// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__72276 = arguments.length;
switch (G__72276) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72321){
var state_val_72322 = (state_72321[(1)]);
if((state_val_72322 === (7))){
var inst_72291 = typeof user === 'string';
var state_72321__$1 = state_72321;
if(cljs.core.truth_(inst_72291)){
var statearr_72323_72352 = state_72321__$1;
(statearr_72323_72352[(1)] = (9));

} else {
var statearr_72324_72353 = state_72321__$1;
(statearr_72324_72353[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72322 === (1))){
var state_72321__$1 = state_72321;
var statearr_72325_72354 = state_72321__$1;
(statearr_72325_72354[(2)] = null);

(statearr_72325_72354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72322 === (4))){
var inst_72277 = (state_72321[(2)]);
var inst_72278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72279 = [inst_72277];
var inst_72280 = (new cljs.core.PersistentVector(null,1,(5),inst_72278,inst_72279,null));
var inst_72281 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72280);
var inst_72282 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_72277) : reject.call(null,inst_72277));
var state_72321__$1 = (function (){var statearr_72326 = state_72321;
(statearr_72326[(7)] = inst_72281);

return statearr_72326;
})();
var statearr_72327_72355 = state_72321__$1;
(statearr_72327_72355[(2)] = inst_72282);

(statearr_72327_72355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72322 === (15))){
var inst_72310 = (state_72321[(2)]);
var inst_72311 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_72310);
var inst_72312 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72313 = cljs.core.constantly(inst_72311);
var inst_72314 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72312,inst_72313);
var inst_72315 = fluree.db.connection.add_token(conn,inst_72311);
var inst_72316 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_72310) : resolve.call(null,inst_72310));
var _ = (function (){var statearr_72328 = state_72321;
(statearr_72328[(4)] = cljs.core.rest((state_72321[(4)])));

return statearr_72328;
})();
var state_72321__$1 = (function (){var statearr_72329 = state_72321;
(statearr_72329[(8)] = inst_72314);

(statearr_72329[(9)] = inst_72315);

return statearr_72329;
})();
var statearr_72330_72356 = state_72321__$1;
(statearr_72330_72356[(2)] = inst_72316);

(statearr_72330_72356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72322 === (13))){
var state_72321__$1 = state_72321;
var statearr_72331_72357 = state_72321__$1;
(statearr_72331_72357[(2)] = null);

(statearr_72331_72357[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72322 === (6))){
var state_72321__$1 = state_72321;
var statearr_72332_72358 = state_72321__$1;
(statearr_72332_72358[(2)] = user);

(statearr_72332_72358[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72322 === (3))){
var inst_72319 = (state_72321[(2)]);
var state_72321__$1 = state_72321;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72321__$1,inst_72319);
} else {
if((state_val_72322 === (12))){
var state_72321__$1 = state_72321;
var statearr_72333_72359 = state_72321__$1;
(statearr_72333_72359[(2)] = user);

(statearr_72333_72359[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72322 === (2))){
var _ = (function (){var statearr_72334 = state_72321;
(statearr_72334[(4)] = cljs.core.cons((5),(state_72321[(4)])));

return statearr_72334;
})();
var inst_72288 = typeof user === 'number';
var state_72321__$1 = state_72321;
if(cljs.core.truth_(inst_72288)){
var statearr_72335_72360 = state_72321__$1;
(statearr_72335_72360[(1)] = (6));

} else {
var statearr_72336_72361 = state_72321__$1;
(statearr_72336_72361[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72322 === (11))){
var inst_72302 = (state_72321[(2)]);
var state_72321__$1 = state_72321;
var statearr_72338_72362 = state_72321__$1;
(statearr_72338_72362[(2)] = inst_72302);

(statearr_72338_72362[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72322 === (9))){
var inst_72293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72294 = ["_user/username",user];
var inst_72295 = (new cljs.core.PersistentVector(null,2,(5),inst_72293,inst_72294,null));
var state_72321__$1 = state_72321;
var statearr_72339_72363 = state_72321__$1;
(statearr_72339_72363[(2)] = inst_72295);

(statearr_72339_72363[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72322 === (5))){
var _ = (function (){var statearr_72340 = state_72321;
(statearr_72340[(4)] = cljs.core.rest((state_72321[(4)])));

return statearr_72340;
})();
var state_72321__$1 = state_72321;
var ex72337 = (state_72321__$1[(2)]);
var statearr_72341_72364 = state_72321__$1;
(statearr_72341_72364[(5)] = ex72337);


var statearr_72342_72365 = state_72321__$1;
(statearr_72342_72365[(1)] = (4));

(statearr_72342_72365[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72322 === (14))){
var inst_72300 = (state_72321[(2)]);
var state_72321__$1 = state_72321;
var statearr_72343_72366 = state_72321__$1;
(statearr_72343_72366[(2)] = inst_72300);

(statearr_72343_72366[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72322 === (10))){
var state_72321__$1 = state_72321;
var statearr_72344_72367 = state_72321__$1;
(statearr_72344_72367[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72322 === (8))){
var inst_72304 = (state_72321[(2)]);
var inst_72305 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_72306 = [account,inst_72304,password,expireSeconds,syncTo];
var inst_72307 = cljs.core.PersistentHashMap.fromArrays(inst_72305,inst_72306);
var inst_72308 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_72307);
var state_72321__$1 = state_72321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72321__$1,(15),inst_72308);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72346 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72346[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72346[(1)] = (1));

return statearr_72346;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72321){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72321);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72347){var ex__2730__auto__ = e72347;
var statearr_72348_72368 = state_72321;
(statearr_72348_72368[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72321[(4)]))){
var statearr_72349_72369 = state_72321;
(statearr_72349_72369[(1)] = cljs.core.first((state_72321[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72370 = state_72321;
state_72321 = G__72370;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72321){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72350 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72350[(6)] = c__2749__auto__);

return statearr_72350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__72372 = arguments.length;
switch (G__72372) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72381){
var state_val_72382 = (state_72381[(1)]);
if((state_val_72382 === (1))){
var inst_72373 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72374 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72375 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_72376 = (new cljs.core.PersistentVector(null,4,(5),inst_72374,inst_72375,null));
var inst_72377 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72373,inst_72376);
var inst_72378 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__72383 = cljs.core.seq(cljs.core.keys(x));
var chunk__72384 = null;
var count__72385 = (0);
var i__72386 = (0);
while(true){
if((i__72386 < count__72385)){
var k = chunk__72384.cljs$core$IIndexed$_nth$arity$2(null,i__72386);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__72394 = seq__72383;
var G__72395 = chunk__72384;
var G__72396 = count__72385;
var G__72397 = (i__72386 + (1));
seq__72383 = G__72394;
chunk__72384 = G__72395;
count__72385 = G__72396;
i__72386 = G__72397;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__72383);
if(temp__5804__auto__){
var seq__72383__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__72383__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__72383__$1);
var G__72398 = cljs.core.chunk_rest(seq__72383__$1);
var G__72399 = c__4679__auto__;
var G__72400 = cljs.core.count(c__4679__auto__);
var G__72401 = (0);
seq__72383 = G__72398;
chunk__72384 = G__72399;
count__72385 = G__72400;
i__72386 = G__72401;
continue;
} else {
var k = cljs.core.first(seq__72383__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__72402 = cljs.core.next(seq__72383__$1);
var G__72403 = null;
var G__72404 = (0);
var G__72405 = (0);
seq__72383 = G__72402;
chunk__72384 = G__72403;
count__72385 = G__72404;
i__72386 = G__72405;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_72379 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_72378);
var state_72381__$1 = (function (){var statearr_72387 = state_72381;
(statearr_72387[(7)] = inst_72377);

return statearr_72387;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_72381__$1,inst_72379);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72388 = [null,null,null,null,null,null,null,null];
(statearr_72388[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72388[(1)] = (1));

return statearr_72388;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72381){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72381);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72389){var ex__2730__auto__ = e72389;
var statearr_72390_72406 = state_72381;
(statearr_72390_72406[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72381[(4)]))){
var statearr_72391_72407 = state_72381;
(statearr_72391_72407[(1)] = cljs.core.first((state_72381[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72408 = state_72381;
state_72381 = G__72408;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72381){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72392 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72392[(6)] = c__2749__auto__);

return statearr_72392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__72410 = arguments.length;
switch (G__72410) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72447){
var state_val_72448 = (state_72447[(1)]);
if((state_val_72448 === (1))){
var state_72447__$1 = state_72447;
var statearr_72449_72470 = state_72447__$1;
(statearr_72449_72470[(2)] = null);

(statearr_72449_72470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72448 === (2))){
var _ = (function (){var statearr_72450 = state_72447;
(statearr_72450[(4)] = cljs.core.cons((5),(state_72447[(4)])));

return statearr_72450;
})();
var inst_72422 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_72423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72424 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_72425 = (new cljs.core.PersistentVector(null,1,(5),inst_72423,inst_72424,null));
var inst_72426 = cljs.core.PersistentHashMap.EMPTY;
var inst_72427 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_72426);
var inst_72428 = cljs.core.assoc_in(inst_72422,inst_72425,inst_72427);
var inst_72429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72430 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_72431 = (new cljs.core.PersistentVector(null,1,(5),inst_72429,inst_72430,null));
var inst_72432 = cljs.core.PersistentHashMap.EMPTY;
var inst_72433 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_72432);
var inst_72434 = cljs.core.assoc_in(inst_72428,inst_72431,inst_72433);
var inst_72435 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_72436 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_72434);
var inst_72437 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72438 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_72435,null];
var inst_72439 = (new cljs.core.PersistentVector(null,4,(5),inst_72437,inst_72438,null));
var inst_72440 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72436,inst_72439);
var inst_72441 = (function (){var conn = inst_72434;
var pc = inst_72435;
return (function (x){
if((x == null)){
} else {
var seq__72451_72471 = cljs.core.seq(cljs.core.keys(x));
var chunk__72452_72472 = null;
var count__72453_72473 = (0);
var i__72454_72474 = (0);
while(true){
if((i__72454_72474 < count__72453_72473)){
var k_72475 = chunk__72452_72472.cljs$core$IIndexed$_nth$arity$2(null,i__72454_72474);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_72475], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_72475,null));


var G__72476 = seq__72451_72471;
var G__72477 = chunk__72452_72472;
var G__72478 = count__72453_72473;
var G__72479 = (i__72454_72474 + (1));
seq__72451_72471 = G__72476;
chunk__72452_72472 = G__72477;
count__72453_72473 = G__72478;
i__72454_72474 = G__72479;
continue;
} else {
var temp__5804__auto___72480 = cljs.core.seq(seq__72451_72471);
if(temp__5804__auto___72480){
var seq__72451_72481__$1 = temp__5804__auto___72480;
if(cljs.core.chunked_seq_QMARK_(seq__72451_72481__$1)){
var c__4679__auto___72482 = cljs.core.chunk_first(seq__72451_72481__$1);
var G__72483 = cljs.core.chunk_rest(seq__72451_72481__$1);
var G__72484 = c__4679__auto___72482;
var G__72485 = cljs.core.count(c__4679__auto___72482);
var G__72486 = (0);
seq__72451_72471 = G__72483;
chunk__72452_72472 = G__72484;
count__72453_72473 = G__72485;
i__72454_72474 = G__72486;
continue;
} else {
var k_72487 = cljs.core.first(seq__72451_72481__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_72487], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_72487,null));


var G__72488 = cljs.core.next(seq__72451_72481__$1);
var G__72489 = null;
var G__72490 = (0);
var G__72491 = (0);
seq__72451_72471 = G__72488;
chunk__72452_72472 = G__72489;
count__72453_72473 = G__72490;
i__72454_72474 = G__72491;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_72442 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72435,inst_72441);
var ___$1 = (function (){var statearr_72455 = state_72447;
(statearr_72455[(4)] = cljs.core.rest((state_72447[(4)])));

return statearr_72455;
})();
var state_72447__$1 = (function (){var statearr_72456 = state_72447;
(statearr_72456[(7)] = inst_72440);

return statearr_72456;
})();
var statearr_72457_72492 = state_72447__$1;
(statearr_72457_72492[(2)] = inst_72442);

(statearr_72457_72492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72448 === (3))){
var inst_72445 = (state_72447[(2)]);
var state_72447__$1 = state_72447;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72447__$1,inst_72445);
} else {
if((state_val_72448 === (4))){
var inst_72411 = (state_72447[(2)]);
var inst_72412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72413 = [inst_72411];
var inst_72414 = (new cljs.core.PersistentVector(null,1,(5),inst_72412,inst_72413,null));
var inst_72415 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72414);
var inst_72416 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_72411) : reject.call(null,inst_72411));
var state_72447__$1 = (function (){var statearr_72459 = state_72447;
(statearr_72459[(8)] = inst_72415);

return statearr_72459;
})();
var statearr_72460_72493 = state_72447__$1;
(statearr_72460_72493[(2)] = inst_72416);

(statearr_72460_72493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72448 === (5))){
var _ = (function (){var statearr_72461 = state_72447;
(statearr_72461[(4)] = cljs.core.rest((state_72447[(4)])));

return statearr_72461;
})();
var state_72447__$1 = state_72447;
var ex72458 = (state_72447__$1[(2)]);
var statearr_72462_72494 = state_72447__$1;
(statearr_72462_72494[(5)] = ex72458);


var statearr_72463_72495 = state_72447__$1;
(statearr_72463_72495[(1)] = (4));

(statearr_72463_72495[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72464 = [null,null,null,null,null,null,null,null,null];
(statearr_72464[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72464[(1)] = (1));

return statearr_72464;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72447){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72447);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72465){var ex__2730__auto__ = e72465;
var statearr_72466_72496 = state_72447;
(statearr_72466_72496[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72447[(4)]))){
var statearr_72467_72497 = state_72447;
(statearr_72467_72497[(1)] = cljs.core.first((state_72447[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72498 = state_72447;
state_72447 = G__72498;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72447){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72468 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72468[(6)] = c__2749__auto__);

return statearr_72468;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__72500 = arguments.length;
switch (G__72500) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__72502 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72502,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72502,(1),null);
var cb_STAR_ = (function (header,data){
var G__72505 = cljs.core.clj__GT_js(header);
var G__72506 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__72505,G__72506) : callback.call(null,G__72505,G__72506));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__72507 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72507,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72507,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72560){
var state_val_72561 = (state_72560[(1)]);
if((state_val_72561 === (7))){
var inst_72521 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72522 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72523 = cljs.core.PersistentHashMap.fromArrays(inst_72521,inst_72522);
var inst_72524 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_72523);
var inst_72525 = (function(){throw inst_72524})();
var state_72560__$1 = state_72560;
var statearr_72562_72594 = state_72560__$1;
(statearr_72562_72594[(2)] = inst_72525);

(statearr_72562_72594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72561 === (1))){
var state_72560__$1 = state_72560;
var statearr_72563_72595 = state_72560__$1;
(statearr_72563_72595[(2)] = null);

(statearr_72563_72595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72561 === (4))){
var inst_72510 = (state_72560[(2)]);
var inst_72511 = cljs.core.clj__GT_js(inst_72510);
var inst_72512 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_72511) : reject.call(null,inst_72511));
var state_72560__$1 = state_72560;
var statearr_72564_72596 = state_72560__$1;
(statearr_72564_72596[(2)] = inst_72512);

(statearr_72564_72596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72561 === (13))){
var inst_72539 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72540 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72541 = cljs.core.PersistentHashMap.fromArrays(inst_72539,inst_72540);
var inst_72542 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_72541);
var inst_72543 = (function(){throw inst_72542})();
var state_72560__$1 = state_72560;
var statearr_72565_72597 = state_72560__$1;
(statearr_72565_72597[(2)] = inst_72543);

(statearr_72565_72597[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72561 === (6))){
var state_72560__$1 = state_72560;
var statearr_72566_72598 = state_72560__$1;
(statearr_72566_72598[(2)] = null);

(statearr_72566_72598[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72561 === (3))){
var inst_72558 = (state_72560[(2)]);
var state_72560__$1 = state_72560;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72560__$1,inst_72558);
} else {
if((state_val_72561 === (12))){
var state_72560__$1 = state_72560;
var statearr_72567_72599 = state_72560__$1;
(statearr_72567_72599[(2)] = null);

(statearr_72567_72599[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72561 === (2))){
var _ = (function (){var statearr_72568 = state_72560;
(statearr_72568[(4)] = cljs.core.cons((5),(state_72560[(4)])));

return statearr_72568;
})();
var inst_72518 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_72560__$1 = state_72560;
if(cljs.core.truth_(inst_72518)){
var statearr_72569_72600 = state_72560__$1;
(statearr_72569_72600[(1)] = (6));

} else {
var statearr_72570_72601 = state_72560__$1;
(statearr_72570_72601[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72561 === (11))){
var inst_72536 = (state_72560[(2)]);
var state_72560__$1 = (function (){var statearr_72572 = state_72560;
(statearr_72572[(7)] = inst_72536);

return statearr_72572;
})();
if(cljs.core.truth_(password)){
var statearr_72573_72602 = state_72560__$1;
(statearr_72573_72602[(1)] = (12));

} else {
var statearr_72574_72603 = state_72560__$1;
(statearr_72574_72603[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72561 === (9))){
var state_72560__$1 = state_72560;
var statearr_72575_72604 = state_72560__$1;
(statearr_72575_72604[(2)] = null);

(statearr_72575_72604[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72561 === (5))){
var _ = (function (){var statearr_72576 = state_72560;
(statearr_72576[(4)] = cljs.core.rest((state_72560[(4)])));

return statearr_72576;
})();
var state_72560__$1 = state_72560;
var ex72571 = (state_72560__$1[(2)]);
var statearr_72577_72605 = state_72560__$1;
(statearr_72577_72605[(5)] = ex72571);


var statearr_72578_72606 = state_72560__$1;
(statearr_72578_72606[(1)] = (4));

(statearr_72578_72606[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72561 === (14))){
var inst_72545 = (state_72560[(2)]);
var inst_72546 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_72547 = fluree.db.util.core.without_nils(inst_72546);
var inst_72548 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_72549 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72551 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_72547,inst_72548,null];
var inst_72552 = (new cljs.core.PersistentVector(null,4,(5),inst_72550,inst_72551,null));
var inst_72553 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72549,inst_72552);
var inst_72554 = (function (){var _ = inst_72545;
var data = inst_72547;
var pc = inst_72548;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__72579 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__72579) : reject.call(null,G__72579));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__72580 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__72580) : reject.call(null,G__72580));
} else {
var G__72581 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__72581) : resolve.call(null,G__72581));

}
}
});
})();
var inst_72555 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72548,inst_72554);
var _ = (function (){var statearr_72582 = state_72560;
(statearr_72582[(4)] = cljs.core.rest((state_72560[(4)])));

return statearr_72582;
})();
var state_72560__$1 = (function (){var statearr_72583 = state_72560;
(statearr_72583[(8)] = inst_72553);

return statearr_72583;
})();
var statearr_72584_72607 = state_72560__$1;
(statearr_72584_72607[(2)] = inst_72555);

(statearr_72584_72607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72561 === (10))){
var inst_72530 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72531 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72532 = cljs.core.PersistentHashMap.fromArrays(inst_72530,inst_72531);
var inst_72533 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_72532);
var inst_72534 = (function(){throw inst_72533})();
var state_72560__$1 = state_72560;
var statearr_72585_72608 = state_72560__$1;
(statearr_72585_72608[(2)] = inst_72534);

(statearr_72585_72608[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72561 === (8))){
var inst_72527 = (state_72560[(2)]);
var state_72560__$1 = (function (){var statearr_72586 = state_72560;
(statearr_72586[(9)] = inst_72527);

return statearr_72586;
})();
if(cljs.core.truth_(ledger)){
var statearr_72587_72609 = state_72560__$1;
(statearr_72587_72609[(1)] = (9));

} else {
var statearr_72588_72610 = state_72560__$1;
(statearr_72588_72610[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0 = (function (){
var statearr_72589 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72589[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2727__auto__);

(statearr_72589[(1)] = (1));

return statearr_72589;
});
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1 = (function (state_72560){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72560);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72590){var ex__2730__auto__ = e72590;
var statearr_72591_72611 = state_72560;
(statearr_72591_72611[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72560[(4)]))){
var statearr_72592_72612 = state_72560;
(statearr_72592_72612[(1)] = cljs.core.first((state_72560[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72613 = state_72560;
state_72560 = G__72613;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = function(state_72560){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1.call(this,state_72560);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72593 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72593[(6)] = c__2749__auto__);

return statearr_72593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__72615 = arguments.length;
switch (G__72615) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72682){
var state_val_72683 = (state_72682[(1)]);
if((state_val_72683 === (7))){
var inst_72627 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72628 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72629 = cljs.core.PersistentHashMap.fromArrays(inst_72627,inst_72628);
var inst_72630 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_72629);
var inst_72631 = (function(){throw inst_72630})();
var state_72682__$1 = state_72682;
var statearr_72684_72726 = state_72682__$1;
(statearr_72684_72726[(2)] = inst_72631);

(statearr_72684_72726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (20))){
var inst_72665 = (state_72682[(2)]);
var inst_72666 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_72667 = [ledger,password,user,auth,expire];
var inst_72668 = cljs.core.PersistentHashMap.fromArrays(inst_72666,inst_72667);
var inst_72669 = fluree.db.util.core.without_nils(inst_72668);
var inst_72670 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_72671 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72672 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72673 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_72669,inst_72670,null];
var inst_72674 = (new cljs.core.PersistentVector(null,4,(5),inst_72672,inst_72673,null));
var inst_72675 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72671,inst_72674);
var inst_72676 = (function (){var _ = inst_72665;
var data = inst_72669;
var pc = inst_72670;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__72685 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__72685) : reject.call(null,G__72685));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__72686 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__72686) : reject.call(null,G__72686));
} else {
fluree.db.connection.add_token(conn,result);

var G__72687 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__72687) : resolve.call(null,G__72687));

}
}
});
})();
var inst_72677 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72670,inst_72676);
var _ = (function (){var statearr_72688 = state_72682;
(statearr_72688[(4)] = cljs.core.rest((state_72682[(4)])));

return statearr_72688;
})();
var state_72682__$1 = (function (){var statearr_72689 = state_72682;
(statearr_72689[(7)] = inst_72675);

return statearr_72689;
})();
var statearr_72690_72727 = state_72682__$1;
(statearr_72690_72727[(2)] = inst_72677);

(statearr_72690_72727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (1))){
var state_72682__$1 = state_72682;
var statearr_72691_72728 = state_72682__$1;
(statearr_72691_72728[(2)] = null);

(statearr_72691_72728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (4))){
var inst_72616 = (state_72682[(2)]);
var inst_72617 = cljs.core.clj__GT_js(inst_72616);
var inst_72618 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_72617) : reject.call(null,inst_72617));
var state_72682__$1 = state_72682;
var statearr_72692_72729 = state_72682__$1;
(statearr_72692_72729[(2)] = inst_72618);

(statearr_72692_72729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (15))){
var inst_72652 = (state_72682[(8)]);
var state_72682__$1 = state_72682;
var statearr_72693_72730 = state_72682__$1;
(statearr_72693_72730[(2)] = inst_72652);

(statearr_72693_72730[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (13))){
var inst_72645 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72646 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72647 = cljs.core.PersistentHashMap.fromArrays(inst_72645,inst_72646);
var inst_72648 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_72647);
var inst_72649 = (function(){throw inst_72648})();
var state_72682__$1 = state_72682;
var statearr_72694_72731 = state_72682__$1;
(statearr_72694_72731[(2)] = inst_72649);

(statearr_72694_72731[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (6))){
var state_72682__$1 = state_72682;
var statearr_72695_72732 = state_72682__$1;
(statearr_72695_72732[(2)] = null);

(statearr_72695_72732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (17))){
var inst_72656 = (state_72682[(2)]);
var state_72682__$1 = state_72682;
if(cljs.core.truth_(inst_72656)){
var statearr_72696_72733 = state_72682__$1;
(statearr_72696_72733[(1)] = (18));

} else {
var statearr_72697_72734 = state_72682__$1;
(statearr_72697_72734[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (3))){
var inst_72680 = (state_72682[(2)]);
var state_72682__$1 = state_72682;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72682__$1,inst_72680);
} else {
if((state_val_72683 === (12))){
var state_72682__$1 = state_72682;
var statearr_72698_72735 = state_72682__$1;
(statearr_72698_72735[(2)] = null);

(statearr_72698_72735[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (2))){
var _ = (function (){var statearr_72699 = state_72682;
(statearr_72699[(4)] = cljs.core.cons((5),(state_72682[(4)])));

return statearr_72699;
})();
var inst_72624 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_72682__$1 = state_72682;
if(cljs.core.truth_(inst_72624)){
var statearr_72700_72736 = state_72682__$1;
(statearr_72700_72736[(1)] = (6));

} else {
var statearr_72701_72737 = state_72682__$1;
(statearr_72701_72737[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (19))){
var inst_72659 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72660 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72661 = cljs.core.PersistentHashMap.fromArrays(inst_72659,inst_72660);
var inst_72662 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_72661);
var inst_72663 = (function(){throw inst_72662})();
var state_72682__$1 = state_72682;
var statearr_72702_72738 = state_72682__$1;
(statearr_72702_72738[(2)] = inst_72663);

(statearr_72702_72738[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (11))){
var inst_72642 = (state_72682[(2)]);
var state_72682__$1 = (function (){var statearr_72704 = state_72682;
(statearr_72704[(9)] = inst_72642);

return statearr_72704;
})();
if(cljs.core.truth_(password)){
var statearr_72705_72739 = state_72682__$1;
(statearr_72705_72739[(1)] = (12));

} else {
var statearr_72706_72740 = state_72682__$1;
(statearr_72706_72740[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (9))){
var state_72682__$1 = state_72682;
var statearr_72707_72741 = state_72682__$1;
(statearr_72707_72741[(2)] = null);

(statearr_72707_72741[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (5))){
var _ = (function (){var statearr_72708 = state_72682;
(statearr_72708[(4)] = cljs.core.rest((state_72682[(4)])));

return statearr_72708;
})();
var state_72682__$1 = state_72682;
var ex72703 = (state_72682__$1[(2)]);
var statearr_72709_72742 = state_72682__$1;
(statearr_72709_72742[(5)] = ex72703);


var statearr_72710_72743 = state_72682__$1;
(statearr_72710_72743[(1)] = (4));

(statearr_72710_72743[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (14))){
var inst_72652 = (state_72682[(8)]);
var inst_72651 = (state_72682[(2)]);
var inst_72652__$1 = user;
var state_72682__$1 = (function (){var statearr_72711 = state_72682;
(statearr_72711[(8)] = inst_72652__$1);

(statearr_72711[(10)] = inst_72651);

return statearr_72711;
})();
if(cljs.core.truth_(inst_72652__$1)){
var statearr_72712_72744 = state_72682__$1;
(statearr_72712_72744[(1)] = (15));

} else {
var statearr_72713_72745 = state_72682__$1;
(statearr_72713_72745[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (16))){
var state_72682__$1 = state_72682;
var statearr_72714_72746 = state_72682__$1;
(statearr_72714_72746[(2)] = auth);

(statearr_72714_72746[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (10))){
var inst_72636 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72637 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72638 = cljs.core.PersistentHashMap.fromArrays(inst_72636,inst_72637);
var inst_72639 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_72638);
var inst_72640 = (function(){throw inst_72639})();
var state_72682__$1 = state_72682;
var statearr_72715_72747 = state_72682__$1;
(statearr_72715_72747[(2)] = inst_72640);

(statearr_72715_72747[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (18))){
var state_72682__$1 = state_72682;
var statearr_72716_72748 = state_72682__$1;
(statearr_72716_72748[(2)] = null);

(statearr_72716_72748[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72683 === (8))){
var inst_72633 = (state_72682[(2)]);
var state_72682__$1 = (function (){var statearr_72717 = state_72682;
(statearr_72717[(11)] = inst_72633);

return statearr_72717;
})();
if(cljs.core.truth_(ledger)){
var statearr_72718_72749 = state_72682__$1;
(statearr_72718_72749[(1)] = (9));

} else {
var statearr_72719_72750 = state_72682__$1;
(statearr_72719_72750[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72720 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72720[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72720[(1)] = (1));

return statearr_72720;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72682){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72682);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72721){var ex__2730__auto__ = e72721;
var statearr_72722_72751 = state_72682;
(statearr_72722_72751[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72682[(4)]))){
var statearr_72723_72752 = state_72682;
(statearr_72723_72752[(1)] = cljs.core.first((state_72682[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72753 = state_72682;
state_72682 = G__72753;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72682){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72724 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72724[(6)] = c__2749__auto__);

return statearr_72724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__72755 = arguments.length;
switch (G__72755) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72790){
var state_val_72791 = (state_72790[(1)]);
if((state_val_72791 === (1))){
var state_72790__$1 = state_72790;
var statearr_72792_72814 = state_72790__$1;
(statearr_72792_72814[(2)] = null);

(statearr_72792_72814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72791 === (2))){
var _ = (function (){var statearr_72793 = state_72790;
(statearr_72793[(4)] = cljs.core.cons((5),(state_72790[(4)])));

return statearr_72793;
})();
var inst_72764 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_72790__$1 = state_72790;
if(cljs.core.truth_(inst_72764)){
var statearr_72794_72815 = state_72790__$1;
(statearr_72794_72815[(1)] = (6));

} else {
var statearr_72795_72816 = state_72790__$1;
(statearr_72795_72816[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72791 === (3))){
var inst_72788 = (state_72790[(2)]);
var state_72790__$1 = state_72790;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72790__$1,inst_72788);
} else {
if((state_val_72791 === (4))){
var inst_72756 = (state_72790[(2)]);
var inst_72757 = cljs.core.clj__GT_js(inst_72756);
var inst_72758 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_72757) : reject.call(null,inst_72757));
var state_72790__$1 = state_72790;
var statearr_72797_72817 = state_72790__$1;
(statearr_72797_72817[(2)] = inst_72758);

(statearr_72797_72817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72791 === (5))){
var _ = (function (){var statearr_72798 = state_72790;
(statearr_72798[(4)] = cljs.core.rest((state_72790[(4)])));

return statearr_72798;
})();
var state_72790__$1 = state_72790;
var ex72796 = (state_72790__$1[(2)]);
var statearr_72799_72818 = state_72790__$1;
(statearr_72799_72818[(5)] = ex72796);


var statearr_72800_72819 = state_72790__$1;
(statearr_72800_72819[(1)] = (4));

(statearr_72800_72819[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72791 === (6))){
var state_72790__$1 = state_72790;
var statearr_72801_72820 = state_72790__$1;
(statearr_72801_72820[(2)] = null);

(statearr_72801_72820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72791 === (7))){
var inst_72767 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72768 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72769 = cljs.core.PersistentHashMap.fromArrays(inst_72767,inst_72768);
var inst_72770 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_72769);
var inst_72771 = (function(){throw inst_72770})();
var state_72790__$1 = state_72790;
var statearr_72802_72821 = state_72790__$1;
(statearr_72802_72821[(2)] = inst_72771);

(statearr_72802_72821[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72791 === (8))){
var inst_72773 = (state_72790[(2)]);
var inst_72774 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_72775 = [jwt,expire];
var inst_72776 = cljs.core.PersistentHashMap.fromArrays(inst_72774,inst_72775);
var inst_72777 = fluree.db.util.core.without_nils(inst_72776);
var inst_72778 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_72779 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72781 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_72777,inst_72778,null];
var inst_72782 = (new cljs.core.PersistentVector(null,4,(5),inst_72780,inst_72781,null));
var inst_72783 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72779,inst_72782);
var inst_72784 = (function (){var _ = inst_72773;
var data = inst_72777;
var pc = inst_72778;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__72803 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__72803) : reject.call(null,G__72803));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__72804 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__72804) : resolve.call(null,G__72804));

}
});
})();
var inst_72785 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72778,inst_72784);
var _ = (function (){var statearr_72805 = state_72790;
(statearr_72805[(4)] = cljs.core.rest((state_72790[(4)])));

return statearr_72805;
})();
var state_72790__$1 = (function (){var statearr_72806 = state_72790;
(statearr_72806[(7)] = inst_72783);

return statearr_72806;
})();
var statearr_72807_72822 = state_72790__$1;
(statearr_72807_72822[(2)] = inst_72785);

(statearr_72807_72822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72808 = [null,null,null,null,null,null,null,null];
(statearr_72808[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72808[(1)] = (1));

return statearr_72808;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72790){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72790);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72809){var ex__2730__auto__ = e72809;
var statearr_72810_72823 = state_72790;
(statearr_72810_72823[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72790[(4)]))){
var statearr_72811_72824 = state_72790;
(statearr_72811_72824[(1)] = cljs.core.first((state_72790[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72825 = state_72790;
state_72790 = G__72825;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72790){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72790);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72812 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72812[(6)] = c__2749__auto__);

return statearr_72812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

