// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-ledger-id] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__25105 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25105,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25105,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25105,(2),null);
if(cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
/**
 * Predicates to exclude from the database
 */
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(130),(106)]);
fluree.db.graphdb.exclude_flake_QMARK_ = (function fluree$db$graphdb$exclude_flake_QMARK_(f){
return cljs.core.contains_QMARK_(fluree.db.graphdb.exclude_predicates,fluree.db.flake.p(f));
});
fluree.db.graphdb.include_flake_QMARK_ = cljs.core.complement(fluree.db.graphdb.exclude_flake_QMARK_);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__25108){
var map__25109 = p__25108;
var map__25109__$1 = cljs.core.__destructure_map(map__25109);
var opts = map__25109__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25109__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25169){
var state_val_25170 = (state_25169[(1)]);
if((state_val_25170 === (7))){
var inst_25140 = cljs.core.not(reindex_QMARK_);
var state_25169__$1 = state_25169;
var statearr_25171_25195 = state_25169__$1;
(statearr_25171_25195[(2)] = inst_25140);

(statearr_25171_25195[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25170 === (1))){
var state_25169__$1 = state_25169;
var statearr_25172_25196 = state_25169__$1;
(statearr_25172_25196[(2)] = null);

(statearr_25172_25196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25170 === (4))){
var inst_25110 = (state_25169[(2)]);
var state_25169__$1 = state_25169;
var statearr_25173_25197 = state_25169__$1;
(statearr_25173_25197[(2)] = inst_25110);

(statearr_25173_25197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25170 === (6))){
var inst_25124 = (state_25169[(7)]);
var inst_25138 = (state_25169[(8)]);
var inst_25130 = (state_25169[(9)]);
var inst_25123 = (state_25169[(2)]);
var inst_25124__$1 = fluree.db.util.async.throw_err(inst_25123);
var inst_25125 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_25126 = cljs.core.__destructure_map(inst_25125);
var inst_25127 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25126,new cljs.core.Keyword(null,"post","post",269697687));
var inst_25128 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25126,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_25129 = fluree.db.flake.size_bytes(inst_25124__$1);
var inst_25130__$1 = (inst_25128 + inst_25129);
var inst_25131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25132 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_25133 = (new cljs.core.PersistentVector(null,2,(5),inst_25131,inst_25132,null));
var inst_25134 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_25133);
var inst_25135 = cljs.core.__destructure_map(inst_25134);
var inst_25136 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25135,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_25137 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25135,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_25138__$1 = (inst_25130__$1 > inst_25137);
var state_25169__$1 = (function (){var statearr_25174 = state_25169;
(statearr_25174[(10)] = inst_25127);

(statearr_25174[(7)] = inst_25124__$1);

(statearr_25174[(8)] = inst_25138__$1);

(statearr_25174[(9)] = inst_25130__$1);

(statearr_25174[(11)] = inst_25136);

return statearr_25174;
})();
if(cljs.core.truth_(inst_25138__$1)){
var statearr_25175_25198 = state_25169__$1;
(statearr_25175_25198[(1)] = (7));

} else {
var statearr_25176_25199 = state_25169__$1;
(statearr_25176_25199[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25170 === (3))){
var inst_25167 = (state_25169[(2)]);
var state_25169__$1 = state_25169;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25169__$1,inst_25167);
} else {
if((state_val_25170 === (12))){
var inst_25127 = (state_25169[(10)]);
var inst_25124 = (state_25169[(7)]);
var inst_25130 = (state_25169[(9)]);
var inst_25153 = (state_25169[(2)]);
var inst_25154 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25127,inst_25124);
var inst_25155 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_25156 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_25155,cljs.core.empty);
var inst_25157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25158 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25159 = (new cljs.core.PersistentVector(null,2,(5),inst_25157,inst_25158,null));
var inst_25160 = cljs.core.assoc_in(db,inst_25159,inst_25154);
var inst_25161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25162 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25163 = (new cljs.core.PersistentVector(null,2,(5),inst_25161,inst_25162,null));
var inst_25164 = cljs.core.assoc_in(inst_25160,inst_25163,inst_25130);
var _ = (function (){var statearr_25177 = state_25169;
(statearr_25177[(4)] = cljs.core.rest((state_25169[(4)])));

return statearr_25177;
})();
var state_25169__$1 = (function (){var statearr_25178 = state_25169;
(statearr_25178[(12)] = inst_25156);

(statearr_25178[(13)] = inst_25153);

return statearr_25178;
})();
var statearr_25179_25200 = state_25169__$1;
(statearr_25179_25200[(2)] = inst_25164);

(statearr_25179_25200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25170 === (2))){
var _ = (function (){var statearr_25180 = state_25169;
(statearr_25180[(4)] = cljs.core.cons((5),(state_25169[(4)])));

return statearr_25180;
})();
var inst_25118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25119 = [pred_id];
var inst_25120 = (new cljs.core.PersistentVector(null,1,(5),inst_25118,inst_25119,null));
var inst_25121 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25120);
var state_25169__$1 = state_25169;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25169__$1,(6),inst_25121);
} else {
if((state_val_25170 === (11))){
var state_25169__$1 = state_25169;
var statearr_25182_25201 = state_25169__$1;
(statearr_25182_25201[(2)] = null);

(statearr_25182_25201[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25170 === (9))){
var inst_25143 = (state_25169[(2)]);
var state_25169__$1 = state_25169;
if(cljs.core.truth_(inst_25143)){
var statearr_25183_25202 = state_25169__$1;
(statearr_25183_25202[(1)] = (10));

} else {
var statearr_25184_25203 = state_25169__$1;
(statearr_25184_25203[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25170 === (5))){
var _ = (function (){var statearr_25185 = state_25169;
(statearr_25185[(4)] = cljs.core.rest((state_25169[(4)])));

return statearr_25185;
})();
var state_25169__$1 = state_25169;
var ex25181 = (state_25169__$1[(2)]);
var statearr_25186_25204 = state_25169__$1;
(statearr_25186_25204[(5)] = ex25181);


if((ex25181 instanceof Error)){
var statearr_25187_25205 = state_25169__$1;
(statearr_25187_25205[(1)] = (4));

(statearr_25187_25205[(5)] = null);

} else {
throw ex25181;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25170 === (10))){
var inst_25145 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_25146 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25147 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_25148 = cljs.core.PersistentHashMap.fromArrays(inst_25146,inst_25147);
var inst_25149 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25145,inst_25148);
var inst_25150 = (function(){throw inst_25149})();
var state_25169__$1 = state_25169;
var statearr_25188_25206 = state_25169__$1;
(statearr_25188_25206[(2)] = inst_25150);

(statearr_25188_25206[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25170 === (8))){
var inst_25138 = (state_25169[(8)]);
var state_25169__$1 = state_25169;
var statearr_25189_25207 = state_25169__$1;
(statearr_25189_25207[(2)] = inst_25138);

(statearr_25189_25207[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0 = (function (){
var statearr_25190 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25190[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__);

(statearr_25190[(1)] = (1));

return statearr_25190;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1 = (function (state_25169){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25169);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25191){var ex__2730__auto__ = e25191;
var statearr_25192_25208 = state_25169;
(statearr_25192_25208[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25169[(4)]))){
var statearr_25193_25209 = state_25169;
(statearr_25193_25209[(1)] = cljs.core.first((state_25169[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25210 = state_25169;
state_25169 = G__25210;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__ = function(state_25169){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1.call(this,state_25169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25194 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25194[(6)] = c__2749__auto__);

return statearr_25194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__25213 = arguments.length;
switch (G__25213) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25413){
var state_val_25414 = (state_25413[(1)]);
if((state_val_25414 === (7))){
var state_25413__$1 = state_25413;
var statearr_25415_25482 = state_25413__$1;
(statearr_25415_25482[(2)] = null);

(statearr_25415_25482[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (20))){
var inst_25333 = (state_25413[(7)]);
var inst_25336 = (state_25413[(8)]);
var inst_25338 = (state_25413[(9)]);
var inst_25300 = (state_25413[(10)]);
var inst_25250 = (state_25413[(11)]);
var inst_25337 = (state_25413[(12)]);
var inst_25334 = (state_25413[(13)]);
var inst_25249 = (state_25413[(14)]);
var inst_25335 = (state_25413[(15)]);
var inst_25348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25349 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25350 = (new cljs.core.PersistentVector(null,2,(5),inst_25348,inst_25349,null));
var inst_25351 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25300,inst_25350);
var inst_25352 = (inst_25351 + inst_25249);
var inst_25353 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25354 = [inst_25333,inst_25334,inst_25335,inst_25336,inst_25337,inst_25352];
var inst_25355 = cljs.core.PersistentHashMap.fromArrays(inst_25353,inst_25354);
var inst_25356 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_25300,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_25338,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_25355], 0));
var state_25413__$1 = (function (){var statearr_25416 = state_25413;
(statearr_25416[(16)] = inst_25356);

return statearr_25416;
})();
if(cljs.core.truth_(inst_25250)){
var statearr_25417_25483 = state_25413__$1;
(statearr_25417_25483[(1)] = (23));

} else {
var statearr_25418_25484 = state_25413__$1;
(statearr_25418_25484[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (27))){
var inst_25356 = (state_25413[(16)]);
var state_25413__$1 = state_25413;
var statearr_25419_25485 = state_25413__$1;
(statearr_25419_25485[(2)] = inst_25356);

(statearr_25419_25485[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (1))){
var state_25413__$1 = state_25413;
var statearr_25420_25486 = state_25413__$1;
(statearr_25420_25486[(2)] = null);

(statearr_25420_25486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (24))){
var inst_25356 = (state_25413[(16)]);
var inst_25360 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_25356);
var inst_25361 = (inst_25360 == null);
var state_25413__$1 = state_25413;
var statearr_25421_25487 = state_25413__$1;
(statearr_25421_25487[(2)] = inst_25361);

(statearr_25421_25487[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (39))){
var inst_25337 = (state_25413[(12)]);
var inst_25344 = (state_25413[(17)]);
var inst_25345 = (state_25413[(18)]);
var inst_25388 = (state_25413[(19)]);
var inst_25395 = (state_25413[(20)]);
var inst_25386 = (state_25413[(21)]);
var inst_25387 = (state_25413[(22)]);
var inst_25402 = (state_25413[(2)]);
var inst_25403 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25337,inst_25344);
var inst_25332 = inst_25345;
var inst_25333 = inst_25387;
var inst_25334 = inst_25388;
var inst_25335 = inst_25395;
var inst_25336 = inst_25402;
var inst_25337__$1 = inst_25403;
var inst_25338 = inst_25386;
var state_25413__$1 = (function (){var statearr_25422 = state_25413;
(statearr_25422[(7)] = inst_25333);

(statearr_25422[(8)] = inst_25336);

(statearr_25422[(9)] = inst_25338);

(statearr_25422[(12)] = inst_25337__$1);

(statearr_25422[(23)] = inst_25332);

(statearr_25422[(13)] = inst_25334);

(statearr_25422[(15)] = inst_25335);

return statearr_25422;
})();
var statearr_25423_25488 = state_25413__$1;
(statearr_25423_25488[(2)] = null);

(statearr_25423_25488[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (4))){
var inst_25214 = (state_25413[(2)]);
var state_25413__$1 = state_25413;
var statearr_25424_25489 = state_25413__$1;
(statearr_25424_25489[(2)] = inst_25214);

(statearr_25424_25489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (15))){
var inst_25272 = (state_25413[(24)]);
var state_25413__$1 = state_25413;
var statearr_25425_25490 = state_25413__$1;
(statearr_25425_25490[(2)] = inst_25272);

(statearr_25425_25490[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (21))){
var inst_25333 = (state_25413[(7)]);
var inst_25259 = (state_25413[(25)]);
var inst_25244 = (state_25413[(26)]);
var inst_25336 = (state_25413[(8)]);
var inst_25338 = (state_25413[(9)]);
var inst_25221 = (state_25413[(27)]);
var inst_25300 = (state_25413[(10)]);
var inst_25236 = (state_25413[(28)]);
var inst_25250 = (state_25413[(11)]);
var inst_25309 = (state_25413[(29)]);
var inst_25337 = (state_25413[(12)]);
var inst_25237 = (state_25413[(30)]);
var inst_25332 = (state_25413[(23)]);
var inst_25344 = (state_25413[(17)]);
var inst_25345 = (state_25413[(18)]);
var inst_25334 = (state_25413[(13)]);
var inst_25310 = (state_25413[(31)]);
var inst_25248 = (state_25413[(32)]);
var inst_25240 = (state_25413[(33)]);
var inst_25251 = (state_25413[(34)]);
var inst_25249 = (state_25413[(14)]);
var inst_25335 = (state_25413[(15)]);
var inst_25253 = (state_25413[(35)]);
var inst_25383 = fluree.db.flake.s(inst_25344);
var inst_25384 = fluree.db.flake.sid__GT_cid(inst_25383);
var inst_25385 = (function (){var flakes_bytes = inst_25249;
var t = inst_25221;
var spot = inst_25333;
var add_flakes = inst_25237;
var root_setting_change_QMARK_ = inst_25251;
var ref_QMARK__map = inst_25248;
var r = inst_25345;
var vec__25305 = inst_25237;
var psot = inst_25334;
var G__25304 = inst_25332;
var add_pred_to_idx_QMARK_ = inst_25259;
var seq__25341 = inst_25345;
var _ = inst_25236;
var first__25307 = inst_25309;
var tspo = inst_25337;
var cid = inst_25384;
var ecount = inst_25338;
var pred_ecount = inst_25253;
var first__25342 = inst_25344;
var db_STAR_ = inst_25300;
var system_change_QMARK_ = inst_25250;
var vec__25340 = inst_25332;
var add_preds = inst_25240;
var opst = inst_25336;
var idx_QMARK__map = inst_25244;
var post = inst_25335;
var seq__25306 = inst_25310;
var f = inst_25344;
return (function (p1__25211_SHARP_){
if(cljs.core.truth_(p1__25211_SHARP_)){
var x__4336__auto__ = p1__25211_SHARP_;
var y__4337__auto__ = fluree.db.flake.s(f);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
} else {
return fluree.db.flake.s(f);
}
});
})();
var inst_25386 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_25338,inst_25384,inst_25385);
var inst_25387 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25333,inst_25344);
var inst_25388 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25334,inst_25344);
var inst_25389 = fluree.db.flake.p(inst_25344);
var inst_25390 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25244,inst_25389);
var state_25413__$1 = (function (){var statearr_25426 = state_25413;
(statearr_25426[(19)] = inst_25388);

(statearr_25426[(21)] = inst_25386);

(statearr_25426[(22)] = inst_25387);

return statearr_25426;
})();
if(cljs.core.truth_(inst_25390)){
var statearr_25427_25491 = state_25413__$1;
(statearr_25427_25491[(1)] = (34));

} else {
var statearr_25428_25492 = state_25413__$1;
(statearr_25428_25492[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (31))){
var inst_25372 = (state_25413[(36)]);
var state_25413__$1 = state_25413;
var statearr_25429_25493 = state_25413__$1;
(statearr_25429_25493[(2)] = inst_25372);

(statearr_25429_25493[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (32))){
var inst_25381 = (state_25413[(2)]);
var state_25413__$1 = state_25413;
var statearr_25430_25494 = state_25413__$1;
(statearr_25430_25494[(2)] = inst_25381);

(statearr_25430_25494[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (33))){
var inst_25372 = (state_25413[(36)]);
var inst_25376 = (state_25413[(2)]);
var inst_25377 = fluree.db.util.async.throw_err(inst_25376);
var inst_25378 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25372,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_25377);
var state_25413__$1 = state_25413;
var statearr_25431_25495 = state_25413__$1;
(statearr_25431_25495[(2)] = inst_25378);

(statearr_25431_25495[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (13))){
var inst_25221 = (state_25413[(27)]);
var inst_25300 = (state_25413[(10)]);
var inst_25237 = (state_25413[(30)]);
var inst_25249 = (state_25413[(14)]);
var inst_25290 = (state_25413[(2)]);
var inst_25291 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25290,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25221);
var inst_25292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25293 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25294 = (new cljs.core.PersistentVector(null,2,(5),inst_25292,inst_25293,null));
var inst_25295 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_25291,inst_25294,cljs.core._PLUS_,inst_25249);
var inst_25296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25297 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_25298 = (new cljs.core.PersistentVector(null,2,(5),inst_25296,inst_25297,null));
var inst_25299 = cljs.core.count(inst_25237);
var inst_25300__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_25295,inst_25298,cljs.core._PLUS_,inst_25299);
var inst_25308 = cljs.core.seq(inst_25237);
var inst_25309 = cljs.core.first(inst_25308);
var inst_25310 = cljs.core.next(inst_25308);
var inst_25311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25312 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_25313 = (new cljs.core.PersistentVector(null,2,(5),inst_25311,inst_25312,null));
var inst_25314 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25300__$1,inst_25313);
var inst_25315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25316 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_25317 = (new cljs.core.PersistentVector(null,2,(5),inst_25315,inst_25316,null));
var inst_25318 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25300__$1,inst_25317);
var inst_25319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25320 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25321 = (new cljs.core.PersistentVector(null,2,(5),inst_25319,inst_25320,null));
var inst_25322 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25300__$1,inst_25321);
var inst_25323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25324 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_25325 = (new cljs.core.PersistentVector(null,2,(5),inst_25323,inst_25324,null));
var inst_25326 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25300__$1,inst_25325);
var inst_25327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25328 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"tspo","tspo",-440144953)];
var inst_25329 = (new cljs.core.PersistentVector(null,2,(5),inst_25327,inst_25328,null));
var inst_25330 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25300__$1,inst_25329);
var inst_25331 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25332 = inst_25237;
var inst_25333 = inst_25314;
var inst_25334 = inst_25318;
var inst_25335 = inst_25322;
var inst_25336 = inst_25326;
var inst_25337 = inst_25330;
var inst_25338 = inst_25331;
var state_25413__$1 = (function (){var statearr_25432 = state_25413;
(statearr_25432[(7)] = inst_25333);

(statearr_25432[(8)] = inst_25336);

(statearr_25432[(9)] = inst_25338);

(statearr_25432[(10)] = inst_25300__$1);

(statearr_25432[(29)] = inst_25309);

(statearr_25432[(12)] = inst_25337);

(statearr_25432[(23)] = inst_25332);

(statearr_25432[(13)] = inst_25334);

(statearr_25432[(31)] = inst_25310);

(statearr_25432[(15)] = inst_25335);

return statearr_25432;
})();
var statearr_25433_25496 = state_25413__$1;
(statearr_25433_25496[(2)] = null);

(statearr_25433_25496[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (22))){
var inst_25406 = (state_25413[(2)]);
var state_25413__$1 = state_25413;
var statearr_25434_25497 = state_25413__$1;
(statearr_25434_25497[(2)] = inst_25406);

(statearr_25434_25497[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (36))){
var inst_25344 = (state_25413[(17)]);
var inst_25248 = (state_25413[(32)]);
var inst_25395 = (state_25413[(2)]);
var inst_25396 = fluree.db.flake.p(inst_25344);
var inst_25397 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25248,inst_25396);
var state_25413__$1 = (function (){var statearr_25435 = state_25413;
(statearr_25435[(20)] = inst_25395);

return statearr_25435;
})();
if(cljs.core.truth_(inst_25397)){
var statearr_25436_25498 = state_25413__$1;
(statearr_25436_25498[(1)] = (37));

} else {
var statearr_25437_25499 = state_25413__$1;
(statearr_25437_25499[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (29))){
var inst_25356 = (state_25413[(16)]);
var inst_25367 = (state_25413[(2)]);
var inst_25368 = fluree.db.util.async.throw_err(inst_25367);
var inst_25369 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25356,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_25368);
var state_25413__$1 = state_25413;
var statearr_25438_25500 = state_25413__$1;
(statearr_25438_25500[(2)] = inst_25369);

(statearr_25438_25500[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (6))){
var inst_25221 = (state_25413[(27)]);
var inst_25226 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25227 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25228 = ["Invalid with called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25226)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25227)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25221),"."].join('');
var inst_25229 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25230 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25231 = cljs.core.PersistentHashMap.fromArrays(inst_25229,inst_25230);
var inst_25232 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25228,inst_25231);
var inst_25233 = (function(){throw inst_25232})();
var state_25413__$1 = state_25413;
var statearr_25439_25501 = state_25413__$1;
(statearr_25439_25501[(2)] = inst_25233);

(statearr_25439_25501[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (28))){
var inst_25251 = (state_25413[(34)]);
var inst_25372 = (state_25413[(2)]);
var state_25413__$1 = (function (){var statearr_25440 = state_25413;
(statearr_25440[(36)] = inst_25372);

return statearr_25440;
})();
if(cljs.core.truth_(inst_25251)){
var statearr_25441_25502 = state_25413__$1;
(statearr_25441_25502[(1)] = (30));

} else {
var statearr_25442_25503 = state_25413__$1;
(statearr_25442_25503[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (25))){
var inst_25363 = (state_25413[(2)]);
var state_25413__$1 = state_25413;
if(cljs.core.truth_(inst_25363)){
var statearr_25443_25504 = state_25413__$1;
(statearr_25443_25504[(1)] = (26));

} else {
var statearr_25444_25505 = state_25413__$1;
(statearr_25444_25505[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (34))){
var inst_25344 = (state_25413[(17)]);
var inst_25335 = (state_25413[(15)]);
var inst_25392 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25335,inst_25344);
var state_25413__$1 = state_25413;
var statearr_25445_25506 = state_25413__$1;
(statearr_25445_25506[(2)] = inst_25392);

(statearr_25445_25506[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (17))){
var inst_25279 = (state_25413[(37)]);
var inst_25283 = (state_25413[(2)]);
var inst_25284 = fluree.db.util.async.throw_err(inst_25283);
var inst_25271 = inst_25279;
var inst_25272 = inst_25284;
var state_25413__$1 = (function (){var statearr_25446 = state_25413;
(statearr_25446[(24)] = inst_25272);

(statearr_25446[(38)] = inst_25271);

return statearr_25446;
})();
var statearr_25447_25507 = state_25413__$1;
(statearr_25447_25507[(2)] = null);

(statearr_25447_25507[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (3))){
var inst_25411 = (state_25413[(2)]);
var state_25413__$1 = state_25413;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25413__$1,inst_25411);
} else {
if((state_val_25414 === (12))){
var inst_25271 = (state_25413[(38)]);
var inst_25278 = (state_25413[(39)]);
var inst_25277 = cljs.core.seq(inst_25271);
var inst_25278__$1 = cljs.core.first(inst_25277);
var inst_25279 = cljs.core.next(inst_25277);
var state_25413__$1 = (function (){var statearr_25448 = state_25413;
(statearr_25448[(37)] = inst_25279);

(statearr_25448[(39)] = inst_25278__$1);

return statearr_25448;
})();
if(cljs.core.truth_(inst_25278__$1)){
var statearr_25449_25508 = state_25413__$1;
(statearr_25449_25508[(1)] = (14));

} else {
var statearr_25450_25509 = state_25413__$1;
(statearr_25450_25509[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (2))){
var inst_25221 = (state_25413[(27)]);
var _ = (function (){var statearr_25451 = state_25413;
(statearr_25451[(4)] = cljs.core.cons((5),(state_25413[(4)])));

return statearr_25451;
})();
var inst_25220 = cljs.core.first(flakes);
var inst_25221__$1 = fluree.db.flake.t(inst_25220);
var inst_25222 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25223 = (inst_25222 - (1));
var inst_25224 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_25221__$1,inst_25223);
var state_25413__$1 = (function (){var statearr_25452 = state_25413;
(statearr_25452[(27)] = inst_25221__$1);

return statearr_25452;
})();
if(inst_25224){
var statearr_25453_25510 = state_25413__$1;
(statearr_25453_25510[(1)] = (6));

} else {
var statearr_25454_25511 = state_25413__$1;
(statearr_25454_25511[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (23))){
var inst_25250 = (state_25413[(11)]);
var state_25413__$1 = state_25413;
var statearr_25455_25512 = state_25413__$1;
(statearr_25455_25512[(2)] = inst_25250);

(statearr_25455_25512[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (35))){
var inst_25335 = (state_25413[(15)]);
var state_25413__$1 = state_25413;
var statearr_25456_25513 = state_25413__$1;
(statearr_25456_25513[(2)] = inst_25335);

(statearr_25456_25513[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (19))){
var inst_25408 = (state_25413[(2)]);
var _ = (function (){var statearr_25457 = state_25413;
(statearr_25457[(4)] = cljs.core.rest((state_25413[(4)])));

return statearr_25457;
})();
var state_25413__$1 = state_25413;
var statearr_25458_25514 = state_25413__$1;
(statearr_25458_25514[(2)] = inst_25408);

(statearr_25458_25514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (11))){
var inst_25259 = (state_25413[(25)]);
var inst_25259__$1 = (state_25413[(2)]);
var inst_25267 = cljs.core.seq(inst_25259__$1);
var inst_25268 = cljs.core.first(inst_25267);
var inst_25269 = cljs.core.next(inst_25267);
var inst_25270 = db;
var inst_25271 = inst_25259__$1;
var inst_25272 = inst_25270;
var state_25413__$1 = (function (){var statearr_25460 = state_25413;
(statearr_25460[(25)] = inst_25259__$1);

(statearr_25460[(40)] = inst_25269);

(statearr_25460[(24)] = inst_25272);

(statearr_25460[(41)] = inst_25268);

(statearr_25460[(38)] = inst_25271);

return statearr_25460;
})();
var statearr_25461_25515 = state_25413__$1;
(statearr_25461_25515[(2)] = null);

(statearr_25461_25515[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (9))){
var inst_25237 = (state_25413[(30)]);
var inst_25253 = (state_25413[(35)]);
var inst_25255 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_25237,inst_25253);
var state_25413__$1 = state_25413;
var statearr_25462_25516 = state_25413__$1;
(statearr_25462_25516[(2)] = inst_25255);

(statearr_25462_25516[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (5))){
var _ = (function (){var statearr_25463 = state_25413;
(statearr_25463[(4)] = cljs.core.rest((state_25413[(4)])));

return statearr_25463;
})();
var state_25413__$1 = state_25413;
var ex25459 = (state_25413__$1[(2)]);
var statearr_25464_25517 = state_25413__$1;
(statearr_25464_25517[(5)] = ex25459);


if((ex25459 instanceof Error)){
var statearr_25465_25518 = state_25413__$1;
(statearr_25465_25518[(1)] = (4));

(statearr_25465_25518[(5)] = null);

} else {
throw ex25459;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (14))){
var inst_25272 = (state_25413[(24)]);
var inst_25278 = (state_25413[(39)]);
var inst_25281 = fluree.db.graphdb.add_predicate_to_idx(inst_25272,inst_25278,opts);
var state_25413__$1 = state_25413;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25413__$1,(17),inst_25281);
} else {
if((state_val_25414 === (26))){
var inst_25356 = (state_25413[(16)]);
var inst_25365 = fluree.db.query.schema.schema_map(inst_25356);
var state_25413__$1 = state_25413;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25413__$1,(29),inst_25365);
} else {
if((state_val_25414 === (16))){
var inst_25288 = (state_25413[(2)]);
var state_25413__$1 = state_25413;
var statearr_25466_25519 = state_25413__$1;
(statearr_25466_25519[(2)] = inst_25288);

(statearr_25466_25519[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (38))){
var inst_25336 = (state_25413[(8)]);
var state_25413__$1 = state_25413;
var statearr_25467_25520 = state_25413__$1;
(statearr_25467_25520[(2)] = inst_25336);

(statearr_25467_25520[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (30))){
var inst_25356 = (state_25413[(16)]);
var inst_25374 = fluree.db.query.schema.setting_map(inst_25356);
var state_25413__$1 = state_25413;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25413__$1,(33),inst_25374);
} else {
if((state_val_25414 === (10))){
var inst_25257 = cljs.core.PersistentVector.EMPTY;
var state_25413__$1 = state_25413;
var statearr_25468_25521 = state_25413__$1;
(statearr_25468_25521[(2)] = inst_25257);

(statearr_25468_25521[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (18))){
var inst_25332 = (state_25413[(23)]);
var inst_25344 = (state_25413[(17)]);
var inst_25343 = cljs.core.seq(inst_25332);
var inst_25344__$1 = cljs.core.first(inst_25343);
var inst_25345 = cljs.core.next(inst_25343);
var inst_25346 = cljs.core.not(inst_25344__$1);
var state_25413__$1 = (function (){var statearr_25469 = state_25413;
(statearr_25469[(17)] = inst_25344__$1);

(statearr_25469[(18)] = inst_25345);

return statearr_25469;
})();
if(inst_25346){
var statearr_25470_25522 = state_25413__$1;
(statearr_25470_25522[(1)] = (20));

} else {
var statearr_25471_25523 = state_25413__$1;
(statearr_25471_25523[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (37))){
var inst_25336 = (state_25413[(8)]);
var inst_25344 = (state_25413[(17)]);
var inst_25399 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25336,inst_25344);
var state_25413__$1 = state_25413;
var statearr_25472_25524 = state_25413__$1;
(statearr_25472_25524[(2)] = inst_25399);

(statearr_25472_25524[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25414 === (8))){
var inst_25244 = (state_25413[(26)]);
var inst_25221 = (state_25413[(27)]);
var inst_25236 = (state_25413[(28)]);
var inst_25250 = (state_25413[(11)]);
var inst_25237 = (state_25413[(30)]);
var inst_25240 = (state_25413[(33)]);
var inst_25236__$1 = (state_25413[(2)]);
var inst_25237__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.graphdb.include_flake_QMARK_,flakes);
var inst_25238 = cljs.core.PersistentHashSet.EMPTY;
var inst_25239 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p,inst_25237__$1);
var inst_25240__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25238,inst_25239);
var inst_25241 = cljs.core.PersistentHashMap.EMPTY;
var inst_25242 = (function (){var t = inst_25221;
var _ = inst_25236__$1;
var add_flakes = inst_25237__$1;
var add_preds = inst_25240__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_25243 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_25242,inst_25240__$1);
var inst_25244__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25241,inst_25243);
var inst_25245 = cljs.core.PersistentHashMap.EMPTY;
var inst_25246 = (function (){var t = inst_25221;
var _ = inst_25236__$1;
var add_flakes = inst_25237__$1;
var add_preds = inst_25240__$1;
var idx_QMARK__map = inst_25244__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_25247 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_25246,inst_25240__$1);
var inst_25248 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25245,inst_25247);
var inst_25249 = fluree.db.flake.size_bytes(inst_25237__$1);
var inst_25250__$1 = fluree.db.util.schema.system_change_QMARK_(inst_25237__$1);
var inst_25251 = fluree.db.util.schema.setting_change_QMARK_(inst_25237__$1);
var inst_25252 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25253 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25252,(0));
var state_25413__$1 = (function (){var statearr_25473 = state_25413;
(statearr_25473[(26)] = inst_25244__$1);

(statearr_25473[(28)] = inst_25236__$1);

(statearr_25473[(11)] = inst_25250__$1);

(statearr_25473[(30)] = inst_25237__$1);

(statearr_25473[(32)] = inst_25248);

(statearr_25473[(33)] = inst_25240__$1);

(statearr_25473[(34)] = inst_25251);

(statearr_25473[(14)] = inst_25249);

(statearr_25473[(35)] = inst_25253);

return statearr_25473;
})();
if(cljs.core.truth_(inst_25250__$1)){
var statearr_25474_25525 = state_25413__$1;
(statearr_25474_25525[(1)] = (9));

} else {
var statearr_25475_25526 = state_25413__$1;
(statearr_25475_25526[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_25476 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25476[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_25476[(1)] = (1));

return statearr_25476;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_25413){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25413);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25477){var ex__2730__auto__ = e25477;
var statearr_25478_25527 = state_25413;
(statearr_25478_25527[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25413[(4)]))){
var statearr_25479_25528 = state_25413;
(statearr_25479_25528[(1)] = cljs.core.first((state_25413[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25529 = state_25413;
state_25413 = G__25529;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_25413){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_25413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25480 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25480[(6)] = c__2749__auto__);

return statearr_25480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__25531 = arguments.length;
switch (G__25531) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___25678 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25627){
var state_val_25628 = (state_25627[(1)]);
if((state_val_25628 === (7))){
var state_25627__$1 = state_25627;
var statearr_25629_25679 = state_25627__$1;
(statearr_25629_25679[(2)] = null);

(statearr_25629_25679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (20))){
var inst_25577 = (state_25627[(7)]);
var inst_25575 = (state_25627[(8)]);
var inst_25576 = (state_25627[(9)]);
var inst_25596 = (inst_25575 + (1));
var inst_25597 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25577,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25596);
var inst_25598 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_25597,inst_25576,opts);
var state_25627__$1 = state_25627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25627__$1,(23),inst_25598);
} else {
if((state_val_25628 === (1))){
var state_25627__$1 = state_25627;
var statearr_25630_25680 = state_25627__$1;
(statearr_25630_25680[(2)] = null);

(statearr_25630_25680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (24))){
var inst_25601 = (state_25627[(10)]);
var inst_25604 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25601,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_25627__$1 = state_25627;
var statearr_25631_25681 = state_25627__$1;
(statearr_25631_25681[(2)] = inst_25604);

(statearr_25631_25681[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (4))){
var inst_25532 = (state_25627[(2)]);
var inst_25533 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_25532);
var state_25627__$1 = state_25627;
var statearr_25632_25682 = state_25627__$1;
(statearr_25632_25682[(2)] = inst_25533);

(statearr_25632_25682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (15))){
var inst_25583 = (state_25627[(11)]);
var state_25627__$1 = state_25627;
var statearr_25633_25683 = state_25627__$1;
(statearr_25633_25683[(2)] = inst_25583);

(statearr_25633_25683[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (21))){
var state_25627__$1 = state_25627;
var statearr_25634_25684 = state_25627__$1;
(statearr_25634_25684[(2)] = null);

(statearr_25634_25684[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (13))){
var inst_25619 = (state_25627[(2)]);
var inst_25620 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_25619);
var state_25627__$1 = state_25627;
var statearr_25635_25685 = state_25627__$1;
(statearr_25635_25685[(2)] = inst_25620);

(statearr_25635_25685[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (22))){
var inst_25615 = (state_25627[(2)]);
var state_25627__$1 = state_25627;
var statearr_25636_25686 = state_25627__$1;
(statearr_25636_25686[(2)] = inst_25615);

(statearr_25636_25686[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (6))){
var inst_25543 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25544 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_25545 = ["Invalid 'with' called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25543)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25544)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_25546 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25547 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25548 = cljs.core.PersistentHashMap.fromArrays(inst_25546,inst_25547);
var inst_25549 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25545,inst_25548);
var inst_25550 = (function(){throw inst_25549})();
var state_25627__$1 = state_25627;
var statearr_25639_25687 = state_25627__$1;
(statearr_25639_25687[(2)] = inst_25550);

(statearr_25639_25687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (25))){
var inst_25601 = (state_25627[(10)]);
var inst_25584 = (state_25627[(12)]);
var inst_25583 = (state_25627[(11)]);
var inst_25606 = fluree.db.flake.t(inst_25583);
var inst_25607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25608 = [inst_25583];
var inst_25609 = (new cljs.core.PersistentVector(null,1,(5),inst_25607,inst_25608,null));
var inst_25574 = inst_25584;
var inst_25575 = inst_25606;
var inst_25576 = inst_25609;
var inst_25577 = inst_25601;
var state_25627__$1 = (function (){var statearr_25640 = state_25627;
(statearr_25640[(7)] = inst_25577);

(statearr_25640[(8)] = inst_25575);

(statearr_25640[(13)] = inst_25574);

(statearr_25640[(9)] = inst_25576);

return statearr_25640;
})();
var statearr_25641_25688 = state_25627__$1;
(statearr_25641_25688[(2)] = null);

(statearr_25641_25688[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (17))){
var inst_25577 = (state_25627[(7)]);
var inst_25584 = (state_25627[(12)]);
var inst_25575 = (state_25627[(8)]);
var inst_25576 = (state_25627[(9)]);
var inst_25583 = (state_25627[(11)]);
var inst_25592 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25576,inst_25583);
var tmp25637 = inst_25577;
var tmp25638 = inst_25575;
var inst_25574 = inst_25584;
var inst_25575__$1 = tmp25638;
var inst_25576__$1 = inst_25592;
var inst_25577__$1 = tmp25637;
var state_25627__$1 = (function (){var statearr_25642 = state_25627;
(statearr_25642[(7)] = inst_25577__$1);

(statearr_25642[(8)] = inst_25575__$1);

(statearr_25642[(13)] = inst_25574);

(statearr_25642[(9)] = inst_25576__$1);

return statearr_25642;
})();
var statearr_25643_25689 = state_25627__$1;
(statearr_25643_25689[(2)] = null);

(statearr_25643_25689[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (3))){
var inst_25625 = (state_25627[(2)]);
var state_25627__$1 = state_25627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25627__$1,inst_25625);
} else {
if((state_val_25628 === (12))){
var inst_25574 = (state_25627[(13)]);
var inst_25583 = (state_25627[(11)]);
var inst_25582 = cljs.core.seq(inst_25574);
var inst_25583__$1 = cljs.core.first(inst_25582);
var inst_25584 = cljs.core.next(inst_25582);
var state_25627__$1 = (function (){var statearr_25644 = state_25627;
(statearr_25644[(12)] = inst_25584);

(statearr_25644[(11)] = inst_25583__$1);

return statearr_25644;
})();
if(cljs.core.truth_(inst_25583__$1)){
var statearr_25645_25690 = state_25627__$1;
(statearr_25645_25690[(1)] = (14));

} else {
var statearr_25646_25691 = state_25627__$1;
(statearr_25646_25691[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (2))){
var _ = (function (){var statearr_25647 = state_25627;
(statearr_25647[(4)] = cljs.core.cons((5),(state_25627[(4)])));

return statearr_25647;
})();
var inst_25539 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_25540 = (inst_25539 + (1));
var inst_25541 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_25540);
var state_25627__$1 = state_25627;
if(inst_25541){
var statearr_25648_25692 = state_25627__$1;
(statearr_25648_25692[(1)] = (6));

} else {
var statearr_25649_25693 = state_25627__$1;
(statearr_25649_25693[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (23))){
var inst_25583 = (state_25627[(11)]);
var inst_25600 = (state_25627[(2)]);
var inst_25601 = fluree.db.util.async.throw_err(inst_25600);
var inst_25602 = (inst_25583 == null);
var state_25627__$1 = (function (){var statearr_25650 = state_25627;
(statearr_25650[(10)] = inst_25601);

return statearr_25650;
})();
if(cljs.core.truth_(inst_25602)){
var statearr_25651_25694 = state_25627__$1;
(statearr_25651_25694[(1)] = (24));

} else {
var statearr_25652_25695 = state_25627__$1;
(statearr_25652_25695[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (19))){
var inst_25617 = (state_25627[(2)]);
var state_25627__$1 = state_25627;
var statearr_25653_25696 = state_25627__$1;
(statearr_25653_25696[(2)] = inst_25617);

(statearr_25653_25696[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (11))){
var inst_25622 = (state_25627[(2)]);
var _ = (function (){var statearr_25655 = state_25627;
(statearr_25655[(4)] = cljs.core.rest((state_25627[(4)])));

return statearr_25655;
})();
var state_25627__$1 = state_25627;
var statearr_25656_25697 = state_25627__$1;
(statearr_25656_25697[(2)] = inst_25622);

(statearr_25656_25697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (9))){
var inst_25556 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_25557 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_25556);
var state_25627__$1 = state_25627;
var statearr_25657_25698 = state_25627__$1;
(statearr_25657_25698[(2)] = inst_25557);

(statearr_25657_25698[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (5))){
var _ = (function (){var statearr_25658 = state_25627;
(statearr_25658[(4)] = cljs.core.rest((state_25627[(4)])));

return statearr_25658;
})();
var state_25627__$1 = state_25627;
var ex25654 = (state_25627__$1[(2)]);
var statearr_25659_25699 = state_25627__$1;
(statearr_25659_25699[(5)] = ex25654);


var statearr_25660_25700 = state_25627__$1;
(statearr_25660_25700[(1)] = (4));

(statearr_25660_25700[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (14))){
var inst_25575 = (state_25627[(8)]);
var inst_25583 = (state_25627[(11)]);
var inst_25586 = fluree.db.flake.t(inst_25583);
var inst_25587 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_25575,inst_25586);
var state_25627__$1 = state_25627;
var statearr_25661_25701 = state_25627__$1;
(statearr_25661_25701[(2)] = inst_25587);

(statearr_25661_25701[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (26))){
var inst_25612 = (state_25627[(2)]);
var state_25627__$1 = state_25627;
var statearr_25662_25702 = state_25627__$1;
(statearr_25662_25702[(2)] = inst_25612);

(statearr_25662_25702[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (16))){
var inst_25590 = (state_25627[(2)]);
var state_25627__$1 = state_25627;
if(cljs.core.truth_(inst_25590)){
var statearr_25663_25703 = state_25627__$1;
(statearr_25663_25703[(1)] = (17));

} else {
var statearr_25664_25704 = state_25627__$1;
(statearr_25664_25704[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (10))){
var inst_25559 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_25567 = cljs.core.seq(inst_25559);
var inst_25568 = cljs.core.first(inst_25567);
var inst_25569 = cljs.core.next(inst_25567);
var inst_25570 = cljs.core.first(inst_25559);
var inst_25571 = fluree.db.flake.t(inst_25570);
var inst_25572 = cljs.core.PersistentVector.EMPTY;
var inst_25573 = db;
var inst_25574 = inst_25559;
var inst_25575 = inst_25571;
var inst_25576 = inst_25572;
var inst_25577 = inst_25573;
var state_25627__$1 = (function (){var statearr_25665 = state_25627;
(statearr_25665[(14)] = inst_25569);

(statearr_25665[(7)] = inst_25577);

(statearr_25665[(8)] = inst_25575);

(statearr_25665[(13)] = inst_25574);

(statearr_25665[(15)] = inst_25568);

(statearr_25665[(9)] = inst_25576);

return statearr_25665;
})();
var statearr_25666_25705 = state_25627__$1;
(statearr_25666_25705[(2)] = null);

(statearr_25666_25705[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (18))){
var state_25627__$1 = state_25627;
var statearr_25667_25706 = state_25627__$1;
(statearr_25667_25706[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25628 === (8))){
var inst_25553 = (state_25627[(2)]);
var inst_25554 = cljs.core.empty_QMARK_(flakes);
var state_25627__$1 = (function (){var statearr_25669 = state_25627;
(statearr_25669[(16)] = inst_25553);

return statearr_25669;
})();
if(inst_25554){
var statearr_25670_25707 = state_25627__$1;
(statearr_25670_25707[(1)] = (9));

} else {
var statearr_25671_25708 = state_25627__$1;
(statearr_25671_25708[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_25672 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25672[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_25672[(1)] = (1));

return statearr_25672;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_25627){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25627);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25673){var ex__2730__auto__ = e25673;
var statearr_25674_25709 = state_25627;
(statearr_25674_25709[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25627[(4)]))){
var statearr_25675_25710 = state_25627;
(statearr_25675_25710[(1)] = cljs.core.first((state_25627[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25711 = state_25627;
state_25627 = G__25711;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_25627){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_25627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25676 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25676[(6)] = c__2749__auto___25678);

return statearr_25676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25763){
var state_val_25764 = (state_25763[(1)]);
if((state_val_25764 === (7))){
var state_25763__$1 = state_25763;
var statearr_25765_25792 = state_25763__$1;
(statearr_25765_25792[(2)] = tt_id);

(statearr_25765_25792[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25764 === (1))){
var state_25763__$1 = state_25763;
var statearr_25766_25793 = state_25763__$1;
(statearr_25766_25793[(2)] = null);

(statearr_25766_25793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25764 === (4))){
var inst_25712 = (state_25763[(2)]);
var state_25763__$1 = state_25763;
var statearr_25767_25794 = state_25763__$1;
(statearr_25767_25794[(2)] = inst_25712);

(statearr_25767_25794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25764 === (13))){
var inst_25756 = (state_25763[(2)]);
var state_25763__$1 = state_25763;
var statearr_25768_25795 = state_25763__$1;
(statearr_25768_25795[(2)] = inst_25756);

(statearr_25768_25795[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25764 === (6))){
var inst_25720 = cljs.core.random_uuid();
var state_25763__$1 = state_25763;
var statearr_25769_25796 = state_25763__$1;
(statearr_25769_25796[(2)] = inst_25720);

(statearr_25769_25796[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25764 === (3))){
var inst_25761 = (state_25763[(2)]);
var state_25763__$1 = state_25763;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25763__$1,inst_25761);
} else {
if((state_val_25764 === (12))){
var inst_25739 = (state_25763[(7)]);
var state_25763__$1 = state_25763;
var statearr_25770_25797 = state_25763__$1;
(statearr_25770_25797[(2)] = inst_25739);

(statearr_25770_25797[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25764 === (2))){
var _ = (function (){var statearr_25771 = state_25763;
(statearr_25771[(4)] = cljs.core.cons((5),(state_25763[(4)])));

return statearr_25771;
})();
var inst_25718 = (tt_id == null);
var state_25763__$1 = state_25763;
if(cljs.core.truth_(inst_25718)){
var statearr_25772_25798 = state_25763__$1;
(statearr_25772_25798[(1)] = (6));

} else {
var statearr_25773_25799 = state_25763__$1;
(statearr_25773_25799[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25764 === (11))){
var inst_25739 = (state_25763[(7)]);
var inst_25746 = (state_25763[(8)]);
var inst_25749 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_25739,inst_25746);
var state_25763__$1 = state_25763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25763__$1,(14),inst_25749);
} else {
if((state_val_25764 === (9))){
var inst_25740 = (state_25763[(9)]);
var inst_25746 = (state_25763[(8)]);
var inst_25745 = cljs.core.seq(inst_25740);
var inst_25746__$1 = cljs.core.first(inst_25745);
var inst_25747 = cljs.core.next(inst_25745);
var state_25763__$1 = (function (){var statearr_25775 = state_25763;
(statearr_25775[(10)] = inst_25747);

(statearr_25775[(8)] = inst_25746__$1);

return statearr_25775;
})();
if(cljs.core.truth_(inst_25746__$1)){
var statearr_25776_25800 = state_25763__$1;
(statearr_25776_25800[(1)] = (11));

} else {
var statearr_25777_25801 = state_25763__$1;
(statearr_25777_25801[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25764 === (5))){
var _ = (function (){var statearr_25778 = state_25763;
(statearr_25778[(4)] = cljs.core.rest((state_25763[(4)])));

return statearr_25778;
})();
var state_25763__$1 = state_25763;
var ex25774 = (state_25763__$1[(2)]);
var statearr_25779_25802 = state_25763__$1;
(statearr_25779_25802[(5)] = ex25774);


if((ex25774 instanceof Error)){
var statearr_25780_25803 = state_25763__$1;
(statearr_25780_25803[(1)] = (4));

(statearr_25780_25803[(5)] = null);

} else {
throw ex25774;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25764 === (14))){
var inst_25747 = (state_25763[(10)]);
var inst_25751 = (state_25763[(2)]);
var inst_25752 = fluree.db.util.async.throw_err(inst_25751);
var inst_25739 = inst_25752;
var inst_25740 = inst_25747;
var state_25763__$1 = (function (){var statearr_25781 = state_25763;
(statearr_25781[(9)] = inst_25740);

(statearr_25781[(7)] = inst_25739);

return statearr_25781;
})();
var statearr_25782_25804 = state_25763__$1;
(statearr_25782_25804[(2)] = null);

(statearr_25782_25804[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25764 === (10))){
var inst_25758 = (state_25763[(2)]);
var _ = (function (){var statearr_25783 = state_25763;
(statearr_25783[(4)] = cljs.core.rest((state_25763[(4)])));

return statearr_25783;
})();
var state_25763__$1 = state_25763;
var statearr_25784_25805 = state_25763__$1;
(statearr_25784_25805[(2)] = inst_25758);

(statearr_25784_25805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25764 === (8))){
var inst_25723 = (state_25763[(2)]);
var inst_25724 = (function (){var tt_id__$1 = inst_25723;
return (function (db_STAR_,idx){
return cljs.core.update.cljs$core$IFn$_invoke$arity$5(db_STAR_,idx,cljs.core.assoc,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id__$1);
});
})();
var inst_25725 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_25723);
var inst_25726 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_25724,inst_25725,fluree.db.index.types);
var inst_25727 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"t","t",-1397832519),fluree.db.flake.cmp_tx,flakes);
var inst_25728 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_25727);
var inst_25736 = cljs.core.seq(inst_25728);
var inst_25737 = cljs.core.first(inst_25736);
var inst_25738 = cljs.core.next(inst_25736);
var inst_25739 = inst_25726;
var inst_25740 = inst_25728;
var state_25763__$1 = (function (){var statearr_25785 = state_25763;
(statearr_25785[(9)] = inst_25740);

(statearr_25785[(11)] = inst_25737);

(statearr_25785[(12)] = inst_25738);

(statearr_25785[(7)] = inst_25739);

return statearr_25785;
})();
var statearr_25786_25806 = state_25763__$1;
(statearr_25786_25806[(2)] = null);

(statearr_25786_25806[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0 = (function (){
var statearr_25787 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25787[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__);

(statearr_25787[(1)] = (1));

return statearr_25787;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1 = (function (state_25763){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25763);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25788){var ex__2730__auto__ = e25788;
var statearr_25789_25807 = state_25763;
(statearr_25789_25807[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25763[(4)]))){
var statearr_25790_25808 = state_25763;
(statearr_25790_25808[(1)] = cljs.core.first((state_25763[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25809 = state_25763;
state_25763 = G__25809;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__ = function(state_25763){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1.call(this,state_25763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25791 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25791[(6)] = c__2749__auto__);

return statearr_25791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___25996 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25927){
var state_val_25928 = (state_25927[(1)]);
if((state_val_25928 === (7))){
var inst_25837 = (state_25927[(7)]);
var inst_25837__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_25927__$1 = (function (){var statearr_25929 = state_25927;
(statearr_25929[(7)] = inst_25837__$1);

return statearr_25929;
})();
if(inst_25837__$1){
var statearr_25930_25997 = state_25927__$1;
(statearr_25930_25997[(1)] = (13));

} else {
var statearr_25931_25998 = state_25927__$1;
(statearr_25931_25998[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (20))){
var state_25927__$1 = state_25927;
var statearr_25932_25999 = state_25927__$1;
(statearr_25932_25999[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (27))){
var inst_25873 = (state_25927[(8)]);
var inst_25877 = fluree.db.flake.s(inst_25873);
var state_25927__$1 = state_25927;
var statearr_25934_26000 = state_25927__$1;
(statearr_25934_26000[(2)] = inst_25877);

(statearr_25934_26000[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (1))){
var state_25927__$1 = state_25927;
var statearr_25935_26001 = state_25927__$1;
(statearr_25935_26001[(2)] = null);

(statearr_25935_26001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (24))){
var inst_25867 = (state_25927[(9)]);
var inst_25871 = cljs.core.first(inst_25867);
var state_25927__$1 = state_25927;
var statearr_25936_26002 = state_25927__$1;
(statearr_25936_26002[(2)] = inst_25871);

(statearr_25936_26002[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (39))){
var state_25927__$1 = state_25927;
var statearr_25937_26003 = state_25927__$1;
(statearr_25937_26003[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (4))){
var inst_25810 = (state_25927[(2)]);
var inst_25811 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_25812 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25813 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_25814 = cljs.core.PersistentHashMap.fromArrays(inst_25812,inst_25813);
var inst_25815 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_25811,inst_25814,inst_25810);
var inst_25816 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_25815);
var state_25927__$1 = state_25927;
var statearr_25939_26004 = state_25927__$1;
(statearr_25939_26004[(2)] = inst_25816);

(statearr_25939_26004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (15))){
var inst_25844 = (state_25927[(2)]);
var state_25927__$1 = state_25927;
if(cljs.core.truth_(inst_25844)){
var statearr_25940_26005 = state_25927__$1;
(statearr_25940_26005[(1)] = (16));

} else {
var statearr_25941_26006 = state_25927__$1;
(statearr_25941_26006[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (21))){
var inst_25893 = (state_25927[(2)]);
var state_25927__$1 = state_25927;
var statearr_25942_26007 = state_25927__$1;
(statearr_25942_26007[(2)] = inst_25893);

(statearr_25942_26007[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (31))){
var inst_25891 = (state_25927[(2)]);
var state_25927__$1 = state_25927;
var statearr_25943_26008 = state_25927__$1;
(statearr_25943_26008[(2)] = inst_25891);

(statearr_25943_26008[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (32))){
var inst_25897 = (state_25927[(10)]);
var inst_25899 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_25897);
var state_25927__$1 = state_25927;
var statearr_25944_26009 = state_25927__$1;
(statearr_25944_26009[(2)] = inst_25899);

(statearr_25944_26009[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (40))){
var inst_25920 = (state_25927[(2)]);
var state_25927__$1 = state_25927;
var statearr_25945_26010 = state_25927__$1;
(statearr_25945_26010[(2)] = inst_25920);

(statearr_25945_26010[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (33))){
var inst_25897 = (state_25927[(10)]);
var inst_25901 = (state_25927[(11)]);
var inst_25901__$1 = (inst_25897 == null);
var state_25927__$1 = (function (){var statearr_25946 = state_25927;
(statearr_25946[(11)] = inst_25901__$1);

return statearr_25946;
})();
if(cljs.core.truth_(inst_25901__$1)){
var statearr_25947_26011 = state_25927__$1;
(statearr_25947_26011[(1)] = (35));

} else {
var statearr_25948_26012 = state_25927__$1;
(statearr_25948_26012[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (13))){
var inst_25839 = cljs.core.first(ident);
var inst_25840 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_25839);
var inst_25841 = (inst_25840 == null);
var state_25927__$1 = state_25927;
var statearr_25949_26013 = state_25927__$1;
(statearr_25949_26013[(2)] = inst_25841);

(statearr_25949_26013[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (22))){
var inst_25867 = (state_25927[(9)]);
var inst_25866 = (state_25927[(2)]);
var inst_25867__$1 = fluree.db.util.async.throw_err(inst_25866);
var inst_25868 = (inst_25867__$1 == null);
var state_25927__$1 = (function (){var statearr_25950 = state_25927;
(statearr_25950[(9)] = inst_25867__$1);

return statearr_25950;
})();
if(cljs.core.truth_(inst_25868)){
var statearr_25951_26014 = state_25927__$1;
(statearr_25951_26014[(1)] = (23));

} else {
var statearr_25952_26015 = state_25927__$1;
(statearr_25952_26015[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (36))){
var inst_25901 = (state_25927[(11)]);
var state_25927__$1 = state_25927;
var statearr_25953_26016 = state_25927__$1;
(statearr_25953_26016[(2)] = inst_25901);

(statearr_25953_26016[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (41))){
var inst_25915 = cljs.core.async.close_BANG_(return_chan);
var state_25927__$1 = state_25927;
var statearr_25954_26017 = state_25927__$1;
(statearr_25954_26017[(2)] = inst_25915);

(statearr_25954_26017[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (43))){
var inst_25918 = (state_25927[(2)]);
var state_25927__$1 = state_25927;
var statearr_25955_26018 = state_25927__$1;
(statearr_25955_26018[(2)] = inst_25918);

(statearr_25955_26018[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (29))){
var inst_25882 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_25883 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_25882].join('');
var inst_25884 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25885 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_25886 = cljs.core.PersistentHashMap.fromArrays(inst_25884,inst_25885);
var inst_25887 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25883,inst_25886);
var inst_25888 = (function(){throw inst_25887})();
var state_25927__$1 = state_25927;
var statearr_25956_26019 = state_25927__$1;
(statearr_25956_26019[(2)] = inst_25888);

(statearr_25956_26019[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (6))){
var inst_25824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25825 = [ident];
var inst_25826 = (new cljs.core.PersistentVector(null,1,(5),inst_25824,inst_25825,null));
var inst_25827 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_25826);
var state_25927__$1 = state_25927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25927__$1,(9),inst_25827);
} else {
if((state_val_25928 === (28))){
var inst_25879 = (state_25927[(2)]);
var state_25927__$1 = state_25927;
var statearr_25957_26020 = state_25927__$1;
(statearr_25957_26020[(2)] = inst_25879);

(statearr_25957_26020[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (25))){
var inst_25873 = (state_25927[(8)]);
var inst_25873__$1 = (state_25927[(2)]);
var inst_25874 = (inst_25873__$1 == null);
var state_25927__$1 = (function (){var statearr_25958 = state_25927;
(statearr_25958[(8)] = inst_25873__$1);

return statearr_25958;
})();
if(cljs.core.truth_(inst_25874)){
var statearr_25959_26021 = state_25927__$1;
(statearr_25959_26021[(1)] = (26));

} else {
var statearr_25960_26022 = state_25927__$1;
(statearr_25960_26022[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (34))){
var inst_25922 = (state_25927[(2)]);
var _ = (function (){var statearr_25961 = state_25927;
(statearr_25961[(4)] = cljs.core.rest((state_25927[(4)])));

return statearr_25961;
})();
var state_25927__$1 = state_25927;
var statearr_25962_26023 = state_25927__$1;
(statearr_25962_26023[(2)] = inst_25922);

(statearr_25962_26023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (17))){
var inst_25855 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_25927__$1 = state_25927;
if(inst_25855){
var statearr_25963_26024 = state_25927__$1;
(statearr_25963_26024[(1)] = (19));

} else {
var statearr_25964_26025 = state_25927__$1;
(statearr_25964_26025[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (3))){
var inst_25925 = (state_25927[(2)]);
var state_25927__$1 = state_25927;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25927__$1,inst_25925);
} else {
if((state_val_25928 === (12))){
var inst_25835 = (state_25927[(2)]);
var state_25927__$1 = state_25927;
var statearr_25965_26026 = state_25927__$1;
(statearr_25965_26026[(2)] = inst_25835);

(statearr_25965_26026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (2))){
var _ = (function (){var statearr_25966 = state_25927;
(statearr_25966[(4)] = cljs.core.cons((5),(state_25927[(4)])));

return statearr_25966;
})();
var inst_25822 = typeof ident === 'number';
var state_25927__$1 = state_25927;
if(cljs.core.truth_(inst_25822)){
var statearr_25967_26027 = state_25927__$1;
(statearr_25967_26027[(1)] = (6));

} else {
var statearr_25968_26028 = state_25927__$1;
(statearr_25968_26028[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (23))){
var state_25927__$1 = state_25927;
var statearr_25969_26029 = state_25927__$1;
(statearr_25969_26029[(2)] = null);

(statearr_25969_26029[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (35))){
var state_25927__$1 = state_25927;
var statearr_25970_26030 = state_25927__$1;
(statearr_25970_26030[(2)] = strict_QMARK_);

(statearr_25970_26030[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (19))){
var inst_25858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25859 = cljs.core.first(ident);
var inst_25860 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_25859);
var inst_25861 = cljs.core.second(ident);
var inst_25862 = [inst_25860,inst_25861];
var inst_25863 = (new cljs.core.PersistentVector(null,2,(5),inst_25858,inst_25862,null));
var inst_25864 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_25863);
var state_25927__$1 = state_25927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25927__$1,(22),inst_25864);
} else {
if((state_val_25928 === (11))){
var state_25927__$1 = state_25927;
var statearr_25972_26031 = state_25927__$1;
(statearr_25972_26031[(2)] = null);

(statearr_25972_26031[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (9))){
var inst_25829 = (state_25927[(2)]);
var inst_25830 = fluree.db.util.async.throw_err(inst_25829);
var inst_25831 = cljs.core.not_empty(inst_25830);
var state_25927__$1 = state_25927;
if(cljs.core.truth_(inst_25831)){
var statearr_25973_26032 = state_25927__$1;
(statearr_25973_26032[(1)] = (10));

} else {
var statearr_25974_26033 = state_25927__$1;
(statearr_25974_26033[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (5))){
var _ = (function (){var statearr_25975 = state_25927;
(statearr_25975[(4)] = cljs.core.rest((state_25927[(4)])));

return statearr_25975;
})();
var state_25927__$1 = state_25927;
var ex25971 = (state_25927__$1[(2)]);
var statearr_25976_26034 = state_25927__$1;
(statearr_25976_26034[(5)] = ex25971);


var statearr_25977_26035 = state_25927__$1;
(statearr_25977_26035[(1)] = (4));

(statearr_25977_26035[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (14))){
var inst_25837 = (state_25927[(7)]);
var state_25927__$1 = state_25927;
var statearr_25978_26036 = state_25927__$1;
(statearr_25978_26036[(2)] = inst_25837);

(statearr_25978_26036[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (26))){
var state_25927__$1 = state_25927;
var statearr_25979_26037 = state_25927__$1;
(statearr_25979_26037[(2)] = null);

(statearr_25979_26037[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (16))){
var inst_25846 = cljs.core.first(ident);
var inst_25847 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_25846], 0));
var inst_25848 = ["Subject ID lookup failed. The predicate ",inst_25847," does not exist."].join('');
var inst_25849 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25850 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_25851 = cljs.core.PersistentHashMap.fromArrays(inst_25849,inst_25850);
var inst_25852 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25848,inst_25851);
var inst_25853 = (function(){throw inst_25852})();
var state_25927__$1 = state_25927;
var statearr_25980_26038 = state_25927__$1;
(statearr_25980_26038[(2)] = inst_25853);

(statearr_25980_26038[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (38))){
var inst_25907 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_25908 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25909 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_25910 = cljs.core.PersistentHashMap.fromArrays(inst_25908,inst_25909);
var inst_25911 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25907,inst_25910);
var inst_25912 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_25911);
var state_25927__$1 = state_25927;
var statearr_25981_26039 = state_25927__$1;
(statearr_25981_26039[(2)] = inst_25912);

(statearr_25981_26039[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (30))){
var state_25927__$1 = state_25927;
var statearr_25982_26040 = state_25927__$1;
(statearr_25982_26040[(2)] = null);

(statearr_25982_26040[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (10))){
var state_25927__$1 = state_25927;
var statearr_25983_26041 = state_25927__$1;
(statearr_25983_26041[(2)] = ident);

(statearr_25983_26041[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (18))){
var inst_25895 = (state_25927[(2)]);
var state_25927__$1 = state_25927;
var statearr_25984_26042 = state_25927__$1;
(statearr_25984_26042[(2)] = inst_25895);

(statearr_25984_26042[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (42))){
var state_25927__$1 = state_25927;
var statearr_25985_26043 = state_25927__$1;
(statearr_25985_26043[(2)] = null);

(statearr_25985_26043[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (37))){
var inst_25905 = (state_25927[(2)]);
var state_25927__$1 = state_25927;
if(cljs.core.truth_(inst_25905)){
var statearr_25986_26044 = state_25927__$1;
(statearr_25986_26044[(1)] = (38));

} else {
var statearr_25987_26045 = state_25927__$1;
(statearr_25987_26045[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25928 === (8))){
var inst_25897 = (state_25927[(10)]);
var inst_25897__$1 = (state_25927[(2)]);
var state_25927__$1 = (function (){var statearr_25988 = state_25927;
(statearr_25988[(10)] = inst_25897__$1);

return statearr_25988;
})();
if(cljs.core.truth_(inst_25897__$1)){
var statearr_25989_26046 = state_25927__$1;
(statearr_25989_26046[(1)] = (32));

} else {
var statearr_25990_26047 = state_25927__$1;
(statearr_25990_26047[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2727__auto____0 = (function (){
var statearr_25991 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25991[(0)] = fluree$db$graphdb$subid_$_state_machine__2727__auto__);

(statearr_25991[(1)] = (1));

return statearr_25991;
});
var fluree$db$graphdb$subid_$_state_machine__2727__auto____1 = (function (state_25927){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25927);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25992){var ex__2730__auto__ = e25992;
var statearr_25993_26048 = state_25927;
(statearr_25993_26048[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25927[(4)]))){
var statearr_25994_26049 = state_25927;
(statearr_25994_26049[(1)] = cljs.core.first((state_25927[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26050 = state_25927;
state_25927 = G__26050;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2727__auto__ = function(state_25927){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2727__auto____1.call(this,state_25927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2727__auto____0;
fluree$db$graphdb$subid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2727__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25995 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25995[(6)] = c__2749__auto___25996);

return statearr_25995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__26051){
var map__26052 = p__26051;
var map__26052__$1 = cljs.core.__destructure_map(map__26052);
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26052__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26052__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26068){
var state_val_26069 = (state_26068[(1)]);
if((state_val_26069 === (1))){
var state_26068__$1 = state_26068;
var statearr_26070_26084 = state_26068__$1;
(statearr_26070_26084[(2)] = null);

(statearr_26070_26084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26069 === (2))){
var _ = (function (){var statearr_26071 = state_26068;
(statearr_26071[(4)] = cljs.core.cons((5),(state_26068[(4)])));

return statearr_26071;
})();
var inst_26059 = (current_db_fn.cljs$core$IFn$_invoke$arity$0 ? current_db_fn.cljs$core$IFn$_invoke$arity$0() : current_db_fn.call(null));
var state_26068__$1 = state_26068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26068__$1,(6),inst_26059);
} else {
if((state_val_26069 === (3))){
var inst_26066 = (state_26068[(2)]);
var state_26068__$1 = state_26068;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26068__$1,inst_26066);
} else {
if((state_val_26069 === (4))){
var inst_26053 = (state_26068[(2)]);
var state_26068__$1 = state_26068;
var statearr_26073_26085 = state_26068__$1;
(statearr_26073_26085[(2)] = inst_26053);

(statearr_26073_26085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26069 === (5))){
var _ = (function (){var statearr_26074 = state_26068;
(statearr_26074[(4)] = cljs.core.rest((state_26068[(4)])));

return statearr_26074;
})();
var state_26068__$1 = state_26068;
var ex26072 = (state_26068__$1[(2)]);
var statearr_26075_26086 = state_26068__$1;
(statearr_26075_26086[(5)] = ex26072);


if((ex26072 instanceof Error)){
var statearr_26076_26087 = state_26068__$1;
(statearr_26076_26087[(1)] = (4));

(statearr_26076_26087[(5)] = null);

} else {
throw ex26072;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26069 === (6))){
var inst_26061 = (state_26068[(2)]);
var inst_26062 = fluree.db.util.async.throw_err(inst_26061);
var inst_26063 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26062,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_26077 = state_26068;
(statearr_26077[(4)] = cljs.core.rest((state_26068[(4)])));

return statearr_26077;
})();
var state_26068__$1 = state_26068;
var statearr_26078_26088 = state_26068__$1;
(statearr_26078_26088[(2)] = inst_26063);

(statearr_26078_26088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0 = (function (){
var statearr_26079 = [null,null,null,null,null,null,null];
(statearr_26079[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__);

(statearr_26079[(1)] = (1));

return statearr_26079;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1 = (function (state_26068){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26068);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26080){var ex__2730__auto__ = e26080;
var statearr_26081_26089 = state_26068;
(statearr_26081_26089[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26068[(4)]))){
var statearr_26082_26090 = state_26068;
(statearr_26082_26090[(1)] = cljs.core.first((state_26068[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26091 = state_26068;
state_26068 = G__26091;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__ = function(state_26068){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1.call(this,state_26068);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26083 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26083[(6)] = c__2749__auto__);

return statearr_26083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__26092,property,collection){
var map__26093 = p__26092;
var map__26093__$1 = cljs.core.__destructure_map(map__26093);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26093__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__26094 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__26094.cljs$core$IFn$_invoke$arity$1 ? fexpr__26094.cljs$core$IFn$_invoke$arity$1(property) : fexpr__26094.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__26095,property,predicate){
var map__26096 = p__26095;
var map__26096__$1 = cljs.core.__destructure_map(map__26096);
var this$ = map__26096__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26096__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__26097 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__26097.cljs$core$IFn$_invoke$arity$1 ? fexpr__26097.cljs$core$IFn$_invoke$arity$1(property) : fexpr__26097.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__26098 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop(this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__26098);
} else {
return G__26098;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__26100 = arguments.length;
switch (G__26100) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26132){
var state_val_26133 = (state_26132[(1)]);
if((state_val_26133 === (7))){
var state_26132__$1 = state_26132;
var statearr_26134_26228 = state_26132__$1;
(statearr_26134_26228[(2)] = null);

(statearr_26134_26228[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26133 === (1))){
var state_26132__$1 = state_26132;
var statearr_26135_26229 = state_26132__$1;
(statearr_26135_26229[(2)] = null);

(statearr_26135_26229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26133 === (4))){
var inst_26101 = (state_26132[(2)]);
var state_26132__$1 = state_26132;
var statearr_26136_26230 = state_26132__$1;
(statearr_26136_26230[(2)] = inst_26101);

(statearr_26136_26230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26133 === (6))){
var inst_26115 = (state_26132[(7)]);
var inst_26114 = (state_26132[(2)]);
var inst_26115__$1 = fluree.db.util.async.throw_err(inst_26114);
var inst_26116 = (inst_26115__$1 == null);
var state_26132__$1 = (function (){var statearr_26137 = state_26132;
(statearr_26137[(7)] = inst_26115__$1);

return statearr_26137;
})();
if(cljs.core.truth_(inst_26116)){
var statearr_26138_26231 = state_26132__$1;
(statearr_26138_26231[(1)] = (7));

} else {
var statearr_26139_26232 = state_26132__$1;
(statearr_26139_26232[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26133 === (3))){
var inst_26130 = (state_26132[(2)]);
var state_26132__$1 = state_26132;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26132__$1,inst_26130);
} else {
if((state_val_26133 === (12))){
var inst_26127 = (state_26132[(2)]);
var _ = (function (){var statearr_26140 = state_26132;
(statearr_26140[(4)] = cljs.core.rest((state_26132[(4)])));

return statearr_26140;
})();
var state_26132__$1 = state_26132;
var statearr_26141_26233 = state_26132__$1;
(statearr_26141_26233[(2)] = inst_26127);

(statearr_26141_26233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26133 === (2))){
var _ = (function (){var statearr_26142 = state_26132;
(statearr_26142[(4)] = cljs.core.cons((5),(state_26132[(4)])));

return statearr_26142;
})();
var inst_26108 = fluree.db.dbproto._rootdb(this$);
var inst_26109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26110 = [tag_id,(30)];
var inst_26111 = (new cljs.core.PersistentVector(null,2,(5),inst_26109,inst_26110,null));
var inst_26112 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_26108,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26111);
var state_26132__$1 = state_26132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26132__$1,(6),inst_26112);
} else {
if((state_val_26133 === (11))){
var inst_26121 = (state_26132[(8)]);
var inst_26125 = fluree.db.flake.o(inst_26121);
var state_26132__$1 = state_26132;
var statearr_26144_26234 = state_26132__$1;
(statearr_26144_26234[(2)] = inst_26125);

(statearr_26144_26234[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26133 === (9))){
var inst_26121 = (state_26132[(8)]);
var inst_26121__$1 = (state_26132[(2)]);
var inst_26122 = (inst_26121__$1 == null);
var state_26132__$1 = (function (){var statearr_26145 = state_26132;
(statearr_26145[(8)] = inst_26121__$1);

return statearr_26145;
})();
if(cljs.core.truth_(inst_26122)){
var statearr_26146_26235 = state_26132__$1;
(statearr_26146_26235[(1)] = (10));

} else {
var statearr_26147_26236 = state_26132__$1;
(statearr_26147_26236[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26133 === (5))){
var _ = (function (){var statearr_26148 = state_26132;
(statearr_26148[(4)] = cljs.core.rest((state_26132[(4)])));

return statearr_26148;
})();
var state_26132__$1 = state_26132;
var ex26143 = (state_26132__$1[(2)]);
var statearr_26149_26237 = state_26132__$1;
(statearr_26149_26237[(5)] = ex26143);


if((ex26143 instanceof Error)){
var statearr_26150_26238 = state_26132__$1;
(statearr_26150_26238[(1)] = (4));

(statearr_26150_26238[(5)] = null);

} else {
throw ex26143;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26133 === (10))){
var state_26132__$1 = state_26132;
var statearr_26151_26239 = state_26132__$1;
(statearr_26151_26239[(2)] = null);

(statearr_26151_26239[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26133 === (8))){
var inst_26115 = (state_26132[(7)]);
var inst_26119 = cljs.core.first(inst_26115);
var state_26132__$1 = state_26132;
var statearr_26152_26240 = state_26132__$1;
(statearr_26152_26240[(2)] = inst_26119);

(statearr_26152_26240[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26153 = [null,null,null,null,null,null,null,null,null];
(statearr_26153[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26153[(1)] = (1));

return statearr_26153;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26132){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26132);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26154){var ex__2730__auto__ = e26154;
var statearr_26155_26241 = state_26132;
(statearr_26155_26241[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26132[(4)]))){
var statearr_26156_26242 = state_26132;
(statearr_26156_26242[(1)] = cljs.core.first((state_26132[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26243 = state_26132;
state_26132 = G__26243;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26132){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26157 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26157[(6)] = c__2749__auto__);

return statearr_26157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26193){
var state_val_26194 = (state_26193[(1)]);
if((state_val_26194 === (7))){
var inst_26167 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26193__$1 = state_26193;
var statearr_26195_26244 = state_26193__$1;
(statearr_26195_26244[(2)] = inst_26167);

(statearr_26195_26244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (1))){
var state_26193__$1 = state_26193;
var statearr_26196_26245 = state_26193__$1;
(statearr_26196_26245[(2)] = null);

(statearr_26196_26245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (4))){
var inst_26158 = (state_26193[(2)]);
var state_26193__$1 = state_26193;
var statearr_26197_26246 = state_26193__$1;
(statearr_26197_26246[(2)] = inst_26158);

(statearr_26197_26246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (15))){
var inst_26188 = (state_26193[(2)]);
var _ = (function (){var statearr_26198 = state_26193;
(statearr_26198[(4)] = cljs.core.rest((state_26193[(4)])));

return statearr_26198;
})();
var state_26193__$1 = state_26193;
var statearr_26199_26247 = state_26193__$1;
(statearr_26199_26247[(2)] = inst_26188);

(statearr_26199_26247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (13))){
var inst_26173 = (state_26193[(7)]);
var inst_26179 = clojure.string.includes_QMARK_(inst_26173,":");
var state_26193__$1 = state_26193;
if(inst_26179){
var statearr_26200_26248 = state_26193__$1;
(statearr_26200_26248[(1)] = (16));

} else {
var statearr_26201_26249 = state_26193__$1;
(statearr_26201_26249[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (6))){
var state_26193__$1 = state_26193;
var statearr_26202_26250 = state_26193__$1;
(statearr_26202_26250[(2)] = pred);

(statearr_26202_26250[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (17))){
var inst_26173 = (state_26193[(7)]);
var state_26193__$1 = state_26193;
var statearr_26203_26251 = state_26193__$1;
(statearr_26203_26251[(2)] = inst_26173);

(statearr_26203_26251[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (3))){
var inst_26191 = (state_26193[(2)]);
var state_26193__$1 = state_26193;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26193__$1,inst_26191);
} else {
if((state_val_26194 === (12))){
var inst_26177 = (state_26193[(2)]);
var state_26193__$1 = state_26193;
if(cljs.core.truth_(inst_26177)){
var statearr_26204_26252 = state_26193__$1;
(statearr_26204_26252[(1)] = (13));

} else {
var statearr_26205_26253 = state_26193__$1;
(statearr_26205_26253[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (2))){
var _ = (function (){var statearr_26206 = state_26193;
(statearr_26206[(4)] = cljs.core.cons((5),(state_26193[(4)])));

return statearr_26206;
})();
var inst_26164 = typeof pred === 'string';
var state_26193__$1 = state_26193;
if(cljs.core.truth_(inst_26164)){
var statearr_26207_26254 = state_26193__$1;
(statearr_26207_26254[(1)] = (6));

} else {
var statearr_26208_26255 = state_26193__$1;
(statearr_26208_26255[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (11))){
var inst_26169 = (state_26193[(8)]);
var state_26193__$1 = state_26193;
var statearr_26210_26256 = state_26193__$1;
(statearr_26210_26256[(2)] = inst_26169);

(statearr_26210_26256[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (9))){
var inst_26169 = (state_26193[(8)]);
var inst_26172 = (state_26193[(2)]);
var inst_26173 = fluree.db.util.async.throw_err(inst_26172);
var state_26193__$1 = (function (){var statearr_26211 = state_26193;
(statearr_26211[(7)] = inst_26173);

return statearr_26211;
})();
if(cljs.core.truth_(inst_26169)){
var statearr_26212_26257 = state_26193__$1;
(statearr_26212_26257[(1)] = (10));

} else {
var statearr_26213_26258 = state_26193__$1;
(statearr_26213_26258[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (5))){
var _ = (function (){var statearr_26214 = state_26193;
(statearr_26214[(4)] = cljs.core.rest((state_26193[(4)])));

return statearr_26214;
})();
var state_26193__$1 = state_26193;
var ex26209 = (state_26193__$1[(2)]);
var statearr_26215_26259 = state_26193__$1;
(statearr_26215_26259[(5)] = ex26209);


if((ex26209 instanceof Error)){
var statearr_26216_26260 = state_26193__$1;
(statearr_26216_26260[(1)] = (4));

(statearr_26216_26260[(5)] = null);

} else {
throw ex26209;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (14))){
var state_26193__$1 = state_26193;
var statearr_26217_26261 = state_26193__$1;
(statearr_26217_26261[(2)] = null);

(statearr_26217_26261[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (16))){
var inst_26173 = (state_26193[(7)]);
var inst_26181 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_26173,/:/);
var inst_26182 = cljs.core.second(inst_26181);
var state_26193__$1 = state_26193;
var statearr_26218_26262 = state_26193__$1;
(statearr_26218_26262[(2)] = inst_26182);

(statearr_26218_26262[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (10))){
var inst_26173 = (state_26193[(7)]);
var state_26193__$1 = state_26193;
var statearr_26219_26263 = state_26193__$1;
(statearr_26219_26263[(2)] = inst_26173);

(statearr_26219_26263[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (18))){
var inst_26185 = (state_26193[(2)]);
var state_26193__$1 = state_26193;
var statearr_26220_26264 = state_26193__$1;
(statearr_26220_26264[(2)] = inst_26185);

(statearr_26220_26264[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26194 === (8))){
var inst_26169 = (state_26193[(2)]);
var inst_26170 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_26193__$1 = (function (){var statearr_26221 = state_26193;
(statearr_26221[(8)] = inst_26169);

return statearr_26221;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26193__$1,(9),inst_26170);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26222 = [null,null,null,null,null,null,null,null,null];
(statearr_26222[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26222[(1)] = (1));

return statearr_26222;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26193){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26193);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26223){var ex__2730__auto__ = e26223;
var statearr_26224_26265 = state_26193;
(statearr_26224_26265[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26193[(4)]))){
var statearr_26225_26266 = state_26193;
(statearr_26225_26266[(1)] = cljs.core.first((state_26193[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26267 = state_26193;
state_26193 = G__26267;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26193){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26226 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26226[(6)] = c__2749__auto__);

return statearr_26226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__26269 = arguments.length;
switch (G__26269) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26302){
var state_val_26303 = (state_26302[(1)]);
if((state_val_26303 === (7))){
var state_26302__$1 = state_26302;
var statearr_26304_26392 = state_26302__$1;
(statearr_26304_26392[(2)] = null);

(statearr_26304_26392[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26303 === (1))){
var state_26302__$1 = state_26302;
var statearr_26305_26393 = state_26302__$1;
(statearr_26305_26393[(2)] = null);

(statearr_26305_26393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26303 === (4))){
var inst_26270 = (state_26302[(2)]);
var state_26302__$1 = state_26302;
var statearr_26306_26394 = state_26302__$1;
(statearr_26306_26394[(2)] = inst_26270);

(statearr_26306_26394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26303 === (6))){
var inst_26285 = (state_26302[(7)]);
var inst_26284 = (state_26302[(2)]);
var inst_26285__$1 = fluree.db.util.async.throw_err(inst_26284);
var inst_26286 = (inst_26285__$1 == null);
var state_26302__$1 = (function (){var statearr_26307 = state_26302;
(statearr_26307[(7)] = inst_26285__$1);

return statearr_26307;
})();
if(cljs.core.truth_(inst_26286)){
var statearr_26308_26395 = state_26302__$1;
(statearr_26308_26395[(1)] = (7));

} else {
var statearr_26309_26396 = state_26302__$1;
(statearr_26309_26396[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26303 === (3))){
var inst_26300 = (state_26302[(2)]);
var state_26302__$1 = state_26302;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26302__$1,inst_26300);
} else {
if((state_val_26303 === (12))){
var inst_26297 = (state_26302[(2)]);
var _ = (function (){var statearr_26310 = state_26302;
(statearr_26310[(4)] = cljs.core.rest((state_26302[(4)])));

return statearr_26310;
})();
var state_26302__$1 = state_26302;
var statearr_26311_26397 = state_26302__$1;
(statearr_26311_26397[(2)] = inst_26297);

(statearr_26311_26397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26303 === (2))){
var _ = (function (){var statearr_26312 = state_26302;
(statearr_26312[(4)] = cljs.core.cons((5),(state_26302[(4)])));

return statearr_26312;
})();
var inst_26276 = (30);
var inst_26278 = fluree.db.dbproto._rootdb(this$);
var inst_26279 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26280 = [inst_26276,tag_name];
var inst_26281 = (new cljs.core.PersistentVector(null,2,(5),inst_26279,inst_26280,null));
var inst_26282 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_26278,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26281);
var state_26302__$1 = state_26302;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26302__$1,(6),inst_26282);
} else {
if((state_val_26303 === (11))){
var inst_26291 = (state_26302[(8)]);
var inst_26295 = fluree.db.flake.s(inst_26291);
var state_26302__$1 = state_26302;
var statearr_26314_26398 = state_26302__$1;
(statearr_26314_26398[(2)] = inst_26295);

(statearr_26314_26398[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26303 === (9))){
var inst_26291 = (state_26302[(8)]);
var inst_26291__$1 = (state_26302[(2)]);
var inst_26292 = (inst_26291__$1 == null);
var state_26302__$1 = (function (){var statearr_26315 = state_26302;
(statearr_26315[(8)] = inst_26291__$1);

return statearr_26315;
})();
if(cljs.core.truth_(inst_26292)){
var statearr_26316_26399 = state_26302__$1;
(statearr_26316_26399[(1)] = (10));

} else {
var statearr_26317_26400 = state_26302__$1;
(statearr_26317_26400[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26303 === (5))){
var _ = (function (){var statearr_26318 = state_26302;
(statearr_26318[(4)] = cljs.core.rest((state_26302[(4)])));

return statearr_26318;
})();
var state_26302__$1 = state_26302;
var ex26313 = (state_26302__$1[(2)]);
var statearr_26319_26401 = state_26302__$1;
(statearr_26319_26401[(5)] = ex26313);


if((ex26313 instanceof Error)){
var statearr_26320_26402 = state_26302__$1;
(statearr_26320_26402[(1)] = (4));

(statearr_26320_26402[(5)] = null);

} else {
throw ex26313;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26303 === (10))){
var state_26302__$1 = state_26302;
var statearr_26321_26403 = state_26302__$1;
(statearr_26321_26403[(2)] = null);

(statearr_26321_26403[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26303 === (8))){
var inst_26285 = (state_26302[(7)]);
var inst_26289 = cljs.core.first(inst_26285);
var state_26302__$1 = state_26302;
var statearr_26322_26404 = state_26302__$1;
(statearr_26322_26404[(2)] = inst_26289);

(statearr_26322_26404[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26323 = [null,null,null,null,null,null,null,null,null];
(statearr_26323[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26323[(1)] = (1));

return statearr_26323;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26302){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26302);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26324){var ex__2730__auto__ = e26324;
var statearr_26325_26405 = state_26302;
(statearr_26325_26405[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26302[(4)]))){
var statearr_26326_26406 = state_26302;
(statearr_26326_26406[(1)] = cljs.core.first((state_26302[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26407 = state_26302;
state_26302 = G__26407;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26302){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26327 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26327[(6)] = c__2749__auto__);

return statearr_26327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26362){
var state_val_26363 = (state_26362[(1)]);
if((state_val_26363 === (7))){
var inst_26341 = typeof pred === 'string';
var state_26362__$1 = state_26362;
if(cljs.core.truth_(inst_26341)){
var statearr_26364_26408 = state_26362__$1;
(statearr_26364_26408[(1)] = (10));

} else {
var statearr_26365_26409 = state_26362__$1;
(statearr_26365_26409[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26363 === (1))){
var state_26362__$1 = state_26362;
var statearr_26366_26410 = state_26362__$1;
(statearr_26366_26410[(2)] = null);

(statearr_26366_26410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26363 === (4))){
var inst_26328 = (state_26362[(2)]);
var state_26362__$1 = state_26362;
var statearr_26367_26411 = state_26362__$1;
(statearr_26367_26411[(2)] = inst_26328);

(statearr_26367_26411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26363 === (15))){
var inst_26355 = (state_26362[(2)]);
var state_26362__$1 = state_26362;
var statearr_26368_26412 = state_26362__$1;
(statearr_26368_26412[(2)] = inst_26355);

(statearr_26368_26412[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26363 === (13))){
var inst_26346 = (state_26362[(7)]);
var inst_26348 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26346),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_26349 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_26348);
var state_26362__$1 = state_26362;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26362__$1,(16),inst_26349);
} else {
if((state_val_26363 === (6))){
var inst_26336 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_26362__$1 = state_26362;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26362__$1,(9),inst_26336);
} else {
if((state_val_26363 === (3))){
var inst_26360 = (state_26362[(2)]);
var state_26362__$1 = state_26362;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26362__$1,inst_26360);
} else {
if((state_val_26363 === (12))){
var inst_26346 = (state_26362[(7)]);
var inst_26346__$1 = (state_26362[(2)]);
var state_26362__$1 = (function (){var statearr_26369 = state_26362;
(statearr_26369[(7)] = inst_26346__$1);

return statearr_26369;
})();
if(cljs.core.truth_(inst_26346__$1)){
var statearr_26370_26413 = state_26362__$1;
(statearr_26370_26413[(1)] = (13));

} else {
var statearr_26371_26414 = state_26362__$1;
(statearr_26371_26414[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26363 === (2))){
var _ = (function (){var statearr_26372 = state_26362;
(statearr_26372[(4)] = cljs.core.cons((5),(state_26362[(4)])));

return statearr_26372;
})();
var inst_26334 = clojure.string.includes_QMARK_(tag_name,"/");
var state_26362__$1 = state_26362;
if(inst_26334){
var statearr_26373_26415 = state_26362__$1;
(statearr_26373_26415[(1)] = (6));

} else {
var statearr_26374_26416 = state_26362__$1;
(statearr_26374_26416[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26363 === (11))){
var inst_26344 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26362__$1 = state_26362;
var statearr_26376_26417 = state_26362__$1;
(statearr_26376_26417[(2)] = inst_26344);

(statearr_26376_26417[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26363 === (9))){
var inst_26338 = (state_26362[(2)]);
var inst_26339 = fluree.db.util.async.throw_err(inst_26338);
var state_26362__$1 = state_26362;
var statearr_26377_26418 = state_26362__$1;
(statearr_26377_26418[(2)] = inst_26339);

(statearr_26377_26418[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26363 === (5))){
var _ = (function (){var statearr_26378 = state_26362;
(statearr_26378[(4)] = cljs.core.rest((state_26362[(4)])));

return statearr_26378;
})();
var state_26362__$1 = state_26362;
var ex26375 = (state_26362__$1[(2)]);
var statearr_26379_26419 = state_26362__$1;
(statearr_26379_26419[(5)] = ex26375);


if((ex26375 instanceof Error)){
var statearr_26380_26420 = state_26362__$1;
(statearr_26380_26420[(1)] = (4));

(statearr_26380_26420[(5)] = null);

} else {
throw ex26375;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26363 === (14))){
var state_26362__$1 = state_26362;
var statearr_26381_26421 = state_26362__$1;
(statearr_26381_26421[(2)] = null);

(statearr_26381_26421[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26363 === (16))){
var inst_26351 = (state_26362[(2)]);
var inst_26352 = fluree.db.util.async.throw_err(inst_26351);
var state_26362__$1 = state_26362;
var statearr_26382_26422 = state_26362__$1;
(statearr_26382_26422[(2)] = inst_26352);

(statearr_26382_26422[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26363 === (10))){
var state_26362__$1 = state_26362;
var statearr_26383_26423 = state_26362__$1;
(statearr_26383_26423[(2)] = pred);

(statearr_26383_26423[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26363 === (8))){
var inst_26357 = (state_26362[(2)]);
var _ = (function (){var statearr_26384 = state_26362;
(statearr_26384[(4)] = cljs.core.rest((state_26362[(4)])));

return statearr_26384;
})();
var state_26362__$1 = state_26362;
var statearr_26385_26424 = state_26362__$1;
(statearr_26385_26424[(2)] = inst_26357);

(statearr_26385_26424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26386 = [null,null,null,null,null,null,null,null];
(statearr_26386[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26386[(1)] = (1));

return statearr_26386;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26362){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26362);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26387){var ex__2730__auto__ = e26387;
var statearr_26388_26425 = state_26362;
(statearr_26388_26425[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26362[(4)]))){
var statearr_26389_26426 = state_26362;
(statearr_26389_26426[(1)] = cljs.core.first((state_26362[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26427 = state_26362;
state_26362 = G__26427;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26362){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26390 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26390[(6)] = c__2749__auto__);

return statearr_26390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.tspo = tspo;
this.schema = schema;
this.settings = settings;
this.comparators = comparators;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k26429,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__26433 = k26429;
var G__26433__$1 = (((G__26433 instanceof cljs.core.Keyword))?G__26433.fqn:null);
switch (G__26433__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "tspo":
return self__.tspo;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "comparators":
return self__.comparators;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26429,else__4505__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__26434){
var vec__26435 = p__26434;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26435,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26435,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26428){
var self__ = this;
var G__26428__$1 = this;
return (new cljs.core.RecordIter((0),G__26428__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__26438 = (function (coll__4499__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__26438(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26430,other26431){
var self__ = this;
var this26430__$1 = this;
return (((!((other26431 == null)))) && ((((this26430__$1.constructor === other26431.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.conn,other26431.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.network,other26431.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.ledger_id,other26431.ledger_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.block,other26431.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.t,other26431.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.tt_id,other26431.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.stats,other26431.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.spot,other26431.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.psot,other26431.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.post,other26431.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.opst,other26431.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.tspo,other26431.tspo)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.schema,other26431.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.settings,other26431.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.comparators,other26431.comparators)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.schema_cache,other26431.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.novelty,other26431.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.permissions,other26431.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.fork,other26431.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.fork_block,other26431.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.current_db_fn,other26431.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26430__$1.__extmap,other26431.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k26429){
var self__ = this;
var this__4509__auto____$1 = this;
var G__26439 = k26429;
var G__26439__$1 = (((G__26439 instanceof cljs.core.Keyword))?G__26439.fqn:null);
switch (G__26439__$1) {
case "conn":
case "network":
case "ledger-id":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "tspo":
case "schema":
case "settings":
case "comparators":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k26429);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__26428){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__26440 = cljs.core.keyword_identical_QMARK_;
var expr__26441 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__26443 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__26444 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26443,G__26444) : pred__26440.call(null,G__26443,G__26444));
})())){
return (new fluree.db.graphdb.GraphDb(G__26428,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26445 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__26446 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26445,G__26446) : pred__26440.call(null,G__26445,G__26446));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__26428,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26447 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015);
var G__26448 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26447,G__26448) : pred__26440.call(null,G__26447,G__26448));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__26428,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26449 = new cljs.core.Keyword(null,"block","block",664686210);
var G__26450 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26449,G__26450) : pred__26440.call(null,G__26449,G__26450));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,G__26428,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26451 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__26452 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26451,G__26452) : pred__26440.call(null,G__26451,G__26452));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,G__26428,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26453 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__26454 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26453,G__26454) : pred__26440.call(null,G__26453,G__26454));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,G__26428,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26455 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__26456 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26455,G__26456) : pred__26440.call(null,G__26455,G__26456));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,G__26428,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26457 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__26458 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26457,G__26458) : pred__26440.call(null,G__26457,G__26458));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,G__26428,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26459 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__26460 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26459,G__26460) : pred__26440.call(null,G__26459,G__26460));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__26428,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26461 = new cljs.core.Keyword(null,"post","post",269697687);
var G__26462 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26461,G__26462) : pred__26440.call(null,G__26461,G__26462));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__26428,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26463 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__26464 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26463,G__26464) : pred__26440.call(null,G__26463,G__26464));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__26428,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26465 = new cljs.core.Keyword(null,"tspo","tspo",-440144953);
var G__26466 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26465,G__26466) : pred__26440.call(null,G__26465,G__26466));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__26428,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26467 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__26468 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26467,G__26468) : pred__26440.call(null,G__26467,G__26468));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,G__26428,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26469 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__26470 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26469,G__26470) : pred__26440.call(null,G__26469,G__26470));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,G__26428,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26471 = new cljs.core.Keyword(null,"comparators","comparators",-1325611955);
var G__26472 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26471,G__26472) : pred__26440.call(null,G__26471,G__26472));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,G__26428,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26473 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__26474 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26473,G__26474) : pred__26440.call(null,G__26473,G__26474));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,G__26428,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26475 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__26476 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26475,G__26476) : pred__26440.call(null,G__26475,G__26476));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,G__26428,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26477 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__26478 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26477,G__26478) : pred__26440.call(null,G__26477,G__26478));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,G__26428,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26479 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__26480 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26479,G__26480) : pred__26440.call(null,G__26479,G__26480));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,G__26428,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26481 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__26482 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26481,G__26482) : pred__26440.call(null,G__26481,G__26482));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__26428,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26483 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__26484 = expr__26441;
return (pred__26440.cljs$core$IFn$_invoke$arity$2 ? pred__26440.cljs$core$IFn$_invoke$arity$2(G__26483,G__26484) : pred__26440.call(null,G__26483,G__26484));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__26428,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__26428),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__26428){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__26428,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"tspo","tspo",1200386574,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"comparators","comparators",314919572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__26432){
var extmap__4542__auto__ = (function (){var G__26485 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__26432,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__26432)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__26485);
} else {
return G__26485;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"tspo","tspo",-440144953).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"comparators","comparators",-1325611955).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__26432),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__26432),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),db__$1.ledger_id,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(comparators){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,clojure.data.avl.sorted_set_by(cljs.core.get.cljs$core$IFn$_invoke$arity$2(comparators,idx)));
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),fluree.db.index.types);
});
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,ledger_id,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(ledger_id)){
} else {
throw (new Error(["Assert failed: ","No ledger-id provided when creating new db.","\n","ledger-id"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.index.default_comparators);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var map__26488 = fluree.db.index.default_comparators;
var map__26488__$1 = cljs.core.__destructure_map(map__26488);
var spot_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26488__$1,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26488__$1,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26488__$1,new cljs.core.Keyword(null,"post","post",269697687));
var opst_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26488__$1,new cljs.core.Keyword(null,"opst","opst",1213963058));
var tspo_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26488__$1,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var spot = fluree.db.index.empty_branch(network,ledger_id,spot_cmp);
var psot = fluree.db.index.empty_branch(network,ledger_id,psot_cmp);
var post = fluree.db.index.empty_branch(network,ledger_id,post_cmp);
var opst = fluree.db.index.empty_branch(network,ledger_id,opst_cmp);
var tspo = fluree.db.index.empty_branch(network,ledger_id,tspo_cmp);
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,ledger_id,(0),(-1),null,stats,spot,psot,post,opst,tspo,schema,settings,fluree.db.index.default_comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
