// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__17513 = arguments.length;
switch (G__17513) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,ledger){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,ledger,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,ledger,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__17516 = arguments.length;
switch (G__17516) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___17569 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17547){
var state_val_17548 = (state_17547[(1)]);
if((state_val_17548 === (1))){
var state_17547__$1 = state_17547;
var statearr_17549_17570 = state_17547__$1;
(statearr_17549_17570[(2)] = null);

(statearr_17549_17570[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17548 === (2))){
var _ = (function (){var statearr_17550 = state_17547;
(statearr_17550[(4)] = cljs.core.cons((5),(state_17547[(4)])));

return statearr_17550;
})();
var inst_17524 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_17547__$1 = state_17547;
if(cljs.core.truth_(inst_17524)){
var statearr_17551_17571 = state_17547__$1;
(statearr_17551_17571[(1)] = (6));

} else {
var statearr_17552_17572 = state_17547__$1;
(statearr_17552_17572[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17548 === (3))){
var inst_17545 = (state_17547[(2)]);
var state_17547__$1 = state_17547;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17547__$1,inst_17545);
} else {
if((state_val_17548 === (4))){
var inst_17517 = (state_17547[(2)]);
var inst_17518 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_17517);
var state_17547__$1 = state_17547;
var statearr_17554_17573 = state_17547__$1;
(statearr_17554_17573[(2)] = inst_17518);

(statearr_17554_17573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17548 === (5))){
var _ = (function (){var statearr_17555 = state_17547;
(statearr_17555[(4)] = cljs.core.rest((state_17547[(4)])));

return statearr_17555;
})();
var state_17547__$1 = state_17547;
var ex17553 = (state_17547__$1[(2)]);
var statearr_17556_17574 = state_17547__$1;
(statearr_17556_17574[(5)] = ex17553);


var statearr_17557_17575 = state_17547__$1;
(statearr_17557_17575[(1)] = (4));

(statearr_17557_17575[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17548 === (6))){
var inst_17526 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17527 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_17528 = cljs.core.PersistentHashMap.fromArrays(inst_17526,inst_17527);
var inst_17529 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_17528);
var inst_17530 = (function(){throw inst_17529})();
var state_17547__$1 = state_17547;
var statearr_17558_17576 = state_17547__$1;
(statearr_17558_17576[(2)] = inst_17530);

(statearr_17558_17576[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17548 === (7))){
var inst_17532 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_17533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17534 = [operation,data,pc,opts];
var inst_17535 = (new cljs.core.PersistentVector(null,4,(5),inst_17533,inst_17534,null));
var inst_17536 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_17532,inst_17535);
var inst_17537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17538 = [operation,data,pc,opts];
var inst_17539 = (new cljs.core.PersistentVector(null,4,(5),inst_17537,inst_17538,null));
var inst_17540 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("Put operation on connection req-chan: ",inst_17539) : fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_17539));
var state_17547__$1 = (function (){var statearr_17559 = state_17547;
(statearr_17559[(7)] = inst_17536);

return statearr_17559;
})();
var statearr_17560_17577 = state_17547__$1;
(statearr_17560_17577[(2)] = inst_17540);

(statearr_17560_17577[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17548 === (8))){
var inst_17542 = (state_17547[(2)]);
var _ = (function (){var statearr_17561 = state_17547;
(statearr_17561[(4)] = cljs.core.rest((state_17547[(4)])));

return statearr_17561;
})();
var state_17547__$1 = state_17547;
var statearr_17562_17578 = state_17547__$1;
(statearr_17562_17578[(2)] = inst_17542);

(statearr_17562_17578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2727__auto__ = null;
var fluree$db$operations$state_machine__2727__auto____0 = (function (){
var statearr_17563 = [null,null,null,null,null,null,null,null];
(statearr_17563[(0)] = fluree$db$operations$state_machine__2727__auto__);

(statearr_17563[(1)] = (1));

return statearr_17563;
});
var fluree$db$operations$state_machine__2727__auto____1 = (function (state_17547){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17547);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17564){var ex__2730__auto__ = e17564;
var statearr_17565_17579 = state_17547;
(statearr_17565_17579[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17547[(4)]))){
var statearr_17566_17580 = state_17547;
(statearr_17566_17580[(1)] = cljs.core.first((state_17547[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17581 = state_17547;
state_17547 = G__17581;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2727__auto__ = function(state_17547){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2727__auto____1.call(this,state_17547);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2727__auto____0;
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2727__auto____1;
return fluree$db$operations$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17567 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17567[(6)] = c__2749__auto___17569);

return statearr_17567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__17583 = arguments.length;
switch (G__17583) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__17584){
var map__17585 = p__17584;
var map__17585__$1 = cljs.core.__destructure_map(map__17585);
var opts = map__17585__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17585__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__17586 = session;
var map__17586__$1 = cljs.core.__destructure_map(map__17586);
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17586__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17586__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17586__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4870__auto__ = [];
var len__4864__auto___17613 = arguments.length;
var i__4865__auto___17614 = (0);
while(true){
if((i__4865__auto___17614 < len__4864__auto___17613)){
args__4870__auto__.push((arguments[i__4865__auto___17614]));

var G__17615 = (i__4865__auto___17614 + (1));
i__4865__auto___17614 = G__17615;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__17590){
var vec__17591 = p__17590;
var map__17594 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17591,(0),null);
var map__17594__$1 = cljs.core.__destructure_map(map__17594);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17594__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17594__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__17591;
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17606){
var state_val_17607 = (state_17606[(1)]);
if((state_val_17607 === (1))){
var inst_17596 = session;
var inst_17597 = cljs.core.__destructure_map(inst_17596);
var inst_17598 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17597,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17599 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17597,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17600 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17597,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17601 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_17602 = [inst_17598,inst_17599,toBlock,toTime];
var inst_17603 = cljs.core.PersistentHashMap.fromArrays(inst_17601,inst_17602);
var inst_17604 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_17600,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_17603);
var state_17606__$1 = state_17606;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17606__$1,inst_17604);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2727__auto__ = null;
var fluree$db$operations$state_machine__2727__auto____0 = (function (){
var statearr_17608 = [null,null,null,null,null,null,null];
(statearr_17608[(0)] = fluree$db$operations$state_machine__2727__auto__);

(statearr_17608[(1)] = (1));

return statearr_17608;
});
var fluree$db$operations$state_machine__2727__auto____1 = (function (state_17606){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17606);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17609){var ex__2730__auto__ = e17609;
var statearr_17610_17616 = state_17606;
(statearr_17610_17616[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17606[(4)]))){
var statearr_17611_17617 = state_17606;
(statearr_17611_17617[(1)] = cljs.core.first((state_17606[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17618 = state_17606;
state_17606 = G__17618;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2727__auto__ = function(state_17606){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2727__auto____1.call(this,state_17606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2727__auto____0;
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2727__auto____1;
return fluree$db$operations$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17612 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17612[(6)] = c__2749__auto__);

return statearr_17612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq17588){
var G__17589 = cljs.core.first(seq17588);
var seq17588__$1 = cljs.core.next(seq17588);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17589,seq17588__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__17619 = session;
var map__17619__$1 = cljs.core.__destructure_map(map__17619);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17619__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17619__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17619__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("Sending transaction async: ",tx_map) : fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__17621 = arguments.length;
switch (G__17621) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__17622 = opts;
var map__17622__$1 = cljs.core.__destructure_map(map__17622);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17622__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17622__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4253__auto__ = auth;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return jwt;
}
})();
var _ = (function (){var G__17623 = "Subscribe to: ";
var G__17624 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var G__17625 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var G__17626 = auth_or_jwt;
return (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$4(G__17623,G__17624,G__17625,G__17626) : fluree.db.util.log.trace.call(null,G__17623,G__17624,G__17625,G__17626));
})();
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsubscribe","unsubscribe",632650147),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null));
});
