// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.query.analytical_parse');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e19349){var e = e19349;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__19350_SHARP_){
var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__19350_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__19350_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__19350_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__19350_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19351_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19351_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19352_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19352_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
if(and__4251__auto__){
return fluree.db.query.analytical_parse.query_fn_QMARK_(key);
} else {
return and__4251__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4253__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__19357 = fluree.db.query.analytical_filter.extract_filter_fn(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19357,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19357,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19353_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19353_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4251__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4251__auto__;
}
})())){
var vec__19360 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19360,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19360,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4253__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19354_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19354_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19355_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19355_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19356_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19356_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19363_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__19363_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (add_amount > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fuel;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4251__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5802__auto__ = (function (){var G__19364 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__19364) : intersecting_vars.call(null,G__19364));
})();
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__19367,optional_QMARK_,fuel,max_fuel){
var map__19368 = p__19367;
var map__19368__$1 = cljs.core.__destructure_map(map__19368);
var res = map__19368__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19368__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19434){
var state_val_19435 = (state_19434[(1)]);
if((state_val_19435 === (7))){
var inst_19423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19424 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_19425 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_19424,clause);
var inst_19426 = [null,inst_19425];
var inst_19427 = (new cljs.core.PersistentVector(null,2,(5),inst_19423,inst_19426,null));
var state_19434__$1 = state_19434;
var statearr_19436_19464 = state_19434__$1;
(statearr_19436_19464[(2)] = inst_19427);

(statearr_19436_19464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19435 === (1))){
var state_19434__$1 = state_19434;
var statearr_19437_19465 = state_19434__$1;
(statearr_19437_19465[(2)] = null);

(statearr_19437_19465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19435 === (4))){
var inst_19369 = (state_19434[(2)]);
var state_19434__$1 = state_19434;
var statearr_19438_19466 = state_19434__$1;
(statearr_19438_19466[(2)] = inst_19369);

(statearr_19438_19466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19435 === (15))){
var inst_19412 = (state_19434[(2)]);
var inst_19413 = fluree.db.util.async.throw_err(inst_19412);
var inst_19414 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_19413);
var inst_19415 = cljs.core.count(inst_19414);
var inst_19416 = fluree.db.query.analytical.add_fuel(inst_19415,fuel,max_fuel);
var inst_19417 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19418 = [inst_19413,r];
var inst_19419 = (new cljs.core.PersistentVector(null,2,(5),inst_19417,inst_19418,null));
var state_19434__$1 = (function (){var statearr_19439 = state_19434;
(statearr_19439[(7)] = inst_19416);

return statearr_19439;
})();
var statearr_19440_19467 = state_19434__$1;
(statearr_19440_19467[(2)] = inst_19419);

(statearr_19440_19467[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19435 === (13))){
var inst_19378 = (state_19434[(8)]);
var inst_19391 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_19392 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_19391);
var inst_19393 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_19378);
var inst_19394 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_19393);
var inst_19395 = cljs.core.set(inst_19394);
var inst_19396 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_19392);
var inst_19397 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_19396);
var inst_19398 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_19395,inst_19397);
var inst_19399 = (function (){var all_wd = inst_19378;
var optional = inst_19392;
var all_wd_vars = inst_19395;
var all_vars = inst_19398;
return (function (p1__19365_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__19365_SHARP_) : all_vars.call(null,p1__19365_SHARP_));
});
})();
var inst_19400 = cljs.core.keys(vars);
var inst_19401 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_19399,inst_19400);
var inst_19402 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_19401);
var inst_19403 = cljs.core.set(inst_19402);
var inst_19404 = (function (){var all_wd = inst_19378;
var optional = inst_19392;
var all_wd_vars = inst_19395;
var all_vars = inst_19398;
var intersecting_vars = inst_19403;
return (function (p1__19366_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__19366_SHARP_);
});
})();
var inst_19405 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_19404,inst_19378);
var inst_19406 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_19405);
var inst_19407 = fluree.db.query.analytical.select_from_tuples(inst_19406,res);
var inst_19408 = fluree.db.query.analytical.replace_vars_wikidata(inst_19378,inst_19403,vars);
var inst_19409 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_19403,inst_19398);
var inst_19410 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_19408,inst_19406,inst_19407,inst_19409,inst_19392);
var state_19434__$1 = state_19434;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19434__$1,(15),inst_19410);
} else {
if((state_val_19435 === (6))){
var inst_19379 = (state_19434[(9)]);
var inst_19377 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_19378 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_19377);
var inst_19379__$1 = optional_QMARK_;
var state_19434__$1 = (function (){var statearr_19441 = state_19434;
(statearr_19441[(9)] = inst_19379__$1);

(statearr_19441[(8)] = inst_19378);

return statearr_19441;
})();
if(cljs.core.truth_(inst_19379__$1)){
var statearr_19442_19468 = state_19434__$1;
(statearr_19442_19468[(1)] = (9));

} else {
var statearr_19443_19469 = state_19434__$1;
(statearr_19443_19469[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19435 === (3))){
var inst_19432 = (state_19434[(2)]);
var state_19434__$1 = state_19434;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19434__$1,inst_19432);
} else {
if((state_val_19435 === (12))){
var inst_19387 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19388 = [null,r];
var inst_19389 = (new cljs.core.PersistentVector(null,2,(5),inst_19387,inst_19388,null));
var state_19434__$1 = state_19434;
var statearr_19444_19470 = state_19434__$1;
(statearr_19444_19470[(2)] = inst_19389);

(statearr_19444_19470[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19435 === (2))){
var _ = (function (){var statearr_19445 = state_19434;
(statearr_19445[(4)] = cljs.core.cons((5),(state_19434[(4)])));

return statearr_19445;
})();
var inst_19375 = (r == null);
var state_19434__$1 = state_19434;
if(cljs.core.truth_(inst_19375)){
var statearr_19446_19471 = state_19434__$1;
(statearr_19446_19471[(1)] = (6));

} else {
var statearr_19447_19472 = state_19434__$1;
(statearr_19447_19472[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19435 === (11))){
var inst_19385 = (state_19434[(2)]);
var state_19434__$1 = state_19434;
if(cljs.core.truth_(inst_19385)){
var statearr_19449_19473 = state_19434__$1;
(statearr_19449_19473[(1)] = (12));

} else {
var statearr_19450_19474 = state_19434__$1;
(statearr_19450_19474[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19435 === (9))){
var inst_19378 = (state_19434[(8)]);
var inst_19381 = cljs.core.empty_QMARK_(inst_19378);
var inst_19382 = (!(inst_19381));
var state_19434__$1 = state_19434;
var statearr_19451_19475 = state_19434__$1;
(statearr_19451_19475[(2)] = inst_19382);

(statearr_19451_19475[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19435 === (5))){
var _ = (function (){var statearr_19452 = state_19434;
(statearr_19452[(4)] = cljs.core.rest((state_19434[(4)])));

return statearr_19452;
})();
var state_19434__$1 = state_19434;
var ex19448 = (state_19434__$1[(2)]);
var statearr_19453_19476 = state_19434__$1;
(statearr_19453_19476[(5)] = ex19448);


if((ex19448 instanceof Error)){
var statearr_19454_19477 = state_19434__$1;
(statearr_19454_19477[(1)] = (4));

(statearr_19454_19477[(5)] = null);

} else {
throw ex19448;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19435 === (14))){
var inst_19421 = (state_19434[(2)]);
var state_19434__$1 = state_19434;
var statearr_19455_19478 = state_19434__$1;
(statearr_19455_19478[(2)] = inst_19421);

(statearr_19455_19478[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19435 === (10))){
var inst_19379 = (state_19434[(9)]);
var state_19434__$1 = state_19434;
var statearr_19456_19479 = state_19434__$1;
(statearr_19456_19479[(2)] = inst_19379);

(statearr_19456_19479[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19435 === (8))){
var inst_19429 = (state_19434[(2)]);
var _ = (function (){var statearr_19457 = state_19434;
(statearr_19457[(4)] = cljs.core.rest((state_19434[(4)])));

return statearr_19457;
})();
var state_19434__$1 = state_19434;
var statearr_19458_19480 = state_19434__$1;
(statearr_19458_19480[(2)] = inst_19429);

(statearr_19458_19480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_19459 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19459[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__);

(statearr_19459[(1)] = (1));

return statearr_19459;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1 = (function (state_19434){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19434);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19460){var ex__2730__auto__ = e19460;
var statearr_19461_19481 = state_19434;
(statearr_19461_19481[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19434[(4)]))){
var statearr_19462_19482 = state_19434;
(statearr_19462_19482[(1)] = cljs.core.first((state_19434[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19483 = state_19434;
state_19434 = G__19483;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__ = function(state_19434){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1.call(this,state_19434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19463 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19463[(6)] = c__2749__auto__);

return statearr_19463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(ledger_id){
return cljs.core.re_find(/[a-z]+/,ledger_id);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(ledger_id){
return cljs.core.re_find(/[A-Z0-9]+/,ledger_id);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__19485 = arguments.length;
switch (G__19485) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19579){
var state_val_19580 = (state_19579[(1)]);
if((state_val_19580 === (7))){
var inst_19492 = (state_19579[(7)]);
var inst_19502 = clojure.string.starts_with_QMARK_(inst_19492,"$fdb");
var state_19579__$1 = state_19579;
if(inst_19502){
var statearr_19581_19630 = state_19579__$1;
(statearr_19581_19630[(1)] = (9));

} else {
var statearr_19582_19631 = state_19579__$1;
(statearr_19582_19631[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (20))){
var state_19579__$1 = state_19579;
var statearr_19583_19632 = state_19579__$1;
(statearr_19583_19632[(2)] = null);

(statearr_19583_19632[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (27))){
var inst_19542 = (state_19579[(8)]);
var state_19579__$1 = state_19579;
var statearr_19584_19633 = state_19579__$1;
(statearr_19584_19633[(2)] = inst_19542);

(statearr_19584_19633[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (1))){
var state_19579__$1 = state_19579;
var statearr_19585_19634 = state_19579__$1;
(statearr_19585_19634[(2)] = null);

(statearr_19585_19634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (24))){
var inst_19565 = (state_19579[(2)]);
var state_19579__$1 = state_19579;
var statearr_19586_19635 = state_19579__$1;
(statearr_19586_19635[(2)] = inst_19565);

(statearr_19586_19635[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (4))){
var inst_19486 = (state_19579[(2)]);
var state_19579__$1 = state_19579;
var statearr_19587_19636 = state_19579__$1;
(statearr_19587_19636[(2)] = inst_19486);

(statearr_19587_19636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (15))){
var inst_19509 = (state_19579[(9)]);
var inst_19515 = (state_19579[(2)]);
var inst_19516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19517 = cljs.core.PersistentVector.EMPTY;
var inst_19518 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_19519 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_19517,inst_19518);
var inst_19520 = [inst_19509,inst_19519];
var inst_19521 = (new cljs.core.PersistentVector(null,2,(5),inst_19516,inst_19520,null));
var state_19579__$1 = (function (){var statearr_19588 = state_19579;
(statearr_19588[(10)] = inst_19515);

return statearr_19588;
})();
var statearr_19589_19637 = state_19579__$1;
(statearr_19589_19637[(2)] = inst_19521);

(statearr_19589_19637[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (21))){
var inst_19568 = (state_19579[(2)]);
var state_19579__$1 = state_19579;
var statearr_19590_19638 = state_19579__$1;
(statearr_19590_19638[(2)] = inst_19568);

(statearr_19590_19638[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (13))){
var inst_19509 = (state_19579[(9)]);
var inst_19512 = (function(){throw inst_19509})();
var state_19579__$1 = state_19579;
var statearr_19591_19639 = state_19579__$1;
(statearr_19591_19639[(2)] = inst_19512);

(statearr_19591_19639[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (22))){
var inst_19531 = (state_19579[(11)]);
var inst_19533 = (state_19579[(12)]);
var inst_19535 = fluree.db.query.analytical.parse_block_from_source(inst_19531);
var inst_19536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19537 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_19533];
var inst_19538 = (new cljs.core.PersistentVector(null,2,(5),inst_19536,inst_19537,null));
var inst_19539 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_19538);
var state_19579__$1 = (function (){var statearr_19592 = state_19579;
(statearr_19592[(13)] = inst_19535);

return statearr_19592;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19579__$1,(25),inst_19539);
} else {
if((state_val_19580 === (29))){
var inst_19546 = (state_19579[(2)]);
var inst_19547 = fluree.db.util.async.throw_err(inst_19546);
var state_19579__$1 = state_19579;
var statearr_19593_19640 = state_19579__$1;
(statearr_19593_19640[(2)] = inst_19547);

(statearr_19593_19640[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (6))){
var inst_19495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19496 = cljs.core.PersistentVector.EMPTY;
var inst_19497 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_19498 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_19496,inst_19497);
var inst_19499 = [db,inst_19498];
var inst_19500 = (new cljs.core.PersistentVector(null,2,(5),inst_19495,inst_19499,null));
var state_19579__$1 = state_19579;
var statearr_19594_19641 = state_19579__$1;
(statearr_19594_19641[(2)] = inst_19500);

(statearr_19594_19641[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (28))){
var inst_19550 = (state_19579[(2)]);
var inst_19551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19552 = cljs.core.PersistentVector.EMPTY;
var inst_19553 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_19554 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_19552,inst_19553);
var inst_19555 = [inst_19550,inst_19554];
var inst_19556 = (new cljs.core.PersistentVector(null,2,(5),inst_19551,inst_19555,null));
var state_19579__$1 = state_19579;
var statearr_19595_19642 = state_19579__$1;
(statearr_19595_19642[(2)] = inst_19556);

(statearr_19595_19642[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (25))){
var inst_19535 = (state_19579[(13)]);
var inst_19541 = (state_19579[(2)]);
var inst_19542 = fluree.db.util.async.throw_err(inst_19541);
var state_19579__$1 = (function (){var statearr_19596 = state_19579;
(statearr_19596[(8)] = inst_19542);

return statearr_19596;
})();
if(cljs.core.truth_(inst_19535)){
var statearr_19597_19643 = state_19579__$1;
(statearr_19597_19643[(1)] = (26));

} else {
var statearr_19598_19644 = state_19579__$1;
(statearr_19598_19644[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (17))){
var state_19579__$1 = state_19579;
var statearr_19599_19645 = state_19579__$1;
(statearr_19599_19645[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (3))){
var inst_19577 = (state_19579[(2)]);
var state_19579__$1 = state_19579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19579__$1,inst_19577);
} else {
if((state_val_19580 === (12))){
var inst_19509 = (state_19579[(9)]);
var inst_19508 = (state_19579[(2)]);
var inst_19509__$1 = fluree.db.util.async.throw_err(inst_19508);
var inst_19510 = fluree.db.util.core.exception_QMARK_(inst_19509__$1);
var state_19579__$1 = (function (){var statearr_19601 = state_19579;
(statearr_19601[(9)] = inst_19509__$1);

return statearr_19601;
})();
if(inst_19510){
var statearr_19602_19646 = state_19579__$1;
(statearr_19602_19646[(1)] = (13));

} else {
var statearr_19603_19647 = state_19579__$1;
(statearr_19603_19647[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (2))){
var inst_19492 = (state_19579[(7)]);
var _ = (function (){var statearr_19604 = state_19579;
(statearr_19604[(4)] = cljs.core.cons((5),(state_19579[(4)])));

return statearr_19604;
})();
var inst_19492__$1 = cljs.core.first(clause);
var inst_19493 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_19492__$1);
var state_19579__$1 = (function (){var statearr_19605 = state_19579;
(statearr_19605[(7)] = inst_19492__$1);

return statearr_19605;
})();
if(inst_19493){
var statearr_19606_19648 = state_19579__$1;
(statearr_19606_19648[(1)] = (6));

} else {
var statearr_19607_19649 = state_19579__$1;
(statearr_19607_19649[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (23))){
var inst_19492 = (state_19579[(7)]);
var inst_19558 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19492)," is not supported in Fluree"].join('');
var inst_19559 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19560 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19561 = cljs.core.PersistentHashMap.fromArrays(inst_19559,inst_19560);
var inst_19562 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19558,inst_19561);
var inst_19563 = (function(){throw inst_19562})();
var state_19579__$1 = state_19579;
var statearr_19608_19650 = state_19579__$1;
(statearr_19608_19650[(2)] = inst_19563);

(statearr_19608_19650[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (19))){
var inst_19533 = (state_19579[(12)]);
var inst_19492 = (state_19579[(7)]);
var inst_19530 = fluree.db.query.analytical.isolate_source_name(inst_19492);
var inst_19531 = fluree.db.query.analytical.isolate_source_block(inst_19492);
var inst_19532 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_19530);
var inst_19533__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_19532);
var state_19579__$1 = (function (){var statearr_19609 = state_19579;
(statearr_19609[(11)] = inst_19531);

(statearr_19609[(12)] = inst_19533__$1);

return statearr_19609;
})();
if(cljs.core.truth_(inst_19533__$1)){
var statearr_19610_19651 = state_19579__$1;
(statearr_19610_19651[(1)] = (22));

} else {
var statearr_19611_19652 = state_19579__$1;
(statearr_19611_19652[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (11))){
var inst_19572 = (state_19579[(2)]);
var state_19579__$1 = state_19579;
var statearr_19613_19653 = state_19579__$1;
(statearr_19613_19653[(2)] = inst_19572);

(statearr_19613_19653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (9))){
var inst_19492 = (state_19579[(7)]);
var inst_19504 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_19492,(4));
var inst_19505 = fluree.db.query.analytical.parse_block_from_source(inst_19504);
var inst_19506 = fluree.db.time_travel.as_of_block(db,inst_19505);
var state_19579__$1 = state_19579;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19579__$1,(12),inst_19506);
} else {
if((state_val_19580 === (5))){
var _ = (function (){var statearr_19614 = state_19579;
(statearr_19614[(4)] = cljs.core.rest((state_19579[(4)])));

return statearr_19614;
})();
var state_19579__$1 = state_19579;
var ex19612 = (state_19579__$1[(2)]);
var statearr_19615_19654 = state_19579__$1;
(statearr_19615_19654[(5)] = ex19612);


if((ex19612 instanceof Error)){
var statearr_19616_19655 = state_19579__$1;
(statearr_19616_19655[(1)] = (4));

(statearr_19616_19655[(5)] = null);

} else {
throw ex19612;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (14))){
var state_19579__$1 = state_19579;
var statearr_19617_19656 = state_19579__$1;
(statearr_19617_19656[(2)] = null);

(statearr_19617_19656[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (26))){
var inst_19542 = (state_19579[(8)]);
var inst_19535 = (state_19579[(13)]);
var inst_19544 = fluree.db.time_travel.as_of_block(inst_19542,inst_19535);
var state_19579__$1 = state_19579;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19579__$1,(29),inst_19544);
} else {
if((state_val_19580 === (16))){
var inst_19525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19526 = ["$wd",clause];
var inst_19527 = (new cljs.core.PersistentVector(null,2,(5),inst_19525,inst_19526,null));
var state_19579__$1 = state_19579;
var statearr_19618_19657 = state_19579__$1;
(statearr_19618_19657[(2)] = inst_19527);

(statearr_19618_19657[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (10))){
var inst_19492 = (state_19579[(7)]);
var inst_19523 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_19492);
var state_19579__$1 = state_19579;
if(inst_19523){
var statearr_19619_19658 = state_19579__$1;
(statearr_19619_19658[(1)] = (16));

} else {
var statearr_19620_19659 = state_19579__$1;
(statearr_19620_19659[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (18))){
var inst_19570 = (state_19579[(2)]);
var state_19579__$1 = state_19579;
var statearr_19621_19660 = state_19579__$1;
(statearr_19621_19660[(2)] = inst_19570);

(statearr_19621_19660[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19580 === (8))){
var inst_19574 = (state_19579[(2)]);
var _ = (function (){var statearr_19622 = state_19579;
(statearr_19622[(4)] = cljs.core.rest((state_19579[(4)])));

return statearr_19622;
})();
var state_19579__$1 = state_19579;
var statearr_19623_19661 = state_19579__$1;
(statearr_19623_19661[(2)] = inst_19574);

(statearr_19623_19661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2727__auto__ = null;
var fluree$db$query$analytical$state_machine__2727__auto____0 = (function (){
var statearr_19624 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19624[(0)] = fluree$db$query$analytical$state_machine__2727__auto__);

(statearr_19624[(1)] = (1));

return statearr_19624;
});
var fluree$db$query$analytical$state_machine__2727__auto____1 = (function (state_19579){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19579);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19625){var ex__2730__auto__ = e19625;
var statearr_19626_19662 = state_19579;
(statearr_19626_19662[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19579[(4)]))){
var statearr_19627_19663 = state_19579;
(statearr_19627_19663[(1)] = cljs.core.first((state_19579[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19664 = state_19579;
state_19579 = G__19664;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2727__auto__ = function(state_19579){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2727__auto____1.call(this,state_19579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2727__auto____0;
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2727__auto____1;
return fluree$db$query$analytical$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19628 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19628[(6)] = c__2749__auto__);

return statearr_19628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__19665){
var vec__19666 = p__19665;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19666,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19666,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19669_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__19669_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__19673 = subjects;
var vec__19674 = G__19673;
var seq__19675 = cljs.core.seq(vec__19674);
var first__19676 = cljs.core.first(seq__19675);
var seq__19675__$1 = cljs.core.next(seq__19675);
var subject = first__19676;
var r = seq__19675__$1;
var acc = expanded_map;
var G__19673__$1 = G__19673;
var acc__$1 = acc;
while(true){
var vec__19680 = G__19673__$1;
var seq__19681 = cljs.core.seq(vec__19680);
var first__19682 = cljs.core.first(seq__19681);
var seq__19681__$1 = cljs.core.next(seq__19681);
var subject__$1 = first__19682;
var r__$1 = seq__19681__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__19683 = r__$1;
var G__19684 = acc__$2;
G__19673__$1 = G__19683;
acc__$1 = G__19684;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__19673__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__19680,seq__19681,first__19682,seq__19681__$1,subject__$1,r__$1,acc__$2,G__19673,vec__19674,seq__19675,first__19676,seq__19675__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4253__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__19673__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19680,seq__19681,first__19682,seq__19681__$1,subject__$1,r__$1,acc__$2,G__19673,vec__19674,seq__19675,first__19676,seq__19675__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__19673__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19680,seq__19681,first__19682,seq__19681__$1,subject__$1,r__$1,acc__$2,G__19673,vec__19674,seq__19675,first__19676,seq__19675__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__19673__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19680,seq__19681,first__19682,seq__19681__$1,subject__$1,r__$1,acc__$2,G__19673,vec__19674,seq__19675,first__19676,seq__19675__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__19673__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19680,seq__19681,first__19682,seq__19681__$1,subject__$1,r__$1,acc__$2,G__19673,vec__19674,seq__19675,first__19676,seq__19675__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__19673__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__19680,seq__19681,first__19682,seq__19681__$1,subject__$1,r__$1,acc__$2,G__19673,vec__19674,seq__19675,first__19676,seq__19675__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__19685 = r__$1;
var G__19686 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__19673__$1 = G__19685;
acc__$1 = G__19686;
continue;
} else {
var G__19687 = subjects;
var G__19688 = acc_STAR_;
G__19673__$1 = G__19687;
acc__$1 = G__19688;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19689_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__19689_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19780){
var state_val_19781 = (state_19780[(1)]);
if((state_val_19781 === (7))){
var state_19780__$1 = state_19780;
var statearr_19782_19828 = state_19780__$1;
(statearr_19782_19828[(2)] = (100));

(statearr_19782_19828[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (20))){
var inst_19729 = (state_19780[(7)]);
var state_19780__$1 = state_19780;
var statearr_19783_19829 = state_19780__$1;
(statearr_19783_19829[(2)] = inst_19729);

(statearr_19783_19829[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (1))){
var state_19780__$1 = state_19780;
var statearr_19784_19830 = state_19780__$1;
(statearr_19784_19830[(2)] = null);

(statearr_19784_19830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (24))){
var inst_19768 = (state_19780[(8)]);
var inst_19766 = (state_19780[(9)]);
var inst_19701 = (state_19780[(10)]);
var inst_19767 = (state_19780[(11)]);
var inst_19771 = (function (){var max_depth = inst_19701;
var recur_map__$1 = inst_19767;
var subjects = inst_19766;
var tuples = inst_19768;
return (function (p1__19690_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__19690_SHARP_)],null));
});
})();
var inst_19772 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_19771,inst_19768);
var inst_19773 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_19772);
var state_19780__$1 = state_19780;
var statearr_19785_19831 = state_19780__$1;
(statearr_19785_19831[(2)] = inst_19773);

(statearr_19785_19831[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (4))){
var inst_19691 = (state_19780[(2)]);
var state_19780__$1 = state_19780;
var statearr_19786_19832 = state_19780__$1;
(statearr_19786_19832[(2)] = inst_19691);

(statearr_19786_19832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (15))){
var inst_19714 = (state_19780[(12)]);
var inst_19725 = cljs.core.PersistentVector.EMPTY;
var inst_19726 = cljs.core.seq(inst_19714);
var inst_19727 = cljs.core.first(inst_19726);
var inst_19728 = cljs.core.next(inst_19726);
var inst_19729 = inst_19725;
var inst_19730 = inst_19714;
var state_19780__$1 = (function (){var statearr_19787 = state_19780;
(statearr_19787[(13)] = inst_19727);

(statearr_19787[(14)] = inst_19728);

(statearr_19787[(15)] = inst_19730);

(statearr_19787[(7)] = inst_19729);

return statearr_19787;
})();
var statearr_19788_19833 = state_19780__$1;
(statearr_19788_19833[(2)] = null);

(statearr_19788_19833[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (21))){
var inst_19750 = (state_19780[(2)]);
var state_19780__$1 = state_19780;
var statearr_19789_19834 = state_19780__$1;
(statearr_19789_19834[(2)] = inst_19750);

(statearr_19789_19834[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (13))){
var inst_19763 = (state_19780[(2)]);
var state_19780__$1 = state_19780;
var statearr_19790_19835 = state_19780__$1;
(statearr_19790_19835[(2)] = inst_19763);

(statearr_19790_19835[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (22))){
var inst_19729 = (state_19780[(7)]);
var inst_19737 = (state_19780[(16)]);
var inst_19744 = (state_19780[(2)]);
var inst_19745 = fluree.db.util.async.throw_err(inst_19744);
var inst_19746 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_19729,inst_19745);
var inst_19729__$1 = inst_19746;
var inst_19730 = inst_19737;
var state_19780__$1 = (function (){var statearr_19791 = state_19780;
(statearr_19791[(15)] = inst_19730);

(statearr_19791[(7)] = inst_19729__$1);

return statearr_19791;
})();
var statearr_19792_19836 = state_19780__$1;
(statearr_19792_19836[(2)] = null);

(statearr_19792_19836[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (6))){
var inst_19697 = (state_19780[(17)]);
var state_19780__$1 = state_19780;
var statearr_19793_19837 = state_19780__$1;
(statearr_19793_19837[(2)] = inst_19697);

(statearr_19793_19837[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (25))){
var inst_19775 = (state_19780[(2)]);
var _ = (function (){var statearr_19794 = state_19780;
(statearr_19794[(4)] = cljs.core.rest((state_19780[(4)])));

return statearr_19794;
})();
var state_19780__$1 = state_19780;
var statearr_19795_19838 = state_19780__$1;
(statearr_19795_19838[(2)] = inst_19775);

(statearr_19795_19838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (17))){
var inst_19730 = (state_19780[(15)]);
var inst_19736 = (state_19780[(18)]);
var inst_19735 = cljs.core.seq(inst_19730);
var inst_19736__$1 = cljs.core.first(inst_19735);
var inst_19737 = cljs.core.next(inst_19735);
var state_19780__$1 = (function (){var statearr_19796 = state_19780;
(statearr_19796[(16)] = inst_19737);

(statearr_19796[(18)] = inst_19736__$1);

return statearr_19796;
})();
if(cljs.core.truth_(inst_19736__$1)){
var statearr_19797_19839 = state_19780__$1;
(statearr_19797_19839[(1)] = (19));

} else {
var statearr_19798_19840 = state_19780__$1;
(statearr_19798_19840[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (3))){
var inst_19778 = (state_19780[(2)]);
var state_19780__$1 = state_19780;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19780__$1,inst_19778);
} else {
if((state_val_19781 === (12))){
var inst_19703 = (state_19780[(19)]);
var inst_19714 = (state_19780[(12)]);
var inst_19709 = cljs.core.vals(inst_19703);
var inst_19710 = cljs.core.flatten(inst_19709);
var inst_19711 = cljs.core.set(inst_19710);
var inst_19712 = cljs.core.keys(inst_19703);
var inst_19713 = cljs.core.set(inst_19712);
var inst_19714__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_19711,inst_19713);
var inst_19715 = cljs.core.empty_QMARK_(inst_19714__$1);
var state_19780__$1 = (function (){var statearr_19799 = state_19780;
(statearr_19799[(12)] = inst_19714__$1);

return statearr_19799;
})();
if(inst_19715){
var statearr_19800_19841 = state_19780__$1;
(statearr_19800_19841[(1)] = (14));

} else {
var statearr_19801_19842 = state_19780__$1;
(statearr_19801_19842[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (2))){
var inst_19697 = (state_19780[(17)]);
var _ = (function (){var statearr_19802 = state_19780;
(statearr_19802[(4)] = cljs.core.cons((5),(state_19780[(4)])));

return statearr_19802;
})();
var inst_19697__$1 = depth;
var state_19780__$1 = (function (){var statearr_19803 = state_19780;
(statearr_19803[(17)] = inst_19697__$1);

return statearr_19803;
})();
if(cljs.core.truth_(inst_19697__$1)){
var statearr_19804_19843 = state_19780__$1;
(statearr_19804_19843[(1)] = (6));

} else {
var statearr_19805_19844 = state_19780__$1;
(statearr_19805_19844[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (23))){
var inst_19768 = (state_19780[(8)]);
var state_19780__$1 = state_19780;
var statearr_19806_19845 = state_19780__$1;
(statearr_19806_19845[(2)] = inst_19768);

(statearr_19806_19845[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (19))){
var inst_19736 = (state_19780[(18)]);
var inst_19739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19740 = [inst_19736,predicate];
var inst_19741 = (new cljs.core.PersistentVector(null,2,(5),inst_19739,inst_19740,null));
var inst_19742 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_19741);
var state_19780__$1 = state_19780;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19780__$1,(22),inst_19742);
} else {
if((state_val_19781 === (11))){
var inst_19703 = (state_19780[(19)]);
var state_19780__$1 = state_19780;
var statearr_19808_19846 = state_19780__$1;
(statearr_19808_19846[(2)] = inst_19703);

(statearr_19808_19846[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (9))){
var inst_19704 = (state_19780[(20)]);
var inst_19701 = (state_19780[(10)]);
var inst_19706 = (inst_19704 >= inst_19701);
var state_19780__$1 = state_19780;
if(cljs.core.truth_(inst_19706)){
var statearr_19809_19847 = state_19780__$1;
(statearr_19809_19847[(1)] = (11));

} else {
var statearr_19810_19848 = state_19780__$1;
(statearr_19810_19848[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (5))){
var _ = (function (){var statearr_19811 = state_19780;
(statearr_19811[(4)] = cljs.core.rest((state_19780[(4)])));

return statearr_19811;
})();
var state_19780__$1 = state_19780;
var ex19807 = (state_19780__$1[(2)]);
var statearr_19812_19849 = state_19780__$1;
(statearr_19812_19849[(5)] = ex19807);


if((ex19807 instanceof Error)){
var statearr_19813_19850 = state_19780__$1;
(statearr_19813_19850[(1)] = (4));

(statearr_19813_19850[(5)] = null);

} else {
throw ex19807;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (14))){
var inst_19703 = (state_19780[(19)]);
var state_19780__$1 = state_19780;
var statearr_19814_19851 = state_19780__$1;
(statearr_19814_19851[(2)] = inst_19703);

(statearr_19814_19851[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (16))){
var inst_19761 = (state_19780[(2)]);
var state_19780__$1 = state_19780;
var statearr_19815_19852 = state_19780__$1;
(statearr_19815_19852[(2)] = inst_19761);

(statearr_19815_19852[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (10))){
var inst_19766 = (state_19780[(9)]);
var inst_19767 = (state_19780[(11)]);
var inst_19765 = (state_19780[(2)]);
var inst_19766__$1 = cljs.core.keys(inst_19765);
var inst_19767__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_19766__$1,inst_19765);
var inst_19768 = fluree.db.query.analytical.recur_map__GT_tuples(inst_19766__$1,inst_19767__$1);
var state_19780__$1 = (function (){var statearr_19816 = state_19780;
(statearr_19816[(8)] = inst_19768);

(statearr_19816[(9)] = inst_19766__$1);

(statearr_19816[(11)] = inst_19767__$1);

return statearr_19816;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_19817_19853 = state_19780__$1;
(statearr_19817_19853[(1)] = (23));

} else {
var statearr_19818_19854 = state_19780__$1;
(statearr_19818_19854[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (18))){
var inst_19703 = (state_19780[(19)]);
var inst_19704 = (state_19780[(20)]);
var inst_19752 = (state_19780[(2)]);
var inst_19753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19754 = [(0),(2)];
var inst_19755 = (new cljs.core.PersistentVector(null,2,(5),inst_19753,inst_19754,null));
var inst_19756 = fluree.db.query.analytical.get_ns_arrays(inst_19755,inst_19752);
var inst_19757 = fluree.db.query.analytical.tuples__GT_map(inst_19703,inst_19756);
var inst_19758 = (inst_19704 + (1));
var inst_19703__$1 = inst_19757;
var inst_19704__$1 = inst_19758;
var state_19780__$1 = (function (){var statearr_19819 = state_19780;
(statearr_19819[(19)] = inst_19703__$1);

(statearr_19819[(20)] = inst_19704__$1);

return statearr_19819;
})();
var statearr_19820_19855 = state_19780__$1;
(statearr_19820_19855[(2)] = null);

(statearr_19820_19855[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (8))){
var inst_19701 = (state_19780[(2)]);
var inst_19702 = recur_map;
var inst_19703 = inst_19702;
var inst_19704 = (1);
var state_19780__$1 = (function (){var statearr_19821 = state_19780;
(statearr_19821[(19)] = inst_19703);

(statearr_19821[(20)] = inst_19704);

(statearr_19821[(10)] = inst_19701);

return statearr_19821;
})();
var statearr_19822_19856 = state_19780__$1;
(statearr_19822_19856[(2)] = null);

(statearr_19822_19856[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0 = (function (){
var statearr_19823 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19823[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__);

(statearr_19823[(1)] = (1));

return statearr_19823;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1 = (function (state_19780){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19780);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19824){var ex__2730__auto__ = e19824;
var statearr_19825_19857 = state_19780;
(statearr_19825_19857[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19780[(4)]))){
var statearr_19826_19858 = state_19780;
(statearr_19826_19858[(1)] = cljs.core.first((state_19780[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19859 = state_19780;
state_19780 = G__19859;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__ = function(state_19780){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1.call(this,state_19780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19827 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19827[(6)] = c__2749__auto__);

return statearr_19827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__19860,clause,fuel,max_fuel){
var map__19861 = p__19860;
var map__19861__$1 = cljs.core.__destructure_map(map__19861);
var res = map__19861__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19861__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19861__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19861__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19972){
var state_val_19973 = (state_19972[(1)]);
if((state_val_19973 === (7))){
var inst_19878 = (state_19972[(7)]);
var state_19972__$1 = state_19972;
var statearr_19974_20027 = state_19972__$1;
(statearr_19974_20027[(2)] = inst_19878);

(statearr_19974_20027[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (20))){
var inst_19906 = (state_19972[(8)]);
var inst_19937 = typeof inst_19906 === 'number';
var state_19972__$1 = state_19972;
if(cljs.core.truth_(inst_19937)){
var statearr_19975_20028 = state_19972__$1;
(statearr_19975_20028[(1)] = (22));

} else {
var statearr_19976_20029 = state_19972__$1;
(statearr_19976_20029[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (27))){
var inst_19952 = (state_19972[(2)]);
var state_19972__$1 = state_19972;
var statearr_19977_20030 = state_19972__$1;
(statearr_19977_20030[(2)] = inst_19952);

(statearr_19977_20030[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (1))){
var state_19972__$1 = state_19972;
var statearr_19978_20031 = state_19972__$1;
(statearr_19978_20031[(2)] = null);

(statearr_19978_20031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (24))){
var inst_19954 = (state_19972[(2)]);
var state_19972__$1 = state_19972;
var statearr_19979_20032 = state_19972__$1;
(statearr_19979_20032[(2)] = inst_19954);

(statearr_19979_20032[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (4))){
var inst_19862 = (state_19972[(2)]);
var state_19972__$1 = state_19972;
var statearr_19980_20033 = state_19972__$1;
(statearr_19980_20033[(2)] = inst_19862);

(statearr_19980_20033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (15))){
var inst_19920 = (state_19972[(2)]);
var inst_19921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_19922 = fluree.db.query.analytical.variable_QMARK_(inst_19921);
var state_19972__$1 = (function (){var statearr_19981 = state_19972;
(statearr_19981[(9)] = inst_19920);

return statearr_19981;
})();
if(cljs.core.truth_(inst_19922)){
var statearr_19982_20034 = state_19972__$1;
(statearr_19982_20034[(1)] = (16));

} else {
var statearr_19983_20035 = state_19972__$1;
(statearr_19983_20035[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (21))){
var inst_19908 = (state_19972[(10)]);
var inst_19909 = (state_19972[(11)]);
var inst_19879 = (state_19972[(12)]);
var inst_19956 = (state_19972[(2)]);
var inst_19957 = fluree.db.query.analytical.tuples__GT_recur(db,inst_19909,inst_19956,inst_19879,inst_19908);
var state_19972__$1 = state_19972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19972__$1,(28),inst_19957);
} else {
if((state_val_19973 === (13))){
var inst_19888 = (state_19972[(13)]);
var inst_19912 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19888)].join('');
var inst_19913 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19914 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19915 = cljs.core.PersistentHashMap.fromArrays(inst_19913,inst_19914);
var inst_19916 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19912,inst_19915);
var inst_19917 = (function(){throw inst_19916})();
var state_19972__$1 = state_19972;
var statearr_19984_20036 = state_19972__$1;
(statearr_19984_20036[(2)] = inst_19917);

(statearr_19984_20036[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (22))){
var inst_19906 = (state_19972[(8)]);
var inst_19904 = (state_19972[(14)]);
var inst_19939 = cljs.core.PersistentHashMap.EMPTY;
var inst_19940 = cljs.core.flatten(inst_19904);
var inst_19941 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_19939,inst_19906,inst_19940);
var state_19972__$1 = state_19972;
var statearr_19985_20037 = state_19972__$1;
(statearr_19985_20037[(2)] = inst_19941);

(statearr_19985_20037[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (6))){
var inst_19890 = (state_19972[(15)]);
var state_19972__$1 = state_19972;
var statearr_19986_20038 = state_19972__$1;
(statearr_19986_20038[(2)] = inst_19890);

(statearr_19986_20038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (28))){
var inst_19959 = (state_19972[(2)]);
var inst_19960 = fluree.db.util.async.throw_err(inst_19959);
var state_19972__$1 = state_19972;
var statearr_19987_20039 = state_19972__$1;
(statearr_19987_20039[(2)] = inst_19960);

(statearr_19987_20039[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (25))){
var inst_19904 = (state_19972[(14)]);
var inst_19900 = (state_19972[(16)]);
var inst_19945 = cljs.core.PersistentHashMap.EMPTY;
var inst_19946 = cljs.core.first(inst_19900);
var inst_19947 = cljs.core.first(inst_19946);
var inst_19948 = cljs.core.flatten(inst_19904);
var inst_19949 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_19945,inst_19947,inst_19948);
var state_19972__$1 = state_19972;
var statearr_19988_20040 = state_19972__$1;
(statearr_19988_20040[(2)] = inst_19949);

(statearr_19988_20040[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (17))){
var inst_19888 = (state_19972[(13)]);
var inst_19925 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19888)].join('');
var inst_19926 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19927 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19928 = cljs.core.PersistentHashMap.fromArrays(inst_19926,inst_19927);
var inst_19929 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19925,inst_19928);
var inst_19930 = (function(){throw inst_19929})();
var state_19972__$1 = state_19972;
var statearr_19989_20041 = state_19972__$1;
(statearr_19989_20041[(2)] = inst_19930);

(statearr_19989_20041[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (3))){
var inst_19970 = (state_19972[(2)]);
var state_19972__$1 = state_19972;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19972__$1,inst_19970);
} else {
if((state_val_19973 === (12))){
var inst_19875 = (state_19972[(17)]);
var inst_19963 = (state_19972[(2)]);
var inst_19964 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_19965 = cljs.core.keys(inst_19875);
var inst_19966 = [inst_19965,vars,inst_19963];
var inst_19967 = cljs.core.PersistentHashMap.fromArrays(inst_19964,inst_19966);
var _ = (function (){var statearr_19990 = state_19972;
(statearr_19990[(4)] = cljs.core.rest((state_19972[(4)])));

return statearr_19990;
})();
var state_19972__$1 = state_19972;
var statearr_19991_20042 = state_19972__$1;
(statearr_19991_20042[(2)] = inst_19967);

(statearr_19991_20042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (2))){
var inst_19878 = (state_19972[(7)]);
var inst_19890 = (state_19972[(15)]);
var inst_19875 = (state_19972[(17)]);
var inst_19879 = (state_19972[(12)]);
var _ = (function (){var statearr_19992 = state_19972;
(statearr_19992[(4)] = cljs.core.cons((5),(state_19972[(4)])));

return statearr_19992;
})();
var inst_19872 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_19873 = cljs.core.__destructure_map(inst_19872);
var inst_19874 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19873,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_19875__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19873,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_19876 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19873,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_19877 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_19878__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_19876);
var inst_19879__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_19876);
var inst_19881 = (function (){var map__19868 = inst_19873;
var search = inst_19874;
var rel = inst_19875__$1;
var opts = inst_19876;
var common_keys = inst_19877;
var object_fn = inst_19878__$1;
var recur_depth = inst_19879__$1;
return (function (p__19880,common_key){
var vec__19993 = p__19880;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19993,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19993,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__19996 = cljs.core._EQ_;
var expr__19997 = idx_of;
if(cljs.core.truth_((pred__19996.cljs$core$IFn$_invoke$arity$2 ? pred__19996.cljs$core$IFn$_invoke$arity$2((0),expr__19997) : pred__19996.call(null,(0),expr__19997)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__19996.cljs$core$IFn$_invoke$arity$2 ? pred__19996.cljs$core$IFn$_invoke$arity$2((1),expr__19997) : pred__19996.call(null,(1),expr__19997)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__19996.cljs$core$IFn$_invoke$arity$2 ? pred__19996.cljs$core$IFn$_invoke$arity$2((2),expr__19997) : pred__19996.call(null,(2),expr__19997)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__19997)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4251__auto__ = (!(single_v_QMARK_));
if(and__4251__auto__){
var and__4251__auto____$1 = object_fn;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_19882 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19883 = cljs.core.PersistentHashMap.EMPTY;
var inst_19884 = [inst_19883,inst_19874];
var inst_19885 = (new cljs.core.PersistentVector(null,2,(5),inst_19882,inst_19884,null));
var inst_19886 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_19881,inst_19885,inst_19877);
var inst_19887 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19886,(0),null);
var inst_19888 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19886,(1),null);
var inst_19889 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_19890__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_19887);
var state_19972__$1 = (function (){var statearr_19999 = state_19972;
(statearr_19999[(7)] = inst_19878__$1);

(statearr_19999[(18)] = inst_19889);

(statearr_19999[(13)] = inst_19888);

(statearr_19999[(15)] = inst_19890__$1);

(statearr_19999[(17)] = inst_19875__$1);

(statearr_19999[(12)] = inst_19879__$1);

return statearr_19999;
})();
if(cljs.core.truth_(inst_19890__$1)){
var statearr_20000_20043 = state_19972__$1;
(statearr_20000_20043[(1)] = (6));

} else {
var statearr_20001_20044 = state_19972__$1;
(statearr_20001_20044[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (23))){
var inst_19906 = (state_19972[(8)]);
var inst_19943 = cljs.core.coll_QMARK_(inst_19906);
var state_19972__$1 = state_19972;
if(inst_19943){
var statearr_20002_20045 = state_19972__$1;
(statearr_20002_20045[(1)] = (25));

} else {
var statearr_20003_20046 = state_19972__$1;
(statearr_20003_20046[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (19))){
var inst_19904 = (state_19972[(14)]);
var inst_19934 = cljs.core.PersistentHashMap.EMPTY;
var inst_19935 = fluree.db.query.analytical.tuples__GT_map(inst_19934,inst_19904);
var state_19972__$1 = state_19972;
var statearr_20004_20047 = state_19972__$1;
(statearr_20004_20047[(2)] = inst_19935);

(statearr_20004_20047[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (11))){
var inst_19904 = (state_19972[(14)]);
var state_19972__$1 = state_19972;
var statearr_20006_20048 = state_19972__$1;
(statearr_20006_20048[(2)] = inst_19904);

(statearr_20006_20048[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (9))){
var inst_19875 = (state_19972[(17)]);
var inst_19879 = (state_19972[(12)]);
var inst_19900 = (state_19972[(16)]);
var inst_19899 = (state_19972[(2)]);
var inst_19900__$1 = fluree.db.util.async.throw_err(inst_19899);
var inst_19901 = cljs.core.count(inst_19900__$1);
var inst_19902 = fluree.db.query.analytical.add_fuel(inst_19901,fuel,max_fuel);
var inst_19903 = cljs.core.vals(inst_19875);
var inst_19904 = fluree.db.query.analytical.get_ns_arrays(inst_19903,inst_19900__$1);
var state_19972__$1 = (function (){var statearr_20007 = state_19972;
(statearr_20007[(19)] = inst_19902);

(statearr_20007[(14)] = inst_19904);

(statearr_20007[(16)] = inst_19900__$1);

return statearr_20007;
})();
if(cljs.core.truth_(inst_19879)){
var statearr_20008_20049 = state_19972__$1;
(statearr_20008_20049[(1)] = (10));

} else {
var statearr_20009_20050 = state_19972__$1;
(statearr_20009_20050[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (5))){
var _ = (function (){var statearr_20010 = state_19972;
(statearr_20010[(4)] = cljs.core.rest((state_19972[(4)])));

return statearr_20010;
})();
var state_19972__$1 = state_19972;
var ex20005 = (state_19972__$1[(2)]);
var statearr_20011_20051 = state_19972__$1;
(statearr_20011_20051[(5)] = ex20005);


if((ex20005 instanceof Error)){
var statearr_20012_20052 = state_19972__$1;
(statearr_20012_20052[(1)] = (4));

(statearr_20012_20052[(5)] = null);

} else {
throw ex20005;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (14))){
var state_19972__$1 = state_19972;
var statearr_20013_20053 = state_19972__$1;
(statearr_20013_20053[(2)] = null);

(statearr_20013_20053[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (26))){
var state_19972__$1 = state_19972;
var statearr_20014_20054 = state_19972__$1;
(statearr_20014_20054[(2)] = null);

(statearr_20014_20054[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (16))){
var state_19972__$1 = state_19972;
var statearr_20015_20055 = state_19972__$1;
(statearr_20015_20055[(2)] = null);

(statearr_20015_20055[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (10))){
var inst_19888 = (state_19972[(13)]);
var inst_19909 = (state_19972[(11)]);
var inst_19906 = cljs.core.first(inst_19888);
var inst_19907 = cljs.core.first(clause);
var inst_19908 = fluree.db.query.analytical.variable_QMARK_(inst_19907);
var inst_19909__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_19888,(1));
var inst_19910 = fluree.db.query.analytical.variable_QMARK_(inst_19909__$1);
var state_19972__$1 = (function (){var statearr_20016 = state_19972;
(statearr_20016[(8)] = inst_19906);

(statearr_20016[(10)] = inst_19908);

(statearr_20016[(11)] = inst_19909__$1);

return statearr_20016;
})();
if(cljs.core.truth_(inst_19910)){
var statearr_20017_20056 = state_19972__$1;
(statearr_20017_20056[(1)] = (13));

} else {
var statearr_20018_20057 = state_19972__$1;
(statearr_20018_20057[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (18))){
var inst_19908 = (state_19972[(10)]);
var inst_19932 = (state_19972[(2)]);
var state_19972__$1 = (function (){var statearr_20019 = state_19972;
(statearr_20019[(20)] = inst_19932);

return statearr_20019;
})();
if(cljs.core.truth_(inst_19908)){
var statearr_20020_20058 = state_19972__$1;
(statearr_20020_20058[(1)] = (19));

} else {
var statearr_20021_20059 = state_19972__$1;
(statearr_20021_20059[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19973 === (8))){
var inst_19889 = (state_19972[(18)]);
var inst_19888 = (state_19972[(13)]);
var inst_19894 = (state_19972[(2)]);
var inst_19895 = [inst_19894];
var inst_19896 = cljs.core.PersistentHashMap.fromArrays(inst_19889,inst_19895);
var inst_19897 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_19888,inst_19896);
var state_19972__$1 = state_19972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19972__$1,(9),inst_19897);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_20022 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20022[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__);

(statearr_20022[(1)] = (1));

return statearr_20022;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1 = (function (state_19972){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19972);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20023){var ex__2730__auto__ = e20023;
var statearr_20024_20060 = state_19972;
(statearr_20024_20060[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19972[(4)]))){
var statearr_20025_20061 = state_19972;
(statearr_20025_20061[(1)] = cljs.core.first((state_19972[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20062 = state_19972;
state_19972 = G__20062;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__ = function(state_19972){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1.call(this,state_19972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20026 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20026[(6)] = c__2749__auto__);

return statearr_20026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__20063,res,clause){
var map__20064 = p__20063;
var map__20064__$1 = cljs.core.__destructure_map(map__20064);
var db = map__20064__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20064__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20064__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20064__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20173){
var state_val_20174 = (state_20173[(1)]);
if((state_val_20174 === (7))){
var inst_20073 = (state_20173[(7)]);
var state_20173__$1 = state_20173;
var statearr_20175_20216 = state_20173__$1;
(statearr_20175_20216[(2)] = inst_20073);

(statearr_20175_20216[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (20))){
var state_20173__$1 = state_20173;
var statearr_20176_20217 = state_20173__$1;
(statearr_20176_20217[(2)] = null);

(statearr_20176_20217[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (1))){
var state_20173__$1 = state_20173;
var statearr_20177_20218 = state_20173__$1;
(statearr_20177_20218[(2)] = null);

(statearr_20177_20218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (24))){
var inst_20075 = (state_20173[(8)]);
var inst_20146 = (state_20173[(2)]);
var inst_20147 = fluree.db.flake.sid__GT_cid(inst_20146);
var inst_20148 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_20147);
var inst_20149 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20151 = [inst_20075];
var inst_20152 = (new cljs.core.PersistentVector(null,1,(5),inst_20150,inst_20151,null));
var inst_20153 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20155 = [inst_20148];
var inst_20156 = (new cljs.core.PersistentVector(null,1,(5),inst_20154,inst_20155,null));
var inst_20157 = [inst_20156];
var inst_20158 = (new cljs.core.PersistentVector(null,1,(5),inst_20153,inst_20157,null));
var inst_20159 = cljs.core.PersistentHashMap.EMPTY;
var inst_20160 = [inst_20152,inst_20158,inst_20159];
var inst_20161 = cljs.core.PersistentHashMap.fromArrays(inst_20149,inst_20160);
var state_20173__$1 = state_20173;
var statearr_20178_20219 = state_20173__$1;
(statearr_20178_20219[(2)] = inst_20161);

(statearr_20178_20219[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (4))){
var inst_20066 = (state_20173[(2)]);
var state_20173__$1 = state_20173;
var statearr_20179_20220 = state_20173__$1;
(statearr_20179_20220[(2)] = inst_20066);

(statearr_20179_20220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (15))){
var inst_20073 = (state_20173[(7)]);
var inst_20075 = (state_20173[(8)]);
var inst_20094 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20095 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20097 = [inst_20073];
var inst_20098 = (new cljs.core.PersistentVector(null,1,(5),inst_20096,inst_20097,null));
var inst_20099 = (function (){var subject_var = inst_20073;
var object_var = inst_20075;
var min_sid = inst_20094;
var max_sid = (0);
return (function (p1__20065_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__20065_SHARP_);
});
})();
var inst_20100 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_20094,(0));
var inst_20101 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20099,inst_20100);
var inst_20102 = cljs.core.PersistentHashMap.EMPTY;
var inst_20103 = [inst_20098,inst_20101,inst_20102];
var inst_20104 = cljs.core.PersistentHashMap.fromArrays(inst_20095,inst_20103);
var state_20173__$1 = state_20173;
var statearr_20180_20221 = state_20173__$1;
(statearr_20180_20221[(2)] = inst_20104);

(statearr_20180_20221[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (21))){
var inst_20164 = (state_20173[(2)]);
var state_20173__$1 = state_20173;
var statearr_20181_20222 = state_20173__$1;
(statearr_20181_20222[(2)] = inst_20164);

(statearr_20181_20222[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (13))){
var inst_20075 = (state_20173[(8)]);
var state_20173__$1 = state_20173;
if(cljs.core.truth_(inst_20075)){
var statearr_20182_20223 = state_20173__$1;
(statearr_20182_20223[(1)] = (19));

} else {
var statearr_20183_20224 = state_20173__$1;
(statearr_20183_20224[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (22))){
var inst_20137 = (state_20173[(9)]);
var state_20173__$1 = state_20173;
var statearr_20184_20225 = state_20173__$1;
(statearr_20184_20225[(2)] = inst_20137);

(statearr_20184_20225[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (6))){
var inst_20075 = (state_20173[(8)]);
var state_20173__$1 = state_20173;
var statearr_20185_20226 = state_20173__$1;
(statearr_20185_20226[(2)] = inst_20075);

(statearr_20185_20226[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (25))){
var inst_20143 = (state_20173[(2)]);
var inst_20144 = fluree.db.util.async.throw_err(inst_20143);
var state_20173__$1 = state_20173;
var statearr_20186_20227 = state_20173__$1;
(statearr_20186_20227[(2)] = inst_20144);

(statearr_20186_20227[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (17))){
var inst_20134 = (state_20173[(2)]);
var state_20173__$1 = state_20173;
var statearr_20187_20228 = state_20173__$1;
(statearr_20187_20228[(2)] = inst_20134);

(statearr_20187_20228[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (3))){
var inst_20171 = (state_20173[(2)]);
var state_20173__$1 = state_20173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20173__$1,inst_20171);
} else {
if((state_val_20174 === (12))){
var inst_20088 = ["_tx",null,"_block",null];
var inst_20089 = (new cljs.core.PersistentArrayMap(null,2,inst_20088,null));
var inst_20090 = (new cljs.core.PersistentHashSet(null,inst_20089,null));
var inst_20091 = cljs.core.last(clause);
var inst_20092 = (inst_20090.cljs$core$IFn$_invoke$arity$1 ? inst_20090.cljs$core$IFn$_invoke$arity$1(inst_20091) : inst_20090.call(null,inst_20091));
var state_20173__$1 = state_20173;
if(cljs.core.truth_(inst_20092)){
var statearr_20188_20229 = state_20173__$1;
(statearr_20188_20229[(1)] = (15));

} else {
var statearr_20189_20230 = state_20173__$1;
(statearr_20189_20230[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (2))){
var inst_20073 = (state_20173[(7)]);
var _ = (function (){var statearr_20190 = state_20173;
(statearr_20190[(4)] = cljs.core.cons((5),(state_20173[(4)])));

return statearr_20190;
})();
var inst_20072 = cljs.core.first(clause);
var inst_20073__$1 = fluree.db.query.analytical.variable_QMARK_(inst_20072);
var inst_20074 = cljs.core.last(clause);
var inst_20075 = fluree.db.query.analytical.variable_QMARK_(inst_20074);
var state_20173__$1 = (function (){var statearr_20191 = state_20173;
(statearr_20191[(7)] = inst_20073__$1);

(statearr_20191[(8)] = inst_20075);

return statearr_20191;
})();
if(cljs.core.truth_(inst_20073__$1)){
var statearr_20192_20231 = state_20173__$1;
(statearr_20192_20231[(1)] = (6));

} else {
var statearr_20193_20232 = state_20173__$1;
(statearr_20193_20232[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (23))){
var inst_20137 = (state_20173[(9)]);
var inst_20141 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_20137);
var state_20173__$1 = state_20173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20173__$1,(25),inst_20141);
} else {
if((state_val_20174 === (19))){
var inst_20137 = (state_20173[(9)]);
var inst_20137__$1 = cljs.core.first(clause);
var inst_20138 = typeof inst_20137__$1 === 'number';
var state_20173__$1 = (function (){var statearr_20194 = state_20173;
(statearr_20194[(9)] = inst_20137__$1);

return statearr_20194;
})();
if(cljs.core.truth_(inst_20138)){
var statearr_20195_20233 = state_20173__$1;
(statearr_20195_20233[(1)] = (22));

} else {
var statearr_20196_20234 = state_20173__$1;
(statearr_20196_20234[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (11))){
var inst_20168 = (state_20173[(2)]);
var _ = (function (){var statearr_20198 = state_20173;
(statearr_20198[(4)] = cljs.core.rest((state_20173[(4)])));

return statearr_20198;
})();
var state_20173__$1 = state_20173;
var statearr_20199_20235 = state_20173__$1;
(statearr_20199_20235[(2)] = inst_20168);

(statearr_20199_20235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (9))){
var inst_20081 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20082 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20083 = cljs.core.PersistentHashMap.fromArrays(inst_20081,inst_20082);
var inst_20084 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_20083);
var inst_20085 = (function(){throw inst_20084})();
var state_20173__$1 = state_20173;
var statearr_20200_20236 = state_20173__$1;
(statearr_20200_20236[(2)] = inst_20085);

(statearr_20200_20236[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (5))){
var _ = (function (){var statearr_20201 = state_20173;
(statearr_20201[(4)] = cljs.core.rest((state_20173[(4)])));

return statearr_20201;
})();
var state_20173__$1 = state_20173;
var ex20197 = (state_20173__$1[(2)]);
var statearr_20202_20237 = state_20173__$1;
(statearr_20202_20237[(5)] = ex20197);


if((ex20197 instanceof Error)){
var statearr_20203_20238 = state_20173__$1;
(statearr_20203_20238[(1)] = (4));

(statearr_20203_20238[(5)] = null);

} else {
throw ex20197;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (14))){
var inst_20166 = (state_20173[(2)]);
var state_20173__$1 = state_20173;
var statearr_20204_20239 = state_20173__$1;
(statearr_20204_20239[(2)] = inst_20166);

(statearr_20204_20239[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (16))){
var inst_20110 = (state_20173[(10)]);
var inst_20107 = (state_20173[(11)]);
var inst_20109 = (state_20173[(12)]);
var inst_20106 = cljs.core.last(clause);
var inst_20107__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_20106);
var inst_20108 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20109__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20108,inst_20107__$1);
var inst_20110__$1 = fluree.db.flake.min_subject_id(inst_20107__$1);
var inst_20111 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20112 = [inst_20109__$1];
var inst_20113 = (new cljs.core.PersistentVector(null,1,(5),inst_20111,inst_20112,null));
var inst_20114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20115 = [inst_20110__$1];
var inst_20116 = (new cljs.core.PersistentVector(null,1,(5),inst_20114,inst_20115,null));
var inst_20117 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20113,cljs.core._LT__EQ_,inst_20116);
var state_20173__$1 = (function (){var statearr_20205 = state_20173;
(statearr_20205[(10)] = inst_20110__$1);

(statearr_20205[(11)] = inst_20107__$1);

(statearr_20205[(12)] = inst_20109__$1);

return statearr_20205;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20173__$1,(18),inst_20117);
} else {
if((state_val_20174 === (10))){
var inst_20073 = (state_20173[(7)]);
var state_20173__$1 = state_20173;
if(cljs.core.truth_(inst_20073)){
var statearr_20206_20240 = state_20173__$1;
(statearr_20206_20240[(1)] = (12));

} else {
var statearr_20207_20241 = state_20173__$1;
(statearr_20207_20241[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (18))){
var inst_20073 = (state_20173[(7)]);
var inst_20110 = (state_20173[(10)]);
var inst_20107 = (state_20173[(11)]);
var inst_20109 = (state_20173[(12)]);
var inst_20075 = (state_20173[(8)]);
var inst_20119 = (state_20173[(2)]);
var inst_20120 = fluree.db.util.async.throw_err(inst_20119);
var inst_20121 = (function (){var subject_var = inst_20073;
var object_var = inst_20075;
var partition = inst_20107;
var max_sid = inst_20109;
var min_sid = inst_20110;
var flakes = inst_20120;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_20122 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_20121);
var inst_20123 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_20124 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_20122,inst_20123);
var inst_20125 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20127 = [inst_20073];
var inst_20128 = (new cljs.core.PersistentVector(null,1,(5),inst_20126,inst_20127,null));
var inst_20129 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_20124,inst_20120);
var inst_20130 = cljs.core.PersistentHashMap.EMPTY;
var inst_20131 = [inst_20128,inst_20129,inst_20130];
var inst_20132 = cljs.core.PersistentHashMap.fromArrays(inst_20125,inst_20131);
var state_20173__$1 = state_20173;
var statearr_20208_20242 = state_20173__$1;
(statearr_20208_20242[(2)] = inst_20132);

(statearr_20208_20242[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20174 === (8))){
var inst_20079 = (state_20173[(2)]);
var state_20173__$1 = state_20173;
if(cljs.core.truth_(inst_20079)){
var statearr_20209_20243 = state_20173__$1;
(statearr_20209_20243[(1)] = (9));

} else {
var statearr_20210_20244 = state_20173__$1;
(statearr_20210_20244[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_20211 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20211[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__);

(statearr_20211[(1)] = (1));

return statearr_20211;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1 = (function (state_20173){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20173);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20212){var ex__2730__auto__ = e20212;
var statearr_20213_20245 = state_20173;
(statearr_20213_20245[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20173[(4)]))){
var statearr_20214_20246 = state_20173;
(statearr_20214_20246[(1)] = cljs.core.first((state_20173[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20247 = state_20173;
state_20173 = G__20247;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__ = function(state_20173){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1.call(this,state_20173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20215 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20215[(6)] = c__2749__auto__);

return statearr_20215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__20254 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__20254 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__20254;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4652__auto__ = (function fluree$db$query$analytical$variance_$_iter__20255(s__20256){
return (new cljs.core.LazySeq(null,(function (){
var s__20256__$1 = s__20256;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__20256__$1);
if(temp__5804__auto__){
var s__20256__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__20256__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__20256__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__20258 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__20257 = (0);
while(true){
if((i__20257 < size__4651__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__20257);
var delta = (x - mean);
cljs.core.chunk_append(b__20258,(delta * delta));

var G__20260 = (i__20257 + (1));
i__20257 = G__20260;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__20258),fluree$db$query$analytical$variance_$_iter__20255(cljs.core.chunk_rest(s__20256__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__20258),null);
}
} else {
var x = cljs.core.first(s__20256__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__20255(cljs.core.rest(s__20256__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__20259 = variance(coll);
return Math.sqrt(G__20259);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4336__auto__ = n;
var y__4337__auto__ = (- n);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
}),(function() {
var G__20261 = null;
var G__20261__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__20261__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__20261 = function(n,coll){
switch(arguments.length){
case 1:
return G__20261__1.call(this,n);
case 2:
return G__20261__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20261.cljs$core$IFn$_invoke$arity$1 = G__20261__1;
G__20261.cljs$core$IFn$_invoke$arity$2 = G__20261__2;
return G__20261;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__20262 = null;
var G__20262__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__20262__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__20262 = function(n,coll){
switch(arguments.length){
case 1:
return G__20262__1.call(this,n);
case 2:
return G__20262__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20262.cljs$core$IFn$_invoke$arity$1 = G__20262__1;
G__20262.cljs$core$IFn$_invoke$arity$2 = G__20262__2;
return G__20262;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__20263 = null;
var G__20263__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__20263__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__20263 = function(n,coll){
switch(arguments.length){
case 1:
return G__20263__1.call(this,n);
case 2:
return G__20263__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20263.cljs$core$IFn$_invoke$arity$1 = G__20263__1;
G__20263.cljs$core$IFn$_invoke$arity$2 = G__20263__2;
return G__20263;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__20264 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20264,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20264,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20264,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20267 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__20270 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__20270) : agg_fn.call(null,G__20270));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20267,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20267,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__20271 = agg;
var map__20271__$1 = cljs.core.__destructure_map(map__20271);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20271__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20271__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var function$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20271__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (function$.cljs$core$IFn$_invoke$arity$1 ? function$.cljs$core$IFn$_invoke$arity$1(agg_params) : function$.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__20273 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20273,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20273,(1),null);
var map__20276 = res__$1;
var map__20276__$1 = cljs.core.__destructure_map(map__20276);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20276__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20276__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20272_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__20272_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20277_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__20277_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20278_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__20278_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__20279_SHARP_,p2__20280_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20279_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__20280_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20281_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__20281_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__20284,row,b_tuple){
var vec__20285 = p__20284;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20285,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20285,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20282_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__20282_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4253__auto__ = acc;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20283_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__20283_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20288_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__20288_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20289_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__20289_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__20294 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__20296 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__20295 = (function (p1__20290_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__20290_SHARP_);
});
return fexpr__20295(G__20296);
})()),cljs.core.set(b_idxs));
var fexpr__20293 = (function (p1__20291_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__20291_SHARP_);
});
return fexpr__20293(G__20294);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20292_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__20292_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20297_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__20297_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20298_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20298_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__20303 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__20305 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__20304 = (function (p1__20299_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__20299_SHARP_);
});
return fexpr__20304(G__20305);
})()),cljs.core.set(b_idxs));
var fexpr__20302 = (function (p1__20300_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__20300_SHARP_);
});
return fexpr__20302(G__20303);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20301_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20301_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__20307 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.extract_filter_fn(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20307,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20307,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__20306_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__20306_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var vec__20312 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.extract_filter_fn(filt,valid_vars);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20312,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20312,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20310_SHARP_){
return fluree.db.util.core.index_of(headers,p1__20310_SHARP_);
}),filt_vars);
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__20311_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__20311_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__20315,filters,optional_QMARK_){
var map__20316 = p__20315;
var map__20316__$1 = cljs.core.__destructure_map(map__20316);
var tuple_map = map__20316__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20316__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20316__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20316__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__20317 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20317,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20317,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__20320 = res;
var map__20320__$1 = cljs.core.__destructure_map(map__20320);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20320__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20320__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5802__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20376){
var state_val_20377 = (state_20376[(1)]);
if((state_val_20377 === (7))){
var inst_20350 = (state_20376[(7)]);
var inst_20348 = (state_20376[(2)]);
var inst_20349 = fluree.db.util.async.throw_err(inst_20348);
var inst_20350__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20349,(0),null);
var inst_20351 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20349,(1),null);
var inst_20352 = (inst_20350__$1 == null);
var state_20376__$1 = (function (){var statearr_20378 = state_20376;
(statearr_20378[(7)] = inst_20350__$1);

(statearr_20378[(8)] = inst_20351);

return statearr_20378;
})();
if(cljs.core.truth_(inst_20352)){
var statearr_20379_20408 = state_20376__$1;
(statearr_20379_20408[(1)] = (8));

} else {
var statearr_20380_20409 = state_20376__$1;
(statearr_20380_20409[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20377 === (1))){
var inst_20328 = optional_clauses;
var inst_20329 = cljs.core.seq(inst_20328);
var inst_20330 = cljs.core.first(inst_20329);
var inst_20331 = cljs.core.next(inst_20329);
var inst_20332 = where_tuples;
var inst_20333 = inst_20328;
var inst_20334 = inst_20332;
var state_20376__$1 = (function (){var statearr_20381 = state_20376;
(statearr_20381[(9)] = inst_20331);

(statearr_20381[(10)] = inst_20330);

(statearr_20381[(11)] = inst_20334);

(statearr_20381[(12)] = inst_20333);

return statearr_20381;
})();
var statearr_20382_20410 = state_20376__$1;
(statearr_20382_20410[(2)] = null);

(statearr_20382_20410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20377 === (4))){
var inst_20341 = (state_20376[(13)]);
var inst_20334 = (state_20376[(11)]);
var inst_20340 = (state_20376[(14)]);
var inst_20346 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_20334,inst_20340,inst_20341,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_20334,inst_20340,inst_20341,true,fuel,max_fuel,opts));
var state_20376__$1 = state_20376;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20376__$1,(7),inst_20346);
} else {
if((state_val_20377 === (15))){
var state_20376__$1 = state_20376;
var statearr_20383_20411 = state_20376__$1;
(statearr_20383_20411[(2)] = null);

(statearr_20383_20411[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20377 === (13))){
var inst_20367 = (state_20376[(2)]);
var state_20376__$1 = state_20376;
var statearr_20384_20412 = state_20376__$1;
(statearr_20384_20412[(2)] = inst_20367);

(statearr_20384_20412[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20377 === (6))){
var inst_20372 = (state_20376[(2)]);
var state_20376__$1 = state_20376;
var statearr_20385_20413 = state_20376__$1;
(statearr_20385_20413[(2)] = inst_20372);

(statearr_20385_20413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20377 === (3))){
var inst_20374 = (state_20376[(2)]);
var state_20376__$1 = state_20376;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20376__$1,inst_20374);
} else {
if((state_val_20377 === (12))){
var state_20376__$1 = state_20376;
var statearr_20386_20414 = state_20376__$1;
(statearr_20386_20414[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20377 === (2))){
var inst_20340 = (state_20376[(14)]);
var inst_20333 = (state_20376[(12)]);
var inst_20339 = cljs.core.seq(inst_20333);
var inst_20340__$1 = cljs.core.first(inst_20339);
var inst_20341 = cljs.core.next(inst_20339);
var state_20376__$1 = (function (){var statearr_20388 = state_20376;
(statearr_20388[(13)] = inst_20341);

(statearr_20388[(14)] = inst_20340__$1);

return statearr_20388;
})();
if(cljs.core.truth_(inst_20340__$1)){
var statearr_20389_20415 = state_20376__$1;
(statearr_20389_20415[(1)] = (4));

} else {
var statearr_20390_20416 = state_20376__$1;
(statearr_20390_20416[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20377 === (11))){
var inst_20350 = (state_20376[(7)]);
var inst_20351 = (state_20376[(8)]);
var inst_20333 = inst_20351;
var inst_20334 = inst_20350;
var state_20376__$1 = (function (){var statearr_20391 = state_20376;
(statearr_20391[(11)] = inst_20334);

(statearr_20391[(12)] = inst_20333);

return statearr_20391;
})();
var statearr_20392_20417 = state_20376__$1;
(statearr_20392_20417[(2)] = null);

(statearr_20392_20417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20377 === (9))){
var inst_20340 = (state_20376[(14)]);
var inst_20356 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_20340);
var state_20376__$1 = state_20376;
if(cljs.core.truth_(inst_20356)){
var statearr_20393_20418 = state_20376__$1;
(statearr_20393_20418[(1)] = (11));

} else {
var statearr_20394_20419 = state_20376__$1;
(statearr_20394_20419[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20377 === (5))){
var inst_20334 = (state_20376[(11)]);
var state_20376__$1 = state_20376;
var statearr_20395_20420 = state_20376__$1;
(statearr_20395_20420[(2)] = inst_20334);

(statearr_20395_20420[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20377 === (14))){
var inst_20350 = (state_20376[(7)]);
var inst_20351 = (state_20376[(8)]);
var inst_20334 = (state_20376[(11)]);
var inst_20361 = fluree.db.query.analytical.left_outer_join(inst_20334,inst_20350);
var inst_20333 = inst_20351;
var inst_20334__$1 = inst_20361;
var state_20376__$1 = (function (){var statearr_20396 = state_20376;
(statearr_20396[(11)] = inst_20334__$1);

(statearr_20396[(12)] = inst_20333);

return statearr_20396;
})();
var statearr_20397_20421 = state_20376__$1;
(statearr_20397_20421[(2)] = null);

(statearr_20397_20421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20377 === (16))){
var inst_20365 = (state_20376[(2)]);
var state_20376__$1 = state_20376;
var statearr_20399_20422 = state_20376__$1;
(statearr_20399_20422[(2)] = inst_20365);

(statearr_20399_20422[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20377 === (10))){
var inst_20369 = (state_20376[(2)]);
var state_20376__$1 = state_20376;
var statearr_20400_20423 = state_20376__$1;
(statearr_20400_20423[(2)] = inst_20369);

(statearr_20400_20423[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20377 === (8))){
var inst_20351 = (state_20376[(8)]);
var inst_20334 = (state_20376[(11)]);
var tmp20398 = inst_20334;
var inst_20333 = inst_20351;
var inst_20334__$1 = tmp20398;
var state_20376__$1 = (function (){var statearr_20401 = state_20376;
(statearr_20401[(11)] = inst_20334__$1);

(statearr_20401[(12)] = inst_20333);

return statearr_20401;
})();
var statearr_20402_20424 = state_20376__$1;
(statearr_20402_20424[(2)] = null);

(statearr_20402_20424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0 = (function (){
var statearr_20403 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20403[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__);

(statearr_20403[(1)] = (1));

return statearr_20403;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1 = (function (state_20376){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20376);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20404){var ex__2730__auto__ = e20404;
var statearr_20405_20425 = state_20376;
(statearr_20405_20425[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20376[(4)]))){
var statearr_20406_20426 = state_20376;
(statearr_20406_20426[(1)] = cljs.core.first((state_20376[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20427 = state_20376;
state_20376 = G__20427;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__ = function(state_20376){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1.call(this,state_20376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20407 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20407[(6)] = c__2749__auto__);

return statearr_20407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__20429){
var vec__20430 = p__20429;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20430,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20430,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20428_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20428_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__20434,p__20435,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__20436 = p__20434;
var map__20436__$1 = cljs.core.__destructure_map(map__20436);
var q_map = map__20436__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20436__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__20437 = p__20435;
var map__20437__$1 = cljs.core.__destructure_map(map__20437);
var res = map__20437__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20437__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20674){
var state_val_20675 = (state_20674[(1)]);
if((state_val_20675 === (65))){
var inst_20623 = (state_20674[(7)]);
var inst_20624 = (state_20674[(8)]);
var inst_20635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20636 = fluree.db.query.analytical.full_text__GT_tuples(inst_20623,res,inst_20624);
var inst_20637 = [inst_20636,r];
var inst_20638 = (new cljs.core.PersistentVector(null,2,(5),inst_20635,inst_20637,null));
var state_20674__$1 = state_20674;
var statearr_20676_20789 = state_20674__$1;
(statearr_20676_20789[(2)] = inst_20638);

(statearr_20676_20789[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (70))){
var inst_20650 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20677_20790 = state_20674__$1;
(statearr_20677_20790[(2)] = inst_20650);

(statearr_20677_20790[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (62))){
var inst_20624 = (state_20674[(8)]);
var inst_20632 = cljs.core.second(inst_20624);
var inst_20633 = clojure.string.starts_with_QMARK_(inst_20632,"fullText:");
var state_20674__$1 = state_20674;
if(inst_20633){
var statearr_20678_20791 = state_20674__$1;
(statearr_20678_20791[(1)] = (65));

} else {
var statearr_20679_20792 = state_20674__$1;
(statearr_20679_20792[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (7))){
var inst_20543 = (state_20674[(9)]);
var inst_20542 = cljs.core.count(clause);
var inst_20543__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_20542);
var state_20674__$1 = (function (){var statearr_20680 = state_20674;
(statearr_20680[(9)] = inst_20543__$1);

return statearr_20680;
})();
if(inst_20543__$1){
var statearr_20681_20793 = state_20674__$1;
(statearr_20681_20793[(1)] = (31));

} else {
var statearr_20682_20794 = state_20674__$1;
(statearr_20682_20794[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (59))){
var inst_20657 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20683_20795 = state_20674__$1;
(statearr_20683_20795[(2)] = inst_20657);

(statearr_20683_20795[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (20))){
var inst_20506 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20684_20796 = state_20674__$1;
(statearr_20684_20796[(2)] = inst_20506);

(statearr_20684_20796[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (58))){
var state_20674__$1 = state_20674;
var statearr_20685_20797 = state_20674__$1;
(statearr_20685_20797[(2)] = null);

(statearr_20685_20797[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (60))){
var inst_20623 = (state_20674[(7)]);
var inst_20621 = (state_20674[(2)]);
var inst_20622 = fluree.db.util.async.throw_err(inst_20621);
var inst_20623__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20622,(0),null);
var inst_20624 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20622,(1),null);
var inst_20625 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_20623__$1);
var state_20674__$1 = (function (){var statearr_20686 = state_20674;
(statearr_20686[(7)] = inst_20623__$1);

(statearr_20686[(8)] = inst_20624);

return statearr_20686;
})();
if(inst_20625){
var statearr_20687_20798 = state_20674__$1;
(statearr_20687_20798[(1)] = (61));

} else {
var statearr_20688_20799 = state_20674__$1;
(statearr_20688_20799[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (27))){
var inst_20536 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20689_20800 = state_20674__$1;
(statearr_20689_20800[(2)] = inst_20536);

(statearr_20689_20800[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (1))){
var state_20674__$1 = state_20674;
var statearr_20690_20801 = state_20674__$1;
(statearr_20690_20801[(2)] = null);

(statearr_20690_20801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (69))){
var state_20674__$1 = state_20674;
var statearr_20691_20802 = state_20674__$1;
(statearr_20691_20802[(2)] = null);

(statearr_20691_20802[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (24))){
var inst_20500 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20692_20803 = state_20674__$1;
(statearr_20692_20803[(2)] = inst_20500);

(statearr_20692_20803[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (55))){
var inst_20606 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_20607 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20608 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20609 = cljs.core.PersistentHashMap.fromArrays(inst_20607,inst_20608);
var inst_20610 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20606,inst_20609);
var inst_20611 = (function(){throw inst_20610})();
var state_20674__$1 = state_20674;
var statearr_20693_20804 = state_20674__$1;
(statearr_20693_20804[(2)] = inst_20611);

(statearr_20693_20804[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (39))){
var inst_20563 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
if(cljs.core.truth_(inst_20563)){
var statearr_20694_20805 = state_20674__$1;
(statearr_20694_20805[(1)] = (40));

} else {
var statearr_20695_20806 = state_20674__$1;
(statearr_20695_20806[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (46))){
var inst_20663 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20696_20807 = state_20674__$1;
(statearr_20696_20807[(2)] = inst_20663);

(statearr_20696_20807[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (4))){
var inst_20438 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20697_20808 = state_20674__$1;
(statearr_20697_20808[(2)] = inst_20438);

(statearr_20697_20808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (54))){
var inst_20599 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_20600 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20601 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20602 = cljs.core.PersistentHashMap.fromArrays(inst_20600,inst_20601);
var inst_20603 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20599,inst_20602);
var inst_20604 = (function(){throw inst_20603})();
var state_20674__$1 = state_20674;
var statearr_20698_20809 = state_20674__$1;
(statearr_20698_20809[(2)] = inst_20604);

(statearr_20698_20809[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (15))){
var inst_20538 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20699_20810 = state_20674__$1;
(statearr_20699_20810[(2)] = inst_20538);

(statearr_20699_20810[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (48))){
var inst_20587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20588 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_20589 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_20588);
var inst_20590 = [inst_20589,r];
var inst_20591 = (new cljs.core.PersistentVector(null,2,(5),inst_20587,inst_20590,null));
var state_20674__$1 = state_20674;
var statearr_20700_20811 = state_20674__$1;
(statearr_20700_20811[(2)] = inst_20591);

(statearr_20700_20811[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (50))){
var inst_20661 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20701_20812 = state_20674__$1;
(statearr_20701_20812[(2)] = inst_20661);

(statearr_20701_20812[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (21))){
var inst_20447 = (state_20674[(10)]);
var inst_20483 = (state_20674[(11)]);
var inst_20451 = (state_20674[(12)]);
var inst_20474 = (state_20674[(13)]);
var inst_20476 = (state_20674[(14)]);
var inst_20472 = (state_20674[(15)]);
var inst_20484 = (state_20674[(16)]);
var inst_20477 = (state_20674[(17)]);
var inst_20475 = (state_20674[(18)]);
var inst_20488 = (state_20674[(2)]);
var inst_20489 = fluree.db.util.async.throw_err(inst_20488);
var inst_20490 = (function (){var expr__20449 = inst_20447;
var new_res = inst_20489;
var rest = inst_20484;
var tuples = inst_20477;
var vec__20469 = inst_20472;
var pred__20448 = inst_20451;
var G__20468 = inst_20476;
var seq__20470 = inst_20475;
var first__20481 = inst_20483;
var segment_type = inst_20447;
var vec__20479 = inst_20476;
var first__20471 = inst_20474;
var seq__20480 = inst_20484;
var clause_group = inst_20483;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_20491 = cljs.core.keys(vars);
var inst_20492 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20490,inst_20489,inst_20491);
var inst_20493 = fluree.db.query.analytical.res_absorb_vars(inst_20492);
var state_20674__$1 = (function (){var statearr_20702 = state_20674;
(statearr_20702[(19)] = inst_20493);

return statearr_20702;
})();
if(cljs.core.truth_(inst_20477)){
var statearr_20703_20813 = state_20674__$1;
(statearr_20703_20813[(1)] = (22));

} else {
var statearr_20704_20814 = state_20674__$1;
(statearr_20704_20814[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (31))){
var inst_20545 = cljs.core.second(clause);
var inst_20546 = clojure.string.starts_with_QMARK_(inst_20545,"fullText:");
var state_20674__$1 = state_20674;
var statearr_20705_20815 = state_20674__$1;
(statearr_20705_20815[(2)] = inst_20546);

(statearr_20705_20815[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (32))){
var inst_20543 = (state_20674[(9)]);
var state_20674__$1 = state_20674;
var statearr_20706_20816 = state_20674__$1;
(statearr_20706_20816[(2)] = inst_20543);

(statearr_20706_20816[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (40))){
var inst_20565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20566 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_20674__$1 = (function (){var statearr_20707 = state_20674;
(statearr_20707[(20)] = inst_20565);

return statearr_20707;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20674__$1,(43),inst_20566);
} else {
if((state_val_20675 === (56))){
var inst_20613 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20708_20817 = state_20674__$1;
(statearr_20708_20817[(2)] = inst_20613);

(statearr_20708_20817[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (33))){
var inst_20549 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
if(cljs.core.truth_(inst_20549)){
var statearr_20709_20818 = state_20674__$1;
(statearr_20709_20818[(1)] = (34));

} else {
var statearr_20710_20819 = state_20674__$1;
(statearr_20710_20819[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (13))){
var inst_20472 = (state_20674[(15)]);
var inst_20472__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20473 = cljs.core.seq(inst_20472__$1);
var inst_20474 = cljs.core.first(inst_20473);
var inst_20475 = cljs.core.next(inst_20473);
var inst_20476 = inst_20472__$1;
var inst_20477 = null;
var state_20674__$1 = (function (){var statearr_20711 = state_20674;
(statearr_20711[(13)] = inst_20474);

(statearr_20711[(14)] = inst_20476);

(statearr_20711[(15)] = inst_20472__$1);

(statearr_20711[(17)] = inst_20477);

(statearr_20711[(18)] = inst_20475);

return statearr_20711;
})();
var statearr_20712_20820 = state_20674__$1;
(statearr_20712_20820[(2)] = null);

(statearr_20712_20820[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (22))){
var inst_20484 = (state_20674[(16)]);
var inst_20477 = (state_20674[(17)]);
var inst_20493 = (state_20674[(19)]);
var inst_20495 = fluree.db.query.union.results(inst_20477,inst_20493);
var inst_20476 = inst_20484;
var inst_20477__$1 = inst_20495;
var state_20674__$1 = (function (){var statearr_20713 = state_20674;
(statearr_20713[(14)] = inst_20476);

(statearr_20713[(17)] = inst_20477__$1);

return statearr_20713;
})();
var statearr_20714_20821 = state_20674__$1;
(statearr_20714_20821[(2)] = null);

(statearr_20714_20821[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (36))){
var inst_20667 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20715_20822 = state_20674__$1;
(statearr_20715_20822[(2)] = inst_20667);

(statearr_20715_20822[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (41))){
var inst_20573 = cljs.core.count(clause);
var inst_20574 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_20573);
var state_20674__$1 = state_20674;
if(inst_20574){
var statearr_20716_20823 = state_20674__$1;
(statearr_20716_20823[(1)] = (44));

} else {
var statearr_20717_20824 = state_20674__$1;
(statearr_20717_20824[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (43))){
var inst_20565 = (state_20674[(20)]);
var inst_20568 = (state_20674[(2)]);
var inst_20569 = fluree.db.util.async.throw_err(inst_20568);
var inst_20570 = [inst_20569,r];
var inst_20571 = (new cljs.core.PersistentVector(null,2,(5),inst_20565,inst_20570,null));
var state_20674__$1 = state_20674;
var statearr_20718_20825 = state_20674__$1;
(statearr_20718_20825[(2)] = inst_20571);

(statearr_20718_20825[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (61))){
var inst_20624 = (state_20674[(8)]);
var inst_20627 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_20624,r,res,optional_QMARK_,fuel,max_fuel);
var state_20674__$1 = state_20674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20674__$1,(64),inst_20627);
} else {
if((state_val_20675 === (29))){
var inst_20447 = (state_20674[(10)]);
var inst_20530 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20447)].join('');
var inst_20531 = (new Error(inst_20530));
var inst_20532 = (function(){throw inst_20531})();
var state_20674__$1 = state_20674;
var statearr_20719_20826 = state_20674__$1;
(statearr_20719_20826[(2)] = inst_20532);

(statearr_20719_20826[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (44))){
var inst_20576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20577 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_20674__$1 = (function (){var statearr_20720 = state_20674;
(statearr_20720[(21)] = inst_20576);

return statearr_20720;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20674__$1,(47),inst_20577);
} else {
if((state_val_20675 === (6))){
var inst_20447 = (state_20674[(10)]);
var inst_20451 = (state_20674[(12)]);
var inst_20446 = cljs.core.keys(clause);
var inst_20447__$1 = cljs.core.first(inst_20446);
var inst_20451__$1 = cljs.core._EQ_;
var inst_20452 = (function (){var G__20721 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__20722 = inst_20447__$1;
return (inst_20451__$1.cljs$core$IFn$_invoke$arity$2 ? inst_20451__$1.cljs$core$IFn$_invoke$arity$2(G__20721,G__20722) : inst_20451__$1.call(null,G__20721,G__20722));
})();
var state_20674__$1 = (function (){var statearr_20723 = state_20674;
(statearr_20723[(10)] = inst_20447__$1);

(statearr_20723[(12)] = inst_20451__$1);

return statearr_20723;
})();
if(cljs.core.truth_(inst_20452)){
var statearr_20724_20827 = state_20674__$1;
(statearr_20724_20827[(1)] = (9));

} else {
var statearr_20725_20828 = state_20674__$1;
(statearr_20725_20828[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (28))){
var inst_20524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20525 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20526 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_20525,optional_QMARK_);
var inst_20527 = [inst_20526,r];
var inst_20528 = (new cljs.core.PersistentVector(null,2,(5),inst_20524,inst_20527,null));
var state_20674__$1 = state_20674;
var statearr_20726_20829 = state_20674__$1;
(statearr_20726_20829[(2)] = inst_20528);

(statearr_20726_20829[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (64))){
var inst_20629 = (state_20674[(2)]);
var inst_20630 = fluree.db.util.async.throw_err(inst_20629);
var state_20674__$1 = state_20674;
var statearr_20727_20830 = state_20674__$1;
(statearr_20727_20830[(2)] = inst_20630);

(statearr_20727_20830[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (51))){
var inst_20596 = cljs.core.first(clause);
var inst_20597 = cljs.core.sequential_QMARK_(inst_20596);
var state_20674__$1 = state_20674;
if(inst_20597){
var statearr_20728_20831 = state_20674__$1;
(statearr_20728_20831[(1)] = (54));

} else {
var statearr_20729_20832 = state_20674__$1;
(statearr_20729_20832[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (25))){
var inst_20447 = (state_20674[(10)]);
var inst_20451 = (state_20674[(12)]);
var inst_20512 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20513 = (function (){var segment_type = inst_20447;
var pred__20448 = inst_20451;
var expr__20449 = inst_20447;
var bindings = inst_20512;
return (function (p1__20433_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__20433_SHARP_);
});
})();
var inst_20514 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20513,inst_20512);
var inst_20515 = cljs.core.PersistentHashMap.EMPTY;
var inst_20516 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20515,inst_20514);
var inst_20517 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20518 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_20516);
var inst_20519 = [inst_20518,r];
var inst_20520 = (new cljs.core.PersistentVector(null,2,(5),inst_20517,inst_20519,null));
var state_20674__$1 = state_20674;
var statearr_20730_20833 = state_20674__$1;
(statearr_20730_20833[(2)] = inst_20520);

(statearr_20730_20833[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (34))){
var inst_20551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20552 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_20553 = [inst_20552,r];
var inst_20554 = (new cljs.core.PersistentVector(null,2,(5),inst_20551,inst_20553,null));
var state_20674__$1 = state_20674;
var statearr_20731_20834 = state_20674__$1;
(statearr_20731_20834[(2)] = inst_20554);

(statearr_20731_20834[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (17))){
var inst_20508 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20732_20835 = state_20674__$1;
(statearr_20732_20835[(2)] = inst_20508);

(statearr_20732_20835[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (3))){
var inst_20672 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20674__$1,inst_20672);
} else {
if((state_val_20675 === (12))){
var inst_20454 = (state_20674[(22)]);
var inst_20458 = (state_20674[(2)]);
var inst_20459 = fluree.db.util.async.throw_err(inst_20458);
var inst_20460 = [inst_20459,r];
var inst_20461 = (new cljs.core.PersistentVector(null,2,(5),inst_20454,inst_20460,null));
var state_20674__$1 = state_20674;
var statearr_20733_20836 = state_20674__$1;
(statearr_20733_20836[(2)] = inst_20461);

(statearr_20733_20836[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (2))){
var _ = (function (){var statearr_20734 = state_20674;
(statearr_20734[(4)] = cljs.core.cons((5),(state_20674[(4)])));

return statearr_20734;
})();
var inst_20444 = cljs.core.map_QMARK_(clause);
var state_20674__$1 = state_20674;
if(inst_20444){
var statearr_20735_20837 = state_20674__$1;
(statearr_20735_20837[(1)] = (6));

} else {
var statearr_20736_20838 = state_20674__$1;
(statearr_20736_20838[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (66))){
var state_20674__$1 = state_20674;
var statearr_20737_20839 = state_20674__$1;
(statearr_20737_20839[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (23))){
var inst_20484 = (state_20674[(16)]);
var inst_20493 = (state_20674[(19)]);
var inst_20476 = inst_20484;
var inst_20477 = inst_20493;
var state_20674__$1 = (function (){var statearr_20739 = state_20674;
(statearr_20739[(14)] = inst_20476);

(statearr_20739[(17)] = inst_20477);

return statearr_20739;
})();
var statearr_20740_20840 = state_20674__$1;
(statearr_20740_20840[(2)] = null);

(statearr_20740_20840[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (47))){
var inst_20576 = (state_20674[(21)]);
var inst_20579 = (state_20674[(2)]);
var inst_20580 = fluree.db.util.async.throw_err(inst_20579);
var inst_20581 = [inst_20580,r];
var inst_20582 = (new cljs.core.PersistentVector(null,2,(5),inst_20576,inst_20581,null));
var state_20674__$1 = state_20674;
var statearr_20741_20841 = state_20674__$1;
(statearr_20741_20841[(2)] = inst_20582);

(statearr_20741_20841[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (35))){
var inst_20557 = (state_20674[(23)]);
var inst_20556 = cljs.core.count(clause);
var inst_20557__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_20556);
var state_20674__$1 = (function (){var statearr_20742 = state_20674;
(statearr_20742[(23)] = inst_20557__$1);

return statearr_20742;
})();
if(inst_20557__$1){
var statearr_20743_20842 = state_20674__$1;
(statearr_20743_20842[(1)] = (37));

} else {
var statearr_20744_20843 = state_20674__$1;
(statearr_20744_20843[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (19))){
var inst_20477 = (state_20674[(17)]);
var inst_20502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20503 = [inst_20477,r];
var inst_20504 = (new cljs.core.PersistentVector(null,2,(5),inst_20502,inst_20503,null));
var state_20674__$1 = state_20674;
var statearr_20745_20844 = state_20674__$1;
(statearr_20745_20844[(2)] = inst_20504);

(statearr_20745_20844[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (57))){
var inst_20619 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_20674__$1 = state_20674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20674__$1,(60),inst_20619);
} else {
if((state_val_20675 === (68))){
var inst_20623 = (state_20674[(7)]);
var inst_20624 = (state_20674[(8)]);
var inst_20641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20642 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_20623,res,inst_20624,fuel,max_fuel);
var state_20674__$1 = (function (){var statearr_20746 = state_20674;
(statearr_20746[(24)] = inst_20641);

return statearr_20746;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20674__$1,(71),inst_20642);
} else {
if((state_val_20675 === (11))){
var inst_20540 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20748_20845 = state_20674__$1;
(statearr_20748_20845[(2)] = inst_20540);

(statearr_20748_20845[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (9))){
var inst_20454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20455 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20456 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_20455,res,fuel,max_fuel,opts);
var state_20674__$1 = (function (){var statearr_20749 = state_20674;
(statearr_20749[(22)] = inst_20454);

return statearr_20749;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20674__$1,(12),inst_20456);
} else {
if((state_val_20675 === (5))){
var _ = (function (){var statearr_20750 = state_20674;
(statearr_20750[(4)] = cljs.core.rest((state_20674[(4)])));

return statearr_20750;
})();
var state_20674__$1 = state_20674;
var ex20747 = (state_20674__$1[(2)]);
var statearr_20751_20846 = state_20674__$1;
(statearr_20751_20846[(5)] = ex20747);


if((ex20747 instanceof Error)){
var statearr_20752_20847 = state_20674__$1;
(statearr_20752_20847[(1)] = (4));

(statearr_20752_20847[(5)] = null);

} else {
throw ex20747;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (14))){
var inst_20447 = (state_20674[(10)]);
var inst_20451 = (state_20674[(12)]);
var inst_20510 = (function (){var G__20753 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__20754 = inst_20447;
return (inst_20451.cljs$core$IFn$_invoke$arity$2 ? inst_20451.cljs$core$IFn$_invoke$arity$2(G__20753,G__20754) : inst_20451.call(null,G__20753,G__20754));
})();
var state_20674__$1 = state_20674;
if(cljs.core.truth_(inst_20510)){
var statearr_20755_20848 = state_20674__$1;
(statearr_20755_20848[(1)] = (25));

} else {
var statearr_20756_20849 = state_20674__$1;
(statearr_20756_20849[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (45))){
var inst_20584 = cljs.core.count(clause);
var inst_20585 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_20584);
var state_20674__$1 = state_20674;
if(inst_20585){
var statearr_20757_20850 = state_20674__$1;
(statearr_20757_20850[(1)] = (48));

} else {
var statearr_20758_20851 = state_20674__$1;
(statearr_20758_20851[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (53))){
var inst_20659 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20759_20852 = state_20674__$1;
(statearr_20759_20852[(2)] = inst_20659);

(statearr_20759_20852[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (26))){
var inst_20447 = (state_20674[(10)]);
var inst_20451 = (state_20674[(12)]);
var inst_20522 = (function (){var G__20760 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__20761 = inst_20447;
return (inst_20451.cljs$core$IFn$_invoke$arity$2 ? inst_20451.cljs$core$IFn$_invoke$arity$2(G__20760,G__20761) : inst_20451.call(null,G__20760,G__20761));
})();
var state_20674__$1 = state_20674;
if(cljs.core.truth_(inst_20522)){
var statearr_20762_20853 = state_20674__$1;
(statearr_20762_20853[(1)] = (28));

} else {
var statearr_20763_20854 = state_20674__$1;
(statearr_20763_20854[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (16))){
var inst_20483 = (state_20674[(11)]);
var inst_20476 = (state_20674[(14)]);
var inst_20482 = cljs.core.seq(inst_20476);
var inst_20483__$1 = cljs.core.first(inst_20482);
var inst_20484 = cljs.core.next(inst_20482);
var state_20674__$1 = (function (){var statearr_20764 = state_20674;
(statearr_20764[(11)] = inst_20483__$1);

(statearr_20764[(16)] = inst_20484);

return statearr_20764;
})();
if(cljs.core.truth_(inst_20483__$1)){
var statearr_20765_20855 = state_20674__$1;
(statearr_20765_20855[(1)] = (18));

} else {
var statearr_20766_20856 = state_20674__$1;
(statearr_20766_20856[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (38))){
var inst_20557 = (state_20674[(23)]);
var state_20674__$1 = state_20674;
var statearr_20767_20857 = state_20674__$1;
(statearr_20767_20857[(2)] = inst_20557);

(statearr_20767_20857[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (30))){
var inst_20534 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20768_20858 = state_20674__$1;
(statearr_20768_20858[(2)] = inst_20534);

(statearr_20768_20858[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (10))){
var inst_20447 = (state_20674[(10)]);
var inst_20451 = (state_20674[(12)]);
var inst_20463 = (function (){var G__20769 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__20770 = inst_20447;
return (inst_20451.cljs$core$IFn$_invoke$arity$2 ? inst_20451.cljs$core$IFn$_invoke$arity$2(G__20769,G__20770) : inst_20451.call(null,G__20769,G__20770));
})();
var state_20674__$1 = state_20674;
if(cljs.core.truth_(inst_20463)){
var statearr_20771_20859 = state_20674__$1;
(statearr_20771_20859[(1)] = (13));

} else {
var statearr_20772_20860 = state_20674__$1;
(statearr_20772_20860[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (18))){
var inst_20483 = (state_20674[(11)]);
var inst_20486 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_20483,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_20483,q_map,vars,fuel,max_fuel,opts));
var state_20674__$1 = state_20674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20674__$1,(21),inst_20486);
} else {
if((state_val_20675 === (52))){
var state_20674__$1 = state_20674;
var statearr_20773_20861 = state_20674__$1;
(statearr_20773_20861[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (67))){
var inst_20652 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20775_20862 = state_20674__$1;
(statearr_20775_20862[(2)] = inst_20652);

(statearr_20775_20862[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (71))){
var inst_20641 = (state_20674[(24)]);
var inst_20644 = (state_20674[(2)]);
var inst_20645 = fluree.db.util.async.throw_err(inst_20644);
var inst_20646 = [inst_20645,r];
var inst_20647 = (new cljs.core.PersistentVector(null,2,(5),inst_20641,inst_20646,null));
var state_20674__$1 = state_20674;
var statearr_20776_20863 = state_20674__$1;
(statearr_20776_20863[(2)] = inst_20647);

(statearr_20776_20863[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (42))){
var inst_20665 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20777_20864 = state_20674__$1;
(statearr_20777_20864[(2)] = inst_20665);

(statearr_20777_20864[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (37))){
var inst_20559 = cljs.core.second(clause);
var inst_20560 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20559,"rdf:type");
var state_20674__$1 = state_20674;
var statearr_20778_20865 = state_20674__$1;
(statearr_20778_20865[(2)] = inst_20560);

(statearr_20778_20865[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (63))){
var inst_20654 = (state_20674[(2)]);
var state_20674__$1 = state_20674;
var statearr_20779_20866 = state_20674__$1;
(statearr_20779_20866[(2)] = inst_20654);

(statearr_20779_20866[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (8))){
var inst_20669 = (state_20674[(2)]);
var _ = (function (){var statearr_20780 = state_20674;
(statearr_20780[(4)] = cljs.core.rest((state_20674[(4)])));

return statearr_20780;
})();
var state_20674__$1 = state_20674;
var statearr_20781_20867 = state_20674__$1;
(statearr_20781_20867[(2)] = inst_20669);

(statearr_20781_20867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20675 === (49))){
var inst_20593 = cljs.core.count(clause);
var inst_20594 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_20593);
var state_20674__$1 = state_20674;
if(inst_20594){
var statearr_20782_20868 = state_20674__$1;
(statearr_20782_20868[(1)] = (51));

} else {
var statearr_20783_20869 = state_20674__$1;
(statearr_20783_20869[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_20784 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20784[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__);

(statearr_20784[(1)] = (1));

return statearr_20784;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1 = (function (state_20674){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20674);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20785){var ex__2730__auto__ = e20785;
var statearr_20786_20870 = state_20674;
(statearr_20786_20870[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20674[(4)]))){
var statearr_20787_20871 = state_20674;
(statearr_20787_20871[(1)] = cljs.core.first((state_20674[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20872 = state_20674;
state_20674 = G__20872;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__ = function(state_20674){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1.call(this,state_20674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20788 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20788[(6)] = c__2749__auto__);

return statearr_20788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__20874 = arguments.length;
switch (G__20874) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20954){
var state_val_20955 = (state_20954[(1)]);
if((state_val_20955 === (7))){
var inst_20949 = (state_20954[(2)]);
var _ = (function (){var statearr_20956 = state_20954;
(statearr_20956[(4)] = cljs.core.rest((state_20954[(4)])));

return statearr_20956;
})();
var state_20954__$1 = state_20954;
var statearr_20957_21005 = state_20954__$1;
(statearr_20957_21005[(2)] = inst_20949);

(statearr_20957_21005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (20))){
var inst_20914 = (state_20954[(7)]);
var inst_20926 = (state_20954[(2)]);
var inst_20896 = inst_20914;
var inst_20897 = inst_20926;
var state_20954__$1 = (function (){var statearr_20958 = state_20954;
(statearr_20958[(8)] = inst_20897);

(statearr_20958[(9)] = inst_20896);

return statearr_20958;
})();
var statearr_20959_21006 = state_20954__$1;
(statearr_20959_21006[(2)] = null);

(statearr_20959_21006[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (1))){
var state_20954__$1 = state_20954;
var statearr_20960_21007 = state_20954__$1;
(statearr_20960_21007[(2)] = null);

(statearr_20960_21007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (24))){
var inst_20897 = (state_20954[(8)]);
var inst_20913 = (state_20954[(10)]);
var inst_20914 = (state_20954[(7)]);
var inst_20934 = fluree.db.query.analytical.inner_join(inst_20897,inst_20913);
var inst_20896 = inst_20914;
var inst_20897__$1 = inst_20934;
var state_20954__$1 = (function (){var statearr_20961 = state_20954;
(statearr_20961[(8)] = inst_20897__$1);

(statearr_20961[(9)] = inst_20896);

return statearr_20961;
})();
var statearr_20962_21008 = state_20954__$1;
(statearr_20962_21008[(2)] = null);

(statearr_20962_21008[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (4))){
var inst_20875 = (state_20954[(2)]);
var state_20954__$1 = state_20954;
var statearr_20964_21009 = state_20954__$1;
(statearr_20964_21009[(2)] = inst_20875);

(statearr_20964_21009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (15))){
var inst_20913 = (state_20954[(10)]);
var state_20954__$1 = state_20954;
if(cljs.core.truth_(inst_20913)){
var statearr_20965_21010 = state_20954__$1;
(statearr_20965_21010[(1)] = (18));

} else {
var statearr_20966_21011 = state_20954__$1;
(statearr_20966_21011[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (21))){
var inst_20897 = (state_20954[(8)]);
var inst_20914 = (state_20954[(7)]);
var tmp20963 = inst_20897;
var inst_20896 = inst_20914;
var inst_20897__$1 = tmp20963;
var state_20954__$1 = (function (){var statearr_20967 = state_20954;
(statearr_20967[(8)] = inst_20897__$1);

(statearr_20967[(9)] = inst_20896);

return statearr_20967;
})();
var statearr_20968_21012 = state_20954__$1;
(statearr_20968_21012[(2)] = null);

(statearr_20968_21012[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (13))){
var inst_20897 = (state_20954[(8)]);
var inst_20920 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_20897,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_20921 = cljs.core.empty_QMARK_(inst_20920);
var state_20954__$1 = state_20954;
if(inst_20921){
var statearr_20969_21013 = state_20954__$1;
(statearr_20969_21013[(1)] = (15));

} else {
var statearr_20970_21014 = state_20954__$1;
(statearr_20970_21014[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (22))){
var state_20954__$1 = state_20954;
var statearr_20971_21015 = state_20954__$1;
(statearr_20971_21015[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (6))){
var inst_20903 = (state_20954[(11)]);
var inst_20896 = (state_20954[(9)]);
var inst_20902 = cljs.core.seq(inst_20896);
var inst_20903__$1 = cljs.core.first(inst_20902);
var inst_20904 = cljs.core.next(inst_20902);
var state_20954__$1 = (function (){var statearr_20973 = state_20954;
(statearr_20973[(11)] = inst_20903__$1);

(statearr_20973[(12)] = inst_20904);

return statearr_20973;
})();
if(cljs.core.truth_(inst_20903__$1)){
var statearr_20974_21016 = state_20954__$1;
(statearr_20974_21016[(1)] = (8));

} else {
var statearr_20975_21017 = state_20954__$1;
(statearr_20975_21017[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (25))){
var state_20954__$1 = state_20954;
var statearr_20976_21018 = state_20954__$1;
(statearr_20976_21018[(2)] = null);

(statearr_20976_21018[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (17))){
var inst_20942 = (state_20954[(2)]);
var state_20954__$1 = state_20954;
var statearr_20977_21019 = state_20954__$1;
(statearr_20977_21019[(2)] = inst_20942);

(statearr_20977_21019[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (3))){
var inst_20952 = (state_20954[(2)]);
var state_20954__$1 = state_20954;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20954__$1,inst_20952);
} else {
if((state_val_20955 === (12))){
var inst_20913 = (state_20954[(10)]);
var inst_20914 = (state_20954[(7)]);
var inst_20896 = inst_20914;
var inst_20897 = inst_20913;
var state_20954__$1 = (function (){var statearr_20978 = state_20954;
(statearr_20978[(8)] = inst_20897);

(statearr_20978[(9)] = inst_20896);

return statearr_20978;
})();
var statearr_20979_21020 = state_20954__$1;
(statearr_20979_21020[(2)] = null);

(statearr_20979_21020[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (2))){
var _ = (function (){var statearr_20980 = state_20954;
(statearr_20980[(4)] = cljs.core.cons((5),(state_20954[(4)])));

return statearr_20980;
})();
var inst_20888 = where;
var inst_20889 = cljs.core.seq(inst_20888);
var inst_20890 = cljs.core.first(inst_20889);
var inst_20891 = cljs.core.next(inst_20889);
var inst_20892 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20893 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_20894 = [inst_20893];
var inst_20895 = cljs.core.PersistentHashMap.fromArrays(inst_20892,inst_20894);
var inst_20896 = inst_20888;
var inst_20897 = inst_20895;
var state_20954__$1 = (function (){var statearr_20981 = state_20954;
(statearr_20981[(8)] = inst_20897);

(statearr_20981[(9)] = inst_20896);

(statearr_20981[(13)] = inst_20890);

(statearr_20981[(14)] = inst_20891);

return statearr_20981;
})();
var statearr_20982_21021 = state_20954__$1;
(statearr_20982_21021[(2)] = null);

(statearr_20982_21021[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (23))){
var inst_20940 = (state_20954[(2)]);
var state_20954__$1 = state_20954;
var statearr_20983_21022 = state_20954__$1;
(statearr_20983_21022[(2)] = inst_20940);

(statearr_20983_21022[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (19))){
var inst_20897 = (state_20954[(8)]);
var state_20954__$1 = state_20954;
var statearr_20984_21023 = state_20954__$1;
(statearr_20984_21023[(2)] = inst_20897);

(statearr_20984_21023[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (11))){
var inst_20903 = (state_20954[(11)]);
var inst_20911 = (state_20954[(2)]);
var inst_20912 = fluree.db.util.async.throw_err(inst_20911);
var inst_20913 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20912,(0),null);
var inst_20914 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20912,(1),null);
var inst_20915 = cljs.core.count(inst_20903);
var inst_20916 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_20915);
var state_20954__$1 = (function (){var statearr_20986 = state_20954;
(statearr_20986[(10)] = inst_20913);

(statearr_20986[(7)] = inst_20914);

return statearr_20986;
})();
if(inst_20916){
var statearr_20987_21024 = state_20954__$1;
(statearr_20987_21024[(1)] = (12));

} else {
var statearr_20988_21025 = state_20954__$1;
(statearr_20988_21025[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (9))){
var inst_20897 = (state_20954[(8)]);
var state_20954__$1 = state_20954;
var statearr_20989_21026 = state_20954__$1;
(statearr_20989_21026[(2)] = inst_20897);

(statearr_20989_21026[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (5))){
var _ = (function (){var statearr_20990 = state_20954;
(statearr_20990[(4)] = cljs.core.rest((state_20954[(4)])));

return statearr_20990;
})();
var state_20954__$1 = state_20954;
var ex20985 = (state_20954__$1[(2)]);
var statearr_20991_21027 = state_20954__$1;
(statearr_20991_21027[(5)] = ex20985);


if((ex20985 instanceof Error)){
var statearr_20992_21028 = state_20954__$1;
(statearr_20992_21028[(1)] = (4));

(statearr_20992_21028[(5)] = null);

} else {
throw ex20985;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (14))){
var inst_20944 = (state_20954[(2)]);
var state_20954__$1 = state_20954;
var statearr_20993_21029 = state_20954__$1;
(statearr_20993_21029[(2)] = inst_20944);

(statearr_20993_21029[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (26))){
var inst_20938 = (state_20954[(2)]);
var state_20954__$1 = state_20954;
var statearr_20994_21030 = state_20954__$1;
(statearr_20994_21030[(2)] = inst_20938);

(statearr_20994_21030[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (16))){
var inst_20913 = (state_20954[(10)]);
var inst_20929 = (inst_20913 == null);
var state_20954__$1 = state_20954;
if(cljs.core.truth_(inst_20929)){
var statearr_20995_21031 = state_20954__$1;
(statearr_20995_21031[(1)] = (21));

} else {
var statearr_20996_21032 = state_20954__$1;
(statearr_20996_21032[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (10))){
var inst_20947 = (state_20954[(2)]);
var state_20954__$1 = state_20954;
var statearr_20997_21033 = state_20954__$1;
(statearr_20997_21033[(2)] = inst_20947);

(statearr_20997_21033[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (18))){
var inst_20913 = (state_20954[(10)]);
var state_20954__$1 = state_20954;
var statearr_20998_21034 = state_20954__$1;
(statearr_20998_21034[(2)] = inst_20913);

(statearr_20998_21034[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20955 === (8))){
var inst_20897 = (state_20954[(8)]);
var inst_20903 = (state_20954[(11)]);
var inst_20904 = (state_20954[(12)]);
var inst_20909 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_20897,inst_20903,inst_20904,false,fuel,max_fuel,opts);
var state_20954__$1 = state_20954;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20954__$1,(11),inst_20909);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2727__auto__ = null;
var fluree$db$query$analytical$state_machine__2727__auto____0 = (function (){
var statearr_20999 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20999[(0)] = fluree$db$query$analytical$state_machine__2727__auto__);

(statearr_20999[(1)] = (1));

return statearr_20999;
});
var fluree$db$query$analytical$state_machine__2727__auto____1 = (function (state_20954){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20954);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21000){var ex__2730__auto__ = e21000;
var statearr_21001_21035 = state_20954;
(statearr_21001_21035[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20954[(4)]))){
var statearr_21002_21036 = state_20954;
(statearr_21002_21036[(1)] = cljs.core.first((state_20954[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21037 = state_20954;
state_20954 = G__21037;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2727__auto__ = function(state_20954){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2727__auto____1.call(this,state_20954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2727__auto____0;
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2727__auto____1;
return fluree$db$query$analytical$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21003 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21003[(6)] = c__2749__auto__);

return statearr_21003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21072){
var state_val_21073 = (state_21072[(1)]);
if((state_val_21073 === (7))){
var inst_21054 = (state_21072[(7)]);
var inst_21049 = (state_21072[(8)]);
var inst_21056 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21049,inst_21054,fuel,max_fuel,opts);
var state_21072__$1 = state_21072;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21072__$1,(10),inst_21056);
} else {
if((state_val_21073 === (1))){
var state_21072__$1 = state_21072;
var statearr_21074_21099 = state_21072__$1;
(statearr_21074_21099[(2)] = null);

(statearr_21074_21099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (4))){
var inst_21038 = (state_21072[(2)]);
var state_21072__$1 = state_21072;
var statearr_21075_21100 = state_21072__$1;
(statearr_21075_21100[(2)] = inst_21038);

(statearr_21075_21100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (13))){
var inst_21067 = (state_21072[(2)]);
var _ = (function (){var statearr_21076 = state_21072;
(statearr_21076[(4)] = cljs.core.rest((state_21072[(4)])));

return statearr_21076;
})();
var state_21072__$1 = state_21072;
var statearr_21077_21101 = state_21072__$1;
(statearr_21077_21101[(2)] = inst_21067);

(statearr_21077_21101[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (6))){
var inst_21049 = (state_21072[(8)]);
var inst_21053 = (state_21072[(2)]);
var inst_21054 = fluree.db.util.async.throw_err(inst_21053);
var state_21072__$1 = (function (){var statearr_21078 = state_21072;
(statearr_21078[(7)] = inst_21054);

return statearr_21078;
})();
if(cljs.core.truth_(inst_21049)){
var statearr_21079_21102 = state_21072__$1;
(statearr_21079_21102[(1)] = (7));

} else {
var statearr_21080_21103 = state_21072__$1;
(statearr_21080_21103[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (3))){
var inst_21070 = (state_21072[(2)]);
var state_21072__$1 = state_21072;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21072__$1,inst_21070);
} else {
if((state_val_21073 === (12))){
var inst_21062 = (state_21072[(9)]);
var state_21072__$1 = state_21072;
var statearr_21081_21104 = state_21072__$1;
(statearr_21081_21104[(2)] = inst_21062);

(statearr_21081_21104[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (2))){
var _ = (function (){var statearr_21082 = state_21072;
(statearr_21082[(4)] = cljs.core.cons((5),(state_21072[(4)])));

return statearr_21082;
})();
var inst_21045 = q_map;
var inst_21046 = cljs.core.__destructure_map(inst_21045);
var inst_21047 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21046,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21048 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21046,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21049 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21046,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21050 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21046,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21051 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21048,q_map,inst_21047,fuel,max_fuel,opts);
var state_21072__$1 = (function (){var statearr_21083 = state_21072;
(statearr_21083[(8)] = inst_21049);

(statearr_21083[(10)] = inst_21050);

return statearr_21083;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21072__$1,(6),inst_21051);
} else {
if((state_val_21073 === (11))){
var inst_21062 = (state_21072[(9)]);
var inst_21050 = (state_21072[(10)]);
var inst_21064 = fluree.db.query.analytical.tuples__GT_filtered(inst_21062,inst_21050,null);
var state_21072__$1 = state_21072;
var statearr_21085_21105 = state_21072__$1;
(statearr_21085_21105[(2)] = inst_21064);

(statearr_21085_21105[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (9))){
var inst_21050 = (state_21072[(10)]);
var inst_21062 = (state_21072[(2)]);
var state_21072__$1 = (function (){var statearr_21086 = state_21072;
(statearr_21086[(9)] = inst_21062);

return statearr_21086;
})();
if(cljs.core.truth_(inst_21050)){
var statearr_21087_21106 = state_21072__$1;
(statearr_21087_21106[(1)] = (11));

} else {
var statearr_21088_21107 = state_21072__$1;
(statearr_21088_21107[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (5))){
var _ = (function (){var statearr_21089 = state_21072;
(statearr_21089[(4)] = cljs.core.rest((state_21072[(4)])));

return statearr_21089;
})();
var state_21072__$1 = state_21072;
var ex21084 = (state_21072__$1[(2)]);
var statearr_21090_21108 = state_21072__$1;
(statearr_21090_21108[(5)] = ex21084);


if((ex21084 instanceof Error)){
var statearr_21091_21109 = state_21072__$1;
(statearr_21091_21109[(1)] = (4));

(statearr_21091_21109[(5)] = null);

} else {
throw ex21084;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (10))){
var inst_21058 = (state_21072[(2)]);
var inst_21059 = fluree.db.util.async.throw_err(inst_21058);
var state_21072__$1 = state_21072;
var statearr_21092_21110 = state_21072__$1;
(statearr_21092_21110[(2)] = inst_21059);

(statearr_21092_21110[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (8))){
var inst_21054 = (state_21072[(7)]);
var state_21072__$1 = state_21072;
var statearr_21093_21111 = state_21072__$1;
(statearr_21093_21111[(2)] = inst_21054);

(statearr_21093_21111[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2727__auto____0 = (function (){
var statearr_21094 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21094[(0)] = fluree$db$query$analytical$q_$_state_machine__2727__auto__);

(statearr_21094[(1)] = (1));

return statearr_21094;
});
var fluree$db$query$analytical$q_$_state_machine__2727__auto____1 = (function (state_21072){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21072);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21095){var ex__2730__auto__ = e21095;
var statearr_21096_21112 = state_21072;
(statearr_21096_21112[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21072[(4)]))){
var statearr_21097_21113 = state_21072;
(statearr_21097_21113[(1)] = cljs.core.first((state_21072[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21114 = state_21072;
state_21072 = G__21114;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2727__auto__ = function(state_21072){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2727__auto____1.call(this,state_21072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2727__auto____0;
fluree$db$query$analytical$q_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21098 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21098[(6)] = c__2749__auto__);

return statearr_21098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
