// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.token_auth');
goog.require('cljs.core');
goog.require('fluree.crypto.hmac');
goog.require('alphabase.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('clojure.string');
fluree.db.token_auth.base64__GT_base64url = (function fluree$db$token_auth$base64__GT_base64url(b64){
return clojure.string.replace(clojure.string.replace(clojure.string.replace(b64,/=+$/,""),/\+/,"-"),/\//,"_");
});
fluree.db.token_auth.jwt_header = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alg","alg",-830920638),"HS256",new cljs.core.Keyword(null,"typ","typ",-1304536900),"JWT"], null);
fluree.db.token_auth.jwt_header_enc = fluree.db.token_auth.base64__GT_base64url(alphabase.core.bytes__GT_base64(fluree.db.util.json.stringify_UTF8(fluree.db.token_auth.jwt_header)));
/**
 * Generates jwt signature as base64URL using secret given a string token.
 */
fluree.db.token_auth.generate_jwt_sig = (function fluree$db$token_auth$generate_jwt_sig(secret,token){
return fluree.db.token_auth.base64__GT_base64url(alphabase.core.bytes__GT_base64(fluree.crypto.hmac.hmac_sha256(alphabase.core.string__GT_bytes(token),secret)));
});
/**
 * Generates a HS256 JWT token containing data as a map and secured with secret.
 */
fluree.db.token_auth.generate_jwt = (function fluree$db$token_auth$generate_jwt(secret,payload){
var data_enc = fluree.db.token_auth.base64__GT_base64url(alphabase.core.bytes__GT_base64(fluree.db.util.json.stringify_UTF8(payload)));
var token = [fluree.db.token_auth.jwt_header_enc,".",data_enc].join('');
var hs256 = fluree.db.token_auth.generate_jwt_sig(secret,token);
return [token,".",hs256].join('');
});
/**
 * Returns the JWT payload as map if valid, else an exception.
 */
fluree.db.token_auth.verify_jwt = (function fluree$db$token_auth$verify_jwt(secret,jwt){
var vec__72268 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(jwt,/\./);
var header = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72268,(0),null);
var payload = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72268,(1),null);
var sig = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72268,(2),null);
var header_STAR_ = (function (){try{return fluree.db.util.json.parse(alphabase.core.base64__GT_bytes(header));
}catch (e72271){var e = e72271;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid JWT header.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-token","db/invalid-token",2042659556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"reason","reason",-2070751759),e.getMessage()], null)], null));
}})();
var token = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(header),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(payload)].join('');
var sig_STAR_ = fluree.db.token_auth.generate_jwt_sig(secret,token);
var _ = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(header_STAR_,fluree.db.token_auth.jwt_header))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid JWT header. Only HS256 algorithm supported.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-token","db/invalid-token",2042659556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"header","header",119441134),header_STAR_], null)], null))})():null);
var ___$1 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(sig_STAR_,sig))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid JWT signature.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-token","db/invalid-token",2042659556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null)], null))})():null);
var payload_STAR_ = (function (){try{return fluree.db.util.json.parse(alphabase.core.base64__GT_bytes(payload));
}catch (e72272){var e = e72272;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid JWT payload.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-token","db/invalid-token",2042659556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"reason","reason",-2070751759),e.getMessage()], null)], null));
}})();
if(cljs.core.truth_((function (){var and__4251__auto__ = new cljs.core.Keyword(null,"exp","exp",-261706262).cljs$core$IFn$_invoke$arity$1(payload_STAR_);
if(cljs.core.truth_(and__4251__auto__)){
return (new cljs.core.Keyword(null,"exp","exp",-261706262).cljs$core$IFn$_invoke$arity$1(payload_STAR_) < fluree.db.util.core.current_time_millis());
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("JWT has expired.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","expired-token","db/expired-token",-311685617),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null)], null));
} else {
}

return payload_STAR_;
});
