// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *    1. level [Values: severe, warning, info, config, fine, finer, finest]
 *    
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__75756 = opts_SINGLEQUOTE_;
var map__75756__$1 = cljs.core.__destructure_map(map__75756);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75756__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__75758 = arguments.length;
switch (G__75758) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 * 
 *     Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__75761 = arguments.length;
switch (G__75761) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__75764 = arguments.length;
switch (G__75764) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__75767 = arguments.length;
switch (G__75767) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *    Must supply ledger, password and either user or auth identifier.
 *    Expire is optional
 *    - connection - connection object to server
 *    - ledger     - ledger identifier
 *    - password   - plain-text password
 *    - user       - _user/username (TODO: should allow any _user ident in the future)
 *    - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *    - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__75770 = arguments.length;
switch (G__75770) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *    Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__75773 = arguments.length;
switch (G__75773) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___75782 = arguments.length;
var i__4865__auto___75783 = (0);
while(true){
if((i__4865__auto___75783 < len__4864__auto___75782)){
args__4870__auto__.push((arguments[i__4865__auto___75783]));

var G__75784 = (i__4865__auto___75783 + (1));
i__4865__auto___75783 = G__75784;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__75778){
var vec__75779 = p__75778;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75779,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq75775){
var G__75776 = cljs.core.first(seq75775);
var seq75775__$1 = cljs.core.next(seq75775);
var G__75777 = cljs.core.first(seq75775__$1);
var seq75775__$2 = cljs.core.next(seq75775__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__75776,G__75777,seq75775__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75806){
var state_val_75807 = (state_75806[(1)]);
if((state_val_75807 === (1))){
var state_75806__$1 = state_75806;
var statearr_75808_75823 = state_75806__$1;
(statearr_75808_75823[(2)] = null);

(statearr_75808_75823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75807 === (2))){
var _ = (function (){var statearr_75809 = state_75806;
(statearr_75809[(4)] = cljs.core.cons((5),(state_75806[(4)])));

return statearr_75809;
})();
var state_75806__$1 = state_75806;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75806__$1,(6),db);
} else {
if((state_val_75807 === (3))){
var inst_75804 = (state_75806[(2)]);
var state_75806__$1 = state_75806;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75806__$1,inst_75804);
} else {
if((state_val_75807 === (4))){
var inst_75785 = (state_75806[(2)]);
var inst_75786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75787 = [inst_75785];
var inst_75788 = (new cljs.core.PersistentVector(null,1,(5),inst_75786,inst_75787,null));
var inst_75789 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_75788);
var inst_75790 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_75785) : reject.call(null,inst_75785));
var state_75806__$1 = (function (){var statearr_75811 = state_75806;
(statearr_75811[(7)] = inst_75789);

return statearr_75811;
})();
var statearr_75812_75824 = state_75806__$1;
(statearr_75812_75824[(2)] = inst_75790);

(statearr_75812_75824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75807 === (5))){
var _ = (function (){var statearr_75813 = state_75806;
(statearr_75813[(4)] = cljs.core.rest((state_75806[(4)])));

return statearr_75813;
})();
var state_75806__$1 = state_75806;
var ex75810 = (state_75806__$1[(2)]);
var statearr_75814_75825 = state_75806__$1;
(statearr_75814_75825[(5)] = ex75810);


var statearr_75815_75826 = state_75806__$1;
(statearr_75815_75826[(1)] = (4));

(statearr_75815_75826[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75807 === (6))){
var inst_75797 = (state_75806[(2)]);
var inst_75798 = fluree.db.util.async.throw_err(inst_75797);
var inst_75799 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_75798);
var inst_75800 = cljs.core.clj__GT_js(inst_75799);
var inst_75801 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_75800) : resolve.call(null,inst_75800));
var _ = (function (){var statearr_75816 = state_75806;
(statearr_75816[(4)] = cljs.core.rest((state_75806[(4)])));

return statearr_75816;
})();
var state_75806__$1 = state_75806;
var statearr_75817_75827 = state_75806__$1;
(statearr_75817_75827[(2)] = inst_75801);

(statearr_75817_75827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__2727__auto__ = null;
var flureedb$db_schema_$_state_machine__2727__auto____0 = (function (){
var statearr_75818 = [null,null,null,null,null,null,null,null];
(statearr_75818[(0)] = flureedb$db_schema_$_state_machine__2727__auto__);

(statearr_75818[(1)] = (1));

return statearr_75818;
});
var flureedb$db_schema_$_state_machine__2727__auto____1 = (function (state_75806){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75806);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75819){var ex__2730__auto__ = e75819;
var statearr_75820_75828 = state_75806;
(statearr_75820_75828[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75806[(4)]))){
var statearr_75821_75829 = state_75806;
(statearr_75821_75829[(1)] = cljs.core.first((state_75806[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75830 = state_75806;
state_75806 = G__75830;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__2727__auto__ = function(state_75806){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__2727__auto____1.call(this,state_75806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__2727__auto____0;
flureedb$db_schema_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__2727__auto____1;
return flureedb$db_schema_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75822 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75822[(6)] = c__2749__auto__);

return statearr_75822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *    Returns a promise that will have a response with a corresponding status of success.
 * 
 *    A 200 status indicates the deletion has been successfully initiated.
 *    The full deletion happens in the background on the respective ledger.
 * 
 *    Query servers get notified when this process initiates, and ledger will be marked as
 *    being in a deletion state during the deletion process.
 * 
 *    Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__75832 = arguments.length;
switch (G__75832) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75905){
var state_val_75906 = (state_75905[(1)]);
if((state_val_75906 === (7))){
var inst_75848 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_75905__$1 = state_75905;
var statearr_75907_75952 = state_75905__$1;
(statearr_75907_75952[(2)] = inst_75848);

(statearr_75907_75952[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (20))){
var inst_75856 = (state_75905[(7)]);
var inst_75880 = (state_75905[(2)]);
var state_75905__$1 = (function (){var statearr_75908 = state_75905;
(statearr_75908[(8)] = inst_75880);

return statearr_75908;
})();
if(cljs.core.truth_(inst_75856)){
var statearr_75909_75953 = state_75905__$1;
(statearr_75909_75953[(1)] = (21));

} else {
var statearr_75910_75954 = state_75905__$1;
(statearr_75910_75954[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (1))){
var state_75905__$1 = state_75905;
var statearr_75911_75955 = state_75905__$1;
(statearr_75911_75955[(2)] = null);

(statearr_75911_75955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (24))){
var inst_75887 = (state_75905[(2)]);
var inst_75888 = fluree.db.util.async.throw_err(inst_75887);
var state_75905__$1 = state_75905;
var statearr_75912_75956 = state_75905__$1;
(statearr_75912_75956[(2)] = inst_75888);

(statearr_75912_75956[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (4))){
var inst_75833 = (state_75905[(2)]);
var inst_75834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75835 = [inst_75833];
var inst_75836 = (new cljs.core.PersistentVector(null,1,(5),inst_75834,inst_75835,null));
var inst_75837 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_75836);
var inst_75838 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_75833) : reject.call(null,inst_75833));
var state_75905__$1 = (function (){var statearr_75913 = state_75905;
(statearr_75913[(9)] = inst_75837);

return statearr_75913;
})();
var statearr_75914_75957 = state_75905__$1;
(statearr_75914_75957[(2)] = inst_75838);

(statearr_75914_75957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (15))){
var inst_75869 = (state_75905[(10)]);
var inst_75871 = fluree.db.util.core.without_nils(inst_75869);
var inst_75872 = fluree.db.util.json.stringify(inst_75871);
var state_75905__$1 = state_75905;
var statearr_75915_75958 = state_75905__$1;
(statearr_75915_75958[(2)] = inst_75872);

(statearr_75915_75958[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (21))){
var inst_75880 = (state_75905[(8)]);
var inst_75875 = (state_75905[(11)]);
var inst_75882 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_75883 = [inst_75875,inst_75880];
var inst_75884 = cljs.core.PersistentHashMap.fromArrays(inst_75882,inst_75883);
var inst_75885 = fluree.db.operations.command_async(conn,inst_75884);
var state_75905__$1 = state_75905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75905__$1,(24),inst_75885);
} else {
if((state_val_75906 === (13))){
var inst_75857 = (state_75905[(12)]);
var inst_75864 = (inst_75857 + (30000));
var state_75905__$1 = state_75905;
var statearr_75916_75959 = state_75905__$1;
(statearr_75916_75959[(2)] = inst_75864);

(statearr_75916_75959[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (22))){
var inst_75869 = (state_75905[(10)]);
var inst_75890 = fluree.db.operations.unsigned_command_async(conn,inst_75869);
var state_75905__$1 = state_75905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75905__$1,(25),inst_75890);
} else {
if((state_val_75906 === (6))){
var state_75905__$1 = state_75905;
var statearr_75917_75960 = state_75905__$1;
(statearr_75917_75960[(2)] = null);

(statearr_75917_75960[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (25))){
var inst_75892 = (state_75905[(2)]);
var inst_75893 = fluree.db.util.async.throw_err(inst_75892);
var state_75905__$1 = state_75905;
var statearr_75918_75961 = state_75905__$1;
(statearr_75918_75961[(2)] = inst_75893);

(statearr_75918_75961[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (17))){
var inst_75856 = (state_75905[(7)]);
var inst_75875 = (state_75905[(2)]);
var state_75905__$1 = (function (){var statearr_75919 = state_75905;
(statearr_75919[(11)] = inst_75875);

return statearr_75919;
})();
if(cljs.core.truth_(inst_75856)){
var statearr_75920_75962 = state_75905__$1;
(statearr_75920_75962[(1)] = (18));

} else {
var statearr_75921_75963 = state_75905__$1;
(statearr_75921_75963[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (3))){
var inst_75903 = (state_75905[(2)]);
var state_75905__$1 = state_75905;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75905__$1,inst_75903);
} else {
if((state_val_75906 === (12))){
var inst_75854 = (state_75905[(13)]);
var state_75905__$1 = state_75905;
var statearr_75922_75964 = state_75905__$1;
(statearr_75922_75964[(2)] = inst_75854);

(statearr_75922_75964[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (2))){
var _ = (function (){var statearr_75923 = state_75905;
(statearr_75923[(4)] = cljs.core.cons((5),(state_75905[(4)])));

return statearr_75923;
})();
var inst_75845 = (opts == null);
var state_75905__$1 = state_75905;
if(cljs.core.truth_(inst_75845)){
var statearr_75924_75965 = state_75905__$1;
(statearr_75924_75965[(1)] = (6));

} else {
var statearr_75925_75966 = state_75905__$1;
(statearr_75925_75966[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (23))){
var inst_75895 = (state_75905[(2)]);
var inst_75896 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_75897 = [(200),inst_75895];
var inst_75898 = cljs.core.PersistentHashMap.fromArrays(inst_75896,inst_75897);
var inst_75899 = cljs.core.clj__GT_js(inst_75898);
var inst_75900 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_75899) : resolve.call(null,inst_75899));
var _ = (function (){var statearr_75926 = state_75905;
(statearr_75926[(4)] = cljs.core.rest((state_75905[(4)])));

return statearr_75926;
})();
var state_75905__$1 = state_75905;
var statearr_75927_75967 = state_75905__$1;
(statearr_75927_75967[(2)] = inst_75900);

(statearr_75927_75967[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (19))){
var state_75905__$1 = state_75905;
var statearr_75928_75968 = state_75905__$1;
(statearr_75928_75968[(2)] = null);

(statearr_75928_75968[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (11))){
var inst_75854 = (state_75905[(13)]);
var inst_75861 = (state_75905[(2)]);
var state_75905__$1 = (function (){var statearr_75930 = state_75905;
(statearr_75930[(14)] = inst_75861);

return statearr_75930;
})();
if(cljs.core.truth_(inst_75854)){
var statearr_75931_75969 = state_75905__$1;
(statearr_75931_75969[(1)] = (12));

} else {
var statearr_75932_75970 = state_75905__$1;
(statearr_75932_75970[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (9))){
var inst_75853 = (state_75905[(15)]);
var state_75905__$1 = state_75905;
var statearr_75933_75971 = state_75905__$1;
(statearr_75933_75971[(2)] = inst_75853);

(statearr_75933_75971[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (5))){
var _ = (function (){var statearr_75934 = state_75905;
(statearr_75934[(4)] = cljs.core.rest((state_75905[(4)])));

return statearr_75934;
})();
var state_75905__$1 = state_75905;
var ex75929 = (state_75905__$1[(2)]);
var statearr_75935_75972 = state_75905__$1;
(statearr_75935_75972[(5)] = ex75929);


var statearr_75936_75973 = state_75905__$1;
(statearr_75936_75973[(1)] = (4));

(statearr_75936_75973[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (14))){
var inst_75861 = (state_75905[(14)]);
var inst_75856 = (state_75905[(7)]);
var inst_75866 = (state_75905[(2)]);
var inst_75867 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_75868 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_75861,inst_75866];
var inst_75869 = cljs.core.PersistentHashMap.fromArrays(inst_75867,inst_75868);
var state_75905__$1 = (function (){var statearr_75937 = state_75905;
(statearr_75937[(10)] = inst_75869);

return statearr_75937;
})();
if(cljs.core.truth_(inst_75856)){
var statearr_75938_75974 = state_75905__$1;
(statearr_75938_75974[(1)] = (15));

} else {
var statearr_75939_75975 = state_75905__$1;
(statearr_75939_75975[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (16))){
var state_75905__$1 = state_75905;
var statearr_75940_75976 = state_75905__$1;
(statearr_75940_75976[(2)] = null);

(statearr_75940_75976[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (10))){
var inst_75857 = (state_75905[(12)]);
var state_75905__$1 = state_75905;
var statearr_75941_75977 = state_75905__$1;
(statearr_75941_75977[(2)] = inst_75857);

(statearr_75941_75977[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (18))){
var inst_75856 = (state_75905[(7)]);
var inst_75875 = (state_75905[(11)]);
var inst_75877 = fluree.crypto.sign_message(inst_75875,inst_75856);
var state_75905__$1 = state_75905;
var statearr_75942_75978 = state_75905__$1;
(statearr_75942_75978[(2)] = inst_75877);

(statearr_75942_75978[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75906 === (8))){
var inst_75853 = (state_75905[(15)]);
var inst_75850 = (state_75905[(2)]);
var inst_75851 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_75850);
var inst_75852 = cljs.core.__destructure_map(inst_75850);
var inst_75853__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75852,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_75854 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75852,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_75855 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_75852,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_75856 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75852,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_75857 = fluree.db.util.core.current_time_millis();
var state_75905__$1 = (function (){var statearr_75943 = state_75905;
(statearr_75943[(13)] = inst_75854);

(statearr_75943[(12)] = inst_75857);

(statearr_75943[(16)] = inst_75855);

(statearr_75943[(17)] = inst_75851);

(statearr_75943[(7)] = inst_75856);

(statearr_75943[(15)] = inst_75853__$1);

return statearr_75943;
})();
if(cljs.core.truth_(inst_75853__$1)){
var statearr_75944_75979 = state_75905__$1;
(statearr_75944_75979[(1)] = (9));

} else {
var statearr_75945_75980 = state_75905__$1;
(statearr_75945_75980[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_75946 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75946[(0)] = flureedb$state_machine__2727__auto__);

(statearr_75946[(1)] = (1));

return statearr_75946;
});
var flureedb$state_machine__2727__auto____1 = (function (state_75905){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75905);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75947){var ex__2730__auto__ = e75947;
var statearr_75948_75981 = state_75905;
(statearr_75948_75981[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75905[(4)]))){
var statearr_75949_75982 = state_75905;
(statearr_75949_75982[(1)] = cljs.core.first((state_75905[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75983 = state_75905;
state_75905 = G__75983;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_75905){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_75905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75950 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75950[(6)] = c__2749__auto__);

return statearr_75950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *    If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76005){
var state_val_76006 = (state_76005[(1)]);
if((state_val_76006 === (1))){
var state_76005__$1 = state_76005;
var statearr_76007_76022 = state_76005__$1;
(statearr_76007_76022[(2)] = null);

(statearr_76007_76022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76006 === (2))){
var _ = (function (){var statearr_76008 = state_76005;
(statearr_76008[(4)] = cljs.core.cons((5),(state_76005[(4)])));

return statearr_76008;
})();
var inst_75995 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_76005__$1 = state_76005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76005__$1,(6),inst_75995);
} else {
if((state_val_76006 === (3))){
var inst_76003 = (state_76005[(2)]);
var state_76005__$1 = state_76005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76005__$1,inst_76003);
} else {
if((state_val_76006 === (4))){
var inst_75984 = (state_76005[(2)]);
var inst_75985 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75986 = [inst_75984];
var inst_75987 = (new cljs.core.PersistentVector(null,1,(5),inst_75985,inst_75986,null));
var inst_75988 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_75987);
var inst_75989 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_75984) : reject.call(null,inst_75984));
var state_76005__$1 = (function (){var statearr_76010 = state_76005;
(statearr_76010[(7)] = inst_75988);

return statearr_76010;
})();
var statearr_76011_76023 = state_76005__$1;
(statearr_76011_76023[(2)] = inst_75989);

(statearr_76011_76023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76006 === (5))){
var _ = (function (){var statearr_76012 = state_76005;
(statearr_76012[(4)] = cljs.core.rest((state_76005[(4)])));

return statearr_76012;
})();
var state_76005__$1 = state_76005;
var ex76009 = (state_76005__$1[(2)]);
var statearr_76013_76024 = state_76005__$1;
(statearr_76013_76024[(5)] = ex76009);


var statearr_76014_76025 = state_76005__$1;
(statearr_76014_76025[(1)] = (4));

(statearr_76014_76025[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76006 === (6))){
var inst_75997 = (state_76005[(2)]);
var inst_75998 = fluree.db.util.async.throw_err(inst_75997);
var inst_75999 = cljs.core.clj__GT_js(inst_75998);
var inst_76000 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_75999) : resolve.call(null,inst_75999));
var _ = (function (){var statearr_76015 = state_76005;
(statearr_76015[(4)] = cljs.core.rest((state_76005[(4)])));

return statearr_76015;
})();
var state_76005__$1 = state_76005;
var statearr_76016_76026 = state_76005__$1;
(statearr_76016_76026[(2)] = inst_76000);

(statearr_76016_76026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__2727__auto__ = null;
var flureedb$ledger_stats_$_state_machine__2727__auto____0 = (function (){
var statearr_76017 = [null,null,null,null,null,null,null,null];
(statearr_76017[(0)] = flureedb$ledger_stats_$_state_machine__2727__auto__);

(statearr_76017[(1)] = (1));

return statearr_76017;
});
var flureedb$ledger_stats_$_state_machine__2727__auto____1 = (function (state_76005){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76005);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76018){var ex__2730__auto__ = e76018;
var statearr_76019_76027 = state_76005;
(statearr_76019_76027[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76005[(4)]))){
var statearr_76020_76028 = state_76005;
(statearr_76020_76028[(1)] = cljs.core.first((state_76005[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76029 = state_76005;
state_76005 = G__76029;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__2727__auto__ = function(state_76005){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__2727__auto____1.call(this,state_76005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__2727__auto____0;
flureedb$ledger_stats_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__2727__auto____1;
return flureedb$ledger_stats_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76021 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76021[(6)] = c__2749__auto__);

return statearr_76021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 *     A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 *     Once successful, will return with a command-id.
 * 
 *     Ledger creation is handled asynchronously and may not be immediately available.
 * 
 *     Options include:
 *     - :alias       - Alias, if different than db-ident.
 *     - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 *     - :doc         - Optional doc string about this db.
 *     - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 *     - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 *     - :persistResp - Respond immediately once persisted with the ledger-id, don't wait for transaction to be finished
 *     - :jwt         - token for Fluree On-Demand access
 *     
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__76031 = arguments.length;
switch (G__76031) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76158){
var state_val_76159 = (state_76158[(1)]);
if((state_val_76159 === (7))){
var inst_76057 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76158__$1 = state_76158;
var statearr_76160_76230 = state_76158__$1;
(statearr_76160_76230[(2)] = inst_76057);

(statearr_76160_76230[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (20))){
var inst_76064 = (state_76158[(7)]);
var inst_76103 = (state_76158[(2)]);
var inst_76104 = fluree.db.util.core.current_time_millis();
var state_76158__$1 = (function (){var statearr_76161 = state_76158;
(statearr_76161[(8)] = inst_76103);

(statearr_76161[(9)] = inst_76104);

return statearr_76161;
})();
if(cljs.core.truth_(inst_76064)){
var statearr_76162_76231 = state_76158__$1;
(statearr_76162_76231[(1)] = (21));

} else {
var statearr_76163_76232 = state_76158__$1;
(statearr_76163_76232[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (27))){
var inst_76072 = (state_76158[(10)]);
var inst_76117 = (state_76158[(11)]);
var inst_76119 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76117,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_76072);
var state_76158__$1 = state_76158;
var statearr_76164_76233 = state_76158__$1;
(statearr_76164_76233[(2)] = inst_76119);

(statearr_76164_76233[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (1))){
var state_76158__$1 = state_76158;
var statearr_76165_76234 = state_76158__$1;
(statearr_76165_76234[(2)] = null);

(statearr_76165_76234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (24))){
var inst_76070 = (state_76158[(12)]);
var state_76158__$1 = state_76158;
var statearr_76166_76235 = state_76158__$1;
(statearr_76166_76235[(2)] = inst_76070);

(statearr_76166_76235[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (39))){
var inst_76140 = (state_76158[(2)]);
var inst_76141 = fluree.db.util.async.throw_err(inst_76140);
var state_76158__$1 = state_76158;
var statearr_76167_76236 = state_76158__$1;
(statearr_76167_76236[(2)] = inst_76141);

(statearr_76167_76236[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (4))){
var inst_76032 = (state_76158[(2)]);
var inst_76033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76034 = [inst_76032];
var inst_76035 = (new cljs.core.PersistentVector(null,1,(5),inst_76033,inst_76034,null));
var inst_76036 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76035);
var inst_76037 = cljs.core.ex_data(inst_76032);
var inst_76038 = cljs.core.ex_message(inst_76032);
var inst_76039 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76037,new cljs.core.Keyword(null,"message","message",-406056002),inst_76038);
var inst_76040 = cljs.core.clj__GT_js(inst_76039);
var inst_76041 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76040) : reject.call(null,inst_76040));
var state_76158__$1 = (function (){var statearr_76168 = state_76158;
(statearr_76168[(13)] = inst_76036);

return statearr_76168;
})();
var statearr_76169_76237 = state_76158__$1;
(statearr_76169_76237[(2)] = inst_76041);

(statearr_76169_76237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (15))){
var inst_76093 = (state_76158[(14)]);
var inst_76095 = fluree.db.graphdb.validate_ledger_name(inst_76093,"alias");
var state_76158__$1 = state_76158;
var statearr_76170_76238 = state_76158__$1;
(statearr_76170_76238[(2)] = inst_76095);

(statearr_76170_76238[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (21))){
var inst_76064 = (state_76158[(7)]);
var state_76158__$1 = state_76158;
var statearr_76171_76239 = state_76158__$1;
(statearr_76171_76239[(2)] = inst_76064);

(statearr_76171_76239[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (31))){
var state_76158__$1 = state_76158;
var statearr_76172_76240 = state_76158__$1;
(statearr_76172_76240[(2)] = null);

(statearr_76172_76240[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (32))){
var inst_76066 = (state_76158[(15)]);
var inst_76128 = (state_76158[(2)]);
var state_76158__$1 = (function (){var statearr_76173 = state_76158;
(statearr_76173[(16)] = inst_76128);

return statearr_76173;
})();
if(cljs.core.truth_(inst_76066)){
var statearr_76174_76241 = state_76158__$1;
(statearr_76174_76241[(1)] = (33));

} else {
var statearr_76175_76242 = state_76158__$1;
(statearr_76175_76242[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (40))){
var inst_76145 = (state_76158[(2)]);
var inst_76146 = fluree.db.util.async.throw_err(inst_76145);
var state_76158__$1 = state_76158;
var statearr_76176_76243 = state_76158__$1;
(statearr_76176_76243[(2)] = inst_76146);

(statearr_76176_76243[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (33))){
var inst_76066 = (state_76158[(15)]);
var inst_76128 = (state_76158[(16)]);
var inst_76130 = fluree.crypto.sign_message(inst_76128,inst_76066);
var state_76158__$1 = state_76158;
var statearr_76177_76244 = state_76158__$1;
(statearr_76177_76244[(2)] = inst_76130);

(statearr_76177_76244[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (13))){
var state_76158__$1 = state_76158;
var statearr_76178_76245 = state_76158__$1;
(statearr_76178_76245[(2)] = null);

(statearr_76178_76245[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (22))){
var inst_76104 = (state_76158[(9)]);
var state_76158__$1 = state_76158;
var statearr_76179_76246 = state_76158__$1;
(statearr_76179_76246[(2)] = inst_76104);

(statearr_76179_76246[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (36))){
var inst_76133 = (state_76158[(17)]);
var inst_76128 = (state_76158[(16)]);
var inst_76135 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_76136 = [inst_76128,inst_76133];
var inst_76137 = cljs.core.PersistentHashMap.fromArrays(inst_76135,inst_76136);
var inst_76138 = fluree.db.operations.command_async(conn,inst_76137);
var state_76158__$1 = state_76158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76158__$1,(39),inst_76138);
} else {
if((state_val_76159 === (29))){
var inst_76066 = (state_76158[(15)]);
var inst_76122 = (state_76158[(2)]);
var state_76158__$1 = (function (){var statearr_76180 = state_76158;
(statearr_76180[(18)] = inst_76122);

return statearr_76180;
})();
if(cljs.core.truth_(inst_76066)){
var statearr_76181_76247 = state_76158__$1;
(statearr_76181_76247[(1)] = (30));

} else {
var statearr_76182_76248 = state_76158__$1;
(statearr_76182_76248[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (6))){
var state_76158__$1 = state_76158;
var statearr_76183_76249 = state_76158__$1;
(statearr_76183_76249[(2)] = null);

(statearr_76183_76249[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (28))){
var inst_76117 = (state_76158[(11)]);
var state_76158__$1 = state_76158;
var statearr_76184_76250 = state_76158__$1;
(statearr_76184_76250[(2)] = inst_76117);

(statearr_76184_76250[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (25))){
var inst_76104 = (state_76158[(9)]);
var inst_76111 = (inst_76104 + (30000));
var state_76158__$1 = state_76158;
var statearr_76185_76251 = state_76158__$1;
(statearr_76185_76251[(2)] = inst_76111);

(statearr_76185_76251[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (34))){
var state_76158__$1 = state_76158;
var statearr_76186_76252 = state_76158__$1;
(statearr_76186_76252[(2)] = null);

(statearr_76186_76252[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (17))){
var inst_76074 = (state_76158[(19)]);
var inst_76098 = (state_76158[(2)]);
var state_76158__$1 = (function (){var statearr_76187 = state_76158;
(statearr_76187[(20)] = inst_76098);

return statearr_76187;
})();
if(cljs.core.truth_(inst_76074)){
var statearr_76188_76253 = state_76158__$1;
(statearr_76188_76253[(1)] = (18));

} else {
var statearr_76189_76254 = state_76158__$1;
(statearr_76189_76254[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (3))){
var inst_76156 = (state_76158[(2)]);
var state_76158__$1 = state_76158;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76158__$1,inst_76156);
} else {
if((state_val_76159 === (12))){
var inst_76088 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_76158__$1 = state_76158;
var statearr_76190_76255 = state_76158__$1;
(statearr_76190_76255[(2)] = inst_76088);

(statearr_76190_76255[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (2))){
var _ = (function (){var statearr_76191 = state_76158;
(statearr_76191[(4)] = cljs.core.cons((5),(state_76158[(4)])));

return statearr_76191;
})();
var inst_76054 = (opts == null);
var state_76158__$1 = state_76158;
if(cljs.core.truth_(inst_76054)){
var statearr_76192_76256 = state_76158__$1;
(statearr_76192_76256[(1)] = (6));

} else {
var statearr_76193_76257 = state_76158__$1;
(statearr_76193_76257[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (23))){
var inst_76070 = (state_76158[(12)]);
var inst_76108 = (state_76158[(2)]);
var state_76158__$1 = (function (){var statearr_76194 = state_76158;
(statearr_76194[(21)] = inst_76108);

return statearr_76194;
})();
if(cljs.core.truth_(inst_76070)){
var statearr_76195_76258 = state_76158__$1;
(statearr_76195_76258[(1)] = (24));

} else {
var statearr_76196_76259 = state_76158__$1;
(statearr_76196_76259[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (35))){
var inst_76066 = (state_76158[(15)]);
var inst_76133 = (state_76158[(2)]);
var state_76158__$1 = (function (){var statearr_76197 = state_76158;
(statearr_76197[(17)] = inst_76133);

return statearr_76197;
})();
if(cljs.core.truth_(inst_76066)){
var statearr_76198_76260 = state_76158__$1;
(statearr_76198_76260[(1)] = (36));

} else {
var statearr_76199_76261 = state_76158__$1;
(statearr_76199_76261[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (19))){
var state_76158__$1 = state_76158;
var statearr_76200_76262 = state_76158__$1;
(statearr_76200_76262[(2)] = null);

(statearr_76200_76262[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (11))){
var inst_76077 = (state_76158[(22)]);
var inst_76084 = (state_76158[(23)]);
var inst_76074 = (state_76158[(19)]);
var inst_76084__$1 = (state_76158[(2)]);
var inst_76085 = fluree.db.graphdb.validate_ledger_name(inst_76084__$1,"ledger");
var inst_76086 = fluree.db.graphdb.validate_ledger_name(inst_76077,"network");
var state_76158__$1 = (function (){var statearr_76202 = state_76158;
(statearr_76202[(23)] = inst_76084__$1);

(statearr_76202[(24)] = inst_76086);

(statearr_76202[(25)] = inst_76085);

return statearr_76202;
})();
if(cljs.core.truth_(inst_76074)){
var statearr_76203_76263 = state_76158__$1;
(statearr_76203_76263[(1)] = (12));

} else {
var statearr_76204_76264 = state_76158__$1;
(statearr_76204_76264[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (9))){
var inst_76078 = (state_76158[(26)]);
var inst_76081 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_76078,(1));
var state_76158__$1 = state_76158;
var statearr_76205_76265 = state_76158__$1;
(statearr_76205_76265[(2)] = inst_76081);

(statearr_76205_76265[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (5))){
var _ = (function (){var statearr_76206 = state_76158;
(statearr_76206[(4)] = cljs.core.rest((state_76158[(4)])));

return statearr_76206;
})();
var state_76158__$1 = state_76158;
var ex76201 = (state_76158__$1[(2)]);
var statearr_76207_76266 = state_76158__$1;
(statearr_76207_76266[(5)] = ex76201);


var statearr_76208_76267 = state_76158__$1;
(statearr_76208_76267[(1)] = (4));

(statearr_76208_76267[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (14))){
var inst_76074 = (state_76158[(19)]);
var inst_76091 = (state_76158[(2)]);
var inst_76092 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76091,(0),null);
var inst_76093 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76091,(1),null);
var state_76158__$1 = (function (){var statearr_76209 = state_76158;
(statearr_76209[(27)] = inst_76092);

(statearr_76209[(14)] = inst_76093);

return statearr_76209;
})();
if(cljs.core.truth_(inst_76074)){
var statearr_76210_76268 = state_76158__$1;
(statearr_76210_76268[(1)] = (15));

} else {
var statearr_76211_76269 = state_76158__$1;
(statearr_76211_76269[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (26))){
var inst_76077 = (state_76158[(22)]);
var inst_76084 = (state_76158[(23)]);
var inst_76069 = (state_76158[(28)]);
var inst_76103 = (state_76158[(8)]);
var inst_76072 = (state_76158[(10)]);
var inst_76065 = (state_76158[(29)]);
var inst_76068 = (state_76158[(30)]);
var inst_76075 = (state_76158[(31)]);
var inst_76108 = (state_76158[(21)]);
var inst_76073 = (state_76158[(32)]);
var inst_76063 = (state_76158[(33)]);
var inst_76071 = (state_76158[(34)]);
var inst_76067 = (state_76158[(35)]);
var inst_76113 = (state_76158[(2)]);
var inst_76114 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_76115 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76077),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76084)].join('');
var inst_76116 = [inst_76115,inst_76068,inst_76069,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_76113,inst_76071,inst_76103,inst_76075,inst_76073,inst_76063,inst_76108,inst_76065,inst_76067];
var inst_76117 = cljs.core.PersistentHashMap.fromArrays(inst_76114,inst_76116);
var state_76158__$1 = (function (){var statearr_76212 = state_76158;
(statearr_76212[(11)] = inst_76117);

return statearr_76212;
})();
if(cljs.core.truth_(inst_76072)){
var statearr_76213_76270 = state_76158__$1;
(statearr_76213_76270[(1)] = (27));

} else {
var statearr_76214_76271 = state_76158__$1;
(statearr_76214_76271[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (16))){
var state_76158__$1 = state_76158;
var statearr_76215_76272 = state_76158__$1;
(statearr_76215_76272[(2)] = null);

(statearr_76215_76272[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (38))){
var inst_76148 = (state_76158[(2)]);
var inst_76149 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_76150 = [(200),inst_76148];
var inst_76151 = cljs.core.PersistentHashMap.fromArrays(inst_76149,inst_76150);
var inst_76152 = cljs.core.clj__GT_js(inst_76151);
var inst_76153 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76152) : resolve.call(null,inst_76152));
var _ = (function (){var statearr_76216 = state_76158;
(statearr_76216[(4)] = cljs.core.rest((state_76158[(4)])));

return statearr_76216;
})();
var state_76158__$1 = state_76158;
var statearr_76217_76273 = state_76158__$1;
(statearr_76217_76273[(2)] = inst_76153);

(statearr_76217_76273[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (30))){
var inst_76122 = (state_76158[(18)]);
var inst_76124 = fluree.db.util.core.without_nils(inst_76122);
var inst_76125 = fluree.db.util.json.stringify(inst_76124);
var state_76158__$1 = state_76158;
var statearr_76218_76274 = state_76158__$1;
(statearr_76218_76274[(2)] = inst_76125);

(statearr_76218_76274[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (10))){
var inst_76078 = (state_76158[(26)]);
var state_76158__$1 = state_76158;
var statearr_76219_76275 = state_76158__$1;
(statearr_76219_76275[(2)] = inst_76078);

(statearr_76219_76275[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (18))){
var inst_76092 = (state_76158[(27)]);
var inst_76093 = (state_76158[(14)]);
var inst_76100 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76092),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76093)].join('');
var state_76158__$1 = state_76158;
var statearr_76220_76276 = state_76158__$1;
(statearr_76220_76276[(2)] = inst_76100);

(statearr_76220_76276[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76159 === (37))){
var inst_76122 = (state_76158[(18)]);
var inst_76143 = fluree.db.operations.unsigned_command_async(conn,inst_76122);
var state_76158__$1 = state_76158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76158__$1,(40),inst_76143);
} else {
if((state_val_76159 === (8))){
var inst_76078 = (state_76158[(26)]);
var inst_76059 = (state_76158[(2)]);
var inst_76060 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_76059);
var inst_76061 = cljs.core.__destructure_map(inst_76059);
var inst_76062 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_76061,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_76063 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76061,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_76064 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76061,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_76065 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76061,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_76066 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76061,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_76067 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76061,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_76068 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76061,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_76069 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76061,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_76070 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76061,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_76071 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76061,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_76072 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76061,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_76073 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76061,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_76074 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76061,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_76075 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76061,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_76076 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_76077 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76076,(0),null);
var inst_76078__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76076,(1),null);
var inst_76079 = clojure.string.starts_with_QMARK_(inst_76078__$1,"$");
var state_76158__$1 = (function (){var statearr_76221 = state_76158;
(statearr_76221[(22)] = inst_76077);

(statearr_76221[(19)] = inst_76074);

(statearr_76221[(28)] = inst_76069);

(statearr_76221[(10)] = inst_76072);

(statearr_76221[(15)] = inst_76066);

(statearr_76221[(36)] = inst_76062);

(statearr_76221[(29)] = inst_76065);

(statearr_76221[(30)] = inst_76068);

(statearr_76221[(7)] = inst_76064);

(statearr_76221[(37)] = inst_76060);

(statearr_76221[(31)] = inst_76075);

(statearr_76221[(12)] = inst_76070);

(statearr_76221[(26)] = inst_76078__$1);

(statearr_76221[(32)] = inst_76073);

(statearr_76221[(33)] = inst_76063);

(statearr_76221[(34)] = inst_76071);

(statearr_76221[(35)] = inst_76067);

return statearr_76221;
})();
if(inst_76079){
var statearr_76222_76277 = state_76158__$1;
(statearr_76222_76277[(1)] = (9));

} else {
var statearr_76223_76278 = state_76158__$1;
(statearr_76223_76278[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76224 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76224[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76224[(1)] = (1));

return statearr_76224;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76158){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76158);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76225){var ex__2730__auto__ = e76225;
var statearr_76226_76279 = state_76158;
(statearr_76226_76279[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76158[(4)]))){
var statearr_76227_76280 = state_76158;
(statearr_76227_76280[(1)] = cljs.core.first((state_76158[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76281 = state_76158;
state_76158 = G__76281;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76158){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76228 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76228[(6)] = c__2749__auto__);

return statearr_76228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *    Returns a promise that will eventually contain a response or an exception
 *    if the timeout period has expired.
 * 
 *    Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76304){
var state_val_76305 = (state_76304[(1)]);
if((state_val_76305 === (1))){
var state_76304__$1 = state_76304;
var statearr_76306_76322 = state_76304__$1;
(statearr_76306_76322[(2)] = null);

(statearr_76306_76322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76305 === (2))){
var _ = (function (){var statearr_76307 = state_76304;
(statearr_76307[(4)] = cljs.core.cons((5),(state_76304[(4)])));

return statearr_76307;
})();
var inst_76294 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76295 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_76304__$1 = (function (){var statearr_76308 = state_76304;
(statearr_76308[(7)] = inst_76294);

return statearr_76308;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76304__$1,(6),inst_76295);
} else {
if((state_val_76305 === (3))){
var inst_76302 = (state_76304[(2)]);
var state_76304__$1 = state_76304;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76304__$1,inst_76302);
} else {
if((state_val_76305 === (4))){
var inst_76282 = (state_76304[(2)]);
var inst_76283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76284 = [inst_76282];
var inst_76285 = (new cljs.core.PersistentVector(null,1,(5),inst_76283,inst_76284,null));
var inst_76286 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76285);
var inst_76287 = cljs.core.clj__GT_js(inst_76282);
var inst_76288 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76287) : reject.call(null,inst_76287));
var state_76304__$1 = (function (){var statearr_76310 = state_76304;
(statearr_76310[(8)] = inst_76286);

return statearr_76310;
})();
var statearr_76311_76323 = state_76304__$1;
(statearr_76311_76323[(2)] = inst_76288);

(statearr_76311_76323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76305 === (5))){
var _ = (function (){var statearr_76312 = state_76304;
(statearr_76312[(4)] = cljs.core.rest((state_76304[(4)])));

return statearr_76312;
})();
var state_76304__$1 = state_76304;
var ex76309 = (state_76304__$1[(2)]);
var statearr_76313_76324 = state_76304__$1;
(statearr_76313_76324[(5)] = ex76309);


var statearr_76314_76325 = state_76304__$1;
(statearr_76314_76325[(1)] = (4));

(statearr_76314_76325[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76305 === (6))){
var inst_76297 = (state_76304[(2)]);
var inst_76298 = cljs.core.clj__GT_js(inst_76297);
var inst_76299 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76298) : resolve.call(null,inst_76298));
var _ = (function (){var statearr_76315 = state_76304;
(statearr_76315[(4)] = cljs.core.rest((state_76304[(4)])));

return statearr_76315;
})();
var state_76304__$1 = state_76304;
var statearr_76316_76326 = state_76304__$1;
(statearr_76316_76326[(2)] = inst_76299);

(statearr_76316_76326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__2727__auto__ = null;
var flureedb$monitor_tx_$_state_machine__2727__auto____0 = (function (){
var statearr_76317 = [null,null,null,null,null,null,null,null,null];
(statearr_76317[(0)] = flureedb$monitor_tx_$_state_machine__2727__auto__);

(statearr_76317[(1)] = (1));

return statearr_76317;
});
var flureedb$monitor_tx_$_state_machine__2727__auto____1 = (function (state_76304){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76304);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76318){var ex__2730__auto__ = e76318;
var statearr_76319_76327 = state_76304;
(statearr_76319_76327[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76304[(4)]))){
var statearr_76320_76328 = state_76304;
(statearr_76320_76328[(1)] = cljs.core.first((state_76304[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76329 = state_76304;
state_76304 = G__76329;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__2727__auto__ = function(state_76304){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__2727__auto____1.call(this,state_76304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__2727__auto____0;
flureedb$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__2727__auto____1;
return flureedb$monitor_tx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76321 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76321[(6)] = c__2749__auto__);

return statearr_76321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 *     that will eventually have the result of the tx, the txid (if :txid-only option used), or
 *     an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 *     Will locally sign a final transaction command if a private key is provided via :private-key
 *     in the options, otherwise will submit the transaction to the connected ledger and request signature,
 *     provided the ledger group has a default private key available for signing.
 * 
 *     Options (opts) is a map with the following possible keys:
 *     - private-key - The private key to use for signing. If not present, a default
 *                     private key will attempt to be used from the connection, if available.
 *     - auth        - The auth id for the auth record being used. The private key must
 *                     correspond to this auth record, or an authority of this auth record.
 *     - expire      - When this transaction should expire if not yet attempted.
 *                     Defaults to 5 minutes.
 *     - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                     By default epoch milliseconds is used.
 *     - deps        - List of one or more txids that must be successfully processed before
 *                     this tx is processed. If any fail, this tx will fail. (not yet implemented)
 *     - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                     but instead return with the txid once it is successfully persisted by the
 *                     transactors. The txid can be used to look up/monitor the response at a later time.
 *     - timeout     - will respond with an exception if timeout reached before response available.
 *     - jwt         - token to access Fluree On-Demand
 *     
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__76331 = arguments.length;
switch (G__76331) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76360){
var state_val_76361 = (state_76360[(1)]);
if((state_val_76361 === (7))){
var inst_76346 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76360__$1 = state_76360;
var statearr_76362_76383 = state_76360__$1;
(statearr_76362_76383[(2)] = inst_76346);

(statearr_76362_76383[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76361 === (1))){
var state_76360__$1 = state_76360;
var statearr_76363_76384 = state_76360__$1;
(statearr_76363_76384[(2)] = null);

(statearr_76363_76384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76361 === (4))){
var inst_76332 = (state_76360[(2)]);
var inst_76333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76334 = [inst_76332];
var inst_76335 = (new cljs.core.PersistentVector(null,1,(5),inst_76333,inst_76334,null));
var inst_76336 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76335);
var inst_76337 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76332) : reject.call(null,inst_76332));
var state_76360__$1 = (function (){var statearr_76364 = state_76360;
(statearr_76364[(7)] = inst_76336);

return statearr_76364;
})();
var statearr_76365_76385 = state_76360__$1;
(statearr_76365_76385[(2)] = inst_76337);

(statearr_76365_76385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76361 === (6))){
var state_76360__$1 = state_76360;
var statearr_76366_76386 = state_76360__$1;
(statearr_76366_76386[(2)] = null);

(statearr_76366_76386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76361 === (3))){
var inst_76358 = (state_76360[(2)]);
var state_76360__$1 = state_76360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76360__$1,inst_76358);
} else {
if((state_val_76361 === (2))){
var _ = (function (){var statearr_76368 = state_76360;
(statearr_76368[(4)] = cljs.core.cons((5),(state_76360[(4)])));

return statearr_76368;
})();
var inst_76343 = (opts == null);
var state_76360__$1 = state_76360;
if(cljs.core.truth_(inst_76343)){
var statearr_76369_76387 = state_76360__$1;
(statearr_76369_76387[(1)] = (6));

} else {
var statearr_76370_76388 = state_76360__$1;
(statearr_76370_76388[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76361 === (9))){
var inst_76353 = (state_76360[(2)]);
var inst_76354 = cljs.core.clj__GT_js(inst_76353);
var inst_76355 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76354) : resolve.call(null,inst_76354));
var _ = (function (){var statearr_76371 = state_76360;
(statearr_76371[(4)] = cljs.core.rest((state_76360[(4)])));

return statearr_76371;
})();
var state_76360__$1 = state_76360;
var statearr_76372_76389 = state_76360__$1;
(statearr_76372_76389[(2)] = inst_76355);

(statearr_76372_76389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76361 === (5))){
var _ = (function (){var statearr_76373 = state_76360;
(statearr_76373[(4)] = cljs.core.rest((state_76360[(4)])));

return statearr_76373;
})();
var state_76360__$1 = state_76360;
var ex76367 = (state_76360__$1[(2)]);
var statearr_76374_76390 = state_76360__$1;
(statearr_76374_76390[(5)] = ex76367);


var statearr_76375_76391 = state_76360__$1;
(statearr_76375_76391[(1)] = (4));

(statearr_76375_76391[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76361 === (8))){
var inst_76348 = (state_76360[(2)]);
var inst_76349 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_76348);
var inst_76350 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_76351 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_76350,inst_76348);
var state_76360__$1 = (function (){var statearr_76376 = state_76360;
(statearr_76376[(8)] = inst_76349);

return statearr_76376;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76360__$1,(9),inst_76351);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76377 = [null,null,null,null,null,null,null,null,null];
(statearr_76377[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76377[(1)] = (1));

return statearr_76377;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76360){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76360);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76378){var ex__2730__auto__ = e76378;
var statearr_76379_76392 = state_76360;
(statearr_76379_76392[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76360[(4)]))){
var statearr_76380_76393 = state_76360;
(statearr_76380_76393[(1)] = cljs.core.first((state_76360[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76394 = state_76360;
state_76360 = G__76394;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76360){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76381 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76381[(6)] = c__2749__auto__);

return statearr_76381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *    to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *    :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__76396 = arguments.length;
switch (G__76396) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76428){
var state_val_76429 = (state_76428[(1)]);
if((state_val_76429 === (7))){
var inst_76411 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76428__$1 = state_76428;
var statearr_76430_76451 = state_76428__$1;
(statearr_76430_76451[(2)] = inst_76411);

(statearr_76430_76451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76429 === (1))){
var state_76428__$1 = state_76428;
var statearr_76431_76452 = state_76428__$1;
(statearr_76431_76452[(2)] = null);

(statearr_76431_76452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76429 === (4))){
var inst_76397 = (state_76428[(2)]);
var inst_76398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76399 = [inst_76397];
var inst_76400 = (new cljs.core.PersistentVector(null,1,(5),inst_76398,inst_76399,null));
var inst_76401 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76400);
var inst_76402 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76397) : reject.call(null,inst_76397));
var state_76428__$1 = (function (){var statearr_76432 = state_76428;
(statearr_76432[(7)] = inst_76401);

return statearr_76432;
})();
var statearr_76433_76453 = state_76428__$1;
(statearr_76433_76453[(2)] = inst_76402);

(statearr_76433_76453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76429 === (6))){
var state_76428__$1 = state_76428;
var statearr_76434_76454 = state_76428__$1;
(statearr_76434_76454[(2)] = null);

(statearr_76434_76454[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76429 === (3))){
var inst_76426 = (state_76428[(2)]);
var state_76428__$1 = state_76428;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76428__$1,inst_76426);
} else {
if((state_val_76429 === (2))){
var _ = (function (){var statearr_76436 = state_76428;
(statearr_76436[(4)] = cljs.core.cons((5),(state_76428[(4)])));

return statearr_76436;
})();
var inst_76408 = (opts == null);
var state_76428__$1 = state_76428;
if(cljs.core.truth_(inst_76408)){
var statearr_76437_76455 = state_76428__$1;
(statearr_76437_76455[(1)] = (6));

} else {
var statearr_76438_76456 = state_76428__$1;
(statearr_76438_76456[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76429 === (9))){
var inst_76413 = (state_76428[(8)]);
var inst_76416 = (state_76428[(2)]);
var inst_76417 = fluree.db.util.async.throw_err(inst_76416);
var inst_76418 = fluree.db.query.block.block_range(inst_76417,start,end,inst_76413);
var state_76428__$1 = state_76428;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76428__$1,(10),inst_76418);
} else {
if((state_val_76429 === (5))){
var _ = (function (){var statearr_76439 = state_76428;
(statearr_76439[(4)] = cljs.core.rest((state_76428[(4)])));

return statearr_76439;
})();
var state_76428__$1 = state_76428;
var ex76435 = (state_76428__$1[(2)]);
var statearr_76440_76457 = state_76428__$1;
(statearr_76440_76457[(5)] = ex76435);


var statearr_76441_76458 = state_76428__$1;
(statearr_76441_76458[(1)] = (4));

(statearr_76441_76458[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76429 === (10))){
var inst_76420 = (state_76428[(2)]);
var inst_76421 = fluree.db.util.async.throw_err(inst_76420);
var inst_76422 = cljs.core.clj__GT_js(inst_76421);
var inst_76423 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76422) : resolve.call(null,inst_76422));
var _ = (function (){var statearr_76442 = state_76428;
(statearr_76442[(4)] = cljs.core.rest((state_76428[(4)])));

return statearr_76442;
})();
var state_76428__$1 = state_76428;
var statearr_76443_76459 = state_76428__$1;
(statearr_76443_76459[(2)] = inst_76423);

(statearr_76443_76459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76429 === (8))){
var inst_76413 = (state_76428[(8)]);
var inst_76413__$1 = (state_76428[(2)]);
var inst_76414 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76413__$1], 0));
var state_76428__$1 = (function (){var statearr_76444 = state_76428;
(statearr_76444[(8)] = inst_76413__$1);

return statearr_76444;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76428__$1,(9),inst_76414);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76445 = [null,null,null,null,null,null,null,null,null];
(statearr_76445[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76445[(1)] = (1));

return statearr_76445;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76428){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76428);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76446){var ex__2730__auto__ = e76446;
var statearr_76447_76460 = state_76428;
(statearr_76447_76460[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76428[(4)]))){
var statearr_76448_76461 = state_76428;
(statearr_76448_76461[(1)] = cljs.core.first((state_76428[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76462 = state_76428;
state_76428 = G__76462;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76428){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76428);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76449 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76449[(6)] = c__2749__auto__);

return statearr_76449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 *     start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 *     containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__76464 = arguments.length;
switch (G__76464) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76502){
var state_val_76503 = (state_76502[(1)]);
if((state_val_76503 === (7))){
var inst_76480 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76502__$1 = state_76502;
var statearr_76504_76525 = state_76502__$1;
(statearr_76504_76525[(2)] = inst_76480);

(statearr_76504_76525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76503 === (1))){
var state_76502__$1 = state_76502;
var statearr_76505_76526 = state_76502__$1;
(statearr_76505_76526[(2)] = null);

(statearr_76505_76526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76503 === (4))){
var inst_76465 = (state_76502[(2)]);
var inst_76466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76467 = [inst_76465];
var inst_76468 = (new cljs.core.PersistentVector(null,1,(5),inst_76466,inst_76467,null));
var inst_76469 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76468);
var inst_76470 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76465) : reject.call(null,inst_76465));
var state_76502__$1 = (function (){var statearr_76506 = state_76502;
(statearr_76506[(7)] = inst_76469);

return statearr_76506;
})();
var statearr_76507_76527 = state_76502__$1;
(statearr_76507_76527[(2)] = inst_76470);

(statearr_76507_76527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76503 === (6))){
var state_76502__$1 = state_76502;
var statearr_76508_76528 = state_76502__$1;
(statearr_76508_76528[(2)] = null);

(statearr_76508_76528[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76503 === (3))){
var inst_76500 = (state_76502[(2)]);
var state_76502__$1 = state_76502;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76502__$1,inst_76500);
} else {
if((state_val_76503 === (2))){
var _ = (function (){var statearr_76510 = state_76502;
(statearr_76510[(4)] = cljs.core.cons((5),(state_76502[(4)])));

return statearr_76510;
})();
var inst_76477 = (opts == null);
var state_76502__$1 = state_76502;
if(cljs.core.truth_(inst_76477)){
var statearr_76511_76529 = state_76502__$1;
(statearr_76511_76529[(1)] = (6));

} else {
var statearr_76512_76530 = state_76502__$1;
(statearr_76512_76530[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76503 === (9))){
var inst_76485 = (state_76502[(8)]);
var inst_76482 = (state_76502[(9)]);
var inst_76486 = (state_76502[(10)]);
var inst_76489 = (state_76502[(2)]);
var inst_76490 = fluree.db.util.async.throw_err(inst_76489);
var inst_76491 = fluree.db.query.block.block_range(inst_76490,inst_76485,inst_76486,inst_76482);
var state_76502__$1 = state_76502;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76502__$1,(10),inst_76491);
} else {
if((state_val_76503 === (5))){
var _ = (function (){var statearr_76513 = state_76502;
(statearr_76513[(4)] = cljs.core.rest((state_76502[(4)])));

return statearr_76513;
})();
var state_76502__$1 = state_76502;
var ex76509 = (state_76502__$1[(2)]);
var statearr_76514_76531 = state_76502__$1;
(statearr_76514_76531[(5)] = ex76509);


var statearr_76515_76532 = state_76502__$1;
(statearr_76515_76532[(1)] = (4));

(statearr_76515_76532[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76503 === (10))){
var inst_76493 = (state_76502[(2)]);
var inst_76494 = fluree.db.util.async.throw_err(inst_76493);
var inst_76495 = fluree.db.query.range.block_with_tx_data(inst_76494);
var inst_76496 = cljs.core.clj__GT_js(inst_76495);
var inst_76497 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76496) : resolve.call(null,inst_76496));
var _ = (function (){var statearr_76516 = state_76502;
(statearr_76516[(4)] = cljs.core.rest((state_76502[(4)])));

return statearr_76516;
})();
var state_76502__$1 = state_76502;
var statearr_76517_76533 = state_76502__$1;
(statearr_76517_76533[(2)] = inst_76497);

(statearr_76517_76533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76503 === (8))){
var inst_76482 = (state_76502[(9)]);
var inst_76482__$1 = (state_76502[(2)]);
var inst_76483 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_76484 = cljs.core.__destructure_map(inst_76483);
var inst_76485 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76484,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_76486 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76484,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_76487 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76482__$1], 0));
var state_76502__$1 = (function (){var statearr_76518 = state_76502;
(statearr_76518[(8)] = inst_76485);

(statearr_76518[(9)] = inst_76482__$1);

(statearr_76518[(10)] = inst_76486);

return statearr_76518;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76502__$1,(9),inst_76487);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76519 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_76519[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76519[(1)] = (1));

return statearr_76519;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76502){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76502);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76520){var ex__2730__auto__ = e76520;
var statearr_76521_76534 = state_76502;
(statearr_76521_76534[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76502[(4)]))){
var statearr_76522_76535 = state_76502;
(statearr_76522_76535[(1)] = cljs.core.first((state_76502[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76536 = state_76502;
state_76502 = G__76536;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76502){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76523 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76523[(6)] = c__2749__auto__);

return statearr_76523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__76538 = arguments.length;
switch (G__76538) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76608){
var state_val_76609 = (state_76608[(1)]);
if((state_val_76609 === (7))){
var inst_76554 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76608__$1 = state_76608;
var statearr_76610_76651 = state_76608__$1;
(statearr_76610_76651[(2)] = inst_76554);

(statearr_76610_76651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (20))){
var inst_76550 = (state_76608[(7)]);
var inst_76556 = (state_76608[(8)]);
var inst_76592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76593 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_76594 = (new cljs.core.PersistentVector(null,1,(5),inst_76592,inst_76593,null));
var inst_76595 = cljs.core.assoc_in(inst_76556,inst_76594,new cljs.core.Keyword(null,"block","block",664686210));
var inst_76596 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_76550,inst_76595);
var state_76608__$1 = state_76608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76608__$1,(23),inst_76596);
} else {
if((state_val_76609 === (1))){
var state_76608__$1 = state_76608;
var statearr_76611_76652 = state_76608__$1;
(statearr_76611_76652[(2)] = null);

(statearr_76611_76652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (4))){
var inst_76539 = (state_76608[(2)]);
var inst_76540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76541 = [inst_76539];
var inst_76542 = (new cljs.core.PersistentVector(null,1,(5),inst_76540,inst_76541,null));
var inst_76543 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76542);
var inst_76544 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76539) : reject.call(null,inst_76539));
var state_76608__$1 = (function (){var statearr_76612 = state_76608;
(statearr_76612[(9)] = inst_76543);

return statearr_76612;
})();
var statearr_76613_76653 = state_76608__$1;
(statearr_76613_76653[(2)] = inst_76544);

(statearr_76613_76653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (15))){
var inst_76580 = (state_76608[(2)]);
var inst_76581 = fluree.db.util.async.throw_err(inst_76580);
var state_76608__$1 = state_76608;
var statearr_76614_76654 = state_76608__$1;
(statearr_76614_76654[(2)] = inst_76581);

(statearr_76614_76654[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (21))){
var inst_76601 = (state_76608[(2)]);
var inst_76602 = cljs.core.clj__GT_js(inst_76601);
var inst_76603 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76602) : resolve.call(null,inst_76602));
var _ = (function (){var statearr_76615 = state_76608;
(statearr_76615[(4)] = cljs.core.rest((state_76608[(4)])));

return statearr_76615;
})();
var state_76608__$1 = state_76608;
var statearr_76616_76655 = state_76608__$1;
(statearr_76616_76655[(2)] = inst_76603);

(statearr_76616_76655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (13))){
var state_76608__$1 = state_76608;
var statearr_76617_76656 = state_76608__$1;
(statearr_76617_76656[(2)] = null);

(statearr_76617_76656[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (22))){
var inst_76589 = (state_76608[(2)]);
var inst_76590 = fluree.db.util.async.throw_err(inst_76589);
var state_76608__$1 = state_76608;
var statearr_76618_76657 = state_76608__$1;
(statearr_76618_76657[(2)] = inst_76590);

(statearr_76618_76657[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (6))){
var state_76608__$1 = state_76608;
var statearr_76619_76658 = state_76608__$1;
(statearr_76619_76658[(2)] = null);

(statearr_76619_76658[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (17))){
var state_76608__$1 = state_76608;
var statearr_76620_76659 = state_76608__$1;
(statearr_76620_76659[(2)] = null);

(statearr_76620_76659[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (3))){
var inst_76606 = (state_76608[(2)]);
var state_76608__$1 = state_76608;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76608__$1,inst_76606);
} else {
if((state_val_76609 === (12))){
var inst_76564 = (state_76608[(10)]);
var inst_76568 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_76608__$1 = (function (){var statearr_76621 = state_76608;
(statearr_76621[(11)] = inst_76568);

return statearr_76621;
})();
if(cljs.core.truth_(inst_76564)){
var statearr_76622_76660 = state_76608__$1;
(statearr_76622_76660[(1)] = (16));

} else {
var statearr_76623_76661 = state_76608__$1;
(statearr_76623_76661[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (2))){
var _ = (function (){var statearr_76624 = state_76608;
(statearr_76624[(4)] = cljs.core.cons((5),(state_76608[(4)])));

return statearr_76624;
})();
var inst_76550 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_76551 = (opts == null);
var state_76608__$1 = (function (){var statearr_76625 = state_76608;
(statearr_76625[(7)] = inst_76550);

return statearr_76625;
})();
if(cljs.core.truth_(inst_76551)){
var statearr_76626_76662 = state_76608__$1;
(statearr_76626_76662[(1)] = (6));

} else {
var statearr_76627_76663 = state_76608__$1;
(statearr_76627_76663[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (23))){
var inst_76598 = (state_76608[(2)]);
var inst_76599 = fluree.db.util.async.throw_err(inst_76598);
var state_76608__$1 = state_76608;
var statearr_76628_76664 = state_76608__$1;
(statearr_76628_76664[(2)] = inst_76599);

(statearr_76628_76664[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (19))){
var inst_76584 = (state_76608[(12)]);
var inst_76550 = (state_76608[(7)]);
var inst_76556 = (state_76608[(8)]);
var inst_76587 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_76584,inst_76550,inst_76556);
var state_76608__$1 = state_76608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76608__$1,(22),inst_76587);
} else {
if((state_val_76609 === (11))){
var inst_76556 = (state_76608[(8)]);
var inst_76558 = (state_76608[(13)]);
var inst_76564 = (state_76608[(2)]);
var inst_76565 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_76556);
var inst_76566 = (inst_76558 == null);
var state_76608__$1 = (function (){var statearr_76630 = state_76608;
(statearr_76630[(10)] = inst_76564);

(statearr_76630[(14)] = inst_76565);

return statearr_76630;
})();
if(cljs.core.truth_(inst_76566)){
var statearr_76631_76665 = state_76608__$1;
(statearr_76631_76665[(1)] = (12));

} else {
var statearr_76632_76666 = state_76608__$1;
(statearr_76632_76666[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (9))){
var inst_76559 = (state_76608[(15)]);
var state_76608__$1 = state_76608;
var statearr_76633_76667 = state_76608__$1;
(statearr_76633_76667[(2)] = inst_76559);

(statearr_76633_76667[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (5))){
var _ = (function (){var statearr_76634 = state_76608;
(statearr_76634[(4)] = cljs.core.rest((state_76608[(4)])));

return statearr_76634;
})();
var state_76608__$1 = state_76608;
var ex76629 = (state_76608__$1[(2)]);
var statearr_76635_76668 = state_76608__$1;
(statearr_76635_76668[(5)] = ex76629);


var statearr_76636_76669 = state_76608__$1;
(statearr_76636_76669[(1)] = (4));

(statearr_76636_76669[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (14))){
var inst_76558 = (state_76608[(13)]);
var inst_76584 = (state_76608[(2)]);
var inst_76585 = (inst_76558 == null);
var state_76608__$1 = (function (){var statearr_76637 = state_76608;
(statearr_76637[(12)] = inst_76584);

return statearr_76637;
})();
if(cljs.core.truth_(inst_76585)){
var statearr_76638_76670 = state_76608__$1;
(statearr_76638_76670[(1)] = (19));

} else {
var statearr_76639_76671 = state_76608__$1;
(statearr_76639_76671[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (16))){
var inst_76564 = (state_76608[(10)]);
var inst_76570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76571 = ["_auth/id",inst_76564];
var inst_76572 = (new cljs.core.PersistentVector(null,2,(5),inst_76570,inst_76571,null));
var state_76608__$1 = state_76608;
var statearr_76640_76672 = state_76608__$1;
(statearr_76640_76672[(2)] = inst_76572);

(statearr_76640_76672[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (10))){
var inst_76556 = (state_76608[(8)]);
var inst_76562 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_76556);
var state_76608__$1 = state_76608;
var statearr_76641_76673 = state_76608__$1;
(statearr_76641_76673[(2)] = inst_76562);

(statearr_76641_76673[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76609 === (18))){
var inst_76565 = (state_76608[(14)]);
var inst_76568 = (state_76608[(11)]);
var inst_76575 = (state_76608[(2)]);
var inst_76576 = [inst_76575,inst_76565];
var inst_76577 = cljs.core.PersistentHashMap.fromArrays(inst_76568,inst_76576);
var inst_76578 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76577], 0));
var state_76608__$1 = state_76608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76608__$1,(15),inst_76578);
} else {
if((state_val_76609 === (8))){
var inst_76559 = (state_76608[(15)]);
var inst_76556 = (state_76608[(8)]);
var inst_76556__$1 = (state_76608[(2)]);
var inst_76557 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_76556__$1);
var inst_76558 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_76556__$1);
var inst_76559__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_76556__$1);
var state_76608__$1 = (function (){var statearr_76642 = state_76608;
(statearr_76642[(15)] = inst_76559__$1);

(statearr_76642[(8)] = inst_76556__$1);

(statearr_76642[(13)] = inst_76558);

(statearr_76642[(16)] = inst_76557);

return statearr_76642;
})();
if(cljs.core.truth_(inst_76559__$1)){
var statearr_76643_76674 = state_76608__$1;
(statearr_76643_76674[(1)] = (9));

} else {
var statearr_76644_76675 = state_76608__$1;
(statearr_76644_76675[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76645 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76645[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76645[(1)] = (1));

return statearr_76645;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76608){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76608);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76646){var ex__2730__auto__ = e76646;
var statearr_76647_76676 = state_76608;
(statearr_76647_76676[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76608[(4)]))){
var statearr_76648_76677 = state_76608;
(statearr_76648_76677[(1)] = cljs.core.first((state_76608[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76678 = state_76608;
state_76608 = G__76678;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76608){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76649 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76649[(6)] = c__2749__auto__);

return statearr_76649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76701){
var state_val_76702 = (state_76701[(1)]);
if((state_val_76702 === (1))){
var state_76701__$1 = state_76701;
var statearr_76703_76718 = state_76701__$1;
(statearr_76703_76718[(2)] = null);

(statearr_76703_76718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76702 === (2))){
var _ = (function (){var statearr_76704 = state_76701;
(statearr_76704[(4)] = cljs.core.cons((5),(state_76701[(4)])));

return statearr_76704;
})();
var inst_76690 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_76691 = fluree.db.api.query.history_query_async(sources,inst_76690);
var state_76701__$1 = state_76701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76701__$1,(6),inst_76691);
} else {
if((state_val_76702 === (3))){
var inst_76699 = (state_76701[(2)]);
var state_76701__$1 = state_76701;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76701__$1,inst_76699);
} else {
if((state_val_76702 === (4))){
var inst_76679 = (state_76701[(2)]);
var inst_76680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76681 = [inst_76679];
var inst_76682 = (new cljs.core.PersistentVector(null,1,(5),inst_76680,inst_76681,null));
var inst_76683 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76682);
var inst_76684 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76679) : reject.call(null,inst_76679));
var state_76701__$1 = (function (){var statearr_76706 = state_76701;
(statearr_76706[(7)] = inst_76683);

return statearr_76706;
})();
var statearr_76707_76719 = state_76701__$1;
(statearr_76707_76719[(2)] = inst_76684);

(statearr_76707_76719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76702 === (5))){
var _ = (function (){var statearr_76708 = state_76701;
(statearr_76708[(4)] = cljs.core.rest((state_76701[(4)])));

return statearr_76708;
})();
var state_76701__$1 = state_76701;
var ex76705 = (state_76701__$1[(2)]);
var statearr_76709_76720 = state_76701__$1;
(statearr_76709_76720[(5)] = ex76705);


var statearr_76710_76721 = state_76701__$1;
(statearr_76710_76721[(1)] = (4));

(statearr_76710_76721[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76702 === (6))){
var inst_76693 = (state_76701[(2)]);
var inst_76694 = fluree.db.util.async.throw_err(inst_76693);
var inst_76695 = cljs.core.clj__GT_js(inst_76694);
var inst_76696 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76695) : resolve.call(null,inst_76695));
var _ = (function (){var statearr_76711 = state_76701;
(statearr_76711[(4)] = cljs.core.rest((state_76701[(4)])));

return statearr_76711;
})();
var state_76701__$1 = state_76701;
var statearr_76712_76722 = state_76701__$1;
(statearr_76712_76722[(2)] = inst_76696);

(statearr_76712_76722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__2727__auto__ = null;
var flureedb$history_query_$_state_machine__2727__auto____0 = (function (){
var statearr_76713 = [null,null,null,null,null,null,null,null];
(statearr_76713[(0)] = flureedb$history_query_$_state_machine__2727__auto__);

(statearr_76713[(1)] = (1));

return statearr_76713;
});
var flureedb$history_query_$_state_machine__2727__auto____1 = (function (state_76701){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76701);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76714){var ex__2730__auto__ = e76714;
var statearr_76715_76723 = state_76701;
(statearr_76715_76723[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76701[(4)]))){
var statearr_76716_76724 = state_76701;
(statearr_76716_76724[(1)] = cljs.core.first((state_76701[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76725 = state_76701;
state_76701 = G__76725;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__2727__auto__ = function(state_76701){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__2727__auto____1.call(this,state_76701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__2727__auto____0;
flureedb$history_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__2727__auto____1;
return flureedb$history_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76717 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76717[(6)] = c__2749__auto__);

return statearr_76717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76748){
var state_val_76749 = (state_76748[(1)]);
if((state_val_76749 === (1))){
var state_76748__$1 = state_76748;
var statearr_76750_76765 = state_76748__$1;
(statearr_76750_76765[(2)] = null);

(statearr_76750_76765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76749 === (2))){
var _ = (function (){var statearr_76751 = state_76748;
(statearr_76751[(4)] = cljs.core.cons((5),(state_76748[(4)])));

return statearr_76751;
})();
var inst_76737 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_76738 = fluree.db.api.query.multi_query_async(sources,inst_76737);
var state_76748__$1 = state_76748;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76748__$1,(6),inst_76738);
} else {
if((state_val_76749 === (3))){
var inst_76746 = (state_76748[(2)]);
var state_76748__$1 = state_76748;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76748__$1,inst_76746);
} else {
if((state_val_76749 === (4))){
var inst_76726 = (state_76748[(2)]);
var inst_76727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76728 = [inst_76726];
var inst_76729 = (new cljs.core.PersistentVector(null,1,(5),inst_76727,inst_76728,null));
var inst_76730 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76729);
var inst_76731 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76726) : reject.call(null,inst_76726));
var state_76748__$1 = (function (){var statearr_76753 = state_76748;
(statearr_76753[(7)] = inst_76730);

return statearr_76753;
})();
var statearr_76754_76766 = state_76748__$1;
(statearr_76754_76766[(2)] = inst_76731);

(statearr_76754_76766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76749 === (5))){
var _ = (function (){var statearr_76755 = state_76748;
(statearr_76755[(4)] = cljs.core.rest((state_76748[(4)])));

return statearr_76755;
})();
var state_76748__$1 = state_76748;
var ex76752 = (state_76748__$1[(2)]);
var statearr_76756_76767 = state_76748__$1;
(statearr_76756_76767[(5)] = ex76752);


var statearr_76757_76768 = state_76748__$1;
(statearr_76757_76768[(1)] = (4));

(statearr_76757_76768[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76749 === (6))){
var inst_76740 = (state_76748[(2)]);
var inst_76741 = fluree.db.util.async.throw_err(inst_76740);
var inst_76742 = cljs.core.clj__GT_js(inst_76741);
var inst_76743 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76742) : resolve.call(null,inst_76742));
var _ = (function (){var statearr_76758 = state_76748;
(statearr_76758[(4)] = cljs.core.rest((state_76748[(4)])));

return statearr_76758;
})();
var state_76748__$1 = state_76748;
var statearr_76759_76769 = state_76748__$1;
(statearr_76759_76769[(2)] = inst_76743);

(statearr_76759_76769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__2727__auto__ = null;
var flureedb$multi_query_$_state_machine__2727__auto____0 = (function (){
var statearr_76760 = [null,null,null,null,null,null,null,null];
(statearr_76760[(0)] = flureedb$multi_query_$_state_machine__2727__auto__);

(statearr_76760[(1)] = (1));

return statearr_76760;
});
var flureedb$multi_query_$_state_machine__2727__auto____1 = (function (state_76748){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76748);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76761){var ex__2730__auto__ = e76761;
var statearr_76762_76770 = state_76748;
(statearr_76762_76770[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76748[(4)]))){
var statearr_76763_76771 = state_76748;
(statearr_76763_76771[(1)] = cljs.core.first((state_76748[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76772 = state_76748;
state_76748 = G__76772;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__2727__auto__ = function(state_76748){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__2727__auto____1.call(this,state_76748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__2727__auto____0;
flureedb$multi_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__2727__auto____1;
return flureedb$multi_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76764 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76764[(6)] = c__2749__auto__);

return statearr_76764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76795){
var state_val_76796 = (state_76795[(1)]);
if((state_val_76796 === (1))){
var state_76795__$1 = state_76795;
var statearr_76797_76812 = state_76795__$1;
(statearr_76797_76812[(2)] = null);

(statearr_76797_76812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76796 === (2))){
var _ = (function (){var statearr_76798 = state_76795;
(statearr_76798[(4)] = cljs.core.cons((5),(state_76795[(4)])));

return statearr_76798;
})();
var inst_76785 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_76786 = fluree.db.api.query.query_async(sources,inst_76785);
var state_76795__$1 = state_76795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76795__$1,(6),inst_76786);
} else {
if((state_val_76796 === (3))){
var inst_76793 = (state_76795[(2)]);
var state_76795__$1 = state_76795;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76795__$1,inst_76793);
} else {
if((state_val_76796 === (4))){
var inst_76773 = (state_76795[(2)]);
var inst_76774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76775 = [inst_76773];
var inst_76776 = (new cljs.core.PersistentVector(null,1,(5),inst_76774,inst_76775,null));
var inst_76777 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76776);
var inst_76778 = cljs.core.clj__GT_js(inst_76773);
var inst_76779 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76778) : reject.call(null,inst_76778));
var state_76795__$1 = (function (){var statearr_76800 = state_76795;
(statearr_76800[(7)] = inst_76777);

return statearr_76800;
})();
var statearr_76801_76813 = state_76795__$1;
(statearr_76801_76813[(2)] = inst_76779);

(statearr_76801_76813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76796 === (5))){
var _ = (function (){var statearr_76802 = state_76795;
(statearr_76802[(4)] = cljs.core.rest((state_76795[(4)])));

return statearr_76802;
})();
var state_76795__$1 = state_76795;
var ex76799 = (state_76795__$1[(2)]);
var statearr_76803_76814 = state_76795__$1;
(statearr_76803_76814[(5)] = ex76799);


var statearr_76804_76815 = state_76795__$1;
(statearr_76804_76815[(1)] = (4));

(statearr_76804_76815[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76796 === (6))){
var inst_76788 = (state_76795[(2)]);
var inst_76789 = cljs.core.clj__GT_js(inst_76788);
var inst_76790 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76789) : resolve.call(null,inst_76789));
var _ = (function (){var statearr_76805 = state_76795;
(statearr_76805[(4)] = cljs.core.rest((state_76795[(4)])));

return statearr_76805;
})();
var state_76795__$1 = state_76795;
var statearr_76806_76816 = state_76795__$1;
(statearr_76806_76816[(2)] = inst_76790);

(statearr_76806_76816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__2727__auto__ = null;
var flureedb$query_$_state_machine__2727__auto____0 = (function (){
var statearr_76807 = [null,null,null,null,null,null,null,null];
(statearr_76807[(0)] = flureedb$query_$_state_machine__2727__auto__);

(statearr_76807[(1)] = (1));

return statearr_76807;
});
var flureedb$query_$_state_machine__2727__auto____1 = (function (state_76795){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76795);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76808){var ex__2730__auto__ = e76808;
var statearr_76809_76817 = state_76795;
(statearr_76809_76817[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76795[(4)]))){
var statearr_76810_76818 = state_76795;
(statearr_76810_76818[(1)] = cljs.core.first((state_76795[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76819 = state_76795;
state_76795 = G__76819;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$query_$_state_machine__2727__auto__ = function(state_76795){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__2727__auto____1.call(this,state_76795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__2727__auto____0;
flureedb$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__2727__auto____1;
return flureedb$query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76811 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76811[(6)] = c__2749__auto__);

return statearr_76811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__76821 = arguments.length;
switch (G__76821) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76851){
var state_val_76852 = (state_76851[(1)]);
if((state_val_76852 === (7))){
var inst_76838 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76851__$1 = state_76851;
var statearr_76853_76874 = state_76851__$1;
(statearr_76853_76874[(2)] = inst_76838);

(statearr_76853_76874[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76852 === (1))){
var state_76851__$1 = state_76851;
var statearr_76854_76875 = state_76851__$1;
(statearr_76854_76875[(2)] = null);

(statearr_76854_76875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76852 === (4))){
var inst_76822 = (state_76851[(2)]);
var inst_76823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76824 = [inst_76822];
var inst_76825 = (new cljs.core.PersistentVector(null,1,(5),inst_76823,inst_76824,null));
var inst_76826 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76825);
var inst_76827 = cljs.core.clj__GT_js(inst_76822);
var inst_76828 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76827) : reject.call(null,inst_76827));
var state_76851__$1 = (function (){var statearr_76855 = state_76851;
(statearr_76855[(7)] = inst_76826);

return statearr_76855;
})();
var statearr_76856_76876 = state_76851__$1;
(statearr_76856_76876[(2)] = inst_76828);

(statearr_76856_76876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76852 === (6))){
var state_76851__$1 = state_76851;
var statearr_76857_76877 = state_76851__$1;
(statearr_76857_76877[(2)] = null);

(statearr_76857_76877[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76852 === (3))){
var inst_76849 = (state_76851[(2)]);
var state_76851__$1 = state_76851;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76851__$1,inst_76849);
} else {
if((state_val_76852 === (2))){
var _ = (function (){var statearr_76859 = state_76851;
(statearr_76859[(4)] = cljs.core.cons((5),(state_76851[(4)])));

return statearr_76859;
})();
var inst_76834 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_76835 = (opts == null);
var state_76851__$1 = (function (){var statearr_76860 = state_76851;
(statearr_76860[(8)] = inst_76834);

return statearr_76860;
})();
if(cljs.core.truth_(inst_76835)){
var statearr_76861_76878 = state_76851__$1;
(statearr_76861_76878[(1)] = (6));

} else {
var statearr_76862_76879 = state_76851__$1;
(statearr_76862_76879[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76852 === (9))){
var inst_76843 = (state_76851[(2)]);
var inst_76844 = fluree.db.util.async.throw_err(inst_76843);
var inst_76845 = cljs.core.clj__GT_js(inst_76844);
var inst_76846 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76845) : resolve.call(null,inst_76845));
var _ = (function (){var statearr_76863 = state_76851;
(statearr_76863[(4)] = cljs.core.rest((state_76851[(4)])));

return statearr_76863;
})();
var state_76851__$1 = state_76851;
var statearr_76864_76880 = state_76851__$1;
(statearr_76864_76880[(2)] = inst_76846);

(statearr_76864_76880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76852 === (5))){
var _ = (function (){var statearr_76865 = state_76851;
(statearr_76865[(4)] = cljs.core.rest((state_76851[(4)])));

return statearr_76865;
})();
var state_76851__$1 = state_76851;
var ex76858 = (state_76851__$1[(2)]);
var statearr_76866_76881 = state_76851__$1;
(statearr_76866_76881[(5)] = ex76858);


var statearr_76867_76882 = state_76851__$1;
(statearr_76867_76882[(1)] = (4));

(statearr_76867_76882[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76852 === (8))){
var inst_76834 = (state_76851[(8)]);
var inst_76840 = (state_76851[(2)]);
var inst_76841 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_76834,inst_76840);
var state_76851__$1 = state_76851;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76851__$1,(9),inst_76841);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76868 = [null,null,null,null,null,null,null,null,null];
(statearr_76868[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76868[(1)] = (1));

return statearr_76868;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76851){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76851);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76869){var ex__2730__auto__ = e76869;
var statearr_76870_76883 = state_76851;
(statearr_76870_76883[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76851[(4)]))){
var statearr_76871_76884 = state_76851;
(statearr_76871_76884[(1)] = cljs.core.first((state_76851[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76885 = state_76851;
state_76851 = G__76885;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76851){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76872 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76872[(6)] = c__2749__auto__);

return statearr_76872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *    any key, and a two-argument function that will be called with each event.
 * 
 *    The key is any arbitrary key, and is only used to close the listener via close-listener,
 *    otherwise it is opaque to the listener.
 * 
 *    The callback function's first argument is the event header/metadata and the second argument
 *    is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
