// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
goog.require('goog.object');
goog.scope(function(){
cljs.source_map.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__5571){
var vec__5572 = p__5571;
var i = cljs.core.nth.call(null,vec__5572,(0),null);
var v = cljs.core.nth.call(null,vec__5572,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__5575 = seg;
var gcol = cljs.core.nth.call(null,vec__5575,(0),null);
var source = cljs.core.nth.call(null,vec__5575,(1),null);
var line = cljs.core.nth.call(null,vec__5575,(2),null);
var col = cljs.core.nth.call(null,vec__5575,(3),null);
var name = cljs.core.nth.call(null,vec__5575,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (cljs.source_map.goog$module$goog$object.get.call(null,source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__5578 = seg;
var gcol = cljs.core.nth.call(null,vec__5578,(0),null);
var source = cljs.core.nth.call(null,vec__5578,(1),null);
var line = cljs.core.nth.call(null,vec__5578,(2),null);
var col = cljs.core.nth.call(null,vec__5578,(3),null);
var name = cljs.core.nth.call(null,vec__5578,(4),null);
var vec__5581 = relseg;
var rgcol = cljs.core.nth.call(null,vec__5581,(0),null);
var rsource = cljs.core.nth.call(null,vec__5581,(1),null);
var rline = cljs.core.nth.call(null,vec__5581,(2),null);
var rcol = cljs.core.nth.call(null,vec__5581,(3),null);
var rname = cljs.core.nth.call(null,vec__5581,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4253__auto__ = source;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4253__auto__ = line;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4253__auto__ = col;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__5584 = segmap;
var map__5584__$1 = cljs.core.__destructure_map.call(null,map__5584);
var gcol = cljs.core.get.call(null,map__5584__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__5584__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__5584__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__5584__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__5584__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,(function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,(function (v){
return cljs.core.conj.call(null,v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__5586 = arguments.length;
switch (G__5586) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__5590 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__5594 = cljs.core.next.call(null,segs__$1);
var G__5595 = nrelseg;
var G__5596 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__5594;
relseg__$1 = G__5595;
result__$1 = G__5596;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__5590,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__5590,(1),null);
var G__5597 = (gline + (1));
var G__5598 = cljs.core.next.call(null,lines__$1);
var G__5599 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__5600 = result__$1;
gline = G__5597;
lines__$1 = G__5598;
relseg = G__5599;
result = G__5600;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__5602 = segmap;
var map__5602__$1 = cljs.core.__destructure_map.call(null,map__5602);
var gcol = cljs.core.get.call(null,map__5602__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__5602__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__5602__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__5602__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__5602__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,(function (p1__5601_SHARP_){
return cljs.core.conj.call(null,p1__5601_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__5604 = arguments.length;
switch (G__5604) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__5608 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__5612 = cljs.core.next.call(null,segs__$1);
var G__5613 = nrelseg;
var G__5614 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__5612;
relseg__$1 = G__5613;
result__$1 = G__5614;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__5608,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__5608,(1),null);
var G__5615 = (gline + (1));
var G__5616 = cljs.core.next.call(null,lines__$1);
var G__5617 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__5618 = result__$1;
gline = G__5615;
lines__$1 = G__5616;
relseg = G__5617;
result = G__5618;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,(function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,(function (p__5619){
var vec__5620 = p__5619;
var _ = cljs.core.nth.call(null,vec__5620,(0),null);
var source = cljs.core.nth.call(null,vec__5620,(1),null);
var line = cljs.core.nth.call(null,vec__5620,(2),null);
var col = cljs.core.nth.call(null,vec__5620,(3),null);
var name = cljs.core.nth.call(null,vec__5620,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,(function (cols__$1,p__5623){
var vec__5624 = p__5623;
var gcol = cljs.core.nth.call(null,vec__5624,(0),null);
var sidx = cljs.core.nth.call(null,vec__5624,(1),null);
var line = cljs.core.nth.call(null,vec__5624,(2),null);
var col = cljs.core.nth.call(null,vec__5624,(3),null);
var name = cljs.core.nth.call(null,vec__5624,(4),null);
var seg = vec__5624;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,(function (p__5627){
var vec__5628 = p__5627;
var _ = cljs.core.nth.call(null,vec__5628,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__5628,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__5628,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__5628,(3),null);
var lname = cljs.core.nth.call(null,vec__5628,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__5634 = cljs.core.seq.call(null,infos);
var chunk__5635 = null;
var count__5636 = (0);
var i__5637 = (0);
while(true){
if((i__5637 < count__5636)){
var info = cljs.core._nth.call(null,chunk__5635,i__5637);
var segv_5988 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_5989 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_5990 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_5989 > (lc_5990 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__5634,chunk__5635,count__5636,i__5637,segv_5988,gline_5989,lc_5990,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_5989 - (lc_5990 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_5988], null));
});})(seq__5634,chunk__5635,count__5636,i__5637,segv_5988,gline_5989,lc_5990,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__5634,chunk__5635,count__5636,i__5637,segv_5988,gline_5989,lc_5990,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5989], null),cljs.core.conj,segv_5988);
});})(seq__5634,chunk__5635,count__5636,i__5637,segv_5988,gline_5989,lc_5990,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__5991 = seq__5634;
var G__5992 = chunk__5635;
var G__5993 = count__5636;
var G__5994 = (i__5637 + (1));
seq__5634 = G__5991;
chunk__5635 = G__5992;
count__5636 = G__5993;
i__5637 = G__5994;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__5634);
if(temp__5753__auto__){
var seq__5634__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5634__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__5634__$1);
var G__5995 = cljs.core.chunk_rest.call(null,seq__5634__$1);
var G__5996 = c__4679__auto__;
var G__5997 = cljs.core.count.call(null,c__4679__auto__);
var G__5998 = (0);
seq__5634 = G__5995;
chunk__5635 = G__5996;
count__5636 = G__5997;
i__5637 = G__5998;
continue;
} else {
var info = cljs.core.first.call(null,seq__5634__$1);
var segv_5999 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_6000 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_6001 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_6000 > (lc_6001 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__5634,chunk__5635,count__5636,i__5637,segv_5999,gline_6000,lc_6001,info,seq__5634__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_6000 - (lc_6001 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_5999], null));
});})(seq__5634,chunk__5635,count__5636,i__5637,segv_5999,gline_6000,lc_6001,info,seq__5634__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__5634,chunk__5635,count__5636,i__5637,segv_5999,gline_6000,lc_6001,info,seq__5634__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6000], null),cljs.core.conj,segv_5999);
});})(seq__5634,chunk__5635,count__5636,i__5637,segv_5999,gline_6000,lc_6001,info,seq__5634__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6002 = cljs.core.next.call(null,seq__5634__$1);
var G__6003 = null;
var G__6004 = (0);
var G__6005 = (0);
seq__5634 = G__6002;
chunk__5635 = G__6003;
count__5636 = G__6004;
i__5637 = G__6005;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__5638_6006 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__5639_6007 = null;
var count__5640_6008 = (0);
var i__5641_6009 = (0);
while(true){
if((i__5641_6009 < count__5640_6008)){
var vec__5814_6010 = cljs.core._nth.call(null,chunk__5639_6007,i__5641_6009);
var source_idx_6011 = cljs.core.nth.call(null,vec__5814_6010,(0),null);
var vec__5817_6012 = cljs.core.nth.call(null,vec__5814_6010,(1),null);
var __6013 = cljs.core.nth.call(null,vec__5817_6012,(0),null);
var lines_6014__$1 = cljs.core.nth.call(null,vec__5817_6012,(1),null);
var seq__5820_6015 = cljs.core.seq.call(null,lines_6014__$1);
var chunk__5821_6016 = null;
var count__5822_6017 = (0);
var i__5823_6018 = (0);
while(true){
if((i__5823_6018 < count__5822_6017)){
var vec__5862_6019 = cljs.core._nth.call(null,chunk__5821_6016,i__5823_6018);
var line_6020 = cljs.core.nth.call(null,vec__5862_6019,(0),null);
var cols_6021 = cljs.core.nth.call(null,vec__5862_6019,(1),null);
var seq__5865_6022 = cljs.core.seq.call(null,cols_6021);
var chunk__5866_6023 = null;
var count__5867_6024 = (0);
var i__5868_6025 = (0);
while(true){
if((i__5868_6025 < count__5867_6024)){
var vec__5875_6026 = cljs.core._nth.call(null,chunk__5866_6023,i__5868_6025);
var col_6027 = cljs.core.nth.call(null,vec__5875_6026,(0),null);
var infos_6028 = cljs.core.nth.call(null,vec__5875_6026,(1),null);
encode_cols.call(null,infos_6028,source_idx_6011,line_6020,col_6027);


var G__6029 = seq__5865_6022;
var G__6030 = chunk__5866_6023;
var G__6031 = count__5867_6024;
var G__6032 = (i__5868_6025 + (1));
seq__5865_6022 = G__6029;
chunk__5866_6023 = G__6030;
count__5867_6024 = G__6031;
i__5868_6025 = G__6032;
continue;
} else {
var temp__5753__auto___6033 = cljs.core.seq.call(null,seq__5865_6022);
if(temp__5753__auto___6033){
var seq__5865_6034__$1 = temp__5753__auto___6033;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5865_6034__$1)){
var c__4679__auto___6035 = cljs.core.chunk_first.call(null,seq__5865_6034__$1);
var G__6036 = cljs.core.chunk_rest.call(null,seq__5865_6034__$1);
var G__6037 = c__4679__auto___6035;
var G__6038 = cljs.core.count.call(null,c__4679__auto___6035);
var G__6039 = (0);
seq__5865_6022 = G__6036;
chunk__5866_6023 = G__6037;
count__5867_6024 = G__6038;
i__5868_6025 = G__6039;
continue;
} else {
var vec__5878_6040 = cljs.core.first.call(null,seq__5865_6034__$1);
var col_6041 = cljs.core.nth.call(null,vec__5878_6040,(0),null);
var infos_6042 = cljs.core.nth.call(null,vec__5878_6040,(1),null);
encode_cols.call(null,infos_6042,source_idx_6011,line_6020,col_6041);


var G__6043 = cljs.core.next.call(null,seq__5865_6034__$1);
var G__6044 = null;
var G__6045 = (0);
var G__6046 = (0);
seq__5865_6022 = G__6043;
chunk__5866_6023 = G__6044;
count__5867_6024 = G__6045;
i__5868_6025 = G__6046;
continue;
}
} else {
}
}
break;
}


var G__6047 = seq__5820_6015;
var G__6048 = chunk__5821_6016;
var G__6049 = count__5822_6017;
var G__6050 = (i__5823_6018 + (1));
seq__5820_6015 = G__6047;
chunk__5821_6016 = G__6048;
count__5822_6017 = G__6049;
i__5823_6018 = G__6050;
continue;
} else {
var temp__5753__auto___6051 = cljs.core.seq.call(null,seq__5820_6015);
if(temp__5753__auto___6051){
var seq__5820_6052__$1 = temp__5753__auto___6051;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5820_6052__$1)){
var c__4679__auto___6053 = cljs.core.chunk_first.call(null,seq__5820_6052__$1);
var G__6054 = cljs.core.chunk_rest.call(null,seq__5820_6052__$1);
var G__6055 = c__4679__auto___6053;
var G__6056 = cljs.core.count.call(null,c__4679__auto___6053);
var G__6057 = (0);
seq__5820_6015 = G__6054;
chunk__5821_6016 = G__6055;
count__5822_6017 = G__6056;
i__5823_6018 = G__6057;
continue;
} else {
var vec__5881_6058 = cljs.core.first.call(null,seq__5820_6052__$1);
var line_6059 = cljs.core.nth.call(null,vec__5881_6058,(0),null);
var cols_6060 = cljs.core.nth.call(null,vec__5881_6058,(1),null);
var seq__5884_6061 = cljs.core.seq.call(null,cols_6060);
var chunk__5885_6062 = null;
var count__5886_6063 = (0);
var i__5887_6064 = (0);
while(true){
if((i__5887_6064 < count__5886_6063)){
var vec__5894_6065 = cljs.core._nth.call(null,chunk__5885_6062,i__5887_6064);
var col_6066 = cljs.core.nth.call(null,vec__5894_6065,(0),null);
var infos_6067 = cljs.core.nth.call(null,vec__5894_6065,(1),null);
encode_cols.call(null,infos_6067,source_idx_6011,line_6059,col_6066);


var G__6068 = seq__5884_6061;
var G__6069 = chunk__5885_6062;
var G__6070 = count__5886_6063;
var G__6071 = (i__5887_6064 + (1));
seq__5884_6061 = G__6068;
chunk__5885_6062 = G__6069;
count__5886_6063 = G__6070;
i__5887_6064 = G__6071;
continue;
} else {
var temp__5753__auto___6072__$1 = cljs.core.seq.call(null,seq__5884_6061);
if(temp__5753__auto___6072__$1){
var seq__5884_6073__$1 = temp__5753__auto___6072__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5884_6073__$1)){
var c__4679__auto___6074 = cljs.core.chunk_first.call(null,seq__5884_6073__$1);
var G__6075 = cljs.core.chunk_rest.call(null,seq__5884_6073__$1);
var G__6076 = c__4679__auto___6074;
var G__6077 = cljs.core.count.call(null,c__4679__auto___6074);
var G__6078 = (0);
seq__5884_6061 = G__6075;
chunk__5885_6062 = G__6076;
count__5886_6063 = G__6077;
i__5887_6064 = G__6078;
continue;
} else {
var vec__5897_6079 = cljs.core.first.call(null,seq__5884_6073__$1);
var col_6080 = cljs.core.nth.call(null,vec__5897_6079,(0),null);
var infos_6081 = cljs.core.nth.call(null,vec__5897_6079,(1),null);
encode_cols.call(null,infos_6081,source_idx_6011,line_6059,col_6080);


var G__6082 = cljs.core.next.call(null,seq__5884_6073__$1);
var G__6083 = null;
var G__6084 = (0);
var G__6085 = (0);
seq__5884_6061 = G__6082;
chunk__5885_6062 = G__6083;
count__5886_6063 = G__6084;
i__5887_6064 = G__6085;
continue;
}
} else {
}
}
break;
}


var G__6086 = cljs.core.next.call(null,seq__5820_6052__$1);
var G__6087 = null;
var G__6088 = (0);
var G__6089 = (0);
seq__5820_6015 = G__6086;
chunk__5821_6016 = G__6087;
count__5822_6017 = G__6088;
i__5823_6018 = G__6089;
continue;
}
} else {
}
}
break;
}


var G__6090 = seq__5638_6006;
var G__6091 = chunk__5639_6007;
var G__6092 = count__5640_6008;
var G__6093 = (i__5641_6009 + (1));
seq__5638_6006 = G__6090;
chunk__5639_6007 = G__6091;
count__5640_6008 = G__6092;
i__5641_6009 = G__6093;
continue;
} else {
var temp__5753__auto___6094 = cljs.core.seq.call(null,seq__5638_6006);
if(temp__5753__auto___6094){
var seq__5638_6095__$1 = temp__5753__auto___6094;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5638_6095__$1)){
var c__4679__auto___6096 = cljs.core.chunk_first.call(null,seq__5638_6095__$1);
var G__6097 = cljs.core.chunk_rest.call(null,seq__5638_6095__$1);
var G__6098 = c__4679__auto___6096;
var G__6099 = cljs.core.count.call(null,c__4679__auto___6096);
var G__6100 = (0);
seq__5638_6006 = G__6097;
chunk__5639_6007 = G__6098;
count__5640_6008 = G__6099;
i__5641_6009 = G__6100;
continue;
} else {
var vec__5900_6101 = cljs.core.first.call(null,seq__5638_6095__$1);
var source_idx_6102 = cljs.core.nth.call(null,vec__5900_6101,(0),null);
var vec__5903_6103 = cljs.core.nth.call(null,vec__5900_6101,(1),null);
var __6104 = cljs.core.nth.call(null,vec__5903_6103,(0),null);
var lines_6105__$1 = cljs.core.nth.call(null,vec__5903_6103,(1),null);
var seq__5906_6106 = cljs.core.seq.call(null,lines_6105__$1);
var chunk__5907_6107 = null;
var count__5908_6108 = (0);
var i__5909_6109 = (0);
while(true){
if((i__5909_6109 < count__5908_6108)){
var vec__5948_6110 = cljs.core._nth.call(null,chunk__5907_6107,i__5909_6109);
var line_6111 = cljs.core.nth.call(null,vec__5948_6110,(0),null);
var cols_6112 = cljs.core.nth.call(null,vec__5948_6110,(1),null);
var seq__5951_6113 = cljs.core.seq.call(null,cols_6112);
var chunk__5952_6114 = null;
var count__5953_6115 = (0);
var i__5954_6116 = (0);
while(true){
if((i__5954_6116 < count__5953_6115)){
var vec__5961_6117 = cljs.core._nth.call(null,chunk__5952_6114,i__5954_6116);
var col_6118 = cljs.core.nth.call(null,vec__5961_6117,(0),null);
var infos_6119 = cljs.core.nth.call(null,vec__5961_6117,(1),null);
encode_cols.call(null,infos_6119,source_idx_6102,line_6111,col_6118);


var G__6120 = seq__5951_6113;
var G__6121 = chunk__5952_6114;
var G__6122 = count__5953_6115;
var G__6123 = (i__5954_6116 + (1));
seq__5951_6113 = G__6120;
chunk__5952_6114 = G__6121;
count__5953_6115 = G__6122;
i__5954_6116 = G__6123;
continue;
} else {
var temp__5753__auto___6124__$1 = cljs.core.seq.call(null,seq__5951_6113);
if(temp__5753__auto___6124__$1){
var seq__5951_6125__$1 = temp__5753__auto___6124__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5951_6125__$1)){
var c__4679__auto___6126 = cljs.core.chunk_first.call(null,seq__5951_6125__$1);
var G__6127 = cljs.core.chunk_rest.call(null,seq__5951_6125__$1);
var G__6128 = c__4679__auto___6126;
var G__6129 = cljs.core.count.call(null,c__4679__auto___6126);
var G__6130 = (0);
seq__5951_6113 = G__6127;
chunk__5952_6114 = G__6128;
count__5953_6115 = G__6129;
i__5954_6116 = G__6130;
continue;
} else {
var vec__5964_6131 = cljs.core.first.call(null,seq__5951_6125__$1);
var col_6132 = cljs.core.nth.call(null,vec__5964_6131,(0),null);
var infos_6133 = cljs.core.nth.call(null,vec__5964_6131,(1),null);
encode_cols.call(null,infos_6133,source_idx_6102,line_6111,col_6132);


var G__6134 = cljs.core.next.call(null,seq__5951_6125__$1);
var G__6135 = null;
var G__6136 = (0);
var G__6137 = (0);
seq__5951_6113 = G__6134;
chunk__5952_6114 = G__6135;
count__5953_6115 = G__6136;
i__5954_6116 = G__6137;
continue;
}
} else {
}
}
break;
}


var G__6138 = seq__5906_6106;
var G__6139 = chunk__5907_6107;
var G__6140 = count__5908_6108;
var G__6141 = (i__5909_6109 + (1));
seq__5906_6106 = G__6138;
chunk__5907_6107 = G__6139;
count__5908_6108 = G__6140;
i__5909_6109 = G__6141;
continue;
} else {
var temp__5753__auto___6142__$1 = cljs.core.seq.call(null,seq__5906_6106);
if(temp__5753__auto___6142__$1){
var seq__5906_6143__$1 = temp__5753__auto___6142__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5906_6143__$1)){
var c__4679__auto___6144 = cljs.core.chunk_first.call(null,seq__5906_6143__$1);
var G__6145 = cljs.core.chunk_rest.call(null,seq__5906_6143__$1);
var G__6146 = c__4679__auto___6144;
var G__6147 = cljs.core.count.call(null,c__4679__auto___6144);
var G__6148 = (0);
seq__5906_6106 = G__6145;
chunk__5907_6107 = G__6146;
count__5908_6108 = G__6147;
i__5909_6109 = G__6148;
continue;
} else {
var vec__5967_6149 = cljs.core.first.call(null,seq__5906_6143__$1);
var line_6150 = cljs.core.nth.call(null,vec__5967_6149,(0),null);
var cols_6151 = cljs.core.nth.call(null,vec__5967_6149,(1),null);
var seq__5970_6152 = cljs.core.seq.call(null,cols_6151);
var chunk__5971_6153 = null;
var count__5972_6154 = (0);
var i__5973_6155 = (0);
while(true){
if((i__5973_6155 < count__5972_6154)){
var vec__5980_6156 = cljs.core._nth.call(null,chunk__5971_6153,i__5973_6155);
var col_6157 = cljs.core.nth.call(null,vec__5980_6156,(0),null);
var infos_6158 = cljs.core.nth.call(null,vec__5980_6156,(1),null);
encode_cols.call(null,infos_6158,source_idx_6102,line_6150,col_6157);


var G__6159 = seq__5970_6152;
var G__6160 = chunk__5971_6153;
var G__6161 = count__5972_6154;
var G__6162 = (i__5973_6155 + (1));
seq__5970_6152 = G__6159;
chunk__5971_6153 = G__6160;
count__5972_6154 = G__6161;
i__5973_6155 = G__6162;
continue;
} else {
var temp__5753__auto___6163__$2 = cljs.core.seq.call(null,seq__5970_6152);
if(temp__5753__auto___6163__$2){
var seq__5970_6164__$1 = temp__5753__auto___6163__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5970_6164__$1)){
var c__4679__auto___6165 = cljs.core.chunk_first.call(null,seq__5970_6164__$1);
var G__6166 = cljs.core.chunk_rest.call(null,seq__5970_6164__$1);
var G__6167 = c__4679__auto___6165;
var G__6168 = cljs.core.count.call(null,c__4679__auto___6165);
var G__6169 = (0);
seq__5970_6152 = G__6166;
chunk__5971_6153 = G__6167;
count__5972_6154 = G__6168;
i__5973_6155 = G__6169;
continue;
} else {
var vec__5983_6170 = cljs.core.first.call(null,seq__5970_6164__$1);
var col_6171 = cljs.core.nth.call(null,vec__5983_6170,(0),null);
var infos_6172 = cljs.core.nth.call(null,vec__5983_6170,(1),null);
encode_cols.call(null,infos_6172,source_idx_6102,line_6150,col_6171);


var G__6173 = cljs.core.next.call(null,seq__5970_6164__$1);
var G__6174 = null;
var G__6175 = (0);
var G__6176 = (0);
seq__5970_6152 = G__6173;
chunk__5971_6153 = G__6174;
count__5972_6154 = G__6175;
i__5973_6155 = G__6176;
continue;
}
} else {
}
}
break;
}


var G__6177 = cljs.core.next.call(null,seq__5906_6143__$1);
var G__6178 = null;
var G__6179 = (0);
var G__6180 = (0);
seq__5906_6106 = G__6177;
chunk__5907_6107 = G__6178;
count__5908_6108 = G__6179;
i__5909_6109 = G__6180;
continue;
}
} else {
}
}
break;
}


var G__6181 = cljs.core.next.call(null,seq__5638_6095__$1);
var G__6182 = null;
var G__6183 = (0);
var G__6184 = (0);
seq__5638_6006 = G__6181;
chunk__5639_6007 = G__6182;
count__5640_6008 = G__6183;
i__5641_6009 = G__6184;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__5986 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__5631_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__5631_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__5632_SHARP_){
return cljs.core.last.call(null,clojure.string.split.call(null,p1__5632_SHARP_,/\//));
}));
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.call(null,";",cljs.core.map.call(null,(function (p1__5633_SHARP_){
return clojure.string.join.call(null,",",p1__5633_SHARP_);
}),cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert.call(null,cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__5987 = G__5986;
cljs.source_map.goog$module$goog$object.set.call(null,G__5987,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__5987;
} else {
return G__5986;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__6185 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__6185,(0),null);
var col_map = cljs.core.nth.call(null,vec__6185,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__6188 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__6188,(0),null);
var infos = cljs.core.nth.call(null,vec__6188,(1),null);
var G__6193 = cljs.core.next.call(null,col_map_seq);
var G__6194 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__6188,col,infos,vec__6185,line,col_map){
return (function (v,p__6191){
var map__6192 = p__6191;
var map__6192__$1 = cljs.core.__destructure_map.call(null,map__6192);
var gline = cljs.core.get.call(null,map__6192__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__6192__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__6188,col,infos,vec__6185,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__6193;
new_cols = G__6194;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__6195 = cljs.core.next.call(null,line_map_seq);
var G__6196 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__6195;
new_lines = G__6196;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__6197_6405 = cljs.core.seq.call(null,reverse_map);
var chunk__6198_6406 = null;
var count__6199_6407 = (0);
var i__6200_6408 = (0);
while(true){
if((i__6200_6408 < count__6199_6407)){
var vec__6303_6409 = cljs.core._nth.call(null,chunk__6198_6406,i__6200_6408);
var line_6410 = cljs.core.nth.call(null,vec__6303_6409,(0),null);
var columns_6411 = cljs.core.nth.call(null,vec__6303_6409,(1),null);
var seq__6306_6412 = cljs.core.seq.call(null,columns_6411);
var chunk__6307_6413 = null;
var count__6308_6414 = (0);
var i__6309_6415 = (0);
while(true){
if((i__6309_6415 < count__6308_6414)){
var vec__6332_6416 = cljs.core._nth.call(null,chunk__6307_6413,i__6309_6415);
var column_6417 = cljs.core.nth.call(null,vec__6332_6416,(0),null);
var column_info_6418 = cljs.core.nth.call(null,vec__6332_6416,(1),null);
var seq__6335_6419 = cljs.core.seq.call(null,column_info_6418);
var chunk__6336_6420 = null;
var count__6337_6421 = (0);
var i__6338_6422 = (0);
while(true){
if((i__6338_6422 < count__6337_6421)){
var map__6341_6423 = cljs.core._nth.call(null,chunk__6336_6420,i__6338_6422);
var map__6341_6424__$1 = cljs.core.__destructure_map.call(null,map__6341_6423);
var gline_6425 = cljs.core.get.call(null,map__6341_6424__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6426 = cljs.core.get.call(null,map__6341_6424__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6427 = cljs.core.get.call(null,map__6341_6424__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6425], null),cljs.core.fnil.call(null,((function (seq__6335_6419,chunk__6336_6420,count__6337_6421,i__6338_6422,seq__6306_6412,chunk__6307_6413,count__6308_6414,i__6309_6415,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6341_6423,map__6341_6424__$1,gline_6425,gcol_6426,name_6427,vec__6332_6416,column_6417,column_info_6418,vec__6303_6409,line_6410,columns_6411,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6426], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6410,new cljs.core.Keyword(null,"col","col",-1959363084),column_6417,new cljs.core.Keyword(null,"name","name",1843675177),name_6427], null));
});})(seq__6335_6419,chunk__6336_6420,count__6337_6421,i__6338_6422,seq__6306_6412,chunk__6307_6413,count__6308_6414,i__6309_6415,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6341_6423,map__6341_6424__$1,gline_6425,gcol_6426,name_6427,vec__6332_6416,column_6417,column_info_6418,vec__6303_6409,line_6410,columns_6411,inverted))
,cljs.core.sorted_map.call(null)));


var G__6428 = seq__6335_6419;
var G__6429 = chunk__6336_6420;
var G__6430 = count__6337_6421;
var G__6431 = (i__6338_6422 + (1));
seq__6335_6419 = G__6428;
chunk__6336_6420 = G__6429;
count__6337_6421 = G__6430;
i__6338_6422 = G__6431;
continue;
} else {
var temp__5753__auto___6432 = cljs.core.seq.call(null,seq__6335_6419);
if(temp__5753__auto___6432){
var seq__6335_6433__$1 = temp__5753__auto___6432;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6335_6433__$1)){
var c__4679__auto___6434 = cljs.core.chunk_first.call(null,seq__6335_6433__$1);
var G__6435 = cljs.core.chunk_rest.call(null,seq__6335_6433__$1);
var G__6436 = c__4679__auto___6434;
var G__6437 = cljs.core.count.call(null,c__4679__auto___6434);
var G__6438 = (0);
seq__6335_6419 = G__6435;
chunk__6336_6420 = G__6436;
count__6337_6421 = G__6437;
i__6338_6422 = G__6438;
continue;
} else {
var map__6342_6439 = cljs.core.first.call(null,seq__6335_6433__$1);
var map__6342_6440__$1 = cljs.core.__destructure_map.call(null,map__6342_6439);
var gline_6441 = cljs.core.get.call(null,map__6342_6440__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6442 = cljs.core.get.call(null,map__6342_6440__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6443 = cljs.core.get.call(null,map__6342_6440__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6441], null),cljs.core.fnil.call(null,((function (seq__6335_6419,chunk__6336_6420,count__6337_6421,i__6338_6422,seq__6306_6412,chunk__6307_6413,count__6308_6414,i__6309_6415,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6342_6439,map__6342_6440__$1,gline_6441,gcol_6442,name_6443,seq__6335_6433__$1,temp__5753__auto___6432,vec__6332_6416,column_6417,column_info_6418,vec__6303_6409,line_6410,columns_6411,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6442], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6410,new cljs.core.Keyword(null,"col","col",-1959363084),column_6417,new cljs.core.Keyword(null,"name","name",1843675177),name_6443], null));
});})(seq__6335_6419,chunk__6336_6420,count__6337_6421,i__6338_6422,seq__6306_6412,chunk__6307_6413,count__6308_6414,i__6309_6415,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6342_6439,map__6342_6440__$1,gline_6441,gcol_6442,name_6443,seq__6335_6433__$1,temp__5753__auto___6432,vec__6332_6416,column_6417,column_info_6418,vec__6303_6409,line_6410,columns_6411,inverted))
,cljs.core.sorted_map.call(null)));


var G__6444 = cljs.core.next.call(null,seq__6335_6433__$1);
var G__6445 = null;
var G__6446 = (0);
var G__6447 = (0);
seq__6335_6419 = G__6444;
chunk__6336_6420 = G__6445;
count__6337_6421 = G__6446;
i__6338_6422 = G__6447;
continue;
}
} else {
}
}
break;
}


var G__6448 = seq__6306_6412;
var G__6449 = chunk__6307_6413;
var G__6450 = count__6308_6414;
var G__6451 = (i__6309_6415 + (1));
seq__6306_6412 = G__6448;
chunk__6307_6413 = G__6449;
count__6308_6414 = G__6450;
i__6309_6415 = G__6451;
continue;
} else {
var temp__5753__auto___6452 = cljs.core.seq.call(null,seq__6306_6412);
if(temp__5753__auto___6452){
var seq__6306_6453__$1 = temp__5753__auto___6452;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6306_6453__$1)){
var c__4679__auto___6454 = cljs.core.chunk_first.call(null,seq__6306_6453__$1);
var G__6455 = cljs.core.chunk_rest.call(null,seq__6306_6453__$1);
var G__6456 = c__4679__auto___6454;
var G__6457 = cljs.core.count.call(null,c__4679__auto___6454);
var G__6458 = (0);
seq__6306_6412 = G__6455;
chunk__6307_6413 = G__6456;
count__6308_6414 = G__6457;
i__6309_6415 = G__6458;
continue;
} else {
var vec__6343_6459 = cljs.core.first.call(null,seq__6306_6453__$1);
var column_6460 = cljs.core.nth.call(null,vec__6343_6459,(0),null);
var column_info_6461 = cljs.core.nth.call(null,vec__6343_6459,(1),null);
var seq__6346_6462 = cljs.core.seq.call(null,column_info_6461);
var chunk__6347_6463 = null;
var count__6348_6464 = (0);
var i__6349_6465 = (0);
while(true){
if((i__6349_6465 < count__6348_6464)){
var map__6352_6466 = cljs.core._nth.call(null,chunk__6347_6463,i__6349_6465);
var map__6352_6467__$1 = cljs.core.__destructure_map.call(null,map__6352_6466);
var gline_6468 = cljs.core.get.call(null,map__6352_6467__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6469 = cljs.core.get.call(null,map__6352_6467__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6470 = cljs.core.get.call(null,map__6352_6467__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6468], null),cljs.core.fnil.call(null,((function (seq__6346_6462,chunk__6347_6463,count__6348_6464,i__6349_6465,seq__6306_6412,chunk__6307_6413,count__6308_6414,i__6309_6415,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6352_6466,map__6352_6467__$1,gline_6468,gcol_6469,name_6470,vec__6343_6459,column_6460,column_info_6461,seq__6306_6453__$1,temp__5753__auto___6452,vec__6303_6409,line_6410,columns_6411,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6469], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6410,new cljs.core.Keyword(null,"col","col",-1959363084),column_6460,new cljs.core.Keyword(null,"name","name",1843675177),name_6470], null));
});})(seq__6346_6462,chunk__6347_6463,count__6348_6464,i__6349_6465,seq__6306_6412,chunk__6307_6413,count__6308_6414,i__6309_6415,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6352_6466,map__6352_6467__$1,gline_6468,gcol_6469,name_6470,vec__6343_6459,column_6460,column_info_6461,seq__6306_6453__$1,temp__5753__auto___6452,vec__6303_6409,line_6410,columns_6411,inverted))
,cljs.core.sorted_map.call(null)));


var G__6471 = seq__6346_6462;
var G__6472 = chunk__6347_6463;
var G__6473 = count__6348_6464;
var G__6474 = (i__6349_6465 + (1));
seq__6346_6462 = G__6471;
chunk__6347_6463 = G__6472;
count__6348_6464 = G__6473;
i__6349_6465 = G__6474;
continue;
} else {
var temp__5753__auto___6475__$1 = cljs.core.seq.call(null,seq__6346_6462);
if(temp__5753__auto___6475__$1){
var seq__6346_6476__$1 = temp__5753__auto___6475__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6346_6476__$1)){
var c__4679__auto___6477 = cljs.core.chunk_first.call(null,seq__6346_6476__$1);
var G__6478 = cljs.core.chunk_rest.call(null,seq__6346_6476__$1);
var G__6479 = c__4679__auto___6477;
var G__6480 = cljs.core.count.call(null,c__4679__auto___6477);
var G__6481 = (0);
seq__6346_6462 = G__6478;
chunk__6347_6463 = G__6479;
count__6348_6464 = G__6480;
i__6349_6465 = G__6481;
continue;
} else {
var map__6353_6482 = cljs.core.first.call(null,seq__6346_6476__$1);
var map__6353_6483__$1 = cljs.core.__destructure_map.call(null,map__6353_6482);
var gline_6484 = cljs.core.get.call(null,map__6353_6483__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6485 = cljs.core.get.call(null,map__6353_6483__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6486 = cljs.core.get.call(null,map__6353_6483__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6484], null),cljs.core.fnil.call(null,((function (seq__6346_6462,chunk__6347_6463,count__6348_6464,i__6349_6465,seq__6306_6412,chunk__6307_6413,count__6308_6414,i__6309_6415,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6353_6482,map__6353_6483__$1,gline_6484,gcol_6485,name_6486,seq__6346_6476__$1,temp__5753__auto___6475__$1,vec__6343_6459,column_6460,column_info_6461,seq__6306_6453__$1,temp__5753__auto___6452,vec__6303_6409,line_6410,columns_6411,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6485], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6410,new cljs.core.Keyword(null,"col","col",-1959363084),column_6460,new cljs.core.Keyword(null,"name","name",1843675177),name_6486], null));
});})(seq__6346_6462,chunk__6347_6463,count__6348_6464,i__6349_6465,seq__6306_6412,chunk__6307_6413,count__6308_6414,i__6309_6415,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6353_6482,map__6353_6483__$1,gline_6484,gcol_6485,name_6486,seq__6346_6476__$1,temp__5753__auto___6475__$1,vec__6343_6459,column_6460,column_info_6461,seq__6306_6453__$1,temp__5753__auto___6452,vec__6303_6409,line_6410,columns_6411,inverted))
,cljs.core.sorted_map.call(null)));


var G__6487 = cljs.core.next.call(null,seq__6346_6476__$1);
var G__6488 = null;
var G__6489 = (0);
var G__6490 = (0);
seq__6346_6462 = G__6487;
chunk__6347_6463 = G__6488;
count__6348_6464 = G__6489;
i__6349_6465 = G__6490;
continue;
}
} else {
}
}
break;
}


var G__6491 = cljs.core.next.call(null,seq__6306_6453__$1);
var G__6492 = null;
var G__6493 = (0);
var G__6494 = (0);
seq__6306_6412 = G__6491;
chunk__6307_6413 = G__6492;
count__6308_6414 = G__6493;
i__6309_6415 = G__6494;
continue;
}
} else {
}
}
break;
}


var G__6495 = seq__6197_6405;
var G__6496 = chunk__6198_6406;
var G__6497 = count__6199_6407;
var G__6498 = (i__6200_6408 + (1));
seq__6197_6405 = G__6495;
chunk__6198_6406 = G__6496;
count__6199_6407 = G__6497;
i__6200_6408 = G__6498;
continue;
} else {
var temp__5753__auto___6499 = cljs.core.seq.call(null,seq__6197_6405);
if(temp__5753__auto___6499){
var seq__6197_6500__$1 = temp__5753__auto___6499;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6197_6500__$1)){
var c__4679__auto___6501 = cljs.core.chunk_first.call(null,seq__6197_6500__$1);
var G__6502 = cljs.core.chunk_rest.call(null,seq__6197_6500__$1);
var G__6503 = c__4679__auto___6501;
var G__6504 = cljs.core.count.call(null,c__4679__auto___6501);
var G__6505 = (0);
seq__6197_6405 = G__6502;
chunk__6198_6406 = G__6503;
count__6199_6407 = G__6504;
i__6200_6408 = G__6505;
continue;
} else {
var vec__6354_6506 = cljs.core.first.call(null,seq__6197_6500__$1);
var line_6507 = cljs.core.nth.call(null,vec__6354_6506,(0),null);
var columns_6508 = cljs.core.nth.call(null,vec__6354_6506,(1),null);
var seq__6357_6509 = cljs.core.seq.call(null,columns_6508);
var chunk__6358_6510 = null;
var count__6359_6511 = (0);
var i__6360_6512 = (0);
while(true){
if((i__6360_6512 < count__6359_6511)){
var vec__6383_6513 = cljs.core._nth.call(null,chunk__6358_6510,i__6360_6512);
var column_6514 = cljs.core.nth.call(null,vec__6383_6513,(0),null);
var column_info_6515 = cljs.core.nth.call(null,vec__6383_6513,(1),null);
var seq__6386_6516 = cljs.core.seq.call(null,column_info_6515);
var chunk__6387_6517 = null;
var count__6388_6518 = (0);
var i__6389_6519 = (0);
while(true){
if((i__6389_6519 < count__6388_6518)){
var map__6392_6520 = cljs.core._nth.call(null,chunk__6387_6517,i__6389_6519);
var map__6392_6521__$1 = cljs.core.__destructure_map.call(null,map__6392_6520);
var gline_6522 = cljs.core.get.call(null,map__6392_6521__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6523 = cljs.core.get.call(null,map__6392_6521__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6524 = cljs.core.get.call(null,map__6392_6521__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6522], null),cljs.core.fnil.call(null,((function (seq__6386_6516,chunk__6387_6517,count__6388_6518,i__6389_6519,seq__6357_6509,chunk__6358_6510,count__6359_6511,i__6360_6512,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6392_6520,map__6392_6521__$1,gline_6522,gcol_6523,name_6524,vec__6383_6513,column_6514,column_info_6515,vec__6354_6506,line_6507,columns_6508,seq__6197_6500__$1,temp__5753__auto___6499,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6523], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6507,new cljs.core.Keyword(null,"col","col",-1959363084),column_6514,new cljs.core.Keyword(null,"name","name",1843675177),name_6524], null));
});})(seq__6386_6516,chunk__6387_6517,count__6388_6518,i__6389_6519,seq__6357_6509,chunk__6358_6510,count__6359_6511,i__6360_6512,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6392_6520,map__6392_6521__$1,gline_6522,gcol_6523,name_6524,vec__6383_6513,column_6514,column_info_6515,vec__6354_6506,line_6507,columns_6508,seq__6197_6500__$1,temp__5753__auto___6499,inverted))
,cljs.core.sorted_map.call(null)));


var G__6525 = seq__6386_6516;
var G__6526 = chunk__6387_6517;
var G__6527 = count__6388_6518;
var G__6528 = (i__6389_6519 + (1));
seq__6386_6516 = G__6525;
chunk__6387_6517 = G__6526;
count__6388_6518 = G__6527;
i__6389_6519 = G__6528;
continue;
} else {
var temp__5753__auto___6529__$1 = cljs.core.seq.call(null,seq__6386_6516);
if(temp__5753__auto___6529__$1){
var seq__6386_6530__$1 = temp__5753__auto___6529__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6386_6530__$1)){
var c__4679__auto___6531 = cljs.core.chunk_first.call(null,seq__6386_6530__$1);
var G__6532 = cljs.core.chunk_rest.call(null,seq__6386_6530__$1);
var G__6533 = c__4679__auto___6531;
var G__6534 = cljs.core.count.call(null,c__4679__auto___6531);
var G__6535 = (0);
seq__6386_6516 = G__6532;
chunk__6387_6517 = G__6533;
count__6388_6518 = G__6534;
i__6389_6519 = G__6535;
continue;
} else {
var map__6393_6536 = cljs.core.first.call(null,seq__6386_6530__$1);
var map__6393_6537__$1 = cljs.core.__destructure_map.call(null,map__6393_6536);
var gline_6538 = cljs.core.get.call(null,map__6393_6537__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6539 = cljs.core.get.call(null,map__6393_6537__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6540 = cljs.core.get.call(null,map__6393_6537__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6538], null),cljs.core.fnil.call(null,((function (seq__6386_6516,chunk__6387_6517,count__6388_6518,i__6389_6519,seq__6357_6509,chunk__6358_6510,count__6359_6511,i__6360_6512,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6393_6536,map__6393_6537__$1,gline_6538,gcol_6539,name_6540,seq__6386_6530__$1,temp__5753__auto___6529__$1,vec__6383_6513,column_6514,column_info_6515,vec__6354_6506,line_6507,columns_6508,seq__6197_6500__$1,temp__5753__auto___6499,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6539], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6507,new cljs.core.Keyword(null,"col","col",-1959363084),column_6514,new cljs.core.Keyword(null,"name","name",1843675177),name_6540], null));
});})(seq__6386_6516,chunk__6387_6517,count__6388_6518,i__6389_6519,seq__6357_6509,chunk__6358_6510,count__6359_6511,i__6360_6512,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6393_6536,map__6393_6537__$1,gline_6538,gcol_6539,name_6540,seq__6386_6530__$1,temp__5753__auto___6529__$1,vec__6383_6513,column_6514,column_info_6515,vec__6354_6506,line_6507,columns_6508,seq__6197_6500__$1,temp__5753__auto___6499,inverted))
,cljs.core.sorted_map.call(null)));


var G__6541 = cljs.core.next.call(null,seq__6386_6530__$1);
var G__6542 = null;
var G__6543 = (0);
var G__6544 = (0);
seq__6386_6516 = G__6541;
chunk__6387_6517 = G__6542;
count__6388_6518 = G__6543;
i__6389_6519 = G__6544;
continue;
}
} else {
}
}
break;
}


var G__6545 = seq__6357_6509;
var G__6546 = chunk__6358_6510;
var G__6547 = count__6359_6511;
var G__6548 = (i__6360_6512 + (1));
seq__6357_6509 = G__6545;
chunk__6358_6510 = G__6546;
count__6359_6511 = G__6547;
i__6360_6512 = G__6548;
continue;
} else {
var temp__5753__auto___6549__$1 = cljs.core.seq.call(null,seq__6357_6509);
if(temp__5753__auto___6549__$1){
var seq__6357_6550__$1 = temp__5753__auto___6549__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6357_6550__$1)){
var c__4679__auto___6551 = cljs.core.chunk_first.call(null,seq__6357_6550__$1);
var G__6552 = cljs.core.chunk_rest.call(null,seq__6357_6550__$1);
var G__6553 = c__4679__auto___6551;
var G__6554 = cljs.core.count.call(null,c__4679__auto___6551);
var G__6555 = (0);
seq__6357_6509 = G__6552;
chunk__6358_6510 = G__6553;
count__6359_6511 = G__6554;
i__6360_6512 = G__6555;
continue;
} else {
var vec__6394_6556 = cljs.core.first.call(null,seq__6357_6550__$1);
var column_6557 = cljs.core.nth.call(null,vec__6394_6556,(0),null);
var column_info_6558 = cljs.core.nth.call(null,vec__6394_6556,(1),null);
var seq__6397_6559 = cljs.core.seq.call(null,column_info_6558);
var chunk__6398_6560 = null;
var count__6399_6561 = (0);
var i__6400_6562 = (0);
while(true){
if((i__6400_6562 < count__6399_6561)){
var map__6403_6563 = cljs.core._nth.call(null,chunk__6398_6560,i__6400_6562);
var map__6403_6564__$1 = cljs.core.__destructure_map.call(null,map__6403_6563);
var gline_6565 = cljs.core.get.call(null,map__6403_6564__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6566 = cljs.core.get.call(null,map__6403_6564__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6567 = cljs.core.get.call(null,map__6403_6564__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6565], null),cljs.core.fnil.call(null,((function (seq__6397_6559,chunk__6398_6560,count__6399_6561,i__6400_6562,seq__6357_6509,chunk__6358_6510,count__6359_6511,i__6360_6512,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6403_6563,map__6403_6564__$1,gline_6565,gcol_6566,name_6567,vec__6394_6556,column_6557,column_info_6558,seq__6357_6550__$1,temp__5753__auto___6549__$1,vec__6354_6506,line_6507,columns_6508,seq__6197_6500__$1,temp__5753__auto___6499,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6566], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6507,new cljs.core.Keyword(null,"col","col",-1959363084),column_6557,new cljs.core.Keyword(null,"name","name",1843675177),name_6567], null));
});})(seq__6397_6559,chunk__6398_6560,count__6399_6561,i__6400_6562,seq__6357_6509,chunk__6358_6510,count__6359_6511,i__6360_6512,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6403_6563,map__6403_6564__$1,gline_6565,gcol_6566,name_6567,vec__6394_6556,column_6557,column_info_6558,seq__6357_6550__$1,temp__5753__auto___6549__$1,vec__6354_6506,line_6507,columns_6508,seq__6197_6500__$1,temp__5753__auto___6499,inverted))
,cljs.core.sorted_map.call(null)));


var G__6568 = seq__6397_6559;
var G__6569 = chunk__6398_6560;
var G__6570 = count__6399_6561;
var G__6571 = (i__6400_6562 + (1));
seq__6397_6559 = G__6568;
chunk__6398_6560 = G__6569;
count__6399_6561 = G__6570;
i__6400_6562 = G__6571;
continue;
} else {
var temp__5753__auto___6572__$2 = cljs.core.seq.call(null,seq__6397_6559);
if(temp__5753__auto___6572__$2){
var seq__6397_6573__$1 = temp__5753__auto___6572__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6397_6573__$1)){
var c__4679__auto___6574 = cljs.core.chunk_first.call(null,seq__6397_6573__$1);
var G__6575 = cljs.core.chunk_rest.call(null,seq__6397_6573__$1);
var G__6576 = c__4679__auto___6574;
var G__6577 = cljs.core.count.call(null,c__4679__auto___6574);
var G__6578 = (0);
seq__6397_6559 = G__6575;
chunk__6398_6560 = G__6576;
count__6399_6561 = G__6577;
i__6400_6562 = G__6578;
continue;
} else {
var map__6404_6579 = cljs.core.first.call(null,seq__6397_6573__$1);
var map__6404_6580__$1 = cljs.core.__destructure_map.call(null,map__6404_6579);
var gline_6581 = cljs.core.get.call(null,map__6404_6580__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6582 = cljs.core.get.call(null,map__6404_6580__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6583 = cljs.core.get.call(null,map__6404_6580__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6581], null),cljs.core.fnil.call(null,((function (seq__6397_6559,chunk__6398_6560,count__6399_6561,i__6400_6562,seq__6357_6509,chunk__6358_6510,count__6359_6511,i__6360_6512,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6404_6579,map__6404_6580__$1,gline_6581,gcol_6582,name_6583,seq__6397_6573__$1,temp__5753__auto___6572__$2,vec__6394_6556,column_6557,column_info_6558,seq__6357_6550__$1,temp__5753__auto___6549__$1,vec__6354_6506,line_6507,columns_6508,seq__6197_6500__$1,temp__5753__auto___6499,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6582], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6507,new cljs.core.Keyword(null,"col","col",-1959363084),column_6557,new cljs.core.Keyword(null,"name","name",1843675177),name_6583], null));
});})(seq__6397_6559,chunk__6398_6560,count__6399_6561,i__6400_6562,seq__6357_6509,chunk__6358_6510,count__6359_6511,i__6360_6512,seq__6197_6405,chunk__6198_6406,count__6199_6407,i__6200_6408,map__6404_6579,map__6404_6580__$1,gline_6581,gcol_6582,name_6583,seq__6397_6573__$1,temp__5753__auto___6572__$2,vec__6394_6556,column_6557,column_info_6558,seq__6357_6550__$1,temp__5753__auto___6549__$1,vec__6354_6506,line_6507,columns_6508,seq__6197_6500__$1,temp__5753__auto___6499,inverted))
,cljs.core.sorted_map.call(null)));


var G__6584 = cljs.core.next.call(null,seq__6397_6573__$1);
var G__6585 = null;
var G__6586 = (0);
var G__6587 = (0);
seq__6397_6559 = G__6584;
chunk__6398_6560 = G__6585;
count__6399_6561 = G__6586;
i__6400_6562 = G__6587;
continue;
}
} else {
}
}
break;
}


var G__6588 = cljs.core.next.call(null,seq__6357_6550__$1);
var G__6589 = null;
var G__6590 = (0);
var G__6591 = (0);
seq__6357_6509 = G__6588;
chunk__6358_6510 = G__6589;
count__6359_6511 = G__6590;
i__6360_6512 = G__6591;
continue;
}
} else {
}
}
break;
}


var G__6592 = cljs.core.next.call(null,seq__6197_6500__$1);
var G__6593 = null;
var G__6594 = (0);
var G__6595 = (0);
seq__6197_6405 = G__6592;
chunk__6198_6406 = G__6593;
count__6199_6407 = G__6594;
i__6200_6408 = G__6595;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});
