// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__76989 = arguments.length;
switch (G__76989) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___77028 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77010){
var state_val_77011 = (state_77010[(1)]);
if((state_val_77011 === (1))){
var state_77010__$1 = state_77010;
var statearr_77012_77029 = state_77010__$1;
(statearr_77012_77029[(2)] = null);

(statearr_77012_77029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77011 === (2))){
var _ = (function (){var statearr_77013 = state_77010;
(statearr_77013[(4)] = cljs.core.cons.call(null,(5),(state_77010[(4)])));

return statearr_77013;
})();
var inst_76996 = fluree.db.session.db.call(null,conn,ledger,null);
var state_77010__$1 = state_77010;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77010__$1,(7),inst_76996);
} else {
if((state_val_77011 === (3))){
var inst_77006 = (state_77010[(2)]);
var inst_77007 = cljs.core.async.put_BANG_.call(null,pc,inst_77006);
var inst_77008 = cljs.core.async.close_BANG_.call(null,pc);
var state_77010__$1 = (function (){var statearr_77015 = state_77010;
(statearr_77015[(7)] = inst_77007);

return statearr_77015;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77010__$1,inst_77008);
} else {
if((state_val_77011 === (4))){
var inst_76990 = (state_77010[(2)]);
var state_77010__$1 = state_77010;
var statearr_77016_77030 = state_77010__$1;
(statearr_77016_77030[(2)] = inst_76990);

(statearr_77016_77030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77011 === (5))){
var _ = (function (){var statearr_77017 = state_77010;
(statearr_77017[(4)] = cljs.core.rest.call(null,(state_77010[(4)])));

return statearr_77017;
})();
var state_77010__$1 = state_77010;
var ex77014 = (state_77010__$1[(2)]);
var statearr_77018_77031 = state_77010__$1;
(statearr_77018_77031[(5)] = ex77014);


var statearr_77019_77032 = state_77010__$1;
(statearr_77019_77032[(1)] = (4));

(statearr_77019_77032[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77011 === (6))){
var inst_77002 = (state_77010[(2)]);
var inst_77003 = fluree.db.util.async.throw_err.call(null,inst_77002);
var _ = (function (){var statearr_77020 = state_77010;
(statearr_77020[(4)] = cljs.core.rest.call(null,(state_77010[(4)])));

return statearr_77020;
})();
var state_77010__$1 = state_77010;
var statearr_77021_77033 = state_77010__$1;
(statearr_77021_77033[(2)] = inst_77003);

(statearr_77021_77033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77011 === (7))){
var inst_76998 = (state_77010[(2)]);
var inst_76999 = fluree.db.util.async.throw_err.call(null,inst_76998);
var inst_77000 = fluree.db.time_travel.as_of_block.call(null,inst_76999,block);
var state_77010__$1 = state_77010;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77010__$1,(6),inst_77000);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2746__auto__ = null;
var fluree$db$api$ledger$state_machine__2746__auto____0 = (function (){
var statearr_77022 = [null,null,null,null,null,null,null,null];
(statearr_77022[(0)] = fluree$db$api$ledger$state_machine__2746__auto__);

(statearr_77022[(1)] = (1));

return statearr_77022;
});
var fluree$db$api$ledger$state_machine__2746__auto____1 = (function (state_77010){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77010);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77023){var ex__2749__auto__ = e77023;
var statearr_77024_77034 = state_77010;
(statearr_77024_77034[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77010[(4)]))){
var statearr_77025_77035 = state_77010;
(statearr_77025_77035[(1)] = cljs.core.first.call(null,(state_77010[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77036 = state_77010;
state_77010 = G__77036;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2746__auto__ = function(state_77010){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2746__auto____1.call(this,state_77010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2746__auto____0;
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2746__auto____1;
return fluree$db$api$ledger$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77026 = f__2769__auto__.call(null);
(statearr_77026[(6)] = c__2768__auto___77028);

return statearr_77026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77077){
var state_val_77078 = (state_77077[(1)]);
if((state_val_77078 === (7))){
var inst_77046 = cljs.core._EQ_.call(null,(0),auth);
var state_77077__$1 = state_77077;
if(inst_77046){
var statearr_77079_77110 = state_77077__$1;
(statearr_77079_77110[(1)] = (9));

} else {
var statearr_77080_77111 = state_77077__$1;
(statearr_77080_77111[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (1))){
var state_77077__$1 = state_77077;
var statearr_77081_77112 = state_77077__$1;
(statearr_77081_77112[(2)] = null);

(statearr_77081_77112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (4))){
var inst_77037 = (state_77077[(2)]);
var state_77077__$1 = state_77077;
var statearr_77082_77113 = state_77077__$1;
(statearr_77082_77113[(2)] = inst_77037);

(statearr_77082_77113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (15))){
var inst_77054 = (state_77077[(7)]);
var inst_77053 = (state_77077[(2)]);
var inst_77054__$1 = fluree.db.util.async.throw_err.call(null,inst_77053);
var state_77077__$1 = (function (){var statearr_77083 = state_77077;
(statearr_77083[(7)] = inst_77054__$1);

return statearr_77083;
})();
if(cljs.core.truth_(inst_77054__$1)){
var statearr_77084_77114 = state_77077__$1;
(statearr_77084_77114[(1)] = (16));

} else {
var statearr_77085_77115 = state_77077__$1;
(statearr_77085_77115[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (13))){
var state_77077__$1 = state_77077;
var statearr_77086_77116 = state_77077__$1;
(statearr_77086_77116[(2)] = null);

(statearr_77086_77116[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (6))){
var state_77077__$1 = state_77077;
var statearr_77087_77117 = state_77077__$1;
(statearr_77087_77117[(2)] = db);

(statearr_77087_77117[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (17))){
var inst_77058 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_77059 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77060 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_77061 = cljs.core.PersistentHashMap.fromArrays(inst_77059,inst_77060);
var inst_77062 = cljs.core.ex_info.call(null,inst_77058,inst_77061);
var inst_77063 = (function(){throw inst_77062})();
var state_77077__$1 = state_77077;
var statearr_77088_77118 = state_77077__$1;
(statearr_77088_77118[(2)] = inst_77063);

(statearr_77088_77118[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (3))){
var inst_77075 = (state_77077[(2)]);
var state_77077__$1 = state_77077;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77077__$1,inst_77075);
} else {
if((state_val_77078 === (12))){
var inst_77051 = fluree.db.dbproto._subid.call(null,db,auth);
var state_77077__$1 = state_77077;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77077__$1,(15),inst_77051);
} else {
if((state_val_77078 === (2))){
var _ = (function (){var statearr_77089 = state_77077;
(statearr_77089[(4)] = cljs.core.cons.call(null,(5),(state_77077[(4)])));

return statearr_77089;
})();
var inst_77043 = cljs.core.not.call(null,auth);
var state_77077__$1 = state_77077;
if(inst_77043){
var statearr_77090_77119 = state_77077__$1;
(statearr_77090_77119[(1)] = (6));

} else {
var statearr_77091_77120 = state_77077__$1;
(statearr_77091_77120[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (11))){
var inst_77070 = (state_77077[(2)]);
var state_77077__$1 = state_77077;
var statearr_77093_77121 = state_77077__$1;
(statearr_77093_77121[(2)] = inst_77070);

(statearr_77093_77121[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (9))){
var inst_77048 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_77077__$1 = state_77077;
var statearr_77094_77122 = state_77077__$1;
(statearr_77094_77122[(2)] = inst_77048);

(statearr_77094_77122[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (5))){
var _ = (function (){var statearr_77095 = state_77077;
(statearr_77095[(4)] = cljs.core.rest.call(null,(state_77077[(4)])));

return statearr_77095;
})();
var state_77077__$1 = state_77077;
var ex77092 = (state_77077__$1[(2)]);
var statearr_77096_77123 = state_77077__$1;
(statearr_77096_77123[(5)] = ex77092);


if((ex77092 instanceof Error)){
var statearr_77097_77124 = state_77077__$1;
(statearr_77097_77124[(1)] = (4));

(statearr_77097_77124[(5)] = null);

} else {
throw ex77092;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (14))){
var inst_77068 = (state_77077[(2)]);
var state_77077__$1 = state_77077;
var statearr_77098_77125 = state_77077__$1;
(statearr_77098_77125[(2)] = inst_77068);

(statearr_77098_77125[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (16))){
var inst_77054 = (state_77077[(7)]);
var inst_77056 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_77054);
var state_77077__$1 = state_77077;
var statearr_77099_77126 = state_77077__$1;
(statearr_77099_77126[(2)] = inst_77056);

(statearr_77099_77126[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (10))){
var state_77077__$1 = state_77077;
var statearr_77100_77127 = state_77077__$1;
(statearr_77100_77127[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (18))){
var inst_77065 = (state_77077[(2)]);
var state_77077__$1 = state_77077;
var statearr_77102_77128 = state_77077__$1;
(statearr_77102_77128[(2)] = inst_77065);

(statearr_77102_77128[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (8))){
var inst_77072 = (state_77077[(2)]);
var _ = (function (){var statearr_77103 = state_77077;
(statearr_77103[(4)] = cljs.core.rest.call(null,(state_77077[(4)])));

return statearr_77103;
})();
var state_77077__$1 = state_77077;
var statearr_77104_77129 = state_77077__$1;
(statearr_77104_77129[(2)] = inst_77072);

(statearr_77104_77129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0 = (function (){
var statearr_77105 = [null,null,null,null,null,null,null,null];
(statearr_77105[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__);

(statearr_77105[(1)] = (1));

return statearr_77105;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1 = (function (state_77077){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77106){var ex__2749__auto__ = e77106;
var statearr_77107_77130 = state_77077;
(statearr_77107_77130[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77077[(4)]))){
var statearr_77108_77131 = state_77077;
(statearr_77108_77131[(1)] = cljs.core.first.call(null,(state_77077[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77132 = state_77077;
state_77077 = G__77132;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__ = function(state_77077){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1.call(this,state_77077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77109 = f__2769__auto__.call(null);
(statearr_77109[(6)] = c__2768__auto__);

return statearr_77109;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77204){
var state_val_77205 = (state_77204[(1)]);
if((state_val_77205 === (7))){
var inst_77142 = cljs.core._EQ_.call(null,(0),auth);
var state_77204__$1 = state_77204;
if(inst_77142){
var statearr_77206_77260 = state_77204__$1;
(statearr_77206_77260[(1)] = (9));

} else {
var statearr_77207_77261 = state_77204__$1;
(statearr_77207_77261[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (20))){
var inst_77166 = (state_77204[(7)]);
var state_77204__$1 = state_77204;
if(cljs.core.truth_(inst_77166)){
var statearr_77208_77262 = state_77204__$1;
(statearr_77208_77262[(1)] = (22));

} else {
var statearr_77209_77263 = state_77204__$1;
(statearr_77209_77263[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (27))){
var state_77204__$1 = state_77204;
var statearr_77210_77264 = state_77204__$1;
(statearr_77210_77264[(2)] = null);

(statearr_77210_77264[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (1))){
var state_77204__$1 = state_77204;
var statearr_77211_77265 = state_77204__$1;
(statearr_77211_77265[(2)] = null);

(statearr_77211_77265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (24))){
var inst_77180 = (state_77204[(2)]);
var state_77204__$1 = state_77204;
var statearr_77212_77266 = state_77204__$1;
(statearr_77212_77266[(2)] = inst_77180);

(statearr_77212_77266[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (4))){
var inst_77133 = (state_77204[(2)]);
var state_77204__$1 = state_77204;
var statearr_77213_77267 = state_77204__$1;
(statearr_77213_77267[(2)] = inst_77133);

(statearr_77213_77267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (15))){
var inst_77149 = (state_77204[(8)]);
var inst_77148 = (state_77204[(2)]);
var inst_77149__$1 = fluree.db.util.async.throw_err.call(null,inst_77148);
var state_77204__$1 = (function (){var statearr_77214 = state_77204;
(statearr_77214[(8)] = inst_77149__$1);

return statearr_77214;
})();
if(cljs.core.truth_(inst_77149__$1)){
var statearr_77215_77268 = state_77204__$1;
(statearr_77215_77268[(1)] = (16));

} else {
var statearr_77216_77269 = state_77204__$1;
(statearr_77216_77269[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (21))){
var inst_77182 = (state_77204[(9)]);
var inst_77182__$1 = (state_77204[(2)]);
var state_77204__$1 = (function (){var statearr_77217 = state_77204;
(statearr_77217[(9)] = inst_77182__$1);

return statearr_77217;
})();
if(cljs.core.truth_(inst_77182__$1)){
var statearr_77218_77270 = state_77204__$1;
(statearr_77218_77270[(1)] = (29));

} else {
var statearr_77219_77271 = state_77204__$1;
(statearr_77219_77271[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (31))){
var inst_77182 = (state_77204[(9)]);
var inst_77190 = (state_77204[(2)]);
var state_77204__$1 = (function (){var statearr_77220 = state_77204;
(statearr_77220[(10)] = inst_77190);

return statearr_77220;
})();
if(cljs.core.truth_(inst_77182)){
var statearr_77221_77272 = state_77204__$1;
(statearr_77221_77272[(1)] = (33));

} else {
var statearr_77222_77273 = state_77204__$1;
(statearr_77222_77273[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (32))){
var inst_77186 = (state_77204[(2)]);
var inst_77187 = fluree.db.util.async.throw_err.call(null,inst_77186);
var state_77204__$1 = state_77204;
var statearr_77223_77274 = state_77204__$1;
(statearr_77223_77274[(2)] = inst_77187);

(statearr_77223_77274[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (33))){
var inst_77182 = (state_77204[(9)]);
var inst_77192 = fluree.db.permissions.permission_map.call(null,db,inst_77182,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_77204__$1 = state_77204;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77204__$1,(36),inst_77192);
} else {
if((state_val_77205 === (13))){
var state_77204__$1 = state_77204;
var statearr_77224_77275 = state_77204__$1;
(statearr_77224_77275[(2)] = null);

(statearr_77224_77275[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (22))){
var inst_77166 = (state_77204[(7)]);
var inst_77170 = fluree.db.auth.roles.call(null,db,inst_77166);
var state_77204__$1 = state_77204;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77204__$1,(25),inst_77170);
} else {
if((state_val_77205 === (36))){
var inst_77194 = (state_77204[(2)]);
var inst_77195 = fluree.db.util.async.throw_err.call(null,inst_77194);
var state_77204__$1 = state_77204;
var statearr_77225_77276 = state_77204__$1;
(statearr_77225_77276[(2)] = inst_77195);

(statearr_77225_77276[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (29))){
var inst_77182 = (state_77204[(9)]);
var inst_77166 = (state_77204[(7)]);
var inst_77184 = fluree.db.dbfunctions.ctx.build.call(null,db,inst_77166,inst_77182);
var state_77204__$1 = state_77204;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77204__$1,(32),inst_77184);
} else {
if((state_val_77205 === (6))){
var state_77204__$1 = state_77204;
var statearr_77226_77277 = state_77204__$1;
(statearr_77226_77277[(2)] = null);

(statearr_77226_77277[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (28))){
var inst_77178 = (state_77204[(2)]);
var state_77204__$1 = state_77204;
var statearr_77227_77278 = state_77204__$1;
(statearr_77227_77278[(2)] = inst_77178);

(statearr_77227_77278[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (25))){
var inst_77172 = (state_77204[(2)]);
var inst_77173 = fluree.db.util.async.throw_err.call(null,inst_77172);
var state_77204__$1 = state_77204;
var statearr_77228_77279 = state_77204__$1;
(statearr_77228_77279[(2)] = inst_77173);

(statearr_77228_77279[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (34))){
var state_77204__$1 = state_77204;
var statearr_77229_77280 = state_77204__$1;
(statearr_77229_77280[(2)] = null);

(statearr_77229_77280[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (17))){
var inst_77152 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_77153 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77154 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_77155 = cljs.core.PersistentHashMap.fromArrays(inst_77153,inst_77154);
var inst_77156 = cljs.core.ex_info.call(null,inst_77152,inst_77155);
var inst_77157 = (function(){throw inst_77156})();
var state_77204__$1 = state_77204;
var statearr_77230_77281 = state_77204__$1;
(statearr_77230_77281[(2)] = inst_77157);

(statearr_77230_77281[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (3))){
var inst_77202 = (state_77204[(2)]);
var state_77204__$1 = state_77204;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77204__$1,inst_77202);
} else {
if((state_val_77205 === (12))){
var inst_77146 = fluree.db.dbproto._subid.call(null,db,auth);
var state_77204__$1 = state_77204;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77204__$1,(15),inst_77146);
} else {
if((state_val_77205 === (2))){
var _ = (function (){var statearr_77231 = state_77204;
(statearr_77231[(4)] = cljs.core.cons.call(null,(5),(state_77204[(4)])));

return statearr_77231;
})();
var inst_77139 = (auth == null);
var state_77204__$1 = state_77204;
if(cljs.core.truth_(inst_77139)){
var statearr_77232_77282 = state_77204__$1;
(statearr_77232_77282[(1)] = (6));

} else {
var statearr_77233_77283 = state_77204__$1;
(statearr_77233_77283[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (23))){
var state_77204__$1 = state_77204;
var statearr_77234_77284 = state_77204__$1;
(statearr_77234_77284[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (35))){
var inst_77182 = (state_77204[(9)]);
var inst_77190 = (state_77204[(10)]);
var inst_77166 = (state_77204[(7)]);
var inst_77198 = (state_77204[(2)]);
var inst_77199 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_77166,new cljs.core.Keyword(null,"roles","roles",143379530),inst_77182,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_77198,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_77190);
var _ = (function (){var statearr_77236 = state_77204;
(statearr_77236[(4)] = cljs.core.rest.call(null,(state_77204[(4)])));

return statearr_77236;
})();
var state_77204__$1 = state_77204;
var statearr_77237_77285 = state_77204__$1;
(statearr_77237_77285[(2)] = inst_77199);

(statearr_77237_77285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (19))){
var state_77204__$1 = state_77204;
var statearr_77238_77286 = state_77204__$1;
(statearr_77238_77286[(2)] = roles);

(statearr_77238_77286[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (11))){
var inst_77164 = (state_77204[(2)]);
var state_77204__$1 = state_77204;
var statearr_77240_77287 = state_77204__$1;
(statearr_77240_77287[(2)] = inst_77164);

(statearr_77240_77287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (9))){
var state_77204__$1 = state_77204;
var statearr_77241_77288 = state_77204__$1;
(statearr_77241_77288[(2)] = (0));

(statearr_77241_77288[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (5))){
var _ = (function (){var statearr_77242 = state_77204;
(statearr_77242[(4)] = cljs.core.rest.call(null,(state_77204[(4)])));

return statearr_77242;
})();
var state_77204__$1 = state_77204;
var ex77239 = (state_77204__$1[(2)]);
var statearr_77243_77289 = state_77204__$1;
(statearr_77243_77289[(5)] = ex77239);


if((ex77239 instanceof Error)){
var statearr_77244_77290 = state_77204__$1;
(statearr_77244_77290[(1)] = (4));

(statearr_77244_77290[(5)] = null);

} else {
throw ex77239;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (14))){
var inst_77162 = (state_77204[(2)]);
var state_77204__$1 = state_77204;
var statearr_77245_77291 = state_77204__$1;
(statearr_77245_77291[(2)] = inst_77162);

(statearr_77245_77291[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (26))){
var state_77204__$1 = state_77204;
var statearr_77246_77292 = state_77204__$1;
(statearr_77246_77292[(2)] = null);

(statearr_77246_77292[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (16))){
var inst_77149 = (state_77204[(8)]);
var state_77204__$1 = state_77204;
var statearr_77247_77293 = state_77204__$1;
(statearr_77247_77293[(2)] = inst_77149);

(statearr_77247_77293[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (30))){
var state_77204__$1 = state_77204;
var statearr_77248_77294 = state_77204__$1;
(statearr_77248_77294[(2)] = null);

(statearr_77248_77294[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (10))){
var state_77204__$1 = state_77204;
if(cljs.core.truth_(auth)){
var statearr_77249_77295 = state_77204__$1;
(statearr_77249_77295[(1)] = (12));

} else {
var statearr_77250_77296 = state_77204__$1;
(statearr_77250_77296[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (18))){
var inst_77159 = (state_77204[(2)]);
var state_77204__$1 = state_77204;
var statearr_77251_77297 = state_77204__$1;
(statearr_77251_77297[(2)] = inst_77159);

(statearr_77251_77297[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77205 === (8))){
var inst_77166 = (state_77204[(2)]);
var state_77204__$1 = (function (){var statearr_77252 = state_77204;
(statearr_77252[(7)] = inst_77166);

return statearr_77252;
})();
if(cljs.core.truth_(roles)){
var statearr_77253_77298 = state_77204__$1;
(statearr_77253_77298[(1)] = (19));

} else {
var statearr_77254_77299 = state_77204__$1;
(statearr_77254_77299[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0 = (function (){
var statearr_77255 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_77255[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__);

(statearr_77255[(1)] = (1));

return statearr_77255;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1 = (function (state_77204){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77204);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77256){var ex__2749__auto__ = e77256;
var statearr_77257_77300 = state_77204;
(statearr_77257_77300[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77204[(4)]))){
var statearr_77258_77301 = state_77204;
(statearr_77258_77301[(1)] = cljs.core.first.call(null,(state_77204[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77302 = state_77204;
state_77204 = G__77302;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__ = function(state_77204){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1.call(this,state_77204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77259 = f__2769__auto__.call(null);
(statearr_77259[(6)] = c__2768__auto__);

return statearr_77259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__77303 = db;
var map__77303__$1 = cljs.core.__destructure_map.call(null,map__77303);
var conn = cljs.core.get.call(null,map__77303__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__77303__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__77303__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,listen_id);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77310){
var state_val_77311 = (state_77310[(1)]);
if((state_val_77311 === (1))){
var inst_77304 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_77305 = fluree.db.session.db.call(null,conn,inst_77304,null);
var state_77310__$1 = state_77310;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77310__$1,(2),inst_77305);
} else {
if((state_val_77311 === (2))){
var inst_77307 = (state_77310[(2)]);
var inst_77308 = cljs.core.async.put_BANG_.call(null,resp_port,inst_77307);
var state_77310__$1 = state_77310;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77310__$1,inst_77308);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0 = (function (){
var statearr_77312 = [null,null,null,null,null,null,null];
(statearr_77312[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__);

(statearr_77312[(1)] = (1));

return statearr_77312;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1 = (function (state_77310){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77310);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77313){var ex__2749__auto__ = e77313;
var statearr_77314_77341 = state_77310;
(statearr_77314_77341[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77310[(4)]))){
var statearr_77315_77342 = state_77310;
(statearr_77315_77342[(1)] = cljs.core.first.call(null,(state_77310[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77343 = state_77310;
state_77310 = G__77343;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = function(state_77310){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1.call(this,state_77310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77316 = f__2769__auto__.call(null);
(statearr_77316[(6)] = c__2768__auto__);

return statearr_77316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,ledger_id,listen_id,event_fn);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77329){
var state_val_77330 = (state_77329[(1)]);
if((state_val_77330 === (1))){
var inst_77317 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_77318 = fluree.db.session.db.call(null,conn,inst_77317,null);
var state_77329__$1 = state_77329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77329__$1,(2),inst_77318);
} else {
if((state_val_77330 === (2))){
var inst_77320 = (state_77329[(7)]);
var inst_77320__$1 = (state_77329[(2)]);
var inst_77321 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_77320__$1);
var inst_77322 = newer_block_QMARK_.call(null,inst_77321);
var state_77329__$1 = (function (){var statearr_77331 = state_77329;
(statearr_77331[(7)] = inst_77320__$1);

return statearr_77331;
})();
if(inst_77322){
var statearr_77332_77344 = state_77329__$1;
(statearr_77332_77344[(1)] = (3));

} else {
var statearr_77333_77345 = state_77329__$1;
(statearr_77333_77345[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77330 === (3))){
var inst_77320 = (state_77329[(7)]);
var inst_77324 = cljs.core.async.put_BANG_.call(null,resp_port,inst_77320);
var state_77329__$1 = state_77329;
var statearr_77334_77346 = state_77329__$1;
(statearr_77334_77346[(2)] = inst_77324);

(statearr_77334_77346[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77330 === (4))){
var state_77329__$1 = state_77329;
var statearr_77335_77347 = state_77329__$1;
(statearr_77335_77347[(2)] = null);

(statearr_77335_77347[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77330 === (5))){
var inst_77327 = (state_77329[(2)]);
var state_77329__$1 = state_77329;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77329__$1,inst_77327);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0 = (function (){
var statearr_77336 = [null,null,null,null,null,null,null,null];
(statearr_77336[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__);

(statearr_77336[(1)] = (1));

return statearr_77336;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1 = (function (state_77329){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77329);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77337){var ex__2749__auto__ = e77337;
var statearr_77338_77348 = state_77329;
(statearr_77338_77348[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77329[(4)]))){
var statearr_77339_77349 = state_77329;
(statearr_77339_77349[(1)] = cljs.core.first.call(null,(state_77329[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77350 = state_77329;
state_77329 = G__77350;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = function(state_77329){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1.call(this,state_77329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77340 = f__2769__auto__.call(null);
(statearr_77340[(6)] = c__2768__auto__);

return statearr_77340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__77351 = db;
var map__77351__$1 = cljs.core.__destructure_map.call(null,map__77351);
var conn = cljs.core.get.call(null,map__77351__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__77351__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__77351__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__4339__auto__ = syncTimeout;
var y__4340__auto__ = (120000);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__2768__auto___77427 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77401){
var state_val_77402 = (state_77401[(1)]);
if((state_val_77402 === (7))){
var inst_77367 = (state_77401[(7)]);
var inst_77378 = cljs.core._EQ_.call(null,inst_77367,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_77401__$1 = state_77401;
if(inst_77378){
var statearr_77403_77428 = state_77401__$1;
(statearr_77403_77428[(1)] = (9));

} else {
var statearr_77404_77429 = state_77401__$1;
(statearr_77404_77429[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77402 === (1))){
var inst_77360 = (state_77401[(8)]);
var inst_77352 = (state_77401[(9)]);
var inst_77352__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_77360__$1 = res_port;
var inst_77361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77362 = [inst_77352__$1,inst_77360__$1];
var inst_77363 = (new cljs.core.PersistentVector(null,2,(5),inst_77361,inst_77362,null));
var state_77401__$1 = (function (){var statearr_77405 = state_77401;
(statearr_77405[(8)] = inst_77360__$1);

(statearr_77405[(9)] = inst_77352__$1);

return statearr_77405;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_77401__$1,(2),inst_77363);
} else {
if((state_val_77402 === (4))){
var inst_77360 = (state_77401[(8)]);
var inst_77367 = (state_77401[(7)]);
var inst_77371 = cljs.core._EQ_.call(null,inst_77367,inst_77360);
var state_77401__$1 = state_77401;
if(inst_77371){
var statearr_77406_77430 = state_77401__$1;
(statearr_77406_77430[(1)] = (6));

} else {
var statearr_77407_77431 = state_77401__$1;
(statearr_77407_77431[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77402 === (13))){
var inst_77386 = (state_77401[(10)]);
var inst_77397 = cljs.core.async.put_BANG_.call(null,pc,inst_77386);
var state_77401__$1 = state_77401;
var statearr_77408_77432 = state_77401__$1;
(statearr_77408_77432[(2)] = inst_77397);

(statearr_77408_77432[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77402 === (6))){
var inst_77365 = (state_77401[(11)]);
var inst_77376 = cljs.core.nth.call(null,inst_77365,(0),null);
var state_77401__$1 = state_77401;
var statearr_77409_77433 = state_77401__$1;
(statearr_77409_77433[(2)] = inst_77376);

(statearr_77409_77433[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77402 === (3))){
var state_77401__$1 = state_77401;
var statearr_77410_77434 = state_77401__$1;
(statearr_77410_77434[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_77410_77434[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77402 === (12))){
var inst_77390 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_77391 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77392 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_77393 = cljs.core.PersistentHashMap.fromArrays(inst_77391,inst_77392);
var inst_77394 = cljs.core.ex_info.call(null,inst_77390,inst_77393);
var inst_77395 = cljs.core.async.put_BANG_.call(null,pc,inst_77394);
var state_77401__$1 = state_77401;
var statearr_77411_77435 = state_77401__$1;
(statearr_77411_77435[(2)] = inst_77395);

(statearr_77411_77435[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77402 === (2))){
var inst_77365 = (state_77401[(11)]);
var inst_77367 = (state_77401[(7)]);
var inst_77352 = (state_77401[(9)]);
var inst_77365__$1 = (state_77401[(2)]);
var inst_77366 = cljs.core.nth.call(null,inst_77365__$1,(0),null);
var inst_77367__$1 = cljs.core.nth.call(null,inst_77365__$1,(1),null);
var inst_77368 = cljs.core._EQ_.call(null,inst_77367__$1,inst_77352);
var state_77401__$1 = (function (){var statearr_77412 = state_77401;
(statearr_77412[(12)] = inst_77366);

(statearr_77412[(11)] = inst_77365__$1);

(statearr_77412[(7)] = inst_77367__$1);

return statearr_77412;
})();
if(inst_77368){
var statearr_77413_77436 = state_77401__$1;
(statearr_77413_77436[(1)] = (3));

} else {
var statearr_77414_77437 = state_77401__$1;
(statearr_77414_77437[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77402 === (11))){
var inst_77382 = (state_77401[(2)]);
var state_77401__$1 = state_77401;
var statearr_77415_77438 = state_77401__$1;
(statearr_77415_77438[(2)] = inst_77382);

(statearr_77415_77438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77402 === (9))){
var inst_77366 = (state_77401[(12)]);
var state_77401__$1 = state_77401;
var statearr_77416_77439 = state_77401__$1;
(statearr_77416_77439[(2)] = inst_77366);

(statearr_77416_77439[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77402 === (5))){
var inst_77386 = (state_77401[(10)]);
var inst_77386__$1 = (state_77401[(2)]);
var inst_77387 = fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,listen_id);
var inst_77388 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_77386__$1);
var state_77401__$1 = (function (){var statearr_77417 = state_77401;
(statearr_77417[(10)] = inst_77386__$1);

(statearr_77417[(13)] = inst_77387);

return statearr_77417;
})();
if(inst_77388){
var statearr_77418_77440 = state_77401__$1;
(statearr_77418_77440[(1)] = (12));

} else {
var statearr_77419_77441 = state_77401__$1;
(statearr_77419_77441[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77402 === (14))){
var inst_77399 = (state_77401[(2)]);
var state_77401__$1 = state_77401;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77401__$1,inst_77399);
} else {
if((state_val_77402 === (10))){
var state_77401__$1 = state_77401;
var statearr_77420_77442 = state_77401__$1;
(statearr_77420_77442[(2)] = null);

(statearr_77420_77442[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77402 === (8))){
var inst_77384 = (state_77401[(2)]);
var state_77401__$1 = state_77401;
var statearr_77421_77443 = state_77401__$1;
(statearr_77421_77443[(2)] = inst_77384);

(statearr_77421_77443[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0 = (function (){
var statearr_77422 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77422[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__);

(statearr_77422[(1)] = (1));

return statearr_77422;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1 = (function (state_77401){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77401);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77423){var ex__2749__auto__ = e77423;
var statearr_77424_77444 = state_77401;
(statearr_77424_77444[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77401[(4)]))){
var statearr_77425_77445 = state_77401;
(statearr_77425_77445[(1)] = cljs.core.first.call(null,(state_77401[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77446 = state_77401;
state_77401 = G__77446;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__ = function(state_77401){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1.call(this,state_77401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77426 = f__2769__auto__.call(null);
(statearr_77426[(6)] = c__2768__auto___77427);

return statearr_77426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__77448 = arguments.length;
switch (G__77448) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__77449){
var map__77450 = p__77449;
var map__77450__$1 = cljs.core.__destructure_map.call(null,map__77450);
var opts = map__77450__$1;
var roles = cljs.core.get.call(null,map__77450__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__77450__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__77450__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__77450__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__77450__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2768__auto___77539 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77501){
var state_val_77502 = (state_77501[(1)]);
if((state_val_77502 === (7))){
var inst_77463 = (state_77501[(7)]);
var inst_77465 = fluree.db.api.ledger.syncTo_db.call(null,inst_77463,syncTo,syncTimeout);
var state_77501__$1 = state_77501;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77501__$1,(10),inst_77465);
} else {
if((state_val_77502 === (20))){
var inst_77487 = (state_77501[(8)]);
var state_77501__$1 = state_77501;
var statearr_77503_77540 = state_77501__$1;
(statearr_77503_77540[(2)] = inst_77487);

(statearr_77503_77540[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (1))){
var state_77501__$1 = state_77501;
var statearr_77504_77541 = state_77501__$1;
(statearr_77504_77541[(2)] = null);

(statearr_77504_77541[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (4))){
var inst_77451 = (state_77501[(2)]);
var inst_77452 = cljs.core.async.put_BANG_.call(null,pc,inst_77451);
var inst_77453 = cljs.core.async.close_BANG_.call(null,pc);
var state_77501__$1 = (function (){var statearr_77505 = state_77501;
(statearr_77505[(9)] = inst_77452);

return statearr_77505;
})();
var statearr_77506_77542 = state_77501__$1;
(statearr_77506_77542[(2)] = inst_77453);

(statearr_77506_77542[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (15))){
var inst_77479 = (state_77501[(10)]);
var inst_77481 = fluree.db.api.ledger.add_db_permissions.call(null,inst_77479,auth,roles);
var state_77501__$1 = state_77501;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77501__$1,(18),inst_77481);
} else {
if((state_val_77502 === (21))){
var inst_77495 = (state_77501[(2)]);
var inst_77496 = cljs.core.async.put_BANG_.call(null,pc,inst_77495);
var _ = (function (){var statearr_77507 = state_77501;
(statearr_77507[(4)] = cljs.core.rest.call(null,(state_77501[(4)])));

return statearr_77507;
})();
var state_77501__$1 = state_77501;
var statearr_77508_77543 = state_77501__$1;
(statearr_77508_77543[(2)] = inst_77496);

(statearr_77508_77543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (13))){
var inst_77479 = (state_77501[(2)]);
var state_77501__$1 = (function (){var statearr_77509 = state_77501;
(statearr_77509[(10)] = inst_77479);

return statearr_77509;
})();
if(cljs.core.truth_(roles)){
var statearr_77510_77544 = state_77501__$1;
(statearr_77510_77544[(1)] = (15));

} else {
var statearr_77511_77545 = state_77501__$1;
(statearr_77511_77545[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (22))){
var inst_77491 = (state_77501[(2)]);
var inst_77492 = fluree.db.util.async.throw_err.call(null,inst_77491);
var state_77501__$1 = state_77501;
var statearr_77512_77546 = state_77501__$1;
(statearr_77512_77546[(2)] = inst_77492);

(statearr_77512_77546[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (6))){
var inst_77462 = (state_77501[(2)]);
var inst_77463 = fluree.db.util.async.throw_err.call(null,inst_77462);
var state_77501__$1 = (function (){var statearr_77513 = state_77501;
(statearr_77513[(7)] = inst_77463);

return statearr_77513;
})();
if(cljs.core.truth_(syncTo)){
var statearr_77514_77547 = state_77501__$1;
(statearr_77514_77547[(1)] = (7));

} else {
var statearr_77515_77548 = state_77501__$1;
(statearr_77515_77548[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (17))){
var inst_77487 = (state_77501[(2)]);
var state_77501__$1 = (function (){var statearr_77516 = state_77501;
(statearr_77516[(8)] = inst_77487);

return statearr_77516;
})();
if(cljs.core.truth_(auth)){
var statearr_77517_77549 = state_77501__$1;
(statearr_77517_77549[(1)] = (19));

} else {
var statearr_77518_77550 = state_77501__$1;
(statearr_77518_77550[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (3))){
var inst_77499 = (state_77501[(2)]);
var state_77501__$1 = state_77501;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77501__$1,inst_77499);
} else {
if((state_val_77502 === (12))){
var inst_77471 = (state_77501[(11)]);
var state_77501__$1 = state_77501;
var statearr_77519_77551 = state_77501__$1;
(statearr_77519_77551[(2)] = inst_77471);

(statearr_77519_77551[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (2))){
var _ = (function (){var statearr_77520 = state_77501;
(statearr_77520[(4)] = cljs.core.cons.call(null,(5),(state_77501[(4)])));

return statearr_77520;
})();
var inst_77460 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_77501__$1 = state_77501;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77501__$1,(6),inst_77460);
} else {
if((state_val_77502 === (19))){
var inst_77487 = (state_77501[(8)]);
var inst_77489 = fluree.db.api.ledger.add_db_permissions.call(null,inst_77487,auth,roles);
var state_77501__$1 = state_77501;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77501__$1,(22),inst_77489);
} else {
if((state_val_77502 === (11))){
var inst_77471 = (state_77501[(11)]);
var inst_77473 = fluree.db.time_travel.as_of_block.call(null,inst_77471,block);
var state_77501__$1 = state_77501;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77501__$1,(14),inst_77473);
} else {
if((state_val_77502 === (9))){
var inst_77471 = (state_77501[(2)]);
var state_77501__$1 = (function (){var statearr_77522 = state_77501;
(statearr_77522[(11)] = inst_77471);

return statearr_77522;
})();
if(cljs.core.truth_(block)){
var statearr_77523_77552 = state_77501__$1;
(statearr_77523_77552[(1)] = (11));

} else {
var statearr_77524_77553 = state_77501__$1;
(statearr_77524_77553[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (5))){
var _ = (function (){var statearr_77525 = state_77501;
(statearr_77525[(4)] = cljs.core.rest.call(null,(state_77501[(4)])));

return statearr_77525;
})();
var state_77501__$1 = state_77501;
var ex77521 = (state_77501__$1[(2)]);
var statearr_77526_77554 = state_77501__$1;
(statearr_77526_77554[(5)] = ex77521);


var statearr_77527_77555 = state_77501__$1;
(statearr_77527_77555[(1)] = (4));

(statearr_77527_77555[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (14))){
var inst_77475 = (state_77501[(2)]);
var inst_77476 = fluree.db.util.async.throw_err.call(null,inst_77475);
var state_77501__$1 = state_77501;
var statearr_77528_77556 = state_77501__$1;
(statearr_77528_77556[(2)] = inst_77476);

(statearr_77528_77556[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (16))){
var inst_77479 = (state_77501[(10)]);
var state_77501__$1 = state_77501;
var statearr_77529_77557 = state_77501__$1;
(statearr_77529_77557[(2)] = inst_77479);

(statearr_77529_77557[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (10))){
var inst_77467 = (state_77501[(2)]);
var inst_77468 = fluree.db.util.async.throw_err.call(null,inst_77467);
var state_77501__$1 = state_77501;
var statearr_77530_77558 = state_77501__$1;
(statearr_77530_77558[(2)] = inst_77468);

(statearr_77530_77558[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (18))){
var inst_77483 = (state_77501[(2)]);
var inst_77484 = fluree.db.util.async.throw_err.call(null,inst_77483);
var state_77501__$1 = state_77501;
var statearr_77531_77559 = state_77501__$1;
(statearr_77531_77559[(2)] = inst_77484);

(statearr_77531_77559[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77502 === (8))){
var inst_77463 = (state_77501[(7)]);
var state_77501__$1 = state_77501;
var statearr_77532_77560 = state_77501__$1;
(statearr_77532_77560[(2)] = inst_77463);

(statearr_77532_77560[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2746__auto__ = null;
var fluree$db$api$ledger$state_machine__2746__auto____0 = (function (){
var statearr_77533 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77533[(0)] = fluree$db$api$ledger$state_machine__2746__auto__);

(statearr_77533[(1)] = (1));

return statearr_77533;
});
var fluree$db$api$ledger$state_machine__2746__auto____1 = (function (state_77501){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77501);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77534){var ex__2749__auto__ = e77534;
var statearr_77535_77561 = state_77501;
(statearr_77535_77561[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77501[(4)]))){
var statearr_77536_77562 = state_77501;
(statearr_77536_77562[(1)] = cljs.core.first.call(null,(state_77501[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77563 = state_77501;
state_77501 = G__77563;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2746__auto__ = function(state_77501){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2746__auto____1.call(this,state_77501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2746__auto____0;
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2746__auto____1;
return fluree$db$api$ledger$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77537 = f__2769__auto__.call(null);
(statearr_77537[(6)] = c__2768__auto___77539);

return statearr_77537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

