// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__68610 = arguments.length;
switch (G__68610) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___68758 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68697){
var state_val_68698 = (state_68697[(1)]);
if((state_val_68698 === (7))){
var inst_68628 = (state_68697[(7)]);
var inst_68631 = cljs.core.not_EQ_.call(null,(0),inst_68628);
var state_68697__$1 = state_68697;
var statearr_68699_68759 = state_68697__$1;
(statearr_68699_68759[(2)] = inst_68631);

(statearr_68699_68759[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (20))){
var inst_68652 = (state_68697[(8)]);
var inst_68623 = (state_68697[(9)]);
var inst_68656 = fluree.db.auth.roles.call(null,inst_68623,inst_68652);
var state_68697__$1 = state_68697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68697__$1,(23),inst_68656);
} else {
if((state_val_68698 === (27))){
var inst_68623 = (state_68697[(9)]);
var inst_68671 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_68672 = fluree.db.time_travel.as_of_block.call(null,inst_68623,inst_68671);
var state_68697__$1 = state_68697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68697__$1,(30),inst_68672);
} else {
if((state_val_68698 === (1))){
var state_68697__$1 = state_68697;
var statearr_68700_68760 = state_68697__$1;
(statearr_68700_68760[(2)] = null);

(statearr_68700_68760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (24))){
var inst_68623 = (state_68697[(9)]);
var inst_68664 = (state_68697[(10)]);
var inst_68666 = fluree.db.permissions.permission_map.call(null,inst_68623,inst_68664,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_68697__$1 = state_68697;
var statearr_68701_68761 = state_68697__$1;
(statearr_68701_68761[(2)] = inst_68666);

(statearr_68701_68761[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (4))){
var inst_68611 = (state_68697[(2)]);
var inst_68612 = cljs.core.async.put_BANG_.call(null,pc,inst_68611);
var inst_68613 = cljs.core.async.close_BANG_.call(null,pc);
var state_68697__$1 = (function (){var statearr_68702 = state_68697;
(statearr_68702[(11)] = inst_68612);

return statearr_68702;
})();
var statearr_68703_68762 = state_68697__$1;
(statearr_68703_68762[(2)] = inst_68613);

(statearr_68703_68762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (15))){
var inst_68628 = (state_68697[(7)]);
var inst_68642 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68628)," unknown."].join('');
var inst_68643 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68644 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_68645 = cljs.core.PersistentHashMap.fromArrays(inst_68643,inst_68644);
var inst_68646 = cljs.core.ex_info.call(null,inst_68642,inst_68645);
var inst_68647 = (function(){throw inst_68646})();
var state_68697__$1 = state_68697;
var statearr_68704_68763 = state_68697__$1;
(statearr_68704_68763[(2)] = inst_68647);

(statearr_68704_68763[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (21))){
var state_68697__$1 = state_68697;
var statearr_68705_68764 = state_68697__$1;
(statearr_68705_68764[(2)] = null);

(statearr_68705_68764[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (31))){
var inst_68678 = (state_68697[(12)]);
var inst_68628 = (state_68697[(7)]);
var inst_68680 = cljs.core.assoc.call(null,inst_68678,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_68628);
var state_68697__$1 = state_68697;
var statearr_68706_68765 = state_68697__$1;
(statearr_68706_68765[(2)] = inst_68680);

(statearr_68706_68765[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (32))){
var inst_68678 = (state_68697[(12)]);
var state_68697__$1 = state_68697;
var statearr_68707_68766 = state_68697__$1;
(statearr_68707_68766[(2)] = inst_68678);

(statearr_68707_68766[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (33))){
var inst_68664 = (state_68697[(10)]);
var inst_68683 = (state_68697[(2)]);
var state_68697__$1 = (function (){var statearr_68708 = state_68697;
(statearr_68708[(13)] = inst_68683);

return statearr_68708;
})();
if(cljs.core.truth_(inst_68664)){
var statearr_68709_68767 = state_68697__$1;
(statearr_68709_68767[(1)] = (34));

} else {
var statearr_68710_68768 = state_68697__$1;
(statearr_68710_68768[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (13))){
var inst_68639 = (state_68697[(14)]);
var inst_68638 = (state_68697[(2)]);
var inst_68639__$1 = fluree.db.util.async.throw_err.call(null,inst_68638);
var state_68697__$1 = (function (){var statearr_68711 = state_68697;
(statearr_68711[(14)] = inst_68639__$1);

return statearr_68711;
})();
if(cljs.core.truth_(inst_68639__$1)){
var statearr_68712_68769 = state_68697__$1;
(statearr_68712_68769[(1)] = (14));

} else {
var statearr_68713_68770 = state_68697__$1;
(statearr_68713_68770[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (22))){
var inst_68662 = (state_68697[(2)]);
var state_68697__$1 = state_68697;
var statearr_68714_68771 = state_68697__$1;
(statearr_68714_68771[(2)] = inst_68662);

(statearr_68714_68771[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (36))){
var inst_68691 = (state_68697[(2)]);
var inst_68692 = cljs.core.async.put_BANG_.call(null,pc,inst_68691);
var _ = (function (){var statearr_68715 = state_68697;
(statearr_68715[(4)] = cljs.core.rest.call(null,(state_68697[(4)])));

return statearr_68715;
})();
var state_68697__$1 = state_68697;
var statearr_68716_68772 = state_68697__$1;
(statearr_68716_68772[(2)] = inst_68692);

(statearr_68716_68772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (29))){
var inst_68628 = (state_68697[(7)]);
var inst_68678 = (state_68697[(2)]);
var state_68697__$1 = (function (){var statearr_68717 = state_68697;
(statearr_68717[(12)] = inst_68678);

return statearr_68717;
})();
if(cljs.core.truth_(inst_68628)){
var statearr_68718_68773 = state_68697__$1;
(statearr_68718_68773[(1)] = (31));

} else {
var statearr_68719_68774 = state_68697__$1;
(statearr_68719_68774[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (6))){
var inst_68628 = (state_68697[(7)]);
var inst_68622 = (state_68697[(2)]);
var inst_68623 = fluree.db.util.async.throw_err.call(null,inst_68622);
var inst_68624 = opts;
var inst_68625 = cljs.core.__destructure_map.call(null,inst_68624);
var inst_68626 = cljs.core.get.call(null,inst_68625,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_68627 = cljs.core.get.call(null,inst_68625,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_68628__$1 = cljs.core.get.call(null,inst_68625,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_68629 = cljs.core.get.call(null,inst_68625,new cljs.core.Keyword(null,"block","block",664686210));
var state_68697__$1 = (function (){var statearr_68720 = state_68697;
(statearr_68720[(15)] = inst_68629);

(statearr_68720[(9)] = inst_68623);

(statearr_68720[(16)] = inst_68626);

(statearr_68720[(17)] = inst_68627);

(statearr_68720[(7)] = inst_68628__$1);

return statearr_68720;
})();
if(cljs.core.truth_(inst_68628__$1)){
var statearr_68721_68775 = state_68697__$1;
(statearr_68721_68775[(1)] = (7));

} else {
var statearr_68722_68776 = state_68697__$1;
(statearr_68722_68776[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (28))){
var inst_68623 = (state_68697[(9)]);
var state_68697__$1 = state_68697;
var statearr_68723_68777 = state_68697__$1;
(statearr_68723_68777[(2)] = inst_68623);

(statearr_68723_68777[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (25))){
var state_68697__$1 = state_68697;
var statearr_68724_68778 = state_68697__$1;
(statearr_68724_68778[(2)] = null);

(statearr_68724_68778[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (34))){
var inst_68669 = (state_68697[(18)]);
var state_68697__$1 = state_68697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68697__$1,(37),inst_68669);
} else {
if((state_val_68698 === (17))){
var inst_68626 = (state_68697[(16)]);
var state_68697__$1 = state_68697;
var statearr_68725_68779 = state_68697__$1;
(statearr_68725_68779[(2)] = inst_68626);

(statearr_68725_68779[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (3))){
var inst_68695 = (state_68697[(2)]);
var state_68697__$1 = state_68697;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68697__$1,inst_68695);
} else {
if((state_val_68698 === (12))){
var inst_68626 = (state_68697[(16)]);
var inst_68652 = (state_68697[(2)]);
var state_68697__$1 = (function (){var statearr_68726 = state_68697;
(statearr_68726[(8)] = inst_68652);

return statearr_68726;
})();
if(cljs.core.truth_(inst_68626)){
var statearr_68727_68780 = state_68697__$1;
(statearr_68727_68780[(1)] = (17));

} else {
var statearr_68728_68781 = state_68697__$1;
(statearr_68728_68781[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (2))){
var _ = (function (){var statearr_68729 = state_68697;
(statearr_68729[(4)] = cljs.core.cons.call(null,(5),(state_68697[(4)])));

return statearr_68729;
})();
var inst_68620 = fluree.db.session.db.call(null,conn,ledger,null);
var state_68697__$1 = state_68697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68697__$1,(6),inst_68620);
} else {
if((state_val_68698 === (23))){
var inst_68658 = (state_68697[(2)]);
var inst_68659 = fluree.db.util.async.throw_err.call(null,inst_68658);
var state_68697__$1 = state_68697;
var statearr_68730_68782 = state_68697__$1;
(statearr_68730_68782[(2)] = inst_68659);

(statearr_68730_68782[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (35))){
var inst_68683 = (state_68697[(13)]);
var state_68697__$1 = state_68697;
var statearr_68731_68783 = state_68697__$1;
(statearr_68731_68783[(2)] = inst_68683);

(statearr_68731_68783[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (19))){
var inst_68664 = (state_68697[(10)]);
var inst_68664__$1 = (state_68697[(2)]);
var state_68697__$1 = (function (){var statearr_68732 = state_68697;
(statearr_68732[(10)] = inst_68664__$1);

return statearr_68732;
})();
if(cljs.core.truth_(inst_68664__$1)){
var statearr_68733_68784 = state_68697__$1;
(statearr_68733_68784[(1)] = (24));

} else {
var statearr_68734_68785 = state_68697__$1;
(statearr_68734_68785[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (11))){
var state_68697__$1 = state_68697;
var statearr_68736_68786 = state_68697__$1;
(statearr_68736_68786[(2)] = null);

(statearr_68736_68786[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (9))){
var inst_68634 = (state_68697[(2)]);
var state_68697__$1 = state_68697;
if(cljs.core.truth_(inst_68634)){
var statearr_68737_68787 = state_68697__$1;
(statearr_68737_68787[(1)] = (10));

} else {
var statearr_68738_68788 = state_68697__$1;
(statearr_68738_68788[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (5))){
var _ = (function (){var statearr_68739 = state_68697;
(statearr_68739[(4)] = cljs.core.rest.call(null,(state_68697[(4)])));

return statearr_68739;
})();
var state_68697__$1 = state_68697;
var ex68735 = (state_68697__$1[(2)]);
var statearr_68740_68789 = state_68697__$1;
(statearr_68740_68789[(5)] = ex68735);


var statearr_68741_68790 = state_68697__$1;
(statearr_68741_68790[(1)] = (4));

(statearr_68741_68790[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (14))){
var inst_68639 = (state_68697[(14)]);
var state_68697__$1 = state_68697;
var statearr_68742_68791 = state_68697__$1;
(statearr_68742_68791[(2)] = inst_68639);

(statearr_68742_68791[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (26))){
var inst_68629 = (state_68697[(15)]);
var inst_68669 = (state_68697[(2)]);
var state_68697__$1 = (function (){var statearr_68743 = state_68697;
(statearr_68743[(18)] = inst_68669);

return statearr_68743;
})();
if(cljs.core.truth_(inst_68629)){
var statearr_68744_68792 = state_68697__$1;
(statearr_68744_68792[(1)] = (27));

} else {
var statearr_68745_68793 = state_68697__$1;
(statearr_68745_68793[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (16))){
var inst_68649 = (state_68697[(2)]);
var state_68697__$1 = state_68697;
var statearr_68746_68794 = state_68697__$1;
(statearr_68746_68794[(2)] = inst_68649);

(statearr_68746_68794[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (30))){
var inst_68674 = (state_68697[(2)]);
var inst_68675 = fluree.db.util.async.throw_err.call(null,inst_68674);
var state_68697__$1 = state_68697;
var statearr_68747_68795 = state_68697__$1;
(statearr_68747_68795[(2)] = inst_68675);

(statearr_68747_68795[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (10))){
var inst_68623 = (state_68697[(9)]);
var inst_68628 = (state_68697[(7)]);
var inst_68636 = fluree.db.dbproto._subid.call(null,inst_68623,inst_68628);
var state_68697__$1 = state_68697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68697__$1,(13),inst_68636);
} else {
if((state_val_68698 === (18))){
var inst_68652 = (state_68697[(8)]);
var state_68697__$1 = state_68697;
if(cljs.core.truth_(inst_68652)){
var statearr_68748_68796 = state_68697__$1;
(statearr_68748_68796[(1)] = (20));

} else {
var statearr_68749_68797 = state_68697__$1;
(statearr_68749_68797[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (37))){
var inst_68683 = (state_68697[(13)]);
var inst_68686 = (state_68697[(2)]);
var inst_68687 = fluree.db.util.async.throw_err.call(null,inst_68686);
var inst_68688 = cljs.core.assoc.call(null,inst_68683,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_68687);
var state_68697__$1 = state_68697;
var statearr_68750_68798 = state_68697__$1;
(statearr_68750_68798[(2)] = inst_68688);

(statearr_68750_68798[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68698 === (8))){
var inst_68628 = (state_68697[(7)]);
var state_68697__$1 = state_68697;
var statearr_68751_68799 = state_68697__$1;
(statearr_68751_68799[(2)] = inst_68628);

(statearr_68751_68799[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2746__auto__ = null;
var fluree$db$api$query$state_machine__2746__auto____0 = (function (){
var statearr_68752 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68752[(0)] = fluree$db$api$query$state_machine__2746__auto__);

(statearr_68752[(1)] = (1));

return statearr_68752;
});
var fluree$db$api$query$state_machine__2746__auto____1 = (function (state_68697){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68697);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68753){var ex__2749__auto__ = e68753;
var statearr_68754_68800 = state_68697;
(statearr_68754_68800[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68697[(4)]))){
var statearr_68755_68801 = state_68697;
(statearr_68755_68801[(1)] = cljs.core.first.call(null,(state_68697[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68802 = state_68697;
state_68697 = G__68802;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2746__auto__ = function(state_68697){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2746__auto____1.call(this,state_68697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2746__auto____0;
fluree$db$api$query$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2746__auto____1;
return fluree$db$api$query$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68756 = f__2769__auto__.call(null);
(statearr_68756[(6)] = c__2768__auto___68758);

return statearr_68756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68943){
var state_val_68944 = (state_68943[(1)]);
if((state_val_68944 === (7))){
var inst_68823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68824 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_68825 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_68826 = [inst_68824,inst_68825];
var inst_68827 = (new cljs.core.PersistentVector(null,2,(5),inst_68823,inst_68826,null));
var state_68943__$1 = state_68943;
var statearr_68945_69015 = state_68943__$1;
(statearr_68945_69015[(2)] = inst_68827);

(statearr_68945_69015[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (20))){
var inst_68853 = (state_68943[(7)]);
var state_68943__$1 = state_68943;
var statearr_68946_69016 = state_68943__$1;
(statearr_68946_69016[(2)] = inst_68853);

(statearr_68946_69016[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (27))){
var state_68943__$1 = state_68943;
var statearr_68947_69017 = state_68943__$1;
(statearr_68947_69017[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (1))){
var state_68943__$1 = state_68943;
var statearr_68949_69018 = state_68943__$1;
(statearr_68949_69018[(2)] = null);

(statearr_68949_69018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (24))){
var inst_68852 = (state_68943[(8)]);
var state_68943__$1 = state_68943;
if(cljs.core.truth_(inst_68852)){
var statearr_68950_69019 = state_68943__$1;
(statearr_68950_69019[(1)] = (26));

} else {
var statearr_68951_69020 = state_68943__$1;
(statearr_68951_69020[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (39))){
var inst_68899 = (state_68943[(9)]);
var inst_68898 = (state_68943[(10)]);
var inst_68924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68925 = [inst_68898,inst_68899];
var inst_68926 = (new cljs.core.PersistentVector(null,2,(5),inst_68924,inst_68925,null));
var state_68943__$1 = state_68943;
var statearr_68952_69021 = state_68943__$1;
(statearr_68952_69021[(2)] = inst_68926);

(statearr_68952_69021[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (4))){
var inst_68803 = (state_68943[(2)]);
var state_68943__$1 = state_68943;
var statearr_68953_69022 = state_68943__$1;
(statearr_68953_69022[(2)] = inst_68803);

(statearr_68953_69022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (15))){
var inst_68832 = (state_68943[(11)]);
var inst_68837 = (state_68943[(12)]);
var inst_68846 = (state_68943[(2)]);
var inst_68847 = [inst_68837,inst_68846];
var inst_68848 = (new cljs.core.PersistentVector(null,2,(5),inst_68832,inst_68847,null));
var state_68943__$1 = state_68943;
var statearr_68954_69023 = state_68943__$1;
(statearr_68954_69023[(2)] = inst_68848);

(statearr_68954_69023[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (21))){
var inst_68852 = (state_68943[(8)]);
var state_68943__$1 = state_68943;
var statearr_68955_69024 = state_68943__$1;
(statearr_68955_69024[(2)] = inst_68852);

(statearr_68955_69024[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (31))){
var inst_68893 = (state_68943[(2)]);
var state_68943__$1 = state_68943;
var statearr_68956_69025 = state_68943__$1;
(statearr_68956_69025[(2)] = inst_68893);

(statearr_68956_69025[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (32))){
var inst_68899 = (state_68943[(9)]);
var inst_68902 = cljs.core.pos_int_QMARK_.call(null,inst_68899);
var state_68943__$1 = state_68943;
var statearr_68957_69026 = state_68943__$1;
(statearr_68957_69026[(2)] = inst_68902);

(statearr_68957_69026[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (40))){
var inst_68854 = (state_68943[(13)]);
var inst_68930 = (state_68943[(14)]);
var inst_68928 = (state_68943[(2)]);
var inst_68929 = cljs.core.nth.call(null,inst_68928,(0),null);
var inst_68930__$1 = cljs.core.nth.call(null,inst_68928,(1),null);
var inst_68931 = (inst_68930__$1 > inst_68854);
var state_68943__$1 = (function (){var statearr_68958 = state_68943;
(statearr_68958[(15)] = inst_68929);

(statearr_68958[(14)] = inst_68930__$1);

return statearr_68958;
})();
if(cljs.core.truth_(inst_68931)){
var statearr_68959_69027 = state_68943__$1;
(statearr_68959_69027[(1)] = (41));

} else {
var statearr_68960_69028 = state_68943__$1;
(statearr_68960_69028[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (33))){
var inst_68900 = (state_68943[(16)]);
var state_68943__$1 = state_68943;
var statearr_68961_69029 = state_68943__$1;
(statearr_68961_69029[(2)] = inst_68900);

(statearr_68961_69029[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (13))){
var inst_68838 = (state_68943[(17)]);
var inst_68840 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_68838);
var state_68943__$1 = state_68943;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68943__$1,(16),inst_68840);
} else {
if((state_val_68944 === (22))){
var inst_68871 = (state_68943[(2)]);
var state_68943__$1 = state_68943;
if(cljs.core.truth_(inst_68871)){
var statearr_68962_69030 = state_68943__$1;
(statearr_68962_69030[(1)] = (23));

} else {
var statearr_68963_69031 = state_68943__$1;
(statearr_68963_69031[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (36))){
var state_68943__$1 = state_68943;
var statearr_68964_69032 = state_68943__$1;
(statearr_68964_69032[(2)] = null);

(statearr_68964_69032[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (41))){
var inst_68854 = (state_68943[(13)]);
var state_68943__$1 = state_68943;
var statearr_68965_69033 = state_68943__$1;
(statearr_68965_69033[(2)] = inst_68854);

(statearr_68965_69033[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (43))){
var inst_68929 = (state_68943[(15)]);
var inst_68935 = (state_68943[(2)]);
var inst_68936 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68937 = [inst_68929,inst_68935];
var inst_68938 = (new cljs.core.PersistentVector(null,2,(5),inst_68936,inst_68937,null));
var _ = (function (){var statearr_68966 = state_68943;
(statearr_68966[(4)] = cljs.core.rest.call(null,(state_68943[(4)])));

return statearr_68966;
})();
var state_68943__$1 = state_68943;
var statearr_68967_69034 = state_68943__$1;
(statearr_68967_69034[(2)] = inst_68938);

(statearr_68967_69034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (29))){
var inst_68829 = (state_68943[(18)]);
var inst_68884 = cljs.core.pr_str.call(null,inst_68829);
var inst_68885 = ["Invalid block range provided: ",inst_68884].join('');
var inst_68886 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68887 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_68888 = cljs.core.PersistentHashMap.fromArrays(inst_68886,inst_68887);
var inst_68889 = cljs.core.ex_info.call(null,inst_68885,inst_68888);
var inst_68890 = (function(){throw inst_68889})();
var state_68943__$1 = state_68943;
var statearr_68968_69035 = state_68943__$1;
(statearr_68968_69035[(2)] = inst_68890);

(statearr_68968_69035[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (6))){
var inst_68821 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_68943__$1 = state_68943;
var statearr_68969_69036 = state_68943__$1;
(statearr_68969_69036[(2)] = inst_68821);

(statearr_68969_69036[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (28))){
var inst_68895 = (state_68943[(2)]);
var state_68943__$1 = state_68943;
var statearr_68970_69037 = state_68943__$1;
(statearr_68970_69037[(2)] = inst_68895);

(statearr_68970_69037[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (25))){
var inst_68900 = (state_68943[(16)]);
var inst_68898 = (state_68943[(10)]);
var inst_68897 = (state_68943[(2)]);
var inst_68898__$1 = cljs.core.nth.call(null,inst_68897,(0),null);
var inst_68899 = cljs.core.nth.call(null,inst_68897,(1),null);
var inst_68900__$1 = cljs.core.pos_int_QMARK_.call(null,inst_68898__$1);
var state_68943__$1 = (function (){var statearr_68971 = state_68943;
(statearr_68971[(16)] = inst_68900__$1);

(statearr_68971[(9)] = inst_68899);

(statearr_68971[(10)] = inst_68898__$1);

return statearr_68971;
})();
if(inst_68900__$1){
var statearr_68972_69038 = state_68943__$1;
(statearr_68972_69038[(1)] = (32));

} else {
var statearr_68973_69039 = state_68943__$1;
(statearr_68973_69039[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (34))){
var inst_68905 = (state_68943[(2)]);
var inst_68906 = cljs.core.not.call(null,inst_68905);
var state_68943__$1 = state_68943;
if(inst_68906){
var statearr_68974_69040 = state_68943__$1;
(statearr_68974_69040[(1)] = (35));

} else {
var statearr_68975_69041 = state_68943__$1;
(statearr_68975_69041[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (17))){
var inst_68854 = (state_68943[(13)]);
var inst_68852 = (state_68943[(8)]);
var inst_68857 = cljs.core.pr_str.call(null,inst_68852);
var inst_68858 = cljs.core.pr_str.call(null,inst_68854);
var inst_68859 = ["Start block is out of range for this ledger. Start block provided: ",inst_68857,". Database block: ",inst_68858].join('');
var inst_68860 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68861 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_68862 = cljs.core.PersistentHashMap.fromArrays(inst_68860,inst_68861);
var inst_68863 = cljs.core.ex_info.call(null,inst_68859,inst_68862);
var inst_68864 = (function(){throw inst_68863})();
var state_68943__$1 = state_68943;
var statearr_68976_69042 = state_68943__$1;
(statearr_68976_69042[(2)] = inst_68864);

(statearr_68976_69042[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (3))){
var inst_68941 = (state_68943[(2)]);
var state_68943__$1 = state_68943;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68943__$1,inst_68941);
} else {
if((state_val_68944 === (12))){
var inst_68838 = (state_68943[(17)]);
var inst_68829 = (state_68943[(18)]);
var inst_68836 = (state_68943[(2)]);
var inst_68837 = fluree.db.util.async.throw_err.call(null,inst_68836);
var inst_68838__$1 = cljs.core.second.call(null,inst_68829);
var state_68943__$1 = (function (){var statearr_68977 = state_68943;
(statearr_68977[(12)] = inst_68837);

(statearr_68977[(17)] = inst_68838__$1);

return statearr_68977;
})();
if(cljs.core.truth_(inst_68838__$1)){
var statearr_68978_69043 = state_68943__$1;
(statearr_68978_69043[(1)] = (13));

} else {
var statearr_68979_69044 = state_68943__$1;
(statearr_68979_69044[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (2))){
var _ = (function (){var statearr_68980 = state_68943;
(statearr_68980[(4)] = cljs.core.cons.call(null,(5),(state_68943[(4)])));

return statearr_68980;
})();
var inst_68818 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_68819 = cljs.core.sequential_QMARK_.call(null,inst_68818);
var state_68943__$1 = state_68943;
if(inst_68819){
var statearr_68981_69045 = state_68943__$1;
(statearr_68981_69045[(1)] = (6));

} else {
var statearr_68982_69046 = state_68943__$1;
(statearr_68982_69046[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (23))){
var inst_68853 = (state_68943[(7)]);
var inst_68852 = (state_68943[(8)]);
var inst_68873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68874 = [inst_68852,inst_68853];
var inst_68875 = (new cljs.core.PersistentVector(null,2,(5),inst_68873,inst_68874,null));
var state_68943__$1 = state_68943;
var statearr_68983_69047 = state_68943__$1;
(statearr_68983_69047[(2)] = inst_68875);

(statearr_68983_69047[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (35))){
var inst_68829 = (state_68943[(18)]);
var inst_68908 = cljs.core.pr_str.call(null,inst_68829);
var inst_68909 = ["Invalid block range provided: ",inst_68908].join('');
var inst_68910 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68911 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_68912 = cljs.core.PersistentHashMap.fromArrays(inst_68910,inst_68911);
var inst_68913 = cljs.core.ex_info.call(null,inst_68909,inst_68912);
var inst_68914 = (function(){throw inst_68913})();
var state_68943__$1 = state_68943;
var statearr_68984_69048 = state_68943__$1;
(statearr_68984_69048[(2)] = inst_68914);

(statearr_68984_69048[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (19))){
var inst_68852 = (state_68943[(8)]);
var inst_68867 = (state_68943[(2)]);
var state_68943__$1 = (function (){var statearr_68985 = state_68943;
(statearr_68985[(19)] = inst_68867);

return statearr_68985;
})();
if(cljs.core.truth_(inst_68852)){
var statearr_68986_69049 = state_68943__$1;
(statearr_68986_69049[(1)] = (20));

} else {
var statearr_68987_69050 = state_68943__$1;
(statearr_68987_69050[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (11))){
var inst_68854 = (state_68943[(13)]);
var inst_68852 = (state_68943[(8)]);
var inst_68851 = (state_68943[(2)]);
var inst_68852__$1 = cljs.core.nth.call(null,inst_68851,(0),null);
var inst_68853 = cljs.core.nth.call(null,inst_68851,(1),null);
var inst_68854__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_68855 = (inst_68852__$1 > inst_68854__$1);
var state_68943__$1 = (function (){var statearr_68989 = state_68943;
(statearr_68989[(13)] = inst_68854__$1);

(statearr_68989[(7)] = inst_68853);

(statearr_68989[(8)] = inst_68852__$1);

return statearr_68989;
})();
if(cljs.core.truth_(inst_68855)){
var statearr_68990_69051 = state_68943__$1;
(statearr_68990_69051[(1)] = (17));

} else {
var statearr_68991_69052 = state_68943__$1;
(statearr_68991_69052[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (9))){
var inst_68829 = (state_68943[(18)]);
var inst_68832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68833 = cljs.core.first.call(null,inst_68829);
var inst_68834 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_68833);
var state_68943__$1 = (function (){var statearr_68992 = state_68943;
(statearr_68992[(11)] = inst_68832);

return statearr_68992;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68943__$1,(12),inst_68834);
} else {
if((state_val_68944 === (5))){
var _ = (function (){var statearr_68993 = state_68943;
(statearr_68993[(4)] = cljs.core.rest.call(null,(state_68943[(4)])));

return statearr_68993;
})();
var state_68943__$1 = state_68943;
var ex68988 = (state_68943__$1[(2)]);
var statearr_68994_69053 = state_68943__$1;
(statearr_68994_69053[(5)] = ex68988);


if((ex68988 instanceof Error)){
var statearr_68995_69054 = state_68943__$1;
(statearr_68995_69054[(1)] = (4));

(statearr_68995_69054[(5)] = null);

} else {
throw ex68988;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (14))){
var state_68943__$1 = state_68943;
var statearr_68996_69055 = state_68943__$1;
(statearr_68996_69055[(2)] = null);

(statearr_68996_69055[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (26))){
var inst_68852 = (state_68943[(8)]);
var inst_68878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68879 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_68880 = [inst_68852,inst_68879];
var inst_68881 = (new cljs.core.PersistentVector(null,2,(5),inst_68878,inst_68880,null));
var state_68943__$1 = state_68943;
var statearr_68997_69056 = state_68943__$1;
(statearr_68997_69056[(2)] = inst_68881);

(statearr_68997_69056[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (16))){
var inst_68842 = (state_68943[(2)]);
var inst_68843 = fluree.db.util.async.throw_err.call(null,inst_68842);
var state_68943__$1 = state_68943;
var statearr_68998_69057 = state_68943__$1;
(statearr_68998_69057[(2)] = inst_68843);

(statearr_68998_69057[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (38))){
var inst_68899 = (state_68943[(9)]);
var inst_68898 = (state_68943[(10)]);
var inst_68920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68921 = [inst_68899,inst_68898];
var inst_68922 = (new cljs.core.PersistentVector(null,2,(5),inst_68920,inst_68921,null));
var state_68943__$1 = state_68943;
var statearr_68999_69058 = state_68943__$1;
(statearr_68999_69058[(2)] = inst_68922);

(statearr_68999_69058[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (30))){
var state_68943__$1 = state_68943;
var statearr_69000_69059 = state_68943__$1;
(statearr_69000_69059[(2)] = null);

(statearr_69000_69059[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (10))){
var inst_68829 = (state_68943[(18)]);
var state_68943__$1 = state_68943;
var statearr_69001_69060 = state_68943__$1;
(statearr_69001_69060[(2)] = inst_68829);

(statearr_69001_69060[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (18))){
var state_68943__$1 = state_68943;
var statearr_69002_69061 = state_68943__$1;
(statearr_69002_69061[(2)] = null);

(statearr_69002_69061[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (42))){
var inst_68930 = (state_68943[(14)]);
var state_68943__$1 = state_68943;
var statearr_69003_69062 = state_68943__$1;
(statearr_69003_69062[(2)] = inst_68930);

(statearr_69003_69062[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (37))){
var inst_68899 = (state_68943[(9)]);
var inst_68898 = (state_68943[(10)]);
var inst_68917 = (state_68943[(2)]);
var inst_68918 = (inst_68899 < inst_68898);
var state_68943__$1 = (function (){var statearr_69004 = state_68943;
(statearr_69004[(20)] = inst_68917);

return statearr_69004;
})();
if(cljs.core.truth_(inst_68918)){
var statearr_69005_69063 = state_68943__$1;
(statearr_69005_69063[(1)] = (38));

} else {
var statearr_69006_69064 = state_68943__$1;
(statearr_69006_69064[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (8))){
var inst_68829 = (state_68943[(18)]);
var inst_68829__$1 = (state_68943[(2)]);
var inst_68830 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_68829__$1);
var state_68943__$1 = (function (){var statearr_69007 = state_68943;
(statearr_69007[(18)] = inst_68829__$1);

return statearr_69007;
})();
if(cljs.core.truth_(inst_68830)){
var statearr_69008_69065 = state_68943__$1;
(statearr_69008_69065[(1)] = (9));

} else {
var statearr_69009_69066 = state_68943__$1;
(statearr_69009_69066[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0 = (function (){
var statearr_69010 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69010[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__);

(statearr_69010[(1)] = (1));

return statearr_69010;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1 = (function (state_68943){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68943);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69011){var ex__2749__auto__ = e69011;
var statearr_69012_69067 = state_68943;
(statearr_69012_69067[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68943[(4)]))){
var statearr_69013_69068 = state_68943;
(statearr_69013_69068[(1)] = cljs.core.first.call(null,(state_68943[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69069 = state_68943;
state_68943 = G__69069;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__ = function(state_68943){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1.call(this,state_68943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69014 = f__2769__auto__.call(null);
(statearr_69014[(6)] = c__2768__auto__);

return statearr_69014;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69219){
var state_val_69220 = (state_69219[(1)]);
if((state_val_69220 === (7))){
var inst_69131 = (state_69219[(2)]);
var inst_69132 = cljs.core.nth.call(null,inst_69131,(0),null);
var inst_69133 = cljs.core.nth.call(null,inst_69131,(1),null);
var inst_69141 = cljs.core.vals.call(null,inst_69133);
var inst_69142 = cljs.core.seq.call(null,inst_69141);
var inst_69143 = cljs.core.first.call(null,inst_69142);
var inst_69144 = cljs.core.next.call(null,inst_69142);
var inst_69145 = cljs.core.PersistentVector.EMPTY;
var inst_69146 = inst_69141;
var inst_69147 = inst_69145;
var state_69219__$1 = (function (){var statearr_69221 = state_69219;
(statearr_69221[(7)] = inst_69132);

(statearr_69221[(8)] = inst_69144);

(statearr_69221[(9)] = inst_69146);

(statearr_69221[(10)] = inst_69147);

(statearr_69221[(11)] = inst_69143);

return statearr_69221;
})();
var statearr_69222_69275 = state_69219__$1;
(statearr_69222_69275[(2)] = null);

(statearr_69222_69275[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (20))){
var inst_69153 = (state_69219[(12)]);
var inst_69158 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_69159 = cljs.core.PersistentHashMap.EMPTY;
var inst_69160 = [true,inst_69159];
var inst_69161 = cljs.core.PersistentHashMap.fromArrays(inst_69158,inst_69160);
var inst_69162 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_69161,inst_69153);
var state_69219__$1 = state_69219;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69219__$1,(22),inst_69162);
} else {
if((state_val_69220 === (27))){
var inst_69207 = (state_69219[(2)]);
var state_69219__$1 = state_69219;
var statearr_69223_69276 = state_69219__$1;
(statearr_69223_69276[(2)] = inst_69207);

(statearr_69223_69276[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (1))){
var state_69219__$1 = state_69219;
var statearr_69224_69277 = state_69219__$1;
(statearr_69224_69277[(2)] = null);

(statearr_69224_69277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (24))){
var inst_69171 = (state_69219[(13)]);
var inst_69209 = (state_69219[(2)]);
var inst_69210 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_69211 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69212 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69213 = [inst_69211,inst_69212,inst_69171,inst_69209];
var inst_69214 = cljs.core.PersistentHashMap.fromArrays(inst_69210,inst_69213);
var _ = (function (){var statearr_69226 = state_69219;
(statearr_69226[(4)] = cljs.core.rest.call(null,(state_69219[(4)])));

return statearr_69226;
})();
var state_69219__$1 = state_69219;
var statearr_69227_69278 = state_69219__$1;
(statearr_69227_69278[(2)] = inst_69214);

(statearr_69227_69278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (4))){
var inst_69072 = (state_69219[(2)]);
var state_69219__$1 = state_69219;
var statearr_69228_69279 = state_69219__$1;
(statearr_69228_69279[(2)] = inst_69072);

(statearr_69228_69279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (15))){
var inst_69110 = (state_69219[(14)]);
var inst_69102 = (state_69219[(15)]);
var inst_69112 = (state_69219[(16)]);
var inst_69095 = (state_69219[(17)]);
var inst_69096 = (state_69219[(18)]);
var inst_69094 = (state_69219[(19)]);
var inst_69117 = (state_69219[(20)]);
var inst_69091 = (state_69219[(21)]);
var inst_69088 = (state_69219[(22)]);
var inst_69090 = (state_69219[(23)]);
var inst_69103 = (state_69219[(24)]);
var inst_69123 = (function (){var seq__69086 = inst_69091;
var G__69084 = inst_69094;
var subject = inst_69110;
var first__69100 = inst_69102;
var flake = inst_69102;
var first__69087 = inst_69090;
var vec__69098 = inst_69094;
var r = inst_69103;
var asserted_subjects = inst_69095;
var flake_SINGLEQUOTE_ = inst_69117;
var retracted_subjects = inst_69096;
var seq__69099 = inst_69103;
var asserted_QMARK_ = inst_69112;
var vec__69085 = inst_69088;
return (function (p1__69071_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__69071_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_69124 = cljs.core.update.call(null,inst_69096,inst_69110,inst_69123);
var tmp69225 = inst_69095;
var inst_69094__$1 = inst_69103;
var inst_69095__$1 = tmp69225;
var inst_69096__$1 = inst_69124;
var state_69219__$1 = (function (){var statearr_69229 = state_69219;
(statearr_69229[(17)] = inst_69095__$1);

(statearr_69229[(18)] = inst_69096__$1);

(statearr_69229[(19)] = inst_69094__$1);

return statearr_69229;
})();
var statearr_69230_69280 = state_69219__$1;
(statearr_69230_69280[(2)] = null);

(statearr_69230_69280[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (21))){
var inst_69169 = (state_69219[(2)]);
var state_69219__$1 = state_69219;
var statearr_69231_69281 = state_69219__$1;
(statearr_69231_69281[(2)] = inst_69169);

(statearr_69231_69281[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (13))){
var inst_69112 = (state_69219[(16)]);
var inst_69117 = (state_69219[(2)]);
var state_69219__$1 = (function (){var statearr_69232 = state_69219;
(statearr_69232[(20)] = inst_69117);

return statearr_69232;
})();
if(cljs.core.truth_(inst_69112)){
var statearr_69233_69282 = state_69219__$1;
(statearr_69233_69282[(1)] = (14));

} else {
var statearr_69234_69283 = state_69219__$1;
(statearr_69234_69283[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (22))){
var inst_69154 = (state_69219[(25)]);
var inst_69147 = (state_69219[(10)]);
var inst_69164 = (state_69219[(2)]);
var inst_69165 = fluree.db.util.async.throw_err.call(null,inst_69164);
var inst_69166 = cljs.core.conj.call(null,inst_69147,inst_69165);
var inst_69146 = inst_69154;
var inst_69147__$1 = inst_69166;
var state_69219__$1 = (function (){var statearr_69235 = state_69219;
(statearr_69235[(9)] = inst_69146);

(statearr_69235[(10)] = inst_69147__$1);

return statearr_69235;
})();
var statearr_69236_69284 = state_69219__$1;
(statearr_69236_69284[(2)] = null);

(statearr_69236_69284[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (6))){
var inst_69102 = (state_69219[(15)]);
var inst_69094 = (state_69219[(19)]);
var inst_69101 = cljs.core.seq.call(null,inst_69094);
var inst_69102__$1 = cljs.core.first.call(null,inst_69101);
var inst_69103 = cljs.core.next.call(null,inst_69101);
var inst_69104 = cljs.core.not.call(null,inst_69102__$1);
var state_69219__$1 = (function (){var statearr_69237 = state_69219;
(statearr_69237[(15)] = inst_69102__$1);

(statearr_69237[(24)] = inst_69103);

return statearr_69237;
})();
if(inst_69104){
var statearr_69238_69285 = state_69219__$1;
(statearr_69238_69285[(1)] = (8));

} else {
var statearr_69239_69286 = state_69219__$1;
(statearr_69239_69286[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (28))){
var inst_69192 = (state_69219[(26)]);
var inst_69185 = (state_69219[(27)]);
var inst_69202 = (state_69219[(2)]);
var inst_69203 = fluree.db.util.async.throw_err.call(null,inst_69202);
var inst_69204 = cljs.core.conj.call(null,inst_69185,inst_69203);
var inst_69184 = inst_69192;
var inst_69185__$1 = inst_69204;
var state_69219__$1 = (function (){var statearr_69240 = state_69219;
(statearr_69240[(28)] = inst_69184);

(statearr_69240[(27)] = inst_69185__$1);

return statearr_69240;
})();
var statearr_69241_69287 = state_69219__$1;
(statearr_69241_69287[(2)] = null);

(statearr_69241_69287[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (25))){
var inst_69185 = (state_69219[(27)]);
var state_69219__$1 = state_69219;
var statearr_69242_69288 = state_69219__$1;
(statearr_69242_69288[(2)] = inst_69185);

(statearr_69242_69288[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (17))){
var inst_69146 = (state_69219[(9)]);
var inst_69153 = (state_69219[(12)]);
var inst_69152 = cljs.core.seq.call(null,inst_69146);
var inst_69153__$1 = cljs.core.first.call(null,inst_69152);
var inst_69154 = cljs.core.next.call(null,inst_69152);
var inst_69155 = cljs.core.not.call(null,inst_69153__$1);
var state_69219__$1 = (function (){var statearr_69243 = state_69219;
(statearr_69243[(25)] = inst_69154);

(statearr_69243[(12)] = inst_69153__$1);

return statearr_69243;
})();
if(inst_69155){
var statearr_69244_69289 = state_69219__$1;
(statearr_69244_69289[(1)] = (19));

} else {
var statearr_69245_69290 = state_69219__$1;
(statearr_69245_69290[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (3))){
var inst_69217 = (state_69219[(2)]);
var state_69219__$1 = state_69219;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69219__$1,inst_69217);
} else {
if((state_val_69220 === (12))){
var inst_69102 = (state_69219[(15)]);
var inst_69115 = fluree.db.flake.flip_flake.call(null,inst_69102);
var state_69219__$1 = state_69219;
var statearr_69246_69291 = state_69219__$1;
(statearr_69246_69291[(2)] = inst_69115);

(statearr_69246_69291[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (2))){
var inst_69088 = (state_69219[(22)]);
var _ = (function (){var statearr_69247 = state_69219;
(statearr_69247[(4)] = cljs.core.cons.call(null,(5),(state_69219[(4)])));

return statearr_69247;
})();
var inst_69088__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69089 = cljs.core.seq.call(null,inst_69088__$1);
var inst_69090 = cljs.core.first.call(null,inst_69089);
var inst_69091 = cljs.core.next.call(null,inst_69089);
var inst_69092 = cljs.core.PersistentHashMap.EMPTY;
var inst_69093 = cljs.core.PersistentHashMap.EMPTY;
var inst_69094 = inst_69088__$1;
var inst_69095 = inst_69092;
var inst_69096 = inst_69093;
var state_69219__$1 = (function (){var statearr_69248 = state_69219;
(statearr_69248[(17)] = inst_69095);

(statearr_69248[(18)] = inst_69096);

(statearr_69248[(19)] = inst_69094);

(statearr_69248[(21)] = inst_69091);

(statearr_69248[(22)] = inst_69088__$1);

(statearr_69248[(23)] = inst_69090);

return statearr_69248;
})();
var statearr_69249_69292 = state_69219__$1;
(statearr_69249_69292[(2)] = null);

(statearr_69249_69292[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (23))){
var inst_69184 = (state_69219[(28)]);
var inst_69191 = (state_69219[(29)]);
var inst_69190 = cljs.core.seq.call(null,inst_69184);
var inst_69191__$1 = cljs.core.first.call(null,inst_69190);
var inst_69192 = cljs.core.next.call(null,inst_69190);
var inst_69193 = cljs.core.not.call(null,inst_69191__$1);
var state_69219__$1 = (function (){var statearr_69250 = state_69219;
(statearr_69250[(26)] = inst_69192);

(statearr_69250[(29)] = inst_69191__$1);

return statearr_69250;
})();
if(inst_69193){
var statearr_69251_69293 = state_69219__$1;
(statearr_69251_69293[(1)] = (25));

} else {
var statearr_69252_69294 = state_69219__$1;
(statearr_69252_69294[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (19))){
var inst_69147 = (state_69219[(10)]);
var state_69219__$1 = state_69219;
var statearr_69253_69295 = state_69219__$1;
(statearr_69253_69295[(2)] = inst_69147);

(statearr_69253_69295[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (11))){
var inst_69102 = (state_69219[(15)]);
var state_69219__$1 = state_69219;
var statearr_69255_69296 = state_69219__$1;
(statearr_69255_69296[(2)] = inst_69102);

(statearr_69255_69296[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (9))){
var inst_69102 = (state_69219[(15)]);
var inst_69112 = (state_69219[(16)]);
var inst_69110 = fluree.db.flake.s.call(null,inst_69102);
var inst_69111 = fluree.db.flake.op.call(null,inst_69102);
var inst_69112__$1 = inst_69111 === true;
var state_69219__$1 = (function (){var statearr_69257 = state_69219;
(statearr_69257[(14)] = inst_69110);

(statearr_69257[(16)] = inst_69112__$1);

return statearr_69257;
})();
if(cljs.core.truth_(inst_69112__$1)){
var statearr_69258_69297 = state_69219__$1;
(statearr_69258_69297[(1)] = (11));

} else {
var statearr_69259_69298 = state_69219__$1;
(statearr_69259_69298[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (5))){
var _ = (function (){var statearr_69260 = state_69219;
(statearr_69260[(4)] = cljs.core.rest.call(null,(state_69219[(4)])));

return statearr_69260;
})();
var state_69219__$1 = state_69219;
var ex69254 = (state_69219__$1[(2)]);
var statearr_69261_69299 = state_69219__$1;
(statearr_69261_69299[(5)] = ex69254);


if((ex69254 instanceof Error)){
var statearr_69262_69300 = state_69219__$1;
(statearr_69262_69300[(1)] = (4));

(statearr_69262_69300[(5)] = null);

} else {
throw ex69254;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (14))){
var inst_69110 = (state_69219[(14)]);
var inst_69102 = (state_69219[(15)]);
var inst_69112 = (state_69219[(16)]);
var inst_69095 = (state_69219[(17)]);
var inst_69096 = (state_69219[(18)]);
var inst_69094 = (state_69219[(19)]);
var inst_69117 = (state_69219[(20)]);
var inst_69091 = (state_69219[(21)]);
var inst_69088 = (state_69219[(22)]);
var inst_69090 = (state_69219[(23)]);
var inst_69103 = (state_69219[(24)]);
var inst_69119 = (function (){var seq__69086 = inst_69091;
var G__69084 = inst_69094;
var subject = inst_69110;
var first__69100 = inst_69102;
var flake = inst_69102;
var first__69087 = inst_69090;
var vec__69098 = inst_69094;
var r = inst_69103;
var asserted_subjects = inst_69095;
var flake_SINGLEQUOTE_ = inst_69117;
var retracted_subjects = inst_69096;
var seq__69099 = inst_69103;
var asserted_QMARK_ = inst_69112;
var vec__69085 = inst_69088;
return (function (p1__69070_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__69070_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_69120 = cljs.core.update.call(null,inst_69095,inst_69110,inst_69119);
var tmp69256 = inst_69096;
var inst_69094__$1 = inst_69103;
var inst_69095__$1 = inst_69120;
var inst_69096__$1 = tmp69256;
var state_69219__$1 = (function (){var statearr_69263 = state_69219;
(statearr_69263[(17)] = inst_69095__$1);

(statearr_69263[(18)] = inst_69096__$1);

(statearr_69263[(19)] = inst_69094__$1);

return statearr_69263;
})();
var statearr_69264_69301 = state_69219__$1;
(statearr_69264_69301[(2)] = null);

(statearr_69264_69301[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (26))){
var inst_69191 = (state_69219[(29)]);
var inst_69196 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_69197 = cljs.core.PersistentHashMap.EMPTY;
var inst_69198 = [true,inst_69197];
var inst_69199 = cljs.core.PersistentHashMap.fromArrays(inst_69196,inst_69198);
var inst_69200 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_69199,inst_69191);
var state_69219__$1 = state_69219;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69219__$1,(28),inst_69200);
} else {
if((state_val_69220 === (16))){
var inst_69127 = (state_69219[(2)]);
var state_69219__$1 = state_69219;
var statearr_69265_69302 = state_69219__$1;
(statearr_69265_69302[(2)] = inst_69127);

(statearr_69265_69302[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (10))){
var inst_69129 = (state_69219[(2)]);
var state_69219__$1 = state_69219;
var statearr_69266_69303 = state_69219__$1;
(statearr_69266_69303[(2)] = inst_69129);

(statearr_69266_69303[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (18))){
var inst_69132 = (state_69219[(7)]);
var inst_69171 = (state_69219[(2)]);
var inst_69179 = cljs.core.vals.call(null,inst_69132);
var inst_69180 = cljs.core.seq.call(null,inst_69179);
var inst_69181 = cljs.core.first.call(null,inst_69180);
var inst_69182 = cljs.core.next.call(null,inst_69180);
var inst_69183 = cljs.core.PersistentVector.EMPTY;
var inst_69184 = inst_69179;
var inst_69185 = inst_69183;
var state_69219__$1 = (function (){var statearr_69267 = state_69219;
(statearr_69267[(30)] = inst_69182);

(statearr_69267[(28)] = inst_69184);

(statearr_69267[(13)] = inst_69171);

(statearr_69267[(31)] = inst_69181);

(statearr_69267[(27)] = inst_69185);

return statearr_69267;
})();
var statearr_69268_69304 = state_69219__$1;
(statearr_69268_69304[(2)] = null);

(statearr_69268_69304[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69220 === (8))){
var inst_69095 = (state_69219[(17)]);
var inst_69096 = (state_69219[(18)]);
var inst_69106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69107 = [inst_69095,inst_69096];
var inst_69108 = (new cljs.core.PersistentVector(null,2,(5),inst_69106,inst_69107,null));
var state_69219__$1 = state_69219;
var statearr_69269_69305 = state_69219__$1;
(statearr_69269_69305[(2)] = inst_69108);

(statearr_69269_69305[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_69270 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69270[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__);

(statearr_69270[(1)] = (1));

return statearr_69270;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1 = (function (state_69219){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69219);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69271){var ex__2749__auto__ = e69271;
var statearr_69272_69306 = state_69219;
(statearr_69272_69306[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69219[(4)]))){
var statearr_69273_69307 = state_69219;
(statearr_69273_69307[(1)] = cljs.core.first.call(null,(state_69219[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69308 = state_69219;
state_69219 = G__69308;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__ = function(state_69219){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1.call(this,state_69219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69274 = f__2769__auto__.call(null);
(statearr_69274[(6)] = c__2768__auto__);

return statearr_69274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69340){
var state_val_69341 = (state_69340[(1)]);
if((state_val_69341 === (1))){
var inst_69309 = cljs.core.volatile_BANG_.call(null,(0));
var inst_69310 = cljs.core.PersistentHashMap.EMPTY;
var inst_69311 = cljs.core.volatile_BANG_.call(null,inst_69310);
var inst_69312 = cljs.core.first.call(null,resp);
var inst_69313 = cljs.core.rest.call(null,resp);
var inst_69314 = cljs.core.PersistentVector.EMPTY;
var inst_69315 = inst_69309;
var inst_69316 = inst_69311;
var inst_69317 = inst_69312;
var inst_69318 = inst_69313;
var inst_69319 = inst_69314;
var state_69340__$1 = (function (){var statearr_69342 = state_69340;
(statearr_69342[(7)] = inst_69316);

(statearr_69342[(8)] = inst_69317);

(statearr_69342[(9)] = inst_69315);

(statearr_69342[(10)] = inst_69319);

(statearr_69342[(11)] = inst_69318);

return statearr_69342;
})();
var statearr_69343_69358 = state_69340__$1;
(statearr_69343_69358[(2)] = null);

(statearr_69343_69358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69341 === (2))){
var inst_69316 = (state_69340[(7)]);
var inst_69317 = (state_69340[(8)]);
var inst_69315 = (state_69340[(9)]);
var inst_69321 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_69317,inst_69316,inst_69315);
var state_69340__$1 = state_69340;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69340__$1,(4),inst_69321);
} else {
if((state_val_69341 === (3))){
var inst_69338 = (state_69340[(2)]);
var state_69340__$1 = state_69340;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69340__$1,inst_69338);
} else {
if((state_val_69341 === (4))){
var inst_69319 = (state_69340[(10)]);
var inst_69318 = (state_69340[(11)]);
var inst_69323 = (state_69340[(2)]);
var inst_69324 = fluree.db.util.async.throw_err.call(null,inst_69323);
var inst_69325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69326 = [inst_69324];
var inst_69327 = (new cljs.core.PersistentVector(null,1,(5),inst_69325,inst_69326,null));
var inst_69328 = cljs.core.concat.call(null,inst_69319,inst_69327);
var inst_69329 = cljs.core.first.call(null,inst_69318);
var state_69340__$1 = (function (){var statearr_69346 = state_69340;
(statearr_69346[(12)] = inst_69328);

return statearr_69346;
})();
if(cljs.core.truth_(inst_69329)){
var statearr_69347_69359 = state_69340__$1;
(statearr_69347_69359[(1)] = (5));

} else {
var statearr_69348_69360 = state_69340__$1;
(statearr_69348_69360[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69341 === (5))){
var inst_69316 = (state_69340[(7)]);
var inst_69315 = (state_69340[(9)]);
var inst_69318 = (state_69340[(11)]);
var inst_69328 = (state_69340[(12)]);
var inst_69331 = cljs.core.first.call(null,inst_69318);
var inst_69332 = cljs.core.rest.call(null,inst_69318);
var tmp69344 = inst_69316;
var tmp69345 = inst_69315;
var inst_69315__$1 = tmp69345;
var inst_69316__$1 = tmp69344;
var inst_69317 = inst_69331;
var inst_69318__$1 = inst_69332;
var inst_69319 = inst_69328;
var state_69340__$1 = (function (){var statearr_69349 = state_69340;
(statearr_69349[(7)] = inst_69316__$1);

(statearr_69349[(8)] = inst_69317);

(statearr_69349[(9)] = inst_69315__$1);

(statearr_69349[(10)] = inst_69319);

(statearr_69349[(11)] = inst_69318__$1);

return statearr_69349;
})();
var statearr_69350_69361 = state_69340__$1;
(statearr_69350_69361[(2)] = null);

(statearr_69350_69361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69341 === (6))){
var inst_69328 = (state_69340[(12)]);
var state_69340__$1 = state_69340;
var statearr_69351_69362 = state_69340__$1;
(statearr_69351_69362[(2)] = inst_69328);

(statearr_69351_69362[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69341 === (7))){
var inst_69336 = (state_69340[(2)]);
var state_69340__$1 = state_69340;
var statearr_69352_69363 = state_69340__$1;
(statearr_69352_69363[(2)] = inst_69336);

(statearr_69352_69363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_69353 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69353[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__);

(statearr_69353[(1)] = (1));

return statearr_69353;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1 = (function (state_69340){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69340);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69354){var ex__2749__auto__ = e69354;
var statearr_69355_69364 = state_69340;
(statearr_69355_69364[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69340[(4)]))){
var statearr_69356_69365 = state_69340;
(statearr_69356_69365[(1)] = cljs.core.first.call(null,(state_69340[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69366 = state_69340;
state_69340 = G__69366;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__ = function(state_69340){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1.call(this,state_69340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69357 = f__2769__auto__.call(null);
(statearr_69357[(6)] = c__2768__auto__);

return statearr_69357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__69368 = arguments.length;
switch (G__69368) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__69370){
var map__69371 = p__69370;
var map__69371__$1 = cljs.core.__destructure_map.call(null,map__69371);
var query = map__69371__$1;
var opts = cljs.core.get.call(null,map__69371__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69456){
var state_val_69457 = (state_69456[(1)]);
if((state_val_69457 === (7))){
var inst_69382 = (state_69456[(7)]);
var inst_69386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69387 = ["_auth/id",inst_69382];
var inst_69388 = (new cljs.core.PersistentVector(null,2,(5),inst_69386,inst_69387,null));
var state_69456__$1 = state_69456;
var statearr_69458_69502 = state_69456__$1;
(statearr_69458_69502[(2)] = inst_69388);

(statearr_69458_69502[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (20))){
var inst_69436 = (state_69456[(2)]);
var inst_69437 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_69456__$1 = (function (){var statearr_69459 = state_69456;
(statearr_69459[(8)] = inst_69436);

return statearr_69459;
})();
if(cljs.core.truth_(inst_69437)){
var statearr_69460_69503 = state_69456__$1;
(statearr_69460_69503[(1)] = (22));

} else {
var statearr_69461_69504 = state_69456__$1;
(statearr_69461_69504[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (27))){
var inst_69439 = (state_69456[(9)]);
var inst_69383 = (state_69456[(10)]);
var inst_69445 = (state_69456[(2)]);
var inst_69446 = fluree.db.util.core.response_time_formatted.call(null,inst_69383);
var inst_69447 = [(200),inst_69445,(100),inst_69446];
var inst_69448 = cljs.core.PersistentHashMap.fromArrays(inst_69439,inst_69447);
var state_69456__$1 = state_69456;
var statearr_69462_69505 = state_69456__$1;
(statearr_69462_69505[(2)] = inst_69448);

(statearr_69462_69505[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (1))){
var state_69456__$1 = state_69456;
var statearr_69463_69506 = state_69456__$1;
(statearr_69463_69506[(2)] = null);

(statearr_69463_69506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (24))){
var inst_69451 = (state_69456[(2)]);
var _ = (function (){var statearr_69464 = state_69456;
(statearr_69464[(4)] = cljs.core.rest.call(null,(state_69456[(4)])));

return statearr_69464;
})();
var state_69456__$1 = state_69456;
var statearr_69465_69507 = state_69456__$1;
(statearr_69465_69507[(2)] = inst_69451);

(statearr_69465_69507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (4))){
var inst_69372 = (state_69456[(2)]);
var state_69456__$1 = state_69456;
var statearr_69466_69508 = state_69456__$1;
(statearr_69466_69508[(2)] = inst_69372);

(statearr_69466_69508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (15))){
var inst_69423 = (state_69456[(11)]);
var state_69456__$1 = state_69456;
var statearr_69467_69509 = state_69456__$1;
(statearr_69467_69509[(2)] = inst_69423);

(statearr_69467_69509[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (21))){
var inst_69432 = (state_69456[(2)]);
var inst_69433 = fluree.db.util.async.throw_err.call(null,inst_69432);
var state_69456__$1 = state_69456;
var statearr_69468_69510 = state_69456__$1;
(statearr_69468_69510[(2)] = inst_69433);

(statearr_69468_69510[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (13))){
var inst_69423 = (state_69456[(11)]);
var inst_69381 = (state_69456[(12)]);
var inst_69422 = (state_69456[(2)]);
var inst_69423__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_69381);
var state_69456__$1 = (function (){var statearr_69469 = state_69456;
(statearr_69469[(13)] = inst_69422);

(statearr_69469[(11)] = inst_69423__$1);

return statearr_69469;
})();
if(cljs.core.truth_(inst_69423__$1)){
var statearr_69470_69511 = state_69456__$1;
(statearr_69470_69511[(1)] = (15));

} else {
var statearr_69471_69512 = state_69456__$1;
(statearr_69471_69512[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (22))){
var inst_69436 = (state_69456[(8)]);
var inst_69439 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_69440 = cljs.core.sequential_QMARK_.call(null,inst_69436);
var state_69456__$1 = (function (){var statearr_69472 = state_69456;
(statearr_69472[(9)] = inst_69439);

return statearr_69472;
})();
if(inst_69440){
var statearr_69473_69513 = state_69456__$1;
(statearr_69473_69513[(1)] = (25));

} else {
var statearr_69474_69514 = state_69456__$1;
(statearr_69474_69514[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (6))){
var inst_69381 = (state_69456[(12)]);
var inst_69397 = (state_69456[(14)]);
var inst_69396 = (state_69456[(2)]);
var inst_69397__$1 = fluree.db.util.async.throw_err.call(null,inst_69396);
var inst_69398 = fluree.db.api.query.resolve_block_range.call(null,inst_69397__$1,inst_69381);
var state_69456__$1 = (function (){var statearr_69475 = state_69456;
(statearr_69475[(14)] = inst_69397__$1);

return statearr_69475;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69456__$1,(10),inst_69398);
} else {
if((state_val_69457 === (25))){
var inst_69436 = (state_69456[(8)]);
var inst_69442 = cljs.core.doall.call(null,inst_69436);
var state_69456__$1 = state_69456;
var statearr_69476_69515 = state_69456__$1;
(statearr_69476_69515[(2)] = inst_69442);

(statearr_69476_69515[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (17))){
var inst_69428 = (state_69456[(2)]);
var state_69456__$1 = state_69456;
if(cljs.core.truth_(inst_69428)){
var statearr_69477_69516 = state_69456__$1;
(statearr_69477_69516[(1)] = (18));

} else {
var statearr_69478_69517 = state_69456__$1;
(statearr_69478_69517[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (3))){
var inst_69454 = (state_69456[(2)]);
var state_69456__$1 = state_69456;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69456__$1,inst_69454);
} else {
if((state_val_69457 === (12))){
var inst_69381 = (state_69456[(12)]);
var inst_69414 = cljs.core.pr_str.call(null,inst_69381);
var inst_69415 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_69414].join('');
var inst_69416 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69417 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69418 = cljs.core.PersistentHashMap.fromArrays(inst_69416,inst_69417);
var inst_69419 = cljs.core.ex_info.call(null,inst_69415,inst_69418);
var inst_69420 = (function(){throw inst_69419})();
var state_69456__$1 = state_69456;
var statearr_69479_69518 = state_69456__$1;
(statearr_69479_69518[(2)] = inst_69420);

(statearr_69479_69518[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (2))){
var inst_69382 = (state_69456[(7)]);
var _ = (function (){var statearr_69480 = state_69456;
(statearr_69480[(4)] = cljs.core.cons.call(null,(5),(state_69456[(4)])));

return statearr_69480;
})();
var inst_69381 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_69382__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_69383 = fluree.db.util.core.current_time_millis.call(null);
var inst_69384 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_69456__$1 = (function (){var statearr_69481 = state_69456;
(statearr_69481[(15)] = inst_69384);

(statearr_69481[(12)] = inst_69381);

(statearr_69481[(7)] = inst_69382__$1);

(statearr_69481[(10)] = inst_69383);

return statearr_69481;
})();
if(cljs.core.truth_(inst_69382__$1)){
var statearr_69482_69519 = state_69456__$1;
(statearr_69482_69519[(1)] = (7));

} else {
var statearr_69483_69520 = state_69456__$1;
(statearr_69483_69520[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (23))){
var inst_69436 = (state_69456[(8)]);
var state_69456__$1 = state_69456;
var statearr_69484_69521 = state_69456__$1;
(statearr_69484_69521[(2)] = inst_69436);

(statearr_69484_69521[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (19))){
var inst_69422 = (state_69456[(13)]);
var state_69456__$1 = state_69456;
var statearr_69485_69522 = state_69456__$1;
(statearr_69485_69522[(2)] = inst_69422);

(statearr_69485_69522[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (11))){
var inst_69403 = (state_69456[(16)]);
var inst_69402 = (state_69456[(17)]);
var inst_69397 = (state_69456[(14)]);
var inst_69409 = fluree.db.api.query.block_range.call(null,inst_69397,inst_69402,inst_69403,opts);
var state_69456__$1 = state_69456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69456__$1,(14),inst_69409);
} else {
if((state_val_69457 === (9))){
var inst_69384 = (state_69456[(15)]);
var inst_69391 = (state_69456[(2)]);
var inst_69392 = [inst_69391];
var inst_69393 = cljs.core.PersistentHashMap.fromArrays(inst_69384,inst_69392);
var inst_69394 = fluree.db.api.query.db.call(null,conn,ledger,inst_69393);
var state_69456__$1 = state_69456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69456__$1,(6),inst_69394);
} else {
if((state_val_69457 === (5))){
var _ = (function (){var statearr_69487 = state_69456;
(statearr_69487[(4)] = cljs.core.rest.call(null,(state_69456[(4)])));

return statearr_69487;
})();
var state_69456__$1 = state_69456;
var ex69486 = (state_69456__$1[(2)]);
var statearr_69488_69523 = state_69456__$1;
(statearr_69488_69523[(5)] = ex69486);


if((ex69486 instanceof Error)){
var statearr_69489_69524 = state_69456__$1;
(statearr_69489_69524[(1)] = (4));

(statearr_69489_69524[(5)] = null);

} else {
throw ex69486;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (14))){
var inst_69411 = (state_69456[(2)]);
var inst_69412 = fluree.db.util.async.throw_err.call(null,inst_69411);
var state_69456__$1 = state_69456;
var statearr_69490_69525 = state_69456__$1;
(statearr_69490_69525[(2)] = inst_69412);

(statearr_69490_69525[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (26))){
var inst_69436 = (state_69456[(8)]);
var state_69456__$1 = state_69456;
var statearr_69491_69526 = state_69456__$1;
(statearr_69491_69526[(2)] = inst_69436);

(statearr_69491_69526[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (16))){
var inst_69381 = (state_69456[(12)]);
var inst_69426 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_69381);
var state_69456__$1 = state_69456;
var statearr_69492_69527 = state_69456__$1;
(statearr_69492_69527[(2)] = inst_69426);

(statearr_69492_69527[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (10))){
var inst_69381 = (state_69456[(12)]);
var inst_69400 = (state_69456[(2)]);
var inst_69401 = fluree.db.util.async.throw_err.call(null,inst_69400);
var inst_69402 = cljs.core.nth.call(null,inst_69401,(0),null);
var inst_69403 = cljs.core.nth.call(null,inst_69401,(1),null);
var inst_69404 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_69405 = cljs.core.dissoc.call(null,inst_69381,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_69406 = cljs.core.keys.call(null,inst_69405);
var inst_69407 = cljs.core._EQ_.call(null,inst_69404,inst_69406);
var state_69456__$1 = (function (){var statearr_69493 = state_69456;
(statearr_69493[(16)] = inst_69403);

(statearr_69493[(17)] = inst_69402);

return statearr_69493;
})();
if(inst_69407){
var statearr_69494_69528 = state_69456__$1;
(statearr_69494_69528[(1)] = (11));

} else {
var statearr_69495_69529 = state_69456__$1;
(statearr_69495_69529[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69457 === (18))){
var inst_69422 = (state_69456[(13)]);
var inst_69397 = (state_69456[(14)]);
var inst_69430 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_69397,inst_69422);
var state_69456__$1 = state_69456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69456__$1,(21),inst_69430);
} else {
if((state_val_69457 === (8))){
var state_69456__$1 = state_69456;
var statearr_69496_69530 = state_69456__$1;
(statearr_69496_69530[(2)] = null);

(statearr_69496_69530[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_69497 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69497[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2746__auto__);

(statearr_69497[(1)] = (1));

return statearr_69497;
});
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1 = (function (state_69456){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69456);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69498){var ex__2749__auto__ = e69498;
var statearr_69499_69531 = state_69456;
(statearr_69499_69531[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69456[(4)]))){
var statearr_69500_69532 = state_69456;
(statearr_69500_69532[(1)] = cljs.core.first.call(null,(state_69456[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69533 = state_69456;
state_69456 = G__69533;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__ = function(state_69456){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1.call(this,state_69456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69501 = f__2769__auto__.call(null);
(statearr_69501[(6)] = c__2768__auto__);

return statearr_69501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__69534 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__69534,(0),null);
var p = cljs.core.nth.call(null,vec__69534,(1),null);
var o = cljs.core.nth.call(null,vec__69534,(2),null);
var t = cljs.core.nth.call(null,vec__69534,(3),null);
var vec__69537 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__69537,(0),null);
var idx = cljs.core.nth.call(null,vec__69537,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__69540 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t.call(null,flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__69540,(0),null);
var id = cljs.core.nth.call(null,vec__69540,(1),null);
var or__4253__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69544 = arguments.length;
var i__4865__auto___69545 = (0);
while(true){
if((i__4865__auto___69545 < len__4864__auto___69544)){
args__4870__auto__.push((arguments[i__4865__auto___69545]));

var G__69546 = (i__4865__auto___69545 + (1));
i__4865__auto___69545 = G__69546;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq69543){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq69543));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69742){
var state_val_69743 = (state_69742[(1)]);
if((state_val_69743 === (7))){
var inst_69662 = (state_69742[(7)]);
var inst_69669 = (state_69742[(8)]);
var inst_69668 = cljs.core.seq.call(null,inst_69662);
var inst_69669__$1 = cljs.core.first.call(null,inst_69668);
var inst_69670 = cljs.core.next.call(null,inst_69668);
var state_69742__$1 = (function (){var statearr_69744 = state_69742;
(statearr_69744[(9)] = inst_69670);

(statearr_69744[(8)] = inst_69669__$1);

return statearr_69744;
})();
if(cljs.core.truth_(inst_69669__$1)){
var statearr_69745_69845 = state_69742__$1;
(statearr_69745_69845[(1)] = (9));

} else {
var statearr_69746_69846 = state_69742__$1;
(statearr_69746_69846[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (20))){
var inst_69732 = (state_69742[(2)]);
var state_69742__$1 = state_69742;
var statearr_69747_69847 = state_69742__$1;
(statearr_69747_69847[(2)] = inst_69732);

(statearr_69747_69847[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (27))){
var inst_69708 = (state_69742[(10)]);
var inst_69687 = (state_69742[(11)]);
var inst_69690 = (state_69742[(12)]);
var inst_69710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69711 = [inst_69690,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_69712 = (new cljs.core.PersistentVector(null,2,(5),inst_69710,inst_69711,null));
var inst_69713 = cljs.core.update_in.call(null,inst_69708,inst_69712,fluree.db.api.query.min_safe,inst_69687);
var state_69742__$1 = state_69742;
var statearr_69748_69848 = state_69742__$1;
(statearr_69748_69848[(2)] = inst_69713);

(statearr_69748_69848[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (1))){
var state_69742__$1 = state_69742;
var statearr_69749_69849 = state_69742__$1;
(statearr_69749_69849[(2)] = null);

(statearr_69749_69849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (24))){
var inst_69669 = (state_69742[(8)]);
var inst_69700 = (state_69742[(13)]);
var inst_69690 = (state_69742[(12)]);
var inst_69702 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69703 = [inst_69690,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_69704 = (new cljs.core.PersistentVector(null,2,(5),inst_69702,inst_69703,null));
var inst_69705 = cljs.core.update_in.call(null,inst_69700,inst_69704,cljs.core.conj,inst_69669);
var state_69742__$1 = state_69742;
var statearr_69751_69850 = state_69742__$1;
(statearr_69751_69850[(2)] = inst_69705);

(statearr_69751_69850[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (4))){
var inst_69548 = (state_69742[(2)]);
var state_69742__$1 = state_69742;
var statearr_69752_69851 = state_69742__$1;
(statearr_69752_69851[(2)] = inst_69548);

(statearr_69752_69851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (15))){
var inst_69663 = (state_69742[(14)]);
var inst_69670 = (state_69742[(9)]);
var tmp69750 = inst_69663;
var inst_69662 = inst_69670;
var inst_69663__$1 = tmp69750;
var state_69742__$1 = (function (){var statearr_69753 = state_69742;
(statearr_69753[(14)] = inst_69663__$1);

(statearr_69753[(7)] = inst_69662);

return statearr_69753;
})();
var statearr_69754_69852 = state_69742__$1;
(statearr_69754_69852[(2)] = null);

(statearr_69754_69852[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (21))){
var inst_69663 = (state_69742[(14)]);
var inst_69690 = (state_69742[(12)]);
var inst_69694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69695 = [inst_69690,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_69696 = (new cljs.core.PersistentVector(null,2,(5),inst_69694,inst_69695,null));
var inst_69697 = cljs.core.assoc_in.call(null,inst_69663,inst_69696,inst_69690);
var state_69742__$1 = state_69742;
var statearr_69755_69853 = state_69742__$1;
(statearr_69755_69853[(2)] = inst_69697);

(statearr_69755_69853[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (31))){
var inst_69716 = (state_69742[(15)]);
var state_69742__$1 = state_69742;
var statearr_69756_69854 = state_69742__$1;
(statearr_69756_69854[(2)] = inst_69716);

(statearr_69756_69854[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (32))){
var inst_69670 = (state_69742[(9)]);
var inst_69724 = (state_69742[(2)]);
var inst_69662 = inst_69670;
var inst_69663 = inst_69724;
var state_69742__$1 = (function (){var statearr_69757 = state_69742;
(statearr_69757[(14)] = inst_69663);

(statearr_69757[(7)] = inst_69662);

return statearr_69757;
})();
var statearr_69758_69855 = state_69742__$1;
(statearr_69758_69855[(2)] = null);

(statearr_69758_69855[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (33))){
var inst_69663 = (state_69742[(14)]);
var state_69742__$1 = state_69742;
var statearr_69759_69856 = state_69742__$1;
(statearr_69759_69856[(2)] = inst_69663);

(statearr_69759_69856[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (13))){
var inst_69672 = (state_69742[(16)]);
var state_69742__$1 = state_69742;
var statearr_69760_69857 = state_69742__$1;
(statearr_69760_69857[(2)] = inst_69672);

(statearr_69760_69857[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (22))){
var inst_69663 = (state_69742[(14)]);
var state_69742__$1 = state_69742;
var statearr_69761_69858 = state_69742__$1;
(statearr_69761_69858[(2)] = inst_69663);

(statearr_69761_69858[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (29))){
var inst_69716 = (state_69742[(2)]);
var state_69742__$1 = (function (){var statearr_69762 = state_69742;
(statearr_69762[(15)] = inst_69716);

return statearr_69762;
})();
if(cljs.core.truth_(show_auth)){
var statearr_69763_69859 = state_69742__$1;
(statearr_69763_69859[(1)] = (30));

} else {
var statearr_69764_69860 = state_69742__$1;
(statearr_69764_69860[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (6))){
var inst_69648 = (state_69742[(2)]);
var inst_69649 = fluree.db.util.async.throw_err.call(null,inst_69648);
var inst_69657 = resp;
var inst_69658 = cljs.core.seq.call(null,inst_69657);
var inst_69659 = cljs.core.first.call(null,inst_69658);
var inst_69660 = cljs.core.next.call(null,inst_69658);
var inst_69661 = cljs.core.PersistentHashMap.EMPTY;
var inst_69662 = inst_69657;
var inst_69663 = inst_69661;
var state_69742__$1 = (function (){var statearr_69765 = state_69742;
(statearr_69765[(14)] = inst_69663);

(statearr_69765[(7)] = inst_69662);

(statearr_69765[(17)] = inst_69659);

(statearr_69765[(18)] = inst_69660);

(statearr_69765[(19)] = inst_69649);

return statearr_69765;
})();
var statearr_69766_69861 = state_69742__$1;
(statearr_69766_69861[(2)] = null);

(statearr_69766_69861[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (28))){
var inst_69708 = (state_69742[(10)]);
var state_69742__$1 = state_69742;
var statearr_69767_69862 = state_69742__$1;
(statearr_69767_69862[(2)] = inst_69708);

(statearr_69767_69862[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (25))){
var inst_69700 = (state_69742[(13)]);
var state_69742__$1 = state_69742;
var statearr_69768_69863 = state_69742__$1;
(statearr_69768_69863[(2)] = inst_69700);

(statearr_69768_69863[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (34))){
var state_69742__$1 = state_69742;
var statearr_69769_69864 = state_69742__$1;
(statearr_69769_69864[(2)] = null);

(statearr_69769_69864[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (17))){
var inst_69734 = (state_69742[(2)]);
var state_69742__$1 = state_69742;
var statearr_69770_69865 = state_69742__$1;
(statearr_69770_69865[(2)] = inst_69734);

(statearr_69770_69865[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (3))){
var inst_69740 = (state_69742[(2)]);
var state_69742__$1 = state_69742;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69742__$1,inst_69740);
} else {
if((state_val_69743 === (12))){
var inst_69669 = (state_69742[(8)]);
var inst_69649 = (state_69742[(19)]);
var inst_69674 = fluree.db.api.query.auth_match.call(null,auth,inst_69649,inst_69669);
var inst_69675 = cljs.core.not.call(null,inst_69674);
var state_69742__$1 = state_69742;
var statearr_69771_69866 = state_69742__$1;
(statearr_69771_69866[(2)] = inst_69675);

(statearr_69771_69866[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (2))){
var _ = (function (){var statearr_69772 = state_69742;
(statearr_69772[(4)] = cljs.core.cons.call(null,(5),(state_69742[(4)])));

return statearr_69772;
})();
var inst_69554 = (function (){return (function (p1__69547_SHARP_){
return fluree.db.flake.t.call(null,p1__69547_SHARP_);
});
})();
var inst_69555 = cljs.core.map.call(null,inst_69554,resp);
var inst_69556 = cljs.core.set.call(null,inst_69555);
var inst_69644 = cljs.core.async.chan.call(null,(1));
var inst_69645 = (function (){var ts = inst_69556;
var c__2768__auto____$1 = inst_69644;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69642){
var state_val_69643 = (state_69642[(1)]);
if((state_val_69643 === (7))){
var inst_69576 = (state_69642[(7)]);
var inst_69582 = (state_69642[(8)]);
var inst_69588 = (state_69642[(9)]);
var inst_69570 = (state_69642[(10)]);
var inst_69581 = (state_69642[(2)]);
var inst_69582__$1 = fluree.db.util.async.throw_err.call(null,inst_69581);
var inst_69584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69585 = [inst_69576,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_69586 = (new cljs.core.PersistentVector(null,2,(5),inst_69584,inst_69585,null));
var inst_69587 = cljs.core.assoc_in.call(null,inst_69570,inst_69586,inst_69582__$1);
var inst_69588__$1 = auth;
var state_69642__$1 = (function (){var statearr_69773 = state_69642;
(statearr_69773[(8)] = inst_69582__$1);

(statearr_69773[(11)] = inst_69587);

(statearr_69773[(9)] = inst_69588__$1);

return statearr_69773;
})();
if(cljs.core.truth_(inst_69588__$1)){
var statearr_69774_69867 = state_69642__$1;
(statearr_69774_69867[(1)] = (8));

} else {
var statearr_69775_69868 = state_69642__$1;
(statearr_69775_69868[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69643 === (1))){
var inst_69564 = (state_69642[(12)]);
var inst_69564__$1 = ts;
var inst_69565 = cljs.core.seq.call(null,inst_69564__$1);
var inst_69566 = cljs.core.first.call(null,inst_69565);
var inst_69567 = cljs.core.next.call(null,inst_69565);
var inst_69568 = cljs.core.PersistentHashMap.EMPTY;
var inst_69569 = inst_69564__$1;
var inst_69570 = inst_69568;
var state_69642__$1 = (function (){var statearr_69776 = state_69642;
(statearr_69776[(12)] = inst_69564__$1);

(statearr_69776[(13)] = inst_69567);

(statearr_69776[(14)] = inst_69569);

(statearr_69776[(15)] = inst_69566);

(statearr_69776[(10)] = inst_69570);

return statearr_69776;
})();
var statearr_69777_69869 = state_69642__$1;
(statearr_69777_69869[(2)] = null);

(statearr_69777_69869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69643 === (4))){
var inst_69576 = (state_69642[(7)]);
var inst_69579 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_69576);
var state_69642__$1 = state_69642;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69642__$1,(7),inst_69579);
} else {
if((state_val_69643 === (13))){
var inst_69577 = (state_69642[(16)]);
var inst_69634 = (state_69642[(2)]);
var inst_69569 = inst_69577;
var inst_69570 = inst_69634;
var state_69642__$1 = (function (){var statearr_69778 = state_69642;
(statearr_69778[(14)] = inst_69569);

(statearr_69778[(10)] = inst_69570);

return statearr_69778;
})();
var statearr_69779_69870 = state_69642__$1;
(statearr_69779_69870[(2)] = null);

(statearr_69779_69870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69643 === (6))){
var inst_69638 = (state_69642[(2)]);
var state_69642__$1 = state_69642;
var statearr_69780_69871 = state_69642__$1;
(statearr_69780_69871[(2)] = inst_69638);

(statearr_69780_69871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69643 === (3))){
var inst_69640 = (state_69642[(2)]);
var state_69642__$1 = state_69642;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69642__$1,inst_69640);
} else {
if((state_val_69643 === (12))){
var inst_69587 = (state_69642[(11)]);
var state_69642__$1 = state_69642;
var statearr_69781_69872 = state_69642__$1;
(statearr_69781_69872[(2)] = inst_69587);

(statearr_69781_69872[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69643 === (2))){
var inst_69576 = (state_69642[(7)]);
var inst_69569 = (state_69642[(14)]);
var inst_69575 = cljs.core.seq.call(null,inst_69569);
var inst_69576__$1 = cljs.core.first.call(null,inst_69575);
var inst_69577 = cljs.core.next.call(null,inst_69575);
var state_69642__$1 = (function (){var statearr_69782 = state_69642;
(statearr_69782[(7)] = inst_69576__$1);

(statearr_69782[(16)] = inst_69577);

return statearr_69782;
})();
if(cljs.core.truth_(inst_69576__$1)){
var statearr_69783_69873 = state_69642__$1;
(statearr_69783_69873[(1)] = (4));

} else {
var statearr_69784_69874 = state_69642__$1;
(statearr_69784_69874[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69643 === (11))){
var inst_69564 = (state_69642[(12)]);
var inst_69576 = (state_69642[(7)]);
var inst_69582 = (state_69642[(8)]);
var inst_69577 = (state_69642[(16)]);
var inst_69567 = (state_69642[(13)]);
var inst_69587 = (state_69642[(11)]);
var inst_69569 = (state_69642[(14)]);
var inst_69566 = (state_69642[(15)]);
var inst_69570 = (state_69642[(10)]);
var inst_69594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69595 = [inst_69576,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_69596 = (new cljs.core.PersistentVector(null,2,(5),inst_69594,inst_69595,null));
var inst_69609 = cljs.core.async.chan.call(null,(1));
var inst_69610 = (function (){var t = inst_69576;
var first__69563 = inst_69566;
var seq__69573 = inst_69577;
var block = inst_69582;
var r = inst_69577;
var G__69560 = inst_69569;
var seq__69562 = inst_69567;
var acc = inst_69570;
var vec__69572 = inst_69569;
var vec__69561 = inst_69564;
var first__69574 = inst_69576;
var G__69583 = inst_69587;
var c__2768__auto____$2 = inst_69609;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69607){
var state_val_69608 = (state_69607[(1)]);
if((state_val_69608 === (1))){
var state_69607__$1 = state_69607;
var statearr_69785_69875 = state_69607__$1;
(statearr_69785_69875[(2)] = null);

(statearr_69785_69875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69608 === (2))){
var ___$1 = (function (){var statearr_69786 = state_69607;
(statearr_69786[(4)] = cljs.core.cons.call(null,(5),(state_69607[(4)])));

return statearr_69786;
})();
var ___$2 = (function (){var statearr_69787 = state_69607;
(statearr_69787[(4)] = cljs.core.rest.call(null,(state_69607[(4)])));

return statearr_69787;
})();
var state_69607__$1 = state_69607;
var statearr_69788_69876 = state_69607__$1;
(statearr_69788_69876[(2)] = db);

(statearr_69788_69876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69608 === (3))){
var inst_69605 = (state_69607[(2)]);
var state_69607__$1 = state_69607;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69607__$1,inst_69605);
} else {
if((state_val_69608 === (4))){
var inst_69597 = (state_69607[(2)]);
var state_69607__$1 = state_69607;
var statearr_69790_69877 = state_69607__$1;
(statearr_69790_69877[(2)] = inst_69597);

(statearr_69790_69877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69608 === (5))){
var ___$1 = (function (){var statearr_69791 = state_69607;
(statearr_69791[(4)] = cljs.core.rest.call(null,(state_69607[(4)])));

return statearr_69791;
})();
var state_69607__$1 = state_69607;
var ex69789 = (state_69607__$1[(2)]);
var statearr_69792_69878 = state_69607__$1;
(statearr_69792_69878[(5)] = ex69789);


if((ex69789 instanceof Error)){
var statearr_69793_69879 = state_69607__$1;
(statearr_69793_69879[(1)] = (4));

(statearr_69793_69879[(5)] = null);

} else {
throw ex69789;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_69794 = [null,null,null,null,null,null,null];
(statearr_69794[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_69794[(1)] = (1));

return statearr_69794;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_69607){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69607);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69795){var ex__2749__auto__ = e69795;
var statearr_69796_69880 = state_69607;
(statearr_69796_69880[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69607[(4)]))){
var statearr_69797_69881 = state_69607;
(statearr_69797_69881[(1)] = cljs.core.first.call(null,(state_69607[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69882 = state_69607;
state_69607 = G__69882;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_69607){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_69607);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69798 = f__2769__auto__.call(null);
(statearr_69798[(6)] = c__2768__auto____$2);

return statearr_69798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_69611 = cljs.core.async.impl.dispatch.run.call(null,inst_69610);
var inst_69612 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_69613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69614 = ["?auth","?id"];
var inst_69615 = (new cljs.core.PersistentVector(null,2,(5),inst_69613,inst_69614,null));
var inst_69616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69618 = [inst_69576,"_tx/auth","?auth"];
var inst_69619 = (new cljs.core.PersistentVector(null,3,(5),inst_69617,inst_69618,null));
var inst_69620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69621 = ["?auth","_auth/id","?id"];
var inst_69622 = (new cljs.core.PersistentVector(null,3,(5),inst_69620,inst_69621,null));
var inst_69623 = [inst_69619,inst_69622];
var inst_69624 = (new cljs.core.PersistentVector(null,2,(5),inst_69616,inst_69623,null));
var inst_69625 = [inst_69615,inst_69624];
var inst_69626 = cljs.core.PersistentHashMap.fromArrays(inst_69612,inst_69625);
var inst_69627 = fluree.db.api.query.query_async.call(null,inst_69609,inst_69626);
var state_69642__$1 = (function (){var statearr_69799 = state_69642;
(statearr_69799[(17)] = inst_69596);

(statearr_69799[(18)] = inst_69611);

return statearr_69799;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69642__$1,(14),inst_69627);
} else {
if((state_val_69643 === (9))){
var state_69642__$1 = state_69642;
var statearr_69800_69883 = state_69642__$1;
(statearr_69800_69883[(2)] = show_auth);

(statearr_69800_69883[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69643 === (5))){
var inst_69570 = (state_69642[(10)]);
var state_69642__$1 = state_69642;
var statearr_69801_69884 = state_69642__$1;
(statearr_69801_69884[(2)] = inst_69570);

(statearr_69801_69884[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69643 === (14))){
var inst_69596 = (state_69642[(17)]);
var inst_69587 = (state_69642[(11)]);
var inst_69629 = (state_69642[(2)]);
var inst_69630 = fluree.db.util.async.throw_err.call(null,inst_69629);
var inst_69631 = cljs.core.assoc_in.call(null,inst_69587,inst_69596,inst_69630);
var state_69642__$1 = state_69642;
var statearr_69802_69885 = state_69642__$1;
(statearr_69802_69885[(2)] = inst_69631);

(statearr_69802_69885[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69643 === (10))){
var inst_69592 = (state_69642[(2)]);
var state_69642__$1 = state_69642;
if(cljs.core.truth_(inst_69592)){
var statearr_69803_69886 = state_69642__$1;
(statearr_69803_69886[(1)] = (11));

} else {
var statearr_69804_69887 = state_69642__$1;
(statearr_69804_69887[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69643 === (8))){
var inst_69588 = (state_69642[(9)]);
var state_69642__$1 = state_69642;
var statearr_69805_69888 = state_69642__$1;
(statearr_69805_69888[(2)] = inst_69588);

(statearr_69805_69888[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_69806 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69806[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_69806[(1)] = (1));

return statearr_69806;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_69642){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69642);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69807){var ex__2749__auto__ = e69807;
var statearr_69808_69889 = state_69642;
(statearr_69808_69889[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69642[(4)]))){
var statearr_69809_69890 = state_69642;
(statearr_69809_69890[(1)] = cljs.core.first.call(null,(state_69642[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69891 = state_69642;
state_69642 = G__69891;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_69642){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_69642);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69810 = f__2769__auto__.call(null);
(statearr_69810[(6)] = c__2768__auto____$1);

return statearr_69810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_69646 = cljs.core.async.impl.dispatch.run.call(null,inst_69645);
var state_69742__$1 = (function (){var statearr_69811 = state_69742;
(statearr_69811[(20)] = inst_69646);

return statearr_69811;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69742__$1,(6),inst_69644);
} else {
if((state_val_69743 === (23))){
var inst_69700 = (state_69742[(2)]);
var state_69742__$1 = (function (){var statearr_69812 = state_69742;
(statearr_69812[(13)] = inst_69700);

return statearr_69812;
})();
var statearr_69813_69892 = state_69742__$1;
(statearr_69813_69892[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (35))){
var inst_69730 = (state_69742[(2)]);
var state_69742__$1 = state_69742;
var statearr_69815_69893 = state_69742__$1;
(statearr_69815_69893[(2)] = inst_69730);

(statearr_69815_69893[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (19))){
var state_69742__$1 = state_69742;
var statearr_69816_69894 = state_69742__$1;
(statearr_69816_69894[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (11))){
var inst_69681 = (state_69742[(2)]);
var state_69742__$1 = state_69742;
if(cljs.core.truth_(inst_69681)){
var statearr_69819_69895 = state_69742__$1;
(statearr_69819_69895[(1)] = (15));

} else {
var statearr_69820_69896 = state_69742__$1;
(statearr_69820_69896[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (9))){
var inst_69672 = (state_69742[(16)]);
var inst_69672__$1 = auth;
var state_69742__$1 = (function (){var statearr_69821 = state_69742;
(statearr_69821[(16)] = inst_69672__$1);

return statearr_69821;
})();
if(cljs.core.truth_(inst_69672__$1)){
var statearr_69822_69897 = state_69742__$1;
(statearr_69822_69897[(1)] = (12));

} else {
var statearr_69823_69898 = state_69742__$1;
(statearr_69823_69898[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (5))){
var _ = (function (){var statearr_69824 = state_69742;
(statearr_69824[(4)] = cljs.core.rest.call(null,(state_69742[(4)])));

return statearr_69824;
})();
var state_69742__$1 = state_69742;
var ex69818 = (state_69742__$1[(2)]);
var statearr_69825_69899 = state_69742__$1;
(statearr_69825_69899[(5)] = ex69818);


if((ex69818 instanceof Error)){
var statearr_69826_69900 = state_69742__$1;
(statearr_69826_69900[(1)] = (4));

(statearr_69826_69900[(5)] = null);

} else {
throw ex69818;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (14))){
var inst_69678 = (state_69742[(2)]);
var state_69742__$1 = state_69742;
var statearr_69827_69901 = state_69742__$1;
(statearr_69827_69901[(2)] = inst_69678);

(statearr_69827_69901[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (26))){
var inst_69708 = (state_69742[(2)]);
var state_69742__$1 = (function (){var statearr_69828 = state_69742;
(statearr_69828[(10)] = inst_69708);

return statearr_69828;
})();
var statearr_69829_69902 = state_69742__$1;
(statearr_69829_69902[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (16))){
var inst_69669 = (state_69742[(8)]);
var state_69742__$1 = state_69742;
if(cljs.core.truth_(inst_69669)){
var statearr_69831_69903 = state_69742__$1;
(statearr_69831_69903[(1)] = (18));

} else {
var statearr_69832_69904 = state_69742__$1;
(statearr_69832_69904[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (30))){
var inst_69691 = (state_69742[(21)]);
var inst_69716 = (state_69742[(15)]);
var inst_69690 = (state_69742[(12)]);
var inst_69718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69719 = [inst_69690,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_69720 = (new cljs.core.PersistentVector(null,2,(5),inst_69718,inst_69719,null));
var inst_69721 = cljs.core.assoc_in.call(null,inst_69716,inst_69720,inst_69691);
var state_69742__$1 = state_69742;
var statearr_69833_69905 = state_69742__$1;
(statearr_69833_69905[(2)] = inst_69721);

(statearr_69833_69905[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (10))){
var inst_69669 = (state_69742[(8)]);
var state_69742__$1 = state_69742;
var statearr_69834_69906 = state_69742__$1;
(statearr_69834_69906[(2)] = inst_69669);

(statearr_69834_69906[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (18))){
var inst_69669 = (state_69742[(8)]);
var inst_69687 = (state_69742[(11)]);
var inst_69649 = (state_69742[(19)]);
var inst_69687__$1 = fluree.db.flake.t.call(null,inst_69669);
var inst_69688 = cljs.core.get.call(null,inst_69649,inst_69687__$1);
var inst_69689 = cljs.core.__destructure_map.call(null,inst_69688);
var inst_69690 = cljs.core.get.call(null,inst_69689,new cljs.core.Keyword(null,"block","block",664686210));
var inst_69691 = cljs.core.get.call(null,inst_69689,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_69742__$1 = (function (){var statearr_69835 = state_69742;
(statearr_69835[(21)] = inst_69691);

(statearr_69835[(11)] = inst_69687__$1);

(statearr_69835[(12)] = inst_69690);

return statearr_69835;
})();
var statearr_69836_69907 = state_69742__$1;
(statearr_69836_69907[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69743 === (8))){
var inst_69736 = (state_69742[(2)]);
var inst_69737 = cljs.core.vals.call(null,inst_69736);
var _ = (function (){var statearr_69838 = state_69742;
(statearr_69838[(4)] = cljs.core.rest.call(null,(state_69742[(4)])));

return statearr_69838;
})();
var state_69742__$1 = state_69742;
var statearr_69839_69908 = state_69742__$1;
(statearr_69839_69908[(2)] = inst_69737);

(statearr_69839_69908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_69840 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69840[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_69840[(1)] = (1));

return statearr_69840;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_69742){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69742);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69841){var ex__2749__auto__ = e69841;
var statearr_69842_69909 = state_69742;
(statearr_69842_69909[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69742[(4)]))){
var statearr_69843_69910 = state_69742;
(statearr_69843_69910[(1)] = cljs.core.first.call(null,(state_69742[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69911 = state_69742;
state_69742 = G__69911;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_69742){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_69742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69844 = f__2769__auto__.call(null);
(statearr_69844[(6)] = c__2768__auto__);

return statearr_69844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70035){
var state_val_70036 = (state_70035[(1)]);
if((state_val_70036 === (7))){
var inst_69934 = (state_70035[(7)]);
var inst_69936 = fluree.db.api.query.resolve_block_range.call(null,inst_69934,query_map);
var state_70035__$1 = state_70035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70035__$1,(10),inst_69936);
} else {
if((state_val_70036 === (20))){
var inst_69960 = (state_70035[(2)]);
var inst_69961 = fluree.db.util.async.throw_err.call(null,inst_69960);
var inst_69962 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_69961);
var inst_69963 = (inst_69962 - (1));
var state_70035__$1 = state_70035;
var statearr_70037_70100 = state_70035__$1;
(statearr_70037_70100[(2)] = inst_69963);

(statearr_70037_70100[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (27))){
var state_70035__$1 = state_70035;
var statearr_70038_70101 = state_70035__$1;
(statearr_70038_70101[(2)] = null);

(statearr_70038_70101[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (1))){
var state_70035__$1 = state_70035;
var statearr_70039_70102 = state_70035__$1;
(statearr_70039_70102[(2)] = null);

(statearr_70039_70102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (24))){
var inst_69970 = (state_70035[(2)]);
var inst_69971 = fluree.db.util.async.throw_err.call(null,inst_69970);
var inst_69972 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_69971);
var state_70035__$1 = state_70035;
var statearr_70040_70103 = state_70035__$1;
(statearr_70040_70103[(2)] = inst_69972);

(statearr_70040_70103[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (39))){
var inst_70007 = (state_70035[(2)]);
var inst_70008 = fluree.db.util.async.throw_err.call(null,inst_70007);
var state_70035__$1 = state_70035;
var statearr_70041_70104 = state_70035__$1;
(statearr_70041_70104[(2)] = inst_70008);

(statearr_70041_70104[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (4))){
var inst_69912 = (state_70035[(2)]);
var state_70035__$1 = state_70035;
var statearr_70042_70105 = state_70035__$1;
(statearr_70042_70105[(2)] = inst_69912);

(statearr_70042_70105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (15))){
var inst_69943 = (state_70035[(8)]);
var state_70035__$1 = state_70035;
var statearr_70043_70106 = state_70035__$1;
(statearr_70043_70106[(2)] = inst_69943);

(statearr_70043_70106[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (21))){
var inst_69934 = (state_70035[(7)]);
var inst_69944 = (state_70035[(9)]);
var inst_69968 = fluree.db.time_travel.as_of_block.call(null,inst_69934,inst_69944);
var state_70035__$1 = state_70035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70035__$1,(24),inst_69968);
} else {
if((state_val_70036 === (31))){
var inst_69928 = (state_70035[(10)]);
var state_70035__$1 = state_70035;
var statearr_70044_70107 = state_70035__$1;
(statearr_70044_70107[(2)] = inst_69928);

(statearr_70044_70107[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (32))){
var inst_69934 = (state_70035[(7)]);
var inst_69991 = (state_70035[(11)]);
var inst_69986 = (state_70035[(12)]);
var inst_69995 = (state_70035[(2)]);
var inst_69996 = fluree.db.api.query.format_history_resp.call(null,inst_69934,inst_69986,inst_69991,inst_69995);
var state_70035__$1 = state_70035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70035__$1,(29),inst_69996);
} else {
if((state_val_70036 === (40))){
var inst_70012 = (state_70035[(13)]);
var inst_69986 = (state_70035[(12)]);
var inst_70014 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_70015 = cljs.core.count.call(null,inst_69986);
var inst_70016 = [inst_70012,inst_70015,(200)];
var inst_70017 = cljs.core.PersistentHashMap.fromArrays(inst_70014,inst_70016);
var state_70035__$1 = state_70035;
var statearr_70045_70108 = state_70035__$1;
(statearr_70045_70108[(2)] = inst_70017);

(statearr_70045_70108[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (33))){
var inst_69927 = (state_70035[(14)]);
var state_70035__$1 = state_70035;
var statearr_70046_70109 = state_70035__$1;
(statearr_70046_70109[(2)] = inst_69927);

(statearr_70046_70109[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (13))){
var inst_70030 = (state_70035[(2)]);
var _ = (function (){var statearr_70047 = state_70035;
(statearr_70047[(4)] = cljs.core.rest.call(null,(state_70035[(4)])));

return statearr_70047;
})();
var state_70035__$1 = state_70035;
var statearr_70048_70110 = state_70035__$1;
(statearr_70048_70110[(2)] = inst_70030);

(statearr_70048_70110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (22))){
var inst_69934 = (state_70035[(7)]);
var inst_69974 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_69934);
var state_70035__$1 = state_70035;
var statearr_70049_70111 = state_70035__$1;
(statearr_70049_70111[(2)] = inst_69974);

(statearr_70049_70111[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (36))){
var inst_69999 = (state_70035[(15)]);
var inst_69934 = (state_70035[(7)]);
var inst_70005 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_69934,inst_69999);
var state_70035__$1 = state_70035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70035__$1,(39),inst_70005);
} else {
if((state_val_70036 === (41))){
var inst_70012 = (state_70035[(13)]);
var state_70035__$1 = state_70035;
var statearr_70050_70112 = state_70035__$1;
(statearr_70050_70112[(2)] = inst_70012);

(statearr_70050_70112[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (29))){
var inst_69927 = (state_70035[(14)]);
var inst_69998 = (state_70035[(2)]);
var inst_69999 = fluree.db.util.async.throw_err.call(null,inst_69998);
var state_70035__$1 = (function (){var statearr_70051 = state_70035;
(statearr_70051[(15)] = inst_69999);

return statearr_70051;
})();
if(cljs.core.truth_(inst_69927)){
var statearr_70052_70113 = state_70035__$1;
(statearr_70052_70113[(1)] = (33));

} else {
var statearr_70053_70114 = state_70035__$1;
(statearr_70053_70114[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (6))){
var inst_69924 = (state_70035[(16)]);
var inst_69933 = (state_70035[(2)]);
var inst_69934 = fluree.db.util.async.throw_err.call(null,inst_69933);
var state_70035__$1 = (function (){var statearr_70054 = state_70035;
(statearr_70054[(7)] = inst_69934);

return statearr_70054;
})();
if(cljs.core.truth_(inst_69924)){
var statearr_70055_70115 = state_70035__$1;
(statearr_70055_70115[(1)] = (7));

} else {
var statearr_70056_70116 = state_70035__$1;
(statearr_70056_70116[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (28))){
var inst_69929 = (state_70035[(17)]);
var inst_69991 = (state_70035[(2)]);
var state_70035__$1 = (function (){var statearr_70057 = state_70035;
(statearr_70057[(11)] = inst_69991);

return statearr_70057;
})();
if(cljs.core.truth_(inst_69929)){
var statearr_70058_70117 = state_70035__$1;
(statearr_70058_70117[(1)] = (30));

} else {
var statearr_70059_70118 = state_70035__$1;
(statearr_70059_70118[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (25))){
var inst_69930 = (state_70035[(18)]);
var inst_69985 = (state_70035[(2)]);
var inst_69986 = fluree.db.util.async.throw_err.call(null,inst_69985);
var state_70035__$1 = (function (){var statearr_70060 = state_70035;
(statearr_70060[(12)] = inst_69986);

return statearr_70060;
})();
if(cljs.core.truth_(inst_69930)){
var statearr_70061_70119 = state_70035__$1;
(statearr_70061_70119[(1)] = (26));

} else {
var statearr_70062_70120 = state_70035__$1;
(statearr_70062_70120[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (34))){
var inst_69926 = (state_70035[(19)]);
var state_70035__$1 = state_70035;
var statearr_70063_70121 = state_70035__$1;
(statearr_70063_70121[(2)] = inst_69926);

(statearr_70063_70121[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (17))){
var inst_69943 = (state_70035[(8)]);
var inst_69934 = (state_70035[(7)]);
var inst_69957 = (inst_69943 - (1));
var inst_69958 = fluree.db.time_travel.as_of_block.call(null,inst_69934,inst_69957);
var state_70035__$1 = state_70035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70035__$1,(20),inst_69958);
} else {
if((state_val_70036 === (3))){
var inst_70033 = (state_70035[(2)]);
var state_70035__$1 = state_70035;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70035__$1,inst_70033);
} else {
if((state_val_70036 === (12))){
var inst_70022 = cljs.core.pr_str.call(null,query_map);
var inst_70023 = ["History query not properly formatted. Provided ",inst_70022].join('');
var inst_70024 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70025 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70026 = cljs.core.PersistentHashMap.fromArrays(inst_70024,inst_70025);
var inst_70027 = cljs.core.ex_info.call(null,inst_70023,inst_70026);
var inst_70028 = (function(){throw inst_70027})();
var state_70035__$1 = state_70035;
var statearr_70064_70122 = state_70035__$1;
(statearr_70064_70122[(2)] = inst_70028);

(statearr_70064_70122[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (2))){
var _ = (function (){var statearr_70065 = state_70035;
(statearr_70065[(4)] = cljs.core.cons.call(null,(5),(state_70035[(4)])));

return statearr_70065;
})();
var inst_69922 = query_map;
var inst_69923 = cljs.core.__destructure_map.call(null,inst_69922);
var inst_69924 = cljs.core.get.call(null,inst_69923,new cljs.core.Keyword(null,"block","block",664686210));
var inst_69925 = cljs.core.get.call(null,inst_69923,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_69926 = cljs.core.get.call(null,inst_69923,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_69927 = cljs.core.get.call(null,inst_69923,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_69928 = cljs.core.get.call(null,inst_69923,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_69929 = cljs.core.get.call(null,inst_69923,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_69930 = cljs.core.get.call(null,inst_69923,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_69931 = cljs.core.get.call(null,inst_69923,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_70035__$1 = (function (){var statearr_70066 = state_70035;
(statearr_70066[(20)] = inst_69925);

(statearr_70066[(18)] = inst_69930);

(statearr_70066[(16)] = inst_69924);

(statearr_70066[(19)] = inst_69926);

(statearr_70066[(14)] = inst_69927);

(statearr_70066[(10)] = inst_69928);

(statearr_70066[(17)] = inst_69929);

(statearr_70066[(21)] = inst_69931);

return statearr_70066;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70035__$1,(6),sources);
} else {
if((state_val_70036 === (23))){
var inst_69925 = (state_70035[(20)]);
var inst_69966 = (state_70035[(22)]);
var inst_69934 = (state_70035[(7)]);
var inst_69976 = (state_70035[(2)]);
var inst_69977 = fluree.db.api.query.get_history_pattern.call(null,inst_69925);
var inst_69978 = cljs.core.nth.call(null,inst_69977,(0),null);
var inst_69979 = cljs.core.nth.call(null,inst_69977,(1),null);
var inst_69980 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_69981 = [inst_69966,inst_69976];
var inst_69982 = cljs.core.PersistentHashMap.fromArrays(inst_69980,inst_69981);
var inst_69983 = fluree.db.query.range.time_range.call(null,inst_69934,inst_69979,cljs.core._EQ_,inst_69978,inst_69982);
var state_70035__$1 = state_70035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70035__$1,(25),inst_69983);
} else {
if((state_val_70036 === (35))){
var inst_70003 = (state_70035[(2)]);
var state_70035__$1 = state_70035;
if(cljs.core.truth_(inst_70003)){
var statearr_70067_70123 = state_70035__$1;
(statearr_70067_70123[(1)] = (36));

} else {
var statearr_70068_70124 = state_70035__$1;
(statearr_70068_70124[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (19))){
var inst_69944 = (state_70035[(9)]);
var inst_69966 = (state_70035[(2)]);
var state_70035__$1 = (function (){var statearr_70069 = state_70035;
(statearr_70069[(22)] = inst_69966);

return statearr_70069;
})();
if(cljs.core.truth_(inst_69944)){
var statearr_70070_70125 = state_70035__$1;
(statearr_70070_70125[(1)] = (21));

} else {
var statearr_70071_70126 = state_70035__$1;
(statearr_70071_70126[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (11))){
var inst_69943 = (state_70035[(8)]);
var inst_69931 = (state_70035[(21)]);
var inst_69950 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_69931);
var state_70035__$1 = (function (){var statearr_70073 = state_70035;
(statearr_70073[(23)] = inst_69950);

return statearr_70073;
})();
if(cljs.core.truth_(inst_69943)){
var statearr_70074_70127 = state_70035__$1;
(statearr_70074_70127[(1)] = (14));

} else {
var statearr_70075_70128 = state_70035__$1;
(statearr_70075_70128[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (9))){
var inst_69942 = (state_70035[(2)]);
var inst_69943 = cljs.core.nth.call(null,inst_69942,(0),null);
var inst_69944 = cljs.core.nth.call(null,inst_69942,(1),null);
var inst_69945 = cljs.core.contains_QMARK_.call(null,query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_70035__$1 = (function (){var statearr_70076 = state_70035;
(statearr_70076[(8)] = inst_69943);

(statearr_70076[(9)] = inst_69944);

return statearr_70076;
})();
if(inst_69945){
var statearr_70077_70129 = state_70035__$1;
(statearr_70077_70129[(1)] = (11));

} else {
var statearr_70078_70130 = state_70035__$1;
(statearr_70078_70130[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (5))){
var _ = (function (){var statearr_70079 = state_70035;
(statearr_70079[(4)] = cljs.core.rest.call(null,(state_70035[(4)])));

return statearr_70079;
})();
var state_70035__$1 = state_70035;
var ex70072 = (state_70035__$1[(2)]);
var statearr_70080_70131 = state_70035__$1;
(statearr_70080_70131[(5)] = ex70072);


if((ex70072 instanceof Error)){
var statearr_70081_70132 = state_70035__$1;
(statearr_70081_70132[(1)] = (4));

(statearr_70081_70132[(5)] = null);

} else {
throw ex70072;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (14))){
var inst_69943 = (state_70035[(8)]);
var inst_69952 = cljs.core.not_EQ_.call(null,(1),inst_69943);
var state_70035__$1 = state_70035;
var statearr_70082_70133 = state_70035__$1;
(statearr_70082_70133[(2)] = inst_69952);

(statearr_70082_70133[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (26))){
var inst_69930 = (state_70035[(18)]);
var inst_69988 = cljs.core.set.call(null,inst_69930);
var state_70035__$1 = state_70035;
var statearr_70083_70134 = state_70035__$1;
(statearr_70083_70134[(2)] = inst_69988);

(statearr_70083_70134[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (16))){
var inst_69955 = (state_70035[(2)]);
var state_70035__$1 = state_70035;
if(cljs.core.truth_(inst_69955)){
var statearr_70084_70135 = state_70035__$1;
(statearr_70084_70135[(1)] = (17));

} else {
var statearr_70085_70136 = state_70035__$1;
(statearr_70085_70136[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (38))){
var inst_69950 = (state_70035[(23)]);
var inst_70012 = (state_70035[(2)]);
var state_70035__$1 = (function (){var statearr_70086 = state_70035;
(statearr_70086[(13)] = inst_70012);

return statearr_70086;
})();
if(cljs.core.truth_(inst_69950)){
var statearr_70087_70137 = state_70035__$1;
(statearr_70087_70137[(1)] = (40));

} else {
var statearr_70088_70138 = state_70035__$1;
(statearr_70088_70138[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (30))){
var inst_69929 = (state_70035[(17)]);
var state_70035__$1 = state_70035;
var statearr_70089_70139 = state_70035__$1;
(statearr_70089_70139[(2)] = inst_69929);

(statearr_70089_70139[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (10))){
var inst_69938 = (state_70035[(2)]);
var inst_69939 = fluree.db.util.async.throw_err.call(null,inst_69938);
var state_70035__$1 = state_70035;
var statearr_70090_70140 = state_70035__$1;
(statearr_70090_70140[(2)] = inst_69939);

(statearr_70090_70140[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (18))){
var state_70035__$1 = state_70035;
var statearr_70091_70141 = state_70035__$1;
(statearr_70091_70141[(2)] = (-1));

(statearr_70091_70141[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (42))){
var inst_70020 = (state_70035[(2)]);
var state_70035__$1 = state_70035;
var statearr_70092_70142 = state_70035__$1;
(statearr_70092_70142[(2)] = inst_70020);

(statearr_70092_70142[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (37))){
var inst_69999 = (state_70035[(15)]);
var inst_70010 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_69999);
var state_70035__$1 = state_70035;
var statearr_70093_70143 = state_70035__$1;
(statearr_70093_70143[(2)] = inst_70010);

(statearr_70093_70143[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70036 === (8))){
var state_70035__$1 = state_70035;
var statearr_70094_70144 = state_70035__$1;
(statearr_70094_70144[(2)] = null);

(statearr_70094_70144[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_70095 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70095[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2746__auto__);

(statearr_70095[(1)] = (1));

return statearr_70095;
});
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1 = (function (state_70035){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70035);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70096){var ex__2749__auto__ = e70096;
var statearr_70097_70145 = state_70035;
(statearr_70097_70145[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70035[(4)]))){
var statearr_70098_70146 = state_70035;
(statearr_70098_70146[(1)] = cljs.core.first.call(null,(state_70035[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70147 = state_70035;
state_70035 = G__70147;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__ = function(state_70035){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1.call(this,state_70035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70099 = f__2769__auto__.call(null);
(statearr_70099[(6)] = c__2768__auto__);

return statearr_70099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70280){
var state_val_70281 = (state_70280[(1)]);
if((state_val_70281 === (7))){
var inst_70177 = cljs.core.pr_str.call(null,flureeQL);
var inst_70178 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_70177].join('');
var inst_70179 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70180 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70181 = cljs.core.PersistentHashMap.fromArrays(inst_70179,inst_70180);
var inst_70182 = cljs.core.ex_info.call(null,inst_70178,inst_70181);
var inst_70183 = (function(){throw inst_70182})();
var state_70280__$1 = state_70280;
var statearr_70282_70361 = state_70280__$1;
(statearr_70282_70361[(2)] = inst_70183);

(statearr_70282_70361[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (20))){
var inst_70215 = (state_70280[(2)]);
var state_70280__$1 = state_70280;
if(cljs.core.truth_(inst_70215)){
var statearr_70283_70362 = state_70280__$1;
(statearr_70283_70362[(1)] = (21));

} else {
var statearr_70284_70363 = state_70280__$1;
(statearr_70284_70363[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (27))){
var inst_70159 = (state_70280[(7)]);
var state_70280__$1 = state_70280;
var statearr_70285_70364 = state_70280__$1;
(statearr_70285_70364[(2)] = inst_70159);

(statearr_70285_70364[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (1))){
var state_70280__$1 = state_70280;
var statearr_70286_70365 = state_70280__$1;
(statearr_70286_70365[(2)] = null);

(statearr_70286_70365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (24))){
var inst_70221 = (state_70280[(8)]);
var state_70280__$1 = state_70280;
var statearr_70287_70366 = state_70280__$1;
(statearr_70287_70366[(2)] = inst_70221);

(statearr_70287_70366[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (39))){
var inst_70165 = (state_70280[(9)]);
var state_70280__$1 = state_70280;
if(cljs.core.truth_(inst_70165)){
var statearr_70288_70367 = state_70280__$1;
(statearr_70288_70367[(1)] = (42));

} else {
var statearr_70289_70368 = state_70280__$1;
(statearr_70289_70368[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (46))){
var inst_70253 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70254 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70255 = cljs.core.PersistentHashMap.fromArrays(inst_70253,inst_70254);
var inst_70256 = cljs.core.ex_info.call(null,"Invalid query.",inst_70255);
var inst_70257 = (function(){throw inst_70256})();
var state_70280__$1 = state_70280;
var statearr_70290_70369 = state_70280__$1;
(statearr_70290_70369[(2)] = inst_70257);

(statearr_70290_70369[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (4))){
var inst_70149 = (state_70280[(2)]);
var state_70280__$1 = state_70280;
var statearr_70291_70370 = state_70280__$1;
(statearr_70291_70370[(2)] = inst_70149);

(statearr_70291_70370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (15))){
var inst_70200 = (state_70280[(10)]);
var inst_70162 = (state_70280[(11)]);
var inst_70202 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_70200);
var inst_70203 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_70200);
var inst_70204 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_70200);
var inst_70205 = fluree.db.api.query.get_sources.call(null,inst_70202,inst_70203,inst_70204,inst_70162);
var state_70280__$1 = state_70280;
var statearr_70292_70371 = state_70280__$1;
(statearr_70292_70371[(2)] = inst_70205);

(statearr_70292_70371[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (48))){
var inst_70210 = (state_70280[(12)]);
var inst_70264 = (state_70280[(2)]);
var inst_70265 = fluree.db.util.async.throw_err.call(null,inst_70264);
var state_70280__$1 = (function (){var statearr_70293 = state_70280;
(statearr_70293[(13)] = inst_70265);

return statearr_70293;
})();
if(cljs.core.truth_(inst_70210)){
var statearr_70294_70372 = state_70280__$1;
(statearr_70294_70372[(1)] = (49));

} else {
var statearr_70295_70373 = state_70280__$1;
(statearr_70295_70373[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (50))){
var inst_70265 = (state_70280[(13)]);
var state_70280__$1 = state_70280;
var statearr_70296_70374 = state_70280__$1;
(statearr_70296_70374[(2)] = inst_70265);

(statearr_70296_70374[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (21))){
var inst_70217 = cljs.core.volatile_BANG_.call(null,(0));
var state_70280__$1 = state_70280;
var statearr_70297_70375 = state_70280__$1;
(statearr_70297_70375[(2)] = inst_70217);

(statearr_70297_70375[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (31))){
var inst_70163 = (state_70280[(14)]);
var state_70280__$1 = state_70280;
if(cljs.core.truth_(inst_70163)){
var statearr_70298_70376 = state_70280__$1;
(statearr_70298_70376[(1)] = (33));

} else {
var statearr_70299_70377 = state_70280__$1;
(statearr_70299_70377[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (32))){
var inst_70240 = (state_70280[(2)]);
var state_70280__$1 = state_70280;
var statearr_70300_70378 = state_70280__$1;
(statearr_70300_70378[(2)] = inst_70240);

(statearr_70300_70378[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (40))){
var inst_70242 = (state_70280[(15)]);
var state_70280__$1 = state_70280;
var statearr_70301_70379 = state_70280__$1;
(statearr_70301_70379[(2)] = inst_70242);

(statearr_70301_70379[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (33))){
var inst_70163 = (state_70280[(14)]);
var state_70280__$1 = state_70280;
var statearr_70302_70380 = state_70280__$1;
(statearr_70302_70380[(2)] = inst_70163);

(statearr_70302_70380[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (13))){
var inst_70160 = (state_70280[(16)]);
var inst_70189 = (state_70280[(2)]);
var inst_70190 = fluree.db.util.async.throw_err.call(null,inst_70189);
var inst_70191 = fluree.db.time_travel.as_of_block.call(null,inst_70190,inst_70160);
var state_70280__$1 = state_70280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70280__$1,(12),inst_70191);
} else {
if((state_val_70281 === (22))){
var state_70280__$1 = state_70280;
var statearr_70303_70381 = state_70280__$1;
(statearr_70303_70381[(2)] = null);

(statearr_70303_70381[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (36))){
var inst_70167 = (state_70280[(17)]);
var state_70280__$1 = state_70280;
var statearr_70304_70382 = state_70280__$1;
(statearr_70304_70382[(2)] = inst_70167);

(statearr_70304_70382[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (41))){
var inst_70250 = (state_70280[(2)]);
var state_70280__$1 = state_70280;
if(cljs.core.truth_(inst_70250)){
var statearr_70305_70383 = state_70280__$1;
(statearr_70305_70383[(1)] = (45));

} else {
var statearr_70306_70384 = state_70280__$1;
(statearr_70306_70384[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (43))){
var inst_70161 = (state_70280[(18)]);
var state_70280__$1 = state_70280;
var statearr_70307_70385 = state_70280__$1;
(statearr_70307_70385[(2)] = inst_70161);

(statearr_70307_70385[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (29))){
var inst_70242 = (state_70280[(15)]);
var inst_70242__$1 = (state_70280[(2)]);
var state_70280__$1 = (function (){var statearr_70308 = state_70280;
(statearr_70308[(15)] = inst_70242__$1);

return statearr_70308;
})();
if(cljs.core.truth_(inst_70242__$1)){
var statearr_70309_70386 = state_70280__$1;
(statearr_70309_70386[(1)] = (39));

} else {
var statearr_70310_70387 = state_70280__$1;
(statearr_70310_70387[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (44))){
var inst_70247 = (state_70280[(2)]);
var state_70280__$1 = state_70280;
var statearr_70311_70388 = state_70280__$1;
(statearr_70311_70388[(2)] = inst_70247);

(statearr_70311_70388[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (6))){
var state_70280__$1 = state_70280;
var statearr_70312_70389 = state_70280__$1;
(statearr_70312_70389[(2)] = null);

(statearr_70312_70389[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (28))){
var inst_70164 = (state_70280[(19)]);
var state_70280__$1 = state_70280;
if(cljs.core.truth_(inst_70164)){
var statearr_70313_70390 = state_70280__$1;
(statearr_70313_70390[(1)] = (30));

} else {
var statearr_70314_70391 = state_70280__$1;
(statearr_70314_70391[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (51))){
var inst_70275 = (state_70280[(2)]);
var _ = (function (){var statearr_70315 = state_70280;
(statearr_70315[(4)] = cljs.core.rest.call(null,(state_70280[(4)])));

return statearr_70315;
})();
var state_70280__$1 = state_70280;
var statearr_70316_70392 = state_70280__$1;
(statearr_70316_70392[(2)] = inst_70275);

(statearr_70316_70392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (25))){
var state_70280__$1 = state_70280;
var statearr_70317_70393 = state_70280__$1;
(statearr_70317_70393[(2)] = (1000000));

(statearr_70317_70393[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (34))){
var inst_70167 = (state_70280[(17)]);
var state_70280__$1 = state_70280;
if(cljs.core.truth_(inst_70167)){
var statearr_70318_70394 = state_70280__$1;
(statearr_70318_70394[(1)] = (36));

} else {
var statearr_70319_70395 = state_70280__$1;
(statearr_70319_70395[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (17))){
var inst_70166 = (state_70280[(20)]);
var inst_70211 = (state_70280[(21)]);
var inst_70209 = (state_70280[(2)]);
var inst_70210 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_70166);
var inst_70211__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_70166);
var state_70280__$1 = (function (){var statearr_70320 = state_70280;
(statearr_70320[(21)] = inst_70211__$1);

(statearr_70320[(22)] = inst_70209);

(statearr_70320[(12)] = inst_70210);

return statearr_70320;
})();
if(cljs.core.truth_(inst_70211__$1)){
var statearr_70321_70396 = state_70280__$1;
(statearr_70321_70396[(1)] = (18));

} else {
var statearr_70322_70397 = state_70280__$1;
(statearr_70322_70397[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (3))){
var inst_70278 = (state_70280[(2)]);
var state_70280__$1 = state_70280;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70280__$1,inst_70278);
} else {
if((state_val_70281 === (12))){
var inst_70193 = (state_70280[(2)]);
var inst_70194 = fluree.db.util.async.throw_err.call(null,inst_70193);
var state_70280__$1 = state_70280;
var statearr_70323_70398 = state_70280__$1;
(statearr_70323_70398[(2)] = inst_70194);

(statearr_70323_70398[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (2))){
var inst_70160 = (state_70280[(16)]);
var inst_70166 = (state_70280[(20)]);
var inst_70159 = (state_70280[(7)]);
var inst_70161 = (state_70280[(18)]);
var inst_70163 = (state_70280[(14)]);
var inst_70158 = (state_70280[(23)]);
var inst_70164 = (state_70280[(19)]);
var inst_70165 = (state_70280[(9)]);
var inst_70167 = (state_70280[(17)]);
var inst_70162 = (state_70280[(11)]);
var _ = (function (){var statearr_70324 = state_70280;
(statearr_70324[(4)] = cljs.core.cons.call(null,(5),(state_70280[(4)])));

return statearr_70324;
})();
var inst_70156 = flureeQL;
var inst_70157 = cljs.core.__destructure_map.call(null,inst_70156);
var inst_70158__$1 = cljs.core.get.call(null,inst_70157,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_70159__$1 = cljs.core.get.call(null,inst_70157,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_70160__$1 = cljs.core.get.call(null,inst_70157,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70161__$1 = cljs.core.get.call(null,inst_70157,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_70162__$1 = cljs.core.get.call(null,inst_70157,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_70163__$1 = cljs.core.get.call(null,inst_70157,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_70164__$1 = cljs.core.get.call(null,inst_70157,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_70165__$1 = cljs.core.get.call(null,inst_70157,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_70166__$1 = cljs.core.get.call(null,inst_70157,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_70167__$1 = cljs.core.get.call(null,inst_70157,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_70168 = (function (){var construct = inst_70158__$1;
var select = inst_70159__$1;
var block = inst_70160__$1;
var where = inst_70161__$1;
var prefixes = inst_70162__$1;
var selectDistinct = inst_70163__$1;
var selectOne = inst_70164__$1;
var from = inst_70165__$1;
var map__70155 = inst_70157;
var opts = inst_70166__$1;
var selectReduced = inst_70167__$1;
return (function (p1__70148_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__70148_SHARP_);
});
})();
var inst_70169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70170 = [inst_70159__$1,inst_70164__$1,inst_70163__$1,inst_70167__$1];
var inst_70171 = (new cljs.core.PersistentVector(null,4,(5),inst_70169,inst_70170,null));
var inst_70172 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_70171);
var inst_70173 = cljs.core.count.call(null,inst_70172);
var inst_70174 = inst_70168.call(null,inst_70173);
var state_70280__$1 = (function (){var statearr_70325 = state_70280;
(statearr_70325[(16)] = inst_70160__$1);

(statearr_70325[(20)] = inst_70166__$1);

(statearr_70325[(7)] = inst_70159__$1);

(statearr_70325[(18)] = inst_70161__$1);

(statearr_70325[(14)] = inst_70163__$1);

(statearr_70325[(23)] = inst_70158__$1);

(statearr_70325[(19)] = inst_70164__$1);

(statearr_70325[(9)] = inst_70165__$1);

(statearr_70325[(17)] = inst_70167__$1);

(statearr_70325[(11)] = inst_70162__$1);

return statearr_70325;
})();
if(cljs.core.truth_(inst_70174)){
var statearr_70326_70399 = state_70280__$1;
(statearr_70326_70399[(1)] = (6));

} else {
var statearr_70327_70400 = state_70280__$1;
(statearr_70327_70400[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (23))){
var inst_70166 = (state_70280[(20)]);
var inst_70221 = (state_70280[(8)]);
var inst_70220 = (state_70280[(2)]);
var inst_70221__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_70166);
var state_70280__$1 = (function (){var statearr_70328 = state_70280;
(statearr_70328[(24)] = inst_70220);

(statearr_70328[(8)] = inst_70221__$1);

return statearr_70328;
})();
if(cljs.core.truth_(inst_70221__$1)){
var statearr_70329_70401 = state_70280__$1;
(statearr_70329_70401[(1)] = (24));

} else {
var statearr_70330_70402 = state_70280__$1;
(statearr_70330_70402[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (47))){
var inst_70226 = (state_70280[(25)]);
var inst_70200 = (state_70280[(10)]);
var inst_70259 = (state_70280[(2)]);
var inst_70260 = fluree.db.util.core.current_time_millis.call(null);
var inst_70261 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_70226);
var inst_70262 = fluree.db.query.fql.query.call(null,inst_70200,inst_70261);
var state_70280__$1 = (function (){var statearr_70331 = state_70280;
(statearr_70331[(26)] = inst_70259);

(statearr_70331[(27)] = inst_70260);

return statearr_70331;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70280__$1,(48),inst_70262);
} else {
if((state_val_70281 === (35))){
var inst_70238 = (state_70280[(2)]);
var state_70280__$1 = state_70280;
var statearr_70332_70403 = state_70280__$1;
(statearr_70332_70403[(2)] = inst_70238);

(statearr_70332_70403[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (19))){
var inst_70210 = (state_70280[(12)]);
var state_70280__$1 = state_70280;
var statearr_70333_70404 = state_70280__$1;
(statearr_70333_70404[(2)] = inst_70210);

(statearr_70333_70404[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (11))){
var inst_70162 = (state_70280[(11)]);
var inst_70200 = (state_70280[(2)]);
var state_70280__$1 = (function (){var statearr_70335 = state_70280;
(statearr_70335[(10)] = inst_70200);

return statearr_70335;
})();
if(cljs.core.truth_(inst_70162)){
var statearr_70336_70405 = state_70280__$1;
(statearr_70336_70405[(1)] = (15));

} else {
var statearr_70337_70406 = state_70280__$1;
(statearr_70337_70406[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (9))){
var inst_70186 = (state_70280[(28)]);
var state_70280__$1 = state_70280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70280__$1,(13),inst_70186);
} else {
if((state_val_70281 === (5))){
var _ = (function (){var statearr_70338 = state_70280;
(statearr_70338[(4)] = cljs.core.rest.call(null,(state_70280[(4)])));

return statearr_70338;
})();
var state_70280__$1 = state_70280;
var ex70334 = (state_70280__$1[(2)]);
var statearr_70339_70407 = state_70280__$1;
(statearr_70339_70407[(5)] = ex70334);


if((ex70334 instanceof Error)){
var statearr_70340_70408 = state_70280__$1;
(statearr_70340_70408[(1)] = (4));

(statearr_70340_70408[(5)] = null);

} else {
throw ex70334;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (14))){
var inst_70197 = (state_70280[(2)]);
var inst_70198 = fluree.db.util.async.throw_err.call(null,inst_70197);
var state_70280__$1 = state_70280;
var statearr_70341_70409 = state_70280__$1;
(statearr_70341_70409[(2)] = inst_70198);

(statearr_70341_70409[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (45))){
var state_70280__$1 = state_70280;
var statearr_70342_70410 = state_70280__$1;
(statearr_70342_70410[(2)] = null);

(statearr_70342_70410[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (26))){
var inst_70166 = (state_70280[(20)]);
var inst_70159 = (state_70280[(7)]);
var inst_70220 = (state_70280[(24)]);
var inst_70209 = (state_70280[(22)]);
var inst_70225 = (state_70280[(2)]);
var inst_70226 = cljs.core.assoc.call(null,inst_70166,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_70209,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_70225,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_70220);
var state_70280__$1 = (function (){var statearr_70343 = state_70280;
(statearr_70343[(25)] = inst_70226);

return statearr_70343;
})();
if(cljs.core.truth_(inst_70159)){
var statearr_70344_70411 = state_70280__$1;
(statearr_70344_70411[(1)] = (27));

} else {
var statearr_70345_70412 = state_70280__$1;
(statearr_70345_70412[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (16))){
var inst_70207 = cljs.core.PersistentHashMap.EMPTY;
var state_70280__$1 = state_70280;
var statearr_70346_70413 = state_70280__$1;
(statearr_70346_70413[(2)] = inst_70207);

(statearr_70346_70413[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (38))){
var inst_70236 = (state_70280[(2)]);
var state_70280__$1 = state_70280;
var statearr_70347_70414 = state_70280__$1;
(statearr_70347_70414[(2)] = inst_70236);

(statearr_70347_70414[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (30))){
var inst_70164 = (state_70280[(19)]);
var state_70280__$1 = state_70280;
var statearr_70348_70415 = state_70280__$1;
(statearr_70348_70415[(2)] = inst_70164);

(statearr_70348_70415[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (10))){
var inst_70186 = (state_70280[(28)]);
var state_70280__$1 = state_70280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70280__$1,(14),inst_70186);
} else {
if((state_val_70281 === (18))){
var inst_70211 = (state_70280[(21)]);
var state_70280__$1 = state_70280;
var statearr_70349_70416 = state_70280__$1;
(statearr_70349_70416[(2)] = inst_70211);

(statearr_70349_70416[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (42))){
var inst_70165 = (state_70280[(9)]);
var state_70280__$1 = state_70280;
var statearr_70350_70417 = state_70280__$1;
(statearr_70350_70417[(2)] = inst_70165);

(statearr_70350_70417[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (37))){
var inst_70158 = (state_70280[(23)]);
var state_70280__$1 = state_70280;
var statearr_70351_70418 = state_70280__$1;
(statearr_70351_70418[(2)] = inst_70158);

(statearr_70351_70418[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (8))){
var inst_70160 = (state_70280[(16)]);
var inst_70185 = (state_70280[(2)]);
var inst_70186 = sources;
var state_70280__$1 = (function (){var statearr_70352 = state_70280;
(statearr_70352[(29)] = inst_70185);

(statearr_70352[(28)] = inst_70186);

return statearr_70352;
})();
if(cljs.core.truth_(inst_70160)){
var statearr_70353_70419 = state_70280__$1;
(statearr_70353_70419[(1)] = (9));

} else {
var statearr_70354_70420 = state_70280__$1;
(statearr_70354_70420[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70281 === (49))){
var inst_70200 = (state_70280[(10)]);
var inst_70220 = (state_70280[(24)]);
var inst_70265 = (state_70280[(13)]);
var inst_70260 = (state_70280[(27)]);
var inst_70267 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70268 = cljs.core.deref.call(null,inst_70220);
var inst_70269 = fluree.db.util.core.response_time_formatted.call(null,inst_70260);
var inst_70270 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_70200);
var inst_70271 = [(200),inst_70265,inst_70268,inst_70269,inst_70270];
var inst_70272 = cljs.core.PersistentHashMap.fromArrays(inst_70267,inst_70271);
var state_70280__$1 = state_70280;
var statearr_70355_70421 = state_70280__$1;
(statearr_70355_70421[(2)] = inst_70272);

(statearr_70355_70421[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_70356 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70356[(0)] = fluree$db$api$query$query_async_$_state_machine__2746__auto__);

(statearr_70356[(1)] = (1));

return statearr_70356;
});
var fluree$db$api$query$query_async_$_state_machine__2746__auto____1 = (function (state_70280){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70280);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70357){var ex__2749__auto__ = e70357;
var statearr_70358_70422 = state_70280;
(statearr_70358_70422[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70280[(4)]))){
var statearr_70359_70423 = state_70280;
(statearr_70359_70423[(1)] = cljs.core.first.call(null,(state_70280[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70424 = state_70280;
state_70280 = G__70424;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2746__auto__ = function(state_70280){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2746__auto____1.call(this,state_70280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70360 = f__2769__auto__.call(null);
(statearr_70360[(6)] = c__2768__auto__);

return statearr_70360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70565){
var state_val_70566 = (state_70565[(1)]);
if((state_val_70566 === (7))){
var inst_70560 = (state_70565[(2)]);
var _ = (function (){var statearr_70567 = state_70565;
(statearr_70567[(4)] = cljs.core.rest.call(null,(state_70565[(4)])));

return statearr_70567;
})();
var state_70565__$1 = state_70565;
var statearr_70568_70644 = state_70565__$1;
(statearr_70568_70644[(2)] = inst_70560);

(statearr_70568_70644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (20))){
var inst_70532 = (state_70565[(2)]);
var state_70565__$1 = state_70565;
var statearr_70569_70645 = state_70565__$1;
(statearr_70569_70645[(2)] = inst_70532);

(statearr_70569_70645[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (27))){
var inst_70512 = (state_70565[(7)]);
var state_70565__$1 = state_70565;
var statearr_70570_70646 = state_70565__$1;
(statearr_70570_70646[(2)] = inst_70512);

(statearr_70570_70646[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (1))){
var state_70565__$1 = state_70565;
var statearr_70571_70647 = state_70565__$1;
(statearr_70571_70647[(2)] = null);

(statearr_70571_70647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (24))){
var inst_70509 = (state_70565[(8)]);
var state_70565__$1 = state_70565;
var statearr_70572_70648 = state_70565__$1;
(statearr_70572_70648[(2)] = inst_70509);

(statearr_70572_70648[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (39))){
var inst_70466 = (state_70565[(9)]);
var inst_70499 = (state_70565[(10)]);
var inst_70477 = (state_70565[(11)]);
var inst_70543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70544 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_70477];
var inst_70545 = (new cljs.core.PersistentVector(null,2,(5),inst_70543,inst_70544,null));
var inst_70546 = cljs.core.assoc_in.call(null,inst_70466,inst_70545,inst_70499);
var state_70565__$1 = state_70565;
var statearr_70573_70649 = state_70565__$1;
(statearr_70573_70649[(2)] = inst_70546);

(statearr_70573_70649[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (4))){
var inst_70425 = (state_70565[(2)]);
var state_70565__$1 = state_70565;
var statearr_70574_70650 = state_70565__$1;
(statearr_70574_70650[(2)] = inst_70425);

(statearr_70574_70650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (15))){
var inst_70464 = (state_70565[(12)]);
var inst_70499 = (state_70565[(10)]);
var inst_70502 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_70499);
var inst_70503 = (inst_70464 == null);
var state_70565__$1 = (function (){var statearr_70575 = state_70565;
(statearr_70575[(13)] = inst_70502);

return statearr_70575;
})();
if(cljs.core.truth_(inst_70503)){
var statearr_70576_70651 = state_70565__$1;
(statearr_70576_70651[(1)] = (18));

} else {
var statearr_70577_70652 = state_70565__$1;
(statearr_70577_70652[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (21))){
var inst_70502 = (state_70565[(13)]);
var state_70565__$1 = state_70565;
var statearr_70578_70653 = state_70565__$1;
(statearr_70578_70653[(2)] = inst_70502);

(statearr_70578_70653[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (31))){
var state_70565__$1 = state_70565;
var statearr_70579_70654 = state_70565__$1;
(statearr_70579_70654[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (32))){
var inst_70528 = (state_70565[(2)]);
var state_70565__$1 = state_70565;
var statearr_70581_70655 = state_70565__$1;
(statearr_70581_70655[(2)] = inst_70528);

(statearr_70581_70655[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (40))){
var inst_70497 = (state_70565[(14)]);
var state_70565__$1 = state_70565;
if(cljs.core.truth_(inst_70497)){
var statearr_70582_70656 = state_70565__$1;
(statearr_70582_70656[(1)] = (42));

} else {
var statearr_70583_70657 = state_70565__$1;
(statearr_70583_70657[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (33))){
var inst_70464 = (state_70565[(12)]);
var inst_70502 = (state_70565[(13)]);
var inst_70523 = ((inst_70502 > inst_70464) ? inst_70502 : inst_70464);
var state_70565__$1 = state_70565;
var statearr_70584_70658 = state_70565__$1;
(statearr_70584_70658[(2)] = inst_70523);

(statearr_70584_70658[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (13))){
var inst_70488 = (state_70565[(2)]);
var state_70565__$1 = state_70565;
var statearr_70585_70659 = state_70565__$1;
(statearr_70585_70659[(2)] = inst_70488);

(statearr_70585_70659[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (22))){
var inst_70509 = (state_70565[(8)]);
var inst_70502 = (state_70565[(13)]);
var inst_70509__$1 = cljs.core._EQ_.call(null,(200),inst_70502);
var state_70565__$1 = (function (){var statearr_70586 = state_70565;
(statearr_70586[(8)] = inst_70509__$1);

return statearr_70586;
})();
if(inst_70509__$1){
var statearr_70587_70660 = state_70565__$1;
(statearr_70587_70660[(1)] = (24));

} else {
var statearr_70588_70661 = state_70565__$1;
(statearr_70588_70661[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (36))){
var inst_70499 = (state_70565[(10)]);
var inst_70465 = (state_70565[(15)]);
var inst_70537 = cljs.core.get.call(null,inst_70499,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_70538 = (inst_70465 + inst_70537);
var state_70565__$1 = state_70565;
var statearr_70589_70662 = state_70565__$1;
(statearr_70589_70662[(2)] = inst_70538);

(statearr_70589_70662[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (41))){
var inst_70476 = (state_70565[(16)]);
var inst_70535 = (state_70565[(17)]);
var inst_70541 = (state_70565[(18)]);
var inst_70555 = (state_70565[(2)]);
var inst_70463 = inst_70476;
var inst_70464 = inst_70535;
var inst_70465 = inst_70541;
var inst_70466 = inst_70555;
var state_70565__$1 = (function (){var statearr_70590 = state_70565;
(statearr_70590[(9)] = inst_70466);

(statearr_70590[(12)] = inst_70464);

(statearr_70590[(15)] = inst_70465);

(statearr_70590[(19)] = inst_70463);

return statearr_70590;
})();
var statearr_70591_70663 = state_70565__$1;
(statearr_70591_70663[(2)] = null);

(statearr_70591_70663[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (43))){
var inst_70499 = (state_70565[(10)]);
var state_70565__$1 = state_70565;
var statearr_70592_70664 = state_70565__$1;
(statearr_70592_70664[(2)] = inst_70499);

(statearr_70592_70664[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (29))){
var inst_70517 = (state_70565[(2)]);
var state_70565__$1 = state_70565;
var statearr_70593_70665 = state_70565__$1;
(statearr_70593_70665[(2)] = inst_70517);

(statearr_70593_70665[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (44))){
var inst_70466 = (state_70565[(9)]);
var inst_70477 = (state_70565[(11)]);
var inst_70552 = (state_70565[(2)]);
var inst_70553 = cljs.core.assoc.call(null,inst_70466,inst_70477,inst_70552);
var state_70565__$1 = state_70565;
var statearr_70594_70666 = state_70565__$1;
(statearr_70594_70666[(2)] = inst_70553);

(statearr_70594_70666[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (6))){
var inst_70478 = (state_70565[(20)]);
var inst_70463 = (state_70565[(19)]);
var inst_70474 = cljs.core.seq.call(null,inst_70463);
var inst_70475 = cljs.core.first.call(null,inst_70474);
var inst_70476 = cljs.core.next.call(null,inst_70474);
var inst_70477 = cljs.core.nth.call(null,inst_70475,(0),null);
var inst_70478__$1 = cljs.core.nth.call(null,inst_70475,(1),null);
var inst_70479 = (inst_70478__$1 == null);
var state_70565__$1 = (function (){var statearr_70595 = state_70565;
(statearr_70595[(16)] = inst_70476);

(statearr_70595[(20)] = inst_70478__$1);

(statearr_70595[(11)] = inst_70477);

return statearr_70595;
})();
if(cljs.core.truth_(inst_70479)){
var statearr_70596_70667 = state_70565__$1;
(statearr_70596_70667[(1)] = (8));

} else {
var statearr_70597_70668 = state_70565__$1;
(statearr_70597_70668[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (28))){
var inst_70464 = (state_70565[(12)]);
var inst_70515 = cljs.core._EQ_.call(null,(207),inst_70464);
var state_70565__$1 = state_70565;
var statearr_70598_70669 = state_70565__$1;
(statearr_70598_70669[(2)] = inst_70515);

(statearr_70598_70669[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (25))){
var inst_70464 = (state_70565[(12)]);
var inst_70512 = (state_70565[(7)]);
var inst_70512__$1 = cljs.core._EQ_.call(null,(200),inst_70464);
var state_70565__$1 = (function (){var statearr_70599 = state_70565;
(statearr_70599[(7)] = inst_70512__$1);

return statearr_70599;
})();
if(inst_70512__$1){
var statearr_70600_70670 = state_70565__$1;
(statearr_70600_70670[(1)] = (27));

} else {
var statearr_70601_70671 = state_70565__$1;
(statearr_70601_70671[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (34))){
var state_70565__$1 = state_70565;
var statearr_70602_70672 = state_70565__$1;
(statearr_70602_70672[(2)] = null);

(statearr_70602_70672[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (17))){
var inst_70496 = (state_70565[(21)]);
var inst_70535 = (state_70565[(2)]);
var state_70565__$1 = (function (){var statearr_70603 = state_70565;
(statearr_70603[(17)] = inst_70535);

return statearr_70603;
})();
if(cljs.core.truth_(inst_70496)){
var statearr_70604_70673 = state_70565__$1;
(statearr_70604_70673[(1)] = (36));

} else {
var statearr_70605_70674 = state_70565__$1;
(statearr_70605_70674[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (3))){
var inst_70563 = (state_70565[(2)]);
var state_70565__$1 = state_70565;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70565__$1,inst_70563);
} else {
if((state_val_70566 === (12))){
var inst_70466 = (state_70565[(9)]);
var state_70565__$1 = state_70565;
var statearr_70606_70675 = state_70565__$1;
(statearr_70606_70675[(2)] = inst_70466);

(statearr_70606_70675[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (2))){
var inst_70435 = (state_70565[(22)]);
var inst_70439 = (state_70565[(23)]);
var inst_70440 = (state_70565[(24)]);
var _ = (function (){var statearr_70607 = state_70565;
(statearr_70607[(4)] = cljs.core.cons.call(null,(5),(state_70565[(4)])));

return statearr_70607;
})();
var inst_70431 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_70432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70433 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_70434 = (new cljs.core.PersistentVector(null,2,(5),inst_70432,inst_70433,null));
var inst_70435__$1 = cljs.core.get_in.call(null,flureeQL,inst_70434);
var inst_70436 = (function (){var global_block = inst_70431;
var global_meta_QMARK_ = inst_70435__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4253__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4251__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__4251__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_70437 = cljs.core.PersistentHashMap.EMPTY;
var inst_70438 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_70439__$1 = cljs.core.reduce_kv.call(null,inst_70436,inst_70437,inst_70438);
var inst_70440__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_70442 = (function (){var global_block = inst_70431;
var global_meta_QMARK_ = inst_70435__$1;
var queries = inst_70439__$1;
var start_time = inst_70440__$1;
return (function (p__70441){
var vec__70608 = p__70441;
var alias = cljs.core.nth.call(null,vec__70608,(0),null);
var q = cljs.core.nth.call(null,vec__70608,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_70443 = cljs.core.map.call(null,inst_70442,inst_70439__$1);
var inst_70457 = cljs.core.seq.call(null,inst_70443);
var inst_70458 = cljs.core.first.call(null,inst_70457);
var inst_70459 = cljs.core.next.call(null,inst_70457);
var inst_70460 = cljs.core.nth.call(null,inst_70458,(0),null);
var inst_70461 = cljs.core.nth.call(null,inst_70458,(1),null);
var inst_70462 = cljs.core.PersistentHashMap.EMPTY;
var inst_70463 = inst_70443;
var inst_70464 = null;
var inst_70465 = (0);
var inst_70466 = inst_70462;
var state_70565__$1 = (function (){var statearr_70611 = state_70565;
(statearr_70611[(25)] = inst_70461);

(statearr_70611[(9)] = inst_70466);

(statearr_70611[(12)] = inst_70464);

(statearr_70611[(15)] = inst_70465);

(statearr_70611[(26)] = inst_70459);

(statearr_70611[(19)] = inst_70463);

(statearr_70611[(27)] = inst_70460);

(statearr_70611[(22)] = inst_70435__$1);

(statearr_70611[(23)] = inst_70439__$1);

(statearr_70611[(24)] = inst_70440__$1);

return statearr_70611;
})();
var statearr_70612_70676 = state_70565__$1;
(statearr_70612_70676[(2)] = null);

(statearr_70612_70676[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (23))){
var inst_70530 = (state_70565[(2)]);
var state_70565__$1 = state_70565;
var statearr_70613_70677 = state_70565__$1;
(statearr_70613_70677[(2)] = inst_70530);

(statearr_70613_70677[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (35))){
var inst_70526 = (state_70565[(2)]);
var state_70565__$1 = state_70565;
var statearr_70614_70678 = state_70565__$1;
(statearr_70614_70678[(2)] = inst_70526);

(statearr_70614_70678[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (19))){
var inst_70464 = (state_70565[(12)]);
var inst_70502 = (state_70565[(13)]);
var inst_70506 = cljs.core._EQ_.call(null,inst_70464,inst_70502);
var state_70565__$1 = state_70565;
if(inst_70506){
var statearr_70615_70679 = state_70565__$1;
(statearr_70615_70679[(1)] = (21));

} else {
var statearr_70616_70680 = state_70565__$1;
(statearr_70616_70680[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (11))){
var inst_70466 = (state_70565[(9)]);
var inst_70464 = (state_70565[(12)]);
var inst_70465 = (state_70565[(15)]);
var inst_70440 = (state_70565[(24)]);
var inst_70482 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_70483 = fluree.db.util.core.response_time_formatted.call(null,inst_70440);
var inst_70484 = [inst_70466,inst_70465,inst_70464,inst_70483];
var inst_70485 = cljs.core.PersistentHashMap.fromArrays(inst_70482,inst_70484);
var state_70565__$1 = state_70565;
var statearr_70618_70681 = state_70565__$1;
(statearr_70618_70681[(2)] = inst_70485);

(statearr_70618_70681[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (9))){
var inst_70478 = (state_70565[(20)]);
var inst_70477 = (state_70565[(11)]);
var inst_70439 = (state_70565[(23)]);
var inst_70491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70492 = [inst_70477,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_70493 = (new cljs.core.PersistentVector(null,2,(5),inst_70491,inst_70492,null));
var inst_70494 = cljs.core.get_in.call(null,inst_70439,inst_70493);
var inst_70495 = cljs.core.__destructure_map.call(null,inst_70494);
var inst_70496 = cljs.core.get.call(null,inst_70495,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_70497 = cljs.core.get.call(null,inst_70495,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_70565__$1 = (function (){var statearr_70619 = state_70565;
(statearr_70619[(21)] = inst_70496);

(statearr_70619[(14)] = inst_70497);

return statearr_70619;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70565__$1,(14),inst_70478);
} else {
if((state_val_70566 === (5))){
var _ = (function (){var statearr_70620 = state_70565;
(statearr_70620[(4)] = cljs.core.rest.call(null,(state_70565[(4)])));

return statearr_70620;
})();
var state_70565__$1 = state_70565;
var ex70617 = (state_70565__$1[(2)]);
var statearr_70621_70682 = state_70565__$1;
(statearr_70621_70682[(5)] = ex70617);


var statearr_70622_70683 = state_70565__$1;
(statearr_70622_70683[(1)] = (4));

(statearr_70622_70683[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (14))){
var inst_70496 = (state_70565[(21)]);
var inst_70499 = (state_70565[(10)]);
var inst_70499__$1 = (state_70565[(2)]);
var inst_70500 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_70499__$1);
var state_70565__$1 = (function (){var statearr_70623 = state_70565;
(statearr_70623[(28)] = inst_70500);

(statearr_70623[(10)] = inst_70499__$1);

return statearr_70623;
})();
if(cljs.core.truth_(inst_70496)){
var statearr_70624_70684 = state_70565__$1;
(statearr_70624_70684[(1)] = (15));

} else {
var statearr_70625_70685 = state_70565__$1;
(statearr_70625_70685[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (26))){
var inst_70519 = (state_70565[(2)]);
var state_70565__$1 = state_70565;
if(cljs.core.truth_(inst_70519)){
var statearr_70626_70686 = state_70565__$1;
(statearr_70626_70686[(1)] = (30));

} else {
var statearr_70627_70687 = state_70565__$1;
(statearr_70627_70687[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (16))){
var state_70565__$1 = state_70565;
var statearr_70628_70688 = state_70565__$1;
(statearr_70628_70688[(2)] = null);

(statearr_70628_70688[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (38))){
var inst_70500 = (state_70565[(28)]);
var inst_70541 = (state_70565[(2)]);
var state_70565__$1 = (function (){var statearr_70629 = state_70565;
(statearr_70629[(18)] = inst_70541);

return statearr_70629;
})();
if(cljs.core.truth_(inst_70500)){
var statearr_70630_70689 = state_70565__$1;
(statearr_70630_70689[(1)] = (39));

} else {
var statearr_70631_70690 = state_70565__$1;
(statearr_70631_70690[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (30))){
var state_70565__$1 = state_70565;
var statearr_70632_70691 = state_70565__$1;
(statearr_70632_70691[(2)] = (207));

(statearr_70632_70691[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (10))){
var inst_70558 = (state_70565[(2)]);
var state_70565__$1 = state_70565;
var statearr_70633_70692 = state_70565__$1;
(statearr_70633_70692[(2)] = inst_70558);

(statearr_70633_70692[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (18))){
var inst_70502 = (state_70565[(13)]);
var state_70565__$1 = state_70565;
var statearr_70634_70693 = state_70565__$1;
(statearr_70634_70693[(2)] = inst_70502);

(statearr_70634_70693[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (42))){
var inst_70499 = (state_70565[(10)]);
var inst_70549 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_70499);
var state_70565__$1 = state_70565;
var statearr_70635_70694 = state_70565__$1;
(statearr_70635_70694[(2)] = inst_70549);

(statearr_70635_70694[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (37))){
var state_70565__$1 = state_70565;
var statearr_70636_70695 = state_70565__$1;
(statearr_70636_70695[(2)] = null);

(statearr_70636_70695[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70566 === (8))){
var inst_70435 = (state_70565[(22)]);
var state_70565__$1 = state_70565;
if(cljs.core.truth_(inst_70435)){
var statearr_70637_70696 = state_70565__$1;
(statearr_70637_70696[(1)] = (11));

} else {
var statearr_70638_70697 = state_70565__$1;
(statearr_70638_70697[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_70639 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70639[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__);

(statearr_70639[(1)] = (1));

return statearr_70639;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1 = (function (state_70565){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70565);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70640){var ex__2749__auto__ = e70640;
var statearr_70641_70698 = state_70565;
(statearr_70641_70698[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70565[(4)]))){
var statearr_70642_70699 = state_70565;
(statearr_70642_70699[(1)] = cljs.core.first.call(null,(state_70565[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70700 = state_70565;
state_70565 = G__70700;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__ = function(state_70565){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1.call(this,state_70565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70643 = f__2769__auto__.call(null);
(statearr_70643[(6)] = c__2768__auto__);

return statearr_70643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__70701 = query_type;
var G__70701__$1 = (((G__70701 instanceof cljs.core.Keyword))?G__70701.fqn:null);
switch (G__70701__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__70701__$1)].join('')));

}
});
