// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__70743_70924 = cljs.core.seq.call(null,servers);
var chunk__70744_70925 = null;
var count__70745_70926 = (0);
var i__70746_70927 = (0);
while(true){
if((i__70746_70927 < count__70745_70926)){
var server_70928 = cljs.core._nth.call(null,chunk__70744_70925,i__70746_70927);
var healthcheck_uri_70929 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_70928),"/fdb/health"].join('');
var resp_chan_70930 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_70929,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2768__auto___70931 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__70743_70924,chunk__70744_70925,count__70745_70926,i__70746_70927,c__2768__auto___70931,healthcheck_uri_70929,resp_chan_70930,server_70928){
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = ((function (seq__70743_70924,chunk__70744_70925,count__70745_70926,i__70746_70927,c__2768__auto___70931,healthcheck_uri_70929,resp_chan_70930,server_70928){
return (function (state_70816){
var state_val_70817 = (state_70816[(1)]);
if((state_val_70817 === (1))){
var state_70816__$1 = state_70816;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70816__$1,(2),resp_chan_70930);
} else {
if((state_val_70817 === (2))){
var inst_70802 = (state_70816[(7)]);
var inst_70802__$1 = (state_70816[(2)]);
var inst_70803 = fluree.db.util.core.exception_QMARK_.call(null,inst_70802__$1);
var state_70816__$1 = (function (){var statearr_70818 = state_70816;
(statearr_70818[(7)] = inst_70802__$1);

return statearr_70818;
})();
if(inst_70803){
var statearr_70819_70932 = state_70816__$1;
(statearr_70819_70932[(1)] = (3));

} else {
var statearr_70820_70933 = state_70816__$1;
(statearr_70820_70933[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70817 === (3))){
var inst_70802 = (state_70816[(7)]);
var inst_70805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70806 = cljs.core.ex_message.call(null,inst_70802);
var inst_70807 = cljs.core.ex_data.call(null,inst_70802);
var inst_70808 = ["Server contact error: ",inst_70806,inst_70807];
var inst_70809 = (new cljs.core.PersistentVector(null,3,(5),inst_70805,inst_70808,null));
var inst_70810 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_70809);
var state_70816__$1 = state_70816;
var statearr_70821_70934 = state_70816__$1;
(statearr_70821_70934[(2)] = inst_70810);

(statearr_70821_70934[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70817 === (4))){
var inst_70812 = cljs.core.async.put_BANG_.call(null,promise_chan,server_70928);
var state_70816__$1 = state_70816;
var statearr_70822_70935 = state_70816__$1;
(statearr_70822_70935[(2)] = inst_70812);

(statearr_70822_70935[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70817 === (5))){
var inst_70814 = (state_70816[(2)]);
var state_70816__$1 = state_70816;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70816__$1,inst_70814);
} else {
return null;
}
}
}
}
}
});})(seq__70743_70924,chunk__70744_70925,count__70745_70926,i__70746_70927,c__2768__auto___70931,healthcheck_uri_70929,resp_chan_70930,server_70928))
;
return ((function (seq__70743_70924,chunk__70744_70925,count__70745_70926,i__70746_70927,switch__2745__auto__,c__2768__auto___70931,healthcheck_uri_70929,resp_chan_70930,server_70928){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_70823 = [null,null,null,null,null,null,null,null];
(statearr_70823[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_70823[(1)] = (1));

return statearr_70823;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_70816){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70816);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70824){var ex__2749__auto__ = e70824;
var statearr_70825_70936 = state_70816;
(statearr_70825_70936[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70816[(4)]))){
var statearr_70826_70937 = state_70816;
(statearr_70826_70937[(1)] = cljs.core.first.call(null,(state_70816[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70938 = state_70816;
state_70816 = G__70938;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_70816){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_70816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
;})(seq__70743_70924,chunk__70744_70925,count__70745_70926,i__70746_70927,switch__2745__auto__,c__2768__auto___70931,healthcheck_uri_70929,resp_chan_70930,server_70928))
})();
var state__2770__auto__ = (function (){var statearr_70827 = f__2769__auto__.call(null);
(statearr_70827[(6)] = c__2768__auto___70931);

return statearr_70827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});})(seq__70743_70924,chunk__70744_70925,count__70745_70926,i__70746_70927,c__2768__auto___70931,healthcheck_uri_70929,resp_chan_70930,server_70928))
);



var G__70939 = seq__70743_70924;
var G__70940 = chunk__70744_70925;
var G__70941 = count__70745_70926;
var G__70942 = (i__70746_70927 + (1));
seq__70743_70924 = G__70939;
chunk__70744_70925 = G__70940;
count__70745_70926 = G__70941;
i__70746_70927 = G__70942;
continue;
} else {
var temp__5804__auto___70943 = cljs.core.seq.call(null,seq__70743_70924);
if(temp__5804__auto___70943){
var seq__70743_70944__$1 = temp__5804__auto___70943;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__70743_70944__$1)){
var c__4679__auto___70945 = cljs.core.chunk_first.call(null,seq__70743_70944__$1);
var G__70946 = cljs.core.chunk_rest.call(null,seq__70743_70944__$1);
var G__70947 = c__4679__auto___70945;
var G__70948 = cljs.core.count.call(null,c__4679__auto___70945);
var G__70949 = (0);
seq__70743_70924 = G__70946;
chunk__70744_70925 = G__70947;
count__70745_70926 = G__70948;
i__70746_70927 = G__70949;
continue;
} else {
var server_70950 = cljs.core.first.call(null,seq__70743_70944__$1);
var healthcheck_uri_70951 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_70950),"/fdb/health"].join('');
var resp_chan_70952 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_70951,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2768__auto___70953 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__70743_70924,chunk__70744_70925,count__70745_70926,i__70746_70927,c__2768__auto___70953,healthcheck_uri_70951,resp_chan_70952,server_70950,seq__70743_70944__$1,temp__5804__auto___70943){
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = ((function (seq__70743_70924,chunk__70744_70925,count__70745_70926,i__70746_70927,c__2768__auto___70953,healthcheck_uri_70951,resp_chan_70952,server_70950,seq__70743_70944__$1,temp__5804__auto___70943){
return (function (state_70843){
var state_val_70844 = (state_70843[(1)]);
if((state_val_70844 === (1))){
var state_70843__$1 = state_70843;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70843__$1,(2),resp_chan_70952);
} else {
if((state_val_70844 === (2))){
var inst_70829 = (state_70843[(7)]);
var inst_70829__$1 = (state_70843[(2)]);
var inst_70830 = fluree.db.util.core.exception_QMARK_.call(null,inst_70829__$1);
var state_70843__$1 = (function (){var statearr_70845 = state_70843;
(statearr_70845[(7)] = inst_70829__$1);

return statearr_70845;
})();
if(inst_70830){
var statearr_70846_70954 = state_70843__$1;
(statearr_70846_70954[(1)] = (3));

} else {
var statearr_70847_70955 = state_70843__$1;
(statearr_70847_70955[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70844 === (3))){
var inst_70829 = (state_70843[(7)]);
var inst_70832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70833 = cljs.core.ex_message.call(null,inst_70829);
var inst_70834 = cljs.core.ex_data.call(null,inst_70829);
var inst_70835 = ["Server contact error: ",inst_70833,inst_70834];
var inst_70836 = (new cljs.core.PersistentVector(null,3,(5),inst_70832,inst_70835,null));
var inst_70837 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_70836);
var state_70843__$1 = state_70843;
var statearr_70848_70956 = state_70843__$1;
(statearr_70848_70956[(2)] = inst_70837);

(statearr_70848_70956[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70844 === (4))){
var inst_70839 = cljs.core.async.put_BANG_.call(null,promise_chan,server_70950);
var state_70843__$1 = state_70843;
var statearr_70849_70957 = state_70843__$1;
(statearr_70849_70957[(2)] = inst_70839);

(statearr_70849_70957[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70844 === (5))){
var inst_70841 = (state_70843[(2)]);
var state_70843__$1 = state_70843;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70843__$1,inst_70841);
} else {
return null;
}
}
}
}
}
});})(seq__70743_70924,chunk__70744_70925,count__70745_70926,i__70746_70927,c__2768__auto___70953,healthcheck_uri_70951,resp_chan_70952,server_70950,seq__70743_70944__$1,temp__5804__auto___70943))
;
return ((function (seq__70743_70924,chunk__70744_70925,count__70745_70926,i__70746_70927,switch__2745__auto__,c__2768__auto___70953,healthcheck_uri_70951,resp_chan_70952,server_70950,seq__70743_70944__$1,temp__5804__auto___70943){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_70850 = [null,null,null,null,null,null,null,null];
(statearr_70850[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_70850[(1)] = (1));

return statearr_70850;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_70843){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70843);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70851){var ex__2749__auto__ = e70851;
var statearr_70852_70958 = state_70843;
(statearr_70852_70958[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70843[(4)]))){
var statearr_70853_70959 = state_70843;
(statearr_70853_70959[(1)] = cljs.core.first.call(null,(state_70843[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70960 = state_70843;
state_70843 = G__70960;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_70843){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_70843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
;})(seq__70743_70924,chunk__70744_70925,count__70745_70926,i__70746_70927,switch__2745__auto__,c__2768__auto___70953,healthcheck_uri_70951,resp_chan_70952,server_70950,seq__70743_70944__$1,temp__5804__auto___70943))
})();
var state__2770__auto__ = (function (){var statearr_70854 = f__2769__auto__.call(null);
(statearr_70854[(6)] = c__2768__auto___70953);

return statearr_70854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});})(seq__70743_70924,chunk__70744_70925,count__70745_70926,i__70746_70927,c__2768__auto___70953,healthcheck_uri_70951,resp_chan_70952,server_70950,seq__70743_70944__$1,temp__5804__auto___70943))
);



var G__70961 = cljs.core.next.call(null,seq__70743_70944__$1);
var G__70962 = null;
var G__70963 = (0);
var G__70964 = (0);
seq__70743_70924 = G__70961;
chunk__70744_70925 = G__70962;
count__70745_70926 = G__70963;
i__70746_70927 = G__70964;
continue;
}
} else {
}
}
break;
}

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70898){
var state_val_70899 = (state_70898[(1)]);
if((state_val_70899 === (7))){
var inst_70870 = (state_70898[(7)]);
var inst_70877 = cljs.core._EQ_.call(null,inst_70870,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_70898__$1 = state_70898;
if(inst_70877){
var statearr_70900_70965 = state_70898__$1;
(statearr_70900_70965[(1)] = (9));

} else {
var statearr_70901_70966 = state_70898__$1;
(statearr_70901_70966[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70899 === (1))){
var inst_70862 = (state_70898[(8)]);
var inst_70863 = (state_70898[(9)]);
var inst_70862__$1 = promise_chan;
var inst_70863__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_70864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70865 = [inst_70862__$1,inst_70863__$1];
var inst_70866 = (new cljs.core.PersistentVector(null,2,(5),inst_70864,inst_70865,null));
var state_70898__$1 = (function (){var statearr_70902 = state_70898;
(statearr_70902[(8)] = inst_70862__$1);

(statearr_70902[(9)] = inst_70863__$1);

return statearr_70902;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_70898__$1,(2),inst_70866);
} else {
if((state_val_70899 === (4))){
var inst_70863 = (state_70898[(9)]);
var inst_70870 = (state_70898[(7)]);
var inst_70874 = cljs.core._EQ_.call(null,inst_70870,inst_70863);
var state_70898__$1 = state_70898;
if(inst_70874){
var statearr_70903_70967 = state_70898__$1;
(statearr_70903_70967[(1)] = (6));

} else {
var statearr_70904_70968 = state_70898__$1;
(statearr_70904_70968[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70899 === (13))){
var state_70898__$1 = state_70898;
var statearr_70905_70969 = state_70898__$1;
(statearr_70905_70969[(2)] = null);

(statearr_70905_70969[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70899 === (6))){
var state_70898__$1 = state_70898;
var statearr_70906_70970 = state_70898__$1;
(statearr_70906_70970[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_70906_70970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70899 === (3))){
var state_70898__$1 = state_70898;
var statearr_70907_70971 = state_70898__$1;
(statearr_70907_70971[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_70907_70971[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70899 === (12))){
var inst_70888 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_70889 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70890 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_70891 = cljs.core.PersistentHashMap.fromArrays(inst_70889,inst_70890);
var inst_70892 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_70891);
var inst_70893 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_70892);
var state_70898__$1 = (function (){var statearr_70908 = state_70898;
(statearr_70908[(10)] = inst_70888);

return statearr_70908;
})();
var statearr_70909_70972 = state_70898__$1;
(statearr_70909_70972[(2)] = inst_70893);

(statearr_70909_70972[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70899 === (2))){
var inst_70862 = (state_70898[(8)]);
var inst_70870 = (state_70898[(7)]);
var inst_70868 = (state_70898[(2)]);
var inst_70869 = cljs.core.nth.call(null,inst_70868,(0),null);
var inst_70870__$1 = cljs.core.nth.call(null,inst_70868,(1),null);
var inst_70871 = cljs.core._EQ_.call(null,inst_70870__$1,inst_70862);
var state_70898__$1 = (function (){var statearr_70910 = state_70898;
(statearr_70910[(11)] = inst_70869);

(statearr_70910[(7)] = inst_70870__$1);

return statearr_70910;
})();
if(inst_70871){
var statearr_70911_70973 = state_70898__$1;
(statearr_70911_70973[(1)] = (3));

} else {
var statearr_70912_70974 = state_70898__$1;
(statearr_70912_70974[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70899 === (11))){
var inst_70881 = (state_70898[(2)]);
var state_70898__$1 = state_70898;
var statearr_70913_70975 = state_70898__$1;
(statearr_70913_70975[(2)] = inst_70881);

(statearr_70913_70975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70899 === (9))){
var inst_70869 = (state_70898[(11)]);
var state_70898__$1 = state_70898;
var statearr_70914_70976 = state_70898__$1;
(statearr_70914_70976[(2)] = inst_70869);

(statearr_70914_70976[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70899 === (5))){
var inst_70885 = (state_70898[(2)]);
var inst_70886 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_70885);
var state_70898__$1 = state_70898;
if(inst_70886){
var statearr_70915_70977 = state_70898__$1;
(statearr_70915_70977[(1)] = (12));

} else {
var statearr_70916_70978 = state_70898__$1;
(statearr_70916_70978[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70899 === (14))){
var inst_70896 = (state_70898[(2)]);
var state_70898__$1 = state_70898;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70898__$1,inst_70896);
} else {
if((state_val_70899 === (10))){
var state_70898__$1 = state_70898;
var statearr_70917_70979 = state_70898__$1;
(statearr_70917_70979[(2)] = null);

(statearr_70917_70979[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70899 === (8))){
var inst_70883 = (state_70898[(2)]);
var state_70898__$1 = state_70898;
var statearr_70918_70980 = state_70898__$1;
(statearr_70918_70980[(2)] = inst_70883);

(statearr_70918_70980[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_70919 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70919[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_70919[(1)] = (1));

return statearr_70919;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_70898){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70898);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70920){var ex__2749__auto__ = e70920;
var statearr_70921_70981 = state_70898;
(statearr_70921_70981[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70898[(4)]))){
var statearr_70922_70982 = state_70898;
(statearr_70922_70982[(1)] = cljs.core.first.call(null,(state_70898[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70983 = state_70898;
state_70898 = G__70983;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_70898){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_70898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70923 = f__2769__auto__.call(null);
(statearr_70923[(6)] = c__2768__auto__);

return statearr_70923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71027){
var state_val_71028 = (state_71027[(1)]);
if((state_val_71028 === (7))){
var state_71027__$1 = state_71027;
var statearr_71029_71055 = state_71027__$1;
(statearr_71029_71055[(2)] = null);

(statearr_71029_71055[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71028 === (1))){
var state_71027__$1 = state_71027;
var statearr_71030_71056 = state_71027__$1;
(statearr_71030_71056[(2)] = null);

(statearr_71030_71056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71028 === (4))){
var inst_70984 = (state_71027[(2)]);
var state_71027__$1 = state_71027;
var statearr_71031_71057 = state_71027__$1;
(statearr_71031_71057[(2)] = inst_70984);

(statearr_71031_71057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71028 === (6))){
var inst_71006 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_71027__$1 = state_71027;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71027__$1,(9),inst_71006);
} else {
if((state_val_71028 === (3))){
var inst_71025 = (state_71027[(2)]);
var state_71027__$1 = state_71027;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71027__$1,inst_71025);
} else {
if((state_val_71028 === (12))){
var inst_71019 = (state_71027[(2)]);
var state_71027__$1 = state_71027;
var statearr_71032_71058 = state_71027__$1;
(statearr_71032_71058[(2)] = inst_71019);

(statearr_71032_71058[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71028 === (2))){
var inst_71000 = (state_71027[(7)]);
var inst_70995 = (state_71027[(8)]);
var inst_70990 = (state_71027[(9)]);
var _ = (function (){var statearr_71033 = state_71027;
(statearr_71033[(4)] = cljs.core.cons.call(null,(5),(state_71027[(4)])));

return statearr_71033;
})();
var inst_70990__$1 = cljs.core.random_uuid.call(null);
var inst_70991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70992 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_70993 = (new cljs.core.PersistentVector(null,2,(5),inst_70991,inst_70992,null));
var inst_70994 = (function (){var lock_id = inst_70990__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_70995__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_70993,inst_70994);
var inst_70996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70997 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_70998 = (new cljs.core.PersistentVector(null,3,(5),inst_70996,inst_70997,null));
var inst_70999 = cljs.core.get_in.call(null,inst_70995__$1,inst_70998);
var inst_71000__$1 = cljs.core._EQ_.call(null,inst_70990__$1,inst_70999);
var inst_71001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71002 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_71003 = (new cljs.core.PersistentVector(null,3,(5),inst_71001,inst_71002,null));
var inst_71004 = cljs.core.get_in.call(null,inst_70995__$1,inst_71003);
var state_71027__$1 = (function (){var statearr_71034 = state_71027;
(statearr_71034[(7)] = inst_71000__$1);

(statearr_71034[(8)] = inst_70995__$1);

(statearr_71034[(10)] = inst_71004);

(statearr_71034[(9)] = inst_70990__$1);

return statearr_71034;
})();
if(inst_71000__$1){
var statearr_71035_71059 = state_71027__$1;
(statearr_71035_71059[(1)] = (6));

} else {
var statearr_71036_71060 = state_71027__$1;
(statearr_71036_71060[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71028 === (11))){
var inst_71011 = (state_71027[(11)]);
var inst_71004 = (state_71027[(10)]);
var inst_71010 = (state_71027[(12)]);
var inst_71017 = fluree.db.util.xhttp.try_socket.call(null,inst_71010,sub_chan,pub_chan,inst_71004,(60000),inst_71011);
var state_71027__$1 = state_71027;
var statearr_71038_71061 = state_71027__$1;
(statearr_71038_71061[(2)] = inst_71017);

(statearr_71038_71061[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71028 === (9))){
var inst_71000 = (state_71027[(7)]);
var inst_71008 = (state_71027[(13)]);
var inst_70995 = (state_71027[(8)]);
var inst_71004 = (state_71027[(10)]);
var inst_70990 = (state_71027[(9)]);
var inst_71010 = (state_71027[(12)]);
var inst_71008__$1 = (state_71027[(2)]);
var inst_71009 = clojure.string.replace.call(null,inst_71008__$1,"http","ws");
var inst_71010__$1 = [inst_71009,"/fdb/ws"].join('');
var inst_71011 = (function (){var lock_id = inst_70990;
var state = inst_70995;
var have_lock_QMARK_ = inst_71000;
var resp_chan = inst_71004;
var healthy_server = inst_71008__$1;
var ws_url = inst_71010__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_71012 = fluree.db.util.core.exception_QMARK_.call(null,inst_71008__$1);
var state_71027__$1 = (function (){var statearr_71039 = state_71027;
(statearr_71039[(11)] = inst_71011);

(statearr_71039[(13)] = inst_71008__$1);

(statearr_71039[(12)] = inst_71010__$1);

return statearr_71039;
})();
if(inst_71012){
var statearr_71040_71062 = state_71027__$1;
(statearr_71040_71062[(1)] = (10));

} else {
var statearr_71041_71063 = state_71027__$1;
(statearr_71041_71063[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71028 === (5))){
var _ = (function (){var statearr_71042 = state_71027;
(statearr_71042[(4)] = cljs.core.rest.call(null,(state_71027[(4)])));

return statearr_71042;
})();
var state_71027__$1 = state_71027;
var ex71037 = (state_71027__$1[(2)]);
var statearr_71043_71064 = state_71027__$1;
(statearr_71043_71064[(5)] = ex71037);


if((ex71037 instanceof Error)){
var statearr_71044_71065 = state_71027__$1;
(statearr_71044_71065[(1)] = (4));

(statearr_71044_71065[(5)] = null);

} else {
throw ex71037;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71028 === (10))){
var inst_71008 = (state_71027[(13)]);
var inst_71004 = (state_71027[(10)]);
var inst_71014 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_71015 = cljs.core.async.put_BANG_.call(null,inst_71004,inst_71008);
var state_71027__$1 = (function (){var statearr_71045 = state_71027;
(statearr_71045[(14)] = inst_71014);

return statearr_71045;
})();
var statearr_71046_71066 = state_71027__$1;
(statearr_71046_71066[(2)] = inst_71015);

(statearr_71046_71066[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71028 === (8))){
var inst_71004 = (state_71027[(10)]);
var inst_71022 = (state_71027[(2)]);
var _ = (function (){var statearr_71047 = state_71027;
(statearr_71047[(4)] = cljs.core.rest.call(null,(state_71027[(4)])));

return statearr_71047;
})();
var state_71027__$1 = (function (){var statearr_71048 = state_71027;
(statearr_71048[(15)] = inst_71022);

return statearr_71048;
})();
var statearr_71049_71067 = state_71027__$1;
(statearr_71049_71067[(2)] = inst_71004);

(statearr_71049_71067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2746__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_71050 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71050[(0)] = fluree$db$connection$establish_socket_$_state_machine__2746__auto__);

(statearr_71050[(1)] = (1));

return statearr_71050;
});
var fluree$db$connection$establish_socket_$_state_machine__2746__auto____1 = (function (state_71027){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71027);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71051){var ex__2749__auto__ = e71051;
var statearr_71052_71068 = state_71027;
(statearr_71052_71068[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71027[(4)]))){
var statearr_71053_71069 = state_71027;
(statearr_71053_71069[(1)] = cljs.core.first.call(null,(state_71027[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71070 = state_71027;
state_71027 = G__71070;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2746__auto__ = function(state_71027){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2746__auto____1.call(this,state_71027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2746__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2746__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71054 = f__2769__auto__.call(null);
(statearr_71054[(6)] = c__2768__auto__);

return statearr_71054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k71072,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__71076 = k71072;
var G__71076__$1 = (((G__71076 instanceof cljs.core.Keyword))?G__71076.fqn:null);
switch (G__71076__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k71072,else__4505__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__71077){
var vec__71078 = p__71077;
var k__4526__auto__ = cljs.core.nth.call(null,vec__71078,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__71078,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__71071){
var self__ = this;
var G__71071__$1 = this;
return (new cljs.core.RecordIter((0),G__71071__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (27 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this71073,other71074){
var self__ = this;
var this71073__$1 = this;
return (((!((other71074 == null)))) && ((((this71073__$1.constructor === other71074.constructor)) && (((cljs.core._EQ_.call(null,this71073__$1.id,other71074.id)) && (((cljs.core._EQ_.call(null,this71073__$1.servers,other71074.servers)) && (((cljs.core._EQ_.call(null,this71073__$1.state,other71074.state)) && (((cljs.core._EQ_.call(null,this71073__$1.req_chan,other71074.req_chan)) && (((cljs.core._EQ_.call(null,this71073__$1.sub_chan,other71074.sub_chan)) && (((cljs.core._EQ_.call(null,this71073__$1.pub_chan,other71074.pub_chan)) && (((cljs.core._EQ_.call(null,this71073__$1.group,other71074.group)) && (((cljs.core._EQ_.call(null,this71073__$1.storage_read,other71074.storage_read)) && (((cljs.core._EQ_.call(null,this71073__$1.storage_list,other71074.storage_list)) && (((cljs.core._EQ_.call(null,this71073__$1.storage_write,other71074.storage_write)) && (((cljs.core._EQ_.call(null,this71073__$1.storage_exists,other71074.storage_exists)) && (((cljs.core._EQ_.call(null,this71073__$1.storage_rename,other71074.storage_rename)) && (((cljs.core._EQ_.call(null,this71073__$1.storage_delete,other71074.storage_delete)) && (((cljs.core._EQ_.call(null,this71073__$1.object_cache,other71074.object_cache)) && (((cljs.core._EQ_.call(null,this71073__$1.async_cache,other71074.async_cache)) && (((cljs.core._EQ_.call(null,this71073__$1.parallelism,other71074.parallelism)) && (((cljs.core._EQ_.call(null,this71073__$1.serializer,other71074.serializer)) && (((cljs.core._EQ_.call(null,this71073__$1.default_network,other71074.default_network)) && (((cljs.core._EQ_.call(null,this71073__$1.transactor_QMARK_,other71074.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this71073__$1.publish,other71074.publish)) && (((cljs.core._EQ_.call(null,this71073__$1.transact_handler,other71074.transact_handler)) && (((cljs.core._EQ_.call(null,this71073__$1.tx_private_key,other71074.tx_private_key)) && (((cljs.core._EQ_.call(null,this71073__$1.tx_key_id,other71074.tx_key_id)) && (((cljs.core._EQ_.call(null,this71073__$1.meta,other71074.meta)) && (((cljs.core._EQ_.call(null,this71073__$1.add_listener,other71074.add_listener)) && (((cljs.core._EQ_.call(null,this71073__$1.remove_listener,other71074.remove_listener)) && (((cljs.core._EQ_.call(null,this71073__$1.close,other71074.close)) && (cljs.core._EQ_.call(null,this71073__$1.__extmap,other71074.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__71081){
var self__ = this;
var map__71082 = p__71081;
var map__71082__$1 = cljs.core.__destructure_map.call(null,map__71082);
var node = map__71082__$1;
var id__$1 = cljs.core.get.call(null,map__71082__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__71082__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.call(null,map__71082__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf.call(null,node);
} else {
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null),(function (_){
return fluree.db.storage.core.resolve_index_node.call(null,conn__$1,node,(function (){
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null),null);
}));
}));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k71072){
var self__ = this;
var this__4509__auto____$1 = this;
var G__71083 = k71072;
var G__71083__$1 = (((G__71083 instanceof cljs.core.Keyword))?G__71083.fqn:null);
switch (G__71083__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k71072);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__71071){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__71084 = cljs.core.keyword_identical_QMARK_;
var expr__71085 = k__4511__auto__;
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__71085))){
return (new fluree.db.connection.Connection(G__71071,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,G__71071,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__71071,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__71071,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__71071,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__71071,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"group","group",582596132),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__71071,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__71071,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__71071,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__71071,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__71071,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__71071,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__71071,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__71071,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__71071,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__71071,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__71071,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__71071,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__71071,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__71071,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__71071,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__71071,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__71071,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__71071,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__71071,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__71071,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71084.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__71085))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__71071,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__71071),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_read.call(null,k);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return self__.storage_write.call(null,k,data);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_exists.call(null,k);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return self__.storage_rename.call(null,old_key,new_key);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return self__.storage_list.call(null,d);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_delete.call(null,k);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__71071){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__71071,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__71075){
var extmap__4542__auto__ = (function (){var G__71087 = cljs.core.dissoc.call(null,G__71075,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__71075)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__71087);
} else {
return G__71087;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__71075),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__71075),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__71093 = servers_STAR_;
var vec__71094 = G__71093;
var seq__71095 = cljs.core.seq.call(null,vec__71094);
var first__71096 = cljs.core.first.call(null,seq__71095);
var seq__71095__$1 = cljs.core.next.call(null,seq__71095);
var server = first__71096;
var r = seq__71095__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__71093__$1 = G__71093;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__71100 = G__71093__$1;
var seq__71101 = cljs.core.seq.call(null,vec__71100);
var first__71102 = cljs.core.first.call(null,seq__71101);
var seq__71101__$1 = cljs.core.next.call(null,seq__71101);
var server__$1 = first__71102;
var r__$1 = seq__71101__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__71103 = r__$1;
var G__71104 = is_https_QMARK_;
var G__71105 = result_STAR_;
G__71093__$1 = G__71103;
https_QMARK___$1 = G__71104;
result__$1 = G__71105;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__71106 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__71106 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__71106);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71135){
var state_val_71136 = (state_71135[(1)]);
if((state_val_71136 === (7))){
var inst_71121 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71122 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71123 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71124 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71125 = fluree.db.connection.establish_socket.call(null,inst_71121,inst_71122,inst_71123,inst_71124);
var state_71135__$1 = state_71135;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71135__$1,(9),inst_71125);
} else {
if((state_val_71136 === (1))){
var state_71135__$1 = state_71135;
var statearr_71137_71156 = state_71135__$1;
(statearr_71137_71156[(2)] = null);

(statearr_71137_71156[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71136 === (4))){
var inst_71107 = (state_71135[(2)]);
var state_71135__$1 = state_71135;
var statearr_71138_71157 = state_71135__$1;
(statearr_71138_71157[(2)] = inst_71107);

(statearr_71138_71157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71136 === (6))){
var inst_71118 = (state_71135[(7)]);
var state_71135__$1 = state_71135;
var statearr_71139_71158 = state_71135__$1;
(statearr_71139_71158[(2)] = inst_71118);

(statearr_71139_71158[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71136 === (3))){
var inst_71133 = (state_71135[(2)]);
var state_71135__$1 = state_71135;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71135__$1,inst_71133);
} else {
if((state_val_71136 === (2))){
var inst_71118 = (state_71135[(7)]);
var _ = (function (){var statearr_71141 = state_71135;
(statearr_71141[(4)] = cljs.core.cons.call(null,(5),(state_71135[(4)])));

return statearr_71141;
})();
var inst_71113 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_71114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71115 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71116 = [inst_71115,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_71117 = (new cljs.core.PersistentVector(null,3,(5),inst_71114,inst_71116,null));
var inst_71118__$1 = cljs.core.get_in.call(null,inst_71113,inst_71117);
var state_71135__$1 = (function (){var statearr_71142 = state_71135;
(statearr_71142[(7)] = inst_71118__$1);

return statearr_71142;
})();
if(cljs.core.truth_(inst_71118__$1)){
var statearr_71143_71159 = state_71135__$1;
(statearr_71143_71159[(1)] = (6));

} else {
var statearr_71144_71160 = state_71135__$1;
(statearr_71144_71160[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71136 === (9))){
var inst_71127 = (state_71135[(2)]);
var inst_71128 = fluree.db.util.async.throw_err.call(null,inst_71127);
var state_71135__$1 = state_71135;
var statearr_71145_71161 = state_71135__$1;
(statearr_71145_71161[(2)] = inst_71128);

(statearr_71145_71161[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71136 === (5))){
var _ = (function (){var statearr_71146 = state_71135;
(statearr_71146[(4)] = cljs.core.rest.call(null,(state_71135[(4)])));

return statearr_71146;
})();
var state_71135__$1 = state_71135;
var ex71140 = (state_71135__$1[(2)]);
var statearr_71147_71162 = state_71135__$1;
(statearr_71147_71162[(5)] = ex71140);


if((ex71140 instanceof Error)){
var statearr_71148_71163 = state_71135__$1;
(statearr_71148_71163[(1)] = (4));

(statearr_71148_71163[(5)] = null);

} else {
throw ex71140;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71136 === (8))){
var inst_71130 = (state_71135[(2)]);
var _ = (function (){var statearr_71149 = state_71135;
(statearr_71149[(4)] = cljs.core.rest.call(null,(state_71135[(4)])));

return statearr_71149;
})();
var state_71135__$1 = state_71135;
var statearr_71150_71164 = state_71135__$1;
(statearr_71150_71164[(2)] = inst_71130);

(statearr_71150_71164[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2746__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_71151 = [null,null,null,null,null,null,null,null];
(statearr_71151[(0)] = fluree$db$connection$get_socket_$_state_machine__2746__auto__);

(statearr_71151[(1)] = (1));

return statearr_71151;
});
var fluree$db$connection$get_socket_$_state_machine__2746__auto____1 = (function (state_71135){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71135);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71152){var ex__2749__auto__ = e71152;
var statearr_71153_71165 = state_71135;
(statearr_71153_71165[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71135[(4)]))){
var statearr_71154_71166 = state_71135;
(statearr_71154_71166[(1)] = cljs.core.first.call(null,(state_71135[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71167 = state_71135;
state_71135 = G__71167;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2746__auto__ = function(state_71135){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2746__auto____1.call(this,state_71135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2746__auto____0;
fluree$db$connection$get_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2746__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71155 = f__2769__auto__.call(null);
(statearr_71155[(6)] = c__2768__auto__);

return statearr_71155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4253__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e71168){var e = e71168;
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__71170){
var map__71171 = p__71170;
var map__71171__$1 = cljs.core.__destructure_map.call(null,map__71171);
var conn = map__71171__$1;
var state = cljs.core.get.call(null,map__71171__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.call(null,map__71171__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.call(null,map__71171__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71317){
var state_val_71318 = (state_71317[(1)]);
if((state_val_71318 === (7))){
var inst_71313 = (state_71317[(2)]);
var state_71317__$1 = state_71317;
var statearr_71320_71394 = state_71317__$1;
(statearr_71320_71394[(2)] = inst_71313);

(statearr_71320_71394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (20))){
var _ = (function (){var statearr_71321 = state_71317;
(statearr_71321[(4)] = cljs.core.rest.call(null,(state_71317[(4)])));

return statearr_71321;
})();
var state_71317__$1 = state_71317;
var ex71319 = (state_71317__$1[(2)]);
var statearr_71322_71395 = state_71317__$1;
(statearr_71322_71395[(5)] = ex71319);


var statearr_71323_71396 = state_71317__$1;
(statearr_71323_71396[(1)] = (10));

(statearr_71323_71396[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (27))){
var inst_71274 = (state_71317[(7)]);
var inst_71274__$1 = (state_71317[(2)]);
var inst_71275 = inst_71274__$1 === true;
var state_71317__$1 = (function (){var statearr_71324 = state_71317;
(statearr_71324[(7)] = inst_71274__$1);

return statearr_71324;
})();
if(cljs.core.truth_(inst_71275)){
var statearr_71325_71397 = state_71317__$1;
(statearr_71325_71397[(1)] = (28));

} else {
var statearr_71326_71398 = state_71317__$1;
(statearr_71326_71398[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (1))){
var inst_71172 = (0);
var state_71317__$1 = (function (){var statearr_71327 = state_71317;
(statearr_71327[(8)] = inst_71172);

return statearr_71327;
})();
var statearr_71328_71399 = state_71317__$1;
(statearr_71328_71399[(2)] = null);

(statearr_71328_71399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (24))){
var inst_71264 = (state_71317[(9)]);
var state_71317__$1 = state_71317;
var statearr_71329_71400 = state_71317__$1;
(statearr_71329_71400[(2)] = inst_71264);

(statearr_71329_71400[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (39))){
var inst_71299 = (state_71317[(2)]);
var state_71317__$1 = state_71317;
var statearr_71330_71401 = state_71317__$1;
(statearr_71330_71401[(2)] = inst_71299);

(statearr_71330_71401[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (4))){
var inst_71175 = (state_71317[(10)]);
var inst_71175__$1 = (state_71317[(2)]);
var state_71317__$1 = (function (){var statearr_71331 = state_71317;
(statearr_71331[(10)] = inst_71175__$1);

return statearr_71331;
})();
if(cljs.core.truth_(inst_71175__$1)){
var statearr_71332_71402 = state_71317__$1;
(statearr_71332_71402[(1)] = (5));

} else {
var statearr_71333_71403 = state_71317__$1;
(statearr_71333_71403[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (15))){
var inst_71188 = (state_71317[(11)]);
var state_71317__$1 = state_71317;
var statearr_71334_71404 = state_71317__$1;
(statearr_71334_71404[(2)] = inst_71188);

(statearr_71334_71404[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (21))){
var inst_71220 = (state_71317[(12)]);
var inst_71226 = (state_71317[(13)]);
var inst_71218 = (state_71317[(14)]);
var inst_71217 = (state_71317[(15)]);
var inst_71175 = (state_71317[(10)]);
var inst_71172 = (state_71317[(8)]);
var inst_71222 = (state_71317[(16)]);
var inst_71221 = (state_71317[(17)]);
var inst_71225 = (state_71317[(18)]);
var inst_71219 = (state_71317[(19)]);
var inst_71228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71229 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_71225];
var inst_71230 = (new cljs.core.PersistentVector(null,2,(5),inst_71228,inst_71229,null));
var inst_71231 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_71230,inst_71220);
var inst_71258 = cljs.core.async.chan.call(null,(1));
var inst_71259 = (function (){var resp_chan = inst_71220;
var vec__71210 = inst_71175;
var timeout = inst_71226;
var i = inst_71172;
var map__71213 = inst_71222;
var data = inst_71219;
var _ = inst_71217;
var req_id = inst_71225;
var operation = inst_71218;
var msg = inst_71175;
var temp__5804__auto__ = inst_71175;
var c__2768__auto____$1 = inst_71258;
var opts = inst_71221;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71256){
var state_val_71257 = (state_71256[(1)]);
if((state_val_71257 === (1))){
var inst_71235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71236 = cljs.core.async.timeout.call(null,timeout);
var inst_71237 = [resp_chan,inst_71236];
var inst_71238 = (new cljs.core.PersistentVector(null,2,(5),inst_71235,inst_71237,null));
var state_71256__$1 = state_71256;
return cljs.core.async.ioc_alts_BANG_.call(null,state_71256__$1,(2),inst_71238);
} else {
if((state_val_71257 === (2))){
var inst_71241 = (state_71256[(7)]);
var inst_71240 = (state_71256[(2)]);
var inst_71241__$1 = cljs.core.nth.call(null,inst_71240,(0),null);
var inst_71242 = cljs.core.nth.call(null,inst_71240,(1),null);
var inst_71243 = (function (){var vec__71232 = inst_71240;
var resp = inst_71241__$1;
var c = inst_71242;
return (function (p1__71169_SHARP_){
return cljs.core.dissoc.call(null,p1__71169_SHARP_,req_id);
});
})();
var inst_71244 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_71243);
var inst_71245 = cljs.core._EQ_.call(null,inst_71242,resp_chan);
var state_71256__$1 = (function (){var statearr_71335 = state_71256;
(statearr_71335[(8)] = inst_71244);

(statearr_71335[(7)] = inst_71241__$1);

return statearr_71335;
})();
if(inst_71245){
var statearr_71336_71405 = state_71256__$1;
(statearr_71336_71405[(1)] = (3));

} else {
var statearr_71337_71406 = state_71256__$1;
(statearr_71337_71406[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71257 === (3))){
var inst_71241 = (state_71256[(7)]);
var state_71256__$1 = state_71256;
var statearr_71338_71407 = state_71256__$1;
(statearr_71338_71407[(2)] = inst_71241);

(statearr_71338_71407[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71257 === (4))){
var inst_71248 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_71249 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71250 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_71251 = cljs.core.PersistentHashMap.fromArrays(inst_71249,inst_71250);
var inst_71252 = cljs.core.ex_info.call(null,inst_71248,inst_71251);
var state_71256__$1 = state_71256;
var statearr_71339_71408 = state_71256__$1;
(statearr_71339_71408[(2)] = inst_71252);

(statearr_71339_71408[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71257 === (5))){
var inst_71254 = (state_71256[(2)]);
var state_71256__$1 = state_71256;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71256__$1,inst_71254);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____0 = (function (){
var statearr_71340 = [null,null,null,null,null,null,null,null,null];
(statearr_71340[(0)] = fluree$db$connection$msg_producer_$_state_machine__2746__auto__);

(statearr_71340[(1)] = (1));

return statearr_71340;
});
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____1 = (function (state_71256){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71256);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71341){var ex__2749__auto__ = e71341;
var statearr_71342_71409 = state_71256;
(statearr_71342_71409[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71256[(4)]))){
var statearr_71343_71410 = state_71256;
(statearr_71343_71410[(1)] = cljs.core.first.call(null,(state_71256[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71411 = state_71256;
state_71256 = G__71411;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = function(state_71256){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____1.call(this,state_71256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71344 = f__2769__auto__.call(null);
(statearr_71344[(6)] = c__2768__auto____$1);

return statearr_71344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_71260 = cljs.core.async.impl.dispatch.run.call(null,inst_71259);
var state_71317__$1 = (function (){var statearr_71345 = state_71317;
(statearr_71345[(20)] = inst_71260);

(statearr_71345[(21)] = inst_71231);

return statearr_71345;
})();
var statearr_71346_71412 = state_71317__$1;
(statearr_71346_71412[(2)] = inst_71258);

(statearr_71346_71412[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (31))){
var inst_71274 = (state_71317[(7)]);
var inst_71280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71281 = [inst_71274,"Error processing message in producer."];
var inst_71282 = (new cljs.core.PersistentVector(null,2,(5),inst_71280,inst_71281,null));
var inst_71283 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71282);
var state_71317__$1 = state_71317;
var statearr_71347_71413 = state_71317__$1;
(statearr_71347_71413[(2)] = inst_71283);

(statearr_71347_71413[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (32))){
var inst_71274 = (state_71317[(7)]);
var inst_71285 = (inst_71274 == null);
var state_71317__$1 = state_71317;
if(cljs.core.truth_(inst_71285)){
var statearr_71348_71414 = state_71317__$1;
(statearr_71348_71414[(1)] = (34));

} else {
var statearr_71349_71415 = state_71317__$1;
(statearr_71349_71415[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (33))){
var inst_71303 = (state_71317[(2)]);
var state_71317__$1 = state_71317;
var statearr_71350_71416 = state_71317__$1;
(statearr_71350_71416[(2)] = inst_71303);

(statearr_71350_71416[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (13))){
var inst_71188 = (state_71317[(11)]);
var inst_71185 = (state_71317[(2)]);
var inst_71186 = cljs.core.nth.call(null,inst_71185,(0),null);
var inst_71187 = cljs.core.nth.call(null,inst_71185,(1),null);
var inst_71188__$1 = cljs.core.nth.call(null,inst_71185,(2),null);
var state_71317__$1 = (function (){var statearr_71351 = state_71317;
(statearr_71351[(22)] = inst_71186);

(statearr_71351[(11)] = inst_71188__$1);

(statearr_71351[(23)] = inst_71187);

return statearr_71351;
})();
if(cljs.core.truth_(inst_71188__$1)){
var statearr_71352_71417 = state_71317__$1;
(statearr_71352_71417[(1)] = (14));

} else {
var statearr_71353_71418 = state_71317__$1;
(statearr_71353_71418[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (22))){
var state_71317__$1 = state_71317;
var statearr_71354_71419 = state_71317__$1;
(statearr_71354_71419[(2)] = null);

(statearr_71354_71419[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (36))){
var inst_71301 = (state_71317[(2)]);
var state_71317__$1 = state_71317;
var statearr_71355_71420 = state_71317__$1;
(statearr_71355_71420[(2)] = inst_71301);

(statearr_71355_71420[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (29))){
var inst_71274 = (state_71317[(7)]);
var inst_71278 = fluree.db.util.core.exception_QMARK_.call(null,inst_71274);
var state_71317__$1 = state_71317;
if(inst_71278){
var statearr_71356_71421 = state_71317__$1;
(statearr_71356_71421[(1)] = (31));

} else {
var statearr_71357_71422 = state_71317__$1;
(statearr_71357_71422[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (6))){
var state_71317__$1 = state_71317;
var statearr_71358_71423 = state_71317__$1;
(statearr_71358_71423[(2)] = null);

(statearr_71358_71423[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (28))){
var state_71317__$1 = state_71317;
var statearr_71359_71424 = state_71317__$1;
(statearr_71359_71424[(2)] = null);

(statearr_71359_71424[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (25))){
var state_71317__$1 = state_71317;
var statearr_71360_71425 = state_71317__$1;
(statearr_71360_71425[(2)] = fluree.db.connection.default_publish_fn);

(statearr_71360_71425[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (34))){
var inst_71287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71288 = ["Error processing message in producer. Socket closed."];
var inst_71289 = (new cljs.core.PersistentVector(null,1,(5),inst_71287,inst_71288,null));
var inst_71290 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71289);
var state_71317__$1 = state_71317;
var statearr_71361_71426 = state_71317__$1;
(statearr_71361_71426[(2)] = inst_71290);

(statearr_71361_71426[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (17))){
var inst_71177 = (state_71317[(24)]);
var inst_71188 = (state_71317[(11)]);
var inst_71195 = cljs.core.async.put_BANG_.call(null,inst_71188,inst_71177);
var state_71317__$1 = state_71317;
var statearr_71362_71427 = state_71317__$1;
(statearr_71362_71427[(2)] = inst_71195);

(statearr_71362_71427[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (3))){
var inst_71315 = (state_71317[(2)]);
var state_71317__$1 = state_71317;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71317__$1,inst_71315);
} else {
if((state_val_71318 === (12))){
var state_71317__$1 = state_71317;
var statearr_71363_71428 = state_71317__$1;
(statearr_71363_71428[(2)] = null);

(statearr_71363_71428[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (2))){
var state_71317__$1 = state_71317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71317__$1,(4),req_chan);
} else {
if((state_val_71318 === (23))){
var inst_71264 = (state_71317[(9)]);
var inst_71263 = (state_71317[(2)]);
var inst_71264__$1 = publish;
var state_71317__$1 = (function (){var statearr_71364 = state_71317;
(statearr_71364[(9)] = inst_71264__$1);

(statearr_71364[(25)] = inst_71263);

return statearr_71364;
})();
if(cljs.core.truth_(inst_71264__$1)){
var statearr_71365_71429 = state_71317__$1;
(statearr_71365_71429[(1)] = (24));

} else {
var statearr_71366_71430 = state_71317__$1;
(statearr_71366_71430[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (35))){
var state_71317__$1 = state_71317;
var statearr_71367_71431 = state_71317__$1;
(statearr_71367_71431[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (19))){
var inst_71204 = (state_71317[(2)]);
var state_71317__$1 = state_71317;
var statearr_71369_71432 = state_71317__$1;
(statearr_71369_71432[(2)] = inst_71204);

(statearr_71369_71432[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (11))){
var inst_71175 = (state_71317[(10)]);
var state_71317__$1 = state_71317;
var statearr_71370_71433 = state_71317__$1;
(statearr_71370_71433[(2)] = inst_71175);

(statearr_71370_71433[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (9))){
var inst_71172 = (state_71317[(8)]);
var inst_71308 = (state_71317[(2)]);
var inst_71309 = (inst_71172 + (1));
var inst_71172__$1 = inst_71309;
var state_71317__$1 = (function (){var statearr_71371 = state_71317;
(statearr_71371[(8)] = inst_71172__$1);

(statearr_71371[(26)] = inst_71308);

return statearr_71371;
})();
var statearr_71372_71434 = state_71317__$1;
(statearr_71372_71434[(2)] = null);

(statearr_71372_71434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (5))){
var state_71317__$1 = state_71317;
var statearr_71373_71435 = state_71317__$1;
(statearr_71373_71435[(2)] = null);

(statearr_71373_71435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (14))){
var inst_71188 = (state_71317[(11)]);
var inst_71190 = fluree.db.util.async.channel_QMARK_.call(null,inst_71188);
var state_71317__$1 = state_71317;
var statearr_71374_71436 = state_71317__$1;
(statearr_71374_71436[(2)] = inst_71190);

(statearr_71374_71436[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (26))){
var inst_71218 = (state_71317[(14)]);
var inst_71225 = (state_71317[(18)]);
var inst_71219 = (state_71317[(19)]);
var inst_71268 = (state_71317[(2)]);
var inst_71269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71270 = [inst_71218,inst_71225,inst_71219];
var inst_71271 = (new cljs.core.PersistentVector(null,3,(5),inst_71269,inst_71270,null));
var inst_71272 = inst_71268.call(null,conn,inst_71271);
var state_71317__$1 = state_71317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71317__$1,(27),inst_71272);
} else {
if((state_val_71318 === (16))){
var inst_71193 = (state_71317[(2)]);
var state_71317__$1 = state_71317;
if(cljs.core.truth_(inst_71193)){
var statearr_71375_71437 = state_71317__$1;
(statearr_71375_71437[(1)] = (17));

} else {
var statearr_71376_71438 = state_71317__$1;
(statearr_71376_71438[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (38))){
var state_71317__$1 = state_71317;
var statearr_71377_71439 = state_71317__$1;
(statearr_71377_71439[(2)] = null);

(statearr_71377_71439[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (30))){
var inst_71305 = (state_71317[(2)]);
var _ = (function (){var statearr_71378 = state_71317;
(statearr_71378[(4)] = cljs.core.rest.call(null,(state_71317[(4)])));

return statearr_71378;
})();
var state_71317__$1 = state_71317;
var statearr_71379_71440 = state_71317__$1;
(statearr_71379_71440[(2)] = inst_71305);

(statearr_71379_71440[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (10))){
var inst_71175 = (state_71317[(10)]);
var inst_71177 = (state_71317[(2)]);
var inst_71181 = cljs.core.sequential_QMARK_.call(null,inst_71175);
var state_71317__$1 = (function (){var statearr_71380 = state_71317;
(statearr_71380[(24)] = inst_71177);

return statearr_71380;
})();
if(inst_71181){
var statearr_71381_71441 = state_71317__$1;
(statearr_71381_71441[(1)] = (11));

} else {
var statearr_71382_71442 = state_71317__$1;
(statearr_71382_71442[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (18))){
var inst_71175 = (state_71317[(10)]);
var inst_71177 = (state_71317[(24)]);
var inst_71197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71198 = cljs.core.pr_str.call(null,inst_71175);
var inst_71199 = ["Error processing ledger request, no valid return channel: ",inst_71198].join('');
var inst_71200 = [inst_71177,inst_71199];
var inst_71201 = (new cljs.core.PersistentVector(null,2,(5),inst_71197,inst_71200,null));
var inst_71202 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71201);
var state_71317__$1 = state_71317;
var statearr_71383_71443 = state_71317__$1;
(statearr_71383_71443[(2)] = inst_71202);

(statearr_71383_71443[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (37))){
var inst_71274 = (state_71317[(7)]);
var inst_71293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71294 = ["Error processing message in producer. Socket closed. Published result",inst_71274];
var inst_71295 = (new cljs.core.PersistentVector(null,2,(5),inst_71293,inst_71294,null));
var inst_71296 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71295);
var state_71317__$1 = state_71317;
var statearr_71384_71444 = state_71317__$1;
(statearr_71384_71444[(2)] = inst_71296);

(statearr_71384_71444[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71318 === (8))){
var inst_71220 = (state_71317[(12)]);
var inst_71175 = (state_71317[(10)]);
var inst_71222 = (state_71317[(16)]);
var inst_71221 = (state_71317[(17)]);
var _ = (function (){var statearr_71385 = state_71317;
(statearr_71385[(4)] = cljs.core.cons.call(null,(20),(state_71317[(4)])));

return statearr_71385;
})();
var inst_71214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71215 = ["Outgoing message to websocket: ",inst_71175];
var inst_71216 = (new cljs.core.PersistentVector(null,2,(5),inst_71214,inst_71215,null));
var inst_71217 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_71216);
var inst_71218 = cljs.core.nth.call(null,inst_71175,(0),null);
var inst_71219 = cljs.core.nth.call(null,inst_71175,(1),null);
var inst_71220__$1 = cljs.core.nth.call(null,inst_71175,(2),null);
var inst_71221__$1 = cljs.core.nth.call(null,inst_71175,(3),null);
var inst_71222__$1 = cljs.core.__destructure_map.call(null,inst_71221__$1);
var inst_71223 = cljs.core.random_uuid.call(null);
var inst_71224 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71223);
var inst_71225 = cljs.core.get.call(null,inst_71222__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_71224);
var inst_71226 = cljs.core.get.call(null,inst_71222__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_71317__$1 = (function (){var statearr_71386 = state_71317;
(statearr_71386[(12)] = inst_71220__$1);

(statearr_71386[(13)] = inst_71226);

(statearr_71386[(14)] = inst_71218);

(statearr_71386[(15)] = inst_71217);

(statearr_71386[(16)] = inst_71222__$1);

(statearr_71386[(17)] = inst_71221__$1);

(statearr_71386[(18)] = inst_71225);

(statearr_71386[(19)] = inst_71219);

return statearr_71386;
})();
if(cljs.core.truth_(inst_71220__$1)){
var statearr_71387_71445 = state_71317__$1;
(statearr_71387_71445[(1)] = (21));

} else {
var statearr_71388_71446 = state_71317__$1;
(statearr_71388_71446[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____0 = (function (){
var statearr_71389 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71389[(0)] = fluree$db$connection$msg_producer_$_state_machine__2746__auto__);

(statearr_71389[(1)] = (1));

return statearr_71389;
});
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____1 = (function (state_71317){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71317);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71390){var ex__2749__auto__ = e71390;
var statearr_71391_71447 = state_71317;
(statearr_71391_71447[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71317[(4)]))){
var statearr_71392_71448 = state_71317;
(statearr_71392_71448[(1)] = cljs.core.first.call(null,(state_71317[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71449 = state_71317;
state_71317 = G__71449;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = function(state_71317){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____1.call(this,state_71317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71393 = f__2769__auto__.call(null);
(statearr_71393[(6)] = c__2768__auto__);

return statearr_71393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__71450 = conn;
var map__71450__$1 = cljs.core.__destructure_map.call(null,map__71450);
var sub_chan = cljs.core.get.call(null,map__71450__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71553){
var state_val_71554 = (state_71553[(1)]);
if((state_val_71554 === (7))){
var inst_71549 = (state_71553[(2)]);
var state_71553__$1 = state_71553;
var statearr_71555_71606 = state_71553__$1;
(statearr_71555_71606[(2)] = inst_71549);

(statearr_71555_71606[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (20))){
var inst_71472 = (state_71553[(7)]);
var inst_71489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71490 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_71491 = [inst_71472];
var inst_71492 = cljs.core.PersistentHashMap.fromArrays(inst_71490,inst_71491);
var inst_71493 = ["Unsupported callback registered",inst_71492];
var inst_71494 = (new cljs.core.PersistentVector(null,2,(5),inst_71489,inst_71493,null));
var inst_71495 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_71494);
var state_71553__$1 = state_71553;
var statearr_71556_71607 = state_71553__$1;
(statearr_71556_71607[(2)] = inst_71495);

(statearr_71556_71607[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (27))){
var state_71553__$1 = state_71553;
var statearr_71557_71608 = state_71553__$1;
(statearr_71557_71608[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (1))){
var inst_71451 = (0);
var state_71553__$1 = (function (){var statearr_71559 = state_71553;
(statearr_71559[(8)] = inst_71451);

return statearr_71559;
})();
var statearr_71560_71609 = state_71553__$1;
(statearr_71560_71609[(2)] = null);

(statearr_71560_71609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (24))){
var inst_71462 = (state_71553[(9)]);
var inst_71523 = fluree.db.util.core.exception_QMARK_.call(null,inst_71462);
var state_71553__$1 = state_71553;
if(inst_71523){
var statearr_71561_71610 = state_71553__$1;
(statearr_71561_71610[(1)] = (26));

} else {
var statearr_71562_71611 = state_71553__$1;
(statearr_71562_71611[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (4))){
var inst_71456 = (state_71553[(10)]);
var inst_71461 = (state_71553[(2)]);
var inst_71462 = cljs.core.nth.call(null,inst_71461,(0),null);
var inst_71463 = cljs.core.nth.call(null,inst_71461,(1),null);
var inst_71464 = cljs.core._EQ_.call(null,inst_71463,inst_71456);
var state_71553__$1 = (function (){var statearr_71563 = state_71553;
(statearr_71563[(9)] = inst_71462);

return statearr_71563;
})();
if(inst_71464){
var statearr_71564_71612 = state_71553__$1;
(statearr_71564_71612[(1)] = (5));

} else {
var statearr_71565_71613 = state_71553__$1;
(statearr_71565_71613[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (15))){
var inst_71472 = (state_71553[(7)]);
var inst_71484 = typeof inst_71472 === 'string';
var state_71553__$1 = state_71553;
if(cljs.core.truth_(inst_71484)){
var statearr_71566_71614 = state_71553__$1;
(statearr_71566_71614[(1)] = (17));

} else {
var statearr_71567_71615 = state_71553__$1;
(statearr_71567_71615[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (21))){
var state_71553__$1 = state_71553;
var statearr_71568_71616 = state_71553__$1;
(statearr_71568_71616[(2)] = null);

(statearr_71568_71616[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (31))){
var inst_71543 = (state_71553[(2)]);
var state_71553__$1 = state_71553;
var statearr_71569_71617 = state_71553__$1;
(statearr_71569_71617[(2)] = inst_71543);

(statearr_71569_71617[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (13))){
var inst_71504 = (state_71553[(2)]);
var inst_71505 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71506 = fluree.db.connection.close_websocket.call(null,inst_71505);
var inst_71507 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71508 = fluree.db.session.close_all_sessions.call(null,inst_71507);
var state_71553__$1 = (function (){var statearr_71570 = state_71553;
(statearr_71570[(11)] = inst_71504);

(statearr_71570[(12)] = inst_71506);

return statearr_71570;
})();
var statearr_71571_71618 = state_71553__$1;
(statearr_71571_71618[(2)] = inst_71508);

(statearr_71571_71618[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (22))){
var inst_71498 = (state_71553[(2)]);
var state_71553__$1 = state_71553;
var statearr_71572_71619 = state_71553__$1;
(statearr_71572_71619[(2)] = inst_71498);

(statearr_71572_71619[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (29))){
var inst_71462 = (state_71553[(9)]);
var inst_71532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71533 = fluree.db.util.json.parse.call(null,inst_71462);
var inst_71534 = cljs.core.pr_str.call(null,inst_71533);
var inst_71535 = ["Received message:",inst_71534];
var inst_71536 = (new cljs.core.PersistentVector(null,2,(5),inst_71532,inst_71535,null));
var inst_71537 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_71536);
var inst_71538 = fluree.db.util.json.parse.call(null,inst_71462);
var inst_71539 = fluree.db.conn_events.process_events.call(null,conn,inst_71538);
var inst_71451 = (0);
var state_71553__$1 = (function (){var statearr_71573 = state_71553;
(statearr_71573[(8)] = inst_71451);

(statearr_71573[(13)] = inst_71539);

(statearr_71573[(14)] = inst_71537);

return statearr_71573;
})();
var statearr_71574_71620 = state_71553__$1;
(statearr_71574_71620[(2)] = null);

(statearr_71574_71620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (6))){
var inst_71462 = (state_71553[(9)]);
var inst_71516 = (inst_71462 == null);
var state_71553__$1 = state_71553;
if(cljs.core.truth_(inst_71516)){
var statearr_71575_71621 = state_71553__$1;
(statearr_71575_71621[(1)] = (23));

} else {
var statearr_71576_71622 = state_71553__$1;
(statearr_71576_71622[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (28))){
var inst_71545 = (state_71553[(2)]);
var state_71553__$1 = state_71553;
var statearr_71577_71623 = state_71553__$1;
(statearr_71577_71623[(2)] = inst_71545);

(statearr_71577_71623[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (25))){
var inst_71547 = (state_71553[(2)]);
var state_71553__$1 = state_71553;
var statearr_71578_71624 = state_71553__$1;
(statearr_71578_71624[(2)] = inst_71547);

(statearr_71578_71624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (17))){
var inst_71472 = (state_71553[(7)]);
var inst_71486 = cljs.core.eval.call(null,inst_71472);
var state_71553__$1 = state_71553;
var statearr_71579_71625 = state_71553__$1;
(statearr_71579_71625[(2)] = inst_71486);

(statearr_71579_71625[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (3))){
var inst_71551 = (state_71553[(2)]);
var state_71553__$1 = state_71553;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71553__$1,inst_71551);
} else {
if((state_val_71554 === (12))){
var inst_71472 = (state_71553[(7)]);
var inst_71480 = cljs.core.fn_QMARK_.call(null,inst_71472);
var state_71553__$1 = state_71553;
if(inst_71480){
var statearr_71580_71626 = state_71553__$1;
(statearr_71580_71626[(1)] = (14));

} else {
var statearr_71581_71627 = state_71553__$1;
(statearr_71581_71627[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (2))){
var inst_71456 = (state_71553[(10)]);
var inst_71456__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_71457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71458 = [sub_chan,inst_71456__$1];
var inst_71459 = (new cljs.core.PersistentVector(null,2,(5),inst_71457,inst_71458,null));
var state_71553__$1 = (function (){var statearr_71582 = state_71553;
(statearr_71582[(10)] = inst_71456__$1);

return statearr_71582;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_71553__$1,(4),inst_71459);
} else {
if((state_val_71554 === (23))){
var inst_71518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71519 = ["Connection closed."];
var inst_71520 = (new cljs.core.PersistentVector(null,1,(5),inst_71518,inst_71519,null));
var inst_71521 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_71520);
var state_71553__$1 = state_71553;
var statearr_71583_71628 = state_71553__$1;
(statearr_71583_71628[(2)] = inst_71521);

(statearr_71583_71628[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (19))){
var inst_71500 = (state_71553[(2)]);
var state_71553__$1 = state_71553;
var statearr_71584_71629 = state_71553__$1;
(statearr_71584_71629[(2)] = inst_71500);

(statearr_71584_71629[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (11))){
var inst_71475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71476 = ["No keep-alive callback is registered"];
var inst_71477 = (new cljs.core.PersistentVector(null,1,(5),inst_71475,inst_71476,null));
var inst_71478 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_71477);
var state_71553__$1 = state_71553;
var statearr_71585_71630 = state_71553__$1;
(statearr_71585_71630[(2)] = inst_71478);

(statearr_71585_71630[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (9))){
var inst_71451 = (state_71553[(8)]);
var inst_71510 = fluree.db.connection.ping_transactor.call(null,conn);
var inst_71511 = (inst_71451 + (1));
var inst_71451__$1 = inst_71511;
var state_71553__$1 = (function (){var statearr_71586 = state_71553;
(statearr_71586[(15)] = inst_71510);

(statearr_71586[(8)] = inst_71451__$1);

return statearr_71586;
})();
var statearr_71587_71631 = state_71553__$1;
(statearr_71587_71631[(2)] = null);

(statearr_71587_71631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (5))){
var inst_71451 = (state_71553[(8)]);
var inst_71466 = cljs.core._EQ_.call(null,(2),inst_71451);
var state_71553__$1 = state_71553;
if(inst_71466){
var statearr_71588_71632 = state_71553__$1;
(statearr_71588_71632[(1)] = (8));

} else {
var statearr_71589_71633 = state_71553__$1;
(statearr_71589_71633[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (14))){
var inst_71472 = (state_71553[(7)]);
var inst_71482 = inst_71472.call(null);
var state_71553__$1 = state_71553;
var statearr_71590_71634 = state_71553__$1;
(statearr_71590_71634[(2)] = inst_71482);

(statearr_71590_71634[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (26))){
var inst_71462 = (state_71553[(9)]);
var inst_71525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71526 = [inst_71462];
var inst_71527 = (new cljs.core.PersistentVector(null,1,(5),inst_71525,inst_71526,null));
var inst_71528 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71527);
var inst_71451 = (0);
var state_71553__$1 = (function (){var statearr_71591 = state_71553;
(statearr_71591[(8)] = inst_71451);

(statearr_71591[(16)] = inst_71528);

return statearr_71591;
})();
var statearr_71592_71635 = state_71553__$1;
(statearr_71592_71635[(2)] = null);

(statearr_71592_71635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (16))){
var inst_71502 = (state_71553[(2)]);
var state_71553__$1 = state_71553;
var statearr_71593_71636 = state_71553__$1;
(statearr_71593_71636[(2)] = inst_71502);

(statearr_71593_71636[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (30))){
var state_71553__$1 = state_71553;
var statearr_71594_71637 = state_71553__$1;
(statearr_71594_71637[(2)] = null);

(statearr_71594_71637[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (10))){
var inst_71514 = (state_71553[(2)]);
var state_71553__$1 = state_71553;
var statearr_71595_71638 = state_71553__$1;
(statearr_71595_71638[(2)] = inst_71514);

(statearr_71595_71638[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (18))){
var state_71553__$1 = state_71553;
var statearr_71596_71639 = state_71553__$1;
(statearr_71596_71639[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71554 === (8))){
var inst_71472 = (state_71553[(7)]);
var inst_71468 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71469 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_71470 = (new cljs.core.PersistentVector(null,1,(5),inst_71468,inst_71469,null));
var inst_71471 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_71470);
var inst_71472__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71473 = (inst_71472__$1 == null);
var state_71553__$1 = (function (){var statearr_71598 = state_71553;
(statearr_71598[(7)] = inst_71472__$1);

(statearr_71598[(17)] = inst_71471);

return statearr_71598;
})();
if(cljs.core.truth_(inst_71473)){
var statearr_71599_71640 = state_71553__$1;
(statearr_71599_71640[(1)] = (11));

} else {
var statearr_71600_71641 = state_71553__$1;
(statearr_71600_71641[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0 = (function (){
var statearr_71601 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71601[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2746__auto__);

(statearr_71601[(1)] = (1));

return statearr_71601;
});
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1 = (function (state_71553){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71553);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71602){var ex__2749__auto__ = e71602;
var statearr_71603_71642 = state_71553;
(statearr_71603_71642[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71553[(4)]))){
var statearr_71604_71643 = state_71553;
(statearr_71604_71643[(1)] = cljs.core.first.call(null,(state_71553[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71644 = state_71553;
state_71553 = G__71644;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__ = function(state_71553){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1.call(this,state_71553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71605 = f__2769__auto__.call(null);
(statearr_71605[(6)] = c__2768__auto__);

return statearr_71605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__71646 = arguments.length;
switch (G__71646) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__71647 = opts;
var map__71647__$1 = cljs.core.__destructure_map.call(null,map__71647);
var private$ = cljs.core.get.call(null,map__71647__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__71647__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71699){
var state_val_71700 = (state_71699[(1)]);
if((state_val_71700 === (7))){
var inst_71657 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_71658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71659 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_71660 = (new cljs.core.PersistentVector(null,2,(5),inst_71658,inst_71659,null));
var inst_71661 = cljs.core.get_in.call(null,inst_71657,inst_71660);
var state_71699__$1 = state_71699;
var statearr_71701_71732 = state_71699__$1;
(statearr_71701_71732[(2)] = inst_71661);

(statearr_71701_71732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (1))){
var state_71699__$1 = state_71699;
var statearr_71702_71733 = state_71699__$1;
(statearr_71702_71733[(2)] = null);

(statearr_71702_71733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (4))){
var inst_71648 = (state_71699[(2)]);
var state_71699__$1 = state_71699;
var statearr_71703_71734 = state_71699__$1;
(statearr_71703_71734[(2)] = inst_71648);

(statearr_71703_71734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (15))){
var inst_71668 = (state_71699[(7)]);
var inst_71687 = (state_71699[(2)]);
var inst_71688 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_71689 = [(5000),inst_71687,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_71690 = cljs.core.PersistentHashMap.fromArrays(inst_71688,inst_71689);
var inst_71691 = fluree.db.util.xhttp.get.call(null,inst_71668,inst_71690);
var state_71699__$1 = state_71699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71699__$1,(16),inst_71691);
} else {
if((state_val_71700 === (13))){
var inst_71678 = (state_71699[(8)]);
var inst_71668 = (state_71699[(7)]);
var inst_71680 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_71681 = [inst_71678];
var inst_71682 = cljs.core.PersistentHashMap.fromArrays(inst_71680,inst_71681);
var inst_71683 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_71668,inst_71682,private$);
var inst_71684 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_71683);
var state_71699__$1 = state_71699;
var statearr_71704_71735 = state_71699__$1;
(statearr_71704_71735[(2)] = inst_71684);

(statearr_71704_71735[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (6))){
var inst_71654 = (state_71699[(9)]);
var state_71699__$1 = state_71699;
var statearr_71705_71736 = state_71699__$1;
(statearr_71705_71736[(2)] = inst_71654);

(statearr_71705_71736[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (3))){
var inst_71697 = (state_71699[(2)]);
var state_71699__$1 = state_71699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71699__$1,inst_71697);
} else {
if((state_val_71700 === (12))){
var inst_71678 = (state_71699[(2)]);
var state_71699__$1 = (function (){var statearr_71706 = state_71699;
(statearr_71706[(8)] = inst_71678);

return statearr_71706;
})();
if(cljs.core.truth_(private$)){
var statearr_71707_71737 = state_71699__$1;
(statearr_71707_71737[(1)] = (13));

} else {
var statearr_71708_71738 = state_71699__$1;
(statearr_71708_71738[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (2))){
var inst_71654 = (state_71699[(9)]);
var _ = (function (){var statearr_71709 = state_71699;
(statearr_71709[(4)] = cljs.core.cons.call(null,(5),(state_71699[(4)])));

return statearr_71709;
})();
var inst_71654__$1 = jwt;
var state_71699__$1 = (function (){var statearr_71710 = state_71699;
(statearr_71710[(9)] = inst_71654__$1);

return statearr_71710;
})();
if(cljs.core.truth_(inst_71654__$1)){
var statearr_71711_71739 = state_71699__$1;
(statearr_71711_71739[(1)] = (6));

} else {
var statearr_71712_71740 = state_71699__$1;
(statearr_71712_71740[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (11))){
var inst_71672 = (state_71699[(10)]);
var state_71699__$1 = state_71699;
var statearr_71714_71741 = state_71699__$1;
(statearr_71714_71741[(2)] = inst_71672);

(statearr_71714_71741[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (9))){
var inst_71664 = (state_71699[(11)]);
var inst_71663 = (state_71699[(12)]);
var inst_71667 = (state_71699[(2)]);
var inst_71668 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71667),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71664)].join('');
var inst_71670 = ["Accept"];
var inst_71671 = ["application/json"];
var inst_71672 = cljs.core.PersistentHashMap.fromArrays(inst_71670,inst_71671);
var state_71699__$1 = (function (){var statearr_71715 = state_71699;
(statearr_71715[(10)] = inst_71672);

(statearr_71715[(7)] = inst_71668);

return statearr_71715;
})();
if(cljs.core.truth_(inst_71663)){
var statearr_71716_71742 = state_71699__$1;
(statearr_71716_71742[(1)] = (10));

} else {
var statearr_71717_71743 = state_71699__$1;
(statearr_71717_71743[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (5))){
var _ = (function (){var statearr_71718 = state_71699;
(statearr_71718[(4)] = cljs.core.rest.call(null,(state_71699[(4)])));

return statearr_71718;
})();
var state_71699__$1 = state_71699;
var ex71713 = (state_71699__$1[(2)]);
var statearr_71719_71744 = state_71699__$1;
(statearr_71719_71744[(5)] = ex71713);


if((ex71713 instanceof Error)){
var statearr_71720_71745 = state_71699__$1;
(statearr_71720_71745[(1)] = (4));

(statearr_71720_71745[(5)] = null);

} else {
throw ex71713;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (14))){
var inst_71678 = (state_71699[(8)]);
var state_71699__$1 = state_71699;
var statearr_71721_71746 = state_71699__$1;
(statearr_71721_71746[(2)] = inst_71678);

(statearr_71721_71746[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (16))){
var inst_71693 = (state_71699[(2)]);
var inst_71694 = fluree.db.util.async.throw_err.call(null,inst_71693);
var _ = (function (){var statearr_71722 = state_71699;
(statearr_71722[(4)] = cljs.core.rest.call(null,(state_71699[(4)])));

return statearr_71722;
})();
var state_71699__$1 = state_71699;
var statearr_71723_71747 = state_71699__$1;
(statearr_71723_71747[(2)] = inst_71694);

(statearr_71723_71747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (10))){
var inst_71672 = (state_71699[(10)]);
var inst_71663 = (state_71699[(12)]);
var inst_71674 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71663)].join('');
var inst_71675 = cljs.core.assoc.call(null,inst_71672,"Authorization",inst_71674);
var state_71699__$1 = state_71699;
var statearr_71724_71748 = state_71699__$1;
(statearr_71724_71748[(2)] = inst_71675);

(statearr_71724_71748[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (8))){
var inst_71663 = (state_71699[(2)]);
var inst_71664 = clojure.string.replace.call(null,k,"_","/");
var inst_71665 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_71699__$1 = (function (){var statearr_71725 = state_71699;
(statearr_71725[(11)] = inst_71664);

(statearr_71725[(12)] = inst_71663);

return statearr_71725;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71699__$1,(9),inst_71665);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2746__auto__ = null;
var fluree$db$connection$state_machine__2746__auto____0 = (function (){
var statearr_71726 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71726[(0)] = fluree$db$connection$state_machine__2746__auto__);

(statearr_71726[(1)] = (1));

return statearr_71726;
});
var fluree$db$connection$state_machine__2746__auto____1 = (function (state_71699){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71727){var ex__2749__auto__ = e71727;
var statearr_71728_71749 = state_71699;
(statearr_71728_71749[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71699[(4)]))){
var statearr_71729_71750 = state_71699;
(statearr_71729_71750[(1)] = cljs.core.first.call(null,(state_71699[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71751 = state_71699;
state_71699 = G__71751;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2746__auto__ = function(state_71699){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2746__auto____1.call(this,state_71699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2746__auto____0;
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2746__auto____1;
return fluree$db$connection$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71730 = f__2769__auto__.call(null);
(statearr_71730[(6)] = c__2768__auto__);

return statearr_71730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache.call(null,cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.call(null);
var temp__5802__auto___71776 = fluree.db.connection.lookup_cache.call(null,cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___71776)){
var v_71777 = temp__5802__auto___71776;
cljs.core.async.put_BANG_.call(null,out,v_71777);
} else {
var c__2768__auto___71778 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71763){
var state_val_71764 = (state_71763[(1)]);
if((state_val_71764 === (1))){
var inst_71752 = value_fn.call(null,k);
var state_71763__$1 = state_71763;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71763__$1,(2),inst_71752);
} else {
if((state_val_71764 === (2))){
var inst_71754 = (state_71763[(7)]);
var inst_71754__$1 = (state_71763[(2)]);
var inst_71755 = fluree.db.util.core.exception_QMARK_.call(null,inst_71754__$1);
var state_71763__$1 = (function (){var statearr_71765 = state_71763;
(statearr_71765[(7)] = inst_71754__$1);

return statearr_71765;
})();
if(inst_71755){
var statearr_71766_71779 = state_71763__$1;
(statearr_71766_71779[(1)] = (3));

} else {
var statearr_71767_71780 = state_71763__$1;
(statearr_71767_71780[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71764 === (3))){
var state_71763__$1 = state_71763;
var statearr_71768_71781 = state_71763__$1;
(statearr_71768_71781[(2)] = null);

(statearr_71768_71781[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71764 === (4))){
var inst_71754 = (state_71763[(7)]);
var inst_71758 = cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,inst_71754);
var state_71763__$1 = state_71763;
var statearr_71769_71782 = state_71763__$1;
(statearr_71769_71782[(2)] = inst_71758);

(statearr_71769_71782[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71764 === (5))){
var inst_71754 = (state_71763[(7)]);
var inst_71760 = (state_71763[(2)]);
var inst_71761 = cljs.core.async.put_BANG_.call(null,out,inst_71754);
var state_71763__$1 = (function (){var statearr_71770 = state_71763;
(statearr_71770[(8)] = inst_71760);

return statearr_71770;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71763__$1,inst_71761);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_71771 = [null,null,null,null,null,null,null,null,null];
(statearr_71771[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__);

(statearr_71771[(1)] = (1));

return statearr_71771;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1 = (function (state_71763){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71763);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71772){var ex__2749__auto__ = e71772;
var statearr_71773_71783 = state_71763;
(statearr_71773_71783[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71763[(4)]))){
var statearr_71774_71784 = state_71763;
(statearr_71774_71784[(1)] = cljs.core.first.call(null,(state_71763[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71785 = state_71763;
state_71763 = G__71785;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__ = function(state_71763){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1.call(this,state_71763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71775 = f__2769__auto__.call(null);
(statearr_71775[(6)] = c__2768__auto___71778);

return statearr_71775;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__71786_SHARP_){
if(cljs.core.truth_(p1__71786_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__71787_SHARP_){
var or__4253__auto__ = p1__71787_SHARP_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return token;
}
}));

return true;
}catch (e71788){var e = e71788;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__71789 = opts;
var map__71789__$1 = cljs.core.__destructure_map.call(null,map__71789);
var sub_chan = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var async_cache = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__71789__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__4253__auto__ = object_cache;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__4253__auto__ = async_cache;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_async_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4253__auto__ = storage_read;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4253__auto__ = storage_exists;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = storage_read;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4251__auto__ = storage_write;
if(cljs.core.truth_(and__4251__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71833 = arguments.length;
var i__4865__auto___71834 = (0);
while(true){
if((i__4865__auto___71834 < len__4864__auto___71833)){
args__4870__auto__.push((arguments[i__4865__auto___71834]));

var G__71835 = (i__4865__auto___71834 + (1));
i__4865__auto___71834 = G__71835;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__71792){
var vec__71793 = p__71792;
var opts = cljs.core.nth.call(null,vec__71793,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2768__auto___71836 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71816){
var state_val_71817 = (state_71816[(1)]);
if((state_val_71817 === (1))){
var inst_71796 = fluree.db.connection.get_socket.call(null,conn);
var state_71816__$1 = state_71816;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71816__$1,(2),inst_71796);
} else {
if((state_val_71817 === (2))){
var inst_71798 = (state_71816[(7)]);
var inst_71799 = (state_71816[(8)]);
var inst_71798__$1 = (state_71816[(2)]);
var inst_71799__$1 = (inst_71798__$1 == null);
var state_71816__$1 = (function (){var statearr_71818 = state_71816;
(statearr_71818[(7)] = inst_71798__$1);

(statearr_71818[(8)] = inst_71799__$1);

return statearr_71818;
})();
if(cljs.core.truth_(inst_71799__$1)){
var statearr_71819_71837 = state_71816__$1;
(statearr_71819_71837[(1)] = (3));

} else {
var statearr_71820_71838 = state_71816__$1;
(statearr_71820_71838[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71817 === (3))){
var inst_71799 = (state_71816[(8)]);
var state_71816__$1 = state_71816;
var statearr_71821_71839 = state_71816__$1;
(statearr_71821_71839[(2)] = inst_71799);

(statearr_71821_71839[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71817 === (4))){
var inst_71798 = (state_71816[(7)]);
var inst_71802 = fluree.db.util.core.exception_QMARK_.call(null,inst_71798);
var state_71816__$1 = state_71816;
var statearr_71822_71840 = state_71816__$1;
(statearr_71822_71840[(2)] = inst_71802);

(statearr_71822_71840[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71817 === (5))){
var inst_71804 = (state_71816[(2)]);
var state_71816__$1 = state_71816;
if(cljs.core.truth_(inst_71804)){
var statearr_71823_71841 = state_71816__$1;
(statearr_71823_71841[(1)] = (6));

} else {
var statearr_71824_71842 = state_71816__$1;
(statearr_71824_71842[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71817 === (6))){
var inst_71798 = (state_71816[(7)]);
var inst_71806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71807 = [inst_71798,"Cannot establish connection to a healthy server, disconnecting."];
var inst_71808 = (new cljs.core.PersistentVector(null,2,(5),inst_71806,inst_71807,null));
var inst_71809 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71808);
var inst_71810 = cljs.core.async.close_BANG_.call(null,conn);
var state_71816__$1 = (function (){var statearr_71825 = state_71816;
(statearr_71825[(9)] = inst_71809);

return statearr_71825;
})();
var statearr_71826_71843 = state_71816__$1;
(statearr_71826_71843[(2)] = inst_71810);

(statearr_71826_71843[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71817 === (7))){
var inst_71812 = fluree.db.connection.msg_consumer.call(null,conn);
var state_71816__$1 = state_71816;
var statearr_71827_71844 = state_71816__$1;
(statearr_71827_71844[(2)] = inst_71812);

(statearr_71827_71844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71817 === (8))){
var inst_71814 = (state_71816[(2)]);
var state_71816__$1 = state_71816;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71816__$1,inst_71814);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2746__auto__ = null;
var fluree$db$connection$state_machine__2746__auto____0 = (function (){
var statearr_71828 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71828[(0)] = fluree$db$connection$state_machine__2746__auto__);

(statearr_71828[(1)] = (1));

return statearr_71828;
});
var fluree$db$connection$state_machine__2746__auto____1 = (function (state_71816){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71816);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71829){var ex__2749__auto__ = e71829;
var statearr_71830_71845 = state_71816;
(statearr_71830_71845[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71816[(4)]))){
var statearr_71831_71846 = state_71816;
(statearr_71831_71846[(1)] = cljs.core.first.call(null,(state_71816[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71847 = state_71816;
state_71816 = G__71847;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2746__auto__ = function(state_71816){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2746__auto____1.call(this,state_71816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2746__auto____0;
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2746__auto____1;
return fluree$db$connection$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71832 = f__2769__auto__.call(null);
(statearr_71832[(6)] = c__2768__auto___71836);

return statearr_71832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq71790){
var G__71791 = cljs.core.first.call(null,seq71790);
var seq71790__$1 = cljs.core.next.call(null,seq71790);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71791,seq71790__$1);
}));

