// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__71858 = arguments.length;
switch (G__71858) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71903){
var state_val_71904 = (state_71903[(1)]);
if((state_val_71904 === (7))){
var inst_71873 = typeof user === 'string';
var state_71903__$1 = state_71903;
if(cljs.core.truth_(inst_71873)){
var statearr_71905_71934 = state_71903__$1;
(statearr_71905_71934[(1)] = (9));

} else {
var statearr_71906_71935 = state_71903__$1;
(statearr_71906_71935[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71904 === (1))){
var state_71903__$1 = state_71903;
var statearr_71907_71936 = state_71903__$1;
(statearr_71907_71936[(2)] = null);

(statearr_71907_71936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71904 === (4))){
var inst_71859 = (state_71903[(2)]);
var inst_71860 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71861 = [inst_71859];
var inst_71862 = (new cljs.core.PersistentVector(null,1,(5),inst_71860,inst_71861,null));
var inst_71863 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71862);
var inst_71864 = reject.call(null,inst_71859);
var state_71903__$1 = (function (){var statearr_71908 = state_71903;
(statearr_71908[(7)] = inst_71863);

return statearr_71908;
})();
var statearr_71909_71937 = state_71903__$1;
(statearr_71909_71937[(2)] = inst_71864);

(statearr_71909_71937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71904 === (15))){
var inst_71892 = (state_71903[(2)]);
var inst_71893 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_71892);
var inst_71894 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71895 = cljs.core.constantly.call(null,inst_71893);
var inst_71896 = cljs.core.swap_BANG_.call(null,inst_71894,inst_71895);
var inst_71897 = fluree.db.connection.add_token.call(null,conn,inst_71893);
var inst_71898 = resolve.call(null,inst_71892);
var _ = (function (){var statearr_71910 = state_71903;
(statearr_71910[(4)] = cljs.core.rest.call(null,(state_71903[(4)])));

return statearr_71910;
})();
var state_71903__$1 = (function (){var statearr_71911 = state_71903;
(statearr_71911[(8)] = inst_71896);

(statearr_71911[(9)] = inst_71897);

return statearr_71911;
})();
var statearr_71912_71938 = state_71903__$1;
(statearr_71912_71938[(2)] = inst_71898);

(statearr_71912_71938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71904 === (13))){
var state_71903__$1 = state_71903;
var statearr_71913_71939 = state_71903__$1;
(statearr_71913_71939[(2)] = null);

(statearr_71913_71939[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71904 === (6))){
var state_71903__$1 = state_71903;
var statearr_71914_71940 = state_71903__$1;
(statearr_71914_71940[(2)] = user);

(statearr_71914_71940[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71904 === (3))){
var inst_71901 = (state_71903[(2)]);
var state_71903__$1 = state_71903;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71903__$1,inst_71901);
} else {
if((state_val_71904 === (12))){
var state_71903__$1 = state_71903;
var statearr_71915_71941 = state_71903__$1;
(statearr_71915_71941[(2)] = user);

(statearr_71915_71941[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71904 === (2))){
var _ = (function (){var statearr_71916 = state_71903;
(statearr_71916[(4)] = cljs.core.cons.call(null,(5),(state_71903[(4)])));

return statearr_71916;
})();
var inst_71870 = typeof user === 'number';
var state_71903__$1 = state_71903;
if(cljs.core.truth_(inst_71870)){
var statearr_71917_71942 = state_71903__$1;
(statearr_71917_71942[(1)] = (6));

} else {
var statearr_71918_71943 = state_71903__$1;
(statearr_71918_71943[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71904 === (11))){
var inst_71884 = (state_71903[(2)]);
var state_71903__$1 = state_71903;
var statearr_71920_71944 = state_71903__$1;
(statearr_71920_71944[(2)] = inst_71884);

(statearr_71920_71944[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71904 === (9))){
var inst_71875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71876 = ["_user/username",user];
var inst_71877 = (new cljs.core.PersistentVector(null,2,(5),inst_71875,inst_71876,null));
var state_71903__$1 = state_71903;
var statearr_71921_71945 = state_71903__$1;
(statearr_71921_71945[(2)] = inst_71877);

(statearr_71921_71945[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71904 === (5))){
var _ = (function (){var statearr_71922 = state_71903;
(statearr_71922[(4)] = cljs.core.rest.call(null,(state_71903[(4)])));

return statearr_71922;
})();
var state_71903__$1 = state_71903;
var ex71919 = (state_71903__$1[(2)]);
var statearr_71923_71946 = state_71903__$1;
(statearr_71923_71946[(5)] = ex71919);


var statearr_71924_71947 = state_71903__$1;
(statearr_71924_71947[(1)] = (4));

(statearr_71924_71947[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71904 === (14))){
var inst_71882 = (state_71903[(2)]);
var state_71903__$1 = state_71903;
var statearr_71925_71948 = state_71903__$1;
(statearr_71925_71948[(2)] = inst_71882);

(statearr_71925_71948[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71904 === (10))){
var state_71903__$1 = state_71903;
var statearr_71926_71949 = state_71903__$1;
(statearr_71926_71949[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71904 === (8))){
var inst_71886 = (state_71903[(2)]);
var inst_71887 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_71888 = [account,inst_71886,password,expireSeconds,syncTo];
var inst_71889 = cljs.core.PersistentHashMap.fromArrays(inst_71887,inst_71888);
var inst_71890 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_71889);
var state_71903__$1 = state_71903;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71903__$1,(15),inst_71890);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_71928 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71928[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_71928[(1)] = (1));

return statearr_71928;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_71903){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71903);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71929){var ex__2749__auto__ = e71929;
var statearr_71930_71950 = state_71903;
(statearr_71930_71950[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71903[(4)]))){
var statearr_71931_71951 = state_71903;
(statearr_71931_71951[(1)] = cljs.core.first.call(null,(state_71903[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71952 = state_71903;
state_71903 = G__71952;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_71903){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_71903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71932 = f__2769__auto__.call(null);
(statearr_71932[(6)] = c__2768__auto__);

return statearr_71932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__71954 = arguments.length;
switch (G__71954) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71963){
var state_val_71964 = (state_71963[(1)]);
if((state_val_71964 === (1))){
var inst_71955 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71957 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_71958 = (new cljs.core.PersistentVector(null,4,(5),inst_71956,inst_71957,null));
var inst_71959 = cljs.core.async.put_BANG_.call(null,inst_71955,inst_71958);
var inst_71960 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__71965 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__71966 = null;
var count__71967 = (0);
var i__71968 = (0);
while(true){
if((i__71968 < count__71967)){
var k = cljs.core._nth.call(null,chunk__71966,i__71968);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__71976 = seq__71965;
var G__71977 = chunk__71966;
var G__71978 = count__71967;
var G__71979 = (i__71968 + (1));
seq__71965 = G__71976;
chunk__71966 = G__71977;
count__71967 = G__71978;
i__71968 = G__71979;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__71965);
if(temp__5804__auto__){
var seq__71965__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71965__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__71965__$1);
var G__71980 = cljs.core.chunk_rest.call(null,seq__71965__$1);
var G__71981 = c__4679__auto__;
var G__71982 = cljs.core.count.call(null,c__4679__auto__);
var G__71983 = (0);
seq__71965 = G__71980;
chunk__71966 = G__71981;
count__71967 = G__71982;
i__71968 = G__71983;
continue;
} else {
var k = cljs.core.first.call(null,seq__71965__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__71984 = cljs.core.next.call(null,seq__71965__$1);
var G__71985 = null;
var G__71986 = (0);
var G__71987 = (0);
seq__71965 = G__71984;
chunk__71966 = G__71985;
count__71967 = G__71986;
i__71968 = G__71987;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_71961 = cljs.core.async.take_BANG_.call(null,pc,inst_71960);
var state_71963__$1 = (function (){var statearr_71969 = state_71963;
(statearr_71969[(7)] = inst_71959);

return statearr_71969;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71963__$1,inst_71961);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_71970 = [null,null,null,null,null,null,null,null];
(statearr_71970[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_71970[(1)] = (1));

return statearr_71970;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_71963){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71963);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71971){var ex__2749__auto__ = e71971;
var statearr_71972_71988 = state_71963;
(statearr_71972_71988[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71963[(4)]))){
var statearr_71973_71989 = state_71963;
(statearr_71973_71989[(1)] = cljs.core.first.call(null,(state_71963[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71990 = state_71963;
state_71963 = G__71990;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_71963){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_71963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71974 = f__2769__auto__.call(null);
(statearr_71974[(6)] = c__2768__auto__);

return statearr_71974;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__71992 = arguments.length;
switch (G__71992) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72029){
var state_val_72030 = (state_72029[(1)]);
if((state_val_72030 === (1))){
var state_72029__$1 = state_72029;
var statearr_72031_72052 = state_72029__$1;
(statearr_72031_72052[(2)] = null);

(statearr_72031_72052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72030 === (2))){
var _ = (function (){var statearr_72032 = state_72029;
(statearr_72032[(4)] = cljs.core.cons.call(null,(5),(state_72029[(4)])));

return statearr_72032;
})();
var inst_72004 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_72005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72006 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_72007 = (new cljs.core.PersistentVector(null,1,(5),inst_72005,inst_72006,null));
var inst_72008 = cljs.core.PersistentHashMap.EMPTY;
var inst_72009 = cljs.core.atom.call(null,inst_72008);
var inst_72010 = cljs.core.assoc_in.call(null,inst_72004,inst_72007,inst_72009);
var inst_72011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72012 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_72013 = (new cljs.core.PersistentVector(null,1,(5),inst_72011,inst_72012,null));
var inst_72014 = cljs.core.PersistentHashMap.EMPTY;
var inst_72015 = cljs.core.atom.call(null,inst_72014);
var inst_72016 = cljs.core.assoc_in.call(null,inst_72010,inst_72013,inst_72015);
var inst_72017 = cljs.core.async.promise_chan.call(null);
var inst_72018 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_72016);
var inst_72019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72020 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_72017,null];
var inst_72021 = (new cljs.core.PersistentVector(null,4,(5),inst_72019,inst_72020,null));
var inst_72022 = cljs.core.async.put_BANG_.call(null,inst_72018,inst_72021);
var inst_72023 = (function (){var conn = inst_72016;
var pc = inst_72017;
return (function (x){
if((x == null)){
} else {
var seq__72033_72053 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__72034_72054 = null;
var count__72035_72055 = (0);
var i__72036_72056 = (0);
while(true){
if((i__72036_72056 < count__72035_72055)){
var k_72057 = cljs.core._nth.call(null,chunk__72034_72054,i__72036_72056);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_72057], null),cljs.core.get.call(null,x,k_72057,null));


var G__72058 = seq__72033_72053;
var G__72059 = chunk__72034_72054;
var G__72060 = count__72035_72055;
var G__72061 = (i__72036_72056 + (1));
seq__72033_72053 = G__72058;
chunk__72034_72054 = G__72059;
count__72035_72055 = G__72060;
i__72036_72056 = G__72061;
continue;
} else {
var temp__5804__auto___72062 = cljs.core.seq.call(null,seq__72033_72053);
if(temp__5804__auto___72062){
var seq__72033_72063__$1 = temp__5804__auto___72062;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__72033_72063__$1)){
var c__4679__auto___72064 = cljs.core.chunk_first.call(null,seq__72033_72063__$1);
var G__72065 = cljs.core.chunk_rest.call(null,seq__72033_72063__$1);
var G__72066 = c__4679__auto___72064;
var G__72067 = cljs.core.count.call(null,c__4679__auto___72064);
var G__72068 = (0);
seq__72033_72053 = G__72065;
chunk__72034_72054 = G__72066;
count__72035_72055 = G__72067;
i__72036_72056 = G__72068;
continue;
} else {
var k_72069 = cljs.core.first.call(null,seq__72033_72063__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_72069], null),cljs.core.get.call(null,x,k_72069,null));


var G__72070 = cljs.core.next.call(null,seq__72033_72063__$1);
var G__72071 = null;
var G__72072 = (0);
var G__72073 = (0);
seq__72033_72053 = G__72070;
chunk__72034_72054 = G__72071;
count__72035_72055 = G__72072;
i__72036_72056 = G__72073;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_72024 = cljs.core.async.take_BANG_.call(null,inst_72017,inst_72023);
var ___$1 = (function (){var statearr_72037 = state_72029;
(statearr_72037[(4)] = cljs.core.rest.call(null,(state_72029[(4)])));

return statearr_72037;
})();
var state_72029__$1 = (function (){var statearr_72038 = state_72029;
(statearr_72038[(7)] = inst_72022);

return statearr_72038;
})();
var statearr_72039_72074 = state_72029__$1;
(statearr_72039_72074[(2)] = inst_72024);

(statearr_72039_72074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72030 === (3))){
var inst_72027 = (state_72029[(2)]);
var state_72029__$1 = state_72029;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72029__$1,inst_72027);
} else {
if((state_val_72030 === (4))){
var inst_71993 = (state_72029[(2)]);
var inst_71994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71995 = [inst_71993];
var inst_71996 = (new cljs.core.PersistentVector(null,1,(5),inst_71994,inst_71995,null));
var inst_71997 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71996);
var inst_71998 = reject.call(null,inst_71993);
var state_72029__$1 = (function (){var statearr_72041 = state_72029;
(statearr_72041[(8)] = inst_71997);

return statearr_72041;
})();
var statearr_72042_72075 = state_72029__$1;
(statearr_72042_72075[(2)] = inst_71998);

(statearr_72042_72075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72030 === (5))){
var _ = (function (){var statearr_72043 = state_72029;
(statearr_72043[(4)] = cljs.core.rest.call(null,(state_72029[(4)])));

return statearr_72043;
})();
var state_72029__$1 = state_72029;
var ex72040 = (state_72029__$1[(2)]);
var statearr_72044_72076 = state_72029__$1;
(statearr_72044_72076[(5)] = ex72040);


var statearr_72045_72077 = state_72029__$1;
(statearr_72045_72077[(1)] = (4));

(statearr_72045_72077[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_72046 = [null,null,null,null,null,null,null,null,null];
(statearr_72046[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_72046[(1)] = (1));

return statearr_72046;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_72029){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72047){var ex__2749__auto__ = e72047;
var statearr_72048_72078 = state_72029;
(statearr_72048_72078[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72029[(4)]))){
var statearr_72049_72079 = state_72029;
(statearr_72049_72079[(1)] = cljs.core.first.call(null,(state_72029[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72080 = state_72029;
state_72029 = G__72080;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_72029){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_72029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72050 = f__2769__auto__.call(null);
(statearr_72050[(6)] = c__2768__auto__);

return statearr_72050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__72082 = arguments.length;
switch (G__72082) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__72084 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__72084,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__72084,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__72087 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__72087,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__72087,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72140){
var state_val_72141 = (state_72140[(1)]);
if((state_val_72141 === (7))){
var inst_72101 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72102 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72103 = cljs.core.PersistentHashMap.fromArrays(inst_72101,inst_72102);
var inst_72104 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_72103);
var inst_72105 = (function(){throw inst_72104})();
var state_72140__$1 = state_72140;
var statearr_72142_72171 = state_72140__$1;
(statearr_72142_72171[(2)] = inst_72105);

(statearr_72142_72171[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72141 === (1))){
var state_72140__$1 = state_72140;
var statearr_72143_72172 = state_72140__$1;
(statearr_72143_72172[(2)] = null);

(statearr_72143_72172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72141 === (4))){
var inst_72090 = (state_72140[(2)]);
var inst_72091 = cljs.core.clj__GT_js.call(null,inst_72090);
var inst_72092 = reject.call(null,inst_72091);
var state_72140__$1 = state_72140;
var statearr_72144_72173 = state_72140__$1;
(statearr_72144_72173[(2)] = inst_72092);

(statearr_72144_72173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72141 === (13))){
var inst_72119 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72120 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72121 = cljs.core.PersistentHashMap.fromArrays(inst_72119,inst_72120);
var inst_72122 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_72121);
var inst_72123 = (function(){throw inst_72122})();
var state_72140__$1 = state_72140;
var statearr_72145_72174 = state_72140__$1;
(statearr_72145_72174[(2)] = inst_72123);

(statearr_72145_72174[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72141 === (6))){
var state_72140__$1 = state_72140;
var statearr_72146_72175 = state_72140__$1;
(statearr_72146_72175[(2)] = null);

(statearr_72146_72175[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72141 === (3))){
var inst_72138 = (state_72140[(2)]);
var state_72140__$1 = state_72140;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72140__$1,inst_72138);
} else {
if((state_val_72141 === (12))){
var state_72140__$1 = state_72140;
var statearr_72147_72176 = state_72140__$1;
(statearr_72147_72176[(2)] = null);

(statearr_72147_72176[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72141 === (2))){
var _ = (function (){var statearr_72148 = state_72140;
(statearr_72148[(4)] = cljs.core.cons.call(null,(5),(state_72140[(4)])));

return statearr_72148;
})();
var inst_72098 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_72140__$1 = state_72140;
if(cljs.core.truth_(inst_72098)){
var statearr_72149_72177 = state_72140__$1;
(statearr_72149_72177[(1)] = (6));

} else {
var statearr_72150_72178 = state_72140__$1;
(statearr_72150_72178[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72141 === (11))){
var inst_72116 = (state_72140[(2)]);
var state_72140__$1 = (function (){var statearr_72152 = state_72140;
(statearr_72152[(7)] = inst_72116);

return statearr_72152;
})();
if(cljs.core.truth_(password)){
var statearr_72153_72179 = state_72140__$1;
(statearr_72153_72179[(1)] = (12));

} else {
var statearr_72154_72180 = state_72140__$1;
(statearr_72154_72180[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72141 === (9))){
var state_72140__$1 = state_72140;
var statearr_72155_72181 = state_72140__$1;
(statearr_72155_72181[(2)] = null);

(statearr_72155_72181[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72141 === (5))){
var _ = (function (){var statearr_72156 = state_72140;
(statearr_72156[(4)] = cljs.core.rest.call(null,(state_72140[(4)])));

return statearr_72156;
})();
var state_72140__$1 = state_72140;
var ex72151 = (state_72140__$1[(2)]);
var statearr_72157_72182 = state_72140__$1;
(statearr_72157_72182[(5)] = ex72151);


var statearr_72158_72183 = state_72140__$1;
(statearr_72158_72183[(1)] = (4));

(statearr_72158_72183[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72141 === (14))){
var inst_72125 = (state_72140[(2)]);
var inst_72126 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_72127 = fluree.db.util.core.without_nils.call(null,inst_72126);
var inst_72128 = cljs.core.async.promise_chan.call(null);
var inst_72129 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72131 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_72127,inst_72128,null];
var inst_72132 = (new cljs.core.PersistentVector(null,4,(5),inst_72130,inst_72131,null));
var inst_72133 = cljs.core.async.put_BANG_.call(null,inst_72129,inst_72132);
var inst_72134 = (function (){var _ = inst_72125;
var data = inst_72127;
var pc = inst_72128;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_72135 = cljs.core.async.take_BANG_.call(null,inst_72128,inst_72134);
var _ = (function (){var statearr_72159 = state_72140;
(statearr_72159[(4)] = cljs.core.rest.call(null,(state_72140[(4)])));

return statearr_72159;
})();
var state_72140__$1 = (function (){var statearr_72160 = state_72140;
(statearr_72160[(8)] = inst_72133);

return statearr_72160;
})();
var statearr_72161_72184 = state_72140__$1;
(statearr_72161_72184[(2)] = inst_72135);

(statearr_72161_72184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72141 === (10))){
var inst_72110 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72111 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72112 = cljs.core.PersistentHashMap.fromArrays(inst_72110,inst_72111);
var inst_72113 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_72112);
var inst_72114 = (function(){throw inst_72113})();
var state_72140__$1 = state_72140;
var statearr_72162_72185 = state_72140__$1;
(statearr_72162_72185[(2)] = inst_72114);

(statearr_72162_72185[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72141 === (8))){
var inst_72107 = (state_72140[(2)]);
var state_72140__$1 = (function (){var statearr_72163 = state_72140;
(statearr_72163[(9)] = inst_72107);

return statearr_72163;
})();
if(cljs.core.truth_(ledger)){
var statearr_72164_72186 = state_72140__$1;
(statearr_72164_72186[(1)] = (9));

} else {
var statearr_72165_72187 = state_72140__$1;
(statearr_72165_72187[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0 = (function (){
var statearr_72166 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72166[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2746__auto__);

(statearr_72166[(1)] = (1));

return statearr_72166;
});
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1 = (function (state_72140){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72140);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72167){var ex__2749__auto__ = e72167;
var statearr_72168_72188 = state_72140;
(statearr_72168_72188[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72140[(4)]))){
var statearr_72169_72189 = state_72140;
(statearr_72169_72189[(1)] = cljs.core.first.call(null,(state_72140[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72190 = state_72140;
state_72140 = G__72190;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__ = function(state_72140){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1.call(this,state_72140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72170 = f__2769__auto__.call(null);
(statearr_72170[(6)] = c__2768__auto__);

return statearr_72170;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__72192 = arguments.length;
switch (G__72192) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72259){
var state_val_72260 = (state_72259[(1)]);
if((state_val_72260 === (7))){
var inst_72204 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72205 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72206 = cljs.core.PersistentHashMap.fromArrays(inst_72204,inst_72205);
var inst_72207 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_72206);
var inst_72208 = (function(){throw inst_72207})();
var state_72259__$1 = state_72259;
var statearr_72261_72300 = state_72259__$1;
(statearr_72261_72300[(2)] = inst_72208);

(statearr_72261_72300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (20))){
var inst_72242 = (state_72259[(2)]);
var inst_72243 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_72244 = [ledger,password,user,auth,expire];
var inst_72245 = cljs.core.PersistentHashMap.fromArrays(inst_72243,inst_72244);
var inst_72246 = fluree.db.util.core.without_nils.call(null,inst_72245);
var inst_72247 = cljs.core.async.promise_chan.call(null);
var inst_72248 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72249 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72250 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_72246,inst_72247,null];
var inst_72251 = (new cljs.core.PersistentVector(null,4,(5),inst_72249,inst_72250,null));
var inst_72252 = cljs.core.async.put_BANG_.call(null,inst_72248,inst_72251);
var inst_72253 = (function (){var _ = inst_72242;
var data = inst_72246;
var pc = inst_72247;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_72254 = cljs.core.async.take_BANG_.call(null,inst_72247,inst_72253);
var _ = (function (){var statearr_72262 = state_72259;
(statearr_72262[(4)] = cljs.core.rest.call(null,(state_72259[(4)])));

return statearr_72262;
})();
var state_72259__$1 = (function (){var statearr_72263 = state_72259;
(statearr_72263[(7)] = inst_72252);

return statearr_72263;
})();
var statearr_72264_72301 = state_72259__$1;
(statearr_72264_72301[(2)] = inst_72254);

(statearr_72264_72301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (1))){
var state_72259__$1 = state_72259;
var statearr_72265_72302 = state_72259__$1;
(statearr_72265_72302[(2)] = null);

(statearr_72265_72302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (4))){
var inst_72193 = (state_72259[(2)]);
var inst_72194 = cljs.core.clj__GT_js.call(null,inst_72193);
var inst_72195 = reject.call(null,inst_72194);
var state_72259__$1 = state_72259;
var statearr_72266_72303 = state_72259__$1;
(statearr_72266_72303[(2)] = inst_72195);

(statearr_72266_72303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (15))){
var inst_72229 = (state_72259[(8)]);
var state_72259__$1 = state_72259;
var statearr_72267_72304 = state_72259__$1;
(statearr_72267_72304[(2)] = inst_72229);

(statearr_72267_72304[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (13))){
var inst_72222 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72223 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72224 = cljs.core.PersistentHashMap.fromArrays(inst_72222,inst_72223);
var inst_72225 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_72224);
var inst_72226 = (function(){throw inst_72225})();
var state_72259__$1 = state_72259;
var statearr_72268_72305 = state_72259__$1;
(statearr_72268_72305[(2)] = inst_72226);

(statearr_72268_72305[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (6))){
var state_72259__$1 = state_72259;
var statearr_72269_72306 = state_72259__$1;
(statearr_72269_72306[(2)] = null);

(statearr_72269_72306[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (17))){
var inst_72233 = (state_72259[(2)]);
var state_72259__$1 = state_72259;
if(cljs.core.truth_(inst_72233)){
var statearr_72270_72307 = state_72259__$1;
(statearr_72270_72307[(1)] = (18));

} else {
var statearr_72271_72308 = state_72259__$1;
(statearr_72271_72308[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (3))){
var inst_72257 = (state_72259[(2)]);
var state_72259__$1 = state_72259;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72259__$1,inst_72257);
} else {
if((state_val_72260 === (12))){
var state_72259__$1 = state_72259;
var statearr_72272_72309 = state_72259__$1;
(statearr_72272_72309[(2)] = null);

(statearr_72272_72309[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (2))){
var _ = (function (){var statearr_72273 = state_72259;
(statearr_72273[(4)] = cljs.core.cons.call(null,(5),(state_72259[(4)])));

return statearr_72273;
})();
var inst_72201 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_72259__$1 = state_72259;
if(cljs.core.truth_(inst_72201)){
var statearr_72274_72310 = state_72259__$1;
(statearr_72274_72310[(1)] = (6));

} else {
var statearr_72275_72311 = state_72259__$1;
(statearr_72275_72311[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (19))){
var inst_72236 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72237 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72238 = cljs.core.PersistentHashMap.fromArrays(inst_72236,inst_72237);
var inst_72239 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_72238);
var inst_72240 = (function(){throw inst_72239})();
var state_72259__$1 = state_72259;
var statearr_72276_72312 = state_72259__$1;
(statearr_72276_72312[(2)] = inst_72240);

(statearr_72276_72312[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (11))){
var inst_72219 = (state_72259[(2)]);
var state_72259__$1 = (function (){var statearr_72278 = state_72259;
(statearr_72278[(9)] = inst_72219);

return statearr_72278;
})();
if(cljs.core.truth_(password)){
var statearr_72279_72313 = state_72259__$1;
(statearr_72279_72313[(1)] = (12));

} else {
var statearr_72280_72314 = state_72259__$1;
(statearr_72280_72314[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (9))){
var state_72259__$1 = state_72259;
var statearr_72281_72315 = state_72259__$1;
(statearr_72281_72315[(2)] = null);

(statearr_72281_72315[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (5))){
var _ = (function (){var statearr_72282 = state_72259;
(statearr_72282[(4)] = cljs.core.rest.call(null,(state_72259[(4)])));

return statearr_72282;
})();
var state_72259__$1 = state_72259;
var ex72277 = (state_72259__$1[(2)]);
var statearr_72283_72316 = state_72259__$1;
(statearr_72283_72316[(5)] = ex72277);


var statearr_72284_72317 = state_72259__$1;
(statearr_72284_72317[(1)] = (4));

(statearr_72284_72317[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (14))){
var inst_72229 = (state_72259[(8)]);
var inst_72228 = (state_72259[(2)]);
var inst_72229__$1 = user;
var state_72259__$1 = (function (){var statearr_72285 = state_72259;
(statearr_72285[(8)] = inst_72229__$1);

(statearr_72285[(10)] = inst_72228);

return statearr_72285;
})();
if(cljs.core.truth_(inst_72229__$1)){
var statearr_72286_72318 = state_72259__$1;
(statearr_72286_72318[(1)] = (15));

} else {
var statearr_72287_72319 = state_72259__$1;
(statearr_72287_72319[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (16))){
var state_72259__$1 = state_72259;
var statearr_72288_72320 = state_72259__$1;
(statearr_72288_72320[(2)] = auth);

(statearr_72288_72320[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (10))){
var inst_72213 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72214 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72215 = cljs.core.PersistentHashMap.fromArrays(inst_72213,inst_72214);
var inst_72216 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_72215);
var inst_72217 = (function(){throw inst_72216})();
var state_72259__$1 = state_72259;
var statearr_72289_72321 = state_72259__$1;
(statearr_72289_72321[(2)] = inst_72217);

(statearr_72289_72321[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (18))){
var state_72259__$1 = state_72259;
var statearr_72290_72322 = state_72259__$1;
(statearr_72290_72322[(2)] = null);

(statearr_72290_72322[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72260 === (8))){
var inst_72210 = (state_72259[(2)]);
var state_72259__$1 = (function (){var statearr_72291 = state_72259;
(statearr_72291[(11)] = inst_72210);

return statearr_72291;
})();
if(cljs.core.truth_(ledger)){
var statearr_72292_72323 = state_72259__$1;
(statearr_72292_72323[(1)] = (9));

} else {
var statearr_72293_72324 = state_72259__$1;
(statearr_72293_72324[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_72294 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72294[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_72294[(1)] = (1));

return statearr_72294;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_72259){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72259);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72295){var ex__2749__auto__ = e72295;
var statearr_72296_72325 = state_72259;
(statearr_72296_72325[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72259[(4)]))){
var statearr_72297_72326 = state_72259;
(statearr_72297_72326[(1)] = cljs.core.first.call(null,(state_72259[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72327 = state_72259;
state_72259 = G__72327;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_72259){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_72259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72298 = f__2769__auto__.call(null);
(statearr_72298[(6)] = c__2768__auto__);

return statearr_72298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__72329 = arguments.length;
switch (G__72329) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72364){
var state_val_72365 = (state_72364[(1)]);
if((state_val_72365 === (1))){
var state_72364__$1 = state_72364;
var statearr_72366_72386 = state_72364__$1;
(statearr_72366_72386[(2)] = null);

(statearr_72366_72386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72365 === (2))){
var _ = (function (){var statearr_72367 = state_72364;
(statearr_72367[(4)] = cljs.core.cons.call(null,(5),(state_72364[(4)])));

return statearr_72367;
})();
var inst_72338 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_72364__$1 = state_72364;
if(cljs.core.truth_(inst_72338)){
var statearr_72368_72387 = state_72364__$1;
(statearr_72368_72387[(1)] = (6));

} else {
var statearr_72369_72388 = state_72364__$1;
(statearr_72369_72388[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72365 === (3))){
var inst_72362 = (state_72364[(2)]);
var state_72364__$1 = state_72364;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72364__$1,inst_72362);
} else {
if((state_val_72365 === (4))){
var inst_72330 = (state_72364[(2)]);
var inst_72331 = cljs.core.clj__GT_js.call(null,inst_72330);
var inst_72332 = reject.call(null,inst_72331);
var state_72364__$1 = state_72364;
var statearr_72371_72389 = state_72364__$1;
(statearr_72371_72389[(2)] = inst_72332);

(statearr_72371_72389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72365 === (5))){
var _ = (function (){var statearr_72372 = state_72364;
(statearr_72372[(4)] = cljs.core.rest.call(null,(state_72364[(4)])));

return statearr_72372;
})();
var state_72364__$1 = state_72364;
var ex72370 = (state_72364__$1[(2)]);
var statearr_72373_72390 = state_72364__$1;
(statearr_72373_72390[(5)] = ex72370);


var statearr_72374_72391 = state_72364__$1;
(statearr_72374_72391[(1)] = (4));

(statearr_72374_72391[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72365 === (6))){
var state_72364__$1 = state_72364;
var statearr_72375_72392 = state_72364__$1;
(statearr_72375_72392[(2)] = null);

(statearr_72375_72392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72365 === (7))){
var inst_72341 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72342 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72343 = cljs.core.PersistentHashMap.fromArrays(inst_72341,inst_72342);
var inst_72344 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_72343);
var inst_72345 = (function(){throw inst_72344})();
var state_72364__$1 = state_72364;
var statearr_72376_72393 = state_72364__$1;
(statearr_72376_72393[(2)] = inst_72345);

(statearr_72376_72393[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72365 === (8))){
var inst_72347 = (state_72364[(2)]);
var inst_72348 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_72349 = [jwt,expire];
var inst_72350 = cljs.core.PersistentHashMap.fromArrays(inst_72348,inst_72349);
var inst_72351 = fluree.db.util.core.without_nils.call(null,inst_72350);
var inst_72352 = cljs.core.async.promise_chan.call(null);
var inst_72353 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72354 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72355 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_72351,inst_72352,null];
var inst_72356 = (new cljs.core.PersistentVector(null,4,(5),inst_72354,inst_72355,null));
var inst_72357 = cljs.core.async.put_BANG_.call(null,inst_72353,inst_72356);
var inst_72358 = (function (){var _ = inst_72347;
var data = inst_72351;
var pc = inst_72352;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_72359 = cljs.core.async.take_BANG_.call(null,inst_72352,inst_72358);
var _ = (function (){var statearr_72377 = state_72364;
(statearr_72377[(4)] = cljs.core.rest.call(null,(state_72364[(4)])));

return statearr_72377;
})();
var state_72364__$1 = (function (){var statearr_72378 = state_72364;
(statearr_72378[(7)] = inst_72357);

return statearr_72378;
})();
var statearr_72379_72394 = state_72364__$1;
(statearr_72379_72394[(2)] = inst_72359);

(statearr_72379_72394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_72380 = [null,null,null,null,null,null,null,null];
(statearr_72380[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_72380[(1)] = (1));

return statearr_72380;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_72364){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72364);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72381){var ex__2749__auto__ = e72381;
var statearr_72382_72395 = state_72364;
(statearr_72382_72395[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72364[(4)]))){
var statearr_72383_72396 = state_72364;
(statearr_72383_72396[(1)] = cljs.core.first.call(null,(state_72364[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72397 = state_72364;
state_72364 = G__72397;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_72364){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_72364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72384 = f__2769__auto__.call(null);
(statearr_72384[(6)] = c__2768__auto__);

return statearr_72384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

