// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-ledger-id] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__24948 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__24948,(0),null);
var network = cljs.core.nth.call(null,vec__24948,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__24948,(2),null);
if(cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
/**
 * Predicates to exclude from the database
 */
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(130),(106)]);
fluree.db.graphdb.exclude_flake_QMARK_ = (function fluree$db$graphdb$exclude_flake_QMARK_(f){
return cljs.core.contains_QMARK_.call(null,fluree.db.graphdb.exclude_predicates,fluree.db.flake.p.call(null,f));
});
fluree.db.graphdb.include_flake_QMARK_ = cljs.core.complement.call(null,fluree.db.graphdb.exclude_flake_QMARK_);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__24951){
var map__24952 = p__24951;
var map__24952__$1 = cljs.core.__destructure_map.call(null,map__24952);
var opts = map__24952__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__24952__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25012){
var state_val_25013 = (state_25012[(1)]);
if((state_val_25013 === (7))){
var inst_24983 = cljs.core.not.call(null,reindex_QMARK_);
var state_25012__$1 = state_25012;
var statearr_25014_25038 = state_25012__$1;
(statearr_25014_25038[(2)] = inst_24983);

(statearr_25014_25038[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (1))){
var state_25012__$1 = state_25012;
var statearr_25015_25039 = state_25012__$1;
(statearr_25015_25039[(2)] = null);

(statearr_25015_25039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (4))){
var inst_24953 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25016_25040 = state_25012__$1;
(statearr_25016_25040[(2)] = inst_24953);

(statearr_25016_25040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (6))){
var inst_24967 = (state_25012[(7)]);
var inst_24981 = (state_25012[(8)]);
var inst_24973 = (state_25012[(9)]);
var inst_24966 = (state_25012[(2)]);
var inst_24967__$1 = fluree.db.util.async.throw_err.call(null,inst_24966);
var inst_24968 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_24969 = cljs.core.__destructure_map.call(null,inst_24968);
var inst_24970 = cljs.core.get.call(null,inst_24969,new cljs.core.Keyword(null,"post","post",269697687));
var inst_24971 = cljs.core.get.call(null,inst_24969,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_24972 = fluree.db.flake.size_bytes.call(null,inst_24967__$1);
var inst_24973__$1 = (inst_24971 + inst_24972);
var inst_24974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24975 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_24976 = (new cljs.core.PersistentVector(null,2,(5),inst_24974,inst_24975,null));
var inst_24977 = cljs.core.get_in.call(null,db,inst_24976);
var inst_24978 = cljs.core.__destructure_map.call(null,inst_24977);
var inst_24979 = cljs.core.get.call(null,inst_24978,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_24980 = cljs.core.get.call(null,inst_24978,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_24981__$1 = (inst_24973__$1 > inst_24980);
var state_25012__$1 = (function (){var statearr_25017 = state_25012;
(statearr_25017[(10)] = inst_24979);

(statearr_25017[(7)] = inst_24967__$1);

(statearr_25017[(8)] = inst_24981__$1);

(statearr_25017[(9)] = inst_24973__$1);

(statearr_25017[(11)] = inst_24970);

return statearr_25017;
})();
if(cljs.core.truth_(inst_24981__$1)){
var statearr_25018_25041 = state_25012__$1;
(statearr_25018_25041[(1)] = (7));

} else {
var statearr_25019_25042 = state_25012__$1;
(statearr_25019_25042[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (3))){
var inst_25010 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25012__$1,inst_25010);
} else {
if((state_val_25013 === (12))){
var inst_24967 = (state_25012[(7)]);
var inst_24973 = (state_25012[(9)]);
var inst_24970 = (state_25012[(11)]);
var inst_24996 = (state_25012[(2)]);
var inst_24997 = cljs.core.into.call(null,inst_24970,inst_24967);
var inst_24998 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_24999 = cljs.core.swap_BANG_.call(null,inst_24998,cljs.core.empty);
var inst_25000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25001 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25002 = (new cljs.core.PersistentVector(null,2,(5),inst_25000,inst_25001,null));
var inst_25003 = cljs.core.assoc_in.call(null,db,inst_25002,inst_24997);
var inst_25004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25005 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25006 = (new cljs.core.PersistentVector(null,2,(5),inst_25004,inst_25005,null));
var inst_25007 = cljs.core.assoc_in.call(null,inst_25003,inst_25006,inst_24973);
var _ = (function (){var statearr_25020 = state_25012;
(statearr_25020[(4)] = cljs.core.rest.call(null,(state_25012[(4)])));

return statearr_25020;
})();
var state_25012__$1 = (function (){var statearr_25021 = state_25012;
(statearr_25021[(12)] = inst_24999);

(statearr_25021[(13)] = inst_24996);

return statearr_25021;
})();
var statearr_25022_25043 = state_25012__$1;
(statearr_25022_25043[(2)] = inst_25007);

(statearr_25022_25043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (2))){
var _ = (function (){var statearr_25023 = state_25012;
(statearr_25023[(4)] = cljs.core.cons.call(null,(5),(state_25012[(4)])));

return statearr_25023;
})();
var inst_24961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24962 = [pred_id];
var inst_24963 = (new cljs.core.PersistentVector(null,1,(5),inst_24961,inst_24962,null));
var inst_24964 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_24963);
var state_25012__$1 = state_25012;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25012__$1,(6),inst_24964);
} else {
if((state_val_25013 === (11))){
var state_25012__$1 = state_25012;
var statearr_25025_25044 = state_25012__$1;
(statearr_25025_25044[(2)] = null);

(statearr_25025_25044[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (9))){
var inst_24986 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
if(cljs.core.truth_(inst_24986)){
var statearr_25026_25045 = state_25012__$1;
(statearr_25026_25045[(1)] = (10));

} else {
var statearr_25027_25046 = state_25012__$1;
(statearr_25027_25046[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (5))){
var _ = (function (){var statearr_25028 = state_25012;
(statearr_25028[(4)] = cljs.core.rest.call(null,(state_25012[(4)])));

return statearr_25028;
})();
var state_25012__$1 = state_25012;
var ex25024 = (state_25012__$1[(2)]);
var statearr_25029_25047 = state_25012__$1;
(statearr_25029_25047[(5)] = ex25024);


if((ex25024 instanceof Error)){
var statearr_25030_25048 = state_25012__$1;
(statearr_25030_25048[(1)] = (4));

(statearr_25030_25048[(5)] = null);

} else {
throw ex25024;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (10))){
var inst_24988 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_24989 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24990 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_24991 = cljs.core.PersistentHashMap.fromArrays(inst_24989,inst_24990);
var inst_24992 = cljs.core.ex_info.call(null,inst_24988,inst_24991);
var inst_24993 = (function(){throw inst_24992})();
var state_25012__$1 = state_25012;
var statearr_25031_25049 = state_25012__$1;
(statearr_25031_25049[(2)] = inst_24993);

(statearr_25031_25049[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (8))){
var inst_24981 = (state_25012[(8)]);
var state_25012__$1 = state_25012;
var statearr_25032_25050 = state_25012__$1;
(statearr_25032_25050[(2)] = inst_24981);

(statearr_25032_25050[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0 = (function (){
var statearr_25033 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25033[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__);

(statearr_25033[(1)] = (1));

return statearr_25033;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1 = (function (state_25012){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25012);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25034){var ex__2749__auto__ = e25034;
var statearr_25035_25051 = state_25012;
(statearr_25035_25051[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25012[(4)]))){
var statearr_25036_25052 = state_25012;
(statearr_25036_25052[(1)] = cljs.core.first.call(null,(state_25012[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25053 = state_25012;
state_25012 = G__25053;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__ = function(state_25012){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1.call(this,state_25012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25037 = f__2769__auto__.call(null);
(statearr_25037[(6)] = c__2768__auto__);

return statearr_25037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__25056 = arguments.length;
switch (G__25056) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25256){
var state_val_25257 = (state_25256[(1)]);
if((state_val_25257 === (7))){
var state_25256__$1 = state_25256;
var statearr_25258_25325 = state_25256__$1;
(statearr_25258_25325[(2)] = null);

(statearr_25258_25325[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (20))){
var inst_25092 = (state_25256[(7)]);
var inst_25181 = (state_25256[(8)]);
var inst_25178 = (state_25256[(9)]);
var inst_25143 = (state_25256[(10)]);
var inst_25093 = (state_25256[(11)]);
var inst_25177 = (state_25256[(12)]);
var inst_25179 = (state_25256[(13)]);
var inst_25180 = (state_25256[(14)]);
var inst_25176 = (state_25256[(15)]);
var inst_25191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25192 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25193 = (new cljs.core.PersistentVector(null,2,(5),inst_25191,inst_25192,null));
var inst_25194 = cljs.core.get_in.call(null,inst_25143,inst_25193);
var inst_25195 = (inst_25194 + inst_25092);
var inst_25196 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25197 = [inst_25176,inst_25177,inst_25178,inst_25179,inst_25180,inst_25195];
var inst_25198 = cljs.core.PersistentHashMap.fromArrays(inst_25196,inst_25197);
var inst_25199 = cljs.core.assoc.call(null,inst_25143,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_25181,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_25198);
var state_25256__$1 = (function (){var statearr_25259 = state_25256;
(statearr_25259[(16)] = inst_25199);

return statearr_25259;
})();
if(cljs.core.truth_(inst_25093)){
var statearr_25260_25326 = state_25256__$1;
(statearr_25260_25326[(1)] = (23));

} else {
var statearr_25261_25327 = state_25256__$1;
(statearr_25261_25327[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (27))){
var inst_25199 = (state_25256[(16)]);
var state_25256__$1 = state_25256;
var statearr_25262_25328 = state_25256__$1;
(statearr_25262_25328[(2)] = inst_25199);

(statearr_25262_25328[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (1))){
var state_25256__$1 = state_25256;
var statearr_25263_25329 = state_25256__$1;
(statearr_25263_25329[(2)] = null);

(statearr_25263_25329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (24))){
var inst_25199 = (state_25256[(16)]);
var inst_25203 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_25199);
var inst_25204 = (inst_25203 == null);
var state_25256__$1 = state_25256;
var statearr_25264_25330 = state_25256__$1;
(statearr_25264_25330[(2)] = inst_25204);

(statearr_25264_25330[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (39))){
var inst_25238 = (state_25256[(17)]);
var inst_25229 = (state_25256[(18)]);
var inst_25188 = (state_25256[(19)]);
var inst_25230 = (state_25256[(20)]);
var inst_25180 = (state_25256[(14)]);
var inst_25187 = (state_25256[(21)]);
var inst_25231 = (state_25256[(22)]);
var inst_25245 = (state_25256[(2)]);
var inst_25246 = cljs.core.conj.call(null,inst_25180,inst_25187);
var inst_25175 = inst_25188;
var inst_25176 = inst_25230;
var inst_25177 = inst_25231;
var inst_25178 = inst_25238;
var inst_25179 = inst_25245;
var inst_25180__$1 = inst_25246;
var inst_25181 = inst_25229;
var state_25256__$1 = (function (){var statearr_25265 = state_25256;
(statearr_25265[(8)] = inst_25181);

(statearr_25265[(23)] = inst_25175);

(statearr_25265[(9)] = inst_25178);

(statearr_25265[(12)] = inst_25177);

(statearr_25265[(13)] = inst_25179);

(statearr_25265[(14)] = inst_25180__$1);

(statearr_25265[(15)] = inst_25176);

return statearr_25265;
})();
var statearr_25266_25331 = state_25256__$1;
(statearr_25266_25331[(2)] = null);

(statearr_25266_25331[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (4))){
var inst_25057 = (state_25256[(2)]);
var state_25256__$1 = state_25256;
var statearr_25267_25332 = state_25256__$1;
(statearr_25267_25332[(2)] = inst_25057);

(statearr_25267_25332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (15))){
var inst_25115 = (state_25256[(24)]);
var state_25256__$1 = state_25256;
var statearr_25268_25333 = state_25256__$1;
(statearr_25268_25333[(2)] = inst_25115);

(statearr_25268_25333[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (21))){
var inst_25092 = (state_25256[(7)]);
var inst_25181 = (state_25256[(8)]);
var inst_25091 = (state_25256[(25)]);
var inst_25087 = (state_25256[(26)]);
var inst_25153 = (state_25256[(27)]);
var inst_25094 = (state_25256[(28)]);
var inst_25064 = (state_25256[(29)]);
var inst_25175 = (state_25256[(23)]);
var inst_25152 = (state_25256[(30)]);
var inst_25178 = (state_25256[(9)]);
var inst_25083 = (state_25256[(31)]);
var inst_25079 = (state_25256[(32)]);
var inst_25143 = (state_25256[(10)]);
var inst_25188 = (state_25256[(19)]);
var inst_25093 = (state_25256[(11)]);
var inst_25177 = (state_25256[(12)]);
var inst_25179 = (state_25256[(13)]);
var inst_25180 = (state_25256[(14)]);
var inst_25176 = (state_25256[(15)]);
var inst_25187 = (state_25256[(21)]);
var inst_25080 = (state_25256[(33)]);
var inst_25102 = (state_25256[(34)]);
var inst_25096 = (state_25256[(35)]);
var inst_25226 = fluree.db.flake.s.call(null,inst_25187);
var inst_25227 = fluree.db.flake.sid__GT_cid.call(null,inst_25226);
var inst_25228 = (function (){var flakes_bytes = inst_25092;
var t = inst_25064;
var vec__25148 = inst_25080;
var spot = inst_25176;
var add_flakes = inst_25080;
var root_setting_change_QMARK_ = inst_25094;
var ref_QMARK__map = inst_25091;
var r = inst_25188;
var psot = inst_25177;
var add_pred_to_idx_QMARK_ = inst_25102;
var seq__25184 = inst_25188;
var _ = inst_25079;
var tspo = inst_25180;
var seq__25149 = inst_25153;
var cid = inst_25227;
var ecount = inst_25181;
var pred_ecount = inst_25096;
var db_STAR_ = inst_25143;
var system_change_QMARK_ = inst_25093;
var add_preds = inst_25083;
var opst = inst_25179;
var first__25150 = inst_25152;
var G__25147 = inst_25175;
var idx_QMARK__map = inst_25087;
var vec__25183 = inst_25175;
var post = inst_25178;
var first__25185 = inst_25187;
var f = inst_25187;
return (function (p1__25054_SHARP_){
if(cljs.core.truth_(p1__25054_SHARP_)){
var x__4336__auto__ = p1__25054_SHARP_;
var y__4337__auto__ = fluree.db.flake.s.call(null,f);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
} else {
return fluree.db.flake.s.call(null,f);
}
});
})();
var inst_25229 = cljs.core.update.call(null,inst_25181,inst_25227,inst_25228);
var inst_25230 = cljs.core.conj.call(null,inst_25176,inst_25187);
var inst_25231 = cljs.core.conj.call(null,inst_25177,inst_25187);
var inst_25232 = fluree.db.flake.p.call(null,inst_25187);
var inst_25233 = cljs.core.get.call(null,inst_25087,inst_25232);
var state_25256__$1 = (function (){var statearr_25269 = state_25256;
(statearr_25269[(18)] = inst_25229);

(statearr_25269[(20)] = inst_25230);

(statearr_25269[(22)] = inst_25231);

return statearr_25269;
})();
if(cljs.core.truth_(inst_25233)){
var statearr_25270_25334 = state_25256__$1;
(statearr_25270_25334[(1)] = (34));

} else {
var statearr_25271_25335 = state_25256__$1;
(statearr_25271_25335[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (31))){
var inst_25215 = (state_25256[(36)]);
var state_25256__$1 = state_25256;
var statearr_25272_25336 = state_25256__$1;
(statearr_25272_25336[(2)] = inst_25215);

(statearr_25272_25336[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (32))){
var inst_25224 = (state_25256[(2)]);
var state_25256__$1 = state_25256;
var statearr_25273_25337 = state_25256__$1;
(statearr_25273_25337[(2)] = inst_25224);

(statearr_25273_25337[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (33))){
var inst_25215 = (state_25256[(36)]);
var inst_25219 = (state_25256[(2)]);
var inst_25220 = fluree.db.util.async.throw_err.call(null,inst_25219);
var inst_25221 = cljs.core.assoc.call(null,inst_25215,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_25220);
var state_25256__$1 = state_25256;
var statearr_25274_25338 = state_25256__$1;
(statearr_25274_25338[(2)] = inst_25221);

(statearr_25274_25338[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (13))){
var inst_25092 = (state_25256[(7)]);
var inst_25064 = (state_25256[(29)]);
var inst_25143 = (state_25256[(10)]);
var inst_25080 = (state_25256[(33)]);
var inst_25133 = (state_25256[(2)]);
var inst_25134 = cljs.core.assoc.call(null,inst_25133,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25064);
var inst_25135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25136 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25137 = (new cljs.core.PersistentVector(null,2,(5),inst_25135,inst_25136,null));
var inst_25138 = cljs.core.update_in.call(null,inst_25134,inst_25137,cljs.core._PLUS_,inst_25092);
var inst_25139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25140 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_25141 = (new cljs.core.PersistentVector(null,2,(5),inst_25139,inst_25140,null));
var inst_25142 = cljs.core.count.call(null,inst_25080);
var inst_25143__$1 = cljs.core.update_in.call(null,inst_25138,inst_25141,cljs.core._PLUS_,inst_25142);
var inst_25151 = cljs.core.seq.call(null,inst_25080);
var inst_25152 = cljs.core.first.call(null,inst_25151);
var inst_25153 = cljs.core.next.call(null,inst_25151);
var inst_25154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25155 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_25156 = (new cljs.core.PersistentVector(null,2,(5),inst_25154,inst_25155,null));
var inst_25157 = cljs.core.get_in.call(null,inst_25143__$1,inst_25156);
var inst_25158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25159 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_25160 = (new cljs.core.PersistentVector(null,2,(5),inst_25158,inst_25159,null));
var inst_25161 = cljs.core.get_in.call(null,inst_25143__$1,inst_25160);
var inst_25162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25163 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25164 = (new cljs.core.PersistentVector(null,2,(5),inst_25162,inst_25163,null));
var inst_25165 = cljs.core.get_in.call(null,inst_25143__$1,inst_25164);
var inst_25166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25167 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_25168 = (new cljs.core.PersistentVector(null,2,(5),inst_25166,inst_25167,null));
var inst_25169 = cljs.core.get_in.call(null,inst_25143__$1,inst_25168);
var inst_25170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25171 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"tspo","tspo",-440144953)];
var inst_25172 = (new cljs.core.PersistentVector(null,2,(5),inst_25170,inst_25171,null));
var inst_25173 = cljs.core.get_in.call(null,inst_25143__$1,inst_25172);
var inst_25174 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25175 = inst_25080;
var inst_25176 = inst_25157;
var inst_25177 = inst_25161;
var inst_25178 = inst_25165;
var inst_25179 = inst_25169;
var inst_25180 = inst_25173;
var inst_25181 = inst_25174;
var state_25256__$1 = (function (){var statearr_25275 = state_25256;
(statearr_25275[(8)] = inst_25181);

(statearr_25275[(27)] = inst_25153);

(statearr_25275[(23)] = inst_25175);

(statearr_25275[(30)] = inst_25152);

(statearr_25275[(9)] = inst_25178);

(statearr_25275[(10)] = inst_25143__$1);

(statearr_25275[(12)] = inst_25177);

(statearr_25275[(13)] = inst_25179);

(statearr_25275[(14)] = inst_25180);

(statearr_25275[(15)] = inst_25176);

return statearr_25275;
})();
var statearr_25276_25339 = state_25256__$1;
(statearr_25276_25339[(2)] = null);

(statearr_25276_25339[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (22))){
var inst_25249 = (state_25256[(2)]);
var state_25256__$1 = state_25256;
var statearr_25277_25340 = state_25256__$1;
(statearr_25277_25340[(2)] = inst_25249);

(statearr_25277_25340[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (36))){
var inst_25091 = (state_25256[(25)]);
var inst_25187 = (state_25256[(21)]);
var inst_25238 = (state_25256[(2)]);
var inst_25239 = fluree.db.flake.p.call(null,inst_25187);
var inst_25240 = cljs.core.get.call(null,inst_25091,inst_25239);
var state_25256__$1 = (function (){var statearr_25278 = state_25256;
(statearr_25278[(17)] = inst_25238);

return statearr_25278;
})();
if(cljs.core.truth_(inst_25240)){
var statearr_25279_25341 = state_25256__$1;
(statearr_25279_25341[(1)] = (37));

} else {
var statearr_25280_25342 = state_25256__$1;
(statearr_25280_25342[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (29))){
var inst_25199 = (state_25256[(16)]);
var inst_25210 = (state_25256[(2)]);
var inst_25211 = fluree.db.util.async.throw_err.call(null,inst_25210);
var inst_25212 = cljs.core.assoc.call(null,inst_25199,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_25211);
var state_25256__$1 = state_25256;
var statearr_25281_25343 = state_25256__$1;
(statearr_25281_25343[(2)] = inst_25212);

(statearr_25281_25343[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (6))){
var inst_25064 = (state_25256[(29)]);
var inst_25069 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25070 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25071 = ["Invalid with called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25069)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25070)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25064),"."].join('');
var inst_25072 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25073 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25074 = cljs.core.PersistentHashMap.fromArrays(inst_25072,inst_25073);
var inst_25075 = cljs.core.ex_info.call(null,inst_25071,inst_25074);
var inst_25076 = (function(){throw inst_25075})();
var state_25256__$1 = state_25256;
var statearr_25282_25344 = state_25256__$1;
(statearr_25282_25344[(2)] = inst_25076);

(statearr_25282_25344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (28))){
var inst_25094 = (state_25256[(28)]);
var inst_25215 = (state_25256[(2)]);
var state_25256__$1 = (function (){var statearr_25283 = state_25256;
(statearr_25283[(36)] = inst_25215);

return statearr_25283;
})();
if(cljs.core.truth_(inst_25094)){
var statearr_25284_25345 = state_25256__$1;
(statearr_25284_25345[(1)] = (30));

} else {
var statearr_25285_25346 = state_25256__$1;
(statearr_25285_25346[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (25))){
var inst_25206 = (state_25256[(2)]);
var state_25256__$1 = state_25256;
if(cljs.core.truth_(inst_25206)){
var statearr_25286_25347 = state_25256__$1;
(statearr_25286_25347[(1)] = (26));

} else {
var statearr_25287_25348 = state_25256__$1;
(statearr_25287_25348[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (34))){
var inst_25178 = (state_25256[(9)]);
var inst_25187 = (state_25256[(21)]);
var inst_25235 = cljs.core.conj.call(null,inst_25178,inst_25187);
var state_25256__$1 = state_25256;
var statearr_25288_25349 = state_25256__$1;
(statearr_25288_25349[(2)] = inst_25235);

(statearr_25288_25349[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (17))){
var inst_25122 = (state_25256[(37)]);
var inst_25126 = (state_25256[(2)]);
var inst_25127 = fluree.db.util.async.throw_err.call(null,inst_25126);
var inst_25114 = inst_25122;
var inst_25115 = inst_25127;
var state_25256__$1 = (function (){var statearr_25289 = state_25256;
(statearr_25289[(38)] = inst_25114);

(statearr_25289[(24)] = inst_25115);

return statearr_25289;
})();
var statearr_25290_25350 = state_25256__$1;
(statearr_25290_25350[(2)] = null);

(statearr_25290_25350[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (3))){
var inst_25254 = (state_25256[(2)]);
var state_25256__$1 = state_25256;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25256__$1,inst_25254);
} else {
if((state_val_25257 === (12))){
var inst_25114 = (state_25256[(38)]);
var inst_25121 = (state_25256[(39)]);
var inst_25120 = cljs.core.seq.call(null,inst_25114);
var inst_25121__$1 = cljs.core.first.call(null,inst_25120);
var inst_25122 = cljs.core.next.call(null,inst_25120);
var state_25256__$1 = (function (){var statearr_25291 = state_25256;
(statearr_25291[(39)] = inst_25121__$1);

(statearr_25291[(37)] = inst_25122);

return statearr_25291;
})();
if(cljs.core.truth_(inst_25121__$1)){
var statearr_25292_25351 = state_25256__$1;
(statearr_25292_25351[(1)] = (14));

} else {
var statearr_25293_25352 = state_25256__$1;
(statearr_25293_25352[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (2))){
var inst_25064 = (state_25256[(29)]);
var _ = (function (){var statearr_25294 = state_25256;
(statearr_25294[(4)] = cljs.core.cons.call(null,(5),(state_25256[(4)])));

return statearr_25294;
})();
var inst_25063 = cljs.core.first.call(null,flakes);
var inst_25064__$1 = fluree.db.flake.t.call(null,inst_25063);
var inst_25065 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25066 = (inst_25065 - (1));
var inst_25067 = cljs.core.not_EQ_.call(null,inst_25064__$1,inst_25066);
var state_25256__$1 = (function (){var statearr_25295 = state_25256;
(statearr_25295[(29)] = inst_25064__$1);

return statearr_25295;
})();
if(inst_25067){
var statearr_25296_25353 = state_25256__$1;
(statearr_25296_25353[(1)] = (6));

} else {
var statearr_25297_25354 = state_25256__$1;
(statearr_25297_25354[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (23))){
var inst_25093 = (state_25256[(11)]);
var state_25256__$1 = state_25256;
var statearr_25298_25355 = state_25256__$1;
(statearr_25298_25355[(2)] = inst_25093);

(statearr_25298_25355[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (35))){
var inst_25178 = (state_25256[(9)]);
var state_25256__$1 = state_25256;
var statearr_25299_25356 = state_25256__$1;
(statearr_25299_25356[(2)] = inst_25178);

(statearr_25299_25356[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (19))){
var inst_25251 = (state_25256[(2)]);
var _ = (function (){var statearr_25300 = state_25256;
(statearr_25300[(4)] = cljs.core.rest.call(null,(state_25256[(4)])));

return statearr_25300;
})();
var state_25256__$1 = state_25256;
var statearr_25301_25357 = state_25256__$1;
(statearr_25301_25357[(2)] = inst_25251);

(statearr_25301_25357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (11))){
var inst_25102 = (state_25256[(34)]);
var inst_25102__$1 = (state_25256[(2)]);
var inst_25110 = cljs.core.seq.call(null,inst_25102__$1);
var inst_25111 = cljs.core.first.call(null,inst_25110);
var inst_25112 = cljs.core.next.call(null,inst_25110);
var inst_25113 = db;
var inst_25114 = inst_25102__$1;
var inst_25115 = inst_25113;
var state_25256__$1 = (function (){var statearr_25303 = state_25256;
(statearr_25303[(38)] = inst_25114);

(statearr_25303[(40)] = inst_25112);

(statearr_25303[(24)] = inst_25115);

(statearr_25303[(41)] = inst_25111);

(statearr_25303[(34)] = inst_25102__$1);

return statearr_25303;
})();
var statearr_25304_25358 = state_25256__$1;
(statearr_25304_25358[(2)] = null);

(statearr_25304_25358[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (9))){
var inst_25080 = (state_25256[(33)]);
var inst_25096 = (state_25256[(35)]);
var inst_25098 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_25080,inst_25096);
var state_25256__$1 = state_25256;
var statearr_25305_25359 = state_25256__$1;
(statearr_25305_25359[(2)] = inst_25098);

(statearr_25305_25359[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (5))){
var _ = (function (){var statearr_25306 = state_25256;
(statearr_25306[(4)] = cljs.core.rest.call(null,(state_25256[(4)])));

return statearr_25306;
})();
var state_25256__$1 = state_25256;
var ex25302 = (state_25256__$1[(2)]);
var statearr_25307_25360 = state_25256__$1;
(statearr_25307_25360[(5)] = ex25302);


if((ex25302 instanceof Error)){
var statearr_25308_25361 = state_25256__$1;
(statearr_25308_25361[(1)] = (4));

(statearr_25308_25361[(5)] = null);

} else {
throw ex25302;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (14))){
var inst_25121 = (state_25256[(39)]);
var inst_25115 = (state_25256[(24)]);
var inst_25124 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_25115,inst_25121,opts);
var state_25256__$1 = state_25256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25256__$1,(17),inst_25124);
} else {
if((state_val_25257 === (26))){
var inst_25199 = (state_25256[(16)]);
var inst_25208 = fluree.db.query.schema.schema_map.call(null,inst_25199);
var state_25256__$1 = state_25256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25256__$1,(29),inst_25208);
} else {
if((state_val_25257 === (16))){
var inst_25131 = (state_25256[(2)]);
var state_25256__$1 = state_25256;
var statearr_25309_25362 = state_25256__$1;
(statearr_25309_25362[(2)] = inst_25131);

(statearr_25309_25362[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (38))){
var inst_25179 = (state_25256[(13)]);
var state_25256__$1 = state_25256;
var statearr_25310_25363 = state_25256__$1;
(statearr_25310_25363[(2)] = inst_25179);

(statearr_25310_25363[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (30))){
var inst_25199 = (state_25256[(16)]);
var inst_25217 = fluree.db.query.schema.setting_map.call(null,inst_25199);
var state_25256__$1 = state_25256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25256__$1,(33),inst_25217);
} else {
if((state_val_25257 === (10))){
var inst_25100 = cljs.core.PersistentVector.EMPTY;
var state_25256__$1 = state_25256;
var statearr_25311_25364 = state_25256__$1;
(statearr_25311_25364[(2)] = inst_25100);

(statearr_25311_25364[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (18))){
var inst_25175 = (state_25256[(23)]);
var inst_25187 = (state_25256[(21)]);
var inst_25186 = cljs.core.seq.call(null,inst_25175);
var inst_25187__$1 = cljs.core.first.call(null,inst_25186);
var inst_25188 = cljs.core.next.call(null,inst_25186);
var inst_25189 = cljs.core.not.call(null,inst_25187__$1);
var state_25256__$1 = (function (){var statearr_25312 = state_25256;
(statearr_25312[(19)] = inst_25188);

(statearr_25312[(21)] = inst_25187__$1);

return statearr_25312;
})();
if(inst_25189){
var statearr_25313_25365 = state_25256__$1;
(statearr_25313_25365[(1)] = (20));

} else {
var statearr_25314_25366 = state_25256__$1;
(statearr_25314_25366[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (37))){
var inst_25179 = (state_25256[(13)]);
var inst_25187 = (state_25256[(21)]);
var inst_25242 = cljs.core.conj.call(null,inst_25179,inst_25187);
var state_25256__$1 = state_25256;
var statearr_25315_25367 = state_25256__$1;
(statearr_25315_25367[(2)] = inst_25242);

(statearr_25315_25367[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25257 === (8))){
var inst_25087 = (state_25256[(26)]);
var inst_25064 = (state_25256[(29)]);
var inst_25083 = (state_25256[(31)]);
var inst_25079 = (state_25256[(32)]);
var inst_25093 = (state_25256[(11)]);
var inst_25080 = (state_25256[(33)]);
var inst_25079__$1 = (state_25256[(2)]);
var inst_25080__$1 = cljs.core.filter.call(null,fluree.db.graphdb.include_flake_QMARK_,flakes);
var inst_25081 = cljs.core.PersistentHashSet.EMPTY;
var inst_25082 = cljs.core.map.call(null,fluree.db.flake.p,inst_25080__$1);
var inst_25083__$1 = cljs.core.into.call(null,inst_25081,inst_25082);
var inst_25084 = cljs.core.PersistentHashMap.EMPTY;
var inst_25085 = (function (){var t = inst_25064;
var _ = inst_25079__$1;
var add_flakes = inst_25080__$1;
var add_preds = inst_25083__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_25086 = cljs.core.map.call(null,inst_25085,inst_25083__$1);
var inst_25087__$1 = cljs.core.into.call(null,inst_25084,inst_25086);
var inst_25088 = cljs.core.PersistentHashMap.EMPTY;
var inst_25089 = (function (){var t = inst_25064;
var _ = inst_25079__$1;
var add_flakes = inst_25080__$1;
var add_preds = inst_25083__$1;
var idx_QMARK__map = inst_25087__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_25090 = cljs.core.map.call(null,inst_25089,inst_25083__$1);
var inst_25091 = cljs.core.into.call(null,inst_25088,inst_25090);
var inst_25092 = fluree.db.flake.size_bytes.call(null,inst_25080__$1);
var inst_25093__$1 = fluree.db.util.schema.system_change_QMARK_.call(null,inst_25080__$1);
var inst_25094 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_25080__$1);
var inst_25095 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25096 = cljs.core.get.call(null,inst_25095,(0));
var state_25256__$1 = (function (){var statearr_25316 = state_25256;
(statearr_25316[(7)] = inst_25092);

(statearr_25316[(25)] = inst_25091);

(statearr_25316[(26)] = inst_25087__$1);

(statearr_25316[(28)] = inst_25094);

(statearr_25316[(31)] = inst_25083__$1);

(statearr_25316[(32)] = inst_25079__$1);

(statearr_25316[(11)] = inst_25093__$1);

(statearr_25316[(33)] = inst_25080__$1);

(statearr_25316[(35)] = inst_25096);

return statearr_25316;
})();
if(cljs.core.truth_(inst_25093__$1)){
var statearr_25317_25368 = state_25256__$1;
(statearr_25317_25368[(1)] = (9));

} else {
var statearr_25318_25369 = state_25256__$1;
(statearr_25318_25369[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_25319 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25319[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_25319[(1)] = (1));

return statearr_25319;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_25256){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25256);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25320){var ex__2749__auto__ = e25320;
var statearr_25321_25370 = state_25256;
(statearr_25321_25370[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25256[(4)]))){
var statearr_25322_25371 = state_25256;
(statearr_25322_25371[(1)] = cljs.core.first.call(null,(state_25256[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25372 = state_25256;
state_25256 = G__25372;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_25256){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_25256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25323 = f__2769__auto__.call(null);
(statearr_25323[(6)] = c__2768__auto__);

return statearr_25323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__25374 = arguments.length;
switch (G__25374) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___25521 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25470){
var state_val_25471 = (state_25470[(1)]);
if((state_val_25471 === (7))){
var state_25470__$1 = state_25470;
var statearr_25472_25522 = state_25470__$1;
(statearr_25472_25522[(2)] = null);

(statearr_25472_25522[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (20))){
var inst_25418 = (state_25470[(7)]);
var inst_25419 = (state_25470[(8)]);
var inst_25420 = (state_25470[(9)]);
var inst_25439 = (inst_25418 + (1));
var inst_25440 = cljs.core.assoc.call(null,inst_25420,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25439);
var inst_25441 = fluree.db.graphdb.with_t.call(null,inst_25440,inst_25419,opts);
var state_25470__$1 = state_25470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25470__$1,(23),inst_25441);
} else {
if((state_val_25471 === (1))){
var state_25470__$1 = state_25470;
var statearr_25473_25523 = state_25470__$1;
(statearr_25473_25523[(2)] = null);

(statearr_25473_25523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (24))){
var inst_25444 = (state_25470[(10)]);
var inst_25447 = cljs.core.assoc.call(null,inst_25444,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_25470__$1 = state_25470;
var statearr_25474_25524 = state_25470__$1;
(statearr_25474_25524[(2)] = inst_25447);

(statearr_25474_25524[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (4))){
var inst_25375 = (state_25470[(2)]);
var inst_25376 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_25375);
var state_25470__$1 = state_25470;
var statearr_25475_25525 = state_25470__$1;
(statearr_25475_25525[(2)] = inst_25376);

(statearr_25475_25525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (15))){
var inst_25426 = (state_25470[(11)]);
var state_25470__$1 = state_25470;
var statearr_25476_25526 = state_25470__$1;
(statearr_25476_25526[(2)] = inst_25426);

(statearr_25476_25526[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (21))){
var state_25470__$1 = state_25470;
var statearr_25477_25527 = state_25470__$1;
(statearr_25477_25527[(2)] = null);

(statearr_25477_25527[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (13))){
var inst_25462 = (state_25470[(2)]);
var inst_25463 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_25462);
var state_25470__$1 = state_25470;
var statearr_25478_25528 = state_25470__$1;
(statearr_25478_25528[(2)] = inst_25463);

(statearr_25478_25528[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (22))){
var inst_25458 = (state_25470[(2)]);
var state_25470__$1 = state_25470;
var statearr_25479_25529 = state_25470__$1;
(statearr_25479_25529[(2)] = inst_25458);

(statearr_25479_25529[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (6))){
var inst_25386 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25387 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_25388 = ["Invalid 'with' called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25386)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25387)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_25389 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25390 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25391 = cljs.core.PersistentHashMap.fromArrays(inst_25389,inst_25390);
var inst_25392 = cljs.core.ex_info.call(null,inst_25388,inst_25391);
var inst_25393 = (function(){throw inst_25392})();
var state_25470__$1 = state_25470;
var statearr_25482_25530 = state_25470__$1;
(statearr_25482_25530[(2)] = inst_25393);

(statearr_25482_25530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (25))){
var inst_25427 = (state_25470[(12)]);
var inst_25444 = (state_25470[(10)]);
var inst_25426 = (state_25470[(11)]);
var inst_25449 = fluree.db.flake.t.call(null,inst_25426);
var inst_25450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25451 = [inst_25426];
var inst_25452 = (new cljs.core.PersistentVector(null,1,(5),inst_25450,inst_25451,null));
var inst_25417 = inst_25427;
var inst_25418 = inst_25449;
var inst_25419 = inst_25452;
var inst_25420 = inst_25444;
var state_25470__$1 = (function (){var statearr_25483 = state_25470;
(statearr_25483[(7)] = inst_25418);

(statearr_25483[(13)] = inst_25417);

(statearr_25483[(8)] = inst_25419);

(statearr_25483[(9)] = inst_25420);

return statearr_25483;
})();
var statearr_25484_25531 = state_25470__$1;
(statearr_25484_25531[(2)] = null);

(statearr_25484_25531[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (17))){
var inst_25418 = (state_25470[(7)]);
var inst_25427 = (state_25470[(12)]);
var inst_25419 = (state_25470[(8)]);
var inst_25420 = (state_25470[(9)]);
var inst_25426 = (state_25470[(11)]);
var inst_25435 = cljs.core.conj.call(null,inst_25419,inst_25426);
var tmp25480 = inst_25418;
var tmp25481 = inst_25420;
var inst_25417 = inst_25427;
var inst_25418__$1 = tmp25480;
var inst_25419__$1 = inst_25435;
var inst_25420__$1 = tmp25481;
var state_25470__$1 = (function (){var statearr_25485 = state_25470;
(statearr_25485[(7)] = inst_25418__$1);

(statearr_25485[(13)] = inst_25417);

(statearr_25485[(8)] = inst_25419__$1);

(statearr_25485[(9)] = inst_25420__$1);

return statearr_25485;
})();
var statearr_25486_25532 = state_25470__$1;
(statearr_25486_25532[(2)] = null);

(statearr_25486_25532[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (3))){
var inst_25468 = (state_25470[(2)]);
var state_25470__$1 = state_25470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25470__$1,inst_25468);
} else {
if((state_val_25471 === (12))){
var inst_25417 = (state_25470[(13)]);
var inst_25426 = (state_25470[(11)]);
var inst_25425 = cljs.core.seq.call(null,inst_25417);
var inst_25426__$1 = cljs.core.first.call(null,inst_25425);
var inst_25427 = cljs.core.next.call(null,inst_25425);
var state_25470__$1 = (function (){var statearr_25487 = state_25470;
(statearr_25487[(12)] = inst_25427);

(statearr_25487[(11)] = inst_25426__$1);

return statearr_25487;
})();
if(cljs.core.truth_(inst_25426__$1)){
var statearr_25488_25533 = state_25470__$1;
(statearr_25488_25533[(1)] = (14));

} else {
var statearr_25489_25534 = state_25470__$1;
(statearr_25489_25534[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (2))){
var _ = (function (){var statearr_25490 = state_25470;
(statearr_25490[(4)] = cljs.core.cons.call(null,(5),(state_25470[(4)])));

return statearr_25490;
})();
var inst_25382 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_25383 = (inst_25382 + (1));
var inst_25384 = cljs.core.not_EQ_.call(null,block,inst_25383);
var state_25470__$1 = state_25470;
if(inst_25384){
var statearr_25491_25535 = state_25470__$1;
(statearr_25491_25535[(1)] = (6));

} else {
var statearr_25492_25536 = state_25470__$1;
(statearr_25492_25536[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (23))){
var inst_25426 = (state_25470[(11)]);
var inst_25443 = (state_25470[(2)]);
var inst_25444 = fluree.db.util.async.throw_err.call(null,inst_25443);
var inst_25445 = (inst_25426 == null);
var state_25470__$1 = (function (){var statearr_25493 = state_25470;
(statearr_25493[(10)] = inst_25444);

return statearr_25493;
})();
if(cljs.core.truth_(inst_25445)){
var statearr_25494_25537 = state_25470__$1;
(statearr_25494_25537[(1)] = (24));

} else {
var statearr_25495_25538 = state_25470__$1;
(statearr_25495_25538[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (19))){
var inst_25460 = (state_25470[(2)]);
var state_25470__$1 = state_25470;
var statearr_25496_25539 = state_25470__$1;
(statearr_25496_25539[(2)] = inst_25460);

(statearr_25496_25539[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (11))){
var inst_25465 = (state_25470[(2)]);
var _ = (function (){var statearr_25498 = state_25470;
(statearr_25498[(4)] = cljs.core.rest.call(null,(state_25470[(4)])));

return statearr_25498;
})();
var state_25470__$1 = state_25470;
var statearr_25499_25540 = state_25470__$1;
(statearr_25499_25540[(2)] = inst_25465);

(statearr_25499_25540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (9))){
var inst_25399 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_25400 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_25399);
var state_25470__$1 = state_25470;
var statearr_25500_25541 = state_25470__$1;
(statearr_25500_25541[(2)] = inst_25400);

(statearr_25500_25541[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (5))){
var _ = (function (){var statearr_25501 = state_25470;
(statearr_25501[(4)] = cljs.core.rest.call(null,(state_25470[(4)])));

return statearr_25501;
})();
var state_25470__$1 = state_25470;
var ex25497 = (state_25470__$1[(2)]);
var statearr_25502_25542 = state_25470__$1;
(statearr_25502_25542[(5)] = ex25497);


var statearr_25503_25543 = state_25470__$1;
(statearr_25503_25543[(1)] = (4));

(statearr_25503_25543[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (14))){
var inst_25418 = (state_25470[(7)]);
var inst_25426 = (state_25470[(11)]);
var inst_25429 = fluree.db.flake.t.call(null,inst_25426);
var inst_25430 = cljs.core._EQ_.call(null,inst_25418,inst_25429);
var state_25470__$1 = state_25470;
var statearr_25504_25544 = state_25470__$1;
(statearr_25504_25544[(2)] = inst_25430);

(statearr_25504_25544[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (26))){
var inst_25455 = (state_25470[(2)]);
var state_25470__$1 = state_25470;
var statearr_25505_25545 = state_25470__$1;
(statearr_25505_25545[(2)] = inst_25455);

(statearr_25505_25545[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (16))){
var inst_25433 = (state_25470[(2)]);
var state_25470__$1 = state_25470;
if(cljs.core.truth_(inst_25433)){
var statearr_25506_25546 = state_25470__$1;
(statearr_25506_25546[(1)] = (17));

} else {
var statearr_25507_25547 = state_25470__$1;
(statearr_25507_25547[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (10))){
var inst_25402 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_25410 = cljs.core.seq.call(null,inst_25402);
var inst_25411 = cljs.core.first.call(null,inst_25410);
var inst_25412 = cljs.core.next.call(null,inst_25410);
var inst_25413 = cljs.core.first.call(null,inst_25402);
var inst_25414 = fluree.db.flake.t.call(null,inst_25413);
var inst_25415 = cljs.core.PersistentVector.EMPTY;
var inst_25416 = db;
var inst_25417 = inst_25402;
var inst_25418 = inst_25414;
var inst_25419 = inst_25415;
var inst_25420 = inst_25416;
var state_25470__$1 = (function (){var statearr_25508 = state_25470;
(statearr_25508[(14)] = inst_25411);

(statearr_25508[(7)] = inst_25418);

(statearr_25508[(13)] = inst_25417);

(statearr_25508[(8)] = inst_25419);

(statearr_25508[(9)] = inst_25420);

(statearr_25508[(15)] = inst_25412);

return statearr_25508;
})();
var statearr_25509_25548 = state_25470__$1;
(statearr_25509_25548[(2)] = null);

(statearr_25509_25548[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (18))){
var state_25470__$1 = state_25470;
var statearr_25510_25549 = state_25470__$1;
(statearr_25510_25549[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (8))){
var inst_25396 = (state_25470[(2)]);
var inst_25397 = cljs.core.empty_QMARK_.call(null,flakes);
var state_25470__$1 = (function (){var statearr_25512 = state_25470;
(statearr_25512[(16)] = inst_25396);

return statearr_25512;
})();
if(inst_25397){
var statearr_25513_25550 = state_25470__$1;
(statearr_25513_25550[(1)] = (9));

} else {
var statearr_25514_25551 = state_25470__$1;
(statearr_25514_25551[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_25515 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25515[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_25515[(1)] = (1));

return statearr_25515;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_25470){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25516){var ex__2749__auto__ = e25516;
var statearr_25517_25552 = state_25470;
(statearr_25517_25552[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25470[(4)]))){
var statearr_25518_25553 = state_25470;
(statearr_25518_25553[(1)] = cljs.core.first.call(null,(state_25470[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25554 = state_25470;
state_25470 = G__25554;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_25470){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_25470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25519 = f__2769__auto__.call(null);
(statearr_25519[(6)] = c__2768__auto___25521);

return statearr_25519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25606){
var state_val_25607 = (state_25606[(1)]);
if((state_val_25607 === (7))){
var state_25606__$1 = state_25606;
var statearr_25608_25635 = state_25606__$1;
(statearr_25608_25635[(2)] = tt_id);

(statearr_25608_25635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25607 === (1))){
var state_25606__$1 = state_25606;
var statearr_25609_25636 = state_25606__$1;
(statearr_25609_25636[(2)] = null);

(statearr_25609_25636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25607 === (4))){
var inst_25555 = (state_25606[(2)]);
var state_25606__$1 = state_25606;
var statearr_25610_25637 = state_25606__$1;
(statearr_25610_25637[(2)] = inst_25555);

(statearr_25610_25637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25607 === (13))){
var inst_25599 = (state_25606[(2)]);
var state_25606__$1 = state_25606;
var statearr_25611_25638 = state_25606__$1;
(statearr_25611_25638[(2)] = inst_25599);

(statearr_25611_25638[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25607 === (6))){
var inst_25563 = cljs.core.random_uuid.call(null);
var state_25606__$1 = state_25606;
var statearr_25612_25639 = state_25606__$1;
(statearr_25612_25639[(2)] = inst_25563);

(statearr_25612_25639[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25607 === (3))){
var inst_25604 = (state_25606[(2)]);
var state_25606__$1 = state_25606;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25606__$1,inst_25604);
} else {
if((state_val_25607 === (12))){
var inst_25582 = (state_25606[(7)]);
var state_25606__$1 = state_25606;
var statearr_25613_25640 = state_25606__$1;
(statearr_25613_25640[(2)] = inst_25582);

(statearr_25613_25640[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25607 === (2))){
var _ = (function (){var statearr_25614 = state_25606;
(statearr_25614[(4)] = cljs.core.cons.call(null,(5),(state_25606[(4)])));

return statearr_25614;
})();
var inst_25561 = (tt_id == null);
var state_25606__$1 = state_25606;
if(cljs.core.truth_(inst_25561)){
var statearr_25615_25641 = state_25606__$1;
(statearr_25615_25641[(1)] = (6));

} else {
var statearr_25616_25642 = state_25606__$1;
(statearr_25616_25642[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25607 === (11))){
var inst_25589 = (state_25606[(8)]);
var inst_25582 = (state_25606[(7)]);
var inst_25592 = fluree.db.graphdb.with_t.call(null,inst_25582,inst_25589);
var state_25606__$1 = state_25606;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25606__$1,(14),inst_25592);
} else {
if((state_val_25607 === (9))){
var inst_25583 = (state_25606[(9)]);
var inst_25589 = (state_25606[(8)]);
var inst_25588 = cljs.core.seq.call(null,inst_25583);
var inst_25589__$1 = cljs.core.first.call(null,inst_25588);
var inst_25590 = cljs.core.next.call(null,inst_25588);
var state_25606__$1 = (function (){var statearr_25618 = state_25606;
(statearr_25618[(10)] = inst_25590);

(statearr_25618[(8)] = inst_25589__$1);

return statearr_25618;
})();
if(cljs.core.truth_(inst_25589__$1)){
var statearr_25619_25643 = state_25606__$1;
(statearr_25619_25643[(1)] = (11));

} else {
var statearr_25620_25644 = state_25606__$1;
(statearr_25620_25644[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25607 === (5))){
var _ = (function (){var statearr_25621 = state_25606;
(statearr_25621[(4)] = cljs.core.rest.call(null,(state_25606[(4)])));

return statearr_25621;
})();
var state_25606__$1 = state_25606;
var ex25617 = (state_25606__$1[(2)]);
var statearr_25622_25645 = state_25606__$1;
(statearr_25622_25645[(5)] = ex25617);


if((ex25617 instanceof Error)){
var statearr_25623_25646 = state_25606__$1;
(statearr_25623_25646[(1)] = (4));

(statearr_25623_25646[(5)] = null);

} else {
throw ex25617;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25607 === (14))){
var inst_25590 = (state_25606[(10)]);
var inst_25594 = (state_25606[(2)]);
var inst_25595 = fluree.db.util.async.throw_err.call(null,inst_25594);
var inst_25582 = inst_25595;
var inst_25583 = inst_25590;
var state_25606__$1 = (function (){var statearr_25624 = state_25606;
(statearr_25624[(9)] = inst_25583);

(statearr_25624[(7)] = inst_25582);

return statearr_25624;
})();
var statearr_25625_25647 = state_25606__$1;
(statearr_25625_25647[(2)] = null);

(statearr_25625_25647[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25607 === (10))){
var inst_25601 = (state_25606[(2)]);
var _ = (function (){var statearr_25626 = state_25606;
(statearr_25626[(4)] = cljs.core.rest.call(null,(state_25606[(4)])));

return statearr_25626;
})();
var state_25606__$1 = state_25606;
var statearr_25627_25648 = state_25606__$1;
(statearr_25627_25648[(2)] = inst_25601);

(statearr_25627_25648[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25607 === (8))){
var inst_25566 = (state_25606[(2)]);
var inst_25567 = (function (){var tt_id__$1 = inst_25566;
return (function (db_STAR_,idx){
return cljs.core.update.call(null,db_STAR_,idx,cljs.core.assoc,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id__$1);
});
})();
var inst_25568 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_25566);
var inst_25569 = cljs.core.reduce.call(null,inst_25567,inst_25568,fluree.db.index.types);
var inst_25570 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),fluree.db.flake.cmp_tx,flakes);
var inst_25571 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25570);
var inst_25579 = cljs.core.seq.call(null,inst_25571);
var inst_25580 = cljs.core.first.call(null,inst_25579);
var inst_25581 = cljs.core.next.call(null,inst_25579);
var inst_25582 = inst_25569;
var inst_25583 = inst_25571;
var state_25606__$1 = (function (){var statearr_25628 = state_25606;
(statearr_25628[(11)] = inst_25581);

(statearr_25628[(12)] = inst_25580);

(statearr_25628[(9)] = inst_25583);

(statearr_25628[(7)] = inst_25582);

return statearr_25628;
})();
var statearr_25629_25649 = state_25606__$1;
(statearr_25629_25649[(2)] = null);

(statearr_25629_25649[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0 = (function (){
var statearr_25630 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25630[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__);

(statearr_25630[(1)] = (1));

return statearr_25630;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1 = (function (state_25606){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25606);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25631){var ex__2749__auto__ = e25631;
var statearr_25632_25650 = state_25606;
(statearr_25632_25650[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25606[(4)]))){
var statearr_25633_25651 = state_25606;
(statearr_25633_25651[(1)] = cljs.core.first.call(null,(state_25606[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25652 = state_25606;
state_25606 = G__25652;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__ = function(state_25606){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1.call(this,state_25606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25634 = f__2769__auto__.call(null);
(statearr_25634[(6)] = c__2768__auto__);

return statearr_25634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2768__auto___25839 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25770){
var state_val_25771 = (state_25770[(1)]);
if((state_val_25771 === (7))){
var inst_25680 = (state_25770[(7)]);
var inst_25680__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_25770__$1 = (function (){var statearr_25772 = state_25770;
(statearr_25772[(7)] = inst_25680__$1);

return statearr_25772;
})();
if(inst_25680__$1){
var statearr_25773_25840 = state_25770__$1;
(statearr_25773_25840[(1)] = (13));

} else {
var statearr_25774_25841 = state_25770__$1;
(statearr_25774_25841[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (20))){
var state_25770__$1 = state_25770;
var statearr_25775_25842 = state_25770__$1;
(statearr_25775_25842[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (27))){
var inst_25716 = (state_25770[(8)]);
var inst_25720 = fluree.db.flake.s.call(null,inst_25716);
var state_25770__$1 = state_25770;
var statearr_25777_25843 = state_25770__$1;
(statearr_25777_25843[(2)] = inst_25720);

(statearr_25777_25843[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (1))){
var state_25770__$1 = state_25770;
var statearr_25778_25844 = state_25770__$1;
(statearr_25778_25844[(2)] = null);

(statearr_25778_25844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (24))){
var inst_25710 = (state_25770[(9)]);
var inst_25714 = cljs.core.first.call(null,inst_25710);
var state_25770__$1 = state_25770;
var statearr_25779_25845 = state_25770__$1;
(statearr_25779_25845[(2)] = inst_25714);

(statearr_25779_25845[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (39))){
var state_25770__$1 = state_25770;
var statearr_25780_25846 = state_25770__$1;
(statearr_25780_25846[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (4))){
var inst_25653 = (state_25770[(2)]);
var inst_25654 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_25655 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25656 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_25657 = cljs.core.PersistentHashMap.fromArrays(inst_25655,inst_25656);
var inst_25658 = cljs.core.ex_info.call(null,inst_25654,inst_25657,inst_25653);
var inst_25659 = cljs.core.async.put_BANG_.call(null,return_chan,inst_25658);
var state_25770__$1 = state_25770;
var statearr_25782_25847 = state_25770__$1;
(statearr_25782_25847[(2)] = inst_25659);

(statearr_25782_25847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (15))){
var inst_25687 = (state_25770[(2)]);
var state_25770__$1 = state_25770;
if(cljs.core.truth_(inst_25687)){
var statearr_25783_25848 = state_25770__$1;
(statearr_25783_25848[(1)] = (16));

} else {
var statearr_25784_25849 = state_25770__$1;
(statearr_25784_25849[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (21))){
var inst_25736 = (state_25770[(2)]);
var state_25770__$1 = state_25770;
var statearr_25785_25850 = state_25770__$1;
(statearr_25785_25850[(2)] = inst_25736);

(statearr_25785_25850[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (31))){
var inst_25734 = (state_25770[(2)]);
var state_25770__$1 = state_25770;
var statearr_25786_25851 = state_25770__$1;
(statearr_25786_25851[(2)] = inst_25734);

(statearr_25786_25851[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (32))){
var inst_25740 = (state_25770[(10)]);
var inst_25742 = cljs.core.async.put_BANG_.call(null,return_chan,inst_25740);
var state_25770__$1 = state_25770;
var statearr_25787_25852 = state_25770__$1;
(statearr_25787_25852[(2)] = inst_25742);

(statearr_25787_25852[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (40))){
var inst_25763 = (state_25770[(2)]);
var state_25770__$1 = state_25770;
var statearr_25788_25853 = state_25770__$1;
(statearr_25788_25853[(2)] = inst_25763);

(statearr_25788_25853[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (33))){
var inst_25744 = (state_25770[(11)]);
var inst_25740 = (state_25770[(10)]);
var inst_25744__$1 = (inst_25740 == null);
var state_25770__$1 = (function (){var statearr_25789 = state_25770;
(statearr_25789[(11)] = inst_25744__$1);

return statearr_25789;
})();
if(cljs.core.truth_(inst_25744__$1)){
var statearr_25790_25854 = state_25770__$1;
(statearr_25790_25854[(1)] = (35));

} else {
var statearr_25791_25855 = state_25770__$1;
(statearr_25791_25855[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (13))){
var inst_25682 = cljs.core.first.call(null,ident);
var inst_25683 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_25682);
var inst_25684 = (inst_25683 == null);
var state_25770__$1 = state_25770;
var statearr_25792_25856 = state_25770__$1;
(statearr_25792_25856[(2)] = inst_25684);

(statearr_25792_25856[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (22))){
var inst_25710 = (state_25770[(9)]);
var inst_25709 = (state_25770[(2)]);
var inst_25710__$1 = fluree.db.util.async.throw_err.call(null,inst_25709);
var inst_25711 = (inst_25710__$1 == null);
var state_25770__$1 = (function (){var statearr_25793 = state_25770;
(statearr_25793[(9)] = inst_25710__$1);

return statearr_25793;
})();
if(cljs.core.truth_(inst_25711)){
var statearr_25794_25857 = state_25770__$1;
(statearr_25794_25857[(1)] = (23));

} else {
var statearr_25795_25858 = state_25770__$1;
(statearr_25795_25858[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (36))){
var inst_25744 = (state_25770[(11)]);
var state_25770__$1 = state_25770;
var statearr_25796_25859 = state_25770__$1;
(statearr_25796_25859[(2)] = inst_25744);

(statearr_25796_25859[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (41))){
var inst_25758 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_25770__$1 = state_25770;
var statearr_25797_25860 = state_25770__$1;
(statearr_25797_25860[(2)] = inst_25758);

(statearr_25797_25860[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (43))){
var inst_25761 = (state_25770[(2)]);
var state_25770__$1 = state_25770;
var statearr_25798_25861 = state_25770__$1;
(statearr_25798_25861[(2)] = inst_25761);

(statearr_25798_25861[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (29))){
var inst_25725 = cljs.core.pr_str.call(null,ident);
var inst_25726 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_25725].join('');
var inst_25727 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25728 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_25729 = cljs.core.PersistentHashMap.fromArrays(inst_25727,inst_25728);
var inst_25730 = cljs.core.ex_info.call(null,inst_25726,inst_25729);
var inst_25731 = (function(){throw inst_25730})();
var state_25770__$1 = state_25770;
var statearr_25799_25862 = state_25770__$1;
(statearr_25799_25862[(2)] = inst_25731);

(statearr_25799_25862[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (6))){
var inst_25667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25668 = [ident];
var inst_25669 = (new cljs.core.PersistentVector(null,1,(5),inst_25667,inst_25668,null));
var inst_25670 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_25669);
var state_25770__$1 = state_25770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25770__$1,(9),inst_25670);
} else {
if((state_val_25771 === (28))){
var inst_25722 = (state_25770[(2)]);
var state_25770__$1 = state_25770;
var statearr_25800_25863 = state_25770__$1;
(statearr_25800_25863[(2)] = inst_25722);

(statearr_25800_25863[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (25))){
var inst_25716 = (state_25770[(8)]);
var inst_25716__$1 = (state_25770[(2)]);
var inst_25717 = (inst_25716__$1 == null);
var state_25770__$1 = (function (){var statearr_25801 = state_25770;
(statearr_25801[(8)] = inst_25716__$1);

return statearr_25801;
})();
if(cljs.core.truth_(inst_25717)){
var statearr_25802_25864 = state_25770__$1;
(statearr_25802_25864[(1)] = (26));

} else {
var statearr_25803_25865 = state_25770__$1;
(statearr_25803_25865[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (34))){
var inst_25765 = (state_25770[(2)]);
var _ = (function (){var statearr_25804 = state_25770;
(statearr_25804[(4)] = cljs.core.rest.call(null,(state_25770[(4)])));

return statearr_25804;
})();
var state_25770__$1 = state_25770;
var statearr_25805_25866 = state_25770__$1;
(statearr_25805_25866[(2)] = inst_25765);

(statearr_25805_25866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (17))){
var inst_25698 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_25770__$1 = state_25770;
if(inst_25698){
var statearr_25806_25867 = state_25770__$1;
(statearr_25806_25867[(1)] = (19));

} else {
var statearr_25807_25868 = state_25770__$1;
(statearr_25807_25868[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (3))){
var inst_25768 = (state_25770[(2)]);
var state_25770__$1 = state_25770;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25770__$1,inst_25768);
} else {
if((state_val_25771 === (12))){
var inst_25678 = (state_25770[(2)]);
var state_25770__$1 = state_25770;
var statearr_25808_25869 = state_25770__$1;
(statearr_25808_25869[(2)] = inst_25678);

(statearr_25808_25869[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (2))){
var _ = (function (){var statearr_25809 = state_25770;
(statearr_25809[(4)] = cljs.core.cons.call(null,(5),(state_25770[(4)])));

return statearr_25809;
})();
var inst_25665 = typeof ident === 'number';
var state_25770__$1 = state_25770;
if(cljs.core.truth_(inst_25665)){
var statearr_25810_25870 = state_25770__$1;
(statearr_25810_25870[(1)] = (6));

} else {
var statearr_25811_25871 = state_25770__$1;
(statearr_25811_25871[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (23))){
var state_25770__$1 = state_25770;
var statearr_25812_25872 = state_25770__$1;
(statearr_25812_25872[(2)] = null);

(statearr_25812_25872[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (35))){
var state_25770__$1 = state_25770;
var statearr_25813_25873 = state_25770__$1;
(statearr_25813_25873[(2)] = strict_QMARK_);

(statearr_25813_25873[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (19))){
var inst_25701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25702 = cljs.core.first.call(null,ident);
var inst_25703 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_25702);
var inst_25704 = cljs.core.second.call(null,ident);
var inst_25705 = [inst_25703,inst_25704];
var inst_25706 = (new cljs.core.PersistentVector(null,2,(5),inst_25701,inst_25705,null));
var inst_25707 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_25706);
var state_25770__$1 = state_25770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25770__$1,(22),inst_25707);
} else {
if((state_val_25771 === (11))){
var state_25770__$1 = state_25770;
var statearr_25815_25874 = state_25770__$1;
(statearr_25815_25874[(2)] = null);

(statearr_25815_25874[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (9))){
var inst_25672 = (state_25770[(2)]);
var inst_25673 = fluree.db.util.async.throw_err.call(null,inst_25672);
var inst_25674 = cljs.core.not_empty.call(null,inst_25673);
var state_25770__$1 = state_25770;
if(cljs.core.truth_(inst_25674)){
var statearr_25816_25875 = state_25770__$1;
(statearr_25816_25875[(1)] = (10));

} else {
var statearr_25817_25876 = state_25770__$1;
(statearr_25817_25876[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (5))){
var _ = (function (){var statearr_25818 = state_25770;
(statearr_25818[(4)] = cljs.core.rest.call(null,(state_25770[(4)])));

return statearr_25818;
})();
var state_25770__$1 = state_25770;
var ex25814 = (state_25770__$1[(2)]);
var statearr_25819_25877 = state_25770__$1;
(statearr_25819_25877[(5)] = ex25814);


var statearr_25820_25878 = state_25770__$1;
(statearr_25820_25878[(1)] = (4));

(statearr_25820_25878[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (14))){
var inst_25680 = (state_25770[(7)]);
var state_25770__$1 = state_25770;
var statearr_25821_25879 = state_25770__$1;
(statearr_25821_25879[(2)] = inst_25680);

(statearr_25821_25879[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (26))){
var state_25770__$1 = state_25770;
var statearr_25822_25880 = state_25770__$1;
(statearr_25822_25880[(2)] = null);

(statearr_25822_25880[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (16))){
var inst_25689 = cljs.core.first.call(null,ident);
var inst_25690 = cljs.core.pr_str.call(null,inst_25689);
var inst_25691 = ["Subject ID lookup failed. The predicate ",inst_25690," does not exist."].join('');
var inst_25692 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25693 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_25694 = cljs.core.PersistentHashMap.fromArrays(inst_25692,inst_25693);
var inst_25695 = cljs.core.ex_info.call(null,inst_25691,inst_25694);
var inst_25696 = (function(){throw inst_25695})();
var state_25770__$1 = state_25770;
var statearr_25823_25881 = state_25770__$1;
(statearr_25823_25881[(2)] = inst_25696);

(statearr_25823_25881[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (38))){
var inst_25750 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_25751 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25752 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_25753 = cljs.core.PersistentHashMap.fromArrays(inst_25751,inst_25752);
var inst_25754 = cljs.core.ex_info.call(null,inst_25750,inst_25753);
var inst_25755 = cljs.core.async.put_BANG_.call(null,return_chan,inst_25754);
var state_25770__$1 = state_25770;
var statearr_25824_25882 = state_25770__$1;
(statearr_25824_25882[(2)] = inst_25755);

(statearr_25824_25882[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (30))){
var state_25770__$1 = state_25770;
var statearr_25825_25883 = state_25770__$1;
(statearr_25825_25883[(2)] = null);

(statearr_25825_25883[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (10))){
var state_25770__$1 = state_25770;
var statearr_25826_25884 = state_25770__$1;
(statearr_25826_25884[(2)] = ident);

(statearr_25826_25884[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (18))){
var inst_25738 = (state_25770[(2)]);
var state_25770__$1 = state_25770;
var statearr_25827_25885 = state_25770__$1;
(statearr_25827_25885[(2)] = inst_25738);

(statearr_25827_25885[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (42))){
var state_25770__$1 = state_25770;
var statearr_25828_25886 = state_25770__$1;
(statearr_25828_25886[(2)] = null);

(statearr_25828_25886[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (37))){
var inst_25748 = (state_25770[(2)]);
var state_25770__$1 = state_25770;
if(cljs.core.truth_(inst_25748)){
var statearr_25829_25887 = state_25770__$1;
(statearr_25829_25887[(1)] = (38));

} else {
var statearr_25830_25888 = state_25770__$1;
(statearr_25830_25888[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25771 === (8))){
var inst_25740 = (state_25770[(10)]);
var inst_25740__$1 = (state_25770[(2)]);
var state_25770__$1 = (function (){var statearr_25831 = state_25770;
(statearr_25831[(10)] = inst_25740__$1);

return statearr_25831;
})();
if(cljs.core.truth_(inst_25740__$1)){
var statearr_25832_25889 = state_25770__$1;
(statearr_25832_25889[(1)] = (32));

} else {
var statearr_25833_25890 = state_25770__$1;
(statearr_25833_25890[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2746__auto____0 = (function (){
var statearr_25834 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25834[(0)] = fluree$db$graphdb$subid_$_state_machine__2746__auto__);

(statearr_25834[(1)] = (1));

return statearr_25834;
});
var fluree$db$graphdb$subid_$_state_machine__2746__auto____1 = (function (state_25770){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25770);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25835){var ex__2749__auto__ = e25835;
var statearr_25836_25891 = state_25770;
(statearr_25836_25891[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25770[(4)]))){
var statearr_25837_25892 = state_25770;
(statearr_25837_25892[(1)] = cljs.core.first.call(null,(state_25770[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25893 = state_25770;
state_25770 = G__25893;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2746__auto__ = function(state_25770){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2746__auto____1.call(this,state_25770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2746__auto____0;
fluree$db$graphdb$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2746__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25838 = f__2769__auto__.call(null);
(statearr_25838[(6)] = c__2768__auto___25839);

return statearr_25838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__25894){
var map__25895 = p__25894;
var map__25895__$1 = cljs.core.__destructure_map.call(null,map__25895);
var current_db_fn = cljs.core.get.call(null,map__25895__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.call(null,map__25895__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25911){
var state_val_25912 = (state_25911[(1)]);
if((state_val_25912 === (1))){
var state_25911__$1 = state_25911;
var statearr_25913_25927 = state_25911__$1;
(statearr_25913_25927[(2)] = null);

(statearr_25913_25927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25912 === (2))){
var _ = (function (){var statearr_25914 = state_25911;
(statearr_25914[(4)] = cljs.core.cons.call(null,(5),(state_25911[(4)])));

return statearr_25914;
})();
var inst_25902 = current_db_fn.call(null);
var state_25911__$1 = state_25911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25911__$1,(6),inst_25902);
} else {
if((state_val_25912 === (3))){
var inst_25909 = (state_25911[(2)]);
var state_25911__$1 = state_25911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25911__$1,inst_25909);
} else {
if((state_val_25912 === (4))){
var inst_25896 = (state_25911[(2)]);
var state_25911__$1 = state_25911;
var statearr_25916_25928 = state_25911__$1;
(statearr_25916_25928[(2)] = inst_25896);

(statearr_25916_25928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25912 === (5))){
var _ = (function (){var statearr_25917 = state_25911;
(statearr_25917[(4)] = cljs.core.rest.call(null,(state_25911[(4)])));

return statearr_25917;
})();
var state_25911__$1 = state_25911;
var ex25915 = (state_25911__$1[(2)]);
var statearr_25918_25929 = state_25911__$1;
(statearr_25918_25929[(5)] = ex25915);


if((ex25915 instanceof Error)){
var statearr_25919_25930 = state_25911__$1;
(statearr_25919_25930[(1)] = (4));

(statearr_25919_25930[(5)] = null);

} else {
throw ex25915;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25912 === (6))){
var inst_25904 = (state_25911[(2)]);
var inst_25905 = fluree.db.util.async.throw_err.call(null,inst_25904);
var inst_25906 = cljs.core.assoc.call(null,inst_25905,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_25920 = state_25911;
(statearr_25920[(4)] = cljs.core.rest.call(null,(state_25911[(4)])));

return statearr_25920;
})();
var state_25911__$1 = state_25911;
var statearr_25921_25931 = state_25911__$1;
(statearr_25921_25931[(2)] = inst_25906);

(statearr_25921_25931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0 = (function (){
var statearr_25922 = [null,null,null,null,null,null,null];
(statearr_25922[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__);

(statearr_25922[(1)] = (1));

return statearr_25922;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1 = (function (state_25911){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25923){var ex__2749__auto__ = e25923;
var statearr_25924_25932 = state_25911;
(statearr_25924_25932[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25911[(4)]))){
var statearr_25925_25933 = state_25911;
(statearr_25925_25933[(1)] = cljs.core.first.call(null,(state_25911[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25934 = state_25911;
state_25911 = G__25934;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__ = function(state_25911){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1.call(this,state_25911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25926 = f__2769__auto__.call(null);
(statearr_25926[(6)] = c__2768__auto__);

return statearr_25926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.call(null,this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__25935,property,collection){
var map__25936 = p__25935;
var map__25936__$1 = cljs.core.__destructure_map.call(null,map__25936);
var schema = cljs.core.get.call(null,map__25936__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__25937,property,predicate){
var map__25938 = p__25937;
var map__25938__$1 = cljs.core.__destructure_map.call(null,map__25938);
var this$ = map__25938__$1;
var schema = cljs.core.get.call(null,map__25938__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__25939 = cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop.call(null,this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__25939);
} else {
return G__25939;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__25941 = arguments.length;
switch (G__25941) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25973){
var state_val_25974 = (state_25973[(1)]);
if((state_val_25974 === (7))){
var state_25973__$1 = state_25973;
var statearr_25975_26069 = state_25973__$1;
(statearr_25975_26069[(2)] = null);

(statearr_25975_26069[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25974 === (1))){
var state_25973__$1 = state_25973;
var statearr_25976_26070 = state_25973__$1;
(statearr_25976_26070[(2)] = null);

(statearr_25976_26070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25974 === (4))){
var inst_25942 = (state_25973[(2)]);
var state_25973__$1 = state_25973;
var statearr_25977_26071 = state_25973__$1;
(statearr_25977_26071[(2)] = inst_25942);

(statearr_25977_26071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25974 === (6))){
var inst_25956 = (state_25973[(7)]);
var inst_25955 = (state_25973[(2)]);
var inst_25956__$1 = fluree.db.util.async.throw_err.call(null,inst_25955);
var inst_25957 = (inst_25956__$1 == null);
var state_25973__$1 = (function (){var statearr_25978 = state_25973;
(statearr_25978[(7)] = inst_25956__$1);

return statearr_25978;
})();
if(cljs.core.truth_(inst_25957)){
var statearr_25979_26072 = state_25973__$1;
(statearr_25979_26072[(1)] = (7));

} else {
var statearr_25980_26073 = state_25973__$1;
(statearr_25980_26073[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25974 === (3))){
var inst_25971 = (state_25973[(2)]);
var state_25973__$1 = state_25973;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25973__$1,inst_25971);
} else {
if((state_val_25974 === (12))){
var inst_25968 = (state_25973[(2)]);
var _ = (function (){var statearr_25981 = state_25973;
(statearr_25981[(4)] = cljs.core.rest.call(null,(state_25973[(4)])));

return statearr_25981;
})();
var state_25973__$1 = state_25973;
var statearr_25982_26074 = state_25973__$1;
(statearr_25982_26074[(2)] = inst_25968);

(statearr_25982_26074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25974 === (2))){
var _ = (function (){var statearr_25983 = state_25973;
(statearr_25983[(4)] = cljs.core.cons.call(null,(5),(state_25973[(4)])));

return statearr_25983;
})();
var inst_25949 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_25950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25951 = [tag_id,(30)];
var inst_25952 = (new cljs.core.PersistentVector(null,2,(5),inst_25950,inst_25951,null));
var inst_25953 = fluree.db.query.range.index_range.call(null,inst_25949,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_25952);
var state_25973__$1 = state_25973;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25973__$1,(6),inst_25953);
} else {
if((state_val_25974 === (11))){
var inst_25962 = (state_25973[(8)]);
var inst_25966 = fluree.db.flake.o.call(null,inst_25962);
var state_25973__$1 = state_25973;
var statearr_25985_26075 = state_25973__$1;
(statearr_25985_26075[(2)] = inst_25966);

(statearr_25985_26075[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25974 === (9))){
var inst_25962 = (state_25973[(8)]);
var inst_25962__$1 = (state_25973[(2)]);
var inst_25963 = (inst_25962__$1 == null);
var state_25973__$1 = (function (){var statearr_25986 = state_25973;
(statearr_25986[(8)] = inst_25962__$1);

return statearr_25986;
})();
if(cljs.core.truth_(inst_25963)){
var statearr_25987_26076 = state_25973__$1;
(statearr_25987_26076[(1)] = (10));

} else {
var statearr_25988_26077 = state_25973__$1;
(statearr_25988_26077[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25974 === (5))){
var _ = (function (){var statearr_25989 = state_25973;
(statearr_25989[(4)] = cljs.core.rest.call(null,(state_25973[(4)])));

return statearr_25989;
})();
var state_25973__$1 = state_25973;
var ex25984 = (state_25973__$1[(2)]);
var statearr_25990_26078 = state_25973__$1;
(statearr_25990_26078[(5)] = ex25984);


if((ex25984 instanceof Error)){
var statearr_25991_26079 = state_25973__$1;
(statearr_25991_26079[(1)] = (4));

(statearr_25991_26079[(5)] = null);

} else {
throw ex25984;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25974 === (10))){
var state_25973__$1 = state_25973;
var statearr_25992_26080 = state_25973__$1;
(statearr_25992_26080[(2)] = null);

(statearr_25992_26080[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25974 === (8))){
var inst_25956 = (state_25973[(7)]);
var inst_25960 = cljs.core.first.call(null,inst_25956);
var state_25973__$1 = state_25973;
var statearr_25993_26081 = state_25973__$1;
(statearr_25993_26081[(2)] = inst_25960);

(statearr_25993_26081[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_25994 = [null,null,null,null,null,null,null,null,null];
(statearr_25994[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_25994[(1)] = (1));

return statearr_25994;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_25973){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25973);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25995){var ex__2749__auto__ = e25995;
var statearr_25996_26082 = state_25973;
(statearr_25996_26082[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25973[(4)]))){
var statearr_25997_26083 = state_25973;
(statearr_25997_26083[(1)] = cljs.core.first.call(null,(state_25973[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26084 = state_25973;
state_25973 = G__26084;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_25973){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_25973);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25998 = f__2769__auto__.call(null);
(statearr_25998[(6)] = c__2768__auto__);

return statearr_25998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26034){
var state_val_26035 = (state_26034[(1)]);
if((state_val_26035 === (7))){
var inst_26008 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26034__$1 = state_26034;
var statearr_26036_26085 = state_26034__$1;
(statearr_26036_26085[(2)] = inst_26008);

(statearr_26036_26085[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (1))){
var state_26034__$1 = state_26034;
var statearr_26037_26086 = state_26034__$1;
(statearr_26037_26086[(2)] = null);

(statearr_26037_26086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (4))){
var inst_25999 = (state_26034[(2)]);
var state_26034__$1 = state_26034;
var statearr_26038_26087 = state_26034__$1;
(statearr_26038_26087[(2)] = inst_25999);

(statearr_26038_26087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (15))){
var inst_26029 = (state_26034[(2)]);
var _ = (function (){var statearr_26039 = state_26034;
(statearr_26039[(4)] = cljs.core.rest.call(null,(state_26034[(4)])));

return statearr_26039;
})();
var state_26034__$1 = state_26034;
var statearr_26040_26088 = state_26034__$1;
(statearr_26040_26088[(2)] = inst_26029);

(statearr_26040_26088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (13))){
var inst_26014 = (state_26034[(7)]);
var inst_26020 = clojure.string.includes_QMARK_.call(null,inst_26014,":");
var state_26034__$1 = state_26034;
if(inst_26020){
var statearr_26041_26089 = state_26034__$1;
(statearr_26041_26089[(1)] = (16));

} else {
var statearr_26042_26090 = state_26034__$1;
(statearr_26042_26090[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (6))){
var state_26034__$1 = state_26034;
var statearr_26043_26091 = state_26034__$1;
(statearr_26043_26091[(2)] = pred);

(statearr_26043_26091[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (17))){
var inst_26014 = (state_26034[(7)]);
var state_26034__$1 = state_26034;
var statearr_26044_26092 = state_26034__$1;
(statearr_26044_26092[(2)] = inst_26014);

(statearr_26044_26092[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (3))){
var inst_26032 = (state_26034[(2)]);
var state_26034__$1 = state_26034;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26034__$1,inst_26032);
} else {
if((state_val_26035 === (12))){
var inst_26018 = (state_26034[(2)]);
var state_26034__$1 = state_26034;
if(cljs.core.truth_(inst_26018)){
var statearr_26045_26093 = state_26034__$1;
(statearr_26045_26093[(1)] = (13));

} else {
var statearr_26046_26094 = state_26034__$1;
(statearr_26046_26094[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (2))){
var _ = (function (){var statearr_26047 = state_26034;
(statearr_26047[(4)] = cljs.core.cons.call(null,(5),(state_26034[(4)])));

return statearr_26047;
})();
var inst_26005 = typeof pred === 'string';
var state_26034__$1 = state_26034;
if(cljs.core.truth_(inst_26005)){
var statearr_26048_26095 = state_26034__$1;
(statearr_26048_26095[(1)] = (6));

} else {
var statearr_26049_26096 = state_26034__$1;
(statearr_26049_26096[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (11))){
var inst_26010 = (state_26034[(8)]);
var state_26034__$1 = state_26034;
var statearr_26051_26097 = state_26034__$1;
(statearr_26051_26097[(2)] = inst_26010);

(statearr_26051_26097[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (9))){
var inst_26010 = (state_26034[(8)]);
var inst_26013 = (state_26034[(2)]);
var inst_26014 = fluree.db.util.async.throw_err.call(null,inst_26013);
var state_26034__$1 = (function (){var statearr_26052 = state_26034;
(statearr_26052[(7)] = inst_26014);

return statearr_26052;
})();
if(cljs.core.truth_(inst_26010)){
var statearr_26053_26098 = state_26034__$1;
(statearr_26053_26098[(1)] = (10));

} else {
var statearr_26054_26099 = state_26034__$1;
(statearr_26054_26099[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (5))){
var _ = (function (){var statearr_26055 = state_26034;
(statearr_26055[(4)] = cljs.core.rest.call(null,(state_26034[(4)])));

return statearr_26055;
})();
var state_26034__$1 = state_26034;
var ex26050 = (state_26034__$1[(2)]);
var statearr_26056_26100 = state_26034__$1;
(statearr_26056_26100[(5)] = ex26050);


if((ex26050 instanceof Error)){
var statearr_26057_26101 = state_26034__$1;
(statearr_26057_26101[(1)] = (4));

(statearr_26057_26101[(5)] = null);

} else {
throw ex26050;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (14))){
var state_26034__$1 = state_26034;
var statearr_26058_26102 = state_26034__$1;
(statearr_26058_26102[(2)] = null);

(statearr_26058_26102[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (16))){
var inst_26014 = (state_26034[(7)]);
var inst_26022 = clojure.string.split.call(null,inst_26014,/:/);
var inst_26023 = cljs.core.second.call(null,inst_26022);
var state_26034__$1 = state_26034;
var statearr_26059_26103 = state_26034__$1;
(statearr_26059_26103[(2)] = inst_26023);

(statearr_26059_26103[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (10))){
var inst_26014 = (state_26034[(7)]);
var state_26034__$1 = state_26034;
var statearr_26060_26104 = state_26034__$1;
(statearr_26060_26104[(2)] = inst_26014);

(statearr_26060_26104[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (18))){
var inst_26026 = (state_26034[(2)]);
var state_26034__$1 = state_26034;
var statearr_26061_26105 = state_26034__$1;
(statearr_26061_26105[(2)] = inst_26026);

(statearr_26061_26105[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (8))){
var inst_26010 = (state_26034[(2)]);
var inst_26011 = fluree.db.dbproto._tag.call(null,this$,tag_id);
var state_26034__$1 = (function (){var statearr_26062 = state_26034;
(statearr_26062[(8)] = inst_26010);

return statearr_26062;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26034__$1,(9),inst_26011);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26063 = [null,null,null,null,null,null,null,null,null];
(statearr_26063[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26063[(1)] = (1));

return statearr_26063;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26034){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26034);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26064){var ex__2749__auto__ = e26064;
var statearr_26065_26106 = state_26034;
(statearr_26065_26106[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26034[(4)]))){
var statearr_26066_26107 = state_26034;
(statearr_26066_26107[(1)] = cljs.core.first.call(null,(state_26034[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26108 = state_26034;
state_26034 = G__26108;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26034){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26067 = f__2769__auto__.call(null);
(statearr_26067[(6)] = c__2768__auto__);

return statearr_26067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__26110 = arguments.length;
switch (G__26110) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26143){
var state_val_26144 = (state_26143[(1)]);
if((state_val_26144 === (7))){
var state_26143__$1 = state_26143;
var statearr_26145_26233 = state_26143__$1;
(statearr_26145_26233[(2)] = null);

(statearr_26145_26233[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26144 === (1))){
var state_26143__$1 = state_26143;
var statearr_26146_26234 = state_26143__$1;
(statearr_26146_26234[(2)] = null);

(statearr_26146_26234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26144 === (4))){
var inst_26111 = (state_26143[(2)]);
var state_26143__$1 = state_26143;
var statearr_26147_26235 = state_26143__$1;
(statearr_26147_26235[(2)] = inst_26111);

(statearr_26147_26235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26144 === (6))){
var inst_26126 = (state_26143[(7)]);
var inst_26125 = (state_26143[(2)]);
var inst_26126__$1 = fluree.db.util.async.throw_err.call(null,inst_26125);
var inst_26127 = (inst_26126__$1 == null);
var state_26143__$1 = (function (){var statearr_26148 = state_26143;
(statearr_26148[(7)] = inst_26126__$1);

return statearr_26148;
})();
if(cljs.core.truth_(inst_26127)){
var statearr_26149_26236 = state_26143__$1;
(statearr_26149_26236[(1)] = (7));

} else {
var statearr_26150_26237 = state_26143__$1;
(statearr_26150_26237[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26144 === (3))){
var inst_26141 = (state_26143[(2)]);
var state_26143__$1 = state_26143;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26143__$1,inst_26141);
} else {
if((state_val_26144 === (12))){
var inst_26138 = (state_26143[(2)]);
var _ = (function (){var statearr_26151 = state_26143;
(statearr_26151[(4)] = cljs.core.rest.call(null,(state_26143[(4)])));

return statearr_26151;
})();
var state_26143__$1 = state_26143;
var statearr_26152_26238 = state_26143__$1;
(statearr_26152_26238[(2)] = inst_26138);

(statearr_26152_26238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26144 === (2))){
var _ = (function (){var statearr_26153 = state_26143;
(statearr_26153[(4)] = cljs.core.cons.call(null,(5),(state_26143[(4)])));

return statearr_26153;
})();
var inst_26117 = (30);
var inst_26119 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_26120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26121 = [inst_26117,tag_name];
var inst_26122 = (new cljs.core.PersistentVector(null,2,(5),inst_26120,inst_26121,null));
var inst_26123 = fluree.db.query.range.index_range.call(null,inst_26119,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26122);
var state_26143__$1 = state_26143;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26143__$1,(6),inst_26123);
} else {
if((state_val_26144 === (11))){
var inst_26132 = (state_26143[(8)]);
var inst_26136 = fluree.db.flake.s.call(null,inst_26132);
var state_26143__$1 = state_26143;
var statearr_26155_26239 = state_26143__$1;
(statearr_26155_26239[(2)] = inst_26136);

(statearr_26155_26239[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26144 === (9))){
var inst_26132 = (state_26143[(8)]);
var inst_26132__$1 = (state_26143[(2)]);
var inst_26133 = (inst_26132__$1 == null);
var state_26143__$1 = (function (){var statearr_26156 = state_26143;
(statearr_26156[(8)] = inst_26132__$1);

return statearr_26156;
})();
if(cljs.core.truth_(inst_26133)){
var statearr_26157_26240 = state_26143__$1;
(statearr_26157_26240[(1)] = (10));

} else {
var statearr_26158_26241 = state_26143__$1;
(statearr_26158_26241[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26144 === (5))){
var _ = (function (){var statearr_26159 = state_26143;
(statearr_26159[(4)] = cljs.core.rest.call(null,(state_26143[(4)])));

return statearr_26159;
})();
var state_26143__$1 = state_26143;
var ex26154 = (state_26143__$1[(2)]);
var statearr_26160_26242 = state_26143__$1;
(statearr_26160_26242[(5)] = ex26154);


if((ex26154 instanceof Error)){
var statearr_26161_26243 = state_26143__$1;
(statearr_26161_26243[(1)] = (4));

(statearr_26161_26243[(5)] = null);

} else {
throw ex26154;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26144 === (10))){
var state_26143__$1 = state_26143;
var statearr_26162_26244 = state_26143__$1;
(statearr_26162_26244[(2)] = null);

(statearr_26162_26244[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26144 === (8))){
var inst_26126 = (state_26143[(7)]);
var inst_26130 = cljs.core.first.call(null,inst_26126);
var state_26143__$1 = state_26143;
var statearr_26163_26245 = state_26143__$1;
(statearr_26163_26245[(2)] = inst_26130);

(statearr_26163_26245[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26164 = [null,null,null,null,null,null,null,null,null];
(statearr_26164[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26164[(1)] = (1));

return statearr_26164;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26143){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26143);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26165){var ex__2749__auto__ = e26165;
var statearr_26166_26246 = state_26143;
(statearr_26166_26246[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26143[(4)]))){
var statearr_26167_26247 = state_26143;
(statearr_26167_26247[(1)] = cljs.core.first.call(null,(state_26143[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26248 = state_26143;
state_26143 = G__26248;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26143){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26143);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26168 = f__2769__auto__.call(null);
(statearr_26168[(6)] = c__2768__auto__);

return statearr_26168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26203){
var state_val_26204 = (state_26203[(1)]);
if((state_val_26204 === (7))){
var inst_26182 = typeof pred === 'string';
var state_26203__$1 = state_26203;
if(cljs.core.truth_(inst_26182)){
var statearr_26205_26249 = state_26203__$1;
(statearr_26205_26249[(1)] = (10));

} else {
var statearr_26206_26250 = state_26203__$1;
(statearr_26206_26250[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26204 === (1))){
var state_26203__$1 = state_26203;
var statearr_26207_26251 = state_26203__$1;
(statearr_26207_26251[(2)] = null);

(statearr_26207_26251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26204 === (4))){
var inst_26169 = (state_26203[(2)]);
var state_26203__$1 = state_26203;
var statearr_26208_26252 = state_26203__$1;
(statearr_26208_26252[(2)] = inst_26169);

(statearr_26208_26252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26204 === (15))){
var inst_26196 = (state_26203[(2)]);
var state_26203__$1 = state_26203;
var statearr_26209_26253 = state_26203__$1;
(statearr_26209_26253[(2)] = inst_26196);

(statearr_26209_26253[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26204 === (13))){
var inst_26187 = (state_26203[(7)]);
var inst_26189 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26187),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_26190 = fluree.db.dbproto._tag_id.call(null,this$,inst_26189);
var state_26203__$1 = state_26203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26203__$1,(16),inst_26190);
} else {
if((state_val_26204 === (6))){
var inst_26177 = fluree.db.dbproto._tag_id.call(null,this$,tag_name);
var state_26203__$1 = state_26203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26203__$1,(9),inst_26177);
} else {
if((state_val_26204 === (3))){
var inst_26201 = (state_26203[(2)]);
var state_26203__$1 = state_26203;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26203__$1,inst_26201);
} else {
if((state_val_26204 === (12))){
var inst_26187 = (state_26203[(7)]);
var inst_26187__$1 = (state_26203[(2)]);
var state_26203__$1 = (function (){var statearr_26210 = state_26203;
(statearr_26210[(7)] = inst_26187__$1);

return statearr_26210;
})();
if(cljs.core.truth_(inst_26187__$1)){
var statearr_26211_26254 = state_26203__$1;
(statearr_26211_26254[(1)] = (13));

} else {
var statearr_26212_26255 = state_26203__$1;
(statearr_26212_26255[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26204 === (2))){
var _ = (function (){var statearr_26213 = state_26203;
(statearr_26213[(4)] = cljs.core.cons.call(null,(5),(state_26203[(4)])));

return statearr_26213;
})();
var inst_26175 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_26203__$1 = state_26203;
if(inst_26175){
var statearr_26214_26256 = state_26203__$1;
(statearr_26214_26256[(1)] = (6));

} else {
var statearr_26215_26257 = state_26203__$1;
(statearr_26215_26257[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26204 === (11))){
var inst_26185 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26203__$1 = state_26203;
var statearr_26217_26258 = state_26203__$1;
(statearr_26217_26258[(2)] = inst_26185);

(statearr_26217_26258[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26204 === (9))){
var inst_26179 = (state_26203[(2)]);
var inst_26180 = fluree.db.util.async.throw_err.call(null,inst_26179);
var state_26203__$1 = state_26203;
var statearr_26218_26259 = state_26203__$1;
(statearr_26218_26259[(2)] = inst_26180);

(statearr_26218_26259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26204 === (5))){
var _ = (function (){var statearr_26219 = state_26203;
(statearr_26219[(4)] = cljs.core.rest.call(null,(state_26203[(4)])));

return statearr_26219;
})();
var state_26203__$1 = state_26203;
var ex26216 = (state_26203__$1[(2)]);
var statearr_26220_26260 = state_26203__$1;
(statearr_26220_26260[(5)] = ex26216);


if((ex26216 instanceof Error)){
var statearr_26221_26261 = state_26203__$1;
(statearr_26221_26261[(1)] = (4));

(statearr_26221_26261[(5)] = null);

} else {
throw ex26216;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26204 === (14))){
var state_26203__$1 = state_26203;
var statearr_26222_26262 = state_26203__$1;
(statearr_26222_26262[(2)] = null);

(statearr_26222_26262[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26204 === (16))){
var inst_26192 = (state_26203[(2)]);
var inst_26193 = fluree.db.util.async.throw_err.call(null,inst_26192);
var state_26203__$1 = state_26203;
var statearr_26223_26263 = state_26203__$1;
(statearr_26223_26263[(2)] = inst_26193);

(statearr_26223_26263[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26204 === (10))){
var state_26203__$1 = state_26203;
var statearr_26224_26264 = state_26203__$1;
(statearr_26224_26264[(2)] = pred);

(statearr_26224_26264[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26204 === (8))){
var inst_26198 = (state_26203[(2)]);
var _ = (function (){var statearr_26225 = state_26203;
(statearr_26225[(4)] = cljs.core.rest.call(null,(state_26203[(4)])));

return statearr_26225;
})();
var state_26203__$1 = state_26203;
var statearr_26226_26265 = state_26203__$1;
(statearr_26226_26265[(2)] = inst_26198);

(statearr_26226_26265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26227 = [null,null,null,null,null,null,null,null];
(statearr_26227[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26227[(1)] = (1));

return statearr_26227;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26203){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26203);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26228){var ex__2749__auto__ = e26228;
var statearr_26229_26266 = state_26203;
(statearr_26229_26266[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26203[(4)]))){
var statearr_26230_26267 = state_26203;
(statearr_26230_26267[(1)] = cljs.core.first.call(null,(state_26203[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26268 = state_26203;
state_26203 = G__26268;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26203){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26231 = f__2769__auto__.call(null);
(statearr_26231[(6)] = c__2768__auto__);

return statearr_26231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.tspo = tspo;
this.schema = schema;
this.settings = settings;
this.comparators = comparators;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k26270,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__26274 = k26270;
var G__26274__$1 = (((G__26274 instanceof cljs.core.Keyword))?G__26274.fqn:null);
switch (G__26274__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "tspo":
return self__.tspo;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "comparators":
return self__.comparators;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k26270,else__4505__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__26275){
var vec__26276 = p__26275;
var k__4526__auto__ = cljs.core.nth.call(null,vec__26276,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__26276,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26269){
var self__ = this;
var G__26269__$1 = this;
return (new cljs.core.RecordIter((0),G__26269__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (21 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26271,other26272){
var self__ = this;
var this26271__$1 = this;
return (((!((other26272 == null)))) && ((((this26271__$1.constructor === other26272.constructor)) && (((cljs.core._EQ_.call(null,this26271__$1.conn,other26272.conn)) && (((cljs.core._EQ_.call(null,this26271__$1.network,other26272.network)) && (((cljs.core._EQ_.call(null,this26271__$1.ledger_id,other26272.ledger_id)) && (((cljs.core._EQ_.call(null,this26271__$1.block,other26272.block)) && (((cljs.core._EQ_.call(null,this26271__$1.t,other26272.t)) && (((cljs.core._EQ_.call(null,this26271__$1.tt_id,other26272.tt_id)) && (((cljs.core._EQ_.call(null,this26271__$1.stats,other26272.stats)) && (((cljs.core._EQ_.call(null,this26271__$1.spot,other26272.spot)) && (((cljs.core._EQ_.call(null,this26271__$1.psot,other26272.psot)) && (((cljs.core._EQ_.call(null,this26271__$1.post,other26272.post)) && (((cljs.core._EQ_.call(null,this26271__$1.opst,other26272.opst)) && (((cljs.core._EQ_.call(null,this26271__$1.tspo,other26272.tspo)) && (((cljs.core._EQ_.call(null,this26271__$1.schema,other26272.schema)) && (((cljs.core._EQ_.call(null,this26271__$1.settings,other26272.settings)) && (((cljs.core._EQ_.call(null,this26271__$1.comparators,other26272.comparators)) && (((cljs.core._EQ_.call(null,this26271__$1.schema_cache,other26272.schema_cache)) && (((cljs.core._EQ_.call(null,this26271__$1.novelty,other26272.novelty)) && (((cljs.core._EQ_.call(null,this26271__$1.permissions,other26272.permissions)) && (((cljs.core._EQ_.call(null,this26271__$1.fork,other26272.fork)) && (((cljs.core._EQ_.call(null,this26271__$1.fork_block,other26272.fork_block)) && (((cljs.core._EQ_.call(null,this26271__$1.current_db_fn,other26272.current_db_fn)) && (cljs.core._EQ_.call(null,this26271__$1.__extmap,other26272.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k26270){
var self__ = this;
var this__4509__auto____$1 = this;
var G__26279 = k26270;
var G__26279__$1 = (((G__26279 instanceof cljs.core.Keyword))?G__26279.fqn:null);
switch (G__26279__$1) {
case "conn":
case "network":
case "ledger-id":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "tspo":
case "schema":
case "settings":
case "comparators":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k26270);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__26269){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__26280 = cljs.core.keyword_identical_QMARK_;
var expr__26281 = k__4511__auto__;
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__26281))){
return (new fluree.db.graphdb.GraphDb(G__26269,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__26269,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__26269,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,G__26269,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,G__26269,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,G__26269,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,G__26269,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,G__26269,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__26269,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__26269,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__26269,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__26269,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,G__26269,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,G__26269,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,G__26269,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,G__26269,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,G__26269,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,G__26269,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,G__26269,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__26269,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26280.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__26281))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__26269,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__26269),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__26269){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__26269,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop.call(null,this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop.call(null,this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"tspo","tspo",1200386574,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"comparators","comparators",314919572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__26273){
var extmap__4542__auto__ = (function (){var G__26283 = cljs.core.dissoc.call(null,G__26273,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__26273)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__26283);
} else {
return G__26283;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"tspo","tspo",-440144953).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"comparators","comparators",-1325611955).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__26273),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__26273),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),db__$1.ledger_id,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(comparators){
return cljs.core.reduce.call(null,(function (m,idx){
return cljs.core.assoc.call(null,m,idx,clojure.data.avl.sorted_set_by.call(null,cljs.core.get.call(null,comparators,idx)));
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),fluree.db.index.types);
});
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,ledger_id,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(ledger_id)){
} else {
throw (new Error(["Assert failed: ","No ledger-id provided when creating new db.","\n","ledger-id"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.index.default_comparators);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var map__26286 = fluree.db.index.default_comparators;
var map__26286__$1 = cljs.core.__destructure_map.call(null,map__26286);
var spot_cmp = cljs.core.get.call(null,map__26286__$1,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot_cmp = cljs.core.get.call(null,map__26286__$1,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post_cmp = cljs.core.get.call(null,map__26286__$1,new cljs.core.Keyword(null,"post","post",269697687));
var opst_cmp = cljs.core.get.call(null,map__26286__$1,new cljs.core.Keyword(null,"opst","opst",1213963058));
var tspo_cmp = cljs.core.get.call(null,map__26286__$1,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var spot = fluree.db.index.empty_branch.call(null,network,ledger_id,spot_cmp);
var psot = fluree.db.index.empty_branch.call(null,network,ledger_id,psot_cmp);
var post = fluree.db.index.empty_branch.call(null,network,ledger_id,post_cmp);
var opst = fluree.db.index.empty_branch.call(null,network,ledger_id,opst_cmp);
var tspo = fluree.db.index.empty_branch.call(null,network,ledger_id,tspo_cmp);
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,ledger_id,(0),(-1),null,stats,spot,psot,post,opst,tspo,schema,settings,fluree.db.index.default_comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
