// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
/**
 * Map of default index comparators for the five index types
 */
fluree.db.index.default_comparators = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"post","post",269697687),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"tspo","tspo",-440144953),fluree.db.flake.cmp_flakes_block], null);
/**
 * The five possible index orderings based on the subject, predicate, object,
 *   and transaction flake attributes
 */
fluree.db.index.types = cljs.core.set.call(null,cljs.core.keys.call(null,fluree.db.index.default_comparators));
/**
 * Returns `true` if `node` is a map for a leaf node
 */
fluree.db.index.leaf_QMARK_ = (function fluree$db$index$leaf_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === true;
});
/**
 * Returns `true` if `node` is a map for branch node
 */
fluree.db.index.branch_QMARK_ = (function fluree$db$index$branch_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === false;
});

/**
 * @interface
 */
fluree.db.index.Resolver = function(){};

var fluree$db$index$Resolver$resolve$dyn_13874 = (function (r,node){
var x__4550__auto__ = (((r == null))?null:r);
var m__4551__auto__ = (fluree.db.index.resolve[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,r,node);
} else {
var m__4549__auto__ = (fluree.db.index.resolve["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,r,node);
} else {
throw cljs.core.missing_protocol.call(null,"Resolver.resolve",r);
}
}
});
/**
 * Populate index branch and leaf node maps with either their child node
 *   attributes or the flakes the store, respectively.
 */
fluree.db.index.resolve = (function fluree$db$index$resolve(r,node){
if((((!((r == null)))) && ((!((r.fluree$db$index$Resolver$resolve$arity$2 == null)))))){
return r.fluree$db$index$Resolver$resolve$arity$2(r,node);
} else {
return fluree$db$index$Resolver$resolve$dyn_13874.call(null,r,node);
}
});

fluree.db.index.try_resolve = (function fluree$db$index$try_resolve(r,error_ch,node){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_13896){
var state_val_13897 = (state_13896[(1)]);
if((state_val_13897 === (1))){
var state_13896__$1 = state_13896;
var statearr_13898_13913 = state_13896__$1;
(statearr_13898_13913[(2)] = null);

(statearr_13898_13913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13897 === (2))){
var _ = (function (){var statearr_13899 = state_13896;
(statearr_13899[(4)] = cljs.core.cons.call(null,(6),(state_13896[(4)])));

return statearr_13899;
})();
var inst_13888 = fluree.db.index.resolve.call(null,r,node);
var state_13896__$1 = state_13896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13896__$1,(7),inst_13888);
} else {
if((state_val_13897 === (3))){
var inst_13894 = (state_13896[(2)]);
var state_13896__$1 = state_13896;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13896__$1,inst_13894);
} else {
if((state_val_13897 === (4))){
var inst_13875 = (state_13896[(2)]);
var inst_13876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13877 = [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015)];
var inst_13878 = (new cljs.core.PersistentVector(null,3,(5),inst_13876,inst_13877,null));
var inst_13879 = cljs.core.select_keys.call(null,node,inst_13878);
var inst_13880 = fluree.db.util.log.error.call(null,inst_13875,"Error resolving index node:",inst_13879);
var state_13896__$1 = (function (){var statearr_13901 = state_13896;
(statearr_13901[(7)] = inst_13880);

return statearr_13901;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13896__$1,(5),error_ch,inst_13875);
} else {
if((state_val_13897 === (5))){
var inst_13882 = (state_13896[(2)]);
var state_13896__$1 = state_13896;
var statearr_13902_13914 = state_13896__$1;
(statearr_13902_13914[(2)] = inst_13882);

(statearr_13902_13914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13897 === (6))){
var _ = (function (){var statearr_13903 = state_13896;
(statearr_13903[(4)] = cljs.core.rest.call(null,(state_13896[(4)])));

return statearr_13903;
})();
var state_13896__$1 = state_13896;
var ex13900 = (state_13896__$1[(2)]);
var statearr_13904_13915 = state_13896__$1;
(statearr_13904_13915[(5)] = ex13900);


var statearr_13905_13916 = state_13896__$1;
(statearr_13905_13916[(1)] = (4));

(statearr_13905_13916[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13897 === (7))){
var inst_13890 = (state_13896[(2)]);
var inst_13891 = fluree.db.util.async.throw_err.call(null,inst_13890);
var _ = (function (){var statearr_13906 = state_13896;
(statearr_13906[(4)] = cljs.core.rest.call(null,(state_13896[(4)])));

return statearr_13906;
})();
var state_13896__$1 = state_13896;
var statearr_13907_13917 = state_13896__$1;
(statearr_13907_13917[(2)] = inst_13891);

(statearr_13907_13917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$try_resolve_$_state_machine__2746__auto__ = null;
var fluree$db$index$try_resolve_$_state_machine__2746__auto____0 = (function (){
var statearr_13908 = [null,null,null,null,null,null,null,null];
(statearr_13908[(0)] = fluree$db$index$try_resolve_$_state_machine__2746__auto__);

(statearr_13908[(1)] = (1));

return statearr_13908;
});
var fluree$db$index$try_resolve_$_state_machine__2746__auto____1 = (function (state_13896){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_13896);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e13909){var ex__2749__auto__ = e13909;
var statearr_13910_13918 = state_13896;
(statearr_13910_13918[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_13896[(4)]))){
var statearr_13911_13919 = state_13896;
(statearr_13911_13919[(1)] = cljs.core.first.call(null,(state_13896[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13920 = state_13896;
state_13896 = G__13920;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$index$try_resolve_$_state_machine__2746__auto__ = function(state_13896){
switch(arguments.length){
case 0:
return fluree$db$index$try_resolve_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$index$try_resolve_$_state_machine__2746__auto____1.call(this,state_13896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$try_resolve_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$try_resolve_$_state_machine__2746__auto____0;
fluree$db$index$try_resolve_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$try_resolve_$_state_machine__2746__auto____1;
return fluree$db$index$try_resolve_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_13912 = f__2769__auto__.call(null);
(statearr_13912[(6)] = c__2768__auto__);

return statearr_13912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns `true` if the data associated with the index node map `node` is fully
 *   resolved from storage
 */
fluree.db.index.resolved_QMARK_ = (function fluree$db$index$resolved_QMARK_(node){
if(fluree.db.index.leaf_QMARK_.call(null,node)){
return (!((new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
if(fluree.db.index.branch_QMARK_.call(null,node)){
return (!((new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
return null;
}
}
});
fluree.db.index.lookup = (function fluree$db$index$lookup(branch,flake){
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.index.branch_QMARK_.call(null,branch);
if(and__4251__auto__){
return fluree.db.index.resolved_QMARK_.call(null,branch);
} else {
return and__4251__auto__;
}
})())){
var map__13921 = branch;
var map__13921__$1 = cljs.core.__destructure_map.call(null,map__13921);
var children = cljs.core.get.call(null,map__13921__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.val.call(null,(function (){var or__4253__auto__ = clojure.data.avl.nearest.call(null,children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.first.call(null,children);
}
})());
} else {
return null;
}
});
fluree.db.index.lookup_leaf = (function fluree$db$index$lookup_leaf(r,branch,flake){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_13957){
var state_val_13958 = (state_13957[(1)]);
if((state_val_13958 === (7))){
var inst_13928 = (state_13957[(7)]);
var state_13957__$1 = state_13957;
var statearr_13959_13990 = state_13957__$1;
(statearr_13959_13990[(2)] = inst_13928);

(statearr_13959_13990[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13958 === (1))){
var state_13957__$1 = state_13957;
var statearr_13960_13991 = state_13957__$1;
(statearr_13960_13991[(2)] = null);

(statearr_13960_13991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13958 === (4))){
var inst_13922 = (state_13957[(2)]);
var state_13957__$1 = state_13957;
var statearr_13961_13992 = state_13957__$1;
(statearr_13961_13992[(2)] = inst_13922);

(statearr_13961_13992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13958 === (15))){
var inst_13936 = (state_13957[(8)]);
var inst_13941 = fluree.db.index.resolve.call(null,r,inst_13936);
var state_13957__$1 = state_13957;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13957__$1,(17),inst_13941);
} else {
if((state_val_13958 === (13))){
var inst_13949 = (state_13957[(2)]);
var state_13957__$1 = state_13957;
var statearr_13962_13993 = state_13957__$1;
(statearr_13962_13993[(2)] = inst_13949);

(statearr_13962_13993[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13958 === (6))){
var inst_13930 = fluree.db.index.resolved_QMARK_.call(null,branch);
var state_13957__$1 = state_13957;
var statearr_13963_13994 = state_13957__$1;
(statearr_13963_13994[(2)] = inst_13930);

(statearr_13963_13994[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13958 === (17))){
var inst_13943 = (state_13957[(2)]);
var inst_13944 = fluree.db.util.async.throw_err.call(null,inst_13943);
var inst_13936 = inst_13944;
var state_13957__$1 = (function (){var statearr_13964 = state_13957;
(statearr_13964[(8)] = inst_13936);

return statearr_13964;
})();
var statearr_13965_13995 = state_13957__$1;
(statearr_13965_13995[(2)] = null);

(statearr_13965_13995[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13958 === (3))){
var inst_13955 = (state_13957[(2)]);
var state_13957__$1 = state_13957;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13957__$1,inst_13955);
} else {
if((state_val_13958 === (12))){
var inst_13936 = (state_13957[(8)]);
var inst_13938 = fluree.db.index.leaf_QMARK_.call(null,inst_13936);
var state_13957__$1 = state_13957;
if(inst_13938){
var statearr_13966_13996 = state_13957__$1;
(statearr_13966_13996[(1)] = (14));

} else {
var statearr_13967_13997 = state_13957__$1;
(statearr_13967_13997[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13958 === (2))){
var inst_13928 = (state_13957[(7)]);
var _ = (function (){var statearr_13968 = state_13957;
(statearr_13968[(4)] = cljs.core.cons.call(null,(5),(state_13957[(4)])));

return statearr_13968;
})();
var inst_13928__$1 = fluree.db.index.branch_QMARK_.call(null,branch);
var state_13957__$1 = (function (){var statearr_13969 = state_13957;
(statearr_13969[(7)] = inst_13928__$1);

return statearr_13969;
})();
if(inst_13928__$1){
var statearr_13970_13998 = state_13957__$1;
(statearr_13970_13998[(1)] = (6));

} else {
var statearr_13971_13999 = state_13957__$1;
(statearr_13971_13999[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13958 === (11))){
var inst_13952 = (state_13957[(2)]);
var _ = (function (){var statearr_13973 = state_13957;
(statearr_13973[(4)] = cljs.core.rest.call(null,(state_13957[(4)])));

return statearr_13973;
})();
var state_13957__$1 = state_13957;
var statearr_13974_14000 = state_13957__$1;
(statearr_13974_14000[(2)] = inst_13952);

(statearr_13974_14000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13958 === (9))){
var inst_13935 = fluree.db.index.lookup.call(null,branch,flake);
var inst_13936 = inst_13935;
var state_13957__$1 = (function (){var statearr_13975 = state_13957;
(statearr_13975[(8)] = inst_13936);

return statearr_13975;
})();
var statearr_13976_14001 = state_13957__$1;
(statearr_13976_14001[(2)] = null);

(statearr_13976_14001[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13958 === (5))){
var _ = (function (){var statearr_13977 = state_13957;
(statearr_13977[(4)] = cljs.core.rest.call(null,(state_13957[(4)])));

return statearr_13977;
})();
var state_13957__$1 = state_13957;
var ex13972 = (state_13957__$1[(2)]);
var statearr_13978_14002 = state_13957__$1;
(statearr_13978_14002[(5)] = ex13972);


if((ex13972 instanceof Error)){
var statearr_13979_14003 = state_13957__$1;
(statearr_13979_14003[(1)] = (4));

(statearr_13979_14003[(5)] = null);

} else {
throw ex13972;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13958 === (14))){
var inst_13936 = (state_13957[(8)]);
var state_13957__$1 = state_13957;
var statearr_13980_14004 = state_13957__$1;
(statearr_13980_14004[(2)] = inst_13936);

(statearr_13980_14004[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13958 === (16))){
var inst_13947 = (state_13957[(2)]);
var state_13957__$1 = state_13957;
var statearr_13981_14005 = state_13957__$1;
(statearr_13981_14005[(2)] = inst_13947);

(statearr_13981_14005[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13958 === (10))){
var state_13957__$1 = state_13957;
var statearr_13982_14006 = state_13957__$1;
(statearr_13982_14006[(2)] = null);

(statearr_13982_14006[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13958 === (8))){
var inst_13933 = (state_13957[(2)]);
var state_13957__$1 = state_13957;
if(cljs.core.truth_(inst_13933)){
var statearr_13983_14007 = state_13957__$1;
(statearr_13983_14007[(1)] = (9));

} else {
var statearr_13984_14008 = state_13957__$1;
(statearr_13984_14008[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$lookup_leaf_$_state_machine__2746__auto__ = null;
var fluree$db$index$lookup_leaf_$_state_machine__2746__auto____0 = (function (){
var statearr_13985 = [null,null,null,null,null,null,null,null,null];
(statearr_13985[(0)] = fluree$db$index$lookup_leaf_$_state_machine__2746__auto__);

(statearr_13985[(1)] = (1));

return statearr_13985;
});
var fluree$db$index$lookup_leaf_$_state_machine__2746__auto____1 = (function (state_13957){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_13957);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e13986){var ex__2749__auto__ = e13986;
var statearr_13987_14009 = state_13957;
(statearr_13987_14009[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_13957[(4)]))){
var statearr_13988_14010 = state_13957;
(statearr_13988_14010[(1)] = cljs.core.first.call(null,(state_13957[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14011 = state_13957;
state_13957 = G__14011;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$index$lookup_leaf_$_state_machine__2746__auto__ = function(state_13957){
switch(arguments.length){
case 0:
return fluree$db$index$lookup_leaf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$index$lookup_leaf_$_state_machine__2746__auto____1.call(this,state_13957);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$lookup_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$lookup_leaf_$_state_machine__2746__auto____0;
fluree$db$index$lookup_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$lookup_leaf_$_state_machine__2746__auto____1;
return fluree$db$index$lookup_leaf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_13989 = f__2769__auto__.call(null);
(statearr_13989[(6)] = c__2768__auto__);

return statearr_13989;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.index.add_flakes = (function fluree$db$index$add_flakes(leaf,flakes){
var new_leaf = cljs.core.update.call(null,cljs.core.update.call(null,leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.conj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.call(null,cljs.core._PLUS_,size,cljs.core.map.call(null,fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__4253__auto__ = (function (){var G__14012 = new_leaf;
var G__14012__$1 = (((G__14012 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14012));
if((G__14012__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__14012__$1);
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.call(null,new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
fluree.db.index.rem_flakes = (function fluree$db$index$rem_flakes(leaf,flakes){
var new_leaf = cljs.core.update.call(null,cljs.core.update.call(null,leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.disj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.call(null,cljs.core._,size,cljs.core.map.call(null,fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__4253__auto__ = (function (){var G__14013 = new_leaf;
var G__14013__$1 = (((G__14013 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14013));
if((G__14013__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__14013__$1);
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.call(null,new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
/**
 * Returns a blank leaf node map for the provided `network`, `ledger-id`, and index
 *   comparator `cmp`.
 */
fluree.db.index.empty_leaf = (function fluree$db$index$empty_leaf(network,ledger_id,cmp){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[(0),ledger_id,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.new_leaf = (function fluree$db$index$new_leaf(network,ledger_id,cmp,flakes){
var empty_set = fluree.db.flake.sorted_set_by.call(null,cmp);
return fluree.db.index.add_flakes.call(null,cljs.core.assoc.call(null,fluree.db.index.empty_leaf.call(null,network,ledger_id,cmp),new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set),flakes);
});
/**
 * Checks if the `node` passed in the second argument is a descendant of the
 *   `branch` passed in the first argument
 */
fluree.db.index.descendant_QMARK_ = (function fluree$db$index$descendant_QMARK_(p__14014,p__14015){
var map__14016 = p__14014;
var map__14016__$1 = cljs.core.__destructure_map.call(null,map__14016);
var branch = map__14016__$1;
var cmp = cljs.core.get.call(null,map__14016__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var first_flake = cljs.core.get.call(null,map__14016__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.call(null,map__14016__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.call(null,map__14016__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var map__14017 = p__14015;
var map__14017__$1 = cljs.core.__destructure_map.call(null,map__14017);
var node = map__14017__$1;
var node_first = cljs.core.get.call(null,map__14017__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var node_rhs = cljs.core.get.call(null,map__14017__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
if((!(fluree.db.index.branch_QMARK_.call(null,branch)))){
return false;
} else {
var and__4251__auto__ = (function (){var or__4253__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (!((cmp.call(null,first_flake,node_first) > (0))));
}
})();
if(cljs.core.truth_(and__4251__auto__)){
return (((rhs == null)) || ((((!((node_rhs == null)))) && ((!((cmp.call(null,node_rhs,rhs) > (0))))))));
} else {
return and__4251__auto__;
}
}
});
fluree.db.index.child_entry = (function fluree$db$index$child_entry(p__14018){
var map__14019 = p__14018;
var map__14019__$1 = cljs.core.__destructure_map.call(null,map__14019);
var node = map__14019__$1;
var first = cljs.core.get.call(null,map__14019__$1,new cljs.core.Keyword(null,"first","first",-644103046));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [first,node], null);
});
/**
 * Returns avl sorted map whose keys are the first flakes of the index node
 *   sequence `child-nodes`, and whose values are the corresponding nodes from
 *   `child-nodes`.
 */
fluree.db.index.child_map = (function fluree$db$index$child_map(var_args){
var args__4870__auto__ = [];
var len__4864__auto___14022 = arguments.length;
var i__4865__auto___14023 = (0);
while(true){
if((i__4865__auto___14023 < len__4864__auto___14022)){
args__4870__auto__.push((arguments[i__4865__auto___14023]));

var G__14024 = (i__4865__auto___14023 + (1));
i__4865__auto___14023 = G__14024;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic = (function (cmp,child_nodes){
return cljs.core.apply.call(null,fluree.db.flake.sorted_map_by,cmp,cljs.core.mapcat.call(null,fluree.db.index.child_entry,child_nodes));
}));

(fluree.db.index.child_map.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.index.child_map.cljs$lang$applyTo = (function (seq14020){
var G__14021 = cljs.core.first.call(null,seq14020);
var seq14020__$1 = cljs.core.next.call(null,seq14020);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14021,seq14020__$1);
}));

/**
 * Returns a blank branch node which contains a single empty leaf node for the
 *   provided `network`, `ledger-id`, and index comparator `cmp`.
 */
fluree.db.index.empty_branch = (function fluree$db$index$empty_branch(network,ledger_id,cmp){
var child_node = fluree.db.index.empty_leaf.call(null,network,ledger_id,cmp);
var children = fluree.db.index.child_map.call(null,cmp,child_node);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[children,(0),ledger_id,false,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.reset_children = (function fluree$db$index$reset_children(p__14025,new_child_nodes){
var map__14026 = p__14025;
var map__14026__$1 = cljs.core.__destructure_map.call(null,map__14026);
var branch = map__14026__$1;
var comparator = cljs.core.get.call(null,map__14026__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var size = cljs.core.get.call(null,map__14026__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var new_kids = cljs.core.apply.call(null,fluree.db.index.child_map,comparator,new_child_nodes);
var new_first = (function (){var or__4253__auto__ = (function (){var G__14027 = new_kids;
var G__14027__$1 = (((G__14027 == null))?null:cljs.core.first.call(null,G__14027));
if((G__14027__$1 == null)){
return null;
} else {
return cljs.core.key.call(null,G__14027__$1);
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
var new_size = cljs.core.reduce.call(null,cljs.core._PLUS_,size,cljs.core.map.call(null,new cljs.core.Keyword(null,"size","size",1098693007),new_child_nodes));
return cljs.core.assoc.call(null,branch,new cljs.core.Keyword(null,"first","first",-644103046),new_first,new cljs.core.Keyword(null,"size","size",1098693007),new_size,new cljs.core.Keyword(null,"children","children",-940561982),new_kids);
});
fluree.db.index.new_branch = (function fluree$db$index$new_branch(network,ledger_id,cmp,child_nodes){
return fluree.db.index.reset_children.call(null,fluree.db.index.empty_branch.call(null,network,ledger_id,cmp),child_nodes);
});
/**
 * Returns `true` if `flake` has a transaction value after the provided `t`
 */
fluree.db.index.after_t_QMARK_ = (function fluree$db$index$after_t_QMARK_(t,flake){
return (fluree.db.flake.t.call(null,flake) < t);
});
/**
 * Returns a sequence containing only flakes from the flake set `flakes` with
 *   transaction values after the provided `t`.
 */
fluree.db.index.filter_after = (function fluree$db$index$filter_after(t,flakes){
return cljs.core.filter.call(null,cljs.core.partial.call(null,fluree.db.index.after_t_QMARK_,t),flakes);
});
/**
 * Returns an avl-subset of the avl-set `flakes` with transaction values on or
 *   before the provided `t`.
 */
fluree.db.index.flakes_through = (function fluree$db$index$flakes_through(t,flakes){
return fluree.db.flake.disj_all.call(null,flakes,fluree.db.index.filter_after.call(null,t,flakes));
});
fluree.db.index.novelty_subrange = (function fluree$db$index$novelty_subrange(p__14028,through_t,novelty){
var map__14029 = p__14028;
var map__14029__$1 = cljs.core.__destructure_map.call(null,map__14029);
var node = map__14029__$1;
var first_flake = cljs.core.get.call(null,map__14029__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.call(null,map__14029__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.call(null,map__14029__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var subrange = (cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4251__auto__ = (rhs == null);
if(and__4251__auto__){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?novelty:null))));
return fluree.db.index.flakes_through.call(null,through_t,subrange);
});
/**
 * Returns a sequence of flakes from the sorted set `flakes` that are out of date
 *   by the transaction `t` because `flakes` contains another flake with the same
 *   subject and predicate and a transaction value later than that flake but on or
 *   before `t`.
 */
fluree.db.index.stale_by = (function fluree$db$index$stale_by(t,flakes){
return cljs.core.mapcat.call(null,(function (flakes__$1){
var last_flake = cljs.core.last.call(null,flakes__$1);
if(cljs.core.truth_(fluree.db.flake.op.call(null,last_flake))){
return cljs.core.butlast.call(null,flakes__$1);
} else {
return flakes__$1;
}
}),cljs.core.partition_by.call(null,cljs.core.juxt.call(null,fluree.db.flake.s,fluree.db.flake.p,fluree.db.flake.o),cljs.core.filter.call(null,cljs.core.complement.call(null,cljs.core.partial.call(null,fluree.db.index.after_t_QMARK_,t)),flakes)));
});
/**
 * Returns a sorted set of flakes that are not out of date between the
 *   transactions `from-t` and `to-t`.
 */
fluree.db.index.t_range = (function fluree$db$index$t_range(p__14030,novelty,from_t,to_t){
var map__14031 = p__14030;
var map__14031__$1 = cljs.core.__destructure_map.call(null,map__14031);
var leaf = map__14031__$1;
var leaf_t = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__14031__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var latest = (function (){var G__14032 = flakes;
if((leaf_t > to_t)){
return fluree.db.flake.conj_all.call(null,G__14032,fluree.db.index.novelty_subrange.call(null,leaf,to_t,novelty));
} else {
return G__14032;
}
})();
var stale_flakes = fluree.db.index.stale_by.call(null,from_t,latest);
var subsequent = fluree.db.index.filter_after.call(null,to_t,latest);
var out_of_range = cljs.core.concat.call(null,stale_flakes,subsequent);
return fluree.db.flake.disj_all.call(null,latest,out_of_range);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.CachedTRangeResolver = (function (node_resolver,novelty,from_t,to_t,async_cache,__meta,__extmap,__hash){
this.node_resolver = node_resolver;
this.novelty = novelty;
this.from_t = from_t;
this.to_t = to_t;
this.async_cache = async_cache;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (_,p__14038){
var self__ = this;
var map__14039 = p__14038;
var map__14039__$1 = cljs.core.__destructure_map.call(null,map__14039);
var node = map__14039__$1;
var id = cljs.core.get.call(null,map__14039__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tempid = cljs.core.get.call(null,map__14039__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var tt_id = cljs.core.get.call(null,map__14039__$1,new cljs.core.Keyword(null,"tt-id","tt-id",725587484));
var ___$1 = this;
if(fluree.db.index.branch_QMARK_.call(null,node)){
return fluree.db.index.resolve.call(null,self__.node_resolver,node);
} else {
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.index","t-range","fluree.db.index/t-range",437950593),id,tempid,tt_id,self__.from_t,self__.to_t], null),(function (___$2){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14057){
var state_val_14058 = (state_14057[(1)]);
if((state_val_14058 === (1))){
var state_14057__$1 = state_14057;
var statearr_14059_14083 = state_14057__$1;
(statearr_14059_14083[(2)] = null);

(statearr_14059_14083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14058 === (2))){
var ___$3 = (function (){var statearr_14060 = state_14057;
(statearr_14060[(4)] = cljs.core.cons.call(null,(5),(state_14057[(4)])));

return statearr_14060;
})();
var inst_14046 = fluree.db.index.resolve.call(null,self__.node_resolver,node);
var state_14057__$1 = state_14057;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14057__$1,(6),inst_14046);
} else {
if((state_val_14058 === (3))){
var inst_14055 = (state_14057[(2)]);
var state_14057__$1 = state_14057;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14057__$1,inst_14055);
} else {
if((state_val_14058 === (4))){
var inst_14040 = (state_14057[(2)]);
var state_14057__$1 = state_14057;
var statearr_14062_14084 = state_14057__$1;
(statearr_14062_14084[(2)] = inst_14040);

(statearr_14062_14084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14058 === (5))){
var ___$3 = (function (){var statearr_14063 = state_14057;
(statearr_14063[(4)] = cljs.core.rest.call(null,(state_14057[(4)])));

return statearr_14063;
})();
var state_14057__$1 = state_14057;
var ex14061 = (state_14057__$1[(2)]);
var statearr_14064_14085 = state_14057__$1;
(statearr_14064_14085[(5)] = ex14061);


if((ex14061 instanceof Error)){
var statearr_14065_14086 = state_14057__$1;
(statearr_14065_14086[(1)] = (4));

(statearr_14065_14086[(5)] = null);

} else {
throw ex14061;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14058 === (6))){
var inst_14048 = (state_14057[(2)]);
var inst_14049 = fluree.db.util.async.throw_err.call(null,inst_14048);
var inst_14050 = fluree.db.index.t_range.call(null,inst_14049,self__.novelty,self__.from_t,self__.to_t);
var inst_14051 = cljs.core.dissoc.call(null,inst_14049,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_14052 = cljs.core.assoc.call(null,inst_14051,new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_14050);
var ___$3 = (function (){var statearr_14066 = state_14057;
(statearr_14066[(4)] = cljs.core.rest.call(null,(state_14057[(4)])));

return statearr_14066;
})();
var state_14057__$1 = state_14057;
var statearr_14067_14087 = state_14057__$1;
(statearr_14067_14087[(2)] = inst_14052);

(statearr_14067_14087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2746__auto__ = null;
var fluree$db$index$state_machine__2746__auto____0 = (function (){
var statearr_14068 = [null,null,null,null,null,null,null];
(statearr_14068[(0)] = fluree$db$index$state_machine__2746__auto__);

(statearr_14068[(1)] = (1));

return statearr_14068;
});
var fluree$db$index$state_machine__2746__auto____1 = (function (state_14057){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14057);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14069){var ex__2749__auto__ = e14069;
var statearr_14070_14088 = state_14057;
(statearr_14070_14088[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14057[(4)]))){
var statearr_14071_14089 = state_14057;
(statearr_14071_14089[(1)] = cljs.core.first.call(null,(state_14057[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14090 = state_14057;
state_14057 = G__14090;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$index$state_machine__2746__auto__ = function(state_14057){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2746__auto____1.call(this,state_14057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2746__auto____0;
fluree$db$index$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2746__auto____1;
return fluree$db$index$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14072 = f__2769__auto__.call(null);
(statearr_14072[(6)] = c__2768__auto__);

return statearr_14072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k14034,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__14073 = k14034;
var G__14073__$1 = (((G__14073 instanceof cljs.core.Keyword))?G__14073.fqn:null);
switch (G__14073__$1) {
case "node-resolver":
return self__.node_resolver;

break;
case "novelty":
return self__.novelty;

break;
case "from-t":
return self__.from_t;

break;
case "to-t":
return self__.to_t;

break;
case "async-cache":
return self__.async_cache;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k14034,else__4505__auto__);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__14074){
var vec__14075 = p__14074;
var k__4526__auto__ = cljs.core.nth.call(null,vec__14075,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__14075,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.index.CachedTRangeResolver{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14033){
var self__ = this;
var G__14033__$1 = this;
return (new cljs.core.RecordIter((0),G__14033__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (361103374 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14035,other14036){
var self__ = this;
var this14035__$1 = this;
return (((!((other14036 == null)))) && ((((this14035__$1.constructor === other14036.constructor)) && (((cljs.core._EQ_.call(null,this14035__$1.node_resolver,other14036.node_resolver)) && (((cljs.core._EQ_.call(null,this14035__$1.novelty,other14036.novelty)) && (((cljs.core._EQ_.call(null,this14035__$1.from_t,other14036.from_t)) && (((cljs.core._EQ_.call(null,this14035__$1.to_t,other14036.to_t)) && (((cljs.core._EQ_.call(null,this14035__$1.async_cache,other14036.async_cache)) && (cljs.core._EQ_.call(null,this14035__$1.__extmap,other14036.__extmap)))))))))))))));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),null,new cljs.core.Keyword(null,"from-t","from-t",1730913525),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"to-t","to-t",569467359),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k14034){
var self__ = this;
var this__4509__auto____$1 = this;
var G__14078 = k14034;
var G__14078__$1 = (((G__14078 instanceof cljs.core.Keyword))?G__14078.fqn:null);
switch (G__14078__$1) {
case "node-resolver":
case "novelty":
case "from-t":
case "to-t":
case "async-cache":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k14034);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__14033){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__14079 = cljs.core.keyword_identical_QMARK_;
var expr__14080 = k__4511__auto__;
if(cljs.core.truth_(pred__14079.call(null,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),expr__14080))){
return (new fluree.db.index.CachedTRangeResolver(G__14033,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14079.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__14080))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,G__14033,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14079.call(null,new cljs.core.Keyword(null,"from-t","from-t",1730913525),expr__14080))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,G__14033,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14079.call(null,new cljs.core.Keyword(null,"to-t","to-t",569467359),expr__14080))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,G__14033,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14079.call(null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),expr__14080))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,G__14033,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__14033),null));
}
}
}
}
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__14033){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,G__14033,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.index.CachedTRangeResolver.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node-resolver","node-resolver",-1971835691,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"from-t","from-t",-923522244,null),new cljs.core.Symbol(null,"to-t","to-t",-2084968410,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null)], null);
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$type = true);

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.index/CachedTRangeResolver",null,(1),null));
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.index/CachedTRangeResolver");
}));

/**
 * Positional factory function for fluree.db.index/CachedTRangeResolver.
 */
fluree.db.index.__GT_CachedTRangeResolver = (function fluree$db$index$__GT_CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache){
return (new fluree.db.index.CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache,null,null,null));
});

/**
 * Factory function for fluree.db.index/CachedTRangeResolver, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_CachedTRangeResolver = (function fluree$db$index$map__GT_CachedTRangeResolver(G__14037){
var extmap__4542__auto__ = (function (){var G__14082 = cljs.core.dissoc.call(null,G__14037,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
if(cljs.core.record_QMARK_.call(null,G__14037)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__14082);
} else {
return G__14082;
}
})();
return (new fluree.db.index.CachedTRangeResolver(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078).cljs$core$IFn$_invoke$arity$1(G__14037),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__14037),new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(G__14037),new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(G__14037),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__14037),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

/**
 * Find the value of `leaf` at transaction `t` by adding new flakes from
 *   `idx-novelty` to `leaf` if `t` is newer than `leaf`, or removing flakes later
 *   than `t` from `leaf` if `t` is older than `leaf`.
 */
fluree.db.index.at_t = (function fluree$db$index$at_t(p__14093,t,idx_novelty){
var map__14094 = p__14093;
var map__14094__$1 = cljs.core.__destructure_map.call(null,map__14094);
var leaf = map__14094__$1;
var leaf_t = cljs.core.get.call(null,map__14094__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var rhs = cljs.core.get.call(null,map__14094__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.call(null,map__14094__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var flakes = cljs.core.get.call(null,map__14094__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
if(cljs.core._EQ_.call(null,leaf_t,t)){
return leaf;
} else {
var G__14095 = leaf;
var G__14095__$1 = (((leaf_t > t))?fluree.db.index.add_flakes.call(null,G__14095,fluree.db.index.novelty_subrange.call(null,leaf,t,idx_novelty)):G__14095);
var G__14095__$2 = (((leaf_t < t))?fluree.db.index.rem_flakes.call(null,G__14095__$1,fluree.db.index.filter_after.call(null,t,flakes)):G__14095__$1);
return cljs.core.assoc.call(null,G__14095__$2,new cljs.core.Keyword(null,"t","t",-1397832519),t);

}
});
fluree.db.index.mark_expanded = (function fluree$db$index$mark_expanded(node){
return cljs.core.assoc.call(null,node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179),true);
});
fluree.db.index.unmark_expanded = (function fluree$db$index$unmark_expanded(node){
return cljs.core.dissoc.call(null,node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179));
});
fluree.db.index.expanded_QMARK_ = (function fluree$db$index$expanded_QMARK_(node){
return new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179).cljs$core$IFn$_invoke$arity$1(node) === true;
});
fluree.db.index.resolve_when = (function fluree$db$index$resolve_when(r,resolve_QMARK_,error_ch,node){
if(cljs.core.truth_(resolve_QMARK_.call(null,node))){
return fluree.db.index.try_resolve.call(null,r,error_ch,node);
} else {
var G__14096 = cljs.core.async.chan.call(null);
cljs.core.async.put_BANG_.call(null,G__14096,node);

return G__14096;
}
});
fluree.db.index.resolve_children_when = (function fluree$db$index$resolve_children_when(r,resolve_QMARK_,error_ch,branch){
if(cljs.core.truth_(fluree.db.index.resolved_QMARK_.call(null,branch))){
return cljs.core.async.map.call(null,cljs.core.vector,cljs.core.map.call(null,(function (p__14097){
var vec__14098 = p__14097;
var _ = cljs.core.nth.call(null,vec__14098,(0),null);
var child = cljs.core.nth.call(null,vec__14098,(1),null);
return fluree.db.index.resolve_when.call(null,r,resolve_QMARK_,error_ch,child);
}),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(branch)));
} else {
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14103){
var state_val_14104 = (state_14103[(1)]);
if((state_val_14104 === (1))){
var inst_14101 = cljs.core.PersistentVector.EMPTY;
var state_14103__$1 = state_14103;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14103__$1,inst_14101);
} else {
return null;
}
});
return (function() {
var fluree$db$index$resolve_children_when_$_state_machine__2746__auto__ = null;
var fluree$db$index$resolve_children_when_$_state_machine__2746__auto____0 = (function (){
var statearr_14105 = [null,null,null,null,null,null,null];
(statearr_14105[(0)] = fluree$db$index$resolve_children_when_$_state_machine__2746__auto__);

(statearr_14105[(1)] = (1));

return statearr_14105;
});
var fluree$db$index$resolve_children_when_$_state_machine__2746__auto____1 = (function (state_14103){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14103);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14106){var ex__2749__auto__ = e14106;
var statearr_14107_14110 = state_14103;
(statearr_14107_14110[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14103[(4)]))){
var statearr_14108_14111 = state_14103;
(statearr_14108_14111[(1)] = cljs.core.first.call(null,(state_14103[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14112 = state_14103;
state_14103 = G__14112;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$index$resolve_children_when_$_state_machine__2746__auto__ = function(state_14103){
switch(arguments.length){
case 0:
return fluree$db$index$resolve_children_when_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$index$resolve_children_when_$_state_machine__2746__auto____1.call(this,state_14103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$resolve_children_when_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$resolve_children_when_$_state_machine__2746__auto____0;
fluree$db$index$resolve_children_when_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$resolve_children_when_$_state_machine__2746__auto____1;
return fluree$db$index$resolve_children_when_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14109 = f__2769__auto__.call(null);
(statearr_14109[(6)] = c__2768__auto__);

return statearr_14109;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}
});
/**
 * Returns a channel that will eventually contain the stream of index nodes
 *   descended from `root` in depth-first order. `resolve?` is a boolean function
 *   that will be applied to each node to determine whether or not the data
 *   associated with that node will be resolved from disk using the supplied
 *   `Resolver` `r`. `include?` is a boolean function that will be applied to each
 *   node to determine if it will be included in the final output node stream, `n`
 *   is an optional parameter specifying the number of nodes to load concurrently,
 *   and `xf` is an optional transducer that will transform the output stream if
 *   supplied.
 */
fluree.db.index.tree_chan = (function fluree$db$index$tree_chan(var_args){
var G__14114 = arguments.length;
switch (G__14114) {
case 5:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 7:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5 = (function (r,root,resolve_QMARK_,include_QMARK_,error_ch){
return fluree.db.index.tree_chan.call(null,r,root,resolve_QMARK_,include_QMARK_,(1),cljs.core.identity,error_ch);
}));

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7 = (function (r,root,resolve_QMARK_,include_QMARK_,n,xf,error_ch){
var out = cljs.core.async.chan.call(null,n,xf);
var c__2768__auto___14192 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14160){
var state_val_14161 = (state_14160[(1)]);
if((state_val_14161 === (7))){
var inst_14155 = (state_14160[(2)]);
var state_14160__$1 = state_14160;
var statearr_14162_14193 = state_14160__$1;
(statearr_14162_14193[(2)] = inst_14155);

(statearr_14162_14193[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14161 === (1))){
var inst_14115 = fluree.db.index.resolve_when.call(null,r,resolve_QMARK_,error_ch,root);
var state_14160__$1 = state_14160;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14160__$1,(2),inst_14115);
} else {
if((state_val_14161 === (4))){
var inst_14157 = (state_14160[(2)]);
var inst_14158 = cljs.core.async.close_BANG_.call(null,out);
var state_14160__$1 = (function (){var statearr_14163 = state_14160;
(statearr_14163[(7)] = inst_14157);

return statearr_14163;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14160__$1,inst_14158);
} else {
if((state_val_14161 === (15))){
var state_14160__$1 = state_14160;
var statearr_14164_14194 = state_14160__$1;
(statearr_14164_14194[(2)] = null);

(statearr_14164_14194[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14161 === (13))){
var inst_14152 = (state_14160[(2)]);
var state_14160__$1 = state_14160;
var statearr_14165_14195 = state_14160__$1;
(statearr_14165_14195[(2)] = inst_14152);

(statearr_14165_14195[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14161 === (6))){
var state_14160__$1 = state_14160;
var statearr_14166_14196 = state_14160__$1;
(statearr_14166_14196[(2)] = null);

(statearr_14166_14196[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14161 === (17))){
var inst_14137 = (state_14160[(2)]);
var state_14160__$1 = state_14160;
var statearr_14167_14197 = state_14160__$1;
(statearr_14167_14197[(2)] = inst_14137);

(statearr_14167_14197[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14161 === (3))){
var inst_14121 = (state_14160[(8)]);
var inst_14123 = (state_14160[(9)]);
var inst_14123__$1 = cljs.core.peek.call(null,inst_14121);
var state_14160__$1 = (function (){var statearr_14168 = state_14160;
(statearr_14168[(9)] = inst_14123__$1);

return statearr_14168;
})();
if(cljs.core.truth_(inst_14123__$1)){
var statearr_14169_14198 = state_14160__$1;
(statearr_14169_14198[(1)] = (5));

} else {
var statearr_14170_14199 = state_14160__$1;
(statearr_14170_14199[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14161 === (12))){
var inst_14123 = (state_14160[(9)]);
var inst_14143 = fluree.db.index.resolve_children_when.call(null,r,resolve_QMARK_,error_ch,inst_14123);
var state_14160__$1 = state_14160;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14160__$1,(18),inst_14143);
} else {
if((state_val_14161 === (2))){
var inst_14117 = (state_14160[(2)]);
var inst_14118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14119 = [inst_14117];
var inst_14120 = (new cljs.core.PersistentVector(null,1,(5),inst_14118,inst_14119,null));
var inst_14121 = inst_14120;
var state_14160__$1 = (function (){var statearr_14171 = state_14160;
(statearr_14171[(8)] = inst_14121);

return statearr_14171;
})();
var statearr_14172_14200 = state_14160__$1;
(statearr_14172_14200[(2)] = null);

(statearr_14172_14200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14161 === (11))){
var inst_14123 = (state_14160[(9)]);
var inst_14133 = include_QMARK_.call(null,inst_14123);
var state_14160__$1 = state_14160;
if(cljs.core.truth_(inst_14133)){
var statearr_14173_14201 = state_14160__$1;
(statearr_14173_14201[(1)] = (14));

} else {
var statearr_14174_14202 = state_14160__$1;
(statearr_14174_14202[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14161 === (9))){
var inst_14123 = (state_14160[(9)]);
var inst_14129 = fluree.db.index.expanded_QMARK_.call(null,inst_14123);
var state_14160__$1 = state_14160;
var statearr_14175_14203 = state_14160__$1;
(statearr_14175_14203[(2)] = inst_14129);

(statearr_14175_14203[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14161 === (5))){
var inst_14121 = (state_14160[(8)]);
var inst_14123 = (state_14160[(9)]);
var inst_14126 = (state_14160[(10)]);
var inst_14125 = cljs.core.pop.call(null,inst_14121);
var inst_14126__$1 = fluree.db.index.leaf_QMARK_.call(null,inst_14123);
var state_14160__$1 = (function (){var statearr_14176 = state_14160;
(statearr_14176[(10)] = inst_14126__$1);

(statearr_14176[(11)] = inst_14125);

return statearr_14176;
})();
if(inst_14126__$1){
var statearr_14177_14204 = state_14160__$1;
(statearr_14177_14204[(1)] = (8));

} else {
var statearr_14178_14205 = state_14160__$1;
(statearr_14178_14205[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14161 === (14))){
var inst_14123 = (state_14160[(9)]);
var inst_14135 = fluree.db.index.unmark_expanded.call(null,inst_14123);
var state_14160__$1 = state_14160;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14160__$1,(17),out,inst_14135);
} else {
if((state_val_14161 === (16))){
var inst_14125 = (state_14160[(11)]);
var inst_14140 = (state_14160[(2)]);
var inst_14121 = inst_14125;
var state_14160__$1 = (function (){var statearr_14179 = state_14160;
(statearr_14179[(8)] = inst_14121);

(statearr_14179[(12)] = inst_14140);

return statearr_14179;
})();
var statearr_14180_14206 = state_14160__$1;
(statearr_14180_14206[(2)] = null);

(statearr_14180_14206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14161 === (10))){
var inst_14131 = (state_14160[(2)]);
var state_14160__$1 = state_14160;
if(cljs.core.truth_(inst_14131)){
var statearr_14181_14207 = state_14160__$1;
(statearr_14181_14207[(1)] = (11));

} else {
var statearr_14182_14208 = state_14160__$1;
(statearr_14182_14208[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14161 === (18))){
var inst_14123 = (state_14160[(9)]);
var inst_14125 = (state_14160[(11)]);
var inst_14145 = (state_14160[(2)]);
var inst_14146 = fluree.db.index.mark_expanded.call(null,inst_14123);
var inst_14147 = cljs.core.conj.call(null,inst_14125,inst_14146);
var inst_14148 = cljs.core.rseq.call(null,inst_14145);
var inst_14149 = cljs.core.into.call(null,inst_14147,inst_14148);
var inst_14121 = inst_14149;
var state_14160__$1 = (function (){var statearr_14183 = state_14160;
(statearr_14183[(8)] = inst_14121);

return statearr_14183;
})();
var statearr_14184_14209 = state_14160__$1;
(statearr_14184_14209[(2)] = null);

(statearr_14184_14209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14161 === (8))){
var inst_14126 = (state_14160[(10)]);
var state_14160__$1 = state_14160;
var statearr_14185_14210 = state_14160__$1;
(statearr_14185_14210[(2)] = inst_14126);

(statearr_14185_14210[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2746__auto__ = null;
var fluree$db$index$state_machine__2746__auto____0 = (function (){
var statearr_14186 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14186[(0)] = fluree$db$index$state_machine__2746__auto__);

(statearr_14186[(1)] = (1));

return statearr_14186;
});
var fluree$db$index$state_machine__2746__auto____1 = (function (state_14160){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14160);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14187){var ex__2749__auto__ = e14187;
var statearr_14188_14211 = state_14160;
(statearr_14188_14211[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14160[(4)]))){
var statearr_14189_14212 = state_14160;
(statearr_14189_14212[(1)] = cljs.core.first.call(null,(state_14160[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14213 = state_14160;
state_14160 = G__14213;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$index$state_machine__2746__auto__ = function(state_14160){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2746__auto____1.call(this,state_14160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2746__auto____0;
fluree$db$index$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2746__auto____1;
return fluree$db$index$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14190 = f__2769__auto__.call(null);
(statearr_14190[(6)] = c__2768__auto___14192);

return statearr_14190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return out;
}));

(fluree.db.index.tree_chan.cljs$lang$maxFixedArity = 7);

