// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__17466 = arguments.length;
switch (G__17466) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,ledger){
return fluree.db.operations.formulate_op_header.call(null,operation,ledger,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,ledger,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__17469 = arguments.length;
switch (G__17469) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___17522 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17500){
var state_val_17501 = (state_17500[(1)]);
if((state_val_17501 === (1))){
var state_17500__$1 = state_17500;
var statearr_17502_17523 = state_17500__$1;
(statearr_17502_17523[(2)] = null);

(statearr_17502_17523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17501 === (2))){
var _ = (function (){var statearr_17503 = state_17500;
(statearr_17503[(4)] = cljs.core.cons.call(null,(5),(state_17500[(4)])));

return statearr_17503;
})();
var inst_17477 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_17500__$1 = state_17500;
if(cljs.core.truth_(inst_17477)){
var statearr_17504_17524 = state_17500__$1;
(statearr_17504_17524[(1)] = (6));

} else {
var statearr_17505_17525 = state_17500__$1;
(statearr_17505_17525[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17501 === (3))){
var inst_17498 = (state_17500[(2)]);
var state_17500__$1 = state_17500;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17500__$1,inst_17498);
} else {
if((state_val_17501 === (4))){
var inst_17470 = (state_17500[(2)]);
var inst_17471 = cljs.core.async.put_BANG_.call(null,pc,inst_17470);
var state_17500__$1 = state_17500;
var statearr_17507_17526 = state_17500__$1;
(statearr_17507_17526[(2)] = inst_17471);

(statearr_17507_17526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17501 === (5))){
var _ = (function (){var statearr_17508 = state_17500;
(statearr_17508[(4)] = cljs.core.rest.call(null,(state_17500[(4)])));

return statearr_17508;
})();
var state_17500__$1 = state_17500;
var ex17506 = (state_17500__$1[(2)]);
var statearr_17509_17527 = state_17500__$1;
(statearr_17509_17527[(5)] = ex17506);


var statearr_17510_17528 = state_17500__$1;
(statearr_17510_17528[(1)] = (4));

(statearr_17510_17528[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17501 === (6))){
var inst_17479 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17480 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_17481 = cljs.core.PersistentHashMap.fromArrays(inst_17479,inst_17480);
var inst_17482 = cljs.core.ex_info.call(null,"Connection was closed.",inst_17481);
var inst_17483 = (function(){throw inst_17482})();
var state_17500__$1 = state_17500;
var statearr_17511_17529 = state_17500__$1;
(statearr_17511_17529[(2)] = inst_17483);

(statearr_17511_17529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17501 === (7))){
var inst_17485 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_17486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17487 = [operation,data,pc,opts];
var inst_17488 = (new cljs.core.PersistentVector(null,4,(5),inst_17486,inst_17487,null));
var inst_17489 = cljs.core.async.put_BANG_.call(null,inst_17485,inst_17488);
var inst_17490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17491 = [operation,data,pc,opts];
var inst_17492 = (new cljs.core.PersistentVector(null,4,(5),inst_17490,inst_17491,null));
var inst_17493 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_17492);
var state_17500__$1 = (function (){var statearr_17512 = state_17500;
(statearr_17512[(7)] = inst_17489);

return statearr_17512;
})();
var statearr_17513_17530 = state_17500__$1;
(statearr_17513_17530[(2)] = inst_17493);

(statearr_17513_17530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17501 === (8))){
var inst_17495 = (state_17500[(2)]);
var _ = (function (){var statearr_17514 = state_17500;
(statearr_17514[(4)] = cljs.core.rest.call(null,(state_17500[(4)])));

return statearr_17514;
})();
var state_17500__$1 = state_17500;
var statearr_17515_17531 = state_17500__$1;
(statearr_17515_17531[(2)] = inst_17495);

(statearr_17515_17531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2746__auto__ = null;
var fluree$db$operations$state_machine__2746__auto____0 = (function (){
var statearr_17516 = [null,null,null,null,null,null,null,null];
(statearr_17516[(0)] = fluree$db$operations$state_machine__2746__auto__);

(statearr_17516[(1)] = (1));

return statearr_17516;
});
var fluree$db$operations$state_machine__2746__auto____1 = (function (state_17500){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17500);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17517){var ex__2749__auto__ = e17517;
var statearr_17518_17532 = state_17500;
(statearr_17518_17532[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17500[(4)]))){
var statearr_17519_17533 = state_17500;
(statearr_17519_17533[(1)] = cljs.core.first.call(null,(state_17500[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17534 = state_17500;
state_17500 = G__17534;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2746__auto__ = function(state_17500){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2746__auto____1.call(this,state_17500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2746__auto____0;
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2746__auto____1;
return fluree$db$operations$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17520 = f__2769__auto__.call(null);
(statearr_17520[(6)] = c__2768__auto___17522);

return statearr_17520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__17536 = arguments.length;
switch (G__17536) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__17537){
var map__17538 = p__17537;
var map__17538__$1 = cljs.core.__destructure_map.call(null,map__17538);
var opts = map__17538__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__17538__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__17539 = session;
var map__17539__$1 = cljs.core.__destructure_map.call(null,map__17539);
var ledger_id = cljs.core.get.call(null,map__17539__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var network = cljs.core.get.call(null,map__17539__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__17539__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4870__auto__ = [];
var len__4864__auto___17566 = arguments.length;
var i__4865__auto___17567 = (0);
while(true){
if((i__4865__auto___17567 < len__4864__auto___17566)){
args__4870__auto__.push((arguments[i__4865__auto___17567]));

var G__17568 = (i__4865__auto___17567 + (1));
i__4865__auto___17567 = G__17568;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__17543){
var vec__17544 = p__17543;
var map__17547 = cljs.core.nth.call(null,vec__17544,(0),null);
var map__17547__$1 = cljs.core.__destructure_map.call(null,map__17547);
var toBlock = cljs.core.get.call(null,map__17547__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__17547__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__17544;
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17559){
var state_val_17560 = (state_17559[(1)]);
if((state_val_17560 === (1))){
var inst_17549 = session;
var inst_17550 = cljs.core.__destructure_map.call(null,inst_17549);
var inst_17551 = cljs.core.get.call(null,inst_17550,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17552 = cljs.core.get.call(null,inst_17550,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17553 = cljs.core.get.call(null,inst_17550,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17554 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_17555 = [inst_17551,inst_17552,toBlock,toTime];
var inst_17556 = cljs.core.PersistentHashMap.fromArrays(inst_17554,inst_17555);
var inst_17557 = fluree.db.operations.send_operation.call(null,inst_17553,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_17556);
var state_17559__$1 = state_17559;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17559__$1,inst_17557);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2746__auto__ = null;
var fluree$db$operations$state_machine__2746__auto____0 = (function (){
var statearr_17561 = [null,null,null,null,null,null,null];
(statearr_17561[(0)] = fluree$db$operations$state_machine__2746__auto__);

(statearr_17561[(1)] = (1));

return statearr_17561;
});
var fluree$db$operations$state_machine__2746__auto____1 = (function (state_17559){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17559);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17562){var ex__2749__auto__ = e17562;
var statearr_17563_17569 = state_17559;
(statearr_17563_17569[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17559[(4)]))){
var statearr_17564_17570 = state_17559;
(statearr_17564_17570[(1)] = cljs.core.first.call(null,(state_17559[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17571 = state_17559;
state_17559 = G__17571;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2746__auto__ = function(state_17559){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2746__auto____1.call(this,state_17559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2746__auto____0;
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2746__auto____1;
return fluree$db$operations$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17565 = f__2769__auto__.call(null);
(statearr_17565[(6)] = c__2768__auto__);

return statearr_17565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq17541){
var G__17542 = cljs.core.first.call(null,seq17541);
var seq17541__$1 = cljs.core.next.call(null,seq17541);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17542,seq17541__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__17572 = session;
var map__17572__$1 = cljs.core.__destructure_map.call(null,map__17572);
var network = cljs.core.get.call(null,map__17572__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__17572__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var conn = cljs.core.get.call(null,map__17572__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__17574 = arguments.length;
switch (G__17574) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__17575 = opts;
var map__17575__$1 = cljs.core.__destructure_map.call(null,map__17575);
var auth = cljs.core.get.call(null,map__17575__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__17575__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4253__auto__ = auth;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsubscribe","unsubscribe",632650147),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null));
});
