// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.query.analytical_parse');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e19241){var e = e19241;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__19242_SHARP_){
var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__19242_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__19242_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__19242_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (((cljs.core.not.call(null,key_as_var)) && (((cljs.core.not_EQ_.call(null,"_id",key)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19243_SHARP_){
return cljs.core.conj.call(null,p1__19243_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19244_SHARP_){
return cljs.core.conj.call(null,p1__19244_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.call(null,idx,(2));
if(and__4251__auto__){
return fluree.db.query.analytical_parse.query_fn_QMARK_.call(null,key);
} else {
return and__4251__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__4253__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__19249 = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__19249,(0),null);
var _ = cljs.core.nth.call(null,vec__19249,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19245_SHARP_){
return cljs.core.conj.call(null,p1__19245_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.call(null,idx,(1));
if(and__4251__auto__){
return cljs.core.re_find.call(null,/\+/,key);
} else {
return and__4251__auto__;
}
})())){
var vec__19252 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__19252,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__19252,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4253__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19246_SHARP_){
return cljs.core.conj.call(null,p1__19246_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19247_SHARP_){
return cljs.core.conj.call(null,p1__19247_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19248_SHARP_){
return cljs.core.conj.call(null,p1__19248_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__19255_SHARP_){
return cljs.core.nth.call(null,array,p1__19255_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (add_amount > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fuel;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__4251__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5802__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__19258,optional_QMARK_,fuel,max_fuel){
var map__19259 = p__19258;
var map__19259__$1 = cljs.core.__destructure_map.call(null,map__19259);
var res = map__19259__$1;
var vars = cljs.core.get.call(null,map__19259__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19325){
var state_val_19326 = (state_19325[(1)]);
if((state_val_19326 === (7))){
var inst_19314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19315 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_19316 = cljs.core.conj.call(null,inst_19315,clause);
var inst_19317 = [null,inst_19316];
var inst_19318 = (new cljs.core.PersistentVector(null,2,(5),inst_19314,inst_19317,null));
var state_19325__$1 = state_19325;
var statearr_19327_19355 = state_19325__$1;
(statearr_19327_19355[(2)] = inst_19318);

(statearr_19327_19355[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19326 === (1))){
var state_19325__$1 = state_19325;
var statearr_19328_19356 = state_19325__$1;
(statearr_19328_19356[(2)] = null);

(statearr_19328_19356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19326 === (4))){
var inst_19260 = (state_19325[(2)]);
var state_19325__$1 = state_19325;
var statearr_19329_19357 = state_19325__$1;
(statearr_19329_19357[(2)] = inst_19260);

(statearr_19329_19357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19326 === (15))){
var inst_19303 = (state_19325[(2)]);
var inst_19304 = fluree.db.util.async.throw_err.call(null,inst_19303);
var inst_19305 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_19304);
var inst_19306 = cljs.core.count.call(null,inst_19305);
var inst_19307 = fluree.db.query.analytical.add_fuel.call(null,inst_19306,fuel,max_fuel);
var inst_19308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19309 = [inst_19304,r];
var inst_19310 = (new cljs.core.PersistentVector(null,2,(5),inst_19308,inst_19309,null));
var state_19325__$1 = (function (){var statearr_19330 = state_19325;
(statearr_19330[(7)] = inst_19307);

return statearr_19330;
})();
var statearr_19331_19358 = state_19325__$1;
(statearr_19331_19358[(2)] = inst_19310);

(statearr_19331_19358[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19326 === (13))){
var inst_19269 = (state_19325[(8)]);
var inst_19282 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_19283 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses.call(null,inst_19282);
var inst_19284 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_19269);
var inst_19285 = cljs.core.apply.call(null,cljs.core.concat,inst_19284);
var inst_19286 = cljs.core.set.call(null,inst_19285);
var inst_19287 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_19283);
var inst_19288 = cljs.core.apply.call(null,cljs.core.concat,inst_19287);
var inst_19289 = cljs.core.into.call(null,inst_19286,inst_19288);
var inst_19290 = (function (){var all_wd = inst_19269;
var optional = inst_19283;
var all_wd_vars = inst_19286;
var all_vars = inst_19289;
return (function (p1__19256_SHARP_){
return all_vars.call(null,p1__19256_SHARP_);
});
})();
var inst_19291 = cljs.core.keys.call(null,vars);
var inst_19292 = cljs.core.map.call(null,inst_19290,inst_19291);
var inst_19293 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_19292);
var inst_19294 = cljs.core.set.call(null,inst_19293);
var inst_19295 = (function (){var all_wd = inst_19269;
var optional = inst_19283;
var all_wd_vars = inst_19286;
var all_vars = inst_19289;
var intersecting_vars = inst_19294;
return (function (p1__19257_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__19257_SHARP_);
});
})();
var inst_19296 = cljs.core.map.call(null,inst_19295,inst_19269);
var inst_19297 = cljs.core.apply.call(null,cljs.core.concat,inst_19296);
var inst_19298 = fluree.db.query.analytical.select_from_tuples.call(null,inst_19297,res);
var inst_19299 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_19269,inst_19294,vars);
var inst_19300 = cljs.core.remove.call(null,inst_19294,inst_19289);
var inst_19301 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_19299,inst_19297,inst_19298,inst_19300,inst_19283);
var state_19325__$1 = state_19325;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19325__$1,(15),inst_19301);
} else {
if((state_val_19326 === (6))){
var inst_19270 = (state_19325[(9)]);
var inst_19268 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_19269 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_19268);
var inst_19270__$1 = optional_QMARK_;
var state_19325__$1 = (function (){var statearr_19332 = state_19325;
(statearr_19332[(8)] = inst_19269);

(statearr_19332[(9)] = inst_19270__$1);

return statearr_19332;
})();
if(cljs.core.truth_(inst_19270__$1)){
var statearr_19333_19359 = state_19325__$1;
(statearr_19333_19359[(1)] = (9));

} else {
var statearr_19334_19360 = state_19325__$1;
(statearr_19334_19360[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19326 === (3))){
var inst_19323 = (state_19325[(2)]);
var state_19325__$1 = state_19325;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19325__$1,inst_19323);
} else {
if((state_val_19326 === (12))){
var inst_19278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19279 = [null,r];
var inst_19280 = (new cljs.core.PersistentVector(null,2,(5),inst_19278,inst_19279,null));
var state_19325__$1 = state_19325;
var statearr_19335_19361 = state_19325__$1;
(statearr_19335_19361[(2)] = inst_19280);

(statearr_19335_19361[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19326 === (2))){
var _ = (function (){var statearr_19336 = state_19325;
(statearr_19336[(4)] = cljs.core.cons.call(null,(5),(state_19325[(4)])));

return statearr_19336;
})();
var inst_19266 = (r == null);
var state_19325__$1 = state_19325;
if(cljs.core.truth_(inst_19266)){
var statearr_19337_19362 = state_19325__$1;
(statearr_19337_19362[(1)] = (6));

} else {
var statearr_19338_19363 = state_19325__$1;
(statearr_19338_19363[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19326 === (11))){
var inst_19276 = (state_19325[(2)]);
var state_19325__$1 = state_19325;
if(cljs.core.truth_(inst_19276)){
var statearr_19340_19364 = state_19325__$1;
(statearr_19340_19364[(1)] = (12));

} else {
var statearr_19341_19365 = state_19325__$1;
(statearr_19341_19365[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19326 === (9))){
var inst_19269 = (state_19325[(8)]);
var inst_19272 = cljs.core.empty_QMARK_.call(null,inst_19269);
var inst_19273 = (!(inst_19272));
var state_19325__$1 = state_19325;
var statearr_19342_19366 = state_19325__$1;
(statearr_19342_19366[(2)] = inst_19273);

(statearr_19342_19366[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19326 === (5))){
var _ = (function (){var statearr_19343 = state_19325;
(statearr_19343[(4)] = cljs.core.rest.call(null,(state_19325[(4)])));

return statearr_19343;
})();
var state_19325__$1 = state_19325;
var ex19339 = (state_19325__$1[(2)]);
var statearr_19344_19367 = state_19325__$1;
(statearr_19344_19367[(5)] = ex19339);


if((ex19339 instanceof Error)){
var statearr_19345_19368 = state_19325__$1;
(statearr_19345_19368[(1)] = (4));

(statearr_19345_19368[(5)] = null);

} else {
throw ex19339;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19326 === (14))){
var inst_19312 = (state_19325[(2)]);
var state_19325__$1 = state_19325;
var statearr_19346_19369 = state_19325__$1;
(statearr_19346_19369[(2)] = inst_19312);

(statearr_19346_19369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19326 === (10))){
var inst_19270 = (state_19325[(9)]);
var state_19325__$1 = state_19325;
var statearr_19347_19370 = state_19325__$1;
(statearr_19347_19370[(2)] = inst_19270);

(statearr_19347_19370[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19326 === (8))){
var inst_19320 = (state_19325[(2)]);
var _ = (function (){var statearr_19348 = state_19325;
(statearr_19348[(4)] = cljs.core.rest.call(null,(state_19325[(4)])));

return statearr_19348;
})();
var state_19325__$1 = state_19325;
var statearr_19349_19371 = state_19325__$1;
(statearr_19349_19371[(2)] = inst_19320);

(statearr_19349_19371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_19350 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19350[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__);

(statearr_19350[(1)] = (1));

return statearr_19350;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1 = (function (state_19325){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19351){var ex__2749__auto__ = e19351;
var statearr_19352_19372 = state_19325;
(statearr_19352_19372[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19325[(4)]))){
var statearr_19353_19373 = state_19325;
(statearr_19353_19373[(1)] = cljs.core.first.call(null,(state_19325[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19374 = state_19325;
state_19325 = G__19374;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__ = function(state_19325){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1.call(this,state_19325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19354 = f__2769__auto__.call(null);
(statearr_19354[(6)] = c__2768__auto__);

return statearr_19354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(ledger_id){
return cljs.core.re_find.call(null,/[a-z]+/,ledger_id);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(ledger_id){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,ledger_id);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__19376 = arguments.length;
switch (G__19376) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19470){
var state_val_19471 = (state_19470[(1)]);
if((state_val_19471 === (7))){
var inst_19383 = (state_19470[(7)]);
var inst_19393 = clojure.string.starts_with_QMARK_.call(null,inst_19383,"$fdb");
var state_19470__$1 = state_19470;
if(inst_19393){
var statearr_19472_19521 = state_19470__$1;
(statearr_19472_19521[(1)] = (9));

} else {
var statearr_19473_19522 = state_19470__$1;
(statearr_19473_19522[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (20))){
var state_19470__$1 = state_19470;
var statearr_19474_19523 = state_19470__$1;
(statearr_19474_19523[(2)] = null);

(statearr_19474_19523[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (27))){
var inst_19433 = (state_19470[(8)]);
var state_19470__$1 = state_19470;
var statearr_19475_19524 = state_19470__$1;
(statearr_19475_19524[(2)] = inst_19433);

(statearr_19475_19524[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (1))){
var state_19470__$1 = state_19470;
var statearr_19476_19525 = state_19470__$1;
(statearr_19476_19525[(2)] = null);

(statearr_19476_19525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (24))){
var inst_19456 = (state_19470[(2)]);
var state_19470__$1 = state_19470;
var statearr_19477_19526 = state_19470__$1;
(statearr_19477_19526[(2)] = inst_19456);

(statearr_19477_19526[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (4))){
var inst_19377 = (state_19470[(2)]);
var state_19470__$1 = state_19470;
var statearr_19478_19527 = state_19470__$1;
(statearr_19478_19527[(2)] = inst_19377);

(statearr_19478_19527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (15))){
var inst_19400 = (state_19470[(9)]);
var inst_19406 = (state_19470[(2)]);
var inst_19407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19408 = cljs.core.PersistentVector.EMPTY;
var inst_19409 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_19410 = cljs.core.into.call(null,inst_19408,inst_19409);
var inst_19411 = [inst_19400,inst_19410];
var inst_19412 = (new cljs.core.PersistentVector(null,2,(5),inst_19407,inst_19411,null));
var state_19470__$1 = (function (){var statearr_19479 = state_19470;
(statearr_19479[(10)] = inst_19406);

return statearr_19479;
})();
var statearr_19480_19528 = state_19470__$1;
(statearr_19480_19528[(2)] = inst_19412);

(statearr_19480_19528[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (21))){
var inst_19459 = (state_19470[(2)]);
var state_19470__$1 = state_19470;
var statearr_19481_19529 = state_19470__$1;
(statearr_19481_19529[(2)] = inst_19459);

(statearr_19481_19529[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (13))){
var inst_19400 = (state_19470[(9)]);
var inst_19403 = (function(){throw inst_19400})();
var state_19470__$1 = state_19470;
var statearr_19482_19530 = state_19470__$1;
(statearr_19482_19530[(2)] = inst_19403);

(statearr_19482_19530[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (22))){
var inst_19424 = (state_19470[(11)]);
var inst_19422 = (state_19470[(12)]);
var inst_19426 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_19422);
var inst_19427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19428 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_19424];
var inst_19429 = (new cljs.core.PersistentVector(null,2,(5),inst_19427,inst_19428,null));
var inst_19430 = cljs.core.get_in.call(null,opts,inst_19429);
var state_19470__$1 = (function (){var statearr_19483 = state_19470;
(statearr_19483[(13)] = inst_19426);

return statearr_19483;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19470__$1,(25),inst_19430);
} else {
if((state_val_19471 === (29))){
var inst_19437 = (state_19470[(2)]);
var inst_19438 = fluree.db.util.async.throw_err.call(null,inst_19437);
var state_19470__$1 = state_19470;
var statearr_19484_19531 = state_19470__$1;
(statearr_19484_19531[(2)] = inst_19438);

(statearr_19484_19531[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (6))){
var inst_19386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19387 = cljs.core.PersistentVector.EMPTY;
var inst_19388 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_19389 = cljs.core.into.call(null,inst_19387,inst_19388);
var inst_19390 = [db,inst_19389];
var inst_19391 = (new cljs.core.PersistentVector(null,2,(5),inst_19386,inst_19390,null));
var state_19470__$1 = state_19470;
var statearr_19485_19532 = state_19470__$1;
(statearr_19485_19532[(2)] = inst_19391);

(statearr_19485_19532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (28))){
var inst_19441 = (state_19470[(2)]);
var inst_19442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19443 = cljs.core.PersistentVector.EMPTY;
var inst_19444 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_19445 = cljs.core.into.call(null,inst_19443,inst_19444);
var inst_19446 = [inst_19441,inst_19445];
var inst_19447 = (new cljs.core.PersistentVector(null,2,(5),inst_19442,inst_19446,null));
var state_19470__$1 = state_19470;
var statearr_19486_19533 = state_19470__$1;
(statearr_19486_19533[(2)] = inst_19447);

(statearr_19486_19533[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (25))){
var inst_19426 = (state_19470[(13)]);
var inst_19432 = (state_19470[(2)]);
var inst_19433 = fluree.db.util.async.throw_err.call(null,inst_19432);
var state_19470__$1 = (function (){var statearr_19487 = state_19470;
(statearr_19487[(8)] = inst_19433);

return statearr_19487;
})();
if(cljs.core.truth_(inst_19426)){
var statearr_19488_19534 = state_19470__$1;
(statearr_19488_19534[(1)] = (26));

} else {
var statearr_19489_19535 = state_19470__$1;
(statearr_19489_19535[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (17))){
var state_19470__$1 = state_19470;
var statearr_19490_19536 = state_19470__$1;
(statearr_19490_19536[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (3))){
var inst_19468 = (state_19470[(2)]);
var state_19470__$1 = state_19470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19470__$1,inst_19468);
} else {
if((state_val_19471 === (12))){
var inst_19400 = (state_19470[(9)]);
var inst_19399 = (state_19470[(2)]);
var inst_19400__$1 = fluree.db.util.async.throw_err.call(null,inst_19399);
var inst_19401 = fluree.db.util.core.exception_QMARK_.call(null,inst_19400__$1);
var state_19470__$1 = (function (){var statearr_19492 = state_19470;
(statearr_19492[(9)] = inst_19400__$1);

return statearr_19492;
})();
if(inst_19401){
var statearr_19493_19537 = state_19470__$1;
(statearr_19493_19537[(1)] = (13));

} else {
var statearr_19494_19538 = state_19470__$1;
(statearr_19494_19538[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (2))){
var inst_19383 = (state_19470[(7)]);
var _ = (function (){var statearr_19495 = state_19470;
(statearr_19495[(4)] = cljs.core.cons.call(null,(5),(state_19470[(4)])));

return statearr_19495;
})();
var inst_19383__$1 = cljs.core.first.call(null,clause);
var inst_19384 = cljs.core._EQ_.call(null,"$fdb",inst_19383__$1);
var state_19470__$1 = (function (){var statearr_19496 = state_19470;
(statearr_19496[(7)] = inst_19383__$1);

return statearr_19496;
})();
if(inst_19384){
var statearr_19497_19539 = state_19470__$1;
(statearr_19497_19539[(1)] = (6));

} else {
var statearr_19498_19540 = state_19470__$1;
(statearr_19498_19540[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (23))){
var inst_19383 = (state_19470[(7)]);
var inst_19449 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19383)," is not supported in Fluree"].join('');
var inst_19450 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19451 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19452 = cljs.core.PersistentHashMap.fromArrays(inst_19450,inst_19451);
var inst_19453 = cljs.core.ex_info.call(null,inst_19449,inst_19452);
var inst_19454 = (function(){throw inst_19453})();
var state_19470__$1 = state_19470;
var statearr_19499_19541 = state_19470__$1;
(statearr_19499_19541[(2)] = inst_19454);

(statearr_19499_19541[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (19))){
var inst_19424 = (state_19470[(11)]);
var inst_19383 = (state_19470[(7)]);
var inst_19421 = fluree.db.query.analytical.isolate_source_name.call(null,inst_19383);
var inst_19422 = fluree.db.query.analytical.isolate_source_block.call(null,inst_19383);
var inst_19423 = cljs.core.keyword.call(null,inst_19421);
var inst_19424__$1 = cljs.core.get.call(null,prefixes,inst_19423);
var state_19470__$1 = (function (){var statearr_19500 = state_19470;
(statearr_19500[(11)] = inst_19424__$1);

(statearr_19500[(12)] = inst_19422);

return statearr_19500;
})();
if(cljs.core.truth_(inst_19424__$1)){
var statearr_19501_19542 = state_19470__$1;
(statearr_19501_19542[(1)] = (22));

} else {
var statearr_19502_19543 = state_19470__$1;
(statearr_19502_19543[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (11))){
var inst_19463 = (state_19470[(2)]);
var state_19470__$1 = state_19470;
var statearr_19504_19544 = state_19470__$1;
(statearr_19504_19544[(2)] = inst_19463);

(statearr_19504_19544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (9))){
var inst_19383 = (state_19470[(7)]);
var inst_19395 = cljs.core.subs.call(null,inst_19383,(4));
var inst_19396 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_19395);
var inst_19397 = fluree.db.time_travel.as_of_block.call(null,db,inst_19396);
var state_19470__$1 = state_19470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19470__$1,(12),inst_19397);
} else {
if((state_val_19471 === (5))){
var _ = (function (){var statearr_19505 = state_19470;
(statearr_19505[(4)] = cljs.core.rest.call(null,(state_19470[(4)])));

return statearr_19505;
})();
var state_19470__$1 = state_19470;
var ex19503 = (state_19470__$1[(2)]);
var statearr_19506_19545 = state_19470__$1;
(statearr_19506_19545[(5)] = ex19503);


if((ex19503 instanceof Error)){
var statearr_19507_19546 = state_19470__$1;
(statearr_19507_19546[(1)] = (4));

(statearr_19507_19546[(5)] = null);

} else {
throw ex19503;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (14))){
var state_19470__$1 = state_19470;
var statearr_19508_19547 = state_19470__$1;
(statearr_19508_19547[(2)] = null);

(statearr_19508_19547[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (26))){
var inst_19426 = (state_19470[(13)]);
var inst_19433 = (state_19470[(8)]);
var inst_19435 = fluree.db.time_travel.as_of_block.call(null,inst_19433,inst_19426);
var state_19470__$1 = state_19470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19470__$1,(29),inst_19435);
} else {
if((state_val_19471 === (16))){
var inst_19416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19417 = ["$wd",clause];
var inst_19418 = (new cljs.core.PersistentVector(null,2,(5),inst_19416,inst_19417,null));
var state_19470__$1 = state_19470;
var statearr_19509_19548 = state_19470__$1;
(statearr_19509_19548[(2)] = inst_19418);

(statearr_19509_19548[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (10))){
var inst_19383 = (state_19470[(7)]);
var inst_19414 = cljs.core._EQ_.call(null,"$wd",inst_19383);
var state_19470__$1 = state_19470;
if(inst_19414){
var statearr_19510_19549 = state_19470__$1;
(statearr_19510_19549[(1)] = (16));

} else {
var statearr_19511_19550 = state_19470__$1;
(statearr_19511_19550[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (18))){
var inst_19461 = (state_19470[(2)]);
var state_19470__$1 = state_19470;
var statearr_19512_19551 = state_19470__$1;
(statearr_19512_19551[(2)] = inst_19461);

(statearr_19512_19551[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (8))){
var inst_19465 = (state_19470[(2)]);
var _ = (function (){var statearr_19513 = state_19470;
(statearr_19513[(4)] = cljs.core.rest.call(null,(state_19470[(4)])));

return statearr_19513;
})();
var state_19470__$1 = state_19470;
var statearr_19514_19552 = state_19470__$1;
(statearr_19514_19552[(2)] = inst_19465);

(statearr_19514_19552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2746__auto__ = null;
var fluree$db$query$analytical$state_machine__2746__auto____0 = (function (){
var statearr_19515 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19515[(0)] = fluree$db$query$analytical$state_machine__2746__auto__);

(statearr_19515[(1)] = (1));

return statearr_19515;
});
var fluree$db$query$analytical$state_machine__2746__auto____1 = (function (state_19470){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19516){var ex__2749__auto__ = e19516;
var statearr_19517_19553 = state_19470;
(statearr_19517_19553[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19470[(4)]))){
var statearr_19518_19554 = state_19470;
(statearr_19518_19554[(1)] = cljs.core.first.call(null,(state_19470[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19555 = state_19470;
state_19470 = G__19555;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2746__auto__ = function(state_19470){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2746__auto____1.call(this,state_19470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2746__auto____0;
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2746__auto____1;
return fluree$db$query$analytical$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19519 = f__2769__auto__.call(null);
(statearr_19519[(6)] = c__2768__auto__);

return statearr_19519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__19556){
var vec__19557 = p__19556;
var sub = cljs.core.nth.call(null,vec__19557,(0),null);
var obj = cljs.core.nth.call(null,vec__19557,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__19560_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__19560_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__19564 = subjects;
var vec__19565 = G__19564;
var seq__19566 = cljs.core.seq.call(null,vec__19565);
var first__19567 = cljs.core.first.call(null,seq__19566);
var seq__19566__$1 = cljs.core.next.call(null,seq__19566);
var subject = first__19567;
var r = seq__19566__$1;
var acc = expanded_map;
var G__19564__$1 = G__19564;
var acc__$1 = acc;
while(true){
var vec__19571 = G__19564__$1;
var seq__19572 = cljs.core.seq.call(null,vec__19571);
var first__19573 = cljs.core.first.call(null,seq__19572);
var seq__19572__$1 = cljs.core.next.call(null,seq__19572);
var subject__$1 = first__19573;
var r__$1 = seq__19572__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__19574 = r__$1;
var G__19575 = acc__$2;
G__19564__$1 = G__19574;
acc__$1 = G__19575;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__19564__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__19571,seq__19572,first__19573,seq__19572__$1,subject__$1,r__$1,acc__$2,G__19564,vec__19565,seq__19566,first__19567,seq__19566__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4253__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__19564__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19571,seq__19572,first__19573,seq__19572__$1,subject__$1,r__$1,acc__$2,G__19564,vec__19565,seq__19566,first__19567,seq__19566__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__19564__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19571,seq__19572,first__19573,seq__19572__$1,subject__$1,r__$1,acc__$2,G__19564,vec__19565,seq__19566,first__19567,seq__19566__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__19564__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19571,seq__19572,first__19573,seq__19572__$1,subject__$1,r__$1,acc__$2,G__19564,vec__19565,seq__19566,first__19567,seq__19566__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__19564__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19571,seq__19572,first__19573,seq__19572__$1,subject__$1,r__$1,acc__$2,G__19564,vec__19565,seq__19566,first__19567,seq__19566__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__19564__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__19571,seq__19572,first__19573,seq__19572__$1,subject__$1,r__$1,acc__$2,G__19564,vec__19565,seq__19566,first__19567,seq__19566__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__19576 = r__$1;
var G__19577 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__19564__$1 = G__19576;
acc__$1 = G__19577;
continue;
} else {
var G__19578 = subjects;
var G__19579 = acc_STAR_;
G__19564__$1 = G__19578;
acc__$1 = G__19579;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__19580_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__19580_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19671){
var state_val_19672 = (state_19671[(1)]);
if((state_val_19672 === (7))){
var state_19671__$1 = state_19671;
var statearr_19673_19719 = state_19671__$1;
(statearr_19673_19719[(2)] = (100));

(statearr_19673_19719[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (20))){
var inst_19620 = (state_19671[(7)]);
var state_19671__$1 = state_19671;
var statearr_19674_19720 = state_19671__$1;
(statearr_19674_19720[(2)] = inst_19620);

(statearr_19674_19720[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (1))){
var state_19671__$1 = state_19671;
var statearr_19675_19721 = state_19671__$1;
(statearr_19675_19721[(2)] = null);

(statearr_19675_19721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (24))){
var inst_19659 = (state_19671[(8)]);
var inst_19657 = (state_19671[(9)]);
var inst_19592 = (state_19671[(10)]);
var inst_19658 = (state_19671[(11)]);
var inst_19662 = (function (){var max_depth = inst_19592;
var recur_map__$1 = inst_19658;
var subjects = inst_19657;
var tuples = inst_19659;
return (function (p1__19581_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__19581_SHARP_)],null));
});
})();
var inst_19663 = cljs.core.map.call(null,inst_19662,inst_19659);
var inst_19664 = cljs.core.distinct.call(null,inst_19663);
var state_19671__$1 = state_19671;
var statearr_19676_19722 = state_19671__$1;
(statearr_19676_19722[(2)] = inst_19664);

(statearr_19676_19722[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (4))){
var inst_19582 = (state_19671[(2)]);
var state_19671__$1 = state_19671;
var statearr_19677_19723 = state_19671__$1;
(statearr_19677_19723[(2)] = inst_19582);

(statearr_19677_19723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (15))){
var inst_19605 = (state_19671[(12)]);
var inst_19616 = cljs.core.PersistentVector.EMPTY;
var inst_19617 = cljs.core.seq.call(null,inst_19605);
var inst_19618 = cljs.core.first.call(null,inst_19617);
var inst_19619 = cljs.core.next.call(null,inst_19617);
var inst_19620 = inst_19616;
var inst_19621 = inst_19605;
var state_19671__$1 = (function (){var statearr_19678 = state_19671;
(statearr_19678[(13)] = inst_19621);

(statearr_19678[(7)] = inst_19620);

(statearr_19678[(14)] = inst_19619);

(statearr_19678[(15)] = inst_19618);

return statearr_19678;
})();
var statearr_19679_19724 = state_19671__$1;
(statearr_19679_19724[(2)] = null);

(statearr_19679_19724[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (21))){
var inst_19641 = (state_19671[(2)]);
var state_19671__$1 = state_19671;
var statearr_19680_19725 = state_19671__$1;
(statearr_19680_19725[(2)] = inst_19641);

(statearr_19680_19725[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (13))){
var inst_19654 = (state_19671[(2)]);
var state_19671__$1 = state_19671;
var statearr_19681_19726 = state_19671__$1;
(statearr_19681_19726[(2)] = inst_19654);

(statearr_19681_19726[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (22))){
var inst_19620 = (state_19671[(7)]);
var inst_19628 = (state_19671[(16)]);
var inst_19635 = (state_19671[(2)]);
var inst_19636 = fluree.db.util.async.throw_err.call(null,inst_19635);
var inst_19637 = cljs.core.concat.call(null,inst_19620,inst_19636);
var inst_19620__$1 = inst_19637;
var inst_19621 = inst_19628;
var state_19671__$1 = (function (){var statearr_19682 = state_19671;
(statearr_19682[(13)] = inst_19621);

(statearr_19682[(7)] = inst_19620__$1);

return statearr_19682;
})();
var statearr_19683_19727 = state_19671__$1;
(statearr_19683_19727[(2)] = null);

(statearr_19683_19727[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (6))){
var inst_19588 = (state_19671[(17)]);
var state_19671__$1 = state_19671;
var statearr_19684_19728 = state_19671__$1;
(statearr_19684_19728[(2)] = inst_19588);

(statearr_19684_19728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (25))){
var inst_19666 = (state_19671[(2)]);
var _ = (function (){var statearr_19685 = state_19671;
(statearr_19685[(4)] = cljs.core.rest.call(null,(state_19671[(4)])));

return statearr_19685;
})();
var state_19671__$1 = state_19671;
var statearr_19686_19729 = state_19671__$1;
(statearr_19686_19729[(2)] = inst_19666);

(statearr_19686_19729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (17))){
var inst_19621 = (state_19671[(13)]);
var inst_19627 = (state_19671[(18)]);
var inst_19626 = cljs.core.seq.call(null,inst_19621);
var inst_19627__$1 = cljs.core.first.call(null,inst_19626);
var inst_19628 = cljs.core.next.call(null,inst_19626);
var state_19671__$1 = (function (){var statearr_19687 = state_19671;
(statearr_19687[(16)] = inst_19628);

(statearr_19687[(18)] = inst_19627__$1);

return statearr_19687;
})();
if(cljs.core.truth_(inst_19627__$1)){
var statearr_19688_19730 = state_19671__$1;
(statearr_19688_19730[(1)] = (19));

} else {
var statearr_19689_19731 = state_19671__$1;
(statearr_19689_19731[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (3))){
var inst_19669 = (state_19671[(2)]);
var state_19671__$1 = state_19671;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19671__$1,inst_19669);
} else {
if((state_val_19672 === (12))){
var inst_19594 = (state_19671[(19)]);
var inst_19605 = (state_19671[(12)]);
var inst_19600 = cljs.core.vals.call(null,inst_19594);
var inst_19601 = cljs.core.flatten.call(null,inst_19600);
var inst_19602 = cljs.core.set.call(null,inst_19601);
var inst_19603 = cljs.core.keys.call(null,inst_19594);
var inst_19604 = cljs.core.set.call(null,inst_19603);
var inst_19605__$1 = clojure.set.difference.call(null,inst_19602,inst_19604);
var inst_19606 = cljs.core.empty_QMARK_.call(null,inst_19605__$1);
var state_19671__$1 = (function (){var statearr_19690 = state_19671;
(statearr_19690[(12)] = inst_19605__$1);

return statearr_19690;
})();
if(inst_19606){
var statearr_19691_19732 = state_19671__$1;
(statearr_19691_19732[(1)] = (14));

} else {
var statearr_19692_19733 = state_19671__$1;
(statearr_19692_19733[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (2))){
var inst_19588 = (state_19671[(17)]);
var _ = (function (){var statearr_19693 = state_19671;
(statearr_19693[(4)] = cljs.core.cons.call(null,(5),(state_19671[(4)])));

return statearr_19693;
})();
var inst_19588__$1 = depth;
var state_19671__$1 = (function (){var statearr_19694 = state_19671;
(statearr_19694[(17)] = inst_19588__$1);

return statearr_19694;
})();
if(cljs.core.truth_(inst_19588__$1)){
var statearr_19695_19734 = state_19671__$1;
(statearr_19695_19734[(1)] = (6));

} else {
var statearr_19696_19735 = state_19671__$1;
(statearr_19696_19735[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (23))){
var inst_19659 = (state_19671[(8)]);
var state_19671__$1 = state_19671;
var statearr_19697_19736 = state_19671__$1;
(statearr_19697_19736[(2)] = inst_19659);

(statearr_19697_19736[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (19))){
var inst_19627 = (state_19671[(18)]);
var inst_19630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19631 = [inst_19627,predicate];
var inst_19632 = (new cljs.core.PersistentVector(null,2,(5),inst_19630,inst_19631,null));
var inst_19633 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_19632);
var state_19671__$1 = state_19671;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19671__$1,(22),inst_19633);
} else {
if((state_val_19672 === (11))){
var inst_19594 = (state_19671[(19)]);
var state_19671__$1 = state_19671;
var statearr_19699_19737 = state_19671__$1;
(statearr_19699_19737[(2)] = inst_19594);

(statearr_19699_19737[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (9))){
var inst_19592 = (state_19671[(10)]);
var inst_19595 = (state_19671[(20)]);
var inst_19597 = (inst_19595 >= inst_19592);
var state_19671__$1 = state_19671;
if(cljs.core.truth_(inst_19597)){
var statearr_19700_19738 = state_19671__$1;
(statearr_19700_19738[(1)] = (11));

} else {
var statearr_19701_19739 = state_19671__$1;
(statearr_19701_19739[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (5))){
var _ = (function (){var statearr_19702 = state_19671;
(statearr_19702[(4)] = cljs.core.rest.call(null,(state_19671[(4)])));

return statearr_19702;
})();
var state_19671__$1 = state_19671;
var ex19698 = (state_19671__$1[(2)]);
var statearr_19703_19740 = state_19671__$1;
(statearr_19703_19740[(5)] = ex19698);


if((ex19698 instanceof Error)){
var statearr_19704_19741 = state_19671__$1;
(statearr_19704_19741[(1)] = (4));

(statearr_19704_19741[(5)] = null);

} else {
throw ex19698;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (14))){
var inst_19594 = (state_19671[(19)]);
var state_19671__$1 = state_19671;
var statearr_19705_19742 = state_19671__$1;
(statearr_19705_19742[(2)] = inst_19594);

(statearr_19705_19742[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (16))){
var inst_19652 = (state_19671[(2)]);
var state_19671__$1 = state_19671;
var statearr_19706_19743 = state_19671__$1;
(statearr_19706_19743[(2)] = inst_19652);

(statearr_19706_19743[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (10))){
var inst_19657 = (state_19671[(9)]);
var inst_19658 = (state_19671[(11)]);
var inst_19656 = (state_19671[(2)]);
var inst_19657__$1 = cljs.core.keys.call(null,inst_19656);
var inst_19658__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_19657__$1,inst_19656);
var inst_19659 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_19657__$1,inst_19658__$1);
var state_19671__$1 = (function (){var statearr_19707 = state_19671;
(statearr_19707[(8)] = inst_19659);

(statearr_19707[(9)] = inst_19657__$1);

(statearr_19707[(11)] = inst_19658__$1);

return statearr_19707;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_19708_19744 = state_19671__$1;
(statearr_19708_19744[(1)] = (23));

} else {
var statearr_19709_19745 = state_19671__$1;
(statearr_19709_19745[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (18))){
var inst_19594 = (state_19671[(19)]);
var inst_19595 = (state_19671[(20)]);
var inst_19643 = (state_19671[(2)]);
var inst_19644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19645 = [(0),(2)];
var inst_19646 = (new cljs.core.PersistentVector(null,2,(5),inst_19644,inst_19645,null));
var inst_19647 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_19646,inst_19643);
var inst_19648 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_19594,inst_19647);
var inst_19649 = (inst_19595 + (1));
var inst_19594__$1 = inst_19648;
var inst_19595__$1 = inst_19649;
var state_19671__$1 = (function (){var statearr_19710 = state_19671;
(statearr_19710[(19)] = inst_19594__$1);

(statearr_19710[(20)] = inst_19595__$1);

return statearr_19710;
})();
var statearr_19711_19746 = state_19671__$1;
(statearr_19711_19746[(2)] = null);

(statearr_19711_19746[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19672 === (8))){
var inst_19592 = (state_19671[(2)]);
var inst_19593 = recur_map;
var inst_19594 = inst_19593;
var inst_19595 = (1);
var state_19671__$1 = (function (){var statearr_19712 = state_19671;
(statearr_19712[(10)] = inst_19592);

(statearr_19712[(19)] = inst_19594);

(statearr_19712[(20)] = inst_19595);

return statearr_19712;
})();
var statearr_19713_19747 = state_19671__$1;
(statearr_19713_19747[(2)] = null);

(statearr_19713_19747[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0 = (function (){
var statearr_19714 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19714[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__);

(statearr_19714[(1)] = (1));

return statearr_19714;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1 = (function (state_19671){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19671);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19715){var ex__2749__auto__ = e19715;
var statearr_19716_19748 = state_19671;
(statearr_19716_19748[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19671[(4)]))){
var statearr_19717_19749 = state_19671;
(statearr_19717_19749[(1)] = cljs.core.first.call(null,(state_19671[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19750 = state_19671;
state_19671 = G__19750;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__ = function(state_19671){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1.call(this,state_19671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19718 = f__2769__auto__.call(null);
(statearr_19718[(6)] = c__2768__auto__);

return statearr_19718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__19751,clause,fuel,max_fuel){
var map__19752 = p__19751;
var map__19752__$1 = cljs.core.__destructure_map.call(null,map__19752);
var res = map__19752__$1;
var headers = cljs.core.get.call(null,map__19752__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__19752__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__19752__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19863){
var state_val_19864 = (state_19863[(1)]);
if((state_val_19864 === (7))){
var inst_19769 = (state_19863[(7)]);
var state_19863__$1 = state_19863;
var statearr_19865_19918 = state_19863__$1;
(statearr_19865_19918[(2)] = inst_19769);

(statearr_19865_19918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (20))){
var inst_19797 = (state_19863[(8)]);
var inst_19828 = typeof inst_19797 === 'number';
var state_19863__$1 = state_19863;
if(cljs.core.truth_(inst_19828)){
var statearr_19866_19919 = state_19863__$1;
(statearr_19866_19919[(1)] = (22));

} else {
var statearr_19867_19920 = state_19863__$1;
(statearr_19867_19920[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (27))){
var inst_19843 = (state_19863[(2)]);
var state_19863__$1 = state_19863;
var statearr_19868_19921 = state_19863__$1;
(statearr_19868_19921[(2)] = inst_19843);

(statearr_19868_19921[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (1))){
var state_19863__$1 = state_19863;
var statearr_19869_19922 = state_19863__$1;
(statearr_19869_19922[(2)] = null);

(statearr_19869_19922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (24))){
var inst_19845 = (state_19863[(2)]);
var state_19863__$1 = state_19863;
var statearr_19870_19923 = state_19863__$1;
(statearr_19870_19923[(2)] = inst_19845);

(statearr_19870_19923[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (4))){
var inst_19753 = (state_19863[(2)]);
var state_19863__$1 = state_19863;
var statearr_19871_19924 = state_19863__$1;
(statearr_19871_19924[(2)] = inst_19753);

(statearr_19871_19924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (15))){
var inst_19811 = (state_19863[(2)]);
var inst_19812 = cljs.core.nth.call(null,clause,(2));
var inst_19813 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_19812);
var state_19863__$1 = (function (){var statearr_19872 = state_19863;
(statearr_19872[(9)] = inst_19811);

return statearr_19872;
})();
if(cljs.core.truth_(inst_19813)){
var statearr_19873_19925 = state_19863__$1;
(statearr_19873_19925[(1)] = (16));

} else {
var statearr_19874_19926 = state_19863__$1;
(statearr_19874_19926[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (21))){
var inst_19799 = (state_19863[(10)]);
var inst_19800 = (state_19863[(11)]);
var inst_19770 = (state_19863[(12)]);
var inst_19847 = (state_19863[(2)]);
var inst_19848 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_19800,inst_19847,inst_19770,inst_19799);
var state_19863__$1 = state_19863;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19863__$1,(28),inst_19848);
} else {
if((state_val_19864 === (13))){
var inst_19779 = (state_19863[(13)]);
var inst_19803 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19779)].join('');
var inst_19804 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19805 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19806 = cljs.core.PersistentHashMap.fromArrays(inst_19804,inst_19805);
var inst_19807 = cljs.core.ex_info.call(null,inst_19803,inst_19806);
var inst_19808 = (function(){throw inst_19807})();
var state_19863__$1 = state_19863;
var statearr_19875_19927 = state_19863__$1;
(statearr_19875_19927[(2)] = inst_19808);

(statearr_19875_19927[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (22))){
var inst_19795 = (state_19863[(14)]);
var inst_19797 = (state_19863[(8)]);
var inst_19830 = cljs.core.PersistentHashMap.EMPTY;
var inst_19831 = cljs.core.flatten.call(null,inst_19795);
var inst_19832 = cljs.core.assoc.call(null,inst_19830,inst_19797,inst_19831);
var state_19863__$1 = state_19863;
var statearr_19876_19928 = state_19863__$1;
(statearr_19876_19928[(2)] = inst_19832);

(statearr_19876_19928[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (6))){
var inst_19781 = (state_19863[(15)]);
var state_19863__$1 = state_19863;
var statearr_19877_19929 = state_19863__$1;
(statearr_19877_19929[(2)] = inst_19781);

(statearr_19877_19929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (28))){
var inst_19850 = (state_19863[(2)]);
var inst_19851 = fluree.db.util.async.throw_err.call(null,inst_19850);
var state_19863__$1 = state_19863;
var statearr_19878_19930 = state_19863__$1;
(statearr_19878_19930[(2)] = inst_19851);

(statearr_19878_19930[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (25))){
var inst_19795 = (state_19863[(14)]);
var inst_19791 = (state_19863[(16)]);
var inst_19836 = cljs.core.PersistentHashMap.EMPTY;
var inst_19837 = cljs.core.first.call(null,inst_19791);
var inst_19838 = cljs.core.first.call(null,inst_19837);
var inst_19839 = cljs.core.flatten.call(null,inst_19795);
var inst_19840 = cljs.core.assoc.call(null,inst_19836,inst_19838,inst_19839);
var state_19863__$1 = state_19863;
var statearr_19879_19931 = state_19863__$1;
(statearr_19879_19931[(2)] = inst_19840);

(statearr_19879_19931[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (17))){
var inst_19779 = (state_19863[(13)]);
var inst_19816 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19779)].join('');
var inst_19817 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19818 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19819 = cljs.core.PersistentHashMap.fromArrays(inst_19817,inst_19818);
var inst_19820 = cljs.core.ex_info.call(null,inst_19816,inst_19819);
var inst_19821 = (function(){throw inst_19820})();
var state_19863__$1 = state_19863;
var statearr_19880_19932 = state_19863__$1;
(statearr_19880_19932[(2)] = inst_19821);

(statearr_19880_19932[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (3))){
var inst_19861 = (state_19863[(2)]);
var state_19863__$1 = state_19863;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19863__$1,inst_19861);
} else {
if((state_val_19864 === (12))){
var inst_19766 = (state_19863[(17)]);
var inst_19854 = (state_19863[(2)]);
var inst_19855 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_19856 = cljs.core.keys.call(null,inst_19766);
var inst_19857 = [inst_19856,vars,inst_19854];
var inst_19858 = cljs.core.PersistentHashMap.fromArrays(inst_19855,inst_19857);
var _ = (function (){var statearr_19881 = state_19863;
(statearr_19881[(4)] = cljs.core.rest.call(null,(state_19863[(4)])));

return statearr_19881;
})();
var state_19863__$1 = state_19863;
var statearr_19882_19933 = state_19863__$1;
(statearr_19882_19933[(2)] = inst_19858);

(statearr_19882_19933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (2))){
var inst_19766 = (state_19863[(17)]);
var inst_19781 = (state_19863[(15)]);
var inst_19769 = (state_19863[(7)]);
var inst_19770 = (state_19863[(12)]);
var _ = (function (){var statearr_19883 = state_19863;
(statearr_19883[(4)] = cljs.core.cons.call(null,(5),(state_19863[(4)])));

return statearr_19883;
})();
var inst_19763 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_19764 = cljs.core.__destructure_map.call(null,inst_19763);
var inst_19765 = cljs.core.get.call(null,inst_19764,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_19766__$1 = cljs.core.get.call(null,inst_19764,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_19767 = cljs.core.get.call(null,inst_19764,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_19768 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_19769__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_19767);
var inst_19770__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_19767);
var inst_19772 = (function (){var map__19759 = inst_19764;
var search = inst_19765;
var rel = inst_19766__$1;
var opts = inst_19767;
var common_keys = inst_19768;
var object_fn = inst_19769__$1;
var recur_depth = inst_19770__$1;
return (function (p__19771,common_key){
var vec__19884 = p__19771;
var acc = cljs.core.nth.call(null,vec__19884,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__19884,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__19887 = cljs.core._EQ_;
var expr__19888 = idx_of;
if(cljs.core.truth_(pred__19887.call(null,(0),expr__19888))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__19887.call(null,(1),expr__19888))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__19887.call(null,(2),expr__19888))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__19888)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((function (){var and__4251__auto__ = (!(single_v_QMARK_));
if(and__4251__auto__){
var and__4251__auto____$1 = object_fn;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_19773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19774 = cljs.core.PersistentHashMap.EMPTY;
var inst_19775 = [inst_19774,inst_19765];
var inst_19776 = (new cljs.core.PersistentVector(null,2,(5),inst_19773,inst_19775,null));
var inst_19777 = cljs.core.reduce.call(null,inst_19772,inst_19776,inst_19768);
var inst_19778 = cljs.core.nth.call(null,inst_19777,(0),null);
var inst_19779 = cljs.core.nth.call(null,inst_19777,(1),null);
var inst_19780 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_19781__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_19778);
var state_19863__$1 = (function (){var statearr_19890 = state_19863;
(statearr_19890[(13)] = inst_19779);

(statearr_19890[(17)] = inst_19766__$1);

(statearr_19890[(18)] = inst_19780);

(statearr_19890[(15)] = inst_19781__$1);

(statearr_19890[(7)] = inst_19769__$1);

(statearr_19890[(12)] = inst_19770__$1);

return statearr_19890;
})();
if(cljs.core.truth_(inst_19781__$1)){
var statearr_19891_19934 = state_19863__$1;
(statearr_19891_19934[(1)] = (6));

} else {
var statearr_19892_19935 = state_19863__$1;
(statearr_19892_19935[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (23))){
var inst_19797 = (state_19863[(8)]);
var inst_19834 = cljs.core.coll_QMARK_.call(null,inst_19797);
var state_19863__$1 = state_19863;
if(inst_19834){
var statearr_19893_19936 = state_19863__$1;
(statearr_19893_19936[(1)] = (25));

} else {
var statearr_19894_19937 = state_19863__$1;
(statearr_19894_19937[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (19))){
var inst_19795 = (state_19863[(14)]);
var inst_19825 = cljs.core.PersistentHashMap.EMPTY;
var inst_19826 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_19825,inst_19795);
var state_19863__$1 = state_19863;
var statearr_19895_19938 = state_19863__$1;
(statearr_19895_19938[(2)] = inst_19826);

(statearr_19895_19938[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (11))){
var inst_19795 = (state_19863[(14)]);
var state_19863__$1 = state_19863;
var statearr_19897_19939 = state_19863__$1;
(statearr_19897_19939[(2)] = inst_19795);

(statearr_19897_19939[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (9))){
var inst_19766 = (state_19863[(17)]);
var inst_19791 = (state_19863[(16)]);
var inst_19770 = (state_19863[(12)]);
var inst_19790 = (state_19863[(2)]);
var inst_19791__$1 = fluree.db.util.async.throw_err.call(null,inst_19790);
var inst_19792 = cljs.core.count.call(null,inst_19791__$1);
var inst_19793 = fluree.db.query.analytical.add_fuel.call(null,inst_19792,fuel,max_fuel);
var inst_19794 = cljs.core.vals.call(null,inst_19766);
var inst_19795 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_19794,inst_19791__$1);
var state_19863__$1 = (function (){var statearr_19898 = state_19863;
(statearr_19898[(19)] = inst_19793);

(statearr_19898[(14)] = inst_19795);

(statearr_19898[(16)] = inst_19791__$1);

return statearr_19898;
})();
if(cljs.core.truth_(inst_19770)){
var statearr_19899_19940 = state_19863__$1;
(statearr_19899_19940[(1)] = (10));

} else {
var statearr_19900_19941 = state_19863__$1;
(statearr_19900_19941[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (5))){
var _ = (function (){var statearr_19901 = state_19863;
(statearr_19901[(4)] = cljs.core.rest.call(null,(state_19863[(4)])));

return statearr_19901;
})();
var state_19863__$1 = state_19863;
var ex19896 = (state_19863__$1[(2)]);
var statearr_19902_19942 = state_19863__$1;
(statearr_19902_19942[(5)] = ex19896);


if((ex19896 instanceof Error)){
var statearr_19903_19943 = state_19863__$1;
(statearr_19903_19943[(1)] = (4));

(statearr_19903_19943[(5)] = null);

} else {
throw ex19896;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (14))){
var state_19863__$1 = state_19863;
var statearr_19904_19944 = state_19863__$1;
(statearr_19904_19944[(2)] = null);

(statearr_19904_19944[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (26))){
var state_19863__$1 = state_19863;
var statearr_19905_19945 = state_19863__$1;
(statearr_19905_19945[(2)] = null);

(statearr_19905_19945[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (16))){
var state_19863__$1 = state_19863;
var statearr_19906_19946 = state_19863__$1;
(statearr_19906_19946[(2)] = null);

(statearr_19906_19946[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (10))){
var inst_19800 = (state_19863[(11)]);
var inst_19779 = (state_19863[(13)]);
var inst_19797 = cljs.core.first.call(null,inst_19779);
var inst_19798 = cljs.core.first.call(null,clause);
var inst_19799 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_19798);
var inst_19800__$1 = cljs.core.nth.call(null,inst_19779,(1));
var inst_19801 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_19800__$1);
var state_19863__$1 = (function (){var statearr_19907 = state_19863;
(statearr_19907[(10)] = inst_19799);

(statearr_19907[(11)] = inst_19800__$1);

(statearr_19907[(8)] = inst_19797);

return statearr_19907;
})();
if(cljs.core.truth_(inst_19801)){
var statearr_19908_19947 = state_19863__$1;
(statearr_19908_19947[(1)] = (13));

} else {
var statearr_19909_19948 = state_19863__$1;
(statearr_19909_19948[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (18))){
var inst_19799 = (state_19863[(10)]);
var inst_19823 = (state_19863[(2)]);
var state_19863__$1 = (function (){var statearr_19910 = state_19863;
(statearr_19910[(20)] = inst_19823);

return statearr_19910;
})();
if(cljs.core.truth_(inst_19799)){
var statearr_19911_19949 = state_19863__$1;
(statearr_19911_19949[(1)] = (19));

} else {
var statearr_19912_19950 = state_19863__$1;
(statearr_19912_19950[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19864 === (8))){
var inst_19779 = (state_19863[(13)]);
var inst_19780 = (state_19863[(18)]);
var inst_19785 = (state_19863[(2)]);
var inst_19786 = [inst_19785];
var inst_19787 = cljs.core.PersistentHashMap.fromArrays(inst_19780,inst_19786);
var inst_19788 = fluree.db.query.range.search.call(null,db,inst_19779,inst_19787);
var state_19863__$1 = state_19863;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19863__$1,(9),inst_19788);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_19913 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19913[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__);

(statearr_19913[(1)] = (1));

return statearr_19913;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1 = (function (state_19863){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19863);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19914){var ex__2749__auto__ = e19914;
var statearr_19915_19951 = state_19863;
(statearr_19915_19951[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19863[(4)]))){
var statearr_19916_19952 = state_19863;
(statearr_19916_19952[(1)] = cljs.core.first.call(null,(state_19863[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19953 = state_19863;
state_19863 = G__19953;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__ = function(state_19863){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1.call(this,state_19863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19917 = f__2769__auto__.call(null);
(statearr_19917[(6)] = c__2768__auto__);

return statearr_19917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__19954,res,clause){
var map__19955 = p__19954;
var map__19955__$1 = cljs.core.__destructure_map.call(null,map__19955);
var db = map__19955__$1;
var conn = cljs.core.get.call(null,map__19955__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__19955__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__19955__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20064){
var state_val_20065 = (state_20064[(1)]);
if((state_val_20065 === (7))){
var inst_19964 = (state_20064[(7)]);
var state_20064__$1 = state_20064;
var statearr_20066_20107 = state_20064__$1;
(statearr_20066_20107[(2)] = inst_19964);

(statearr_20066_20107[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (20))){
var state_20064__$1 = state_20064;
var statearr_20067_20108 = state_20064__$1;
(statearr_20067_20108[(2)] = null);

(statearr_20067_20108[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (1))){
var state_20064__$1 = state_20064;
var statearr_20068_20109 = state_20064__$1;
(statearr_20068_20109[(2)] = null);

(statearr_20068_20109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (24))){
var inst_19966 = (state_20064[(8)]);
var inst_20037 = (state_20064[(2)]);
var inst_20038 = fluree.db.flake.sid__GT_cid.call(null,inst_20037);
var inst_20039 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_20038);
var inst_20040 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20042 = [inst_19966];
var inst_20043 = (new cljs.core.PersistentVector(null,1,(5),inst_20041,inst_20042,null));
var inst_20044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20046 = [inst_20039];
var inst_20047 = (new cljs.core.PersistentVector(null,1,(5),inst_20045,inst_20046,null));
var inst_20048 = [inst_20047];
var inst_20049 = (new cljs.core.PersistentVector(null,1,(5),inst_20044,inst_20048,null));
var inst_20050 = cljs.core.PersistentHashMap.EMPTY;
var inst_20051 = [inst_20043,inst_20049,inst_20050];
var inst_20052 = cljs.core.PersistentHashMap.fromArrays(inst_20040,inst_20051);
var state_20064__$1 = state_20064;
var statearr_20069_20110 = state_20064__$1;
(statearr_20069_20110[(2)] = inst_20052);

(statearr_20069_20110[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (4))){
var inst_19957 = (state_20064[(2)]);
var state_20064__$1 = state_20064;
var statearr_20070_20111 = state_20064__$1;
(statearr_20070_20111[(2)] = inst_19957);

(statearr_20070_20111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (15))){
var inst_19966 = (state_20064[(8)]);
var inst_19964 = (state_20064[(7)]);
var inst_19985 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_19986 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_19987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19988 = [inst_19964];
var inst_19989 = (new cljs.core.PersistentVector(null,1,(5),inst_19987,inst_19988,null));
var inst_19990 = (function (){var subject_var = inst_19964;
var object_var = inst_19966;
var min_sid = inst_19985;
var max_sid = (0);
return (function (p1__19956_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__19956_SHARP_);
});
})();
var inst_19991 = cljs.core.range.call(null,inst_19985,(0));
var inst_19992 = cljs.core.map.call(null,inst_19990,inst_19991);
var inst_19993 = cljs.core.PersistentHashMap.EMPTY;
var inst_19994 = [inst_19989,inst_19992,inst_19993];
var inst_19995 = cljs.core.PersistentHashMap.fromArrays(inst_19986,inst_19994);
var state_20064__$1 = state_20064;
var statearr_20071_20112 = state_20064__$1;
(statearr_20071_20112[(2)] = inst_19995);

(statearr_20071_20112[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (21))){
var inst_20055 = (state_20064[(2)]);
var state_20064__$1 = state_20064;
var statearr_20072_20113 = state_20064__$1;
(statearr_20072_20113[(2)] = inst_20055);

(statearr_20072_20113[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (13))){
var inst_19966 = (state_20064[(8)]);
var state_20064__$1 = state_20064;
if(cljs.core.truth_(inst_19966)){
var statearr_20073_20114 = state_20064__$1;
(statearr_20073_20114[(1)] = (19));

} else {
var statearr_20074_20115 = state_20064__$1;
(statearr_20074_20115[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (22))){
var inst_20028 = (state_20064[(9)]);
var state_20064__$1 = state_20064;
var statearr_20075_20116 = state_20064__$1;
(statearr_20075_20116[(2)] = inst_20028);

(statearr_20075_20116[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (6))){
var inst_19966 = (state_20064[(8)]);
var state_20064__$1 = state_20064;
var statearr_20076_20117 = state_20064__$1;
(statearr_20076_20117[(2)] = inst_19966);

(statearr_20076_20117[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (25))){
var inst_20034 = (state_20064[(2)]);
var inst_20035 = fluree.db.util.async.throw_err.call(null,inst_20034);
var state_20064__$1 = state_20064;
var statearr_20077_20118 = state_20064__$1;
(statearr_20077_20118[(2)] = inst_20035);

(statearr_20077_20118[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (17))){
var inst_20025 = (state_20064[(2)]);
var state_20064__$1 = state_20064;
var statearr_20078_20119 = state_20064__$1;
(statearr_20078_20119[(2)] = inst_20025);

(statearr_20078_20119[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (3))){
var inst_20062 = (state_20064[(2)]);
var state_20064__$1 = state_20064;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20064__$1,inst_20062);
} else {
if((state_val_20065 === (12))){
var inst_19979 = ["_tx",null,"_block",null];
var inst_19980 = (new cljs.core.PersistentArrayMap(null,2,inst_19979,null));
var inst_19981 = (new cljs.core.PersistentHashSet(null,inst_19980,null));
var inst_19982 = cljs.core.last.call(null,clause);
var inst_19983 = inst_19981.call(null,inst_19982);
var state_20064__$1 = state_20064;
if(cljs.core.truth_(inst_19983)){
var statearr_20079_20120 = state_20064__$1;
(statearr_20079_20120[(1)] = (15));

} else {
var statearr_20080_20121 = state_20064__$1;
(statearr_20080_20121[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (2))){
var inst_19964 = (state_20064[(7)]);
var _ = (function (){var statearr_20081 = state_20064;
(statearr_20081[(4)] = cljs.core.cons.call(null,(5),(state_20064[(4)])));

return statearr_20081;
})();
var inst_19963 = cljs.core.first.call(null,clause);
var inst_19964__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_19963);
var inst_19965 = cljs.core.last.call(null,clause);
var inst_19966 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_19965);
var state_20064__$1 = (function (){var statearr_20082 = state_20064;
(statearr_20082[(8)] = inst_19966);

(statearr_20082[(7)] = inst_19964__$1);

return statearr_20082;
})();
if(cljs.core.truth_(inst_19964__$1)){
var statearr_20083_20122 = state_20064__$1;
(statearr_20083_20122[(1)] = (6));

} else {
var statearr_20084_20123 = state_20064__$1;
(statearr_20084_20123[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (23))){
var inst_20028 = (state_20064[(9)]);
var inst_20032 = fluree.db.dbproto._subid.call(null,db,inst_20028);
var state_20064__$1 = state_20064;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20064__$1,(25),inst_20032);
} else {
if((state_val_20065 === (19))){
var inst_20028 = (state_20064[(9)]);
var inst_20028__$1 = cljs.core.first.call(null,clause);
var inst_20029 = typeof inst_20028__$1 === 'number';
var state_20064__$1 = (function (){var statearr_20085 = state_20064;
(statearr_20085[(9)] = inst_20028__$1);

return statearr_20085;
})();
if(cljs.core.truth_(inst_20029)){
var statearr_20086_20124 = state_20064__$1;
(statearr_20086_20124[(1)] = (22));

} else {
var statearr_20087_20125 = state_20064__$1;
(statearr_20087_20125[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (11))){
var inst_20059 = (state_20064[(2)]);
var _ = (function (){var statearr_20089 = state_20064;
(statearr_20089[(4)] = cljs.core.rest.call(null,(state_20064[(4)])));

return statearr_20089;
})();
var state_20064__$1 = state_20064;
var statearr_20090_20126 = state_20064__$1;
(statearr_20090_20126[(2)] = inst_20059);

(statearr_20090_20126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (9))){
var inst_19972 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19973 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19974 = cljs.core.PersistentHashMap.fromArrays(inst_19972,inst_19973);
var inst_19975 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_19974);
var inst_19976 = (function(){throw inst_19975})();
var state_20064__$1 = state_20064;
var statearr_20091_20127 = state_20064__$1;
(statearr_20091_20127[(2)] = inst_19976);

(statearr_20091_20127[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (5))){
var _ = (function (){var statearr_20092 = state_20064;
(statearr_20092[(4)] = cljs.core.rest.call(null,(state_20064[(4)])));

return statearr_20092;
})();
var state_20064__$1 = state_20064;
var ex20088 = (state_20064__$1[(2)]);
var statearr_20093_20128 = state_20064__$1;
(statearr_20093_20128[(5)] = ex20088);


if((ex20088 instanceof Error)){
var statearr_20094_20129 = state_20064__$1;
(statearr_20094_20129[(1)] = (4));

(statearr_20094_20129[(5)] = null);

} else {
throw ex20088;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (14))){
var inst_20057 = (state_20064[(2)]);
var state_20064__$1 = state_20064;
var statearr_20095_20130 = state_20064__$1;
(statearr_20095_20130[(2)] = inst_20057);

(statearr_20095_20130[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (16))){
var inst_19998 = (state_20064[(10)]);
var inst_20001 = (state_20064[(11)]);
var inst_20000 = (state_20064[(12)]);
var inst_19997 = cljs.core.last.call(null,clause);
var inst_19998__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_19997);
var inst_19999 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20000__$1 = cljs.core.get.call(null,inst_19999,inst_19998__$1);
var inst_20001__$1 = fluree.db.flake.min_subject_id.call(null,inst_19998__$1);
var inst_20002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20003 = [inst_20000__$1];
var inst_20004 = (new cljs.core.PersistentVector(null,1,(5),inst_20002,inst_20003,null));
var inst_20005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20006 = [inst_20001__$1];
var inst_20007 = (new cljs.core.PersistentVector(null,1,(5),inst_20005,inst_20006,null));
var inst_20008 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20004,cljs.core._LT__EQ_,inst_20007);
var state_20064__$1 = (function (){var statearr_20096 = state_20064;
(statearr_20096[(10)] = inst_19998__$1);

(statearr_20096[(11)] = inst_20001__$1);

(statearr_20096[(12)] = inst_20000__$1);

return statearr_20096;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20064__$1,(18),inst_20008);
} else {
if((state_val_20065 === (10))){
var inst_19964 = (state_20064[(7)]);
var state_20064__$1 = state_20064;
if(cljs.core.truth_(inst_19964)){
var statearr_20097_20131 = state_20064__$1;
(statearr_20097_20131[(1)] = (12));

} else {
var statearr_20098_20132 = state_20064__$1;
(statearr_20098_20132[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (18))){
var inst_19998 = (state_20064[(10)]);
var inst_19966 = (state_20064[(8)]);
var inst_20001 = (state_20064[(11)]);
var inst_20000 = (state_20064[(12)]);
var inst_19964 = (state_20064[(7)]);
var inst_20010 = (state_20064[(2)]);
var inst_20011 = fluree.db.util.async.throw_err.call(null,inst_20010);
var inst_20012 = (function (){var subject_var = inst_19964;
var object_var = inst_19966;
var partition = inst_19998;
var max_sid = inst_20000;
var min_sid = inst_20001;
var flakes = inst_20011;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_20013 = cljs.core.map.call(null,inst_20012);
var inst_20014 = cljs.core.distinct.call(null);
var inst_20015 = cljs.core.comp.call(null,inst_20013,inst_20014);
var inst_20016 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20018 = [inst_19964];
var inst_20019 = (new cljs.core.PersistentVector(null,1,(5),inst_20017,inst_20018,null));
var inst_20020 = cljs.core.sequence.call(null,inst_20015,inst_20011);
var inst_20021 = cljs.core.PersistentHashMap.EMPTY;
var inst_20022 = [inst_20019,inst_20020,inst_20021];
var inst_20023 = cljs.core.PersistentHashMap.fromArrays(inst_20016,inst_20022);
var state_20064__$1 = state_20064;
var statearr_20099_20133 = state_20064__$1;
(statearr_20099_20133[(2)] = inst_20023);

(statearr_20099_20133[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20065 === (8))){
var inst_19970 = (state_20064[(2)]);
var state_20064__$1 = state_20064;
if(cljs.core.truth_(inst_19970)){
var statearr_20100_20134 = state_20064__$1;
(statearr_20100_20134[(1)] = (9));

} else {
var statearr_20101_20135 = state_20064__$1;
(statearr_20101_20135[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20102 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20102[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__);

(statearr_20102[(1)] = (1));

return statearr_20102;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20064){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20064);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20103){var ex__2749__auto__ = e20103;
var statearr_20104_20136 = state_20064;
(statearr_20104_20136[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20064[(4)]))){
var statearr_20105_20137 = state_20064;
(statearr_20105_20137[(1)] = cljs.core.first.call(null,(state_20064[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20138 = state_20064;
state_20064 = G__20138;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__ = function(state_20064){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20106 = f__2769__auto__.call(null);
(statearr_20106[(6)] = c__2768__auto__);

return statearr_20106;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__20144 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__20144 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__20144;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__4652__auto__ = (function fluree$db$query$analytical$variance_$_iter__20145(s__20146){
return (new cljs.core.LazySeq(null,(function (){
var s__20146__$1 = s__20146;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__20146__$1);
if(temp__5804__auto__){
var s__20146__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20146__$2)){
var c__4650__auto__ = cljs.core.chunk_first.call(null,s__20146__$2);
var size__4651__auto__ = cljs.core.count.call(null,c__4650__auto__);
var b__20148 = cljs.core.chunk_buffer.call(null,size__4651__auto__);
if((function (){var i__20147 = (0);
while(true){
if((i__20147 < size__4651__auto__)){
var x = cljs.core._nth.call(null,c__4650__auto__,i__20147);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__20148,(delta * delta));

var G__20149 = (i__20147 + (1));
i__20147 = G__20149;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20148),fluree$db$query$analytical$variance_$_iter__20145.call(null,cljs.core.chunk_rest.call(null,s__20146__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20148),null);
}
} else {
var x = cljs.core.first.call(null,s__20146__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__20145.call(null,cljs.core.rest.call(null,s__20146__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4336__auto__ = n;
var y__4337__auto__ = (- n);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
}),(function() {
var G__20150 = null;
var G__20150__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__20150__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__20150 = function(n,coll){
switch(arguments.length){
case 1:
return G__20150__1.call(this,n);
case 2:
return G__20150__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20150.cljs$core$IFn$_invoke$arity$1 = G__20150__1;
G__20150.cljs$core$IFn$_invoke$arity$2 = G__20150__2;
return G__20150;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__20151 = null;
var G__20151__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__20151__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__20151 = function(n,coll){
switch(arguments.length){
case 1:
return G__20151__1.call(this,n);
case 2:
return G__20151__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20151.cljs$core$IFn$_invoke$arity$1 = G__20151__1;
G__20151.cljs$core$IFn$_invoke$arity$2 = G__20151__2;
return G__20151;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__20152 = null;
var G__20152__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__20152__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__20152 = function(n,coll){
switch(arguments.length){
case 1:
return G__20152__1.call(this,n);
case 2:
return G__20152__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20152.cljs$core$IFn$_invoke$arity$1 = G__20152__1;
G__20152.cljs$core$IFn$_invoke$arity$2 = G__20152__2;
return G__20152;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__20153 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__20153,(0),null);
var arg = cljs.core.nth.call(null,vec__20153,(1),null);
var var$ = cljs.core.nth.call(null,vec__20153,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20156 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__20156,(0),null);
var variable = cljs.core.nth.call(null,vec__20156,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__20159 = agg;
var map__20159__$1 = cljs.core.__destructure_map.call(null,map__20159);
var variable = cljs.core.get.call(null,map__20159__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__20159__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var function$ = cljs.core.get.call(null,map__20159__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = function$.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__20161 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__20161,(0),null);
var agg_result = cljs.core.nth.call(null,vec__20161,(1),null);
var map__20164 = res__$1;
var map__20164__$1 = cljs.core.__destructure_map.call(null,map__20164);
var headers = cljs.core.get.call(null,map__20164__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__20164__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__20160_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__20160_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__20165_SHARP_){
return cljs.core.nth.call(null,tuple,p1__20165_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__20166_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__20166_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.call(null,(function (p1__20167_SHARP_,p2__20168_SHARP_){
return cljs.core.conj.call(null,p1__20167_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__20168_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__20169_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__20169_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__20172,row,b_tuple){
var vec__20173 = p__20172;
var acc = cljs.core.nth.call(null,vec__20173,(0),null);
var b_rows = cljs.core.nth.call(null,vec__20173,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__20170_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__20170_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__4253__auto__ = acc;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__20171_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__20171_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__20176_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__20176_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__20177_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__20177_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__20179_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__20179_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__20178_SHARP_){
return cljs.core.range.call(null,(0),p1__20178_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__20180_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__20180_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__20181_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__20181_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__20182_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20182_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__20184_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__20184_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__20183_SHARP_){
return cljs.core.range.call(null,(0),p1__20183_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__20185_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20185_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__20187 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__20187,(0),null);
var _ = cljs.core.nth.call(null,vec__20187,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__20186_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__20186_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var vec__20192 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filt,valid_vars);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__20192,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__20192,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__20190_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__20190_SHARP_);
}),filt_vars);
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__20191_SHARP_){
return cljs.core.nth.call(null,clause,p1__20191_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__20195,filters,optional_QMARK_){
var map__20196 = p__20195;
var map__20196__$1 = cljs.core.__destructure_map.call(null,map__20196);
var tuple_map = map__20196__$1;
var headers = cljs.core.get.call(null,map__20196__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__20196__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__20196__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__20197 = clause;
var k = cljs.core.nth.call(null,vec__20197,(0),null);
var v = cljs.core.nth.call(null,vec__20197,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__20200 = res;
var map__20200__$1 = cljs.core.__destructure_map.call(null,map__20200);
var headers = cljs.core.get.call(null,map__20200__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__20200__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5802__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20256){
var state_val_20257 = (state_20256[(1)]);
if((state_val_20257 === (7))){
var inst_20230 = (state_20256[(7)]);
var inst_20228 = (state_20256[(2)]);
var inst_20229 = fluree.db.util.async.throw_err.call(null,inst_20228);
var inst_20230__$1 = cljs.core.nth.call(null,inst_20229,(0),null);
var inst_20231 = cljs.core.nth.call(null,inst_20229,(1),null);
var inst_20232 = (inst_20230__$1 == null);
var state_20256__$1 = (function (){var statearr_20258 = state_20256;
(statearr_20258[(8)] = inst_20231);

(statearr_20258[(7)] = inst_20230__$1);

return statearr_20258;
})();
if(cljs.core.truth_(inst_20232)){
var statearr_20259_20288 = state_20256__$1;
(statearr_20259_20288[(1)] = (8));

} else {
var statearr_20260_20289 = state_20256__$1;
(statearr_20260_20289[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20257 === (1))){
var inst_20208 = optional_clauses;
var inst_20209 = cljs.core.seq.call(null,inst_20208);
var inst_20210 = cljs.core.first.call(null,inst_20209);
var inst_20211 = cljs.core.next.call(null,inst_20209);
var inst_20212 = where_tuples;
var inst_20213 = inst_20208;
var inst_20214 = inst_20212;
var state_20256__$1 = (function (){var statearr_20261 = state_20256;
(statearr_20261[(9)] = inst_20211);

(statearr_20261[(10)] = inst_20213);

(statearr_20261[(11)] = inst_20210);

(statearr_20261[(12)] = inst_20214);

return statearr_20261;
})();
var statearr_20262_20290 = state_20256__$1;
(statearr_20262_20290[(2)] = null);

(statearr_20262_20290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20257 === (4))){
var inst_20221 = (state_20256[(13)]);
var inst_20220 = (state_20256[(14)]);
var inst_20214 = (state_20256[(12)]);
var inst_20226 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_20214,inst_20220,inst_20221,true,fuel,max_fuel,opts);
var state_20256__$1 = state_20256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20256__$1,(7),inst_20226);
} else {
if((state_val_20257 === (15))){
var state_20256__$1 = state_20256;
var statearr_20263_20291 = state_20256__$1;
(statearr_20263_20291[(2)] = null);

(statearr_20263_20291[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20257 === (13))){
var inst_20247 = (state_20256[(2)]);
var state_20256__$1 = state_20256;
var statearr_20264_20292 = state_20256__$1;
(statearr_20264_20292[(2)] = inst_20247);

(statearr_20264_20292[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20257 === (6))){
var inst_20252 = (state_20256[(2)]);
var state_20256__$1 = state_20256;
var statearr_20265_20293 = state_20256__$1;
(statearr_20265_20293[(2)] = inst_20252);

(statearr_20265_20293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20257 === (3))){
var inst_20254 = (state_20256[(2)]);
var state_20256__$1 = state_20256;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20256__$1,inst_20254);
} else {
if((state_val_20257 === (12))){
var state_20256__$1 = state_20256;
var statearr_20266_20294 = state_20256__$1;
(statearr_20266_20294[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20257 === (2))){
var inst_20220 = (state_20256[(14)]);
var inst_20213 = (state_20256[(10)]);
var inst_20219 = cljs.core.seq.call(null,inst_20213);
var inst_20220__$1 = cljs.core.first.call(null,inst_20219);
var inst_20221 = cljs.core.next.call(null,inst_20219);
var state_20256__$1 = (function (){var statearr_20268 = state_20256;
(statearr_20268[(13)] = inst_20221);

(statearr_20268[(14)] = inst_20220__$1);

return statearr_20268;
})();
if(cljs.core.truth_(inst_20220__$1)){
var statearr_20269_20295 = state_20256__$1;
(statearr_20269_20295[(1)] = (4));

} else {
var statearr_20270_20296 = state_20256__$1;
(statearr_20270_20296[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20257 === (11))){
var inst_20231 = (state_20256[(8)]);
var inst_20230 = (state_20256[(7)]);
var inst_20213 = inst_20231;
var inst_20214 = inst_20230;
var state_20256__$1 = (function (){var statearr_20271 = state_20256;
(statearr_20271[(10)] = inst_20213);

(statearr_20271[(12)] = inst_20214);

return statearr_20271;
})();
var statearr_20272_20297 = state_20256__$1;
(statearr_20272_20297[(2)] = null);

(statearr_20272_20297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20257 === (9))){
var inst_20220 = (state_20256[(14)]);
var inst_20236 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_20220);
var state_20256__$1 = state_20256;
if(cljs.core.truth_(inst_20236)){
var statearr_20273_20298 = state_20256__$1;
(statearr_20273_20298[(1)] = (11));

} else {
var statearr_20274_20299 = state_20256__$1;
(statearr_20274_20299[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20257 === (5))){
var inst_20214 = (state_20256[(12)]);
var state_20256__$1 = state_20256;
var statearr_20275_20300 = state_20256__$1;
(statearr_20275_20300[(2)] = inst_20214);

(statearr_20275_20300[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20257 === (14))){
var inst_20231 = (state_20256[(8)]);
var inst_20230 = (state_20256[(7)]);
var inst_20214 = (state_20256[(12)]);
var inst_20241 = fluree.db.query.analytical.left_outer_join.call(null,inst_20214,inst_20230);
var inst_20213 = inst_20231;
var inst_20214__$1 = inst_20241;
var state_20256__$1 = (function (){var statearr_20276 = state_20256;
(statearr_20276[(10)] = inst_20213);

(statearr_20276[(12)] = inst_20214__$1);

return statearr_20276;
})();
var statearr_20277_20301 = state_20256__$1;
(statearr_20277_20301[(2)] = null);

(statearr_20277_20301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20257 === (16))){
var inst_20245 = (state_20256[(2)]);
var state_20256__$1 = state_20256;
var statearr_20279_20302 = state_20256__$1;
(statearr_20279_20302[(2)] = inst_20245);

(statearr_20279_20302[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20257 === (10))){
var inst_20249 = (state_20256[(2)]);
var state_20256__$1 = state_20256;
var statearr_20280_20303 = state_20256__$1;
(statearr_20280_20303[(2)] = inst_20249);

(statearr_20280_20303[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20257 === (8))){
var inst_20231 = (state_20256[(8)]);
var inst_20214 = (state_20256[(12)]);
var tmp20278 = inst_20214;
var inst_20213 = inst_20231;
var inst_20214__$1 = tmp20278;
var state_20256__$1 = (function (){var statearr_20281 = state_20256;
(statearr_20281[(10)] = inst_20213);

(statearr_20281[(12)] = inst_20214__$1);

return statearr_20281;
})();
var statearr_20282_20304 = state_20256__$1;
(statearr_20282_20304[(2)] = null);

(statearr_20282_20304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0 = (function (){
var statearr_20283 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20283[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__);

(statearr_20283[(1)] = (1));

return statearr_20283;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1 = (function (state_20256){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20256);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20284){var ex__2749__auto__ = e20284;
var statearr_20285_20305 = state_20256;
(statearr_20285_20305[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20256[(4)]))){
var statearr_20286_20306 = state_20256;
(statearr_20286_20306[(1)] = cljs.core.first.call(null,(state_20256[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20307 = state_20256;
state_20256 = G__20307;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__ = function(state_20256){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1.call(this,state_20256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20287 = f__2769__auto__.call(null);
(statearr_20287[(6)] = c__2768__auto__);

return statearr_20287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__20309){
var vec__20310 = p__20309;
var var_name = cljs.core.nth.call(null,vec__20310,(0),null);
var var_val = cljs.core.nth.call(null,vec__20310,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__20308_SHARP_){
return cljs.core.conj.call(null,p1__20308_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__20314,p__20315,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__20316 = p__20314;
var map__20316__$1 = cljs.core.__destructure_map.call(null,map__20316);
var q_map = map__20316__$1;
var prefixes = cljs.core.get.call(null,map__20316__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__20317 = p__20315;
var map__20317__$1 = cljs.core.__destructure_map.call(null,map__20317);
var res = map__20317__$1;
var vars = cljs.core.get.call(null,map__20317__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20554){
var state_val_20555 = (state_20554[(1)]);
if((state_val_20555 === (65))){
var inst_20504 = (state_20554[(7)]);
var inst_20503 = (state_20554[(8)]);
var inst_20515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20516 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_20503,res,inst_20504);
var inst_20517 = [inst_20516,r];
var inst_20518 = (new cljs.core.PersistentVector(null,2,(5),inst_20515,inst_20517,null));
var state_20554__$1 = state_20554;
var statearr_20556_20661 = state_20554__$1;
(statearr_20556_20661[(2)] = inst_20518);

(statearr_20556_20661[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (70))){
var inst_20530 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20557_20662 = state_20554__$1;
(statearr_20557_20662[(2)] = inst_20530);

(statearr_20557_20662[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (62))){
var inst_20504 = (state_20554[(7)]);
var inst_20512 = cljs.core.second.call(null,inst_20504);
var inst_20513 = clojure.string.starts_with_QMARK_.call(null,inst_20512,"fullText:");
var state_20554__$1 = state_20554;
if(inst_20513){
var statearr_20558_20663 = state_20554__$1;
(statearr_20558_20663[(1)] = (65));

} else {
var statearr_20559_20664 = state_20554__$1;
(statearr_20559_20664[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (7))){
var inst_20423 = (state_20554[(9)]);
var inst_20422 = cljs.core.count.call(null,clause);
var inst_20423__$1 = cljs.core._EQ_.call(null,(3),inst_20422);
var state_20554__$1 = (function (){var statearr_20560 = state_20554;
(statearr_20560[(9)] = inst_20423__$1);

return statearr_20560;
})();
if(inst_20423__$1){
var statearr_20561_20665 = state_20554__$1;
(statearr_20561_20665[(1)] = (31));

} else {
var statearr_20562_20666 = state_20554__$1;
(statearr_20562_20666[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (59))){
var inst_20537 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20563_20667 = state_20554__$1;
(statearr_20563_20667[(2)] = inst_20537);

(statearr_20563_20667[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (20))){
var inst_20386 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20564_20668 = state_20554__$1;
(statearr_20564_20668[(2)] = inst_20386);

(statearr_20564_20668[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (58))){
var state_20554__$1 = state_20554;
var statearr_20565_20669 = state_20554__$1;
(statearr_20565_20669[(2)] = null);

(statearr_20565_20669[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (60))){
var inst_20503 = (state_20554[(8)]);
var inst_20501 = (state_20554[(2)]);
var inst_20502 = fluree.db.util.async.throw_err.call(null,inst_20501);
var inst_20503__$1 = cljs.core.nth.call(null,inst_20502,(0),null);
var inst_20504 = cljs.core.nth.call(null,inst_20502,(1),null);
var inst_20505 = cljs.core._EQ_.call(null,"$wd",inst_20503__$1);
var state_20554__$1 = (function (){var statearr_20566 = state_20554;
(statearr_20566[(7)] = inst_20504);

(statearr_20566[(8)] = inst_20503__$1);

return statearr_20566;
})();
if(inst_20505){
var statearr_20567_20670 = state_20554__$1;
(statearr_20567_20670[(1)] = (61));

} else {
var statearr_20568_20671 = state_20554__$1;
(statearr_20568_20671[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (27))){
var inst_20416 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20569_20672 = state_20554__$1;
(statearr_20569_20672[(2)] = inst_20416);

(statearr_20569_20672[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (1))){
var state_20554__$1 = state_20554;
var statearr_20570_20673 = state_20554__$1;
(statearr_20570_20673[(2)] = null);

(statearr_20570_20673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (69))){
var state_20554__$1 = state_20554;
var statearr_20571_20674 = state_20554__$1;
(statearr_20571_20674[(2)] = null);

(statearr_20571_20674[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (24))){
var inst_20380 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20572_20675 = state_20554__$1;
(statearr_20572_20675[(2)] = inst_20380);

(statearr_20572_20675[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (55))){
var inst_20486 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_20487 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20488 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20489 = cljs.core.PersistentHashMap.fromArrays(inst_20487,inst_20488);
var inst_20490 = cljs.core.ex_info.call(null,inst_20486,inst_20489);
var inst_20491 = (function(){throw inst_20490})();
var state_20554__$1 = state_20554;
var statearr_20573_20676 = state_20554__$1;
(statearr_20573_20676[(2)] = inst_20491);

(statearr_20573_20676[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (39))){
var inst_20443 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
if(cljs.core.truth_(inst_20443)){
var statearr_20574_20677 = state_20554__$1;
(statearr_20574_20677[(1)] = (40));

} else {
var statearr_20575_20678 = state_20554__$1;
(statearr_20575_20678[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (46))){
var inst_20543 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20576_20679 = state_20554__$1;
(statearr_20576_20679[(2)] = inst_20543);

(statearr_20576_20679[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (4))){
var inst_20318 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20577_20680 = state_20554__$1;
(statearr_20577_20680[(2)] = inst_20318);

(statearr_20577_20680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (54))){
var inst_20479 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_20480 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20481 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20482 = cljs.core.PersistentHashMap.fromArrays(inst_20480,inst_20481);
var inst_20483 = cljs.core.ex_info.call(null,inst_20479,inst_20482);
var inst_20484 = (function(){throw inst_20483})();
var state_20554__$1 = state_20554;
var statearr_20578_20681 = state_20554__$1;
(statearr_20578_20681[(2)] = inst_20484);

(statearr_20578_20681[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (15))){
var inst_20418 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20579_20682 = state_20554__$1;
(statearr_20579_20682[(2)] = inst_20418);

(statearr_20579_20682[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (48))){
var inst_20467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20468 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_20469 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_20468);
var inst_20470 = [inst_20469,r];
var inst_20471 = (new cljs.core.PersistentVector(null,2,(5),inst_20467,inst_20470,null));
var state_20554__$1 = state_20554;
var statearr_20580_20683 = state_20554__$1;
(statearr_20580_20683[(2)] = inst_20471);

(statearr_20580_20683[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (50))){
var inst_20541 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20581_20684 = state_20554__$1;
(statearr_20581_20684[(2)] = inst_20541);

(statearr_20581_20684[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (21))){
var inst_20331 = (state_20554[(10)]);
var inst_20364 = (state_20554[(11)]);
var inst_20363 = (state_20554[(12)]);
var inst_20327 = (state_20554[(13)]);
var inst_20354 = (state_20554[(14)]);
var inst_20357 = (state_20554[(15)]);
var inst_20355 = (state_20554[(16)]);
var inst_20352 = (state_20554[(17)]);
var inst_20356 = (state_20554[(18)]);
var inst_20368 = (state_20554[(2)]);
var inst_20369 = fluree.db.util.async.throw_err.call(null,inst_20368);
var inst_20370 = (function (){var seq__20350 = inst_20355;
var new_res = inst_20369;
var rest = inst_20364;
var tuples = inst_20357;
var G__20348 = inst_20356;
var vec__20349 = inst_20352;
var first__20351 = inst_20354;
var pred__20328 = inst_20331;
var expr__20329 = inst_20327;
var first__20361 = inst_20363;
var segment_type = inst_20327;
var seq__20360 = inst_20364;
var clause_group = inst_20363;
var vec__20359 = inst_20356;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_20371 = cljs.core.keys.call(null,vars);
var inst_20372 = cljs.core.reduce.call(null,inst_20370,inst_20369,inst_20371);
var inst_20373 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_20372);
var state_20554__$1 = (function (){var statearr_20582 = state_20554;
(statearr_20582[(19)] = inst_20373);

return statearr_20582;
})();
if(cljs.core.truth_(inst_20357)){
var statearr_20583_20685 = state_20554__$1;
(statearr_20583_20685[(1)] = (22));

} else {
var statearr_20584_20686 = state_20554__$1;
(statearr_20584_20686[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (31))){
var inst_20425 = cljs.core.second.call(null,clause);
var inst_20426 = clojure.string.starts_with_QMARK_.call(null,inst_20425,"fullText:");
var state_20554__$1 = state_20554;
var statearr_20585_20687 = state_20554__$1;
(statearr_20585_20687[(2)] = inst_20426);

(statearr_20585_20687[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (32))){
var inst_20423 = (state_20554[(9)]);
var state_20554__$1 = state_20554;
var statearr_20586_20688 = state_20554__$1;
(statearr_20586_20688[(2)] = inst_20423);

(statearr_20586_20688[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (40))){
var inst_20445 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20446 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_20554__$1 = (function (){var statearr_20587 = state_20554;
(statearr_20587[(20)] = inst_20445);

return statearr_20587;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20554__$1,(43),inst_20446);
} else {
if((state_val_20555 === (56))){
var inst_20493 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20588_20689 = state_20554__$1;
(statearr_20588_20689[(2)] = inst_20493);

(statearr_20588_20689[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (33))){
var inst_20429 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
if(cljs.core.truth_(inst_20429)){
var statearr_20589_20690 = state_20554__$1;
(statearr_20589_20690[(1)] = (34));

} else {
var statearr_20590_20691 = state_20554__$1;
(statearr_20590_20691[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (13))){
var inst_20352 = (state_20554[(17)]);
var inst_20352__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20353 = cljs.core.seq.call(null,inst_20352__$1);
var inst_20354 = cljs.core.first.call(null,inst_20353);
var inst_20355 = cljs.core.next.call(null,inst_20353);
var inst_20356 = inst_20352__$1;
var inst_20357 = null;
var state_20554__$1 = (function (){var statearr_20591 = state_20554;
(statearr_20591[(14)] = inst_20354);

(statearr_20591[(15)] = inst_20357);

(statearr_20591[(16)] = inst_20355);

(statearr_20591[(17)] = inst_20352__$1);

(statearr_20591[(18)] = inst_20356);

return statearr_20591;
})();
var statearr_20592_20692 = state_20554__$1;
(statearr_20592_20692[(2)] = null);

(statearr_20592_20692[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (22))){
var inst_20364 = (state_20554[(11)]);
var inst_20357 = (state_20554[(15)]);
var inst_20373 = (state_20554[(19)]);
var inst_20375 = fluree.db.query.union.results.call(null,inst_20357,inst_20373);
var inst_20356 = inst_20364;
var inst_20357__$1 = inst_20375;
var state_20554__$1 = (function (){var statearr_20593 = state_20554;
(statearr_20593[(15)] = inst_20357__$1);

(statearr_20593[(18)] = inst_20356);

return statearr_20593;
})();
var statearr_20594_20693 = state_20554__$1;
(statearr_20594_20693[(2)] = null);

(statearr_20594_20693[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (36))){
var inst_20547 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20595_20694 = state_20554__$1;
(statearr_20595_20694[(2)] = inst_20547);

(statearr_20595_20694[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (41))){
var inst_20453 = cljs.core.count.call(null,clause);
var inst_20454 = cljs.core._EQ_.call(null,(3),inst_20453);
var state_20554__$1 = state_20554;
if(inst_20454){
var statearr_20596_20695 = state_20554__$1;
(statearr_20596_20695[(1)] = (44));

} else {
var statearr_20597_20696 = state_20554__$1;
(statearr_20597_20696[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (43))){
var inst_20445 = (state_20554[(20)]);
var inst_20448 = (state_20554[(2)]);
var inst_20449 = fluree.db.util.async.throw_err.call(null,inst_20448);
var inst_20450 = [inst_20449,r];
var inst_20451 = (new cljs.core.PersistentVector(null,2,(5),inst_20445,inst_20450,null));
var state_20554__$1 = state_20554;
var statearr_20598_20697 = state_20554__$1;
(statearr_20598_20697[(2)] = inst_20451);

(statearr_20598_20697[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (61))){
var inst_20504 = (state_20554[(7)]);
var inst_20507 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_20504,r,res,optional_QMARK_,fuel,max_fuel);
var state_20554__$1 = state_20554;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20554__$1,(64),inst_20507);
} else {
if((state_val_20555 === (29))){
var inst_20327 = (state_20554[(13)]);
var inst_20410 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20327)].join('');
var inst_20411 = (new Error(inst_20410));
var inst_20412 = (function(){throw inst_20411})();
var state_20554__$1 = state_20554;
var statearr_20599_20698 = state_20554__$1;
(statearr_20599_20698[(2)] = inst_20412);

(statearr_20599_20698[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (44))){
var inst_20456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20457 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_20554__$1 = (function (){var statearr_20600 = state_20554;
(statearr_20600[(21)] = inst_20456);

return statearr_20600;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20554__$1,(47),inst_20457);
} else {
if((state_val_20555 === (6))){
var inst_20331 = (state_20554[(10)]);
var inst_20327 = (state_20554[(13)]);
var inst_20326 = cljs.core.keys.call(null,clause);
var inst_20327__$1 = cljs.core.first.call(null,inst_20326);
var inst_20331__$1 = cljs.core._EQ_;
var inst_20332 = inst_20331__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_20327__$1);
var state_20554__$1 = (function (){var statearr_20601 = state_20554;
(statearr_20601[(10)] = inst_20331__$1);

(statearr_20601[(13)] = inst_20327__$1);

return statearr_20601;
})();
if(cljs.core.truth_(inst_20332)){
var statearr_20602_20699 = state_20554__$1;
(statearr_20602_20699[(1)] = (9));

} else {
var statearr_20603_20700 = state_20554__$1;
(statearr_20603_20700[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (28))){
var inst_20404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20405 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20406 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_20405,optional_QMARK_);
var inst_20407 = [inst_20406,r];
var inst_20408 = (new cljs.core.PersistentVector(null,2,(5),inst_20404,inst_20407,null));
var state_20554__$1 = state_20554;
var statearr_20604_20701 = state_20554__$1;
(statearr_20604_20701[(2)] = inst_20408);

(statearr_20604_20701[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (64))){
var inst_20509 = (state_20554[(2)]);
var inst_20510 = fluree.db.util.async.throw_err.call(null,inst_20509);
var state_20554__$1 = state_20554;
var statearr_20605_20702 = state_20554__$1;
(statearr_20605_20702[(2)] = inst_20510);

(statearr_20605_20702[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (51))){
var inst_20476 = cljs.core.first.call(null,clause);
var inst_20477 = cljs.core.sequential_QMARK_.call(null,inst_20476);
var state_20554__$1 = state_20554;
if(inst_20477){
var statearr_20606_20703 = state_20554__$1;
(statearr_20606_20703[(1)] = (54));

} else {
var statearr_20607_20704 = state_20554__$1;
(statearr_20607_20704[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (25))){
var inst_20331 = (state_20554[(10)]);
var inst_20327 = (state_20554[(13)]);
var inst_20392 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20393 = (function (){var segment_type = inst_20327;
var pred__20328 = inst_20331;
var expr__20329 = inst_20327;
var bindings = inst_20392;
return (function (p1__20313_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__20313_SHARP_);
});
})();
var inst_20394 = cljs.core.map.call(null,inst_20393,inst_20392);
var inst_20395 = cljs.core.PersistentHashMap.EMPTY;
var inst_20396 = cljs.core.into.call(null,inst_20395,inst_20394);
var inst_20397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20398 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_20396);
var inst_20399 = [inst_20398,r];
var inst_20400 = (new cljs.core.PersistentVector(null,2,(5),inst_20397,inst_20399,null));
var state_20554__$1 = state_20554;
var statearr_20608_20705 = state_20554__$1;
(statearr_20608_20705[(2)] = inst_20400);

(statearr_20608_20705[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (34))){
var inst_20431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20432 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_20433 = [inst_20432,r];
var inst_20434 = (new cljs.core.PersistentVector(null,2,(5),inst_20431,inst_20433,null));
var state_20554__$1 = state_20554;
var statearr_20609_20706 = state_20554__$1;
(statearr_20609_20706[(2)] = inst_20434);

(statearr_20609_20706[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (17))){
var inst_20388 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20610_20707 = state_20554__$1;
(statearr_20610_20707[(2)] = inst_20388);

(statearr_20610_20707[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (3))){
var inst_20552 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20554__$1,inst_20552);
} else {
if((state_val_20555 === (12))){
var inst_20334 = (state_20554[(22)]);
var inst_20338 = (state_20554[(2)]);
var inst_20339 = fluree.db.util.async.throw_err.call(null,inst_20338);
var inst_20340 = [inst_20339,r];
var inst_20341 = (new cljs.core.PersistentVector(null,2,(5),inst_20334,inst_20340,null));
var state_20554__$1 = state_20554;
var statearr_20611_20708 = state_20554__$1;
(statearr_20611_20708[(2)] = inst_20341);

(statearr_20611_20708[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (2))){
var _ = (function (){var statearr_20612 = state_20554;
(statearr_20612[(4)] = cljs.core.cons.call(null,(5),(state_20554[(4)])));

return statearr_20612;
})();
var inst_20324 = cljs.core.map_QMARK_.call(null,clause);
var state_20554__$1 = state_20554;
if(inst_20324){
var statearr_20613_20709 = state_20554__$1;
(statearr_20613_20709[(1)] = (6));

} else {
var statearr_20614_20710 = state_20554__$1;
(statearr_20614_20710[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (66))){
var state_20554__$1 = state_20554;
var statearr_20615_20711 = state_20554__$1;
(statearr_20615_20711[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (23))){
var inst_20364 = (state_20554[(11)]);
var inst_20373 = (state_20554[(19)]);
var inst_20356 = inst_20364;
var inst_20357 = inst_20373;
var state_20554__$1 = (function (){var statearr_20617 = state_20554;
(statearr_20617[(15)] = inst_20357);

(statearr_20617[(18)] = inst_20356);

return statearr_20617;
})();
var statearr_20618_20712 = state_20554__$1;
(statearr_20618_20712[(2)] = null);

(statearr_20618_20712[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (47))){
var inst_20456 = (state_20554[(21)]);
var inst_20459 = (state_20554[(2)]);
var inst_20460 = fluree.db.util.async.throw_err.call(null,inst_20459);
var inst_20461 = [inst_20460,r];
var inst_20462 = (new cljs.core.PersistentVector(null,2,(5),inst_20456,inst_20461,null));
var state_20554__$1 = state_20554;
var statearr_20619_20713 = state_20554__$1;
(statearr_20619_20713[(2)] = inst_20462);

(statearr_20619_20713[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (35))){
var inst_20437 = (state_20554[(23)]);
var inst_20436 = cljs.core.count.call(null,clause);
var inst_20437__$1 = cljs.core._EQ_.call(null,(3),inst_20436);
var state_20554__$1 = (function (){var statearr_20620 = state_20554;
(statearr_20620[(23)] = inst_20437__$1);

return statearr_20620;
})();
if(inst_20437__$1){
var statearr_20621_20714 = state_20554__$1;
(statearr_20621_20714[(1)] = (37));

} else {
var statearr_20622_20715 = state_20554__$1;
(statearr_20622_20715[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (19))){
var inst_20357 = (state_20554[(15)]);
var inst_20382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20383 = [inst_20357,r];
var inst_20384 = (new cljs.core.PersistentVector(null,2,(5),inst_20382,inst_20383,null));
var state_20554__$1 = state_20554;
var statearr_20623_20716 = state_20554__$1;
(statearr_20623_20716[(2)] = inst_20384);

(statearr_20623_20716[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (57))){
var inst_20499 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_20554__$1 = state_20554;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20554__$1,(60),inst_20499);
} else {
if((state_val_20555 === (68))){
var inst_20504 = (state_20554[(7)]);
var inst_20503 = (state_20554[(8)]);
var inst_20521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20522 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_20503,res,inst_20504,fuel,max_fuel);
var state_20554__$1 = (function (){var statearr_20624 = state_20554;
(statearr_20624[(24)] = inst_20521);

return statearr_20624;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20554__$1,(71),inst_20522);
} else {
if((state_val_20555 === (11))){
var inst_20420 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20626_20717 = state_20554__$1;
(statearr_20626_20717[(2)] = inst_20420);

(statearr_20626_20717[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (9))){
var inst_20334 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20335 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20336 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_20335,res,fuel,max_fuel,opts);
var state_20554__$1 = (function (){var statearr_20627 = state_20554;
(statearr_20627[(22)] = inst_20334);

return statearr_20627;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20554__$1,(12),inst_20336);
} else {
if((state_val_20555 === (5))){
var _ = (function (){var statearr_20628 = state_20554;
(statearr_20628[(4)] = cljs.core.rest.call(null,(state_20554[(4)])));

return statearr_20628;
})();
var state_20554__$1 = state_20554;
var ex20625 = (state_20554__$1[(2)]);
var statearr_20629_20718 = state_20554__$1;
(statearr_20629_20718[(5)] = ex20625);


if((ex20625 instanceof Error)){
var statearr_20630_20719 = state_20554__$1;
(statearr_20630_20719[(1)] = (4));

(statearr_20630_20719[(5)] = null);

} else {
throw ex20625;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (14))){
var inst_20331 = (state_20554[(10)]);
var inst_20327 = (state_20554[(13)]);
var inst_20390 = inst_20331.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_20327);
var state_20554__$1 = state_20554;
if(cljs.core.truth_(inst_20390)){
var statearr_20631_20720 = state_20554__$1;
(statearr_20631_20720[(1)] = (25));

} else {
var statearr_20632_20721 = state_20554__$1;
(statearr_20632_20721[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (45))){
var inst_20464 = cljs.core.count.call(null,clause);
var inst_20465 = cljs.core._EQ_.call(null,(2),inst_20464);
var state_20554__$1 = state_20554;
if(inst_20465){
var statearr_20633_20722 = state_20554__$1;
(statearr_20633_20722[(1)] = (48));

} else {
var statearr_20634_20723 = state_20554__$1;
(statearr_20634_20723[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (53))){
var inst_20539 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20635_20724 = state_20554__$1;
(statearr_20635_20724[(2)] = inst_20539);

(statearr_20635_20724[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (26))){
var inst_20331 = (state_20554[(10)]);
var inst_20327 = (state_20554[(13)]);
var inst_20402 = inst_20331.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_20327);
var state_20554__$1 = state_20554;
if(cljs.core.truth_(inst_20402)){
var statearr_20636_20725 = state_20554__$1;
(statearr_20636_20725[(1)] = (28));

} else {
var statearr_20637_20726 = state_20554__$1;
(statearr_20637_20726[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (16))){
var inst_20363 = (state_20554[(12)]);
var inst_20356 = (state_20554[(18)]);
var inst_20362 = cljs.core.seq.call(null,inst_20356);
var inst_20363__$1 = cljs.core.first.call(null,inst_20362);
var inst_20364 = cljs.core.next.call(null,inst_20362);
var state_20554__$1 = (function (){var statearr_20638 = state_20554;
(statearr_20638[(11)] = inst_20364);

(statearr_20638[(12)] = inst_20363__$1);

return statearr_20638;
})();
if(cljs.core.truth_(inst_20363__$1)){
var statearr_20639_20727 = state_20554__$1;
(statearr_20639_20727[(1)] = (18));

} else {
var statearr_20640_20728 = state_20554__$1;
(statearr_20640_20728[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (38))){
var inst_20437 = (state_20554[(23)]);
var state_20554__$1 = state_20554;
var statearr_20641_20729 = state_20554__$1;
(statearr_20641_20729[(2)] = inst_20437);

(statearr_20641_20729[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (30))){
var inst_20414 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20642_20730 = state_20554__$1;
(statearr_20642_20730[(2)] = inst_20414);

(statearr_20642_20730[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (10))){
var inst_20331 = (state_20554[(10)]);
var inst_20327 = (state_20554[(13)]);
var inst_20343 = inst_20331.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_20327);
var state_20554__$1 = state_20554;
if(cljs.core.truth_(inst_20343)){
var statearr_20643_20731 = state_20554__$1;
(statearr_20643_20731[(1)] = (13));

} else {
var statearr_20644_20732 = state_20554__$1;
(statearr_20644_20732[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (18))){
var inst_20363 = (state_20554[(12)]);
var inst_20366 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_20363,q_map,vars,fuel,max_fuel,opts);
var state_20554__$1 = state_20554;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20554__$1,(21),inst_20366);
} else {
if((state_val_20555 === (52))){
var state_20554__$1 = state_20554;
var statearr_20645_20733 = state_20554__$1;
(statearr_20645_20733[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (67))){
var inst_20532 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20647_20734 = state_20554__$1;
(statearr_20647_20734[(2)] = inst_20532);

(statearr_20647_20734[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (71))){
var inst_20521 = (state_20554[(24)]);
var inst_20524 = (state_20554[(2)]);
var inst_20525 = fluree.db.util.async.throw_err.call(null,inst_20524);
var inst_20526 = [inst_20525,r];
var inst_20527 = (new cljs.core.PersistentVector(null,2,(5),inst_20521,inst_20526,null));
var state_20554__$1 = state_20554;
var statearr_20648_20735 = state_20554__$1;
(statearr_20648_20735[(2)] = inst_20527);

(statearr_20648_20735[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (42))){
var inst_20545 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20649_20736 = state_20554__$1;
(statearr_20649_20736[(2)] = inst_20545);

(statearr_20649_20736[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (37))){
var inst_20439 = cljs.core.second.call(null,clause);
var inst_20440 = cljs.core._EQ_.call(null,inst_20439,"rdf:type");
var state_20554__$1 = state_20554;
var statearr_20650_20737 = state_20554__$1;
(statearr_20650_20737[(2)] = inst_20440);

(statearr_20650_20737[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (63))){
var inst_20534 = (state_20554[(2)]);
var state_20554__$1 = state_20554;
var statearr_20651_20738 = state_20554__$1;
(statearr_20651_20738[(2)] = inst_20534);

(statearr_20651_20738[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (8))){
var inst_20549 = (state_20554[(2)]);
var _ = (function (){var statearr_20652 = state_20554;
(statearr_20652[(4)] = cljs.core.rest.call(null,(state_20554[(4)])));

return statearr_20652;
})();
var state_20554__$1 = state_20554;
var statearr_20653_20739 = state_20554__$1;
(statearr_20653_20739[(2)] = inst_20549);

(statearr_20653_20739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20555 === (49))){
var inst_20473 = cljs.core.count.call(null,clause);
var inst_20474 = cljs.core._EQ_.call(null,(1),inst_20473);
var state_20554__$1 = state_20554;
if(inst_20474){
var statearr_20654_20740 = state_20554__$1;
(statearr_20654_20740[(1)] = (51));

} else {
var statearr_20655_20741 = state_20554__$1;
(statearr_20655_20741[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20656 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20656[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__);

(statearr_20656[(1)] = (1));

return statearr_20656;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20554){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20554);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20657){var ex__2749__auto__ = e20657;
var statearr_20658_20742 = state_20554;
(statearr_20658_20742[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20554[(4)]))){
var statearr_20659_20743 = state_20554;
(statearr_20659_20743[(1)] = cljs.core.first.call(null,(state_20554[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20744 = state_20554;
state_20554 = G__20744;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__ = function(state_20554){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20660 = f__2769__auto__.call(null);
(statearr_20660[(6)] = c__2768__auto__);

return statearr_20660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__20746 = arguments.length;
switch (G__20746) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20826){
var state_val_20827 = (state_20826[(1)]);
if((state_val_20827 === (7))){
var inst_20821 = (state_20826[(2)]);
var _ = (function (){var statearr_20828 = state_20826;
(statearr_20828[(4)] = cljs.core.rest.call(null,(state_20826[(4)])));

return statearr_20828;
})();
var state_20826__$1 = state_20826;
var statearr_20829_20877 = state_20826__$1;
(statearr_20829_20877[(2)] = inst_20821);

(statearr_20829_20877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (20))){
var inst_20786 = (state_20826[(7)]);
var inst_20798 = (state_20826[(2)]);
var inst_20768 = inst_20786;
var inst_20769 = inst_20798;
var state_20826__$1 = (function (){var statearr_20830 = state_20826;
(statearr_20830[(8)] = inst_20768);

(statearr_20830[(9)] = inst_20769);

return statearr_20830;
})();
var statearr_20831_20878 = state_20826__$1;
(statearr_20831_20878[(2)] = null);

(statearr_20831_20878[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (1))){
var state_20826__$1 = state_20826;
var statearr_20832_20879 = state_20826__$1;
(statearr_20832_20879[(2)] = null);

(statearr_20832_20879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (24))){
var inst_20785 = (state_20826[(10)]);
var inst_20786 = (state_20826[(7)]);
var inst_20769 = (state_20826[(9)]);
var inst_20806 = fluree.db.query.analytical.inner_join.call(null,inst_20769,inst_20785);
var inst_20768 = inst_20786;
var inst_20769__$1 = inst_20806;
var state_20826__$1 = (function (){var statearr_20833 = state_20826;
(statearr_20833[(8)] = inst_20768);

(statearr_20833[(9)] = inst_20769__$1);

return statearr_20833;
})();
var statearr_20834_20880 = state_20826__$1;
(statearr_20834_20880[(2)] = null);

(statearr_20834_20880[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (4))){
var inst_20747 = (state_20826[(2)]);
var state_20826__$1 = state_20826;
var statearr_20836_20881 = state_20826__$1;
(statearr_20836_20881[(2)] = inst_20747);

(statearr_20836_20881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (15))){
var inst_20785 = (state_20826[(10)]);
var state_20826__$1 = state_20826;
if(cljs.core.truth_(inst_20785)){
var statearr_20837_20882 = state_20826__$1;
(statearr_20837_20882[(1)] = (18));

} else {
var statearr_20838_20883 = state_20826__$1;
(statearr_20838_20883[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (21))){
var inst_20786 = (state_20826[(7)]);
var inst_20769 = (state_20826[(9)]);
var tmp20835 = inst_20769;
var inst_20768 = inst_20786;
var inst_20769__$1 = tmp20835;
var state_20826__$1 = (function (){var statearr_20839 = state_20826;
(statearr_20839[(8)] = inst_20768);

(statearr_20839[(9)] = inst_20769__$1);

return statearr_20839;
})();
var statearr_20840_20884 = state_20826__$1;
(statearr_20840_20884[(2)] = null);

(statearr_20840_20884[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (13))){
var inst_20769 = (state_20826[(9)]);
var inst_20792 = cljs.core.dissoc.call(null,inst_20769,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_20793 = cljs.core.empty_QMARK_.call(null,inst_20792);
var state_20826__$1 = state_20826;
if(inst_20793){
var statearr_20841_20885 = state_20826__$1;
(statearr_20841_20885[(1)] = (15));

} else {
var statearr_20842_20886 = state_20826__$1;
(statearr_20842_20886[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (22))){
var state_20826__$1 = state_20826;
var statearr_20843_20887 = state_20826__$1;
(statearr_20843_20887[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (6))){
var inst_20775 = (state_20826[(11)]);
var inst_20768 = (state_20826[(8)]);
var inst_20774 = cljs.core.seq.call(null,inst_20768);
var inst_20775__$1 = cljs.core.first.call(null,inst_20774);
var inst_20776 = cljs.core.next.call(null,inst_20774);
var state_20826__$1 = (function (){var statearr_20845 = state_20826;
(statearr_20845[(11)] = inst_20775__$1);

(statearr_20845[(12)] = inst_20776);

return statearr_20845;
})();
if(cljs.core.truth_(inst_20775__$1)){
var statearr_20846_20888 = state_20826__$1;
(statearr_20846_20888[(1)] = (8));

} else {
var statearr_20847_20889 = state_20826__$1;
(statearr_20847_20889[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (25))){
var state_20826__$1 = state_20826;
var statearr_20848_20890 = state_20826__$1;
(statearr_20848_20890[(2)] = null);

(statearr_20848_20890[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (17))){
var inst_20814 = (state_20826[(2)]);
var state_20826__$1 = state_20826;
var statearr_20849_20891 = state_20826__$1;
(statearr_20849_20891[(2)] = inst_20814);

(statearr_20849_20891[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (3))){
var inst_20824 = (state_20826[(2)]);
var state_20826__$1 = state_20826;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20826__$1,inst_20824);
} else {
if((state_val_20827 === (12))){
var inst_20785 = (state_20826[(10)]);
var inst_20786 = (state_20826[(7)]);
var inst_20768 = inst_20786;
var inst_20769 = inst_20785;
var state_20826__$1 = (function (){var statearr_20850 = state_20826;
(statearr_20850[(8)] = inst_20768);

(statearr_20850[(9)] = inst_20769);

return statearr_20850;
})();
var statearr_20851_20892 = state_20826__$1;
(statearr_20851_20892[(2)] = null);

(statearr_20851_20892[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (2))){
var _ = (function (){var statearr_20852 = state_20826;
(statearr_20852[(4)] = cljs.core.cons.call(null,(5),(state_20826[(4)])));

return statearr_20852;
})();
var inst_20760 = where;
var inst_20761 = cljs.core.seq.call(null,inst_20760);
var inst_20762 = cljs.core.first.call(null,inst_20761);
var inst_20763 = cljs.core.next.call(null,inst_20761);
var inst_20764 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20765 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_20766 = [inst_20765];
var inst_20767 = cljs.core.PersistentHashMap.fromArrays(inst_20764,inst_20766);
var inst_20768 = inst_20760;
var inst_20769 = inst_20767;
var state_20826__$1 = (function (){var statearr_20853 = state_20826;
(statearr_20853[(13)] = inst_20762);

(statearr_20853[(8)] = inst_20768);

(statearr_20853[(14)] = inst_20763);

(statearr_20853[(9)] = inst_20769);

return statearr_20853;
})();
var statearr_20854_20893 = state_20826__$1;
(statearr_20854_20893[(2)] = null);

(statearr_20854_20893[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (23))){
var inst_20812 = (state_20826[(2)]);
var state_20826__$1 = state_20826;
var statearr_20855_20894 = state_20826__$1;
(statearr_20855_20894[(2)] = inst_20812);

(statearr_20855_20894[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (19))){
var inst_20769 = (state_20826[(9)]);
var state_20826__$1 = state_20826;
var statearr_20856_20895 = state_20826__$1;
(statearr_20856_20895[(2)] = inst_20769);

(statearr_20856_20895[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (11))){
var inst_20775 = (state_20826[(11)]);
var inst_20783 = (state_20826[(2)]);
var inst_20784 = fluree.db.util.async.throw_err.call(null,inst_20783);
var inst_20785 = cljs.core.nth.call(null,inst_20784,(0),null);
var inst_20786 = cljs.core.nth.call(null,inst_20784,(1),null);
var inst_20787 = cljs.core.count.call(null,inst_20775);
var inst_20788 = cljs.core._EQ_.call(null,(2),inst_20787);
var state_20826__$1 = (function (){var statearr_20858 = state_20826;
(statearr_20858[(10)] = inst_20785);

(statearr_20858[(7)] = inst_20786);

return statearr_20858;
})();
if(inst_20788){
var statearr_20859_20896 = state_20826__$1;
(statearr_20859_20896[(1)] = (12));

} else {
var statearr_20860_20897 = state_20826__$1;
(statearr_20860_20897[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (9))){
var inst_20769 = (state_20826[(9)]);
var state_20826__$1 = state_20826;
var statearr_20861_20898 = state_20826__$1;
(statearr_20861_20898[(2)] = inst_20769);

(statearr_20861_20898[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (5))){
var _ = (function (){var statearr_20862 = state_20826;
(statearr_20862[(4)] = cljs.core.rest.call(null,(state_20826[(4)])));

return statearr_20862;
})();
var state_20826__$1 = state_20826;
var ex20857 = (state_20826__$1[(2)]);
var statearr_20863_20899 = state_20826__$1;
(statearr_20863_20899[(5)] = ex20857);


if((ex20857 instanceof Error)){
var statearr_20864_20900 = state_20826__$1;
(statearr_20864_20900[(1)] = (4));

(statearr_20864_20900[(5)] = null);

} else {
throw ex20857;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (14))){
var inst_20816 = (state_20826[(2)]);
var state_20826__$1 = state_20826;
var statearr_20865_20901 = state_20826__$1;
(statearr_20865_20901[(2)] = inst_20816);

(statearr_20865_20901[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (26))){
var inst_20810 = (state_20826[(2)]);
var state_20826__$1 = state_20826;
var statearr_20866_20902 = state_20826__$1;
(statearr_20866_20902[(2)] = inst_20810);

(statearr_20866_20902[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (16))){
var inst_20785 = (state_20826[(10)]);
var inst_20801 = (inst_20785 == null);
var state_20826__$1 = state_20826;
if(cljs.core.truth_(inst_20801)){
var statearr_20867_20903 = state_20826__$1;
(statearr_20867_20903[(1)] = (21));

} else {
var statearr_20868_20904 = state_20826__$1;
(statearr_20868_20904[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (10))){
var inst_20819 = (state_20826[(2)]);
var state_20826__$1 = state_20826;
var statearr_20869_20905 = state_20826__$1;
(statearr_20869_20905[(2)] = inst_20819);

(statearr_20869_20905[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (18))){
var inst_20785 = (state_20826[(10)]);
var state_20826__$1 = state_20826;
var statearr_20870_20906 = state_20826__$1;
(statearr_20870_20906[(2)] = inst_20785);

(statearr_20870_20906[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20827 === (8))){
var inst_20775 = (state_20826[(11)]);
var inst_20776 = (state_20826[(12)]);
var inst_20769 = (state_20826[(9)]);
var inst_20781 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_20769,inst_20775,inst_20776,false,fuel,max_fuel,opts);
var state_20826__$1 = state_20826;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20826__$1,(11),inst_20781);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2746__auto__ = null;
var fluree$db$query$analytical$state_machine__2746__auto____0 = (function (){
var statearr_20871 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20871[(0)] = fluree$db$query$analytical$state_machine__2746__auto__);

(statearr_20871[(1)] = (1));

return statearr_20871;
});
var fluree$db$query$analytical$state_machine__2746__auto____1 = (function (state_20826){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20826);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20872){var ex__2749__auto__ = e20872;
var statearr_20873_20907 = state_20826;
(statearr_20873_20907[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20826[(4)]))){
var statearr_20874_20908 = state_20826;
(statearr_20874_20908[(1)] = cljs.core.first.call(null,(state_20826[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20909 = state_20826;
state_20826 = G__20909;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2746__auto__ = function(state_20826){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2746__auto____1.call(this,state_20826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2746__auto____0;
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2746__auto____1;
return fluree$db$query$analytical$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20875 = f__2769__auto__.call(null);
(statearr_20875[(6)] = c__2768__auto__);

return statearr_20875;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20944){
var state_val_20945 = (state_20944[(1)]);
if((state_val_20945 === (7))){
var inst_20926 = (state_20944[(7)]);
var inst_20921 = (state_20944[(8)]);
var inst_20928 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_20921,inst_20926,fuel,max_fuel,opts);
var state_20944__$1 = state_20944;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20944__$1,(10),inst_20928);
} else {
if((state_val_20945 === (1))){
var state_20944__$1 = state_20944;
var statearr_20946_20971 = state_20944__$1;
(statearr_20946_20971[(2)] = null);

(statearr_20946_20971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20945 === (4))){
var inst_20910 = (state_20944[(2)]);
var state_20944__$1 = state_20944;
var statearr_20947_20972 = state_20944__$1;
(statearr_20947_20972[(2)] = inst_20910);

(statearr_20947_20972[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20945 === (13))){
var inst_20939 = (state_20944[(2)]);
var _ = (function (){var statearr_20948 = state_20944;
(statearr_20948[(4)] = cljs.core.rest.call(null,(state_20944[(4)])));

return statearr_20948;
})();
var state_20944__$1 = state_20944;
var statearr_20949_20973 = state_20944__$1;
(statearr_20949_20973[(2)] = inst_20939);

(statearr_20949_20973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20945 === (6))){
var inst_20921 = (state_20944[(8)]);
var inst_20925 = (state_20944[(2)]);
var inst_20926 = fluree.db.util.async.throw_err.call(null,inst_20925);
var state_20944__$1 = (function (){var statearr_20950 = state_20944;
(statearr_20950[(7)] = inst_20926);

return statearr_20950;
})();
if(cljs.core.truth_(inst_20921)){
var statearr_20951_20974 = state_20944__$1;
(statearr_20951_20974[(1)] = (7));

} else {
var statearr_20952_20975 = state_20944__$1;
(statearr_20952_20975[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20945 === (3))){
var inst_20942 = (state_20944[(2)]);
var state_20944__$1 = state_20944;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20944__$1,inst_20942);
} else {
if((state_val_20945 === (12))){
var inst_20934 = (state_20944[(9)]);
var state_20944__$1 = state_20944;
var statearr_20953_20976 = state_20944__$1;
(statearr_20953_20976[(2)] = inst_20934);

(statearr_20953_20976[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20945 === (2))){
var _ = (function (){var statearr_20954 = state_20944;
(statearr_20954[(4)] = cljs.core.cons.call(null,(5),(state_20944[(4)])));

return statearr_20954;
})();
var inst_20917 = q_map;
var inst_20918 = cljs.core.__destructure_map.call(null,inst_20917);
var inst_20919 = cljs.core.get.call(null,inst_20918,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_20920 = cljs.core.get.call(null,inst_20918,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_20921 = cljs.core.get.call(null,inst_20918,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_20922 = cljs.core.get.call(null,inst_20918,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_20923 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_20920,q_map,inst_20919,fuel,max_fuel,opts);
var state_20944__$1 = (function (){var statearr_20955 = state_20944;
(statearr_20955[(8)] = inst_20921);

(statearr_20955[(10)] = inst_20922);

return statearr_20955;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20944__$1,(6),inst_20923);
} else {
if((state_val_20945 === (11))){
var inst_20922 = (state_20944[(10)]);
var inst_20934 = (state_20944[(9)]);
var inst_20936 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_20934,inst_20922,null);
var state_20944__$1 = state_20944;
var statearr_20957_20977 = state_20944__$1;
(statearr_20957_20977[(2)] = inst_20936);

(statearr_20957_20977[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20945 === (9))){
var inst_20922 = (state_20944[(10)]);
var inst_20934 = (state_20944[(2)]);
var state_20944__$1 = (function (){var statearr_20958 = state_20944;
(statearr_20958[(9)] = inst_20934);

return statearr_20958;
})();
if(cljs.core.truth_(inst_20922)){
var statearr_20959_20978 = state_20944__$1;
(statearr_20959_20978[(1)] = (11));

} else {
var statearr_20960_20979 = state_20944__$1;
(statearr_20960_20979[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20945 === (5))){
var _ = (function (){var statearr_20961 = state_20944;
(statearr_20961[(4)] = cljs.core.rest.call(null,(state_20944[(4)])));

return statearr_20961;
})();
var state_20944__$1 = state_20944;
var ex20956 = (state_20944__$1[(2)]);
var statearr_20962_20980 = state_20944__$1;
(statearr_20962_20980[(5)] = ex20956);


if((ex20956 instanceof Error)){
var statearr_20963_20981 = state_20944__$1;
(statearr_20963_20981[(1)] = (4));

(statearr_20963_20981[(5)] = null);

} else {
throw ex20956;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20945 === (10))){
var inst_20930 = (state_20944[(2)]);
var inst_20931 = fluree.db.util.async.throw_err.call(null,inst_20930);
var state_20944__$1 = state_20944;
var statearr_20964_20982 = state_20944__$1;
(statearr_20964_20982[(2)] = inst_20931);

(statearr_20964_20982[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20945 === (8))){
var inst_20926 = (state_20944[(7)]);
var state_20944__$1 = state_20944;
var statearr_20965_20983 = state_20944__$1;
(statearr_20965_20983[(2)] = inst_20926);

(statearr_20965_20983[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2746__auto____0 = (function (){
var statearr_20966 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20966[(0)] = fluree$db$query$analytical$q_$_state_machine__2746__auto__);

(statearr_20966[(1)] = (1));

return statearr_20966;
});
var fluree$db$query$analytical$q_$_state_machine__2746__auto____1 = (function (state_20944){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20944);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20967){var ex__2749__auto__ = e20967;
var statearr_20968_20984 = state_20944;
(statearr_20968_20984[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20944[(4)]))){
var statearr_20969_20985 = state_20944;
(statearr_20969_20985[(1)] = cljs.core.first.call(null,(state_20944[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20986 = state_20944;
state_20944 = G__20986;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2746__auto__ = function(state_20944){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2746__auto____1.call(this,state_20944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2746__auto____0;
fluree$db$query$analytical$q_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20970 = f__2769__auto__.call(null);
(statearr_20970[(6)] = c__2768__auto__);

return statearr_20970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
