// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_parse');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.subject_crawl.legacy');
goog.require('fluree.db.query.subject_crawl.reparse');
fluree.db.query.analytical_parse.read_str_fn = cljs.reader.read_string;
fluree.db.query.analytical_parse.safe_read_fn = (function fluree$db$query$analytical_parse$safe_read_fn(code_str){
if(typeof code_str === 'string'){
} else {
throw cljs.core.ex_info.call(null,code_str.call(null,"Invalid function: ",code_str),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

try{var code_str_STAR_ = ((clojure.string.starts_with_QMARK_.call(null,code_str,"#"))?cljs.core.subs.call(null,code_str,(1)):code_str);
var res = fluree.db.query.analytical_parse.read_str_fn.call(null,code_str_STAR_);
if(cljs.core.list_QMARK_.call(null,res)){
} else {
throw cljs.core.ex_info.call(null,code_str.call(null,"Invalid function: ",code_str),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return res;
}catch (e17897){var e = e17897;
fluree.db.util.log.warn.call(null,"Invalid query function attempted: ",code_str," with error message: ",cljs.core.ex_message.call(null,e));

throw cljs.core.ex_info.call(null,code_str.call(null,"Invalid query function: ",code_str),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}});
fluree.db.query.analytical_parse.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical_parse$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical_parse$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical_parse$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__17903 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__17903 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__17903;
}
});
var variance = (function fluree$db$query$analytical_parse$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__4652__auto__ = (function fluree$db$query$analytical_parse$variance_$_iter__17904(s__17905){
return (new cljs.core.LazySeq(null,(function (){
var s__17905__$1 = s__17905;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__17905__$1);
if(temp__5804__auto__){
var s__17905__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17905__$2)){
var c__4650__auto__ = cljs.core.chunk_first.call(null,s__17905__$2);
var size__4651__auto__ = cljs.core.count.call(null,c__4650__auto__);
var b__17907 = cljs.core.chunk_buffer.call(null,size__4651__auto__);
if((function (){var i__17906 = (0);
while(true){
if((i__17906 < size__4651__auto__)){
var x = cljs.core._nth.call(null,c__4650__auto__,i__17906);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__17907,(delta * delta));

var G__17908 = (i__17906 + (1));
i__17906 = G__17908;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17907),fluree$db$query$analytical_parse$variance_$_iter__17904.call(null,cljs.core.chunk_rest.call(null,s__17905__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17907),null);
}
} else {
var x = cljs.core.first.call(null,s__17905__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical_parse$variance_$_iter__17904.call(null,cljs.core.rest.call(null,s__17905__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical_parse$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4336__auto__ = n;
var y__4337__auto__ = (- n);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
}),(function() {
var G__17909 = null;
var G__17909__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__17909__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__17909 = function(n,coll){
switch(arguments.length){
case 1:
return G__17909__1.call(this,n);
case 2:
return G__17909__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17909.cljs$core$IFn$_invoke$arity$1 = G__17909__1;
G__17909.cljs$core$IFn$_invoke$arity$2 = G__17909__2;
return G__17909;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__17910 = null;
var G__17910__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__17910__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__17910 = function(n,coll){
switch(arguments.length){
case 1:
return G__17910__1.call(this,n);
case 2:
return G__17910__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17910.cljs$core$IFn$_invoke$arity$1 = G__17910__1;
G__17910.cljs$core$IFn$_invoke$arity$2 = G__17910__2;
return G__17910;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__17911 = null;
var G__17911__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__17911__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__17911 = function(n,coll){
switch(arguments.length){
case 1:
return G__17911__1.call(this,n);
case 2:
return G__17911__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17911.cljs$core$IFn$_invoke$arity$1 = G__17911__1;
G__17911.cljs$core$IFn$_invoke$arity$2 = G__17911__2;
return G__17911;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
/**
 * Aggregate as positioned in a :select statement
 */
fluree.db.query.analytical_parse.aggregate_QMARK_ = (function fluree$db$query$analytical_parse$aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
/**
 * Query function as positioned in a :where statement
 */
fluree.db.query.analytical_parse.query_fn_QMARK_ = (function fluree$db$query$analytical_parse$query_fn_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
/**
 * Returns a query variable as a symbol, else nil if not a query variable.
 */
fluree.db.query.analytical_parse.q_var__GT_symbol = (function fluree$db$query$analytical_parse$q_var__GT_symbol(x){
if((((x instanceof cljs.core.Keyword)) || (((((typeof x === 'string') && (cljs.core._EQ_.call(null,"?",cljs.core.first.call(null,x))))) || ((((x instanceof cljs.core.Symbol)) && (cljs.core._EQ_.call(null,"?",cljs.core.first.call(null,cljs.core.name.call(null,x)))))))))){
return cljs.core.symbol.call(null,x);
} else {
return null;
}
});
/**
 * Returns as var symbol if 'as' function is used in an aggregate,
 *   e.g. (as (sum ?nums) ?sum).
 * 
 *   Checks that has 3 elements to the form, and the last element
 *   is a symbol that starts with a '?'. Else will throw.
 */
fluree.db.query.analytical_parse.extract_aggregate_as = (function fluree$db$query$analytical_parse$extract_aggregate_as(as_fn_parsed){
if(((cljs.core._EQ_.call(null,(3),cljs.core.count.call(null,as_fn_parsed))) && ((cljs.core.last.call(null,as_fn_parsed) instanceof cljs.core.Symbol)))){
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate function using 'as': ",cljs.core.pr_str.call(null,as_fn_parsed)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return cljs.core.last.call(null,as_fn_parsed);
});
fluree.db.query.analytical_parse.parse_aggregate = (function fluree$db$query$analytical_parse$parse_aggregate(aggregate_fn_str){
var list_agg = fluree.db.query.analytical_parse.safe_read_fn.call(null,aggregate_fn_str);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var func_list = ((as_QMARK_)?cljs.core.second.call(null,list_agg):list_agg);
var _ = ((cljs.core.coll_QMARK_.call(null,func_list))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aggregate_fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var list_count = cljs.core.count.call(null,func_list);
var vec__17912 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aggregate_fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aggregate_fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__17912,(0),null);
var arg = cljs.core.nth.call(null,vec__17912,(1),null);
var var$ = cljs.core.nth.call(null,vec__17912,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = fluree.db.query.analytical_parse.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aggregate_fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__17915 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__17915,(0),null);
var variable = cljs.core.nth.call(null,vec__17915,(1),null);
var as = ((as_QMARK_)?fluree.db.query.analytical_parse.extract_aggregate_as.call(null,list_agg):cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fun)].join('')));
if((((variable instanceof cljs.core.Symbol)) && (cljs.core._EQ_.call(null,"?",cljs.core.first.call(null,cljs.core.name.call(null,variable)))))){
} else {
throw cljs.core.ex_info.call(null,["Variables used in aggregate functions must start with a '?'. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aggregate_fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),aggregate_fn_str,new cljs.core.Keyword(null,"function","function",-2127255473),agg_fn__$1], null);
});
/**
 * Returns true if provided variable exists as a variable
 *   somewhere within the where clause.
 */
fluree.db.query.analytical_parse.variable_in_where_QMARK_ = (function fluree$db$query$analytical_parse$variable_in_where_QMARK_(variable,where){
return cljs.core.some.call(null,(function (p__17919){
var map__17920 = p__17919;
var map__17920__$1 = cljs.core.__destructure_map.call(null,map__17920);
var _where_smt = map__17920__$1;
var o = cljs.core.get.call(null,map__17920__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var optional = cljs.core.get.call(null,map__17920__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
var bind = cljs.core.get.call(null,map__17920__$1,new cljs.core.Keyword(null,"bind","bind",-113428417));
var union = cljs.core.get.call(null,map__17920__$1,new cljs.core.Keyword(null,"union","union",2142937499));
if(cljs.core.truth_(o)){
return cljs.core._EQ_.call(null,variable,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
} else {
if(cljs.core.truth_(optional)){
return cljs.core.map.call(null,(function (p1__17918_SHARP_){
return fluree.db.query.analytical_parse.variable_in_where_QMARK_.call(null,variable,p1__17918_SHARP_);
}),optional);
} else {
if(cljs.core.truth_(bind)){
return cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,cljs.core.keys.call(null,bind)),variable);
} else {
if(cljs.core.truth_(union)){
var or__4253__auto__ = fluree.db.query.analytical_parse.variable_in_where_QMARK_.call(null,variable,cljs.core.first.call(null,union));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.query.analytical_parse.variable_in_where_QMARK_.call(null,variable,cljs.core.second.call(null,union));
}
} else {
return null;
}
}
}
}
}),where);
});
fluree.db.query.analytical_parse.parse_map = (function fluree$db$query$analytical_parse$parse_map(select_map){
var vec__17921 = cljs.core.first.call(null,select_map);
var var$ = cljs.core.nth.call(null,vec__17921,(0),null);
var selection = cljs.core.nth.call(null,vec__17921,(1),null);
var var_as_symbol = fluree.db.query.analytical_parse.q_var__GT_symbol.call(null,var$);
if(((cljs.core.not_EQ_.call(null,(1),cljs.core.count.call(null,select_map))) || ((var_as_symbol == null)))){
throw cljs.core.ex_info.call(null,["Invalid select statement, maps must have only one key/val. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_map)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),selection], null);
});
fluree.db.query.analytical_parse.parse_select = (function fluree$db$query$analytical_parse$parse_select(select_smt){
var _ = (function (){var or__4253__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__17924_SHARP_){
return ((typeof p1__17924_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__17924_SHARP_)));
}),select_smt);
if(or__4253__auto__){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
return cljs.core.map.call(null,(function (select){
var var_symbol = fluree.db.query.analytical_parse.q_var__GT_symbol.call(null,select);
if(cljs.core.truth_(var_symbol)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical_parse.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical_parse.parse_aggregate.call(null,select);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.analytical_parse.parse_map.call(null,select);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}),select_smt);
});
fluree.db.query.analytical_parse.add_select_spec = (function fluree$db$query$analytical_parse$add_select_spec(p__17927,p__17928){
var map__17929 = p__17927;
var map__17929__$1 = cljs.core.__destructure_map.call(null,map__17929);
var parsed_query = map__17929__$1;
var group_by = cljs.core.get.call(null,map__17929__$1,new cljs.core.Keyword(null,"group-by","group-by",-379139802));
var order_by = cljs.core.get.call(null,map__17929__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var limit = cljs.core.get.call(null,map__17929__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__17929__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var pretty_print = cljs.core.get.call(null,map__17929__$1,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var map__17930 = p__17928;
var map__17930__$1 = cljs.core.__destructure_map.call(null,map__17930);
var _query_map_SINGLEQUOTE_ = map__17930__$1;
var selectOne = cljs.core.get.call(null,map__17930__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.call(null,map__17930__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.call(null,map__17930__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.call(null,map__17930__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var opts = cljs.core.get.call(null,map__17930__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var orderBy = cljs.core.get.call(null,map__17930__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var groupBy = cljs.core.get.call(null,map__17930__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var select_smt = (function (){var or__4253__auto__ = selectOne;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = select;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var selectOne_QMARK_ = cljs.core.boolean$.call(null,selectOne);
var limit_STAR_ = ((selectOne_QMARK_)?(1):limit);
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.analytical_parse.parse_select.call(null,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__17925_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__17925_SHARP_,new cljs.core.Keyword(null,"function","function",-2127255473));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__17926_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__17926_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var orderBy_STAR_ = (function (){var temp__5804__auto__ = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return orderBy;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var orderBy__$1 = temp__5804__auto__;
if(cljs.core.truth_((function (){var or__4253__auto__ = typeof orderBy__$1 === 'string';
if(or__4253__auto__){
return or__4253__auto__;
} else {
var and__4251__auto__ = cljs.core.vector_QMARK_.call(null,orderBy__$1);
if(and__4251__auto__){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy__$1));
} else {
return and__4251__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy__$1)){
return orderBy__$1;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy__$1], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.assoc.call(null,parsed_query,new cljs.core.Keyword(null,"limit","limit",-1355822363),limit_STAR_,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),selectOne_QMARK_,new cljs.core.Keyword(null,"select","select",1147833503),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(opts),limit_STAR_,(function (){var or__4253__auto__ = offset;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),cljs.core.not_empty.call(null,aggregates),selectOne_QMARK_,pretty_print,(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return groupBy;
}
})(),cljs.core.boolean$.call(null,(function (){var or__4253__auto__ = selectDistinct;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy_STAR_,inVector_QMARK_]));
});
/**
 * Turns keys of var maps into symbols
 */
fluree.db.query.analytical_parse.symbolize_var_keys = (function fluree$db$query$analytical_parse$symbolize_var_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Adds a valid filter fn into the respective where statement(s).
 *   If the filter fn uses a var not found in a where statement, throws
 *   an exception
 */
fluree.db.query.analytical_parse.add_filter_where = (function fluree$db$query$analytical_parse$add_filter_where(where,p__17931){
var map__17932 = p__17931;
var map__17932__$1 = cljs.core.__destructure_map.call(null,map__17932);
var filter_fn_map = map__17932__$1;
var variable = cljs.core.get.call(null,map__17932__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var G__17937 = where;
var vec__17938 = G__17937;
var seq__17939 = cljs.core.seq.call(null,vec__17938);
var first__17940 = cljs.core.first.call(null,seq__17939);
var seq__17939__$1 = cljs.core.next.call(null,seq__17939);
var map__17941 = first__17940;
var map__17941__$1 = cljs.core.__destructure_map.call(null,map__17941);
var where_smt = map__17941__$1;
var o = cljs.core.get.call(null,map__17941__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var r = seq__17939__$1;
var found_var_QMARK_ = false;
var where_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__17937__$1 = G__17937;
var found_var_QMARK___$1 = found_var_QMARK_;
var where_STAR___$1 = where_STAR_;
while(true){
var vec__17946 = G__17937__$1;
var seq__17947 = cljs.core.seq.call(null,vec__17946);
var first__17948 = cljs.core.first.call(null,seq__17947);
var seq__17947__$1 = cljs.core.next.call(null,seq__17947);
var map__17949 = first__17948;
var map__17949__$1 = cljs.core.__destructure_map.call(null,map__17949);
var where_smt__$1 = map__17949__$1;
var o__$1 = cljs.core.get.call(null,map__17949__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var r__$1 = seq__17947__$1;
var found_var_QMARK___$2 = found_var_QMARK___$1;
var where_STAR___$2 = where_STAR___$1;
if(cljs.core.truth_(where_smt__$1)){
var match_QMARK_ = cljs.core._EQ_.call(null,variable,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o__$1));
if(match_QMARK_){
var G__17950 = r__$1;
var G__17951 = true;
var G__17952 = cljs.core.conj.call(null,where_STAR___$2,cljs.core.assoc.call(null,where_smt__$1,new cljs.core.Keyword(null,"o","o",-1350007228),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"filter","filter",-948537934),filter_fn_map], null)));
G__17937__$1 = G__17950;
found_var_QMARK___$1 = G__17951;
where_STAR___$1 = G__17952;
continue;
} else {
var G__17953 = r__$1;
var G__17954 = found_var_QMARK___$2;
var G__17955 = cljs.core.conj.call(null,where_STAR___$2,where_smt__$1);
G__17937__$1 = G__17953;
found_var_QMARK___$1 = G__17954;
where_STAR___$1 = G__17955;
continue;
}
} else {
if(found_var_QMARK___$2){
return where_STAR___$2;
} else {
throw cljs.core.ex_info.call(null,["Filter function uses variable: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable)," however that variable is not used in a where statement ","or was already used in another filter function."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}
break;
}
});
/**
 * Returns a set of valid vars.
 */
fluree.db.query.analytical_parse.get_vars = (function fluree$db$query$analytical_parse$get_vars(code){
return cljs.core.reduce.call(null,(function (acc,code_segment){
if(cljs.core.coll_QMARK_.call(null,code_segment)){
return cljs.core.into.call(null,acc,fluree.db.query.analytical_parse.get_vars.call(null,code_segment));
} else {
var temp__5802__auto__ = fluree.db.query.analytical_parse.q_var__GT_symbol.call(null,code_segment);
if(cljs.core.truth_(temp__5802__auto__)){
var allowed_var = temp__5802__auto__;
return cljs.core.conj.call(null,acc,allowed_var);
} else {
return acc;
}
}
}),cljs.core.PersistentHashSet.EMPTY,code);
});
/**
 * Returns the var that will represent flake/o when passed in a flake to execute filter fn.
 * 
 *   There can be multiple vars in the filter function which can utilize the original query's 'vars' map,
 *   however there should be exactly one var in the filter fn that isn't in that map - which should be the
 *   var that will receive flake/o.
 */
fluree.db.query.analytical_parse.get_object_var = (function fluree$db$query$analytical_parse$get_object_var(params,supplied_vars){
var non_assigned_vars = cljs.core.remove.call(null,(function (p1__17956_SHARP_){
return cljs.core.contains_QMARK_.call(null,supplied_vars,p1__17956_SHARP_);
}),params);
var G__17957 = cljs.core.count.call(null,non_assigned_vars);
switch (G__17957) {
case (1):
return cljs.core.first.call(null,non_assigned_vars);

break;
case (0):
throw cljs.core.ex_info.call(null,["Query filter function has no variable assigned to it, all parameters ","exist in the 'vars' map. Filter function params: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(params),". ","Vars assigned in query: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.vec.call(null,cljs.core.keys.call(null,supplied_vars))),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

break;
default:
throw cljs.core.ex_info.call(null,["Vars used in a filter function are not included in the 'vars' map ","or as a binding. Should only be missing one var, but missing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.vec.call(null,non_assigned_vars)),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
});
/**
 * Evals, and returns query function.
 */
fluree.db.query.analytical_parse.parse_filter_fn = (function fluree$db$query$analytical_parse$parse_filter_fn(filter_fn,supplied_vars){
var filter_code = fluree.db.query.analytical_parse.safe_read_fn.call(null,filter_fn);
var fn_vars = (function (){var or__4253__auto__ = cljs.core.not_empty.call(null,fluree.db.query.analytical_parse.get_vars.call(null,filter_code));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var params = cljs.core.vec.call(null,fn_vars);
var o_var = fluree.db.query.analytical_parse.get_object_var.call(null,params,supplied_vars);
var vec__17959 = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code,fn_vars);
var fun = cljs.core.nth.call(null,vec__17959,(0),null);
var _ = cljs.core.nth.call(null,vec__17959,(1),null);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),o_var,new cljs.core.Keyword(null,"params","params",710516235),params,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),["(fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(params)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fun)].join(''),new cljs.core.Keyword(null,"function","function",-2127255473),fluree.db.query.analytical_filter.make_executable.call(null,params,fun)], null);
});
fluree.db.query.analytical_parse.add_filter = (function fluree$db$query$analytical_parse$add_filter(p__17962,filter,supplied_vars){
var map__17963 = p__17962;
var map__17963__$1 = cljs.core.__destructure_map.call(null,map__17963);
var parsed_query = map__17963__$1;
var where = cljs.core.get.call(null,map__17963__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
if((!(cljs.core.sequential_QMARK_.call(null,filter)))){
throw cljs.core.ex_info.call(null,["Filter clause must be a vector/array, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var G__17967 = filter;
var vec__17968 = G__17967;
var seq__17969 = cljs.core.seq.call(null,vec__17968);
var first__17970 = cljs.core.first.call(null,seq__17969);
var seq__17969__$1 = cljs.core.next.call(null,seq__17969);
var filter_fn = first__17970;
var r = seq__17969__$1;
var parsed_query_STAR_ = parsed_query;
var G__17967__$1 = G__17967;
var parsed_query_STAR___$1 = parsed_query_STAR_;
while(true){
var vec__17974 = G__17967__$1;
var seq__17975 = cljs.core.seq.call(null,vec__17974);
var first__17976 = cljs.core.first.call(null,seq__17975);
var seq__17975__$1 = cljs.core.next.call(null,seq__17975);
var filter_fn__$1 = first__17976;
var r__$1 = seq__17975__$1;
var parsed_query_STAR___$2 = parsed_query_STAR___$1;
if(cljs.core.truth_(filter_fn__$1)){
var parsed = fluree.db.query.analytical_parse.parse_filter_fn.call(null,filter_fn__$1,supplied_vars);
var G__17977 = r__$1;
var G__17978 = cljs.core.assoc.call(null,parsed_query_STAR___$2,new cljs.core.Keyword(null,"where","where",-2044795965),fluree.db.query.analytical_parse.add_filter_where.call(null,where,parsed));
G__17967__$1 = G__17977;
parsed_query_STAR___$1 = G__17978;
continue;
} else {
return parsed_query_STAR___$2;
}
break;
}
}
});
/**
 * Parses binding map. Returns a two-tuple of binding maps
 *   including aggregates and scalars, for bindings that are
 *   aggregate functions vs static scalar values.
 * 
 *   Scalars end up getting hoisted, and essentially merged
 *   with query :vars - this way filter functions that get
 *   merged into their respective where statements will have
 *   the variable available to them.
 */
fluree.db.query.analytical_parse.parse_binding = (function fluree$db$query$analytical_parse$parse_binding(bind_map){
return cljs.core.reduce_kv.call(null,(function (p__17979,k,v){
var vec__17980 = p__17979;
var aggregates = cljs.core.nth.call(null,vec__17980,(0),null);
var scalars = cljs.core.nth.call(null,vec__17980,(1),null);
if(cljs.core.truth_(fluree.db.query.analytical_parse.query_fn_QMARK_.call(null,v))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,aggregates,k,fluree.db.query.analytical_parse.parse_aggregate.call(null,v)),scalars], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [aggregates,cljs.core.assoc.call(null,scalars,k,v)], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY], null),bind_map);
});
/**
 * When a where clause is a map, parses it into accumulating parsed where.
 *   Note parsed-where is not complete, but only has where clauses parsed that
 *   preceded the map clause.
 * 
 *   Returns a two-tuple of where-map type (i.e. :filter, :bind, :union .. etc.) and
 *   updated where clause. Updates where clause because a filter function may impact
 *   a prior where statement.
 *   
 */
fluree.db.query.analytical_parse.parse_where_map = (function fluree$db$query$analytical_parse$parse_where_map(db,parsed_where,map_clause,supplied_vars){
if(cljs.core.not_EQ_.call(null,(1),cljs.core.count.call(null,map_clause))){
throw cljs.core.ex_info.call(null,["Where clause maps can only have one key/val, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(map_clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

var vec__17984 = cljs.core.first.call(null,map_clause);
var clause_type = cljs.core.nth.call(null,vec__17984,(0),null);
var clause_val = cljs.core.nth.call(null,vec__17984,(1),null);
var G__17987 = clause_type;
var G__17987__$1 = (((G__17987 instanceof cljs.core.Keyword))?G__17987.fqn:null);
switch (G__17987__$1) {
case "filter":
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"filter","filter",-948537934),clause_val], null);

break;
case "optional":
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"optional","optional",2053951509),new cljs.core.Keyword(null,"where","where",-2044795965),fluree.db.query.analytical_parse.parse_where.call(null,db,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"where","where",-2044795965),clause_val], null),supplied_vars)], null);

break;
case "union":
if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,clause_val))){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"union","union",2142937499),new cljs.core.Keyword(null,"where","where",-2044795965),cljs.core.mapv.call(null,(function (p1__17983_SHARP_){
return fluree.db.query.analytical_parse.parse_where.call(null,db,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"where","where",-2044795965),p1__17983_SHARP_], null),supplied_vars);
}),clause_val)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid where clause, 'union' clause must have exactly two solutions. ","Each solution must be its own 'where' clause wrapped in a vector"].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

break;
case "bind":
if(cljs.core.map_QMARK_.call(null,clause_val)){
var bind_map = fluree.db.query.analytical_parse.symbolize_var_keys.call(null,clause_val);
var vec__17988 = fluree.db.query.analytical_parse.parse_binding.call(null,bind_map);
var aggregates = cljs.core.nth.call(null,vec__17988,(0),null);
var scalars = cljs.core.nth.call(null,vec__17988,(1),null);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"bind","bind",-113428417),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),aggregates,new cljs.core.Keyword(null,"scalars","scalars",-350192527),scalars], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid where clause, 'bind' must be a map with binding vars as keys ","and binding scalars, or aggregates, as values."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

break;
case "minus":
throw cljs.core.ex_info.call(null,"Invalid where clause, Fluree does not yet support the 'minus' operation.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

break;
default:
throw cljs.core.ex_info.call(null,["Invalid where clause, unsupported where clause operation: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause_type)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
});
/**
 * Parses a two-tuple variable binding where clause
 */
fluree.db.query.analytical_parse.parse_binding_tuple = (function fluree$db$query$analytical_parse$parse_binding_tuple(binding_var,binding_val){
var var$ = fluree.db.query.analytical_parse.q_var__GT_symbol.call(null,binding_var);
var fn_QMARK_ = fluree.db.query.analytical_parse.query_fn_QMARK_.call(null,binding_val);
if(cljs.core.truth_(fn_QMARK_)){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword(null,"variable","variable",-281346492),var$,new cljs.core.Keyword(null,"fn","fn",-1175266204),binding_val], null);
} else {
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword(null,"variable","variable",-281346492),var$,new cljs.core.Keyword(null,"value","value",305978217),binding_val], null);
}
});
/**
 * For both 's' and 'o', returns a map with respective value
 *   that indicates the value's type and if needed other information.
 * 
 * 
 *   'o' values have special handling before calling this function as they can
 *   also have 'tag' values or query-functions.
 */
fluree.db.query.analytical_parse.value_type_map = (function fluree$db$query$analytical_parse$value_type_map(value){
if(fluree.db.util.core.pred_ident_QMARK_.call(null,value)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ident","ident",-742346),value], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical_parse.q_var__GT_symbol.call(null,value))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),fluree.db.query.analytical_parse.q_var__GT_symbol.call(null,value)], null);
} else {
if((value == null)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),value], null);

}
}
}
});
/**
 * Parses where clause tuples (not maps)
 */
fluree.db.query.analytical_parse.parse_where_tuple = (function fluree$db$query$analytical_parse$parse_where_tuple(supplied_vars,db,s,p,o){
var fulltext_QMARK_ = clojure.string.starts_with_QMARK_.call(null,p,"fullText:");
var rdf_type_QMARK_ = ((cljs.core._EQ_.call(null,"rdf:type",p)) || (cljs.core._EQ_.call(null,"a",p)));
var _id_QMARK_ = cljs.core._EQ_.call(null,"_id",p);
var s_STAR_ = fluree.db.query.analytical_parse.value_type_map.call(null,s);
var p_STAR_ = ((fulltext_QMARK_)?(function(){throw cljs.core.ex_info.call(null,"Full text queries not supported in JavaScript currently.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((rdf_type_QMARK_)?new cljs.core.Keyword("rdf","type","rdf/type",1175423232):((_id_QMARK_)?new cljs.core.Keyword(null,"_id","_id",-789960287):(cljs.core.truth_(db)?(function (){var or__4253__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():p)
)));
var p_idx_QMARK_ = (cljs.core.truth_(p_STAR_)?fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p_STAR_):null);
var p_tag_QMARK_ = (cljs.core.truth_(p_STAR_)?cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p)):null);
var o_STAR_ = (cljs.core.truth_(p_tag_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),o], null):(cljs.core.truth_(fluree.db.query.analytical_parse.query_fn_QMARK_.call(null,o))?(function (){var parsed_filter_map = fluree.db.query.analytical_parse.parse_filter_fn.call(null,o,supplied_vars);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(parsed_filter_map),new cljs.core.Keyword(null,"filter","filter",-948537934),parsed_filter_map], null);
})():fluree.db.query.analytical_parse.value_type_map.call(null,o)
));
var idx = ((fulltext_QMARK_)?new cljs.core.Keyword(null,"full-text","full-text",1432444182):((((_id_QMARK_) || (rdf_type_QMARK_)))?new cljs.core.Keyword(null,"spot","spot",-1706962147):(cljs.core.truth_((function (){var and__4251__auto__ = s_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(s_STAR_));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword(null,"spot","spot",-1706962147):(cljs.core.truth_((function (){var and__4251__auto__ = p_idx_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o_STAR_);
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword(null,"post","post",269697687):(cljs.core.truth_(p)?(function (){
if(cljs.core.truth_(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o_STAR_))){
fluree.db.util.log.info.call(null,["Searching for a property value on unindexed predicate: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),". Consider making property indexed for improved performance ","and lower fuel consumption."].join(''));
} else {
}

return new cljs.core.Keyword(null,"psot","psot",2111653059);
})()
:(cljs.core.truth_(o)?new cljs.core.Keyword(null,"opst","opst",1213963058):(function(){throw cljs.core.ex_info.call(null,["Unable to determine query type for where statement: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [s,p,o], null)),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
))))));
return new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"type","type",1174270348),((fulltext_QMARK_)?new cljs.core.Keyword(null,"full-text","full-text",1432444182):((rdf_type_QMARK_)?new cljs.core.Keyword("rdf","type","rdf/type",1175423232):((_id_QMARK_)?new cljs.core.Keyword(null,"_id","_id",-789960287):new cljs.core.Keyword(null,"tuple","tuple",-472667284)
))),new cljs.core.Keyword(null,"idx","idx",1053688473),idx,new cljs.core.Keyword(null,"s","s",1705939918),s_STAR_,new cljs.core.Keyword(null,"p","p",151049309),p_STAR_,new cljs.core.Keyword(null,"o","o",-1350007228),o_STAR_,new cljs.core.Keyword(null,"p-tag?","p-tag?",2131007743),p_tag_QMARK_,new cljs.core.Keyword(null,"p-idx?","p-idx?",977503771),p_idx_QMARK_], null);
});
/**
 * When a specific DB is used (not default) for a where statement.
 *   This is in the form of a 4-tuple where clause.
 */
fluree.db.query.analytical_parse.parse_remote_tuple = (function fluree$db$query$analytical_parse$parse_remote_tuple(supplied_vars,db,s,p,o){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"remote-tuple","remote-tuple",-1236726618),new cljs.core.Keyword(null,"s","s",1705939918),s,new cljs.core.Keyword(null,"p","p",151049309),p,new cljs.core.Keyword(null,"o","o",-1350007228),o], null);
});
/**
 * Parses where clause
 */
fluree.db.query.analytical_parse.parse_where = (function fluree$db$query$analytical_parse$parse_where(db,p__17992,supplied_vars){
var map__17993 = p__17992;
var map__17993__$1 = cljs.core.__destructure_map.call(null,map__17993);
var _query_map_SINGLEQUOTE_ = map__17993__$1;
var where = cljs.core.get.call(null,map__17993__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
if(cljs.core.sequential_QMARK_.call(null,where)){
} else {
throw cljs.core.ex_info.call(null,["Invalid where clause, must be a vector of tuples and/or maps: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var G__17997 = where;
var vec__17998 = G__17997;
var seq__17999 = cljs.core.seq.call(null,vec__17998);
var first__18000 = cljs.core.first.call(null,seq__17999);
var seq__17999__$1 = cljs.core.next.call(null,seq__17999);
var where_smt = first__18000;
var r = seq__17999__$1;
var filters = cljs.core.PersistentVector.EMPTY;
var hoisted_bind = cljs.core.PersistentArrayMap.EMPTY;
var supplied_vars_STAR_ = supplied_vars;
var where_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__17997__$1 = G__17997;
var filters__$1 = filters;
var hoisted_bind__$1 = hoisted_bind;
var supplied_vars_STAR___$1 = supplied_vars_STAR_;
var where_STAR___$1 = where_STAR_;
while(true){
var vec__18008 = G__17997__$1;
var seq__18009 = cljs.core.seq.call(null,vec__18008);
var first__18010 = cljs.core.first.call(null,seq__18009);
var seq__18009__$1 = cljs.core.next.call(null,seq__18009);
var where_smt__$1 = first__18010;
var r__$1 = seq__18009__$1;
var filters__$2 = filters__$1;
var hoisted_bind__$2 = hoisted_bind__$1;
var supplied_vars_STAR___$2 = supplied_vars_STAR___$1;
var where_STAR___$2 = where_STAR___$1;
if(cljs.core.truth_(where_smt__$1)){
if(cljs.core.map_QMARK_.call(null,where_smt__$1)){
var map__18011 = fluree.db.query.analytical_parse.parse_where_map.call(null,db,where_STAR___$2,where_smt__$1,supplied_vars_STAR___$2);
var map__18011__$1 = cljs.core.__destructure_map.call(null,map__18011);
var where_map = map__18011__$1;
var type = cljs.core.get.call(null,map__18011__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var G__18012 = type;
var G__18012__$1 = (((G__18012 instanceof cljs.core.Keyword))?G__18012.fqn:null);
switch (G__18012__$1) {
case "bind":
var map__18013 = where_map;
var map__18013__$1 = cljs.core.__destructure_map.call(null,map__18013);
var aggregates = cljs.core.get.call(null,map__18013__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var scalars = cljs.core.get.call(null,map__18013__$1,new cljs.core.Keyword(null,"scalars","scalars",-350192527));
var G__18016 = r__$1;
var G__18017 = filters__$2;
var G__18018 = cljs.core.merge.call(null,hoisted_bind__$2,scalars);
var G__18019 = cljs.core.merge.call(null,supplied_vars_STAR___$2,aggregates,scalars);
var G__18020 = (cljs.core.truth_(cljs.core.not_empty.call(null,aggregates))?cljs.core.conj.call(null,where_STAR___$2,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"bind","bind",-113428417),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),aggregates], null)):where_STAR___$2);
G__17997__$1 = G__18016;
filters__$1 = G__18017;
hoisted_bind__$1 = G__18018;
supplied_vars_STAR___$1 = G__18019;
where_STAR___$1 = G__18020;
continue;

break;
case "filter":
var G__18021 = r__$1;
var G__18022 = cljs.core.conj.call(null,filters__$2,new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(where_map));
var G__18023 = hoisted_bind__$2;
var G__18024 = supplied_vars_STAR___$2;
var G__18025 = where_STAR___$2;
G__17997__$1 = G__18021;
filters__$1 = G__18022;
hoisted_bind__$1 = G__18023;
supplied_vars_STAR___$1 = G__18024;
where_STAR___$1 = G__18025;
continue;

break;
default:
var G__18026 = r__$1;
var G__18027 = filters__$2;
var G__18028 = hoisted_bind__$2;
var G__18029 = supplied_vars_STAR___$2;
var G__18030 = cljs.core.conj.call(null,where_STAR___$2,where_map);
G__17997__$1 = G__18026;
filters__$1 = G__18027;
hoisted_bind__$1 = G__18028;
supplied_vars_STAR___$1 = G__18029;
where_STAR___$1 = G__18030;
continue;

}
} else {
if(cljs.core.sequential_QMARK_.call(null,where_smt__$1)){
var tuple_count = cljs.core.count.call(null,where_smt__$1);
var where_smt_STAR_ = (function (){var G__18014 = tuple_count;
switch (G__18014) {
case (3):
return cljs.core.apply.call(null,fluree.db.query.analytical_parse.parse_where_tuple,supplied_vars_STAR___$2,db,where_smt__$1);

break;
case (4):
return cljs.core.apply.call(null,fluree.db.query.analytical_parse.parse_remote_tuple,supplied_vars_STAR___$2,where_smt__$1);

break;
case (2):
return cljs.core.apply.call(null,fluree.db.query.analytical_parse.parse_binding_tuple,where_smt__$1);

break;
default:
if(cljs.core.sequential_QMARK_.call(null,cljs.core.first.call(null,where_smt__$1))){
throw cljs.core.ex_info.call(null,["Invalid where clause, it should contain 2, 3 or 4 tuples. ","It appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where_smt__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
throw cljs.core.ex_info.call(null,["Invalid where clause, it should contain 2, 3 or 4 tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where_smt__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

}
})();
var G__18032 = r__$1;
var G__18033 = filters__$2;
var G__18034 = hoisted_bind__$2;
var G__18035 = supplied_vars_STAR___$2;
var G__18036 = cljs.core.conj.call(null,where_STAR___$2,where_smt_STAR_);
G__17997__$1 = G__18032;
filters__$1 = G__18033;
hoisted_bind__$1 = G__18034;
supplied_vars_STAR___$1 = G__18035;
where_STAR___$1 = G__18036;
continue;
} else {
throw cljs.core.ex_info.call(null,["Invalid where clause, must be a vector of tuples and/or maps: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
} else {
var where_PLUS_filters = ((cljs.core.seq.call(null,filters__$2))?cljs.core.reduce.call(null,((function (G__17997__$1,filters__$1,hoisted_bind__$1,supplied_vars_STAR___$1,where_STAR___$1,vec__18008,seq__18009,first__18010,seq__18009__$1,where_smt__$1,r__$1,filters__$2,hoisted_bind__$2,supplied_vars_STAR___$2,where_STAR___$2,G__17997,vec__17998,seq__17999,first__18000,seq__17999__$1,where_smt,r,filters,hoisted_bind,supplied_vars_STAR_,where_STAR_,map__17993,map__17993__$1,_query_map_SINGLEQUOTE_,where){
return (function (where_SINGLEQUOTE_,filter){
return new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(fluree.db.query.analytical_parse.add_filter.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"where","where",-2044795965),where_SINGLEQUOTE_], null),filter,supplied_vars_STAR___$2));
});})(G__17997__$1,filters__$1,hoisted_bind__$1,supplied_vars_STAR___$1,where_STAR___$1,vec__18008,seq__18009,first__18010,seq__18009__$1,where_smt__$1,r__$1,filters__$2,hoisted_bind__$2,supplied_vars_STAR___$2,where_STAR___$2,G__17997,vec__17998,seq__17999,first__18000,seq__17999__$1,where_smt,r,filters,hoisted_bind,supplied_vars_STAR_,where_STAR_,map__17993,map__17993__$1,_query_map_SINGLEQUOTE_,where))
,where_STAR___$2,filters__$2):where_STAR___$2);
if(cljs.core.truth_(cljs.core.not_empty.call(null,hoisted_bind__$2))){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"bind","bind",-113428417),new cljs.core.Keyword(null,"scalars","scalars",-350192527),hoisted_bind__$2], null)], null),where_PLUS_filters);
} else {
return where_PLUS_filters;
}
}
break;
}
});
/**
 * Returns query map without vars, to allow more effective caching of parsing.
 */
fluree.db.query.analytical_parse.extract_vars = (function fluree$db$query$analytical_parse$extract_vars(query_map){
return cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"vars","vars",-2046957217));
});
fluree.db.query.analytical_parse.parse_order_by = (function fluree$db$query$analytical_parse$parse_order_by(order_by_clause){
var throw_BANG_ = (function (msg){
throw cljs.core.ex_info.call(null,(function (){var or__4253__auto__ = msg;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return ["Invalid orderBy clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(order_by_clause)].join('');
}
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
var vec__18037 = ((cljs.core.vector_QMARK_.call(null,order_by_clause))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.second.call(null,order_by_clause),cljs.core.first.call(null,order_by_clause)], null):((typeof order_by_clause === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [order_by_clause,new cljs.core.Keyword(null,"asc","asc",356854569)], null):throw_BANG_.call(null,null)
));
var pred = cljs.core.nth.call(null,vec__18037,(0),null);
var order = cljs.core.nth.call(null,vec__18037,(1),null);
var order_STAR_ = (function (){var G__18040 = order;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"asc","asc",356854569),G__18040)){
return order;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"desc","desc",2093485764),G__18040)){
return order;
} else {
if(cljs.core._EQ_.call(null,"ASC",G__18040)){
return new cljs.core.Keyword(null,"asc","asc",356854569);
} else {
if(cljs.core._EQ_.call(null,"DESC",G__18040)){
return new cljs.core.Keyword(null,"desc","desc",2093485764);
} else {
return throw_BANG_.call(null,null);

}
}
}
}
})();
var pred_var = fluree.db.query.analytical_parse.q_var__GT_symbol.call(null,pred);
if(cljs.core.truth_(pred_var)){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"variable","variable",-281346492),new cljs.core.Keyword(null,"order","order",-1254677256),order_STAR_,new cljs.core.Keyword(null,"variable","variable",-281346492),pred_var], null);
} else {
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.Keyword(null,"order","order",-1254677256),order_STAR_,new cljs.core.Keyword(null,"predicate","predicate",-1742501860),pred], null);
}
});
/**
 * Parses order-by and returns a map with more details
 *   Map contains keys:
 * :type      - contains :variable or :predicate for type
 * :order     - :asc or :desc
 * :predicate - predicate name, if :predicate type
 * :variable  - variable name, if :variable type
 */
fluree.db.query.analytical_parse.add_order_by = (function fluree$db$query$analytical_parse$add_order_by(p__18041,db,order_by){
var map__18042 = p__18041;
var map__18042__$1 = cljs.core.__destructure_map.call(null,map__18042);
var parsed_query = map__18042__$1;
var where = cljs.core.get.call(null,map__18042__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var map__18043 = fluree.db.query.analytical_parse.parse_order_by.call(null,order_by);
var map__18043__$1 = cljs.core.__destructure_map.call(null,map__18043);
var parsed_order_by = map__18043__$1;
var variable = cljs.core.get.call(null,map__18043__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
if(cljs.core.truth_((function (){var and__4251__auto__ = variable;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not.call(null,fluree.db.query.analytical_parse.variable_in_where_QMARK_.call(null,variable,where));
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Order by specifies a variable, ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable)," that is used in a where statement."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

return cljs.core.assoc.call(null,parsed_query,new cljs.core.Keyword(null,"order-by","order-by",1527318070),parsed_order_by);
});
fluree.db.query.analytical_parse.add_group_by = (function fluree$db$query$analytical_parse$add_group_by(p__18045,group_by){
var map__18046 = p__18045;
var map__18046__$1 = cljs.core.__destructure_map.call(null,map__18046);
var parsed_query = map__18046__$1;
var where = cljs.core.get.call(null,map__18046__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var group_by_STAR_ = cljs.core.mapv.call(null,fluree.db.query.analytical_parse.q_var__GT_symbol,((cljs.core.sequential_QMARK_.call(null,group_by))?group_by:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [group_by], null)));
if(cljs.core.every_QMARK_.call(null,cljs.core.symbol_QMARK_,group_by_STAR_)){
} else {
throw cljs.core.ex_info.call(null,["Group by must only include variable(s), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(group_by)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.every_QMARK_.call(null,(function (p1__18044_SHARP_){
return fluree.db.query.analytical_parse.variable_in_where_QMARK_.call(null,p1__18044_SHARP_,where);
}),group_by_STAR_)){
} else {
throw cljs.core.ex_info.call(null,["Group by includes variable(s) not specified in the where clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(group_by)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return cljs.core.assoc.call(null,parsed_query,new cljs.core.Keyword(null,"group-by","group-by",-379139802),group_by_STAR_);
});
/**
 * Extracts limit, if available, and verifies it is a positive integer.
 *   Uses Integer/max as default if not present.
 */
fluree.db.query.analytical_parse.get_limit = (function fluree$db$query$analytical_parse$get_limit(p__18047){
var map__18048 = p__18047;
var map__18048__$1 = cljs.core.__destructure_map.call(null,map__18048);
var _query_map_SINGLEQUOTE_ = map__18048__$1;
var limit = cljs.core.get.call(null,map__18048__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var opts = cljs.core.get.call(null,map__18048__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var limit_STAR_ = (function (){var or__4253__auto__ = limit;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return (2147483647);
}
}
})();
if(cljs.core.pos_int_QMARK_.call(null,limit_STAR_)){
} else {
throw cljs.core.ex_info.call(null,["Invalid query limit specified: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit_STAR_)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return limit_STAR_;
});
/**
 * Extracts offset, if specified, and verifies it is a positive integer.
 *   Uses 0 as default if not present.
 */
fluree.db.query.analytical_parse.get_offset = (function fluree$db$query$analytical_parse$get_offset(p__18049){
var map__18050 = p__18049;
var map__18050__$1 = cljs.core.__destructure_map.call(null,map__18050);
var _query_map_SINGLEQUOTE_ = map__18050__$1;
var offset = cljs.core.get.call(null,map__18050__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var opts = cljs.core.get.call(null,map__18050__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var offset_STAR_ = (function (){var or__4253__auto__ = offset;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return (0);
}
}
})();
if((offset_STAR_ >= (0))){
} else {
throw cljs.core.ex_info.call(null,["Invalid query offset specified: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset_STAR_)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return offset_STAR_;
});
/**
 * Extracts max-fuel from query if specified, or uses Integer/max a default.
 */
fluree.db.query.analytical_parse.get_max_fuel = (function fluree$db$query$analytical_parse$get_max_fuel(p__18051){
var map__18052 = p__18051;
var map__18052__$1 = cljs.core.__destructure_map.call(null,map__18052);
var query_map_SINGLEQUOTE_ = map__18052__$1;
var fuel = cljs.core.get.call(null,map__18052__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var max_fuel = cljs.core.get.call(null,map__18052__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
if(cljs.core.truth_(max_fuel)){
fluree.db.util.log.info.call(null,"Deprecated max-fuel used in query: ",query_map_SINGLEQUOTE_);
} else {
}

var max_fuel__$1 = ((typeof max_fuel === 'number')?max_fuel:((typeof fuel === 'number')?fuel:(2147483647)
));
if((max_fuel__$1 > (0))){
} else {
throw cljs.core.ex_info.call(null,["Invalid query fuel specified: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return max_fuel__$1;
});
/**
 * Expands a relational bindings vars definition where it was not supplied
 *   as a vector of maps, but instead a map with one or more vectors as vals.
 *   e.g.
 *   {?x [1 2 3 4]}
 *   {?x [1 2 3 4]
 * ?y ['a' 'b' 'c' 'd']}
 *   {?x [1 2 3 4]
 * ?y 'some-constant-var'}
 * 
 *   Returns a vector of full vars maps.
 */
fluree.db.query.analytical_parse.expand_var_rel_binding = (function fluree$db$query$analytical_parse$expand_var_rel_binding(supplied_vars){
var ks = cljs.core.keys.call(null,supplied_vars);
return cljs.core.mapv.call(null,(function (p1__18054_SHARP_){
return cljs.core.zipmap.call(null,ks,p1__18054_SHARP_);
}),cljs.core.partition.call(null,cljs.core.count.call(null,ks),cljs.core.apply.call(null,cljs.core.interleave,cljs.core.mapv.call(null,(function (p1__18053_SHARP_){
if(cljs.core.sequential_QMARK_.call(null,p1__18053_SHARP_)){
return p1__18053_SHARP_;
} else {
return cljs.core.repeat.call(null,p1__18053_SHARP_);
}
}),cljs.core.vals.call(null,supplied_vars)))));
});
/**
 * Turns all var keys into symbols.
 *   If multiple vars (relational bindings) then will
 *   return a vector of vars maps.
 */
fluree.db.query.analytical_parse.coerce_vars = (function fluree$db$query$analytical_parse$coerce_vars(supplied_vars){
if(cljs.core.truth_(supplied_vars)){
if(cljs.core.sequential_QMARK_.call(null,supplied_vars)){
return cljs.core.mapv.call(null,fluree.db.query.analytical_parse.symbolize_var_keys,supplied_vars);
} else {
var supplied_vars_STAR_ = fluree.db.query.analytical_parse.symbolize_var_keys.call(null,supplied_vars);
var rel_binding_QMARK_ = cljs.core.some.call(null,cljs.core.sequential_QMARK_,cljs.core.vals.call(null,supplied_vars_STAR_));
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.analytical_parse.expand_var_rel_binding.call(null,supplied_vars_STAR_);
} else {
return supplied_vars_STAR_;
}
}
} else {
return null;
}
});
/**
 * Returns true if the query is the legacy 'basic query' type.
 *   e.g.:
 * {select [*], from: '_user'}
 * {select [*], from: ['_user/username' 'userid']}
 * {select [*], from: '_user', where: '_user/username = userid'}
 */
fluree.db.query.analytical_parse.basic_query_QMARK_ = (function fluree$db$query$analytical_parse$basic_query_QMARK_(p__18055){
var map__18056 = p__18055;
var map__18056__$1 = cljs.core.__destructure_map.call(null,map__18056);
var _query_map = map__18056__$1;
var where = cljs.core.get.call(null,map__18056__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
return (!(cljs.core.sequential_QMARK_.call(null,where)));
});
fluree.db.query.analytical_parse.parse_STAR_ = (function fluree$db$query$analytical_parse$parse_STAR_(db,p__18057,supplied_vars){
var map__18058 = p__18057;
var map__18058__$1 = cljs.core.__destructure_map.call(null,map__18058);
var query_map_SINGLEQUOTE_ = map__18058__$1;
var opts = cljs.core.get.call(null,map__18058__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var prettyPrint = cljs.core.get.call(null,map__18058__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var filter = cljs.core.get.call(null,map__18058__$1,new cljs.core.Keyword(null,"filter","filter",-948537934));
var orderBy = cljs.core.get.call(null,map__18058__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var groupBy = cljs.core.get.call(null,map__18058__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var rel_binding_QMARK_ = cljs.core.sequential_QMARK_.call(null,supplied_vars);
var supplied_var_keys = ((rel_binding_QMARK_)?cljs.core.set.call(null,cljs.core.keys.call(null,cljs.core.first.call(null,supplied_vars))):cljs.core.set.call(null,cljs.core.keys.call(null,supplied_vars)));
var parsed = (function (){var G__18059 = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094),new cljs.core.Keyword(null,"strategy","strategy",-1471631918),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"supplied-vars","supplied-vars",-919438628)],[fluree.db.query.analytical_parse.parse_where.call(null,db,query_map_SINGLEQUOTE_,supplied_var_keys),fluree.db.query.analytical_parse.get_limit.call(null,query_map_SINGLEQUOTE_),fluree.db.query.analytical_parse.get_offset.call(null,query_map_SINGLEQUOTE_),fluree.db.query.analytical_parse.get_max_fuel.call(null,query_map_SINGLEQUOTE_),rel_binding_QMARK_,new cljs.core.Keyword(null,"legacy","legacy",1434943289),opts,((cljs.core.boolean_QMARK_.call(null,prettyPrint))?prettyPrint:new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts)),supplied_var_keys]);
var G__18059__$1 = (cljs.core.truth_(filter)?fluree.db.query.analytical_parse.add_filter.call(null,G__18059,filter,supplied_var_keys):G__18059);
var G__18059__$2 = (cljs.core.truth_(orderBy)?fluree.db.query.analytical_parse.add_order_by.call(null,G__18059__$1,db,orderBy):G__18059__$1);
var G__18059__$3 = (cljs.core.truth_(groupBy)?fluree.db.query.analytical_parse.add_group_by.call(null,G__18059__$2,groupBy):G__18059__$2);
return fluree.db.query.analytical_parse.add_select_spec.call(null,G__18059__$3,query_map_SINGLEQUOTE_);

})();
var or__4253__auto__ = fluree.db.query.subject_crawl.reparse.re_parse_as_simple_subj_crawl.call(null,parsed);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return parsed;
}
});
fluree.db.query.analytical_parse.parse = (function fluree$db$query$analytical_parse$parse(db,query_map){
var query_map_STAR_ = ((fluree.db.query.analytical_parse.basic_query_QMARK_.call(null,query_map))?fluree.db.query.subject_crawl.legacy.basic_to_analytical_transpiler.call(null,query_map):query_map);
var map__18060 = query_map_STAR_;
var map__18060__$1 = cljs.core.__destructure_map.call(null,map__18060);
var vars = cljs.core.get.call(null,map__18060__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var vars_STAR_ = fluree.db.query.analytical_parse.coerce_vars.call(null,vars);
var parsed_query = fluree.db.query.analytical_parse.parse_STAR_.call(null,db,cljs.core.dissoc.call(null,query_map_STAR_,new cljs.core.Keyword(null,"vars","vars",-2046957217)),vars_STAR_);
return cljs.core.assoc.call(null,parsed_query,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars_STAR_);
});
