// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__19023_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19023_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19027 = coll;
var vec__19028 = G__19027;
var seq__19029 = cljs.core.seq.call(null,vec__19028);
var first__19030 = cljs.core.first.call(null,seq__19029);
var seq__19029__$1 = cljs.core.next.call(null,seq__19029);
var clause = first__19030;
var r = seq__19029__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19027__$1 = G__19027;
var res__$1 = res;
while(true){
var vec__19034 = G__19027__$1;
var seq__19035 = cljs.core.seq.call(null,vec__19034);
var first__19036 = cljs.core.first.call(null,seq__19035);
var seq__19035__$1 = cljs.core.next.call(null,seq__19035);
var clause__$1 = first__19036;
var r__$1 = seq__19035__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19037 = r__$1;
var G__19038 = cljs.core.conj.call(null,res__$2,clause__$1);
G__19027__$1 = G__19037;
res__$1 = G__19038;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.call(null,(function (res,p__19039){
var map__19040 = p__19039;
var map__19040__$1 = cljs.core.__destructure_map.call(null,map__19040);
var optional = cljs.core.get.call(null,map__19040__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.call(null,res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__19044 = coll;
var vec__19045 = G__19044;
var seq__19046 = cljs.core.seq.call(null,vec__19045);
var first__19047 = cljs.core.first.call(null,seq__19046);
var seq__19046__$1 = cljs.core.next.call(null,seq__19046);
var clause = first__19047;
var r = seq__19046__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19044__$1 = G__19044;
var res__$1 = res;
while(true){
var vec__19051 = G__19044__$1;
var seq__19052 = cljs.core.seq.call(null,vec__19051);
var first__19053 = cljs.core.first.call(null,seq__19052);
var seq__19052__$1 = cljs.core.next.call(null,seq__19052);
var clause__$1 = first__19053;
var r__$1 = seq__19052__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19054 = r__$1;
var G__19055 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__19044__$1 = G__19054;
res__$1 = G__19055;
continue;
} else {
var G__19056 = r__$1;
var G__19057 = res__$2;
G__19044__$1 = G__19056;
res__$1 = G__19057;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__19061 = coll;
var vec__19062 = G__19061;
var seq__19063 = cljs.core.seq.call(null,vec__19062);
var first__19064 = cljs.core.first.call(null,seq__19063);
var seq__19063__$1 = cljs.core.next.call(null,seq__19063);
var clause = first__19064;
var r = seq__19063__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19061__$1 = G__19061;
var res__$1 = res;
while(true){
var vec__19068 = G__19061__$1;
var seq__19069 = cljs.core.seq.call(null,vec__19068);
var first__19070 = cljs.core.first.call(null,seq__19069);
var seq__19069__$1 = cljs.core.next.call(null,seq__19069);
var clause__$1 = first__19070;
var r__$1 = seq__19069__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19071 = r__$1;
var G__19072 = res__$2;
G__19061__$1 = G__19071;
res__$1 = G__19072;
continue;
} else {
var G__19073 = r__$1;
var G__19074 = cljs.core.conj.call(null,res__$2,clause__$1);
G__19061__$1 = G__19073;
res__$1 = G__19074;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__19077 = clause;
var G__19077__$1 = ((cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause)))?cljs.core.drop.call(null,(1),G__19077):G__19077);
var G__19077__$2 = clojure.string.join.call(null," ",G__19077__$1)
;
var G__19077__$3 = (function (p1__19075_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19075_SHARP_)," ."].join('');
}).call(null,G__19077__$2)
;
if(cljs.core.truth_(optional_QMARK_)){
return (function (p1__19076_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19076_SHARP_),"}"].join('');
}).call(null,G__19077__$3);
} else {
return G__19077__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__19081 = opts;
var map__19081__$1 = cljs.core.__destructure_map.call(null,map__19081);
var limit = cljs.core.get.call(null,map__19081__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__19081__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__19081__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__19081__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__19081__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__19078_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19078_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__19079_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__19079_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__19080_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__19080_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = language;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19095){
var state_val_19096 = (state_19095[(1)]);
if((state_val_19096 === (1))){
var inst_19082 = fluree.db.util.core.url_encode.call(null,query);
var inst_19083 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19082)].join('');
var inst_19084 = ["User-Agent","Accept"];
var inst_19085 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_19086 = cljs.core.PersistentHashMap.fromArrays(inst_19084,inst_19085);
var inst_19087 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_19088 = [inst_19086,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_19089 = cljs.core.PersistentHashMap.fromArrays(inst_19087,inst_19088);
var inst_19090 = fluree.db.util.xhttp.get.call(null,inst_19083,inst_19089);
var state_19095__$1 = state_19095;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19095__$1,(2),inst_19090);
} else {
if((state_val_19096 === (2))){
var inst_19092 = (state_19095[(2)]);
var inst_19093 = fluree.db.util.async.throw_err.call(null,inst_19092);
var state_19095__$1 = state_19095;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19095__$1,inst_19093);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0 = (function (){
var statearr_19097 = [null,null,null,null,null,null,null];
(statearr_19097[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__);

(statearr_19097[(1)] = (1));

return statearr_19097;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1 = (function (state_19095){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19095);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19098){var ex__2749__auto__ = e19098;
var statearr_19099_19102 = state_19095;
(statearr_19099_19102[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19095[(4)]))){
var statearr_19100_19103 = state_19095;
(statearr_19100_19103[(1)] = cljs.core.first.call(null,(state_19095[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19104 = state_19095;
state_19095 = G__19104;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__ = function(state_19095){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1.call(this,state_19095);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19101 = f__2769__auto__.call(null);
(statearr_19101[(6)] = c__2768__auto__);

return statearr_19101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19122){
var state_val_19123 = (state_19122[(1)]);
if((state_val_19123 === (1))){
var inst_19105 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_19122__$1 = state_19122;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19122__$1,(2),inst_19105);
} else {
if((state_val_19123 === (2))){
var inst_19108 = (state_19122[(7)]);
var inst_19107 = (state_19122[(2)]);
var inst_19108__$1 = fluree.db.util.async.throw_err.call(null,inst_19107);
var inst_19109 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_19108__$1);
var inst_19110 = cljs.core.not_EQ_.call(null,(200),inst_19109);
var state_19122__$1 = (function (){var statearr_19124 = state_19122;
(statearr_19124[(7)] = inst_19108__$1);

return statearr_19124;
})();
if(inst_19110){
var statearr_19125_19134 = state_19122__$1;
(statearr_19125_19134[(1)] = (3));

} else {
var statearr_19126_19135 = state_19122__$1;
(statearr_19126_19135[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19123 === (3))){
var inst_19108 = (state_19122[(7)]);
var state_19122__$1 = state_19122;
var statearr_19127_19136 = state_19122__$1;
(statearr_19127_19136[(2)] = inst_19108);

(statearr_19127_19136[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19123 === (4))){
var inst_19108 = (state_19122[(7)]);
var inst_19113 = (function (){var body = inst_19108;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_19114 = cljs.core.second.call(null,inst_19108);
var inst_19115 = cljs.core.second.call(null,inst_19114);
var inst_19116 = cljs.core.first.call(null,inst_19115);
var inst_19117 = cljs.core.second.call(null,inst_19116);
var inst_19118 = cljs.core.mapv.call(null,inst_19113,inst_19117);
var state_19122__$1 = state_19122;
var statearr_19128_19137 = state_19122__$1;
(statearr_19128_19137[(2)] = inst_19118);

(statearr_19128_19137[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19123 === (5))){
var inst_19120 = (state_19122[(2)]);
var state_19122__$1 = state_19122;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19122__$1,inst_19120);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0 = (function (){
var statearr_19129 = [null,null,null,null,null,null,null,null];
(statearr_19129[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__);

(statearr_19129[(1)] = (1));

return statearr_19129;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1 = (function (state_19122){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19122);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19130){var ex__2749__auto__ = e19130;
var statearr_19131_19138 = state_19122;
(statearr_19131_19138[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19122[(4)]))){
var statearr_19132_19139 = state_19122;
(statearr_19132_19139[(1)] = cljs.core.first.call(null,(state_19122[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19140 = state_19122;
state_19122 = G__19140;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__ = function(state_19122){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1.call(this,state_19122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19133 = f__2769__auto__.call(null);
(statearr_19133[(6)] = c__2768__auto__);

return statearr_19133;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__19141_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19141_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__19142_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19142_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__19143_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__19143_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19189){
var state_val_19190 = (state_19189[(1)]);
if((state_val_19190 === (7))){
var inst_19154 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_19189__$1 = state_19189;
var statearr_19191_19219 = state_19189__$1;
(statearr_19191_19219[(2)] = inst_19154);

(statearr_19191_19219[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (1))){
var state_19189__$1 = state_19189;
var statearr_19192_19220 = state_19189__$1;
(statearr_19192_19220[(2)] = null);

(statearr_19192_19220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (4))){
var inst_19144 = (state_19189[(2)]);
var state_19189__$1 = state_19189;
var statearr_19193_19221 = state_19189__$1;
(statearr_19193_19221[(2)] = inst_19144);

(statearr_19193_19221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (15))){
var inst_19162 = (state_19189[(7)]);
var inst_19168 = (state_19189[(8)]);
var inst_19163 = (state_19189[(9)]);
var inst_19173 = (state_19189[(2)]);
var inst_19174 = cljs.core.subs.call(null,inst_19168,(0),inst_19173);
var inst_19175 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19176 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_19162);
var inst_19177 = [inst_19163,inst_19176];
var inst_19178 = cljs.core.PersistentHashMap.fromArrays(inst_19175,inst_19177);
var inst_19179 = cljs.core.ex_info.call(null,inst_19174,inst_19178);
var inst_19180 = (function(){throw inst_19179})();
var state_19189__$1 = state_19189;
var statearr_19194_19222 = state_19189__$1;
(statearr_19194_19222[(2)] = inst_19180);

(statearr_19194_19222[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (13))){
var inst_19167 = (state_19189[(10)]);
var state_19189__$1 = state_19189;
var statearr_19195_19223 = state_19189__$1;
(statearr_19195_19223[(2)] = inst_19167);

(statearr_19195_19223[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (6))){
var state_19189__$1 = state_19189;
var statearr_19196_19224 = state_19189__$1;
(statearr_19196_19224[(2)] = null);

(statearr_19196_19224[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (3))){
var inst_19187 = (state_19189[(2)]);
var state_19189__$1 = state_19189;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19189__$1,inst_19187);
} else {
if((state_val_19190 === (12))){
var inst_19184 = (state_19189[(2)]);
var _ = (function (){var statearr_19197 = state_19189;
(statearr_19197[(4)] = cljs.core.rest.call(null,(state_19189[(4)])));

return statearr_19197;
})();
var state_19189__$1 = state_19189;
var statearr_19198_19225 = state_19189__$1;
(statearr_19198_19225[(2)] = inst_19184);

(statearr_19198_19225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (2))){
var _ = (function (){var statearr_19199 = state_19189;
(statearr_19199[(4)] = cljs.core.cons.call(null,(5),(state_19189[(4)])));

return statearr_19199;
})();
var inst_19151 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_19189__$1 = state_19189;
if(inst_19151){
var statearr_19200_19226 = state_19189__$1;
(statearr_19200_19226[(1)] = (6));

} else {
var statearr_19201_19227 = state_19189__$1;
(statearr_19201_19227[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (11))){
var inst_19162 = (state_19189[(7)]);
var inst_19182 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_19162,all_vars);
var state_19189__$1 = state_19189;
var statearr_19203_19228 = state_19189__$1;
(statearr_19203_19228[(2)] = inst_19182);

(statearr_19203_19228[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (9))){
var inst_19162 = (state_19189[(7)]);
var inst_19163 = (state_19189[(9)]);
var inst_19160 = (state_19189[(2)]);
var inst_19161 = fluree.db.util.async.throw_err.call(null,inst_19160);
var inst_19162__$1 = cljs.core.__destructure_map.call(null,inst_19161);
var inst_19163__$1 = cljs.core.get.call(null,inst_19162__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_19164 = cljs.core.get.call(null,inst_19162__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_19165 = cljs.core._EQ_.call(null,(400),inst_19163__$1);
var state_19189__$1 = (function (){var statearr_19204 = state_19189;
(statearr_19204[(7)] = inst_19162__$1);

(statearr_19204[(11)] = inst_19164);

(statearr_19204[(9)] = inst_19163__$1);

return statearr_19204;
})();
if(inst_19165){
var statearr_19205_19229 = state_19189__$1;
(statearr_19205_19229[(1)] = (10));

} else {
var statearr_19206_19230 = state_19189__$1;
(statearr_19206_19230[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (5))){
var _ = (function (){var statearr_19207 = state_19189;
(statearr_19207[(4)] = cljs.core.rest.call(null,(state_19189[(4)])));

return statearr_19207;
})();
var state_19189__$1 = state_19189;
var ex19202 = (state_19189__$1[(2)]);
var statearr_19208_19231 = state_19189__$1;
(statearr_19208_19231[(5)] = ex19202);


if((ex19202 instanceof Error)){
var statearr_19209_19232 = state_19189__$1;
(statearr_19209_19232[(1)] = (4));

(statearr_19209_19232[(5)] = null);

} else {
throw ex19202;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (14))){
var state_19189__$1 = state_19189;
var statearr_19210_19233 = state_19189__$1;
(statearr_19210_19233[(2)] = (1000));

(statearr_19210_19233[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (10))){
var inst_19162 = (state_19189[(7)]);
var inst_19167 = (state_19189[(10)]);
var inst_19164 = (state_19189[(11)]);
var inst_19167__$1 = cljs.core.count.call(null,inst_19164);
var inst_19168 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_19162);
var inst_19169 = (inst_19167__$1 < (1000));
var state_19189__$1 = (function (){var statearr_19211 = state_19189;
(statearr_19211[(10)] = inst_19167__$1);

(statearr_19211[(8)] = inst_19168);

return statearr_19211;
})();
if(cljs.core.truth_(inst_19169)){
var statearr_19212_19234 = state_19189__$1;
(statearr_19212_19234[(1)] = (13));

} else {
var statearr_19213_19235 = state_19189__$1;
(statearr_19213_19235[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (8))){
var inst_19156 = (state_19189[(2)]);
var inst_19157 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_19156,optional_clauses);
var inst_19158 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_19157);
var state_19189__$1 = state_19189;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19189__$1,(9),inst_19158);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_19214 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19214[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__);

(statearr_19214[(1)] = (1));

return statearr_19214;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1 = (function (state_19189){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19189);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19215){var ex__2749__auto__ = e19215;
var statearr_19216_19236 = state_19189;
(statearr_19216_19236[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19189[(4)]))){
var statearr_19217_19237 = state_19189;
(statearr_19217_19237[(1)] = cljs.core.first.call(null,(state_19189[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19238 = state_19189;
state_19189 = G__19238;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__ = function(state_19189){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1.call(this,state_19189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19218 = f__2769__auto__.call(null);
(statearr_19218[(6)] = c__2768__auto__);

return statearr_19218;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
