// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
goog.require('fluree.db.query.subject_crawl.core');
goog.require('fluree.db.query.fql_resp');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__23685 = arguments.length;
switch (G__23685) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__23688 = arguments.length;
switch (G__23688) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__23690 = null;
var G__23690__0 = (function (){
return xf.call(null);
});
var G__23690__1 = (function (result){
return xf.call(null,result);
});
var G__23690__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__23690 = function(result,flake){
switch(arguments.length){
case 0:
return G__23690__0.call(this);
case 1:
return G__23690__1.call(this,result);
case 2:
return G__23690__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23690.cljs$core$IFn$_invoke$arity$0 = G__23690__0;
G__23690.cljs$core$IFn$_invoke$arity$1 = G__23690__1;
G__23690.cljs$core$IFn$_invoke$arity$2 = G__23690__2;
return G__23690;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__23691_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__23691_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__23695 = vars;
var vec__23696 = G__23695;
var seq__23697 = cljs.core.seq.call(null,vec__23696);
var first__23698 = cljs.core.first.call(null,seq__23697);
var seq__23697__$1 = cljs.core.next.call(null,seq__23697);
var var$ = first__23698;
var r = seq__23697__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__23695__$1 = G__23695;
var all_vars__$1 = all_vars;
while(true){
var vec__23702 = G__23695__$1;
var seq__23703 = cljs.core.seq.call(null,vec__23702);
var first__23704 = cljs.core.first.call(null,seq__23703);
var seq__23703__$1 = cljs.core.next.call(null,seq__23703);
var var$__$1 = first__23704;
var r__$1 = seq__23703__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__23705 = r__$1;
var G__23706 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__23695__$1 = G__23705;
all_vars__$1 = G__23706;
continue;
} else {
var G__23707 = r__$1;
var G__23708 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__23695__$1 = G__23707;
all_vars__$1 = G__23708;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__23709){
var vec__23710 = p__23709;
var tuple_index = cljs.core.nth.call(null,vec__23710,(0),null);
var query_map = cljs.core.nth.call(null,vec__23710,(1),null);
var temp__5804__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23724){
var state_val_23725 = (state_23724[(1)]);
if((state_val_23725 === (1))){
var inst_23713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23714 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_23715 = [query_map,_id,query_opts];
var inst_23716 = cljs.core.PersistentHashMap.fromArrays(inst_23714,inst_23715);
var inst_23717 = fluree.db.query.fql.query.call(null,db,inst_23716);
var state_23724__$1 = (function (){var statearr_23726 = state_23724;
(statearr_23726[(7)] = inst_23713);

return statearr_23726;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23724__$1,(2),inst_23717);
} else {
if((state_val_23725 === (2))){
var inst_23713 = (state_23724[(7)]);
var inst_23719 = (state_23724[(2)]);
var inst_23720 = fluree.db.util.async.throw_err.call(null,inst_23719);
var inst_23721 = [tuple_index,inst_23720];
var inst_23722 = (new cljs.core.PersistentVector(null,2,(5),inst_23713,inst_23721,null));
var state_23724__$1 = state_23724;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23724__$1,inst_23722);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0 = (function (){
var statearr_23727 = [null,null,null,null,null,null,null,null];
(statearr_23727[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2746__auto__);

(statearr_23727[(1)] = (1));

return statearr_23727;
});
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1 = (function (state_23724){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23724);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23728){var ex__2749__auto__ = e23728;
var statearr_23729_23732 = state_23724;
(statearr_23729_23732[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23724[(4)]))){
var statearr_23730_23733 = state_23724;
(statearr_23730_23733[(1)] = cljs.core.first.call(null,(state_23724[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23734 = state_23724;
state_23724 = G__23734;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__ = function(state_23724){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1.call(this,state_23724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23731 = f__2769__auto__.call(null);
(statearr_23731[(6)] = c__2768__auto__);

return statearr_23731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__23735 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__23735,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__23735,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23798){
var state_val_23799 = (state_23798[(1)]);
if((state_val_23799 === (7))){
var inst_23793 = (state_23798[(2)]);
var _ = (function (){var statearr_23800 = state_23798;
(statearr_23800[(4)] = cljs.core.rest.call(null,(state_23798[(4)])));

return statearr_23800;
})();
var state_23798__$1 = state_23798;
var statearr_23801_23892 = state_23798__$1;
(statearr_23801_23892[(2)] = inst_23793);

(statearr_23801_23892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (20))){
var inst_23784 = (state_23798[(2)]);
var state_23798__$1 = state_23798;
var statearr_23802_23893 = state_23798__$1;
(statearr_23802_23893[(2)] = inst_23784);

(statearr_23802_23893[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (1))){
var state_23798__$1 = state_23798;
var statearr_23803_23894 = state_23798__$1;
(statearr_23803_23894[(2)] = null);

(statearr_23803_23894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (4))){
var inst_23740 = (state_23798[(2)]);
var state_23798__$1 = state_23798;
var statearr_23804_23895 = state_23798__$1;
(statearr_23804_23895[(2)] = inst_23740);

(statearr_23804_23895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (15))){
var inst_23760 = (state_23798[(7)]);
var inst_23769 = cljs.core.second.call(null,inst_23760);
var inst_23770 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_23769);
var inst_23771 = (inst_23770 > max_fuel);
var state_23798__$1 = state_23798;
if(cljs.core.truth_(inst_23771)){
var statearr_23805_23896 = state_23798__$1;
(statearr_23805_23896[(1)] = (18));

} else {
var statearr_23806_23897 = state_23798__$1;
(statearr_23806_23897[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (13))){
var state_23798__$1 = state_23798;
var statearr_23807_23898 = state_23798__$1;
(statearr_23807_23898[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (6))){
var inst_23748 = (state_23798[(8)]);
var state_23798__$1 = state_23798;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23798__$1,(8),inst_23748);
} else {
if((state_val_23799 === (17))){
var inst_23787 = (state_23798[(2)]);
var state_23798__$1 = state_23798;
var statearr_23809_23899 = state_23798__$1;
(statearr_23809_23899[(2)] = inst_23787);

(statearr_23809_23899[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (3))){
var inst_23796 = (state_23798[(2)]);
var state_23798__$1 = state_23798;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23798__$1,inst_23796);
} else {
if((state_val_23799 === (12))){
var inst_23749 = (state_23798[(9)]);
var inst_23760 = (state_23798[(7)]);
var inst_23766 = inst_23749.call(null);
var state_23798__$1 = (function (){var statearr_23810 = state_23798;
(statearr_23810[(10)] = inst_23766);

return statearr_23810;
})();
var statearr_23811_23900 = state_23798__$1;
(statearr_23811_23900[(2)] = inst_23760);

(statearr_23811_23900[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (2))){
var inst_23749 = (state_23798[(9)]);
var inst_23748 = (state_23798[(8)]);
var _ = (function (){var statearr_23812 = state_23798;
(statearr_23812[(4)] = cljs.core.cons.call(null,(5),(state_23798[(4)])));

return statearr_23812;
})();
var inst_23746 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_23747 = cljs.core.async.chan.call(null);
var inst_23748__$1 = cljs.core.async.chan.call(null);
var inst_23749__$1 = (function (){var expandMaps = inst_23746;
var queue_ch = inst_23747;
var res_ch = inst_23748__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_23750 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_23751 = cljs.core.volatile_BANG_.call(null,(0));
var inst_23752 = cljs.core.assoc.call(null,inst_23750,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_23751);
var inst_23753 = (function (){var expandMaps = inst_23746;
var queue_ch = inst_23747;
var res_ch = inst_23748__$1;
var stop_BANG_ = inst_23749__$1;
var opts_STAR_ = inst_23752;
return (function (tuple_res,port){
var c__2768__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23845){
var state_val_23846 = (state_23845[(1)]);
if((state_val_23846 === (7))){
var state_23845__$1 = state_23845;
var statearr_23847_23901 = state_23845__$1;
(statearr_23847_23901[(2)] = tuple_res);

(statearr_23847_23901[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (1))){
var state_23845__$1 = state_23845;
var statearr_23848_23902 = state_23845__$1;
(statearr_23848_23902[(2)] = null);

(statearr_23848_23902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (4))){
var inst_23813 = (state_23845[(2)]);
var inst_23814 = cljs.core.async.put_BANG_.call(null,port,inst_23813);
var inst_23815 = cljs.core.async.close_BANG_.call(null,port);
var state_23845__$1 = (function (){var statearr_23849 = state_23845;
(statearr_23849[(7)] = inst_23814);

return statearr_23849;
})();
var statearr_23850_23903 = state_23845__$1;
(statearr_23850_23903[(2)] = inst_23815);

(statearr_23850_23903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (6))){
var inst_23822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23823 = [tuple_res];
var inst_23824 = (new cljs.core.PersistentVector(null,1,(5),inst_23822,inst_23823,null));
var state_23845__$1 = state_23845;
var statearr_23851_23904 = state_23845__$1;
(statearr_23851_23904[(2)] = inst_23824);

(statearr_23851_23904[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (3))){
var inst_23843 = (state_23845[(2)]);
var state_23845__$1 = state_23845;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23845__$1,inst_23843);
} else {
if((state_val_23846 === (2))){
var ___$1 = (function (){var statearr_23853 = state_23845;
(statearr_23853[(4)] = cljs.core.cons.call(null,(5),(state_23845[(4)])));

return statearr_23853;
})();
var state_23845__$1 = state_23845;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_23854_23905 = state_23845__$1;
(statearr_23854_23905[(1)] = (6));

} else {
var statearr_23855_23906 = state_23845__$1;
(statearr_23855_23906[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (9))){
var inst_23827 = (state_23845[(8)]);
var inst_23829 = (state_23845[(9)]);
var inst_23836 = (state_23845[(2)]);
var inst_23837 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_23827,inst_23836);
var inst_23838 = inst_23829.call(null,inst_23837);
var inst_23839 = cljs.core.async.put_BANG_.call(null,port,inst_23838);
var inst_23840 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_23856 = state_23845;
(statearr_23856[(4)] = cljs.core.rest.call(null,(state_23845[(4)])));

return statearr_23856;
})();
var state_23845__$1 = (function (){var statearr_23857 = state_23845;
(statearr_23857[(10)] = inst_23839);

return statearr_23857;
})();
var statearr_23858_23907 = state_23845__$1;
(statearr_23858_23907[(2)] = inst_23840);

(statearr_23858_23907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (5))){
var ___$1 = (function (){var statearr_23859 = state_23845;
(statearr_23859[(4)] = cljs.core.rest.call(null,(state_23845[(4)])));

return statearr_23859;
})();
var state_23845__$1 = state_23845;
var ex23852 = (state_23845__$1[(2)]);
var statearr_23860_23908 = state_23845__$1;
(statearr_23860_23908[(5)] = ex23852);


var statearr_23861_23909 = state_23845__$1;
(statearr_23861_23909[(1)] = (4));

(statearr_23861_23909[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23846 === (8))){
var inst_23827 = (state_23845[(8)]);
var inst_23827__$1 = (state_23845[(2)]);
var inst_23828 = cljs.core.volatile_BANG_.call(null,(0));
var inst_23829 = (function (){var tuple_res_SINGLEQUOTE_ = inst_23827__$1;
var query_fuel = inst_23828;
return (function (p1__23739_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__23739_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__23739_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_23830 = cljs.core.PersistentVector.EMPTY;
var inst_23831 = (function (){var tuple_res_SINGLEQUOTE_ = inst_23827__$1;
var query_fuel = inst_23828;
return (function (p1__23738_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__23738_SHARP_);
});
})();
var inst_23832 = cljs.core.keep.call(null,inst_23831,expandMaps);
var inst_23833 = cljs.core.async.merge.call(null,inst_23832);
var inst_23834 = cljs.core.async.into.call(null,inst_23830,inst_23833);
var state_23845__$1 = (function (){var statearr_23862 = state_23845;
(statearr_23862[(8)] = inst_23827__$1);

(statearr_23862[(9)] = inst_23829);

return statearr_23862;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23845__$1,(9),inst_23834);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0 = (function (){
var statearr_23863 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23863[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__);

(statearr_23863[(1)] = (1));

return statearr_23863;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1 = (function (state_23845){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23845);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23864){var ex__2749__auto__ = e23864;
var statearr_23865_23910 = state_23845;
(statearr_23865_23910[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23845[(4)]))){
var statearr_23866_23911 = state_23845;
(statearr_23866_23911[(1)] = cljs.core.first.call(null,(state_23845[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23912 = state_23845;
state_23845 = G__23912;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = function(state_23845){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1.call(this,state_23845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23867 = f__2769__auto__.call(null);
(statearr_23867[(6)] = c__2768__auto____$1);

return statearr_23867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto____$1;
});
})();
var inst_23754 = cljs.core.async.onto_chan_BANG_.call(null,inst_23747,tuples_res);
var inst_23755 = cljs.core.async.pipeline_async.call(null,parallelism,inst_23748__$1,inst_23753,inst_23747);
var inst_23756 = cljs.core.PersistentVector.EMPTY;
var inst_23757 = inst_23756;
var state_23798__$1 = (function (){var statearr_23868 = state_23798;
(statearr_23868[(11)] = inst_23755);

(statearr_23868[(9)] = inst_23749__$1);

(statearr_23868[(12)] = inst_23754);

(statearr_23868[(13)] = inst_23757);

(statearr_23868[(8)] = inst_23748__$1);

return statearr_23868;
})();
var statearr_23869_23913 = state_23798__$1;
(statearr_23869_23913[(2)] = null);

(statearr_23869_23913[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (19))){
var inst_23757 = (state_23798[(13)]);
var inst_23760 = (state_23798[(7)]);
var inst_23780 = cljs.core.first.call(null,inst_23760);
var inst_23781 = cljs.core.conj.call(null,inst_23757,inst_23780);
var inst_23757__$1 = inst_23781;
var state_23798__$1 = (function (){var statearr_23870 = state_23798;
(statearr_23870[(13)] = inst_23757__$1);

return statearr_23870;
})();
var statearr_23871_23914 = state_23798__$1;
(statearr_23871_23914[(2)] = null);

(statearr_23871_23914[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (11))){
var inst_23791 = (state_23798[(2)]);
var state_23798__$1 = state_23798;
var statearr_23873_23915 = state_23798__$1;
(statearr_23873_23915[(2)] = inst_23791);

(statearr_23873_23915[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (9))){
var inst_23757 = (state_23798[(13)]);
var state_23798__$1 = state_23798;
var statearr_23874_23916 = state_23798__$1;
(statearr_23874_23916[(2)] = inst_23757);

(statearr_23874_23916[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (5))){
var _ = (function (){var statearr_23875 = state_23798;
(statearr_23875[(4)] = cljs.core.rest.call(null,(state_23798[(4)])));

return statearr_23875;
})();
var state_23798__$1 = state_23798;
var ex23872 = (state_23798__$1[(2)]);
var statearr_23876_23917 = state_23798__$1;
(statearr_23876_23917[(5)] = ex23872);


if((ex23872 instanceof Error)){
var statearr_23877_23918 = state_23798__$1;
(statearr_23877_23918[(1)] = (4));

(statearr_23877_23918[(5)] = null);

} else {
throw ex23872;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (14))){
var inst_23789 = (state_23798[(2)]);
var state_23798__$1 = state_23798;
var statearr_23878_23919 = state_23798__$1;
(statearr_23878_23919[(2)] = inst_23789);

(statearr_23878_23919[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (16))){
var state_23798__$1 = state_23798;
var statearr_23879_23920 = state_23798__$1;
(statearr_23879_23920[(2)] = null);

(statearr_23879_23920[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (10))){
var inst_23760 = (state_23798[(7)]);
var inst_23764 = fluree.db.util.core.exception_QMARK_.call(null,inst_23760);
var state_23798__$1 = state_23798;
if(inst_23764){
var statearr_23880_23921 = state_23798__$1;
(statearr_23880_23921[(1)] = (12));

} else {
var statearr_23881_23922 = state_23798__$1;
(statearr_23881_23922[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (18))){
var inst_23749 = (state_23798[(9)]);
var inst_23773 = inst_23749.call(null);
var inst_23774 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_23775 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_23776 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_23777 = cljs.core.PersistentHashMap.fromArrays(inst_23775,inst_23776);
var inst_23778 = cljs.core.ex_info.call(null,inst_23774,inst_23777);
var state_23798__$1 = (function (){var statearr_23882 = state_23798;
(statearr_23882[(14)] = inst_23773);

return statearr_23882;
})();
var statearr_23883_23923 = state_23798__$1;
(statearr_23883_23923[(2)] = inst_23778);

(statearr_23883_23923[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23799 === (8))){
var inst_23760 = (state_23798[(7)]);
var inst_23760__$1 = (state_23798[(2)]);
var inst_23761 = (inst_23760__$1 == null);
var state_23798__$1 = (function (){var statearr_23884 = state_23798;
(statearr_23884[(7)] = inst_23760__$1);

return statearr_23884;
})();
if(cljs.core.truth_(inst_23761)){
var statearr_23885_23924 = state_23798__$1;
(statearr_23885_23924[(1)] = (9));

} else {
var statearr_23886_23925 = state_23798__$1;
(statearr_23886_23925[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0 = (function (){
var statearr_23887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23887[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__);

(statearr_23887[(1)] = (1));

return statearr_23887;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1 = (function (state_23798){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23798);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23888){var ex__2749__auto__ = e23888;
var statearr_23889_23926 = state_23798;
(statearr_23889_23926[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23798[(4)]))){
var statearr_23890_23927 = state_23798;
(statearr_23890_23927[(1)] = cljs.core.first.call(null,(state_23798[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23928 = state_23798;
state_23798 = G__23928;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = function(state_23798){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1.call(this,state_23798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23891 = f__2769__auto__.call(null);
(statearr_23891[(6)] = c__2768__auto__);

return statearr_23891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__23929 = select;
var map__23929__$1 = cljs.core.__destructure_map.call(null,map__23929);
var as = cljs.core.get.call(null,map__23929__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__23929__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__23929__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4253__auto__ = as;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__23932 = orderBy;
var order = cljs.core.nth.call(null,vec__23932,(0),null);
var var$ = cljs.core.nth.call(null,vec__23932,(1),null);
var option = cljs.core.nth.call(null,vec__23932,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__23930_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__23930_SHARP_,compare_idx));
}):(function (p1__23931_SHARP_){
return cljs.core.nth.call(null,p1__23931_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__23937 = arguments.length;
switch (G__23937) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__23938,p__23939,group_limit,opts){
var map__23940 = p__23938;
var map__23940__$1 = cljs.core.__destructure_map.call(null,map__23940);
var res = map__23940__$1;
var vars = cljs.core.get.call(null,map__23940__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__23941 = p__23939;
var map__23941__$1 = cljs.core.__destructure_map.call(null,map__23941);
var select_spec = map__23941__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__23941__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__23941__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__23941__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__23941__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__23941__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__23941__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__23941__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__23941__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__23941__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__23941__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24078){
var state_val_24079 = (state_24078[(1)]);
if((state_val_24079 === (7))){
var inst_23948 = (state_24078[(7)]);
var state_24078__$1 = state_24078;
var statearr_24080_24182 = state_24078__$1;
(statearr_24080_24182[(2)] = inst_23948);

(statearr_24080_24182[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (59))){
var inst_24071 = (state_24078[(2)]);
var state_24078__$1 = state_24078;
var statearr_24081_24183 = state_24078__$1;
(statearr_24081_24183[(2)] = inst_24071);

(statearr_24081_24183[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (20))){
var inst_23987 = (state_24078[(8)]);
var inst_23984 = (state_24078[(9)]);
var inst_23983 = (state_24078[(2)]);
var inst_23984__$1 = cljs.core.__destructure_map.call(null,inst_23983);
var inst_23985 = cljs.core.get.call(null,inst_23984__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_23986 = cljs.core.get.call(null,inst_23984__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_23987__$1 = offset;
var state_24078__$1 = (function (){var statearr_24082 = state_24078;
(statearr_24082[(10)] = inst_23986);

(statearr_24082[(8)] = inst_23987__$1);

(statearr_24082[(9)] = inst_23984__$1);

(statearr_24082[(11)] = inst_23985);

return statearr_24082;
})();
if(cljs.core.truth_(inst_23987__$1)){
var statearr_24083_24184 = state_24078__$1;
(statearr_24083_24184[(1)] = (21));

} else {
var statearr_24084_24185 = state_24078__$1;
(statearr_24084_24185[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (58))){
var inst_24063 = (state_24078[(12)]);
var state_24078__$1 = state_24078;
var statearr_24085_24186 = state_24078__$1;
(statearr_24085_24186[(2)] = inst_24063);

(statearr_24085_24186[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (60))){
var inst_24067 = (state_24078[(2)]);
var inst_24068 = fluree.db.util.async.throw_err.call(null,inst_24067);
var state_24078__$1 = state_24078;
var statearr_24086_24187 = state_24078__$1;
(statearr_24086_24187[(2)] = inst_24068);

(statearr_24086_24187[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (27))){
var inst_23999 = cljs.core.not.call(null,inVector_QMARK_);
var state_24078__$1 = state_24078;
var statearr_24087_24188 = state_24078__$1;
(statearr_24087_24188[(2)] = inst_23999);

(statearr_24087_24188[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (1))){
var state_24078__$1 = state_24078;
var statearr_24088_24189 = state_24078__$1;
(statearr_24088_24189[(2)] = null);

(statearr_24088_24189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (24))){
var state_24078__$1 = state_24078;
var statearr_24089_24190 = state_24078__$1;
(statearr_24089_24190[(2)] = offset);

(statearr_24089_24190[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (55))){
var inst_24057 = (state_24078[(13)]);
var state_24078__$1 = state_24078;
var statearr_24090_24191 = state_24078__$1;
(statearr_24090_24191[(2)] = inst_24057);

(statearr_24090_24191[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (39))){
var inst_24025 = (state_24078[(14)]);
var inst_24027 = cljs.core.distinct.call(null);
var inst_24028 = cljs.core.conj.call(null,inst_24025,inst_24027);
var state_24078__$1 = state_24078;
var statearr_24091_24192 = state_24078__$1;
(statearr_24091_24192[(2)] = inst_24028);

(statearr_24091_24192[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (46))){
var inst_24037 = (state_24078[(15)]);
var state_24078__$1 = state_24078;
var statearr_24092_24193 = state_24078__$1;
(statearr_24092_24193[(2)] = inst_24037);

(statearr_24092_24193[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (4))){
var inst_23942 = (state_24078[(2)]);
var state_24078__$1 = state_24078;
var statearr_24093_24194 = state_24078__$1;
(statearr_24093_24194[(2)] = inst_23942);

(statearr_24093_24194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (54))){
var inst_24057 = (state_24078[(13)]);
var inst_24051 = (state_24078[(16)]);
var inst_24059 = cljs.core.PersistentVector.EMPTY;
var inst_24060 = cljs.core.into.call(null,inst_24059,inst_24051,inst_24057);
var state_24078__$1 = state_24078;
var statearr_24094_24195 = state_24078__$1;
(statearr_24094_24195[(2)] = inst_24060);

(statearr_24094_24195[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (15))){
var inst_23969 = (state_24078[(17)]);
var inst_23971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23972 = [inst_23969];
var inst_23973 = (new cljs.core.PersistentVector(null,1,(5),inst_23971,inst_23972,null));
var state_24078__$1 = state_24078;
var statearr_24095_24196 = state_24078__$1;
(statearr_24095_24196[(2)] = inst_23973);

(statearr_24095_24196[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (48))){
var inst_23986 = (state_24078[(10)]);
var inst_23984 = (state_24078[(9)]);
var inst_23985 = (state_24078[(11)]);
var inst_23996 = (state_24078[(18)]);
var inst_24007 = (state_24078[(19)]);
var inst_24043 = (state_24078[(20)]);
var inst_24002 = (state_24078[(21)]);
var inst_24045 = (function (){var map__23978 = inst_23984;
var headers = inst_23985;
var tuples = inst_23986;
var offset_SINGLEQUOTE_ = inst_23996;
var single_result_QMARK_ = inst_24002;
var pp_keys = inst_24007;
var G__24008 = inst_24043;
return (function (p1__23935_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__23935_SHARP_);
});
})();
var inst_24046 = cljs.core.map.call(null,inst_24045);
var inst_24047 = cljs.core.conj.call(null,inst_24043,inst_24046);
var state_24078__$1 = state_24078;
var statearr_24096_24197 = state_24078__$1;
(statearr_24096_24197[(2)] = inst_24047);

(statearr_24096_24197[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (50))){
var inst_24050 = (state_24078[(2)]);
var inst_24051 = cljs.core.apply.call(null,cljs.core.comp,inst_24050);
var state_24078__$1 = (function (){var statearr_24097 = state_24078;
(statearr_24097[(16)] = inst_24051);

return statearr_24097;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24098_24198 = state_24078__$1;
(statearr_24098_24198[(1)] = (51));

} else {
var statearr_24099_24199 = state_24078__$1;
(statearr_24099_24199[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (21))){
var inst_23989 = cljs.core.not.call(null,groupBy);
var state_24078__$1 = state_24078;
var statearr_24100_24200 = state_24078__$1;
(statearr_24100_24200[(2)] = inst_23989);

(statearr_24100_24200[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (31))){
var state_24078__$1 = state_24078;
var statearr_24101_24201 = state_24078__$1;
(statearr_24101_24201[(2)] = null);

(statearr_24101_24201[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (32))){
var inst_23985 = (state_24078[(11)]);
var inst_24002 = (state_24078[(21)]);
var inst_24007 = (state_24078[(2)]);
var inst_24009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24010 = fluree.db.query.fql.select_tuples_fn.call(null,inst_23985,vars,select);
var inst_24011 = cljs.core.map.call(null,inst_24010);
var inst_24012 = [inst_24011];
var inst_24013 = (new cljs.core.PersistentVector(null,1,(5),inst_24009,inst_24012,null));
var state_24078__$1 = (function (){var statearr_24102 = state_24078;
(statearr_24102[(22)] = inst_24013);

(statearr_24102[(19)] = inst_24007);

return statearr_24102;
})();
if(cljs.core.truth_(inst_24002)){
var statearr_24103_24202 = state_24078__$1;
(statearr_24103_24202[(1)] = (33));

} else {
var statearr_24104_24203 = state_24078__$1;
(statearr_24104_24203[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (40))){
var inst_24025 = (state_24078[(14)]);
var state_24078__$1 = state_24078;
var statearr_24105_24204 = state_24078__$1;
(statearr_24105_24204[(2)] = inst_24025);

(statearr_24105_24204[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (56))){
var inst_24063 = (state_24078[(2)]);
var state_24078__$1 = (function (){var statearr_24106 = state_24078;
(statearr_24106[(12)] = inst_24063);

return statearr_24106;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24107_24205 = state_24078__$1;
(statearr_24107_24205[(1)] = (57));

} else {
var statearr_24108_24206 = state_24078__$1;
(statearr_24108_24206[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (33))){
var inst_24013 = (state_24078[(22)]);
var inst_24015 = cljs.core.map.call(null,cljs.core.first);
var inst_24016 = cljs.core.conj.call(null,inst_24013,inst_24015);
var state_24078__$1 = state_24078;
var statearr_24109_24207 = state_24078__$1;
(statearr_24109_24207[(2)] = inst_24016);

(statearr_24109_24207[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (13))){
var inst_23958 = (state_24078[(23)]);
var state_24078__$1 = state_24078;
var statearr_24110_24208 = state_24078__$1;
(statearr_24110_24208[(2)] = inst_23958);

(statearr_24110_24208[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (22))){
var inst_23987 = (state_24078[(8)]);
var state_24078__$1 = state_24078;
var statearr_24111_24209 = state_24078__$1;
(statearr_24111_24209[(2)] = inst_23987);

(statearr_24111_24209[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (36))){
var inst_24019 = (state_24078[(24)]);
var inst_24021 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_24022 = cljs.core.conj.call(null,inst_24019,inst_24021);
var state_24078__$1 = state_24078;
var statearr_24112_24210 = state_24078__$1;
(statearr_24112_24210[(2)] = inst_24022);

(statearr_24112_24210[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (41))){
var inst_23996 = (state_24078[(18)]);
var inst_24031 = (state_24078[(2)]);
var state_24078__$1 = (function (){var statearr_24113 = state_24078;
(statearr_24113[(25)] = inst_24031);

return statearr_24113;
})();
if(cljs.core.truth_(inst_23996)){
var statearr_24114_24211 = state_24078__$1;
(statearr_24114_24211[(1)] = (42));

} else {
var statearr_24115_24212 = state_24078__$1;
(statearr_24115_24212[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (43))){
var inst_24031 = (state_24078[(25)]);
var state_24078__$1 = state_24078;
var statearr_24116_24213 = state_24078__$1;
(statearr_24116_24213[(2)] = inst_24031);

(statearr_24116_24213[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (29))){
var inst_24002 = (state_24078[(2)]);
var state_24078__$1 = (function (){var statearr_24117 = state_24078;
(statearr_24117[(21)] = inst_24002);

return statearr_24117;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24118_24214 = state_24078__$1;
(statearr_24118_24214[(1)] = (30));

} else {
var statearr_24119_24215 = state_24078__$1;
(statearr_24119_24215[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (44))){
var inst_24037 = (state_24078[(2)]);
var state_24078__$1 = (function (){var statearr_24120 = state_24078;
(statearr_24120[(15)] = inst_24037);

return statearr_24120;
})();
if(cljs.core.truth_(group_limit)){
var statearr_24121_24216 = state_24078__$1;
(statearr_24121_24216[(1)] = (45));

} else {
var statearr_24122_24217 = state_24078__$1;
(statearr_24122_24217[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (6))){
var inst_23950 = cljs.core.count.call(null,select);
var inst_23951 = cljs.core._EQ_.call(null,(1),inst_23950);
var state_24078__$1 = state_24078;
var statearr_24123_24218 = state_24078__$1;
(statearr_24123_24218[(2)] = inst_23951);

(statearr_24123_24218[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (28))){
var inst_23997 = (state_24078[(26)]);
var state_24078__$1 = state_24078;
var statearr_24124_24219 = state_24078__$1;
(statearr_24124_24219[(2)] = inst_23997);

(statearr_24124_24219[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (51))){
var inst_23986 = (state_24078[(10)]);
var inst_23985 = (state_24078[(11)]);
var inst_24054 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_23985,orderBy,inst_23986);
var state_24078__$1 = state_24078;
var statearr_24125_24220 = state_24078__$1;
(statearr_24125_24220[(2)] = inst_24054);

(statearr_24125_24220[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (25))){
var state_24078__$1 = state_24078;
var statearr_24126_24221 = state_24078__$1;
(statearr_24126_24221[(2)] = null);

(statearr_24126_24221[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (34))){
var inst_24013 = (state_24078[(22)]);
var state_24078__$1 = state_24078;
var statearr_24127_24222 = state_24078__$1;
(statearr_24127_24222[(2)] = inst_24013);

(statearr_24127_24222[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (17))){
var inst_23976 = (state_24078[(2)]);
var state_24078__$1 = state_24078;
var statearr_24128_24223 = state_24078__$1;
(statearr_24128_24223[(2)] = inst_23976);

(statearr_24128_24223[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (3))){
var inst_24076 = (state_24078[(2)]);
var state_24078__$1 = state_24078;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24078__$1,inst_24076);
} else {
if((state_val_24079 === (12))){
var inst_23958 = (state_24078[(23)]);
var inst_23960 = cljs.core.first.call(null,select);
var inst_23961 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_23960);
var inst_23962 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23961);
var inst_23963 = cljs.core.subs.call(null,inst_23962,(1));
var inst_23964 = [inst_23963];
var inst_23965 = [inst_23958];
var inst_23966 = cljs.core.PersistentHashMap.fromArrays(inst_23964,inst_23965);
var state_24078__$1 = state_24078;
var statearr_24129_24224 = state_24078__$1;
(statearr_24129_24224[(2)] = inst_23966);

(statearr_24129_24224[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (2))){
var inst_23948 = (state_24078[(7)]);
var _ = (function (){var statearr_24130 = state_24078;
(statearr_24130[(4)] = cljs.core.cons.call(null,(5),(state_24078[(4)])));

return statearr_24130;
})();
var inst_23948__$1 = aggregates;
var state_24078__$1 = (function (){var statearr_24131 = state_24078;
(statearr_24131[(7)] = inst_23948__$1);

return statearr_24131;
})();
if(cljs.core.truth_(inst_23948__$1)){
var statearr_24132_24225 = state_24078__$1;
(statearr_24132_24225[(1)] = (6));

} else {
var statearr_24133_24226 = state_24078__$1;
(statearr_24133_24226[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (23))){
var inst_23992 = (state_24078[(2)]);
var state_24078__$1 = state_24078;
if(cljs.core.truth_(inst_23992)){
var statearr_24134_24227 = state_24078__$1;
(statearr_24134_24227[(1)] = (24));

} else {
var statearr_24135_24228 = state_24078__$1;
(statearr_24135_24228[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (47))){
var inst_24043 = (state_24078[(2)]);
var state_24078__$1 = (function (){var statearr_24136 = state_24078;
(statearr_24136[(20)] = inst_24043);

return statearr_24136;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24137_24229 = state_24078__$1;
(statearr_24137_24229[(1)] = (48));

} else {
var statearr_24138_24230 = state_24078__$1;
(statearr_24138_24230[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (35))){
var inst_24019 = (state_24078[(2)]);
var state_24078__$1 = (function (){var statearr_24139 = state_24078;
(statearr_24139[(24)] = inst_24019);

return statearr_24139;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24140_24231 = state_24078__$1;
(statearr_24140_24231[(1)] = (36));

} else {
var statearr_24141_24232 = state_24078__$1;
(statearr_24141_24232[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (19))){
var state_24078__$1 = state_24078;
var statearr_24142_24233 = state_24078__$1;
(statearr_24142_24233[(2)] = res);

(statearr_24142_24233[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (57))){
var inst_24007 = (state_24078[(19)]);
var inst_24063 = (state_24078[(12)]);
var inst_24002 = (state_24078[(21)]);
var inst_24065 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_24007,inst_24002,db,fuel,max_fuel,opts,(8),inst_24063);
var state_24078__$1 = state_24078;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24078__$1,(60),inst_24065);
} else {
if((state_val_24079 === (11))){
var inst_24073 = (state_24078[(2)]);
var _ = (function (){var statearr_24144 = state_24078;
(statearr_24144[(4)] = cljs.core.rest.call(null,(state_24078[(4)])));

return statearr_24144;
})();
var state_24078__$1 = state_24078;
var statearr_24145_24234 = state_24078__$1;
(statearr_24145_24234[(2)] = inst_24073);

(statearr_24145_24234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (9))){
var inst_23956 = cljs.core.first.call(null,aggregates);
var inst_23957 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_23956);
var inst_23958 = cljs.core.second.call(null,inst_23957);
var state_24078__$1 = (function (){var statearr_24146 = state_24078;
(statearr_24146[(23)] = inst_23958);

return statearr_24146;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24147_24235 = state_24078__$1;
(statearr_24147_24235[(1)] = (12));

} else {
var statearr_24148_24236 = state_24078__$1;
(statearr_24148_24236[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (5))){
var _ = (function (){var statearr_24149 = state_24078;
(statearr_24149[(4)] = cljs.core.rest.call(null,(state_24078[(4)])));

return statearr_24149;
})();
var state_24078__$1 = state_24078;
var ex24143 = (state_24078__$1[(2)]);
var statearr_24150_24237 = state_24078__$1;
(statearr_24150_24237[(5)] = ex24143);


if((ex24143 instanceof Error)){
var statearr_24151_24238 = state_24078__$1;
(statearr_24151_24238[(1)] = (4));

(statearr_24151_24238[(5)] = null);

} else {
throw ex24143;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (14))){
var inst_23969 = (state_24078[(2)]);
var state_24078__$1 = (function (){var statearr_24152 = state_24078;
(statearr_24152[(17)] = inst_23969);

return statearr_24152;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24153_24239 = state_24078__$1;
(statearr_24153_24239[(1)] = (15));

} else {
var statearr_24154_24240 = state_24078__$1;
(statearr_24154_24240[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (45))){
var inst_24037 = (state_24078[(15)]);
var inst_24039 = cljs.core.take.call(null,group_limit);
var inst_24040 = cljs.core.conj.call(null,inst_24037,inst_24039);
var state_24078__$1 = state_24078;
var statearr_24155_24241 = state_24078__$1;
(statearr_24155_24241[(2)] = inst_24040);

(statearr_24155_24241[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (53))){
var inst_24057 = (state_24078[(2)]);
var state_24078__$1 = (function (){var statearr_24156 = state_24078;
(statearr_24156[(13)] = inst_24057);

return statearr_24156;
})();
var statearr_24157_24242 = state_24078__$1;
(statearr_24157_24242[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (26))){
var inst_23997 = (state_24078[(26)]);
var inst_23996 = (state_24078[(2)]);
var inst_23997__$1 = cljs.core.not.call(null,prettyPrint);
var state_24078__$1 = (function (){var statearr_24159 = state_24078;
(statearr_24159[(26)] = inst_23997__$1);

(statearr_24159[(18)] = inst_23996);

return statearr_24159;
})();
if(inst_23997__$1){
var statearr_24160_24243 = state_24078__$1;
(statearr_24160_24243[(1)] = (27));

} else {
var statearr_24161_24244 = state_24078__$1;
(statearr_24161_24244[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (16))){
var inst_23969 = (state_24078[(17)]);
var state_24078__$1 = state_24078;
var statearr_24162_24245 = state_24078__$1;
(statearr_24162_24245[(2)] = inst_23969);

(statearr_24162_24245[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (38))){
var inst_24025 = (state_24078[(2)]);
var state_24078__$1 = (function (){var statearr_24163 = state_24078;
(statearr_24163[(14)] = inst_24025);

return statearr_24163;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24164_24246 = state_24078__$1;
(statearr_24164_24246[(1)] = (39));

} else {
var statearr_24165_24247 = state_24078__$1;
(statearr_24165_24247[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (30))){
var inst_24004 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_24078__$1 = state_24078;
var statearr_24166_24248 = state_24078__$1;
(statearr_24166_24248[(2)] = inst_24004);

(statearr_24166_24248[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (10))){
var state_24078__$1 = state_24078;
if(cljs.core.truth_(aggregates)){
var statearr_24167_24249 = state_24078__$1;
(statearr_24167_24249[(1)] = (18));

} else {
var statearr_24168_24250 = state_24078__$1;
(statearr_24168_24250[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (18))){
var inst_23980 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_24078__$1 = state_24078;
var statearr_24169_24251 = state_24078__$1;
(statearr_24169_24251[(2)] = inst_23980);

(statearr_24169_24251[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (52))){
var inst_23986 = (state_24078[(10)]);
var state_24078__$1 = state_24078;
var statearr_24170_24252 = state_24078__$1;
(statearr_24170_24252[(2)] = inst_23986);

(statearr_24170_24252[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (42))){
var inst_24031 = (state_24078[(25)]);
var inst_23996 = (state_24078[(18)]);
var inst_24033 = cljs.core.drop.call(null,inst_23996);
var inst_24034 = cljs.core.conj.call(null,inst_24031,inst_24033);
var state_24078__$1 = state_24078;
var statearr_24171_24253 = state_24078__$1;
(statearr_24171_24253[(2)] = inst_24034);

(statearr_24171_24253[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (37))){
var inst_24019 = (state_24078[(24)]);
var state_24078__$1 = state_24078;
var statearr_24172_24254 = state_24078__$1;
(statearr_24172_24254[(2)] = inst_24019);

(statearr_24172_24254[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (8))){
var inst_23954 = (state_24078[(2)]);
var state_24078__$1 = state_24078;
if(cljs.core.truth_(inst_23954)){
var statearr_24173_24255 = state_24078__$1;
(statearr_24173_24255[(1)] = (9));

} else {
var statearr_24174_24256 = state_24078__$1;
(statearr_24174_24256[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24079 === (49))){
var inst_24043 = (state_24078[(20)]);
var state_24078__$1 = state_24078;
var statearr_24175_24257 = state_24078__$1;
(statearr_24175_24257[(2)] = inst_24043);

(statearr_24175_24257[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_24176 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24176[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_24176[(1)] = (1));

return statearr_24176;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_24078){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24078);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24177){var ex__2749__auto__ = e24177;
var statearr_24178_24258 = state_24078;
(statearr_24178_24258[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24078[(4)]))){
var statearr_24179_24259 = state_24078;
(statearr_24179_24259[(1)] = cljs.core.first.call(null,(state_24078[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24260 = state_24078;
state_24078 = G__24260;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_24078){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_24078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24180 = f__2769__auto__.call(null);
(statearr_24180[(6)] = c__2768__auto__);

return statearr_24180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__24263,groupBy){
var map__24264 = p__24263;
var map__24264__$1 = cljs.core.__destructure_map.call(null,map__24264);
var res = map__24264__$1;
var headers = cljs.core.get.call(null,map__24264__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__24264__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__24265 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__24265,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__24265,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__24261_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__24261_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__24262_SHARP_){
return cljs.core.nth.call(null,tuple,p1__24262_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__24268 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__24268,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__24268,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__24271,p__24272,opts){
var map__24273 = p__24271;
var map__24273__$1 = cljs.core.__destructure_map.call(null,map__24273);
var res = map__24273__$1;
var headers = cljs.core.get.call(null,map__24273__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__24273__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24274 = p__24272;
var map__24274__$1 = cljs.core.__destructure_map.call(null,map__24274);
var select_spec = map__24274__$1;
var groupBy = cljs.core.get.call(null,map__24274__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__24274__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__24274__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__24274__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__24274__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__24274__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__24274__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24516){
var state_val_24517 = (state_24516[(1)]);
if((state_val_24517 === (65))){
var state_24516__$1 = state_24516;
var statearr_24518_24669 = state_24516__$1;
(statearr_24518_24669[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (70))){
var inst_24437 = (state_24516[(7)]);
var state_24516__$1 = state_24516;
var statearr_24520_24670 = state_24516__$1;
(statearr_24520_24670[(2)] = inst_24437);

(statearr_24520_24670[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (62))){
var state_24516__$1 = state_24516;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24521_24671 = state_24516__$1;
(statearr_24521_24671[(1)] = (64));

} else {
var statearr_24522_24672 = state_24516__$1;
(statearr_24522_24672[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (74))){
var inst_24344 = (state_24516[(8)]);
var inst_24353 = (state_24516[(9)]);
var inst_24412 = (state_24516[(10)]);
var inst_24445 = cljs.core.assoc.call(null,inst_24344,inst_24353,inst_24412);
var state_24516__$1 = state_24516;
var statearr_24523_24673 = state_24516__$1;
(statearr_24523_24673[(2)] = inst_24445);

(statearr_24523_24673[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (7))){
var state_24516__$1 = state_24516;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_24524_24674 = state_24516__$1;
(statearr_24524_24674[(1)] = (82));

} else {
var statearr_24525_24675 = state_24516__$1;
(statearr_24525_24675[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (59))){
var inst_24412 = (state_24516[(10)]);
var inst_24342 = (state_24516[(11)]);
var inst_24416 = cljs.core.count.call(null,inst_24412);
var inst_24417 = (inst_24342 - inst_24416);
var state_24516__$1 = state_24516;
var statearr_24526_24676 = state_24516__$1;
(statearr_24526_24676[(2)] = inst_24417);

(statearr_24526_24676[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (86))){
var state_24516__$1 = state_24516;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24527_24677 = state_24516__$1;
(statearr_24527_24677[(1)] = (89));

} else {
var statearr_24528_24678 = state_24516__$1;
(statearr_24528_24678[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (20))){
var state_24516__$1 = state_24516;
var statearr_24529_24679 = state_24516__$1;
(statearr_24529_24679[(2)] = (0));

(statearr_24529_24679[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (72))){
var inst_24442 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
if(cljs.core.truth_(inst_24442)){
var statearr_24530_24680 = state_24516__$1;
(statearr_24530_24680[(1)] = (73));

} else {
var statearr_24531_24681 = state_24516__$1;
(statearr_24531_24681[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (58))){
var state_24516__$1 = state_24516;
var statearr_24532_24682 = state_24516__$1;
(statearr_24532_24682[(2)] = null);

(statearr_24532_24682[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (60))){
var inst_24343 = (state_24516[(12)]);
var inst_24419 = (state_24516[(2)]);
var inst_24420 = (inst_24343 <= (0));
var state_24516__$1 = (function (){var statearr_24533 = state_24516;
(statearr_24533[(13)] = inst_24419);

return statearr_24533;
})();
if(cljs.core.truth_(inst_24420)){
var statearr_24534_24683 = state_24516__$1;
(statearr_24534_24683[(1)] = (61));

} else {
var statearr_24535_24684 = state_24516__$1;
(statearr_24535_24684[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (27))){
var inst_24342 = (state_24516[(11)]);
var inst_24366 = (inst_24342 < (1));
var state_24516__$1 = state_24516;
var statearr_24536_24685 = state_24516__$1;
(statearr_24536_24685[(2)] = inst_24366);

(statearr_24536_24685[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (1))){
var state_24516__$1 = state_24516;
var statearr_24537_24686 = state_24516__$1;
(statearr_24537_24686[(2)] = null);

(statearr_24537_24686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (69))){
var inst_24432 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
var statearr_24538_24687 = state_24516__$1;
(statearr_24538_24687[(2)] = inst_24432);

(statearr_24538_24687[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (24))){
var inst_24344 = (state_24516[(8)]);
var state_24516__$1 = state_24516;
var statearr_24539_24688 = state_24516__$1;
(statearr_24539_24688[(2)] = inst_24344);

(statearr_24539_24688[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (55))){
var inst_24402 = (state_24516[(14)]);
var inst_24342 = (state_24516[(11)]);
var inst_24409 = cljs.core.take.call(null,inst_24342,inst_24402);
var state_24516__$1 = state_24516;
var statearr_24540_24689 = state_24516__$1;
(statearr_24540_24689[(2)] = inst_24409);

(statearr_24540_24689[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (85))){
var inst_24487 = (state_24516[(15)]);
var inst_24486 = (state_24516[(2)]);
var inst_24487__$1 = fluree.db.util.async.throw_err.call(null,inst_24486);
var inst_24488 = cljs.core.coll_QMARK_.call(null,inst_24487__$1);
var inst_24489 = (!(inst_24488));
var state_24516__$1 = (function (){var statearr_24541 = state_24516;
(statearr_24541[(15)] = inst_24487__$1);

return statearr_24541;
})();
if(inst_24489){
var statearr_24542_24690 = state_24516__$1;
(statearr_24542_24690[(1)] = (86));

} else {
var statearr_24543_24691 = state_24516__$1;
(statearr_24543_24691[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (39))){
var inst_24361 = (state_24516[(16)]);
var inst_24383 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_24384 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_24385 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_24361,inst_24383,inst_24384);
var state_24516__$1 = state_24516;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24516__$1,(42),inst_24385);
} else {
if((state_val_24517 === (88))){
var inst_24509 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
var statearr_24544_24692 = state_24516__$1;
(statearr_24544_24692[(2)] = inst_24509);

(statearr_24544_24692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (46))){
var inst_24343 = (state_24516[(12)]);
var inst_24397 = ((0) < inst_24343);
var state_24516__$1 = state_24516;
if(cljs.core.truth_(inst_24397)){
var statearr_24545_24693 = state_24516__$1;
(statearr_24545_24693[(1)] = (49));

} else {
var statearr_24546_24694 = state_24516__$1;
(statearr_24546_24694[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (4))){
var inst_24275 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
var statearr_24547_24695 = state_24516__$1;
(statearr_24547_24695[(2)] = inst_24275);

(statearr_24547_24695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (77))){
var inst_24342 = (state_24516[(11)]);
var inst_24453 = (inst_24342 - (1));
var state_24516__$1 = state_24516;
var statearr_24548_24696 = state_24516__$1;
(statearr_24548_24696[(2)] = inst_24453);

(statearr_24548_24696[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (95))){
var inst_24487 = (state_24516[(15)]);
var state_24516__$1 = state_24516;
var statearr_24549_24697 = state_24516__$1;
(statearr_24549_24697[(2)] = inst_24487);

(statearr_24549_24697[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (54))){
var inst_24407 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
if(cljs.core.truth_(inst_24407)){
var statearr_24550_24698 = state_24516__$1;
(statearr_24550_24698[(1)] = (55));

} else {
var statearr_24551_24699 = state_24516__$1;
(statearr_24551_24699[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (92))){
var inst_24487 = (state_24516[(15)]);
var inst_24500 = cljs.core.first.call(null,inst_24487);
var state_24516__$1 = state_24516;
var statearr_24552_24700 = state_24516__$1;
(statearr_24552_24700[(2)] = inst_24500);

(statearr_24552_24700[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (15))){
var inst_24293 = (state_24516[(17)]);
var inst_24301 = (state_24516[(2)]);
var inst_24302 = fluree.db.util.async.throw_err.call(null,inst_24301);
var inst_24303 = [inst_24293];
var inst_24304 = [inst_24302];
var inst_24305 = cljs.core.PersistentHashMap.fromArrays(inst_24303,inst_24304);
var state_24516__$1 = state_24516;
var statearr_24553_24701 = state_24516__$1;
(statearr_24553_24701[(2)] = inst_24305);

(statearr_24553_24701[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (48))){
var inst_24465 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
var statearr_24554_24702 = state_24516__$1;
(statearr_24554_24702[(2)] = inst_24465);

(statearr_24554_24702[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (50))){
var inst_24388 = (state_24516[(18)]);
var state_24516__$1 = state_24516;
var statearr_24555_24703 = state_24516__$1;
(statearr_24555_24703[(2)] = inst_24388);

(statearr_24555_24703[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (75))){
var inst_24357 = (state_24516[(19)]);
var inst_24436 = (state_24516[(20)]);
var inst_24354 = (state_24516[(21)]);
var inst_24419 = (state_24516[(13)]);
var inst_24447 = (state_24516[(2)]);
var inst_24340 = inst_24354;
var inst_24341 = inst_24357;
var inst_24342 = inst_24419;
var inst_24343 = inst_24436;
var inst_24344 = inst_24447;
var state_24516__$1 = (function (){var statearr_24556 = state_24516;
(statearr_24556[(12)] = inst_24343);

(statearr_24556[(8)] = inst_24344);

(statearr_24556[(22)] = inst_24341);

(statearr_24556[(11)] = inst_24342);

(statearr_24556[(23)] = inst_24340);

return statearr_24556;
})();
var statearr_24557_24704 = state_24516__$1;
(statearr_24557_24704[(2)] = null);

(statearr_24557_24704[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (21))){
var inst_24325 = (state_24516[(24)]);
var inst_24321 = (state_24516[(25)]);
var inst_24333 = (state_24516[(26)]);
var inst_24338 = (state_24516[(2)]);
var inst_24339 = cljs.core.PersistentHashMap.EMPTY;
var inst_24340 = inst_24321;
var inst_24341 = inst_24325;
var inst_24342 = inst_24333;
var inst_24343 = inst_24338;
var inst_24344 = inst_24339;
var state_24516__$1 = (function (){var statearr_24558 = state_24516;
(statearr_24558[(12)] = inst_24343);

(statearr_24558[(8)] = inst_24344);

(statearr_24558[(22)] = inst_24341);

(statearr_24558[(11)] = inst_24342);

(statearr_24558[(23)] = inst_24340);

return statearr_24558;
})();
var statearr_24559_24705 = state_24516__$1;
(statearr_24559_24705[(2)] = null);

(statearr_24559_24705[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (31))){
var inst_24343 = (state_24516[(12)]);
var inst_24358 = (state_24516[(27)]);
var inst_24372 = (inst_24343 >= inst_24358);
var state_24516__$1 = state_24516;
if(cljs.core.truth_(inst_24372)){
var statearr_24560_24706 = state_24516__$1;
(statearr_24560_24706[(1)] = (33));

} else {
var statearr_24561_24707 = state_24516__$1;
(statearr_24561_24707[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (32))){
var inst_24472 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
var statearr_24562_24708 = state_24516__$1;
(statearr_24562_24708[(2)] = inst_24472);

(statearr_24562_24708[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (40))){
var state_24516__$1 = state_24516;
var statearr_24563_24709 = state_24516__$1;
(statearr_24563_24709[(2)] = null);

(statearr_24563_24709[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (91))){
var inst_24497 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
var statearr_24564_24710 = state_24516__$1;
(statearr_24564_24710[(2)] = inst_24497);

(statearr_24564_24710[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (56))){
var inst_24402 = (state_24516[(14)]);
var state_24516__$1 = state_24516;
var statearr_24565_24711 = state_24516__$1;
(statearr_24565_24711[(2)] = inst_24402);

(statearr_24565_24711[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (33))){
var state_24516__$1 = state_24516;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24566_24712 = state_24516__$1;
(statearr_24566_24712[(1)] = (36));

} else {
var statearr_24567_24713 = state_24516__$1;
(statearr_24567_24713[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (13))){
var inst_24325 = (state_24516[(24)]);
var inst_24290 = (state_24516[(28)]);
var inst_24321 = (state_24516[(25)]);
var inst_24321__$1 = cljs.core.keys.call(null,inst_24290);
var inst_24322 = cljs.core.seq.call(null,inst_24321__$1);
var inst_24323 = cljs.core.first.call(null,inst_24322);
var inst_24324 = cljs.core.next.call(null,inst_24322);
var inst_24325__$1 = cljs.core.vals.call(null,inst_24290);
var inst_24326 = cljs.core.seq.call(null,inst_24325__$1);
var inst_24327 = cljs.core.first.call(null,inst_24326);
var inst_24328 = cljs.core.next.call(null,inst_24326);
var inst_24329 = cljs.core._EQ_.call(null,(0),limit);
var state_24516__$1 = (function (){var statearr_24568 = state_24516;
(statearr_24568[(29)] = inst_24327);

(statearr_24568[(30)] = inst_24324);

(statearr_24568[(24)] = inst_24325__$1);

(statearr_24568[(31)] = inst_24328);

(statearr_24568[(25)] = inst_24321__$1);

(statearr_24568[(32)] = inst_24323);

return statearr_24568;
})();
if(inst_24329){
var statearr_24569_24714 = state_24516__$1;
(statearr_24569_24714[(1)] = (16));

} else {
var statearr_24570_24715 = state_24516__$1;
(statearr_24570_24715[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (22))){
var inst_24341 = (state_24516[(22)]);
var inst_24340 = (state_24516[(23)]);
var inst_24352 = cljs.core.seq.call(null,inst_24340);
var inst_24353 = cljs.core.first.call(null,inst_24352);
var inst_24354 = cljs.core.next.call(null,inst_24352);
var inst_24355 = cljs.core.seq.call(null,inst_24341);
var inst_24356 = cljs.core.first.call(null,inst_24355);
var inst_24357 = cljs.core.next.call(null,inst_24355);
var inst_24358 = cljs.core.count.call(null,inst_24356);
var inst_24359 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_24360 = [headers,vars,inst_24356];
var inst_24361 = cljs.core.PersistentHashMap.fromArrays(inst_24359,inst_24360);
var inst_24362 = (inst_24356 == null);
var state_24516__$1 = (function (){var statearr_24571 = state_24516;
(statearr_24571[(9)] = inst_24353);

(statearr_24571[(19)] = inst_24357);

(statearr_24571[(21)] = inst_24354);

(statearr_24571[(16)] = inst_24361);

(statearr_24571[(27)] = inst_24358);

return statearr_24571;
})();
if(cljs.core.truth_(inst_24362)){
var statearr_24572_24716 = state_24516__$1;
(statearr_24572_24716[(1)] = (24));

} else {
var statearr_24573_24717 = state_24516__$1;
(statearr_24573_24717[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (90))){
var inst_24487 = (state_24516[(15)]);
var state_24516__$1 = state_24516;
var statearr_24574_24718 = state_24516__$1;
(statearr_24574_24718[(2)] = inst_24487);

(statearr_24574_24718[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (36))){
var inst_24343 = (state_24516[(12)]);
var inst_24375 = (inst_24343 - (1));
var state_24516__$1 = state_24516;
var statearr_24575_24719 = state_24516__$1;
(statearr_24575_24719[(2)] = inst_24375);

(statearr_24575_24719[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (41))){
var inst_24468 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
var statearr_24576_24720 = state_24516__$1;
(statearr_24576_24720[(2)] = inst_24468);

(statearr_24576_24720[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (89))){
var inst_24487 = (state_24516[(15)]);
var inst_24492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24493 = [inst_24487];
var inst_24494 = (new cljs.core.PersistentVector(null,1,(5),inst_24492,inst_24493,null));
var state_24516__$1 = state_24516;
var statearr_24577_24721 = state_24516__$1;
(statearr_24577_24721[(2)] = inst_24494);

(statearr_24577_24721[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (43))){
var inst_24388 = (state_24516[(18)]);
var inst_24391 = cljs.core.seq.call(null,inst_24388);
var state_24516__$1 = state_24516;
var statearr_24578_24722 = state_24516__$1;
(statearr_24578_24722[(2)] = inst_24391);

(statearr_24578_24722[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (61))){
var state_24516__$1 = state_24516;
var statearr_24579_24723 = state_24516__$1;
(statearr_24579_24723[(2)] = (0));

(statearr_24579_24723[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (29))){
var inst_24369 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
if(cljs.core.truth_(inst_24369)){
var statearr_24580_24724 = state_24516__$1;
(statearr_24580_24724[(1)] = (30));

} else {
var statearr_24581_24725 = state_24516__$1;
(statearr_24581_24725[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (44))){
var inst_24389 = (state_24516[(33)]);
var state_24516__$1 = state_24516;
var statearr_24582_24726 = state_24516__$1;
(statearr_24582_24726[(2)] = inst_24389);

(statearr_24582_24726[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (93))){
var state_24516__$1 = state_24516;
var statearr_24583_24727 = state_24516__$1;
(statearr_24583_24727[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (6))){
var inst_24282 = (state_24516[(34)]);
var inst_24282__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_24284 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_24516__$1 = (function (){var statearr_24585 = state_24516;
(statearr_24585[(35)] = inst_24284);

(statearr_24585[(34)] = inst_24282__$1);

return statearr_24585;
})();
if(cljs.core.truth_(inst_24282__$1)){
var statearr_24586_24728 = state_24516__$1;
(statearr_24586_24728[(1)] = (9));

} else {
var statearr_24587_24729 = state_24516__$1;
(statearr_24587_24729[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (28))){
var inst_24342 = (state_24516[(11)]);
var state_24516__$1 = state_24516;
var statearr_24588_24730 = state_24516__$1;
(statearr_24588_24730[(2)] = inst_24342);

(statearr_24588_24730[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (64))){
var inst_24343 = (state_24516[(12)]);
var inst_24424 = (inst_24343 - (1));
var state_24516__$1 = state_24516;
var statearr_24589_24731 = state_24516__$1;
(statearr_24589_24731[(2)] = inst_24424);

(statearr_24589_24731[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (51))){
var inst_24342 = (state_24516[(11)]);
var inst_24402 = (state_24516[(2)]);
var state_24516__$1 = (function (){var statearr_24590 = state_24516;
(statearr_24590[(14)] = inst_24402);

return statearr_24590;
})();
if(cljs.core.truth_(inst_24342)){
var statearr_24591_24732 = state_24516__$1;
(statearr_24591_24732[(1)] = (52));

} else {
var statearr_24592_24733 = state_24516__$1;
(statearr_24592_24733[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (25))){
var inst_24342 = (state_24516[(11)]);
var state_24516__$1 = state_24516;
if(cljs.core.truth_(inst_24342)){
var statearr_24593_24734 = state_24516__$1;
(statearr_24593_24734[(1)] = (27));

} else {
var statearr_24594_24735 = state_24516__$1;
(statearr_24594_24735[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (34))){
var state_24516__$1 = state_24516;
var statearr_24595_24736 = state_24516__$1;
(statearr_24595_24736[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (17))){
var state_24516__$1 = state_24516;
var statearr_24597_24737 = state_24516__$1;
(statearr_24597_24737[(2)] = limit);

(statearr_24597_24737[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (3))){
var inst_24514 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24516__$1,inst_24514);
} else {
if((state_val_24517 === (12))){
var inst_24290 = (state_24516[(28)]);
var inst_24292 = cljs.core.keys.call(null,inst_24290);
var inst_24293 = cljs.core.first.call(null,inst_24292);
var inst_24294 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_24295 = cljs.core.vals.call(null,inst_24290);
var inst_24296 = cljs.core.first.call(null,inst_24295);
var inst_24297 = [headers,vars,inst_24296];
var inst_24298 = cljs.core.PersistentHashMap.fromArrays(inst_24294,inst_24297);
var inst_24299 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_24298,select_spec,limit,opts);
var state_24516__$1 = (function (){var statearr_24598 = state_24516;
(statearr_24598[(17)] = inst_24293);

return statearr_24598;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24516__$1,(15),inst_24299);
} else {
if((state_val_24517 === (2))){
var _ = (function (){var statearr_24599 = state_24516;
(statearr_24599[(4)] = cljs.core.cons.call(null,(5),(state_24516[(4)])));

return statearr_24599;
})();
var state_24516__$1 = state_24516;
if(cljs.core.truth_(groupBy)){
var statearr_24600_24738 = state_24516__$1;
(statearr_24600_24738[(1)] = (6));

} else {
var statearr_24601_24739 = state_24516__$1;
(statearr_24601_24739[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (66))){
var inst_24434 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
var statearr_24602_24740 = state_24516__$1;
(statearr_24602_24740[(2)] = inst_24434);

(statearr_24602_24740[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (23))){
var inst_24476 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
var statearr_24603_24741 = state_24516__$1;
(statearr_24603_24741[(2)] = inst_24476);

(statearr_24603_24741[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (47))){
var inst_24342 = (state_24516[(11)]);
var inst_24450 = (inst_24342 == null);
var state_24516__$1 = state_24516;
if(cljs.core.truth_(inst_24450)){
var statearr_24604_24742 = state_24516__$1;
(statearr_24604_24742[(1)] = (76));

} else {
var statearr_24605_24743 = state_24516__$1;
(statearr_24605_24743[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (35))){
var inst_24470 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
var statearr_24606_24744 = state_24516__$1;
(statearr_24606_24744[(2)] = inst_24470);

(statearr_24606_24744[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (82))){
var state_24516__$1 = state_24516;
var statearr_24607_24745 = state_24516__$1;
(statearr_24607_24745[(2)] = (1));

(statearr_24607_24745[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (76))){
var state_24516__$1 = state_24516;
var statearr_24608_24746 = state_24516__$1;
(statearr_24608_24746[(2)] = null);

(statearr_24608_24746[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (97))){
var inst_24505 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
var statearr_24609_24747 = state_24516__$1;
(statearr_24609_24747[(2)] = inst_24505);

(statearr_24609_24747[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (19))){
var inst_24334 = (state_24516[(36)]);
var state_24516__$1 = state_24516;
var statearr_24610_24748 = state_24516__$1;
(statearr_24610_24748[(2)] = inst_24334);

(statearr_24610_24748[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (57))){
var inst_24342 = (state_24516[(11)]);
var inst_24412 = (state_24516[(2)]);
var inst_24413 = (inst_24342 == null);
var state_24516__$1 = (function (){var statearr_24611 = state_24516;
(statearr_24611[(10)] = inst_24412);

return statearr_24611;
})();
if(cljs.core.truth_(inst_24413)){
var statearr_24612_24749 = state_24516__$1;
(statearr_24612_24749[(1)] = (58));

} else {
var statearr_24613_24750 = state_24516__$1;
(statearr_24613_24750[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (68))){
var state_24516__$1 = state_24516;
var statearr_24614_24751 = state_24516__$1;
(statearr_24614_24751[(2)] = null);

(statearr_24614_24751[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (11))){
var inst_24290 = (state_24516[(2)]);
var state_24516__$1 = (function (){var statearr_24616 = state_24516;
(statearr_24616[(28)] = inst_24290);

return statearr_24616;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_24617_24752 = state_24516__$1;
(statearr_24617_24752[(1)] = (12));

} else {
var statearr_24618_24753 = state_24516__$1;
(statearr_24618_24753[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (9))){
var inst_24284 = (state_24516[(35)]);
var inst_24282 = (state_24516[(34)]);
var inst_24286 = cljs.core.sorted_map_by.call(null,inst_24282);
var inst_24287 = cljs.core.into.call(null,inst_24286,inst_24284);
var state_24516__$1 = state_24516;
var statearr_24619_24754 = state_24516__$1;
(statearr_24619_24754[(2)] = inst_24287);

(statearr_24619_24754[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (5))){
var _ = (function (){var statearr_24620 = state_24516;
(statearr_24620[(4)] = cljs.core.rest.call(null,(state_24516[(4)])));

return statearr_24620;
})();
var state_24516__$1 = state_24516;
var ex24615 = (state_24516__$1[(2)]);
var statearr_24621_24755 = state_24516__$1;
(statearr_24621_24755[(5)] = ex24615);


if((ex24615 instanceof Error)){
var statearr_24622_24756 = state_24516__$1;
(statearr_24622_24756[(1)] = (4));

(statearr_24622_24756[(5)] = null);

} else {
throw ex24615;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (83))){
var state_24516__$1 = state_24516;
var statearr_24623_24757 = state_24516__$1;
(statearr_24623_24757[(2)] = limit);

(statearr_24623_24757[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (14))){
var inst_24478 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
var statearr_24624_24758 = state_24516__$1;
(statearr_24624_24758[(2)] = inst_24478);

(statearr_24624_24758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (45))){
var inst_24394 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
if(cljs.core.truth_(inst_24394)){
var statearr_24625_24759 = state_24516__$1;
(statearr_24625_24759[(1)] = (46));

} else {
var statearr_24626_24760 = state_24516__$1;
(statearr_24626_24760[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (53))){
var inst_24342 = (state_24516[(11)]);
var state_24516__$1 = state_24516;
var statearr_24627_24761 = state_24516__$1;
(statearr_24627_24761[(2)] = inst_24342);

(statearr_24627_24761[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (78))){
var inst_24343 = (state_24516[(12)]);
var inst_24455 = (state_24516[(2)]);
var inst_24456 = (inst_24343 <= (0));
var state_24516__$1 = (function (){var statearr_24628 = state_24516;
(statearr_24628[(37)] = inst_24455);

return statearr_24628;
})();
if(cljs.core.truth_(inst_24456)){
var statearr_24629_24762 = state_24516__$1;
(statearr_24629_24762[(1)] = (79));

} else {
var statearr_24630_24763 = state_24516__$1;
(statearr_24630_24763[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (26))){
var inst_24474 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
var statearr_24631_24764 = state_24516__$1;
(statearr_24631_24764[(2)] = inst_24474);

(statearr_24631_24764[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (16))){
var state_24516__$1 = state_24516;
var statearr_24632_24765 = state_24516__$1;
(statearr_24632_24765[(2)] = null);

(statearr_24632_24765[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (81))){
var inst_24344 = (state_24516[(8)]);
var inst_24388 = (state_24516[(18)]);
var inst_24353 = (state_24516[(9)]);
var inst_24357 = (state_24516[(19)]);
var inst_24354 = (state_24516[(21)]);
var inst_24455 = (state_24516[(37)]);
var inst_24461 = (state_24516[(2)]);
var inst_24462 = cljs.core.assoc.call(null,inst_24344,inst_24353,inst_24388);
var inst_24340 = inst_24354;
var inst_24341 = inst_24357;
var inst_24342 = inst_24455;
var inst_24343 = inst_24461;
var inst_24344__$1 = inst_24462;
var state_24516__$1 = (function (){var statearr_24635 = state_24516;
(statearr_24635[(12)] = inst_24343);

(statearr_24635[(8)] = inst_24344__$1);

(statearr_24635[(22)] = inst_24341);

(statearr_24635[(11)] = inst_24342);

(statearr_24635[(23)] = inst_24340);

return statearr_24635;
})();
var statearr_24636_24766 = state_24516__$1;
(statearr_24636_24766[(2)] = null);

(statearr_24636_24766[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (79))){
var state_24516__$1 = state_24516;
var statearr_24637_24767 = state_24516__$1;
(statearr_24637_24767[(2)] = (0));

(statearr_24637_24767[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (38))){
var inst_24344 = (state_24516[(8)]);
var inst_24357 = (state_24516[(19)]);
var inst_24354 = (state_24516[(21)]);
var inst_24342 = (state_24516[(11)]);
var inst_24379 = (state_24516[(2)]);
var tmp24633 = inst_24344;
var tmp24634 = inst_24342;
var inst_24340 = inst_24354;
var inst_24341 = inst_24357;
var inst_24342__$1 = tmp24634;
var inst_24343 = inst_24379;
var inst_24344__$1 = tmp24633;
var state_24516__$1 = (function (){var statearr_24638 = state_24516;
(statearr_24638[(12)] = inst_24343);

(statearr_24638[(8)] = inst_24344__$1);

(statearr_24638[(22)] = inst_24341);

(statearr_24638[(11)] = inst_24342__$1);

(statearr_24638[(23)] = inst_24340);

return statearr_24638;
})();
var statearr_24639_24768 = state_24516__$1;
(statearr_24639_24768[(2)] = null);

(statearr_24639_24768[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (87))){
var state_24516__$1 = state_24516;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_24640_24769 = state_24516__$1;
(statearr_24640_24769[(1)] = (92));

} else {
var statearr_24641_24770 = state_24516__$1;
(statearr_24641_24770[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (30))){
var inst_24344 = (state_24516[(8)]);
var state_24516__$1 = state_24516;
var statearr_24642_24771 = state_24516__$1;
(statearr_24642_24771[(2)] = inst_24344);

(statearr_24642_24771[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (73))){
var inst_24344 = (state_24516[(8)]);
var state_24516__$1 = state_24516;
var statearr_24643_24772 = state_24516__$1;
(statearr_24643_24772[(2)] = inst_24344);

(statearr_24643_24772[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (96))){
var state_24516__$1 = state_24516;
var statearr_24644_24773 = state_24516__$1;
(statearr_24644_24773[(2)] = null);

(statearr_24644_24773[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (10))){
var inst_24284 = (state_24516[(35)]);
var state_24516__$1 = state_24516;
var statearr_24645_24774 = state_24516__$1;
(statearr_24645_24774[(2)] = inst_24284);

(statearr_24645_24774[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (18))){
var inst_24334 = (state_24516[(36)]);
var inst_24333 = (state_24516[(2)]);
var inst_24334__$1 = offset;
var state_24516__$1 = (function (){var statearr_24646 = state_24516;
(statearr_24646[(36)] = inst_24334__$1);

(statearr_24646[(26)] = inst_24333);

return statearr_24646;
})();
if(cljs.core.truth_(inst_24334__$1)){
var statearr_24647_24775 = state_24516__$1;
(statearr_24647_24775[(1)] = (19));

} else {
var statearr_24648_24776 = state_24516__$1;
(statearr_24648_24776[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (52))){
var inst_24342 = (state_24516[(11)]);
var inst_24404 = ((0) < inst_24342);
var state_24516__$1 = state_24516;
var statearr_24649_24777 = state_24516__$1;
(statearr_24649_24777[(2)] = inst_24404);

(statearr_24649_24777[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (67))){
var inst_24343 = (state_24516[(12)]);
var inst_24358 = (state_24516[(27)]);
var inst_24412 = (state_24516[(10)]);
var inst_24427 = cljs.core.count.call(null,inst_24412);
var inst_24428 = (inst_24358 - inst_24427);
var inst_24429 = (inst_24343 - inst_24428);
var state_24516__$1 = state_24516;
var statearr_24650_24778 = state_24516__$1;
(statearr_24650_24778[(2)] = inst_24429);

(statearr_24650_24778[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (71))){
var inst_24412 = (state_24516[(10)]);
var inst_24440 = cljs.core.empty_QMARK_.call(null,inst_24412);
var state_24516__$1 = state_24516;
var statearr_24651_24779 = state_24516__$1;
(statearr_24651_24779[(2)] = inst_24440);

(statearr_24651_24779[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (42))){
var inst_24388 = (state_24516[(18)]);
var inst_24389 = (state_24516[(33)]);
var inst_24387 = (state_24516[(2)]);
var inst_24388__$1 = fluree.db.util.async.throw_err.call(null,inst_24387);
var inst_24389__$1 = cljs.core.coll_QMARK_.call(null,inst_24388__$1);
var state_24516__$1 = (function (){var statearr_24652 = state_24516;
(statearr_24652[(18)] = inst_24388__$1);

(statearr_24652[(33)] = inst_24389__$1);

return statearr_24652;
})();
if(inst_24389__$1){
var statearr_24653_24780 = state_24516__$1;
(statearr_24653_24780[(1)] = (43));

} else {
var statearr_24654_24781 = state_24516__$1;
(statearr_24654_24781[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (80))){
var inst_24343 = (state_24516[(12)]);
var inst_24459 = (inst_24343 - (1));
var state_24516__$1 = state_24516;
var statearr_24655_24782 = state_24516__$1;
(statearr_24655_24782[(2)] = inst_24459);

(statearr_24655_24782[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (37))){
var inst_24343 = (state_24516[(12)]);
var inst_24358 = (state_24516[(27)]);
var inst_24377 = (inst_24343 - inst_24358);
var state_24516__$1 = state_24516;
var statearr_24656_24783 = state_24516__$1;
(statearr_24656_24783[(2)] = inst_24377);

(statearr_24656_24783[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (63))){
var inst_24437 = (state_24516[(7)]);
var inst_24412 = (state_24516[(10)]);
var inst_24436 = (state_24516[(2)]);
var inst_24437__$1 = (inst_24412 == null);
var state_24516__$1 = (function (){var statearr_24657 = state_24516;
(statearr_24657[(7)] = inst_24437__$1);

(statearr_24657[(20)] = inst_24436);

return statearr_24657;
})();
if(cljs.core.truth_(inst_24437__$1)){
var statearr_24658_24784 = state_24516__$1;
(statearr_24658_24784[(1)] = (70));

} else {
var statearr_24659_24785 = state_24516__$1;
(statearr_24659_24785[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (94))){
var inst_24507 = (state_24516[(2)]);
var state_24516__$1 = state_24516;
var statearr_24660_24786 = state_24516__$1;
(statearr_24660_24786[(2)] = inst_24507);

(statearr_24660_24786[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (8))){
var inst_24511 = (state_24516[(2)]);
var _ = (function (){var statearr_24661 = state_24516;
(statearr_24661[(4)] = cljs.core.rest.call(null,(state_24516[(4)])));

return statearr_24661;
})();
var state_24516__$1 = state_24516;
var statearr_24662_24787 = state_24516__$1;
(statearr_24662_24787[(2)] = inst_24511);

(statearr_24662_24787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (49))){
var inst_24343 = (state_24516[(12)]);
var inst_24388 = (state_24516[(18)]);
var inst_24399 = cljs.core.drop.call(null,inst_24343,inst_24388);
var state_24516__$1 = state_24516;
var statearr_24663_24788 = state_24516__$1;
(statearr_24663_24788[(2)] = inst_24399);

(statearr_24663_24788[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24517 === (84))){
var inst_24483 = (state_24516[(2)]);
var inst_24484 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_24483,opts);
var state_24516__$1 = state_24516;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24516__$1,(85),inst_24484);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0 = (function (){
var statearr_24664 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24664[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__);

(statearr_24664[(1)] = (1));

return statearr_24664;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1 = (function (state_24516){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24516);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24665){var ex__2749__auto__ = e24665;
var statearr_24666_24789 = state_24516;
(statearr_24666_24789[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24516[(4)]))){
var statearr_24667_24790 = state_24516;
(statearr_24667_24790[(1)] = cljs.core.first.call(null,(state_24516[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24791 = state_24516;
state_24516 = G__24791;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__ = function(state_24516){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1.call(this,state_24516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24668 = f__2769__auto__.call(null);
(statearr_24668[(6)] = c__2768__auto__);

return statearr_24668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Legacy ad-hoc query processor
 */
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,parsed_query,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24852){
var state_val_24853 = (state_24852[(1)]);
if((state_val_24853 === (7))){
var state_24852__$1 = state_24852;
var statearr_24854_24892 = state_24852__$1;
(statearr_24854_24892[(2)] = (0));

(statearr_24854_24892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (20))){
var inst_24836 = (state_24852[(2)]);
var state_24852__$1 = state_24852;
var statearr_24855_24893 = state_24852__$1;
(statearr_24855_24893[(2)] = inst_24836);

(statearr_24855_24893[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (1))){
var state_24852__$1 = state_24852;
var statearr_24856_24894 = state_24852__$1;
(statearr_24856_24894[(2)] = null);

(statearr_24856_24894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (4))){
var inst_24792 = (state_24852[(2)]);
var state_24852__$1 = state_24852;
var statearr_24857_24895 = state_24852__$1;
(statearr_24857_24895[(2)] = inst_24792);

(statearr_24857_24895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (15))){
var inst_24823 = (state_24852[(7)]);
var state_24852__$1 = state_24852;
var statearr_24858_24896 = state_24852__$1;
(statearr_24858_24896[(2)] = inst_24823);

(statearr_24858_24896[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (21))){
var inst_24808 = (state_24852[(8)]);
var inst_24823 = (state_24852[(7)]);
var inst_24838 = (state_24852[(9)]);
var inst_24841 = (state_24852[(2)]);
var inst_24842 = fluree.db.util.async.throw_err.call(null,inst_24841);
var inst_24843 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query);
var inst_24844 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,inst_24838,inst_24823,inst_24842,inst_24843,inst_24808);
var state_24852__$1 = state_24852;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24852__$1,(22),inst_24844);
} else {
if((state_val_24853 === (13))){
var inst_24823 = (state_24852[(7)]);
var state_24852__$1 = state_24852;
if(cljs.core.truth_(inst_24823)){
var statearr_24859_24897 = state_24852__$1;
(statearr_24859_24897[(1)] = (15));

} else {
var statearr_24860_24898 = state_24852__$1;
(statearr_24860_24898[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (22))){
var inst_24846 = (state_24852[(2)]);
var inst_24847 = fluree.db.util.async.throw_err.call(null,inst_24846);
var _ = (function (){var statearr_24861 = state_24852;
(statearr_24861[(4)] = cljs.core.rest.call(null,(state_24852[(4)])));

return statearr_24861;
})();
var state_24852__$1 = state_24852;
var statearr_24862_24899 = state_24852__$1;
(statearr_24862_24899[(2)] = inst_24847);

(statearr_24862_24899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (6))){
var inst_24803 = (state_24852[(10)]);
var state_24852__$1 = state_24852;
var statearr_24863_24900 = state_24852__$1;
(statearr_24863_24900[(2)] = inst_24803);

(statearr_24863_24900[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (17))){
var inst_24831 = (state_24852[(2)]);
var state_24852__$1 = state_24852;
if(cljs.core.truth_(inst_24831)){
var statearr_24864_24901 = state_24852__$1;
(statearr_24864_24901[(1)] = (18));

} else {
var statearr_24865_24902 = state_24852__$1;
(statearr_24865_24902[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (3))){
var inst_24850 = (state_24852[(2)]);
var state_24852__$1 = state_24852;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24852__$1,inst_24850);
} else {
if((state_val_24853 === (12))){
var inst_24824 = (state_24852[(11)]);
var state_24852__$1 = state_24852;
var statearr_24866_24903 = state_24852__$1;
(statearr_24866_24903[(2)] = inst_24824);

(statearr_24866_24903[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (2))){
var inst_24803 = (state_24852[(10)]);
var _ = (function (){var statearr_24867 = state_24852;
(statearr_24867[(4)] = cljs.core.cons.call(null,(5),(state_24852[(4)])));

return statearr_24867;
})();
var inst_24799 = query_map;
var inst_24800 = cljs.core.__destructure_map.call(null,inst_24799);
var inst_24801 = cljs.core.get.call(null,inst_24800,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_24802 = cljs.core.get.call(null,inst_24800,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_24803__$1 = cljs.core.get.call(null,inst_24800,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_24804 = cljs.core.get.call(null,inst_24800,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_24805 = cljs.core.get.call(null,inst_24800,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_24806 = cljs.core.get.call(null,inst_24800,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_24807 = cljs.core.get.call(null,inst_24800,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_24808 = cljs.core.get.call(null,inst_24800,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_24810 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)];
var state_24852__$1 = (function (){var statearr_24868 = state_24852;
(statearr_24868[(12)] = inst_24810);

(statearr_24868[(13)] = inst_24804);

(statearr_24868[(14)] = inst_24805);

(statearr_24868[(15)] = inst_24802);

(statearr_24868[(16)] = inst_24806);

(statearr_24868[(8)] = inst_24808);

(statearr_24868[(10)] = inst_24803__$1);

(statearr_24868[(17)] = inst_24801);

(statearr_24868[(18)] = inst_24807);

return statearr_24868;
})();
if(cljs.core.truth_(inst_24803__$1)){
var statearr_24869_24904 = state_24852__$1;
(statearr_24869_24904[(1)] = (6));

} else {
var statearr_24870_24905 = state_24852__$1;
(statearr_24870_24905[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (19))){
var state_24852__$1 = state_24852;
var statearr_24871_24906 = state_24852__$1;
(statearr_24871_24906[(2)] = null);

(statearr_24871_24906[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (11))){
var inst_24822 = (state_24852[(19)]);
var inst_24808 = (state_24852[(8)]);
var inst_24824 = (state_24852[(11)]);
var inst_24822__$1 = (state_24852[(2)]);
var inst_24823 = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(inst_24822__$1);
var inst_24824__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_24808);
var state_24852__$1 = (function (){var statearr_24873 = state_24852;
(statearr_24873[(19)] = inst_24822__$1);

(statearr_24873[(11)] = inst_24824__$1);

(statearr_24873[(7)] = inst_24823);

return statearr_24873;
})();
if(cljs.core.truth_(inst_24824__$1)){
var statearr_24874_24907 = state_24852__$1;
(statearr_24874_24907[(1)] = (12));

} else {
var statearr_24875_24908 = state_24852__$1;
(statearr_24875_24908[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (9))){
var inst_24817 = (state_24852[(20)]);
var inst_24819 = cljs.core.assoc.call(null,inst_24817,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var state_24852__$1 = state_24852;
var statearr_24876_24909 = state_24852__$1;
(statearr_24876_24909[(2)] = inst_24819);

(statearr_24876_24909[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (5))){
var _ = (function (){var statearr_24877 = state_24852;
(statearr_24877[(4)] = cljs.core.rest.call(null,(state_24852[(4)])));

return statearr_24877;
})();
var state_24852__$1 = state_24852;
var ex24872 = (state_24852__$1[(2)]);
var statearr_24878_24910 = state_24852__$1;
(statearr_24878_24910[(5)] = ex24872);


if((ex24872 instanceof Error)){
var statearr_24879_24911 = state_24852__$1;
(statearr_24879_24911[(1)] = (4));

(statearr_24879_24911[(5)] = null);

} else {
throw ex24872;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (14))){
var inst_24822 = (state_24852[(19)]);
var inst_24823 = (state_24852[(7)]);
var inst_24838 = (state_24852[(9)]);
var inst_24838__$1 = (state_24852[(2)]);
var inst_24839 = fluree.db.query.analytical.q.call(null,query_map,inst_24838__$1,inst_24823,db,inst_24822);
var state_24852__$1 = (function (){var statearr_24880 = state_24852;
(statearr_24880[(9)] = inst_24838__$1);

return statearr_24880;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24852__$1,(21),inst_24839);
} else {
if((state_val_24853 === (16))){
var inst_24808 = (state_24852[(8)]);
var inst_24829 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_24808);
var state_24852__$1 = state_24852;
var statearr_24881_24912 = state_24852__$1;
(statearr_24881_24912[(2)] = inst_24829);

(statearr_24881_24912[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (10))){
var inst_24817 = (state_24852[(20)]);
var state_24852__$1 = state_24852;
var statearr_24882_24913 = state_24852__$1;
(statearr_24882_24913[(2)] = inst_24817);

(statearr_24882_24913[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (18))){
var inst_24833 = cljs.core.volatile_BANG_.call(null,(0));
var state_24852__$1 = state_24852;
var statearr_24883_24914 = state_24852__$1;
(statearr_24883_24914[(2)] = inst_24833);

(statearr_24883_24914[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24853 === (8))){
var inst_24810 = (state_24852[(12)]);
var inst_24804 = (state_24852[(13)]);
var inst_24805 = (state_24852[(14)]);
var inst_24802 = (state_24852[(15)]);
var inst_24806 = (state_24852[(16)]);
var inst_24808 = (state_24852[(8)]);
var inst_24801 = (state_24852[(17)]);
var inst_24807 = (state_24852[(18)]);
var inst_24814 = (state_24852[(2)]);
var inst_24815 = [inst_24802,inst_24814,inst_24804,inst_24805,inst_24806,inst_24807];
var inst_24816 = cljs.core.PersistentHashMap.fromArrays(inst_24810,inst_24815);
var inst_24817 = cljs.core.merge.call(null,inst_24816,inst_24808);
var state_24852__$1 = (function (){var statearr_24884 = state_24852;
(statearr_24884[(20)] = inst_24817);

return statearr_24884;
})();
if(cljs.core.truth_(inst_24801)){
var statearr_24885_24915 = state_24852__$1;
(statearr_24885_24915[(1)] = (9));

} else {
var statearr_24886_24916 = state_24852__$1;
(statearr_24886_24916[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0 = (function (){
var statearr_24887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24887[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__);

(statearr_24887[(1)] = (1));

return statearr_24887;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1 = (function (state_24852){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24852);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24888){var ex__2749__auto__ = e24888;
var statearr_24889_24917 = state_24852;
(statearr_24889_24917[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24852[(4)]))){
var statearr_24890_24918 = state_24852;
(statearr_24890_24918[(1)] = cljs.core.first.call(null,(state_24852[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24919 = state_24852;
state_24852 = G__24919;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__ = function(state_24852){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1.call(this,state_24852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24891 = f__2769__auto__.call(null);
(statearr_24891[(6)] = c__2768__auto__);

return statearr_24891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns already cached query from cache if available, else
 *   executes and stores query into cache.
 */
fluree.db.query.fql.cache_query = (function fluree$db$query$fql$cache_query(p__24920,p__24921){
var map__24922 = p__24920;
var map__24922__$1 = cljs.core.__destructure_map.call(null,map__24922);
var db = map__24922__$1;
var network = cljs.core.get.call(null,map__24922__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__24922__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var block = cljs.core.get.call(null,map__24922__$1,new cljs.core.Keyword(null,"block","block",664686210));
var auth = cljs.core.get.call(null,map__24922__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var conn = cljs.core.get.call(null,map__24922__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__24923 = p__24921;
var map__24923__$1 = cljs.core.__destructure_map.call(null,map__24923);
var query_map = map__24923__$1;
var opts = cljs.core.get.call(null,map__24923__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var oc = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
var query_STAR_ = cljs.core.update.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.dissoc,new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var cache_key = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510),network,ledger_id,block,auth,query_STAR_], null);
return oc.call(null,cache_key,(function (_){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___24940 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24933){
var state_val_24934 = (state_24933[(1)]);
if((state_val_24934 === (1))){
var inst_24924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24925 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"cache","cache",-1237023054)];
var inst_24926 = (new cljs.core.PersistentVector(null,2,(5),inst_24924,inst_24925,null));
var inst_24927 = cljs.core.assoc_in.call(null,query_map,inst_24926,false);
var inst_24928 = fluree.db.query.fql.query.call(null,db,inst_24927);
var state_24933__$1 = state_24933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24933__$1,(2),inst_24928);
} else {
if((state_val_24934 === (2))){
var inst_24930 = (state_24933[(2)]);
var inst_24931 = cljs.core.async.put_BANG_.call(null,pc,inst_24930);
var state_24933__$1 = state_24933;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24933__$1,inst_24931);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0 = (function (){
var statearr_24935 = [null,null,null,null,null,null,null];
(statearr_24935[(0)] = fluree$db$query$fql$cache_query_$_state_machine__2746__auto__);

(statearr_24935[(1)] = (1));

return statearr_24935;
});
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1 = (function (state_24933){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24933);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24936){var ex__2749__auto__ = e24936;
var statearr_24937_24941 = state_24933;
(statearr_24937_24941[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24933[(4)]))){
var statearr_24938_24942 = state_24933;
(statearr_24938_24942[(1)] = cljs.core.first.call(null,(state_24933[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24943 = state_24933;
state_24933 = G__24943;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__ = function(state_24933){
switch(arguments.length){
case 0:
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1.call(this,state_24933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0;
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1;
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24939 = f__2769__auto__.call(null);
(statearr_24939[(6)] = c__2768__auto___24940);

return statearr_24939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));
});
/**
 * Returns true if query was requested to run from the cache.
 */
fluree.db.query.fql.cache_QMARK_ = (function fluree$db$query$fql$cache_QMARK_(p__24944){
var map__24945 = p__24944;
var map__24945__$1 = cljs.core.__destructure_map.call(null,map__24945);
var _query_map = map__24945__$1;
var opts = cljs.core.get.call(null,map__24945__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return false;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.call(null,"Running query:",cljs.core.pr_str.call(null,query_map));

if(fluree.db.query.fql.cache_QMARK_.call(null,query_map)){
return fluree.db.query.fql.cache_query.call(null,db,query_map);
} else {
var parsed_query = fluree.db.query.analytical_parse.parse.call(null,db,query_map);
var db_STAR_ = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"ctx-cache","ctx-cache",-391738418),cljs.core.volatile_BANG_.call(null,cljs.core.PersistentArrayMap.EMPTY));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044),new cljs.core.Keyword(null,"strategy","strategy",-1471631918).cljs$core$IFn$_invoke$arity$1(parsed_query))){
return fluree.db.query.subject_crawl.core.simple_subject_crawl.call(null,db_STAR_,parsed_query);
} else {
return fluree.db.query.fql.ad_hoc_query.call(null,db_STAR_,parsed_query,query_map);
}
}
});
