// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.index');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4253__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * If a predicate is provided as a string value, coerce to pid
 */
fluree.db.query.range.coerce_predicate = (function fluree$db$query$range$coerce_predicate(db,pred){
if(typeof pred === 'string'){
var or__4253__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),pred);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",pred].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return pred;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14216 = match;
var p1 = cljs.core.nth.call(null,vec__14216,(0),null);
var p2 = cljs.core.nth.call(null,vec__14216,(1),null);
var p3 = cljs.core.nth.call(null,vec__14216,(2),null);
var p4 = cljs.core.nth.call(null,vec__14216,(3),null);
var op = cljs.core.nth.call(null,vec__14216,(4),null);
var m = cljs.core.nth.call(null,vec__14216,(5),null);
var G__14219 = idx;
var G__14219__$1 = (((G__14219 instanceof cljs.core.Keyword))?G__14219.fqn:null);
switch (G__14219__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.query.range.coerce_predicate.call(null,db,p2),p3,p4,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate.call(null,db,p1),p3,p4,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate.call(null,db,p1),p2,p4,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate.call(null,db,p2),p1,p4,op,m], null);

break;
case "tspo":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate.call(null,db,p3),p4,p1,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14219__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(9007199254740991)], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
fluree.db.query.range.txn_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.txn_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14221 = idx;
var G__14221__$1 = (((G__14221 instanceof cljs.core.Keyword))?G__14221.fqn:null);
switch (G__14221__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
case "tspo":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14221__$1)].join('')));

}
});
/**
 * Biggest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14223 = idx;
var G__14223__$1 = (((G__14223 instanceof cljs.core.Keyword))?G__14223.fqn:null);
switch (G__14223__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
case "tspo":
return fluree.db.query.range.txn_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14223__$1)].join('')));

}
});
fluree.db.query.range.resolve_subid = (function fluree$db$query$range$resolve_subid(db,id){
var out = cljs.core.async.chan.call(null);
if(cljs.core.not.call(null,id)){
cljs.core.async.close_BANG_.call(null,out);
} else {
if(fluree.db.util.core.pred_ident_QMARK_.call(null,id)){
cljs.core.async.pipe.call(null,fluree.db.dbproto._subid.call(null,db,id),out);
} else {
cljs.core.async.put_BANG_.call(null,out,id);
}
}

return out;
});
fluree.db.query.range.resolve_match_flake = (function fluree$db$query$range$resolve_match_flake(db,test,parts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14263){
var state_val_14264 = (state_14263[(1)]);
if((state_val_14264 === (7))){
var inst_14240 = (state_14263[(7)]);
var inst_14247 = (state_14263[(2)]);
var inst_14248 = fluree.db.util.async.throw_err.call(null,inst_14247);
var state_14263__$1 = (function (){var statearr_14265 = state_14263;
(statearr_14265[(8)] = inst_14248);

return statearr_14265;
})();
if(cljs.core.truth_(inst_14240)){
var statearr_14266_14290 = state_14263__$1;
(statearr_14266_14290[(1)] = (8));

} else {
var statearr_14267_14291 = state_14263__$1;
(statearr_14267_14291[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14264 === (1))){
var state_14263__$1 = state_14263;
var statearr_14268_14292 = state_14263__$1;
(statearr_14268_14292[(2)] = null);

(statearr_14268_14292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14264 === (4))){
var inst_14225 = (state_14263[(2)]);
var state_14263__$1 = state_14263;
var statearr_14269_14293 = state_14263__$1;
(statearr_14269_14293[(2)] = inst_14225);

(statearr_14269_14293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14264 === (13))){
var inst_14255 = (state_14263[(2)]);
var state_14263__$1 = state_14263;
var statearr_14270_14294 = state_14263__$1;
(statearr_14270_14294[(2)] = inst_14255);

(statearr_14270_14294[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14264 === (6))){
var inst_14237 = (state_14263[(9)]);
var inst_14243 = (state_14263[(2)]);
var inst_14244 = fluree.db.util.async.throw_err.call(null,inst_14243);
var inst_14245 = fluree.db.query.range.resolve_subid.call(null,db,inst_14237);
var state_14263__$1 = (function (){var statearr_14271 = state_14263;
(statearr_14271[(10)] = inst_14244);

return statearr_14271;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14263__$1,(7),inst_14245);
} else {
if((state_val_14264 === (3))){
var inst_14261 = (state_14263[(2)]);
var state_14263__$1 = state_14263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14263__$1,inst_14261);
} else {
if((state_val_14264 === (12))){
var state_14263__$1 = state_14263;
var statearr_14272_14295 = state_14263__$1;
(statearr_14272_14295[(2)] = (2147483647));

(statearr_14272_14295[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14264 === (2))){
var _ = (function (){var statearr_14273 = state_14263;
(statearr_14273[(4)] = cljs.core.cons.call(null,(5),(state_14263[(4)])));

return statearr_14273;
})();
var inst_14234 = parts;
var inst_14235 = cljs.core.nth.call(null,inst_14234,(0),null);
var inst_14236 = cljs.core.nth.call(null,inst_14234,(1),null);
var inst_14237 = cljs.core.nth.call(null,inst_14234,(2),null);
var inst_14238 = cljs.core.nth.call(null,inst_14234,(3),null);
var inst_14239 = cljs.core.nth.call(null,inst_14234,(4),null);
var inst_14240 = cljs.core.nth.call(null,inst_14234,(5),null);
var inst_14241 = fluree.db.query.range.resolve_subid.call(null,db,inst_14235);
var state_14263__$1 = (function (){var statearr_14274 = state_14263;
(statearr_14274[(9)] = inst_14237);

(statearr_14274[(11)] = inst_14238);

(statearr_14274[(7)] = inst_14240);

(statearr_14274[(12)] = inst_14239);

(statearr_14274[(13)] = inst_14236);

return statearr_14274;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14263__$1,(6),inst_14241);
} else {
if((state_val_14264 === (11))){
var state_14263__$1 = state_14263;
var statearr_14276_14296 = state_14263__$1;
(statearr_14276_14296[(2)] = (-2147483647));

(statearr_14276_14296[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14264 === (9))){
var inst_14251 = (cljs.core._GT__EQ_ === test);
var state_14263__$1 = state_14263;
if(cljs.core.truth_(inst_14251)){
var statearr_14277_14297 = state_14263__$1;
(statearr_14277_14297[(1)] = (11));

} else {
var statearr_14278_14298 = state_14263__$1;
(statearr_14278_14298[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14264 === (5))){
var _ = (function (){var statearr_14279 = state_14263;
(statearr_14279[(4)] = cljs.core.rest.call(null,(state_14263[(4)])));

return statearr_14279;
})();
var state_14263__$1 = state_14263;
var ex14275 = (state_14263__$1[(2)]);
var statearr_14280_14299 = state_14263__$1;
(statearr_14280_14299[(5)] = ex14275);


if((ex14275 instanceof Error)){
var statearr_14281_14300 = state_14263__$1;
(statearr_14281_14300[(1)] = (4));

(statearr_14281_14300[(5)] = null);

} else {
throw ex14275;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14264 === (10))){
var inst_14238 = (state_14263[(11)]);
var inst_14244 = (state_14263[(10)]);
var inst_14248 = (state_14263[(8)]);
var inst_14239 = (state_14263[(12)]);
var inst_14236 = (state_14263[(13)]);
var inst_14257 = (state_14263[(2)]);
var inst_14258 = fluree.db.flake.__GT_Flake.call(null,inst_14244,inst_14236,inst_14248,inst_14238,inst_14239,inst_14257);
var _ = (function (){var statearr_14282 = state_14263;
(statearr_14282[(4)] = cljs.core.rest.call(null,(state_14263[(4)])));

return statearr_14282;
})();
var state_14263__$1 = state_14263;
var statearr_14283_14301 = state_14263__$1;
(statearr_14283_14301[(2)] = inst_14258);

(statearr_14283_14301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14264 === (8))){
var inst_14240 = (state_14263[(7)]);
var state_14263__$1 = state_14263;
var statearr_14284_14302 = state_14263__$1;
(statearr_14284_14302[(2)] = inst_14240);

(statearr_14284_14302[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____0 = (function (){
var statearr_14285 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14285[(0)] = fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__);

(statearr_14285[(1)] = (1));

return statearr_14285;
});
var fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____1 = (function (state_14263){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14286){var ex__2749__auto__ = e14286;
var statearr_14287_14303 = state_14263;
(statearr_14287_14303[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14263[(4)]))){
var statearr_14288_14304 = state_14263;
(statearr_14288_14304[(1)] = cljs.core.first.call(null,(state_14263[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14305 = state_14263;
state_14263 = G__14305;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__ = function(state_14263){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____1.call(this,state_14263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____0;
fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto____1;
return fluree$db$query$range$resolve_match_flake_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14289 = f__2769__auto__.call(null);
(statearr_14289[(6)] = c__2768__auto__);

return statearr_14289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.range.resolved_leaf_QMARK_ = (function fluree$db$query$range$resolved_leaf_QMARK_(node){
var and__4251__auto__ = fluree.db.index.leaf_QMARK_.call(null,node);
if(and__4251__auto__){
return fluree.db.index.resolved_QMARK_.call(null,node);
} else {
return and__4251__auto__;
}
});
/**
 * Returns true if the supplied `node` contains flakes between the `lower` and
 *   `upper` flakes, according to the `node`'s comparator.
 */
fluree.db.query.range.intersects_range_QMARK_ = (function fluree$db$query$range$intersects_range_QMARK_(node,range_set){
return cljs.core.not.call(null,(function (){var or__4253__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(and__4251__auto__)){
return fluree.db.flake.lower_than_all_QMARK_.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node),range_set);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(node))) && (fluree.db.flake.higher_than_all_QMARK_.call(null,new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(node),range_set)));
}
})());
});
/**
 * Returns a transducer to filter flakes according to the boolean function values
 *   of the `:subject-fn`, `:predicate-fn`, and `:object-fn` keys from the supplied
 *   options map. All three functions are optional, and each supplied function will
 *   be applied to its corresponding flake component, and only flakes where each
 *   function evaluates to a truthy value will be included.
 */
fluree.db.query.range.query_filter = (function fluree$db$query$range$query_filter(p__14306){
var map__14307 = p__14306;
var map__14307__$1 = cljs.core.__destructure_map.call(null,map__14307);
var subject_fn = cljs.core.get.call(null,map__14307__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var predicate_fn = cljs.core.get.call(null,map__14307__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var object_fn = cljs.core.get.call(null,map__14307__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var filter_xfs = (function (){var G__14308 = cljs.core.PersistentVector.EMPTY;
var G__14308__$1 = (cljs.core.truth_(subject_fn)?cljs.core.conj.call(null,G__14308,cljs.core.filter.call(null,(function (f){
return subject_fn.call(null,fluree.db.flake.s.call(null,f));
}))):G__14308);
var G__14308__$2 = (cljs.core.truth_(predicate_fn)?cljs.core.conj.call(null,G__14308__$1,cljs.core.filter.call(null,(function (f){
return predicate_fn.call(null,fluree.db.flake.p.call(null,f));
}))):G__14308__$1);
if(cljs.core.truth_(object_fn)){
return cljs.core.conj.call(null,G__14308__$2,cljs.core.filter.call(null,(function (f){
return object_fn.call(null,fluree.db.flake.o.call(null,f));
})));
} else {
return G__14308__$2;
}
})();
return cljs.core.apply.call(null,cljs.core.comp,filter_xfs);
});
/**
 * Returns a transducer to extract flakes from each leaf from a stream of index
 *   leaf nodes that satisfy the bounds specified in the supplied query options
 *   map. The result of the transformation will be a stream of collections of
 *   flakes from the leaf nodes in the input stream, with one flake collection for
 *   each input leaf.
 */
fluree.db.query.range.extract_query_flakes = (function fluree$db$query$range$extract_query_flakes(p__14309){
var map__14310 = p__14309;
var map__14310__$1 = cljs.core.__destructure_map.call(null,map__14310);
var opts = map__14310__$1;
var start_flake = cljs.core.get.call(null,map__14310__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var start_test = cljs.core.get.call(null,map__14310__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var end_flake = cljs.core.get.call(null,map__14310__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var end_test = cljs.core.get.call(null,map__14310__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
return cljs.core.comp.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.call(null,(function (flakes){
return fluree.db.flake.subrange.call(null,flakes,start_test,start_flake,end_test,end_flake);
})),cljs.core.map.call(null,(function (flakes){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,fluree.db.query.range.query_filter.call(null,opts),flakes);
})));
});
/**
 * Returns a channel that will contain a stream of chunked flake collections that
 *   contain the flakes between `start-flake` and `end-flake` and are within the
 *   transaction range starting at `from-t` and ending at `to-t`.
 */
fluree.db.query.range.resolve_flake_slices = (function fluree$db$query$range$resolve_flake_slices(p__14311,root,novelty,error_ch,p__14312){
var map__14313 = p__14311;
var map__14313__$1 = cljs.core.__destructure_map.call(null,map__14313);
var conn = map__14313__$1;
var async_cache = cljs.core.get.call(null,map__14313__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var map__14314 = p__14312;
var map__14314__$1 = cljs.core.__destructure_map.call(null,map__14314);
var opts = map__14314__$1;
var from_t = cljs.core.get.call(null,map__14314__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525));
var to_t = cljs.core.get.call(null,map__14314__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359));
var start_flake = cljs.core.get.call(null,map__14314__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.call(null,map__14314__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var resolver = fluree.db.index.__GT_CachedTRangeResolver.call(null,conn,novelty,from_t,to_t,async_cache);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(root);
var range_set = fluree.db.flake.sorted_set_by.call(null,cmp,start_flake,end_flake);
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_.call(null,node,range_set);
});
var query_xf = fluree.db.query.range.extract_query_flakes.call(null,opts);
return fluree.db.index.tree_chan.call(null,resolver,root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
});
fluree.db.query.range.unauthorized_QMARK_ = (function fluree$db$query$range$unauthorized_QMARK_(f){
return cljs.core._EQ_.call(null,f,new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));
});
fluree.db.query.range.authorize_flake = (function fluree$db$query$range$authorize_flake(db,error_ch,flake){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14345){
var state_val_14346 = (state_14345[(1)]);
if((state_val_14346 === (7))){
var inst_14328 = (state_14345[(7)]);
var state_14345__$1 = state_14345;
var statearr_14347_14371 = state_14345__$1;
(statearr_14347_14371[(2)] = inst_14328);

(statearr_14347_14371[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14346 === (1))){
var state_14345__$1 = state_14345;
var statearr_14348_14372 = state_14345__$1;
(statearr_14348_14372[(2)] = null);

(statearr_14348_14372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14346 === (4))){
var inst_14315 = (state_14345[(2)]);
var inst_14316 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14317 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_14318 = (new cljs.core.PersistentVector(null,3,(5),inst_14316,inst_14317,null));
var inst_14319 = cljs.core.select_keys.call(null,db,inst_14318);
var inst_14320 = fluree.db.util.log.error.call(null,inst_14315,"Error authorizing flake in ledger",inst_14319);
var state_14345__$1 = (function (){var statearr_14350 = state_14345;
(statearr_14350[(8)] = inst_14320);

return statearr_14350;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14345__$1,(5),error_ch,inst_14315);
} else {
if((state_val_14346 === (13))){
var inst_14340 = (state_14345[(2)]);
var _ = (function (){var statearr_14351 = state_14345;
(statearr_14351[(4)] = cljs.core.rest.call(null,(state_14345[(4)])));

return statearr_14351;
})();
var state_14345__$1 = state_14345;
var statearr_14352_14373 = state_14345__$1;
(statearr_14352_14373[(2)] = inst_14340);

(statearr_14352_14373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14346 === (6))){
var _ = (function (){var statearr_14353 = state_14345;
(statearr_14353[(4)] = cljs.core.rest.call(null,(state_14345[(4)])));

return statearr_14353;
})();
var state_14345__$1 = state_14345;
var ex14349 = (state_14345__$1[(2)]);
var statearr_14354_14374 = state_14345__$1;
(statearr_14354_14374[(5)] = ex14349);


var statearr_14355_14375 = state_14345__$1;
(statearr_14355_14375[(1)] = (4));

(statearr_14355_14375[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14346 === (3))){
var inst_14343 = (state_14345[(2)]);
var state_14345__$1 = state_14345;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14345__$1,inst_14343);
} else {
if((state_val_14346 === (12))){
var state_14345__$1 = state_14345;
var statearr_14356_14376 = state_14345__$1;
(statearr_14356_14376[(2)] = new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));

(statearr_14356_14376[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14346 === (2))){
var inst_14328 = (state_14345[(7)]);
var _ = (function (){var statearr_14357 = state_14345;
(statearr_14357[(4)] = cljs.core.cons.call(null,(6),(state_14345[(4)])));

return statearr_14357;
})();
var inst_14328__$1 = fluree.db.util.schema.is_schema_flake_QMARK_.call(null,flake);
var state_14345__$1 = (function (){var statearr_14358 = state_14345;
(statearr_14358[(7)] = inst_14328__$1);

return statearr_14358;
})();
if(inst_14328__$1){
var statearr_14359_14377 = state_14345__$1;
(statearr_14359_14377[(1)] = (7));

} else {
var statearr_14360_14378 = state_14345__$1;
(statearr_14360_14378[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14346 === (11))){
var state_14345__$1 = state_14345;
var statearr_14361_14379 = state_14345__$1;
(statearr_14361_14379[(2)] = flake);

(statearr_14361_14379[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14346 === (9))){
var inst_14336 = (state_14345[(2)]);
var state_14345__$1 = state_14345;
if(cljs.core.truth_(inst_14336)){
var statearr_14362_14380 = state_14345__$1;
(statearr_14362_14380[(1)] = (11));

} else {
var statearr_14363_14381 = state_14345__$1;
(statearr_14363_14381[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14346 === (5))){
var inst_14322 = (state_14345[(2)]);
var state_14345__$1 = state_14345;
var statearr_14364_14382 = state_14345__$1;
(statearr_14364_14382[(2)] = inst_14322);

(statearr_14364_14382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14346 === (10))){
var inst_14333 = (state_14345[(2)]);
var inst_14334 = fluree.db.util.async.throw_err.call(null,inst_14333);
var state_14345__$1 = state_14345;
var statearr_14365_14383 = state_14345__$1;
(statearr_14365_14383[(2)] = inst_14334);

(statearr_14365_14383[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14346 === (8))){
var inst_14331 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,flake);
var state_14345__$1 = state_14345;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14345__$1,(10),inst_14331);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____0 = (function (){
var statearr_14366 = [null,null,null,null,null,null,null,null,null];
(statearr_14366[(0)] = fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__);

(statearr_14366[(1)] = (1));

return statearr_14366;
});
var fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____1 = (function (state_14345){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14345);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14367){var ex__2749__auto__ = e14367;
var statearr_14368_14384 = state_14345;
(statearr_14368_14384[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14345[(4)]))){
var statearr_14369_14385 = state_14345;
(statearr_14369_14385[(1)] = cljs.core.first.call(null,(state_14345[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14386 = state_14345;
state_14345 = G__14386;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__ = function(state_14345){
switch(arguments.length){
case 0:
return fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____1.call(this,state_14345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____0;
fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$authorize_flake_$_state_machine__2746__auto____1;
return fluree$db$query$range$authorize_flake_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14370 = f__2769__auto__.call(null);
(statearr_14370[(6)] = c__2768__auto__);

return statearr_14370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Authorize each flake in the supplied `flakes` collection asynchronously,
 *   returning a collection containing only allowed flakes according to the
 *   permissions of the supplied `db`.
 */
fluree.db.query.range.authorize_flakes = (function fluree$db$query$range$authorize_flakes(db,error_ch,flakes){
return cljs.core.async.map.call(null,(function() { 
var G__14387__delegate = function (fs){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,fluree.db.query.range.unauthorized_QMARK_),fs);
};
var G__14387 = function (var_args){
var fs = null;
if (arguments.length > 0) {
var G__14388__i = 0, G__14388__a = new Array(arguments.length -  0);
while (G__14388__i < G__14388__a.length) {G__14388__a[G__14388__i] = arguments[G__14388__i + 0]; ++G__14388__i;}
  fs = new cljs.core.IndexedSeq(G__14388__a,0,null);
} 
return G__14387__delegate.call(this,fs);};
G__14387.cljs$lang$maxFixedArity = 0;
G__14387.cljs$lang$applyTo = (function (arglist__14389){
var fs = cljs.core.seq(arglist__14389);
return G__14387__delegate(fs);
});
G__14387.cljs$core$IFn$_invoke$arity$variadic = G__14387__delegate;
return G__14387;
})()
,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.range.authorize_flake,db,error_ch),flakes));
});
/**
 * Returns a channel that will eventually return a stream of flake slices
 *   containing only the schema flakes and the flakes validated by
 *   fluree.db.permissions-validate/allow-flake? function for the database `db`
 *   from the `flake-slices` channel
 */
fluree.db.query.range.filter_authorized = (function fluree$db$query$range$filter_authorized(p__14390,start,end,error_ch,flake_slices){
var map__14391 = p__14390;
var map__14391__$1 = cljs.core.__destructure_map.call(null,map__14391);
var db = map__14391__$1;
var permissions = cljs.core.get.call(null,map__14391__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
return flake_slices;
});
/**
 * Returns a transducer to filter a stream of flakes to only contain flakes from
 *   at most `limit` subjects, skipping the flakes from the first `offset`
 *   subjects.
 */
fluree.db.query.range.filter_subject_page = (function fluree$db$query$range$filter_subject_page(limit,offset){
var subject_page_xfs = (function (){var G__14392 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.partition_by.call(null,fluree.db.flake.s)], null);
var G__14392__$1 = (cljs.core.truth_(offset)?cljs.core.conj.call(null,G__14392,cljs.core.drop.call(null,offset)):G__14392);
var G__14392__$2 = (cljs.core.truth_(limit)?cljs.core.conj.call(null,G__14392__$1,cljs.core.take.call(null,limit)):G__14392__$1);
return cljs.core.conj.call(null,G__14392__$2,cljs.core.cat);

})();
return cljs.core.apply.call(null,cljs.core.comp,subject_page_xfs);
});
/**
 * Collects flakes from the stream of flake collections in the `flake-slices`
 *   channel into a sorted vector according to the `limit`, `offset`, and
 *   `flake-limit` parameters. The result will have flakes from at most `limit`
 *   subjects, not including flakes from the first `offset` subjects, and having at
 *   most `flake-limit` flakes in total.
 */
fluree.db.query.range.into_page = (function fluree$db$query$range$into_page(limit,offset,flake_limit,flake_slices){
var page_xfs = (function (){var G__14393 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cat], null);
var G__14393__$1 = (cljs.core.truth_((function (){var or__4253__auto__ = limit;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return offset;
}
})())?cljs.core.conj.call(null,G__14393,fluree.db.query.range.filter_subject_page.call(null,limit,offset)):G__14393);
if(cljs.core.truth_(flake_limit)){
return cljs.core.conj.call(null,G__14393__$1,cljs.core.take.call(null,flake_limit));
} else {
return G__14393__$1;
}
})();
var page_xf = cljs.core.apply.call(null,cljs.core.comp,page_xfs);
return cljs.core.async.transduce.call(null,page_xf,cljs.core.conj,cljs.core.PersistentVector.EMPTY,flake_slices);
});
/**
 * Return a channel that will eventually hold a sorted vector of the range of
 *   flakes from `db` that meet the criteria specified in the `opts` map.
 */
fluree.db.query.range.index_range_STAR_ = (function fluree$db$query$range$index_range_STAR_(p__14394,error_ch,p__14395){
var map__14396 = p__14394;
var map__14396__$1 = cljs.core.__destructure_map.call(null,map__14396);
var db = map__14396__$1;
var conn = cljs.core.get.call(null,map__14396__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__14397 = p__14395;
var map__14397__$1 = cljs.core.__destructure_map.call(null,map__14397);
var opts = map__14397__$1;
var idx = cljs.core.get.call(null,map__14397__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var start_flake = cljs.core.get.call(null,map__14397__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.call(null,map__14397__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var limit = cljs.core.get.call(null,map__14397__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__14397__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var flake_limit = cljs.core.get.call(null,map__14397__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961));
var idx_root = cljs.core.get.call(null,db,idx);
var idx_cmp = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var novelty = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx], null));
return fluree.db.query.range.into_page.call(null,limit,offset,flake_limit,fluree.db.query.range.filter_authorized.call(null,db,start_flake,end_flake,error_ch,fluree.db.query.range.resolve_flake_slices.call(null,conn,idx_root,novelty,error_ch,opts)));
});
/**
 * Finds the full index or time range interval including the maximum and minimum
 *   tests when only one test is provided
 */
fluree.db.query.range.expand_range_interval = (function fluree$db$query$range$expand_range_interval(idx,test,match){
var pred__14398 = cljs.core.identical_QMARK_;
var expr__14399 = test;
if(cljs.core.truth_(pred__14398.call(null,cljs.core._EQ_,expr__14399))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14398.call(null,cljs.core._LT_,expr__14399))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__14398.call(null,cljs.core._LT__EQ_,expr__14399))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14398.call(null,cljs.core._GT_,expr__14399))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__14398.call(null,cljs.core._GT__EQ_,expr__14399))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14399)].join('')));
}
}
}
}
}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we
 *   don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will return in
 *   reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number
 *          is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used
 *         when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__14402 = arguments.length;
switch (G__14402) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14403 = fluree.db.query.range.expand_range_interval.call(null,idx,test,match);
var start_test = cljs.core.nth.call(null,vec__14403,(0),null);
var start_match = cljs.core.nth.call(null,vec__14403,(1),null);
var end_test = cljs.core.nth.call(null,vec__14403,(2),null);
var end_match = cljs.core.nth.call(null,vec__14403,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (p__14406,idx,start_test,start_match,end_test,end_match,opts){
var map__14407 = p__14406;
var map__14407__$1 = cljs.core.__destructure_map.call(null,map__14407);
var db = map__14407__$1;
var t = cljs.core.get.call(null,map__14407__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__14408 = opts;
var map__14408__$1 = cljs.core.__destructure_map.call(null,map__14408);
var limit = cljs.core.get.call(null,map__14408__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var from_t = cljs.core.get.call(null,map__14408__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t);
var to_t = cljs.core.get.call(null,map__14408__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359),t);
var idx_compare = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var start_parts = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var end_parts = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14470){
var state_val_14471 = (state_14470[(1)]);
if((state_val_14471 === (7))){
var inst_14423 = (state_14470[(7)]);
var inst_14427 = (state_14470[(8)]);
var inst_14418 = (state_14470[(9)]);
var inst_14421 = (state_14470[(2)]);
var inst_14422 = fluree.db.util.async.throw_err.call(null,inst_14421);
var inst_14423__$1 = cljs.core.async.chan.call(null);
var inst_14424 = [new cljs.core.Keyword(null,"idx","idx",1053688473),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"start-test","start-test",-952983565),new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),new cljs.core.Keyword(null,"end-test","end-test",481973727),new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961)];
var inst_14425 = [idx,from_t,to_t,start_test,inst_14418,end_test,inst_14422,limit];
var inst_14426 = cljs.core.PersistentHashMap.fromArrays(inst_14424,inst_14425);
var inst_14427__$1 = fluree.db.query.range.index_range_STAR_.call(null,db,inst_14423__$1,inst_14426);
var inst_14435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14436 = [inst_14423__$1,inst_14427__$1];
var inst_14437 = (new cljs.core.PersistentVector(null,2,(5),inst_14435,inst_14436,null));
var state_14470__$1 = (function (){var statearr_14472 = state_14470;
(statearr_14472[(7)] = inst_14423__$1);

(statearr_14472[(8)] = inst_14427__$1);

return statearr_14472;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_14470__$1,(8),inst_14437);
} else {
if((state_val_14471 === (1))){
var state_14470__$1 = state_14470;
var statearr_14473_14502 = state_14470__$1;
(statearr_14473_14502[(2)] = null);

(statearr_14473_14502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (4))){
var inst_14409 = (state_14470[(2)]);
var state_14470__$1 = state_14470;
var statearr_14474_14503 = state_14470__$1;
(statearr_14474_14503[(2)] = inst_14409);

(statearr_14474_14503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (15))){
var inst_14440 = (state_14470[(10)]);
var state_14470__$1 = state_14470;
var statearr_14475_14504 = state_14470__$1;
(statearr_14475_14504[(2)] = inst_14440);

(statearr_14475_14504[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (13))){
var inst_14441 = (state_14470[(11)]);
var inst_14457 = cljs.core._EQ_.call(null,inst_14441,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_14470__$1 = state_14470;
if(inst_14457){
var statearr_14476_14505 = state_14470__$1;
(statearr_14476_14505[(1)] = (15));

} else {
var statearr_14477_14506 = state_14470__$1;
(statearr_14477_14506[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (6))){
var inst_14417 = (state_14470[(2)]);
var inst_14418 = fluree.db.util.async.throw_err.call(null,inst_14417);
var inst_14419 = fluree.db.query.range.resolve_match_flake.call(null,db,end_test,end_parts);
var state_14470__$1 = (function (){var statearr_14478 = state_14470;
(statearr_14478[(9)] = inst_14418);

return statearr_14478;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14470__$1,(7),inst_14419);
} else {
if((state_val_14471 === (17))){
var inst_14461 = (state_14470[(2)]);
var state_14470__$1 = state_14470;
var statearr_14479_14507 = state_14470__$1;
(statearr_14479_14507[(2)] = inst_14461);

(statearr_14479_14507[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (3))){
var inst_14468 = (state_14470[(2)]);
var state_14470__$1 = state_14470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14470__$1,inst_14468);
} else {
if((state_val_14471 === (12))){
var inst_14439 = (state_14470[(12)]);
var inst_14455 = cljs.core.nth.call(null,inst_14439,(0),null);
var state_14470__$1 = state_14470;
var statearr_14480_14508 = state_14470__$1;
(statearr_14480_14508[(2)] = inst_14455);

(statearr_14480_14508[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (2))){
var _ = (function (){var statearr_14481 = state_14470;
(statearr_14481[(4)] = cljs.core.cons.call(null,(5),(state_14470[(4)])));

return statearr_14481;
})();
var inst_14415 = fluree.db.query.range.resolve_match_flake.call(null,db,start_test,start_parts);
var state_14470__$1 = state_14470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14470__$1,(6),inst_14415);
} else {
if((state_val_14471 === (11))){
var inst_14465 = (state_14470[(2)]);
var _ = (function (){var statearr_14483 = state_14470;
(statearr_14483[(4)] = cljs.core.rest.call(null,(state_14470[(4)])));

return statearr_14483;
})();
var state_14470__$1 = state_14470;
var statearr_14484_14509 = state_14470__$1;
(statearr_14484_14509[(2)] = inst_14465);

(statearr_14484_14509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (9))){
var inst_14439 = (state_14470[(12)]);
var inst_14447 = cljs.core.nth.call(null,inst_14439,(0),null);
var inst_14448 = (function(){throw inst_14447})();
var state_14470__$1 = state_14470;
var statearr_14485_14510 = state_14470__$1;
(statearr_14485_14510[(2)] = inst_14448);

(statearr_14485_14510[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (5))){
var _ = (function (){var statearr_14486 = state_14470;
(statearr_14486[(4)] = cljs.core.rest.call(null,(state_14470[(4)])));

return statearr_14486;
})();
var state_14470__$1 = state_14470;
var ex14482 = (state_14470__$1[(2)]);
var statearr_14487_14511 = state_14470__$1;
(statearr_14487_14511[(5)] = ex14482);


if((ex14482 instanceof Error)){
var statearr_14488_14512 = state_14470__$1;
(statearr_14488_14512[(1)] = (4));

(statearr_14488_14512[(5)] = null);

} else {
throw ex14482;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (14))){
var inst_14463 = (state_14470[(2)]);
var state_14470__$1 = state_14470;
var statearr_14489_14513 = state_14470__$1;
(statearr_14489_14513[(2)] = inst_14463);

(statearr_14489_14513[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (16))){
var state_14470__$1 = state_14470;
var statearr_14490_14514 = state_14470__$1;
(statearr_14490_14514[(2)] = null);

(statearr_14490_14514[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (10))){
var inst_14427 = (state_14470[(8)]);
var inst_14441 = (state_14470[(11)]);
var inst_14450 = cljs.core._EQ_.call(null,inst_14441,inst_14427);
var state_14470__$1 = state_14470;
if(inst_14450){
var statearr_14491_14515 = state_14470__$1;
(statearr_14491_14515[(1)] = (12));

} else {
var statearr_14492_14516 = state_14470__$1;
(statearr_14492_14516[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14471 === (8))){
var inst_14423 = (state_14470[(7)]);
var inst_14439 = (state_14470[(12)]);
var inst_14441 = (state_14470[(11)]);
var inst_14439__$1 = (state_14470[(2)]);
var inst_14440 = cljs.core.nth.call(null,inst_14439__$1,(0),null);
var inst_14441__$1 = cljs.core.nth.call(null,inst_14439__$1,(1),null);
var inst_14442 = cljs.core._EQ_.call(null,inst_14441__$1,inst_14423);
var state_14470__$1 = (function (){var statearr_14493 = state_14470;
(statearr_14493[(12)] = inst_14439__$1);

(statearr_14493[(11)] = inst_14441__$1);

(statearr_14493[(10)] = inst_14440);

return statearr_14493;
})();
if(inst_14442){
var statearr_14494_14517 = state_14470__$1;
(statearr_14494_14517[(1)] = (9));

} else {
var statearr_14495_14518 = state_14470__$1;
(statearr_14495_14518[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_14496 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14496[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_14496[(1)] = (1));

return statearr_14496;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_14470){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14497){var ex__2749__auto__ = e14497;
var statearr_14498_14519 = state_14470;
(statearr_14498_14519[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14470[(4)]))){
var statearr_14499_14520 = state_14470;
(statearr_14499_14520[(1)] = cljs.core.first.call(null,(state_14470[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14521 = state_14470;
state_14470 = G__14521;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_14470){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_14470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14500 = f__2769__auto__.call(null);
(statearr_14500[(6)] = c__2768__auto__);

return statearr_14500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__14523 = arguments.length;
switch (G__14523) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14524 = fluree.db.query.range.expand_range_interval.call(null,idx,test,match);
var start_test = cljs.core.nth.call(null,vec__14524,(0),null);
var start_match = cljs.core.nth.call(null,vec__14524,(1),null);
var end_test = cljs.core.nth.call(null,vec__14524,(2),null);
var end_match = cljs.core.nth.call(null,vec__14524,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (p__14527,idx,start_test,start_match,end_test,end_match,p__14528){
var map__14529 = p__14527;
var map__14529__$1 = cljs.core.__destructure_map.call(null,map__14529);
var db = map__14529__$1;
var permissions = cljs.core.get.call(null,map__14529__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var t = cljs.core.get.call(null,map__14529__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__14530 = p__14528;
var map__14530__$1 = cljs.core.__destructure_map.call(null,map__14530);
var opts = map__14530__$1;
var object_fn = cljs.core.get.call(null,map__14530__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var idx_compare = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var vec__14531 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var s1 = cljs.core.nth.call(null,vec__14531,(0),null);
var p1 = cljs.core.nth.call(null,vec__14531,(1),null);
var o1 = cljs.core.nth.call(null,vec__14531,(2),null);
var t1 = cljs.core.nth.call(null,vec__14531,(3),null);
var op1 = cljs.core.nth.call(null,vec__14531,(4),null);
var m1 = cljs.core.nth.call(null,vec__14531,(5),null);
var vec__14534 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var s2 = cljs.core.nth.call(null,vec__14534,(0),null);
var p2 = cljs.core.nth.call(null,vec__14534,(1),null);
var o2 = cljs.core.nth.call(null,vec__14534,(2),null);
var t2 = cljs.core.nth.call(null,vec__14534,(3),null);
var op2 = cljs.core.nth.call(null,vec__14534,(4),null);
var m2 = cljs.core.nth.call(null,vec__14534,(5),null);
var vec__14537 = (function (){var temp__5806__auto__ = ((cljs.core.boolean_QMARK_.call(null,o1))?o1:((cljs.core.boolean_QMARK_.call(null,o2))?o2:null
));
if((temp__5806__auto__ == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o1,o2], null),object_fn], null);
} else {
var bool = temp__5806__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),(function (o){
return cljs.core._EQ_.call(null,o,bool);
})], null);
}
})();
var vec__14540 = cljs.core.nth.call(null,vec__14537,(0),null);
var o1__$1 = cljs.core.nth.call(null,vec__14540,(0),null);
var o2__$1 = cljs.core.nth.call(null,vec__14540,(1),null);
var object_fn__$1 = cljs.core.nth.call(null,vec__14537,(1),null);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14608){
var state_val_14609 = (state_14608[(1)]);
if((state_val_14609 === (7))){
var inst_14565 = (state_14608[(7)]);
var inst_14563 = (state_14608[(8)]);
var inst_14555 = (state_14608[(9)]);
var inst_14561 = (state_14608[(2)]);
var inst_14562 = fluree.db.util.async.throw_err.call(null,inst_14561);
var inst_14563__$1 = cljs.core.async.chan.call(null);
var inst_14564 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"idx","idx",1053688473),idx,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t,new cljs.core.Keyword(null,"to-t","to-t",569467359),t,new cljs.core.Keyword(null,"start-test","start-test",-952983565),start_test,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),inst_14555,new cljs.core.Keyword(null,"end-test","end-test",481973727),end_test,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),inst_14562,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),object_fn__$1);
var inst_14565__$1 = fluree.db.query.range.index_range_STAR_.call(null,db,inst_14563__$1,inst_14564);
var inst_14573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14574 = [inst_14563__$1,inst_14565__$1];
var inst_14575 = (new cljs.core.PersistentVector(null,2,(5),inst_14573,inst_14574,null));
var state_14608__$1 = (function (){var statearr_14610 = state_14608;
(statearr_14610[(7)] = inst_14565__$1);

(statearr_14610[(8)] = inst_14563__$1);

return statearr_14610;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_14608__$1,(8),inst_14575);
} else {
if((state_val_14609 === (1))){
var state_14608__$1 = state_14608;
var statearr_14611_14640 = state_14608__$1;
(statearr_14611_14640[(2)] = null);

(statearr_14611_14640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14609 === (4))){
var inst_14543 = (state_14608[(2)]);
var state_14608__$1 = state_14608;
var statearr_14612_14641 = state_14608__$1;
(statearr_14612_14641[(2)] = inst_14543);

(statearr_14612_14641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14609 === (15))){
var inst_14578 = (state_14608[(10)]);
var state_14608__$1 = state_14608;
var statearr_14613_14642 = state_14608__$1;
(statearr_14613_14642[(2)] = inst_14578);

(statearr_14613_14642[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14609 === (13))){
var inst_14579 = (state_14608[(11)]);
var inst_14595 = cljs.core._EQ_.call(null,inst_14579,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_14608__$1 = state_14608;
if(inst_14595){
var statearr_14614_14643 = state_14608__$1;
(statearr_14614_14643[(1)] = (15));

} else {
var statearr_14615_14644 = state_14608__$1;
(statearr_14615_14644[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14609 === (6))){
var inst_14554 = (state_14608[(2)]);
var inst_14555 = fluree.db.util.async.throw_err.call(null,inst_14554);
var inst_14556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14557 = [s2,p2,o2__$1,t2,op2,m2];
var inst_14558 = (new cljs.core.PersistentVector(null,6,(5),inst_14556,inst_14557,null));
var inst_14559 = fluree.db.query.range.resolve_match_flake.call(null,db,end_test,inst_14558);
var state_14608__$1 = (function (){var statearr_14616 = state_14608;
(statearr_14616[(9)] = inst_14555);

return statearr_14616;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14608__$1,(7),inst_14559);
} else {
if((state_val_14609 === (17))){
var inst_14599 = (state_14608[(2)]);
var state_14608__$1 = state_14608;
var statearr_14617_14645 = state_14608__$1;
(statearr_14617_14645[(2)] = inst_14599);

(statearr_14617_14645[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14609 === (3))){
var inst_14606 = (state_14608[(2)]);
var state_14608__$1 = state_14608;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14608__$1,inst_14606);
} else {
if((state_val_14609 === (12))){
var inst_14577 = (state_14608[(12)]);
var inst_14593 = cljs.core.nth.call(null,inst_14577,(0),null);
var state_14608__$1 = state_14608;
var statearr_14618_14646 = state_14608__$1;
(statearr_14618_14646[(2)] = inst_14593);

(statearr_14618_14646[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14609 === (2))){
var _ = (function (){var statearr_14619 = state_14608;
(statearr_14619[(4)] = cljs.core.cons.call(null,(5),(state_14608[(4)])));

return statearr_14619;
})();
var inst_14549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14550 = [s1,p1,o1__$1,t1,op1,m1];
var inst_14551 = (new cljs.core.PersistentVector(null,6,(5),inst_14549,inst_14550,null));
var inst_14552 = fluree.db.query.range.resolve_match_flake.call(null,db,start_test,inst_14551);
var state_14608__$1 = state_14608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14608__$1,(6),inst_14552);
} else {
if((state_val_14609 === (11))){
var inst_14603 = (state_14608[(2)]);
var _ = (function (){var statearr_14621 = state_14608;
(statearr_14621[(4)] = cljs.core.rest.call(null,(state_14608[(4)])));

return statearr_14621;
})();
var state_14608__$1 = state_14608;
var statearr_14622_14647 = state_14608__$1;
(statearr_14622_14647[(2)] = inst_14603);

(statearr_14622_14647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14609 === (9))){
var inst_14577 = (state_14608[(12)]);
var inst_14585 = cljs.core.nth.call(null,inst_14577,(0),null);
var inst_14586 = (function(){throw inst_14585})();
var state_14608__$1 = state_14608;
var statearr_14623_14648 = state_14608__$1;
(statearr_14623_14648[(2)] = inst_14586);

(statearr_14623_14648[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14609 === (5))){
var _ = (function (){var statearr_14624 = state_14608;
(statearr_14624[(4)] = cljs.core.rest.call(null,(state_14608[(4)])));

return statearr_14624;
})();
var state_14608__$1 = state_14608;
var ex14620 = (state_14608__$1[(2)]);
var statearr_14625_14649 = state_14608__$1;
(statearr_14625_14649[(5)] = ex14620);


if((ex14620 instanceof Error)){
var statearr_14626_14650 = state_14608__$1;
(statearr_14626_14650[(1)] = (4));

(statearr_14626_14650[(5)] = null);

} else {
throw ex14620;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14609 === (14))){
var inst_14601 = (state_14608[(2)]);
var state_14608__$1 = state_14608;
var statearr_14627_14651 = state_14608__$1;
(statearr_14627_14651[(2)] = inst_14601);

(statearr_14627_14651[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14609 === (16))){
var state_14608__$1 = state_14608;
var statearr_14628_14652 = state_14608__$1;
(statearr_14628_14652[(2)] = null);

(statearr_14628_14652[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14609 === (10))){
var inst_14565 = (state_14608[(7)]);
var inst_14579 = (state_14608[(11)]);
var inst_14588 = cljs.core._EQ_.call(null,inst_14579,inst_14565);
var state_14608__$1 = state_14608;
if(inst_14588){
var statearr_14629_14653 = state_14608__$1;
(statearr_14629_14653[(1)] = (12));

} else {
var statearr_14630_14654 = state_14608__$1;
(statearr_14630_14654[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14609 === (8))){
var inst_14563 = (state_14608[(8)]);
var inst_14579 = (state_14608[(11)]);
var inst_14577 = (state_14608[(12)]);
var inst_14577__$1 = (state_14608[(2)]);
var inst_14578 = cljs.core.nth.call(null,inst_14577__$1,(0),null);
var inst_14579__$1 = cljs.core.nth.call(null,inst_14577__$1,(1),null);
var inst_14580 = cljs.core._EQ_.call(null,inst_14579__$1,inst_14563);
var state_14608__$1 = (function (){var statearr_14631 = state_14608;
(statearr_14631[(11)] = inst_14579__$1);

(statearr_14631[(12)] = inst_14577__$1);

(statearr_14631[(10)] = inst_14578);

return statearr_14631;
})();
if(inst_14580){
var statearr_14632_14655 = state_14608__$1;
(statearr_14632_14655[(1)] = (9));

} else {
var statearr_14633_14656 = state_14608__$1;
(statearr_14633_14656[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_14634 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14634[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_14634[(1)] = (1));

return statearr_14634;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_14608){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14608);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14635){var ex__2749__auto__ = e14635;
var statearr_14636_14657 = state_14608;
(statearr_14636_14657[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14608[(4)]))){
var statearr_14637_14658 = state_14608;
(statearr_14637_14658[(1)] = cljs.core.first.call(null,(state_14608[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14659 = state_14608;
state_14608 = G__14659;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_14608){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_14608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14638 = f__2769__auto__.call(null);
(statearr_14638[(6)] = c__2768__auto__);

return statearr_14638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= fluree.db.flake.o.call(null,f))) && ((fluree.db.flake.o.call(null,f) <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14715){
var state_val_14716 = (state_14715[(1)]);
if((state_val_14716 === (7))){
var inst_14689 = (state_14715[(7)]);
var inst_14679 = (state_14715[(8)]);
var inst_14687 = fluree.db.flake.Flake__GT_parts.call(null,inst_14679);
var inst_14688 = cljs.core.nth.call(null,inst_14687,(0),null);
var inst_14689__$1 = cljs.core.nth.call(null,inst_14687,(1),null);
var inst_14690 = cljs.core.nth.call(null,inst_14687,(2),null);
var inst_14691 = cljs.core.nth.call(null,inst_14687,(3),null);
var inst_14692 = cljs.core.nth.call(null,inst_14687,(4),null);
var inst_14693 = cljs.core.nth.call(null,inst_14687,(5),null);
var inst_14694 = fluree.db.dbproto._tag.call(null,db,inst_14690,inst_14689__$1);
var state_14715__$1 = (function (){var statearr_14717 = state_14715;
(statearr_14717[(9)] = inst_14688);

(statearr_14717[(10)] = inst_14693);

(statearr_14717[(11)] = inst_14692);

(statearr_14717[(7)] = inst_14689__$1);

(statearr_14717[(12)] = inst_14691);

return statearr_14717;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14715__$1,(10),inst_14694);
} else {
if((state_val_14716 === (1))){
var inst_14667 = flakes;
var inst_14668 = cljs.core.seq.call(null,inst_14667);
var inst_14669 = cljs.core.first.call(null,inst_14668);
var inst_14670 = cljs.core.next.call(null,inst_14668);
var inst_14671 = cljs.core.PersistentVector.EMPTY;
var inst_14672 = inst_14667;
var inst_14673 = inst_14671;
var state_14715__$1 = (function (){var statearr_14718 = state_14715;
(statearr_14718[(13)] = inst_14669);

(statearr_14718[(14)] = inst_14670);

(statearr_14718[(15)] = inst_14672);

(statearr_14718[(16)] = inst_14673);

return statearr_14718;
})();
var statearr_14719_14737 = state_14715__$1;
(statearr_14719_14737[(2)] = null);

(statearr_14719_14737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (4))){
var inst_14679 = (state_14715[(8)]);
var inst_14682 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_14679);
var state_14715__$1 = state_14715;
if(inst_14682){
var statearr_14720_14738 = state_14715__$1;
(statearr_14720_14738[(1)] = (7));

} else {
var statearr_14721_14739 = state_14715__$1;
(statearr_14721_14739[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (6))){
var inst_14711 = (state_14715[(2)]);
var state_14715__$1 = state_14715;
var statearr_14722_14740 = state_14715__$1;
(statearr_14722_14740[(2)] = inst_14711);

(statearr_14722_14740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (3))){
var inst_14713 = (state_14715[(2)]);
var state_14715__$1 = state_14715;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14715__$1,inst_14713);
} else {
if((state_val_14716 === (2))){
var inst_14672 = (state_14715[(15)]);
var inst_14679 = (state_14715[(8)]);
var inst_14678 = cljs.core.seq.call(null,inst_14672);
var inst_14679__$1 = cljs.core.first.call(null,inst_14678);
var inst_14680 = cljs.core.next.call(null,inst_14678);
var state_14715__$1 = (function (){var statearr_14723 = state_14715;
(statearr_14723[(17)] = inst_14680);

(statearr_14723[(8)] = inst_14679__$1);

return statearr_14723;
})();
if(cljs.core.truth_(inst_14679__$1)){
var statearr_14724_14741 = state_14715__$1;
(statearr_14724_14741[(1)] = (4));

} else {
var statearr_14725_14742 = state_14715__$1;
(statearr_14725_14742[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (9))){
var inst_14708 = (state_14715[(2)]);
var state_14715__$1 = state_14715;
var statearr_14726_14743 = state_14715__$1;
(statearr_14726_14743[(2)] = inst_14708);

(statearr_14726_14743[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (5))){
var inst_14673 = (state_14715[(16)]);
var state_14715__$1 = state_14715;
var statearr_14727_14744 = state_14715__$1;
(statearr_14727_14744[(2)] = inst_14673);

(statearr_14727_14744[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (10))){
var inst_14688 = (state_14715[(9)]);
var inst_14693 = (state_14715[(10)]);
var inst_14692 = (state_14715[(11)]);
var inst_14689 = (state_14715[(7)]);
var inst_14680 = (state_14715[(17)]);
var inst_14691 = (state_14715[(12)]);
var inst_14673 = (state_14715[(16)]);
var inst_14696 = (state_14715[(2)]);
var inst_14697 = fluree.db.util.async.throw_err.call(null,inst_14696);
var inst_14698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14699 = [inst_14688,inst_14689,inst_14697,inst_14691,inst_14692,inst_14693];
var inst_14700 = (new cljs.core.PersistentVector(null,6,(5),inst_14698,inst_14699,null));
var inst_14701 = fluree.db.flake.parts__GT_Flake.call(null,inst_14700);
var inst_14702 = cljs.core.conj.call(null,inst_14673,inst_14701);
var inst_14672 = inst_14680;
var inst_14673__$1 = inst_14702;
var state_14715__$1 = (function (){var statearr_14728 = state_14715;
(statearr_14728[(15)] = inst_14672);

(statearr_14728[(16)] = inst_14673__$1);

return statearr_14728;
})();
var statearr_14729_14745 = state_14715__$1;
(statearr_14729_14745[(2)] = null);

(statearr_14729_14745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (8))){
var inst_14680 = (state_14715[(17)]);
var inst_14673 = (state_14715[(16)]);
var inst_14679 = (state_14715[(8)]);
var inst_14705 = cljs.core.conj.call(null,inst_14673,inst_14679);
var inst_14672 = inst_14680;
var inst_14673__$1 = inst_14705;
var state_14715__$1 = (function (){var statearr_14730 = state_14715;
(statearr_14730[(15)] = inst_14672);

(statearr_14730[(16)] = inst_14673__$1);

return statearr_14730;
})();
var statearr_14731_14746 = state_14715__$1;
(statearr_14731_14746[(2)] = null);

(statearr_14731_14746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0 = (function (){
var statearr_14732 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14732[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__);

(statearr_14732[(1)] = (1));

return statearr_14732;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1 = (function (state_14715){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14715);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e14733){var ex__2749__auto__ = e14733;
var statearr_14734_14747 = state_14715;
(statearr_14734_14747[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14715[(4)]))){
var statearr_14735_14748 = state_14715;
(statearr_14735_14748[(1)] = cljs.core.first.call(null,(state_14715[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14749 = state_14715;
state_14715 = G__14749;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__ = function(state_14715){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1.call(this,state_14715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_14736 = f__2769__auto__.call(null);
(statearr_14736[(6)] = c__2768__auto__);

return statearr_14736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__14751 = arguments.length;
switch (G__14751) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_14933){
var state_val_14934 = (state_14933[(1)]);
if((state_val_14934 === (65))){
var inst_14802 = (state_14933[(7)]);
var state_14933__$1 = state_14933;
if(cljs.core.truth_(inst_14802)){
var statearr_14935_15039 = state_14933__$1;
(statearr_14935_15039[(1)] = (68));

} else {
var statearr_14936_15040 = state_14933__$1;
(statearr_14936_15040[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (70))){
var inst_14912 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
var statearr_14937_15041 = state_14933__$1;
(statearr_14937_15041[(2)] = inst_14912);

(statearr_14937_15041[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (62))){
var inst_14878 = (state_14933[(2)]);
var inst_14879 = fluree.db.util.async.throw_err.call(null,inst_14878);
var inst_14880 = cljs.core.take.call(null,(1),inst_14879);
var state_14933__$1 = state_14933;
var statearr_14938_15042 = state_14933__$1;
(statearr_14938_15042[(2)] = inst_14880);

(statearr_14938_15042[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (74))){
var inst_14928 = (state_14933[(2)]);
var _ = (function (){var statearr_14939 = state_14933;
(statearr_14939[(4)] = cljs.core.rest.call(null,(state_14933[(4)])));

return statearr_14939;
})();
var state_14933__$1 = state_14933;
var statearr_14940_15043 = state_14933__$1;
(statearr_14940_15043[(2)] = inst_14928);

(statearr_14940_15043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (7))){
var state_14933__$1 = state_14933;
var statearr_14941_15044 = state_14933__$1;
(statearr_14941_15044[(2)] = false);

(statearr_14941_15044[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (59))){
var inst_14802 = (state_14933[(7)]);
var inst_14872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14873 = [inst_14802];
var inst_14874 = (new cljs.core.PersistentVector(null,1,(5),inst_14872,inst_14873,null));
var inst_14875 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_14876 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14874,inst_14875);
var state_14933__$1 = state_14933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14933__$1,(62),inst_14876);
} else {
if((state_val_14934 === (20))){
var state_14933__$1 = state_14933;
var statearr_14942_15045 = state_14933__$1;
(statearr_14942_15045[(2)] = null);

(statearr_14942_15045[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (72))){
var inst_14920 = (state_14933[(8)]);
var inst_14922 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_14920);
var state_14933__$1 = state_14933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14933__$1,(75),inst_14922);
} else {
if((state_val_14934 === (58))){
var inst_14870 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
if(cljs.core.truth_(inst_14870)){
var statearr_14943_15046 = state_14933__$1;
(statearr_14943_15046[(1)] = (59));

} else {
var statearr_14944_15047 = state_14933__$1;
(statearr_14944_15047[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (60))){
var inst_14762 = (state_14933[(9)]);
var inst_14864 = (state_14933[(10)]);
var inst_14765 = (state_14933[(11)]);
var inst_14763 = (state_14933[(12)]);
var inst_14882 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14883 = [inst_14763,inst_14762,null,inst_14765];
var inst_14884 = (new cljs.core.PersistentVector(null,4,(5),inst_14882,inst_14883,null));
var inst_14885 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_14864);
var inst_14886 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14884,inst_14885);
var state_14933__$1 = state_14933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14933__$1,(63),inst_14886);
} else {
if((state_val_14934 === (27))){
var inst_14762 = (state_14933[(9)]);
var inst_14765 = (state_14933[(11)]);
var inst_14763 = (state_14933[(12)]);
var inst_14802 = (state_14933[(7)]);
var inst_14814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14815 = [inst_14762,inst_14763,inst_14802,inst_14765];
var inst_14816 = (new cljs.core.PersistentVector(null,4,(5),inst_14814,inst_14815,null));
var inst_14817 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14816,opts);
var state_14933__$1 = state_14933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14933__$1,(30),inst_14817);
} else {
if((state_val_14934 === (1))){
var state_14933__$1 = state_14933;
var statearr_14945_15048 = state_14933__$1;
(statearr_14945_15048[(2)] = null);

(statearr_14945_15048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (69))){
var state_14933__$1 = state_14933;
var statearr_14946_15049 = state_14933__$1;
(statearr_14946_15049[(2)] = null);

(statearr_14946_15049[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (24))){
var inst_14763 = (state_14933[(12)]);
var state_14933__$1 = state_14933;
if(cljs.core.truth_(inst_14763)){
var statearr_14947_15050 = state_14933__$1;
(statearr_14947_15050[(1)] = (31));

} else {
var statearr_14948_15051 = state_14933__$1;
(statearr_14948_15051[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (55))){
var inst_14865 = (state_14933[(13)]);
var inst_14763 = (state_14933[(12)]);
var inst_14864 = (state_14933[(2)]);
var inst_14865__$1 = cljs.core._EQ_.call(null,"_id",inst_14763);
var state_14933__$1 = (function (){var statearr_14949 = state_14933;
(statearr_14949[(10)] = inst_14864);

(statearr_14949[(13)] = inst_14865__$1);

return statearr_14949;
})();
if(inst_14865__$1){
var statearr_14950_15052 = state_14933__$1;
(statearr_14950_15052[(1)] = (56));

} else {
var statearr_14951_15053 = state_14933__$1;
(statearr_14951_15053[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (39))){
var inst_14832 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
var statearr_14952_15054 = state_14933__$1;
(statearr_14952_15054[(2)] = inst_14832);

(statearr_14952_15054[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (46))){
var inst_14856 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
if(cljs.core.truth_(inst_14856)){
var statearr_14953_15055 = state_14933__$1;
(statearr_14953_15055[(1)] = (50));

} else {
var statearr_14954_15056 = state_14933__$1;
(statearr_14954_15056[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (4))){
var inst_14752 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
var statearr_14955_15057 = state_14933__$1;
(statearr_14955_15057[(2)] = inst_14752);

(statearr_14955_15057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (54))){
var inst_14772 = (state_14933[(14)]);
var inst_14777 = (state_14933[(15)]);
var inst_14762 = (state_14933[(9)]);
var inst_14761 = (state_14933[(16)]);
var inst_14858 = (state_14933[(17)]);
var inst_14765 = (state_14933[(11)]);
var inst_14763 = (state_14933[(12)]);
var inst_14802 = (state_14933[(7)]);
var inst_14766 = (state_14933[(18)]);
var inst_14862 = (function (){var t = inst_14765;
var temp__5802__auto__ = inst_14858;
var vec__14758 = inst_14761;
var p = inst_14763;
var idx_predicate_QMARK_ = inst_14766;
var o = inst_14802;
var tag_predicate_QMARK_ = inst_14772;
var s = inst_14762;
var o_coerce_QMARK_ = inst_14777;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_14933__$1 = state_14933;
var statearr_14956_15058 = state_14933__$1;
(statearr_14956_15058[(2)] = inst_14862);

(statearr_14956_15058[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (15))){
var inst_14764 = (state_14933[(19)]);
var inst_14783 = fluree.db.dbproto._tag_id.call(null,db,inst_14764);
var state_14933__$1 = state_14933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14933__$1,(18),inst_14783);
} else {
if((state_val_14934 === (48))){
var inst_14849 = (state_14933[(20)]);
var state_14933__$1 = state_14933;
var statearr_14957_15059 = state_14933__$1;
(statearr_14957_15059[(2)] = inst_14849);

(statearr_14957_15059[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (50))){
var inst_14858 = (state_14933[(17)]);
var inst_14858__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_14933__$1 = (function (){var statearr_14958 = state_14933;
(statearr_14958[(17)] = inst_14858__$1);

return statearr_14958;
})();
if(cljs.core.truth_(inst_14858__$1)){
var statearr_14959_15060 = state_14933__$1;
(statearr_14959_15060[(1)] = (53));

} else {
var statearr_14960_15061 = state_14933__$1;
(statearr_14960_15061[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (75))){
var inst_14924 = (state_14933[(2)]);
var inst_14925 = fluree.db.util.async.throw_err.call(null,inst_14924);
var state_14933__$1 = state_14933;
var statearr_14961_15062 = state_14933__$1;
(statearr_14961_15062[(2)] = inst_14925);

(statearr_14961_15062[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (21))){
var inst_14798 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
var statearr_14962_15063 = state_14933__$1;
(statearr_14962_15063[(2)] = inst_14798);

(statearr_14962_15063[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (31))){
var inst_14825 = (state_14933[(21)]);
var inst_14802 = (state_14933[(7)]);
var inst_14825__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_14802);
var state_14933__$1 = (function (){var statearr_14963 = state_14933;
(statearr_14963[(21)] = inst_14825__$1);

return statearr_14963;
})();
if(inst_14825__$1){
var statearr_14964_15064 = state_14933__$1;
(statearr_14964_15064[(1)] = (34));

} else {
var statearr_14965_15065 = state_14933__$1;
(statearr_14965_15065[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (32))){
var inst_14763 = (state_14933[(12)]);
var state_14933__$1 = state_14933;
var statearr_14966_15066 = state_14933__$1;
(statearr_14966_15066[(2)] = inst_14763);

(statearr_14966_15066[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (40))){
var inst_14762 = (state_14933[(9)]);
var inst_14765 = (state_14933[(11)]);
var inst_14763 = (state_14933[(12)]);
var inst_14802 = (state_14933[(7)]);
var inst_14840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14841 = [inst_14763,inst_14802,inst_14762,inst_14765];
var inst_14842 = (new cljs.core.PersistentVector(null,4,(5),inst_14840,inst_14841,null));
var inst_14843 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_14842,opts);
var state_14933__$1 = state_14933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14933__$1,(43),inst_14843);
} else {
if((state_val_14934 === (56))){
var inst_14802 = (state_14933[(7)]);
var inst_14867 = cljs.core.int_QMARK_.call(null,inst_14802);
var state_14933__$1 = state_14933;
var statearr_14967_15067 = state_14933__$1;
(statearr_14967_15067[(2)] = inst_14867);

(statearr_14967_15067[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (33))){
var inst_14838 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
if(cljs.core.truth_(inst_14838)){
var statearr_14968_15068 = state_14933__$1;
(statearr_14968_15068[(1)] = (40));

} else {
var statearr_14969_15069 = state_14933__$1;
(statearr_14969_15069[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (13))){
var inst_14764 = (state_14933[(19)]);
var inst_14781 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_14764);
var state_14933__$1 = state_14933;
if(cljs.core.truth_(inst_14781)){
var statearr_14970_15070 = state_14933__$1;
(statearr_14970_15070[(1)] = (15));

} else {
var statearr_14971_15071 = state_14933__$1;
(statearr_14971_15071[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (22))){
var inst_14794 = (state_14933[(2)]);
var inst_14795 = fluree.db.util.async.throw_err.call(null,inst_14794);
var state_14933__$1 = state_14933;
var statearr_14972_15072 = state_14933__$1;
(statearr_14972_15072[(2)] = inst_14795);

(statearr_14972_15072[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (36))){
var inst_14835 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
var statearr_14973_15073 = state_14933__$1;
(statearr_14973_15073[(2)] = inst_14835);

(statearr_14973_15073[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (41))){
var inst_14763 = (state_14933[(12)]);
var state_14933__$1 = state_14933;
if(cljs.core.truth_(inst_14763)){
var statearr_14974_15074 = state_14933__$1;
(statearr_14974_15074[(1)] = (44));

} else {
var statearr_14975_15075 = state_14933__$1;
(statearr_14975_15075[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (43))){
var inst_14845 = (state_14933[(2)]);
var inst_14846 = fluree.db.util.async.throw_err.call(null,inst_14845);
var state_14933__$1 = state_14933;
var statearr_14976_15076 = state_14933__$1;
(statearr_14976_15076[(2)] = inst_14846);

(statearr_14976_15076[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (61))){
var inst_14891 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
var statearr_14977_15077 = state_14933__$1;
(statearr_14977_15077[(2)] = inst_14891);

(statearr_14977_15077[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (29))){
var inst_14811 = (state_14933[(2)]);
var inst_14812 = fluree.db.util.async.throw_err.call(null,inst_14811);
var state_14933__$1 = state_14933;
var statearr_14978_15078 = state_14933__$1;
(statearr_14978_15078[(2)] = inst_14812);

(statearr_14978_15078[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (44))){
var inst_14849 = (state_14933[(20)]);
var inst_14766 = (state_14933[(18)]);
var inst_14849__$1 = cljs.core.not.call(null,inst_14766);
var state_14933__$1 = (function (){var statearr_14979 = state_14933;
(statearr_14979[(20)] = inst_14849__$1);

return statearr_14979;
})();
if(inst_14849__$1){
var statearr_14980_15079 = state_14933__$1;
(statearr_14980_15079[(1)] = (47));

} else {
var statearr_14981_15080 = state_14933__$1;
(statearr_14981_15080[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (6))){
var inst_14763 = (state_14933[(12)]);
var inst_14768 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_14763);
var inst_14769 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_14768);
var state_14933__$1 = state_14933;
var statearr_14982_15081 = state_14933__$1;
(statearr_14982_15081[(2)] = inst_14769);

(statearr_14982_15081[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (28))){
var inst_14822 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
var statearr_14983_15082 = state_14933__$1;
(statearr_14983_15082[(2)] = inst_14822);

(statearr_14983_15082[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (64))){
var inst_14762 = (state_14933[(9)]);
var inst_14765 = (state_14933[(11)]);
var inst_14763 = (state_14933[(12)]);
var inst_14802 = (state_14933[(7)]);
var inst_14894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14895 = [inst_14763,inst_14762,inst_14802,inst_14765];
var inst_14896 = (new cljs.core.PersistentVector(null,4,(5),inst_14894,inst_14895,null));
var inst_14897 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14896,opts);
var state_14933__$1 = state_14933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14933__$1,(67),inst_14897);
} else {
if((state_val_14934 === (51))){
var inst_14763 = (state_14933[(12)]);
var state_14933__$1 = state_14933;
if(cljs.core.truth_(inst_14763)){
var statearr_14984_15083 = state_14933__$1;
(statearr_14984_15083[(1)] = (64));

} else {
var statearr_14985_15084 = state_14933__$1;
(statearr_14985_15084[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (25))){
var inst_14772 = (state_14933[(14)]);
var inst_14920 = (state_14933[(2)]);
var state_14933__$1 = (function (){var statearr_14986 = state_14933;
(statearr_14986[(8)] = inst_14920);

return statearr_14986;
})();
if(cljs.core.truth_(inst_14772)){
var statearr_14987_15085 = state_14933__$1;
(statearr_14987_15085[(1)] = (72));

} else {
var statearr_14988_15086 = state_14933__$1;
(statearr_14988_15086[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (34))){
var inst_14766 = (state_14933[(18)]);
var state_14933__$1 = state_14933;
if(cljs.core.truth_(inst_14766)){
var statearr_14989_15087 = state_14933__$1;
(statearr_14989_15087[(1)] = (37));

} else {
var statearr_14990_15088 = state_14933__$1;
(statearr_14990_15088[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (17))){
var inst_14800 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
var statearr_14991_15089 = state_14933__$1;
(statearr_14991_15089[(2)] = inst_14800);

(statearr_14991_15089[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (3))){
var inst_14931 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14933__$1,inst_14931);
} else {
if((state_val_14934 === (12))){
var inst_14764 = (state_14933[(19)]);
var state_14933__$1 = state_14933;
var statearr_14992_15090 = state_14933__$1;
(statearr_14992_15090[(2)] = inst_14764);

(statearr_14992_15090[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (2))){
var inst_14761 = (state_14933[(16)]);
var inst_14763 = (state_14933[(12)]);
var _ = (function (){var statearr_14993 = state_14933;
(statearr_14993[(4)] = cljs.core.cons.call(null,(5),(state_14933[(4)])));

return statearr_14993;
})();
var inst_14761__$1 = fparts;
var inst_14762 = cljs.core.nth.call(null,inst_14761__$1,(0),null);
var inst_14763__$1 = cljs.core.nth.call(null,inst_14761__$1,(1),null);
var inst_14764 = cljs.core.nth.call(null,inst_14761__$1,(2),null);
var inst_14765 = cljs.core.nth.call(null,inst_14761__$1,(3),null);
var inst_14766 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_14763__$1);
var state_14933__$1 = (function (){var statearr_14994 = state_14933;
(statearr_14994[(9)] = inst_14762);

(statearr_14994[(16)] = inst_14761__$1);

(statearr_14994[(11)] = inst_14765);

(statearr_14994[(12)] = inst_14763__$1);

(statearr_14994[(19)] = inst_14764);

(statearr_14994[(18)] = inst_14766);

return statearr_14994;
})();
if(cljs.core.truth_(inst_14763__$1)){
var statearr_14995_15091 = state_14933__$1;
(statearr_14995_15091[(1)] = (6));

} else {
var statearr_14996_15092 = state_14933__$1;
(statearr_14996_15092[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (66))){
var inst_14914 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
var statearr_14997_15093 = state_14933__$1;
(statearr_14997_15093[(2)] = inst_14914);

(statearr_14997_15093[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (23))){
var inst_14763 = (state_14933[(12)]);
var inst_14804 = cljs.core._EQ_.call(null,"_id",inst_14763);
var state_14933__$1 = state_14933;
if(inst_14804){
var statearr_14998_15094 = state_14933__$1;
(statearr_14998_15094[(1)] = (26));

} else {
var statearr_14999_15095 = state_14933__$1;
(statearr_14999_15095[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (47))){
var inst_14802 = (state_14933[(7)]);
var state_14933__$1 = state_14933;
var statearr_15000_15096 = state_14933__$1;
(statearr_15000_15096[(2)] = inst_14802);

(statearr_15000_15096[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (35))){
var inst_14825 = (state_14933[(21)]);
var state_14933__$1 = state_14933;
var statearr_15001_15097 = state_14933__$1;
(statearr_15001_15097[(2)] = inst_14825);

(statearr_15001_15097[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (19))){
var inst_14763 = (state_14933[(12)]);
var inst_14764 = (state_14933[(19)]);
var inst_14790 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_14763);
var inst_14791 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14790),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14764)].join('');
var inst_14792 = fluree.db.dbproto._tag_id.call(null,db,inst_14791);
var state_14933__$1 = state_14933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14933__$1,(22),inst_14792);
} else {
if((state_val_14934 === (57))){
var inst_14865 = (state_14933[(13)]);
var state_14933__$1 = state_14933;
var statearr_15002_15098 = state_14933__$1;
(statearr_15002_15098[(2)] = inst_14865);

(statearr_15002_15098[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (68))){
var inst_14762 = (state_14933[(9)]);
var inst_14765 = (state_14933[(11)]);
var inst_14763 = (state_14933[(12)]);
var inst_14802 = (state_14933[(7)]);
var inst_14903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14904 = [inst_14802,inst_14763,inst_14762,inst_14765];
var inst_14905 = (new cljs.core.PersistentVector(null,4,(5),inst_14903,inst_14904,null));
var inst_14906 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_14905,opts);
var state_14933__$1 = state_14933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14933__$1,(71),inst_14906);
} else {
if((state_val_14934 === (11))){
var inst_14777 = (state_14933[(15)]);
var inst_14777__$1 = (state_14933[(2)]);
var inst_14778 = cljs.core.not.call(null,inst_14777__$1);
var state_14933__$1 = (function (){var statearr_15004 = state_14933;
(statearr_15004[(15)] = inst_14777__$1);

return statearr_15004;
})();
if(inst_14778){
var statearr_15005_15099 = state_14933__$1;
(statearr_15005_15099[(1)] = (12));

} else {
var statearr_15006_15100 = state_14933__$1;
(statearr_15006_15100[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (9))){
var inst_14764 = (state_14933[(19)]);
var inst_14774 = typeof inst_14764 === 'string';
var state_14933__$1 = state_14933;
var statearr_15007_15101 = state_14933__$1;
(statearr_15007_15101[(2)] = inst_14774);

(statearr_15007_15101[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (5))){
var _ = (function (){var statearr_15008 = state_14933;
(statearr_15008[(4)] = cljs.core.rest.call(null,(state_14933[(4)])));

return statearr_15008;
})();
var state_14933__$1 = state_14933;
var ex15003 = (state_14933__$1[(2)]);
var statearr_15009_15102 = state_14933__$1;
(statearr_15009_15102[(5)] = ex15003);


if((ex15003 instanceof Error)){
var statearr_15010_15103 = state_14933__$1;
(statearr_15010_15103[(1)] = (4));

(statearr_15010_15103[(5)] = null);

} else {
throw ex15003;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (14))){
var inst_14762 = (state_14933[(9)]);
var inst_14802 = (state_14933[(2)]);
var state_14933__$1 = (function (){var statearr_15011 = state_14933;
(statearr_15011[(7)] = inst_14802);

return statearr_15011;
})();
if(cljs.core.truth_(inst_14762)){
var statearr_15012_15104 = state_14933__$1;
(statearr_15012_15104[(1)] = (23));

} else {
var statearr_15013_15105 = state_14933__$1;
(statearr_15013_15105[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (45))){
var inst_14763 = (state_14933[(12)]);
var state_14933__$1 = state_14933;
var statearr_15014_15106 = state_14933__$1;
(statearr_15014_15106[(2)] = inst_14763);

(statearr_15014_15106[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (53))){
var inst_14772 = (state_14933[(14)]);
var inst_14777 = (state_14933[(15)]);
var inst_14762 = (state_14933[(9)]);
var inst_14761 = (state_14933[(16)]);
var inst_14858 = (state_14933[(17)]);
var inst_14765 = (state_14933[(11)]);
var inst_14763 = (state_14933[(12)]);
var inst_14802 = (state_14933[(7)]);
var inst_14766 = (state_14933[(18)]);
var inst_14860 = (function (){var obj_fn = inst_14858;
var t = inst_14765;
var temp__5802__auto__ = inst_14858;
var vec__14758 = inst_14761;
var p = inst_14763;
var idx_predicate_QMARK_ = inst_14766;
var o = inst_14802;
var tag_predicate_QMARK_ = inst_14772;
var s = inst_14762;
var o_coerce_QMARK_ = inst_14777;
return (function (x){
var and__4251__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__4251__auto__;
}
});
})();
var state_14933__$1 = state_14933;
var statearr_15015_15107 = state_14933__$1;
(statearr_15015_15107[(2)] = inst_14860);

(statearr_15015_15107[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (26))){
var inst_14762 = (state_14933[(9)]);
var inst_14765 = (state_14933[(11)]);
var inst_14806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14807 = [inst_14762,null,null,inst_14765];
var inst_14808 = (new cljs.core.PersistentVector(null,4,(5),inst_14806,inst_14807,null));
var inst_14809 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14808,opts);
var state_14933__$1 = state_14933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14933__$1,(29),inst_14809);
} else {
if((state_val_14934 === (16))){
var inst_14764 = (state_14933[(19)]);
var inst_14788 = typeof inst_14764 === 'string';
var state_14933__$1 = state_14933;
if(cljs.core.truth_(inst_14788)){
var statearr_15016_15108 = state_14933__$1;
(statearr_15016_15108[(1)] = (19));

} else {
var statearr_15017_15109 = state_14933__$1;
(statearr_15017_15109[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (38))){
var inst_14766 = (state_14933[(18)]);
var state_14933__$1 = state_14933;
var statearr_15018_15110 = state_14933__$1;
(statearr_15018_15110[(2)] = inst_14766);

(statearr_15018_15110[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (30))){
var inst_14819 = (state_14933[(2)]);
var inst_14820 = fluree.db.util.async.throw_err.call(null,inst_14819);
var state_14933__$1 = state_14933;
var statearr_15019_15111 = state_14933__$1;
(statearr_15019_15111[(2)] = inst_14820);

(statearr_15019_15111[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (73))){
var inst_14920 = (state_14933[(8)]);
var state_14933__$1 = state_14933;
var statearr_15020_15112 = state_14933__$1;
(statearr_15020_15112[(2)] = inst_14920);

(statearr_15020_15112[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (10))){
var inst_14772 = (state_14933[(14)]);
var state_14933__$1 = state_14933;
var statearr_15021_15113 = state_14933__$1;
(statearr_15021_15113[(2)] = inst_14772);

(statearr_15021_15113[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (18))){
var inst_14785 = (state_14933[(2)]);
var inst_14786 = fluree.db.util.async.throw_err.call(null,inst_14785);
var state_14933__$1 = state_14933;
var statearr_15022_15114 = state_14933__$1;
(statearr_15022_15114[(2)] = inst_14786);

(statearr_15022_15114[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (52))){
var inst_14916 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
var statearr_15023_15115 = state_14933__$1;
(statearr_15023_15115[(2)] = inst_14916);

(statearr_15023_15115[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (67))){
var inst_14899 = (state_14933[(2)]);
var inst_14900 = fluree.db.util.async.throw_err.call(null,inst_14899);
var state_14933__$1 = state_14933;
var statearr_15024_15116 = state_14933__$1;
(statearr_15024_15116[(2)] = inst_14900);

(statearr_15024_15116[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (71))){
var inst_14908 = (state_14933[(2)]);
var inst_14909 = fluree.db.util.async.throw_err.call(null,inst_14908);
var state_14933__$1 = state_14933;
var statearr_15025_15117 = state_14933__$1;
(statearr_15025_15117[(2)] = inst_14909);

(statearr_15025_15117[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (42))){
var inst_14918 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
var statearr_15026_15118 = state_14933__$1;
(statearr_15026_15118[(2)] = inst_14918);

(statearr_15026_15118[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (37))){
var inst_14802 = (state_14933[(7)]);
var inst_14828 = cljs.core.fn_QMARK_.call(null,inst_14802);
var inst_14829 = (!(inst_14828));
var state_14933__$1 = state_14933;
var statearr_15027_15119 = state_14933__$1;
(statearr_15027_15119[(2)] = inst_14829);

(statearr_15027_15119[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (63))){
var inst_14888 = (state_14933[(2)]);
var inst_14889 = fluree.db.util.async.throw_err.call(null,inst_14888);
var state_14933__$1 = state_14933;
var statearr_15028_15120 = state_14933__$1;
(statearr_15028_15120[(2)] = inst_14889);

(statearr_15028_15120[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (8))){
var inst_14772 = (state_14933[(14)]);
var inst_14772__$1 = (state_14933[(2)]);
var state_14933__$1 = (function (){var statearr_15029 = state_14933;
(statearr_15029[(14)] = inst_14772__$1);

return statearr_15029;
})();
if(cljs.core.truth_(inst_14772__$1)){
var statearr_15030_15121 = state_14933__$1;
(statearr_15030_15121[(1)] = (9));

} else {
var statearr_15031_15122 = state_14933__$1;
(statearr_15031_15122[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14934 === (49))){
var inst_14853 = (state_14933[(2)]);
var state_14933__$1 = state_14933;
var statearr_15032_15123 = state_14933__$1;
(statearr_15032_15123[(2)] = inst_14853);

(statearr_15032_15123[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_15033 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15033[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_15033[(1)] = (1));

return statearr_15033;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_14933){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_14933);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15034){var ex__2749__auto__ = e15034;
var statearr_15035_15124 = state_14933;
(statearr_15035_15124[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_14933[(4)]))){
var statearr_15036_15125 = state_14933;
(statearr_15036_15125[(1)] = cljs.core.first.call(null,(state_14933[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15126 = state_14933;
state_14933 = G__15126;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_14933){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_14933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15037 = f__2769__auto__.call(null);
(statearr_15037[(6)] = c__2768__auto__);

return statearr_15037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15128 = arguments.length;
switch (G__15128) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15163){
var state_val_15164 = (state_15163[(1)]);
if((state_val_15164 === (7))){
var inst_15150 = cljs.core.pr_str.call(null,name);
var inst_15151 = ["Invalid collection name: ",inst_15150].join('');
var inst_15152 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15153 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15154 = cljs.core.PersistentHashMap.fromArrays(inst_15152,inst_15153);
var inst_15155 = cljs.core.ex_info.call(null,inst_15151,inst_15154);
var inst_15156 = (function(){throw inst_15155})();
var state_15163__$1 = state_15163;
var statearr_15165_15185 = state_15163__$1;
(statearr_15165_15185[(2)] = inst_15156);

(statearr_15165_15185[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15164 === (1))){
var state_15163__$1 = state_15163;
var statearr_15166_15186 = state_15163__$1;
(statearr_15166_15186[(2)] = null);

(statearr_15166_15186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15164 === (4))){
var inst_15129 = (state_15163[(2)]);
var state_15163__$1 = state_15163;
var statearr_15167_15187 = state_15163__$1;
(statearr_15167_15187[(2)] = inst_15129);

(statearr_15167_15187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15164 === (6))){
var inst_15135 = (state_15163[(7)]);
var inst_15137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15138 = fluree.db.flake.max_subject_id.call(null,inst_15135);
var inst_15139 = [inst_15138];
var inst_15140 = (new cljs.core.PersistentVector(null,1,(5),inst_15137,inst_15139,null));
var inst_15141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15142 = fluree.db.flake.min_subject_id.call(null,inst_15135);
var inst_15143 = [inst_15142];
var inst_15144 = (new cljs.core.PersistentVector(null,1,(5),inst_15141,inst_15143,null));
var inst_15145 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15140,cljs.core._LT__EQ_,inst_15144,opts);
var state_15163__$1 = state_15163;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15163__$1,(9),inst_15145);
} else {
if((state_val_15164 === (3))){
var inst_15161 = (state_15163[(2)]);
var state_15163__$1 = state_15163;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15163__$1,inst_15161);
} else {
if((state_val_15164 === (2))){
var inst_15135 = (state_15163[(7)]);
var _ = (function (){var statearr_15169 = state_15163;
(statearr_15169[(4)] = cljs.core.cons.call(null,(5),(state_15163[(4)])));

return statearr_15169;
})();
var inst_15135__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15163__$1 = (function (){var statearr_15170 = state_15163;
(statearr_15170[(7)] = inst_15135__$1);

return statearr_15170;
})();
if(cljs.core.truth_(inst_15135__$1)){
var statearr_15171_15188 = state_15163__$1;
(statearr_15171_15188[(1)] = (6));

} else {
var statearr_15172_15189 = state_15163__$1;
(statearr_15172_15189[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15164 === (9))){
var inst_15147 = (state_15163[(2)]);
var inst_15148 = fluree.db.util.async.throw_err.call(null,inst_15147);
var state_15163__$1 = state_15163;
var statearr_15173_15190 = state_15163__$1;
(statearr_15173_15190[(2)] = inst_15148);

(statearr_15173_15190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15164 === (5))){
var _ = (function (){var statearr_15174 = state_15163;
(statearr_15174[(4)] = cljs.core.rest.call(null,(state_15163[(4)])));

return statearr_15174;
})();
var state_15163__$1 = state_15163;
var ex15168 = (state_15163__$1[(2)]);
var statearr_15175_15191 = state_15163__$1;
(statearr_15175_15191[(5)] = ex15168);


var statearr_15176_15192 = state_15163__$1;
(statearr_15176_15192[(1)] = (4));

(statearr_15176_15192[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15164 === (8))){
var inst_15158 = (state_15163[(2)]);
var _ = (function (){var statearr_15177 = state_15163;
(statearr_15177[(4)] = cljs.core.rest.call(null,(state_15163[(4)])));

return statearr_15177;
})();
var state_15163__$1 = state_15163;
var statearr_15178_15193 = state_15163__$1;
(statearr_15178_15193[(2)] = inst_15158);

(statearr_15178_15193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2746__auto__ = null;
var fluree$db$query$range$state_machine__2746__auto____0 = (function (){
var statearr_15179 = [null,null,null,null,null,null,null,null];
(statearr_15179[(0)] = fluree$db$query$range$state_machine__2746__auto__);

(statearr_15179[(1)] = (1));

return statearr_15179;
});
var fluree$db$query$range$state_machine__2746__auto____1 = (function (state_15163){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15163);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15180){var ex__2749__auto__ = e15180;
var statearr_15181_15194 = state_15163;
(statearr_15181_15194[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15163[(4)]))){
var statearr_15182_15195 = state_15163;
(statearr_15182_15195[(1)] = cljs.core.first.call(null,(state_15163[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15196 = state_15163;
state_15163 = G__15196;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2746__auto__ = function(state_15163){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2746__auto____1.call(this,state_15163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2746__auto____0;
fluree$db$query$range$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2746__auto____1;
return fluree$db$query$range$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15183 = f__2769__auto__.call(null);
(statearr_15183[(6)] = c__2768__auto__);

return statearr_15183;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15200 = flakes;
var vec__15201 = G__15200;
var seq__15202 = cljs.core.seq.call(null,vec__15201);
var first__15203 = cljs.core.first.call(null,seq__15202);
var seq__15202__$1 = cljs.core.next.call(null,seq__15202);
var flake_SINGLEQUOTE_ = first__15203;
var r = seq__15202__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15200__$1 = G__15200;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15209 = G__15200__$1;
var seq__15210 = cljs.core.seq.call(null,vec__15209);
var first__15211 = cljs.core.first.call(null,seq__15210);
var seq__15210__$1 = cljs.core.next.call(null,seq__15210);
var flake_SINGLEQUOTE___$1 = first__15211;
var r__$1 = seq__15210__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = fluree.db.flake.o.call(null,flake_SINGLEQUOTE___$1);
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e15213){var e = e15213;
return null;
}})();
var map__15212 = cmd_map;
var map__15212__$1 = cljs.core.__destructure_map.call(null,map__15212);
var type = cljs.core.get.call(null,map__15212__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__15212__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__15212__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__15212__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__15212__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__15212__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15214 = r__$1;
var G__15215 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15200__$1 = G__15214;
result_STAR___$1 = G__15215;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15224 = blocks;
var vec__15225 = G__15224;
var seq__15226 = cljs.core.seq.call(null,vec__15225);
var first__15227 = cljs.core.first.call(null,seq__15226);
var seq__15226__$1 = cljs.core.next.call(null,seq__15226);
var block_SINGLEQUOTE_ = first__15227;
var r = seq__15226__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15224__$1 = G__15224;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15232 = G__15224__$1;
var seq__15233 = cljs.core.seq.call(null,vec__15232);
var first__15234 = cljs.core.first.call(null,seq__15233);
var seq__15233__$1 = cljs.core.next.call(null,seq__15233);
var block_SINGLEQUOTE___$1 = first__15234;
var r__$1 = seq__15233__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15235 = block_SINGLEQUOTE___$1;
var map__15235__$1 = cljs.core.__destructure_map.call(null,map__15235);
var block = cljs.core.get.call(null,map__15235__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__15235__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__15235__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__15224__$1,result_STAR___$1,map__15235,map__15235__$1,block,t,flakes,vec__15232,seq__15233,first__15234,seq__15233__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15224,vec__15225,seq__15226,first__15227,seq__15226__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15216_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15216_SHARP_),(2))){
return fluree.db.flake.o.call(null,p1__15216_SHARP_);
} else {
return null;
}
});})(G__15224__$1,result_STAR___$1,map__15235,map__15235__$1,block,t,flakes,vec__15232,seq__15233,first__15234,seq__15233__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15224,vec__15225,seq__15226,first__15227,seq__15226__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__15224__$1,result_STAR___$1,map__15235,map__15235__$1,block,t,flakes,prev_hash,vec__15232,seq__15233,first__15234,seq__15233__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15224,vec__15225,seq__15226,first__15227,seq__15226__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15217_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15217_SHARP_),(1))){
return fluree.db.flake.o.call(null,p1__15217_SHARP_);
} else {
return null;
}
});})(G__15224__$1,result_STAR___$1,map__15235,map__15235__$1,block,t,flakes,prev_hash,vec__15232,seq__15233,first__15234,seq__15233__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15224,vec__15225,seq__15226,first__15227,seq__15226__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__15224__$1,result_STAR___$1,map__15235,map__15235__$1,block,t,flakes,prev_hash,hash,vec__15232,seq__15233,first__15234,seq__15233__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15224,vec__15225,seq__15226,first__15227,seq__15226__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15218_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15218_SHARP_),(5))){
return fluree.db.flake.o.call(null,p1__15218_SHARP_);
} else {
return null;
}
});})(G__15224__$1,result_STAR___$1,map__15235,map__15235__$1,block,t,flakes,prev_hash,hash,vec__15232,seq__15233,first__15234,seq__15233__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15224,vec__15225,seq__15226,first__15227,seq__15226__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__15224__$1,result_STAR___$1,map__15235,map__15235__$1,block,t,flakes,prev_hash,hash,instant,vec__15232,seq__15233,first__15234,seq__15233__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15224,vec__15225,seq__15226,first__15227,seq__15226__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15219_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15219_SHARP_),(7))){
return fluree.db.flake.o.call(null,p1__15219_SHARP_);
} else {
return null;
}
});})(G__15224__$1,result_STAR___$1,map__15235,map__15235__$1,block,t,flakes,prev_hash,hash,instant,vec__15232,seq__15233,first__15234,seq__15233__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15224,vec__15225,seq__15226,first__15227,seq__15226__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__15224__$1,result_STAR___$1,map__15235,map__15235__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15232,seq__15233,first__15234,seq__15233__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15224,vec__15225,seq__15226,first__15227,seq__15226__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15220_SHARP_){
return cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15220_SHARP_),(106));
});})(G__15224__$1,result_STAR___$1,map__15235,map__15235__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15232,seq__15233,first__15234,seq__15233__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15224,vec__15225,seq__15226,first__15227,seq__15226__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__15236 = r__$1;
var G__15237 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15224__$1 = G__15236;
result_STAR___$1 = G__15237;
continue;
}
break;
}
});
