// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.subject');
goog.require('fluree.db.query.subject_crawl.rdf_type');
goog.require('fluree.db.query.subject_crawl.common');
/**
 * Returns a parsed selection specification.
 * 
 *   This strategy is only deployed if there is a single selection graph crawl,
 *   so this assumes this case is true in code.
 */
fluree.db.query.subject_crawl.core.retrieve_select_spec = (function fluree$db$query$subject_crawl$core$retrieve_select_spec(db,p__23595){
var map__23596 = p__23595;
var map__23596__$1 = cljs.core.__destructure_map.call(null,map__23596);
var parsed_query = map__23596__$1;
var select = cljs.core.get.call(null,map__23596__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var opts = cljs.core.get.call(null,map__23596__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var select_smt = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(select)));
return fluree.db.query.fql_parser.parse_db.call(null,db,select_smt,opts);
});
fluree.db.query.subject_crawl.core.relationship_binding = (function fluree$db$query$subject_crawl$core$relationship_binding(p__23597){
var map__23598 = p__23597;
var map__23598__$1 = cljs.core.__destructure_map.call(null,map__23598);
var opts = map__23598__$1;
var rdf_type_QMARK_ = cljs.core.get.call(null,map__23598__$1,new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441));
var vars = cljs.core.get.call(null,map__23598__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23642){
var state_val_23643 = (state_23642[(1)]);
if((state_val_23643 === (7))){
var inst_23621 = (state_23642[(7)]);
var inst_23623 = fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl.call(null,inst_23621);
var state_23642__$1 = state_23642;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23642__$1,(10),inst_23623);
} else {
if((state_val_23643 === (1))){
var inst_23606 = vars;
var inst_23607 = cljs.core.seq.call(null,inst_23606);
var inst_23608 = cljs.core.first.call(null,inst_23607);
var inst_23609 = cljs.core.next.call(null,inst_23607);
var inst_23610 = cljs.core.PersistentVector.EMPTY;
var inst_23611 = inst_23606;
var inst_23612 = inst_23610;
var state_23642__$1 = (function (){var statearr_23644 = state_23642;
(statearr_23644[(8)] = inst_23609);

(statearr_23644[(9)] = inst_23608);

(statearr_23644[(10)] = inst_23612);

(statearr_23644[(11)] = inst_23611);

return statearr_23644;
})();
var statearr_23645_23663 = state_23642__$1;
(statearr_23645_23663[(2)] = null);

(statearr_23645_23663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23643 === (4))){
var inst_23618 = (state_23642[(12)]);
var inst_23621 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_23618);
var state_23642__$1 = (function (){var statearr_23646 = state_23642;
(statearr_23646[(7)] = inst_23621);

return statearr_23646;
})();
if(cljs.core.truth_(rdf_type_QMARK_)){
var statearr_23647_23664 = state_23642__$1;
(statearr_23647_23664[(1)] = (7));

} else {
var statearr_23648_23665 = state_23642__$1;
(statearr_23648_23665[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23643 === (6))){
var inst_23638 = (state_23642[(2)]);
var state_23642__$1 = state_23642;
var statearr_23649_23666 = state_23642__$1;
(statearr_23649_23666[(2)] = inst_23638);

(statearr_23649_23666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23643 === (3))){
var inst_23640 = (state_23642[(2)]);
var state_23642__$1 = state_23642;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23642__$1,inst_23640);
} else {
if((state_val_23643 === (2))){
var inst_23618 = (state_23642[(12)]);
var inst_23611 = (state_23642[(11)]);
var inst_23617 = cljs.core.seq.call(null,inst_23611);
var inst_23618__$1 = cljs.core.first.call(null,inst_23617);
var inst_23619 = cljs.core.next.call(null,inst_23617);
var state_23642__$1 = (function (){var statearr_23650 = state_23642;
(statearr_23650[(12)] = inst_23618__$1);

(statearr_23650[(13)] = inst_23619);

return statearr_23650;
})();
if(cljs.core.truth_(inst_23618__$1)){
var statearr_23651_23667 = state_23642__$1;
(statearr_23651_23667[(1)] = (4));

} else {
var statearr_23652_23668 = state_23642__$1;
(statearr_23652_23668[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23643 === (11))){
var inst_23630 = (state_23642[(2)]);
var inst_23631 = fluree.db.util.async.throw_err.call(null,inst_23630);
var state_23642__$1 = state_23642;
var statearr_23653_23669 = state_23642__$1;
(statearr_23653_23669[(2)] = inst_23631);

(statearr_23653_23669[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23643 === (9))){
var inst_23619 = (state_23642[(13)]);
var inst_23612 = (state_23642[(10)]);
var inst_23633 = (state_23642[(2)]);
var inst_23634 = cljs.core.into.call(null,inst_23612,inst_23633);
var inst_23611 = inst_23619;
var inst_23612__$1 = inst_23634;
var state_23642__$1 = (function (){var statearr_23654 = state_23642;
(statearr_23654[(10)] = inst_23612__$1);

(statearr_23654[(11)] = inst_23611);

return statearr_23654;
})();
var statearr_23655_23670 = state_23642__$1;
(statearr_23655_23670[(2)] = null);

(statearr_23655_23670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23643 === (5))){
var inst_23612 = (state_23642[(10)]);
var state_23642__$1 = state_23642;
var statearr_23656_23671 = state_23642__$1;
(statearr_23656_23671[(2)] = inst_23612);

(statearr_23656_23671[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23643 === (10))){
var inst_23625 = (state_23642[(2)]);
var inst_23626 = fluree.db.util.async.throw_err.call(null,inst_23625);
var state_23642__$1 = state_23642;
var statearr_23657_23672 = state_23642__$1;
(statearr_23657_23672[(2)] = inst_23626);

(statearr_23657_23672[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23643 === (8))){
var inst_23621 = (state_23642[(7)]);
var inst_23628 = fluree.db.query.subject_crawl.subject.subj_crawl.call(null,inst_23621);
var state_23642__$1 = state_23642;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23642__$1,(11),inst_23628);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____0 = (function (){
var statearr_23658 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23658[(0)] = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__);

(statearr_23658[(1)] = (1));

return statearr_23658;
});
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____1 = (function (state_23642){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23642);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23659){var ex__2749__auto__ = e23659;
var statearr_23660_23673 = state_23642;
(statearr_23660_23673[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23642[(4)]))){
var statearr_23661_23674 = state_23642;
(statearr_23661_23674[(1)] = cljs.core.first.call(null,(state_23642[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23675 = state_23642;
state_23642 = G__23675;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__ = function(state_23642){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____1.call(this,state_23642);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23662 = f__2769__auto__.call(null);
(statearr_23662[(6)] = c__2768__auto__);

return statearr_23662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * After results are processed, the response may be modified if:
 *   - order-by exists, in which case we need to perform a sort
 *   - selectOne? exists, in which case we take the (first result)
 *   - pretty-print is true, in which case each result needs to get embedded in a map
 */
fluree.db.query.subject_crawl.core.build_finishing_fn = (function fluree$db$query$subject_crawl$core$build_finishing_fn(p__23677){
var map__23678 = p__23677;
var map__23678__$1 = cljs.core.__destructure_map.call(null,map__23678);
var parsed_query = map__23678__$1;
var selectOne_QMARK_ = cljs.core.get.call(null,map__23678__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var order_by = cljs.core.get.call(null,map__23678__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var pretty_print = cljs.core.get.call(null,map__23678__$1,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var fns = (function (){var G__23679 = cljs.core.PersistentVector.EMPTY;
var G__23679__$1 = (cljs.core.truth_(selectOne_QMARK_)?cljs.core.conj.call(null,G__23679,(function (result){
return cljs.core.first.call(null,result);
})):G__23679);
var G__23679__$2 = (cljs.core.truth_(pretty_print)?cljs.core.conj.call(null,G__23679__$1,(function (){var select_var = cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query))))),(1));
return (function (result){
return cljs.core.mapv.call(null,(function (p1__23676_SHARP_){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([select_var,p1__23676_SHARP_]);
}),result);
});
})()):G__23679__$1);
if(cljs.core.truth_(order_by)){
return cljs.core.conj.call(null,G__23679__$2,(function (result){
return fluree.db.query.subject_crawl.common.order_results.call(null,result,order_by);
}));
} else {
return G__23679__$2;
}
})();
if(cljs.core.empty_QMARK_.call(null,fns)){
return cljs.core.identity;
} else {
return cljs.core.apply.call(null,cljs.core.comp,fns);
}
});
/**
 * Executes a simple subject crawl analytical query execution strategy.
 * 
 *   Strategy involves:
 *   (a) Get a list of subjects from first where clause
 *   (b) select all flakes for each subject
 *   (c) filter subjects based on subsequent where clause(s)
 *   (d) apply offset/limit for (c)
 *   (e) send result into :select graph crawl
 */
fluree.db.query.subject_crawl.core.simple_subject_crawl = (function fluree$db$query$subject_crawl$core$simple_subject_crawl(db,p__23680){
var map__23681 = p__23680;
var map__23681__$1 = cljs.core.__destructure_map.call(null,map__23681);
var parsed_query = map__23681__$1;
var vars = cljs.core.get.call(null,map__23681__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var where = cljs.core.get.call(null,map__23681__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__23681__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__23681__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var fuel = cljs.core.get.call(null,map__23681__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var rel_binding_QMARK_ = cljs.core.get.call(null,map__23681__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var error_ch = cljs.core.async.chan.call(null);
var f_where = cljs.core.first.call(null,where);
var rdf_type_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Keyword("rdf","type","rdf/type",1175423232),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where));
var filter_map = new cljs.core.Keyword(null,"s-filter","s-filter",-1111214020).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,where));
var cache = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentArrayMap.EMPTY);
var fuel_vol = cljs.core.volatile_BANG_.call(null,(0));
var select_spec = fluree.db.query.subject_crawl.core.retrieve_select_spec.call(null,db,parsed_query);
var finish_fn = fluree.db.query.subject_crawl.core.build_finishing_fn.call(null,parsed_query);
var opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"f-where","f-where",-958007776),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"select-spec","select-spec",55073283),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736),new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803),new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441),new cljs.core.Keyword(null,"cache","cache",-1237023054),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"filter-map","filter-map",-314788257)],[f_where,(3),select_spec,limit,offset,db,error_ch,cljs.core.not.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"root?","root?",-2045639518)], null))),rdf_type_QMARK_,cache,fuel,fuel_vol,parsed_query,finish_fn,vars,filter_map]);
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.subject_crawl.core.relationship_binding.call(null,opts);
} else {
if(rdf_type_QMARK_){
return fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl.call(null,opts);
} else {
return fluree.db.query.subject_crawl.subject.subj_crawl.call(null,opts);
}
}
});
