// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.subject');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('fluree.db.index');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.common');
goog.require('fluree.db.dbproto');
/**
 * Returns chan of subjects in chunks per index-leaf
 *   that can be pulled as needed based on the selection criteria of a where clause.
 */
fluree.db.query.subject_crawl.subject.subjects_chan = (function fluree$db$query$subject_crawl$subject$subjects_chan(p__22885,error_ch,vars,p__22886){
var map__22887 = p__22885;
var map__22887__$1 = cljs.core.__destructure_map.call(null,map__22887);
var db = map__22887__$1;
var conn = cljs.core.get.call(null,map__22887__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var novelty = cljs.core.get.call(null,map__22887__$1,new cljs.core.Keyword(null,"novelty","novelty",-1590246024));
var t = cljs.core.get.call(null,map__22887__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__22888 = p__22886;
var map__22888__$1 = cljs.core.__destructure_map.call(null,map__22888);
var _where_clause = map__22888__$1;
var p = cljs.core.get.call(null,map__22888__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.call(null,map__22888__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var idx = cljs.core.get.call(null,map__22888__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var o_STAR_ = (function (){var temp__5806__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if((temp__5806__auto__ == null)){
var temp__5804__auto__ = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(temp__5804__auto__)){
var variable = temp__5804__auto__;
return cljs.core.get.call(null,vars,variable);
} else {
return null;
}
} else {
var v = temp__5806__auto__;
return v;
}
})();
var vec__22889 = (function (){var G__22892 = idx;
var G__22892__$1 = (((G__22892 instanceof cljs.core.Keyword))?G__22892.fqn:null);
switch (G__22892__$1) {
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake.call(null,null,p,o_STAR_,null,null,(-2147483647)),fluree.db.flake.__GT_Flake.call(null,null,p,o_STAR_,null,null,(2147483647))], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake.call(null,null,p,null,null,null,(-2147483647)),fluree.db.flake.__GT_Flake.call(null,null,p,null,null,null,(2147483647))], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__22892__$1)].join('')));

}
})();
var fflake = cljs.core.nth.call(null,vec__22889,(0),null);
var lflake = cljs.core.nth.call(null,vec__22889,(1),null);
var filter_fn = (cljs.core.truth_((function (){var and__4251__auto__ = o_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),idx);
} else {
return and__4251__auto__;
}
})())?(function (p1__22883_SHARP_){
return cljs.core._EQ_.call(null,o_STAR_,fluree.db.flake.o.call(null,p1__22883_SHARP_));
}):(cljs.core.truth_(new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(o))?(function (){var f = cljs.core.get_in.call(null,o,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"function","function",-2127255473)], null));
return (function (p1__22884_SHARP_){
return f.call(null,fluree.db.flake.o.call(null,p1__22884_SHARP_));
});
})():null));
var idx_root = cljs.core.get.call(null,db,idx);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(idx_root);
var range_set = fluree.db.flake.sorted_set_by.call(null,cmp,fflake,lflake);
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_.call(null,node,range_set);
});
var query_xf = fluree.db.query.subject_crawl.common.where_subj_xf.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"start-test","start-test",-952983565),cljs.core._GT__EQ_,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),fflake,new cljs.core.Keyword(null,"end-test","end-test",481973727),cljs.core._LT__EQ_,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),lflake,new cljs.core.Keyword(null,"xf","xf",401902988),(cljs.core.truth_(filter_fn)?cljs.core.map.call(null,(function (flakes){
return cljs.core.filter.call(null,filter_fn,flakes);
})):null)], null));
var resolver = fluree.db.index.__GT_CachedTRangeResolver.call(null,conn,cljs.core.get.call(null,novelty,idx),t,t,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(conn));
var tree_chan = fluree.db.index.tree_chan.call(null,resolver,idx_root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
var return_chan = cljs.core.async.chan.call(null,(10),cljs.core.comp.call(null,cljs.core.map.call(null,fluree.db.flake.s),cljs.core.dedupe.call(null)));
var c__2768__auto___22962 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22931){
var state_val_22932 = (state_22931[(1)]);
if((state_val_22932 === (7))){
var inst_22927 = (state_22931[(2)]);
var state_22931__$1 = state_22931;
var statearr_22933_22963 = state_22931__$1;
(statearr_22933_22963[(2)] = inst_22927);

(statearr_22933_22963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (1))){
var state_22931__$1 = state_22931;
var statearr_22934_22964 = state_22931__$1;
(statearr_22934_22964[(2)] = null);

(statearr_22934_22964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (4))){
var inst_22895 = (state_22931[(7)]);
var inst_22895__$1 = (state_22931[(2)]);
var inst_22896 = (inst_22895__$1 == null);
var state_22931__$1 = (function (){var statearr_22935 = state_22931;
(statearr_22935[(7)] = inst_22895__$1);

return statearr_22935;
})();
if(cljs.core.truth_(inst_22896)){
var statearr_22936_22965 = state_22931__$1;
(statearr_22936_22965[(1)] = (5));

} else {
var statearr_22937_22966 = state_22931__$1;
(statearr_22937_22966[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (15))){
var state_22931__$1 = state_22931;
var statearr_22938_22967 = state_22931__$1;
(statearr_22938_22967[(2)] = false);

(statearr_22938_22967[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (13))){
var inst_22907 = (state_22931[(2)]);
var state_22931__$1 = state_22931;
if(cljs.core.truth_(inst_22907)){
var statearr_22939_22968 = state_22931__$1;
(statearr_22939_22968[(1)] = (14));

} else {
var statearr_22940_22969 = state_22931__$1;
(statearr_22940_22969[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (6))){
var inst_22895 = (state_22931[(7)]);
var inst_22900 = cljs.core.seq.call(null,inst_22895);
var inst_22901 = inst_22900;
var inst_22902 = (0);
var state_22931__$1 = (function (){var statearr_22941 = state_22931;
(statearr_22941[(8)] = inst_22901);

(statearr_22941[(9)] = inst_22902);

return statearr_22941;
})();
var statearr_22942_22970 = state_22931__$1;
(statearr_22942_22970[(2)] = null);

(statearr_22942_22970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (17))){
var state_22931__$1 = state_22931;
var statearr_22943_22971 = state_22931__$1;
(statearr_22943_22971[(2)] = null);

(statearr_22943_22971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (3))){
var inst_22929 = (state_22931[(2)]);
var state_22931__$1 = state_22931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22931__$1,inst_22929);
} else {
if((state_val_22932 === (12))){
var inst_22917 = (state_22931[(2)]);
var state_22931__$1 = state_22931;
var statearr_22944_22972 = state_22931__$1;
(statearr_22944_22972[(2)] = inst_22917);

(statearr_22944_22972[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (2))){
var state_22931__$1 = state_22931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22931__$1,(4),tree_chan);
} else {
if((state_val_22932 === (19))){
var inst_22925 = (state_22931[(2)]);
var state_22931__$1 = state_22931;
var statearr_22945_22973 = state_22931__$1;
(statearr_22945_22973[(2)] = inst_22925);

(statearr_22945_22973[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (11))){
var state_22931__$1 = state_22931;
var statearr_22946_22974 = state_22931__$1;
(statearr_22946_22974[(2)] = true);

(statearr_22946_22974[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (9))){
var inst_22919 = (state_22931[(2)]);
var state_22931__$1 = state_22931;
if(cljs.core.truth_(inst_22919)){
var statearr_22947_22975 = state_22931__$1;
(statearr_22947_22975[(1)] = (17));

} else {
var statearr_22948_22976 = state_22931__$1;
(statearr_22948_22976[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (5))){
var inst_22898 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_22931__$1 = state_22931;
var statearr_22949_22977 = state_22931__$1;
(statearr_22949_22977[(2)] = inst_22898);

(statearr_22949_22977[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (14))){
var inst_22901 = (state_22931[(8)]);
var inst_22902 = (state_22931[(9)]);
var inst_22909 = cljs.core.next.call(null,inst_22901);
var inst_22910 = (inst_22902 + (1));
var inst_22901__$1 = inst_22909;
var inst_22902__$1 = inst_22910;
var state_22931__$1 = (function (){var statearr_22950 = state_22931;
(statearr_22950[(8)] = inst_22901__$1);

(statearr_22950[(9)] = inst_22902__$1);

return statearr_22950;
})();
var statearr_22951_22978 = state_22931__$1;
(statearr_22951_22978[(2)] = null);

(statearr_22951_22978[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (16))){
var inst_22914 = (state_22931[(2)]);
var state_22931__$1 = state_22931;
var statearr_22952_22979 = state_22931__$1;
(statearr_22952_22979[(2)] = inst_22914);

(statearr_22952_22979[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (10))){
var inst_22901 = (state_22931[(8)]);
var inst_22905 = cljs.core.first.call(null,inst_22901);
var state_22931__$1 = state_22931;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22931__$1,(13),return_chan,inst_22905);
} else {
if((state_val_22932 === (18))){
var inst_22923 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_22931__$1 = state_22931;
var statearr_22953_22980 = state_22931__$1;
(statearr_22953_22980[(2)] = inst_22923);

(statearr_22953_22980[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22932 === (8))){
var inst_22901 = (state_22931[(8)]);
var state_22931__$1 = state_22931;
if(cljs.core.truth_(inst_22901)){
var statearr_22954_22981 = state_22931__$1;
(statearr_22954_22981[(1)] = (10));

} else {
var statearr_22955_22982 = state_22931__$1;
(statearr_22955_22982[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0 = (function (){
var statearr_22956 = [null,null,null,null,null,null,null,null,null,null];
(statearr_22956[(0)] = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__);

(statearr_22956[(1)] = (1));

return statearr_22956;
});
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1 = (function (state_22931){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22957){var ex__2749__auto__ = e22957;
var statearr_22958_22983 = state_22931;
(statearr_22958_22983[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22931[(4)]))){
var statearr_22959_22984 = state_22931;
(statearr_22959_22984[(1)] = cljs.core.first.call(null,(state_22931[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22985 = state_22931;
state_22931 = G__22985;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__ = function(state_22931){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1.call(this,state_22931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22960 = f__2769__auto__.call(null);
(statearr_22960[(6)] = c__2768__auto___22962);

return statearr_22960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_chan;
});
fluree.db.query.subject_crawl.subject.flakes_xf = (function fluree$db$query$subject_crawl$subject$flakes_xf(p__22986){
var map__22987 = p__22986;
var map__22987__$1 = cljs.core.__destructure_map.call(null,map__22987);
var _opts = map__22987__$1;
var db = cljs.core.get.call(null,map__22987__$1,new cljs.core.Keyword(null,"db","db",993250759));
var fuel_vol = cljs.core.get.call(null,map__22987__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.call(null,map__22987__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var error_ch = cljs.core.get.call(null,map__22987__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var vars = cljs.core.get.call(null,map__22987__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var filter_map = cljs.core.get.call(null,map__22987__$1,new cljs.core.Keyword(null,"filter-map","filter-map",-314788257));
var permissioned_QMARK_ = cljs.core.get.call(null,map__22987__$1,new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803));
var permissions = (cljs.core.truth_(permissioned_QMARK_)?fluree.db.query.subject_crawl.common.subj_perm_filter_fn.call(null,db):null);
return (function (sid,port){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23032){
var state_val_23033 = (state_23032[(1)]);
if((state_val_23033 === (7))){
var inst_23003 = (state_23032[(7)]);
var inst_23005 = fluree.db.query.subject_crawl.common.filter_subject.call(null,vars,filter_map,inst_23003);
var state_23032__$1 = state_23032;
var statearr_23034_23070 = state_23032__$1;
(statearr_23034_23070[(2)] = inst_23005);

(statearr_23034_23070[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (1))){
var state_23032__$1 = state_23032;
var statearr_23035_23071 = state_23032__$1;
(statearr_23035_23071[(2)] = null);

(statearr_23035_23071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (4))){
var inst_22988 = (state_23032[(2)]);
var inst_22989 = cljs.core.async.put_BANG_.call(null,error_ch,inst_22988);
var inst_22990 = cljs.core.async.close_BANG_.call(null,port);
var state_23032__$1 = (function (){var statearr_23036 = state_23032;
(statearr_23036[(8)] = inst_22990);

(statearr_23036[(9)] = inst_22989);

return statearr_23036;
})();
var statearr_23037_23072 = state_23032__$1;
(statearr_23037_23072[(2)] = null);

(statearr_23037_23072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (15))){
var inst_23020 = (state_23032[(10)]);
var inst_23020__$1 = (state_23032[(2)]);
var inst_23021 = cljs.core.seq.call(null,inst_23020__$1);
var state_23032__$1 = (function (){var statearr_23038 = state_23032;
(statearr_23038[(10)] = inst_23020__$1);

return statearr_23038;
})();
if(inst_23021){
var statearr_23039_23073 = state_23032__$1;
(statearr_23039_23073[(1)] = (17));

} else {
var statearr_23040_23074 = state_23032__$1;
(statearr_23040_23074[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (13))){
var inst_23013 = (state_23032[(11)]);
var state_23032__$1 = state_23032;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23032__$1,(16),inst_23013);
} else {
if((state_val_23033 === (6))){
var inst_23002 = (state_23032[(2)]);
var inst_23003 = fluree.db.util.async.throw_err.call(null,inst_23002);
var state_23032__$1 = (function (){var statearr_23041 = state_23032;
(statearr_23041[(7)] = inst_23003);

return statearr_23041;
})();
if(cljs.core.truth_(filter_map)){
var statearr_23042_23075 = state_23032__$1;
(statearr_23042_23075[(1)] = (7));

} else {
var statearr_23043_23076 = state_23032__$1;
(statearr_23043_23076[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (17))){
var inst_23020 = (state_23032[(10)]);
var inst_23023 = cljs.core.async.put_BANG_.call(null,port,inst_23020);
var state_23032__$1 = state_23032;
var statearr_23044_23077 = state_23032__$1;
(statearr_23044_23077[(2)] = inst_23023);

(statearr_23044_23077[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (3))){
var inst_23030 = (state_23032[(2)]);
var state_23032__$1 = state_23032;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23032__$1,inst_23030);
} else {
if((state_val_23033 === (12))){
var inst_23013 = (state_23032[(2)]);
var state_23032__$1 = (function (){var statearr_23045 = state_23032;
(statearr_23045[(11)] = inst_23013);

return statearr_23045;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_23046_23078 = state_23032__$1;
(statearr_23046_23078[(1)] = (13));

} else {
var statearr_23047_23079 = state_23032__$1;
(statearr_23047_23079[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (2))){
var _ = (function (){var statearr_23048 = state_23032;
(statearr_23048[(4)] = cljs.core.cons.call(null,(5),(state_23032[(4)])));

return statearr_23048;
})();
var inst_22997 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22998 = [sid];
var inst_22999 = (new cljs.core.PersistentVector(null,1,(5),inst_22997,inst_22998,null));
var inst_23000 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22999);
var state_23032__$1 = state_23032;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23032__$1,(6),inst_23000);
} else {
if((state_val_23033 === (19))){
var inst_23026 = (state_23032[(2)]);
var inst_23027 = cljs.core.async.close_BANG_.call(null,port);
var _ = (function (){var statearr_23049 = state_23032;
(statearr_23049[(4)] = cljs.core.rest.call(null,(state_23032[(4)])));

return statearr_23049;
})();
var state_23032__$1 = (function (){var statearr_23050 = state_23032;
(statearr_23050[(12)] = inst_23026);

return statearr_23050;
})();
var statearr_23051_23080 = state_23032__$1;
(statearr_23051_23080[(2)] = inst_23027);

(statearr_23051_23080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (11))){
var inst_23008 = (state_23032[(13)]);
var state_23032__$1 = state_23032;
var statearr_23053_23081 = state_23032__$1;
(statearr_23053_23081[(2)] = inst_23008);

(statearr_23053_23081[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (9))){
var inst_23008 = (state_23032[(2)]);
var state_23032__$1 = (function (){var statearr_23054 = state_23032;
(statearr_23054[(13)] = inst_23008);

return statearr_23054;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_23055_23082 = state_23032__$1;
(statearr_23055_23082[(1)] = (10));

} else {
var statearr_23056_23083 = state_23032__$1;
(statearr_23056_23083[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (5))){
var _ = (function (){var statearr_23057 = state_23032;
(statearr_23057[(4)] = cljs.core.rest.call(null,(state_23032[(4)])));

return statearr_23057;
})();
var state_23032__$1 = state_23032;
var ex23052 = (state_23032__$1[(2)]);
var statearr_23058_23084 = state_23032__$1;
(statearr_23058_23084[(5)] = ex23052);


var statearr_23059_23085 = state_23032__$1;
(statearr_23059_23085[(1)] = (4));

(statearr_23059_23085[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (14))){
var inst_23013 = (state_23032[(11)]);
var state_23032__$1 = state_23032;
var statearr_23060_23086 = state_23032__$1;
(statearr_23060_23086[(2)] = inst_23013);

(statearr_23060_23086[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (16))){
var inst_23016 = (state_23032[(2)]);
var inst_23017 = fluree.db.util.async.throw_err.call(null,inst_23016);
var state_23032__$1 = state_23032;
var statearr_23061_23087 = state_23032__$1;
(statearr_23061_23087[(2)] = inst_23017);

(statearr_23061_23087[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (10))){
var inst_23008 = (state_23032[(13)]);
var inst_23010 = permissions.call(null,inst_23008);
var state_23032__$1 = state_23032;
var statearr_23062_23088 = state_23032__$1;
(statearr_23062_23088[(2)] = inst_23010);

(statearr_23062_23088[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (18))){
var state_23032__$1 = state_23032;
var statearr_23063_23089 = state_23032__$1;
(statearr_23063_23089[(2)] = null);

(statearr_23063_23089[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23033 === (8))){
var inst_23003 = (state_23032[(7)]);
var state_23032__$1 = state_23032;
var statearr_23064_23090 = state_23032__$1;
(statearr_23064_23090[(2)] = inst_23003);

(statearr_23064_23090[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0 = (function (){
var statearr_23065 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23065[(0)] = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__);

(statearr_23065[(1)] = (1));

return statearr_23065;
});
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1 = (function (state_23032){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23032);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23066){var ex__2749__auto__ = e23066;
var statearr_23067_23091 = state_23032;
(statearr_23067_23091[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23032[(4)]))){
var statearr_23068_23092 = state_23032;
(statearr_23068_23092[(1)] = cljs.core.first.call(null,(state_23032[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23093 = state_23032;
state_23032 = G__23093;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__ = function(state_23032){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1.call(this,state_23032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23069 = f__2769__auto__.call(null);
(statearr_23069[(6)] = c__2768__auto__);

return statearr_23069;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
/**
 * For queries that specify _id as the predicate, we will have a
 *   single subject as a value.
 */
fluree.db.query.subject_crawl.subject.subjects_id_chan = (function fluree$db$query$subject_crawl$subject$subjects_id_chan(db,error_ch,vars,p__23094){
var map__23095 = p__23094;
var map__23095__$1 = cljs.core.__destructure_map.call(null,map__23095);
var f_where = map__23095__$1;
var o = cljs.core.get.call(null,map__23095__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var return_ch = cljs.core.async.chan.call(null);
var _id_val = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.call(null,vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
}
})();
if(cljs.core.truth_(_id_val)){
} else {
throw cljs.core.ex_info.call(null,["When using _id as the predicate, a value must be provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f_where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var c__2768__auto___23132 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23115){
var state_val_23116 = (state_23115[(1)]);
if((state_val_23116 === (7))){
var inst_23103 = (state_23115[(7)]);
var inst_23106 = cljs.core.async.put_BANG_.call(null,error_ch,inst_23103);
var state_23115__$1 = state_23115;
var statearr_23117_23133 = state_23115__$1;
(statearr_23117_23133[(2)] = inst_23106);

(statearr_23117_23133[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23116 === (1))){
var inst_23096 = typeof _id_val === 'number';
var state_23115__$1 = state_23115;
if(cljs.core.truth_(inst_23096)){
var statearr_23118_23134 = state_23115__$1;
(statearr_23118_23134[(1)] = (2));

} else {
var statearr_23119_23135 = state_23115__$1;
(statearr_23119_23135[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23116 === (4))){
var inst_23112 = (state_23115[(2)]);
var inst_23113 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_23115__$1 = (function (){var statearr_23120 = state_23115;
(statearr_23120[(8)] = inst_23112);

return statearr_23120;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23115__$1,inst_23113);
} else {
if((state_val_23116 === (6))){
var inst_23103 = (state_23115[(7)]);
var inst_23103__$1 = (state_23115[(2)]);
var inst_23104 = fluree.db.util.core.exception_QMARK_.call(null,inst_23103__$1);
var state_23115__$1 = (function (){var statearr_23121 = state_23115;
(statearr_23121[(7)] = inst_23103__$1);

return statearr_23121;
})();
if(inst_23104){
var statearr_23122_23136 = state_23115__$1;
(statearr_23122_23136[(1)] = (7));

} else {
var statearr_23123_23137 = state_23115__$1;
(statearr_23123_23137[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23116 === (3))){
var inst_23101 = fluree.db.dbproto._subid.call(null,db,_id_val);
var state_23115__$1 = state_23115;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23115__$1,(6),inst_23101);
} else {
if((state_val_23116 === (2))){
var state_23115__$1 = state_23115;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23115__$1,(5),return_ch,_id_val);
} else {
if((state_val_23116 === (9))){
var inst_23110 = (state_23115[(2)]);
var state_23115__$1 = state_23115;
var statearr_23124_23138 = state_23115__$1;
(statearr_23124_23138[(2)] = inst_23110);

(statearr_23124_23138[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23116 === (5))){
var inst_23099 = (state_23115[(2)]);
var state_23115__$1 = state_23115;
var statearr_23125_23139 = state_23115__$1;
(statearr_23125_23139[(2)] = inst_23099);

(statearr_23125_23139[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23116 === (8))){
var inst_23103 = (state_23115[(7)]);
var inst_23108 = cljs.core.async.put_BANG_.call(null,return_ch,inst_23103);
var state_23115__$1 = state_23115;
var statearr_23126_23140 = state_23115__$1;
(statearr_23126_23140[(2)] = inst_23108);

(statearr_23126_23140[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0 = (function (){
var statearr_23127 = [null,null,null,null,null,null,null,null,null];
(statearr_23127[(0)] = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__);

(statearr_23127[(1)] = (1));

return statearr_23127;
});
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1 = (function (state_23115){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23115);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23128){var ex__2749__auto__ = e23128;
var statearr_23129_23141 = state_23115;
(statearr_23129_23141[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23115[(4)]))){
var statearr_23130_23142 = state_23115;
(statearr_23130_23142[(1)] = cljs.core.first.call(null,(state_23115[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23143 = state_23115;
state_23115 = G__23143;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__ = function(state_23115){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1.call(this,state_23115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23131 = f__2769__auto__.call(null);
(statearr_23131[(6)] = c__2768__auto___23132);

return statearr_23131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_ch;
});
fluree.db.query.subject_crawl.subject.subj_crawl = (function fluree$db$query$subject_crawl$subject$subj_crawl(p__23144){
var map__23145 = p__23144;
var map__23145__$1 = cljs.core.__destructure_map.call(null,map__23145);
var opts = map__23145__$1;
var db = cljs.core.get.call(null,map__23145__$1,new cljs.core.Keyword(null,"db","db",993250759));
var error_ch = cljs.core.get.call(null,map__23145__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var f_where = cljs.core.get.call(null,map__23145__$1,new cljs.core.Keyword(null,"f-where","f-where",-958007776));
var limit = cljs.core.get.call(null,map__23145__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__23145__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var parallelism = cljs.core.get.call(null,map__23145__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333));
var vars = cljs.core.get.call(null,map__23145__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var finish_fn = cljs.core.get.call(null,map__23145__$1,new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23212){
var state_val_23213 = (state_23212[(1)]);
if((state_val_23213 === (7))){
var inst_23157 = fluree.db.query.subject_crawl.subject.subjects_chan.call(null,db,error_ch,vars,f_where);
var state_23212__$1 = state_23212;
var statearr_23214_23251 = state_23212__$1;
(statearr_23214_23251[(2)] = inst_23157);

(statearr_23214_23251[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (20))){
var inst_23201 = (state_23212[(2)]);
var state_23212__$1 = state_23212;
var statearr_23215_23252 = state_23212__$1;
(statearr_23215_23252[(2)] = inst_23201);

(statearr_23215_23252[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (1))){
var state_23212__$1 = state_23212;
var statearr_23216_23253 = state_23212__$1;
(statearr_23216_23253[(2)] = null);

(statearr_23216_23253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (4))){
var inst_23146 = (state_23212[(2)]);
var state_23212__$1 = state_23212;
var statearr_23217_23254 = state_23212__$1;
(statearr_23217_23254[(2)] = inst_23146);

(statearr_23217_23254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (15))){
var inst_23159 = (state_23212[(7)]);
var inst_23164 = (state_23212[(8)]);
var inst_23165 = (state_23212[(9)]);
var inst_23170 = (state_23212[(10)]);
var inst_23191 = cljs.core.async.close_BANG_.call(null,inst_23159);
var inst_23192 = cljs.core.async.close_BANG_.call(null,inst_23164);
var inst_23193 = cljs.core.async.close_BANG_.call(null,inst_23165);
var inst_23194 = finish_fn.call(null,inst_23170);
var state_23212__$1 = (function (){var statearr_23218 = state_23212;
(statearr_23218[(11)] = inst_23192);

(statearr_23218[(12)] = inst_23191);

(statearr_23218[(13)] = inst_23193);

return statearr_23218;
})();
var statearr_23219_23255 = state_23212__$1;
(statearr_23219_23255[(2)] = inst_23194);

(statearr_23219_23255[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (13))){
var inst_23180 = (state_23212[(14)]);
var inst_23189 = (inst_23180 == null);
var state_23212__$1 = state_23212;
if(cljs.core.truth_(inst_23189)){
var statearr_23220_23256 = state_23212__$1;
(statearr_23220_23256[(1)] = (15));

} else {
var statearr_23221_23257 = state_23212__$1;
(statearr_23221_23257[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (6))){
var inst_23155 = fluree.db.query.subject_crawl.subject.subjects_id_chan.call(null,db,error_ch,vars,f_where);
var state_23212__$1 = state_23212;
var statearr_23222_23258 = state_23212__$1;
(statearr_23222_23258[(2)] = inst_23155);

(statearr_23222_23258[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (17))){
var inst_23203 = (state_23212[(2)]);
var state_23212__$1 = state_23212;
var statearr_23223_23259 = state_23212__$1;
(statearr_23223_23259[(2)] = inst_23203);

(statearr_23223_23259[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (3))){
var inst_23210 = (state_23212[(2)]);
var state_23212__$1 = state_23212;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23212__$1,inst_23210);
} else {
if((state_val_23213 === (12))){
var inst_23159 = (state_23212[(7)]);
var inst_23180 = (state_23212[(14)]);
var inst_23164 = (state_23212[(8)]);
var inst_23165 = (state_23212[(9)]);
var inst_23184 = cljs.core.async.close_BANG_.call(null,inst_23159);
var inst_23185 = cljs.core.async.close_BANG_.call(null,inst_23164);
var inst_23186 = cljs.core.async.close_BANG_.call(null,inst_23165);
var inst_23187 = (function(){throw inst_23180})();
var state_23212__$1 = (function (){var statearr_23224 = state_23212;
(statearr_23224[(15)] = inst_23186);

(statearr_23224[(16)] = inst_23185);

(statearr_23224[(17)] = inst_23184);

return statearr_23224;
})();
var statearr_23225_23260 = state_23212__$1;
(statearr_23225_23260[(2)] = inst_23187);

(statearr_23225_23260[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (2))){
var _ = (function (){var statearr_23226 = state_23212;
(statearr_23226[(4)] = cljs.core.cons.call(null,(5),(state_23212[(4)])));

return statearr_23226;
})();
var inst_23152 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where);
var inst_23153 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23152);
var state_23212__$1 = state_23212;
if(inst_23153){
var statearr_23227_23261 = state_23212__$1;
(statearr_23227_23261[(1)] = (6));

} else {
var statearr_23228_23262 = state_23212__$1;
(statearr_23228_23262[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (19))){
var state_23212__$1 = state_23212;
var statearr_23229_23263 = state_23212__$1;
(statearr_23229_23263[(2)] = null);

(statearr_23229_23263[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (11))){
var inst_23179 = (state_23212[(2)]);
var inst_23180 = cljs.core.nth.call(null,inst_23179,(0),null);
var inst_23181 = cljs.core.nth.call(null,inst_23179,(1),null);
var inst_23182 = cljs.core._EQ_.call(null,inst_23181,error_ch);
var state_23212__$1 = (function (){var statearr_23231 = state_23212;
(statearr_23231[(14)] = inst_23180);

return statearr_23231;
})();
if(inst_23182){
var statearr_23232_23264 = state_23212__$1;
(statearr_23232_23264[(1)] = (12));

} else {
var statearr_23233_23265 = state_23212__$1;
(statearr_23233_23265[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (9))){
var inst_23165 = (state_23212[(9)]);
var inst_23175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23176 = [error_ch,inst_23165];
var inst_23177 = (new cljs.core.PersistentVector(null,2,(5),inst_23175,inst_23176,null));
var state_23212__$1 = state_23212;
return cljs.core.async.ioc_alts_BANG_.call(null,state_23212__$1,(11),inst_23177);
} else {
if((state_val_23213 === (5))){
var _ = (function (){var statearr_23234 = state_23212;
(statearr_23234[(4)] = cljs.core.rest.call(null,(state_23212[(4)])));

return statearr_23234;
})();
var state_23212__$1 = state_23212;
var ex23230 = (state_23212__$1[(2)]);
var statearr_23235_23266 = state_23212__$1;
(statearr_23235_23266[(5)] = ex23230);


if((ex23230 instanceof Error)){
var statearr_23236_23267 = state_23212__$1;
(statearr_23236_23267[(1)] = (4));

(statearr_23236_23267[(5)] = null);

} else {
throw ex23230;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (14))){
var inst_23205 = (state_23212[(2)]);
var state_23212__$1 = state_23212;
var statearr_23237_23268 = state_23212__$1;
(statearr_23237_23268[(2)] = inst_23205);

(statearr_23237_23268[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (16))){
var state_23212__$1 = state_23212;
var statearr_23238_23269 = state_23212__$1;
(statearr_23238_23269[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (10))){
var inst_23207 = (state_23212[(2)]);
var _ = (function (){var statearr_23240 = state_23212;
(statearr_23240[(4)] = cljs.core.rest.call(null,(state_23212[(4)])));

return statearr_23240;
})();
var state_23212__$1 = state_23212;
var statearr_23241_23270 = state_23212__$1;
(statearr_23241_23270[(2)] = inst_23207);

(statearr_23241_23270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (18))){
var inst_23180 = (state_23212[(14)]);
var inst_23170 = (state_23212[(10)]);
var inst_23197 = cljs.core.conj.call(null,inst_23170,inst_23180);
var inst_23170__$1 = inst_23197;
var state_23212__$1 = (function (){var statearr_23242 = state_23212;
(statearr_23242[(10)] = inst_23170__$1);

return statearr_23242;
})();
var statearr_23243_23271 = state_23212__$1;
(statearr_23243_23271[(2)] = null);

(statearr_23243_23271[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23213 === (8))){
var inst_23159 = (state_23212[(7)]);
var inst_23164 = (state_23212[(8)]);
var inst_23165 = (state_23212[(9)]);
var inst_23159__$1 = (state_23212[(2)]);
var inst_23160 = fluree.db.query.subject_crawl.subject.flakes_xf.call(null,opts);
var inst_23161 = cljs.core.drop.call(null,offset);
var inst_23162 = cljs.core.take.call(null,limit);
var inst_23163 = cljs.core.comp.call(null,inst_23161,inst_23162);
var inst_23164__$1 = cljs.core.async.chan.call(null,(32),inst_23163);
var inst_23165__$1 = cljs.core.async.chan.call(null);
var inst_23166 = cljs.core.async.pipeline_async.call(null,parallelism,inst_23164__$1,inst_23160,inst_23159__$1);
var inst_23167 = fluree.db.query.subject_crawl.common.result_af.call(null,opts);
var inst_23168 = cljs.core.async.pipeline_async.call(null,parallelism,inst_23165__$1,inst_23167,inst_23164__$1);
var inst_23169 = cljs.core.PersistentVector.EMPTY;
var inst_23170 = inst_23169;
var state_23212__$1 = (function (){var statearr_23244 = state_23212;
(statearr_23244[(7)] = inst_23159__$1);

(statearr_23244[(8)] = inst_23164__$1);

(statearr_23244[(18)] = inst_23168);

(statearr_23244[(19)] = inst_23166);

(statearr_23244[(9)] = inst_23165__$1);

(statearr_23244[(10)] = inst_23170);

return statearr_23244;
})();
var statearr_23245_23272 = state_23212__$1;
(statearr_23245_23272[(2)] = null);

(statearr_23245_23272[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0 = (function (){
var statearr_23246 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23246[(0)] = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__);

(statearr_23246[(1)] = (1));

return statearr_23246;
});
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1 = (function (state_23212){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23212);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23247){var ex__2749__auto__ = e23247;
var statearr_23248_23273 = state_23212;
(statearr_23248_23273[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23212[(4)]))){
var statearr_23249_23274 = state_23212;
(statearr_23249_23274[(1)] = cljs.core.first.call(null,(state_23212[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23275 = state_23212;
state_23212 = G__23275;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__ = function(state_23212){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1.call(this,state_23212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23250 = f__2769__auto__.call(null);
(statearr_23250[(6)] = c__2768__auto__);

return statearr_23250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
