// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k26316,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__26320 = k26316;
var G__26320__$1 = (((G__26320 instanceof cljs.core.Keyword))?G__26320.fqn:null);
switch (G__26320__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k26316,else__4505__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__26321){
var vec__26322 = p__26321;
var k__4526__auto__ = cljs.core.nth.call(null,vec__26322,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__26322,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26315){
var self__ = this;
var G__26315__$1 = this;
return (new cljs.core.RecordIter((0),G__26315__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26317,other26318){
var self__ = this;
var this26317__$1 = this;
return (((!((other26318 == null)))) && ((((this26317__$1.constructor === other26318.constructor)) && (((cljs.core._EQ_.call(null,this26317__$1.conn,other26318.conn)) && (((cljs.core._EQ_.call(null,this26317__$1.network,other26318.network)) && (((cljs.core._EQ_.call(null,this26317__$1.ledger_id,other26318.ledger_id)) && (((cljs.core._EQ_.call(null,this26317__$1.db_name,other26318.db_name)) && (((cljs.core._EQ_.call(null,this26317__$1.update_chan,other26318.update_chan)) && (((cljs.core._EQ_.call(null,this26317__$1.transact_chan,other26318.transact_chan)) && (((cljs.core._EQ_.call(null,this26317__$1.state,other26318.state)) && (((cljs.core._EQ_.call(null,this26317__$1.schema_cache,other26318.schema_cache)) && (((cljs.core._EQ_.call(null,this26317__$1.blank_db,other26318.blank_db)) && (((cljs.core._EQ_.call(null,this26317__$1.close,other26318.close)) && (((cljs.core._EQ_.call(null,this26317__$1.id,other26318.id)) && (cljs.core._EQ_.call(null,this26317__$1.__extmap,other26318.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k26316){
var self__ = this;
var this__4509__auto____$1 = this;
var G__26325 = k26316;
var G__26325__$1 = (((G__26325 instanceof cljs.core.Keyword))?G__26325.fqn:null);
switch (G__26325__$1) {
case "conn":
case "network":
case "ledger-id":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k26316);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__26315){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__26326 = cljs.core.keyword_identical_QMARK_;
var expr__26327 = k__4511__auto__;
if(cljs.core.truth_(pred__26326.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__26327))){
return (new fluree.db.session.DbSession(G__26315,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26326.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__26327))){
return (new fluree.db.session.DbSession(self__.conn,G__26315,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26326.call(null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),expr__26327))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__26315,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26326.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__26327))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,G__26315,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26326.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__26327))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,G__26315,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26326.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__26327))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,G__26315,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26326.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__26327))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,G__26315,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26326.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__26327))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__26315,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26326.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__26327))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__26315,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26326.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__26327))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__26315,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26326.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__26327))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__26315,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__26315),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__26315){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__26315,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__26319){
var extmap__4542__auto__ = (function (){var G__26329 = cljs.core.dissoc.call(null,G__26319,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__26319)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__26329);
} else {
return G__26329;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__26319),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__26319),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__26319),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__26319),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__26319),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__26319),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__26319),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__26319),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__26319),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__26319),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__26319),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__26332 = session;
var map__26332__$1 = cljs.core.__destructure_map.call(null,map__26332);
var network = cljs.core.get.call(null,map__26332__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__26332__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,ledger_id){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,ledger_id){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___26483 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26435){
var state_val_26436 = (state_26435[(1)]);
if((state_val_26436 === (7))){
var inst_26353 = (state_26435[(7)]);
var inst_26358 = cljs.core.empty_QMARK_.call(null,inst_26353);
var state_26435__$1 = state_26435;
if(inst_26358){
var statearr_26437_26484 = state_26435__$1;
(statearr_26437_26484[(1)] = (10));

} else {
var statearr_26438_26485 = state_26435__$1;
(statearr_26438_26485[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (20))){
var inst_26346 = (state_26435[(8)]);
var inst_26384 = (state_26435[(9)]);
var inst_26344 = (state_26435[(10)]);
var inst_26345 = (state_26435[(11)]);
var inst_26389 = fluree.db.storage.core.read_block.call(null,inst_26344,inst_26345,inst_26346,inst_26384);
var state_26435__$1 = state_26435;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26435__$1,(22),inst_26389);
} else {
if((state_val_26436 === (27))){
var inst_26422 = (state_26435[(12)]);
var inst_26424 = (state_26435[(2)]);
var inst_26425 = fluree.db.util.async.throw_err.call(null,inst_26424);
var state_26435__$1 = (function (){var statearr_26439 = state_26435;
(statearr_26439[(13)] = inst_26425);

return statearr_26439;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26435__$1,(28),inst_26422);
} else {
if((state_val_26436 === (1))){
var state_26435__$1 = state_26435;
var statearr_26440_26486 = state_26435__$1;
(statearr_26440_26486[(2)] = null);

(statearr_26440_26486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (24))){
var inst_26346 = (state_26435[(8)]);
var inst_26384 = (state_26435[(9)]);
var inst_26345 = (state_26435[(11)]);
var inst_26406 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26384)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26345),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26346),"."].join('');
var inst_26407 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26408 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26409 = cljs.core.PersistentHashMap.fromArrays(inst_26407,inst_26408);
var inst_26410 = cljs.core.ex_info.call(null,inst_26406,inst_26409);
var inst_26411 = (function(){throw inst_26410})();
var state_26435__$1 = state_26435;
var statearr_26441_26487 = state_26435__$1;
(statearr_26441_26487[(2)] = inst_26411);

(statearr_26441_26487[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (4))){
var inst_26333 = (state_26435[(2)]);
var inst_26334 = cljs.core.async.put_BANG_.call(null,pc,inst_26333);
var state_26435__$1 = state_26435;
var statearr_26442_26488 = state_26435__$1;
(statearr_26442_26488[(2)] = inst_26334);

(statearr_26442_26488[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (15))){
var state_26435__$1 = state_26435;
var statearr_26443_26489 = state_26435__$1;
(statearr_26443_26489[(2)] = null);

(statearr_26443_26489[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (21))){
var inst_26415 = (state_26435[(2)]);
var state_26435__$1 = state_26435;
var statearr_26444_26490 = state_26435__$1;
(statearr_26444_26490[(2)] = inst_26415);

(statearr_26444_26490[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (13))){
var inst_26378 = (state_26435[(14)]);
var inst_26353 = (state_26435[(7)]);
var inst_26377 = (state_26435[(2)]);
var inst_26378__$1 = fluree.db.util.async.throw_err.call(null,inst_26377);
var inst_26379 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_26353);
var state_26435__$1 = (function (){var statearr_26445 = state_26435;
(statearr_26445[(15)] = inst_26379);

(statearr_26445[(14)] = inst_26378__$1);

return statearr_26445;
})();
if(cljs.core.truth_(inst_26378__$1)){
var statearr_26446_26491 = state_26435__$1;
(statearr_26446_26491[(1)] = (14));

} else {
var statearr_26447_26492 = state_26435__$1;
(statearr_26447_26492[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (22))){
var inst_26392 = (state_26435[(16)]);
var inst_26391 = (state_26435[(2)]);
var inst_26392__$1 = fluree.db.util.async.throw_err.call(null,inst_26391);
var state_26435__$1 = (function (){var statearr_26448 = state_26435;
(statearr_26448[(16)] = inst_26392__$1);

return statearr_26448;
})();
if(cljs.core.truth_(inst_26392__$1)){
var statearr_26449_26493 = state_26435__$1;
(statearr_26449_26493[(1)] = (23));

} else {
var statearr_26450_26494 = state_26435__$1;
(statearr_26450_26494[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (6))){
var inst_26353 = (state_26435[(7)]);
var inst_26352 = (state_26435[(2)]);
var inst_26353__$1 = fluree.db.util.async.throw_err.call(null,inst_26352);
var inst_26354 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_26353__$1);
var inst_26355 = cljs.core.keyword.call(null,inst_26354);
var inst_26356 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),inst_26355);
var state_26435__$1 = (function (){var statearr_26451 = state_26435;
(statearr_26451[(7)] = inst_26353__$1);

return statearr_26451;
})();
if(inst_26356){
var statearr_26452_26495 = state_26435__$1;
(statearr_26452_26495[(1)] = (7));

} else {
var statearr_26453_26496 = state_26435__$1;
(statearr_26453_26496[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (28))){
var inst_26420 = (state_26435[(17)]);
var inst_26425 = (state_26435[(13)]);
var inst_26427 = (state_26435[(2)]);
var inst_26428 = fluree.db.util.async.throw_err.call(null,inst_26427);
var inst_26429 = cljs.core.assoc.call(null,inst_26420,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26425,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26428);
var inst_26430 = cljs.core.async.put_BANG_.call(null,pc,inst_26429);
var _ = (function (){var statearr_26454 = state_26435;
(statearr_26454[(4)] = cljs.core.rest.call(null,(state_26435[(4)])));

return statearr_26454;
})();
var state_26435__$1 = state_26435;
var statearr_26455_26497 = state_26435__$1;
(statearr_26455_26497[(2)] = inst_26430);

(statearr_26455_26497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (25))){
var inst_26413 = (state_26435[(2)]);
var state_26435__$1 = state_26435;
var statearr_26456_26498 = state_26435__$1;
(statearr_26456_26498[(2)] = inst_26413);

(statearr_26456_26498[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (17))){
var inst_26379 = (state_26435[(15)]);
var inst_26384 = (state_26435[(9)]);
var inst_26386 = (inst_26384 > inst_26379);
var state_26435__$1 = state_26435;
if(cljs.core.truth_(inst_26386)){
var statearr_26457_26499 = state_26435__$1;
(statearr_26457_26499[(1)] = (19));

} else {
var statearr_26458_26500 = state_26435__$1;
(statearr_26458_26500[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (3))){
var inst_26433 = (state_26435[(2)]);
var state_26435__$1 = state_26435;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26435__$1,inst_26433);
} else {
if((state_val_26436 === (12))){
var inst_26365 = (state_26435[(2)]);
var inst_26366 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26367 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_26368 = cljs.core.PersistentHashMap.fromArrays(inst_26366,inst_26367);
var inst_26369 = cljs.core.ex_info.call(null,inst_26365,inst_26368);
var inst_26370 = (function(){throw inst_26369})();
var state_26435__$1 = state_26435;
var statearr_26459_26501 = state_26435__$1;
(statearr_26459_26501[(2)] = inst_26370);

(statearr_26459_26501[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (2))){
var inst_26346 = (state_26435[(8)]);
var inst_26344 = (state_26435[(10)]);
var inst_26345 = (state_26435[(11)]);
var _ = (function (){var statearr_26460 = state_26435;
(statearr_26460[(4)] = cljs.core.cons.call(null,(5),(state_26435[(4)])));

return statearr_26460;
})();
var inst_26341 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_26342 = session;
var inst_26343 = cljs.core.__destructure_map.call(null,inst_26342);
var inst_26344__$1 = cljs.core.get.call(null,inst_26343,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_26345__$1 = cljs.core.get.call(null,inst_26343,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_26346__$1 = cljs.core.get.call(null,inst_26343,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_26347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26348 = [inst_26345__$1,inst_26346__$1];
var inst_26349 = (new cljs.core.PersistentVector(null,2,(5),inst_26347,inst_26348,null));
var inst_26350 = fluree.db.operations.ledger_info_async.call(null,inst_26344__$1,inst_26349);
var state_26435__$1 = (function (){var statearr_26461 = state_26435;
(statearr_26461[(8)] = inst_26346__$1);

(statearr_26461[(10)] = inst_26344__$1);

(statearr_26461[(11)] = inst_26345__$1);

(statearr_26461[(18)] = inst_26341);

return statearr_26461;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26435__$1,(6),inst_26350);
} else {
if((state_val_26436 === (23))){
var inst_26383 = (state_26435[(19)]);
var inst_26392 = (state_26435[(16)]);
var inst_26395 = cljs.core.__destructure_map.call(null,inst_26392);
var inst_26396 = cljs.core.get.call(null,inst_26395,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_26397 = cljs.core.get.call(null,inst_26395,new cljs.core.Keyword(null,"block","block",664686210));
var inst_26398 = cljs.core.get.call(null,inst_26395,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_26399 = fluree.db.dbproto._with.call(null,inst_26383,inst_26397,inst_26396);
var state_26435__$1 = (function (){var statearr_26462 = state_26435;
(statearr_26462[(20)] = inst_26398);

return statearr_26462;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26435__$1,(26),inst_26399);
} else {
if((state_val_26436 === (19))){
var inst_26383 = (state_26435[(19)]);
var state_26435__$1 = state_26435;
var statearr_26463_26502 = state_26435__$1;
(statearr_26463_26502[(2)] = inst_26383);

(statearr_26463_26502[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (11))){
var inst_26346 = (state_26435[(8)]);
var inst_26353 = (state_26435[(7)]);
var inst_26345 = (state_26435[(11)]);
var inst_26362 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_26353);
var inst_26363 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26345),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26346)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26362),"."].join('');
var state_26435__$1 = state_26435;
var statearr_26465_26503 = state_26435__$1;
(statearr_26465_26503[(2)] = inst_26363);

(statearr_26465_26503[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (9))){
var inst_26346 = (state_26435[(8)]);
var inst_26353 = (state_26435[(7)]);
var inst_26344 = (state_26435[(10)]);
var inst_26345 = (state_26435[(11)]);
var inst_26341 = (state_26435[(18)]);
var inst_26373 = (state_26435[(2)]);
var inst_26374 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_26353);
var inst_26375 = fluree.db.storage.core.reify_db.call(null,inst_26344,inst_26345,inst_26346,inst_26341,inst_26374);
var state_26435__$1 = (function (){var statearr_26466 = state_26435;
(statearr_26466[(21)] = inst_26373);

return statearr_26466;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26435__$1,(13),inst_26375);
} else {
if((state_val_26436 === (5))){
var _ = (function (){var statearr_26467 = state_26435;
(statearr_26467[(4)] = cljs.core.rest.call(null,(state_26435[(4)])));

return statearr_26467;
})();
var state_26435__$1 = state_26435;
var ex26464 = (state_26435__$1[(2)]);
var statearr_26468_26504 = state_26435__$1;
(statearr_26468_26504[(5)] = ex26464);


var statearr_26469_26505 = state_26435__$1;
(statearr_26469_26505[(1)] = (4));

(statearr_26469_26505[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (14))){
var inst_26378 = (state_26435[(14)]);
var inst_26381 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_26378);
var inst_26382 = (inst_26381 + (1));
var inst_26383 = inst_26378;
var inst_26384 = inst_26382;
var state_26435__$1 = (function (){var statearr_26470 = state_26435;
(statearr_26470[(9)] = inst_26384);

(statearr_26470[(19)] = inst_26383);

return statearr_26470;
})();
var statearr_26471_26506 = state_26435__$1;
(statearr_26471_26506[(2)] = null);

(statearr_26471_26506[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (26))){
var inst_26384 = (state_26435[(9)]);
var inst_26401 = (state_26435[(2)]);
var inst_26402 = fluree.db.util.async.throw_err.call(null,inst_26401);
var inst_26403 = (inst_26384 + (1));
var inst_26383 = inst_26402;
var inst_26384__$1 = inst_26403;
var state_26435__$1 = (function (){var statearr_26472 = state_26435;
(statearr_26472[(9)] = inst_26384__$1);

(statearr_26472[(19)] = inst_26383);

return statearr_26472;
})();
var statearr_26473_26507 = state_26435__$1;
(statearr_26473_26507[(2)] = null);

(statearr_26473_26507[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (16))){
var inst_26420 = (state_26435[(17)]);
var inst_26420__$1 = (state_26435[(2)]);
var inst_26421 = fluree.db.query.schema.schema_map.call(null,inst_26420__$1);
var inst_26422 = fluree.db.query.schema.setting_map.call(null,inst_26420__$1);
var state_26435__$1 = (function (){var statearr_26474 = state_26435;
(statearr_26474[(17)] = inst_26420__$1);

(statearr_26474[(12)] = inst_26422);

return statearr_26474;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26435__$1,(27),inst_26421);
} else {
if((state_val_26436 === (10))){
var inst_26346 = (state_26435[(8)]);
var inst_26345 = (state_26435[(11)]);
var inst_26360 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26345),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26346)," is not found on this ledger group."].join('');
var state_26435__$1 = state_26435;
var statearr_26475_26508 = state_26435__$1;
(statearr_26475_26508[(2)] = inst_26360);

(statearr_26475_26508[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (18))){
var inst_26417 = (state_26435[(2)]);
var state_26435__$1 = state_26435;
var statearr_26476_26509 = state_26435__$1;
(statearr_26476_26509[(2)] = inst_26417);

(statearr_26476_26509[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (8))){
var state_26435__$1 = state_26435;
var statearr_26477_26510 = state_26435__$1;
(statearr_26477_26510[(2)] = null);

(statearr_26477_26510[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2746__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2746__auto____0 = (function (){
var statearr_26478 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26478[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2746__auto__);

(statearr_26478[(1)] = (1));

return statearr_26478;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2746__auto____1 = (function (state_26435){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26435);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26479){var ex__2749__auto__ = e26479;
var statearr_26480_26511 = state_26435;
(statearr_26480_26511[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26435[(4)]))){
var statearr_26481_26512 = state_26435;
(statearr_26481_26512[(1)] = cljs.core.first.call(null,(state_26435[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26513 = state_26435;
state_26435 = G__26513;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2746__auto__ = function(state_26435){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2746__auto____1.call(this,state_26435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2746__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2746__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26482 = f__2769__auto__.call(null);
(statearr_26482[(6)] = c__2768__auto___26483);

return statearr_26482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.call(null,old_db_ch,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.call(null,new_db_ch,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),fluree.db.session.full_load_existing_db.call(null,session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.call(null,pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4253__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var ledger_id = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),ledger_id);

return ledger_id;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4747__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26515){
var state_val_26516 = (state_26515[(1)]);
if((state_val_26516 === (1))){
var state_26515__$1 = state_26515;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26515__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_26517 = [null,null,null,null,null,null,null];
(statearr_26517[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_26517[(1)] = (1));

return statearr_26517;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_26515){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26515);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26518){var ex__2749__auto__ = e26518;
var statearr_26519_26522 = state_26515;
(statearr_26519_26522[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26515[(4)]))){
var statearr_26520_26523 = state_26515;
(statearr_26520_26523[(1)] = cljs.core.first.call(null,(state_26515[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26524 = state_26515;
state_26515 = G__26524;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_26515){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_26515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26521 = f__2769__auto__.call(null);
(statearr_26521[(6)] = c__2768__auto__);

return statearr_26521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__26526){
var map__26527 = p__26526;
var map__26527__$1 = cljs.core.__destructure_map.call(null,map__26527);
var data = map__26527__$1;
var block = cljs.core.get.call(null,map__26527__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__26527__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__26527__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26586){
var state_val_26587 = (state_26586[(1)]);
if((state_val_26587 === (7))){
var inst_26538 = (state_26586[(7)]);
var inst_26541 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_26542 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_26543 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26541),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26542),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26538),". No-op."].join('');
var inst_26544 = fluree.db.util.log.info.call(null,inst_26543);
var state_26586__$1 = state_26586;
var statearr_26588_26622 = state_26586__$1;
(statearr_26588_26622[(2)] = inst_26544);

(statearr_26588_26622[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (1))){
var state_26586__$1 = state_26586;
var statearr_26589_26623 = state_26586__$1;
(statearr_26589_26623[(2)] = null);

(statearr_26589_26623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (4))){
var inst_26528 = (state_26586[(2)]);
var state_26586__$1 = state_26586;
var statearr_26590_26624 = state_26586__$1;
(statearr_26590_26624[(2)] = inst_26528);

(statearr_26590_26624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (15))){
var inst_26567 = (state_26586[(2)]);
var state_26586__$1 = state_26586;
var statearr_26591_26625 = state_26586__$1;
(statearr_26591_26625[(2)] = inst_26567);

(statearr_26591_26625[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (13))){
var inst_26558 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_26559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26560 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_26561 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_26562 = [inst_26560,inst_26561];
var inst_26563 = (new cljs.core.PersistentVector(null,2,(5),inst_26559,inst_26562,null));
var inst_26564 = fluree.db.conn_events.process_event.call(null,inst_26558,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_26563,data);
var state_26586__$1 = state_26586;
var statearr_26592_26626 = state_26586__$1;
(statearr_26592_26626[(2)] = inst_26564);

(statearr_26592_26626[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (6))){
var inst_26538 = (state_26586[(7)]);
var inst_26537 = (state_26586[(8)]);
var inst_26536 = (state_26586[(2)]);
var inst_26537__$1 = fluree.db.util.async.throw_err.call(null,inst_26536);
var inst_26538__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_26537__$1);
var inst_26539 = (block <= inst_26538__$1);
var state_26586__$1 = (function (){var statearr_26593 = state_26586;
(statearr_26593[(7)] = inst_26538__$1);

(statearr_26593[(8)] = inst_26537__$1);

return statearr_26593;
})();
if(cljs.core.truth_(inst_26539)){
var statearr_26594_26627 = state_26586__$1;
(statearr_26594_26627[(1)] = (7));

} else {
var statearr_26595_26628 = state_26586__$1;
(statearr_26595_26628[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (17))){
var state_26586__$1 = state_26586;
var statearr_26596_26629 = state_26586__$1;
(statearr_26596_26629[(2)] = null);

(statearr_26596_26629[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (3))){
var inst_26584 = (state_26586[(2)]);
var state_26586__$1 = state_26586;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26586__$1,inst_26584);
} else {
if((state_val_26587 === (12))){
var inst_26579 = (state_26586[(2)]);
var state_26586__$1 = state_26586;
var statearr_26597_26630 = state_26586__$1;
(statearr_26597_26630[(2)] = inst_26579);

(statearr_26597_26630[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (2))){
var inst_26534 = (state_26586[(9)]);
var _ = (function (){var statearr_26598 = state_26586;
(statearr_26598[(4)] = cljs.core.cons.call(null,(5),(state_26586[(4)])));

return statearr_26598;
})();
var inst_26534__$1 = fluree.db.session.current_db.call(null,session);
var state_26586__$1 = (function (){var statearr_26599 = state_26586;
(statearr_26599[(9)] = inst_26534__$1);

return statearr_26599;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26586__$1,(6),inst_26534__$1);
} else {
if((state_val_26587 === (11))){
var state_26586__$1 = state_26586;
var statearr_26601_26631 = state_26586__$1;
(statearr_26601_26631[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (9))){
var inst_26581 = (state_26586[(2)]);
var _ = (function (){var statearr_26603 = state_26586;
(statearr_26603[(4)] = cljs.core.rest.call(null,(state_26586[(4)])));

return statearr_26603;
})();
var state_26586__$1 = state_26586;
var statearr_26604_26632 = state_26586__$1;
(statearr_26604_26632[(2)] = inst_26581);

(statearr_26604_26632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (5))){
var _ = (function (){var statearr_26605 = state_26586;
(statearr_26605[(4)] = cljs.core.rest.call(null,(state_26586[(4)])));

return statearr_26605;
})();
var state_26586__$1 = state_26586;
var ex26600 = (state_26586__$1[(2)]);
var statearr_26606_26633 = state_26586__$1;
(statearr_26606_26633[(5)] = ex26600);


if((ex26600 instanceof Error)){
var statearr_26607_26634 = state_26586__$1;
(statearr_26607_26634[(1)] = (4));

(statearr_26607_26634[(5)] = null);

} else {
throw ex26600;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (14))){
var state_26586__$1 = state_26586;
var statearr_26608_26635 = state_26586__$1;
(statearr_26608_26635[(2)] = null);

(statearr_26608_26635[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (16))){
var inst_26538 = (state_26586[(7)]);
var inst_26570 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_26571 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_26572 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26570),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26571),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26538),". Forcing a db reload."].join('');
var inst_26573 = fluree.db.util.log.info.call(null,inst_26572);
var inst_26574 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_26586__$1 = (function (){var statearr_26609 = state_26586;
(statearr_26609[(10)] = inst_26573);

return statearr_26609;
})();
var statearr_26610_26636 = state_26586__$1;
(statearr_26610_26636[(2)] = inst_26574);

(statearr_26610_26636[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (10))){
var inst_26538 = (state_26586[(7)]);
var inst_26537 = (state_26586[(8)]);
var inst_26534 = (state_26586[(9)]);
var inst_26549 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_26550 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_26551 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26549),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26550),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_26552 = fluree.db.util.log.trace.call(null,inst_26551);
var inst_26553 = (function (){var current_db_ch = inst_26534;
var current_db = inst_26537;
var current_block = inst_26538;
return (function (p1__26525_SHARP_){
if((p1__26525_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__26525_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,p1__26525_SHARP_);
}
});
})();
var inst_26554 = cljs.core.map.call(null,inst_26553,flakes);
var inst_26555 = fluree.db.dbproto._with.call(null,inst_26537,block,inst_26554);
var inst_26556 = fluree.db.session.cas_db_BANG_.call(null,session,inst_26534,inst_26555);
var state_26586__$1 = (function (){var statearr_26611 = state_26586;
(statearr_26611[(11)] = inst_26552);

return statearr_26611;
})();
if(inst_26556){
var statearr_26612_26637 = state_26586__$1;
(statearr_26612_26637[(1)] = (13));

} else {
var statearr_26613_26638 = state_26586__$1;
(statearr_26613_26638[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (18))){
var inst_26577 = (state_26586[(2)]);
var state_26586__$1 = state_26586;
var statearr_26614_26639 = state_26586__$1;
(statearr_26614_26639[(2)] = inst_26577);

(statearr_26614_26639[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26587 === (8))){
var inst_26538 = (state_26586[(7)]);
var inst_26546 = ((1) + inst_26538);
var inst_26547 = cljs.core._EQ_.call(null,block,inst_26546);
var state_26586__$1 = state_26586;
if(inst_26547){
var statearr_26615_26640 = state_26586__$1;
(statearr_26615_26640[(1)] = (10));

} else {
var statearr_26616_26641 = state_26586__$1;
(statearr_26616_26641[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_26617 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26617[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_26617[(1)] = (1));

return statearr_26617;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_26586){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26586);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26618){var ex__2749__auto__ = e26618;
var statearr_26619_26642 = state_26586;
(statearr_26619_26642[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26586[(4)]))){
var statearr_26620_26643 = state_26586;
(statearr_26620_26643[(1)] = cljs.core.first.call(null,(state_26586[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26644 = state_26586;
state_26586 = G__26644;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_26586){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_26586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26621 = f__2769__auto__.call(null);
(statearr_26621[(6)] = c__2768__auto__);

return statearr_26621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26651){
var state_val_26652 = (state_26651[(1)]);
if((state_val_26652 === (1))){
var inst_26645 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_26646 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_26647 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_26648 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26646),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26647)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26649 = fluree.db.util.log.debug.call(null,inst_26648);
var state_26651__$1 = (function (){var statearr_26653 = state_26651;
(statearr_26653[(7)] = inst_26645);

(statearr_26653[(8)] = inst_26649);

return statearr_26653;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26651__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_26654 = [null,null,null,null,null,null,null,null,null];
(statearr_26654[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_26654[(1)] = (1));

return statearr_26654;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_26651){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26651);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26655){var ex__2749__auto__ = e26655;
var statearr_26656_26659 = state_26651;
(statearr_26656_26659[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26651[(4)]))){
var statearr_26657_26660 = state_26651;
(statearr_26657_26660[(1)] = cljs.core.first.call(null,(state_26651[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26661 = state_26651;
state_26651 = G__26661;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_26651){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_26651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26658 = f__2769__auto__.call(null);
(statearr_26658[(6)] = c__2768__auto__);

return statearr_26658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + ledger-id will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__26663 = arguments.length;
switch (G__26663) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
var map__26664 = session;
var map__26664__$1 = cljs.core.__destructure_map.call(null,map__26664);
var conn = cljs.core.get.call(null,map__26664__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__26664__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__26664__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__26664__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__26664__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__26664__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var id = cljs.core.get.call(null,map__26664__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_.call(null,session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_.call(null,network,ledger_id);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,ledger_id);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,ledger_id){
var temp__5802__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26717){
var state_val_26718 = (state_26717[(1)]);
if((state_val_26718 === (7))){
var inst_26713 = (state_26717[(2)]);
var state_26717__$1 = state_26717;
var statearr_26719_26750 = state_26717__$1;
(statearr_26719_26750[(2)] = inst_26713);

(statearr_26719_26750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26718 === (1))){
var state_26717__$1 = state_26717;
var statearr_26720_26751 = state_26717__$1;
(statearr_26720_26751[(2)] = null);

(statearr_26720_26751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26718 === (4))){
var inst_26669 = (state_26717[(7)]);
var inst_26668 = (state_26717[(2)]);
var inst_26669__$1 = fluree.db.util.async.throw_err.call(null,inst_26668);
var inst_26670 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_26671 = (inst_26669__$1 == null);
var state_26717__$1 = (function (){var statearr_26721 = state_26717;
(statearr_26721[(8)] = inst_26670);

(statearr_26721[(7)] = inst_26669__$1);

return statearr_26721;
})();
if(cljs.core.truth_(inst_26671)){
var statearr_26722_26752 = state_26717__$1;
(statearr_26722_26752[(1)] = (5));

} else {
var statearr_26723_26753 = state_26717__$1;
(statearr_26723_26753[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26718 === (15))){
var inst_26705 = (state_26717[(2)]);
var state_26717__$1 = (function (){var statearr_26724 = state_26717;
(statearr_26724[(9)] = inst_26705);

return statearr_26724;
})();
var statearr_26725_26754 = state_26717__$1;
(statearr_26725_26754[(2)] = null);

(statearr_26725_26754[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26718 === (13))){
var inst_26709 = (state_26717[(2)]);
var state_26717__$1 = state_26717;
var statearr_26727_26755 = state_26717__$1;
(statearr_26727_26755[(2)] = inst_26709);

(statearr_26727_26755[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26718 === (6))){
var inst_26670 = (state_26717[(8)]);
var inst_26676 = (inst_26670 == null);
var state_26717__$1 = state_26717;
if(cljs.core.truth_(inst_26676)){
var statearr_26728_26756 = state_26717__$1;
(statearr_26728_26756[(1)] = (8));

} else {
var statearr_26729_26757 = state_26717__$1;
(statearr_26729_26757[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26718 === (17))){
var _ = (function (){var statearr_26730 = state_26717;
(statearr_26730[(4)] = cljs.core.rest.call(null,(state_26717[(4)])));

return statearr_26730;
})();
var state_26717__$1 = state_26717;
var ex26726 = (state_26717__$1[(2)]);
var statearr_26731_26758 = state_26717__$1;
(statearr_26731_26758[(5)] = ex26726);


var statearr_26732_26759 = state_26717__$1;
(statearr_26732_26759[(1)] = (16));

(statearr_26732_26759[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26718 === (3))){
var inst_26715 = (state_26717[(2)]);
var state_26717__$1 = state_26717;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26717__$1,inst_26715);
} else {
if((state_val_26718 === (12))){
var state_26717__$1 = state_26717;
var statearr_26733_26760 = state_26717__$1;
(statearr_26733_26760[(2)] = null);

(statearr_26733_26760[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26718 === (2))){
var state_26717__$1 = state_26717;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26717__$1,(4),update_chan);
} else {
if((state_val_26718 === (11))){
var state_26717__$1 = state_26717;
var statearr_26734_26761 = state_26717__$1;
(statearr_26734_26761[(2)] = null);

(statearr_26734_26761[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26718 === (9))){
var state_26717__$1 = state_26717;
var statearr_26735_26762 = state_26717__$1;
(statearr_26735_26762[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26718 === (5))){
var inst_26673 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_26674 = fluree.db.util.log.info.call(null,"Channel closed for session updates for:",inst_26673);
var state_26717__$1 = state_26717;
var statearr_26737_26763 = state_26717__$1;
(statearr_26737_26763[(2)] = inst_26674);

(statearr_26737_26763[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26718 === (14))){
var inst_26670 = (state_26717[(8)]);
var inst_26669 = (state_26717[(7)]);
var _ = (function (){var statearr_26738 = state_26717;
(statearr_26738[(4)] = cljs.core.cons.call(null,(17),(state_26717[(4)])));

return statearr_26738;
})();
var inst_26693 = cljs.core.nth.call(null,inst_26669,(0),null);
var inst_26694 = cljs.core.nth.call(null,inst_26669,(1),null);
var inst_26695 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_26696 = cljs.core.pr_str.call(null,inst_26669);
var inst_26697 = fluree.db.util.core.trunc.call(null,inst_26696,(200));
var inst_26698 = fluree.db.util.log.trace.call(null,"[process-ledger-updates[",inst_26695,"]: ",inst_26697);
var inst_26699 = fluree.db.session.process_ledger_update.call(null,inst_26670,inst_26693,inst_26694);
var state_26717__$1 = (function (){var statearr_26739 = state_26717;
(statearr_26739[(10)] = inst_26698);

return statearr_26739;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26717__$1,(18),inst_26699);
} else {
if((state_val_26718 === (16))){
var inst_26669 = (state_26717[(7)]);
var inst_26683 = (state_26717[(2)]);
var inst_26684 = fluree.db.util.log.error.call(null,inst_26683,"Exception processing ledger updates for message:",inst_26669);
var state_26717__$1 = state_26717;
var statearr_26740_26764 = state_26717__$1;
(statearr_26740_26764[(2)] = inst_26684);

(statearr_26740_26764[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26718 === (10))){
var inst_26711 = (state_26717[(2)]);
var state_26717__$1 = state_26717;
var statearr_26741_26765 = state_26717__$1;
(statearr_26741_26765[(2)] = inst_26711);

(statearr_26741_26765[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26718 === (18))){
var inst_26701 = (state_26717[(2)]);
var inst_26702 = fluree.db.util.async.throw_err.call(null,inst_26701);
var _ = (function (){var statearr_26742 = state_26717;
(statearr_26742[(4)] = cljs.core.rest.call(null,(state_26717[(4)])));

return statearr_26742;
})();
var state_26717__$1 = state_26717;
var statearr_26743_26766 = state_26717__$1;
(statearr_26743_26766[(2)] = inst_26702);

(statearr_26743_26766[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26718 === (8))){
var inst_26669 = (state_26717[(7)]);
var inst_26678 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_26679 = cljs.core.first.call(null,inst_26669);
var inst_26680 = fluree.db.util.log.warn.call(null,"Ledger update received for session that is no longer open:",inst_26678,"Message: ",inst_26679);
var state_26717__$1 = state_26717;
var statearr_26744_26767 = state_26717__$1;
(statearr_26744_26767[(2)] = inst_26680);

(statearr_26744_26767[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0 = (function (){
var statearr_26745 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26745[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__);

(statearr_26745[(1)] = (1));

return statearr_26745;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1 = (function (state_26717){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26717);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26746){var ex__2749__auto__ = e26746;
var statearr_26747_26768 = state_26717;
(statearr_26747_26768[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26717[(4)]))){
var statearr_26748_26769 = state_26717;
(statearr_26748_26769[(1)] = cljs.core.first.call(null,(state_26717[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26770 = state_26717;
state_26717 = G__26770;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__ = function(state_26717){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1.call(this,state_26717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26749 = f__2769__auto__.call(null);
(statearr_26749[(6)] = c__2768__auto__);

return statearr_26749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__26771){
var map__26772 = p__26771;
var map__26772__$1 = cljs.core.__destructure_map.call(null,map__26772);
var network = cljs.core.get.call(null,map__26772__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__26772__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var db = cljs.core.get.call(null,map__26772__$1,new cljs.core.Keyword(null,"db","db",993250759));
var ledger_id = cljs.core.get.call(null,map__26772__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var transactor_QMARK_ = cljs.core.get.call(null,map__26772__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__26772__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__26772__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__26772__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__26772__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.call(null);
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","current","db/current",-1088041545),(cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[ledger_id,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return fluree.db.session.current_db.call(null,session);
});
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,ledger_id,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__26776 = block_result;
var map__26776__$1 = cljs.core.__destructure_map.call(null,map__26776);
var block = cljs.core.get.call(null,map__26776__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__26776__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__26776__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__26776__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__26776__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4253__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__26777 = tx_result;
var map__26777__$1 = cljs.core.__destructure_map.call(null,map__26777);
var t = cljs.core.get.call(null,map__26777__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__26777__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__26773_SHARP_){
return cljs.core._EQ_.call(null,t,fluree.db.flake.t.call(null,p1__26773_SHARP_));
}):(function (p1__26774_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__26774_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__26775_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__26775_SHARP_))){
return cljs.core.nth.call(null,p1__26775_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__26778 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__26778,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__26778,(1),null);
var error = cljs.core.nth.call(null,vec__26778,(2),null);
var message = cljs.core.nth.call(null,vec__26778,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__4253__auto__ = message;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));
var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__26782 = arguments.length;
switch (G__26782) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__26783){
var map__26784 = p__26783;
var map__26784__$1 = cljs.core.__destructure_map.call(null,map__26784);
var state = cljs.core.get.call(null,map__26784__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__26784__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__26784__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__26784__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__26785 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__26785,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__26785,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__26785,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4253__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4253__auto____$1 = state;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__26788 = cljs.core.seq.call(null,tids);
var chunk__26789 = null;
var count__26790 = (0);
var i__26791 = (0);
while(true){
if((i__26791 < count__26790)){
var tid = cljs.core._nth.call(null,chunk__26789,i__26791);
var temp__5804__auto___26904__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___26904__$1)){
var keyed_callbacks_26905 = temp__5804__auto___26904__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_26906 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__26832_26907 = cljs.core.seq.call(null,keyed_callbacks_26905);
var chunk__26833_26908 = null;
var count__26834_26909 = (0);
var i__26835_26910 = (0);
while(true){
if((i__26835_26910 < count__26834_26909)){
var vec__26844_26911 = cljs.core._nth.call(null,chunk__26833_26908,i__26835_26910);
var k_26912 = cljs.core.nth.call(null,vec__26844_26911,(0),null);
var f_26913 = cljs.core.nth.call(null,vec__26844_26911,(1),null);
try{f_26913.call(null,tx_response_26906);
}catch (e26847){var e_26914 = e26847;
fluree.db.util.log.error.call(null,e_26914,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__26915 = seq__26832_26907;
var G__26916 = chunk__26833_26908;
var G__26917 = count__26834_26909;
var G__26918 = (i__26835_26910 + (1));
seq__26832_26907 = G__26915;
chunk__26833_26908 = G__26916;
count__26834_26909 = G__26917;
i__26835_26910 = G__26918;
continue;
} else {
var temp__5804__auto___26919__$2 = cljs.core.seq.call(null,seq__26832_26907);
if(temp__5804__auto___26919__$2){
var seq__26832_26920__$1 = temp__5804__auto___26919__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26832_26920__$1)){
var c__4679__auto___26921 = cljs.core.chunk_first.call(null,seq__26832_26920__$1);
var G__26922 = cljs.core.chunk_rest.call(null,seq__26832_26920__$1);
var G__26923 = c__4679__auto___26921;
var G__26924 = cljs.core.count.call(null,c__4679__auto___26921);
var G__26925 = (0);
seq__26832_26907 = G__26922;
chunk__26833_26908 = G__26923;
count__26834_26909 = G__26924;
i__26835_26910 = G__26925;
continue;
} else {
var vec__26848_26926 = cljs.core.first.call(null,seq__26832_26920__$1);
var k_26927 = cljs.core.nth.call(null,vec__26848_26926,(0),null);
var f_26928 = cljs.core.nth.call(null,vec__26848_26926,(1),null);
try{f_26928.call(null,tx_response_26906);
}catch (e26851){var e_26929 = e26851;
fluree.db.util.log.error.call(null,e_26929,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__26930 = cljs.core.next.call(null,seq__26832_26920__$1);
var G__26931 = null;
var G__26932 = (0);
var G__26933 = (0);
seq__26832_26907 = G__26930;
chunk__26833_26908 = G__26931;
count__26834_26909 = G__26932;
i__26835_26910 = G__26933;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__26934 = seq__26788;
var G__26935 = chunk__26789;
var G__26936 = count__26790;
var G__26937 = (i__26791 + (1));
seq__26788 = G__26934;
chunk__26789 = G__26935;
count__26790 = G__26936;
i__26791 = G__26937;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq.call(null,seq__26788);
if(temp__5804__auto____$1){
var seq__26788__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26788__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__26788__$1);
var G__26938 = cljs.core.chunk_rest.call(null,seq__26788__$1);
var G__26939 = c__4679__auto__;
var G__26940 = cljs.core.count.call(null,c__4679__auto__);
var G__26941 = (0);
seq__26788 = G__26938;
chunk__26789 = G__26939;
count__26790 = G__26940;
i__26791 = G__26941;
continue;
} else {
var tid = cljs.core.first.call(null,seq__26788__$1);
var temp__5804__auto___26942__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___26942__$2)){
var keyed_callbacks_26943 = temp__5804__auto___26942__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_26944 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__26852_26945 = cljs.core.seq.call(null,keyed_callbacks_26943);
var chunk__26853_26946 = null;
var count__26854_26947 = (0);
var i__26855_26948 = (0);
while(true){
if((i__26855_26948 < count__26854_26947)){
var vec__26864_26949 = cljs.core._nth.call(null,chunk__26853_26946,i__26855_26948);
var k_26950 = cljs.core.nth.call(null,vec__26864_26949,(0),null);
var f_26951 = cljs.core.nth.call(null,vec__26864_26949,(1),null);
try{f_26951.call(null,tx_response_26944);
}catch (e26867){var e_26952 = e26867;
fluree.db.util.log.error.call(null,e_26952,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__26953 = seq__26852_26945;
var G__26954 = chunk__26853_26946;
var G__26955 = count__26854_26947;
var G__26956 = (i__26855_26948 + (1));
seq__26852_26945 = G__26953;
chunk__26853_26946 = G__26954;
count__26854_26947 = G__26955;
i__26855_26948 = G__26956;
continue;
} else {
var temp__5804__auto___26957__$3 = cljs.core.seq.call(null,seq__26852_26945);
if(temp__5804__auto___26957__$3){
var seq__26852_26958__$1 = temp__5804__auto___26957__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26852_26958__$1)){
var c__4679__auto___26959 = cljs.core.chunk_first.call(null,seq__26852_26958__$1);
var G__26960 = cljs.core.chunk_rest.call(null,seq__26852_26958__$1);
var G__26961 = c__4679__auto___26959;
var G__26962 = cljs.core.count.call(null,c__4679__auto___26959);
var G__26963 = (0);
seq__26852_26945 = G__26960;
chunk__26853_26946 = G__26961;
count__26854_26947 = G__26962;
i__26855_26948 = G__26963;
continue;
} else {
var vec__26868_26964 = cljs.core.first.call(null,seq__26852_26958__$1);
var k_26965 = cljs.core.nth.call(null,vec__26868_26964,(0),null);
var f_26966 = cljs.core.nth.call(null,vec__26868_26964,(1),null);
try{f_26966.call(null,tx_response_26944);
}catch (e26871){var e_26967 = e26871;
fluree.db.util.log.error.call(null,e_26967,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__26968 = cljs.core.next.call(null,seq__26852_26958__$1);
var G__26969 = null;
var G__26970 = (0);
var G__26971 = (0);
seq__26852_26945 = G__26968;
chunk__26853_26946 = G__26969;
count__26854_26947 = G__26970;
i__26855_26948 = G__26971;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__26972 = cljs.core.next.call(null,seq__26788__$1);
var G__26973 = null;
var G__26974 = (0);
var G__26975 = (0);
seq__26788 = G__26972;
chunk__26789 = G__26973;
count__26790 = G__26974;
i__26791 = G__26975;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_26976 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2768__auto___26977 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26888){
var state_val_26889 = (state_26888[(1)]);
if((state_val_26889 === (1))){
var state_26888__$1 = state_26888;
var statearr_26890_26978 = state_26888__$1;
(statearr_26890_26978[(2)] = null);

(statearr_26890_26978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26889 === (2))){
var inst_26873 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_26888__$1 = state_26888;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26888__$1,(4),inst_26873);
} else {
if((state_val_26889 === (3))){
var inst_26886 = (state_26888[(2)]);
var state_26888__$1 = state_26888;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26888__$1,inst_26886);
} else {
if((state_val_26889 === (4))){
var inst_26875 = (state_26888[(7)]);
var inst_26875__$1 = (state_26888[(2)]);
var inst_26876 = (inst_26875__$1 == null);
var state_26888__$1 = (function (){var statearr_26891 = state_26888;
(statearr_26891[(7)] = inst_26875__$1);

return statearr_26891;
})();
if(cljs.core.truth_(inst_26876)){
var statearr_26892_26979 = state_26888__$1;
(statearr_26892_26979[(1)] = (5));

} else {
var statearr_26893_26980 = state_26888__$1;
(statearr_26893_26980[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26889 === (5))){
var inst_26878 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_26879 = fluree.db.util.log.info.call(null,"Transactor session closing for db:",inst_26878);
var state_26888__$1 = state_26888;
var statearr_26894_26981 = state_26888__$1;
(statearr_26894_26981[(2)] = inst_26879);

(statearr_26894_26981[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26889 === (6))){
var inst_26875 = (state_26888[(7)]);
var inst_26881 = transact_handler_26976.call(null,conn,inst_26875);
var state_26888__$1 = (function (){var statearr_26895 = state_26888;
(statearr_26895[(8)] = inst_26881);

return statearr_26895;
})();
var statearr_26896_26982 = state_26888__$1;
(statearr_26896_26982[(2)] = null);

(statearr_26896_26982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26889 === (7))){
var inst_26884 = (state_26888[(2)]);
var state_26888__$1 = state_26888;
var statearr_26897_26983 = state_26888__$1;
(statearr_26897_26983[(2)] = inst_26884);

(statearr_26897_26983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_26898 = [null,null,null,null,null,null,null,null,null];
(statearr_26898[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_26898[(1)] = (1));

return statearr_26898;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_26888){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26888);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26899){var ex__2749__auto__ = e26899;
var statearr_26900_26984 = state_26888;
(statearr_26900_26984[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26888[(4)]))){
var statearr_26901_26985 = state_26888;
(statearr_26901_26985[(1)] = cljs.core.first.call(null,(state_26888[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26986 = state_26888;
state_26888 = G__26986;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_26888){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_26888);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26902 = f__2769__auto__.call(null);
(statearr_26902[(6)] = c__2768__auto___26977);

return statearr_26902;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(p__26988){
var map__26989 = p__26988;
var map__26989__$1 = cljs.core.__destructure_map.call(null,map__26989);
var session = map__26989__$1;
var state = cljs.core.get.call(null,map__26989__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.call(null,state,(function (p1__26987_SHARP_){
return cljs.core.assoc.call(null,p1__26987_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__26987_SHARP_) + (1)));
}));

var or__4253__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var _ = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);
var new_state = cljs.core.swap_BANG_.call(null,state,(function (st){
if(cljs.core.truth_(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(st))){
return st;
} else {
return cljs.core.assoc.call(null,st,new cljs.core.Keyword("db","current","db/current",-1088041545),fluree.db.session.full_load_existing_db.call(null,session));
}
}));
return new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(new_state);
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__26992 = arguments.length;
switch (G__26992) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__26993 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__26990_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__26990_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__26993);
} else {
return G__26993;
}
})();
var seq__26994 = cljs.core.seq.call(null,sessions);
var chunk__26995 = null;
var count__26996 = (0);
var i__26997 = (0);
while(true){
if((i__26997 < count__26996)){
var session = cljs.core._nth.call(null,chunk__26995,i__26997);
fluree.db.session.close.call(null,session);


var G__26999 = seq__26994;
var G__27000 = chunk__26995;
var G__27001 = count__26996;
var G__27002 = (i__26997 + (1));
seq__26994 = G__26999;
chunk__26995 = G__27000;
count__26996 = G__27001;
i__26997 = G__27002;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__26994);
if(temp__5804__auto__){
var seq__26994__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26994__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__26994__$1);
var G__27003 = cljs.core.chunk_rest.call(null,seq__26994__$1);
var G__27004 = c__4679__auto__;
var G__27005 = cljs.core.count.call(null,c__4679__auto__);
var G__27006 = (0);
seq__26994 = G__27003;
chunk__26995 = G__27004;
count__26996 = G__27005;
i__26997 = G__27006;
continue;
} else {
var session = cljs.core.first.call(null,seq__26994__$1);
fluree.db.session.close.call(null,session);


var G__27007 = cljs.core.next.call(null,seq__26994__$1);
var G__27008 = null;
var G__27009 = (0);
var G__27010 = (0);
seq__26994 = G__27007;
chunk__26995 = G__27008;
count__26996 = G__27009;
i__26997 = G__27010;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
