// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');

/**
 * @interface
 */
fluree.db.storage.core.Store = function(){};

var fluree$db$storage$core$Store$exists_QMARK_$dyn_16432 = (function (s,k){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.exists_QMARK_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,s,k);
} else {
var m__4549__auto__ = (fluree.db.storage.core.exists_QMARK_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.exists?",s);
}
}
});
/**
 * Returns true when `k` exists in `s`
 */
fluree.db.storage.core.exists_QMARK_ = (function fluree$db$storage$core$exists_QMARK_(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$exists_QMARK_$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$exists_QMARK_$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$exists_QMARK_$dyn_16432.call(null,s,k);
}
});

var fluree$db$storage$core$Store$list$dyn_16433 = (function (s,d){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.list[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,s,d);
} else {
var m__4549__auto__ = (fluree.db.storage.core.list["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,s,d);
} else {
throw cljs.core.missing_protocol.call(null,"Store.list",s);
}
}
});
/**
 * Returns a collection containing the keys stored under the subdirectory/prefix `d` of `s`
 */
fluree.db.storage.core.list = (function fluree$db$storage$core$list(s,d){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$list$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$list$arity$2(s,d);
} else {
return fluree$db$storage$core$Store$list$dyn_16433.call(null,s,d);
}
});

var fluree$db$storage$core$Store$read$dyn_16434 = (function (s,k){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.read[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,s,k);
} else {
var m__4549__auto__ = (fluree.db.storage.core.read["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.read",s);
}
}
});
/**
 * Reads raw bytes from `s` associated with `k`
 */
fluree.db.storage.core.read = (function fluree$db$storage$core$read(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$read$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$read$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$read$dyn_16434.call(null,s,k);
}
});

var fluree$db$storage$core$Store$write$dyn_16435 = (function (s,k,data){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.write[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,s,k,data);
} else {
var m__4549__auto__ = (fluree.db.storage.core.write["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,s,k,data);
} else {
throw cljs.core.missing_protocol.call(null,"Store.write",s);
}
}
});
/**
 * Writes `data` as raw bytes to `s` and associates it with `k`
 */
fluree.db.storage.core.write = (function fluree$db$storage$core$write(s,k,data){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$write$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$write$arity$3(s,k,data);
} else {
return fluree$db$storage$core$Store$write$dyn_16435.call(null,s,k,data);
}
});

var fluree$db$storage$core$Store$rename$dyn_16436 = (function (s,old_key,new_key){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.rename[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,s,old_key,new_key);
} else {
var m__4549__auto__ = (fluree.db.storage.core.rename["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,s,old_key,new_key);
} else {
throw cljs.core.missing_protocol.call(null,"Store.rename",s);
}
}
});
/**
 * Remove `old-key` and associate its data to `new-key`
 */
fluree.db.storage.core.rename = (function fluree$db$storage$core$rename(s,old_key,new_key){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$rename$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$rename$arity$3(s,old_key,new_key);
} else {
return fluree$db$storage$core$Store$rename$dyn_16436.call(null,s,old_key,new_key);
}
});

var fluree$db$storage$core$Store$delete$dyn_16437 = (function (s,k){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.delete$[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,s,k);
} else {
var m__4549__auto__ = (fluree.db.storage.core.delete$["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.delete",s);
}
}
});
/**
 * Delete data associated with key `k`
 */
fluree.db.storage.core.delete$ = (function fluree$db$storage$core$delete(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$delete$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$delete$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$delete$dyn_16437.call(null,s,k);
}
});

/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_prefix = (function fluree$db$storage$core$ledger_garbage_prefix(network,ldgr_id){
return clojure.string.join.call(null,"_",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ldgr_id,"garbage"], null));
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ldgr_id,block){
var pre = fluree.db.storage.core.ledger_garbage_prefix.call(null,network,ldgr_id);
return clojure.string.join.call(null,"_",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pre,block], null));
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16459){
var state_val_16460 = (state_16459[(1)]);
if((state_val_16460 === (7))){
var inst_16448 = (state_16459[(7)]);
var inst_16450 = fluree.db.storage.core.serde.call(null,conn);
var inst_16451 = fluree.db.serde.protocol._deserialize_block.call(null,inst_16450,inst_16448);
var state_16459__$1 = state_16459;
var statearr_16461_16480 = state_16459__$1;
(statearr_16461_16480[(2)] = inst_16451);

(statearr_16461_16480[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16460 === (1))){
var state_16459__$1 = state_16459;
var statearr_16462_16481 = state_16459__$1;
(statearr_16462_16481[(2)] = null);

(statearr_16462_16481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16460 === (4))){
var inst_16438 = (state_16459[(2)]);
var state_16459__$1 = state_16459;
var statearr_16463_16482 = state_16459__$1;
(statearr_16463_16482[(2)] = inst_16438);

(statearr_16463_16482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16460 === (6))){
var inst_16448 = (state_16459[(7)]);
var inst_16447 = (state_16459[(2)]);
var inst_16448__$1 = fluree.db.util.async.throw_err.call(null,inst_16447);
var state_16459__$1 = (function (){var statearr_16464 = state_16459;
(statearr_16464[(7)] = inst_16448__$1);

return statearr_16464;
})();
if(cljs.core.truth_(inst_16448__$1)){
var statearr_16465_16483 = state_16459__$1;
(statearr_16465_16483[(1)] = (7));

} else {
var statearr_16466_16484 = state_16459__$1;
(statearr_16466_16484[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16460 === (3))){
var inst_16457 = (state_16459[(2)]);
var state_16459__$1 = state_16459;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16459__$1,inst_16457);
} else {
if((state_val_16460 === (2))){
var _ = (function (){var statearr_16468 = state_16459;
(statearr_16468[(4)] = cljs.core.cons.call(null,(5),(state_16459[(4)])));

return statearr_16468;
})();
var inst_16444 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_16445 = fluree.db.storage.core.read.call(null,conn,inst_16444);
var state_16459__$1 = state_16459;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16459__$1,(6),inst_16445);
} else {
if((state_val_16460 === (9))){
var inst_16454 = (state_16459[(2)]);
var _ = (function (){var statearr_16469 = state_16459;
(statearr_16469[(4)] = cljs.core.rest.call(null,(state_16459[(4)])));

return statearr_16469;
})();
var state_16459__$1 = state_16459;
var statearr_16470_16485 = state_16459__$1;
(statearr_16470_16485[(2)] = inst_16454);

(statearr_16470_16485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16460 === (5))){
var _ = (function (){var statearr_16471 = state_16459;
(statearr_16471[(4)] = cljs.core.rest.call(null,(state_16459[(4)])));

return statearr_16471;
})();
var state_16459__$1 = state_16459;
var ex16467 = (state_16459__$1[(2)]);
var statearr_16472_16486 = state_16459__$1;
(statearr_16472_16486[(5)] = ex16467);


if((ex16467 instanceof Error)){
var statearr_16473_16487 = state_16459__$1;
(statearr_16473_16487[(1)] = (4));

(statearr_16473_16487[(5)] = null);

} else {
throw ex16467;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16460 === (8))){
var state_16459__$1 = state_16459;
var statearr_16474_16488 = state_16459__$1;
(statearr_16474_16488[(2)] = null);

(statearr_16474_16488[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2746__auto____0 = (function (){
var statearr_16475 = [null,null,null,null,null,null,null,null];
(statearr_16475[(0)] = fluree$db$storage$core$read_block_$_state_machine__2746__auto__);

(statearr_16475[(1)] = (1));

return statearr_16475;
});
var fluree$db$storage$core$read_block_$_state_machine__2746__auto____1 = (function (state_16459){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16459);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16476){var ex__2749__auto__ = e16476;
var statearr_16477_16489 = state_16459;
(statearr_16477_16489[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16459[(4)]))){
var statearr_16478_16490 = state_16459;
(statearr_16478_16490[(1)] = cljs.core.first.call(null,(state_16459[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16491 = state_16459;
state_16459 = G__16491;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2746__auto__ = function(state_16459){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2746__auto____1.call(this,state_16459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16479 = f__2769__auto__.call(null);
(statearr_16479[(6)] = c__2768__auto__);

return statearr_16479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16514){
var state_val_16515 = (state_16514[(1)]);
if((state_val_16515 === (7))){
var inst_16503 = (state_16514[(7)]);
var inst_16505 = fluree.db.storage.core.serde.call(null,conn);
var inst_16506 = fluree.db.serde.protocol._deserialize_block.call(null,inst_16505,inst_16503);
var state_16514__$1 = state_16514;
var statearr_16516_16535 = state_16514__$1;
(statearr_16516_16535[(2)] = inst_16506);

(statearr_16516_16535[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16515 === (1))){
var state_16514__$1 = state_16514;
var statearr_16517_16536 = state_16514__$1;
(statearr_16517_16536[(2)] = null);

(statearr_16517_16536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16515 === (4))){
var inst_16492 = (state_16514[(2)]);
var state_16514__$1 = state_16514;
var statearr_16518_16537 = state_16514__$1;
(statearr_16518_16537[(2)] = inst_16492);

(statearr_16518_16537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16515 === (6))){
var inst_16503 = (state_16514[(7)]);
var inst_16502 = (state_16514[(2)]);
var inst_16503__$1 = fluree.db.util.async.throw_err.call(null,inst_16502);
var state_16514__$1 = (function (){var statearr_16519 = state_16514;
(statearr_16519[(7)] = inst_16503__$1);

return statearr_16519;
})();
if(cljs.core.truth_(inst_16503__$1)){
var statearr_16520_16538 = state_16514__$1;
(statearr_16520_16538[(1)] = (7));

} else {
var statearr_16521_16539 = state_16514__$1;
(statearr_16521_16539[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16515 === (3))){
var inst_16512 = (state_16514[(2)]);
var state_16514__$1 = state_16514;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16514__$1,inst_16512);
} else {
if((state_val_16515 === (2))){
var _ = (function (){var statearr_16523 = state_16514;
(statearr_16523[(4)] = cljs.core.cons.call(null,(5),(state_16514[(4)])));

return statearr_16523;
})();
var inst_16498 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_16499 = [inst_16498,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_16500 = fluree.db.storage.core.read.call(null,conn,inst_16499);
var state_16514__$1 = state_16514;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16514__$1,(6),inst_16500);
} else {
if((state_val_16515 === (9))){
var inst_16509 = (state_16514[(2)]);
var _ = (function (){var statearr_16524 = state_16514;
(statearr_16524[(4)] = cljs.core.rest.call(null,(state_16514[(4)])));

return statearr_16524;
})();
var state_16514__$1 = state_16514;
var statearr_16525_16540 = state_16514__$1;
(statearr_16525_16540[(2)] = inst_16509);

(statearr_16525_16540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16515 === (5))){
var _ = (function (){var statearr_16526 = state_16514;
(statearr_16526[(4)] = cljs.core.rest.call(null,(state_16514[(4)])));

return statearr_16526;
})();
var state_16514__$1 = state_16514;
var ex16522 = (state_16514__$1[(2)]);
var statearr_16527_16541 = state_16514__$1;
(statearr_16527_16541[(5)] = ex16522);


if((ex16522 instanceof Error)){
var statearr_16528_16542 = state_16514__$1;
(statearr_16528_16542[(1)] = (4));

(statearr_16528_16542[(5)] = null);

} else {
throw ex16522;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16515 === (8))){
var state_16514__$1 = state_16514;
var statearr_16529_16543 = state_16514__$1;
(statearr_16529_16543[(2)] = null);

(statearr_16529_16543[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0 = (function (){
var statearr_16530 = [null,null,null,null,null,null,null,null];
(statearr_16530[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__);

(statearr_16530[(1)] = (1));

return statearr_16530;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1 = (function (state_16514){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16514);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16531){var ex__2749__auto__ = e16531;
var statearr_16532_16544 = state_16514;
(statearr_16532_16544[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16514[(4)]))){
var statearr_16533_16545 = state_16514;
(statearr_16533_16545[(1)] = cljs.core.first.call(null,(state_16514[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16546 = state_16514;
state_16514 = G__16546;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__ = function(state_16514){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1.call(this,state_16514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16534 = f__2769__auto__.call(null);
(statearr_16534[(6)] = c__2768__auto__);

return statearr_16534;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,ledger_id,block_data,version){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16570){
var state_val_16571 = (state_16570[(1)]);
if((state_val_16571 === (1))){
var state_16570__$1 = state_16570;
var statearr_16572_16586 = state_16570__$1;
(statearr_16572_16586[(2)] = null);

(statearr_16572_16586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (2))){
var _ = (function (){var statearr_16573 = state_16570;
(statearr_16573[(4)] = cljs.core.cons.call(null,(5),(state_16570[(4)])));

return statearr_16573;
})();
var inst_16553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16554 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_16555 = (new cljs.core.PersistentVector(null,3,(5),inst_16553,inst_16554,null));
var inst_16556 = cljs.core.select_keys.call(null,block_data,inst_16555);
var inst_16557 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_16556);
var inst_16558 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,inst_16557);
var inst_16559 = [inst_16558,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_16560 = fluree.db.storage.core.serde.call(null,conn);
var inst_16561 = fluree.db.serde.protocol._serialize_block.call(null,inst_16560,inst_16556);
var inst_16562 = fluree.db.storage.core.write.call(null,conn,inst_16559,inst_16561);
var state_16570__$1 = state_16570;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16570__$1,(6),inst_16562);
} else {
if((state_val_16571 === (3))){
var inst_16568 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16570__$1,inst_16568);
} else {
if((state_val_16571 === (4))){
var inst_16547 = (state_16570[(2)]);
var state_16570__$1 = state_16570;
var statearr_16575_16587 = state_16570__$1;
(statearr_16575_16587[(2)] = inst_16547);

(statearr_16575_16587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (5))){
var _ = (function (){var statearr_16576 = state_16570;
(statearr_16576[(4)] = cljs.core.rest.call(null,(state_16570[(4)])));

return statearr_16576;
})();
var state_16570__$1 = state_16570;
var ex16574 = (state_16570__$1[(2)]);
var statearr_16577_16588 = state_16570__$1;
(statearr_16577_16588[(5)] = ex16574);


if((ex16574 instanceof Error)){
var statearr_16578_16589 = state_16570__$1;
(statearr_16578_16589[(1)] = (4));

(statearr_16578_16589[(5)] = null);

} else {
throw ex16574;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16571 === (6))){
var inst_16564 = (state_16570[(2)]);
var inst_16565 = fluree.db.util.async.throw_err.call(null,inst_16564);
var _ = (function (){var statearr_16579 = state_16570;
(statearr_16579[(4)] = cljs.core.rest.call(null,(state_16570[(4)])));

return statearr_16579;
})();
var state_16570__$1 = state_16570;
var statearr_16580_16590 = state_16570__$1;
(statearr_16580_16590[(2)] = inst_16565);

(statearr_16580_16590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0 = (function (){
var statearr_16581 = [null,null,null,null,null,null,null];
(statearr_16581[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__);

(statearr_16581[(1)] = (1));

return statearr_16581;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1 = (function (state_16570){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16570);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16582){var ex__2749__auto__ = e16582;
var statearr_16583_16591 = state_16570;
(statearr_16583_16591[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16570[(4)]))){
var statearr_16584_16592 = state_16570;
(statearr_16584_16592[(1)] = cljs.core.first.call(null,(state_16570[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16593 = state_16570;
state_16570 = G__16593;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__ = function(state_16570){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1.call(this,state_16570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16585 = f__2769__auto__.call(null);
(statearr_16585[(6)] = c__2768__auto__);

return statearr_16585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,ledger_id,block_data){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16616){
var state_val_16617 = (state_16616[(1)]);
if((state_val_16617 === (1))){
var state_16616__$1 = state_16616;
var statearr_16618_16632 = state_16616__$1;
(statearr_16618_16632[(2)] = null);

(statearr_16618_16632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16617 === (2))){
var _ = (function (){var statearr_16619 = state_16616;
(statearr_16619[(4)] = cljs.core.cons.call(null,(5),(state_16616[(4)])));

return statearr_16619;
})();
var inst_16600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16601 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_16602 = (new cljs.core.PersistentVector(null,3,(5),inst_16600,inst_16601,null));
var inst_16603 = cljs.core.select_keys.call(null,block_data,inst_16602);
var inst_16604 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_16603);
var inst_16605 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,inst_16604);
var inst_16606 = fluree.db.storage.core.serde.call(null,conn);
var inst_16607 = fluree.db.serde.protocol._serialize_block.call(null,inst_16606,inst_16603);
var inst_16608 = fluree.db.storage.core.write.call(null,conn,inst_16605,inst_16607);
var state_16616__$1 = state_16616;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16616__$1,(6),inst_16608);
} else {
if((state_val_16617 === (3))){
var inst_16614 = (state_16616[(2)]);
var state_16616__$1 = state_16616;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16616__$1,inst_16614);
} else {
if((state_val_16617 === (4))){
var inst_16594 = (state_16616[(2)]);
var state_16616__$1 = state_16616;
var statearr_16621_16633 = state_16616__$1;
(statearr_16621_16633[(2)] = inst_16594);

(statearr_16621_16633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16617 === (5))){
var _ = (function (){var statearr_16622 = state_16616;
(statearr_16622[(4)] = cljs.core.rest.call(null,(state_16616[(4)])));

return statearr_16622;
})();
var state_16616__$1 = state_16616;
var ex16620 = (state_16616__$1[(2)]);
var statearr_16623_16634 = state_16616__$1;
(statearr_16623_16634[(5)] = ex16620);


if((ex16620 instanceof Error)){
var statearr_16624_16635 = state_16616__$1;
(statearr_16624_16635[(1)] = (4));

(statearr_16624_16635[(5)] = null);

} else {
throw ex16620;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16617 === (6))){
var inst_16610 = (state_16616[(2)]);
var inst_16611 = fluree.db.util.async.throw_err.call(null,inst_16610);
var _ = (function (){var statearr_16625 = state_16616;
(statearr_16625[(4)] = cljs.core.rest.call(null,(state_16616[(4)])));

return statearr_16625;
})();
var state_16616__$1 = state_16616;
var statearr_16626_16636 = state_16616__$1;
(statearr_16626_16636[(2)] = inst_16611);

(statearr_16626_16636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2746__auto____0 = (function (){
var statearr_16627 = [null,null,null,null,null,null,null];
(statearr_16627[(0)] = fluree$db$storage$core$write_block_$_state_machine__2746__auto__);

(statearr_16627[(1)] = (1));

return statearr_16627;
});
var fluree$db$storage$core$write_block_$_state_machine__2746__auto____1 = (function (state_16616){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16616);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16628){var ex__2749__auto__ = e16628;
var statearr_16629_16637 = state_16616;
(statearr_16629_16637[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16616[(4)]))){
var statearr_16630_16638 = state_16616;
(statearr_16630_16638[(1)] = cljs.core.first.call(null,(state_16616[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16639 = state_16616;
state_16616 = G__16639;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2746__auto__ = function(state_16616){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2746__auto____1.call(this,state_16616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16631 = f__2769__auto__.call(null);
(statearr_16631[(6)] = c__2768__auto__);

return statearr_16631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into
 *   storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.random_leaf_id = (function fluree$db$storage$core$random_leaf_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key.call(null,network,ledger_id,idx,cljs.core.random_uuid.call(null),"l");
});
/**
 * Writes `leaf` to storage under the provided `leaf-id`, computing a new id if
 *   one isn't provided. Returns the leaf map with the id used attached uner the
 *   `:id` key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(var_args){
var G__16641 = arguments.length;
switch (G__16641) {
case 5:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,leaf){
var leaf_id = fluree.db.storage.core.random_leaf_id.call(null,network,ledger_id,idx_type);
return fluree.db.storage.core.write_leaf.call(null,conn,network,ledger_id,idx_type,leaf_id,leaf);
}));

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,leaf_id,p__16642){
var map__16643 = p__16642;
var map__16643__$1 = cljs.core.__destructure_map.call(null,map__16643);
var leaf = map__16643__$1;
var flakes = cljs.core.get.call(null,map__16643__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16664){
var state_val_16665 = (state_16664[(1)]);
if((state_val_16665 === (1))){
var state_16664__$1 = state_16664;
var statearr_16666_16682 = state_16664__$1;
(statearr_16666_16682[(2)] = null);

(statearr_16666_16682[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (2))){
var _ = (function (){var statearr_16667 = state_16664;
(statearr_16667[(4)] = cljs.core.cons.call(null,(5),(state_16664[(4)])));

return statearr_16667;
})();
var inst_16650 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_16651 = [flakes];
var inst_16652 = cljs.core.PersistentHashMap.fromArrays(inst_16650,inst_16651);
var inst_16653 = fluree.db.storage.core.serde.call(null,conn);
var inst_16654 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_16653,inst_16652);
var inst_16655 = fluree.db.storage.core.write.call(null,conn,leaf_id,inst_16654);
var state_16664__$1 = state_16664;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16664__$1,(6),inst_16655);
} else {
if((state_val_16665 === (3))){
var inst_16662 = (state_16664[(2)]);
var state_16664__$1 = state_16664;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16664__$1,inst_16662);
} else {
if((state_val_16665 === (4))){
var inst_16644 = (state_16664[(2)]);
var state_16664__$1 = state_16664;
var statearr_16669_16683 = state_16664__$1;
(statearr_16669_16683[(2)] = inst_16644);

(statearr_16669_16683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (5))){
var _ = (function (){var statearr_16670 = state_16664;
(statearr_16670[(4)] = cljs.core.rest.call(null,(state_16664[(4)])));

return statearr_16670;
})();
var state_16664__$1 = state_16664;
var ex16668 = (state_16664__$1[(2)]);
var statearr_16671_16684 = state_16664__$1;
(statearr_16671_16684[(5)] = ex16668);


if((ex16668 instanceof Error)){
var statearr_16672_16685 = state_16664__$1;
(statearr_16672_16685[(1)] = (4));

(statearr_16672_16685[(5)] = null);

} else {
throw ex16668;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (6))){
var inst_16657 = (state_16664[(2)]);
var inst_16658 = fluree.db.util.async.throw_err.call(null,inst_16657);
var inst_16659 = cljs.core.assoc.call(null,leaf,new cljs.core.Keyword(null,"id","id",-1388402092),leaf_id);
var _ = (function (){var statearr_16673 = state_16664;
(statearr_16673[(4)] = cljs.core.rest.call(null,(state_16664[(4)])));

return statearr_16673;
})();
var state_16664__$1 = (function (){var statearr_16674 = state_16664;
(statearr_16674[(7)] = inst_16658);

return statearr_16674;
})();
var statearr_16675_16686 = state_16664__$1;
(statearr_16675_16686[(2)] = inst_16659);

(statearr_16675_16686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_16676 = [null,null,null,null,null,null,null,null];
(statearr_16676[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_16676[(1)] = (1));

return statearr_16676;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_16664){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16664);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16677){var ex__2749__auto__ = e16677;
var statearr_16678_16687 = state_16664;
(statearr_16678_16687[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16664[(4)]))){
var statearr_16679_16688 = state_16664;
(statearr_16679_16688[(1)] = cljs.core.first.call(null,(state_16664[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16689 = state_16664;
state_16664 = G__16689;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_16664){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_16664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16680 = f__2769__auto__.call(null);
(statearr_16680[(6)] = c__2768__auto__);

return statearr_16680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.storage.core.write_leaf.cljs$lang$maxFixedArity = 6);

/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16706){
var state_val_16707 = (state_16706[(1)]);
if((state_val_16707 === (1))){
var state_16706__$1 = state_16706;
var statearr_16708_16723 = state_16706__$1;
(statearr_16708_16723[(2)] = null);

(statearr_16708_16723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16707 === (2))){
var _ = (function (){var statearr_16709 = state_16706;
(statearr_16709[(4)] = cljs.core.cons.call(null,(5),(state_16706[(4)])));

return statearr_16709;
})();
var inst_16696 = fluree.db.storage.core.serde.call(null,conn);
var inst_16697 = fluree.db.serde.protocol._serialize_branch.call(null,inst_16696,data);
var inst_16698 = fluree.db.storage.core.write.call(null,conn,key,inst_16697);
var state_16706__$1 = state_16706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16706__$1,(6),inst_16698);
} else {
if((state_val_16707 === (3))){
var inst_16704 = (state_16706[(2)]);
var state_16706__$1 = state_16706;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16706__$1,inst_16704);
} else {
if((state_val_16707 === (4))){
var inst_16690 = (state_16706[(2)]);
var state_16706__$1 = state_16706;
var statearr_16711_16724 = state_16706__$1;
(statearr_16711_16724[(2)] = inst_16690);

(statearr_16711_16724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16707 === (5))){
var _ = (function (){var statearr_16712 = state_16706;
(statearr_16712[(4)] = cljs.core.rest.call(null,(state_16706[(4)])));

return statearr_16712;
})();
var state_16706__$1 = state_16706;
var ex16710 = (state_16706__$1[(2)]);
var statearr_16713_16725 = state_16706__$1;
(statearr_16713_16725[(5)] = ex16710);


if((ex16710 instanceof Error)){
var statearr_16714_16726 = state_16706__$1;
(statearr_16714_16726[(1)] = (4));

(statearr_16714_16726[(5)] = null);

} else {
throw ex16710;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16707 === (6))){
var inst_16700 = (state_16706[(2)]);
var inst_16701 = fluree.db.util.async.throw_err.call(null,inst_16700);
var _ = (function (){var statearr_16715 = state_16706;
(statearr_16715[(4)] = cljs.core.rest.call(null,(state_16706[(4)])));

return statearr_16715;
})();
var state_16706__$1 = (function (){var statearr_16716 = state_16706;
(statearr_16716[(7)] = inst_16701);

return statearr_16716;
})();
var statearr_16717_16727 = state_16706__$1;
(statearr_16717_16727[(2)] = key);

(statearr_16717_16727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0 = (function (){
var statearr_16718 = [null,null,null,null,null,null,null,null];
(statearr_16718[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__);

(statearr_16718[(1)] = (1));

return statearr_16718;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1 = (function (state_16706){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16706);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16719){var ex__2749__auto__ = e16719;
var statearr_16720_16728 = state_16706;
(statearr_16720_16728[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16706[(4)]))){
var statearr_16721_16729 = state_16706;
(statearr_16721_16729[(1)] = cljs.core.first.call(null,(state_16706[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16730 = state_16706;
state_16706 = G__16730;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__ = function(state_16706){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1.call(this,state_16706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16722 = f__2769__auto__.call(null);
(statearr_16722[(6)] = c__2768__auto__);

return statearr_16722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.random_branch_id = (function fluree$db$storage$core$random_branch_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key.call(null,network,ledger_id,idx,cljs.core.random_uuid.call(null),"b");
});
/**
 * Writes `branch` to storage under the provided `branch-id`, computing a new id
 *   if one isn't provided. Returns the branch map with the id used attached uner
 *   the `:id` key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(var_args){
var G__16732 = arguments.length;
switch (G__16732) {
case 5:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,branch){
var branch_id = fluree.db.storage.core.random_branch_id.call(null,network,ledger_id,idx_type);
return fluree.db.storage.core.write_branch.call(null,conn,network,ledger_id,idx_type,branch_id,branch);
}));

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,branch_id,p__16733){
var map__16734 = p__16733;
var map__16734__$1 = cljs.core.__destructure_map.call(null,map__16734);
var branch = map__16734__$1;
var children = cljs.core.get.call(null,map__16734__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16760){
var state_val_16761 = (state_16760[(1)]);
if((state_val_16761 === (1))){
var state_16760__$1 = state_16760;
var statearr_16762_16779 = state_16760__$1;
(statearr_16762_16779[(2)] = null);

(statearr_16762_16779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16761 === (2))){
var _ = (function (){var statearr_16763 = state_16760;
(statearr_16763[(4)] = cljs.core.cons.call(null,(5),(state_16760[(4)])));

return statearr_16763;
})();
var inst_16741 = cljs.core.map.call(null,cljs.core.val,children);
var inst_16742 = cljs.core.mapv.call(null,fluree.db.storage.core.child_data,inst_16741);
var inst_16743 = cljs.core.first.call(null,inst_16742);
var inst_16744 = new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(inst_16743);
var inst_16745 = cljs.core.rseq.call(null,inst_16742);
var inst_16746 = cljs.core.first.call(null,inst_16745);
var inst_16747 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_16746);
var inst_16748 = [new cljs.core.Keyword(null,"children","children",-940561982)];
var inst_16749 = [inst_16742];
var inst_16750 = cljs.core.PersistentHashMap.fromArrays(inst_16748,inst_16749);
var inst_16751 = fluree.db.storage.core.write_branch_data.call(null,conn,branch_id,inst_16750);
var state_16760__$1 = (function (){var statearr_16764 = state_16760;
(statearr_16764[(7)] = inst_16744);

(statearr_16764[(8)] = inst_16747);

return statearr_16764;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16760__$1,(6),inst_16751);
} else {
if((state_val_16761 === (3))){
var inst_16758 = (state_16760[(2)]);
var state_16760__$1 = state_16760;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16760__$1,inst_16758);
} else {
if((state_val_16761 === (4))){
var inst_16735 = (state_16760[(2)]);
var state_16760__$1 = state_16760;
var statearr_16766_16780 = state_16760__$1;
(statearr_16766_16780[(2)] = inst_16735);

(statearr_16766_16780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16761 === (5))){
var _ = (function (){var statearr_16767 = state_16760;
(statearr_16767[(4)] = cljs.core.rest.call(null,(state_16760[(4)])));

return statearr_16767;
})();
var state_16760__$1 = state_16760;
var ex16765 = (state_16760__$1[(2)]);
var statearr_16768_16781 = state_16760__$1;
(statearr_16768_16781[(5)] = ex16765);


if((ex16765 instanceof Error)){
var statearr_16769_16782 = state_16760__$1;
(statearr_16769_16782[(1)] = (4));

(statearr_16769_16782[(5)] = null);

} else {
throw ex16765;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16761 === (6))){
var inst_16753 = (state_16760[(2)]);
var inst_16754 = fluree.db.util.async.throw_err.call(null,inst_16753);
var inst_16755 = cljs.core.assoc.call(null,branch,new cljs.core.Keyword(null,"id","id",-1388402092),branch_id);
var _ = (function (){var statearr_16770 = state_16760;
(statearr_16770[(4)] = cljs.core.rest.call(null,(state_16760[(4)])));

return statearr_16770;
})();
var state_16760__$1 = (function (){var statearr_16771 = state_16760;
(statearr_16771[(9)] = inst_16754);

return statearr_16771;
})();
var statearr_16772_16783 = state_16760__$1;
(statearr_16772_16783[(2)] = inst_16755);

(statearr_16772_16783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_16773 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16773[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_16773[(1)] = (1));

return statearr_16773;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_16760){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16760);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16774){var ex__2749__auto__ = e16774;
var statearr_16775_16784 = state_16760;
(statearr_16775_16784[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16760[(4)]))){
var statearr_16776_16785 = state_16760;
(statearr_16776_16785[(1)] = cljs.core.first.call(null,(state_16760[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16786 = state_16760;
state_16760 = G__16786;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_16760){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_16760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16777 = f__2769__auto__.call(null);
(statearr_16777[(6)] = c__2768__auto__);

return statearr_16777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.storage.core.write_branch.cljs$lang$maxFixedArity = 6);

/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,garbage){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16814){
var state_val_16815 = (state_16814[(1)]);
if((state_val_16815 === (1))){
var state_16814__$1 = state_16814;
var statearr_16816_16832 = state_16814__$1;
(statearr_16816_16832[(2)] = null);

(statearr_16816_16832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16815 === (2))){
var inst_16800 = (state_16814[(7)]);
var _ = (function (){var statearr_16817 = state_16814;
(statearr_16817[(4)] = cljs.core.cons.call(null,(5),(state_16814[(4)])));

return statearr_16817;
})();
var inst_16794 = db;
var inst_16795 = cljs.core.__destructure_map.call(null,inst_16794);
var inst_16796 = cljs.core.get.call(null,inst_16795,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_16797 = cljs.core.get.call(null,inst_16795,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_16798 = cljs.core.get.call(null,inst_16795,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_16799 = cljs.core.get.call(null,inst_16795,new cljs.core.Keyword(null,"block","block",664686210));
var inst_16800__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_16797,inst_16798,inst_16799);
var inst_16801 = [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_16802 = [inst_16798,inst_16799,garbage];
var inst_16803 = cljs.core.PersistentHashMap.fromArrays(inst_16801,inst_16802);
var inst_16804 = fluree.db.storage.core.serde.call(null,inst_16796);
var inst_16805 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_16804,inst_16803);
var inst_16806 = fluree.db.storage.core.write.call(null,inst_16796,inst_16800__$1,inst_16805);
var state_16814__$1 = (function (){var statearr_16818 = state_16814;
(statearr_16818[(7)] = inst_16800__$1);

return statearr_16818;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16814__$1,(6),inst_16806);
} else {
if((state_val_16815 === (3))){
var inst_16812 = (state_16814[(2)]);
var state_16814__$1 = state_16814;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16814__$1,inst_16812);
} else {
if((state_val_16815 === (4))){
var inst_16787 = (state_16814[(2)]);
var state_16814__$1 = state_16814;
var statearr_16820_16833 = state_16814__$1;
(statearr_16820_16833[(2)] = inst_16787);

(statearr_16820_16833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16815 === (5))){
var _ = (function (){var statearr_16821 = state_16814;
(statearr_16821[(4)] = cljs.core.rest.call(null,(state_16814[(4)])));

return statearr_16821;
})();
var state_16814__$1 = state_16814;
var ex16819 = (state_16814__$1[(2)]);
var statearr_16822_16834 = state_16814__$1;
(statearr_16822_16834[(5)] = ex16819);


if((ex16819 instanceof Error)){
var statearr_16823_16835 = state_16814__$1;
(statearr_16823_16835[(1)] = (4));

(statearr_16823_16835[(5)] = null);

} else {
throw ex16819;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16815 === (6))){
var inst_16800 = (state_16814[(7)]);
var inst_16808 = (state_16814[(2)]);
var inst_16809 = fluree.db.util.async.throw_err.call(null,inst_16808);
var _ = (function (){var statearr_16824 = state_16814;
(statearr_16824[(4)] = cljs.core.rest.call(null,(state_16814[(4)])));

return statearr_16824;
})();
var state_16814__$1 = (function (){var statearr_16825 = state_16814;
(statearr_16825[(8)] = inst_16809);

return statearr_16825;
})();
var statearr_16826_16836 = state_16814__$1;
(statearr_16826_16836[(2)] = inst_16800);

(statearr_16826_16836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0 = (function (){
var statearr_16827 = [null,null,null,null,null,null,null,null,null];
(statearr_16827[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__);

(statearr_16827[(1)] = (1));

return statearr_16827;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1 = (function (state_16814){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16814);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16828){var ex__2749__auto__ = e16828;
var statearr_16829_16837 = state_16814;
(statearr_16829_16837[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16814[(4)]))){
var statearr_16830_16838 = state_16814;
(statearr_16830_16838[(1)] = cljs.core.first.call(null,(state_16814[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16839 = state_16814;
state_16814 = G__16839;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__ = function(state_16814){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1.call(this,state_16814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16831 = f__2769__auto__.call(null);
(statearr_16831[(6)] = c__2768__auto__);

return statearr_16831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__16841 = arguments.length;
switch (G__16841) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16899){
var state_val_16900 = (state_16899[(1)]);
if((state_val_16900 === (7))){
var state_16899__$1 = state_16899;
var statearr_16901_16927 = state_16899__$1;
(statearr_16901_16927[(2)] = (0));

(statearr_16901_16927[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16900 === (1))){
var state_16899__$1 = state_16899;
var statearr_16902_16928 = state_16899__$1;
(statearr_16902_16928[(2)] = null);

(statearr_16902_16928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16900 === (4))){
var inst_16842 = (state_16899[(2)]);
var state_16899__$1 = state_16899;
var statearr_16903_16929 = state_16899__$1;
(statearr_16903_16929[(2)] = inst_16842);

(statearr_16903_16929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16900 === (6))){
var inst_16868 = (state_16899[(7)]);
var state_16899__$1 = state_16899;
var statearr_16904_16930 = state_16899__$1;
(statearr_16904_16930[(2)] = inst_16868);

(statearr_16904_16930[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16900 === (3))){
var inst_16897 = (state_16899[(2)]);
var state_16899__$1 = state_16899;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16899__$1,inst_16897);
} else {
if((state_val_16900 === (12))){
var inst_16865 = (state_16899[(8)]);
var inst_16893 = (state_16899[(2)]);
var inst_16894 = fluree.db.util.async.throw_err.call(null,inst_16893);
var _ = (function (){var statearr_16905 = state_16899;
(statearr_16905[(4)] = cljs.core.rest.call(null,(state_16899[(4)])));

return statearr_16905;
})();
var state_16899__$1 = (function (){var statearr_16906 = state_16899;
(statearr_16906[(9)] = inst_16894);

return statearr_16906;
})();
var statearr_16907_16931 = state_16899__$1;
(statearr_16907_16931[(2)] = inst_16865);

(statearr_16907_16931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16900 === (2))){
var inst_16860 = (state_16899[(10)]);
var inst_16868 = (state_16899[(7)]);
var inst_16855 = (state_16899[(11)]);
var inst_16857 = (state_16899[(12)]);
var _ = (function (){var statearr_16908 = state_16899;
(statearr_16908[(4)] = cljs.core.cons.call(null,(5),(state_16899[(4)])));

return statearr_16908;
})();
var inst_16849 = db;
var inst_16850 = cljs.core.__destructure_map.call(null,inst_16849);
var inst_16851 = cljs.core.get.call(null,inst_16850,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_16852 = cljs.core.get.call(null,inst_16850,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_16853 = cljs.core.get.call(null,inst_16850,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_16854 = cljs.core.get.call(null,inst_16850,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_16855__$1 = cljs.core.get.call(null,inst_16850,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_16856 = cljs.core.get.call(null,inst_16850,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_16857__$1 = cljs.core.get.call(null,inst_16850,new cljs.core.Keyword(null,"block","block",664686210));
var inst_16858 = cljs.core.get.call(null,inst_16850,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_16859 = cljs.core.get.call(null,inst_16850,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var inst_16860__$1 = cljs.core.get.call(null,inst_16850,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_16861 = cljs.core.get.call(null,inst_16850,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_16862 = cljs.core.get.call(null,inst_16850,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_16863 = cljs.core.get.call(null,inst_16850,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_16864 = cljs.core.get.call(null,inst_16850,new cljs.core.Keyword(null,"post","post",269697687));
var inst_16865 = fluree.db.storage.core.ledger_root_key.call(null,inst_16851,inst_16860__$1,inst_16857__$1);
var inst_16866 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_16867 = fluree.db.storage.core.child_data.call(null,inst_16858);
var inst_16868__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_16855__$1);
var state_16899__$1 = (function (){var statearr_16909 = state_16899;
(statearr_16909[(13)] = inst_16862);

(statearr_16909[(10)] = inst_16860__$1);

(statearr_16909[(8)] = inst_16865);

(statearr_16909[(14)] = inst_16852);

(statearr_16909[(15)] = inst_16863);

(statearr_16909[(16)] = inst_16866);

(statearr_16909[(17)] = inst_16859);

(statearr_16909[(7)] = inst_16868__$1);

(statearr_16909[(11)] = inst_16855__$1);

(statearr_16909[(18)] = inst_16853);

(statearr_16909[(19)] = inst_16861);

(statearr_16909[(20)] = inst_16864);

(statearr_16909[(21)] = inst_16854);

(statearr_16909[(22)] = inst_16867);

(statearr_16909[(23)] = inst_16856);

(statearr_16909[(12)] = inst_16857__$1);

return statearr_16909;
})();
if(cljs.core.truth_(inst_16868__$1)){
var statearr_16910_16932 = state_16899__$1;
(statearr_16910_16932[(1)] = (6));

} else {
var statearr_16911_16933 = state_16899__$1;
(statearr_16911_16933[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16900 === (11))){
var inst_16862 = (state_16899[(13)]);
var inst_16860 = (state_16899[(10)]);
var inst_16865 = (state_16899[(8)]);
var inst_16852 = (state_16899[(14)]);
var inst_16863 = (state_16899[(15)]);
var inst_16866 = (state_16899[(16)]);
var inst_16873 = (state_16899[(24)]);
var inst_16872 = (state_16899[(25)]);
var inst_16855 = (state_16899[(11)]);
var inst_16853 = (state_16899[(18)]);
var inst_16864 = (state_16899[(20)]);
var inst_16854 = (state_16899[(21)]);
var inst_16867 = (state_16899[(22)]);
var inst_16856 = (state_16899[(23)]);
var inst_16857 = (state_16899[(12)]);
var inst_16878 = (state_16899[(2)]);
var inst_16879 = fluree.db.storage.core.child_data.call(null,inst_16862);
var inst_16880 = fluree.db.storage.core.child_data.call(null,inst_16864);
var inst_16881 = fluree.db.util.core.current_time_millis.call(null);
var inst_16882 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16883 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_16884 = (new cljs.core.PersistentVector(null,2,(5),inst_16882,inst_16883,null));
var inst_16885 = cljs.core.select_keys.call(null,inst_16855,inst_16884);
var inst_16886 = fluree.db.storage.core.child_data.call(null,inst_16854);
var inst_16887 = [inst_16857,inst_16867,inst_16872,inst_16860,inst_16873,inst_16878,inst_16879,inst_16880,inst_16852,inst_16881,inst_16853,inst_16863,inst_16885,inst_16886];
var inst_16888 = cljs.core.PersistentHashMap.fromArrays(inst_16866,inst_16887);
var inst_16889 = fluree.db.storage.core.serde.call(null,inst_16856);
var inst_16890 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_16889,inst_16888);
var inst_16891 = fluree.db.storage.core.write.call(null,inst_16856,inst_16865,inst_16890);
var state_16899__$1 = state_16899;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16899__$1,(12),inst_16891);
} else {
if((state_val_16900 === (9))){
var inst_16874 = (state_16899[(26)]);
var state_16899__$1 = state_16899;
var statearr_16913_16934 = state_16899__$1;
(statearr_16913_16934[(2)] = inst_16874);

(statearr_16913_16934[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16900 === (5))){
var _ = (function (){var statearr_16914 = state_16899;
(statearr_16914[(4)] = cljs.core.rest.call(null,(state_16899[(4)])));

return statearr_16914;
})();
var state_16899__$1 = state_16899;
var ex16912 = (state_16899__$1[(2)]);
var statearr_16915_16935 = state_16899__$1;
(statearr_16915_16935[(5)] = ex16912);


if((ex16912 instanceof Error)){
var statearr_16916_16936 = state_16899__$1;
(statearr_16916_16936[(1)] = (4));

(statearr_16916_16936[(5)] = null);

} else {
throw ex16912;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16900 === (10))){
var inst_16861 = (state_16899[(19)]);
var state_16899__$1 = state_16899;
var statearr_16917_16937 = state_16899__$1;
(statearr_16917_16937[(2)] = inst_16861);

(statearr_16917_16937[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16900 === (8))){
var inst_16859 = (state_16899[(17)]);
var inst_16874 = (state_16899[(26)]);
var inst_16872 = (state_16899[(2)]);
var inst_16873 = fluree.db.storage.core.child_data.call(null,inst_16859);
var inst_16874__$1 = custom_ecount;
var state_16899__$1 = (function (){var statearr_16918 = state_16899;
(statearr_16918[(24)] = inst_16873);

(statearr_16918[(25)] = inst_16872);

(statearr_16918[(26)] = inst_16874__$1);

return statearr_16918;
})();
if(cljs.core.truth_(inst_16874__$1)){
var statearr_16919_16938 = state_16899__$1;
(statearr_16919_16938[(1)] = (9));

} else {
var statearr_16920_16939 = state_16899__$1;
(statearr_16920_16939[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_16921 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16921[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_16921[(1)] = (1));

return statearr_16921;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_16899){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16899);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16922){var ex__2749__auto__ = e16922;
var statearr_16923_16940 = state_16899;
(statearr_16923_16940[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16899[(4)]))){
var statearr_16924_16941 = state_16899;
(statearr_16924_16941[(1)] = cljs.core.first.call(null,(state_16899[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16942 = state_16899;
state_16899 = G__16942;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_16899){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_16899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16925 = f__2769__auto__.call(null);
(statearr_16925[(6)] = c__2768__auto__);

return statearr_16925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(p__16943,key){
var map__16944 = p__16943;
var map__16944__$1 = cljs.core.__destructure_map.call(null,map__16944);
var conn = map__16944__$1;
var serializer = cljs.core.get.call(null,map__16944__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16964){
var state_val_16965 = (state_16964[(1)]);
if((state_val_16965 === (7))){
var inst_16954 = (state_16964[(7)]);
var inst_16956 = fluree.db.serde.protocol._deserialize_branch.call(null,serializer,inst_16954);
var state_16964__$1 = state_16964;
var statearr_16966_16985 = state_16964__$1;
(statearr_16966_16985[(2)] = inst_16956);

(statearr_16966_16985[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16965 === (1))){
var state_16964__$1 = state_16964;
var statearr_16967_16986 = state_16964__$1;
(statearr_16967_16986[(2)] = null);

(statearr_16967_16986[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16965 === (4))){
var inst_16945 = (state_16964[(2)]);
var state_16964__$1 = state_16964;
var statearr_16968_16987 = state_16964__$1;
(statearr_16968_16987[(2)] = inst_16945);

(statearr_16968_16987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16965 === (6))){
var inst_16954 = (state_16964[(7)]);
var inst_16953 = (state_16964[(2)]);
var inst_16954__$1 = fluree.db.util.async.throw_err.call(null,inst_16953);
var state_16964__$1 = (function (){var statearr_16969 = state_16964;
(statearr_16969[(7)] = inst_16954__$1);

return statearr_16969;
})();
if(cljs.core.truth_(inst_16954__$1)){
var statearr_16970_16988 = state_16964__$1;
(statearr_16970_16988[(1)] = (7));

} else {
var statearr_16971_16989 = state_16964__$1;
(statearr_16971_16989[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16965 === (3))){
var inst_16962 = (state_16964[(2)]);
var state_16964__$1 = state_16964;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16964__$1,inst_16962);
} else {
if((state_val_16965 === (2))){
var _ = (function (){var statearr_16973 = state_16964;
(statearr_16973[(4)] = cljs.core.cons.call(null,(5),(state_16964[(4)])));

return statearr_16973;
})();
var inst_16951 = fluree.db.storage.core.read.call(null,conn,key);
var state_16964__$1 = state_16964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16964__$1,(6),inst_16951);
} else {
if((state_val_16965 === (9))){
var inst_16959 = (state_16964[(2)]);
var _ = (function (){var statearr_16974 = state_16964;
(statearr_16974[(4)] = cljs.core.rest.call(null,(state_16964[(4)])));

return statearr_16974;
})();
var state_16964__$1 = state_16964;
var statearr_16975_16990 = state_16964__$1;
(statearr_16975_16990[(2)] = inst_16959);

(statearr_16975_16990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16965 === (5))){
var _ = (function (){var statearr_16976 = state_16964;
(statearr_16976[(4)] = cljs.core.rest.call(null,(state_16964[(4)])));

return statearr_16976;
})();
var state_16964__$1 = state_16964;
var ex16972 = (state_16964__$1[(2)]);
var statearr_16977_16991 = state_16964__$1;
(statearr_16977_16991[(5)] = ex16972);


if((ex16972 instanceof Error)){
var statearr_16978_16992 = state_16964__$1;
(statearr_16978_16992[(1)] = (4));

(statearr_16978_16992[(5)] = null);

} else {
throw ex16972;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16965 === (8))){
var state_16964__$1 = state_16964;
var statearr_16979_16993 = state_16964__$1;
(statearr_16979_16993[(2)] = null);

(statearr_16979_16993[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0 = (function (){
var statearr_16980 = [null,null,null,null,null,null,null,null];
(statearr_16980[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2746__auto__);

(statearr_16980[(1)] = (1));

return statearr_16980;
});
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1 = (function (state_16964){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16964);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16981){var ex__2749__auto__ = e16981;
var statearr_16982_16994 = state_16964;
(statearr_16982_16994[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16964[(4)]))){
var statearr_16983_16995 = state_16964;
(statearr_16983_16995[(1)] = cljs.core.first.call(null,(state_16964[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16996 = state_16964;
state_16964 = G__16996;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__ = function(state_16964){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1.call(this,state_16964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16984 = f__2769__auto__.call(null);
(statearr_16984[(6)] = c__2768__auto__);

return statearr_16984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(p__16997,key){
var map__16998 = p__16997;
var map__16998__$1 = cljs.core.__destructure_map.call(null,map__16998);
var conn = map__16998__$1;
var serializer = cljs.core.get.call(null,map__16998__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17018){
var state_val_17019 = (state_17018[(1)]);
if((state_val_17019 === (7))){
var inst_17008 = (state_17018[(7)]);
var inst_17010 = fluree.db.serde.protocol._deserialize_leaf.call(null,serializer,inst_17008);
var state_17018__$1 = state_17018;
var statearr_17020_17039 = state_17018__$1;
(statearr_17020_17039[(2)] = inst_17010);

(statearr_17020_17039[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17019 === (1))){
var state_17018__$1 = state_17018;
var statearr_17021_17040 = state_17018__$1;
(statearr_17021_17040[(2)] = null);

(statearr_17021_17040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17019 === (4))){
var inst_16999 = (state_17018[(2)]);
var state_17018__$1 = state_17018;
var statearr_17022_17041 = state_17018__$1;
(statearr_17022_17041[(2)] = inst_16999);

(statearr_17022_17041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17019 === (6))){
var inst_17008 = (state_17018[(7)]);
var inst_17007 = (state_17018[(2)]);
var inst_17008__$1 = fluree.db.util.async.throw_err.call(null,inst_17007);
var state_17018__$1 = (function (){var statearr_17023 = state_17018;
(statearr_17023[(7)] = inst_17008__$1);

return statearr_17023;
})();
if(cljs.core.truth_(inst_17008__$1)){
var statearr_17024_17042 = state_17018__$1;
(statearr_17024_17042[(1)] = (7));

} else {
var statearr_17025_17043 = state_17018__$1;
(statearr_17025_17043[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17019 === (3))){
var inst_17016 = (state_17018[(2)]);
var state_17018__$1 = state_17018;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17018__$1,inst_17016);
} else {
if((state_val_17019 === (2))){
var _ = (function (){var statearr_17027 = state_17018;
(statearr_17027[(4)] = cljs.core.cons.call(null,(5),(state_17018[(4)])));

return statearr_17027;
})();
var inst_17005 = fluree.db.storage.core.read.call(null,conn,key);
var state_17018__$1 = state_17018;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17018__$1,(6),inst_17005);
} else {
if((state_val_17019 === (9))){
var inst_17013 = (state_17018[(2)]);
var _ = (function (){var statearr_17028 = state_17018;
(statearr_17028[(4)] = cljs.core.rest.call(null,(state_17018[(4)])));

return statearr_17028;
})();
var state_17018__$1 = state_17018;
var statearr_17029_17044 = state_17018__$1;
(statearr_17029_17044[(2)] = inst_17013);

(statearr_17029_17044[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17019 === (5))){
var _ = (function (){var statearr_17030 = state_17018;
(statearr_17030[(4)] = cljs.core.rest.call(null,(state_17018[(4)])));

return statearr_17030;
})();
var state_17018__$1 = state_17018;
var ex17026 = (state_17018__$1[(2)]);
var statearr_17031_17045 = state_17018__$1;
(statearr_17031_17045[(5)] = ex17026);


if((ex17026 instanceof Error)){
var statearr_17032_17046 = state_17018__$1;
(statearr_17032_17046[(1)] = (4));

(statearr_17032_17046[(5)] = null);

} else {
throw ex17026;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17019 === (8))){
var state_17018__$1 = state_17018;
var statearr_17033_17047 = state_17018__$1;
(statearr_17033_17047[(2)] = null);

(statearr_17033_17047[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0 = (function (){
var statearr_17034 = [null,null,null,null,null,null,null,null];
(statearr_17034[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__);

(statearr_17034[(1)] = (1));

return statearr_17034;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1 = (function (state_17018){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17018);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17035){var ex__2749__auto__ = e17035;
var statearr_17036_17048 = state_17018;
(statearr_17036_17048[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17018[(4)]))){
var statearr_17037_17049 = state_17018;
(statearr_17037_17049[(1)] = cljs.core.first.call(null,(state_17018[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17050 = state_17018;
state_17018 = G__17050;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__ = function(state_17018){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1.call(this,state_17018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17038 = f__2769__auto__.call(null);
(statearr_17038[(6)] = c__2768__auto__);

return statearr_17038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(_conn,p__17051,index,index_data){
var map__17052 = p__17051;
var map__17052__$1 = cljs.core.__destructure_map.call(null,map__17052);
var network = cljs.core.get.call(null,map__17052__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__17052__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var comparators = cljs.core.get.call(null,map__17052__$1,new cljs.core.Keyword(null,"comparators","comparators",-1325611955));
var block = cljs.core.get.call(null,map__17052__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__17052__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var cmp = (function (){var or__4253__auto__ = cljs.core.get.call(null,comparators,index);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db index root: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
var G__17053 = index_data;
var G__17053__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.call(null,G__17053,new cljs.core.Keyword(null,"rhs","rhs",-229356739),fluree.db.flake.parts__GT_Flake):G__17053);
var G__17053__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.call(null,G__17053__$1,new cljs.core.Keyword(null,"first","first",-644103046),fluree.db.flake.parts__GT_Flake):G__17053__$1);
return cljs.core.assoc.call(null,G__17053__$2,new cljs.core.Keyword(null,"comparator","comparator",2144896662),cmp,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true);

});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__17054 = root_data;
var map__17054__$1 = cljs.core.__destructure_map.call(null,map__17054);
var block = cljs.core.get.call(null,map__17054__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__17054__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__17054__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__17054__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
var idx_root = fluree.db.storage.core.reify_index_root.call(null,conn,db,idx,cljs.core.get.call(null,root_data,idx));
return cljs.core.assoc.call(null,db,idx,idx_root);
}),db_STAR_,fluree.db.index.types);
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,ledger_id,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17076){
var state_val_17077 = (state_17076[(1)]);
if((state_val_17077 === (7))){
var state_17076__$1 = state_17076;
var statearr_17078_17098 = state_17076__$1;
(statearr_17078_17098[(2)] = null);

(statearr_17078_17098[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17077 === (1))){
var state_17076__$1 = state_17076;
var statearr_17079_17099 = state_17076__$1;
(statearr_17079_17099[(2)] = null);

(statearr_17079_17099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17077 === (4))){
var inst_17055 = (state_17076[(2)]);
var state_17076__$1 = state_17076;
var statearr_17080_17100 = state_17076__$1;
(statearr_17080_17100[(2)] = inst_17055);

(statearr_17080_17100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17077 === (6))){
var inst_17062 = (state_17076[(7)]);
var inst_17064 = fluree.db.storage.core.serde.call(null,conn);
var state_17076__$1 = (function (){var statearr_17081 = state_17076;
(statearr_17081[(8)] = inst_17064);

return statearr_17081;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17076__$1,(9),inst_17062);
} else {
if((state_val_17077 === (3))){
var inst_17074 = (state_17076[(2)]);
var state_17076__$1 = state_17076;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17076__$1,inst_17074);
} else {
if((state_val_17077 === (2))){
var inst_17062 = (state_17076[(7)]);
var _ = (function (){var statearr_17083 = state_17076;
(statearr_17083[(4)] = cljs.core.cons.call(null,(5),(state_17076[(4)])));

return statearr_17083;
})();
var inst_17061 = fluree.db.storage.core.ledger_garbage_key.call(null,network,ledger_id,block);
var inst_17062__$1 = fluree.db.storage.core.read.call(null,conn,inst_17061);
var state_17076__$1 = (function (){var statearr_17084 = state_17076;
(statearr_17084[(7)] = inst_17062__$1);

return statearr_17084;
})();
if(cljs.core.truth_(inst_17062__$1)){
var statearr_17085_17101 = state_17076__$1;
(statearr_17085_17101[(1)] = (6));

} else {
var statearr_17086_17102 = state_17076__$1;
(statearr_17086_17102[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17077 === (9))){
var inst_17064 = (state_17076[(8)]);
var inst_17066 = (state_17076[(2)]);
var inst_17067 = fluree.db.util.async.throw_err.call(null,inst_17066);
var inst_17068 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_17064,inst_17067);
var state_17076__$1 = state_17076;
var statearr_17087_17103 = state_17076__$1;
(statearr_17087_17103[(2)] = inst_17068);

(statearr_17087_17103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17077 === (5))){
var _ = (function (){var statearr_17088 = state_17076;
(statearr_17088[(4)] = cljs.core.rest.call(null,(state_17076[(4)])));

return statearr_17088;
})();
var state_17076__$1 = state_17076;
var ex17082 = (state_17076__$1[(2)]);
var statearr_17089_17104 = state_17076__$1;
(statearr_17089_17104[(5)] = ex17082);


if((ex17082 instanceof Error)){
var statearr_17090_17105 = state_17076__$1;
(statearr_17090_17105[(1)] = (4));

(statearr_17090_17105[(5)] = null);

} else {
throw ex17082;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17077 === (8))){
var inst_17071 = (state_17076[(2)]);
var _ = (function (){var statearr_17091 = state_17076;
(statearr_17091[(4)] = cljs.core.rest.call(null,(state_17076[(4)])));

return statearr_17091;
})();
var state_17076__$1 = state_17076;
var statearr_17092_17106 = state_17076__$1;
(statearr_17092_17106[(2)] = inst_17071);

(statearr_17092_17106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0 = (function (){
var statearr_17093 = [null,null,null,null,null,null,null,null,null];
(statearr_17093[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__);

(statearr_17093[(1)] = (1));

return statearr_17093;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1 = (function (state_17076){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17076);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17094){var ex__2749__auto__ = e17094;
var statearr_17095_17107 = state_17076;
(statearr_17095_17107[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17076[(4)]))){
var statearr_17096_17108 = state_17076;
(statearr_17096_17108[(1)] = cljs.core.first.call(null,(state_17076[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17109 = state_17076;
state_17076 = G__17109;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__ = function(state_17076){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1.call(this,state_17076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17097 = f__2769__auto__.call(null);
(statearr_17097[(6)] = c__2768__auto__);

return statearr_17097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,ledger_id,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17131){
var state_val_17132 = (state_17131[(1)]);
if((state_val_17132 === (7))){
var inst_17120 = (state_17131[(7)]);
var inst_17122 = fluree.db.storage.core.serde.call(null,conn);
var inst_17123 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_17122,inst_17120);
var state_17131__$1 = state_17131;
var statearr_17133_17152 = state_17131__$1;
(statearr_17133_17152[(2)] = inst_17123);

(statearr_17133_17152[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17132 === (1))){
var state_17131__$1 = state_17131;
var statearr_17134_17153 = state_17131__$1;
(statearr_17134_17153[(2)] = null);

(statearr_17134_17153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17132 === (4))){
var inst_17110 = (state_17131[(2)]);
var state_17131__$1 = state_17131;
var statearr_17135_17154 = state_17131__$1;
(statearr_17135_17154[(2)] = inst_17110);

(statearr_17135_17154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17132 === (6))){
var inst_17120 = (state_17131[(7)]);
var inst_17119 = (state_17131[(2)]);
var inst_17120__$1 = fluree.db.util.async.throw_err.call(null,inst_17119);
var state_17131__$1 = (function (){var statearr_17136 = state_17131;
(statearr_17136[(7)] = inst_17120__$1);

return statearr_17136;
})();
if(cljs.core.truth_(inst_17120__$1)){
var statearr_17137_17155 = state_17131__$1;
(statearr_17137_17155[(1)] = (7));

} else {
var statearr_17138_17156 = state_17131__$1;
(statearr_17138_17156[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17132 === (3))){
var inst_17129 = (state_17131[(2)]);
var state_17131__$1 = state_17131;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17131__$1,inst_17129);
} else {
if((state_val_17132 === (2))){
var _ = (function (){var statearr_17140 = state_17131;
(statearr_17140[(4)] = cljs.core.cons.call(null,(5),(state_17131[(4)])));

return statearr_17140;
})();
var inst_17116 = fluree.db.storage.core.ledger_root_key.call(null,network,ledger_id,block);
var inst_17117 = fluree.db.storage.core.read.call(null,conn,inst_17116);
var state_17131__$1 = state_17131;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17131__$1,(6),inst_17117);
} else {
if((state_val_17132 === (9))){
var inst_17126 = (state_17131[(2)]);
var _ = (function (){var statearr_17141 = state_17131;
(statearr_17141[(4)] = cljs.core.rest.call(null,(state_17131[(4)])));

return statearr_17141;
})();
var state_17131__$1 = state_17131;
var statearr_17142_17157 = state_17131__$1;
(statearr_17142_17157[(2)] = inst_17126);

(statearr_17142_17157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17132 === (5))){
var _ = (function (){var statearr_17143 = state_17131;
(statearr_17143[(4)] = cljs.core.rest.call(null,(state_17131[(4)])));

return statearr_17143;
})();
var state_17131__$1 = state_17131;
var ex17139 = (state_17131__$1[(2)]);
var statearr_17144_17158 = state_17131__$1;
(statearr_17144_17158[(5)] = ex17139);


if((ex17139 instanceof Error)){
var statearr_17145_17159 = state_17131__$1;
(statearr_17145_17159[(1)] = (4));

(statearr_17145_17159[(5)] = null);

} else {
throw ex17139;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17132 === (8))){
var state_17131__$1 = state_17131;
var statearr_17146_17160 = state_17131__$1;
(statearr_17146_17160[(2)] = null);

(statearr_17146_17160[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0 = (function (){
var statearr_17147 = [null,null,null,null,null,null,null,null];
(statearr_17147[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__);

(statearr_17147[(1)] = (1));

return statearr_17147;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1 = (function (state_17131){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17131);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17148){var ex__2749__auto__ = e17148;
var statearr_17149_17161 = state_17131;
(statearr_17149_17161[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17131[(4)]))){
var statearr_17150_17162 = state_17131;
(statearr_17150_17162[(1)] = cljs.core.first.call(null,(state_17131[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17163 = state_17131;
state_17131 = G__17163;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__ = function(state_17131){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1.call(this,state_17131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17151 = f__2769__auto__.call(null);
(statearr_17151[(6)] = c__2768__auto__);

return statearr_17151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index,
 *   throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,ledger_id,blank_db,index){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17200){
var state_val_17201 = (state_17200[(1)]);
if((state_val_17201 === (7))){
var inst_17170 = (state_17200[(7)]);
var state_17200__$1 = state_17200;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17200__$1,(9),inst_17170);
} else {
if((state_val_17201 === (1))){
var state_17200__$1 = state_17200;
var statearr_17202_17223 = state_17200__$1;
(statearr_17202_17223[(2)] = null);

(statearr_17202_17223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17201 === (4))){
var inst_17164 = (state_17200[(2)]);
var state_17200__$1 = state_17200;
var statearr_17203_17224 = state_17200__$1;
(statearr_17203_17224[(2)] = inst_17164);

(statearr_17203_17224[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17201 === (6))){
var inst_17173 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_17174 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17175 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_17176 = cljs.core.PersistentHashMap.fromArrays(inst_17174,inst_17175);
var inst_17177 = cljs.core.ex_info.call(null,inst_17173,inst_17176);
var inst_17178 = (function(){throw inst_17177})();
var state_17200__$1 = state_17200;
var statearr_17204_17225 = state_17200__$1;
(statearr_17204_17225[(2)] = inst_17178);

(statearr_17204_17225[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17201 === (3))){
var inst_17198 = (state_17200[(2)]);
var state_17200__$1 = state_17200;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17200__$1,inst_17198);
} else {
if((state_val_17201 === (2))){
var inst_17170 = (state_17200[(7)]);
var _ = (function (){var statearr_17205 = state_17200;
(statearr_17205[(4)] = cljs.core.cons.call(null,(5),(state_17200[(4)])));

return statearr_17205;
})();
var inst_17170__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,ledger_id,index);
var inst_17171 = cljs.core.not.call(null,inst_17170__$1);
var state_17200__$1 = (function (){var statearr_17206 = state_17200;
(statearr_17206[(7)] = inst_17170__$1);

return statearr_17206;
})();
if(inst_17171){
var statearr_17207_17226 = state_17200__$1;
(statearr_17207_17226[(1)] = (6));

} else {
var statearr_17208_17227 = state_17200__$1;
(statearr_17208_17227[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17201 === (11))){
var inst_17188 = (state_17200[(8)]);
var inst_17191 = (state_17200[(2)]);
var inst_17192 = fluree.db.util.async.throw_err.call(null,inst_17191);
var inst_17193 = cljs.core.assoc.call(null,inst_17188,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_17192);
var state_17200__$1 = state_17200;
var statearr_17210_17228 = state_17200__$1;
(statearr_17210_17228[(2)] = inst_17193);

(statearr_17210_17228[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17201 === (9))){
var inst_17183 = (state_17200[(9)]);
var inst_17181 = (state_17200[(2)]);
var inst_17182 = fluree.db.util.async.throw_err.call(null,inst_17181);
var inst_17183__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_17182);
var inst_17184 = fluree.db.query.schema.schema_map.call(null,inst_17183__$1);
var state_17200__$1 = (function (){var statearr_17211 = state_17200;
(statearr_17211[(9)] = inst_17183__$1);

return statearr_17211;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17200__$1,(10),inst_17184);
} else {
if((state_val_17201 === (5))){
var _ = (function (){var statearr_17212 = state_17200;
(statearr_17212[(4)] = cljs.core.rest.call(null,(state_17200[(4)])));

return statearr_17212;
})();
var state_17200__$1 = state_17200;
var ex17209 = (state_17200__$1[(2)]);
var statearr_17213_17229 = state_17200__$1;
(statearr_17213_17229[(5)] = ex17209);


if((ex17209 instanceof Error)){
var statearr_17214_17230 = state_17200__$1;
(statearr_17214_17230[(1)] = (4));

(statearr_17214_17230[(5)] = null);

} else {
throw ex17209;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17201 === (10))){
var inst_17183 = (state_17200[(9)]);
var inst_17188 = (state_17200[(8)]);
var inst_17186 = (state_17200[(2)]);
var inst_17187 = fluree.db.util.async.throw_err.call(null,inst_17186);
var inst_17188__$1 = cljs.core.assoc.call(null,inst_17183,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_17187);
var inst_17189 = fluree.db.query.schema.setting_map.call(null,inst_17188__$1);
var state_17200__$1 = (function (){var statearr_17215 = state_17200;
(statearr_17215[(8)] = inst_17188__$1);

return statearr_17215;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17200__$1,(11),inst_17189);
} else {
if((state_val_17201 === (8))){
var inst_17195 = (state_17200[(2)]);
var _ = (function (){var statearr_17216 = state_17200;
(statearr_17216[(4)] = cljs.core.rest.call(null,(state_17200[(4)])));

return statearr_17216;
})();
var state_17200__$1 = state_17200;
var statearr_17217_17231 = state_17200__$1;
(statearr_17217_17231[(2)] = inst_17195);

(statearr_17217_17231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0 = (function (){
var statearr_17218 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17218[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2746__auto__);

(statearr_17218[(1)] = (1));

return statearr_17218;
});
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1 = (function (state_17200){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17200);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17219){var ex__2749__auto__ = e17219;
var statearr_17220_17232 = state_17200;
(statearr_17220_17232[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17200[(4)]))){
var statearr_17221_17233 = state_17200;
(statearr_17221_17233[(1)] = cljs.core.first.call(null,(state_17200[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17234 = state_17200;
state_17200 = G__17234;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__ = function(state_17200){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1.call(this,state_17200);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17222 = f__2769__auto__.call(null);
(statearr_17222[(6)] = c__2768__auto__);

return statearr_17222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.fetch_child_attributes = (function fluree$db$storage$core$fetch_child_attributes(conn,p__17235){
var map__17236 = p__17235;
var map__17236__$1 = cljs.core.__destructure_map.call(null,map__17236);
var branch = map__17236__$1;
var id = cljs.core.get.call(null,map__17236__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.call(null,map__17236__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leftmost_QMARK_ = cljs.core.get.call(null,map__17236__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17273){
var state_val_17274 = (state_17273[(1)]);
if((state_val_17274 === (7))){
var inst_17246 = (state_17273[(7)]);
var inst_17249 = cljs.core.__destructure_map.call(null,inst_17246);
var inst_17250 = cljs.core.get.call(null,inst_17249,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_17251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17252 = [new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"tempid","tempid",1427663222)];
var inst_17253 = (new cljs.core.PersistentVector(null,7,(5),inst_17251,inst_17252,null));
var inst_17254 = cljs.core.select_keys.call(null,branch,inst_17253);
var inst_17255 = (function (){var temp__5802__auto__ = inst_17246;
var map__17248 = inst_17249;
var children = inst_17250;
var branch_metadata = inst_17254;
return (function (i,child){
return cljs.core.merge.call(null,cljs.core.assoc.call(null,branch_metadata,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),(function (){var and__4251__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return (i === (0));
} else {
return and__4251__auto__;
}
})()),child);
});
})();
var inst_17256 = cljs.core.map_indexed.call(null,inst_17255,inst_17250);
var inst_17257 = cljs.core.juxt.call(null,new cljs.core.Keyword(null,"first","first",-644103046),cljs.core.identity);
var inst_17258 = cljs.core.mapcat.call(null,inst_17257,inst_17256);
var inst_17259 = cljs.core.apply.call(null,fluree.db.flake.sorted_map_by,comparator,inst_17258);
var state_17273__$1 = state_17273;
var statearr_17275_17294 = state_17273__$1;
(statearr_17275_17294[(2)] = inst_17259);

(statearr_17275_17294[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17274 === (1))){
var state_17273__$1 = state_17273;
var statearr_17276_17295 = state_17273__$1;
(statearr_17276_17295[(2)] = null);

(statearr_17276_17295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17274 === (4))){
var inst_17237 = (state_17273[(2)]);
var state_17273__$1 = state_17273;
var statearr_17277_17296 = state_17273__$1;
(statearr_17277_17296[(2)] = inst_17237);

(statearr_17277_17296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17274 === (6))){
var inst_17246 = (state_17273[(7)]);
var inst_17245 = (state_17273[(2)]);
var inst_17246__$1 = fluree.db.util.async.throw_err.call(null,inst_17245);
var state_17273__$1 = (function (){var statearr_17278 = state_17273;
(statearr_17278[(7)] = inst_17246__$1);

return statearr_17278;
})();
if(cljs.core.truth_(inst_17246__$1)){
var statearr_17279_17297 = state_17273__$1;
(statearr_17279_17297[(1)] = (7));

} else {
var statearr_17280_17298 = state_17273__$1;
(statearr_17280_17298[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17274 === (3))){
var inst_17271 = (state_17273[(2)]);
var state_17273__$1 = state_17273;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17273__$1,inst_17271);
} else {
if((state_val_17274 === (2))){
var _ = (function (){var statearr_17282 = state_17273;
(statearr_17282[(4)] = cljs.core.cons.call(null,(5),(state_17273[(4)])));

return statearr_17282;
})();
var inst_17243 = fluree.db.storage.core.read_branch.call(null,conn,id);
var state_17273__$1 = state_17273;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17273__$1,(6),inst_17243);
} else {
if((state_val_17274 === (9))){
var inst_17268 = (state_17273[(2)]);
var _ = (function (){var statearr_17283 = state_17273;
(statearr_17283[(4)] = cljs.core.rest.call(null,(state_17273[(4)])));

return statearr_17283;
})();
var state_17273__$1 = state_17273;
var statearr_17284_17299 = state_17273__$1;
(statearr_17284_17299[(2)] = inst_17268);

(statearr_17284_17299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17274 === (5))){
var _ = (function (){var statearr_17285 = state_17273;
(statearr_17285[(4)] = cljs.core.rest.call(null,(state_17273[(4)])));

return statearr_17285;
})();
var state_17273__$1 = state_17273;
var ex17281 = (state_17273__$1[(2)]);
var statearr_17286_17300 = state_17273__$1;
(statearr_17286_17300[(5)] = ex17281);


if((ex17281 instanceof Error)){
var statearr_17287_17301 = state_17273__$1;
(statearr_17287_17301[(1)] = (4));

(statearr_17287_17301[(5)] = null);

} else {
throw ex17281;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17274 === (8))){
var inst_17261 = ["Unable to retrieve index branch with id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage."].join('');
var inst_17262 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17263 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_17264 = cljs.core.PersistentHashMap.fromArrays(inst_17262,inst_17263);
var inst_17265 = cljs.core.ex_info.call(null,inst_17261,inst_17264);
var inst_17266 = (function(){throw inst_17265})();
var state_17273__$1 = state_17273;
var statearr_17288_17302 = state_17273__$1;
(statearr_17288_17302[(2)] = inst_17266);

(statearr_17288_17302[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____0 = (function (){
var statearr_17289 = [null,null,null,null,null,null,null,null];
(statearr_17289[(0)] = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__);

(statearr_17289[(1)] = (1));

return statearr_17289;
});
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____1 = (function (state_17273){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17273);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17290){var ex__2749__auto__ = e17290;
var statearr_17291_17303 = state_17273;
(statearr_17291_17303[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17273[(4)]))){
var statearr_17292_17304 = state_17273;
(statearr_17292_17304[(1)] = cljs.core.first.call(null,(state_17273[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17305 = state_17273;
state_17273 = G__17305;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__ = function(state_17273){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____1.call(this,state_17273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____0;
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____1;
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17293 = f__2769__auto__.call(null);
(statearr_17293[(6)] = c__2768__auto__);

return statearr_17293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.fetch_leaf_flakes = (function fluree$db$storage$core$fetch_leaf_flakes(conn,p__17306){
var map__17307 = p__17306;
var map__17307__$1 = cljs.core.__destructure_map.call(null,map__17307);
var id = cljs.core.get.call(null,map__17307__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.call(null,map__17307__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17336){
var state_val_17337 = (state_17336[(1)]);
if((state_val_17337 === (7))){
var inst_17317 = (state_17336[(7)]);
var inst_17320 = cljs.core.__destructure_map.call(null,inst_17317);
var inst_17321 = cljs.core.get.call(null,inst_17320,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_17322 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,comparator,inst_17321);
var state_17336__$1 = state_17336;
var statearr_17338_17357 = state_17336__$1;
(statearr_17338_17357[(2)] = inst_17322);

(statearr_17338_17357[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17337 === (1))){
var state_17336__$1 = state_17336;
var statearr_17339_17358 = state_17336__$1;
(statearr_17339_17358[(2)] = null);

(statearr_17339_17358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17337 === (4))){
var inst_17308 = (state_17336[(2)]);
var state_17336__$1 = state_17336;
var statearr_17340_17359 = state_17336__$1;
(statearr_17340_17359[(2)] = inst_17308);

(statearr_17340_17359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17337 === (6))){
var inst_17317 = (state_17336[(7)]);
var inst_17316 = (state_17336[(2)]);
var inst_17317__$1 = fluree.db.util.async.throw_err.call(null,inst_17316);
var state_17336__$1 = (function (){var statearr_17341 = state_17336;
(statearr_17341[(7)] = inst_17317__$1);

return statearr_17341;
})();
if(cljs.core.truth_(inst_17317__$1)){
var statearr_17342_17360 = state_17336__$1;
(statearr_17342_17360[(1)] = (7));

} else {
var statearr_17343_17361 = state_17336__$1;
(statearr_17343_17361[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17337 === (3))){
var inst_17334 = (state_17336[(2)]);
var state_17336__$1 = state_17336;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17336__$1,inst_17334);
} else {
if((state_val_17337 === (2))){
var _ = (function (){var statearr_17345 = state_17336;
(statearr_17345[(4)] = cljs.core.cons.call(null,(5),(state_17336[(4)])));

return statearr_17345;
})();
var inst_17314 = fluree.db.storage.core.read_leaf.call(null,conn,id);
var state_17336__$1 = state_17336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17336__$1,(6),inst_17314);
} else {
if((state_val_17337 === (9))){
var inst_17331 = (state_17336[(2)]);
var _ = (function (){var statearr_17346 = state_17336;
(statearr_17346[(4)] = cljs.core.rest.call(null,(state_17336[(4)])));

return statearr_17346;
})();
var state_17336__$1 = state_17336;
var statearr_17347_17362 = state_17336__$1;
(statearr_17347_17362[(2)] = inst_17331);

(statearr_17347_17362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17337 === (5))){
var _ = (function (){var statearr_17348 = state_17336;
(statearr_17348[(4)] = cljs.core.rest.call(null,(state_17336[(4)])));

return statearr_17348;
})();
var state_17336__$1 = state_17336;
var ex17344 = (state_17336__$1[(2)]);
var statearr_17349_17363 = state_17336__$1;
(statearr_17349_17363[(5)] = ex17344);


if((ex17344 instanceof Error)){
var statearr_17350_17364 = state_17336__$1;
(statearr_17350_17364[(1)] = (4));

(statearr_17350_17364[(5)] = null);

} else {
throw ex17344;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17337 === (8))){
var inst_17324 = ["Unable to retrieve leaf node with id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage"].join('');
var inst_17325 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17326 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_17327 = cljs.core.PersistentHashMap.fromArrays(inst_17325,inst_17326);
var inst_17328 = cljs.core.ex_info.call(null,inst_17324,inst_17327);
var inst_17329 = (function(){throw inst_17328})();
var state_17336__$1 = state_17336;
var statearr_17351_17365 = state_17336__$1;
(statearr_17351_17365[(2)] = inst_17329);

(statearr_17351_17365[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____0 = (function (){
var statearr_17352 = [null,null,null,null,null,null,null,null];
(statearr_17352[(0)] = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__);

(statearr_17352[(1)] = (1));

return statearr_17352;
});
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____1 = (function (state_17336){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17336);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17353){var ex__2749__auto__ = e17353;
var statearr_17354_17366 = state_17336;
(statearr_17354_17366[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17336[(4)]))){
var statearr_17355_17367 = state_17336;
(statearr_17355_17367[(1)] = cljs.core.first.call(null,(state_17336[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17368 = state_17336;
state_17336 = G__17368;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__ = function(state_17336){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____1.call(this,state_17336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____0;
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____1;
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17356 = f__2769__auto__.call(null);
(statearr_17356[(6)] = c__2768__auto__);

return statearr_17356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.resolve_index_node = (function fluree$db$storage$core$resolve_index_node(var_args){
var G__17370 = arguments.length;
switch (G__17370) {
case 2:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2 = (function (conn,node){
return fluree.db.storage.core.resolve_index_node.call(null,node,null);
}));

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3 = (function (conn,p__17371,error_fn){
var map__17372 = p__17371;
var map__17372__$1 = cljs.core.__destructure_map.call(null,map__17372);
var node = map__17372__$1;
var comparator = cljs.core.get.call(null,map__17372__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leaf = cljs.core.get.call(null,map__17372__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
if(cljs.core.truth_(comparator)){
} else {
throw (new Error(["Assert failed: ","Cannot resolve index node; configuration does not have a comparator.","\n","comparator"].join('')));
}

var return_ch = cljs.core.async.chan.call(null);
var c__2768__auto___17444 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17416){
var state_val_17417 = (state_17416[(1)]);
if((state_val_17417 === (7))){
var inst_17381 = (state_17416[(2)]);
var state_17416__$1 = state_17416;
var statearr_17418_17445 = state_17416__$1;
(statearr_17418_17445[(2)] = inst_17381);

(statearr_17418_17445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (1))){
var state_17416__$1 = state_17416;
var statearr_17419_17446 = state_17416__$1;
(statearr_17419_17446[(2)] = null);

(statearr_17419_17446[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (4))){
var inst_17373 = (state_17416[(7)]);
var inst_17373__$1 = (state_17416[(2)]);
var inst_17374 = fluree.db.util.log.error.call(null,inst_17373__$1,"Error resolving index node");
var state_17416__$1 = (function (){var statearr_17420 = state_17416;
(statearr_17420[(8)] = inst_17374);

(statearr_17420[(7)] = inst_17373__$1);

return statearr_17420;
})();
if(cljs.core.truth_(error_fn)){
var statearr_17421_17447 = state_17416__$1;
(statearr_17421_17447[(1)] = (5));

} else {
var statearr_17422_17448 = state_17416__$1;
(statearr_17422_17448[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (13))){
var inst_17399 = (state_17416[(9)]);
var inst_17402 = (state_17416[(2)]);
var inst_17403 = fluree.db.util.async.throw_err.call(null,inst_17402);
var inst_17404 = [new cljs.core.Keyword(null,"children","children",-940561982),inst_17403];
var inst_17405 = (new cljs.core.PersistentVector(null,2,(5),inst_17399,inst_17404,null));
var state_17416__$1 = state_17416;
var statearr_17423_17449 = state_17416__$1;
(statearr_17423_17449[(2)] = inst_17405);

(statearr_17423_17449[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (6))){
var state_17416__$1 = state_17416;
var statearr_17424_17450 = state_17416__$1;
(statearr_17424_17450[(2)] = null);

(statearr_17424_17450[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (3))){
var inst_17414 = (state_17416[(2)]);
var state_17416__$1 = state_17416;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17416__$1,inst_17414);
} else {
if((state_val_17417 === (12))){
var inst_17391 = (state_17416[(10)]);
var inst_17394 = (state_17416[(2)]);
var inst_17395 = fluree.db.util.async.throw_err.call(null,inst_17394);
var inst_17396 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_17395];
var inst_17397 = (new cljs.core.PersistentVector(null,2,(5),inst_17391,inst_17396,null));
var state_17416__$1 = state_17416;
var statearr_17425_17451 = state_17416__$1;
(statearr_17425_17451[(2)] = inst_17397);

(statearr_17425_17451[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (2))){
var _ = (function (){var statearr_17426 = state_17416;
(statearr_17426[(4)] = cljs.core.cons.call(null,(8),(state_17416[(4)])));

return statearr_17426;
})();
var state_17416__$1 = state_17416;
if(cljs.core.truth_(leaf)){
var statearr_17427_17452 = state_17416__$1;
(statearr_17427_17452[(1)] = (9));

} else {
var statearr_17428_17453 = state_17416__$1;
(statearr_17428_17453[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (11))){
var inst_17407 = (state_17416[(2)]);
var inst_17408 = cljs.core.nth.call(null,inst_17407,(0),null);
var inst_17409 = cljs.core.nth.call(null,inst_17407,(1),null);
var inst_17410 = cljs.core.assoc.call(null,node,inst_17408,inst_17409);
var inst_17411 = cljs.core.async.put_BANG_.call(null,return_ch,inst_17410);
var _ = (function (){var statearr_17429 = state_17416;
(statearr_17429[(4)] = cljs.core.rest.call(null,(state_17416[(4)])));

return statearr_17429;
})();
var state_17416__$1 = state_17416;
var statearr_17430_17454 = state_17416__$1;
(statearr_17430_17454[(2)] = inst_17411);

(statearr_17430_17454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (9))){
var inst_17391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17392 = fluree.db.storage.core.fetch_leaf_flakes.call(null,conn,node);
var state_17416__$1 = (function (){var statearr_17431 = state_17416;
(statearr_17431[(10)] = inst_17391);

return statearr_17431;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17416__$1,(12),inst_17392);
} else {
if((state_val_17417 === (5))){
var inst_17373 = (state_17416[(7)]);
var inst_17376 = cljs.core.async.put_BANG_.call(null,return_ch,inst_17373);
var inst_17377 = cljs.core.async.close_BANG_.call(null,return_ch);
var inst_17378 = error_fn.call(null,inst_17376,inst_17377);
var state_17416__$1 = state_17416;
var statearr_17433_17455 = state_17416__$1;
(statearr_17433_17455[(2)] = inst_17378);

(statearr_17433_17455[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (10))){
var inst_17399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17400 = fluree.db.storage.core.fetch_child_attributes.call(null,conn,node);
var state_17416__$1 = (function (){var statearr_17434 = state_17416;
(statearr_17434[(9)] = inst_17399);

return statearr_17434;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17416__$1,(13),inst_17400);
} else {
if((state_val_17417 === (8))){
var _ = (function (){var statearr_17435 = state_17416;
(statearr_17435[(4)] = cljs.core.rest.call(null,(state_17416[(4)])));

return statearr_17435;
})();
var state_17416__$1 = state_17416;
var ex17432 = (state_17416__$1[(2)]);
var statearr_17436_17456 = state_17416__$1;
(statearr_17436_17456[(5)] = ex17432);


var statearr_17437_17457 = state_17416__$1;
(statearr_17437_17457[(1)] = (4));

(statearr_17437_17457[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_17438 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17438[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_17438[(1)] = (1));

return statearr_17438;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_17416){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17416);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17439){var ex__2749__auto__ = e17439;
var statearr_17440_17458 = state_17416;
(statearr_17440_17458[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17416[(4)]))){
var statearr_17441_17459 = state_17416;
(statearr_17441_17459[(1)] = cljs.core.first.call(null,(state_17416[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17460 = state_17416;
state_17416 = G__17460;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_17416){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_17416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17442 = f__2769__auto__.call(null);
(statearr_17442[(6)] = c__2768__auto___17444);

return statearr_17442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_ch;
}));

(fluree.db.storage.core.resolve_index_node.cljs$lang$maxFixedArity = 3);

fluree.db.storage.core.resolve_empty_leaf = (function fluree$db$storage$core$resolve_empty_leaf(p__17461){
var map__17462 = p__17461;
var map__17462__$1 = cljs.core.__destructure_map.call(null,map__17462);
var node = map__17462__$1;
var comparator = cljs.core.get.call(null,map__17462__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var ch = cljs.core.async.chan.call(null);
var empty_set = fluree.db.flake.sorted_set_by.call(null,comparator);
var empty_node = cljs.core.assoc.call(null,node,new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set);
cljs.core.async.put_BANG_.call(null,ch,empty_node);

return ch;
});
