// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.call(null,index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.get.call(null,text,counter))){
var G__90643 = (line + (1));
var G__90644 = (1);
var G__90645 = (counter + (1));
line = G__90643;
col = G__90644;
counter = G__90645;
continue;
} else {
var G__90646 = line;
var G__90647 = (col + (1));
var G__90648 = (counter + (1));
line = G__90646;
col = G__90647;
counter = G__90648;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq.call(null,clojure.string.replace.call(null,text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_.call(null,chars)){
return "";
} else {
if(cljs.core._EQ_.call(null,n__$1,(1))){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.take_while.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.first.call(null,chars))){
var G__90649 = cljs.core.next.call(null,chars);
var G__90650 = (n__$1 - (1));
chars = G__90649;
n__$1 = G__90650;
continue;
} else {
var G__90651 = cljs.core.next.call(null,chars);
var G__90652 = n__$1;
chars = G__90651;
n__$1 = G__90652;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_.call(null,n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.call(null,cljs.core.str,cljs.core.concat.call(null,cljs.core.repeat.call(null,(n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column.call(null,new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.call(null,failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line.call(null,new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.call(null,"NOT ");

return cljs.core.print.call(null,new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.call(null,instaparse.print.char_range__GT_str.call(null,r));
} else {
if((r instanceof RegExp)){
return cljs.core.print.call(null,instaparse.print.regexp__GT_str.call(null,r));
} else {
return cljs.core.pr.call(null,r);

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__90653){
var map__90654 = p__90653;
var map__90654__$1 = cljs.core.__destructure_map.call(null,map__90654);
var line = cljs.core.get.call(null,map__90654__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__90654__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.call(null,map__90654__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.call(null,map__90654__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.call(null,["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join(''));

cljs.core.println.call(null,text);

cljs.core.println.call(null,instaparse.failure.marker.call(null,column));

var full_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,cljs.core.complement.call(null,new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count.call(null,full_reasons) + cljs.core.count.call(null,partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.call(null,(1),total)){
cljs.core.println.call(null,"Expected:");
} else {
cljs.core.println.call(null,"Expected one of:");

}
}

var seq__90655_90663 = cljs.core.seq.call(null,full_reasons);
var chunk__90656_90664 = null;
var count__90657_90665 = (0);
var i__90658_90666 = (0);
while(true){
if((i__90658_90666 < count__90657_90665)){
var r_90667 = cljs.core._nth.call(null,chunk__90656_90664,i__90658_90666);
instaparse.failure.print_reason.call(null,r_90667);

cljs.core.println.call(null," (followed by end-of-string)");


var G__90668 = seq__90655_90663;
var G__90669 = chunk__90656_90664;
var G__90670 = count__90657_90665;
var G__90671 = (i__90658_90666 + (1));
seq__90655_90663 = G__90668;
chunk__90656_90664 = G__90669;
count__90657_90665 = G__90670;
i__90658_90666 = G__90671;
continue;
} else {
var temp__5753__auto___90672 = cljs.core.seq.call(null,seq__90655_90663);
if(temp__5753__auto___90672){
var seq__90655_90673__$1 = temp__5753__auto___90672;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__90655_90673__$1)){
var c__4679__auto___90674 = cljs.core.chunk_first.call(null,seq__90655_90673__$1);
var G__90675 = cljs.core.chunk_rest.call(null,seq__90655_90673__$1);
var G__90676 = c__4679__auto___90674;
var G__90677 = cljs.core.count.call(null,c__4679__auto___90674);
var G__90678 = (0);
seq__90655_90663 = G__90675;
chunk__90656_90664 = G__90676;
count__90657_90665 = G__90677;
i__90658_90666 = G__90678;
continue;
} else {
var r_90679 = cljs.core.first.call(null,seq__90655_90673__$1);
instaparse.failure.print_reason.call(null,r_90679);

cljs.core.println.call(null," (followed by end-of-string)");


var G__90680 = cljs.core.next.call(null,seq__90655_90673__$1);
var G__90681 = null;
var G__90682 = (0);
var G__90683 = (0);
seq__90655_90663 = G__90680;
chunk__90656_90664 = G__90681;
count__90657_90665 = G__90682;
i__90658_90666 = G__90683;
continue;
}
} else {
}
}
break;
}

var seq__90659 = cljs.core.seq.call(null,partial_reasons);
var chunk__90660 = null;
var count__90661 = (0);
var i__90662 = (0);
while(true){
if((i__90662 < count__90661)){
var r = cljs.core._nth.call(null,chunk__90660,i__90662);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__90684 = seq__90659;
var G__90685 = chunk__90660;
var G__90686 = count__90661;
var G__90687 = (i__90662 + (1));
seq__90659 = G__90684;
chunk__90660 = G__90685;
count__90661 = G__90686;
i__90662 = G__90687;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__90659);
if(temp__5753__auto__){
var seq__90659__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__90659__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__90659__$1);
var G__90688 = cljs.core.chunk_rest.call(null,seq__90659__$1);
var G__90689 = c__4679__auto__;
var G__90690 = cljs.core.count.call(null,c__4679__auto__);
var G__90691 = (0);
seq__90659 = G__90688;
chunk__90660 = G__90689;
count__90661 = G__90690;
i__90662 = G__90691;
continue;
} else {
var r = cljs.core.first.call(null,seq__90659__$1);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__90692 = cljs.core.next.call(null,seq__90659__$1);
var G__90693 = null;
var G__90694 = (0);
var G__90695 = (0);
seq__90659 = G__90692;
chunk__90660 = G__90693;
count__90661 = G__90694;
i__90662 = G__90695;
continue;
}
} else {
return null;
}
}
break;
}
});
