// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15300){
var state_val_15301 = (state_15300[(1)]);
if((state_val_15301 === (1))){
var state_15300__$1 = state_15300;
var statearr_15302_15316 = state_15300__$1;
(statearr_15302_15316[(2)] = null);

(statearr_15302_15316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15301 === (2))){
var _ = (function (){var statearr_15303 = state_15300;
(statearr_15303[(4)] = cljs.core.cons((5),(state_15300[(4)])));

return statearr_15303;
})();
var inst_15291 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_15300__$1 = state_15300;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15300__$1,(6),inst_15291);
} else {
if((state_val_15301 === (3))){
var inst_15298 = (state_15300[(2)]);
var state_15300__$1 = state_15300;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15300__$1,inst_15298);
} else {
if((state_val_15301 === (4))){
var inst_15285 = (state_15300[(2)]);
var state_15300__$1 = state_15300;
var statearr_15305_15317 = state_15300__$1;
(statearr_15305_15317[(2)] = inst_15285);

(statearr_15305_15317[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15301 === (5))){
var _ = (function (){var statearr_15306 = state_15300;
(statearr_15306[(4)] = cljs.core.rest((state_15300[(4)])));

return statearr_15306;
})();
var state_15300__$1 = state_15300;
var ex15304 = (state_15300__$1[(2)]);
var statearr_15307_15318 = state_15300__$1;
(statearr_15307_15318[(5)] = ex15304);


if((ex15304 instanceof Error)){
var statearr_15308_15319 = state_15300__$1;
(statearr_15308_15319[(1)] = (4));

(statearr_15308_15319[(5)] = null);

} else {
throw ex15304;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15301 === (6))){
var inst_15293 = (state_15300[(2)]);
var inst_15294 = fluree.db.util.async.throw_err(inst_15293);
var inst_15295 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_15294);
var _ = (function (){var statearr_15309 = state_15300;
(statearr_15309[(4)] = cljs.core.rest((state_15300[(4)])));

return statearr_15309;
})();
var state_15300__$1 = state_15300;
var statearr_15310_15320 = state_15300__$1;
(statearr_15310_15320[(2)] = inst_15295);

(statearr_15310_15320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0 = (function (){
var statearr_15311 = [null,null,null,null,null,null,null];
(statearr_15311[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__);

(statearr_15311[(1)] = (1));

return statearr_15311;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1 = (function (state_15300){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15300);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15312){var ex__2730__auto__ = e15312;
var statearr_15313_15321 = state_15300;
(statearr_15313_15321[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15300[(4)]))){
var statearr_15314_15322 = state_15300;
(statearr_15314_15322[(1)] = cljs.core.first((state_15300[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15323 = state_15300;
state_15300 = G__15323;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__ = function(state_15300){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1.call(this,state_15300);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15315 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15315[(6)] = c__2749__auto__);

return statearr_15315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15355){
var state_val_15356 = (state_15355[(1)]);
if((state_val_15356 === (7))){
var inst_15339 = (state_15355[(7)]);
var inst_15341 = cljs.core.empty_QMARK_(inst_15339);
var inst_15342 = (!(inst_15341));
var state_15355__$1 = state_15355;
var statearr_15357_15381 = state_15355__$1;
(statearr_15357_15381[(2)] = inst_15342);

(statearr_15357_15381[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15356 === (1))){
var state_15355__$1 = state_15355;
var statearr_15358_15382 = state_15355__$1;
(statearr_15358_15382[(2)] = null);

(statearr_15358_15382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15356 === (4))){
var inst_15325 = (state_15355[(2)]);
var state_15355__$1 = state_15355;
var statearr_15359_15383 = state_15355__$1;
(statearr_15359_15383[(2)] = inst_15325);

(statearr_15359_15383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15356 === (6))){
var inst_15339 = (state_15355[(7)]);
var inst_15331 = (state_15355[(8)]);
var inst_15337 = (state_15355[(2)]);
var inst_15338 = fluree.db.util.async.throw_err(inst_15337);
var inst_15339__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_15331,inst_15338);
var state_15355__$1 = (function (){var statearr_15360 = state_15355;
(statearr_15360[(7)] = inst_15339__$1);

return statearr_15360;
})();
if(cljs.core.truth_(inst_15339__$1)){
var statearr_15361_15384 = state_15355__$1;
(statearr_15361_15384[(1)] = (7));

} else {
var statearr_15362_15385 = state_15355__$1;
(statearr_15362_15385[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15356 === (3))){
var inst_15353 = (state_15355[(2)]);
var state_15355__$1 = state_15355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15355__$1,inst_15353);
} else {
if((state_val_15356 === (12))){
var inst_15350 = (state_15355[(2)]);
var _ = (function (){var statearr_15363 = state_15355;
(statearr_15363[(4)] = cljs.core.rest((state_15355[(4)])));

return statearr_15363;
})();
var state_15355__$1 = state_15355;
var statearr_15364_15386 = state_15355__$1;
(statearr_15364_15386[(2)] = inst_15350);

(statearr_15364_15386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15356 === (2))){
var _ = (function (){var statearr_15365 = state_15355;
(statearr_15365[(4)] = cljs.core.cons((5),(state_15355[(4)])));

return statearr_15365;
})();
var inst_15331 = (function (){return (function (p1__15324_SHARP_){
return fluree.db.flake.o(p1__15324_SHARP_);
});
})();
var inst_15332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15333 = [pred_id];
var inst_15334 = (new cljs.core.PersistentVector(null,1,(5),inst_15332,inst_15333,null));
var inst_15335 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15334);
var state_15355__$1 = (function (){var statearr_15366 = state_15355;
(statearr_15366[(8)] = inst_15331);

return statearr_15366;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15355__$1,(6),inst_15335);
} else {
if((state_val_15356 === (11))){
var state_15355__$1 = state_15355;
var statearr_15368_15387 = state_15355__$1;
(statearr_15368_15387[(2)] = true);

(statearr_15368_15387[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15356 === (9))){
var inst_15345 = (state_15355[(2)]);
var state_15355__$1 = state_15355;
if(cljs.core.truth_(inst_15345)){
var statearr_15369_15388 = state_15355__$1;
(statearr_15369_15388[(1)] = (10));

} else {
var statearr_15370_15389 = state_15355__$1;
(statearr_15370_15389[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15356 === (5))){
var _ = (function (){var statearr_15371 = state_15355;
(statearr_15371[(4)] = cljs.core.rest((state_15355[(4)])));

return statearr_15371;
})();
var state_15355__$1 = state_15355;
var ex15367 = (state_15355__$1[(2)]);
var statearr_15372_15390 = state_15355__$1;
(statearr_15372_15390[(5)] = ex15367);


if((ex15367 instanceof Error)){
var statearr_15373_15391 = state_15355__$1;
(statearr_15373_15391[(1)] = (4));

(statearr_15373_15391[(5)] = null);

} else {
throw ex15367;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15356 === (10))){
var inst_15339 = (state_15355[(7)]);
var inst_15347 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_15339);
var state_15355__$1 = state_15355;
var statearr_15374_15392 = state_15355__$1;
(statearr_15374_15392[(2)] = inst_15347);

(statearr_15374_15392[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15356 === (8))){
var inst_15339 = (state_15355[(7)]);
var state_15355__$1 = state_15355;
var statearr_15375_15393 = state_15355__$1;
(statearr_15375_15393[(2)] = inst_15339);

(statearr_15375_15393[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_15376 = [null,null,null,null,null,null,null,null,null];
(statearr_15376[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__);

(statearr_15376[(1)] = (1));

return statearr_15376;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1 = (function (state_15355){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15355);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15377){var ex__2730__auto__ = e15377;
var statearr_15378_15394 = state_15355;
(statearr_15378_15394[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15355[(4)]))){
var statearr_15379_15395 = state_15355;
(statearr_15379_15395[(1)] = cljs.core.first((state_15355[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15396 = state_15355;
state_15355 = G__15396;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__ = function(state_15355){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1.call(this,state_15355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15380 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15380[(6)] = c__2749__auto__);

return statearr_15380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15477){
var state_val_15478 = (state_15477[(1)]);
if((state_val_15478 === (7))){
var state_15477__$1 = state_15477;
var statearr_15479_15517 = state_15477__$1;
(statearr_15479_15517[(2)] = flakes);

(statearr_15479_15517[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (20))){
var inst_15434 = (state_15477[(7)]);
var inst_15467 = (state_15477[(2)]);
var inst_15426 = inst_15434;
var inst_15427 = inst_15467;
var state_15477__$1 = (function (){var statearr_15480 = state_15477;
(statearr_15480[(8)] = inst_15427);

(statearr_15480[(9)] = inst_15426);

return statearr_15480;
})();
var statearr_15481_15518 = state_15477__$1;
(statearr_15481_15518[(2)] = null);

(statearr_15481_15518[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (1))){
var state_15477__$1 = state_15477;
var statearr_15482_15519 = state_15477__$1;
(statearr_15482_15519[(2)] = null);

(statearr_15482_15519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (4))){
var inst_15399 = (state_15477[(2)]);
var state_15477__$1 = state_15477;
var statearr_15483_15520 = state_15477__$1;
(statearr_15483_15520[(2)] = inst_15399);

(statearr_15483_15520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (15))){
var inst_15433 = (state_15477[(10)]);
var inst_15451 = fluree.db.flake.o(inst_15433);
var state_15477__$1 = state_15477;
var statearr_15484_15521 = state_15477__$1;
(statearr_15484_15521[(2)] = inst_15451);

(statearr_15484_15521[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (13))){
var inst_15470 = (state_15477[(2)]);
var state_15477__$1 = state_15477;
var statearr_15485_15522 = state_15477__$1;
(statearr_15485_15522[(2)] = inst_15470);

(statearr_15485_15522[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (6))){
var inst_15406 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_15477__$1 = state_15477;
var statearr_15486_15523 = state_15477__$1;
(statearr_15486_15523[(2)] = inst_15406);

(statearr_15486_15523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (17))){
var inst_15448 = (state_15477[(2)]);
var inst_15449 = fluree.db.util.async.throw_err(inst_15448);
var state_15477__$1 = state_15477;
var statearr_15487_15524 = state_15477__$1;
(statearr_15487_15524[(2)] = inst_15449);

(statearr_15487_15524[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (3))){
var inst_15475 = (state_15477[(2)]);
var state_15477__$1 = state_15477;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15477__$1,inst_15475);
} else {
if((state_val_15478 === (12))){
var inst_15440 = (state_15477[(11)]);
var inst_15433 = (state_15477[(10)]);
var inst_15438 = fluree.db.flake.p(inst_15433);
var inst_15439 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15438);
var inst_15440__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_15439);
var inst_15441 = fluree.db.flake.op(inst_15433);
var inst_15442 = inst_15441 === false;
var inst_15443 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_15440__$1);
var state_15477__$1 = (function (){var statearr_15488 = state_15477;
(statearr_15488[(12)] = inst_15442);

(statearr_15488[(11)] = inst_15440__$1);

return statearr_15488;
})();
if(inst_15443){
var statearr_15489_15525 = state_15477__$1;
(statearr_15489_15525[(1)] = (14));

} else {
var statearr_15490_15526 = state_15477__$1;
(statearr_15490_15526[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (2))){
var _ = (function (){var statearr_15491 = state_15477;
(statearr_15491[(4)] = cljs.core.cons((5),(state_15477[(4)])));

return statearr_15491;
})();
var state_15477__$1 = state_15477;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_15492_15527 = state_15477__$1;
(statearr_15492_15527[(1)] = (6));

} else {
var statearr_15493_15528 = state_15477__$1;
(statearr_15493_15528[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (19))){
var inst_15453 = (state_15477[(13)]);
var inst_15427 = (state_15477[(8)]);
var inst_15440 = (state_15477[(11)]);
var inst_15433 = (state_15477[(10)]);
var inst_15461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15462 = fluree.db.flake.s(inst_15433);
var inst_15463 = [inst_15462,inst_15440,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_15464 = (new cljs.core.PersistentVector(null,3,(5),inst_15461,inst_15463,null));
var inst_15465 = cljs.core.assoc_in(inst_15427,inst_15464,inst_15453);
var state_15477__$1 = state_15477;
var statearr_15494_15529 = state_15477__$1;
(statearr_15494_15529[(2)] = inst_15465);

(statearr_15494_15529[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (11))){
var inst_15427 = (state_15477[(8)]);
var state_15477__$1 = state_15477;
var statearr_15496_15530 = state_15477__$1;
(statearr_15496_15530[(2)] = inst_15427);

(statearr_15496_15530[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (9))){
var inst_15426 = (state_15477[(9)]);
var inst_15433 = (state_15477[(10)]);
var inst_15432 = cljs.core.seq(inst_15426);
var inst_15433__$1 = cljs.core.first(inst_15432);
var inst_15434 = cljs.core.next(inst_15432);
var inst_15435 = cljs.core.not(inst_15433__$1);
var state_15477__$1 = (function (){var statearr_15497 = state_15477;
(statearr_15497[(10)] = inst_15433__$1);

(statearr_15497[(7)] = inst_15434);

return statearr_15497;
})();
if(inst_15435){
var statearr_15498_15531 = state_15477__$1;
(statearr_15498_15531[(1)] = (11));

} else {
var statearr_15499_15532 = state_15477__$1;
(statearr_15499_15532[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (5))){
var _ = (function (){var statearr_15500 = state_15477;
(statearr_15500[(4)] = cljs.core.rest((state_15477[(4)])));

return statearr_15500;
})();
var state_15477__$1 = state_15477;
var ex15495 = (state_15477__$1[(2)]);
var statearr_15501_15533 = state_15477__$1;
(statearr_15501_15533[(5)] = ex15495);


if((ex15495 instanceof Error)){
var statearr_15502_15534 = state_15477__$1;
(statearr_15502_15534[(1)] = (4));

(statearr_15502_15534[(5)] = null);

} else {
throw ex15495;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (14))){
var inst_15433 = (state_15477[(10)]);
var inst_15445 = fluree.db.flake.o(inst_15433);
var inst_15446 = fluree.db.query.schema.convert_type_to_kw(inst_15445,db);
var state_15477__$1 = state_15477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15477__$1,(17),inst_15446);
} else {
if((state_val_15478 === (16))){
var inst_15442 = (state_15477[(12)]);
var inst_15453 = (state_15477[(2)]);
var state_15477__$1 = (function (){var statearr_15503 = state_15477;
(statearr_15503[(13)] = inst_15453);

return statearr_15503;
})();
if(cljs.core.truth_(inst_15442)){
var statearr_15504_15535 = state_15477__$1;
(statearr_15504_15535[(1)] = (18));

} else {
var statearr_15505_15536 = state_15477__$1;
(statearr_15505_15536[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (10))){
var inst_15472 = (state_15477[(2)]);
var _ = (function (){var statearr_15506 = state_15477;
(statearr_15506[(4)] = cljs.core.rest((state_15477[(4)])));

return statearr_15506;
})();
var state_15477__$1 = state_15477;
var statearr_15507_15537 = state_15477__$1;
(statearr_15507_15537[(2)] = inst_15472);

(statearr_15507_15537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (18))){
var inst_15453 = (state_15477[(13)]);
var inst_15427 = (state_15477[(8)]);
var inst_15440 = (state_15477[(11)]);
var inst_15433 = (state_15477[(10)]);
var inst_15455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15456 = fluree.db.flake.s(inst_15433);
var inst_15457 = [inst_15456,inst_15440,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_15458 = (new cljs.core.PersistentVector(null,3,(5),inst_15455,inst_15457,null));
var inst_15459 = cljs.core.assoc_in(inst_15427,inst_15458,inst_15453);
var state_15477__$1 = state_15477;
var statearr_15508_15538 = state_15477__$1;
(statearr_15508_15538[(2)] = inst_15459);

(statearr_15508_15538[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15478 === (8))){
var inst_15409 = (state_15477[(2)]);
var inst_15410 = cljs.core.PersistentHashSet.EMPTY;
var inst_15411 = cljs.core.vals(tempids);
var inst_15412 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_15410,inst_15411);
var inst_15413 = (function (){var pred_flakes = inst_15409;
var is_new_QMARK_ = inst_15412;
return (function (p1__15398_SHARP_,p2__15397_SHARP_){
var f = p2__15397_SHARP_;
return cljs.core.assoc_in(p1__15398_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.s(f),new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__15509 = fluree.db.flake.s(f);
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__15509) : is_new_QMARK_.call(null,G__15509));
})()));
});
})();
var inst_15414 = cljs.core.PersistentHashMap.EMPTY;
var inst_15415 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_15413,inst_15414,inst_15409);
var inst_15423 = cljs.core.seq(inst_15409);
var inst_15424 = cljs.core.first(inst_15423);
var inst_15425 = cljs.core.next(inst_15423);
var inst_15426 = inst_15409;
var inst_15427 = inst_15415;
var state_15477__$1 = (function (){var statearr_15510 = state_15477;
(statearr_15510[(8)] = inst_15427);

(statearr_15510[(9)] = inst_15426);

(statearr_15510[(14)] = inst_15425);

(statearr_15510[(15)] = inst_15424);

return statearr_15510;
})();
var statearr_15511_15539 = state_15477__$1;
(statearr_15511_15539[(2)] = null);

(statearr_15511_15539[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0 = (function (){
var statearr_15512 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15512[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__);

(statearr_15512[(1)] = (1));

return statearr_15512;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1 = (function (state_15477){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15477);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15513){var ex__2730__auto__ = e15513;
var statearr_15514_15540 = state_15477;
(statearr_15514_15540[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15477[(4)]))){
var statearr_15515_15541 = state_15477;
(statearr_15515_15541[(1)] = cljs.core.first((state_15477[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15542 = state_15477;
state_15477 = G__15542;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__ = function(state_15477){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1.call(this,state_15477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15516 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15516[(6)] = c__2749__auto__);

return statearr_15516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__15544 = arguments.length;
switch (G__15544) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__15547 = arguments.length;
switch (G__15547) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15859){
var state_val_15860 = (state_15859[(1)]);
if((state_val_15860 === (121))){
var inst_15814 = (state_15859[(7)]);
var state_15859__$1 = state_15859;
var statearr_15861_16054 = state_15859__$1;
(statearr_15861_16054[(2)] = inst_15814);

(statearr_15861_16054[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (65))){
var inst_15713 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
if(cljs.core.truth_(inst_15713)){
var statearr_15862_16055 = state_15859__$1;
(statearr_15862_16055[(1)] = (66));

} else {
var statearr_15863_16056 = state_15859__$1;
(statearr_15863_16056[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (70))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15723 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_15724 = (inst_15719.cljs$core$IFn$_invoke$arity$5 ? inst_15719.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_15723,null) : inst_15719.call(null,cljs.core.PersistentArrayMap,null,3,inst_15723,null));
var inst_15725 = (inst_15719.cljs$core$IFn$_invoke$arity$4 ? inst_15719.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15724,null) : inst_15719.call(null,cljs.core.PersistentHashSet,null,inst_15724,null));
var inst_15726 = (inst_15725.cljs$core$IFn$_invoke$arity$1 ? inst_15725.cljs$core$IFn$_invoke$arity$1(inst_15718) : inst_15725.call(null,inst_15718));
var state_15859__$1 = state_15859;
if(cljs.core.truth_(inst_15726)){
var statearr_15864_16057 = state_15859__$1;
(statearr_15864_16057[(1)] = (72));

} else {
var statearr_15865_16058 = state_15859__$1;
(statearr_15865_16058[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (62))){
var inst_15703 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15866_16059 = state_15859__$1;
(statearr_15866_16059[(2)] = inst_15703);

(statearr_15866_16059[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (74))){
var inst_15809 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15867_16060 = state_15859__$1;
(statearr_15867_16060[(2)] = inst_15809);

(statearr_15867_16060[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (110))){
var inst_15836 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
if(cljs.core.truth_(inst_15836)){
var statearr_15868_16061 = state_15859__$1;
(statearr_15868_16061[(1)] = (117));

} else {
var statearr_15869_16062 = state_15859__$1;
(statearr_15869_16062[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (7))){
var inst_15854 = (state_15859[(2)]);
var _ = (function (){var statearr_15870 = state_15859;
(statearr_15870[(4)] = cljs.core.rest((state_15859[(4)])));

return statearr_15870;
})();
var state_15859__$1 = state_15859;
var statearr_15871_16063 = state_15859__$1;
(statearr_15871_16063[(2)] = inst_15854);

(statearr_15871_16063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (59))){
var inst_15707 = (state_15859[(10)]);
var inst_15587 = (state_15859[(11)]);
var inst_15706 = (state_15859[(2)]);
var inst_15707__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15587);
var state_15859__$1 = (function (){var statearr_15872 = state_15859;
(statearr_15872[(10)] = inst_15707__$1);

(statearr_15872[(12)] = inst_15706);

return statearr_15872;
})();
if(cljs.core.truth_(inst_15707__$1)){
var statearr_15873_16064 = state_15859__$1;
(statearr_15873_16064[(1)] = (63));

} else {
var statearr_15874_16065 = state_15859__$1;
(statearr_15874_16065[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (86))){
var inst_15749 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15875_16066 = state_15859__$1;
(statearr_15875_16066[(2)] = inst_15749);

(statearr_15875_16066[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (20))){
var inst_15613 = (state_15859[(13)]);
var inst_15587 = (state_15859[(11)]);
var inst_15613__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15587);
var state_15859__$1 = (function (){var statearr_15876 = state_15859;
(statearr_15876[(13)] = inst_15613__$1);

return statearr_15876;
})();
if(cljs.core.truth_(inst_15613__$1)){
var statearr_15877_16067 = state_15859__$1;
(statearr_15877_16067[(1)] = (23));

} else {
var statearr_15878_16068 = state_15859__$1;
(statearr_15878_16068[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (72))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15728 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15718,inst_15719,throw_QMARK_);
var state_15859__$1 = state_15859;
var statearr_15879_16069 = state_15859__$1;
(statearr_15879_16069[(2)] = inst_15728);

(statearr_15879_16069[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (58))){
var inst_15668 = (state_15859[(14)]);
var state_15859__$1 = state_15859;
var statearr_15880_16070 = state_15859__$1;
(statearr_15880_16070[(2)] = inst_15668);

(statearr_15880_16070[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (60))){
var inst_15575 = (state_15859[(15)]);
var inst_15586 = (state_15859[(16)]);
var inst_15694 = fluree.db.dbproto._p_prop(inst_15575,new cljs.core.Keyword(null,"name","name",1843675177),inst_15586);
var inst_15695 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15694)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_15696 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15697 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15698 = cljs.core.PersistentHashMap.fromArrays(inst_15696,inst_15697);
var inst_15699 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15695,inst_15698);
var inst_15700 = (function(){throw inst_15699})();
var state_15859__$1 = state_15859;
var statearr_15881_16071 = state_15859__$1;
(statearr_15881_16071[(2)] = inst_15700);

(statearr_15881_16071[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (27))){
var inst_15616 = (state_15859[(17)]);
var state_15859__$1 = state_15859;
var statearr_15882_16072 = state_15859__$1;
(statearr_15882_16072[(2)] = inst_15616);

(statearr_15882_16072[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (1))){
var state_15859__$1 = state_15859;
var statearr_15883_16073 = state_15859__$1;
(statearr_15883_16073[(2)] = null);

(statearr_15883_16073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (69))){
var inst_15706 = (state_15859[(12)]);
var state_15859__$1 = state_15859;
var statearr_15884_16074 = state_15859__$1;
(statearr_15884_16074[(2)] = inst_15706);

(statearr_15884_16074[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (101))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15787 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15718,inst_15719,throw_QMARK_);
var state_15859__$1 = state_15859;
var statearr_15885_16075 = state_15859__$1;
(statearr_15885_16075[(2)] = inst_15787);

(statearr_15885_16075[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (24))){
var inst_15613 = (state_15859[(13)]);
var state_15859__$1 = state_15859;
var statearr_15886_16076 = state_15859__$1;
(statearr_15886_16076[(2)] = inst_15613);

(statearr_15886_16076[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (102))){
var inst_15789 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15887_16077 = state_15859__$1;
(statearr_15887_16077[(2)] = inst_15789);

(statearr_15887_16077[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (55))){
var inst_15685 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15888_16078 = state_15859__$1;
(statearr_15888_16078[(2)] = inst_15685);

(statearr_15888_16078[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (85))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15747 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15718,inst_15719,throw_QMARK_);
var state_15859__$1 = state_15859;
var statearr_15889_16079 = state_15859__$1;
(statearr_15889_16079[(2)] = inst_15747);

(statearr_15889_16079[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (39))){
var inst_15650 = (state_15859[(18)]);
var state_15859__$1 = state_15859;
var statearr_15890_16080 = state_15859__$1;
(statearr_15890_16080[(2)] = inst_15650);

(statearr_15890_16080[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (88))){
var inst_15706 = (state_15859[(12)]);
var state_15859__$1 = state_15859;
var statearr_15891_16081 = state_15859__$1;
(statearr_15891_16081[(2)] = inst_15706);

(statearr_15891_16081[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (46))){
var inst_15587 = (state_15859[(11)]);
var inst_15669 = (state_15859[(19)]);
var inst_15668 = (state_15859[(2)]);
var inst_15669__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15587);
var state_15859__$1 = (function (){var statearr_15892 = state_15859;
(statearr_15892[(14)] = inst_15668);

(statearr_15892[(19)] = inst_15669__$1);

return statearr_15892;
})();
if(cljs.core.truth_(inst_15669__$1)){
var statearr_15893_16082 = state_15859__$1;
(statearr_15893_16082[(1)] = (47));

} else {
var statearr_15894_16083 = state_15859__$1;
(statearr_15894_16083[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (4))){
var inst_15548 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15895_16084 = state_15859__$1;
(statearr_15895_16084[(2)] = inst_15548);

(statearr_15895_16084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (77))){
var inst_15807 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15896_16085 = state_15859__$1;
(statearr_15896_16085[(2)] = inst_15807);

(statearr_15896_16085[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (106))){
var inst_15799 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15897_16086 = state_15859__$1;
(statearr_15897_16086[(2)] = inst_15799);

(statearr_15897_16086[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (119))){
var inst_15585 = (state_15859[(20)]);
var inst_15849 = (state_15859[(2)]);
var inst_15574 = inst_15585;
var inst_15575 = inst_15849;
var state_15859__$1 = (function (){var statearr_15898 = state_15859;
(statearr_15898[(15)] = inst_15575);

(statearr_15898[(21)] = inst_15574);

return statearr_15898;
})();
var statearr_15899_16087 = state_15859__$1;
(statearr_15899_16087[(2)] = null);

(statearr_15899_16087[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (95))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15771 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15772 = (inst_15719.cljs$core$IFn$_invoke$arity$5 ? inst_15719.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_15771,null) : inst_15719.call(null,cljs.core.PersistentArrayMap,null,5,inst_15771,null));
var inst_15773 = (inst_15719.cljs$core$IFn$_invoke$arity$4 ? inst_15719.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15772,null) : inst_15719.call(null,cljs.core.PersistentHashSet,null,inst_15772,null));
var inst_15774 = (inst_15773.cljs$core$IFn$_invoke$arity$1 ? inst_15773.cljs$core$IFn$_invoke$arity$1(inst_15718) : inst_15773.call(null,inst_15718));
var state_15859__$1 = state_15859;
if(cljs.core.truth_(inst_15774)){
var statearr_15900_16088 = state_15859__$1;
(statearr_15900_16088[(1)] = (96));

} else {
var statearr_15901_16089 = state_15859__$1;
(statearr_15901_16089[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (54))){
var inst_15676 = (state_15859[(22)]);
var state_15859__$1 = state_15859;
var statearr_15902_16090 = state_15859__$1;
(statearr_15902_16090[(2)] = inst_15676);

(statearr_15902_16090[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (92))){
var inst_15706 = (state_15859[(12)]);
var state_15859__$1 = state_15859;
var statearr_15903_16091 = state_15859__$1;
(statearr_15903_16091[(2)] = inst_15706);

(statearr_15903_16091[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (104))){
var inst_15706 = (state_15859[(12)]);
var state_15859__$1 = state_15859;
var statearr_15904_16092 = state_15859__$1;
(statearr_15904_16092[(2)] = inst_15706);

(statearr_15904_16092[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (15))){
var inst_15595 = (state_15859[(23)]);
var state_15859__$1 = state_15859;
var statearr_15905_16093 = state_15859__$1;
(statearr_15905_16093[(2)] = inst_15595);

(statearr_15905_16093[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (48))){
var inst_15669 = (state_15859[(19)]);
var state_15859__$1 = state_15859;
var statearr_15906_16094 = state_15859__$1;
(statearr_15906_16094[(2)] = inst_15669);

(statearr_15906_16094[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (50))){
var inst_15587 = (state_15859[(11)]);
var inst_15676 = (state_15859[(22)]);
var inst_15674 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15587);
var inst_15675 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15674);
var inst_15676__$1 = inst_15675 === true;
var state_15859__$1 = (function (){var statearr_15907 = state_15859;
(statearr_15907[(22)] = inst_15676__$1);

return statearr_15907;
})();
if(cljs.core.truth_(inst_15676__$1)){
var statearr_15908_16095 = state_15859__$1;
(statearr_15908_16095[(1)] = (53));

} else {
var statearr_15909_16096 = state_15859__$1;
(statearr_15909_16096[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (116))){
var inst_15830 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15910_16097 = state_15859__$1;
(statearr_15910_16097[(2)] = inst_15830);

(statearr_15910_16097[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (75))){
var inst_15719 = (state_15859[(8)]);
var state_15859__$1 = state_15859;
var G__15911_16098 = inst_15719;
var G__15911_16099__$1 = (((G__15911_16098 instanceof cljs.core.Keyword))?G__15911_16098.fqn:null);
switch (G__15911_16099__$1) {
case "long":
var statearr_15912_16101 = state_15859__$1;
(statearr_15912_16101[(1)] = (79));


break;
case "bigint":
var statearr_15913_16102 = state_15859__$1;
(statearr_15913_16102[(1)] = (83));


break;
case "double":
var statearr_15914_16103 = state_15859__$1;
(statearr_15914_16103[(1)] = (87));


break;
case "float":
var statearr_15915_16104 = state_15859__$1;
(statearr_15915_16104[(1)] = (91));


break;
case "bigdec":
var statearr_15916_16105 = state_15859__$1;
(statearr_15916_16105[(1)] = (95));


break;
case "string":
var statearr_15917_16106 = state_15859__$1;
(statearr_15917_16106[(1)] = (99));


break;
case "instant":
var statearr_15918_16107 = state_15859__$1;
(statearr_15918_16107[(1)] = (103));


break;
default:
var statearr_15919_16108 = state_15859__$1;
(statearr_15919_16108[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (99))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15781 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_15782 = (inst_15719.cljs$core$IFn$_invoke$arity$5 ? inst_15719.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_15781,null) : inst_15719.call(null,cljs.core.PersistentArrayMap,null,5,inst_15781,null));
var inst_15783 = (inst_15719.cljs$core$IFn$_invoke$arity$4 ? inst_15719.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15782,null) : inst_15719.call(null,cljs.core.PersistentHashSet,null,inst_15782,null));
var inst_15784 = (inst_15783.cljs$core$IFn$_invoke$arity$1 ? inst_15783.cljs$core$IFn$_invoke$arity$1(inst_15718) : inst_15783.call(null,inst_15718));
var state_15859__$1 = state_15859;
if(cljs.core.truth_(inst_15784)){
var statearr_15920_16109 = state_15859__$1;
(statearr_15920_16109[(1)] = (100));

} else {
var statearr_15921_16110 = state_15859__$1;
(statearr_15921_16110[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (21))){
var inst_15611 = (state_15859[(24)]);
var state_15859__$1 = state_15859;
var statearr_15922_16111 = state_15859__$1;
(statearr_15922_16111[(2)] = inst_15611);

(statearr_15922_16111[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (31))){
var inst_15627 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15923_16112 = state_15859__$1;
(statearr_15923_16112[(2)] = inst_15627);

(statearr_15923_16112[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (113))){
var inst_15833 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15924_16113 = state_15859__$1;
(statearr_15924_16113[(2)] = inst_15833);

(statearr_15924_16113[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (32))){
var state_15859__$1 = state_15859;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15925_16114 = state_15859__$1;
(statearr_15925_16114[(1)] = (35));

} else {
var statearr_15926_16115 = state_15859__$1;
(statearr_15926_16115[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (40))){
var inst_15663 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
if(cljs.core.truth_(inst_15663)){
var statearr_15927_16116 = state_15859__$1;
(statearr_15927_16116[(1)] = (44));

} else {
var statearr_15928_16117 = state_15859__$1;
(statearr_15928_16117[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (91))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15761 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15762 = (inst_15719.cljs$core$IFn$_invoke$arity$5 ? inst_15719.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_15761,null) : inst_15719.call(null,cljs.core.PersistentArrayMap,null,3,inst_15761,null));
var inst_15763 = (inst_15719.cljs$core$IFn$_invoke$arity$4 ? inst_15719.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15762,null) : inst_15719.call(null,cljs.core.PersistentHashSet,null,inst_15762,null));
var inst_15764 = (inst_15763.cljs$core$IFn$_invoke$arity$1 ? inst_15763.cljs$core$IFn$_invoke$arity$1(inst_15718) : inst_15763.call(null,inst_15718));
var state_15859__$1 = state_15859;
if(cljs.core.truth_(inst_15764)){
var statearr_15929_16118 = state_15859__$1;
(statearr_15929_16118[(1)] = (92));

} else {
var statearr_15930_16119 = state_15859__$1;
(statearr_15930_16119[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (117))){
var state_15859__$1 = state_15859;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15931_16120 = state_15859__$1;
(statearr_15931_16120[(1)] = (120));

} else {
var statearr_15932_16121 = state_15859__$1;
(statearr_15932_16121[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (108))){
var inst_15818 = (state_15859[(25)]);
var inst_15587 = (state_15859[(11)]);
var inst_15818__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15587);
var state_15859__$1 = (function (){var statearr_15933 = state_15859;
(statearr_15933[(25)] = inst_15818__$1);

return statearr_15933;
})();
if(cljs.core.truth_(inst_15818__$1)){
var statearr_15934_16122 = state_15859__$1;
(statearr_15934_16122[(1)] = (111));

} else {
var statearr_15935_16123 = state_15859__$1;
(statearr_15935_16123[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (56))){
var inst_15680 = (state_15859[(2)]);
var inst_15681 = fluree.db.util.async.throw_err(inst_15680);
var inst_15682 = cljs.core.not(inst_15681);
var state_15859__$1 = state_15859;
var statearr_15936_16124 = state_15859__$1;
(statearr_15936_16124[(2)] = inst_15682);

(statearr_15936_16124[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (33))){
var inst_15610 = (state_15859[(26)]);
var state_15859__$1 = state_15859;
var statearr_15937_16125 = state_15859__$1;
(statearr_15937_16125[(2)] = inst_15610);

(statearr_15937_16125[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (13))){
var inst_15605 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
if(cljs.core.truth_(inst_15605)){
var statearr_15938_16126 = state_15859__$1;
(statearr_15938_16126[(1)] = (17));

} else {
var statearr_15939_16127 = state_15859__$1;
(statearr_15939_16127[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (22))){
var inst_15636 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
if(cljs.core.truth_(inst_15636)){
var statearr_15940_16128 = state_15859__$1;
(statearr_15940_16128[(1)] = (32));

} else {
var statearr_15941_16129 = state_15859__$1;
(statearr_15941_16129[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (90))){
var inst_15759 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15942_16130 = state_15859__$1;
(statearr_15942_16130[(2)] = inst_15759);

(statearr_15942_16130[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (109))){
var inst_15816 = (state_15859[(27)]);
var state_15859__$1 = state_15859;
var statearr_15943_16131 = state_15859__$1;
(statearr_15943_16131[(2)] = inst_15816);

(statearr_15943_16131[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (36))){
var inst_15610 = (state_15859[(26)]);
var state_15859__$1 = state_15859;
var statearr_15944_16132 = state_15859__$1;
(statearr_15944_16132[(2)] = inst_15610);

(statearr_15944_16132[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (41))){
var inst_15587 = (state_15859[(11)]);
var inst_15655 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15587);
var inst_15656 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15655);
var inst_15657 = inst_15656 === true;
var state_15859__$1 = state_15859;
var statearr_15945_16133 = state_15859__$1;
(statearr_15945_16133[(2)] = inst_15657);

(statearr_15945_16133[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (118))){
var inst_15814 = (state_15859[(7)]);
var state_15859__$1 = state_15859;
var statearr_15946_16134 = state_15859__$1;
(statearr_15946_16134[(2)] = inst_15814);

(statearr_15946_16134[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (89))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15757 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15718,inst_15719,throw_QMARK_);
var state_15859__$1 = state_15859;
var statearr_15947_16135 = state_15859__$1;
(statearr_15947_16135[(2)] = inst_15757);

(statearr_15947_16135[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (100))){
var inst_15706 = (state_15859[(12)]);
var state_15859__$1 = state_15859;
var statearr_15948_16136 = state_15859__$1;
(statearr_15948_16136[(2)] = inst_15706);

(statearr_15948_16136[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (122))){
var inst_15846 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15949_16137 = state_15859__$1;
(statearr_15949_16137[(2)] = inst_15846);

(statearr_15949_16137[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (43))){
var inst_15660 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15950_16138 = state_15859__$1;
(statearr_15950_16138[(2)] = inst_15660);

(statearr_15950_16138[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (61))){
var inst_15668 = (state_15859[(14)]);
var state_15859__$1 = state_15859;
var statearr_15951_16139 = state_15859__$1;
(statearr_15951_16139[(2)] = inst_15668);

(statearr_15951_16139[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (29))){
var inst_15587 = (state_15859[(11)]);
var inst_15622 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15587);
var inst_15623 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15622);
var inst_15624 = inst_15623 === true;
var state_15859__$1 = state_15859;
var statearr_15952_16140 = state_15859__$1;
(statearr_15952_16140[(2)] = inst_15624);

(statearr_15952_16140[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (44))){
var inst_15649 = (state_15859[(28)]);
var inst_15665 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_15649,"a component","a non-component",throw_QMARK_);
var state_15859__$1 = state_15859;
var statearr_15953_16141 = state_15859__$1;
(statearr_15953_16141[(2)] = inst_15665);

(statearr_15953_16141[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (93))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15767 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15718,inst_15719,throw_QMARK_);
var state_15859__$1 = state_15859;
var statearr_15954_16142 = state_15859__$1;
(statearr_15954_16142[(2)] = inst_15767);

(statearr_15954_16142[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (6))){
var inst_15574 = (state_15859[(21)]);
var inst_15586 = (state_15859[(16)]);
var inst_15583 = cljs.core.seq(inst_15574);
var inst_15584 = cljs.core.first(inst_15583);
var inst_15585 = cljs.core.next(inst_15583);
var inst_15586__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15584,(0),null);
var inst_15587 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15584,(1),null);
var inst_15588 = cljs.core.not(inst_15586__$1);
var state_15859__$1 = (function (){var statearr_15955 = state_15859;
(statearr_15955[(20)] = inst_15585);

(statearr_15955[(11)] = inst_15587);

(statearr_15955[(16)] = inst_15586__$1);

return statearr_15955;
})();
if(inst_15588){
var statearr_15956_16143 = state_15859__$1;
(statearr_15956_16143[(1)] = (8));

} else {
var statearr_15957_16144 = state_15859__$1;
(statearr_15957_16144[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (111))){
var inst_15587 = (state_15859[(11)]);
var inst_15822 = (state_15859[(29)]);
var inst_15820 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15587);
var inst_15821 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15820);
var inst_15822__$1 = inst_15821 === true;
var state_15859__$1 = (function (){var statearr_15958 = state_15859;
(statearr_15958[(29)] = inst_15822__$1);

return statearr_15958;
})();
if(cljs.core.truth_(inst_15822__$1)){
var statearr_15959_16145 = state_15859__$1;
(statearr_15959_16145[(1)] = (114));

} else {
var statearr_15960_16146 = state_15859__$1;
(statearr_15960_16146[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (28))){
var inst_15630 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15961_16147 = state_15859__$1;
(statearr_15961_16147[(2)] = inst_15630);

(statearr_15961_16147[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (64))){
var inst_15707 = (state_15859[(10)]);
var state_15859__$1 = state_15859;
var statearr_15962_16148 = state_15859__$1;
(statearr_15962_16148[(2)] = inst_15707);

(statearr_15962_16148[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (103))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15791 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15792 = (inst_15719.cljs$core$IFn$_invoke$arity$5 ? inst_15719.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_15791,null) : inst_15719.call(null,cljs.core.PersistentArrayMap,null,2,inst_15791,null));
var inst_15793 = (inst_15719.cljs$core$IFn$_invoke$arity$4 ? inst_15719.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15792,null) : inst_15719.call(null,cljs.core.PersistentHashSet,null,inst_15792,null));
var inst_15794 = (inst_15793.cljs$core$IFn$_invoke$arity$1 ? inst_15793.cljs$core$IFn$_invoke$arity$1(inst_15718) : inst_15793.call(null,inst_15718));
var state_15859__$1 = state_15859;
if(cljs.core.truth_(inst_15794)){
var statearr_15963_16149 = state_15859__$1;
(statearr_15963_16149[(1)] = (104));

} else {
var statearr_15964_16150 = state_15859__$1;
(statearr_15964_16150[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (51))){
var inst_15672 = (state_15859[(30)]);
var state_15859__$1 = state_15859;
var statearr_15965_16151 = state_15859__$1;
(statearr_15965_16151[(2)] = inst_15672);

(statearr_15965_16151[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (25))){
var inst_15633 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15966_16152 = state_15859__$1;
(statearr_15966_16152[(2)] = inst_15633);

(statearr_15966_16152[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (34))){
var inst_15587 = (state_15859[(11)]);
var inst_15650 = (state_15859[(18)]);
var inst_15649 = (state_15859[(2)]);
var inst_15650__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15587);
var state_15859__$1 = (function (){var statearr_15967 = state_15859;
(statearr_15967[(28)] = inst_15649);

(statearr_15967[(18)] = inst_15650__$1);

return statearr_15967;
})();
if(cljs.core.truth_(inst_15650__$1)){
var statearr_15968_16153 = state_15859__$1;
(statearr_15968_16153[(1)] = (38));

} else {
var statearr_15969_16154 = state_15859__$1;
(statearr_15969_16154[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (17))){
var inst_15575 = (state_15859[(15)]);
var inst_15607 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_15575,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_15859__$1 = state_15859;
var statearr_15970_16155 = state_15859__$1;
(statearr_15970_16155[(2)] = inst_15607);

(statearr_15970_16155[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (3))){
var inst_15857 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15859__$1,inst_15857);
} else {
if((state_val_15860 === (12))){
var inst_15591 = (state_15859[(31)]);
var state_15859__$1 = state_15859;
var statearr_15971_16156 = state_15859__$1;
(statearr_15971_16156[(2)] = inst_15591);

(statearr_15971_16156[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (2))){
var _ = (function (){var statearr_15972 = state_15859;
(statearr_15972[(4)] = cljs.core.cons((5),(state_15859[(4)])));

return statearr_15972;
})();
var inst_15567 = pred_changes;
var inst_15568 = cljs.core.seq(inst_15567);
var inst_15569 = cljs.core.first(inst_15568);
var inst_15570 = cljs.core.next(inst_15568);
var inst_15571 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15569,(0),null);
var inst_15572 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15569,(1),null);
var inst_15573 = db;
var inst_15574 = inst_15567;
var inst_15575 = inst_15573;
var state_15859__$1 = (function (){var statearr_15973 = state_15859;
(statearr_15973[(15)] = inst_15575);

(statearr_15973[(32)] = inst_15572);

(statearr_15973[(21)] = inst_15574);

(statearr_15973[(33)] = inst_15571);

(statearr_15973[(34)] = inst_15570);

return statearr_15973;
})();
var statearr_15974_16157 = state_15859__$1;
(statearr_15974_16157[(2)] = null);

(statearr_15974_16157[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (66))){
var inst_15587 = (state_15859[(11)]);
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15716 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15587);
var inst_15717 = cljs.core.__destructure_map(inst_15716);
var inst_15718__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15717,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_15719__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15717,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_15720 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15719__$1,inst_15718__$1);
var state_15859__$1 = (function (){var statearr_15975 = state_15859;
(statearr_15975[(8)] = inst_15719__$1);

(statearr_15975[(9)] = inst_15718__$1);

return statearr_15975;
})();
if(inst_15720){
var statearr_15976_16158 = state_15859__$1;
(statearr_15976_16158[(1)] = (69));

} else {
var statearr_15977_16159 = state_15859__$1;
(statearr_15977_16159[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (107))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15801 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15718,inst_15719,throw_QMARK_);
var state_15859__$1 = state_15859;
var statearr_15978_16160 = state_15859__$1;
(statearr_15978_16160[(2)] = inst_15801);

(statearr_15978_16160[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (23))){
var inst_15616 = (state_15859[(17)]);
var inst_15587 = (state_15859[(11)]);
var inst_15615 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15587);
var inst_15616__$1 = inst_15615 === true;
var state_15859__$1 = (function (){var statearr_15979 = state_15859;
(statearr_15979[(17)] = inst_15616__$1);

return statearr_15979;
})();
if(cljs.core.truth_(inst_15616__$1)){
var statearr_15980_16161 = state_15859__$1;
(statearr_15980_16161[(1)] = (26));

} else {
var statearr_15981_16162 = state_15859__$1;
(statearr_15981_16162[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (47))){
var inst_15587 = (state_15859[(11)]);
var inst_15672 = (state_15859[(30)]);
var inst_15671 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15587);
var inst_15672__$1 = cljs.core.not(inst_15671);
var state_15859__$1 = (function (){var statearr_15982 = state_15859;
(statearr_15982[(30)] = inst_15672__$1);

return statearr_15982;
})();
if(inst_15672__$1){
var statearr_15983_16163 = state_15859__$1;
(statearr_15983_16163[(1)] = (50));

} else {
var statearr_15984_16164 = state_15859__$1;
(statearr_15984_16164[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (35))){
var inst_15639 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15640 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15641 = cljs.core.PersistentHashMap.fromArrays(inst_15639,inst_15640);
var inst_15642 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_15641);
var inst_15643 = (function(){throw inst_15642})();
var state_15859__$1 = state_15859;
var statearr_15985_16165 = state_15859__$1;
(statearr_15985_16165[(2)] = inst_15643);

(statearr_15985_16165[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (82))){
var inst_15739 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_15986_16166 = state_15859__$1;
(statearr_15986_16166[(2)] = inst_15739);

(statearr_15986_16166[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (76))){
var state_15859__$1 = state_15859;
var statearr_15987_16167 = state_15859__$1;
(statearr_15987_16167[(2)] = null);

(statearr_15987_16167[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (97))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15777 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15718,inst_15719,throw_QMARK_);
var state_15859__$1 = state_15859;
var statearr_15988_16168 = state_15859__$1;
(statearr_15988_16168[(2)] = inst_15777);

(statearr_15988_16168[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (19))){
var inst_15587 = (state_15859[(11)]);
var inst_15611 = (state_15859[(24)]);
var inst_15610 = (state_15859[(2)]);
var inst_15611__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15587);
var state_15859__$1 = (function (){var statearr_15989 = state_15859;
(statearr_15989[(26)] = inst_15610);

(statearr_15989[(24)] = inst_15611__$1);

return statearr_15989;
})();
if(cljs.core.truth_(inst_15611__$1)){
var statearr_15990_16169 = state_15859__$1;
(statearr_15990_16169[(1)] = (20));

} else {
var statearr_15991_16170 = state_15859__$1;
(statearr_15991_16170[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (57))){
var state_15859__$1 = state_15859;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15992_16171 = state_15859__$1;
(statearr_15992_16171[(1)] = (60));

} else {
var statearr_15993_16172 = state_15859__$1;
(statearr_15993_16172[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (68))){
var inst_15816 = (state_15859[(27)]);
var inst_15587 = (state_15859[(11)]);
var inst_15814 = (state_15859[(2)]);
var inst_15815 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15587);
var inst_15816__$1 = inst_15815 === true;
var state_15859__$1 = (function (){var statearr_15994 = state_15859;
(statearr_15994[(27)] = inst_15816__$1);

(statearr_15994[(7)] = inst_15814);

return statearr_15994;
})();
if(cljs.core.truth_(inst_15816__$1)){
var statearr_15995_16173 = state_15859__$1;
(statearr_15995_16173[(1)] = (108));

} else {
var statearr_15996_16174 = state_15859__$1;
(statearr_15996_16174[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (11))){
var inst_15587 = (state_15859[(11)]);
var inst_15595 = (state_15859[(23)]);
var inst_15593 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15587);
var inst_15594 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15593);
var inst_15595__$1 = inst_15594 === false;
var state_15859__$1 = (function (){var statearr_15997 = state_15859;
(statearr_15997[(23)] = inst_15595__$1);

return statearr_15997;
})();
if(cljs.core.truth_(inst_15595__$1)){
var statearr_15998_16175 = state_15859__$1;
(statearr_15998_16175[(1)] = (14));

} else {
var statearr_15999_16176 = state_15859__$1;
(statearr_15999_16176[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (115))){
var inst_15822 = (state_15859[(29)]);
var state_15859__$1 = state_15859;
var statearr_16001_16177 = state_15859__$1;
(statearr_16001_16177[(2)] = inst_15822);

(statearr_16001_16177[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (9))){
var inst_15587 = (state_15859[(11)]);
var inst_15591 = (state_15859[(31)]);
var inst_15591__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15587);
var state_15859__$1 = (function (){var statearr_16002 = state_15859;
(statearr_16002[(31)] = inst_15591__$1);

return statearr_16002;
})();
if(cljs.core.truth_(inst_15591__$1)){
var statearr_16003_16178 = state_15859__$1;
(statearr_16003_16178[(1)] = (11));

} else {
var statearr_16004_16179 = state_15859__$1;
(statearr_16004_16179[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (5))){
var _ = (function (){var statearr_16005 = state_15859;
(statearr_16005[(4)] = cljs.core.rest((state_15859[(4)])));

return statearr_16005;
})();
var state_15859__$1 = state_15859;
var ex16000 = (state_15859__$1[(2)]);
var statearr_16006_16180 = state_15859__$1;
(statearr_16006_16180[(5)] = ex16000);


if((ex16000 instanceof Error)){
var statearr_16007_16181 = state_15859__$1;
(statearr_16007_16181[(1)] = (4));

(statearr_16007_16181[(5)] = null);

} else {
throw ex16000;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (112))){
var inst_15818 = (state_15859[(25)]);
var state_15859__$1 = state_15859;
var statearr_16008_16182 = state_15859__$1;
(statearr_16008_16182[(2)] = inst_15818);

(statearr_16008_16182[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (83))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15741 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15742 = (inst_15719.cljs$core$IFn$_invoke$arity$5 ? inst_15719.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_15741,null) : inst_15719.call(null,cljs.core.PersistentArrayMap,null,3,inst_15741,null));
var inst_15743 = (inst_15719.cljs$core$IFn$_invoke$arity$4 ? inst_15719.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15742,null) : inst_15719.call(null,cljs.core.PersistentHashSet,null,inst_15742,null));
var inst_15744 = (inst_15743.cljs$core$IFn$_invoke$arity$1 ? inst_15743.cljs$core$IFn$_invoke$arity$1(inst_15718) : inst_15743.call(null,inst_15718));
var state_15859__$1 = state_15859;
if(cljs.core.truth_(inst_15744)){
var statearr_16009_16183 = state_15859__$1;
(statearr_16009_16183[(1)] = (84));

} else {
var statearr_16010_16184 = state_15859__$1;
(statearr_16010_16184[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (14))){
var inst_15587 = (state_15859[(11)]);
var inst_15597 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15587);
var inst_15598 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_15597);
var inst_15599 = inst_15598 === true;
var state_15859__$1 = state_15859;
var statearr_16011_16185 = state_15859__$1;
(statearr_16011_16185[(2)] = inst_15599);

(statearr_16011_16185[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (45))){
var inst_15649 = (state_15859[(28)]);
var state_15859__$1 = state_15859;
var statearr_16012_16186 = state_15859__$1;
(statearr_16012_16186[(2)] = inst_15649);

(statearr_16012_16186[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (53))){
var inst_15575 = (state_15859[(15)]);
var inst_15586 = (state_15859[(16)]);
var inst_15678 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_15575,inst_15586);
var state_15859__$1 = state_15859;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15859__$1,(56),inst_15678);
} else {
if((state_val_15860 === (78))){
var inst_15804 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_16013_16187 = state_15859__$1;
(statearr_16013_16187[(2)] = inst_15804);

(statearr_16013_16187[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (26))){
var inst_15587 = (state_15859[(11)]);
var inst_15620 = (state_15859[(35)]);
var inst_15618 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15587);
var inst_15619 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15618);
var inst_15620__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_15619);
var state_15859__$1 = (function (){var statearr_16014 = state_15859;
(statearr_16014[(35)] = inst_15620__$1);

return statearr_16014;
})();
if(inst_15620__$1){
var statearr_16015_16188 = state_15859__$1;
(statearr_16015_16188[(1)] = (29));

} else {
var statearr_16016_16189 = state_15859__$1;
(statearr_16016_16189[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (16))){
var inst_15602 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_16017_16190 = state_15859__$1;
(statearr_16017_16190[(2)] = inst_15602);

(statearr_16017_16190[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (81))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15737 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15718,inst_15719,throw_QMARK_);
var state_15859__$1 = state_15859;
var statearr_16018_16191 = state_15859__$1;
(statearr_16018_16191[(2)] = inst_15737);

(statearr_16018_16191[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (120))){
var inst_15839 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15840 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15841 = cljs.core.PersistentHashMap.fromArrays(inst_15839,inst_15840);
var inst_15842 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_15841);
var inst_15843 = (function(){throw inst_15842})();
var state_15859__$1 = state_15859;
var statearr_16019_16192 = state_15859__$1;
(statearr_16019_16192[(2)] = inst_15843);

(statearr_16019_16192[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (79))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15731 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15732 = (inst_15719.cljs$core$IFn$_invoke$arity$5 ? inst_15719.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_15731,null) : inst_15719.call(null,cljs.core.PersistentArrayMap,null,2,inst_15731,null));
var inst_15733 = (inst_15719.cljs$core$IFn$_invoke$arity$4 ? inst_15719.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15732,null) : inst_15719.call(null,cljs.core.PersistentHashSet,null,inst_15732,null));
var inst_15734 = (inst_15733.cljs$core$IFn$_invoke$arity$1 ? inst_15733.cljs$core$IFn$_invoke$arity$1(inst_15718) : inst_15733.call(null,inst_15718));
var state_15859__$1 = state_15859;
if(cljs.core.truth_(inst_15734)){
var statearr_16020_16193 = state_15859__$1;
(statearr_16020_16193[(1)] = (80));

} else {
var statearr_16021_16194 = state_15859__$1;
(statearr_16021_16194[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (38))){
var inst_15587 = (state_15859[(11)]);
var inst_15653 = (state_15859[(36)]);
var inst_15652 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15587);
var inst_15653__$1 = cljs.core.not(inst_15652);
var state_15859__$1 = (function (){var statearr_16022 = state_15859;
(statearr_16022[(36)] = inst_15653__$1);

return statearr_16022;
})();
if(inst_15653__$1){
var statearr_16023_16195 = state_15859__$1;
(statearr_16023_16195[(1)] = (41));

} else {
var statearr_16024_16196 = state_15859__$1;
(statearr_16024_16196[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (98))){
var inst_15779 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_16025_16197 = state_15859__$1;
(statearr_16025_16197[(2)] = inst_15779);

(statearr_16025_16197[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (87))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15751 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15752 = (inst_15719.cljs$core$IFn$_invoke$arity$5 ? inst_15719.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_15751,null) : inst_15719.call(null,cljs.core.PersistentArrayMap,null,3,inst_15751,null));
var inst_15753 = (inst_15719.cljs$core$IFn$_invoke$arity$4 ? inst_15719.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15752,null) : inst_15719.call(null,cljs.core.PersistentHashSet,null,inst_15752,null));
var inst_15754 = (inst_15753.cljs$core$IFn$_invoke$arity$1 ? inst_15753.cljs$core$IFn$_invoke$arity$1(inst_15718) : inst_15753.call(null,inst_15718));
var state_15859__$1 = state_15859;
if(cljs.core.truth_(inst_15754)){
var statearr_16026_16198 = state_15859__$1;
(statearr_16026_16198[(1)] = (88));

} else {
var statearr_16027_16199 = state_15859__$1;
(statearr_16027_16199[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (30))){
var inst_15620 = (state_15859[(35)]);
var state_15859__$1 = state_15859;
var statearr_16028_16200 = state_15859__$1;
(statearr_16028_16200[(2)] = inst_15620);

(statearr_16028_16200[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (73))){
var state_15859__$1 = state_15859;
var statearr_16029_16201 = state_15859__$1;
(statearr_16029_16201[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (96))){
var inst_15706 = (state_15859[(12)]);
var state_15859__$1 = state_15859;
var statearr_16031_16202 = state_15859__$1;
(statearr_16031_16202[(2)] = inst_15706);

(statearr_16031_16202[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (10))){
var inst_15852 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_16032_16203 = state_15859__$1;
(statearr_16032_16203[(2)] = inst_15852);

(statearr_16032_16203[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (18))){
var inst_15575 = (state_15859[(15)]);
var state_15859__$1 = state_15859;
var statearr_16033_16204 = state_15859__$1;
(statearr_16033_16204[(2)] = inst_15575);

(statearr_16033_16204[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (105))){
var inst_15719 = (state_15859[(8)]);
var inst_15718 = (state_15859[(9)]);
var inst_15797 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15718,inst_15719,throw_QMARK_);
var state_15859__$1 = state_15859;
var statearr_16034_16205 = state_15859__$1;
(statearr_16034_16205[(2)] = inst_15797);

(statearr_16034_16205[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (52))){
var inst_15688 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_16035_16206 = state_15859__$1;
(statearr_16035_16206[(2)] = inst_15688);

(statearr_16035_16206[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (114))){
var inst_15587 = (state_15859[(11)]);
var inst_15824 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15587);
var inst_15825 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15824);
var inst_15826 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_15825);
var inst_15827 = (!(inst_15826));
var state_15859__$1 = state_15859;
var statearr_16036_16207 = state_15859__$1;
(statearr_16036_16207[(2)] = inst_15827);

(statearr_16036_16207[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (67))){
var inst_15706 = (state_15859[(12)]);
var state_15859__$1 = state_15859;
var statearr_16037_16208 = state_15859__$1;
(statearr_16037_16208[(2)] = inst_15706);

(statearr_16037_16208[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (71))){
var inst_15811 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_16038_16209 = state_15859__$1;
(statearr_16038_16209[(2)] = inst_15811);

(statearr_16038_16209[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (42))){
var inst_15653 = (state_15859[(36)]);
var state_15859__$1 = state_15859;
var statearr_16039_16210 = state_15859__$1;
(statearr_16039_16210[(2)] = inst_15653);

(statearr_16039_16210[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (80))){
var inst_15706 = (state_15859[(12)]);
var state_15859__$1 = state_15859;
var statearr_16040_16211 = state_15859__$1;
(statearr_16040_16211[(2)] = inst_15706);

(statearr_16040_16211[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (37))){
var inst_15646 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_16041_16212 = state_15859__$1;
(statearr_16041_16212[(2)] = inst_15646);

(statearr_16041_16212[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (63))){
var inst_15587 = (state_15859[(11)]);
var inst_15709 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15587);
var inst_15710 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_15709);
var state_15859__$1 = state_15859;
var statearr_16042_16213 = state_15859__$1;
(statearr_16042_16213[(2)] = inst_15710);

(statearr_16042_16213[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (94))){
var inst_15769 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
var statearr_16043_16214 = state_15859__$1;
(statearr_16043_16214[(2)] = inst_15769);

(statearr_16043_16214[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (8))){
var inst_15575 = (state_15859[(15)]);
var state_15859__$1 = state_15859;
var statearr_16044_16215 = state_15859__$1;
(statearr_16044_16215[(2)] = inst_15575);

(statearr_16044_16215[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (49))){
var inst_15691 = (state_15859[(2)]);
var state_15859__$1 = state_15859;
if(cljs.core.truth_(inst_15691)){
var statearr_16045_16216 = state_15859__$1;
(statearr_16045_16216[(1)] = (57));

} else {
var statearr_16046_16217 = state_15859__$1;
(statearr_16046_16217[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15860 === (84))){
var inst_15706 = (state_15859[(12)]);
var state_15859__$1 = state_15859;
var statearr_16047_16218 = state_15859__$1;
(statearr_16047_16218[(2)] = inst_15706);

(statearr_16047_16218[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2727__auto__ = null;
var fluree$db$query$schema$state_machine__2727__auto____0 = (function (){
var statearr_16048 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16048[(0)] = fluree$db$query$schema$state_machine__2727__auto__);

(statearr_16048[(1)] = (1));

return statearr_16048;
});
var fluree$db$query$schema$state_machine__2727__auto____1 = (function (state_15859){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15859);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16049){var ex__2730__auto__ = e16049;
var statearr_16050_16219 = state_15859;
(statearr_16050_16219[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15859[(4)]))){
var statearr_16051_16220 = state_15859;
(statearr_16051_16220[(1)] = cljs.core.first((state_15859[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16221 = state_15859;
state_15859 = G__16221;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2727__auto__ = function(state_15859){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2727__auto____1.call(this,state_15859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2727__auto____0;
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2727__auto____1;
return fluree$db$query$schema$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16052 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16052[(6)] = c__2749__auto__);

return statearr_16052;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16223 = arguments.length;
switch (G__16223) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16247){
var state_val_16248 = (state_16247[(1)]);
if((state_val_16248 === (7))){
var state_16247__$1 = state_16247;
var statearr_16249_16269 = state_16247__$1;
(statearr_16249_16269[(2)] = db);

(statearr_16249_16269[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16248 === (1))){
var state_16247__$1 = state_16247;
var statearr_16250_16270 = state_16247__$1;
(statearr_16250_16270[(2)] = null);

(statearr_16250_16270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16248 === (4))){
var inst_16224 = (state_16247[(2)]);
var state_16247__$1 = state_16247;
var statearr_16251_16271 = state_16247__$1;
(statearr_16251_16271[(2)] = inst_16224);

(statearr_16251_16271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16248 === (6))){
var inst_16233 = (state_16247[(7)]);
var inst_16232 = (state_16247[(2)]);
var inst_16233__$1 = fluree.db.util.async.throw_err(inst_16232);
var inst_16234 = cljs.core.empty_QMARK_(inst_16233__$1);
var state_16247__$1 = (function (){var statearr_16252 = state_16247;
(statearr_16252[(7)] = inst_16233__$1);

return statearr_16252;
})();
if(inst_16234){
var statearr_16253_16272 = state_16247__$1;
(statearr_16253_16272[(1)] = (7));

} else {
var statearr_16254_16273 = state_16247__$1;
(statearr_16254_16273[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16248 === (3))){
var inst_16245 = (state_16247[(2)]);
var state_16247__$1 = state_16247;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16247__$1,inst_16245);
} else {
if((state_val_16248 === (2))){
var _ = (function (){var statearr_16256 = state_16247;
(statearr_16256[(4)] = cljs.core.cons((5),(state_16247[(4)])));

return statearr_16256;
})();
var inst_16230 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_16247__$1 = state_16247;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16247__$1,(6),inst_16230);
} else {
if((state_val_16248 === (9))){
var inst_16242 = (state_16247[(2)]);
var _ = (function (){var statearr_16257 = state_16247;
(statearr_16257[(4)] = cljs.core.rest((state_16247[(4)])));

return statearr_16257;
})();
var state_16247__$1 = state_16247;
var statearr_16258_16274 = state_16247__$1;
(statearr_16258_16274[(2)] = inst_16242);

(statearr_16258_16274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16248 === (5))){
var _ = (function (){var statearr_16259 = state_16247;
(statearr_16259[(4)] = cljs.core.rest((state_16247[(4)])));

return statearr_16259;
})();
var state_16247__$1 = state_16247;
var ex16255 = (state_16247__$1[(2)]);
var statearr_16260_16275 = state_16247__$1;
(statearr_16260_16275[(5)] = ex16255);


if((ex16255 instanceof Error)){
var statearr_16261_16276 = state_16247__$1;
(statearr_16261_16276[(1)] = (4));

(statearr_16261_16276[(5)] = null);

} else {
throw ex16255;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16248 === (10))){
var inst_16239 = (state_16247[(2)]);
var inst_16240 = fluree.db.util.async.throw_err(inst_16239);
var state_16247__$1 = state_16247;
var statearr_16262_16277 = state_16247__$1;
(statearr_16262_16277[(2)] = inst_16240);

(statearr_16262_16277[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16248 === (8))){
var inst_16233 = (state_16247[(7)]);
var inst_16237 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_16233,db,true);
var state_16247__$1 = state_16247;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16247__$1,(10),inst_16237);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2727__auto__ = null;
var fluree$db$query$schema$state_machine__2727__auto____0 = (function (){
var statearr_16263 = [null,null,null,null,null,null,null,null];
(statearr_16263[(0)] = fluree$db$query$schema$state_machine__2727__auto__);

(statearr_16263[(1)] = (1));

return statearr_16263;
});
var fluree$db$query$schema$state_machine__2727__auto____1 = (function (state_16247){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16247);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16264){var ex__2730__auto__ = e16264;
var statearr_16265_16278 = state_16247;
(statearr_16265_16278[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16247[(4)]))){
var statearr_16266_16279 = state_16247;
(statearr_16266_16279[(1)] = cljs.core.first((state_16247[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16280 = state_16247;
state_16247 = G__16280;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2727__auto__ = function(state_16247){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2727__auto____1.call(this,state_16247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2727__auto____0;
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2727__auto____1;
return fluree$db$query$schema$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16267 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16267[(6)] = c__2749__auto__);

return statearr_16267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16282 = arguments.length;
switch (G__16282) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16284 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16284,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16284,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16284,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = fluree.db.flake.p(flake);
var o = fluree.db.flake.o(flake);
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4251__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4251__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__16287_SHARP_,p2__16288_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16287_SHARP_,p2__16288_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__16289_SHARP_){
var f = p1__16289_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,fluree.db.flake.p(f))){
return fluree.db.flake.o(f);
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16355){
var state_val_16356 = (state_16355[(1)]);
if((state_val_16356 === (1))){
var state_16355__$1 = state_16355;
var statearr_16357_16375 = state_16355__$1;
(statearr_16357_16375[(2)] = null);

(statearr_16357_16375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (2))){
var _ = (function (){var statearr_16358 = state_16355;
(statearr_16358[(4)] = cljs.core.cons((5),(state_16355[(4)])));

return statearr_16358;
})();
var inst_16307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16308 = fluree.db.flake.max_subject_id((1));
var inst_16309 = [inst_16308];
var inst_16310 = (new cljs.core.PersistentVector(null,1,(5),inst_16307,inst_16309,null));
var inst_16311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16312 = [(0)];
var inst_16313 = (new cljs.core.PersistentVector(null,1,(5),inst_16311,inst_16312,null));
var inst_16314 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16310,cljs.core._LT__EQ_,inst_16313);
var state_16355__$1 = state_16355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16355__$1,(6),inst_16314);
} else {
if((state_val_16356 === (3))){
var inst_16353 = (state_16355[(2)]);
var state_16355__$1 = state_16355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16355__$1,inst_16353);
} else {
if((state_val_16356 === (4))){
var inst_16295 = (state_16355[(2)]);
var state_16355__$1 = state_16355;
var statearr_16360_16376 = state_16355__$1;
(statearr_16360_16376[(2)] = inst_16295);

(statearr_16360_16376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (5))){
var _ = (function (){var statearr_16361 = state_16355;
(statearr_16361[(4)] = cljs.core.rest((state_16355[(4)])));

return statearr_16361;
})();
var state_16355__$1 = state_16355;
var ex16359 = (state_16355__$1[(2)]);
var statearr_16362_16377 = state_16355__$1;
(statearr_16362_16377[(5)] = ex16359);


if((ex16359 instanceof Error)){
var statearr_16363_16378 = state_16355__$1;
(statearr_16363_16378[(1)] = (4));

(statearr_16363_16378[(5)] = null);

} else {
throw ex16359;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16356 === (6))){
var inst_16316 = (state_16355[(2)]);
var inst_16317 = fluree.db.util.async.throw_err(inst_16316);
var inst_16318 = (function (){var schema_flakes = inst_16317;
return (function (p1__16290_SHARP_){
return (fluree.db.flake.s(p1__16290_SHARP_) <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_16319 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16318,inst_16317);
var inst_16320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16319,(0),null);
var inst_16321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16319,(1),null);
var inst_16322 = (function (){var schema_flakes = inst_16317;
var vec__16301 = inst_16319;
var collection_flakes = inst_16320;
var predicate_flakes = inst_16321;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = fluree.db.flake.s(first_flake);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__16293_SHARP_,p2__16292_SHARP_){
var f = p2__16292_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__16293_SHARP_,fluree.db.flake.p(f),fluree.db.flake.o(f));
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_16323 = [(-1),"_tx"];
var inst_16324 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16325 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16326 = cljs.core.PersistentHashMap.fromArrays(inst_16324,inst_16325);
var inst_16327 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16328 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16329 = cljs.core.PersistentHashMap.fromArrays(inst_16327,inst_16328);
var inst_16330 = [inst_16326,inst_16329];
var inst_16331 = cljs.core.PersistentHashMap.fromArrays(inst_16323,inst_16330);
var inst_16332 = (function (){var schema_flakes = inst_16317;
var vec__16301 = inst_16319;
var collection_flakes = inst_16320;
var predicate_flakes = inst_16321;
return (function (p1__16291_SHARP_){
return fluree.db.flake.s(p1__16291_SHARP_);
});
})();
var inst_16333 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16332,inst_16320);
var inst_16334 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16322,inst_16331,inst_16333);
var inst_16336 = (function (){var schema_flakes = inst_16317;
var vec__16301 = inst_16319;
var collection_flakes = inst_16320;
var predicate_flakes = inst_16321;
var coll = inst_16334;
return (function (p__16335,pred_flakes){
var vec__16364 = p__16335;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16364,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16364,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = fluree.db.flake.s(first_flake);
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__16367 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__16367.cljs$core$IFn$_invoke$arity$1 ? fexpr__16367.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__16367.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4253__auto__ = ref_QMARK_;
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_16337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16338 = cljs.core.PersistentHashMap.EMPTY;
var inst_16339 = cljs.core.PersistentHashSet.EMPTY;
var inst_16340 = [inst_16338,inst_16339];
var inst_16341 = (new cljs.core.PersistentVector(null,2,(5),inst_16337,inst_16340,null));
var inst_16342 = (function (){var schema_flakes = inst_16317;
var vec__16301 = inst_16319;
var collection_flakes = inst_16320;
var predicate_flakes = inst_16321;
var coll = inst_16334;
return (function (p1__16294_SHARP_){
return fluree.db.flake.s(p1__16294_SHARP_);
});
})();
var inst_16343 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16342,inst_16321);
var inst_16344 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16336,inst_16341,inst_16343);
var inst_16345 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16344,(0),null);
var inst_16346 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16344,(1),null);
var inst_16347 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_16348 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_16349 = [inst_16348,inst_16334,inst_16345,inst_16346];
var inst_16350 = cljs.core.PersistentHashMap.fromArrays(inst_16347,inst_16349);
var _ = (function (){var statearr_16368 = state_16355;
(statearr_16368[(4)] = cljs.core.rest((state_16355[(4)])));

return statearr_16368;
})();
var state_16355__$1 = state_16355;
var statearr_16369_16379 = state_16355__$1;
(statearr_16369_16379[(2)] = inst_16350);

(statearr_16369_16379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0 = (function (){
var statearr_16370 = [null,null,null,null,null,null,null];
(statearr_16370[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2727__auto__);

(statearr_16370[(1)] = (1));

return statearr_16370;
});
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1 = (function (state_16355){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16355);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16371){var ex__2730__auto__ = e16371;
var statearr_16372_16380 = state_16355;
(statearr_16372_16380[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16355[(4)]))){
var statearr_16373_16381 = state_16355;
(statearr_16373_16381[(1)] = cljs.core.first((state_16355[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16382 = state_16355;
state_16355 = G__16382;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__ = function(state_16355){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1.call(this,state_16355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16374 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16374[(6)] = c__2749__auto__);

return statearr_16374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16424){
var state_val_16425 = (state_16424[(1)]);
if((state_val_16425 === (7))){
var inst_16407 = (state_16424[(2)]);
var inst_16408 = fluree.db.query.schema.flake__GT_pred_map(inst_16407);
var inst_16409 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_16410 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16408,(114));
var inst_16411 = cljs.core.boolean$(inst_16410);
var inst_16412 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16408,(110));
var inst_16413 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16408,(117));
var inst_16414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_16413);
var inst_16415 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16408,(111));
var inst_16416 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16408,(115));
var inst_16417 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16408,(112));
var inst_16418 = [inst_16411,inst_16412,inst_16414,inst_16415,inst_16416,inst_16417];
var inst_16419 = cljs.core.PersistentHashMap.fromArrays(inst_16409,inst_16418);
var _ = (function (){var statearr_16426 = state_16424;
(statearr_16426[(4)] = cljs.core.rest((state_16424[(4)])));

return statearr_16426;
})();
var state_16424__$1 = state_16424;
var statearr_16427_16450 = state_16424__$1;
(statearr_16427_16450[(2)] = inst_16419);

(statearr_16427_16450[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (1))){
var state_16424__$1 = state_16424;
var statearr_16428_16451 = state_16424__$1;
(statearr_16428_16451[(2)] = null);

(statearr_16428_16451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (4))){
var inst_16383 = (state_16424[(2)]);
var state_16424__$1 = state_16424;
var statearr_16429_16452 = state_16424__$1;
(statearr_16429_16452[(2)] = inst_16383);

(statearr_16429_16452[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (6))){
var _ = (function (){var statearr_16430 = state_16424;
(statearr_16430[(4)] = cljs.core.cons((9),(state_16424[(4)])));

return statearr_16430;
})();
var inst_16395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16397 = ["_setting/id","root"];
var inst_16398 = (new cljs.core.PersistentVector(null,2,(5),inst_16396,inst_16397,null));
var inst_16399 = [inst_16398];
var inst_16400 = (new cljs.core.PersistentVector(null,1,(5),inst_16395,inst_16399,null));
var inst_16401 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16400);
var state_16424__$1 = state_16424;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16424__$1,(10),inst_16401);
} else {
if((state_val_16425 === (3))){
var inst_16422 = (state_16424[(2)]);
var state_16424__$1 = state_16424;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16424__$1,inst_16422);
} else {
if((state_val_16425 === (2))){
var _ = (function (){var statearr_16433 = state_16424;
(statearr_16433[(4)] = cljs.core.cons((5),(state_16424[(4)])));

return statearr_16433;
})();
var state_16424__$1 = state_16424;
var statearr_16434_16453 = state_16424__$1;
(statearr_16434_16453[(2)] = null);

(statearr_16434_16453[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (9))){
var _ = (function (){var statearr_16435 = state_16424;
(statearr_16435[(4)] = cljs.core.rest((state_16424[(4)])));

return statearr_16435;
})();
var state_16424__$1 = state_16424;
var ex16431 = (state_16424__$1[(2)]);
var statearr_16436_16454 = state_16424__$1;
(statearr_16436_16454[(5)] = ex16431);


var statearr_16437_16455 = state_16424__$1;
(statearr_16437_16455[(1)] = (8));

(statearr_16437_16455[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (5))){
var _ = (function (){var statearr_16438 = state_16424;
(statearr_16438[(4)] = cljs.core.rest((state_16424[(4)])));

return statearr_16438;
})();
var state_16424__$1 = state_16424;
var ex16432 = (state_16424__$1[(2)]);
var statearr_16439_16456 = state_16424__$1;
(statearr_16439_16456[(5)] = ex16432);


if((ex16432 instanceof Error)){
var statearr_16440_16457 = state_16424__$1;
(statearr_16440_16457[(1)] = (4));

(statearr_16440_16457[(5)] = null);

} else {
throw ex16432;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (10))){
var inst_16403 = (state_16424[(2)]);
var inst_16404 = fluree.db.util.async.throw_err(inst_16403);
var _ = (function (){var statearr_16441 = state_16424;
(statearr_16441[(4)] = cljs.core.rest((state_16424[(4)])));

return statearr_16441;
})();
var state_16424__$1 = state_16424;
var statearr_16442_16458 = state_16424__$1;
(statearr_16442_16458[(2)] = inst_16404);

(statearr_16442_16458[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16425 === (8))){
var inst_16389 = (state_16424[(2)]);
var state_16424__$1 = (function (){var statearr_16443 = state_16424;
(statearr_16443[(7)] = inst_16389);

return statearr_16443;
})();
var statearr_16444_16459 = state_16424__$1;
(statearr_16444_16459[(2)] = null);

(statearr_16444_16459[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0 = (function (){
var statearr_16445 = [null,null,null,null,null,null,null,null];
(statearr_16445[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2727__auto__);

(statearr_16445[(1)] = (1));

return statearr_16445;
});
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1 = (function (state_16424){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16424);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16446){var ex__2730__auto__ = e16446;
var statearr_16447_16460 = state_16424;
(statearr_16447_16460[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16424[(4)]))){
var statearr_16448_16461 = state_16424;
(statearr_16448_16461[(1)] = cljs.core.first((state_16424[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16462 = state_16424;
state_16424 = G__16462;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__ = function(state_16424){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1.call(this,state_16424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16449 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16449[(6)] = c__2749__auto__);

return statearr_16449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
