// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.subject');
goog.require('fluree.db.query.subject_crawl.rdf_type');
goog.require('fluree.db.query.subject_crawl.common');
/**
 * Returns a parsed selection specification.
 * 
 *   This strategy is only deployed if there is a single selection graph crawl,
 *   so this assumes this case is true in code.
 */
fluree.db.query.subject_crawl.core.retrieve_select_spec = (function fluree$db$query$subject_crawl$core$retrieve_select_spec(db,p__23734){
var map__23735 = p__23734;
var map__23735__$1 = cljs.core.__destructure_map(map__23735);
var parsed_query = map__23735__$1;
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23735__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23735__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var select_smt = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(select)));
return fluree.db.query.fql_parser.parse_db(db,select_smt,opts);
});
fluree.db.query.subject_crawl.core.relationship_binding = (function fluree$db$query$subject_crawl$core$relationship_binding(p__23736){
var map__23737 = p__23736;
var map__23737__$1 = cljs.core.__destructure_map(map__23737);
var opts = map__23737__$1;
var rdf_type_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23737__$1,new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23737__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23781){
var state_val_23782 = (state_23781[(1)]);
if((state_val_23782 === (7))){
var inst_23760 = (state_23781[(7)]);
var inst_23762 = fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl(inst_23760);
var state_23781__$1 = state_23781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23781__$1,(10),inst_23762);
} else {
if((state_val_23782 === (1))){
var inst_23745 = vars;
var inst_23746 = cljs.core.seq(inst_23745);
var inst_23747 = cljs.core.first(inst_23746);
var inst_23748 = cljs.core.next(inst_23746);
var inst_23749 = cljs.core.PersistentVector.EMPTY;
var inst_23750 = inst_23745;
var inst_23751 = inst_23749;
var state_23781__$1 = (function (){var statearr_23783 = state_23781;
(statearr_23783[(8)] = inst_23750);

(statearr_23783[(9)] = inst_23747);

(statearr_23783[(10)] = inst_23751);

(statearr_23783[(11)] = inst_23748);

return statearr_23783;
})();
var statearr_23784_23802 = state_23781__$1;
(statearr_23784_23802[(2)] = null);

(statearr_23784_23802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23782 === (4))){
var inst_23757 = (state_23781[(12)]);
var inst_23760 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_23757);
var state_23781__$1 = (function (){var statearr_23785 = state_23781;
(statearr_23785[(7)] = inst_23760);

return statearr_23785;
})();
if(cljs.core.truth_(rdf_type_QMARK_)){
var statearr_23786_23803 = state_23781__$1;
(statearr_23786_23803[(1)] = (7));

} else {
var statearr_23787_23804 = state_23781__$1;
(statearr_23787_23804[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23782 === (6))){
var inst_23777 = (state_23781[(2)]);
var state_23781__$1 = state_23781;
var statearr_23788_23805 = state_23781__$1;
(statearr_23788_23805[(2)] = inst_23777);

(statearr_23788_23805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23782 === (3))){
var inst_23779 = (state_23781[(2)]);
var state_23781__$1 = state_23781;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23781__$1,inst_23779);
} else {
if((state_val_23782 === (2))){
var inst_23750 = (state_23781[(8)]);
var inst_23757 = (state_23781[(12)]);
var inst_23756 = cljs.core.seq(inst_23750);
var inst_23757__$1 = cljs.core.first(inst_23756);
var inst_23758 = cljs.core.next(inst_23756);
var state_23781__$1 = (function (){var statearr_23789 = state_23781;
(statearr_23789[(13)] = inst_23758);

(statearr_23789[(12)] = inst_23757__$1);

return statearr_23789;
})();
if(cljs.core.truth_(inst_23757__$1)){
var statearr_23790_23806 = state_23781__$1;
(statearr_23790_23806[(1)] = (4));

} else {
var statearr_23791_23807 = state_23781__$1;
(statearr_23791_23807[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23782 === (11))){
var inst_23769 = (state_23781[(2)]);
var inst_23770 = fluree.db.util.async.throw_err(inst_23769);
var state_23781__$1 = state_23781;
var statearr_23792_23808 = state_23781__$1;
(statearr_23792_23808[(2)] = inst_23770);

(statearr_23792_23808[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23782 === (9))){
var inst_23758 = (state_23781[(13)]);
var inst_23751 = (state_23781[(10)]);
var inst_23772 = (state_23781[(2)]);
var inst_23773 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23751,inst_23772);
var inst_23750 = inst_23758;
var inst_23751__$1 = inst_23773;
var state_23781__$1 = (function (){var statearr_23793 = state_23781;
(statearr_23793[(8)] = inst_23750);

(statearr_23793[(10)] = inst_23751__$1);

return statearr_23793;
})();
var statearr_23794_23809 = state_23781__$1;
(statearr_23794_23809[(2)] = null);

(statearr_23794_23809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23782 === (5))){
var inst_23751 = (state_23781[(10)]);
var state_23781__$1 = state_23781;
var statearr_23795_23810 = state_23781__$1;
(statearr_23795_23810[(2)] = inst_23751);

(statearr_23795_23810[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23782 === (10))){
var inst_23764 = (state_23781[(2)]);
var inst_23765 = fluree.db.util.async.throw_err(inst_23764);
var state_23781__$1 = state_23781;
var statearr_23796_23811 = state_23781__$1;
(statearr_23796_23811[(2)] = inst_23765);

(statearr_23796_23811[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23782 === (8))){
var inst_23760 = (state_23781[(7)]);
var inst_23767 = fluree.db.query.subject_crawl.subject.subj_crawl(inst_23760);
var state_23781__$1 = state_23781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23781__$1,(11),inst_23767);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0 = (function (){
var statearr_23797 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23797[(0)] = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__);

(statearr_23797[(1)] = (1));

return statearr_23797;
});
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1 = (function (state_23781){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23781);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23798){var ex__2730__auto__ = e23798;
var statearr_23799_23812 = state_23781;
(statearr_23799_23812[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23781[(4)]))){
var statearr_23800_23813 = state_23781;
(statearr_23800_23813[(1)] = cljs.core.first((state_23781[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23814 = state_23781;
state_23781 = G__23814;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__ = function(state_23781){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1.call(this,state_23781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23801 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23801[(6)] = c__2749__auto__);

return statearr_23801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * After results are processed, the response may be modified if:
 *   - order-by exists, in which case we need to perform a sort
 *   - selectOne? exists, in which case we take the (first result)
 *   - pretty-print is true, in which case each result needs to get embedded in a map
 */
fluree.db.query.subject_crawl.core.build_finishing_fn = (function fluree$db$query$subject_crawl$core$build_finishing_fn(p__23816){
var map__23817 = p__23816;
var map__23817__$1 = cljs.core.__destructure_map(map__23817);
var parsed_query = map__23817__$1;
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23817__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var order_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23817__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var pretty_print = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23817__$1,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var fns = (function (){var G__23818 = cljs.core.PersistentVector.EMPTY;
var G__23818__$1 = (cljs.core.truth_(selectOne_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__23818,(function (result){
return cljs.core.first(result);
})):G__23818);
var G__23818__$2 = (cljs.core.truth_(pretty_print)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__23818__$1,(function (){var select_var = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query))))),(1));
return (function (result){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__23815_SHARP_){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([select_var,p1__23815_SHARP_]);
}),result);
});
})()):G__23818__$1);
if(cljs.core.truth_(order_by)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__23818__$2,(function (result){
return fluree.db.query.subject_crawl.common.order_results(result,order_by);
}));
} else {
return G__23818__$2;
}
})();
if(cljs.core.empty_QMARK_(fns)){
return cljs.core.identity;
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,fns);
}
});
/**
 * Executes a simple subject crawl analytical query execution strategy.
 * 
 *   Strategy involves:
 *   (a) Get a list of subjects from first where clause
 *   (b) select all flakes for each subject
 *   (c) filter subjects based on subsequent where clause(s)
 *   (d) apply offset/limit for (c)
 *   (e) send result into :select graph crawl
 */
fluree.db.query.subject_crawl.core.simple_subject_crawl = (function fluree$db$query$subject_crawl$core$simple_subject_crawl(db,p__23819){
var map__23820 = p__23819;
var map__23820__$1 = cljs.core.__destructure_map(map__23820);
var parsed_query = map__23820__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23820__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23820__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23820__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23820__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23820__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var rel_binding_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23820__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var error_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var f_where = cljs.core.first(where);
var rdf_type_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("rdf","type","rdf/type",1175423232),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where));
var filter_map = new cljs.core.Keyword(null,"s-filter","s-filter",-1111214020).cljs$core$IFn$_invoke$arity$1(cljs.core.second(where));
var cache = cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY);
var fuel_vol = cljs.core.volatile_BANG_((0));
var select_spec = fluree.db.query.subject_crawl.core.retrieve_select_spec(db,parsed_query);
var finish_fn = fluree.db.query.subject_crawl.core.build_finishing_fn(parsed_query);
var opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"f-where","f-where",-958007776),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"select-spec","select-spec",55073283),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736),new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803),new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441),new cljs.core.Keyword(null,"cache","cache",-1237023054),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"filter-map","filter-map",-314788257)],[f_where,(3),select_spec,limit,offset,db,error_ch,cljs.core.not(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"root?","root?",-2045639518)], null))),rdf_type_QMARK_,cache,fuel,fuel_vol,parsed_query,finish_fn,vars,filter_map]);
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.subject_crawl.core.relationship_binding(opts);
} else {
if(rdf_type_QMARK_){
return fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl(opts);
} else {
return fluree.db.query.subject_crawl.subject.subj_crawl(opts);
}
}
});
