// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');

/**
 * @interface
 */
fluree.db.storage.core.Store = function(){};

var fluree$db$storage$core$Store$exists_QMARK_$dyn_16479 = (function (s,k){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.exists_QMARK_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__4551__auto__.call(null,s,k));
} else {
var m__4549__auto__ = (fluree.db.storage.core.exists_QMARK_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__4549__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.exists?",s);
}
}
});
/**
 * Returns true when `k` exists in `s`
 */
fluree.db.storage.core.exists_QMARK_ = (function fluree$db$storage$core$exists_QMARK_(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$exists_QMARK_$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$exists_QMARK_$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$exists_QMARK_$dyn_16479(s,k);
}
});

var fluree$db$storage$core$Store$list$dyn_16480 = (function (s,d){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.list[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(s,d) : m__4551__auto__.call(null,s,d));
} else {
var m__4549__auto__ = (fluree.db.storage.core.list["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(s,d) : m__4549__auto__.call(null,s,d));
} else {
throw cljs.core.missing_protocol("Store.list",s);
}
}
});
/**
 * Returns a collection containing the keys stored under the subdirectory/prefix `d` of `s`
 */
fluree.db.storage.core.list = (function fluree$db$storage$core$list(s,d){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$list$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$list$arity$2(s,d);
} else {
return fluree$db$storage$core$Store$list$dyn_16480(s,d);
}
});

var fluree$db$storage$core$Store$read$dyn_16481 = (function (s,k){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.read[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__4551__auto__.call(null,s,k));
} else {
var m__4549__auto__ = (fluree.db.storage.core.read["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__4549__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.read",s);
}
}
});
/**
 * Reads raw bytes from `s` associated with `k`
 */
fluree.db.storage.core.read = (function fluree$db$storage$core$read(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$read$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$read$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$read$dyn_16481(s,k);
}
});

var fluree$db$storage$core$Store$write$dyn_16482 = (function (s,k,data){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.write[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(s,k,data) : m__4551__auto__.call(null,s,k,data));
} else {
var m__4549__auto__ = (fluree.db.storage.core.write["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(s,k,data) : m__4549__auto__.call(null,s,k,data));
} else {
throw cljs.core.missing_protocol("Store.write",s);
}
}
});
/**
 * Writes `data` as raw bytes to `s` and associates it with `k`
 */
fluree.db.storage.core.write = (function fluree$db$storage$core$write(s,k,data){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$write$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$write$arity$3(s,k,data);
} else {
return fluree$db$storage$core$Store$write$dyn_16482(s,k,data);
}
});

var fluree$db$storage$core$Store$rename$dyn_16483 = (function (s,old_key,new_key){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.rename[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(s,old_key,new_key) : m__4551__auto__.call(null,s,old_key,new_key));
} else {
var m__4549__auto__ = (fluree.db.storage.core.rename["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(s,old_key,new_key) : m__4549__auto__.call(null,s,old_key,new_key));
} else {
throw cljs.core.missing_protocol("Store.rename",s);
}
}
});
/**
 * Remove `old-key` and associate its data to `new-key`
 */
fluree.db.storage.core.rename = (function fluree$db$storage$core$rename(s,old_key,new_key){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$rename$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$rename$arity$3(s,old_key,new_key);
} else {
return fluree$db$storage$core$Store$rename$dyn_16483(s,old_key,new_key);
}
});

var fluree$db$storage$core$Store$delete$dyn_16484 = (function (s,k){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.delete$[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__4551__auto__.call(null,s,k));
} else {
var m__4549__auto__ = (fluree.db.storage.core.delete$["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__4549__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.delete",s);
}
}
});
/**
 * Delete data associated with key `k`
 */
fluree.db.storage.core.delete$ = (function fluree$db$storage$core$delete(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$delete$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$delete$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$delete$dyn_16484(s,k);
}
});

/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_prefix = (function fluree$db$storage$core$ledger_garbage_prefix(network,ldgr_id){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("_",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ldgr_id,"garbage"], null));
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ldgr_id,block){
var pre = fluree.db.storage.core.ledger_garbage_prefix(network,ldgr_id);
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("_",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pre,block], null));
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16506){
var state_val_16507 = (state_16506[(1)]);
if((state_val_16507 === (7))){
var inst_16495 = (state_16506[(7)]);
var inst_16497 = fluree.db.storage.core.serde(conn);
var inst_16498 = fluree.db.serde.protocol._deserialize_block(inst_16497,inst_16495);
var state_16506__$1 = state_16506;
var statearr_16508_16527 = state_16506__$1;
(statearr_16508_16527[(2)] = inst_16498);

(statearr_16508_16527[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16507 === (1))){
var state_16506__$1 = state_16506;
var statearr_16509_16528 = state_16506__$1;
(statearr_16509_16528[(2)] = null);

(statearr_16509_16528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16507 === (4))){
var inst_16485 = (state_16506[(2)]);
var state_16506__$1 = state_16506;
var statearr_16510_16529 = state_16506__$1;
(statearr_16510_16529[(2)] = inst_16485);

(statearr_16510_16529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16507 === (6))){
var inst_16495 = (state_16506[(7)]);
var inst_16494 = (state_16506[(2)]);
var inst_16495__$1 = fluree.db.util.async.throw_err(inst_16494);
var state_16506__$1 = (function (){var statearr_16511 = state_16506;
(statearr_16511[(7)] = inst_16495__$1);

return statearr_16511;
})();
if(cljs.core.truth_(inst_16495__$1)){
var statearr_16512_16530 = state_16506__$1;
(statearr_16512_16530[(1)] = (7));

} else {
var statearr_16513_16531 = state_16506__$1;
(statearr_16513_16531[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16507 === (3))){
var inst_16504 = (state_16506[(2)]);
var state_16506__$1 = state_16506;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16506__$1,inst_16504);
} else {
if((state_val_16507 === (2))){
var _ = (function (){var statearr_16515 = state_16506;
(statearr_16515[(4)] = cljs.core.cons((5),(state_16506[(4)])));

return statearr_16515;
})();
var inst_16491 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_16492 = fluree.db.storage.core.read(conn,inst_16491);
var state_16506__$1 = state_16506;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16506__$1,(6),inst_16492);
} else {
if((state_val_16507 === (9))){
var inst_16501 = (state_16506[(2)]);
var _ = (function (){var statearr_16516 = state_16506;
(statearr_16516[(4)] = cljs.core.rest((state_16506[(4)])));

return statearr_16516;
})();
var state_16506__$1 = state_16506;
var statearr_16517_16532 = state_16506__$1;
(statearr_16517_16532[(2)] = inst_16501);

(statearr_16517_16532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16507 === (5))){
var _ = (function (){var statearr_16518 = state_16506;
(statearr_16518[(4)] = cljs.core.rest((state_16506[(4)])));

return statearr_16518;
})();
var state_16506__$1 = state_16506;
var ex16514 = (state_16506__$1[(2)]);
var statearr_16519_16533 = state_16506__$1;
(statearr_16519_16533[(5)] = ex16514);


if((ex16514 instanceof Error)){
var statearr_16520_16534 = state_16506__$1;
(statearr_16520_16534[(1)] = (4));

(statearr_16520_16534[(5)] = null);

} else {
throw ex16514;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16507 === (8))){
var state_16506__$1 = state_16506;
var statearr_16521_16535 = state_16506__$1;
(statearr_16521_16535[(2)] = null);

(statearr_16521_16535[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2727__auto____0 = (function (){
var statearr_16522 = [null,null,null,null,null,null,null,null];
(statearr_16522[(0)] = fluree$db$storage$core$read_block_$_state_machine__2727__auto__);

(statearr_16522[(1)] = (1));

return statearr_16522;
});
var fluree$db$storage$core$read_block_$_state_machine__2727__auto____1 = (function (state_16506){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16506);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16523){var ex__2730__auto__ = e16523;
var statearr_16524_16536 = state_16506;
(statearr_16524_16536[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16506[(4)]))){
var statearr_16525_16537 = state_16506;
(statearr_16525_16537[(1)] = cljs.core.first((state_16506[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16538 = state_16506;
state_16506 = G__16538;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2727__auto__ = function(state_16506){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2727__auto____1.call(this,state_16506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16526 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16526[(6)] = c__2749__auto__);

return statearr_16526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16561){
var state_val_16562 = (state_16561[(1)]);
if((state_val_16562 === (7))){
var inst_16550 = (state_16561[(7)]);
var inst_16552 = fluree.db.storage.core.serde(conn);
var inst_16553 = fluree.db.serde.protocol._deserialize_block(inst_16552,inst_16550);
var state_16561__$1 = state_16561;
var statearr_16563_16582 = state_16561__$1;
(statearr_16563_16582[(2)] = inst_16553);

(statearr_16563_16582[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16562 === (1))){
var state_16561__$1 = state_16561;
var statearr_16564_16583 = state_16561__$1;
(statearr_16564_16583[(2)] = null);

(statearr_16564_16583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16562 === (4))){
var inst_16539 = (state_16561[(2)]);
var state_16561__$1 = state_16561;
var statearr_16565_16584 = state_16561__$1;
(statearr_16565_16584[(2)] = inst_16539);

(statearr_16565_16584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16562 === (6))){
var inst_16550 = (state_16561[(7)]);
var inst_16549 = (state_16561[(2)]);
var inst_16550__$1 = fluree.db.util.async.throw_err(inst_16549);
var state_16561__$1 = (function (){var statearr_16566 = state_16561;
(statearr_16566[(7)] = inst_16550__$1);

return statearr_16566;
})();
if(cljs.core.truth_(inst_16550__$1)){
var statearr_16567_16585 = state_16561__$1;
(statearr_16567_16585[(1)] = (7));

} else {
var statearr_16568_16586 = state_16561__$1;
(statearr_16568_16586[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16562 === (3))){
var inst_16559 = (state_16561[(2)]);
var state_16561__$1 = state_16561;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16561__$1,inst_16559);
} else {
if((state_val_16562 === (2))){
var _ = (function (){var statearr_16570 = state_16561;
(statearr_16570[(4)] = cljs.core.cons((5),(state_16561[(4)])));

return statearr_16570;
})();
var inst_16545 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_16546 = [inst_16545,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_16547 = fluree.db.storage.core.read(conn,inst_16546);
var state_16561__$1 = state_16561;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16561__$1,(6),inst_16547);
} else {
if((state_val_16562 === (9))){
var inst_16556 = (state_16561[(2)]);
var _ = (function (){var statearr_16571 = state_16561;
(statearr_16571[(4)] = cljs.core.rest((state_16561[(4)])));

return statearr_16571;
})();
var state_16561__$1 = state_16561;
var statearr_16572_16587 = state_16561__$1;
(statearr_16572_16587[(2)] = inst_16556);

(statearr_16572_16587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16562 === (5))){
var _ = (function (){var statearr_16573 = state_16561;
(statearr_16573[(4)] = cljs.core.rest((state_16561[(4)])));

return statearr_16573;
})();
var state_16561__$1 = state_16561;
var ex16569 = (state_16561__$1[(2)]);
var statearr_16574_16588 = state_16561__$1;
(statearr_16574_16588[(5)] = ex16569);


if((ex16569 instanceof Error)){
var statearr_16575_16589 = state_16561__$1;
(statearr_16575_16589[(1)] = (4));

(statearr_16575_16589[(5)] = null);

} else {
throw ex16569;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16562 === (8))){
var state_16561__$1 = state_16561;
var statearr_16576_16590 = state_16561__$1;
(statearr_16576_16590[(2)] = null);

(statearr_16576_16590[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0 = (function (){
var statearr_16577 = [null,null,null,null,null,null,null,null];
(statearr_16577[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__);

(statearr_16577[(1)] = (1));

return statearr_16577;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1 = (function (state_16561){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16561);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16578){var ex__2730__auto__ = e16578;
var statearr_16579_16591 = state_16561;
(statearr_16579_16591[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16561[(4)]))){
var statearr_16580_16592 = state_16561;
(statearr_16580_16592[(1)] = cljs.core.first((state_16561[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16593 = state_16561;
state_16561 = G__16593;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__ = function(state_16561){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1.call(this,state_16561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16581 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16581[(6)] = c__2749__auto__);

return statearr_16581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,ledger_id,block_data,version){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16617){
var state_val_16618 = (state_16617[(1)]);
if((state_val_16618 === (1))){
var state_16617__$1 = state_16617;
var statearr_16619_16633 = state_16617__$1;
(statearr_16619_16633[(2)] = null);

(statearr_16619_16633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16618 === (2))){
var _ = (function (){var statearr_16620 = state_16617;
(statearr_16620[(4)] = cljs.core.cons((5),(state_16617[(4)])));

return statearr_16620;
})();
var inst_16600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16601 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_16602 = (new cljs.core.PersistentVector(null,3,(5),inst_16600,inst_16601,null));
var inst_16603 = cljs.core.select_keys(block_data,inst_16602);
var inst_16604 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_16603);
var inst_16605 = fluree.db.storage.core.ledger_block_key(network,ledger_id,inst_16604);
var inst_16606 = [inst_16605,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_16607 = fluree.db.storage.core.serde(conn);
var inst_16608 = fluree.db.serde.protocol._serialize_block(inst_16607,inst_16603);
var inst_16609 = fluree.db.storage.core.write(conn,inst_16606,inst_16608);
var state_16617__$1 = state_16617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16617__$1,(6),inst_16609);
} else {
if((state_val_16618 === (3))){
var inst_16615 = (state_16617[(2)]);
var state_16617__$1 = state_16617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16617__$1,inst_16615);
} else {
if((state_val_16618 === (4))){
var inst_16594 = (state_16617[(2)]);
var state_16617__$1 = state_16617;
var statearr_16622_16634 = state_16617__$1;
(statearr_16622_16634[(2)] = inst_16594);

(statearr_16622_16634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16618 === (5))){
var _ = (function (){var statearr_16623 = state_16617;
(statearr_16623[(4)] = cljs.core.rest((state_16617[(4)])));

return statearr_16623;
})();
var state_16617__$1 = state_16617;
var ex16621 = (state_16617__$1[(2)]);
var statearr_16624_16635 = state_16617__$1;
(statearr_16624_16635[(5)] = ex16621);


if((ex16621 instanceof Error)){
var statearr_16625_16636 = state_16617__$1;
(statearr_16625_16636[(1)] = (4));

(statearr_16625_16636[(5)] = null);

} else {
throw ex16621;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16618 === (6))){
var inst_16611 = (state_16617[(2)]);
var inst_16612 = fluree.db.util.async.throw_err(inst_16611);
var _ = (function (){var statearr_16626 = state_16617;
(statearr_16626[(4)] = cljs.core.rest((state_16617[(4)])));

return statearr_16626;
})();
var state_16617__$1 = state_16617;
var statearr_16627_16637 = state_16617__$1;
(statearr_16627_16637[(2)] = inst_16612);

(statearr_16627_16637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0 = (function (){
var statearr_16628 = [null,null,null,null,null,null,null];
(statearr_16628[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__);

(statearr_16628[(1)] = (1));

return statearr_16628;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1 = (function (state_16617){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16617);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16629){var ex__2730__auto__ = e16629;
var statearr_16630_16638 = state_16617;
(statearr_16630_16638[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16617[(4)]))){
var statearr_16631_16639 = state_16617;
(statearr_16631_16639[(1)] = cljs.core.first((state_16617[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16640 = state_16617;
state_16617 = G__16640;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__ = function(state_16617){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1.call(this,state_16617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16632 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16632[(6)] = c__2749__auto__);

return statearr_16632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,ledger_id,block_data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16663){
var state_val_16664 = (state_16663[(1)]);
if((state_val_16664 === (1))){
var state_16663__$1 = state_16663;
var statearr_16665_16679 = state_16663__$1;
(statearr_16665_16679[(2)] = null);

(statearr_16665_16679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16664 === (2))){
var _ = (function (){var statearr_16666 = state_16663;
(statearr_16666[(4)] = cljs.core.cons((5),(state_16663[(4)])));

return statearr_16666;
})();
var inst_16647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16648 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_16649 = (new cljs.core.PersistentVector(null,3,(5),inst_16647,inst_16648,null));
var inst_16650 = cljs.core.select_keys(block_data,inst_16649);
var inst_16651 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_16650);
var inst_16652 = fluree.db.storage.core.ledger_block_key(network,ledger_id,inst_16651);
var inst_16653 = fluree.db.storage.core.serde(conn);
var inst_16654 = fluree.db.serde.protocol._serialize_block(inst_16653,inst_16650);
var inst_16655 = fluree.db.storage.core.write(conn,inst_16652,inst_16654);
var state_16663__$1 = state_16663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16663__$1,(6),inst_16655);
} else {
if((state_val_16664 === (3))){
var inst_16661 = (state_16663[(2)]);
var state_16663__$1 = state_16663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16663__$1,inst_16661);
} else {
if((state_val_16664 === (4))){
var inst_16641 = (state_16663[(2)]);
var state_16663__$1 = state_16663;
var statearr_16668_16680 = state_16663__$1;
(statearr_16668_16680[(2)] = inst_16641);

(statearr_16668_16680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16664 === (5))){
var _ = (function (){var statearr_16669 = state_16663;
(statearr_16669[(4)] = cljs.core.rest((state_16663[(4)])));

return statearr_16669;
})();
var state_16663__$1 = state_16663;
var ex16667 = (state_16663__$1[(2)]);
var statearr_16670_16681 = state_16663__$1;
(statearr_16670_16681[(5)] = ex16667);


if((ex16667 instanceof Error)){
var statearr_16671_16682 = state_16663__$1;
(statearr_16671_16682[(1)] = (4));

(statearr_16671_16682[(5)] = null);

} else {
throw ex16667;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16664 === (6))){
var inst_16657 = (state_16663[(2)]);
var inst_16658 = fluree.db.util.async.throw_err(inst_16657);
var _ = (function (){var statearr_16672 = state_16663;
(statearr_16672[(4)] = cljs.core.rest((state_16663[(4)])));

return statearr_16672;
})();
var state_16663__$1 = state_16663;
var statearr_16673_16683 = state_16663__$1;
(statearr_16673_16683[(2)] = inst_16658);

(statearr_16673_16683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2727__auto____0 = (function (){
var statearr_16674 = [null,null,null,null,null,null,null];
(statearr_16674[(0)] = fluree$db$storage$core$write_block_$_state_machine__2727__auto__);

(statearr_16674[(1)] = (1));

return statearr_16674;
});
var fluree$db$storage$core$write_block_$_state_machine__2727__auto____1 = (function (state_16663){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16663);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16675){var ex__2730__auto__ = e16675;
var statearr_16676_16684 = state_16663;
(statearr_16676_16684[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16663[(4)]))){
var statearr_16677_16685 = state_16663;
(statearr_16677_16685[(1)] = cljs.core.first((state_16663[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16686 = state_16663;
state_16663 = G__16686;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2727__auto__ = function(state_16663){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2727__auto____1.call(this,state_16663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16678 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16678[(6)] = c__2749__auto__);

return statearr_16678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into
 *   storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.random_leaf_id = (function fluree$db$storage$core$random_leaf_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key(network,ledger_id,idx,cljs.core.random_uuid(),"l");
});
/**
 * Writes `leaf` to storage under the provided `leaf-id`, computing a new id if
 *   one isn't provided. Returns the leaf map with the id used attached uner the
 *   `:id` key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(var_args){
var G__16688 = arguments.length;
switch (G__16688) {
case 5:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,leaf){
var leaf_id = fluree.db.storage.core.random_leaf_id(network,ledger_id,idx_type);
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6(conn,network,ledger_id,idx_type,leaf_id,leaf);
}));

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,leaf_id,p__16689){
var map__16690 = p__16689;
var map__16690__$1 = cljs.core.__destructure_map(map__16690);
var leaf = map__16690__$1;
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16690__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16711){
var state_val_16712 = (state_16711[(1)]);
if((state_val_16712 === (1))){
var state_16711__$1 = state_16711;
var statearr_16713_16729 = state_16711__$1;
(statearr_16713_16729[(2)] = null);

(statearr_16713_16729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16712 === (2))){
var _ = (function (){var statearr_16714 = state_16711;
(statearr_16714[(4)] = cljs.core.cons((5),(state_16711[(4)])));

return statearr_16714;
})();
var inst_16697 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_16698 = [flakes];
var inst_16699 = cljs.core.PersistentHashMap.fromArrays(inst_16697,inst_16698);
var inst_16700 = fluree.db.storage.core.serde(conn);
var inst_16701 = fluree.db.serde.protocol._serialize_leaf(inst_16700,inst_16699);
var inst_16702 = fluree.db.storage.core.write(conn,leaf_id,inst_16701);
var state_16711__$1 = state_16711;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16711__$1,(6),inst_16702);
} else {
if((state_val_16712 === (3))){
var inst_16709 = (state_16711[(2)]);
var state_16711__$1 = state_16711;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16711__$1,inst_16709);
} else {
if((state_val_16712 === (4))){
var inst_16691 = (state_16711[(2)]);
var state_16711__$1 = state_16711;
var statearr_16716_16730 = state_16711__$1;
(statearr_16716_16730[(2)] = inst_16691);

(statearr_16716_16730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16712 === (5))){
var _ = (function (){var statearr_16717 = state_16711;
(statearr_16717[(4)] = cljs.core.rest((state_16711[(4)])));

return statearr_16717;
})();
var state_16711__$1 = state_16711;
var ex16715 = (state_16711__$1[(2)]);
var statearr_16718_16731 = state_16711__$1;
(statearr_16718_16731[(5)] = ex16715);


if((ex16715 instanceof Error)){
var statearr_16719_16732 = state_16711__$1;
(statearr_16719_16732[(1)] = (4));

(statearr_16719_16732[(5)] = null);

} else {
throw ex16715;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16712 === (6))){
var inst_16704 = (state_16711[(2)]);
var inst_16705 = fluree.db.util.async.throw_err(inst_16704);
var inst_16706 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(leaf,new cljs.core.Keyword(null,"id","id",-1388402092),leaf_id);
var _ = (function (){var statearr_16720 = state_16711;
(statearr_16720[(4)] = cljs.core.rest((state_16711[(4)])));

return statearr_16720;
})();
var state_16711__$1 = (function (){var statearr_16721 = state_16711;
(statearr_16721[(7)] = inst_16705);

return statearr_16721;
})();
var statearr_16722_16733 = state_16711__$1;
(statearr_16722_16733[(2)] = inst_16706);

(statearr_16722_16733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_16723 = [null,null,null,null,null,null,null,null];
(statearr_16723[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_16723[(1)] = (1));

return statearr_16723;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_16711){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16711);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16724){var ex__2730__auto__ = e16724;
var statearr_16725_16734 = state_16711;
(statearr_16725_16734[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16711[(4)]))){
var statearr_16726_16735 = state_16711;
(statearr_16726_16735[(1)] = cljs.core.first((state_16711[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16736 = state_16711;
state_16711 = G__16736;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_16711){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_16711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16727 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16727[(6)] = c__2749__auto__);

return statearr_16727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_leaf.cljs$lang$maxFixedArity = 6);

/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16753){
var state_val_16754 = (state_16753[(1)]);
if((state_val_16754 === (1))){
var state_16753__$1 = state_16753;
var statearr_16755_16770 = state_16753__$1;
(statearr_16755_16770[(2)] = null);

(statearr_16755_16770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16754 === (2))){
var _ = (function (){var statearr_16756 = state_16753;
(statearr_16756[(4)] = cljs.core.cons((5),(state_16753[(4)])));

return statearr_16756;
})();
var inst_16743 = fluree.db.storage.core.serde(conn);
var inst_16744 = fluree.db.serde.protocol._serialize_branch(inst_16743,data);
var inst_16745 = fluree.db.storage.core.write(conn,key,inst_16744);
var state_16753__$1 = state_16753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16753__$1,(6),inst_16745);
} else {
if((state_val_16754 === (3))){
var inst_16751 = (state_16753[(2)]);
var state_16753__$1 = state_16753;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16753__$1,inst_16751);
} else {
if((state_val_16754 === (4))){
var inst_16737 = (state_16753[(2)]);
var state_16753__$1 = state_16753;
var statearr_16758_16771 = state_16753__$1;
(statearr_16758_16771[(2)] = inst_16737);

(statearr_16758_16771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16754 === (5))){
var _ = (function (){var statearr_16759 = state_16753;
(statearr_16759[(4)] = cljs.core.rest((state_16753[(4)])));

return statearr_16759;
})();
var state_16753__$1 = state_16753;
var ex16757 = (state_16753__$1[(2)]);
var statearr_16760_16772 = state_16753__$1;
(statearr_16760_16772[(5)] = ex16757);


if((ex16757 instanceof Error)){
var statearr_16761_16773 = state_16753__$1;
(statearr_16761_16773[(1)] = (4));

(statearr_16761_16773[(5)] = null);

} else {
throw ex16757;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16754 === (6))){
var inst_16747 = (state_16753[(2)]);
var inst_16748 = fluree.db.util.async.throw_err(inst_16747);
var _ = (function (){var statearr_16762 = state_16753;
(statearr_16762[(4)] = cljs.core.rest((state_16753[(4)])));

return statearr_16762;
})();
var state_16753__$1 = (function (){var statearr_16763 = state_16753;
(statearr_16763[(7)] = inst_16748);

return statearr_16763;
})();
var statearr_16764_16774 = state_16753__$1;
(statearr_16764_16774[(2)] = key);

(statearr_16764_16774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0 = (function (){
var statearr_16765 = [null,null,null,null,null,null,null,null];
(statearr_16765[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__);

(statearr_16765[(1)] = (1));

return statearr_16765;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1 = (function (state_16753){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16753);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16766){var ex__2730__auto__ = e16766;
var statearr_16767_16775 = state_16753;
(statearr_16767_16775[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16753[(4)]))){
var statearr_16768_16776 = state_16753;
(statearr_16768_16776[(1)] = cljs.core.first((state_16753[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16777 = state_16753;
state_16753 = G__16777;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__ = function(state_16753){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1.call(this,state_16753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16769 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16769[(6)] = c__2749__auto__);

return statearr_16769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.random_branch_id = (function fluree$db$storage$core$random_branch_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key(network,ledger_id,idx,cljs.core.random_uuid(),"b");
});
/**
 * Writes `branch` to storage under the provided `branch-id`, computing a new id
 *   if one isn't provided. Returns the branch map with the id used attached uner
 *   the `:id` key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(var_args){
var G__16779 = arguments.length;
switch (G__16779) {
case 5:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,branch){
var branch_id = fluree.db.storage.core.random_branch_id(network,ledger_id,idx_type);
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6(conn,network,ledger_id,idx_type,branch_id,branch);
}));

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,branch_id,p__16780){
var map__16781 = p__16780;
var map__16781__$1 = cljs.core.__destructure_map(map__16781);
var branch = map__16781__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16781__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16807){
var state_val_16808 = (state_16807[(1)]);
if((state_val_16808 === (1))){
var state_16807__$1 = state_16807;
var statearr_16809_16826 = state_16807__$1;
(statearr_16809_16826[(2)] = null);

(statearr_16809_16826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16808 === (2))){
var _ = (function (){var statearr_16810 = state_16807;
(statearr_16810[(4)] = cljs.core.cons((5),(state_16807[(4)])));

return statearr_16810;
})();
var inst_16788 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.val,children);
var inst_16789 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.storage.core.child_data,inst_16788);
var inst_16790 = cljs.core.first(inst_16789);
var inst_16791 = new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(inst_16790);
var inst_16792 = cljs.core.rseq(inst_16789);
var inst_16793 = cljs.core.first(inst_16792);
var inst_16794 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_16793);
var inst_16795 = [new cljs.core.Keyword(null,"children","children",-940561982)];
var inst_16796 = [inst_16789];
var inst_16797 = cljs.core.PersistentHashMap.fromArrays(inst_16795,inst_16796);
var inst_16798 = fluree.db.storage.core.write_branch_data(conn,branch_id,inst_16797);
var state_16807__$1 = (function (){var statearr_16811 = state_16807;
(statearr_16811[(7)] = inst_16794);

(statearr_16811[(8)] = inst_16791);

return statearr_16811;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16807__$1,(6),inst_16798);
} else {
if((state_val_16808 === (3))){
var inst_16805 = (state_16807[(2)]);
var state_16807__$1 = state_16807;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16807__$1,inst_16805);
} else {
if((state_val_16808 === (4))){
var inst_16782 = (state_16807[(2)]);
var state_16807__$1 = state_16807;
var statearr_16813_16827 = state_16807__$1;
(statearr_16813_16827[(2)] = inst_16782);

(statearr_16813_16827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16808 === (5))){
var _ = (function (){var statearr_16814 = state_16807;
(statearr_16814[(4)] = cljs.core.rest((state_16807[(4)])));

return statearr_16814;
})();
var state_16807__$1 = state_16807;
var ex16812 = (state_16807__$1[(2)]);
var statearr_16815_16828 = state_16807__$1;
(statearr_16815_16828[(5)] = ex16812);


if((ex16812 instanceof Error)){
var statearr_16816_16829 = state_16807__$1;
(statearr_16816_16829[(1)] = (4));

(statearr_16816_16829[(5)] = null);

} else {
throw ex16812;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16808 === (6))){
var inst_16800 = (state_16807[(2)]);
var inst_16801 = fluree.db.util.async.throw_err(inst_16800);
var inst_16802 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(branch,new cljs.core.Keyword(null,"id","id",-1388402092),branch_id);
var _ = (function (){var statearr_16817 = state_16807;
(statearr_16817[(4)] = cljs.core.rest((state_16807[(4)])));

return statearr_16817;
})();
var state_16807__$1 = (function (){var statearr_16818 = state_16807;
(statearr_16818[(9)] = inst_16801);

return statearr_16818;
})();
var statearr_16819_16830 = state_16807__$1;
(statearr_16819_16830[(2)] = inst_16802);

(statearr_16819_16830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_16820 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16820[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_16820[(1)] = (1));

return statearr_16820;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_16807){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16807);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16821){var ex__2730__auto__ = e16821;
var statearr_16822_16831 = state_16807;
(statearr_16822_16831[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16807[(4)]))){
var statearr_16823_16832 = state_16807;
(statearr_16823_16832[(1)] = cljs.core.first((state_16807[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16833 = state_16807;
state_16807 = G__16833;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_16807){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_16807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16824 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16824[(6)] = c__2749__auto__);

return statearr_16824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_branch.cljs$lang$maxFixedArity = 6);

/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,garbage){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16861){
var state_val_16862 = (state_16861[(1)]);
if((state_val_16862 === (1))){
var state_16861__$1 = state_16861;
var statearr_16863_16879 = state_16861__$1;
(statearr_16863_16879[(2)] = null);

(statearr_16863_16879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16862 === (2))){
var inst_16847 = (state_16861[(7)]);
var _ = (function (){var statearr_16864 = state_16861;
(statearr_16864[(4)] = cljs.core.cons((5),(state_16861[(4)])));

return statearr_16864;
})();
var inst_16841 = db;
var inst_16842 = cljs.core.__destructure_map(inst_16841);
var inst_16843 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16842,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_16844 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16842,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_16845 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16842,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_16846 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16842,new cljs.core.Keyword(null,"block","block",664686210));
var inst_16847__$1 = fluree.db.storage.core.ledger_garbage_key(inst_16844,inst_16845,inst_16846);
var inst_16848 = [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_16849 = [inst_16845,inst_16846,garbage];
var inst_16850 = cljs.core.PersistentHashMap.fromArrays(inst_16848,inst_16849);
var inst_16851 = fluree.db.storage.core.serde(inst_16843);
var inst_16852 = fluree.db.serde.protocol._serialize_garbage(inst_16851,inst_16850);
var inst_16853 = fluree.db.storage.core.write(inst_16843,inst_16847__$1,inst_16852);
var state_16861__$1 = (function (){var statearr_16865 = state_16861;
(statearr_16865[(7)] = inst_16847__$1);

return statearr_16865;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16861__$1,(6),inst_16853);
} else {
if((state_val_16862 === (3))){
var inst_16859 = (state_16861[(2)]);
var state_16861__$1 = state_16861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16861__$1,inst_16859);
} else {
if((state_val_16862 === (4))){
var inst_16834 = (state_16861[(2)]);
var state_16861__$1 = state_16861;
var statearr_16867_16880 = state_16861__$1;
(statearr_16867_16880[(2)] = inst_16834);

(statearr_16867_16880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16862 === (5))){
var _ = (function (){var statearr_16868 = state_16861;
(statearr_16868[(4)] = cljs.core.rest((state_16861[(4)])));

return statearr_16868;
})();
var state_16861__$1 = state_16861;
var ex16866 = (state_16861__$1[(2)]);
var statearr_16869_16881 = state_16861__$1;
(statearr_16869_16881[(5)] = ex16866);


if((ex16866 instanceof Error)){
var statearr_16870_16882 = state_16861__$1;
(statearr_16870_16882[(1)] = (4));

(statearr_16870_16882[(5)] = null);

} else {
throw ex16866;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16862 === (6))){
var inst_16847 = (state_16861[(7)]);
var inst_16855 = (state_16861[(2)]);
var inst_16856 = fluree.db.util.async.throw_err(inst_16855);
var _ = (function (){var statearr_16871 = state_16861;
(statearr_16871[(4)] = cljs.core.rest((state_16861[(4)])));

return statearr_16871;
})();
var state_16861__$1 = (function (){var statearr_16872 = state_16861;
(statearr_16872[(8)] = inst_16856);

return statearr_16872;
})();
var statearr_16873_16883 = state_16861__$1;
(statearr_16873_16883[(2)] = inst_16847);

(statearr_16873_16883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0 = (function (){
var statearr_16874 = [null,null,null,null,null,null,null,null,null];
(statearr_16874[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__);

(statearr_16874[(1)] = (1));

return statearr_16874;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1 = (function (state_16861){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16861);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16875){var ex__2730__auto__ = e16875;
var statearr_16876_16884 = state_16861;
(statearr_16876_16884[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16861[(4)]))){
var statearr_16877_16885 = state_16861;
(statearr_16877_16885[(1)] = cljs.core.first((state_16861[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16886 = state_16861;
state_16861 = G__16886;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__ = function(state_16861){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1.call(this,state_16861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16878 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16878[(6)] = c__2749__auto__);

return statearr_16878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__16888 = arguments.length;
switch (G__16888) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16946){
var state_val_16947 = (state_16946[(1)]);
if((state_val_16947 === (7))){
var state_16946__$1 = state_16946;
var statearr_16948_16974 = state_16946__$1;
(statearr_16948_16974[(2)] = (0));

(statearr_16948_16974[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16947 === (1))){
var state_16946__$1 = state_16946;
var statearr_16949_16975 = state_16946__$1;
(statearr_16949_16975[(2)] = null);

(statearr_16949_16975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16947 === (4))){
var inst_16889 = (state_16946[(2)]);
var state_16946__$1 = state_16946;
var statearr_16950_16976 = state_16946__$1;
(statearr_16950_16976[(2)] = inst_16889);

(statearr_16950_16976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16947 === (6))){
var inst_16915 = (state_16946[(7)]);
var state_16946__$1 = state_16946;
var statearr_16951_16977 = state_16946__$1;
(statearr_16951_16977[(2)] = inst_16915);

(statearr_16951_16977[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16947 === (3))){
var inst_16944 = (state_16946[(2)]);
var state_16946__$1 = state_16946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16946__$1,inst_16944);
} else {
if((state_val_16947 === (12))){
var inst_16912 = (state_16946[(8)]);
var inst_16940 = (state_16946[(2)]);
var inst_16941 = fluree.db.util.async.throw_err(inst_16940);
var _ = (function (){var statearr_16952 = state_16946;
(statearr_16952[(4)] = cljs.core.rest((state_16946[(4)])));

return statearr_16952;
})();
var state_16946__$1 = (function (){var statearr_16953 = state_16946;
(statearr_16953[(9)] = inst_16941);

return statearr_16953;
})();
var statearr_16954_16978 = state_16946__$1;
(statearr_16954_16978[(2)] = inst_16912);

(statearr_16954_16978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16947 === (2))){
var inst_16907 = (state_16946[(10)]);
var inst_16904 = (state_16946[(11)]);
var inst_16915 = (state_16946[(7)]);
var inst_16902 = (state_16946[(12)]);
var _ = (function (){var statearr_16955 = state_16946;
(statearr_16955[(4)] = cljs.core.cons((5),(state_16946[(4)])));

return statearr_16955;
})();
var inst_16896 = db;
var inst_16897 = cljs.core.__destructure_map(inst_16896);
var inst_16898 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16897,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_16899 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16897,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_16900 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16897,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_16901 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16897,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_16902__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16897,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_16903 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16897,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_16904__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16897,new cljs.core.Keyword(null,"block","block",664686210));
var inst_16905 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16897,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_16906 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16897,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var inst_16907__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16897,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_16908 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16897,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_16909 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16897,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_16910 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16897,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_16911 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16897,new cljs.core.Keyword(null,"post","post",269697687));
var inst_16912 = fluree.db.storage.core.ledger_root_key(inst_16898,inst_16907__$1,inst_16904__$1);
var inst_16913 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_16914 = fluree.db.storage.core.child_data(inst_16905);
var inst_16915__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_16902__$1);
var state_16946__$1 = (function (){var statearr_16956 = state_16946;
(statearr_16956[(13)] = inst_16900);

(statearr_16956[(14)] = inst_16901);

(statearr_16956[(10)] = inst_16907__$1);

(statearr_16956[(15)] = inst_16913);

(statearr_16956[(16)] = inst_16906);

(statearr_16956[(8)] = inst_16912);

(statearr_16956[(17)] = inst_16911);

(statearr_16956[(18)] = inst_16909);

(statearr_16956[(11)] = inst_16904__$1);

(statearr_16956[(7)] = inst_16915__$1);

(statearr_16956[(12)] = inst_16902__$1);

(statearr_16956[(19)] = inst_16910);

(statearr_16956[(20)] = inst_16903);

(statearr_16956[(21)] = inst_16908);

(statearr_16956[(22)] = inst_16899);

(statearr_16956[(23)] = inst_16914);

return statearr_16956;
})();
if(cljs.core.truth_(inst_16915__$1)){
var statearr_16957_16979 = state_16946__$1;
(statearr_16957_16979[(1)] = (6));

} else {
var statearr_16958_16980 = state_16946__$1;
(statearr_16958_16980[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16947 === (11))){
var inst_16900 = (state_16946[(13)]);
var inst_16901 = (state_16946[(14)]);
var inst_16907 = (state_16946[(10)]);
var inst_16913 = (state_16946[(15)]);
var inst_16912 = (state_16946[(8)]);
var inst_16911 = (state_16946[(17)]);
var inst_16909 = (state_16946[(18)]);
var inst_16919 = (state_16946[(24)]);
var inst_16904 = (state_16946[(11)]);
var inst_16902 = (state_16946[(12)]);
var inst_16920 = (state_16946[(25)]);
var inst_16910 = (state_16946[(19)]);
var inst_16903 = (state_16946[(20)]);
var inst_16899 = (state_16946[(22)]);
var inst_16914 = (state_16946[(23)]);
var inst_16925 = (state_16946[(2)]);
var inst_16926 = fluree.db.storage.core.child_data(inst_16909);
var inst_16927 = fluree.db.storage.core.child_data(inst_16911);
var inst_16928 = fluree.db.util.core.current_time_millis();
var inst_16929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16930 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_16931 = (new cljs.core.PersistentVector(null,2,(5),inst_16929,inst_16930,null));
var inst_16932 = cljs.core.select_keys(inst_16902,inst_16931);
var inst_16933 = fluree.db.storage.core.child_data(inst_16901);
var inst_16934 = [inst_16904,inst_16914,inst_16919,inst_16907,inst_16920,inst_16925,inst_16926,inst_16927,inst_16899,inst_16928,inst_16900,inst_16910,inst_16932,inst_16933];
var inst_16935 = cljs.core.PersistentHashMap.fromArrays(inst_16913,inst_16934);
var inst_16936 = fluree.db.storage.core.serde(inst_16903);
var inst_16937 = fluree.db.serde.protocol._serialize_db_root(inst_16936,inst_16935);
var inst_16938 = fluree.db.storage.core.write(inst_16903,inst_16912,inst_16937);
var state_16946__$1 = state_16946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16946__$1,(12),inst_16938);
} else {
if((state_val_16947 === (9))){
var inst_16921 = (state_16946[(26)]);
var state_16946__$1 = state_16946;
var statearr_16960_16981 = state_16946__$1;
(statearr_16960_16981[(2)] = inst_16921);

(statearr_16960_16981[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16947 === (5))){
var _ = (function (){var statearr_16961 = state_16946;
(statearr_16961[(4)] = cljs.core.rest((state_16946[(4)])));

return statearr_16961;
})();
var state_16946__$1 = state_16946;
var ex16959 = (state_16946__$1[(2)]);
var statearr_16962_16982 = state_16946__$1;
(statearr_16962_16982[(5)] = ex16959);


if((ex16959 instanceof Error)){
var statearr_16963_16983 = state_16946__$1;
(statearr_16963_16983[(1)] = (4));

(statearr_16963_16983[(5)] = null);

} else {
throw ex16959;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16947 === (10))){
var inst_16908 = (state_16946[(21)]);
var state_16946__$1 = state_16946;
var statearr_16964_16984 = state_16946__$1;
(statearr_16964_16984[(2)] = inst_16908);

(statearr_16964_16984[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16947 === (8))){
var inst_16906 = (state_16946[(16)]);
var inst_16921 = (state_16946[(26)]);
var inst_16919 = (state_16946[(2)]);
var inst_16920 = fluree.db.storage.core.child_data(inst_16906);
var inst_16921__$1 = custom_ecount;
var state_16946__$1 = (function (){var statearr_16965 = state_16946;
(statearr_16965[(24)] = inst_16919);

(statearr_16965[(26)] = inst_16921__$1);

(statearr_16965[(25)] = inst_16920);

return statearr_16965;
})();
if(cljs.core.truth_(inst_16921__$1)){
var statearr_16966_16985 = state_16946__$1;
(statearr_16966_16985[(1)] = (9));

} else {
var statearr_16967_16986 = state_16946__$1;
(statearr_16967_16986[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_16968 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16968[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_16968[(1)] = (1));

return statearr_16968;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_16946){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16946);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16969){var ex__2730__auto__ = e16969;
var statearr_16970_16987 = state_16946;
(statearr_16970_16987[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16946[(4)]))){
var statearr_16971_16988 = state_16946;
(statearr_16971_16988[(1)] = cljs.core.first((state_16946[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16989 = state_16946;
state_16946 = G__16989;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_16946){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_16946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16972 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16972[(6)] = c__2749__auto__);

return statearr_16972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(p__16990,key){
var map__16991 = p__16990;
var map__16991__$1 = cljs.core.__destructure_map(map__16991);
var conn = map__16991__$1;
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16991__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17011){
var state_val_17012 = (state_17011[(1)]);
if((state_val_17012 === (7))){
var inst_17001 = (state_17011[(7)]);
var inst_17003 = fluree.db.serde.protocol._deserialize_branch(serializer,inst_17001);
var state_17011__$1 = state_17011;
var statearr_17013_17032 = state_17011__$1;
(statearr_17013_17032[(2)] = inst_17003);

(statearr_17013_17032[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17012 === (1))){
var state_17011__$1 = state_17011;
var statearr_17014_17033 = state_17011__$1;
(statearr_17014_17033[(2)] = null);

(statearr_17014_17033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17012 === (4))){
var inst_16992 = (state_17011[(2)]);
var state_17011__$1 = state_17011;
var statearr_17015_17034 = state_17011__$1;
(statearr_17015_17034[(2)] = inst_16992);

(statearr_17015_17034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17012 === (6))){
var inst_17001 = (state_17011[(7)]);
var inst_17000 = (state_17011[(2)]);
var inst_17001__$1 = fluree.db.util.async.throw_err(inst_17000);
var state_17011__$1 = (function (){var statearr_17016 = state_17011;
(statearr_17016[(7)] = inst_17001__$1);

return statearr_17016;
})();
if(cljs.core.truth_(inst_17001__$1)){
var statearr_17017_17035 = state_17011__$1;
(statearr_17017_17035[(1)] = (7));

} else {
var statearr_17018_17036 = state_17011__$1;
(statearr_17018_17036[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17012 === (3))){
var inst_17009 = (state_17011[(2)]);
var state_17011__$1 = state_17011;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17011__$1,inst_17009);
} else {
if((state_val_17012 === (2))){
var _ = (function (){var statearr_17020 = state_17011;
(statearr_17020[(4)] = cljs.core.cons((5),(state_17011[(4)])));

return statearr_17020;
})();
var inst_16998 = fluree.db.storage.core.read(conn,key);
var state_17011__$1 = state_17011;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17011__$1,(6),inst_16998);
} else {
if((state_val_17012 === (9))){
var inst_17006 = (state_17011[(2)]);
var _ = (function (){var statearr_17021 = state_17011;
(statearr_17021[(4)] = cljs.core.rest((state_17011[(4)])));

return statearr_17021;
})();
var state_17011__$1 = state_17011;
var statearr_17022_17037 = state_17011__$1;
(statearr_17022_17037[(2)] = inst_17006);

(statearr_17022_17037[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17012 === (5))){
var _ = (function (){var statearr_17023 = state_17011;
(statearr_17023[(4)] = cljs.core.rest((state_17011[(4)])));

return statearr_17023;
})();
var state_17011__$1 = state_17011;
var ex17019 = (state_17011__$1[(2)]);
var statearr_17024_17038 = state_17011__$1;
(statearr_17024_17038[(5)] = ex17019);


if((ex17019 instanceof Error)){
var statearr_17025_17039 = state_17011__$1;
(statearr_17025_17039[(1)] = (4));

(statearr_17025_17039[(5)] = null);

} else {
throw ex17019;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17012 === (8))){
var state_17011__$1 = state_17011;
var statearr_17026_17040 = state_17011__$1;
(statearr_17026_17040[(2)] = null);

(statearr_17026_17040[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0 = (function (){
var statearr_17027 = [null,null,null,null,null,null,null,null];
(statearr_17027[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2727__auto__);

(statearr_17027[(1)] = (1));

return statearr_17027;
});
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1 = (function (state_17011){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17011);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17028){var ex__2730__auto__ = e17028;
var statearr_17029_17041 = state_17011;
(statearr_17029_17041[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17011[(4)]))){
var statearr_17030_17042 = state_17011;
(statearr_17030_17042[(1)] = cljs.core.first((state_17011[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17043 = state_17011;
state_17011 = G__17043;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__ = function(state_17011){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1.call(this,state_17011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17031 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17031[(6)] = c__2749__auto__);

return statearr_17031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(p__17044,key){
var map__17045 = p__17044;
var map__17045__$1 = cljs.core.__destructure_map(map__17045);
var conn = map__17045__$1;
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17045__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17065){
var state_val_17066 = (state_17065[(1)]);
if((state_val_17066 === (7))){
var inst_17055 = (state_17065[(7)]);
var inst_17057 = fluree.db.serde.protocol._deserialize_leaf(serializer,inst_17055);
var state_17065__$1 = state_17065;
var statearr_17067_17086 = state_17065__$1;
(statearr_17067_17086[(2)] = inst_17057);

(statearr_17067_17086[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17066 === (1))){
var state_17065__$1 = state_17065;
var statearr_17068_17087 = state_17065__$1;
(statearr_17068_17087[(2)] = null);

(statearr_17068_17087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17066 === (4))){
var inst_17046 = (state_17065[(2)]);
var state_17065__$1 = state_17065;
var statearr_17069_17088 = state_17065__$1;
(statearr_17069_17088[(2)] = inst_17046);

(statearr_17069_17088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17066 === (6))){
var inst_17055 = (state_17065[(7)]);
var inst_17054 = (state_17065[(2)]);
var inst_17055__$1 = fluree.db.util.async.throw_err(inst_17054);
var state_17065__$1 = (function (){var statearr_17070 = state_17065;
(statearr_17070[(7)] = inst_17055__$1);

return statearr_17070;
})();
if(cljs.core.truth_(inst_17055__$1)){
var statearr_17071_17089 = state_17065__$1;
(statearr_17071_17089[(1)] = (7));

} else {
var statearr_17072_17090 = state_17065__$1;
(statearr_17072_17090[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17066 === (3))){
var inst_17063 = (state_17065[(2)]);
var state_17065__$1 = state_17065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17065__$1,inst_17063);
} else {
if((state_val_17066 === (2))){
var _ = (function (){var statearr_17074 = state_17065;
(statearr_17074[(4)] = cljs.core.cons((5),(state_17065[(4)])));

return statearr_17074;
})();
var inst_17052 = fluree.db.storage.core.read(conn,key);
var state_17065__$1 = state_17065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17065__$1,(6),inst_17052);
} else {
if((state_val_17066 === (9))){
var inst_17060 = (state_17065[(2)]);
var _ = (function (){var statearr_17075 = state_17065;
(statearr_17075[(4)] = cljs.core.rest((state_17065[(4)])));

return statearr_17075;
})();
var state_17065__$1 = state_17065;
var statearr_17076_17091 = state_17065__$1;
(statearr_17076_17091[(2)] = inst_17060);

(statearr_17076_17091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17066 === (5))){
var _ = (function (){var statearr_17077 = state_17065;
(statearr_17077[(4)] = cljs.core.rest((state_17065[(4)])));

return statearr_17077;
})();
var state_17065__$1 = state_17065;
var ex17073 = (state_17065__$1[(2)]);
var statearr_17078_17092 = state_17065__$1;
(statearr_17078_17092[(5)] = ex17073);


if((ex17073 instanceof Error)){
var statearr_17079_17093 = state_17065__$1;
(statearr_17079_17093[(1)] = (4));

(statearr_17079_17093[(5)] = null);

} else {
throw ex17073;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17066 === (8))){
var state_17065__$1 = state_17065;
var statearr_17080_17094 = state_17065__$1;
(statearr_17080_17094[(2)] = null);

(statearr_17080_17094[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_17081 = [null,null,null,null,null,null,null,null];
(statearr_17081[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__);

(statearr_17081[(1)] = (1));

return statearr_17081;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1 = (function (state_17065){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17065);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17082){var ex__2730__auto__ = e17082;
var statearr_17083_17095 = state_17065;
(statearr_17083_17095[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17065[(4)]))){
var statearr_17084_17096 = state_17065;
(statearr_17084_17096[(1)] = cljs.core.first((state_17065[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17097 = state_17065;
state_17065 = G__17097;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__ = function(state_17065){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1.call(this,state_17065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17085 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17085[(6)] = c__2749__auto__);

return statearr_17085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(_conn,p__17098,index,index_data){
var map__17099 = p__17098;
var map__17099__$1 = cljs.core.__destructure_map(map__17099);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17099__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17099__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var comparators = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17099__$1,new cljs.core.Keyword(null,"comparators","comparators",-1325611955));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17099__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17099__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var cmp = (function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(comparators,index);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db index root: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
var G__17100 = index_data;
var G__17100__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__17100,new cljs.core.Keyword(null,"rhs","rhs",-229356739),fluree.db.flake.parts__GT_Flake):G__17100);
var G__17100__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__17100__$1,new cljs.core.Keyword(null,"first","first",-644103046),fluree.db.flake.parts__GT_Flake):G__17100__$1);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__17100__$2,new cljs.core.Keyword(null,"comparator","comparator",2144896662),cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0));

});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__17101 = root_data;
var map__17101__$1 = cljs.core.__destructure_map(map__17101);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17101__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17101__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17101__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17101__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
var idx_root = fluree.db.storage.core.reify_index_root(conn,db,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,idx_root);
}),db_STAR_,fluree.db.index.types);
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17123){
var state_val_17124 = (state_17123[(1)]);
if((state_val_17124 === (7))){
var state_17123__$1 = state_17123;
var statearr_17125_17145 = state_17123__$1;
(statearr_17125_17145[(2)] = null);

(statearr_17125_17145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17124 === (1))){
var state_17123__$1 = state_17123;
var statearr_17126_17146 = state_17123__$1;
(statearr_17126_17146[(2)] = null);

(statearr_17126_17146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17124 === (4))){
var inst_17102 = (state_17123[(2)]);
var state_17123__$1 = state_17123;
var statearr_17127_17147 = state_17123__$1;
(statearr_17127_17147[(2)] = inst_17102);

(statearr_17127_17147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17124 === (6))){
var inst_17109 = (state_17123[(7)]);
var inst_17111 = fluree.db.storage.core.serde(conn);
var state_17123__$1 = (function (){var statearr_17128 = state_17123;
(statearr_17128[(8)] = inst_17111);

return statearr_17128;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17123__$1,(9),inst_17109);
} else {
if((state_val_17124 === (3))){
var inst_17121 = (state_17123[(2)]);
var state_17123__$1 = state_17123;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17123__$1,inst_17121);
} else {
if((state_val_17124 === (2))){
var inst_17109 = (state_17123[(7)]);
var _ = (function (){var statearr_17130 = state_17123;
(statearr_17130[(4)] = cljs.core.cons((5),(state_17123[(4)])));

return statearr_17130;
})();
var inst_17108 = fluree.db.storage.core.ledger_garbage_key(network,ledger_id,block);
var inst_17109__$1 = fluree.db.storage.core.read(conn,inst_17108);
var state_17123__$1 = (function (){var statearr_17131 = state_17123;
(statearr_17131[(7)] = inst_17109__$1);

return statearr_17131;
})();
if(cljs.core.truth_(inst_17109__$1)){
var statearr_17132_17148 = state_17123__$1;
(statearr_17132_17148[(1)] = (6));

} else {
var statearr_17133_17149 = state_17123__$1;
(statearr_17133_17149[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17124 === (9))){
var inst_17111 = (state_17123[(8)]);
var inst_17113 = (state_17123[(2)]);
var inst_17114 = fluree.db.util.async.throw_err(inst_17113);
var inst_17115 = fluree.db.serde.protocol._deserialize_garbage(inst_17111,inst_17114);
var state_17123__$1 = state_17123;
var statearr_17134_17150 = state_17123__$1;
(statearr_17134_17150[(2)] = inst_17115);

(statearr_17134_17150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17124 === (5))){
var _ = (function (){var statearr_17135 = state_17123;
(statearr_17135[(4)] = cljs.core.rest((state_17123[(4)])));

return statearr_17135;
})();
var state_17123__$1 = state_17123;
var ex17129 = (state_17123__$1[(2)]);
var statearr_17136_17151 = state_17123__$1;
(statearr_17136_17151[(5)] = ex17129);


if((ex17129 instanceof Error)){
var statearr_17137_17152 = state_17123__$1;
(statearr_17137_17152[(1)] = (4));

(statearr_17137_17152[(5)] = null);

} else {
throw ex17129;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17124 === (8))){
var inst_17118 = (state_17123[(2)]);
var _ = (function (){var statearr_17138 = state_17123;
(statearr_17138[(4)] = cljs.core.rest((state_17123[(4)])));

return statearr_17138;
})();
var state_17123__$1 = state_17123;
var statearr_17139_17153 = state_17123__$1;
(statearr_17139_17153[(2)] = inst_17118);

(statearr_17139_17153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0 = (function (){
var statearr_17140 = [null,null,null,null,null,null,null,null,null];
(statearr_17140[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__);

(statearr_17140[(1)] = (1));

return statearr_17140;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1 = (function (state_17123){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17123);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17141){var ex__2730__auto__ = e17141;
var statearr_17142_17154 = state_17123;
(statearr_17142_17154[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17123[(4)]))){
var statearr_17143_17155 = state_17123;
(statearr_17143_17155[(1)] = cljs.core.first((state_17123[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17156 = state_17123;
state_17123 = G__17156;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__ = function(state_17123){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1.call(this,state_17123);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17144 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17144[(6)] = c__2749__auto__);

return statearr_17144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17178){
var state_val_17179 = (state_17178[(1)]);
if((state_val_17179 === (7))){
var inst_17167 = (state_17178[(7)]);
var inst_17169 = fluree.db.storage.core.serde(conn);
var inst_17170 = fluree.db.serde.protocol._deserialize_db_root(inst_17169,inst_17167);
var state_17178__$1 = state_17178;
var statearr_17180_17199 = state_17178__$1;
(statearr_17180_17199[(2)] = inst_17170);

(statearr_17180_17199[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17179 === (1))){
var state_17178__$1 = state_17178;
var statearr_17181_17200 = state_17178__$1;
(statearr_17181_17200[(2)] = null);

(statearr_17181_17200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17179 === (4))){
var inst_17157 = (state_17178[(2)]);
var state_17178__$1 = state_17178;
var statearr_17182_17201 = state_17178__$1;
(statearr_17182_17201[(2)] = inst_17157);

(statearr_17182_17201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17179 === (6))){
var inst_17167 = (state_17178[(7)]);
var inst_17166 = (state_17178[(2)]);
var inst_17167__$1 = fluree.db.util.async.throw_err(inst_17166);
var state_17178__$1 = (function (){var statearr_17183 = state_17178;
(statearr_17183[(7)] = inst_17167__$1);

return statearr_17183;
})();
if(cljs.core.truth_(inst_17167__$1)){
var statearr_17184_17202 = state_17178__$1;
(statearr_17184_17202[(1)] = (7));

} else {
var statearr_17185_17203 = state_17178__$1;
(statearr_17185_17203[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17179 === (3))){
var inst_17176 = (state_17178[(2)]);
var state_17178__$1 = state_17178;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17178__$1,inst_17176);
} else {
if((state_val_17179 === (2))){
var _ = (function (){var statearr_17187 = state_17178;
(statearr_17187[(4)] = cljs.core.cons((5),(state_17178[(4)])));

return statearr_17187;
})();
var inst_17163 = fluree.db.storage.core.ledger_root_key(network,ledger_id,block);
var inst_17164 = fluree.db.storage.core.read(conn,inst_17163);
var state_17178__$1 = state_17178;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17178__$1,(6),inst_17164);
} else {
if((state_val_17179 === (9))){
var inst_17173 = (state_17178[(2)]);
var _ = (function (){var statearr_17188 = state_17178;
(statearr_17188[(4)] = cljs.core.rest((state_17178[(4)])));

return statearr_17188;
})();
var state_17178__$1 = state_17178;
var statearr_17189_17204 = state_17178__$1;
(statearr_17189_17204[(2)] = inst_17173);

(statearr_17189_17204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17179 === (5))){
var _ = (function (){var statearr_17190 = state_17178;
(statearr_17190[(4)] = cljs.core.rest((state_17178[(4)])));

return statearr_17190;
})();
var state_17178__$1 = state_17178;
var ex17186 = (state_17178__$1[(2)]);
var statearr_17191_17205 = state_17178__$1;
(statearr_17191_17205[(5)] = ex17186);


if((ex17186 instanceof Error)){
var statearr_17192_17206 = state_17178__$1;
(statearr_17192_17206[(1)] = (4));

(statearr_17192_17206[(5)] = null);

} else {
throw ex17186;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17179 === (8))){
var state_17178__$1 = state_17178;
var statearr_17193_17207 = state_17178__$1;
(statearr_17193_17207[(2)] = null);

(statearr_17193_17207[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0 = (function (){
var statearr_17194 = [null,null,null,null,null,null,null,null];
(statearr_17194[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__);

(statearr_17194[(1)] = (1));

return statearr_17194;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1 = (function (state_17178){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17178);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17195){var ex__2730__auto__ = e17195;
var statearr_17196_17208 = state_17178;
(statearr_17196_17208[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17178[(4)]))){
var statearr_17197_17209 = state_17178;
(statearr_17197_17209[(1)] = cljs.core.first((state_17178[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17210 = state_17178;
state_17178 = G__17210;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__ = function(state_17178){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1.call(this,state_17178);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17198 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17198[(6)] = c__2749__auto__);

return statearr_17198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index,
 *   throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,ledger_id,blank_db,index){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17247){
var state_val_17248 = (state_17247[(1)]);
if((state_val_17248 === (7))){
var inst_17217 = (state_17247[(7)]);
var state_17247__$1 = state_17247;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17247__$1,(9),inst_17217);
} else {
if((state_val_17248 === (1))){
var state_17247__$1 = state_17247;
var statearr_17249_17270 = state_17247__$1;
(statearr_17249_17270[(2)] = null);

(statearr_17249_17270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17248 === (4))){
var inst_17211 = (state_17247[(2)]);
var state_17247__$1 = state_17247;
var statearr_17250_17271 = state_17247__$1;
(statearr_17250_17271[(2)] = inst_17211);

(statearr_17250_17271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17248 === (6))){
var inst_17220 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_17221 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17222 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_17223 = cljs.core.PersistentHashMap.fromArrays(inst_17221,inst_17222);
var inst_17224 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17220,inst_17223);
var inst_17225 = (function(){throw inst_17224})();
var state_17247__$1 = state_17247;
var statearr_17251_17272 = state_17247__$1;
(statearr_17251_17272[(2)] = inst_17225);

(statearr_17251_17272[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17248 === (3))){
var inst_17245 = (state_17247[(2)]);
var state_17247__$1 = state_17247;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17247__$1,inst_17245);
} else {
if((state_val_17248 === (2))){
var inst_17217 = (state_17247[(7)]);
var _ = (function (){var statearr_17252 = state_17247;
(statearr_17252[(4)] = cljs.core.cons((5),(state_17247[(4)])));

return statearr_17252;
})();
var inst_17217__$1 = fluree.db.storage.core.read_db_root(conn,network,ledger_id,index);
var inst_17218 = cljs.core.not(inst_17217__$1);
var state_17247__$1 = (function (){var statearr_17253 = state_17247;
(statearr_17253[(7)] = inst_17217__$1);

return statearr_17253;
})();
if(inst_17218){
var statearr_17254_17273 = state_17247__$1;
(statearr_17254_17273[(1)] = (6));

} else {
var statearr_17255_17274 = state_17247__$1;
(statearr_17255_17274[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17248 === (11))){
var inst_17235 = (state_17247[(8)]);
var inst_17238 = (state_17247[(2)]);
var inst_17239 = fluree.db.util.async.throw_err(inst_17238);
var inst_17240 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17235,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_17239);
var state_17247__$1 = state_17247;
var statearr_17257_17275 = state_17247__$1;
(statearr_17257_17275[(2)] = inst_17240);

(statearr_17257_17275[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17248 === (9))){
var inst_17230 = (state_17247[(9)]);
var inst_17228 = (state_17247[(2)]);
var inst_17229 = fluree.db.util.async.throw_err(inst_17228);
var inst_17230__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_17229);
var inst_17231 = fluree.db.query.schema.schema_map(inst_17230__$1);
var state_17247__$1 = (function (){var statearr_17258 = state_17247;
(statearr_17258[(9)] = inst_17230__$1);

return statearr_17258;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17247__$1,(10),inst_17231);
} else {
if((state_val_17248 === (5))){
var _ = (function (){var statearr_17259 = state_17247;
(statearr_17259[(4)] = cljs.core.rest((state_17247[(4)])));

return statearr_17259;
})();
var state_17247__$1 = state_17247;
var ex17256 = (state_17247__$1[(2)]);
var statearr_17260_17276 = state_17247__$1;
(statearr_17260_17276[(5)] = ex17256);


if((ex17256 instanceof Error)){
var statearr_17261_17277 = state_17247__$1;
(statearr_17261_17277[(1)] = (4));

(statearr_17261_17277[(5)] = null);

} else {
throw ex17256;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17248 === (10))){
var inst_17235 = (state_17247[(8)]);
var inst_17230 = (state_17247[(9)]);
var inst_17233 = (state_17247[(2)]);
var inst_17234 = fluree.db.util.async.throw_err(inst_17233);
var inst_17235__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17230,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_17234);
var inst_17236 = fluree.db.query.schema.setting_map(inst_17235__$1);
var state_17247__$1 = (function (){var statearr_17262 = state_17247;
(statearr_17262[(8)] = inst_17235__$1);

return statearr_17262;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17247__$1,(11),inst_17236);
} else {
if((state_val_17248 === (8))){
var inst_17242 = (state_17247[(2)]);
var _ = (function (){var statearr_17263 = state_17247;
(statearr_17263[(4)] = cljs.core.rest((state_17247[(4)])));

return statearr_17263;
})();
var state_17247__$1 = state_17247;
var statearr_17264_17278 = state_17247__$1;
(statearr_17264_17278[(2)] = inst_17242);

(statearr_17264_17278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0 = (function (){
var statearr_17265 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17265[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2727__auto__);

(statearr_17265[(1)] = (1));

return statearr_17265;
});
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1 = (function (state_17247){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17247);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17266){var ex__2730__auto__ = e17266;
var statearr_17267_17279 = state_17247;
(statearr_17267_17279[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17247[(4)]))){
var statearr_17268_17280 = state_17247;
(statearr_17268_17280[(1)] = cljs.core.first((state_17247[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17281 = state_17247;
state_17247 = G__17281;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__ = function(state_17247){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1.call(this,state_17247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17269 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17269[(6)] = c__2749__auto__);

return statearr_17269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.fetch_child_attributes = (function fluree$db$storage$core$fetch_child_attributes(conn,p__17282){
var map__17283 = p__17282;
var map__17283__$1 = cljs.core.__destructure_map(map__17283);
var branch = map__17283__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17283__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17283__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17283__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17320){
var state_val_17321 = (state_17320[(1)]);
if((state_val_17321 === (7))){
var inst_17293 = (state_17320[(7)]);
var inst_17296 = cljs.core.__destructure_map(inst_17293);
var inst_17297 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17296,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_17298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17299 = [new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"tempid","tempid",1427663222)];
var inst_17300 = (new cljs.core.PersistentVector(null,7,(5),inst_17298,inst_17299,null));
var inst_17301 = cljs.core.select_keys(branch,inst_17300);
var inst_17302 = (function (){var temp__5802__auto__ = inst_17293;
var map__17295 = inst_17296;
var children = inst_17297;
var branch_metadata = inst_17301;
return (function (i,child){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(branch_metadata,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),(function (){var and__4251__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return (i === (0));
} else {
return and__4251__auto__;
}
})()),child], 0));
});
})();
var inst_17303 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_17302,inst_17297);
var inst_17304 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),cljs.core.identity);
var inst_17305 = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(inst_17304,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_17303], 0));
var inst_17306 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_map_by,comparator,inst_17305);
var state_17320__$1 = state_17320;
var statearr_17322_17341 = state_17320__$1;
(statearr_17322_17341[(2)] = inst_17306);

(statearr_17322_17341[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17321 === (1))){
var state_17320__$1 = state_17320;
var statearr_17323_17342 = state_17320__$1;
(statearr_17323_17342[(2)] = null);

(statearr_17323_17342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17321 === (4))){
var inst_17284 = (state_17320[(2)]);
var state_17320__$1 = state_17320;
var statearr_17324_17343 = state_17320__$1;
(statearr_17324_17343[(2)] = inst_17284);

(statearr_17324_17343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17321 === (6))){
var inst_17293 = (state_17320[(7)]);
var inst_17292 = (state_17320[(2)]);
var inst_17293__$1 = fluree.db.util.async.throw_err(inst_17292);
var state_17320__$1 = (function (){var statearr_17325 = state_17320;
(statearr_17325[(7)] = inst_17293__$1);

return statearr_17325;
})();
if(cljs.core.truth_(inst_17293__$1)){
var statearr_17326_17344 = state_17320__$1;
(statearr_17326_17344[(1)] = (7));

} else {
var statearr_17327_17345 = state_17320__$1;
(statearr_17327_17345[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17321 === (3))){
var inst_17318 = (state_17320[(2)]);
var state_17320__$1 = state_17320;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17320__$1,inst_17318);
} else {
if((state_val_17321 === (2))){
var _ = (function (){var statearr_17329 = state_17320;
(statearr_17329[(4)] = cljs.core.cons((5),(state_17320[(4)])));

return statearr_17329;
})();
var inst_17290 = fluree.db.storage.core.read_branch(conn,id);
var state_17320__$1 = state_17320;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17320__$1,(6),inst_17290);
} else {
if((state_val_17321 === (9))){
var inst_17315 = (state_17320[(2)]);
var _ = (function (){var statearr_17330 = state_17320;
(statearr_17330[(4)] = cljs.core.rest((state_17320[(4)])));

return statearr_17330;
})();
var state_17320__$1 = state_17320;
var statearr_17331_17346 = state_17320__$1;
(statearr_17331_17346[(2)] = inst_17315);

(statearr_17331_17346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17321 === (5))){
var _ = (function (){var statearr_17332 = state_17320;
(statearr_17332[(4)] = cljs.core.rest((state_17320[(4)])));

return statearr_17332;
})();
var state_17320__$1 = state_17320;
var ex17328 = (state_17320__$1[(2)]);
var statearr_17333_17347 = state_17320__$1;
(statearr_17333_17347[(5)] = ex17328);


if((ex17328 instanceof Error)){
var statearr_17334_17348 = state_17320__$1;
(statearr_17334_17348[(1)] = (4));

(statearr_17334_17348[(5)] = null);

} else {
throw ex17328;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17321 === (8))){
var inst_17308 = ["Unable to retrieve index branch with id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage."].join('');
var inst_17309 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17310 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_17311 = cljs.core.PersistentHashMap.fromArrays(inst_17309,inst_17310);
var inst_17312 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17308,inst_17311);
var inst_17313 = (function(){throw inst_17312})();
var state_17320__$1 = state_17320;
var statearr_17335_17349 = state_17320__$1;
(statearr_17335_17349[(2)] = inst_17313);

(statearr_17335_17349[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0 = (function (){
var statearr_17336 = [null,null,null,null,null,null,null,null];
(statearr_17336[(0)] = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__);

(statearr_17336[(1)] = (1));

return statearr_17336;
});
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1 = (function (state_17320){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17320);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17337){var ex__2730__auto__ = e17337;
var statearr_17338_17350 = state_17320;
(statearr_17338_17350[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17320[(4)]))){
var statearr_17339_17351 = state_17320;
(statearr_17339_17351[(1)] = cljs.core.first((state_17320[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17352 = state_17320;
state_17320 = G__17352;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__ = function(state_17320){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1.call(this,state_17320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0;
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1;
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17340 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17340[(6)] = c__2749__auto__);

return statearr_17340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.fetch_leaf_flakes = (function fluree$db$storage$core$fetch_leaf_flakes(conn,p__17353){
var map__17354 = p__17353;
var map__17354__$1 = cljs.core.__destructure_map(map__17354);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17354__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17354__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17383){
var state_val_17384 = (state_17383[(1)]);
if((state_val_17384 === (7))){
var inst_17364 = (state_17383[(7)]);
var inst_17367 = cljs.core.__destructure_map(inst_17364);
var inst_17368 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17367,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_17369 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,comparator,inst_17368);
var state_17383__$1 = state_17383;
var statearr_17385_17404 = state_17383__$1;
(statearr_17385_17404[(2)] = inst_17369);

(statearr_17385_17404[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17384 === (1))){
var state_17383__$1 = state_17383;
var statearr_17386_17405 = state_17383__$1;
(statearr_17386_17405[(2)] = null);

(statearr_17386_17405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17384 === (4))){
var inst_17355 = (state_17383[(2)]);
var state_17383__$1 = state_17383;
var statearr_17387_17406 = state_17383__$1;
(statearr_17387_17406[(2)] = inst_17355);

(statearr_17387_17406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17384 === (6))){
var inst_17364 = (state_17383[(7)]);
var inst_17363 = (state_17383[(2)]);
var inst_17364__$1 = fluree.db.util.async.throw_err(inst_17363);
var state_17383__$1 = (function (){var statearr_17388 = state_17383;
(statearr_17388[(7)] = inst_17364__$1);

return statearr_17388;
})();
if(cljs.core.truth_(inst_17364__$1)){
var statearr_17389_17407 = state_17383__$1;
(statearr_17389_17407[(1)] = (7));

} else {
var statearr_17390_17408 = state_17383__$1;
(statearr_17390_17408[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17384 === (3))){
var inst_17381 = (state_17383[(2)]);
var state_17383__$1 = state_17383;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17383__$1,inst_17381);
} else {
if((state_val_17384 === (2))){
var _ = (function (){var statearr_17392 = state_17383;
(statearr_17392[(4)] = cljs.core.cons((5),(state_17383[(4)])));

return statearr_17392;
})();
var inst_17361 = fluree.db.storage.core.read_leaf(conn,id);
var state_17383__$1 = state_17383;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17383__$1,(6),inst_17361);
} else {
if((state_val_17384 === (9))){
var inst_17378 = (state_17383[(2)]);
var _ = (function (){var statearr_17393 = state_17383;
(statearr_17393[(4)] = cljs.core.rest((state_17383[(4)])));

return statearr_17393;
})();
var state_17383__$1 = state_17383;
var statearr_17394_17409 = state_17383__$1;
(statearr_17394_17409[(2)] = inst_17378);

(statearr_17394_17409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17384 === (5))){
var _ = (function (){var statearr_17395 = state_17383;
(statearr_17395[(4)] = cljs.core.rest((state_17383[(4)])));

return statearr_17395;
})();
var state_17383__$1 = state_17383;
var ex17391 = (state_17383__$1[(2)]);
var statearr_17396_17410 = state_17383__$1;
(statearr_17396_17410[(5)] = ex17391);


if((ex17391 instanceof Error)){
var statearr_17397_17411 = state_17383__$1;
(statearr_17397_17411[(1)] = (4));

(statearr_17397_17411[(5)] = null);

} else {
throw ex17391;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17384 === (8))){
var inst_17371 = ["Unable to retrieve leaf node with id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage"].join('');
var inst_17372 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17373 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_17374 = cljs.core.PersistentHashMap.fromArrays(inst_17372,inst_17373);
var inst_17375 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17371,inst_17374);
var inst_17376 = (function(){throw inst_17375})();
var state_17383__$1 = state_17383;
var statearr_17398_17412 = state_17383__$1;
(statearr_17398_17412[(2)] = inst_17376);

(statearr_17398_17412[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0 = (function (){
var statearr_17399 = [null,null,null,null,null,null,null,null];
(statearr_17399[(0)] = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__);

(statearr_17399[(1)] = (1));

return statearr_17399;
});
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1 = (function (state_17383){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17383);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17400){var ex__2730__auto__ = e17400;
var statearr_17401_17413 = state_17383;
(statearr_17401_17413[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17383[(4)]))){
var statearr_17402_17414 = state_17383;
(statearr_17402_17414[(1)] = cljs.core.first((state_17383[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17415 = state_17383;
state_17383 = G__17415;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__ = function(state_17383){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1.call(this,state_17383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0;
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1;
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17403 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17403[(6)] = c__2749__auto__);

return statearr_17403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.resolve_index_node = (function fluree$db$storage$core$resolve_index_node(var_args){
var G__17417 = arguments.length;
switch (G__17417) {
case 2:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2 = (function (conn,node){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2(node,null);
}));

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3 = (function (conn,p__17418,error_fn){
var map__17419 = p__17418;
var map__17419__$1 = cljs.core.__destructure_map(map__17419);
var node = map__17419__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17419__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17419__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
if(cljs.core.truth_(comparator)){
} else {
throw (new Error(["Assert failed: ","Cannot resolve index node; configuration does not have a comparator.","\n","comparator"].join('')));
}

var return_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___17491 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17463){
var state_val_17464 = (state_17463[(1)]);
if((state_val_17464 === (7))){
var inst_17428 = (state_17463[(2)]);
var state_17463__$1 = state_17463;
var statearr_17465_17492 = state_17463__$1;
(statearr_17465_17492[(2)] = inst_17428);

(statearr_17465_17492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17464 === (1))){
var state_17463__$1 = state_17463;
var statearr_17466_17493 = state_17463__$1;
(statearr_17466_17493[(2)] = null);

(statearr_17466_17493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17464 === (4))){
var inst_17420 = (state_17463[(7)]);
var inst_17420__$1 = (state_17463[(2)]);
var inst_17421 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(inst_17420__$1,"Error resolving index node") : fluree.db.util.log.error.call(null,inst_17420__$1,"Error resolving index node"));
var state_17463__$1 = (function (){var statearr_17467 = state_17463;
(statearr_17467[(7)] = inst_17420__$1);

(statearr_17467[(8)] = inst_17421);

return statearr_17467;
})();
if(cljs.core.truth_(error_fn)){
var statearr_17468_17494 = state_17463__$1;
(statearr_17468_17494[(1)] = (5));

} else {
var statearr_17469_17495 = state_17463__$1;
(statearr_17469_17495[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17464 === (13))){
var inst_17446 = (state_17463[(9)]);
var inst_17449 = (state_17463[(2)]);
var inst_17450 = fluree.db.util.async.throw_err(inst_17449);
var inst_17451 = [new cljs.core.Keyword(null,"children","children",-940561982),inst_17450];
var inst_17452 = (new cljs.core.PersistentVector(null,2,(5),inst_17446,inst_17451,null));
var state_17463__$1 = state_17463;
var statearr_17470_17496 = state_17463__$1;
(statearr_17470_17496[(2)] = inst_17452);

(statearr_17470_17496[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17464 === (6))){
var state_17463__$1 = state_17463;
var statearr_17471_17497 = state_17463__$1;
(statearr_17471_17497[(2)] = null);

(statearr_17471_17497[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17464 === (3))){
var inst_17461 = (state_17463[(2)]);
var state_17463__$1 = state_17463;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17463__$1,inst_17461);
} else {
if((state_val_17464 === (12))){
var inst_17438 = (state_17463[(10)]);
var inst_17441 = (state_17463[(2)]);
var inst_17442 = fluree.db.util.async.throw_err(inst_17441);
var inst_17443 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_17442];
var inst_17444 = (new cljs.core.PersistentVector(null,2,(5),inst_17438,inst_17443,null));
var state_17463__$1 = state_17463;
var statearr_17472_17498 = state_17463__$1;
(statearr_17472_17498[(2)] = inst_17444);

(statearr_17472_17498[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17464 === (2))){
var _ = (function (){var statearr_17473 = state_17463;
(statearr_17473[(4)] = cljs.core.cons((8),(state_17463[(4)])));

return statearr_17473;
})();
var state_17463__$1 = state_17463;
if(cljs.core.truth_(leaf)){
var statearr_17474_17499 = state_17463__$1;
(statearr_17474_17499[(1)] = (9));

} else {
var statearr_17475_17500 = state_17463__$1;
(statearr_17475_17500[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17464 === (11))){
var inst_17454 = (state_17463[(2)]);
var inst_17455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17454,(0),null);
var inst_17456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17454,(1),null);
var inst_17457 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,inst_17455,inst_17456);
var inst_17458 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17457);
var _ = (function (){var statearr_17476 = state_17463;
(statearr_17476[(4)] = cljs.core.rest((state_17463[(4)])));

return statearr_17476;
})();
var state_17463__$1 = state_17463;
var statearr_17477_17501 = state_17463__$1;
(statearr_17477_17501[(2)] = inst_17458);

(statearr_17477_17501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17464 === (9))){
var inst_17438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17439 = fluree.db.storage.core.fetch_leaf_flakes(conn,node);
var state_17463__$1 = (function (){var statearr_17478 = state_17463;
(statearr_17478[(10)] = inst_17438);

return statearr_17478;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17463__$1,(12),inst_17439);
} else {
if((state_val_17464 === (5))){
var inst_17420 = (state_17463[(7)]);
var inst_17423 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17420);
var inst_17424 = cljs.core.async.close_BANG_(return_ch);
var inst_17425 = (error_fn.cljs$core$IFn$_invoke$arity$2 ? error_fn.cljs$core$IFn$_invoke$arity$2(inst_17423,inst_17424) : error_fn.call(null,inst_17423,inst_17424));
var state_17463__$1 = state_17463;
var statearr_17480_17502 = state_17463__$1;
(statearr_17480_17502[(2)] = inst_17425);

(statearr_17480_17502[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17464 === (10))){
var inst_17446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17447 = fluree.db.storage.core.fetch_child_attributes(conn,node);
var state_17463__$1 = (function (){var statearr_17481 = state_17463;
(statearr_17481[(9)] = inst_17446);

return statearr_17481;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17463__$1,(13),inst_17447);
} else {
if((state_val_17464 === (8))){
var _ = (function (){var statearr_17482 = state_17463;
(statearr_17482[(4)] = cljs.core.rest((state_17463[(4)])));

return statearr_17482;
})();
var state_17463__$1 = state_17463;
var ex17479 = (state_17463__$1[(2)]);
var statearr_17483_17503 = state_17463__$1;
(statearr_17483_17503[(5)] = ex17479);


var statearr_17484_17504 = state_17463__$1;
(statearr_17484_17504[(1)] = (4));

(statearr_17484_17504[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_17485 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17485[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_17485[(1)] = (1));

return statearr_17485;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_17463){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17463);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17486){var ex__2730__auto__ = e17486;
var statearr_17487_17505 = state_17463;
(statearr_17487_17505[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17463[(4)]))){
var statearr_17488_17506 = state_17463;
(statearr_17488_17506[(1)] = cljs.core.first((state_17463[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17507 = state_17463;
state_17463 = G__17507;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_17463){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_17463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17489 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17489[(6)] = c__2749__auto___17491);

return statearr_17489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_ch;
}));

(fluree.db.storage.core.resolve_index_node.cljs$lang$maxFixedArity = 3);

fluree.db.storage.core.resolve_empty_leaf = (function fluree$db$storage$core$resolve_empty_leaf(p__17508){
var map__17509 = p__17508;
var map__17509__$1 = cljs.core.__destructure_map(map__17509);
var node = map__17509__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17509__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var empty_set = fluree.db.flake.sorted_set_by(comparator);
var empty_node = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,empty_node);

return ch;
});
