// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status >= (500));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
var G__18990_18993 = "XHTTP Request Error:";
var G__18991_18994 = e.request;
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__18990_18993,G__18991_18994) : fluree.db.util.log.error.call(null,G__18990_18993,G__18991_18994));

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status > (0));
} else {
return and__4251__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__18992 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__18992,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__18992;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__18995 = opts;
var map__18995__$1 = cljs.core.__destructure_map(map__18995);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18995__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18995__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18995__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__18996 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__18996__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__18996,headers], 0)):G__18996);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__18996__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__18996__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json, :edn or :binary (default :text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__18997 = opts;
var map__18997__$1 = cljs.core.__destructure_map(map__18997);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18997__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18997__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18997__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18997__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18997__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__18998 = cljs.core.PersistentArrayMap.EMPTY;
var G__18998__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__18998,headers], 0)):G__18998);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__18998__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__18998__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__18999 = output_format;
var G__18999__$1 = (((G__18999 instanceof cljs.core.Keyword))?G__18999.fqn:null);
switch (G__18999__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__19001 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19001,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__19001;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19033){
var state_val_19034 = (state_19033[(1)]);
if((state_val_19034 === (7))){
var inst_19029 = (state_19033[(2)]);
var state_19033__$1 = state_19033;
var statearr_19035_19060 = state_19033__$1;
(statearr_19035_19060[(2)] = inst_19029);

(statearr_19035_19060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19034 === (1))){
var state_19033__$1 = state_19033;
var statearr_19036_19061 = state_19033__$1;
(statearr_19036_19061[(2)] = null);

(statearr_19036_19061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19034 === (4))){
var inst_19004 = (state_19033[(7)]);
var inst_19004__$1 = (state_19033[(2)]);
var inst_19005 = (inst_19004__$1 == null);
var state_19033__$1 = (function (){var statearr_19037 = state_19033;
(statearr_19037[(7)] = inst_19004__$1);

return statearr_19037;
})();
if(cljs.core.truth_(inst_19005)){
var statearr_19038_19062 = state_19033__$1;
(statearr_19038_19062[(1)] = (5));

} else {
var statearr_19039_19063 = state_19033__$1;
(statearr_19039_19063[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19034 === (6))){
var inst_19004 = (state_19033[(7)]);
var inst_19012 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19004,(0),null);
var inst_19013 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19004,(1),null);
var state_19033__$1 = (function (){var statearr_19040 = state_19033;
(statearr_19040[(8)] = inst_19012);

(statearr_19040[(9)] = inst_19013);

return statearr_19040;
})();
var statearr_19041_19064 = state_19033__$1;
(statearr_19041_19064[(2)] = null);

(statearr_19041_19064[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19034 === (3))){
var inst_19031 = (state_19033[(2)]);
var state_19033__$1 = state_19033;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19033__$1,inst_19031);
} else {
if((state_val_19034 === (2))){
var state_19033__$1 = state_19033;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19033__$1,(4),pub_chan);
} else {
if((state_val_19034 === (11))){
var _ = (function (){var statearr_19043 = state_19033;
(statearr_19043[(4)] = cljs.core.rest((state_19033[(4)])));

return statearr_19043;
})();
var state_19033__$1 = state_19033;
var ex19042 = (state_19033__$1[(2)]);
var statearr_19044_19065 = state_19033__$1;
(statearr_19044_19065[(5)] = ex19042);


var statearr_19045_19066 = state_19033__$1;
(statearr_19045_19066[(1)] = (10));

(statearr_19045_19066[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19034 === (9))){
var inst_19026 = (state_19033[(2)]);
var state_19033__$1 = (function (){var statearr_19046 = state_19033;
(statearr_19046[(10)] = inst_19026);

return statearr_19046;
})();
var statearr_19047_19067 = state_19033__$1;
(statearr_19047_19067[(2)] = null);

(statearr_19047_19067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19034 === (5))){
var inst_19007 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1("Web socket pub/producer channel closed.") : fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed."));
var state_19033__$1 = state_19033;
var statearr_19048_19068 = state_19033__$1;
(statearr_19048_19068[(2)] = inst_19007);

(statearr_19048_19068[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19034 === (10))){
var inst_19012 = (state_19033[(8)]);
var inst_19013 = (state_19033[(9)]);
var inst_19014 = (state_19033[(2)]);
var inst_19015 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_19014,"Error sending websocket message:",inst_19012) : fluree.db.util.log.error.call(null,inst_19014,"Error sending websocket message:",inst_19012));
var inst_19016 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19013,false);
var state_19033__$1 = (function (){var statearr_19049 = state_19033;
(statearr_19049[(11)] = inst_19015);

return statearr_19049;
})();
var statearr_19050_19069 = state_19033__$1;
(statearr_19050_19069[(2)] = inst_19016);

(statearr_19050_19069[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19034 === (8))){
var inst_19012 = (state_19033[(8)]);
var inst_19013 = (state_19033[(9)]);
var _ = (function (){var statearr_19051 = state_19033;
(statearr_19051[(4)] = cljs.core.cons((11),(state_19033[(4)])));

return statearr_19051;
})();
var inst_19022 = ws.send(inst_19012);
var inst_19023 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19013,true);
var ___$1 = (function (){var statearr_19052 = state_19033;
(statearr_19052[(4)] = cljs.core.rest((state_19033[(4)])));

return statearr_19052;
})();
var state_19033__$1 = (function (){var statearr_19053 = state_19033;
(statearr_19053[(12)] = inst_19022);

return statearr_19053;
})();
var statearr_19054_19070 = state_19033__$1;
(statearr_19054_19070[(2)] = inst_19023);

(statearr_19054_19070[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0 = (function (){
var statearr_19055 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19055[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__);

(statearr_19055[(1)] = (1));

return statearr_19055;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1 = (function (state_19033){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19033);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19056){var ex__2730__auto__ = e19056;
var statearr_19057_19071 = state_19033;
(statearr_19057_19071[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19033[(4)]))){
var statearr_19058_19072 = state_19033;
(statearr_19058_19072[(1)] = cljs.core.first((state_19033[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19073 = state_19033;
state_19033 = G__19073;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__ = function(state_19033){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1.call(this,state_19033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19059 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19059[(6)] = c__2749__auto__);

return statearr_19059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
var G__19074_19115 = "Websocket closed: ";
var G__19075_19116 = e.reason;
var G__19076_19117 = "Code: ";
var G__19077_19118 = e.code;
(fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4(G__19074_19115,G__19075_19116,G__19076_19117,G__19077_19118) : fluree.db.util.log.warn.call(null,G__19074_19115,G__19075_19116,G__19076_19117,G__19077_19118));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__2749__auto___19119 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19102){
var state_val_19103 = (state_19102[(1)]);
if((state_val_19103 === (1))){
var inst_19081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19082 = [open_QMARK_,timeout_chan];
var inst_19083 = (new cljs.core.PersistentVector(null,2,(5),inst_19081,inst_19082,null));
var state_19102__$1 = state_19102;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_19102__$1,(2),inst_19083,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_19103 === (2))){
var inst_19085 = (state_19102[(2)]);
var inst_19086 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19085,(0),null);
var inst_19087 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19085,(1),null);
var inst_19088 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19087,timeout_chan);
var state_19102__$1 = (function (){var statearr_19104 = state_19102;
(statearr_19104[(7)] = inst_19086);

return statearr_19104;
})();
if(inst_19088){
var statearr_19105_19120 = state_19102__$1;
(statearr_19105_19120[(1)] = (3));

} else {
var statearr_19106_19121 = state_19102__$1;
(statearr_19106_19121[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19103 === (3))){
var inst_19090 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_19091 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19092 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_19093 = cljs.core.PersistentHashMap.fromArrays(inst_19091,inst_19092);
var inst_19094 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19090,inst_19093);
var inst_19095 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_19094);
var inst_19096 = fluree.db.util.xhttp.close_websocket(ws);
var state_19102__$1 = (function (){var statearr_19107 = state_19102;
(statearr_19107[(8)] = inst_19095);

return statearr_19107;
})();
var statearr_19108_19122 = state_19102__$1;
(statearr_19108_19122[(2)] = inst_19096);

(statearr_19108_19122[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19103 === (4))){
var inst_19098 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_19102__$1 = state_19102;
var statearr_19109_19123 = state_19102__$1;
(statearr_19109_19123[(2)] = inst_19098);

(statearr_19109_19123[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19103 === (5))){
var inst_19100 = (state_19102[(2)]);
var state_19102__$1 = state_19102;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19102__$1,inst_19100);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_19110 = [null,null,null,null,null,null,null,null,null];
(statearr_19110[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__);

(statearr_19110[(1)] = (1));

return statearr_19110;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1 = (function (state_19102){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19102);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19111){var ex__2730__auto__ = e19111;
var statearr_19112_19124 = state_19102;
(statearr_19112_19124[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19102[(4)]))){
var statearr_19113_19125 = state_19102;
(statearr_19113_19125[(1)] = cljs.core.first((state_19102[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19126 = state_19102;
state_19102 = G__19126;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__ = function(state_19102){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1.call(this,state_19102);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19114 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19114[(6)] = c__2749__auto___19119);

return statearr_19114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
