// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.connection_js');
goog.require('goog.object');
goog.scope(function(){
flureeworker.goog$module$goog$object = goog.module.get('goog.object');
});
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__73794 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__73794__$1 = cljs.core.__destructure_map(map__73794);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73794__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73794__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"block","block",664686210),time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = flureeworker.goog$module$goog$object.get.call(null,obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__73795 = cljs.core.get_global_hierarchy;
return (fexpr__73795.cljs$core$IFn$_invoke$arity$0 ? fexpr__73795.cljs$core$IFn$_invoke$arity$0() : fexpr__73795.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),(function() { 
var G__73796__delegate = function (conn_id,event,_){
return event;
};
var G__73796 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__73797__i = 0, G__73797__a = new Array(arguments.length -  2);
while (G__73797__i < G__73797__a.length) {G__73797__a[G__73797__i] = arguments[G__73797__i + 2]; ++G__73797__i;}
  _ = new cljs.core.IndexedSeq(G__73797__a,0,null);
} 
return G__73796__delegate.call(this,conn_id,event,_);};
G__73796.cljs$lang$maxFixedArity = 2;
G__73796.cljs$lang$applyTo = (function (arglist__73798){
var conn_id = cljs.core.first(arglist__73798);
arglist__73798 = cljs.core.next(arglist__73798);
var event = cljs.core.first(arglist__73798);
var _ = cljs.core.rest(arglist__73798);
return G__73796__delegate(conn_id,event,_);
});
G__73796.cljs$core$IFn$_invoke$arity$variadic = G__73796__delegate;
return G__73796;
})()
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setState","setState",552299271),(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setState",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connStatus","connStatus",63327857),(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connStatus",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"login","login",55217519),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"login",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"pwGenerate",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connClosed","connClosed",1810797125),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connClosed",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connReset","connReset",-1382938159),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connReset",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setTransact","setTransact",1791803585),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setTransact",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connInit","connInit",-148647574),(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn","conn",278309663),(0),new cljs.core.Keyword(null,"event","event",301435442),"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),(function (){var or__4253__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unknown Error.";
}
})(),new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),e_map,new cljs.core.Keyword(null,"status","status",-1997798413),"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt);
if(cljs.core.truth_(flureeql)){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73816){
var state_val_73817 = (state_73816[(1)]);
if((state_val_73817 === (1))){
var inst_73799 = new cljs.core.Keyword(null,"forceTime","forceTime",827124337).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_73800 = flureeworker.conn_id__GT_db(conn_id,inst_73799);
var inst_73801 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,new cljs.core.Keyword(null,"opts","opts",155075701),opts_SINGLEQUOTE_);
var inst_73802 = fluree.db.api.query.query(inst_73800,inst_73801);
var state_73816__$1 = state_73816;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73816__$1,(2),inst_73802);
} else {
if((state_val_73817 === (2))){
var inst_73804 = (state_73816[(7)]);
var inst_73804__$1 = (state_73816[(2)]);
var inst_73805 = fluree.db.util.core.exception_QMARK_(inst_73804__$1);
var state_73816__$1 = (function (){var statearr_73818 = state_73816;
(statearr_73818[(7)] = inst_73804__$1);

return statearr_73818;
})();
if(inst_73805){
var statearr_73819_73832 = state_73816__$1;
(statearr_73819_73832[(1)] = (3));

} else {
var statearr_73820_73833 = state_73816__$1;
(statearr_73820_73833[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73817 === (3))){
var inst_73804 = (state_73816[(7)]);
var inst_73807 = flureeworker.error_return_map(inst_73804);
var state_73816__$1 = state_73816;
var statearr_73821_73834 = state_73816__$1;
(statearr_73821_73834[(2)] = inst_73807);

(statearr_73821_73834[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73817 === (4))){
var inst_73804 = (state_73816[(7)]);
var inst_73809 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_73810 = [inst_73804,"loaded"];
var inst_73811 = cljs.core.PersistentHashMap.fromArrays(inst_73809,inst_73810);
var state_73816__$1 = state_73816;
var statearr_73822_73835 = state_73816__$1;
(statearr_73822_73835[(2)] = inst_73811);

(statearr_73822_73835[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73817 === (5))){
var inst_73813 = (state_73816[(2)]);
var inst_73814 = (function (){var G__73823 = conn_id;
var G__73824 = new cljs.core.Keyword(null,"setState","setState",552299271);
var G__73825 = id;
var G__73826 = inst_73813;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73823,G__73824,G__73825,G__73826) : flureeworker.worker_action.call(null,G__73823,G__73824,G__73825,G__73826));
})();
var state_73816__$1 = state_73816;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73816__$1,inst_73814);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$process_query_$_state_machine__2727__auto__ = null;
var flureeworker$process_query_$_state_machine__2727__auto____0 = (function (){
var statearr_73827 = [null,null,null,null,null,null,null,null];
(statearr_73827[(0)] = flureeworker$process_query_$_state_machine__2727__auto__);

(statearr_73827[(1)] = (1));

return statearr_73827;
});
var flureeworker$process_query_$_state_machine__2727__auto____1 = (function (state_73816){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73816);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73828){var ex__2730__auto__ = e73828;
var statearr_73829_73836 = state_73816;
(statearr_73829_73836[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73816[(4)]))){
var statearr_73830_73837 = state_73816;
(statearr_73830_73837[(1)] = cljs.core.first((state_73816[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73838 = state_73816;
state_73816 = G__73838;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__2727__auto__ = function(state_73816){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__2727__auto____1.call(this,state_73816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__2727__auto____0;
flureeworker$process_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__2727__auto____1;
return flureeworker$process_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73831 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73831[(6)] = c__2749__auto__);

return statearr_73831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__73839 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__73839__$1 = cljs.core.__destructure_map(map__73839);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73839__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73839__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var query_ids = cljs.core.keys(queries);
var seq__73840 = cljs.core.seq(query_ids);
var chunk__73841 = null;
var count__73842 = (0);
var i__73843 = (0);
while(true){
if((i__73843 < count__73842)){
var id = chunk__73841.cljs$core$IIndexed$_nth$arity$2(null,i__73843);
flureeworker.process_query(conn_id,id,opts);


var G__73844 = seq__73840;
var G__73845 = chunk__73841;
var G__73846 = count__73842;
var G__73847 = (i__73843 + (1));
seq__73840 = G__73844;
chunk__73841 = G__73845;
count__73842 = G__73846;
i__73843 = G__73847;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__73840);
if(temp__5804__auto__){
var seq__73840__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__73840__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__73840__$1);
var G__73848 = cljs.core.chunk_rest(seq__73840__$1);
var G__73849 = c__4679__auto__;
var G__73850 = cljs.core.count(c__4679__auto__);
var G__73851 = (0);
seq__73840 = G__73848;
chunk__73841 = G__73849;
count__73842 = G__73850;
i__73843 = G__73851;
continue;
} else {
var id = cljs.core.first(seq__73840__$1);
flureeworker.process_query(conn_id,id,opts);


var G__73852 = cljs.core.next(seq__73840__$1);
var G__73853 = null;
var G__73854 = (0);
var G__73855 = (0);
seq__73840 = G__73852;
chunk__73841 = G__73853;
count__73842 = G__73854;
i__73843 = G__73855;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__73856 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73856,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73856,(1),null);
var cb = (function (header,data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73864){
var state_val_73865 = (state_73864[(1)]);
if((state_val_73865 === (1))){
var inst_73859 = cljs.core.async.timeout((100));
var state_73864__$1 = state_73864;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73864__$1,(2),inst_73859);
} else {
if((state_val_73865 === (2))){
var inst_73861 = (state_73864[(2)]);
var inst_73862 = flureeworker.process_all_queries(conn_id);
var state_73864__$1 = (function (){var statearr_73866 = state_73864;
(statearr_73866[(7)] = inst_73861);

return statearr_73866;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_73864__$1,inst_73862);
} else {
return null;
}
}
});
return (function() {
var flureeworker$ledger_listener_$_state_machine__2727__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__2727__auto____0 = (function (){
var statearr_73867 = [null,null,null,null,null,null,null,null];
(statearr_73867[(0)] = flureeworker$ledger_listener_$_state_machine__2727__auto__);

(statearr_73867[(1)] = (1));

return statearr_73867;
});
var flureeworker$ledger_listener_$_state_machine__2727__auto____1 = (function (state_73864){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73864);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73868){var ex__2730__auto__ = e73868;
var statearr_73869_73872 = state_73864;
(statearr_73869_73872[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73864[(4)]))){
var statearr_73870_73873 = state_73864;
(statearr_73870_73873[(1)] = cljs.core.first((state_73864[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73874 = state_73864;
state_73864 = G__73874;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__2727__auto__ = function(state_73864){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__2727__auto____1.call(this,state_73864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__2727__auto____0;
flureeworker$ledger_listener_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__2727__auto____1;
return flureeworker$ledger_listener_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73871 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73871[(6)] = c__2749__auto__);

return statearr_73871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__73875 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73875,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73875,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__73878 = config;
var map__73878__$1 = cljs.core.__destructure_map(map__73878);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73878__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73878__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73878__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73878__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73878__$1,new cljs.core.Keyword(null,"compact","compact",-348732150));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73878__$1,new cljs.core.Keyword(null,"private","private",-558947994));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"closed","closed",-919675359),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"conn","conn",278309663)],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"compact","compact",-348732150),compact], null),servers,(function (){var or__4253__auto__ = queries;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__73879 = conn_data;
var map__73879__$1 = cljs.core.__destructure_map(map__73879);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73879__$1,new cljs.core.Keyword(null,"config","config",994861415));
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73879__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73879__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var map__73880 = config;
var map__73880__$1 = cljs.core.__destructure_map(map__73880);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73880__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73880__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73880__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73880__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73886){
var state_val_73887 = (state_73886[(1)]);
if((state_val_73887 === (1))){
var inst_73881 = cljs.core.async.timeout((100));
var state_73886__$1 = state_73886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73886__$1,(2),inst_73881);
} else {
if((state_val_73887 === (2))){
var inst_73883 = (state_73886[(2)]);
var inst_73884 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_73886__$1 = (function (){var statearr_73888 = state_73886;
(statearr_73888[(7)] = inst_73883);

return statearr_73888;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_73886__$1,inst_73884);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_STAR__$_state_machine__2727__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__2727__auto____0 = (function (){
var statearr_73889 = [null,null,null,null,null,null,null,null];
(statearr_73889[(0)] = flureeworker$connect_STAR__$_state_machine__2727__auto__);

(statearr_73889[(1)] = (1));

return statearr_73889;
});
var flureeworker$connect_STAR__$_state_machine__2727__auto____1 = (function (state_73886){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73886);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73890){var ex__2730__auto__ = e73890;
var statearr_73891_73902 = state_73886;
(statearr_73891_73902[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73886[(4)]))){
var statearr_73892_73903 = state_73886;
(statearr_73892_73903[(1)] = cljs.core.first((state_73886[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73904 = state_73886;
state_73886 = G__73904;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__2727__auto__ = function(state_73886){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__2727__auto____1.call(this,state_73886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__2727__auto____0;
flureeworker$connect_STAR__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__2727__auto____1;
return flureeworker$connect_STAR__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73893 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73893[(6)] = c__2749__auto__);

return statearr_73893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}):null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__73894_73905 = conn_id;
var G__73895_73906 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__73896_73907 = ref;
var G__73897_73908 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73894_73905,G__73895_73906,G__73896_73907,G__73897_73908) : flureeworker.worker_action.call(null,G__73894_73905,G__73895_73906,G__73896_73907,G__73897_73908));

return flureeworker.process_all_queries(conn_id);
})).catch((function (error){
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__73898 = conn_id;
var G__73899 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__73900 = ref;
var G__73901 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73898,G__73899,G__73900,G__73901) : flureeworker.worker_action.call(null,G__73898,G__73899,G__73900,G__73901));
}));
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__73910 = arguments.length;
switch (G__73910) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
}));

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__73911 = conn_data;
var map__73911__$1 = cljs.core.__destructure_map(map__73911);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73911__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73911__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73911__$1,new cljs.core.Keyword(null,"config","config",994861415));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73911__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"closed","closed",-919675359),true,new cljs.core.Keyword(null,"config","config",994861415),config,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null));
if((((conn_data == null)) || (new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection closed."], null);
}
}));

(flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2);

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__73918 = conn_id;
var G__73919 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__73920 = ref;
var G__73921 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73918,G__73919,G__73920,G__73921) : flureeworker.worker_action.call(null,G__73918,G__73919,G__73920,G__73921));
}catch (e73913){var e = e73913;
var msg = (function (){var or__4253__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4253__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__73914 = conn_id;
var G__73915 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__73916 = ref;
var G__73917 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73914,G__73915,G__73916,G__73917) : flureeworker.worker_action.call(null,G__73914,G__73915,G__73916,G__73917));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e73922){var e = e73922;
var msg = (function (){var or__4253__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4253__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__73923 = conn_id;
var G__73924 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__73925 = ref;
var G__73926 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73923,G__73924,G__73925,G__73926) : flureeworker.worker_action.call(null,G__73923,G__73924,G__73925,G__73926));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__73927 = config_STAR_;
var map__73927__$1 = cljs.core.__destructure_map(map__73927);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73927__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73927__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73927__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73927__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"finest","finest",-1359568890)):null);
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73933){
var state_val_73934 = (state_73933[(1)]);
if((state_val_73934 === (1))){
var inst_73928 = cljs.core.async.timeout((100));
var state_73933__$1 = state_73933;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73933__$1,(2),inst_73928);
} else {
if((state_val_73934 === (2))){
var inst_73930 = (state_73933[(2)]);
var inst_73931 = flureeworker.connect_STAR_(id,ref);
var state_73933__$1 = (function (){var statearr_73935 = state_73933;
(statearr_73935[(7)] = inst_73930);

return statearr_73935;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_73933__$1,inst_73931);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_p_$_state_machine__2727__auto__ = null;
var flureeworker$connect_p_$_state_machine__2727__auto____0 = (function (){
var statearr_73936 = [null,null,null,null,null,null,null,null];
(statearr_73936[(0)] = flureeworker$connect_p_$_state_machine__2727__auto__);

(statearr_73936[(1)] = (1));

return statearr_73936;
});
var flureeworker$connect_p_$_state_machine__2727__auto____1 = (function (state_73933){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73933);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73937){var ex__2730__auto__ = e73937;
var statearr_73938_73949 = state_73933;
(statearr_73938_73949[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73933[(4)]))){
var statearr_73939_73950 = state_73933;
(statearr_73939_73950[(1)] = cljs.core.first((state_73933[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73951 = state_73933;
state_73933 = G__73951;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__2727__auto__ = function(state_73933){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__2727__auto____1.call(this,state_73933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__2727__auto____0;
flureeworker$connect_p_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__2727__auto____1;
return flureeworker$connect_p_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73940 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73940[(6)] = c__2749__auto__);

return statearr_73940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}):null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__73941 = id;
var G__73942 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__73943 = ref;
var G__73944 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73941,G__73942,G__73943,G__73944) : flureeworker.worker_action.call(null,G__73941,G__73942,G__73943,G__73944));
})).catch((function (error){
var G__73945 = id;
var G__73946 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__73947 = ref;
var G__73948 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73945,G__73946,G__73947,G__73948) : flureeworker.worker_action.call(null,G__73945,G__73946,G__73947,G__73948));
}));
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"closed","closed",-919675359)], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__4870__auto__ = [];
var len__4864__auto___74019 = arguments.length;
var i__4865__auto___74020 = (0);
while(true){
if((i__4865__auto___74020 < len__4864__auto___74019)){
args__4870__auto__.push((arguments[i__4865__auto___74020]));

var G__74021 = (i__4865__auto___74020 + (1));
i__4865__auto___74020 = G__74021;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((4) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4871__auto__);
});

(flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__73957){
var vec__73958 = p__73957;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73958,(0),null);
var map__73961 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__73961__$1 = cljs.core.__destructure_map(map__73961);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73961__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73961__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73961__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__73962 = conn_id;
var G__73963 = new cljs.core.Keyword(null,"login","login",55217519);
var G__73964 = ref;
var G__73965 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73962,G__73963,G__73964,G__73965) : flureeworker.worker_action.call(null,G__73962,G__73963,G__73964,G__73965));
})());
var auth = null;
var c__2749__auto___74022 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73986){
var state_val_73987 = (state_73986[(1)]);
if((state_val_73987 === (1))){
var state_73986__$1 = state_73986;
var statearr_73988_74023 = state_73986__$1;
(statearr_73988_74023[(2)] = null);

(statearr_73988_74023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73987 === (2))){
var ___$1 = (function (){var statearr_73989 = state_73986;
(statearr_73989[(4)] = cljs.core.cons((5),(state_73986[(4)])));

return statearr_73989;
})();
var inst_73977 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_73978 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__73990 = conn_id;
var G__73991 = new cljs.core.Keyword(null,"login","login",55217519);
var G__73992 = ref;
var G__73993 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73990,G__73991,G__73992,G__73993) : flureeworker.worker_action.call(null,G__73990,G__73991,G__73992,G__73993));
});
})();
var inst_73979 = inst_73977.then(inst_73978);
var inst_73980 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e73994){var ___$2 = e73994;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__73995 = conn_id;
var G__73996 = new cljs.core.Keyword(null,"login","login",55217519);
var G__73997 = ref;
var G__73998 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73995,G__73996,G__73997,G__73998) : flureeworker.worker_action.call(null,G__73995,G__73996,G__73997,G__73998));
} else {
var G__73999 = conn_id;
var G__74000 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74001 = ref;
var G__74002 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73999,G__74000,G__74001,G__74002) : flureeworker.worker_action.call(null,G__73999,G__74000,G__74001,G__74002));

}
});
})();
var inst_73981 = inst_73979.catch(inst_73980);
var ___$2 = (function (){var statearr_74003 = state_73986;
(statearr_74003[(4)] = cljs.core.rest((state_73986[(4)])));

return statearr_74003;
})();
var state_73986__$1 = state_73986;
var statearr_74004_74024 = state_73986__$1;
(statearr_74004_74024[(2)] = inst_73981);

(statearr_74004_74024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73987 === (3))){
var inst_73984 = (state_73986[(2)]);
var state_73986__$1 = state_73986;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73986__$1,inst_73984);
} else {
if((state_val_73987 === (4))){
var inst_73966 = (state_73986[(2)]);
var inst_73967 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_73968 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73966);
var inst_73969 = [(400),inst_73968];
var inst_73970 = cljs.core.PersistentHashMap.fromArrays(inst_73967,inst_73969);
var inst_73971 = (function (){var G__74006 = conn_id;
var G__74007 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74008 = ref;
var G__74009 = inst_73970;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74006,G__74007,G__74008,G__74009) : flureeworker.worker_action.call(null,G__74006,G__74007,G__74008,G__74009));
})();
var state_73986__$1 = state_73986;
var statearr_74010_74025 = state_73986__$1;
(statearr_74010_74025[(2)] = inst_73971);

(statearr_74010_74025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73987 === (5))){
var ___$1 = (function (){var statearr_74011 = state_73986;
(statearr_74011[(4)] = cljs.core.rest((state_73986[(4)])));

return statearr_74011;
})();
var state_73986__$1 = state_73986;
var ex74005 = (state_73986__$1[(2)]);
var statearr_74012_74026 = state_73986__$1;
(statearr_74012_74026[(5)] = ex74005);


var statearr_74013_74027 = state_73986__$1;
(statearr_74013_74027[(1)] = (4));

(statearr_74013_74027[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$state_machine__2727__auto__ = null;
var flureeworker$state_machine__2727__auto____0 = (function (){
var statearr_74014 = [null,null,null,null,null,null,null];
(statearr_74014[(0)] = flureeworker$state_machine__2727__auto__);

(statearr_74014[(1)] = (1));

return statearr_74014;
});
var flureeworker$state_machine__2727__auto____1 = (function (state_73986){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73986);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74015){var ex__2730__auto__ = e74015;
var statearr_74016_74028 = state_73986;
(statearr_74016_74028[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73986[(4)]))){
var statearr_74017_74029 = state_73986;
(statearr_74017_74029[(1)] = cljs.core.first((state_73986[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74030 = state_73986;
state_73986 = G__74030;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$state_machine__2727__auto__ = function(state_73986){
switch(arguments.length){
case 0:
return flureeworker$state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$state_machine__2727__auto____1.call(this,state_73986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__2727__auto____0;
flureeworker$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__2727__auto____1;
return flureeworker$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74018 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74018[(6)] = c__2749__auto___74022);

return statearr_74018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return true;
}));

(flureeworker.login.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(flureeworker.login.cljs$lang$applyTo = (function (seq73952){
var G__73953 = cljs.core.first(seq73952);
var seq73952__$1 = cljs.core.next(seq73952);
var G__73954 = cljs.core.first(seq73952__$1);
var seq73952__$2 = cljs.core.next(seq73952__$1);
var G__73955 = cljs.core.first(seq73952__$2);
var seq73952__$3 = cljs.core.next(seq73952__$2);
var G__73956 = cljs.core.first(seq73952__$3);
var seq73952__$4 = cljs.core.next(seq73952__$3);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73953,G__73954,G__73955,G__73956,seq73952__$4);
}));

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__74031 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__74031__$1 = cljs.core.__destructure_map(map__74031);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74031__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74031__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__74033 = conn_id;
var G__74034 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74035 = ref;
var G__74036 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74033,G__74034,G__74035,G__74036) : flureeworker.worker_action.call(null,G__74033,G__74034,G__74035,G__74036));
})());
var map__74032 = map_data;
var map__74032__$1 = cljs.core.__destructure_map(map__74032);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74032__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74032__$1,new cljs.core.Keyword(null,"password","password",417022471));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74032__$1,new cljs.core.Keyword(null,"options","options",99638489));
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),new cljs.core.Keyword(null,"user","user",1532431356),username);
var c__2749__auto___74090 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74057){
var state_val_74058 = (state_74057[(1)]);
if((state_val_74058 === (1))){
var state_74057__$1 = state_74057;
var statearr_74059_74091 = state_74057__$1;
(statearr_74059_74091[(2)] = null);

(statearr_74059_74091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74058 === (2))){
var ___$1 = (function (){var statearr_74060 = state_74057;
(statearr_74060[(4)] = cljs.core.cons((5),(state_74057[(4)])));

return statearr_74060;
})();
var inst_74048 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_74049 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__74061 = conn_id;
var G__74062 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__74063 = ref;
var G__74064 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74061,G__74062,G__74063,G__74064) : flureeworker.worker_action.call(null,G__74061,G__74062,G__74063,G__74064));
});
})();
var inst_74050 = inst_74048.then(inst_74049);
var inst_74051 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e74065){var ___$2 = e74065;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__74066 = conn_id;
var G__74067 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__74068 = ref;
var G__74069 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74066,G__74067,G__74068,G__74069) : flureeworker.worker_action.call(null,G__74066,G__74067,G__74068,G__74069));
} else {
var G__74070 = conn_id;
var G__74071 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__74072 = ref;
var G__74073 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74070,G__74071,G__74072,G__74073) : flureeworker.worker_action.call(null,G__74070,G__74071,G__74072,G__74073));

}
});
})();
var inst_74052 = inst_74050.catch(inst_74051);
var ___$2 = (function (){var statearr_74074 = state_74057;
(statearr_74074[(4)] = cljs.core.rest((state_74057[(4)])));

return statearr_74074;
})();
var state_74057__$1 = state_74057;
var statearr_74075_74092 = state_74057__$1;
(statearr_74075_74092[(2)] = inst_74052);

(statearr_74075_74092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74058 === (3))){
var inst_74055 = (state_74057[(2)]);
var state_74057__$1 = state_74057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74057__$1,inst_74055);
} else {
if((state_val_74058 === (4))){
var inst_74037 = (state_74057[(2)]);
var inst_74038 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_74039 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74037);
var inst_74040 = [(400),inst_74039];
var inst_74041 = cljs.core.PersistentHashMap.fromArrays(inst_74038,inst_74040);
var inst_74042 = (function (){var G__74077 = conn_id;
var G__74078 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__74079 = ref;
var G__74080 = inst_74041;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74077,G__74078,G__74079,G__74080) : flureeworker.worker_action.call(null,G__74077,G__74078,G__74079,G__74080));
})();
var state_74057__$1 = state_74057;
var statearr_74081_74093 = state_74057__$1;
(statearr_74081_74093[(2)] = inst_74042);

(statearr_74081_74093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74058 === (5))){
var ___$1 = (function (){var statearr_74082 = state_74057;
(statearr_74082[(4)] = cljs.core.rest((state_74057[(4)])));

return statearr_74082;
})();
var state_74057__$1 = state_74057;
var ex74076 = (state_74057__$1[(2)]);
var statearr_74083_74094 = state_74057__$1;
(statearr_74083_74094[(5)] = ex74076);


var statearr_74084_74095 = state_74057__$1;
(statearr_74084_74095[(1)] = (4));

(statearr_74084_74095[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$pw_generate_$_state_machine__2727__auto__ = null;
var flureeworker$pw_generate_$_state_machine__2727__auto____0 = (function (){
var statearr_74085 = [null,null,null,null,null,null,null];
(statearr_74085[(0)] = flureeworker$pw_generate_$_state_machine__2727__auto__);

(statearr_74085[(1)] = (1));

return statearr_74085;
});
var flureeworker$pw_generate_$_state_machine__2727__auto____1 = (function (state_74057){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74057);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74086){var ex__2730__auto__ = e74086;
var statearr_74087_74096 = state_74057;
(statearr_74087_74096[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74057[(4)]))){
var statearr_74088_74097 = state_74057;
(statearr_74088_74097[(1)] = cljs.core.first((state_74057[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74098 = state_74057;
state_74057 = G__74098;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__2727__auto__ = function(state_74057){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__2727__auto____1.call(this,state_74057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__2727__auto____0;
flureeworker$pw_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__2727__auto____1;
return flureeworker$pw_generate_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74089 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74089[(6)] = c__2749__auto___74090);

return statearr_74089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"opts","opts",155075701)], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return new cljs.core.Keyword(null,"TODO","TODO",-523795145);
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__74099_SHARP_){
return (js_array[p1__74099_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),action_str,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"status","status",-1997798413),(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e74100){var e = e74100;
var data = (event["data"]);
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),(data["conn"]),new cljs.core.Keyword(null,"event","event",301435442),(data["action"]),new cljs.core.Keyword(null,"ref","ref",1289896967),(data["ref"]),new cljs.core.Keyword(null,"data","data",-232669377),error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5804__auto___74101 = cljs.core.not(self.document);
if(temp__5804__auto___74101){
var worker_QMARK__74102 = temp__5804__auto___74101;
(self.onerror = flureeworker.log_error);

(self.onmessage = flureeworker.decode_message);
} else {
}
var G__74103_74105 = null;
var G__74104_74106 = new cljs.core.Keyword(null,"connInit","connInit",-148647574);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__74103_74105,G__74104_74106) : flureeworker.worker_action.call(null,G__74103_74105,G__74104_74106));
