// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
goog.scope(function(){
cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__11530 = arguments.length;
switch (G__11530) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11531 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11531 = (function (f,blockable,meta11532){
this.f = f;
this.blockable = blockable;
this.meta11532 = meta11532;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11531.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11533,meta11532__$1){
var self__ = this;
var _11533__$1 = this;
return (new cljs.core.async.t_cljs$core$async11531(self__.f,self__.blockable,meta11532__$1));
}));

(cljs.core.async.t_cljs$core$async11531.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11533){
var self__ = this;
var _11533__$1 = this;
return self__.meta11532;
}));

(cljs.core.async.t_cljs$core$async11531.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11531.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11531.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async11531.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async11531.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11532","meta11532",120968016,null)], null);
}));

(cljs.core.async.t_cljs$core$async11531.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11531.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11531");

(cljs.core.async.t_cljs$core$async11531.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async11531");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11531.
 */
cljs.core.async.__GT_t_cljs$core$async11531 = (function cljs$core$async$__GT_t_cljs$core$async11531(f__$1,blockable__$1,meta11532){
return (new cljs.core.async.t_cljs$core$async11531(f__$1,blockable__$1,meta11532));
});

}

return (new cljs.core.async.t_cljs$core$async11531(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__11537 = arguments.length;
switch (G__11537) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__11540 = arguments.length;
switch (G__11540) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__11543 = arguments.length;
switch (G__11543) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_11545 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_11545) : fn1.call(null,val_11545));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_11545) : fn1.call(null,val_11545));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__11547 = arguments.length;
switch (G__11547) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4741__auto___11549 = n;
var x_11550 = (0);
while(true){
if((x_11550 < n__4741__auto___11549)){
(a[x_11550] = x_11550);

var G__11551 = (x_11550 + (1));
x_11550 = G__11551;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle.call(null,a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11552 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11552 = (function (flag,meta11553){
this.flag = flag;
this.meta11553 = meta11553;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11552.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11554,meta11553__$1){
var self__ = this;
var _11554__$1 = this;
return (new cljs.core.async.t_cljs$core$async11552(self__.flag,meta11553__$1));
}));

(cljs.core.async.t_cljs$core$async11552.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11554){
var self__ = this;
var _11554__$1 = this;
return self__.meta11553;
}));

(cljs.core.async.t_cljs$core$async11552.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11552.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async11552.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11552.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async11552.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11553","meta11553",84768360,null)], null);
}));

(cljs.core.async.t_cljs$core$async11552.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11552.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11552");

(cljs.core.async.t_cljs$core$async11552.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async11552");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11552.
 */
cljs.core.async.__GT_t_cljs$core$async11552 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11552(flag__$1,meta11553){
return (new cljs.core.async.t_cljs$core$async11552(flag__$1,meta11553));
});

}

return (new cljs.core.async.t_cljs$core$async11552(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11555 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11555 = (function (flag,cb,meta11556){
this.flag = flag;
this.cb = cb;
this.meta11556 = meta11556;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11555.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11557,meta11556__$1){
var self__ = this;
var _11557__$1 = this;
return (new cljs.core.async.t_cljs$core$async11555(self__.flag,self__.cb,meta11556__$1));
}));

(cljs.core.async.t_cljs$core$async11555.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11557){
var self__ = this;
var _11557__$1 = this;
return self__.meta11556;
}));

(cljs.core.async.t_cljs$core$async11555.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11555.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async11555.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11555.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async11555.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11556","meta11556",-1140168019,null)], null);
}));

(cljs.core.async.t_cljs$core$async11555.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11555.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11555");

(cljs.core.async.t_cljs$core$async11555.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async11555");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11555.
 */
cljs.core.async.__GT_t_cljs$core$async11555 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11555(flag__$1,cb__$1,meta11556){
return (new cljs.core.async.t_cljs$core$async11555(flag__$1,cb__$1,meta11556));
});

}

return (new cljs.core.async.t_cljs$core$async11555(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11558_SHARP_){
var G__11560 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11558_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__11560) : fret.call(null,G__11560));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11559_SHARP_){
var G__11561 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11559_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__11561) : fret.call(null,G__11561));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4253__auto__ = wport;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11562 = (i + (1));
i = G__11562;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4253__auto__ = ret;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4251__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4251__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___11567 = arguments.length;
var i__4865__auto___11568 = (0);
while(true){
if((i__4865__auto___11568 < len__4864__auto___11567)){
args__4870__auto__.push((arguments[i__4865__auto___11568]));

var G__11569 = (i__4865__auto___11568 + (1));
i__4865__auto___11568 = G__11569;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11565){
var map__11566 = p__11565;
var map__11566__$1 = cljs.core.__destructure_map(map__11566);
var opts = map__11566__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11563){
var G__11564 = cljs.core.first(seq11563);
var seq11563__$1 = cljs.core.next(seq11563);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11564,seq11563__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__11571 = arguments.length;
switch (G__11571) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11470__auto___11618 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_11595){
var state_val_11596 = (state_11595[(1)]);
if((state_val_11596 === (7))){
var inst_11591 = (state_11595[(2)]);
var state_11595__$1 = state_11595;
var statearr_11597_11619 = state_11595__$1;
(statearr_11597_11619[(2)] = inst_11591);

(statearr_11597_11619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11596 === (1))){
var state_11595__$1 = state_11595;
var statearr_11598_11620 = state_11595__$1;
(statearr_11598_11620[(2)] = null);

(statearr_11598_11620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11596 === (4))){
var inst_11574 = (state_11595[(7)]);
var inst_11574__$1 = (state_11595[(2)]);
var inst_11575 = (inst_11574__$1 == null);
var state_11595__$1 = (function (){var statearr_11599 = state_11595;
(statearr_11599[(7)] = inst_11574__$1);

return statearr_11599;
})();
if(cljs.core.truth_(inst_11575)){
var statearr_11600_11621 = state_11595__$1;
(statearr_11600_11621[(1)] = (5));

} else {
var statearr_11601_11622 = state_11595__$1;
(statearr_11601_11622[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11596 === (13))){
var state_11595__$1 = state_11595;
var statearr_11602_11623 = state_11595__$1;
(statearr_11602_11623[(2)] = null);

(statearr_11602_11623[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11596 === (6))){
var inst_11574 = (state_11595[(7)]);
var state_11595__$1 = state_11595;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11595__$1,(11),to,inst_11574);
} else {
if((state_val_11596 === (3))){
var inst_11593 = (state_11595[(2)]);
var state_11595__$1 = state_11595;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11595__$1,inst_11593);
} else {
if((state_val_11596 === (12))){
var state_11595__$1 = state_11595;
var statearr_11603_11624 = state_11595__$1;
(statearr_11603_11624[(2)] = null);

(statearr_11603_11624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11596 === (2))){
var state_11595__$1 = state_11595;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11595__$1,(4),from);
} else {
if((state_val_11596 === (11))){
var inst_11584 = (state_11595[(2)]);
var state_11595__$1 = state_11595;
if(cljs.core.truth_(inst_11584)){
var statearr_11604_11625 = state_11595__$1;
(statearr_11604_11625[(1)] = (12));

} else {
var statearr_11605_11626 = state_11595__$1;
(statearr_11605_11626[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11596 === (9))){
var state_11595__$1 = state_11595;
var statearr_11606_11627 = state_11595__$1;
(statearr_11606_11627[(2)] = null);

(statearr_11606_11627[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11596 === (5))){
var state_11595__$1 = state_11595;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11607_11628 = state_11595__$1;
(statearr_11607_11628[(1)] = (8));

} else {
var statearr_11608_11629 = state_11595__$1;
(statearr_11608_11629[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11596 === (14))){
var inst_11589 = (state_11595[(2)]);
var state_11595__$1 = state_11595;
var statearr_11609_11630 = state_11595__$1;
(statearr_11609_11630[(2)] = inst_11589);

(statearr_11609_11630[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11596 === (10))){
var inst_11581 = (state_11595[(2)]);
var state_11595__$1 = state_11595;
var statearr_11610_11631 = state_11595__$1;
(statearr_11610_11631[(2)] = inst_11581);

(statearr_11610_11631[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11596 === (8))){
var inst_11578 = cljs.core.async.close_BANG_(to);
var state_11595__$1 = state_11595;
var statearr_11611_11632 = state_11595__$1;
(statearr_11611_11632[(2)] = inst_11578);

(statearr_11611_11632[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11396__auto__ = null;
var cljs$core$async$state_machine__11396__auto____0 = (function (){
var statearr_11612 = [null,null,null,null,null,null,null,null];
(statearr_11612[(0)] = cljs$core$async$state_machine__11396__auto__);

(statearr_11612[(1)] = (1));

return statearr_11612;
});
var cljs$core$async$state_machine__11396__auto____1 = (function (state_11595){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_11595);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e11613){var ex__11399__auto__ = e11613;
var statearr_11614_11633 = state_11595;
(statearr_11614_11633[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_11595[(4)]))){
var statearr_11615_11634 = state_11595;
(statearr_11615_11634[(1)] = cljs.core.first((state_11595[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11635 = state_11595;
state_11595 = G__11635;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$state_machine__11396__auto__ = function(state_11595){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11396__auto____1.call(this,state_11595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11396__auto____0;
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11396__auto____1;
return cljs$core$async$state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_11616 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_11616[(6)] = c__11470__auto___11618);

return statearr_11616;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__11636){
var vec__11637 = p__11636;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11637,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11637,(1),null);
var job = vec__11637;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__11470__auto___11813 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_11644){
var state_val_11645 = (state_11644[(1)]);
if((state_val_11645 === (1))){
var state_11644__$1 = state_11644;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11644__$1,(2),res,v);
} else {
if((state_val_11645 === (2))){
var inst_11641 = (state_11644[(2)]);
var inst_11642 = cljs.core.async.close_BANG_(res);
var state_11644__$1 = (function (){var statearr_11646 = state_11644;
(statearr_11646[(7)] = inst_11641);

return statearr_11646;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_11644__$1,inst_11642);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0 = (function (){
var statearr_11647 = [null,null,null,null,null,null,null,null];
(statearr_11647[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__);

(statearr_11647[(1)] = (1));

return statearr_11647;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1 = (function (state_11644){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_11644);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e11648){var ex__11399__auto__ = e11648;
var statearr_11649_11814 = state_11644;
(statearr_11649_11814[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_11644[(4)]))){
var statearr_11650_11815 = state_11644;
(statearr_11650_11815[(1)] = cljs.core.first((state_11644[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11816 = state_11644;
state_11644 = G__11816;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__ = function(state_11644){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1.call(this,state_11644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_11651 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_11651[(6)] = c__11470__auto___11813);

return statearr_11651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__11652){
var vec__11653 = p__11652;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11653,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11653,(1),null);
var job = vec__11653;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4741__auto___11817 = n;
var __11818 = (0);
while(true){
if((__11818 < n__4741__auto___11817)){
var G__11656_11819 = type;
var G__11656_11820__$1 = (((G__11656_11819 instanceof cljs.core.Keyword))?G__11656_11819.fqn:null);
switch (G__11656_11820__$1) {
case "compute":
var c__11470__auto___11822 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__11818,c__11470__auto___11822,G__11656_11819,G__11656_11820__$1,n__4741__auto___11817,jobs,results,process,async){
return (function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = ((function (__11818,c__11470__auto___11822,G__11656_11819,G__11656_11820__$1,n__4741__auto___11817,jobs,results,process,async){
return (function (state_11669){
var state_val_11670 = (state_11669[(1)]);
if((state_val_11670 === (1))){
var state_11669__$1 = state_11669;
var statearr_11671_11823 = state_11669__$1;
(statearr_11671_11823[(2)] = null);

(statearr_11671_11823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11670 === (2))){
var state_11669__$1 = state_11669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11669__$1,(4),jobs);
} else {
if((state_val_11670 === (3))){
var inst_11667 = (state_11669[(2)]);
var state_11669__$1 = state_11669;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11669__$1,inst_11667);
} else {
if((state_val_11670 === (4))){
var inst_11659 = (state_11669[(2)]);
var inst_11660 = process(inst_11659);
var state_11669__$1 = state_11669;
if(cljs.core.truth_(inst_11660)){
var statearr_11672_11824 = state_11669__$1;
(statearr_11672_11824[(1)] = (5));

} else {
var statearr_11673_11825 = state_11669__$1;
(statearr_11673_11825[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11670 === (5))){
var state_11669__$1 = state_11669;
var statearr_11674_11826 = state_11669__$1;
(statearr_11674_11826[(2)] = null);

(statearr_11674_11826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11670 === (6))){
var state_11669__$1 = state_11669;
var statearr_11675_11827 = state_11669__$1;
(statearr_11675_11827[(2)] = null);

(statearr_11675_11827[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11670 === (7))){
var inst_11665 = (state_11669[(2)]);
var state_11669__$1 = state_11669;
var statearr_11676_11828 = state_11669__$1;
(statearr_11676_11828[(2)] = inst_11665);

(statearr_11676_11828[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11818,c__11470__auto___11822,G__11656_11819,G__11656_11820__$1,n__4741__auto___11817,jobs,results,process,async))
;
return ((function (__11818,switch__11395__auto__,c__11470__auto___11822,G__11656_11819,G__11656_11820__$1,n__4741__auto___11817,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0 = (function (){
var statearr_11677 = [null,null,null,null,null,null,null];
(statearr_11677[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__);

(statearr_11677[(1)] = (1));

return statearr_11677;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1 = (function (state_11669){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_11669);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e11678){var ex__11399__auto__ = e11678;
var statearr_11679_11829 = state_11669;
(statearr_11679_11829[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_11669[(4)]))){
var statearr_11680_11830 = state_11669;
(statearr_11680_11830[(1)] = cljs.core.first((state_11669[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11831 = state_11669;
state_11669 = G__11831;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__ = function(state_11669){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1.call(this,state_11669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__;
})()
;})(__11818,switch__11395__auto__,c__11470__auto___11822,G__11656_11819,G__11656_11820__$1,n__4741__auto___11817,jobs,results,process,async))
})();
var state__11472__auto__ = (function (){var statearr_11681 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_11681[(6)] = c__11470__auto___11822);

return statearr_11681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
});})(__11818,c__11470__auto___11822,G__11656_11819,G__11656_11820__$1,n__4741__auto___11817,jobs,results,process,async))
);


break;
case "async":
var c__11470__auto___11832 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__11818,c__11470__auto___11832,G__11656_11819,G__11656_11820__$1,n__4741__auto___11817,jobs,results,process,async){
return (function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = ((function (__11818,c__11470__auto___11832,G__11656_11819,G__11656_11820__$1,n__4741__auto___11817,jobs,results,process,async){
return (function (state_11694){
var state_val_11695 = (state_11694[(1)]);
if((state_val_11695 === (1))){
var state_11694__$1 = state_11694;
var statearr_11696_11833 = state_11694__$1;
(statearr_11696_11833[(2)] = null);

(statearr_11696_11833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11695 === (2))){
var state_11694__$1 = state_11694;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11694__$1,(4),jobs);
} else {
if((state_val_11695 === (3))){
var inst_11692 = (state_11694[(2)]);
var state_11694__$1 = state_11694;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11694__$1,inst_11692);
} else {
if((state_val_11695 === (4))){
var inst_11684 = (state_11694[(2)]);
var inst_11685 = async(inst_11684);
var state_11694__$1 = state_11694;
if(cljs.core.truth_(inst_11685)){
var statearr_11697_11834 = state_11694__$1;
(statearr_11697_11834[(1)] = (5));

} else {
var statearr_11698_11835 = state_11694__$1;
(statearr_11698_11835[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11695 === (5))){
var state_11694__$1 = state_11694;
var statearr_11699_11836 = state_11694__$1;
(statearr_11699_11836[(2)] = null);

(statearr_11699_11836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11695 === (6))){
var state_11694__$1 = state_11694;
var statearr_11700_11837 = state_11694__$1;
(statearr_11700_11837[(2)] = null);

(statearr_11700_11837[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11695 === (7))){
var inst_11690 = (state_11694[(2)]);
var state_11694__$1 = state_11694;
var statearr_11701_11838 = state_11694__$1;
(statearr_11701_11838[(2)] = inst_11690);

(statearr_11701_11838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11818,c__11470__auto___11832,G__11656_11819,G__11656_11820__$1,n__4741__auto___11817,jobs,results,process,async))
;
return ((function (__11818,switch__11395__auto__,c__11470__auto___11832,G__11656_11819,G__11656_11820__$1,n__4741__auto___11817,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0 = (function (){
var statearr_11702 = [null,null,null,null,null,null,null];
(statearr_11702[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__);

(statearr_11702[(1)] = (1));

return statearr_11702;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1 = (function (state_11694){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_11694);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e11703){var ex__11399__auto__ = e11703;
var statearr_11704_11839 = state_11694;
(statearr_11704_11839[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_11694[(4)]))){
var statearr_11705_11840 = state_11694;
(statearr_11705_11840[(1)] = cljs.core.first((state_11694[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11841 = state_11694;
state_11694 = G__11841;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__ = function(state_11694){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1.call(this,state_11694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__;
})()
;})(__11818,switch__11395__auto__,c__11470__auto___11832,G__11656_11819,G__11656_11820__$1,n__4741__auto___11817,jobs,results,process,async))
})();
var state__11472__auto__ = (function (){var statearr_11706 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_11706[(6)] = c__11470__auto___11832);

return statearr_11706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
});})(__11818,c__11470__auto___11832,G__11656_11819,G__11656_11820__$1,n__4741__auto___11817,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11656_11820__$1)].join('')));

}

var G__11842 = (__11818 + (1));
__11818 = G__11842;
continue;
} else {
}
break;
}

var c__11470__auto___11843 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_11728){
var state_val_11729 = (state_11728[(1)]);
if((state_val_11729 === (7))){
var inst_11724 = (state_11728[(2)]);
var state_11728__$1 = state_11728;
var statearr_11730_11844 = state_11728__$1;
(statearr_11730_11844[(2)] = inst_11724);

(statearr_11730_11844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11729 === (1))){
var state_11728__$1 = state_11728;
var statearr_11731_11845 = state_11728__$1;
(statearr_11731_11845[(2)] = null);

(statearr_11731_11845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11729 === (4))){
var inst_11709 = (state_11728[(7)]);
var inst_11709__$1 = (state_11728[(2)]);
var inst_11710 = (inst_11709__$1 == null);
var state_11728__$1 = (function (){var statearr_11732 = state_11728;
(statearr_11732[(7)] = inst_11709__$1);

return statearr_11732;
})();
if(cljs.core.truth_(inst_11710)){
var statearr_11733_11846 = state_11728__$1;
(statearr_11733_11846[(1)] = (5));

} else {
var statearr_11734_11847 = state_11728__$1;
(statearr_11734_11847[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11729 === (6))){
var inst_11714 = (state_11728[(8)]);
var inst_11709 = (state_11728[(7)]);
var inst_11714__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_11715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11716 = [inst_11709,inst_11714__$1];
var inst_11717 = (new cljs.core.PersistentVector(null,2,(5),inst_11715,inst_11716,null));
var state_11728__$1 = (function (){var statearr_11735 = state_11728;
(statearr_11735[(8)] = inst_11714__$1);

return statearr_11735;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11728__$1,(8),jobs,inst_11717);
} else {
if((state_val_11729 === (3))){
var inst_11726 = (state_11728[(2)]);
var state_11728__$1 = state_11728;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11728__$1,inst_11726);
} else {
if((state_val_11729 === (2))){
var state_11728__$1 = state_11728;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11728__$1,(4),from);
} else {
if((state_val_11729 === (9))){
var inst_11721 = (state_11728[(2)]);
var state_11728__$1 = (function (){var statearr_11736 = state_11728;
(statearr_11736[(9)] = inst_11721);

return statearr_11736;
})();
var statearr_11737_11848 = state_11728__$1;
(statearr_11737_11848[(2)] = null);

(statearr_11737_11848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11729 === (5))){
var inst_11712 = cljs.core.async.close_BANG_(jobs);
var state_11728__$1 = state_11728;
var statearr_11738_11849 = state_11728__$1;
(statearr_11738_11849[(2)] = inst_11712);

(statearr_11738_11849[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11729 === (8))){
var inst_11714 = (state_11728[(8)]);
var inst_11719 = (state_11728[(2)]);
var state_11728__$1 = (function (){var statearr_11739 = state_11728;
(statearr_11739[(10)] = inst_11719);

return statearr_11739;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11728__$1,(9),results,inst_11714);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0 = (function (){
var statearr_11740 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11740[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__);

(statearr_11740[(1)] = (1));

return statearr_11740;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1 = (function (state_11728){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_11728);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e11741){var ex__11399__auto__ = e11741;
var statearr_11742_11850 = state_11728;
(statearr_11742_11850[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_11728[(4)]))){
var statearr_11743_11851 = state_11728;
(statearr_11743_11851[(1)] = cljs.core.first((state_11728[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11852 = state_11728;
state_11728 = G__11852;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__ = function(state_11728){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1.call(this,state_11728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_11744 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_11744[(6)] = c__11470__auto___11843);

return statearr_11744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));


var c__11470__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_11782){
var state_val_11783 = (state_11782[(1)]);
if((state_val_11783 === (7))){
var inst_11778 = (state_11782[(2)]);
var state_11782__$1 = state_11782;
var statearr_11784_11853 = state_11782__$1;
(statearr_11784_11853[(2)] = inst_11778);

(statearr_11784_11853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (20))){
var state_11782__$1 = state_11782;
var statearr_11785_11854 = state_11782__$1;
(statearr_11785_11854[(2)] = null);

(statearr_11785_11854[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (1))){
var state_11782__$1 = state_11782;
var statearr_11786_11855 = state_11782__$1;
(statearr_11786_11855[(2)] = null);

(statearr_11786_11855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (4))){
var inst_11747 = (state_11782[(7)]);
var inst_11747__$1 = (state_11782[(2)]);
var inst_11748 = (inst_11747__$1 == null);
var state_11782__$1 = (function (){var statearr_11787 = state_11782;
(statearr_11787[(7)] = inst_11747__$1);

return statearr_11787;
})();
if(cljs.core.truth_(inst_11748)){
var statearr_11788_11856 = state_11782__$1;
(statearr_11788_11856[(1)] = (5));

} else {
var statearr_11789_11857 = state_11782__$1;
(statearr_11789_11857[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (15))){
var inst_11760 = (state_11782[(8)]);
var state_11782__$1 = state_11782;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11782__$1,(18),to,inst_11760);
} else {
if((state_val_11783 === (21))){
var inst_11773 = (state_11782[(2)]);
var state_11782__$1 = state_11782;
var statearr_11790_11858 = state_11782__$1;
(statearr_11790_11858[(2)] = inst_11773);

(statearr_11790_11858[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (13))){
var inst_11775 = (state_11782[(2)]);
var state_11782__$1 = (function (){var statearr_11791 = state_11782;
(statearr_11791[(9)] = inst_11775);

return statearr_11791;
})();
var statearr_11792_11859 = state_11782__$1;
(statearr_11792_11859[(2)] = null);

(statearr_11792_11859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (6))){
var inst_11747 = (state_11782[(7)]);
var state_11782__$1 = state_11782;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11782__$1,(11),inst_11747);
} else {
if((state_val_11783 === (17))){
var inst_11768 = (state_11782[(2)]);
var state_11782__$1 = state_11782;
if(cljs.core.truth_(inst_11768)){
var statearr_11793_11860 = state_11782__$1;
(statearr_11793_11860[(1)] = (19));

} else {
var statearr_11794_11861 = state_11782__$1;
(statearr_11794_11861[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (3))){
var inst_11780 = (state_11782[(2)]);
var state_11782__$1 = state_11782;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11782__$1,inst_11780);
} else {
if((state_val_11783 === (12))){
var inst_11757 = (state_11782[(10)]);
var state_11782__$1 = state_11782;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11782__$1,(14),inst_11757);
} else {
if((state_val_11783 === (2))){
var state_11782__$1 = state_11782;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11782__$1,(4),results);
} else {
if((state_val_11783 === (19))){
var state_11782__$1 = state_11782;
var statearr_11795_11862 = state_11782__$1;
(statearr_11795_11862[(2)] = null);

(statearr_11795_11862[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (11))){
var inst_11757 = (state_11782[(2)]);
var state_11782__$1 = (function (){var statearr_11796 = state_11782;
(statearr_11796[(10)] = inst_11757);

return statearr_11796;
})();
var statearr_11797_11863 = state_11782__$1;
(statearr_11797_11863[(2)] = null);

(statearr_11797_11863[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (9))){
var state_11782__$1 = state_11782;
var statearr_11798_11864 = state_11782__$1;
(statearr_11798_11864[(2)] = null);

(statearr_11798_11864[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (5))){
var state_11782__$1 = state_11782;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11799_11865 = state_11782__$1;
(statearr_11799_11865[(1)] = (8));

} else {
var statearr_11800_11866 = state_11782__$1;
(statearr_11800_11866[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (14))){
var inst_11762 = (state_11782[(11)]);
var inst_11760 = (state_11782[(8)]);
var inst_11760__$1 = (state_11782[(2)]);
var inst_11761 = (inst_11760__$1 == null);
var inst_11762__$1 = cljs.core.not(inst_11761);
var state_11782__$1 = (function (){var statearr_11801 = state_11782;
(statearr_11801[(11)] = inst_11762__$1);

(statearr_11801[(8)] = inst_11760__$1);

return statearr_11801;
})();
if(inst_11762__$1){
var statearr_11802_11867 = state_11782__$1;
(statearr_11802_11867[(1)] = (15));

} else {
var statearr_11803_11868 = state_11782__$1;
(statearr_11803_11868[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (16))){
var inst_11762 = (state_11782[(11)]);
var state_11782__$1 = state_11782;
var statearr_11804_11869 = state_11782__$1;
(statearr_11804_11869[(2)] = inst_11762);

(statearr_11804_11869[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (10))){
var inst_11754 = (state_11782[(2)]);
var state_11782__$1 = state_11782;
var statearr_11805_11870 = state_11782__$1;
(statearr_11805_11870[(2)] = inst_11754);

(statearr_11805_11870[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (18))){
var inst_11765 = (state_11782[(2)]);
var state_11782__$1 = state_11782;
var statearr_11806_11871 = state_11782__$1;
(statearr_11806_11871[(2)] = inst_11765);

(statearr_11806_11871[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11783 === (8))){
var inst_11751 = cljs.core.async.close_BANG_(to);
var state_11782__$1 = state_11782;
var statearr_11807_11872 = state_11782__$1;
(statearr_11807_11872[(2)] = inst_11751);

(statearr_11807_11872[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0 = (function (){
var statearr_11808 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11808[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__);

(statearr_11808[(1)] = (1));

return statearr_11808;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1 = (function (state_11782){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_11782);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e11809){var ex__11399__auto__ = e11809;
var statearr_11810_11873 = state_11782;
(statearr_11810_11873[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_11782[(4)]))){
var statearr_11811_11874 = state_11782;
(statearr_11811_11874[(1)] = cljs.core.first((state_11782[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11875 = state_11782;
state_11782 = G__11875;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__ = function(state_11782){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1.call(this,state_11782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11396__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_11812 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_11812[(6)] = c__11470__auto__);

return statearr_11812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));

return c__11470__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__11877 = arguments.length;
switch (G__11877) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__11880 = arguments.length;
switch (G__11880) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__11883 = arguments.length;
switch (G__11883) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__11470__auto___11933 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_11909){
var state_val_11910 = (state_11909[(1)]);
if((state_val_11910 === (7))){
var inst_11905 = (state_11909[(2)]);
var state_11909__$1 = state_11909;
var statearr_11911_11934 = state_11909__$1;
(statearr_11911_11934[(2)] = inst_11905);

(statearr_11911_11934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (1))){
var state_11909__$1 = state_11909;
var statearr_11912_11935 = state_11909__$1;
(statearr_11912_11935[(2)] = null);

(statearr_11912_11935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (4))){
var inst_11886 = (state_11909[(7)]);
var inst_11886__$1 = (state_11909[(2)]);
var inst_11887 = (inst_11886__$1 == null);
var state_11909__$1 = (function (){var statearr_11913 = state_11909;
(statearr_11913[(7)] = inst_11886__$1);

return statearr_11913;
})();
if(cljs.core.truth_(inst_11887)){
var statearr_11914_11936 = state_11909__$1;
(statearr_11914_11936[(1)] = (5));

} else {
var statearr_11915_11937 = state_11909__$1;
(statearr_11915_11937[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (13))){
var state_11909__$1 = state_11909;
var statearr_11916_11938 = state_11909__$1;
(statearr_11916_11938[(2)] = null);

(statearr_11916_11938[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (6))){
var inst_11886 = (state_11909[(7)]);
var inst_11892 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_11886) : p.call(null,inst_11886));
var state_11909__$1 = state_11909;
if(cljs.core.truth_(inst_11892)){
var statearr_11917_11939 = state_11909__$1;
(statearr_11917_11939[(1)] = (9));

} else {
var statearr_11918_11940 = state_11909__$1;
(statearr_11918_11940[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (3))){
var inst_11907 = (state_11909[(2)]);
var state_11909__$1 = state_11909;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11909__$1,inst_11907);
} else {
if((state_val_11910 === (12))){
var state_11909__$1 = state_11909;
var statearr_11919_11941 = state_11909__$1;
(statearr_11919_11941[(2)] = null);

(statearr_11919_11941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (2))){
var state_11909__$1 = state_11909;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11909__$1,(4),ch);
} else {
if((state_val_11910 === (11))){
var inst_11886 = (state_11909[(7)]);
var inst_11896 = (state_11909[(2)]);
var state_11909__$1 = state_11909;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11909__$1,(8),inst_11896,inst_11886);
} else {
if((state_val_11910 === (9))){
var state_11909__$1 = state_11909;
var statearr_11920_11942 = state_11909__$1;
(statearr_11920_11942[(2)] = tc);

(statearr_11920_11942[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (5))){
var inst_11889 = cljs.core.async.close_BANG_(tc);
var inst_11890 = cljs.core.async.close_BANG_(fc);
var state_11909__$1 = (function (){var statearr_11921 = state_11909;
(statearr_11921[(8)] = inst_11889);

return statearr_11921;
})();
var statearr_11922_11943 = state_11909__$1;
(statearr_11922_11943[(2)] = inst_11890);

(statearr_11922_11943[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (14))){
var inst_11903 = (state_11909[(2)]);
var state_11909__$1 = state_11909;
var statearr_11923_11944 = state_11909__$1;
(statearr_11923_11944[(2)] = inst_11903);

(statearr_11923_11944[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (10))){
var state_11909__$1 = state_11909;
var statearr_11924_11945 = state_11909__$1;
(statearr_11924_11945[(2)] = fc);

(statearr_11924_11945[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11910 === (8))){
var inst_11898 = (state_11909[(2)]);
var state_11909__$1 = state_11909;
if(cljs.core.truth_(inst_11898)){
var statearr_11925_11946 = state_11909__$1;
(statearr_11925_11946[(1)] = (12));

} else {
var statearr_11926_11947 = state_11909__$1;
(statearr_11926_11947[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11396__auto__ = null;
var cljs$core$async$state_machine__11396__auto____0 = (function (){
var statearr_11927 = [null,null,null,null,null,null,null,null,null];
(statearr_11927[(0)] = cljs$core$async$state_machine__11396__auto__);

(statearr_11927[(1)] = (1));

return statearr_11927;
});
var cljs$core$async$state_machine__11396__auto____1 = (function (state_11909){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_11909);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e11928){var ex__11399__auto__ = e11928;
var statearr_11929_11948 = state_11909;
(statearr_11929_11948[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_11909[(4)]))){
var statearr_11930_11949 = state_11909;
(statearr_11930_11949[(1)] = cljs.core.first((state_11909[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11950 = state_11909;
state_11909 = G__11950;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$state_machine__11396__auto__ = function(state_11909){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11396__auto____1.call(this,state_11909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11396__auto____0;
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11396__auto____1;
return cljs$core$async$state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_11931 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_11931[(6)] = c__11470__auto___11933);

return statearr_11931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11470__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_11972){
var state_val_11973 = (state_11972[(1)]);
if((state_val_11973 === (7))){
var inst_11968 = (state_11972[(2)]);
var state_11972__$1 = state_11972;
var statearr_11974_11993 = state_11972__$1;
(statearr_11974_11993[(2)] = inst_11968);

(statearr_11974_11993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11973 === (1))){
var inst_11951 = init;
var inst_11952 = inst_11951;
var state_11972__$1 = (function (){var statearr_11975 = state_11972;
(statearr_11975[(7)] = inst_11952);

return statearr_11975;
})();
var statearr_11976_11994 = state_11972__$1;
(statearr_11976_11994[(2)] = null);

(statearr_11976_11994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11973 === (4))){
var inst_11955 = (state_11972[(8)]);
var inst_11955__$1 = (state_11972[(2)]);
var inst_11956 = (inst_11955__$1 == null);
var state_11972__$1 = (function (){var statearr_11977 = state_11972;
(statearr_11977[(8)] = inst_11955__$1);

return statearr_11977;
})();
if(cljs.core.truth_(inst_11956)){
var statearr_11978_11995 = state_11972__$1;
(statearr_11978_11995[(1)] = (5));

} else {
var statearr_11979_11996 = state_11972__$1;
(statearr_11979_11996[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11973 === (6))){
var inst_11952 = (state_11972[(7)]);
var inst_11959 = (state_11972[(9)]);
var inst_11955 = (state_11972[(8)]);
var inst_11959__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_11952,inst_11955) : f.call(null,inst_11952,inst_11955));
var inst_11960 = cljs.core.reduced_QMARK_(inst_11959__$1);
var state_11972__$1 = (function (){var statearr_11980 = state_11972;
(statearr_11980[(9)] = inst_11959__$1);

return statearr_11980;
})();
if(inst_11960){
var statearr_11981_11997 = state_11972__$1;
(statearr_11981_11997[(1)] = (8));

} else {
var statearr_11982_11998 = state_11972__$1;
(statearr_11982_11998[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11973 === (3))){
var inst_11970 = (state_11972[(2)]);
var state_11972__$1 = state_11972;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11972__$1,inst_11970);
} else {
if((state_val_11973 === (2))){
var state_11972__$1 = state_11972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11972__$1,(4),ch);
} else {
if((state_val_11973 === (9))){
var inst_11959 = (state_11972[(9)]);
var inst_11952 = inst_11959;
var state_11972__$1 = (function (){var statearr_11983 = state_11972;
(statearr_11983[(7)] = inst_11952);

return statearr_11983;
})();
var statearr_11984_11999 = state_11972__$1;
(statearr_11984_11999[(2)] = null);

(statearr_11984_11999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11973 === (5))){
var inst_11952 = (state_11972[(7)]);
var state_11972__$1 = state_11972;
var statearr_11985_12000 = state_11972__$1;
(statearr_11985_12000[(2)] = inst_11952);

(statearr_11985_12000[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11973 === (10))){
var inst_11966 = (state_11972[(2)]);
var state_11972__$1 = state_11972;
var statearr_11986_12001 = state_11972__$1;
(statearr_11986_12001[(2)] = inst_11966);

(statearr_11986_12001[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11973 === (8))){
var inst_11959 = (state_11972[(9)]);
var inst_11962 = cljs.core.deref(inst_11959);
var state_11972__$1 = state_11972;
var statearr_11987_12002 = state_11972__$1;
(statearr_11987_12002[(2)] = inst_11962);

(statearr_11987_12002[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__11396__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11396__auto____0 = (function (){
var statearr_11988 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11988[(0)] = cljs$core$async$reduce_$_state_machine__11396__auto__);

(statearr_11988[(1)] = (1));

return statearr_11988;
});
var cljs$core$async$reduce_$_state_machine__11396__auto____1 = (function (state_11972){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_11972);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e11989){var ex__11399__auto__ = e11989;
var statearr_11990_12003 = state_11972;
(statearr_11990_12003[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_11972[(4)]))){
var statearr_11991_12004 = state_11972;
(statearr_11991_12004[(1)] = cljs.core.first((state_11972[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12005 = state_11972;
state_11972 = G__12005;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11396__auto__ = function(state_11972){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11396__auto____1.call(this,state_11972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11396__auto____0;
cljs$core$async$reduce_$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11396__auto____1;
return cljs$core$async$reduce_$_state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_11992 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_11992[(6)] = c__11470__auto__);

return statearr_11992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));

return c__11470__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__11470__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_12011){
var state_val_12012 = (state_12011[(1)]);
if((state_val_12012 === (1))){
var inst_12006 = cljs.core.async.reduce(f__$1,init,ch);
var state_12011__$1 = state_12011;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12011__$1,(2),inst_12006);
} else {
if((state_val_12012 === (2))){
var inst_12008 = (state_12011[(2)]);
var inst_12009 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_12008) : f__$1.call(null,inst_12008));
var state_12011__$1 = state_12011;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12011__$1,inst_12009);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__11396__auto__ = null;
var cljs$core$async$transduce_$_state_machine__11396__auto____0 = (function (){
var statearr_12013 = [null,null,null,null,null,null,null];
(statearr_12013[(0)] = cljs$core$async$transduce_$_state_machine__11396__auto__);

(statearr_12013[(1)] = (1));

return statearr_12013;
});
var cljs$core$async$transduce_$_state_machine__11396__auto____1 = (function (state_12011){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_12011);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e12014){var ex__11399__auto__ = e12014;
var statearr_12015_12018 = state_12011;
(statearr_12015_12018[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_12011[(4)]))){
var statearr_12016_12019 = state_12011;
(statearr_12016_12019[(1)] = cljs.core.first((state_12011[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12020 = state_12011;
state_12011 = G__12020;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__11396__auto__ = function(state_12011){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__11396__auto____1.call(this,state_12011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__11396__auto____0;
cljs$core$async$transduce_$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__11396__auto____1;
return cljs$core$async$transduce_$_state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_12017 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_12017[(6)] = c__11470__auto__);

return statearr_12017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));

return c__11470__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__12022 = arguments.length;
switch (G__12022) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11470__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_12047){
var state_val_12048 = (state_12047[(1)]);
if((state_val_12048 === (7))){
var inst_12029 = (state_12047[(2)]);
var state_12047__$1 = state_12047;
var statearr_12049_12071 = state_12047__$1;
(statearr_12049_12071[(2)] = inst_12029);

(statearr_12049_12071[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12048 === (1))){
var inst_12023 = cljs.core.seq(coll);
var inst_12024 = inst_12023;
var state_12047__$1 = (function (){var statearr_12050 = state_12047;
(statearr_12050[(7)] = inst_12024);

return statearr_12050;
})();
var statearr_12051_12072 = state_12047__$1;
(statearr_12051_12072[(2)] = null);

(statearr_12051_12072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12048 === (4))){
var inst_12024 = (state_12047[(7)]);
var inst_12027 = cljs.core.first(inst_12024);
var state_12047__$1 = state_12047;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12047__$1,(7),ch,inst_12027);
} else {
if((state_val_12048 === (13))){
var inst_12041 = (state_12047[(2)]);
var state_12047__$1 = state_12047;
var statearr_12052_12073 = state_12047__$1;
(statearr_12052_12073[(2)] = inst_12041);

(statearr_12052_12073[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12048 === (6))){
var inst_12032 = (state_12047[(2)]);
var state_12047__$1 = state_12047;
if(cljs.core.truth_(inst_12032)){
var statearr_12053_12074 = state_12047__$1;
(statearr_12053_12074[(1)] = (8));

} else {
var statearr_12054_12075 = state_12047__$1;
(statearr_12054_12075[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12048 === (3))){
var inst_12045 = (state_12047[(2)]);
var state_12047__$1 = state_12047;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12047__$1,inst_12045);
} else {
if((state_val_12048 === (12))){
var state_12047__$1 = state_12047;
var statearr_12055_12076 = state_12047__$1;
(statearr_12055_12076[(2)] = null);

(statearr_12055_12076[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12048 === (2))){
var inst_12024 = (state_12047[(7)]);
var state_12047__$1 = state_12047;
if(cljs.core.truth_(inst_12024)){
var statearr_12056_12077 = state_12047__$1;
(statearr_12056_12077[(1)] = (4));

} else {
var statearr_12057_12078 = state_12047__$1;
(statearr_12057_12078[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12048 === (11))){
var inst_12038 = cljs.core.async.close_BANG_(ch);
var state_12047__$1 = state_12047;
var statearr_12058_12079 = state_12047__$1;
(statearr_12058_12079[(2)] = inst_12038);

(statearr_12058_12079[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12048 === (9))){
var state_12047__$1 = state_12047;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12059_12080 = state_12047__$1;
(statearr_12059_12080[(1)] = (11));

} else {
var statearr_12060_12081 = state_12047__$1;
(statearr_12060_12081[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12048 === (5))){
var inst_12024 = (state_12047[(7)]);
var state_12047__$1 = state_12047;
var statearr_12061_12082 = state_12047__$1;
(statearr_12061_12082[(2)] = inst_12024);

(statearr_12061_12082[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12048 === (10))){
var inst_12043 = (state_12047[(2)]);
var state_12047__$1 = state_12047;
var statearr_12062_12083 = state_12047__$1;
(statearr_12062_12083[(2)] = inst_12043);

(statearr_12062_12083[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12048 === (8))){
var inst_12024 = (state_12047[(7)]);
var inst_12034 = cljs.core.next(inst_12024);
var inst_12024__$1 = inst_12034;
var state_12047__$1 = (function (){var statearr_12063 = state_12047;
(statearr_12063[(7)] = inst_12024__$1);

return statearr_12063;
})();
var statearr_12064_12084 = state_12047__$1;
(statearr_12064_12084[(2)] = null);

(statearr_12064_12084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11396__auto__ = null;
var cljs$core$async$state_machine__11396__auto____0 = (function (){
var statearr_12065 = [null,null,null,null,null,null,null,null];
(statearr_12065[(0)] = cljs$core$async$state_machine__11396__auto__);

(statearr_12065[(1)] = (1));

return statearr_12065;
});
var cljs$core$async$state_machine__11396__auto____1 = (function (state_12047){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_12047);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e12066){var ex__11399__auto__ = e12066;
var statearr_12067_12085 = state_12047;
(statearr_12067_12085[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_12047[(4)]))){
var statearr_12068_12086 = state_12047;
(statearr_12068_12086[(1)] = cljs.core.first((state_12047[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12087 = state_12047;
state_12047 = G__12087;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$state_machine__11396__auto__ = function(state_12047){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11396__auto____1.call(this,state_12047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11396__auto____0;
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11396__auto____1;
return cljs$core$async$state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_12069 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_12069[(6)] = c__11470__auto__);

return statearr_12069;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));

return c__11470__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__12089 = arguments.length;
switch (G__12089) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_12091 = (function (_){
var x__4550__auto__ = (((_ == null))?null:_);
var m__4551__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4551__auto__.call(null,_));
} else {
var m__4549__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4549__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_12091(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_12092 = (function (m,ch,close_QMARK_){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4551__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4549__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_12092(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_12093 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_12093(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_12094 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_12094(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12095 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12095 = (function (ch,cs,meta12096){
this.ch = ch;
this.cs = cs;
this.meta12096 = meta12096;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12095.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12097,meta12096__$1){
var self__ = this;
var _12097__$1 = this;
return (new cljs.core.async.t_cljs$core$async12095(self__.ch,self__.cs,meta12096__$1));
}));

(cljs.core.async.t_cljs$core$async12095.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12097){
var self__ = this;
var _12097__$1 = this;
return self__.meta12096;
}));

(cljs.core.async.t_cljs$core$async12095.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12095.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12095.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12095.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async12095.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async12095.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async12095.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12096","meta12096",-734138274,null)], null);
}));

(cljs.core.async.t_cljs$core$async12095.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12095.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12095");

(cljs.core.async.t_cljs$core$async12095.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async12095");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12095.
 */
cljs.core.async.__GT_t_cljs$core$async12095 = (function cljs$core$async$mult_$___GT_t_cljs$core$async12095(ch__$1,cs__$1,meta12096){
return (new cljs.core.async.t_cljs$core$async12095(ch__$1,cs__$1,meta12096));
});

}

return (new cljs.core.async.t_cljs$core$async12095(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__11470__auto___12314 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_12230){
var state_val_12231 = (state_12230[(1)]);
if((state_val_12231 === (7))){
var inst_12226 = (state_12230[(2)]);
var state_12230__$1 = state_12230;
var statearr_12232_12315 = state_12230__$1;
(statearr_12232_12315[(2)] = inst_12226);

(statearr_12232_12315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (20))){
var inst_12131 = (state_12230[(7)]);
var inst_12143 = cljs.core.first(inst_12131);
var inst_12144 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12143,(0),null);
var inst_12145 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12143,(1),null);
var state_12230__$1 = (function (){var statearr_12233 = state_12230;
(statearr_12233[(8)] = inst_12144);

return statearr_12233;
})();
if(cljs.core.truth_(inst_12145)){
var statearr_12234_12316 = state_12230__$1;
(statearr_12234_12316[(1)] = (22));

} else {
var statearr_12235_12317 = state_12230__$1;
(statearr_12235_12317[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (27))){
var inst_12173 = (state_12230[(9)]);
var inst_12100 = (state_12230[(10)]);
var inst_12175 = (state_12230[(11)]);
var inst_12180 = (state_12230[(12)]);
var inst_12180__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12173,inst_12175);
var inst_12181 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_12180__$1,inst_12100,done);
var state_12230__$1 = (function (){var statearr_12236 = state_12230;
(statearr_12236[(12)] = inst_12180__$1);

return statearr_12236;
})();
if(cljs.core.truth_(inst_12181)){
var statearr_12237_12318 = state_12230__$1;
(statearr_12237_12318[(1)] = (30));

} else {
var statearr_12238_12319 = state_12230__$1;
(statearr_12238_12319[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (1))){
var state_12230__$1 = state_12230;
var statearr_12239_12320 = state_12230__$1;
(statearr_12239_12320[(2)] = null);

(statearr_12239_12320[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (24))){
var inst_12131 = (state_12230[(7)]);
var inst_12150 = (state_12230[(2)]);
var inst_12151 = cljs.core.next(inst_12131);
var inst_12109 = inst_12151;
var inst_12110 = null;
var inst_12111 = (0);
var inst_12112 = (0);
var state_12230__$1 = (function (){var statearr_12240 = state_12230;
(statearr_12240[(13)] = inst_12110);

(statearr_12240[(14)] = inst_12111);

(statearr_12240[(15)] = inst_12112);

(statearr_12240[(16)] = inst_12150);

(statearr_12240[(17)] = inst_12109);

return statearr_12240;
})();
var statearr_12241_12321 = state_12230__$1;
(statearr_12241_12321[(2)] = null);

(statearr_12241_12321[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (39))){
var state_12230__$1 = state_12230;
var statearr_12245_12322 = state_12230__$1;
(statearr_12245_12322[(2)] = null);

(statearr_12245_12322[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (4))){
var inst_12100 = (state_12230[(10)]);
var inst_12100__$1 = (state_12230[(2)]);
var inst_12101 = (inst_12100__$1 == null);
var state_12230__$1 = (function (){var statearr_12246 = state_12230;
(statearr_12246[(10)] = inst_12100__$1);

return statearr_12246;
})();
if(cljs.core.truth_(inst_12101)){
var statearr_12247_12323 = state_12230__$1;
(statearr_12247_12323[(1)] = (5));

} else {
var statearr_12248_12324 = state_12230__$1;
(statearr_12248_12324[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (15))){
var inst_12110 = (state_12230[(13)]);
var inst_12111 = (state_12230[(14)]);
var inst_12112 = (state_12230[(15)]);
var inst_12109 = (state_12230[(17)]);
var inst_12127 = (state_12230[(2)]);
var inst_12128 = (inst_12112 + (1));
var tmp12242 = inst_12110;
var tmp12243 = inst_12111;
var tmp12244 = inst_12109;
var inst_12109__$1 = tmp12244;
var inst_12110__$1 = tmp12242;
var inst_12111__$1 = tmp12243;
var inst_12112__$1 = inst_12128;
var state_12230__$1 = (function (){var statearr_12249 = state_12230;
(statearr_12249[(13)] = inst_12110__$1);

(statearr_12249[(14)] = inst_12111__$1);

(statearr_12249[(15)] = inst_12112__$1);

(statearr_12249[(17)] = inst_12109__$1);

(statearr_12249[(18)] = inst_12127);

return statearr_12249;
})();
var statearr_12250_12325 = state_12230__$1;
(statearr_12250_12325[(2)] = null);

(statearr_12250_12325[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (21))){
var inst_12154 = (state_12230[(2)]);
var state_12230__$1 = state_12230;
var statearr_12254_12326 = state_12230__$1;
(statearr_12254_12326[(2)] = inst_12154);

(statearr_12254_12326[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (31))){
var inst_12180 = (state_12230[(12)]);
var inst_12184 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_12180);
var state_12230__$1 = state_12230;
var statearr_12255_12327 = state_12230__$1;
(statearr_12255_12327[(2)] = inst_12184);

(statearr_12255_12327[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (32))){
var inst_12173 = (state_12230[(9)]);
var inst_12174 = (state_12230[(19)]);
var inst_12172 = (state_12230[(20)]);
var inst_12175 = (state_12230[(11)]);
var inst_12186 = (state_12230[(2)]);
var inst_12187 = (inst_12175 + (1));
var tmp12251 = inst_12173;
var tmp12252 = inst_12174;
var tmp12253 = inst_12172;
var inst_12172__$1 = tmp12253;
var inst_12173__$1 = tmp12251;
var inst_12174__$1 = tmp12252;
var inst_12175__$1 = inst_12187;
var state_12230__$1 = (function (){var statearr_12256 = state_12230;
(statearr_12256[(21)] = inst_12186);

(statearr_12256[(9)] = inst_12173__$1);

(statearr_12256[(19)] = inst_12174__$1);

(statearr_12256[(20)] = inst_12172__$1);

(statearr_12256[(11)] = inst_12175__$1);

return statearr_12256;
})();
var statearr_12257_12328 = state_12230__$1;
(statearr_12257_12328[(2)] = null);

(statearr_12257_12328[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (40))){
var inst_12199 = (state_12230[(22)]);
var inst_12203 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_12199);
var state_12230__$1 = state_12230;
var statearr_12258_12329 = state_12230__$1;
(statearr_12258_12329[(2)] = inst_12203);

(statearr_12258_12329[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (33))){
var inst_12190 = (state_12230[(23)]);
var inst_12192 = cljs.core.chunked_seq_QMARK_(inst_12190);
var state_12230__$1 = state_12230;
if(inst_12192){
var statearr_12259_12330 = state_12230__$1;
(statearr_12259_12330[(1)] = (36));

} else {
var statearr_12260_12331 = state_12230__$1;
(statearr_12260_12331[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (13))){
var inst_12121 = (state_12230[(24)]);
var inst_12124 = cljs.core.async.close_BANG_(inst_12121);
var state_12230__$1 = state_12230;
var statearr_12261_12332 = state_12230__$1;
(statearr_12261_12332[(2)] = inst_12124);

(statearr_12261_12332[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (22))){
var inst_12144 = (state_12230[(8)]);
var inst_12147 = cljs.core.async.close_BANG_(inst_12144);
var state_12230__$1 = state_12230;
var statearr_12262_12333 = state_12230__$1;
(statearr_12262_12333[(2)] = inst_12147);

(statearr_12262_12333[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (36))){
var inst_12190 = (state_12230[(23)]);
var inst_12194 = cljs.core.chunk_first(inst_12190);
var inst_12195 = cljs.core.chunk_rest(inst_12190);
var inst_12196 = cljs.core.count(inst_12194);
var inst_12172 = inst_12195;
var inst_12173 = inst_12194;
var inst_12174 = inst_12196;
var inst_12175 = (0);
var state_12230__$1 = (function (){var statearr_12263 = state_12230;
(statearr_12263[(9)] = inst_12173);

(statearr_12263[(19)] = inst_12174);

(statearr_12263[(20)] = inst_12172);

(statearr_12263[(11)] = inst_12175);

return statearr_12263;
})();
var statearr_12264_12334 = state_12230__$1;
(statearr_12264_12334[(2)] = null);

(statearr_12264_12334[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (41))){
var inst_12190 = (state_12230[(23)]);
var inst_12205 = (state_12230[(2)]);
var inst_12206 = cljs.core.next(inst_12190);
var inst_12172 = inst_12206;
var inst_12173 = null;
var inst_12174 = (0);
var inst_12175 = (0);
var state_12230__$1 = (function (){var statearr_12265 = state_12230;
(statearr_12265[(9)] = inst_12173);

(statearr_12265[(19)] = inst_12174);

(statearr_12265[(20)] = inst_12172);

(statearr_12265[(11)] = inst_12175);

(statearr_12265[(25)] = inst_12205);

return statearr_12265;
})();
var statearr_12266_12335 = state_12230__$1;
(statearr_12266_12335[(2)] = null);

(statearr_12266_12335[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (43))){
var state_12230__$1 = state_12230;
var statearr_12267_12336 = state_12230__$1;
(statearr_12267_12336[(2)] = null);

(statearr_12267_12336[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (29))){
var inst_12214 = (state_12230[(2)]);
var state_12230__$1 = state_12230;
var statearr_12268_12337 = state_12230__$1;
(statearr_12268_12337[(2)] = inst_12214);

(statearr_12268_12337[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (44))){
var inst_12223 = (state_12230[(2)]);
var state_12230__$1 = (function (){var statearr_12269 = state_12230;
(statearr_12269[(26)] = inst_12223);

return statearr_12269;
})();
var statearr_12270_12338 = state_12230__$1;
(statearr_12270_12338[(2)] = null);

(statearr_12270_12338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (6))){
var inst_12164 = (state_12230[(27)]);
var inst_12163 = cljs.core.deref(cs);
var inst_12164__$1 = cljs.core.keys(inst_12163);
var inst_12165 = cljs.core.count(inst_12164__$1);
var inst_12166 = cljs.core.reset_BANG_(dctr,inst_12165);
var inst_12171 = cljs.core.seq(inst_12164__$1);
var inst_12172 = inst_12171;
var inst_12173 = null;
var inst_12174 = (0);
var inst_12175 = (0);
var state_12230__$1 = (function (){var statearr_12271 = state_12230;
(statearr_12271[(9)] = inst_12173);

(statearr_12271[(19)] = inst_12174);

(statearr_12271[(20)] = inst_12172);

(statearr_12271[(27)] = inst_12164__$1);

(statearr_12271[(11)] = inst_12175);

(statearr_12271[(28)] = inst_12166);

return statearr_12271;
})();
var statearr_12272_12339 = state_12230__$1;
(statearr_12272_12339[(2)] = null);

(statearr_12272_12339[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (28))){
var inst_12190 = (state_12230[(23)]);
var inst_12172 = (state_12230[(20)]);
var inst_12190__$1 = cljs.core.seq(inst_12172);
var state_12230__$1 = (function (){var statearr_12273 = state_12230;
(statearr_12273[(23)] = inst_12190__$1);

return statearr_12273;
})();
if(inst_12190__$1){
var statearr_12274_12340 = state_12230__$1;
(statearr_12274_12340[(1)] = (33));

} else {
var statearr_12275_12341 = state_12230__$1;
(statearr_12275_12341[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (25))){
var inst_12174 = (state_12230[(19)]);
var inst_12175 = (state_12230[(11)]);
var inst_12177 = (inst_12175 < inst_12174);
var inst_12178 = inst_12177;
var state_12230__$1 = state_12230;
if(cljs.core.truth_(inst_12178)){
var statearr_12276_12342 = state_12230__$1;
(statearr_12276_12342[(1)] = (27));

} else {
var statearr_12277_12343 = state_12230__$1;
(statearr_12277_12343[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (34))){
var state_12230__$1 = state_12230;
var statearr_12278_12344 = state_12230__$1;
(statearr_12278_12344[(2)] = null);

(statearr_12278_12344[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (17))){
var state_12230__$1 = state_12230;
var statearr_12279_12345 = state_12230__$1;
(statearr_12279_12345[(2)] = null);

(statearr_12279_12345[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (3))){
var inst_12228 = (state_12230[(2)]);
var state_12230__$1 = state_12230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12230__$1,inst_12228);
} else {
if((state_val_12231 === (12))){
var inst_12159 = (state_12230[(2)]);
var state_12230__$1 = state_12230;
var statearr_12280_12346 = state_12230__$1;
(statearr_12280_12346[(2)] = inst_12159);

(statearr_12280_12346[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (2))){
var state_12230__$1 = state_12230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12230__$1,(4),ch);
} else {
if((state_val_12231 === (23))){
var state_12230__$1 = state_12230;
var statearr_12281_12347 = state_12230__$1;
(statearr_12281_12347[(2)] = null);

(statearr_12281_12347[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (35))){
var inst_12212 = (state_12230[(2)]);
var state_12230__$1 = state_12230;
var statearr_12282_12348 = state_12230__$1;
(statearr_12282_12348[(2)] = inst_12212);

(statearr_12282_12348[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (19))){
var inst_12131 = (state_12230[(7)]);
var inst_12135 = cljs.core.chunk_first(inst_12131);
var inst_12136 = cljs.core.chunk_rest(inst_12131);
var inst_12137 = cljs.core.count(inst_12135);
var inst_12109 = inst_12136;
var inst_12110 = inst_12135;
var inst_12111 = inst_12137;
var inst_12112 = (0);
var state_12230__$1 = (function (){var statearr_12283 = state_12230;
(statearr_12283[(13)] = inst_12110);

(statearr_12283[(14)] = inst_12111);

(statearr_12283[(15)] = inst_12112);

(statearr_12283[(17)] = inst_12109);

return statearr_12283;
})();
var statearr_12284_12349 = state_12230__$1;
(statearr_12284_12349[(2)] = null);

(statearr_12284_12349[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (11))){
var inst_12109 = (state_12230[(17)]);
var inst_12131 = (state_12230[(7)]);
var inst_12131__$1 = cljs.core.seq(inst_12109);
var state_12230__$1 = (function (){var statearr_12285 = state_12230;
(statearr_12285[(7)] = inst_12131__$1);

return statearr_12285;
})();
if(inst_12131__$1){
var statearr_12286_12350 = state_12230__$1;
(statearr_12286_12350[(1)] = (16));

} else {
var statearr_12287_12351 = state_12230__$1;
(statearr_12287_12351[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (9))){
var inst_12161 = (state_12230[(2)]);
var state_12230__$1 = state_12230;
var statearr_12288_12352 = state_12230__$1;
(statearr_12288_12352[(2)] = inst_12161);

(statearr_12288_12352[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (5))){
var inst_12107 = cljs.core.deref(cs);
var inst_12108 = cljs.core.seq(inst_12107);
var inst_12109 = inst_12108;
var inst_12110 = null;
var inst_12111 = (0);
var inst_12112 = (0);
var state_12230__$1 = (function (){var statearr_12289 = state_12230;
(statearr_12289[(13)] = inst_12110);

(statearr_12289[(14)] = inst_12111);

(statearr_12289[(15)] = inst_12112);

(statearr_12289[(17)] = inst_12109);

return statearr_12289;
})();
var statearr_12290_12353 = state_12230__$1;
(statearr_12290_12353[(2)] = null);

(statearr_12290_12353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (14))){
var state_12230__$1 = state_12230;
var statearr_12291_12354 = state_12230__$1;
(statearr_12291_12354[(2)] = null);

(statearr_12291_12354[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (45))){
var inst_12220 = (state_12230[(2)]);
var state_12230__$1 = state_12230;
var statearr_12292_12355 = state_12230__$1;
(statearr_12292_12355[(2)] = inst_12220);

(statearr_12292_12355[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (26))){
var inst_12164 = (state_12230[(27)]);
var inst_12216 = (state_12230[(2)]);
var inst_12217 = cljs.core.seq(inst_12164);
var state_12230__$1 = (function (){var statearr_12293 = state_12230;
(statearr_12293[(29)] = inst_12216);

return statearr_12293;
})();
if(inst_12217){
var statearr_12294_12356 = state_12230__$1;
(statearr_12294_12356[(1)] = (42));

} else {
var statearr_12295_12357 = state_12230__$1;
(statearr_12295_12357[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (16))){
var inst_12131 = (state_12230[(7)]);
var inst_12133 = cljs.core.chunked_seq_QMARK_(inst_12131);
var state_12230__$1 = state_12230;
if(inst_12133){
var statearr_12296_12358 = state_12230__$1;
(statearr_12296_12358[(1)] = (19));

} else {
var statearr_12297_12359 = state_12230__$1;
(statearr_12297_12359[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (38))){
var inst_12209 = (state_12230[(2)]);
var state_12230__$1 = state_12230;
var statearr_12298_12360 = state_12230__$1;
(statearr_12298_12360[(2)] = inst_12209);

(statearr_12298_12360[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (30))){
var state_12230__$1 = state_12230;
var statearr_12299_12361 = state_12230__$1;
(statearr_12299_12361[(2)] = null);

(statearr_12299_12361[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (10))){
var inst_12110 = (state_12230[(13)]);
var inst_12112 = (state_12230[(15)]);
var inst_12120 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12110,inst_12112);
var inst_12121 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12120,(0),null);
var inst_12122 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12120,(1),null);
var state_12230__$1 = (function (){var statearr_12300 = state_12230;
(statearr_12300[(24)] = inst_12121);

return statearr_12300;
})();
if(cljs.core.truth_(inst_12122)){
var statearr_12301_12362 = state_12230__$1;
(statearr_12301_12362[(1)] = (13));

} else {
var statearr_12302_12363 = state_12230__$1;
(statearr_12302_12363[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (18))){
var inst_12157 = (state_12230[(2)]);
var state_12230__$1 = state_12230;
var statearr_12303_12364 = state_12230__$1;
(statearr_12303_12364[(2)] = inst_12157);

(statearr_12303_12364[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (42))){
var state_12230__$1 = state_12230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12230__$1,(45),dchan);
} else {
if((state_val_12231 === (37))){
var inst_12199 = (state_12230[(22)]);
var inst_12190 = (state_12230[(23)]);
var inst_12100 = (state_12230[(10)]);
var inst_12199__$1 = cljs.core.first(inst_12190);
var inst_12200 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_12199__$1,inst_12100,done);
var state_12230__$1 = (function (){var statearr_12304 = state_12230;
(statearr_12304[(22)] = inst_12199__$1);

return statearr_12304;
})();
if(cljs.core.truth_(inst_12200)){
var statearr_12305_12365 = state_12230__$1;
(statearr_12305_12365[(1)] = (39));

} else {
var statearr_12306_12366 = state_12230__$1;
(statearr_12306_12366[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (8))){
var inst_12111 = (state_12230[(14)]);
var inst_12112 = (state_12230[(15)]);
var inst_12114 = (inst_12112 < inst_12111);
var inst_12115 = inst_12114;
var state_12230__$1 = state_12230;
if(cljs.core.truth_(inst_12115)){
var statearr_12307_12367 = state_12230__$1;
(statearr_12307_12367[(1)] = (10));

} else {
var statearr_12308_12368 = state_12230__$1;
(statearr_12308_12368[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__11396__auto__ = null;
var cljs$core$async$mult_$_state_machine__11396__auto____0 = (function (){
var statearr_12309 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12309[(0)] = cljs$core$async$mult_$_state_machine__11396__auto__);

(statearr_12309[(1)] = (1));

return statearr_12309;
});
var cljs$core$async$mult_$_state_machine__11396__auto____1 = (function (state_12230){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_12230);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e12310){var ex__11399__auto__ = e12310;
var statearr_12311_12369 = state_12230;
(statearr_12311_12369[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_12230[(4)]))){
var statearr_12312_12370 = state_12230;
(statearr_12312_12370[(1)] = cljs.core.first((state_12230[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12371 = state_12230;
state_12230 = G__12371;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11396__auto__ = function(state_12230){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11396__auto____1.call(this,state_12230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11396__auto____0;
cljs$core$async$mult_$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11396__auto____1;
return cljs$core$async$mult_$_state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_12313 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_12313[(6)] = c__11470__auto___12314);

return statearr_12313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__12373 = arguments.length;
switch (G__12373) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_12375 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_12375(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_12376 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_12376(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_12377 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_12377(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_12378 = (function (m,state_map){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4551__auto__.call(null,m,state_map));
} else {
var m__4549__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4549__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_12378(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_12379 = (function (m,mode){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4551__auto__.call(null,m,mode));
} else {
var m__4549__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4549__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_12379(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___12389 = arguments.length;
var i__4865__auto___12390 = (0);
while(true){
if((i__4865__auto___12390 < len__4864__auto___12389)){
args__4870__auto__.push((arguments[i__4865__auto___12390]));

var G__12391 = (i__4865__auto___12390 + (1));
i__4865__auto___12390 = G__12391;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12384){
var map__12385 = p__12384;
var map__12385__$1 = cljs.core.__destructure_map(map__12385);
var opts = map__12385__$1;
var statearr_12386_12392 = state;
(statearr_12386_12392[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_12387_12393 = state;
(statearr_12387_12393[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_12388_12394 = state;
(statearr_12388_12394[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12380){
var G__12381 = cljs.core.first(seq12380);
var seq12380__$1 = cljs.core.next(seq12380);
var G__12382 = cljs.core.first(seq12380__$1);
var seq12380__$2 = cljs.core.next(seq12380__$1);
var G__12383 = cljs.core.first(seq12380__$2);
var seq12380__$3 = cljs.core.next(seq12380__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12381,G__12382,G__12383,seq12380__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12395 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12395 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12396){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12396 = meta12396;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12395.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12397,meta12396__$1){
var self__ = this;
var _12397__$1 = this;
return (new cljs.core.async.t_cljs$core$async12395(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12396__$1));
}));

(cljs.core.async.t_cljs$core$async12395.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12397){
var self__ = this;
var _12397__$1 = this;
return self__.meta12396;
}));

(cljs.core.async.t_cljs$core$async12395.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12395.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async12395.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12395.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12395.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12395.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12395.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12395.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12395.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12396","meta12396",-1393348706,null)], null);
}));

(cljs.core.async.t_cljs$core$async12395.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12395.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12395");

(cljs.core.async.t_cljs$core$async12395.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async12395");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12395.
 */
cljs.core.async.__GT_t_cljs$core$async12395 = (function cljs$core$async$mix_$___GT_t_cljs$core$async12395(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12396){
return (new cljs.core.async.t_cljs$core$async12395(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12396));
});

}

return (new cljs.core.async.t_cljs$core$async12395(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11470__auto___12510 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_12465){
var state_val_12466 = (state_12465[(1)]);
if((state_val_12466 === (7))){
var inst_12425 = (state_12465[(2)]);
var state_12465__$1 = state_12465;
if(cljs.core.truth_(inst_12425)){
var statearr_12467_12511 = state_12465__$1;
(statearr_12467_12511[(1)] = (8));

} else {
var statearr_12468_12512 = state_12465__$1;
(statearr_12468_12512[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (20))){
var inst_12418 = (state_12465[(7)]);
var state_12465__$1 = state_12465;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12465__$1,(23),out,inst_12418);
} else {
if((state_val_12466 === (1))){
var inst_12401 = calc_state();
var inst_12402 = cljs.core.__destructure_map(inst_12401);
var inst_12403 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12402,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12404 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12402,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12405 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12402,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12406 = inst_12401;
var state_12465__$1 = (function (){var statearr_12469 = state_12465;
(statearr_12469[(8)] = inst_12404);

(statearr_12469[(9)] = inst_12406);

(statearr_12469[(10)] = inst_12403);

(statearr_12469[(11)] = inst_12405);

return statearr_12469;
})();
var statearr_12470_12513 = state_12465__$1;
(statearr_12470_12513[(2)] = null);

(statearr_12470_12513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (24))){
var inst_12409 = (state_12465[(12)]);
var inst_12406 = inst_12409;
var state_12465__$1 = (function (){var statearr_12471 = state_12465;
(statearr_12471[(9)] = inst_12406);

return statearr_12471;
})();
var statearr_12472_12514 = state_12465__$1;
(statearr_12472_12514[(2)] = null);

(statearr_12472_12514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (4))){
var inst_12418 = (state_12465[(7)]);
var inst_12420 = (state_12465[(13)]);
var inst_12417 = (state_12465[(2)]);
var inst_12418__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12417,(0),null);
var inst_12419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12417,(1),null);
var inst_12420__$1 = (inst_12418__$1 == null);
var state_12465__$1 = (function (){var statearr_12473 = state_12465;
(statearr_12473[(14)] = inst_12419);

(statearr_12473[(7)] = inst_12418__$1);

(statearr_12473[(13)] = inst_12420__$1);

return statearr_12473;
})();
if(cljs.core.truth_(inst_12420__$1)){
var statearr_12474_12515 = state_12465__$1;
(statearr_12474_12515[(1)] = (5));

} else {
var statearr_12475_12516 = state_12465__$1;
(statearr_12475_12516[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (15))){
var inst_12410 = (state_12465[(15)]);
var inst_12439 = (state_12465[(16)]);
var inst_12439__$1 = cljs.core.empty_QMARK_(inst_12410);
var state_12465__$1 = (function (){var statearr_12476 = state_12465;
(statearr_12476[(16)] = inst_12439__$1);

return statearr_12476;
})();
if(inst_12439__$1){
var statearr_12477_12517 = state_12465__$1;
(statearr_12477_12517[(1)] = (17));

} else {
var statearr_12478_12518 = state_12465__$1;
(statearr_12478_12518[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (21))){
var inst_12409 = (state_12465[(12)]);
var inst_12406 = inst_12409;
var state_12465__$1 = (function (){var statearr_12479 = state_12465;
(statearr_12479[(9)] = inst_12406);

return statearr_12479;
})();
var statearr_12480_12519 = state_12465__$1;
(statearr_12480_12519[(2)] = null);

(statearr_12480_12519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (13))){
var inst_12432 = (state_12465[(2)]);
var inst_12433 = calc_state();
var inst_12406 = inst_12433;
var state_12465__$1 = (function (){var statearr_12481 = state_12465;
(statearr_12481[(17)] = inst_12432);

(statearr_12481[(9)] = inst_12406);

return statearr_12481;
})();
var statearr_12482_12520 = state_12465__$1;
(statearr_12482_12520[(2)] = null);

(statearr_12482_12520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (22))){
var inst_12459 = (state_12465[(2)]);
var state_12465__$1 = state_12465;
var statearr_12483_12521 = state_12465__$1;
(statearr_12483_12521[(2)] = inst_12459);

(statearr_12483_12521[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (6))){
var inst_12419 = (state_12465[(14)]);
var inst_12423 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_12419,change);
var state_12465__$1 = state_12465;
var statearr_12484_12522 = state_12465__$1;
(statearr_12484_12522[(2)] = inst_12423);

(statearr_12484_12522[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (25))){
var state_12465__$1 = state_12465;
var statearr_12485_12523 = state_12465__$1;
(statearr_12485_12523[(2)] = null);

(statearr_12485_12523[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (17))){
var inst_12419 = (state_12465[(14)]);
var inst_12411 = (state_12465[(18)]);
var inst_12441 = (inst_12411.cljs$core$IFn$_invoke$arity$1 ? inst_12411.cljs$core$IFn$_invoke$arity$1(inst_12419) : inst_12411.call(null,inst_12419));
var inst_12442 = cljs.core.not(inst_12441);
var state_12465__$1 = state_12465;
var statearr_12486_12524 = state_12465__$1;
(statearr_12486_12524[(2)] = inst_12442);

(statearr_12486_12524[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (3))){
var inst_12463 = (state_12465[(2)]);
var state_12465__$1 = state_12465;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12465__$1,inst_12463);
} else {
if((state_val_12466 === (12))){
var state_12465__$1 = state_12465;
var statearr_12487_12525 = state_12465__$1;
(statearr_12487_12525[(2)] = null);

(statearr_12487_12525[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (2))){
var inst_12406 = (state_12465[(9)]);
var inst_12409 = (state_12465[(12)]);
var inst_12409__$1 = cljs.core.__destructure_map(inst_12406);
var inst_12410 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12409__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12411 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12409__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12412 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12409__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12465__$1 = (function (){var statearr_12488 = state_12465;
(statearr_12488[(15)] = inst_12410);

(statearr_12488[(18)] = inst_12411);

(statearr_12488[(12)] = inst_12409__$1);

return statearr_12488;
})();
return cljs.core.async.ioc_alts_BANG_(state_12465__$1,(4),inst_12412);
} else {
if((state_val_12466 === (23))){
var inst_12450 = (state_12465[(2)]);
var state_12465__$1 = state_12465;
if(cljs.core.truth_(inst_12450)){
var statearr_12489_12526 = state_12465__$1;
(statearr_12489_12526[(1)] = (24));

} else {
var statearr_12490_12527 = state_12465__$1;
(statearr_12490_12527[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (19))){
var inst_12445 = (state_12465[(2)]);
var state_12465__$1 = state_12465;
var statearr_12491_12528 = state_12465__$1;
(statearr_12491_12528[(2)] = inst_12445);

(statearr_12491_12528[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (11))){
var inst_12419 = (state_12465[(14)]);
var inst_12429 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_12419);
var state_12465__$1 = state_12465;
var statearr_12492_12529 = state_12465__$1;
(statearr_12492_12529[(2)] = inst_12429);

(statearr_12492_12529[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (9))){
var inst_12419 = (state_12465[(14)]);
var inst_12436 = (state_12465[(19)]);
var inst_12410 = (state_12465[(15)]);
var inst_12436__$1 = (inst_12410.cljs$core$IFn$_invoke$arity$1 ? inst_12410.cljs$core$IFn$_invoke$arity$1(inst_12419) : inst_12410.call(null,inst_12419));
var state_12465__$1 = (function (){var statearr_12493 = state_12465;
(statearr_12493[(19)] = inst_12436__$1);

return statearr_12493;
})();
if(cljs.core.truth_(inst_12436__$1)){
var statearr_12494_12530 = state_12465__$1;
(statearr_12494_12530[(1)] = (14));

} else {
var statearr_12495_12531 = state_12465__$1;
(statearr_12495_12531[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (5))){
var inst_12420 = (state_12465[(13)]);
var state_12465__$1 = state_12465;
var statearr_12496_12532 = state_12465__$1;
(statearr_12496_12532[(2)] = inst_12420);

(statearr_12496_12532[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (14))){
var inst_12436 = (state_12465[(19)]);
var state_12465__$1 = state_12465;
var statearr_12497_12533 = state_12465__$1;
(statearr_12497_12533[(2)] = inst_12436);

(statearr_12497_12533[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (26))){
var inst_12455 = (state_12465[(2)]);
var state_12465__$1 = state_12465;
var statearr_12498_12534 = state_12465__$1;
(statearr_12498_12534[(2)] = inst_12455);

(statearr_12498_12534[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (16))){
var inst_12447 = (state_12465[(2)]);
var state_12465__$1 = state_12465;
if(cljs.core.truth_(inst_12447)){
var statearr_12499_12535 = state_12465__$1;
(statearr_12499_12535[(1)] = (20));

} else {
var statearr_12500_12536 = state_12465__$1;
(statearr_12500_12536[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (10))){
var inst_12461 = (state_12465[(2)]);
var state_12465__$1 = state_12465;
var statearr_12501_12537 = state_12465__$1;
(statearr_12501_12537[(2)] = inst_12461);

(statearr_12501_12537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (18))){
var inst_12439 = (state_12465[(16)]);
var state_12465__$1 = state_12465;
var statearr_12502_12538 = state_12465__$1;
(statearr_12502_12538[(2)] = inst_12439);

(statearr_12502_12538[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (8))){
var inst_12418 = (state_12465[(7)]);
var inst_12427 = (inst_12418 == null);
var state_12465__$1 = state_12465;
if(cljs.core.truth_(inst_12427)){
var statearr_12503_12539 = state_12465__$1;
(statearr_12503_12539[(1)] = (11));

} else {
var statearr_12504_12540 = state_12465__$1;
(statearr_12504_12540[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__11396__auto__ = null;
var cljs$core$async$mix_$_state_machine__11396__auto____0 = (function (){
var statearr_12505 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12505[(0)] = cljs$core$async$mix_$_state_machine__11396__auto__);

(statearr_12505[(1)] = (1));

return statearr_12505;
});
var cljs$core$async$mix_$_state_machine__11396__auto____1 = (function (state_12465){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_12465);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e12506){var ex__11399__auto__ = e12506;
var statearr_12507_12541 = state_12465;
(statearr_12507_12541[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_12465[(4)]))){
var statearr_12508_12542 = state_12465;
(statearr_12508_12542[(1)] = cljs.core.first((state_12465[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12543 = state_12465;
state_12465 = G__12543;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11396__auto__ = function(state_12465){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11396__auto____1.call(this,state_12465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11396__auto____0;
cljs$core$async$mix_$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11396__auto____1;
return cljs$core$async$mix_$_state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_12509 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_12509[(6)] = c__11470__auto___12510);

return statearr_12509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_12546 = (function (p,v,ch,close_QMARK_){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4551__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4549__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_12546(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_12547 = (function (p,v,ch){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4551__auto__.call(null,p,v,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4549__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_12547(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_12548 = (function() {
var G__12549 = null;
var G__12549__1 = (function (p){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4551__auto__.call(null,p));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4549__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__12549__2 = (function (p,v){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4551__auto__.call(null,p,v));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4549__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__12549 = function(p,v){
switch(arguments.length){
case 1:
return G__12549__1.call(this,p);
case 2:
return G__12549__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12549.cljs$core$IFn$_invoke$arity$1 = G__12549__1;
G__12549.cljs$core$IFn$_invoke$arity$2 = G__12549__2;
return G__12549;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__12545 = arguments.length;
switch (G__12545) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12548.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12548.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__12553 = arguments.length;
switch (G__12553) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__12551_SHARP_){
if(cljs.core.truth_((p1__12551_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__12551_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__12551_SHARP_.call(null,topic)))){
return p1__12551_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__12551_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12554 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12554 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12555){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12555 = meta12555;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12554.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12556,meta12555__$1){
var self__ = this;
var _12556__$1 = this;
return (new cljs.core.async.t_cljs$core$async12554(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12555__$1));
}));

(cljs.core.async.t_cljs$core$async12554.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12556){
var self__ = this;
var _12556__$1 = this;
return self__.meta12555;
}));

(cljs.core.async.t_cljs$core$async12554.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12554.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12554.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12554.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async12554.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async12554.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async12554.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async12554.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12555","meta12555",-1736676128,null)], null);
}));

(cljs.core.async.t_cljs$core$async12554.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12554.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12554");

(cljs.core.async.t_cljs$core$async12554.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async12554");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12554.
 */
cljs.core.async.__GT_t_cljs$core$async12554 = (function cljs$core$async$__GT_t_cljs$core$async12554(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12555){
return (new cljs.core.async.t_cljs$core$async12554(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12555));
});

}

return (new cljs.core.async.t_cljs$core$async12554(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11470__auto___12675 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_12628){
var state_val_12629 = (state_12628[(1)]);
if((state_val_12629 === (7))){
var inst_12624 = (state_12628[(2)]);
var state_12628__$1 = state_12628;
var statearr_12630_12676 = state_12628__$1;
(statearr_12630_12676[(2)] = inst_12624);

(statearr_12630_12676[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (20))){
var state_12628__$1 = state_12628;
var statearr_12631_12677 = state_12628__$1;
(statearr_12631_12677[(2)] = null);

(statearr_12631_12677[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (1))){
var state_12628__$1 = state_12628;
var statearr_12632_12678 = state_12628__$1;
(statearr_12632_12678[(2)] = null);

(statearr_12632_12678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (24))){
var inst_12607 = (state_12628[(7)]);
var inst_12616 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_12607);
var state_12628__$1 = state_12628;
var statearr_12633_12679 = state_12628__$1;
(statearr_12633_12679[(2)] = inst_12616);

(statearr_12633_12679[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (4))){
var inst_12559 = (state_12628[(8)]);
var inst_12559__$1 = (state_12628[(2)]);
var inst_12560 = (inst_12559__$1 == null);
var state_12628__$1 = (function (){var statearr_12634 = state_12628;
(statearr_12634[(8)] = inst_12559__$1);

return statearr_12634;
})();
if(cljs.core.truth_(inst_12560)){
var statearr_12635_12680 = state_12628__$1;
(statearr_12635_12680[(1)] = (5));

} else {
var statearr_12636_12681 = state_12628__$1;
(statearr_12636_12681[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (15))){
var inst_12601 = (state_12628[(2)]);
var state_12628__$1 = state_12628;
var statearr_12637_12682 = state_12628__$1;
(statearr_12637_12682[(2)] = inst_12601);

(statearr_12637_12682[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (21))){
var inst_12621 = (state_12628[(2)]);
var state_12628__$1 = (function (){var statearr_12638 = state_12628;
(statearr_12638[(9)] = inst_12621);

return statearr_12638;
})();
var statearr_12639_12683 = state_12628__$1;
(statearr_12639_12683[(2)] = null);

(statearr_12639_12683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (13))){
var inst_12583 = (state_12628[(10)]);
var inst_12585 = cljs.core.chunked_seq_QMARK_(inst_12583);
var state_12628__$1 = state_12628;
if(inst_12585){
var statearr_12640_12684 = state_12628__$1;
(statearr_12640_12684[(1)] = (16));

} else {
var statearr_12641_12685 = state_12628__$1;
(statearr_12641_12685[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (22))){
var inst_12613 = (state_12628[(2)]);
var state_12628__$1 = state_12628;
if(cljs.core.truth_(inst_12613)){
var statearr_12642_12686 = state_12628__$1;
(statearr_12642_12686[(1)] = (23));

} else {
var statearr_12643_12687 = state_12628__$1;
(statearr_12643_12687[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (6))){
var inst_12607 = (state_12628[(7)]);
var inst_12609 = (state_12628[(11)]);
var inst_12559 = (state_12628[(8)]);
var inst_12607__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_12559) : topic_fn.call(null,inst_12559));
var inst_12608 = cljs.core.deref(mults);
var inst_12609__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12608,inst_12607__$1);
var state_12628__$1 = (function (){var statearr_12644 = state_12628;
(statearr_12644[(7)] = inst_12607__$1);

(statearr_12644[(11)] = inst_12609__$1);

return statearr_12644;
})();
if(cljs.core.truth_(inst_12609__$1)){
var statearr_12645_12688 = state_12628__$1;
(statearr_12645_12688[(1)] = (19));

} else {
var statearr_12646_12689 = state_12628__$1;
(statearr_12646_12689[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (25))){
var inst_12618 = (state_12628[(2)]);
var state_12628__$1 = state_12628;
var statearr_12647_12690 = state_12628__$1;
(statearr_12647_12690[(2)] = inst_12618);

(statearr_12647_12690[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (17))){
var inst_12583 = (state_12628[(10)]);
var inst_12592 = cljs.core.first(inst_12583);
var inst_12593 = cljs.core.async.muxch_STAR_(inst_12592);
var inst_12594 = cljs.core.async.close_BANG_(inst_12593);
var inst_12595 = cljs.core.next(inst_12583);
var inst_12569 = inst_12595;
var inst_12570 = null;
var inst_12571 = (0);
var inst_12572 = (0);
var state_12628__$1 = (function (){var statearr_12648 = state_12628;
(statearr_12648[(12)] = inst_12594);

(statearr_12648[(13)] = inst_12569);

(statearr_12648[(14)] = inst_12572);

(statearr_12648[(15)] = inst_12571);

(statearr_12648[(16)] = inst_12570);

return statearr_12648;
})();
var statearr_12649_12691 = state_12628__$1;
(statearr_12649_12691[(2)] = null);

(statearr_12649_12691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (3))){
var inst_12626 = (state_12628[(2)]);
var state_12628__$1 = state_12628;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12628__$1,inst_12626);
} else {
if((state_val_12629 === (12))){
var inst_12603 = (state_12628[(2)]);
var state_12628__$1 = state_12628;
var statearr_12650_12692 = state_12628__$1;
(statearr_12650_12692[(2)] = inst_12603);

(statearr_12650_12692[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (2))){
var state_12628__$1 = state_12628;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12628__$1,(4),ch);
} else {
if((state_val_12629 === (23))){
var state_12628__$1 = state_12628;
var statearr_12651_12693 = state_12628__$1;
(statearr_12651_12693[(2)] = null);

(statearr_12651_12693[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (19))){
var inst_12609 = (state_12628[(11)]);
var inst_12559 = (state_12628[(8)]);
var inst_12611 = cljs.core.async.muxch_STAR_(inst_12609);
var state_12628__$1 = state_12628;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12628__$1,(22),inst_12611,inst_12559);
} else {
if((state_val_12629 === (11))){
var inst_12569 = (state_12628[(13)]);
var inst_12583 = (state_12628[(10)]);
var inst_12583__$1 = cljs.core.seq(inst_12569);
var state_12628__$1 = (function (){var statearr_12652 = state_12628;
(statearr_12652[(10)] = inst_12583__$1);

return statearr_12652;
})();
if(inst_12583__$1){
var statearr_12653_12694 = state_12628__$1;
(statearr_12653_12694[(1)] = (13));

} else {
var statearr_12654_12695 = state_12628__$1;
(statearr_12654_12695[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (9))){
var inst_12605 = (state_12628[(2)]);
var state_12628__$1 = state_12628;
var statearr_12655_12696 = state_12628__$1;
(statearr_12655_12696[(2)] = inst_12605);

(statearr_12655_12696[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (5))){
var inst_12566 = cljs.core.deref(mults);
var inst_12567 = cljs.core.vals(inst_12566);
var inst_12568 = cljs.core.seq(inst_12567);
var inst_12569 = inst_12568;
var inst_12570 = null;
var inst_12571 = (0);
var inst_12572 = (0);
var state_12628__$1 = (function (){var statearr_12656 = state_12628;
(statearr_12656[(13)] = inst_12569);

(statearr_12656[(14)] = inst_12572);

(statearr_12656[(15)] = inst_12571);

(statearr_12656[(16)] = inst_12570);

return statearr_12656;
})();
var statearr_12657_12697 = state_12628__$1;
(statearr_12657_12697[(2)] = null);

(statearr_12657_12697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (14))){
var state_12628__$1 = state_12628;
var statearr_12661_12698 = state_12628__$1;
(statearr_12661_12698[(2)] = null);

(statearr_12661_12698[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (16))){
var inst_12583 = (state_12628[(10)]);
var inst_12587 = cljs.core.chunk_first(inst_12583);
var inst_12588 = cljs.core.chunk_rest(inst_12583);
var inst_12589 = cljs.core.count(inst_12587);
var inst_12569 = inst_12588;
var inst_12570 = inst_12587;
var inst_12571 = inst_12589;
var inst_12572 = (0);
var state_12628__$1 = (function (){var statearr_12662 = state_12628;
(statearr_12662[(13)] = inst_12569);

(statearr_12662[(14)] = inst_12572);

(statearr_12662[(15)] = inst_12571);

(statearr_12662[(16)] = inst_12570);

return statearr_12662;
})();
var statearr_12663_12699 = state_12628__$1;
(statearr_12663_12699[(2)] = null);

(statearr_12663_12699[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (10))){
var inst_12569 = (state_12628[(13)]);
var inst_12572 = (state_12628[(14)]);
var inst_12571 = (state_12628[(15)]);
var inst_12570 = (state_12628[(16)]);
var inst_12577 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12570,inst_12572);
var inst_12578 = cljs.core.async.muxch_STAR_(inst_12577);
var inst_12579 = cljs.core.async.close_BANG_(inst_12578);
var inst_12580 = (inst_12572 + (1));
var tmp12658 = inst_12569;
var tmp12659 = inst_12571;
var tmp12660 = inst_12570;
var inst_12569__$1 = tmp12658;
var inst_12570__$1 = tmp12660;
var inst_12571__$1 = tmp12659;
var inst_12572__$1 = inst_12580;
var state_12628__$1 = (function (){var statearr_12664 = state_12628;
(statearr_12664[(13)] = inst_12569__$1);

(statearr_12664[(14)] = inst_12572__$1);

(statearr_12664[(17)] = inst_12579);

(statearr_12664[(15)] = inst_12571__$1);

(statearr_12664[(16)] = inst_12570__$1);

return statearr_12664;
})();
var statearr_12665_12700 = state_12628__$1;
(statearr_12665_12700[(2)] = null);

(statearr_12665_12700[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (18))){
var inst_12598 = (state_12628[(2)]);
var state_12628__$1 = state_12628;
var statearr_12666_12701 = state_12628__$1;
(statearr_12666_12701[(2)] = inst_12598);

(statearr_12666_12701[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (8))){
var inst_12572 = (state_12628[(14)]);
var inst_12571 = (state_12628[(15)]);
var inst_12574 = (inst_12572 < inst_12571);
var inst_12575 = inst_12574;
var state_12628__$1 = state_12628;
if(cljs.core.truth_(inst_12575)){
var statearr_12667_12702 = state_12628__$1;
(statearr_12667_12702[(1)] = (10));

} else {
var statearr_12668_12703 = state_12628__$1;
(statearr_12668_12703[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11396__auto__ = null;
var cljs$core$async$state_machine__11396__auto____0 = (function (){
var statearr_12669 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12669[(0)] = cljs$core$async$state_machine__11396__auto__);

(statearr_12669[(1)] = (1));

return statearr_12669;
});
var cljs$core$async$state_machine__11396__auto____1 = (function (state_12628){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_12628);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e12670){var ex__11399__auto__ = e12670;
var statearr_12671_12704 = state_12628;
(statearr_12671_12704[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_12628[(4)]))){
var statearr_12672_12705 = state_12628;
(statearr_12672_12705[(1)] = cljs.core.first((state_12628[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12706 = state_12628;
state_12628 = G__12706;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$state_machine__11396__auto__ = function(state_12628){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11396__auto____1.call(this,state_12628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11396__auto____0;
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11396__auto____1;
return cljs$core$async$state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_12673 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_12673[(6)] = c__11470__auto___12675);

return statearr_12673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__12708 = arguments.length;
switch (G__12708) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__12711 = arguments.length;
switch (G__12711) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__12714 = arguments.length;
switch (G__12714) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__11470__auto___12792 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_12757){
var state_val_12758 = (state_12757[(1)]);
if((state_val_12758 === (7))){
var state_12757__$1 = state_12757;
var statearr_12759_12793 = state_12757__$1;
(statearr_12759_12793[(2)] = null);

(statearr_12759_12793[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12758 === (1))){
var state_12757__$1 = state_12757;
var statearr_12760_12794 = state_12757__$1;
(statearr_12760_12794[(2)] = null);

(statearr_12760_12794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12758 === (4))){
var inst_12717 = (state_12757[(7)]);
var inst_12718 = (state_12757[(8)]);
var inst_12720 = (inst_12718 < inst_12717);
var state_12757__$1 = state_12757;
if(cljs.core.truth_(inst_12720)){
var statearr_12761_12795 = state_12757__$1;
(statearr_12761_12795[(1)] = (6));

} else {
var statearr_12762_12796 = state_12757__$1;
(statearr_12762_12796[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12758 === (15))){
var inst_12743 = (state_12757[(9)]);
var inst_12748 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_12743);
var state_12757__$1 = state_12757;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12757__$1,(17),out,inst_12748);
} else {
if((state_val_12758 === (13))){
var inst_12743 = (state_12757[(9)]);
var inst_12743__$1 = (state_12757[(2)]);
var inst_12744 = cljs.core.some(cljs.core.nil_QMARK_,inst_12743__$1);
var state_12757__$1 = (function (){var statearr_12763 = state_12757;
(statearr_12763[(9)] = inst_12743__$1);

return statearr_12763;
})();
if(cljs.core.truth_(inst_12744)){
var statearr_12764_12797 = state_12757__$1;
(statearr_12764_12797[(1)] = (14));

} else {
var statearr_12765_12798 = state_12757__$1;
(statearr_12765_12798[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12758 === (6))){
var state_12757__$1 = state_12757;
var statearr_12766_12799 = state_12757__$1;
(statearr_12766_12799[(2)] = null);

(statearr_12766_12799[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12758 === (17))){
var inst_12750 = (state_12757[(2)]);
var state_12757__$1 = (function (){var statearr_12768 = state_12757;
(statearr_12768[(10)] = inst_12750);

return statearr_12768;
})();
var statearr_12769_12800 = state_12757__$1;
(statearr_12769_12800[(2)] = null);

(statearr_12769_12800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12758 === (3))){
var inst_12755 = (state_12757[(2)]);
var state_12757__$1 = state_12757;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12757__$1,inst_12755);
} else {
if((state_val_12758 === (12))){
var _ = (function (){var statearr_12770 = state_12757;
(statearr_12770[(4)] = cljs.core.rest((state_12757[(4)])));

return statearr_12770;
})();
var state_12757__$1 = state_12757;
var ex12767 = (state_12757__$1[(2)]);
var statearr_12771_12801 = state_12757__$1;
(statearr_12771_12801[(5)] = ex12767);


if((ex12767 instanceof Object)){
var statearr_12772_12802 = state_12757__$1;
(statearr_12772_12802[(1)] = (11));

(statearr_12772_12802[(5)] = null);

} else {
throw ex12767;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12758 === (2))){
var inst_12716 = cljs.core.reset_BANG_(dctr,cnt);
var inst_12717 = cnt;
var inst_12718 = (0);
var state_12757__$1 = (function (){var statearr_12773 = state_12757;
(statearr_12773[(7)] = inst_12717);

(statearr_12773[(8)] = inst_12718);

(statearr_12773[(11)] = inst_12716);

return statearr_12773;
})();
var statearr_12774_12803 = state_12757__$1;
(statearr_12774_12803[(2)] = null);

(statearr_12774_12803[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12758 === (11))){
var inst_12722 = (state_12757[(2)]);
var inst_12723 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_12757__$1 = (function (){var statearr_12775 = state_12757;
(statearr_12775[(12)] = inst_12722);

return statearr_12775;
})();
var statearr_12776_12804 = state_12757__$1;
(statearr_12776_12804[(2)] = inst_12723);

(statearr_12776_12804[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12758 === (9))){
var inst_12718 = (state_12757[(8)]);
var _ = (function (){var statearr_12777 = state_12757;
(statearr_12777[(4)] = cljs.core.cons((12),(state_12757[(4)])));

return statearr_12777;
})();
var inst_12729 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_12718) : chs__$1.call(null,inst_12718));
var inst_12730 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_12718) : done.call(null,inst_12718));
var inst_12731 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_12729,inst_12730);
var ___$1 = (function (){var statearr_12778 = state_12757;
(statearr_12778[(4)] = cljs.core.rest((state_12757[(4)])));

return statearr_12778;
})();
var state_12757__$1 = state_12757;
var statearr_12779_12805 = state_12757__$1;
(statearr_12779_12805[(2)] = inst_12731);

(statearr_12779_12805[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12758 === (5))){
var inst_12741 = (state_12757[(2)]);
var state_12757__$1 = (function (){var statearr_12780 = state_12757;
(statearr_12780[(13)] = inst_12741);

return statearr_12780;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12757__$1,(13),dchan);
} else {
if((state_val_12758 === (14))){
var inst_12746 = cljs.core.async.close_BANG_(out);
var state_12757__$1 = state_12757;
var statearr_12781_12806 = state_12757__$1;
(statearr_12781_12806[(2)] = inst_12746);

(statearr_12781_12806[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12758 === (16))){
var inst_12753 = (state_12757[(2)]);
var state_12757__$1 = state_12757;
var statearr_12782_12807 = state_12757__$1;
(statearr_12782_12807[(2)] = inst_12753);

(statearr_12782_12807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12758 === (10))){
var inst_12718 = (state_12757[(8)]);
var inst_12734 = (state_12757[(2)]);
var inst_12735 = (inst_12718 + (1));
var inst_12718__$1 = inst_12735;
var state_12757__$1 = (function (){var statearr_12783 = state_12757;
(statearr_12783[(8)] = inst_12718__$1);

(statearr_12783[(14)] = inst_12734);

return statearr_12783;
})();
var statearr_12784_12808 = state_12757__$1;
(statearr_12784_12808[(2)] = null);

(statearr_12784_12808[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12758 === (8))){
var inst_12739 = (state_12757[(2)]);
var state_12757__$1 = state_12757;
var statearr_12785_12809 = state_12757__$1;
(statearr_12785_12809[(2)] = inst_12739);

(statearr_12785_12809[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11396__auto__ = null;
var cljs$core$async$state_machine__11396__auto____0 = (function (){
var statearr_12786 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12786[(0)] = cljs$core$async$state_machine__11396__auto__);

(statearr_12786[(1)] = (1));

return statearr_12786;
});
var cljs$core$async$state_machine__11396__auto____1 = (function (state_12757){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_12757);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e12787){var ex__11399__auto__ = e12787;
var statearr_12788_12810 = state_12757;
(statearr_12788_12810[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_12757[(4)]))){
var statearr_12789_12811 = state_12757;
(statearr_12789_12811[(1)] = cljs.core.first((state_12757[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12812 = state_12757;
state_12757 = G__12812;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$state_machine__11396__auto__ = function(state_12757){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11396__auto____1.call(this,state_12757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11396__auto____0;
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11396__auto____1;
return cljs$core$async$state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_12790 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_12790[(6)] = c__11470__auto___12792);

return statearr_12790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__12815 = arguments.length;
switch (G__12815) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11470__auto___12870 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_12847){
var state_val_12848 = (state_12847[(1)]);
if((state_val_12848 === (7))){
var inst_12827 = (state_12847[(7)]);
var inst_12826 = (state_12847[(8)]);
var inst_12826__$1 = (state_12847[(2)]);
var inst_12827__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12826__$1,(0),null);
var inst_12828 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12826__$1,(1),null);
var inst_12829 = (inst_12827__$1 == null);
var state_12847__$1 = (function (){var statearr_12849 = state_12847;
(statearr_12849[(7)] = inst_12827__$1);

(statearr_12849[(8)] = inst_12826__$1);

(statearr_12849[(9)] = inst_12828);

return statearr_12849;
})();
if(cljs.core.truth_(inst_12829)){
var statearr_12850_12871 = state_12847__$1;
(statearr_12850_12871[(1)] = (8));

} else {
var statearr_12851_12872 = state_12847__$1;
(statearr_12851_12872[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12848 === (1))){
var inst_12816 = cljs.core.vec(chs);
var inst_12817 = inst_12816;
var state_12847__$1 = (function (){var statearr_12852 = state_12847;
(statearr_12852[(10)] = inst_12817);

return statearr_12852;
})();
var statearr_12853_12873 = state_12847__$1;
(statearr_12853_12873[(2)] = null);

(statearr_12853_12873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12848 === (4))){
var inst_12817 = (state_12847[(10)]);
var state_12847__$1 = state_12847;
return cljs.core.async.ioc_alts_BANG_(state_12847__$1,(7),inst_12817);
} else {
if((state_val_12848 === (6))){
var inst_12843 = (state_12847[(2)]);
var state_12847__$1 = state_12847;
var statearr_12854_12874 = state_12847__$1;
(statearr_12854_12874[(2)] = inst_12843);

(statearr_12854_12874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12848 === (3))){
var inst_12845 = (state_12847[(2)]);
var state_12847__$1 = state_12847;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12847__$1,inst_12845);
} else {
if((state_val_12848 === (2))){
var inst_12817 = (state_12847[(10)]);
var inst_12819 = cljs.core.count(inst_12817);
var inst_12820 = (inst_12819 > (0));
var state_12847__$1 = state_12847;
if(cljs.core.truth_(inst_12820)){
var statearr_12856_12875 = state_12847__$1;
(statearr_12856_12875[(1)] = (4));

} else {
var statearr_12857_12876 = state_12847__$1;
(statearr_12857_12876[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12848 === (11))){
var inst_12817 = (state_12847[(10)]);
var inst_12836 = (state_12847[(2)]);
var tmp12855 = inst_12817;
var inst_12817__$1 = tmp12855;
var state_12847__$1 = (function (){var statearr_12858 = state_12847;
(statearr_12858[(11)] = inst_12836);

(statearr_12858[(10)] = inst_12817__$1);

return statearr_12858;
})();
var statearr_12859_12877 = state_12847__$1;
(statearr_12859_12877[(2)] = null);

(statearr_12859_12877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12848 === (9))){
var inst_12827 = (state_12847[(7)]);
var state_12847__$1 = state_12847;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12847__$1,(11),out,inst_12827);
} else {
if((state_val_12848 === (5))){
var inst_12841 = cljs.core.async.close_BANG_(out);
var state_12847__$1 = state_12847;
var statearr_12860_12878 = state_12847__$1;
(statearr_12860_12878[(2)] = inst_12841);

(statearr_12860_12878[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12848 === (10))){
var inst_12839 = (state_12847[(2)]);
var state_12847__$1 = state_12847;
var statearr_12861_12879 = state_12847__$1;
(statearr_12861_12879[(2)] = inst_12839);

(statearr_12861_12879[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12848 === (8))){
var inst_12827 = (state_12847[(7)]);
var inst_12826 = (state_12847[(8)]);
var inst_12817 = (state_12847[(10)]);
var inst_12828 = (state_12847[(9)]);
var inst_12831 = (function (){var cs = inst_12817;
var vec__12822 = inst_12826;
var v = inst_12827;
var c = inst_12828;
return (function (p1__12813_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__12813_SHARP_);
});
})();
var inst_12832 = cljs.core.filterv(inst_12831,inst_12817);
var inst_12817__$1 = inst_12832;
var state_12847__$1 = (function (){var statearr_12862 = state_12847;
(statearr_12862[(10)] = inst_12817__$1);

return statearr_12862;
})();
var statearr_12863_12880 = state_12847__$1;
(statearr_12863_12880[(2)] = null);

(statearr_12863_12880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11396__auto__ = null;
var cljs$core$async$state_machine__11396__auto____0 = (function (){
var statearr_12864 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12864[(0)] = cljs$core$async$state_machine__11396__auto__);

(statearr_12864[(1)] = (1));

return statearr_12864;
});
var cljs$core$async$state_machine__11396__auto____1 = (function (state_12847){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_12847);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e12865){var ex__11399__auto__ = e12865;
var statearr_12866_12881 = state_12847;
(statearr_12866_12881[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_12847[(4)]))){
var statearr_12867_12882 = state_12847;
(statearr_12867_12882[(1)] = cljs.core.first((state_12847[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12883 = state_12847;
state_12847 = G__12883;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$state_machine__11396__auto__ = function(state_12847){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11396__auto____1.call(this,state_12847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11396__auto____0;
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11396__auto____1;
return cljs$core$async$state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_12868 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_12868[(6)] = c__11470__auto___12870);

return statearr_12868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__12885 = arguments.length;
switch (G__12885) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11470__auto___12931 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_12909){
var state_val_12910 = (state_12909[(1)]);
if((state_val_12910 === (7))){
var inst_12891 = (state_12909[(7)]);
var inst_12891__$1 = (state_12909[(2)]);
var inst_12892 = (inst_12891__$1 == null);
var inst_12893 = cljs.core.not(inst_12892);
var state_12909__$1 = (function (){var statearr_12911 = state_12909;
(statearr_12911[(7)] = inst_12891__$1);

return statearr_12911;
})();
if(inst_12893){
var statearr_12912_12932 = state_12909__$1;
(statearr_12912_12932[(1)] = (8));

} else {
var statearr_12913_12933 = state_12909__$1;
(statearr_12913_12933[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12910 === (1))){
var inst_12886 = (0);
var state_12909__$1 = (function (){var statearr_12914 = state_12909;
(statearr_12914[(8)] = inst_12886);

return statearr_12914;
})();
var statearr_12915_12934 = state_12909__$1;
(statearr_12915_12934[(2)] = null);

(statearr_12915_12934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12910 === (4))){
var state_12909__$1 = state_12909;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12909__$1,(7),ch);
} else {
if((state_val_12910 === (6))){
var inst_12904 = (state_12909[(2)]);
var state_12909__$1 = state_12909;
var statearr_12916_12935 = state_12909__$1;
(statearr_12916_12935[(2)] = inst_12904);

(statearr_12916_12935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12910 === (3))){
var inst_12906 = (state_12909[(2)]);
var inst_12907 = cljs.core.async.close_BANG_(out);
var state_12909__$1 = (function (){var statearr_12917 = state_12909;
(statearr_12917[(9)] = inst_12906);

return statearr_12917;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_12909__$1,inst_12907);
} else {
if((state_val_12910 === (2))){
var inst_12886 = (state_12909[(8)]);
var inst_12888 = (inst_12886 < n);
var state_12909__$1 = state_12909;
if(cljs.core.truth_(inst_12888)){
var statearr_12918_12936 = state_12909__$1;
(statearr_12918_12936[(1)] = (4));

} else {
var statearr_12919_12937 = state_12909__$1;
(statearr_12919_12937[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12910 === (11))){
var inst_12886 = (state_12909[(8)]);
var inst_12896 = (state_12909[(2)]);
var inst_12897 = (inst_12886 + (1));
var inst_12886__$1 = inst_12897;
var state_12909__$1 = (function (){var statearr_12920 = state_12909;
(statearr_12920[(10)] = inst_12896);

(statearr_12920[(8)] = inst_12886__$1);

return statearr_12920;
})();
var statearr_12921_12938 = state_12909__$1;
(statearr_12921_12938[(2)] = null);

(statearr_12921_12938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12910 === (9))){
var state_12909__$1 = state_12909;
var statearr_12922_12939 = state_12909__$1;
(statearr_12922_12939[(2)] = null);

(statearr_12922_12939[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12910 === (5))){
var state_12909__$1 = state_12909;
var statearr_12923_12940 = state_12909__$1;
(statearr_12923_12940[(2)] = null);

(statearr_12923_12940[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12910 === (10))){
var inst_12901 = (state_12909[(2)]);
var state_12909__$1 = state_12909;
var statearr_12924_12941 = state_12909__$1;
(statearr_12924_12941[(2)] = inst_12901);

(statearr_12924_12941[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12910 === (8))){
var inst_12891 = (state_12909[(7)]);
var state_12909__$1 = state_12909;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12909__$1,(11),out,inst_12891);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11396__auto__ = null;
var cljs$core$async$state_machine__11396__auto____0 = (function (){
var statearr_12925 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12925[(0)] = cljs$core$async$state_machine__11396__auto__);

(statearr_12925[(1)] = (1));

return statearr_12925;
});
var cljs$core$async$state_machine__11396__auto____1 = (function (state_12909){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_12909);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e12926){var ex__11399__auto__ = e12926;
var statearr_12927_12942 = state_12909;
(statearr_12927_12942[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_12909[(4)]))){
var statearr_12928_12943 = state_12909;
(statearr_12928_12943[(1)] = cljs.core.first((state_12909[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12944 = state_12909;
state_12909 = G__12944;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$state_machine__11396__auto__ = function(state_12909){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11396__auto____1.call(this,state_12909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11396__auto____0;
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11396__auto____1;
return cljs$core$async$state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_12929 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_12929[(6)] = c__11470__auto___12931);

return statearr_12929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12946 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12946 = (function (f,ch,meta12947){
this.f = f;
this.ch = ch;
this.meta12947 = meta12947;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12946.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12948,meta12947__$1){
var self__ = this;
var _12948__$1 = this;
return (new cljs.core.async.t_cljs$core$async12946(self__.f,self__.ch,meta12947__$1));
}));

(cljs.core.async.t_cljs$core$async12946.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12948){
var self__ = this;
var _12948__$1 = this;
return self__.meta12947;
}));

(cljs.core.async.t_cljs$core$async12946.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12946.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12946.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12946.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12946.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12949 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12949 = (function (f,ch,meta12947,_,fn1,meta12950){
this.f = f;
this.ch = ch;
this.meta12947 = meta12947;
this._ = _;
this.fn1 = fn1;
this.meta12950 = meta12950;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12949.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12951,meta12950__$1){
var self__ = this;
var _12951__$1 = this;
return (new cljs.core.async.t_cljs$core$async12949(self__.f,self__.ch,self__.meta12947,self__._,self__.fn1,meta12950__$1));
}));

(cljs.core.async.t_cljs$core$async12949.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12951){
var self__ = this;
var _12951__$1 = this;
return self__.meta12950;
}));

(cljs.core.async.t_cljs$core$async12949.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12949.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async12949.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12949.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__12945_SHARP_){
var G__12952 = (((p1__12945_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__12945_SHARP_) : self__.f.call(null,p1__12945_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__12952) : f1.call(null,G__12952));
});
}));

(cljs.core.async.t_cljs$core$async12949.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12947","meta12947",1038307721,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async12946","cljs.core.async/t_cljs$core$async12946",2090062009,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta12950","meta12950",652053530,null)], null);
}));

(cljs.core.async.t_cljs$core$async12949.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12949.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12949");

(cljs.core.async.t_cljs$core$async12949.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async12949");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12949.
 */
cljs.core.async.__GT_t_cljs$core$async12949 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12949(f__$1,ch__$1,meta12947__$1,___$2,fn1__$1,meta12950){
return (new cljs.core.async.t_cljs$core$async12949(f__$1,ch__$1,meta12947__$1,___$2,fn1__$1,meta12950));
});

}

return (new cljs.core.async.t_cljs$core$async12949(self__.f,self__.ch,self__.meta12947,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4251__auto__ = ret;
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__12953 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__12953) : self__.f.call(null,G__12953));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async12946.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12946.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async12946.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12947","meta12947",1038307721,null)], null);
}));

(cljs.core.async.t_cljs$core$async12946.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12946.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12946");

(cljs.core.async.t_cljs$core$async12946.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async12946");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12946.
 */
cljs.core.async.__GT_t_cljs$core$async12946 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12946(f__$1,ch__$1,meta12947){
return (new cljs.core.async.t_cljs$core$async12946(f__$1,ch__$1,meta12947));
});

}

return (new cljs.core.async.t_cljs$core$async12946(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12954 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12954 = (function (f,ch,meta12955){
this.f = f;
this.ch = ch;
this.meta12955 = meta12955;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12954.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12956,meta12955__$1){
var self__ = this;
var _12956__$1 = this;
return (new cljs.core.async.t_cljs$core$async12954(self__.f,self__.ch,meta12955__$1));
}));

(cljs.core.async.t_cljs$core$async12954.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12956){
var self__ = this;
var _12956__$1 = this;
return self__.meta12955;
}));

(cljs.core.async.t_cljs$core$async12954.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12954.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12954.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12954.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12954.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12954.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async12954.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12955","meta12955",-1463071323,null)], null);
}));

(cljs.core.async.t_cljs$core$async12954.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12954.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12954");

(cljs.core.async.t_cljs$core$async12954.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async12954");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12954.
 */
cljs.core.async.__GT_t_cljs$core$async12954 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async12954(f__$1,ch__$1,meta12955){
return (new cljs.core.async.t_cljs$core$async12954(f__$1,ch__$1,meta12955));
});

}

return (new cljs.core.async.t_cljs$core$async12954(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12957 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12957 = (function (p,ch,meta12958){
this.p = p;
this.ch = ch;
this.meta12958 = meta12958;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12957.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12959,meta12958__$1){
var self__ = this;
var _12959__$1 = this;
return (new cljs.core.async.t_cljs$core$async12957(self__.p,self__.ch,meta12958__$1));
}));

(cljs.core.async.t_cljs$core$async12957.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12959){
var self__ = this;
var _12959__$1 = this;
return self__.meta12958;
}));

(cljs.core.async.t_cljs$core$async12957.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12957.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12957.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async12957.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12957.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12957.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12957.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async12957.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12958","meta12958",880860667,null)], null);
}));

(cljs.core.async.t_cljs$core$async12957.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12957.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12957");

(cljs.core.async.t_cljs$core$async12957.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async12957");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12957.
 */
cljs.core.async.__GT_t_cljs$core$async12957 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async12957(p__$1,ch__$1,meta12958){
return (new cljs.core.async.t_cljs$core$async12957(p__$1,ch__$1,meta12958));
});

}

return (new cljs.core.async.t_cljs$core$async12957(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__12961 = arguments.length;
switch (G__12961) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11470__auto___13002 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_12982){
var state_val_12983 = (state_12982[(1)]);
if((state_val_12983 === (7))){
var inst_12978 = (state_12982[(2)]);
var state_12982__$1 = state_12982;
var statearr_12984_13003 = state_12982__$1;
(statearr_12984_13003[(2)] = inst_12978);

(statearr_12984_13003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12983 === (1))){
var state_12982__$1 = state_12982;
var statearr_12985_13004 = state_12982__$1;
(statearr_12985_13004[(2)] = null);

(statearr_12985_13004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12983 === (4))){
var inst_12964 = (state_12982[(7)]);
var inst_12964__$1 = (state_12982[(2)]);
var inst_12965 = (inst_12964__$1 == null);
var state_12982__$1 = (function (){var statearr_12986 = state_12982;
(statearr_12986[(7)] = inst_12964__$1);

return statearr_12986;
})();
if(cljs.core.truth_(inst_12965)){
var statearr_12987_13005 = state_12982__$1;
(statearr_12987_13005[(1)] = (5));

} else {
var statearr_12988_13006 = state_12982__$1;
(statearr_12988_13006[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12983 === (6))){
var inst_12964 = (state_12982[(7)]);
var inst_12969 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_12964) : p.call(null,inst_12964));
var state_12982__$1 = state_12982;
if(cljs.core.truth_(inst_12969)){
var statearr_12989_13007 = state_12982__$1;
(statearr_12989_13007[(1)] = (8));

} else {
var statearr_12990_13008 = state_12982__$1;
(statearr_12990_13008[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12983 === (3))){
var inst_12980 = (state_12982[(2)]);
var state_12982__$1 = state_12982;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12982__$1,inst_12980);
} else {
if((state_val_12983 === (2))){
var state_12982__$1 = state_12982;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12982__$1,(4),ch);
} else {
if((state_val_12983 === (11))){
var inst_12972 = (state_12982[(2)]);
var state_12982__$1 = state_12982;
var statearr_12991_13009 = state_12982__$1;
(statearr_12991_13009[(2)] = inst_12972);

(statearr_12991_13009[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12983 === (9))){
var state_12982__$1 = state_12982;
var statearr_12992_13010 = state_12982__$1;
(statearr_12992_13010[(2)] = null);

(statearr_12992_13010[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12983 === (5))){
var inst_12967 = cljs.core.async.close_BANG_(out);
var state_12982__$1 = state_12982;
var statearr_12993_13011 = state_12982__$1;
(statearr_12993_13011[(2)] = inst_12967);

(statearr_12993_13011[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12983 === (10))){
var inst_12975 = (state_12982[(2)]);
var state_12982__$1 = (function (){var statearr_12994 = state_12982;
(statearr_12994[(8)] = inst_12975);

return statearr_12994;
})();
var statearr_12995_13012 = state_12982__$1;
(statearr_12995_13012[(2)] = null);

(statearr_12995_13012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12983 === (8))){
var inst_12964 = (state_12982[(7)]);
var state_12982__$1 = state_12982;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12982__$1,(11),out,inst_12964);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11396__auto__ = null;
var cljs$core$async$state_machine__11396__auto____0 = (function (){
var statearr_12996 = [null,null,null,null,null,null,null,null,null];
(statearr_12996[(0)] = cljs$core$async$state_machine__11396__auto__);

(statearr_12996[(1)] = (1));

return statearr_12996;
});
var cljs$core$async$state_machine__11396__auto____1 = (function (state_12982){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_12982);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e12997){var ex__11399__auto__ = e12997;
var statearr_12998_13013 = state_12982;
(statearr_12998_13013[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_12982[(4)]))){
var statearr_12999_13014 = state_12982;
(statearr_12999_13014[(1)] = cljs.core.first((state_12982[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13015 = state_12982;
state_12982 = G__13015;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$state_machine__11396__auto__ = function(state_12982){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11396__auto____1.call(this,state_12982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11396__auto____0;
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11396__auto____1;
return cljs$core$async$state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_13000 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_13000[(6)] = c__11470__auto___13002);

return statearr_13000;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__13017 = arguments.length;
switch (G__13017) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11470__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_13080){
var state_val_13081 = (state_13080[(1)]);
if((state_val_13081 === (7))){
var inst_13076 = (state_13080[(2)]);
var state_13080__$1 = state_13080;
var statearr_13082_13121 = state_13080__$1;
(statearr_13082_13121[(2)] = inst_13076);

(statearr_13082_13121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (20))){
var inst_13046 = (state_13080[(7)]);
var inst_13057 = (state_13080[(2)]);
var inst_13058 = cljs.core.next(inst_13046);
var inst_13032 = inst_13058;
var inst_13033 = null;
var inst_13034 = (0);
var inst_13035 = (0);
var state_13080__$1 = (function (){var statearr_13083 = state_13080;
(statearr_13083[(8)] = inst_13057);

(statearr_13083[(9)] = inst_13033);

(statearr_13083[(10)] = inst_13032);

(statearr_13083[(11)] = inst_13035);

(statearr_13083[(12)] = inst_13034);

return statearr_13083;
})();
var statearr_13084_13122 = state_13080__$1;
(statearr_13084_13122[(2)] = null);

(statearr_13084_13122[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (1))){
var state_13080__$1 = state_13080;
var statearr_13085_13123 = state_13080__$1;
(statearr_13085_13123[(2)] = null);

(statearr_13085_13123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (4))){
var inst_13021 = (state_13080[(13)]);
var inst_13021__$1 = (state_13080[(2)]);
var inst_13022 = (inst_13021__$1 == null);
var state_13080__$1 = (function (){var statearr_13086 = state_13080;
(statearr_13086[(13)] = inst_13021__$1);

return statearr_13086;
})();
if(cljs.core.truth_(inst_13022)){
var statearr_13087_13124 = state_13080__$1;
(statearr_13087_13124[(1)] = (5));

} else {
var statearr_13088_13125 = state_13080__$1;
(statearr_13088_13125[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (15))){
var state_13080__$1 = state_13080;
var statearr_13092_13126 = state_13080__$1;
(statearr_13092_13126[(2)] = null);

(statearr_13092_13126[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (21))){
var state_13080__$1 = state_13080;
var statearr_13093_13127 = state_13080__$1;
(statearr_13093_13127[(2)] = null);

(statearr_13093_13127[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (13))){
var inst_13033 = (state_13080[(9)]);
var inst_13032 = (state_13080[(10)]);
var inst_13035 = (state_13080[(11)]);
var inst_13034 = (state_13080[(12)]);
var inst_13042 = (state_13080[(2)]);
var inst_13043 = (inst_13035 + (1));
var tmp13089 = inst_13033;
var tmp13090 = inst_13032;
var tmp13091 = inst_13034;
var inst_13032__$1 = tmp13090;
var inst_13033__$1 = tmp13089;
var inst_13034__$1 = tmp13091;
var inst_13035__$1 = inst_13043;
var state_13080__$1 = (function (){var statearr_13094 = state_13080;
(statearr_13094[(14)] = inst_13042);

(statearr_13094[(9)] = inst_13033__$1);

(statearr_13094[(10)] = inst_13032__$1);

(statearr_13094[(11)] = inst_13035__$1);

(statearr_13094[(12)] = inst_13034__$1);

return statearr_13094;
})();
var statearr_13095_13128 = state_13080__$1;
(statearr_13095_13128[(2)] = null);

(statearr_13095_13128[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (22))){
var state_13080__$1 = state_13080;
var statearr_13096_13129 = state_13080__$1;
(statearr_13096_13129[(2)] = null);

(statearr_13096_13129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (6))){
var inst_13021 = (state_13080[(13)]);
var inst_13030 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_13021) : f.call(null,inst_13021));
var inst_13031 = cljs.core.seq(inst_13030);
var inst_13032 = inst_13031;
var inst_13033 = null;
var inst_13034 = (0);
var inst_13035 = (0);
var state_13080__$1 = (function (){var statearr_13097 = state_13080;
(statearr_13097[(9)] = inst_13033);

(statearr_13097[(10)] = inst_13032);

(statearr_13097[(11)] = inst_13035);

(statearr_13097[(12)] = inst_13034);

return statearr_13097;
})();
var statearr_13098_13130 = state_13080__$1;
(statearr_13098_13130[(2)] = null);

(statearr_13098_13130[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (17))){
var inst_13046 = (state_13080[(7)]);
var inst_13050 = cljs.core.chunk_first(inst_13046);
var inst_13051 = cljs.core.chunk_rest(inst_13046);
var inst_13052 = cljs.core.count(inst_13050);
var inst_13032 = inst_13051;
var inst_13033 = inst_13050;
var inst_13034 = inst_13052;
var inst_13035 = (0);
var state_13080__$1 = (function (){var statearr_13099 = state_13080;
(statearr_13099[(9)] = inst_13033);

(statearr_13099[(10)] = inst_13032);

(statearr_13099[(11)] = inst_13035);

(statearr_13099[(12)] = inst_13034);

return statearr_13099;
})();
var statearr_13100_13131 = state_13080__$1;
(statearr_13100_13131[(2)] = null);

(statearr_13100_13131[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (3))){
var inst_13078 = (state_13080[(2)]);
var state_13080__$1 = state_13080;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13080__$1,inst_13078);
} else {
if((state_val_13081 === (12))){
var inst_13066 = (state_13080[(2)]);
var state_13080__$1 = state_13080;
var statearr_13101_13132 = state_13080__$1;
(statearr_13101_13132[(2)] = inst_13066);

(statearr_13101_13132[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (2))){
var state_13080__$1 = state_13080;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13080__$1,(4),in$);
} else {
if((state_val_13081 === (23))){
var inst_13074 = (state_13080[(2)]);
var state_13080__$1 = state_13080;
var statearr_13102_13133 = state_13080__$1;
(statearr_13102_13133[(2)] = inst_13074);

(statearr_13102_13133[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (19))){
var inst_13061 = (state_13080[(2)]);
var state_13080__$1 = state_13080;
var statearr_13103_13134 = state_13080__$1;
(statearr_13103_13134[(2)] = inst_13061);

(statearr_13103_13134[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (11))){
var inst_13032 = (state_13080[(10)]);
var inst_13046 = (state_13080[(7)]);
var inst_13046__$1 = cljs.core.seq(inst_13032);
var state_13080__$1 = (function (){var statearr_13104 = state_13080;
(statearr_13104[(7)] = inst_13046__$1);

return statearr_13104;
})();
if(inst_13046__$1){
var statearr_13105_13135 = state_13080__$1;
(statearr_13105_13135[(1)] = (14));

} else {
var statearr_13106_13136 = state_13080__$1;
(statearr_13106_13136[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (9))){
var inst_13068 = (state_13080[(2)]);
var inst_13069 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_13080__$1 = (function (){var statearr_13107 = state_13080;
(statearr_13107[(15)] = inst_13068);

return statearr_13107;
})();
if(cljs.core.truth_(inst_13069)){
var statearr_13108_13137 = state_13080__$1;
(statearr_13108_13137[(1)] = (21));

} else {
var statearr_13109_13138 = state_13080__$1;
(statearr_13109_13138[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (5))){
var inst_13024 = cljs.core.async.close_BANG_(out);
var state_13080__$1 = state_13080;
var statearr_13110_13139 = state_13080__$1;
(statearr_13110_13139[(2)] = inst_13024);

(statearr_13110_13139[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (14))){
var inst_13046 = (state_13080[(7)]);
var inst_13048 = cljs.core.chunked_seq_QMARK_(inst_13046);
var state_13080__$1 = state_13080;
if(inst_13048){
var statearr_13111_13140 = state_13080__$1;
(statearr_13111_13140[(1)] = (17));

} else {
var statearr_13112_13141 = state_13080__$1;
(statearr_13112_13141[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (16))){
var inst_13064 = (state_13080[(2)]);
var state_13080__$1 = state_13080;
var statearr_13113_13142 = state_13080__$1;
(statearr_13113_13142[(2)] = inst_13064);

(statearr_13113_13142[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13081 === (10))){
var inst_13033 = (state_13080[(9)]);
var inst_13035 = (state_13080[(11)]);
var inst_13040 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_13033,inst_13035);
var state_13080__$1 = state_13080;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13080__$1,(13),out,inst_13040);
} else {
if((state_val_13081 === (18))){
var inst_13046 = (state_13080[(7)]);
var inst_13055 = cljs.core.first(inst_13046);
var state_13080__$1 = state_13080;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13080__$1,(20),out,inst_13055);
} else {
if((state_val_13081 === (8))){
var inst_13035 = (state_13080[(11)]);
var inst_13034 = (state_13080[(12)]);
var inst_13037 = (inst_13035 < inst_13034);
var inst_13038 = inst_13037;
var state_13080__$1 = state_13080;
if(cljs.core.truth_(inst_13038)){
var statearr_13114_13143 = state_13080__$1;
(statearr_13114_13143[(1)] = (10));

} else {
var statearr_13115_13144 = state_13080__$1;
(statearr_13115_13144[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11396__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11396__auto____0 = (function (){
var statearr_13116 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13116[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11396__auto__);

(statearr_13116[(1)] = (1));

return statearr_13116;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11396__auto____1 = (function (state_13080){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_13080);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e13117){var ex__11399__auto__ = e13117;
var statearr_13118_13145 = state_13080;
(statearr_13118_13145[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_13080[(4)]))){
var statearr_13119_13146 = state_13080;
(statearr_13119_13146[(1)] = cljs.core.first((state_13080[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13147 = state_13080;
state_13080 = G__13147;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11396__auto__ = function(state_13080){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11396__auto____1.call(this,state_13080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11396__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11396__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_13120 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_13120[(6)] = c__11470__auto__);

return statearr_13120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));

return c__11470__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__13149 = arguments.length;
switch (G__13149) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__13152 = arguments.length;
switch (G__13152) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__13155 = arguments.length;
switch (G__13155) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11470__auto___13203 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_13179){
var state_val_13180 = (state_13179[(1)]);
if((state_val_13180 === (7))){
var inst_13174 = (state_13179[(2)]);
var state_13179__$1 = state_13179;
var statearr_13181_13204 = state_13179__$1;
(statearr_13181_13204[(2)] = inst_13174);

(statearr_13181_13204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13180 === (1))){
var inst_13156 = null;
var state_13179__$1 = (function (){var statearr_13182 = state_13179;
(statearr_13182[(7)] = inst_13156);

return statearr_13182;
})();
var statearr_13183_13205 = state_13179__$1;
(statearr_13183_13205[(2)] = null);

(statearr_13183_13205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13180 === (4))){
var inst_13159 = (state_13179[(8)]);
var inst_13159__$1 = (state_13179[(2)]);
var inst_13160 = (inst_13159__$1 == null);
var inst_13161 = cljs.core.not(inst_13160);
var state_13179__$1 = (function (){var statearr_13184 = state_13179;
(statearr_13184[(8)] = inst_13159__$1);

return statearr_13184;
})();
if(inst_13161){
var statearr_13185_13206 = state_13179__$1;
(statearr_13185_13206[(1)] = (5));

} else {
var statearr_13186_13207 = state_13179__$1;
(statearr_13186_13207[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13180 === (6))){
var state_13179__$1 = state_13179;
var statearr_13187_13208 = state_13179__$1;
(statearr_13187_13208[(2)] = null);

(statearr_13187_13208[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13180 === (3))){
var inst_13176 = (state_13179[(2)]);
var inst_13177 = cljs.core.async.close_BANG_(out);
var state_13179__$1 = (function (){var statearr_13188 = state_13179;
(statearr_13188[(9)] = inst_13176);

return statearr_13188;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_13179__$1,inst_13177);
} else {
if((state_val_13180 === (2))){
var state_13179__$1 = state_13179;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13179__$1,(4),ch);
} else {
if((state_val_13180 === (11))){
var inst_13159 = (state_13179[(8)]);
var inst_13168 = (state_13179[(2)]);
var inst_13156 = inst_13159;
var state_13179__$1 = (function (){var statearr_13189 = state_13179;
(statearr_13189[(7)] = inst_13156);

(statearr_13189[(10)] = inst_13168);

return statearr_13189;
})();
var statearr_13190_13209 = state_13179__$1;
(statearr_13190_13209[(2)] = null);

(statearr_13190_13209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13180 === (9))){
var inst_13159 = (state_13179[(8)]);
var state_13179__$1 = state_13179;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13179__$1,(11),out,inst_13159);
} else {
if((state_val_13180 === (5))){
var inst_13159 = (state_13179[(8)]);
var inst_13156 = (state_13179[(7)]);
var inst_13163 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13159,inst_13156);
var state_13179__$1 = state_13179;
if(inst_13163){
var statearr_13192_13210 = state_13179__$1;
(statearr_13192_13210[(1)] = (8));

} else {
var statearr_13193_13211 = state_13179__$1;
(statearr_13193_13211[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13180 === (10))){
var inst_13171 = (state_13179[(2)]);
var state_13179__$1 = state_13179;
var statearr_13194_13212 = state_13179__$1;
(statearr_13194_13212[(2)] = inst_13171);

(statearr_13194_13212[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13180 === (8))){
var inst_13156 = (state_13179[(7)]);
var tmp13191 = inst_13156;
var inst_13156__$1 = tmp13191;
var state_13179__$1 = (function (){var statearr_13195 = state_13179;
(statearr_13195[(7)] = inst_13156__$1);

return statearr_13195;
})();
var statearr_13196_13213 = state_13179__$1;
(statearr_13196_13213[(2)] = null);

(statearr_13196_13213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11396__auto__ = null;
var cljs$core$async$state_machine__11396__auto____0 = (function (){
var statearr_13197 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13197[(0)] = cljs$core$async$state_machine__11396__auto__);

(statearr_13197[(1)] = (1));

return statearr_13197;
});
var cljs$core$async$state_machine__11396__auto____1 = (function (state_13179){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_13179);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e13198){var ex__11399__auto__ = e13198;
var statearr_13199_13214 = state_13179;
(statearr_13199_13214[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_13179[(4)]))){
var statearr_13200_13215 = state_13179;
(statearr_13200_13215[(1)] = cljs.core.first((state_13179[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13216 = state_13179;
state_13179 = G__13216;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$state_machine__11396__auto__ = function(state_13179){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11396__auto____1.call(this,state_13179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11396__auto____0;
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11396__auto____1;
return cljs$core$async$state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_13201 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_13201[(6)] = c__11470__auto___13203);

return statearr_13201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__13218 = arguments.length;
switch (G__13218) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11470__auto___13285 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_13256){
var state_val_13257 = (state_13256[(1)]);
if((state_val_13257 === (7))){
var inst_13252 = (state_13256[(2)]);
var state_13256__$1 = state_13256;
var statearr_13258_13286 = state_13256__$1;
(statearr_13258_13286[(2)] = inst_13252);

(statearr_13258_13286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13257 === (1))){
var inst_13219 = (new Array(n));
var inst_13220 = inst_13219;
var inst_13221 = (0);
var state_13256__$1 = (function (){var statearr_13259 = state_13256;
(statearr_13259[(7)] = inst_13221);

(statearr_13259[(8)] = inst_13220);

return statearr_13259;
})();
var statearr_13260_13287 = state_13256__$1;
(statearr_13260_13287[(2)] = null);

(statearr_13260_13287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13257 === (4))){
var inst_13224 = (state_13256[(9)]);
var inst_13224__$1 = (state_13256[(2)]);
var inst_13225 = (inst_13224__$1 == null);
var inst_13226 = cljs.core.not(inst_13225);
var state_13256__$1 = (function (){var statearr_13261 = state_13256;
(statearr_13261[(9)] = inst_13224__$1);

return statearr_13261;
})();
if(inst_13226){
var statearr_13262_13288 = state_13256__$1;
(statearr_13262_13288[(1)] = (5));

} else {
var statearr_13263_13289 = state_13256__$1;
(statearr_13263_13289[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13257 === (15))){
var inst_13246 = (state_13256[(2)]);
var state_13256__$1 = state_13256;
var statearr_13264_13290 = state_13256__$1;
(statearr_13264_13290[(2)] = inst_13246);

(statearr_13264_13290[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13257 === (13))){
var state_13256__$1 = state_13256;
var statearr_13265_13291 = state_13256__$1;
(statearr_13265_13291[(2)] = null);

(statearr_13265_13291[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13257 === (6))){
var inst_13221 = (state_13256[(7)]);
var inst_13242 = (inst_13221 > (0));
var state_13256__$1 = state_13256;
if(cljs.core.truth_(inst_13242)){
var statearr_13266_13292 = state_13256__$1;
(statearr_13266_13292[(1)] = (12));

} else {
var statearr_13267_13293 = state_13256__$1;
(statearr_13267_13293[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13257 === (3))){
var inst_13254 = (state_13256[(2)]);
var state_13256__$1 = state_13256;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13256__$1,inst_13254);
} else {
if((state_val_13257 === (12))){
var inst_13220 = (state_13256[(8)]);
var inst_13244 = cljs.core.vec(inst_13220);
var state_13256__$1 = state_13256;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13256__$1,(15),out,inst_13244);
} else {
if((state_val_13257 === (2))){
var state_13256__$1 = state_13256;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13256__$1,(4),ch);
} else {
if((state_val_13257 === (11))){
var inst_13236 = (state_13256[(2)]);
var inst_13237 = (new Array(n));
var inst_13220 = inst_13237;
var inst_13221 = (0);
var state_13256__$1 = (function (){var statearr_13268 = state_13256;
(statearr_13268[(10)] = inst_13236);

(statearr_13268[(7)] = inst_13221);

(statearr_13268[(8)] = inst_13220);

return statearr_13268;
})();
var statearr_13269_13294 = state_13256__$1;
(statearr_13269_13294[(2)] = null);

(statearr_13269_13294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13257 === (9))){
var inst_13220 = (state_13256[(8)]);
var inst_13234 = cljs.core.vec(inst_13220);
var state_13256__$1 = state_13256;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13256__$1,(11),out,inst_13234);
} else {
if((state_val_13257 === (5))){
var inst_13221 = (state_13256[(7)]);
var inst_13229 = (state_13256[(11)]);
var inst_13220 = (state_13256[(8)]);
var inst_13224 = (state_13256[(9)]);
var inst_13228 = (inst_13220[inst_13221] = inst_13224);
var inst_13229__$1 = (inst_13221 + (1));
var inst_13230 = (inst_13229__$1 < n);
var state_13256__$1 = (function (){var statearr_13270 = state_13256;
(statearr_13270[(11)] = inst_13229__$1);

(statearr_13270[(12)] = inst_13228);

return statearr_13270;
})();
if(cljs.core.truth_(inst_13230)){
var statearr_13271_13295 = state_13256__$1;
(statearr_13271_13295[(1)] = (8));

} else {
var statearr_13272_13296 = state_13256__$1;
(statearr_13272_13296[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13257 === (14))){
var inst_13249 = (state_13256[(2)]);
var inst_13250 = cljs.core.async.close_BANG_(out);
var state_13256__$1 = (function (){var statearr_13274 = state_13256;
(statearr_13274[(13)] = inst_13249);

return statearr_13274;
})();
var statearr_13275_13297 = state_13256__$1;
(statearr_13275_13297[(2)] = inst_13250);

(statearr_13275_13297[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13257 === (10))){
var inst_13240 = (state_13256[(2)]);
var state_13256__$1 = state_13256;
var statearr_13276_13298 = state_13256__$1;
(statearr_13276_13298[(2)] = inst_13240);

(statearr_13276_13298[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13257 === (8))){
var inst_13229 = (state_13256[(11)]);
var inst_13220 = (state_13256[(8)]);
var tmp13273 = inst_13220;
var inst_13220__$1 = tmp13273;
var inst_13221 = inst_13229;
var state_13256__$1 = (function (){var statearr_13277 = state_13256;
(statearr_13277[(7)] = inst_13221);

(statearr_13277[(8)] = inst_13220__$1);

return statearr_13277;
})();
var statearr_13278_13299 = state_13256__$1;
(statearr_13278_13299[(2)] = null);

(statearr_13278_13299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11396__auto__ = null;
var cljs$core$async$state_machine__11396__auto____0 = (function (){
var statearr_13279 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13279[(0)] = cljs$core$async$state_machine__11396__auto__);

(statearr_13279[(1)] = (1));

return statearr_13279;
});
var cljs$core$async$state_machine__11396__auto____1 = (function (state_13256){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_13256);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e13280){var ex__11399__auto__ = e13280;
var statearr_13281_13300 = state_13256;
(statearr_13281_13300[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_13256[(4)]))){
var statearr_13282_13301 = state_13256;
(statearr_13282_13301[(1)] = cljs.core.first((state_13256[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13302 = state_13256;
state_13256 = G__13302;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$state_machine__11396__auto__ = function(state_13256){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11396__auto____1.call(this,state_13256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11396__auto____0;
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11396__auto____1;
return cljs$core$async$state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_13283 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_13283[(6)] = c__11470__auto___13285);

return statearr_13283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__13304 = arguments.length;
switch (G__13304) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11470__auto___13382 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11471__auto__ = (function (){var switch__11395__auto__ = (function (state_13349){
var state_val_13350 = (state_13349[(1)]);
if((state_val_13350 === (7))){
var inst_13345 = (state_13349[(2)]);
var state_13349__$1 = state_13349;
var statearr_13351_13383 = state_13349__$1;
(statearr_13351_13383[(2)] = inst_13345);

(statearr_13351_13383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13350 === (1))){
var inst_13305 = [];
var inst_13306 = inst_13305;
var inst_13307 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13349__$1 = (function (){var statearr_13352 = state_13349;
(statearr_13352[(7)] = inst_13307);

(statearr_13352[(8)] = inst_13306);

return statearr_13352;
})();
var statearr_13353_13384 = state_13349__$1;
(statearr_13353_13384[(2)] = null);

(statearr_13353_13384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13350 === (4))){
var inst_13310 = (state_13349[(9)]);
var inst_13310__$1 = (state_13349[(2)]);
var inst_13311 = (inst_13310__$1 == null);
var inst_13312 = cljs.core.not(inst_13311);
var state_13349__$1 = (function (){var statearr_13354 = state_13349;
(statearr_13354[(9)] = inst_13310__$1);

return statearr_13354;
})();
if(inst_13312){
var statearr_13355_13385 = state_13349__$1;
(statearr_13355_13385[(1)] = (5));

} else {
var statearr_13356_13386 = state_13349__$1;
(statearr_13356_13386[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13350 === (15))){
var inst_13306 = (state_13349[(8)]);
var inst_13337 = cljs.core.vec(inst_13306);
var state_13349__$1 = state_13349;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13349__$1,(18),out,inst_13337);
} else {
if((state_val_13350 === (13))){
var inst_13332 = (state_13349[(2)]);
var state_13349__$1 = state_13349;
var statearr_13357_13387 = state_13349__$1;
(statearr_13357_13387[(2)] = inst_13332);

(statearr_13357_13387[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13350 === (6))){
var inst_13306 = (state_13349[(8)]);
var inst_13334 = inst_13306.length;
var inst_13335 = (inst_13334 > (0));
var state_13349__$1 = state_13349;
if(cljs.core.truth_(inst_13335)){
var statearr_13358_13388 = state_13349__$1;
(statearr_13358_13388[(1)] = (15));

} else {
var statearr_13359_13389 = state_13349__$1;
(statearr_13359_13389[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13350 === (17))){
var inst_13342 = (state_13349[(2)]);
var inst_13343 = cljs.core.async.close_BANG_(out);
var state_13349__$1 = (function (){var statearr_13360 = state_13349;
(statearr_13360[(10)] = inst_13342);

return statearr_13360;
})();
var statearr_13361_13390 = state_13349__$1;
(statearr_13361_13390[(2)] = inst_13343);

(statearr_13361_13390[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13350 === (3))){
var inst_13347 = (state_13349[(2)]);
var state_13349__$1 = state_13349;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13349__$1,inst_13347);
} else {
if((state_val_13350 === (12))){
var inst_13306 = (state_13349[(8)]);
var inst_13325 = cljs.core.vec(inst_13306);
var state_13349__$1 = state_13349;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13349__$1,(14),out,inst_13325);
} else {
if((state_val_13350 === (2))){
var state_13349__$1 = state_13349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13349__$1,(4),ch);
} else {
if((state_val_13350 === (11))){
var inst_13306 = (state_13349[(8)]);
var inst_13310 = (state_13349[(9)]);
var inst_13314 = (state_13349[(11)]);
var inst_13322 = inst_13306.push(inst_13310);
var tmp13362 = inst_13306;
var inst_13306__$1 = tmp13362;
var inst_13307 = inst_13314;
var state_13349__$1 = (function (){var statearr_13363 = state_13349;
(statearr_13363[(7)] = inst_13307);

(statearr_13363[(8)] = inst_13306__$1);

(statearr_13363[(12)] = inst_13322);

return statearr_13363;
})();
var statearr_13364_13391 = state_13349__$1;
(statearr_13364_13391[(2)] = null);

(statearr_13364_13391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13350 === (9))){
var inst_13307 = (state_13349[(7)]);
var inst_13318 = cljs.core.keyword_identical_QMARK_(inst_13307,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_13349__$1 = state_13349;
var statearr_13365_13392 = state_13349__$1;
(statearr_13365_13392[(2)] = inst_13318);

(statearr_13365_13392[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13350 === (5))){
var inst_13315 = (state_13349[(13)]);
var inst_13307 = (state_13349[(7)]);
var inst_13310 = (state_13349[(9)]);
var inst_13314 = (state_13349[(11)]);
var inst_13314__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_13310) : f.call(null,inst_13310));
var inst_13315__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13314__$1,inst_13307);
var state_13349__$1 = (function (){var statearr_13366 = state_13349;
(statearr_13366[(13)] = inst_13315__$1);

(statearr_13366[(11)] = inst_13314__$1);

return statearr_13366;
})();
if(inst_13315__$1){
var statearr_13367_13393 = state_13349__$1;
(statearr_13367_13393[(1)] = (8));

} else {
var statearr_13368_13394 = state_13349__$1;
(statearr_13368_13394[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13350 === (14))){
var inst_13310 = (state_13349[(9)]);
var inst_13314 = (state_13349[(11)]);
var inst_13327 = (state_13349[(2)]);
var inst_13328 = [];
var inst_13329 = inst_13328.push(inst_13310);
var inst_13306 = inst_13328;
var inst_13307 = inst_13314;
var state_13349__$1 = (function (){var statearr_13369 = state_13349;
(statearr_13369[(7)] = inst_13307);

(statearr_13369[(8)] = inst_13306);

(statearr_13369[(14)] = inst_13329);

(statearr_13369[(15)] = inst_13327);

return statearr_13369;
})();
var statearr_13370_13395 = state_13349__$1;
(statearr_13370_13395[(2)] = null);

(statearr_13370_13395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13350 === (16))){
var state_13349__$1 = state_13349;
var statearr_13371_13396 = state_13349__$1;
(statearr_13371_13396[(2)] = null);

(statearr_13371_13396[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13350 === (10))){
var inst_13320 = (state_13349[(2)]);
var state_13349__$1 = state_13349;
if(cljs.core.truth_(inst_13320)){
var statearr_13372_13397 = state_13349__$1;
(statearr_13372_13397[(1)] = (11));

} else {
var statearr_13373_13398 = state_13349__$1;
(statearr_13373_13398[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13350 === (18))){
var inst_13339 = (state_13349[(2)]);
var state_13349__$1 = state_13349;
var statearr_13374_13399 = state_13349__$1;
(statearr_13374_13399[(2)] = inst_13339);

(statearr_13374_13399[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13350 === (8))){
var inst_13315 = (state_13349[(13)]);
var state_13349__$1 = state_13349;
var statearr_13375_13400 = state_13349__$1;
(statearr_13375_13400[(2)] = inst_13315);

(statearr_13375_13400[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11396__auto__ = null;
var cljs$core$async$state_machine__11396__auto____0 = (function (){
var statearr_13376 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13376[(0)] = cljs$core$async$state_machine__11396__auto__);

(statearr_13376[(1)] = (1));

return statearr_13376;
});
var cljs$core$async$state_machine__11396__auto____1 = (function (state_13349){
while(true){
var ret_value__11397__auto__ = (function (){try{while(true){
var result__11398__auto__ = switch__11395__auto__(state_13349);
if(cljs.core.keyword_identical_QMARK_(result__11398__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11398__auto__;
}
break;
}
}catch (e13377){var ex__11399__auto__ = e13377;
var statearr_13378_13401 = state_13349;
(statearr_13378_13401[(2)] = ex__11399__auto__);


if(cljs.core.seq((state_13349[(4)]))){
var statearr_13379_13402 = state_13349;
(statearr_13379_13402[(1)] = cljs.core.first((state_13349[(4)])));

} else {
throw ex__11399__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11397__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13403 = state_13349;
state_13349 = G__13403;
continue;
} else {
return ret_value__11397__auto__;
}
break;
}
});
cljs$core$async$state_machine__11396__auto__ = function(state_13349){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11396__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11396__auto____1.call(this,state_13349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11396__auto____0;
cljs$core$async$state_machine__11396__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11396__auto____1;
return cljs$core$async$state_machine__11396__auto__;
})()
})();
var state__11472__auto__ = (function (){var statearr_13380 = (f__11471__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11471__auto__.cljs$core$IFn$_invoke$arity$0() : f__11471__auto__.call(null));
(statearr_13380[(6)] = c__11470__auto___13382);

return statearr_13380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11472__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

