// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.query.fql_resp');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___73000 = arguments.length;
var i__4865__auto___73001 = (0);
while(true){
if((i__4865__auto___73001 < len__4864__auto___73000)){
args__4870__auto__.push((arguments[i__4865__auto___73001]));

var G__73002 = (i__4865__auto___73001 + (1));
i__4865__auto___73001 = G__73002;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__72929){
var vec__72930 = p__72929;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72930,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___73003 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72977){
var state_val_72978 = (state_72977[(1)]);
if((state_val_72978 === (7))){
var inst_72963 = (state_72977[(7)]);
var inst_72954 = (state_72977[(8)]);
var inst_72965 = fluree.db.time_travel.as_of_block(inst_72963,inst_72954);
var state_72977__$1 = state_72977;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72977__$1,(10),inst_72965);
} else {
if((state_val_72978 === (1))){
var state_72977__$1 = state_72977;
var statearr_72979_73004 = state_72977__$1;
(statearr_72979_73004[(2)] = null);

(statearr_72979_73004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (4))){
var inst_72933 = (state_72977[(2)]);
var inst_72934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72935 = [inst_72933];
var inst_72936 = (new cljs.core.PersistentVector(null,1,(5),inst_72934,inst_72935,null));
var inst_72937 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72936);
var inst_72938 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_72933);
var inst_72939 = cljs.core.async.close_BANG_(pc);
var state_72977__$1 = (function (){var statearr_72980 = state_72977;
(statearr_72980[(9)] = inst_72938);

(statearr_72980[(10)] = inst_72937);

return statearr_72980;
})();
var statearr_72981_73005 = state_72977__$1;
(statearr_72981_73005[(2)] = inst_72939);

(statearr_72981_73005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (6))){
var inst_72957 = (state_72977[(11)]);
var inst_72958 = (state_72977[(12)]);
var inst_72954 = (state_72977[(8)]);
var inst_72961 = (state_72977[(2)]);
var inst_72962 = fluree.db.util.async.throw_err(inst_72961);
var inst_72963 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_72962,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_72957,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_72958], 0));
var state_72977__$1 = (function (){var statearr_72982 = state_72977;
(statearr_72982[(7)] = inst_72963);

return statearr_72982;
})();
if(cljs.core.truth_(inst_72954)){
var statearr_72983_73006 = state_72977__$1;
(statearr_72983_73006[(1)] = (7));

} else {
var statearr_72984_73007 = state_72977__$1;
(statearr_72984_73007[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (3))){
var inst_72975 = (state_72977[(2)]);
var state_72977__$1 = state_72977;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72977__$1,inst_72975);
} else {
if((state_val_72978 === (2))){
var _ = (function (){var statearr_72986 = state_72977;
(statearr_72986[(4)] = cljs.core.cons((5),(state_72977[(4)])));

return statearr_72986;
})();
var inst_72949 = opts;
var inst_72950 = cljs.core.__destructure_map(inst_72949);
var inst_72951 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72950,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_72952 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72950,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_72953 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72950,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_72954 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72950,new cljs.core.Keyword(null,"block","block",664686210));
var inst_72955 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_72956 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_72957 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72956,(0),null);
var inst_72958 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72956,(1),null);
var inst_72959 = fluree.db.session.db(conn,ledger,opts);
var state_72977__$1 = (function (){var statearr_72987 = state_72977;
(statearr_72987[(13)] = inst_72953);

(statearr_72987[(14)] = inst_72951);

(statearr_72987[(11)] = inst_72957);

(statearr_72987[(15)] = inst_72955);

(statearr_72987[(16)] = inst_72952);

(statearr_72987[(12)] = inst_72958);

(statearr_72987[(8)] = inst_72954);

return statearr_72987;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72977__$1,(6),inst_72959);
} else {
if((state_val_72978 === (9))){
var inst_72971 = (state_72977[(2)]);
var inst_72972 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_72971);
var _ = (function (){var statearr_72988 = state_72977;
(statearr_72988[(4)] = cljs.core.rest((state_72977[(4)])));

return statearr_72988;
})();
var state_72977__$1 = state_72977;
var statearr_72989_73008 = state_72977__$1;
(statearr_72989_73008[(2)] = inst_72972);

(statearr_72989_73008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (5))){
var _ = (function (){var statearr_72990 = state_72977;
(statearr_72990[(4)] = cljs.core.rest((state_72977[(4)])));

return statearr_72990;
})();
var state_72977__$1 = state_72977;
var ex72985 = (state_72977__$1[(2)]);
var statearr_72991_73009 = state_72977__$1;
(statearr_72991_73009[(5)] = ex72985);


var statearr_72992_73010 = state_72977__$1;
(statearr_72992_73010[(1)] = (4));

(statearr_72992_73010[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (10))){
var inst_72967 = (state_72977[(2)]);
var inst_72968 = fluree.db.util.async.throw_err(inst_72967);
var state_72977__$1 = state_72977;
var statearr_72993_73011 = state_72977__$1;
(statearr_72993_73011[(2)] = inst_72968);

(statearr_72993_73011[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (8))){
var inst_72963 = (state_72977[(7)]);
var state_72977__$1 = state_72977;
var statearr_72994_73012 = state_72977__$1;
(statearr_72994_73012[(2)] = inst_72963);

(statearr_72994_73012[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_72995 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72995[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_72995[(1)] = (1));

return statearr_72995;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_72977){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72977);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72996){var ex__2730__auto__ = e72996;
var statearr_72997_73013 = state_72977;
(statearr_72997_73013[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72977[(4)]))){
var statearr_72998_73014 = state_72977;
(statearr_72998_73014[(1)] = cljs.core.first((state_72977[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73015 = state_72977;
state_72977 = G__73015;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_72977){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_72977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72999 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72999[(6)] = c__2749__auto___73003);

return statearr_72999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq72926){
var G__72927 = cljs.core.first(seq72926);
var seq72926__$1 = cljs.core.next(seq72926);
var G__72928 = cljs.core.first(seq72926__$1);
var seq72926__$2 = cljs.core.next(seq72926__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72927,G__72928,seq72926__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(ledger_id){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
var and__4251__auto____$1 = open_api;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
return open_api;
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
return auth;
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__73017 = arguments.length;
switch (G__73017) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73146){
var state_val_73147 = (state_73146[(1)]);
if((state_val_73147 === (7))){
var inst_73046 = (state_73146[(7)]);
var inst_73036 = (state_73146[(8)]);
var inst_73048 = fluree.db.time_travel.as_of_block(inst_73046,inst_73036);
var state_73146__$1 = state_73146;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73146__$1,(10),inst_73048);
} else {
if((state_val_73147 === (20))){
var inst_73040 = (state_73146[(9)]);
var state_73146__$1 = state_73146;
var statearr_73148_73228 = state_73146__$1;
(statearr_73148_73228[(2)] = inst_73040);

(statearr_73148_73228[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (27))){
var inst_73034 = (state_73146[(10)]);
var state_73146__$1 = state_73146;
var statearr_73149_73229 = state_73146__$1;
(statearr_73149_73229[(2)] = inst_73034);

(statearr_73149_73229[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (1))){
var state_73146__$1 = state_73146;
var statearr_73150_73230 = state_73146__$1;
(statearr_73150_73230[(2)] = null);

(statearr_73150_73230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (24))){
var inst_73043 = (state_73146[(11)]);
var state_73146__$1 = state_73146;
if(cljs.core.truth_(inst_73043)){
var statearr_73151_73231 = state_73146__$1;
(statearr_73151_73231[(1)] = (26));

} else {
var statearr_73152_73232 = state_73146__$1;
(statearr_73152_73232[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (39))){
var inst_73108 = (state_73146[(12)]);
var inst_73111 = cljs.core.ex_data(inst_73108);
var inst_73112 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73113 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_73111);
var inst_73114 = cljs.core.ex_message(inst_73108);
var inst_73115 = [inst_73113,inst_73114,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73116 = cljs.core.PersistentHashMap.fromArrays(inst_73112,inst_73115);
var state_73146__$1 = state_73146;
var statearr_73153_73233 = state_73146__$1;
(statearr_73153_73233[(2)] = inst_73116);

(statearr_73153_73233[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (46))){
var inst_73108 = (state_73146[(12)]);
var state_73146__$1 = state_73146;
var statearr_73154_73234 = state_73146__$1;
(statearr_73154_73234[(2)] = inst_73108);

(statearr_73154_73234[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (4))){
var inst_73018 = (state_73146[(2)]);
var inst_73019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73020 = [inst_73018];
var inst_73021 = (new cljs.core.PersistentVector(null,1,(5),inst_73019,inst_73020,null));
var inst_73022 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73021);
var inst_73023 = cljs.core.ex_data(inst_73018);
var inst_73024 = cljs.core.ex_message(inst_73018);
var inst_73025 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73023,new cljs.core.Keyword(null,"message","message",-406056002),inst_73024);
var state_73146__$1 = (function (){var statearr_73155 = state_73146;
(statearr_73155[(13)] = inst_73022);

return statearr_73155;
})();
var statearr_73156_73235 = state_73146__$1;
(statearr_73156_73235[(2)] = inst_73025);

(statearr_73156_73235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (15))){
var state_73146__$1 = state_73146;
var statearr_73157_73236 = state_73146__$1;
(statearr_73157_73236[(2)] = (1000000));

(statearr_73157_73236[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (48))){
var inst_73108 = (state_73146[(12)]);
var state_73146__$1 = state_73146;
var statearr_73158_73237 = state_73146__$1;
(statearr_73158_73237[(2)] = inst_73108);

(statearr_73158_73237[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (50))){
var inst_73135 = (state_73146[(2)]);
var state_73146__$1 = state_73146;
var statearr_73159_73238 = state_73146__$1;
(statearr_73159_73238[(2)] = inst_73135);

(statearr_73159_73238[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (21))){
var inst_73039 = (state_73146[(14)]);
var state_73146__$1 = state_73146;
if(cljs.core.truth_(inst_73039)){
var statearr_73160_73239 = state_73146__$1;
(statearr_73160_73239[(1)] = (23));

} else {
var statearr_73161_73240 = state_73146__$1;
(statearr_73161_73240[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (31))){
var inst_73097 = (state_73146[(2)]);
var inst_73098 = cljs.core.not(inst_73097);
var state_73146__$1 = state_73146;
if(inst_73098){
var statearr_73162_73241 = state_73146__$1;
(statearr_73162_73241[(1)] = (35));

} else {
var statearr_73163_73242 = state_73146__$1;
(statearr_73163_73242[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (32))){
var inst_73041 = (state_73146[(15)]);
var state_73146__$1 = state_73146;
var statearr_73164_73243 = state_73146__$1;
(statearr_73164_73243[(2)] = inst_73041);

(statearr_73164_73243[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (40))){
var inst_73071 = (state_73146[(16)]);
var state_73146__$1 = state_73146;
if(cljs.core.truth_(inst_73071)){
var statearr_73165_73244 = state_73146__$1;
(statearr_73165_73244[(1)] = (42));

} else {
var statearr_73166_73245 = state_73146__$1;
(statearr_73166_73245[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (33))){
var inst_73037 = (state_73146[(17)]);
var state_73146__$1 = state_73146;
var statearr_73167_73246 = state_73146__$1;
(statearr_73167_73246[(2)] = inst_73037);

(statearr_73167_73246[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (13))){
var inst_73066 = (state_73146[(18)]);
var inst_73042 = (state_73146[(19)]);
var inst_73064 = (state_73146[(2)]);
var inst_73065 = cljs.core.volatile_BANG_((0));
var inst_73066__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_73042);
var state_73146__$1 = (function (){var statearr_73168 = state_73146;
(statearr_73168[(20)] = inst_73064);

(statearr_73168[(18)] = inst_73066__$1);

(statearr_73168[(21)] = inst_73065);

return statearr_73168;
})();
if(cljs.core.truth_(inst_73066__$1)){
var statearr_73169_73247 = state_73146__$1;
(statearr_73169_73247[(1)] = (14));

} else {
var statearr_73170_73248 = state_73146__$1;
(statearr_73170_73248[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (22))){
var inst_73087 = (state_73146[(2)]);
var state_73146__$1 = state_73146;
var statearr_73171_73249 = state_73146__$1;
(statearr_73171_73249[(2)] = inst_73087);

(statearr_73171_73249[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (36))){
var inst_73073 = (state_73146[(22)]);
var inst_73054 = (state_73146[(23)]);
var inst_73104 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_73073);
var inst_73105 = fluree.db.query.fql.query(inst_73054,inst_73104);
var state_73146__$1 = state_73146;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73146__$1,(38),inst_73105);
} else {
if((state_val_73147 === (41))){
var inst_73139 = (state_73146[(2)]);
var state_73146__$1 = state_73146;
var statearr_73172_73250 = state_73146__$1;
(statearr_73172_73250[(2)] = inst_73139);

(statearr_73172_73250[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (43))){
var state_73146__$1 = state_73146;
var statearr_73173_73251 = state_73146__$1;
(statearr_73173_73251[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (29))){
var inst_73041 = (state_73146[(15)]);
var state_73146__$1 = state_73146;
if(cljs.core.truth_(inst_73041)){
var statearr_73175_73252 = state_73146__$1;
(statearr_73175_73252[(1)] = (32));

} else {
var statearr_73176_73253 = state_73146__$1;
(statearr_73176_73253[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (44))){
var inst_73137 = (state_73146[(2)]);
var state_73146__$1 = state_73146;
var statearr_73177_73254 = state_73146__$1;
(statearr_73177_73254[(2)] = inst_73137);

(statearr_73177_73254[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (6))){
var inst_73036 = (state_73146[(8)]);
var inst_73045 = (state_73146[(2)]);
var inst_73046 = fluree.db.util.async.throw_err(inst_73045);
var state_73146__$1 = (function (){var statearr_73178 = state_73146;
(statearr_73178[(7)] = inst_73046);

return statearr_73178;
})();
if(cljs.core.truth_(inst_73036)){
var statearr_73179_73255 = state_73146__$1;
(statearr_73179_73255[(1)] = (7));

} else {
var statearr_73180_73256 = state_73146__$1;
(statearr_73180_73256[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (28))){
var inst_73083 = (state_73146[(2)]);
var state_73146__$1 = state_73146;
var statearr_73181_73257 = state_73146__$1;
(statearr_73181_73257[(2)] = inst_73083);

(statearr_73181_73257[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (25))){
var inst_73085 = (state_73146[(2)]);
var state_73146__$1 = state_73146;
var statearr_73182_73258 = state_73146__$1;
(statearr_73182_73258[(2)] = inst_73085);

(statearr_73182_73258[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (34))){
var inst_73094 = (state_73146[(2)]);
var state_73146__$1 = state_73146;
var statearr_73183_73259 = state_73146__$1;
(statearr_73183_73259[(2)] = inst_73094);

(statearr_73183_73259[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (17))){
var inst_73035 = (state_73146[(24)]);
var state_73146__$1 = state_73146;
var statearr_73184_73260 = state_73146__$1;
(statearr_73184_73260[(2)] = inst_73035);

(statearr_73184_73260[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (3))){
var inst_73144 = (state_73146[(2)]);
var state_73146__$1 = state_73146;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73146__$1,inst_73144);
} else {
if((state_val_73147 === (12))){
var inst_73062 = cljs.core.PersistentHashMap.EMPTY;
var state_73146__$1 = state_73146;
var statearr_73185_73261 = state_73146__$1;
(statearr_73185_73261[(2)] = inst_73062);

(statearr_73185_73261[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (2))){
var _ = (function (){var statearr_73186 = state_73146;
(statearr_73186[(4)] = cljs.core.cons((5),(state_73146[(4)])));

return statearr_73186;
})();
var inst_73032 = query_map;
var inst_73033 = cljs.core.__destructure_map(inst_73032);
var inst_73034 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73033,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_73035 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73033,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_73036 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73033,new cljs.core.Keyword(null,"block","block",664686210));
var inst_73037 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73033,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_73038 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73033,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_73039 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73033,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_73040 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73033,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_73041 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73033,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_73042 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73033,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_73043 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73033,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_73146__$1 = (function (){var statearr_73187 = state_73146;
(statearr_73187[(15)] = inst_73041);

(statearr_73187[(9)] = inst_73040);

(statearr_73187[(8)] = inst_73036);

(statearr_73187[(25)] = inst_73038);

(statearr_73187[(24)] = inst_73035);

(statearr_73187[(11)] = inst_73043);

(statearr_73187[(17)] = inst_73037);

(statearr_73187[(19)] = inst_73042);

(statearr_73187[(10)] = inst_73034);

(statearr_73187[(14)] = inst_73039);

return statearr_73187;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73146__$1,(6),sources);
} else {
if((state_val_73147 === (23))){
var inst_73039 = (state_73146[(14)]);
var state_73146__$1 = state_73146;
var statearr_73188_73262 = state_73146__$1;
(statearr_73188_73262[(2)] = inst_73039);

(statearr_73188_73262[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (47))){
var inst_73119 = (state_73146[(26)]);
var inst_73054 = (state_73146[(23)]);
var inst_73072 = (state_73146[(27)]);
var inst_73065 = (state_73146[(21)]);
var inst_73125 = (state_73146[(2)]);
var inst_73126 = cljs.core.deref(inst_73065);
var inst_73127 = fluree.db.util.core.response_time_formatted(inst_73072);
var inst_73128 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_73054);
var inst_73129 = [(200),inst_73125,inst_73126,inst_73127,inst_73128];
var inst_73130 = cljs.core.PersistentHashMap.fromArrays(inst_73119,inst_73129);
var state_73146__$1 = state_73146;
var statearr_73189_73263 = state_73146__$1;
(statearr_73189_73263[(2)] = inst_73130);

(statearr_73189_73263[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (35))){
var inst_73100 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73101 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73102 = cljs.core.PersistentHashMap.fromArrays(inst_73100,inst_73101);
var state_73146__$1 = state_73146;
var statearr_73190_73264 = state_73146__$1;
(statearr_73190_73264[(2)] = inst_73102);

(statearr_73190_73264[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (19))){
var inst_73089 = (state_73146[(28)]);
var inst_73089__$1 = (state_73146[(2)]);
var state_73146__$1 = (function (){var statearr_73191 = state_73146;
(statearr_73191[(28)] = inst_73089__$1);

return statearr_73191;
})();
if(cljs.core.truth_(inst_73089__$1)){
var statearr_73192_73265 = state_73146__$1;
(statearr_73192_73265[(1)] = (29));

} else {
var statearr_73193_73266 = state_73146__$1;
(statearr_73193_73266[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (11))){
var inst_73054 = (state_73146[(23)]);
var inst_73038 = (state_73146[(25)]);
var inst_73055 = (state_73146[(29)]);
var inst_73057 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_73054);
var inst_73058 = fluree.db.connection_js.open_api_QMARK_(inst_73055);
var inst_73059 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_73054);
var inst_73060 = fluree.db.api_js.get_sources(inst_73055,inst_73057,inst_73058,inst_73059,inst_73038,db_fn);
var state_73146__$1 = state_73146;
var statearr_73195_73267 = state_73146__$1;
(statearr_73195_73267[(2)] = inst_73060);

(statearr_73195_73267[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (9))){
var inst_73054 = (state_73146[(23)]);
var inst_73038 = (state_73146[(25)]);
var inst_73054__$1 = (state_73146[(2)]);
var inst_73055 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_73054__$1);
var state_73146__$1 = (function (){var statearr_73196 = state_73146;
(statearr_73196[(23)] = inst_73054__$1);

(statearr_73196[(29)] = inst_73055);

return statearr_73196;
})();
if(cljs.core.truth_(inst_73038)){
var statearr_73197_73268 = state_73146__$1;
(statearr_73197_73268[(1)] = (11));

} else {
var statearr_73198_73269 = state_73146__$1;
(statearr_73198_73269[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (5))){
var _ = (function (){var statearr_73199 = state_73146;
(statearr_73199[(4)] = cljs.core.rest((state_73146[(4)])));

return statearr_73199;
})();
var state_73146__$1 = state_73146;
var ex73194 = (state_73146__$1[(2)]);
var statearr_73200_73270 = state_73146__$1;
(statearr_73200_73270[(5)] = ex73194);


var statearr_73201_73271 = state_73146__$1;
(statearr_73201_73271[(1)] = (4));

(statearr_73201_73271[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (14))){
var inst_73066 = (state_73146[(18)]);
var state_73146__$1 = state_73146;
var statearr_73202_73272 = state_73146__$1;
(statearr_73202_73272[(2)] = inst_73066);

(statearr_73202_73272[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (45))){
var inst_73108 = (state_73146[(12)]);
var inst_73122 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_73108);
var state_73146__$1 = state_73146;
var statearr_73203_73273 = state_73146__$1;
(statearr_73203_73273[(2)] = inst_73122);

(statearr_73203_73273[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (26))){
var inst_73043 = (state_73146[(11)]);
var state_73146__$1 = state_73146;
var statearr_73204_73274 = state_73146__$1;
(statearr_73204_73274[(2)] = inst_73043);

(statearr_73204_73274[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (16))){
var inst_73064 = (state_73146[(20)]);
var inst_73035 = (state_73146[(24)]);
var inst_73042 = (state_73146[(19)]);
var inst_73065 = (state_73146[(21)]);
var inst_73070 = (state_73146[(2)]);
var inst_73071 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_73042);
var inst_73072 = fluree.db.util.core.current_time_millis();
var inst_73073 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_73042,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_73064,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_73070,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_73065], 0));
var state_73146__$1 = (function (){var statearr_73205 = state_73146;
(statearr_73205[(22)] = inst_73073);

(statearr_73205[(27)] = inst_73072);

(statearr_73205[(16)] = inst_73071);

return statearr_73205;
})();
if(cljs.core.truth_(inst_73035)){
var statearr_73206_73275 = state_73146__$1;
(statearr_73206_73275[(1)] = (17));

} else {
var statearr_73207_73276 = state_73146__$1;
(statearr_73207_73276[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (38))){
var inst_73108 = (state_73146[(12)]);
var inst_73107 = (state_73146[(2)]);
var inst_73108__$1 = fluree.db.util.async.throw_err(inst_73107);
var inst_73109 = (inst_73108__$1 instanceof cljs.core.ExceptionInfo);
var state_73146__$1 = (function (){var statearr_73208 = state_73146;
(statearr_73208[(12)] = inst_73108__$1);

return statearr_73208;
})();
if(cljs.core.truth_(inst_73109)){
var statearr_73209_73277 = state_73146__$1;
(statearr_73209_73277[(1)] = (39));

} else {
var statearr_73210_73278 = state_73146__$1;
(statearr_73210_73278[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (30))){
var inst_73089 = (state_73146[(28)]);
var state_73146__$1 = state_73146;
var statearr_73211_73279 = state_73146__$1;
(statearr_73211_73279[(2)] = inst_73089);

(statearr_73211_73279[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (10))){
var inst_73050 = (state_73146[(2)]);
var inst_73051 = fluree.db.util.async.throw_err(inst_73050);
var state_73146__$1 = state_73146;
var statearr_73212_73280 = state_73146__$1;
(statearr_73212_73280[(2)] = inst_73051);

(statearr_73212_73280[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (18))){
var inst_73040 = (state_73146[(9)]);
var state_73146__$1 = state_73146;
if(cljs.core.truth_(inst_73040)){
var statearr_73213_73281 = state_73146__$1;
(statearr_73213_73281[(1)] = (20));

} else {
var statearr_73214_73282 = state_73146__$1;
(statearr_73214_73282[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (42))){
var inst_73108 = (state_73146[(12)]);
var inst_73119 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_73120 = cljs.core.sequential_QMARK_(inst_73108);
var state_73146__$1 = (function (){var statearr_73215 = state_73146;
(statearr_73215[(26)] = inst_73119);

return statearr_73215;
})();
if(inst_73120){
var statearr_73216_73283 = state_73146__$1;
(statearr_73216_73283[(1)] = (45));

} else {
var statearr_73217_73284 = state_73146__$1;
(statearr_73217_73284[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (37))){
var inst_73141 = (state_73146[(2)]);
var _ = (function (){var statearr_73218 = state_73146;
(statearr_73218[(4)] = cljs.core.rest((state_73146[(4)])));

return statearr_73218;
})();
var state_73146__$1 = state_73146;
var statearr_73219_73285 = state_73146__$1;
(statearr_73219_73285[(2)] = inst_73141);

(statearr_73219_73285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (8))){
var inst_73046 = (state_73146[(7)]);
var state_73146__$1 = state_73146;
var statearr_73220_73286 = state_73146__$1;
(statearr_73220_73286[(2)] = inst_73046);

(statearr_73220_73286[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73147 === (49))){
var state_73146__$1 = state_73146;
var statearr_73221_73287 = state_73146__$1;
(statearr_73221_73287[(2)] = null);

(statearr_73221_73287[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_73222 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73222[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_73222[(1)] = (1));

return statearr_73222;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_73146){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73146);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73223){var ex__2730__auto__ = e73223;
var statearr_73224_73288 = state_73146;
(statearr_73224_73288[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73146[(4)]))){
var statearr_73225_73289 = state_73146;
(statearr_73225_73289[(1)] = cljs.core.first((state_73146[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73290 = state_73146;
state_73146 = G__73290;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_73146){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_73146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73226 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73226[(6)] = c__2749__auto__);

return statearr_73226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__73291_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__73291_SHARP_);
}));

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73313){
var state_val_73314 = (state_73313[(1)]);
if((state_val_73314 === (1))){
var inst_73295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73296 = [resp_chan,timeout_chan];
var inst_73297 = (new cljs.core.PersistentVector(null,2,(5),inst_73295,inst_73296,null));
var state_73313__$1 = state_73313;
return cljs.core.async.ioc_alts_BANG_(state_73313__$1,(2),inst_73297);
} else {
if((state_val_73314 === (2))){
var inst_73299 = (state_73313[(2)]);
var inst_73300 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73299,(0),null);
var inst_73301 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73299,(1),null);
var inst_73302 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_73301);
var state_73313__$1 = (function (){var statearr_73315 = state_73313;
(statearr_73315[(7)] = inst_73300);

return statearr_73315;
})();
if(inst_73302){
var statearr_73316_73326 = state_73313__$1;
(statearr_73316_73326[(1)] = (3));

} else {
var statearr_73317_73327 = state_73313__$1;
(statearr_73317_73327[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (3))){
var inst_73304 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_73305 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_73306 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_73307 = [tid,(408),inst_73306];
var inst_73308 = cljs.core.PersistentHashMap.fromArrays(inst_73305,inst_73307);
var state_73313__$1 = (function (){var statearr_73318 = state_73313;
(statearr_73318[(8)] = inst_73304);

return statearr_73318;
})();
var statearr_73319_73328 = state_73313__$1;
(statearr_73319_73328[(2)] = inst_73308);

(statearr_73319_73328[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (4))){
var inst_73300 = (state_73313[(7)]);
var state_73313__$1 = state_73313;
var statearr_73320_73329 = state_73313__$1;
(statearr_73320_73329[(2)] = inst_73300);

(statearr_73320_73329[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (5))){
var inst_73311 = (state_73313[(2)]);
var state_73313__$1 = state_73313;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73313__$1,inst_73311);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0 = (function (){
var statearr_73321 = [null,null,null,null,null,null,null,null,null];
(statearr_73321[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__);

(statearr_73321[(1)] = (1));

return statearr_73321;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1 = (function (state_73313){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73313);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73322){var ex__2730__auto__ = e73322;
var statearr_73323_73330 = state_73313;
(statearr_73323_73330[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73313[(4)]))){
var statearr_73324_73331 = state_73313;
(statearr_73324_73331[(1)] = cljs.core.first((state_73313[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73332 = state_73313;
state_73313 = G__73332;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__ = function(state_73313){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1.call(this,state_73313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73325 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73325[(6)] = c__2749__auto__);

return statearr_73325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__73334 = arguments.length;
switch (G__73334) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__73335 = opts;
var map__73335__$1 = cljs.core.__destructure_map(map__73335);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73335__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73335__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73335__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73335__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__73336 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73336,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73336,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e73339){var e = e73339;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__73342 = arguments.length;
switch (G__73342) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73411){
var state_val_73412 = (state_73411[(1)]);
if((state_val_73412 === (7))){
var inst_73367 = (state_73411[(7)]);
var inst_73364 = (state_73411[(8)]);
var inst_73362 = (state_73411[(9)]);
var inst_73366 = (state_73411[(10)]);
var inst_73365 = (state_73411[(11)]);
var inst_73380 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_73381 = [ledger,txn,inst_73362,inst_73364,inst_73365,inst_73366,inst_73367];
var inst_73382 = cljs.core.PersistentHashMap.fromArrays(inst_73380,inst_73381);
var inst_73383 = fluree.db.util.core.without_nils(inst_73382);
var inst_73384 = fluree.db.operations.transact_async(conn,inst_73383);
var state_73411__$1 = state_73411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73411__$1,(13),inst_73384);
} else {
if((state_val_73412 === (20))){
var inst_73402 = (state_73411[(2)]);
var state_73411__$1 = state_73411;
var statearr_73413_73449 = state_73411__$1;
(statearr_73413_73449[(2)] = inst_73402);

(statearr_73413_73449[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (1))){
var state_73411__$1 = state_73411;
var statearr_73414_73450 = state_73411__$1;
(statearr_73414_73450[(2)] = null);

(statearr_73414_73450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (4))){
var inst_73343 = (state_73411[(2)]);
var inst_73344 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73345 = [inst_73343];
var inst_73346 = (new cljs.core.PersistentVector(null,1,(5),inst_73344,inst_73345,null));
var inst_73347 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73346);
var inst_73348 = cljs.core.ex_data(inst_73343);
var inst_73349 = cljs.core.ex_message(inst_73343);
var inst_73350 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73348,new cljs.core.Keyword(null,"message","message",-406056002),inst_73349);
var state_73411__$1 = (function (){var statearr_73415 = state_73411;
(statearr_73415[(12)] = inst_73347);

return statearr_73415;
})();
var statearr_73416_73451 = state_73411__$1;
(statearr_73416_73451[(2)] = inst_73350);

(statearr_73416_73451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (15))){
var inst_73361 = (state_73411[(13)]);
var inst_73386 = (state_73411[(14)]);
var inst_73389 = fluree.db.api_js.monitor_tx(conn,ledger,inst_73386,inst_73361);
var state_73411__$1 = state_73411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73411__$1,(17),inst_73389);
} else {
if((state_val_73412 === (13))){
var inst_73360 = (state_73411[(15)]);
var inst_73386 = (state_73411[(2)]);
var state_73411__$1 = (function (){var statearr_73417 = state_73411;
(statearr_73417[(14)] = inst_73386);

return statearr_73417;
})();
if(cljs.core.truth_(inst_73360)){
var statearr_73418_73452 = state_73411__$1;
(statearr_73418_73452[(1)] = (14));

} else {
var statearr_73419_73453 = state_73411__$1;
(statearr_73419_73453[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (6))){
var inst_73359 = (state_73411[(16)]);
var inst_73360 = (state_73411[(15)]);
var inst_73369 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_73359,opts);
var inst_73370 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_73369);
var inst_73371 = fluree.db.operations.command_async(conn,inst_73369);
var state_73411__$1 = (function (){var statearr_73420 = state_73411;
(statearr_73420[(17)] = inst_73370);

(statearr_73420[(18)] = inst_73371);

return statearr_73420;
})();
if(cljs.core.truth_(inst_73360)){
var statearr_73421_73454 = state_73411__$1;
(statearr_73421_73454[(1)] = (9));

} else {
var statearr_73422_73455 = state_73411__$1;
(statearr_73422_73455[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (17))){
var inst_73391 = (state_73411[(19)]);
var inst_73391__$1 = (state_73411[(2)]);
var inst_73392 = (inst_73391__$1 instanceof cljs.core.ExceptionInfo);
var state_73411__$1 = (function (){var statearr_73423 = state_73411;
(statearr_73423[(19)] = inst_73391__$1);

return statearr_73423;
})();
if(cljs.core.truth_(inst_73392)){
var statearr_73424_73456 = state_73411__$1;
(statearr_73424_73456[(1)] = (18));

} else {
var statearr_73425_73457 = state_73411__$1;
(statearr_73425_73457[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (3))){
var inst_73409 = (state_73411[(2)]);
var state_73411__$1 = state_73411;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73411__$1,inst_73409);
} else {
if((state_val_73412 === (12))){
var inst_73376 = (state_73411[(2)]);
var state_73411__$1 = state_73411;
var statearr_73426_73458 = state_73411__$1;
(statearr_73426_73458[(2)] = inst_73376);

(statearr_73426_73458[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (2))){
var inst_73359 = (state_73411[(16)]);
var _ = (function (){var statearr_73427 = state_73411;
(statearr_73427[(4)] = cljs.core.cons((5),(state_73411[(4)])));

return statearr_73427;
})();
var inst_73357 = opts;
var inst_73358 = cljs.core.__destructure_map(inst_73357);
var inst_73359__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73358,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_73360 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73358,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_73361 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_73358,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_73362 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73358,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_73363 = fluree.db.util.core.current_time_millis();
var inst_73364 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_73358,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_73363);
var inst_73365 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73358,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_73366 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73358,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_73367 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73358,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_73411__$1 = (function (){var statearr_73428 = state_73411;
(statearr_73428[(7)] = inst_73367);

(statearr_73428[(13)] = inst_73361);

(statearr_73428[(8)] = inst_73364);

(statearr_73428[(9)] = inst_73362);

(statearr_73428[(16)] = inst_73359__$1);

(statearr_73428[(10)] = inst_73366);

(statearr_73428[(15)] = inst_73360);

(statearr_73428[(11)] = inst_73365);

return statearr_73428;
})();
if(cljs.core.truth_(inst_73359__$1)){
var statearr_73429_73459 = state_73411__$1;
(statearr_73429_73459[(1)] = (6));

} else {
var statearr_73430_73460 = state_73411__$1;
(statearr_73430_73460[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (19))){
var inst_73391 = (state_73411[(19)]);
var state_73411__$1 = state_73411;
var statearr_73431_73461 = state_73411__$1;
(statearr_73431_73461[(2)] = inst_73391);

(statearr_73431_73461[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (11))){
var inst_73378 = (state_73411[(2)]);
var state_73411__$1 = state_73411;
var statearr_73433_73462 = state_73411__$1;
(statearr_73433_73462[(2)] = inst_73378);

(statearr_73433_73462[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (9))){
var inst_73371 = (state_73411[(18)]);
var state_73411__$1 = state_73411;
var statearr_73434_73463 = state_73411__$1;
(statearr_73434_73463[(2)] = inst_73371);

(statearr_73434_73463[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (5))){
var _ = (function (){var statearr_73435 = state_73411;
(statearr_73435[(4)] = cljs.core.rest((state_73411[(4)])));

return statearr_73435;
})();
var state_73411__$1 = state_73411;
var ex73432 = (state_73411__$1[(2)]);
var statearr_73436_73464 = state_73411__$1;
(statearr_73436_73464[(5)] = ex73432);


var statearr_73437_73465 = state_73411__$1;
(statearr_73437_73465[(1)] = (4));

(statearr_73437_73465[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (14))){
var inst_73386 = (state_73411[(14)]);
var state_73411__$1 = state_73411;
var statearr_73438_73466 = state_73411__$1;
(statearr_73438_73466[(2)] = inst_73386);

(statearr_73438_73466[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (16))){
var inst_73404 = (state_73411[(2)]);
var state_73411__$1 = state_73411;
var statearr_73439_73467 = state_73411__$1;
(statearr_73439_73467[(2)] = inst_73404);

(statearr_73439_73467[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (10))){
var inst_73361 = (state_73411[(13)]);
var inst_73370 = (state_73411[(17)]);
var inst_73374 = fluree.db.api_js.monitor_tx(conn,ledger,inst_73370,inst_73361);
var state_73411__$1 = state_73411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73411__$1,(12),inst_73374);
} else {
if((state_val_73412 === (18))){
var inst_73391 = (state_73411[(19)]);
var inst_73394 = cljs.core.ex_data(inst_73391);
var inst_73395 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73396 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_73394);
var inst_73397 = cljs.core.ex_message(inst_73391);
var inst_73398 = [inst_73396,inst_73397,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_73399 = cljs.core.PersistentHashMap.fromArrays(inst_73395,inst_73398);
var state_73411__$1 = state_73411;
var statearr_73440_73468 = state_73411__$1;
(statearr_73440_73468[(2)] = inst_73399);

(statearr_73440_73468[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (8))){
var inst_73406 = (state_73411[(2)]);
var _ = (function (){var statearr_73441 = state_73411;
(statearr_73441[(4)] = cljs.core.rest((state_73411[(4)])));

return statearr_73441;
})();
var state_73411__$1 = state_73411;
var statearr_73442_73469 = state_73411__$1;
(statearr_73442_73469[(2)] = inst_73406);

(statearr_73442_73469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_73443 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73443[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_73443[(1)] = (1));

return statearr_73443;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_73411){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73411);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73444){var ex__2730__auto__ = e73444;
var statearr_73445_73470 = state_73411;
(statearr_73445_73470[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73411[(4)]))){
var statearr_73446_73471 = state_73411;
(statearr_73446_73471[(1)] = cljs.core.first((state_73411[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73472 = state_73411;
state_73411 = G__73472;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_73411){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_73411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73447 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73447[(6)] = c__2749__auto__);

return statearr_73447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___73474 = arguments.length;
var i__4865__auto___73475 = (0);
while(true){
if((i__4865__auto___73475 < len__4864__auto___73474)){
args__4870__auto__.push((arguments[i__4865__auto___73475]));

var G__73476 = (i__4865__auto___73475 + (1));
i__4865__auto___73475 = G__73476;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq73473){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq73473));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73507){
var state_val_73508 = (state_73507[(1)]);
if((state_val_73508 === (1))){
var inst_73477 = cljs.core.first(flakes);
var inst_73478 = cljs.core.rest(flakes);
var inst_73479 = cljs.core.PersistentVector.EMPTY;
var inst_73480 = inst_73477;
var inst_73481 = inst_73478;
var inst_73482 = inst_73479;
var state_73507__$1 = (function (){var statearr_73509 = state_73507;
(statearr_73509[(7)] = inst_73480);

(statearr_73509[(8)] = inst_73481);

(statearr_73509[(9)] = inst_73482);

return statearr_73509;
})();
var statearr_73510_73523 = state_73507__$1;
(statearr_73510_73523[(2)] = null);

(statearr_73510_73523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73508 === (2))){
var inst_73480 = (state_73507[(7)]);
var inst_73484 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_73485 = cljs.core.PersistentHashMap.EMPTY;
var inst_73486 = [true,inst_73485];
var inst_73487 = cljs.core.PersistentHashMap.fromArrays(inst_73484,inst_73486);
var inst_73488 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_73487,inst_73480);
var state_73507__$1 = state_73507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73507__$1,(4),inst_73488);
} else {
if((state_val_73508 === (3))){
var inst_73505 = (state_73507[(2)]);
var state_73507__$1 = state_73507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73507__$1,inst_73505);
} else {
if((state_val_73508 === (4))){
var inst_73481 = (state_73507[(8)]);
var inst_73482 = (state_73507[(9)]);
var inst_73490 = (state_73507[(2)]);
var inst_73491 = fluree.db.util.async.throw_err(inst_73490);
var inst_73492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73493 = [inst_73491];
var inst_73494 = (new cljs.core.PersistentVector(null,1,(5),inst_73492,inst_73493,null));
var inst_73495 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_73482,inst_73494);
var inst_73496 = cljs.core.first(inst_73481);
var state_73507__$1 = (function (){var statearr_73511 = state_73507;
(statearr_73511[(10)] = inst_73495);

return statearr_73511;
})();
if(cljs.core.truth_(inst_73496)){
var statearr_73512_73524 = state_73507__$1;
(statearr_73512_73524[(1)] = (5));

} else {
var statearr_73513_73525 = state_73507__$1;
(statearr_73513_73525[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73508 === (5))){
var inst_73481 = (state_73507[(8)]);
var inst_73495 = (state_73507[(10)]);
var inst_73498 = cljs.core.first(inst_73481);
var inst_73499 = cljs.core.rest(inst_73481);
var inst_73480 = inst_73498;
var inst_73481__$1 = inst_73499;
var inst_73482 = inst_73495;
var state_73507__$1 = (function (){var statearr_73514 = state_73507;
(statearr_73514[(7)] = inst_73480);

(statearr_73514[(8)] = inst_73481__$1);

(statearr_73514[(9)] = inst_73482);

return statearr_73514;
})();
var statearr_73515_73526 = state_73507__$1;
(statearr_73515_73526[(2)] = null);

(statearr_73515_73526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73508 === (6))){
var inst_73495 = (state_73507[(10)]);
var state_73507__$1 = state_73507;
var statearr_73516_73527 = state_73507__$1;
(statearr_73516_73527[(2)] = inst_73495);

(statearr_73516_73527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73508 === (7))){
var inst_73503 = (state_73507[(2)]);
var state_73507__$1 = state_73507;
var statearr_73517_73528 = state_73507__$1;
(statearr_73517_73528[(2)] = inst_73503);

(statearr_73517_73528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_73518 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_73518[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__);

(statearr_73518[(1)] = (1));

return statearr_73518;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1 = (function (state_73507){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73507);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73519){var ex__2730__auto__ = e73519;
var statearr_73520_73529 = state_73507;
(statearr_73520_73529[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73507[(4)]))){
var statearr_73521_73530 = state_73507;
(statearr_73521_73530[(1)] = cljs.core.first((state_73507[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73531 = state_73507;
state_73507 = G__73531;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__ = function(state_73507){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1.call(this,state_73507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73522 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73522[(6)] = c__2749__auto__);

return statearr_73522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73599){
var state_val_73600 = (state_73599[(1)]);
if((state_val_73600 === (7))){
var inst_73559 = (state_73599[(2)]);
var inst_73560 = fluree.db.util.async.throw_err(inst_73559);
var state_73599__$1 = state_73599;
var statearr_73601_73627 = state_73599__$1;
(statearr_73601_73627[(2)] = inst_73560);

(statearr_73601_73627[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73600 === (1))){
var inst_73536 = cljs.core.volatile_BANG_((0));
var inst_73537 = cljs.core.PersistentHashMap.EMPTY;
var inst_73538 = cljs.core.volatile_BANG_(inst_73537);
var inst_73539 = cljs.core.first(resp);
var inst_73540 = cljs.core.rest(resp);
var inst_73541 = cljs.core.PersistentVector.EMPTY;
var inst_73542 = inst_73536;
var inst_73543 = inst_73538;
var inst_73544 = inst_73539;
var inst_73545 = inst_73540;
var inst_73546 = inst_73541;
var state_73599__$1 = (function (){var statearr_73602 = state_73599;
(statearr_73602[(7)] = inst_73544);

(statearr_73602[(8)] = inst_73542);

(statearr_73602[(9)] = inst_73546);

(statearr_73602[(10)] = inst_73543);

(statearr_73602[(11)] = inst_73545);

return statearr_73602;
})();
var statearr_73603_73628 = state_73599__$1;
(statearr_73603_73628[(2)] = null);

(statearr_73603_73628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73600 === (4))){
var inst_73544 = (state_73599[(7)]);
var inst_73542 = (state_73599[(8)]);
var inst_73546 = (state_73599[(9)]);
var inst_73548 = (state_73599[(12)]);
var inst_73543 = (state_73599[(10)]);
var inst_73545 = (state_73599[(11)]);
var inst_73550 = (state_73599[(13)]);
var inst_73554 = (function (){var fuel = inst_73542;
var cache = inst_73543;
var curr_block = inst_73544;
var rest_blocks = inst_73545;
var acc = inst_73546;
var flakes = inst_73548;
var asserted = inst_73550;
return (function (p1__73533_SHARP_){
return p1__73533_SHARP_.s;
});
})();
var inst_73555 = cljs.core.group_by(inst_73554,inst_73550);
var inst_73556 = cljs.core.vals(inst_73555);
var inst_73557 = fluree.db.api_js.format_flake_groups_pretty(db,inst_73543,inst_73542,inst_73556);
var state_73599__$1 = state_73599;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73599__$1,(7),inst_73557);
} else {
if((state_val_73600 === (13))){
var inst_73587 = (state_73599[(14)]);
var state_73599__$1 = state_73599;
var statearr_73604_73629 = state_73599__$1;
(statearr_73604_73629[(2)] = inst_73587);

(statearr_73604_73629[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73600 === (6))){
var inst_73544 = (state_73599[(7)]);
var inst_73542 = (state_73599[(8)]);
var inst_73546 = (state_73599[(9)]);
var inst_73548 = (state_73599[(12)]);
var inst_73565 = (state_73599[(15)]);
var inst_73543 = (state_73599[(10)]);
var inst_73545 = (state_73599[(11)]);
var inst_73550 = (state_73599[(13)]);
var inst_73563 = (state_73599[(16)]);
var inst_73563__$1 = (state_73599[(2)]);
var inst_73564 = (function (){var fuel = inst_73542;
var cache = inst_73543;
var curr_block = inst_73544;
var rest_blocks = inst_73545;
var acc = inst_73546;
var flakes = inst_73548;
var asserted = inst_73550;
var asserted_SINGLEQUOTE_ = inst_73563__$1;
return (function (p1__73534_SHARP_){
return p1__73534_SHARP_.op === false;
});
})();
var inst_73565__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_73564,inst_73548);
var inst_73566 = cljs.core.empty_QMARK_(inst_73565__$1);
var inst_73567 = (!(inst_73566));
var state_73599__$1 = (function (){var statearr_73607 = state_73599;
(statearr_73607[(15)] = inst_73565__$1);

(statearr_73607[(16)] = inst_73563__$1);

return statearr_73607;
})();
if(inst_73567){
var statearr_73608_73630 = state_73599__$1;
(statearr_73608_73630[(1)] = (8));

} else {
var statearr_73609_73631 = state_73599__$1;
(statearr_73609_73631[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73600 === (3))){
var inst_73597 = (state_73599[(2)]);
var state_73599__$1 = state_73599;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73599__$1,inst_73597);
} else {
if((state_val_73600 === (12))){
var inst_73542 = (state_73599[(8)]);
var inst_73587 = (state_73599[(14)]);
var inst_73543 = (state_73599[(10)]);
var inst_73545 = (state_73599[(11)]);
var inst_73590 = cljs.core.first(inst_73545);
var inst_73591 = cljs.core.rest(inst_73545);
var tmp73605 = inst_73542;
var tmp73606 = inst_73543;
var inst_73542__$1 = tmp73605;
var inst_73543__$1 = tmp73606;
var inst_73544 = inst_73590;
var inst_73545__$1 = inst_73591;
var inst_73546 = inst_73587;
var state_73599__$1 = (function (){var statearr_73610 = state_73599;
(statearr_73610[(7)] = inst_73544);

(statearr_73610[(8)] = inst_73542__$1);

(statearr_73610[(9)] = inst_73546);

(statearr_73610[(10)] = inst_73543__$1);

(statearr_73610[(11)] = inst_73545__$1);

return statearr_73610;
})();
var statearr_73611_73632 = state_73599__$1;
(statearr_73611_73632[(2)] = null);

(statearr_73611_73632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73600 === (2))){
var inst_73544 = (state_73599[(7)]);
var inst_73542 = (state_73599[(8)]);
var inst_73546 = (state_73599[(9)]);
var inst_73548 = (state_73599[(12)]);
var inst_73543 = (state_73599[(10)]);
var inst_73545 = (state_73599[(11)]);
var inst_73550 = (state_73599[(13)]);
var inst_73548__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_73544);
var inst_73549 = (function (){var fuel = inst_73542;
var cache = inst_73543;
var curr_block = inst_73544;
var rest_blocks = inst_73545;
var acc = inst_73546;
var flakes = inst_73548__$1;
return (function (p1__73532_SHARP_){
return p1__73532_SHARP_.op;
});
})();
var inst_73550__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_73549,inst_73548__$1);
var inst_73551 = cljs.core.empty_QMARK_(inst_73550__$1);
var inst_73552 = (!(inst_73551));
var state_73599__$1 = (function (){var statearr_73612 = state_73599;
(statearr_73612[(12)] = inst_73548__$1);

(statearr_73612[(13)] = inst_73550__$1);

return statearr_73612;
})();
if(inst_73552){
var statearr_73613_73633 = state_73599__$1;
(statearr_73613_73633[(1)] = (4));

} else {
var statearr_73614_73634 = state_73599__$1;
(statearr_73614_73634[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73600 === (11))){
var inst_73575 = (state_73599[(2)]);
var inst_73576 = fluree.db.util.async.throw_err(inst_73575);
var state_73599__$1 = state_73599;
var statearr_73615_73635 = state_73599__$1;
(statearr_73615_73635[(2)] = inst_73576);

(statearr_73615_73635[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73600 === (9))){
var state_73599__$1 = state_73599;
var statearr_73616_73636 = state_73599__$1;
(statearr_73616_73636[(2)] = null);

(statearr_73616_73636[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73600 === (5))){
var state_73599__$1 = state_73599;
var statearr_73617_73637 = state_73599__$1;
(statearr_73617_73637[(2)] = null);

(statearr_73617_73637[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73600 === (14))){
var inst_73595 = (state_73599[(2)]);
var state_73599__$1 = state_73599;
var statearr_73618_73638 = state_73599__$1;
(statearr_73618_73638[(2)] = inst_73595);

(statearr_73618_73638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73600 === (10))){
var inst_73544 = (state_73599[(7)]);
var inst_73546 = (state_73599[(9)]);
var inst_73545 = (state_73599[(11)]);
var inst_73563 = (state_73599[(16)]);
var inst_73579 = (state_73599[(2)]);
var inst_73580 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_73581 = [inst_73563,inst_73579];
var inst_73582 = cljs.core.PersistentHashMap.fromArrays(inst_73580,inst_73581);
var inst_73583 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73544,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_73582);
var inst_73584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73585 = [inst_73583];
var inst_73586 = (new cljs.core.PersistentVector(null,1,(5),inst_73584,inst_73585,null));
var inst_73587 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_73546,inst_73586);
var inst_73588 = cljs.core.first(inst_73545);
var state_73599__$1 = (function (){var statearr_73619 = state_73599;
(statearr_73619[(14)] = inst_73587);

return statearr_73619;
})();
if(cljs.core.truth_(inst_73588)){
var statearr_73620_73639 = state_73599__$1;
(statearr_73620_73639[(1)] = (12));

} else {
var statearr_73621_73640 = state_73599__$1;
(statearr_73621_73640[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73600 === (8))){
var inst_73544 = (state_73599[(7)]);
var inst_73542 = (state_73599[(8)]);
var inst_73546 = (state_73599[(9)]);
var inst_73548 = (state_73599[(12)]);
var inst_73565 = (state_73599[(15)]);
var inst_73543 = (state_73599[(10)]);
var inst_73545 = (state_73599[(11)]);
var inst_73550 = (state_73599[(13)]);
var inst_73563 = (state_73599[(16)]);
var inst_73569 = (function (){var flakes = inst_73548;
var rest_blocks = inst_73545;
var curr_block = inst_73544;
var asserted_SINGLEQUOTE_ = inst_73563;
var acc = inst_73546;
var fuel = inst_73542;
var cache = inst_73543;
var retracted = inst_73565;
var asserted = inst_73550;
return (function (p1__73535_SHARP_){
return p1__73535_SHARP_.s;
});
})();
var inst_73570 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_73565);
var inst_73571 = cljs.core.group_by(inst_73569,inst_73570);
var inst_73572 = cljs.core.vals(inst_73571);
var inst_73573 = fluree.db.api_js.format_flake_groups_pretty(db,inst_73543,inst_73542,inst_73572);
var state_73599__$1 = state_73599;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73599__$1,(11),inst_73573);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_73622 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73622[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_73622[(1)] = (1));

return statearr_73622;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_73599){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73599);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73623){var ex__2730__auto__ = e73623;
var statearr_73624_73641 = state_73599;
(statearr_73624_73641[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73599[(4)]))){
var statearr_73625_73642 = state_73599;
(statearr_73625_73642[(1)] = cljs.core.first((state_73599[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73643 = state_73599;
state_73599 = G__73643;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_73599){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_73599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73626 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73626[(6)] = c__2749__auto__);

return statearr_73626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73743){
var state_val_73744 = (state_73743[(1)]);
if((state_val_73744 === (7))){
var inst_73715 = (state_73743[(7)]);
var inst_73708 = (state_73743[(8)]);
var inst_73714 = cljs.core.seq(inst_73708);
var inst_73715__$1 = cljs.core.first(inst_73714);
var inst_73716 = cljs.core.next(inst_73714);
var state_73743__$1 = (function (){var statearr_73745 = state_73743;
(statearr_73745[(7)] = inst_73715__$1);

(statearr_73745[(9)] = inst_73716);

return statearr_73745;
})();
if(cljs.core.truth_(inst_73715__$1)){
var statearr_73746_73783 = state_73743__$1;
(statearr_73746_73783[(1)] = (9));

} else {
var statearr_73747_73784 = state_73743__$1;
(statearr_73747_73784[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73744 === (1))){
var state_73743__$1 = state_73743;
var statearr_73748_73785 = state_73743__$1;
(statearr_73748_73785[(2)] = null);

(statearr_73748_73785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73744 === (4))){
var inst_73645 = (state_73743[(2)]);
var state_73743__$1 = state_73743;
var statearr_73749_73786 = state_73743__$1;
(statearr_73749_73786[(2)] = inst_73645);

(statearr_73749_73786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73744 === (6))){
var inst_73694 = (state_73743[(2)]);
var inst_73695 = fluree.db.util.async.throw_err(inst_73694);
var inst_73703 = resp;
var inst_73704 = cljs.core.seq(inst_73703);
var inst_73705 = cljs.core.first(inst_73704);
var inst_73706 = cljs.core.next(inst_73704);
var inst_73707 = cljs.core.PersistentHashMap.EMPTY;
var inst_73708 = inst_73703;
var inst_73709 = inst_73707;
var state_73743__$1 = (function (){var statearr_73750 = state_73743;
(statearr_73750[(10)] = inst_73706);

(statearr_73750[(11)] = inst_73705);

(statearr_73750[(12)] = inst_73709);

(statearr_73750[(13)] = inst_73695);

(statearr_73750[(8)] = inst_73708);

return statearr_73750;
})();
var statearr_73751_73787 = state_73743__$1;
(statearr_73751_73787[(2)] = null);

(statearr_73751_73787[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73744 === (3))){
var inst_73741 = (state_73743[(2)]);
var state_73743__$1 = state_73743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73743__$1,inst_73741);
} else {
if((state_val_73744 === (2))){
var _ = (function (){var statearr_73752 = state_73743;
(statearr_73752[(4)] = cljs.core.cons((5),(state_73743[(4)])));

return statearr_73752;
})();
var inst_73651 = (function (){return (function (p1__73644_SHARP_){
return p1__73644_SHARP_.t;
});
})();
var inst_73652 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_73651,resp);
var inst_73653 = cljs.core.set(inst_73652);
var inst_73690 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_73691 = (function (){var ts = inst_73653;
var c__2749__auto____$1 = inst_73690;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73688){
var state_val_73689 = (state_73688[(1)]);
if((state_val_73689 === (1))){
var inst_73661 = ts;
var inst_73662 = cljs.core.seq(inst_73661);
var inst_73663 = cljs.core.first(inst_73662);
var inst_73664 = cljs.core.next(inst_73662);
var inst_73665 = cljs.core.PersistentHashMap.EMPTY;
var inst_73666 = inst_73661;
var inst_73667 = inst_73665;
var state_73688__$1 = (function (){var statearr_73753 = state_73688;
(statearr_73753[(7)] = inst_73667);

(statearr_73753[(8)] = inst_73666);

(statearr_73753[(9)] = inst_73663);

(statearr_73753[(10)] = inst_73664);

return statearr_73753;
})();
var statearr_73754_73788 = state_73688__$1;
(statearr_73754_73788[(2)] = null);

(statearr_73754_73788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73689 === (2))){
var inst_73673 = (state_73688[(11)]);
var inst_73666 = (state_73688[(8)]);
var inst_73672 = cljs.core.seq(inst_73666);
var inst_73673__$1 = cljs.core.first(inst_73672);
var inst_73674 = cljs.core.next(inst_73672);
var state_73688__$1 = (function (){var statearr_73755 = state_73688;
(statearr_73755[(11)] = inst_73673__$1);

(statearr_73755[(12)] = inst_73674);

return statearr_73755;
})();
if(cljs.core.truth_(inst_73673__$1)){
var statearr_73756_73789 = state_73688__$1;
(statearr_73756_73789[(1)] = (4));

} else {
var statearr_73757_73790 = state_73688__$1;
(statearr_73757_73790[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73689 === (3))){
var inst_73686 = (state_73688[(2)]);
var state_73688__$1 = state_73688;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73688__$1,inst_73686);
} else {
if((state_val_73689 === (4))){
var inst_73673 = (state_73688[(11)]);
var inst_73676 = fluree.db.time_travel.non_border_t_to_block(db,inst_73673);
var state_73688__$1 = state_73688;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73688__$1,(7),inst_73676);
} else {
if((state_val_73689 === (5))){
var inst_73667 = (state_73688[(7)]);
var state_73688__$1 = state_73688;
var statearr_73758_73791 = state_73688__$1;
(statearr_73758_73791[(2)] = inst_73667);

(statearr_73758_73791[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73689 === (6))){
var inst_73684 = (state_73688[(2)]);
var state_73688__$1 = state_73688;
var statearr_73759_73792 = state_73688__$1;
(statearr_73759_73792[(2)] = inst_73684);

(statearr_73759_73792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73689 === (7))){
var inst_73673 = (state_73688[(11)]);
var inst_73667 = (state_73688[(7)]);
var inst_73674 = (state_73688[(12)]);
var inst_73678 = (state_73688[(2)]);
var inst_73679 = fluree.db.util.async.throw_err(inst_73678);
var inst_73680 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73667,inst_73673,inst_73679);
var inst_73666 = inst_73674;
var inst_73667__$1 = inst_73680;
var state_73688__$1 = (function (){var statearr_73760 = state_73688;
(statearr_73760[(7)] = inst_73667__$1);

(statearr_73760[(8)] = inst_73666);

return statearr_73760;
})();
var statearr_73761_73793 = state_73688__$1;
(statearr_73761_73793[(2)] = null);

(statearr_73761_73793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_73762 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73762[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__);

(statearr_73762[(1)] = (1));

return statearr_73762;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1 = (function (state_73688){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73688);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73763){var ex__2730__auto__ = e73763;
var statearr_73764_73794 = state_73688;
(statearr_73764_73794[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73688[(4)]))){
var statearr_73765_73795 = state_73688;
(statearr_73765_73795[(1)] = cljs.core.first((state_73688[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73796 = state_73688;
state_73688 = G__73796;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = function(state_73688){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1.call(this,state_73688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73766 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73766[(6)] = c__2749__auto____$1);

return statearr_73766;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_73692 = cljs.core.async.impl.dispatch.run(inst_73691);
var state_73743__$1 = (function (){var statearr_73767 = state_73743;
(statearr_73767[(14)] = inst_73692);

return statearr_73767;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73743__$1,(6),inst_73690);
} else {
if((state_val_73744 === (11))){
var inst_73735 = (state_73743[(2)]);
var state_73743__$1 = state_73743;
var statearr_73769_73797 = state_73743__$1;
(statearr_73769_73797[(2)] = inst_73735);

(statearr_73769_73797[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73744 === (9))){
var inst_73715 = (state_73743[(7)]);
var inst_73709 = (state_73743[(12)]);
var inst_73716 = (state_73743[(9)]);
var inst_73695 = (state_73743[(13)]);
var inst_73718 = inst_73715.t;
var inst_73719 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73695,inst_73718);
var inst_73720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73721 = [inst_73719,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_73722 = (new cljs.core.PersistentVector(null,2,(5),inst_73720,inst_73721,null));
var inst_73723 = cljs.core.assoc_in(inst_73709,inst_73722,inst_73719);
var inst_73724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73725 = [inst_73719,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_73726 = (new cljs.core.PersistentVector(null,2,(5),inst_73724,inst_73725,null));
var inst_73727 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_73723,inst_73726,cljs.core.conj,inst_73715);
var inst_73728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73729 = [inst_73719,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_73730 = (new cljs.core.PersistentVector(null,2,(5),inst_73728,inst_73729,null));
var inst_73731 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_73727,inst_73730,fluree.db.api_js.min_safe,inst_73718);
var inst_73708 = inst_73716;
var inst_73709__$1 = inst_73731;
var state_73743__$1 = (function (){var statearr_73770 = state_73743;
(statearr_73770[(12)] = inst_73709__$1);

(statearr_73770[(8)] = inst_73708);

return statearr_73770;
})();
var statearr_73771_73798 = state_73743__$1;
(statearr_73771_73798[(2)] = null);

(statearr_73771_73798[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73744 === (5))){
var _ = (function (){var statearr_73772 = state_73743;
(statearr_73772[(4)] = cljs.core.rest((state_73743[(4)])));

return statearr_73772;
})();
var state_73743__$1 = state_73743;
var ex73768 = (state_73743__$1[(2)]);
var statearr_73773_73799 = state_73743__$1;
(statearr_73773_73799[(5)] = ex73768);


if((ex73768 instanceof Error)){
var statearr_73774_73800 = state_73743__$1;
(statearr_73774_73800[(1)] = (4));

(statearr_73774_73800[(5)] = null);

} else {
throw ex73768;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73744 === (10))){
var inst_73709 = (state_73743[(12)]);
var state_73743__$1 = state_73743;
var statearr_73775_73801 = state_73743__$1;
(statearr_73775_73801[(2)] = inst_73709);

(statearr_73775_73801[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73744 === (8))){
var inst_73737 = (state_73743[(2)]);
var inst_73738 = cljs.core.vals(inst_73737);
var _ = (function (){var statearr_73776 = state_73743;
(statearr_73776[(4)] = cljs.core.rest((state_73743[(4)])));

return statearr_73776;
})();
var state_73743__$1 = state_73743;
var statearr_73777_73802 = state_73743__$1;
(statearr_73777_73802[(2)] = inst_73738);

(statearr_73777_73802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_73778 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73778[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__);

(statearr_73778[(1)] = (1));

return statearr_73778;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1 = (function (state_73743){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73743);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73779){var ex__2730__auto__ = e73779;
var statearr_73780_73803 = state_73743;
(statearr_73780_73803[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73743[(4)]))){
var statearr_73781_73804 = state_73743;
(statearr_73781_73804[(1)] = cljs.core.first((state_73743[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73805 = state_73743;
state_73743 = G__73805;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = function(state_73743){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1.call(this,state_73743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73782 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73782[(6)] = c__2749__auto__);

return statearr_73782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73953){
var state_val_73954 = (state_73953[(1)]);
if((state_val_73954 === (7))){
var inst_73833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73834 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73835 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73836 = [inst_73834,inst_73835];
var inst_73837 = (new cljs.core.PersistentVector(null,2,(5),inst_73833,inst_73836,null));
var state_73953__$1 = state_73953;
var statearr_73955_74026 = state_73953__$1;
(statearr_73955_74026[(2)] = inst_73837);

(statearr_73955_74026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (20))){
var inst_73863 = (state_73953[(7)]);
var state_73953__$1 = state_73953;
var statearr_73956_74027 = state_73953__$1;
(statearr_73956_74027[(2)] = inst_73863);

(statearr_73956_74027[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (27))){
var state_73953__$1 = state_73953;
var statearr_73957_74028 = state_73953__$1;
(statearr_73957_74028[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (1))){
var state_73953__$1 = state_73953;
var statearr_73959_74029 = state_73953__$1;
(statearr_73959_74029[(2)] = null);

(statearr_73959_74029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (24))){
var inst_73862 = (state_73953[(8)]);
var state_73953__$1 = state_73953;
if(cljs.core.truth_(inst_73862)){
var statearr_73960_74030 = state_73953__$1;
(statearr_73960_74030[(1)] = (26));

} else {
var statearr_73961_74031 = state_73953__$1;
(statearr_73961_74031[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (39))){
var inst_73908 = (state_73953[(9)]);
var inst_73909 = (state_73953[(10)]);
var inst_73934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73935 = [inst_73908,inst_73909];
var inst_73936 = (new cljs.core.PersistentVector(null,2,(5),inst_73934,inst_73935,null));
var state_73953__$1 = state_73953;
var statearr_73962_74032 = state_73953__$1;
(statearr_73962_74032[(2)] = inst_73936);

(statearr_73962_74032[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (4))){
var inst_73806 = (state_73953[(2)]);
var inst_73807 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73808 = [inst_73806];
var inst_73809 = (new cljs.core.PersistentVector(null,1,(5),inst_73807,inst_73808,null));
var inst_73810 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73809);
var inst_73811 = cljs.core.ex_data(inst_73806);
var inst_73812 = cljs.core.ex_message(inst_73806);
var inst_73813 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73811,new cljs.core.Keyword(null,"message","message",-406056002),inst_73812);
var state_73953__$1 = (function (){var statearr_73963 = state_73953;
(statearr_73963[(11)] = inst_73810);

return statearr_73963;
})();
var statearr_73964_74033 = state_73953__$1;
(statearr_73964_74033[(2)] = inst_73813);

(statearr_73964_74033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (15))){
var inst_73842 = (state_73953[(12)]);
var inst_73847 = (state_73953[(13)]);
var inst_73856 = (state_73953[(2)]);
var inst_73857 = [inst_73847,inst_73856];
var inst_73858 = (new cljs.core.PersistentVector(null,2,(5),inst_73842,inst_73857,null));
var state_73953__$1 = state_73953;
var statearr_73965_74034 = state_73953__$1;
(statearr_73965_74034[(2)] = inst_73858);

(statearr_73965_74034[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (21))){
var inst_73862 = (state_73953[(8)]);
var state_73953__$1 = state_73953;
var statearr_73966_74035 = state_73953__$1;
(statearr_73966_74035[(2)] = inst_73862);

(statearr_73966_74035[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (31))){
var inst_73903 = (state_73953[(2)]);
var state_73953__$1 = state_73953;
var statearr_73967_74036 = state_73953__$1;
(statearr_73967_74036[(2)] = inst_73903);

(statearr_73967_74036[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (32))){
var inst_73909 = (state_73953[(10)]);
var inst_73912 = cljs.core.pos_int_QMARK_(inst_73909);
var state_73953__$1 = state_73953;
var statearr_73968_74037 = state_73953__$1;
(statearr_73968_74037[(2)] = inst_73912);

(statearr_73968_74037[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (40))){
var inst_73864 = (state_73953[(14)]);
var inst_73940 = (state_73953[(15)]);
var inst_73938 = (state_73953[(2)]);
var inst_73939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73938,(0),null);
var inst_73940__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73938,(1),null);
var inst_73941 = (inst_73940__$1 > inst_73864);
var state_73953__$1 = (function (){var statearr_73969 = state_73953;
(statearr_73969[(16)] = inst_73939);

(statearr_73969[(15)] = inst_73940__$1);

return statearr_73969;
})();
if(cljs.core.truth_(inst_73941)){
var statearr_73970_74038 = state_73953__$1;
(statearr_73970_74038[(1)] = (41));

} else {
var statearr_73971_74039 = state_73953__$1;
(statearr_73971_74039[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (33))){
var inst_73910 = (state_73953[(17)]);
var state_73953__$1 = state_73953;
var statearr_73972_74040 = state_73953__$1;
(statearr_73972_74040[(2)] = inst_73910);

(statearr_73972_74040[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (13))){
var inst_73848 = (state_73953[(18)]);
var inst_73850 = fluree.db.time_travel.block_to_int_format(db,inst_73848);
var state_73953__$1 = state_73953;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73953__$1,(16),inst_73850);
} else {
if((state_val_73954 === (22))){
var inst_73881 = (state_73953[(2)]);
var state_73953__$1 = state_73953;
if(cljs.core.truth_(inst_73881)){
var statearr_73973_74041 = state_73953__$1;
(statearr_73973_74041[(1)] = (23));

} else {
var statearr_73974_74042 = state_73953__$1;
(statearr_73974_74042[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (36))){
var state_73953__$1 = state_73953;
var statearr_73975_74043 = state_73953__$1;
(statearr_73975_74043[(2)] = null);

(statearr_73975_74043[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (41))){
var inst_73864 = (state_73953[(14)]);
var state_73953__$1 = state_73953;
var statearr_73976_74044 = state_73953__$1;
(statearr_73976_74044[(2)] = inst_73864);

(statearr_73976_74044[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (43))){
var inst_73939 = (state_73953[(16)]);
var inst_73945 = (state_73953[(2)]);
var inst_73946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73947 = [inst_73939,inst_73945];
var inst_73948 = (new cljs.core.PersistentVector(null,2,(5),inst_73946,inst_73947,null));
var _ = (function (){var statearr_73977 = state_73953;
(statearr_73977[(4)] = cljs.core.rest((state_73953[(4)])));

return statearr_73977;
})();
var state_73953__$1 = state_73953;
var statearr_73978_74045 = state_73953__$1;
(statearr_73978_74045[(2)] = inst_73948);

(statearr_73978_74045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (29))){
var inst_73839 = (state_73953[(19)]);
var inst_73894 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73839], 0));
var inst_73895 = ["Invalid block range provided: ",inst_73894].join('');
var inst_73896 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73897 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73898 = cljs.core.PersistentHashMap.fromArrays(inst_73896,inst_73897);
var inst_73899 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73895,inst_73898);
var inst_73900 = (function(){throw inst_73899})();
var state_73953__$1 = state_73953;
var statearr_73979_74046 = state_73953__$1;
(statearr_73979_74046[(2)] = inst_73900);

(statearr_73979_74046[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (6))){
var inst_73831 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_73953__$1 = state_73953;
var statearr_73980_74047 = state_73953__$1;
(statearr_73980_74047[(2)] = inst_73831);

(statearr_73980_74047[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (28))){
var inst_73905 = (state_73953[(2)]);
var state_73953__$1 = state_73953;
var statearr_73981_74048 = state_73953__$1;
(statearr_73981_74048[(2)] = inst_73905);

(statearr_73981_74048[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (25))){
var inst_73910 = (state_73953[(17)]);
var inst_73908 = (state_73953[(9)]);
var inst_73907 = (state_73953[(2)]);
var inst_73908__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73907,(0),null);
var inst_73909 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73907,(1),null);
var inst_73910__$1 = cljs.core.pos_int_QMARK_(inst_73908__$1);
var state_73953__$1 = (function (){var statearr_73982 = state_73953;
(statearr_73982[(17)] = inst_73910__$1);

(statearr_73982[(9)] = inst_73908__$1);

(statearr_73982[(10)] = inst_73909);

return statearr_73982;
})();
if(inst_73910__$1){
var statearr_73983_74049 = state_73953__$1;
(statearr_73983_74049[(1)] = (32));

} else {
var statearr_73984_74050 = state_73953__$1;
(statearr_73984_74050[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (34))){
var inst_73915 = (state_73953[(2)]);
var inst_73916 = cljs.core.not(inst_73915);
var state_73953__$1 = state_73953;
if(inst_73916){
var statearr_73985_74051 = state_73953__$1;
(statearr_73985_74051[(1)] = (35));

} else {
var statearr_73986_74052 = state_73953__$1;
(statearr_73986_74052[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (17))){
var inst_73864 = (state_73953[(14)]);
var inst_73862 = (state_73953[(8)]);
var inst_73867 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73862], 0));
var inst_73868 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73864], 0));
var inst_73869 = ["Start block is out of range for this ledger. Start block provided: ",inst_73867,". Database block: ",inst_73868].join('');
var inst_73870 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73871 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73872 = cljs.core.PersistentHashMap.fromArrays(inst_73870,inst_73871);
var inst_73873 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73869,inst_73872);
var inst_73874 = (function(){throw inst_73873})();
var state_73953__$1 = state_73953;
var statearr_73987_74053 = state_73953__$1;
(statearr_73987_74053[(2)] = inst_73874);

(statearr_73987_74053[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (3))){
var inst_73951 = (state_73953[(2)]);
var state_73953__$1 = state_73953;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73953__$1,inst_73951);
} else {
if((state_val_73954 === (12))){
var inst_73839 = (state_73953[(19)]);
var inst_73848 = (state_73953[(18)]);
var inst_73846 = (state_73953[(2)]);
var inst_73847 = fluree.db.util.async.throw_err(inst_73846);
var inst_73848__$1 = cljs.core.second(inst_73839);
var state_73953__$1 = (function (){var statearr_73988 = state_73953;
(statearr_73988[(18)] = inst_73848__$1);

(statearr_73988[(13)] = inst_73847);

return statearr_73988;
})();
if(cljs.core.truth_(inst_73848__$1)){
var statearr_73989_74054 = state_73953__$1;
(statearr_73989_74054[(1)] = (13));

} else {
var statearr_73990_74055 = state_73953__$1;
(statearr_73990_74055[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (2))){
var _ = (function (){var statearr_73991 = state_73953;
(statearr_73991[(4)] = cljs.core.cons((5),(state_73953[(4)])));

return statearr_73991;
})();
var inst_73828 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73829 = cljs.core.sequential_QMARK_(inst_73828);
var state_73953__$1 = state_73953;
if(inst_73829){
var statearr_73992_74056 = state_73953__$1;
(statearr_73992_74056[(1)] = (6));

} else {
var statearr_73993_74057 = state_73953__$1;
(statearr_73993_74057[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (23))){
var inst_73863 = (state_73953[(7)]);
var inst_73862 = (state_73953[(8)]);
var inst_73883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73884 = [inst_73862,inst_73863];
var inst_73885 = (new cljs.core.PersistentVector(null,2,(5),inst_73883,inst_73884,null));
var state_73953__$1 = state_73953;
var statearr_73994_74058 = state_73953__$1;
(statearr_73994_74058[(2)] = inst_73885);

(statearr_73994_74058[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (35))){
var inst_73839 = (state_73953[(19)]);
var inst_73918 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73839], 0));
var inst_73919 = ["Invalid block range provided: ",inst_73918].join('');
var inst_73920 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73921 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73922 = cljs.core.PersistentHashMap.fromArrays(inst_73920,inst_73921);
var inst_73923 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73919,inst_73922);
var inst_73924 = (function(){throw inst_73923})();
var state_73953__$1 = state_73953;
var statearr_73995_74059 = state_73953__$1;
(statearr_73995_74059[(2)] = inst_73924);

(statearr_73995_74059[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (19))){
var inst_73862 = (state_73953[(8)]);
var inst_73877 = (state_73953[(2)]);
var state_73953__$1 = (function (){var statearr_73996 = state_73953;
(statearr_73996[(20)] = inst_73877);

return statearr_73996;
})();
if(cljs.core.truth_(inst_73862)){
var statearr_73997_74060 = state_73953__$1;
(statearr_73997_74060[(1)] = (20));

} else {
var statearr_73998_74061 = state_73953__$1;
(statearr_73998_74061[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (11))){
var inst_73864 = (state_73953[(14)]);
var inst_73862 = (state_73953[(8)]);
var inst_73861 = (state_73953[(2)]);
var inst_73862__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73861,(0),null);
var inst_73863 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73861,(1),null);
var inst_73864__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_73865 = (inst_73862__$1 > inst_73864__$1);
var state_73953__$1 = (function (){var statearr_74000 = state_73953;
(statearr_74000[(14)] = inst_73864__$1);

(statearr_74000[(7)] = inst_73863);

(statearr_74000[(8)] = inst_73862__$1);

return statearr_74000;
})();
if(cljs.core.truth_(inst_73865)){
var statearr_74001_74062 = state_73953__$1;
(statearr_74001_74062[(1)] = (17));

} else {
var statearr_74002_74063 = state_73953__$1;
(statearr_74002_74063[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (9))){
var inst_73839 = (state_73953[(19)]);
var inst_73842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73843 = cljs.core.first(inst_73839);
var inst_73844 = fluree.db.time_travel.block_to_int_format(db,inst_73843);
var state_73953__$1 = (function (){var statearr_74003 = state_73953;
(statearr_74003[(12)] = inst_73842);

return statearr_74003;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73953__$1,(12),inst_73844);
} else {
if((state_val_73954 === (5))){
var _ = (function (){var statearr_74004 = state_73953;
(statearr_74004[(4)] = cljs.core.rest((state_73953[(4)])));

return statearr_74004;
})();
var state_73953__$1 = state_73953;
var ex73999 = (state_73953__$1[(2)]);
var statearr_74005_74064 = state_73953__$1;
(statearr_74005_74064[(5)] = ex73999);


var statearr_74006_74065 = state_73953__$1;
(statearr_74006_74065[(1)] = (4));

(statearr_74006_74065[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (14))){
var state_73953__$1 = state_73953;
var statearr_74007_74066 = state_73953__$1;
(statearr_74007_74066[(2)] = null);

(statearr_74007_74066[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (26))){
var inst_73862 = (state_73953[(8)]);
var inst_73888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73889 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_73890 = [inst_73862,inst_73889];
var inst_73891 = (new cljs.core.PersistentVector(null,2,(5),inst_73888,inst_73890,null));
var state_73953__$1 = state_73953;
var statearr_74008_74067 = state_73953__$1;
(statearr_74008_74067[(2)] = inst_73891);

(statearr_74008_74067[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (16))){
var inst_73852 = (state_73953[(2)]);
var inst_73853 = fluree.db.util.async.throw_err(inst_73852);
var state_73953__$1 = state_73953;
var statearr_74009_74068 = state_73953__$1;
(statearr_74009_74068[(2)] = inst_73853);

(statearr_74009_74068[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (38))){
var inst_73908 = (state_73953[(9)]);
var inst_73909 = (state_73953[(10)]);
var inst_73930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73931 = [inst_73909,inst_73908];
var inst_73932 = (new cljs.core.PersistentVector(null,2,(5),inst_73930,inst_73931,null));
var state_73953__$1 = state_73953;
var statearr_74010_74069 = state_73953__$1;
(statearr_74010_74069[(2)] = inst_73932);

(statearr_74010_74069[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (30))){
var state_73953__$1 = state_73953;
var statearr_74011_74070 = state_73953__$1;
(statearr_74011_74070[(2)] = null);

(statearr_74011_74070[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (10))){
var inst_73839 = (state_73953[(19)]);
var state_73953__$1 = state_73953;
var statearr_74012_74071 = state_73953__$1;
(statearr_74012_74071[(2)] = inst_73839);

(statearr_74012_74071[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (18))){
var state_73953__$1 = state_73953;
var statearr_74013_74072 = state_73953__$1;
(statearr_74013_74072[(2)] = null);

(statearr_74013_74072[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (42))){
var inst_73940 = (state_73953[(15)]);
var state_73953__$1 = state_73953;
var statearr_74014_74073 = state_73953__$1;
(statearr_74014_74073[(2)] = inst_73940);

(statearr_74014_74073[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (37))){
var inst_73908 = (state_73953[(9)]);
var inst_73909 = (state_73953[(10)]);
var inst_73927 = (state_73953[(2)]);
var inst_73928 = (inst_73909 < inst_73908);
var state_73953__$1 = (function (){var statearr_74015 = state_73953;
(statearr_74015[(21)] = inst_73927);

return statearr_74015;
})();
if(cljs.core.truth_(inst_73928)){
var statearr_74016_74074 = state_73953__$1;
(statearr_74016_74074[(1)] = (38));

} else {
var statearr_74017_74075 = state_73953__$1;
(statearr_74017_74075[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73954 === (8))){
var inst_73839 = (state_73953[(19)]);
var inst_73839__$1 = (state_73953[(2)]);
var inst_73840 = cljs.core.some(cljs.core.string_QMARK_,inst_73839__$1);
var state_73953__$1 = (function (){var statearr_74018 = state_73953;
(statearr_74018[(19)] = inst_73839__$1);

return statearr_74018;
})();
if(cljs.core.truth_(inst_73840)){
var statearr_74019_74076 = state_73953__$1;
(statearr_74019_74076[(1)] = (9));

} else {
var statearr_74020_74077 = state_73953__$1;
(statearr_74020_74077[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_74021 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74021[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__);

(statearr_74021[(1)] = (1));

return statearr_74021;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_73953){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73953);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74022){var ex__2730__auto__ = e74022;
var statearr_74023_74078 = state_73953;
(statearr_74023_74078[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73953[(4)]))){
var statearr_74024_74079 = state_73953;
(statearr_74024_74079[(1)] = cljs.core.first((state_73953[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74080 = state_73953;
state_73953 = G__74080;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__ = function(state_73953){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_73953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74025 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74025[(6)] = c__2749__auto__);

return statearr_74025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__74082 = arguments.length;
switch (G__74082) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74176){
var state_val_74177 = (state_74176[(1)]);
if((state_val_74177 === (7))){
var inst_74108 = (state_74176[(7)]);
var inst_74111 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_74108);
var state_74176__$1 = state_74176;
var statearr_74178_74229 = state_74176__$1;
(statearr_74178_74229[(2)] = inst_74111);

(statearr_74178_74229[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (20))){
var inst_74147 = (state_74176[(8)]);
var inst_74150 = fluree.db.api_js.format_block_resp_pretty(db,inst_74147);
var state_74176__$1 = state_74176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74176__$1,(23),inst_74150);
} else {
if((state_val_74177 === (27))){
var inst_74156 = (state_74176[(9)]);
var inst_74162 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_74156);
var state_74176__$1 = state_74176;
var statearr_74179_74230 = state_74176__$1;
(statearr_74179_74230[(2)] = inst_74162);

(statearr_74179_74230[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (1))){
var state_74176__$1 = state_74176;
var statearr_74180_74231 = state_74176__$1;
(statearr_74180_74231[(2)] = null);

(statearr_74180_74231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (24))){
var inst_74156 = (state_74176[(9)]);
var inst_74159 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_74160 = cljs.core.sequential_QMARK_(inst_74156);
var state_74176__$1 = (function (){var statearr_74181 = state_74176;
(statearr_74181[(10)] = inst_74159);

return statearr_74181;
})();
if(inst_74160){
var statearr_74182_74232 = state_74176__$1;
(statearr_74182_74232[(1)] = (27));

} else {
var statearr_74183_74233 = state_74176__$1;
(statearr_74183_74233[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (4))){
var inst_74083 = (state_74176[(2)]);
var inst_74084 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74085 = [inst_74083];
var inst_74086 = (new cljs.core.PersistentVector(null,1,(5),inst_74084,inst_74085,null));
var inst_74087 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_74086);
var inst_74088 = cljs.core.ex_data(inst_74083);
var inst_74089 = cljs.core.ex_message(inst_74083);
var inst_74090 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74088,new cljs.core.Keyword(null,"message","message",-406056002),inst_74089);
var state_74176__$1 = (function (){var statearr_74184 = state_74176;
(statearr_74184[(11)] = inst_74087);

return statearr_74184;
})();
var statearr_74185_74234 = state_74176__$1;
(statearr_74185_74234[(2)] = inst_74090);

(statearr_74185_74234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (15))){
var inst_74108 = (state_74176[(7)]);
var inst_74121 = (state_74176[(2)]);
var inst_74122 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74121,inst_74108);
var inst_74123 = (function(){throw inst_74122})();
var state_74176__$1 = state_74176;
var statearr_74186_74235 = state_74176__$1;
(statearr_74186_74235[(2)] = inst_74123);

(statearr_74186_74235[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (21))){
var inst_74147 = (state_74176[(8)]);
var state_74176__$1 = state_74176;
var statearr_74187_74236 = state_74176__$1;
(statearr_74187_74236[(2)] = inst_74147);

(statearr_74187_74236[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (13))){
var inst_74116 = (state_74176[(12)]);
var state_74176__$1 = state_74176;
var statearr_74188_74237 = state_74176__$1;
(statearr_74188_74237[(2)] = inst_74116);

(statearr_74188_74237[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (22))){
var inst_74156 = (state_74176[(2)]);
var inst_74157 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_74176__$1 = (function (){var statearr_74189 = state_74176;
(statearr_74189[(9)] = inst_74156);

return statearr_74189;
})();
if(cljs.core.truth_(inst_74157)){
var statearr_74190_74238 = state_74176__$1;
(statearr_74190_74238[(1)] = (24));

} else {
var statearr_74191_74239 = state_74176__$1;
(statearr_74191_74239[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (29))){
var inst_74100 = (state_74176[(13)]);
var inst_74159 = (state_74176[(10)]);
var inst_74165 = (state_74176[(2)]);
var inst_74166 = fluree.db.util.core.response_time_formatted(inst_74100);
var inst_74167 = [(200),inst_74165,(100),inst_74166];
var inst_74168 = cljs.core.PersistentHashMap.fromArrays(inst_74159,inst_74167);
var state_74176__$1 = state_74176;
var statearr_74192_74240 = state_74176__$1;
(statearr_74192_74240[(2)] = inst_74168);

(statearr_74192_74240[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (6))){
var inst_74108 = (state_74176[(7)]);
var inst_74109 = (state_74176[(14)]);
var inst_74107 = (state_74176[(2)]);
var inst_74108__$1 = fluree.db.util.async.throw_err(inst_74107);
var inst_74109__$1 = cljs.core.map_QMARK_(inst_74108__$1);
var state_74176__$1 = (function (){var statearr_74193 = state_74176;
(statearr_74193[(7)] = inst_74108__$1);

(statearr_74193[(14)] = inst_74109__$1);

return statearr_74193;
})();
if(inst_74109__$1){
var statearr_74194_74241 = state_74176__$1;
(statearr_74194_74241[(1)] = (7));

} else {
var statearr_74195_74242 = state_74176__$1;
(statearr_74195_74242[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (28))){
var inst_74156 = (state_74176[(9)]);
var state_74176__$1 = state_74176;
var statearr_74196_74243 = state_74176__$1;
(statearr_74196_74243[(2)] = inst_74156);

(statearr_74196_74243[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (25))){
var inst_74156 = (state_74176[(9)]);
var state_74176__$1 = state_74176;
var statearr_74197_74244 = state_74176__$1;
(statearr_74197_74244[(2)] = inst_74156);

(statearr_74197_74244[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (17))){
var inst_74139 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_74140 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_74139].join('');
var inst_74141 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74142 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74143 = cljs.core.PersistentHashMap.fromArrays(inst_74141,inst_74142);
var inst_74144 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74140,inst_74143);
var inst_74145 = (function(){throw inst_74144})();
var state_74176__$1 = state_74176;
var statearr_74198_74245 = state_74176__$1;
(statearr_74198_74245[(2)] = inst_74145);

(statearr_74198_74245[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (3))){
var inst_74174 = (state_74176[(2)]);
var state_74176__$1 = state_74176;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74176__$1,inst_74174);
} else {
if((state_val_74177 === (12))){
var inst_74108 = (state_74176[(7)]);
var inst_74126 = (state_74176[(2)]);
var inst_74127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74108,(0),null);
var inst_74128 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74108,(1),null);
var inst_74129 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_74130 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_74131 = cljs.core.keys(inst_74130);
var inst_74132 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74129,inst_74131);
var state_74176__$1 = (function (){var statearr_74199 = state_74176;
(statearr_74199[(15)] = inst_74127);

(statearr_74199[(16)] = inst_74126);

(statearr_74199[(17)] = inst_74128);

return statearr_74199;
})();
if(inst_74132){
var statearr_74200_74246 = state_74176__$1;
(statearr_74200_74246[(1)] = (16));

} else {
var statearr_74201_74247 = state_74176__$1;
(statearr_74201_74247[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (2))){
var _ = (function (){var statearr_74202 = state_74176;
(statearr_74202[(4)] = cljs.core.cons((5),(state_74176[(4)])));

return statearr_74202;
})();
var inst_74100 = fluree.db.util.core.current_time_millis();
var inst_74101 = db;
var inst_74102 = cljs.core.__destructure_map(inst_74101);
var inst_74103 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74102,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_74104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74102,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_74105 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_74176__$1 = (function (){var statearr_74203 = state_74176;
(statearr_74203[(18)] = inst_74103);

(statearr_74203[(13)] = inst_74100);

(statearr_74203[(19)] = inst_74104);

return statearr_74203;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74176__$1,(6),inst_74105);
} else {
if((state_val_74177 === (23))){
var inst_74152 = (state_74176[(2)]);
var inst_74153 = fluree.db.util.async.throw_err(inst_74152);
var state_74176__$1 = state_74176;
var statearr_74204_74248 = state_74176__$1;
(statearr_74204_74248[(2)] = inst_74153);

(statearr_74204_74248[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (19))){
var inst_74136 = (state_74176[(2)]);
var inst_74137 = fluree.db.util.async.throw_err(inst_74136);
var state_74176__$1 = state_74176;
var statearr_74205_74249 = state_74176__$1;
(statearr_74205_74249[(2)] = inst_74137);

(statearr_74205_74249[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (11))){
var state_74176__$1 = state_74176;
var statearr_74207_74250 = state_74176__$1;
(statearr_74207_74250[(2)] = null);

(statearr_74207_74250[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (9))){
var inst_74114 = (state_74176[(2)]);
var state_74176__$1 = state_74176;
if(cljs.core.truth_(inst_74114)){
var statearr_74208_74251 = state_74176__$1;
(statearr_74208_74251[(1)] = (10));

} else {
var statearr_74209_74252 = state_74176__$1;
(statearr_74209_74252[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (5))){
var _ = (function (){var statearr_74210 = state_74176;
(statearr_74210[(4)] = cljs.core.rest((state_74176[(4)])));

return statearr_74210;
})();
var state_74176__$1 = state_74176;
var ex74206 = (state_74176__$1[(2)]);
var statearr_74211_74253 = state_74176__$1;
(statearr_74211_74253[(5)] = ex74206);


var statearr_74212_74254 = state_74176__$1;
(statearr_74212_74254[(1)] = (4));

(statearr_74212_74254[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (14))){
var inst_74103 = (state_74176[(18)]);
var inst_74104 = (state_74176[(19)]);
var inst_74119 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74103),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74104)].join('');
var state_74176__$1 = state_74176;
var statearr_74213_74255 = state_74176__$1;
(statearr_74213_74255[(2)] = inst_74119);

(statearr_74213_74255[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (26))){
var inst_74171 = (state_74176[(2)]);
var _ = (function (){var statearr_74214 = state_74176;
(statearr_74214[(4)] = cljs.core.rest((state_74176[(4)])));

return statearr_74214;
})();
var state_74176__$1 = state_74176;
var statearr_74215_74256 = state_74176__$1;
(statearr_74215_74256[(2)] = inst_74171);

(statearr_74215_74256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (16))){
var inst_74127 = (state_74176[(15)]);
var inst_74128 = (state_74176[(17)]);
var inst_74134 = fluree.db.query.block.block_range(db,inst_74127,inst_74128,opts);
var state_74176__$1 = state_74176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74176__$1,(19),inst_74134);
} else {
if((state_val_74177 === (10))){
var inst_74108 = (state_74176[(7)]);
var inst_74116 = (state_74176[(12)]);
var inst_74116__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_74108);
var state_74176__$1 = (function (){var statearr_74216 = state_74176;
(statearr_74216[(12)] = inst_74116__$1);

return statearr_74216;
})();
if(cljs.core.truth_(inst_74116__$1)){
var statearr_74217_74257 = state_74176__$1;
(statearr_74217_74257[(1)] = (13));

} else {
var statearr_74218_74258 = state_74176__$1;
(statearr_74218_74258[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (18))){
var inst_74147 = (state_74176[(2)]);
var inst_74148 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_74176__$1 = (function (){var statearr_74219 = state_74176;
(statearr_74219[(8)] = inst_74147);

return statearr_74219;
})();
if(cljs.core.truth_(inst_74148)){
var statearr_74220_74259 = state_74176__$1;
(statearr_74220_74259[(1)] = (20));

} else {
var statearr_74221_74260 = state_74176__$1;
(statearr_74221_74260[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (8))){
var inst_74109 = (state_74176[(14)]);
var state_74176__$1 = state_74176;
var statearr_74222_74261 = state_74176__$1;
(statearr_74222_74261[(2)] = inst_74109);

(statearr_74222_74261[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74223 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74223[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74223[(1)] = (1));

return statearr_74223;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74176){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74176);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74224){var ex__2730__auto__ = e74224;
var statearr_74225_74262 = state_74176;
(statearr_74225_74262[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74176[(4)]))){
var statearr_74226_74263 = state_74176;
(statearr_74226_74263[(1)] = cljs.core.first((state_74176[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74264 = state_74176;
state_74176 = G__74264;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74176){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74227 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74227[(6)] = c__2749__auto__);

return statearr_74227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__74266 = arguments.length;
switch (G__74266) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74461){
var state_val_74462 = (state_74461[(1)]);
if((state_val_74462 === (62))){
var inst_74459 = (state_74461[(2)]);
var state_74461__$1 = state_74461;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74461__$1,inst_74459);
} else {
if((state_val_74462 === (7))){
var inst_74287 = (state_74461[(7)]);
var inst_74297 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_74287);
var state_74461__$1 = state_74461;
var statearr_74463_74554 = state_74461__$1;
(statearr_74463_74554[(2)] = inst_74297);

(statearr_74463_74554[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (59))){
var inst_74447 = (state_74461[(2)]);
var inst_74448 = fluree.db.util.async.throw_err(inst_74447);
var state_74461__$1 = state_74461;
var statearr_74464_74555 = state_74461__$1;
(statearr_74464_74555[(2)] = inst_74448);

(statearr_74464_74555[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (20))){
var inst_74355 = (state_74461[(8)]);
var inst_74363 = (state_74461[(9)]);
var inst_74355__$1 = (state_74461[(2)]);
var inst_74356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74357 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74355__$1,(0));
var inst_74358 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74355__$1,(1));
var inst_74359 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74355__$1,(2));
var inst_74360 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74355__$1,(3));
var inst_74361 = [inst_74357,inst_74358,inst_74359,inst_74360];
var inst_74362 = (new cljs.core.PersistentVector(null,4,(5),inst_74356,inst_74361,null));
var inst_74363__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74362,(0),null);
var inst_74364 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74362,(1),null);
var inst_74365 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74362,(2),null);
var inst_74366 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74362,(3),null);
var inst_74367 = (inst_74363__$1 == null);
var inst_74368 = cljs.core.not(inst_74367);
var state_74461__$1 = (function (){var statearr_74465 = state_74461;
(statearr_74465[(10)] = inst_74364);

(statearr_74465[(8)] = inst_74355__$1);

(statearr_74465[(9)] = inst_74363__$1);

(statearr_74465[(11)] = inst_74365);

(statearr_74465[(12)] = inst_74366);

return statearr_74465;
})();
if(inst_74368){
var statearr_74466_74556 = state_74461__$1;
(statearr_74466_74556[(1)] = (30));

} else {
var statearr_74467_74557 = state_74461__$1;
(statearr_74467_74557[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (58))){
var inst_74295 = (state_74461[(13)]);
var inst_74451 = (state_74461[(2)]);
var state_74461__$1 = (function (){var statearr_74468 = state_74461;
(statearr_74468[(14)] = inst_74451);

return statearr_74468;
})();
if(cljs.core.truth_(inst_74295)){
var statearr_74469_74558 = state_74461__$1;
(statearr_74469_74558[(1)] = (60));

} else {
var statearr_74470_74559 = state_74461__$1;
(statearr_74470_74559[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (60))){
var inst_74451 = (state_74461[(14)]);
var inst_74439 = (state_74461[(15)]);
var inst_74453 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_74454 = cljs.core.count(inst_74439);
var inst_74455 = [inst_74451,inst_74454,(200)];
var inst_74456 = cljs.core.PersistentHashMap.fromArrays(inst_74453,inst_74455);
var state_74461__$1 = state_74461;
var statearr_74471_74560 = state_74461__$1;
(statearr_74471_74560[(2)] = inst_74456);

(statearr_74471_74560[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (27))){
var inst_74274 = (state_74461[(16)]);
var inst_74343 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74274)].join('');
var inst_74344 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74345 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74346 = cljs.core.PersistentHashMap.fromArrays(inst_74344,inst_74345);
var inst_74347 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74343,inst_74346);
var inst_74348 = (function(){throw inst_74347})();
var state_74461__$1 = state_74461;
var statearr_74472_74561 = state_74461__$1;
(statearr_74472_74561[(2)] = inst_74348);

(statearr_74472_74561[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (1))){
var inst_74271 = query_map;
var inst_74272 = cljs.core.__destructure_map(inst_74271);
var inst_74273 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74272,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74274 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74272,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_74275 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74272,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_74461__$1 = (function (){var statearr_74473 = state_74461;
(statearr_74473[(17)] = inst_74273);

(statearr_74473[(16)] = inst_74274);

(statearr_74473[(18)] = inst_74275);

return statearr_74473;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74461__$1,(2),sources);
} else {
if((state_val_74462 === (24))){
var inst_74274 = (state_74461[(16)]);
var inst_74332 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74274)].join('');
var inst_74333 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74334 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74335 = cljs.core.PersistentHashMap.fromArrays(inst_74333,inst_74334);
var inst_74336 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74332,inst_74335);
var inst_74337 = (function(){throw inst_74336})();
var state_74461__$1 = state_74461;
var statearr_74474_74562 = state_74461__$1;
(statearr_74474_74562[(2)] = inst_74337);

(statearr_74474_74562[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (55))){
var inst_74275 = (state_74461[(18)]);
var inst_74442 = (state_74461[(2)]);
var inst_74443 = fluree.db.util.async.throw_err(inst_74442);
var state_74461__$1 = (function (){var statearr_74475 = state_74461;
(statearr_74475[(19)] = inst_74443);

return statearr_74475;
})();
if(cljs.core.truth_(inst_74275)){
var statearr_74476_74563 = state_74461__$1;
(statearr_74476_74563[(1)] = (56));

} else {
var statearr_74477_74564 = state_74461__$1;
(statearr_74477_74564[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (39))){
var inst_74364 = (state_74461[(10)]);
var inst_74363 = (state_74461[(9)]);
var inst_74365 = (state_74461[(11)]);
var inst_74366 = (state_74461[(12)]);
var inst_74387 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74389 = [inst_74364,inst_74363,inst_74365,inst_74366];
var inst_74390 = (new cljs.core.PersistentVector(null,4,(5),inst_74388,inst_74389,null));
var inst_74391 = [inst_74390,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_74392 = (new cljs.core.PersistentVector(null,2,(5),inst_74387,inst_74391,null));
var state_74461__$1 = state_74461;
var statearr_74478_74565 = state_74461__$1;
(statearr_74478_74565[(2)] = inst_74392);

(statearr_74478_74565[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (46))){
var inst_74397 = (state_74461[(20)]);
var state_74461__$1 = state_74461;
var statearr_74479_74566 = state_74461__$1;
(statearr_74479_74566[(2)] = inst_74397);

(statearr_74479_74566[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (4))){
var state_74461__$1 = state_74461;
var statearr_74480_74567 = state_74461__$1;
(statearr_74480_74567[(2)] = null);

(statearr_74480_74567[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (54))){
var inst_74278 = (state_74461[(21)]);
var inst_74439 = (state_74461[(15)]);
var inst_74438 = (state_74461[(2)]);
var inst_74439__$1 = fluree.db.util.async.throw_err(inst_74438);
var inst_74440 = fluree.db.api_js.format_history_resp(inst_74278,inst_74439__$1);
var state_74461__$1 = (function (){var statearr_74481 = state_74461;
(statearr_74481[(15)] = inst_74439__$1);

return statearr_74481;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74461__$1,(55),inst_74440);
} else {
if((state_val_74462 === (15))){
var inst_74278 = (state_74461[(21)]);
var inst_74319 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74278);
var state_74461__$1 = state_74461;
var statearr_74482_74568 = state_74461__$1;
(statearr_74482_74568[(2)] = inst_74319);

(statearr_74482_74568[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (48))){
var inst_74364 = (state_74461[(10)]);
var inst_74363 = (state_74461[(9)]);
var inst_74365 = (state_74461[(11)]);
var inst_74366 = (state_74461[(12)]);
var inst_74408 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74410 = [inst_74364,inst_74365,inst_74363,inst_74366];
var inst_74411 = (new cljs.core.PersistentVector(null,4,(5),inst_74409,inst_74410,null));
var inst_74412 = [inst_74411,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_74413 = (new cljs.core.PersistentVector(null,2,(5),inst_74408,inst_74412,null));
var state_74461__$1 = state_74461;
var statearr_74483_74569 = state_74461__$1;
(statearr_74483_74569[(2)] = inst_74413);

(statearr_74483_74569[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (50))){
var inst_74426 = (state_74461[(2)]);
var state_74461__$1 = state_74461;
var statearr_74484_74570 = state_74461__$1;
(statearr_74484_74570[(2)] = inst_74426);

(statearr_74484_74570[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (21))){
var inst_74274 = (state_74461[(16)]);
var inst_74330 = cljs.core.empty_QMARK_(inst_74274);
var state_74461__$1 = state_74461;
if(inst_74330){
var statearr_74485_74571 = state_74461__$1;
(statearr_74485_74571[(1)] = (24));

} else {
var statearr_74486_74572 = state_74461__$1;
(statearr_74486_74572[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (31))){
var inst_74363 = (state_74461[(9)]);
var inst_74374 = (state_74461[(22)]);
var inst_74374__$1 = (inst_74363 == null);
var state_74461__$1 = (function (){var statearr_74487 = state_74461;
(statearr_74487[(22)] = inst_74374__$1);

return statearr_74487;
})();
if(cljs.core.truth_(inst_74374__$1)){
var statearr_74488_74573 = state_74461__$1;
(statearr_74488_74573[(1)] = (33));

} else {
var statearr_74489_74574 = state_74461__$1;
(statearr_74489_74574[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (32))){
var inst_74278 = (state_74461[(21)]);
var inst_74321 = (state_74461[(23)]);
var inst_74311 = (state_74461[(24)]);
var inst_74430 = (state_74461[(2)]);
var inst_74431 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74430,(0),null);
var inst_74432 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74430,(1),null);
var inst_74433 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_74434 = [inst_74311,inst_74321];
var inst_74435 = cljs.core.PersistentHashMap.fromArrays(inst_74433,inst_74434);
var inst_74436 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_74278,inst_74432,cljs.core._EQ_,inst_74431,inst_74435);
var state_74461__$1 = state_74461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74461__$1,(54),inst_74436);
} else {
if((state_val_74462 === (40))){
var inst_74394 = (state_74461[(25)]);
var inst_74363 = (state_74461[(9)]);
var inst_74394__$1 = (inst_74363 == null);
var state_74461__$1 = (function (){var statearr_74490 = state_74461;
(statearr_74490[(25)] = inst_74394__$1);

return statearr_74490;
})();
if(cljs.core.truth_(inst_74394__$1)){
var statearr_74491_74575 = state_74461__$1;
(statearr_74491_74575[(1)] = (42));

} else {
var statearr_74492_74576 = state_74461__$1;
(statearr_74492_74576[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (56))){
var inst_74278 = (state_74461[(21)]);
var inst_74443 = (state_74461[(19)]);
var inst_74445 = fluree.db.api_js.format_block_resp_pretty(inst_74278,inst_74443);
var state_74461__$1 = state_74461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74461__$1,(59),inst_74445);
} else {
if((state_val_74462 === (33))){
var inst_74364 = (state_74461[(10)]);
var inst_74377 = (state_74461[(26)]);
var inst_74376 = (inst_74364 == null);
var inst_74377__$1 = cljs.core.not(inst_74376);
var state_74461__$1 = (function (){var statearr_74493 = state_74461;
(statearr_74493[(26)] = inst_74377__$1);

return statearr_74493;
})();
if(inst_74377__$1){
var statearr_74494_74577 = state_74461__$1;
(statearr_74494_74577[(1)] = (36));

} else {
var statearr_74495_74578 = state_74461__$1;
(statearr_74495_74578[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (13))){
var inst_74305 = (state_74461[(2)]);
var inst_74306 = fluree.db.util.async.throw_err(inst_74305);
var inst_74307 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74306);
var inst_74308 = (inst_74307 - (1));
var state_74461__$1 = state_74461;
var statearr_74496_74579 = state_74461__$1;
(statearr_74496_74579[(2)] = inst_74308);

(statearr_74496_74579[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (22))){
var state_74461__$1 = state_74461;
var statearr_74497_74580 = state_74461__$1;
(statearr_74497_74580[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (36))){
var inst_74365 = (state_74461[(11)]);
var inst_74379 = (inst_74365 == null);
var state_74461__$1 = state_74461;
var statearr_74499_74581 = state_74461__$1;
(statearr_74499_74581[(2)] = inst_74379);

(statearr_74499_74581[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (41))){
var inst_74428 = (state_74461[(2)]);
var state_74461__$1 = state_74461;
var statearr_74500_74582 = state_74461__$1;
(statearr_74500_74582[(2)] = inst_74428);

(statearr_74500_74582[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (43))){
var inst_74394 = (state_74461[(25)]);
var state_74461__$1 = state_74461;
var statearr_74501_74583 = state_74461__$1;
(statearr_74501_74583[(2)] = inst_74394);

(statearr_74501_74583[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (61))){
var inst_74451 = (state_74461[(14)]);
var state_74461__$1 = state_74461;
var statearr_74502_74584 = state_74461__$1;
(statearr_74502_74584[(2)] = inst_74451);

(statearr_74502_74584[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (29))){
var inst_74351 = (state_74461[(2)]);
var state_74461__$1 = state_74461;
var statearr_74503_74585 = state_74461__$1;
(statearr_74503_74585[(2)] = inst_74351);

(statearr_74503_74585[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (44))){
var inst_74406 = (state_74461[(2)]);
var state_74461__$1 = state_74461;
if(cljs.core.truth_(inst_74406)){
var statearr_74504_74586 = state_74461__$1;
(statearr_74504_74586[(1)] = (48));

} else {
var statearr_74505_74587 = state_74461__$1;
(statearr_74505_74587[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (6))){
var inst_74282 = (state_74461[(2)]);
var inst_74283 = fluree.db.util.async.throw_err(inst_74282);
var state_74461__$1 = state_74461;
var statearr_74506_74588 = state_74461__$1;
(statearr_74506_74588[(2)] = inst_74283);

(statearr_74506_74588[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (28))){
var state_74461__$1 = state_74461;
var statearr_74507_74589 = state_74461__$1;
(statearr_74507_74589[(2)] = null);

(statearr_74507_74589[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (51))){
var inst_74274 = (state_74461[(16)]);
var inst_74416 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74274)].join('');
var inst_74417 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74418 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74419 = cljs.core.PersistentHashMap.fromArrays(inst_74417,inst_74418);
var inst_74420 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74416,inst_74419);
var inst_74421 = (function(){throw inst_74420})();
var state_74461__$1 = state_74461;
var statearr_74508_74590 = state_74461__$1;
(statearr_74508_74590[(2)] = inst_74421);

(statearr_74508_74590[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (25))){
var inst_74274 = (state_74461[(16)]);
var state_74461__$1 = state_74461;
var statearr_74509_74591 = state_74461__$1;
(statearr_74509_74591[(2)] = inst_74274);

(statearr_74509_74591[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (34))){
var inst_74374 = (state_74461[(22)]);
var state_74461__$1 = state_74461;
var statearr_74510_74592 = state_74461__$1;
(statearr_74510_74592[(2)] = inst_74374);

(statearr_74510_74592[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (17))){
var inst_74315 = (state_74461[(2)]);
var inst_74316 = fluree.db.util.async.throw_err(inst_74315);
var inst_74317 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74316);
var state_74461__$1 = state_74461;
var statearr_74511_74593 = state_74461__$1;
(statearr_74511_74593[(2)] = inst_74317);

(statearr_74511_74593[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (3))){
var inst_74278 = (state_74461[(21)]);
var inst_74280 = fluree.db.api_js.resolve_block_range(inst_74278,query_map);
var state_74461__$1 = state_74461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74461__$1,(6),inst_74280);
} else {
if((state_val_74462 === (12))){
var inst_74288 = (state_74461[(27)]);
var inst_74311 = (state_74461[(2)]);
var state_74461__$1 = (function (){var statearr_74512 = state_74461;
(statearr_74512[(24)] = inst_74311);

return statearr_74512;
})();
if(cljs.core.truth_(inst_74288)){
var statearr_74513_74594 = state_74461__$1;
(statearr_74513_74594[(1)] = (14));

} else {
var statearr_74514_74595 = state_74461__$1;
(statearr_74514_74595[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (2))){
var inst_74273 = (state_74461[(17)]);
var inst_74277 = (state_74461[(2)]);
var inst_74278 = fluree.db.util.async.throw_err(inst_74277);
var state_74461__$1 = (function (){var statearr_74515 = state_74461;
(statearr_74515[(21)] = inst_74278);

return statearr_74515;
})();
if(cljs.core.truth_(inst_74273)){
var statearr_74516_74596 = state_74461__$1;
(statearr_74516_74596[(1)] = (3));

} else {
var statearr_74517_74597 = state_74461__$1;
(statearr_74517_74597[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (23))){
var inst_74353 = (state_74461[(2)]);
var state_74461__$1 = state_74461;
var statearr_74518_74598 = state_74461__$1;
(statearr_74518_74598[(2)] = inst_74353);

(statearr_74518_74598[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (47))){
var inst_74403 = (state_74461[(2)]);
var state_74461__$1 = state_74461;
var statearr_74519_74599 = state_74461__$1;
(statearr_74519_74599[(2)] = inst_74403);

(statearr_74519_74599[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (35))){
var inst_74385 = (state_74461[(2)]);
var state_74461__$1 = state_74461;
if(cljs.core.truth_(inst_74385)){
var statearr_74520_74600 = state_74461__$1;
(statearr_74520_74600[(1)] = (39));

} else {
var statearr_74521_74601 = state_74461__$1;
(statearr_74521_74601[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (19))){
var inst_74274 = (state_74461[(16)]);
var inst_74328 = cljs.core.sequential_QMARK_(inst_74274);
var state_74461__$1 = state_74461;
if(inst_74328){
var statearr_74522_74602 = state_74461__$1;
(statearr_74522_74602[(1)] = (21));

} else {
var statearr_74523_74603 = state_74461__$1;
(statearr_74523_74603[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (57))){
var inst_74443 = (state_74461[(19)]);
var state_74461__$1 = state_74461;
var statearr_74524_74604 = state_74461__$1;
(statearr_74524_74604[(2)] = inst_74443);

(statearr_74524_74604[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (11))){
var state_74461__$1 = state_74461;
var statearr_74525_74605 = state_74461__$1;
(statearr_74525_74605[(2)] = (-1));

(statearr_74525_74605[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (9))){
var inst_74300 = (state_74461[(2)]);
var state_74461__$1 = state_74461;
if(cljs.core.truth_(inst_74300)){
var statearr_74526_74606 = state_74461__$1;
(statearr_74526_74606[(1)] = (10));

} else {
var statearr_74527_74607 = state_74461__$1;
(statearr_74527_74607[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (5))){
var inst_74287 = (state_74461[(7)]);
var inst_74286 = (state_74461[(2)]);
var inst_74287__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74286,(0),null);
var inst_74288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74286,(1),null);
var inst_74295 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_74461__$1 = (function (){var statearr_74528 = state_74461;
(statearr_74528[(27)] = inst_74288);

(statearr_74528[(7)] = inst_74287__$1);

(statearr_74528[(13)] = inst_74295);

return statearr_74528;
})();
if(cljs.core.truth_(inst_74287__$1)){
var statearr_74529_74608 = state_74461__$1;
(statearr_74529_74608[(1)] = (7));

} else {
var statearr_74530_74609 = state_74461__$1;
(statearr_74530_74609[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (14))){
var inst_74288 = (state_74461[(27)]);
var inst_74278 = (state_74461[(21)]);
var inst_74313 = fluree.db.time_travel.as_of_block(inst_74278,inst_74288);
var state_74461__$1 = state_74461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74461__$1,(17),inst_74313);
} else {
if((state_val_74462 === (45))){
var inst_74365 = (state_74461[(11)]);
var inst_74399 = (inst_74365 == null);
var inst_74400 = cljs.core.not(inst_74399);
var state_74461__$1 = state_74461;
var statearr_74531_74610 = state_74461__$1;
(statearr_74531_74610[(2)] = inst_74400);

(statearr_74531_74610[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (53))){
var inst_74424 = (state_74461[(2)]);
var state_74461__$1 = state_74461;
var statearr_74532_74611 = state_74461__$1;
(statearr_74532_74611[(2)] = inst_74424);

(statearr_74532_74611[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (26))){
var inst_74340 = (state_74461[(2)]);
var state_74461__$1 = state_74461;
var statearr_74533_74612 = state_74461__$1;
(statearr_74533_74612[(2)] = inst_74340);

(statearr_74533_74612[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (16))){
var inst_74274 = (state_74461[(16)]);
var inst_74321 = (state_74461[(2)]);
var inst_74322 = fluree.db.util.core.subj_ident_QMARK_(inst_74274);
var state_74461__$1 = (function (){var statearr_74534 = state_74461;
(statearr_74534[(23)] = inst_74321);

return statearr_74534;
})();
if(inst_74322){
var statearr_74535_74613 = state_74461__$1;
(statearr_74535_74613[(1)] = (18));

} else {
var statearr_74536_74614 = state_74461__$1;
(statearr_74536_74614[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (38))){
var inst_74382 = (state_74461[(2)]);
var state_74461__$1 = state_74461;
var statearr_74537_74615 = state_74461__$1;
(statearr_74537_74615[(2)] = inst_74382);

(statearr_74537_74615[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (30))){
var inst_74355 = (state_74461[(8)]);
var inst_74370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74371 = [inst_74355,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_74372 = (new cljs.core.PersistentVector(null,2,(5),inst_74370,inst_74371,null));
var state_74461__$1 = state_74461;
var statearr_74538_74616 = state_74461__$1;
(statearr_74538_74616[(2)] = inst_74372);

(statearr_74538_74616[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (10))){
var inst_74278 = (state_74461[(21)]);
var inst_74287 = (state_74461[(7)]);
var inst_74302 = (inst_74287 - (1));
var inst_74303 = fluree.db.time_travel.as_of_block(inst_74278,inst_74302);
var state_74461__$1 = state_74461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74461__$1,(13),inst_74303);
} else {
if((state_val_74462 === (18))){
var inst_74274 = (state_74461[(16)]);
var inst_74324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74325 = [inst_74274];
var inst_74326 = (new cljs.core.PersistentVector(null,1,(5),inst_74324,inst_74325,null));
var state_74461__$1 = state_74461;
var statearr_74539_74617 = state_74461__$1;
(statearr_74539_74617[(2)] = inst_74326);

(statearr_74539_74617[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (52))){
var state_74461__$1 = state_74461;
var statearr_74540_74618 = state_74461__$1;
(statearr_74540_74618[(2)] = null);

(statearr_74540_74618[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (42))){
var inst_74364 = (state_74461[(10)]);
var inst_74397 = (state_74461[(20)]);
var inst_74396 = (inst_74364 == null);
var inst_74397__$1 = cljs.core.not(inst_74396);
var state_74461__$1 = (function (){var statearr_74541 = state_74461;
(statearr_74541[(20)] = inst_74397__$1);

return statearr_74541;
})();
if(inst_74397__$1){
var statearr_74542_74619 = state_74461__$1;
(statearr_74542_74619[(1)] = (45));

} else {
var statearr_74543_74620 = state_74461__$1;
(statearr_74543_74620[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (37))){
var inst_74377 = (state_74461[(26)]);
var state_74461__$1 = state_74461;
var statearr_74544_74621 = state_74461__$1;
(statearr_74544_74621[(2)] = inst_74377);

(statearr_74544_74621[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (8))){
var inst_74287 = (state_74461[(7)]);
var state_74461__$1 = state_74461;
var statearr_74545_74622 = state_74461__$1;
(statearr_74545_74622[(2)] = inst_74287);

(statearr_74545_74622[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74462 === (49))){
var state_74461__$1 = state_74461;
var statearr_74546_74623 = state_74461__$1;
(statearr_74546_74623[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74548 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74548[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74548[(1)] = (1));

return statearr_74548;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74461){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74461);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74549){var ex__2730__auto__ = e74549;
var statearr_74550_74624 = state_74461;
(statearr_74550_74624[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74461[(4)]))){
var statearr_74551_74625 = state_74461;
(statearr_74551_74625[(1)] = cljs.core.first((state_74461[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74626 = state_74461;
state_74461 = G__74626;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74461){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74552 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74552[(6)] = c__2749__auto__);

return statearr_74552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__74634 = arguments.length;
switch (G__74634) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__74627_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__74627_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74723){
var state_val_74724 = (state_74723[(1)]);
if((state_val_74724 === (7))){
var inst_74684 = (state_74723[(7)]);
var inst_74674 = (state_74723[(8)]);
var inst_74677 = (state_74723[(9)]);
var inst_74680 = (state_74723[(10)]);
var inst_74690 = (function (){var responses = inst_74674;
var responses_STAR_ = inst_74677;
var statuses = inst_74680;
var fuel = inst_74684;
return (function (p1__74630_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__74630_SHARP_);
});
})();
var inst_74691 = cljs.core.some(inst_74690,inst_74680);
var state_74723__$1 = state_74723;
if(cljs.core.truth_(inst_74691)){
var statearr_74725_74773 = state_74723__$1;
(statearr_74725_74773[(1)] = (9));

} else {
var statearr_74726_74774 = state_74723__$1;
(statearr_74726_74774[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (20))){
var inst_74718 = (state_74723[(2)]);
var state_74723__$1 = state_74723;
var statearr_74727_74775 = state_74723__$1;
(statearr_74727_74775[(2)] = inst_74718);

(statearr_74727_74775[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (1))){
var inst_74669 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_74670 = (function (){var c__2749__auto____$1 = inst_74669;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74667){
var state_val_74668 = (state_74667[(1)]);
if((state_val_74668 === (1))){
var inst_74635 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_74636 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_74637 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74636,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_74638 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_74639 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_74640 = cljs.core.PersistentHashMap.EMPTY;
var inst_74641 = inst_74635;
var inst_74642 = inst_74637;
var inst_74643 = inst_74638;
var inst_74644 = inst_74639;
var inst_74645 = inst_74640;
var state_74667__$1 = (function (){var statearr_74728 = state_74667;
(statearr_74728[(7)] = inst_74642);

(statearr_74728[(8)] = inst_74643);

(statearr_74728[(9)] = inst_74645);

(statearr_74728[(10)] = inst_74644);

(statearr_74728[(11)] = inst_74641);

return statearr_74728;
})();
var statearr_74729_74776 = state_74667__$1;
(statearr_74729_74776[(2)] = null);

(statearr_74729_74776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74668 === (2))){
var inst_74642 = (state_74667[(7)]);
var inst_74647 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_74642);
var inst_74648 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_74647], 0));
var inst_74649 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74642,new cljs.core.Keyword(null,"opts","opts",155075701),inst_74648);
var inst_74650 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_74649,db_fn);
var state_74667__$1 = state_74667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74667__$1,(4),inst_74650);
} else {
if((state_val_74668 === (3))){
var inst_74665 = (state_74667[(2)]);
var state_74667__$1 = state_74667;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74667__$1,inst_74665);
} else {
if((state_val_74668 === (4))){
var inst_74643 = (state_74667[(8)]);
var inst_74645 = (state_74667[(9)]);
var inst_74641 = (state_74667[(11)]);
var inst_74652 = (state_74667[(2)]);
var inst_74653 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74645,inst_74641,inst_74652);
var inst_74654 = cljs.core.first(inst_74643);
var state_74667__$1 = (function (){var statearr_74730 = state_74667;
(statearr_74730[(12)] = inst_74653);

return statearr_74730;
})();
if(cljs.core.truth_(inst_74654)){
var statearr_74731_74777 = state_74667__$1;
(statearr_74731_74777[(1)] = (5));

} else {
var statearr_74732_74778 = state_74667__$1;
(statearr_74732_74778[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74668 === (5))){
var inst_74643 = (state_74667[(8)]);
var inst_74644 = (state_74667[(10)]);
var inst_74653 = (state_74667[(12)]);
var inst_74656 = cljs.core.first(inst_74643);
var inst_74657 = cljs.core.first(inst_74644);
var inst_74658 = cljs.core.rest(inst_74643);
var inst_74659 = cljs.core.rest(inst_74644);
var inst_74641 = inst_74656;
var inst_74642 = inst_74657;
var inst_74643__$1 = inst_74658;
var inst_74644__$1 = inst_74659;
var inst_74645 = inst_74653;
var state_74667__$1 = (function (){var statearr_74733 = state_74667;
(statearr_74733[(7)] = inst_74642);

(statearr_74733[(8)] = inst_74643__$1);

(statearr_74733[(9)] = inst_74645);

(statearr_74733[(10)] = inst_74644__$1);

(statearr_74733[(11)] = inst_74641);

return statearr_74733;
})();
var statearr_74734_74779 = state_74667__$1;
(statearr_74734_74779[(2)] = null);

(statearr_74734_74779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74668 === (6))){
var inst_74653 = (state_74667[(12)]);
var state_74667__$1 = state_74667;
var statearr_74735_74780 = state_74667__$1;
(statearr_74735_74780[(2)] = inst_74653);

(statearr_74735_74780[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74668 === (7))){
var inst_74663 = (state_74667[(2)]);
var state_74667__$1 = state_74667;
var statearr_74736_74781 = state_74667__$1;
(statearr_74736_74781[(2)] = inst_74663);

(statearr_74736_74781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74737 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74737[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74737[(1)] = (1));

return statearr_74737;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74667){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74667);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74738){var ex__2730__auto__ = e74738;
var statearr_74739_74782 = state_74667;
(statearr_74739_74782[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74667[(4)]))){
var statearr_74740_74783 = state_74667;
(statearr_74740_74783[(1)] = cljs.core.first((state_74667[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74784 = state_74667;
state_74667 = G__74784;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74667){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74741 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74741[(6)] = c__2749__auto____$1);

return statearr_74741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_74671 = cljs.core.async.impl.dispatch.run(inst_74670);
var state_74723__$1 = (function (){var statearr_74742 = state_74723;
(statearr_74742[(11)] = inst_74671);

return statearr_74742;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74723__$1,(2),inst_74669);
} else {
if((state_val_74724 === (4))){
var inst_74674 = (state_74723[(8)]);
var state_74723__$1 = state_74723;
var statearr_74743_74785 = state_74723__$1;
(statearr_74743_74785[(2)] = inst_74674);

(statearr_74743_74785[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (15))){
var state_74723__$1 = state_74723;
var statearr_74744_74786 = state_74723__$1;
(statearr_74744_74786[(2)] = (400));

(statearr_74744_74786[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (13))){
var state_74723__$1 = state_74723;
var statearr_74745_74787 = state_74723__$1;
(statearr_74745_74787[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (6))){
var inst_74680 = (state_74723[(10)]);
var inst_74688 = cljs.core.first(inst_74680);
var state_74723__$1 = state_74723;
var statearr_74747_74788 = state_74723__$1;
(statearr_74747_74788[(2)] = inst_74688);

(statearr_74747_74788[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (17))){
var inst_74701 = (state_74723[(2)]);
var state_74723__$1 = state_74723;
var statearr_74748_74789 = state_74723__$1;
(statearr_74748_74789[(2)] = inst_74701);

(statearr_74748_74789[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (3))){
var inst_74684 = (state_74723[(7)]);
var inst_74674 = (state_74723[(8)]);
var inst_74677 = (state_74723[(9)]);
var inst_74680 = (state_74723[(10)]);
var inst_74679 = cljs.core.vals(inst_74674);
var inst_74680__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_74679);
var inst_74681 = (function (){var responses = inst_74674;
var responses_STAR_ = inst_74677;
var statuses = inst_74680__$1;
return (function (p1__74628_SHARP_){
var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__74628_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
});
})();
var inst_74682 = cljs.core.vals(inst_74674);
var inst_74683 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_74681,inst_74682);
var inst_74684__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_74683);
var inst_74685 = (function (){var responses = inst_74674;
var responses_STAR_ = inst_74677;
var statuses = inst_74680__$1;
var fuel = inst_74684__$1;
return (function (p1__74629_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__74629_SHARP_);
});
})();
var inst_74686 = cljs.core.every_QMARK_(inst_74685,inst_74680__$1);
var state_74723__$1 = (function (){var statearr_74749 = state_74723;
(statearr_74749[(7)] = inst_74684__$1);

(statearr_74749[(10)] = inst_74680__$1);

return statearr_74749;
})();
if(inst_74686){
var statearr_74750_74790 = state_74723__$1;
(statearr_74750_74790[(1)] = (6));

} else {
var statearr_74751_74791 = state_74723__$1;
(statearr_74751_74791[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (12))){
var state_74723__$1 = state_74723;
var statearr_74752_74792 = state_74723__$1;
(statearr_74752_74792[(2)] = (500));

(statearr_74752_74792[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (2))){
var inst_74674 = (state_74723[(8)]);
var inst_74673 = (state_74723[(2)]);
var inst_74674__$1 = fluree.db.util.async.throw_err(inst_74673);
var inst_74675 = (function (){var responses = inst_74674__$1;
return (function (acc,index,response){
var resp = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_74676 = cljs.core.PersistentHashMap.EMPTY;
var inst_74677 = cljs.core.reduce_kv(inst_74675,inst_74676,inst_74674__$1);
var state_74723__$1 = (function (){var statearr_74753 = state_74723;
(statearr_74753[(8)] = inst_74674__$1);

(statearr_74753[(9)] = inst_74677);

return statearr_74753;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_74754_74793 = state_74723__$1;
(statearr_74754_74793[(1)] = (3));

} else {
var statearr_74755_74794 = state_74723__$1;
(statearr_74755_74794[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (19))){
var inst_74684 = (state_74723[(7)]);
var inst_74707 = (state_74723[(12)]);
var inst_74677 = (state_74723[(9)]);
var inst_74716 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_74677,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74707,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74684], 0));
var state_74723__$1 = state_74723;
var statearr_74756_74795 = state_74723__$1;
(statearr_74756_74795[(2)] = inst_74716);

(statearr_74756_74795[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (11))){
var inst_74705 = (state_74723[(2)]);
var state_74723__$1 = state_74723;
var statearr_74757_74796 = state_74723__$1;
(statearr_74757_74796[(2)] = inst_74705);

(statearr_74757_74796[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (9))){
var state_74723__$1 = state_74723;
var statearr_74758_74797 = state_74723__$1;
(statearr_74758_74797[(2)] = (207));

(statearr_74758_74797[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (5))){
var inst_74721 = (state_74723[(2)]);
var state_74723__$1 = state_74723;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74723__$1,inst_74721);
} else {
if((state_val_74724 === (14))){
var inst_74703 = (state_74723[(2)]);
var state_74723__$1 = state_74723;
var statearr_74759_74798 = state_74723__$1;
(statearr_74759_74798[(2)] = inst_74703);

(statearr_74759_74798[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (16))){
var state_74723__$1 = state_74723;
var statearr_74760_74799 = state_74723__$1;
(statearr_74760_74799[(2)] = null);

(statearr_74760_74799[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (10))){
var inst_74684 = (state_74723[(7)]);
var inst_74674 = (state_74723[(8)]);
var inst_74677 = (state_74723[(9)]);
var inst_74680 = (state_74723[(10)]);
var inst_74694 = (function (){var responses = inst_74674;
var responses_STAR_ = inst_74677;
var statuses = inst_74680;
var fuel = inst_74684;
return (function (p1__74631_SHARP_){
return ((499) < p1__74631_SHARP_);
});
})();
var inst_74695 = cljs.core.some(inst_74694,inst_74680);
var state_74723__$1 = state_74723;
if(cljs.core.truth_(inst_74695)){
var statearr_74761_74800 = state_74723__$1;
(statearr_74761_74800[(1)] = (12));

} else {
var statearr_74762_74801 = state_74723__$1;
(statearr_74762_74801[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (18))){
var inst_74684 = (state_74723[(7)]);
var inst_74707 = (state_74723[(12)]);
var inst_74677 = (state_74723[(9)]);
var inst_74712 = (state_74723[(13)]);
var inst_74714 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_74677,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74707,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74684,new cljs.core.Keyword(null,"block","block",664686210),inst_74712], 0));
var state_74723__$1 = state_74723;
var statearr_74763_74802 = state_74723__$1;
(statearr_74763_74802[(2)] = inst_74714);

(statearr_74763_74802[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74724 === (8))){
var inst_74684 = (state_74723[(7)]);
var inst_74674 = (state_74723[(8)]);
var inst_74707 = (state_74723[(12)]);
var inst_74677 = (state_74723[(9)]);
var inst_74680 = (state_74723[(10)]);
var inst_74712 = (state_74723[(13)]);
var inst_74707__$1 = (state_74723[(2)]);
var inst_74708 = (function (){var responses = inst_74674;
var responses_STAR_ = inst_74677;
var statuses = inst_74680;
var fuel = inst_74684;
var status = inst_74707__$1;
return (function (p1__74632_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__74632_SHARP_));
});
})();
var inst_74709 = cljs.core.vals(inst_74674);
var inst_74710 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_74708,inst_74709);
var inst_74711 = cljs.core.first(inst_74710);
var inst_74712__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_74711);
var state_74723__$1 = (function (){var statearr_74764 = state_74723;
(statearr_74764[(12)] = inst_74707__$1);

(statearr_74764[(13)] = inst_74712__$1);

return statearr_74764;
})();
if(cljs.core.truth_(inst_74712__$1)){
var statearr_74765_74803 = state_74723__$1;
(statearr_74765_74803[(1)] = (18));

} else {
var statearr_74766_74804 = state_74723__$1;
(statearr_74766_74804[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74767 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74767[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74767[(1)] = (1));

return statearr_74767;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74723){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74723);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74768){var ex__2730__auto__ = e74768;
var statearr_74769_74805 = state_74723;
(statearr_74769_74805[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74723[(4)]))){
var statearr_74770_74806 = state_74723;
(statearr_74770_74806[(1)] = cljs.core.first((state_74723[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74807 = state_74723;
state_74723 = G__74807;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74723){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74771 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74771[(6)] = c__2749__auto__);

return statearr_74771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__74809 = arguments.length;
switch (G__74809) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__74810 = opts;
var map__74810__$1 = cljs.core.__destructure_map(map__74810);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74810__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74810__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74810__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74810__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__74811 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74811,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74811,(1),null);
var action__$1 = (function (){var or__4253__auto__ = action;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e74814){var e = e74814;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__74817 = arguments.length;
switch (G__74817) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74851){
var state_val_74852 = (state_74851[(1)]);
if((state_val_74852 === (7))){
var state_74851__$1 = state_74851;
var statearr_74853_74874 = state_74851__$1;
(statearr_74853_74874[(2)] = opts);

(statearr_74853_74874[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74852 === (1))){
var state_74851__$1 = state_74851;
var statearr_74854_74875 = state_74851__$1;
(statearr_74854_74875[(2)] = null);

(statearr_74854_74875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74852 === (4))){
var inst_74818 = (state_74851[(2)]);
var inst_74819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74820 = [inst_74818];
var inst_74821 = (new cljs.core.PersistentVector(null,1,(5),inst_74819,inst_74820,null));
var inst_74822 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_74821);
var inst_74823 = cljs.core.ex_data(inst_74818);
var inst_74824 = cljs.core.ex_message(inst_74818);
var inst_74825 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74823,new cljs.core.Keyword(null,"message","message",-406056002),inst_74824);
var state_74851__$1 = (function (){var statearr_74855 = state_74851;
(statearr_74855[(7)] = inst_74822);

return statearr_74855;
})();
var statearr_74856_74876 = state_74851__$1;
(statearr_74856_74876[(2)] = inst_74825);

(statearr_74856_74876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74852 === (6))){
var inst_74835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74836 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_74837 = (new cljs.core.PersistentVector(null,1,(5),inst_74835,inst_74836,null));
var inst_74838 = cljs.core.assoc_in(opts,inst_74837,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_74851__$1 = state_74851;
var statearr_74857_74877 = state_74851__$1;
(statearr_74857_74877[(2)] = inst_74838);

(statearr_74857_74877[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74852 === (3))){
var inst_74849 = (state_74851[(2)]);
var state_74851__$1 = state_74851;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74851__$1,inst_74849);
} else {
if((state_val_74852 === (2))){
var _ = (function (){var statearr_74859 = state_74851;
(statearr_74859[(4)] = cljs.core.cons((5),(state_74851[(4)])));

return statearr_74859;
})();
var inst_74831 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_74832 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_74833 = (inst_74832 == null);
var state_74851__$1 = (function (){var statearr_74860 = state_74851;
(statearr_74860[(8)] = inst_74831);

return statearr_74860;
})();
if(cljs.core.truth_(inst_74833)){
var statearr_74861_74878 = state_74851__$1;
(statearr_74861_74878[(1)] = (6));

} else {
var statearr_74862_74879 = state_74851__$1;
(statearr_74862_74879[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74852 === (9))){
var inst_74845 = (state_74851[(2)]);
var inst_74846 = fluree.db.util.async.throw_err(inst_74845);
var _ = (function (){var statearr_74863 = state_74851;
(statearr_74863[(4)] = cljs.core.rest((state_74851[(4)])));

return statearr_74863;
})();
var state_74851__$1 = state_74851;
var statearr_74864_74880 = state_74851__$1;
(statearr_74864_74880[(2)] = inst_74846);

(statearr_74864_74880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74852 === (5))){
var _ = (function (){var statearr_74865 = state_74851;
(statearr_74865[(4)] = cljs.core.rest((state_74851[(4)])));

return statearr_74865;
})();
var state_74851__$1 = state_74851;
var ex74858 = (state_74851__$1[(2)]);
var statearr_74866_74881 = state_74851__$1;
(statearr_74866_74881[(5)] = ex74858);


var statearr_74867_74882 = state_74851__$1;
(statearr_74867_74882[(1)] = (4));

(statearr_74867_74882[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74852 === (8))){
var inst_74831 = (state_74851[(8)]);
var inst_74841 = (state_74851[(2)]);
var inst_74842 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_74831,inst_74841);
var inst_74843 = fluree.db.operations.command_async(conn,inst_74842);
var state_74851__$1 = state_74851;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74851__$1,(9),inst_74843);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74868 = [null,null,null,null,null,null,null,null,null];
(statearr_74868[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74868[(1)] = (1));

return statearr_74868;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74851){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74851);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74869){var ex__2730__auto__ = e74869;
var statearr_74870_74883 = state_74851;
(statearr_74870_74883[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74851[(4)]))){
var statearr_74871_74884 = state_74851;
(statearr_74871_74884[(1)] = cljs.core.first((state_74851[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74885 = state_74851;
state_74851 = G__74885;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74851){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74872 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74872[(6)] = c__2749__auto__);

return statearr_74872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

