// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__72374 = arguments.length;
switch (G__72374) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72419){
var state_val_72420 = (state_72419[(1)]);
if((state_val_72420 === (7))){
var inst_72389 = typeof user === 'string';
var state_72419__$1 = state_72419;
if(cljs.core.truth_(inst_72389)){
var statearr_72421_72450 = state_72419__$1;
(statearr_72421_72450[(1)] = (9));

} else {
var statearr_72422_72451 = state_72419__$1;
(statearr_72422_72451[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72420 === (1))){
var state_72419__$1 = state_72419;
var statearr_72423_72452 = state_72419__$1;
(statearr_72423_72452[(2)] = null);

(statearr_72423_72452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72420 === (4))){
var inst_72375 = (state_72419[(2)]);
var inst_72376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72377 = [inst_72375];
var inst_72378 = (new cljs.core.PersistentVector(null,1,(5),inst_72376,inst_72377,null));
var inst_72379 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72378);
var inst_72380 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_72375) : reject.call(null,inst_72375));
var state_72419__$1 = (function (){var statearr_72424 = state_72419;
(statearr_72424[(7)] = inst_72379);

return statearr_72424;
})();
var statearr_72425_72453 = state_72419__$1;
(statearr_72425_72453[(2)] = inst_72380);

(statearr_72425_72453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72420 === (15))){
var inst_72408 = (state_72419[(2)]);
var inst_72409 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_72408);
var inst_72410 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72411 = cljs.core.constantly(inst_72409);
var inst_72412 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72410,inst_72411);
var inst_72413 = fluree.db.connection.add_token(conn,inst_72409);
var inst_72414 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_72408) : resolve.call(null,inst_72408));
var _ = (function (){var statearr_72426 = state_72419;
(statearr_72426[(4)] = cljs.core.rest((state_72419[(4)])));

return statearr_72426;
})();
var state_72419__$1 = (function (){var statearr_72427 = state_72419;
(statearr_72427[(8)] = inst_72413);

(statearr_72427[(9)] = inst_72412);

return statearr_72427;
})();
var statearr_72428_72454 = state_72419__$1;
(statearr_72428_72454[(2)] = inst_72414);

(statearr_72428_72454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72420 === (13))){
var state_72419__$1 = state_72419;
var statearr_72429_72455 = state_72419__$1;
(statearr_72429_72455[(2)] = null);

(statearr_72429_72455[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72420 === (6))){
var state_72419__$1 = state_72419;
var statearr_72430_72456 = state_72419__$1;
(statearr_72430_72456[(2)] = user);

(statearr_72430_72456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72420 === (3))){
var inst_72417 = (state_72419[(2)]);
var state_72419__$1 = state_72419;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72419__$1,inst_72417);
} else {
if((state_val_72420 === (12))){
var state_72419__$1 = state_72419;
var statearr_72431_72457 = state_72419__$1;
(statearr_72431_72457[(2)] = user);

(statearr_72431_72457[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72420 === (2))){
var _ = (function (){var statearr_72432 = state_72419;
(statearr_72432[(4)] = cljs.core.cons((5),(state_72419[(4)])));

return statearr_72432;
})();
var inst_72386 = typeof user === 'number';
var state_72419__$1 = state_72419;
if(cljs.core.truth_(inst_72386)){
var statearr_72433_72458 = state_72419__$1;
(statearr_72433_72458[(1)] = (6));

} else {
var statearr_72434_72459 = state_72419__$1;
(statearr_72434_72459[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72420 === (11))){
var inst_72400 = (state_72419[(2)]);
var state_72419__$1 = state_72419;
var statearr_72436_72460 = state_72419__$1;
(statearr_72436_72460[(2)] = inst_72400);

(statearr_72436_72460[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72420 === (9))){
var inst_72391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72392 = ["_user/username",user];
var inst_72393 = (new cljs.core.PersistentVector(null,2,(5),inst_72391,inst_72392,null));
var state_72419__$1 = state_72419;
var statearr_72437_72461 = state_72419__$1;
(statearr_72437_72461[(2)] = inst_72393);

(statearr_72437_72461[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72420 === (5))){
var _ = (function (){var statearr_72438 = state_72419;
(statearr_72438[(4)] = cljs.core.rest((state_72419[(4)])));

return statearr_72438;
})();
var state_72419__$1 = state_72419;
var ex72435 = (state_72419__$1[(2)]);
var statearr_72439_72462 = state_72419__$1;
(statearr_72439_72462[(5)] = ex72435);


var statearr_72440_72463 = state_72419__$1;
(statearr_72440_72463[(1)] = (4));

(statearr_72440_72463[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72420 === (14))){
var inst_72398 = (state_72419[(2)]);
var state_72419__$1 = state_72419;
var statearr_72441_72464 = state_72419__$1;
(statearr_72441_72464[(2)] = inst_72398);

(statearr_72441_72464[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72420 === (10))){
var state_72419__$1 = state_72419;
var statearr_72442_72465 = state_72419__$1;
(statearr_72442_72465[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72420 === (8))){
var inst_72402 = (state_72419[(2)]);
var inst_72403 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_72404 = [account,inst_72402,password,expireSeconds,syncTo];
var inst_72405 = cljs.core.PersistentHashMap.fromArrays(inst_72403,inst_72404);
var inst_72406 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_72405);
var state_72419__$1 = state_72419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72419__$1,(15),inst_72406);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72444 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72444[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72444[(1)] = (1));

return statearr_72444;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72419){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72419);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72445){var ex__2730__auto__ = e72445;
var statearr_72446_72466 = state_72419;
(statearr_72446_72466[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72419[(4)]))){
var statearr_72447_72467 = state_72419;
(statearr_72447_72467[(1)] = cljs.core.first((state_72419[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72468 = state_72419;
state_72419 = G__72468;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72419){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72448 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72448[(6)] = c__2749__auto__);

return statearr_72448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__72470 = arguments.length;
switch (G__72470) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72479){
var state_val_72480 = (state_72479[(1)]);
if((state_val_72480 === (1))){
var inst_72471 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72473 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_72474 = (new cljs.core.PersistentVector(null,4,(5),inst_72472,inst_72473,null));
var inst_72475 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72471,inst_72474);
var inst_72476 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__72481 = cljs.core.seq(cljs.core.keys(x));
var chunk__72482 = null;
var count__72483 = (0);
var i__72484 = (0);
while(true){
if((i__72484 < count__72483)){
var k = chunk__72482.cljs$core$IIndexed$_nth$arity$2(null,i__72484);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__72492 = seq__72481;
var G__72493 = chunk__72482;
var G__72494 = count__72483;
var G__72495 = (i__72484 + (1));
seq__72481 = G__72492;
chunk__72482 = G__72493;
count__72483 = G__72494;
i__72484 = G__72495;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__72481);
if(temp__5804__auto__){
var seq__72481__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__72481__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__72481__$1);
var G__72496 = cljs.core.chunk_rest(seq__72481__$1);
var G__72497 = c__4679__auto__;
var G__72498 = cljs.core.count(c__4679__auto__);
var G__72499 = (0);
seq__72481 = G__72496;
chunk__72482 = G__72497;
count__72483 = G__72498;
i__72484 = G__72499;
continue;
} else {
var k = cljs.core.first(seq__72481__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__72500 = cljs.core.next(seq__72481__$1);
var G__72501 = null;
var G__72502 = (0);
var G__72503 = (0);
seq__72481 = G__72500;
chunk__72482 = G__72501;
count__72483 = G__72502;
i__72484 = G__72503;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_72477 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_72476);
var state_72479__$1 = (function (){var statearr_72485 = state_72479;
(statearr_72485[(7)] = inst_72475);

return statearr_72485;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_72479__$1,inst_72477);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72486 = [null,null,null,null,null,null,null,null];
(statearr_72486[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72486[(1)] = (1));

return statearr_72486;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72479){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72479);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72487){var ex__2730__auto__ = e72487;
var statearr_72488_72504 = state_72479;
(statearr_72488_72504[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72479[(4)]))){
var statearr_72489_72505 = state_72479;
(statearr_72489_72505[(1)] = cljs.core.first((state_72479[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72506 = state_72479;
state_72479 = G__72506;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72479){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72490 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72490[(6)] = c__2749__auto__);

return statearr_72490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__72508 = arguments.length;
switch (G__72508) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72545){
var state_val_72546 = (state_72545[(1)]);
if((state_val_72546 === (1))){
var state_72545__$1 = state_72545;
var statearr_72547_72568 = state_72545__$1;
(statearr_72547_72568[(2)] = null);

(statearr_72547_72568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72546 === (2))){
var _ = (function (){var statearr_72548 = state_72545;
(statearr_72548[(4)] = cljs.core.cons((5),(state_72545[(4)])));

return statearr_72548;
})();
var inst_72520 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_72521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72522 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_72523 = (new cljs.core.PersistentVector(null,1,(5),inst_72521,inst_72522,null));
var inst_72524 = cljs.core.PersistentHashMap.EMPTY;
var inst_72525 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_72524);
var inst_72526 = cljs.core.assoc_in(inst_72520,inst_72523,inst_72525);
var inst_72527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72528 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_72529 = (new cljs.core.PersistentVector(null,1,(5),inst_72527,inst_72528,null));
var inst_72530 = cljs.core.PersistentHashMap.EMPTY;
var inst_72531 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_72530);
var inst_72532 = cljs.core.assoc_in(inst_72526,inst_72529,inst_72531);
var inst_72533 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_72534 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_72532);
var inst_72535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72536 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_72533,null];
var inst_72537 = (new cljs.core.PersistentVector(null,4,(5),inst_72535,inst_72536,null));
var inst_72538 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72534,inst_72537);
var inst_72539 = (function (){var conn = inst_72532;
var pc = inst_72533;
return (function (x){
if((x == null)){
} else {
var seq__72549_72569 = cljs.core.seq(cljs.core.keys(x));
var chunk__72550_72570 = null;
var count__72551_72571 = (0);
var i__72552_72572 = (0);
while(true){
if((i__72552_72572 < count__72551_72571)){
var k_72573 = chunk__72550_72570.cljs$core$IIndexed$_nth$arity$2(null,i__72552_72572);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_72573], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_72573,null));


var G__72574 = seq__72549_72569;
var G__72575 = chunk__72550_72570;
var G__72576 = count__72551_72571;
var G__72577 = (i__72552_72572 + (1));
seq__72549_72569 = G__72574;
chunk__72550_72570 = G__72575;
count__72551_72571 = G__72576;
i__72552_72572 = G__72577;
continue;
} else {
var temp__5804__auto___72578 = cljs.core.seq(seq__72549_72569);
if(temp__5804__auto___72578){
var seq__72549_72579__$1 = temp__5804__auto___72578;
if(cljs.core.chunked_seq_QMARK_(seq__72549_72579__$1)){
var c__4679__auto___72580 = cljs.core.chunk_first(seq__72549_72579__$1);
var G__72581 = cljs.core.chunk_rest(seq__72549_72579__$1);
var G__72582 = c__4679__auto___72580;
var G__72583 = cljs.core.count(c__4679__auto___72580);
var G__72584 = (0);
seq__72549_72569 = G__72581;
chunk__72550_72570 = G__72582;
count__72551_72571 = G__72583;
i__72552_72572 = G__72584;
continue;
} else {
var k_72585 = cljs.core.first(seq__72549_72579__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_72585], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_72585,null));


var G__72586 = cljs.core.next(seq__72549_72579__$1);
var G__72587 = null;
var G__72588 = (0);
var G__72589 = (0);
seq__72549_72569 = G__72586;
chunk__72550_72570 = G__72587;
count__72551_72571 = G__72588;
i__72552_72572 = G__72589;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_72540 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72533,inst_72539);
var ___$1 = (function (){var statearr_72553 = state_72545;
(statearr_72553[(4)] = cljs.core.rest((state_72545[(4)])));

return statearr_72553;
})();
var state_72545__$1 = (function (){var statearr_72554 = state_72545;
(statearr_72554[(7)] = inst_72538);

return statearr_72554;
})();
var statearr_72555_72590 = state_72545__$1;
(statearr_72555_72590[(2)] = inst_72540);

(statearr_72555_72590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72546 === (3))){
var inst_72543 = (state_72545[(2)]);
var state_72545__$1 = state_72545;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72545__$1,inst_72543);
} else {
if((state_val_72546 === (4))){
var inst_72509 = (state_72545[(2)]);
var inst_72510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72511 = [inst_72509];
var inst_72512 = (new cljs.core.PersistentVector(null,1,(5),inst_72510,inst_72511,null));
var inst_72513 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72512);
var inst_72514 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_72509) : reject.call(null,inst_72509));
var state_72545__$1 = (function (){var statearr_72557 = state_72545;
(statearr_72557[(8)] = inst_72513);

return statearr_72557;
})();
var statearr_72558_72591 = state_72545__$1;
(statearr_72558_72591[(2)] = inst_72514);

(statearr_72558_72591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72546 === (5))){
var _ = (function (){var statearr_72559 = state_72545;
(statearr_72559[(4)] = cljs.core.rest((state_72545[(4)])));

return statearr_72559;
})();
var state_72545__$1 = state_72545;
var ex72556 = (state_72545__$1[(2)]);
var statearr_72560_72592 = state_72545__$1;
(statearr_72560_72592[(5)] = ex72556);


var statearr_72561_72593 = state_72545__$1;
(statearr_72561_72593[(1)] = (4));

(statearr_72561_72593[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72562 = [null,null,null,null,null,null,null,null,null];
(statearr_72562[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72562[(1)] = (1));

return statearr_72562;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72545){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72545);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72563){var ex__2730__auto__ = e72563;
var statearr_72564_72594 = state_72545;
(statearr_72564_72594[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72545[(4)]))){
var statearr_72565_72595 = state_72545;
(statearr_72565_72595[(1)] = cljs.core.first((state_72545[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72596 = state_72545;
state_72545 = G__72596;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72545){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72566 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72566[(6)] = c__2749__auto__);

return statearr_72566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__72598 = arguments.length;
switch (G__72598) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__72600 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72600,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72600,(1),null);
var cb_STAR_ = (function (header,data){
var G__72603 = cljs.core.clj__GT_js(header);
var G__72604 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__72603,G__72604) : callback.call(null,G__72603,G__72604));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__72605 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72605,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72605,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72658){
var state_val_72659 = (state_72658[(1)]);
if((state_val_72659 === (7))){
var inst_72619 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72620 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72621 = cljs.core.PersistentHashMap.fromArrays(inst_72619,inst_72620);
var inst_72622 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_72621);
var inst_72623 = (function(){throw inst_72622})();
var state_72658__$1 = state_72658;
var statearr_72660_72692 = state_72658__$1;
(statearr_72660_72692[(2)] = inst_72623);

(statearr_72660_72692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72659 === (1))){
var state_72658__$1 = state_72658;
var statearr_72661_72693 = state_72658__$1;
(statearr_72661_72693[(2)] = null);

(statearr_72661_72693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72659 === (4))){
var inst_72608 = (state_72658[(2)]);
var inst_72609 = cljs.core.clj__GT_js(inst_72608);
var inst_72610 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_72609) : reject.call(null,inst_72609));
var state_72658__$1 = state_72658;
var statearr_72662_72694 = state_72658__$1;
(statearr_72662_72694[(2)] = inst_72610);

(statearr_72662_72694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72659 === (13))){
var inst_72637 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72638 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72639 = cljs.core.PersistentHashMap.fromArrays(inst_72637,inst_72638);
var inst_72640 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_72639);
var inst_72641 = (function(){throw inst_72640})();
var state_72658__$1 = state_72658;
var statearr_72663_72695 = state_72658__$1;
(statearr_72663_72695[(2)] = inst_72641);

(statearr_72663_72695[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72659 === (6))){
var state_72658__$1 = state_72658;
var statearr_72664_72696 = state_72658__$1;
(statearr_72664_72696[(2)] = null);

(statearr_72664_72696[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72659 === (3))){
var inst_72656 = (state_72658[(2)]);
var state_72658__$1 = state_72658;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72658__$1,inst_72656);
} else {
if((state_val_72659 === (12))){
var state_72658__$1 = state_72658;
var statearr_72665_72697 = state_72658__$1;
(statearr_72665_72697[(2)] = null);

(statearr_72665_72697[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72659 === (2))){
var _ = (function (){var statearr_72666 = state_72658;
(statearr_72666[(4)] = cljs.core.cons((5),(state_72658[(4)])));

return statearr_72666;
})();
var inst_72616 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_72658__$1 = state_72658;
if(cljs.core.truth_(inst_72616)){
var statearr_72667_72698 = state_72658__$1;
(statearr_72667_72698[(1)] = (6));

} else {
var statearr_72668_72699 = state_72658__$1;
(statearr_72668_72699[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72659 === (11))){
var inst_72634 = (state_72658[(2)]);
var state_72658__$1 = (function (){var statearr_72670 = state_72658;
(statearr_72670[(7)] = inst_72634);

return statearr_72670;
})();
if(cljs.core.truth_(password)){
var statearr_72671_72700 = state_72658__$1;
(statearr_72671_72700[(1)] = (12));

} else {
var statearr_72672_72701 = state_72658__$1;
(statearr_72672_72701[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72659 === (9))){
var state_72658__$1 = state_72658;
var statearr_72673_72702 = state_72658__$1;
(statearr_72673_72702[(2)] = null);

(statearr_72673_72702[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72659 === (5))){
var _ = (function (){var statearr_72674 = state_72658;
(statearr_72674[(4)] = cljs.core.rest((state_72658[(4)])));

return statearr_72674;
})();
var state_72658__$1 = state_72658;
var ex72669 = (state_72658__$1[(2)]);
var statearr_72675_72703 = state_72658__$1;
(statearr_72675_72703[(5)] = ex72669);


var statearr_72676_72704 = state_72658__$1;
(statearr_72676_72704[(1)] = (4));

(statearr_72676_72704[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72659 === (14))){
var inst_72643 = (state_72658[(2)]);
var inst_72644 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_72645 = fluree.db.util.core.without_nils(inst_72644);
var inst_72646 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_72647 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72649 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_72645,inst_72646,null];
var inst_72650 = (new cljs.core.PersistentVector(null,4,(5),inst_72648,inst_72649,null));
var inst_72651 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72647,inst_72650);
var inst_72652 = (function (){var _ = inst_72643;
var data = inst_72645;
var pc = inst_72646;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__72677 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__72677) : reject.call(null,G__72677));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__72678 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__72678) : reject.call(null,G__72678));
} else {
var G__72679 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__72679) : resolve.call(null,G__72679));

}
}
});
})();
var inst_72653 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72646,inst_72652);
var _ = (function (){var statearr_72680 = state_72658;
(statearr_72680[(4)] = cljs.core.rest((state_72658[(4)])));

return statearr_72680;
})();
var state_72658__$1 = (function (){var statearr_72681 = state_72658;
(statearr_72681[(8)] = inst_72651);

return statearr_72681;
})();
var statearr_72682_72705 = state_72658__$1;
(statearr_72682_72705[(2)] = inst_72653);

(statearr_72682_72705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72659 === (10))){
var inst_72628 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72629 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72630 = cljs.core.PersistentHashMap.fromArrays(inst_72628,inst_72629);
var inst_72631 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_72630);
var inst_72632 = (function(){throw inst_72631})();
var state_72658__$1 = state_72658;
var statearr_72683_72706 = state_72658__$1;
(statearr_72683_72706[(2)] = inst_72632);

(statearr_72683_72706[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72659 === (8))){
var inst_72625 = (state_72658[(2)]);
var state_72658__$1 = (function (){var statearr_72684 = state_72658;
(statearr_72684[(9)] = inst_72625);

return statearr_72684;
})();
if(cljs.core.truth_(ledger)){
var statearr_72685_72707 = state_72658__$1;
(statearr_72685_72707[(1)] = (9));

} else {
var statearr_72686_72708 = state_72658__$1;
(statearr_72686_72708[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0 = (function (){
var statearr_72687 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72687[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2727__auto__);

(statearr_72687[(1)] = (1));

return statearr_72687;
});
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1 = (function (state_72658){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72658);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72688){var ex__2730__auto__ = e72688;
var statearr_72689_72709 = state_72658;
(statearr_72689_72709[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72658[(4)]))){
var statearr_72690_72710 = state_72658;
(statearr_72690_72710[(1)] = cljs.core.first((state_72658[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72711 = state_72658;
state_72658 = G__72711;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = function(state_72658){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1.call(this,state_72658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72691 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72691[(6)] = c__2749__auto__);

return statearr_72691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__72713 = arguments.length;
switch (G__72713) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72780){
var state_val_72781 = (state_72780[(1)]);
if((state_val_72781 === (7))){
var inst_72725 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72726 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72727 = cljs.core.PersistentHashMap.fromArrays(inst_72725,inst_72726);
var inst_72728 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_72727);
var inst_72729 = (function(){throw inst_72728})();
var state_72780__$1 = state_72780;
var statearr_72782_72824 = state_72780__$1;
(statearr_72782_72824[(2)] = inst_72729);

(statearr_72782_72824[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (20))){
var inst_72763 = (state_72780[(2)]);
var inst_72764 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_72765 = [ledger,password,user,auth,expire];
var inst_72766 = cljs.core.PersistentHashMap.fromArrays(inst_72764,inst_72765);
var inst_72767 = fluree.db.util.core.without_nils(inst_72766);
var inst_72768 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_72769 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72771 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_72767,inst_72768,null];
var inst_72772 = (new cljs.core.PersistentVector(null,4,(5),inst_72770,inst_72771,null));
var inst_72773 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72769,inst_72772);
var inst_72774 = (function (){var _ = inst_72763;
var data = inst_72767;
var pc = inst_72768;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__72783 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__72783) : reject.call(null,G__72783));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__72784 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__72784) : reject.call(null,G__72784));
} else {
fluree.db.connection.add_token(conn,result);

var G__72785 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__72785) : resolve.call(null,G__72785));

}
}
});
})();
var inst_72775 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72768,inst_72774);
var _ = (function (){var statearr_72786 = state_72780;
(statearr_72786[(4)] = cljs.core.rest((state_72780[(4)])));

return statearr_72786;
})();
var state_72780__$1 = (function (){var statearr_72787 = state_72780;
(statearr_72787[(7)] = inst_72773);

return statearr_72787;
})();
var statearr_72788_72825 = state_72780__$1;
(statearr_72788_72825[(2)] = inst_72775);

(statearr_72788_72825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (1))){
var state_72780__$1 = state_72780;
var statearr_72789_72826 = state_72780__$1;
(statearr_72789_72826[(2)] = null);

(statearr_72789_72826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (4))){
var inst_72714 = (state_72780[(2)]);
var inst_72715 = cljs.core.clj__GT_js(inst_72714);
var inst_72716 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_72715) : reject.call(null,inst_72715));
var state_72780__$1 = state_72780;
var statearr_72790_72827 = state_72780__$1;
(statearr_72790_72827[(2)] = inst_72716);

(statearr_72790_72827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (15))){
var inst_72750 = (state_72780[(8)]);
var state_72780__$1 = state_72780;
var statearr_72791_72828 = state_72780__$1;
(statearr_72791_72828[(2)] = inst_72750);

(statearr_72791_72828[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (13))){
var inst_72743 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72744 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72745 = cljs.core.PersistentHashMap.fromArrays(inst_72743,inst_72744);
var inst_72746 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_72745);
var inst_72747 = (function(){throw inst_72746})();
var state_72780__$1 = state_72780;
var statearr_72792_72829 = state_72780__$1;
(statearr_72792_72829[(2)] = inst_72747);

(statearr_72792_72829[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (6))){
var state_72780__$1 = state_72780;
var statearr_72793_72830 = state_72780__$1;
(statearr_72793_72830[(2)] = null);

(statearr_72793_72830[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (17))){
var inst_72754 = (state_72780[(2)]);
var state_72780__$1 = state_72780;
if(cljs.core.truth_(inst_72754)){
var statearr_72794_72831 = state_72780__$1;
(statearr_72794_72831[(1)] = (18));

} else {
var statearr_72795_72832 = state_72780__$1;
(statearr_72795_72832[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (3))){
var inst_72778 = (state_72780[(2)]);
var state_72780__$1 = state_72780;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72780__$1,inst_72778);
} else {
if((state_val_72781 === (12))){
var state_72780__$1 = state_72780;
var statearr_72796_72833 = state_72780__$1;
(statearr_72796_72833[(2)] = null);

(statearr_72796_72833[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (2))){
var _ = (function (){var statearr_72797 = state_72780;
(statearr_72797[(4)] = cljs.core.cons((5),(state_72780[(4)])));

return statearr_72797;
})();
var inst_72722 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_72780__$1 = state_72780;
if(cljs.core.truth_(inst_72722)){
var statearr_72798_72834 = state_72780__$1;
(statearr_72798_72834[(1)] = (6));

} else {
var statearr_72799_72835 = state_72780__$1;
(statearr_72799_72835[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (19))){
var inst_72757 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72758 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72759 = cljs.core.PersistentHashMap.fromArrays(inst_72757,inst_72758);
var inst_72760 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_72759);
var inst_72761 = (function(){throw inst_72760})();
var state_72780__$1 = state_72780;
var statearr_72800_72836 = state_72780__$1;
(statearr_72800_72836[(2)] = inst_72761);

(statearr_72800_72836[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (11))){
var inst_72740 = (state_72780[(2)]);
var state_72780__$1 = (function (){var statearr_72802 = state_72780;
(statearr_72802[(9)] = inst_72740);

return statearr_72802;
})();
if(cljs.core.truth_(password)){
var statearr_72803_72837 = state_72780__$1;
(statearr_72803_72837[(1)] = (12));

} else {
var statearr_72804_72838 = state_72780__$1;
(statearr_72804_72838[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (9))){
var state_72780__$1 = state_72780;
var statearr_72805_72839 = state_72780__$1;
(statearr_72805_72839[(2)] = null);

(statearr_72805_72839[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (5))){
var _ = (function (){var statearr_72806 = state_72780;
(statearr_72806[(4)] = cljs.core.rest((state_72780[(4)])));

return statearr_72806;
})();
var state_72780__$1 = state_72780;
var ex72801 = (state_72780__$1[(2)]);
var statearr_72807_72840 = state_72780__$1;
(statearr_72807_72840[(5)] = ex72801);


var statearr_72808_72841 = state_72780__$1;
(statearr_72808_72841[(1)] = (4));

(statearr_72808_72841[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (14))){
var inst_72750 = (state_72780[(8)]);
var inst_72749 = (state_72780[(2)]);
var inst_72750__$1 = user;
var state_72780__$1 = (function (){var statearr_72809 = state_72780;
(statearr_72809[(10)] = inst_72749);

(statearr_72809[(8)] = inst_72750__$1);

return statearr_72809;
})();
if(cljs.core.truth_(inst_72750__$1)){
var statearr_72810_72842 = state_72780__$1;
(statearr_72810_72842[(1)] = (15));

} else {
var statearr_72811_72843 = state_72780__$1;
(statearr_72811_72843[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (16))){
var state_72780__$1 = state_72780;
var statearr_72812_72844 = state_72780__$1;
(statearr_72812_72844[(2)] = auth);

(statearr_72812_72844[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (10))){
var inst_72734 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72735 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72736 = cljs.core.PersistentHashMap.fromArrays(inst_72734,inst_72735);
var inst_72737 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_72736);
var inst_72738 = (function(){throw inst_72737})();
var state_72780__$1 = state_72780;
var statearr_72813_72845 = state_72780__$1;
(statearr_72813_72845[(2)] = inst_72738);

(statearr_72813_72845[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (18))){
var state_72780__$1 = state_72780;
var statearr_72814_72846 = state_72780__$1;
(statearr_72814_72846[(2)] = null);

(statearr_72814_72846[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (8))){
var inst_72731 = (state_72780[(2)]);
var state_72780__$1 = (function (){var statearr_72815 = state_72780;
(statearr_72815[(11)] = inst_72731);

return statearr_72815;
})();
if(cljs.core.truth_(ledger)){
var statearr_72816_72847 = state_72780__$1;
(statearr_72816_72847[(1)] = (9));

} else {
var statearr_72817_72848 = state_72780__$1;
(statearr_72817_72848[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72818 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72818[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72818[(1)] = (1));

return statearr_72818;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72780){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72780);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72819){var ex__2730__auto__ = e72819;
var statearr_72820_72849 = state_72780;
(statearr_72820_72849[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72780[(4)]))){
var statearr_72821_72850 = state_72780;
(statearr_72821_72850[(1)] = cljs.core.first((state_72780[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72851 = state_72780;
state_72780 = G__72851;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72780){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72822 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72822[(6)] = c__2749__auto__);

return statearr_72822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__72853 = arguments.length;
switch (G__72853) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72888){
var state_val_72889 = (state_72888[(1)]);
if((state_val_72889 === (1))){
var state_72888__$1 = state_72888;
var statearr_72890_72912 = state_72888__$1;
(statearr_72890_72912[(2)] = null);

(statearr_72890_72912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72889 === (2))){
var _ = (function (){var statearr_72891 = state_72888;
(statearr_72891[(4)] = cljs.core.cons((5),(state_72888[(4)])));

return statearr_72891;
})();
var inst_72862 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_72888__$1 = state_72888;
if(cljs.core.truth_(inst_72862)){
var statearr_72892_72913 = state_72888__$1;
(statearr_72892_72913[(1)] = (6));

} else {
var statearr_72893_72914 = state_72888__$1;
(statearr_72893_72914[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72889 === (3))){
var inst_72886 = (state_72888[(2)]);
var state_72888__$1 = state_72888;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72888__$1,inst_72886);
} else {
if((state_val_72889 === (4))){
var inst_72854 = (state_72888[(2)]);
var inst_72855 = cljs.core.clj__GT_js(inst_72854);
var inst_72856 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_72855) : reject.call(null,inst_72855));
var state_72888__$1 = state_72888;
var statearr_72895_72915 = state_72888__$1;
(statearr_72895_72915[(2)] = inst_72856);

(statearr_72895_72915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72889 === (5))){
var _ = (function (){var statearr_72896 = state_72888;
(statearr_72896[(4)] = cljs.core.rest((state_72888[(4)])));

return statearr_72896;
})();
var state_72888__$1 = state_72888;
var ex72894 = (state_72888__$1[(2)]);
var statearr_72897_72916 = state_72888__$1;
(statearr_72897_72916[(5)] = ex72894);


var statearr_72898_72917 = state_72888__$1;
(statearr_72898_72917[(1)] = (4));

(statearr_72898_72917[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72889 === (6))){
var state_72888__$1 = state_72888;
var statearr_72899_72918 = state_72888__$1;
(statearr_72899_72918[(2)] = null);

(statearr_72899_72918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72889 === (7))){
var inst_72865 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72866 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72867 = cljs.core.PersistentHashMap.fromArrays(inst_72865,inst_72866);
var inst_72868 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_72867);
var inst_72869 = (function(){throw inst_72868})();
var state_72888__$1 = state_72888;
var statearr_72900_72919 = state_72888__$1;
(statearr_72900_72919[(2)] = inst_72869);

(statearr_72900_72919[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72889 === (8))){
var inst_72871 = (state_72888[(2)]);
var inst_72872 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_72873 = [jwt,expire];
var inst_72874 = cljs.core.PersistentHashMap.fromArrays(inst_72872,inst_72873);
var inst_72875 = fluree.db.util.core.without_nils(inst_72874);
var inst_72876 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_72877 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72879 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_72875,inst_72876,null];
var inst_72880 = (new cljs.core.PersistentVector(null,4,(5),inst_72878,inst_72879,null));
var inst_72881 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72877,inst_72880);
var inst_72882 = (function (){var _ = inst_72871;
var data = inst_72875;
var pc = inst_72876;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__72901 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__72901) : reject.call(null,G__72901));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__72902 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__72902) : resolve.call(null,G__72902));

}
});
})();
var inst_72883 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72876,inst_72882);
var _ = (function (){var statearr_72903 = state_72888;
(statearr_72903[(4)] = cljs.core.rest((state_72888[(4)])));

return statearr_72903;
})();
var state_72888__$1 = (function (){var statearr_72904 = state_72888;
(statearr_72904[(7)] = inst_72881);

return statearr_72904;
})();
var statearr_72905_72920 = state_72888__$1;
(statearr_72905_72920[(2)] = inst_72883);

(statearr_72905_72920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72906 = [null,null,null,null,null,null,null,null];
(statearr_72906[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72906[(1)] = (1));

return statearr_72906;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72888){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72888);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72907){var ex__2730__auto__ = e72907;
var statearr_72908_72921 = state_72888;
(statearr_72908_72921[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72888[(4)]))){
var statearr_72909_72922 = state_72888;
(statearr_72909_72922[(1)] = cljs.core.first((state_72888[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72923 = state_72888;
state_72888 = G__72923;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72888){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72888);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72910 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72910[(6)] = c__2749__auto__);

return statearr_72910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

