// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4913__auto___53197 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53248){
var state_val_53249 = (state_53248[(1)]);
if((state_val_53249 === (7))){
var inst_53243 = (state_53248[(2)]);
var _ = (function (){var statearr_53250 = state_53248;
(statearr_53250[(4)] = cljs.core.rest((state_53248[(4)])));

return statearr_53250;
})();
var state_53248__$1 = state_53248;
var statearr_53251_53278 = state_53248__$1;
(statearr_53251_53278[(2)] = inst_53243);

(statearr_53251_53278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53249 === (1))){
var state_53248__$1 = state_53248;
var statearr_53252_53279 = state_53248__$1;
(statearr_53252_53279[(2)] = null);

(statearr_53252_53279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53249 === (4))){
var inst_53198 = (state_53248[(2)]);
var state_53248__$1 = state_53248;
var statearr_53253_53280 = state_53248__$1;
(statearr_53253_53280[(2)] = inst_53198);

(statearr_53253_53280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53249 === (13))){
var inst_53239 = (state_53248[(2)]);
var state_53248__$1 = state_53248;
var statearr_53254_53281 = state_53248__$1;
(statearr_53254_53281[(2)] = inst_53239);

(statearr_53254_53281[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53249 === (6))){
var inst_53216 = (state_53248[(7)]);
var inst_53223 = (state_53248[(8)]);
var inst_53222 = cljs.core.seq(inst_53216);
var inst_53223__$1 = cljs.core.first(inst_53222);
var inst_53224 = cljs.core.next(inst_53222);
var inst_53225 = cljs.core.not(inst_53223__$1);
var state_53248__$1 = (function (){var statearr_53255 = state_53248;
(statearr_53255[(8)] = inst_53223__$1);

(statearr_53255[(9)] = inst_53224);

return statearr_53255;
})();
if(inst_53225){
var statearr_53256_53282 = state_53248__$1;
(statearr_53256_53282[(1)] = (8));

} else {
var statearr_53257_53283 = state_53248__$1;
(statearr_53257_53283[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53249 === (3))){
var inst_53246 = (state_53248[(2)]);
var state_53248__$1 = state_53248;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53248__$1,inst_53246);
} else {
if((state_val_53249 === (12))){
var inst_53217 = (state_53248[(10)]);
var inst_53223 = (state_53248[(8)]);
var inst_53224 = (state_53248[(9)]);
var inst_53236 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_53217,inst_53223);
var inst_53216 = inst_53224;
var inst_53217__$1 = inst_53236;
var state_53248__$1 = (function (){var statearr_53258 = state_53248;
(statearr_53258[(7)] = inst_53216);

(statearr_53258[(10)] = inst_53217__$1);

return statearr_53258;
})();
var statearr_53259_53284 = state_53248__$1;
(statearr_53259_53284[(2)] = null);

(statearr_53259_53284[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53249 === (2))){
var _ = (function (){var statearr_53260 = state_53248;
(statearr_53260[(4)] = cljs.core.cons((5),(state_53248[(4)])));

return statearr_53260;
})();
var inst_53211 = args;
var inst_53212 = cljs.core.seq(inst_53211);
var inst_53213 = cljs.core.first(inst_53212);
var inst_53214 = cljs.core.next(inst_53212);
var inst_53215 = cljs.core.PersistentVector.EMPTY;
var inst_53216 = inst_53211;
var inst_53217 = inst_53215;
var state_53248__$1 = (function (){var statearr_53261 = state_53248;
(statearr_53261[(7)] = inst_53216);

(statearr_53261[(10)] = inst_53217);

(statearr_53261[(11)] = inst_53214);

(statearr_53261[(12)] = inst_53213);

return statearr_53261;
})();
var statearr_53262_53285 = state_53248__$1;
(statearr_53262_53285[(2)] = null);

(statearr_53262_53285[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53249 === (11))){
var inst_53223 = (state_53248[(8)]);
var state_53248__$1 = state_53248;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53248__$1,(14),inst_53223);
} else {
if((state_val_53249 === (9))){
var inst_53223 = (state_53248[(8)]);
var inst_53228 = fluree.db.util.async.channel_QMARK_(inst_53223);
var state_53248__$1 = state_53248;
if(inst_53228){
var statearr_53264_53286 = state_53248__$1;
(statearr_53264_53286[(1)] = (11));

} else {
var statearr_53265_53287 = state_53248__$1;
(statearr_53265_53287[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53249 === (5))){
var _ = (function (){var statearr_53266 = state_53248;
(statearr_53266[(4)] = cljs.core.rest((state_53248[(4)])));

return statearr_53266;
})();
var state_53248__$1 = state_53248;
var ex53263 = (state_53248__$1[(2)]);
var statearr_53267_53288 = state_53248__$1;
(statearr_53267_53288[(5)] = ex53263);


if((ex53263 instanceof Error)){
var statearr_53268_53289 = state_53248__$1;
(statearr_53268_53289[(1)] = (4));

(statearr_53268_53289[(5)] = null);

} else {
throw ex53263;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53249 === (14))){
var inst_53217 = (state_53248[(10)]);
var inst_53224 = (state_53248[(9)]);
var inst_53231 = (state_53248[(2)]);
var inst_53232 = fluree.db.util.async.throw_err(inst_53231);
var inst_53233 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_53217,inst_53232);
var inst_53216 = inst_53224;
var inst_53217__$1 = inst_53233;
var state_53248__$1 = (function (){var statearr_53269 = state_53248;
(statearr_53269[(7)] = inst_53216);

(statearr_53269[(10)] = inst_53217__$1);

return statearr_53269;
})();
var statearr_53270_53290 = state_53248__$1;
(statearr_53270_53290[(2)] = null);

(statearr_53270_53290[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53249 === (10))){
var inst_53241 = (state_53248[(2)]);
var state_53248__$1 = state_53248;
var statearr_53271_53291 = state_53248__$1;
(statearr_53271_53291[(2)] = inst_53241);

(statearr_53271_53291[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53249 === (8))){
var inst_53217 = (state_53248[(10)]);
var state_53248__$1 = state_53248;
var statearr_53272_53292 = state_53248__$1;
(statearr_53272_53292[(2)] = inst_53217);

(statearr_53272_53292[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0 = (function (){
var statearr_53273 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53273[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__);

(statearr_53273[(1)] = (1));

return statearr_53273;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1 = (function (state_53248){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53248);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53274){var ex__2730__auto__ = e53274;
var statearr_53275_53293 = state_53248;
(statearr_53275_53293[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53248[(4)]))){
var statearr_53276_53294 = state_53248;
(statearr_53276_53294[(1)] = cljs.core.first((state_53248[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53295 = state_53248;
state_53248 = G__53295;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = function(state_53248){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1.call(this,state_53248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53277 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53277[(6)] = c__2749__auto__);

return statearr_53277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__53297 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53297,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53297,(1),null);
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__53296_SHARP_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(p1__53296_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53345){
var state_val_53346 = (state_53345[(1)]);
if((state_val_53346 === (7))){
var state_53345__$1 = state_53345;
var statearr_53347_53376 = state_53345__$1;
(statearr_53347_53376[(2)] = coll);

(statearr_53347_53376[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (1))){
var state_53345__$1 = state_53345;
var statearr_53348_53377 = state_53345__$1;
(statearr_53348_53377[(2)] = null);

(statearr_53348_53377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (4))){
var inst_53300 = (state_53345[(2)]);
var state_53345__$1 = state_53345;
var statearr_53349_53378 = state_53345__$1;
(statearr_53349_53378[(2)] = inst_53300);

(statearr_53349_53378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (15))){
var inst_53319 = (state_53345[(7)]);
var inst_53327 = (state_53345[(2)]);
var inst_53328 = fluree.db.dbfunctions.internal.nth(inst_53319,inst_53327);
var inst_53329 = cljs.core.count(inst_53319);
var inst_53330 = ((9) + inst_53329);
var inst_53331 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53332 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53334 = [inst_53319,inst_53327];
var inst_53335 = (new cljs.core.PersistentVector(null,2,(5),inst_53333,inst_53334,null));
var inst_53336 = ["nth",inst_53335,inst_53328];
var inst_53337 = cljs.core.PersistentHashMap.fromArrays(inst_53332,inst_53336);
var inst_53338 = [inst_53337,inst_53330];
var inst_53339 = (new cljs.core.PersistentVector(null,2,(5),inst_53331,inst_53338,null));
var inst_53340 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53339);
var _ = (function (){var statearr_53350 = state_53345;
(statearr_53350[(4)] = cljs.core.rest((state_53345[(4)])));

return statearr_53350;
})();
var state_53345__$1 = (function (){var statearr_53351 = state_53345;
(statearr_53351[(8)] = inst_53340);

return statearr_53351;
})();
var statearr_53352_53379 = state_53345__$1;
(statearr_53352_53379[(2)] = inst_53328);

(statearr_53352_53379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (13))){
var state_53345__$1 = state_53345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53345__$1,(16),key);
} else {
if((state_val_53346 === (6))){
var state_53345__$1 = state_53345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53345__$1,(9),coll);
} else {
if((state_val_53346 === (3))){
var inst_53343 = (state_53345[(2)]);
var state_53345__$1 = state_53345;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53345__$1,inst_53343);
} else {
if((state_val_53346 === (12))){
var inst_53319 = (state_53345[(2)]);
var inst_53320 = fluree.db.util.async.channel_QMARK_(key);
var state_53345__$1 = (function (){var statearr_53353 = state_53345;
(statearr_53353[(7)] = inst_53319);

return statearr_53353;
})();
if(inst_53320){
var statearr_53354_53380 = state_53345__$1;
(statearr_53354_53380[(1)] = (13));

} else {
var statearr_53355_53381 = state_53345__$1;
(statearr_53355_53381[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (2))){
var _ = (function (){var statearr_53356 = state_53345;
(statearr_53356[(4)] = cljs.core.cons((5),(state_53345[(4)])));

return statearr_53356;
})();
var inst_53306 = fluree.db.util.async.channel_QMARK_(coll);
var state_53345__$1 = state_53345;
if(inst_53306){
var statearr_53357_53382 = state_53345__$1;
(statearr_53357_53382[(1)] = (6));

} else {
var statearr_53358_53383 = state_53345__$1;
(statearr_53358_53383[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (11))){
var inst_53313 = (state_53345[(9)]);
var state_53345__$1 = state_53345;
var statearr_53360_53384 = state_53345__$1;
(statearr_53360_53384[(2)] = inst_53313);

(statearr_53360_53384[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (9))){
var inst_53309 = (state_53345[(2)]);
var inst_53310 = fluree.db.util.async.throw_err(inst_53309);
var state_53345__$1 = state_53345;
var statearr_53361_53385 = state_53345__$1;
(statearr_53361_53385[(2)] = inst_53310);

(statearr_53361_53385[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (5))){
var _ = (function (){var statearr_53362 = state_53345;
(statearr_53362[(4)] = cljs.core.rest((state_53345[(4)])));

return statearr_53362;
})();
var state_53345__$1 = state_53345;
var ex53359 = (state_53345__$1[(2)]);
var statearr_53363_53386 = state_53345__$1;
(statearr_53363_53386[(5)] = ex53359);


if((ex53359 instanceof Error)){
var statearr_53364_53387 = state_53345__$1;
(statearr_53364_53387[(1)] = (4));

(statearr_53364_53387[(5)] = null);

} else {
throw ex53359;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (14))){
var state_53345__$1 = state_53345;
var statearr_53365_53388 = state_53345__$1;
(statearr_53365_53388[(2)] = key);

(statearr_53365_53388[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (16))){
var inst_53323 = (state_53345[(2)]);
var inst_53324 = fluree.db.util.async.throw_err(inst_53323);
var state_53345__$1 = state_53345;
var statearr_53366_53389 = state_53345__$1;
(statearr_53366_53389[(2)] = inst_53324);

(statearr_53366_53389[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (10))){
var inst_53313 = (state_53345[(9)]);
var inst_53316 = cljs.core.vec(inst_53313);
var state_53345__$1 = state_53345;
var statearr_53367_53390 = state_53345__$1;
(statearr_53367_53390[(2)] = inst_53316);

(statearr_53367_53390[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (8))){
var inst_53313 = (state_53345[(9)]);
var inst_53313__$1 = (state_53345[(2)]);
var inst_53314 = cljs.core.set_QMARK_(inst_53313__$1);
var state_53345__$1 = (function (){var statearr_53368 = state_53345;
(statearr_53368[(9)] = inst_53313__$1);

return statearr_53368;
})();
if(inst_53314){
var statearr_53369_53391 = state_53345__$1;
(statearr_53369_53391[(1)] = (10));

} else {
var statearr_53370_53392 = state_53345__$1;
(statearr_53370_53392[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0 = (function (){
var statearr_53371 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53371[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__);

(statearr_53371[(1)] = (1));

return statearr_53371;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1 = (function (state_53345){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53345);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53372){var ex__2730__auto__ = e53372;
var statearr_53373_53393 = state_53345;
(statearr_53373_53393[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53345[(4)]))){
var statearr_53374_53394 = state_53345;
(statearr_53374_53394[(1)] = cljs.core.first((state_53345[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53395 = state_53345;
state_53345 = G__53395;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = function(state_53345){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1.call(this,state_53345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53375 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53375[(6)] = c__2749__auto__);

return statearr_53375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53456){
var state_val_53457 = (state_53456[(1)]);
if((state_val_53457 === (7))){
var state_53456__$1 = state_53456;
var statearr_53458_53492 = state_53456__$1;
(statearr_53458_53492[(2)] = test);

(statearr_53458_53492[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (20))){
var inst_53430 = (state_53456[(2)]);
var inst_53431 = fluree.db.util.async.throw_err(inst_53430);
var state_53456__$1 = state_53456;
var statearr_53459_53493 = state_53456__$1;
(statearr_53459_53493[(2)] = inst_53431);

(statearr_53459_53493[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (1))){
var state_53456__$1 = state_53456;
var statearr_53460_53494 = state_53456__$1;
(statearr_53460_53494[(2)] = null);

(statearr_53460_53494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (4))){
var inst_53396 = (state_53456[(2)]);
var state_53456__$1 = state_53456;
var statearr_53461_53495 = state_53456__$1;
(statearr_53461_53495[(2)] = inst_53396);

(statearr_53461_53495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (15))){
var inst_53414 = (state_53456[(7)]);
var inst_53422 = (state_53456[(2)]);
var inst_53423 = [inst_53422,f];
var inst_53424 = (new cljs.core.PersistentVector(null,2,(5),inst_53414,inst_53423,null));
var state_53456__$1 = state_53456;
var statearr_53462_53496 = state_53456__$1;
(statearr_53462_53496[(2)] = inst_53424);

(statearr_53462_53496[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (13))){
var state_53456__$1 = state_53456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53456__$1,(16),t);
} else {
if((state_val_53457 === (6))){
var state_53456__$1 = state_53456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53456__$1,(9),test);
} else {
if((state_val_53457 === (17))){
var state_53456__$1 = state_53456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53456__$1,(20),f);
} else {
if((state_val_53457 === (3))){
var inst_53454 = (state_53456[(2)]);
var state_53456__$1 = state_53456;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53456__$1,inst_53454);
} else {
if((state_val_53457 === (12))){
var inst_53412 = (state_53456[(8)]);
var inst_53438 = (state_53456[(2)]);
var inst_53439 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53438,(0),null);
var inst_53440 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53438,(1),null);
var inst_53441 = fluree.db.dbfunctions.internal.if_else(inst_53412,inst_53439,inst_53440);
var inst_53442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53443 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53445 = [inst_53412,inst_53439,inst_53440];
var inst_53446 = (new cljs.core.PersistentVector(null,3,(5),inst_53444,inst_53445,null));
var inst_53447 = ["if-else",inst_53446,inst_53441];
var inst_53448 = cljs.core.PersistentHashMap.fromArrays(inst_53443,inst_53447);
var inst_53449 = [inst_53448,(10)];
var inst_53450 = (new cljs.core.PersistentVector(null,2,(5),inst_53442,inst_53449,null));
var inst_53451 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53450);
var _ = (function (){var statearr_53463 = state_53456;
(statearr_53463[(4)] = cljs.core.rest((state_53456[(4)])));

return statearr_53463;
})();
var state_53456__$1 = (function (){var statearr_53464 = state_53456;
(statearr_53464[(9)] = inst_53451);

return statearr_53464;
})();
var statearr_53465_53497 = state_53456__$1;
(statearr_53465_53497[(2)] = inst_53441);

(statearr_53465_53497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (2))){
var _ = (function (){var statearr_53466 = state_53456;
(statearr_53466[(4)] = cljs.core.cons((5),(state_53456[(4)])));

return statearr_53466;
})();
var inst_53405 = fluree.db.util.async.channel_QMARK_(test);
var state_53456__$1 = state_53456;
if(inst_53405){
var statearr_53467_53498 = state_53456__$1;
(statearr_53467_53498[(1)] = (6));

} else {
var statearr_53468_53499 = state_53456__$1;
(statearr_53468_53499[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (19))){
var inst_53426 = (state_53456[(10)]);
var inst_53434 = (state_53456[(2)]);
var inst_53435 = [f,inst_53434];
var inst_53436 = (new cljs.core.PersistentVector(null,2,(5),inst_53426,inst_53435,null));
var state_53456__$1 = state_53456;
var statearr_53469_53500 = state_53456__$1;
(statearr_53469_53500[(2)] = inst_53436);

(statearr_53469_53500[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (11))){
var inst_53426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53427 = fluree.db.util.async.channel_QMARK_(f);
var state_53456__$1 = (function (){var statearr_53471 = state_53456;
(statearr_53471[(10)] = inst_53426);

return statearr_53471;
})();
if(inst_53427){
var statearr_53472_53501 = state_53456__$1;
(statearr_53472_53501[(1)] = (17));

} else {
var statearr_53473_53502 = state_53456__$1;
(statearr_53473_53502[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (9))){
var inst_53408 = (state_53456[(2)]);
var inst_53409 = fluree.db.util.async.throw_err(inst_53408);
var state_53456__$1 = state_53456;
var statearr_53474_53503 = state_53456__$1;
(statearr_53474_53503[(2)] = inst_53409);

(statearr_53474_53503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (5))){
var _ = (function (){var statearr_53475 = state_53456;
(statearr_53475[(4)] = cljs.core.rest((state_53456[(4)])));

return statearr_53475;
})();
var state_53456__$1 = state_53456;
var ex53470 = (state_53456__$1[(2)]);
var statearr_53476_53504 = state_53456__$1;
(statearr_53476_53504[(5)] = ex53470);


if((ex53470 instanceof Error)){
var statearr_53477_53505 = state_53456__$1;
(statearr_53477_53505[(1)] = (4));

(statearr_53477_53505[(5)] = null);

} else {
throw ex53470;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (14))){
var state_53456__$1 = state_53456;
var statearr_53478_53506 = state_53456__$1;
(statearr_53478_53506[(2)] = t);

(statearr_53478_53506[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (16))){
var inst_53418 = (state_53456[(2)]);
var inst_53419 = fluree.db.util.async.throw_err(inst_53418);
var state_53456__$1 = state_53456;
var statearr_53479_53507 = state_53456__$1;
(statearr_53479_53507[(2)] = inst_53419);

(statearr_53479_53507[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (10))){
var inst_53414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53415 = fluree.db.util.async.channel_QMARK_(t);
var state_53456__$1 = (function (){var statearr_53480 = state_53456;
(statearr_53480[(7)] = inst_53414);

return statearr_53480;
})();
if(inst_53415){
var statearr_53481_53508 = state_53456__$1;
(statearr_53481_53508[(1)] = (13));

} else {
var statearr_53482_53509 = state_53456__$1;
(statearr_53482_53509[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (18))){
var state_53456__$1 = state_53456;
var statearr_53483_53510 = state_53456__$1;
(statearr_53483_53510[(2)] = f);

(statearr_53483_53510[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53457 === (8))){
var inst_53412 = (state_53456[(8)]);
var inst_53412__$1 = (state_53456[(2)]);
var state_53456__$1 = (function (){var statearr_53484 = state_53456;
(statearr_53484[(8)] = inst_53412__$1);

return statearr_53484;
})();
if(cljs.core.truth_(inst_53412__$1)){
var statearr_53485_53511 = state_53456__$1;
(statearr_53485_53511[(1)] = (10));

} else {
var statearr_53486_53512 = state_53456__$1;
(statearr_53486_53512[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0 = (function (){
var statearr_53487 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_53487[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__);

(statearr_53487[(1)] = (1));

return statearr_53487;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1 = (function (state_53456){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53456);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53488){var ex__2730__auto__ = e53488;
var statearr_53489_53513 = state_53456;
(statearr_53489_53513[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53456[(4)]))){
var statearr_53490_53514 = state_53456;
(statearr_53490_53514[(1)] = cljs.core.first((state_53456[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53515 = state_53456;
state_53456 = G__53515;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = function(state_53456){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1.call(this,state_53456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53491 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53491[(6)] = c__2749__auto__);

return statearr_53491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53545){
var state_val_53546 = (state_53545[(1)]);
if((state_val_53546 === (7))){
var state_53545__$1 = state_53545;
var statearr_53547_53566 = state_53545__$1;
(statearr_53547_53566[(2)] = arg);

(statearr_53547_53566[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53546 === (1))){
var state_53545__$1 = state_53545;
var statearr_53548_53567 = state_53545__$1;
(statearr_53548_53567[(2)] = null);

(statearr_53548_53567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53546 === (4))){
var inst_53516 = (state_53545[(2)]);
var state_53545__$1 = state_53545;
var statearr_53549_53568 = state_53545__$1;
(statearr_53549_53568[(2)] = inst_53516);

(statearr_53549_53568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53546 === (6))){
var state_53545__$1 = state_53545;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53545__$1,(9),arg);
} else {
if((state_val_53546 === (3))){
var inst_53543 = (state_53545[(2)]);
var state_53545__$1 = state_53545;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53545__$1,inst_53543);
} else {
if((state_val_53546 === (2))){
var _ = (function (){var statearr_53551 = state_53545;
(statearr_53551[(4)] = cljs.core.cons((5),(state_53545[(4)])));

return statearr_53551;
})();
var inst_53522 = fluree.db.util.async.channel_QMARK_(arg);
var state_53545__$1 = state_53545;
if(inst_53522){
var statearr_53552_53569 = state_53545__$1;
(statearr_53552_53569[(1)] = (6));

} else {
var statearr_53553_53570 = state_53545__$1;
(statearr_53553_53570[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53546 === (9))){
var inst_53525 = (state_53545[(2)]);
var inst_53526 = fluree.db.util.async.throw_err(inst_53525);
var state_53545__$1 = state_53545;
var statearr_53554_53571 = state_53545__$1;
(statearr_53554_53571[(2)] = inst_53526);

(statearr_53554_53571[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53546 === (5))){
var _ = (function (){var statearr_53555 = state_53545;
(statearr_53555[(4)] = cljs.core.rest((state_53545[(4)])));

return statearr_53555;
})();
var state_53545__$1 = state_53545;
var ex53550 = (state_53545__$1[(2)]);
var statearr_53556_53572 = state_53545__$1;
(statearr_53556_53572[(5)] = ex53550);


if((ex53550 instanceof Error)){
var statearr_53557_53573 = state_53545__$1;
(statearr_53557_53573[(1)] = (4));

(statearr_53557_53573[(5)] = null);

} else {
throw ex53550;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53546 === (8))){
var inst_53529 = (state_53545[(2)]);
var inst_53530 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_53529);
var inst_53531 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53532 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53534 = [inst_53529];
var inst_53535 = (new cljs.core.PersistentVector(null,1,(5),inst_53533,inst_53534,null));
var inst_53536 = ["nil?",inst_53535,inst_53530];
var inst_53537 = cljs.core.PersistentHashMap.fromArrays(inst_53532,inst_53536);
var inst_53538 = [inst_53537,(10)];
var inst_53539 = (new cljs.core.PersistentVector(null,2,(5),inst_53531,inst_53538,null));
var inst_53540 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53539);
var _ = (function (){var statearr_53558 = state_53545;
(statearr_53558[(4)] = cljs.core.rest((state_53545[(4)])));

return statearr_53558;
})();
var state_53545__$1 = (function (){var statearr_53559 = state_53545;
(statearr_53559[(7)] = inst_53540);

return statearr_53559;
})();
var statearr_53560_53574 = state_53545__$1;
(statearr_53560_53574[(2)] = inst_53530);

(statearr_53560_53574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_53561 = [null,null,null,null,null,null,null,null];
(statearr_53561[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__);

(statearr_53561[(1)] = (1));

return statearr_53561;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1 = (function (state_53545){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53545);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53562){var ex__2730__auto__ = e53562;
var statearr_53563_53575 = state_53545;
(statearr_53563_53575[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53545[(4)]))){
var statearr_53564_53576 = state_53545;
(statearr_53564_53576[(1)] = cljs.core.first((state_53545[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53577 = state_53545;
state_53545 = G__53577;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = function(state_53545){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1.call(this,state_53545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53565 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53565[(6)] = c__2749__auto__);

return statearr_53565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53607){
var state_val_53608 = (state_53607[(1)]);
if((state_val_53608 === (7))){
var state_53607__$1 = state_53607;
var statearr_53609_53628 = state_53607__$1;
(statearr_53609_53628[(2)] = arg);

(statearr_53609_53628[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53608 === (1))){
var state_53607__$1 = state_53607;
var statearr_53610_53629 = state_53607__$1;
(statearr_53610_53629[(2)] = null);

(statearr_53610_53629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53608 === (4))){
var inst_53578 = (state_53607[(2)]);
var state_53607__$1 = state_53607;
var statearr_53611_53630 = state_53607__$1;
(statearr_53611_53630[(2)] = inst_53578);

(statearr_53611_53630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53608 === (6))){
var state_53607__$1 = state_53607;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53607__$1,(9),arg);
} else {
if((state_val_53608 === (3))){
var inst_53605 = (state_53607[(2)]);
var state_53607__$1 = state_53607;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53607__$1,inst_53605);
} else {
if((state_val_53608 === (2))){
var _ = (function (){var statearr_53613 = state_53607;
(statearr_53613[(4)] = cljs.core.cons((5),(state_53607[(4)])));

return statearr_53613;
})();
var inst_53584 = fluree.db.util.async.channel_QMARK_(arg);
var state_53607__$1 = state_53607;
if(inst_53584){
var statearr_53614_53631 = state_53607__$1;
(statearr_53614_53631[(1)] = (6));

} else {
var statearr_53615_53632 = state_53607__$1;
(statearr_53615_53632[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53608 === (9))){
var inst_53587 = (state_53607[(2)]);
var inst_53588 = fluree.db.util.async.throw_err(inst_53587);
var state_53607__$1 = state_53607;
var statearr_53616_53633 = state_53607__$1;
(statearr_53616_53633[(2)] = inst_53588);

(statearr_53616_53633[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53608 === (5))){
var _ = (function (){var statearr_53617 = state_53607;
(statearr_53617[(4)] = cljs.core.rest((state_53607[(4)])));

return statearr_53617;
})();
var state_53607__$1 = state_53607;
var ex53612 = (state_53607__$1[(2)]);
var statearr_53618_53634 = state_53607__$1;
(statearr_53618_53634[(5)] = ex53612);


if((ex53612 instanceof Error)){
var statearr_53619_53635 = state_53607__$1;
(statearr_53619_53635[(1)] = (4));

(statearr_53619_53635[(5)] = null);

} else {
throw ex53612;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53608 === (8))){
var inst_53591 = (state_53607[(2)]);
var inst_53592 = fluree.db.dbfunctions.internal.not(inst_53591);
var inst_53593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53594 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53596 = [inst_53591];
var inst_53597 = (new cljs.core.PersistentVector(null,1,(5),inst_53595,inst_53596,null));
var inst_53598 = ["not",inst_53597,inst_53592];
var inst_53599 = cljs.core.PersistentHashMap.fromArrays(inst_53594,inst_53598);
var inst_53600 = [inst_53599,(10)];
var inst_53601 = (new cljs.core.PersistentVector(null,2,(5),inst_53593,inst_53600,null));
var inst_53602 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53601);
var _ = (function (){var statearr_53620 = state_53607;
(statearr_53620[(4)] = cljs.core.rest((state_53607[(4)])));

return statearr_53620;
})();
var state_53607__$1 = (function (){var statearr_53621 = state_53607;
(statearr_53621[(7)] = inst_53602);

return statearr_53621;
})();
var statearr_53622_53636 = state_53607__$1;
(statearr_53622_53636[(2)] = inst_53592);

(statearr_53622_53636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0 = (function (){
var statearr_53623 = [null,null,null,null,null,null,null,null];
(statearr_53623[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__);

(statearr_53623[(1)] = (1));

return statearr_53623;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1 = (function (state_53607){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53607);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53624){var ex__2730__auto__ = e53624;
var statearr_53625_53637 = state_53607;
(statearr_53625_53637[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53607[(4)]))){
var statearr_53626_53638 = state_53607;
(statearr_53626_53638[(1)] = cljs.core.first((state_53607[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53639 = state_53607;
state_53607 = G__53639;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = function(state_53607){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1.call(this,state_53607);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53627 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53627[(6)] = c__2749__auto__);

return statearr_53627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53669){
var state_val_53670 = (state_53669[(1)]);
if((state_val_53670 === (7))){
var state_53669__$1 = state_53669;
var statearr_53671_53690 = state_53669__$1;
(statearr_53671_53690[(2)] = arg);

(statearr_53671_53690[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53670 === (1))){
var state_53669__$1 = state_53669;
var statearr_53672_53691 = state_53669__$1;
(statearr_53672_53691[(2)] = null);

(statearr_53672_53691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53670 === (4))){
var inst_53640 = (state_53669[(2)]);
var state_53669__$1 = state_53669;
var statearr_53673_53692 = state_53669__$1;
(statearr_53673_53692[(2)] = inst_53640);

(statearr_53673_53692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53670 === (6))){
var state_53669__$1 = state_53669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53669__$1,(9),arg);
} else {
if((state_val_53670 === (3))){
var inst_53667 = (state_53669[(2)]);
var state_53669__$1 = state_53669;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53669__$1,inst_53667);
} else {
if((state_val_53670 === (2))){
var _ = (function (){var statearr_53675 = state_53669;
(statearr_53675[(4)] = cljs.core.cons((5),(state_53669[(4)])));

return statearr_53675;
})();
var inst_53646 = fluree.db.util.async.channel_QMARK_(arg);
var state_53669__$1 = state_53669;
if(inst_53646){
var statearr_53676_53693 = state_53669__$1;
(statearr_53676_53693[(1)] = (6));

} else {
var statearr_53677_53694 = state_53669__$1;
(statearr_53677_53694[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53670 === (9))){
var inst_53649 = (state_53669[(2)]);
var inst_53650 = fluree.db.util.async.throw_err(inst_53649);
var state_53669__$1 = state_53669;
var statearr_53678_53695 = state_53669__$1;
(statearr_53678_53695[(2)] = inst_53650);

(statearr_53678_53695[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53670 === (5))){
var _ = (function (){var statearr_53679 = state_53669;
(statearr_53679[(4)] = cljs.core.rest((state_53669[(4)])));

return statearr_53679;
})();
var state_53669__$1 = state_53669;
var ex53674 = (state_53669__$1[(2)]);
var statearr_53680_53696 = state_53669__$1;
(statearr_53680_53696[(5)] = ex53674);


if((ex53674 instanceof Error)){
var statearr_53681_53697 = state_53669__$1;
(statearr_53681_53697[(1)] = (4));

(statearr_53681_53697[(5)] = null);

} else {
throw ex53674;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53670 === (8))){
var inst_53653 = (state_53669[(2)]);
var inst_53654 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_53653);
var inst_53655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53656 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53658 = [inst_53653];
var inst_53659 = (new cljs.core.PersistentVector(null,1,(5),inst_53657,inst_53658,null));
var inst_53660 = ["empty?",inst_53659,inst_53654];
var inst_53661 = cljs.core.PersistentHashMap.fromArrays(inst_53656,inst_53660);
var inst_53662 = [inst_53661,(10)];
var inst_53663 = (new cljs.core.PersistentVector(null,2,(5),inst_53655,inst_53662,null));
var inst_53664 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53663);
var _ = (function (){var statearr_53682 = state_53669;
(statearr_53682[(4)] = cljs.core.rest((state_53669[(4)])));

return statearr_53682;
})();
var state_53669__$1 = (function (){var statearr_53683 = state_53669;
(statearr_53683[(7)] = inst_53664);

return statearr_53683;
})();
var statearr_53684_53698 = state_53669__$1;
(statearr_53684_53698[(2)] = inst_53654);

(statearr_53684_53698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_53685 = [null,null,null,null,null,null,null,null];
(statearr_53685[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__);

(statearr_53685[(1)] = (1));

return statearr_53685;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1 = (function (state_53669){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53669);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53686){var ex__2730__auto__ = e53686;
var statearr_53687_53699 = state_53669;
(statearr_53687_53699[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53669[(4)]))){
var statearr_53688_53700 = state_53669;
(statearr_53688_53700[(1)] = cljs.core.first((state_53669[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53701 = state_53669;
state_53669 = G__53701;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = function(state_53669){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1.call(this,state_53669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53689 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53689[(6)] = c__2749__auto__);

return statearr_53689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53746 = arguments.length;
var i__4865__auto___53747 = (0);
while(true){
if((i__4865__auto___53747 < len__4864__auto___53746)){
args__4870__auto__.push((arguments[i__4865__auto___53747]));

var G__53748 = (i__4865__auto___53747 + (1));
i__4865__auto___53747 = G__53748;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53729){
var state_val_53730 = (state_53729[(1)]);
if((state_val_53730 === (1))){
var state_53729__$1 = state_53729;
var statearr_53731_53749 = state_53729__$1;
(statearr_53731_53749[(2)] = null);

(statearr_53731_53749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53730 === (2))){
var _ = (function (){var statearr_53732 = state_53729;
(statearr_53732[(4)] = cljs.core.cons((5),(state_53729[(4)])));

return statearr_53732;
})();
var inst_53710 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_53729__$1 = state_53729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53729__$1,(6),inst_53710);
} else {
if((state_val_53730 === (3))){
var inst_53727 = (state_53729[(2)]);
var state_53729__$1 = state_53729;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53729__$1,inst_53727);
} else {
if((state_val_53730 === (4))){
var inst_53704 = (state_53729[(2)]);
var state_53729__$1 = state_53729;
var statearr_53734_53750 = state_53729__$1;
(statearr_53734_53750[(2)] = inst_53704);

(statearr_53734_53750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53730 === (5))){
var _ = (function (){var statearr_53735 = state_53729;
(statearr_53735[(4)] = cljs.core.rest((state_53729[(4)])));

return statearr_53735;
})();
var state_53729__$1 = state_53729;
var ex53733 = (state_53729__$1[(2)]);
var statearr_53736_53751 = state_53729__$1;
(statearr_53736_53751[(5)] = ex53733);


if((ex53733 instanceof Error)){
var statearr_53737_53752 = state_53729__$1;
(statearr_53737_53752[(1)] = (4));

(statearr_53737_53752[(5)] = null);

} else {
throw ex53733;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53730 === (6))){
var inst_53712 = (state_53729[(2)]);
var inst_53713 = fluree.db.util.async.throw_err(inst_53712);
var inst_53714 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_53713);
var inst_53715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53716 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53718 = [inst_53713];
var inst_53719 = (new cljs.core.PersistentVector(null,1,(5),inst_53717,inst_53718,null));
var inst_53720 = ["str",inst_53719,inst_53714];
var inst_53721 = cljs.core.PersistentHashMap.fromArrays(inst_53716,inst_53720);
var inst_53722 = [inst_53721,(10)];
var inst_53723 = (new cljs.core.PersistentVector(null,2,(5),inst_53715,inst_53722,null));
var inst_53724 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53723);
var _ = (function (){var statearr_53738 = state_53729;
(statearr_53738[(4)] = cljs.core.rest((state_53729[(4)])));

return statearr_53738;
})();
var state_53729__$1 = (function (){var statearr_53739 = state_53729;
(statearr_53739[(7)] = inst_53724);

return statearr_53739;
})();
var statearr_53740_53753 = state_53729__$1;
(statearr_53740_53753[(2)] = inst_53714);

(statearr_53740_53753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_53741 = [null,null,null,null,null,null,null,null];
(statearr_53741[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_53741[(1)] = (1));

return statearr_53741;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_53729){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53729);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53742){var ex__2730__auto__ = e53742;
var statearr_53743_53754 = state_53729;
(statearr_53743_53754[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53729[(4)]))){
var statearr_53744_53755 = state_53729;
(statearr_53744_53755[(1)] = cljs.core.first((state_53729[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53756 = state_53729;
state_53729 = G__53756;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_53729){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_53729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53745 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53745[(6)] = c__2749__auto__);

return statearr_53745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq53702){
var G__53703 = cljs.core.first(seq53702);
var seq53702__$1 = cljs.core.next(seq53702);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53703,seq53702__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53782){
var state_val_53783 = (state_53782[(1)]);
if((state_val_53783 === (1))){
var state_53782__$1 = state_53782;
var statearr_53784_53799 = state_53782__$1;
(statearr_53784_53799[(2)] = null);

(statearr_53784_53799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53783 === (2))){
var _ = (function (){var statearr_53785 = state_53782;
(statearr_53785[(4)] = cljs.core.cons((5),(state_53782[(4)])));

return statearr_53785;
})();
var inst_53763 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_53782__$1 = state_53782;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53782__$1,(6),inst_53763);
} else {
if((state_val_53783 === (3))){
var inst_53780 = (state_53782[(2)]);
var state_53782__$1 = state_53782;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53782__$1,inst_53780);
} else {
if((state_val_53783 === (4))){
var inst_53757 = (state_53782[(2)]);
var state_53782__$1 = state_53782;
var statearr_53787_53800 = state_53782__$1;
(statearr_53787_53800[(2)] = inst_53757);

(statearr_53787_53800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53783 === (5))){
var _ = (function (){var statearr_53788 = state_53782;
(statearr_53788[(4)] = cljs.core.rest((state_53782[(4)])));

return statearr_53788;
})();
var state_53782__$1 = state_53782;
var ex53786 = (state_53782__$1[(2)]);
var statearr_53789_53801 = state_53782__$1;
(statearr_53789_53801[(5)] = ex53786);


if((ex53786 instanceof Error)){
var statearr_53790_53802 = state_53782__$1;
(statearr_53790_53802[(1)] = (4));

(statearr_53790_53802[(5)] = null);

} else {
throw ex53786;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53783 === (6))){
var inst_53765 = (state_53782[(2)]);
var inst_53766 = fluree.db.util.async.throw_err(inst_53765);
var inst_53767 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_53766);
var inst_53768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53769 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53771 = [inst_53766];
var inst_53772 = (new cljs.core.PersistentVector(null,1,(5),inst_53770,inst_53771,null));
var inst_53773 = ["subs",inst_53772,inst_53767];
var inst_53774 = cljs.core.PersistentHashMap.fromArrays(inst_53769,inst_53773);
var inst_53775 = [inst_53774,(30)];
var inst_53776 = (new cljs.core.PersistentVector(null,2,(5),inst_53768,inst_53775,null));
var inst_53777 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53776);
var _ = (function (){var statearr_53791 = state_53782;
(statearr_53791[(4)] = cljs.core.rest((state_53782[(4)])));

return statearr_53791;
})();
var state_53782__$1 = (function (){var statearr_53792 = state_53782;
(statearr_53792[(7)] = inst_53777);

return statearr_53792;
})();
var statearr_53793_53803 = state_53782__$1;
(statearr_53793_53803[(2)] = inst_53767);

(statearr_53793_53803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0 = (function (){
var statearr_53794 = [null,null,null,null,null,null,null,null];
(statearr_53794[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__);

(statearr_53794[(1)] = (1));

return statearr_53794;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1 = (function (state_53782){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53782);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53795){var ex__2730__auto__ = e53795;
var statearr_53796_53804 = state_53782;
(statearr_53796_53804[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53782[(4)]))){
var statearr_53797_53805 = state_53782;
(statearr_53797_53805[(1)] = cljs.core.first((state_53782[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53806 = state_53782;
state_53782 = G__53806;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = function(state_53782){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1.call(this,state_53782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53798 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53798[(6)] = c__2749__auto__);

return statearr_53798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53836){
var state_val_53837 = (state_53836[(1)]);
if((state_val_53837 === (7))){
var state_53836__$1 = state_53836;
var statearr_53838_53857 = state_53836__$1;
(statearr_53838_53857[(2)] = str);

(statearr_53838_53857[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53837 === (1))){
var state_53836__$1 = state_53836;
var statearr_53839_53858 = state_53836__$1;
(statearr_53839_53858[(2)] = null);

(statearr_53839_53858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53837 === (4))){
var inst_53807 = (state_53836[(2)]);
var state_53836__$1 = state_53836;
var statearr_53840_53859 = state_53836__$1;
(statearr_53840_53859[(2)] = inst_53807);

(statearr_53840_53859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53837 === (6))){
var state_53836__$1 = state_53836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53836__$1,(9),str);
} else {
if((state_val_53837 === (3))){
var inst_53834 = (state_53836[(2)]);
var state_53836__$1 = state_53836;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53836__$1,inst_53834);
} else {
if((state_val_53837 === (2))){
var _ = (function (){var statearr_53842 = state_53836;
(statearr_53842[(4)] = cljs.core.cons((5),(state_53836[(4)])));

return statearr_53842;
})();
var inst_53813 = fluree.db.util.async.channel_QMARK_(str);
var state_53836__$1 = state_53836;
if(inst_53813){
var statearr_53843_53860 = state_53836__$1;
(statearr_53843_53860[(1)] = (6));

} else {
var statearr_53844_53861 = state_53836__$1;
(statearr_53844_53861[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53837 === (9))){
var inst_53816 = (state_53836[(2)]);
var inst_53817 = fluree.db.util.async.throw_err(inst_53816);
var state_53836__$1 = state_53836;
var statearr_53845_53862 = state_53836__$1;
(statearr_53845_53862[(2)] = inst_53817);

(statearr_53845_53862[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53837 === (5))){
var _ = (function (){var statearr_53846 = state_53836;
(statearr_53846[(4)] = cljs.core.rest((state_53836[(4)])));

return statearr_53846;
})();
var state_53836__$1 = state_53836;
var ex53841 = (state_53836__$1[(2)]);
var statearr_53847_53863 = state_53836__$1;
(statearr_53847_53863[(5)] = ex53841);


if((ex53841 instanceof Error)){
var statearr_53848_53864 = state_53836__$1;
(statearr_53848_53864[(1)] = (4));

(statearr_53848_53864[(5)] = null);

} else {
throw ex53841;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53837 === (8))){
var inst_53820 = (state_53836[(2)]);
var inst_53821 = fluree.db.dbfunctions.internal.lower_case(inst_53820);
var inst_53822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53823 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53825 = [inst_53820];
var inst_53826 = (new cljs.core.PersistentVector(null,1,(5),inst_53824,inst_53825,null));
var inst_53827 = ["lower-case",inst_53826,inst_53821];
var inst_53828 = cljs.core.PersistentHashMap.fromArrays(inst_53823,inst_53827);
var inst_53829 = [inst_53828,(10)];
var inst_53830 = (new cljs.core.PersistentVector(null,2,(5),inst_53822,inst_53829,null));
var inst_53831 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53830);
var _ = (function (){var statearr_53849 = state_53836;
(statearr_53849[(4)] = cljs.core.rest((state_53836[(4)])));

return statearr_53849;
})();
var state_53836__$1 = (function (){var statearr_53850 = state_53836;
(statearr_53850[(7)] = inst_53831);

return statearr_53850;
})();
var statearr_53851_53865 = state_53836__$1;
(statearr_53851_53865[(2)] = inst_53821);

(statearr_53851_53865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0 = (function (){
var statearr_53852 = [null,null,null,null,null,null,null,null];
(statearr_53852[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__);

(statearr_53852[(1)] = (1));

return statearr_53852;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1 = (function (state_53836){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53836);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53853){var ex__2730__auto__ = e53853;
var statearr_53854_53866 = state_53836;
(statearr_53854_53866[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53836[(4)]))){
var statearr_53855_53867 = state_53836;
(statearr_53855_53867[(1)] = cljs.core.first((state_53836[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53868 = state_53836;
state_53836 = G__53868;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = function(state_53836){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1.call(this,state_53836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53856 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53856[(6)] = c__2749__auto__);

return statearr_53856;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53898){
var state_val_53899 = (state_53898[(1)]);
if((state_val_53899 === (7))){
var state_53898__$1 = state_53898;
var statearr_53900_53919 = state_53898__$1;
(statearr_53900_53919[(2)] = str);

(statearr_53900_53919[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53899 === (1))){
var state_53898__$1 = state_53898;
var statearr_53901_53920 = state_53898__$1;
(statearr_53901_53920[(2)] = null);

(statearr_53901_53920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53899 === (4))){
var inst_53869 = (state_53898[(2)]);
var state_53898__$1 = state_53898;
var statearr_53902_53921 = state_53898__$1;
(statearr_53902_53921[(2)] = inst_53869);

(statearr_53902_53921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53899 === (6))){
var state_53898__$1 = state_53898;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53898__$1,(9),str);
} else {
if((state_val_53899 === (3))){
var inst_53896 = (state_53898[(2)]);
var state_53898__$1 = state_53898;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53898__$1,inst_53896);
} else {
if((state_val_53899 === (2))){
var _ = (function (){var statearr_53904 = state_53898;
(statearr_53904[(4)] = cljs.core.cons((5),(state_53898[(4)])));

return statearr_53904;
})();
var inst_53875 = fluree.db.util.async.channel_QMARK_(str);
var state_53898__$1 = state_53898;
if(inst_53875){
var statearr_53905_53922 = state_53898__$1;
(statearr_53905_53922[(1)] = (6));

} else {
var statearr_53906_53923 = state_53898__$1;
(statearr_53906_53923[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53899 === (9))){
var inst_53878 = (state_53898[(2)]);
var inst_53879 = fluree.db.util.async.throw_err(inst_53878);
var state_53898__$1 = state_53898;
var statearr_53907_53924 = state_53898__$1;
(statearr_53907_53924[(2)] = inst_53879);

(statearr_53907_53924[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53899 === (5))){
var _ = (function (){var statearr_53908 = state_53898;
(statearr_53908[(4)] = cljs.core.rest((state_53898[(4)])));

return statearr_53908;
})();
var state_53898__$1 = state_53898;
var ex53903 = (state_53898__$1[(2)]);
var statearr_53909_53925 = state_53898__$1;
(statearr_53909_53925[(5)] = ex53903);


if((ex53903 instanceof Error)){
var statearr_53910_53926 = state_53898__$1;
(statearr_53910_53926[(1)] = (4));

(statearr_53910_53926[(5)] = null);

} else {
throw ex53903;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53899 === (8))){
var inst_53882 = (state_53898[(2)]);
var inst_53883 = fluree.db.dbfunctions.internal.upper_case(inst_53882);
var inst_53884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53885 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53886 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53887 = [inst_53882];
var inst_53888 = (new cljs.core.PersistentVector(null,1,(5),inst_53886,inst_53887,null));
var inst_53889 = ["upper-case",inst_53888,inst_53883];
var inst_53890 = cljs.core.PersistentHashMap.fromArrays(inst_53885,inst_53889);
var inst_53891 = [inst_53890,(10)];
var inst_53892 = (new cljs.core.PersistentVector(null,2,(5),inst_53884,inst_53891,null));
var inst_53893 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53892);
var _ = (function (){var statearr_53911 = state_53898;
(statearr_53911[(4)] = cljs.core.rest((state_53898[(4)])));

return statearr_53911;
})();
var state_53898__$1 = (function (){var statearr_53912 = state_53898;
(statearr_53912[(7)] = inst_53893);

return statearr_53912;
})();
var statearr_53913_53927 = state_53898__$1;
(statearr_53913_53927[(2)] = inst_53883);

(statearr_53913_53927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0 = (function (){
var statearr_53914 = [null,null,null,null,null,null,null,null];
(statearr_53914[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__);

(statearr_53914[(1)] = (1));

return statearr_53914;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1 = (function (state_53898){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53898);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53915){var ex__2730__auto__ = e53915;
var statearr_53916_53928 = state_53898;
(statearr_53916_53928[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53898[(4)]))){
var statearr_53917_53929 = state_53898;
(statearr_53917_53929[(1)] = cljs.core.first((state_53898[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53930 = state_53898;
state_53898 = G__53930;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = function(state_53898){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1.call(this,state_53898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53918 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53918[(6)] = c__2749__auto__);

return statearr_53918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4251__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4251__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__53932 = arguments.length;
switch (G__53932) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53960){
var state_val_53961 = (state_53960[(1)]);
if((state_val_53961 === (1))){
var state_53960__$1 = state_53960;
var statearr_53962_53978 = state_53960__$1;
(statearr_53962_53978[(2)] = null);

(statearr_53962_53978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53961 === (2))){
var _ = (function (){var statearr_53963 = state_53960;
(statearr_53963[(4)] = cljs.core.cons((5),(state_53960[(4)])));

return statearr_53963;
})();
var inst_53942 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_53960__$1 = state_53960;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53960__$1,(6),inst_53942);
} else {
if((state_val_53961 === (3))){
var inst_53958 = (state_53960[(2)]);
var state_53960__$1 = state_53960;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53960__$1,inst_53958);
} else {
if((state_val_53961 === (4))){
var inst_53933 = (state_53960[(2)]);
var state_53960__$1 = state_53960;
var statearr_53965_53979 = state_53960__$1;
(statearr_53965_53979[(2)] = inst_53933);

(statearr_53965_53979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53961 === (5))){
var _ = (function (){var statearr_53966 = state_53960;
(statearr_53966[(4)] = cljs.core.rest((state_53960[(4)])));

return statearr_53966;
})();
var state_53960__$1 = state_53960;
var ex53964 = (state_53960__$1[(2)]);
var statearr_53967_53980 = state_53960__$1;
(statearr_53967_53980[(5)] = ex53964);


if((ex53964 instanceof Error)){
var statearr_53968_53981 = state_53960__$1;
(statearr_53968_53981[(1)] = (4));

(statearr_53968_53981[(5)] = null);

} else {
throw ex53964;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53961 === (6))){
var inst_53944 = (state_53960[(2)]);
var inst_53945 = fluree.db.util.async.throw_err(inst_53944);
var inst_53946 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53945,(0),null);
var inst_53947 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53945,(1),null);
var inst_53948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53949 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53950 = ["?s","?ctx",inst_53946];
var inst_53951 = cljs.core.PersistentHashMap.fromArrays(inst_53949,inst_53950);
var inst_53952 = ((10) + inst_53947);
var inst_53953 = [inst_53951,inst_53952];
var inst_53954 = (new cljs.core.PersistentVector(null,2,(5),inst_53948,inst_53953,null));
var inst_53955 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53954);
var _ = (function (){var statearr_53969 = state_53960;
(statearr_53969[(4)] = cljs.core.rest((state_53960[(4)])));

return statearr_53969;
})();
var state_53960__$1 = (function (){var statearr_53970 = state_53960;
(statearr_53970[(7)] = inst_53955);

return statearr_53970;
})();
var statearr_53971_53982 = state_53960__$1;
(statearr_53971_53982[(2)] = inst_53946);

(statearr_53971_53982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_53972 = [null,null,null,null,null,null,null,null];
(statearr_53972[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_53972[(1)] = (1));

return statearr_53972;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_53960){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53960);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53973){var ex__2730__auto__ = e53973;
var statearr_53974_53983 = state_53960;
(statearr_53974_53983[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53960[(4)]))){
var statearr_53975_53984 = state_53960;
(statearr_53975_53984[(1)] = cljs.core.first((state_53960[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53985 = state_53960;
state_53960 = G__53985;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_53960){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_53960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53976 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53976[(6)] = c__2749__auto__);

return statearr_53976;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__53987 = arguments.length;
switch (G__53987) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54025){
var state_val_54026 = (state_54025[(1)]);
if((state_val_54026 === (7))){
var inst_54018 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_54025__$1 = state_54025;
var statearr_54027_54047 = state_54025__$1;
(statearr_54027_54047[(2)] = inst_54018);

(statearr_54027_54047[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54026 === (1))){
var state_54025__$1 = state_54025;
var statearr_54028_54048 = state_54025__$1;
(statearr_54028_54048[(2)] = null);

(statearr_54028_54048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54026 === (4))){
var inst_53988 = (state_54025[(2)]);
var state_54025__$1 = state_54025;
var statearr_54029_54049 = state_54025__$1;
(statearr_54029_54049[(2)] = inst_53988);

(statearr_54029_54049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54026 === (6))){
var inst_53999 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_54025__$1 = state_54025;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54025__$1,(10),inst_53999);
} else {
if((state_val_54026 === (3))){
var inst_54023 = (state_54025[(2)]);
var state_54025__$1 = state_54025;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54025__$1,inst_54023);
} else {
if((state_val_54026 === (2))){
var _ = (function (){var statearr_54031 = state_54025;
(statearr_54031[(4)] = cljs.core.cons((5),(state_54025[(4)])));

return statearr_54031;
})();
var inst_53994 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54025__$1 = state_54025;
if(cljs.core.truth_(inst_53994)){
var statearr_54032_54050 = state_54025__$1;
(statearr_54032_54050[(1)] = (6));

} else {
var statearr_54033_54051 = state_54025__$1;
(statearr_54033_54051[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54026 === (9))){
var inst_54005 = (state_54025[(2)]);
var inst_54006 = fluree.db.util.async.throw_err(inst_54005);
var inst_54007 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54006,(0),null);
var inst_54008 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54006,(1),null);
var inst_54009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54010 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54011 = ["?p","?ctx",inst_54007];
var inst_54012 = cljs.core.PersistentHashMap.fromArrays(inst_54010,inst_54011);
var inst_54013 = ((10) + inst_54008);
var inst_54014 = [inst_54012,inst_54013];
var inst_54015 = (new cljs.core.PersistentVector(null,2,(5),inst_54009,inst_54014,null));
var inst_54016 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54015);
var state_54025__$1 = (function (){var statearr_54034 = state_54025;
(statearr_54034[(7)] = inst_54016);

return statearr_54034;
})();
var statearr_54035_54052 = state_54025__$1;
(statearr_54035_54052[(2)] = inst_54007);

(statearr_54035_54052[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54026 === (5))){
var _ = (function (){var statearr_54036 = state_54025;
(statearr_54036[(4)] = cljs.core.rest((state_54025[(4)])));

return statearr_54036;
})();
var state_54025__$1 = state_54025;
var ex54030 = (state_54025__$1[(2)]);
var statearr_54037_54053 = state_54025__$1;
(statearr_54037_54053[(5)] = ex54030);


if((ex54030 instanceof Error)){
var statearr_54038_54054 = state_54025__$1;
(statearr_54038_54054[(1)] = (4));

(statearr_54038_54054[(5)] = null);

} else {
throw ex54030;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54026 === (10))){
var inst_54001 = (state_54025[(2)]);
var inst_54002 = fluree.db.util.async.throw_err(inst_54001);
var inst_54003 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_54002);
var state_54025__$1 = state_54025;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54025__$1,(9),inst_54003);
} else {
if((state_val_54026 === (8))){
var inst_54020 = (state_54025[(2)]);
var _ = (function (){var statearr_54039 = state_54025;
(statearr_54039[(4)] = cljs.core.rest((state_54025[(4)])));

return statearr_54039;
})();
var state_54025__$1 = state_54025;
var statearr_54040_54055 = state_54025__$1;
(statearr_54040_54055[(2)] = inst_54020);

(statearr_54040_54055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54041 = [null,null,null,null,null,null,null,null];
(statearr_54041[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54041[(1)] = (1));

return statearr_54041;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54025){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54025);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54042){var ex__2730__auto__ = e54042;
var statearr_54043_54056 = state_54025;
(statearr_54043_54056[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54025[(4)]))){
var statearr_54044_54057 = state_54025;
(statearr_54044_54057[(1)] = cljs.core.first((state_54025[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54058 = state_54025;
state_54025 = G__54058;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54025){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54045 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54045[(6)] = c__2749__auto__);

return statearr_54045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54107 = arguments.length;
var i__4865__auto___54108 = (0);
while(true){
if((i__4865__auto___54108 < len__4864__auto___54107)){
args__4870__auto__.push((arguments[i__4865__auto___54108]));

var G__54109 = (i__4865__auto___54108 + (1));
i__4865__auto___54108 = G__54109;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54090){
var state_val_54091 = (state_54090[(1)]);
if((state_val_54091 === (1))){
var state_54090__$1 = state_54090;
var statearr_54092_54110 = state_54090__$1;
(statearr_54092_54110[(2)] = null);

(statearr_54092_54110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54091 === (2))){
var _ = (function (){var statearr_54093 = state_54090;
(statearr_54093[(4)] = cljs.core.cons((5),(state_54090[(4)])));

return statearr_54093;
})();
var inst_54067 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54090__$1 = state_54090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54090__$1,(6),inst_54067);
} else {
if((state_val_54091 === (3))){
var inst_54088 = (state_54090[(2)]);
var state_54090__$1 = state_54090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54090__$1,inst_54088);
} else {
if((state_val_54091 === (4))){
var inst_54061 = (state_54090[(2)]);
var state_54090__$1 = state_54090;
var statearr_54095_54111 = state_54090__$1;
(statearr_54095_54111[(2)] = inst_54061);

(statearr_54095_54111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54091 === (5))){
var _ = (function (){var statearr_54096 = state_54090;
(statearr_54096[(4)] = cljs.core.rest((state_54090[(4)])));

return statearr_54096;
})();
var state_54090__$1 = state_54090;
var ex54094 = (state_54090__$1[(2)]);
var statearr_54097_54112 = state_54090__$1;
(statearr_54097_54112[(5)] = ex54094);


if((ex54094 instanceof Error)){
var statearr_54098_54113 = state_54090__$1;
(statearr_54098_54113[(1)] = (4));

(statearr_54098_54113[(5)] = null);

} else {
throw ex54094;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54091 === (6))){
var inst_54069 = (state_54090[(2)]);
var inst_54070 = fluree.db.util.async.throw_err(inst_54069);
var inst_54071 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_54070);
var inst_54072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54073 = [inst_54070];
var inst_54074 = (new cljs.core.PersistentVector(null,1,(5),inst_54072,inst_54073,null));
var inst_54075 = cljs.core.count(inst_54074);
var inst_54076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54077 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54079 = [inst_54070];
var inst_54080 = (new cljs.core.PersistentVector(null,1,(5),inst_54078,inst_54079,null));
var inst_54081 = ["and",inst_54080,inst_54071];
var inst_54082 = cljs.core.PersistentHashMap.fromArrays(inst_54077,inst_54081);
var inst_54083 = [inst_54082,inst_54075];
var inst_54084 = (new cljs.core.PersistentVector(null,2,(5),inst_54076,inst_54083,null));
var inst_54085 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54084);
var _ = (function (){var statearr_54099 = state_54090;
(statearr_54099[(4)] = cljs.core.rest((state_54090[(4)])));

return statearr_54099;
})();
var state_54090__$1 = (function (){var statearr_54100 = state_54090;
(statearr_54100[(7)] = inst_54085);

return statearr_54100;
})();
var statearr_54101_54114 = state_54090__$1;
(statearr_54101_54114[(2)] = inst_54071);

(statearr_54101_54114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54102 = [null,null,null,null,null,null,null,null];
(statearr_54102[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54102[(1)] = (1));

return statearr_54102;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54090){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54090);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54103){var ex__2730__auto__ = e54103;
var statearr_54104_54115 = state_54090;
(statearr_54104_54115[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54090[(4)]))){
var statearr_54105_54116 = state_54090;
(statearr_54105_54116[(1)] = cljs.core.first((state_54090[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54117 = state_54090;
state_54090 = G__54117;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54090){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54106 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54106[(6)] = c__2749__auto__);

return statearr_54106;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54059){
var G__54060 = cljs.core.first(seq54059);
var seq54059__$1 = cljs.core.next(seq54059);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54060,seq54059__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54166 = arguments.length;
var i__4865__auto___54167 = (0);
while(true){
if((i__4865__auto___54167 < len__4864__auto___54166)){
args__4870__auto__.push((arguments[i__4865__auto___54167]));

var G__54168 = (i__4865__auto___54167 + (1));
i__4865__auto___54167 = G__54168;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54149){
var state_val_54150 = (state_54149[(1)]);
if((state_val_54150 === (1))){
var state_54149__$1 = state_54149;
var statearr_54151_54169 = state_54149__$1;
(statearr_54151_54169[(2)] = null);

(statearr_54151_54169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54150 === (2))){
var _ = (function (){var statearr_54152 = state_54149;
(statearr_54152[(4)] = cljs.core.cons((5),(state_54149[(4)])));

return statearr_54152;
})();
var inst_54126 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54149__$1 = state_54149;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54149__$1,(6),inst_54126);
} else {
if((state_val_54150 === (3))){
var inst_54147 = (state_54149[(2)]);
var state_54149__$1 = state_54149;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54149__$1,inst_54147);
} else {
if((state_val_54150 === (4))){
var inst_54120 = (state_54149[(2)]);
var state_54149__$1 = state_54149;
var statearr_54154_54170 = state_54149__$1;
(statearr_54154_54170[(2)] = inst_54120);

(statearr_54154_54170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54150 === (5))){
var _ = (function (){var statearr_54155 = state_54149;
(statearr_54155[(4)] = cljs.core.rest((state_54149[(4)])));

return statearr_54155;
})();
var state_54149__$1 = state_54149;
var ex54153 = (state_54149__$1[(2)]);
var statearr_54156_54171 = state_54149__$1;
(statearr_54156_54171[(5)] = ex54153);


if((ex54153 instanceof Error)){
var statearr_54157_54172 = state_54149__$1;
(statearr_54157_54172[(1)] = (4));

(statearr_54157_54172[(5)] = null);

} else {
throw ex54153;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54150 === (6))){
var inst_54128 = (state_54149[(2)]);
var inst_54129 = fluree.db.util.async.throw_err(inst_54128);
var inst_54130 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_54129);
var inst_54131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54132 = [inst_54129];
var inst_54133 = (new cljs.core.PersistentVector(null,1,(5),inst_54131,inst_54132,null));
var inst_54134 = cljs.core.count(inst_54133);
var inst_54135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54136 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54138 = [inst_54129];
var inst_54139 = (new cljs.core.PersistentVector(null,1,(5),inst_54137,inst_54138,null));
var inst_54140 = ["or",inst_54139,inst_54130];
var inst_54141 = cljs.core.PersistentHashMap.fromArrays(inst_54136,inst_54140);
var inst_54142 = [inst_54141,inst_54134];
var inst_54143 = (new cljs.core.PersistentVector(null,2,(5),inst_54135,inst_54142,null));
var inst_54144 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54143);
var _ = (function (){var statearr_54158 = state_54149;
(statearr_54158[(4)] = cljs.core.rest((state_54149[(4)])));

return statearr_54158;
})();
var state_54149__$1 = (function (){var statearr_54159 = state_54149;
(statearr_54159[(7)] = inst_54144);

return statearr_54159;
})();
var statearr_54160_54173 = state_54149__$1;
(statearr_54160_54173[(2)] = inst_54130);

(statearr_54160_54173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54161 = [null,null,null,null,null,null,null,null];
(statearr_54161[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54161[(1)] = (1));

return statearr_54161;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54149){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54149);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54162){var ex__2730__auto__ = e54162;
var statearr_54163_54174 = state_54149;
(statearr_54163_54174[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54149[(4)]))){
var statearr_54164_54175 = state_54149;
(statearr_54164_54175[(1)] = cljs.core.first((state_54149[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54176 = state_54149;
state_54149 = G__54176;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54149){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54149);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54165 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54165[(6)] = c__2749__auto__);

return statearr_54165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq54118){
var G__54119 = cljs.core.first(seq54118);
var seq54118__$1 = cljs.core.next(seq54118);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54119,seq54118__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54214){
var state_val_54215 = (state_54214[(1)]);
if((state_val_54215 === (7))){
var inst_54190 = fluree.db.util.async.channel_QMARK_(coll);
var state_54214__$1 = state_54214;
if(inst_54190){
var statearr_54216_54239 = state_54214__$1;
(statearr_54216_54239[(1)] = (10));

} else {
var statearr_54217_54240 = state_54214__$1;
(statearr_54217_54240[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54215 === (1))){
var state_54214__$1 = state_54214;
var statearr_54218_54241 = state_54214__$1;
(statearr_54218_54241[(2)] = null);

(statearr_54218_54241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54215 === (4))){
var inst_54177 = (state_54214[(2)]);
var state_54214__$1 = state_54214;
var statearr_54219_54242 = state_54214__$1;
(statearr_54219_54242[(2)] = inst_54177);

(statearr_54219_54242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54215 === (13))){
var inst_54193 = (state_54214[(2)]);
var inst_54194 = fluree.db.util.async.throw_err(inst_54193);
var state_54214__$1 = state_54214;
var statearr_54220_54243 = state_54214__$1;
(statearr_54220_54243[(2)] = inst_54194);

(statearr_54220_54243[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54215 === (6))){
var inst_54185 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_54214__$1 = state_54214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54214__$1,(9),inst_54185);
} else {
if((state_val_54215 === (3))){
var inst_54212 = (state_54214[(2)]);
var state_54214__$1 = state_54214;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54214__$1,inst_54212);
} else {
if((state_val_54215 === (12))){
var inst_54197 = (state_54214[(2)]);
var state_54214__$1 = state_54214;
var statearr_54221_54244 = state_54214__$1;
(statearr_54221_54244[(2)] = inst_54197);

(statearr_54221_54244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54215 === (2))){
var _ = (function (){var statearr_54222 = state_54214;
(statearr_54222[(4)] = cljs.core.cons((5),(state_54214[(4)])));

return statearr_54222;
})();
var inst_54183 = cljs.core.vector_QMARK_(coll);
var state_54214__$1 = state_54214;
if(inst_54183){
var statearr_54223_54245 = state_54214__$1;
(statearr_54223_54245[(1)] = (6));

} else {
var statearr_54224_54246 = state_54214__$1;
(statearr_54224_54246[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54215 === (11))){
var state_54214__$1 = state_54214;
var statearr_54226_54247 = state_54214__$1;
(statearr_54226_54247[(2)] = coll);

(statearr_54226_54247[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54215 === (9))){
var inst_54187 = (state_54214[(2)]);
var inst_54188 = fluree.db.util.async.throw_err(inst_54187);
var state_54214__$1 = state_54214;
var statearr_54227_54248 = state_54214__$1;
(statearr_54227_54248[(2)] = inst_54188);

(statearr_54227_54248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54215 === (5))){
var _ = (function (){var statearr_54228 = state_54214;
(statearr_54228[(4)] = cljs.core.rest((state_54214[(4)])));

return statearr_54228;
})();
var state_54214__$1 = state_54214;
var ex54225 = (state_54214__$1[(2)]);
var statearr_54229_54249 = state_54214__$1;
(statearr_54229_54249[(5)] = ex54225);


if((ex54225 instanceof Error)){
var statearr_54230_54250 = state_54214__$1;
(statearr_54230_54250[(1)] = (4));

(statearr_54230_54250[(5)] = null);

} else {
throw ex54225;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54215 === (10))){
var state_54214__$1 = state_54214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54214__$1,(13),coll);
} else {
if((state_val_54215 === (8))){
var inst_54199 = (state_54214[(2)]);
var inst_54200 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_54199);
var inst_54201 = cljs.core.count(inst_54200);
var inst_54202 = ((9) + inst_54201);
var inst_54203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54204 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54205 = ["count",inst_54199,inst_54201];
var inst_54206 = cljs.core.PersistentHashMap.fromArrays(inst_54204,inst_54205);
var inst_54207 = [inst_54206,inst_54202];
var inst_54208 = (new cljs.core.PersistentVector(null,2,(5),inst_54203,inst_54207,null));
var inst_54209 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54208);
var _ = (function (){var statearr_54231 = state_54214;
(statearr_54231[(4)] = cljs.core.rest((state_54214[(4)])));

return statearr_54231;
})();
var state_54214__$1 = (function (){var statearr_54232 = state_54214;
(statearr_54232[(7)] = inst_54209);

return statearr_54232;
})();
var statearr_54233_54251 = state_54214__$1;
(statearr_54233_54251[(2)] = inst_54201);

(statearr_54233_54251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0 = (function (){
var statearr_54234 = [null,null,null,null,null,null,null,null];
(statearr_54234[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__);

(statearr_54234[(1)] = (1));

return statearr_54234;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1 = (function (state_54214){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54214);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54235){var ex__2730__auto__ = e54235;
var statearr_54236_54252 = state_54214;
(statearr_54236_54252[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54214[(4)]))){
var statearr_54237_54253 = state_54214;
(statearr_54237_54253[(1)] = cljs.core.first((state_54214[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54254 = state_54214;
state_54214 = G__54254;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = function(state_54214){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1.call(this,state_54214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54238 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54238[(6)] = c__2749__auto__);

return statearr_54238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__54255,subject,pred){
var map__54256 = p__54255;
var map__54256__$1 = cljs.core.__destructure_map(map__54256);
var _QMARK_ctx = map__54256__$1;
var cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54256__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54256__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54347){
var state_val_54348 = (state_54347[(1)]);
if((state_val_54348 === (7))){
var state_54347__$1 = state_54347;
var statearr_54349_54405 = state_54347__$1;
(statearr_54349_54405[(2)] = subject);

(statearr_54349_54405[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (20))){
var state_54347__$1 = state_54347;
var statearr_54350_54406 = state_54347__$1;
(statearr_54350_54406[(2)] = cache);

(statearr_54350_54406[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (27))){
var inst_54290 = (state_54347[(7)]);
var inst_54278 = (state_54347[(8)]);
var inst_54304 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_54290,inst_54278);
var state_54347__$1 = state_54347;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54347__$1,(29),inst_54304);
} else {
if((state_val_54348 === (1))){
var state_54347__$1 = state_54347;
var statearr_54351_54407 = state_54347__$1;
(statearr_54351_54407[(2)] = null);

(statearr_54351_54407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (24))){
var inst_54290 = (state_54347[(7)]);
var inst_54317 = cljs.core.int_QMARK_(inst_54290);
var state_54347__$1 = state_54347;
if(inst_54317){
var statearr_54352_54408 = state_54347__$1;
(statearr_54352_54408[(1)] = (30));

} else {
var statearr_54353_54409 = state_54347__$1;
(statearr_54353_54409[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (4))){
var inst_54257 = (state_54347[(2)]);
var state_54347__$1 = state_54347;
var statearr_54354_54410 = state_54347__$1;
(statearr_54354_54410[(2)] = inst_54257);

(statearr_54354_54410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (15))){
var inst_54270 = (state_54347[(9)]);
var state_54347__$1 = state_54347;
var statearr_54355_54411 = state_54347__$1;
(statearr_54355_54411[(2)] = inst_54270);

(statearr_54355_54411[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (21))){
var inst_54291 = (state_54347[(10)]);
var state_54347__$1 = state_54347;
var statearr_54356_54412 = state_54347__$1;
(statearr_54356_54412[(2)] = inst_54291);

(statearr_54356_54412[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (31))){
var state_54347__$1 = state_54347;
var statearr_54357_54413 = state_54347__$1;
(statearr_54357_54413[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (32))){
var inst_54330 = (state_54347[(2)]);
var state_54347__$1 = state_54347;
var statearr_54359_54414 = state_54347__$1;
(statearr_54359_54414[(2)] = inst_54330);

(statearr_54359_54414[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (33))){
var inst_54321 = (state_54347[(2)]);
var inst_54322 = fluree.db.util.async.throw_err(inst_54321);
var state_54347__$1 = state_54347;
var statearr_54360_54415 = state_54347__$1;
(statearr_54360_54415[(2)] = inst_54322);

(statearr_54360_54415[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (13))){
var inst_54274 = (state_54347[(2)]);
var inst_54275 = fluree.db.util.async.throw_err(inst_54274);
var state_54347__$1 = state_54347;
var statearr_54361_54416 = state_54347__$1;
(statearr_54361_54416[(2)] = inst_54275);

(statearr_54361_54416[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (22))){
var inst_54295 = (state_54347[(2)]);
var state_54347__$1 = state_54347;
if(cljs.core.truth_(inst_54295)){
var statearr_54362_54417 = state_54347__$1;
(statearr_54362_54417[(1)] = (23));

} else {
var statearr_54363_54418 = state_54347__$1;
(statearr_54363_54418[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (36))){
var inst_54328 = (state_54347[(2)]);
var state_54347__$1 = state_54347;
var statearr_54364_54419 = state_54347__$1;
(statearr_54364_54419[(2)] = inst_54328);

(statearr_54364_54419[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (29))){
var inst_54290 = (state_54347[(7)]);
var inst_54278 = (state_54347[(8)]);
var inst_54306 = (state_54347[(2)]);
var inst_54307 = fluree.db.util.async.throw_err(inst_54306);
var inst_54308 = cljs.core._deref(cache);
var inst_54309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54310 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_54290,inst_54278];
var inst_54311 = (new cljs.core.PersistentVector(null,3,(5),inst_54309,inst_54310,null));
var inst_54312 = cljs.core.assoc_in(inst_54308,inst_54311,inst_54307);
var inst_54313 = cljs.core._vreset_BANG_(cache,inst_54312);
var state_54347__$1 = (function (){var statearr_54365 = state_54347;
(statearr_54365[(11)] = inst_54313);

return statearr_54365;
})();
var statearr_54366_54420 = state_54347__$1;
(statearr_54366_54420[(2)] = inst_54307);

(statearr_54366_54420[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (6))){
var state_54347__$1 = state_54347;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54347__$1,(9),subject);
} else {
if((state_val_54348 === (28))){
var inst_54315 = (state_54347[(2)]);
var state_54347__$1 = state_54347;
var statearr_54367_54421 = state_54347__$1;
(statearr_54367_54421[(2)] = inst_54315);

(statearr_54367_54421[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (25))){
var inst_54270 = (state_54347[(9)]);
var inst_54278 = (state_54347[(8)]);
var inst_54332 = (state_54347[(2)]);
var inst_54333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54334 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54336 = [inst_54270,inst_54278];
var inst_54337 = (new cljs.core.PersistentVector(null,2,(5),inst_54335,inst_54336,null));
var inst_54338 = ["get",inst_54337,inst_54332];
var inst_54339 = cljs.core.PersistentHashMap.fromArrays(inst_54334,inst_54338);
var inst_54340 = [inst_54339,(10)];
var inst_54341 = (new cljs.core.PersistentVector(null,2,(5),inst_54333,inst_54340,null));
var inst_54342 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54341);
var _ = (function (){var statearr_54368 = state_54347;
(statearr_54368[(4)] = cljs.core.rest((state_54347[(4)])));

return statearr_54368;
})();
var state_54347__$1 = (function (){var statearr_54369 = state_54347;
(statearr_54369[(12)] = inst_54342);

return statearr_54369;
})();
var statearr_54370_54422 = state_54347__$1;
(statearr_54370_54422[(2)] = inst_54332);

(statearr_54370_54422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (34))){
var inst_54290 = (state_54347[(7)]);
var inst_54278 = (state_54347[(8)]);
var inst_54325 = fluree.db.dbfunctions.internal.get(inst_54290,inst_54278);
var state_54347__$1 = state_54347;
var statearr_54371_54423 = state_54347__$1;
(statearr_54371_54423[(2)] = inst_54325);

(statearr_54371_54423[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (17))){
var inst_54270 = (state_54347[(9)]);
var inst_54284 = cljs.core.first(inst_54270);
var state_54347__$1 = state_54347;
var statearr_54372_54424 = state_54347__$1;
(statearr_54372_54424[(2)] = inst_54284);

(statearr_54372_54424[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (3))){
var inst_54345 = (state_54347[(2)]);
var state_54347__$1 = state_54347;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54347__$1,inst_54345);
} else {
if((state_val_54348 === (12))){
var inst_54270 = (state_54347[(9)]);
var inst_54278 = (state_54347[(2)]);
var inst_54279 = cljs.core.vector_QMARK_(inst_54270);
var state_54347__$1 = (function (){var statearr_54373 = state_54347;
(statearr_54373[(8)] = inst_54278);

return statearr_54373;
})();
if(inst_54279){
var statearr_54374_54425 = state_54347__$1;
(statearr_54374_54425[(1)] = (14));

} else {
var statearr_54375_54426 = state_54347__$1;
(statearr_54375_54426[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (2))){
var _ = (function (){var statearr_54376 = state_54347;
(statearr_54376[(4)] = cljs.core.cons((5),(state_54347[(4)])));

return statearr_54376;
})();
var inst_54263 = fluree.db.util.async.channel_QMARK_(subject);
var state_54347__$1 = state_54347;
if(inst_54263){
var statearr_54377_54427 = state_54347__$1;
(statearr_54377_54427[(1)] = (6));

} else {
var statearr_54378_54428 = state_54347__$1;
(statearr_54378_54428[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (23))){
var inst_54290 = (state_54347[(7)]);
var inst_54278 = (state_54347[(8)]);
var inst_54301 = (state_54347[(13)]);
var inst_54297 = cljs.core.deref(cache);
var inst_54298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54299 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_54290,inst_54278];
var inst_54300 = (new cljs.core.PersistentVector(null,3,(5),inst_54298,inst_54299,null));
var inst_54301__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_54297,inst_54300);
var state_54347__$1 = (function (){var statearr_54379 = state_54347;
(statearr_54379[(13)] = inst_54301__$1);

return statearr_54379;
})();
if(cljs.core.truth_(inst_54301__$1)){
var statearr_54380_54429 = state_54347__$1;
(statearr_54380_54429[(1)] = (26));

} else {
var statearr_54381_54430 = state_54347__$1;
(statearr_54381_54430[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (35))){
var state_54347__$1 = state_54347;
var statearr_54382_54431 = state_54347__$1;
(statearr_54382_54431[(2)] = null);

(statearr_54382_54431[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (19))){
var inst_54287 = (state_54347[(2)]);
var state_54347__$1 = state_54347;
var statearr_54383_54432 = state_54347__$1;
(statearr_54383_54432[(2)] = inst_54287);

(statearr_54383_54432[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (11))){
var state_54347__$1 = state_54347;
var statearr_54385_54433 = state_54347__$1;
(statearr_54385_54433[(2)] = pred);

(statearr_54385_54433[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (9))){
var inst_54266 = (state_54347[(2)]);
var inst_54267 = fluree.db.util.async.throw_err(inst_54266);
var state_54347__$1 = state_54347;
var statearr_54386_54434 = state_54347__$1;
(statearr_54386_54434[(2)] = inst_54267);

(statearr_54386_54434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (5))){
var _ = (function (){var statearr_54387 = state_54347;
(statearr_54387[(4)] = cljs.core.rest((state_54347[(4)])));

return statearr_54387;
})();
var state_54347__$1 = state_54347;
var ex54384 = (state_54347__$1[(2)]);
var statearr_54388_54435 = state_54347__$1;
(statearr_54388_54435[(5)] = ex54384);


if((ex54384 instanceof Error)){
var statearr_54389_54436 = state_54347__$1;
(statearr_54389_54436[(1)] = (4));

(statearr_54389_54436[(5)] = null);

} else {
throw ex54384;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (14))){
var inst_54270 = (state_54347[(9)]);
var inst_54281 = cljs.core.count(inst_54270);
var inst_54282 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54281);
var state_54347__$1 = state_54347;
if(inst_54282){
var statearr_54390_54437 = state_54347__$1;
(statearr_54390_54437[(1)] = (17));

} else {
var statearr_54391_54438 = state_54347__$1;
(statearr_54391_54438[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (26))){
var inst_54301 = (state_54347[(13)]);
var state_54347__$1 = state_54347;
var statearr_54392_54439 = state_54347__$1;
(statearr_54392_54439[(2)] = inst_54301);

(statearr_54392_54439[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (16))){
var inst_54291 = (state_54347[(10)]);
var inst_54290 = (state_54347[(7)]);
var inst_54290__$1 = (state_54347[(2)]);
var inst_54291__$1 = cljs.core.int_QMARK_(inst_54290__$1);
var state_54347__$1 = (function (){var statearr_54393 = state_54347;
(statearr_54393[(10)] = inst_54291__$1);

(statearr_54393[(7)] = inst_54290__$1);

return statearr_54393;
})();
if(inst_54291__$1){
var statearr_54394_54440 = state_54347__$1;
(statearr_54394_54440[(1)] = (20));

} else {
var statearr_54395_54441 = state_54347__$1;
(statearr_54395_54441[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (30))){
var inst_54290 = (state_54347[(7)]);
var inst_54278 = (state_54347[(8)]);
var inst_54319 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_54290,inst_54278);
var state_54347__$1 = state_54347;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54347__$1,(33),inst_54319);
} else {
if((state_val_54348 === (10))){
var state_54347__$1 = state_54347;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54347__$1,(13),pred);
} else {
if((state_val_54348 === (18))){
var inst_54270 = (state_54347[(9)]);
var state_54347__$1 = state_54347;
var statearr_54396_54442 = state_54347__$1;
(statearr_54396_54442[(2)] = inst_54270);

(statearr_54396_54442[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54348 === (8))){
var inst_54270 = (state_54347[(2)]);
var inst_54271 = fluree.db.util.async.channel_QMARK_(pred);
var state_54347__$1 = (function (){var statearr_54397 = state_54347;
(statearr_54397[(9)] = inst_54270);

return statearr_54397;
})();
if(inst_54271){
var statearr_54398_54443 = state_54347__$1;
(statearr_54398_54443[(1)] = (10));

} else {
var statearr_54399_54444 = state_54347__$1;
(statearr_54399_54444[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0 = (function (){
var statearr_54400 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54400[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__);

(statearr_54400[(1)] = (1));

return statearr_54400;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1 = (function (state_54347){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54347);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54401){var ex__2730__auto__ = e54401;
var statearr_54402_54445 = state_54347;
(statearr_54402_54445[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54347[(4)]))){
var statearr_54403_54446 = state_54347;
(statearr_54403_54446[(1)] = cljs.core.first((state_54347[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54447 = state_54347;
state_54347 = G__54447;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = function(state_54347){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1.call(this,state_54347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54404 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54404[(6)] = c__2749__auto__);

return statearr_54404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54486){
var state_val_54487 = (state_54486[(1)]);
if((state_val_54487 === (7))){
var inst_54454 = (state_54486[(7)]);
var state_54486__$1 = state_54486;
var statearr_54488_54512 = state_54486__$1;
(statearr_54488_54512[(2)] = inst_54454);

(statearr_54488_54512[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54487 === (1))){
var state_54486__$1 = state_54486;
var statearr_54489_54513 = state_54486__$1;
(statearr_54489_54513[(2)] = null);

(statearr_54489_54513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54487 === (4))){
var inst_54448 = (state_54486[(2)]);
var state_54486__$1 = state_54486;
var statearr_54490_54514 = state_54486__$1;
(statearr_54490_54514[(2)] = inst_54448);

(statearr_54490_54514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54487 === (6))){
var inst_54456 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54486__$1 = state_54486;
var statearr_54491_54515 = state_54486__$1;
(statearr_54491_54515[(2)] = inst_54456);

(statearr_54491_54515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54487 === (3))){
var inst_54484 = (state_54486[(2)]);
var state_54486__$1 = state_54486;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54486__$1,inst_54484);
} else {
if((state_val_54487 === (12))){
var inst_54466 = (state_54486[(2)]);
var inst_54467 = fluree.db.util.async.throw_err(inst_54466);
var inst_54468 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54467,(0),null);
var inst_54469 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54467,(1),null);
var inst_54470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54471 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54472 = ["?pO","?ctx",inst_54468];
var inst_54473 = cljs.core.PersistentHashMap.fromArrays(inst_54471,inst_54472);
var inst_54474 = ((10) + inst_54469);
var inst_54475 = [inst_54473,inst_54474];
var inst_54476 = (new cljs.core.PersistentVector(null,2,(5),inst_54470,inst_54475,null));
var inst_54477 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54476);
var state_54486__$1 = (function (){var statearr_54492 = state_54486;
(statearr_54492[(8)] = inst_54477);

return statearr_54492;
})();
var statearr_54493_54516 = state_54486__$1;
(statearr_54493_54516[(2)] = inst_54468);

(statearr_54493_54516[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54487 === (2))){
var inst_54454 = (state_54486[(7)]);
var _ = (function (){var statearr_54494 = state_54486;
(statearr_54494[(4)] = cljs.core.cons((5),(state_54486[(4)])));

return statearr_54494;
})();
var inst_54454__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54486__$1 = (function (){var statearr_54495 = state_54486;
(statearr_54495[(7)] = inst_54454__$1);

return statearr_54495;
})();
if(cljs.core.truth_(inst_54454__$1)){
var statearr_54496_54517 = state_54486__$1;
(statearr_54496_54517[(1)] = (6));

} else {
var statearr_54497_54518 = state_54486__$1;
(statearr_54497_54518[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54487 === (11))){
var inst_54481 = (state_54486[(2)]);
var _ = (function (){var statearr_54499 = state_54486;
(statearr_54499[(4)] = cljs.core.rest((state_54486[(4)])));

return statearr_54499;
})();
var state_54486__$1 = state_54486;
var statearr_54500_54519 = state_54486__$1;
(statearr_54500_54519[(2)] = inst_54481);

(statearr_54500_54519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54487 === (9))){
var inst_54464 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_54486__$1 = state_54486;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54486__$1,(12),inst_54464);
} else {
if((state_val_54487 === (5))){
var _ = (function (){var statearr_54501 = state_54486;
(statearr_54501[(4)] = cljs.core.rest((state_54486[(4)])));

return statearr_54501;
})();
var state_54486__$1 = state_54486;
var ex54498 = (state_54486__$1[(2)]);
var statearr_54502_54520 = state_54486__$1;
(statearr_54502_54520[(5)] = ex54498);


if((ex54498 instanceof Error)){
var statearr_54503_54521 = state_54486__$1;
(statearr_54503_54521[(1)] = (4));

(statearr_54503_54521[(5)] = null);

} else {
throw ex54498;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54487 === (10))){
var inst_54479 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_54486__$1 = state_54486;
var statearr_54504_54522 = state_54486__$1;
(statearr_54504_54522[(2)] = inst_54479);

(statearr_54504_54522[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54487 === (8))){
var inst_54459 = (state_54486[(2)]);
var state_54486__$1 = state_54486;
if(cljs.core.truth_(inst_54459)){
var statearr_54505_54523 = state_54486__$1;
(statearr_54505_54523[(1)] = (9));

} else {
var statearr_54506_54524 = state_54486__$1;
(statearr_54506_54524[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_54507 = [null,null,null,null,null,null,null,null,null];
(statearr_54507[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_54507[(1)] = (1));

return statearr_54507;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_54486){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54486);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54508){var ex__2730__auto__ = e54508;
var statearr_54509_54525 = state_54486;
(statearr_54509_54525[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54486[(4)]))){
var statearr_54510_54526 = state_54486;
(statearr_54510_54526[(1)] = cljs.core.first((state_54486[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54527 = state_54486;
state_54486 = G__54527;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = function(state_54486){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_54486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54511 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54511[(6)] = c__2749__auto__);

return statearr_54511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54596){
var state_val_54597 = (state_54596[(1)]);
if((state_val_54597 === (7))){
var state_54596__$1 = state_54596;
var statearr_54598_54636 = state_54596__$1;
(statearr_54598_54636[(2)] = subject);

(statearr_54598_54636[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (20))){
var inst_54552 = (state_54596[(7)]);
var inst_54564 = (state_54596[(8)]);
var inst_54567 = fluree.db.dbfunctions.internal.follow_subject(_QMARK_ctx,inst_54564,inst_54552);
var state_54596__$1 = state_54596;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54596__$1,(23),inst_54567);
} else {
if((state_val_54597 === (1))){
var state_54596__$1 = state_54596;
var statearr_54599_54637 = state_54596__$1;
(statearr_54599_54637[(2)] = null);

(statearr_54599_54637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (4))){
var inst_54528 = (state_54596[(2)]);
var state_54596__$1 = state_54596;
var statearr_54600_54638 = state_54596__$1;
(statearr_54600_54638[(2)] = inst_54528);

(statearr_54600_54638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (15))){
var inst_54544 = (state_54596[(9)]);
var state_54596__$1 = state_54596;
var statearr_54601_54639 = state_54596__$1;
(statearr_54601_54639[(2)] = inst_54544);

(statearr_54601_54639[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (21))){
var inst_54552 = (state_54596[(7)]);
var inst_54564 = (state_54596[(8)]);
var inst_54572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54573 = fluree.db.dbfunctions.internal.get_all(inst_54564,inst_54552);
var inst_54574 = cljs.core.count(inst_54552);
var inst_54575 = ((9) + inst_54574);
var inst_54576 = [inst_54573,inst_54575];
var inst_54577 = (new cljs.core.PersistentVector(null,2,(5),inst_54572,inst_54576,null));
var state_54596__$1 = state_54596;
var statearr_54602_54640 = state_54596__$1;
(statearr_54602_54640[(2)] = inst_54577);

(statearr_54602_54640[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (13))){
var inst_54548 = (state_54596[(2)]);
var inst_54549 = fluree.db.util.async.throw_err(inst_54548);
var state_54596__$1 = state_54596;
var statearr_54603_54641 = state_54596__$1;
(statearr_54603_54641[(2)] = inst_54549);

(statearr_54603_54641[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (22))){
var inst_54552 = (state_54596[(7)]);
var inst_54544 = (state_54596[(9)]);
var inst_54579 = (state_54596[(2)]);
var inst_54580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54579,(0),null);
var inst_54581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54579,(1),null);
var inst_54582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54583 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54585 = [inst_54544,inst_54552];
var inst_54586 = (new cljs.core.PersistentVector(null,2,(5),inst_54584,inst_54585,null));
var inst_54587 = ["get-all",inst_54586,inst_54580];
var inst_54588 = cljs.core.PersistentHashMap.fromArrays(inst_54583,inst_54587);
var inst_54589 = [inst_54588,inst_54581];
var inst_54590 = (new cljs.core.PersistentVector(null,2,(5),inst_54582,inst_54589,null));
var inst_54591 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54590);
var _ = (function (){var statearr_54604 = state_54596;
(statearr_54604[(4)] = cljs.core.rest((state_54596[(4)])));

return statearr_54604;
})();
var state_54596__$1 = (function (){var statearr_54605 = state_54596;
(statearr_54605[(10)] = inst_54591);

return statearr_54605;
})();
var statearr_54606_54642 = state_54596__$1;
(statearr_54606_54642[(2)] = inst_54580);

(statearr_54606_54642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (6))){
var state_54596__$1 = state_54596;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54596__$1,(9),subject);
} else {
if((state_val_54597 === (17))){
var inst_54544 = (state_54596[(9)]);
var inst_54558 = cljs.core.first(inst_54544);
var state_54596__$1 = state_54596;
var statearr_54607_54643 = state_54596__$1;
(statearr_54607_54643[(2)] = inst_54558);

(statearr_54607_54643[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (3))){
var inst_54594 = (state_54596[(2)]);
var state_54596__$1 = state_54596;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54596__$1,inst_54594);
} else {
if((state_val_54597 === (12))){
var inst_54544 = (state_54596[(9)]);
var inst_54552 = (state_54596[(2)]);
var inst_54553 = cljs.core.vector_QMARK_(inst_54544);
var state_54596__$1 = (function (){var statearr_54608 = state_54596;
(statearr_54608[(7)] = inst_54552);

return statearr_54608;
})();
if(inst_54553){
var statearr_54609_54644 = state_54596__$1;
(statearr_54609_54644[(1)] = (14));

} else {
var statearr_54610_54645 = state_54596__$1;
(statearr_54610_54645[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (2))){
var _ = (function (){var statearr_54611 = state_54596;
(statearr_54611[(4)] = cljs.core.cons((5),(state_54596[(4)])));

return statearr_54611;
})();
var inst_54537 = fluree.db.util.async.channel_QMARK_(subject);
var state_54596__$1 = state_54596;
if(inst_54537){
var statearr_54612_54646 = state_54596__$1;
(statearr_54612_54646[(1)] = (6));

} else {
var statearr_54613_54647 = state_54596__$1;
(statearr_54613_54647[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (23))){
var inst_54569 = (state_54596[(2)]);
var inst_54570 = fluree.db.util.async.throw_err(inst_54569);
var state_54596__$1 = state_54596;
var statearr_54614_54648 = state_54596__$1;
(statearr_54614_54648[(2)] = inst_54570);

(statearr_54614_54648[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (19))){
var inst_54561 = (state_54596[(2)]);
var state_54596__$1 = state_54596;
var statearr_54615_54649 = state_54596__$1;
(statearr_54615_54649[(2)] = inst_54561);

(statearr_54615_54649[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (11))){
var state_54596__$1 = state_54596;
var statearr_54617_54650 = state_54596__$1;
(statearr_54617_54650[(2)] = path);

(statearr_54617_54650[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (9))){
var inst_54540 = (state_54596[(2)]);
var inst_54541 = fluree.db.util.async.throw_err(inst_54540);
var state_54596__$1 = state_54596;
var statearr_54618_54651 = state_54596__$1;
(statearr_54618_54651[(2)] = inst_54541);

(statearr_54618_54651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (5))){
var _ = (function (){var statearr_54619 = state_54596;
(statearr_54619[(4)] = cljs.core.rest((state_54596[(4)])));

return statearr_54619;
})();
var state_54596__$1 = state_54596;
var ex54616 = (state_54596__$1[(2)]);
var statearr_54620_54652 = state_54596__$1;
(statearr_54620_54652[(5)] = ex54616);


if((ex54616 instanceof Error)){
var statearr_54621_54653 = state_54596__$1;
(statearr_54621_54653[(1)] = (4));

(statearr_54621_54653[(5)] = null);

} else {
throw ex54616;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (14))){
var inst_54544 = (state_54596[(9)]);
var inst_54555 = cljs.core.count(inst_54544);
var inst_54556 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54555);
var state_54596__$1 = state_54596;
if(inst_54556){
var statearr_54622_54654 = state_54596__$1;
(statearr_54622_54654[(1)] = (17));

} else {
var statearr_54623_54655 = state_54596__$1;
(statearr_54623_54655[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (16))){
var inst_54564 = (state_54596[(8)]);
var inst_54564__$1 = (state_54596[(2)]);
var inst_54565 = cljs.core.int_QMARK_(inst_54564__$1);
var state_54596__$1 = (function (){var statearr_54624 = state_54596;
(statearr_54624[(8)] = inst_54564__$1);

return statearr_54624;
})();
if(inst_54565){
var statearr_54625_54656 = state_54596__$1;
(statearr_54625_54656[(1)] = (20));

} else {
var statearr_54626_54657 = state_54596__$1;
(statearr_54626_54657[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (10))){
var state_54596__$1 = state_54596;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54596__$1,(13),path);
} else {
if((state_val_54597 === (18))){
var inst_54544 = (state_54596[(9)]);
var state_54596__$1 = state_54596;
var statearr_54627_54658 = state_54596__$1;
(statearr_54627_54658[(2)] = inst_54544);

(statearr_54627_54658[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54597 === (8))){
var inst_54544 = (state_54596[(2)]);
var inst_54545 = fluree.db.util.async.channel_QMARK_(path);
var state_54596__$1 = (function (){var statearr_54628 = state_54596;
(statearr_54628[(9)] = inst_54544);

return statearr_54628;
})();
if(inst_54545){
var statearr_54629_54659 = state_54596__$1;
(statearr_54629_54659[(1)] = (10));

} else {
var statearr_54630_54660 = state_54596__$1;
(statearr_54630_54660[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0 = (function (){
var statearr_54631 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54631[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__);

(statearr_54631[(1)] = (1));

return statearr_54631;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1 = (function (state_54596){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54596);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54632){var ex__2730__auto__ = e54632;
var statearr_54633_54661 = state_54596;
(statearr_54633_54661[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54596[(4)]))){
var statearr_54634_54662 = state_54596;
(statearr_54634_54662[(1)] = cljs.core.first((state_54596[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54663 = state_54596;
state_54596 = G__54663;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = function(state_54596){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1.call(this,state_54596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54635 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54635[(6)] = c__2749__auto__);

return statearr_54635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54702){
var state_val_54703 = (state_54702[(1)]);
if((state_val_54703 === (7))){
var state_54702__$1 = state_54702;
var statearr_54704_54728 = state_54702__$1;
(statearr_54704_54728[(2)] = subject);

(statearr_54704_54728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54703 === (1))){
var state_54702__$1 = state_54702;
var statearr_54705_54729 = state_54702__$1;
(statearr_54705_54729[(2)] = null);

(statearr_54705_54729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54703 === (4))){
var inst_54664 = (state_54702[(2)]);
var state_54702__$1 = state_54702;
var statearr_54706_54730 = state_54702__$1;
(statearr_54706_54730[(2)] = inst_54664);

(statearr_54706_54730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54703 === (13))){
var inst_54681 = (state_54702[(2)]);
var inst_54682 = fluree.db.util.async.throw_err(inst_54681);
var state_54702__$1 = state_54702;
var statearr_54707_54731 = state_54702__$1;
(statearr_54707_54731[(2)] = inst_54682);

(statearr_54707_54731[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54703 === (6))){
var state_54702__$1 = state_54702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54702__$1,(9),subject);
} else {
if((state_val_54703 === (3))){
var inst_54700 = (state_54702[(2)]);
var state_54702__$1 = state_54702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54702__$1,inst_54700);
} else {
if((state_val_54703 === (12))){
var inst_54677 = (state_54702[(7)]);
var inst_54685 = (state_54702[(2)]);
var inst_54686 = fluree.db.dbfunctions.internal.get_in(inst_54677,inst_54685);
var inst_54687 = cljs.core.count(inst_54685);
var inst_54688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54689 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54691 = [inst_54677,inst_54685];
var inst_54692 = (new cljs.core.PersistentVector(null,2,(5),inst_54690,inst_54691,null));
var inst_54693 = ["get-in",inst_54692,inst_54686];
var inst_54694 = cljs.core.PersistentHashMap.fromArrays(inst_54689,inst_54693);
var inst_54695 = [inst_54694,inst_54687];
var inst_54696 = (new cljs.core.PersistentVector(null,2,(5),inst_54688,inst_54695,null));
var inst_54697 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54696);
var _ = (function (){var statearr_54708 = state_54702;
(statearr_54708[(4)] = cljs.core.rest((state_54702[(4)])));

return statearr_54708;
})();
var state_54702__$1 = (function (){var statearr_54709 = state_54702;
(statearr_54709[(8)] = inst_54697);

return statearr_54709;
})();
var statearr_54710_54732 = state_54702__$1;
(statearr_54710_54732[(2)] = inst_54686);

(statearr_54710_54732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54703 === (2))){
var _ = (function (){var statearr_54711 = state_54702;
(statearr_54711[(4)] = cljs.core.cons((5),(state_54702[(4)])));

return statearr_54711;
})();
var inst_54670 = fluree.db.util.async.channel_QMARK_(subject);
var state_54702__$1 = state_54702;
if(inst_54670){
var statearr_54712_54733 = state_54702__$1;
(statearr_54712_54733[(1)] = (6));

} else {
var statearr_54713_54734 = state_54702__$1;
(statearr_54713_54734[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54703 === (11))){
var state_54702__$1 = state_54702;
var statearr_54715_54735 = state_54702__$1;
(statearr_54715_54735[(2)] = path);

(statearr_54715_54735[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54703 === (9))){
var inst_54673 = (state_54702[(2)]);
var inst_54674 = fluree.db.util.async.throw_err(inst_54673);
var state_54702__$1 = state_54702;
var statearr_54716_54736 = state_54702__$1;
(statearr_54716_54736[(2)] = inst_54674);

(statearr_54716_54736[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54703 === (5))){
var _ = (function (){var statearr_54717 = state_54702;
(statearr_54717[(4)] = cljs.core.rest((state_54702[(4)])));

return statearr_54717;
})();
var state_54702__$1 = state_54702;
var ex54714 = (state_54702__$1[(2)]);
var statearr_54718_54737 = state_54702__$1;
(statearr_54718_54737[(5)] = ex54714);


if((ex54714 instanceof Error)){
var statearr_54719_54738 = state_54702__$1;
(statearr_54719_54738[(1)] = (4));

(statearr_54719_54738[(5)] = null);

} else {
throw ex54714;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54703 === (10))){
var state_54702__$1 = state_54702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54702__$1,(13),path);
} else {
if((state_val_54703 === (8))){
var inst_54677 = (state_54702[(2)]);
var inst_54678 = fluree.db.util.async.channel_QMARK_(path);
var state_54702__$1 = (function (){var statearr_54720 = state_54702;
(statearr_54720[(7)] = inst_54677);

return statearr_54720;
})();
if(inst_54678){
var statearr_54721_54739 = state_54702__$1;
(statearr_54721_54739[(1)] = (10));

} else {
var statearr_54722_54740 = state_54702__$1;
(statearr_54722_54740[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0 = (function (){
var statearr_54723 = [null,null,null,null,null,null,null,null,null];
(statearr_54723[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__);

(statearr_54723[(1)] = (1));

return statearr_54723;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1 = (function (state_54702){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54702);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54724){var ex__2730__auto__ = e54724;
var statearr_54725_54741 = state_54702;
(statearr_54725_54741[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54702[(4)]))){
var statearr_54726_54742 = state_54702;
(statearr_54726_54742[(1)] = cljs.core.first((state_54702[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54743 = state_54702;
state_54702 = G__54743;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = function(state_54702){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1.call(this,state_54702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54727 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54727[(6)] = c__2749__auto__);

return statearr_54727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__54744,key_or_ks){
var map__54745 = p__54744;
var map__54745__$1 = cljs.core.__destructure_map(map__54745);
var _QMARK_ctx = map__54745__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54745__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_(key_or_ks)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54790){
var state_val_54791 = (state_54790[(1)]);
if((state_val_54791 === (7))){
var state_54790__$1 = state_54790;
var statearr_54792_54821 = state_54790__$1;
(statearr_54792_54821[(2)] = coll);

(statearr_54792_54821[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54791 === (1))){
var state_54790__$1 = state_54790;
var statearr_54793_54822 = state_54790__$1;
(statearr_54793_54822[(2)] = null);

(statearr_54793_54822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54791 === (4))){
var inst_54746 = (state_54790[(2)]);
var state_54790__$1 = state_54790;
var statearr_54794_54823 = state_54790__$1;
(statearr_54794_54823[(2)] = inst_54746);

(statearr_54794_54823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54791 === (15))){
var inst_54766 = (state_54790[(7)]);
var inst_54774 = (state_54790[(2)]);
var inst_54775 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_54766,inst_54774);
var inst_54776 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54777 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54779 = [inst_54766,inst_54774];
var inst_54780 = (new cljs.core.PersistentVector(null,2,(5),inst_54778,inst_54779,null));
var inst_54781 = ["contains?",inst_54780,inst_54775];
var inst_54782 = cljs.core.PersistentHashMap.fromArrays(inst_54777,inst_54781);
var inst_54783 = [inst_54782,(10)];
var inst_54784 = (new cljs.core.PersistentVector(null,2,(5),inst_54776,inst_54783,null));
var inst_54785 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54784);
var _ = (function (){var statearr_54795 = state_54790;
(statearr_54795[(4)] = cljs.core.rest((state_54790[(4)])));

return statearr_54795;
})();
var state_54790__$1 = (function (){var statearr_54796 = state_54790;
(statearr_54796[(8)] = inst_54785);

return statearr_54796;
})();
var statearr_54797_54824 = state_54790__$1;
(statearr_54797_54824[(2)] = inst_54775);

(statearr_54797_54824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54791 === (13))){
var state_54790__$1 = state_54790;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54790__$1,(16),key);
} else {
if((state_val_54791 === (6))){
var state_54790__$1 = state_54790;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54790__$1,(9),coll);
} else {
if((state_val_54791 === (3))){
var inst_54788 = (state_54790[(2)]);
var state_54790__$1 = state_54790;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54790__$1,inst_54788);
} else {
if((state_val_54791 === (12))){
var inst_54766 = (state_54790[(2)]);
var inst_54767 = fluree.db.util.async.channel_QMARK_(key);
var state_54790__$1 = (function (){var statearr_54798 = state_54790;
(statearr_54798[(7)] = inst_54766);

return statearr_54798;
})();
if(inst_54767){
var statearr_54799_54825 = state_54790__$1;
(statearr_54799_54825[(1)] = (13));

} else {
var statearr_54800_54826 = state_54790__$1;
(statearr_54800_54826[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54791 === (2))){
var _ = (function (){var statearr_54801 = state_54790;
(statearr_54801[(4)] = cljs.core.cons((5),(state_54790[(4)])));

return statearr_54801;
})();
var inst_54752 = fluree.db.util.async.channel_QMARK_(coll);
var state_54790__$1 = state_54790;
if(inst_54752){
var statearr_54802_54827 = state_54790__$1;
(statearr_54802_54827[(1)] = (6));

} else {
var statearr_54803_54828 = state_54790__$1;
(statearr_54803_54828[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54791 === (11))){
var inst_54759 = (state_54790[(9)]);
var inst_54763 = cljs.core.flatten(inst_54759);
var inst_54764 = cljs.core.set(inst_54763);
var state_54790__$1 = state_54790;
var statearr_54805_54829 = state_54790__$1;
(statearr_54805_54829[(2)] = inst_54764);

(statearr_54805_54829[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54791 === (9))){
var inst_54755 = (state_54790[(2)]);
var inst_54756 = fluree.db.util.async.throw_err(inst_54755);
var state_54790__$1 = state_54790;
var statearr_54806_54830 = state_54790__$1;
(statearr_54806_54830[(2)] = inst_54756);

(statearr_54806_54830[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54791 === (5))){
var _ = (function (){var statearr_54807 = state_54790;
(statearr_54807[(4)] = cljs.core.rest((state_54790[(4)])));

return statearr_54807;
})();
var state_54790__$1 = state_54790;
var ex54804 = (state_54790__$1[(2)]);
var statearr_54808_54831 = state_54790__$1;
(statearr_54808_54831[(5)] = ex54804);


if((ex54804 instanceof Error)){
var statearr_54809_54832 = state_54790__$1;
(statearr_54809_54832[(1)] = (4));

(statearr_54809_54832[(5)] = null);

} else {
throw ex54804;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54791 === (14))){
var state_54790__$1 = state_54790;
var statearr_54810_54833 = state_54790__$1;
(statearr_54810_54833[(2)] = key);

(statearr_54810_54833[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54791 === (16))){
var inst_54770 = (state_54790[(2)]);
var inst_54771 = fluree.db.util.async.throw_err(inst_54770);
var state_54790__$1 = state_54790;
var statearr_54811_54834 = state_54790__$1;
(statearr_54811_54834[(2)] = inst_54771);

(statearr_54811_54834[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54791 === (10))){
var inst_54759 = (state_54790[(9)]);
var state_54790__$1 = state_54790;
var statearr_54812_54835 = state_54790__$1;
(statearr_54812_54835[(2)] = inst_54759);

(statearr_54812_54835[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54791 === (8))){
var inst_54759 = (state_54790[(9)]);
var inst_54759__$1 = (state_54790[(2)]);
var inst_54760 = cljs.core.set_QMARK_(inst_54759__$1);
var state_54790__$1 = (function (){var statearr_54813 = state_54790;
(statearr_54813[(9)] = inst_54759__$1);

return statearr_54813;
})();
if(inst_54760){
var statearr_54814_54836 = state_54790__$1;
(statearr_54814_54836[(1)] = (10));

} else {
var statearr_54815_54837 = state_54790__$1;
(statearr_54815_54837[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_54816 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54816[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__);

(statearr_54816[(1)] = (1));

return statearr_54816;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1 = (function (state_54790){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54790);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54817){var ex__2730__auto__ = e54817;
var statearr_54818_54838 = state_54790;
(statearr_54818_54838[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54790[(4)]))){
var statearr_54819_54839 = state_54790;
(statearr_54819_54839[(1)] = cljs.core.first((state_54790[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54840 = state_54790;
state_54790 = G__54840;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = function(state_54790){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1.call(this,state_54790);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54820 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54820[(6)] = c__2749__auto__);

return statearr_54820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54912 = arguments.length;
var i__4865__auto___54913 = (0);
while(true){
if((i__4865__auto___54913 < len__4864__auto___54912)){
args__4870__auto__.push((arguments[i__4865__auto___54913]));

var G__54914 = (i__4865__auto___54913 + (1));
i__4865__auto___54913 = G__54914;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54886){
var state_val_54887 = (state_54886[(1)]);
if((state_val_54887 === (7))){
var inst_54852 = (state_54886[(7)]);
var inst_54856 = cljs.core.first(inst_54852);
var inst_54857 = cljs.core.coll_QMARK_(inst_54856);
var state_54886__$1 = state_54886;
var statearr_54888_54915 = state_54886__$1;
(statearr_54888_54915[(2)] = inst_54857);

(statearr_54888_54915[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54887 === (1))){
var state_54886__$1 = state_54886;
var statearr_54889_54916 = state_54886__$1;
(statearr_54889_54916[(2)] = null);

(statearr_54889_54916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54887 === (4))){
var inst_54843 = (state_54886[(2)]);
var state_54886__$1 = state_54886;
var statearr_54890_54917 = state_54886__$1;
(statearr_54890_54917[(2)] = inst_54843);

(statearr_54890_54917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54887 === (6))){
var inst_54852 = (state_54886[(7)]);
var inst_54854 = (state_54886[(8)]);
var inst_54851 = (state_54886[(2)]);
var inst_54852__$1 = fluree.db.util.async.throw_err(inst_54851);
var inst_54853 = cljs.core.count(inst_54852__$1);
var inst_54854__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54853);
var state_54886__$1 = (function (){var statearr_54891 = state_54886;
(statearr_54891[(7)] = inst_54852__$1);

(statearr_54891[(8)] = inst_54854__$1);

return statearr_54891;
})();
if(inst_54854__$1){
var statearr_54892_54918 = state_54886__$1;
(statearr_54892_54918[(1)] = (7));

} else {
var statearr_54893_54919 = state_54886__$1;
(statearr_54893_54919[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54887 === (3))){
var inst_54884 = (state_54886[(2)]);
var state_54886__$1 = state_54886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54886__$1,inst_54884);
} else {
if((state_val_54887 === (12))){
var inst_54865 = (state_54886[(2)]);
var inst_54866 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_54865);
var inst_54867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54868 = [inst_54865];
var inst_54869 = (new cljs.core.PersistentVector(null,1,(5),inst_54867,inst_54868,null));
var inst_54870 = cljs.core.count(inst_54869);
var inst_54871 = ((9) + inst_54870);
var inst_54872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54873 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54874 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54875 = [inst_54865];
var inst_54876 = (new cljs.core.PersistentVector(null,1,(5),inst_54874,inst_54875,null));
var inst_54877 = ["hash-set",inst_54876,inst_54866];
var inst_54878 = cljs.core.PersistentHashMap.fromArrays(inst_54873,inst_54877);
var inst_54879 = [inst_54878,inst_54871];
var inst_54880 = (new cljs.core.PersistentVector(null,2,(5),inst_54872,inst_54879,null));
var inst_54881 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54880);
var _ = (function (){var statearr_54894 = state_54886;
(statearr_54894[(4)] = cljs.core.rest((state_54886[(4)])));

return statearr_54894;
})();
var state_54886__$1 = (function (){var statearr_54895 = state_54886;
(statearr_54895[(9)] = inst_54881);

return statearr_54895;
})();
var statearr_54896_54920 = state_54886__$1;
(statearr_54896_54920[(2)] = inst_54866);

(statearr_54896_54920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54887 === (2))){
var _ = (function (){var statearr_54897 = state_54886;
(statearr_54897[(4)] = cljs.core.cons((5),(state_54886[(4)])));

return statearr_54897;
})();
var inst_54849 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54886__$1 = state_54886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54886__$1,(6),inst_54849);
} else {
if((state_val_54887 === (11))){
var inst_54852 = (state_54886[(7)]);
var state_54886__$1 = state_54886;
var statearr_54899_54921 = state_54886__$1;
(statearr_54899_54921[(2)] = inst_54852);

(statearr_54899_54921[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54887 === (9))){
var inst_54860 = (state_54886[(2)]);
var state_54886__$1 = state_54886;
if(cljs.core.truth_(inst_54860)){
var statearr_54900_54922 = state_54886__$1;
(statearr_54900_54922[(1)] = (10));

} else {
var statearr_54901_54923 = state_54886__$1;
(statearr_54901_54923[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54887 === (5))){
var _ = (function (){var statearr_54902 = state_54886;
(statearr_54902[(4)] = cljs.core.rest((state_54886[(4)])));

return statearr_54902;
})();
var state_54886__$1 = state_54886;
var ex54898 = (state_54886__$1[(2)]);
var statearr_54903_54924 = state_54886__$1;
(statearr_54903_54924[(5)] = ex54898);


if((ex54898 instanceof Error)){
var statearr_54904_54925 = state_54886__$1;
(statearr_54904_54925[(1)] = (4));

(statearr_54904_54925[(5)] = null);

} else {
throw ex54898;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54887 === (10))){
var inst_54852 = (state_54886[(7)]);
var inst_54862 = cljs.core.first(inst_54852);
var state_54886__$1 = state_54886;
var statearr_54905_54926 = state_54886__$1;
(statearr_54905_54926[(2)] = inst_54862);

(statearr_54905_54926[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54887 === (8))){
var inst_54854 = (state_54886[(8)]);
var state_54886__$1 = state_54886;
var statearr_54906_54927 = state_54886__$1;
(statearr_54906_54927[(2)] = inst_54854);

(statearr_54906_54927[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54907 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54907[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54907[(1)] = (1));

return statearr_54907;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54886){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54886);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54908){var ex__2730__auto__ = e54908;
var statearr_54909_54928 = state_54886;
(statearr_54909_54928[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54886[(4)]))){
var statearr_54910_54929 = state_54886;
(statearr_54910_54929[(1)] = cljs.core.first((state_54886[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54930 = state_54886;
state_54886 = G__54930;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54886){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54911 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54911[(6)] = c__2749__auto__);

return statearr_54911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq54841){
var G__54842 = cljs.core.first(seq54841);
var seq54841__$1 = cljs.core.next(seq54841);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54842,seq54841__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54980 = arguments.length;
var i__4865__auto___54981 = (0);
while(true){
if((i__4865__auto___54981 < len__4864__auto___54980)){
args__4870__auto__.push((arguments[i__4865__auto___54981]));

var G__54982 = (i__4865__auto___54981 + (1));
i__4865__auto___54981 = G__54982;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54963){
var state_val_54964 = (state_54963[(1)]);
if((state_val_54964 === (1))){
var state_54963__$1 = state_54963;
var statearr_54965_54983 = state_54963__$1;
(statearr_54965_54983[(2)] = null);

(statearr_54965_54983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54964 === (2))){
var _ = (function (){var statearr_54966 = state_54963;
(statearr_54966[(4)] = cljs.core.cons((5),(state_54963[(4)])));

return statearr_54966;
})();
var inst_54939 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54963__$1 = state_54963;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54963__$1,(6),inst_54939);
} else {
if((state_val_54964 === (3))){
var inst_54961 = (state_54963[(2)]);
var state_54963__$1 = state_54963;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54963__$1,inst_54961);
} else {
if((state_val_54964 === (4))){
var inst_54933 = (state_54963[(2)]);
var state_54963__$1 = state_54963;
var statearr_54968_54984 = state_54963__$1;
(statearr_54968_54984[(2)] = inst_54933);

(statearr_54968_54984[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54964 === (5))){
var _ = (function (){var statearr_54969 = state_54963;
(statearr_54969[(4)] = cljs.core.rest((state_54963[(4)])));

return statearr_54969;
})();
var state_54963__$1 = state_54963;
var ex54967 = (state_54963__$1[(2)]);
var statearr_54970_54985 = state_54963__$1;
(statearr_54970_54985[(5)] = ex54967);


if((ex54967 instanceof Error)){
var statearr_54971_54986 = state_54963__$1;
(statearr_54971_54986[(1)] = (4));

(statearr_54971_54986[(5)] = null);

} else {
throw ex54967;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54964 === (6))){
var inst_54941 = (state_54963[(2)]);
var inst_54942 = fluree.db.util.async.throw_err(inst_54941);
var inst_54943 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_54942);
var inst_54944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54945 = [inst_54942];
var inst_54946 = (new cljs.core.PersistentVector(null,1,(5),inst_54944,inst_54945,null));
var inst_54947 = cljs.core.count(inst_54946);
var inst_54948 = ((9) + inst_54947);
var inst_54949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54950 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54952 = [inst_54942];
var inst_54953 = (new cljs.core.PersistentVector(null,1,(5),inst_54951,inst_54952,null));
var inst_54954 = ["==",inst_54953,inst_54943];
var inst_54955 = cljs.core.PersistentHashMap.fromArrays(inst_54950,inst_54954);
var inst_54956 = [inst_54955,inst_54948];
var inst_54957 = (new cljs.core.PersistentVector(null,2,(5),inst_54949,inst_54956,null));
var inst_54958 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54957);
var _ = (function (){var statearr_54972 = state_54963;
(statearr_54972[(4)] = cljs.core.rest((state_54963[(4)])));

return statearr_54972;
})();
var state_54963__$1 = (function (){var statearr_54973 = state_54963;
(statearr_54973[(7)] = inst_54958);

return statearr_54973;
})();
var statearr_54974_54987 = state_54963__$1;
(statearr_54974_54987[(2)] = inst_54943);

(statearr_54974_54987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54975 = [null,null,null,null,null,null,null,null];
(statearr_54975[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54975[(1)] = (1));

return statearr_54975;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54963){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54963);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54976){var ex__2730__auto__ = e54976;
var statearr_54977_54988 = state_54963;
(statearr_54977_54988[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54963[(4)]))){
var statearr_54978_54989 = state_54963;
(statearr_54978_54989[(1)] = cljs.core.first((state_54963[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54990 = state_54963;
state_54963 = G__54990;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54963){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54979 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54979[(6)] = c__2749__auto__);

return statearr_54979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq54931){
var G__54932 = cljs.core.first(seq54931);
var seq54931__$1 = cljs.core.next(seq54931);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54932,seq54931__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55040 = arguments.length;
var i__4865__auto___55041 = (0);
while(true){
if((i__4865__auto___55041 < len__4864__auto___55040)){
args__4870__auto__.push((arguments[i__4865__auto___55041]));

var G__55042 = (i__4865__auto___55041 + (1));
i__4865__auto___55041 = G__55042;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55023){
var state_val_55024 = (state_55023[(1)]);
if((state_val_55024 === (1))){
var state_55023__$1 = state_55023;
var statearr_55025_55043 = state_55023__$1;
(statearr_55025_55043[(2)] = null);

(statearr_55025_55043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55024 === (2))){
var _ = (function (){var statearr_55026 = state_55023;
(statearr_55026[(4)] = cljs.core.cons((5),(state_55023[(4)])));

return statearr_55026;
})();
var inst_54999 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55023__$1 = state_55023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55023__$1,(6),inst_54999);
} else {
if((state_val_55024 === (3))){
var inst_55021 = (state_55023[(2)]);
var state_55023__$1 = state_55023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55023__$1,inst_55021);
} else {
if((state_val_55024 === (4))){
var inst_54993 = (state_55023[(2)]);
var state_55023__$1 = state_55023;
var statearr_55028_55044 = state_55023__$1;
(statearr_55028_55044[(2)] = inst_54993);

(statearr_55028_55044[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55024 === (5))){
var _ = (function (){var statearr_55029 = state_55023;
(statearr_55029[(4)] = cljs.core.rest((state_55023[(4)])));

return statearr_55029;
})();
var state_55023__$1 = state_55023;
var ex55027 = (state_55023__$1[(2)]);
var statearr_55030_55045 = state_55023__$1;
(statearr_55030_55045[(5)] = ex55027);


if((ex55027 instanceof Error)){
var statearr_55031_55046 = state_55023__$1;
(statearr_55031_55046[(1)] = (4));

(statearr_55031_55046[(5)] = null);

} else {
throw ex55027;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55024 === (6))){
var inst_55001 = (state_55023[(2)]);
var inst_55002 = fluree.db.util.async.throw_err(inst_55001);
var inst_55003 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_55002);
var inst_55004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55005 = [inst_55002];
var inst_55006 = (new cljs.core.PersistentVector(null,1,(5),inst_55004,inst_55005,null));
var inst_55007 = cljs.core.count(inst_55006);
var inst_55008 = ((9) + inst_55007);
var inst_55009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55010 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55012 = [inst_55002];
var inst_55013 = (new cljs.core.PersistentVector(null,1,(5),inst_55011,inst_55012,null));
var inst_55014 = [">",inst_55013,inst_55003];
var inst_55015 = cljs.core.PersistentHashMap.fromArrays(inst_55010,inst_55014);
var inst_55016 = [inst_55015,inst_55008];
var inst_55017 = (new cljs.core.PersistentVector(null,2,(5),inst_55009,inst_55016,null));
var inst_55018 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55017);
var _ = (function (){var statearr_55032 = state_55023;
(statearr_55032[(4)] = cljs.core.rest((state_55023[(4)])));

return statearr_55032;
})();
var state_55023__$1 = (function (){var statearr_55033 = state_55023;
(statearr_55033[(7)] = inst_55018);

return statearr_55033;
})();
var statearr_55034_55047 = state_55023__$1;
(statearr_55034_55047[(2)] = inst_55003);

(statearr_55034_55047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55035 = [null,null,null,null,null,null,null,null];
(statearr_55035[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55035[(1)] = (1));

return statearr_55035;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55023){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55023);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55036){var ex__2730__auto__ = e55036;
var statearr_55037_55048 = state_55023;
(statearr_55037_55048[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55023[(4)]))){
var statearr_55038_55049 = state_55023;
(statearr_55038_55049[(1)] = cljs.core.first((state_55023[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55050 = state_55023;
state_55023 = G__55050;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55023){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55039 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55039[(6)] = c__2749__auto__);

return statearr_55039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq54991){
var G__54992 = cljs.core.first(seq54991);
var seq54991__$1 = cljs.core.next(seq54991);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54992,seq54991__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55100 = arguments.length;
var i__4865__auto___55101 = (0);
while(true){
if((i__4865__auto___55101 < len__4864__auto___55100)){
args__4870__auto__.push((arguments[i__4865__auto___55101]));

var G__55102 = (i__4865__auto___55101 + (1));
i__4865__auto___55101 = G__55102;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55083){
var state_val_55084 = (state_55083[(1)]);
if((state_val_55084 === (1))){
var state_55083__$1 = state_55083;
var statearr_55085_55103 = state_55083__$1;
(statearr_55085_55103[(2)] = null);

(statearr_55085_55103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55084 === (2))){
var _ = (function (){var statearr_55086 = state_55083;
(statearr_55086[(4)] = cljs.core.cons((5),(state_55083[(4)])));

return statearr_55086;
})();
var inst_55059 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55083__$1 = state_55083;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55083__$1,(6),inst_55059);
} else {
if((state_val_55084 === (3))){
var inst_55081 = (state_55083[(2)]);
var state_55083__$1 = state_55083;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55083__$1,inst_55081);
} else {
if((state_val_55084 === (4))){
var inst_55053 = (state_55083[(2)]);
var state_55083__$1 = state_55083;
var statearr_55088_55104 = state_55083__$1;
(statearr_55088_55104[(2)] = inst_55053);

(statearr_55088_55104[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55084 === (5))){
var _ = (function (){var statearr_55089 = state_55083;
(statearr_55089[(4)] = cljs.core.rest((state_55083[(4)])));

return statearr_55089;
})();
var state_55083__$1 = state_55083;
var ex55087 = (state_55083__$1[(2)]);
var statearr_55090_55105 = state_55083__$1;
(statearr_55090_55105[(5)] = ex55087);


if((ex55087 instanceof Error)){
var statearr_55091_55106 = state_55083__$1;
(statearr_55091_55106[(1)] = (4));

(statearr_55091_55106[(5)] = null);

} else {
throw ex55087;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55084 === (6))){
var inst_55061 = (state_55083[(2)]);
var inst_55062 = fluree.db.util.async.throw_err(inst_55061);
var inst_55063 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_55062);
var inst_55064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55065 = [inst_55062];
var inst_55066 = (new cljs.core.PersistentVector(null,1,(5),inst_55064,inst_55065,null));
var inst_55067 = cljs.core.count(inst_55066);
var inst_55068 = ((9) + inst_55067);
var inst_55069 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55070 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55072 = [inst_55062];
var inst_55073 = (new cljs.core.PersistentVector(null,1,(5),inst_55071,inst_55072,null));
var inst_55074 = ["<",inst_55073,inst_55063];
var inst_55075 = cljs.core.PersistentHashMap.fromArrays(inst_55070,inst_55074);
var inst_55076 = [inst_55075,inst_55068];
var inst_55077 = (new cljs.core.PersistentVector(null,2,(5),inst_55069,inst_55076,null));
var inst_55078 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55077);
var _ = (function (){var statearr_55092 = state_55083;
(statearr_55092[(4)] = cljs.core.rest((state_55083[(4)])));

return statearr_55092;
})();
var state_55083__$1 = (function (){var statearr_55093 = state_55083;
(statearr_55093[(7)] = inst_55078);

return statearr_55093;
})();
var statearr_55094_55107 = state_55083__$1;
(statearr_55094_55107[(2)] = inst_55063);

(statearr_55094_55107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55095 = [null,null,null,null,null,null,null,null];
(statearr_55095[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55095[(1)] = (1));

return statearr_55095;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55083){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55083);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55096){var ex__2730__auto__ = e55096;
var statearr_55097_55108 = state_55083;
(statearr_55097_55108[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55083[(4)]))){
var statearr_55098_55109 = state_55083;
(statearr_55098_55109[(1)] = cljs.core.first((state_55083[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55110 = state_55083;
state_55083 = G__55110;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55083){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55099 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55099[(6)] = c__2749__auto__);

return statearr_55099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq55051){
var G__55052 = cljs.core.first(seq55051);
var seq55051__$1 = cljs.core.next(seq55051);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55052,seq55051__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55160 = arguments.length;
var i__4865__auto___55161 = (0);
while(true){
if((i__4865__auto___55161 < len__4864__auto___55160)){
args__4870__auto__.push((arguments[i__4865__auto___55161]));

var G__55162 = (i__4865__auto___55161 + (1));
i__4865__auto___55161 = G__55162;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55143){
var state_val_55144 = (state_55143[(1)]);
if((state_val_55144 === (1))){
var state_55143__$1 = state_55143;
var statearr_55145_55163 = state_55143__$1;
(statearr_55145_55163[(2)] = null);

(statearr_55145_55163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55144 === (2))){
var _ = (function (){var statearr_55146 = state_55143;
(statearr_55146[(4)] = cljs.core.cons((5),(state_55143[(4)])));

return statearr_55146;
})();
var inst_55119 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55143__$1 = state_55143;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55143__$1,(6),inst_55119);
} else {
if((state_val_55144 === (3))){
var inst_55141 = (state_55143[(2)]);
var state_55143__$1 = state_55143;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55143__$1,inst_55141);
} else {
if((state_val_55144 === (4))){
var inst_55113 = (state_55143[(2)]);
var state_55143__$1 = state_55143;
var statearr_55148_55164 = state_55143__$1;
(statearr_55148_55164[(2)] = inst_55113);

(statearr_55148_55164[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55144 === (5))){
var _ = (function (){var statearr_55149 = state_55143;
(statearr_55149[(4)] = cljs.core.rest((state_55143[(4)])));

return statearr_55149;
})();
var state_55143__$1 = state_55143;
var ex55147 = (state_55143__$1[(2)]);
var statearr_55150_55165 = state_55143__$1;
(statearr_55150_55165[(5)] = ex55147);


if((ex55147 instanceof Error)){
var statearr_55151_55166 = state_55143__$1;
(statearr_55151_55166[(1)] = (4));

(statearr_55151_55166[(5)] = null);

} else {
throw ex55147;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55144 === (6))){
var inst_55121 = (state_55143[(2)]);
var inst_55122 = fluree.db.util.async.throw_err(inst_55121);
var inst_55123 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_55122);
var inst_55124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55125 = [inst_55122];
var inst_55126 = (new cljs.core.PersistentVector(null,1,(5),inst_55124,inst_55125,null));
var inst_55127 = cljs.core.count(inst_55126);
var inst_55128 = ((9) + inst_55127);
var inst_55129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55130 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55132 = [inst_55122];
var inst_55133 = (new cljs.core.PersistentVector(null,1,(5),inst_55131,inst_55132,null));
var inst_55134 = ["<=",inst_55133,inst_55123];
var inst_55135 = cljs.core.PersistentHashMap.fromArrays(inst_55130,inst_55134);
var inst_55136 = [inst_55135,inst_55128];
var inst_55137 = (new cljs.core.PersistentVector(null,2,(5),inst_55129,inst_55136,null));
var inst_55138 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55137);
var _ = (function (){var statearr_55152 = state_55143;
(statearr_55152[(4)] = cljs.core.rest((state_55143[(4)])));

return statearr_55152;
})();
var state_55143__$1 = (function (){var statearr_55153 = state_55143;
(statearr_55153[(7)] = inst_55138);

return statearr_55153;
})();
var statearr_55154_55167 = state_55143__$1;
(statearr_55154_55167[(2)] = inst_55123);

(statearr_55154_55167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55155 = [null,null,null,null,null,null,null,null];
(statearr_55155[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55155[(1)] = (1));

return statearr_55155;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55143){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55143);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55156){var ex__2730__auto__ = e55156;
var statearr_55157_55168 = state_55143;
(statearr_55157_55168[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55143[(4)]))){
var statearr_55158_55169 = state_55143;
(statearr_55158_55169[(1)] = cljs.core.first((state_55143[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55170 = state_55143;
state_55143 = G__55170;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55143){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55143);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55159 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55159[(6)] = c__2749__auto__);

return statearr_55159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq55111){
var G__55112 = cljs.core.first(seq55111);
var seq55111__$1 = cljs.core.next(seq55111);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55112,seq55111__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55220 = arguments.length;
var i__4865__auto___55221 = (0);
while(true){
if((i__4865__auto___55221 < len__4864__auto___55220)){
args__4870__auto__.push((arguments[i__4865__auto___55221]));

var G__55222 = (i__4865__auto___55221 + (1));
i__4865__auto___55221 = G__55222;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55203){
var state_val_55204 = (state_55203[(1)]);
if((state_val_55204 === (1))){
var state_55203__$1 = state_55203;
var statearr_55205_55223 = state_55203__$1;
(statearr_55205_55223[(2)] = null);

(statearr_55205_55223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (2))){
var _ = (function (){var statearr_55206 = state_55203;
(statearr_55206[(4)] = cljs.core.cons((5),(state_55203[(4)])));

return statearr_55206;
})();
var inst_55179 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55203__$1 = state_55203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55203__$1,(6),inst_55179);
} else {
if((state_val_55204 === (3))){
var inst_55201 = (state_55203[(2)]);
var state_55203__$1 = state_55203;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55203__$1,inst_55201);
} else {
if((state_val_55204 === (4))){
var inst_55173 = (state_55203[(2)]);
var state_55203__$1 = state_55203;
var statearr_55208_55224 = state_55203__$1;
(statearr_55208_55224[(2)] = inst_55173);

(statearr_55208_55224[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (5))){
var _ = (function (){var statearr_55209 = state_55203;
(statearr_55209[(4)] = cljs.core.rest((state_55203[(4)])));

return statearr_55209;
})();
var state_55203__$1 = state_55203;
var ex55207 = (state_55203__$1[(2)]);
var statearr_55210_55225 = state_55203__$1;
(statearr_55210_55225[(5)] = ex55207);


if((ex55207 instanceof Error)){
var statearr_55211_55226 = state_55203__$1;
(statearr_55211_55226[(1)] = (4));

(statearr_55211_55226[(5)] = null);

} else {
throw ex55207;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (6))){
var inst_55181 = (state_55203[(2)]);
var inst_55182 = fluree.db.util.async.throw_err(inst_55181);
var inst_55183 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_55182);
var inst_55184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55185 = [inst_55182];
var inst_55186 = (new cljs.core.PersistentVector(null,1,(5),inst_55184,inst_55185,null));
var inst_55187 = cljs.core.count(inst_55186);
var inst_55188 = ((9) + inst_55187);
var inst_55189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55190 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55192 = [inst_55182];
var inst_55193 = (new cljs.core.PersistentVector(null,1,(5),inst_55191,inst_55192,null));
var inst_55194 = [">=",inst_55193,inst_55183];
var inst_55195 = cljs.core.PersistentHashMap.fromArrays(inst_55190,inst_55194);
var inst_55196 = [inst_55195,inst_55188];
var inst_55197 = (new cljs.core.PersistentVector(null,2,(5),inst_55189,inst_55196,null));
var inst_55198 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55197);
var _ = (function (){var statearr_55212 = state_55203;
(statearr_55212[(4)] = cljs.core.rest((state_55203[(4)])));

return statearr_55212;
})();
var state_55203__$1 = (function (){var statearr_55213 = state_55203;
(statearr_55213[(7)] = inst_55198);

return statearr_55213;
})();
var statearr_55214_55227 = state_55203__$1;
(statearr_55214_55227[(2)] = inst_55183);

(statearr_55214_55227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55215 = [null,null,null,null,null,null,null,null];
(statearr_55215[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55215[(1)] = (1));

return statearr_55215;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55203){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55203);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55216){var ex__2730__auto__ = e55216;
var statearr_55217_55228 = state_55203;
(statearr_55217_55228[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55203[(4)]))){
var statearr_55218_55229 = state_55203;
(statearr_55218_55229[(1)] = cljs.core.first((state_55203[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55230 = state_55203;
state_55203 = G__55230;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55203){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55219 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55219[(6)] = c__2749__auto__);

return statearr_55219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq55171){
var G__55172 = cljs.core.first(seq55171);
var seq55171__$1 = cljs.core.next(seq55171);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55172,seq55171__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55280 = arguments.length;
var i__4865__auto___55281 = (0);
while(true){
if((i__4865__auto___55281 < len__4864__auto___55280)){
args__4870__auto__.push((arguments[i__4865__auto___55281]));

var G__55282 = (i__4865__auto___55281 + (1));
i__4865__auto___55281 = G__55282;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55263){
var state_val_55264 = (state_55263[(1)]);
if((state_val_55264 === (1))){
var state_55263__$1 = state_55263;
var statearr_55265_55283 = state_55263__$1;
(statearr_55265_55283[(2)] = null);

(statearr_55265_55283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55264 === (2))){
var _ = (function (){var statearr_55266 = state_55263;
(statearr_55266[(4)] = cljs.core.cons((5),(state_55263[(4)])));

return statearr_55266;
})();
var inst_55239 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55263__$1 = state_55263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55263__$1,(6),inst_55239);
} else {
if((state_val_55264 === (3))){
var inst_55261 = (state_55263[(2)]);
var state_55263__$1 = state_55263;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55263__$1,inst_55261);
} else {
if((state_val_55264 === (4))){
var inst_55233 = (state_55263[(2)]);
var state_55263__$1 = state_55263;
var statearr_55268_55284 = state_55263__$1;
(statearr_55268_55284[(2)] = inst_55233);

(statearr_55268_55284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55264 === (5))){
var _ = (function (){var statearr_55269 = state_55263;
(statearr_55269[(4)] = cljs.core.rest((state_55263[(4)])));

return statearr_55269;
})();
var state_55263__$1 = state_55263;
var ex55267 = (state_55263__$1[(2)]);
var statearr_55270_55285 = state_55263__$1;
(statearr_55270_55285[(5)] = ex55267);


if((ex55267 instanceof Error)){
var statearr_55271_55286 = state_55263__$1;
(statearr_55271_55286[(1)] = (4));

(statearr_55271_55286[(5)] = null);

} else {
throw ex55267;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55264 === (6))){
var inst_55241 = (state_55263[(2)]);
var inst_55242 = fluree.db.util.async.throw_err(inst_55241);
var inst_55243 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_55242);
var inst_55244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55245 = [inst_55242];
var inst_55246 = (new cljs.core.PersistentVector(null,1,(5),inst_55244,inst_55245,null));
var inst_55247 = cljs.core.count(inst_55246);
var inst_55248 = ((9) + inst_55247);
var inst_55249 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55250 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55252 = [inst_55242];
var inst_55253 = (new cljs.core.PersistentVector(null,1,(5),inst_55251,inst_55252,null));
var inst_55254 = ["not=",inst_55253,inst_55243];
var inst_55255 = cljs.core.PersistentHashMap.fromArrays(inst_55250,inst_55254);
var inst_55256 = [inst_55255,inst_55248];
var inst_55257 = (new cljs.core.PersistentVector(null,2,(5),inst_55249,inst_55256,null));
var inst_55258 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55257);
var _ = (function (){var statearr_55272 = state_55263;
(statearr_55272[(4)] = cljs.core.rest((state_55263[(4)])));

return statearr_55272;
})();
var state_55263__$1 = (function (){var statearr_55273 = state_55263;
(statearr_55273[(7)] = inst_55258);

return statearr_55273;
})();
var statearr_55274_55287 = state_55263__$1;
(statearr_55274_55287[(2)] = inst_55243);

(statearr_55274_55287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55275 = [null,null,null,null,null,null,null,null];
(statearr_55275[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55275[(1)] = (1));

return statearr_55275;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55263){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55263);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55276){var ex__2730__auto__ = e55276;
var statearr_55277_55288 = state_55263;
(statearr_55277_55288[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55263[(4)]))){
var statearr_55278_55289 = state_55263;
(statearr_55278_55289[(1)] = cljs.core.first((state_55263[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55290 = state_55263;
state_55263 = G__55290;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55263){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55279 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55279[(6)] = c__2749__auto__);

return statearr_55279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq55231){
var G__55232 = cljs.core.first(seq55231);
var seq55231__$1 = cljs.core.next(seq55231);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55232,seq55231__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55340 = arguments.length;
var i__4865__auto___55341 = (0);
while(true){
if((i__4865__auto___55341 < len__4864__auto___55340)){
args__4870__auto__.push((arguments[i__4865__auto___55341]));

var G__55342 = (i__4865__auto___55341 + (1));
i__4865__auto___55341 = G__55342;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55323){
var state_val_55324 = (state_55323[(1)]);
if((state_val_55324 === (1))){
var state_55323__$1 = state_55323;
var statearr_55325_55343 = state_55323__$1;
(statearr_55325_55343[(2)] = null);

(statearr_55325_55343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55324 === (2))){
var _ = (function (){var statearr_55326 = state_55323;
(statearr_55326[(4)] = cljs.core.cons((5),(state_55323[(4)])));

return statearr_55326;
})();
var inst_55299 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55323__$1 = state_55323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55323__$1,(6),inst_55299);
} else {
if((state_val_55324 === (3))){
var inst_55321 = (state_55323[(2)]);
var state_55323__$1 = state_55323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55323__$1,inst_55321);
} else {
if((state_val_55324 === (4))){
var inst_55293 = (state_55323[(2)]);
var state_55323__$1 = state_55323;
var statearr_55328_55344 = state_55323__$1;
(statearr_55328_55344[(2)] = inst_55293);

(statearr_55328_55344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55324 === (5))){
var _ = (function (){var statearr_55329 = state_55323;
(statearr_55329[(4)] = cljs.core.rest((state_55323[(4)])));

return statearr_55329;
})();
var state_55323__$1 = state_55323;
var ex55327 = (state_55323__$1[(2)]);
var statearr_55330_55345 = state_55323__$1;
(statearr_55330_55345[(5)] = ex55327);


if((ex55327 instanceof Error)){
var statearr_55331_55346 = state_55323__$1;
(statearr_55331_55346[(1)] = (4));

(statearr_55331_55346[(5)] = null);

} else {
throw ex55327;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55324 === (6))){
var inst_55301 = (state_55323[(2)]);
var inst_55302 = fluree.db.util.async.throw_err(inst_55301);
var inst_55303 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_55302);
var inst_55304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55305 = [inst_55302];
var inst_55306 = (new cljs.core.PersistentVector(null,1,(5),inst_55304,inst_55305,null));
var inst_55307 = cljs.core.count(inst_55306);
var inst_55308 = ((9) + inst_55307);
var inst_55309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55310 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55312 = [inst_55302];
var inst_55313 = (new cljs.core.PersistentVector(null,1,(5),inst_55311,inst_55312,null));
var inst_55314 = ["max",inst_55313,inst_55303];
var inst_55315 = cljs.core.PersistentHashMap.fromArrays(inst_55310,inst_55314);
var inst_55316 = [inst_55315,inst_55308];
var inst_55317 = (new cljs.core.PersistentVector(null,2,(5),inst_55309,inst_55316,null));
var inst_55318 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55317);
var _ = (function (){var statearr_55332 = state_55323;
(statearr_55332[(4)] = cljs.core.rest((state_55323[(4)])));

return statearr_55332;
})();
var state_55323__$1 = (function (){var statearr_55333 = state_55323;
(statearr_55333[(7)] = inst_55318);

return statearr_55333;
})();
var statearr_55334_55347 = state_55323__$1;
(statearr_55334_55347[(2)] = inst_55303);

(statearr_55334_55347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55335 = [null,null,null,null,null,null,null,null];
(statearr_55335[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55335[(1)] = (1));

return statearr_55335;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55323){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55323);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55336){var ex__2730__auto__ = e55336;
var statearr_55337_55348 = state_55323;
(statearr_55337_55348[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55323[(4)]))){
var statearr_55338_55349 = state_55323;
(statearr_55338_55349[(1)] = cljs.core.first((state_55323[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55350 = state_55323;
state_55323 = G__55350;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55323){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55339 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55339[(6)] = c__2749__auto__);

return statearr_55339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq55291){
var G__55292 = cljs.core.first(seq55291);
var seq55291__$1 = cljs.core.next(seq55291);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55292,seq55291__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55400 = arguments.length;
var i__4865__auto___55401 = (0);
while(true){
if((i__4865__auto___55401 < len__4864__auto___55400)){
args__4870__auto__.push((arguments[i__4865__auto___55401]));

var G__55402 = (i__4865__auto___55401 + (1));
i__4865__auto___55401 = G__55402;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55383){
var state_val_55384 = (state_55383[(1)]);
if((state_val_55384 === (1))){
var state_55383__$1 = state_55383;
var statearr_55385_55403 = state_55383__$1;
(statearr_55385_55403[(2)] = null);

(statearr_55385_55403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55384 === (2))){
var _ = (function (){var statearr_55386 = state_55383;
(statearr_55386[(4)] = cljs.core.cons((5),(state_55383[(4)])));

return statearr_55386;
})();
var inst_55359 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55383__$1 = state_55383;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55383__$1,(6),inst_55359);
} else {
if((state_val_55384 === (3))){
var inst_55381 = (state_55383[(2)]);
var state_55383__$1 = state_55383;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55383__$1,inst_55381);
} else {
if((state_val_55384 === (4))){
var inst_55353 = (state_55383[(2)]);
var state_55383__$1 = state_55383;
var statearr_55388_55404 = state_55383__$1;
(statearr_55388_55404[(2)] = inst_55353);

(statearr_55388_55404[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55384 === (5))){
var _ = (function (){var statearr_55389 = state_55383;
(statearr_55389[(4)] = cljs.core.rest((state_55383[(4)])));

return statearr_55389;
})();
var state_55383__$1 = state_55383;
var ex55387 = (state_55383__$1[(2)]);
var statearr_55390_55405 = state_55383__$1;
(statearr_55390_55405[(5)] = ex55387);


if((ex55387 instanceof Error)){
var statearr_55391_55406 = state_55383__$1;
(statearr_55391_55406[(1)] = (4));

(statearr_55391_55406[(5)] = null);

} else {
throw ex55387;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55384 === (6))){
var inst_55361 = (state_55383[(2)]);
var inst_55362 = fluree.db.util.async.throw_err(inst_55361);
var inst_55363 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_55362);
var inst_55364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55365 = [inst_55362];
var inst_55366 = (new cljs.core.PersistentVector(null,1,(5),inst_55364,inst_55365,null));
var inst_55367 = cljs.core.count(inst_55366);
var inst_55368 = ((9) + inst_55367);
var inst_55369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55370 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55372 = [inst_55362];
var inst_55373 = (new cljs.core.PersistentVector(null,1,(5),inst_55371,inst_55372,null));
var inst_55374 = ["min",inst_55373,inst_55363];
var inst_55375 = cljs.core.PersistentHashMap.fromArrays(inst_55370,inst_55374);
var inst_55376 = [inst_55375,inst_55368];
var inst_55377 = (new cljs.core.PersistentVector(null,2,(5),inst_55369,inst_55376,null));
var inst_55378 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55377);
var _ = (function (){var statearr_55392 = state_55383;
(statearr_55392[(4)] = cljs.core.rest((state_55383[(4)])));

return statearr_55392;
})();
var state_55383__$1 = (function (){var statearr_55393 = state_55383;
(statearr_55393[(7)] = inst_55378);

return statearr_55393;
})();
var statearr_55394_55407 = state_55383__$1;
(statearr_55394_55407[(2)] = inst_55363);

(statearr_55394_55407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55395 = [null,null,null,null,null,null,null,null];
(statearr_55395[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55395[(1)] = (1));

return statearr_55395;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55383){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55383);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55396){var ex__2730__auto__ = e55396;
var statearr_55397_55408 = state_55383;
(statearr_55397_55408[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55383[(4)]))){
var statearr_55398_55409 = state_55383;
(statearr_55398_55409[(1)] = cljs.core.first((state_55383[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55410 = state_55383;
state_55383 = G__55410;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55383){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55399 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55399[(6)] = c__2749__auto__);

return statearr_55399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq55351){
var G__55352 = cljs.core.first(seq55351);
var seq55351__$1 = cljs.core.next(seq55351);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55352,seq55351__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__55412 = arguments.length;
switch (G__55412) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55457){
var state_val_55458 = (state_55457[(1)]);
if((state_val_55458 === (7))){
var state_55457__$1 = state_55457;
var statearr_55459_55596 = state_55457__$1;
(statearr_55459_55596[(2)] = query_map);

(statearr_55459_55596[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55458 === (1))){
var state_55457__$1 = state_55457;
var statearr_55460_55597 = state_55457__$1;
(statearr_55460_55597[(2)] = null);

(statearr_55460_55597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55458 === (4))){
var inst_55413 = (state_55457[(2)]);
var state_55457__$1 = state_55457;
var statearr_55461_55598 = state_55457__$1;
(statearr_55461_55598[(2)] = inst_55413);

(statearr_55461_55598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55458 === (13))){
var inst_55435 = (state_55457[(7)]);
var inst_55439 = (state_55457[(2)]);
var inst_55440 = fluree.db.util.async.throw_err(inst_55439);
var inst_55441 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55440,(0),null);
var inst_55442 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55440,(1),null);
var inst_55443 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55444 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55445 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55446 = [inst_55435];
var inst_55447 = (new cljs.core.PersistentVector(null,1,(5),inst_55445,inst_55446,null));
var inst_55448 = ["query",inst_55447,inst_55441];
var inst_55449 = cljs.core.PersistentHashMap.fromArrays(inst_55444,inst_55448);
var inst_55450 = [inst_55449,inst_55442];
var inst_55451 = (new cljs.core.PersistentVector(null,2,(5),inst_55443,inst_55450,null));
var inst_55452 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55451);
var _ = (function (){var statearr_55462 = state_55457;
(statearr_55462[(4)] = cljs.core.rest((state_55457[(4)])));

return statearr_55462;
})();
var state_55457__$1 = (function (){var statearr_55463 = state_55457;
(statearr_55463[(8)] = inst_55452);

return statearr_55463;
})();
var statearr_55464_55599 = state_55457__$1;
(statearr_55464_55599[(2)] = inst_55441);

(statearr_55464_55599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55458 === (6))){
var state_55457__$1 = state_55457;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55457__$1,(9),query_map);
} else {
if((state_val_55458 === (3))){
var inst_55455 = (state_55457[(2)]);
var state_55457__$1 = state_55457;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55457__$1,inst_55455);
} else {
if((state_val_55458 === (12))){
var inst_55435 = (state_55457[(7)]);
var inst_55435__$1 = (state_55457[(2)]);
var inst_55436 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55437 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_55436,inst_55435__$1);
var state_55457__$1 = (function (){var statearr_55465 = state_55457;
(statearr_55465[(7)] = inst_55435__$1);

return statearr_55465;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55457__$1,(13),inst_55437);
} else {
if((state_val_55458 === (2))){
var _ = (function (){var statearr_55466 = state_55457;
(statearr_55466[(4)] = cljs.core.cons((5),(state_55457[(4)])));

return statearr_55466;
})();
var inst_55422 = fluree.db.util.async.channel_QMARK_(query_map);
var state_55457__$1 = state_55457;
if(inst_55422){
var statearr_55467_55600 = state_55457__$1;
(statearr_55467_55600[(1)] = (6));

} else {
var statearr_55468_55601 = state_55457__$1;
(statearr_55468_55601[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55458 === (11))){
var inst_55429 = (state_55457[(9)]);
var state_55457__$1 = state_55457;
var statearr_55470_55602 = state_55457__$1;
(statearr_55470_55602[(2)] = inst_55429);

(statearr_55470_55602[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55458 === (9))){
var inst_55425 = (state_55457[(2)]);
var inst_55426 = fluree.db.util.async.throw_err(inst_55425);
var state_55457__$1 = state_55457;
var statearr_55471_55603 = state_55457__$1;
(statearr_55471_55603[(2)] = inst_55426);

(statearr_55471_55603[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55458 === (5))){
var _ = (function (){var statearr_55472 = state_55457;
(statearr_55472[(4)] = cljs.core.rest((state_55457[(4)])));

return statearr_55472;
})();
var state_55457__$1 = state_55457;
var ex55469 = (state_55457__$1[(2)]);
var statearr_55473_55604 = state_55457__$1;
(statearr_55473_55604[(5)] = ex55469);


if((ex55469 instanceof Error)){
var statearr_55474_55605 = state_55457__$1;
(statearr_55474_55605[(1)] = (4));

(statearr_55474_55605[(5)] = null);

} else {
throw ex55469;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55458 === (10))){
var inst_55429 = (state_55457[(9)]);
var inst_55432 = fluree.db.util.json.parse(inst_55429);
var state_55457__$1 = state_55457;
var statearr_55475_55606 = state_55457__$1;
(statearr_55475_55606[(2)] = inst_55432);

(statearr_55475_55606[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55458 === (8))){
var inst_55429 = (state_55457[(9)]);
var inst_55429__$1 = (state_55457[(2)]);
var inst_55430 = typeof inst_55429__$1 === 'string';
var state_55457__$1 = (function (){var statearr_55476 = state_55457;
(statearr_55476[(9)] = inst_55429__$1);

return statearr_55476;
})();
if(cljs.core.truth_(inst_55430)){
var statearr_55477_55607 = state_55457__$1;
(statearr_55477_55607[(1)] = (10));

} else {
var statearr_55478_55608 = state_55457__$1;
(statearr_55478_55608[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55479 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55479[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55479[(1)] = (1));

return statearr_55479;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55457){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55457);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55480){var ex__2730__auto__ = e55480;
var statearr_55481_55609 = state_55457;
(statearr_55481_55609[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55457[(4)]))){
var statearr_55482_55610 = state_55457;
(statearr_55482_55610[(1)] = cljs.core.first((state_55457[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55611 = state_55457;
state_55457 = G__55611;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55457){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55457);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55483 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55483[(6)] = c__2749__auto__);

return statearr_55483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55554){
var state_val_55555 = (state_55554[(1)]);
if((state_val_55555 === (7))){
var state_55554__$1 = state_55554;
var statearr_55556_55612 = state_55554__$1;
(statearr_55556_55612[(2)] = select);

(statearr_55556_55612[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (20))){
var inst_55524 = (state_55554[(2)]);
var inst_55525 = fluree.db.util.async.channel_QMARK_(limit);
var state_55554__$1 = (function (){var statearr_55557 = state_55554;
(statearr_55557[(7)] = inst_55524);

return statearr_55557;
})();
if(inst_55525){
var statearr_55558_55613 = state_55554__$1;
(statearr_55558_55613[(1)] = (22));

} else {
var statearr_55559_55614 = state_55554__$1;
(statearr_55559_55614[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (1))){
var state_55554__$1 = state_55554;
var statearr_55560_55615 = state_55554__$1;
(statearr_55560_55615[(2)] = null);

(statearr_55560_55615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (24))){
var inst_55508 = (state_55554[(8)]);
var inst_55516 = (state_55554[(9)]);
var inst_55524 = (state_55554[(7)]);
var inst_55500 = (state_55554[(10)]);
var inst_55532 = (state_55554[(2)]);
var inst_55533 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55534 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_55533,inst_55500,inst_55508,inst_55516,inst_55524,inst_55532);
var state_55554__$1 = state_55554;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55554__$1,(26),inst_55534);
} else {
if((state_val_55555 === (4))){
var inst_55484 = (state_55554[(2)]);
var state_55554__$1 = state_55554;
var statearr_55561_55616 = state_55554__$1;
(statearr_55561_55616[(2)] = inst_55484);

(statearr_55561_55616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (15))){
var state_55554__$1 = state_55554;
var statearr_55562_55617 = state_55554__$1;
(statearr_55562_55617[(2)] = where);

(statearr_55562_55617[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (21))){
var inst_55520 = (state_55554[(2)]);
var inst_55521 = fluree.db.util.async.throw_err(inst_55520);
var state_55554__$1 = state_55554;
var statearr_55563_55618 = state_55554__$1;
(statearr_55563_55618[(2)] = inst_55521);

(statearr_55563_55618[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (13))){
var inst_55504 = (state_55554[(2)]);
var inst_55505 = fluree.db.util.async.throw_err(inst_55504);
var state_55554__$1 = state_55554;
var statearr_55564_55619 = state_55554__$1;
(statearr_55564_55619[(2)] = inst_55505);

(statearr_55564_55619[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (22))){
var state_55554__$1 = state_55554;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55554__$1,(25),limit);
} else {
if((state_val_55555 === (6))){
var state_55554__$1 = state_55554;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55554__$1,(9),select);
} else {
if((state_val_55555 === (25))){
var inst_55528 = (state_55554[(2)]);
var inst_55529 = fluree.db.util.async.throw_err(inst_55528);
var state_55554__$1 = state_55554;
var statearr_55565_55620 = state_55554__$1;
(statearr_55565_55620[(2)] = inst_55529);

(statearr_55565_55620[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (17))){
var inst_55512 = (state_55554[(2)]);
var inst_55513 = fluree.db.util.async.throw_err(inst_55512);
var state_55554__$1 = state_55554;
var statearr_55566_55621 = state_55554__$1;
(statearr_55566_55621[(2)] = inst_55513);

(statearr_55566_55621[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (3))){
var inst_55552 = (state_55554[(2)]);
var state_55554__$1 = state_55554;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55554__$1,inst_55552);
} else {
if((state_val_55555 === (12))){
var inst_55508 = (state_55554[(2)]);
var inst_55509 = fluree.db.util.async.channel_QMARK_(where);
var state_55554__$1 = (function (){var statearr_55567 = state_55554;
(statearr_55567[(8)] = inst_55508);

return statearr_55567;
})();
if(inst_55509){
var statearr_55568_55622 = state_55554__$1;
(statearr_55568_55622[(1)] = (14));

} else {
var statearr_55569_55623 = state_55554__$1;
(statearr_55569_55623[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (2))){
var _ = (function (){var statearr_55570 = state_55554;
(statearr_55570[(4)] = cljs.core.cons((5),(state_55554[(4)])));

return statearr_55570;
})();
var inst_55493 = fluree.db.util.async.channel_QMARK_(select);
var state_55554__$1 = state_55554;
if(inst_55493){
var statearr_55571_55624 = state_55554__$1;
(statearr_55571_55624[(1)] = (6));

} else {
var statearr_55572_55625 = state_55554__$1;
(statearr_55572_55625[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (23))){
var state_55554__$1 = state_55554;
var statearr_55573_55626 = state_55554__$1;
(statearr_55573_55626[(2)] = limit);

(statearr_55573_55626[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (19))){
var state_55554__$1 = state_55554;
var statearr_55574_55627 = state_55554__$1;
(statearr_55574_55627[(2)] = block);

(statearr_55574_55627[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (11))){
var state_55554__$1 = state_55554;
var statearr_55576_55628 = state_55554__$1;
(statearr_55576_55628[(2)] = from);

(statearr_55576_55628[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (9))){
var inst_55496 = (state_55554[(2)]);
var inst_55497 = fluree.db.util.async.throw_err(inst_55496);
var state_55554__$1 = state_55554;
var statearr_55577_55629 = state_55554__$1;
(statearr_55577_55629[(2)] = inst_55497);

(statearr_55577_55629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (5))){
var _ = (function (){var statearr_55578 = state_55554;
(statearr_55578[(4)] = cljs.core.rest((state_55554[(4)])));

return statearr_55578;
})();
var state_55554__$1 = state_55554;
var ex55575 = (state_55554__$1[(2)]);
var statearr_55579_55630 = state_55554__$1;
(statearr_55579_55630[(5)] = ex55575);


if((ex55575 instanceof Error)){
var statearr_55580_55631 = state_55554__$1;
(statearr_55580_55631[(1)] = (4));

(statearr_55580_55631[(5)] = null);

} else {
throw ex55575;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (14))){
var state_55554__$1 = state_55554;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55554__$1,(17),where);
} else {
if((state_val_55555 === (26))){
var inst_55508 = (state_55554[(8)]);
var inst_55516 = (state_55554[(9)]);
var inst_55524 = (state_55554[(7)]);
var inst_55500 = (state_55554[(10)]);
var inst_55536 = (state_55554[(2)]);
var inst_55537 = fluree.db.util.async.throw_err(inst_55536);
var inst_55538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55537,(0),null);
var inst_55539 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55537,(1),null);
var inst_55540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55541 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55543 = [inst_55500,inst_55508,inst_55516,inst_55524];
var inst_55544 = (new cljs.core.PersistentVector(null,4,(5),inst_55542,inst_55543,null));
var inst_55545 = ["query",inst_55544,inst_55538];
var inst_55546 = cljs.core.PersistentHashMap.fromArrays(inst_55541,inst_55545);
var inst_55547 = [inst_55546,inst_55539];
var inst_55548 = (new cljs.core.PersistentVector(null,2,(5),inst_55540,inst_55547,null));
var inst_55549 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55548);
var _ = (function (){var statearr_55581 = state_55554;
(statearr_55581[(4)] = cljs.core.rest((state_55554[(4)])));

return statearr_55581;
})();
var state_55554__$1 = (function (){var statearr_55582 = state_55554;
(statearr_55582[(11)] = inst_55549);

return statearr_55582;
})();
var statearr_55583_55632 = state_55554__$1;
(statearr_55583_55632[(2)] = inst_55538);

(statearr_55583_55632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (16))){
var inst_55516 = (state_55554[(2)]);
var inst_55517 = fluree.db.util.async.channel_QMARK_(block);
var state_55554__$1 = (function (){var statearr_55584 = state_55554;
(statearr_55584[(9)] = inst_55516);

return statearr_55584;
})();
if(inst_55517){
var statearr_55585_55633 = state_55554__$1;
(statearr_55585_55633[(1)] = (18));

} else {
var statearr_55586_55634 = state_55554__$1;
(statearr_55586_55634[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55555 === (10))){
var state_55554__$1 = state_55554;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55554__$1,(13),from);
} else {
if((state_val_55555 === (18))){
var state_55554__$1 = state_55554;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55554__$1,(21),block);
} else {
if((state_val_55555 === (8))){
var inst_55500 = (state_55554[(2)]);
var inst_55501 = fluree.db.util.async.channel_QMARK_(from);
var state_55554__$1 = (function (){var statearr_55587 = state_55554;
(statearr_55587[(10)] = inst_55500);

return statearr_55587;
})();
if(inst_55501){
var statearr_55588_55635 = state_55554__$1;
(statearr_55588_55635[(1)] = (10));

} else {
var statearr_55589_55636 = state_55554__$1;
(statearr_55589_55636[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55590 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55590[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55590[(1)] = (1));

return statearr_55590;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55554){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55554);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55591){var ex__2730__auto__ = e55591;
var statearr_55592_55637 = state_55554;
(statearr_55592_55637[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55554[(4)]))){
var statearr_55593_55638 = state_55554;
(statearr_55593_55638[(1)] = cljs.core.first((state_55554[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55639 = state_55554;
state_55554 = G__55639;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55554){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55594 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55594[(6)] = c__2749__auto__);

return statearr_55594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55695){
var state_val_55696 = (state_55695[(1)]);
if((state_val_55696 === (7))){
var state_55695__$1 = state_55695;
var statearr_55697_55728 = state_55695__$1;
(statearr_55697_55728[(2)] = startSubject);

(statearr_55697_55728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (1))){
var state_55695__$1 = state_55695;
var statearr_55698_55729 = state_55695__$1;
(statearr_55698_55729[(2)] = null);

(statearr_55698_55729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (4))){
var inst_55640 = (state_55695[(2)]);
var state_55695__$1 = state_55695;
var statearr_55699_55730 = state_55695__$1;
(statearr_55699_55730[(2)] = inst_55640);

(statearr_55699_55730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (15))){
var inst_55672 = (state_55695[(2)]);
var inst_55673 = fluree.db.util.async.throw_err(inst_55672);
var inst_55674 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55673,(0),null);
var inst_55675 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55673,(1),null);
var inst_55676 = cljs.core.empty_QMARK_(inst_55674);
var state_55695__$1 = (function (){var statearr_55700 = state_55695;
(statearr_55700[(7)] = inst_55675);

return statearr_55700;
})();
if(inst_55676){
var statearr_55701_55731 = state_55695__$1;
(statearr_55701_55731[(1)] = (16));

} else {
var statearr_55702_55732 = state_55695__$1;
(statearr_55702_55732[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (13))){
var inst_55660 = (state_55695[(8)]);
var inst_55668 = (state_55695[(9)]);
var inst_55656 = (state_55695[(10)]);
var inst_55668__$1 = (state_55695[(2)]);
var inst_55669 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55670 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_55669,inst_55656,inst_55660,inst_55668__$1);
var state_55695__$1 = (function (){var statearr_55703 = state_55695;
(statearr_55703[(9)] = inst_55668__$1);

return statearr_55703;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55695__$1,(15),inst_55670);
} else {
if((state_val_55696 === (6))){
var state_55695__$1 = state_55695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55695__$1,(9),startSubject);
} else {
if((state_val_55696 === (17))){
var state_55695__$1 = state_55695;
var statearr_55704_55733 = state_55695__$1;
(statearr_55704_55733[(2)] = true);

(statearr_55704_55733[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (3))){
var inst_55693 = (state_55695[(2)]);
var state_55695__$1 = state_55695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55695__$1,inst_55693);
} else {
if((state_val_55696 === (12))){
var state_55695__$1 = state_55695;
var statearr_55705_55734 = state_55695__$1;
(statearr_55705_55734[(2)] = endSubject);

(statearr_55705_55734[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (2))){
var _ = (function (){var statearr_55706 = state_55695;
(statearr_55706[(4)] = cljs.core.cons((5),(state_55695[(4)])));

return statearr_55706;
})();
var inst_55649 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_55695__$1 = state_55695;
if(inst_55649){
var statearr_55707_55735 = state_55695__$1;
(statearr_55707_55735[(1)] = (6));

} else {
var statearr_55708_55736 = state_55695__$1;
(statearr_55708_55736[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (11))){
var state_55695__$1 = state_55695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55695__$1,(14),endSubject);
} else {
if((state_val_55696 === (9))){
var inst_55652 = (state_55695[(2)]);
var inst_55653 = fluree.db.util.async.throw_err(inst_55652);
var state_55695__$1 = state_55695;
var statearr_55710_55737 = state_55695__$1;
(statearr_55710_55737[(2)] = inst_55653);

(statearr_55710_55737[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (5))){
var _ = (function (){var statearr_55711 = state_55695;
(statearr_55711[(4)] = cljs.core.rest((state_55695[(4)])));

return statearr_55711;
})();
var state_55695__$1 = state_55695;
var ex55709 = (state_55695__$1[(2)]);
var statearr_55712_55738 = state_55695__$1;
(statearr_55712_55738[(5)] = ex55709);


if((ex55709 instanceof Error)){
var statearr_55713_55739 = state_55695__$1;
(statearr_55713_55739[(1)] = (4));

(statearr_55713_55739[(5)] = null);

} else {
throw ex55709;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (14))){
var inst_55664 = (state_55695[(2)]);
var inst_55665 = fluree.db.util.async.throw_err(inst_55664);
var state_55695__$1 = state_55695;
var statearr_55714_55740 = state_55695__$1;
(statearr_55714_55740[(2)] = inst_55665);

(statearr_55714_55740[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (16))){
var state_55695__$1 = state_55695;
var statearr_55715_55741 = state_55695__$1;
(statearr_55715_55741[(2)] = false);

(statearr_55715_55741[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (10))){
var inst_55659 = (state_55695[(2)]);
var inst_55660 = fluree.db.util.async.throw_err(inst_55659);
var inst_55661 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_55695__$1 = (function (){var statearr_55716 = state_55695;
(statearr_55716[(8)] = inst_55660);

return statearr_55716;
})();
if(inst_55661){
var statearr_55717_55742 = state_55695__$1;
(statearr_55717_55742[(1)] = (11));

} else {
var statearr_55718_55743 = state_55695__$1;
(statearr_55718_55743[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (18))){
var inst_55675 = (state_55695[(7)]);
var inst_55660 = (state_55695[(8)]);
var inst_55668 = (state_55695[(9)]);
var inst_55656 = (state_55695[(10)]);
var inst_55680 = (state_55695[(2)]);
var inst_55681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55682 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55684 = [inst_55656,inst_55660,inst_55668];
var inst_55685 = (new cljs.core.PersistentVector(null,3,(5),inst_55683,inst_55684,null));
var inst_55686 = ["relationship?",inst_55685,inst_55680];
var inst_55687 = cljs.core.PersistentHashMap.fromArrays(inst_55682,inst_55686);
var inst_55688 = [inst_55687,inst_55675];
var inst_55689 = (new cljs.core.PersistentVector(null,2,(5),inst_55681,inst_55688,null));
var inst_55690 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55689);
var _ = (function (){var statearr_55719 = state_55695;
(statearr_55719[(4)] = cljs.core.rest((state_55695[(4)])));

return statearr_55719;
})();
var state_55695__$1 = (function (){var statearr_55720 = state_55695;
(statearr_55720[(11)] = inst_55690);

return statearr_55720;
})();
var statearr_55721_55744 = state_55695__$1;
(statearr_55721_55744[(2)] = inst_55680);

(statearr_55721_55744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (8))){
var inst_55656 = (state_55695[(2)]);
var inst_55657 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_55695__$1 = (function (){var statearr_55722 = state_55695;
(statearr_55722[(10)] = inst_55656);

return statearr_55722;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55695__$1,(10),inst_55657);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_55723 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55723[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_55723[(1)] = (1));

return statearr_55723;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_55695){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55695);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55724){var ex__2730__auto__ = e55724;
var statearr_55725_55745 = state_55695;
(statearr_55725_55745[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55695[(4)]))){
var statearr_55726_55746 = state_55695;
(statearr_55726_55746[(1)] = cljs.core.first((state_55695[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55747 = state_55695;
state_55695 = G__55747;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = function(state_55695){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_55695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55727 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55727[(6)] = c__2749__auto__);

return statearr_55727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55784){
var state_val_55785 = (state_55784[(1)]);
if((state_val_55785 === (7))){
var state_55784__$1 = state_55784;
var statearr_55786_55806 = state_55784__$1;
(statearr_55786_55806[(2)] = pred_name);

(statearr_55786_55806[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55785 === (1))){
var state_55784__$1 = state_55784;
var statearr_55787_55807 = state_55784__$1;
(statearr_55787_55807[(2)] = null);

(statearr_55787_55807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55785 === (4))){
var inst_55748 = (state_55784[(2)]);
var state_55784__$1 = state_55784;
var statearr_55788_55808 = state_55784__$1;
(statearr_55788_55808[(2)] = inst_55748);

(statearr_55788_55808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55785 === (6))){
var state_55784__$1 = state_55784;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55784__$1,(9),pred_name);
} else {
if((state_val_55785 === (3))){
var inst_55782 = (state_55784[(2)]);
var state_55784__$1 = state_55784;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55784__$1,inst_55782);
} else {
if((state_val_55785 === (2))){
var _ = (function (){var statearr_55790 = state_55784;
(statearr_55790[(4)] = cljs.core.cons((5),(state_55784[(4)])));

return statearr_55790;
})();
var inst_55757 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_55784__$1 = state_55784;
if(inst_55757){
var statearr_55791_55809 = state_55784__$1;
(statearr_55791_55809[(1)] = (6));

} else {
var statearr_55792_55810 = state_55784__$1;
(statearr_55792_55810[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55785 === (9))){
var inst_55760 = (state_55784[(2)]);
var inst_55761 = fluree.db.util.async.throw_err(inst_55760);
var state_55784__$1 = state_55784;
var statearr_55793_55811 = state_55784__$1;
(statearr_55793_55811[(2)] = inst_55761);

(statearr_55793_55811[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55785 === (5))){
var _ = (function (){var statearr_55794 = state_55784;
(statearr_55794[(4)] = cljs.core.rest((state_55784[(4)])));

return statearr_55794;
})();
var state_55784__$1 = state_55784;
var ex55789 = (state_55784__$1[(2)]);
var statearr_55795_55812 = state_55784__$1;
(statearr_55795_55812[(5)] = ex55789);


if((ex55789 instanceof Error)){
var statearr_55796_55813 = state_55784__$1;
(statearr_55796_55813[(1)] = (4));

(statearr_55796_55813[(5)] = null);

} else {
throw ex55789;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55785 === (10))){
var inst_55764 = (state_55784[(7)]);
var inst_55768 = (state_55784[(2)]);
var inst_55769 = fluree.db.util.async.throw_err(inst_55768);
var inst_55770 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55769,(0),null);
var inst_55771 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55769,(1),null);
var inst_55772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55773 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55774 = ["max-pred-val",inst_55764,inst_55770];
var inst_55775 = cljs.core.PersistentHashMap.fromArrays(inst_55773,inst_55774);
var inst_55776 = (inst_55771 + (10));
var inst_55777 = [inst_55775,inst_55776];
var inst_55778 = (new cljs.core.PersistentVector(null,2,(5),inst_55772,inst_55777,null));
var inst_55779 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55778);
var _ = (function (){var statearr_55797 = state_55784;
(statearr_55797[(4)] = cljs.core.rest((state_55784[(4)])));

return statearr_55797;
})();
var state_55784__$1 = (function (){var statearr_55798 = state_55784;
(statearr_55798[(8)] = inst_55779);

return statearr_55798;
})();
var statearr_55799_55814 = state_55784__$1;
(statearr_55799_55814[(2)] = inst_55770);

(statearr_55799_55814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55785 === (8))){
var inst_55764 = (state_55784[(7)]);
var inst_55764__$1 = (state_55784[(2)]);
var inst_55765 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55766 = fluree.db.dbfunctions.internal.max_pred_val(inst_55765,inst_55764__$1,null);
var state_55784__$1 = (function (){var statearr_55800 = state_55784;
(statearr_55800[(7)] = inst_55764__$1);

return statearr_55800;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55784__$1,(10),inst_55766);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_55801 = [null,null,null,null,null,null,null,null,null];
(statearr_55801[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__);

(statearr_55801[(1)] = (1));

return statearr_55801;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1 = (function (state_55784){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55784);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55802){var ex__2730__auto__ = e55802;
var statearr_55803_55815 = state_55784;
(statearr_55803_55815[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55784[(4)]))){
var statearr_55804_55816 = state_55784;
(statearr_55804_55816[(1)] = cljs.core.first((state_55784[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55817 = state_55784;
state_55784 = G__55817;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = function(state_55784){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1.call(this,state_55784);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55805 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55805[(6)] = c__2749__auto__);

return statearr_55805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55844){
var state_val_55845 = (state_55844[(1)]);
if((state_val_55845 === (7))){
var state_55844__$1 = state_55844;
var statearr_55846_55865 = state_55844__$1;
(statearr_55846_55865[(2)] = n);

(statearr_55846_55865[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55845 === (1))){
var state_55844__$1 = state_55844;
var statearr_55847_55866 = state_55844__$1;
(statearr_55847_55866[(2)] = null);

(statearr_55847_55866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55845 === (4))){
var inst_55818 = (state_55844[(2)]);
var state_55844__$1 = state_55844;
var statearr_55848_55867 = state_55844__$1;
(statearr_55848_55867[(2)] = inst_55818);

(statearr_55848_55867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55845 === (6))){
var state_55844__$1 = state_55844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55844__$1,(9),n);
} else {
if((state_val_55845 === (3))){
var inst_55842 = (state_55844[(2)]);
var state_55844__$1 = state_55844;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55844__$1,inst_55842);
} else {
if((state_val_55845 === (2))){
var _ = (function (){var statearr_55850 = state_55844;
(statearr_55850[(4)] = cljs.core.cons((5),(state_55844[(4)])));

return statearr_55850;
})();
var inst_55824 = fluree.db.util.async.channel_QMARK_(n);
var state_55844__$1 = state_55844;
if(inst_55824){
var statearr_55851_55868 = state_55844__$1;
(statearr_55851_55868[(1)] = (6));

} else {
var statearr_55852_55869 = state_55844__$1;
(statearr_55852_55869[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55845 === (9))){
var inst_55827 = (state_55844[(2)]);
var inst_55828 = fluree.db.util.async.throw_err(inst_55827);
var state_55844__$1 = state_55844;
var statearr_55853_55870 = state_55844__$1;
(statearr_55853_55870[(2)] = inst_55828);

(statearr_55853_55870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55845 === (5))){
var _ = (function (){var statearr_55854 = state_55844;
(statearr_55854[(4)] = cljs.core.rest((state_55844[(4)])));

return statearr_55854;
})();
var state_55844__$1 = state_55844;
var ex55849 = (state_55844__$1[(2)]);
var statearr_55855_55871 = state_55844__$1;
(statearr_55855_55871[(5)] = ex55849);


if((ex55849 instanceof Error)){
var statearr_55856_55872 = state_55844__$1;
(statearr_55856_55872[(1)] = (4));

(statearr_55856_55872[(5)] = null);

} else {
throw ex55849;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55845 === (8))){
var inst_55831 = (state_55844[(2)]);
var inst_55832 = fluree.db.dbfunctions.internal.inc(inst_55831);
var inst_55833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55834 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55835 = ["inc",inst_55831,inst_55832];
var inst_55836 = cljs.core.PersistentHashMap.fromArrays(inst_55834,inst_55835);
var inst_55837 = [inst_55836,(10)];
var inst_55838 = (new cljs.core.PersistentVector(null,2,(5),inst_55833,inst_55837,null));
var inst_55839 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55838);
var _ = (function (){var statearr_55857 = state_55844;
(statearr_55857[(4)] = cljs.core.rest((state_55844[(4)])));

return statearr_55857;
})();
var state_55844__$1 = (function (){var statearr_55858 = state_55844;
(statearr_55858[(7)] = inst_55839);

return statearr_55858;
})();
var statearr_55859_55873 = state_55844__$1;
(statearr_55859_55873[(2)] = inst_55832);

(statearr_55859_55873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0 = (function (){
var statearr_55860 = [null,null,null,null,null,null,null,null];
(statearr_55860[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__);

(statearr_55860[(1)] = (1));

return statearr_55860;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1 = (function (state_55844){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55844);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55861){var ex__2730__auto__ = e55861;
var statearr_55862_55874 = state_55844;
(statearr_55862_55874[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55844[(4)]))){
var statearr_55863_55875 = state_55844;
(statearr_55863_55875[(1)] = cljs.core.first((state_55844[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55876 = state_55844;
state_55844 = G__55876;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = function(state_55844){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1.call(this,state_55844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55864 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55864[(6)] = c__2749__auto__);

return statearr_55864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55903){
var state_val_55904 = (state_55903[(1)]);
if((state_val_55904 === (7))){
var state_55903__$1 = state_55903;
var statearr_55905_55924 = state_55903__$1;
(statearr_55905_55924[(2)] = n);

(statearr_55905_55924[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55904 === (1))){
var state_55903__$1 = state_55903;
var statearr_55906_55925 = state_55903__$1;
(statearr_55906_55925[(2)] = null);

(statearr_55906_55925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55904 === (4))){
var inst_55877 = (state_55903[(2)]);
var state_55903__$1 = state_55903;
var statearr_55907_55926 = state_55903__$1;
(statearr_55907_55926[(2)] = inst_55877);

(statearr_55907_55926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55904 === (6))){
var state_55903__$1 = state_55903;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55903__$1,(9),n);
} else {
if((state_val_55904 === (3))){
var inst_55901 = (state_55903[(2)]);
var state_55903__$1 = state_55903;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55903__$1,inst_55901);
} else {
if((state_val_55904 === (2))){
var _ = (function (){var statearr_55909 = state_55903;
(statearr_55909[(4)] = cljs.core.cons((5),(state_55903[(4)])));

return statearr_55909;
})();
var inst_55883 = fluree.db.util.async.channel_QMARK_(n);
var state_55903__$1 = state_55903;
if(inst_55883){
var statearr_55910_55927 = state_55903__$1;
(statearr_55910_55927[(1)] = (6));

} else {
var statearr_55911_55928 = state_55903__$1;
(statearr_55911_55928[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55904 === (9))){
var inst_55886 = (state_55903[(2)]);
var inst_55887 = fluree.db.util.async.throw_err(inst_55886);
var state_55903__$1 = state_55903;
var statearr_55912_55929 = state_55903__$1;
(statearr_55912_55929[(2)] = inst_55887);

(statearr_55912_55929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55904 === (5))){
var _ = (function (){var statearr_55913 = state_55903;
(statearr_55913[(4)] = cljs.core.rest((state_55903[(4)])));

return statearr_55913;
})();
var state_55903__$1 = state_55903;
var ex55908 = (state_55903__$1[(2)]);
var statearr_55914_55930 = state_55903__$1;
(statearr_55914_55930[(5)] = ex55908);


if((ex55908 instanceof Error)){
var statearr_55915_55931 = state_55903__$1;
(statearr_55915_55931[(1)] = (4));

(statearr_55915_55931[(5)] = null);

} else {
throw ex55908;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55904 === (8))){
var inst_55890 = (state_55903[(2)]);
var inst_55891 = fluree.db.dbfunctions.internal.dec(inst_55890);
var inst_55892 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55893 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55894 = ["dec",inst_55890,inst_55891];
var inst_55895 = cljs.core.PersistentHashMap.fromArrays(inst_55893,inst_55894);
var inst_55896 = [inst_55895,(10)];
var inst_55897 = (new cljs.core.PersistentVector(null,2,(5),inst_55892,inst_55896,null));
var inst_55898 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55897);
var _ = (function (){var statearr_55916 = state_55903;
(statearr_55916[(4)] = cljs.core.rest((state_55903[(4)])));

return statearr_55916;
})();
var state_55903__$1 = (function (){var statearr_55917 = state_55903;
(statearr_55917[(7)] = inst_55898);

return statearr_55917;
})();
var statearr_55918_55932 = state_55903__$1;
(statearr_55918_55932[(2)] = inst_55891);

(statearr_55918_55932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0 = (function (){
var statearr_55919 = [null,null,null,null,null,null,null,null];
(statearr_55919[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__);

(statearr_55919[(1)] = (1));

return statearr_55919;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1 = (function (state_55903){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55903);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55920){var ex__2730__auto__ = e55920;
var statearr_55921_55933 = state_55903;
(statearr_55921_55933[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55903[(4)]))){
var statearr_55922_55934 = state_55903;
(statearr_55922_55934[(1)] = cljs.core.first((state_55903[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55935 = state_55903;
state_55903 = G__55935;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = function(state_55903){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1.call(this,state_55903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55923 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55923[(6)] = c__2749__auto__);

return statearr_55923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55985 = arguments.length;
var i__4865__auto___55986 = (0);
while(true){
if((i__4865__auto___55986 < len__4864__auto___55985)){
args__4870__auto__.push((arguments[i__4865__auto___55986]));

var G__55987 = (i__4865__auto___55986 + (1));
i__4865__auto___55986 = G__55987;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55968){
var state_val_55969 = (state_55968[(1)]);
if((state_val_55969 === (1))){
var state_55968__$1 = state_55968;
var statearr_55970_55988 = state_55968__$1;
(statearr_55970_55988[(2)] = null);

(statearr_55970_55988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55969 === (2))){
var _ = (function (){var statearr_55971 = state_55968;
(statearr_55971[(4)] = cljs.core.cons((5),(state_55968[(4)])));

return statearr_55971;
})();
var inst_55944 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55968__$1 = state_55968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55968__$1,(6),inst_55944);
} else {
if((state_val_55969 === (3))){
var inst_55966 = (state_55968[(2)]);
var state_55968__$1 = state_55968;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55968__$1,inst_55966);
} else {
if((state_val_55969 === (4))){
var inst_55938 = (state_55968[(2)]);
var state_55968__$1 = state_55968;
var statearr_55973_55989 = state_55968__$1;
(statearr_55973_55989[(2)] = inst_55938);

(statearr_55973_55989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55969 === (5))){
var _ = (function (){var statearr_55974 = state_55968;
(statearr_55974[(4)] = cljs.core.rest((state_55968[(4)])));

return statearr_55974;
})();
var state_55968__$1 = state_55968;
var ex55972 = (state_55968__$1[(2)]);
var statearr_55975_55990 = state_55968__$1;
(statearr_55975_55990[(5)] = ex55972);


if((ex55972 instanceof Error)){
var statearr_55976_55991 = state_55968__$1;
(statearr_55976_55991[(1)] = (4));

(statearr_55976_55991[(5)] = null);

} else {
throw ex55972;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55969 === (6))){
var inst_55946 = (state_55968[(2)]);
var inst_55947 = fluree.db.util.async.throw_err(inst_55946);
var inst_55948 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_55947);
var inst_55949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55950 = [inst_55947];
var inst_55951 = (new cljs.core.PersistentVector(null,1,(5),inst_55949,inst_55950,null));
var inst_55952 = cljs.core.count(inst_55951);
var inst_55953 = ((9) + inst_55952);
var inst_55954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55955 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55957 = [inst_55947];
var inst_55958 = (new cljs.core.PersistentVector(null,1,(5),inst_55956,inst_55957,null));
var inst_55959 = ["+",inst_55958,inst_55948];
var inst_55960 = cljs.core.PersistentHashMap.fromArrays(inst_55955,inst_55959);
var inst_55961 = [inst_55960,inst_55953];
var inst_55962 = (new cljs.core.PersistentVector(null,2,(5),inst_55954,inst_55961,null));
var inst_55963 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55962);
var _ = (function (){var statearr_55977 = state_55968;
(statearr_55977[(4)] = cljs.core.rest((state_55968[(4)])));

return statearr_55977;
})();
var state_55968__$1 = (function (){var statearr_55978 = state_55968;
(statearr_55978[(7)] = inst_55963);

return statearr_55978;
})();
var statearr_55979_55992 = state_55968__$1;
(statearr_55979_55992[(2)] = inst_55948);

(statearr_55979_55992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55980 = [null,null,null,null,null,null,null,null];
(statearr_55980[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55980[(1)] = (1));

return statearr_55980;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55968){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55968);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55981){var ex__2730__auto__ = e55981;
var statearr_55982_55993 = state_55968;
(statearr_55982_55993[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55968[(4)]))){
var statearr_55983_55994 = state_55968;
(statearr_55983_55994[(1)] = cljs.core.first((state_55968[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55995 = state_55968;
state_55968 = G__55995;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55968){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55984 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55984[(6)] = c__2749__auto__);

return statearr_55984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq55936){
var G__55937 = cljs.core.first(seq55936);
var seq55936__$1 = cljs.core.next(seq55936);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55937,seq55936__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___56045 = arguments.length;
var i__4865__auto___56046 = (0);
while(true){
if((i__4865__auto___56046 < len__4864__auto___56045)){
args__4870__auto__.push((arguments[i__4865__auto___56046]));

var G__56047 = (i__4865__auto___56046 + (1));
i__4865__auto___56046 = G__56047;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56028){
var state_val_56029 = (state_56028[(1)]);
if((state_val_56029 === (1))){
var state_56028__$1 = state_56028;
var statearr_56030_56048 = state_56028__$1;
(statearr_56030_56048[(2)] = null);

(statearr_56030_56048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (2))){
var _ = (function (){var statearr_56031 = state_56028;
(statearr_56031[(4)] = cljs.core.cons((5),(state_56028[(4)])));

return statearr_56031;
})();
var inst_56004 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56028__$1 = state_56028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56028__$1,(6),inst_56004);
} else {
if((state_val_56029 === (3))){
var inst_56026 = (state_56028[(2)]);
var state_56028__$1 = state_56028;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56028__$1,inst_56026);
} else {
if((state_val_56029 === (4))){
var inst_55998 = (state_56028[(2)]);
var state_56028__$1 = state_56028;
var statearr_56033_56049 = state_56028__$1;
(statearr_56033_56049[(2)] = inst_55998);

(statearr_56033_56049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (5))){
var _ = (function (){var statearr_56034 = state_56028;
(statearr_56034[(4)] = cljs.core.rest((state_56028[(4)])));

return statearr_56034;
})();
var state_56028__$1 = state_56028;
var ex56032 = (state_56028__$1[(2)]);
var statearr_56035_56050 = state_56028__$1;
(statearr_56035_56050[(5)] = ex56032);


if((ex56032 instanceof Error)){
var statearr_56036_56051 = state_56028__$1;
(statearr_56036_56051[(1)] = (4));

(statearr_56036_56051[(5)] = null);

} else {
throw ex56032;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56029 === (6))){
var inst_56006 = (state_56028[(2)]);
var inst_56007 = fluree.db.util.async.throw_err(inst_56006);
var inst_56008 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_56007);
var inst_56009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56010 = [inst_56007];
var inst_56011 = (new cljs.core.PersistentVector(null,1,(5),inst_56009,inst_56010,null));
var inst_56012 = cljs.core.count(inst_56011);
var inst_56013 = ((9) + inst_56012);
var inst_56014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56015 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56017 = [inst_56007];
var inst_56018 = (new cljs.core.PersistentVector(null,1,(5),inst_56016,inst_56017,null));
var inst_56019 = ["-",inst_56018,inst_56008];
var inst_56020 = cljs.core.PersistentHashMap.fromArrays(inst_56015,inst_56019);
var inst_56021 = [inst_56020,inst_56013];
var inst_56022 = (new cljs.core.PersistentVector(null,2,(5),inst_56014,inst_56021,null));
var inst_56023 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56022);
var _ = (function (){var statearr_56037 = state_56028;
(statearr_56037[(4)] = cljs.core.rest((state_56028[(4)])));

return statearr_56037;
})();
var state_56028__$1 = (function (){var statearr_56038 = state_56028;
(statearr_56038[(7)] = inst_56023);

return statearr_56038;
})();
var statearr_56039_56052 = state_56028__$1;
(statearr_56039_56052[(2)] = inst_56008);

(statearr_56039_56052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56040 = [null,null,null,null,null,null,null,null];
(statearr_56040[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56040[(1)] = (1));

return statearr_56040;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56028){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56028);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56041){var ex__2730__auto__ = e56041;
var statearr_56042_56053 = state_56028;
(statearr_56042_56053[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56028[(4)]))){
var statearr_56043_56054 = state_56028;
(statearr_56043_56054[(1)] = cljs.core.first((state_56028[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56055 = state_56028;
state_56028 = G__56055;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56028){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56044 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56044[(6)] = c__2749__auto__);

return statearr_56044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq55996){
var G__55997 = cljs.core.first(seq55996);
var seq55996__$1 = cljs.core.next(seq55996);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55997,seq55996__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___56105 = arguments.length;
var i__4865__auto___56106 = (0);
while(true){
if((i__4865__auto___56106 < len__4864__auto___56105)){
args__4870__auto__.push((arguments[i__4865__auto___56106]));

var G__56107 = (i__4865__auto___56106 + (1));
i__4865__auto___56106 = G__56107;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56088){
var state_val_56089 = (state_56088[(1)]);
if((state_val_56089 === (1))){
var state_56088__$1 = state_56088;
var statearr_56090_56108 = state_56088__$1;
(statearr_56090_56108[(2)] = null);

(statearr_56090_56108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56089 === (2))){
var _ = (function (){var statearr_56091 = state_56088;
(statearr_56091[(4)] = cljs.core.cons((5),(state_56088[(4)])));

return statearr_56091;
})();
var inst_56064 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56088__$1 = state_56088;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56088__$1,(6),inst_56064);
} else {
if((state_val_56089 === (3))){
var inst_56086 = (state_56088[(2)]);
var state_56088__$1 = state_56088;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56088__$1,inst_56086);
} else {
if((state_val_56089 === (4))){
var inst_56058 = (state_56088[(2)]);
var state_56088__$1 = state_56088;
var statearr_56093_56109 = state_56088__$1;
(statearr_56093_56109[(2)] = inst_56058);

(statearr_56093_56109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56089 === (5))){
var _ = (function (){var statearr_56094 = state_56088;
(statearr_56094[(4)] = cljs.core.rest((state_56088[(4)])));

return statearr_56094;
})();
var state_56088__$1 = state_56088;
var ex56092 = (state_56088__$1[(2)]);
var statearr_56095_56110 = state_56088__$1;
(statearr_56095_56110[(5)] = ex56092);


if((ex56092 instanceof Error)){
var statearr_56096_56111 = state_56088__$1;
(statearr_56096_56111[(1)] = (4));

(statearr_56096_56111[(5)] = null);

} else {
throw ex56092;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56089 === (6))){
var inst_56066 = (state_56088[(2)]);
var inst_56067 = fluree.db.util.async.throw_err(inst_56066);
var inst_56068 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_56067);
var inst_56069 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56070 = [inst_56067];
var inst_56071 = (new cljs.core.PersistentVector(null,1,(5),inst_56069,inst_56070,null));
var inst_56072 = cljs.core.count(inst_56071);
var inst_56073 = ((9) + inst_56072);
var inst_56074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56075 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56077 = [inst_56067];
var inst_56078 = (new cljs.core.PersistentVector(null,1,(5),inst_56076,inst_56077,null));
var inst_56079 = ["*",inst_56078,inst_56068];
var inst_56080 = cljs.core.PersistentHashMap.fromArrays(inst_56075,inst_56079);
var inst_56081 = [inst_56080,inst_56073];
var inst_56082 = (new cljs.core.PersistentVector(null,2,(5),inst_56074,inst_56081,null));
var inst_56083 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56082);
var _ = (function (){var statearr_56097 = state_56088;
(statearr_56097[(4)] = cljs.core.rest((state_56088[(4)])));

return statearr_56097;
})();
var state_56088__$1 = (function (){var statearr_56098 = state_56088;
(statearr_56098[(7)] = inst_56083);

return statearr_56098;
})();
var statearr_56099_56112 = state_56088__$1;
(statearr_56099_56112[(2)] = inst_56068);

(statearr_56099_56112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56100 = [null,null,null,null,null,null,null,null];
(statearr_56100[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56100[(1)] = (1));

return statearr_56100;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56088){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56088);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56101){var ex__2730__auto__ = e56101;
var statearr_56102_56113 = state_56088;
(statearr_56102_56113[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56088[(4)]))){
var statearr_56103_56114 = state_56088;
(statearr_56103_56114[(1)] = cljs.core.first((state_56088[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56115 = state_56088;
state_56088 = G__56115;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56088){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56104 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56104[(6)] = c__2749__auto__);

return statearr_56104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq56056){
var G__56057 = cljs.core.first(seq56056);
var seq56056__$1 = cljs.core.next(seq56056);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56057,seq56056__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___56165 = arguments.length;
var i__4865__auto___56166 = (0);
while(true){
if((i__4865__auto___56166 < len__4864__auto___56165)){
args__4870__auto__.push((arguments[i__4865__auto___56166]));

var G__56167 = (i__4865__auto___56166 + (1));
i__4865__auto___56166 = G__56167;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56148){
var state_val_56149 = (state_56148[(1)]);
if((state_val_56149 === (1))){
var state_56148__$1 = state_56148;
var statearr_56150_56168 = state_56148__$1;
(statearr_56150_56168[(2)] = null);

(statearr_56150_56168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56149 === (2))){
var _ = (function (){var statearr_56151 = state_56148;
(statearr_56151[(4)] = cljs.core.cons((5),(state_56148[(4)])));

return statearr_56151;
})();
var inst_56124 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56148__$1 = state_56148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56148__$1,(6),inst_56124);
} else {
if((state_val_56149 === (3))){
var inst_56146 = (state_56148[(2)]);
var state_56148__$1 = state_56148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56148__$1,inst_56146);
} else {
if((state_val_56149 === (4))){
var inst_56118 = (state_56148[(2)]);
var state_56148__$1 = state_56148;
var statearr_56153_56169 = state_56148__$1;
(statearr_56153_56169[(2)] = inst_56118);

(statearr_56153_56169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56149 === (5))){
var _ = (function (){var statearr_56154 = state_56148;
(statearr_56154[(4)] = cljs.core.rest((state_56148[(4)])));

return statearr_56154;
})();
var state_56148__$1 = state_56148;
var ex56152 = (state_56148__$1[(2)]);
var statearr_56155_56170 = state_56148__$1;
(statearr_56155_56170[(5)] = ex56152);


if((ex56152 instanceof Error)){
var statearr_56156_56171 = state_56148__$1;
(statearr_56156_56171[(1)] = (4));

(statearr_56156_56171[(5)] = null);

} else {
throw ex56152;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56149 === (6))){
var inst_56126 = (state_56148[(2)]);
var inst_56127 = fluree.db.util.async.throw_err(inst_56126);
var inst_56128 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_56127);
var inst_56129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56130 = [inst_56127];
var inst_56131 = (new cljs.core.PersistentVector(null,1,(5),inst_56129,inst_56130,null));
var inst_56132 = cljs.core.count(inst_56131);
var inst_56133 = ((9) + inst_56132);
var inst_56134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56135 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56137 = [inst_56127];
var inst_56138 = (new cljs.core.PersistentVector(null,1,(5),inst_56136,inst_56137,null));
var inst_56139 = ["/",inst_56138,inst_56128];
var inst_56140 = cljs.core.PersistentHashMap.fromArrays(inst_56135,inst_56139);
var inst_56141 = [inst_56140,inst_56133];
var inst_56142 = (new cljs.core.PersistentVector(null,2,(5),inst_56134,inst_56141,null));
var inst_56143 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56142);
var _ = (function (){var statearr_56157 = state_56148;
(statearr_56157[(4)] = cljs.core.rest((state_56148[(4)])));

return statearr_56157;
})();
var state_56148__$1 = (function (){var statearr_56158 = state_56148;
(statearr_56158[(7)] = inst_56143);

return statearr_56158;
})();
var statearr_56159_56172 = state_56148__$1;
(statearr_56159_56172[(2)] = inst_56128);

(statearr_56159_56172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56160 = [null,null,null,null,null,null,null,null];
(statearr_56160[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56160[(1)] = (1));

return statearr_56160;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56148){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56148);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56161){var ex__2730__auto__ = e56161;
var statearr_56162_56173 = state_56148;
(statearr_56162_56173[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56148[(4)]))){
var statearr_56163_56174 = state_56148;
(statearr_56163_56174[(1)] = cljs.core.first((state_56148[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56175 = state_56148;
state_56148 = G__56175;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56148){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56164 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56164[(6)] = c__2749__auto__);

return statearr_56164;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq56116){
var G__56117 = cljs.core.first(seq56116);
var seq56116__$1 = cljs.core.next(seq56116);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56117,seq56116__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56213){
var state_val_56214 = (state_56213[(1)]);
if((state_val_56214 === (7))){
var state_56213__$1 = state_56213;
var statearr_56215_56239 = state_56213__$1;
(statearr_56215_56239[(2)] = n);

(statearr_56215_56239[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56214 === (1))){
var state_56213__$1 = state_56213;
var statearr_56216_56240 = state_56213__$1;
(statearr_56216_56240[(2)] = null);

(statearr_56216_56240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56214 === (4))){
var inst_56176 = (state_56213[(2)]);
var state_56213__$1 = state_56213;
var statearr_56217_56241 = state_56213__$1;
(statearr_56217_56241[(2)] = inst_56176);

(statearr_56217_56241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56214 === (13))){
var inst_56193 = (state_56213[(2)]);
var inst_56194 = fluree.db.util.async.throw_err(inst_56193);
var state_56213__$1 = state_56213;
var statearr_56218_56242 = state_56213__$1;
(statearr_56218_56242[(2)] = inst_56194);

(statearr_56218_56242[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56214 === (6))){
var state_56213__$1 = state_56213;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56213__$1,(9),n);
} else {
if((state_val_56214 === (3))){
var inst_56211 = (state_56213[(2)]);
var state_56213__$1 = state_56213;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56213__$1,inst_56211);
} else {
if((state_val_56214 === (12))){
var inst_56189 = (state_56213[(7)]);
var inst_56197 = (state_56213[(2)]);
var inst_56198 = fluree.db.dbfunctions.internal.quot(inst_56189,inst_56197);
var inst_56199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56200 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56202 = [inst_56189,inst_56197];
var inst_56203 = (new cljs.core.PersistentVector(null,2,(5),inst_56201,inst_56202,null));
var inst_56204 = ["quot",inst_56203,inst_56198];
var inst_56205 = cljs.core.PersistentHashMap.fromArrays(inst_56200,inst_56204);
var inst_56206 = [inst_56205,(2)];
var inst_56207 = (new cljs.core.PersistentVector(null,2,(5),inst_56199,inst_56206,null));
var inst_56208 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56207);
var _ = (function (){var statearr_56219 = state_56213;
(statearr_56219[(4)] = cljs.core.rest((state_56213[(4)])));

return statearr_56219;
})();
var state_56213__$1 = (function (){var statearr_56220 = state_56213;
(statearr_56220[(8)] = inst_56208);

return statearr_56220;
})();
var statearr_56221_56243 = state_56213__$1;
(statearr_56221_56243[(2)] = inst_56198);

(statearr_56221_56243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56214 === (2))){
var _ = (function (){var statearr_56222 = state_56213;
(statearr_56222[(4)] = cljs.core.cons((5),(state_56213[(4)])));

return statearr_56222;
})();
var inst_56182 = fluree.db.util.async.channel_QMARK_(n);
var state_56213__$1 = state_56213;
if(inst_56182){
var statearr_56223_56244 = state_56213__$1;
(statearr_56223_56244[(1)] = (6));

} else {
var statearr_56224_56245 = state_56213__$1;
(statearr_56224_56245[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56214 === (11))){
var state_56213__$1 = state_56213;
var statearr_56226_56246 = state_56213__$1;
(statearr_56226_56246[(2)] = d);

(statearr_56226_56246[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56214 === (9))){
var inst_56185 = (state_56213[(2)]);
var inst_56186 = fluree.db.util.async.throw_err(inst_56185);
var state_56213__$1 = state_56213;
var statearr_56227_56247 = state_56213__$1;
(statearr_56227_56247[(2)] = inst_56186);

(statearr_56227_56247[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56214 === (5))){
var _ = (function (){var statearr_56228 = state_56213;
(statearr_56228[(4)] = cljs.core.rest((state_56213[(4)])));

return statearr_56228;
})();
var state_56213__$1 = state_56213;
var ex56225 = (state_56213__$1[(2)]);
var statearr_56229_56248 = state_56213__$1;
(statearr_56229_56248[(5)] = ex56225);


if((ex56225 instanceof Error)){
var statearr_56230_56249 = state_56213__$1;
(statearr_56230_56249[(1)] = (4));

(statearr_56230_56249[(5)] = null);

} else {
throw ex56225;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56214 === (10))){
var state_56213__$1 = state_56213;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56213__$1,(13),d);
} else {
if((state_val_56214 === (8))){
var inst_56189 = (state_56213[(2)]);
var inst_56190 = fluree.db.util.async.channel_QMARK_(d);
var state_56213__$1 = (function (){var statearr_56231 = state_56213;
(statearr_56231[(7)] = inst_56189);

return statearr_56231;
})();
if(inst_56190){
var statearr_56232_56250 = state_56213__$1;
(statearr_56232_56250[(1)] = (10));

} else {
var statearr_56233_56251 = state_56213__$1;
(statearr_56233_56251[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0 = (function (){
var statearr_56234 = [null,null,null,null,null,null,null,null,null];
(statearr_56234[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__);

(statearr_56234[(1)] = (1));

return statearr_56234;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1 = (function (state_56213){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56213);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56235){var ex__2730__auto__ = e56235;
var statearr_56236_56252 = state_56213;
(statearr_56236_56252[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56213[(4)]))){
var statearr_56237_56253 = state_56213;
(statearr_56237_56253[(1)] = cljs.core.first((state_56213[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56254 = state_56213;
state_56213 = G__56254;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = function(state_56213){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1.call(this,state_56213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56238 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56238[(6)] = c__2749__auto__);

return statearr_56238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56292){
var state_val_56293 = (state_56292[(1)]);
if((state_val_56293 === (7))){
var state_56292__$1 = state_56292;
var statearr_56294_56318 = state_56292__$1;
(statearr_56294_56318[(2)] = n);

(statearr_56294_56318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56293 === (1))){
var state_56292__$1 = state_56292;
var statearr_56295_56319 = state_56292__$1;
(statearr_56295_56319[(2)] = null);

(statearr_56295_56319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56293 === (4))){
var inst_56255 = (state_56292[(2)]);
var state_56292__$1 = state_56292;
var statearr_56296_56320 = state_56292__$1;
(statearr_56296_56320[(2)] = inst_56255);

(statearr_56296_56320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56293 === (13))){
var inst_56272 = (state_56292[(2)]);
var inst_56273 = fluree.db.util.async.throw_err(inst_56272);
var state_56292__$1 = state_56292;
var statearr_56297_56321 = state_56292__$1;
(statearr_56297_56321[(2)] = inst_56273);

(statearr_56297_56321[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56293 === (6))){
var state_56292__$1 = state_56292;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56292__$1,(9),n);
} else {
if((state_val_56293 === (3))){
var inst_56290 = (state_56292[(2)]);
var state_56292__$1 = state_56292;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56292__$1,inst_56290);
} else {
if((state_val_56293 === (12))){
var inst_56268 = (state_56292[(7)]);
var inst_56276 = (state_56292[(2)]);
var inst_56277 = fluree.db.dbfunctions.internal.mod(inst_56268,inst_56276);
var inst_56278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56279 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56281 = [inst_56268,inst_56276];
var inst_56282 = (new cljs.core.PersistentVector(null,2,(5),inst_56280,inst_56281,null));
var inst_56283 = ["mod",inst_56282,inst_56277];
var inst_56284 = cljs.core.PersistentHashMap.fromArrays(inst_56279,inst_56283);
var inst_56285 = [inst_56284,(2)];
var inst_56286 = (new cljs.core.PersistentVector(null,2,(5),inst_56278,inst_56285,null));
var inst_56287 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56286);
var _ = (function (){var statearr_56298 = state_56292;
(statearr_56298[(4)] = cljs.core.rest((state_56292[(4)])));

return statearr_56298;
})();
var state_56292__$1 = (function (){var statearr_56299 = state_56292;
(statearr_56299[(8)] = inst_56287);

return statearr_56299;
})();
var statearr_56300_56322 = state_56292__$1;
(statearr_56300_56322[(2)] = inst_56277);

(statearr_56300_56322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56293 === (2))){
var _ = (function (){var statearr_56301 = state_56292;
(statearr_56301[(4)] = cljs.core.cons((5),(state_56292[(4)])));

return statearr_56301;
})();
var inst_56261 = fluree.db.util.async.channel_QMARK_(n);
var state_56292__$1 = state_56292;
if(inst_56261){
var statearr_56302_56323 = state_56292__$1;
(statearr_56302_56323[(1)] = (6));

} else {
var statearr_56303_56324 = state_56292__$1;
(statearr_56303_56324[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56293 === (11))){
var state_56292__$1 = state_56292;
var statearr_56305_56325 = state_56292__$1;
(statearr_56305_56325[(2)] = d);

(statearr_56305_56325[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56293 === (9))){
var inst_56264 = (state_56292[(2)]);
var inst_56265 = fluree.db.util.async.throw_err(inst_56264);
var state_56292__$1 = state_56292;
var statearr_56306_56326 = state_56292__$1;
(statearr_56306_56326[(2)] = inst_56265);

(statearr_56306_56326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56293 === (5))){
var _ = (function (){var statearr_56307 = state_56292;
(statearr_56307[(4)] = cljs.core.rest((state_56292[(4)])));

return statearr_56307;
})();
var state_56292__$1 = state_56292;
var ex56304 = (state_56292__$1[(2)]);
var statearr_56308_56327 = state_56292__$1;
(statearr_56308_56327[(5)] = ex56304);


if((ex56304 instanceof Error)){
var statearr_56309_56328 = state_56292__$1;
(statearr_56309_56328[(1)] = (4));

(statearr_56309_56328[(5)] = null);

} else {
throw ex56304;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56293 === (10))){
var state_56292__$1 = state_56292;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56292__$1,(13),d);
} else {
if((state_val_56293 === (8))){
var inst_56268 = (state_56292[(2)]);
var inst_56269 = fluree.db.util.async.channel_QMARK_(d);
var state_56292__$1 = (function (){var statearr_56310 = state_56292;
(statearr_56310[(7)] = inst_56268);

return statearr_56310;
})();
if(inst_56269){
var statearr_56311_56329 = state_56292__$1;
(statearr_56311_56329[(1)] = (10));

} else {
var statearr_56312_56330 = state_56292__$1;
(statearr_56312_56330[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0 = (function (){
var statearr_56313 = [null,null,null,null,null,null,null,null,null];
(statearr_56313[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__);

(statearr_56313[(1)] = (1));

return statearr_56313;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1 = (function (state_56292){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56292);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56314){var ex__2730__auto__ = e56314;
var statearr_56315_56331 = state_56292;
(statearr_56315_56331[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56292[(4)]))){
var statearr_56316_56332 = state_56292;
(statearr_56316_56332[(1)] = cljs.core.first((state_56292[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56333 = state_56292;
state_56292 = G__56333;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = function(state_56292){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1.call(this,state_56292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56317 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56317[(6)] = c__2749__auto__);

return statearr_56317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56371){
var state_val_56372 = (state_56371[(1)]);
if((state_val_56372 === (7))){
var state_56371__$1 = state_56371;
var statearr_56373_56397 = state_56371__$1;
(statearr_56373_56397[(2)] = n);

(statearr_56373_56397[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56372 === (1))){
var state_56371__$1 = state_56371;
var statearr_56374_56398 = state_56371__$1;
(statearr_56374_56398[(2)] = null);

(statearr_56374_56398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56372 === (4))){
var inst_56334 = (state_56371[(2)]);
var state_56371__$1 = state_56371;
var statearr_56375_56399 = state_56371__$1;
(statearr_56375_56399[(2)] = inst_56334);

(statearr_56375_56399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56372 === (13))){
var inst_56351 = (state_56371[(2)]);
var inst_56352 = fluree.db.util.async.throw_err(inst_56351);
var state_56371__$1 = state_56371;
var statearr_56376_56400 = state_56371__$1;
(statearr_56376_56400[(2)] = inst_56352);

(statearr_56376_56400[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56372 === (6))){
var state_56371__$1 = state_56371;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56371__$1,(9),n);
} else {
if((state_val_56372 === (3))){
var inst_56369 = (state_56371[(2)]);
var state_56371__$1 = state_56371;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56371__$1,inst_56369);
} else {
if((state_val_56372 === (12))){
var inst_56347 = (state_56371[(7)]);
var inst_56355 = (state_56371[(2)]);
var inst_56356 = fluree.db.dbfunctions.internal.rem(inst_56347,inst_56355);
var inst_56357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56358 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56360 = [inst_56347,inst_56355];
var inst_56361 = (new cljs.core.PersistentVector(null,2,(5),inst_56359,inst_56360,null));
var inst_56362 = ["rem",inst_56361,inst_56356];
var inst_56363 = cljs.core.PersistentHashMap.fromArrays(inst_56358,inst_56362);
var inst_56364 = [inst_56363,(2)];
var inst_56365 = (new cljs.core.PersistentVector(null,2,(5),inst_56357,inst_56364,null));
var inst_56366 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56365);
var _ = (function (){var statearr_56377 = state_56371;
(statearr_56377[(4)] = cljs.core.rest((state_56371[(4)])));

return statearr_56377;
})();
var state_56371__$1 = (function (){var statearr_56378 = state_56371;
(statearr_56378[(8)] = inst_56366);

return statearr_56378;
})();
var statearr_56379_56401 = state_56371__$1;
(statearr_56379_56401[(2)] = inst_56356);

(statearr_56379_56401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56372 === (2))){
var _ = (function (){var statearr_56380 = state_56371;
(statearr_56380[(4)] = cljs.core.cons((5),(state_56371[(4)])));

return statearr_56380;
})();
var inst_56340 = fluree.db.util.async.channel_QMARK_(n);
var state_56371__$1 = state_56371;
if(inst_56340){
var statearr_56381_56402 = state_56371__$1;
(statearr_56381_56402[(1)] = (6));

} else {
var statearr_56382_56403 = state_56371__$1;
(statearr_56382_56403[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56372 === (11))){
var state_56371__$1 = state_56371;
var statearr_56384_56404 = state_56371__$1;
(statearr_56384_56404[(2)] = d);

(statearr_56384_56404[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56372 === (9))){
var inst_56343 = (state_56371[(2)]);
var inst_56344 = fluree.db.util.async.throw_err(inst_56343);
var state_56371__$1 = state_56371;
var statearr_56385_56405 = state_56371__$1;
(statearr_56385_56405[(2)] = inst_56344);

(statearr_56385_56405[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56372 === (5))){
var _ = (function (){var statearr_56386 = state_56371;
(statearr_56386[(4)] = cljs.core.rest((state_56371[(4)])));

return statearr_56386;
})();
var state_56371__$1 = state_56371;
var ex56383 = (state_56371__$1[(2)]);
var statearr_56387_56406 = state_56371__$1;
(statearr_56387_56406[(5)] = ex56383);


if((ex56383 instanceof Error)){
var statearr_56388_56407 = state_56371__$1;
(statearr_56388_56407[(1)] = (4));

(statearr_56388_56407[(5)] = null);

} else {
throw ex56383;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56372 === (10))){
var state_56371__$1 = state_56371;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56371__$1,(13),d);
} else {
if((state_val_56372 === (8))){
var inst_56347 = (state_56371[(2)]);
var inst_56348 = fluree.db.util.async.channel_QMARK_(d);
var state_56371__$1 = (function (){var statearr_56389 = state_56371;
(statearr_56389[(7)] = inst_56347);

return statearr_56389;
})();
if(inst_56348){
var statearr_56390_56408 = state_56371__$1;
(statearr_56390_56408[(1)] = (10));

} else {
var statearr_56391_56409 = state_56371__$1;
(statearr_56391_56409[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0 = (function (){
var statearr_56392 = [null,null,null,null,null,null,null,null,null];
(statearr_56392[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__);

(statearr_56392[(1)] = (1));

return statearr_56392;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1 = (function (state_56371){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56371);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56393){var ex__2730__auto__ = e56393;
var statearr_56394_56410 = state_56371;
(statearr_56394_56410[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56371[(4)]))){
var statearr_56395_56411 = state_56371;
(statearr_56395_56411[(1)] = cljs.core.first((state_56371[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56412 = state_56371;
state_56371 = G__56412;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = function(state_56371){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1.call(this,state_56371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56396 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56396[(6)] = c__2749__auto__);

return statearr_56396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56439){
var state_val_56440 = (state_56439[(1)]);
if((state_val_56440 === (7))){
var state_56439__$1 = state_56439;
var statearr_56441_56460 = state_56439__$1;
(statearr_56441_56460[(2)] = x);

(statearr_56441_56460[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56440 === (1))){
var state_56439__$1 = state_56439;
var statearr_56442_56461 = state_56439__$1;
(statearr_56442_56461[(2)] = null);

(statearr_56442_56461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56440 === (4))){
var inst_56413 = (state_56439[(2)]);
var state_56439__$1 = state_56439;
var statearr_56443_56462 = state_56439__$1;
(statearr_56443_56462[(2)] = inst_56413);

(statearr_56443_56462[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56440 === (6))){
var state_56439__$1 = state_56439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56439__$1,(9),x);
} else {
if((state_val_56440 === (3))){
var inst_56437 = (state_56439[(2)]);
var state_56439__$1 = state_56439;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56439__$1,inst_56437);
} else {
if((state_val_56440 === (2))){
var _ = (function (){var statearr_56445 = state_56439;
(statearr_56445[(4)] = cljs.core.cons((5),(state_56439[(4)])));

return statearr_56445;
})();
var inst_56419 = fluree.db.util.async.channel_QMARK_(x);
var state_56439__$1 = state_56439;
if(inst_56419){
var statearr_56446_56463 = state_56439__$1;
(statearr_56446_56463[(1)] = (6));

} else {
var statearr_56447_56464 = state_56439__$1;
(statearr_56447_56464[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56440 === (9))){
var inst_56422 = (state_56439[(2)]);
var inst_56423 = fluree.db.util.async.throw_err(inst_56422);
var state_56439__$1 = state_56439;
var statearr_56448_56465 = state_56439__$1;
(statearr_56448_56465[(2)] = inst_56423);

(statearr_56448_56465[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56440 === (5))){
var _ = (function (){var statearr_56449 = state_56439;
(statearr_56449[(4)] = cljs.core.rest((state_56439[(4)])));

return statearr_56449;
})();
var state_56439__$1 = state_56439;
var ex56444 = (state_56439__$1[(2)]);
var statearr_56450_56466 = state_56439__$1;
(statearr_56450_56466[(5)] = ex56444);


if((ex56444 instanceof Error)){
var statearr_56451_56467 = state_56439__$1;
(statearr_56451_56467[(1)] = (4));

(statearr_56451_56467[(5)] = null);

} else {
throw ex56444;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56440 === (8))){
var inst_56426 = (state_56439[(2)]);
var inst_56427 = fluree.db.dbfunctions.internal.boolean$(inst_56426);
var inst_56428 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56429 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56430 = ["boolean",inst_56426,inst_56427];
var inst_56431 = cljs.core.PersistentHashMap.fromArrays(inst_56429,inst_56430);
var inst_56432 = [inst_56431,(10)];
var inst_56433 = (new cljs.core.PersistentVector(null,2,(5),inst_56428,inst_56432,null));
var inst_56434 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56433);
var _ = (function (){var statearr_56452 = state_56439;
(statearr_56452[(4)] = cljs.core.rest((state_56439[(4)])));

return statearr_56452;
})();
var state_56439__$1 = (function (){var statearr_56453 = state_56439;
(statearr_56453[(7)] = inst_56434);

return statearr_56453;
})();
var statearr_56454_56468 = state_56439__$1;
(statearr_56454_56468[(2)] = inst_56427);

(statearr_56454_56468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0 = (function (){
var statearr_56455 = [null,null,null,null,null,null,null,null];
(statearr_56455[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__);

(statearr_56455[(1)] = (1));

return statearr_56455;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1 = (function (state_56439){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56439);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56456){var ex__2730__auto__ = e56456;
var statearr_56457_56469 = state_56439;
(statearr_56457_56469[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56439[(4)]))){
var statearr_56458_56470 = state_56439;
(statearr_56458_56470[(1)] = cljs.core.first((state_56439[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56471 = state_56439;
state_56439 = G__56471;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = function(state_56439){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1.call(this,state_56439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56459 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56459[(6)] = c__2749__auto__);

return statearr_56459;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56509){
var state_val_56510 = (state_56509[(1)]);
if((state_val_56510 === (7))){
var state_56509__$1 = state_56509;
var statearr_56511_56535 = state_56509__$1;
(statearr_56511_56535[(2)] = pattern);

(statearr_56511_56535[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (1))){
var state_56509__$1 = state_56509;
var statearr_56512_56536 = state_56509__$1;
(statearr_56512_56536[(2)] = null);

(statearr_56512_56536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (4))){
var inst_56472 = (state_56509[(2)]);
var state_56509__$1 = state_56509;
var statearr_56513_56537 = state_56509__$1;
(statearr_56513_56537[(2)] = inst_56472);

(statearr_56513_56537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (13))){
var inst_56489 = (state_56509[(2)]);
var inst_56490 = fluree.db.util.async.throw_err(inst_56489);
var state_56509__$1 = state_56509;
var statearr_56514_56538 = state_56509__$1;
(statearr_56514_56538[(2)] = inst_56490);

(statearr_56514_56538[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (6))){
var state_56509__$1 = state_56509;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56509__$1,(9),pattern);
} else {
if((state_val_56510 === (3))){
var inst_56507 = (state_56509[(2)]);
var state_56509__$1 = state_56509;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56509__$1,inst_56507);
} else {
if((state_val_56510 === (12))){
var inst_56485 = (state_56509[(7)]);
var inst_56493 = (state_56509[(2)]);
var inst_56494 = fluree.db.dbfunctions.internal.re_find(inst_56485,inst_56493);
var inst_56495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56496 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56497 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56498 = [inst_56485,inst_56493];
var inst_56499 = (new cljs.core.PersistentVector(null,2,(5),inst_56497,inst_56498,null));
var inst_56500 = ["re-find",inst_56499,inst_56494];
var inst_56501 = cljs.core.PersistentHashMap.fromArrays(inst_56496,inst_56500);
var inst_56502 = [inst_56501,(10)];
var inst_56503 = (new cljs.core.PersistentVector(null,2,(5),inst_56495,inst_56502,null));
var inst_56504 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56503);
var _ = (function (){var statearr_56515 = state_56509;
(statearr_56515[(4)] = cljs.core.rest((state_56509[(4)])));

return statearr_56515;
})();
var state_56509__$1 = (function (){var statearr_56516 = state_56509;
(statearr_56516[(8)] = inst_56504);

return statearr_56516;
})();
var statearr_56517_56539 = state_56509__$1;
(statearr_56517_56539[(2)] = inst_56494);

(statearr_56517_56539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (2))){
var _ = (function (){var statearr_56518 = state_56509;
(statearr_56518[(4)] = cljs.core.cons((5),(state_56509[(4)])));

return statearr_56518;
})();
var inst_56478 = fluree.db.util.async.channel_QMARK_(pattern);
var state_56509__$1 = state_56509;
if(inst_56478){
var statearr_56519_56540 = state_56509__$1;
(statearr_56519_56540[(1)] = (6));

} else {
var statearr_56520_56541 = state_56509__$1;
(statearr_56520_56541[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (11))){
var state_56509__$1 = state_56509;
var statearr_56522_56542 = state_56509__$1;
(statearr_56522_56542[(2)] = string);

(statearr_56522_56542[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (9))){
var inst_56481 = (state_56509[(2)]);
var inst_56482 = fluree.db.util.async.throw_err(inst_56481);
var state_56509__$1 = state_56509;
var statearr_56523_56543 = state_56509__$1;
(statearr_56523_56543[(2)] = inst_56482);

(statearr_56523_56543[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (5))){
var _ = (function (){var statearr_56524 = state_56509;
(statearr_56524[(4)] = cljs.core.rest((state_56509[(4)])));

return statearr_56524;
})();
var state_56509__$1 = state_56509;
var ex56521 = (state_56509__$1[(2)]);
var statearr_56525_56544 = state_56509__$1;
(statearr_56525_56544[(5)] = ex56521);


if((ex56521 instanceof Error)){
var statearr_56526_56545 = state_56509__$1;
(statearr_56526_56545[(1)] = (4));

(statearr_56526_56545[(5)] = null);

} else {
throw ex56521;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (10))){
var state_56509__$1 = state_56509;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56509__$1,(13),string);
} else {
if((state_val_56510 === (8))){
var inst_56485 = (state_56509[(2)]);
var inst_56486 = fluree.db.util.async.channel_QMARK_(string);
var state_56509__$1 = (function (){var statearr_56527 = state_56509;
(statearr_56527[(7)] = inst_56485);

return statearr_56527;
})();
if(inst_56486){
var statearr_56528_56546 = state_56509__$1;
(statearr_56528_56546[(1)] = (10));

} else {
var statearr_56529_56547 = state_56509__$1;
(statearr_56529_56547[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0 = (function (){
var statearr_56530 = [null,null,null,null,null,null,null,null,null];
(statearr_56530[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__);

(statearr_56530[(1)] = (1));

return statearr_56530;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1 = (function (state_56509){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56509);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56531){var ex__2730__auto__ = e56531;
var statearr_56532_56548 = state_56509;
(statearr_56532_56548[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56509[(4)]))){
var statearr_56533_56549 = state_56509;
(statearr_56533_56549[(1)] = cljs.core.first((state_56509[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56550 = state_56509;
state_56509 = G__56550;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = function(state_56509){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1.call(this,state_56509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56534 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56534[(6)] = c__2749__auto__);

return statearr_56534;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56577){
var state_val_56578 = (state_56577[(1)]);
if((state_val_56578 === (7))){
var state_56577__$1 = state_56577;
var statearr_56579_56598 = state_56577__$1;
(statearr_56579_56598[(2)] = email);

(statearr_56579_56598[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56578 === (1))){
var state_56577__$1 = state_56577;
var statearr_56580_56599 = state_56577__$1;
(statearr_56580_56599[(2)] = null);

(statearr_56580_56599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56578 === (4))){
var inst_56551 = (state_56577[(2)]);
var state_56577__$1 = state_56577;
var statearr_56581_56600 = state_56577__$1;
(statearr_56581_56600[(2)] = inst_56551);

(statearr_56581_56600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56578 === (6))){
var state_56577__$1 = state_56577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56577__$1,(9),email);
} else {
if((state_val_56578 === (3))){
var inst_56575 = (state_56577[(2)]);
var state_56577__$1 = state_56577;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56577__$1,inst_56575);
} else {
if((state_val_56578 === (2))){
var _ = (function (){var statearr_56583 = state_56577;
(statearr_56583[(4)] = cljs.core.cons((5),(state_56577[(4)])));

return statearr_56583;
})();
var inst_56557 = fluree.db.util.async.channel_QMARK_(email);
var state_56577__$1 = state_56577;
if(inst_56557){
var statearr_56584_56601 = state_56577__$1;
(statearr_56584_56601[(1)] = (6));

} else {
var statearr_56585_56602 = state_56577__$1;
(statearr_56585_56602[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56578 === (9))){
var inst_56560 = (state_56577[(2)]);
var inst_56561 = fluree.db.util.async.throw_err(inst_56560);
var state_56577__$1 = state_56577;
var statearr_56586_56603 = state_56577__$1;
(statearr_56586_56603[(2)] = inst_56561);

(statearr_56586_56603[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56578 === (5))){
var _ = (function (){var statearr_56587 = state_56577;
(statearr_56587[(4)] = cljs.core.rest((state_56577[(4)])));

return statearr_56587;
})();
var state_56577__$1 = state_56577;
var ex56582 = (state_56577__$1[(2)]);
var statearr_56588_56604 = state_56577__$1;
(statearr_56588_56604[(5)] = ex56582);


if((ex56582 instanceof Error)){
var statearr_56589_56605 = state_56577__$1;
(statearr_56589_56605[(1)] = (4));

(statearr_56589_56605[(5)] = null);

} else {
throw ex56582;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56578 === (8))){
var inst_56564 = (state_56577[(2)]);
var inst_56565 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_56564);
var inst_56566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56567 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56568 = ["re-find",inst_56564,inst_56565];
var inst_56569 = cljs.core.PersistentHashMap.fromArrays(inst_56567,inst_56568);
var inst_56570 = [inst_56569,(10)];
var inst_56571 = (new cljs.core.PersistentVector(null,2,(5),inst_56566,inst_56570,null));
var inst_56572 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56571);
var _ = (function (){var statearr_56590 = state_56577;
(statearr_56590[(4)] = cljs.core.rest((state_56577[(4)])));

return statearr_56590;
})();
var state_56577__$1 = (function (){var statearr_56591 = state_56577;
(statearr_56591[(7)] = inst_56572);

return statearr_56591;
})();
var statearr_56592_56606 = state_56577__$1;
(statearr_56592_56606[(2)] = inst_56565);

(statearr_56592_56606[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_56593 = [null,null,null,null,null,null,null,null];
(statearr_56593[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__);

(statearr_56593[(1)] = (1));

return statearr_56593;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1 = (function (state_56577){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56577);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56594){var ex__2730__auto__ = e56594;
var statearr_56595_56607 = state_56577;
(statearr_56595_56607[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56577[(4)]))){
var statearr_56596_56608 = state_56577;
(statearr_56596_56608[(1)] = cljs.core.first((state_56577[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56609 = state_56577;
state_56577 = G__56609;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = function(state_56577){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1.call(this,state_56577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56597 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56597[(6)] = c__2749__auto__);

return statearr_56597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56656){
var state_val_56657 = (state_56656[(1)]);
if((state_val_56657 === (7))){
var inst_56626 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56656__$1 = state_56656;
if(cljs.core.truth_(inst_56626)){
var statearr_56658_56685 = state_56656__$1;
(statearr_56658_56685[(1)] = (9));

} else {
var statearr_56659_56686 = state_56656__$1;
(statearr_56659_56686[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56657 === (1))){
var state_56656__$1 = state_56656;
var statearr_56660_56687 = state_56656__$1;
(statearr_56660_56687[(2)] = null);

(statearr_56660_56687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56657 === (4))){
var inst_56610 = (state_56656[(2)]);
var state_56656__$1 = state_56656;
var statearr_56661_56688 = state_56656__$1;
(statearr_56661_56688[(2)] = inst_56610);

(statearr_56661_56688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56657 === (15))){
var inst_56637 = (state_56656[(2)]);
var state_56656__$1 = state_56656;
var statearr_56662_56689 = state_56656__$1;
(statearr_56662_56689[(2)] = inst_56637);

(statearr_56662_56689[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56657 === (13))){
var inst_56634 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_56656__$1 = state_56656;
var statearr_56663_56690 = state_56656__$1;
(statearr_56663_56690[(2)] = inst_56634);

(statearr_56663_56690[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56657 === (6))){
var inst_56621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56622 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56623 = [inst_56622,(0)];
var inst_56624 = (new cljs.core.PersistentVector(null,2,(5),inst_56621,inst_56623,null));
var state_56656__$1 = state_56656;
var statearr_56664_56691 = state_56656__$1;
(statearr_56664_56691[(2)] = inst_56624);

(statearr_56664_56691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56657 === (3))){
var inst_56654 = (state_56656[(2)]);
var state_56656__$1 = state_56656;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56656__$1,inst_56654);
} else {
if((state_val_56657 === (12))){
var inst_56630 = (state_56656[(2)]);
var inst_56631 = fluree.db.util.async.throw_err(inst_56630);
var state_56656__$1 = state_56656;
var statearr_56665_56692 = state_56656__$1;
(statearr_56665_56692[(2)] = inst_56631);

(statearr_56665_56692[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56657 === (2))){
var _ = (function (){var statearr_56666 = state_56656;
(statearr_56666[(4)] = cljs.core.cons((5),(state_56656[(4)])));

return statearr_56666;
})();
var inst_56619 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56656__$1 = state_56656;
if(cljs.core.truth_(inst_56619)){
var statearr_56667_56693 = state_56656__$1;
(statearr_56667_56693[(1)] = (6));

} else {
var statearr_56668_56694 = state_56656__$1;
(statearr_56668_56694[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56657 === (11))){
var inst_56639 = (state_56656[(2)]);
var state_56656__$1 = state_56656;
var statearr_56670_56695 = state_56656__$1;
(statearr_56670_56695[(2)] = inst_56639);

(statearr_56670_56695[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56657 === (9))){
var inst_56628 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_56656__$1 = state_56656;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56656__$1,(12),inst_56628);
} else {
if((state_val_56657 === (5))){
var _ = (function (){var statearr_56671 = state_56656;
(statearr_56671[(4)] = cljs.core.rest((state_56656[(4)])));

return statearr_56671;
})();
var state_56656__$1 = state_56656;
var ex56669 = (state_56656__$1[(2)]);
var statearr_56672_56696 = state_56656__$1;
(statearr_56672_56696[(5)] = ex56669);


if((ex56669 instanceof Error)){
var statearr_56673_56697 = state_56656__$1;
(statearr_56673_56697[(1)] = (4));

(statearr_56673_56697[(5)] = null);

} else {
throw ex56669;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56657 === (14))){
var state_56656__$1 = state_56656;
var statearr_56674_56698 = state_56656__$1;
(statearr_56674_56698[(2)] = null);

(statearr_56674_56698[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56657 === (10))){
var state_56656__$1 = state_56656;
var statearr_56675_56699 = state_56656__$1;
(statearr_56675_56699[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56657 === (8))){
var inst_56641 = (state_56656[(2)]);
var inst_56642 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56641,(0),null);
var inst_56643 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56641,(1),null);
var inst_56644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56645 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56646 = ["?user_id","?ctx",inst_56642];
var inst_56647 = cljs.core.PersistentHashMap.fromArrays(inst_56645,inst_56646);
var inst_56648 = ((10) + inst_56643);
var inst_56649 = [inst_56647,inst_56648];
var inst_56650 = (new cljs.core.PersistentVector(null,2,(5),inst_56644,inst_56649,null));
var inst_56651 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56650);
var _ = (function (){var statearr_56677 = state_56656;
(statearr_56677[(4)] = cljs.core.rest((state_56656[(4)])));

return statearr_56677;
})();
var state_56656__$1 = (function (){var statearr_56678 = state_56656;
(statearr_56678[(7)] = inst_56651);

return statearr_56678;
})();
var statearr_56679_56700 = state_56656__$1;
(statearr_56679_56700[(2)] = inst_56642);

(statearr_56679_56700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0 = (function (){
var statearr_56680 = [null,null,null,null,null,null,null,null];
(statearr_56680[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__);

(statearr_56680[(1)] = (1));

return statearr_56680;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1 = (function (state_56656){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56656);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56681){var ex__2730__auto__ = e56681;
var statearr_56682_56701 = state_56656;
(statearr_56682_56701[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56656[(4)]))){
var statearr_56683_56702 = state_56656;
(statearr_56683_56702[(1)] = cljs.core.first((state_56656[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56703 = state_56656;
state_56656 = G__56703;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = function(state_56656){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1.call(this,state_56656);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56684 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56684[(6)] = c__2749__auto__);

return statearr_56684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56731){
var state_val_56732 = (state_56731[(1)]);
if((state_val_56732 === (7))){
var inst_56724 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_56731__$1 = state_56731;
var statearr_56733_56752 = state_56731__$1;
(statearr_56733_56752[(2)] = inst_56724);

(statearr_56733_56752[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56732 === (1))){
var state_56731__$1 = state_56731;
var statearr_56734_56753 = state_56731__$1;
(statearr_56734_56753[(2)] = null);

(statearr_56734_56753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56732 === (4))){
var inst_56704 = (state_56731[(2)]);
var state_56731__$1 = state_56731;
var statearr_56735_56754 = state_56731__$1;
(statearr_56735_56754[(2)] = inst_56704);

(statearr_56735_56754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56732 === (6))){
var inst_56712 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_56731__$1 = state_56731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56731__$1,(9),inst_56712);
} else {
if((state_val_56732 === (3))){
var inst_56729 = (state_56731[(2)]);
var state_56731__$1 = state_56731;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56731__$1,inst_56729);
} else {
if((state_val_56732 === (2))){
var _ = (function (){var statearr_56737 = state_56731;
(statearr_56737[(4)] = cljs.core.cons((5),(state_56731[(4)])));

return statearr_56737;
})();
var inst_56710 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56731__$1 = state_56731;
if(cljs.core.truth_(inst_56710)){
var statearr_56738_56755 = state_56731__$1;
(statearr_56738_56755[(1)] = (6));

} else {
var statearr_56739_56756 = state_56731__$1;
(statearr_56739_56756[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56732 === (9))){
var inst_56714 = (state_56731[(2)]);
var inst_56715 = fluree.db.util.async.throw_err(inst_56714);
var inst_56716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56717 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56718 = ["?auth_id","?ctx",inst_56715];
var inst_56719 = cljs.core.PersistentHashMap.fromArrays(inst_56717,inst_56718);
var inst_56720 = [inst_56719,(10)];
var inst_56721 = (new cljs.core.PersistentVector(null,2,(5),inst_56716,inst_56720,null));
var inst_56722 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56721);
var state_56731__$1 = (function (){var statearr_56740 = state_56731;
(statearr_56740[(7)] = inst_56722);

return statearr_56740;
})();
var statearr_56741_56757 = state_56731__$1;
(statearr_56741_56757[(2)] = inst_56715);

(statearr_56741_56757[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56732 === (5))){
var _ = (function (){var statearr_56742 = state_56731;
(statearr_56742[(4)] = cljs.core.rest((state_56731[(4)])));

return statearr_56742;
})();
var state_56731__$1 = state_56731;
var ex56736 = (state_56731__$1[(2)]);
var statearr_56743_56758 = state_56731__$1;
(statearr_56743_56758[(5)] = ex56736);


if((ex56736 instanceof Error)){
var statearr_56744_56759 = state_56731__$1;
(statearr_56744_56759[(1)] = (4));

(statearr_56744_56759[(5)] = null);

} else {
throw ex56736;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56732 === (8))){
var inst_56726 = (state_56731[(2)]);
var _ = (function (){var statearr_56745 = state_56731;
(statearr_56745[(4)] = cljs.core.rest((state_56731[(4)])));

return statearr_56745;
})();
var state_56731__$1 = state_56731;
var statearr_56746_56760 = state_56731__$1;
(statearr_56746_56760[(2)] = inst_56726);

(statearr_56746_56760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_56747 = [null,null,null,null,null,null,null,null];
(statearr_56747[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_56747[(1)] = (1));

return statearr_56747;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_56731){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56731);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56748){var ex__2730__auto__ = e56748;
var statearr_56749_56761 = state_56731;
(statearr_56749_56761[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56731[(4)]))){
var statearr_56750_56762 = state_56731;
(statearr_56750_56762[(1)] = cljs.core.first((state_56731[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56763 = state_56731;
state_56731 = G__56763;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_56731){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_56731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56751 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56751[(6)] = c__2749__auto__);

return statearr_56751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__56765 = arguments.length;
switch (G__56765) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56807){
var state_val_56808 = (state_56807[(1)]);
if((state_val_56808 === (7))){
var state_56807__$1 = state_56807;
var statearr_56809_56839 = state_56807__$1;
(statearr_56809_56839[(2)] = seed);

(statearr_56809_56839[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56808 === (1))){
var state_56807__$1 = state_56807;
var statearr_56810_56840 = state_56807__$1;
(statearr_56810_56840[(2)] = null);

(statearr_56810_56840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56808 === (4))){
var inst_56766 = (state_56807[(2)]);
var state_56807__$1 = state_56807;
var statearr_56811_56841 = state_56807__$1;
(statearr_56811_56841[(2)] = inst_56766);

(statearr_56811_56841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56808 === (15))){
var state_56807__$1 = state_56807;
var statearr_56812_56842 = state_56807__$1;
(statearr_56812_56842[(2)] = (10));

(statearr_56812_56842[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56808 === (13))){
var inst_56783 = (state_56807[(2)]);
var inst_56784 = fluree.db.util.async.throw_err(inst_56783);
var state_56807__$1 = state_56807;
var statearr_56813_56843 = state_56807__$1;
(statearr_56813_56843[(2)] = inst_56784);

(statearr_56813_56843[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56808 === (6))){
var state_56807__$1 = state_56807;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56807__$1,(9),seed);
} else {
if((state_val_56808 === (3))){
var inst_56805 = (state_56807[(2)]);
var state_56807__$1 = state_56807;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56807__$1,inst_56805);
} else {
if((state_val_56808 === (12))){
var inst_56787 = (state_56807[(7)]);
var inst_56787__$1 = (state_56807[(2)]);
var state_56807__$1 = (function (){var statearr_56814 = state_56807;
(statearr_56814[(7)] = inst_56787__$1);

return statearr_56814;
})();
if(cljs.core.truth_(inst_56787__$1)){
var statearr_56815_56844 = state_56807__$1;
(statearr_56815_56844[(1)] = (14));

} else {
var statearr_56816_56845 = state_56807__$1;
(statearr_56816_56845[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56808 === (2))){
var _ = (function (){var statearr_56817 = state_56807;
(statearr_56817[(4)] = cljs.core.cons((5),(state_56807[(4)])));

return statearr_56817;
})();
var inst_56772 = fluree.db.util.async.channel_QMARK_(seed);
var state_56807__$1 = state_56807;
if(inst_56772){
var statearr_56818_56846 = state_56807__$1;
(statearr_56818_56846[(1)] = (6));

} else {
var statearr_56819_56847 = state_56807__$1;
(statearr_56819_56847[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56808 === (11))){
var state_56807__$1 = state_56807;
var statearr_56821_56848 = state_56807__$1;
(statearr_56821_56848[(2)] = max);

(statearr_56821_56848[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56808 === (9))){
var inst_56775 = (state_56807[(2)]);
var inst_56776 = fluree.db.util.async.throw_err(inst_56775);
var state_56807__$1 = state_56807;
var statearr_56822_56849 = state_56807__$1;
(statearr_56822_56849[(2)] = inst_56776);

(statearr_56822_56849[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56808 === (5))){
var _ = (function (){var statearr_56823 = state_56807;
(statearr_56823[(4)] = cljs.core.rest((state_56807[(4)])));

return statearr_56823;
})();
var state_56807__$1 = state_56807;
var ex56820 = (state_56807__$1[(2)]);
var statearr_56824_56850 = state_56807__$1;
(statearr_56824_56850[(5)] = ex56820);


if((ex56820 instanceof Error)){
var statearr_56825_56851 = state_56807__$1;
(statearr_56825_56851[(1)] = (4));

(statearr_56825_56851[(5)] = null);

} else {
throw ex56820;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56808 === (14))){
var inst_56787 = (state_56807[(7)]);
var state_56807__$1 = state_56807;
var statearr_56826_56852 = state_56807__$1;
(statearr_56826_56852[(2)] = inst_56787);

(statearr_56826_56852[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56808 === (16))){
var inst_56779 = (state_56807[(8)]);
var inst_56791 = (state_56807[(2)]);
var inst_56792 = fluree.db.dbfunctions.internal.rand(inst_56779,inst_56791);
var inst_56793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56794 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56795 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56796 = [max,seed];
var inst_56797 = (new cljs.core.PersistentVector(null,2,(5),inst_56795,inst_56796,null));
var inst_56798 = ["rand",inst_56797,inst_56792];
var inst_56799 = cljs.core.PersistentHashMap.fromArrays(inst_56794,inst_56798);
var inst_56800 = [inst_56799,(10)];
var inst_56801 = (new cljs.core.PersistentVector(null,2,(5),inst_56793,inst_56800,null));
var inst_56802 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56801);
var _ = (function (){var statearr_56827 = state_56807;
(statearr_56827[(4)] = cljs.core.rest((state_56807[(4)])));

return statearr_56827;
})();
var state_56807__$1 = (function (){var statearr_56828 = state_56807;
(statearr_56828[(9)] = inst_56802);

return statearr_56828;
})();
var statearr_56829_56853 = state_56807__$1;
(statearr_56829_56853[(2)] = inst_56792);

(statearr_56829_56853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56808 === (10))){
var state_56807__$1 = state_56807;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56807__$1,(13),max);
} else {
if((state_val_56808 === (8))){
var inst_56779 = (state_56807[(2)]);
var inst_56780 = fluree.db.util.async.channel_QMARK_(max);
var state_56807__$1 = (function (){var statearr_56830 = state_56807;
(statearr_56830[(8)] = inst_56779);

return statearr_56830;
})();
if(inst_56780){
var statearr_56831_56854 = state_56807__$1;
(statearr_56831_56854[(1)] = (10));

} else {
var statearr_56832_56855 = state_56807__$1;
(statearr_56832_56855[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56833 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56833[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56833[(1)] = (1));

return statearr_56833;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56807){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56807);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56834){var ex__2730__auto__ = e56834;
var statearr_56835_56856 = state_56807;
(statearr_56835_56856[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56807[(4)]))){
var statearr_56836_56857 = state_56807;
(statearr_56836_56857[(1)] = cljs.core.first((state_56807[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56858 = state_56807;
state_56807 = G__56858;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56807){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56837 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56837[(6)] = c__2749__auto__);

return statearr_56837;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56879){
var state_val_56880 = (state_56879[(1)]);
if((state_val_56880 === (1))){
var state_56879__$1 = state_56879;
var statearr_56881_56896 = state_56879__$1;
(statearr_56881_56896[(2)] = null);

(statearr_56881_56896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56880 === (2))){
var _ = (function (){var statearr_56882 = state_56879;
(statearr_56882[(4)] = cljs.core.cons((5),(state_56879[(4)])));

return statearr_56882;
})();
var inst_56865 = cljs.core.random_uuid();
var inst_56866 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_56865);
var inst_56867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56868 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56869 = cljs.core.PersistentVector.EMPTY;
var inst_56870 = ["uuid",inst_56869,inst_56866];
var inst_56871 = cljs.core.PersistentHashMap.fromArrays(inst_56868,inst_56870);
var inst_56872 = [inst_56871,(10)];
var inst_56873 = (new cljs.core.PersistentVector(null,2,(5),inst_56867,inst_56872,null));
var inst_56874 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56873);
var ___$1 = (function (){var statearr_56883 = state_56879;
(statearr_56883[(4)] = cljs.core.rest((state_56879[(4)])));

return statearr_56883;
})();
var state_56879__$1 = (function (){var statearr_56884 = state_56879;
(statearr_56884[(7)] = inst_56874);

return statearr_56884;
})();
var statearr_56885_56897 = state_56879__$1;
(statearr_56885_56897[(2)] = inst_56866);

(statearr_56885_56897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56880 === (3))){
var inst_56877 = (state_56879[(2)]);
var state_56879__$1 = state_56879;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56879__$1,inst_56877);
} else {
if((state_val_56880 === (4))){
var inst_56859 = (state_56879[(2)]);
var state_56879__$1 = state_56879;
var statearr_56887_56898 = state_56879__$1;
(statearr_56887_56898[(2)] = inst_56859);

(statearr_56887_56898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56880 === (5))){
var _ = (function (){var statearr_56888 = state_56879;
(statearr_56888[(4)] = cljs.core.rest((state_56879[(4)])));

return statearr_56888;
})();
var state_56879__$1 = state_56879;
var ex56886 = (state_56879__$1[(2)]);
var statearr_56889_56899 = state_56879__$1;
(statearr_56889_56899[(5)] = ex56886);


if((ex56886 instanceof Error)){
var statearr_56890_56900 = state_56879__$1;
(statearr_56890_56900[(1)] = (4));

(statearr_56890_56900[(5)] = null);

} else {
throw ex56886;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0 = (function (){
var statearr_56891 = [null,null,null,null,null,null,null,null];
(statearr_56891[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__);

(statearr_56891[(1)] = (1));

return statearr_56891;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1 = (function (state_56879){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56879);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56892){var ex__2730__auto__ = e56892;
var statearr_56893_56901 = state_56879;
(statearr_56893_56901[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56879[(4)]))){
var statearr_56894_56902 = state_56879;
(statearr_56894_56902[(1)] = cljs.core.first((state_56879[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56903 = state_56879;
state_56879 = G__56903;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = function(state_56879){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1.call(this,state_56879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56895 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56895[(6)] = c__2749__auto__);

return statearr_56895;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56933){
var state_val_56934 = (state_56933[(1)]);
if((state_val_56934 === (7))){
var state_56933__$1 = state_56933;
var statearr_56935_56954 = state_56933__$1;
(statearr_56935_56954[(2)] = num);

(statearr_56935_56954[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56934 === (1))){
var state_56933__$1 = state_56933;
var statearr_56936_56955 = state_56933__$1;
(statearr_56936_56955[(2)] = null);

(statearr_56936_56955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56934 === (4))){
var inst_56904 = (state_56933[(2)]);
var state_56933__$1 = state_56933;
var statearr_56937_56956 = state_56933__$1;
(statearr_56937_56956[(2)] = inst_56904);

(statearr_56937_56956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56934 === (6))){
var state_56933__$1 = state_56933;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56933__$1,(9),num);
} else {
if((state_val_56934 === (3))){
var inst_56931 = (state_56933[(2)]);
var state_56933__$1 = state_56933;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56933__$1,inst_56931);
} else {
if((state_val_56934 === (2))){
var _ = (function (){var statearr_56939 = state_56933;
(statearr_56939[(4)] = cljs.core.cons((5),(state_56933[(4)])));

return statearr_56939;
})();
var inst_56910 = fluree.db.util.async.channel_QMARK_(num);
var state_56933__$1 = state_56933;
if(inst_56910){
var statearr_56940_56957 = state_56933__$1;
(statearr_56940_56957[(1)] = (6));

} else {
var statearr_56941_56958 = state_56933__$1;
(statearr_56941_56958[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56934 === (9))){
var inst_56913 = (state_56933[(2)]);
var inst_56914 = fluree.db.util.async.throw_err(inst_56913);
var state_56933__$1 = state_56933;
var statearr_56942_56959 = state_56933__$1;
(statearr_56942_56959[(2)] = inst_56914);

(statearr_56942_56959[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56934 === (5))){
var _ = (function (){var statearr_56943 = state_56933;
(statearr_56943[(4)] = cljs.core.rest((state_56933[(4)])));

return statearr_56943;
})();
var state_56933__$1 = state_56933;
var ex56938 = (state_56933__$1[(2)]);
var statearr_56944_56960 = state_56933__$1;
(statearr_56944_56960[(5)] = ex56938);


if((ex56938 instanceof Error)){
var statearr_56945_56961 = state_56933__$1;
(statearr_56945_56961[(1)] = (4));

(statearr_56945_56961[(5)] = null);

} else {
throw ex56938;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56934 === (8))){
var inst_56917 = (state_56933[(2)]);
var inst_56918 = fluree.db.dbfunctions.internal.ceil(inst_56917);
var inst_56919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56920 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56922 = [fluree.db.dbfunctions.fns.ceil];
var inst_56923 = (new cljs.core.PersistentVector(null,1,(5),inst_56921,inst_56922,null));
var inst_56924 = ["",inst_56923,inst_56918];
var inst_56925 = cljs.core.PersistentHashMap.fromArrays(inst_56920,inst_56924);
var inst_56926 = [inst_56925,(10)];
var inst_56927 = (new cljs.core.PersistentVector(null,2,(5),inst_56919,inst_56926,null));
var inst_56928 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56927);
var _ = (function (){var statearr_56946 = state_56933;
(statearr_56946[(4)] = cljs.core.rest((state_56933[(4)])));

return statearr_56946;
})();
var state_56933__$1 = (function (){var statearr_56947 = state_56933;
(statearr_56947[(7)] = inst_56928);

return statearr_56947;
})();
var statearr_56948_56962 = state_56933__$1;
(statearr_56948_56962[(2)] = inst_56918);

(statearr_56948_56962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0 = (function (){
var statearr_56949 = [null,null,null,null,null,null,null,null];
(statearr_56949[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__);

(statearr_56949[(1)] = (1));

return statearr_56949;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1 = (function (state_56933){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56933);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56950){var ex__2730__auto__ = e56950;
var statearr_56951_56963 = state_56933;
(statearr_56951_56963[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56933[(4)]))){
var statearr_56952_56964 = state_56933;
(statearr_56952_56964[(1)] = cljs.core.first((state_56933[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56965 = state_56933;
state_56933 = G__56965;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = function(state_56933){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1.call(this,state_56933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56953 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56953[(6)] = c__2749__auto__);

return statearr_56953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56995){
var state_val_56996 = (state_56995[(1)]);
if((state_val_56996 === (7))){
var state_56995__$1 = state_56995;
var statearr_56997_57016 = state_56995__$1;
(statearr_56997_57016[(2)] = num);

(statearr_56997_57016[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56996 === (1))){
var state_56995__$1 = state_56995;
var statearr_56998_57017 = state_56995__$1;
(statearr_56998_57017[(2)] = null);

(statearr_56998_57017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56996 === (4))){
var inst_56966 = (state_56995[(2)]);
var state_56995__$1 = state_56995;
var statearr_56999_57018 = state_56995__$1;
(statearr_56999_57018[(2)] = inst_56966);

(statearr_56999_57018[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56996 === (6))){
var state_56995__$1 = state_56995;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56995__$1,(9),num);
} else {
if((state_val_56996 === (3))){
var inst_56993 = (state_56995[(2)]);
var state_56995__$1 = state_56995;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56995__$1,inst_56993);
} else {
if((state_val_56996 === (2))){
var _ = (function (){var statearr_57001 = state_56995;
(statearr_57001[(4)] = cljs.core.cons((5),(state_56995[(4)])));

return statearr_57001;
})();
var inst_56972 = fluree.db.util.async.channel_QMARK_(num);
var state_56995__$1 = state_56995;
if(inst_56972){
var statearr_57002_57019 = state_56995__$1;
(statearr_57002_57019[(1)] = (6));

} else {
var statearr_57003_57020 = state_56995__$1;
(statearr_57003_57020[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56996 === (9))){
var inst_56975 = (state_56995[(2)]);
var inst_56976 = fluree.db.util.async.throw_err(inst_56975);
var state_56995__$1 = state_56995;
var statearr_57004_57021 = state_56995__$1;
(statearr_57004_57021[(2)] = inst_56976);

(statearr_57004_57021[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56996 === (5))){
var _ = (function (){var statearr_57005 = state_56995;
(statearr_57005[(4)] = cljs.core.rest((state_56995[(4)])));

return statearr_57005;
})();
var state_56995__$1 = state_56995;
var ex57000 = (state_56995__$1[(2)]);
var statearr_57006_57022 = state_56995__$1;
(statearr_57006_57022[(5)] = ex57000);


if((ex57000 instanceof Error)){
var statearr_57007_57023 = state_56995__$1;
(statearr_57007_57023[(1)] = (4));

(statearr_57007_57023[(5)] = null);

} else {
throw ex57000;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56996 === (8))){
var inst_56979 = (state_56995[(2)]);
var inst_56980 = fluree.db.dbfunctions.internal.floor(inst_56979);
var inst_56981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56982 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56984 = [fluree.db.dbfunctions.fns.floor];
var inst_56985 = (new cljs.core.PersistentVector(null,1,(5),inst_56983,inst_56984,null));
var inst_56986 = ["",inst_56985,inst_56980];
var inst_56987 = cljs.core.PersistentHashMap.fromArrays(inst_56982,inst_56986);
var inst_56988 = [inst_56987,(10)];
var inst_56989 = (new cljs.core.PersistentVector(null,2,(5),inst_56981,inst_56988,null));
var inst_56990 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56989);
var _ = (function (){var statearr_57008 = state_56995;
(statearr_57008[(4)] = cljs.core.rest((state_56995[(4)])));

return statearr_57008;
})();
var state_56995__$1 = (function (){var statearr_57009 = state_56995;
(statearr_57009[(7)] = inst_56990);

return statearr_57009;
})();
var statearr_57010_57024 = state_56995__$1;
(statearr_57010_57024[(2)] = inst_56980);

(statearr_57010_57024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0 = (function (){
var statearr_57011 = [null,null,null,null,null,null,null,null];
(statearr_57011[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__);

(statearr_57011[(1)] = (1));

return statearr_57011;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1 = (function (state_56995){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56995);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57012){var ex__2730__auto__ = e57012;
var statearr_57013_57025 = state_56995;
(statearr_57013_57025[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56995[(4)]))){
var statearr_57014_57026 = state_56995;
(statearr_57014_57026[(1)] = cljs.core.first((state_56995[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57027 = state_56995;
state_56995 = G__57027;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = function(state_56995){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1.call(this,state_56995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57015 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57015[(6)] = c__2749__auto__);

return statearr_57015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57052){
var state_val_57053 = (state_57052[(1)]);
if((state_val_57053 === (1))){
var state_57052__$1 = state_57052;
var statearr_57054_57069 = state_57052__$1;
(statearr_57054_57069[(2)] = null);

(statearr_57054_57069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57053 === (2))){
var _ = (function (){var statearr_57055 = state_57052;
(statearr_57055[(4)] = cljs.core.cons((5),(state_57052[(4)])));

return statearr_57055;
})();
var inst_57034 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_57052__$1 = state_57052;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57052__$1,(6),inst_57034);
} else {
if((state_val_57053 === (3))){
var inst_57050 = (state_57052[(2)]);
var state_57052__$1 = state_57052;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57052__$1,inst_57050);
} else {
if((state_val_57053 === (4))){
var inst_57028 = (state_57052[(2)]);
var state_57052__$1 = state_57052;
var statearr_57057_57070 = state_57052__$1;
(statearr_57057_57070[(2)] = inst_57028);

(statearr_57057_57070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57053 === (5))){
var _ = (function (){var statearr_57058 = state_57052;
(statearr_57058[(4)] = cljs.core.rest((state_57052[(4)])));

return statearr_57058;
})();
var state_57052__$1 = state_57052;
var ex57056 = (state_57052__$1[(2)]);
var statearr_57059_57071 = state_57052__$1;
(statearr_57059_57071[(5)] = ex57056);


if((ex57056 instanceof Error)){
var statearr_57060_57072 = state_57052__$1;
(statearr_57060_57072[(1)] = (4));

(statearr_57060_57072[(5)] = null);

} else {
throw ex57056;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57053 === (6))){
var inst_57036 = (state_57052[(2)]);
var inst_57037 = fluree.db.util.async.throw_err(inst_57036);
var inst_57038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57039 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57041 = [compare_val,new_val];
var inst_57042 = (new cljs.core.PersistentVector(null,2,(5),inst_57040,inst_57041,null));
var inst_57043 = ["",inst_57042,inst_57037];
var inst_57044 = cljs.core.PersistentHashMap.fromArrays(inst_57039,inst_57043);
var inst_57045 = [inst_57044,(10)];
var inst_57046 = (new cljs.core.PersistentVector(null,2,(5),inst_57038,inst_57045,null));
var inst_57047 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57046);
var _ = (function (){var statearr_57061 = state_57052;
(statearr_57061[(4)] = cljs.core.rest((state_57052[(4)])));

return statearr_57061;
})();
var state_57052__$1 = (function (){var statearr_57062 = state_57052;
(statearr_57062[(7)] = inst_57047);

return statearr_57062;
})();
var statearr_57063_57073 = state_57052__$1;
(statearr_57063_57073[(2)] = inst_57037);

(statearr_57063_57073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_57064 = [null,null,null,null,null,null,null,null];
(statearr_57064[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__);

(statearr_57064[(1)] = (1));

return statearr_57064;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1 = (function (state_57052){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57052);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57065){var ex__2730__auto__ = e57065;
var statearr_57066_57074 = state_57052;
(statearr_57066_57074[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57052[(4)]))){
var statearr_57067_57075 = state_57052;
(statearr_57067_57075[(1)] = cljs.core.first((state_57052[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57076 = state_57052;
state_57052 = G__57076;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = function(state_57052){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1.call(this,state_57052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57068 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57068[(6)] = c__2749__auto__);

return statearr_57068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
