// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__26374 = arguments.length;
switch (G__26374) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,ledger){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,ledger,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,ledger,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__26377 = arguments.length;
switch (G__26377) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___26430 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26408){
var state_val_26409 = (state_26408[(1)]);
if((state_val_26409 === (1))){
var state_26408__$1 = state_26408;
var statearr_26410_26431 = state_26408__$1;
(statearr_26410_26431[(2)] = null);

(statearr_26410_26431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26409 === (2))){
var _ = (function (){var statearr_26411 = state_26408;
(statearr_26411[(4)] = cljs.core.cons((5),(state_26408[(4)])));

return statearr_26411;
})();
var inst_26385 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_26408__$1 = state_26408;
if(cljs.core.truth_(inst_26385)){
var statearr_26412_26432 = state_26408__$1;
(statearr_26412_26432[(1)] = (6));

} else {
var statearr_26413_26433 = state_26408__$1;
(statearr_26413_26433[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26409 === (3))){
var inst_26406 = (state_26408[(2)]);
var state_26408__$1 = state_26408;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26408__$1,inst_26406);
} else {
if((state_val_26409 === (4))){
var inst_26378 = (state_26408[(2)]);
var inst_26379 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_26378);
var state_26408__$1 = state_26408;
var statearr_26415_26434 = state_26408__$1;
(statearr_26415_26434[(2)] = inst_26379);

(statearr_26415_26434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26409 === (5))){
var _ = (function (){var statearr_26416 = state_26408;
(statearr_26416[(4)] = cljs.core.rest((state_26408[(4)])));

return statearr_26416;
})();
var state_26408__$1 = state_26408;
var ex26414 = (state_26408__$1[(2)]);
var statearr_26417_26435 = state_26408__$1;
(statearr_26417_26435[(5)] = ex26414);


var statearr_26418_26436 = state_26408__$1;
(statearr_26418_26436[(1)] = (4));

(statearr_26418_26436[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26409 === (6))){
var inst_26387 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26388 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_26389 = cljs.core.PersistentHashMap.fromArrays(inst_26387,inst_26388);
var inst_26390 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_26389);
var inst_26391 = (function(){throw inst_26390})();
var state_26408__$1 = state_26408;
var statearr_26419_26437 = state_26408__$1;
(statearr_26419_26437[(2)] = inst_26391);

(statearr_26419_26437[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26409 === (7))){
var inst_26393 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_26394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26395 = [operation,data,pc,opts];
var inst_26396 = (new cljs.core.PersistentVector(null,4,(5),inst_26394,inst_26395,null));
var inst_26397 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_26393,inst_26396);
var inst_26398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26399 = [operation,data,pc,opts];
var inst_26400 = (new cljs.core.PersistentVector(null,4,(5),inst_26398,inst_26399,null));
var inst_26401 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("Put operation on connection req-chan: ",inst_26400) : fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_26400));
var state_26408__$1 = (function (){var statearr_26420 = state_26408;
(statearr_26420[(7)] = inst_26397);

return statearr_26420;
})();
var statearr_26421_26438 = state_26408__$1;
(statearr_26421_26438[(2)] = inst_26401);

(statearr_26421_26438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26409 === (8))){
var inst_26403 = (state_26408[(2)]);
var _ = (function (){var statearr_26422 = state_26408;
(statearr_26422[(4)] = cljs.core.rest((state_26408[(4)])));

return statearr_26422;
})();
var state_26408__$1 = state_26408;
var statearr_26423_26439 = state_26408__$1;
(statearr_26423_26439[(2)] = inst_26403);

(statearr_26423_26439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2727__auto__ = null;
var fluree$db$operations$state_machine__2727__auto____0 = (function (){
var statearr_26424 = [null,null,null,null,null,null,null,null];
(statearr_26424[(0)] = fluree$db$operations$state_machine__2727__auto__);

(statearr_26424[(1)] = (1));

return statearr_26424;
});
var fluree$db$operations$state_machine__2727__auto____1 = (function (state_26408){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26408);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26425){var ex__2730__auto__ = e26425;
var statearr_26426_26440 = state_26408;
(statearr_26426_26440[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26408[(4)]))){
var statearr_26427_26441 = state_26408;
(statearr_26427_26441[(1)] = cljs.core.first((state_26408[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26442 = state_26408;
state_26408 = G__26442;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2727__auto__ = function(state_26408){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2727__auto____1.call(this,state_26408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2727__auto____0;
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2727__auto____1;
return fluree$db$operations$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26428 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26428[(6)] = c__2749__auto___26430);

return statearr_26428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__26444 = arguments.length;
switch (G__26444) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__26445){
var map__26446 = p__26445;
var map__26446__$1 = cljs.core.__destructure_map(map__26446);
var opts = map__26446__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26446__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__26447 = session;
var map__26447__$1 = cljs.core.__destructure_map(map__26447);
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26447__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26447__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26447__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4870__auto__ = [];
var len__4864__auto___26474 = arguments.length;
var i__4865__auto___26475 = (0);
while(true){
if((i__4865__auto___26475 < len__4864__auto___26474)){
args__4870__auto__.push((arguments[i__4865__auto___26475]));

var G__26476 = (i__4865__auto___26475 + (1));
i__4865__auto___26475 = G__26476;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__26451){
var vec__26452 = p__26451;
var map__26455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26452,(0),null);
var map__26455__$1 = cljs.core.__destructure_map(map__26455);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26455__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26455__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__26452;
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26467){
var state_val_26468 = (state_26467[(1)]);
if((state_val_26468 === (1))){
var inst_26457 = session;
var inst_26458 = cljs.core.__destructure_map(inst_26457);
var inst_26459 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26458,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_26460 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26458,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_26461 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26458,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_26462 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_26463 = [inst_26459,inst_26460,toBlock,toTime];
var inst_26464 = cljs.core.PersistentHashMap.fromArrays(inst_26462,inst_26463);
var inst_26465 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_26461,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_26464);
var state_26467__$1 = state_26467;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26467__$1,inst_26465);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2727__auto__ = null;
var fluree$db$operations$state_machine__2727__auto____0 = (function (){
var statearr_26469 = [null,null,null,null,null,null,null];
(statearr_26469[(0)] = fluree$db$operations$state_machine__2727__auto__);

(statearr_26469[(1)] = (1));

return statearr_26469;
});
var fluree$db$operations$state_machine__2727__auto____1 = (function (state_26467){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26467);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26470){var ex__2730__auto__ = e26470;
var statearr_26471_26477 = state_26467;
(statearr_26471_26477[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26467[(4)]))){
var statearr_26472_26478 = state_26467;
(statearr_26472_26478[(1)] = cljs.core.first((state_26467[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26479 = state_26467;
state_26467 = G__26479;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2727__auto__ = function(state_26467){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2727__auto____1.call(this,state_26467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2727__auto____0;
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2727__auto____1;
return fluree$db$operations$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26473 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26473[(6)] = c__2749__auto__);

return statearr_26473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq26449){
var G__26450 = cljs.core.first(seq26449);
var seq26449__$1 = cljs.core.next(seq26449);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26450,seq26449__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__26480 = session;
var map__26480__$1 = cljs.core.__destructure_map(map__26480);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26480__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26480__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26480__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("Sending transaction async: ",tx_map) : fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__26482 = arguments.length;
switch (G__26482) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__26483 = opts;
var map__26483__$1 = cljs.core.__destructure_map(map__26483);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26483__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26483__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4253__auto__ = auth;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return jwt;
}
})();
var _ = (function (){var G__26484 = "Subscribe to: ";
var G__26485 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var G__26486 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var G__26487 = auth_or_jwt;
return (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$4(G__26484,G__26485,G__26486,G__26487) : fluree.db.util.log.trace.call(null,G__26484,G__26485,G__26486,G__26487));
})();
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsubscribe","unsubscribe",632650147),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null));
});
