// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.query.analytical_parse');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e18126){var e = e18126;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__18127_SHARP_){
var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__18127_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__18127_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__18127_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__18127_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__18128_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18128_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__18129_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18129_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
if(and__4251__auto__){
return fluree.db.query.analytical_parse.query_fn_QMARK_(key);
} else {
return and__4251__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4253__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__18134 = fluree.db.query.analytical_filter.extract_filter_fn(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18134,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18134,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__18130_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18130_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4251__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4251__auto__;
}
})())){
var vec__18137 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18137,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18137,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4253__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__18131_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18131_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__18132_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18132_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__18133_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18133_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18140_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__18140_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (add_amount > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fuel;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4251__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5802__auto__ = (function (){var G__18141 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__18141) : intersecting_vars.call(null,G__18141));
})();
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__18144,optional_QMARK_,fuel,max_fuel){
var map__18145 = p__18144;
var map__18145__$1 = cljs.core.__destructure_map(map__18145);
var res = map__18145__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18145__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18211){
var state_val_18212 = (state_18211[(1)]);
if((state_val_18212 === (7))){
var inst_18200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18201 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_18202 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_18201,clause);
var inst_18203 = [null,inst_18202];
var inst_18204 = (new cljs.core.PersistentVector(null,2,(5),inst_18200,inst_18203,null));
var state_18211__$1 = state_18211;
var statearr_18213_18241 = state_18211__$1;
(statearr_18213_18241[(2)] = inst_18204);

(statearr_18213_18241[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (1))){
var state_18211__$1 = state_18211;
var statearr_18214_18242 = state_18211__$1;
(statearr_18214_18242[(2)] = null);

(statearr_18214_18242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (4))){
var inst_18146 = (state_18211[(2)]);
var state_18211__$1 = state_18211;
var statearr_18215_18243 = state_18211__$1;
(statearr_18215_18243[(2)] = inst_18146);

(statearr_18215_18243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (15))){
var inst_18189 = (state_18211[(2)]);
var inst_18190 = fluree.db.util.async.throw_err(inst_18189);
var inst_18191 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_18190);
var inst_18192 = cljs.core.count(inst_18191);
var inst_18193 = fluree.db.query.analytical.add_fuel(inst_18192,fuel,max_fuel);
var inst_18194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18195 = [inst_18190,r];
var inst_18196 = (new cljs.core.PersistentVector(null,2,(5),inst_18194,inst_18195,null));
var state_18211__$1 = (function (){var statearr_18216 = state_18211;
(statearr_18216[(7)] = inst_18193);

return statearr_18216;
})();
var statearr_18217_18244 = state_18211__$1;
(statearr_18217_18244[(2)] = inst_18196);

(statearr_18217_18244[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (13))){
var inst_18155 = (state_18211[(8)]);
var inst_18168 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_18169 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_18168);
var inst_18170 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_18155);
var inst_18171 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_18170);
var inst_18172 = cljs.core.set(inst_18171);
var inst_18173 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_18169);
var inst_18174 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_18173);
var inst_18175 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_18172,inst_18174);
var inst_18176 = (function (){var all_wd = inst_18155;
var optional = inst_18169;
var all_wd_vars = inst_18172;
var all_vars = inst_18175;
return (function (p1__18142_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__18142_SHARP_) : all_vars.call(null,p1__18142_SHARP_));
});
})();
var inst_18177 = cljs.core.keys(vars);
var inst_18178 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_18176,inst_18177);
var inst_18179 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_18178);
var inst_18180 = cljs.core.set(inst_18179);
var inst_18181 = (function (){var all_wd = inst_18155;
var optional = inst_18169;
var all_wd_vars = inst_18172;
var all_vars = inst_18175;
var intersecting_vars = inst_18180;
return (function (p1__18143_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__18143_SHARP_);
});
})();
var inst_18182 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_18181,inst_18155);
var inst_18183 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_18182);
var inst_18184 = fluree.db.query.analytical.select_from_tuples(inst_18183,res);
var inst_18185 = fluree.db.query.analytical.replace_vars_wikidata(inst_18155,inst_18180,vars);
var inst_18186 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_18180,inst_18175);
var inst_18187 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_18185,inst_18183,inst_18184,inst_18186,inst_18169);
var state_18211__$1 = state_18211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18211__$1,(15),inst_18187);
} else {
if((state_val_18212 === (6))){
var inst_18156 = (state_18211[(9)]);
var inst_18154 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_18155 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_18154);
var inst_18156__$1 = optional_QMARK_;
var state_18211__$1 = (function (){var statearr_18218 = state_18211;
(statearr_18218[(9)] = inst_18156__$1);

(statearr_18218[(8)] = inst_18155);

return statearr_18218;
})();
if(cljs.core.truth_(inst_18156__$1)){
var statearr_18219_18245 = state_18211__$1;
(statearr_18219_18245[(1)] = (9));

} else {
var statearr_18220_18246 = state_18211__$1;
(statearr_18220_18246[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (3))){
var inst_18209 = (state_18211[(2)]);
var state_18211__$1 = state_18211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18211__$1,inst_18209);
} else {
if((state_val_18212 === (12))){
var inst_18164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18165 = [null,r];
var inst_18166 = (new cljs.core.PersistentVector(null,2,(5),inst_18164,inst_18165,null));
var state_18211__$1 = state_18211;
var statearr_18221_18247 = state_18211__$1;
(statearr_18221_18247[(2)] = inst_18166);

(statearr_18221_18247[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (2))){
var _ = (function (){var statearr_18222 = state_18211;
(statearr_18222[(4)] = cljs.core.cons((5),(state_18211[(4)])));

return statearr_18222;
})();
var inst_18152 = (r == null);
var state_18211__$1 = state_18211;
if(cljs.core.truth_(inst_18152)){
var statearr_18223_18248 = state_18211__$1;
(statearr_18223_18248[(1)] = (6));

} else {
var statearr_18224_18249 = state_18211__$1;
(statearr_18224_18249[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (11))){
var inst_18162 = (state_18211[(2)]);
var state_18211__$1 = state_18211;
if(cljs.core.truth_(inst_18162)){
var statearr_18226_18250 = state_18211__$1;
(statearr_18226_18250[(1)] = (12));

} else {
var statearr_18227_18251 = state_18211__$1;
(statearr_18227_18251[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (9))){
var inst_18155 = (state_18211[(8)]);
var inst_18158 = cljs.core.empty_QMARK_(inst_18155);
var inst_18159 = (!(inst_18158));
var state_18211__$1 = state_18211;
var statearr_18228_18252 = state_18211__$1;
(statearr_18228_18252[(2)] = inst_18159);

(statearr_18228_18252[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (5))){
var _ = (function (){var statearr_18229 = state_18211;
(statearr_18229[(4)] = cljs.core.rest((state_18211[(4)])));

return statearr_18229;
})();
var state_18211__$1 = state_18211;
var ex18225 = (state_18211__$1[(2)]);
var statearr_18230_18253 = state_18211__$1;
(statearr_18230_18253[(5)] = ex18225);


if((ex18225 instanceof Error)){
var statearr_18231_18254 = state_18211__$1;
(statearr_18231_18254[(1)] = (4));

(statearr_18231_18254[(5)] = null);

} else {
throw ex18225;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (14))){
var inst_18198 = (state_18211[(2)]);
var state_18211__$1 = state_18211;
var statearr_18232_18255 = state_18211__$1;
(statearr_18232_18255[(2)] = inst_18198);

(statearr_18232_18255[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (10))){
var inst_18156 = (state_18211[(9)]);
var state_18211__$1 = state_18211;
var statearr_18233_18256 = state_18211__$1;
(statearr_18233_18256[(2)] = inst_18156);

(statearr_18233_18256[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18212 === (8))){
var inst_18206 = (state_18211[(2)]);
var _ = (function (){var statearr_18234 = state_18211;
(statearr_18234[(4)] = cljs.core.rest((state_18211[(4)])));

return statearr_18234;
})();
var state_18211__$1 = state_18211;
var statearr_18235_18257 = state_18211__$1;
(statearr_18235_18257[(2)] = inst_18206);

(statearr_18235_18257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_18236 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18236[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__);

(statearr_18236[(1)] = (1));

return statearr_18236;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1 = (function (state_18211){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18211);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18237){var ex__2730__auto__ = e18237;
var statearr_18238_18258 = state_18211;
(statearr_18238_18258[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18211[(4)]))){
var statearr_18239_18259 = state_18211;
(statearr_18239_18259[(1)] = cljs.core.first((state_18211[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18260 = state_18211;
state_18211 = G__18260;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__ = function(state_18211){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1.call(this,state_18211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18240 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18240[(6)] = c__2749__auto__);

return statearr_18240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(ledger_id){
return cljs.core.re_find(/[a-z]+/,ledger_id);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(ledger_id){
return cljs.core.re_find(/[A-Z0-9]+/,ledger_id);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__18262 = arguments.length;
switch (G__18262) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18356){
var state_val_18357 = (state_18356[(1)]);
if((state_val_18357 === (7))){
var inst_18269 = (state_18356[(7)]);
var inst_18279 = clojure.string.starts_with_QMARK_(inst_18269,"$fdb");
var state_18356__$1 = state_18356;
if(inst_18279){
var statearr_18358_18407 = state_18356__$1;
(statearr_18358_18407[(1)] = (9));

} else {
var statearr_18359_18408 = state_18356__$1;
(statearr_18359_18408[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (20))){
var state_18356__$1 = state_18356;
var statearr_18360_18409 = state_18356__$1;
(statearr_18360_18409[(2)] = null);

(statearr_18360_18409[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (27))){
var inst_18319 = (state_18356[(8)]);
var state_18356__$1 = state_18356;
var statearr_18361_18410 = state_18356__$1;
(statearr_18361_18410[(2)] = inst_18319);

(statearr_18361_18410[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (1))){
var state_18356__$1 = state_18356;
var statearr_18362_18411 = state_18356__$1;
(statearr_18362_18411[(2)] = null);

(statearr_18362_18411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (24))){
var inst_18342 = (state_18356[(2)]);
var state_18356__$1 = state_18356;
var statearr_18363_18412 = state_18356__$1;
(statearr_18363_18412[(2)] = inst_18342);

(statearr_18363_18412[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (4))){
var inst_18263 = (state_18356[(2)]);
var state_18356__$1 = state_18356;
var statearr_18364_18413 = state_18356__$1;
(statearr_18364_18413[(2)] = inst_18263);

(statearr_18364_18413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (15))){
var inst_18286 = (state_18356[(9)]);
var inst_18292 = (state_18356[(2)]);
var inst_18293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18294 = cljs.core.PersistentVector.EMPTY;
var inst_18295 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_18296 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_18294,inst_18295);
var inst_18297 = [inst_18286,inst_18296];
var inst_18298 = (new cljs.core.PersistentVector(null,2,(5),inst_18293,inst_18297,null));
var state_18356__$1 = (function (){var statearr_18365 = state_18356;
(statearr_18365[(10)] = inst_18292);

return statearr_18365;
})();
var statearr_18366_18414 = state_18356__$1;
(statearr_18366_18414[(2)] = inst_18298);

(statearr_18366_18414[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (21))){
var inst_18345 = (state_18356[(2)]);
var state_18356__$1 = state_18356;
var statearr_18367_18415 = state_18356__$1;
(statearr_18367_18415[(2)] = inst_18345);

(statearr_18367_18415[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (13))){
var inst_18286 = (state_18356[(9)]);
var inst_18289 = (function(){throw inst_18286})();
var state_18356__$1 = state_18356;
var statearr_18368_18416 = state_18356__$1;
(statearr_18368_18416[(2)] = inst_18289);

(statearr_18368_18416[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (22))){
var inst_18308 = (state_18356[(11)]);
var inst_18310 = (state_18356[(12)]);
var inst_18312 = fluree.db.query.analytical.parse_block_from_source(inst_18308);
var inst_18313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18314 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_18310];
var inst_18315 = (new cljs.core.PersistentVector(null,2,(5),inst_18313,inst_18314,null));
var inst_18316 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_18315);
var state_18356__$1 = (function (){var statearr_18369 = state_18356;
(statearr_18369[(13)] = inst_18312);

return statearr_18369;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18356__$1,(25),inst_18316);
} else {
if((state_val_18357 === (29))){
var inst_18323 = (state_18356[(2)]);
var inst_18324 = fluree.db.util.async.throw_err(inst_18323);
var state_18356__$1 = state_18356;
var statearr_18370_18417 = state_18356__$1;
(statearr_18370_18417[(2)] = inst_18324);

(statearr_18370_18417[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (6))){
var inst_18272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18273 = cljs.core.PersistentVector.EMPTY;
var inst_18274 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_18275 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_18273,inst_18274);
var inst_18276 = [db,inst_18275];
var inst_18277 = (new cljs.core.PersistentVector(null,2,(5),inst_18272,inst_18276,null));
var state_18356__$1 = state_18356;
var statearr_18371_18418 = state_18356__$1;
(statearr_18371_18418[(2)] = inst_18277);

(statearr_18371_18418[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (28))){
var inst_18327 = (state_18356[(2)]);
var inst_18328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18329 = cljs.core.PersistentVector.EMPTY;
var inst_18330 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_18331 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_18329,inst_18330);
var inst_18332 = [inst_18327,inst_18331];
var inst_18333 = (new cljs.core.PersistentVector(null,2,(5),inst_18328,inst_18332,null));
var state_18356__$1 = state_18356;
var statearr_18372_18419 = state_18356__$1;
(statearr_18372_18419[(2)] = inst_18333);

(statearr_18372_18419[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (25))){
var inst_18312 = (state_18356[(13)]);
var inst_18318 = (state_18356[(2)]);
var inst_18319 = fluree.db.util.async.throw_err(inst_18318);
var state_18356__$1 = (function (){var statearr_18373 = state_18356;
(statearr_18373[(8)] = inst_18319);

return statearr_18373;
})();
if(cljs.core.truth_(inst_18312)){
var statearr_18374_18420 = state_18356__$1;
(statearr_18374_18420[(1)] = (26));

} else {
var statearr_18375_18421 = state_18356__$1;
(statearr_18375_18421[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (17))){
var state_18356__$1 = state_18356;
var statearr_18376_18422 = state_18356__$1;
(statearr_18376_18422[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (3))){
var inst_18354 = (state_18356[(2)]);
var state_18356__$1 = state_18356;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18356__$1,inst_18354);
} else {
if((state_val_18357 === (12))){
var inst_18286 = (state_18356[(9)]);
var inst_18285 = (state_18356[(2)]);
var inst_18286__$1 = fluree.db.util.async.throw_err(inst_18285);
var inst_18287 = fluree.db.util.core.exception_QMARK_(inst_18286__$1);
var state_18356__$1 = (function (){var statearr_18378 = state_18356;
(statearr_18378[(9)] = inst_18286__$1);

return statearr_18378;
})();
if(inst_18287){
var statearr_18379_18423 = state_18356__$1;
(statearr_18379_18423[(1)] = (13));

} else {
var statearr_18380_18424 = state_18356__$1;
(statearr_18380_18424[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (2))){
var inst_18269 = (state_18356[(7)]);
var _ = (function (){var statearr_18381 = state_18356;
(statearr_18381[(4)] = cljs.core.cons((5),(state_18356[(4)])));

return statearr_18381;
})();
var inst_18269__$1 = cljs.core.first(clause);
var inst_18270 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_18269__$1);
var state_18356__$1 = (function (){var statearr_18382 = state_18356;
(statearr_18382[(7)] = inst_18269__$1);

return statearr_18382;
})();
if(inst_18270){
var statearr_18383_18425 = state_18356__$1;
(statearr_18383_18425[(1)] = (6));

} else {
var statearr_18384_18426 = state_18356__$1;
(statearr_18384_18426[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (23))){
var inst_18269 = (state_18356[(7)]);
var inst_18335 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18269)," is not supported in Fluree"].join('');
var inst_18336 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18337 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_18338 = cljs.core.PersistentHashMap.fromArrays(inst_18336,inst_18337);
var inst_18339 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18335,inst_18338);
var inst_18340 = (function(){throw inst_18339})();
var state_18356__$1 = state_18356;
var statearr_18385_18427 = state_18356__$1;
(statearr_18385_18427[(2)] = inst_18340);

(statearr_18385_18427[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (19))){
var inst_18310 = (state_18356[(12)]);
var inst_18269 = (state_18356[(7)]);
var inst_18307 = fluree.db.query.analytical.isolate_source_name(inst_18269);
var inst_18308 = fluree.db.query.analytical.isolate_source_block(inst_18269);
var inst_18309 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_18307);
var inst_18310__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_18309);
var state_18356__$1 = (function (){var statearr_18386 = state_18356;
(statearr_18386[(11)] = inst_18308);

(statearr_18386[(12)] = inst_18310__$1);

return statearr_18386;
})();
if(cljs.core.truth_(inst_18310__$1)){
var statearr_18387_18428 = state_18356__$1;
(statearr_18387_18428[(1)] = (22));

} else {
var statearr_18388_18429 = state_18356__$1;
(statearr_18388_18429[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (11))){
var inst_18349 = (state_18356[(2)]);
var state_18356__$1 = state_18356;
var statearr_18390_18430 = state_18356__$1;
(statearr_18390_18430[(2)] = inst_18349);

(statearr_18390_18430[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (9))){
var inst_18269 = (state_18356[(7)]);
var inst_18281 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_18269,(4));
var inst_18282 = fluree.db.query.analytical.parse_block_from_source(inst_18281);
var inst_18283 = fluree.db.time_travel.as_of_block(db,inst_18282);
var state_18356__$1 = state_18356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18356__$1,(12),inst_18283);
} else {
if((state_val_18357 === (5))){
var _ = (function (){var statearr_18391 = state_18356;
(statearr_18391[(4)] = cljs.core.rest((state_18356[(4)])));

return statearr_18391;
})();
var state_18356__$1 = state_18356;
var ex18389 = (state_18356__$1[(2)]);
var statearr_18392_18431 = state_18356__$1;
(statearr_18392_18431[(5)] = ex18389);


if((ex18389 instanceof Error)){
var statearr_18393_18432 = state_18356__$1;
(statearr_18393_18432[(1)] = (4));

(statearr_18393_18432[(5)] = null);

} else {
throw ex18389;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (14))){
var state_18356__$1 = state_18356;
var statearr_18394_18433 = state_18356__$1;
(statearr_18394_18433[(2)] = null);

(statearr_18394_18433[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (26))){
var inst_18312 = (state_18356[(13)]);
var inst_18319 = (state_18356[(8)]);
var inst_18321 = fluree.db.time_travel.as_of_block(inst_18319,inst_18312);
var state_18356__$1 = state_18356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18356__$1,(29),inst_18321);
} else {
if((state_val_18357 === (16))){
var inst_18302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18303 = ["$wd",clause];
var inst_18304 = (new cljs.core.PersistentVector(null,2,(5),inst_18302,inst_18303,null));
var state_18356__$1 = state_18356;
var statearr_18395_18434 = state_18356__$1;
(statearr_18395_18434[(2)] = inst_18304);

(statearr_18395_18434[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (10))){
var inst_18269 = (state_18356[(7)]);
var inst_18300 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_18269);
var state_18356__$1 = state_18356;
if(inst_18300){
var statearr_18396_18435 = state_18356__$1;
(statearr_18396_18435[(1)] = (16));

} else {
var statearr_18397_18436 = state_18356__$1;
(statearr_18397_18436[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (18))){
var inst_18347 = (state_18356[(2)]);
var state_18356__$1 = state_18356;
var statearr_18398_18437 = state_18356__$1;
(statearr_18398_18437[(2)] = inst_18347);

(statearr_18398_18437[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18357 === (8))){
var inst_18351 = (state_18356[(2)]);
var _ = (function (){var statearr_18399 = state_18356;
(statearr_18399[(4)] = cljs.core.rest((state_18356[(4)])));

return statearr_18399;
})();
var state_18356__$1 = state_18356;
var statearr_18400_18438 = state_18356__$1;
(statearr_18400_18438[(2)] = inst_18351);

(statearr_18400_18438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2727__auto__ = null;
var fluree$db$query$analytical$state_machine__2727__auto____0 = (function (){
var statearr_18401 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18401[(0)] = fluree$db$query$analytical$state_machine__2727__auto__);

(statearr_18401[(1)] = (1));

return statearr_18401;
});
var fluree$db$query$analytical$state_machine__2727__auto____1 = (function (state_18356){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18356);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18402){var ex__2730__auto__ = e18402;
var statearr_18403_18439 = state_18356;
(statearr_18403_18439[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18356[(4)]))){
var statearr_18404_18440 = state_18356;
(statearr_18404_18440[(1)] = cljs.core.first((state_18356[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18441 = state_18356;
state_18356 = G__18441;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2727__auto__ = function(state_18356){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2727__auto____1.call(this,state_18356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2727__auto____0;
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2727__auto____1;
return fluree$db$query$analytical$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18405 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18405[(6)] = c__2749__auto__);

return statearr_18405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__18442){
var vec__18443 = p__18442;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18443,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18443,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18446_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__18446_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__18450 = subjects;
var vec__18451 = G__18450;
var seq__18452 = cljs.core.seq(vec__18451);
var first__18453 = cljs.core.first(seq__18452);
var seq__18452__$1 = cljs.core.next(seq__18452);
var subject = first__18453;
var r = seq__18452__$1;
var acc = expanded_map;
var G__18450__$1 = G__18450;
var acc__$1 = acc;
while(true){
var vec__18457 = G__18450__$1;
var seq__18458 = cljs.core.seq(vec__18457);
var first__18459 = cljs.core.first(seq__18458);
var seq__18458__$1 = cljs.core.next(seq__18458);
var subject__$1 = first__18459;
var r__$1 = seq__18458__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__18460 = r__$1;
var G__18461 = acc__$2;
G__18450__$1 = G__18460;
acc__$1 = G__18461;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__18450__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__18457,seq__18458,first__18459,seq__18458__$1,subject__$1,r__$1,acc__$2,G__18450,vec__18451,seq__18452,first__18453,seq__18452__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4253__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__18450__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__18457,seq__18458,first__18459,seq__18458__$1,subject__$1,r__$1,acc__$2,G__18450,vec__18451,seq__18452,first__18453,seq__18452__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__18450__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__18457,seq__18458,first__18459,seq__18458__$1,subject__$1,r__$1,acc__$2,G__18450,vec__18451,seq__18452,first__18453,seq__18452__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__18450__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__18457,seq__18458,first__18459,seq__18458__$1,subject__$1,r__$1,acc__$2,G__18450,vec__18451,seq__18452,first__18453,seq__18452__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__18450__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__18457,seq__18458,first__18459,seq__18458__$1,subject__$1,r__$1,acc__$2,G__18450,vec__18451,seq__18452,first__18453,seq__18452__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__18450__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__18457,seq__18458,first__18459,seq__18458__$1,subject__$1,r__$1,acc__$2,G__18450,vec__18451,seq__18452,first__18453,seq__18452__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__18462 = r__$1;
var G__18463 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__18450__$1 = G__18462;
acc__$1 = G__18463;
continue;
} else {
var G__18464 = subjects;
var G__18465 = acc_STAR_;
G__18450__$1 = G__18464;
acc__$1 = G__18465;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18466_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__18466_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18557){
var state_val_18558 = (state_18557[(1)]);
if((state_val_18558 === (7))){
var state_18557__$1 = state_18557;
var statearr_18559_18605 = state_18557__$1;
(statearr_18559_18605[(2)] = (100));

(statearr_18559_18605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (20))){
var inst_18506 = (state_18557[(7)]);
var state_18557__$1 = state_18557;
var statearr_18560_18606 = state_18557__$1;
(statearr_18560_18606[(2)] = inst_18506);

(statearr_18560_18606[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (1))){
var state_18557__$1 = state_18557;
var statearr_18561_18607 = state_18557__$1;
(statearr_18561_18607[(2)] = null);

(statearr_18561_18607[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (24))){
var inst_18543 = (state_18557[(8)]);
var inst_18545 = (state_18557[(9)]);
var inst_18478 = (state_18557[(10)]);
var inst_18544 = (state_18557[(11)]);
var inst_18548 = (function (){var max_depth = inst_18478;
var recur_map__$1 = inst_18544;
var subjects = inst_18543;
var tuples = inst_18545;
return (function (p1__18467_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__18467_SHARP_)],null));
});
})();
var inst_18549 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_18548,inst_18545);
var inst_18550 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_18549);
var state_18557__$1 = state_18557;
var statearr_18562_18608 = state_18557__$1;
(statearr_18562_18608[(2)] = inst_18550);

(statearr_18562_18608[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (4))){
var inst_18468 = (state_18557[(2)]);
var state_18557__$1 = state_18557;
var statearr_18563_18609 = state_18557__$1;
(statearr_18563_18609[(2)] = inst_18468);

(statearr_18563_18609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (15))){
var inst_18491 = (state_18557[(12)]);
var inst_18502 = cljs.core.PersistentVector.EMPTY;
var inst_18503 = cljs.core.seq(inst_18491);
var inst_18504 = cljs.core.first(inst_18503);
var inst_18505 = cljs.core.next(inst_18503);
var inst_18506 = inst_18502;
var inst_18507 = inst_18491;
var state_18557__$1 = (function (){var statearr_18564 = state_18557;
(statearr_18564[(7)] = inst_18506);

(statearr_18564[(13)] = inst_18507);

(statearr_18564[(14)] = inst_18505);

(statearr_18564[(15)] = inst_18504);

return statearr_18564;
})();
var statearr_18565_18610 = state_18557__$1;
(statearr_18565_18610[(2)] = null);

(statearr_18565_18610[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (21))){
var inst_18527 = (state_18557[(2)]);
var state_18557__$1 = state_18557;
var statearr_18566_18611 = state_18557__$1;
(statearr_18566_18611[(2)] = inst_18527);

(statearr_18566_18611[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (13))){
var inst_18540 = (state_18557[(2)]);
var state_18557__$1 = state_18557;
var statearr_18567_18612 = state_18557__$1;
(statearr_18567_18612[(2)] = inst_18540);

(statearr_18567_18612[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (22))){
var inst_18506 = (state_18557[(7)]);
var inst_18514 = (state_18557[(16)]);
var inst_18521 = (state_18557[(2)]);
var inst_18522 = fluree.db.util.async.throw_err(inst_18521);
var inst_18523 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_18506,inst_18522);
var inst_18506__$1 = inst_18523;
var inst_18507 = inst_18514;
var state_18557__$1 = (function (){var statearr_18568 = state_18557;
(statearr_18568[(7)] = inst_18506__$1);

(statearr_18568[(13)] = inst_18507);

return statearr_18568;
})();
var statearr_18569_18613 = state_18557__$1;
(statearr_18569_18613[(2)] = null);

(statearr_18569_18613[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (6))){
var inst_18474 = (state_18557[(17)]);
var state_18557__$1 = state_18557;
var statearr_18570_18614 = state_18557__$1;
(statearr_18570_18614[(2)] = inst_18474);

(statearr_18570_18614[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (25))){
var inst_18552 = (state_18557[(2)]);
var _ = (function (){var statearr_18571 = state_18557;
(statearr_18571[(4)] = cljs.core.rest((state_18557[(4)])));

return statearr_18571;
})();
var state_18557__$1 = state_18557;
var statearr_18572_18615 = state_18557__$1;
(statearr_18572_18615[(2)] = inst_18552);

(statearr_18572_18615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (17))){
var inst_18513 = (state_18557[(18)]);
var inst_18507 = (state_18557[(13)]);
var inst_18512 = cljs.core.seq(inst_18507);
var inst_18513__$1 = cljs.core.first(inst_18512);
var inst_18514 = cljs.core.next(inst_18512);
var state_18557__$1 = (function (){var statearr_18573 = state_18557;
(statearr_18573[(16)] = inst_18514);

(statearr_18573[(18)] = inst_18513__$1);

return statearr_18573;
})();
if(cljs.core.truth_(inst_18513__$1)){
var statearr_18574_18616 = state_18557__$1;
(statearr_18574_18616[(1)] = (19));

} else {
var statearr_18575_18617 = state_18557__$1;
(statearr_18575_18617[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (3))){
var inst_18555 = (state_18557[(2)]);
var state_18557__$1 = state_18557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18557__$1,inst_18555);
} else {
if((state_val_18558 === (12))){
var inst_18491 = (state_18557[(12)]);
var inst_18480 = (state_18557[(19)]);
var inst_18486 = cljs.core.vals(inst_18480);
var inst_18487 = cljs.core.flatten(inst_18486);
var inst_18488 = cljs.core.set(inst_18487);
var inst_18489 = cljs.core.keys(inst_18480);
var inst_18490 = cljs.core.set(inst_18489);
var inst_18491__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_18488,inst_18490);
var inst_18492 = cljs.core.empty_QMARK_(inst_18491__$1);
var state_18557__$1 = (function (){var statearr_18576 = state_18557;
(statearr_18576[(12)] = inst_18491__$1);

return statearr_18576;
})();
if(inst_18492){
var statearr_18577_18618 = state_18557__$1;
(statearr_18577_18618[(1)] = (14));

} else {
var statearr_18578_18619 = state_18557__$1;
(statearr_18578_18619[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (2))){
var inst_18474 = (state_18557[(17)]);
var _ = (function (){var statearr_18579 = state_18557;
(statearr_18579[(4)] = cljs.core.cons((5),(state_18557[(4)])));

return statearr_18579;
})();
var inst_18474__$1 = depth;
var state_18557__$1 = (function (){var statearr_18580 = state_18557;
(statearr_18580[(17)] = inst_18474__$1);

return statearr_18580;
})();
if(cljs.core.truth_(inst_18474__$1)){
var statearr_18581_18620 = state_18557__$1;
(statearr_18581_18620[(1)] = (6));

} else {
var statearr_18582_18621 = state_18557__$1;
(statearr_18582_18621[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (23))){
var inst_18545 = (state_18557[(9)]);
var state_18557__$1 = state_18557;
var statearr_18583_18622 = state_18557__$1;
(statearr_18583_18622[(2)] = inst_18545);

(statearr_18583_18622[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (19))){
var inst_18513 = (state_18557[(18)]);
var inst_18516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18517 = [inst_18513,predicate];
var inst_18518 = (new cljs.core.PersistentVector(null,2,(5),inst_18516,inst_18517,null));
var inst_18519 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_18518);
var state_18557__$1 = state_18557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18557__$1,(22),inst_18519);
} else {
if((state_val_18558 === (11))){
var inst_18480 = (state_18557[(19)]);
var state_18557__$1 = state_18557;
var statearr_18585_18623 = state_18557__$1;
(statearr_18585_18623[(2)] = inst_18480);

(statearr_18585_18623[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (9))){
var inst_18481 = (state_18557[(20)]);
var inst_18478 = (state_18557[(10)]);
var inst_18483 = (inst_18481 >= inst_18478);
var state_18557__$1 = state_18557;
if(cljs.core.truth_(inst_18483)){
var statearr_18586_18624 = state_18557__$1;
(statearr_18586_18624[(1)] = (11));

} else {
var statearr_18587_18625 = state_18557__$1;
(statearr_18587_18625[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (5))){
var _ = (function (){var statearr_18588 = state_18557;
(statearr_18588[(4)] = cljs.core.rest((state_18557[(4)])));

return statearr_18588;
})();
var state_18557__$1 = state_18557;
var ex18584 = (state_18557__$1[(2)]);
var statearr_18589_18626 = state_18557__$1;
(statearr_18589_18626[(5)] = ex18584);


if((ex18584 instanceof Error)){
var statearr_18590_18627 = state_18557__$1;
(statearr_18590_18627[(1)] = (4));

(statearr_18590_18627[(5)] = null);

} else {
throw ex18584;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (14))){
var inst_18480 = (state_18557[(19)]);
var state_18557__$1 = state_18557;
var statearr_18591_18628 = state_18557__$1;
(statearr_18591_18628[(2)] = inst_18480);

(statearr_18591_18628[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (16))){
var inst_18538 = (state_18557[(2)]);
var state_18557__$1 = state_18557;
var statearr_18592_18629 = state_18557__$1;
(statearr_18592_18629[(2)] = inst_18538);

(statearr_18592_18629[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (10))){
var inst_18543 = (state_18557[(8)]);
var inst_18544 = (state_18557[(11)]);
var inst_18542 = (state_18557[(2)]);
var inst_18543__$1 = cljs.core.keys(inst_18542);
var inst_18544__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_18543__$1,inst_18542);
var inst_18545 = fluree.db.query.analytical.recur_map__GT_tuples(inst_18543__$1,inst_18544__$1);
var state_18557__$1 = (function (){var statearr_18593 = state_18557;
(statearr_18593[(8)] = inst_18543__$1);

(statearr_18593[(9)] = inst_18545);

(statearr_18593[(11)] = inst_18544__$1);

return statearr_18593;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_18594_18630 = state_18557__$1;
(statearr_18594_18630[(1)] = (23));

} else {
var statearr_18595_18631 = state_18557__$1;
(statearr_18595_18631[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (18))){
var inst_18481 = (state_18557[(20)]);
var inst_18480 = (state_18557[(19)]);
var inst_18529 = (state_18557[(2)]);
var inst_18530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18531 = [(0),(2)];
var inst_18532 = (new cljs.core.PersistentVector(null,2,(5),inst_18530,inst_18531,null));
var inst_18533 = fluree.db.query.analytical.get_ns_arrays(inst_18532,inst_18529);
var inst_18534 = fluree.db.query.analytical.tuples__GT_map(inst_18480,inst_18533);
var inst_18535 = (inst_18481 + (1));
var inst_18480__$1 = inst_18534;
var inst_18481__$1 = inst_18535;
var state_18557__$1 = (function (){var statearr_18596 = state_18557;
(statearr_18596[(20)] = inst_18481__$1);

(statearr_18596[(19)] = inst_18480__$1);

return statearr_18596;
})();
var statearr_18597_18632 = state_18557__$1;
(statearr_18597_18632[(2)] = null);

(statearr_18597_18632[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18558 === (8))){
var inst_18478 = (state_18557[(2)]);
var inst_18479 = recur_map;
var inst_18480 = inst_18479;
var inst_18481 = (1);
var state_18557__$1 = (function (){var statearr_18598 = state_18557;
(statearr_18598[(20)] = inst_18481);

(statearr_18598[(10)] = inst_18478);

(statearr_18598[(19)] = inst_18480);

return statearr_18598;
})();
var statearr_18599_18633 = state_18557__$1;
(statearr_18599_18633[(2)] = null);

(statearr_18599_18633[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0 = (function (){
var statearr_18600 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18600[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__);

(statearr_18600[(1)] = (1));

return statearr_18600;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1 = (function (state_18557){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18557);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18601){var ex__2730__auto__ = e18601;
var statearr_18602_18634 = state_18557;
(statearr_18602_18634[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18557[(4)]))){
var statearr_18603_18635 = state_18557;
(statearr_18603_18635[(1)] = cljs.core.first((state_18557[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18636 = state_18557;
state_18557 = G__18636;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__ = function(state_18557){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1.call(this,state_18557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18604 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18604[(6)] = c__2749__auto__);

return statearr_18604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__18637,clause,fuel,max_fuel){
var map__18638 = p__18637;
var map__18638__$1 = cljs.core.__destructure_map(map__18638);
var res = map__18638__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18638__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18638__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18638__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18749){
var state_val_18750 = (state_18749[(1)]);
if((state_val_18750 === (7))){
var inst_18655 = (state_18749[(7)]);
var state_18749__$1 = state_18749;
var statearr_18751_18804 = state_18749__$1;
(statearr_18751_18804[(2)] = inst_18655);

(statearr_18751_18804[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (20))){
var inst_18683 = (state_18749[(8)]);
var inst_18714 = typeof inst_18683 === 'number';
var state_18749__$1 = state_18749;
if(cljs.core.truth_(inst_18714)){
var statearr_18752_18805 = state_18749__$1;
(statearr_18752_18805[(1)] = (22));

} else {
var statearr_18753_18806 = state_18749__$1;
(statearr_18753_18806[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (27))){
var inst_18729 = (state_18749[(2)]);
var state_18749__$1 = state_18749;
var statearr_18754_18807 = state_18749__$1;
(statearr_18754_18807[(2)] = inst_18729);

(statearr_18754_18807[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (1))){
var state_18749__$1 = state_18749;
var statearr_18755_18808 = state_18749__$1;
(statearr_18755_18808[(2)] = null);

(statearr_18755_18808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (24))){
var inst_18731 = (state_18749[(2)]);
var state_18749__$1 = state_18749;
var statearr_18756_18809 = state_18749__$1;
(statearr_18756_18809[(2)] = inst_18731);

(statearr_18756_18809[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (4))){
var inst_18639 = (state_18749[(2)]);
var state_18749__$1 = state_18749;
var statearr_18757_18810 = state_18749__$1;
(statearr_18757_18810[(2)] = inst_18639);

(statearr_18757_18810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (15))){
var inst_18697 = (state_18749[(2)]);
var inst_18698 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_18699 = fluree.db.query.analytical.variable_QMARK_(inst_18698);
var state_18749__$1 = (function (){var statearr_18758 = state_18749;
(statearr_18758[(9)] = inst_18697);

return statearr_18758;
})();
if(cljs.core.truth_(inst_18699)){
var statearr_18759_18811 = state_18749__$1;
(statearr_18759_18811[(1)] = (16));

} else {
var statearr_18760_18812 = state_18749__$1;
(statearr_18760_18812[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (21))){
var inst_18685 = (state_18749[(10)]);
var inst_18656 = (state_18749[(11)]);
var inst_18686 = (state_18749[(12)]);
var inst_18733 = (state_18749[(2)]);
var inst_18734 = fluree.db.query.analytical.tuples__GT_recur(db,inst_18686,inst_18733,inst_18656,inst_18685);
var state_18749__$1 = state_18749;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18749__$1,(28),inst_18734);
} else {
if((state_val_18750 === (13))){
var inst_18665 = (state_18749[(13)]);
var inst_18689 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18665)].join('');
var inst_18690 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18691 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_18692 = cljs.core.PersistentHashMap.fromArrays(inst_18690,inst_18691);
var inst_18693 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18689,inst_18692);
var inst_18694 = (function(){throw inst_18693})();
var state_18749__$1 = state_18749;
var statearr_18761_18813 = state_18749__$1;
(statearr_18761_18813[(2)] = inst_18694);

(statearr_18761_18813[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (22))){
var inst_18683 = (state_18749[(8)]);
var inst_18681 = (state_18749[(14)]);
var inst_18716 = cljs.core.PersistentHashMap.EMPTY;
var inst_18717 = cljs.core.flatten(inst_18681);
var inst_18718 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18716,inst_18683,inst_18717);
var state_18749__$1 = state_18749;
var statearr_18762_18814 = state_18749__$1;
(statearr_18762_18814[(2)] = inst_18718);

(statearr_18762_18814[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (6))){
var inst_18667 = (state_18749[(15)]);
var state_18749__$1 = state_18749;
var statearr_18763_18815 = state_18749__$1;
(statearr_18763_18815[(2)] = inst_18667);

(statearr_18763_18815[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (28))){
var inst_18736 = (state_18749[(2)]);
var inst_18737 = fluree.db.util.async.throw_err(inst_18736);
var state_18749__$1 = state_18749;
var statearr_18764_18816 = state_18749__$1;
(statearr_18764_18816[(2)] = inst_18737);

(statearr_18764_18816[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (25))){
var inst_18677 = (state_18749[(16)]);
var inst_18681 = (state_18749[(14)]);
var inst_18722 = cljs.core.PersistentHashMap.EMPTY;
var inst_18723 = cljs.core.first(inst_18677);
var inst_18724 = cljs.core.first(inst_18723);
var inst_18725 = cljs.core.flatten(inst_18681);
var inst_18726 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18722,inst_18724,inst_18725);
var state_18749__$1 = state_18749;
var statearr_18765_18817 = state_18749__$1;
(statearr_18765_18817[(2)] = inst_18726);

(statearr_18765_18817[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (17))){
var inst_18665 = (state_18749[(13)]);
var inst_18702 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18665)].join('');
var inst_18703 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18704 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_18705 = cljs.core.PersistentHashMap.fromArrays(inst_18703,inst_18704);
var inst_18706 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18702,inst_18705);
var inst_18707 = (function(){throw inst_18706})();
var state_18749__$1 = state_18749;
var statearr_18766_18818 = state_18749__$1;
(statearr_18766_18818[(2)] = inst_18707);

(statearr_18766_18818[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (3))){
var inst_18747 = (state_18749[(2)]);
var state_18749__$1 = state_18749;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18749__$1,inst_18747);
} else {
if((state_val_18750 === (12))){
var inst_18652 = (state_18749[(17)]);
var inst_18740 = (state_18749[(2)]);
var inst_18741 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_18742 = cljs.core.keys(inst_18652);
var inst_18743 = [inst_18742,vars,inst_18740];
var inst_18744 = cljs.core.PersistentHashMap.fromArrays(inst_18741,inst_18743);
var _ = (function (){var statearr_18767 = state_18749;
(statearr_18767[(4)] = cljs.core.rest((state_18749[(4)])));

return statearr_18767;
})();
var state_18749__$1 = state_18749;
var statearr_18768_18819 = state_18749__$1;
(statearr_18768_18819[(2)] = inst_18744);

(statearr_18768_18819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (2))){
var inst_18652 = (state_18749[(17)]);
var inst_18655 = (state_18749[(7)]);
var inst_18667 = (state_18749[(15)]);
var inst_18656 = (state_18749[(11)]);
var _ = (function (){var statearr_18769 = state_18749;
(statearr_18769[(4)] = cljs.core.cons((5),(state_18749[(4)])));

return statearr_18769;
})();
var inst_18649 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_18650 = cljs.core.__destructure_map(inst_18649);
var inst_18651 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18650,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_18652__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18650,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_18653 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18650,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_18654 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_18655__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_18653);
var inst_18656__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_18653);
var inst_18658 = (function (){var map__18645 = inst_18650;
var search = inst_18651;
var rel = inst_18652__$1;
var opts = inst_18653;
var common_keys = inst_18654;
var object_fn = inst_18655__$1;
var recur_depth = inst_18656__$1;
return (function (p__18657,common_key){
var vec__18770 = p__18657;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18770,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18770,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__18773 = cljs.core._EQ_;
var expr__18774 = idx_of;
if(cljs.core.truth_((pred__18773.cljs$core$IFn$_invoke$arity$2 ? pred__18773.cljs$core$IFn$_invoke$arity$2((0),expr__18774) : pred__18773.call(null,(0),expr__18774)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__18773.cljs$core$IFn$_invoke$arity$2 ? pred__18773.cljs$core$IFn$_invoke$arity$2((1),expr__18774) : pred__18773.call(null,(1),expr__18774)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__18773.cljs$core$IFn$_invoke$arity$2 ? pred__18773.cljs$core$IFn$_invoke$arity$2((2),expr__18774) : pred__18773.call(null,(2),expr__18774)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__18774)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4251__auto__ = (!(single_v_QMARK_));
if(and__4251__auto__){
var and__4251__auto____$1 = object_fn;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_18659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18660 = cljs.core.PersistentHashMap.EMPTY;
var inst_18661 = [inst_18660,inst_18651];
var inst_18662 = (new cljs.core.PersistentVector(null,2,(5),inst_18659,inst_18661,null));
var inst_18663 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_18658,inst_18662,inst_18654);
var inst_18664 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18663,(0),null);
var inst_18665 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18663,(1),null);
var inst_18666 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_18667__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_18664);
var state_18749__$1 = (function (){var statearr_18776 = state_18749;
(statearr_18776[(18)] = inst_18666);

(statearr_18776[(17)] = inst_18652__$1);

(statearr_18776[(7)] = inst_18655__$1);

(statearr_18776[(15)] = inst_18667__$1);

(statearr_18776[(11)] = inst_18656__$1);

(statearr_18776[(13)] = inst_18665);

return statearr_18776;
})();
if(cljs.core.truth_(inst_18667__$1)){
var statearr_18777_18820 = state_18749__$1;
(statearr_18777_18820[(1)] = (6));

} else {
var statearr_18778_18821 = state_18749__$1;
(statearr_18778_18821[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (23))){
var inst_18683 = (state_18749[(8)]);
var inst_18720 = cljs.core.coll_QMARK_(inst_18683);
var state_18749__$1 = state_18749;
if(inst_18720){
var statearr_18779_18822 = state_18749__$1;
(statearr_18779_18822[(1)] = (25));

} else {
var statearr_18780_18823 = state_18749__$1;
(statearr_18780_18823[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (19))){
var inst_18681 = (state_18749[(14)]);
var inst_18711 = cljs.core.PersistentHashMap.EMPTY;
var inst_18712 = fluree.db.query.analytical.tuples__GT_map(inst_18711,inst_18681);
var state_18749__$1 = state_18749;
var statearr_18781_18824 = state_18749__$1;
(statearr_18781_18824[(2)] = inst_18712);

(statearr_18781_18824[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (11))){
var inst_18681 = (state_18749[(14)]);
var state_18749__$1 = state_18749;
var statearr_18783_18825 = state_18749__$1;
(statearr_18783_18825[(2)] = inst_18681);

(statearr_18783_18825[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (9))){
var inst_18677 = (state_18749[(16)]);
var inst_18652 = (state_18749[(17)]);
var inst_18656 = (state_18749[(11)]);
var inst_18676 = (state_18749[(2)]);
var inst_18677__$1 = fluree.db.util.async.throw_err(inst_18676);
var inst_18678 = cljs.core.count(inst_18677__$1);
var inst_18679 = fluree.db.query.analytical.add_fuel(inst_18678,fuel,max_fuel);
var inst_18680 = cljs.core.vals(inst_18652);
var inst_18681 = fluree.db.query.analytical.get_ns_arrays(inst_18680,inst_18677__$1);
var state_18749__$1 = (function (){var statearr_18784 = state_18749;
(statearr_18784[(16)] = inst_18677__$1);

(statearr_18784[(14)] = inst_18681);

(statearr_18784[(19)] = inst_18679);

return statearr_18784;
})();
if(cljs.core.truth_(inst_18656)){
var statearr_18785_18826 = state_18749__$1;
(statearr_18785_18826[(1)] = (10));

} else {
var statearr_18786_18827 = state_18749__$1;
(statearr_18786_18827[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (5))){
var _ = (function (){var statearr_18787 = state_18749;
(statearr_18787[(4)] = cljs.core.rest((state_18749[(4)])));

return statearr_18787;
})();
var state_18749__$1 = state_18749;
var ex18782 = (state_18749__$1[(2)]);
var statearr_18788_18828 = state_18749__$1;
(statearr_18788_18828[(5)] = ex18782);


if((ex18782 instanceof Error)){
var statearr_18789_18829 = state_18749__$1;
(statearr_18789_18829[(1)] = (4));

(statearr_18789_18829[(5)] = null);

} else {
throw ex18782;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (14))){
var state_18749__$1 = state_18749;
var statearr_18790_18830 = state_18749__$1;
(statearr_18790_18830[(2)] = null);

(statearr_18790_18830[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (26))){
var state_18749__$1 = state_18749;
var statearr_18791_18831 = state_18749__$1;
(statearr_18791_18831[(2)] = null);

(statearr_18791_18831[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (16))){
var state_18749__$1 = state_18749;
var statearr_18792_18832 = state_18749__$1;
(statearr_18792_18832[(2)] = null);

(statearr_18792_18832[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (10))){
var inst_18686 = (state_18749[(12)]);
var inst_18665 = (state_18749[(13)]);
var inst_18683 = cljs.core.first(inst_18665);
var inst_18684 = cljs.core.first(clause);
var inst_18685 = fluree.db.query.analytical.variable_QMARK_(inst_18684);
var inst_18686__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_18665,(1));
var inst_18687 = fluree.db.query.analytical.variable_QMARK_(inst_18686__$1);
var state_18749__$1 = (function (){var statearr_18793 = state_18749;
(statearr_18793[(10)] = inst_18685);

(statearr_18793[(8)] = inst_18683);

(statearr_18793[(12)] = inst_18686__$1);

return statearr_18793;
})();
if(cljs.core.truth_(inst_18687)){
var statearr_18794_18833 = state_18749__$1;
(statearr_18794_18833[(1)] = (13));

} else {
var statearr_18795_18834 = state_18749__$1;
(statearr_18795_18834[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (18))){
var inst_18685 = (state_18749[(10)]);
var inst_18709 = (state_18749[(2)]);
var state_18749__$1 = (function (){var statearr_18796 = state_18749;
(statearr_18796[(20)] = inst_18709);

return statearr_18796;
})();
if(cljs.core.truth_(inst_18685)){
var statearr_18797_18835 = state_18749__$1;
(statearr_18797_18835[(1)] = (19));

} else {
var statearr_18798_18836 = state_18749__$1;
(statearr_18798_18836[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18750 === (8))){
var inst_18666 = (state_18749[(18)]);
var inst_18665 = (state_18749[(13)]);
var inst_18671 = (state_18749[(2)]);
var inst_18672 = [inst_18671];
var inst_18673 = cljs.core.PersistentHashMap.fromArrays(inst_18666,inst_18672);
var inst_18674 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_18665,inst_18673);
var state_18749__$1 = state_18749;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18749__$1,(9),inst_18674);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_18799 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18799[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__);

(statearr_18799[(1)] = (1));

return statearr_18799;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1 = (function (state_18749){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18749);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18800){var ex__2730__auto__ = e18800;
var statearr_18801_18837 = state_18749;
(statearr_18801_18837[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18749[(4)]))){
var statearr_18802_18838 = state_18749;
(statearr_18802_18838[(1)] = cljs.core.first((state_18749[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18839 = state_18749;
state_18749 = G__18839;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__ = function(state_18749){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1.call(this,state_18749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18803 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18803[(6)] = c__2749__auto__);

return statearr_18803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__18840,res,clause){
var map__18841 = p__18840;
var map__18841__$1 = cljs.core.__destructure_map(map__18841);
var db = map__18841__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18841__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18841__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18841__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18950){
var state_val_18951 = (state_18950[(1)]);
if((state_val_18951 === (7))){
var inst_18850 = (state_18950[(7)]);
var state_18950__$1 = state_18950;
var statearr_18952_18993 = state_18950__$1;
(statearr_18952_18993[(2)] = inst_18850);

(statearr_18952_18993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (20))){
var state_18950__$1 = state_18950;
var statearr_18953_18994 = state_18950__$1;
(statearr_18953_18994[(2)] = null);

(statearr_18953_18994[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (1))){
var state_18950__$1 = state_18950;
var statearr_18954_18995 = state_18950__$1;
(statearr_18954_18995[(2)] = null);

(statearr_18954_18995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (24))){
var inst_18852 = (state_18950[(8)]);
var inst_18923 = (state_18950[(2)]);
var inst_18924 = fluree.db.flake.sid__GT_cid(inst_18923);
var inst_18925 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_18924);
var inst_18926 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_18927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18928 = [inst_18852];
var inst_18929 = (new cljs.core.PersistentVector(null,1,(5),inst_18927,inst_18928,null));
var inst_18930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18932 = [inst_18925];
var inst_18933 = (new cljs.core.PersistentVector(null,1,(5),inst_18931,inst_18932,null));
var inst_18934 = [inst_18933];
var inst_18935 = (new cljs.core.PersistentVector(null,1,(5),inst_18930,inst_18934,null));
var inst_18936 = cljs.core.PersistentHashMap.EMPTY;
var inst_18937 = [inst_18929,inst_18935,inst_18936];
var inst_18938 = cljs.core.PersistentHashMap.fromArrays(inst_18926,inst_18937);
var state_18950__$1 = state_18950;
var statearr_18955_18996 = state_18950__$1;
(statearr_18955_18996[(2)] = inst_18938);

(statearr_18955_18996[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (4))){
var inst_18843 = (state_18950[(2)]);
var state_18950__$1 = state_18950;
var statearr_18956_18997 = state_18950__$1;
(statearr_18956_18997[(2)] = inst_18843);

(statearr_18956_18997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (15))){
var inst_18852 = (state_18950[(8)]);
var inst_18850 = (state_18950[(7)]);
var inst_18871 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_18872 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_18873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18874 = [inst_18850];
var inst_18875 = (new cljs.core.PersistentVector(null,1,(5),inst_18873,inst_18874,null));
var inst_18876 = (function (){var subject_var = inst_18850;
var object_var = inst_18852;
var min_sid = inst_18871;
var max_sid = (0);
return (function (p1__18842_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__18842_SHARP_);
});
})();
var inst_18877 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_18871,(0));
var inst_18878 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_18876,inst_18877);
var inst_18879 = cljs.core.PersistentHashMap.EMPTY;
var inst_18880 = [inst_18875,inst_18878,inst_18879];
var inst_18881 = cljs.core.PersistentHashMap.fromArrays(inst_18872,inst_18880);
var state_18950__$1 = state_18950;
var statearr_18957_18998 = state_18950__$1;
(statearr_18957_18998[(2)] = inst_18881);

(statearr_18957_18998[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (21))){
var inst_18941 = (state_18950[(2)]);
var state_18950__$1 = state_18950;
var statearr_18958_18999 = state_18950__$1;
(statearr_18958_18999[(2)] = inst_18941);

(statearr_18958_18999[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (13))){
var inst_18852 = (state_18950[(8)]);
var state_18950__$1 = state_18950;
if(cljs.core.truth_(inst_18852)){
var statearr_18959_19000 = state_18950__$1;
(statearr_18959_19000[(1)] = (19));

} else {
var statearr_18960_19001 = state_18950__$1;
(statearr_18960_19001[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (22))){
var inst_18914 = (state_18950[(9)]);
var state_18950__$1 = state_18950;
var statearr_18961_19002 = state_18950__$1;
(statearr_18961_19002[(2)] = inst_18914);

(statearr_18961_19002[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (6))){
var inst_18852 = (state_18950[(8)]);
var state_18950__$1 = state_18950;
var statearr_18962_19003 = state_18950__$1;
(statearr_18962_19003[(2)] = inst_18852);

(statearr_18962_19003[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (25))){
var inst_18920 = (state_18950[(2)]);
var inst_18921 = fluree.db.util.async.throw_err(inst_18920);
var state_18950__$1 = state_18950;
var statearr_18963_19004 = state_18950__$1;
(statearr_18963_19004[(2)] = inst_18921);

(statearr_18963_19004[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (17))){
var inst_18911 = (state_18950[(2)]);
var state_18950__$1 = state_18950;
var statearr_18964_19005 = state_18950__$1;
(statearr_18964_19005[(2)] = inst_18911);

(statearr_18964_19005[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (3))){
var inst_18948 = (state_18950[(2)]);
var state_18950__$1 = state_18950;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18950__$1,inst_18948);
} else {
if((state_val_18951 === (12))){
var inst_18865 = ["_tx",null,"_block",null];
var inst_18866 = (new cljs.core.PersistentArrayMap(null,2,inst_18865,null));
var inst_18867 = (new cljs.core.PersistentHashSet(null,inst_18866,null));
var inst_18868 = cljs.core.last(clause);
var inst_18869 = (inst_18867.cljs$core$IFn$_invoke$arity$1 ? inst_18867.cljs$core$IFn$_invoke$arity$1(inst_18868) : inst_18867.call(null,inst_18868));
var state_18950__$1 = state_18950;
if(cljs.core.truth_(inst_18869)){
var statearr_18965_19006 = state_18950__$1;
(statearr_18965_19006[(1)] = (15));

} else {
var statearr_18966_19007 = state_18950__$1;
(statearr_18966_19007[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (2))){
var inst_18850 = (state_18950[(7)]);
var _ = (function (){var statearr_18967 = state_18950;
(statearr_18967[(4)] = cljs.core.cons((5),(state_18950[(4)])));

return statearr_18967;
})();
var inst_18849 = cljs.core.first(clause);
var inst_18850__$1 = fluree.db.query.analytical.variable_QMARK_(inst_18849);
var inst_18851 = cljs.core.last(clause);
var inst_18852 = fluree.db.query.analytical.variable_QMARK_(inst_18851);
var state_18950__$1 = (function (){var statearr_18968 = state_18950;
(statearr_18968[(8)] = inst_18852);

(statearr_18968[(7)] = inst_18850__$1);

return statearr_18968;
})();
if(cljs.core.truth_(inst_18850__$1)){
var statearr_18969_19008 = state_18950__$1;
(statearr_18969_19008[(1)] = (6));

} else {
var statearr_18970_19009 = state_18950__$1;
(statearr_18970_19009[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (23))){
var inst_18914 = (state_18950[(9)]);
var inst_18918 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_18914);
var state_18950__$1 = state_18950;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18950__$1,(25),inst_18918);
} else {
if((state_val_18951 === (19))){
var inst_18914 = (state_18950[(9)]);
var inst_18914__$1 = cljs.core.first(clause);
var inst_18915 = typeof inst_18914__$1 === 'number';
var state_18950__$1 = (function (){var statearr_18971 = state_18950;
(statearr_18971[(9)] = inst_18914__$1);

return statearr_18971;
})();
if(cljs.core.truth_(inst_18915)){
var statearr_18972_19010 = state_18950__$1;
(statearr_18972_19010[(1)] = (22));

} else {
var statearr_18973_19011 = state_18950__$1;
(statearr_18973_19011[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (11))){
var inst_18945 = (state_18950[(2)]);
var _ = (function (){var statearr_18975 = state_18950;
(statearr_18975[(4)] = cljs.core.rest((state_18950[(4)])));

return statearr_18975;
})();
var state_18950__$1 = state_18950;
var statearr_18976_19012 = state_18950__$1;
(statearr_18976_19012[(2)] = inst_18945);

(statearr_18976_19012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (9))){
var inst_18858 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18859 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_18860 = cljs.core.PersistentHashMap.fromArrays(inst_18858,inst_18859);
var inst_18861 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_18860);
var inst_18862 = (function(){throw inst_18861})();
var state_18950__$1 = state_18950;
var statearr_18977_19013 = state_18950__$1;
(statearr_18977_19013[(2)] = inst_18862);

(statearr_18977_19013[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (5))){
var _ = (function (){var statearr_18978 = state_18950;
(statearr_18978[(4)] = cljs.core.rest((state_18950[(4)])));

return statearr_18978;
})();
var state_18950__$1 = state_18950;
var ex18974 = (state_18950__$1[(2)]);
var statearr_18979_19014 = state_18950__$1;
(statearr_18979_19014[(5)] = ex18974);


if((ex18974 instanceof Error)){
var statearr_18980_19015 = state_18950__$1;
(statearr_18980_19015[(1)] = (4));

(statearr_18980_19015[(5)] = null);

} else {
throw ex18974;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (14))){
var inst_18943 = (state_18950[(2)]);
var state_18950__$1 = state_18950;
var statearr_18981_19016 = state_18950__$1;
(statearr_18981_19016[(2)] = inst_18943);

(statearr_18981_19016[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (16))){
var inst_18884 = (state_18950[(10)]);
var inst_18886 = (state_18950[(11)]);
var inst_18887 = (state_18950[(12)]);
var inst_18883 = cljs.core.last(clause);
var inst_18884__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_18883);
var inst_18885 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_18886__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18885,inst_18884__$1);
var inst_18887__$1 = fluree.db.flake.min_subject_id(inst_18884__$1);
var inst_18888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18889 = [inst_18886__$1];
var inst_18890 = (new cljs.core.PersistentVector(null,1,(5),inst_18888,inst_18889,null));
var inst_18891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18892 = [inst_18887__$1];
var inst_18893 = (new cljs.core.PersistentVector(null,1,(5),inst_18891,inst_18892,null));
var inst_18894 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_18890,cljs.core._LT__EQ_,inst_18893);
var state_18950__$1 = (function (){var statearr_18982 = state_18950;
(statearr_18982[(10)] = inst_18884__$1);

(statearr_18982[(11)] = inst_18886__$1);

(statearr_18982[(12)] = inst_18887__$1);

return statearr_18982;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18950__$1,(18),inst_18894);
} else {
if((state_val_18951 === (10))){
var inst_18850 = (state_18950[(7)]);
var state_18950__$1 = state_18950;
if(cljs.core.truth_(inst_18850)){
var statearr_18983_19017 = state_18950__$1;
(statearr_18983_19017[(1)] = (12));

} else {
var statearr_18984_19018 = state_18950__$1;
(statearr_18984_19018[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (18))){
var inst_18852 = (state_18950[(8)]);
var inst_18850 = (state_18950[(7)]);
var inst_18884 = (state_18950[(10)]);
var inst_18886 = (state_18950[(11)]);
var inst_18887 = (state_18950[(12)]);
var inst_18896 = (state_18950[(2)]);
var inst_18897 = fluree.db.util.async.throw_err(inst_18896);
var inst_18898 = (function (){var subject_var = inst_18850;
var object_var = inst_18852;
var partition = inst_18884;
var max_sid = inst_18886;
var min_sid = inst_18887;
var flakes = inst_18897;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_18899 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_18898);
var inst_18900 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_18901 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_18899,inst_18900);
var inst_18902 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_18903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18904 = [inst_18850];
var inst_18905 = (new cljs.core.PersistentVector(null,1,(5),inst_18903,inst_18904,null));
var inst_18906 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_18901,inst_18897);
var inst_18907 = cljs.core.PersistentHashMap.EMPTY;
var inst_18908 = [inst_18905,inst_18906,inst_18907];
var inst_18909 = cljs.core.PersistentHashMap.fromArrays(inst_18902,inst_18908);
var state_18950__$1 = state_18950;
var statearr_18985_19019 = state_18950__$1;
(statearr_18985_19019[(2)] = inst_18909);

(statearr_18985_19019[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18951 === (8))){
var inst_18856 = (state_18950[(2)]);
var state_18950__$1 = state_18950;
if(cljs.core.truth_(inst_18856)){
var statearr_18986_19020 = state_18950__$1;
(statearr_18986_19020[(1)] = (9));

} else {
var statearr_18987_19021 = state_18950__$1;
(statearr_18987_19021[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_18988 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18988[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__);

(statearr_18988[(1)] = (1));

return statearr_18988;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1 = (function (state_18950){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18950);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18989){var ex__2730__auto__ = e18989;
var statearr_18990_19022 = state_18950;
(statearr_18990_19022[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18950[(4)]))){
var statearr_18991_19023 = state_18950;
(statearr_18991_19023[(1)] = cljs.core.first((state_18950[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19024 = state_18950;
state_18950 = G__19024;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__ = function(state_18950){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1.call(this,state_18950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18992 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18992[(6)] = c__2749__auto__);

return statearr_18992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__19031 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__19031 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__19031;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4652__auto__ = (function fluree$db$query$analytical$variance_$_iter__19032(s__19033){
return (new cljs.core.LazySeq(null,(function (){
var s__19033__$1 = s__19033;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__19033__$1);
if(temp__5804__auto__){
var s__19033__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19033__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__19033__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__19035 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__19034 = (0);
while(true){
if((i__19034 < size__4651__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__19034);
var delta = (x - mean);
cljs.core.chunk_append(b__19035,(delta * delta));

var G__19037 = (i__19034 + (1));
i__19034 = G__19037;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19035),fluree$db$query$analytical$variance_$_iter__19032(cljs.core.chunk_rest(s__19033__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19035),null);
}
} else {
var x = cljs.core.first(s__19033__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__19032(cljs.core.rest(s__19033__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__19036 = variance(coll);
return Math.sqrt(G__19036);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4336__auto__ = n;
var y__4337__auto__ = (- n);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
}),(function() {
var G__19038 = null;
var G__19038__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__19038__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__19038 = function(n,coll){
switch(arguments.length){
case 1:
return G__19038__1.call(this,n);
case 2:
return G__19038__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__19038.cljs$core$IFn$_invoke$arity$1 = G__19038__1;
G__19038.cljs$core$IFn$_invoke$arity$2 = G__19038__2;
return G__19038;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__19039 = null;
var G__19039__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__19039__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__19039 = function(n,coll){
switch(arguments.length){
case 1:
return G__19039__1.call(this,n);
case 2:
return G__19039__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__19039.cljs$core$IFn$_invoke$arity$1 = G__19039__1;
G__19039.cljs$core$IFn$_invoke$arity$2 = G__19039__2;
return G__19039;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__19040 = null;
var G__19040__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__19040__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__19040 = function(n,coll){
switch(arguments.length){
case 1:
return G__19040__1.call(this,n);
case 2:
return G__19040__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__19040.cljs$core$IFn$_invoke$arity$1 = G__19040__1;
G__19040.cljs$core$IFn$_invoke$arity$2 = G__19040__2;
return G__19040;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__19041 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19041,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19041,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19041,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__19044 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__19047 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__19047) : agg_fn.call(null,G__19047));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19044,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19044,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__19048 = agg;
var map__19048__$1 = cljs.core.__destructure_map(map__19048);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19048__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19048__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var function$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19048__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (function$.cljs$core$IFn$_invoke$arity$1 ? function$.cljs$core$IFn$_invoke$arity$1(agg_params) : function$.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__19050 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19050,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19050,(1),null);
var map__19053 = res__$1;
var map__19053__$1 = cljs.core.__destructure_map(map__19053);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19053__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19053__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19049_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__19049_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19054_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__19054_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19055_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__19055_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__19056_SHARP_,p2__19057_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19056_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__19057_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19058_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__19058_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__19061,row,b_tuple){
var vec__19062 = p__19061;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19062,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19062,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19059_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__19059_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4253__auto__ = acc;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19060_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__19060_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19065_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__19065_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19066_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__19066_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__19071 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__19073 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__19072 = (function (p1__19067_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__19067_SHARP_);
});
return fexpr__19072(G__19073);
})()),cljs.core.set(b_idxs));
var fexpr__19070 = (function (p1__19068_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__19068_SHARP_);
});
return fexpr__19070(G__19071);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19069_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__19069_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19074_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__19074_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19075_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__19075_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__19080 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__19082 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__19081 = (function (p1__19076_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__19076_SHARP_);
});
return fexpr__19081(G__19082);
})()),cljs.core.set(b_idxs));
var fexpr__19079 = (function (p1__19077_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__19077_SHARP_);
});
return fexpr__19079(G__19080);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19078_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__19078_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__19084 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.extract_filter_fn(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19084,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19084,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__19083_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__19083_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var vec__19089 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.extract_filter_fn(filt,valid_vars);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19089,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19089,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19087_SHARP_){
return fluree.db.util.core.index_of(headers,p1__19087_SHARP_);
}),filt_vars);
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__19088_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__19088_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__19092,filters,optional_QMARK_){
var map__19093 = p__19092;
var map__19093__$1 = cljs.core.__destructure_map(map__19093);
var tuple_map = map__19093__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19093__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19093__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19093__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__19094 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19094,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19094,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__19097 = res;
var map__19097__$1 = cljs.core.__destructure_map(map__19097);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19097__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19097__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5802__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19153){
var state_val_19154 = (state_19153[(1)]);
if((state_val_19154 === (7))){
var inst_19127 = (state_19153[(7)]);
var inst_19125 = (state_19153[(2)]);
var inst_19126 = fluree.db.util.async.throw_err(inst_19125);
var inst_19127__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19126,(0),null);
var inst_19128 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19126,(1),null);
var inst_19129 = (inst_19127__$1 == null);
var state_19153__$1 = (function (){var statearr_19155 = state_19153;
(statearr_19155[(8)] = inst_19128);

(statearr_19155[(7)] = inst_19127__$1);

return statearr_19155;
})();
if(cljs.core.truth_(inst_19129)){
var statearr_19156_19185 = state_19153__$1;
(statearr_19156_19185[(1)] = (8));

} else {
var statearr_19157_19186 = state_19153__$1;
(statearr_19157_19186[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19154 === (1))){
var inst_19105 = optional_clauses;
var inst_19106 = cljs.core.seq(inst_19105);
var inst_19107 = cljs.core.first(inst_19106);
var inst_19108 = cljs.core.next(inst_19106);
var inst_19109 = where_tuples;
var inst_19110 = inst_19105;
var inst_19111 = inst_19109;
var state_19153__$1 = (function (){var statearr_19158 = state_19153;
(statearr_19158[(9)] = inst_19107);

(statearr_19158[(10)] = inst_19110);

(statearr_19158[(11)] = inst_19108);

(statearr_19158[(12)] = inst_19111);

return statearr_19158;
})();
var statearr_19159_19187 = state_19153__$1;
(statearr_19159_19187[(2)] = null);

(statearr_19159_19187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19154 === (4))){
var inst_19118 = (state_19153[(13)]);
var inst_19111 = (state_19153[(12)]);
var inst_19117 = (state_19153[(14)]);
var inst_19123 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_19111,inst_19117,inst_19118,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_19111,inst_19117,inst_19118,true,fuel,max_fuel,opts));
var state_19153__$1 = state_19153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19153__$1,(7),inst_19123);
} else {
if((state_val_19154 === (15))){
var state_19153__$1 = state_19153;
var statearr_19160_19188 = state_19153__$1;
(statearr_19160_19188[(2)] = null);

(statearr_19160_19188[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19154 === (13))){
var inst_19144 = (state_19153[(2)]);
var state_19153__$1 = state_19153;
var statearr_19161_19189 = state_19153__$1;
(statearr_19161_19189[(2)] = inst_19144);

(statearr_19161_19189[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19154 === (6))){
var inst_19149 = (state_19153[(2)]);
var state_19153__$1 = state_19153;
var statearr_19162_19190 = state_19153__$1;
(statearr_19162_19190[(2)] = inst_19149);

(statearr_19162_19190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19154 === (3))){
var inst_19151 = (state_19153[(2)]);
var state_19153__$1 = state_19153;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19153__$1,inst_19151);
} else {
if((state_val_19154 === (12))){
var state_19153__$1 = state_19153;
var statearr_19163_19191 = state_19153__$1;
(statearr_19163_19191[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19154 === (2))){
var inst_19110 = (state_19153[(10)]);
var inst_19117 = (state_19153[(14)]);
var inst_19116 = cljs.core.seq(inst_19110);
var inst_19117__$1 = cljs.core.first(inst_19116);
var inst_19118 = cljs.core.next(inst_19116);
var state_19153__$1 = (function (){var statearr_19165 = state_19153;
(statearr_19165[(13)] = inst_19118);

(statearr_19165[(14)] = inst_19117__$1);

return statearr_19165;
})();
if(cljs.core.truth_(inst_19117__$1)){
var statearr_19166_19192 = state_19153__$1;
(statearr_19166_19192[(1)] = (4));

} else {
var statearr_19167_19193 = state_19153__$1;
(statearr_19167_19193[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19154 === (11))){
var inst_19128 = (state_19153[(8)]);
var inst_19127 = (state_19153[(7)]);
var inst_19110 = inst_19128;
var inst_19111 = inst_19127;
var state_19153__$1 = (function (){var statearr_19168 = state_19153;
(statearr_19168[(10)] = inst_19110);

(statearr_19168[(12)] = inst_19111);

return statearr_19168;
})();
var statearr_19169_19194 = state_19153__$1;
(statearr_19169_19194[(2)] = null);

(statearr_19169_19194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19154 === (9))){
var inst_19117 = (state_19153[(14)]);
var inst_19133 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_19117);
var state_19153__$1 = state_19153;
if(cljs.core.truth_(inst_19133)){
var statearr_19170_19195 = state_19153__$1;
(statearr_19170_19195[(1)] = (11));

} else {
var statearr_19171_19196 = state_19153__$1;
(statearr_19171_19196[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19154 === (5))){
var inst_19111 = (state_19153[(12)]);
var state_19153__$1 = state_19153;
var statearr_19172_19197 = state_19153__$1;
(statearr_19172_19197[(2)] = inst_19111);

(statearr_19172_19197[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19154 === (14))){
var inst_19128 = (state_19153[(8)]);
var inst_19111 = (state_19153[(12)]);
var inst_19127 = (state_19153[(7)]);
var inst_19138 = fluree.db.query.analytical.left_outer_join(inst_19111,inst_19127);
var inst_19110 = inst_19128;
var inst_19111__$1 = inst_19138;
var state_19153__$1 = (function (){var statearr_19173 = state_19153;
(statearr_19173[(10)] = inst_19110);

(statearr_19173[(12)] = inst_19111__$1);

return statearr_19173;
})();
var statearr_19174_19198 = state_19153__$1;
(statearr_19174_19198[(2)] = null);

(statearr_19174_19198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19154 === (16))){
var inst_19142 = (state_19153[(2)]);
var state_19153__$1 = state_19153;
var statearr_19176_19199 = state_19153__$1;
(statearr_19176_19199[(2)] = inst_19142);

(statearr_19176_19199[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19154 === (10))){
var inst_19146 = (state_19153[(2)]);
var state_19153__$1 = state_19153;
var statearr_19177_19200 = state_19153__$1;
(statearr_19177_19200[(2)] = inst_19146);

(statearr_19177_19200[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19154 === (8))){
var inst_19128 = (state_19153[(8)]);
var inst_19111 = (state_19153[(12)]);
var tmp19175 = inst_19111;
var inst_19110 = inst_19128;
var inst_19111__$1 = tmp19175;
var state_19153__$1 = (function (){var statearr_19178 = state_19153;
(statearr_19178[(10)] = inst_19110);

(statearr_19178[(12)] = inst_19111__$1);

return statearr_19178;
})();
var statearr_19179_19201 = state_19153__$1;
(statearr_19179_19201[(2)] = null);

(statearr_19179_19201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0 = (function (){
var statearr_19180 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19180[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__);

(statearr_19180[(1)] = (1));

return statearr_19180;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1 = (function (state_19153){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19153);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19181){var ex__2730__auto__ = e19181;
var statearr_19182_19202 = state_19153;
(statearr_19182_19202[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19153[(4)]))){
var statearr_19183_19203 = state_19153;
(statearr_19183_19203[(1)] = cljs.core.first((state_19153[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19204 = state_19153;
state_19153 = G__19204;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__ = function(state_19153){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1.call(this,state_19153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19184 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19184[(6)] = c__2749__auto__);

return statearr_19184;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__19206){
var vec__19207 = p__19206;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19207,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19207,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19205_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19205_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__19211,p__19212,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__19213 = p__19211;
var map__19213__$1 = cljs.core.__destructure_map(map__19213);
var q_map = map__19213__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19213__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__19214 = p__19212;
var map__19214__$1 = cljs.core.__destructure_map(map__19214);
var res = map__19214__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19214__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19451){
var state_val_19452 = (state_19451[(1)]);
if((state_val_19452 === (65))){
var inst_19400 = (state_19451[(7)]);
var inst_19401 = (state_19451[(8)]);
var inst_19412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19413 = fluree.db.query.analytical.full_text__GT_tuples(inst_19400,res,inst_19401);
var inst_19414 = [inst_19413,r];
var inst_19415 = (new cljs.core.PersistentVector(null,2,(5),inst_19412,inst_19414,null));
var state_19451__$1 = state_19451;
var statearr_19453_19566 = state_19451__$1;
(statearr_19453_19566[(2)] = inst_19415);

(statearr_19453_19566[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (70))){
var inst_19427 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19454_19567 = state_19451__$1;
(statearr_19454_19567[(2)] = inst_19427);

(statearr_19454_19567[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (62))){
var inst_19401 = (state_19451[(8)]);
var inst_19409 = cljs.core.second(inst_19401);
var inst_19410 = clojure.string.starts_with_QMARK_(inst_19409,"fullText:");
var state_19451__$1 = state_19451;
if(inst_19410){
var statearr_19455_19568 = state_19451__$1;
(statearr_19455_19568[(1)] = (65));

} else {
var statearr_19456_19569 = state_19451__$1;
(statearr_19456_19569[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (7))){
var inst_19320 = (state_19451[(9)]);
var inst_19319 = cljs.core.count(clause);
var inst_19320__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_19319);
var state_19451__$1 = (function (){var statearr_19457 = state_19451;
(statearr_19457[(9)] = inst_19320__$1);

return statearr_19457;
})();
if(inst_19320__$1){
var statearr_19458_19570 = state_19451__$1;
(statearr_19458_19570[(1)] = (31));

} else {
var statearr_19459_19571 = state_19451__$1;
(statearr_19459_19571[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (59))){
var inst_19434 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19460_19572 = state_19451__$1;
(statearr_19460_19572[(2)] = inst_19434);

(statearr_19460_19572[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (20))){
var inst_19283 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19461_19573 = state_19451__$1;
(statearr_19461_19573[(2)] = inst_19283);

(statearr_19461_19573[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (58))){
var state_19451__$1 = state_19451;
var statearr_19462_19574 = state_19451__$1;
(statearr_19462_19574[(2)] = null);

(statearr_19462_19574[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (60))){
var inst_19400 = (state_19451[(7)]);
var inst_19398 = (state_19451[(2)]);
var inst_19399 = fluree.db.util.async.throw_err(inst_19398);
var inst_19400__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19399,(0),null);
var inst_19401 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19399,(1),null);
var inst_19402 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_19400__$1);
var state_19451__$1 = (function (){var statearr_19463 = state_19451;
(statearr_19463[(7)] = inst_19400__$1);

(statearr_19463[(8)] = inst_19401);

return statearr_19463;
})();
if(inst_19402){
var statearr_19464_19575 = state_19451__$1;
(statearr_19464_19575[(1)] = (61));

} else {
var statearr_19465_19576 = state_19451__$1;
(statearr_19465_19576[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (27))){
var inst_19313 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19466_19577 = state_19451__$1;
(statearr_19466_19577[(2)] = inst_19313);

(statearr_19466_19577[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (1))){
var state_19451__$1 = state_19451;
var statearr_19467_19578 = state_19451__$1;
(statearr_19467_19578[(2)] = null);

(statearr_19467_19578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (69))){
var state_19451__$1 = state_19451;
var statearr_19468_19579 = state_19451__$1;
(statearr_19468_19579[(2)] = null);

(statearr_19468_19579[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (24))){
var inst_19277 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19469_19580 = state_19451__$1;
(statearr_19469_19580[(2)] = inst_19277);

(statearr_19469_19580[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (55))){
var inst_19383 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_19384 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19385 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19386 = cljs.core.PersistentHashMap.fromArrays(inst_19384,inst_19385);
var inst_19387 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19383,inst_19386);
var inst_19388 = (function(){throw inst_19387})();
var state_19451__$1 = state_19451;
var statearr_19470_19581 = state_19451__$1;
(statearr_19470_19581[(2)] = inst_19388);

(statearr_19470_19581[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (39))){
var inst_19340 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
if(cljs.core.truth_(inst_19340)){
var statearr_19471_19582 = state_19451__$1;
(statearr_19471_19582[(1)] = (40));

} else {
var statearr_19472_19583 = state_19451__$1;
(statearr_19472_19583[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (46))){
var inst_19440 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19473_19584 = state_19451__$1;
(statearr_19473_19584[(2)] = inst_19440);

(statearr_19473_19584[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (4))){
var inst_19215 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19474_19585 = state_19451__$1;
(statearr_19474_19585[(2)] = inst_19215);

(statearr_19474_19585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (54))){
var inst_19376 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_19377 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19378 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19379 = cljs.core.PersistentHashMap.fromArrays(inst_19377,inst_19378);
var inst_19380 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19376,inst_19379);
var inst_19381 = (function(){throw inst_19380})();
var state_19451__$1 = state_19451;
var statearr_19475_19586 = state_19451__$1;
(statearr_19475_19586[(2)] = inst_19381);

(statearr_19475_19586[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (15))){
var inst_19315 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19476_19587 = state_19451__$1;
(statearr_19476_19587[(2)] = inst_19315);

(statearr_19476_19587[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (48))){
var inst_19364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19365 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_19366 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_19365);
var inst_19367 = [inst_19366,r];
var inst_19368 = (new cljs.core.PersistentVector(null,2,(5),inst_19364,inst_19367,null));
var state_19451__$1 = state_19451;
var statearr_19477_19588 = state_19451__$1;
(statearr_19477_19588[(2)] = inst_19368);

(statearr_19477_19588[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (50))){
var inst_19438 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19478_19589 = state_19451__$1;
(statearr_19478_19589[(2)] = inst_19438);

(statearr_19478_19589[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (21))){
var inst_19254 = (state_19451[(10)]);
var inst_19228 = (state_19451[(11)]);
var inst_19253 = (state_19451[(12)]);
var inst_19260 = (state_19451[(13)]);
var inst_19261 = (state_19451[(14)]);
var inst_19252 = (state_19451[(15)]);
var inst_19249 = (state_19451[(16)]);
var inst_19224 = (state_19451[(17)]);
var inst_19251 = (state_19451[(18)]);
var inst_19265 = (state_19451[(2)]);
var inst_19266 = fluree.db.util.async.throw_err(inst_19265);
var inst_19267 = (function (){var new_res = inst_19266;
var seq__19247 = inst_19252;
var seq__19257 = inst_19261;
var rest = inst_19261;
var vec__19256 = inst_19253;
var tuples = inst_19254;
var first__19248 = inst_19251;
var vec__19246 = inst_19249;
var pred__19225 = inst_19228;
var first__19258 = inst_19260;
var expr__19226 = inst_19224;
var segment_type = inst_19224;
var clause_group = inst_19260;
var G__19245 = inst_19253;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_19268 = cljs.core.keys(vars);
var inst_19269 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_19267,inst_19266,inst_19268);
var inst_19270 = fluree.db.query.analytical.res_absorb_vars(inst_19269);
var state_19451__$1 = (function (){var statearr_19479 = state_19451;
(statearr_19479[(19)] = inst_19270);

return statearr_19479;
})();
if(cljs.core.truth_(inst_19254)){
var statearr_19480_19590 = state_19451__$1;
(statearr_19480_19590[(1)] = (22));

} else {
var statearr_19481_19591 = state_19451__$1;
(statearr_19481_19591[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (31))){
var inst_19322 = cljs.core.second(clause);
var inst_19323 = clojure.string.starts_with_QMARK_(inst_19322,"fullText:");
var state_19451__$1 = state_19451;
var statearr_19482_19592 = state_19451__$1;
(statearr_19482_19592[(2)] = inst_19323);

(statearr_19482_19592[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (32))){
var inst_19320 = (state_19451[(9)]);
var state_19451__$1 = state_19451;
var statearr_19483_19593 = state_19451__$1;
(statearr_19483_19593[(2)] = inst_19320);

(statearr_19483_19593[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (40))){
var inst_19342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19343 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_19451__$1 = (function (){var statearr_19484 = state_19451;
(statearr_19484[(20)] = inst_19342);

return statearr_19484;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19451__$1,(43),inst_19343);
} else {
if((state_val_19452 === (56))){
var inst_19390 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19485_19594 = state_19451__$1;
(statearr_19485_19594[(2)] = inst_19390);

(statearr_19485_19594[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (33))){
var inst_19326 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
if(cljs.core.truth_(inst_19326)){
var statearr_19486_19595 = state_19451__$1;
(statearr_19486_19595[(1)] = (34));

} else {
var statearr_19487_19596 = state_19451__$1;
(statearr_19487_19596[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (13))){
var inst_19249 = (state_19451[(16)]);
var inst_19249__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_19250 = cljs.core.seq(inst_19249__$1);
var inst_19251 = cljs.core.first(inst_19250);
var inst_19252 = cljs.core.next(inst_19250);
var inst_19253 = inst_19249__$1;
var inst_19254 = null;
var state_19451__$1 = (function (){var statearr_19488 = state_19451;
(statearr_19488[(10)] = inst_19254);

(statearr_19488[(12)] = inst_19253);

(statearr_19488[(15)] = inst_19252);

(statearr_19488[(16)] = inst_19249__$1);

(statearr_19488[(18)] = inst_19251);

return statearr_19488;
})();
var statearr_19489_19597 = state_19451__$1;
(statearr_19489_19597[(2)] = null);

(statearr_19489_19597[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (22))){
var inst_19254 = (state_19451[(10)]);
var inst_19261 = (state_19451[(14)]);
var inst_19270 = (state_19451[(19)]);
var inst_19272 = fluree.db.query.union.results(inst_19254,inst_19270);
var inst_19253 = inst_19261;
var inst_19254__$1 = inst_19272;
var state_19451__$1 = (function (){var statearr_19490 = state_19451;
(statearr_19490[(10)] = inst_19254__$1);

(statearr_19490[(12)] = inst_19253);

return statearr_19490;
})();
var statearr_19491_19598 = state_19451__$1;
(statearr_19491_19598[(2)] = null);

(statearr_19491_19598[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (36))){
var inst_19444 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19492_19599 = state_19451__$1;
(statearr_19492_19599[(2)] = inst_19444);

(statearr_19492_19599[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (41))){
var inst_19350 = cljs.core.count(clause);
var inst_19351 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_19350);
var state_19451__$1 = state_19451;
if(inst_19351){
var statearr_19493_19600 = state_19451__$1;
(statearr_19493_19600[(1)] = (44));

} else {
var statearr_19494_19601 = state_19451__$1;
(statearr_19494_19601[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (43))){
var inst_19342 = (state_19451[(20)]);
var inst_19345 = (state_19451[(2)]);
var inst_19346 = fluree.db.util.async.throw_err(inst_19345);
var inst_19347 = [inst_19346,r];
var inst_19348 = (new cljs.core.PersistentVector(null,2,(5),inst_19342,inst_19347,null));
var state_19451__$1 = state_19451;
var statearr_19495_19602 = state_19451__$1;
(statearr_19495_19602[(2)] = inst_19348);

(statearr_19495_19602[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (61))){
var inst_19401 = (state_19451[(8)]);
var inst_19404 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_19401,r,res,optional_QMARK_,fuel,max_fuel);
var state_19451__$1 = state_19451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19451__$1,(64),inst_19404);
} else {
if((state_val_19452 === (29))){
var inst_19224 = (state_19451[(17)]);
var inst_19307 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19224)].join('');
var inst_19308 = (new Error(inst_19307));
var inst_19309 = (function(){throw inst_19308})();
var state_19451__$1 = state_19451;
var statearr_19496_19603 = state_19451__$1;
(statearr_19496_19603[(2)] = inst_19309);

(statearr_19496_19603[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (44))){
var inst_19353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19354 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_19451__$1 = (function (){var statearr_19497 = state_19451;
(statearr_19497[(21)] = inst_19353);

return statearr_19497;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19451__$1,(47),inst_19354);
} else {
if((state_val_19452 === (6))){
var inst_19228 = (state_19451[(11)]);
var inst_19224 = (state_19451[(17)]);
var inst_19223 = cljs.core.keys(clause);
var inst_19224__$1 = cljs.core.first(inst_19223);
var inst_19228__$1 = cljs.core._EQ_;
var inst_19229 = (function (){var G__19498 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__19499 = inst_19224__$1;
return (inst_19228__$1.cljs$core$IFn$_invoke$arity$2 ? inst_19228__$1.cljs$core$IFn$_invoke$arity$2(G__19498,G__19499) : inst_19228__$1.call(null,G__19498,G__19499));
})();
var state_19451__$1 = (function (){var statearr_19500 = state_19451;
(statearr_19500[(11)] = inst_19228__$1);

(statearr_19500[(17)] = inst_19224__$1);

return statearr_19500;
})();
if(cljs.core.truth_(inst_19229)){
var statearr_19501_19604 = state_19451__$1;
(statearr_19501_19604[(1)] = (9));

} else {
var statearr_19502_19605 = state_19451__$1;
(statearr_19502_19605[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (28))){
var inst_19301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19302 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_19303 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_19302,optional_QMARK_);
var inst_19304 = [inst_19303,r];
var inst_19305 = (new cljs.core.PersistentVector(null,2,(5),inst_19301,inst_19304,null));
var state_19451__$1 = state_19451;
var statearr_19503_19606 = state_19451__$1;
(statearr_19503_19606[(2)] = inst_19305);

(statearr_19503_19606[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (64))){
var inst_19406 = (state_19451[(2)]);
var inst_19407 = fluree.db.util.async.throw_err(inst_19406);
var state_19451__$1 = state_19451;
var statearr_19504_19607 = state_19451__$1;
(statearr_19504_19607[(2)] = inst_19407);

(statearr_19504_19607[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (51))){
var inst_19373 = cljs.core.first(clause);
var inst_19374 = cljs.core.sequential_QMARK_(inst_19373);
var state_19451__$1 = state_19451;
if(inst_19374){
var statearr_19505_19608 = state_19451__$1;
(statearr_19505_19608[(1)] = (54));

} else {
var statearr_19506_19609 = state_19451__$1;
(statearr_19506_19609[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (25))){
var inst_19228 = (state_19451[(11)]);
var inst_19224 = (state_19451[(17)]);
var inst_19289 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_19290 = (function (){var segment_type = inst_19224;
var pred__19225 = inst_19228;
var expr__19226 = inst_19224;
var bindings = inst_19289;
return (function (p1__19210_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__19210_SHARP_);
});
})();
var inst_19291 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_19290,inst_19289);
var inst_19292 = cljs.core.PersistentHashMap.EMPTY;
var inst_19293 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_19292,inst_19291);
var inst_19294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19295 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_19293);
var inst_19296 = [inst_19295,r];
var inst_19297 = (new cljs.core.PersistentVector(null,2,(5),inst_19294,inst_19296,null));
var state_19451__$1 = state_19451;
var statearr_19507_19610 = state_19451__$1;
(statearr_19507_19610[(2)] = inst_19297);

(statearr_19507_19610[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (34))){
var inst_19328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19329 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_19330 = [inst_19329,r];
var inst_19331 = (new cljs.core.PersistentVector(null,2,(5),inst_19328,inst_19330,null));
var state_19451__$1 = state_19451;
var statearr_19508_19611 = state_19451__$1;
(statearr_19508_19611[(2)] = inst_19331);

(statearr_19508_19611[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (17))){
var inst_19285 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19509_19612 = state_19451__$1;
(statearr_19509_19612[(2)] = inst_19285);

(statearr_19509_19612[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (3))){
var inst_19449 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19451__$1,inst_19449);
} else {
if((state_val_19452 === (12))){
var inst_19231 = (state_19451[(22)]);
var inst_19235 = (state_19451[(2)]);
var inst_19236 = fluree.db.util.async.throw_err(inst_19235);
var inst_19237 = [inst_19236,r];
var inst_19238 = (new cljs.core.PersistentVector(null,2,(5),inst_19231,inst_19237,null));
var state_19451__$1 = state_19451;
var statearr_19510_19613 = state_19451__$1;
(statearr_19510_19613[(2)] = inst_19238);

(statearr_19510_19613[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (2))){
var _ = (function (){var statearr_19511 = state_19451;
(statearr_19511[(4)] = cljs.core.cons((5),(state_19451[(4)])));

return statearr_19511;
})();
var inst_19221 = cljs.core.map_QMARK_(clause);
var state_19451__$1 = state_19451;
if(inst_19221){
var statearr_19512_19614 = state_19451__$1;
(statearr_19512_19614[(1)] = (6));

} else {
var statearr_19513_19615 = state_19451__$1;
(statearr_19513_19615[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (66))){
var state_19451__$1 = state_19451;
var statearr_19514_19616 = state_19451__$1;
(statearr_19514_19616[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (23))){
var inst_19261 = (state_19451[(14)]);
var inst_19270 = (state_19451[(19)]);
var inst_19253 = inst_19261;
var inst_19254 = inst_19270;
var state_19451__$1 = (function (){var statearr_19516 = state_19451;
(statearr_19516[(10)] = inst_19254);

(statearr_19516[(12)] = inst_19253);

return statearr_19516;
})();
var statearr_19517_19617 = state_19451__$1;
(statearr_19517_19617[(2)] = null);

(statearr_19517_19617[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (47))){
var inst_19353 = (state_19451[(21)]);
var inst_19356 = (state_19451[(2)]);
var inst_19357 = fluree.db.util.async.throw_err(inst_19356);
var inst_19358 = [inst_19357,r];
var inst_19359 = (new cljs.core.PersistentVector(null,2,(5),inst_19353,inst_19358,null));
var state_19451__$1 = state_19451;
var statearr_19518_19618 = state_19451__$1;
(statearr_19518_19618[(2)] = inst_19359);

(statearr_19518_19618[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (35))){
var inst_19334 = (state_19451[(23)]);
var inst_19333 = cljs.core.count(clause);
var inst_19334__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_19333);
var state_19451__$1 = (function (){var statearr_19519 = state_19451;
(statearr_19519[(23)] = inst_19334__$1);

return statearr_19519;
})();
if(inst_19334__$1){
var statearr_19520_19619 = state_19451__$1;
(statearr_19520_19619[(1)] = (37));

} else {
var statearr_19521_19620 = state_19451__$1;
(statearr_19521_19620[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (19))){
var inst_19254 = (state_19451[(10)]);
var inst_19279 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19280 = [inst_19254,r];
var inst_19281 = (new cljs.core.PersistentVector(null,2,(5),inst_19279,inst_19280,null));
var state_19451__$1 = state_19451;
var statearr_19522_19621 = state_19451__$1;
(statearr_19522_19621[(2)] = inst_19281);

(statearr_19522_19621[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (57))){
var inst_19396 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_19451__$1 = state_19451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19451__$1,(60),inst_19396);
} else {
if((state_val_19452 === (68))){
var inst_19400 = (state_19451[(7)]);
var inst_19401 = (state_19451[(8)]);
var inst_19418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19419 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_19400,res,inst_19401,fuel,max_fuel);
var state_19451__$1 = (function (){var statearr_19523 = state_19451;
(statearr_19523[(24)] = inst_19418);

return statearr_19523;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19451__$1,(71),inst_19419);
} else {
if((state_val_19452 === (11))){
var inst_19317 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19525_19622 = state_19451__$1;
(statearr_19525_19622[(2)] = inst_19317);

(statearr_19525_19622[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (9))){
var inst_19231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19232 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_19233 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_19232,res,fuel,max_fuel,opts);
var state_19451__$1 = (function (){var statearr_19526 = state_19451;
(statearr_19526[(22)] = inst_19231);

return statearr_19526;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19451__$1,(12),inst_19233);
} else {
if((state_val_19452 === (5))){
var _ = (function (){var statearr_19527 = state_19451;
(statearr_19527[(4)] = cljs.core.rest((state_19451[(4)])));

return statearr_19527;
})();
var state_19451__$1 = state_19451;
var ex19524 = (state_19451__$1[(2)]);
var statearr_19528_19623 = state_19451__$1;
(statearr_19528_19623[(5)] = ex19524);


if((ex19524 instanceof Error)){
var statearr_19529_19624 = state_19451__$1;
(statearr_19529_19624[(1)] = (4));

(statearr_19529_19624[(5)] = null);

} else {
throw ex19524;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (14))){
var inst_19228 = (state_19451[(11)]);
var inst_19224 = (state_19451[(17)]);
var inst_19287 = (function (){var G__19530 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__19531 = inst_19224;
return (inst_19228.cljs$core$IFn$_invoke$arity$2 ? inst_19228.cljs$core$IFn$_invoke$arity$2(G__19530,G__19531) : inst_19228.call(null,G__19530,G__19531));
})();
var state_19451__$1 = state_19451;
if(cljs.core.truth_(inst_19287)){
var statearr_19532_19625 = state_19451__$1;
(statearr_19532_19625[(1)] = (25));

} else {
var statearr_19533_19626 = state_19451__$1;
(statearr_19533_19626[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (45))){
var inst_19361 = cljs.core.count(clause);
var inst_19362 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_19361);
var state_19451__$1 = state_19451;
if(inst_19362){
var statearr_19534_19627 = state_19451__$1;
(statearr_19534_19627[(1)] = (48));

} else {
var statearr_19535_19628 = state_19451__$1;
(statearr_19535_19628[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (53))){
var inst_19436 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19536_19629 = state_19451__$1;
(statearr_19536_19629[(2)] = inst_19436);

(statearr_19536_19629[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (26))){
var inst_19228 = (state_19451[(11)]);
var inst_19224 = (state_19451[(17)]);
var inst_19299 = (function (){var G__19537 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__19538 = inst_19224;
return (inst_19228.cljs$core$IFn$_invoke$arity$2 ? inst_19228.cljs$core$IFn$_invoke$arity$2(G__19537,G__19538) : inst_19228.call(null,G__19537,G__19538));
})();
var state_19451__$1 = state_19451;
if(cljs.core.truth_(inst_19299)){
var statearr_19539_19630 = state_19451__$1;
(statearr_19539_19630[(1)] = (28));

} else {
var statearr_19540_19631 = state_19451__$1;
(statearr_19540_19631[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (16))){
var inst_19253 = (state_19451[(12)]);
var inst_19260 = (state_19451[(13)]);
var inst_19259 = cljs.core.seq(inst_19253);
var inst_19260__$1 = cljs.core.first(inst_19259);
var inst_19261 = cljs.core.next(inst_19259);
var state_19451__$1 = (function (){var statearr_19541 = state_19451;
(statearr_19541[(13)] = inst_19260__$1);

(statearr_19541[(14)] = inst_19261);

return statearr_19541;
})();
if(cljs.core.truth_(inst_19260__$1)){
var statearr_19542_19632 = state_19451__$1;
(statearr_19542_19632[(1)] = (18));

} else {
var statearr_19543_19633 = state_19451__$1;
(statearr_19543_19633[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (38))){
var inst_19334 = (state_19451[(23)]);
var state_19451__$1 = state_19451;
var statearr_19544_19634 = state_19451__$1;
(statearr_19544_19634[(2)] = inst_19334);

(statearr_19544_19634[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (30))){
var inst_19311 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19545_19635 = state_19451__$1;
(statearr_19545_19635[(2)] = inst_19311);

(statearr_19545_19635[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (10))){
var inst_19228 = (state_19451[(11)]);
var inst_19224 = (state_19451[(17)]);
var inst_19240 = (function (){var G__19546 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__19547 = inst_19224;
return (inst_19228.cljs$core$IFn$_invoke$arity$2 ? inst_19228.cljs$core$IFn$_invoke$arity$2(G__19546,G__19547) : inst_19228.call(null,G__19546,G__19547));
})();
var state_19451__$1 = state_19451;
if(cljs.core.truth_(inst_19240)){
var statearr_19548_19636 = state_19451__$1;
(statearr_19548_19636[(1)] = (13));

} else {
var statearr_19549_19637 = state_19451__$1;
(statearr_19549_19637[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (18))){
var inst_19260 = (state_19451[(13)]);
var inst_19263 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_19260,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_19260,q_map,vars,fuel,max_fuel,opts));
var state_19451__$1 = state_19451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19451__$1,(21),inst_19263);
} else {
if((state_val_19452 === (52))){
var state_19451__$1 = state_19451;
var statearr_19550_19638 = state_19451__$1;
(statearr_19550_19638[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (67))){
var inst_19429 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19552_19639 = state_19451__$1;
(statearr_19552_19639[(2)] = inst_19429);

(statearr_19552_19639[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (71))){
var inst_19418 = (state_19451[(24)]);
var inst_19421 = (state_19451[(2)]);
var inst_19422 = fluree.db.util.async.throw_err(inst_19421);
var inst_19423 = [inst_19422,r];
var inst_19424 = (new cljs.core.PersistentVector(null,2,(5),inst_19418,inst_19423,null));
var state_19451__$1 = state_19451;
var statearr_19553_19640 = state_19451__$1;
(statearr_19553_19640[(2)] = inst_19424);

(statearr_19553_19640[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (42))){
var inst_19442 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19554_19641 = state_19451__$1;
(statearr_19554_19641[(2)] = inst_19442);

(statearr_19554_19641[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (37))){
var inst_19336 = cljs.core.second(clause);
var inst_19337 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19336,"rdf:type");
var state_19451__$1 = state_19451;
var statearr_19555_19642 = state_19451__$1;
(statearr_19555_19642[(2)] = inst_19337);

(statearr_19555_19642[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (63))){
var inst_19431 = (state_19451[(2)]);
var state_19451__$1 = state_19451;
var statearr_19556_19643 = state_19451__$1;
(statearr_19556_19643[(2)] = inst_19431);

(statearr_19556_19643[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (8))){
var inst_19446 = (state_19451[(2)]);
var _ = (function (){var statearr_19557 = state_19451;
(statearr_19557[(4)] = cljs.core.rest((state_19451[(4)])));

return statearr_19557;
})();
var state_19451__$1 = state_19451;
var statearr_19558_19644 = state_19451__$1;
(statearr_19558_19644[(2)] = inst_19446);

(statearr_19558_19644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19452 === (49))){
var inst_19370 = cljs.core.count(clause);
var inst_19371 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_19370);
var state_19451__$1 = state_19451;
if(inst_19371){
var statearr_19559_19645 = state_19451__$1;
(statearr_19559_19645[(1)] = (51));

} else {
var statearr_19560_19646 = state_19451__$1;
(statearr_19560_19646[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_19561 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19561[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__);

(statearr_19561[(1)] = (1));

return statearr_19561;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1 = (function (state_19451){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19451);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19562){var ex__2730__auto__ = e19562;
var statearr_19563_19647 = state_19451;
(statearr_19563_19647[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19451[(4)]))){
var statearr_19564_19648 = state_19451;
(statearr_19564_19648[(1)] = cljs.core.first((state_19451[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19649 = state_19451;
state_19451 = G__19649;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__ = function(state_19451){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1.call(this,state_19451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19565 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19565[(6)] = c__2749__auto__);

return statearr_19565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__19651 = arguments.length;
switch (G__19651) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19731){
var state_val_19732 = (state_19731[(1)]);
if((state_val_19732 === (7))){
var inst_19726 = (state_19731[(2)]);
var _ = (function (){var statearr_19733 = state_19731;
(statearr_19733[(4)] = cljs.core.rest((state_19731[(4)])));

return statearr_19733;
})();
var state_19731__$1 = state_19731;
var statearr_19734_19782 = state_19731__$1;
(statearr_19734_19782[(2)] = inst_19726);

(statearr_19734_19782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (20))){
var inst_19691 = (state_19731[(7)]);
var inst_19703 = (state_19731[(2)]);
var inst_19673 = inst_19691;
var inst_19674 = inst_19703;
var state_19731__$1 = (function (){var statearr_19735 = state_19731;
(statearr_19735[(8)] = inst_19673);

(statearr_19735[(9)] = inst_19674);

return statearr_19735;
})();
var statearr_19736_19783 = state_19731__$1;
(statearr_19736_19783[(2)] = null);

(statearr_19736_19783[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (1))){
var state_19731__$1 = state_19731;
var statearr_19737_19784 = state_19731__$1;
(statearr_19737_19784[(2)] = null);

(statearr_19737_19784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (24))){
var inst_19691 = (state_19731[(7)]);
var inst_19690 = (state_19731[(10)]);
var inst_19674 = (state_19731[(9)]);
var inst_19711 = fluree.db.query.analytical.inner_join(inst_19674,inst_19690);
var inst_19673 = inst_19691;
var inst_19674__$1 = inst_19711;
var state_19731__$1 = (function (){var statearr_19738 = state_19731;
(statearr_19738[(8)] = inst_19673);

(statearr_19738[(9)] = inst_19674__$1);

return statearr_19738;
})();
var statearr_19739_19785 = state_19731__$1;
(statearr_19739_19785[(2)] = null);

(statearr_19739_19785[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (4))){
var inst_19652 = (state_19731[(2)]);
var state_19731__$1 = state_19731;
var statearr_19741_19786 = state_19731__$1;
(statearr_19741_19786[(2)] = inst_19652);

(statearr_19741_19786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (15))){
var inst_19690 = (state_19731[(10)]);
var state_19731__$1 = state_19731;
if(cljs.core.truth_(inst_19690)){
var statearr_19742_19787 = state_19731__$1;
(statearr_19742_19787[(1)] = (18));

} else {
var statearr_19743_19788 = state_19731__$1;
(statearr_19743_19788[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (21))){
var inst_19691 = (state_19731[(7)]);
var inst_19674 = (state_19731[(9)]);
var tmp19740 = inst_19674;
var inst_19673 = inst_19691;
var inst_19674__$1 = tmp19740;
var state_19731__$1 = (function (){var statearr_19744 = state_19731;
(statearr_19744[(8)] = inst_19673);

(statearr_19744[(9)] = inst_19674__$1);

return statearr_19744;
})();
var statearr_19745_19789 = state_19731__$1;
(statearr_19745_19789[(2)] = null);

(statearr_19745_19789[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (13))){
var inst_19674 = (state_19731[(9)]);
var inst_19697 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_19674,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_19698 = cljs.core.empty_QMARK_(inst_19697);
var state_19731__$1 = state_19731;
if(inst_19698){
var statearr_19746_19790 = state_19731__$1;
(statearr_19746_19790[(1)] = (15));

} else {
var statearr_19747_19791 = state_19731__$1;
(statearr_19747_19791[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (22))){
var state_19731__$1 = state_19731;
var statearr_19748_19792 = state_19731__$1;
(statearr_19748_19792[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (6))){
var inst_19680 = (state_19731[(11)]);
var inst_19673 = (state_19731[(8)]);
var inst_19679 = cljs.core.seq(inst_19673);
var inst_19680__$1 = cljs.core.first(inst_19679);
var inst_19681 = cljs.core.next(inst_19679);
var state_19731__$1 = (function (){var statearr_19750 = state_19731;
(statearr_19750[(11)] = inst_19680__$1);

(statearr_19750[(12)] = inst_19681);

return statearr_19750;
})();
if(cljs.core.truth_(inst_19680__$1)){
var statearr_19751_19793 = state_19731__$1;
(statearr_19751_19793[(1)] = (8));

} else {
var statearr_19752_19794 = state_19731__$1;
(statearr_19752_19794[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (25))){
var state_19731__$1 = state_19731;
var statearr_19753_19795 = state_19731__$1;
(statearr_19753_19795[(2)] = null);

(statearr_19753_19795[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (17))){
var inst_19719 = (state_19731[(2)]);
var state_19731__$1 = state_19731;
var statearr_19754_19796 = state_19731__$1;
(statearr_19754_19796[(2)] = inst_19719);

(statearr_19754_19796[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (3))){
var inst_19729 = (state_19731[(2)]);
var state_19731__$1 = state_19731;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19731__$1,inst_19729);
} else {
if((state_val_19732 === (12))){
var inst_19691 = (state_19731[(7)]);
var inst_19690 = (state_19731[(10)]);
var inst_19673 = inst_19691;
var inst_19674 = inst_19690;
var state_19731__$1 = (function (){var statearr_19755 = state_19731;
(statearr_19755[(8)] = inst_19673);

(statearr_19755[(9)] = inst_19674);

return statearr_19755;
})();
var statearr_19756_19797 = state_19731__$1;
(statearr_19756_19797[(2)] = null);

(statearr_19756_19797[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (2))){
var _ = (function (){var statearr_19757 = state_19731;
(statearr_19757[(4)] = cljs.core.cons((5),(state_19731[(4)])));

return statearr_19757;
})();
var inst_19665 = where;
var inst_19666 = cljs.core.seq(inst_19665);
var inst_19667 = cljs.core.first(inst_19666);
var inst_19668 = cljs.core.next(inst_19666);
var inst_19669 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_19670 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_19671 = [inst_19670];
var inst_19672 = cljs.core.PersistentHashMap.fromArrays(inst_19669,inst_19671);
var inst_19673 = inst_19665;
var inst_19674 = inst_19672;
var state_19731__$1 = (function (){var statearr_19758 = state_19731;
(statearr_19758[(13)] = inst_19668);

(statearr_19758[(14)] = inst_19667);

(statearr_19758[(8)] = inst_19673);

(statearr_19758[(9)] = inst_19674);

return statearr_19758;
})();
var statearr_19759_19798 = state_19731__$1;
(statearr_19759_19798[(2)] = null);

(statearr_19759_19798[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (23))){
var inst_19717 = (state_19731[(2)]);
var state_19731__$1 = state_19731;
var statearr_19760_19799 = state_19731__$1;
(statearr_19760_19799[(2)] = inst_19717);

(statearr_19760_19799[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (19))){
var inst_19674 = (state_19731[(9)]);
var state_19731__$1 = state_19731;
var statearr_19761_19800 = state_19731__$1;
(statearr_19761_19800[(2)] = inst_19674);

(statearr_19761_19800[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (11))){
var inst_19680 = (state_19731[(11)]);
var inst_19688 = (state_19731[(2)]);
var inst_19689 = fluree.db.util.async.throw_err(inst_19688);
var inst_19690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19689,(0),null);
var inst_19691 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19689,(1),null);
var inst_19692 = cljs.core.count(inst_19680);
var inst_19693 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_19692);
var state_19731__$1 = (function (){var statearr_19763 = state_19731;
(statearr_19763[(7)] = inst_19691);

(statearr_19763[(10)] = inst_19690);

return statearr_19763;
})();
if(inst_19693){
var statearr_19764_19801 = state_19731__$1;
(statearr_19764_19801[(1)] = (12));

} else {
var statearr_19765_19802 = state_19731__$1;
(statearr_19765_19802[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (9))){
var inst_19674 = (state_19731[(9)]);
var state_19731__$1 = state_19731;
var statearr_19766_19803 = state_19731__$1;
(statearr_19766_19803[(2)] = inst_19674);

(statearr_19766_19803[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (5))){
var _ = (function (){var statearr_19767 = state_19731;
(statearr_19767[(4)] = cljs.core.rest((state_19731[(4)])));

return statearr_19767;
})();
var state_19731__$1 = state_19731;
var ex19762 = (state_19731__$1[(2)]);
var statearr_19768_19804 = state_19731__$1;
(statearr_19768_19804[(5)] = ex19762);


if((ex19762 instanceof Error)){
var statearr_19769_19805 = state_19731__$1;
(statearr_19769_19805[(1)] = (4));

(statearr_19769_19805[(5)] = null);

} else {
throw ex19762;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (14))){
var inst_19721 = (state_19731[(2)]);
var state_19731__$1 = state_19731;
var statearr_19770_19806 = state_19731__$1;
(statearr_19770_19806[(2)] = inst_19721);

(statearr_19770_19806[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (26))){
var inst_19715 = (state_19731[(2)]);
var state_19731__$1 = state_19731;
var statearr_19771_19807 = state_19731__$1;
(statearr_19771_19807[(2)] = inst_19715);

(statearr_19771_19807[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (16))){
var inst_19690 = (state_19731[(10)]);
var inst_19706 = (inst_19690 == null);
var state_19731__$1 = state_19731;
if(cljs.core.truth_(inst_19706)){
var statearr_19772_19808 = state_19731__$1;
(statearr_19772_19808[(1)] = (21));

} else {
var statearr_19773_19809 = state_19731__$1;
(statearr_19773_19809[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (10))){
var inst_19724 = (state_19731[(2)]);
var state_19731__$1 = state_19731;
var statearr_19774_19810 = state_19731__$1;
(statearr_19774_19810[(2)] = inst_19724);

(statearr_19774_19810[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (18))){
var inst_19690 = (state_19731[(10)]);
var state_19731__$1 = state_19731;
var statearr_19775_19811 = state_19731__$1;
(statearr_19775_19811[(2)] = inst_19690);

(statearr_19775_19811[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19732 === (8))){
var inst_19680 = (state_19731[(11)]);
var inst_19681 = (state_19731[(12)]);
var inst_19674 = (state_19731[(9)]);
var inst_19686 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_19674,inst_19680,inst_19681,false,fuel,max_fuel,opts);
var state_19731__$1 = state_19731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19731__$1,(11),inst_19686);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2727__auto__ = null;
var fluree$db$query$analytical$state_machine__2727__auto____0 = (function (){
var statearr_19776 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19776[(0)] = fluree$db$query$analytical$state_machine__2727__auto__);

(statearr_19776[(1)] = (1));

return statearr_19776;
});
var fluree$db$query$analytical$state_machine__2727__auto____1 = (function (state_19731){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19731);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19777){var ex__2730__auto__ = e19777;
var statearr_19778_19812 = state_19731;
(statearr_19778_19812[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19731[(4)]))){
var statearr_19779_19813 = state_19731;
(statearr_19779_19813[(1)] = cljs.core.first((state_19731[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19814 = state_19731;
state_19731 = G__19814;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2727__auto__ = function(state_19731){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2727__auto____1.call(this,state_19731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2727__auto____0;
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2727__auto____1;
return fluree$db$query$analytical$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19780 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19780[(6)] = c__2749__auto__);

return statearr_19780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19849){
var state_val_19850 = (state_19849[(1)]);
if((state_val_19850 === (7))){
var inst_19826 = (state_19849[(7)]);
var inst_19831 = (state_19849[(8)]);
var inst_19833 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_19826,inst_19831,fuel,max_fuel,opts);
var state_19849__$1 = state_19849;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19849__$1,(10),inst_19833);
} else {
if((state_val_19850 === (1))){
var state_19849__$1 = state_19849;
var statearr_19851_19876 = state_19849__$1;
(statearr_19851_19876[(2)] = null);

(statearr_19851_19876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19850 === (4))){
var inst_19815 = (state_19849[(2)]);
var state_19849__$1 = state_19849;
var statearr_19852_19877 = state_19849__$1;
(statearr_19852_19877[(2)] = inst_19815);

(statearr_19852_19877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19850 === (13))){
var inst_19844 = (state_19849[(2)]);
var _ = (function (){var statearr_19853 = state_19849;
(statearr_19853[(4)] = cljs.core.rest((state_19849[(4)])));

return statearr_19853;
})();
var state_19849__$1 = state_19849;
var statearr_19854_19878 = state_19849__$1;
(statearr_19854_19878[(2)] = inst_19844);

(statearr_19854_19878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19850 === (6))){
var inst_19826 = (state_19849[(7)]);
var inst_19830 = (state_19849[(2)]);
var inst_19831 = fluree.db.util.async.throw_err(inst_19830);
var state_19849__$1 = (function (){var statearr_19855 = state_19849;
(statearr_19855[(8)] = inst_19831);

return statearr_19855;
})();
if(cljs.core.truth_(inst_19826)){
var statearr_19856_19879 = state_19849__$1;
(statearr_19856_19879[(1)] = (7));

} else {
var statearr_19857_19880 = state_19849__$1;
(statearr_19857_19880[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19850 === (3))){
var inst_19847 = (state_19849[(2)]);
var state_19849__$1 = state_19849;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19849__$1,inst_19847);
} else {
if((state_val_19850 === (12))){
var inst_19839 = (state_19849[(9)]);
var state_19849__$1 = state_19849;
var statearr_19858_19881 = state_19849__$1;
(statearr_19858_19881[(2)] = inst_19839);

(statearr_19858_19881[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19850 === (2))){
var _ = (function (){var statearr_19859 = state_19849;
(statearr_19859[(4)] = cljs.core.cons((5),(state_19849[(4)])));

return statearr_19859;
})();
var inst_19822 = q_map;
var inst_19823 = cljs.core.__destructure_map(inst_19822);
var inst_19824 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19823,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_19825 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19823,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_19826 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19823,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_19827 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19823,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_19828 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_19825,q_map,inst_19824,fuel,max_fuel,opts);
var state_19849__$1 = (function (){var statearr_19860 = state_19849;
(statearr_19860[(7)] = inst_19826);

(statearr_19860[(10)] = inst_19827);

return statearr_19860;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19849__$1,(6),inst_19828);
} else {
if((state_val_19850 === (11))){
var inst_19827 = (state_19849[(10)]);
var inst_19839 = (state_19849[(9)]);
var inst_19841 = fluree.db.query.analytical.tuples__GT_filtered(inst_19839,inst_19827,null);
var state_19849__$1 = state_19849;
var statearr_19862_19882 = state_19849__$1;
(statearr_19862_19882[(2)] = inst_19841);

(statearr_19862_19882[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19850 === (9))){
var inst_19827 = (state_19849[(10)]);
var inst_19839 = (state_19849[(2)]);
var state_19849__$1 = (function (){var statearr_19863 = state_19849;
(statearr_19863[(9)] = inst_19839);

return statearr_19863;
})();
if(cljs.core.truth_(inst_19827)){
var statearr_19864_19883 = state_19849__$1;
(statearr_19864_19883[(1)] = (11));

} else {
var statearr_19865_19884 = state_19849__$1;
(statearr_19865_19884[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19850 === (5))){
var _ = (function (){var statearr_19866 = state_19849;
(statearr_19866[(4)] = cljs.core.rest((state_19849[(4)])));

return statearr_19866;
})();
var state_19849__$1 = state_19849;
var ex19861 = (state_19849__$1[(2)]);
var statearr_19867_19885 = state_19849__$1;
(statearr_19867_19885[(5)] = ex19861);


if((ex19861 instanceof Error)){
var statearr_19868_19886 = state_19849__$1;
(statearr_19868_19886[(1)] = (4));

(statearr_19868_19886[(5)] = null);

} else {
throw ex19861;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19850 === (10))){
var inst_19835 = (state_19849[(2)]);
var inst_19836 = fluree.db.util.async.throw_err(inst_19835);
var state_19849__$1 = state_19849;
var statearr_19869_19887 = state_19849__$1;
(statearr_19869_19887[(2)] = inst_19836);

(statearr_19869_19887[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19850 === (8))){
var inst_19831 = (state_19849[(8)]);
var state_19849__$1 = state_19849;
var statearr_19870_19888 = state_19849__$1;
(statearr_19870_19888[(2)] = inst_19831);

(statearr_19870_19888[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2727__auto____0 = (function (){
var statearr_19871 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19871[(0)] = fluree$db$query$analytical$q_$_state_machine__2727__auto__);

(statearr_19871[(1)] = (1));

return statearr_19871;
});
var fluree$db$query$analytical$q_$_state_machine__2727__auto____1 = (function (state_19849){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19849);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19872){var ex__2730__auto__ = e19872;
var statearr_19873_19889 = state_19849;
(statearr_19873_19889[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19849[(4)]))){
var statearr_19874_19890 = state_19849;
(statearr_19874_19890[(1)] = cljs.core.first((state_19849[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19891 = state_19849;
state_19849 = G__19891;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2727__auto__ = function(state_19849){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2727__auto____1.call(this,state_19849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2727__auto____0;
fluree$db$query$analytical$q_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19875 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19875[(6)] = c__2749__auto__);

return statearr_19875;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
