// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
goog.require('fluree.db.query.subject_crawl.core');
goog.require('fluree.db.query.fql_resp');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__22601 = arguments.length;
switch (G__22601) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__22602 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__22602) : f.call(null,G__22602));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__22603 = cljs.core._deref(vol);
var G__22604 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__22603,G__22604) : f.call(null,G__22603,G__22604));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__22605 = cljs.core._deref(vol);
var G__22606 = arg1;
var G__22607 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__22605,G__22606,G__22607) : f.call(null,G__22605,G__22606,G__22607));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__22608 = cljs.core._deref(vol);
var G__22609 = arg1;
var G__22610 = arg2;
var G__22611 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__22608,G__22609,G__22610,G__22611) : f.call(null,G__22608,G__22609,G__22610,G__22611));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__22614 = arguments.length;
switch (G__22614) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22616 = null;
var G__22616__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22616__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22616__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__22616 = function(result,flake){
switch(arguments.length){
case 0:
return G__22616__0.call(this);
case 1:
return G__22616__1.call(this,result);
case 2:
return G__22616__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22616.cljs$core$IFn$_invoke$arity$0 = G__22616__0;
G__22616.cljs$core$IFn$_invoke$arity$1 = G__22616__1;
G__22616.cljs$core$IFn$_invoke$arity$2 = G__22616__2;
return G__22616;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__22617_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__22617_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__22621 = vars;
var vec__22622 = G__22621;
var seq__22623 = cljs.core.seq(vec__22622);
var first__22624 = cljs.core.first(seq__22623);
var seq__22623__$1 = cljs.core.next(seq__22623);
var var$ = first__22624;
var r = seq__22623__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__22621__$1 = G__22621;
var all_vars__$1 = all_vars;
while(true){
var vec__22629 = G__22621__$1;
var seq__22630 = cljs.core.seq(vec__22629);
var first__22631 = cljs.core.first(seq__22630);
var seq__22630__$1 = cljs.core.next(seq__22630);
var var$__$1 = first__22631;
var r__$1 = seq__22630__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__22632 = cljs.core.set(all_vars__$2);
return (fexpr__22632.cljs$core$IFn$_invoke$arity$1 ? fexpr__22632.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__22632.call(null,var$__$1));
})())){
var G__22633 = r__$1;
var G__22634 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__22621__$1 = G__22633;
all_vars__$1 = G__22634;
continue;
} else {
var G__22635 = r__$1;
var G__22636 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__22621__$1 = G__22635;
all_vars__$1 = G__22636;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__22637){
var vec__22638 = p__22637;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22638,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22638,(1),null);
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22652){
var state_val_22653 = (state_22652[(1)]);
if((state_val_22653 === (1))){
var inst_22641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22642 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_22643 = [query_map,_id,query_opts];
var inst_22644 = cljs.core.PersistentHashMap.fromArrays(inst_22642,inst_22643);
var inst_22645 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_22644) : fluree.db.query.fql.query.call(null,db,inst_22644));
var state_22652__$1 = (function (){var statearr_22654 = state_22652;
(statearr_22654[(7)] = inst_22641);

return statearr_22654;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22652__$1,(2),inst_22645);
} else {
if((state_val_22653 === (2))){
var inst_22641 = (state_22652[(7)]);
var inst_22647 = (state_22652[(2)]);
var inst_22648 = fluree.db.util.async.throw_err(inst_22647);
var inst_22649 = [tuple_index,inst_22648];
var inst_22650 = (new cljs.core.PersistentVector(null,2,(5),inst_22641,inst_22649,null));
var state_22652__$1 = state_22652;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22652__$1,inst_22650);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0 = (function (){
var statearr_22655 = [null,null,null,null,null,null,null,null];
(statearr_22655[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2727__auto__);

(statearr_22655[(1)] = (1));

return statearr_22655;
});
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1 = (function (state_22652){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22652);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22656){var ex__2730__auto__ = e22656;
var statearr_22657_22660 = state_22652;
(statearr_22657_22660[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22652[(4)]))){
var statearr_22658_22661 = state_22652;
(statearr_22658_22661[(1)] = cljs.core.first((state_22652[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22662 = state_22652;
state_22652 = G__22662;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__ = function(state_22652){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1.call(this,state_22652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22659 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22659[(6)] = c__2749__auto__);

return statearr_22659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__22663 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22663,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22663,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22726){
var state_val_22727 = (state_22726[(1)]);
if((state_val_22727 === (7))){
var inst_22721 = (state_22726[(2)]);
var _ = (function (){var statearr_22728 = state_22726;
(statearr_22728[(4)] = cljs.core.rest((state_22726[(4)])));

return statearr_22728;
})();
var state_22726__$1 = state_22726;
var statearr_22729_22820 = state_22726__$1;
(statearr_22729_22820[(2)] = inst_22721);

(statearr_22729_22820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (20))){
var inst_22712 = (state_22726[(2)]);
var state_22726__$1 = state_22726;
var statearr_22730_22821 = state_22726__$1;
(statearr_22730_22821[(2)] = inst_22712);

(statearr_22730_22821[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (1))){
var state_22726__$1 = state_22726;
var statearr_22731_22822 = state_22726__$1;
(statearr_22731_22822[(2)] = null);

(statearr_22731_22822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (4))){
var inst_22668 = (state_22726[(2)]);
var state_22726__$1 = state_22726;
var statearr_22732_22823 = state_22726__$1;
(statearr_22732_22823[(2)] = inst_22668);

(statearr_22732_22823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (15))){
var inst_22688 = (state_22726[(7)]);
var inst_22697 = cljs.core.second(inst_22688);
var inst_22698 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22697);
var inst_22699 = (inst_22698 > max_fuel);
var state_22726__$1 = state_22726;
if(cljs.core.truth_(inst_22699)){
var statearr_22733_22824 = state_22726__$1;
(statearr_22733_22824[(1)] = (18));

} else {
var statearr_22734_22825 = state_22726__$1;
(statearr_22734_22825[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (13))){
var state_22726__$1 = state_22726;
var statearr_22735_22826 = state_22726__$1;
(statearr_22735_22826[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (6))){
var inst_22676 = (state_22726[(8)]);
var state_22726__$1 = state_22726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22726__$1,(8),inst_22676);
} else {
if((state_val_22727 === (17))){
var inst_22715 = (state_22726[(2)]);
var state_22726__$1 = state_22726;
var statearr_22737_22827 = state_22726__$1;
(statearr_22737_22827[(2)] = inst_22715);

(statearr_22737_22827[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (3))){
var inst_22724 = (state_22726[(2)]);
var state_22726__$1 = state_22726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22726__$1,inst_22724);
} else {
if((state_val_22727 === (12))){
var inst_22688 = (state_22726[(7)]);
var inst_22677 = (state_22726[(9)]);
var inst_22694 = (inst_22677.cljs$core$IFn$_invoke$arity$0 ? inst_22677.cljs$core$IFn$_invoke$arity$0() : inst_22677.call(null));
var state_22726__$1 = (function (){var statearr_22738 = state_22726;
(statearr_22738[(10)] = inst_22694);

return statearr_22738;
})();
var statearr_22739_22828 = state_22726__$1;
(statearr_22739_22828[(2)] = inst_22688);

(statearr_22739_22828[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (2))){
var inst_22676 = (state_22726[(8)]);
var inst_22677 = (state_22726[(9)]);
var _ = (function (){var statearr_22740 = state_22726;
(statearr_22740[(4)] = cljs.core.cons((5),(state_22726[(4)])));

return statearr_22740;
})();
var inst_22674 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_22675 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_22676__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_22677__$1 = (function (){var expandMaps = inst_22674;
var queue_ch = inst_22675;
var res_ch = inst_22676__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_22678 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_22679 = cljs.core.volatile_BANG_((0));
var inst_22680 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22678,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_22679);
var inst_22681 = (function (){var expandMaps = inst_22674;
var queue_ch = inst_22675;
var res_ch = inst_22676__$1;
var stop_BANG_ = inst_22677__$1;
var opts_STAR_ = inst_22680;
return (function (tuple_res,port){
var c__2749__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22773){
var state_val_22774 = (state_22773[(1)]);
if((state_val_22774 === (7))){
var state_22773__$1 = state_22773;
var statearr_22775_22829 = state_22773__$1;
(statearr_22775_22829[(2)] = tuple_res);

(statearr_22775_22829[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22774 === (1))){
var state_22773__$1 = state_22773;
var statearr_22776_22830 = state_22773__$1;
(statearr_22776_22830[(2)] = null);

(statearr_22776_22830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22774 === (4))){
var inst_22741 = (state_22773[(2)]);
var inst_22742 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_22741);
var inst_22743 = cljs.core.async.close_BANG_(port);
var state_22773__$1 = (function (){var statearr_22777 = state_22773;
(statearr_22777[(7)] = inst_22742);

return statearr_22777;
})();
var statearr_22778_22831 = state_22773__$1;
(statearr_22778_22831[(2)] = inst_22743);

(statearr_22778_22831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22774 === (6))){
var inst_22750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22751 = [tuple_res];
var inst_22752 = (new cljs.core.PersistentVector(null,1,(5),inst_22750,inst_22751,null));
var state_22773__$1 = state_22773;
var statearr_22779_22832 = state_22773__$1;
(statearr_22779_22832[(2)] = inst_22752);

(statearr_22779_22832[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22774 === (3))){
var inst_22771 = (state_22773[(2)]);
var state_22773__$1 = state_22773;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22773__$1,inst_22771);
} else {
if((state_val_22774 === (2))){
var ___$1 = (function (){var statearr_22781 = state_22773;
(statearr_22781[(4)] = cljs.core.cons((5),(state_22773[(4)])));

return statearr_22781;
})();
var state_22773__$1 = state_22773;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_22782_22833 = state_22773__$1;
(statearr_22782_22833[(1)] = (6));

} else {
var statearr_22783_22834 = state_22773__$1;
(statearr_22783_22834[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22774 === (9))){
var inst_22755 = (state_22773[(8)]);
var inst_22757 = (state_22773[(9)]);
var inst_22764 = (state_22773[(2)]);
var inst_22765 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_22755,inst_22764);
var inst_22766 = (inst_22757.cljs$core$IFn$_invoke$arity$1 ? inst_22757.cljs$core$IFn$_invoke$arity$1(inst_22765) : inst_22757.call(null,inst_22765));
var inst_22767 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_22766);
var inst_22768 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_22784 = state_22773;
(statearr_22784[(4)] = cljs.core.rest((state_22773[(4)])));

return statearr_22784;
})();
var state_22773__$1 = (function (){var statearr_22785 = state_22773;
(statearr_22785[(10)] = inst_22767);

return statearr_22785;
})();
var statearr_22786_22835 = state_22773__$1;
(statearr_22786_22835[(2)] = inst_22768);

(statearr_22786_22835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22774 === (5))){
var ___$1 = (function (){var statearr_22787 = state_22773;
(statearr_22787[(4)] = cljs.core.rest((state_22773[(4)])));

return statearr_22787;
})();
var state_22773__$1 = state_22773;
var ex22780 = (state_22773__$1[(2)]);
var statearr_22788_22836 = state_22773__$1;
(statearr_22788_22836[(5)] = ex22780);


var statearr_22789_22837 = state_22773__$1;
(statearr_22789_22837[(1)] = (4));

(statearr_22789_22837[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22774 === (8))){
var inst_22755 = (state_22773[(8)]);
var inst_22755__$1 = (state_22773[(2)]);
var inst_22756 = cljs.core.volatile_BANG_((0));
var inst_22757 = (function (){var tuple_res_SINGLEQUOTE_ = inst_22755__$1;
var query_fuel = inst_22756;
return (function (p1__22667_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__22667_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22667_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_22758 = cljs.core.PersistentVector.EMPTY;
var inst_22759 = (function (){var tuple_res_SINGLEQUOTE_ = inst_22755__$1;
var query_fuel = inst_22756;
return (function (p1__22666_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__22666_SHARP_);
});
})();
var inst_22760 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_22759,expandMaps);
var inst_22761 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_22760);
var inst_22762 = cljs.core.async.into(inst_22758,inst_22761);
var state_22773__$1 = (function (){var statearr_22790 = state_22773;
(statearr_22790[(8)] = inst_22755__$1);

(statearr_22790[(9)] = inst_22757);

return statearr_22790;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22773__$1,(9),inst_22762);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0 = (function (){
var statearr_22791 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22791[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__);

(statearr_22791[(1)] = (1));

return statearr_22791;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1 = (function (state_22773){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22773);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22792){var ex__2730__auto__ = e22792;
var statearr_22793_22838 = state_22773;
(statearr_22793_22838[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22773[(4)]))){
var statearr_22794_22839 = state_22773;
(statearr_22794_22839[(1)] = cljs.core.first((state_22773[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22840 = state_22773;
state_22773 = G__22840;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = function(state_22773){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1.call(this,state_22773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22795 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22795[(6)] = c__2749__auto____$1);

return statearr_22795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto____$1;
});
})();
var inst_22682 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_22675,tuples_res);
var inst_22683 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_22676__$1,inst_22681,inst_22675);
var inst_22684 = cljs.core.PersistentVector.EMPTY;
var inst_22685 = inst_22684;
var state_22726__$1 = (function (){var statearr_22796 = state_22726;
(statearr_22796[(11)] = inst_22682);

(statearr_22796[(12)] = inst_22683);

(statearr_22796[(8)] = inst_22676__$1);

(statearr_22796[(13)] = inst_22685);

(statearr_22796[(9)] = inst_22677__$1);

return statearr_22796;
})();
var statearr_22797_22841 = state_22726__$1;
(statearr_22797_22841[(2)] = null);

(statearr_22797_22841[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (19))){
var inst_22685 = (state_22726[(13)]);
var inst_22688 = (state_22726[(7)]);
var inst_22708 = cljs.core.first(inst_22688);
var inst_22709 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22685,inst_22708);
var inst_22685__$1 = inst_22709;
var state_22726__$1 = (function (){var statearr_22798 = state_22726;
(statearr_22798[(13)] = inst_22685__$1);

return statearr_22798;
})();
var statearr_22799_22842 = state_22726__$1;
(statearr_22799_22842[(2)] = null);

(statearr_22799_22842[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (11))){
var inst_22719 = (state_22726[(2)]);
var state_22726__$1 = state_22726;
var statearr_22801_22843 = state_22726__$1;
(statearr_22801_22843[(2)] = inst_22719);

(statearr_22801_22843[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (9))){
var inst_22685 = (state_22726[(13)]);
var state_22726__$1 = state_22726;
var statearr_22802_22844 = state_22726__$1;
(statearr_22802_22844[(2)] = inst_22685);

(statearr_22802_22844[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (5))){
var _ = (function (){var statearr_22803 = state_22726;
(statearr_22803[(4)] = cljs.core.rest((state_22726[(4)])));

return statearr_22803;
})();
var state_22726__$1 = state_22726;
var ex22800 = (state_22726__$1[(2)]);
var statearr_22804_22845 = state_22726__$1;
(statearr_22804_22845[(5)] = ex22800);


if((ex22800 instanceof Error)){
var statearr_22805_22846 = state_22726__$1;
(statearr_22805_22846[(1)] = (4));

(statearr_22805_22846[(5)] = null);

} else {
throw ex22800;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (14))){
var inst_22717 = (state_22726[(2)]);
var state_22726__$1 = state_22726;
var statearr_22806_22847 = state_22726__$1;
(statearr_22806_22847[(2)] = inst_22717);

(statearr_22806_22847[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (16))){
var state_22726__$1 = state_22726;
var statearr_22807_22848 = state_22726__$1;
(statearr_22807_22848[(2)] = null);

(statearr_22807_22848[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (10))){
var inst_22688 = (state_22726[(7)]);
var inst_22692 = fluree.db.util.core.exception_QMARK_(inst_22688);
var state_22726__$1 = state_22726;
if(inst_22692){
var statearr_22808_22849 = state_22726__$1;
(statearr_22808_22849[(1)] = (12));

} else {
var statearr_22809_22850 = state_22726__$1;
(statearr_22809_22850[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (18))){
var inst_22677 = (state_22726[(9)]);
var inst_22701 = (inst_22677.cljs$core$IFn$_invoke$arity$0 ? inst_22677.cljs$core$IFn$_invoke$arity$0() : inst_22677.call(null));
var inst_22702 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_22703 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_22704 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_22705 = cljs.core.PersistentHashMap.fromArrays(inst_22703,inst_22704);
var inst_22706 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_22702,inst_22705);
var state_22726__$1 = (function (){var statearr_22810 = state_22726;
(statearr_22810[(14)] = inst_22701);

return statearr_22810;
})();
var statearr_22811_22851 = state_22726__$1;
(statearr_22811_22851[(2)] = inst_22706);

(statearr_22811_22851[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22727 === (8))){
var inst_22688 = (state_22726[(7)]);
var inst_22688__$1 = (state_22726[(2)]);
var inst_22689 = (inst_22688__$1 == null);
var state_22726__$1 = (function (){var statearr_22812 = state_22726;
(statearr_22812[(7)] = inst_22688__$1);

return statearr_22812;
})();
if(cljs.core.truth_(inst_22689)){
var statearr_22813_22852 = state_22726__$1;
(statearr_22813_22852[(1)] = (9));

} else {
var statearr_22814_22853 = state_22726__$1;
(statearr_22814_22853[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0 = (function (){
var statearr_22815 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22815[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__);

(statearr_22815[(1)] = (1));

return statearr_22815;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1 = (function (state_22726){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22726);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22816){var ex__2730__auto__ = e22816;
var statearr_22817_22854 = state_22726;
(statearr_22817_22854[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22726[(4)]))){
var statearr_22818_22855 = state_22726;
(statearr_22818_22855[(1)] = cljs.core.first((state_22726[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22856 = state_22726;
state_22726 = G__22856;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = function(state_22726){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1.call(this,state_22726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22819 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22819[(6)] = c__2749__auto__);

return statearr_22819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__22857 = select;
var map__22857__$1 = cljs.core.__destructure_map(map__22857);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22857__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22857__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22857__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4253__auto__ = as;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__22860 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22860,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22860,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22860,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__22858_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__22858_SHARP_,compare_idx));
}):(function (p1__22859_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__22859_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__22865 = arguments.length;
switch (G__22865) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__22866,p__22867,group_limit,opts){
var map__22868 = p__22866;
var map__22868__$1 = cljs.core.__destructure_map(map__22868);
var res = map__22868__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22868__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__22869 = p__22867;
var map__22869__$1 = cljs.core.__destructure_map(map__22869);
var select_spec = map__22869__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22869__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22869__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22869__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22869__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22869__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22869__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22869__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22869__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22869__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22869__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23006){
var state_val_23007 = (state_23006[(1)]);
if((state_val_23007 === (7))){
var inst_22876 = (state_23006[(7)]);
var state_23006__$1 = state_23006;
var statearr_23008_23110 = state_23006__$1;
(statearr_23008_23110[(2)] = inst_22876);

(statearr_23008_23110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (59))){
var inst_22999 = (state_23006[(2)]);
var state_23006__$1 = state_23006;
var statearr_23009_23111 = state_23006__$1;
(statearr_23009_23111[(2)] = inst_22999);

(statearr_23009_23111[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (20))){
var inst_22912 = (state_23006[(8)]);
var inst_22915 = (state_23006[(9)]);
var inst_22911 = (state_23006[(2)]);
var inst_22912__$1 = cljs.core.__destructure_map(inst_22911);
var inst_22913 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22912__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_22914 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22912__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_22915__$1 = offset;
var state_23006__$1 = (function (){var statearr_23010 = state_23006;
(statearr_23010[(8)] = inst_22912__$1);

(statearr_23010[(9)] = inst_22915__$1);

(statearr_23010[(10)] = inst_22913);

(statearr_23010[(11)] = inst_22914);

return statearr_23010;
})();
if(cljs.core.truth_(inst_22915__$1)){
var statearr_23011_23112 = state_23006__$1;
(statearr_23011_23112[(1)] = (21));

} else {
var statearr_23012_23113 = state_23006__$1;
(statearr_23012_23113[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (58))){
var inst_22991 = (state_23006[(12)]);
var state_23006__$1 = state_23006;
var statearr_23013_23114 = state_23006__$1;
(statearr_23013_23114[(2)] = inst_22991);

(statearr_23013_23114[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (60))){
var inst_22995 = (state_23006[(2)]);
var inst_22996 = fluree.db.util.async.throw_err(inst_22995);
var state_23006__$1 = state_23006;
var statearr_23014_23115 = state_23006__$1;
(statearr_23014_23115[(2)] = inst_22996);

(statearr_23014_23115[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (27))){
var inst_22927 = cljs.core.not(inVector_QMARK_);
var state_23006__$1 = state_23006;
var statearr_23015_23116 = state_23006__$1;
(statearr_23015_23116[(2)] = inst_22927);

(statearr_23015_23116[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (1))){
var state_23006__$1 = state_23006;
var statearr_23016_23117 = state_23006__$1;
(statearr_23016_23117[(2)] = null);

(statearr_23016_23117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (24))){
var state_23006__$1 = state_23006;
var statearr_23017_23118 = state_23006__$1;
(statearr_23017_23118[(2)] = offset);

(statearr_23017_23118[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (55))){
var inst_22985 = (state_23006[(13)]);
var state_23006__$1 = state_23006;
var statearr_23018_23119 = state_23006__$1;
(statearr_23018_23119[(2)] = inst_22985);

(statearr_23018_23119[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (39))){
var inst_22953 = (state_23006[(14)]);
var inst_22955 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_22956 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22953,inst_22955);
var state_23006__$1 = state_23006;
var statearr_23019_23120 = state_23006__$1;
(statearr_23019_23120[(2)] = inst_22956);

(statearr_23019_23120[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (46))){
var inst_22965 = (state_23006[(15)]);
var state_23006__$1 = state_23006;
var statearr_23020_23121 = state_23006__$1;
(statearr_23020_23121[(2)] = inst_22965);

(statearr_23020_23121[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (4))){
var inst_22870 = (state_23006[(2)]);
var state_23006__$1 = state_23006;
var statearr_23021_23122 = state_23006__$1;
(statearr_23021_23122[(2)] = inst_22870);

(statearr_23021_23122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (54))){
var inst_22979 = (state_23006[(16)]);
var inst_22985 = (state_23006[(13)]);
var inst_22987 = cljs.core.PersistentVector.EMPTY;
var inst_22988 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_22987,inst_22979,inst_22985);
var state_23006__$1 = state_23006;
var statearr_23022_23123 = state_23006__$1;
(statearr_23022_23123[(2)] = inst_22988);

(statearr_23022_23123[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (15))){
var inst_22897 = (state_23006[(17)]);
var inst_22899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22900 = [inst_22897];
var inst_22901 = (new cljs.core.PersistentVector(null,1,(5),inst_22899,inst_22900,null));
var state_23006__$1 = state_23006;
var statearr_23023_23124 = state_23006__$1;
(statearr_23023_23124[(2)] = inst_22901);

(statearr_23023_23124[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (48))){
var inst_22912 = (state_23006[(8)]);
var inst_22930 = (state_23006[(18)]);
var inst_22935 = (state_23006[(19)]);
var inst_22924 = (state_23006[(20)]);
var inst_22971 = (state_23006[(21)]);
var inst_22913 = (state_23006[(10)]);
var inst_22914 = (state_23006[(11)]);
var inst_22973 = (function (){var map__22906 = inst_22912;
var headers = inst_22913;
var tuples = inst_22914;
var offset_SINGLEQUOTE_ = inst_22924;
var single_result_QMARK_ = inst_22930;
var pp_keys = inst_22935;
var G__22936 = inst_22971;
return (function (p1__22863_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__22863_SHARP_);
});
})();
var inst_22974 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_22973);
var inst_22975 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22971,inst_22974);
var state_23006__$1 = state_23006;
var statearr_23024_23125 = state_23006__$1;
(statearr_23024_23125[(2)] = inst_22975);

(statearr_23024_23125[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (50))){
var inst_22978 = (state_23006[(2)]);
var inst_22979 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_22978);
var state_23006__$1 = (function (){var statearr_23025 = state_23006;
(statearr_23025[(16)] = inst_22979);

return statearr_23025;
})();
if(cljs.core.truth_(orderBy)){
var statearr_23026_23126 = state_23006__$1;
(statearr_23026_23126[(1)] = (51));

} else {
var statearr_23027_23127 = state_23006__$1;
(statearr_23027_23127[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (21))){
var inst_22917 = cljs.core.not(groupBy);
var state_23006__$1 = state_23006;
var statearr_23028_23128 = state_23006__$1;
(statearr_23028_23128[(2)] = inst_22917);

(statearr_23028_23128[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (31))){
var state_23006__$1 = state_23006;
var statearr_23029_23129 = state_23006__$1;
(statearr_23029_23129[(2)] = null);

(statearr_23029_23129[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (32))){
var inst_22930 = (state_23006[(18)]);
var inst_22913 = (state_23006[(10)]);
var inst_22935 = (state_23006[(2)]);
var inst_22937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22938 = fluree.db.query.fql.select_tuples_fn(inst_22913,vars,select);
var inst_22939 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_22938);
var inst_22940 = [inst_22939];
var inst_22941 = (new cljs.core.PersistentVector(null,1,(5),inst_22937,inst_22940,null));
var state_23006__$1 = (function (){var statearr_23030 = state_23006;
(statearr_23030[(19)] = inst_22935);

(statearr_23030[(22)] = inst_22941);

return statearr_23030;
})();
if(cljs.core.truth_(inst_22930)){
var statearr_23031_23130 = state_23006__$1;
(statearr_23031_23130[(1)] = (33));

} else {
var statearr_23032_23131 = state_23006__$1;
(statearr_23032_23131[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (40))){
var inst_22953 = (state_23006[(14)]);
var state_23006__$1 = state_23006;
var statearr_23033_23132 = state_23006__$1;
(statearr_23033_23132[(2)] = inst_22953);

(statearr_23033_23132[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (56))){
var inst_22991 = (state_23006[(2)]);
var state_23006__$1 = (function (){var statearr_23034 = state_23006;
(statearr_23034[(12)] = inst_22991);

return statearr_23034;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_23035_23133 = state_23006__$1;
(statearr_23035_23133[(1)] = (57));

} else {
var statearr_23036_23134 = state_23006__$1;
(statearr_23036_23134[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (33))){
var inst_22941 = (state_23006[(22)]);
var inst_22943 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_22944 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22941,inst_22943);
var state_23006__$1 = state_23006;
var statearr_23037_23135 = state_23006__$1;
(statearr_23037_23135[(2)] = inst_22944);

(statearr_23037_23135[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (13))){
var inst_22886 = (state_23006[(23)]);
var state_23006__$1 = state_23006;
var statearr_23038_23136 = state_23006__$1;
(statearr_23038_23136[(2)] = inst_22886);

(statearr_23038_23136[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (22))){
var inst_22915 = (state_23006[(9)]);
var state_23006__$1 = state_23006;
var statearr_23039_23137 = state_23006__$1;
(statearr_23039_23137[(2)] = inst_22915);

(statearr_23039_23137[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (36))){
var inst_22947 = (state_23006[(24)]);
var inst_22949 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_22950 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22947,inst_22949);
var state_23006__$1 = state_23006;
var statearr_23040_23138 = state_23006__$1;
(statearr_23040_23138[(2)] = inst_22950);

(statearr_23040_23138[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (41))){
var inst_22924 = (state_23006[(20)]);
var inst_22959 = (state_23006[(2)]);
var state_23006__$1 = (function (){var statearr_23041 = state_23006;
(statearr_23041[(25)] = inst_22959);

return statearr_23041;
})();
if(cljs.core.truth_(inst_22924)){
var statearr_23042_23139 = state_23006__$1;
(statearr_23042_23139[(1)] = (42));

} else {
var statearr_23043_23140 = state_23006__$1;
(statearr_23043_23140[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (43))){
var inst_22959 = (state_23006[(25)]);
var state_23006__$1 = state_23006;
var statearr_23044_23141 = state_23006__$1;
(statearr_23044_23141[(2)] = inst_22959);

(statearr_23044_23141[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (29))){
var inst_22930 = (state_23006[(2)]);
var state_23006__$1 = (function (){var statearr_23045 = state_23006;
(statearr_23045[(18)] = inst_22930);

return statearr_23045;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_23046_23142 = state_23006__$1;
(statearr_23046_23142[(1)] = (30));

} else {
var statearr_23047_23143 = state_23006__$1;
(statearr_23047_23143[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (44))){
var inst_22965 = (state_23006[(2)]);
var state_23006__$1 = (function (){var statearr_23048 = state_23006;
(statearr_23048[(15)] = inst_22965);

return statearr_23048;
})();
if(cljs.core.truth_(group_limit)){
var statearr_23049_23144 = state_23006__$1;
(statearr_23049_23144[(1)] = (45));

} else {
var statearr_23050_23145 = state_23006__$1;
(statearr_23050_23145[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (6))){
var inst_22878 = cljs.core.count(select);
var inst_22879 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_22878);
var state_23006__$1 = state_23006;
var statearr_23051_23146 = state_23006__$1;
(statearr_23051_23146[(2)] = inst_22879);

(statearr_23051_23146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (28))){
var inst_22925 = (state_23006[(26)]);
var state_23006__$1 = state_23006;
var statearr_23052_23147 = state_23006__$1;
(statearr_23052_23147[(2)] = inst_22925);

(statearr_23052_23147[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (51))){
var inst_22913 = (state_23006[(10)]);
var inst_22914 = (state_23006[(11)]);
var inst_22982 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_22913,orderBy,inst_22914);
var state_23006__$1 = state_23006;
var statearr_23053_23148 = state_23006__$1;
(statearr_23053_23148[(2)] = inst_22982);

(statearr_23053_23148[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (25))){
var state_23006__$1 = state_23006;
var statearr_23054_23149 = state_23006__$1;
(statearr_23054_23149[(2)] = null);

(statearr_23054_23149[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (34))){
var inst_22941 = (state_23006[(22)]);
var state_23006__$1 = state_23006;
var statearr_23055_23150 = state_23006__$1;
(statearr_23055_23150[(2)] = inst_22941);

(statearr_23055_23150[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (17))){
var inst_22904 = (state_23006[(2)]);
var state_23006__$1 = state_23006;
var statearr_23056_23151 = state_23006__$1;
(statearr_23056_23151[(2)] = inst_22904);

(statearr_23056_23151[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (3))){
var inst_23004 = (state_23006[(2)]);
var state_23006__$1 = state_23006;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23006__$1,inst_23004);
} else {
if((state_val_23007 === (12))){
var inst_22886 = (state_23006[(23)]);
var inst_22888 = cljs.core.first(select);
var inst_22889 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22888);
var inst_22890 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_22889);
var inst_22891 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_22890,(1));
var inst_22892 = [inst_22891];
var inst_22893 = [inst_22886];
var inst_22894 = cljs.core.PersistentHashMap.fromArrays(inst_22892,inst_22893);
var state_23006__$1 = state_23006;
var statearr_23057_23152 = state_23006__$1;
(statearr_23057_23152[(2)] = inst_22894);

(statearr_23057_23152[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (2))){
var inst_22876 = (state_23006[(7)]);
var _ = (function (){var statearr_23058 = state_23006;
(statearr_23058[(4)] = cljs.core.cons((5),(state_23006[(4)])));

return statearr_23058;
})();
var inst_22876__$1 = aggregates;
var state_23006__$1 = (function (){var statearr_23059 = state_23006;
(statearr_23059[(7)] = inst_22876__$1);

return statearr_23059;
})();
if(cljs.core.truth_(inst_22876__$1)){
var statearr_23060_23153 = state_23006__$1;
(statearr_23060_23153[(1)] = (6));

} else {
var statearr_23061_23154 = state_23006__$1;
(statearr_23061_23154[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (23))){
var inst_22920 = (state_23006[(2)]);
var state_23006__$1 = state_23006;
if(cljs.core.truth_(inst_22920)){
var statearr_23062_23155 = state_23006__$1;
(statearr_23062_23155[(1)] = (24));

} else {
var statearr_23063_23156 = state_23006__$1;
(statearr_23063_23156[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (47))){
var inst_22971 = (state_23006[(2)]);
var state_23006__$1 = (function (){var statearr_23064 = state_23006;
(statearr_23064[(21)] = inst_22971);

return statearr_23064;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_23065_23157 = state_23006__$1;
(statearr_23065_23157[(1)] = (48));

} else {
var statearr_23066_23158 = state_23006__$1;
(statearr_23066_23158[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (35))){
var inst_22947 = (state_23006[(2)]);
var state_23006__$1 = (function (){var statearr_23067 = state_23006;
(statearr_23067[(24)] = inst_22947);

return statearr_23067;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_23068_23159 = state_23006__$1;
(statearr_23068_23159[(1)] = (36));

} else {
var statearr_23069_23160 = state_23006__$1;
(statearr_23069_23160[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (19))){
var state_23006__$1 = state_23006;
var statearr_23070_23161 = state_23006__$1;
(statearr_23070_23161[(2)] = res);

(statearr_23070_23161[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (57))){
var inst_22930 = (state_23006[(18)]);
var inst_22935 = (state_23006[(19)]);
var inst_22991 = (state_23006[(12)]);
var inst_22993 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_22935,inst_22930,db,fuel,max_fuel,opts,(8),inst_22991);
var state_23006__$1 = state_23006;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23006__$1,(60),inst_22993);
} else {
if((state_val_23007 === (11))){
var inst_23001 = (state_23006[(2)]);
var _ = (function (){var statearr_23072 = state_23006;
(statearr_23072[(4)] = cljs.core.rest((state_23006[(4)])));

return statearr_23072;
})();
var state_23006__$1 = state_23006;
var statearr_23073_23162 = state_23006__$1;
(statearr_23073_23162[(2)] = inst_23001);

(statearr_23073_23162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (9))){
var inst_22884 = cljs.core.first(aggregates);
var inst_22885 = fluree.db.query.analytical.calculate_aggregate(res,inst_22884);
var inst_22886 = cljs.core.second(inst_22885);
var state_23006__$1 = (function (){var statearr_23074 = state_23006;
(statearr_23074[(23)] = inst_22886);

return statearr_23074;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_23075_23163 = state_23006__$1;
(statearr_23075_23163[(1)] = (12));

} else {
var statearr_23076_23164 = state_23006__$1;
(statearr_23076_23164[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (5))){
var _ = (function (){var statearr_23077 = state_23006;
(statearr_23077[(4)] = cljs.core.rest((state_23006[(4)])));

return statearr_23077;
})();
var state_23006__$1 = state_23006;
var ex23071 = (state_23006__$1[(2)]);
var statearr_23078_23165 = state_23006__$1;
(statearr_23078_23165[(5)] = ex23071);


if((ex23071 instanceof Error)){
var statearr_23079_23166 = state_23006__$1;
(statearr_23079_23166[(1)] = (4));

(statearr_23079_23166[(5)] = null);

} else {
throw ex23071;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (14))){
var inst_22897 = (state_23006[(2)]);
var state_23006__$1 = (function (){var statearr_23080 = state_23006;
(statearr_23080[(17)] = inst_22897);

return statearr_23080;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_23081_23167 = state_23006__$1;
(statearr_23081_23167[(1)] = (15));

} else {
var statearr_23082_23168 = state_23006__$1;
(statearr_23082_23168[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (45))){
var inst_22965 = (state_23006[(15)]);
var inst_22967 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_22968 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22965,inst_22967);
var state_23006__$1 = state_23006;
var statearr_23083_23169 = state_23006__$1;
(statearr_23083_23169[(2)] = inst_22968);

(statearr_23083_23169[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (53))){
var inst_22985 = (state_23006[(2)]);
var state_23006__$1 = (function (){var statearr_23084 = state_23006;
(statearr_23084[(13)] = inst_22985);

return statearr_23084;
})();
var statearr_23085_23170 = state_23006__$1;
(statearr_23085_23170[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (26))){
var inst_22925 = (state_23006[(26)]);
var inst_22924 = (state_23006[(2)]);
var inst_22925__$1 = cljs.core.not(prettyPrint);
var state_23006__$1 = (function (){var statearr_23087 = state_23006;
(statearr_23087[(26)] = inst_22925__$1);

(statearr_23087[(20)] = inst_22924);

return statearr_23087;
})();
if(inst_22925__$1){
var statearr_23088_23171 = state_23006__$1;
(statearr_23088_23171[(1)] = (27));

} else {
var statearr_23089_23172 = state_23006__$1;
(statearr_23089_23172[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (16))){
var inst_22897 = (state_23006[(17)]);
var state_23006__$1 = state_23006;
var statearr_23090_23173 = state_23006__$1;
(statearr_23090_23173[(2)] = inst_22897);

(statearr_23090_23173[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (38))){
var inst_22953 = (state_23006[(2)]);
var state_23006__$1 = (function (){var statearr_23091 = state_23006;
(statearr_23091[(14)] = inst_22953);

return statearr_23091;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_23092_23174 = state_23006__$1;
(statearr_23092_23174[(1)] = (39));

} else {
var statearr_23093_23175 = state_23006__$1;
(statearr_23093_23175[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (30))){
var inst_22932 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_23006__$1 = state_23006;
var statearr_23094_23176 = state_23006__$1;
(statearr_23094_23176[(2)] = inst_22932);

(statearr_23094_23176[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (10))){
var state_23006__$1 = state_23006;
if(cljs.core.truth_(aggregates)){
var statearr_23095_23177 = state_23006__$1;
(statearr_23095_23177[(1)] = (18));

} else {
var statearr_23096_23178 = state_23006__$1;
(statearr_23096_23178[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (18))){
var inst_22908 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_23006__$1 = state_23006;
var statearr_23097_23179 = state_23006__$1;
(statearr_23097_23179[(2)] = inst_22908);

(statearr_23097_23179[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (52))){
var inst_22914 = (state_23006[(11)]);
var state_23006__$1 = state_23006;
var statearr_23098_23180 = state_23006__$1;
(statearr_23098_23180[(2)] = inst_22914);

(statearr_23098_23180[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (42))){
var inst_22924 = (state_23006[(20)]);
var inst_22959 = (state_23006[(25)]);
var inst_22961 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_22924);
var inst_22962 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22959,inst_22961);
var state_23006__$1 = state_23006;
var statearr_23099_23181 = state_23006__$1;
(statearr_23099_23181[(2)] = inst_22962);

(statearr_23099_23181[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (37))){
var inst_22947 = (state_23006[(24)]);
var state_23006__$1 = state_23006;
var statearr_23100_23182 = state_23006__$1;
(statearr_23100_23182[(2)] = inst_22947);

(statearr_23100_23182[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (8))){
var inst_22882 = (state_23006[(2)]);
var state_23006__$1 = state_23006;
if(cljs.core.truth_(inst_22882)){
var statearr_23101_23183 = state_23006__$1;
(statearr_23101_23183[(1)] = (9));

} else {
var statearr_23102_23184 = state_23006__$1;
(statearr_23102_23184[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23007 === (49))){
var inst_22971 = (state_23006[(21)]);
var state_23006__$1 = state_23006;
var statearr_23103_23185 = state_23006__$1;
(statearr_23103_23185[(2)] = inst_22971);

(statearr_23103_23185[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_23104 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23104[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_23104[(1)] = (1));

return statearr_23104;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_23006){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23006);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23105){var ex__2730__auto__ = e23105;
var statearr_23106_23186 = state_23006;
(statearr_23106_23186[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23006[(4)]))){
var statearr_23107_23187 = state_23006;
(statearr_23107_23187[(1)] = cljs.core.first((state_23006[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23188 = state_23006;
state_23006 = G__23188;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_23006){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_23006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23108 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23108[(6)] = c__2749__auto__);

return statearr_23108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__23191,groupBy){
var map__23192 = p__23191;
var map__23192__$1 = cljs.core.__destructure_map(map__23192);
var res = map__23192__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23192__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23192__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__23193 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23193,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23193,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__23189_SHARP_){
return fluree.db.util.core.index_of(headers,p1__23189_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__23190_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__23190_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__23196 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23196,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23196,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__23199,p__23200,opts){
var map__23201 = p__23199;
var map__23201__$1 = cljs.core.__destructure_map(map__23201);
var res = map__23201__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23201__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23201__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__23202 = p__23200;
var map__23202__$1 = cljs.core.__destructure_map(map__23202);
var select_spec = map__23202__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23202__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23202__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23202__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23202__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23202__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23202__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23202__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23444){
var state_val_23445 = (state_23444[(1)]);
if((state_val_23445 === (65))){
var state_23444__$1 = state_23444;
var statearr_23446_23597 = state_23444__$1;
(statearr_23446_23597[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (70))){
var inst_23365 = (state_23444[(7)]);
var state_23444__$1 = state_23444;
var statearr_23448_23598 = state_23444__$1;
(statearr_23448_23598[(2)] = inst_23365);

(statearr_23448_23598[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (62))){
var state_23444__$1 = state_23444;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_23449_23599 = state_23444__$1;
(statearr_23449_23599[(1)] = (64));

} else {
var statearr_23450_23600 = state_23444__$1;
(statearr_23450_23600[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (74))){
var inst_23281 = (state_23444[(8)]);
var inst_23340 = (state_23444[(9)]);
var inst_23272 = (state_23444[(10)]);
var inst_23373 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23272,inst_23281,inst_23340);
var state_23444__$1 = state_23444;
var statearr_23451_23601 = state_23444__$1;
(statearr_23451_23601[(2)] = inst_23373);

(statearr_23451_23601[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (7))){
var state_23444__$1 = state_23444;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_23452_23602 = state_23444__$1;
(statearr_23452_23602[(1)] = (82));

} else {
var statearr_23453_23603 = state_23444__$1;
(statearr_23453_23603[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (59))){
var inst_23270 = (state_23444[(11)]);
var inst_23340 = (state_23444[(9)]);
var inst_23344 = cljs.core.count(inst_23340);
var inst_23345 = (inst_23270 - inst_23344);
var state_23444__$1 = state_23444;
var statearr_23454_23604 = state_23444__$1;
(statearr_23454_23604[(2)] = inst_23345);

(statearr_23454_23604[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (86))){
var state_23444__$1 = state_23444;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_23455_23605 = state_23444__$1;
(statearr_23455_23605[(1)] = (89));

} else {
var statearr_23456_23606 = state_23444__$1;
(statearr_23456_23606[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (20))){
var state_23444__$1 = state_23444;
var statearr_23457_23607 = state_23444__$1;
(statearr_23457_23607[(2)] = (0));

(statearr_23457_23607[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (72))){
var inst_23370 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
if(cljs.core.truth_(inst_23370)){
var statearr_23458_23608 = state_23444__$1;
(statearr_23458_23608[(1)] = (73));

} else {
var statearr_23459_23609 = state_23444__$1;
(statearr_23459_23609[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (58))){
var state_23444__$1 = state_23444;
var statearr_23460_23610 = state_23444__$1;
(statearr_23460_23610[(2)] = null);

(statearr_23460_23610[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (60))){
var inst_23271 = (state_23444[(12)]);
var inst_23347 = (state_23444[(2)]);
var inst_23348 = (inst_23271 <= (0));
var state_23444__$1 = (function (){var statearr_23461 = state_23444;
(statearr_23461[(13)] = inst_23347);

return statearr_23461;
})();
if(cljs.core.truth_(inst_23348)){
var statearr_23462_23611 = state_23444__$1;
(statearr_23462_23611[(1)] = (61));

} else {
var statearr_23463_23612 = state_23444__$1;
(statearr_23463_23612[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (27))){
var inst_23270 = (state_23444[(11)]);
var inst_23294 = (inst_23270 < (1));
var state_23444__$1 = state_23444;
var statearr_23464_23613 = state_23444__$1;
(statearr_23464_23613[(2)] = inst_23294);

(statearr_23464_23613[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (1))){
var state_23444__$1 = state_23444;
var statearr_23465_23614 = state_23444__$1;
(statearr_23465_23614[(2)] = null);

(statearr_23465_23614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (69))){
var inst_23360 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
var statearr_23466_23615 = state_23444__$1;
(statearr_23466_23615[(2)] = inst_23360);

(statearr_23466_23615[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (24))){
var inst_23272 = (state_23444[(10)]);
var state_23444__$1 = state_23444;
var statearr_23467_23616 = state_23444__$1;
(statearr_23467_23616[(2)] = inst_23272);

(statearr_23467_23616[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (55))){
var inst_23270 = (state_23444[(11)]);
var inst_23330 = (state_23444[(14)]);
var inst_23337 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_23270,inst_23330);
var state_23444__$1 = state_23444;
var statearr_23468_23617 = state_23444__$1;
(statearr_23468_23617[(2)] = inst_23337);

(statearr_23468_23617[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (85))){
var inst_23415 = (state_23444[(15)]);
var inst_23414 = (state_23444[(2)]);
var inst_23415__$1 = fluree.db.util.async.throw_err(inst_23414);
var inst_23416 = cljs.core.coll_QMARK_(inst_23415__$1);
var inst_23417 = (!(inst_23416));
var state_23444__$1 = (function (){var statearr_23469 = state_23444;
(statearr_23469[(15)] = inst_23415__$1);

return statearr_23469;
})();
if(inst_23417){
var statearr_23470_23618 = state_23444__$1;
(statearr_23470_23618[(1)] = (86));

} else {
var statearr_23471_23619 = state_23444__$1;
(statearr_23471_23619[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (39))){
var inst_23289 = (state_23444[(16)]);
var inst_23311 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_23312 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_23313 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_23289,inst_23311,inst_23312);
var state_23444__$1 = state_23444;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23444__$1,(42),inst_23313);
} else {
if((state_val_23445 === (88))){
var inst_23437 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
var statearr_23472_23620 = state_23444__$1;
(statearr_23472_23620[(2)] = inst_23437);

(statearr_23472_23620[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (46))){
var inst_23271 = (state_23444[(12)]);
var inst_23325 = ((0) < inst_23271);
var state_23444__$1 = state_23444;
if(cljs.core.truth_(inst_23325)){
var statearr_23473_23621 = state_23444__$1;
(statearr_23473_23621[(1)] = (49));

} else {
var statearr_23474_23622 = state_23444__$1;
(statearr_23474_23622[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (4))){
var inst_23203 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
var statearr_23475_23623 = state_23444__$1;
(statearr_23475_23623[(2)] = inst_23203);

(statearr_23475_23623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (77))){
var inst_23270 = (state_23444[(11)]);
var inst_23381 = (inst_23270 - (1));
var state_23444__$1 = state_23444;
var statearr_23476_23624 = state_23444__$1;
(statearr_23476_23624[(2)] = inst_23381);

(statearr_23476_23624[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (95))){
var inst_23415 = (state_23444[(15)]);
var state_23444__$1 = state_23444;
var statearr_23477_23625 = state_23444__$1;
(statearr_23477_23625[(2)] = inst_23415);

(statearr_23477_23625[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (54))){
var inst_23335 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
if(cljs.core.truth_(inst_23335)){
var statearr_23478_23626 = state_23444__$1;
(statearr_23478_23626[(1)] = (55));

} else {
var statearr_23479_23627 = state_23444__$1;
(statearr_23479_23627[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (92))){
var inst_23415 = (state_23444[(15)]);
var inst_23428 = cljs.core.first(inst_23415);
var state_23444__$1 = state_23444;
var statearr_23480_23628 = state_23444__$1;
(statearr_23480_23628[(2)] = inst_23428);

(statearr_23480_23628[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (15))){
var inst_23221 = (state_23444[(17)]);
var inst_23229 = (state_23444[(2)]);
var inst_23230 = fluree.db.util.async.throw_err(inst_23229);
var inst_23231 = [inst_23221];
var inst_23232 = [inst_23230];
var inst_23233 = cljs.core.PersistentHashMap.fromArrays(inst_23231,inst_23232);
var state_23444__$1 = state_23444;
var statearr_23481_23629 = state_23444__$1;
(statearr_23481_23629[(2)] = inst_23233);

(statearr_23481_23629[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (48))){
var inst_23393 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
var statearr_23482_23630 = state_23444__$1;
(statearr_23482_23630[(2)] = inst_23393);

(statearr_23482_23630[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (50))){
var inst_23316 = (state_23444[(18)]);
var state_23444__$1 = state_23444;
var statearr_23483_23631 = state_23444__$1;
(statearr_23483_23631[(2)] = inst_23316);

(statearr_23483_23631[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (75))){
var inst_23364 = (state_23444[(19)]);
var inst_23285 = (state_23444[(20)]);
var inst_23282 = (state_23444[(21)]);
var inst_23347 = (state_23444[(13)]);
var inst_23375 = (state_23444[(2)]);
var inst_23268 = inst_23282;
var inst_23269 = inst_23285;
var inst_23270 = inst_23347;
var inst_23271 = inst_23364;
var inst_23272 = inst_23375;
var state_23444__$1 = (function (){var statearr_23484 = state_23444;
(statearr_23484[(22)] = inst_23268);

(statearr_23484[(11)] = inst_23270);

(statearr_23484[(23)] = inst_23269);

(statearr_23484[(10)] = inst_23272);

(statearr_23484[(12)] = inst_23271);

return statearr_23484;
})();
var statearr_23485_23632 = state_23444__$1;
(statearr_23485_23632[(2)] = null);

(statearr_23485_23632[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (21))){
var inst_23253 = (state_23444[(24)]);
var inst_23261 = (state_23444[(25)]);
var inst_23249 = (state_23444[(26)]);
var inst_23266 = (state_23444[(2)]);
var inst_23267 = cljs.core.PersistentHashMap.EMPTY;
var inst_23268 = inst_23249;
var inst_23269 = inst_23253;
var inst_23270 = inst_23261;
var inst_23271 = inst_23266;
var inst_23272 = inst_23267;
var state_23444__$1 = (function (){var statearr_23486 = state_23444;
(statearr_23486[(22)] = inst_23268);

(statearr_23486[(11)] = inst_23270);

(statearr_23486[(23)] = inst_23269);

(statearr_23486[(10)] = inst_23272);

(statearr_23486[(12)] = inst_23271);

return statearr_23486;
})();
var statearr_23487_23633 = state_23444__$1;
(statearr_23487_23633[(2)] = null);

(statearr_23487_23633[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (31))){
var inst_23286 = (state_23444[(27)]);
var inst_23271 = (state_23444[(12)]);
var inst_23300 = (inst_23271 >= inst_23286);
var state_23444__$1 = state_23444;
if(cljs.core.truth_(inst_23300)){
var statearr_23488_23634 = state_23444__$1;
(statearr_23488_23634[(1)] = (33));

} else {
var statearr_23489_23635 = state_23444__$1;
(statearr_23489_23635[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (32))){
var inst_23400 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
var statearr_23490_23636 = state_23444__$1;
(statearr_23490_23636[(2)] = inst_23400);

(statearr_23490_23636[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (40))){
var state_23444__$1 = state_23444;
var statearr_23491_23637 = state_23444__$1;
(statearr_23491_23637[(2)] = null);

(statearr_23491_23637[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (91))){
var inst_23425 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
var statearr_23492_23638 = state_23444__$1;
(statearr_23492_23638[(2)] = inst_23425);

(statearr_23492_23638[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (56))){
var inst_23330 = (state_23444[(14)]);
var state_23444__$1 = state_23444;
var statearr_23493_23639 = state_23444__$1;
(statearr_23493_23639[(2)] = inst_23330);

(statearr_23493_23639[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (33))){
var state_23444__$1 = state_23444;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_23494_23640 = state_23444__$1;
(statearr_23494_23640[(1)] = (36));

} else {
var statearr_23495_23641 = state_23444__$1;
(statearr_23495_23641[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (13))){
var inst_23253 = (state_23444[(24)]);
var inst_23218 = (state_23444[(28)]);
var inst_23249 = (state_23444[(26)]);
var inst_23249__$1 = cljs.core.keys(inst_23218);
var inst_23250 = cljs.core.seq(inst_23249__$1);
var inst_23251 = cljs.core.first(inst_23250);
var inst_23252 = cljs.core.next(inst_23250);
var inst_23253__$1 = cljs.core.vals(inst_23218);
var inst_23254 = cljs.core.seq(inst_23253__$1);
var inst_23255 = cljs.core.first(inst_23254);
var inst_23256 = cljs.core.next(inst_23254);
var inst_23257 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_23444__$1 = (function (){var statearr_23496 = state_23444;
(statearr_23496[(29)] = inst_23255);

(statearr_23496[(30)] = inst_23252);

(statearr_23496[(31)] = inst_23256);

(statearr_23496[(24)] = inst_23253__$1);

(statearr_23496[(26)] = inst_23249__$1);

(statearr_23496[(32)] = inst_23251);

return statearr_23496;
})();
if(inst_23257){
var statearr_23497_23642 = state_23444__$1;
(statearr_23497_23642[(1)] = (16));

} else {
var statearr_23498_23643 = state_23444__$1;
(statearr_23498_23643[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (22))){
var inst_23268 = (state_23444[(22)]);
var inst_23269 = (state_23444[(23)]);
var inst_23280 = cljs.core.seq(inst_23268);
var inst_23281 = cljs.core.first(inst_23280);
var inst_23282 = cljs.core.next(inst_23280);
var inst_23283 = cljs.core.seq(inst_23269);
var inst_23284 = cljs.core.first(inst_23283);
var inst_23285 = cljs.core.next(inst_23283);
var inst_23286 = cljs.core.count(inst_23284);
var inst_23287 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_23288 = [headers,vars,inst_23284];
var inst_23289 = cljs.core.PersistentHashMap.fromArrays(inst_23287,inst_23288);
var inst_23290 = (inst_23284 == null);
var state_23444__$1 = (function (){var statearr_23499 = state_23444;
(statearr_23499[(20)] = inst_23285);

(statearr_23499[(21)] = inst_23282);

(statearr_23499[(16)] = inst_23289);

(statearr_23499[(8)] = inst_23281);

(statearr_23499[(27)] = inst_23286);

return statearr_23499;
})();
if(cljs.core.truth_(inst_23290)){
var statearr_23500_23644 = state_23444__$1;
(statearr_23500_23644[(1)] = (24));

} else {
var statearr_23501_23645 = state_23444__$1;
(statearr_23501_23645[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (90))){
var inst_23415 = (state_23444[(15)]);
var state_23444__$1 = state_23444;
var statearr_23502_23646 = state_23444__$1;
(statearr_23502_23646[(2)] = inst_23415);

(statearr_23502_23646[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (36))){
var inst_23271 = (state_23444[(12)]);
var inst_23303 = (inst_23271 - (1));
var state_23444__$1 = state_23444;
var statearr_23503_23647 = state_23444__$1;
(statearr_23503_23647[(2)] = inst_23303);

(statearr_23503_23647[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (41))){
var inst_23396 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
var statearr_23504_23648 = state_23444__$1;
(statearr_23504_23648[(2)] = inst_23396);

(statearr_23504_23648[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (89))){
var inst_23415 = (state_23444[(15)]);
var inst_23420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23421 = [inst_23415];
var inst_23422 = (new cljs.core.PersistentVector(null,1,(5),inst_23420,inst_23421,null));
var state_23444__$1 = state_23444;
var statearr_23505_23649 = state_23444__$1;
(statearr_23505_23649[(2)] = inst_23422);

(statearr_23505_23649[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (43))){
var inst_23316 = (state_23444[(18)]);
var inst_23319 = cljs.core.seq(inst_23316);
var state_23444__$1 = state_23444;
var statearr_23506_23650 = state_23444__$1;
(statearr_23506_23650[(2)] = inst_23319);

(statearr_23506_23650[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (61))){
var state_23444__$1 = state_23444;
var statearr_23507_23651 = state_23444__$1;
(statearr_23507_23651[(2)] = (0));

(statearr_23507_23651[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (29))){
var inst_23297 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
if(cljs.core.truth_(inst_23297)){
var statearr_23508_23652 = state_23444__$1;
(statearr_23508_23652[(1)] = (30));

} else {
var statearr_23509_23653 = state_23444__$1;
(statearr_23509_23653[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (44))){
var inst_23317 = (state_23444[(33)]);
var state_23444__$1 = state_23444;
var statearr_23510_23654 = state_23444__$1;
(statearr_23510_23654[(2)] = inst_23317);

(statearr_23510_23654[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (93))){
var state_23444__$1 = state_23444;
var statearr_23511_23655 = state_23444__$1;
(statearr_23511_23655[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (6))){
var inst_23210 = (state_23444[(34)]);
var inst_23210__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_23212 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_23444__$1 = (function (){var statearr_23513 = state_23444;
(statearr_23513[(34)] = inst_23210__$1);

(statearr_23513[(35)] = inst_23212);

return statearr_23513;
})();
if(cljs.core.truth_(inst_23210__$1)){
var statearr_23514_23656 = state_23444__$1;
(statearr_23514_23656[(1)] = (9));

} else {
var statearr_23515_23657 = state_23444__$1;
(statearr_23515_23657[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (28))){
var inst_23270 = (state_23444[(11)]);
var state_23444__$1 = state_23444;
var statearr_23516_23658 = state_23444__$1;
(statearr_23516_23658[(2)] = inst_23270);

(statearr_23516_23658[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (64))){
var inst_23271 = (state_23444[(12)]);
var inst_23352 = (inst_23271 - (1));
var state_23444__$1 = state_23444;
var statearr_23517_23659 = state_23444__$1;
(statearr_23517_23659[(2)] = inst_23352);

(statearr_23517_23659[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (51))){
var inst_23270 = (state_23444[(11)]);
var inst_23330 = (state_23444[(2)]);
var state_23444__$1 = (function (){var statearr_23518 = state_23444;
(statearr_23518[(14)] = inst_23330);

return statearr_23518;
})();
if(cljs.core.truth_(inst_23270)){
var statearr_23519_23660 = state_23444__$1;
(statearr_23519_23660[(1)] = (52));

} else {
var statearr_23520_23661 = state_23444__$1;
(statearr_23520_23661[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (25))){
var inst_23270 = (state_23444[(11)]);
var state_23444__$1 = state_23444;
if(cljs.core.truth_(inst_23270)){
var statearr_23521_23662 = state_23444__$1;
(statearr_23521_23662[(1)] = (27));

} else {
var statearr_23522_23663 = state_23444__$1;
(statearr_23522_23663[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (34))){
var state_23444__$1 = state_23444;
var statearr_23523_23664 = state_23444__$1;
(statearr_23523_23664[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (17))){
var state_23444__$1 = state_23444;
var statearr_23525_23665 = state_23444__$1;
(statearr_23525_23665[(2)] = limit);

(statearr_23525_23665[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (3))){
var inst_23442 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23444__$1,inst_23442);
} else {
if((state_val_23445 === (12))){
var inst_23218 = (state_23444[(28)]);
var inst_23220 = cljs.core.keys(inst_23218);
var inst_23221 = cljs.core.first(inst_23220);
var inst_23222 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_23223 = cljs.core.vals(inst_23218);
var inst_23224 = cljs.core.first(inst_23223);
var inst_23225 = [headers,vars,inst_23224];
var inst_23226 = cljs.core.PersistentHashMap.fromArrays(inst_23222,inst_23225);
var inst_23227 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_23226,select_spec,limit,opts);
var state_23444__$1 = (function (){var statearr_23526 = state_23444;
(statearr_23526[(17)] = inst_23221);

return statearr_23526;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23444__$1,(15),inst_23227);
} else {
if((state_val_23445 === (2))){
var _ = (function (){var statearr_23527 = state_23444;
(statearr_23527[(4)] = cljs.core.cons((5),(state_23444[(4)])));

return statearr_23527;
})();
var state_23444__$1 = state_23444;
if(cljs.core.truth_(groupBy)){
var statearr_23528_23666 = state_23444__$1;
(statearr_23528_23666[(1)] = (6));

} else {
var statearr_23529_23667 = state_23444__$1;
(statearr_23529_23667[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (66))){
var inst_23362 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
var statearr_23530_23668 = state_23444__$1;
(statearr_23530_23668[(2)] = inst_23362);

(statearr_23530_23668[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (23))){
var inst_23404 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
var statearr_23531_23669 = state_23444__$1;
(statearr_23531_23669[(2)] = inst_23404);

(statearr_23531_23669[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (47))){
var inst_23270 = (state_23444[(11)]);
var inst_23378 = (inst_23270 == null);
var state_23444__$1 = state_23444;
if(cljs.core.truth_(inst_23378)){
var statearr_23532_23670 = state_23444__$1;
(statearr_23532_23670[(1)] = (76));

} else {
var statearr_23533_23671 = state_23444__$1;
(statearr_23533_23671[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (35))){
var inst_23398 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
var statearr_23534_23672 = state_23444__$1;
(statearr_23534_23672[(2)] = inst_23398);

(statearr_23534_23672[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (82))){
var state_23444__$1 = state_23444;
var statearr_23535_23673 = state_23444__$1;
(statearr_23535_23673[(2)] = (1));

(statearr_23535_23673[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (76))){
var state_23444__$1 = state_23444;
var statearr_23536_23674 = state_23444__$1;
(statearr_23536_23674[(2)] = null);

(statearr_23536_23674[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (97))){
var inst_23433 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
var statearr_23537_23675 = state_23444__$1;
(statearr_23537_23675[(2)] = inst_23433);

(statearr_23537_23675[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (19))){
var inst_23262 = (state_23444[(36)]);
var state_23444__$1 = state_23444;
var statearr_23538_23676 = state_23444__$1;
(statearr_23538_23676[(2)] = inst_23262);

(statearr_23538_23676[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (57))){
var inst_23270 = (state_23444[(11)]);
var inst_23340 = (state_23444[(2)]);
var inst_23341 = (inst_23270 == null);
var state_23444__$1 = (function (){var statearr_23539 = state_23444;
(statearr_23539[(9)] = inst_23340);

return statearr_23539;
})();
if(cljs.core.truth_(inst_23341)){
var statearr_23540_23677 = state_23444__$1;
(statearr_23540_23677[(1)] = (58));

} else {
var statearr_23541_23678 = state_23444__$1;
(statearr_23541_23678[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (68))){
var state_23444__$1 = state_23444;
var statearr_23542_23679 = state_23444__$1;
(statearr_23542_23679[(2)] = null);

(statearr_23542_23679[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (11))){
var inst_23218 = (state_23444[(2)]);
var state_23444__$1 = (function (){var statearr_23544 = state_23444;
(statearr_23544[(28)] = inst_23218);

return statearr_23544;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_23545_23680 = state_23444__$1;
(statearr_23545_23680[(1)] = (12));

} else {
var statearr_23546_23681 = state_23444__$1;
(statearr_23546_23681[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (9))){
var inst_23210 = (state_23444[(34)]);
var inst_23212 = (state_23444[(35)]);
var inst_23214 = cljs.core.sorted_map_by(inst_23210);
var inst_23215 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23214,inst_23212);
var state_23444__$1 = state_23444;
var statearr_23547_23682 = state_23444__$1;
(statearr_23547_23682[(2)] = inst_23215);

(statearr_23547_23682[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (5))){
var _ = (function (){var statearr_23548 = state_23444;
(statearr_23548[(4)] = cljs.core.rest((state_23444[(4)])));

return statearr_23548;
})();
var state_23444__$1 = state_23444;
var ex23543 = (state_23444__$1[(2)]);
var statearr_23549_23683 = state_23444__$1;
(statearr_23549_23683[(5)] = ex23543);


if((ex23543 instanceof Error)){
var statearr_23550_23684 = state_23444__$1;
(statearr_23550_23684[(1)] = (4));

(statearr_23550_23684[(5)] = null);

} else {
throw ex23543;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (83))){
var state_23444__$1 = state_23444;
var statearr_23551_23685 = state_23444__$1;
(statearr_23551_23685[(2)] = limit);

(statearr_23551_23685[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (14))){
var inst_23406 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
var statearr_23552_23686 = state_23444__$1;
(statearr_23552_23686[(2)] = inst_23406);

(statearr_23552_23686[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (45))){
var inst_23322 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
if(cljs.core.truth_(inst_23322)){
var statearr_23553_23687 = state_23444__$1;
(statearr_23553_23687[(1)] = (46));

} else {
var statearr_23554_23688 = state_23444__$1;
(statearr_23554_23688[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (53))){
var inst_23270 = (state_23444[(11)]);
var state_23444__$1 = state_23444;
var statearr_23555_23689 = state_23444__$1;
(statearr_23555_23689[(2)] = inst_23270);

(statearr_23555_23689[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (78))){
var inst_23271 = (state_23444[(12)]);
var inst_23383 = (state_23444[(2)]);
var inst_23384 = (inst_23271 <= (0));
var state_23444__$1 = (function (){var statearr_23556 = state_23444;
(statearr_23556[(37)] = inst_23383);

return statearr_23556;
})();
if(cljs.core.truth_(inst_23384)){
var statearr_23557_23690 = state_23444__$1;
(statearr_23557_23690[(1)] = (79));

} else {
var statearr_23558_23691 = state_23444__$1;
(statearr_23558_23691[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (26))){
var inst_23402 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
var statearr_23559_23692 = state_23444__$1;
(statearr_23559_23692[(2)] = inst_23402);

(statearr_23559_23692[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (16))){
var state_23444__$1 = state_23444;
var statearr_23560_23693 = state_23444__$1;
(statearr_23560_23693[(2)] = null);

(statearr_23560_23693[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (81))){
var inst_23316 = (state_23444[(18)]);
var inst_23285 = (state_23444[(20)]);
var inst_23282 = (state_23444[(21)]);
var inst_23281 = (state_23444[(8)]);
var inst_23383 = (state_23444[(37)]);
var inst_23272 = (state_23444[(10)]);
var inst_23389 = (state_23444[(2)]);
var inst_23390 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23272,inst_23281,inst_23316);
var inst_23268 = inst_23282;
var inst_23269 = inst_23285;
var inst_23270 = inst_23383;
var inst_23271 = inst_23389;
var inst_23272__$1 = inst_23390;
var state_23444__$1 = (function (){var statearr_23563 = state_23444;
(statearr_23563[(22)] = inst_23268);

(statearr_23563[(11)] = inst_23270);

(statearr_23563[(23)] = inst_23269);

(statearr_23563[(10)] = inst_23272__$1);

(statearr_23563[(12)] = inst_23271);

return statearr_23563;
})();
var statearr_23564_23694 = state_23444__$1;
(statearr_23564_23694[(2)] = null);

(statearr_23564_23694[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (79))){
var state_23444__$1 = state_23444;
var statearr_23565_23695 = state_23444__$1;
(statearr_23565_23695[(2)] = (0));

(statearr_23565_23695[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (38))){
var inst_23285 = (state_23444[(20)]);
var inst_23270 = (state_23444[(11)]);
var inst_23282 = (state_23444[(21)]);
var inst_23272 = (state_23444[(10)]);
var inst_23307 = (state_23444[(2)]);
var tmp23561 = inst_23270;
var tmp23562 = inst_23272;
var inst_23268 = inst_23282;
var inst_23269 = inst_23285;
var inst_23270__$1 = tmp23561;
var inst_23271 = inst_23307;
var inst_23272__$1 = tmp23562;
var state_23444__$1 = (function (){var statearr_23566 = state_23444;
(statearr_23566[(22)] = inst_23268);

(statearr_23566[(11)] = inst_23270__$1);

(statearr_23566[(23)] = inst_23269);

(statearr_23566[(10)] = inst_23272__$1);

(statearr_23566[(12)] = inst_23271);

return statearr_23566;
})();
var statearr_23567_23696 = state_23444__$1;
(statearr_23567_23696[(2)] = null);

(statearr_23567_23696[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (87))){
var state_23444__$1 = state_23444;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_23568_23697 = state_23444__$1;
(statearr_23568_23697[(1)] = (92));

} else {
var statearr_23569_23698 = state_23444__$1;
(statearr_23569_23698[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (30))){
var inst_23272 = (state_23444[(10)]);
var state_23444__$1 = state_23444;
var statearr_23570_23699 = state_23444__$1;
(statearr_23570_23699[(2)] = inst_23272);

(statearr_23570_23699[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (73))){
var inst_23272 = (state_23444[(10)]);
var state_23444__$1 = state_23444;
var statearr_23571_23700 = state_23444__$1;
(statearr_23571_23700[(2)] = inst_23272);

(statearr_23571_23700[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (96))){
var state_23444__$1 = state_23444;
var statearr_23572_23701 = state_23444__$1;
(statearr_23572_23701[(2)] = null);

(statearr_23572_23701[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (10))){
var inst_23212 = (state_23444[(35)]);
var state_23444__$1 = state_23444;
var statearr_23573_23702 = state_23444__$1;
(statearr_23573_23702[(2)] = inst_23212);

(statearr_23573_23702[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (18))){
var inst_23262 = (state_23444[(36)]);
var inst_23261 = (state_23444[(2)]);
var inst_23262__$1 = offset;
var state_23444__$1 = (function (){var statearr_23574 = state_23444;
(statearr_23574[(25)] = inst_23261);

(statearr_23574[(36)] = inst_23262__$1);

return statearr_23574;
})();
if(cljs.core.truth_(inst_23262__$1)){
var statearr_23575_23703 = state_23444__$1;
(statearr_23575_23703[(1)] = (19));

} else {
var statearr_23576_23704 = state_23444__$1;
(statearr_23576_23704[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (52))){
var inst_23270 = (state_23444[(11)]);
var inst_23332 = ((0) < inst_23270);
var state_23444__$1 = state_23444;
var statearr_23577_23705 = state_23444__$1;
(statearr_23577_23705[(2)] = inst_23332);

(statearr_23577_23705[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (67))){
var inst_23340 = (state_23444[(9)]);
var inst_23286 = (state_23444[(27)]);
var inst_23271 = (state_23444[(12)]);
var inst_23355 = cljs.core.count(inst_23340);
var inst_23356 = (inst_23286 - inst_23355);
var inst_23357 = (inst_23271 - inst_23356);
var state_23444__$1 = state_23444;
var statearr_23578_23706 = state_23444__$1;
(statearr_23578_23706[(2)] = inst_23357);

(statearr_23578_23706[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (71))){
var inst_23340 = (state_23444[(9)]);
var inst_23368 = cljs.core.empty_QMARK_(inst_23340);
var state_23444__$1 = state_23444;
var statearr_23579_23707 = state_23444__$1;
(statearr_23579_23707[(2)] = inst_23368);

(statearr_23579_23707[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (42))){
var inst_23316 = (state_23444[(18)]);
var inst_23317 = (state_23444[(33)]);
var inst_23315 = (state_23444[(2)]);
var inst_23316__$1 = fluree.db.util.async.throw_err(inst_23315);
var inst_23317__$1 = cljs.core.coll_QMARK_(inst_23316__$1);
var state_23444__$1 = (function (){var statearr_23580 = state_23444;
(statearr_23580[(18)] = inst_23316__$1);

(statearr_23580[(33)] = inst_23317__$1);

return statearr_23580;
})();
if(inst_23317__$1){
var statearr_23581_23708 = state_23444__$1;
(statearr_23581_23708[(1)] = (43));

} else {
var statearr_23582_23709 = state_23444__$1;
(statearr_23582_23709[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (80))){
var inst_23271 = (state_23444[(12)]);
var inst_23387 = (inst_23271 - (1));
var state_23444__$1 = state_23444;
var statearr_23583_23710 = state_23444__$1;
(statearr_23583_23710[(2)] = inst_23387);

(statearr_23583_23710[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (37))){
var inst_23286 = (state_23444[(27)]);
var inst_23271 = (state_23444[(12)]);
var inst_23305 = (inst_23271 - inst_23286);
var state_23444__$1 = state_23444;
var statearr_23584_23711 = state_23444__$1;
(statearr_23584_23711[(2)] = inst_23305);

(statearr_23584_23711[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (63))){
var inst_23365 = (state_23444[(7)]);
var inst_23340 = (state_23444[(9)]);
var inst_23364 = (state_23444[(2)]);
var inst_23365__$1 = (inst_23340 == null);
var state_23444__$1 = (function (){var statearr_23585 = state_23444;
(statearr_23585[(19)] = inst_23364);

(statearr_23585[(7)] = inst_23365__$1);

return statearr_23585;
})();
if(cljs.core.truth_(inst_23365__$1)){
var statearr_23586_23712 = state_23444__$1;
(statearr_23586_23712[(1)] = (70));

} else {
var statearr_23587_23713 = state_23444__$1;
(statearr_23587_23713[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (94))){
var inst_23435 = (state_23444[(2)]);
var state_23444__$1 = state_23444;
var statearr_23588_23714 = state_23444__$1;
(statearr_23588_23714[(2)] = inst_23435);

(statearr_23588_23714[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (8))){
var inst_23439 = (state_23444[(2)]);
var _ = (function (){var statearr_23589 = state_23444;
(statearr_23589[(4)] = cljs.core.rest((state_23444[(4)])));

return statearr_23589;
})();
var state_23444__$1 = state_23444;
var statearr_23590_23715 = state_23444__$1;
(statearr_23590_23715[(2)] = inst_23439);

(statearr_23590_23715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (49))){
var inst_23316 = (state_23444[(18)]);
var inst_23271 = (state_23444[(12)]);
var inst_23327 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_23271,inst_23316);
var state_23444__$1 = state_23444;
var statearr_23591_23716 = state_23444__$1;
(statearr_23591_23716[(2)] = inst_23327);

(statearr_23591_23716[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23445 === (84))){
var inst_23411 = (state_23444[(2)]);
var inst_23412 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_23411,opts);
var state_23444__$1 = state_23444;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23444__$1,(85),inst_23412);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0 = (function (){
var statearr_23592 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23592[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__);

(statearr_23592[(1)] = (1));

return statearr_23592;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1 = (function (state_23444){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23444);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23593){var ex__2730__auto__ = e23593;
var statearr_23594_23717 = state_23444;
(statearr_23594_23717[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23444[(4)]))){
var statearr_23595_23718 = state_23444;
(statearr_23595_23718[(1)] = cljs.core.first((state_23444[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23719 = state_23444;
state_23444 = G__23719;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__ = function(state_23444){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1.call(this,state_23444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23596 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23596[(6)] = c__2749__auto__);

return statearr_23596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Legacy ad-hoc query processor
 */
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,parsed_query,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23780){
var state_val_23781 = (state_23780[(1)]);
if((state_val_23781 === (7))){
var state_23780__$1 = state_23780;
var statearr_23782_23820 = state_23780__$1;
(statearr_23782_23820[(2)] = (0));

(statearr_23782_23820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (20))){
var inst_23764 = (state_23780[(2)]);
var state_23780__$1 = state_23780;
var statearr_23783_23821 = state_23780__$1;
(statearr_23783_23821[(2)] = inst_23764);

(statearr_23783_23821[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (1))){
var state_23780__$1 = state_23780;
var statearr_23784_23822 = state_23780__$1;
(statearr_23784_23822[(2)] = null);

(statearr_23784_23822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (4))){
var inst_23720 = (state_23780[(2)]);
var state_23780__$1 = state_23780;
var statearr_23785_23823 = state_23780__$1;
(statearr_23785_23823[(2)] = inst_23720);

(statearr_23785_23823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (15))){
var inst_23751 = (state_23780[(7)]);
var state_23780__$1 = state_23780;
var statearr_23786_23824 = state_23780__$1;
(statearr_23786_23824[(2)] = inst_23751);

(statearr_23786_23824[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (21))){
var inst_23766 = (state_23780[(8)]);
var inst_23736 = (state_23780[(9)]);
var inst_23751 = (state_23780[(7)]);
var inst_23769 = (state_23780[(2)]);
var inst_23770 = fluree.db.util.async.throw_err(inst_23769);
var inst_23771 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query);
var inst_23772 = fluree.db.query.fql.process_ad_hoc_res(db,inst_23766,inst_23751,inst_23770,inst_23771,inst_23736);
var state_23780__$1 = state_23780;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23780__$1,(22),inst_23772);
} else {
if((state_val_23781 === (13))){
var inst_23751 = (state_23780[(7)]);
var state_23780__$1 = state_23780;
if(cljs.core.truth_(inst_23751)){
var statearr_23787_23825 = state_23780__$1;
(statearr_23787_23825[(1)] = (15));

} else {
var statearr_23788_23826 = state_23780__$1;
(statearr_23788_23826[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (22))){
var inst_23774 = (state_23780[(2)]);
var inst_23775 = fluree.db.util.async.throw_err(inst_23774);
var _ = (function (){var statearr_23789 = state_23780;
(statearr_23789[(4)] = cljs.core.rest((state_23780[(4)])));

return statearr_23789;
})();
var state_23780__$1 = state_23780;
var statearr_23790_23827 = state_23780__$1;
(statearr_23790_23827[(2)] = inst_23775);

(statearr_23790_23827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (6))){
var inst_23731 = (state_23780[(10)]);
var state_23780__$1 = state_23780;
var statearr_23791_23828 = state_23780__$1;
(statearr_23791_23828[(2)] = inst_23731);

(statearr_23791_23828[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (17))){
var inst_23759 = (state_23780[(2)]);
var state_23780__$1 = state_23780;
if(cljs.core.truth_(inst_23759)){
var statearr_23792_23829 = state_23780__$1;
(statearr_23792_23829[(1)] = (18));

} else {
var statearr_23793_23830 = state_23780__$1;
(statearr_23793_23830[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (3))){
var inst_23778 = (state_23780[(2)]);
var state_23780__$1 = state_23780;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23780__$1,inst_23778);
} else {
if((state_val_23781 === (12))){
var inst_23752 = (state_23780[(11)]);
var state_23780__$1 = state_23780;
var statearr_23794_23831 = state_23780__$1;
(statearr_23794_23831[(2)] = inst_23752);

(statearr_23794_23831[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (2))){
var inst_23731 = (state_23780[(10)]);
var _ = (function (){var statearr_23795 = state_23780;
(statearr_23795[(4)] = cljs.core.cons((5),(state_23780[(4)])));

return statearr_23795;
})();
var inst_23727 = query_map;
var inst_23728 = cljs.core.__destructure_map(inst_23727);
var inst_23729 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23728,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_23730 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23728,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23731__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23728,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_23732 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23728,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_23733 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23728,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_23734 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23728,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_23735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23728,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_23736 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23728,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_23738 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)];
var state_23780__$1 = (function (){var statearr_23796 = state_23780;
(statearr_23796[(12)] = inst_23734);

(statearr_23796[(13)] = inst_23729);

(statearr_23796[(14)] = inst_23733);

(statearr_23796[(9)] = inst_23736);

(statearr_23796[(15)] = inst_23735);

(statearr_23796[(16)] = inst_23732);

(statearr_23796[(17)] = inst_23738);

(statearr_23796[(10)] = inst_23731__$1);

(statearr_23796[(18)] = inst_23730);

return statearr_23796;
})();
if(cljs.core.truth_(inst_23731__$1)){
var statearr_23797_23832 = state_23780__$1;
(statearr_23797_23832[(1)] = (6));

} else {
var statearr_23798_23833 = state_23780__$1;
(statearr_23798_23833[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (19))){
var state_23780__$1 = state_23780;
var statearr_23799_23834 = state_23780__$1;
(statearr_23799_23834[(2)] = null);

(statearr_23799_23834[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (11))){
var inst_23750 = (state_23780[(19)]);
var inst_23736 = (state_23780[(9)]);
var inst_23752 = (state_23780[(11)]);
var inst_23750__$1 = (state_23780[(2)]);
var inst_23751 = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(inst_23750__$1);
var inst_23752__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_23736);
var state_23780__$1 = (function (){var statearr_23801 = state_23780;
(statearr_23801[(19)] = inst_23750__$1);

(statearr_23801[(7)] = inst_23751);

(statearr_23801[(11)] = inst_23752__$1);

return statearr_23801;
})();
if(cljs.core.truth_(inst_23752__$1)){
var statearr_23802_23835 = state_23780__$1;
(statearr_23802_23835[(1)] = (12));

} else {
var statearr_23803_23836 = state_23780__$1;
(statearr_23803_23836[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (9))){
var inst_23745 = (state_23780[(20)]);
var inst_23747 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23745,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var state_23780__$1 = state_23780;
var statearr_23804_23837 = state_23780__$1;
(statearr_23804_23837[(2)] = inst_23747);

(statearr_23804_23837[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (5))){
var _ = (function (){var statearr_23805 = state_23780;
(statearr_23805[(4)] = cljs.core.rest((state_23780[(4)])));

return statearr_23805;
})();
var state_23780__$1 = state_23780;
var ex23800 = (state_23780__$1[(2)]);
var statearr_23806_23838 = state_23780__$1;
(statearr_23806_23838[(5)] = ex23800);


if((ex23800 instanceof Error)){
var statearr_23807_23839 = state_23780__$1;
(statearr_23807_23839[(1)] = (4));

(statearr_23807_23839[(5)] = null);

} else {
throw ex23800;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (14))){
var inst_23766 = (state_23780[(8)]);
var inst_23750 = (state_23780[(19)]);
var inst_23751 = (state_23780[(7)]);
var inst_23766__$1 = (state_23780[(2)]);
var inst_23767 = fluree.db.query.analytical.q(query_map,inst_23766__$1,inst_23751,db,inst_23750);
var state_23780__$1 = (function (){var statearr_23808 = state_23780;
(statearr_23808[(8)] = inst_23766__$1);

return statearr_23808;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23780__$1,(21),inst_23767);
} else {
if((state_val_23781 === (16))){
var inst_23736 = (state_23780[(9)]);
var inst_23757 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_23736);
var state_23780__$1 = state_23780;
var statearr_23809_23840 = state_23780__$1;
(statearr_23809_23840[(2)] = inst_23757);

(statearr_23809_23840[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (10))){
var inst_23745 = (state_23780[(20)]);
var state_23780__$1 = state_23780;
var statearr_23810_23841 = state_23780__$1;
(statearr_23810_23841[(2)] = inst_23745);

(statearr_23810_23841[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (18))){
var inst_23761 = cljs.core.volatile_BANG_((0));
var state_23780__$1 = state_23780;
var statearr_23811_23842 = state_23780__$1;
(statearr_23811_23842[(2)] = inst_23761);

(statearr_23811_23842[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23781 === (8))){
var inst_23734 = (state_23780[(12)]);
var inst_23729 = (state_23780[(13)]);
var inst_23733 = (state_23780[(14)]);
var inst_23736 = (state_23780[(9)]);
var inst_23735 = (state_23780[(15)]);
var inst_23732 = (state_23780[(16)]);
var inst_23738 = (state_23780[(17)]);
var inst_23730 = (state_23780[(18)]);
var inst_23742 = (state_23780[(2)]);
var inst_23743 = [inst_23730,inst_23742,inst_23732,inst_23733,inst_23734,inst_23735];
var inst_23744 = cljs.core.PersistentHashMap.fromArrays(inst_23738,inst_23743);
var inst_23745 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23744,inst_23736], 0));
var state_23780__$1 = (function (){var statearr_23812 = state_23780;
(statearr_23812[(20)] = inst_23745);

return statearr_23812;
})();
if(cljs.core.truth_(inst_23729)){
var statearr_23813_23843 = state_23780__$1;
(statearr_23813_23843[(1)] = (9));

} else {
var statearr_23814_23844 = state_23780__$1;
(statearr_23814_23844[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0 = (function (){
var statearr_23815 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23815[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__);

(statearr_23815[(1)] = (1));

return statearr_23815;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1 = (function (state_23780){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23780);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23816){var ex__2730__auto__ = e23816;
var statearr_23817_23845 = state_23780;
(statearr_23817_23845[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23780[(4)]))){
var statearr_23818_23846 = state_23780;
(statearr_23818_23846[(1)] = cljs.core.first((state_23780[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23847 = state_23780;
state_23780 = G__23847;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__ = function(state_23780){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1.call(this,state_23780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23819 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23819[(6)] = c__2749__auto__);

return statearr_23819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns already cached query from cache if available, else
 *   executes and stores query into cache.
 */
fluree.db.query.fql.cache_query = (function fluree$db$query$fql$cache_query(p__23848,p__23849){
var map__23850 = p__23848;
var map__23850__$1 = cljs.core.__destructure_map(map__23850);
var db = map__23850__$1;
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23850__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23850__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23850__$1,new cljs.core.Keyword(null,"block","block",664686210));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23850__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23850__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__23851 = p__23849;
var map__23851__$1 = cljs.core.__destructure_map(map__23851);
var query_map = map__23851__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23851__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var oc = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
var query_STAR_ = cljs.core.update.cljs$core$IFn$_invoke$arity$5(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.dissoc,new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var cache_key = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510),network,ledger_id,block,auth,query_STAR_], null);
var G__23852 = cache_key;
var G__23853 = (function (_){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___23870 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23863){
var state_val_23864 = (state_23863[(1)]);
if((state_val_23864 === (1))){
var inst_23854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23855 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"cache","cache",-1237023054)];
var inst_23856 = (new cljs.core.PersistentVector(null,2,(5),inst_23854,inst_23855,null));
var inst_23857 = cljs.core.assoc_in(query_map,inst_23856,false);
var inst_23858 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_23857) : fluree.db.query.fql.query.call(null,db,inst_23857));
var state_23863__$1 = state_23863;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23863__$1,(2),inst_23858);
} else {
if((state_val_23864 === (2))){
var inst_23860 = (state_23863[(2)]);
var inst_23861 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_23860);
var state_23863__$1 = state_23863;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23863__$1,inst_23861);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0 = (function (){
var statearr_23865 = [null,null,null,null,null,null,null];
(statearr_23865[(0)] = fluree$db$query$fql$cache_query_$_state_machine__2727__auto__);

(statearr_23865[(1)] = (1));

return statearr_23865;
});
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1 = (function (state_23863){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23863);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23866){var ex__2730__auto__ = e23866;
var statearr_23867_23871 = state_23863;
(statearr_23867_23871[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23863[(4)]))){
var statearr_23868_23872 = state_23863;
(statearr_23868_23872[(1)] = cljs.core.first((state_23863[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23873 = state_23863;
state_23863 = G__23873;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__ = function(state_23863){
switch(arguments.length){
case 0:
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1.call(this,state_23863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0;
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1;
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23869 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23869[(6)] = c__2749__auto___23870);

return statearr_23869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
});
return (oc.cljs$core$IFn$_invoke$arity$2 ? oc.cljs$core$IFn$_invoke$arity$2(G__23852,G__23853) : oc.call(null,G__23852,G__23853));
});
/**
 * Returns true if query was requested to run from the cache.
 */
fluree.db.query.fql.cache_QMARK_ = (function fluree$db$query$fql$cache_QMARK_(p__23874){
var map__23875 = p__23874;
var map__23875__$1 = cljs.core.__destructure_map(map__23875);
var _query_map = map__23875__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23875__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return false;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var G__23876_23878 = "Running query:";
var G__23877_23879 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2(G__23876_23878,G__23877_23879) : fluree.db.util.log.debug.call(null,G__23876_23878,G__23877_23879));

if(fluree.db.query.fql.cache_QMARK_(query_map)){
return fluree.db.query.fql.cache_query(db,query_map);
} else {
var parsed_query = fluree.db.query.analytical_parse.parse(db,query_map);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"ctx-cache","ctx-cache",-391738418),cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044),new cljs.core.Keyword(null,"strategy","strategy",-1471631918).cljs$core$IFn$_invoke$arity$1(parsed_query))){
return fluree.db.query.subject_crawl.core.simple_subject_crawl(db_STAR_,parsed_query);
} else {
return fluree.db.query.fql.ad_hoc_query(db_STAR_,parsed_query,query_map);
}
}
});
