// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql_resp');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql_resp.vswap_BANG_ = (function fluree$db$query$fql_resp$vswap_BANG_(var_args){
var G__19895 = arguments.length;
switch (G__19895) {
case 2:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__19896 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__19896) : f.call(null,G__19896));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__19897 = cljs.core._deref(vol);
var G__19898 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__19897,G__19898) : f.call(null,G__19897,G__19898));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__19899 = cljs.core._deref(vol);
var G__19900 = arg1;
var G__19901 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__19899,G__19900,G__19901) : f.call(null,G__19899,G__19900,G__19901));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__19902 = cljs.core._deref(vol);
var G__19903 = arg1;
var G__19904 = arg2;
var G__19905 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__19902,G__19903,G__19904,G__19905) : f.call(null,G__19902,G__19903,G__19904,G__19905));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql_resp.has_ns_lookups_QMARK_ = (function fluree$db$query$fql_resp$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql_resp.full_select_spec = (function fluree$db$query$fql_resp$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql_resp$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql_resp.add_fuel = (function fluree$db$query$fql_resp$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql_resp.resolve_reverse_refs = (function fluree$db$query$fql_resp$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20066){
var state_val_20067 = (state_20066[(1)]);
if((state_val_20067 === (7))){
var inst_20061 = (state_20066[(2)]);
var _ = (function (){var statearr_20068 = state_20066;
(statearr_20068[(4)] = cljs.core.rest((state_20066[(4)])));

return statearr_20068;
})();
var state_20066__$1 = state_20066;
var statearr_20069_20151 = state_20066__$1;
(statearr_20069_20151[(2)] = inst_20061);

(statearr_20069_20151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (20))){
var inst_19988 = (state_20066[(7)]);
var state_20066__$1 = state_20066;
var statearr_20070_20152 = state_20066__$1;
(statearr_20070_20152[(2)] = inst_19988);

(statearr_20070_20152[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (27))){
var inst_19943 = (state_20066[(8)]);
var state_20066__$1 = state_20066;
if(cljs.core.truth_(inst_19943)){
var statearr_20071_20153 = state_20066__$1;
(statearr_20071_20153[(1)] = (29));

} else {
var statearr_20072_20154 = state_20066__$1;
(statearr_20072_20154[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (1))){
var state_20066__$1 = state_20066;
var statearr_20073_20155 = state_20066__$1;
(statearr_20073_20155[(2)] = null);

(statearr_20073_20155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (24))){
var inst_19944 = (state_20066[(9)]);
var state_20066__$1 = state_20066;
var statearr_20074_20156 = state_20066__$1;
(statearr_20074_20156[(2)] = inst_19944);

(statearr_20074_20156[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (39))){
var inst_19980 = (state_20066[(10)]);
var state_20066__$1 = state_20066;
var statearr_20075_20157 = state_20066__$1;
(statearr_20075_20157[(2)] = inst_19980);

(statearr_20075_20157[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (46))){
var inst_19945 = (state_20066[(11)]);
var state_20066__$1 = state_20066;
var statearr_20076_20158 = state_20066__$1;
(statearr_20076_20158[(2)] = inst_19945);

(statearr_20076_20158[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (4))){
var inst_19907 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
var statearr_20077_20159 = state_20066__$1;
(statearr_20077_20159[(2)] = inst_19907);

(statearr_20077_20159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (15))){
var inst_19956 = (state_20066[(12)]);
var inst_19962 = cljs.core.count(inst_19956);
var inst_19963 = fluree.db.query.fql_resp.add_fuel(fuel,inst_19962,max_fuel);
var state_20066__$1 = state_20066;
var statearr_20078_20160 = state_20066__$1;
(statearr_20078_20160[(2)] = inst_19963);

(statearr_20078_20160[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (48))){
var inst_19925 = (state_20066[(13)]);
var inst_20047 = (state_20066[(14)]);
var inst_19932 = (state_20066[(15)]);
var inst_20055 = (state_20066[(2)]);
var inst_20056 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_19925,inst_20055,inst_20047);
var inst_19924 = inst_19932;
var inst_19925__$1 = inst_20056;
var state_20066__$1 = (function (){var statearr_20079 = state_20066;
(statearr_20079[(16)] = inst_19924);

(statearr_20079[(13)] = inst_19925__$1);

return statearr_20079;
})();
var statearr_20080_20161 = state_20066__$1;
(statearr_20080_20161[(2)] = null);

(statearr_20080_20161[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (50))){
var inst_19947 = (state_20066[(17)]);
var state_20066__$1 = state_20066;
var statearr_20081_20162 = state_20066__$1;
(statearr_20081_20162[(2)] = inst_19947);

(statearr_20081_20162[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (21))){
var inst_19944 = (state_20066[(9)]);
var state_20066__$1 = state_20066;
if(cljs.core.truth_(inst_19944)){
var statearr_20083_20163 = state_20066__$1;
(statearr_20083_20163[(1)] = (23));

} else {
var statearr_20084_20164 = state_20066__$1;
(statearr_20084_20164[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (31))){
var inst_20004 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
if(cljs.core.truth_(inst_20004)){
var statearr_20085_20165 = state_20066__$1;
(statearr_20085_20165[(1)] = (32));

} else {
var statearr_20086_20166 = state_20066__$1;
(statearr_20086_20166[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (32))){
var inst_19979 = (state_20066[(18)]);
var inst_19987 = (state_20066[(19)]);
var inst_19980 = (state_20066[(10)]);
var inst_20006 = (inst_19979 + (1));
var tmp20082 = inst_19980;
var inst_19978 = inst_19987;
var inst_19979__$1 = inst_20006;
var inst_19980__$1 = tmp20082;
var state_20066__$1 = (function (){var statearr_20087 = state_20066;
(statearr_20087[(18)] = inst_19979__$1);

(statearr_20087[(20)] = inst_19978);

(statearr_20087[(10)] = inst_19980__$1);

return statearr_20087;
})();
var statearr_20088_20167 = state_20066__$1;
(statearr_20088_20167[(2)] = null);

(statearr_20088_20167[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (40))){
var state_20066__$1 = state_20066;
if(cljs.core.truth_(fuel)){
var statearr_20089_20168 = state_20066__$1;
(statearr_20089_20168[(1)] = (42));

} else {
var statearr_20090_20169 = state_20066__$1;
(statearr_20090_20169[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (33))){
var state_20066__$1 = state_20066;
var statearr_20091_20170 = state_20066__$1;
(statearr_20091_20170[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (13))){
var inst_19956 = (state_20066[(12)]);
var state_20066__$1 = state_20066;
var statearr_20093_20171 = state_20066__$1;
(statearr_20093_20171[(2)] = inst_19956);

(statearr_20093_20171[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (22))){
var inst_19997 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
if(cljs.core.truth_(inst_19997)){
var statearr_20094_20172 = state_20066__$1;
(statearr_20094_20172[(1)] = (26));

} else {
var statearr_20095_20173 = state_20066__$1;
(statearr_20095_20173[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (36))){
var state_20066__$1 = state_20066;
var statearr_20096_20174 = state_20066__$1;
(statearr_20096_20174[(2)] = null);

(statearr_20096_20174[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (41))){
var inst_19979 = (state_20066[(18)]);
var inst_19987 = (state_20066[(19)]);
var inst_20036 = (state_20066[(2)]);
var inst_20037 = (inst_19979 + (1));
var inst_19978 = inst_19987;
var inst_19979__$1 = inst_20037;
var inst_19980 = inst_20036;
var state_20066__$1 = (function (){var statearr_20097 = state_20066;
(statearr_20097[(18)] = inst_19979__$1);

(statearr_20097[(20)] = inst_19978);

(statearr_20097[(10)] = inst_19980);

return statearr_20097;
})();
var statearr_20098_20175 = state_20066__$1;
(statearr_20098_20175[(2)] = null);

(statearr_20098_20175[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (43))){
var state_20066__$1 = state_20066;
var statearr_20099_20176 = state_20066__$1;
(statearr_20099_20176[(2)] = null);

(statearr_20099_20176[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (29))){
var inst_19979 = (state_20066[(18)]);
var inst_19943 = (state_20066[(8)]);
var inst_20001 = (inst_19979 < inst_19943);
var state_20066__$1 = state_20066;
var statearr_20100_20177 = state_20066__$1;
(statearr_20100_20177[(2)] = inst_20001);

(statearr_20100_20177[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (44))){
var inst_20016 = (state_20066[(21)]);
var inst_20020 = (state_20066[(22)]);
var inst_20029 = (state_20066[(2)]);
var inst_20030 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_20020,inst_20016) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_20020,inst_20016));
var state_20066__$1 = (function (){var statearr_20101 = state_20066;
(statearr_20101[(23)] = inst_20029);

return statearr_20101;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20066__$1,(45),inst_20030);
} else {
if((state_val_20067 === (6))){
var inst_19924 = (state_20066[(16)]);
var inst_19931 = (state_20066[(24)]);
var inst_19930 = cljs.core.seq(inst_19924);
var inst_19931__$1 = cljs.core.first(inst_19930);
var inst_19932 = cljs.core.next(inst_19930);
var inst_19933 = cljs.core.not(inst_19931__$1);
var state_20066__$1 = (function (){var statearr_20102 = state_20066;
(statearr_20102[(24)] = inst_19931__$1);

(statearr_20102[(15)] = inst_19932);

return statearr_20102;
})();
if(inst_19933){
var statearr_20103_20178 = state_20066__$1;
(statearr_20103_20178[(1)] = (8));

} else {
var statearr_20104_20179 = state_20066__$1;
(statearr_20104_20179[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (28))){
var inst_20045 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
var statearr_20105_20180 = state_20066__$1;
(statearr_20105_20180[(2)] = inst_20045);

(statearr_20105_20180[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (51))){
var inst_20053 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
var statearr_20106_20181 = state_20066__$1;
(statearr_20106_20181[(2)] = inst_20053);

(statearr_20106_20181[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (25))){
var inst_19995 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
var statearr_20107_20182 = state_20066__$1;
(statearr_20107_20182[(2)] = inst_19995);

(statearr_20107_20182[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (34))){
var inst_20043 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
var statearr_20108_20183 = state_20066__$1;
(statearr_20108_20183[(2)] = inst_20043);

(statearr_20108_20183[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (17))){
var inst_19956 = (state_20066[(12)]);
var inst_19966 = (state_20066[(2)]);
var inst_19974 = cljs.core.seq(inst_19956);
var inst_19975 = cljs.core.first(inst_19974);
var inst_19976 = cljs.core.next(inst_19974);
var inst_19977 = cljs.core.PersistentVector.EMPTY;
var inst_19978 = inst_19956;
var inst_19979 = (0);
var inst_19980 = inst_19977;
var state_20066__$1 = (function (){var statearr_20109 = state_20066;
(statearr_20109[(18)] = inst_19979);

(statearr_20109[(25)] = inst_19966);

(statearr_20109[(20)] = inst_19978);

(statearr_20109[(26)] = inst_19975);

(statearr_20109[(10)] = inst_19980);

(statearr_20109[(27)] = inst_19976);

return statearr_20109;
})();
var statearr_20110_20184 = state_20066__$1;
(statearr_20110_20184[(2)] = null);

(statearr_20110_20184[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (3))){
var inst_20064 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20066__$1,inst_20064);
} else {
if((state_val_20067 === (12))){
var state_20066__$1 = state_20066;
var statearr_20111_20185 = state_20066__$1;
(statearr_20111_20185[(2)] = fuel);

(statearr_20111_20185[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (2))){
var _ = (function (){var statearr_20112 = state_20066;
(statearr_20112[(4)] = cljs.core.cons((5),(state_20066[(4)])));

return statearr_20112;
})();
var inst_19920 = reverse_refs_specs;
var inst_19921 = cljs.core.seq(inst_19920);
var inst_19922 = cljs.core.first(inst_19921);
var inst_19923 = cljs.core.next(inst_19921);
var inst_19924 = inst_19920;
var inst_19925 = null;
var state_20066__$1 = (function (){var statearr_20113 = state_20066;
(statearr_20113[(28)] = inst_19923);

(statearr_20113[(16)] = inst_19924);

(statearr_20113[(13)] = inst_19925);

(statearr_20113[(29)] = inst_19922);

return statearr_20113;
})();
var statearr_20114_20186 = state_20066__$1;
(statearr_20114_20186[(2)] = null);

(statearr_20114_20186[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (23))){
var inst_19979 = (state_20066[(18)]);
var inst_19944 = (state_20066[(9)]);
var inst_19992 = (inst_19979 >= inst_19944);
var state_20066__$1 = state_20066;
var statearr_20115_20187 = state_20066__$1;
(statearr_20115_20187[(2)] = inst_19992);

(statearr_20115_20187[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (47))){
var inst_19946 = (state_20066[(30)]);
var state_20066__$1 = state_20066;
if(cljs.core.truth_(inst_19946)){
var statearr_20116_20188 = state_20066__$1;
(statearr_20116_20188[(1)] = (49));

} else {
var statearr_20117_20189 = state_20066__$1;
(statearr_20117_20189[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (35))){
var inst_19986 = (state_20066[(31)]);
var inst_20010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20011 = [inst_19986];
var inst_20012 = (new cljs.core.PersistentVector(null,1,(5),inst_20010,inst_20011,null));
var inst_20013 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20012);
var state_20066__$1 = state_20066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20066__$1,(38),inst_20013);
} else {
if((state_val_20067 === (19))){
var inst_19945 = (state_20066[(11)]);
var inst_20047 = (state_20066[(2)]);
var state_20066__$1 = (function (){var statearr_20118 = state_20066;
(statearr_20118[(14)] = inst_20047);

return statearr_20118;
})();
if(cljs.core.truth_(inst_19945)){
var statearr_20119_20190 = state_20066__$1;
(statearr_20119_20190[(1)] = (46));

} else {
var statearr_20120_20191 = state_20066__$1;
(statearr_20120_20191[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (11))){
var inst_19956 = (state_20066[(12)]);
var inst_19953 = (state_20066[(2)]);
var inst_19954 = fluree.db.util.async.throw_err(inst_19953);
var inst_19955 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.s,inst_19954);
var inst_19956__$1 = cljs.core.not_empty(inst_19955);
var state_20066__$1 = (function (){var statearr_20122 = state_20066;
(statearr_20122[(12)] = inst_19956__$1);

return statearr_20122;
})();
if(cljs.core.truth_(inst_19956__$1)){
var statearr_20123_20192 = state_20066__$1;
(statearr_20123_20192[(1)] = (12));

} else {
var statearr_20124_20193 = state_20066__$1;
(statearr_20124_20193[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (9))){
var inst_19941 = (state_20066[(32)]);
var inst_19931 = (state_20066[(24)]);
var inst_19940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19931,(0),null);
var inst_19941__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19931,(1),null);
var inst_19942 = cljs.core.__destructure_map(inst_19941__$1);
var inst_19943 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19942,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_19944 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19942,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_19945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19942,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_19946 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19942,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_19947 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19942,new cljs.core.Keyword(null,"p","p",151049309));
var inst_19948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19949 = [subject_id,inst_19940];
var inst_19950 = (new cljs.core.PersistentVector(null,2,(5),inst_19948,inst_19949,null));
var inst_19951 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_19950);
var state_20066__$1 = (function (){var statearr_20125 = state_20066;
(statearr_20125[(17)] = inst_19947);

(statearr_20125[(32)] = inst_19941__$1);

(statearr_20125[(11)] = inst_19945);

(statearr_20125[(30)] = inst_19946);

(statearr_20125[(8)] = inst_19943);

(statearr_20125[(9)] = inst_19944);

return statearr_20125;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20066__$1,(11),inst_19951);
} else {
if((state_val_20067 === (5))){
var _ = (function (){var statearr_20126 = state_20066;
(statearr_20126[(4)] = cljs.core.rest((state_20066[(4)])));

return statearr_20126;
})();
var state_20066__$1 = state_20066;
var ex20121 = (state_20066__$1[(2)]);
var statearr_20127_20194 = state_20066__$1;
(statearr_20127_20194[(5)] = ex20121);


if((ex20121 instanceof Error)){
var statearr_20128_20195 = state_20066__$1;
(statearr_20128_20195[(1)] = (4));

(statearr_20128_20195[(5)] = null);

} else {
throw ex20121;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (14))){
var inst_19960 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
if(cljs.core.truth_(inst_19960)){
var statearr_20129_20196 = state_20066__$1;
(statearr_20129_20196[(1)] = (15));

} else {
var statearr_20130_20197 = state_20066__$1;
(statearr_20130_20197[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (45))){
var inst_19980 = (state_20066[(10)]);
var inst_20032 = (state_20066[(2)]);
var inst_20033 = fluree.db.util.async.throw_err(inst_20032);
var inst_20034 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_19980,inst_20033);
var state_20066__$1 = state_20066;
var statearr_20131_20198 = state_20066__$1;
(statearr_20131_20198[(2)] = inst_20034);

(statearr_20131_20198[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (26))){
var inst_19980 = (state_20066[(10)]);
var state_20066__$1 = state_20066;
var statearr_20132_20199 = state_20066__$1;
(statearr_20132_20199[(2)] = inst_19980);

(statearr_20132_20199[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (16))){
var state_20066__$1 = state_20066;
var statearr_20133_20200 = state_20066__$1;
(statearr_20133_20200[(2)] = null);

(statearr_20133_20200[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (38))){
var inst_19941 = (state_20066[(32)]);
var inst_20016 = (state_20066[(21)]);
var inst_20015 = (state_20066[(2)]);
var inst_20016__$1 = fluree.db.util.async.throw_err(inst_20015);
var inst_20017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20018 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_20019 = (new cljs.core.PersistentVector(null,4,(5),inst_20017,inst_20018,null));
var inst_20020 = cljs.core.select_keys(inst_19941,inst_20019);
var inst_20021 = cljs.core.empty_QMARK_(inst_20016__$1);
var state_20066__$1 = (function (){var statearr_20134 = state_20066;
(statearr_20134[(21)] = inst_20016__$1);

(statearr_20134[(22)] = inst_20020);

return statearr_20134;
})();
if(inst_20021){
var statearr_20135_20201 = state_20066__$1;
(statearr_20135_20201[(1)] = (39));

} else {
var statearr_20136_20202 = state_20066__$1;
(statearr_20136_20202[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (30))){
var inst_19943 = (state_20066[(8)]);
var state_20066__$1 = state_20066;
var statearr_20137_20203 = state_20066__$1;
(statearr_20137_20203[(2)] = inst_19943);

(statearr_20137_20203[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (10))){
var inst_20059 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
var statearr_20138_20204 = state_20066__$1;
(statearr_20138_20204[(2)] = inst_20059);

(statearr_20138_20204[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (18))){
var inst_19978 = (state_20066[(20)]);
var inst_19988 = (state_20066[(7)]);
var inst_19986 = (state_20066[(31)]);
var inst_19985 = cljs.core.seq(inst_19978);
var inst_19986__$1 = cljs.core.first(inst_19985);
var inst_19987 = cljs.core.next(inst_19985);
var inst_19988__$1 = cljs.core.not(inst_19986__$1);
var state_20066__$1 = (function (){var statearr_20139 = state_20066;
(statearr_20139[(19)] = inst_19987);

(statearr_20139[(7)] = inst_19988__$1);

(statearr_20139[(31)] = inst_19986__$1);

return statearr_20139;
})();
if(inst_19988__$1){
var statearr_20140_20205 = state_20066__$1;
(statearr_20140_20205[(1)] = (20));

} else {
var statearr_20141_20206 = state_20066__$1;
(statearr_20141_20206[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (42))){
var inst_20016 = (state_20066[(21)]);
var inst_20025 = cljs.core.count(inst_20016);
var inst_20026 = fluree.db.query.fql_resp.add_fuel(fuel,inst_20025,max_fuel);
var state_20066__$1 = state_20066;
var statearr_20142_20207 = state_20066__$1;
(statearr_20142_20207[(2)] = inst_20026);

(statearr_20142_20207[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (37))){
var inst_20041 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
var statearr_20143_20208 = state_20066__$1;
(statearr_20143_20208[(2)] = inst_20041);

(statearr_20143_20208[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (8))){
var inst_19925 = (state_20066[(13)]);
var state_20066__$1 = state_20066;
var statearr_20144_20209 = state_20066__$1;
(statearr_20144_20209[(2)] = inst_19925);

(statearr_20144_20209[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (49))){
var inst_19946 = (state_20066[(30)]);
var state_20066__$1 = state_20066;
var statearr_20145_20210 = state_20066__$1;
(statearr_20145_20210[(2)] = inst_19946);

(statearr_20145_20210[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0 = (function (){
var statearr_20146 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20146[(0)] = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__);

(statearr_20146[(1)] = (1));

return statearr_20146;
});
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1 = (function (state_20066){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20066);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20147){var ex__2730__auto__ = e20147;
var statearr_20148_20211 = state_20066;
(statearr_20148_20211[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20066[(4)]))){
var statearr_20149_20212 = state_20066;
(statearr_20149_20212[(1)] = cljs.core.first((state_20066[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20213 = state_20066;
state_20066 = G__20213;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__ = function(state_20066){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1.call(this,state_20066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20150 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20150[(6)] = c__2749__auto__);

return statearr_20150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.fql_resp.component_follow_QMARK_ = (function fluree$db$query$fql_resp$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql_resp.fuel_flake_transducer = (function fluree$db$query$fql_resp$fuel_flake_transducer(var_args){
var G__20215 = arguments.length;
switch (G__20215) {
case 2:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__20217 = null;
var G__20217__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__20217__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__20217__2 = (function (result,flake){
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__20217 = function(result,flake){
switch(arguments.length){
case 0:
return G__20217__0.call(this);
case 1:
return G__20217__1.call(this,result);
case 2:
return G__20217__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20217.cljs$core$IFn$_invoke$arity$0 = G__20217__0;
G__20217.cljs$core$IFn$_invoke$arity$1 = G__20217__1;
G__20217.cljs$core$IFn$_invoke$arity$2 = G__20217__2;
return G__20217;
})()
});
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql_resp.recur_select_spec = (function fluree$db$query$fql_resp$recur_select_spec(select_spec,flake){
var recur_subject = fluree.db.flake.o(flake);
var recur_pred = fluree.db.flake.p(flake);
var map__20218 = select_spec;
var map__20218__$1 = cljs.core.__destructure_map(map__20218);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20218__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20218__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.flake__GT_recur = (function fluree$db$query$fql_resp$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20332){
var state_val_20333 = (state_20332[(1)]);
if((state_val_20333 === (7))){
var inst_20244 = flakes;
var inst_20245 = cljs.core.seq(inst_20244);
var inst_20246 = cljs.core.first(inst_20245);
var inst_20247 = cljs.core.next(inst_20245);
var inst_20248 = cljs.core.PersistentVector.EMPTY;
var inst_20249 = inst_20244;
var inst_20250 = (0);
var inst_20251 = inst_20248;
var state_20332__$1 = (function (){var statearr_20334 = state_20332;
(statearr_20334[(7)] = inst_20246);

(statearr_20334[(8)] = inst_20247);

(statearr_20334[(9)] = inst_20250);

(statearr_20334[(10)] = inst_20251);

(statearr_20334[(11)] = inst_20249);

return statearr_20334;
})();
var statearr_20335_20401 = state_20332__$1;
(statearr_20335_20401[(2)] = null);

(statearr_20335_20401[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (20))){
var state_20332__$1 = state_20332;
var statearr_20336_20402 = state_20332__$1;
(statearr_20336_20402[(2)] = results);

(statearr_20336_20402[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (27))){
var state_20332__$1 = state_20332;
var statearr_20337_20403 = state_20332__$1;
(statearr_20337_20403[(2)] = null);

(statearr_20337_20403[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (1))){
var state_20332__$1 = state_20332;
var statearr_20338_20404 = state_20332__$1;
(statearr_20338_20404[(2)] = null);

(statearr_20338_20404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (24))){
var state_20332__$1 = state_20332;
var statearr_20339_20405 = state_20332__$1;
(statearr_20339_20405[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (39))){
var inst_20258 = (state_20332[(12)]);
var inst_20313 = (state_20332[(13)]);
var inst_20251 = (state_20332[(10)]);
var inst_20316 = (state_20332[(2)]);
var inst_20317 = fluree.db.util.async.throw_err(inst_20316);
var inst_20318 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_20251,inst_20317);
var inst_20249 = inst_20258;
var inst_20250 = inst_20313;
var inst_20251__$1 = inst_20318;
var state_20332__$1 = (function (){var statearr_20341 = state_20332;
(statearr_20341[(9)] = inst_20250);

(statearr_20341[(10)] = inst_20251__$1);

(statearr_20341[(11)] = inst_20249);

return statearr_20341;
})();
var statearr_20342_20406 = state_20332__$1;
(statearr_20342_20406[(2)] = null);

(statearr_20342_20406[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (4))){
var inst_20219 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
var statearr_20343_20407 = state_20332__$1;
(statearr_20343_20407[(2)] = inst_20219);

(statearr_20343_20407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (15))){
var inst_20232 = (state_20332[(14)]);
var state_20332__$1 = state_20332;
var statearr_20344_20408 = state_20332__$1;
(statearr_20344_20408[(2)] = inst_20232);

(statearr_20344_20408[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (21))){
var inst_20228 = (state_20332[(15)]);
var state_20332__$1 = state_20332;
if(cljs.core.truth_(inst_20228)){
var statearr_20345_20409 = state_20332__$1;
(statearr_20345_20409[(1)] = (23));

} else {
var statearr_20346_20410 = state_20332__$1;
(statearr_20346_20410[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (31))){
var inst_20296 = (state_20332[(16)]);
var state_20332__$1 = state_20332;
var statearr_20347_20411 = state_20332__$1;
(statearr_20347_20411[(2)] = inst_20296);

(statearr_20347_20411[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (32))){
var inst_20288 = (state_20332[(17)]);
var inst_20302 = (state_20332[(2)]);
var state_20332__$1 = (function (){var statearr_20348 = state_20332;
(statearr_20348[(18)] = inst_20302);

return statearr_20348;
})();
if(cljs.core.truth_(inst_20288)){
var statearr_20349_20412 = state_20332__$1;
(statearr_20349_20412[(1)] = (33));

} else {
var statearr_20350_20413 = state_20332__$1;
(statearr_20350_20413[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (33))){
var inst_20288 = (state_20332[(17)]);
var state_20332__$1 = state_20332;
var statearr_20351_20414 = state_20332__$1;
(statearr_20351_20414[(2)] = inst_20288);

(statearr_20351_20414[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (13))){
var inst_20268 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
if(cljs.core.truth_(inst_20268)){
var statearr_20353_20415 = state_20332__$1;
(statearr_20353_20415[(1)] = (17));

} else {
var statearr_20354_20416 = state_20332__$1;
(statearr_20354_20416[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (22))){
var inst_20285 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
var statearr_20355_20417 = state_20332__$1;
(statearr_20355_20417[(2)] = inst_20285);

(statearr_20355_20417[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (36))){
var inst_20258 = (state_20332[(12)]);
var inst_20250 = (state_20332[(9)]);
var inst_20251 = (state_20332[(10)]);
var inst_20310 = (inst_20250 + (1));
var tmp20352 = inst_20251;
var inst_20249 = inst_20258;
var inst_20250__$1 = inst_20310;
var inst_20251__$1 = tmp20352;
var state_20332__$1 = (function (){var statearr_20356 = state_20332;
(statearr_20356[(9)] = inst_20250__$1);

(statearr_20356[(10)] = inst_20251__$1);

(statearr_20356[(11)] = inst_20249);

return statearr_20356;
})();
var statearr_20357_20418 = state_20332__$1;
(statearr_20357_20418[(2)] = null);

(statearr_20357_20418[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (29))){
var inst_20295 = (state_20332[(2)]);
var inst_20296 = fluree.db.util.async.throw_err(inst_20295);
var state_20332__$1 = (function (){var statearr_20358 = state_20332;
(statearr_20358[(16)] = inst_20296);

return statearr_20358;
})();
if(cljs.core.truth_(fuel)){
var statearr_20359_20419 = state_20332__$1;
(statearr_20359_20419[(1)] = (30));

} else {
var statearr_20360_20420 = state_20332__$1;
(statearr_20360_20420[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (6))){
var state_20332__$1 = state_20332;
var statearr_20361_20421 = state_20332__$1;
(statearr_20361_20421[(2)] = results);

(statearr_20361_20421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (28))){
var inst_20281 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
var statearr_20362_20422 = state_20332__$1;
(statearr_20362_20422[(2)] = inst_20281);

(statearr_20362_20422[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (25))){
var inst_20283 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
var statearr_20363_20423 = state_20332__$1;
(statearr_20363_20423[(2)] = inst_20283);

(statearr_20363_20423[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (34))){
var inst_20302 = (state_20332[(18)]);
var inst_20305 = cljs.core.empty_QMARK_(inst_20302);
var state_20332__$1 = state_20332;
var statearr_20364_20424 = state_20332__$1;
(statearr_20364_20424[(2)] = inst_20305);

(statearr_20364_20424[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (17))){
var inst_20251 = (state_20332[(10)]);
var inst_20270 = cljs.core.empty_QMARK_(inst_20251);
var state_20332__$1 = state_20332;
if(inst_20270){
var statearr_20365_20425 = state_20332__$1;
(statearr_20365_20425[(1)] = (20));

} else {
var statearr_20366_20426 = state_20332__$1;
(statearr_20366_20426[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (3))){
var inst_20330 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20332__$1,inst_20330);
} else {
if((state_val_20333 === (12))){
var inst_20232 = (state_20332[(14)]);
var state_20332__$1 = state_20332;
if(cljs.core.truth_(inst_20232)){
var statearr_20367_20427 = state_20332__$1;
(statearr_20367_20427[(1)] = (14));

} else {
var statearr_20368_20428 = state_20332__$1;
(statearr_20368_20428[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (2))){
var _ = (function (){var statearr_20369 = state_20332;
(statearr_20369[(4)] = cljs.core.cons((5),(state_20332[(4)])));

return statearr_20369;
})();
var inst_20226 = select_spec;
var inst_20227 = cljs.core.__destructure_map(inst_20226);
var inst_20228 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20227,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_20229 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20227,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_20230 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20227,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_20231 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20227,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_20232 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20227,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_20233 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_20234 = (inst_20231 > inst_20233);
var state_20332__$1 = (function (){var statearr_20370 = state_20332;
(statearr_20370[(14)] = inst_20232);

(statearr_20370[(19)] = inst_20230);

(statearr_20370[(15)] = inst_20228);

(statearr_20370[(20)] = inst_20229);

return statearr_20370;
})();
if(cljs.core.truth_(inst_20234)){
var statearr_20371_20429 = state_20332__$1;
(statearr_20371_20429[(1)] = (6));

} else {
var statearr_20372_20430 = state_20332__$1;
(statearr_20372_20430[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (23))){
var inst_20229 = (state_20332[(20)]);
var inst_20251 = (state_20332[(10)]);
var inst_20274 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_20229,inst_20251);
var state_20332__$1 = state_20332;
var statearr_20373_20431 = state_20332__$1;
(statearr_20373_20431[(2)] = inst_20274);

(statearr_20373_20431[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (35))){
var inst_20257 = (state_20332[(21)]);
var inst_20307 = (state_20332[(2)]);
var inst_20308 = fluree.db.query.fql_resp.recur_select_spec(select_spec,inst_20257);
var state_20332__$1 = (function (){var statearr_20374 = state_20332;
(statearr_20374[(22)] = inst_20308);

return statearr_20374;
})();
if(cljs.core.truth_(inst_20307)){
var statearr_20375_20432 = state_20332__$1;
(statearr_20375_20432[(1)] = (36));

} else {
var statearr_20376_20433 = state_20332__$1;
(statearr_20376_20433[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (19))){
var inst_20323 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
var statearr_20377_20434 = state_20332__$1;
(statearr_20377_20434[(2)] = inst_20323);

(statearr_20377_20434[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (11))){
var inst_20259 = (state_20332[(23)]);
var state_20332__$1 = state_20332;
var statearr_20379_20435 = state_20332__$1;
(statearr_20379_20435[(2)] = inst_20259);

(statearr_20379_20435[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (9))){
var inst_20259 = (state_20332[(23)]);
var inst_20257 = (state_20332[(21)]);
var inst_20249 = (state_20332[(11)]);
var inst_20256 = cljs.core.seq(inst_20249);
var inst_20257__$1 = cljs.core.first(inst_20256);
var inst_20258 = cljs.core.next(inst_20256);
var inst_20259__$1 = cljs.core.not(inst_20257__$1);
var state_20332__$1 = (function (){var statearr_20380 = state_20332;
(statearr_20380[(12)] = inst_20258);

(statearr_20380[(23)] = inst_20259__$1);

(statearr_20380[(21)] = inst_20257__$1);

return statearr_20380;
})();
if(inst_20259__$1){
var statearr_20381_20436 = state_20332__$1;
(statearr_20381_20436[(1)] = (11));

} else {
var statearr_20382_20437 = state_20332__$1;
(statearr_20382_20437[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (5))){
var _ = (function (){var statearr_20383 = state_20332;
(statearr_20383[(4)] = cljs.core.rest((state_20332[(4)])));

return statearr_20383;
})();
var state_20332__$1 = state_20332;
var ex20378 = (state_20332__$1[(2)]);
var statearr_20384_20438 = state_20332__$1;
(statearr_20384_20438[(5)] = ex20378);


if((ex20378 instanceof Error)){
var statearr_20385_20439 = state_20332__$1;
(statearr_20385_20439[(1)] = (4));

(statearr_20385_20439[(5)] = null);

} else {
throw ex20378;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (14))){
var inst_20232 = (state_20332[(14)]);
var inst_20250 = (state_20332[(9)]);
var inst_20263 = (inst_20250 < inst_20232);
var state_20332__$1 = state_20332;
var statearr_20386_20440 = state_20332__$1;
(statearr_20386_20440[(2)] = inst_20263);

(statearr_20386_20440[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (26))){
var inst_20229 = (state_20332[(20)]);
var inst_20251 = (state_20332[(10)]);
var inst_20277 = cljs.core.first(inst_20251);
var inst_20278 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_20229,inst_20277);
var state_20332__$1 = state_20332;
var statearr_20387_20441 = state_20332__$1;
(statearr_20387_20441[(2)] = inst_20278);

(statearr_20387_20441[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (16))){
var inst_20266 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
var statearr_20388_20442 = state_20332__$1;
(statearr_20388_20442[(2)] = inst_20266);

(statearr_20388_20442[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (38))){
var inst_20321 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
var statearr_20389_20443 = state_20332__$1;
(statearr_20389_20443[(2)] = inst_20321);

(statearr_20389_20443[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (30))){
var inst_20296 = (state_20332[(16)]);
var inst_20298 = fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_20299 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_20298,inst_20296);
var state_20332__$1 = state_20332;
var statearr_20390_20444 = state_20332__$1;
(statearr_20390_20444[(2)] = inst_20299);

(statearr_20390_20444[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (10))){
var inst_20325 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
var statearr_20391_20445 = state_20332__$1;
(statearr_20391_20445[(2)] = inst_20325);

(statearr_20391_20445[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (18))){
var inst_20230 = (state_20332[(19)]);
var inst_20257 = (state_20332[(21)]);
var inst_20287 = fluree.db.flake.o(inst_20257);
var inst_20288 = cljs.core.contains_QMARK_(inst_20230,inst_20287);
var inst_20290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20291 = [inst_20287];
var inst_20292 = (new cljs.core.PersistentVector(null,1,(5),inst_20290,inst_20291,null));
var inst_20293 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20292);
var state_20332__$1 = (function (){var statearr_20392 = state_20332;
(statearr_20392[(17)] = inst_20288);

return statearr_20392;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20332__$1,(29),inst_20293);
} else {
if((state_val_20333 === (37))){
var inst_20302 = (state_20332[(18)]);
var inst_20308 = (state_20332[(22)]);
var inst_20250 = (state_20332[(9)]);
var inst_20313 = (inst_20250 + (1));
var inst_20314 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_20308,inst_20302) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_20308,inst_20302));
var state_20332__$1 = (function (){var statearr_20393 = state_20332;
(statearr_20393[(13)] = inst_20313);

return statearr_20393;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20332__$1,(39),inst_20314);
} else {
if((state_val_20333 === (8))){
var inst_20327 = (state_20332[(2)]);
var _ = (function (){var statearr_20394 = state_20332;
(statearr_20394[(4)] = cljs.core.rest((state_20332[(4)])));

return statearr_20394;
})();
var state_20332__$1 = state_20332;
var statearr_20395_20446 = state_20332__$1;
(statearr_20395_20446[(2)] = inst_20327);

(statearr_20395_20446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0 = (function (){
var statearr_20396 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20396[(0)] = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__);

(statearr_20396[(1)] = (1));

return statearr_20396;
});
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1 = (function (state_20332){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20332);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20397){var ex__2730__auto__ = e20397;
var statearr_20398_20447 = state_20332;
(statearr_20398_20447[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20332[(4)]))){
var statearr_20399_20448 = state_20332;
(statearr_20399_20448[(1)] = cljs.core.first((state_20332[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20449 = state_20332;
state_20332 = G__20449;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__ = function(state_20332){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1.call(this,state_20332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20400 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20400[(6)] = c__2749__auto__);

return statearr_20400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql_resp.wildcard_pred_spec = (function fluree$db$query$fql_resp$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4253__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.add_pred = (function fluree$db$query$fql_resp$add_pred(var_args){
var G__20453 = arguments.length;
switch (G__20453) {
case 9:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20892){
var state_val_20893 = (state_20892[(1)]);
if((state_val_20893 === (121))){
var inst_20815 = (state_20892[(2)]);
var inst_20816 = fluree.db.util.async.throw_err(inst_20815);
var inst_20817 = cljs.core.seq(inst_20816);
var state_20892__$1 = state_20892;
if(inst_20817){
var statearr_20894_21108 = state_20892__$1;
(statearr_20894_21108[(1)] = (122));

} else {
var statearr_20895_21109 = state_20892__$1;
(statearr_20895_21109[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (65))){
var inst_20608 = (state_20892[(7)]);
var inst_20607 = (state_20892[(2)]);
var inst_20608__$1 = fluree.db.util.async.throw_err(inst_20607);
var inst_20609 = cljs.core.seq(inst_20608__$1);
var state_20892__$1 = (function (){var statearr_20896 = state_20892;
(statearr_20896[(7)] = inst_20608__$1);

return statearr_20896;
})();
if(inst_20609){
var statearr_20897_21110 = state_20892__$1;
(statearr_20897_21110[(1)] = (66));

} else {
var statearr_20898_21111 = state_20892__$1;
(statearr_20898_21111[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (70))){
var inst_20608 = (state_20892[(7)]);
var inst_20619 = cljs.core.count(inst_20608);
var inst_20620 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_20619);
var state_20892__$1 = state_20892;
var statearr_20899_21112 = state_20892__$1;
(statearr_20899_21112[(2)] = inst_20620);

(statearr_20899_21112[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (62))){
var inst_20598 = (state_20892[(8)]);
var inst_20601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20602 = fluree.db.flake.o(inst_20598);
var inst_20603 = [inst_20602];
var inst_20604 = (new cljs.core.PersistentVector(null,1,(5),inst_20601,inst_20603,null));
var inst_20605 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20604);
var state_20892__$1 = state_20892;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20892__$1,(65),inst_20605);
} else {
if((state_val_20893 === (74))){
var inst_20592 = (state_20892[(9)]);
var state_20892__$1 = state_20892;
var statearr_20900_21113 = state_20892__$1;
(statearr_20900_21113[(2)] = inst_20592);

(statearr_20900_21113[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (110))){
var inst_20777 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_20778 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_20777);
var inst_20779 = inst_20778 === true;
var state_20892__$1 = state_20892;
if(cljs.core.truth_(inst_20779)){
var statearr_20901_21114 = state_20892__$1;
(statearr_20901_21114[(1)] = (113));

} else {
var statearr_20902_21115 = state_20892__$1;
(statearr_20902_21115[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (130))){
var inst_20887 = (state_20892[(2)]);
var _ = (function (){var statearr_20903 = state_20892;
(statearr_20903[(4)] = cljs.core.rest((state_20892[(4)])));

return statearr_20903;
})();
var state_20892__$1 = state_20892;
var statearr_20904_21116 = state_20892__$1;
(statearr_20904_21116[(2)] = inst_20887);

(statearr_20904_21116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (128))){
var inst_20862 = (state_20892[(10)]);
var inst_20865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20866 = [acc,inst_20862];
var inst_20867 = (new cljs.core.PersistentVector(null,2,(5),inst_20865,inst_20866,null));
var state_20892__$1 = state_20892;
var statearr_20905_21117 = state_20892__$1;
(statearr_20905_21117[(2)] = inst_20867);

(statearr_20905_21117[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (7))){
var inst_20465 = (state_20892[(11)]);
var state_20892__$1 = state_20892;
var statearr_20906_21118 = state_20892__$1;
(statearr_20906_21118[(2)] = inst_20465);

(statearr_20906_21118[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (59))){
var inst_20856 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_20907_21119 = state_20892__$1;
(statearr_20907_21119[(2)] = inst_20856);

(statearr_20907_21119[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (86))){
var inst_20686 = (state_20892[(12)]);
var inst_20686__$1 = (state_20892[(2)]);
var state_20892__$1 = (function (){var statearr_20908 = state_20892;
(statearr_20908[(12)] = inst_20686__$1);

return statearr_20908;
})();
if(cljs.core.truth_(inst_20686__$1)){
var statearr_20909_21120 = state_20892__$1;
(statearr_20909_21120[(1)] = (88));

} else {
var statearr_20910_21121 = state_20892__$1;
(statearr_20910_21121[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (20))){
var inst_20506 = (state_20892[(13)]);
var inst_20494 = (state_20892[(14)]);
var inst_20507 = (state_20892[(15)]);
var inst_20505 = (state_20892[(2)]);
var inst_20506__$1 = cljs.core.__destructure_map(inst_20494);
var inst_20507__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20506__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_20508 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20506__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_20509 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20506__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_20510 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20506__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_20511 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20506__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_20512 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20506__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_20892__$1 = (function (){var statearr_20911 = state_20892;
(statearr_20911[(16)] = inst_20509);

(statearr_20911[(17)] = inst_20510);

(statearr_20911[(13)] = inst_20506__$1);

(statearr_20911[(18)] = inst_20505);

(statearr_20911[(19)] = inst_20511);

(statearr_20911[(20)] = inst_20508);

(statearr_20911[(21)] = inst_20512);

(statearr_20911[(15)] = inst_20507__$1);

return statearr_20911;
})();
if(cljs.core.truth_(inst_20507__$1)){
var statearr_20912_21122 = state_20892__$1;
(statearr_20912_21122[(1)] = (24));

} else {
var statearr_20913_21123 = state_20892__$1;
(statearr_20913_21123[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (72))){
var inst_20617 = (state_20892[(22)]);
var inst_20623 = (state_20892[(2)]);
var inst_20624 = cljs.core.seq(inst_20617);
var state_20892__$1 = (function (){var statearr_20914 = state_20892;
(statearr_20914[(23)] = inst_20623);

return statearr_20914;
})();
if(inst_20624){
var statearr_20915_21124 = state_20892__$1;
(statearr_20915_21124[(1)] = (73));

} else {
var statearr_20916_21125 = state_20892__$1;
(statearr_20916_21125[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (58))){
var inst_20494 = (state_20892[(14)]);
var inst_20639 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_20494);
var state_20892__$1 = state_20892;
if(cljs.core.truth_(inst_20639)){
var statearr_20917_21126 = state_20892__$1;
(statearr_20917_21126[(1)] = (76));

} else {
var statearr_20918_21127 = state_20892__$1;
(statearr_20918_21127[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (60))){
var inst_20591 = (state_20892[(24)]);
var inst_20598 = (state_20892[(8)]);
var inst_20597 = cljs.core.seq(inst_20591);
var inst_20598__$1 = cljs.core.first(inst_20597);
var inst_20599 = cljs.core.next(inst_20597);
var state_20892__$1 = (function (){var statearr_20919 = state_20892;
(statearr_20919[(25)] = inst_20599);

(statearr_20919[(8)] = inst_20598__$1);

return statearr_20919;
})();
if(cljs.core.truth_(inst_20598__$1)){
var statearr_20920_21128 = state_20892__$1;
(statearr_20920_21128[(1)] = (62));

} else {
var statearr_20921_21129 = state_20892__$1;
(statearr_20921_21129[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (27))){
var inst_20515 = (state_20892[(26)]);
var inst_20511 = (state_20892[(19)]);
var inst_20515__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_20511);
var state_20892__$1 = (function (){var statearr_20922 = state_20892;
(statearr_20922[(26)] = inst_20515__$1);

return statearr_20922;
})();
if(inst_20515__$1){
var statearr_20923_21130 = state_20892__$1;
(statearr_20923_21130[(1)] = (30));

} else {
var statearr_20924_21131 = state_20892__$1;
(statearr_20924_21131[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (1))){
var state_20892__$1 = state_20892;
var statearr_20925_21132 = state_20892__$1;
(statearr_20925_21132[(2)] = null);

(statearr_20925_21132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (69))){
var inst_20613 = (state_20892[(2)]);
var inst_20614 = fluree.db.util.async.throw_err(inst_20613);
var state_20892__$1 = state_20892;
var statearr_20926_21133 = state_20892__$1;
(statearr_20926_21133[(2)] = inst_20614);

(statearr_20926_21133[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (101))){
var inst_20770 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_20927_21134 = state_20892__$1;
(statearr_20927_21134[(2)] = inst_20770);

(statearr_20927_21134[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (24))){
var inst_20511 = (state_20892[(19)]);
var state_20892__$1 = state_20892;
if(cljs.core.truth_(inst_20511)){
var statearr_20928_21135 = state_20892__$1;
(statearr_20928_21135[(1)] = (27));

} else {
var statearr_20929_21136 = state_20892__$1;
(statearr_20929_21136[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (102))){
var inst_20742 = (state_20892[(27)]);
var inst_20741 = (state_20892[(2)]);
var inst_20742__$1 = fluree.db.util.async.throw_err(inst_20741);
var inst_20743 = cljs.core.empty_QMARK_(inst_20742__$1);
var state_20892__$1 = (function (){var statearr_20930 = state_20892;
(statearr_20930[(27)] = inst_20742__$1);

return statearr_20930;
})();
if(inst_20743){
var statearr_20931_21137 = state_20892__$1;
(statearr_20931_21137[(1)] = (103));

} else {
var statearr_20932_21138 = state_20892__$1;
(statearr_20932_21138[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (135))){
var state_20892__$1 = state_20892;
var statearr_20933_21139 = state_20892__$1;
(statearr_20933_21139[(2)] = null);

(statearr_20933_21139[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (55))){
var inst_20494 = (state_20892[(14)]);
var inst_20567 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_20494);
var state_20892__$1 = state_20892;
var statearr_20934_21140 = state_20892__$1;
(statearr_20934_21140[(2)] = inst_20567);

(statearr_20934_21140[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (85))){
var inst_20494 = (state_20892[(14)]);
var inst_20661 = (state_20892[(28)]);
var inst_20673 = fluree.db.flake.o(inst_20661);
var inst_20674 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_20494);
var inst_20675 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_20673,inst_20674);
var state_20892__$1 = state_20892;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20892__$1,(87),inst_20675);
} else {
if((state_val_20893 === (39))){
var inst_20510 = (state_20892[(17)]);
var inst_20542 = (state_20892[(29)]);
var inst_20542__$1 = cljs.core.not(inst_20510);
var state_20892__$1 = (function (){var statearr_20935 = state_20892;
(statearr_20935[(29)] = inst_20542__$1);

return statearr_20935;
})();
if(inst_20542__$1){
var statearr_20936_21141 = state_20892__$1;
(statearr_20936_21141[(1)] = (42));

} else {
var statearr_20937_21142 = state_20892__$1;
(statearr_20937_21142[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (88))){
var inst_20686 = (state_20892[(12)]);
var inst_20655 = (state_20892[(30)]);
var inst_20688 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_20655,inst_20686);
var state_20892__$1 = state_20892;
var statearr_20938_21143 = state_20892__$1;
(statearr_20938_21143[(2)] = inst_20688);

(statearr_20938_21143[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (46))){
var inst_20509 = (state_20892[(16)]);
var state_20892__$1 = state_20892;
var statearr_20939_21144 = state_20892__$1;
(statearr_20939_21144[(2)] = inst_20509);

(statearr_20939_21144[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (4))){
var inst_20454 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_20940_21145 = state_20892__$1;
(statearr_20940_21145[(2)] = inst_20454);

(statearr_20940_21145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (77))){
var inst_20701 = (state_20892[(31)]);
var inst_20701__$1 = componentFollow_QMARK_;
var state_20892__$1 = (function (){var statearr_20941 = state_20892;
(statearr_20941[(31)] = inst_20701__$1);

return statearr_20941;
})();
if(cljs.core.truth_(inst_20701__$1)){
var statearr_20942_21146 = state_20892__$1;
(statearr_20942_21146[(1)] = (91));

} else {
var statearr_20943_21147 = state_20892__$1;
(statearr_20943_21147[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (106))){
var inst_20722 = (state_20892[(32)]);
var inst_20756 = (state_20892[(2)]);
var inst_20757 = fluree.db.util.async.throw_err(inst_20756);
var inst_20758 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_20722,inst_20757);
var state_20892__$1 = state_20892;
var statearr_20944_21148 = state_20892__$1;
(statearr_20944_21148[(2)] = inst_20758);

(statearr_20944_21148[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (119))){
var inst_20800 = (state_20892[(33)]);
var inst_20830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20831 = [inst_20800,offset_map];
var inst_20832 = (new cljs.core.PersistentVector(null,2,(5),inst_20830,inst_20831,null));
var state_20892__$1 = state_20892;
var statearr_20945_21149 = state_20892__$1;
(statearr_20945_21149[(2)] = inst_20832);

(statearr_20945_21149[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (95))){
var inst_20508 = (state_20892[(20)]);
var state_20892__$1 = state_20892;
if(cljs.core.truth_(inst_20508)){
var statearr_20946_21150 = state_20892__$1;
(statearr_20946_21150[(1)] = (110));

} else {
var statearr_20947_21151 = state_20892__$1;
(statearr_20947_21151[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (54))){
var inst_20564 = (state_20892[(34)]);
var state_20892__$1 = state_20892;
var statearr_20948_21152 = state_20892__$1;
(statearr_20948_21152[(2)] = inst_20564);

(statearr_20948_21152[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (92))){
var inst_20701 = (state_20892[(31)]);
var state_20892__$1 = state_20892;
var statearr_20949_21153 = state_20892__$1;
(statearr_20949_21153[(2)] = inst_20701);

(statearr_20949_21153[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (104))){
var inst_20464 = (state_20892[(35)]);
var inst_20742 = (state_20892[(27)]);
var inst_20751 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_20752 = [true,inst_20464];
var inst_20753 = cljs.core.PersistentHashMap.fromArrays(inst_20751,inst_20752);
var inst_20754 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_20753,inst_20742) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_20753,inst_20742));
var state_20892__$1 = state_20892;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20892__$1,(106),inst_20754);
} else {
if((state_val_20893 === (15))){
var inst_20464 = (state_20892[(35)]);
var inst_20487 = (state_20892[(36)]);
var inst_20491 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20487,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_20464);
var state_20892__$1 = state_20892;
var statearr_20950_21154 = state_20892__$1;
(statearr_20950_21154[(2)] = inst_20491);

(statearr_20950_21154[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (48))){
var inst_20558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20559 = [null,offset_map];
var inst_20560 = (new cljs.core.PersistentVector(null,2,(5),inst_20558,inst_20559,null));
var state_20892__$1 = state_20892;
var statearr_20951_21155 = state_20892__$1;
(statearr_20951_21155[(2)] = inst_20560);

(statearr_20951_21155[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (50))){
var inst_20858 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_20952_21156 = state_20892__$1;
(statearr_20952_21156[(2)] = inst_20858);

(statearr_20952_21156[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (116))){
var inst_20806 = (state_20892[(37)]);
var inst_20799 = (state_20892[(38)]);
var inst_20805 = cljs.core.seq(inst_20799);
var inst_20806__$1 = cljs.core.first(inst_20805);
var inst_20807 = cljs.core.next(inst_20805);
var state_20892__$1 = (function (){var statearr_20953 = state_20892;
(statearr_20953[(37)] = inst_20806__$1);

(statearr_20953[(39)] = inst_20807);

return statearr_20953;
})();
if(cljs.core.truth_(inst_20806__$1)){
var statearr_20954_21157 = state_20892__$1;
(statearr_20954_21157[(1)] = (118));

} else {
var statearr_20955_21158 = state_20892__$1;
(statearr_20955_21158[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (75))){
var inst_20599 = (state_20892[(25)]);
var inst_20629 = (state_20892[(2)]);
var inst_20591 = inst_20599;
var inst_20592 = inst_20629;
var state_20892__$1 = (function (){var statearr_20956 = state_20892;
(statearr_20956[(9)] = inst_20592);

(statearr_20956[(24)] = inst_20591);

return statearr_20956;
})();
var statearr_20957_21159 = state_20892__$1;
(statearr_20957_21159[(2)] = null);

(statearr_20957_21159[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (99))){
var inst_20728 = (state_20892[(40)]);
var inst_20494 = (state_20892[(14)]);
var inst_20731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20732 = fluree.db.flake.o(inst_20728);
var inst_20733 = [inst_20732];
var inst_20734 = (new cljs.core.PersistentVector(null,1,(5),inst_20731,inst_20733,null));
var inst_20735 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_20736 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_20494);
var inst_20737 = [inst_20736];
var inst_20738 = cljs.core.PersistentHashMap.fromArrays(inst_20735,inst_20737);
var inst_20739 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20734,inst_20738);
var state_20892__$1 = state_20892;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20892__$1,(102),inst_20739);
} else {
if((state_val_20893 === (21))){
var inst_20498 = (state_20892[(41)]);
var state_20892__$1 = state_20892;
var statearr_20958_21160 = state_20892__$1;
(statearr_20958_21160[(2)] = inst_20498);

(statearr_20958_21160[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (31))){
var inst_20515 = (state_20892[(26)]);
var state_20892__$1 = state_20892;
var statearr_20959_21161 = state_20892__$1;
(statearr_20959_21161[(2)] = inst_20515);

(statearr_20959_21161[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (113))){
var inst_20479 = (state_20892[(42)]);
var inst_20509 = (state_20892[(16)]);
var inst_20510 = (state_20892[(17)]);
var inst_20464 = (state_20892[(35)]);
var inst_20506 = (state_20892[(13)]);
var inst_20494 = (state_20892[(14)]);
var inst_20505 = (state_20892[(18)]);
var inst_20511 = (state_20892[(19)]);
var inst_20508 = (state_20892[(20)]);
var inst_20512 = (state_20892[(21)]);
var inst_20507 = (state_20892[(15)]);
var inst_20781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20782 = (function (){var map__20460 = inst_20506;
var p = inst_20512;
var pred_spec__$1 = inst_20479;
var orderBy = inst_20510;
var multi_QMARK_ = inst_20507;
var limit = inst_20509;
var offset = inst_20511;
var k = inst_20505;
var compact_QMARK_ = inst_20464;
var pred_spec_SINGLEQUOTE_ = inst_20494;
var ref_QMARK_ = inst_20508;
return (function (p1__20450_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[fluree.db.flake.o(p1__20450_SHARP_)]);
});
})();
var inst_20783 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_20782,flakes);
var inst_20784 = [inst_20783,offset_map];
var inst_20785 = (new cljs.core.PersistentVector(null,2,(5),inst_20781,inst_20784,null));
var state_20892__$1 = state_20892;
var statearr_20960_21162 = state_20892__$1;
(statearr_20960_21162[(2)] = inst_20785);

(statearr_20960_21162[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (32))){
var inst_20521 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_20961_21163 = state_20892__$1;
(statearr_20961_21163[(2)] = inst_20521);

(statearr_20961_21163[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (136))){
var inst_20883 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_20962_21164 = state_20892__$1;
(statearr_20962_21164[(2)] = inst_20883);

(statearr_20962_21164[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (40))){
var inst_20507 = (state_20892[(15)]);
var state_20892__$1 = state_20892;
var statearr_20963_21165 = state_20892__$1;
(statearr_20963_21165[(2)] = inst_20507);

(statearr_20963_21165[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (129))){
var inst_20507 = (state_20892[(15)]);
var state_20892__$1 = state_20892;
if(cljs.core.truth_(inst_20507)){
var statearr_20964_21166 = state_20892__$1;
(statearr_20964_21166[(1)] = (131));

} else {
var statearr_20965_21167 = state_20892__$1;
(statearr_20965_21167[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (91))){
var inst_20494 = (state_20892[(14)]);
var inst_20703 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_20494);
var state_20892__$1 = state_20892;
var statearr_20966_21168 = state_20892__$1;
(statearr_20966_21168[(2)] = inst_20703);

(statearr_20966_21168[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (117))){
var inst_20836 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_20967_21169 = state_20892__$1;
(statearr_20967_21169[(2)] = inst_20836);

(statearr_20967_21169[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (108))){
var state_20892__$1 = state_20892;
var statearr_20968_21170 = state_20892__$1;
(statearr_20968_21170[(2)] = null);

(statearr_20968_21170[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (56))){
var inst_20569 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_20969_21171 = state_20892__$1;
(statearr_20969_21171[(2)] = inst_20569);

(statearr_20969_21171[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (33))){
var inst_20512 = (state_20892[(21)]);
var inst_20529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20530 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_20512);
var state_20892__$1 = (function (){var statearr_20970 = state_20892;
(statearr_20970[(43)] = inst_20529);

return statearr_20970;
})();
if(cljs.core.truth_(inst_20530)){
var statearr_20971_21172 = state_20892__$1;
(statearr_20971_21172[(1)] = (36));

} else {
var statearr_20972_21173 = state_20892__$1;
(statearr_20972_21173[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (13))){
var inst_20479 = (state_20892[(42)]);
var state_20892__$1 = state_20892;
var statearr_20973_21174 = state_20892__$1;
(statearr_20973_21174[(2)] = inst_20479);

(statearr_20973_21174[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (22))){
var inst_20494 = (state_20892[(14)]);
var inst_20501 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_20494);
var state_20892__$1 = state_20892;
var statearr_20974_21175 = state_20892__$1;
(statearr_20974_21175[(2)] = inst_20501);

(statearr_20974_21175[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (90))){
var inst_20662 = (state_20892[(44)]);
var inst_20691 = (state_20892[(2)]);
var inst_20654 = inst_20662;
var inst_20655 = inst_20691;
var state_20892__$1 = (function (){var statearr_20975 = state_20892;
(statearr_20975[(45)] = inst_20654);

(statearr_20975[(30)] = inst_20655);

return statearr_20975;
})();
var statearr_20976_21176 = state_20892__$1;
(statearr_20976_21176[(2)] = null);

(statearr_20976_21176[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (109))){
var inst_20729 = (state_20892[(46)]);
var inst_20760 = (state_20892[(47)]);
var inst_20766 = (state_20892[(2)]);
var inst_20721 = inst_20729;
var inst_20722 = inst_20760;
var state_20892__$1 = (function (){var statearr_20977 = state_20892;
(statearr_20977[(48)] = inst_20766);

(statearr_20977[(49)] = inst_20721);

(statearr_20977[(32)] = inst_20722);

return statearr_20977;
})();
var statearr_20978_21177 = state_20892__$1;
(statearr_20978_21177[(2)] = null);

(statearr_20978_21177[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (36))){
var inst_20512 = (state_20892[(21)]);
var inst_20532 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_20512,cljs.core.dec);
var state_20892__$1 = state_20892;
var statearr_20979_21178 = state_20892__$1;
(statearr_20979_21178[(2)] = inst_20532);

(statearr_20979_21178[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (41))){
var inst_20556 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
if(cljs.core.truth_(inst_20556)){
var statearr_20980_21179 = state_20892__$1;
(statearr_20980_21179[(1)] = (48));

} else {
var statearr_20981_21180 = state_20892__$1;
(statearr_20981_21180[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (118))){
var inst_20806 = (state_20892[(37)]);
var inst_20809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20810 = fluree.db.flake.o(inst_20806);
var inst_20811 = [inst_20810];
var inst_20812 = (new cljs.core.PersistentVector(null,1,(5),inst_20809,inst_20811,null));
var inst_20813 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20812);
var state_20892__$1 = state_20892;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20892__$1,(121),inst_20813);
} else {
if((state_val_20893 === (89))){
var inst_20655 = (state_20892[(30)]);
var state_20892__$1 = state_20892;
var statearr_20982_21181 = state_20892__$1;
(statearr_20982_21181[(2)] = inst_20655);

(statearr_20982_21181[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (100))){
var inst_20722 = (state_20892[(32)]);
var state_20892__$1 = state_20892;
var statearr_20983_21182 = state_20892__$1;
(statearr_20983_21182[(2)] = inst_20722);

(statearr_20983_21182[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (131))){
var inst_20862 = (state_20892[(10)]);
var inst_20861 = (state_20892[(50)]);
var inst_20505 = (state_20892[(18)]);
var inst_20870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20871 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_20505,inst_20861);
var inst_20872 = [inst_20871,inst_20862];
var inst_20873 = (new cljs.core.PersistentVector(null,2,(5),inst_20870,inst_20872,null));
var state_20892__$1 = state_20892;
var statearr_20984_21183 = state_20892__$1;
(statearr_20984_21183[(2)] = inst_20873);

(statearr_20984_21183[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (122))){
var inst_20806 = (state_20892[(37)]);
var inst_20807 = (state_20892[(39)]);
var inst_20800 = (state_20892[(33)]);
var inst_20819 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_20820 = fluree.db.flake.o(inst_20806);
var inst_20821 = [inst_20820];
var inst_20822 = cljs.core.PersistentHashMap.fromArrays(inst_20819,inst_20821);
var inst_20823 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_20800,inst_20822);
var inst_20799 = inst_20807;
var inst_20800__$1 = inst_20823;
var state_20892__$1 = (function (){var statearr_20985 = state_20892;
(statearr_20985[(33)] = inst_20800__$1);

(statearr_20985[(38)] = inst_20799);

return statearr_20985;
})();
var statearr_20986_21184 = state_20892__$1;
(statearr_20986_21184[(2)] = null);

(statearr_20986_21184[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (43))){
var inst_20542 = (state_20892[(29)]);
var state_20892__$1 = state_20892;
var statearr_20987_21185 = state_20892__$1;
(statearr_20987_21185[(2)] = inst_20542);

(statearr_20987_21185[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (61))){
var inst_20578 = (state_20892[(51)]);
var inst_20635 = (state_20892[(2)]);
var inst_20636 = [inst_20635,offset_map];
var inst_20637 = (new cljs.core.PersistentVector(null,2,(5),inst_20578,inst_20636,null));
var state_20892__$1 = state_20892;
var statearr_20988_21186 = state_20892__$1;
(statearr_20988_21186[(2)] = inst_20637);

(statearr_20988_21186[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (29))){
var inst_20524 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_20989_21187 = state_20892__$1;
(statearr_20989_21187[(2)] = inst_20524);

(statearr_20989_21187[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (44))){
var inst_20553 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_20990_21188 = state_20892__$1;
(statearr_20990_21188[(2)] = inst_20553);

(statearr_20990_21188[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (93))){
var inst_20706 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
if(cljs.core.truth_(inst_20706)){
var statearr_20991_21189 = state_20892__$1;
(statearr_20991_21189[(1)] = (94));

} else {
var statearr_20992_21190 = state_20892__$1;
(statearr_20992_21190[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (6))){
var inst_20467 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_20468 = (inst_20467 == null);
var state_20892__$1 = state_20892;
var statearr_20993_21191 = state_20892__$1;
(statearr_20993_21191[(2)] = inst_20468);

(statearr_20993_21191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (111))){
var state_20892__$1 = state_20892;
var statearr_20994_21192 = state_20892__$1;
(statearr_20994_21192[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (28))){
var inst_20511 = (state_20892[(19)]);
var state_20892__$1 = state_20892;
var statearr_20996_21193 = state_20892__$1;
(statearr_20996_21193[(2)] = inst_20511);

(statearr_20996_21193[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (134))){
var inst_20862 = (state_20892[(10)]);
var inst_20861 = (state_20892[(50)]);
var inst_20505 = (state_20892[(18)]);
var inst_20876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20877 = cljs.core.first(inst_20861);
var inst_20878 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_20505,inst_20877);
var inst_20879 = [inst_20878,inst_20862];
var inst_20880 = (new cljs.core.PersistentVector(null,2,(5),inst_20876,inst_20879,null));
var state_20892__$1 = state_20892;
var statearr_20997_21194 = state_20892__$1;
(statearr_20997_21194[(2)] = inst_20880);

(statearr_20997_21194[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (64))){
var inst_20633 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_20998_21195 = state_20892__$1;
(statearr_20998_21195[(2)] = inst_20633);

(statearr_20998_21195[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (103))){
var inst_20728 = (state_20892[(40)]);
var inst_20722 = (state_20892[(32)]);
var inst_20745 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_20746 = fluree.db.flake.o(inst_20728);
var inst_20747 = [inst_20746];
var inst_20748 = cljs.core.PersistentHashMap.fromArrays(inst_20745,inst_20747);
var inst_20749 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_20722,inst_20748);
var state_20892__$1 = state_20892;
var statearr_20999_21196 = state_20892__$1;
(statearr_20999_21196[(2)] = inst_20749);

(statearr_20999_21196[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (51))){
var inst_20564 = (state_20892[(34)]);
var inst_20494 = (state_20892[(14)]);
var inst_20564__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_20494);
var state_20892__$1 = (function (){var statearr_21000 = state_20892;
(statearr_21000[(34)] = inst_20564__$1);

return statearr_21000;
})();
if(cljs.core.truth_(inst_20564__$1)){
var statearr_21001_21197 = state_20892__$1;
(statearr_21001_21197[(1)] = (54));

} else {
var statearr_21002_21198 = state_20892__$1;
(statearr_21002_21198[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (25))){
var inst_20507 = (state_20892[(15)]);
var state_20892__$1 = state_20892;
var statearr_21003_21199 = state_20892__$1;
(statearr_21003_21199[(2)] = inst_20507);

(statearr_21003_21199[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (34))){
var inst_20507 = (state_20892[(15)]);
var state_20892__$1 = state_20892;
if(cljs.core.truth_(inst_20507)){
var statearr_21004_21200 = state_20892__$1;
(statearr_21004_21200[(1)] = (39));

} else {
var statearr_21005_21201 = state_20892__$1;
(statearr_21005_21201[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (125))){
var inst_20479 = (state_20892[(42)]);
var inst_20509 = (state_20892[(16)]);
var inst_20510 = (state_20892[(17)]);
var inst_20464 = (state_20892[(35)]);
var inst_20506 = (state_20892[(13)]);
var inst_20494 = (state_20892[(14)]);
var inst_20505 = (state_20892[(18)]);
var inst_20511 = (state_20892[(19)]);
var inst_20508 = (state_20892[(20)]);
var inst_20512 = (state_20892[(21)]);
var inst_20507 = (state_20892[(15)]);
var inst_20841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20842 = (function (){var map__20460 = inst_20506;
var p = inst_20512;
var pred_spec__$1 = inst_20479;
var orderBy = inst_20510;
var multi_QMARK_ = inst_20507;
var limit = inst_20509;
var offset = inst_20511;
var k = inst_20505;
var compact_QMARK_ = inst_20464;
var pred_spec_SINGLEQUOTE_ = inst_20494;
var ref_QMARK_ = inst_20508;
return (function (p1__20451_SHARP_){
return fluree.db.flake.o(p1__20451_SHARP_);
});
})();
var inst_20843 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_20842,flakes);
var inst_20844 = [inst_20843,offset_map];
var inst_20845 = (new cljs.core.PersistentVector(null,2,(5),inst_20841,inst_20844,null));
var state_20892__$1 = state_20892;
var statearr_21006_21202 = state_20892__$1;
(statearr_21006_21202[(2)] = inst_20845);

(statearr_21006_21202[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (17))){
var inst_20494 = (state_20892[(14)]);
var inst_20495 = (state_20892[(52)]);
var inst_20494__$1 = (state_20892[(2)]);
var inst_20495__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_20494__$1);
var state_20892__$1 = (function (){var statearr_21007 = state_20892;
(statearr_21007[(14)] = inst_20494__$1);

(statearr_21007[(52)] = inst_20495__$1);

return statearr_21007;
})();
if(cljs.core.truth_(inst_20495__$1)){
var statearr_21008_21203 = state_20892__$1;
(statearr_21008_21203[(1)] = (18));

} else {
var statearr_21009_21204 = state_20892__$1;
(statearr_21009_21204[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (3))){
var inst_20890 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20892__$1,inst_20890);
} else {
if((state_val_20893 === (12))){
var inst_20479 = (state_20892[(42)]);
var inst_20484 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20479,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_20892__$1 = state_20892;
var statearr_21010_21205 = state_20892__$1;
(statearr_21010_21205[(2)] = inst_20484);

(statearr_21010_21205[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (2))){
var inst_20465 = (state_20892[(11)]);
var _ = (function (){var statearr_21011 = state_20892;
(statearr_21011[(4)] = cljs.core.cons((5),(state_20892[(4)])));

return statearr_21011;
})();
var inst_20464 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_20465__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_20892__$1 = (function (){var statearr_21012 = state_20892;
(statearr_21012[(35)] = inst_20464);

(statearr_21012[(11)] = inst_20465__$1);

return statearr_21012;
})();
if(cljs.core.truth_(inst_20465__$1)){
var statearr_21013_21206 = state_20892__$1;
(statearr_21013_21206[(1)] = (6));

} else {
var statearr_21014_21207 = state_20892__$1;
(statearr_21014_21207[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (66))){
var inst_20577 = (state_20892[(53)]);
var inst_20608 = (state_20892[(7)]);
var inst_20611 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_20577,inst_20608) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_20577,inst_20608));
var state_20892__$1 = state_20892;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20892__$1,(69),inst_20611);
} else {
if((state_val_20893 === (107))){
var inst_20742 = (state_20892[(27)]);
var inst_20762 = cljs.core.count(inst_20742);
var inst_20763 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_20762);
var state_20892__$1 = state_20892;
var statearr_21015_21208 = state_20892__$1;
(statearr_21015_21208[(2)] = inst_20763);

(statearr_21015_21208[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (23))){
var inst_20503 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_21016_21209 = state_20892__$1;
(statearr_21016_21209[(2)] = inst_20503);

(statearr_21016_21209[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (47))){
var inst_20550 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_21017_21210 = state_20892__$1;
(statearr_21017_21210[(2)] = inst_20550);

(statearr_21017_21210[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (35))){
var inst_20861 = (state_20892[(50)]);
var inst_20860 = (state_20892[(2)]);
var inst_20861__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20860,(0),null);
var inst_20862 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20860,(1),null);
var inst_20863 = cljs.core.empty_QMARK_(inst_20861__$1);
var state_20892__$1 = (function (){var statearr_21018 = state_20892;
(statearr_21018[(10)] = inst_20862);

(statearr_21018[(50)] = inst_20861__$1);

return statearr_21018;
})();
if(inst_20863){
var statearr_21019_21211 = state_20892__$1;
(statearr_21019_21211[(1)] = (128));

} else {
var statearr_21020_21212 = state_20892__$1;
(statearr_21020_21212[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (127))){
var inst_20848 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_21021_21213 = state_20892__$1;
(statearr_21021_21213[(2)] = inst_20848);

(statearr_21021_21213[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (82))){
var inst_20655 = (state_20892[(30)]);
var state_20892__$1 = state_20892;
var statearr_21022_21214 = state_20892__$1;
(statearr_21022_21214[(2)] = inst_20655);

(statearr_21022_21214[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (76))){
var inst_20641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20649 = flakes;
var inst_20650 = cljs.core.seq(inst_20649);
var inst_20651 = cljs.core.first(inst_20650);
var inst_20652 = cljs.core.next(inst_20650);
var inst_20653 = cljs.core.PersistentVector.EMPTY;
var inst_20654 = inst_20649;
var inst_20655 = inst_20653;
var state_20892__$1 = (function (){var statearr_21023 = state_20892;
(statearr_21023[(45)] = inst_20654);

(statearr_21023[(30)] = inst_20655);

(statearr_21023[(54)] = inst_20641);

(statearr_21023[(55)] = inst_20651);

(statearr_21023[(56)] = inst_20652);

return statearr_21023;
})();
var statearr_21024_21215 = state_20892__$1;
(statearr_21024_21215[(2)] = null);

(statearr_21024_21215[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (97))){
var inst_20728 = (state_20892[(40)]);
var inst_20721 = (state_20892[(49)]);
var inst_20727 = cljs.core.seq(inst_20721);
var inst_20728__$1 = cljs.core.first(inst_20727);
var inst_20729 = cljs.core.next(inst_20727);
var state_20892__$1 = (function (){var statearr_21025 = state_20892;
(statearr_21025[(40)] = inst_20728__$1);

(statearr_21025[(46)] = inst_20729);

return statearr_21025;
})();
if(cljs.core.truth_(inst_20728__$1)){
var statearr_21026_21216 = state_20892__$1;
(statearr_21026_21216[(1)] = (99));

} else {
var statearr_21027_21217 = state_20892__$1;
(statearr_21027_21217[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (19))){
var inst_20494 = (state_20892[(14)]);
var inst_20498 = (state_20892[(41)]);
var inst_20498__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_20494);
var state_20892__$1 = (function (){var statearr_21028 = state_20892;
(statearr_21028[(41)] = inst_20498__$1);

return statearr_21028;
})();
if(cljs.core.truth_(inst_20498__$1)){
var statearr_21029_21218 = state_20892__$1;
(statearr_21029_21218[(1)] = (21));

} else {
var statearr_21030_21219 = state_20892__$1;
(statearr_21030_21219[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (57))){
var inst_20494 = (state_20892[(14)]);
var inst_20574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20575 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_20576 = (new cljs.core.PersistentVector(null,3,(5),inst_20574,inst_20575,null));
var inst_20577 = cljs.core.select_keys(inst_20494,inst_20576);
var inst_20578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20586 = flakes;
var inst_20587 = cljs.core.seq(inst_20586);
var inst_20588 = cljs.core.first(inst_20587);
var inst_20589 = cljs.core.next(inst_20587);
var inst_20590 = cljs.core.PersistentVector.EMPTY;
var inst_20591 = inst_20586;
var inst_20592 = inst_20590;
var state_20892__$1 = (function (){var statearr_21031 = state_20892;
(statearr_21031[(9)] = inst_20592);

(statearr_21031[(57)] = inst_20589);

(statearr_21031[(24)] = inst_20591);

(statearr_21031[(58)] = inst_20588);

(statearr_21031[(51)] = inst_20578);

(statearr_21031[(53)] = inst_20577);

return statearr_21031;
})();
var statearr_21032_21220 = state_20892__$1;
(statearr_21032_21220[(2)] = null);

(statearr_21032_21220[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (68))){
var inst_20617 = (state_20892[(2)]);
var state_20892__$1 = (function (){var statearr_21033 = state_20892;
(statearr_21033[(22)] = inst_20617);

return statearr_21033;
})();
if(cljs.core.truth_(fuel)){
var statearr_21034_21221 = state_20892__$1;
(statearr_21034_21221[(1)] = (70));

} else {
var statearr_21035_21222 = state_20892__$1;
(statearr_21035_21222[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (11))){
var inst_20479 = (state_20892[(42)]);
var inst_20479__$1 = (state_20892[(2)]);
var inst_20481 = cljs.core.contains_QMARK_(inst_20479__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_20482 = (!(inst_20481));
var state_20892__$1 = (function (){var statearr_21036 = state_20892;
(statearr_21036[(42)] = inst_20479__$1);

return statearr_21036;
})();
if(inst_20482){
var statearr_21037_21223 = state_20892__$1;
(statearr_21037_21223[(1)] = (12));

} else {
var statearr_21038_21224 = state_20892__$1;
(statearr_21038_21224[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (115))){
var inst_20838 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_21040_21225 = state_20892__$1;
(statearr_21040_21225[(2)] = inst_20838);

(statearr_21040_21225[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (9))){
var inst_20473 = cljs.core.first(flakes);
var inst_20474 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_20473);
var inst_20475 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_20476 = fluree.db.query.fql_resp.wildcard_pred_spec(db,cache,inst_20474,inst_20475);
var state_20892__$1 = state_20892;
var statearr_21041_21226 = state_20892__$1;
(statearr_21041_21226[(2)] = inst_20476);

(statearr_21041_21226[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (5))){
var _ = (function (){var statearr_21042 = state_20892;
(statearr_21042[(4)] = cljs.core.rest((state_20892[(4)])));

return statearr_21042;
})();
var state_20892__$1 = state_20892;
var ex21039 = (state_20892__$1[(2)]);
var statearr_21043_21227 = state_20892__$1;
(statearr_21043_21227[(5)] = ex21039);


if((ex21039 instanceof Error)){
var statearr_21044_21228 = state_20892__$1;
(statearr_21044_21228[(1)] = (4));

(statearr_21044_21228[(5)] = null);

} else {
throw ex21039;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (112))){
var inst_20850 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_21045_21229 = state_20892__$1;
(statearr_21045_21229[(2)] = inst_20850);

(statearr_21045_21229[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (83))){
var inst_20695 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_21046_21230 = state_20892__$1;
(statearr_21046_21230[(2)] = inst_20695);

(statearr_21046_21230[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (14))){
var inst_20479 = (state_20892[(42)]);
var inst_20487 = (state_20892[(2)]);
var inst_20488 = cljs.core.contains_QMARK_(inst_20479,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_20489 = (!(inst_20488));
var state_20892__$1 = (function (){var statearr_21047 = state_20892;
(statearr_21047[(36)] = inst_20487);

return statearr_21047;
})();
if(inst_20489){
var statearr_21048_21231 = state_20892__$1;
(statearr_21048_21231[(1)] = (15));

} else {
var statearr_21049_21232 = state_20892__$1;
(statearr_21049_21232[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (45))){
var inst_20509 = (state_20892[(16)]);
var inst_20505 = (state_20892[(18)]);
var inst_20545 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_20505);
var inst_20546 = cljs.core.count(inst_20545);
var inst_20547 = (inst_20546 >= inst_20509);
var state_20892__$1 = state_20892;
var statearr_21050_21233 = state_20892__$1;
(statearr_21050_21233[(2)] = inst_20547);

(statearr_21050_21233[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (53))){
var inst_20572 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
if(cljs.core.truth_(inst_20572)){
var statearr_21051_21234 = state_20892__$1;
(statearr_21051_21234[(1)] = (57));

} else {
var statearr_21052_21235 = state_20892__$1;
(statearr_21052_21235[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (78))){
var inst_20854 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_21053_21236 = state_20892__$1;
(statearr_21053_21236[(2)] = inst_20854);

(statearr_21053_21236[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (132))){
var state_20892__$1 = state_20892;
var statearr_21055_21237 = state_20892__$1;
(statearr_21055_21237[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (26))){
var inst_20527 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
if(cljs.core.truth_(inst_20527)){
var statearr_21057_21238 = state_20892__$1;
(statearr_21057_21238[(1)] = (33));

} else {
var statearr_21058_21239 = state_20892__$1;
(statearr_21058_21239[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (123))){
var inst_20807 = (state_20892[(39)]);
var inst_20800 = (state_20892[(33)]);
var tmp21054 = inst_20800;
var inst_20799 = inst_20807;
var inst_20800__$1 = tmp21054;
var state_20892__$1 = (function (){var statearr_21059 = state_20892;
(statearr_21059[(33)] = inst_20800__$1);

(statearr_21059[(38)] = inst_20799);

return statearr_21059;
})();
var statearr_21060_21240 = state_20892__$1;
(statearr_21060_21240[(2)] = null);

(statearr_21060_21240[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (16))){
var inst_20487 = (state_20892[(36)]);
var state_20892__$1 = state_20892;
var statearr_21061_21241 = state_20892__$1;
(statearr_21061_21241[(2)] = inst_20487);

(statearr_21061_21241[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (133))){
var inst_20885 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_21062_21242 = state_20892__$1;
(statearr_21062_21242[(2)] = inst_20885);

(statearr_21062_21242[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (81))){
var inst_20670 = (state_20892[(59)]);
var inst_20494 = (state_20892[(14)]);
var inst_20661 = (state_20892[(28)]);
var inst_20664 = cljs.core.deref(cache);
var inst_20665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20666 = fluree.db.flake.o(inst_20661);
var inst_20667 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_20494);
var inst_20668 = [inst_20666,inst_20667];
var inst_20669 = (new cljs.core.PersistentVector(null,2,(5),inst_20665,inst_20668,null));
var inst_20670__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20664,inst_20669);
var state_20892__$1 = (function (){var statearr_21063 = state_20892;
(statearr_21063[(59)] = inst_20670__$1);

return statearr_21063;
})();
if(cljs.core.truth_(inst_20670__$1)){
var statearr_21064_21243 = state_20892__$1;
(statearr_21064_21243[(1)] = (84));

} else {
var statearr_21065_21244 = state_20892__$1;
(statearr_21065_21244[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (120))){
var inst_20834 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_21066_21245 = state_20892__$1;
(statearr_21066_21245[(2)] = inst_20834);

(statearr_21066_21245[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (79))){
var inst_20654 = (state_20892[(45)]);
var inst_20661 = (state_20892[(28)]);
var inst_20660 = cljs.core.seq(inst_20654);
var inst_20661__$1 = cljs.core.first(inst_20660);
var inst_20662 = cljs.core.next(inst_20660);
var state_20892__$1 = (function (){var statearr_21067 = state_20892;
(statearr_21067[(44)] = inst_20662);

(statearr_21067[(28)] = inst_20661__$1);

return statearr_21067;
})();
if(cljs.core.truth_(inst_20661__$1)){
var statearr_21068_21246 = state_20892__$1;
(statearr_21068_21246[(1)] = (81));

} else {
var statearr_21069_21247 = state_20892__$1;
(statearr_21069_21247[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (38))){
var inst_20529 = (state_20892[(43)]);
var inst_20537 = (state_20892[(2)]);
var inst_20538 = [null,inst_20537];
var inst_20539 = (new cljs.core.PersistentVector(null,2,(5),inst_20529,inst_20538,null));
var state_20892__$1 = state_20892;
var statearr_21070_21248 = state_20892__$1;
(statearr_21070_21248[(2)] = inst_20539);

(statearr_21070_21248[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (126))){
var state_20892__$1 = state_20892;
var statearr_21071_21249 = state_20892__$1;
(statearr_21071_21249[(2)] = null);

(statearr_21071_21249[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (98))){
var inst_20708 = (state_20892[(60)]);
var inst_20772 = (state_20892[(2)]);
var inst_20773 = [inst_20772,offset_map];
var inst_20774 = (new cljs.core.PersistentVector(null,2,(5),inst_20708,inst_20773,null));
var state_20892__$1 = state_20892;
var statearr_21072_21250 = state_20892__$1;
(statearr_21072_21250[(2)] = inst_20774);

(statearr_21072_21250[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (124))){
var inst_20828 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_21073_21251 = state_20892__$1;
(statearr_21073_21251[(2)] = inst_20828);

(statearr_21073_21251[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (87))){
var inst_20494 = (state_20892[(14)]);
var inst_20661 = (state_20892[(28)]);
var inst_20677 = (state_20892[(2)]);
var inst_20678 = fluree.db.util.async.throw_err(inst_20677);
var inst_20679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20680 = fluree.db.flake.o(inst_20661);
var inst_20681 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_20494);
var inst_20682 = [inst_20680,inst_20681];
var inst_20683 = (new cljs.core.PersistentVector(null,2,(5),inst_20679,inst_20682,null));
var inst_20684 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_20683,inst_20678);
var state_20892__$1 = (function (){var statearr_21074 = state_20892;
(statearr_21074[(61)] = inst_20684);

return statearr_21074;
})();
var statearr_21075_21252 = state_20892__$1;
(statearr_21075_21252[(2)] = inst_20678);

(statearr_21075_21252[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (30))){
var inst_20512 = (state_20892[(21)]);
var inst_20517 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_20512);
var inst_20518 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_20517);
var state_20892__$1 = state_20892;
var statearr_21076_21253 = state_20892__$1;
(statearr_21076_21253[(2)] = inst_20518);

(statearr_21076_21253[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (73))){
var inst_20592 = (state_20892[(9)]);
var inst_20617 = (state_20892[(22)]);
var inst_20626 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_20592,inst_20617);
var state_20892__$1 = state_20892;
var statearr_21077_21254 = state_20892__$1;
(statearr_21077_21254[(2)] = inst_20626);

(statearr_21077_21254[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (96))){
var inst_20852 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_21078_21255 = state_20892__$1;
(statearr_21078_21255[(2)] = inst_20852);

(statearr_21078_21255[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (10))){
var state_20892__$1 = state_20892;
var statearr_21079_21256 = state_20892__$1;
(statearr_21079_21256[(2)] = pred_spec);

(statearr_21079_21256[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (18))){
var inst_20495 = (state_20892[(52)]);
var state_20892__$1 = state_20892;
var statearr_21080_21257 = state_20892__$1;
(statearr_21080_21257[(2)] = inst_20495);

(statearr_21080_21257[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (105))){
var inst_20760 = (state_20892[(2)]);
var state_20892__$1 = (function (){var statearr_21081 = state_20892;
(statearr_21081[(47)] = inst_20760);

return statearr_21081;
})();
if(cljs.core.truth_(fuel)){
var statearr_21082_21258 = state_20892__$1;
(statearr_21082_21258[(1)] = (107));

} else {
var statearr_21083_21259 = state_20892__$1;
(statearr_21083_21259[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (52))){
var inst_20562 = (state_20892[(62)]);
var state_20892__$1 = state_20892;
var statearr_21084_21260 = state_20892__$1;
(statearr_21084_21260[(2)] = inst_20562);

(statearr_21084_21260[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (114))){
var inst_20794 = flakes;
var inst_20795 = cljs.core.seq(inst_20794);
var inst_20796 = cljs.core.first(inst_20795);
var inst_20797 = cljs.core.next(inst_20795);
var inst_20798 = cljs.core.PersistentVector.EMPTY;
var inst_20799 = inst_20794;
var inst_20800 = inst_20798;
var state_20892__$1 = (function (){var statearr_21085 = state_20892;
(statearr_21085[(63)] = inst_20796);

(statearr_21085[(33)] = inst_20800);

(statearr_21085[(38)] = inst_20799);

(statearr_21085[(64)] = inst_20797);

return statearr_21085;
})();
var statearr_21086_21261 = state_20892__$1;
(statearr_21086_21261[(2)] = null);

(statearr_21086_21261[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (67))){
var state_20892__$1 = state_20892;
var statearr_21087_21262 = state_20892__$1;
(statearr_21087_21262[(2)] = null);

(statearr_21087_21262[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (71))){
var state_20892__$1 = state_20892;
var statearr_21088_21263 = state_20892__$1;
(statearr_21088_21263[(2)] = null);

(statearr_21088_21263[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (42))){
var inst_20509 = (state_20892[(16)]);
var state_20892__$1 = state_20892;
if(cljs.core.truth_(inst_20509)){
var statearr_21089_21264 = state_20892__$1;
(statearr_21089_21264[(1)] = (45));

} else {
var statearr_21090_21265 = state_20892__$1;
(statearr_21090_21265[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (80))){
var inst_20641 = (state_20892[(54)]);
var inst_20697 = (state_20892[(2)]);
var inst_20698 = [inst_20697,offset_map];
var inst_20699 = (new cljs.core.PersistentVector(null,2,(5),inst_20641,inst_20698,null));
var state_20892__$1 = state_20892;
var statearr_21091_21266 = state_20892__$1;
(statearr_21091_21266[(2)] = inst_20699);

(statearr_21091_21266[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (37))){
var inst_20511 = (state_20892[(19)]);
var inst_20512 = (state_20892[(21)]);
var inst_20534 = (inst_20511 - (1));
var inst_20535 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_20512,inst_20534);
var state_20892__$1 = state_20892;
var statearr_21092_21267 = state_20892__$1;
(statearr_21092_21267[(2)] = inst_20535);

(statearr_21092_21267[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (63))){
var inst_20592 = (state_20892[(9)]);
var state_20892__$1 = state_20892;
var statearr_21093_21268 = state_20892__$1;
(statearr_21093_21268[(2)] = inst_20592);

(statearr_21093_21268[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (94))){
var inst_20708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20716 = flakes;
var inst_20717 = cljs.core.seq(inst_20716);
var inst_20718 = cljs.core.first(inst_20717);
var inst_20719 = cljs.core.next(inst_20717);
var inst_20720 = cljs.core.PersistentVector.EMPTY;
var inst_20721 = inst_20716;
var inst_20722 = inst_20720;
var state_20892__$1 = (function (){var statearr_21094 = state_20892;
(statearr_21094[(60)] = inst_20708);

(statearr_21094[(49)] = inst_20721);

(statearr_21094[(32)] = inst_20722);

(statearr_21094[(65)] = inst_20718);

(statearr_21094[(66)] = inst_20719);

return statearr_21094;
})();
var statearr_21095_21269 = state_20892__$1;
(statearr_21095_21269[(2)] = null);

(statearr_21095_21269[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (8))){
var inst_20471 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
if(cljs.core.truth_(inst_20471)){
var statearr_21096_21270 = state_20892__$1;
(statearr_21096_21270[(1)] = (9));

} else {
var statearr_21097_21271 = state_20892__$1;
(statearr_21097_21271[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (49))){
var inst_20562 = (state_20892[(62)]);
var inst_20562__$1 = cljs.core.not(recur_QMARK_);
var state_20892__$1 = (function (){var statearr_21098 = state_20892;
(statearr_21098[(62)] = inst_20562__$1);

return statearr_21098;
})();
if(inst_20562__$1){
var statearr_21099_21272 = state_20892__$1;
(statearr_21099_21272[(1)] = (51));

} else {
var statearr_21100_21273 = state_20892__$1;
(statearr_21100_21273[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (84))){
var inst_20670 = (state_20892[(59)]);
var state_20892__$1 = state_20892;
var statearr_21101_21274 = state_20892__$1;
(statearr_21101_21274[(2)] = inst_20670);

(statearr_21101_21274[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$state_machine__2727__auto____0 = (function (){
var statearr_21102 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21102[(0)] = fluree$db$query$fql_resp$state_machine__2727__auto__);

(statearr_21102[(1)] = (1));

return statearr_21102;
});
var fluree$db$query$fql_resp$state_machine__2727__auto____1 = (function (state_20892){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20892);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21103){var ex__2730__auto__ = e21103;
var statearr_21104_21275 = state_20892;
(statearr_21104_21275[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20892[(4)]))){
var statearr_21105_21276 = state_20892;
(statearr_21105_21276[(1)] = cljs.core.first((state_20892[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21277 = state_20892;
state_20892 = G__21277;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$state_machine__2727__auto__ = function(state_20892){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$state_machine__2727__auto____1.call(this,state_20892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$state_machine__2727__auto____0;
fluree$db$query$fql_resp$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$state_machine__2727__auto____1;
return fluree$db$query$fql_resp$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21106 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21106[(6)] = c__2749__auto__);

return statearr_21106;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql_resp.add_pred.cljs$lang$maxFixedArity = 10);

fluree.db.query.fql_resp.compare_fn = (function fluree$db$query$fql_resp$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql_resp.sort_offset_and_limit_res = (function fluree$db$query$fql_resp$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__21279 = res;
var G__21279__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__21278_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__21278_SHARP_,sortPred);
}),fluree.db.query.fql_resp.compare_fn,G__21279):G__21279);
var G__21279__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__21279__$1):G__21279__$1);
var G__21279__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__21279__$2):G__21279__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__21279__$3);
} else {
return G__21279__$3;
}
} else {
return res;
}
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql_resp.flakes__GT_res = (function fluree$db$query$fql_resp$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21460){
var state_val_21461 = (state_21460[(1)]);
if((state_val_21461 === (7))){
var state_21460__$1 = state_21460;
var statearr_21462_21548 = state_21460__$1;
(statearr_21462_21548[(2)] = null);

(statearr_21462_21548[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (20))){
var inst_21318 = cljs.core.PersistentHashMap.EMPTY;
var state_21460__$1 = state_21460;
var statearr_21463_21549 = state_21460__$1;
(statearr_21463_21549[(2)] = inst_21318);

(statearr_21463_21549[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (27))){
var inst_21320 = (state_21460[(7)]);
var inst_21336 = (state_21460[(8)]);
var inst_21300 = (state_21460[(9)]);
var inst_21306 = (state_21460[(10)]);
var inst_21439 = (state_21460[(2)]);
var inst_21440 = (function (){var top_level_subject = inst_21300;
var select_spec = inst_21306;
var base_acc = inst_21320;
var acc_PLUS_refs = inst_21336;
var result = inst_21439;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4253__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_21441 = cljs.core.PersistentVector.EMPTY;
var inst_21442 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_21306);
var inst_21443 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_21442);
var inst_21444 = cljs.core.vals(inst_21443);
var inst_21445 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_21306);
var inst_21446 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_21445);
var inst_21447 = cljs.core.vals(inst_21446);
var inst_21448 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_21444,inst_21447);
var inst_21449 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_21440,inst_21441,inst_21448);
var inst_21451 = (function (){var top_level_subject = inst_21300;
var select_spec = inst_21306;
var base_acc = inst_21320;
var acc_PLUS_refs = inst_21336;
var result = inst_21439;
var sort_preds = inst_21449;
return (function (acc,p__21450){
var vec__21464 = p__21450;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21464,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21464,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21464,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21464,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql_resp.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_21452 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_21451,inst_21439,inst_21449);
var state_21460__$1 = state_21460;
var statearr_21467_21550 = state_21460__$1;
(statearr_21467_21550[(2)] = inst_21452);

(statearr_21467_21550[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (1))){
var state_21460__$1 = state_21460;
var statearr_21468_21551 = state_21460__$1;
(statearr_21468_21551[(2)] = null);

(statearr_21468_21551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (24))){
var inst_21336 = (state_21460[(8)]);
var inst_21336__$1 = (state_21460[(2)]);
var inst_21337 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_21338 = cljs.core.PersistentHashMap.EMPTY;
var inst_21339 = inst_21337;
var inst_21340 = inst_21336__$1;
var inst_21341 = inst_21338;
var state_21460__$1 = (function (){var statearr_21469 = state_21460;
(statearr_21469[(11)] = inst_21339);

(statearr_21469[(8)] = inst_21336__$1);

(statearr_21469[(12)] = inst_21340);

(statearr_21469[(13)] = inst_21341);

return statearr_21469;
})();
var statearr_21470_21552 = state_21460__$1;
(statearr_21470_21552[(2)] = null);

(statearr_21470_21552[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (39))){
var inst_21349 = (state_21460[(14)]);
var inst_21356 = (state_21460[(15)]);
var inst_21340 = (state_21460[(12)]);
var inst_21306 = (state_21460[(10)]);
var inst_21385 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21386 = fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_21340,inst_21306,inst_21349,inst_21356,false);
var state_21460__$1 = (function (){var statearr_21471 = state_21460;
(statearr_21471[(16)] = inst_21385);

return statearr_21471;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21460__$1,(42),inst_21386);
} else {
if((state_val_21461 === (46))){
var inst_21349 = (state_21460[(14)]);
var inst_21339 = (state_21460[(11)]);
var inst_21341 = (state_21460[(13)]);
var inst_21403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21404 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_21405 = cljs.core.first(inst_21349);
var inst_21406 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_21405);
var inst_21407 = [inst_21406];
var inst_21408 = cljs.core.PersistentHashMap.fromArrays(inst_21404,inst_21407);
var inst_21409 = cljs.core.rest(inst_21339);
var inst_21410 = [inst_21408,inst_21409,inst_21341];
var inst_21411 = (new cljs.core.PersistentVector(null,3,(5),inst_21403,inst_21410,null));
var state_21460__$1 = state_21460;
var statearr_21472_21553 = state_21460__$1;
(statearr_21472_21553[(2)] = inst_21411);

(statearr_21472_21553[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (4))){
var inst_21280 = (state_21460[(2)]);
var state_21460__$1 = state_21460;
var statearr_21473_21554 = state_21460__$1;
(statearr_21473_21554[(2)] = inst_21280);

(statearr_21473_21554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (15))){
var inst_21307 = (state_21460[(17)]);
var inst_21306 = (state_21460[(10)]);
var inst_21306__$1 = (state_21460[(2)]);
var inst_21307__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_21306__$1);
var state_21460__$1 = (function (){var statearr_21474 = state_21460;
(statearr_21474[(17)] = inst_21307__$1);

(statearr_21474[(10)] = inst_21306__$1);

return statearr_21474;
})();
if(cljs.core.truth_(inst_21307__$1)){
var statearr_21475_21555 = state_21460__$1;
(statearr_21475_21555[(1)] = (16));

} else {
var statearr_21476_21556 = state_21460__$1;
(statearr_21476_21556[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (48))){
var inst_21422 = (state_21460[(2)]);
var state_21460__$1 = state_21460;
var statearr_21477_21557 = state_21460__$1;
(statearr_21477_21557[(2)] = inst_21422);

(statearr_21477_21557[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (50))){
var state_21460__$1 = state_21460;
var statearr_21478_21558 = state_21460__$1;
(statearr_21478_21558[(2)] = null);

(statearr_21478_21558[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (21))){
var inst_21306 = (state_21460[(10)]);
var inst_21320 = (state_21460[(2)]);
var inst_21321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21322 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_21323 = (new cljs.core.PersistentVector(null,2,(5),inst_21321,inst_21322,null));
var inst_21324 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_21306,inst_21323);
var state_21460__$1 = (function (){var statearr_21479 = state_21460;
(statearr_21479[(7)] = inst_21320);

return statearr_21479;
})();
if(cljs.core.truth_(inst_21324)){
var statearr_21480_21559 = state_21460__$1;
(statearr_21480_21559[(1)] = (22));

} else {
var statearr_21481_21560 = state_21460__$1;
(statearr_21481_21560[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (31))){
var inst_21349 = (state_21460[(14)]);
var inst_21340 = (state_21460[(12)]);
var inst_21355 = (state_21460[(18)]);
var inst_21359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21360 = fluree.db.query.fql_resp.flake__GT_recur(db,inst_21349,inst_21355,inst_21340,fuel,max_fuel,cache);
var state_21460__$1 = (function (){var statearr_21482 = state_21460;
(statearr_21482[(19)] = inst_21359);

return statearr_21482;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21460__$1,(34),inst_21360);
} else {
if((state_val_21461 === (32))){
var inst_21355 = (state_21460[(18)]);
var state_21460__$1 = state_21460;
if(cljs.core.truth_(inst_21355)){
var statearr_21483_21561 = state_21460__$1;
(statearr_21483_21561[(1)] = (35));

} else {
var statearr_21484_21562 = state_21460__$1;
(statearr_21484_21562[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (40))){
var inst_21396 = (state_21460[(20)]);
var inst_21306 = (state_21460[(10)]);
var inst_21395 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_21306);
var inst_21396__$1 = cljs.core.empty_QMARK_(inst_21395);
var state_21460__$1 = (function (){var statearr_21485 = state_21460;
(statearr_21485[(20)] = inst_21396__$1);

return statearr_21485;
})();
if(inst_21396__$1){
var statearr_21486_21563 = state_21460__$1;
(statearr_21486_21563[(1)] = (43));

} else {
var statearr_21487_21564 = state_21460__$1;
(statearr_21487_21564[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (33))){
var inst_21349 = (state_21460[(14)]);
var inst_21428 = (state_21460[(2)]);
var inst_21429 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21428,(0),null);
var inst_21430 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21428,(1),null);
var inst_21431 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21428,(2),null);
var inst_21432 = cljs.core.first(inst_21349);
var inst_21433 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_21432);
var inst_21434 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21429,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_21433);
var inst_21339 = inst_21430;
var inst_21340 = inst_21434;
var inst_21341 = inst_21431;
var state_21460__$1 = (function (){var statearr_21488 = state_21460;
(statearr_21488[(11)] = inst_21339);

(statearr_21488[(12)] = inst_21340);

(statearr_21488[(13)] = inst_21341);

return statearr_21488;
})();
var statearr_21489_21565 = state_21460__$1;
(statearr_21489_21565[(2)] = null);

(statearr_21489_21565[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (13))){
var inst_21300 = (state_21460[(9)]);
var inst_21303 = fluree.db.query.fql_resp.full_select_spec(db,cache,base_select_spec,inst_21300);
var state_21460__$1 = state_21460;
var statearr_21490_21566 = state_21460__$1;
(statearr_21490_21566[(2)] = inst_21303);

(statearr_21490_21566[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (22))){
var inst_21306 = (state_21460[(10)]);
var inst_21326 = cljs.core.first(flakes);
var inst_21327 = fluree.db.flake.s(inst_21326);
var inst_21328 = fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs(inst_21306);
var inst_21329 = fluree.db.query.fql_resp.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_21327,inst_21328);
var state_21460__$1 = state_21460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21460__$1,(25),inst_21329);
} else {
if((state_val_21461 === (36))){
var inst_21306 = (state_21460[(10)]);
var inst_21383 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_21306);
var state_21460__$1 = state_21460;
if(cljs.core.truth_(inst_21383)){
var statearr_21491_21567 = state_21460__$1;
(statearr_21491_21567[(1)] = (39));

} else {
var statearr_21492_21568 = state_21460__$1;
(statearr_21492_21568[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (41))){
var inst_21424 = (state_21460[(2)]);
var state_21460__$1 = state_21460;
var statearr_21493_21569 = state_21460__$1;
(statearr_21493_21569[(2)] = inst_21424);

(statearr_21493_21569[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (43))){
var inst_21306 = (state_21460[(10)]);
var inst_21398 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_21306);
var state_21460__$1 = state_21460;
var statearr_21494_21570 = state_21460__$1;
(statearr_21494_21570[(2)] = inst_21398);

(statearr_21494_21570[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (29))){
var inst_21349 = (state_21460[(14)]);
var inst_21339 = (state_21460[(11)]);
var inst_21306 = (state_21460[(10)]);
var inst_21355 = (state_21460[(18)]);
var inst_21349__$1 = cljs.core.first(inst_21339);
var inst_21350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21351 = cljs.core.first(inst_21349__$1);
var inst_21352 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_21351);
var inst_21353 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_21352];
var inst_21354 = (new cljs.core.PersistentVector(null,3,(5),inst_21350,inst_21353,null));
var inst_21355__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_21306,inst_21354);
var inst_21356 = fluree.db.query.fql_resp.component_follow_QMARK_(inst_21355__$1,inst_21306);
var inst_21357 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_21355__$1);
var state_21460__$1 = (function (){var statearr_21495 = state_21460;
(statearr_21495[(14)] = inst_21349__$1);

(statearr_21495[(15)] = inst_21356);

(statearr_21495[(18)] = inst_21355__$1);

return statearr_21495;
})();
if(cljs.core.truth_(inst_21357)){
var statearr_21496_21571 = state_21460__$1;
(statearr_21496_21571[(1)] = (31));

} else {
var statearr_21497_21572 = state_21460__$1;
(statearr_21497_21572[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (44))){
var inst_21396 = (state_21460[(20)]);
var state_21460__$1 = state_21460;
var statearr_21498_21573 = state_21460__$1;
(statearr_21498_21573[(2)] = inst_21396);

(statearr_21498_21573[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (6))){
var state_21460__$1 = state_21460;
var statearr_21499_21574 = state_21460__$1;
(statearr_21499_21574[(2)] = null);

(statearr_21499_21574[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (28))){
var inst_21340 = (state_21460[(12)]);
var state_21460__$1 = state_21460;
var statearr_21500_21575 = state_21460__$1;
(statearr_21500_21575[(2)] = inst_21340);

(statearr_21500_21575[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (51))){
var inst_21420 = (state_21460[(2)]);
var state_21460__$1 = state_21460;
var statearr_21501_21576 = state_21460__$1;
(statearr_21501_21576[(2)] = inst_21420);

(statearr_21501_21576[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (25))){
var inst_21320 = (state_21460[(7)]);
var inst_21331 = (state_21460[(2)]);
var inst_21332 = fluree.db.util.async.throw_err(inst_21331);
var inst_21333 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_21320,inst_21332], 0));
var state_21460__$1 = state_21460;
var statearr_21502_21577 = state_21460__$1;
(statearr_21502_21577[(2)] = inst_21333);

(statearr_21502_21577[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (34))){
var inst_21359 = (state_21460[(19)]);
var inst_21339 = (state_21460[(11)]);
var inst_21341 = (state_21460[(13)]);
var inst_21362 = (state_21460[(2)]);
var inst_21363 = fluree.db.util.async.throw_err(inst_21362);
var inst_21364 = cljs.core.rest(inst_21339);
var inst_21365 = [inst_21363,inst_21364,inst_21341];
var inst_21366 = (new cljs.core.PersistentVector(null,3,(5),inst_21359,inst_21365,null));
var state_21460__$1 = state_21460;
var statearr_21503_21578 = state_21460__$1;
(statearr_21503_21578[(2)] = inst_21366);

(statearr_21503_21578[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (17))){
var inst_21306 = (state_21460[(10)]);
var inst_21310 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_21306);
var state_21460__$1 = state_21460;
var statearr_21505_21579 = state_21460__$1;
(statearr_21505_21579[(2)] = inst_21310);

(statearr_21505_21579[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (3))){
var inst_21458 = (state_21460[(2)]);
var state_21460__$1 = state_21460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21460__$1,inst_21458);
} else {
if((state_val_21461 === (12))){
var _ = (function (){var statearr_21506 = state_21460;
(statearr_21506[(4)] = cljs.core.rest((state_21460[(4)])));

return statearr_21506;
})();
var state_21460__$1 = state_21460;
var ex21504 = (state_21460__$1[(2)]);
var statearr_21507_21580 = state_21460__$1;
(statearr_21507_21580[(5)] = ex21504);


var statearr_21508_21581 = state_21460__$1;
(statearr_21508_21581[(1)] = (11));

(statearr_21508_21581[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (2))){
var _ = (function (){var statearr_21509 = state_21460;
(statearr_21509[(4)] = cljs.core.cons((5),(state_21460[(4)])));

return statearr_21509;
})();
var inst_21286 = cljs.core.not_empty(flakes);
var state_21460__$1 = state_21460;
if(cljs.core.truth_(inst_21286)){
var statearr_21510_21582 = state_21460__$1;
(statearr_21510_21582[(1)] = (6));

} else {
var statearr_21511_21583 = state_21460__$1;
(statearr_21511_21583[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (23))){
var inst_21320 = (state_21460[(7)]);
var state_21460__$1 = state_21460;
var statearr_21512_21584 = state_21460__$1;
(statearr_21512_21584[(2)] = inst_21320);

(statearr_21512_21584[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (47))){
var state_21460__$1 = state_21460;
var statearr_21513_21585 = state_21460__$1;
(statearr_21513_21585[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (35))){
var inst_21349 = (state_21460[(14)]);
var inst_21356 = (state_21460[(15)]);
var inst_21340 = (state_21460[(12)]);
var inst_21341 = (state_21460[(13)]);
var inst_21355 = (state_21460[(18)]);
var inst_21372 = fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_21340,inst_21355,inst_21349,inst_21356,false,inst_21341);
var state_21460__$1 = state_21460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21460__$1,(38),inst_21372);
} else {
if((state_val_21461 === (19))){
var inst_21300 = (state_21460[(9)]);
var inst_21314 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_21315 = [inst_21300];
var inst_21316 = cljs.core.PersistentHashMap.fromArrays(inst_21314,inst_21315);
var state_21460__$1 = state_21460;
var statearr_21515_21586 = state_21460__$1;
(statearr_21515_21586[(2)] = inst_21316);

(statearr_21515_21586[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (11))){
var inst_21288 = (state_21460[(2)]);
var inst_21289 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1(inst_21288) : fluree.db.util.log.error.call(null,inst_21288));
var inst_21290 = (function(){throw inst_21288})();
var state_21460__$1 = (function (){var statearr_21517 = state_21460;
(statearr_21517[(21)] = inst_21289);

return statearr_21517;
})();
var statearr_21518_21587 = state_21460__$1;
(statearr_21518_21587[(2)] = inst_21290);

(statearr_21518_21587[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (9))){
var _ = (function (){var statearr_21519 = state_21460;
(statearr_21519[(4)] = cljs.core.cons((12),(state_21460[(4)])));

return statearr_21519;
})();
var inst_21296 = cljs.core.first(flakes);
var inst_21297 = fluree.db.flake.s(inst_21296);
var ___$1 = (function (){var statearr_21520 = state_21460;
(statearr_21520[(4)] = cljs.core.rest((state_21460[(4)])));

return statearr_21520;
})();
var state_21460__$1 = state_21460;
var statearr_21521_21588 = state_21460__$1;
(statearr_21521_21588[(2)] = inst_21297);

(statearr_21521_21588[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (5))){
var _ = (function (){var statearr_21522 = state_21460;
(statearr_21522[(4)] = cljs.core.rest((state_21460[(4)])));

return statearr_21522;
})();
var state_21460__$1 = state_21460;
var ex21516 = (state_21460__$1[(2)]);
var statearr_21523_21589 = state_21460__$1;
(statearr_21523_21589[(5)] = ex21516);


if((ex21516 instanceof Error)){
var statearr_21524_21590 = state_21460__$1;
(statearr_21524_21590[(1)] = (4));

(statearr_21524_21590[(5)] = null);

} else {
throw ex21516;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (14))){
var state_21460__$1 = state_21460;
var statearr_21525_21591 = state_21460__$1;
(statearr_21525_21591[(2)] = base_select_spec);

(statearr_21525_21591[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (45))){
var inst_21401 = (state_21460[(2)]);
var state_21460__$1 = state_21460;
if(cljs.core.truth_(inst_21401)){
var statearr_21526_21592 = state_21460__$1;
(statearr_21526_21592[(1)] = (46));

} else {
var statearr_21527_21593 = state_21460__$1;
(statearr_21527_21593[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (26))){
var inst_21339 = (state_21460[(11)]);
var inst_21343 = cljs.core.empty_QMARK_(inst_21339);
var state_21460__$1 = state_21460;
if(inst_21343){
var statearr_21528_21594 = state_21460__$1;
(statearr_21528_21594[(1)] = (28));

} else {
var statearr_21529_21595 = state_21460__$1;
(statearr_21529_21595[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (16))){
var inst_21307 = (state_21460[(17)]);
var state_21460__$1 = state_21460;
var statearr_21530_21596 = state_21460__$1;
(statearr_21530_21596[(2)] = inst_21307);

(statearr_21530_21596[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (38))){
var inst_21339 = (state_21460[(11)]);
var inst_21374 = (state_21460[(2)]);
var inst_21375 = fluree.db.util.async.throw_err(inst_21374);
var inst_21376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21375,(0),null);
var inst_21377 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21375,(1),null);
var inst_21378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21379 = cljs.core.rest(inst_21339);
var inst_21380 = [inst_21376,inst_21379,inst_21377];
var inst_21381 = (new cljs.core.PersistentVector(null,3,(5),inst_21378,inst_21380,null));
var state_21460__$1 = state_21460;
var statearr_21531_21597 = state_21460__$1;
(statearr_21531_21597[(2)] = inst_21381);

(statearr_21531_21597[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (30))){
var inst_21437 = (state_21460[(2)]);
var state_21460__$1 = state_21460;
var statearr_21532_21598 = state_21460__$1;
(statearr_21532_21598[(2)] = inst_21437);

(statearr_21532_21598[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (10))){
var inst_21300 = (state_21460[(2)]);
var inst_21301 = fluree.db.query.fql_resp.has_ns_lookups_QMARK_(base_select_spec);
var state_21460__$1 = (function (){var statearr_21533 = state_21460;
(statearr_21533[(9)] = inst_21300);

return statearr_21533;
})();
if(cljs.core.truth_(inst_21301)){
var statearr_21534_21599 = state_21460__$1;
(statearr_21534_21599[(1)] = (13));

} else {
var statearr_21535_21600 = state_21460__$1;
(statearr_21535_21600[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (18))){
var inst_21312 = (state_21460[(2)]);
var state_21460__$1 = state_21460;
if(cljs.core.truth_(inst_21312)){
var statearr_21536_21601 = state_21460__$1;
(statearr_21536_21601[(1)] = (19));

} else {
var statearr_21537_21602 = state_21460__$1;
(statearr_21537_21602[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (42))){
var inst_21339 = (state_21460[(11)]);
var inst_21385 = (state_21460[(16)]);
var inst_21341 = (state_21460[(13)]);
var inst_21388 = (state_21460[(2)]);
var inst_21389 = fluree.db.util.async.throw_err(inst_21388);
var inst_21390 = cljs.core.first(inst_21389);
var inst_21391 = cljs.core.rest(inst_21339);
var inst_21392 = [inst_21390,inst_21391,inst_21341];
var inst_21393 = (new cljs.core.PersistentVector(null,3,(5),inst_21385,inst_21392,null));
var state_21460__$1 = state_21460;
var statearr_21538_21603 = state_21460__$1;
(statearr_21538_21603[(2)] = inst_21393);

(statearr_21538_21603[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (37))){
var inst_21426 = (state_21460[(2)]);
var state_21460__$1 = state_21460;
var statearr_21539_21604 = state_21460__$1;
(statearr_21539_21604[(2)] = inst_21426);

(statearr_21539_21604[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (8))){
var inst_21455 = (state_21460[(2)]);
var _ = (function (){var statearr_21540 = state_21460;
(statearr_21540[(4)] = cljs.core.rest((state_21460[(4)])));

return statearr_21540;
})();
var state_21460__$1 = state_21460;
var statearr_21541_21605 = state_21460__$1;
(statearr_21541_21605[(2)] = inst_21455);

(statearr_21541_21605[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21461 === (49))){
var inst_21339 = (state_21460[(11)]);
var inst_21340 = (state_21460[(12)]);
var inst_21341 = (state_21460[(13)]);
var inst_21414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21415 = cljs.core.rest(inst_21339);
var inst_21416 = [inst_21340,inst_21415,inst_21341];
var inst_21417 = (new cljs.core.PersistentVector(null,3,(5),inst_21414,inst_21416,null));
var state_21460__$1 = state_21460;
var statearr_21542_21606 = state_21460__$1;
(statearr_21542_21606[(2)] = inst_21417);

(statearr_21542_21606[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0 = (function (){
var statearr_21543 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21543[(0)] = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__);

(statearr_21543[(1)] = (1));

return statearr_21543;
});
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1 = (function (state_21460){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21460);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21544){var ex__2730__auto__ = e21544;
var statearr_21545_21607 = state_21460;
(statearr_21545_21607[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21460[(4)]))){
var statearr_21546_21608 = state_21460;
(statearr_21546_21608[(1)] = cljs.core.first((state_21460[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21609 = state_21460;
state_21460 = G__21609;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__ = function(state_21460){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1.call(this,state_21460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21547 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21547[(6)] = c__2749__auto__);

return statearr_21547;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
