// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.index');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4253__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * If a predicate is provided as a string value, coerce to pid
 */
fluree.db.query.range.coerce_predicate = (function fluree$db$query$range$coerce_predicate(db,pred){
if(typeof pred === 'string'){
var or__4253__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),pred);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",pred].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return pred;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14218 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14218,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14218,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14218,(2),null);
var p4 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14218,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14218,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14218,(5),null);
var G__14221 = idx;
var G__14221__$1 = (((G__14221 instanceof cljs.core.Keyword))?G__14221.fqn:null);
switch (G__14221__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.query.range.coerce_predicate(db,p2),p3,p4,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate(db,p1),p3,p4,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate(db,p1),p2,p4,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate(db,p2),p1,p4,op,m], null);

break;
case "tspo":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate(db,p3),p4,p1,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14221__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(9007199254740991)], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
fluree.db.query.range.txn_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.txn_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14223 = idx;
var G__14223__$1 = (((G__14223 instanceof cljs.core.Keyword))?G__14223.fqn:null);
switch (G__14223__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
case "tspo":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14223__$1)].join('')));

}
});
/**
 * Biggest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14225 = idx;
var G__14225__$1 = (((G__14225 instanceof cljs.core.Keyword))?G__14225.fqn:null);
switch (G__14225__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
case "tspo":
return fluree.db.query.range.txn_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14225__$1)].join('')));

}
});
fluree.db.query.range.resolve_subid = (function fluree$db$query$range$resolve_subid(db,id){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if(cljs.core.not(id)){
cljs.core.async.close_BANG_(out);
} else {
if(fluree.db.util.core.pred_ident_QMARK_(id)){
cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,id),out);
} else {
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,id);
}
}

return out;
});
fluree.db.query.range.resolve_match_flake = (function fluree$db$query$range$resolve_match_flake(db,test,parts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14265){
var state_val_14266 = (state_14265[(1)]);
if((state_val_14266 === (7))){
var inst_14242 = (state_14265[(7)]);
var inst_14249 = (state_14265[(2)]);
var inst_14250 = fluree.db.util.async.throw_err(inst_14249);
var state_14265__$1 = (function (){var statearr_14267 = state_14265;
(statearr_14267[(8)] = inst_14250);

return statearr_14267;
})();
if(cljs.core.truth_(inst_14242)){
var statearr_14268_14292 = state_14265__$1;
(statearr_14268_14292[(1)] = (8));

} else {
var statearr_14269_14293 = state_14265__$1;
(statearr_14269_14293[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14266 === (1))){
var state_14265__$1 = state_14265;
var statearr_14270_14294 = state_14265__$1;
(statearr_14270_14294[(2)] = null);

(statearr_14270_14294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14266 === (4))){
var inst_14227 = (state_14265[(2)]);
var state_14265__$1 = state_14265;
var statearr_14271_14295 = state_14265__$1;
(statearr_14271_14295[(2)] = inst_14227);

(statearr_14271_14295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14266 === (13))){
var inst_14257 = (state_14265[(2)]);
var state_14265__$1 = state_14265;
var statearr_14272_14296 = state_14265__$1;
(statearr_14272_14296[(2)] = inst_14257);

(statearr_14272_14296[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14266 === (6))){
var inst_14239 = (state_14265[(9)]);
var inst_14245 = (state_14265[(2)]);
var inst_14246 = fluree.db.util.async.throw_err(inst_14245);
var inst_14247 = fluree.db.query.range.resolve_subid(db,inst_14239);
var state_14265__$1 = (function (){var statearr_14273 = state_14265;
(statearr_14273[(10)] = inst_14246);

return statearr_14273;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14265__$1,(7),inst_14247);
} else {
if((state_val_14266 === (3))){
var inst_14263 = (state_14265[(2)]);
var state_14265__$1 = state_14265;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14265__$1,inst_14263);
} else {
if((state_val_14266 === (12))){
var state_14265__$1 = state_14265;
var statearr_14274_14297 = state_14265__$1;
(statearr_14274_14297[(2)] = (2147483647));

(statearr_14274_14297[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14266 === (2))){
var _ = (function (){var statearr_14275 = state_14265;
(statearr_14275[(4)] = cljs.core.cons((5),(state_14265[(4)])));

return statearr_14275;
})();
var inst_14236 = parts;
var inst_14237 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14236,(0),null);
var inst_14238 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14236,(1),null);
var inst_14239 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14236,(2),null);
var inst_14240 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14236,(3),null);
var inst_14241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14236,(4),null);
var inst_14242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14236,(5),null);
var inst_14243 = fluree.db.query.range.resolve_subid(db,inst_14237);
var state_14265__$1 = (function (){var statearr_14276 = state_14265;
(statearr_14276[(11)] = inst_14238);

(statearr_14276[(12)] = inst_14241);

(statearr_14276[(13)] = inst_14240);

(statearr_14276[(9)] = inst_14239);

(statearr_14276[(7)] = inst_14242);

return statearr_14276;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14265__$1,(6),inst_14243);
} else {
if((state_val_14266 === (11))){
var state_14265__$1 = state_14265;
var statearr_14278_14298 = state_14265__$1;
(statearr_14278_14298[(2)] = (-2147483647));

(statearr_14278_14298[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14266 === (9))){
var inst_14253 = (cljs.core._GT__EQ_ === test);
var state_14265__$1 = state_14265;
if(cljs.core.truth_(inst_14253)){
var statearr_14279_14299 = state_14265__$1;
(statearr_14279_14299[(1)] = (11));

} else {
var statearr_14280_14300 = state_14265__$1;
(statearr_14280_14300[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14266 === (5))){
var _ = (function (){var statearr_14281 = state_14265;
(statearr_14281[(4)] = cljs.core.rest((state_14265[(4)])));

return statearr_14281;
})();
var state_14265__$1 = state_14265;
var ex14277 = (state_14265__$1[(2)]);
var statearr_14282_14301 = state_14265__$1;
(statearr_14282_14301[(5)] = ex14277);


if((ex14277 instanceof Error)){
var statearr_14283_14302 = state_14265__$1;
(statearr_14283_14302[(1)] = (4));

(statearr_14283_14302[(5)] = null);

} else {
throw ex14277;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14266 === (10))){
var inst_14238 = (state_14265[(11)]);
var inst_14241 = (state_14265[(12)]);
var inst_14240 = (state_14265[(13)]);
var inst_14246 = (state_14265[(10)]);
var inst_14250 = (state_14265[(8)]);
var inst_14259 = (state_14265[(2)]);
var inst_14260 = fluree.db.flake.__GT_Flake(inst_14246,inst_14238,inst_14250,inst_14240,inst_14241,inst_14259);
var _ = (function (){var statearr_14284 = state_14265;
(statearr_14284[(4)] = cljs.core.rest((state_14265[(4)])));

return statearr_14284;
})();
var state_14265__$1 = state_14265;
var statearr_14285_14303 = state_14265__$1;
(statearr_14285_14303[(2)] = inst_14260);

(statearr_14285_14303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14266 === (8))){
var inst_14242 = (state_14265[(7)]);
var state_14265__$1 = state_14265;
var statearr_14286_14304 = state_14265__$1;
(statearr_14286_14304[(2)] = inst_14242);

(statearr_14286_14304[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0 = (function (){
var statearr_14287 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14287[(0)] = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__);

(statearr_14287[(1)] = (1));

return statearr_14287;
});
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1 = (function (state_14265){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14265);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14288){var ex__2730__auto__ = e14288;
var statearr_14289_14305 = state_14265;
(statearr_14289_14305[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14265[(4)]))){
var statearr_14290_14306 = state_14265;
(statearr_14290_14306[(1)] = cljs.core.first((state_14265[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14307 = state_14265;
state_14265 = G__14307;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__ = function(state_14265){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1.call(this,state_14265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0;
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1;
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14291 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14291[(6)] = c__2749__auto__);

return statearr_14291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.range.resolved_leaf_QMARK_ = (function fluree$db$query$range$resolved_leaf_QMARK_(node){
var and__4251__auto__ = fluree.db.index.leaf_QMARK_(node);
if(and__4251__auto__){
return fluree.db.index.resolved_QMARK_(node);
} else {
return and__4251__auto__;
}
});
/**
 * Returns true if the supplied `node` contains flakes between the `lower` and
 *   `upper` flakes, according to the `node`'s comparator.
 */
fluree.db.query.range.intersects_range_QMARK_ = (function fluree$db$query$range$intersects_range_QMARK_(node,range_set){
return cljs.core.not((function (){var or__4253__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(and__4251__auto__)){
return fluree.db.flake.lower_than_all_QMARK_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node),range_set);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return ((cljs.core.not(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(node))) && (fluree.db.flake.higher_than_all_QMARK_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(node),range_set)));
}
})());
});
/**
 * Returns a transducer to filter flakes according to the boolean function values
 *   of the `:subject-fn`, `:predicate-fn`, and `:object-fn` keys from the supplied
 *   options map. All three functions are optional, and each supplied function will
 *   be applied to its corresponding flake component, and only flakes where each
 *   function evaluates to a truthy value will be included.
 */
fluree.db.query.range.query_filter = (function fluree$db$query$range$query_filter(p__14308){
var map__14309 = p__14308;
var map__14309__$1 = cljs.core.__destructure_map(map__14309);
var subject_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14309__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var predicate_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14309__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14309__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var filter_xfs = (function (){var G__14310 = cljs.core.PersistentVector.EMPTY;
var G__14310__$1 = (cljs.core.truth_(subject_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14310,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__14311 = fluree.db.flake.s(f);
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__14311) : subject_fn.call(null,G__14311));
}))):G__14310);
var G__14310__$2 = (cljs.core.truth_(predicate_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14310__$1,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__14312 = fluree.db.flake.p(f);
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__14312) : predicate_fn.call(null,G__14312));
}))):G__14310__$1);
if(cljs.core.truth_(object_fn)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14310__$2,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__14313 = fluree.db.flake.o(f);
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__14313) : object_fn.call(null,G__14313));
})));
} else {
return G__14310__$2;
}
})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,filter_xfs);
});
/**
 * Returns a transducer to extract flakes from each leaf from a stream of index
 *   leaf nodes that satisfy the bounds specified in the supplied query options
 *   map. The result of the transformation will be a stream of collections of
 *   flakes from the leaf nodes in the input stream, with one flake collection for
 *   each input leaf.
 */
fluree.db.query.range.extract_query_flakes = (function fluree$db$query$range$extract_query_flakes(p__14314){
var map__14315 = p__14314;
var map__14315__$1 = cljs.core.__destructure_map(map__14315);
var opts = map__14315__$1;
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14315__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var start_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14315__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14315__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var end_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14315__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$5(flakes,start_test,start_flake,end_test,end_flake);
})),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,fluree.db.query.range.query_filter(opts),flakes);
})));
});
/**
 * Returns a channel that will contain a stream of chunked flake collections that
 *   contain the flakes between `start-flake` and `end-flake` and are within the
 *   transaction range starting at `from-t` and ending at `to-t`.
 */
fluree.db.query.range.resolve_flake_slices = (function fluree$db$query$range$resolve_flake_slices(p__14316,root,novelty,error_ch,p__14317){
var map__14318 = p__14316;
var map__14318__$1 = cljs.core.__destructure_map(map__14318);
var conn = map__14318__$1;
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14318__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var map__14319 = p__14317;
var map__14319__$1 = cljs.core.__destructure_map(map__14319);
var opts = map__14319__$1;
var from_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14319__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525));
var to_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14319__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14319__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14319__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var resolver = fluree.db.index.__GT_CachedTRangeResolver(conn,novelty,from_t,to_t,async_cache);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(root);
var range_set = fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_flake,end_flake], 0));
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_(node,range_set);
});
var query_xf = fluree.db.query.range.extract_query_flakes(opts);
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(resolver,root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
});
fluree.db.query.range.unauthorized_QMARK_ = (function fluree$db$query$range$unauthorized_QMARK_(f){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));
});
fluree.db.query.range.authorize_flake = (function fluree$db$query$range$authorize_flake(db,error_ch,flake){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14350){
var state_val_14351 = (state_14350[(1)]);
if((state_val_14351 === (7))){
var inst_14333 = (state_14350[(7)]);
var state_14350__$1 = state_14350;
var statearr_14352_14376 = state_14350__$1;
(statearr_14352_14376[(2)] = inst_14333);

(statearr_14352_14376[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14351 === (1))){
var state_14350__$1 = state_14350;
var statearr_14353_14377 = state_14350__$1;
(statearr_14353_14377[(2)] = null);

(statearr_14353_14377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14351 === (4))){
var inst_14320 = (state_14350[(2)]);
var inst_14321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14322 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_14323 = (new cljs.core.PersistentVector(null,3,(5),inst_14321,inst_14322,null));
var inst_14324 = cljs.core.select_keys(db,inst_14323);
var inst_14325 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_14320,"Error authorizing flake in ledger",inst_14324) : fluree.db.util.log.error.call(null,inst_14320,"Error authorizing flake in ledger",inst_14324));
var state_14350__$1 = (function (){var statearr_14355 = state_14350;
(statearr_14355[(8)] = inst_14325);

return statearr_14355;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14350__$1,(5),error_ch,inst_14320);
} else {
if((state_val_14351 === (13))){
var inst_14345 = (state_14350[(2)]);
var _ = (function (){var statearr_14356 = state_14350;
(statearr_14356[(4)] = cljs.core.rest((state_14350[(4)])));

return statearr_14356;
})();
var state_14350__$1 = state_14350;
var statearr_14357_14378 = state_14350__$1;
(statearr_14357_14378[(2)] = inst_14345);

(statearr_14357_14378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14351 === (6))){
var _ = (function (){var statearr_14358 = state_14350;
(statearr_14358[(4)] = cljs.core.rest((state_14350[(4)])));

return statearr_14358;
})();
var state_14350__$1 = state_14350;
var ex14354 = (state_14350__$1[(2)]);
var statearr_14359_14379 = state_14350__$1;
(statearr_14359_14379[(5)] = ex14354);


var statearr_14360_14380 = state_14350__$1;
(statearr_14360_14380[(1)] = (4));

(statearr_14360_14380[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14351 === (3))){
var inst_14348 = (state_14350[(2)]);
var state_14350__$1 = state_14350;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14350__$1,inst_14348);
} else {
if((state_val_14351 === (12))){
var state_14350__$1 = state_14350;
var statearr_14361_14381 = state_14350__$1;
(statearr_14361_14381[(2)] = new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));

(statearr_14361_14381[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14351 === (2))){
var inst_14333 = (state_14350[(7)]);
var _ = (function (){var statearr_14362 = state_14350;
(statearr_14362[(4)] = cljs.core.cons((6),(state_14350[(4)])));

return statearr_14362;
})();
var inst_14333__$1 = fluree.db.util.schema.is_schema_flake_QMARK_(flake);
var state_14350__$1 = (function (){var statearr_14363 = state_14350;
(statearr_14363[(7)] = inst_14333__$1);

return statearr_14363;
})();
if(inst_14333__$1){
var statearr_14364_14382 = state_14350__$1;
(statearr_14364_14382[(1)] = (7));

} else {
var statearr_14365_14383 = state_14350__$1;
(statearr_14365_14383[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14351 === (11))){
var state_14350__$1 = state_14350;
var statearr_14366_14384 = state_14350__$1;
(statearr_14366_14384[(2)] = flake);

(statearr_14366_14384[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14351 === (9))){
var inst_14341 = (state_14350[(2)]);
var state_14350__$1 = state_14350;
if(cljs.core.truth_(inst_14341)){
var statearr_14367_14385 = state_14350__$1;
(statearr_14367_14385[(1)] = (11));

} else {
var statearr_14368_14386 = state_14350__$1;
(statearr_14368_14386[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14351 === (5))){
var inst_14327 = (state_14350[(2)]);
var state_14350__$1 = state_14350;
var statearr_14369_14387 = state_14350__$1;
(statearr_14369_14387[(2)] = inst_14327);

(statearr_14369_14387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14351 === (10))){
var inst_14338 = (state_14350[(2)]);
var inst_14339 = fluree.db.util.async.throw_err(inst_14338);
var state_14350__$1 = state_14350;
var statearr_14370_14388 = state_14350__$1;
(statearr_14370_14388[(2)] = inst_14339);

(statearr_14370_14388[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14351 === (8))){
var inst_14336 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,flake);
var state_14350__$1 = state_14350;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14350__$1,(10),inst_14336);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0 = (function (){
var statearr_14371 = [null,null,null,null,null,null,null,null,null];
(statearr_14371[(0)] = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__);

(statearr_14371[(1)] = (1));

return statearr_14371;
});
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1 = (function (state_14350){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14350);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14372){var ex__2730__auto__ = e14372;
var statearr_14373_14389 = state_14350;
(statearr_14373_14389[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14350[(4)]))){
var statearr_14374_14390 = state_14350;
(statearr_14374_14390[(1)] = cljs.core.first((state_14350[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14391 = state_14350;
state_14350 = G__14391;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__ = function(state_14350){
switch(arguments.length){
case 0:
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1.call(this,state_14350);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0;
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1;
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14375 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14375[(6)] = c__2749__auto__);

return statearr_14375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Authorize each flake in the supplied `flakes` collection asynchronously,
 *   returning a collection containing only allowed flakes according to the
 *   permissions of the supplied `db`.
 */
fluree.db.query.range.authorize_flakes = (function fluree$db$query$range$authorize_flakes(db,error_ch,flakes){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function() { 
var G__14392__delegate = function (fs){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$1(fluree.db.query.range.unauthorized_QMARK_),fs);
};
var G__14392 = function (var_args){
var fs = null;
if (arguments.length > 0) {
var G__14393__i = 0, G__14393__a = new Array(arguments.length -  0);
while (G__14393__i < G__14393__a.length) {G__14393__a[G__14393__i] = arguments[G__14393__i + 0]; ++G__14393__i;}
  fs = new cljs.core.IndexedSeq(G__14393__a,0,null);
} 
return G__14392__delegate.call(this,fs);};
G__14392.cljs$lang$maxFixedArity = 0;
G__14392.cljs$lang$applyTo = (function (arglist__14394){
var fs = cljs.core.seq(arglist__14394);
return G__14392__delegate(fs);
});
G__14392.cljs$core$IFn$_invoke$arity$variadic = G__14392__delegate;
return G__14392;
})()
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.range.authorize_flake,db,error_ch),flakes));
});
/**
 * Returns a channel that will eventually return a stream of flake slices
 *   containing only the schema flakes and the flakes validated by
 *   fluree.db.permissions-validate/allow-flake? function for the database `db`
 *   from the `flake-slices` channel
 */
fluree.db.query.range.filter_authorized = (function fluree$db$query$range$filter_authorized(p__14395,start,end,error_ch,flake_slices){
var map__14396 = p__14395;
var map__14396__$1 = cljs.core.__destructure_map(map__14396);
var db = map__14396__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14396__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
return flake_slices;
});
/**
 * Returns a transducer to filter a stream of flakes to only contain flakes from
 *   at most `limit` subjects, skipping the flakes from the first `offset`
 *   subjects.
 */
fluree.db.query.range.filter_subject_page = (function fluree$db$query$range$filter_subject_page(limit,offset){
var subject_page_xfs = (function (){var G__14397 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.flake.s)], null);
var G__14397__$1 = (cljs.core.truth_(offset)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14397,cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset)):G__14397);
var G__14397__$2 = (cljs.core.truth_(limit)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14397__$1,cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit)):G__14397__$1);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14397__$2,cljs.core.cat);

})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,subject_page_xfs);
});
/**
 * Collects flakes from the stream of flake collections in the `flake-slices`
 *   channel into a sorted vector according to the `limit`, `offset`, and
 *   `flake-limit` parameters. The result will have flakes from at most `limit`
 *   subjects, not including flakes from the first `offset` subjects, and having at
 *   most `flake-limit` flakes in total.
 */
fluree.db.query.range.into_page = (function fluree$db$query$range$into_page(limit,offset,flake_limit,flake_slices){
var page_xfs = (function (){var G__14398 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cat], null);
var G__14398__$1 = (cljs.core.truth_((function (){var or__4253__auto__ = limit;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return offset;
}
})())?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14398,fluree.db.query.range.filter_subject_page(limit,offset)):G__14398);
if(cljs.core.truth_(flake_limit)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14398__$1,cljs.core.take.cljs$core$IFn$_invoke$arity$1(flake_limit));
} else {
return G__14398__$1;
}
})();
var page_xf = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,page_xfs);
return cljs.core.async.transduce(page_xf,cljs.core.conj,cljs.core.PersistentVector.EMPTY,flake_slices);
});
/**
 * Return a channel that will eventually hold a sorted vector of the range of
 *   flakes from `db` that meet the criteria specified in the `opts` map.
 */
fluree.db.query.range.index_range_STAR_ = (function fluree$db$query$range$index_range_STAR_(p__14399,error_ch,p__14400){
var map__14401 = p__14399;
var map__14401__$1 = cljs.core.__destructure_map(map__14401);
var db = map__14401__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14401__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__14402 = p__14400;
var map__14402__$1 = cljs.core.__destructure_map(map__14402);
var opts = map__14402__$1;
var idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14402__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14402__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14402__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14402__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14402__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var flake_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14402__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961));
var idx_root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var idx_cmp = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var novelty = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx], null));
return fluree.db.query.range.into_page(limit,offset,flake_limit,fluree.db.query.range.filter_authorized(db,start_flake,end_flake,error_ch,fluree.db.query.range.resolve_flake_slices(conn,idx_root,novelty,error_ch,opts)));
});
/**
 * Finds the full index or time range interval including the maximum and minimum
 *   tests when only one test is provided
 */
fluree.db.query.range.expand_range_interval = (function fluree$db$query$range$expand_range_interval(idx,test,match){
var pred__14403 = cljs.core.identical_QMARK_;
var expr__14404 = test;
if(cljs.core.truth_((pred__14403.cljs$core$IFn$_invoke$arity$2 ? pred__14403.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__14404) : pred__14403.call(null,cljs.core._EQ_,expr__14404)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14403.cljs$core$IFn$_invoke$arity$2 ? pred__14403.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__14404) : pred__14403.call(null,cljs.core._LT_,expr__14404)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__14403.cljs$core$IFn$_invoke$arity$2 ? pred__14403.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__14404) : pred__14403.call(null,cljs.core._LT__EQ_,expr__14404)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14403.cljs$core$IFn$_invoke$arity$2 ? pred__14403.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__14404) : pred__14403.call(null,cljs.core._GT_,expr__14404)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__14403.cljs$core$IFn$_invoke$arity$2 ? pred__14403.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__14404) : pred__14403.call(null,cljs.core._GT__EQ_,expr__14404)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14404)].join('')));
}
}
}
}
}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we
 *   don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will return in
 *   reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number
 *          is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used
 *         when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__14407 = arguments.length;
switch (G__14407) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14408 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14408,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14408,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14408,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14408,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (p__14411,idx,start_test,start_match,end_test,end_match,opts){
var map__14412 = p__14411;
var map__14412__$1 = cljs.core.__destructure_map(map__14412);
var db = map__14412__$1;
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14412__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__14413 = opts;
var map__14413__$1 = cljs.core.__destructure_map(map__14413);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14413__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var from_t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__14413__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t);
var to_t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__14413__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359),t);
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var start_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var end_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14475){
var state_val_14476 = (state_14475[(1)]);
if((state_val_14476 === (7))){
var inst_14423 = (state_14475[(7)]);
var inst_14432 = (state_14475[(8)]);
var inst_14428 = (state_14475[(9)]);
var inst_14426 = (state_14475[(2)]);
var inst_14427 = fluree.db.util.async.throw_err(inst_14426);
var inst_14428__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_14429 = [new cljs.core.Keyword(null,"idx","idx",1053688473),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"start-test","start-test",-952983565),new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),new cljs.core.Keyword(null,"end-test","end-test",481973727),new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961)];
var inst_14430 = [idx,from_t,to_t,start_test,inst_14423,end_test,inst_14427,limit];
var inst_14431 = cljs.core.PersistentHashMap.fromArrays(inst_14429,inst_14430);
var inst_14432__$1 = fluree.db.query.range.index_range_STAR_(db,inst_14428__$1,inst_14431);
var inst_14440 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14441 = [inst_14428__$1,inst_14432__$1];
var inst_14442 = (new cljs.core.PersistentVector(null,2,(5),inst_14440,inst_14441,null));
var state_14475__$1 = (function (){var statearr_14477 = state_14475;
(statearr_14477[(8)] = inst_14432__$1);

(statearr_14477[(9)] = inst_14428__$1);

return statearr_14477;
})();
return cljs.core.async.ioc_alts_BANG_(state_14475__$1,(8),inst_14442);
} else {
if((state_val_14476 === (1))){
var state_14475__$1 = state_14475;
var statearr_14478_14507 = state_14475__$1;
(statearr_14478_14507[(2)] = null);

(statearr_14478_14507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14476 === (4))){
var inst_14414 = (state_14475[(2)]);
var state_14475__$1 = state_14475;
var statearr_14479_14508 = state_14475__$1;
(statearr_14479_14508[(2)] = inst_14414);

(statearr_14479_14508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14476 === (15))){
var inst_14445 = (state_14475[(10)]);
var state_14475__$1 = state_14475;
var statearr_14480_14509 = state_14475__$1;
(statearr_14480_14509[(2)] = inst_14445);

(statearr_14480_14509[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14476 === (13))){
var inst_14446 = (state_14475[(11)]);
var inst_14462 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14446,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_14475__$1 = state_14475;
if(inst_14462){
var statearr_14481_14510 = state_14475__$1;
(statearr_14481_14510[(1)] = (15));

} else {
var statearr_14482_14511 = state_14475__$1;
(statearr_14482_14511[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14476 === (6))){
var inst_14422 = (state_14475[(2)]);
var inst_14423 = fluree.db.util.async.throw_err(inst_14422);
var inst_14424 = fluree.db.query.range.resolve_match_flake(db,end_test,end_parts);
var state_14475__$1 = (function (){var statearr_14483 = state_14475;
(statearr_14483[(7)] = inst_14423);

return statearr_14483;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14475__$1,(7),inst_14424);
} else {
if((state_val_14476 === (17))){
var inst_14466 = (state_14475[(2)]);
var state_14475__$1 = state_14475;
var statearr_14484_14512 = state_14475__$1;
(statearr_14484_14512[(2)] = inst_14466);

(statearr_14484_14512[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14476 === (3))){
var inst_14473 = (state_14475[(2)]);
var state_14475__$1 = state_14475;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14475__$1,inst_14473);
} else {
if((state_val_14476 === (12))){
var inst_14444 = (state_14475[(12)]);
var inst_14460 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14444,(0),null);
var state_14475__$1 = state_14475;
var statearr_14485_14513 = state_14475__$1;
(statearr_14485_14513[(2)] = inst_14460);

(statearr_14485_14513[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14476 === (2))){
var _ = (function (){var statearr_14486 = state_14475;
(statearr_14486[(4)] = cljs.core.cons((5),(state_14475[(4)])));

return statearr_14486;
})();
var inst_14420 = fluree.db.query.range.resolve_match_flake(db,start_test,start_parts);
var state_14475__$1 = state_14475;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14475__$1,(6),inst_14420);
} else {
if((state_val_14476 === (11))){
var inst_14470 = (state_14475[(2)]);
var _ = (function (){var statearr_14488 = state_14475;
(statearr_14488[(4)] = cljs.core.rest((state_14475[(4)])));

return statearr_14488;
})();
var state_14475__$1 = state_14475;
var statearr_14489_14514 = state_14475__$1;
(statearr_14489_14514[(2)] = inst_14470);

(statearr_14489_14514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14476 === (9))){
var inst_14444 = (state_14475[(12)]);
var inst_14452 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14444,(0),null);
var inst_14453 = (function(){throw inst_14452})();
var state_14475__$1 = state_14475;
var statearr_14490_14515 = state_14475__$1;
(statearr_14490_14515[(2)] = inst_14453);

(statearr_14490_14515[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14476 === (5))){
var _ = (function (){var statearr_14491 = state_14475;
(statearr_14491[(4)] = cljs.core.rest((state_14475[(4)])));

return statearr_14491;
})();
var state_14475__$1 = state_14475;
var ex14487 = (state_14475__$1[(2)]);
var statearr_14492_14516 = state_14475__$1;
(statearr_14492_14516[(5)] = ex14487);


if((ex14487 instanceof Error)){
var statearr_14493_14517 = state_14475__$1;
(statearr_14493_14517[(1)] = (4));

(statearr_14493_14517[(5)] = null);

} else {
throw ex14487;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14476 === (14))){
var inst_14468 = (state_14475[(2)]);
var state_14475__$1 = state_14475;
var statearr_14494_14518 = state_14475__$1;
(statearr_14494_14518[(2)] = inst_14468);

(statearr_14494_14518[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14476 === (16))){
var state_14475__$1 = state_14475;
var statearr_14495_14519 = state_14475__$1;
(statearr_14495_14519[(2)] = null);

(statearr_14495_14519[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14476 === (10))){
var inst_14446 = (state_14475[(11)]);
var inst_14432 = (state_14475[(8)]);
var inst_14455 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14446,inst_14432);
var state_14475__$1 = state_14475;
if(inst_14455){
var statearr_14496_14520 = state_14475__$1;
(statearr_14496_14520[(1)] = (12));

} else {
var statearr_14497_14521 = state_14475__$1;
(statearr_14497_14521[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14476 === (8))){
var inst_14446 = (state_14475[(11)]);
var inst_14444 = (state_14475[(12)]);
var inst_14428 = (state_14475[(9)]);
var inst_14444__$1 = (state_14475[(2)]);
var inst_14445 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14444__$1,(0),null);
var inst_14446__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14444__$1,(1),null);
var inst_14447 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14446__$1,inst_14428);
var state_14475__$1 = (function (){var statearr_14498 = state_14475;
(statearr_14498[(11)] = inst_14446__$1);

(statearr_14498[(10)] = inst_14445);

(statearr_14498[(12)] = inst_14444__$1);

return statearr_14498;
})();
if(inst_14447){
var statearr_14499_14522 = state_14475__$1;
(statearr_14499_14522[(1)] = (9));

} else {
var statearr_14500_14523 = state_14475__$1;
(statearr_14500_14523[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_14501 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14501[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_14501[(1)] = (1));

return statearr_14501;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_14475){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14475);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14502){var ex__2730__auto__ = e14502;
var statearr_14503_14524 = state_14475;
(statearr_14503_14524[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14475[(4)]))){
var statearr_14504_14525 = state_14475;
(statearr_14504_14525[(1)] = cljs.core.first((state_14475[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14526 = state_14475;
state_14475 = G__14526;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_14475){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_14475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14505 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14505[(6)] = c__2749__auto__);

return statearr_14505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__14528 = arguments.length;
switch (G__14528) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14529 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14529,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14529,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14529,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14529,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (p__14532,idx,start_test,start_match,end_test,end_match,p__14533){
var map__14534 = p__14532;
var map__14534__$1 = cljs.core.__destructure_map(map__14534);
var db = map__14534__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14534__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14534__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__14535 = p__14533;
var map__14535__$1 = cljs.core.__destructure_map(map__14535);
var opts = map__14535__$1;
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14535__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var vec__14536 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var s1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14536,(0),null);
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14536,(1),null);
var o1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14536,(2),null);
var t1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14536,(3),null);
var op1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14536,(4),null);
var m1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14536,(5),null);
var vec__14539 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var s2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14539,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14539,(1),null);
var o2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14539,(2),null);
var t2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14539,(3),null);
var op2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14539,(4),null);
var m2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14539,(5),null);
var vec__14542 = (function (){var temp__5806__auto__ = ((cljs.core.boolean_QMARK_(o1))?o1:((cljs.core.boolean_QMARK_(o2))?o2:null
));
if((temp__5806__auto__ == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o1,o2], null),object_fn], null);
} else {
var bool = temp__5806__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),(function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
})], null);
}
})();
var vec__14545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14542,(0),null);
var o1__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14545,(0),null);
var o2__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14545,(1),null);
var object_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14542,(1),null);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14613){
var state_val_14614 = (state_14613[(1)]);
if((state_val_14614 === (7))){
var inst_14568 = (state_14613[(7)]);
var inst_14560 = (state_14613[(8)]);
var inst_14570 = (state_14613[(9)]);
var inst_14566 = (state_14613[(2)]);
var inst_14567 = fluree.db.util.async.throw_err(inst_14566);
var inst_14568__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_14569 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"idx","idx",1053688473),idx,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"from-t","from-t",1730913525),t,new cljs.core.Keyword(null,"to-t","to-t",569467359),t,new cljs.core.Keyword(null,"start-test","start-test",-952983565),start_test,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),inst_14560,new cljs.core.Keyword(null,"end-test","end-test",481973727),end_test,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),inst_14567,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),object_fn__$1], 0));
var inst_14570__$1 = fluree.db.query.range.index_range_STAR_(db,inst_14568__$1,inst_14569);
var inst_14578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14579 = [inst_14568__$1,inst_14570__$1];
var inst_14580 = (new cljs.core.PersistentVector(null,2,(5),inst_14578,inst_14579,null));
var state_14613__$1 = (function (){var statearr_14615 = state_14613;
(statearr_14615[(7)] = inst_14568__$1);

(statearr_14615[(9)] = inst_14570__$1);

return statearr_14615;
})();
return cljs.core.async.ioc_alts_BANG_(state_14613__$1,(8),inst_14580);
} else {
if((state_val_14614 === (1))){
var state_14613__$1 = state_14613;
var statearr_14616_14645 = state_14613__$1;
(statearr_14616_14645[(2)] = null);

(statearr_14616_14645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (4))){
var inst_14548 = (state_14613[(2)]);
var state_14613__$1 = state_14613;
var statearr_14617_14646 = state_14613__$1;
(statearr_14617_14646[(2)] = inst_14548);

(statearr_14617_14646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (15))){
var inst_14583 = (state_14613[(10)]);
var state_14613__$1 = state_14613;
var statearr_14618_14647 = state_14613__$1;
(statearr_14618_14647[(2)] = inst_14583);

(statearr_14618_14647[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (13))){
var inst_14584 = (state_14613[(11)]);
var inst_14600 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14584,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_14613__$1 = state_14613;
if(inst_14600){
var statearr_14619_14648 = state_14613__$1;
(statearr_14619_14648[(1)] = (15));

} else {
var statearr_14620_14649 = state_14613__$1;
(statearr_14620_14649[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (6))){
var inst_14559 = (state_14613[(2)]);
var inst_14560 = fluree.db.util.async.throw_err(inst_14559);
var inst_14561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14562 = [s2,p2,o2__$1,t2,op2,m2];
var inst_14563 = (new cljs.core.PersistentVector(null,6,(5),inst_14561,inst_14562,null));
var inst_14564 = fluree.db.query.range.resolve_match_flake(db,end_test,inst_14563);
var state_14613__$1 = (function (){var statearr_14621 = state_14613;
(statearr_14621[(8)] = inst_14560);

return statearr_14621;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14613__$1,(7),inst_14564);
} else {
if((state_val_14614 === (17))){
var inst_14604 = (state_14613[(2)]);
var state_14613__$1 = state_14613;
var statearr_14622_14650 = state_14613__$1;
(statearr_14622_14650[(2)] = inst_14604);

(statearr_14622_14650[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (3))){
var inst_14611 = (state_14613[(2)]);
var state_14613__$1 = state_14613;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14613__$1,inst_14611);
} else {
if((state_val_14614 === (12))){
var inst_14582 = (state_14613[(12)]);
var inst_14598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14582,(0),null);
var state_14613__$1 = state_14613;
var statearr_14623_14651 = state_14613__$1;
(statearr_14623_14651[(2)] = inst_14598);

(statearr_14623_14651[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (2))){
var _ = (function (){var statearr_14624 = state_14613;
(statearr_14624[(4)] = cljs.core.cons((5),(state_14613[(4)])));

return statearr_14624;
})();
var inst_14554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14555 = [s1,p1,o1__$1,t1,op1,m1];
var inst_14556 = (new cljs.core.PersistentVector(null,6,(5),inst_14554,inst_14555,null));
var inst_14557 = fluree.db.query.range.resolve_match_flake(db,start_test,inst_14556);
var state_14613__$1 = state_14613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14613__$1,(6),inst_14557);
} else {
if((state_val_14614 === (11))){
var inst_14608 = (state_14613[(2)]);
var _ = (function (){var statearr_14626 = state_14613;
(statearr_14626[(4)] = cljs.core.rest((state_14613[(4)])));

return statearr_14626;
})();
var state_14613__$1 = state_14613;
var statearr_14627_14652 = state_14613__$1;
(statearr_14627_14652[(2)] = inst_14608);

(statearr_14627_14652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (9))){
var inst_14582 = (state_14613[(12)]);
var inst_14590 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14582,(0),null);
var inst_14591 = (function(){throw inst_14590})();
var state_14613__$1 = state_14613;
var statearr_14628_14653 = state_14613__$1;
(statearr_14628_14653[(2)] = inst_14591);

(statearr_14628_14653[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (5))){
var _ = (function (){var statearr_14629 = state_14613;
(statearr_14629[(4)] = cljs.core.rest((state_14613[(4)])));

return statearr_14629;
})();
var state_14613__$1 = state_14613;
var ex14625 = (state_14613__$1[(2)]);
var statearr_14630_14654 = state_14613__$1;
(statearr_14630_14654[(5)] = ex14625);


if((ex14625 instanceof Error)){
var statearr_14631_14655 = state_14613__$1;
(statearr_14631_14655[(1)] = (4));

(statearr_14631_14655[(5)] = null);

} else {
throw ex14625;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (14))){
var inst_14606 = (state_14613[(2)]);
var state_14613__$1 = state_14613;
var statearr_14632_14656 = state_14613__$1;
(statearr_14632_14656[(2)] = inst_14606);

(statearr_14632_14656[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (16))){
var state_14613__$1 = state_14613;
var statearr_14633_14657 = state_14613__$1;
(statearr_14633_14657[(2)] = null);

(statearr_14633_14657[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (10))){
var inst_14584 = (state_14613[(11)]);
var inst_14570 = (state_14613[(9)]);
var inst_14593 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14584,inst_14570);
var state_14613__$1 = state_14613;
if(inst_14593){
var statearr_14634_14658 = state_14613__$1;
(statearr_14634_14658[(1)] = (12));

} else {
var statearr_14635_14659 = state_14613__$1;
(statearr_14635_14659[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (8))){
var inst_14568 = (state_14613[(7)]);
var inst_14584 = (state_14613[(11)]);
var inst_14582 = (state_14613[(12)]);
var inst_14582__$1 = (state_14613[(2)]);
var inst_14583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14582__$1,(0),null);
var inst_14584__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14582__$1,(1),null);
var inst_14585 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14584__$1,inst_14568);
var state_14613__$1 = (function (){var statearr_14636 = state_14613;
(statearr_14636[(10)] = inst_14583);

(statearr_14636[(11)] = inst_14584__$1);

(statearr_14636[(12)] = inst_14582__$1);

return statearr_14636;
})();
if(inst_14585){
var statearr_14637_14660 = state_14613__$1;
(statearr_14637_14660[(1)] = (9));

} else {
var statearr_14638_14661 = state_14613__$1;
(statearr_14638_14661[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_14639 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14639[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_14639[(1)] = (1));

return statearr_14639;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_14613){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14613);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14640){var ex__2730__auto__ = e14640;
var statearr_14641_14662 = state_14613;
(statearr_14641_14662[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14613[(4)]))){
var statearr_14642_14663 = state_14613;
(statearr_14642_14663[(1)] = cljs.core.first((state_14613[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14664 = state_14613;
state_14613 = G__14664;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_14613){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_14613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14643 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14643[(6)] = c__2749__auto__);

return statearr_14643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= fluree.db.flake.o(f))) && ((fluree.db.flake.o(f) <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14720){
var state_val_14721 = (state_14720[(1)]);
if((state_val_14721 === (7))){
var inst_14684 = (state_14720[(7)]);
var inst_14694 = (state_14720[(8)]);
var inst_14692 = fluree.db.flake.Flake__GT_parts(inst_14684);
var inst_14693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14692,(0),null);
var inst_14694__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14692,(1),null);
var inst_14695 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14692,(2),null);
var inst_14696 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14692,(3),null);
var inst_14697 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14692,(4),null);
var inst_14698 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14692,(5),null);
var inst_14699 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_14695,inst_14694__$1);
var state_14720__$1 = (function (){var statearr_14722 = state_14720;
(statearr_14722[(9)] = inst_14697);

(statearr_14722[(10)] = inst_14696);

(statearr_14722[(11)] = inst_14693);

(statearr_14722[(12)] = inst_14698);

(statearr_14722[(8)] = inst_14694__$1);

return statearr_14722;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14720__$1,(10),inst_14699);
} else {
if((state_val_14721 === (1))){
var inst_14672 = flakes;
var inst_14673 = cljs.core.seq(inst_14672);
var inst_14674 = cljs.core.first(inst_14673);
var inst_14675 = cljs.core.next(inst_14673);
var inst_14676 = cljs.core.PersistentVector.EMPTY;
var inst_14677 = inst_14672;
var inst_14678 = inst_14676;
var state_14720__$1 = (function (){var statearr_14723 = state_14720;
(statearr_14723[(13)] = inst_14674);

(statearr_14723[(14)] = inst_14675);

(statearr_14723[(15)] = inst_14677);

(statearr_14723[(16)] = inst_14678);

return statearr_14723;
})();
var statearr_14724_14742 = state_14720__$1;
(statearr_14724_14742[(2)] = null);

(statearr_14724_14742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14721 === (4))){
var inst_14684 = (state_14720[(7)]);
var inst_14687 = fluree.db.query.range.is_tag_flake_QMARK_(inst_14684);
var state_14720__$1 = state_14720;
if(inst_14687){
var statearr_14725_14743 = state_14720__$1;
(statearr_14725_14743[(1)] = (7));

} else {
var statearr_14726_14744 = state_14720__$1;
(statearr_14726_14744[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14721 === (6))){
var inst_14716 = (state_14720[(2)]);
var state_14720__$1 = state_14720;
var statearr_14727_14745 = state_14720__$1;
(statearr_14727_14745[(2)] = inst_14716);

(statearr_14727_14745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14721 === (3))){
var inst_14718 = (state_14720[(2)]);
var state_14720__$1 = state_14720;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14720__$1,inst_14718);
} else {
if((state_val_14721 === (2))){
var inst_14684 = (state_14720[(7)]);
var inst_14677 = (state_14720[(15)]);
var inst_14683 = cljs.core.seq(inst_14677);
var inst_14684__$1 = cljs.core.first(inst_14683);
var inst_14685 = cljs.core.next(inst_14683);
var state_14720__$1 = (function (){var statearr_14728 = state_14720;
(statearr_14728[(7)] = inst_14684__$1);

(statearr_14728[(17)] = inst_14685);

return statearr_14728;
})();
if(cljs.core.truth_(inst_14684__$1)){
var statearr_14729_14746 = state_14720__$1;
(statearr_14729_14746[(1)] = (4));

} else {
var statearr_14730_14747 = state_14720__$1;
(statearr_14730_14747[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14721 === (9))){
var inst_14713 = (state_14720[(2)]);
var state_14720__$1 = state_14720;
var statearr_14731_14748 = state_14720__$1;
(statearr_14731_14748[(2)] = inst_14713);

(statearr_14731_14748[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14721 === (5))){
var inst_14678 = (state_14720[(16)]);
var state_14720__$1 = state_14720;
var statearr_14732_14749 = state_14720__$1;
(statearr_14732_14749[(2)] = inst_14678);

(statearr_14732_14749[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14721 === (10))){
var inst_14697 = (state_14720[(9)]);
var inst_14696 = (state_14720[(10)]);
var inst_14693 = (state_14720[(11)]);
var inst_14678 = (state_14720[(16)]);
var inst_14685 = (state_14720[(17)]);
var inst_14698 = (state_14720[(12)]);
var inst_14694 = (state_14720[(8)]);
var inst_14701 = (state_14720[(2)]);
var inst_14702 = fluree.db.util.async.throw_err(inst_14701);
var inst_14703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14704 = [inst_14693,inst_14694,inst_14702,inst_14696,inst_14697,inst_14698];
var inst_14705 = (new cljs.core.PersistentVector(null,6,(5),inst_14703,inst_14704,null));
var inst_14706 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_14705);
var inst_14707 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_14678,inst_14706);
var inst_14677 = inst_14685;
var inst_14678__$1 = inst_14707;
var state_14720__$1 = (function (){var statearr_14733 = state_14720;
(statearr_14733[(15)] = inst_14677);

(statearr_14733[(16)] = inst_14678__$1);

return statearr_14733;
})();
var statearr_14734_14750 = state_14720__$1;
(statearr_14734_14750[(2)] = null);

(statearr_14734_14750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14721 === (8))){
var inst_14684 = (state_14720[(7)]);
var inst_14678 = (state_14720[(16)]);
var inst_14685 = (state_14720[(17)]);
var inst_14710 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_14678,inst_14684);
var inst_14677 = inst_14685;
var inst_14678__$1 = inst_14710;
var state_14720__$1 = (function (){var statearr_14735 = state_14720;
(statearr_14735[(15)] = inst_14677);

(statearr_14735[(16)] = inst_14678__$1);

return statearr_14735;
})();
var statearr_14736_14751 = state_14720__$1;
(statearr_14736_14751[(2)] = null);

(statearr_14736_14751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0 = (function (){
var statearr_14737 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14737[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__);

(statearr_14737[(1)] = (1));

return statearr_14737;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1 = (function (state_14720){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14720);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14738){var ex__2730__auto__ = e14738;
var statearr_14739_14752 = state_14720;
(statearr_14739_14752[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14720[(4)]))){
var statearr_14740_14753 = state_14720;
(statearr_14740_14753[(1)] = cljs.core.first((state_14720[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14754 = state_14720;
state_14720 = G__14754;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__ = function(state_14720){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1.call(this,state_14720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14741 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14741[(6)] = c__2749__auto__);

return statearr_14741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__14756 = arguments.length;
switch (G__14756) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14938){
var state_val_14939 = (state_14938[(1)]);
if((state_val_14939 === (65))){
var inst_14807 = (state_14938[(7)]);
var state_14938__$1 = state_14938;
if(cljs.core.truth_(inst_14807)){
var statearr_14940_15044 = state_14938__$1;
(statearr_14940_15044[(1)] = (68));

} else {
var statearr_14941_15045 = state_14938__$1;
(statearr_14941_15045[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (70))){
var inst_14917 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
var statearr_14942_15046 = state_14938__$1;
(statearr_14942_15046[(2)] = inst_14917);

(statearr_14942_15046[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (62))){
var inst_14883 = (state_14938[(2)]);
var inst_14884 = fluree.db.util.async.throw_err(inst_14883);
var inst_14885 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_14884);
var state_14938__$1 = state_14938;
var statearr_14943_15047 = state_14938__$1;
(statearr_14943_15047[(2)] = inst_14885);

(statearr_14943_15047[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (74))){
var inst_14933 = (state_14938[(2)]);
var _ = (function (){var statearr_14944 = state_14938;
(statearr_14944[(4)] = cljs.core.rest((state_14938[(4)])));

return statearr_14944;
})();
var state_14938__$1 = state_14938;
var statearr_14945_15048 = state_14938__$1;
(statearr_14945_15048[(2)] = inst_14933);

(statearr_14945_15048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (7))){
var state_14938__$1 = state_14938;
var statearr_14946_15049 = state_14938__$1;
(statearr_14946_15049[(2)] = false);

(statearr_14946_15049[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (59))){
var inst_14807 = (state_14938[(7)]);
var inst_14877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14878 = [inst_14807];
var inst_14879 = (new cljs.core.PersistentVector(null,1,(5),inst_14877,inst_14878,null));
var inst_14880 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_14881 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14879,inst_14880);
var state_14938__$1 = state_14938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14938__$1,(62),inst_14881);
} else {
if((state_val_14939 === (20))){
var state_14938__$1 = state_14938;
var statearr_14947_15050 = state_14938__$1;
(statearr_14947_15050[(2)] = null);

(statearr_14947_15050[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (72))){
var inst_14925 = (state_14938[(8)]);
var inst_14927 = fluree.db.query.range.coerce_tag_flakes(db,inst_14925);
var state_14938__$1 = state_14938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14938__$1,(75),inst_14927);
} else {
if((state_val_14939 === (58))){
var inst_14875 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
if(cljs.core.truth_(inst_14875)){
var statearr_14948_15051 = state_14938__$1;
(statearr_14948_15051[(1)] = (59));

} else {
var statearr_14949_15052 = state_14938__$1;
(statearr_14949_15052[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (60))){
var inst_14767 = (state_14938[(9)]);
var inst_14770 = (state_14938[(10)]);
var inst_14869 = (state_14938[(11)]);
var inst_14768 = (state_14938[(12)]);
var inst_14887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14888 = [inst_14768,inst_14767,null,inst_14770];
var inst_14889 = (new cljs.core.PersistentVector(null,4,(5),inst_14887,inst_14888,null));
var inst_14890 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_14869);
var inst_14891 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14889,inst_14890);
var state_14938__$1 = state_14938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14938__$1,(63),inst_14891);
} else {
if((state_val_14939 === (27))){
var inst_14767 = (state_14938[(9)]);
var inst_14770 = (state_14938[(10)]);
var inst_14807 = (state_14938[(7)]);
var inst_14768 = (state_14938[(12)]);
var inst_14819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14820 = [inst_14767,inst_14768,inst_14807,inst_14770];
var inst_14821 = (new cljs.core.PersistentVector(null,4,(5),inst_14819,inst_14820,null));
var inst_14822 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14821,opts);
var state_14938__$1 = state_14938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14938__$1,(30),inst_14822);
} else {
if((state_val_14939 === (1))){
var state_14938__$1 = state_14938;
var statearr_14950_15053 = state_14938__$1;
(statearr_14950_15053[(2)] = null);

(statearr_14950_15053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (69))){
var state_14938__$1 = state_14938;
var statearr_14951_15054 = state_14938__$1;
(statearr_14951_15054[(2)] = null);

(statearr_14951_15054[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (24))){
var inst_14768 = (state_14938[(12)]);
var state_14938__$1 = state_14938;
if(cljs.core.truth_(inst_14768)){
var statearr_14952_15055 = state_14938__$1;
(statearr_14952_15055[(1)] = (31));

} else {
var statearr_14953_15056 = state_14938__$1;
(statearr_14953_15056[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (55))){
var inst_14870 = (state_14938[(13)]);
var inst_14768 = (state_14938[(12)]);
var inst_14869 = (state_14938[(2)]);
var inst_14870__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_14768);
var state_14938__$1 = (function (){var statearr_14954 = state_14938;
(statearr_14954[(11)] = inst_14869);

(statearr_14954[(13)] = inst_14870__$1);

return statearr_14954;
})();
if(inst_14870__$1){
var statearr_14955_15057 = state_14938__$1;
(statearr_14955_15057[(1)] = (56));

} else {
var statearr_14956_15058 = state_14938__$1;
(statearr_14956_15058[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (39))){
var inst_14837 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
var statearr_14957_15059 = state_14938__$1;
(statearr_14957_15059[(2)] = inst_14837);

(statearr_14957_15059[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (46))){
var inst_14861 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
if(cljs.core.truth_(inst_14861)){
var statearr_14958_15060 = state_14938__$1;
(statearr_14958_15060[(1)] = (50));

} else {
var statearr_14959_15061 = state_14938__$1;
(statearr_14959_15061[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (4))){
var inst_14757 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
var statearr_14960_15062 = state_14938__$1;
(statearr_14960_15062[(2)] = inst_14757);

(statearr_14960_15062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (54))){
var inst_14771 = (state_14938[(14)]);
var inst_14777 = (state_14938[(15)]);
var inst_14767 = (state_14938[(9)]);
var inst_14770 = (state_14938[(10)]);
var inst_14863 = (state_14938[(16)]);
var inst_14807 = (state_14938[(7)]);
var inst_14766 = (state_14938[(17)]);
var inst_14782 = (state_14938[(18)]);
var inst_14768 = (state_14938[(12)]);
var inst_14867 = (function (){var t = inst_14770;
var temp__5802__auto__ = inst_14863;
var vec__14763 = inst_14766;
var p = inst_14768;
var idx_predicate_QMARK_ = inst_14771;
var o = inst_14807;
var tag_predicate_QMARK_ = inst_14777;
var s = inst_14767;
var o_coerce_QMARK_ = inst_14782;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_14938__$1 = state_14938;
var statearr_14961_15063 = state_14938__$1;
(statearr_14961_15063[(2)] = inst_14867);

(statearr_14961_15063[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (15))){
var inst_14769 = (state_14938[(19)]);
var inst_14788 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_14769);
var state_14938__$1 = state_14938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14938__$1,(18),inst_14788);
} else {
if((state_val_14939 === (48))){
var inst_14854 = (state_14938[(20)]);
var state_14938__$1 = state_14938;
var statearr_14962_15064 = state_14938__$1;
(statearr_14962_15064[(2)] = inst_14854);

(statearr_14962_15064[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (50))){
var inst_14863 = (state_14938[(16)]);
var inst_14863__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_14938__$1 = (function (){var statearr_14963 = state_14938;
(statearr_14963[(16)] = inst_14863__$1);

return statearr_14963;
})();
if(cljs.core.truth_(inst_14863__$1)){
var statearr_14964_15065 = state_14938__$1;
(statearr_14964_15065[(1)] = (53));

} else {
var statearr_14965_15066 = state_14938__$1;
(statearr_14965_15066[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (75))){
var inst_14929 = (state_14938[(2)]);
var inst_14930 = fluree.db.util.async.throw_err(inst_14929);
var state_14938__$1 = state_14938;
var statearr_14966_15067 = state_14938__$1;
(statearr_14966_15067[(2)] = inst_14930);

(statearr_14966_15067[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (21))){
var inst_14803 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
var statearr_14967_15068 = state_14938__$1;
(statearr_14967_15068[(2)] = inst_14803);

(statearr_14967_15068[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (31))){
var inst_14830 = (state_14938[(21)]);
var inst_14807 = (state_14938[(7)]);
var inst_14830__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_14807);
var state_14938__$1 = (function (){var statearr_14968 = state_14938;
(statearr_14968[(21)] = inst_14830__$1);

return statearr_14968;
})();
if(inst_14830__$1){
var statearr_14969_15069 = state_14938__$1;
(statearr_14969_15069[(1)] = (34));

} else {
var statearr_14970_15070 = state_14938__$1;
(statearr_14970_15070[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (32))){
var inst_14768 = (state_14938[(12)]);
var state_14938__$1 = state_14938;
var statearr_14971_15071 = state_14938__$1;
(statearr_14971_15071[(2)] = inst_14768);

(statearr_14971_15071[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (40))){
var inst_14767 = (state_14938[(9)]);
var inst_14770 = (state_14938[(10)]);
var inst_14807 = (state_14938[(7)]);
var inst_14768 = (state_14938[(12)]);
var inst_14845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14846 = [inst_14768,inst_14807,inst_14767,inst_14770];
var inst_14847 = (new cljs.core.PersistentVector(null,4,(5),inst_14845,inst_14846,null));
var inst_14848 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_14847,opts);
var state_14938__$1 = state_14938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14938__$1,(43),inst_14848);
} else {
if((state_val_14939 === (56))){
var inst_14807 = (state_14938[(7)]);
var inst_14872 = cljs.core.int_QMARK_(inst_14807);
var state_14938__$1 = state_14938;
var statearr_14972_15072 = state_14938__$1;
(statearr_14972_15072[(2)] = inst_14872);

(statearr_14972_15072[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (33))){
var inst_14843 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
if(cljs.core.truth_(inst_14843)){
var statearr_14973_15073 = state_14938__$1;
(statearr_14973_15073[(1)] = (40));

} else {
var statearr_14974_15074 = state_14938__$1;
(statearr_14974_15074[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (13))){
var inst_14769 = (state_14938[(19)]);
var inst_14786 = fluree.db.query.range.tag_string_QMARK_(inst_14769);
var state_14938__$1 = state_14938;
if(cljs.core.truth_(inst_14786)){
var statearr_14975_15075 = state_14938__$1;
(statearr_14975_15075[(1)] = (15));

} else {
var statearr_14976_15076 = state_14938__$1;
(statearr_14976_15076[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (22))){
var inst_14799 = (state_14938[(2)]);
var inst_14800 = fluree.db.util.async.throw_err(inst_14799);
var state_14938__$1 = state_14938;
var statearr_14977_15077 = state_14938__$1;
(statearr_14977_15077[(2)] = inst_14800);

(statearr_14977_15077[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (36))){
var inst_14840 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
var statearr_14978_15078 = state_14938__$1;
(statearr_14978_15078[(2)] = inst_14840);

(statearr_14978_15078[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (41))){
var inst_14768 = (state_14938[(12)]);
var state_14938__$1 = state_14938;
if(cljs.core.truth_(inst_14768)){
var statearr_14979_15079 = state_14938__$1;
(statearr_14979_15079[(1)] = (44));

} else {
var statearr_14980_15080 = state_14938__$1;
(statearr_14980_15080[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (43))){
var inst_14850 = (state_14938[(2)]);
var inst_14851 = fluree.db.util.async.throw_err(inst_14850);
var state_14938__$1 = state_14938;
var statearr_14981_15081 = state_14938__$1;
(statearr_14981_15081[(2)] = inst_14851);

(statearr_14981_15081[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (61))){
var inst_14896 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
var statearr_14982_15082 = state_14938__$1;
(statearr_14982_15082[(2)] = inst_14896);

(statearr_14982_15082[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (29))){
var inst_14816 = (state_14938[(2)]);
var inst_14817 = fluree.db.util.async.throw_err(inst_14816);
var state_14938__$1 = state_14938;
var statearr_14983_15083 = state_14938__$1;
(statearr_14983_15083[(2)] = inst_14817);

(statearr_14983_15083[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (44))){
var inst_14771 = (state_14938[(14)]);
var inst_14854 = (state_14938[(20)]);
var inst_14854__$1 = cljs.core.not(inst_14771);
var state_14938__$1 = (function (){var statearr_14984 = state_14938;
(statearr_14984[(20)] = inst_14854__$1);

return statearr_14984;
})();
if(inst_14854__$1){
var statearr_14985_15084 = state_14938__$1;
(statearr_14985_15084[(1)] = (47));

} else {
var statearr_14986_15085 = state_14938__$1;
(statearr_14986_15085[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (6))){
var inst_14768 = (state_14938[(12)]);
var inst_14773 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_14768);
var inst_14774 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_14773);
var state_14938__$1 = state_14938;
var statearr_14987_15086 = state_14938__$1;
(statearr_14987_15086[(2)] = inst_14774);

(statearr_14987_15086[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (28))){
var inst_14827 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
var statearr_14988_15087 = state_14938__$1;
(statearr_14988_15087[(2)] = inst_14827);

(statearr_14988_15087[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (64))){
var inst_14767 = (state_14938[(9)]);
var inst_14770 = (state_14938[(10)]);
var inst_14807 = (state_14938[(7)]);
var inst_14768 = (state_14938[(12)]);
var inst_14899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14900 = [inst_14768,inst_14767,inst_14807,inst_14770];
var inst_14901 = (new cljs.core.PersistentVector(null,4,(5),inst_14899,inst_14900,null));
var inst_14902 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14901,opts);
var state_14938__$1 = state_14938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14938__$1,(67),inst_14902);
} else {
if((state_val_14939 === (51))){
var inst_14768 = (state_14938[(12)]);
var state_14938__$1 = state_14938;
if(cljs.core.truth_(inst_14768)){
var statearr_14989_15088 = state_14938__$1;
(statearr_14989_15088[(1)] = (64));

} else {
var statearr_14990_15089 = state_14938__$1;
(statearr_14990_15089[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (25))){
var inst_14777 = (state_14938[(15)]);
var inst_14925 = (state_14938[(2)]);
var state_14938__$1 = (function (){var statearr_14991 = state_14938;
(statearr_14991[(8)] = inst_14925);

return statearr_14991;
})();
if(cljs.core.truth_(inst_14777)){
var statearr_14992_15090 = state_14938__$1;
(statearr_14992_15090[(1)] = (72));

} else {
var statearr_14993_15091 = state_14938__$1;
(statearr_14993_15091[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (34))){
var inst_14771 = (state_14938[(14)]);
var state_14938__$1 = state_14938;
if(cljs.core.truth_(inst_14771)){
var statearr_14994_15092 = state_14938__$1;
(statearr_14994_15092[(1)] = (37));

} else {
var statearr_14995_15093 = state_14938__$1;
(statearr_14995_15093[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (17))){
var inst_14805 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
var statearr_14996_15094 = state_14938__$1;
(statearr_14996_15094[(2)] = inst_14805);

(statearr_14996_15094[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (3))){
var inst_14936 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14938__$1,inst_14936);
} else {
if((state_val_14939 === (12))){
var inst_14769 = (state_14938[(19)]);
var state_14938__$1 = state_14938;
var statearr_14997_15095 = state_14938__$1;
(statearr_14997_15095[(2)] = inst_14769);

(statearr_14997_15095[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (2))){
var inst_14766 = (state_14938[(17)]);
var inst_14768 = (state_14938[(12)]);
var _ = (function (){var statearr_14998 = state_14938;
(statearr_14998[(4)] = cljs.core.cons((5),(state_14938[(4)])));

return statearr_14998;
})();
var inst_14766__$1 = fparts;
var inst_14767 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14766__$1,(0),null);
var inst_14768__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14766__$1,(1),null);
var inst_14769 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14766__$1,(2),null);
var inst_14770 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14766__$1,(3),null);
var inst_14771 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_14768__$1);
var state_14938__$1 = (function (){var statearr_14999 = state_14938;
(statearr_14999[(14)] = inst_14771);

(statearr_14999[(19)] = inst_14769);

(statearr_14999[(9)] = inst_14767);

(statearr_14999[(10)] = inst_14770);

(statearr_14999[(17)] = inst_14766__$1);

(statearr_14999[(12)] = inst_14768__$1);

return statearr_14999;
})();
if(cljs.core.truth_(inst_14768__$1)){
var statearr_15000_15096 = state_14938__$1;
(statearr_15000_15096[(1)] = (6));

} else {
var statearr_15001_15097 = state_14938__$1;
(statearr_15001_15097[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (66))){
var inst_14919 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
var statearr_15002_15098 = state_14938__$1;
(statearr_15002_15098[(2)] = inst_14919);

(statearr_15002_15098[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (23))){
var inst_14768 = (state_14938[(12)]);
var inst_14809 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_14768);
var state_14938__$1 = state_14938;
if(inst_14809){
var statearr_15003_15099 = state_14938__$1;
(statearr_15003_15099[(1)] = (26));

} else {
var statearr_15004_15100 = state_14938__$1;
(statearr_15004_15100[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (47))){
var inst_14807 = (state_14938[(7)]);
var state_14938__$1 = state_14938;
var statearr_15005_15101 = state_14938__$1;
(statearr_15005_15101[(2)] = inst_14807);

(statearr_15005_15101[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (35))){
var inst_14830 = (state_14938[(21)]);
var state_14938__$1 = state_14938;
var statearr_15006_15102 = state_14938__$1;
(statearr_15006_15102[(2)] = inst_14830);

(statearr_15006_15102[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (19))){
var inst_14769 = (state_14938[(19)]);
var inst_14768 = (state_14938[(12)]);
var inst_14795 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_14768);
var inst_14796 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14795),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14769)].join('');
var inst_14797 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_14796);
var state_14938__$1 = state_14938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14938__$1,(22),inst_14797);
} else {
if((state_val_14939 === (57))){
var inst_14870 = (state_14938[(13)]);
var state_14938__$1 = state_14938;
var statearr_15007_15103 = state_14938__$1;
(statearr_15007_15103[(2)] = inst_14870);

(statearr_15007_15103[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (68))){
var inst_14767 = (state_14938[(9)]);
var inst_14770 = (state_14938[(10)]);
var inst_14807 = (state_14938[(7)]);
var inst_14768 = (state_14938[(12)]);
var inst_14908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14909 = [inst_14807,inst_14768,inst_14767,inst_14770];
var inst_14910 = (new cljs.core.PersistentVector(null,4,(5),inst_14908,inst_14909,null));
var inst_14911 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_14910,opts);
var state_14938__$1 = state_14938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14938__$1,(71),inst_14911);
} else {
if((state_val_14939 === (11))){
var inst_14782 = (state_14938[(18)]);
var inst_14782__$1 = (state_14938[(2)]);
var inst_14783 = cljs.core.not(inst_14782__$1);
var state_14938__$1 = (function (){var statearr_15009 = state_14938;
(statearr_15009[(18)] = inst_14782__$1);

return statearr_15009;
})();
if(inst_14783){
var statearr_15010_15104 = state_14938__$1;
(statearr_15010_15104[(1)] = (12));

} else {
var statearr_15011_15105 = state_14938__$1;
(statearr_15011_15105[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (9))){
var inst_14769 = (state_14938[(19)]);
var inst_14779 = typeof inst_14769 === 'string';
var state_14938__$1 = state_14938;
var statearr_15012_15106 = state_14938__$1;
(statearr_15012_15106[(2)] = inst_14779);

(statearr_15012_15106[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (5))){
var _ = (function (){var statearr_15013 = state_14938;
(statearr_15013[(4)] = cljs.core.rest((state_14938[(4)])));

return statearr_15013;
})();
var state_14938__$1 = state_14938;
var ex15008 = (state_14938__$1[(2)]);
var statearr_15014_15107 = state_14938__$1;
(statearr_15014_15107[(5)] = ex15008);


if((ex15008 instanceof Error)){
var statearr_15015_15108 = state_14938__$1;
(statearr_15015_15108[(1)] = (4));

(statearr_15015_15108[(5)] = null);

} else {
throw ex15008;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (14))){
var inst_14767 = (state_14938[(9)]);
var inst_14807 = (state_14938[(2)]);
var state_14938__$1 = (function (){var statearr_15016 = state_14938;
(statearr_15016[(7)] = inst_14807);

return statearr_15016;
})();
if(cljs.core.truth_(inst_14767)){
var statearr_15017_15109 = state_14938__$1;
(statearr_15017_15109[(1)] = (23));

} else {
var statearr_15018_15110 = state_14938__$1;
(statearr_15018_15110[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (45))){
var inst_14768 = (state_14938[(12)]);
var state_14938__$1 = state_14938;
var statearr_15019_15111 = state_14938__$1;
(statearr_15019_15111[(2)] = inst_14768);

(statearr_15019_15111[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (53))){
var inst_14771 = (state_14938[(14)]);
var inst_14777 = (state_14938[(15)]);
var inst_14767 = (state_14938[(9)]);
var inst_14770 = (state_14938[(10)]);
var inst_14863 = (state_14938[(16)]);
var inst_14807 = (state_14938[(7)]);
var inst_14766 = (state_14938[(17)]);
var inst_14782 = (state_14938[(18)]);
var inst_14768 = (state_14938[(12)]);
var inst_14865 = (function (){var obj_fn = inst_14863;
var t = inst_14770;
var temp__5802__auto__ = inst_14863;
var vec__14763 = inst_14766;
var p = inst_14768;
var idx_predicate_QMARK_ = inst_14771;
var o = inst_14807;
var tag_predicate_QMARK_ = inst_14777;
var s = inst_14767;
var o_coerce_QMARK_ = inst_14782;
return (function (x){
var and__4251__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4251__auto__;
}
});
})();
var state_14938__$1 = state_14938;
var statearr_15020_15112 = state_14938__$1;
(statearr_15020_15112[(2)] = inst_14865);

(statearr_15020_15112[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (26))){
var inst_14767 = (state_14938[(9)]);
var inst_14770 = (state_14938[(10)]);
var inst_14811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14812 = [inst_14767,null,null,inst_14770];
var inst_14813 = (new cljs.core.PersistentVector(null,4,(5),inst_14811,inst_14812,null));
var inst_14814 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14813,opts);
var state_14938__$1 = state_14938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14938__$1,(29),inst_14814);
} else {
if((state_val_14939 === (16))){
var inst_14769 = (state_14938[(19)]);
var inst_14793 = typeof inst_14769 === 'string';
var state_14938__$1 = state_14938;
if(cljs.core.truth_(inst_14793)){
var statearr_15021_15113 = state_14938__$1;
(statearr_15021_15113[(1)] = (19));

} else {
var statearr_15022_15114 = state_14938__$1;
(statearr_15022_15114[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (38))){
var inst_14771 = (state_14938[(14)]);
var state_14938__$1 = state_14938;
var statearr_15023_15115 = state_14938__$1;
(statearr_15023_15115[(2)] = inst_14771);

(statearr_15023_15115[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (30))){
var inst_14824 = (state_14938[(2)]);
var inst_14825 = fluree.db.util.async.throw_err(inst_14824);
var state_14938__$1 = state_14938;
var statearr_15024_15116 = state_14938__$1;
(statearr_15024_15116[(2)] = inst_14825);

(statearr_15024_15116[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (73))){
var inst_14925 = (state_14938[(8)]);
var state_14938__$1 = state_14938;
var statearr_15025_15117 = state_14938__$1;
(statearr_15025_15117[(2)] = inst_14925);

(statearr_15025_15117[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (10))){
var inst_14777 = (state_14938[(15)]);
var state_14938__$1 = state_14938;
var statearr_15026_15118 = state_14938__$1;
(statearr_15026_15118[(2)] = inst_14777);

(statearr_15026_15118[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (18))){
var inst_14790 = (state_14938[(2)]);
var inst_14791 = fluree.db.util.async.throw_err(inst_14790);
var state_14938__$1 = state_14938;
var statearr_15027_15119 = state_14938__$1;
(statearr_15027_15119[(2)] = inst_14791);

(statearr_15027_15119[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (52))){
var inst_14921 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
var statearr_15028_15120 = state_14938__$1;
(statearr_15028_15120[(2)] = inst_14921);

(statearr_15028_15120[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (67))){
var inst_14904 = (state_14938[(2)]);
var inst_14905 = fluree.db.util.async.throw_err(inst_14904);
var state_14938__$1 = state_14938;
var statearr_15029_15121 = state_14938__$1;
(statearr_15029_15121[(2)] = inst_14905);

(statearr_15029_15121[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (71))){
var inst_14913 = (state_14938[(2)]);
var inst_14914 = fluree.db.util.async.throw_err(inst_14913);
var state_14938__$1 = state_14938;
var statearr_15030_15122 = state_14938__$1;
(statearr_15030_15122[(2)] = inst_14914);

(statearr_15030_15122[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (42))){
var inst_14923 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
var statearr_15031_15123 = state_14938__$1;
(statearr_15031_15123[(2)] = inst_14923);

(statearr_15031_15123[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (37))){
var inst_14807 = (state_14938[(7)]);
var inst_14833 = cljs.core.fn_QMARK_(inst_14807);
var inst_14834 = (!(inst_14833));
var state_14938__$1 = state_14938;
var statearr_15032_15124 = state_14938__$1;
(statearr_15032_15124[(2)] = inst_14834);

(statearr_15032_15124[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (63))){
var inst_14893 = (state_14938[(2)]);
var inst_14894 = fluree.db.util.async.throw_err(inst_14893);
var state_14938__$1 = state_14938;
var statearr_15033_15125 = state_14938__$1;
(statearr_15033_15125[(2)] = inst_14894);

(statearr_15033_15125[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (8))){
var inst_14777 = (state_14938[(15)]);
var inst_14777__$1 = (state_14938[(2)]);
var state_14938__$1 = (function (){var statearr_15034 = state_14938;
(statearr_15034[(15)] = inst_14777__$1);

return statearr_15034;
})();
if(cljs.core.truth_(inst_14777__$1)){
var statearr_15035_15126 = state_14938__$1;
(statearr_15035_15126[(1)] = (9));

} else {
var statearr_15036_15127 = state_14938__$1;
(statearr_15036_15127[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14939 === (49))){
var inst_14858 = (state_14938[(2)]);
var state_14938__$1 = state_14938;
var statearr_15037_15128 = state_14938__$1;
(statearr_15037_15128[(2)] = inst_14858);

(statearr_15037_15128[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15038 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15038[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15038[(1)] = (1));

return statearr_15038;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_14938){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14938);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15039){var ex__2730__auto__ = e15039;
var statearr_15040_15129 = state_14938;
(statearr_15040_15129[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14938[(4)]))){
var statearr_15041_15130 = state_14938;
(statearr_15041_15130[(1)] = cljs.core.first((state_14938[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15131 = state_14938;
state_14938 = G__15131;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_14938){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_14938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15042 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15042[(6)] = c__2749__auto__);

return statearr_15042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15133 = arguments.length;
switch (G__15133) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15168){
var state_val_15169 = (state_15168[(1)]);
if((state_val_15169 === (7))){
var inst_15155 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_15156 = ["Invalid collection name: ",inst_15155].join('');
var inst_15157 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15158 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15159 = cljs.core.PersistentHashMap.fromArrays(inst_15157,inst_15158);
var inst_15160 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15156,inst_15159);
var inst_15161 = (function(){throw inst_15160})();
var state_15168__$1 = state_15168;
var statearr_15170_15190 = state_15168__$1;
(statearr_15170_15190[(2)] = inst_15161);

(statearr_15170_15190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15169 === (1))){
var state_15168__$1 = state_15168;
var statearr_15171_15191 = state_15168__$1;
(statearr_15171_15191[(2)] = null);

(statearr_15171_15191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15169 === (4))){
var inst_15134 = (state_15168[(2)]);
var state_15168__$1 = state_15168;
var statearr_15172_15192 = state_15168__$1;
(statearr_15172_15192[(2)] = inst_15134);

(statearr_15172_15192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15169 === (6))){
var inst_15140 = (state_15168[(7)]);
var inst_15142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15143 = fluree.db.flake.max_subject_id(inst_15140);
var inst_15144 = [inst_15143];
var inst_15145 = (new cljs.core.PersistentVector(null,1,(5),inst_15142,inst_15144,null));
var inst_15146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15147 = fluree.db.flake.min_subject_id(inst_15140);
var inst_15148 = [inst_15147];
var inst_15149 = (new cljs.core.PersistentVector(null,1,(5),inst_15146,inst_15148,null));
var inst_15150 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15145,cljs.core._LT__EQ_,inst_15149,opts);
var state_15168__$1 = state_15168;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15168__$1,(9),inst_15150);
} else {
if((state_val_15169 === (3))){
var inst_15166 = (state_15168[(2)]);
var state_15168__$1 = state_15168;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15168__$1,inst_15166);
} else {
if((state_val_15169 === (2))){
var inst_15140 = (state_15168[(7)]);
var _ = (function (){var statearr_15174 = state_15168;
(statearr_15174[(4)] = cljs.core.cons((5),(state_15168[(4)])));

return statearr_15174;
})();
var inst_15140__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15168__$1 = (function (){var statearr_15175 = state_15168;
(statearr_15175[(7)] = inst_15140__$1);

return statearr_15175;
})();
if(cljs.core.truth_(inst_15140__$1)){
var statearr_15176_15193 = state_15168__$1;
(statearr_15176_15193[(1)] = (6));

} else {
var statearr_15177_15194 = state_15168__$1;
(statearr_15177_15194[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15169 === (9))){
var inst_15152 = (state_15168[(2)]);
var inst_15153 = fluree.db.util.async.throw_err(inst_15152);
var state_15168__$1 = state_15168;
var statearr_15178_15195 = state_15168__$1;
(statearr_15178_15195[(2)] = inst_15153);

(statearr_15178_15195[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15169 === (5))){
var _ = (function (){var statearr_15179 = state_15168;
(statearr_15179[(4)] = cljs.core.rest((state_15168[(4)])));

return statearr_15179;
})();
var state_15168__$1 = state_15168;
var ex15173 = (state_15168__$1[(2)]);
var statearr_15180_15196 = state_15168__$1;
(statearr_15180_15196[(5)] = ex15173);


var statearr_15181_15197 = state_15168__$1;
(statearr_15181_15197[(1)] = (4));

(statearr_15181_15197[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15169 === (8))){
var inst_15163 = (state_15168[(2)]);
var _ = (function (){var statearr_15182 = state_15168;
(statearr_15182[(4)] = cljs.core.rest((state_15168[(4)])));

return statearr_15182;
})();
var state_15168__$1 = state_15168;
var statearr_15183_15198 = state_15168__$1;
(statearr_15183_15198[(2)] = inst_15163);

(statearr_15183_15198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15184 = [null,null,null,null,null,null,null,null];
(statearr_15184[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15184[(1)] = (1));

return statearr_15184;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_15168){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15168);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15185){var ex__2730__auto__ = e15185;
var statearr_15186_15199 = state_15168;
(statearr_15186_15199[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15168[(4)]))){
var statearr_15187_15200 = state_15168;
(statearr_15187_15200[(1)] = cljs.core.first((state_15168[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15201 = state_15168;
state_15168 = G__15201;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_15168){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_15168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15188 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15188[(6)] = c__2749__auto__);

return statearr_15188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15205 = flakes;
var vec__15206 = G__15205;
var seq__15207 = cljs.core.seq(vec__15206);
var first__15208 = cljs.core.first(seq__15207);
var seq__15207__$1 = cljs.core.next(seq__15207);
var flake_SINGLEQUOTE_ = first__15208;
var r = seq__15207__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15205__$1 = G__15205;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15214 = G__15205__$1;
var seq__15215 = cljs.core.seq(vec__15214);
var first__15216 = cljs.core.first(seq__15215);
var seq__15215__$1 = cljs.core.next(seq__15215);
var flake_SINGLEQUOTE___$1 = first__15216;
var r__$1 = seq__15215__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = fluree.db.flake.o(flake_SINGLEQUOTE___$1);
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e15218){var e = e15218;
return null;
}})();
var map__15217 = cmd_map;
var map__15217__$1 = cljs.core.__destructure_map(map__15217);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15217__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15217__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15217__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15217__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15217__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15217__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15219 = r__$1;
var G__15220 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15205__$1 = G__15219;
result_STAR___$1 = G__15220;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15229 = blocks;
var vec__15230 = G__15229;
var seq__15231 = cljs.core.seq(vec__15230);
var first__15232 = cljs.core.first(seq__15231);
var seq__15231__$1 = cljs.core.next(seq__15231);
var block_SINGLEQUOTE_ = first__15232;
var r = seq__15231__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15229__$1 = G__15229;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15237 = G__15229__$1;
var seq__15238 = cljs.core.seq(vec__15237);
var first__15239 = cljs.core.first(seq__15238);
var seq__15238__$1 = cljs.core.next(seq__15238);
var block_SINGLEQUOTE___$1 = first__15239;
var r__$1 = seq__15238__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15240 = block_SINGLEQUOTE___$1;
var map__15240__$1 = cljs.core.__destructure_map(map__15240);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15240__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15240__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15240__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__15229__$1,result_STAR___$1,map__15240,map__15240__$1,block,t,flakes,vec__15237,seq__15238,first__15239,seq__15238__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15229,vec__15230,seq__15231,first__15232,seq__15231__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15221_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15221_SHARP_),(2))){
return fluree.db.flake.o(p1__15221_SHARP_);
} else {
return null;
}
});})(G__15229__$1,result_STAR___$1,map__15240,map__15240__$1,block,t,flakes,vec__15237,seq__15238,first__15239,seq__15238__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15229,vec__15230,seq__15231,first__15232,seq__15231__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__15229__$1,result_STAR___$1,map__15240,map__15240__$1,block,t,flakes,prev_hash,vec__15237,seq__15238,first__15239,seq__15238__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15229,vec__15230,seq__15231,first__15232,seq__15231__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15222_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15222_SHARP_),(1))){
return fluree.db.flake.o(p1__15222_SHARP_);
} else {
return null;
}
});})(G__15229__$1,result_STAR___$1,map__15240,map__15240__$1,block,t,flakes,prev_hash,vec__15237,seq__15238,first__15239,seq__15238__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15229,vec__15230,seq__15231,first__15232,seq__15231__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__15229__$1,result_STAR___$1,map__15240,map__15240__$1,block,t,flakes,prev_hash,hash,vec__15237,seq__15238,first__15239,seq__15238__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15229,vec__15230,seq__15231,first__15232,seq__15231__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15223_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15223_SHARP_),(5))){
return fluree.db.flake.o(p1__15223_SHARP_);
} else {
return null;
}
});})(G__15229__$1,result_STAR___$1,map__15240,map__15240__$1,block,t,flakes,prev_hash,hash,vec__15237,seq__15238,first__15239,seq__15238__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15229,vec__15230,seq__15231,first__15232,seq__15231__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__15229__$1,result_STAR___$1,map__15240,map__15240__$1,block,t,flakes,prev_hash,hash,instant,vec__15237,seq__15238,first__15239,seq__15238__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15229,vec__15230,seq__15231,first__15232,seq__15231__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15224_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15224_SHARP_),(7))){
return fluree.db.flake.o(p1__15224_SHARP_);
} else {
return null;
}
});})(G__15229__$1,result_STAR___$1,map__15240,map__15240__$1,block,t,flakes,prev_hash,hash,instant,vec__15237,seq__15238,first__15239,seq__15238__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15229,vec__15230,seq__15231,first__15232,seq__15231__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__15229__$1,result_STAR___$1,map__15240,map__15240__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15237,seq__15238,first__15239,seq__15238__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15229,vec__15230,seq__15231,first__15232,seq__15231__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15225_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15225_SHARP_),(106));
});})(G__15229__$1,result_STAR___$1,map__15240,map__15240__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15237,seq__15238,first__15239,seq__15238__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15229,vec__15230,seq__15231,first__15232,seq__15231__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__15241 = r__$1;
var G__15242 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15229__$1 = G__15241;
result_STAR___$1 = G__15242;
continue;
}
break;
}
});
