// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.legacy');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.spec');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
/**
 * Checks to see if the where clause has ' = ', ' > ', ' < ', ' <= ', or ' >= ', and returns true if yes
 */
fluree.db.query.subject_crawl.legacy.where_clause_valid_QMARK_ = (function fluree$db$query$subject_crawl$legacy$where_clause_valid_QMARK_(where_clause){
var and__4251__auto__ = typeof where_clause === 'string';
if(and__4251__auto__){
return cljs.core.re_find(/^.* (=|>|<|>=|<=|not=) .*$/,where_clause);
} else {
return and__4251__auto__;
}
});
/**
 * Returns a where clause spec based on a string where caluse.
 *   The spec can be applied to a specific db to coerce predicate names
 *   to predicate ids, validate types, and ultimately generate a filtering function.
 */
fluree.db.query.subject_crawl.legacy.parse_where_spec = (function fluree$db$query$subject_crawl$legacy$parse_where_spec(var_args){
var G__16685 = arguments.length;
switch (G__16685) {
case 1:
return fluree.db.query.subject_crawl.legacy.parse_where_spec.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.subject_crawl.legacy.parse_where_spec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.subject_crawl.legacy.parse_where_spec.cljs$core$IFn$_invoke$arity$1 = (function (where){
return fluree.db.query.subject_crawl.legacy.parse_where_spec.cljs$core$IFn$_invoke$arity$2(where,null);
}));

(fluree.db.query.subject_crawl.legacy.parse_where_spec.cljs$core$IFn$_invoke$arity$2 = (function (where,default_collection){
if(cljs.core.truth_(fluree.db.query.subject_crawl.legacy.where_clause_valid_QMARK_(where))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid where clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var and_QMARK_ = cljs.core.re_matches(/.+ AND .+/,where);
var or_QMARK_ = cljs.core.re_matches(/.+ OR .+/,where);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = and_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return or_QMARK_;
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Where clause can have either AND or OR operations, but not both currently: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
var where_type = (cljs.core.truth_(and_QMARK_)?new cljs.core.Keyword(null,"and","and",-971899817):(cljs.core.truth_(or_QMARK_)?new cljs.core.Keyword(null,"or","or",235744169):new cljs.core.Keyword(null,"and","and",-971899817)
));
var args = (function (){var G__16686 = where_type;
var G__16686__$1 = (((G__16686 instanceof cljs.core.Keyword))?G__16686.fqn:null);
switch (G__16686__$1) {
case "and":
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(where,/ AND /);

break;
case "or":
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(where,/ OR /);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__16686__$1)].join('')));

}
})();
var statements = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,arg){
var arg__$1 = clojure.string.trim(arg);
var vec__16687 = cljs.core.re_find(/^([^\s=><].+)[\s]+:?(=|>|<|>=|<=|not=)[\s]+:?(.+)$/,arg__$1);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16687,(0),null);
var pred_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16687,(1),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16687,(2),null);
var match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16687,(3),null);
var pred_name__$1 = ((fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(pred_name,false))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Reverse references cannot be used in a where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((clojure.string.includes_QMARK_(pred_name,"/"))?pred_name:(cljs.core.truth_(default_collection)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(default_collection),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_name)].join(''):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only full namespaced predicate\n                                         names can be used in a where clause. This can be\n                                         provided in a from clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var match_STAR_ = (function (){var temp__5802__auto__ = (function (){var or__4253__auto__ = cljs.core.re_find(/'(.*)'$/,match);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.re_find(/\"(.*)\"$/,match);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var match_str = temp__5802__auto__;
return cljs.core.second(match_str);
} else {
try{if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("true",match)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("false",match)){
return false;
} else {
if(clojure.string.includes_QMARK_(match,".")){
return parseFloat(match);
} else {
return parseInt(match);

}
}
}
}catch (e16690){var ___$2 = e16690;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid where clause in argument: ",arg__$1].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pred_name__$1,op,match_STAR_], null));
}),cljs.core.PersistentVector.EMPTY,args);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [where_type,statements], null);
}));

(fluree.db.query.subject_crawl.legacy.parse_where_spec.cljs$lang$maxFixedArity = 2);

fluree.db.query.subject_crawl.legacy.into_where = (function fluree$db$query$subject_crawl$legacy$into_where(where){
var vec__16693 = fluree.db.query.subject_crawl.legacy.parse_where_spec.cljs$core$IFn$_invoke$arity$1(where);
var where_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16693,(0),null);
var where_statements = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16693,(1),null);
var vars = cljs.core.volatile_BANG_((1));
var next_var = (function (){
return ["?__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(vars.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(vars.cljs$core$IDeref$_deref$arity$1(null) + (1))))].join('');
});
var where_STAR_ = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p__16696){
var vec__16697 = p__16696;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16697,(0),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16697,(1),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16697,(2),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("=",op)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s",pred,val], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s",pred,["#(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(op)," ",next_var()," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(val),")"].join('')], null);
}
}),where_statements);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),where_type)){
return where_STAR_;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"or","or",235744169),where_type)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"optional","optional",2053951509),where_STAR_], null)], null);
} else {
return null;
}
}
});
fluree.db.query.subject_crawl.legacy.basic_to_analytical_transpiler = (function fluree$db$query$subject_crawl$legacy$basic_to_analytical_transpiler(query_map){
var map__16700 = query_map;
var map__16700__$1 = cljs.core.__destructure_map(map__16700);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16700__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16700__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16700__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16700__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16700__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16700__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16700__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16700__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16700__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16700__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var selectKey = (cljs.core.truth_(select)?new cljs.core.Keyword(null,"select","select",1147833503):(cljs.core.truth_(selectOne)?new cljs.core.Keyword(null,"selectOne","selectOne",1588429876):(cljs.core.truth_(selectDistinct)?new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872):null)));
var select_smt = (function (){var or__4253__auto__ = select;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = selectOne;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return selectDistinct;
}
}
})();
var multi_subj = ((((cljs.core.sequential_QMARK_(from)) && (cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from))))?from:null);
var vars_STAR_ = (cljs.core.truth_(multi_subj)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(vars,"?__subj",from):vars);
var where_STAR_ = (cljs.core.truth_(multi_subj)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s","_id","?__subj"], null)], null):((typeof where === 'string')?(function (){var G__16701 = fluree.db.query.subject_crawl.legacy.into_where(where);
if(cljs.core.truth_(from)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s","rdf:type",from], null)], null),G__16701);
} else {
return G__16701;
}
})():((((typeof from === 'string') && (clojure.string.includes_QMARK_(from,"/"))))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s",from,"?o"], null)], null):((typeof from === 'string')?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s","rdf:type",from], null)], null):((typeof from === 'number')?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s","_id",from], null)], null):((fluree.db.util.core.pred_ident_QMARK_(from))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s",cljs.core.first(from),cljs.core.second(from)], null)], null):cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid 'from' in query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))
))))));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query_map,selectKey,new cljs.core.PersistentArrayMap(null, 1, ["?s",select_smt], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"where","where",-2044795965),where_STAR_,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars_STAR_], 0)),new cljs.core.Keyword(null,"from","from",1815293044));
});
