// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');

/**
 * @interface
 */
fluree.db.storage.core.Store = function(){};

var fluree$db$storage$core$Store$exists_QMARK_$dyn_23896 = (function (s,k){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.exists_QMARK_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__4551__auto__.call(null,s,k));
} else {
var m__4549__auto__ = (fluree.db.storage.core.exists_QMARK_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__4549__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.exists?",s);
}
}
});
/**
 * Returns true when `k` exists in `s`
 */
fluree.db.storage.core.exists_QMARK_ = (function fluree$db$storage$core$exists_QMARK_(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$exists_QMARK_$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$exists_QMARK_$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$exists_QMARK_$dyn_23896(s,k);
}
});

var fluree$db$storage$core$Store$list$dyn_23897 = (function (s,d){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.list[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(s,d) : m__4551__auto__.call(null,s,d));
} else {
var m__4549__auto__ = (fluree.db.storage.core.list["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(s,d) : m__4549__auto__.call(null,s,d));
} else {
throw cljs.core.missing_protocol("Store.list",s);
}
}
});
/**
 * Returns a collection containing the keys stored under the subdirectory/prefix `d` of `s`
 */
fluree.db.storage.core.list = (function fluree$db$storage$core$list(s,d){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$list$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$list$arity$2(s,d);
} else {
return fluree$db$storage$core$Store$list$dyn_23897(s,d);
}
});

var fluree$db$storage$core$Store$read$dyn_23898 = (function (s,k){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.read[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__4551__auto__.call(null,s,k));
} else {
var m__4549__auto__ = (fluree.db.storage.core.read["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__4549__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.read",s);
}
}
});
/**
 * Reads raw bytes from `s` associated with `k`
 */
fluree.db.storage.core.read = (function fluree$db$storage$core$read(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$read$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$read$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$read$dyn_23898(s,k);
}
});

var fluree$db$storage$core$Store$write$dyn_23899 = (function (s,k,data){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.write[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(s,k,data) : m__4551__auto__.call(null,s,k,data));
} else {
var m__4549__auto__ = (fluree.db.storage.core.write["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(s,k,data) : m__4549__auto__.call(null,s,k,data));
} else {
throw cljs.core.missing_protocol("Store.write",s);
}
}
});
/**
 * Writes `data` as raw bytes to `s` and associates it with `k`
 */
fluree.db.storage.core.write = (function fluree$db$storage$core$write(s,k,data){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$write$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$write$arity$3(s,k,data);
} else {
return fluree$db$storage$core$Store$write$dyn_23899(s,k,data);
}
});

var fluree$db$storage$core$Store$rename$dyn_23900 = (function (s,old_key,new_key){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.rename[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(s,old_key,new_key) : m__4551__auto__.call(null,s,old_key,new_key));
} else {
var m__4549__auto__ = (fluree.db.storage.core.rename["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(s,old_key,new_key) : m__4549__auto__.call(null,s,old_key,new_key));
} else {
throw cljs.core.missing_protocol("Store.rename",s);
}
}
});
/**
 * Remove `old-key` and associate its data to `new-key`
 */
fluree.db.storage.core.rename = (function fluree$db$storage$core$rename(s,old_key,new_key){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$rename$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$rename$arity$3(s,old_key,new_key);
} else {
return fluree$db$storage$core$Store$rename$dyn_23900(s,old_key,new_key);
}
});

var fluree$db$storage$core$Store$delete$dyn_23901 = (function (s,k){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.delete$[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__4551__auto__.call(null,s,k));
} else {
var m__4549__auto__ = (fluree.db.storage.core.delete$["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__4549__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.delete",s);
}
}
});
/**
 * Delete data associated with key `k`
 */
fluree.db.storage.core.delete$ = (function fluree$db$storage$core$delete(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$delete$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$delete$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$delete$dyn_23901(s,k);
}
});

/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_prefix = (function fluree$db$storage$core$ledger_garbage_prefix(network,ldgr_id){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("_",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ldgr_id,"garbage"], null));
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ldgr_id,block){
var pre = fluree.db.storage.core.ledger_garbage_prefix(network,ldgr_id);
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("_",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pre,block], null));
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23923){
var state_val_23924 = (state_23923[(1)]);
if((state_val_23924 === (7))){
var inst_23912 = (state_23923[(7)]);
var inst_23914 = fluree.db.storage.core.serde(conn);
var inst_23915 = fluree.db.serde.protocol._deserialize_block(inst_23914,inst_23912);
var state_23923__$1 = state_23923;
var statearr_23925_23944 = state_23923__$1;
(statearr_23925_23944[(2)] = inst_23915);

(statearr_23925_23944[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23924 === (1))){
var state_23923__$1 = state_23923;
var statearr_23926_23945 = state_23923__$1;
(statearr_23926_23945[(2)] = null);

(statearr_23926_23945[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23924 === (4))){
var inst_23902 = (state_23923[(2)]);
var state_23923__$1 = state_23923;
var statearr_23927_23946 = state_23923__$1;
(statearr_23927_23946[(2)] = inst_23902);

(statearr_23927_23946[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23924 === (6))){
var inst_23912 = (state_23923[(7)]);
var inst_23911 = (state_23923[(2)]);
var inst_23912__$1 = fluree.db.util.async.throw_err(inst_23911);
var state_23923__$1 = (function (){var statearr_23928 = state_23923;
(statearr_23928[(7)] = inst_23912__$1);

return statearr_23928;
})();
if(cljs.core.truth_(inst_23912__$1)){
var statearr_23929_23947 = state_23923__$1;
(statearr_23929_23947[(1)] = (7));

} else {
var statearr_23930_23948 = state_23923__$1;
(statearr_23930_23948[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23924 === (3))){
var inst_23921 = (state_23923[(2)]);
var state_23923__$1 = state_23923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23923__$1,inst_23921);
} else {
if((state_val_23924 === (2))){
var _ = (function (){var statearr_23932 = state_23923;
(statearr_23932[(4)] = cljs.core.cons((5),(state_23923[(4)])));

return statearr_23932;
})();
var inst_23908 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_23909 = fluree.db.storage.core.read(conn,inst_23908);
var state_23923__$1 = state_23923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23923__$1,(6),inst_23909);
} else {
if((state_val_23924 === (9))){
var inst_23918 = (state_23923[(2)]);
var _ = (function (){var statearr_23933 = state_23923;
(statearr_23933[(4)] = cljs.core.rest((state_23923[(4)])));

return statearr_23933;
})();
var state_23923__$1 = state_23923;
var statearr_23934_23949 = state_23923__$1;
(statearr_23934_23949[(2)] = inst_23918);

(statearr_23934_23949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23924 === (5))){
var _ = (function (){var statearr_23935 = state_23923;
(statearr_23935[(4)] = cljs.core.rest((state_23923[(4)])));

return statearr_23935;
})();
var state_23923__$1 = state_23923;
var ex23931 = (state_23923__$1[(2)]);
var statearr_23936_23950 = state_23923__$1;
(statearr_23936_23950[(5)] = ex23931);


if((ex23931 instanceof Error)){
var statearr_23937_23951 = state_23923__$1;
(statearr_23937_23951[(1)] = (4));

(statearr_23937_23951[(5)] = null);

} else {
throw ex23931;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23924 === (8))){
var state_23923__$1 = state_23923;
var statearr_23938_23952 = state_23923__$1;
(statearr_23938_23952[(2)] = null);

(statearr_23938_23952[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2727__auto____0 = (function (){
var statearr_23939 = [null,null,null,null,null,null,null,null];
(statearr_23939[(0)] = fluree$db$storage$core$read_block_$_state_machine__2727__auto__);

(statearr_23939[(1)] = (1));

return statearr_23939;
});
var fluree$db$storage$core$read_block_$_state_machine__2727__auto____1 = (function (state_23923){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23923);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23940){var ex__2730__auto__ = e23940;
var statearr_23941_23953 = state_23923;
(statearr_23941_23953[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23923[(4)]))){
var statearr_23942_23954 = state_23923;
(statearr_23942_23954[(1)] = cljs.core.first((state_23923[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23955 = state_23923;
state_23923 = G__23955;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2727__auto__ = function(state_23923){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2727__auto____1.call(this,state_23923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23943 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23943[(6)] = c__2749__auto__);

return statearr_23943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23978){
var state_val_23979 = (state_23978[(1)]);
if((state_val_23979 === (7))){
var inst_23967 = (state_23978[(7)]);
var inst_23969 = fluree.db.storage.core.serde(conn);
var inst_23970 = fluree.db.serde.protocol._deserialize_block(inst_23969,inst_23967);
var state_23978__$1 = state_23978;
var statearr_23980_23999 = state_23978__$1;
(statearr_23980_23999[(2)] = inst_23970);

(statearr_23980_23999[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23979 === (1))){
var state_23978__$1 = state_23978;
var statearr_23981_24000 = state_23978__$1;
(statearr_23981_24000[(2)] = null);

(statearr_23981_24000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23979 === (4))){
var inst_23956 = (state_23978[(2)]);
var state_23978__$1 = state_23978;
var statearr_23982_24001 = state_23978__$1;
(statearr_23982_24001[(2)] = inst_23956);

(statearr_23982_24001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23979 === (6))){
var inst_23967 = (state_23978[(7)]);
var inst_23966 = (state_23978[(2)]);
var inst_23967__$1 = fluree.db.util.async.throw_err(inst_23966);
var state_23978__$1 = (function (){var statearr_23983 = state_23978;
(statearr_23983[(7)] = inst_23967__$1);

return statearr_23983;
})();
if(cljs.core.truth_(inst_23967__$1)){
var statearr_23984_24002 = state_23978__$1;
(statearr_23984_24002[(1)] = (7));

} else {
var statearr_23985_24003 = state_23978__$1;
(statearr_23985_24003[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23979 === (3))){
var inst_23976 = (state_23978[(2)]);
var state_23978__$1 = state_23978;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23978__$1,inst_23976);
} else {
if((state_val_23979 === (2))){
var _ = (function (){var statearr_23987 = state_23978;
(statearr_23987[(4)] = cljs.core.cons((5),(state_23978[(4)])));

return statearr_23987;
})();
var inst_23962 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_23963 = [inst_23962,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_23964 = fluree.db.storage.core.read(conn,inst_23963);
var state_23978__$1 = state_23978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23978__$1,(6),inst_23964);
} else {
if((state_val_23979 === (9))){
var inst_23973 = (state_23978[(2)]);
var _ = (function (){var statearr_23988 = state_23978;
(statearr_23988[(4)] = cljs.core.rest((state_23978[(4)])));

return statearr_23988;
})();
var state_23978__$1 = state_23978;
var statearr_23989_24004 = state_23978__$1;
(statearr_23989_24004[(2)] = inst_23973);

(statearr_23989_24004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23979 === (5))){
var _ = (function (){var statearr_23990 = state_23978;
(statearr_23990[(4)] = cljs.core.rest((state_23978[(4)])));

return statearr_23990;
})();
var state_23978__$1 = state_23978;
var ex23986 = (state_23978__$1[(2)]);
var statearr_23991_24005 = state_23978__$1;
(statearr_23991_24005[(5)] = ex23986);


if((ex23986 instanceof Error)){
var statearr_23992_24006 = state_23978__$1;
(statearr_23992_24006[(1)] = (4));

(statearr_23992_24006[(5)] = null);

} else {
throw ex23986;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23979 === (8))){
var state_23978__$1 = state_23978;
var statearr_23993_24007 = state_23978__$1;
(statearr_23993_24007[(2)] = null);

(statearr_23993_24007[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0 = (function (){
var statearr_23994 = [null,null,null,null,null,null,null,null];
(statearr_23994[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__);

(statearr_23994[(1)] = (1));

return statearr_23994;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1 = (function (state_23978){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23978);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23995){var ex__2730__auto__ = e23995;
var statearr_23996_24008 = state_23978;
(statearr_23996_24008[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23978[(4)]))){
var statearr_23997_24009 = state_23978;
(statearr_23997_24009[(1)] = cljs.core.first((state_23978[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24010 = state_23978;
state_23978 = G__24010;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__ = function(state_23978){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1.call(this,state_23978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23998 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23998[(6)] = c__2749__auto__);

return statearr_23998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,ledger_id,block_data,version){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24034){
var state_val_24035 = (state_24034[(1)]);
if((state_val_24035 === (1))){
var state_24034__$1 = state_24034;
var statearr_24036_24050 = state_24034__$1;
(statearr_24036_24050[(2)] = null);

(statearr_24036_24050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24035 === (2))){
var _ = (function (){var statearr_24037 = state_24034;
(statearr_24037[(4)] = cljs.core.cons((5),(state_24034[(4)])));

return statearr_24037;
})();
var inst_24017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24018 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_24019 = (new cljs.core.PersistentVector(null,3,(5),inst_24017,inst_24018,null));
var inst_24020 = cljs.core.select_keys(block_data,inst_24019);
var inst_24021 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_24020);
var inst_24022 = fluree.db.storage.core.ledger_block_key(network,ledger_id,inst_24021);
var inst_24023 = [inst_24022,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_24024 = fluree.db.storage.core.serde(conn);
var inst_24025 = fluree.db.serde.protocol._serialize_block(inst_24024,inst_24020);
var inst_24026 = fluree.db.storage.core.write(conn,inst_24023,inst_24025);
var state_24034__$1 = state_24034;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24034__$1,(6),inst_24026);
} else {
if((state_val_24035 === (3))){
var inst_24032 = (state_24034[(2)]);
var state_24034__$1 = state_24034;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24034__$1,inst_24032);
} else {
if((state_val_24035 === (4))){
var inst_24011 = (state_24034[(2)]);
var state_24034__$1 = state_24034;
var statearr_24039_24051 = state_24034__$1;
(statearr_24039_24051[(2)] = inst_24011);

(statearr_24039_24051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24035 === (5))){
var _ = (function (){var statearr_24040 = state_24034;
(statearr_24040[(4)] = cljs.core.rest((state_24034[(4)])));

return statearr_24040;
})();
var state_24034__$1 = state_24034;
var ex24038 = (state_24034__$1[(2)]);
var statearr_24041_24052 = state_24034__$1;
(statearr_24041_24052[(5)] = ex24038);


if((ex24038 instanceof Error)){
var statearr_24042_24053 = state_24034__$1;
(statearr_24042_24053[(1)] = (4));

(statearr_24042_24053[(5)] = null);

} else {
throw ex24038;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24035 === (6))){
var inst_24028 = (state_24034[(2)]);
var inst_24029 = fluree.db.util.async.throw_err(inst_24028);
var _ = (function (){var statearr_24043 = state_24034;
(statearr_24043[(4)] = cljs.core.rest((state_24034[(4)])));

return statearr_24043;
})();
var state_24034__$1 = state_24034;
var statearr_24044_24054 = state_24034__$1;
(statearr_24044_24054[(2)] = inst_24029);

(statearr_24044_24054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0 = (function (){
var statearr_24045 = [null,null,null,null,null,null,null];
(statearr_24045[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__);

(statearr_24045[(1)] = (1));

return statearr_24045;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1 = (function (state_24034){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24034);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24046){var ex__2730__auto__ = e24046;
var statearr_24047_24055 = state_24034;
(statearr_24047_24055[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24034[(4)]))){
var statearr_24048_24056 = state_24034;
(statearr_24048_24056[(1)] = cljs.core.first((state_24034[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24057 = state_24034;
state_24034 = G__24057;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__ = function(state_24034){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1.call(this,state_24034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24049 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24049[(6)] = c__2749__auto__);

return statearr_24049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,ledger_id,block_data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24080){
var state_val_24081 = (state_24080[(1)]);
if((state_val_24081 === (1))){
var state_24080__$1 = state_24080;
var statearr_24082_24096 = state_24080__$1;
(statearr_24082_24096[(2)] = null);

(statearr_24082_24096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24081 === (2))){
var _ = (function (){var statearr_24083 = state_24080;
(statearr_24083[(4)] = cljs.core.cons((5),(state_24080[(4)])));

return statearr_24083;
})();
var inst_24064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24065 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_24066 = (new cljs.core.PersistentVector(null,3,(5),inst_24064,inst_24065,null));
var inst_24067 = cljs.core.select_keys(block_data,inst_24066);
var inst_24068 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_24067);
var inst_24069 = fluree.db.storage.core.ledger_block_key(network,ledger_id,inst_24068);
var inst_24070 = fluree.db.storage.core.serde(conn);
var inst_24071 = fluree.db.serde.protocol._serialize_block(inst_24070,inst_24067);
var inst_24072 = fluree.db.storage.core.write(conn,inst_24069,inst_24071);
var state_24080__$1 = state_24080;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24080__$1,(6),inst_24072);
} else {
if((state_val_24081 === (3))){
var inst_24078 = (state_24080[(2)]);
var state_24080__$1 = state_24080;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24080__$1,inst_24078);
} else {
if((state_val_24081 === (4))){
var inst_24058 = (state_24080[(2)]);
var state_24080__$1 = state_24080;
var statearr_24085_24097 = state_24080__$1;
(statearr_24085_24097[(2)] = inst_24058);

(statearr_24085_24097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24081 === (5))){
var _ = (function (){var statearr_24086 = state_24080;
(statearr_24086[(4)] = cljs.core.rest((state_24080[(4)])));

return statearr_24086;
})();
var state_24080__$1 = state_24080;
var ex24084 = (state_24080__$1[(2)]);
var statearr_24087_24098 = state_24080__$1;
(statearr_24087_24098[(5)] = ex24084);


if((ex24084 instanceof Error)){
var statearr_24088_24099 = state_24080__$1;
(statearr_24088_24099[(1)] = (4));

(statearr_24088_24099[(5)] = null);

} else {
throw ex24084;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24081 === (6))){
var inst_24074 = (state_24080[(2)]);
var inst_24075 = fluree.db.util.async.throw_err(inst_24074);
var _ = (function (){var statearr_24089 = state_24080;
(statearr_24089[(4)] = cljs.core.rest((state_24080[(4)])));

return statearr_24089;
})();
var state_24080__$1 = state_24080;
var statearr_24090_24100 = state_24080__$1;
(statearr_24090_24100[(2)] = inst_24075);

(statearr_24090_24100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2727__auto____0 = (function (){
var statearr_24091 = [null,null,null,null,null,null,null];
(statearr_24091[(0)] = fluree$db$storage$core$write_block_$_state_machine__2727__auto__);

(statearr_24091[(1)] = (1));

return statearr_24091;
});
var fluree$db$storage$core$write_block_$_state_machine__2727__auto____1 = (function (state_24080){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24080);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24092){var ex__2730__auto__ = e24092;
var statearr_24093_24101 = state_24080;
(statearr_24093_24101[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24080[(4)]))){
var statearr_24094_24102 = state_24080;
(statearr_24094_24102[(1)] = cljs.core.first((state_24080[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24103 = state_24080;
state_24080 = G__24103;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2727__auto__ = function(state_24080){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2727__auto____1.call(this,state_24080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24095 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24095[(6)] = c__2749__auto__);

return statearr_24095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into
 *   storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.random_leaf_id = (function fluree$db$storage$core$random_leaf_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key(network,ledger_id,idx,cljs.core.random_uuid(),"l");
});
/**
 * Writes `leaf` to storage under the provided `leaf-id`, computing a new id if
 *   one isn't provided. Returns the leaf map with the id used attached uner the
 *   `:id` key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(var_args){
var G__24105 = arguments.length;
switch (G__24105) {
case 5:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,leaf){
var leaf_id = fluree.db.storage.core.random_leaf_id(network,ledger_id,idx_type);
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6(conn,network,ledger_id,idx_type,leaf_id,leaf);
}));

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,leaf_id,p__24106){
var map__24107 = p__24106;
var map__24107__$1 = cljs.core.__destructure_map(map__24107);
var leaf = map__24107__$1;
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24107__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24128){
var state_val_24129 = (state_24128[(1)]);
if((state_val_24129 === (1))){
var state_24128__$1 = state_24128;
var statearr_24130_24146 = state_24128__$1;
(statearr_24130_24146[(2)] = null);

(statearr_24130_24146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24129 === (2))){
var _ = (function (){var statearr_24131 = state_24128;
(statearr_24131[(4)] = cljs.core.cons((5),(state_24128[(4)])));

return statearr_24131;
})();
var inst_24114 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_24115 = [flakes];
var inst_24116 = cljs.core.PersistentHashMap.fromArrays(inst_24114,inst_24115);
var inst_24117 = fluree.db.storage.core.serde(conn);
var inst_24118 = fluree.db.serde.protocol._serialize_leaf(inst_24117,inst_24116);
var inst_24119 = fluree.db.storage.core.write(conn,leaf_id,inst_24118);
var state_24128__$1 = state_24128;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24128__$1,(6),inst_24119);
} else {
if((state_val_24129 === (3))){
var inst_24126 = (state_24128[(2)]);
var state_24128__$1 = state_24128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24128__$1,inst_24126);
} else {
if((state_val_24129 === (4))){
var inst_24108 = (state_24128[(2)]);
var state_24128__$1 = state_24128;
var statearr_24133_24147 = state_24128__$1;
(statearr_24133_24147[(2)] = inst_24108);

(statearr_24133_24147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24129 === (5))){
var _ = (function (){var statearr_24134 = state_24128;
(statearr_24134[(4)] = cljs.core.rest((state_24128[(4)])));

return statearr_24134;
})();
var state_24128__$1 = state_24128;
var ex24132 = (state_24128__$1[(2)]);
var statearr_24135_24148 = state_24128__$1;
(statearr_24135_24148[(5)] = ex24132);


if((ex24132 instanceof Error)){
var statearr_24136_24149 = state_24128__$1;
(statearr_24136_24149[(1)] = (4));

(statearr_24136_24149[(5)] = null);

} else {
throw ex24132;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24129 === (6))){
var inst_24121 = (state_24128[(2)]);
var inst_24122 = fluree.db.util.async.throw_err(inst_24121);
var inst_24123 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(leaf,new cljs.core.Keyword(null,"id","id",-1388402092),leaf_id);
var _ = (function (){var statearr_24137 = state_24128;
(statearr_24137[(4)] = cljs.core.rest((state_24128[(4)])));

return statearr_24137;
})();
var state_24128__$1 = (function (){var statearr_24138 = state_24128;
(statearr_24138[(7)] = inst_24122);

return statearr_24138;
})();
var statearr_24139_24150 = state_24128__$1;
(statearr_24139_24150[(2)] = inst_24123);

(statearr_24139_24150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_24140 = [null,null,null,null,null,null,null,null];
(statearr_24140[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_24140[(1)] = (1));

return statearr_24140;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_24128){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24128);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24141){var ex__2730__auto__ = e24141;
var statearr_24142_24151 = state_24128;
(statearr_24142_24151[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24128[(4)]))){
var statearr_24143_24152 = state_24128;
(statearr_24143_24152[(1)] = cljs.core.first((state_24128[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24153 = state_24128;
state_24128 = G__24153;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_24128){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_24128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24144 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24144[(6)] = c__2749__auto__);

return statearr_24144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_leaf.cljs$lang$maxFixedArity = 6);

/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24170){
var state_val_24171 = (state_24170[(1)]);
if((state_val_24171 === (1))){
var state_24170__$1 = state_24170;
var statearr_24172_24187 = state_24170__$1;
(statearr_24172_24187[(2)] = null);

(statearr_24172_24187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24171 === (2))){
var _ = (function (){var statearr_24173 = state_24170;
(statearr_24173[(4)] = cljs.core.cons((5),(state_24170[(4)])));

return statearr_24173;
})();
var inst_24160 = fluree.db.storage.core.serde(conn);
var inst_24161 = fluree.db.serde.protocol._serialize_branch(inst_24160,data);
var inst_24162 = fluree.db.storage.core.write(conn,key,inst_24161);
var state_24170__$1 = state_24170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24170__$1,(6),inst_24162);
} else {
if((state_val_24171 === (3))){
var inst_24168 = (state_24170[(2)]);
var state_24170__$1 = state_24170;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24170__$1,inst_24168);
} else {
if((state_val_24171 === (4))){
var inst_24154 = (state_24170[(2)]);
var state_24170__$1 = state_24170;
var statearr_24175_24188 = state_24170__$1;
(statearr_24175_24188[(2)] = inst_24154);

(statearr_24175_24188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24171 === (5))){
var _ = (function (){var statearr_24176 = state_24170;
(statearr_24176[(4)] = cljs.core.rest((state_24170[(4)])));

return statearr_24176;
})();
var state_24170__$1 = state_24170;
var ex24174 = (state_24170__$1[(2)]);
var statearr_24177_24189 = state_24170__$1;
(statearr_24177_24189[(5)] = ex24174);


if((ex24174 instanceof Error)){
var statearr_24178_24190 = state_24170__$1;
(statearr_24178_24190[(1)] = (4));

(statearr_24178_24190[(5)] = null);

} else {
throw ex24174;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24171 === (6))){
var inst_24164 = (state_24170[(2)]);
var inst_24165 = fluree.db.util.async.throw_err(inst_24164);
var _ = (function (){var statearr_24179 = state_24170;
(statearr_24179[(4)] = cljs.core.rest((state_24170[(4)])));

return statearr_24179;
})();
var state_24170__$1 = (function (){var statearr_24180 = state_24170;
(statearr_24180[(7)] = inst_24165);

return statearr_24180;
})();
var statearr_24181_24191 = state_24170__$1;
(statearr_24181_24191[(2)] = key);

(statearr_24181_24191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0 = (function (){
var statearr_24182 = [null,null,null,null,null,null,null,null];
(statearr_24182[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__);

(statearr_24182[(1)] = (1));

return statearr_24182;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1 = (function (state_24170){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24170);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24183){var ex__2730__auto__ = e24183;
var statearr_24184_24192 = state_24170;
(statearr_24184_24192[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24170[(4)]))){
var statearr_24185_24193 = state_24170;
(statearr_24185_24193[(1)] = cljs.core.first((state_24170[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24194 = state_24170;
state_24170 = G__24194;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__ = function(state_24170){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1.call(this,state_24170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24186 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24186[(6)] = c__2749__auto__);

return statearr_24186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.random_branch_id = (function fluree$db$storage$core$random_branch_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key(network,ledger_id,idx,cljs.core.random_uuid(),"b");
});
/**
 * Writes `branch` to storage under the provided `branch-id`, computing a new id
 *   if one isn't provided. Returns the branch map with the id used attached uner
 *   the `:id` key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(var_args){
var G__24196 = arguments.length;
switch (G__24196) {
case 5:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,branch){
var branch_id = fluree.db.storage.core.random_branch_id(network,ledger_id,idx_type);
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6(conn,network,ledger_id,idx_type,branch_id,branch);
}));

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,branch_id,p__24197){
var map__24198 = p__24197;
var map__24198__$1 = cljs.core.__destructure_map(map__24198);
var branch = map__24198__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24198__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24224){
var state_val_24225 = (state_24224[(1)]);
if((state_val_24225 === (1))){
var state_24224__$1 = state_24224;
var statearr_24226_24243 = state_24224__$1;
(statearr_24226_24243[(2)] = null);

(statearr_24226_24243[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24225 === (2))){
var _ = (function (){var statearr_24227 = state_24224;
(statearr_24227[(4)] = cljs.core.cons((5),(state_24224[(4)])));

return statearr_24227;
})();
var inst_24205 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.val,children);
var inst_24206 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.storage.core.child_data,inst_24205);
var inst_24207 = cljs.core.first(inst_24206);
var inst_24208 = new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(inst_24207);
var inst_24209 = cljs.core.rseq(inst_24206);
var inst_24210 = cljs.core.first(inst_24209);
var inst_24211 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_24210);
var inst_24212 = [new cljs.core.Keyword(null,"children","children",-940561982)];
var inst_24213 = [inst_24206];
var inst_24214 = cljs.core.PersistentHashMap.fromArrays(inst_24212,inst_24213);
var inst_24215 = fluree.db.storage.core.write_branch_data(conn,branch_id,inst_24214);
var state_24224__$1 = (function (){var statearr_24228 = state_24224;
(statearr_24228[(7)] = inst_24211);

(statearr_24228[(8)] = inst_24208);

return statearr_24228;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24224__$1,(6),inst_24215);
} else {
if((state_val_24225 === (3))){
var inst_24222 = (state_24224[(2)]);
var state_24224__$1 = state_24224;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24224__$1,inst_24222);
} else {
if((state_val_24225 === (4))){
var inst_24199 = (state_24224[(2)]);
var state_24224__$1 = state_24224;
var statearr_24230_24244 = state_24224__$1;
(statearr_24230_24244[(2)] = inst_24199);

(statearr_24230_24244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24225 === (5))){
var _ = (function (){var statearr_24231 = state_24224;
(statearr_24231[(4)] = cljs.core.rest((state_24224[(4)])));

return statearr_24231;
})();
var state_24224__$1 = state_24224;
var ex24229 = (state_24224__$1[(2)]);
var statearr_24232_24245 = state_24224__$1;
(statearr_24232_24245[(5)] = ex24229);


if((ex24229 instanceof Error)){
var statearr_24233_24246 = state_24224__$1;
(statearr_24233_24246[(1)] = (4));

(statearr_24233_24246[(5)] = null);

} else {
throw ex24229;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24225 === (6))){
var inst_24217 = (state_24224[(2)]);
var inst_24218 = fluree.db.util.async.throw_err(inst_24217);
var inst_24219 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(branch,new cljs.core.Keyword(null,"id","id",-1388402092),branch_id);
var _ = (function (){var statearr_24234 = state_24224;
(statearr_24234[(4)] = cljs.core.rest((state_24224[(4)])));

return statearr_24234;
})();
var state_24224__$1 = (function (){var statearr_24235 = state_24224;
(statearr_24235[(9)] = inst_24218);

return statearr_24235;
})();
var statearr_24236_24247 = state_24224__$1;
(statearr_24236_24247[(2)] = inst_24219);

(statearr_24236_24247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_24237 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24237[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_24237[(1)] = (1));

return statearr_24237;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_24224){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24224);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24238){var ex__2730__auto__ = e24238;
var statearr_24239_24248 = state_24224;
(statearr_24239_24248[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24224[(4)]))){
var statearr_24240_24249 = state_24224;
(statearr_24240_24249[(1)] = cljs.core.first((state_24224[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24250 = state_24224;
state_24224 = G__24250;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_24224){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_24224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24241 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24241[(6)] = c__2749__auto__);

return statearr_24241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_branch.cljs$lang$maxFixedArity = 6);

/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,garbage){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24278){
var state_val_24279 = (state_24278[(1)]);
if((state_val_24279 === (1))){
var state_24278__$1 = state_24278;
var statearr_24280_24296 = state_24278__$1;
(statearr_24280_24296[(2)] = null);

(statearr_24280_24296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (2))){
var inst_24264 = (state_24278[(7)]);
var _ = (function (){var statearr_24281 = state_24278;
(statearr_24281[(4)] = cljs.core.cons((5),(state_24278[(4)])));

return statearr_24281;
})();
var inst_24258 = db;
var inst_24259 = cljs.core.__destructure_map(inst_24258);
var inst_24260 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24259,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_24261 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24259,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_24262 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24259,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_24263 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24259,new cljs.core.Keyword(null,"block","block",664686210));
var inst_24264__$1 = fluree.db.storage.core.ledger_garbage_key(inst_24261,inst_24262,inst_24263);
var inst_24265 = [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_24266 = [inst_24262,inst_24263,garbage];
var inst_24267 = cljs.core.PersistentHashMap.fromArrays(inst_24265,inst_24266);
var inst_24268 = fluree.db.storage.core.serde(inst_24260);
var inst_24269 = fluree.db.serde.protocol._serialize_garbage(inst_24268,inst_24267);
var inst_24270 = fluree.db.storage.core.write(inst_24260,inst_24264__$1,inst_24269);
var state_24278__$1 = (function (){var statearr_24282 = state_24278;
(statearr_24282[(7)] = inst_24264__$1);

return statearr_24282;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24278__$1,(6),inst_24270);
} else {
if((state_val_24279 === (3))){
var inst_24276 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24278__$1,inst_24276);
} else {
if((state_val_24279 === (4))){
var inst_24251 = (state_24278[(2)]);
var state_24278__$1 = state_24278;
var statearr_24284_24297 = state_24278__$1;
(statearr_24284_24297[(2)] = inst_24251);

(statearr_24284_24297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (5))){
var _ = (function (){var statearr_24285 = state_24278;
(statearr_24285[(4)] = cljs.core.rest((state_24278[(4)])));

return statearr_24285;
})();
var state_24278__$1 = state_24278;
var ex24283 = (state_24278__$1[(2)]);
var statearr_24286_24298 = state_24278__$1;
(statearr_24286_24298[(5)] = ex24283);


if((ex24283 instanceof Error)){
var statearr_24287_24299 = state_24278__$1;
(statearr_24287_24299[(1)] = (4));

(statearr_24287_24299[(5)] = null);

} else {
throw ex24283;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24279 === (6))){
var inst_24264 = (state_24278[(7)]);
var inst_24272 = (state_24278[(2)]);
var inst_24273 = fluree.db.util.async.throw_err(inst_24272);
var _ = (function (){var statearr_24288 = state_24278;
(statearr_24288[(4)] = cljs.core.rest((state_24278[(4)])));

return statearr_24288;
})();
var state_24278__$1 = (function (){var statearr_24289 = state_24278;
(statearr_24289[(8)] = inst_24273);

return statearr_24289;
})();
var statearr_24290_24300 = state_24278__$1;
(statearr_24290_24300[(2)] = inst_24264);

(statearr_24290_24300[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0 = (function (){
var statearr_24291 = [null,null,null,null,null,null,null,null,null];
(statearr_24291[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__);

(statearr_24291[(1)] = (1));

return statearr_24291;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1 = (function (state_24278){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24278);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24292){var ex__2730__auto__ = e24292;
var statearr_24293_24301 = state_24278;
(statearr_24293_24301[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24278[(4)]))){
var statearr_24294_24302 = state_24278;
(statearr_24294_24302[(1)] = cljs.core.first((state_24278[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24303 = state_24278;
state_24278 = G__24303;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__ = function(state_24278){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1.call(this,state_24278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24295 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24295[(6)] = c__2749__auto__);

return statearr_24295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__24305 = arguments.length;
switch (G__24305) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24363){
var state_val_24364 = (state_24363[(1)]);
if((state_val_24364 === (7))){
var state_24363__$1 = state_24363;
var statearr_24365_24391 = state_24363__$1;
(statearr_24365_24391[(2)] = (0));

(statearr_24365_24391[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24364 === (1))){
var state_24363__$1 = state_24363;
var statearr_24366_24392 = state_24363__$1;
(statearr_24366_24392[(2)] = null);

(statearr_24366_24392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24364 === (4))){
var inst_24306 = (state_24363[(2)]);
var state_24363__$1 = state_24363;
var statearr_24367_24393 = state_24363__$1;
(statearr_24367_24393[(2)] = inst_24306);

(statearr_24367_24393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24364 === (6))){
var inst_24332 = (state_24363[(7)]);
var state_24363__$1 = state_24363;
var statearr_24368_24394 = state_24363__$1;
(statearr_24368_24394[(2)] = inst_24332);

(statearr_24368_24394[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24364 === (3))){
var inst_24361 = (state_24363[(2)]);
var state_24363__$1 = state_24363;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24363__$1,inst_24361);
} else {
if((state_val_24364 === (12))){
var inst_24329 = (state_24363[(8)]);
var inst_24357 = (state_24363[(2)]);
var inst_24358 = fluree.db.util.async.throw_err(inst_24357);
var _ = (function (){var statearr_24369 = state_24363;
(statearr_24369[(4)] = cljs.core.rest((state_24363[(4)])));

return statearr_24369;
})();
var state_24363__$1 = (function (){var statearr_24370 = state_24363;
(statearr_24370[(9)] = inst_24358);

return statearr_24370;
})();
var statearr_24371_24395 = state_24363__$1;
(statearr_24371_24395[(2)] = inst_24329);

(statearr_24371_24395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24364 === (2))){
var inst_24324 = (state_24363[(10)]);
var inst_24319 = (state_24363[(11)]);
var inst_24332 = (state_24363[(7)]);
var inst_24321 = (state_24363[(12)]);
var _ = (function (){var statearr_24372 = state_24363;
(statearr_24372[(4)] = cljs.core.cons((5),(state_24363[(4)])));

return statearr_24372;
})();
var inst_24313 = db;
var inst_24314 = cljs.core.__destructure_map(inst_24313);
var inst_24315 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24314,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_24316 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24314,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_24317 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24314,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_24318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24314,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_24319__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24314,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_24320 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24314,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_24321__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24314,new cljs.core.Keyword(null,"block","block",664686210));
var inst_24322 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24314,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_24323 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24314,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var inst_24324__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24314,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_24325 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24314,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_24326 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24314,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_24327 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24314,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_24328 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24314,new cljs.core.Keyword(null,"post","post",269697687));
var inst_24329 = fluree.db.storage.core.ledger_root_key(inst_24315,inst_24324__$1,inst_24321__$1);
var inst_24330 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_24331 = fluree.db.storage.core.child_data(inst_24322);
var inst_24332__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_24319__$1);
var state_24363__$1 = (function (){var statearr_24373 = state_24363;
(statearr_24373[(13)] = inst_24320);

(statearr_24373[(14)] = inst_24327);

(statearr_24373[(15)] = inst_24318);

(statearr_24373[(10)] = inst_24324__$1);

(statearr_24373[(16)] = inst_24325);

(statearr_24373[(17)] = inst_24331);

(statearr_24373[(11)] = inst_24319__$1);

(statearr_24373[(18)] = inst_24328);

(statearr_24373[(8)] = inst_24329);

(statearr_24373[(19)] = inst_24326);

(statearr_24373[(7)] = inst_24332__$1);

(statearr_24373[(20)] = inst_24330);

(statearr_24373[(21)] = inst_24317);

(statearr_24373[(12)] = inst_24321__$1);

(statearr_24373[(22)] = inst_24323);

(statearr_24373[(23)] = inst_24316);

return statearr_24373;
})();
if(cljs.core.truth_(inst_24332__$1)){
var statearr_24374_24396 = state_24363__$1;
(statearr_24374_24396[(1)] = (6));

} else {
var statearr_24375_24397 = state_24363__$1;
(statearr_24375_24397[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24364 === (11))){
var inst_24320 = (state_24363[(13)]);
var inst_24327 = (state_24363[(14)]);
var inst_24318 = (state_24363[(15)]);
var inst_24324 = (state_24363[(10)]);
var inst_24337 = (state_24363[(24)]);
var inst_24331 = (state_24363[(17)]);
var inst_24319 = (state_24363[(11)]);
var inst_24328 = (state_24363[(18)]);
var inst_24329 = (state_24363[(8)]);
var inst_24326 = (state_24363[(19)]);
var inst_24336 = (state_24363[(25)]);
var inst_24330 = (state_24363[(20)]);
var inst_24317 = (state_24363[(21)]);
var inst_24321 = (state_24363[(12)]);
var inst_24316 = (state_24363[(23)]);
var inst_24342 = (state_24363[(2)]);
var inst_24343 = fluree.db.storage.core.child_data(inst_24326);
var inst_24344 = fluree.db.storage.core.child_data(inst_24328);
var inst_24345 = fluree.db.util.core.current_time_millis();
var inst_24346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24347 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_24348 = (new cljs.core.PersistentVector(null,2,(5),inst_24346,inst_24347,null));
var inst_24349 = cljs.core.select_keys(inst_24319,inst_24348);
var inst_24350 = fluree.db.storage.core.child_data(inst_24318);
var inst_24351 = [inst_24321,inst_24331,inst_24336,inst_24324,inst_24337,inst_24342,inst_24343,inst_24344,inst_24316,inst_24345,inst_24317,inst_24327,inst_24349,inst_24350];
var inst_24352 = cljs.core.PersistentHashMap.fromArrays(inst_24330,inst_24351);
var inst_24353 = fluree.db.storage.core.serde(inst_24320);
var inst_24354 = fluree.db.serde.protocol._serialize_db_root(inst_24353,inst_24352);
var inst_24355 = fluree.db.storage.core.write(inst_24320,inst_24329,inst_24354);
var state_24363__$1 = state_24363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24363__$1,(12),inst_24355);
} else {
if((state_val_24364 === (9))){
var inst_24338 = (state_24363[(26)]);
var state_24363__$1 = state_24363;
var statearr_24377_24398 = state_24363__$1;
(statearr_24377_24398[(2)] = inst_24338);

(statearr_24377_24398[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24364 === (5))){
var _ = (function (){var statearr_24378 = state_24363;
(statearr_24378[(4)] = cljs.core.rest((state_24363[(4)])));

return statearr_24378;
})();
var state_24363__$1 = state_24363;
var ex24376 = (state_24363__$1[(2)]);
var statearr_24379_24399 = state_24363__$1;
(statearr_24379_24399[(5)] = ex24376);


if((ex24376 instanceof Error)){
var statearr_24380_24400 = state_24363__$1;
(statearr_24380_24400[(1)] = (4));

(statearr_24380_24400[(5)] = null);

} else {
throw ex24376;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24364 === (10))){
var inst_24325 = (state_24363[(16)]);
var state_24363__$1 = state_24363;
var statearr_24381_24401 = state_24363__$1;
(statearr_24381_24401[(2)] = inst_24325);

(statearr_24381_24401[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24364 === (8))){
var inst_24323 = (state_24363[(22)]);
var inst_24338 = (state_24363[(26)]);
var inst_24336 = (state_24363[(2)]);
var inst_24337 = fluree.db.storage.core.child_data(inst_24323);
var inst_24338__$1 = custom_ecount;
var state_24363__$1 = (function (){var statearr_24382 = state_24363;
(statearr_24382[(24)] = inst_24337);

(statearr_24382[(25)] = inst_24336);

(statearr_24382[(26)] = inst_24338__$1);

return statearr_24382;
})();
if(cljs.core.truth_(inst_24338__$1)){
var statearr_24383_24402 = state_24363__$1;
(statearr_24383_24402[(1)] = (9));

} else {
var statearr_24384_24403 = state_24363__$1;
(statearr_24384_24403[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_24385 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24385[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_24385[(1)] = (1));

return statearr_24385;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_24363){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24363);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24386){var ex__2730__auto__ = e24386;
var statearr_24387_24404 = state_24363;
(statearr_24387_24404[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24363[(4)]))){
var statearr_24388_24405 = state_24363;
(statearr_24388_24405[(1)] = cljs.core.first((state_24363[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24406 = state_24363;
state_24363 = G__24406;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_24363){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_24363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24389 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24389[(6)] = c__2749__auto__);

return statearr_24389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(p__24407,key){
var map__24408 = p__24407;
var map__24408__$1 = cljs.core.__destructure_map(map__24408);
var conn = map__24408__$1;
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24408__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24428){
var state_val_24429 = (state_24428[(1)]);
if((state_val_24429 === (7))){
var inst_24418 = (state_24428[(7)]);
var inst_24420 = fluree.db.serde.protocol._deserialize_branch(serializer,inst_24418);
var state_24428__$1 = state_24428;
var statearr_24430_24449 = state_24428__$1;
(statearr_24430_24449[(2)] = inst_24420);

(statearr_24430_24449[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24429 === (1))){
var state_24428__$1 = state_24428;
var statearr_24431_24450 = state_24428__$1;
(statearr_24431_24450[(2)] = null);

(statearr_24431_24450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24429 === (4))){
var inst_24409 = (state_24428[(2)]);
var state_24428__$1 = state_24428;
var statearr_24432_24451 = state_24428__$1;
(statearr_24432_24451[(2)] = inst_24409);

(statearr_24432_24451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24429 === (6))){
var inst_24418 = (state_24428[(7)]);
var inst_24417 = (state_24428[(2)]);
var inst_24418__$1 = fluree.db.util.async.throw_err(inst_24417);
var state_24428__$1 = (function (){var statearr_24433 = state_24428;
(statearr_24433[(7)] = inst_24418__$1);

return statearr_24433;
})();
if(cljs.core.truth_(inst_24418__$1)){
var statearr_24434_24452 = state_24428__$1;
(statearr_24434_24452[(1)] = (7));

} else {
var statearr_24435_24453 = state_24428__$1;
(statearr_24435_24453[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24429 === (3))){
var inst_24426 = (state_24428[(2)]);
var state_24428__$1 = state_24428;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24428__$1,inst_24426);
} else {
if((state_val_24429 === (2))){
var _ = (function (){var statearr_24437 = state_24428;
(statearr_24437[(4)] = cljs.core.cons((5),(state_24428[(4)])));

return statearr_24437;
})();
var inst_24415 = fluree.db.storage.core.read(conn,key);
var state_24428__$1 = state_24428;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24428__$1,(6),inst_24415);
} else {
if((state_val_24429 === (9))){
var inst_24423 = (state_24428[(2)]);
var _ = (function (){var statearr_24438 = state_24428;
(statearr_24438[(4)] = cljs.core.rest((state_24428[(4)])));

return statearr_24438;
})();
var state_24428__$1 = state_24428;
var statearr_24439_24454 = state_24428__$1;
(statearr_24439_24454[(2)] = inst_24423);

(statearr_24439_24454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24429 === (5))){
var _ = (function (){var statearr_24440 = state_24428;
(statearr_24440[(4)] = cljs.core.rest((state_24428[(4)])));

return statearr_24440;
})();
var state_24428__$1 = state_24428;
var ex24436 = (state_24428__$1[(2)]);
var statearr_24441_24455 = state_24428__$1;
(statearr_24441_24455[(5)] = ex24436);


if((ex24436 instanceof Error)){
var statearr_24442_24456 = state_24428__$1;
(statearr_24442_24456[(1)] = (4));

(statearr_24442_24456[(5)] = null);

} else {
throw ex24436;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24429 === (8))){
var state_24428__$1 = state_24428;
var statearr_24443_24457 = state_24428__$1;
(statearr_24443_24457[(2)] = null);

(statearr_24443_24457[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0 = (function (){
var statearr_24444 = [null,null,null,null,null,null,null,null];
(statearr_24444[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2727__auto__);

(statearr_24444[(1)] = (1));

return statearr_24444;
});
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1 = (function (state_24428){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24428);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24445){var ex__2730__auto__ = e24445;
var statearr_24446_24458 = state_24428;
(statearr_24446_24458[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24428[(4)]))){
var statearr_24447_24459 = state_24428;
(statearr_24447_24459[(1)] = cljs.core.first((state_24428[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24460 = state_24428;
state_24428 = G__24460;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__ = function(state_24428){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1.call(this,state_24428);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24448 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24448[(6)] = c__2749__auto__);

return statearr_24448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(p__24461,key){
var map__24462 = p__24461;
var map__24462__$1 = cljs.core.__destructure_map(map__24462);
var conn = map__24462__$1;
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24462__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24482){
var state_val_24483 = (state_24482[(1)]);
if((state_val_24483 === (7))){
var inst_24472 = (state_24482[(7)]);
var inst_24474 = fluree.db.serde.protocol._deserialize_leaf(serializer,inst_24472);
var state_24482__$1 = state_24482;
var statearr_24484_24503 = state_24482__$1;
(statearr_24484_24503[(2)] = inst_24474);

(statearr_24484_24503[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (1))){
var state_24482__$1 = state_24482;
var statearr_24485_24504 = state_24482__$1;
(statearr_24485_24504[(2)] = null);

(statearr_24485_24504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (4))){
var inst_24463 = (state_24482[(2)]);
var state_24482__$1 = state_24482;
var statearr_24486_24505 = state_24482__$1;
(statearr_24486_24505[(2)] = inst_24463);

(statearr_24486_24505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (6))){
var inst_24472 = (state_24482[(7)]);
var inst_24471 = (state_24482[(2)]);
var inst_24472__$1 = fluree.db.util.async.throw_err(inst_24471);
var state_24482__$1 = (function (){var statearr_24487 = state_24482;
(statearr_24487[(7)] = inst_24472__$1);

return statearr_24487;
})();
if(cljs.core.truth_(inst_24472__$1)){
var statearr_24488_24506 = state_24482__$1;
(statearr_24488_24506[(1)] = (7));

} else {
var statearr_24489_24507 = state_24482__$1;
(statearr_24489_24507[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (3))){
var inst_24480 = (state_24482[(2)]);
var state_24482__$1 = state_24482;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24482__$1,inst_24480);
} else {
if((state_val_24483 === (2))){
var _ = (function (){var statearr_24491 = state_24482;
(statearr_24491[(4)] = cljs.core.cons((5),(state_24482[(4)])));

return statearr_24491;
})();
var inst_24469 = fluree.db.storage.core.read(conn,key);
var state_24482__$1 = state_24482;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24482__$1,(6),inst_24469);
} else {
if((state_val_24483 === (9))){
var inst_24477 = (state_24482[(2)]);
var _ = (function (){var statearr_24492 = state_24482;
(statearr_24492[(4)] = cljs.core.rest((state_24482[(4)])));

return statearr_24492;
})();
var state_24482__$1 = state_24482;
var statearr_24493_24508 = state_24482__$1;
(statearr_24493_24508[(2)] = inst_24477);

(statearr_24493_24508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (5))){
var _ = (function (){var statearr_24494 = state_24482;
(statearr_24494[(4)] = cljs.core.rest((state_24482[(4)])));

return statearr_24494;
})();
var state_24482__$1 = state_24482;
var ex24490 = (state_24482__$1[(2)]);
var statearr_24495_24509 = state_24482__$1;
(statearr_24495_24509[(5)] = ex24490);


if((ex24490 instanceof Error)){
var statearr_24496_24510 = state_24482__$1;
(statearr_24496_24510[(1)] = (4));

(statearr_24496_24510[(5)] = null);

} else {
throw ex24490;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (8))){
var state_24482__$1 = state_24482;
var statearr_24497_24511 = state_24482__$1;
(statearr_24497_24511[(2)] = null);

(statearr_24497_24511[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_24498 = [null,null,null,null,null,null,null,null];
(statearr_24498[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__);

(statearr_24498[(1)] = (1));

return statearr_24498;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1 = (function (state_24482){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24482);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24499){var ex__2730__auto__ = e24499;
var statearr_24500_24512 = state_24482;
(statearr_24500_24512[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24482[(4)]))){
var statearr_24501_24513 = state_24482;
(statearr_24501_24513[(1)] = cljs.core.first((state_24482[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24514 = state_24482;
state_24482 = G__24514;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__ = function(state_24482){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1.call(this,state_24482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24502 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24502[(6)] = c__2749__auto__);

return statearr_24502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(_conn,p__24515,index,index_data){
var map__24516 = p__24515;
var map__24516__$1 = cljs.core.__destructure_map(map__24516);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24516__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24516__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var comparators = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24516__$1,new cljs.core.Keyword(null,"comparators","comparators",-1325611955));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24516__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24516__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var cmp = (function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(comparators,index);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db index root: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
var G__24517 = index_data;
var G__24517__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__24517,new cljs.core.Keyword(null,"rhs","rhs",-229356739),fluree.db.flake.parts__GT_Flake):G__24517);
var G__24517__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__24517__$1,new cljs.core.Keyword(null,"first","first",-644103046),fluree.db.flake.parts__GT_Flake):G__24517__$1);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__24517__$2,new cljs.core.Keyword(null,"comparator","comparator",2144896662),cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0));

});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__24518 = root_data;
var map__24518__$1 = cljs.core.__destructure_map(map__24518);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24518__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24518__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24518__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24518__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
var idx_root = fluree.db.storage.core.reify_index_root(conn,db,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,idx_root);
}),db_STAR_,fluree.db.index.types);
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24540){
var state_val_24541 = (state_24540[(1)]);
if((state_val_24541 === (7))){
var state_24540__$1 = state_24540;
var statearr_24542_24562 = state_24540__$1;
(statearr_24542_24562[(2)] = null);

(statearr_24542_24562[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24541 === (1))){
var state_24540__$1 = state_24540;
var statearr_24543_24563 = state_24540__$1;
(statearr_24543_24563[(2)] = null);

(statearr_24543_24563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24541 === (4))){
var inst_24519 = (state_24540[(2)]);
var state_24540__$1 = state_24540;
var statearr_24544_24564 = state_24540__$1;
(statearr_24544_24564[(2)] = inst_24519);

(statearr_24544_24564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24541 === (6))){
var inst_24526 = (state_24540[(7)]);
var inst_24528 = fluree.db.storage.core.serde(conn);
var state_24540__$1 = (function (){var statearr_24545 = state_24540;
(statearr_24545[(8)] = inst_24528);

return statearr_24545;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24540__$1,(9),inst_24526);
} else {
if((state_val_24541 === (3))){
var inst_24538 = (state_24540[(2)]);
var state_24540__$1 = state_24540;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24540__$1,inst_24538);
} else {
if((state_val_24541 === (2))){
var inst_24526 = (state_24540[(7)]);
var _ = (function (){var statearr_24547 = state_24540;
(statearr_24547[(4)] = cljs.core.cons((5),(state_24540[(4)])));

return statearr_24547;
})();
var inst_24525 = fluree.db.storage.core.ledger_garbage_key(network,ledger_id,block);
var inst_24526__$1 = fluree.db.storage.core.read(conn,inst_24525);
var state_24540__$1 = (function (){var statearr_24548 = state_24540;
(statearr_24548[(7)] = inst_24526__$1);

return statearr_24548;
})();
if(cljs.core.truth_(inst_24526__$1)){
var statearr_24549_24565 = state_24540__$1;
(statearr_24549_24565[(1)] = (6));

} else {
var statearr_24550_24566 = state_24540__$1;
(statearr_24550_24566[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24541 === (9))){
var inst_24528 = (state_24540[(8)]);
var inst_24530 = (state_24540[(2)]);
var inst_24531 = fluree.db.util.async.throw_err(inst_24530);
var inst_24532 = fluree.db.serde.protocol._deserialize_garbage(inst_24528,inst_24531);
var state_24540__$1 = state_24540;
var statearr_24551_24567 = state_24540__$1;
(statearr_24551_24567[(2)] = inst_24532);

(statearr_24551_24567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24541 === (5))){
var _ = (function (){var statearr_24552 = state_24540;
(statearr_24552[(4)] = cljs.core.rest((state_24540[(4)])));

return statearr_24552;
})();
var state_24540__$1 = state_24540;
var ex24546 = (state_24540__$1[(2)]);
var statearr_24553_24568 = state_24540__$1;
(statearr_24553_24568[(5)] = ex24546);


if((ex24546 instanceof Error)){
var statearr_24554_24569 = state_24540__$1;
(statearr_24554_24569[(1)] = (4));

(statearr_24554_24569[(5)] = null);

} else {
throw ex24546;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24541 === (8))){
var inst_24535 = (state_24540[(2)]);
var _ = (function (){var statearr_24555 = state_24540;
(statearr_24555[(4)] = cljs.core.rest((state_24540[(4)])));

return statearr_24555;
})();
var state_24540__$1 = state_24540;
var statearr_24556_24570 = state_24540__$1;
(statearr_24556_24570[(2)] = inst_24535);

(statearr_24556_24570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0 = (function (){
var statearr_24557 = [null,null,null,null,null,null,null,null,null];
(statearr_24557[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__);

(statearr_24557[(1)] = (1));

return statearr_24557;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1 = (function (state_24540){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24540);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24558){var ex__2730__auto__ = e24558;
var statearr_24559_24571 = state_24540;
(statearr_24559_24571[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24540[(4)]))){
var statearr_24560_24572 = state_24540;
(statearr_24560_24572[(1)] = cljs.core.first((state_24540[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24573 = state_24540;
state_24540 = G__24573;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__ = function(state_24540){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1.call(this,state_24540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24561 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24561[(6)] = c__2749__auto__);

return statearr_24561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24595){
var state_val_24596 = (state_24595[(1)]);
if((state_val_24596 === (7))){
var inst_24584 = (state_24595[(7)]);
var inst_24586 = fluree.db.storage.core.serde(conn);
var inst_24587 = fluree.db.serde.protocol._deserialize_db_root(inst_24586,inst_24584);
var state_24595__$1 = state_24595;
var statearr_24597_24616 = state_24595__$1;
(statearr_24597_24616[(2)] = inst_24587);

(statearr_24597_24616[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24596 === (1))){
var state_24595__$1 = state_24595;
var statearr_24598_24617 = state_24595__$1;
(statearr_24598_24617[(2)] = null);

(statearr_24598_24617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24596 === (4))){
var inst_24574 = (state_24595[(2)]);
var state_24595__$1 = state_24595;
var statearr_24599_24618 = state_24595__$1;
(statearr_24599_24618[(2)] = inst_24574);

(statearr_24599_24618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24596 === (6))){
var inst_24584 = (state_24595[(7)]);
var inst_24583 = (state_24595[(2)]);
var inst_24584__$1 = fluree.db.util.async.throw_err(inst_24583);
var state_24595__$1 = (function (){var statearr_24600 = state_24595;
(statearr_24600[(7)] = inst_24584__$1);

return statearr_24600;
})();
if(cljs.core.truth_(inst_24584__$1)){
var statearr_24601_24619 = state_24595__$1;
(statearr_24601_24619[(1)] = (7));

} else {
var statearr_24602_24620 = state_24595__$1;
(statearr_24602_24620[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24596 === (3))){
var inst_24593 = (state_24595[(2)]);
var state_24595__$1 = state_24595;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24595__$1,inst_24593);
} else {
if((state_val_24596 === (2))){
var _ = (function (){var statearr_24604 = state_24595;
(statearr_24604[(4)] = cljs.core.cons((5),(state_24595[(4)])));

return statearr_24604;
})();
var inst_24580 = fluree.db.storage.core.ledger_root_key(network,ledger_id,block);
var inst_24581 = fluree.db.storage.core.read(conn,inst_24580);
var state_24595__$1 = state_24595;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24595__$1,(6),inst_24581);
} else {
if((state_val_24596 === (9))){
var inst_24590 = (state_24595[(2)]);
var _ = (function (){var statearr_24605 = state_24595;
(statearr_24605[(4)] = cljs.core.rest((state_24595[(4)])));

return statearr_24605;
})();
var state_24595__$1 = state_24595;
var statearr_24606_24621 = state_24595__$1;
(statearr_24606_24621[(2)] = inst_24590);

(statearr_24606_24621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24596 === (5))){
var _ = (function (){var statearr_24607 = state_24595;
(statearr_24607[(4)] = cljs.core.rest((state_24595[(4)])));

return statearr_24607;
})();
var state_24595__$1 = state_24595;
var ex24603 = (state_24595__$1[(2)]);
var statearr_24608_24622 = state_24595__$1;
(statearr_24608_24622[(5)] = ex24603);


if((ex24603 instanceof Error)){
var statearr_24609_24623 = state_24595__$1;
(statearr_24609_24623[(1)] = (4));

(statearr_24609_24623[(5)] = null);

} else {
throw ex24603;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24596 === (8))){
var state_24595__$1 = state_24595;
var statearr_24610_24624 = state_24595__$1;
(statearr_24610_24624[(2)] = null);

(statearr_24610_24624[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0 = (function (){
var statearr_24611 = [null,null,null,null,null,null,null,null];
(statearr_24611[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__);

(statearr_24611[(1)] = (1));

return statearr_24611;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1 = (function (state_24595){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24595);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24612){var ex__2730__auto__ = e24612;
var statearr_24613_24625 = state_24595;
(statearr_24613_24625[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24595[(4)]))){
var statearr_24614_24626 = state_24595;
(statearr_24614_24626[(1)] = cljs.core.first((state_24595[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24627 = state_24595;
state_24595 = G__24627;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__ = function(state_24595){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1.call(this,state_24595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24615 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24615[(6)] = c__2749__auto__);

return statearr_24615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index,
 *   throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,ledger_id,blank_db,index){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24664){
var state_val_24665 = (state_24664[(1)]);
if((state_val_24665 === (7))){
var inst_24634 = (state_24664[(7)]);
var state_24664__$1 = state_24664;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24664__$1,(9),inst_24634);
} else {
if((state_val_24665 === (1))){
var state_24664__$1 = state_24664;
var statearr_24666_24687 = state_24664__$1;
(statearr_24666_24687[(2)] = null);

(statearr_24666_24687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (4))){
var inst_24628 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
var statearr_24667_24688 = state_24664__$1;
(statearr_24667_24688[(2)] = inst_24628);

(statearr_24667_24688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (6))){
var inst_24637 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_24638 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24639 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_24640 = cljs.core.PersistentHashMap.fromArrays(inst_24638,inst_24639);
var inst_24641 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24637,inst_24640);
var inst_24642 = (function(){throw inst_24641})();
var state_24664__$1 = state_24664;
var statearr_24668_24689 = state_24664__$1;
(statearr_24668_24689[(2)] = inst_24642);

(statearr_24668_24689[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (3))){
var inst_24662 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24664__$1,inst_24662);
} else {
if((state_val_24665 === (2))){
var inst_24634 = (state_24664[(7)]);
var _ = (function (){var statearr_24669 = state_24664;
(statearr_24669[(4)] = cljs.core.cons((5),(state_24664[(4)])));

return statearr_24669;
})();
var inst_24634__$1 = fluree.db.storage.core.read_db_root(conn,network,ledger_id,index);
var inst_24635 = cljs.core.not(inst_24634__$1);
var state_24664__$1 = (function (){var statearr_24670 = state_24664;
(statearr_24670[(7)] = inst_24634__$1);

return statearr_24670;
})();
if(inst_24635){
var statearr_24671_24690 = state_24664__$1;
(statearr_24671_24690[(1)] = (6));

} else {
var statearr_24672_24691 = state_24664__$1;
(statearr_24672_24691[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (11))){
var inst_24652 = (state_24664[(8)]);
var inst_24655 = (state_24664[(2)]);
var inst_24656 = fluree.db.util.async.throw_err(inst_24655);
var inst_24657 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24652,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_24656);
var state_24664__$1 = state_24664;
var statearr_24674_24692 = state_24664__$1;
(statearr_24674_24692[(2)] = inst_24657);

(statearr_24674_24692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (9))){
var inst_24647 = (state_24664[(9)]);
var inst_24645 = (state_24664[(2)]);
var inst_24646 = fluree.db.util.async.throw_err(inst_24645);
var inst_24647__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_24646);
var inst_24648 = fluree.db.query.schema.schema_map(inst_24647__$1);
var state_24664__$1 = (function (){var statearr_24675 = state_24664;
(statearr_24675[(9)] = inst_24647__$1);

return statearr_24675;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24664__$1,(10),inst_24648);
} else {
if((state_val_24665 === (5))){
var _ = (function (){var statearr_24676 = state_24664;
(statearr_24676[(4)] = cljs.core.rest((state_24664[(4)])));

return statearr_24676;
})();
var state_24664__$1 = state_24664;
var ex24673 = (state_24664__$1[(2)]);
var statearr_24677_24693 = state_24664__$1;
(statearr_24677_24693[(5)] = ex24673);


if((ex24673 instanceof Error)){
var statearr_24678_24694 = state_24664__$1;
(statearr_24678_24694[(1)] = (4));

(statearr_24678_24694[(5)] = null);

} else {
throw ex24673;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (10))){
var inst_24647 = (state_24664[(9)]);
var inst_24652 = (state_24664[(8)]);
var inst_24650 = (state_24664[(2)]);
var inst_24651 = fluree.db.util.async.throw_err(inst_24650);
var inst_24652__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24647,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_24651);
var inst_24653 = fluree.db.query.schema.setting_map(inst_24652__$1);
var state_24664__$1 = (function (){var statearr_24679 = state_24664;
(statearr_24679[(8)] = inst_24652__$1);

return statearr_24679;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24664__$1,(11),inst_24653);
} else {
if((state_val_24665 === (8))){
var inst_24659 = (state_24664[(2)]);
var _ = (function (){var statearr_24680 = state_24664;
(statearr_24680[(4)] = cljs.core.rest((state_24664[(4)])));

return statearr_24680;
})();
var state_24664__$1 = state_24664;
var statearr_24681_24695 = state_24664__$1;
(statearr_24681_24695[(2)] = inst_24659);

(statearr_24681_24695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0 = (function (){
var statearr_24682 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24682[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2727__auto__);

(statearr_24682[(1)] = (1));

return statearr_24682;
});
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1 = (function (state_24664){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24664);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24683){var ex__2730__auto__ = e24683;
var statearr_24684_24696 = state_24664;
(statearr_24684_24696[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24664[(4)]))){
var statearr_24685_24697 = state_24664;
(statearr_24685_24697[(1)] = cljs.core.first((state_24664[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24698 = state_24664;
state_24664 = G__24698;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__ = function(state_24664){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1.call(this,state_24664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24686 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24686[(6)] = c__2749__auto__);

return statearr_24686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.fetch_child_attributes = (function fluree$db$storage$core$fetch_child_attributes(conn,p__24699){
var map__24700 = p__24699;
var map__24700__$1 = cljs.core.__destructure_map(map__24700);
var branch = map__24700__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24700__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24700__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24700__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24737){
var state_val_24738 = (state_24737[(1)]);
if((state_val_24738 === (7))){
var inst_24710 = (state_24737[(7)]);
var inst_24713 = cljs.core.__destructure_map(inst_24710);
var inst_24714 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24713,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_24715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24716 = [new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"tempid","tempid",1427663222)];
var inst_24717 = (new cljs.core.PersistentVector(null,7,(5),inst_24715,inst_24716,null));
var inst_24718 = cljs.core.select_keys(branch,inst_24717);
var inst_24719 = (function (){var temp__5802__auto__ = inst_24710;
var map__24712 = inst_24713;
var children = inst_24714;
var branch_metadata = inst_24718;
return (function (i,child){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(branch_metadata,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),(function (){var and__4251__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return (i === (0));
} else {
return and__4251__auto__;
}
})()),child], 0));
});
})();
var inst_24720 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_24719,inst_24714);
var inst_24721 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),cljs.core.identity);
var inst_24722 = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(inst_24721,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_24720], 0));
var inst_24723 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_map_by,comparator,inst_24722);
var state_24737__$1 = state_24737;
var statearr_24739_24758 = state_24737__$1;
(statearr_24739_24758[(2)] = inst_24723);

(statearr_24739_24758[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (1))){
var state_24737__$1 = state_24737;
var statearr_24740_24759 = state_24737__$1;
(statearr_24740_24759[(2)] = null);

(statearr_24740_24759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (4))){
var inst_24701 = (state_24737[(2)]);
var state_24737__$1 = state_24737;
var statearr_24741_24760 = state_24737__$1;
(statearr_24741_24760[(2)] = inst_24701);

(statearr_24741_24760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (6))){
var inst_24710 = (state_24737[(7)]);
var inst_24709 = (state_24737[(2)]);
var inst_24710__$1 = fluree.db.util.async.throw_err(inst_24709);
var state_24737__$1 = (function (){var statearr_24742 = state_24737;
(statearr_24742[(7)] = inst_24710__$1);

return statearr_24742;
})();
if(cljs.core.truth_(inst_24710__$1)){
var statearr_24743_24761 = state_24737__$1;
(statearr_24743_24761[(1)] = (7));

} else {
var statearr_24744_24762 = state_24737__$1;
(statearr_24744_24762[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (3))){
var inst_24735 = (state_24737[(2)]);
var state_24737__$1 = state_24737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24737__$1,inst_24735);
} else {
if((state_val_24738 === (2))){
var _ = (function (){var statearr_24746 = state_24737;
(statearr_24746[(4)] = cljs.core.cons((5),(state_24737[(4)])));

return statearr_24746;
})();
var inst_24707 = fluree.db.storage.core.read_branch(conn,id);
var state_24737__$1 = state_24737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24737__$1,(6),inst_24707);
} else {
if((state_val_24738 === (9))){
var inst_24732 = (state_24737[(2)]);
var _ = (function (){var statearr_24747 = state_24737;
(statearr_24747[(4)] = cljs.core.rest((state_24737[(4)])));

return statearr_24747;
})();
var state_24737__$1 = state_24737;
var statearr_24748_24763 = state_24737__$1;
(statearr_24748_24763[(2)] = inst_24732);

(statearr_24748_24763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (5))){
var _ = (function (){var statearr_24749 = state_24737;
(statearr_24749[(4)] = cljs.core.rest((state_24737[(4)])));

return statearr_24749;
})();
var state_24737__$1 = state_24737;
var ex24745 = (state_24737__$1[(2)]);
var statearr_24750_24764 = state_24737__$1;
(statearr_24750_24764[(5)] = ex24745);


if((ex24745 instanceof Error)){
var statearr_24751_24765 = state_24737__$1;
(statearr_24751_24765[(1)] = (4));

(statearr_24751_24765[(5)] = null);

} else {
throw ex24745;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (8))){
var inst_24725 = ["Unable to retrieve index branch with id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage."].join('');
var inst_24726 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24727 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_24728 = cljs.core.PersistentHashMap.fromArrays(inst_24726,inst_24727);
var inst_24729 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24725,inst_24728);
var inst_24730 = (function(){throw inst_24729})();
var state_24737__$1 = state_24737;
var statearr_24752_24766 = state_24737__$1;
(statearr_24752_24766[(2)] = inst_24730);

(statearr_24752_24766[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0 = (function (){
var statearr_24753 = [null,null,null,null,null,null,null,null];
(statearr_24753[(0)] = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__);

(statearr_24753[(1)] = (1));

return statearr_24753;
});
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1 = (function (state_24737){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24737);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24754){var ex__2730__auto__ = e24754;
var statearr_24755_24767 = state_24737;
(statearr_24755_24767[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24737[(4)]))){
var statearr_24756_24768 = state_24737;
(statearr_24756_24768[(1)] = cljs.core.first((state_24737[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24769 = state_24737;
state_24737 = G__24769;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__ = function(state_24737){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1.call(this,state_24737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0;
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1;
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24757 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24757[(6)] = c__2749__auto__);

return statearr_24757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.fetch_leaf_flakes = (function fluree$db$storage$core$fetch_leaf_flakes(conn,p__24770){
var map__24771 = p__24770;
var map__24771__$1 = cljs.core.__destructure_map(map__24771);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24771__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24771__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24800){
var state_val_24801 = (state_24800[(1)]);
if((state_val_24801 === (7))){
var inst_24781 = (state_24800[(7)]);
var inst_24784 = cljs.core.__destructure_map(inst_24781);
var inst_24785 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24784,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_24786 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,comparator,inst_24785);
var state_24800__$1 = state_24800;
var statearr_24802_24821 = state_24800__$1;
(statearr_24802_24821[(2)] = inst_24786);

(statearr_24802_24821[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24801 === (1))){
var state_24800__$1 = state_24800;
var statearr_24803_24822 = state_24800__$1;
(statearr_24803_24822[(2)] = null);

(statearr_24803_24822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24801 === (4))){
var inst_24772 = (state_24800[(2)]);
var state_24800__$1 = state_24800;
var statearr_24804_24823 = state_24800__$1;
(statearr_24804_24823[(2)] = inst_24772);

(statearr_24804_24823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24801 === (6))){
var inst_24781 = (state_24800[(7)]);
var inst_24780 = (state_24800[(2)]);
var inst_24781__$1 = fluree.db.util.async.throw_err(inst_24780);
var state_24800__$1 = (function (){var statearr_24805 = state_24800;
(statearr_24805[(7)] = inst_24781__$1);

return statearr_24805;
})();
if(cljs.core.truth_(inst_24781__$1)){
var statearr_24806_24824 = state_24800__$1;
(statearr_24806_24824[(1)] = (7));

} else {
var statearr_24807_24825 = state_24800__$1;
(statearr_24807_24825[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24801 === (3))){
var inst_24798 = (state_24800[(2)]);
var state_24800__$1 = state_24800;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24800__$1,inst_24798);
} else {
if((state_val_24801 === (2))){
var _ = (function (){var statearr_24809 = state_24800;
(statearr_24809[(4)] = cljs.core.cons((5),(state_24800[(4)])));

return statearr_24809;
})();
var inst_24778 = fluree.db.storage.core.read_leaf(conn,id);
var state_24800__$1 = state_24800;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24800__$1,(6),inst_24778);
} else {
if((state_val_24801 === (9))){
var inst_24795 = (state_24800[(2)]);
var _ = (function (){var statearr_24810 = state_24800;
(statearr_24810[(4)] = cljs.core.rest((state_24800[(4)])));

return statearr_24810;
})();
var state_24800__$1 = state_24800;
var statearr_24811_24826 = state_24800__$1;
(statearr_24811_24826[(2)] = inst_24795);

(statearr_24811_24826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24801 === (5))){
var _ = (function (){var statearr_24812 = state_24800;
(statearr_24812[(4)] = cljs.core.rest((state_24800[(4)])));

return statearr_24812;
})();
var state_24800__$1 = state_24800;
var ex24808 = (state_24800__$1[(2)]);
var statearr_24813_24827 = state_24800__$1;
(statearr_24813_24827[(5)] = ex24808);


if((ex24808 instanceof Error)){
var statearr_24814_24828 = state_24800__$1;
(statearr_24814_24828[(1)] = (4));

(statearr_24814_24828[(5)] = null);

} else {
throw ex24808;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24801 === (8))){
var inst_24788 = ["Unable to retrieve leaf node with id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage"].join('');
var inst_24789 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24790 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_24791 = cljs.core.PersistentHashMap.fromArrays(inst_24789,inst_24790);
var inst_24792 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24788,inst_24791);
var inst_24793 = (function(){throw inst_24792})();
var state_24800__$1 = state_24800;
var statearr_24815_24829 = state_24800__$1;
(statearr_24815_24829[(2)] = inst_24793);

(statearr_24815_24829[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0 = (function (){
var statearr_24816 = [null,null,null,null,null,null,null,null];
(statearr_24816[(0)] = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__);

(statearr_24816[(1)] = (1));

return statearr_24816;
});
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1 = (function (state_24800){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24800);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24817){var ex__2730__auto__ = e24817;
var statearr_24818_24830 = state_24800;
(statearr_24818_24830[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24800[(4)]))){
var statearr_24819_24831 = state_24800;
(statearr_24819_24831[(1)] = cljs.core.first((state_24800[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24832 = state_24800;
state_24800 = G__24832;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__ = function(state_24800){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1.call(this,state_24800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0;
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1;
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24820 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24820[(6)] = c__2749__auto__);

return statearr_24820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.resolve_index_node = (function fluree$db$storage$core$resolve_index_node(var_args){
var G__24834 = arguments.length;
switch (G__24834) {
case 2:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2 = (function (conn,node){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2(node,null);
}));

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3 = (function (conn,p__24835,error_fn){
var map__24836 = p__24835;
var map__24836__$1 = cljs.core.__destructure_map(map__24836);
var node = map__24836__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24836__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24836__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
if(cljs.core.truth_(comparator)){
} else {
throw (new Error(["Assert failed: ","Cannot resolve index node; configuration does not have a comparator.","\n","comparator"].join('')));
}

var return_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___24908 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24880){
var state_val_24881 = (state_24880[(1)]);
if((state_val_24881 === (7))){
var inst_24845 = (state_24880[(2)]);
var state_24880__$1 = state_24880;
var statearr_24882_24909 = state_24880__$1;
(statearr_24882_24909[(2)] = inst_24845);

(statearr_24882_24909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24881 === (1))){
var state_24880__$1 = state_24880;
var statearr_24883_24910 = state_24880__$1;
(statearr_24883_24910[(2)] = null);

(statearr_24883_24910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24881 === (4))){
var inst_24837 = (state_24880[(7)]);
var inst_24837__$1 = (state_24880[(2)]);
var inst_24838 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(inst_24837__$1,"Error resolving index node") : fluree.db.util.log.error.call(null,inst_24837__$1,"Error resolving index node"));
var state_24880__$1 = (function (){var statearr_24884 = state_24880;
(statearr_24884[(7)] = inst_24837__$1);

(statearr_24884[(8)] = inst_24838);

return statearr_24884;
})();
if(cljs.core.truth_(error_fn)){
var statearr_24885_24911 = state_24880__$1;
(statearr_24885_24911[(1)] = (5));

} else {
var statearr_24886_24912 = state_24880__$1;
(statearr_24886_24912[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24881 === (13))){
var inst_24863 = (state_24880[(9)]);
var inst_24866 = (state_24880[(2)]);
var inst_24867 = fluree.db.util.async.throw_err(inst_24866);
var inst_24868 = [new cljs.core.Keyword(null,"children","children",-940561982),inst_24867];
var inst_24869 = (new cljs.core.PersistentVector(null,2,(5),inst_24863,inst_24868,null));
var state_24880__$1 = state_24880;
var statearr_24887_24913 = state_24880__$1;
(statearr_24887_24913[(2)] = inst_24869);

(statearr_24887_24913[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24881 === (6))){
var state_24880__$1 = state_24880;
var statearr_24888_24914 = state_24880__$1;
(statearr_24888_24914[(2)] = null);

(statearr_24888_24914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24881 === (3))){
var inst_24878 = (state_24880[(2)]);
var state_24880__$1 = state_24880;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24880__$1,inst_24878);
} else {
if((state_val_24881 === (12))){
var inst_24855 = (state_24880[(10)]);
var inst_24858 = (state_24880[(2)]);
var inst_24859 = fluree.db.util.async.throw_err(inst_24858);
var inst_24860 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_24859];
var inst_24861 = (new cljs.core.PersistentVector(null,2,(5),inst_24855,inst_24860,null));
var state_24880__$1 = state_24880;
var statearr_24889_24915 = state_24880__$1;
(statearr_24889_24915[(2)] = inst_24861);

(statearr_24889_24915[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24881 === (2))){
var _ = (function (){var statearr_24890 = state_24880;
(statearr_24890[(4)] = cljs.core.cons((8),(state_24880[(4)])));

return statearr_24890;
})();
var state_24880__$1 = state_24880;
if(cljs.core.truth_(leaf)){
var statearr_24891_24916 = state_24880__$1;
(statearr_24891_24916[(1)] = (9));

} else {
var statearr_24892_24917 = state_24880__$1;
(statearr_24892_24917[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24881 === (11))){
var inst_24871 = (state_24880[(2)]);
var inst_24872 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24871,(0),null);
var inst_24873 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24871,(1),null);
var inst_24874 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,inst_24872,inst_24873);
var inst_24875 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_24874);
var _ = (function (){var statearr_24893 = state_24880;
(statearr_24893[(4)] = cljs.core.rest((state_24880[(4)])));

return statearr_24893;
})();
var state_24880__$1 = state_24880;
var statearr_24894_24918 = state_24880__$1;
(statearr_24894_24918[(2)] = inst_24875);

(statearr_24894_24918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24881 === (9))){
var inst_24855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24856 = fluree.db.storage.core.fetch_leaf_flakes(conn,node);
var state_24880__$1 = (function (){var statearr_24895 = state_24880;
(statearr_24895[(10)] = inst_24855);

return statearr_24895;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24880__$1,(12),inst_24856);
} else {
if((state_val_24881 === (5))){
var inst_24837 = (state_24880[(7)]);
var inst_24840 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_24837);
var inst_24841 = cljs.core.async.close_BANG_(return_ch);
var inst_24842 = (error_fn.cljs$core$IFn$_invoke$arity$2 ? error_fn.cljs$core$IFn$_invoke$arity$2(inst_24840,inst_24841) : error_fn.call(null,inst_24840,inst_24841));
var state_24880__$1 = state_24880;
var statearr_24897_24919 = state_24880__$1;
(statearr_24897_24919[(2)] = inst_24842);

(statearr_24897_24919[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24881 === (10))){
var inst_24863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24864 = fluree.db.storage.core.fetch_child_attributes(conn,node);
var state_24880__$1 = (function (){var statearr_24898 = state_24880;
(statearr_24898[(9)] = inst_24863);

return statearr_24898;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24880__$1,(13),inst_24864);
} else {
if((state_val_24881 === (8))){
var _ = (function (){var statearr_24899 = state_24880;
(statearr_24899[(4)] = cljs.core.rest((state_24880[(4)])));

return statearr_24899;
})();
var state_24880__$1 = state_24880;
var ex24896 = (state_24880__$1[(2)]);
var statearr_24900_24920 = state_24880__$1;
(statearr_24900_24920[(5)] = ex24896);


var statearr_24901_24921 = state_24880__$1;
(statearr_24901_24921[(1)] = (4));

(statearr_24901_24921[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_24902 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24902[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_24902[(1)] = (1));

return statearr_24902;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_24880){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24880);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24903){var ex__2730__auto__ = e24903;
var statearr_24904_24922 = state_24880;
(statearr_24904_24922[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24880[(4)]))){
var statearr_24905_24923 = state_24880;
(statearr_24905_24923[(1)] = cljs.core.first((state_24880[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24924 = state_24880;
state_24880 = G__24924;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_24880){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_24880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24906 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24906[(6)] = c__2749__auto___24908);

return statearr_24906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_ch;
}));

(fluree.db.storage.core.resolve_index_node.cljs$lang$maxFixedArity = 3);

fluree.db.storage.core.resolve_empty_leaf = (function fluree$db$storage$core$resolve_empty_leaf(p__24925){
var map__24926 = p__24925;
var map__24926__$1 = cljs.core.__destructure_map(map__24926);
var node = map__24926__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24926__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var empty_set = fluree.db.flake.sorted_set_by(comparator);
var empty_node = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,empty_node);

return ch;
});
