// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *    1. level [Values: severe, warning, info, config, fine, finer, finest]
 *    
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__75854 = opts_SINGLEQUOTE_;
var map__75854__$1 = cljs.core.__destructure_map(map__75854);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75854__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__75856 = arguments.length;
switch (G__75856) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 * 
 *     Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__75859 = arguments.length;
switch (G__75859) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__75862 = arguments.length;
switch (G__75862) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__75865 = arguments.length;
switch (G__75865) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *    Must supply ledger, password and either user or auth identifier.
 *    Expire is optional
 *    - connection - connection object to server
 *    - ledger     - ledger identifier
 *    - password   - plain-text password
 *    - user       - _user/username (TODO: should allow any _user ident in the future)
 *    - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *    - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__75868 = arguments.length;
switch (G__75868) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *    Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__75871 = arguments.length;
switch (G__75871) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___75880 = arguments.length;
var i__4865__auto___75881 = (0);
while(true){
if((i__4865__auto___75881 < len__4864__auto___75880)){
args__4870__auto__.push((arguments[i__4865__auto___75881]));

var G__75882 = (i__4865__auto___75881 + (1));
i__4865__auto___75881 = G__75882;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__75876){
var vec__75877 = p__75876;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75877,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq75873){
var G__75874 = cljs.core.first(seq75873);
var seq75873__$1 = cljs.core.next(seq75873);
var G__75875 = cljs.core.first(seq75873__$1);
var seq75873__$2 = cljs.core.next(seq75873__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__75874,G__75875,seq75873__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75904){
var state_val_75905 = (state_75904[(1)]);
if((state_val_75905 === (1))){
var state_75904__$1 = state_75904;
var statearr_75906_75921 = state_75904__$1;
(statearr_75906_75921[(2)] = null);

(statearr_75906_75921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75905 === (2))){
var _ = (function (){var statearr_75907 = state_75904;
(statearr_75907[(4)] = cljs.core.cons((5),(state_75904[(4)])));

return statearr_75907;
})();
var state_75904__$1 = state_75904;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75904__$1,(6),db);
} else {
if((state_val_75905 === (3))){
var inst_75902 = (state_75904[(2)]);
var state_75904__$1 = state_75904;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75904__$1,inst_75902);
} else {
if((state_val_75905 === (4))){
var inst_75883 = (state_75904[(2)]);
var inst_75884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75885 = [inst_75883];
var inst_75886 = (new cljs.core.PersistentVector(null,1,(5),inst_75884,inst_75885,null));
var inst_75887 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_75886);
var inst_75888 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_75883) : reject.call(null,inst_75883));
var state_75904__$1 = (function (){var statearr_75909 = state_75904;
(statearr_75909[(7)] = inst_75887);

return statearr_75909;
})();
var statearr_75910_75922 = state_75904__$1;
(statearr_75910_75922[(2)] = inst_75888);

(statearr_75910_75922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75905 === (5))){
var _ = (function (){var statearr_75911 = state_75904;
(statearr_75911[(4)] = cljs.core.rest((state_75904[(4)])));

return statearr_75911;
})();
var state_75904__$1 = state_75904;
var ex75908 = (state_75904__$1[(2)]);
var statearr_75912_75923 = state_75904__$1;
(statearr_75912_75923[(5)] = ex75908);


var statearr_75913_75924 = state_75904__$1;
(statearr_75913_75924[(1)] = (4));

(statearr_75913_75924[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75905 === (6))){
var inst_75895 = (state_75904[(2)]);
var inst_75896 = fluree.db.util.async.throw_err(inst_75895);
var inst_75897 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_75896);
var inst_75898 = cljs.core.clj__GT_js(inst_75897);
var inst_75899 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_75898) : resolve.call(null,inst_75898));
var _ = (function (){var statearr_75914 = state_75904;
(statearr_75914[(4)] = cljs.core.rest((state_75904[(4)])));

return statearr_75914;
})();
var state_75904__$1 = state_75904;
var statearr_75915_75925 = state_75904__$1;
(statearr_75915_75925[(2)] = inst_75899);

(statearr_75915_75925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__2727__auto__ = null;
var flureedb$db_schema_$_state_machine__2727__auto____0 = (function (){
var statearr_75916 = [null,null,null,null,null,null,null,null];
(statearr_75916[(0)] = flureedb$db_schema_$_state_machine__2727__auto__);

(statearr_75916[(1)] = (1));

return statearr_75916;
});
var flureedb$db_schema_$_state_machine__2727__auto____1 = (function (state_75904){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75904);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75917){var ex__2730__auto__ = e75917;
var statearr_75918_75926 = state_75904;
(statearr_75918_75926[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75904[(4)]))){
var statearr_75919_75927 = state_75904;
(statearr_75919_75927[(1)] = cljs.core.first((state_75904[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75928 = state_75904;
state_75904 = G__75928;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__2727__auto__ = function(state_75904){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__2727__auto____1.call(this,state_75904);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__2727__auto____0;
flureedb$db_schema_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__2727__auto____1;
return flureedb$db_schema_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75920 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75920[(6)] = c__2749__auto__);

return statearr_75920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *    Returns a promise that will have a response with a corresponding status of success.
 * 
 *    A 200 status indicates the deletion has been successfully initiated.
 *    The full deletion happens in the background on the respective ledger.
 * 
 *    Query servers get notified when this process initiates, and ledger will be marked as
 *    being in a deletion state during the deletion process.
 * 
 *    Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__75930 = arguments.length;
switch (G__75930) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76003){
var state_val_76004 = (state_76003[(1)]);
if((state_val_76004 === (7))){
var inst_75946 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76003__$1 = state_76003;
var statearr_76005_76050 = state_76003__$1;
(statearr_76005_76050[(2)] = inst_75946);

(statearr_76005_76050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (20))){
var inst_75954 = (state_76003[(7)]);
var inst_75978 = (state_76003[(2)]);
var state_76003__$1 = (function (){var statearr_76006 = state_76003;
(statearr_76006[(8)] = inst_75978);

return statearr_76006;
})();
if(cljs.core.truth_(inst_75954)){
var statearr_76007_76051 = state_76003__$1;
(statearr_76007_76051[(1)] = (21));

} else {
var statearr_76008_76052 = state_76003__$1;
(statearr_76008_76052[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (1))){
var state_76003__$1 = state_76003;
var statearr_76009_76053 = state_76003__$1;
(statearr_76009_76053[(2)] = null);

(statearr_76009_76053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (24))){
var inst_75985 = (state_76003[(2)]);
var inst_75986 = fluree.db.util.async.throw_err(inst_75985);
var state_76003__$1 = state_76003;
var statearr_76010_76054 = state_76003__$1;
(statearr_76010_76054[(2)] = inst_75986);

(statearr_76010_76054[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (4))){
var inst_75931 = (state_76003[(2)]);
var inst_75932 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75933 = [inst_75931];
var inst_75934 = (new cljs.core.PersistentVector(null,1,(5),inst_75932,inst_75933,null));
var inst_75935 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_75934);
var inst_75936 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_75931) : reject.call(null,inst_75931));
var state_76003__$1 = (function (){var statearr_76011 = state_76003;
(statearr_76011[(9)] = inst_75935);

return statearr_76011;
})();
var statearr_76012_76055 = state_76003__$1;
(statearr_76012_76055[(2)] = inst_75936);

(statearr_76012_76055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (15))){
var inst_75967 = (state_76003[(10)]);
var inst_75969 = fluree.db.util.core.without_nils(inst_75967);
var inst_75970 = fluree.db.util.json.stringify(inst_75969);
var state_76003__$1 = state_76003;
var statearr_76013_76056 = state_76003__$1;
(statearr_76013_76056[(2)] = inst_75970);

(statearr_76013_76056[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (21))){
var inst_75973 = (state_76003[(11)]);
var inst_75978 = (state_76003[(8)]);
var inst_75980 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_75981 = [inst_75973,inst_75978];
var inst_75982 = cljs.core.PersistentHashMap.fromArrays(inst_75980,inst_75981);
var inst_75983 = fluree.db.operations.command_async(conn,inst_75982);
var state_76003__$1 = state_76003;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76003__$1,(24),inst_75983);
} else {
if((state_val_76004 === (13))){
var inst_75955 = (state_76003[(12)]);
var inst_75962 = (inst_75955 + (30000));
var state_76003__$1 = state_76003;
var statearr_76014_76057 = state_76003__$1;
(statearr_76014_76057[(2)] = inst_75962);

(statearr_76014_76057[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (22))){
var inst_75967 = (state_76003[(10)]);
var inst_75988 = fluree.db.operations.unsigned_command_async(conn,inst_75967);
var state_76003__$1 = state_76003;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76003__$1,(25),inst_75988);
} else {
if((state_val_76004 === (6))){
var state_76003__$1 = state_76003;
var statearr_76015_76058 = state_76003__$1;
(statearr_76015_76058[(2)] = null);

(statearr_76015_76058[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (25))){
var inst_75990 = (state_76003[(2)]);
var inst_75991 = fluree.db.util.async.throw_err(inst_75990);
var state_76003__$1 = state_76003;
var statearr_76016_76059 = state_76003__$1;
(statearr_76016_76059[(2)] = inst_75991);

(statearr_76016_76059[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (17))){
var inst_75954 = (state_76003[(7)]);
var inst_75973 = (state_76003[(2)]);
var state_76003__$1 = (function (){var statearr_76017 = state_76003;
(statearr_76017[(11)] = inst_75973);

return statearr_76017;
})();
if(cljs.core.truth_(inst_75954)){
var statearr_76018_76060 = state_76003__$1;
(statearr_76018_76060[(1)] = (18));

} else {
var statearr_76019_76061 = state_76003__$1;
(statearr_76019_76061[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (3))){
var inst_76001 = (state_76003[(2)]);
var state_76003__$1 = state_76003;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76003__$1,inst_76001);
} else {
if((state_val_76004 === (12))){
var inst_75952 = (state_76003[(13)]);
var state_76003__$1 = state_76003;
var statearr_76020_76062 = state_76003__$1;
(statearr_76020_76062[(2)] = inst_75952);

(statearr_76020_76062[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (2))){
var _ = (function (){var statearr_76021 = state_76003;
(statearr_76021[(4)] = cljs.core.cons((5),(state_76003[(4)])));

return statearr_76021;
})();
var inst_75943 = (opts == null);
var state_76003__$1 = state_76003;
if(cljs.core.truth_(inst_75943)){
var statearr_76022_76063 = state_76003__$1;
(statearr_76022_76063[(1)] = (6));

} else {
var statearr_76023_76064 = state_76003__$1;
(statearr_76023_76064[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (23))){
var inst_75993 = (state_76003[(2)]);
var inst_75994 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_75995 = [(200),inst_75993];
var inst_75996 = cljs.core.PersistentHashMap.fromArrays(inst_75994,inst_75995);
var inst_75997 = cljs.core.clj__GT_js(inst_75996);
var inst_75998 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_75997) : resolve.call(null,inst_75997));
var _ = (function (){var statearr_76024 = state_76003;
(statearr_76024[(4)] = cljs.core.rest((state_76003[(4)])));

return statearr_76024;
})();
var state_76003__$1 = state_76003;
var statearr_76025_76065 = state_76003__$1;
(statearr_76025_76065[(2)] = inst_75998);

(statearr_76025_76065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (19))){
var state_76003__$1 = state_76003;
var statearr_76026_76066 = state_76003__$1;
(statearr_76026_76066[(2)] = null);

(statearr_76026_76066[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (11))){
var inst_75952 = (state_76003[(13)]);
var inst_75959 = (state_76003[(2)]);
var state_76003__$1 = (function (){var statearr_76028 = state_76003;
(statearr_76028[(14)] = inst_75959);

return statearr_76028;
})();
if(cljs.core.truth_(inst_75952)){
var statearr_76029_76067 = state_76003__$1;
(statearr_76029_76067[(1)] = (12));

} else {
var statearr_76030_76068 = state_76003__$1;
(statearr_76030_76068[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (9))){
var inst_75951 = (state_76003[(15)]);
var state_76003__$1 = state_76003;
var statearr_76031_76069 = state_76003__$1;
(statearr_76031_76069[(2)] = inst_75951);

(statearr_76031_76069[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (5))){
var _ = (function (){var statearr_76032 = state_76003;
(statearr_76032[(4)] = cljs.core.rest((state_76003[(4)])));

return statearr_76032;
})();
var state_76003__$1 = state_76003;
var ex76027 = (state_76003__$1[(2)]);
var statearr_76033_76070 = state_76003__$1;
(statearr_76033_76070[(5)] = ex76027);


var statearr_76034_76071 = state_76003__$1;
(statearr_76034_76071[(1)] = (4));

(statearr_76034_76071[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (14))){
var inst_75959 = (state_76003[(14)]);
var inst_75954 = (state_76003[(7)]);
var inst_75964 = (state_76003[(2)]);
var inst_75965 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_75966 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_75959,inst_75964];
var inst_75967 = cljs.core.PersistentHashMap.fromArrays(inst_75965,inst_75966);
var state_76003__$1 = (function (){var statearr_76035 = state_76003;
(statearr_76035[(10)] = inst_75967);

return statearr_76035;
})();
if(cljs.core.truth_(inst_75954)){
var statearr_76036_76072 = state_76003__$1;
(statearr_76036_76072[(1)] = (15));

} else {
var statearr_76037_76073 = state_76003__$1;
(statearr_76037_76073[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (16))){
var state_76003__$1 = state_76003;
var statearr_76038_76074 = state_76003__$1;
(statearr_76038_76074[(2)] = null);

(statearr_76038_76074[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (10))){
var inst_75955 = (state_76003[(12)]);
var state_76003__$1 = state_76003;
var statearr_76039_76075 = state_76003__$1;
(statearr_76039_76075[(2)] = inst_75955);

(statearr_76039_76075[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (18))){
var inst_75973 = (state_76003[(11)]);
var inst_75954 = (state_76003[(7)]);
var inst_75975 = fluree.crypto.sign_message(inst_75973,inst_75954);
var state_76003__$1 = state_76003;
var statearr_76040_76076 = state_76003__$1;
(statearr_76040_76076[(2)] = inst_75975);

(statearr_76040_76076[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76004 === (8))){
var inst_75951 = (state_76003[(15)]);
var inst_75948 = (state_76003[(2)]);
var inst_75949 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_75948);
var inst_75950 = cljs.core.__destructure_map(inst_75948);
var inst_75951__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75950,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_75952 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75950,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_75953 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_75950,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_75954 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75950,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_75955 = fluree.db.util.core.current_time_millis();
var state_76003__$1 = (function (){var statearr_76041 = state_76003;
(statearr_76041[(16)] = inst_75953);

(statearr_76041[(12)] = inst_75955);

(statearr_76041[(17)] = inst_75949);

(statearr_76041[(15)] = inst_75951__$1);

(statearr_76041[(13)] = inst_75952);

(statearr_76041[(7)] = inst_75954);

return statearr_76041;
})();
if(cljs.core.truth_(inst_75951__$1)){
var statearr_76042_76077 = state_76003__$1;
(statearr_76042_76077[(1)] = (9));

} else {
var statearr_76043_76078 = state_76003__$1;
(statearr_76043_76078[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76044 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76044[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76044[(1)] = (1));

return statearr_76044;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76003){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76003);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76045){var ex__2730__auto__ = e76045;
var statearr_76046_76079 = state_76003;
(statearr_76046_76079[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76003[(4)]))){
var statearr_76047_76080 = state_76003;
(statearr_76047_76080[(1)] = cljs.core.first((state_76003[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76081 = state_76003;
state_76003 = G__76081;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76003){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76003);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76048 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76048[(6)] = c__2749__auto__);

return statearr_76048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *    If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76103){
var state_val_76104 = (state_76103[(1)]);
if((state_val_76104 === (1))){
var state_76103__$1 = state_76103;
var statearr_76105_76120 = state_76103__$1;
(statearr_76105_76120[(2)] = null);

(statearr_76105_76120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76104 === (2))){
var _ = (function (){var statearr_76106 = state_76103;
(statearr_76106[(4)] = cljs.core.cons((5),(state_76103[(4)])));

return statearr_76106;
})();
var inst_76093 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_76103__$1 = state_76103;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76103__$1,(6),inst_76093);
} else {
if((state_val_76104 === (3))){
var inst_76101 = (state_76103[(2)]);
var state_76103__$1 = state_76103;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76103__$1,inst_76101);
} else {
if((state_val_76104 === (4))){
var inst_76082 = (state_76103[(2)]);
var inst_76083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76084 = [inst_76082];
var inst_76085 = (new cljs.core.PersistentVector(null,1,(5),inst_76083,inst_76084,null));
var inst_76086 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76085);
var inst_76087 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76082) : reject.call(null,inst_76082));
var state_76103__$1 = (function (){var statearr_76108 = state_76103;
(statearr_76108[(7)] = inst_76086);

return statearr_76108;
})();
var statearr_76109_76121 = state_76103__$1;
(statearr_76109_76121[(2)] = inst_76087);

(statearr_76109_76121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76104 === (5))){
var _ = (function (){var statearr_76110 = state_76103;
(statearr_76110[(4)] = cljs.core.rest((state_76103[(4)])));

return statearr_76110;
})();
var state_76103__$1 = state_76103;
var ex76107 = (state_76103__$1[(2)]);
var statearr_76111_76122 = state_76103__$1;
(statearr_76111_76122[(5)] = ex76107);


var statearr_76112_76123 = state_76103__$1;
(statearr_76112_76123[(1)] = (4));

(statearr_76112_76123[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76104 === (6))){
var inst_76095 = (state_76103[(2)]);
var inst_76096 = fluree.db.util.async.throw_err(inst_76095);
var inst_76097 = cljs.core.clj__GT_js(inst_76096);
var inst_76098 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76097) : resolve.call(null,inst_76097));
var _ = (function (){var statearr_76113 = state_76103;
(statearr_76113[(4)] = cljs.core.rest((state_76103[(4)])));

return statearr_76113;
})();
var state_76103__$1 = state_76103;
var statearr_76114_76124 = state_76103__$1;
(statearr_76114_76124[(2)] = inst_76098);

(statearr_76114_76124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__2727__auto__ = null;
var flureedb$ledger_stats_$_state_machine__2727__auto____0 = (function (){
var statearr_76115 = [null,null,null,null,null,null,null,null];
(statearr_76115[(0)] = flureedb$ledger_stats_$_state_machine__2727__auto__);

(statearr_76115[(1)] = (1));

return statearr_76115;
});
var flureedb$ledger_stats_$_state_machine__2727__auto____1 = (function (state_76103){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76103);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76116){var ex__2730__auto__ = e76116;
var statearr_76117_76125 = state_76103;
(statearr_76117_76125[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76103[(4)]))){
var statearr_76118_76126 = state_76103;
(statearr_76118_76126[(1)] = cljs.core.first((state_76103[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76127 = state_76103;
state_76103 = G__76127;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__2727__auto__ = function(state_76103){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__2727__auto____1.call(this,state_76103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__2727__auto____0;
flureedb$ledger_stats_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__2727__auto____1;
return flureedb$ledger_stats_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76119 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76119[(6)] = c__2749__auto__);

return statearr_76119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 *     A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 *     Once successful, will return with a command-id.
 * 
 *     Ledger creation is handled asynchronously and may not be immediately available.
 * 
 *     Options include:
 *     - :alias       - Alias, if different than db-ident.
 *     - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 *     - :doc         - Optional doc string about this db.
 *     - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 *     - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 *     - :persistResp - Respond immediately once persisted with the ledger-id, don't wait for transaction to be finished
 *     - :jwt         - token for Fluree On-Demand access
 *     
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__76129 = arguments.length;
switch (G__76129) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76256){
var state_val_76257 = (state_76256[(1)]);
if((state_val_76257 === (7))){
var inst_76155 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76256__$1 = state_76256;
var statearr_76258_76328 = state_76256__$1;
(statearr_76258_76328[(2)] = inst_76155);

(statearr_76258_76328[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (20))){
var inst_76162 = (state_76256[(7)]);
var inst_76201 = (state_76256[(2)]);
var inst_76202 = fluree.db.util.core.current_time_millis();
var state_76256__$1 = (function (){var statearr_76259 = state_76256;
(statearr_76259[(8)] = inst_76202);

(statearr_76259[(9)] = inst_76201);

return statearr_76259;
})();
if(cljs.core.truth_(inst_76162)){
var statearr_76260_76329 = state_76256__$1;
(statearr_76260_76329[(1)] = (21));

} else {
var statearr_76261_76330 = state_76256__$1;
(statearr_76261_76330[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (27))){
var inst_76215 = (state_76256[(10)]);
var inst_76170 = (state_76256[(11)]);
var inst_76217 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76215,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_76170);
var state_76256__$1 = state_76256;
var statearr_76262_76331 = state_76256__$1;
(statearr_76262_76331[(2)] = inst_76217);

(statearr_76262_76331[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (1))){
var state_76256__$1 = state_76256;
var statearr_76263_76332 = state_76256__$1;
(statearr_76263_76332[(2)] = null);

(statearr_76263_76332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (24))){
var inst_76168 = (state_76256[(12)]);
var state_76256__$1 = state_76256;
var statearr_76264_76333 = state_76256__$1;
(statearr_76264_76333[(2)] = inst_76168);

(statearr_76264_76333[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (39))){
var inst_76238 = (state_76256[(2)]);
var inst_76239 = fluree.db.util.async.throw_err(inst_76238);
var state_76256__$1 = state_76256;
var statearr_76265_76334 = state_76256__$1;
(statearr_76265_76334[(2)] = inst_76239);

(statearr_76265_76334[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (4))){
var inst_76130 = (state_76256[(2)]);
var inst_76131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76132 = [inst_76130];
var inst_76133 = (new cljs.core.PersistentVector(null,1,(5),inst_76131,inst_76132,null));
var inst_76134 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76133);
var inst_76135 = cljs.core.ex_data(inst_76130);
var inst_76136 = cljs.core.ex_message(inst_76130);
var inst_76137 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76135,new cljs.core.Keyword(null,"message","message",-406056002),inst_76136);
var inst_76138 = cljs.core.clj__GT_js(inst_76137);
var inst_76139 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76138) : reject.call(null,inst_76138));
var state_76256__$1 = (function (){var statearr_76266 = state_76256;
(statearr_76266[(13)] = inst_76134);

return statearr_76266;
})();
var statearr_76267_76335 = state_76256__$1;
(statearr_76267_76335[(2)] = inst_76139);

(statearr_76267_76335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (15))){
var inst_76191 = (state_76256[(14)]);
var inst_76193 = fluree.db.graphdb.validate_ledger_name(inst_76191,"alias");
var state_76256__$1 = state_76256;
var statearr_76268_76336 = state_76256__$1;
(statearr_76268_76336[(2)] = inst_76193);

(statearr_76268_76336[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (21))){
var inst_76162 = (state_76256[(7)]);
var state_76256__$1 = state_76256;
var statearr_76269_76337 = state_76256__$1;
(statearr_76269_76337[(2)] = inst_76162);

(statearr_76269_76337[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (31))){
var state_76256__$1 = state_76256;
var statearr_76270_76338 = state_76256__$1;
(statearr_76270_76338[(2)] = null);

(statearr_76270_76338[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (32))){
var inst_76164 = (state_76256[(15)]);
var inst_76226 = (state_76256[(2)]);
var state_76256__$1 = (function (){var statearr_76271 = state_76256;
(statearr_76271[(16)] = inst_76226);

return statearr_76271;
})();
if(cljs.core.truth_(inst_76164)){
var statearr_76272_76339 = state_76256__$1;
(statearr_76272_76339[(1)] = (33));

} else {
var statearr_76273_76340 = state_76256__$1;
(statearr_76273_76340[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (40))){
var inst_76243 = (state_76256[(2)]);
var inst_76244 = fluree.db.util.async.throw_err(inst_76243);
var state_76256__$1 = state_76256;
var statearr_76274_76341 = state_76256__$1;
(statearr_76274_76341[(2)] = inst_76244);

(statearr_76274_76341[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (33))){
var inst_76226 = (state_76256[(16)]);
var inst_76164 = (state_76256[(15)]);
var inst_76228 = fluree.crypto.sign_message(inst_76226,inst_76164);
var state_76256__$1 = state_76256;
var statearr_76275_76342 = state_76256__$1;
(statearr_76275_76342[(2)] = inst_76228);

(statearr_76275_76342[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (13))){
var state_76256__$1 = state_76256;
var statearr_76276_76343 = state_76256__$1;
(statearr_76276_76343[(2)] = null);

(statearr_76276_76343[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (22))){
var inst_76202 = (state_76256[(8)]);
var state_76256__$1 = state_76256;
var statearr_76277_76344 = state_76256__$1;
(statearr_76277_76344[(2)] = inst_76202);

(statearr_76277_76344[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (36))){
var inst_76231 = (state_76256[(17)]);
var inst_76226 = (state_76256[(16)]);
var inst_76233 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_76234 = [inst_76226,inst_76231];
var inst_76235 = cljs.core.PersistentHashMap.fromArrays(inst_76233,inst_76234);
var inst_76236 = fluree.db.operations.command_async(conn,inst_76235);
var state_76256__$1 = state_76256;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76256__$1,(39),inst_76236);
} else {
if((state_val_76257 === (29))){
var inst_76164 = (state_76256[(15)]);
var inst_76220 = (state_76256[(2)]);
var state_76256__$1 = (function (){var statearr_76278 = state_76256;
(statearr_76278[(18)] = inst_76220);

return statearr_76278;
})();
if(cljs.core.truth_(inst_76164)){
var statearr_76279_76345 = state_76256__$1;
(statearr_76279_76345[(1)] = (30));

} else {
var statearr_76280_76346 = state_76256__$1;
(statearr_76280_76346[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (6))){
var state_76256__$1 = state_76256;
var statearr_76281_76347 = state_76256__$1;
(statearr_76281_76347[(2)] = null);

(statearr_76281_76347[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (28))){
var inst_76215 = (state_76256[(10)]);
var state_76256__$1 = state_76256;
var statearr_76282_76348 = state_76256__$1;
(statearr_76282_76348[(2)] = inst_76215);

(statearr_76282_76348[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (25))){
var inst_76202 = (state_76256[(8)]);
var inst_76209 = (inst_76202 + (30000));
var state_76256__$1 = state_76256;
var statearr_76283_76349 = state_76256__$1;
(statearr_76283_76349[(2)] = inst_76209);

(statearr_76283_76349[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (34))){
var state_76256__$1 = state_76256;
var statearr_76284_76350 = state_76256__$1;
(statearr_76284_76350[(2)] = null);

(statearr_76284_76350[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (17))){
var inst_76172 = (state_76256[(19)]);
var inst_76196 = (state_76256[(2)]);
var state_76256__$1 = (function (){var statearr_76285 = state_76256;
(statearr_76285[(20)] = inst_76196);

return statearr_76285;
})();
if(cljs.core.truth_(inst_76172)){
var statearr_76286_76351 = state_76256__$1;
(statearr_76286_76351[(1)] = (18));

} else {
var statearr_76287_76352 = state_76256__$1;
(statearr_76287_76352[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (3))){
var inst_76254 = (state_76256[(2)]);
var state_76256__$1 = state_76256;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76256__$1,inst_76254);
} else {
if((state_val_76257 === (12))){
var inst_76186 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_76256__$1 = state_76256;
var statearr_76288_76353 = state_76256__$1;
(statearr_76288_76353[(2)] = inst_76186);

(statearr_76288_76353[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (2))){
var _ = (function (){var statearr_76289 = state_76256;
(statearr_76289[(4)] = cljs.core.cons((5),(state_76256[(4)])));

return statearr_76289;
})();
var inst_76152 = (opts == null);
var state_76256__$1 = state_76256;
if(cljs.core.truth_(inst_76152)){
var statearr_76290_76354 = state_76256__$1;
(statearr_76290_76354[(1)] = (6));

} else {
var statearr_76291_76355 = state_76256__$1;
(statearr_76291_76355[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (23))){
var inst_76168 = (state_76256[(12)]);
var inst_76206 = (state_76256[(2)]);
var state_76256__$1 = (function (){var statearr_76292 = state_76256;
(statearr_76292[(21)] = inst_76206);

return statearr_76292;
})();
if(cljs.core.truth_(inst_76168)){
var statearr_76293_76356 = state_76256__$1;
(statearr_76293_76356[(1)] = (24));

} else {
var statearr_76294_76357 = state_76256__$1;
(statearr_76294_76357[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (35))){
var inst_76164 = (state_76256[(15)]);
var inst_76231 = (state_76256[(2)]);
var state_76256__$1 = (function (){var statearr_76295 = state_76256;
(statearr_76295[(17)] = inst_76231);

return statearr_76295;
})();
if(cljs.core.truth_(inst_76164)){
var statearr_76296_76358 = state_76256__$1;
(statearr_76296_76358[(1)] = (36));

} else {
var statearr_76297_76359 = state_76256__$1;
(statearr_76297_76359[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (19))){
var state_76256__$1 = state_76256;
var statearr_76298_76360 = state_76256__$1;
(statearr_76298_76360[(2)] = null);

(statearr_76298_76360[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (11))){
var inst_76175 = (state_76256[(22)]);
var inst_76172 = (state_76256[(19)]);
var inst_76182 = (state_76256[(23)]);
var inst_76182__$1 = (state_76256[(2)]);
var inst_76183 = fluree.db.graphdb.validate_ledger_name(inst_76182__$1,"ledger");
var inst_76184 = fluree.db.graphdb.validate_ledger_name(inst_76175,"network");
var state_76256__$1 = (function (){var statearr_76300 = state_76256;
(statearr_76300[(24)] = inst_76184);

(statearr_76300[(25)] = inst_76183);

(statearr_76300[(23)] = inst_76182__$1);

return statearr_76300;
})();
if(cljs.core.truth_(inst_76172)){
var statearr_76301_76361 = state_76256__$1;
(statearr_76301_76361[(1)] = (12));

} else {
var statearr_76302_76362 = state_76256__$1;
(statearr_76302_76362[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (9))){
var inst_76176 = (state_76256[(26)]);
var inst_76179 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_76176,(1));
var state_76256__$1 = state_76256;
var statearr_76303_76363 = state_76256__$1;
(statearr_76303_76363[(2)] = inst_76179);

(statearr_76303_76363[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (5))){
var _ = (function (){var statearr_76304 = state_76256;
(statearr_76304[(4)] = cljs.core.rest((state_76256[(4)])));

return statearr_76304;
})();
var state_76256__$1 = state_76256;
var ex76299 = (state_76256__$1[(2)]);
var statearr_76305_76364 = state_76256__$1;
(statearr_76305_76364[(5)] = ex76299);


var statearr_76306_76365 = state_76256__$1;
(statearr_76306_76365[(1)] = (4));

(statearr_76306_76365[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (14))){
var inst_76172 = (state_76256[(19)]);
var inst_76189 = (state_76256[(2)]);
var inst_76190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76189,(0),null);
var inst_76191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76189,(1),null);
var state_76256__$1 = (function (){var statearr_76307 = state_76256;
(statearr_76307[(14)] = inst_76191);

(statearr_76307[(27)] = inst_76190);

return statearr_76307;
})();
if(cljs.core.truth_(inst_76172)){
var statearr_76308_76366 = state_76256__$1;
(statearr_76308_76366[(1)] = (15));

} else {
var statearr_76309_76367 = state_76256__$1;
(statearr_76309_76367[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (26))){
var inst_76175 = (state_76256[(22)]);
var inst_76163 = (state_76256[(28)]);
var inst_76169 = (state_76256[(29)]);
var inst_76161 = (state_76256[(30)]);
var inst_76206 = (state_76256[(21)]);
var inst_76166 = (state_76256[(31)]);
var inst_76165 = (state_76256[(32)]);
var inst_76167 = (state_76256[(33)]);
var inst_76171 = (state_76256[(34)]);
var inst_76201 = (state_76256[(9)]);
var inst_76173 = (state_76256[(35)]);
var inst_76170 = (state_76256[(11)]);
var inst_76182 = (state_76256[(23)]);
var inst_76211 = (state_76256[(2)]);
var inst_76212 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_76213 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76175),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76182)].join('');
var inst_76214 = [inst_76213,inst_76166,inst_76167,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_76211,inst_76169,inst_76201,inst_76173,inst_76171,inst_76161,inst_76206,inst_76163,inst_76165];
var inst_76215 = cljs.core.PersistentHashMap.fromArrays(inst_76212,inst_76214);
var state_76256__$1 = (function (){var statearr_76310 = state_76256;
(statearr_76310[(10)] = inst_76215);

return statearr_76310;
})();
if(cljs.core.truth_(inst_76170)){
var statearr_76311_76368 = state_76256__$1;
(statearr_76311_76368[(1)] = (27));

} else {
var statearr_76312_76369 = state_76256__$1;
(statearr_76312_76369[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (16))){
var state_76256__$1 = state_76256;
var statearr_76313_76370 = state_76256__$1;
(statearr_76313_76370[(2)] = null);

(statearr_76313_76370[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (38))){
var inst_76246 = (state_76256[(2)]);
var inst_76247 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_76248 = [(200),inst_76246];
var inst_76249 = cljs.core.PersistentHashMap.fromArrays(inst_76247,inst_76248);
var inst_76250 = cljs.core.clj__GT_js(inst_76249);
var inst_76251 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76250) : resolve.call(null,inst_76250));
var _ = (function (){var statearr_76314 = state_76256;
(statearr_76314[(4)] = cljs.core.rest((state_76256[(4)])));

return statearr_76314;
})();
var state_76256__$1 = state_76256;
var statearr_76315_76371 = state_76256__$1;
(statearr_76315_76371[(2)] = inst_76251);

(statearr_76315_76371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (30))){
var inst_76220 = (state_76256[(18)]);
var inst_76222 = fluree.db.util.core.without_nils(inst_76220);
var inst_76223 = fluree.db.util.json.stringify(inst_76222);
var state_76256__$1 = state_76256;
var statearr_76316_76372 = state_76256__$1;
(statearr_76316_76372[(2)] = inst_76223);

(statearr_76316_76372[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (10))){
var inst_76176 = (state_76256[(26)]);
var state_76256__$1 = state_76256;
var statearr_76317_76373 = state_76256__$1;
(statearr_76317_76373[(2)] = inst_76176);

(statearr_76317_76373[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (18))){
var inst_76191 = (state_76256[(14)]);
var inst_76190 = (state_76256[(27)]);
var inst_76198 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76190),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76191)].join('');
var state_76256__$1 = state_76256;
var statearr_76318_76374 = state_76256__$1;
(statearr_76318_76374[(2)] = inst_76198);

(statearr_76318_76374[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76257 === (37))){
var inst_76220 = (state_76256[(18)]);
var inst_76241 = fluree.db.operations.unsigned_command_async(conn,inst_76220);
var state_76256__$1 = state_76256;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76256__$1,(40),inst_76241);
} else {
if((state_val_76257 === (8))){
var inst_76176 = (state_76256[(26)]);
var inst_76157 = (state_76256[(2)]);
var inst_76158 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_76157);
var inst_76159 = cljs.core.__destructure_map(inst_76157);
var inst_76160 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_76159,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_76161 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76159,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_76162 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76159,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_76163 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76159,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_76164 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76159,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_76165 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76159,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_76166 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76159,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_76167 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76159,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_76168 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76159,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_76169 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76159,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_76170 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76159,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_76171 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76159,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_76172 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76159,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_76173 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76159,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_76174 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_76175 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76174,(0),null);
var inst_76176__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76174,(1),null);
var inst_76177 = clojure.string.starts_with_QMARK_(inst_76176__$1,"$");
var state_76256__$1 = (function (){var statearr_76319 = state_76256;
(statearr_76319[(22)] = inst_76175);

(statearr_76319[(28)] = inst_76163);

(statearr_76319[(36)] = inst_76160);

(statearr_76319[(29)] = inst_76169);

(statearr_76319[(30)] = inst_76161);

(statearr_76319[(12)] = inst_76168);

(statearr_76319[(26)] = inst_76176__$1);

(statearr_76319[(31)] = inst_76166);

(statearr_76319[(19)] = inst_76172);

(statearr_76319[(32)] = inst_76165);

(statearr_76319[(7)] = inst_76162);

(statearr_76319[(15)] = inst_76164);

(statearr_76319[(33)] = inst_76167);

(statearr_76319[(34)] = inst_76171);

(statearr_76319[(37)] = inst_76158);

(statearr_76319[(35)] = inst_76173);

(statearr_76319[(11)] = inst_76170);

return statearr_76319;
})();
if(inst_76177){
var statearr_76320_76375 = state_76256__$1;
(statearr_76320_76375[(1)] = (9));

} else {
var statearr_76321_76376 = state_76256__$1;
(statearr_76321_76376[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76322 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76322[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76322[(1)] = (1));

return statearr_76322;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76256){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76256);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76323){var ex__2730__auto__ = e76323;
var statearr_76324_76377 = state_76256;
(statearr_76324_76377[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76256[(4)]))){
var statearr_76325_76378 = state_76256;
(statearr_76325_76378[(1)] = cljs.core.first((state_76256[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76379 = state_76256;
state_76256 = G__76379;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76256){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76326 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76326[(6)] = c__2749__auto__);

return statearr_76326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *    Returns a promise that will eventually contain a response or an exception
 *    if the timeout period has expired.
 * 
 *    Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76402){
var state_val_76403 = (state_76402[(1)]);
if((state_val_76403 === (1))){
var state_76402__$1 = state_76402;
var statearr_76404_76420 = state_76402__$1;
(statearr_76404_76420[(2)] = null);

(statearr_76404_76420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76403 === (2))){
var _ = (function (){var statearr_76405 = state_76402;
(statearr_76405[(4)] = cljs.core.cons((5),(state_76402[(4)])));

return statearr_76405;
})();
var inst_76392 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76393 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_76402__$1 = (function (){var statearr_76406 = state_76402;
(statearr_76406[(7)] = inst_76392);

return statearr_76406;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76402__$1,(6),inst_76393);
} else {
if((state_val_76403 === (3))){
var inst_76400 = (state_76402[(2)]);
var state_76402__$1 = state_76402;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76402__$1,inst_76400);
} else {
if((state_val_76403 === (4))){
var inst_76380 = (state_76402[(2)]);
var inst_76381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76382 = [inst_76380];
var inst_76383 = (new cljs.core.PersistentVector(null,1,(5),inst_76381,inst_76382,null));
var inst_76384 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76383);
var inst_76385 = cljs.core.clj__GT_js(inst_76380);
var inst_76386 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76385) : reject.call(null,inst_76385));
var state_76402__$1 = (function (){var statearr_76408 = state_76402;
(statearr_76408[(8)] = inst_76384);

return statearr_76408;
})();
var statearr_76409_76421 = state_76402__$1;
(statearr_76409_76421[(2)] = inst_76386);

(statearr_76409_76421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76403 === (5))){
var _ = (function (){var statearr_76410 = state_76402;
(statearr_76410[(4)] = cljs.core.rest((state_76402[(4)])));

return statearr_76410;
})();
var state_76402__$1 = state_76402;
var ex76407 = (state_76402__$1[(2)]);
var statearr_76411_76422 = state_76402__$1;
(statearr_76411_76422[(5)] = ex76407);


var statearr_76412_76423 = state_76402__$1;
(statearr_76412_76423[(1)] = (4));

(statearr_76412_76423[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76403 === (6))){
var inst_76395 = (state_76402[(2)]);
var inst_76396 = cljs.core.clj__GT_js(inst_76395);
var inst_76397 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76396) : resolve.call(null,inst_76396));
var _ = (function (){var statearr_76413 = state_76402;
(statearr_76413[(4)] = cljs.core.rest((state_76402[(4)])));

return statearr_76413;
})();
var state_76402__$1 = state_76402;
var statearr_76414_76424 = state_76402__$1;
(statearr_76414_76424[(2)] = inst_76397);

(statearr_76414_76424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__2727__auto__ = null;
var flureedb$monitor_tx_$_state_machine__2727__auto____0 = (function (){
var statearr_76415 = [null,null,null,null,null,null,null,null,null];
(statearr_76415[(0)] = flureedb$monitor_tx_$_state_machine__2727__auto__);

(statearr_76415[(1)] = (1));

return statearr_76415;
});
var flureedb$monitor_tx_$_state_machine__2727__auto____1 = (function (state_76402){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76402);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76416){var ex__2730__auto__ = e76416;
var statearr_76417_76425 = state_76402;
(statearr_76417_76425[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76402[(4)]))){
var statearr_76418_76426 = state_76402;
(statearr_76418_76426[(1)] = cljs.core.first((state_76402[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76427 = state_76402;
state_76402 = G__76427;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__2727__auto__ = function(state_76402){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__2727__auto____1.call(this,state_76402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__2727__auto____0;
flureedb$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__2727__auto____1;
return flureedb$monitor_tx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76419 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76419[(6)] = c__2749__auto__);

return statearr_76419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 *     that will eventually have the result of the tx, the txid (if :txid-only option used), or
 *     an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 *     Will locally sign a final transaction command if a private key is provided via :private-key
 *     in the options, otherwise will submit the transaction to the connected ledger and request signature,
 *     provided the ledger group has a default private key available for signing.
 * 
 *     Options (opts) is a map with the following possible keys:
 *     - private-key - The private key to use for signing. If not present, a default
 *                     private key will attempt to be used from the connection, if available.
 *     - auth        - The auth id for the auth record being used. The private key must
 *                     correspond to this auth record, or an authority of this auth record.
 *     - expire      - When this transaction should expire if not yet attempted.
 *                     Defaults to 5 minutes.
 *     - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                     By default epoch milliseconds is used.
 *     - deps        - List of one or more txids that must be successfully processed before
 *                     this tx is processed. If any fail, this tx will fail. (not yet implemented)
 *     - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                     but instead return with the txid once it is successfully persisted by the
 *                     transactors. The txid can be used to look up/monitor the response at a later time.
 *     - timeout     - will respond with an exception if timeout reached before response available.
 *     - jwt         - token to access Fluree On-Demand
 *     
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__76429 = arguments.length;
switch (G__76429) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76458){
var state_val_76459 = (state_76458[(1)]);
if((state_val_76459 === (7))){
var inst_76444 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76458__$1 = state_76458;
var statearr_76460_76481 = state_76458__$1;
(statearr_76460_76481[(2)] = inst_76444);

(statearr_76460_76481[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76459 === (1))){
var state_76458__$1 = state_76458;
var statearr_76461_76482 = state_76458__$1;
(statearr_76461_76482[(2)] = null);

(statearr_76461_76482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76459 === (4))){
var inst_76430 = (state_76458[(2)]);
var inst_76431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76432 = [inst_76430];
var inst_76433 = (new cljs.core.PersistentVector(null,1,(5),inst_76431,inst_76432,null));
var inst_76434 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76433);
var inst_76435 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76430) : reject.call(null,inst_76430));
var state_76458__$1 = (function (){var statearr_76462 = state_76458;
(statearr_76462[(7)] = inst_76434);

return statearr_76462;
})();
var statearr_76463_76483 = state_76458__$1;
(statearr_76463_76483[(2)] = inst_76435);

(statearr_76463_76483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76459 === (6))){
var state_76458__$1 = state_76458;
var statearr_76464_76484 = state_76458__$1;
(statearr_76464_76484[(2)] = null);

(statearr_76464_76484[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76459 === (3))){
var inst_76456 = (state_76458[(2)]);
var state_76458__$1 = state_76458;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76458__$1,inst_76456);
} else {
if((state_val_76459 === (2))){
var _ = (function (){var statearr_76466 = state_76458;
(statearr_76466[(4)] = cljs.core.cons((5),(state_76458[(4)])));

return statearr_76466;
})();
var inst_76441 = (opts == null);
var state_76458__$1 = state_76458;
if(cljs.core.truth_(inst_76441)){
var statearr_76467_76485 = state_76458__$1;
(statearr_76467_76485[(1)] = (6));

} else {
var statearr_76468_76486 = state_76458__$1;
(statearr_76468_76486[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76459 === (9))){
var inst_76451 = (state_76458[(2)]);
var inst_76452 = cljs.core.clj__GT_js(inst_76451);
var inst_76453 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76452) : resolve.call(null,inst_76452));
var _ = (function (){var statearr_76469 = state_76458;
(statearr_76469[(4)] = cljs.core.rest((state_76458[(4)])));

return statearr_76469;
})();
var state_76458__$1 = state_76458;
var statearr_76470_76487 = state_76458__$1;
(statearr_76470_76487[(2)] = inst_76453);

(statearr_76470_76487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76459 === (5))){
var _ = (function (){var statearr_76471 = state_76458;
(statearr_76471[(4)] = cljs.core.rest((state_76458[(4)])));

return statearr_76471;
})();
var state_76458__$1 = state_76458;
var ex76465 = (state_76458__$1[(2)]);
var statearr_76472_76488 = state_76458__$1;
(statearr_76472_76488[(5)] = ex76465);


var statearr_76473_76489 = state_76458__$1;
(statearr_76473_76489[(1)] = (4));

(statearr_76473_76489[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76459 === (8))){
var inst_76446 = (state_76458[(2)]);
var inst_76447 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_76446);
var inst_76448 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_76449 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_76448,inst_76446);
var state_76458__$1 = (function (){var statearr_76474 = state_76458;
(statearr_76474[(8)] = inst_76447);

return statearr_76474;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76458__$1,(9),inst_76449);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76475 = [null,null,null,null,null,null,null,null,null];
(statearr_76475[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76475[(1)] = (1));

return statearr_76475;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76458){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76458);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76476){var ex__2730__auto__ = e76476;
var statearr_76477_76490 = state_76458;
(statearr_76477_76490[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76458[(4)]))){
var statearr_76478_76491 = state_76458;
(statearr_76478_76491[(1)] = cljs.core.first((state_76458[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76492 = state_76458;
state_76458 = G__76492;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76458){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76479 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76479[(6)] = c__2749__auto__);

return statearr_76479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *    to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *    :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__76494 = arguments.length;
switch (G__76494) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76526){
var state_val_76527 = (state_76526[(1)]);
if((state_val_76527 === (7))){
var inst_76509 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76526__$1 = state_76526;
var statearr_76528_76549 = state_76526__$1;
(statearr_76528_76549[(2)] = inst_76509);

(statearr_76528_76549[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76527 === (1))){
var state_76526__$1 = state_76526;
var statearr_76529_76550 = state_76526__$1;
(statearr_76529_76550[(2)] = null);

(statearr_76529_76550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76527 === (4))){
var inst_76495 = (state_76526[(2)]);
var inst_76496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76497 = [inst_76495];
var inst_76498 = (new cljs.core.PersistentVector(null,1,(5),inst_76496,inst_76497,null));
var inst_76499 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76498);
var inst_76500 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76495) : reject.call(null,inst_76495));
var state_76526__$1 = (function (){var statearr_76530 = state_76526;
(statearr_76530[(7)] = inst_76499);

return statearr_76530;
})();
var statearr_76531_76551 = state_76526__$1;
(statearr_76531_76551[(2)] = inst_76500);

(statearr_76531_76551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76527 === (6))){
var state_76526__$1 = state_76526;
var statearr_76532_76552 = state_76526__$1;
(statearr_76532_76552[(2)] = null);

(statearr_76532_76552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76527 === (3))){
var inst_76524 = (state_76526[(2)]);
var state_76526__$1 = state_76526;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76526__$1,inst_76524);
} else {
if((state_val_76527 === (2))){
var _ = (function (){var statearr_76534 = state_76526;
(statearr_76534[(4)] = cljs.core.cons((5),(state_76526[(4)])));

return statearr_76534;
})();
var inst_76506 = (opts == null);
var state_76526__$1 = state_76526;
if(cljs.core.truth_(inst_76506)){
var statearr_76535_76553 = state_76526__$1;
(statearr_76535_76553[(1)] = (6));

} else {
var statearr_76536_76554 = state_76526__$1;
(statearr_76536_76554[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76527 === (9))){
var inst_76511 = (state_76526[(8)]);
var inst_76514 = (state_76526[(2)]);
var inst_76515 = fluree.db.util.async.throw_err(inst_76514);
var inst_76516 = fluree.db.query.block.block_range(inst_76515,start,end,inst_76511);
var state_76526__$1 = state_76526;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76526__$1,(10),inst_76516);
} else {
if((state_val_76527 === (5))){
var _ = (function (){var statearr_76537 = state_76526;
(statearr_76537[(4)] = cljs.core.rest((state_76526[(4)])));

return statearr_76537;
})();
var state_76526__$1 = state_76526;
var ex76533 = (state_76526__$1[(2)]);
var statearr_76538_76555 = state_76526__$1;
(statearr_76538_76555[(5)] = ex76533);


var statearr_76539_76556 = state_76526__$1;
(statearr_76539_76556[(1)] = (4));

(statearr_76539_76556[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76527 === (10))){
var inst_76518 = (state_76526[(2)]);
var inst_76519 = fluree.db.util.async.throw_err(inst_76518);
var inst_76520 = cljs.core.clj__GT_js(inst_76519);
var inst_76521 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76520) : resolve.call(null,inst_76520));
var _ = (function (){var statearr_76540 = state_76526;
(statearr_76540[(4)] = cljs.core.rest((state_76526[(4)])));

return statearr_76540;
})();
var state_76526__$1 = state_76526;
var statearr_76541_76557 = state_76526__$1;
(statearr_76541_76557[(2)] = inst_76521);

(statearr_76541_76557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76527 === (8))){
var inst_76511 = (state_76526[(8)]);
var inst_76511__$1 = (state_76526[(2)]);
var inst_76512 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76511__$1], 0));
var state_76526__$1 = (function (){var statearr_76542 = state_76526;
(statearr_76542[(8)] = inst_76511__$1);

return statearr_76542;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76526__$1,(9),inst_76512);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76543 = [null,null,null,null,null,null,null,null,null];
(statearr_76543[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76543[(1)] = (1));

return statearr_76543;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76526){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76526);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76544){var ex__2730__auto__ = e76544;
var statearr_76545_76558 = state_76526;
(statearr_76545_76558[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76526[(4)]))){
var statearr_76546_76559 = state_76526;
(statearr_76546_76559[(1)] = cljs.core.first((state_76526[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76560 = state_76526;
state_76526 = G__76560;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76526){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76547 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76547[(6)] = c__2749__auto__);

return statearr_76547;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 *     start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 *     containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__76562 = arguments.length;
switch (G__76562) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76600){
var state_val_76601 = (state_76600[(1)]);
if((state_val_76601 === (7))){
var inst_76578 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76600__$1 = state_76600;
var statearr_76602_76623 = state_76600__$1;
(statearr_76602_76623[(2)] = inst_76578);

(statearr_76602_76623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76601 === (1))){
var state_76600__$1 = state_76600;
var statearr_76603_76624 = state_76600__$1;
(statearr_76603_76624[(2)] = null);

(statearr_76603_76624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76601 === (4))){
var inst_76563 = (state_76600[(2)]);
var inst_76564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76565 = [inst_76563];
var inst_76566 = (new cljs.core.PersistentVector(null,1,(5),inst_76564,inst_76565,null));
var inst_76567 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76566);
var inst_76568 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76563) : reject.call(null,inst_76563));
var state_76600__$1 = (function (){var statearr_76604 = state_76600;
(statearr_76604[(7)] = inst_76567);

return statearr_76604;
})();
var statearr_76605_76625 = state_76600__$1;
(statearr_76605_76625[(2)] = inst_76568);

(statearr_76605_76625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76601 === (6))){
var state_76600__$1 = state_76600;
var statearr_76606_76626 = state_76600__$1;
(statearr_76606_76626[(2)] = null);

(statearr_76606_76626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76601 === (3))){
var inst_76598 = (state_76600[(2)]);
var state_76600__$1 = state_76600;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76600__$1,inst_76598);
} else {
if((state_val_76601 === (2))){
var _ = (function (){var statearr_76608 = state_76600;
(statearr_76608[(4)] = cljs.core.cons((5),(state_76600[(4)])));

return statearr_76608;
})();
var inst_76575 = (opts == null);
var state_76600__$1 = state_76600;
if(cljs.core.truth_(inst_76575)){
var statearr_76609_76627 = state_76600__$1;
(statearr_76609_76627[(1)] = (6));

} else {
var statearr_76610_76628 = state_76600__$1;
(statearr_76610_76628[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76601 === (9))){
var inst_76580 = (state_76600[(8)]);
var inst_76584 = (state_76600[(9)]);
var inst_76583 = (state_76600[(10)]);
var inst_76587 = (state_76600[(2)]);
var inst_76588 = fluree.db.util.async.throw_err(inst_76587);
var inst_76589 = fluree.db.query.block.block_range(inst_76588,inst_76583,inst_76584,inst_76580);
var state_76600__$1 = state_76600;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76600__$1,(10),inst_76589);
} else {
if((state_val_76601 === (5))){
var _ = (function (){var statearr_76611 = state_76600;
(statearr_76611[(4)] = cljs.core.rest((state_76600[(4)])));

return statearr_76611;
})();
var state_76600__$1 = state_76600;
var ex76607 = (state_76600__$1[(2)]);
var statearr_76612_76629 = state_76600__$1;
(statearr_76612_76629[(5)] = ex76607);


var statearr_76613_76630 = state_76600__$1;
(statearr_76613_76630[(1)] = (4));

(statearr_76613_76630[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76601 === (10))){
var inst_76591 = (state_76600[(2)]);
var inst_76592 = fluree.db.util.async.throw_err(inst_76591);
var inst_76593 = fluree.db.query.range.block_with_tx_data(inst_76592);
var inst_76594 = cljs.core.clj__GT_js(inst_76593);
var inst_76595 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76594) : resolve.call(null,inst_76594));
var _ = (function (){var statearr_76614 = state_76600;
(statearr_76614[(4)] = cljs.core.rest((state_76600[(4)])));

return statearr_76614;
})();
var state_76600__$1 = state_76600;
var statearr_76615_76631 = state_76600__$1;
(statearr_76615_76631[(2)] = inst_76595);

(statearr_76615_76631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76601 === (8))){
var inst_76580 = (state_76600[(8)]);
var inst_76580__$1 = (state_76600[(2)]);
var inst_76581 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_76582 = cljs.core.__destructure_map(inst_76581);
var inst_76583 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76582,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_76584 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76582,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_76585 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76580__$1], 0));
var state_76600__$1 = (function (){var statearr_76616 = state_76600;
(statearr_76616[(8)] = inst_76580__$1);

(statearr_76616[(9)] = inst_76584);

(statearr_76616[(10)] = inst_76583);

return statearr_76616;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76600__$1,(9),inst_76585);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76617 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_76617[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76617[(1)] = (1));

return statearr_76617;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76600){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76600);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76618){var ex__2730__auto__ = e76618;
var statearr_76619_76632 = state_76600;
(statearr_76619_76632[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76600[(4)]))){
var statearr_76620_76633 = state_76600;
(statearr_76620_76633[(1)] = cljs.core.first((state_76600[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76634 = state_76600;
state_76600 = G__76634;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76600){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76621 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76621[(6)] = c__2749__auto__);

return statearr_76621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__76636 = arguments.length;
switch (G__76636) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76706){
var state_val_76707 = (state_76706[(1)]);
if((state_val_76707 === (7))){
var inst_76652 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76706__$1 = state_76706;
var statearr_76708_76749 = state_76706__$1;
(statearr_76708_76749[(2)] = inst_76652);

(statearr_76708_76749[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (20))){
var inst_76654 = (state_76706[(7)]);
var inst_76648 = (state_76706[(8)]);
var inst_76690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76691 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_76692 = (new cljs.core.PersistentVector(null,1,(5),inst_76690,inst_76691,null));
var inst_76693 = cljs.core.assoc_in(inst_76654,inst_76692,new cljs.core.Keyword(null,"block","block",664686210));
var inst_76694 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_76648,inst_76693);
var state_76706__$1 = state_76706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76706__$1,(23),inst_76694);
} else {
if((state_val_76707 === (1))){
var state_76706__$1 = state_76706;
var statearr_76709_76750 = state_76706__$1;
(statearr_76709_76750[(2)] = null);

(statearr_76709_76750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (4))){
var inst_76637 = (state_76706[(2)]);
var inst_76638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76639 = [inst_76637];
var inst_76640 = (new cljs.core.PersistentVector(null,1,(5),inst_76638,inst_76639,null));
var inst_76641 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76640);
var inst_76642 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76637) : reject.call(null,inst_76637));
var state_76706__$1 = (function (){var statearr_76710 = state_76706;
(statearr_76710[(9)] = inst_76641);

return statearr_76710;
})();
var statearr_76711_76751 = state_76706__$1;
(statearr_76711_76751[(2)] = inst_76642);

(statearr_76711_76751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (15))){
var inst_76678 = (state_76706[(2)]);
var inst_76679 = fluree.db.util.async.throw_err(inst_76678);
var state_76706__$1 = state_76706;
var statearr_76712_76752 = state_76706__$1;
(statearr_76712_76752[(2)] = inst_76679);

(statearr_76712_76752[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (21))){
var inst_76699 = (state_76706[(2)]);
var inst_76700 = cljs.core.clj__GT_js(inst_76699);
var inst_76701 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76700) : resolve.call(null,inst_76700));
var _ = (function (){var statearr_76713 = state_76706;
(statearr_76713[(4)] = cljs.core.rest((state_76706[(4)])));

return statearr_76713;
})();
var state_76706__$1 = state_76706;
var statearr_76714_76753 = state_76706__$1;
(statearr_76714_76753[(2)] = inst_76701);

(statearr_76714_76753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (13))){
var state_76706__$1 = state_76706;
var statearr_76715_76754 = state_76706__$1;
(statearr_76715_76754[(2)] = null);

(statearr_76715_76754[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (22))){
var inst_76687 = (state_76706[(2)]);
var inst_76688 = fluree.db.util.async.throw_err(inst_76687);
var state_76706__$1 = state_76706;
var statearr_76716_76755 = state_76706__$1;
(statearr_76716_76755[(2)] = inst_76688);

(statearr_76716_76755[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (6))){
var state_76706__$1 = state_76706;
var statearr_76717_76756 = state_76706__$1;
(statearr_76717_76756[(2)] = null);

(statearr_76717_76756[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (17))){
var state_76706__$1 = state_76706;
var statearr_76718_76757 = state_76706__$1;
(statearr_76718_76757[(2)] = null);

(statearr_76718_76757[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (3))){
var inst_76704 = (state_76706[(2)]);
var state_76706__$1 = state_76706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76706__$1,inst_76704);
} else {
if((state_val_76707 === (12))){
var inst_76662 = (state_76706[(10)]);
var inst_76666 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_76706__$1 = (function (){var statearr_76719 = state_76706;
(statearr_76719[(11)] = inst_76666);

return statearr_76719;
})();
if(cljs.core.truth_(inst_76662)){
var statearr_76720_76758 = state_76706__$1;
(statearr_76720_76758[(1)] = (16));

} else {
var statearr_76721_76759 = state_76706__$1;
(statearr_76721_76759[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (2))){
var _ = (function (){var statearr_76722 = state_76706;
(statearr_76722[(4)] = cljs.core.cons((5),(state_76706[(4)])));

return statearr_76722;
})();
var inst_76648 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_76649 = (opts == null);
var state_76706__$1 = (function (){var statearr_76723 = state_76706;
(statearr_76723[(8)] = inst_76648);

return statearr_76723;
})();
if(cljs.core.truth_(inst_76649)){
var statearr_76724_76760 = state_76706__$1;
(statearr_76724_76760[(1)] = (6));

} else {
var statearr_76725_76761 = state_76706__$1;
(statearr_76725_76761[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (23))){
var inst_76696 = (state_76706[(2)]);
var inst_76697 = fluree.db.util.async.throw_err(inst_76696);
var state_76706__$1 = state_76706;
var statearr_76726_76762 = state_76706__$1;
(statearr_76726_76762[(2)] = inst_76697);

(statearr_76726_76762[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (19))){
var inst_76682 = (state_76706[(12)]);
var inst_76654 = (state_76706[(7)]);
var inst_76648 = (state_76706[(8)]);
var inst_76685 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_76682,inst_76648,inst_76654);
var state_76706__$1 = state_76706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76706__$1,(22),inst_76685);
} else {
if((state_val_76707 === (11))){
var inst_76656 = (state_76706[(13)]);
var inst_76654 = (state_76706[(7)]);
var inst_76662 = (state_76706[(2)]);
var inst_76663 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_76654);
var inst_76664 = (inst_76656 == null);
var state_76706__$1 = (function (){var statearr_76728 = state_76706;
(statearr_76728[(10)] = inst_76662);

(statearr_76728[(14)] = inst_76663);

return statearr_76728;
})();
if(cljs.core.truth_(inst_76664)){
var statearr_76729_76763 = state_76706__$1;
(statearr_76729_76763[(1)] = (12));

} else {
var statearr_76730_76764 = state_76706__$1;
(statearr_76730_76764[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (9))){
var inst_76657 = (state_76706[(15)]);
var state_76706__$1 = state_76706;
var statearr_76731_76765 = state_76706__$1;
(statearr_76731_76765[(2)] = inst_76657);

(statearr_76731_76765[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (5))){
var _ = (function (){var statearr_76732 = state_76706;
(statearr_76732[(4)] = cljs.core.rest((state_76706[(4)])));

return statearr_76732;
})();
var state_76706__$1 = state_76706;
var ex76727 = (state_76706__$1[(2)]);
var statearr_76733_76766 = state_76706__$1;
(statearr_76733_76766[(5)] = ex76727);


var statearr_76734_76767 = state_76706__$1;
(statearr_76734_76767[(1)] = (4));

(statearr_76734_76767[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (14))){
var inst_76656 = (state_76706[(13)]);
var inst_76682 = (state_76706[(2)]);
var inst_76683 = (inst_76656 == null);
var state_76706__$1 = (function (){var statearr_76735 = state_76706;
(statearr_76735[(12)] = inst_76682);

return statearr_76735;
})();
if(cljs.core.truth_(inst_76683)){
var statearr_76736_76768 = state_76706__$1;
(statearr_76736_76768[(1)] = (19));

} else {
var statearr_76737_76769 = state_76706__$1;
(statearr_76737_76769[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (16))){
var inst_76662 = (state_76706[(10)]);
var inst_76668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76669 = ["_auth/id",inst_76662];
var inst_76670 = (new cljs.core.PersistentVector(null,2,(5),inst_76668,inst_76669,null));
var state_76706__$1 = state_76706;
var statearr_76738_76770 = state_76706__$1;
(statearr_76738_76770[(2)] = inst_76670);

(statearr_76738_76770[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (10))){
var inst_76654 = (state_76706[(7)]);
var inst_76660 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_76654);
var state_76706__$1 = state_76706;
var statearr_76739_76771 = state_76706__$1;
(statearr_76739_76771[(2)] = inst_76660);

(statearr_76739_76771[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76707 === (18))){
var inst_76666 = (state_76706[(11)]);
var inst_76663 = (state_76706[(14)]);
var inst_76673 = (state_76706[(2)]);
var inst_76674 = [inst_76673,inst_76663];
var inst_76675 = cljs.core.PersistentHashMap.fromArrays(inst_76666,inst_76674);
var inst_76676 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76675], 0));
var state_76706__$1 = state_76706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76706__$1,(15),inst_76676);
} else {
if((state_val_76707 === (8))){
var inst_76654 = (state_76706[(7)]);
var inst_76657 = (state_76706[(15)]);
var inst_76654__$1 = (state_76706[(2)]);
var inst_76655 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_76654__$1);
var inst_76656 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_76654__$1);
var inst_76657__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_76654__$1);
var state_76706__$1 = (function (){var statearr_76740 = state_76706;
(statearr_76740[(13)] = inst_76656);

(statearr_76740[(16)] = inst_76655);

(statearr_76740[(7)] = inst_76654__$1);

(statearr_76740[(15)] = inst_76657__$1);

return statearr_76740;
})();
if(cljs.core.truth_(inst_76657__$1)){
var statearr_76741_76772 = state_76706__$1;
(statearr_76741_76772[(1)] = (9));

} else {
var statearr_76742_76773 = state_76706__$1;
(statearr_76742_76773[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76743 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76743[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76743[(1)] = (1));

return statearr_76743;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76706){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76706);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76744){var ex__2730__auto__ = e76744;
var statearr_76745_76774 = state_76706;
(statearr_76745_76774[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76706[(4)]))){
var statearr_76746_76775 = state_76706;
(statearr_76746_76775[(1)] = cljs.core.first((state_76706[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76776 = state_76706;
state_76706 = G__76776;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76706){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76747 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76747[(6)] = c__2749__auto__);

return statearr_76747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76799){
var state_val_76800 = (state_76799[(1)]);
if((state_val_76800 === (1))){
var state_76799__$1 = state_76799;
var statearr_76801_76816 = state_76799__$1;
(statearr_76801_76816[(2)] = null);

(statearr_76801_76816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76800 === (2))){
var _ = (function (){var statearr_76802 = state_76799;
(statearr_76802[(4)] = cljs.core.cons((5),(state_76799[(4)])));

return statearr_76802;
})();
var inst_76788 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_76789 = fluree.db.api.query.history_query_async(sources,inst_76788);
var state_76799__$1 = state_76799;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76799__$1,(6),inst_76789);
} else {
if((state_val_76800 === (3))){
var inst_76797 = (state_76799[(2)]);
var state_76799__$1 = state_76799;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76799__$1,inst_76797);
} else {
if((state_val_76800 === (4))){
var inst_76777 = (state_76799[(2)]);
var inst_76778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76779 = [inst_76777];
var inst_76780 = (new cljs.core.PersistentVector(null,1,(5),inst_76778,inst_76779,null));
var inst_76781 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76780);
var inst_76782 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76777) : reject.call(null,inst_76777));
var state_76799__$1 = (function (){var statearr_76804 = state_76799;
(statearr_76804[(7)] = inst_76781);

return statearr_76804;
})();
var statearr_76805_76817 = state_76799__$1;
(statearr_76805_76817[(2)] = inst_76782);

(statearr_76805_76817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76800 === (5))){
var _ = (function (){var statearr_76806 = state_76799;
(statearr_76806[(4)] = cljs.core.rest((state_76799[(4)])));

return statearr_76806;
})();
var state_76799__$1 = state_76799;
var ex76803 = (state_76799__$1[(2)]);
var statearr_76807_76818 = state_76799__$1;
(statearr_76807_76818[(5)] = ex76803);


var statearr_76808_76819 = state_76799__$1;
(statearr_76808_76819[(1)] = (4));

(statearr_76808_76819[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76800 === (6))){
var inst_76791 = (state_76799[(2)]);
var inst_76792 = fluree.db.util.async.throw_err(inst_76791);
var inst_76793 = cljs.core.clj__GT_js(inst_76792);
var inst_76794 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76793) : resolve.call(null,inst_76793));
var _ = (function (){var statearr_76809 = state_76799;
(statearr_76809[(4)] = cljs.core.rest((state_76799[(4)])));

return statearr_76809;
})();
var state_76799__$1 = state_76799;
var statearr_76810_76820 = state_76799__$1;
(statearr_76810_76820[(2)] = inst_76794);

(statearr_76810_76820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__2727__auto__ = null;
var flureedb$history_query_$_state_machine__2727__auto____0 = (function (){
var statearr_76811 = [null,null,null,null,null,null,null,null];
(statearr_76811[(0)] = flureedb$history_query_$_state_machine__2727__auto__);

(statearr_76811[(1)] = (1));

return statearr_76811;
});
var flureedb$history_query_$_state_machine__2727__auto____1 = (function (state_76799){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76799);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76812){var ex__2730__auto__ = e76812;
var statearr_76813_76821 = state_76799;
(statearr_76813_76821[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76799[(4)]))){
var statearr_76814_76822 = state_76799;
(statearr_76814_76822[(1)] = cljs.core.first((state_76799[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76823 = state_76799;
state_76799 = G__76823;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__2727__auto__ = function(state_76799){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__2727__auto____1.call(this,state_76799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__2727__auto____0;
flureedb$history_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__2727__auto____1;
return flureedb$history_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76815 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76815[(6)] = c__2749__auto__);

return statearr_76815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76846){
var state_val_76847 = (state_76846[(1)]);
if((state_val_76847 === (1))){
var state_76846__$1 = state_76846;
var statearr_76848_76863 = state_76846__$1;
(statearr_76848_76863[(2)] = null);

(statearr_76848_76863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76847 === (2))){
var _ = (function (){var statearr_76849 = state_76846;
(statearr_76849[(4)] = cljs.core.cons((5),(state_76846[(4)])));

return statearr_76849;
})();
var inst_76835 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_76836 = fluree.db.api.query.multi_query_async(sources,inst_76835);
var state_76846__$1 = state_76846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76846__$1,(6),inst_76836);
} else {
if((state_val_76847 === (3))){
var inst_76844 = (state_76846[(2)]);
var state_76846__$1 = state_76846;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76846__$1,inst_76844);
} else {
if((state_val_76847 === (4))){
var inst_76824 = (state_76846[(2)]);
var inst_76825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76826 = [inst_76824];
var inst_76827 = (new cljs.core.PersistentVector(null,1,(5),inst_76825,inst_76826,null));
var inst_76828 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76827);
var inst_76829 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76824) : reject.call(null,inst_76824));
var state_76846__$1 = (function (){var statearr_76851 = state_76846;
(statearr_76851[(7)] = inst_76828);

return statearr_76851;
})();
var statearr_76852_76864 = state_76846__$1;
(statearr_76852_76864[(2)] = inst_76829);

(statearr_76852_76864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76847 === (5))){
var _ = (function (){var statearr_76853 = state_76846;
(statearr_76853[(4)] = cljs.core.rest((state_76846[(4)])));

return statearr_76853;
})();
var state_76846__$1 = state_76846;
var ex76850 = (state_76846__$1[(2)]);
var statearr_76854_76865 = state_76846__$1;
(statearr_76854_76865[(5)] = ex76850);


var statearr_76855_76866 = state_76846__$1;
(statearr_76855_76866[(1)] = (4));

(statearr_76855_76866[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76847 === (6))){
var inst_76838 = (state_76846[(2)]);
var inst_76839 = fluree.db.util.async.throw_err(inst_76838);
var inst_76840 = cljs.core.clj__GT_js(inst_76839);
var inst_76841 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76840) : resolve.call(null,inst_76840));
var _ = (function (){var statearr_76856 = state_76846;
(statearr_76856[(4)] = cljs.core.rest((state_76846[(4)])));

return statearr_76856;
})();
var state_76846__$1 = state_76846;
var statearr_76857_76867 = state_76846__$1;
(statearr_76857_76867[(2)] = inst_76841);

(statearr_76857_76867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__2727__auto__ = null;
var flureedb$multi_query_$_state_machine__2727__auto____0 = (function (){
var statearr_76858 = [null,null,null,null,null,null,null,null];
(statearr_76858[(0)] = flureedb$multi_query_$_state_machine__2727__auto__);

(statearr_76858[(1)] = (1));

return statearr_76858;
});
var flureedb$multi_query_$_state_machine__2727__auto____1 = (function (state_76846){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76846);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76859){var ex__2730__auto__ = e76859;
var statearr_76860_76868 = state_76846;
(statearr_76860_76868[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76846[(4)]))){
var statearr_76861_76869 = state_76846;
(statearr_76861_76869[(1)] = cljs.core.first((state_76846[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76870 = state_76846;
state_76846 = G__76870;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__2727__auto__ = function(state_76846){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__2727__auto____1.call(this,state_76846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__2727__auto____0;
flureedb$multi_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__2727__auto____1;
return flureedb$multi_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76862 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76862[(6)] = c__2749__auto__);

return statearr_76862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76893){
var state_val_76894 = (state_76893[(1)]);
if((state_val_76894 === (1))){
var state_76893__$1 = state_76893;
var statearr_76895_76910 = state_76893__$1;
(statearr_76895_76910[(2)] = null);

(statearr_76895_76910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76894 === (2))){
var _ = (function (){var statearr_76896 = state_76893;
(statearr_76896[(4)] = cljs.core.cons((5),(state_76893[(4)])));

return statearr_76896;
})();
var inst_76883 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_76884 = fluree.db.api.query.query_async(sources,inst_76883);
var state_76893__$1 = state_76893;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76893__$1,(6),inst_76884);
} else {
if((state_val_76894 === (3))){
var inst_76891 = (state_76893[(2)]);
var state_76893__$1 = state_76893;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76893__$1,inst_76891);
} else {
if((state_val_76894 === (4))){
var inst_76871 = (state_76893[(2)]);
var inst_76872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76873 = [inst_76871];
var inst_76874 = (new cljs.core.PersistentVector(null,1,(5),inst_76872,inst_76873,null));
var inst_76875 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76874);
var inst_76876 = cljs.core.clj__GT_js(inst_76871);
var inst_76877 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76876) : reject.call(null,inst_76876));
var state_76893__$1 = (function (){var statearr_76898 = state_76893;
(statearr_76898[(7)] = inst_76875);

return statearr_76898;
})();
var statearr_76899_76911 = state_76893__$1;
(statearr_76899_76911[(2)] = inst_76877);

(statearr_76899_76911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76894 === (5))){
var _ = (function (){var statearr_76900 = state_76893;
(statearr_76900[(4)] = cljs.core.rest((state_76893[(4)])));

return statearr_76900;
})();
var state_76893__$1 = state_76893;
var ex76897 = (state_76893__$1[(2)]);
var statearr_76901_76912 = state_76893__$1;
(statearr_76901_76912[(5)] = ex76897);


var statearr_76902_76913 = state_76893__$1;
(statearr_76902_76913[(1)] = (4));

(statearr_76902_76913[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76894 === (6))){
var inst_76886 = (state_76893[(2)]);
var inst_76887 = cljs.core.clj__GT_js(inst_76886);
var inst_76888 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76887) : resolve.call(null,inst_76887));
var _ = (function (){var statearr_76903 = state_76893;
(statearr_76903[(4)] = cljs.core.rest((state_76893[(4)])));

return statearr_76903;
})();
var state_76893__$1 = state_76893;
var statearr_76904_76914 = state_76893__$1;
(statearr_76904_76914[(2)] = inst_76888);

(statearr_76904_76914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__2727__auto__ = null;
var flureedb$query_$_state_machine__2727__auto____0 = (function (){
var statearr_76905 = [null,null,null,null,null,null,null,null];
(statearr_76905[(0)] = flureedb$query_$_state_machine__2727__auto__);

(statearr_76905[(1)] = (1));

return statearr_76905;
});
var flureedb$query_$_state_machine__2727__auto____1 = (function (state_76893){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76893);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76906){var ex__2730__auto__ = e76906;
var statearr_76907_76915 = state_76893;
(statearr_76907_76915[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76893[(4)]))){
var statearr_76908_76916 = state_76893;
(statearr_76908_76916[(1)] = cljs.core.first((state_76893[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76917 = state_76893;
state_76893 = G__76917;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$query_$_state_machine__2727__auto__ = function(state_76893){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__2727__auto____1.call(this,state_76893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__2727__auto____0;
flureedb$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__2727__auto____1;
return flureedb$query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76909 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76909[(6)] = c__2749__auto__);

return statearr_76909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__76919 = arguments.length;
switch (G__76919) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76949){
var state_val_76950 = (state_76949[(1)]);
if((state_val_76950 === (7))){
var inst_76936 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76949__$1 = state_76949;
var statearr_76951_76972 = state_76949__$1;
(statearr_76951_76972[(2)] = inst_76936);

(statearr_76951_76972[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76950 === (1))){
var state_76949__$1 = state_76949;
var statearr_76952_76973 = state_76949__$1;
(statearr_76952_76973[(2)] = null);

(statearr_76952_76973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76950 === (4))){
var inst_76920 = (state_76949[(2)]);
var inst_76921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76922 = [inst_76920];
var inst_76923 = (new cljs.core.PersistentVector(null,1,(5),inst_76921,inst_76922,null));
var inst_76924 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76923);
var inst_76925 = cljs.core.clj__GT_js(inst_76920);
var inst_76926 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76925) : reject.call(null,inst_76925));
var state_76949__$1 = (function (){var statearr_76953 = state_76949;
(statearr_76953[(7)] = inst_76924);

return statearr_76953;
})();
var statearr_76954_76974 = state_76949__$1;
(statearr_76954_76974[(2)] = inst_76926);

(statearr_76954_76974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76950 === (6))){
var state_76949__$1 = state_76949;
var statearr_76955_76975 = state_76949__$1;
(statearr_76955_76975[(2)] = null);

(statearr_76955_76975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76950 === (3))){
var inst_76947 = (state_76949[(2)]);
var state_76949__$1 = state_76949;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76949__$1,inst_76947);
} else {
if((state_val_76950 === (2))){
var _ = (function (){var statearr_76957 = state_76949;
(statearr_76957[(4)] = cljs.core.cons((5),(state_76949[(4)])));

return statearr_76957;
})();
var inst_76932 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_76933 = (opts == null);
var state_76949__$1 = (function (){var statearr_76958 = state_76949;
(statearr_76958[(8)] = inst_76932);

return statearr_76958;
})();
if(cljs.core.truth_(inst_76933)){
var statearr_76959_76976 = state_76949__$1;
(statearr_76959_76976[(1)] = (6));

} else {
var statearr_76960_76977 = state_76949__$1;
(statearr_76960_76977[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76950 === (9))){
var inst_76941 = (state_76949[(2)]);
var inst_76942 = fluree.db.util.async.throw_err(inst_76941);
var inst_76943 = cljs.core.clj__GT_js(inst_76942);
var inst_76944 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76943) : resolve.call(null,inst_76943));
var _ = (function (){var statearr_76961 = state_76949;
(statearr_76961[(4)] = cljs.core.rest((state_76949[(4)])));

return statearr_76961;
})();
var state_76949__$1 = state_76949;
var statearr_76962_76978 = state_76949__$1;
(statearr_76962_76978[(2)] = inst_76944);

(statearr_76962_76978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76950 === (5))){
var _ = (function (){var statearr_76963 = state_76949;
(statearr_76963[(4)] = cljs.core.rest((state_76949[(4)])));

return statearr_76963;
})();
var state_76949__$1 = state_76949;
var ex76956 = (state_76949__$1[(2)]);
var statearr_76964_76979 = state_76949__$1;
(statearr_76964_76979[(5)] = ex76956);


var statearr_76965_76980 = state_76949__$1;
(statearr_76965_76980[(1)] = (4));

(statearr_76965_76980[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76950 === (8))){
var inst_76932 = (state_76949[(8)]);
var inst_76938 = (state_76949[(2)]);
var inst_76939 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_76932,inst_76938);
var state_76949__$1 = state_76949;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76949__$1,(9),inst_76939);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76966 = [null,null,null,null,null,null,null,null,null];
(statearr_76966[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76966[(1)] = (1));

return statearr_76966;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76949){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76949);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76967){var ex__2730__auto__ = e76967;
var statearr_76968_76981 = state_76949;
(statearr_76968_76981[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76949[(4)]))){
var statearr_76969_76982 = state_76949;
(statearr_76969_76982[(1)] = cljs.core.first((state_76949[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76983 = state_76949;
state_76949 = G__76983;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76949){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76970 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76970[(6)] = c__2749__auto__);

return statearr_76970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *    any key, and a two-argument function that will be called with each event.
 * 
 *    The key is any arbitrary key, and is only used to close the listener via close-listener,
 *    otherwise it is opaque to the listener.
 * 
 *    The callback function's first argument is the event header/metadata and the second argument
 *    is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
