// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
goog.scope(function(){
cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__11041 = arguments.length;
switch (G__11041) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11042 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11042 = (function (f,blockable,meta11043){
this.f = f;
this.blockable = blockable;
this.meta11043 = meta11043;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11042.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11044,meta11043__$1){
var self__ = this;
var _11044__$1 = this;
return (new cljs.core.async.t_cljs$core$async11042(self__.f,self__.blockable,meta11043__$1));
}));

(cljs.core.async.t_cljs$core$async11042.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11044){
var self__ = this;
var _11044__$1 = this;
return self__.meta11043;
}));

(cljs.core.async.t_cljs$core$async11042.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11042.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11042.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async11042.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async11042.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11043","meta11043",1865792108,null)], null);
}));

(cljs.core.async.t_cljs$core$async11042.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11042.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11042");

(cljs.core.async.t_cljs$core$async11042.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async11042");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11042.
 */
cljs.core.async.__GT_t_cljs$core$async11042 = (function cljs$core$async$__GT_t_cljs$core$async11042(f__$1,blockable__$1,meta11043){
return (new cljs.core.async.t_cljs$core$async11042(f__$1,blockable__$1,meta11043));
});

}

return (new cljs.core.async.t_cljs$core$async11042(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__11048 = arguments.length;
switch (G__11048) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__11051 = arguments.length;
switch (G__11051) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__11054 = arguments.length;
switch (G__11054) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11056 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11056);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_11056);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__11058 = arguments.length;
switch (G__11058) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4741__auto___11060 = n;
var x_11061 = (0);
while(true){
if((x_11061 < n__4741__auto___11060)){
(a[x_11061] = x_11061);

var G__11062 = (x_11061 + (1));
x_11061 = G__11062;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle.call(null,a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11063 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11063 = (function (flag,meta11064){
this.flag = flag;
this.meta11064 = meta11064;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11063.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11065,meta11064__$1){
var self__ = this;
var _11065__$1 = this;
return (new cljs.core.async.t_cljs$core$async11063(self__.flag,meta11064__$1));
}));

(cljs.core.async.t_cljs$core$async11063.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11065){
var self__ = this;
var _11065__$1 = this;
return self__.meta11064;
}));

(cljs.core.async.t_cljs$core$async11063.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11063.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async11063.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11063.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async11063.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11064","meta11064",1358545818,null)], null);
}));

(cljs.core.async.t_cljs$core$async11063.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11063.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11063");

(cljs.core.async.t_cljs$core$async11063.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async11063");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11063.
 */
cljs.core.async.__GT_t_cljs$core$async11063 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11063(flag__$1,meta11064){
return (new cljs.core.async.t_cljs$core$async11063(flag__$1,meta11064));
});

}

return (new cljs.core.async.t_cljs$core$async11063(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11066 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11066 = (function (flag,cb,meta11067){
this.flag = flag;
this.cb = cb;
this.meta11067 = meta11067;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11066.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11068,meta11067__$1){
var self__ = this;
var _11068__$1 = this;
return (new cljs.core.async.t_cljs$core$async11066(self__.flag,self__.cb,meta11067__$1));
}));

(cljs.core.async.t_cljs$core$async11066.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11068){
var self__ = this;
var _11068__$1 = this;
return self__.meta11067;
}));

(cljs.core.async.t_cljs$core$async11066.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11066.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async11066.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11066.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async11066.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11067","meta11067",-746169440,null)], null);
}));

(cljs.core.async.t_cljs$core$async11066.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11066.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11066");

(cljs.core.async.t_cljs$core$async11066.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async11066");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11066.
 */
cljs.core.async.__GT_t_cljs$core$async11066 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11066(flag__$1,cb__$1,meta11067){
return (new cljs.core.async.t_cljs$core$async11066(flag__$1,cb__$1,meta11067));
});

}

return (new cljs.core.async.t_cljs$core$async11066(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11069_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11069_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11070_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11070_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4253__auto__ = wport;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11071 = (i + (1));
i = G__11071;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4253__auto__ = ret;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4251__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___11076 = arguments.length;
var i__4865__auto___11077 = (0);
while(true){
if((i__4865__auto___11077 < len__4864__auto___11076)){
args__4870__auto__.push((arguments[i__4865__auto___11077]));

var G__11078 = (i__4865__auto___11077 + (1));
i__4865__auto___11077 = G__11078;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11074){
var map__11075 = p__11074;
var map__11075__$1 = cljs.core.__destructure_map.call(null,map__11075);
var opts = map__11075__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11072){
var G__11073 = cljs.core.first.call(null,seq11072);
var seq11072__$1 = cljs.core.next.call(null,seq11072);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11073,seq11072__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__11080 = arguments.length;
switch (G__11080) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__10981__auto___11127 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_11104){
var state_val_11105 = (state_11104[(1)]);
if((state_val_11105 === (7))){
var inst_11100 = (state_11104[(2)]);
var state_11104__$1 = state_11104;
var statearr_11106_11128 = state_11104__$1;
(statearr_11106_11128[(2)] = inst_11100);

(statearr_11106_11128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11105 === (1))){
var state_11104__$1 = state_11104;
var statearr_11107_11129 = state_11104__$1;
(statearr_11107_11129[(2)] = null);

(statearr_11107_11129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11105 === (4))){
var inst_11083 = (state_11104[(7)]);
var inst_11083__$1 = (state_11104[(2)]);
var inst_11084 = (inst_11083__$1 == null);
var state_11104__$1 = (function (){var statearr_11108 = state_11104;
(statearr_11108[(7)] = inst_11083__$1);

return statearr_11108;
})();
if(cljs.core.truth_(inst_11084)){
var statearr_11109_11130 = state_11104__$1;
(statearr_11109_11130[(1)] = (5));

} else {
var statearr_11110_11131 = state_11104__$1;
(statearr_11110_11131[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11105 === (13))){
var state_11104__$1 = state_11104;
var statearr_11111_11132 = state_11104__$1;
(statearr_11111_11132[(2)] = null);

(statearr_11111_11132[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11105 === (6))){
var inst_11083 = (state_11104[(7)]);
var state_11104__$1 = state_11104;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11104__$1,(11),to,inst_11083);
} else {
if((state_val_11105 === (3))){
var inst_11102 = (state_11104[(2)]);
var state_11104__$1 = state_11104;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11104__$1,inst_11102);
} else {
if((state_val_11105 === (12))){
var state_11104__$1 = state_11104;
var statearr_11112_11133 = state_11104__$1;
(statearr_11112_11133[(2)] = null);

(statearr_11112_11133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11105 === (2))){
var state_11104__$1 = state_11104;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11104__$1,(4),from);
} else {
if((state_val_11105 === (11))){
var inst_11093 = (state_11104[(2)]);
var state_11104__$1 = state_11104;
if(cljs.core.truth_(inst_11093)){
var statearr_11113_11134 = state_11104__$1;
(statearr_11113_11134[(1)] = (12));

} else {
var statearr_11114_11135 = state_11104__$1;
(statearr_11114_11135[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11105 === (9))){
var state_11104__$1 = state_11104;
var statearr_11115_11136 = state_11104__$1;
(statearr_11115_11136[(2)] = null);

(statearr_11115_11136[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11105 === (5))){
var state_11104__$1 = state_11104;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11116_11137 = state_11104__$1;
(statearr_11116_11137[(1)] = (8));

} else {
var statearr_11117_11138 = state_11104__$1;
(statearr_11117_11138[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11105 === (14))){
var inst_11098 = (state_11104[(2)]);
var state_11104__$1 = state_11104;
var statearr_11118_11139 = state_11104__$1;
(statearr_11118_11139[(2)] = inst_11098);

(statearr_11118_11139[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11105 === (10))){
var inst_11090 = (state_11104[(2)]);
var state_11104__$1 = state_11104;
var statearr_11119_11140 = state_11104__$1;
(statearr_11119_11140[(2)] = inst_11090);

(statearr_11119_11140[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11105 === (8))){
var inst_11087 = cljs.core.async.close_BANG_.call(null,to);
var state_11104__$1 = state_11104;
var statearr_11120_11141 = state_11104__$1;
(statearr_11120_11141[(2)] = inst_11087);

(statearr_11120_11141[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10908__auto__ = null;
var cljs$core$async$state_machine__10908__auto____0 = (function (){
var statearr_11121 = [null,null,null,null,null,null,null,null];
(statearr_11121[(0)] = cljs$core$async$state_machine__10908__auto__);

(statearr_11121[(1)] = (1));

return statearr_11121;
});
var cljs$core$async$state_machine__10908__auto____1 = (function (state_11104){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_11104);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e11122){var ex__10911__auto__ = e11122;
var statearr_11123_11142 = state_11104;
(statearr_11123_11142[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_11104[(4)]))){
var statearr_11124_11143 = state_11104;
(statearr_11124_11143[(1)] = cljs.core.first.call(null,(state_11104[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11144 = state_11104;
state_11104 = G__11144;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$state_machine__10908__auto__ = function(state_11104){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10908__auto____1.call(this,state_11104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10908__auto____0;
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10908__auto____1;
return cljs$core$async$state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_11125 = f__10982__auto__.call(null);
(statearr_11125[(6)] = c__10981__auto___11127);

return statearr_11125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__11145){
var vec__11146 = p__11145;
var v = cljs.core.nth.call(null,vec__11146,(0),null);
var p = cljs.core.nth.call(null,vec__11146,(1),null);
var job = vec__11146;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__10981__auto___11322 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_11153){
var state_val_11154 = (state_11153[(1)]);
if((state_val_11154 === (1))){
var state_11153__$1 = state_11153;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11153__$1,(2),res,v);
} else {
if((state_val_11154 === (2))){
var inst_11150 = (state_11153[(2)]);
var inst_11151 = cljs.core.async.close_BANG_.call(null,res);
var state_11153__$1 = (function (){var statearr_11155 = state_11153;
(statearr_11155[(7)] = inst_11150);

return statearr_11155;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11153__$1,inst_11151);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0 = (function (){
var statearr_11156 = [null,null,null,null,null,null,null,null];
(statearr_11156[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__);

(statearr_11156[(1)] = (1));

return statearr_11156;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1 = (function (state_11153){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_11153);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e11157){var ex__10911__auto__ = e11157;
var statearr_11158_11323 = state_11153;
(statearr_11158_11323[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_11153[(4)]))){
var statearr_11159_11324 = state_11153;
(statearr_11159_11324[(1)] = cljs.core.first.call(null,(state_11153[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11325 = state_11153;
state_11153 = G__11325;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__ = function(state_11153){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1.call(this,state_11153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_11160 = f__10982__auto__.call(null);
(statearr_11160[(6)] = c__10981__auto___11322);

return statearr_11160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__11161){
var vec__11162 = p__11161;
var v = cljs.core.nth.call(null,vec__11162,(0),null);
var p = cljs.core.nth.call(null,vec__11162,(1),null);
var job = vec__11162;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4741__auto___11326 = n;
var __11327 = (0);
while(true){
if((__11327 < n__4741__auto___11326)){
var G__11165_11328 = type;
var G__11165_11329__$1 = (((G__11165_11328 instanceof cljs.core.Keyword))?G__11165_11328.fqn:null);
switch (G__11165_11329__$1) {
case "compute":
var c__10981__auto___11331 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11327,c__10981__auto___11331,G__11165_11328,G__11165_11329__$1,n__4741__auto___11326,jobs,results,process,async){
return (function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = ((function (__11327,c__10981__auto___11331,G__11165_11328,G__11165_11329__$1,n__4741__auto___11326,jobs,results,process,async){
return (function (state_11178){
var state_val_11179 = (state_11178[(1)]);
if((state_val_11179 === (1))){
var state_11178__$1 = state_11178;
var statearr_11180_11332 = state_11178__$1;
(statearr_11180_11332[(2)] = null);

(statearr_11180_11332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (2))){
var state_11178__$1 = state_11178;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11178__$1,(4),jobs);
} else {
if((state_val_11179 === (3))){
var inst_11176 = (state_11178[(2)]);
var state_11178__$1 = state_11178;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11178__$1,inst_11176);
} else {
if((state_val_11179 === (4))){
var inst_11168 = (state_11178[(2)]);
var inst_11169 = process.call(null,inst_11168);
var state_11178__$1 = state_11178;
if(cljs.core.truth_(inst_11169)){
var statearr_11181_11333 = state_11178__$1;
(statearr_11181_11333[(1)] = (5));

} else {
var statearr_11182_11334 = state_11178__$1;
(statearr_11182_11334[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (5))){
var state_11178__$1 = state_11178;
var statearr_11183_11335 = state_11178__$1;
(statearr_11183_11335[(2)] = null);

(statearr_11183_11335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (6))){
var state_11178__$1 = state_11178;
var statearr_11184_11336 = state_11178__$1;
(statearr_11184_11336[(2)] = null);

(statearr_11184_11336[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (7))){
var inst_11174 = (state_11178[(2)]);
var state_11178__$1 = state_11178;
var statearr_11185_11337 = state_11178__$1;
(statearr_11185_11337[(2)] = inst_11174);

(statearr_11185_11337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11327,c__10981__auto___11331,G__11165_11328,G__11165_11329__$1,n__4741__auto___11326,jobs,results,process,async))
;
return ((function (__11327,switch__10907__auto__,c__10981__auto___11331,G__11165_11328,G__11165_11329__$1,n__4741__auto___11326,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0 = (function (){
var statearr_11186 = [null,null,null,null,null,null,null];
(statearr_11186[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__);

(statearr_11186[(1)] = (1));

return statearr_11186;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1 = (function (state_11178){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_11178);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e11187){var ex__10911__auto__ = e11187;
var statearr_11188_11338 = state_11178;
(statearr_11188_11338[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_11178[(4)]))){
var statearr_11189_11339 = state_11178;
(statearr_11189_11339[(1)] = cljs.core.first.call(null,(state_11178[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11340 = state_11178;
state_11178 = G__11340;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__ = function(state_11178){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1.call(this,state_11178);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__;
})()
;})(__11327,switch__10907__auto__,c__10981__auto___11331,G__11165_11328,G__11165_11329__$1,n__4741__auto___11326,jobs,results,process,async))
})();
var state__10983__auto__ = (function (){var statearr_11190 = f__10982__auto__.call(null);
(statearr_11190[(6)] = c__10981__auto___11331);

return statearr_11190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
});})(__11327,c__10981__auto___11331,G__11165_11328,G__11165_11329__$1,n__4741__auto___11326,jobs,results,process,async))
);


break;
case "async":
var c__10981__auto___11341 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11327,c__10981__auto___11341,G__11165_11328,G__11165_11329__$1,n__4741__auto___11326,jobs,results,process,async){
return (function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = ((function (__11327,c__10981__auto___11341,G__11165_11328,G__11165_11329__$1,n__4741__auto___11326,jobs,results,process,async){
return (function (state_11203){
var state_val_11204 = (state_11203[(1)]);
if((state_val_11204 === (1))){
var state_11203__$1 = state_11203;
var statearr_11205_11342 = state_11203__$1;
(statearr_11205_11342[(2)] = null);

(statearr_11205_11342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (2))){
var state_11203__$1 = state_11203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11203__$1,(4),jobs);
} else {
if((state_val_11204 === (3))){
var inst_11201 = (state_11203[(2)]);
var state_11203__$1 = state_11203;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11203__$1,inst_11201);
} else {
if((state_val_11204 === (4))){
var inst_11193 = (state_11203[(2)]);
var inst_11194 = async.call(null,inst_11193);
var state_11203__$1 = state_11203;
if(cljs.core.truth_(inst_11194)){
var statearr_11206_11343 = state_11203__$1;
(statearr_11206_11343[(1)] = (5));

} else {
var statearr_11207_11344 = state_11203__$1;
(statearr_11207_11344[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (5))){
var state_11203__$1 = state_11203;
var statearr_11208_11345 = state_11203__$1;
(statearr_11208_11345[(2)] = null);

(statearr_11208_11345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (6))){
var state_11203__$1 = state_11203;
var statearr_11209_11346 = state_11203__$1;
(statearr_11209_11346[(2)] = null);

(statearr_11209_11346[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11204 === (7))){
var inst_11199 = (state_11203[(2)]);
var state_11203__$1 = state_11203;
var statearr_11210_11347 = state_11203__$1;
(statearr_11210_11347[(2)] = inst_11199);

(statearr_11210_11347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11327,c__10981__auto___11341,G__11165_11328,G__11165_11329__$1,n__4741__auto___11326,jobs,results,process,async))
;
return ((function (__11327,switch__10907__auto__,c__10981__auto___11341,G__11165_11328,G__11165_11329__$1,n__4741__auto___11326,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0 = (function (){
var statearr_11211 = [null,null,null,null,null,null,null];
(statearr_11211[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__);

(statearr_11211[(1)] = (1));

return statearr_11211;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1 = (function (state_11203){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_11203);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e11212){var ex__10911__auto__ = e11212;
var statearr_11213_11348 = state_11203;
(statearr_11213_11348[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_11203[(4)]))){
var statearr_11214_11349 = state_11203;
(statearr_11214_11349[(1)] = cljs.core.first.call(null,(state_11203[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11350 = state_11203;
state_11203 = G__11350;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__ = function(state_11203){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1.call(this,state_11203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__;
})()
;})(__11327,switch__10907__auto__,c__10981__auto___11341,G__11165_11328,G__11165_11329__$1,n__4741__auto___11326,jobs,results,process,async))
})();
var state__10983__auto__ = (function (){var statearr_11215 = f__10982__auto__.call(null);
(statearr_11215[(6)] = c__10981__auto___11341);

return statearr_11215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
});})(__11327,c__10981__auto___11341,G__11165_11328,G__11165_11329__$1,n__4741__auto___11326,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11165_11329__$1)].join('')));

}

var G__11351 = (__11327 + (1));
__11327 = G__11351;
continue;
} else {
}
break;
}

var c__10981__auto___11352 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_11237){
var state_val_11238 = (state_11237[(1)]);
if((state_val_11238 === (7))){
var inst_11233 = (state_11237[(2)]);
var state_11237__$1 = state_11237;
var statearr_11239_11353 = state_11237__$1;
(statearr_11239_11353[(2)] = inst_11233);

(statearr_11239_11353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11238 === (1))){
var state_11237__$1 = state_11237;
var statearr_11240_11354 = state_11237__$1;
(statearr_11240_11354[(2)] = null);

(statearr_11240_11354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11238 === (4))){
var inst_11218 = (state_11237[(7)]);
var inst_11218__$1 = (state_11237[(2)]);
var inst_11219 = (inst_11218__$1 == null);
var state_11237__$1 = (function (){var statearr_11241 = state_11237;
(statearr_11241[(7)] = inst_11218__$1);

return statearr_11241;
})();
if(cljs.core.truth_(inst_11219)){
var statearr_11242_11355 = state_11237__$1;
(statearr_11242_11355[(1)] = (5));

} else {
var statearr_11243_11356 = state_11237__$1;
(statearr_11243_11356[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11238 === (6))){
var inst_11223 = (state_11237[(8)]);
var inst_11218 = (state_11237[(7)]);
var inst_11223__$1 = cljs.core.async.chan.call(null,(1));
var inst_11224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11225 = [inst_11218,inst_11223__$1];
var inst_11226 = (new cljs.core.PersistentVector(null,2,(5),inst_11224,inst_11225,null));
var state_11237__$1 = (function (){var statearr_11244 = state_11237;
(statearr_11244[(8)] = inst_11223__$1);

return statearr_11244;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11237__$1,(8),jobs,inst_11226);
} else {
if((state_val_11238 === (3))){
var inst_11235 = (state_11237[(2)]);
var state_11237__$1 = state_11237;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11237__$1,inst_11235);
} else {
if((state_val_11238 === (2))){
var state_11237__$1 = state_11237;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11237__$1,(4),from);
} else {
if((state_val_11238 === (9))){
var inst_11230 = (state_11237[(2)]);
var state_11237__$1 = (function (){var statearr_11245 = state_11237;
(statearr_11245[(9)] = inst_11230);

return statearr_11245;
})();
var statearr_11246_11357 = state_11237__$1;
(statearr_11246_11357[(2)] = null);

(statearr_11246_11357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11238 === (5))){
var inst_11221 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11237__$1 = state_11237;
var statearr_11247_11358 = state_11237__$1;
(statearr_11247_11358[(2)] = inst_11221);

(statearr_11247_11358[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11238 === (8))){
var inst_11223 = (state_11237[(8)]);
var inst_11228 = (state_11237[(2)]);
var state_11237__$1 = (function (){var statearr_11248 = state_11237;
(statearr_11248[(10)] = inst_11228);

return statearr_11248;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11237__$1,(9),results,inst_11223);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0 = (function (){
var statearr_11249 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11249[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__);

(statearr_11249[(1)] = (1));

return statearr_11249;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1 = (function (state_11237){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_11237);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e11250){var ex__10911__auto__ = e11250;
var statearr_11251_11359 = state_11237;
(statearr_11251_11359[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_11237[(4)]))){
var statearr_11252_11360 = state_11237;
(statearr_11252_11360[(1)] = cljs.core.first.call(null,(state_11237[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11361 = state_11237;
state_11237 = G__11361;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__ = function(state_11237){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1.call(this,state_11237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_11253 = f__10982__auto__.call(null);
(statearr_11253[(6)] = c__10981__auto___11352);

return statearr_11253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));


var c__10981__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_11291){
var state_val_11292 = (state_11291[(1)]);
if((state_val_11292 === (7))){
var inst_11287 = (state_11291[(2)]);
var state_11291__$1 = state_11291;
var statearr_11293_11362 = state_11291__$1;
(statearr_11293_11362[(2)] = inst_11287);

(statearr_11293_11362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (20))){
var state_11291__$1 = state_11291;
var statearr_11294_11363 = state_11291__$1;
(statearr_11294_11363[(2)] = null);

(statearr_11294_11363[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (1))){
var state_11291__$1 = state_11291;
var statearr_11295_11364 = state_11291__$1;
(statearr_11295_11364[(2)] = null);

(statearr_11295_11364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (4))){
var inst_11256 = (state_11291[(7)]);
var inst_11256__$1 = (state_11291[(2)]);
var inst_11257 = (inst_11256__$1 == null);
var state_11291__$1 = (function (){var statearr_11296 = state_11291;
(statearr_11296[(7)] = inst_11256__$1);

return statearr_11296;
})();
if(cljs.core.truth_(inst_11257)){
var statearr_11297_11365 = state_11291__$1;
(statearr_11297_11365[(1)] = (5));

} else {
var statearr_11298_11366 = state_11291__$1;
(statearr_11298_11366[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (15))){
var inst_11269 = (state_11291[(8)]);
var state_11291__$1 = state_11291;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11291__$1,(18),to,inst_11269);
} else {
if((state_val_11292 === (21))){
var inst_11282 = (state_11291[(2)]);
var state_11291__$1 = state_11291;
var statearr_11299_11367 = state_11291__$1;
(statearr_11299_11367[(2)] = inst_11282);

(statearr_11299_11367[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (13))){
var inst_11284 = (state_11291[(2)]);
var state_11291__$1 = (function (){var statearr_11300 = state_11291;
(statearr_11300[(9)] = inst_11284);

return statearr_11300;
})();
var statearr_11301_11368 = state_11291__$1;
(statearr_11301_11368[(2)] = null);

(statearr_11301_11368[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (6))){
var inst_11256 = (state_11291[(7)]);
var state_11291__$1 = state_11291;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11291__$1,(11),inst_11256);
} else {
if((state_val_11292 === (17))){
var inst_11277 = (state_11291[(2)]);
var state_11291__$1 = state_11291;
if(cljs.core.truth_(inst_11277)){
var statearr_11302_11369 = state_11291__$1;
(statearr_11302_11369[(1)] = (19));

} else {
var statearr_11303_11370 = state_11291__$1;
(statearr_11303_11370[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (3))){
var inst_11289 = (state_11291[(2)]);
var state_11291__$1 = state_11291;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11291__$1,inst_11289);
} else {
if((state_val_11292 === (12))){
var inst_11266 = (state_11291[(10)]);
var state_11291__$1 = state_11291;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11291__$1,(14),inst_11266);
} else {
if((state_val_11292 === (2))){
var state_11291__$1 = state_11291;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11291__$1,(4),results);
} else {
if((state_val_11292 === (19))){
var state_11291__$1 = state_11291;
var statearr_11304_11371 = state_11291__$1;
(statearr_11304_11371[(2)] = null);

(statearr_11304_11371[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (11))){
var inst_11266 = (state_11291[(2)]);
var state_11291__$1 = (function (){var statearr_11305 = state_11291;
(statearr_11305[(10)] = inst_11266);

return statearr_11305;
})();
var statearr_11306_11372 = state_11291__$1;
(statearr_11306_11372[(2)] = null);

(statearr_11306_11372[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (9))){
var state_11291__$1 = state_11291;
var statearr_11307_11373 = state_11291__$1;
(statearr_11307_11373[(2)] = null);

(statearr_11307_11373[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (5))){
var state_11291__$1 = state_11291;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11308_11374 = state_11291__$1;
(statearr_11308_11374[(1)] = (8));

} else {
var statearr_11309_11375 = state_11291__$1;
(statearr_11309_11375[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (14))){
var inst_11269 = (state_11291[(8)]);
var inst_11271 = (state_11291[(11)]);
var inst_11269__$1 = (state_11291[(2)]);
var inst_11270 = (inst_11269__$1 == null);
var inst_11271__$1 = cljs.core.not.call(null,inst_11270);
var state_11291__$1 = (function (){var statearr_11310 = state_11291;
(statearr_11310[(8)] = inst_11269__$1);

(statearr_11310[(11)] = inst_11271__$1);

return statearr_11310;
})();
if(inst_11271__$1){
var statearr_11311_11376 = state_11291__$1;
(statearr_11311_11376[(1)] = (15));

} else {
var statearr_11312_11377 = state_11291__$1;
(statearr_11312_11377[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (16))){
var inst_11271 = (state_11291[(11)]);
var state_11291__$1 = state_11291;
var statearr_11313_11378 = state_11291__$1;
(statearr_11313_11378[(2)] = inst_11271);

(statearr_11313_11378[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (10))){
var inst_11263 = (state_11291[(2)]);
var state_11291__$1 = state_11291;
var statearr_11314_11379 = state_11291__$1;
(statearr_11314_11379[(2)] = inst_11263);

(statearr_11314_11379[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (18))){
var inst_11274 = (state_11291[(2)]);
var state_11291__$1 = state_11291;
var statearr_11315_11380 = state_11291__$1;
(statearr_11315_11380[(2)] = inst_11274);

(statearr_11315_11380[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11292 === (8))){
var inst_11260 = cljs.core.async.close_BANG_.call(null,to);
var state_11291__$1 = state_11291;
var statearr_11316_11381 = state_11291__$1;
(statearr_11316_11381[(2)] = inst_11260);

(statearr_11316_11381[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0 = (function (){
var statearr_11317 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11317[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__);

(statearr_11317[(1)] = (1));

return statearr_11317;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1 = (function (state_11291){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_11291);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e11318){var ex__10911__auto__ = e11318;
var statearr_11319_11382 = state_11291;
(statearr_11319_11382[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_11291[(4)]))){
var statearr_11320_11383 = state_11291;
(statearr_11320_11383[(1)] = cljs.core.first.call(null,(state_11291[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11384 = state_11291;
state_11291 = G__11384;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__ = function(state_11291){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1.call(this,state_11291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10908__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_11321 = f__10982__auto__.call(null);
(statearr_11321[(6)] = c__10981__auto__);

return statearr_11321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));

return c__10981__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__11386 = arguments.length;
switch (G__11386) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__11389 = arguments.length;
switch (G__11389) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__11392 = arguments.length;
switch (G__11392) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__10981__auto___11442 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_11418){
var state_val_11419 = (state_11418[(1)]);
if((state_val_11419 === (7))){
var inst_11414 = (state_11418[(2)]);
var state_11418__$1 = state_11418;
var statearr_11420_11443 = state_11418__$1;
(statearr_11420_11443[(2)] = inst_11414);

(statearr_11420_11443[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11419 === (1))){
var state_11418__$1 = state_11418;
var statearr_11421_11444 = state_11418__$1;
(statearr_11421_11444[(2)] = null);

(statearr_11421_11444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11419 === (4))){
var inst_11395 = (state_11418[(7)]);
var inst_11395__$1 = (state_11418[(2)]);
var inst_11396 = (inst_11395__$1 == null);
var state_11418__$1 = (function (){var statearr_11422 = state_11418;
(statearr_11422[(7)] = inst_11395__$1);

return statearr_11422;
})();
if(cljs.core.truth_(inst_11396)){
var statearr_11423_11445 = state_11418__$1;
(statearr_11423_11445[(1)] = (5));

} else {
var statearr_11424_11446 = state_11418__$1;
(statearr_11424_11446[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11419 === (13))){
var state_11418__$1 = state_11418;
var statearr_11425_11447 = state_11418__$1;
(statearr_11425_11447[(2)] = null);

(statearr_11425_11447[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11419 === (6))){
var inst_11395 = (state_11418[(7)]);
var inst_11401 = p.call(null,inst_11395);
var state_11418__$1 = state_11418;
if(cljs.core.truth_(inst_11401)){
var statearr_11426_11448 = state_11418__$1;
(statearr_11426_11448[(1)] = (9));

} else {
var statearr_11427_11449 = state_11418__$1;
(statearr_11427_11449[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11419 === (3))){
var inst_11416 = (state_11418[(2)]);
var state_11418__$1 = state_11418;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11418__$1,inst_11416);
} else {
if((state_val_11419 === (12))){
var state_11418__$1 = state_11418;
var statearr_11428_11450 = state_11418__$1;
(statearr_11428_11450[(2)] = null);

(statearr_11428_11450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11419 === (2))){
var state_11418__$1 = state_11418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11418__$1,(4),ch);
} else {
if((state_val_11419 === (11))){
var inst_11395 = (state_11418[(7)]);
var inst_11405 = (state_11418[(2)]);
var state_11418__$1 = state_11418;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11418__$1,(8),inst_11405,inst_11395);
} else {
if((state_val_11419 === (9))){
var state_11418__$1 = state_11418;
var statearr_11429_11451 = state_11418__$1;
(statearr_11429_11451[(2)] = tc);

(statearr_11429_11451[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11419 === (5))){
var inst_11398 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11399 = cljs.core.async.close_BANG_.call(null,fc);
var state_11418__$1 = (function (){var statearr_11430 = state_11418;
(statearr_11430[(8)] = inst_11398);

return statearr_11430;
})();
var statearr_11431_11452 = state_11418__$1;
(statearr_11431_11452[(2)] = inst_11399);

(statearr_11431_11452[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11419 === (14))){
var inst_11412 = (state_11418[(2)]);
var state_11418__$1 = state_11418;
var statearr_11432_11453 = state_11418__$1;
(statearr_11432_11453[(2)] = inst_11412);

(statearr_11432_11453[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11419 === (10))){
var state_11418__$1 = state_11418;
var statearr_11433_11454 = state_11418__$1;
(statearr_11433_11454[(2)] = fc);

(statearr_11433_11454[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11419 === (8))){
var inst_11407 = (state_11418[(2)]);
var state_11418__$1 = state_11418;
if(cljs.core.truth_(inst_11407)){
var statearr_11434_11455 = state_11418__$1;
(statearr_11434_11455[(1)] = (12));

} else {
var statearr_11435_11456 = state_11418__$1;
(statearr_11435_11456[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10908__auto__ = null;
var cljs$core$async$state_machine__10908__auto____0 = (function (){
var statearr_11436 = [null,null,null,null,null,null,null,null,null];
(statearr_11436[(0)] = cljs$core$async$state_machine__10908__auto__);

(statearr_11436[(1)] = (1));

return statearr_11436;
});
var cljs$core$async$state_machine__10908__auto____1 = (function (state_11418){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_11418);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e11437){var ex__10911__auto__ = e11437;
var statearr_11438_11457 = state_11418;
(statearr_11438_11457[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_11418[(4)]))){
var statearr_11439_11458 = state_11418;
(statearr_11439_11458[(1)] = cljs.core.first.call(null,(state_11418[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11459 = state_11418;
state_11418 = G__11459;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$state_machine__10908__auto__ = function(state_11418){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10908__auto____1.call(this,state_11418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10908__auto____0;
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10908__auto____1;
return cljs$core$async$state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_11440 = f__10982__auto__.call(null);
(statearr_11440[(6)] = c__10981__auto___11442);

return statearr_11440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__10981__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_11481){
var state_val_11482 = (state_11481[(1)]);
if((state_val_11482 === (7))){
var inst_11477 = (state_11481[(2)]);
var state_11481__$1 = state_11481;
var statearr_11483_11502 = state_11481__$1;
(statearr_11483_11502[(2)] = inst_11477);

(statearr_11483_11502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (1))){
var inst_11460 = init;
var inst_11461 = inst_11460;
var state_11481__$1 = (function (){var statearr_11484 = state_11481;
(statearr_11484[(7)] = inst_11461);

return statearr_11484;
})();
var statearr_11485_11503 = state_11481__$1;
(statearr_11485_11503[(2)] = null);

(statearr_11485_11503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (4))){
var inst_11464 = (state_11481[(8)]);
var inst_11464__$1 = (state_11481[(2)]);
var inst_11465 = (inst_11464__$1 == null);
var state_11481__$1 = (function (){var statearr_11486 = state_11481;
(statearr_11486[(8)] = inst_11464__$1);

return statearr_11486;
})();
if(cljs.core.truth_(inst_11465)){
var statearr_11487_11504 = state_11481__$1;
(statearr_11487_11504[(1)] = (5));

} else {
var statearr_11488_11505 = state_11481__$1;
(statearr_11488_11505[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (6))){
var inst_11464 = (state_11481[(8)]);
var inst_11468 = (state_11481[(9)]);
var inst_11461 = (state_11481[(7)]);
var inst_11468__$1 = f.call(null,inst_11461,inst_11464);
var inst_11469 = cljs.core.reduced_QMARK_.call(null,inst_11468__$1);
var state_11481__$1 = (function (){var statearr_11489 = state_11481;
(statearr_11489[(9)] = inst_11468__$1);

return statearr_11489;
})();
if(inst_11469){
var statearr_11490_11506 = state_11481__$1;
(statearr_11490_11506[(1)] = (8));

} else {
var statearr_11491_11507 = state_11481__$1;
(statearr_11491_11507[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (3))){
var inst_11479 = (state_11481[(2)]);
var state_11481__$1 = state_11481;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11481__$1,inst_11479);
} else {
if((state_val_11482 === (2))){
var state_11481__$1 = state_11481;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11481__$1,(4),ch);
} else {
if((state_val_11482 === (9))){
var inst_11468 = (state_11481[(9)]);
var inst_11461 = inst_11468;
var state_11481__$1 = (function (){var statearr_11492 = state_11481;
(statearr_11492[(7)] = inst_11461);

return statearr_11492;
})();
var statearr_11493_11508 = state_11481__$1;
(statearr_11493_11508[(2)] = null);

(statearr_11493_11508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (5))){
var inst_11461 = (state_11481[(7)]);
var state_11481__$1 = state_11481;
var statearr_11494_11509 = state_11481__$1;
(statearr_11494_11509[(2)] = inst_11461);

(statearr_11494_11509[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (10))){
var inst_11475 = (state_11481[(2)]);
var state_11481__$1 = state_11481;
var statearr_11495_11510 = state_11481__$1;
(statearr_11495_11510[(2)] = inst_11475);

(statearr_11495_11510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (8))){
var inst_11468 = (state_11481[(9)]);
var inst_11471 = cljs.core.deref.call(null,inst_11468);
var state_11481__$1 = state_11481;
var statearr_11496_11511 = state_11481__$1;
(statearr_11496_11511[(2)] = inst_11471);

(statearr_11496_11511[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__10908__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10908__auto____0 = (function (){
var statearr_11497 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11497[(0)] = cljs$core$async$reduce_$_state_machine__10908__auto__);

(statearr_11497[(1)] = (1));

return statearr_11497;
});
var cljs$core$async$reduce_$_state_machine__10908__auto____1 = (function (state_11481){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_11481);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e11498){var ex__10911__auto__ = e11498;
var statearr_11499_11512 = state_11481;
(statearr_11499_11512[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_11481[(4)]))){
var statearr_11500_11513 = state_11481;
(statearr_11500_11513[(1)] = cljs.core.first.call(null,(state_11481[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11514 = state_11481;
state_11481 = G__11514;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10908__auto__ = function(state_11481){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10908__auto____1.call(this,state_11481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10908__auto____0;
cljs$core$async$reduce_$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10908__auto____1;
return cljs$core$async$reduce_$_state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_11501 = f__10982__auto__.call(null);
(statearr_11501[(6)] = c__10981__auto__);

return statearr_11501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));

return c__10981__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__10981__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_11520){
var state_val_11521 = (state_11520[(1)]);
if((state_val_11521 === (1))){
var inst_11515 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_11520__$1 = state_11520;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11520__$1,(2),inst_11515);
} else {
if((state_val_11521 === (2))){
var inst_11517 = (state_11520[(2)]);
var inst_11518 = f__$1.call(null,inst_11517);
var state_11520__$1 = state_11520;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11520__$1,inst_11518);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__10908__auto__ = null;
var cljs$core$async$transduce_$_state_machine__10908__auto____0 = (function (){
var statearr_11522 = [null,null,null,null,null,null,null];
(statearr_11522[(0)] = cljs$core$async$transduce_$_state_machine__10908__auto__);

(statearr_11522[(1)] = (1));

return statearr_11522;
});
var cljs$core$async$transduce_$_state_machine__10908__auto____1 = (function (state_11520){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_11520);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e11523){var ex__10911__auto__ = e11523;
var statearr_11524_11527 = state_11520;
(statearr_11524_11527[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_11520[(4)]))){
var statearr_11525_11528 = state_11520;
(statearr_11525_11528[(1)] = cljs.core.first.call(null,(state_11520[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11529 = state_11520;
state_11520 = G__11529;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__10908__auto__ = function(state_11520){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__10908__auto____1.call(this,state_11520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__10908__auto____0;
cljs$core$async$transduce_$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__10908__auto____1;
return cljs$core$async$transduce_$_state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_11526 = f__10982__auto__.call(null);
(statearr_11526[(6)] = c__10981__auto__);

return statearr_11526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));

return c__10981__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__11531 = arguments.length;
switch (G__11531) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__10981__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_11556){
var state_val_11557 = (state_11556[(1)]);
if((state_val_11557 === (7))){
var inst_11538 = (state_11556[(2)]);
var state_11556__$1 = state_11556;
var statearr_11558_11580 = state_11556__$1;
(statearr_11558_11580[(2)] = inst_11538);

(statearr_11558_11580[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11557 === (1))){
var inst_11532 = cljs.core.seq.call(null,coll);
var inst_11533 = inst_11532;
var state_11556__$1 = (function (){var statearr_11559 = state_11556;
(statearr_11559[(7)] = inst_11533);

return statearr_11559;
})();
var statearr_11560_11581 = state_11556__$1;
(statearr_11560_11581[(2)] = null);

(statearr_11560_11581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11557 === (4))){
var inst_11533 = (state_11556[(7)]);
var inst_11536 = cljs.core.first.call(null,inst_11533);
var state_11556__$1 = state_11556;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11556__$1,(7),ch,inst_11536);
} else {
if((state_val_11557 === (13))){
var inst_11550 = (state_11556[(2)]);
var state_11556__$1 = state_11556;
var statearr_11561_11582 = state_11556__$1;
(statearr_11561_11582[(2)] = inst_11550);

(statearr_11561_11582[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11557 === (6))){
var inst_11541 = (state_11556[(2)]);
var state_11556__$1 = state_11556;
if(cljs.core.truth_(inst_11541)){
var statearr_11562_11583 = state_11556__$1;
(statearr_11562_11583[(1)] = (8));

} else {
var statearr_11563_11584 = state_11556__$1;
(statearr_11563_11584[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11557 === (3))){
var inst_11554 = (state_11556[(2)]);
var state_11556__$1 = state_11556;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11556__$1,inst_11554);
} else {
if((state_val_11557 === (12))){
var state_11556__$1 = state_11556;
var statearr_11564_11585 = state_11556__$1;
(statearr_11564_11585[(2)] = null);

(statearr_11564_11585[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11557 === (2))){
var inst_11533 = (state_11556[(7)]);
var state_11556__$1 = state_11556;
if(cljs.core.truth_(inst_11533)){
var statearr_11565_11586 = state_11556__$1;
(statearr_11565_11586[(1)] = (4));

} else {
var statearr_11566_11587 = state_11556__$1;
(statearr_11566_11587[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11557 === (11))){
var inst_11547 = cljs.core.async.close_BANG_.call(null,ch);
var state_11556__$1 = state_11556;
var statearr_11567_11588 = state_11556__$1;
(statearr_11567_11588[(2)] = inst_11547);

(statearr_11567_11588[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11557 === (9))){
var state_11556__$1 = state_11556;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11568_11589 = state_11556__$1;
(statearr_11568_11589[(1)] = (11));

} else {
var statearr_11569_11590 = state_11556__$1;
(statearr_11569_11590[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11557 === (5))){
var inst_11533 = (state_11556[(7)]);
var state_11556__$1 = state_11556;
var statearr_11570_11591 = state_11556__$1;
(statearr_11570_11591[(2)] = inst_11533);

(statearr_11570_11591[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11557 === (10))){
var inst_11552 = (state_11556[(2)]);
var state_11556__$1 = state_11556;
var statearr_11571_11592 = state_11556__$1;
(statearr_11571_11592[(2)] = inst_11552);

(statearr_11571_11592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11557 === (8))){
var inst_11533 = (state_11556[(7)]);
var inst_11543 = cljs.core.next.call(null,inst_11533);
var inst_11533__$1 = inst_11543;
var state_11556__$1 = (function (){var statearr_11572 = state_11556;
(statearr_11572[(7)] = inst_11533__$1);

return statearr_11572;
})();
var statearr_11573_11593 = state_11556__$1;
(statearr_11573_11593[(2)] = null);

(statearr_11573_11593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10908__auto__ = null;
var cljs$core$async$state_machine__10908__auto____0 = (function (){
var statearr_11574 = [null,null,null,null,null,null,null,null];
(statearr_11574[(0)] = cljs$core$async$state_machine__10908__auto__);

(statearr_11574[(1)] = (1));

return statearr_11574;
});
var cljs$core$async$state_machine__10908__auto____1 = (function (state_11556){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_11556);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e11575){var ex__10911__auto__ = e11575;
var statearr_11576_11594 = state_11556;
(statearr_11576_11594[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_11556[(4)]))){
var statearr_11577_11595 = state_11556;
(statearr_11577_11595[(1)] = cljs.core.first.call(null,(state_11556[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11596 = state_11556;
state_11556 = G__11596;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$state_machine__10908__auto__ = function(state_11556){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10908__auto____1.call(this,state_11556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10908__auto____0;
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10908__auto____1;
return cljs$core$async$state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_11578 = f__10982__auto__.call(null);
(statearr_11578[(6)] = c__10981__auto__);

return statearr_11578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));

return c__10981__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan_BANG_.call(null,ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__11598 = arguments.length;
switch (G__11598) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_.call(null,coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_11600 = (function (_){
var x__4550__auto__ = (((_ == null))?null:_);
var m__4551__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,_);
} else {
var m__4549__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_11600.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_11601 = (function (m,ch,close_QMARK_){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4549__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_11601.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_11602 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m,ch);
} else {
var m__4549__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_11602.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_11603 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m);
} else {
var m__4549__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_11603.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11604 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11604 = (function (ch,cs,meta11605){
this.ch = ch;
this.cs = cs;
this.meta11605 = meta11605;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11604.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11606,meta11605__$1){
var self__ = this;
var _11606__$1 = this;
return (new cljs.core.async.t_cljs$core$async11604(self__.ch,self__.cs,meta11605__$1));
}));

(cljs.core.async.t_cljs$core$async11604.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11606){
var self__ = this;
var _11606__$1 = this;
return self__.meta11605;
}));

(cljs.core.async.t_cljs$core$async11604.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11604.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async11604.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11604.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async11604.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async11604.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async11604.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta11605","meta11605",1766813327,null)], null);
}));

(cljs.core.async.t_cljs$core$async11604.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11604.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11604");

(cljs.core.async.t_cljs$core$async11604.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async11604");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11604.
 */
cljs.core.async.__GT_t_cljs$core$async11604 = (function cljs$core$async$mult_$___GT_t_cljs$core$async11604(ch__$1,cs__$1,meta11605){
return (new cljs.core.async.t_cljs$core$async11604(ch__$1,cs__$1,meta11605));
});

}

return (new cljs.core.async.t_cljs$core$async11604(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__10981__auto___11823 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_11739){
var state_val_11740 = (state_11739[(1)]);
if((state_val_11740 === (7))){
var inst_11735 = (state_11739[(2)]);
var state_11739__$1 = state_11739;
var statearr_11741_11824 = state_11739__$1;
(statearr_11741_11824[(2)] = inst_11735);

(statearr_11741_11824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (20))){
var inst_11640 = (state_11739[(7)]);
var inst_11652 = cljs.core.first.call(null,inst_11640);
var inst_11653 = cljs.core.nth.call(null,inst_11652,(0),null);
var inst_11654 = cljs.core.nth.call(null,inst_11652,(1),null);
var state_11739__$1 = (function (){var statearr_11742 = state_11739;
(statearr_11742[(8)] = inst_11653);

return statearr_11742;
})();
if(cljs.core.truth_(inst_11654)){
var statearr_11743_11825 = state_11739__$1;
(statearr_11743_11825[(1)] = (22));

} else {
var statearr_11744_11826 = state_11739__$1;
(statearr_11744_11826[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (27))){
var inst_11689 = (state_11739[(9)]);
var inst_11609 = (state_11739[(10)]);
var inst_11684 = (state_11739[(11)]);
var inst_11682 = (state_11739[(12)]);
var inst_11689__$1 = cljs.core._nth.call(null,inst_11682,inst_11684);
var inst_11690 = cljs.core.async.put_BANG_.call(null,inst_11689__$1,inst_11609,done);
var state_11739__$1 = (function (){var statearr_11745 = state_11739;
(statearr_11745[(9)] = inst_11689__$1);

return statearr_11745;
})();
if(cljs.core.truth_(inst_11690)){
var statearr_11746_11827 = state_11739__$1;
(statearr_11746_11827[(1)] = (30));

} else {
var statearr_11747_11828 = state_11739__$1;
(statearr_11747_11828[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (1))){
var state_11739__$1 = state_11739;
var statearr_11748_11829 = state_11739__$1;
(statearr_11748_11829[(2)] = null);

(statearr_11748_11829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (24))){
var inst_11640 = (state_11739[(7)]);
var inst_11659 = (state_11739[(2)]);
var inst_11660 = cljs.core.next.call(null,inst_11640);
var inst_11618 = inst_11660;
var inst_11619 = null;
var inst_11620 = (0);
var inst_11621 = (0);
var state_11739__$1 = (function (){var statearr_11749 = state_11739;
(statearr_11749[(13)] = inst_11619);

(statearr_11749[(14)] = inst_11620);

(statearr_11749[(15)] = inst_11618);

(statearr_11749[(16)] = inst_11659);

(statearr_11749[(17)] = inst_11621);

return statearr_11749;
})();
var statearr_11750_11830 = state_11739__$1;
(statearr_11750_11830[(2)] = null);

(statearr_11750_11830[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (39))){
var state_11739__$1 = state_11739;
var statearr_11754_11831 = state_11739__$1;
(statearr_11754_11831[(2)] = null);

(statearr_11754_11831[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (4))){
var inst_11609 = (state_11739[(10)]);
var inst_11609__$1 = (state_11739[(2)]);
var inst_11610 = (inst_11609__$1 == null);
var state_11739__$1 = (function (){var statearr_11755 = state_11739;
(statearr_11755[(10)] = inst_11609__$1);

return statearr_11755;
})();
if(cljs.core.truth_(inst_11610)){
var statearr_11756_11832 = state_11739__$1;
(statearr_11756_11832[(1)] = (5));

} else {
var statearr_11757_11833 = state_11739__$1;
(statearr_11757_11833[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (15))){
var inst_11619 = (state_11739[(13)]);
var inst_11620 = (state_11739[(14)]);
var inst_11618 = (state_11739[(15)]);
var inst_11621 = (state_11739[(17)]);
var inst_11636 = (state_11739[(2)]);
var inst_11637 = (inst_11621 + (1));
var tmp11751 = inst_11619;
var tmp11752 = inst_11620;
var tmp11753 = inst_11618;
var inst_11618__$1 = tmp11753;
var inst_11619__$1 = tmp11751;
var inst_11620__$1 = tmp11752;
var inst_11621__$1 = inst_11637;
var state_11739__$1 = (function (){var statearr_11758 = state_11739;
(statearr_11758[(13)] = inst_11619__$1);

(statearr_11758[(14)] = inst_11620__$1);

(statearr_11758[(15)] = inst_11618__$1);

(statearr_11758[(17)] = inst_11621__$1);

(statearr_11758[(18)] = inst_11636);

return statearr_11758;
})();
var statearr_11759_11834 = state_11739__$1;
(statearr_11759_11834[(2)] = null);

(statearr_11759_11834[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (21))){
var inst_11663 = (state_11739[(2)]);
var state_11739__$1 = state_11739;
var statearr_11763_11835 = state_11739__$1;
(statearr_11763_11835[(2)] = inst_11663);

(statearr_11763_11835[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (31))){
var inst_11689 = (state_11739[(9)]);
var inst_11693 = cljs.core.async.untap_STAR_.call(null,m,inst_11689);
var state_11739__$1 = state_11739;
var statearr_11764_11836 = state_11739__$1;
(statearr_11764_11836[(2)] = inst_11693);

(statearr_11764_11836[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (32))){
var inst_11681 = (state_11739[(19)]);
var inst_11683 = (state_11739[(20)]);
var inst_11684 = (state_11739[(11)]);
var inst_11682 = (state_11739[(12)]);
var inst_11695 = (state_11739[(2)]);
var inst_11696 = (inst_11684 + (1));
var tmp11760 = inst_11681;
var tmp11761 = inst_11683;
var tmp11762 = inst_11682;
var inst_11681__$1 = tmp11760;
var inst_11682__$1 = tmp11762;
var inst_11683__$1 = tmp11761;
var inst_11684__$1 = inst_11696;
var state_11739__$1 = (function (){var statearr_11765 = state_11739;
(statearr_11765[(19)] = inst_11681__$1);

(statearr_11765[(20)] = inst_11683__$1);

(statearr_11765[(11)] = inst_11684__$1);

(statearr_11765[(21)] = inst_11695);

(statearr_11765[(12)] = inst_11682__$1);

return statearr_11765;
})();
var statearr_11766_11837 = state_11739__$1;
(statearr_11766_11837[(2)] = null);

(statearr_11766_11837[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (40))){
var inst_11708 = (state_11739[(22)]);
var inst_11712 = cljs.core.async.untap_STAR_.call(null,m,inst_11708);
var state_11739__$1 = state_11739;
var statearr_11767_11838 = state_11739__$1;
(statearr_11767_11838[(2)] = inst_11712);

(statearr_11767_11838[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (33))){
var inst_11699 = (state_11739[(23)]);
var inst_11701 = cljs.core.chunked_seq_QMARK_.call(null,inst_11699);
var state_11739__$1 = state_11739;
if(inst_11701){
var statearr_11768_11839 = state_11739__$1;
(statearr_11768_11839[(1)] = (36));

} else {
var statearr_11769_11840 = state_11739__$1;
(statearr_11769_11840[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (13))){
var inst_11630 = (state_11739[(24)]);
var inst_11633 = cljs.core.async.close_BANG_.call(null,inst_11630);
var state_11739__$1 = state_11739;
var statearr_11770_11841 = state_11739__$1;
(statearr_11770_11841[(2)] = inst_11633);

(statearr_11770_11841[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (22))){
var inst_11653 = (state_11739[(8)]);
var inst_11656 = cljs.core.async.close_BANG_.call(null,inst_11653);
var state_11739__$1 = state_11739;
var statearr_11771_11842 = state_11739__$1;
(statearr_11771_11842[(2)] = inst_11656);

(statearr_11771_11842[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (36))){
var inst_11699 = (state_11739[(23)]);
var inst_11703 = cljs.core.chunk_first.call(null,inst_11699);
var inst_11704 = cljs.core.chunk_rest.call(null,inst_11699);
var inst_11705 = cljs.core.count.call(null,inst_11703);
var inst_11681 = inst_11704;
var inst_11682 = inst_11703;
var inst_11683 = inst_11705;
var inst_11684 = (0);
var state_11739__$1 = (function (){var statearr_11772 = state_11739;
(statearr_11772[(19)] = inst_11681);

(statearr_11772[(20)] = inst_11683);

(statearr_11772[(11)] = inst_11684);

(statearr_11772[(12)] = inst_11682);

return statearr_11772;
})();
var statearr_11773_11843 = state_11739__$1;
(statearr_11773_11843[(2)] = null);

(statearr_11773_11843[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (41))){
var inst_11699 = (state_11739[(23)]);
var inst_11714 = (state_11739[(2)]);
var inst_11715 = cljs.core.next.call(null,inst_11699);
var inst_11681 = inst_11715;
var inst_11682 = null;
var inst_11683 = (0);
var inst_11684 = (0);
var state_11739__$1 = (function (){var statearr_11774 = state_11739;
(statearr_11774[(25)] = inst_11714);

(statearr_11774[(19)] = inst_11681);

(statearr_11774[(20)] = inst_11683);

(statearr_11774[(11)] = inst_11684);

(statearr_11774[(12)] = inst_11682);

return statearr_11774;
})();
var statearr_11775_11844 = state_11739__$1;
(statearr_11775_11844[(2)] = null);

(statearr_11775_11844[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (43))){
var state_11739__$1 = state_11739;
var statearr_11776_11845 = state_11739__$1;
(statearr_11776_11845[(2)] = null);

(statearr_11776_11845[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (29))){
var inst_11723 = (state_11739[(2)]);
var state_11739__$1 = state_11739;
var statearr_11777_11846 = state_11739__$1;
(statearr_11777_11846[(2)] = inst_11723);

(statearr_11777_11846[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (44))){
var inst_11732 = (state_11739[(2)]);
var state_11739__$1 = (function (){var statearr_11778 = state_11739;
(statearr_11778[(26)] = inst_11732);

return statearr_11778;
})();
var statearr_11779_11847 = state_11739__$1;
(statearr_11779_11847[(2)] = null);

(statearr_11779_11847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (6))){
var inst_11673 = (state_11739[(27)]);
var inst_11672 = cljs.core.deref.call(null,cs);
var inst_11673__$1 = cljs.core.keys.call(null,inst_11672);
var inst_11674 = cljs.core.count.call(null,inst_11673__$1);
var inst_11675 = cljs.core.reset_BANG_.call(null,dctr,inst_11674);
var inst_11680 = cljs.core.seq.call(null,inst_11673__$1);
var inst_11681 = inst_11680;
var inst_11682 = null;
var inst_11683 = (0);
var inst_11684 = (0);
var state_11739__$1 = (function (){var statearr_11780 = state_11739;
(statearr_11780[(19)] = inst_11681);

(statearr_11780[(27)] = inst_11673__$1);

(statearr_11780[(20)] = inst_11683);

(statearr_11780[(28)] = inst_11675);

(statearr_11780[(11)] = inst_11684);

(statearr_11780[(12)] = inst_11682);

return statearr_11780;
})();
var statearr_11781_11848 = state_11739__$1;
(statearr_11781_11848[(2)] = null);

(statearr_11781_11848[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (28))){
var inst_11681 = (state_11739[(19)]);
var inst_11699 = (state_11739[(23)]);
var inst_11699__$1 = cljs.core.seq.call(null,inst_11681);
var state_11739__$1 = (function (){var statearr_11782 = state_11739;
(statearr_11782[(23)] = inst_11699__$1);

return statearr_11782;
})();
if(inst_11699__$1){
var statearr_11783_11849 = state_11739__$1;
(statearr_11783_11849[(1)] = (33));

} else {
var statearr_11784_11850 = state_11739__$1;
(statearr_11784_11850[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (25))){
var inst_11683 = (state_11739[(20)]);
var inst_11684 = (state_11739[(11)]);
var inst_11686 = (inst_11684 < inst_11683);
var inst_11687 = inst_11686;
var state_11739__$1 = state_11739;
if(cljs.core.truth_(inst_11687)){
var statearr_11785_11851 = state_11739__$1;
(statearr_11785_11851[(1)] = (27));

} else {
var statearr_11786_11852 = state_11739__$1;
(statearr_11786_11852[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (34))){
var state_11739__$1 = state_11739;
var statearr_11787_11853 = state_11739__$1;
(statearr_11787_11853[(2)] = null);

(statearr_11787_11853[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (17))){
var state_11739__$1 = state_11739;
var statearr_11788_11854 = state_11739__$1;
(statearr_11788_11854[(2)] = null);

(statearr_11788_11854[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (3))){
var inst_11737 = (state_11739[(2)]);
var state_11739__$1 = state_11739;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11739__$1,inst_11737);
} else {
if((state_val_11740 === (12))){
var inst_11668 = (state_11739[(2)]);
var state_11739__$1 = state_11739;
var statearr_11789_11855 = state_11739__$1;
(statearr_11789_11855[(2)] = inst_11668);

(statearr_11789_11855[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (2))){
var state_11739__$1 = state_11739;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11739__$1,(4),ch);
} else {
if((state_val_11740 === (23))){
var state_11739__$1 = state_11739;
var statearr_11790_11856 = state_11739__$1;
(statearr_11790_11856[(2)] = null);

(statearr_11790_11856[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (35))){
var inst_11721 = (state_11739[(2)]);
var state_11739__$1 = state_11739;
var statearr_11791_11857 = state_11739__$1;
(statearr_11791_11857[(2)] = inst_11721);

(statearr_11791_11857[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (19))){
var inst_11640 = (state_11739[(7)]);
var inst_11644 = cljs.core.chunk_first.call(null,inst_11640);
var inst_11645 = cljs.core.chunk_rest.call(null,inst_11640);
var inst_11646 = cljs.core.count.call(null,inst_11644);
var inst_11618 = inst_11645;
var inst_11619 = inst_11644;
var inst_11620 = inst_11646;
var inst_11621 = (0);
var state_11739__$1 = (function (){var statearr_11792 = state_11739;
(statearr_11792[(13)] = inst_11619);

(statearr_11792[(14)] = inst_11620);

(statearr_11792[(15)] = inst_11618);

(statearr_11792[(17)] = inst_11621);

return statearr_11792;
})();
var statearr_11793_11858 = state_11739__$1;
(statearr_11793_11858[(2)] = null);

(statearr_11793_11858[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (11))){
var inst_11618 = (state_11739[(15)]);
var inst_11640 = (state_11739[(7)]);
var inst_11640__$1 = cljs.core.seq.call(null,inst_11618);
var state_11739__$1 = (function (){var statearr_11794 = state_11739;
(statearr_11794[(7)] = inst_11640__$1);

return statearr_11794;
})();
if(inst_11640__$1){
var statearr_11795_11859 = state_11739__$1;
(statearr_11795_11859[(1)] = (16));

} else {
var statearr_11796_11860 = state_11739__$1;
(statearr_11796_11860[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (9))){
var inst_11670 = (state_11739[(2)]);
var state_11739__$1 = state_11739;
var statearr_11797_11861 = state_11739__$1;
(statearr_11797_11861[(2)] = inst_11670);

(statearr_11797_11861[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (5))){
var inst_11616 = cljs.core.deref.call(null,cs);
var inst_11617 = cljs.core.seq.call(null,inst_11616);
var inst_11618 = inst_11617;
var inst_11619 = null;
var inst_11620 = (0);
var inst_11621 = (0);
var state_11739__$1 = (function (){var statearr_11798 = state_11739;
(statearr_11798[(13)] = inst_11619);

(statearr_11798[(14)] = inst_11620);

(statearr_11798[(15)] = inst_11618);

(statearr_11798[(17)] = inst_11621);

return statearr_11798;
})();
var statearr_11799_11862 = state_11739__$1;
(statearr_11799_11862[(2)] = null);

(statearr_11799_11862[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (14))){
var state_11739__$1 = state_11739;
var statearr_11800_11863 = state_11739__$1;
(statearr_11800_11863[(2)] = null);

(statearr_11800_11863[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (45))){
var inst_11729 = (state_11739[(2)]);
var state_11739__$1 = state_11739;
var statearr_11801_11864 = state_11739__$1;
(statearr_11801_11864[(2)] = inst_11729);

(statearr_11801_11864[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (26))){
var inst_11673 = (state_11739[(27)]);
var inst_11725 = (state_11739[(2)]);
var inst_11726 = cljs.core.seq.call(null,inst_11673);
var state_11739__$1 = (function (){var statearr_11802 = state_11739;
(statearr_11802[(29)] = inst_11725);

return statearr_11802;
})();
if(inst_11726){
var statearr_11803_11865 = state_11739__$1;
(statearr_11803_11865[(1)] = (42));

} else {
var statearr_11804_11866 = state_11739__$1;
(statearr_11804_11866[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (16))){
var inst_11640 = (state_11739[(7)]);
var inst_11642 = cljs.core.chunked_seq_QMARK_.call(null,inst_11640);
var state_11739__$1 = state_11739;
if(inst_11642){
var statearr_11805_11867 = state_11739__$1;
(statearr_11805_11867[(1)] = (19));

} else {
var statearr_11806_11868 = state_11739__$1;
(statearr_11806_11868[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (38))){
var inst_11718 = (state_11739[(2)]);
var state_11739__$1 = state_11739;
var statearr_11807_11869 = state_11739__$1;
(statearr_11807_11869[(2)] = inst_11718);

(statearr_11807_11869[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (30))){
var state_11739__$1 = state_11739;
var statearr_11808_11870 = state_11739__$1;
(statearr_11808_11870[(2)] = null);

(statearr_11808_11870[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (10))){
var inst_11619 = (state_11739[(13)]);
var inst_11621 = (state_11739[(17)]);
var inst_11629 = cljs.core._nth.call(null,inst_11619,inst_11621);
var inst_11630 = cljs.core.nth.call(null,inst_11629,(0),null);
var inst_11631 = cljs.core.nth.call(null,inst_11629,(1),null);
var state_11739__$1 = (function (){var statearr_11809 = state_11739;
(statearr_11809[(24)] = inst_11630);

return statearr_11809;
})();
if(cljs.core.truth_(inst_11631)){
var statearr_11810_11871 = state_11739__$1;
(statearr_11810_11871[(1)] = (13));

} else {
var statearr_11811_11872 = state_11739__$1;
(statearr_11811_11872[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (18))){
var inst_11666 = (state_11739[(2)]);
var state_11739__$1 = state_11739;
var statearr_11812_11873 = state_11739__$1;
(statearr_11812_11873[(2)] = inst_11666);

(statearr_11812_11873[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (42))){
var state_11739__$1 = state_11739;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11739__$1,(45),dchan);
} else {
if((state_val_11740 === (37))){
var inst_11609 = (state_11739[(10)]);
var inst_11699 = (state_11739[(23)]);
var inst_11708 = (state_11739[(22)]);
var inst_11708__$1 = cljs.core.first.call(null,inst_11699);
var inst_11709 = cljs.core.async.put_BANG_.call(null,inst_11708__$1,inst_11609,done);
var state_11739__$1 = (function (){var statearr_11813 = state_11739;
(statearr_11813[(22)] = inst_11708__$1);

return statearr_11813;
})();
if(cljs.core.truth_(inst_11709)){
var statearr_11814_11874 = state_11739__$1;
(statearr_11814_11874[(1)] = (39));

} else {
var statearr_11815_11875 = state_11739__$1;
(statearr_11815_11875[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11740 === (8))){
var inst_11620 = (state_11739[(14)]);
var inst_11621 = (state_11739[(17)]);
var inst_11623 = (inst_11621 < inst_11620);
var inst_11624 = inst_11623;
var state_11739__$1 = state_11739;
if(cljs.core.truth_(inst_11624)){
var statearr_11816_11876 = state_11739__$1;
(statearr_11816_11876[(1)] = (10));

} else {
var statearr_11817_11877 = state_11739__$1;
(statearr_11817_11877[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__10908__auto__ = null;
var cljs$core$async$mult_$_state_machine__10908__auto____0 = (function (){
var statearr_11818 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11818[(0)] = cljs$core$async$mult_$_state_machine__10908__auto__);

(statearr_11818[(1)] = (1));

return statearr_11818;
});
var cljs$core$async$mult_$_state_machine__10908__auto____1 = (function (state_11739){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_11739);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e11819){var ex__10911__auto__ = e11819;
var statearr_11820_11878 = state_11739;
(statearr_11820_11878[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_11739[(4)]))){
var statearr_11821_11879 = state_11739;
(statearr_11821_11879[(1)] = cljs.core.first.call(null,(state_11739[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11880 = state_11739;
state_11739 = G__11880;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10908__auto__ = function(state_11739){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10908__auto____1.call(this,state_11739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10908__auto____0;
cljs$core$async$mult_$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10908__auto____1;
return cljs$core$async$mult_$_state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_11822 = f__10982__auto__.call(null);
(statearr_11822[(6)] = c__10981__auto___11823);

return statearr_11822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__11882 = arguments.length;
switch (G__11882) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_11884 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m,ch);
} else {
var m__4549__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_11884.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_11885 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m,ch);
} else {
var m__4549__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_11885.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_11886 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m);
} else {
var m__4549__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_11886.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_11887 = (function (m,state_map){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m,state_map);
} else {
var m__4549__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_11887.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_11888 = (function (m,mode){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m,mode);
} else {
var m__4549__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_11888.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___11898 = arguments.length;
var i__4865__auto___11899 = (0);
while(true){
if((i__4865__auto___11899 < len__4864__auto___11898)){
args__4870__auto__.push((arguments[i__4865__auto___11899]));

var G__11900 = (i__4865__auto___11899 + (1));
i__4865__auto___11899 = G__11900;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__11893){
var map__11894 = p__11893;
var map__11894__$1 = cljs.core.__destructure_map.call(null,map__11894);
var opts = map__11894__$1;
var statearr_11895_11901 = state;
(statearr_11895_11901[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_11896_11902 = state;
(statearr_11896_11902[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_11897_11903 = state;
(statearr_11897_11903[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq11889){
var G__11890 = cljs.core.first.call(null,seq11889);
var seq11889__$1 = cljs.core.next.call(null,seq11889);
var G__11891 = cljs.core.first.call(null,seq11889__$1);
var seq11889__$2 = cljs.core.next.call(null,seq11889__$1);
var G__11892 = cljs.core.first.call(null,seq11889__$2);
var seq11889__$3 = cljs.core.next.call(null,seq11889__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11890,G__11891,G__11892,seq11889__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(1)));
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11904 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11904 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta11905){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta11905 = meta11905;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11906,meta11905__$1){
var self__ = this;
var _11906__$1 = this;
return (new cljs.core.async.t_cljs$core$async11904(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta11905__$1));
}));

(cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11906){
var self__ = this;
var _11906__$1 = this;
return self__.meta11905;
}));

(cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11904.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11904.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta11905","meta11905",1107737781,null)], null);
}));

(cljs.core.async.t_cljs$core$async11904.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11904.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11904");

(cljs.core.async.t_cljs$core$async11904.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async11904");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11904.
 */
cljs.core.async.__GT_t_cljs$core$async11904 = (function cljs$core$async$mix_$___GT_t_cljs$core$async11904(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta11905){
return (new cljs.core.async.t_cljs$core$async11904(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta11905));
});

}

return (new cljs.core.async.t_cljs$core$async11904(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10981__auto___12019 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_11974){
var state_val_11975 = (state_11974[(1)]);
if((state_val_11975 === (7))){
var inst_11934 = (state_11974[(2)]);
var state_11974__$1 = state_11974;
if(cljs.core.truth_(inst_11934)){
var statearr_11976_12020 = state_11974__$1;
(statearr_11976_12020[(1)] = (8));

} else {
var statearr_11977_12021 = state_11974__$1;
(statearr_11977_12021[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (20))){
var inst_11927 = (state_11974[(7)]);
var state_11974__$1 = state_11974;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11974__$1,(23),out,inst_11927);
} else {
if((state_val_11975 === (1))){
var inst_11910 = calc_state.call(null);
var inst_11911 = cljs.core.__destructure_map.call(null,inst_11910);
var inst_11912 = cljs.core.get.call(null,inst_11911,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_11913 = cljs.core.get.call(null,inst_11911,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_11914 = cljs.core.get.call(null,inst_11911,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_11915 = inst_11910;
var state_11974__$1 = (function (){var statearr_11978 = state_11974;
(statearr_11978[(8)] = inst_11912);

(statearr_11978[(9)] = inst_11915);

(statearr_11978[(10)] = inst_11914);

(statearr_11978[(11)] = inst_11913);

return statearr_11978;
})();
var statearr_11979_12022 = state_11974__$1;
(statearr_11979_12022[(2)] = null);

(statearr_11979_12022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (24))){
var inst_11918 = (state_11974[(12)]);
var inst_11915 = inst_11918;
var state_11974__$1 = (function (){var statearr_11980 = state_11974;
(statearr_11980[(9)] = inst_11915);

return statearr_11980;
})();
var statearr_11981_12023 = state_11974__$1;
(statearr_11981_12023[(2)] = null);

(statearr_11981_12023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (4))){
var inst_11929 = (state_11974[(13)]);
var inst_11927 = (state_11974[(7)]);
var inst_11926 = (state_11974[(2)]);
var inst_11927__$1 = cljs.core.nth.call(null,inst_11926,(0),null);
var inst_11928 = cljs.core.nth.call(null,inst_11926,(1),null);
var inst_11929__$1 = (inst_11927__$1 == null);
var state_11974__$1 = (function (){var statearr_11982 = state_11974;
(statearr_11982[(13)] = inst_11929__$1);

(statearr_11982[(14)] = inst_11928);

(statearr_11982[(7)] = inst_11927__$1);

return statearr_11982;
})();
if(cljs.core.truth_(inst_11929__$1)){
var statearr_11983_12024 = state_11974__$1;
(statearr_11983_12024[(1)] = (5));

} else {
var statearr_11984_12025 = state_11974__$1;
(statearr_11984_12025[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (15))){
var inst_11919 = (state_11974[(15)]);
var inst_11948 = (state_11974[(16)]);
var inst_11948__$1 = cljs.core.empty_QMARK_.call(null,inst_11919);
var state_11974__$1 = (function (){var statearr_11985 = state_11974;
(statearr_11985[(16)] = inst_11948__$1);

return statearr_11985;
})();
if(inst_11948__$1){
var statearr_11986_12026 = state_11974__$1;
(statearr_11986_12026[(1)] = (17));

} else {
var statearr_11987_12027 = state_11974__$1;
(statearr_11987_12027[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (21))){
var inst_11918 = (state_11974[(12)]);
var inst_11915 = inst_11918;
var state_11974__$1 = (function (){var statearr_11988 = state_11974;
(statearr_11988[(9)] = inst_11915);

return statearr_11988;
})();
var statearr_11989_12028 = state_11974__$1;
(statearr_11989_12028[(2)] = null);

(statearr_11989_12028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (13))){
var inst_11941 = (state_11974[(2)]);
var inst_11942 = calc_state.call(null);
var inst_11915 = inst_11942;
var state_11974__$1 = (function (){var statearr_11990 = state_11974;
(statearr_11990[(17)] = inst_11941);

(statearr_11990[(9)] = inst_11915);

return statearr_11990;
})();
var statearr_11991_12029 = state_11974__$1;
(statearr_11991_12029[(2)] = null);

(statearr_11991_12029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (22))){
var inst_11968 = (state_11974[(2)]);
var state_11974__$1 = state_11974;
var statearr_11992_12030 = state_11974__$1;
(statearr_11992_12030[(2)] = inst_11968);

(statearr_11992_12030[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (6))){
var inst_11928 = (state_11974[(14)]);
var inst_11932 = cljs.core._EQ_.call(null,inst_11928,change);
var state_11974__$1 = state_11974;
var statearr_11993_12031 = state_11974__$1;
(statearr_11993_12031[(2)] = inst_11932);

(statearr_11993_12031[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (25))){
var state_11974__$1 = state_11974;
var statearr_11994_12032 = state_11974__$1;
(statearr_11994_12032[(2)] = null);

(statearr_11994_12032[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (17))){
var inst_11928 = (state_11974[(14)]);
var inst_11920 = (state_11974[(18)]);
var inst_11950 = inst_11920.call(null,inst_11928);
var inst_11951 = cljs.core.not.call(null,inst_11950);
var state_11974__$1 = state_11974;
var statearr_11995_12033 = state_11974__$1;
(statearr_11995_12033[(2)] = inst_11951);

(statearr_11995_12033[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (3))){
var inst_11972 = (state_11974[(2)]);
var state_11974__$1 = state_11974;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11974__$1,inst_11972);
} else {
if((state_val_11975 === (12))){
var state_11974__$1 = state_11974;
var statearr_11996_12034 = state_11974__$1;
(statearr_11996_12034[(2)] = null);

(statearr_11996_12034[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (2))){
var inst_11918 = (state_11974[(12)]);
var inst_11915 = (state_11974[(9)]);
var inst_11918__$1 = cljs.core.__destructure_map.call(null,inst_11915);
var inst_11919 = cljs.core.get.call(null,inst_11918__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_11920 = cljs.core.get.call(null,inst_11918__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_11921 = cljs.core.get.call(null,inst_11918__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_11974__$1 = (function (){var statearr_11997 = state_11974;
(statearr_11997[(12)] = inst_11918__$1);

(statearr_11997[(15)] = inst_11919);

(statearr_11997[(18)] = inst_11920);

return statearr_11997;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_11974__$1,(4),inst_11921);
} else {
if((state_val_11975 === (23))){
var inst_11959 = (state_11974[(2)]);
var state_11974__$1 = state_11974;
if(cljs.core.truth_(inst_11959)){
var statearr_11998_12035 = state_11974__$1;
(statearr_11998_12035[(1)] = (24));

} else {
var statearr_11999_12036 = state_11974__$1;
(statearr_11999_12036[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (19))){
var inst_11954 = (state_11974[(2)]);
var state_11974__$1 = state_11974;
var statearr_12000_12037 = state_11974__$1;
(statearr_12000_12037[(2)] = inst_11954);

(statearr_12000_12037[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (11))){
var inst_11928 = (state_11974[(14)]);
var inst_11938 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_11928);
var state_11974__$1 = state_11974;
var statearr_12001_12038 = state_11974__$1;
(statearr_12001_12038[(2)] = inst_11938);

(statearr_12001_12038[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (9))){
var inst_11928 = (state_11974[(14)]);
var inst_11919 = (state_11974[(15)]);
var inst_11945 = (state_11974[(19)]);
var inst_11945__$1 = inst_11919.call(null,inst_11928);
var state_11974__$1 = (function (){var statearr_12002 = state_11974;
(statearr_12002[(19)] = inst_11945__$1);

return statearr_12002;
})();
if(cljs.core.truth_(inst_11945__$1)){
var statearr_12003_12039 = state_11974__$1;
(statearr_12003_12039[(1)] = (14));

} else {
var statearr_12004_12040 = state_11974__$1;
(statearr_12004_12040[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (5))){
var inst_11929 = (state_11974[(13)]);
var state_11974__$1 = state_11974;
var statearr_12005_12041 = state_11974__$1;
(statearr_12005_12041[(2)] = inst_11929);

(statearr_12005_12041[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (14))){
var inst_11945 = (state_11974[(19)]);
var state_11974__$1 = state_11974;
var statearr_12006_12042 = state_11974__$1;
(statearr_12006_12042[(2)] = inst_11945);

(statearr_12006_12042[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (26))){
var inst_11964 = (state_11974[(2)]);
var state_11974__$1 = state_11974;
var statearr_12007_12043 = state_11974__$1;
(statearr_12007_12043[(2)] = inst_11964);

(statearr_12007_12043[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (16))){
var inst_11956 = (state_11974[(2)]);
var state_11974__$1 = state_11974;
if(cljs.core.truth_(inst_11956)){
var statearr_12008_12044 = state_11974__$1;
(statearr_12008_12044[(1)] = (20));

} else {
var statearr_12009_12045 = state_11974__$1;
(statearr_12009_12045[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (10))){
var inst_11970 = (state_11974[(2)]);
var state_11974__$1 = state_11974;
var statearr_12010_12046 = state_11974__$1;
(statearr_12010_12046[(2)] = inst_11970);

(statearr_12010_12046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (18))){
var inst_11948 = (state_11974[(16)]);
var state_11974__$1 = state_11974;
var statearr_12011_12047 = state_11974__$1;
(statearr_12011_12047[(2)] = inst_11948);

(statearr_12011_12047[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11975 === (8))){
var inst_11927 = (state_11974[(7)]);
var inst_11936 = (inst_11927 == null);
var state_11974__$1 = state_11974;
if(cljs.core.truth_(inst_11936)){
var statearr_12012_12048 = state_11974__$1;
(statearr_12012_12048[(1)] = (11));

} else {
var statearr_12013_12049 = state_11974__$1;
(statearr_12013_12049[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__10908__auto__ = null;
var cljs$core$async$mix_$_state_machine__10908__auto____0 = (function (){
var statearr_12014 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12014[(0)] = cljs$core$async$mix_$_state_machine__10908__auto__);

(statearr_12014[(1)] = (1));

return statearr_12014;
});
var cljs$core$async$mix_$_state_machine__10908__auto____1 = (function (state_11974){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_11974);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e12015){var ex__10911__auto__ = e12015;
var statearr_12016_12050 = state_11974;
(statearr_12016_12050[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_11974[(4)]))){
var statearr_12017_12051 = state_11974;
(statearr_12017_12051[(1)] = cljs.core.first.call(null,(state_11974[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12052 = state_11974;
state_11974 = G__12052;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10908__auto__ = function(state_11974){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10908__auto____1.call(this,state_11974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10908__auto____0;
cljs$core$async$mix_$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10908__auto____1;
return cljs$core$async$mix_$_state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_12018 = f__10982__auto__.call(null);
(statearr_12018[(6)] = c__10981__auto___12019);

return statearr_12018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_12055 = (function (p,v,ch,close_QMARK_){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4549__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_12055.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_12056 = (function (p,v,ch){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,p,v,ch);
} else {
var m__4549__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_12056.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_12057 = (function() {
var G__12058 = null;
var G__12058__1 = (function (p){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,p);
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__12058__2 = (function (p,v){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,p,v);
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__12058 = function(p,v){
switch(arguments.length){
case 1:
return G__12058__1.call(this,p);
case 2:
return G__12058__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12058.cljs$core$IFn$_invoke$arity$1 = G__12058__1;
G__12058.cljs$core$IFn$_invoke$arity$2 = G__12058__2;
return G__12058;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__12054 = arguments.length;
switch (G__12054) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12057.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12057.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__12062 = arguments.length;
switch (G__12062) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4253__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__12060_SHARP_){
if(cljs.core.truth_(p1__12060_SHARP_.call(null,topic))){
return p1__12060_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12060_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12063 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12063 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12064){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12064 = meta12064;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12063.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12065,meta12064__$1){
var self__ = this;
var _12065__$1 = this;
return (new cljs.core.async.t_cljs$core$async12063(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12064__$1));
}));

(cljs.core.async.t_cljs$core$async12063.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12065){
var self__ = this;
var _12065__$1 = this;
return self__.meta12064;
}));

(cljs.core.async.t_cljs$core$async12063.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12063.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12063.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12063.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async12063.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async12063.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async12063.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async12063.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12064","meta12064",-1440117833,null)], null);
}));

(cljs.core.async.t_cljs$core$async12063.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12063.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12063");

(cljs.core.async.t_cljs$core$async12063.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async12063");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12063.
 */
cljs.core.async.__GT_t_cljs$core$async12063 = (function cljs$core$async$__GT_t_cljs$core$async12063(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12064){
return (new cljs.core.async.t_cljs$core$async12063(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12064));
});

}

return (new cljs.core.async.t_cljs$core$async12063(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10981__auto___12184 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_12137){
var state_val_12138 = (state_12137[(1)]);
if((state_val_12138 === (7))){
var inst_12133 = (state_12137[(2)]);
var state_12137__$1 = state_12137;
var statearr_12139_12185 = state_12137__$1;
(statearr_12139_12185[(2)] = inst_12133);

(statearr_12139_12185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (20))){
var state_12137__$1 = state_12137;
var statearr_12140_12186 = state_12137__$1;
(statearr_12140_12186[(2)] = null);

(statearr_12140_12186[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (1))){
var state_12137__$1 = state_12137;
var statearr_12141_12187 = state_12137__$1;
(statearr_12141_12187[(2)] = null);

(statearr_12141_12187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (24))){
var inst_12116 = (state_12137[(7)]);
var inst_12125 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12116);
var state_12137__$1 = state_12137;
var statearr_12142_12188 = state_12137__$1;
(statearr_12142_12188[(2)] = inst_12125);

(statearr_12142_12188[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (4))){
var inst_12068 = (state_12137[(8)]);
var inst_12068__$1 = (state_12137[(2)]);
var inst_12069 = (inst_12068__$1 == null);
var state_12137__$1 = (function (){var statearr_12143 = state_12137;
(statearr_12143[(8)] = inst_12068__$1);

return statearr_12143;
})();
if(cljs.core.truth_(inst_12069)){
var statearr_12144_12189 = state_12137__$1;
(statearr_12144_12189[(1)] = (5));

} else {
var statearr_12145_12190 = state_12137__$1;
(statearr_12145_12190[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (15))){
var inst_12110 = (state_12137[(2)]);
var state_12137__$1 = state_12137;
var statearr_12146_12191 = state_12137__$1;
(statearr_12146_12191[(2)] = inst_12110);

(statearr_12146_12191[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (21))){
var inst_12130 = (state_12137[(2)]);
var state_12137__$1 = (function (){var statearr_12147 = state_12137;
(statearr_12147[(9)] = inst_12130);

return statearr_12147;
})();
var statearr_12148_12192 = state_12137__$1;
(statearr_12148_12192[(2)] = null);

(statearr_12148_12192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (13))){
var inst_12092 = (state_12137[(10)]);
var inst_12094 = cljs.core.chunked_seq_QMARK_.call(null,inst_12092);
var state_12137__$1 = state_12137;
if(inst_12094){
var statearr_12149_12193 = state_12137__$1;
(statearr_12149_12193[(1)] = (16));

} else {
var statearr_12150_12194 = state_12137__$1;
(statearr_12150_12194[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (22))){
var inst_12122 = (state_12137[(2)]);
var state_12137__$1 = state_12137;
if(cljs.core.truth_(inst_12122)){
var statearr_12151_12195 = state_12137__$1;
(statearr_12151_12195[(1)] = (23));

} else {
var statearr_12152_12196 = state_12137__$1;
(statearr_12152_12196[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (6))){
var inst_12116 = (state_12137[(7)]);
var inst_12118 = (state_12137[(11)]);
var inst_12068 = (state_12137[(8)]);
var inst_12116__$1 = topic_fn.call(null,inst_12068);
var inst_12117 = cljs.core.deref.call(null,mults);
var inst_12118__$1 = cljs.core.get.call(null,inst_12117,inst_12116__$1);
var state_12137__$1 = (function (){var statearr_12153 = state_12137;
(statearr_12153[(7)] = inst_12116__$1);

(statearr_12153[(11)] = inst_12118__$1);

return statearr_12153;
})();
if(cljs.core.truth_(inst_12118__$1)){
var statearr_12154_12197 = state_12137__$1;
(statearr_12154_12197[(1)] = (19));

} else {
var statearr_12155_12198 = state_12137__$1;
(statearr_12155_12198[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (25))){
var inst_12127 = (state_12137[(2)]);
var state_12137__$1 = state_12137;
var statearr_12156_12199 = state_12137__$1;
(statearr_12156_12199[(2)] = inst_12127);

(statearr_12156_12199[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (17))){
var inst_12092 = (state_12137[(10)]);
var inst_12101 = cljs.core.first.call(null,inst_12092);
var inst_12102 = cljs.core.async.muxch_STAR_.call(null,inst_12101);
var inst_12103 = cljs.core.async.close_BANG_.call(null,inst_12102);
var inst_12104 = cljs.core.next.call(null,inst_12092);
var inst_12078 = inst_12104;
var inst_12079 = null;
var inst_12080 = (0);
var inst_12081 = (0);
var state_12137__$1 = (function (){var statearr_12157 = state_12137;
(statearr_12157[(12)] = inst_12081);

(statearr_12157[(13)] = inst_12103);

(statearr_12157[(14)] = inst_12079);

(statearr_12157[(15)] = inst_12078);

(statearr_12157[(16)] = inst_12080);

return statearr_12157;
})();
var statearr_12158_12200 = state_12137__$1;
(statearr_12158_12200[(2)] = null);

(statearr_12158_12200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (3))){
var inst_12135 = (state_12137[(2)]);
var state_12137__$1 = state_12137;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12137__$1,inst_12135);
} else {
if((state_val_12138 === (12))){
var inst_12112 = (state_12137[(2)]);
var state_12137__$1 = state_12137;
var statearr_12159_12201 = state_12137__$1;
(statearr_12159_12201[(2)] = inst_12112);

(statearr_12159_12201[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (2))){
var state_12137__$1 = state_12137;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12137__$1,(4),ch);
} else {
if((state_val_12138 === (23))){
var state_12137__$1 = state_12137;
var statearr_12160_12202 = state_12137__$1;
(statearr_12160_12202[(2)] = null);

(statearr_12160_12202[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (19))){
var inst_12118 = (state_12137[(11)]);
var inst_12068 = (state_12137[(8)]);
var inst_12120 = cljs.core.async.muxch_STAR_.call(null,inst_12118);
var state_12137__$1 = state_12137;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12137__$1,(22),inst_12120,inst_12068);
} else {
if((state_val_12138 === (11))){
var inst_12078 = (state_12137[(15)]);
var inst_12092 = (state_12137[(10)]);
var inst_12092__$1 = cljs.core.seq.call(null,inst_12078);
var state_12137__$1 = (function (){var statearr_12161 = state_12137;
(statearr_12161[(10)] = inst_12092__$1);

return statearr_12161;
})();
if(inst_12092__$1){
var statearr_12162_12203 = state_12137__$1;
(statearr_12162_12203[(1)] = (13));

} else {
var statearr_12163_12204 = state_12137__$1;
(statearr_12163_12204[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (9))){
var inst_12114 = (state_12137[(2)]);
var state_12137__$1 = state_12137;
var statearr_12164_12205 = state_12137__$1;
(statearr_12164_12205[(2)] = inst_12114);

(statearr_12164_12205[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (5))){
var inst_12075 = cljs.core.deref.call(null,mults);
var inst_12076 = cljs.core.vals.call(null,inst_12075);
var inst_12077 = cljs.core.seq.call(null,inst_12076);
var inst_12078 = inst_12077;
var inst_12079 = null;
var inst_12080 = (0);
var inst_12081 = (0);
var state_12137__$1 = (function (){var statearr_12165 = state_12137;
(statearr_12165[(12)] = inst_12081);

(statearr_12165[(14)] = inst_12079);

(statearr_12165[(15)] = inst_12078);

(statearr_12165[(16)] = inst_12080);

return statearr_12165;
})();
var statearr_12166_12206 = state_12137__$1;
(statearr_12166_12206[(2)] = null);

(statearr_12166_12206[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (14))){
var state_12137__$1 = state_12137;
var statearr_12170_12207 = state_12137__$1;
(statearr_12170_12207[(2)] = null);

(statearr_12170_12207[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (16))){
var inst_12092 = (state_12137[(10)]);
var inst_12096 = cljs.core.chunk_first.call(null,inst_12092);
var inst_12097 = cljs.core.chunk_rest.call(null,inst_12092);
var inst_12098 = cljs.core.count.call(null,inst_12096);
var inst_12078 = inst_12097;
var inst_12079 = inst_12096;
var inst_12080 = inst_12098;
var inst_12081 = (0);
var state_12137__$1 = (function (){var statearr_12171 = state_12137;
(statearr_12171[(12)] = inst_12081);

(statearr_12171[(14)] = inst_12079);

(statearr_12171[(15)] = inst_12078);

(statearr_12171[(16)] = inst_12080);

return statearr_12171;
})();
var statearr_12172_12208 = state_12137__$1;
(statearr_12172_12208[(2)] = null);

(statearr_12172_12208[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (10))){
var inst_12081 = (state_12137[(12)]);
var inst_12079 = (state_12137[(14)]);
var inst_12078 = (state_12137[(15)]);
var inst_12080 = (state_12137[(16)]);
var inst_12086 = cljs.core._nth.call(null,inst_12079,inst_12081);
var inst_12087 = cljs.core.async.muxch_STAR_.call(null,inst_12086);
var inst_12088 = cljs.core.async.close_BANG_.call(null,inst_12087);
var inst_12089 = (inst_12081 + (1));
var tmp12167 = inst_12079;
var tmp12168 = inst_12078;
var tmp12169 = inst_12080;
var inst_12078__$1 = tmp12168;
var inst_12079__$1 = tmp12167;
var inst_12080__$1 = tmp12169;
var inst_12081__$1 = inst_12089;
var state_12137__$1 = (function (){var statearr_12173 = state_12137;
(statearr_12173[(12)] = inst_12081__$1);

(statearr_12173[(14)] = inst_12079__$1);

(statearr_12173[(15)] = inst_12078__$1);

(statearr_12173[(17)] = inst_12088);

(statearr_12173[(16)] = inst_12080__$1);

return statearr_12173;
})();
var statearr_12174_12209 = state_12137__$1;
(statearr_12174_12209[(2)] = null);

(statearr_12174_12209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (18))){
var inst_12107 = (state_12137[(2)]);
var state_12137__$1 = state_12137;
var statearr_12175_12210 = state_12137__$1;
(statearr_12175_12210[(2)] = inst_12107);

(statearr_12175_12210[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12138 === (8))){
var inst_12081 = (state_12137[(12)]);
var inst_12080 = (state_12137[(16)]);
var inst_12083 = (inst_12081 < inst_12080);
var inst_12084 = inst_12083;
var state_12137__$1 = state_12137;
if(cljs.core.truth_(inst_12084)){
var statearr_12176_12211 = state_12137__$1;
(statearr_12176_12211[(1)] = (10));

} else {
var statearr_12177_12212 = state_12137__$1;
(statearr_12177_12212[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10908__auto__ = null;
var cljs$core$async$state_machine__10908__auto____0 = (function (){
var statearr_12178 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12178[(0)] = cljs$core$async$state_machine__10908__auto__);

(statearr_12178[(1)] = (1));

return statearr_12178;
});
var cljs$core$async$state_machine__10908__auto____1 = (function (state_12137){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_12137);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e12179){var ex__10911__auto__ = e12179;
var statearr_12180_12213 = state_12137;
(statearr_12180_12213[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_12137[(4)]))){
var statearr_12181_12214 = state_12137;
(statearr_12181_12214[(1)] = cljs.core.first.call(null,(state_12137[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12215 = state_12137;
state_12137 = G__12215;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$state_machine__10908__auto__ = function(state_12137){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10908__auto____1.call(this,state_12137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10908__auto____0;
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10908__auto____1;
return cljs$core$async$state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_12182 = f__10982__auto__.call(null);
(statearr_12182[(6)] = c__10981__auto___12184);

return statearr_12182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__12217 = arguments.length;
switch (G__12217) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__12220 = arguments.length;
switch (G__12220) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__12223 = arguments.length;
switch (G__12223) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_.call(null,out);
} else {
var c__10981__auto___12301 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_12266){
var state_val_12267 = (state_12266[(1)]);
if((state_val_12267 === (7))){
var state_12266__$1 = state_12266;
var statearr_12268_12302 = state_12266__$1;
(statearr_12268_12302[(2)] = null);

(statearr_12268_12302[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12267 === (1))){
var state_12266__$1 = state_12266;
var statearr_12269_12303 = state_12266__$1;
(statearr_12269_12303[(2)] = null);

(statearr_12269_12303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12267 === (4))){
var inst_12227 = (state_12266[(7)]);
var inst_12226 = (state_12266[(8)]);
var inst_12229 = (inst_12227 < inst_12226);
var state_12266__$1 = state_12266;
if(cljs.core.truth_(inst_12229)){
var statearr_12270_12304 = state_12266__$1;
(statearr_12270_12304[(1)] = (6));

} else {
var statearr_12271_12305 = state_12266__$1;
(statearr_12271_12305[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12267 === (15))){
var inst_12252 = (state_12266[(9)]);
var inst_12257 = cljs.core.apply.call(null,f,inst_12252);
var state_12266__$1 = state_12266;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12266__$1,(17),out,inst_12257);
} else {
if((state_val_12267 === (13))){
var inst_12252 = (state_12266[(9)]);
var inst_12252__$1 = (state_12266[(2)]);
var inst_12253 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_12252__$1);
var state_12266__$1 = (function (){var statearr_12272 = state_12266;
(statearr_12272[(9)] = inst_12252__$1);

return statearr_12272;
})();
if(cljs.core.truth_(inst_12253)){
var statearr_12273_12306 = state_12266__$1;
(statearr_12273_12306[(1)] = (14));

} else {
var statearr_12274_12307 = state_12266__$1;
(statearr_12274_12307[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12267 === (6))){
var state_12266__$1 = state_12266;
var statearr_12275_12308 = state_12266__$1;
(statearr_12275_12308[(2)] = null);

(statearr_12275_12308[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12267 === (17))){
var inst_12259 = (state_12266[(2)]);
var state_12266__$1 = (function (){var statearr_12277 = state_12266;
(statearr_12277[(10)] = inst_12259);

return statearr_12277;
})();
var statearr_12278_12309 = state_12266__$1;
(statearr_12278_12309[(2)] = null);

(statearr_12278_12309[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12267 === (3))){
var inst_12264 = (state_12266[(2)]);
var state_12266__$1 = state_12266;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12266__$1,inst_12264);
} else {
if((state_val_12267 === (12))){
var _ = (function (){var statearr_12279 = state_12266;
(statearr_12279[(4)] = cljs.core.rest.call(null,(state_12266[(4)])));

return statearr_12279;
})();
var state_12266__$1 = state_12266;
var ex12276 = (state_12266__$1[(2)]);
var statearr_12280_12310 = state_12266__$1;
(statearr_12280_12310[(5)] = ex12276);


if((ex12276 instanceof Object)){
var statearr_12281_12311 = state_12266__$1;
(statearr_12281_12311[(1)] = (11));

(statearr_12281_12311[(5)] = null);

} else {
throw ex12276;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12267 === (2))){
var inst_12225 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_12226 = cnt;
var inst_12227 = (0);
var state_12266__$1 = (function (){var statearr_12282 = state_12266;
(statearr_12282[(7)] = inst_12227);

(statearr_12282[(8)] = inst_12226);

(statearr_12282[(11)] = inst_12225);

return statearr_12282;
})();
var statearr_12283_12312 = state_12266__$1;
(statearr_12283_12312[(2)] = null);

(statearr_12283_12312[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12267 === (11))){
var inst_12231 = (state_12266[(2)]);
var inst_12232 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_12266__$1 = (function (){var statearr_12284 = state_12266;
(statearr_12284[(12)] = inst_12231);

return statearr_12284;
})();
var statearr_12285_12313 = state_12266__$1;
(statearr_12285_12313[(2)] = inst_12232);

(statearr_12285_12313[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12267 === (9))){
var inst_12227 = (state_12266[(7)]);
var _ = (function (){var statearr_12286 = state_12266;
(statearr_12286[(4)] = cljs.core.cons.call(null,(12),(state_12266[(4)])));

return statearr_12286;
})();
var inst_12238 = chs__$1.call(null,inst_12227);
var inst_12239 = done.call(null,inst_12227);
var inst_12240 = cljs.core.async.take_BANG_.call(null,inst_12238,inst_12239);
var ___$1 = (function (){var statearr_12287 = state_12266;
(statearr_12287[(4)] = cljs.core.rest.call(null,(state_12266[(4)])));

return statearr_12287;
})();
var state_12266__$1 = state_12266;
var statearr_12288_12314 = state_12266__$1;
(statearr_12288_12314[(2)] = inst_12240);

(statearr_12288_12314[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12267 === (5))){
var inst_12250 = (state_12266[(2)]);
var state_12266__$1 = (function (){var statearr_12289 = state_12266;
(statearr_12289[(13)] = inst_12250);

return statearr_12289;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12266__$1,(13),dchan);
} else {
if((state_val_12267 === (14))){
var inst_12255 = cljs.core.async.close_BANG_.call(null,out);
var state_12266__$1 = state_12266;
var statearr_12290_12315 = state_12266__$1;
(statearr_12290_12315[(2)] = inst_12255);

(statearr_12290_12315[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12267 === (16))){
var inst_12262 = (state_12266[(2)]);
var state_12266__$1 = state_12266;
var statearr_12291_12316 = state_12266__$1;
(statearr_12291_12316[(2)] = inst_12262);

(statearr_12291_12316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12267 === (10))){
var inst_12227 = (state_12266[(7)]);
var inst_12243 = (state_12266[(2)]);
var inst_12244 = (inst_12227 + (1));
var inst_12227__$1 = inst_12244;
var state_12266__$1 = (function (){var statearr_12292 = state_12266;
(statearr_12292[(7)] = inst_12227__$1);

(statearr_12292[(14)] = inst_12243);

return statearr_12292;
})();
var statearr_12293_12317 = state_12266__$1;
(statearr_12293_12317[(2)] = null);

(statearr_12293_12317[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12267 === (8))){
var inst_12248 = (state_12266[(2)]);
var state_12266__$1 = state_12266;
var statearr_12294_12318 = state_12266__$1;
(statearr_12294_12318[(2)] = inst_12248);

(statearr_12294_12318[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10908__auto__ = null;
var cljs$core$async$state_machine__10908__auto____0 = (function (){
var statearr_12295 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12295[(0)] = cljs$core$async$state_machine__10908__auto__);

(statearr_12295[(1)] = (1));

return statearr_12295;
});
var cljs$core$async$state_machine__10908__auto____1 = (function (state_12266){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_12266);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e12296){var ex__10911__auto__ = e12296;
var statearr_12297_12319 = state_12266;
(statearr_12297_12319[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_12266[(4)]))){
var statearr_12298_12320 = state_12266;
(statearr_12298_12320[(1)] = cljs.core.first.call(null,(state_12266[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12321 = state_12266;
state_12266 = G__12321;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$state_machine__10908__auto__ = function(state_12266){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10908__auto____1.call(this,state_12266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10908__auto____0;
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10908__auto____1;
return cljs$core$async$state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_12299 = f__10982__auto__.call(null);
(statearr_12299[(6)] = c__10981__auto___12301);

return statearr_12299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__12324 = arguments.length;
switch (G__12324) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10981__auto___12379 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_12356){
var state_val_12357 = (state_12356[(1)]);
if((state_val_12357 === (7))){
var inst_12335 = (state_12356[(7)]);
var inst_12336 = (state_12356[(8)]);
var inst_12335__$1 = (state_12356[(2)]);
var inst_12336__$1 = cljs.core.nth.call(null,inst_12335__$1,(0),null);
var inst_12337 = cljs.core.nth.call(null,inst_12335__$1,(1),null);
var inst_12338 = (inst_12336__$1 == null);
var state_12356__$1 = (function (){var statearr_12358 = state_12356;
(statearr_12358[(7)] = inst_12335__$1);

(statearr_12358[(9)] = inst_12337);

(statearr_12358[(8)] = inst_12336__$1);

return statearr_12358;
})();
if(cljs.core.truth_(inst_12338)){
var statearr_12359_12380 = state_12356__$1;
(statearr_12359_12380[(1)] = (8));

} else {
var statearr_12360_12381 = state_12356__$1;
(statearr_12360_12381[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12357 === (1))){
var inst_12325 = cljs.core.vec.call(null,chs);
var inst_12326 = inst_12325;
var state_12356__$1 = (function (){var statearr_12361 = state_12356;
(statearr_12361[(10)] = inst_12326);

return statearr_12361;
})();
var statearr_12362_12382 = state_12356__$1;
(statearr_12362_12382[(2)] = null);

(statearr_12362_12382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12357 === (4))){
var inst_12326 = (state_12356[(10)]);
var state_12356__$1 = state_12356;
return cljs.core.async.ioc_alts_BANG_.call(null,state_12356__$1,(7),inst_12326);
} else {
if((state_val_12357 === (6))){
var inst_12352 = (state_12356[(2)]);
var state_12356__$1 = state_12356;
var statearr_12363_12383 = state_12356__$1;
(statearr_12363_12383[(2)] = inst_12352);

(statearr_12363_12383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12357 === (3))){
var inst_12354 = (state_12356[(2)]);
var state_12356__$1 = state_12356;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12356__$1,inst_12354);
} else {
if((state_val_12357 === (2))){
var inst_12326 = (state_12356[(10)]);
var inst_12328 = cljs.core.count.call(null,inst_12326);
var inst_12329 = (inst_12328 > (0));
var state_12356__$1 = state_12356;
if(cljs.core.truth_(inst_12329)){
var statearr_12365_12384 = state_12356__$1;
(statearr_12365_12384[(1)] = (4));

} else {
var statearr_12366_12385 = state_12356__$1;
(statearr_12366_12385[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12357 === (11))){
var inst_12326 = (state_12356[(10)]);
var inst_12345 = (state_12356[(2)]);
var tmp12364 = inst_12326;
var inst_12326__$1 = tmp12364;
var state_12356__$1 = (function (){var statearr_12367 = state_12356;
(statearr_12367[(10)] = inst_12326__$1);

(statearr_12367[(11)] = inst_12345);

return statearr_12367;
})();
var statearr_12368_12386 = state_12356__$1;
(statearr_12368_12386[(2)] = null);

(statearr_12368_12386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12357 === (9))){
var inst_12336 = (state_12356[(8)]);
var state_12356__$1 = state_12356;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12356__$1,(11),out,inst_12336);
} else {
if((state_val_12357 === (5))){
var inst_12350 = cljs.core.async.close_BANG_.call(null,out);
var state_12356__$1 = state_12356;
var statearr_12369_12387 = state_12356__$1;
(statearr_12369_12387[(2)] = inst_12350);

(statearr_12369_12387[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12357 === (10))){
var inst_12348 = (state_12356[(2)]);
var state_12356__$1 = state_12356;
var statearr_12370_12388 = state_12356__$1;
(statearr_12370_12388[(2)] = inst_12348);

(statearr_12370_12388[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12357 === (8))){
var inst_12326 = (state_12356[(10)]);
var inst_12335 = (state_12356[(7)]);
var inst_12337 = (state_12356[(9)]);
var inst_12336 = (state_12356[(8)]);
var inst_12340 = (function (){var cs = inst_12326;
var vec__12331 = inst_12335;
var v = inst_12336;
var c = inst_12337;
return (function (p1__12322_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__12322_SHARP_);
});
})();
var inst_12341 = cljs.core.filterv.call(null,inst_12340,inst_12326);
var inst_12326__$1 = inst_12341;
var state_12356__$1 = (function (){var statearr_12371 = state_12356;
(statearr_12371[(10)] = inst_12326__$1);

return statearr_12371;
})();
var statearr_12372_12389 = state_12356__$1;
(statearr_12372_12389[(2)] = null);

(statearr_12372_12389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10908__auto__ = null;
var cljs$core$async$state_machine__10908__auto____0 = (function (){
var statearr_12373 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12373[(0)] = cljs$core$async$state_machine__10908__auto__);

(statearr_12373[(1)] = (1));

return statearr_12373;
});
var cljs$core$async$state_machine__10908__auto____1 = (function (state_12356){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_12356);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e12374){var ex__10911__auto__ = e12374;
var statearr_12375_12390 = state_12356;
(statearr_12375_12390[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_12356[(4)]))){
var statearr_12376_12391 = state_12356;
(statearr_12376_12391[(1)] = cljs.core.first.call(null,(state_12356[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12392 = state_12356;
state_12356 = G__12392;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$state_machine__10908__auto__ = function(state_12356){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10908__auto____1.call(this,state_12356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10908__auto____0;
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10908__auto____1;
return cljs$core$async$state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_12377 = f__10982__auto__.call(null);
(statearr_12377[(6)] = c__10981__auto___12379);

return statearr_12377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__12394 = arguments.length;
switch (G__12394) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10981__auto___12440 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_12418){
var state_val_12419 = (state_12418[(1)]);
if((state_val_12419 === (7))){
var inst_12400 = (state_12418[(7)]);
var inst_12400__$1 = (state_12418[(2)]);
var inst_12401 = (inst_12400__$1 == null);
var inst_12402 = cljs.core.not.call(null,inst_12401);
var state_12418__$1 = (function (){var statearr_12420 = state_12418;
(statearr_12420[(7)] = inst_12400__$1);

return statearr_12420;
})();
if(inst_12402){
var statearr_12421_12441 = state_12418__$1;
(statearr_12421_12441[(1)] = (8));

} else {
var statearr_12422_12442 = state_12418__$1;
(statearr_12422_12442[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (1))){
var inst_12395 = (0);
var state_12418__$1 = (function (){var statearr_12423 = state_12418;
(statearr_12423[(8)] = inst_12395);

return statearr_12423;
})();
var statearr_12424_12443 = state_12418__$1;
(statearr_12424_12443[(2)] = null);

(statearr_12424_12443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (4))){
var state_12418__$1 = state_12418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12418__$1,(7),ch);
} else {
if((state_val_12419 === (6))){
var inst_12413 = (state_12418[(2)]);
var state_12418__$1 = state_12418;
var statearr_12425_12444 = state_12418__$1;
(statearr_12425_12444[(2)] = inst_12413);

(statearr_12425_12444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (3))){
var inst_12415 = (state_12418[(2)]);
var inst_12416 = cljs.core.async.close_BANG_.call(null,out);
var state_12418__$1 = (function (){var statearr_12426 = state_12418;
(statearr_12426[(9)] = inst_12415);

return statearr_12426;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12418__$1,inst_12416);
} else {
if((state_val_12419 === (2))){
var inst_12395 = (state_12418[(8)]);
var inst_12397 = (inst_12395 < n);
var state_12418__$1 = state_12418;
if(cljs.core.truth_(inst_12397)){
var statearr_12427_12445 = state_12418__$1;
(statearr_12427_12445[(1)] = (4));

} else {
var statearr_12428_12446 = state_12418__$1;
(statearr_12428_12446[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (11))){
var inst_12395 = (state_12418[(8)]);
var inst_12405 = (state_12418[(2)]);
var inst_12406 = (inst_12395 + (1));
var inst_12395__$1 = inst_12406;
var state_12418__$1 = (function (){var statearr_12429 = state_12418;
(statearr_12429[(8)] = inst_12395__$1);

(statearr_12429[(10)] = inst_12405);

return statearr_12429;
})();
var statearr_12430_12447 = state_12418__$1;
(statearr_12430_12447[(2)] = null);

(statearr_12430_12447[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (9))){
var state_12418__$1 = state_12418;
var statearr_12431_12448 = state_12418__$1;
(statearr_12431_12448[(2)] = null);

(statearr_12431_12448[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (5))){
var state_12418__$1 = state_12418;
var statearr_12432_12449 = state_12418__$1;
(statearr_12432_12449[(2)] = null);

(statearr_12432_12449[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (10))){
var inst_12410 = (state_12418[(2)]);
var state_12418__$1 = state_12418;
var statearr_12433_12450 = state_12418__$1;
(statearr_12433_12450[(2)] = inst_12410);

(statearr_12433_12450[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (8))){
var inst_12400 = (state_12418[(7)]);
var state_12418__$1 = state_12418;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12418__$1,(11),out,inst_12400);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10908__auto__ = null;
var cljs$core$async$state_machine__10908__auto____0 = (function (){
var statearr_12434 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12434[(0)] = cljs$core$async$state_machine__10908__auto__);

(statearr_12434[(1)] = (1));

return statearr_12434;
});
var cljs$core$async$state_machine__10908__auto____1 = (function (state_12418){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_12418);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e12435){var ex__10911__auto__ = e12435;
var statearr_12436_12451 = state_12418;
(statearr_12436_12451[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_12418[(4)]))){
var statearr_12437_12452 = state_12418;
(statearr_12437_12452[(1)] = cljs.core.first.call(null,(state_12418[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12453 = state_12418;
state_12418 = G__12453;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$state_machine__10908__auto__ = function(state_12418){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10908__auto____1.call(this,state_12418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10908__auto____0;
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10908__auto____1;
return cljs$core$async$state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_12438 = f__10982__auto__.call(null);
(statearr_12438[(6)] = c__10981__auto___12440);

return statearr_12438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12455 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12455 = (function (f,ch,meta12456){
this.f = f;
this.ch = ch;
this.meta12456 = meta12456;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12455.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12457,meta12456__$1){
var self__ = this;
var _12457__$1 = this;
return (new cljs.core.async.t_cljs$core$async12455(self__.f,self__.ch,meta12456__$1));
}));

(cljs.core.async.t_cljs$core$async12455.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12457){
var self__ = this;
var _12457__$1 = this;
return self__.meta12456;
}));

(cljs.core.async.t_cljs$core$async12455.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12455.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12455.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12455.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12455.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12458 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12458 = (function (f,ch,meta12456,_,fn1,meta12459){
this.f = f;
this.ch = ch;
this.meta12456 = meta12456;
this._ = _;
this.fn1 = fn1;
this.meta12459 = meta12459;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12458.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12460,meta12459__$1){
var self__ = this;
var _12460__$1 = this;
return (new cljs.core.async.t_cljs$core$async12458(self__.f,self__.ch,self__.meta12456,self__._,self__.fn1,meta12459__$1));
}));

(cljs.core.async.t_cljs$core$async12458.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12460){
var self__ = this;
var _12460__$1 = this;
return self__.meta12459;
}));

(cljs.core.async.t_cljs$core$async12458.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12458.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async12458.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12458.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__12454_SHARP_){
return f1.call(null,(((p1__12454_SHARP_ == null))?null:self__.f.call(null,p1__12454_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async12458.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12456","meta12456",1038838013,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async12455","cljs.core.async/t_cljs$core$async12455",1692865949,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta12459","meta12459",-2141144617,null)], null);
}));

(cljs.core.async.t_cljs$core$async12458.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12458.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12458");

(cljs.core.async.t_cljs$core$async12458.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async12458");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12458.
 */
cljs.core.async.__GT_t_cljs$core$async12458 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12458(f__$1,ch__$1,meta12456__$1,___$2,fn1__$1,meta12459){
return (new cljs.core.async.t_cljs$core$async12458(f__$1,ch__$1,meta12456__$1,___$2,fn1__$1,meta12459));
});

}

return (new cljs.core.async.t_cljs$core$async12458(self__.f,self__.ch,self__.meta12456,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4251__auto__ = ret;
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async12455.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12455.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async12455.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12456","meta12456",1038838013,null)], null);
}));

(cljs.core.async.t_cljs$core$async12455.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12455.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12455");

(cljs.core.async.t_cljs$core$async12455.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async12455");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12455.
 */
cljs.core.async.__GT_t_cljs$core$async12455 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12455(f__$1,ch__$1,meta12456){
return (new cljs.core.async.t_cljs$core$async12455(f__$1,ch__$1,meta12456));
});

}

return (new cljs.core.async.t_cljs$core$async12455(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12461 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12461 = (function (f,ch,meta12462){
this.f = f;
this.ch = ch;
this.meta12462 = meta12462;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12461.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12463,meta12462__$1){
var self__ = this;
var _12463__$1 = this;
return (new cljs.core.async.t_cljs$core$async12461(self__.f,self__.ch,meta12462__$1));
}));

(cljs.core.async.t_cljs$core$async12461.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12463){
var self__ = this;
var _12463__$1 = this;
return self__.meta12462;
}));

(cljs.core.async.t_cljs$core$async12461.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12461.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12461.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12461.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12461.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12461.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async12461.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12462","meta12462",1700041412,null)], null);
}));

(cljs.core.async.t_cljs$core$async12461.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12461.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12461");

(cljs.core.async.t_cljs$core$async12461.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async12461");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12461.
 */
cljs.core.async.__GT_t_cljs$core$async12461 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async12461(f__$1,ch__$1,meta12462){
return (new cljs.core.async.t_cljs$core$async12461(f__$1,ch__$1,meta12462));
});

}

return (new cljs.core.async.t_cljs$core$async12461(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12464 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12464 = (function (p,ch,meta12465){
this.p = p;
this.ch = ch;
this.meta12465 = meta12465;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12464.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12466,meta12465__$1){
var self__ = this;
var _12466__$1 = this;
return (new cljs.core.async.t_cljs$core$async12464(self__.p,self__.ch,meta12465__$1));
}));

(cljs.core.async.t_cljs$core$async12464.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12466){
var self__ = this;
var _12466__$1 = this;
return self__.meta12465;
}));

(cljs.core.async.t_cljs$core$async12464.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12464.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12464.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12464.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12464.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12464.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12464.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async12464.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12465","meta12465",-1111426819,null)], null);
}));

(cljs.core.async.t_cljs$core$async12464.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12464.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12464");

(cljs.core.async.t_cljs$core$async12464.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async12464");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12464.
 */
cljs.core.async.__GT_t_cljs$core$async12464 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async12464(p__$1,ch__$1,meta12465){
return (new cljs.core.async.t_cljs$core$async12464(p__$1,ch__$1,meta12465));
});

}

return (new cljs.core.async.t_cljs$core$async12464(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__12468 = arguments.length;
switch (G__12468) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10981__auto___12509 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_12489){
var state_val_12490 = (state_12489[(1)]);
if((state_val_12490 === (7))){
var inst_12485 = (state_12489[(2)]);
var state_12489__$1 = state_12489;
var statearr_12491_12510 = state_12489__$1;
(statearr_12491_12510[(2)] = inst_12485);

(statearr_12491_12510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12490 === (1))){
var state_12489__$1 = state_12489;
var statearr_12492_12511 = state_12489__$1;
(statearr_12492_12511[(2)] = null);

(statearr_12492_12511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12490 === (4))){
var inst_12471 = (state_12489[(7)]);
var inst_12471__$1 = (state_12489[(2)]);
var inst_12472 = (inst_12471__$1 == null);
var state_12489__$1 = (function (){var statearr_12493 = state_12489;
(statearr_12493[(7)] = inst_12471__$1);

return statearr_12493;
})();
if(cljs.core.truth_(inst_12472)){
var statearr_12494_12512 = state_12489__$1;
(statearr_12494_12512[(1)] = (5));

} else {
var statearr_12495_12513 = state_12489__$1;
(statearr_12495_12513[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12490 === (6))){
var inst_12471 = (state_12489[(7)]);
var inst_12476 = p.call(null,inst_12471);
var state_12489__$1 = state_12489;
if(cljs.core.truth_(inst_12476)){
var statearr_12496_12514 = state_12489__$1;
(statearr_12496_12514[(1)] = (8));

} else {
var statearr_12497_12515 = state_12489__$1;
(statearr_12497_12515[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12490 === (3))){
var inst_12487 = (state_12489[(2)]);
var state_12489__$1 = state_12489;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12489__$1,inst_12487);
} else {
if((state_val_12490 === (2))){
var state_12489__$1 = state_12489;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12489__$1,(4),ch);
} else {
if((state_val_12490 === (11))){
var inst_12479 = (state_12489[(2)]);
var state_12489__$1 = state_12489;
var statearr_12498_12516 = state_12489__$1;
(statearr_12498_12516[(2)] = inst_12479);

(statearr_12498_12516[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12490 === (9))){
var state_12489__$1 = state_12489;
var statearr_12499_12517 = state_12489__$1;
(statearr_12499_12517[(2)] = null);

(statearr_12499_12517[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12490 === (5))){
var inst_12474 = cljs.core.async.close_BANG_.call(null,out);
var state_12489__$1 = state_12489;
var statearr_12500_12518 = state_12489__$1;
(statearr_12500_12518[(2)] = inst_12474);

(statearr_12500_12518[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12490 === (10))){
var inst_12482 = (state_12489[(2)]);
var state_12489__$1 = (function (){var statearr_12501 = state_12489;
(statearr_12501[(8)] = inst_12482);

return statearr_12501;
})();
var statearr_12502_12519 = state_12489__$1;
(statearr_12502_12519[(2)] = null);

(statearr_12502_12519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12490 === (8))){
var inst_12471 = (state_12489[(7)]);
var state_12489__$1 = state_12489;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12489__$1,(11),out,inst_12471);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10908__auto__ = null;
var cljs$core$async$state_machine__10908__auto____0 = (function (){
var statearr_12503 = [null,null,null,null,null,null,null,null,null];
(statearr_12503[(0)] = cljs$core$async$state_machine__10908__auto__);

(statearr_12503[(1)] = (1));

return statearr_12503;
});
var cljs$core$async$state_machine__10908__auto____1 = (function (state_12489){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_12489);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e12504){var ex__10911__auto__ = e12504;
var statearr_12505_12520 = state_12489;
(statearr_12505_12520[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_12489[(4)]))){
var statearr_12506_12521 = state_12489;
(statearr_12506_12521[(1)] = cljs.core.first.call(null,(state_12489[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12522 = state_12489;
state_12489 = G__12522;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$state_machine__10908__auto__ = function(state_12489){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10908__auto____1.call(this,state_12489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10908__auto____0;
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10908__auto____1;
return cljs$core$async$state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_12507 = f__10982__auto__.call(null);
(statearr_12507[(6)] = c__10981__auto___12509);

return statearr_12507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__12524 = arguments.length;
switch (G__12524) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__10981__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_12587){
var state_val_12588 = (state_12587[(1)]);
if((state_val_12588 === (7))){
var inst_12583 = (state_12587[(2)]);
var state_12587__$1 = state_12587;
var statearr_12589_12628 = state_12587__$1;
(statearr_12589_12628[(2)] = inst_12583);

(statearr_12589_12628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (20))){
var inst_12553 = (state_12587[(7)]);
var inst_12564 = (state_12587[(2)]);
var inst_12565 = cljs.core.next.call(null,inst_12553);
var inst_12539 = inst_12565;
var inst_12540 = null;
var inst_12541 = (0);
var inst_12542 = (0);
var state_12587__$1 = (function (){var statearr_12590 = state_12587;
(statearr_12590[(8)] = inst_12541);

(statearr_12590[(9)] = inst_12542);

(statearr_12590[(10)] = inst_12539);

(statearr_12590[(11)] = inst_12540);

(statearr_12590[(12)] = inst_12564);

return statearr_12590;
})();
var statearr_12591_12629 = state_12587__$1;
(statearr_12591_12629[(2)] = null);

(statearr_12591_12629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (1))){
var state_12587__$1 = state_12587;
var statearr_12592_12630 = state_12587__$1;
(statearr_12592_12630[(2)] = null);

(statearr_12592_12630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (4))){
var inst_12528 = (state_12587[(13)]);
var inst_12528__$1 = (state_12587[(2)]);
var inst_12529 = (inst_12528__$1 == null);
var state_12587__$1 = (function (){var statearr_12593 = state_12587;
(statearr_12593[(13)] = inst_12528__$1);

return statearr_12593;
})();
if(cljs.core.truth_(inst_12529)){
var statearr_12594_12631 = state_12587__$1;
(statearr_12594_12631[(1)] = (5));

} else {
var statearr_12595_12632 = state_12587__$1;
(statearr_12595_12632[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (15))){
var state_12587__$1 = state_12587;
var statearr_12599_12633 = state_12587__$1;
(statearr_12599_12633[(2)] = null);

(statearr_12599_12633[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (21))){
var state_12587__$1 = state_12587;
var statearr_12600_12634 = state_12587__$1;
(statearr_12600_12634[(2)] = null);

(statearr_12600_12634[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (13))){
var inst_12541 = (state_12587[(8)]);
var inst_12542 = (state_12587[(9)]);
var inst_12539 = (state_12587[(10)]);
var inst_12540 = (state_12587[(11)]);
var inst_12549 = (state_12587[(2)]);
var inst_12550 = (inst_12542 + (1));
var tmp12596 = inst_12541;
var tmp12597 = inst_12539;
var tmp12598 = inst_12540;
var inst_12539__$1 = tmp12597;
var inst_12540__$1 = tmp12598;
var inst_12541__$1 = tmp12596;
var inst_12542__$1 = inst_12550;
var state_12587__$1 = (function (){var statearr_12601 = state_12587;
(statearr_12601[(8)] = inst_12541__$1);

(statearr_12601[(9)] = inst_12542__$1);

(statearr_12601[(10)] = inst_12539__$1);

(statearr_12601[(14)] = inst_12549);

(statearr_12601[(11)] = inst_12540__$1);

return statearr_12601;
})();
var statearr_12602_12635 = state_12587__$1;
(statearr_12602_12635[(2)] = null);

(statearr_12602_12635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (22))){
var state_12587__$1 = state_12587;
var statearr_12603_12636 = state_12587__$1;
(statearr_12603_12636[(2)] = null);

(statearr_12603_12636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (6))){
var inst_12528 = (state_12587[(13)]);
var inst_12537 = f.call(null,inst_12528);
var inst_12538 = cljs.core.seq.call(null,inst_12537);
var inst_12539 = inst_12538;
var inst_12540 = null;
var inst_12541 = (0);
var inst_12542 = (0);
var state_12587__$1 = (function (){var statearr_12604 = state_12587;
(statearr_12604[(8)] = inst_12541);

(statearr_12604[(9)] = inst_12542);

(statearr_12604[(10)] = inst_12539);

(statearr_12604[(11)] = inst_12540);

return statearr_12604;
})();
var statearr_12605_12637 = state_12587__$1;
(statearr_12605_12637[(2)] = null);

(statearr_12605_12637[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (17))){
var inst_12553 = (state_12587[(7)]);
var inst_12557 = cljs.core.chunk_first.call(null,inst_12553);
var inst_12558 = cljs.core.chunk_rest.call(null,inst_12553);
var inst_12559 = cljs.core.count.call(null,inst_12557);
var inst_12539 = inst_12558;
var inst_12540 = inst_12557;
var inst_12541 = inst_12559;
var inst_12542 = (0);
var state_12587__$1 = (function (){var statearr_12606 = state_12587;
(statearr_12606[(8)] = inst_12541);

(statearr_12606[(9)] = inst_12542);

(statearr_12606[(10)] = inst_12539);

(statearr_12606[(11)] = inst_12540);

return statearr_12606;
})();
var statearr_12607_12638 = state_12587__$1;
(statearr_12607_12638[(2)] = null);

(statearr_12607_12638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (3))){
var inst_12585 = (state_12587[(2)]);
var state_12587__$1 = state_12587;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12587__$1,inst_12585);
} else {
if((state_val_12588 === (12))){
var inst_12573 = (state_12587[(2)]);
var state_12587__$1 = state_12587;
var statearr_12608_12639 = state_12587__$1;
(statearr_12608_12639[(2)] = inst_12573);

(statearr_12608_12639[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (2))){
var state_12587__$1 = state_12587;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12587__$1,(4),in$);
} else {
if((state_val_12588 === (23))){
var inst_12581 = (state_12587[(2)]);
var state_12587__$1 = state_12587;
var statearr_12609_12640 = state_12587__$1;
(statearr_12609_12640[(2)] = inst_12581);

(statearr_12609_12640[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (19))){
var inst_12568 = (state_12587[(2)]);
var state_12587__$1 = state_12587;
var statearr_12610_12641 = state_12587__$1;
(statearr_12610_12641[(2)] = inst_12568);

(statearr_12610_12641[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (11))){
var inst_12539 = (state_12587[(10)]);
var inst_12553 = (state_12587[(7)]);
var inst_12553__$1 = cljs.core.seq.call(null,inst_12539);
var state_12587__$1 = (function (){var statearr_12611 = state_12587;
(statearr_12611[(7)] = inst_12553__$1);

return statearr_12611;
})();
if(inst_12553__$1){
var statearr_12612_12642 = state_12587__$1;
(statearr_12612_12642[(1)] = (14));

} else {
var statearr_12613_12643 = state_12587__$1;
(statearr_12613_12643[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (9))){
var inst_12575 = (state_12587[(2)]);
var inst_12576 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_12587__$1 = (function (){var statearr_12614 = state_12587;
(statearr_12614[(15)] = inst_12575);

return statearr_12614;
})();
if(cljs.core.truth_(inst_12576)){
var statearr_12615_12644 = state_12587__$1;
(statearr_12615_12644[(1)] = (21));

} else {
var statearr_12616_12645 = state_12587__$1;
(statearr_12616_12645[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (5))){
var inst_12531 = cljs.core.async.close_BANG_.call(null,out);
var state_12587__$1 = state_12587;
var statearr_12617_12646 = state_12587__$1;
(statearr_12617_12646[(2)] = inst_12531);

(statearr_12617_12646[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (14))){
var inst_12553 = (state_12587[(7)]);
var inst_12555 = cljs.core.chunked_seq_QMARK_.call(null,inst_12553);
var state_12587__$1 = state_12587;
if(inst_12555){
var statearr_12618_12647 = state_12587__$1;
(statearr_12618_12647[(1)] = (17));

} else {
var statearr_12619_12648 = state_12587__$1;
(statearr_12619_12648[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (16))){
var inst_12571 = (state_12587[(2)]);
var state_12587__$1 = state_12587;
var statearr_12620_12649 = state_12587__$1;
(statearr_12620_12649[(2)] = inst_12571);

(statearr_12620_12649[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12588 === (10))){
var inst_12542 = (state_12587[(9)]);
var inst_12540 = (state_12587[(11)]);
var inst_12547 = cljs.core._nth.call(null,inst_12540,inst_12542);
var state_12587__$1 = state_12587;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12587__$1,(13),out,inst_12547);
} else {
if((state_val_12588 === (18))){
var inst_12553 = (state_12587[(7)]);
var inst_12562 = cljs.core.first.call(null,inst_12553);
var state_12587__$1 = state_12587;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12587__$1,(20),out,inst_12562);
} else {
if((state_val_12588 === (8))){
var inst_12541 = (state_12587[(8)]);
var inst_12542 = (state_12587[(9)]);
var inst_12544 = (inst_12542 < inst_12541);
var inst_12545 = inst_12544;
var state_12587__$1 = state_12587;
if(cljs.core.truth_(inst_12545)){
var statearr_12621_12650 = state_12587__$1;
(statearr_12621_12650[(1)] = (10));

} else {
var statearr_12622_12651 = state_12587__$1;
(statearr_12622_12651[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10908__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10908__auto____0 = (function (){
var statearr_12623 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12623[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10908__auto__);

(statearr_12623[(1)] = (1));

return statearr_12623;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10908__auto____1 = (function (state_12587){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_12587);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e12624){var ex__10911__auto__ = e12624;
var statearr_12625_12652 = state_12587;
(statearr_12625_12652[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_12587[(4)]))){
var statearr_12626_12653 = state_12587;
(statearr_12626_12653[(1)] = cljs.core.first.call(null,(state_12587[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12654 = state_12587;
state_12587 = G__12654;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10908__auto__ = function(state_12587){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10908__auto____1.call(this,state_12587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10908__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10908__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_12627 = f__10982__auto__.call(null);
(statearr_12627[(6)] = c__10981__auto__);

return statearr_12627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));

return c__10981__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__12656 = arguments.length;
switch (G__12656) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__12659 = arguments.length;
switch (G__12659) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__12662 = arguments.length;
switch (G__12662) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10981__auto___12710 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_12686){
var state_val_12687 = (state_12686[(1)]);
if((state_val_12687 === (7))){
var inst_12681 = (state_12686[(2)]);
var state_12686__$1 = state_12686;
var statearr_12688_12711 = state_12686__$1;
(statearr_12688_12711[(2)] = inst_12681);

(statearr_12688_12711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12687 === (1))){
var inst_12663 = null;
var state_12686__$1 = (function (){var statearr_12689 = state_12686;
(statearr_12689[(7)] = inst_12663);

return statearr_12689;
})();
var statearr_12690_12712 = state_12686__$1;
(statearr_12690_12712[(2)] = null);

(statearr_12690_12712[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12687 === (4))){
var inst_12666 = (state_12686[(8)]);
var inst_12666__$1 = (state_12686[(2)]);
var inst_12667 = (inst_12666__$1 == null);
var inst_12668 = cljs.core.not.call(null,inst_12667);
var state_12686__$1 = (function (){var statearr_12691 = state_12686;
(statearr_12691[(8)] = inst_12666__$1);

return statearr_12691;
})();
if(inst_12668){
var statearr_12692_12713 = state_12686__$1;
(statearr_12692_12713[(1)] = (5));

} else {
var statearr_12693_12714 = state_12686__$1;
(statearr_12693_12714[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12687 === (6))){
var state_12686__$1 = state_12686;
var statearr_12694_12715 = state_12686__$1;
(statearr_12694_12715[(2)] = null);

(statearr_12694_12715[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12687 === (3))){
var inst_12683 = (state_12686[(2)]);
var inst_12684 = cljs.core.async.close_BANG_.call(null,out);
var state_12686__$1 = (function (){var statearr_12695 = state_12686;
(statearr_12695[(9)] = inst_12683);

return statearr_12695;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12686__$1,inst_12684);
} else {
if((state_val_12687 === (2))){
var state_12686__$1 = state_12686;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12686__$1,(4),ch);
} else {
if((state_val_12687 === (11))){
var inst_12666 = (state_12686[(8)]);
var inst_12675 = (state_12686[(2)]);
var inst_12663 = inst_12666;
var state_12686__$1 = (function (){var statearr_12696 = state_12686;
(statearr_12696[(7)] = inst_12663);

(statearr_12696[(10)] = inst_12675);

return statearr_12696;
})();
var statearr_12697_12716 = state_12686__$1;
(statearr_12697_12716[(2)] = null);

(statearr_12697_12716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12687 === (9))){
var inst_12666 = (state_12686[(8)]);
var state_12686__$1 = state_12686;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12686__$1,(11),out,inst_12666);
} else {
if((state_val_12687 === (5))){
var inst_12663 = (state_12686[(7)]);
var inst_12666 = (state_12686[(8)]);
var inst_12670 = cljs.core._EQ_.call(null,inst_12666,inst_12663);
var state_12686__$1 = state_12686;
if(inst_12670){
var statearr_12699_12717 = state_12686__$1;
(statearr_12699_12717[(1)] = (8));

} else {
var statearr_12700_12718 = state_12686__$1;
(statearr_12700_12718[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12687 === (10))){
var inst_12678 = (state_12686[(2)]);
var state_12686__$1 = state_12686;
var statearr_12701_12719 = state_12686__$1;
(statearr_12701_12719[(2)] = inst_12678);

(statearr_12701_12719[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12687 === (8))){
var inst_12663 = (state_12686[(7)]);
var tmp12698 = inst_12663;
var inst_12663__$1 = tmp12698;
var state_12686__$1 = (function (){var statearr_12702 = state_12686;
(statearr_12702[(7)] = inst_12663__$1);

return statearr_12702;
})();
var statearr_12703_12720 = state_12686__$1;
(statearr_12703_12720[(2)] = null);

(statearr_12703_12720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10908__auto__ = null;
var cljs$core$async$state_machine__10908__auto____0 = (function (){
var statearr_12704 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12704[(0)] = cljs$core$async$state_machine__10908__auto__);

(statearr_12704[(1)] = (1));

return statearr_12704;
});
var cljs$core$async$state_machine__10908__auto____1 = (function (state_12686){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_12686);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e12705){var ex__10911__auto__ = e12705;
var statearr_12706_12721 = state_12686;
(statearr_12706_12721[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_12686[(4)]))){
var statearr_12707_12722 = state_12686;
(statearr_12707_12722[(1)] = cljs.core.first.call(null,(state_12686[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12723 = state_12686;
state_12686 = G__12723;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$state_machine__10908__auto__ = function(state_12686){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10908__auto____1.call(this,state_12686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10908__auto____0;
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10908__auto____1;
return cljs$core$async$state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_12708 = f__10982__auto__.call(null);
(statearr_12708[(6)] = c__10981__auto___12710);

return statearr_12708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__12725 = arguments.length;
switch (G__12725) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10981__auto___12792 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_12763){
var state_val_12764 = (state_12763[(1)]);
if((state_val_12764 === (7))){
var inst_12759 = (state_12763[(2)]);
var state_12763__$1 = state_12763;
var statearr_12765_12793 = state_12763__$1;
(statearr_12765_12793[(2)] = inst_12759);

(statearr_12765_12793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12764 === (1))){
var inst_12726 = (new Array(n));
var inst_12727 = inst_12726;
var inst_12728 = (0);
var state_12763__$1 = (function (){var statearr_12766 = state_12763;
(statearr_12766[(7)] = inst_12728);

(statearr_12766[(8)] = inst_12727);

return statearr_12766;
})();
var statearr_12767_12794 = state_12763__$1;
(statearr_12767_12794[(2)] = null);

(statearr_12767_12794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12764 === (4))){
var inst_12731 = (state_12763[(9)]);
var inst_12731__$1 = (state_12763[(2)]);
var inst_12732 = (inst_12731__$1 == null);
var inst_12733 = cljs.core.not.call(null,inst_12732);
var state_12763__$1 = (function (){var statearr_12768 = state_12763;
(statearr_12768[(9)] = inst_12731__$1);

return statearr_12768;
})();
if(inst_12733){
var statearr_12769_12795 = state_12763__$1;
(statearr_12769_12795[(1)] = (5));

} else {
var statearr_12770_12796 = state_12763__$1;
(statearr_12770_12796[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12764 === (15))){
var inst_12753 = (state_12763[(2)]);
var state_12763__$1 = state_12763;
var statearr_12771_12797 = state_12763__$1;
(statearr_12771_12797[(2)] = inst_12753);

(statearr_12771_12797[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12764 === (13))){
var state_12763__$1 = state_12763;
var statearr_12772_12798 = state_12763__$1;
(statearr_12772_12798[(2)] = null);

(statearr_12772_12798[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12764 === (6))){
var inst_12728 = (state_12763[(7)]);
var inst_12749 = (inst_12728 > (0));
var state_12763__$1 = state_12763;
if(cljs.core.truth_(inst_12749)){
var statearr_12773_12799 = state_12763__$1;
(statearr_12773_12799[(1)] = (12));

} else {
var statearr_12774_12800 = state_12763__$1;
(statearr_12774_12800[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12764 === (3))){
var inst_12761 = (state_12763[(2)]);
var state_12763__$1 = state_12763;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12763__$1,inst_12761);
} else {
if((state_val_12764 === (12))){
var inst_12727 = (state_12763[(8)]);
var inst_12751 = cljs.core.vec.call(null,inst_12727);
var state_12763__$1 = state_12763;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12763__$1,(15),out,inst_12751);
} else {
if((state_val_12764 === (2))){
var state_12763__$1 = state_12763;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12763__$1,(4),ch);
} else {
if((state_val_12764 === (11))){
var inst_12743 = (state_12763[(2)]);
var inst_12744 = (new Array(n));
var inst_12727 = inst_12744;
var inst_12728 = (0);
var state_12763__$1 = (function (){var statearr_12775 = state_12763;
(statearr_12775[(7)] = inst_12728);

(statearr_12775[(10)] = inst_12743);

(statearr_12775[(8)] = inst_12727);

return statearr_12775;
})();
var statearr_12776_12801 = state_12763__$1;
(statearr_12776_12801[(2)] = null);

(statearr_12776_12801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12764 === (9))){
var inst_12727 = (state_12763[(8)]);
var inst_12741 = cljs.core.vec.call(null,inst_12727);
var state_12763__$1 = state_12763;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12763__$1,(11),out,inst_12741);
} else {
if((state_val_12764 === (5))){
var inst_12736 = (state_12763[(11)]);
var inst_12728 = (state_12763[(7)]);
var inst_12731 = (state_12763[(9)]);
var inst_12727 = (state_12763[(8)]);
var inst_12735 = (inst_12727[inst_12728] = inst_12731);
var inst_12736__$1 = (inst_12728 + (1));
var inst_12737 = (inst_12736__$1 < n);
var state_12763__$1 = (function (){var statearr_12777 = state_12763;
(statearr_12777[(12)] = inst_12735);

(statearr_12777[(11)] = inst_12736__$1);

return statearr_12777;
})();
if(cljs.core.truth_(inst_12737)){
var statearr_12778_12802 = state_12763__$1;
(statearr_12778_12802[(1)] = (8));

} else {
var statearr_12779_12803 = state_12763__$1;
(statearr_12779_12803[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12764 === (14))){
var inst_12756 = (state_12763[(2)]);
var inst_12757 = cljs.core.async.close_BANG_.call(null,out);
var state_12763__$1 = (function (){var statearr_12781 = state_12763;
(statearr_12781[(13)] = inst_12756);

return statearr_12781;
})();
var statearr_12782_12804 = state_12763__$1;
(statearr_12782_12804[(2)] = inst_12757);

(statearr_12782_12804[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12764 === (10))){
var inst_12747 = (state_12763[(2)]);
var state_12763__$1 = state_12763;
var statearr_12783_12805 = state_12763__$1;
(statearr_12783_12805[(2)] = inst_12747);

(statearr_12783_12805[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12764 === (8))){
var inst_12736 = (state_12763[(11)]);
var inst_12727 = (state_12763[(8)]);
var tmp12780 = inst_12727;
var inst_12727__$1 = tmp12780;
var inst_12728 = inst_12736;
var state_12763__$1 = (function (){var statearr_12784 = state_12763;
(statearr_12784[(7)] = inst_12728);

(statearr_12784[(8)] = inst_12727__$1);

return statearr_12784;
})();
var statearr_12785_12806 = state_12763__$1;
(statearr_12785_12806[(2)] = null);

(statearr_12785_12806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10908__auto__ = null;
var cljs$core$async$state_machine__10908__auto____0 = (function (){
var statearr_12786 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12786[(0)] = cljs$core$async$state_machine__10908__auto__);

(statearr_12786[(1)] = (1));

return statearr_12786;
});
var cljs$core$async$state_machine__10908__auto____1 = (function (state_12763){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_12763);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e12787){var ex__10911__auto__ = e12787;
var statearr_12788_12807 = state_12763;
(statearr_12788_12807[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_12763[(4)]))){
var statearr_12789_12808 = state_12763;
(statearr_12789_12808[(1)] = cljs.core.first.call(null,(state_12763[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12809 = state_12763;
state_12763 = G__12809;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$state_machine__10908__auto__ = function(state_12763){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10908__auto____1.call(this,state_12763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10908__auto____0;
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10908__auto____1;
return cljs$core$async$state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_12790 = f__10982__auto__.call(null);
(statearr_12790[(6)] = c__10981__auto___12792);

return statearr_12790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__12811 = arguments.length;
switch (G__12811) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10981__auto___12889 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10982__auto__ = (function (){var switch__10907__auto__ = (function (state_12856){
var state_val_12857 = (state_12856[(1)]);
if((state_val_12857 === (7))){
var inst_12852 = (state_12856[(2)]);
var state_12856__$1 = state_12856;
var statearr_12858_12890 = state_12856__$1;
(statearr_12858_12890[(2)] = inst_12852);

(statearr_12858_12890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12857 === (1))){
var inst_12812 = [];
var inst_12813 = inst_12812;
var inst_12814 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_12856__$1 = (function (){var statearr_12859 = state_12856;
(statearr_12859[(7)] = inst_12813);

(statearr_12859[(8)] = inst_12814);

return statearr_12859;
})();
var statearr_12860_12891 = state_12856__$1;
(statearr_12860_12891[(2)] = null);

(statearr_12860_12891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12857 === (4))){
var inst_12817 = (state_12856[(9)]);
var inst_12817__$1 = (state_12856[(2)]);
var inst_12818 = (inst_12817__$1 == null);
var inst_12819 = cljs.core.not.call(null,inst_12818);
var state_12856__$1 = (function (){var statearr_12861 = state_12856;
(statearr_12861[(9)] = inst_12817__$1);

return statearr_12861;
})();
if(inst_12819){
var statearr_12862_12892 = state_12856__$1;
(statearr_12862_12892[(1)] = (5));

} else {
var statearr_12863_12893 = state_12856__$1;
(statearr_12863_12893[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12857 === (15))){
var inst_12813 = (state_12856[(7)]);
var inst_12844 = cljs.core.vec.call(null,inst_12813);
var state_12856__$1 = state_12856;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12856__$1,(18),out,inst_12844);
} else {
if((state_val_12857 === (13))){
var inst_12839 = (state_12856[(2)]);
var state_12856__$1 = state_12856;
var statearr_12864_12894 = state_12856__$1;
(statearr_12864_12894[(2)] = inst_12839);

(statearr_12864_12894[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12857 === (6))){
var inst_12813 = (state_12856[(7)]);
var inst_12841 = inst_12813.length;
var inst_12842 = (inst_12841 > (0));
var state_12856__$1 = state_12856;
if(cljs.core.truth_(inst_12842)){
var statearr_12865_12895 = state_12856__$1;
(statearr_12865_12895[(1)] = (15));

} else {
var statearr_12866_12896 = state_12856__$1;
(statearr_12866_12896[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12857 === (17))){
var inst_12849 = (state_12856[(2)]);
var inst_12850 = cljs.core.async.close_BANG_.call(null,out);
var state_12856__$1 = (function (){var statearr_12867 = state_12856;
(statearr_12867[(10)] = inst_12849);

return statearr_12867;
})();
var statearr_12868_12897 = state_12856__$1;
(statearr_12868_12897[(2)] = inst_12850);

(statearr_12868_12897[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12857 === (3))){
var inst_12854 = (state_12856[(2)]);
var state_12856__$1 = state_12856;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12856__$1,inst_12854);
} else {
if((state_val_12857 === (12))){
var inst_12813 = (state_12856[(7)]);
var inst_12832 = cljs.core.vec.call(null,inst_12813);
var state_12856__$1 = state_12856;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12856__$1,(14),out,inst_12832);
} else {
if((state_val_12857 === (2))){
var state_12856__$1 = state_12856;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12856__$1,(4),ch);
} else {
if((state_val_12857 === (11))){
var inst_12813 = (state_12856[(7)]);
var inst_12821 = (state_12856[(11)]);
var inst_12817 = (state_12856[(9)]);
var inst_12829 = inst_12813.push(inst_12817);
var tmp12869 = inst_12813;
var inst_12813__$1 = tmp12869;
var inst_12814 = inst_12821;
var state_12856__$1 = (function (){var statearr_12870 = state_12856;
(statearr_12870[(7)] = inst_12813__$1);

(statearr_12870[(12)] = inst_12829);

(statearr_12870[(8)] = inst_12814);

return statearr_12870;
})();
var statearr_12871_12898 = state_12856__$1;
(statearr_12871_12898[(2)] = null);

(statearr_12871_12898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12857 === (9))){
var inst_12814 = (state_12856[(8)]);
var inst_12825 = cljs.core.keyword_identical_QMARK_.call(null,inst_12814,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_12856__$1 = state_12856;
var statearr_12872_12899 = state_12856__$1;
(statearr_12872_12899[(2)] = inst_12825);

(statearr_12872_12899[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12857 === (5))){
var inst_12821 = (state_12856[(11)]);
var inst_12817 = (state_12856[(9)]);
var inst_12814 = (state_12856[(8)]);
var inst_12822 = (state_12856[(13)]);
var inst_12821__$1 = f.call(null,inst_12817);
var inst_12822__$1 = cljs.core._EQ_.call(null,inst_12821__$1,inst_12814);
var state_12856__$1 = (function (){var statearr_12873 = state_12856;
(statearr_12873[(11)] = inst_12821__$1);

(statearr_12873[(13)] = inst_12822__$1);

return statearr_12873;
})();
if(inst_12822__$1){
var statearr_12874_12900 = state_12856__$1;
(statearr_12874_12900[(1)] = (8));

} else {
var statearr_12875_12901 = state_12856__$1;
(statearr_12875_12901[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12857 === (14))){
var inst_12821 = (state_12856[(11)]);
var inst_12817 = (state_12856[(9)]);
var inst_12834 = (state_12856[(2)]);
var inst_12835 = [];
var inst_12836 = inst_12835.push(inst_12817);
var inst_12813 = inst_12835;
var inst_12814 = inst_12821;
var state_12856__$1 = (function (){var statearr_12876 = state_12856;
(statearr_12876[(14)] = inst_12836);

(statearr_12876[(15)] = inst_12834);

(statearr_12876[(7)] = inst_12813);

(statearr_12876[(8)] = inst_12814);

return statearr_12876;
})();
var statearr_12877_12902 = state_12856__$1;
(statearr_12877_12902[(2)] = null);

(statearr_12877_12902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12857 === (16))){
var state_12856__$1 = state_12856;
var statearr_12878_12903 = state_12856__$1;
(statearr_12878_12903[(2)] = null);

(statearr_12878_12903[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12857 === (10))){
var inst_12827 = (state_12856[(2)]);
var state_12856__$1 = state_12856;
if(cljs.core.truth_(inst_12827)){
var statearr_12879_12904 = state_12856__$1;
(statearr_12879_12904[(1)] = (11));

} else {
var statearr_12880_12905 = state_12856__$1;
(statearr_12880_12905[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12857 === (18))){
var inst_12846 = (state_12856[(2)]);
var state_12856__$1 = state_12856;
var statearr_12881_12906 = state_12856__$1;
(statearr_12881_12906[(2)] = inst_12846);

(statearr_12881_12906[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12857 === (8))){
var inst_12822 = (state_12856[(13)]);
var state_12856__$1 = state_12856;
var statearr_12882_12907 = state_12856__$1;
(statearr_12882_12907[(2)] = inst_12822);

(statearr_12882_12907[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10908__auto__ = null;
var cljs$core$async$state_machine__10908__auto____0 = (function (){
var statearr_12883 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12883[(0)] = cljs$core$async$state_machine__10908__auto__);

(statearr_12883[(1)] = (1));

return statearr_12883;
});
var cljs$core$async$state_machine__10908__auto____1 = (function (state_12856){
while(true){
var ret_value__10909__auto__ = (function (){try{while(true){
var result__10910__auto__ = switch__10907__auto__.call(null,state_12856);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10910__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10910__auto__;
}
break;
}
}catch (e12884){var ex__10911__auto__ = e12884;
var statearr_12885_12908 = state_12856;
(statearr_12885_12908[(2)] = ex__10911__auto__);


if(cljs.core.seq.call(null,(state_12856[(4)]))){
var statearr_12886_12909 = state_12856;
(statearr_12886_12909[(1)] = cljs.core.first.call(null,(state_12856[(4)])));

} else {
throw ex__10911__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10909__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12910 = state_12856;
state_12856 = G__12910;
continue;
} else {
return ret_value__10909__auto__;
}
break;
}
});
cljs$core$async$state_machine__10908__auto__ = function(state_12856){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10908__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10908__auto____1.call(this,state_12856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10908__auto____0;
cljs$core$async$state_machine__10908__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10908__auto____1;
return cljs$core$async$state_machine__10908__auto__;
})()
})();
var state__10983__auto__ = (function (){var statearr_12887 = f__10982__auto__.call(null);
(statearr_12887[(6)] = c__10981__auto___12889);

return statearr_12887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10983__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

