// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__68663 = arguments.length;
switch (G__68663) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2749__auto___68811 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68750){
var state_val_68751 = (state_68750[(1)]);
if((state_val_68751 === (7))){
var inst_68681 = (state_68750[(7)]);
var inst_68684 = cljs.core.not_EQ_.call(null,(0),inst_68681);
var state_68750__$1 = state_68750;
var statearr_68752_68812 = state_68750__$1;
(statearr_68752_68812[(2)] = inst_68684);

(statearr_68752_68812[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (20))){
var inst_68705 = (state_68750[(8)]);
var inst_68676 = (state_68750[(9)]);
var inst_68709 = fluree.db.auth.roles.call(null,inst_68676,inst_68705);
var state_68750__$1 = state_68750;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68750__$1,(23),inst_68709);
} else {
if((state_val_68751 === (27))){
var inst_68676 = (state_68750[(9)]);
var inst_68724 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_68725 = fluree.db.time_travel.as_of_block.call(null,inst_68676,inst_68724);
var state_68750__$1 = state_68750;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68750__$1,(30),inst_68725);
} else {
if((state_val_68751 === (1))){
var state_68750__$1 = state_68750;
var statearr_68753_68813 = state_68750__$1;
(statearr_68753_68813[(2)] = null);

(statearr_68753_68813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (24))){
var inst_68676 = (state_68750[(9)]);
var inst_68717 = (state_68750[(10)]);
var inst_68719 = fluree.db.permissions.permission_map.call(null,inst_68676,inst_68717,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_68750__$1 = state_68750;
var statearr_68754_68814 = state_68750__$1;
(statearr_68754_68814[(2)] = inst_68719);

(statearr_68754_68814[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (4))){
var inst_68664 = (state_68750[(2)]);
var inst_68665 = cljs.core.async.put_BANG_.call(null,pc,inst_68664);
var inst_68666 = cljs.core.async.close_BANG_.call(null,pc);
var state_68750__$1 = (function (){var statearr_68755 = state_68750;
(statearr_68755[(11)] = inst_68665);

return statearr_68755;
})();
var statearr_68756_68815 = state_68750__$1;
(statearr_68756_68815[(2)] = inst_68666);

(statearr_68756_68815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (15))){
var inst_68681 = (state_68750[(7)]);
var inst_68695 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68681)," unknown."].join('');
var inst_68696 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68697 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_68698 = cljs.core.PersistentHashMap.fromArrays(inst_68696,inst_68697);
var inst_68699 = cljs.core.ex_info.call(null,inst_68695,inst_68698);
var inst_68700 = (function(){throw inst_68699})();
var state_68750__$1 = state_68750;
var statearr_68757_68816 = state_68750__$1;
(statearr_68757_68816[(2)] = inst_68700);

(statearr_68757_68816[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (21))){
var state_68750__$1 = state_68750;
var statearr_68758_68817 = state_68750__$1;
(statearr_68758_68817[(2)] = null);

(statearr_68758_68817[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (31))){
var inst_68731 = (state_68750[(12)]);
var inst_68681 = (state_68750[(7)]);
var inst_68733 = cljs.core.assoc.call(null,inst_68731,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_68681);
var state_68750__$1 = state_68750;
var statearr_68759_68818 = state_68750__$1;
(statearr_68759_68818[(2)] = inst_68733);

(statearr_68759_68818[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (32))){
var inst_68731 = (state_68750[(12)]);
var state_68750__$1 = state_68750;
var statearr_68760_68819 = state_68750__$1;
(statearr_68760_68819[(2)] = inst_68731);

(statearr_68760_68819[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (33))){
var inst_68717 = (state_68750[(10)]);
var inst_68736 = (state_68750[(2)]);
var state_68750__$1 = (function (){var statearr_68761 = state_68750;
(statearr_68761[(13)] = inst_68736);

return statearr_68761;
})();
if(cljs.core.truth_(inst_68717)){
var statearr_68762_68820 = state_68750__$1;
(statearr_68762_68820[(1)] = (34));

} else {
var statearr_68763_68821 = state_68750__$1;
(statearr_68763_68821[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (13))){
var inst_68692 = (state_68750[(14)]);
var inst_68691 = (state_68750[(2)]);
var inst_68692__$1 = fluree.db.util.async.throw_err.call(null,inst_68691);
var state_68750__$1 = (function (){var statearr_68764 = state_68750;
(statearr_68764[(14)] = inst_68692__$1);

return statearr_68764;
})();
if(cljs.core.truth_(inst_68692__$1)){
var statearr_68765_68822 = state_68750__$1;
(statearr_68765_68822[(1)] = (14));

} else {
var statearr_68766_68823 = state_68750__$1;
(statearr_68766_68823[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (22))){
var inst_68715 = (state_68750[(2)]);
var state_68750__$1 = state_68750;
var statearr_68767_68824 = state_68750__$1;
(statearr_68767_68824[(2)] = inst_68715);

(statearr_68767_68824[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (36))){
var inst_68744 = (state_68750[(2)]);
var inst_68745 = cljs.core.async.put_BANG_.call(null,pc,inst_68744);
var _ = (function (){var statearr_68768 = state_68750;
(statearr_68768[(4)] = cljs.core.rest.call(null,(state_68750[(4)])));

return statearr_68768;
})();
var state_68750__$1 = state_68750;
var statearr_68769_68825 = state_68750__$1;
(statearr_68769_68825[(2)] = inst_68745);

(statearr_68769_68825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (29))){
var inst_68681 = (state_68750[(7)]);
var inst_68731 = (state_68750[(2)]);
var state_68750__$1 = (function (){var statearr_68770 = state_68750;
(statearr_68770[(12)] = inst_68731);

return statearr_68770;
})();
if(cljs.core.truth_(inst_68681)){
var statearr_68771_68826 = state_68750__$1;
(statearr_68771_68826[(1)] = (31));

} else {
var statearr_68772_68827 = state_68750__$1;
(statearr_68772_68827[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (6))){
var inst_68681 = (state_68750[(7)]);
var inst_68675 = (state_68750[(2)]);
var inst_68676 = fluree.db.util.async.throw_err.call(null,inst_68675);
var inst_68677 = opts;
var inst_68678 = cljs.core.__destructure_map.call(null,inst_68677);
var inst_68679 = cljs.core.get.call(null,inst_68678,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_68680 = cljs.core.get.call(null,inst_68678,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_68681__$1 = cljs.core.get.call(null,inst_68678,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_68682 = cljs.core.get.call(null,inst_68678,new cljs.core.Keyword(null,"block","block",664686210));
var state_68750__$1 = (function (){var statearr_68773 = state_68750;
(statearr_68773[(15)] = inst_68680);

(statearr_68773[(16)] = inst_68679);

(statearr_68773[(7)] = inst_68681__$1);

(statearr_68773[(17)] = inst_68682);

(statearr_68773[(9)] = inst_68676);

return statearr_68773;
})();
if(cljs.core.truth_(inst_68681__$1)){
var statearr_68774_68828 = state_68750__$1;
(statearr_68774_68828[(1)] = (7));

} else {
var statearr_68775_68829 = state_68750__$1;
(statearr_68775_68829[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (28))){
var inst_68676 = (state_68750[(9)]);
var state_68750__$1 = state_68750;
var statearr_68776_68830 = state_68750__$1;
(statearr_68776_68830[(2)] = inst_68676);

(statearr_68776_68830[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (25))){
var state_68750__$1 = state_68750;
var statearr_68777_68831 = state_68750__$1;
(statearr_68777_68831[(2)] = null);

(statearr_68777_68831[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (34))){
var inst_68722 = (state_68750[(18)]);
var state_68750__$1 = state_68750;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68750__$1,(37),inst_68722);
} else {
if((state_val_68751 === (17))){
var inst_68679 = (state_68750[(16)]);
var state_68750__$1 = state_68750;
var statearr_68778_68832 = state_68750__$1;
(statearr_68778_68832[(2)] = inst_68679);

(statearr_68778_68832[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (3))){
var inst_68748 = (state_68750[(2)]);
var state_68750__$1 = state_68750;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68750__$1,inst_68748);
} else {
if((state_val_68751 === (12))){
var inst_68679 = (state_68750[(16)]);
var inst_68705 = (state_68750[(2)]);
var state_68750__$1 = (function (){var statearr_68779 = state_68750;
(statearr_68779[(8)] = inst_68705);

return statearr_68779;
})();
if(cljs.core.truth_(inst_68679)){
var statearr_68780_68833 = state_68750__$1;
(statearr_68780_68833[(1)] = (17));

} else {
var statearr_68781_68834 = state_68750__$1;
(statearr_68781_68834[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (2))){
var _ = (function (){var statearr_68782 = state_68750;
(statearr_68782[(4)] = cljs.core.cons.call(null,(5),(state_68750[(4)])));

return statearr_68782;
})();
var inst_68673 = fluree.db.session.db.call(null,conn,ledger,null);
var state_68750__$1 = state_68750;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68750__$1,(6),inst_68673);
} else {
if((state_val_68751 === (23))){
var inst_68711 = (state_68750[(2)]);
var inst_68712 = fluree.db.util.async.throw_err.call(null,inst_68711);
var state_68750__$1 = state_68750;
var statearr_68783_68835 = state_68750__$1;
(statearr_68783_68835[(2)] = inst_68712);

(statearr_68783_68835[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (35))){
var inst_68736 = (state_68750[(13)]);
var state_68750__$1 = state_68750;
var statearr_68784_68836 = state_68750__$1;
(statearr_68784_68836[(2)] = inst_68736);

(statearr_68784_68836[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (19))){
var inst_68717 = (state_68750[(10)]);
var inst_68717__$1 = (state_68750[(2)]);
var state_68750__$1 = (function (){var statearr_68785 = state_68750;
(statearr_68785[(10)] = inst_68717__$1);

return statearr_68785;
})();
if(cljs.core.truth_(inst_68717__$1)){
var statearr_68786_68837 = state_68750__$1;
(statearr_68786_68837[(1)] = (24));

} else {
var statearr_68787_68838 = state_68750__$1;
(statearr_68787_68838[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (11))){
var state_68750__$1 = state_68750;
var statearr_68789_68839 = state_68750__$1;
(statearr_68789_68839[(2)] = null);

(statearr_68789_68839[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (9))){
var inst_68687 = (state_68750[(2)]);
var state_68750__$1 = state_68750;
if(cljs.core.truth_(inst_68687)){
var statearr_68790_68840 = state_68750__$1;
(statearr_68790_68840[(1)] = (10));

} else {
var statearr_68791_68841 = state_68750__$1;
(statearr_68791_68841[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (5))){
var _ = (function (){var statearr_68792 = state_68750;
(statearr_68792[(4)] = cljs.core.rest.call(null,(state_68750[(4)])));

return statearr_68792;
})();
var state_68750__$1 = state_68750;
var ex68788 = (state_68750__$1[(2)]);
var statearr_68793_68842 = state_68750__$1;
(statearr_68793_68842[(5)] = ex68788);


var statearr_68794_68843 = state_68750__$1;
(statearr_68794_68843[(1)] = (4));

(statearr_68794_68843[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (14))){
var inst_68692 = (state_68750[(14)]);
var state_68750__$1 = state_68750;
var statearr_68795_68844 = state_68750__$1;
(statearr_68795_68844[(2)] = inst_68692);

(statearr_68795_68844[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (26))){
var inst_68682 = (state_68750[(17)]);
var inst_68722 = (state_68750[(2)]);
var state_68750__$1 = (function (){var statearr_68796 = state_68750;
(statearr_68796[(18)] = inst_68722);

return statearr_68796;
})();
if(cljs.core.truth_(inst_68682)){
var statearr_68797_68845 = state_68750__$1;
(statearr_68797_68845[(1)] = (27));

} else {
var statearr_68798_68846 = state_68750__$1;
(statearr_68798_68846[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (16))){
var inst_68702 = (state_68750[(2)]);
var state_68750__$1 = state_68750;
var statearr_68799_68847 = state_68750__$1;
(statearr_68799_68847[(2)] = inst_68702);

(statearr_68799_68847[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (30))){
var inst_68727 = (state_68750[(2)]);
var inst_68728 = fluree.db.util.async.throw_err.call(null,inst_68727);
var state_68750__$1 = state_68750;
var statearr_68800_68848 = state_68750__$1;
(statearr_68800_68848[(2)] = inst_68728);

(statearr_68800_68848[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (10))){
var inst_68681 = (state_68750[(7)]);
var inst_68676 = (state_68750[(9)]);
var inst_68689 = fluree.db.dbproto._subid.call(null,inst_68676,inst_68681);
var state_68750__$1 = state_68750;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68750__$1,(13),inst_68689);
} else {
if((state_val_68751 === (18))){
var inst_68705 = (state_68750[(8)]);
var state_68750__$1 = state_68750;
if(cljs.core.truth_(inst_68705)){
var statearr_68801_68849 = state_68750__$1;
(statearr_68801_68849[(1)] = (20));

} else {
var statearr_68802_68850 = state_68750__$1;
(statearr_68802_68850[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (37))){
var inst_68736 = (state_68750[(13)]);
var inst_68739 = (state_68750[(2)]);
var inst_68740 = fluree.db.util.async.throw_err.call(null,inst_68739);
var inst_68741 = cljs.core.assoc.call(null,inst_68736,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_68740);
var state_68750__$1 = state_68750;
var statearr_68803_68851 = state_68750__$1;
(statearr_68803_68851[(2)] = inst_68741);

(statearr_68803_68851[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68751 === (8))){
var inst_68681 = (state_68750[(7)]);
var state_68750__$1 = state_68750;
var statearr_68804_68852 = state_68750__$1;
(statearr_68804_68852[(2)] = inst_68681);

(statearr_68804_68852[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2727__auto__ = null;
var fluree$db$api$query$state_machine__2727__auto____0 = (function (){
var statearr_68805 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68805[(0)] = fluree$db$api$query$state_machine__2727__auto__);

(statearr_68805[(1)] = (1));

return statearr_68805;
});
var fluree$db$api$query$state_machine__2727__auto____1 = (function (state_68750){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_68750);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68806){var ex__2730__auto__ = e68806;
var statearr_68807_68853 = state_68750;
(statearr_68807_68853[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_68750[(4)]))){
var statearr_68808_68854 = state_68750;
(statearr_68808_68854[(1)] = cljs.core.first.call(null,(state_68750[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68855 = state_68750;
state_68750 = G__68855;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2727__auto__ = function(state_68750){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2727__auto____1.call(this,state_68750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2727__auto____0;
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2727__auto____1;
return fluree$db$api$query$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68809 = f__2750__auto__.call(null);
(statearr_68809[(6)] = c__2749__auto___68811);

return statearr_68809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68996){
var state_val_68997 = (state_68996[(1)]);
if((state_val_68997 === (7))){
var inst_68876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68877 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_68878 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_68879 = [inst_68877,inst_68878];
var inst_68880 = (new cljs.core.PersistentVector(null,2,(5),inst_68876,inst_68879,null));
var state_68996__$1 = state_68996;
var statearr_68998_69068 = state_68996__$1;
(statearr_68998_69068[(2)] = inst_68880);

(statearr_68998_69068[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (20))){
var inst_68906 = (state_68996[(7)]);
var state_68996__$1 = state_68996;
var statearr_68999_69069 = state_68996__$1;
(statearr_68999_69069[(2)] = inst_68906);

(statearr_68999_69069[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (27))){
var state_68996__$1 = state_68996;
var statearr_69000_69070 = state_68996__$1;
(statearr_69000_69070[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (1))){
var state_68996__$1 = state_68996;
var statearr_69002_69071 = state_68996__$1;
(statearr_69002_69071[(2)] = null);

(statearr_69002_69071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (24))){
var inst_68905 = (state_68996[(8)]);
var state_68996__$1 = state_68996;
if(cljs.core.truth_(inst_68905)){
var statearr_69003_69072 = state_68996__$1;
(statearr_69003_69072[(1)] = (26));

} else {
var statearr_69004_69073 = state_68996__$1;
(statearr_69004_69073[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (39))){
var inst_68951 = (state_68996[(9)]);
var inst_68952 = (state_68996[(10)]);
var inst_68977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68978 = [inst_68951,inst_68952];
var inst_68979 = (new cljs.core.PersistentVector(null,2,(5),inst_68977,inst_68978,null));
var state_68996__$1 = state_68996;
var statearr_69005_69074 = state_68996__$1;
(statearr_69005_69074[(2)] = inst_68979);

(statearr_69005_69074[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (4))){
var inst_68856 = (state_68996[(2)]);
var state_68996__$1 = state_68996;
var statearr_69006_69075 = state_68996__$1;
(statearr_69006_69075[(2)] = inst_68856);

(statearr_69006_69075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (15))){
var inst_68890 = (state_68996[(11)]);
var inst_68885 = (state_68996[(12)]);
var inst_68899 = (state_68996[(2)]);
var inst_68900 = [inst_68890,inst_68899];
var inst_68901 = (new cljs.core.PersistentVector(null,2,(5),inst_68885,inst_68900,null));
var state_68996__$1 = state_68996;
var statearr_69007_69076 = state_68996__$1;
(statearr_69007_69076[(2)] = inst_68901);

(statearr_69007_69076[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (21))){
var inst_68905 = (state_68996[(8)]);
var state_68996__$1 = state_68996;
var statearr_69008_69077 = state_68996__$1;
(statearr_69008_69077[(2)] = inst_68905);

(statearr_69008_69077[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (31))){
var inst_68946 = (state_68996[(2)]);
var state_68996__$1 = state_68996;
var statearr_69009_69078 = state_68996__$1;
(statearr_69009_69078[(2)] = inst_68946);

(statearr_69009_69078[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (32))){
var inst_68952 = (state_68996[(10)]);
var inst_68955 = cljs.core.pos_int_QMARK_.call(null,inst_68952);
var state_68996__$1 = state_68996;
var statearr_69010_69079 = state_68996__$1;
(statearr_69010_69079[(2)] = inst_68955);

(statearr_69010_69079[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (40))){
var inst_68983 = (state_68996[(13)]);
var inst_68907 = (state_68996[(14)]);
var inst_68981 = (state_68996[(2)]);
var inst_68982 = cljs.core.nth.call(null,inst_68981,(0),null);
var inst_68983__$1 = cljs.core.nth.call(null,inst_68981,(1),null);
var inst_68984 = (inst_68983__$1 > inst_68907);
var state_68996__$1 = (function (){var statearr_69011 = state_68996;
(statearr_69011[(13)] = inst_68983__$1);

(statearr_69011[(15)] = inst_68982);

return statearr_69011;
})();
if(cljs.core.truth_(inst_68984)){
var statearr_69012_69080 = state_68996__$1;
(statearr_69012_69080[(1)] = (41));

} else {
var statearr_69013_69081 = state_68996__$1;
(statearr_69013_69081[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (33))){
var inst_68953 = (state_68996[(16)]);
var state_68996__$1 = state_68996;
var statearr_69014_69082 = state_68996__$1;
(statearr_69014_69082[(2)] = inst_68953);

(statearr_69014_69082[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (13))){
var inst_68891 = (state_68996[(17)]);
var inst_68893 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_68891);
var state_68996__$1 = state_68996;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68996__$1,(16),inst_68893);
} else {
if((state_val_68997 === (22))){
var inst_68924 = (state_68996[(2)]);
var state_68996__$1 = state_68996;
if(cljs.core.truth_(inst_68924)){
var statearr_69015_69083 = state_68996__$1;
(statearr_69015_69083[(1)] = (23));

} else {
var statearr_69016_69084 = state_68996__$1;
(statearr_69016_69084[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (36))){
var state_68996__$1 = state_68996;
var statearr_69017_69085 = state_68996__$1;
(statearr_69017_69085[(2)] = null);

(statearr_69017_69085[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (41))){
var inst_68907 = (state_68996[(14)]);
var state_68996__$1 = state_68996;
var statearr_69018_69086 = state_68996__$1;
(statearr_69018_69086[(2)] = inst_68907);

(statearr_69018_69086[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (43))){
var inst_68982 = (state_68996[(15)]);
var inst_68988 = (state_68996[(2)]);
var inst_68989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68990 = [inst_68982,inst_68988];
var inst_68991 = (new cljs.core.PersistentVector(null,2,(5),inst_68989,inst_68990,null));
var _ = (function (){var statearr_69019 = state_68996;
(statearr_69019[(4)] = cljs.core.rest.call(null,(state_68996[(4)])));

return statearr_69019;
})();
var state_68996__$1 = state_68996;
var statearr_69020_69087 = state_68996__$1;
(statearr_69020_69087[(2)] = inst_68991);

(statearr_69020_69087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (29))){
var inst_68882 = (state_68996[(18)]);
var inst_68937 = cljs.core.pr_str.call(null,inst_68882);
var inst_68938 = ["Invalid block range provided: ",inst_68937].join('');
var inst_68939 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68940 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_68941 = cljs.core.PersistentHashMap.fromArrays(inst_68939,inst_68940);
var inst_68942 = cljs.core.ex_info.call(null,inst_68938,inst_68941);
var inst_68943 = (function(){throw inst_68942})();
var state_68996__$1 = state_68996;
var statearr_69021_69088 = state_68996__$1;
(statearr_69021_69088[(2)] = inst_68943);

(statearr_69021_69088[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (6))){
var inst_68874 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_68996__$1 = state_68996;
var statearr_69022_69089 = state_68996__$1;
(statearr_69022_69089[(2)] = inst_68874);

(statearr_69022_69089[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (28))){
var inst_68948 = (state_68996[(2)]);
var state_68996__$1 = state_68996;
var statearr_69023_69090 = state_68996__$1;
(statearr_69023_69090[(2)] = inst_68948);

(statearr_69023_69090[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (25))){
var inst_68951 = (state_68996[(9)]);
var inst_68953 = (state_68996[(16)]);
var inst_68950 = (state_68996[(2)]);
var inst_68951__$1 = cljs.core.nth.call(null,inst_68950,(0),null);
var inst_68952 = cljs.core.nth.call(null,inst_68950,(1),null);
var inst_68953__$1 = cljs.core.pos_int_QMARK_.call(null,inst_68951__$1);
var state_68996__$1 = (function (){var statearr_69024 = state_68996;
(statearr_69024[(9)] = inst_68951__$1);

(statearr_69024[(16)] = inst_68953__$1);

(statearr_69024[(10)] = inst_68952);

return statearr_69024;
})();
if(inst_68953__$1){
var statearr_69025_69091 = state_68996__$1;
(statearr_69025_69091[(1)] = (32));

} else {
var statearr_69026_69092 = state_68996__$1;
(statearr_69026_69092[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (34))){
var inst_68958 = (state_68996[(2)]);
var inst_68959 = cljs.core.not.call(null,inst_68958);
var state_68996__$1 = state_68996;
if(inst_68959){
var statearr_69027_69093 = state_68996__$1;
(statearr_69027_69093[(1)] = (35));

} else {
var statearr_69028_69094 = state_68996__$1;
(statearr_69028_69094[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (17))){
var inst_68907 = (state_68996[(14)]);
var inst_68905 = (state_68996[(8)]);
var inst_68910 = cljs.core.pr_str.call(null,inst_68905);
var inst_68911 = cljs.core.pr_str.call(null,inst_68907);
var inst_68912 = ["Start block is out of range for this ledger. Start block provided: ",inst_68910,". Database block: ",inst_68911].join('');
var inst_68913 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68914 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_68915 = cljs.core.PersistentHashMap.fromArrays(inst_68913,inst_68914);
var inst_68916 = cljs.core.ex_info.call(null,inst_68912,inst_68915);
var inst_68917 = (function(){throw inst_68916})();
var state_68996__$1 = state_68996;
var statearr_69029_69095 = state_68996__$1;
(statearr_69029_69095[(2)] = inst_68917);

(statearr_69029_69095[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (3))){
var inst_68994 = (state_68996[(2)]);
var state_68996__$1 = state_68996;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68996__$1,inst_68994);
} else {
if((state_val_68997 === (12))){
var inst_68882 = (state_68996[(18)]);
var inst_68891 = (state_68996[(17)]);
var inst_68889 = (state_68996[(2)]);
var inst_68890 = fluree.db.util.async.throw_err.call(null,inst_68889);
var inst_68891__$1 = cljs.core.second.call(null,inst_68882);
var state_68996__$1 = (function (){var statearr_69030 = state_68996;
(statearr_69030[(11)] = inst_68890);

(statearr_69030[(17)] = inst_68891__$1);

return statearr_69030;
})();
if(cljs.core.truth_(inst_68891__$1)){
var statearr_69031_69096 = state_68996__$1;
(statearr_69031_69096[(1)] = (13));

} else {
var statearr_69032_69097 = state_68996__$1;
(statearr_69032_69097[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (2))){
var _ = (function (){var statearr_69033 = state_68996;
(statearr_69033[(4)] = cljs.core.cons.call(null,(5),(state_68996[(4)])));

return statearr_69033;
})();
var inst_68871 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_68872 = cljs.core.sequential_QMARK_.call(null,inst_68871);
var state_68996__$1 = state_68996;
if(inst_68872){
var statearr_69034_69098 = state_68996__$1;
(statearr_69034_69098[(1)] = (6));

} else {
var statearr_69035_69099 = state_68996__$1;
(statearr_69035_69099[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (23))){
var inst_68905 = (state_68996[(8)]);
var inst_68906 = (state_68996[(7)]);
var inst_68926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68927 = [inst_68905,inst_68906];
var inst_68928 = (new cljs.core.PersistentVector(null,2,(5),inst_68926,inst_68927,null));
var state_68996__$1 = state_68996;
var statearr_69036_69100 = state_68996__$1;
(statearr_69036_69100[(2)] = inst_68928);

(statearr_69036_69100[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (35))){
var inst_68882 = (state_68996[(18)]);
var inst_68961 = cljs.core.pr_str.call(null,inst_68882);
var inst_68962 = ["Invalid block range provided: ",inst_68961].join('');
var inst_68963 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68964 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_68965 = cljs.core.PersistentHashMap.fromArrays(inst_68963,inst_68964);
var inst_68966 = cljs.core.ex_info.call(null,inst_68962,inst_68965);
var inst_68967 = (function(){throw inst_68966})();
var state_68996__$1 = state_68996;
var statearr_69037_69101 = state_68996__$1;
(statearr_69037_69101[(2)] = inst_68967);

(statearr_69037_69101[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (19))){
var inst_68905 = (state_68996[(8)]);
var inst_68920 = (state_68996[(2)]);
var state_68996__$1 = (function (){var statearr_69038 = state_68996;
(statearr_69038[(19)] = inst_68920);

return statearr_69038;
})();
if(cljs.core.truth_(inst_68905)){
var statearr_69039_69102 = state_68996__$1;
(statearr_69039_69102[(1)] = (20));

} else {
var statearr_69040_69103 = state_68996__$1;
(statearr_69040_69103[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (11))){
var inst_68907 = (state_68996[(14)]);
var inst_68905 = (state_68996[(8)]);
var inst_68904 = (state_68996[(2)]);
var inst_68905__$1 = cljs.core.nth.call(null,inst_68904,(0),null);
var inst_68906 = cljs.core.nth.call(null,inst_68904,(1),null);
var inst_68907__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_68908 = (inst_68905__$1 > inst_68907__$1);
var state_68996__$1 = (function (){var statearr_69042 = state_68996;
(statearr_69042[(14)] = inst_68907__$1);

(statearr_69042[(8)] = inst_68905__$1);

(statearr_69042[(7)] = inst_68906);

return statearr_69042;
})();
if(cljs.core.truth_(inst_68908)){
var statearr_69043_69104 = state_68996__$1;
(statearr_69043_69104[(1)] = (17));

} else {
var statearr_69044_69105 = state_68996__$1;
(statearr_69044_69105[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (9))){
var inst_68882 = (state_68996[(18)]);
var inst_68885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68886 = cljs.core.first.call(null,inst_68882);
var inst_68887 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_68886);
var state_68996__$1 = (function (){var statearr_69045 = state_68996;
(statearr_69045[(12)] = inst_68885);

return statearr_69045;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68996__$1,(12),inst_68887);
} else {
if((state_val_68997 === (5))){
var _ = (function (){var statearr_69046 = state_68996;
(statearr_69046[(4)] = cljs.core.rest.call(null,(state_68996[(4)])));

return statearr_69046;
})();
var state_68996__$1 = state_68996;
var ex69041 = (state_68996__$1[(2)]);
var statearr_69047_69106 = state_68996__$1;
(statearr_69047_69106[(5)] = ex69041);


if((ex69041 instanceof Error)){
var statearr_69048_69107 = state_68996__$1;
(statearr_69048_69107[(1)] = (4));

(statearr_69048_69107[(5)] = null);

} else {
throw ex69041;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (14))){
var state_68996__$1 = state_68996;
var statearr_69049_69108 = state_68996__$1;
(statearr_69049_69108[(2)] = null);

(statearr_69049_69108[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (26))){
var inst_68905 = (state_68996[(8)]);
var inst_68931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68932 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_68933 = [inst_68905,inst_68932];
var inst_68934 = (new cljs.core.PersistentVector(null,2,(5),inst_68931,inst_68933,null));
var state_68996__$1 = state_68996;
var statearr_69050_69109 = state_68996__$1;
(statearr_69050_69109[(2)] = inst_68934);

(statearr_69050_69109[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (16))){
var inst_68895 = (state_68996[(2)]);
var inst_68896 = fluree.db.util.async.throw_err.call(null,inst_68895);
var state_68996__$1 = state_68996;
var statearr_69051_69110 = state_68996__$1;
(statearr_69051_69110[(2)] = inst_68896);

(statearr_69051_69110[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (38))){
var inst_68951 = (state_68996[(9)]);
var inst_68952 = (state_68996[(10)]);
var inst_68973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68974 = [inst_68952,inst_68951];
var inst_68975 = (new cljs.core.PersistentVector(null,2,(5),inst_68973,inst_68974,null));
var state_68996__$1 = state_68996;
var statearr_69052_69111 = state_68996__$1;
(statearr_69052_69111[(2)] = inst_68975);

(statearr_69052_69111[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (30))){
var state_68996__$1 = state_68996;
var statearr_69053_69112 = state_68996__$1;
(statearr_69053_69112[(2)] = null);

(statearr_69053_69112[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (10))){
var inst_68882 = (state_68996[(18)]);
var state_68996__$1 = state_68996;
var statearr_69054_69113 = state_68996__$1;
(statearr_69054_69113[(2)] = inst_68882);

(statearr_69054_69113[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (18))){
var state_68996__$1 = state_68996;
var statearr_69055_69114 = state_68996__$1;
(statearr_69055_69114[(2)] = null);

(statearr_69055_69114[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (42))){
var inst_68983 = (state_68996[(13)]);
var state_68996__$1 = state_68996;
var statearr_69056_69115 = state_68996__$1;
(statearr_69056_69115[(2)] = inst_68983);

(statearr_69056_69115[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (37))){
var inst_68951 = (state_68996[(9)]);
var inst_68952 = (state_68996[(10)]);
var inst_68970 = (state_68996[(2)]);
var inst_68971 = (inst_68952 < inst_68951);
var state_68996__$1 = (function (){var statearr_69057 = state_68996;
(statearr_69057[(20)] = inst_68970);

return statearr_69057;
})();
if(cljs.core.truth_(inst_68971)){
var statearr_69058_69116 = state_68996__$1;
(statearr_69058_69116[(1)] = (38));

} else {
var statearr_69059_69117 = state_68996__$1;
(statearr_69059_69117[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68997 === (8))){
var inst_68882 = (state_68996[(18)]);
var inst_68882__$1 = (state_68996[(2)]);
var inst_68883 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_68882__$1);
var state_68996__$1 = (function (){var statearr_69060 = state_68996;
(statearr_69060[(18)] = inst_68882__$1);

return statearr_69060;
})();
if(cljs.core.truth_(inst_68883)){
var statearr_69061_69118 = state_68996__$1;
(statearr_69061_69118[(1)] = (9));

} else {
var statearr_69062_69119 = state_68996__$1;
(statearr_69062_69119[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_69063 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69063[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__);

(statearr_69063[(1)] = (1));

return statearr_69063;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_68996){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_68996);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69064){var ex__2730__auto__ = e69064;
var statearr_69065_69120 = state_68996;
(statearr_69065_69120[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_68996[(4)]))){
var statearr_69066_69121 = state_68996;
(statearr_69066_69121[(1)] = cljs.core.first.call(null,(state_68996[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69122 = state_68996;
state_68996 = G__69122;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = function(state_68996){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_68996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69067 = f__2750__auto__.call(null);
(statearr_69067[(6)] = c__2749__auto__);

return statearr_69067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69272){
var state_val_69273 = (state_69272[(1)]);
if((state_val_69273 === (7))){
var inst_69184 = (state_69272[(2)]);
var inst_69185 = cljs.core.nth.call(null,inst_69184,(0),null);
var inst_69186 = cljs.core.nth.call(null,inst_69184,(1),null);
var inst_69194 = cljs.core.vals.call(null,inst_69186);
var inst_69195 = cljs.core.seq.call(null,inst_69194);
var inst_69196 = cljs.core.first.call(null,inst_69195);
var inst_69197 = cljs.core.next.call(null,inst_69195);
var inst_69198 = cljs.core.PersistentVector.EMPTY;
var inst_69199 = inst_69194;
var inst_69200 = inst_69198;
var state_69272__$1 = (function (){var statearr_69274 = state_69272;
(statearr_69274[(7)] = inst_69200);

(statearr_69274[(8)] = inst_69196);

(statearr_69274[(9)] = inst_69197);

(statearr_69274[(10)] = inst_69199);

(statearr_69274[(11)] = inst_69185);

return statearr_69274;
})();
var statearr_69275_69328 = state_69272__$1;
(statearr_69275_69328[(2)] = null);

(statearr_69275_69328[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (20))){
var inst_69206 = (state_69272[(12)]);
var inst_69211 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_69212 = cljs.core.PersistentHashMap.EMPTY;
var inst_69213 = [true,inst_69212];
var inst_69214 = cljs.core.PersistentHashMap.fromArrays(inst_69211,inst_69213);
var inst_69215 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_69214,inst_69206);
var state_69272__$1 = state_69272;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69272__$1,(22),inst_69215);
} else {
if((state_val_69273 === (27))){
var inst_69260 = (state_69272[(2)]);
var state_69272__$1 = state_69272;
var statearr_69276_69329 = state_69272__$1;
(statearr_69276_69329[(2)] = inst_69260);

(statearr_69276_69329[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (1))){
var state_69272__$1 = state_69272;
var statearr_69277_69330 = state_69272__$1;
(statearr_69277_69330[(2)] = null);

(statearr_69277_69330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (24))){
var inst_69224 = (state_69272[(13)]);
var inst_69262 = (state_69272[(2)]);
var inst_69263 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_69264 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69265 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69266 = [inst_69264,inst_69265,inst_69224,inst_69262];
var inst_69267 = cljs.core.PersistentHashMap.fromArrays(inst_69263,inst_69266);
var _ = (function (){var statearr_69279 = state_69272;
(statearr_69279[(4)] = cljs.core.rest.call(null,(state_69272[(4)])));

return statearr_69279;
})();
var state_69272__$1 = state_69272;
var statearr_69280_69331 = state_69272__$1;
(statearr_69280_69331[(2)] = inst_69267);

(statearr_69280_69331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (4))){
var inst_69125 = (state_69272[(2)]);
var state_69272__$1 = state_69272;
var statearr_69281_69332 = state_69272__$1;
(statearr_69281_69332[(2)] = inst_69125);

(statearr_69281_69332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (15))){
var inst_69165 = (state_69272[(14)]);
var inst_69144 = (state_69272[(15)]);
var inst_69149 = (state_69272[(16)]);
var inst_69170 = (state_69272[(17)]);
var inst_69148 = (state_69272[(18)]);
var inst_69155 = (state_69272[(19)]);
var inst_69141 = (state_69272[(20)]);
var inst_69163 = (state_69272[(21)]);
var inst_69156 = (state_69272[(22)]);
var inst_69147 = (state_69272[(23)]);
var inst_69143 = (state_69272[(24)]);
var inst_69176 = (function (){var subject = inst_69163;
var flake = inst_69155;
var r = inst_69156;
var asserted_subjects = inst_69148;
var first__69140 = inst_69143;
var seq__69152 = inst_69156;
var flake_SINGLEQUOTE_ = inst_69170;
var retracted_subjects = inst_69149;
var first__69153 = inst_69155;
var G__69137 = inst_69147;
var asserted_QMARK_ = inst_69165;
var vec__69138 = inst_69141;
var vec__69151 = inst_69147;
var seq__69139 = inst_69144;
return (function (p1__69124_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__69124_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_69177 = cljs.core.update.call(null,inst_69149,inst_69163,inst_69176);
var tmp69278 = inst_69148;
var inst_69147__$1 = inst_69156;
var inst_69148__$1 = tmp69278;
var inst_69149__$1 = inst_69177;
var state_69272__$1 = (function (){var statearr_69282 = state_69272;
(statearr_69282[(16)] = inst_69149__$1);

(statearr_69282[(18)] = inst_69148__$1);

(statearr_69282[(23)] = inst_69147__$1);

return statearr_69282;
})();
var statearr_69283_69333 = state_69272__$1;
(statearr_69283_69333[(2)] = null);

(statearr_69283_69333[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (21))){
var inst_69222 = (state_69272[(2)]);
var state_69272__$1 = state_69272;
var statearr_69284_69334 = state_69272__$1;
(statearr_69284_69334[(2)] = inst_69222);

(statearr_69284_69334[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (13))){
var inst_69165 = (state_69272[(14)]);
var inst_69170 = (state_69272[(2)]);
var state_69272__$1 = (function (){var statearr_69285 = state_69272;
(statearr_69285[(17)] = inst_69170);

return statearr_69285;
})();
if(cljs.core.truth_(inst_69165)){
var statearr_69286_69335 = state_69272__$1;
(statearr_69286_69335[(1)] = (14));

} else {
var statearr_69287_69336 = state_69272__$1;
(statearr_69287_69336[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (22))){
var inst_69207 = (state_69272[(25)]);
var inst_69200 = (state_69272[(7)]);
var inst_69217 = (state_69272[(2)]);
var inst_69218 = fluree.db.util.async.throw_err.call(null,inst_69217);
var inst_69219 = cljs.core.conj.call(null,inst_69200,inst_69218);
var inst_69199 = inst_69207;
var inst_69200__$1 = inst_69219;
var state_69272__$1 = (function (){var statearr_69288 = state_69272;
(statearr_69288[(7)] = inst_69200__$1);

(statearr_69288[(10)] = inst_69199);

return statearr_69288;
})();
var statearr_69289_69337 = state_69272__$1;
(statearr_69289_69337[(2)] = null);

(statearr_69289_69337[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (6))){
var inst_69155 = (state_69272[(19)]);
var inst_69147 = (state_69272[(23)]);
var inst_69154 = cljs.core.seq.call(null,inst_69147);
var inst_69155__$1 = cljs.core.first.call(null,inst_69154);
var inst_69156 = cljs.core.next.call(null,inst_69154);
var inst_69157 = cljs.core.not.call(null,inst_69155__$1);
var state_69272__$1 = (function (){var statearr_69290 = state_69272;
(statearr_69290[(19)] = inst_69155__$1);

(statearr_69290[(22)] = inst_69156);

return statearr_69290;
})();
if(inst_69157){
var statearr_69291_69338 = state_69272__$1;
(statearr_69291_69338[(1)] = (8));

} else {
var statearr_69292_69339 = state_69272__$1;
(statearr_69292_69339[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (28))){
var inst_69238 = (state_69272[(26)]);
var inst_69245 = (state_69272[(27)]);
var inst_69255 = (state_69272[(2)]);
var inst_69256 = fluree.db.util.async.throw_err.call(null,inst_69255);
var inst_69257 = cljs.core.conj.call(null,inst_69238,inst_69256);
var inst_69237 = inst_69245;
var inst_69238__$1 = inst_69257;
var state_69272__$1 = (function (){var statearr_69293 = state_69272;
(statearr_69293[(26)] = inst_69238__$1);

(statearr_69293[(28)] = inst_69237);

return statearr_69293;
})();
var statearr_69294_69340 = state_69272__$1;
(statearr_69294_69340[(2)] = null);

(statearr_69294_69340[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (25))){
var inst_69238 = (state_69272[(26)]);
var state_69272__$1 = state_69272;
var statearr_69295_69341 = state_69272__$1;
(statearr_69295_69341[(2)] = inst_69238);

(statearr_69295_69341[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (17))){
var inst_69206 = (state_69272[(12)]);
var inst_69199 = (state_69272[(10)]);
var inst_69205 = cljs.core.seq.call(null,inst_69199);
var inst_69206__$1 = cljs.core.first.call(null,inst_69205);
var inst_69207 = cljs.core.next.call(null,inst_69205);
var inst_69208 = cljs.core.not.call(null,inst_69206__$1);
var state_69272__$1 = (function (){var statearr_69296 = state_69272;
(statearr_69296[(25)] = inst_69207);

(statearr_69296[(12)] = inst_69206__$1);

return statearr_69296;
})();
if(inst_69208){
var statearr_69297_69342 = state_69272__$1;
(statearr_69297_69342[(1)] = (19));

} else {
var statearr_69298_69343 = state_69272__$1;
(statearr_69298_69343[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (3))){
var inst_69270 = (state_69272[(2)]);
var state_69272__$1 = state_69272;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69272__$1,inst_69270);
} else {
if((state_val_69273 === (12))){
var inst_69155 = (state_69272[(19)]);
var inst_69168 = fluree.db.flake.flip_flake.call(null,inst_69155);
var state_69272__$1 = state_69272;
var statearr_69299_69344 = state_69272__$1;
(statearr_69299_69344[(2)] = inst_69168);

(statearr_69299_69344[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (2))){
var inst_69141 = (state_69272[(20)]);
var _ = (function (){var statearr_69300 = state_69272;
(statearr_69300[(4)] = cljs.core.cons.call(null,(5),(state_69272[(4)])));

return statearr_69300;
})();
var inst_69141__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69142 = cljs.core.seq.call(null,inst_69141__$1);
var inst_69143 = cljs.core.first.call(null,inst_69142);
var inst_69144 = cljs.core.next.call(null,inst_69142);
var inst_69145 = cljs.core.PersistentHashMap.EMPTY;
var inst_69146 = cljs.core.PersistentHashMap.EMPTY;
var inst_69147 = inst_69141__$1;
var inst_69148 = inst_69145;
var inst_69149 = inst_69146;
var state_69272__$1 = (function (){var statearr_69301 = state_69272;
(statearr_69301[(15)] = inst_69144);

(statearr_69301[(16)] = inst_69149);

(statearr_69301[(18)] = inst_69148);

(statearr_69301[(20)] = inst_69141__$1);

(statearr_69301[(23)] = inst_69147);

(statearr_69301[(24)] = inst_69143);

return statearr_69301;
})();
var statearr_69302_69345 = state_69272__$1;
(statearr_69302_69345[(2)] = null);

(statearr_69302_69345[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (23))){
var inst_69237 = (state_69272[(28)]);
var inst_69244 = (state_69272[(29)]);
var inst_69243 = cljs.core.seq.call(null,inst_69237);
var inst_69244__$1 = cljs.core.first.call(null,inst_69243);
var inst_69245 = cljs.core.next.call(null,inst_69243);
var inst_69246 = cljs.core.not.call(null,inst_69244__$1);
var state_69272__$1 = (function (){var statearr_69303 = state_69272;
(statearr_69303[(27)] = inst_69245);

(statearr_69303[(29)] = inst_69244__$1);

return statearr_69303;
})();
if(inst_69246){
var statearr_69304_69346 = state_69272__$1;
(statearr_69304_69346[(1)] = (25));

} else {
var statearr_69305_69347 = state_69272__$1;
(statearr_69305_69347[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (19))){
var inst_69200 = (state_69272[(7)]);
var state_69272__$1 = state_69272;
var statearr_69306_69348 = state_69272__$1;
(statearr_69306_69348[(2)] = inst_69200);

(statearr_69306_69348[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (11))){
var inst_69155 = (state_69272[(19)]);
var state_69272__$1 = state_69272;
var statearr_69308_69349 = state_69272__$1;
(statearr_69308_69349[(2)] = inst_69155);

(statearr_69308_69349[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (9))){
var inst_69165 = (state_69272[(14)]);
var inst_69155 = (state_69272[(19)]);
var inst_69163 = fluree.db.flake.s.call(null,inst_69155);
var inst_69164 = fluree.db.flake.op.call(null,inst_69155);
var inst_69165__$1 = inst_69164 === true;
var state_69272__$1 = (function (){var statearr_69310 = state_69272;
(statearr_69310[(14)] = inst_69165__$1);

(statearr_69310[(21)] = inst_69163);

return statearr_69310;
})();
if(cljs.core.truth_(inst_69165__$1)){
var statearr_69311_69350 = state_69272__$1;
(statearr_69311_69350[(1)] = (11));

} else {
var statearr_69312_69351 = state_69272__$1;
(statearr_69312_69351[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (5))){
var _ = (function (){var statearr_69313 = state_69272;
(statearr_69313[(4)] = cljs.core.rest.call(null,(state_69272[(4)])));

return statearr_69313;
})();
var state_69272__$1 = state_69272;
var ex69307 = (state_69272__$1[(2)]);
var statearr_69314_69352 = state_69272__$1;
(statearr_69314_69352[(5)] = ex69307);


if((ex69307 instanceof Error)){
var statearr_69315_69353 = state_69272__$1;
(statearr_69315_69353[(1)] = (4));

(statearr_69315_69353[(5)] = null);

} else {
throw ex69307;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (14))){
var inst_69165 = (state_69272[(14)]);
var inst_69144 = (state_69272[(15)]);
var inst_69149 = (state_69272[(16)]);
var inst_69170 = (state_69272[(17)]);
var inst_69148 = (state_69272[(18)]);
var inst_69155 = (state_69272[(19)]);
var inst_69141 = (state_69272[(20)]);
var inst_69163 = (state_69272[(21)]);
var inst_69156 = (state_69272[(22)]);
var inst_69147 = (state_69272[(23)]);
var inst_69143 = (state_69272[(24)]);
var inst_69172 = (function (){var subject = inst_69163;
var flake = inst_69155;
var r = inst_69156;
var asserted_subjects = inst_69148;
var first__69140 = inst_69143;
var seq__69152 = inst_69156;
var flake_SINGLEQUOTE_ = inst_69170;
var retracted_subjects = inst_69149;
var first__69153 = inst_69155;
var G__69137 = inst_69147;
var asserted_QMARK_ = inst_69165;
var vec__69138 = inst_69141;
var vec__69151 = inst_69147;
var seq__69139 = inst_69144;
return (function (p1__69123_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__69123_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_69173 = cljs.core.update.call(null,inst_69148,inst_69163,inst_69172);
var tmp69309 = inst_69149;
var inst_69147__$1 = inst_69156;
var inst_69148__$1 = inst_69173;
var inst_69149__$1 = tmp69309;
var state_69272__$1 = (function (){var statearr_69316 = state_69272;
(statearr_69316[(16)] = inst_69149__$1);

(statearr_69316[(18)] = inst_69148__$1);

(statearr_69316[(23)] = inst_69147__$1);

return statearr_69316;
})();
var statearr_69317_69354 = state_69272__$1;
(statearr_69317_69354[(2)] = null);

(statearr_69317_69354[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (26))){
var inst_69244 = (state_69272[(29)]);
var inst_69249 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_69250 = cljs.core.PersistentHashMap.EMPTY;
var inst_69251 = [true,inst_69250];
var inst_69252 = cljs.core.PersistentHashMap.fromArrays(inst_69249,inst_69251);
var inst_69253 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_69252,inst_69244);
var state_69272__$1 = state_69272;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69272__$1,(28),inst_69253);
} else {
if((state_val_69273 === (16))){
var inst_69180 = (state_69272[(2)]);
var state_69272__$1 = state_69272;
var statearr_69318_69355 = state_69272__$1;
(statearr_69318_69355[(2)] = inst_69180);

(statearr_69318_69355[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (10))){
var inst_69182 = (state_69272[(2)]);
var state_69272__$1 = state_69272;
var statearr_69319_69356 = state_69272__$1;
(statearr_69319_69356[(2)] = inst_69182);

(statearr_69319_69356[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (18))){
var inst_69185 = (state_69272[(11)]);
var inst_69224 = (state_69272[(2)]);
var inst_69232 = cljs.core.vals.call(null,inst_69185);
var inst_69233 = cljs.core.seq.call(null,inst_69232);
var inst_69234 = cljs.core.first.call(null,inst_69233);
var inst_69235 = cljs.core.next.call(null,inst_69233);
var inst_69236 = cljs.core.PersistentVector.EMPTY;
var inst_69237 = inst_69232;
var inst_69238 = inst_69236;
var state_69272__$1 = (function (){var statearr_69320 = state_69272;
(statearr_69320[(30)] = inst_69235);

(statearr_69320[(26)] = inst_69238);

(statearr_69320[(28)] = inst_69237);

(statearr_69320[(31)] = inst_69234);

(statearr_69320[(13)] = inst_69224);

return statearr_69320;
})();
var statearr_69321_69357 = state_69272__$1;
(statearr_69321_69357[(2)] = null);

(statearr_69321_69357[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69273 === (8))){
var inst_69149 = (state_69272[(16)]);
var inst_69148 = (state_69272[(18)]);
var inst_69159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69160 = [inst_69148,inst_69149];
var inst_69161 = (new cljs.core.PersistentVector(null,2,(5),inst_69159,inst_69160,null));
var state_69272__$1 = state_69272;
var statearr_69322_69358 = state_69272__$1;
(statearr_69322_69358[(2)] = inst_69161);

(statearr_69322_69358[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_69323 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69323[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_69323[(1)] = (1));

return statearr_69323;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_69272){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_69272);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69324){var ex__2730__auto__ = e69324;
var statearr_69325_69359 = state_69272;
(statearr_69325_69359[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_69272[(4)]))){
var statearr_69326_69360 = state_69272;
(statearr_69326_69360[(1)] = cljs.core.first.call(null,(state_69272[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69361 = state_69272;
state_69272 = G__69361;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_69272){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_69272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69327 = f__2750__auto__.call(null);
(statearr_69327[(6)] = c__2749__auto__);

return statearr_69327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69393){
var state_val_69394 = (state_69393[(1)]);
if((state_val_69394 === (1))){
var inst_69362 = cljs.core.volatile_BANG_.call(null,(0));
var inst_69363 = cljs.core.PersistentHashMap.EMPTY;
var inst_69364 = cljs.core.volatile_BANG_.call(null,inst_69363);
var inst_69365 = cljs.core.first.call(null,resp);
var inst_69366 = cljs.core.rest.call(null,resp);
var inst_69367 = cljs.core.PersistentVector.EMPTY;
var inst_69368 = inst_69362;
var inst_69369 = inst_69364;
var inst_69370 = inst_69365;
var inst_69371 = inst_69366;
var inst_69372 = inst_69367;
var state_69393__$1 = (function (){var statearr_69395 = state_69393;
(statearr_69395[(7)] = inst_69371);

(statearr_69395[(8)] = inst_69368);

(statearr_69395[(9)] = inst_69369);

(statearr_69395[(10)] = inst_69370);

(statearr_69395[(11)] = inst_69372);

return statearr_69395;
})();
var statearr_69396_69411 = state_69393__$1;
(statearr_69396_69411[(2)] = null);

(statearr_69396_69411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69394 === (2))){
var inst_69368 = (state_69393[(8)]);
var inst_69369 = (state_69393[(9)]);
var inst_69370 = (state_69393[(10)]);
var inst_69374 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_69370,inst_69369,inst_69368);
var state_69393__$1 = state_69393;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69393__$1,(4),inst_69374);
} else {
if((state_val_69394 === (3))){
var inst_69391 = (state_69393[(2)]);
var state_69393__$1 = state_69393;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69393__$1,inst_69391);
} else {
if((state_val_69394 === (4))){
var inst_69371 = (state_69393[(7)]);
var inst_69372 = (state_69393[(11)]);
var inst_69376 = (state_69393[(2)]);
var inst_69377 = fluree.db.util.async.throw_err.call(null,inst_69376);
var inst_69378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69379 = [inst_69377];
var inst_69380 = (new cljs.core.PersistentVector(null,1,(5),inst_69378,inst_69379,null));
var inst_69381 = cljs.core.concat.call(null,inst_69372,inst_69380);
var inst_69382 = cljs.core.first.call(null,inst_69371);
var state_69393__$1 = (function (){var statearr_69399 = state_69393;
(statearr_69399[(12)] = inst_69381);

return statearr_69399;
})();
if(cljs.core.truth_(inst_69382)){
var statearr_69400_69412 = state_69393__$1;
(statearr_69400_69412[(1)] = (5));

} else {
var statearr_69401_69413 = state_69393__$1;
(statearr_69401_69413[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69394 === (5))){
var inst_69371 = (state_69393[(7)]);
var inst_69368 = (state_69393[(8)]);
var inst_69381 = (state_69393[(12)]);
var inst_69369 = (state_69393[(9)]);
var inst_69384 = cljs.core.first.call(null,inst_69371);
var inst_69385 = cljs.core.rest.call(null,inst_69371);
var tmp69397 = inst_69368;
var tmp69398 = inst_69369;
var inst_69368__$1 = tmp69397;
var inst_69369__$1 = tmp69398;
var inst_69370 = inst_69384;
var inst_69371__$1 = inst_69385;
var inst_69372 = inst_69381;
var state_69393__$1 = (function (){var statearr_69402 = state_69393;
(statearr_69402[(7)] = inst_69371__$1);

(statearr_69402[(8)] = inst_69368__$1);

(statearr_69402[(9)] = inst_69369__$1);

(statearr_69402[(10)] = inst_69370);

(statearr_69402[(11)] = inst_69372);

return statearr_69402;
})();
var statearr_69403_69414 = state_69393__$1;
(statearr_69403_69414[(2)] = null);

(statearr_69403_69414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69394 === (6))){
var inst_69381 = (state_69393[(12)]);
var state_69393__$1 = state_69393;
var statearr_69404_69415 = state_69393__$1;
(statearr_69404_69415[(2)] = inst_69381);

(statearr_69404_69415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69394 === (7))){
var inst_69389 = (state_69393[(2)]);
var state_69393__$1 = state_69393;
var statearr_69405_69416 = state_69393__$1;
(statearr_69405_69416[(2)] = inst_69389);

(statearr_69405_69416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_69406 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69406[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__);

(statearr_69406[(1)] = (1));

return statearr_69406;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1 = (function (state_69393){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_69393);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69407){var ex__2730__auto__ = e69407;
var statearr_69408_69417 = state_69393;
(statearr_69408_69417[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_69393[(4)]))){
var statearr_69409_69418 = state_69393;
(statearr_69409_69418[(1)] = cljs.core.first.call(null,(state_69393[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69419 = state_69393;
state_69393 = G__69419;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = function(state_69393){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1.call(this,state_69393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69410 = f__2750__auto__.call(null);
(statearr_69410[(6)] = c__2749__auto__);

return statearr_69410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__69421 = arguments.length;
switch (G__69421) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__69423){
var map__69424 = p__69423;
var map__69424__$1 = cljs.core.__destructure_map.call(null,map__69424);
var query = map__69424__$1;
var opts = cljs.core.get.call(null,map__69424__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69509){
var state_val_69510 = (state_69509[(1)]);
if((state_val_69510 === (7))){
var inst_69435 = (state_69509[(7)]);
var inst_69439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69440 = ["_auth/id",inst_69435];
var inst_69441 = (new cljs.core.PersistentVector(null,2,(5),inst_69439,inst_69440,null));
var state_69509__$1 = state_69509;
var statearr_69511_69555 = state_69509__$1;
(statearr_69511_69555[(2)] = inst_69441);

(statearr_69511_69555[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (20))){
var inst_69489 = (state_69509[(2)]);
var inst_69490 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_69509__$1 = (function (){var statearr_69512 = state_69509;
(statearr_69512[(8)] = inst_69489);

return statearr_69512;
})();
if(cljs.core.truth_(inst_69490)){
var statearr_69513_69556 = state_69509__$1;
(statearr_69513_69556[(1)] = (22));

} else {
var statearr_69514_69557 = state_69509__$1;
(statearr_69514_69557[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (27))){
var inst_69436 = (state_69509[(9)]);
var inst_69492 = (state_69509[(10)]);
var inst_69498 = (state_69509[(2)]);
var inst_69499 = fluree.db.util.core.response_time_formatted.call(null,inst_69436);
var inst_69500 = [(200),inst_69498,(100),inst_69499];
var inst_69501 = cljs.core.PersistentHashMap.fromArrays(inst_69492,inst_69500);
var state_69509__$1 = state_69509;
var statearr_69515_69558 = state_69509__$1;
(statearr_69515_69558[(2)] = inst_69501);

(statearr_69515_69558[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (1))){
var state_69509__$1 = state_69509;
var statearr_69516_69559 = state_69509__$1;
(statearr_69516_69559[(2)] = null);

(statearr_69516_69559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (24))){
var inst_69504 = (state_69509[(2)]);
var _ = (function (){var statearr_69517 = state_69509;
(statearr_69517[(4)] = cljs.core.rest.call(null,(state_69509[(4)])));

return statearr_69517;
})();
var state_69509__$1 = state_69509;
var statearr_69518_69560 = state_69509__$1;
(statearr_69518_69560[(2)] = inst_69504);

(statearr_69518_69560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (4))){
var inst_69425 = (state_69509[(2)]);
var state_69509__$1 = state_69509;
var statearr_69519_69561 = state_69509__$1;
(statearr_69519_69561[(2)] = inst_69425);

(statearr_69519_69561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (15))){
var inst_69476 = (state_69509[(11)]);
var state_69509__$1 = state_69509;
var statearr_69520_69562 = state_69509__$1;
(statearr_69520_69562[(2)] = inst_69476);

(statearr_69520_69562[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (21))){
var inst_69485 = (state_69509[(2)]);
var inst_69486 = fluree.db.util.async.throw_err.call(null,inst_69485);
var state_69509__$1 = state_69509;
var statearr_69521_69563 = state_69509__$1;
(statearr_69521_69563[(2)] = inst_69486);

(statearr_69521_69563[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (13))){
var inst_69476 = (state_69509[(11)]);
var inst_69434 = (state_69509[(12)]);
var inst_69475 = (state_69509[(2)]);
var inst_69476__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_69434);
var state_69509__$1 = (function (){var statearr_69522 = state_69509;
(statearr_69522[(11)] = inst_69476__$1);

(statearr_69522[(13)] = inst_69475);

return statearr_69522;
})();
if(cljs.core.truth_(inst_69476__$1)){
var statearr_69523_69564 = state_69509__$1;
(statearr_69523_69564[(1)] = (15));

} else {
var statearr_69524_69565 = state_69509__$1;
(statearr_69524_69565[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (22))){
var inst_69489 = (state_69509[(8)]);
var inst_69492 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_69493 = cljs.core.sequential_QMARK_.call(null,inst_69489);
var state_69509__$1 = (function (){var statearr_69525 = state_69509;
(statearr_69525[(10)] = inst_69492);

return statearr_69525;
})();
if(inst_69493){
var statearr_69526_69566 = state_69509__$1;
(statearr_69526_69566[(1)] = (25));

} else {
var statearr_69527_69567 = state_69509__$1;
(statearr_69527_69567[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (6))){
var inst_69450 = (state_69509[(14)]);
var inst_69434 = (state_69509[(12)]);
var inst_69449 = (state_69509[(2)]);
var inst_69450__$1 = fluree.db.util.async.throw_err.call(null,inst_69449);
var inst_69451 = fluree.db.api.query.resolve_block_range.call(null,inst_69450__$1,inst_69434);
var state_69509__$1 = (function (){var statearr_69528 = state_69509;
(statearr_69528[(14)] = inst_69450__$1);

return statearr_69528;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69509__$1,(10),inst_69451);
} else {
if((state_val_69510 === (25))){
var inst_69489 = (state_69509[(8)]);
var inst_69495 = cljs.core.doall.call(null,inst_69489);
var state_69509__$1 = state_69509;
var statearr_69529_69568 = state_69509__$1;
(statearr_69529_69568[(2)] = inst_69495);

(statearr_69529_69568[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (17))){
var inst_69481 = (state_69509[(2)]);
var state_69509__$1 = state_69509;
if(cljs.core.truth_(inst_69481)){
var statearr_69530_69569 = state_69509__$1;
(statearr_69530_69569[(1)] = (18));

} else {
var statearr_69531_69570 = state_69509__$1;
(statearr_69531_69570[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (3))){
var inst_69507 = (state_69509[(2)]);
var state_69509__$1 = state_69509;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69509__$1,inst_69507);
} else {
if((state_val_69510 === (12))){
var inst_69434 = (state_69509[(12)]);
var inst_69467 = cljs.core.pr_str.call(null,inst_69434);
var inst_69468 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_69467].join('');
var inst_69469 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69470 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69471 = cljs.core.PersistentHashMap.fromArrays(inst_69469,inst_69470);
var inst_69472 = cljs.core.ex_info.call(null,inst_69468,inst_69471);
var inst_69473 = (function(){throw inst_69472})();
var state_69509__$1 = state_69509;
var statearr_69532_69571 = state_69509__$1;
(statearr_69532_69571[(2)] = inst_69473);

(statearr_69532_69571[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (2))){
var inst_69435 = (state_69509[(7)]);
var _ = (function (){var statearr_69533 = state_69509;
(statearr_69533[(4)] = cljs.core.cons.call(null,(5),(state_69509[(4)])));

return statearr_69533;
})();
var inst_69434 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_69435__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_69436 = fluree.db.util.core.current_time_millis.call(null);
var inst_69437 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_69509__$1 = (function (){var statearr_69534 = state_69509;
(statearr_69534[(15)] = inst_69437);

(statearr_69534[(7)] = inst_69435__$1);

(statearr_69534[(9)] = inst_69436);

(statearr_69534[(12)] = inst_69434);

return statearr_69534;
})();
if(cljs.core.truth_(inst_69435__$1)){
var statearr_69535_69572 = state_69509__$1;
(statearr_69535_69572[(1)] = (7));

} else {
var statearr_69536_69573 = state_69509__$1;
(statearr_69536_69573[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (23))){
var inst_69489 = (state_69509[(8)]);
var state_69509__$1 = state_69509;
var statearr_69537_69574 = state_69509__$1;
(statearr_69537_69574[(2)] = inst_69489);

(statearr_69537_69574[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (19))){
var inst_69475 = (state_69509[(13)]);
var state_69509__$1 = state_69509;
var statearr_69538_69575 = state_69509__$1;
(statearr_69538_69575[(2)] = inst_69475);

(statearr_69538_69575[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (11))){
var inst_69450 = (state_69509[(14)]);
var inst_69456 = (state_69509[(16)]);
var inst_69455 = (state_69509[(17)]);
var inst_69462 = fluree.db.api.query.block_range.call(null,inst_69450,inst_69455,inst_69456,opts);
var state_69509__$1 = state_69509;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69509__$1,(14),inst_69462);
} else {
if((state_val_69510 === (9))){
var inst_69437 = (state_69509[(15)]);
var inst_69444 = (state_69509[(2)]);
var inst_69445 = [inst_69444];
var inst_69446 = cljs.core.PersistentHashMap.fromArrays(inst_69437,inst_69445);
var inst_69447 = fluree.db.api.query.db.call(null,conn,ledger,inst_69446);
var state_69509__$1 = state_69509;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69509__$1,(6),inst_69447);
} else {
if((state_val_69510 === (5))){
var _ = (function (){var statearr_69540 = state_69509;
(statearr_69540[(4)] = cljs.core.rest.call(null,(state_69509[(4)])));

return statearr_69540;
})();
var state_69509__$1 = state_69509;
var ex69539 = (state_69509__$1[(2)]);
var statearr_69541_69576 = state_69509__$1;
(statearr_69541_69576[(5)] = ex69539);


if((ex69539 instanceof Error)){
var statearr_69542_69577 = state_69509__$1;
(statearr_69542_69577[(1)] = (4));

(statearr_69542_69577[(5)] = null);

} else {
throw ex69539;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (14))){
var inst_69464 = (state_69509[(2)]);
var inst_69465 = fluree.db.util.async.throw_err.call(null,inst_69464);
var state_69509__$1 = state_69509;
var statearr_69543_69578 = state_69509__$1;
(statearr_69543_69578[(2)] = inst_69465);

(statearr_69543_69578[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (26))){
var inst_69489 = (state_69509[(8)]);
var state_69509__$1 = state_69509;
var statearr_69544_69579 = state_69509__$1;
(statearr_69544_69579[(2)] = inst_69489);

(statearr_69544_69579[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (16))){
var inst_69434 = (state_69509[(12)]);
var inst_69479 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_69434);
var state_69509__$1 = state_69509;
var statearr_69545_69580 = state_69509__$1;
(statearr_69545_69580[(2)] = inst_69479);

(statearr_69545_69580[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (10))){
var inst_69434 = (state_69509[(12)]);
var inst_69453 = (state_69509[(2)]);
var inst_69454 = fluree.db.util.async.throw_err.call(null,inst_69453);
var inst_69455 = cljs.core.nth.call(null,inst_69454,(0),null);
var inst_69456 = cljs.core.nth.call(null,inst_69454,(1),null);
var inst_69457 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_69458 = cljs.core.dissoc.call(null,inst_69434,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_69459 = cljs.core.keys.call(null,inst_69458);
var inst_69460 = cljs.core._EQ_.call(null,inst_69457,inst_69459);
var state_69509__$1 = (function (){var statearr_69546 = state_69509;
(statearr_69546[(16)] = inst_69456);

(statearr_69546[(17)] = inst_69455);

return statearr_69546;
})();
if(inst_69460){
var statearr_69547_69581 = state_69509__$1;
(statearr_69547_69581[(1)] = (11));

} else {
var statearr_69548_69582 = state_69509__$1;
(statearr_69548_69582[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69510 === (18))){
var inst_69450 = (state_69509[(14)]);
var inst_69475 = (state_69509[(13)]);
var inst_69483 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_69450,inst_69475);
var state_69509__$1 = state_69509;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69509__$1,(21),inst_69483);
} else {
if((state_val_69510 === (8))){
var state_69509__$1 = state_69509;
var statearr_69549_69583 = state_69509__$1;
(statearr_69549_69583[(2)] = null);

(statearr_69549_69583[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_69550 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69550[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2727__auto__);

(statearr_69550[(1)] = (1));

return statearr_69550;
});
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1 = (function (state_69509){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_69509);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69551){var ex__2730__auto__ = e69551;
var statearr_69552_69584 = state_69509;
(statearr_69552_69584[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_69509[(4)]))){
var statearr_69553_69585 = state_69509;
(statearr_69553_69585[(1)] = cljs.core.first.call(null,(state_69509[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69586 = state_69509;
state_69509 = G__69586;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = function(state_69509){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1.call(this,state_69509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69554 = f__2750__auto__.call(null);
(statearr_69554[(6)] = c__2749__auto__);

return statearr_69554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__69587 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__69587,(0),null);
var p = cljs.core.nth.call(null,vec__69587,(1),null);
var o = cljs.core.nth.call(null,vec__69587,(2),null);
var t = cljs.core.nth.call(null,vec__69587,(3),null);
var vec__69590 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__69590,(0),null);
var idx = cljs.core.nth.call(null,vec__69590,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__69593 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t.call(null,flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__69593,(0),null);
var id = cljs.core.nth.call(null,vec__69593,(1),null);
var or__4253__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69597 = arguments.length;
var i__4865__auto___69598 = (0);
while(true){
if((i__4865__auto___69598 < len__4864__auto___69597)){
args__4870__auto__.push((arguments[i__4865__auto___69598]));

var G__69599 = (i__4865__auto___69598 + (1));
i__4865__auto___69598 = G__69599;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq69596){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq69596));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69795){
var state_val_69796 = (state_69795[(1)]);
if((state_val_69796 === (7))){
var inst_69715 = (state_69795[(7)]);
var inst_69722 = (state_69795[(8)]);
var inst_69721 = cljs.core.seq.call(null,inst_69715);
var inst_69722__$1 = cljs.core.first.call(null,inst_69721);
var inst_69723 = cljs.core.next.call(null,inst_69721);
var state_69795__$1 = (function (){var statearr_69797 = state_69795;
(statearr_69797[(9)] = inst_69723);

(statearr_69797[(8)] = inst_69722__$1);

return statearr_69797;
})();
if(cljs.core.truth_(inst_69722__$1)){
var statearr_69798_69898 = state_69795__$1;
(statearr_69798_69898[(1)] = (9));

} else {
var statearr_69799_69899 = state_69795__$1;
(statearr_69799_69899[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (20))){
var inst_69785 = (state_69795[(2)]);
var state_69795__$1 = state_69795;
var statearr_69800_69900 = state_69795__$1;
(statearr_69800_69900[(2)] = inst_69785);

(statearr_69800_69900[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (27))){
var inst_69761 = (state_69795[(10)]);
var inst_69740 = (state_69795[(11)]);
var inst_69743 = (state_69795[(12)]);
var inst_69763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69764 = [inst_69743,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_69765 = (new cljs.core.PersistentVector(null,2,(5),inst_69763,inst_69764,null));
var inst_69766 = cljs.core.update_in.call(null,inst_69761,inst_69765,fluree.db.api.query.min_safe,inst_69740);
var state_69795__$1 = state_69795;
var statearr_69801_69901 = state_69795__$1;
(statearr_69801_69901[(2)] = inst_69766);

(statearr_69801_69901[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (1))){
var state_69795__$1 = state_69795;
var statearr_69802_69902 = state_69795__$1;
(statearr_69802_69902[(2)] = null);

(statearr_69802_69902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (24))){
var inst_69753 = (state_69795[(13)]);
var inst_69722 = (state_69795[(8)]);
var inst_69743 = (state_69795[(12)]);
var inst_69755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69756 = [inst_69743,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_69757 = (new cljs.core.PersistentVector(null,2,(5),inst_69755,inst_69756,null));
var inst_69758 = cljs.core.update_in.call(null,inst_69753,inst_69757,cljs.core.conj,inst_69722);
var state_69795__$1 = state_69795;
var statearr_69804_69903 = state_69795__$1;
(statearr_69804_69903[(2)] = inst_69758);

(statearr_69804_69903[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (4))){
var inst_69601 = (state_69795[(2)]);
var state_69795__$1 = state_69795;
var statearr_69805_69904 = state_69795__$1;
(statearr_69805_69904[(2)] = inst_69601);

(statearr_69805_69904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (15))){
var inst_69723 = (state_69795[(9)]);
var inst_69716 = (state_69795[(14)]);
var tmp69803 = inst_69716;
var inst_69715 = inst_69723;
var inst_69716__$1 = tmp69803;
var state_69795__$1 = (function (){var statearr_69806 = state_69795;
(statearr_69806[(7)] = inst_69715);

(statearr_69806[(14)] = inst_69716__$1);

return statearr_69806;
})();
var statearr_69807_69905 = state_69795__$1;
(statearr_69807_69905[(2)] = null);

(statearr_69807_69905[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (21))){
var inst_69716 = (state_69795[(14)]);
var inst_69743 = (state_69795[(12)]);
var inst_69747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69748 = [inst_69743,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_69749 = (new cljs.core.PersistentVector(null,2,(5),inst_69747,inst_69748,null));
var inst_69750 = cljs.core.assoc_in.call(null,inst_69716,inst_69749,inst_69743);
var state_69795__$1 = state_69795;
var statearr_69808_69906 = state_69795__$1;
(statearr_69808_69906[(2)] = inst_69750);

(statearr_69808_69906[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (31))){
var inst_69769 = (state_69795[(15)]);
var state_69795__$1 = state_69795;
var statearr_69809_69907 = state_69795__$1;
(statearr_69809_69907[(2)] = inst_69769);

(statearr_69809_69907[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (32))){
var inst_69723 = (state_69795[(9)]);
var inst_69777 = (state_69795[(2)]);
var inst_69715 = inst_69723;
var inst_69716 = inst_69777;
var state_69795__$1 = (function (){var statearr_69810 = state_69795;
(statearr_69810[(7)] = inst_69715);

(statearr_69810[(14)] = inst_69716);

return statearr_69810;
})();
var statearr_69811_69908 = state_69795__$1;
(statearr_69811_69908[(2)] = null);

(statearr_69811_69908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (33))){
var inst_69716 = (state_69795[(14)]);
var state_69795__$1 = state_69795;
var statearr_69812_69909 = state_69795__$1;
(statearr_69812_69909[(2)] = inst_69716);

(statearr_69812_69909[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (13))){
var inst_69725 = (state_69795[(16)]);
var state_69795__$1 = state_69795;
var statearr_69813_69910 = state_69795__$1;
(statearr_69813_69910[(2)] = inst_69725);

(statearr_69813_69910[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (22))){
var inst_69716 = (state_69795[(14)]);
var state_69795__$1 = state_69795;
var statearr_69814_69911 = state_69795__$1;
(statearr_69814_69911[(2)] = inst_69716);

(statearr_69814_69911[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (29))){
var inst_69769 = (state_69795[(2)]);
var state_69795__$1 = (function (){var statearr_69815 = state_69795;
(statearr_69815[(15)] = inst_69769);

return statearr_69815;
})();
if(cljs.core.truth_(show_auth)){
var statearr_69816_69912 = state_69795__$1;
(statearr_69816_69912[(1)] = (30));

} else {
var statearr_69817_69913 = state_69795__$1;
(statearr_69817_69913[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (6))){
var inst_69701 = (state_69795[(2)]);
var inst_69702 = fluree.db.util.async.throw_err.call(null,inst_69701);
var inst_69710 = resp;
var inst_69711 = cljs.core.seq.call(null,inst_69710);
var inst_69712 = cljs.core.first.call(null,inst_69711);
var inst_69713 = cljs.core.next.call(null,inst_69711);
var inst_69714 = cljs.core.PersistentHashMap.EMPTY;
var inst_69715 = inst_69710;
var inst_69716 = inst_69714;
var state_69795__$1 = (function (){var statearr_69818 = state_69795;
(statearr_69818[(7)] = inst_69715);

(statearr_69818[(17)] = inst_69713);

(statearr_69818[(18)] = inst_69702);

(statearr_69818[(14)] = inst_69716);

(statearr_69818[(19)] = inst_69712);

return statearr_69818;
})();
var statearr_69819_69914 = state_69795__$1;
(statearr_69819_69914[(2)] = null);

(statearr_69819_69914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (28))){
var inst_69761 = (state_69795[(10)]);
var state_69795__$1 = state_69795;
var statearr_69820_69915 = state_69795__$1;
(statearr_69820_69915[(2)] = inst_69761);

(statearr_69820_69915[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (25))){
var inst_69753 = (state_69795[(13)]);
var state_69795__$1 = state_69795;
var statearr_69821_69916 = state_69795__$1;
(statearr_69821_69916[(2)] = inst_69753);

(statearr_69821_69916[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (34))){
var state_69795__$1 = state_69795;
var statearr_69822_69917 = state_69795__$1;
(statearr_69822_69917[(2)] = null);

(statearr_69822_69917[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (17))){
var inst_69787 = (state_69795[(2)]);
var state_69795__$1 = state_69795;
var statearr_69823_69918 = state_69795__$1;
(statearr_69823_69918[(2)] = inst_69787);

(statearr_69823_69918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (3))){
var inst_69793 = (state_69795[(2)]);
var state_69795__$1 = state_69795;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69795__$1,inst_69793);
} else {
if((state_val_69796 === (12))){
var inst_69722 = (state_69795[(8)]);
var inst_69702 = (state_69795[(18)]);
var inst_69727 = fluree.db.api.query.auth_match.call(null,auth,inst_69702,inst_69722);
var inst_69728 = cljs.core.not.call(null,inst_69727);
var state_69795__$1 = state_69795;
var statearr_69824_69919 = state_69795__$1;
(statearr_69824_69919[(2)] = inst_69728);

(statearr_69824_69919[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (2))){
var _ = (function (){var statearr_69825 = state_69795;
(statearr_69825[(4)] = cljs.core.cons.call(null,(5),(state_69795[(4)])));

return statearr_69825;
})();
var inst_69607 = (function (){return (function (p1__69600_SHARP_){
return fluree.db.flake.t.call(null,p1__69600_SHARP_);
});
})();
var inst_69608 = cljs.core.map.call(null,inst_69607,resp);
var inst_69609 = cljs.core.set.call(null,inst_69608);
var inst_69697 = cljs.core.async.chan.call(null,(1));
var inst_69698 = (function (){var ts = inst_69609;
var c__2749__auto____$1 = inst_69697;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69695){
var state_val_69696 = (state_69695[(1)]);
if((state_val_69696 === (7))){
var inst_69641 = (state_69695[(7)]);
var inst_69629 = (state_69695[(8)]);
var inst_69635 = (state_69695[(9)]);
var inst_69623 = (state_69695[(10)]);
var inst_69634 = (state_69695[(2)]);
var inst_69635__$1 = fluree.db.util.async.throw_err.call(null,inst_69634);
var inst_69637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69638 = [inst_69629,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_69639 = (new cljs.core.PersistentVector(null,2,(5),inst_69637,inst_69638,null));
var inst_69640 = cljs.core.assoc_in.call(null,inst_69623,inst_69639,inst_69635__$1);
var inst_69641__$1 = auth;
var state_69695__$1 = (function (){var statearr_69826 = state_69695;
(statearr_69826[(7)] = inst_69641__$1);

(statearr_69826[(9)] = inst_69635__$1);

(statearr_69826[(11)] = inst_69640);

return statearr_69826;
})();
if(cljs.core.truth_(inst_69641__$1)){
var statearr_69827_69920 = state_69695__$1;
(statearr_69827_69920[(1)] = (8));

} else {
var statearr_69828_69921 = state_69695__$1;
(statearr_69828_69921[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69696 === (1))){
var inst_69617 = (state_69695[(12)]);
var inst_69617__$1 = ts;
var inst_69618 = cljs.core.seq.call(null,inst_69617__$1);
var inst_69619 = cljs.core.first.call(null,inst_69618);
var inst_69620 = cljs.core.next.call(null,inst_69618);
var inst_69621 = cljs.core.PersistentHashMap.EMPTY;
var inst_69622 = inst_69617__$1;
var inst_69623 = inst_69621;
var state_69695__$1 = (function (){var statearr_69829 = state_69695;
(statearr_69829[(12)] = inst_69617__$1);

(statearr_69829[(13)] = inst_69619);

(statearr_69829[(14)] = inst_69622);

(statearr_69829[(15)] = inst_69620);

(statearr_69829[(10)] = inst_69623);

return statearr_69829;
})();
var statearr_69830_69922 = state_69695__$1;
(statearr_69830_69922[(2)] = null);

(statearr_69830_69922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69696 === (4))){
var inst_69629 = (state_69695[(8)]);
var inst_69632 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_69629);
var state_69695__$1 = state_69695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69695__$1,(7),inst_69632);
} else {
if((state_val_69696 === (13))){
var inst_69630 = (state_69695[(16)]);
var inst_69687 = (state_69695[(2)]);
var inst_69622 = inst_69630;
var inst_69623 = inst_69687;
var state_69695__$1 = (function (){var statearr_69831 = state_69695;
(statearr_69831[(14)] = inst_69622);

(statearr_69831[(10)] = inst_69623);

return statearr_69831;
})();
var statearr_69832_69923 = state_69695__$1;
(statearr_69832_69923[(2)] = null);

(statearr_69832_69923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69696 === (6))){
var inst_69691 = (state_69695[(2)]);
var state_69695__$1 = state_69695;
var statearr_69833_69924 = state_69695__$1;
(statearr_69833_69924[(2)] = inst_69691);

(statearr_69833_69924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69696 === (3))){
var inst_69693 = (state_69695[(2)]);
var state_69695__$1 = state_69695;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69695__$1,inst_69693);
} else {
if((state_val_69696 === (12))){
var inst_69640 = (state_69695[(11)]);
var state_69695__$1 = state_69695;
var statearr_69834_69925 = state_69695__$1;
(statearr_69834_69925[(2)] = inst_69640);

(statearr_69834_69925[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69696 === (2))){
var inst_69622 = (state_69695[(14)]);
var inst_69629 = (state_69695[(8)]);
var inst_69628 = cljs.core.seq.call(null,inst_69622);
var inst_69629__$1 = cljs.core.first.call(null,inst_69628);
var inst_69630 = cljs.core.next.call(null,inst_69628);
var state_69695__$1 = (function (){var statearr_69835 = state_69695;
(statearr_69835[(8)] = inst_69629__$1);

(statearr_69835[(16)] = inst_69630);

return statearr_69835;
})();
if(cljs.core.truth_(inst_69629__$1)){
var statearr_69836_69926 = state_69695__$1;
(statearr_69836_69926[(1)] = (4));

} else {
var statearr_69837_69927 = state_69695__$1;
(statearr_69837_69927[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69696 === (11))){
var inst_69617 = (state_69695[(12)]);
var inst_69619 = (state_69695[(13)]);
var inst_69622 = (state_69695[(14)]);
var inst_69620 = (state_69695[(15)]);
var inst_69629 = (state_69695[(8)]);
var inst_69630 = (state_69695[(16)]);
var inst_69635 = (state_69695[(9)]);
var inst_69623 = (state_69695[(10)]);
var inst_69640 = (state_69695[(11)]);
var inst_69647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69648 = [inst_69629,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_69649 = (new cljs.core.PersistentVector(null,2,(5),inst_69647,inst_69648,null));
var inst_69662 = cljs.core.async.chan.call(null,(1));
var inst_69663 = (function (){var G__69613 = inst_69622;
var t = inst_69629;
var seq__69626 = inst_69630;
var c__2749__auto____$2 = inst_69662;
var seq__69615 = inst_69620;
var block = inst_69635;
var r = inst_69630;
var vec__69614 = inst_69617;
var G__69636 = inst_69640;
var acc = inst_69623;
var first__69627 = inst_69629;
var first__69616 = inst_69619;
var vec__69625 = inst_69622;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69660){
var state_val_69661 = (state_69660[(1)]);
if((state_val_69661 === (1))){
var state_69660__$1 = state_69660;
var statearr_69838_69928 = state_69660__$1;
(statearr_69838_69928[(2)] = null);

(statearr_69838_69928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69661 === (2))){
var ___$1 = (function (){var statearr_69839 = state_69660;
(statearr_69839[(4)] = cljs.core.cons.call(null,(5),(state_69660[(4)])));

return statearr_69839;
})();
var ___$2 = (function (){var statearr_69840 = state_69660;
(statearr_69840[(4)] = cljs.core.rest.call(null,(state_69660[(4)])));

return statearr_69840;
})();
var state_69660__$1 = state_69660;
var statearr_69841_69929 = state_69660__$1;
(statearr_69841_69929[(2)] = db);

(statearr_69841_69929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69661 === (3))){
var inst_69658 = (state_69660[(2)]);
var state_69660__$1 = state_69660;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69660__$1,inst_69658);
} else {
if((state_val_69661 === (4))){
var inst_69650 = (state_69660[(2)]);
var state_69660__$1 = state_69660;
var statearr_69843_69930 = state_69660__$1;
(statearr_69843_69930[(2)] = inst_69650);

(statearr_69843_69930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69661 === (5))){
var ___$1 = (function (){var statearr_69844 = state_69660;
(statearr_69844[(4)] = cljs.core.rest.call(null,(state_69660[(4)])));

return statearr_69844;
})();
var state_69660__$1 = state_69660;
var ex69842 = (state_69660__$1[(2)]);
var statearr_69845_69931 = state_69660__$1;
(statearr_69845_69931[(5)] = ex69842);


if((ex69842 instanceof Error)){
var statearr_69846_69932 = state_69660__$1;
(statearr_69846_69932[(1)] = (4));

(statearr_69846_69932[(5)] = null);

} else {
throw ex69842;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_69847 = [null,null,null,null,null,null,null];
(statearr_69847[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_69847[(1)] = (1));

return statearr_69847;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_69660){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_69660);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69848){var ex__2730__auto__ = e69848;
var statearr_69849_69933 = state_69660;
(statearr_69849_69933[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_69660[(4)]))){
var statearr_69850_69934 = state_69660;
(statearr_69850_69934[(1)] = cljs.core.first.call(null,(state_69660[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69935 = state_69660;
state_69660 = G__69935;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_69660){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_69660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69851 = f__2750__auto__.call(null);
(statearr_69851[(6)] = c__2749__auto____$2);

return statearr_69851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
});
})();
var inst_69664 = cljs.core.async.impl.dispatch.run.call(null,inst_69663);
var inst_69665 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_69666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69667 = ["?auth","?id"];
var inst_69668 = (new cljs.core.PersistentVector(null,2,(5),inst_69666,inst_69667,null));
var inst_69669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69670 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69671 = [inst_69629,"_tx/auth","?auth"];
var inst_69672 = (new cljs.core.PersistentVector(null,3,(5),inst_69670,inst_69671,null));
var inst_69673 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69674 = ["?auth","_auth/id","?id"];
var inst_69675 = (new cljs.core.PersistentVector(null,3,(5),inst_69673,inst_69674,null));
var inst_69676 = [inst_69672,inst_69675];
var inst_69677 = (new cljs.core.PersistentVector(null,2,(5),inst_69669,inst_69676,null));
var inst_69678 = [inst_69668,inst_69677];
var inst_69679 = cljs.core.PersistentHashMap.fromArrays(inst_69665,inst_69678);
var inst_69680 = fluree.db.api.query.query_async.call(null,inst_69662,inst_69679);
var state_69695__$1 = (function (){var statearr_69852 = state_69695;
(statearr_69852[(17)] = inst_69649);

(statearr_69852[(18)] = inst_69664);

return statearr_69852;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69695__$1,(14),inst_69680);
} else {
if((state_val_69696 === (9))){
var state_69695__$1 = state_69695;
var statearr_69853_69936 = state_69695__$1;
(statearr_69853_69936[(2)] = show_auth);

(statearr_69853_69936[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69696 === (5))){
var inst_69623 = (state_69695[(10)]);
var state_69695__$1 = state_69695;
var statearr_69854_69937 = state_69695__$1;
(statearr_69854_69937[(2)] = inst_69623);

(statearr_69854_69937[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69696 === (14))){
var inst_69649 = (state_69695[(17)]);
var inst_69640 = (state_69695[(11)]);
var inst_69682 = (state_69695[(2)]);
var inst_69683 = fluree.db.util.async.throw_err.call(null,inst_69682);
var inst_69684 = cljs.core.assoc_in.call(null,inst_69640,inst_69649,inst_69683);
var state_69695__$1 = state_69695;
var statearr_69855_69938 = state_69695__$1;
(statearr_69855_69938[(2)] = inst_69684);

(statearr_69855_69938[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69696 === (10))){
var inst_69645 = (state_69695[(2)]);
var state_69695__$1 = state_69695;
if(cljs.core.truth_(inst_69645)){
var statearr_69856_69939 = state_69695__$1;
(statearr_69856_69939[(1)] = (11));

} else {
var statearr_69857_69940 = state_69695__$1;
(statearr_69857_69940[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69696 === (8))){
var inst_69641 = (state_69695[(7)]);
var state_69695__$1 = state_69695;
var statearr_69858_69941 = state_69695__$1;
(statearr_69858_69941[(2)] = inst_69641);

(statearr_69858_69941[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_69859 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69859[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_69859[(1)] = (1));

return statearr_69859;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_69695){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_69695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69860){var ex__2730__auto__ = e69860;
var statearr_69861_69942 = state_69695;
(statearr_69861_69942[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_69695[(4)]))){
var statearr_69862_69943 = state_69695;
(statearr_69862_69943[(1)] = cljs.core.first.call(null,(state_69695[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69944 = state_69695;
state_69695 = G__69944;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_69695){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_69695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69863 = f__2750__auto__.call(null);
(statearr_69863[(6)] = c__2749__auto____$1);

return statearr_69863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
});
})();
var inst_69699 = cljs.core.async.impl.dispatch.run.call(null,inst_69698);
var state_69795__$1 = (function (){var statearr_69864 = state_69795;
(statearr_69864[(20)] = inst_69699);

return statearr_69864;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69795__$1,(6),inst_69697);
} else {
if((state_val_69796 === (23))){
var inst_69753 = (state_69795[(2)]);
var state_69795__$1 = (function (){var statearr_69865 = state_69795;
(statearr_69865[(13)] = inst_69753);

return statearr_69865;
})();
var statearr_69866_69945 = state_69795__$1;
(statearr_69866_69945[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (35))){
var inst_69783 = (state_69795[(2)]);
var state_69795__$1 = state_69795;
var statearr_69868_69946 = state_69795__$1;
(statearr_69868_69946[(2)] = inst_69783);

(statearr_69868_69946[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (19))){
var state_69795__$1 = state_69795;
var statearr_69869_69947 = state_69795__$1;
(statearr_69869_69947[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (11))){
var inst_69734 = (state_69795[(2)]);
var state_69795__$1 = state_69795;
if(cljs.core.truth_(inst_69734)){
var statearr_69872_69948 = state_69795__$1;
(statearr_69872_69948[(1)] = (15));

} else {
var statearr_69873_69949 = state_69795__$1;
(statearr_69873_69949[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (9))){
var inst_69725 = (state_69795[(16)]);
var inst_69725__$1 = auth;
var state_69795__$1 = (function (){var statearr_69874 = state_69795;
(statearr_69874[(16)] = inst_69725__$1);

return statearr_69874;
})();
if(cljs.core.truth_(inst_69725__$1)){
var statearr_69875_69950 = state_69795__$1;
(statearr_69875_69950[(1)] = (12));

} else {
var statearr_69876_69951 = state_69795__$1;
(statearr_69876_69951[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (5))){
var _ = (function (){var statearr_69877 = state_69795;
(statearr_69877[(4)] = cljs.core.rest.call(null,(state_69795[(4)])));

return statearr_69877;
})();
var state_69795__$1 = state_69795;
var ex69871 = (state_69795__$1[(2)]);
var statearr_69878_69952 = state_69795__$1;
(statearr_69878_69952[(5)] = ex69871);


if((ex69871 instanceof Error)){
var statearr_69879_69953 = state_69795__$1;
(statearr_69879_69953[(1)] = (4));

(statearr_69879_69953[(5)] = null);

} else {
throw ex69871;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (14))){
var inst_69731 = (state_69795[(2)]);
var state_69795__$1 = state_69795;
var statearr_69880_69954 = state_69795__$1;
(statearr_69880_69954[(2)] = inst_69731);

(statearr_69880_69954[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (26))){
var inst_69761 = (state_69795[(2)]);
var state_69795__$1 = (function (){var statearr_69881 = state_69795;
(statearr_69881[(10)] = inst_69761);

return statearr_69881;
})();
var statearr_69882_69955 = state_69795__$1;
(statearr_69882_69955[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (16))){
var inst_69722 = (state_69795[(8)]);
var state_69795__$1 = state_69795;
if(cljs.core.truth_(inst_69722)){
var statearr_69884_69956 = state_69795__$1;
(statearr_69884_69956[(1)] = (18));

} else {
var statearr_69885_69957 = state_69795__$1;
(statearr_69885_69957[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (30))){
var inst_69769 = (state_69795[(15)]);
var inst_69744 = (state_69795[(21)]);
var inst_69743 = (state_69795[(12)]);
var inst_69771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69772 = [inst_69743,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_69773 = (new cljs.core.PersistentVector(null,2,(5),inst_69771,inst_69772,null));
var inst_69774 = cljs.core.assoc_in.call(null,inst_69769,inst_69773,inst_69744);
var state_69795__$1 = state_69795;
var statearr_69886_69958 = state_69795__$1;
(statearr_69886_69958[(2)] = inst_69774);

(statearr_69886_69958[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (10))){
var inst_69722 = (state_69795[(8)]);
var state_69795__$1 = state_69795;
var statearr_69887_69959 = state_69795__$1;
(statearr_69887_69959[(2)] = inst_69722);

(statearr_69887_69959[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (18))){
var inst_69722 = (state_69795[(8)]);
var inst_69702 = (state_69795[(18)]);
var inst_69740 = (state_69795[(11)]);
var inst_69740__$1 = fluree.db.flake.t.call(null,inst_69722);
var inst_69741 = cljs.core.get.call(null,inst_69702,inst_69740__$1);
var inst_69742 = cljs.core.__destructure_map.call(null,inst_69741);
var inst_69743 = cljs.core.get.call(null,inst_69742,new cljs.core.Keyword(null,"block","block",664686210));
var inst_69744 = cljs.core.get.call(null,inst_69742,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_69795__$1 = (function (){var statearr_69888 = state_69795;
(statearr_69888[(11)] = inst_69740__$1);

(statearr_69888[(21)] = inst_69744);

(statearr_69888[(12)] = inst_69743);

return statearr_69888;
})();
var statearr_69889_69960 = state_69795__$1;
(statearr_69889_69960[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69796 === (8))){
var inst_69789 = (state_69795[(2)]);
var inst_69790 = cljs.core.vals.call(null,inst_69789);
var _ = (function (){var statearr_69891 = state_69795;
(statearr_69891[(4)] = cljs.core.rest.call(null,(state_69795[(4)])));

return statearr_69891;
})();
var state_69795__$1 = state_69795;
var statearr_69892_69961 = state_69795__$1;
(statearr_69892_69961[(2)] = inst_69790);

(statearr_69892_69961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_69893 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69893[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_69893[(1)] = (1));

return statearr_69893;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_69795){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_69795);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69894){var ex__2730__auto__ = e69894;
var statearr_69895_69962 = state_69795;
(statearr_69895_69962[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_69795[(4)]))){
var statearr_69896_69963 = state_69795;
(statearr_69896_69963[(1)] = cljs.core.first.call(null,(state_69795[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69964 = state_69795;
state_69795 = G__69964;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_69795){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_69795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69897 = f__2750__auto__.call(null);
(statearr_69897[(6)] = c__2749__auto__);

return statearr_69897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70088){
var state_val_70089 = (state_70088[(1)]);
if((state_val_70089 === (7))){
var inst_69987 = (state_70088[(7)]);
var inst_69989 = fluree.db.api.query.resolve_block_range.call(null,inst_69987,query_map);
var state_70088__$1 = state_70088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70088__$1,(10),inst_69989);
} else {
if((state_val_70089 === (20))){
var inst_70013 = (state_70088[(2)]);
var inst_70014 = fluree.db.util.async.throw_err.call(null,inst_70013);
var inst_70015 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70014);
var inst_70016 = (inst_70015 - (1));
var state_70088__$1 = state_70088;
var statearr_70090_70153 = state_70088__$1;
(statearr_70090_70153[(2)] = inst_70016);

(statearr_70090_70153[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (27))){
var state_70088__$1 = state_70088;
var statearr_70091_70154 = state_70088__$1;
(statearr_70091_70154[(2)] = null);

(statearr_70091_70154[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (1))){
var state_70088__$1 = state_70088;
var statearr_70092_70155 = state_70088__$1;
(statearr_70092_70155[(2)] = null);

(statearr_70092_70155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (24))){
var inst_70023 = (state_70088[(2)]);
var inst_70024 = fluree.db.util.async.throw_err.call(null,inst_70023);
var inst_70025 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70024);
var state_70088__$1 = state_70088;
var statearr_70093_70156 = state_70088__$1;
(statearr_70093_70156[(2)] = inst_70025);

(statearr_70093_70156[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (39))){
var inst_70060 = (state_70088[(2)]);
var inst_70061 = fluree.db.util.async.throw_err.call(null,inst_70060);
var state_70088__$1 = state_70088;
var statearr_70094_70157 = state_70088__$1;
(statearr_70094_70157[(2)] = inst_70061);

(statearr_70094_70157[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (4))){
var inst_69965 = (state_70088[(2)]);
var state_70088__$1 = state_70088;
var statearr_70095_70158 = state_70088__$1;
(statearr_70095_70158[(2)] = inst_69965);

(statearr_70095_70158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (15))){
var inst_69996 = (state_70088[(8)]);
var state_70088__$1 = state_70088;
var statearr_70096_70159 = state_70088__$1;
(statearr_70096_70159[(2)] = inst_69996);

(statearr_70096_70159[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (21))){
var inst_69997 = (state_70088[(9)]);
var inst_69987 = (state_70088[(7)]);
var inst_70021 = fluree.db.time_travel.as_of_block.call(null,inst_69987,inst_69997);
var state_70088__$1 = state_70088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70088__$1,(24),inst_70021);
} else {
if((state_val_70089 === (31))){
var inst_69981 = (state_70088[(10)]);
var state_70088__$1 = state_70088;
var statearr_70097_70160 = state_70088__$1;
(statearr_70097_70160[(2)] = inst_69981);

(statearr_70097_70160[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (32))){
var inst_70044 = (state_70088[(11)]);
var inst_69987 = (state_70088[(7)]);
var inst_70039 = (state_70088[(12)]);
var inst_70048 = (state_70088[(2)]);
var inst_70049 = fluree.db.api.query.format_history_resp.call(null,inst_69987,inst_70039,inst_70044,inst_70048);
var state_70088__$1 = state_70088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70088__$1,(29),inst_70049);
} else {
if((state_val_70089 === (40))){
var inst_70065 = (state_70088[(13)]);
var inst_70039 = (state_70088[(12)]);
var inst_70067 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_70068 = cljs.core.count.call(null,inst_70039);
var inst_70069 = [inst_70065,inst_70068,(200)];
var inst_70070 = cljs.core.PersistentHashMap.fromArrays(inst_70067,inst_70069);
var state_70088__$1 = state_70088;
var statearr_70098_70161 = state_70088__$1;
(statearr_70098_70161[(2)] = inst_70070);

(statearr_70098_70161[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (33))){
var inst_69980 = (state_70088[(14)]);
var state_70088__$1 = state_70088;
var statearr_70099_70162 = state_70088__$1;
(statearr_70099_70162[(2)] = inst_69980);

(statearr_70099_70162[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (13))){
var inst_70083 = (state_70088[(2)]);
var _ = (function (){var statearr_70100 = state_70088;
(statearr_70100[(4)] = cljs.core.rest.call(null,(state_70088[(4)])));

return statearr_70100;
})();
var state_70088__$1 = state_70088;
var statearr_70101_70163 = state_70088__$1;
(statearr_70101_70163[(2)] = inst_70083);

(statearr_70101_70163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (22))){
var inst_69987 = (state_70088[(7)]);
var inst_70027 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_69987);
var state_70088__$1 = state_70088;
var statearr_70102_70164 = state_70088__$1;
(statearr_70102_70164[(2)] = inst_70027);

(statearr_70102_70164[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (36))){
var inst_70052 = (state_70088[(15)]);
var inst_69987 = (state_70088[(7)]);
var inst_70058 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_69987,inst_70052);
var state_70088__$1 = state_70088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70088__$1,(39),inst_70058);
} else {
if((state_val_70089 === (41))){
var inst_70065 = (state_70088[(13)]);
var state_70088__$1 = state_70088;
var statearr_70103_70165 = state_70088__$1;
(statearr_70103_70165[(2)] = inst_70065);

(statearr_70103_70165[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (29))){
var inst_69980 = (state_70088[(14)]);
var inst_70051 = (state_70088[(2)]);
var inst_70052 = fluree.db.util.async.throw_err.call(null,inst_70051);
var state_70088__$1 = (function (){var statearr_70104 = state_70088;
(statearr_70104[(15)] = inst_70052);

return statearr_70104;
})();
if(cljs.core.truth_(inst_69980)){
var statearr_70105_70166 = state_70088__$1;
(statearr_70105_70166[(1)] = (33));

} else {
var statearr_70106_70167 = state_70088__$1;
(statearr_70106_70167[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (6))){
var inst_69977 = (state_70088[(16)]);
var inst_69986 = (state_70088[(2)]);
var inst_69987 = fluree.db.util.async.throw_err.call(null,inst_69986);
var state_70088__$1 = (function (){var statearr_70107 = state_70088;
(statearr_70107[(7)] = inst_69987);

return statearr_70107;
})();
if(cljs.core.truth_(inst_69977)){
var statearr_70108_70168 = state_70088__$1;
(statearr_70108_70168[(1)] = (7));

} else {
var statearr_70109_70169 = state_70088__$1;
(statearr_70109_70169[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (28))){
var inst_69982 = (state_70088[(17)]);
var inst_70044 = (state_70088[(2)]);
var state_70088__$1 = (function (){var statearr_70110 = state_70088;
(statearr_70110[(11)] = inst_70044);

return statearr_70110;
})();
if(cljs.core.truth_(inst_69982)){
var statearr_70111_70170 = state_70088__$1;
(statearr_70111_70170[(1)] = (30));

} else {
var statearr_70112_70171 = state_70088__$1;
(statearr_70112_70171[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (25))){
var inst_69983 = (state_70088[(18)]);
var inst_70038 = (state_70088[(2)]);
var inst_70039 = fluree.db.util.async.throw_err.call(null,inst_70038);
var state_70088__$1 = (function (){var statearr_70113 = state_70088;
(statearr_70113[(12)] = inst_70039);

return statearr_70113;
})();
if(cljs.core.truth_(inst_69983)){
var statearr_70114_70172 = state_70088__$1;
(statearr_70114_70172[(1)] = (26));

} else {
var statearr_70115_70173 = state_70088__$1;
(statearr_70115_70173[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (34))){
var inst_69979 = (state_70088[(19)]);
var state_70088__$1 = state_70088;
var statearr_70116_70174 = state_70088__$1;
(statearr_70116_70174[(2)] = inst_69979);

(statearr_70116_70174[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (17))){
var inst_69996 = (state_70088[(8)]);
var inst_69987 = (state_70088[(7)]);
var inst_70010 = (inst_69996 - (1));
var inst_70011 = fluree.db.time_travel.as_of_block.call(null,inst_69987,inst_70010);
var state_70088__$1 = state_70088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70088__$1,(20),inst_70011);
} else {
if((state_val_70089 === (3))){
var inst_70086 = (state_70088[(2)]);
var state_70088__$1 = state_70088;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70088__$1,inst_70086);
} else {
if((state_val_70089 === (12))){
var inst_70075 = cljs.core.pr_str.call(null,query_map);
var inst_70076 = ["History query not properly formatted. Provided ",inst_70075].join('');
var inst_70077 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70078 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70079 = cljs.core.PersistentHashMap.fromArrays(inst_70077,inst_70078);
var inst_70080 = cljs.core.ex_info.call(null,inst_70076,inst_70079);
var inst_70081 = (function(){throw inst_70080})();
var state_70088__$1 = state_70088;
var statearr_70117_70175 = state_70088__$1;
(statearr_70117_70175[(2)] = inst_70081);

(statearr_70117_70175[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (2))){
var _ = (function (){var statearr_70118 = state_70088;
(statearr_70118[(4)] = cljs.core.cons.call(null,(5),(state_70088[(4)])));

return statearr_70118;
})();
var inst_69975 = query_map;
var inst_69976 = cljs.core.__destructure_map.call(null,inst_69975);
var inst_69977 = cljs.core.get.call(null,inst_69976,new cljs.core.Keyword(null,"block","block",664686210));
var inst_69978 = cljs.core.get.call(null,inst_69976,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_69979 = cljs.core.get.call(null,inst_69976,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_69980 = cljs.core.get.call(null,inst_69976,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_69981 = cljs.core.get.call(null,inst_69976,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_69982 = cljs.core.get.call(null,inst_69976,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_69983 = cljs.core.get.call(null,inst_69976,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_69984 = cljs.core.get.call(null,inst_69976,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_70088__$1 = (function (){var statearr_70119 = state_70088;
(statearr_70119[(10)] = inst_69981);

(statearr_70119[(14)] = inst_69980);

(statearr_70119[(16)] = inst_69977);

(statearr_70119[(20)] = inst_69984);

(statearr_70119[(21)] = inst_69978);

(statearr_70119[(18)] = inst_69983);

(statearr_70119[(17)] = inst_69982);

(statearr_70119[(19)] = inst_69979);

return statearr_70119;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70088__$1,(6),sources);
} else {
if((state_val_70089 === (23))){
var inst_69978 = (state_70088[(21)]);
var inst_69987 = (state_70088[(7)]);
var inst_70019 = (state_70088[(22)]);
var inst_70029 = (state_70088[(2)]);
var inst_70030 = fluree.db.api.query.get_history_pattern.call(null,inst_69978);
var inst_70031 = cljs.core.nth.call(null,inst_70030,(0),null);
var inst_70032 = cljs.core.nth.call(null,inst_70030,(1),null);
var inst_70033 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_70034 = [inst_70019,inst_70029];
var inst_70035 = cljs.core.PersistentHashMap.fromArrays(inst_70033,inst_70034);
var inst_70036 = fluree.db.query.range.time_range.call(null,inst_69987,inst_70032,cljs.core._EQ_,inst_70031,inst_70035);
var state_70088__$1 = state_70088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70088__$1,(25),inst_70036);
} else {
if((state_val_70089 === (35))){
var inst_70056 = (state_70088[(2)]);
var state_70088__$1 = state_70088;
if(cljs.core.truth_(inst_70056)){
var statearr_70120_70176 = state_70088__$1;
(statearr_70120_70176[(1)] = (36));

} else {
var statearr_70121_70177 = state_70088__$1;
(statearr_70121_70177[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (19))){
var inst_69997 = (state_70088[(9)]);
var inst_70019 = (state_70088[(2)]);
var state_70088__$1 = (function (){var statearr_70122 = state_70088;
(statearr_70122[(22)] = inst_70019);

return statearr_70122;
})();
if(cljs.core.truth_(inst_69997)){
var statearr_70123_70178 = state_70088__$1;
(statearr_70123_70178[(1)] = (21));

} else {
var statearr_70124_70179 = state_70088__$1;
(statearr_70124_70179[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (11))){
var inst_69996 = (state_70088[(8)]);
var inst_69984 = (state_70088[(20)]);
var inst_70003 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_69984);
var state_70088__$1 = (function (){var statearr_70126 = state_70088;
(statearr_70126[(23)] = inst_70003);

return statearr_70126;
})();
if(cljs.core.truth_(inst_69996)){
var statearr_70127_70180 = state_70088__$1;
(statearr_70127_70180[(1)] = (14));

} else {
var statearr_70128_70181 = state_70088__$1;
(statearr_70128_70181[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (9))){
var inst_69995 = (state_70088[(2)]);
var inst_69996 = cljs.core.nth.call(null,inst_69995,(0),null);
var inst_69997 = cljs.core.nth.call(null,inst_69995,(1),null);
var inst_69998 = cljs.core.contains_QMARK_.call(null,query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_70088__$1 = (function (){var statearr_70129 = state_70088;
(statearr_70129[(8)] = inst_69996);

(statearr_70129[(9)] = inst_69997);

return statearr_70129;
})();
if(inst_69998){
var statearr_70130_70182 = state_70088__$1;
(statearr_70130_70182[(1)] = (11));

} else {
var statearr_70131_70183 = state_70088__$1;
(statearr_70131_70183[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (5))){
var _ = (function (){var statearr_70132 = state_70088;
(statearr_70132[(4)] = cljs.core.rest.call(null,(state_70088[(4)])));

return statearr_70132;
})();
var state_70088__$1 = state_70088;
var ex70125 = (state_70088__$1[(2)]);
var statearr_70133_70184 = state_70088__$1;
(statearr_70133_70184[(5)] = ex70125);


if((ex70125 instanceof Error)){
var statearr_70134_70185 = state_70088__$1;
(statearr_70134_70185[(1)] = (4));

(statearr_70134_70185[(5)] = null);

} else {
throw ex70125;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (14))){
var inst_69996 = (state_70088[(8)]);
var inst_70005 = cljs.core.not_EQ_.call(null,(1),inst_69996);
var state_70088__$1 = state_70088;
var statearr_70135_70186 = state_70088__$1;
(statearr_70135_70186[(2)] = inst_70005);

(statearr_70135_70186[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (26))){
var inst_69983 = (state_70088[(18)]);
var inst_70041 = cljs.core.set.call(null,inst_69983);
var state_70088__$1 = state_70088;
var statearr_70136_70187 = state_70088__$1;
(statearr_70136_70187[(2)] = inst_70041);

(statearr_70136_70187[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (16))){
var inst_70008 = (state_70088[(2)]);
var state_70088__$1 = state_70088;
if(cljs.core.truth_(inst_70008)){
var statearr_70137_70188 = state_70088__$1;
(statearr_70137_70188[(1)] = (17));

} else {
var statearr_70138_70189 = state_70088__$1;
(statearr_70138_70189[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (38))){
var inst_70003 = (state_70088[(23)]);
var inst_70065 = (state_70088[(2)]);
var state_70088__$1 = (function (){var statearr_70139 = state_70088;
(statearr_70139[(13)] = inst_70065);

return statearr_70139;
})();
if(cljs.core.truth_(inst_70003)){
var statearr_70140_70190 = state_70088__$1;
(statearr_70140_70190[(1)] = (40));

} else {
var statearr_70141_70191 = state_70088__$1;
(statearr_70141_70191[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (30))){
var inst_69982 = (state_70088[(17)]);
var state_70088__$1 = state_70088;
var statearr_70142_70192 = state_70088__$1;
(statearr_70142_70192[(2)] = inst_69982);

(statearr_70142_70192[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (10))){
var inst_69991 = (state_70088[(2)]);
var inst_69992 = fluree.db.util.async.throw_err.call(null,inst_69991);
var state_70088__$1 = state_70088;
var statearr_70143_70193 = state_70088__$1;
(statearr_70143_70193[(2)] = inst_69992);

(statearr_70143_70193[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (18))){
var state_70088__$1 = state_70088;
var statearr_70144_70194 = state_70088__$1;
(statearr_70144_70194[(2)] = (-1));

(statearr_70144_70194[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (42))){
var inst_70073 = (state_70088[(2)]);
var state_70088__$1 = state_70088;
var statearr_70145_70195 = state_70088__$1;
(statearr_70145_70195[(2)] = inst_70073);

(statearr_70145_70195[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (37))){
var inst_70052 = (state_70088[(15)]);
var inst_70063 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_70052);
var state_70088__$1 = state_70088;
var statearr_70146_70196 = state_70088__$1;
(statearr_70146_70196[(2)] = inst_70063);

(statearr_70146_70196[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70089 === (8))){
var state_70088__$1 = state_70088;
var statearr_70147_70197 = state_70088__$1;
(statearr_70147_70197[(2)] = null);

(statearr_70147_70197[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_70148 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70148[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2727__auto__);

(statearr_70148[(1)] = (1));

return statearr_70148;
});
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1 = (function (state_70088){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_70088);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70149){var ex__2730__auto__ = e70149;
var statearr_70150_70198 = state_70088;
(statearr_70150_70198[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_70088[(4)]))){
var statearr_70151_70199 = state_70088;
(statearr_70151_70199[(1)] = cljs.core.first.call(null,(state_70088[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70200 = state_70088;
state_70088 = G__70200;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = function(state_70088){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1.call(this,state_70088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70152 = f__2750__auto__.call(null);
(statearr_70152[(6)] = c__2749__auto__);

return statearr_70152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70333){
var state_val_70334 = (state_70333[(1)]);
if((state_val_70334 === (7))){
var inst_70230 = cljs.core.pr_str.call(null,flureeQL);
var inst_70231 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_70230].join('');
var inst_70232 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70233 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70234 = cljs.core.PersistentHashMap.fromArrays(inst_70232,inst_70233);
var inst_70235 = cljs.core.ex_info.call(null,inst_70231,inst_70234);
var inst_70236 = (function(){throw inst_70235})();
var state_70333__$1 = state_70333;
var statearr_70335_70414 = state_70333__$1;
(statearr_70335_70414[(2)] = inst_70236);

(statearr_70335_70414[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (20))){
var inst_70268 = (state_70333[(2)]);
var state_70333__$1 = state_70333;
if(cljs.core.truth_(inst_70268)){
var statearr_70336_70415 = state_70333__$1;
(statearr_70336_70415[(1)] = (21));

} else {
var statearr_70337_70416 = state_70333__$1;
(statearr_70337_70416[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (27))){
var inst_70212 = (state_70333[(7)]);
var state_70333__$1 = state_70333;
var statearr_70338_70417 = state_70333__$1;
(statearr_70338_70417[(2)] = inst_70212);

(statearr_70338_70417[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (1))){
var state_70333__$1 = state_70333;
var statearr_70339_70418 = state_70333__$1;
(statearr_70339_70418[(2)] = null);

(statearr_70339_70418[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (24))){
var inst_70274 = (state_70333[(8)]);
var state_70333__$1 = state_70333;
var statearr_70340_70419 = state_70333__$1;
(statearr_70340_70419[(2)] = inst_70274);

(statearr_70340_70419[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (39))){
var inst_70218 = (state_70333[(9)]);
var state_70333__$1 = state_70333;
if(cljs.core.truth_(inst_70218)){
var statearr_70341_70420 = state_70333__$1;
(statearr_70341_70420[(1)] = (42));

} else {
var statearr_70342_70421 = state_70333__$1;
(statearr_70342_70421[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (46))){
var inst_70306 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70307 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70308 = cljs.core.PersistentHashMap.fromArrays(inst_70306,inst_70307);
var inst_70309 = cljs.core.ex_info.call(null,"Invalid query.",inst_70308);
var inst_70310 = (function(){throw inst_70309})();
var state_70333__$1 = state_70333;
var statearr_70343_70422 = state_70333__$1;
(statearr_70343_70422[(2)] = inst_70310);

(statearr_70343_70422[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (4))){
var inst_70202 = (state_70333[(2)]);
var state_70333__$1 = state_70333;
var statearr_70344_70423 = state_70333__$1;
(statearr_70344_70423[(2)] = inst_70202);

(statearr_70344_70423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (15))){
var inst_70215 = (state_70333[(10)]);
var inst_70253 = (state_70333[(11)]);
var inst_70255 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_70253);
var inst_70256 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_70253);
var inst_70257 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_70253);
var inst_70258 = fluree.db.api.query.get_sources.call(null,inst_70255,inst_70256,inst_70257,inst_70215);
var state_70333__$1 = state_70333;
var statearr_70345_70424 = state_70333__$1;
(statearr_70345_70424[(2)] = inst_70258);

(statearr_70345_70424[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (48))){
var inst_70263 = (state_70333[(12)]);
var inst_70317 = (state_70333[(2)]);
var inst_70318 = fluree.db.util.async.throw_err.call(null,inst_70317);
var state_70333__$1 = (function (){var statearr_70346 = state_70333;
(statearr_70346[(13)] = inst_70318);

return statearr_70346;
})();
if(cljs.core.truth_(inst_70263)){
var statearr_70347_70425 = state_70333__$1;
(statearr_70347_70425[(1)] = (49));

} else {
var statearr_70348_70426 = state_70333__$1;
(statearr_70348_70426[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (50))){
var inst_70318 = (state_70333[(13)]);
var state_70333__$1 = state_70333;
var statearr_70349_70427 = state_70333__$1;
(statearr_70349_70427[(2)] = inst_70318);

(statearr_70349_70427[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (21))){
var inst_70270 = cljs.core.volatile_BANG_.call(null,(0));
var state_70333__$1 = state_70333;
var statearr_70350_70428 = state_70333__$1;
(statearr_70350_70428[(2)] = inst_70270);

(statearr_70350_70428[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (31))){
var inst_70216 = (state_70333[(14)]);
var state_70333__$1 = state_70333;
if(cljs.core.truth_(inst_70216)){
var statearr_70351_70429 = state_70333__$1;
(statearr_70351_70429[(1)] = (33));

} else {
var statearr_70352_70430 = state_70333__$1;
(statearr_70352_70430[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (32))){
var inst_70293 = (state_70333[(2)]);
var state_70333__$1 = state_70333;
var statearr_70353_70431 = state_70333__$1;
(statearr_70353_70431[(2)] = inst_70293);

(statearr_70353_70431[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (40))){
var inst_70295 = (state_70333[(15)]);
var state_70333__$1 = state_70333;
var statearr_70354_70432 = state_70333__$1;
(statearr_70354_70432[(2)] = inst_70295);

(statearr_70354_70432[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (33))){
var inst_70216 = (state_70333[(14)]);
var state_70333__$1 = state_70333;
var statearr_70355_70433 = state_70333__$1;
(statearr_70355_70433[(2)] = inst_70216);

(statearr_70355_70433[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (13))){
var inst_70213 = (state_70333[(16)]);
var inst_70242 = (state_70333[(2)]);
var inst_70243 = fluree.db.util.async.throw_err.call(null,inst_70242);
var inst_70244 = fluree.db.time_travel.as_of_block.call(null,inst_70243,inst_70213);
var state_70333__$1 = state_70333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70333__$1,(12),inst_70244);
} else {
if((state_val_70334 === (22))){
var state_70333__$1 = state_70333;
var statearr_70356_70434 = state_70333__$1;
(statearr_70356_70434[(2)] = null);

(statearr_70356_70434[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (36))){
var inst_70220 = (state_70333[(17)]);
var state_70333__$1 = state_70333;
var statearr_70357_70435 = state_70333__$1;
(statearr_70357_70435[(2)] = inst_70220);

(statearr_70357_70435[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (41))){
var inst_70303 = (state_70333[(2)]);
var state_70333__$1 = state_70333;
if(cljs.core.truth_(inst_70303)){
var statearr_70358_70436 = state_70333__$1;
(statearr_70358_70436[(1)] = (45));

} else {
var statearr_70359_70437 = state_70333__$1;
(statearr_70359_70437[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (43))){
var inst_70214 = (state_70333[(18)]);
var state_70333__$1 = state_70333;
var statearr_70360_70438 = state_70333__$1;
(statearr_70360_70438[(2)] = inst_70214);

(statearr_70360_70438[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (29))){
var inst_70295 = (state_70333[(15)]);
var inst_70295__$1 = (state_70333[(2)]);
var state_70333__$1 = (function (){var statearr_70361 = state_70333;
(statearr_70361[(15)] = inst_70295__$1);

return statearr_70361;
})();
if(cljs.core.truth_(inst_70295__$1)){
var statearr_70362_70439 = state_70333__$1;
(statearr_70362_70439[(1)] = (39));

} else {
var statearr_70363_70440 = state_70333__$1;
(statearr_70363_70440[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (44))){
var inst_70300 = (state_70333[(2)]);
var state_70333__$1 = state_70333;
var statearr_70364_70441 = state_70333__$1;
(statearr_70364_70441[(2)] = inst_70300);

(statearr_70364_70441[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (6))){
var state_70333__$1 = state_70333;
var statearr_70365_70442 = state_70333__$1;
(statearr_70365_70442[(2)] = null);

(statearr_70365_70442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (28))){
var inst_70217 = (state_70333[(19)]);
var state_70333__$1 = state_70333;
if(cljs.core.truth_(inst_70217)){
var statearr_70366_70443 = state_70333__$1;
(statearr_70366_70443[(1)] = (30));

} else {
var statearr_70367_70444 = state_70333__$1;
(statearr_70367_70444[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (51))){
var inst_70328 = (state_70333[(2)]);
var _ = (function (){var statearr_70368 = state_70333;
(statearr_70368[(4)] = cljs.core.rest.call(null,(state_70333[(4)])));

return statearr_70368;
})();
var state_70333__$1 = state_70333;
var statearr_70369_70445 = state_70333__$1;
(statearr_70369_70445[(2)] = inst_70328);

(statearr_70369_70445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (25))){
var state_70333__$1 = state_70333;
var statearr_70370_70446 = state_70333__$1;
(statearr_70370_70446[(2)] = (1000000));

(statearr_70370_70446[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (34))){
var inst_70220 = (state_70333[(17)]);
var state_70333__$1 = state_70333;
if(cljs.core.truth_(inst_70220)){
var statearr_70371_70447 = state_70333__$1;
(statearr_70371_70447[(1)] = (36));

} else {
var statearr_70372_70448 = state_70333__$1;
(statearr_70372_70448[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (17))){
var inst_70264 = (state_70333[(20)]);
var inst_70219 = (state_70333[(21)]);
var inst_70262 = (state_70333[(2)]);
var inst_70263 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_70219);
var inst_70264__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_70219);
var state_70333__$1 = (function (){var statearr_70373 = state_70333;
(statearr_70373[(20)] = inst_70264__$1);

(statearr_70373[(12)] = inst_70263);

(statearr_70373[(22)] = inst_70262);

return statearr_70373;
})();
if(cljs.core.truth_(inst_70264__$1)){
var statearr_70374_70449 = state_70333__$1;
(statearr_70374_70449[(1)] = (18));

} else {
var statearr_70375_70450 = state_70333__$1;
(statearr_70375_70450[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (3))){
var inst_70331 = (state_70333[(2)]);
var state_70333__$1 = state_70333;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70333__$1,inst_70331);
} else {
if((state_val_70334 === (12))){
var inst_70246 = (state_70333[(2)]);
var inst_70247 = fluree.db.util.async.throw_err.call(null,inst_70246);
var state_70333__$1 = state_70333;
var statearr_70376_70451 = state_70333__$1;
(statearr_70376_70451[(2)] = inst_70247);

(statearr_70376_70451[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (2))){
var inst_70218 = (state_70333[(9)]);
var inst_70215 = (state_70333[(10)]);
var inst_70211 = (state_70333[(23)]);
var inst_70219 = (state_70333[(21)]);
var inst_70220 = (state_70333[(17)]);
var inst_70216 = (state_70333[(14)]);
var inst_70217 = (state_70333[(19)]);
var inst_70212 = (state_70333[(7)]);
var inst_70214 = (state_70333[(18)]);
var inst_70213 = (state_70333[(16)]);
var _ = (function (){var statearr_70377 = state_70333;
(statearr_70377[(4)] = cljs.core.cons.call(null,(5),(state_70333[(4)])));

return statearr_70377;
})();
var inst_70209 = flureeQL;
var inst_70210 = cljs.core.__destructure_map.call(null,inst_70209);
var inst_70211__$1 = cljs.core.get.call(null,inst_70210,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_70212__$1 = cljs.core.get.call(null,inst_70210,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_70213__$1 = cljs.core.get.call(null,inst_70210,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70214__$1 = cljs.core.get.call(null,inst_70210,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_70215__$1 = cljs.core.get.call(null,inst_70210,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_70216__$1 = cljs.core.get.call(null,inst_70210,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_70217__$1 = cljs.core.get.call(null,inst_70210,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_70218__$1 = cljs.core.get.call(null,inst_70210,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_70219__$1 = cljs.core.get.call(null,inst_70210,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_70220__$1 = cljs.core.get.call(null,inst_70210,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_70221 = (function (){var construct = inst_70211__$1;
var select = inst_70212__$1;
var block = inst_70213__$1;
var where = inst_70214__$1;
var prefixes = inst_70215__$1;
var map__70208 = inst_70210;
var selectDistinct = inst_70216__$1;
var selectOne = inst_70217__$1;
var from = inst_70218__$1;
var opts = inst_70219__$1;
var selectReduced = inst_70220__$1;
return (function (p1__70201_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__70201_SHARP_);
});
})();
var inst_70222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70223 = [inst_70212__$1,inst_70217__$1,inst_70216__$1,inst_70220__$1];
var inst_70224 = (new cljs.core.PersistentVector(null,4,(5),inst_70222,inst_70223,null));
var inst_70225 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_70224);
var inst_70226 = cljs.core.count.call(null,inst_70225);
var inst_70227 = inst_70221.call(null,inst_70226);
var state_70333__$1 = (function (){var statearr_70378 = state_70333;
(statearr_70378[(9)] = inst_70218__$1);

(statearr_70378[(10)] = inst_70215__$1);

(statearr_70378[(23)] = inst_70211__$1);

(statearr_70378[(21)] = inst_70219__$1);

(statearr_70378[(17)] = inst_70220__$1);

(statearr_70378[(14)] = inst_70216__$1);

(statearr_70378[(19)] = inst_70217__$1);

(statearr_70378[(7)] = inst_70212__$1);

(statearr_70378[(18)] = inst_70214__$1);

(statearr_70378[(16)] = inst_70213__$1);

return statearr_70378;
})();
if(cljs.core.truth_(inst_70227)){
var statearr_70379_70452 = state_70333__$1;
(statearr_70379_70452[(1)] = (6));

} else {
var statearr_70380_70453 = state_70333__$1;
(statearr_70380_70453[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (23))){
var inst_70219 = (state_70333[(21)]);
var inst_70274 = (state_70333[(8)]);
var inst_70273 = (state_70333[(2)]);
var inst_70274__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_70219);
var state_70333__$1 = (function (){var statearr_70381 = state_70333;
(statearr_70381[(24)] = inst_70273);

(statearr_70381[(8)] = inst_70274__$1);

return statearr_70381;
})();
if(cljs.core.truth_(inst_70274__$1)){
var statearr_70382_70454 = state_70333__$1;
(statearr_70382_70454[(1)] = (24));

} else {
var statearr_70383_70455 = state_70333__$1;
(statearr_70383_70455[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (47))){
var inst_70279 = (state_70333[(25)]);
var inst_70253 = (state_70333[(11)]);
var inst_70312 = (state_70333[(2)]);
var inst_70313 = fluree.db.util.core.current_time_millis.call(null);
var inst_70314 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_70279);
var inst_70315 = fluree.db.query.fql.query.call(null,inst_70253,inst_70314);
var state_70333__$1 = (function (){var statearr_70384 = state_70333;
(statearr_70384[(26)] = inst_70313);

(statearr_70384[(27)] = inst_70312);

return statearr_70384;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70333__$1,(48),inst_70315);
} else {
if((state_val_70334 === (35))){
var inst_70291 = (state_70333[(2)]);
var state_70333__$1 = state_70333;
var statearr_70385_70456 = state_70333__$1;
(statearr_70385_70456[(2)] = inst_70291);

(statearr_70385_70456[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (19))){
var inst_70263 = (state_70333[(12)]);
var state_70333__$1 = state_70333;
var statearr_70386_70457 = state_70333__$1;
(statearr_70386_70457[(2)] = inst_70263);

(statearr_70386_70457[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (11))){
var inst_70215 = (state_70333[(10)]);
var inst_70253 = (state_70333[(2)]);
var state_70333__$1 = (function (){var statearr_70388 = state_70333;
(statearr_70388[(11)] = inst_70253);

return statearr_70388;
})();
if(cljs.core.truth_(inst_70215)){
var statearr_70389_70458 = state_70333__$1;
(statearr_70389_70458[(1)] = (15));

} else {
var statearr_70390_70459 = state_70333__$1;
(statearr_70390_70459[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (9))){
var inst_70239 = (state_70333[(28)]);
var state_70333__$1 = state_70333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70333__$1,(13),inst_70239);
} else {
if((state_val_70334 === (5))){
var _ = (function (){var statearr_70391 = state_70333;
(statearr_70391[(4)] = cljs.core.rest.call(null,(state_70333[(4)])));

return statearr_70391;
})();
var state_70333__$1 = state_70333;
var ex70387 = (state_70333__$1[(2)]);
var statearr_70392_70460 = state_70333__$1;
(statearr_70392_70460[(5)] = ex70387);


if((ex70387 instanceof Error)){
var statearr_70393_70461 = state_70333__$1;
(statearr_70393_70461[(1)] = (4));

(statearr_70393_70461[(5)] = null);

} else {
throw ex70387;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (14))){
var inst_70250 = (state_70333[(2)]);
var inst_70251 = fluree.db.util.async.throw_err.call(null,inst_70250);
var state_70333__$1 = state_70333;
var statearr_70394_70462 = state_70333__$1;
(statearr_70394_70462[(2)] = inst_70251);

(statearr_70394_70462[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (45))){
var state_70333__$1 = state_70333;
var statearr_70395_70463 = state_70333__$1;
(statearr_70395_70463[(2)] = null);

(statearr_70395_70463[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (26))){
var inst_70219 = (state_70333[(21)]);
var inst_70273 = (state_70333[(24)]);
var inst_70262 = (state_70333[(22)]);
var inst_70212 = (state_70333[(7)]);
var inst_70278 = (state_70333[(2)]);
var inst_70279 = cljs.core.assoc.call(null,inst_70219,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_70262,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_70278,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_70273);
var state_70333__$1 = (function (){var statearr_70396 = state_70333;
(statearr_70396[(25)] = inst_70279);

return statearr_70396;
})();
if(cljs.core.truth_(inst_70212)){
var statearr_70397_70464 = state_70333__$1;
(statearr_70397_70464[(1)] = (27));

} else {
var statearr_70398_70465 = state_70333__$1;
(statearr_70398_70465[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (16))){
var inst_70260 = cljs.core.PersistentHashMap.EMPTY;
var state_70333__$1 = state_70333;
var statearr_70399_70466 = state_70333__$1;
(statearr_70399_70466[(2)] = inst_70260);

(statearr_70399_70466[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (38))){
var inst_70289 = (state_70333[(2)]);
var state_70333__$1 = state_70333;
var statearr_70400_70467 = state_70333__$1;
(statearr_70400_70467[(2)] = inst_70289);

(statearr_70400_70467[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (30))){
var inst_70217 = (state_70333[(19)]);
var state_70333__$1 = state_70333;
var statearr_70401_70468 = state_70333__$1;
(statearr_70401_70468[(2)] = inst_70217);

(statearr_70401_70468[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (10))){
var inst_70239 = (state_70333[(28)]);
var state_70333__$1 = state_70333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70333__$1,(14),inst_70239);
} else {
if((state_val_70334 === (18))){
var inst_70264 = (state_70333[(20)]);
var state_70333__$1 = state_70333;
var statearr_70402_70469 = state_70333__$1;
(statearr_70402_70469[(2)] = inst_70264);

(statearr_70402_70469[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (42))){
var inst_70218 = (state_70333[(9)]);
var state_70333__$1 = state_70333;
var statearr_70403_70470 = state_70333__$1;
(statearr_70403_70470[(2)] = inst_70218);

(statearr_70403_70470[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (37))){
var inst_70211 = (state_70333[(23)]);
var state_70333__$1 = state_70333;
var statearr_70404_70471 = state_70333__$1;
(statearr_70404_70471[(2)] = inst_70211);

(statearr_70404_70471[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (8))){
var inst_70213 = (state_70333[(16)]);
var inst_70238 = (state_70333[(2)]);
var inst_70239 = sources;
var state_70333__$1 = (function (){var statearr_70405 = state_70333;
(statearr_70405[(29)] = inst_70238);

(statearr_70405[(28)] = inst_70239);

return statearr_70405;
})();
if(cljs.core.truth_(inst_70213)){
var statearr_70406_70472 = state_70333__$1;
(statearr_70406_70472[(1)] = (9));

} else {
var statearr_70407_70473 = state_70333__$1;
(statearr_70407_70473[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70334 === (49))){
var inst_70318 = (state_70333[(13)]);
var inst_70253 = (state_70333[(11)]);
var inst_70273 = (state_70333[(24)]);
var inst_70313 = (state_70333[(26)]);
var inst_70320 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70321 = cljs.core.deref.call(null,inst_70273);
var inst_70322 = fluree.db.util.core.response_time_formatted.call(null,inst_70313);
var inst_70323 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_70253);
var inst_70324 = [(200),inst_70318,inst_70321,inst_70322,inst_70323];
var inst_70325 = cljs.core.PersistentHashMap.fromArrays(inst_70320,inst_70324);
var state_70333__$1 = state_70333;
var statearr_70408_70474 = state_70333__$1;
(statearr_70408_70474[(2)] = inst_70325);

(statearr_70408_70474[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_70409 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70409[(0)] = fluree$db$api$query$query_async_$_state_machine__2727__auto__);

(statearr_70409[(1)] = (1));

return statearr_70409;
});
var fluree$db$api$query$query_async_$_state_machine__2727__auto____1 = (function (state_70333){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_70333);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70410){var ex__2730__auto__ = e70410;
var statearr_70411_70475 = state_70333;
(statearr_70411_70475[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_70333[(4)]))){
var statearr_70412_70476 = state_70333;
(statearr_70412_70476[(1)] = cljs.core.first.call(null,(state_70333[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70477 = state_70333;
state_70333 = G__70477;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2727__auto__ = function(state_70333){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____1.call(this,state_70333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70413 = f__2750__auto__.call(null);
(statearr_70413[(6)] = c__2749__auto__);

return statearr_70413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70618){
var state_val_70619 = (state_70618[(1)]);
if((state_val_70619 === (7))){
var inst_70613 = (state_70618[(2)]);
var _ = (function (){var statearr_70620 = state_70618;
(statearr_70620[(4)] = cljs.core.rest.call(null,(state_70618[(4)])));

return statearr_70620;
})();
var state_70618__$1 = state_70618;
var statearr_70621_70697 = state_70618__$1;
(statearr_70621_70697[(2)] = inst_70613);

(statearr_70621_70697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (20))){
var inst_70585 = (state_70618[(2)]);
var state_70618__$1 = state_70618;
var statearr_70622_70698 = state_70618__$1;
(statearr_70622_70698[(2)] = inst_70585);

(statearr_70622_70698[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (27))){
var inst_70565 = (state_70618[(7)]);
var state_70618__$1 = state_70618;
var statearr_70623_70699 = state_70618__$1;
(statearr_70623_70699[(2)] = inst_70565);

(statearr_70623_70699[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (1))){
var state_70618__$1 = state_70618;
var statearr_70624_70700 = state_70618__$1;
(statearr_70624_70700[(2)] = null);

(statearr_70624_70700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (24))){
var inst_70562 = (state_70618[(8)]);
var state_70618__$1 = state_70618;
var statearr_70625_70701 = state_70618__$1;
(statearr_70625_70701[(2)] = inst_70562);

(statearr_70625_70701[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (39))){
var inst_70552 = (state_70618[(9)]);
var inst_70519 = (state_70618[(10)]);
var inst_70530 = (state_70618[(11)]);
var inst_70596 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70597 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_70530];
var inst_70598 = (new cljs.core.PersistentVector(null,2,(5),inst_70596,inst_70597,null));
var inst_70599 = cljs.core.assoc_in.call(null,inst_70519,inst_70598,inst_70552);
var state_70618__$1 = state_70618;
var statearr_70626_70702 = state_70618__$1;
(statearr_70626_70702[(2)] = inst_70599);

(statearr_70626_70702[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (4))){
var inst_70478 = (state_70618[(2)]);
var state_70618__$1 = state_70618;
var statearr_70627_70703 = state_70618__$1;
(statearr_70627_70703[(2)] = inst_70478);

(statearr_70627_70703[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (15))){
var inst_70552 = (state_70618[(9)]);
var inst_70517 = (state_70618[(12)]);
var inst_70555 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_70552);
var inst_70556 = (inst_70517 == null);
var state_70618__$1 = (function (){var statearr_70628 = state_70618;
(statearr_70628[(13)] = inst_70555);

return statearr_70628;
})();
if(cljs.core.truth_(inst_70556)){
var statearr_70629_70704 = state_70618__$1;
(statearr_70629_70704[(1)] = (18));

} else {
var statearr_70630_70705 = state_70618__$1;
(statearr_70630_70705[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (21))){
var inst_70555 = (state_70618[(13)]);
var state_70618__$1 = state_70618;
var statearr_70631_70706 = state_70618__$1;
(statearr_70631_70706[(2)] = inst_70555);

(statearr_70631_70706[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (31))){
var state_70618__$1 = state_70618;
var statearr_70632_70707 = state_70618__$1;
(statearr_70632_70707[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (32))){
var inst_70581 = (state_70618[(2)]);
var state_70618__$1 = state_70618;
var statearr_70634_70708 = state_70618__$1;
(statearr_70634_70708[(2)] = inst_70581);

(statearr_70634_70708[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (40))){
var inst_70550 = (state_70618[(14)]);
var state_70618__$1 = state_70618;
if(cljs.core.truth_(inst_70550)){
var statearr_70635_70709 = state_70618__$1;
(statearr_70635_70709[(1)] = (42));

} else {
var statearr_70636_70710 = state_70618__$1;
(statearr_70636_70710[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (33))){
var inst_70517 = (state_70618[(12)]);
var inst_70555 = (state_70618[(13)]);
var inst_70576 = ((inst_70555 > inst_70517) ? inst_70555 : inst_70517);
var state_70618__$1 = state_70618;
var statearr_70637_70711 = state_70618__$1;
(statearr_70637_70711[(2)] = inst_70576);

(statearr_70637_70711[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (13))){
var inst_70541 = (state_70618[(2)]);
var state_70618__$1 = state_70618;
var statearr_70638_70712 = state_70618__$1;
(statearr_70638_70712[(2)] = inst_70541);

(statearr_70638_70712[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (22))){
var inst_70562 = (state_70618[(8)]);
var inst_70555 = (state_70618[(13)]);
var inst_70562__$1 = cljs.core._EQ_.call(null,(200),inst_70555);
var state_70618__$1 = (function (){var statearr_70639 = state_70618;
(statearr_70639[(8)] = inst_70562__$1);

return statearr_70639;
})();
if(inst_70562__$1){
var statearr_70640_70713 = state_70618__$1;
(statearr_70640_70713[(1)] = (24));

} else {
var statearr_70641_70714 = state_70618__$1;
(statearr_70641_70714[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (36))){
var inst_70552 = (state_70618[(9)]);
var inst_70518 = (state_70618[(15)]);
var inst_70590 = cljs.core.get.call(null,inst_70552,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_70591 = (inst_70518 + inst_70590);
var state_70618__$1 = state_70618;
var statearr_70642_70715 = state_70618__$1;
(statearr_70642_70715[(2)] = inst_70591);

(statearr_70642_70715[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (41))){
var inst_70594 = (state_70618[(16)]);
var inst_70588 = (state_70618[(17)]);
var inst_70529 = (state_70618[(18)]);
var inst_70608 = (state_70618[(2)]);
var inst_70516 = inst_70529;
var inst_70517 = inst_70588;
var inst_70518 = inst_70594;
var inst_70519 = inst_70608;
var state_70618__$1 = (function (){var statearr_70643 = state_70618;
(statearr_70643[(15)] = inst_70518);

(statearr_70643[(12)] = inst_70517);

(statearr_70643[(10)] = inst_70519);

(statearr_70643[(19)] = inst_70516);

return statearr_70643;
})();
var statearr_70644_70716 = state_70618__$1;
(statearr_70644_70716[(2)] = null);

(statearr_70644_70716[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (43))){
var inst_70552 = (state_70618[(9)]);
var state_70618__$1 = state_70618;
var statearr_70645_70717 = state_70618__$1;
(statearr_70645_70717[(2)] = inst_70552);

(statearr_70645_70717[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (29))){
var inst_70570 = (state_70618[(2)]);
var state_70618__$1 = state_70618;
var statearr_70646_70718 = state_70618__$1;
(statearr_70646_70718[(2)] = inst_70570);

(statearr_70646_70718[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (44))){
var inst_70519 = (state_70618[(10)]);
var inst_70530 = (state_70618[(11)]);
var inst_70605 = (state_70618[(2)]);
var inst_70606 = cljs.core.assoc.call(null,inst_70519,inst_70530,inst_70605);
var state_70618__$1 = state_70618;
var statearr_70647_70719 = state_70618__$1;
(statearr_70647_70719[(2)] = inst_70606);

(statearr_70647_70719[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (6))){
var inst_70531 = (state_70618[(20)]);
var inst_70516 = (state_70618[(19)]);
var inst_70527 = cljs.core.seq.call(null,inst_70516);
var inst_70528 = cljs.core.first.call(null,inst_70527);
var inst_70529 = cljs.core.next.call(null,inst_70527);
var inst_70530 = cljs.core.nth.call(null,inst_70528,(0),null);
var inst_70531__$1 = cljs.core.nth.call(null,inst_70528,(1),null);
var inst_70532 = (inst_70531__$1 == null);
var state_70618__$1 = (function (){var statearr_70648 = state_70618;
(statearr_70648[(20)] = inst_70531__$1);

(statearr_70648[(18)] = inst_70529);

(statearr_70648[(11)] = inst_70530);

return statearr_70648;
})();
if(cljs.core.truth_(inst_70532)){
var statearr_70649_70720 = state_70618__$1;
(statearr_70649_70720[(1)] = (8));

} else {
var statearr_70650_70721 = state_70618__$1;
(statearr_70650_70721[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (28))){
var inst_70517 = (state_70618[(12)]);
var inst_70568 = cljs.core._EQ_.call(null,(207),inst_70517);
var state_70618__$1 = state_70618;
var statearr_70651_70722 = state_70618__$1;
(statearr_70651_70722[(2)] = inst_70568);

(statearr_70651_70722[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (25))){
var inst_70565 = (state_70618[(7)]);
var inst_70517 = (state_70618[(12)]);
var inst_70565__$1 = cljs.core._EQ_.call(null,(200),inst_70517);
var state_70618__$1 = (function (){var statearr_70652 = state_70618;
(statearr_70652[(7)] = inst_70565__$1);

return statearr_70652;
})();
if(inst_70565__$1){
var statearr_70653_70723 = state_70618__$1;
(statearr_70653_70723[(1)] = (27));

} else {
var statearr_70654_70724 = state_70618__$1;
(statearr_70654_70724[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (34))){
var state_70618__$1 = state_70618;
var statearr_70655_70725 = state_70618__$1;
(statearr_70655_70725[(2)] = null);

(statearr_70655_70725[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (17))){
var inst_70549 = (state_70618[(21)]);
var inst_70588 = (state_70618[(2)]);
var state_70618__$1 = (function (){var statearr_70656 = state_70618;
(statearr_70656[(17)] = inst_70588);

return statearr_70656;
})();
if(cljs.core.truth_(inst_70549)){
var statearr_70657_70726 = state_70618__$1;
(statearr_70657_70726[(1)] = (36));

} else {
var statearr_70658_70727 = state_70618__$1;
(statearr_70658_70727[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (3))){
var inst_70616 = (state_70618[(2)]);
var state_70618__$1 = state_70618;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70618__$1,inst_70616);
} else {
if((state_val_70619 === (12))){
var inst_70519 = (state_70618[(10)]);
var state_70618__$1 = state_70618;
var statearr_70659_70728 = state_70618__$1;
(statearr_70659_70728[(2)] = inst_70519);

(statearr_70659_70728[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (2))){
var inst_70488 = (state_70618[(22)]);
var inst_70493 = (state_70618[(23)]);
var inst_70492 = (state_70618[(24)]);
var _ = (function (){var statearr_70660 = state_70618;
(statearr_70660[(4)] = cljs.core.cons.call(null,(5),(state_70618[(4)])));

return statearr_70660;
})();
var inst_70484 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_70485 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70486 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_70487 = (new cljs.core.PersistentVector(null,2,(5),inst_70485,inst_70486,null));
var inst_70488__$1 = cljs.core.get_in.call(null,flureeQL,inst_70487);
var inst_70489 = (function (){var global_block = inst_70484;
var global_meta_QMARK_ = inst_70488__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4253__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4251__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__4251__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_70490 = cljs.core.PersistentHashMap.EMPTY;
var inst_70491 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_70492__$1 = cljs.core.reduce_kv.call(null,inst_70489,inst_70490,inst_70491);
var inst_70493__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_70495 = (function (){var global_block = inst_70484;
var global_meta_QMARK_ = inst_70488__$1;
var queries = inst_70492__$1;
var start_time = inst_70493__$1;
return (function (p__70494){
var vec__70661 = p__70494;
var alias = cljs.core.nth.call(null,vec__70661,(0),null);
var q = cljs.core.nth.call(null,vec__70661,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_70496 = cljs.core.map.call(null,inst_70495,inst_70492__$1);
var inst_70510 = cljs.core.seq.call(null,inst_70496);
var inst_70511 = cljs.core.first.call(null,inst_70510);
var inst_70512 = cljs.core.next.call(null,inst_70510);
var inst_70513 = cljs.core.nth.call(null,inst_70511,(0),null);
var inst_70514 = cljs.core.nth.call(null,inst_70511,(1),null);
var inst_70515 = cljs.core.PersistentHashMap.EMPTY;
var inst_70516 = inst_70496;
var inst_70517 = null;
var inst_70518 = (0);
var inst_70519 = inst_70515;
var state_70618__$1 = (function (){var statearr_70664 = state_70618;
(statearr_70664[(22)] = inst_70488__$1);

(statearr_70664[(25)] = inst_70513);

(statearr_70664[(23)] = inst_70493__$1);

(statearr_70664[(15)] = inst_70518);

(statearr_70664[(12)] = inst_70517);

(statearr_70664[(26)] = inst_70512);

(statearr_70664[(10)] = inst_70519);

(statearr_70664[(24)] = inst_70492__$1);

(statearr_70664[(19)] = inst_70516);

(statearr_70664[(27)] = inst_70514);

return statearr_70664;
})();
var statearr_70665_70729 = state_70618__$1;
(statearr_70665_70729[(2)] = null);

(statearr_70665_70729[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (23))){
var inst_70583 = (state_70618[(2)]);
var state_70618__$1 = state_70618;
var statearr_70666_70730 = state_70618__$1;
(statearr_70666_70730[(2)] = inst_70583);

(statearr_70666_70730[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (35))){
var inst_70579 = (state_70618[(2)]);
var state_70618__$1 = state_70618;
var statearr_70667_70731 = state_70618__$1;
(statearr_70667_70731[(2)] = inst_70579);

(statearr_70667_70731[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (19))){
var inst_70517 = (state_70618[(12)]);
var inst_70555 = (state_70618[(13)]);
var inst_70559 = cljs.core._EQ_.call(null,inst_70517,inst_70555);
var state_70618__$1 = state_70618;
if(inst_70559){
var statearr_70668_70732 = state_70618__$1;
(statearr_70668_70732[(1)] = (21));

} else {
var statearr_70669_70733 = state_70618__$1;
(statearr_70669_70733[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (11))){
var inst_70493 = (state_70618[(23)]);
var inst_70518 = (state_70618[(15)]);
var inst_70517 = (state_70618[(12)]);
var inst_70519 = (state_70618[(10)]);
var inst_70535 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_70536 = fluree.db.util.core.response_time_formatted.call(null,inst_70493);
var inst_70537 = [inst_70519,inst_70518,inst_70517,inst_70536];
var inst_70538 = cljs.core.PersistentHashMap.fromArrays(inst_70535,inst_70537);
var state_70618__$1 = state_70618;
var statearr_70671_70734 = state_70618__$1;
(statearr_70671_70734[(2)] = inst_70538);

(statearr_70671_70734[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (9))){
var inst_70531 = (state_70618[(20)]);
var inst_70492 = (state_70618[(24)]);
var inst_70530 = (state_70618[(11)]);
var inst_70544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70545 = [inst_70530,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_70546 = (new cljs.core.PersistentVector(null,2,(5),inst_70544,inst_70545,null));
var inst_70547 = cljs.core.get_in.call(null,inst_70492,inst_70546);
var inst_70548 = cljs.core.__destructure_map.call(null,inst_70547);
var inst_70549 = cljs.core.get.call(null,inst_70548,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_70550 = cljs.core.get.call(null,inst_70548,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_70618__$1 = (function (){var statearr_70672 = state_70618;
(statearr_70672[(21)] = inst_70549);

(statearr_70672[(14)] = inst_70550);

return statearr_70672;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70618__$1,(14),inst_70531);
} else {
if((state_val_70619 === (5))){
var _ = (function (){var statearr_70673 = state_70618;
(statearr_70673[(4)] = cljs.core.rest.call(null,(state_70618[(4)])));

return statearr_70673;
})();
var state_70618__$1 = state_70618;
var ex70670 = (state_70618__$1[(2)]);
var statearr_70674_70735 = state_70618__$1;
(statearr_70674_70735[(5)] = ex70670);


var statearr_70675_70736 = state_70618__$1;
(statearr_70675_70736[(1)] = (4));

(statearr_70675_70736[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (14))){
var inst_70552 = (state_70618[(9)]);
var inst_70549 = (state_70618[(21)]);
var inst_70552__$1 = (state_70618[(2)]);
var inst_70553 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_70552__$1);
var state_70618__$1 = (function (){var statearr_70676 = state_70618;
(statearr_70676[(9)] = inst_70552__$1);

(statearr_70676[(28)] = inst_70553);

return statearr_70676;
})();
if(cljs.core.truth_(inst_70549)){
var statearr_70677_70737 = state_70618__$1;
(statearr_70677_70737[(1)] = (15));

} else {
var statearr_70678_70738 = state_70618__$1;
(statearr_70678_70738[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (26))){
var inst_70572 = (state_70618[(2)]);
var state_70618__$1 = state_70618;
if(cljs.core.truth_(inst_70572)){
var statearr_70679_70739 = state_70618__$1;
(statearr_70679_70739[(1)] = (30));

} else {
var statearr_70680_70740 = state_70618__$1;
(statearr_70680_70740[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (16))){
var state_70618__$1 = state_70618;
var statearr_70681_70741 = state_70618__$1;
(statearr_70681_70741[(2)] = null);

(statearr_70681_70741[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (38))){
var inst_70553 = (state_70618[(28)]);
var inst_70594 = (state_70618[(2)]);
var state_70618__$1 = (function (){var statearr_70682 = state_70618;
(statearr_70682[(16)] = inst_70594);

return statearr_70682;
})();
if(cljs.core.truth_(inst_70553)){
var statearr_70683_70742 = state_70618__$1;
(statearr_70683_70742[(1)] = (39));

} else {
var statearr_70684_70743 = state_70618__$1;
(statearr_70684_70743[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (30))){
var state_70618__$1 = state_70618;
var statearr_70685_70744 = state_70618__$1;
(statearr_70685_70744[(2)] = (207));

(statearr_70685_70744[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (10))){
var inst_70611 = (state_70618[(2)]);
var state_70618__$1 = state_70618;
var statearr_70686_70745 = state_70618__$1;
(statearr_70686_70745[(2)] = inst_70611);

(statearr_70686_70745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (18))){
var inst_70555 = (state_70618[(13)]);
var state_70618__$1 = state_70618;
var statearr_70687_70746 = state_70618__$1;
(statearr_70687_70746[(2)] = inst_70555);

(statearr_70687_70746[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (42))){
var inst_70552 = (state_70618[(9)]);
var inst_70602 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_70552);
var state_70618__$1 = state_70618;
var statearr_70688_70747 = state_70618__$1;
(statearr_70688_70747[(2)] = inst_70602);

(statearr_70688_70747[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (37))){
var state_70618__$1 = state_70618;
var statearr_70689_70748 = state_70618__$1;
(statearr_70689_70748[(2)] = null);

(statearr_70689_70748[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70619 === (8))){
var inst_70488 = (state_70618[(22)]);
var state_70618__$1 = state_70618;
if(cljs.core.truth_(inst_70488)){
var statearr_70690_70749 = state_70618__$1;
(statearr_70690_70749[(1)] = (11));

} else {
var statearr_70691_70750 = state_70618__$1;
(statearr_70691_70750[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_70692 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70692[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__);

(statearr_70692[(1)] = (1));

return statearr_70692;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1 = (function (state_70618){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_70618);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70693){var ex__2730__auto__ = e70693;
var statearr_70694_70751 = state_70618;
(statearr_70694_70751[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_70618[(4)]))){
var statearr_70695_70752 = state_70618;
(statearr_70695_70752[(1)] = cljs.core.first.call(null,(state_70618[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70753 = state_70618;
state_70618 = G__70753;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = function(state_70618){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1.call(this,state_70618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70696 = f__2750__auto__.call(null);
(statearr_70696[(6)] = c__2749__auto__);

return statearr_70696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__70754 = query_type;
var G__70754__$1 = (((G__70754 instanceof cljs.core.Keyword))?G__70754.fqn:null);
switch (G__70754__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__70754__$1)].join('')));

}
});
