// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__70796_70977 = cljs.core.seq.call(null,servers);
var chunk__70797_70978 = null;
var count__70798_70979 = (0);
var i__70799_70980 = (0);
while(true){
if((i__70799_70980 < count__70798_70979)){
var server_70981 = cljs.core._nth.call(null,chunk__70797_70978,i__70799_70980);
var healthcheck_uri_70982 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_70981),"/fdb/health"].join('');
var resp_chan_70983 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_70982,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___70984 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__70796_70977,chunk__70797_70978,count__70798_70979,i__70799_70980,c__2749__auto___70984,healthcheck_uri_70982,resp_chan_70983,server_70981){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__70796_70977,chunk__70797_70978,count__70798_70979,i__70799_70980,c__2749__auto___70984,healthcheck_uri_70982,resp_chan_70983,server_70981){
return (function (state_70869){
var state_val_70870 = (state_70869[(1)]);
if((state_val_70870 === (1))){
var state_70869__$1 = state_70869;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70869__$1,(2),resp_chan_70983);
} else {
if((state_val_70870 === (2))){
var inst_70855 = (state_70869[(7)]);
var inst_70855__$1 = (state_70869[(2)]);
var inst_70856 = fluree.db.util.core.exception_QMARK_.call(null,inst_70855__$1);
var state_70869__$1 = (function (){var statearr_70871 = state_70869;
(statearr_70871[(7)] = inst_70855__$1);

return statearr_70871;
})();
if(inst_70856){
var statearr_70872_70985 = state_70869__$1;
(statearr_70872_70985[(1)] = (3));

} else {
var statearr_70873_70986 = state_70869__$1;
(statearr_70873_70986[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70870 === (3))){
var inst_70855 = (state_70869[(7)]);
var inst_70858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70859 = cljs.core.ex_message.call(null,inst_70855);
var inst_70860 = cljs.core.ex_data.call(null,inst_70855);
var inst_70861 = ["Server contact error: ",inst_70859,inst_70860];
var inst_70862 = (new cljs.core.PersistentVector(null,3,(5),inst_70858,inst_70861,null));
var inst_70863 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_70862);
var state_70869__$1 = state_70869;
var statearr_70874_70987 = state_70869__$1;
(statearr_70874_70987[(2)] = inst_70863);

(statearr_70874_70987[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70870 === (4))){
var inst_70865 = cljs.core.async.put_BANG_.call(null,promise_chan,server_70981);
var state_70869__$1 = state_70869;
var statearr_70875_70988 = state_70869__$1;
(statearr_70875_70988[(2)] = inst_70865);

(statearr_70875_70988[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70870 === (5))){
var inst_70867 = (state_70869[(2)]);
var state_70869__$1 = state_70869;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70869__$1,inst_70867);
} else {
return null;
}
}
}
}
}
});})(seq__70796_70977,chunk__70797_70978,count__70798_70979,i__70799_70980,c__2749__auto___70984,healthcheck_uri_70982,resp_chan_70983,server_70981))
;
return ((function (seq__70796_70977,chunk__70797_70978,count__70798_70979,i__70799_70980,switch__2726__auto__,c__2749__auto___70984,healthcheck_uri_70982,resp_chan_70983,server_70981){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_70876 = [null,null,null,null,null,null,null,null];
(statearr_70876[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_70876[(1)] = (1));

return statearr_70876;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_70869){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_70869);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70877){var ex__2730__auto__ = e70877;
var statearr_70878_70989 = state_70869;
(statearr_70878_70989[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_70869[(4)]))){
var statearr_70879_70990 = state_70869;
(statearr_70879_70990[(1)] = cljs.core.first.call(null,(state_70869[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70991 = state_70869;
state_70869 = G__70991;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_70869){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_70869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__70796_70977,chunk__70797_70978,count__70798_70979,i__70799_70980,switch__2726__auto__,c__2749__auto___70984,healthcheck_uri_70982,resp_chan_70983,server_70981))
})();
var state__2751__auto__ = (function (){var statearr_70880 = f__2750__auto__.call(null);
(statearr_70880[(6)] = c__2749__auto___70984);

return statearr_70880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
});})(seq__70796_70977,chunk__70797_70978,count__70798_70979,i__70799_70980,c__2749__auto___70984,healthcheck_uri_70982,resp_chan_70983,server_70981))
);



var G__70992 = seq__70796_70977;
var G__70993 = chunk__70797_70978;
var G__70994 = count__70798_70979;
var G__70995 = (i__70799_70980 + (1));
seq__70796_70977 = G__70992;
chunk__70797_70978 = G__70993;
count__70798_70979 = G__70994;
i__70799_70980 = G__70995;
continue;
} else {
var temp__5804__auto___70996 = cljs.core.seq.call(null,seq__70796_70977);
if(temp__5804__auto___70996){
var seq__70796_70997__$1 = temp__5804__auto___70996;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__70796_70997__$1)){
var c__4679__auto___70998 = cljs.core.chunk_first.call(null,seq__70796_70997__$1);
var G__70999 = cljs.core.chunk_rest.call(null,seq__70796_70997__$1);
var G__71000 = c__4679__auto___70998;
var G__71001 = cljs.core.count.call(null,c__4679__auto___70998);
var G__71002 = (0);
seq__70796_70977 = G__70999;
chunk__70797_70978 = G__71000;
count__70798_70979 = G__71001;
i__70799_70980 = G__71002;
continue;
} else {
var server_71003 = cljs.core.first.call(null,seq__70796_70997__$1);
var healthcheck_uri_71004 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_71003),"/fdb/health"].join('');
var resp_chan_71005 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_71004,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___71006 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__70796_70977,chunk__70797_70978,count__70798_70979,i__70799_70980,c__2749__auto___71006,healthcheck_uri_71004,resp_chan_71005,server_71003,seq__70796_70997__$1,temp__5804__auto___70996){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__70796_70977,chunk__70797_70978,count__70798_70979,i__70799_70980,c__2749__auto___71006,healthcheck_uri_71004,resp_chan_71005,server_71003,seq__70796_70997__$1,temp__5804__auto___70996){
return (function (state_70896){
var state_val_70897 = (state_70896[(1)]);
if((state_val_70897 === (1))){
var state_70896__$1 = state_70896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70896__$1,(2),resp_chan_71005);
} else {
if((state_val_70897 === (2))){
var inst_70882 = (state_70896[(7)]);
var inst_70882__$1 = (state_70896[(2)]);
var inst_70883 = fluree.db.util.core.exception_QMARK_.call(null,inst_70882__$1);
var state_70896__$1 = (function (){var statearr_70898 = state_70896;
(statearr_70898[(7)] = inst_70882__$1);

return statearr_70898;
})();
if(inst_70883){
var statearr_70899_71007 = state_70896__$1;
(statearr_70899_71007[(1)] = (3));

} else {
var statearr_70900_71008 = state_70896__$1;
(statearr_70900_71008[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70897 === (3))){
var inst_70882 = (state_70896[(7)]);
var inst_70885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70886 = cljs.core.ex_message.call(null,inst_70882);
var inst_70887 = cljs.core.ex_data.call(null,inst_70882);
var inst_70888 = ["Server contact error: ",inst_70886,inst_70887];
var inst_70889 = (new cljs.core.PersistentVector(null,3,(5),inst_70885,inst_70888,null));
var inst_70890 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_70889);
var state_70896__$1 = state_70896;
var statearr_70901_71009 = state_70896__$1;
(statearr_70901_71009[(2)] = inst_70890);

(statearr_70901_71009[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70897 === (4))){
var inst_70892 = cljs.core.async.put_BANG_.call(null,promise_chan,server_71003);
var state_70896__$1 = state_70896;
var statearr_70902_71010 = state_70896__$1;
(statearr_70902_71010[(2)] = inst_70892);

(statearr_70902_71010[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70897 === (5))){
var inst_70894 = (state_70896[(2)]);
var state_70896__$1 = state_70896;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70896__$1,inst_70894);
} else {
return null;
}
}
}
}
}
});})(seq__70796_70977,chunk__70797_70978,count__70798_70979,i__70799_70980,c__2749__auto___71006,healthcheck_uri_71004,resp_chan_71005,server_71003,seq__70796_70997__$1,temp__5804__auto___70996))
;
return ((function (seq__70796_70977,chunk__70797_70978,count__70798_70979,i__70799_70980,switch__2726__auto__,c__2749__auto___71006,healthcheck_uri_71004,resp_chan_71005,server_71003,seq__70796_70997__$1,temp__5804__auto___70996){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_70903 = [null,null,null,null,null,null,null,null];
(statearr_70903[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_70903[(1)] = (1));

return statearr_70903;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_70896){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_70896);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70904){var ex__2730__auto__ = e70904;
var statearr_70905_71011 = state_70896;
(statearr_70905_71011[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_70896[(4)]))){
var statearr_70906_71012 = state_70896;
(statearr_70906_71012[(1)] = cljs.core.first.call(null,(state_70896[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71013 = state_70896;
state_70896 = G__71013;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_70896){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_70896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__70796_70977,chunk__70797_70978,count__70798_70979,i__70799_70980,switch__2726__auto__,c__2749__auto___71006,healthcheck_uri_71004,resp_chan_71005,server_71003,seq__70796_70997__$1,temp__5804__auto___70996))
})();
var state__2751__auto__ = (function (){var statearr_70907 = f__2750__auto__.call(null);
(statearr_70907[(6)] = c__2749__auto___71006);

return statearr_70907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
});})(seq__70796_70977,chunk__70797_70978,count__70798_70979,i__70799_70980,c__2749__auto___71006,healthcheck_uri_71004,resp_chan_71005,server_71003,seq__70796_70997__$1,temp__5804__auto___70996))
);



var G__71014 = cljs.core.next.call(null,seq__70796_70997__$1);
var G__71015 = null;
var G__71016 = (0);
var G__71017 = (0);
seq__70796_70977 = G__71014;
chunk__70797_70978 = G__71015;
count__70798_70979 = G__71016;
i__70799_70980 = G__71017;
continue;
}
} else {
}
}
break;
}

var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70951){
var state_val_70952 = (state_70951[(1)]);
if((state_val_70952 === (7))){
var inst_70923 = (state_70951[(7)]);
var inst_70930 = cljs.core._EQ_.call(null,inst_70923,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_70951__$1 = state_70951;
if(inst_70930){
var statearr_70953_71018 = state_70951__$1;
(statearr_70953_71018[(1)] = (9));

} else {
var statearr_70954_71019 = state_70951__$1;
(statearr_70954_71019[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70952 === (1))){
var inst_70916 = (state_70951[(8)]);
var inst_70915 = (state_70951[(9)]);
var inst_70915__$1 = promise_chan;
var inst_70916__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_70917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70918 = [inst_70915__$1,inst_70916__$1];
var inst_70919 = (new cljs.core.PersistentVector(null,2,(5),inst_70917,inst_70918,null));
var state_70951__$1 = (function (){var statearr_70955 = state_70951;
(statearr_70955[(8)] = inst_70916__$1);

(statearr_70955[(9)] = inst_70915__$1);

return statearr_70955;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_70951__$1,(2),inst_70919);
} else {
if((state_val_70952 === (4))){
var inst_70916 = (state_70951[(8)]);
var inst_70923 = (state_70951[(7)]);
var inst_70927 = cljs.core._EQ_.call(null,inst_70923,inst_70916);
var state_70951__$1 = state_70951;
if(inst_70927){
var statearr_70956_71020 = state_70951__$1;
(statearr_70956_71020[(1)] = (6));

} else {
var statearr_70957_71021 = state_70951__$1;
(statearr_70957_71021[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70952 === (13))){
var state_70951__$1 = state_70951;
var statearr_70958_71022 = state_70951__$1;
(statearr_70958_71022[(2)] = null);

(statearr_70958_71022[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70952 === (6))){
var state_70951__$1 = state_70951;
var statearr_70959_71023 = state_70951__$1;
(statearr_70959_71023[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_70959_71023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70952 === (3))){
var state_70951__$1 = state_70951;
var statearr_70960_71024 = state_70951__$1;
(statearr_70960_71024[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_70960_71024[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70952 === (12))){
var inst_70941 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_70942 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70943 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_70944 = cljs.core.PersistentHashMap.fromArrays(inst_70942,inst_70943);
var inst_70945 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_70944);
var inst_70946 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_70945);
var state_70951__$1 = (function (){var statearr_70961 = state_70951;
(statearr_70961[(10)] = inst_70941);

return statearr_70961;
})();
var statearr_70962_71025 = state_70951__$1;
(statearr_70962_71025[(2)] = inst_70946);

(statearr_70962_71025[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70952 === (2))){
var inst_70915 = (state_70951[(9)]);
var inst_70923 = (state_70951[(7)]);
var inst_70921 = (state_70951[(2)]);
var inst_70922 = cljs.core.nth.call(null,inst_70921,(0),null);
var inst_70923__$1 = cljs.core.nth.call(null,inst_70921,(1),null);
var inst_70924 = cljs.core._EQ_.call(null,inst_70923__$1,inst_70915);
var state_70951__$1 = (function (){var statearr_70963 = state_70951;
(statearr_70963[(11)] = inst_70922);

(statearr_70963[(7)] = inst_70923__$1);

return statearr_70963;
})();
if(inst_70924){
var statearr_70964_71026 = state_70951__$1;
(statearr_70964_71026[(1)] = (3));

} else {
var statearr_70965_71027 = state_70951__$1;
(statearr_70965_71027[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70952 === (11))){
var inst_70934 = (state_70951[(2)]);
var state_70951__$1 = state_70951;
var statearr_70966_71028 = state_70951__$1;
(statearr_70966_71028[(2)] = inst_70934);

(statearr_70966_71028[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70952 === (9))){
var inst_70922 = (state_70951[(11)]);
var state_70951__$1 = state_70951;
var statearr_70967_71029 = state_70951__$1;
(statearr_70967_71029[(2)] = inst_70922);

(statearr_70967_71029[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70952 === (5))){
var inst_70938 = (state_70951[(2)]);
var inst_70939 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_70938);
var state_70951__$1 = state_70951;
if(inst_70939){
var statearr_70968_71030 = state_70951__$1;
(statearr_70968_71030[(1)] = (12));

} else {
var statearr_70969_71031 = state_70951__$1;
(statearr_70969_71031[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70952 === (14))){
var inst_70949 = (state_70951[(2)]);
var state_70951__$1 = state_70951;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70951__$1,inst_70949);
} else {
if((state_val_70952 === (10))){
var state_70951__$1 = state_70951;
var statearr_70970_71032 = state_70951__$1;
(statearr_70970_71032[(2)] = null);

(statearr_70970_71032[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70952 === (8))){
var inst_70936 = (state_70951[(2)]);
var state_70951__$1 = state_70951;
var statearr_70971_71033 = state_70951__$1;
(statearr_70971_71033[(2)] = inst_70936);

(statearr_70971_71033[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_70972 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70972[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_70972[(1)] = (1));

return statearr_70972;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_70951){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_70951);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70973){var ex__2730__auto__ = e70973;
var statearr_70974_71034 = state_70951;
(statearr_70974_71034[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_70951[(4)]))){
var statearr_70975_71035 = state_70951;
(statearr_70975_71035[(1)] = cljs.core.first.call(null,(state_70951[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71036 = state_70951;
state_70951 = G__71036;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_70951){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_70951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70976 = f__2750__auto__.call(null);
(statearr_70976[(6)] = c__2749__auto__);

return statearr_70976;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71080){
var state_val_71081 = (state_71080[(1)]);
if((state_val_71081 === (7))){
var state_71080__$1 = state_71080;
var statearr_71082_71108 = state_71080__$1;
(statearr_71082_71108[(2)] = null);

(statearr_71082_71108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71081 === (1))){
var state_71080__$1 = state_71080;
var statearr_71083_71109 = state_71080__$1;
(statearr_71083_71109[(2)] = null);

(statearr_71083_71109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71081 === (4))){
var inst_71037 = (state_71080[(2)]);
var state_71080__$1 = state_71080;
var statearr_71084_71110 = state_71080__$1;
(statearr_71084_71110[(2)] = inst_71037);

(statearr_71084_71110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71081 === (6))){
var inst_71059 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_71080__$1 = state_71080;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71080__$1,(9),inst_71059);
} else {
if((state_val_71081 === (3))){
var inst_71078 = (state_71080[(2)]);
var state_71080__$1 = state_71080;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71080__$1,inst_71078);
} else {
if((state_val_71081 === (12))){
var inst_71072 = (state_71080[(2)]);
var state_71080__$1 = state_71080;
var statearr_71085_71111 = state_71080__$1;
(statearr_71085_71111[(2)] = inst_71072);

(statearr_71085_71111[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71081 === (2))){
var inst_71043 = (state_71080[(7)]);
var inst_71048 = (state_71080[(8)]);
var inst_71053 = (state_71080[(9)]);
var _ = (function (){var statearr_71086 = state_71080;
(statearr_71086[(4)] = cljs.core.cons.call(null,(5),(state_71080[(4)])));

return statearr_71086;
})();
var inst_71043__$1 = cljs.core.random_uuid.call(null);
var inst_71044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71045 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_71046 = (new cljs.core.PersistentVector(null,2,(5),inst_71044,inst_71045,null));
var inst_71047 = (function (){var lock_id = inst_71043__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_71048__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_71046,inst_71047);
var inst_71049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71050 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_71051 = (new cljs.core.PersistentVector(null,3,(5),inst_71049,inst_71050,null));
var inst_71052 = cljs.core.get_in.call(null,inst_71048__$1,inst_71051);
var inst_71053__$1 = cljs.core._EQ_.call(null,inst_71043__$1,inst_71052);
var inst_71054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71055 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_71056 = (new cljs.core.PersistentVector(null,3,(5),inst_71054,inst_71055,null));
var inst_71057 = cljs.core.get_in.call(null,inst_71048__$1,inst_71056);
var state_71080__$1 = (function (){var statearr_71087 = state_71080;
(statearr_71087[(7)] = inst_71043__$1);

(statearr_71087[(8)] = inst_71048__$1);

(statearr_71087[(9)] = inst_71053__$1);

(statearr_71087[(10)] = inst_71057);

return statearr_71087;
})();
if(inst_71053__$1){
var statearr_71088_71112 = state_71080__$1;
(statearr_71088_71112[(1)] = (6));

} else {
var statearr_71089_71113 = state_71080__$1;
(statearr_71089_71113[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71081 === (11))){
var inst_71064 = (state_71080[(11)]);
var inst_71057 = (state_71080[(10)]);
var inst_71063 = (state_71080[(12)]);
var inst_71070 = fluree.db.util.xhttp.try_socket.call(null,inst_71063,sub_chan,pub_chan,inst_71057,(60000),inst_71064);
var state_71080__$1 = state_71080;
var statearr_71091_71114 = state_71080__$1;
(statearr_71091_71114[(2)] = inst_71070);

(statearr_71091_71114[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71081 === (9))){
var inst_71043 = (state_71080[(7)]);
var inst_71048 = (state_71080[(8)]);
var inst_71061 = (state_71080[(13)]);
var inst_71053 = (state_71080[(9)]);
var inst_71057 = (state_71080[(10)]);
var inst_71063 = (state_71080[(12)]);
var inst_71061__$1 = (state_71080[(2)]);
var inst_71062 = clojure.string.replace.call(null,inst_71061__$1,"http","ws");
var inst_71063__$1 = [inst_71062,"/fdb/ws"].join('');
var inst_71064 = (function (){var lock_id = inst_71043;
var state = inst_71048;
var have_lock_QMARK_ = inst_71053;
var resp_chan = inst_71057;
var healthy_server = inst_71061__$1;
var ws_url = inst_71063__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_71065 = fluree.db.util.core.exception_QMARK_.call(null,inst_71061__$1);
var state_71080__$1 = (function (){var statearr_71092 = state_71080;
(statearr_71092[(11)] = inst_71064);

(statearr_71092[(13)] = inst_71061__$1);

(statearr_71092[(12)] = inst_71063__$1);

return statearr_71092;
})();
if(inst_71065){
var statearr_71093_71115 = state_71080__$1;
(statearr_71093_71115[(1)] = (10));

} else {
var statearr_71094_71116 = state_71080__$1;
(statearr_71094_71116[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71081 === (5))){
var _ = (function (){var statearr_71095 = state_71080;
(statearr_71095[(4)] = cljs.core.rest.call(null,(state_71080[(4)])));

return statearr_71095;
})();
var state_71080__$1 = state_71080;
var ex71090 = (state_71080__$1[(2)]);
var statearr_71096_71117 = state_71080__$1;
(statearr_71096_71117[(5)] = ex71090);


if((ex71090 instanceof Error)){
var statearr_71097_71118 = state_71080__$1;
(statearr_71097_71118[(1)] = (4));

(statearr_71097_71118[(5)] = null);

} else {
throw ex71090;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71081 === (10))){
var inst_71061 = (state_71080[(13)]);
var inst_71057 = (state_71080[(10)]);
var inst_71067 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_71068 = cljs.core.async.put_BANG_.call(null,inst_71057,inst_71061);
var state_71080__$1 = (function (){var statearr_71098 = state_71080;
(statearr_71098[(14)] = inst_71067);

return statearr_71098;
})();
var statearr_71099_71119 = state_71080__$1;
(statearr_71099_71119[(2)] = inst_71068);

(statearr_71099_71119[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71081 === (8))){
var inst_71057 = (state_71080[(10)]);
var inst_71075 = (state_71080[(2)]);
var _ = (function (){var statearr_71100 = state_71080;
(statearr_71100[(4)] = cljs.core.rest.call(null,(state_71080[(4)])));

return statearr_71100;
})();
var state_71080__$1 = (function (){var statearr_71101 = state_71080;
(statearr_71101[(15)] = inst_71075);

return statearr_71101;
})();
var statearr_71102_71120 = state_71080__$1;
(statearr_71102_71120[(2)] = inst_71057);

(statearr_71102_71120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_71103 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71103[(0)] = fluree$db$connection$establish_socket_$_state_machine__2727__auto__);

(statearr_71103[(1)] = (1));

return statearr_71103;
});
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____1 = (function (state_71080){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_71080);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71104){var ex__2730__auto__ = e71104;
var statearr_71105_71121 = state_71080;
(statearr_71105_71121[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_71080[(4)]))){
var statearr_71106_71122 = state_71080;
(statearr_71106_71122[(1)] = cljs.core.first.call(null,(state_71080[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71123 = state_71080;
state_71080 = G__71123;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = function(state_71080){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____1.call(this,state_71080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71107 = f__2750__auto__.call(null);
(statearr_71107[(6)] = c__2749__auto__);

return statearr_71107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k71125,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__71129 = k71125;
var G__71129__$1 = (((G__71129 instanceof cljs.core.Keyword))?G__71129.fqn:null);
switch (G__71129__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k71125,else__4505__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__71130){
var vec__71131 = p__71130;
var k__4526__auto__ = cljs.core.nth.call(null,vec__71131,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__71131,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__71124){
var self__ = this;
var G__71124__$1 = this;
return (new cljs.core.RecordIter((0),G__71124__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (27 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this71126,other71127){
var self__ = this;
var this71126__$1 = this;
return (((!((other71127 == null)))) && ((((this71126__$1.constructor === other71127.constructor)) && (((cljs.core._EQ_.call(null,this71126__$1.id,other71127.id)) && (((cljs.core._EQ_.call(null,this71126__$1.servers,other71127.servers)) && (((cljs.core._EQ_.call(null,this71126__$1.state,other71127.state)) && (((cljs.core._EQ_.call(null,this71126__$1.req_chan,other71127.req_chan)) && (((cljs.core._EQ_.call(null,this71126__$1.sub_chan,other71127.sub_chan)) && (((cljs.core._EQ_.call(null,this71126__$1.pub_chan,other71127.pub_chan)) && (((cljs.core._EQ_.call(null,this71126__$1.group,other71127.group)) && (((cljs.core._EQ_.call(null,this71126__$1.storage_read,other71127.storage_read)) && (((cljs.core._EQ_.call(null,this71126__$1.storage_list,other71127.storage_list)) && (((cljs.core._EQ_.call(null,this71126__$1.storage_write,other71127.storage_write)) && (((cljs.core._EQ_.call(null,this71126__$1.storage_exists,other71127.storage_exists)) && (((cljs.core._EQ_.call(null,this71126__$1.storage_rename,other71127.storage_rename)) && (((cljs.core._EQ_.call(null,this71126__$1.storage_delete,other71127.storage_delete)) && (((cljs.core._EQ_.call(null,this71126__$1.object_cache,other71127.object_cache)) && (((cljs.core._EQ_.call(null,this71126__$1.async_cache,other71127.async_cache)) && (((cljs.core._EQ_.call(null,this71126__$1.parallelism,other71127.parallelism)) && (((cljs.core._EQ_.call(null,this71126__$1.serializer,other71127.serializer)) && (((cljs.core._EQ_.call(null,this71126__$1.default_network,other71127.default_network)) && (((cljs.core._EQ_.call(null,this71126__$1.transactor_QMARK_,other71127.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this71126__$1.publish,other71127.publish)) && (((cljs.core._EQ_.call(null,this71126__$1.transact_handler,other71127.transact_handler)) && (((cljs.core._EQ_.call(null,this71126__$1.tx_private_key,other71127.tx_private_key)) && (((cljs.core._EQ_.call(null,this71126__$1.tx_key_id,other71127.tx_key_id)) && (((cljs.core._EQ_.call(null,this71126__$1.meta,other71127.meta)) && (((cljs.core._EQ_.call(null,this71126__$1.add_listener,other71127.add_listener)) && (((cljs.core._EQ_.call(null,this71126__$1.remove_listener,other71127.remove_listener)) && (((cljs.core._EQ_.call(null,this71126__$1.close,other71127.close)) && (cljs.core._EQ_.call(null,this71126__$1.__extmap,other71127.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__71134){
var self__ = this;
var map__71135 = p__71134;
var map__71135__$1 = cljs.core.__destructure_map.call(null,map__71135);
var node = map__71135__$1;
var id__$1 = cljs.core.get.call(null,map__71135__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__71135__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.call(null,map__71135__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf.call(null,node);
} else {
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null),(function (_){
return fluree.db.storage.core.resolve_index_node.call(null,conn__$1,node,(function (){
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null),null);
}));
}));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k71125){
var self__ = this;
var this__4509__auto____$1 = this;
var G__71136 = k71125;
var G__71136__$1 = (((G__71136 instanceof cljs.core.Keyword))?G__71136.fqn:null);
switch (G__71136__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k71125);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__71124){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__71137 = cljs.core.keyword_identical_QMARK_;
var expr__71138 = k__4511__auto__;
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__71138))){
return (new fluree.db.connection.Connection(G__71124,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,G__71124,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__71124,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__71124,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__71124,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__71124,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"group","group",582596132),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__71124,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__71124,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__71124,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__71124,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__71124,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__71124,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__71124,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__71124,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__71124,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__71124,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__71124,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__71124,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__71124,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__71124,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__71124,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__71124,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__71124,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__71124,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__71124,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__71124,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71137.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__71138))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__71124,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__71124),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_read.call(null,k);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return self__.storage_write.call(null,k,data);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_exists.call(null,k);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return self__.storage_rename.call(null,old_key,new_key);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return self__.storage_list.call(null,d);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_delete.call(null,k);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__71124){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__71124,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__71128){
var extmap__4542__auto__ = (function (){var G__71140 = cljs.core.dissoc.call(null,G__71128,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__71128)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__71140);
} else {
return G__71140;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__71128),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__71128),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__71146 = servers_STAR_;
var vec__71147 = G__71146;
var seq__71148 = cljs.core.seq.call(null,vec__71147);
var first__71149 = cljs.core.first.call(null,seq__71148);
var seq__71148__$1 = cljs.core.next.call(null,seq__71148);
var server = first__71149;
var r = seq__71148__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__71146__$1 = G__71146;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__71153 = G__71146__$1;
var seq__71154 = cljs.core.seq.call(null,vec__71153);
var first__71155 = cljs.core.first.call(null,seq__71154);
var seq__71154__$1 = cljs.core.next.call(null,seq__71154);
var server__$1 = first__71155;
var r__$1 = seq__71154__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__71156 = r__$1;
var G__71157 = is_https_QMARK_;
var G__71158 = result_STAR_;
G__71146__$1 = G__71156;
https_QMARK___$1 = G__71157;
result__$1 = G__71158;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__71159 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__71159 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__71159);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71188){
var state_val_71189 = (state_71188[(1)]);
if((state_val_71189 === (7))){
var inst_71174 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71175 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71176 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71177 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71178 = fluree.db.connection.establish_socket.call(null,inst_71174,inst_71175,inst_71176,inst_71177);
var state_71188__$1 = state_71188;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71188__$1,(9),inst_71178);
} else {
if((state_val_71189 === (1))){
var state_71188__$1 = state_71188;
var statearr_71190_71209 = state_71188__$1;
(statearr_71190_71209[(2)] = null);

(statearr_71190_71209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71189 === (4))){
var inst_71160 = (state_71188[(2)]);
var state_71188__$1 = state_71188;
var statearr_71191_71210 = state_71188__$1;
(statearr_71191_71210[(2)] = inst_71160);

(statearr_71191_71210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71189 === (6))){
var inst_71171 = (state_71188[(7)]);
var state_71188__$1 = state_71188;
var statearr_71192_71211 = state_71188__$1;
(statearr_71192_71211[(2)] = inst_71171);

(statearr_71192_71211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71189 === (3))){
var inst_71186 = (state_71188[(2)]);
var state_71188__$1 = state_71188;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71188__$1,inst_71186);
} else {
if((state_val_71189 === (2))){
var inst_71171 = (state_71188[(7)]);
var _ = (function (){var statearr_71194 = state_71188;
(statearr_71194[(4)] = cljs.core.cons.call(null,(5),(state_71188[(4)])));

return statearr_71194;
})();
var inst_71166 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_71167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71168 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71169 = [inst_71168,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_71170 = (new cljs.core.PersistentVector(null,3,(5),inst_71167,inst_71169,null));
var inst_71171__$1 = cljs.core.get_in.call(null,inst_71166,inst_71170);
var state_71188__$1 = (function (){var statearr_71195 = state_71188;
(statearr_71195[(7)] = inst_71171__$1);

return statearr_71195;
})();
if(cljs.core.truth_(inst_71171__$1)){
var statearr_71196_71212 = state_71188__$1;
(statearr_71196_71212[(1)] = (6));

} else {
var statearr_71197_71213 = state_71188__$1;
(statearr_71197_71213[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71189 === (9))){
var inst_71180 = (state_71188[(2)]);
var inst_71181 = fluree.db.util.async.throw_err.call(null,inst_71180);
var state_71188__$1 = state_71188;
var statearr_71198_71214 = state_71188__$1;
(statearr_71198_71214[(2)] = inst_71181);

(statearr_71198_71214[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71189 === (5))){
var _ = (function (){var statearr_71199 = state_71188;
(statearr_71199[(4)] = cljs.core.rest.call(null,(state_71188[(4)])));

return statearr_71199;
})();
var state_71188__$1 = state_71188;
var ex71193 = (state_71188__$1[(2)]);
var statearr_71200_71215 = state_71188__$1;
(statearr_71200_71215[(5)] = ex71193);


if((ex71193 instanceof Error)){
var statearr_71201_71216 = state_71188__$1;
(statearr_71201_71216[(1)] = (4));

(statearr_71201_71216[(5)] = null);

} else {
throw ex71193;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71189 === (8))){
var inst_71183 = (state_71188[(2)]);
var _ = (function (){var statearr_71202 = state_71188;
(statearr_71202[(4)] = cljs.core.rest.call(null,(state_71188[(4)])));

return statearr_71202;
})();
var state_71188__$1 = state_71188;
var statearr_71203_71217 = state_71188__$1;
(statearr_71203_71217[(2)] = inst_71183);

(statearr_71203_71217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_71204 = [null,null,null,null,null,null,null,null];
(statearr_71204[(0)] = fluree$db$connection$get_socket_$_state_machine__2727__auto__);

(statearr_71204[(1)] = (1));

return statearr_71204;
});
var fluree$db$connection$get_socket_$_state_machine__2727__auto____1 = (function (state_71188){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_71188);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71205){var ex__2730__auto__ = e71205;
var statearr_71206_71218 = state_71188;
(statearr_71206_71218[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_71188[(4)]))){
var statearr_71207_71219 = state_71188;
(statearr_71207_71219[(1)] = cljs.core.first.call(null,(state_71188[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71220 = state_71188;
state_71188 = G__71220;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2727__auto__ = function(state_71188){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____1.call(this,state_71188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2727__auto____0;
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71208 = f__2750__auto__.call(null);
(statearr_71208[(6)] = c__2749__auto__);

return statearr_71208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4253__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e71221){var e = e71221;
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__71223){
var map__71224 = p__71223;
var map__71224__$1 = cljs.core.__destructure_map.call(null,map__71224);
var conn = map__71224__$1;
var state = cljs.core.get.call(null,map__71224__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.call(null,map__71224__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.call(null,map__71224__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71370){
var state_val_71371 = (state_71370[(1)]);
if((state_val_71371 === (7))){
var inst_71366 = (state_71370[(2)]);
var state_71370__$1 = state_71370;
var statearr_71373_71447 = state_71370__$1;
(statearr_71373_71447[(2)] = inst_71366);

(statearr_71373_71447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (20))){
var _ = (function (){var statearr_71374 = state_71370;
(statearr_71374[(4)] = cljs.core.rest.call(null,(state_71370[(4)])));

return statearr_71374;
})();
var state_71370__$1 = state_71370;
var ex71372 = (state_71370__$1[(2)]);
var statearr_71375_71448 = state_71370__$1;
(statearr_71375_71448[(5)] = ex71372);


var statearr_71376_71449 = state_71370__$1;
(statearr_71376_71449[(1)] = (10));

(statearr_71376_71449[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (27))){
var inst_71327 = (state_71370[(7)]);
var inst_71327__$1 = (state_71370[(2)]);
var inst_71328 = inst_71327__$1 === true;
var state_71370__$1 = (function (){var statearr_71377 = state_71370;
(statearr_71377[(7)] = inst_71327__$1);

return statearr_71377;
})();
if(cljs.core.truth_(inst_71328)){
var statearr_71378_71450 = state_71370__$1;
(statearr_71378_71450[(1)] = (28));

} else {
var statearr_71379_71451 = state_71370__$1;
(statearr_71379_71451[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (1))){
var inst_71225 = (0);
var state_71370__$1 = (function (){var statearr_71380 = state_71370;
(statearr_71380[(8)] = inst_71225);

return statearr_71380;
})();
var statearr_71381_71452 = state_71370__$1;
(statearr_71381_71452[(2)] = null);

(statearr_71381_71452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (24))){
var inst_71317 = (state_71370[(9)]);
var state_71370__$1 = state_71370;
var statearr_71382_71453 = state_71370__$1;
(statearr_71382_71453[(2)] = inst_71317);

(statearr_71382_71453[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (39))){
var inst_71352 = (state_71370[(2)]);
var state_71370__$1 = state_71370;
var statearr_71383_71454 = state_71370__$1;
(statearr_71383_71454[(2)] = inst_71352);

(statearr_71383_71454[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (4))){
var inst_71228 = (state_71370[(10)]);
var inst_71228__$1 = (state_71370[(2)]);
var state_71370__$1 = (function (){var statearr_71384 = state_71370;
(statearr_71384[(10)] = inst_71228__$1);

return statearr_71384;
})();
if(cljs.core.truth_(inst_71228__$1)){
var statearr_71385_71455 = state_71370__$1;
(statearr_71385_71455[(1)] = (5));

} else {
var statearr_71386_71456 = state_71370__$1;
(statearr_71386_71456[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (15))){
var inst_71241 = (state_71370[(11)]);
var state_71370__$1 = state_71370;
var statearr_71387_71457 = state_71370__$1;
(statearr_71387_71457[(2)] = inst_71241);

(statearr_71387_71457[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (21))){
var inst_71270 = (state_71370[(12)]);
var inst_71275 = (state_71370[(13)]);
var inst_71272 = (state_71370[(14)]);
var inst_71273 = (state_71370[(15)]);
var inst_71274 = (state_71370[(16)]);
var inst_71228 = (state_71370[(10)]);
var inst_71279 = (state_71370[(17)]);
var inst_71225 = (state_71370[(8)]);
var inst_71271 = (state_71370[(18)]);
var inst_71278 = (state_71370[(19)]);
var inst_71281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71282 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_71278];
var inst_71283 = (new cljs.core.PersistentVector(null,2,(5),inst_71281,inst_71282,null));
var inst_71284 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_71283,inst_71273);
var inst_71311 = cljs.core.async.chan.call(null,(1));
var inst_71312 = (function (){var resp_chan = inst_71273;
var timeout = inst_71279;
var vec__71263 = inst_71228;
var c__2749__auto____$1 = inst_71311;
var i = inst_71225;
var data = inst_71272;
var map__71266 = inst_71275;
var _ = inst_71270;
var req_id = inst_71278;
var operation = inst_71271;
var msg = inst_71228;
var temp__5804__auto__ = inst_71228;
var opts = inst_71274;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71309){
var state_val_71310 = (state_71309[(1)]);
if((state_val_71310 === (1))){
var inst_71288 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71289 = cljs.core.async.timeout.call(null,timeout);
var inst_71290 = [resp_chan,inst_71289];
var inst_71291 = (new cljs.core.PersistentVector(null,2,(5),inst_71288,inst_71290,null));
var state_71309__$1 = state_71309;
return cljs.core.async.ioc_alts_BANG_.call(null,state_71309__$1,(2),inst_71291);
} else {
if((state_val_71310 === (2))){
var inst_71294 = (state_71309[(7)]);
var inst_71293 = (state_71309[(2)]);
var inst_71294__$1 = cljs.core.nth.call(null,inst_71293,(0),null);
var inst_71295 = cljs.core.nth.call(null,inst_71293,(1),null);
var inst_71296 = (function (){var vec__71285 = inst_71293;
var resp = inst_71294__$1;
var c = inst_71295;
return (function (p1__71222_SHARP_){
return cljs.core.dissoc.call(null,p1__71222_SHARP_,req_id);
});
})();
var inst_71297 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_71296);
var inst_71298 = cljs.core._EQ_.call(null,inst_71295,resp_chan);
var state_71309__$1 = (function (){var statearr_71388 = state_71309;
(statearr_71388[(8)] = inst_71297);

(statearr_71388[(7)] = inst_71294__$1);

return statearr_71388;
})();
if(inst_71298){
var statearr_71389_71458 = state_71309__$1;
(statearr_71389_71458[(1)] = (3));

} else {
var statearr_71390_71459 = state_71309__$1;
(statearr_71390_71459[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71310 === (3))){
var inst_71294 = (state_71309[(7)]);
var state_71309__$1 = state_71309;
var statearr_71391_71460 = state_71309__$1;
(statearr_71391_71460[(2)] = inst_71294);

(statearr_71391_71460[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71310 === (4))){
var inst_71301 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_71302 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71303 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_71304 = cljs.core.PersistentHashMap.fromArrays(inst_71302,inst_71303);
var inst_71305 = cljs.core.ex_info.call(null,inst_71301,inst_71304);
var state_71309__$1 = state_71309;
var statearr_71392_71461 = state_71309__$1;
(statearr_71392_71461[(2)] = inst_71305);

(statearr_71392_71461[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71310 === (5))){
var inst_71307 = (state_71309[(2)]);
var state_71309__$1 = state_71309;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71309__$1,inst_71307);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_71393 = [null,null,null,null,null,null,null,null,null];
(statearr_71393[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_71393[(1)] = (1));

return statearr_71393;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_71309){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_71309);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71394){var ex__2730__auto__ = e71394;
var statearr_71395_71462 = state_71309;
(statearr_71395_71462[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_71309[(4)]))){
var statearr_71396_71463 = state_71309;
(statearr_71396_71463[(1)] = cljs.core.first.call(null,(state_71309[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71464 = state_71309;
state_71309 = G__71464;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_71309){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_71309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71397 = f__2750__auto__.call(null);
(statearr_71397[(6)] = c__2749__auto____$1);

return statearr_71397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
});
})();
var inst_71313 = cljs.core.async.impl.dispatch.run.call(null,inst_71312);
var state_71370__$1 = (function (){var statearr_71398 = state_71370;
(statearr_71398[(20)] = inst_71284);

(statearr_71398[(21)] = inst_71313);

return statearr_71398;
})();
var statearr_71399_71465 = state_71370__$1;
(statearr_71399_71465[(2)] = inst_71311);

(statearr_71399_71465[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (31))){
var inst_71327 = (state_71370[(7)]);
var inst_71333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71334 = [inst_71327,"Error processing message in producer."];
var inst_71335 = (new cljs.core.PersistentVector(null,2,(5),inst_71333,inst_71334,null));
var inst_71336 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71335);
var state_71370__$1 = state_71370;
var statearr_71400_71466 = state_71370__$1;
(statearr_71400_71466[(2)] = inst_71336);

(statearr_71400_71466[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (32))){
var inst_71327 = (state_71370[(7)]);
var inst_71338 = (inst_71327 == null);
var state_71370__$1 = state_71370;
if(cljs.core.truth_(inst_71338)){
var statearr_71401_71467 = state_71370__$1;
(statearr_71401_71467[(1)] = (34));

} else {
var statearr_71402_71468 = state_71370__$1;
(statearr_71402_71468[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (33))){
var inst_71356 = (state_71370[(2)]);
var state_71370__$1 = state_71370;
var statearr_71403_71469 = state_71370__$1;
(statearr_71403_71469[(2)] = inst_71356);

(statearr_71403_71469[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (13))){
var inst_71241 = (state_71370[(11)]);
var inst_71238 = (state_71370[(2)]);
var inst_71239 = cljs.core.nth.call(null,inst_71238,(0),null);
var inst_71240 = cljs.core.nth.call(null,inst_71238,(1),null);
var inst_71241__$1 = cljs.core.nth.call(null,inst_71238,(2),null);
var state_71370__$1 = (function (){var statearr_71404 = state_71370;
(statearr_71404[(22)] = inst_71239);

(statearr_71404[(11)] = inst_71241__$1);

(statearr_71404[(23)] = inst_71240);

return statearr_71404;
})();
if(cljs.core.truth_(inst_71241__$1)){
var statearr_71405_71470 = state_71370__$1;
(statearr_71405_71470[(1)] = (14));

} else {
var statearr_71406_71471 = state_71370__$1;
(statearr_71406_71471[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (22))){
var state_71370__$1 = state_71370;
var statearr_71407_71472 = state_71370__$1;
(statearr_71407_71472[(2)] = null);

(statearr_71407_71472[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (36))){
var inst_71354 = (state_71370[(2)]);
var state_71370__$1 = state_71370;
var statearr_71408_71473 = state_71370__$1;
(statearr_71408_71473[(2)] = inst_71354);

(statearr_71408_71473[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (29))){
var inst_71327 = (state_71370[(7)]);
var inst_71331 = fluree.db.util.core.exception_QMARK_.call(null,inst_71327);
var state_71370__$1 = state_71370;
if(inst_71331){
var statearr_71409_71474 = state_71370__$1;
(statearr_71409_71474[(1)] = (31));

} else {
var statearr_71410_71475 = state_71370__$1;
(statearr_71410_71475[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (6))){
var state_71370__$1 = state_71370;
var statearr_71411_71476 = state_71370__$1;
(statearr_71411_71476[(2)] = null);

(statearr_71411_71476[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (28))){
var state_71370__$1 = state_71370;
var statearr_71412_71477 = state_71370__$1;
(statearr_71412_71477[(2)] = null);

(statearr_71412_71477[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (25))){
var state_71370__$1 = state_71370;
var statearr_71413_71478 = state_71370__$1;
(statearr_71413_71478[(2)] = fluree.db.connection.default_publish_fn);

(statearr_71413_71478[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (34))){
var inst_71340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71341 = ["Error processing message in producer. Socket closed."];
var inst_71342 = (new cljs.core.PersistentVector(null,1,(5),inst_71340,inst_71341,null));
var inst_71343 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71342);
var state_71370__$1 = state_71370;
var statearr_71414_71479 = state_71370__$1;
(statearr_71414_71479[(2)] = inst_71343);

(statearr_71414_71479[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (17))){
var inst_71230 = (state_71370[(24)]);
var inst_71241 = (state_71370[(11)]);
var inst_71248 = cljs.core.async.put_BANG_.call(null,inst_71241,inst_71230);
var state_71370__$1 = state_71370;
var statearr_71415_71480 = state_71370__$1;
(statearr_71415_71480[(2)] = inst_71248);

(statearr_71415_71480[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (3))){
var inst_71368 = (state_71370[(2)]);
var state_71370__$1 = state_71370;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71370__$1,inst_71368);
} else {
if((state_val_71371 === (12))){
var state_71370__$1 = state_71370;
var statearr_71416_71481 = state_71370__$1;
(statearr_71416_71481[(2)] = null);

(statearr_71416_71481[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (2))){
var state_71370__$1 = state_71370;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71370__$1,(4),req_chan);
} else {
if((state_val_71371 === (23))){
var inst_71317 = (state_71370[(9)]);
var inst_71316 = (state_71370[(2)]);
var inst_71317__$1 = publish;
var state_71370__$1 = (function (){var statearr_71417 = state_71370;
(statearr_71417[(9)] = inst_71317__$1);

(statearr_71417[(25)] = inst_71316);

return statearr_71417;
})();
if(cljs.core.truth_(inst_71317__$1)){
var statearr_71418_71482 = state_71370__$1;
(statearr_71418_71482[(1)] = (24));

} else {
var statearr_71419_71483 = state_71370__$1;
(statearr_71419_71483[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (35))){
var state_71370__$1 = state_71370;
var statearr_71420_71484 = state_71370__$1;
(statearr_71420_71484[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (19))){
var inst_71257 = (state_71370[(2)]);
var state_71370__$1 = state_71370;
var statearr_71422_71485 = state_71370__$1;
(statearr_71422_71485[(2)] = inst_71257);

(statearr_71422_71485[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (11))){
var inst_71228 = (state_71370[(10)]);
var state_71370__$1 = state_71370;
var statearr_71423_71486 = state_71370__$1;
(statearr_71423_71486[(2)] = inst_71228);

(statearr_71423_71486[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (9))){
var inst_71225 = (state_71370[(8)]);
var inst_71361 = (state_71370[(2)]);
var inst_71362 = (inst_71225 + (1));
var inst_71225__$1 = inst_71362;
var state_71370__$1 = (function (){var statearr_71424 = state_71370;
(statearr_71424[(8)] = inst_71225__$1);

(statearr_71424[(26)] = inst_71361);

return statearr_71424;
})();
var statearr_71425_71487 = state_71370__$1;
(statearr_71425_71487[(2)] = null);

(statearr_71425_71487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (5))){
var state_71370__$1 = state_71370;
var statearr_71426_71488 = state_71370__$1;
(statearr_71426_71488[(2)] = null);

(statearr_71426_71488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (14))){
var inst_71241 = (state_71370[(11)]);
var inst_71243 = fluree.db.util.async.channel_QMARK_.call(null,inst_71241);
var state_71370__$1 = state_71370;
var statearr_71427_71489 = state_71370__$1;
(statearr_71427_71489[(2)] = inst_71243);

(statearr_71427_71489[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (26))){
var inst_71272 = (state_71370[(14)]);
var inst_71271 = (state_71370[(18)]);
var inst_71278 = (state_71370[(19)]);
var inst_71321 = (state_71370[(2)]);
var inst_71322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71323 = [inst_71271,inst_71278,inst_71272];
var inst_71324 = (new cljs.core.PersistentVector(null,3,(5),inst_71322,inst_71323,null));
var inst_71325 = inst_71321.call(null,conn,inst_71324);
var state_71370__$1 = state_71370;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71370__$1,(27),inst_71325);
} else {
if((state_val_71371 === (16))){
var inst_71246 = (state_71370[(2)]);
var state_71370__$1 = state_71370;
if(cljs.core.truth_(inst_71246)){
var statearr_71428_71490 = state_71370__$1;
(statearr_71428_71490[(1)] = (17));

} else {
var statearr_71429_71491 = state_71370__$1;
(statearr_71429_71491[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (38))){
var state_71370__$1 = state_71370;
var statearr_71430_71492 = state_71370__$1;
(statearr_71430_71492[(2)] = null);

(statearr_71430_71492[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (30))){
var inst_71358 = (state_71370[(2)]);
var _ = (function (){var statearr_71431 = state_71370;
(statearr_71431[(4)] = cljs.core.rest.call(null,(state_71370[(4)])));

return statearr_71431;
})();
var state_71370__$1 = state_71370;
var statearr_71432_71493 = state_71370__$1;
(statearr_71432_71493[(2)] = inst_71358);

(statearr_71432_71493[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (10))){
var inst_71228 = (state_71370[(10)]);
var inst_71230 = (state_71370[(2)]);
var inst_71234 = cljs.core.sequential_QMARK_.call(null,inst_71228);
var state_71370__$1 = (function (){var statearr_71433 = state_71370;
(statearr_71433[(24)] = inst_71230);

return statearr_71433;
})();
if(inst_71234){
var statearr_71434_71494 = state_71370__$1;
(statearr_71434_71494[(1)] = (11));

} else {
var statearr_71435_71495 = state_71370__$1;
(statearr_71435_71495[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (18))){
var inst_71230 = (state_71370[(24)]);
var inst_71228 = (state_71370[(10)]);
var inst_71250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71251 = cljs.core.pr_str.call(null,inst_71228);
var inst_71252 = ["Error processing ledger request, no valid return channel: ",inst_71251].join('');
var inst_71253 = [inst_71230,inst_71252];
var inst_71254 = (new cljs.core.PersistentVector(null,2,(5),inst_71250,inst_71253,null));
var inst_71255 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71254);
var state_71370__$1 = state_71370;
var statearr_71436_71496 = state_71370__$1;
(statearr_71436_71496[(2)] = inst_71255);

(statearr_71436_71496[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (37))){
var inst_71327 = (state_71370[(7)]);
var inst_71346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71347 = ["Error processing message in producer. Socket closed. Published result",inst_71327];
var inst_71348 = (new cljs.core.PersistentVector(null,2,(5),inst_71346,inst_71347,null));
var inst_71349 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71348);
var state_71370__$1 = state_71370;
var statearr_71437_71497 = state_71370__$1;
(statearr_71437_71497[(2)] = inst_71349);

(statearr_71437_71497[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71371 === (8))){
var inst_71275 = (state_71370[(13)]);
var inst_71273 = (state_71370[(15)]);
var inst_71274 = (state_71370[(16)]);
var inst_71228 = (state_71370[(10)]);
var _ = (function (){var statearr_71438 = state_71370;
(statearr_71438[(4)] = cljs.core.cons.call(null,(20),(state_71370[(4)])));

return statearr_71438;
})();
var inst_71267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71268 = ["Outgoing message to websocket: ",inst_71228];
var inst_71269 = (new cljs.core.PersistentVector(null,2,(5),inst_71267,inst_71268,null));
var inst_71270 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_71269);
var inst_71271 = cljs.core.nth.call(null,inst_71228,(0),null);
var inst_71272 = cljs.core.nth.call(null,inst_71228,(1),null);
var inst_71273__$1 = cljs.core.nth.call(null,inst_71228,(2),null);
var inst_71274__$1 = cljs.core.nth.call(null,inst_71228,(3),null);
var inst_71275__$1 = cljs.core.__destructure_map.call(null,inst_71274__$1);
var inst_71276 = cljs.core.random_uuid.call(null);
var inst_71277 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71276);
var inst_71278 = cljs.core.get.call(null,inst_71275__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_71277);
var inst_71279 = cljs.core.get.call(null,inst_71275__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_71370__$1 = (function (){var statearr_71439 = state_71370;
(statearr_71439[(12)] = inst_71270);

(statearr_71439[(13)] = inst_71275__$1);

(statearr_71439[(14)] = inst_71272);

(statearr_71439[(15)] = inst_71273__$1);

(statearr_71439[(16)] = inst_71274__$1);

(statearr_71439[(17)] = inst_71279);

(statearr_71439[(18)] = inst_71271);

(statearr_71439[(19)] = inst_71278);

return statearr_71439;
})();
if(cljs.core.truth_(inst_71273__$1)){
var statearr_71440_71498 = state_71370__$1;
(statearr_71440_71498[(1)] = (21));

} else {
var statearr_71441_71499 = state_71370__$1;
(statearr_71441_71499[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_71442 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71442[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_71442[(1)] = (1));

return statearr_71442;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_71370){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_71370);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71443){var ex__2730__auto__ = e71443;
var statearr_71444_71500 = state_71370;
(statearr_71444_71500[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_71370[(4)]))){
var statearr_71445_71501 = state_71370;
(statearr_71445_71501[(1)] = cljs.core.first.call(null,(state_71370[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71502 = state_71370;
state_71370 = G__71502;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_71370){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_71370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71446 = f__2750__auto__.call(null);
(statearr_71446[(6)] = c__2749__auto__);

return statearr_71446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(req_chan){
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Returns a channel that will eventually have a websocket. Will exponentially backoff
 *   until connection attempts happen every two minutes. Uses the existing conn and will
 *   reuse the existing sub-chan and pub-chan so the msg-consumer/producer loops do not
 *   need to be restarted.
 */
fluree.db.connection.reconnect_conn = (function fluree$db$connection$reconnect_conn(conn){
fluree.db.connection.close_websocket.call(null,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn));

var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71540){
var state_val_71541 = (state_71540[(1)]);
if((state_val_71541 === (7))){
var inst_71511 = (state_71540[(7)]);
var state_71540__$1 = state_71540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71540__$1,(9),inst_71511);
} else {
if((state_val_71541 === (1))){
var inst_71503 = (1);
var state_71540__$1 = (function (){var statearr_71542 = state_71540;
(statearr_71542[(8)] = inst_71503);

return statearr_71542;
})();
var statearr_71543_71566 = state_71540__$1;
(statearr_71543_71566[(2)] = null);

(statearr_71543_71566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71541 === (4))){
var inst_71508 = (state_71540[(2)]);
var inst_71509 = fluree.db.connection.get_socket.call(null,conn);
var state_71540__$1 = (function (){var statearr_71544 = state_71540;
(statearr_71544[(9)] = inst_71508);

return statearr_71544;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71540__$1,(5),inst_71509);
} else {
if((state_val_71541 === (15))){
var inst_71536 = (state_71540[(2)]);
var state_71540__$1 = state_71540;
var statearr_71545_71567 = state_71540__$1;
(statearr_71545_71567[(2)] = inst_71536);

(statearr_71545_71567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71541 === (13))){
var inst_71503 = (state_71540[(8)]);
var inst_71518 = (state_71540[(10)]);
var inst_71526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71527 = [inst_71518,"Cannot establish connection to a healthy server, backing off:",inst_71503,"s."];
var inst_71528 = (new cljs.core.PersistentVector(null,4,(5),inst_71526,inst_71527,null));
var inst_71529 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71528);
var inst_71530 = ((2) * inst_71503);
var inst_71531 = ((60) * (2));
var inst_71532 = ((inst_71530 < inst_71531) ? inst_71530 : inst_71531);
var inst_71503__$1 = inst_71532;
var state_71540__$1 = (function (){var statearr_71546 = state_71540;
(statearr_71546[(11)] = inst_71529);

(statearr_71546[(8)] = inst_71503__$1);

return statearr_71546;
})();
var statearr_71547_71568 = state_71540__$1;
(statearr_71547_71568[(2)] = null);

(statearr_71547_71568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71541 === (6))){
var inst_71511 = (state_71540[(7)]);
var state_71540__$1 = state_71540;
var statearr_71548_71569 = state_71540__$1;
(statearr_71548_71569[(2)] = inst_71511);

(statearr_71548_71569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71541 === (3))){
var inst_71538 = (state_71540[(2)]);
var state_71540__$1 = state_71540;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71540__$1,inst_71538);
} else {
if((state_val_71541 === (12))){
var inst_71524 = (state_71540[(2)]);
var state_71540__$1 = state_71540;
if(cljs.core.truth_(inst_71524)){
var statearr_71549_71570 = state_71540__$1;
(statearr_71549_71570[(1)] = (13));

} else {
var statearr_71550_71571 = state_71540__$1;
(statearr_71550_71571[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71541 === (2))){
var inst_71503 = (state_71540[(8)]);
var inst_71505 = (inst_71503 * (1000));
var inst_71506 = cljs.core.async.timeout.call(null,inst_71505);
var state_71540__$1 = state_71540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71540__$1,(4),inst_71506);
} else {
if((state_val_71541 === (11))){
var inst_71518 = (state_71540[(10)]);
var inst_71522 = fluree.db.util.core.exception_QMARK_.call(null,inst_71518);
var state_71540__$1 = state_71540;
var statearr_71551_71572 = state_71540__$1;
(statearr_71551_71572[(2)] = inst_71522);

(statearr_71551_71572[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71541 === (9))){
var inst_71516 = (state_71540[(2)]);
var state_71540__$1 = state_71540;
var statearr_71552_71573 = state_71540__$1;
(statearr_71552_71573[(2)] = inst_71516);

(statearr_71552_71573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71541 === (5))){
var inst_71511 = (state_71540[(7)]);
var inst_71511__$1 = (state_71540[(2)]);
var inst_71512 = fluree.db.util.core.exception_QMARK_.call(null,inst_71511__$1);
var state_71540__$1 = (function (){var statearr_71553 = state_71540;
(statearr_71553[(7)] = inst_71511__$1);

return statearr_71553;
})();
if(inst_71512){
var statearr_71554_71574 = state_71540__$1;
(statearr_71554_71574[(1)] = (6));

} else {
var statearr_71555_71575 = state_71540__$1;
(statearr_71555_71575[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71541 === (14))){
var inst_71518 = (state_71540[(10)]);
var state_71540__$1 = state_71540;
var statearr_71556_71576 = state_71540__$1;
(statearr_71556_71576[(2)] = inst_71518);

(statearr_71556_71576[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71541 === (10))){
var inst_71519 = (state_71540[(12)]);
var state_71540__$1 = state_71540;
var statearr_71557_71577 = state_71540__$1;
(statearr_71557_71577[(2)] = inst_71519);

(statearr_71557_71577[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71541 === (8))){
var inst_71519 = (state_71540[(12)]);
var inst_71518 = (state_71540[(10)]);
var inst_71518__$1 = (state_71540[(2)]);
var inst_71519__$1 = (inst_71518__$1 == null);
var state_71540__$1 = (function (){var statearr_71558 = state_71540;
(statearr_71558[(12)] = inst_71519__$1);

(statearr_71558[(10)] = inst_71518__$1);

return statearr_71558;
})();
if(cljs.core.truth_(inst_71519__$1)){
var statearr_71559_71578 = state_71540__$1;
(statearr_71559_71578[(1)] = (10));

} else {
var statearr_71560_71579 = state_71540__$1;
(statearr_71560_71579[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__ = null;
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0 = (function (){
var statearr_71561 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71561[(0)] = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__);

(statearr_71561[(1)] = (1));

return statearr_71561;
});
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1 = (function (state_71540){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_71540);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71562){var ex__2730__auto__ = e71562;
var statearr_71563_71580 = state_71540;
(statearr_71563_71580[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_71540[(4)]))){
var statearr_71564_71581 = state_71540;
(statearr_71564_71581[(1)] = cljs.core.first.call(null,(state_71540[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71582 = state_71540;
state_71540 = G__71582;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__ = function(state_71540){
switch(arguments.length){
case 0:
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1.call(this,state_71540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0;
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1;
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71565 = f__2750__auto__.call(null);
(statearr_71565[(6)] = c__2749__auto__);

return statearr_71565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(p__71583){
var map__71584 = p__71583;
var map__71584__$1 = cljs.core.__destructure_map.call(null,map__71584);
var conn = map__71584__$1;
var sub_chan = cljs.core.get.call(null,map__71584__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var req_chan = cljs.core.get.call(null,map__71584__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var keep_alive_fn = cljs.core.get.call(null,map__71584__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var keep_alive = cljs.core.get.call(null,map__71584__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var ping_transactor_after = (2500);
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71695){
var state_val_71696 = (state_71695[(1)]);
if((state_val_71696 === (7))){
var inst_71691 = (state_71695[(2)]);
var state_71695__$1 = state_71695;
var statearr_71697_71753 = state_71695__$1;
(statearr_71697_71753[(2)] = inst_71691);

(statearr_71697_71753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (20))){
var inst_71642 = (state_71695[(2)]);
var state_71695__$1 = state_71695;
var statearr_71698_71754 = state_71695__$1;
(statearr_71698_71754[(2)] = inst_71642);

(statearr_71698_71754[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (27))){
var inst_71660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71661 = ["Connection closed."];
var inst_71662 = (new cljs.core.PersistentVector(null,1,(5),inst_71660,inst_71661,null));
var inst_71663 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_71662);
var state_71695__$1 = state_71695;
var statearr_71699_71755 = state_71695__$1;
(statearr_71699_71755[(2)] = inst_71663);

(statearr_71699_71755[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (1))){
var inst_71585 = (0);
var state_71695__$1 = (function (){var statearr_71700 = state_71695;
(statearr_71700[(7)] = inst_71585);

return statearr_71700;
})();
var statearr_71701_71756 = state_71695__$1;
(statearr_71701_71756[(2)] = null);

(statearr_71701_71756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (24))){
var inst_71629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71630 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_71631 = [keep_alive_fn];
var inst_71632 = cljs.core.PersistentHashMap.fromArrays(inst_71630,inst_71631);
var inst_71633 = ["Unsupported callback registered",inst_71632];
var inst_71634 = (new cljs.core.PersistentVector(null,2,(5),inst_71629,inst_71633,null));
var inst_71635 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_71634);
var state_71695__$1 = state_71695;
var statearr_71702_71757 = state_71695__$1;
(statearr_71702_71757[(2)] = inst_71635);

(statearr_71702_71757[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (4))){
var inst_71590 = (state_71695[(8)]);
var inst_71595 = (state_71695[(2)]);
var inst_71596 = cljs.core.nth.call(null,inst_71595,(0),null);
var inst_71597 = cljs.core.nth.call(null,inst_71595,(1),null);
var inst_71598 = cljs.core._EQ_.call(null,inst_71597,inst_71590);
var state_71695__$1 = (function (){var statearr_71703 = state_71695;
(statearr_71703[(9)] = inst_71596);

return statearr_71703;
})();
if(inst_71598){
var statearr_71704_71758 = state_71695__$1;
(statearr_71704_71758[(1)] = (5));

} else {
var statearr_71705_71759 = state_71695__$1;
(statearr_71705_71759[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (15))){
var inst_71615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71616 = ["No keep-alive callback is registered"];
var inst_71617 = (new cljs.core.PersistentVector(null,1,(5),inst_71615,inst_71616,null));
var inst_71618 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_71617);
var state_71695__$1 = state_71695;
var statearr_71706_71760 = state_71695__$1;
(statearr_71706_71760[(2)] = inst_71618);

(statearr_71706_71760[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (21))){
var inst_71626 = cljs.core.eval.call(null,keep_alive_fn);
var state_71695__$1 = state_71695;
var statearr_71707_71761 = state_71695__$1;
(statearr_71707_71761[(2)] = inst_71626);

(statearr_71707_71761[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (31))){
var state_71695__$1 = state_71695;
var statearr_71708_71762 = state_71695__$1;
(statearr_71708_71762[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (32))){
var inst_71687 = (state_71695[(2)]);
var state_71695__$1 = state_71695;
var statearr_71710_71763 = state_71695__$1;
(statearr_71710_71763[(2)] = inst_71687);

(statearr_71710_71763[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (33))){
var inst_71596 = (state_71695[(9)]);
var inst_71674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71675 = fluree.db.util.json.parse.call(null,inst_71596);
var inst_71676 = cljs.core.pr_str.call(null,inst_71675);
var inst_71677 = ["Received message:",inst_71676];
var inst_71678 = (new cljs.core.PersistentVector(null,2,(5),inst_71674,inst_71677,null));
var inst_71679 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_71678);
var inst_71680 = fluree.db.util.json.parse.call(null,inst_71596);
var inst_71681 = fluree.db.conn_events.process_events.call(null,conn,inst_71680);
var inst_71585 = (0);
var state_71695__$1 = (function (){var statearr_71711 = state_71695;
(statearr_71711[(10)] = inst_71681);

(statearr_71711[(11)] = inst_71679);

(statearr_71711[(7)] = inst_71585);

return statearr_71711;
})();
var statearr_71712_71764 = state_71695__$1;
(statearr_71712_71764[(2)] = null);

(statearr_71712_71764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (13))){
var inst_71650 = (state_71695[(2)]);
var state_71695__$1 = state_71695;
var statearr_71713_71765 = state_71695__$1;
(statearr_71713_71765[(2)] = inst_71650);

(statearr_71713_71765[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (22))){
var state_71695__$1 = state_71695;
var statearr_71714_71766 = state_71695__$1;
(statearr_71714_71766[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (29))){
var inst_71689 = (state_71695[(2)]);
var state_71695__$1 = state_71695;
var statearr_71716_71767 = state_71695__$1;
(statearr_71716_71767[(2)] = inst_71689);

(statearr_71716_71767[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (6))){
var inst_71596 = (state_71695[(9)]);
var inst_71658 = (inst_71596 == null);
var state_71695__$1 = state_71695;
if(cljs.core.truth_(inst_71658)){
var statearr_71717_71768 = state_71695__$1;
(statearr_71717_71768[(1)] = (27));

} else {
var statearr_71718_71769 = state_71695__$1;
(statearr_71718_71769[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (28))){
var inst_71596 = (state_71695[(9)]);
var inst_71665 = fluree.db.util.core.exception_QMARK_.call(null,inst_71596);
var state_71695__$1 = state_71695;
if(inst_71665){
var statearr_71719_71770 = state_71695__$1;
(statearr_71719_71770[(1)] = (30));

} else {
var statearr_71720_71771 = state_71695__$1;
(statearr_71720_71771[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (25))){
var state_71695__$1 = state_71695;
var statearr_71721_71772 = state_71695__$1;
(statearr_71721_71772[(2)] = null);

(statearr_71721_71772[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (34))){
var state_71695__$1 = state_71695;
var statearr_71722_71773 = state_71695__$1;
(statearr_71722_71773[(2)] = null);

(statearr_71722_71773[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (17))){
var inst_71644 = (state_71695[(2)]);
var inst_71645 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71646 = fluree.db.connection.close_websocket.call(null,inst_71645);
var inst_71647 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71648 = fluree.db.session.close_all_sessions.call(null,inst_71647);
var state_71695__$1 = (function (){var statearr_71723 = state_71695;
(statearr_71723[(12)] = inst_71644);

(statearr_71723[(13)] = inst_71646);

return statearr_71723;
})();
var statearr_71724_71774 = state_71695__$1;
(statearr_71724_71774[(2)] = inst_71648);

(statearr_71724_71774[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (3))){
var inst_71693 = (state_71695[(2)]);
var state_71695__$1 = state_71695;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71695__$1,inst_71693);
} else {
if((state_val_71696 === (12))){
var inst_71608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71609 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_71610 = (new cljs.core.PersistentVector(null,1,(5),inst_71608,inst_71609,null));
var inst_71611 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_71610);
var inst_71612 = keep_alive_fn;
var inst_71613 = (keep_alive_fn == null);
var state_71695__$1 = (function (){var statearr_71725 = state_71695;
(statearr_71725[(14)] = inst_71612);

(statearr_71725[(15)] = inst_71611);

return statearr_71725;
})();
if(cljs.core.truth_(inst_71613)){
var statearr_71726_71775 = state_71695__$1;
(statearr_71726_71775[(1)] = (15));

} else {
var statearr_71727_71776 = state_71695__$1;
(statearr_71727_71776[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (2))){
var inst_71590 = (state_71695[(8)]);
var inst_71590__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_71591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71592 = [sub_chan,inst_71590__$1];
var inst_71593 = (new cljs.core.PersistentVector(null,2,(5),inst_71591,inst_71592,null));
var state_71695__$1 = (function (){var statearr_71728 = state_71695;
(statearr_71728[(8)] = inst_71590__$1);

return statearr_71728;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_71695__$1,(4),inst_71593);
} else {
if((state_val_71696 === (23))){
var inst_71640 = (state_71695[(2)]);
var state_71695__$1 = state_71695;
var statearr_71729_71777 = state_71695__$1;
(statearr_71729_71777[(2)] = inst_71640);

(statearr_71729_71777[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (35))){
var inst_71685 = (state_71695[(2)]);
var state_71695__$1 = state_71695;
var statearr_71730_71778 = state_71695__$1;
(statearr_71730_71778[(2)] = inst_71685);

(statearr_71730_71778[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (19))){
var inst_71624 = typeof keep_alive_fn === 'string';
var state_71695__$1 = state_71695;
if(cljs.core.truth_(inst_71624)){
var statearr_71731_71779 = state_71695__$1;
(statearr_71731_71779[(1)] = (21));

} else {
var statearr_71732_71780 = state_71695__$1;
(statearr_71732_71780[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (11))){
var inst_71603 = fluree.db.connection.reconnect_conn.call(null,conn);
var state_71695__$1 = state_71695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71695__$1,(14),inst_71603);
} else {
if((state_val_71696 === (9))){
var inst_71585 = (state_71695[(7)]);
var inst_71652 = fluree.db.connection.ping_transactor.call(null,req_chan);
var inst_71653 = (inst_71585 + (1));
var inst_71585__$1 = inst_71653;
var state_71695__$1 = (function (){var statearr_71733 = state_71695;
(statearr_71733[(16)] = inst_71652);

(statearr_71733[(7)] = inst_71585__$1);

return statearr_71733;
})();
var statearr_71734_71781 = state_71695__$1;
(statearr_71734_71781[(2)] = null);

(statearr_71734_71781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (5))){
var inst_71585 = (state_71695[(7)]);
var inst_71600 = cljs.core._EQ_.call(null,(2),inst_71585);
var state_71695__$1 = state_71695;
if(inst_71600){
var statearr_71735_71782 = state_71695__$1;
(statearr_71735_71782[(1)] = (8));

} else {
var statearr_71736_71783 = state_71695__$1;
(statearr_71736_71783[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (14))){
var inst_71605 = (state_71695[(2)]);
var inst_71585 = (0);
var state_71695__$1 = (function (){var statearr_71737 = state_71695;
(statearr_71737[(17)] = inst_71605);

(statearr_71737[(7)] = inst_71585);

return statearr_71737;
})();
var statearr_71738_71784 = state_71695__$1;
(statearr_71738_71784[(2)] = null);

(statearr_71738_71784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (26))){
var inst_71638 = (state_71695[(2)]);
var state_71695__$1 = state_71695;
var statearr_71739_71785 = state_71695__$1;
(statearr_71739_71785[(2)] = inst_71638);

(statearr_71739_71785[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (16))){
var inst_71620 = cljs.core.fn_QMARK_.call(null,keep_alive_fn);
var state_71695__$1 = state_71695;
if(inst_71620){
var statearr_71740_71786 = state_71695__$1;
(statearr_71740_71786[(1)] = (18));

} else {
var statearr_71741_71787 = state_71695__$1;
(statearr_71741_71787[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (30))){
var inst_71596 = (state_71695[(9)]);
var inst_71667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71668 = [inst_71596];
var inst_71669 = (new cljs.core.PersistentVector(null,1,(5),inst_71667,inst_71668,null));
var inst_71670 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71669);
var inst_71585 = (0);
var state_71695__$1 = (function (){var statearr_71742 = state_71695;
(statearr_71742[(18)] = inst_71670);

(statearr_71742[(7)] = inst_71585);

return statearr_71742;
})();
var statearr_71743_71788 = state_71695__$1;
(statearr_71743_71788[(2)] = null);

(statearr_71743_71788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (10))){
var inst_71656 = (state_71695[(2)]);
var state_71695__$1 = state_71695;
var statearr_71744_71789 = state_71695__$1;
(statearr_71744_71789[(2)] = inst_71656);

(statearr_71744_71789[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (18))){
var inst_71622 = keep_alive_fn.call(null);
var state_71695__$1 = state_71695;
var statearr_71745_71790 = state_71695__$1;
(statearr_71745_71790[(2)] = inst_71622);

(statearr_71745_71790[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71696 === (8))){
var state_71695__$1 = state_71695;
if(cljs.core.truth_(keep_alive)){
var statearr_71746_71791 = state_71695__$1;
(statearr_71746_71791[(1)] = (11));

} else {
var statearr_71747_71792 = state_71695__$1;
(statearr_71747_71792[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0 = (function (){
var statearr_71748 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71748[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2727__auto__);

(statearr_71748[(1)] = (1));

return statearr_71748;
});
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1 = (function (state_71695){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_71695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71749){var ex__2730__auto__ = e71749;
var statearr_71750_71793 = state_71695;
(statearr_71750_71793[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_71695[(4)]))){
var statearr_71751_71794 = state_71695;
(statearr_71751_71794[(1)] = cljs.core.first.call(null,(state_71695[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71795 = state_71695;
state_71695 = G__71795;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = function(state_71695){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1.call(this,state_71695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71752 = f__2750__auto__.call(null);
(statearr_71752[(6)] = c__2749__auto__);

return statearr_71752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__71797 = arguments.length;
switch (G__71797) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__71798 = opts;
var map__71798__$1 = cljs.core.__destructure_map.call(null,map__71798);
var private$ = cljs.core.get.call(null,map__71798__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__71798__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71850){
var state_val_71851 = (state_71850[(1)]);
if((state_val_71851 === (7))){
var inst_71808 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_71809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71810 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_71811 = (new cljs.core.PersistentVector(null,2,(5),inst_71809,inst_71810,null));
var inst_71812 = cljs.core.get_in.call(null,inst_71808,inst_71811);
var state_71850__$1 = state_71850;
var statearr_71852_71883 = state_71850__$1;
(statearr_71852_71883[(2)] = inst_71812);

(statearr_71852_71883[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71851 === (1))){
var state_71850__$1 = state_71850;
var statearr_71853_71884 = state_71850__$1;
(statearr_71853_71884[(2)] = null);

(statearr_71853_71884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71851 === (4))){
var inst_71799 = (state_71850[(2)]);
var state_71850__$1 = state_71850;
var statearr_71854_71885 = state_71850__$1;
(statearr_71854_71885[(2)] = inst_71799);

(statearr_71854_71885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71851 === (15))){
var inst_71819 = (state_71850[(7)]);
var inst_71838 = (state_71850[(2)]);
var inst_71839 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_71840 = [(5000),inst_71838,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_71841 = cljs.core.PersistentHashMap.fromArrays(inst_71839,inst_71840);
var inst_71842 = fluree.db.util.xhttp.get.call(null,inst_71819,inst_71841);
var state_71850__$1 = state_71850;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71850__$1,(16),inst_71842);
} else {
if((state_val_71851 === (13))){
var inst_71829 = (state_71850[(8)]);
var inst_71819 = (state_71850[(7)]);
var inst_71831 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_71832 = [inst_71829];
var inst_71833 = cljs.core.PersistentHashMap.fromArrays(inst_71831,inst_71832);
var inst_71834 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_71819,inst_71833,private$);
var inst_71835 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_71834);
var state_71850__$1 = state_71850;
var statearr_71855_71886 = state_71850__$1;
(statearr_71855_71886[(2)] = inst_71835);

(statearr_71855_71886[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71851 === (6))){
var inst_71805 = (state_71850[(9)]);
var state_71850__$1 = state_71850;
var statearr_71856_71887 = state_71850__$1;
(statearr_71856_71887[(2)] = inst_71805);

(statearr_71856_71887[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71851 === (3))){
var inst_71848 = (state_71850[(2)]);
var state_71850__$1 = state_71850;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71850__$1,inst_71848);
} else {
if((state_val_71851 === (12))){
var inst_71829 = (state_71850[(2)]);
var state_71850__$1 = (function (){var statearr_71857 = state_71850;
(statearr_71857[(8)] = inst_71829);

return statearr_71857;
})();
if(cljs.core.truth_(private$)){
var statearr_71858_71888 = state_71850__$1;
(statearr_71858_71888[(1)] = (13));

} else {
var statearr_71859_71889 = state_71850__$1;
(statearr_71859_71889[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71851 === (2))){
var inst_71805 = (state_71850[(9)]);
var _ = (function (){var statearr_71860 = state_71850;
(statearr_71860[(4)] = cljs.core.cons.call(null,(5),(state_71850[(4)])));

return statearr_71860;
})();
var inst_71805__$1 = jwt;
var state_71850__$1 = (function (){var statearr_71861 = state_71850;
(statearr_71861[(9)] = inst_71805__$1);

return statearr_71861;
})();
if(cljs.core.truth_(inst_71805__$1)){
var statearr_71862_71890 = state_71850__$1;
(statearr_71862_71890[(1)] = (6));

} else {
var statearr_71863_71891 = state_71850__$1;
(statearr_71863_71891[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71851 === (11))){
var inst_71823 = (state_71850[(10)]);
var state_71850__$1 = state_71850;
var statearr_71865_71892 = state_71850__$1;
(statearr_71865_71892[(2)] = inst_71823);

(statearr_71865_71892[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71851 === (9))){
var inst_71814 = (state_71850[(11)]);
var inst_71815 = (state_71850[(12)]);
var inst_71818 = (state_71850[(2)]);
var inst_71819 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71818),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71815)].join('');
var inst_71821 = ["Accept"];
var inst_71822 = ["application/json"];
var inst_71823 = cljs.core.PersistentHashMap.fromArrays(inst_71821,inst_71822);
var state_71850__$1 = (function (){var statearr_71866 = state_71850;
(statearr_71866[(10)] = inst_71823);

(statearr_71866[(7)] = inst_71819);

return statearr_71866;
})();
if(cljs.core.truth_(inst_71814)){
var statearr_71867_71893 = state_71850__$1;
(statearr_71867_71893[(1)] = (10));

} else {
var statearr_71868_71894 = state_71850__$1;
(statearr_71868_71894[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71851 === (5))){
var _ = (function (){var statearr_71869 = state_71850;
(statearr_71869[(4)] = cljs.core.rest.call(null,(state_71850[(4)])));

return statearr_71869;
})();
var state_71850__$1 = state_71850;
var ex71864 = (state_71850__$1[(2)]);
var statearr_71870_71895 = state_71850__$1;
(statearr_71870_71895[(5)] = ex71864);


if((ex71864 instanceof Error)){
var statearr_71871_71896 = state_71850__$1;
(statearr_71871_71896[(1)] = (4));

(statearr_71871_71896[(5)] = null);

} else {
throw ex71864;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71851 === (14))){
var inst_71829 = (state_71850[(8)]);
var state_71850__$1 = state_71850;
var statearr_71872_71897 = state_71850__$1;
(statearr_71872_71897[(2)] = inst_71829);

(statearr_71872_71897[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71851 === (16))){
var inst_71844 = (state_71850[(2)]);
var inst_71845 = fluree.db.util.async.throw_err.call(null,inst_71844);
var _ = (function (){var statearr_71873 = state_71850;
(statearr_71873[(4)] = cljs.core.rest.call(null,(state_71850[(4)])));

return statearr_71873;
})();
var state_71850__$1 = state_71850;
var statearr_71874_71898 = state_71850__$1;
(statearr_71874_71898[(2)] = inst_71845);

(statearr_71874_71898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71851 === (10))){
var inst_71814 = (state_71850[(11)]);
var inst_71823 = (state_71850[(10)]);
var inst_71825 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71814)].join('');
var inst_71826 = cljs.core.assoc.call(null,inst_71823,"Authorization",inst_71825);
var state_71850__$1 = state_71850;
var statearr_71875_71899 = state_71850__$1;
(statearr_71875_71899[(2)] = inst_71826);

(statearr_71875_71899[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71851 === (8))){
var inst_71814 = (state_71850[(2)]);
var inst_71815 = clojure.string.replace.call(null,k,"_","/");
var inst_71816 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_71850__$1 = (function (){var statearr_71876 = state_71850;
(statearr_71876[(11)] = inst_71814);

(statearr_71876[(12)] = inst_71815);

return statearr_71876;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71850__$1,(9),inst_71816);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_71877 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71877[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_71877[(1)] = (1));

return statearr_71877;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_71850){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_71850);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71878){var ex__2730__auto__ = e71878;
var statearr_71879_71900 = state_71850;
(statearr_71879_71900[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_71850[(4)]))){
var statearr_71880_71901 = state_71850;
(statearr_71880_71901[(1)] = cljs.core.first.call(null,(state_71850[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71902 = state_71850;
state_71850 = G__71902;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_71850){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_71850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71881 = f__2750__auto__.call(null);
(statearr_71881[(6)] = c__2749__auto__);

return statearr_71881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache.call(null,cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.call(null);
var temp__5802__auto___71927 = fluree.db.connection.lookup_cache.call(null,cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___71927)){
var v_71928 = temp__5802__auto___71927;
cljs.core.async.put_BANG_.call(null,out,v_71928);
} else {
var c__2749__auto___71929 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71914){
var state_val_71915 = (state_71914[(1)]);
if((state_val_71915 === (1))){
var inst_71903 = value_fn.call(null,k);
var state_71914__$1 = state_71914;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71914__$1,(2),inst_71903);
} else {
if((state_val_71915 === (2))){
var inst_71905 = (state_71914[(7)]);
var inst_71905__$1 = (state_71914[(2)]);
var inst_71906 = fluree.db.util.core.exception_QMARK_.call(null,inst_71905__$1);
var state_71914__$1 = (function (){var statearr_71916 = state_71914;
(statearr_71916[(7)] = inst_71905__$1);

return statearr_71916;
})();
if(inst_71906){
var statearr_71917_71930 = state_71914__$1;
(statearr_71917_71930[(1)] = (3));

} else {
var statearr_71918_71931 = state_71914__$1;
(statearr_71918_71931[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71915 === (3))){
var state_71914__$1 = state_71914;
var statearr_71919_71932 = state_71914__$1;
(statearr_71919_71932[(2)] = null);

(statearr_71919_71932[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71915 === (4))){
var inst_71905 = (state_71914[(7)]);
var inst_71909 = cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,inst_71905);
var state_71914__$1 = state_71914;
var statearr_71920_71933 = state_71914__$1;
(statearr_71920_71933[(2)] = inst_71909);

(statearr_71920_71933[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71915 === (5))){
var inst_71905 = (state_71914[(7)]);
var inst_71911 = (state_71914[(2)]);
var inst_71912 = cljs.core.async.put_BANG_.call(null,out,inst_71905);
var state_71914__$1 = (function (){var statearr_71921 = state_71914;
(statearr_71921[(8)] = inst_71911);

return statearr_71921;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71914__$1,inst_71912);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_71922 = [null,null,null,null,null,null,null,null,null];
(statearr_71922[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__);

(statearr_71922[(1)] = (1));

return statearr_71922;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1 = (function (state_71914){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_71914);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71923){var ex__2730__auto__ = e71923;
var statearr_71924_71934 = state_71914;
(statearr_71924_71934[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_71914[(4)]))){
var statearr_71925_71935 = state_71914;
(statearr_71925_71935[(1)] = cljs.core.first.call(null,(state_71914[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71936 = state_71914;
state_71914 = G__71936;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__ = function(state_71914){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1.call(this,state_71914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71926 = f__2750__auto__.call(null);
(statearr_71926[(6)] = c__2749__auto___71929);

return statearr_71926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__71937_SHARP_){
if(cljs.core.truth_(p1__71937_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__71938_SHARP_){
var or__4253__auto__ = p1__71938_SHARP_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return token;
}
}));

return true;
}catch (e71939){var e = e71939;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__71940 = opts;
var map__71940__$1 = cljs.core.__destructure_map.call(null,map__71940);
var sub_chan = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var keep_alive = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var async_cache = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__71940__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__4253__auto__ = object_cache;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__4253__auto__ = async_cache;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_async_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4253__auto__ = storage_read;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4253__auto__ = storage_exists;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = storage_read;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4251__auto__ = storage_write;
if(cljs.core.truth_(and__4251__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,keep_alive,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71984 = arguments.length;
var i__4865__auto___71985 = (0);
while(true){
if((i__4865__auto___71985 < len__4864__auto___71984)){
args__4870__auto__.push((arguments[i__4865__auto___71985]));

var G__71986 = (i__4865__auto___71985 + (1));
i__4865__auto___71985 = G__71986;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__71943){
var vec__71944 = p__71943;
var opts = cljs.core.nth.call(null,vec__71944,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2749__auto___71987 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71967){
var state_val_71968 = (state_71967[(1)]);
if((state_val_71968 === (1))){
var inst_71947 = fluree.db.connection.get_socket.call(null,conn);
var state_71967__$1 = state_71967;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71967__$1,(2),inst_71947);
} else {
if((state_val_71968 === (2))){
var inst_71950 = (state_71967[(7)]);
var inst_71949 = (state_71967[(8)]);
var inst_71949__$1 = (state_71967[(2)]);
var inst_71950__$1 = (inst_71949__$1 == null);
var state_71967__$1 = (function (){var statearr_71969 = state_71967;
(statearr_71969[(7)] = inst_71950__$1);

(statearr_71969[(8)] = inst_71949__$1);

return statearr_71969;
})();
if(cljs.core.truth_(inst_71950__$1)){
var statearr_71970_71988 = state_71967__$1;
(statearr_71970_71988[(1)] = (3));

} else {
var statearr_71971_71989 = state_71967__$1;
(statearr_71971_71989[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71968 === (3))){
var inst_71950 = (state_71967[(7)]);
var state_71967__$1 = state_71967;
var statearr_71972_71990 = state_71967__$1;
(statearr_71972_71990[(2)] = inst_71950);

(statearr_71972_71990[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71968 === (4))){
var inst_71949 = (state_71967[(8)]);
var inst_71953 = fluree.db.util.core.exception_QMARK_.call(null,inst_71949);
var state_71967__$1 = state_71967;
var statearr_71973_71991 = state_71967__$1;
(statearr_71973_71991[(2)] = inst_71953);

(statearr_71973_71991[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71968 === (5))){
var inst_71955 = (state_71967[(2)]);
var state_71967__$1 = state_71967;
if(cljs.core.truth_(inst_71955)){
var statearr_71974_71992 = state_71967__$1;
(statearr_71974_71992[(1)] = (6));

} else {
var statearr_71975_71993 = state_71967__$1;
(statearr_71975_71993[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71968 === (6))){
var inst_71949 = (state_71967[(8)]);
var inst_71957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71958 = [inst_71949,"Cannot establish connection to a healthy server, disconnecting."];
var inst_71959 = (new cljs.core.PersistentVector(null,2,(5),inst_71957,inst_71958,null));
var inst_71960 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71959);
var inst_71961 = cljs.core.async.close_BANG_.call(null,conn);
var state_71967__$1 = (function (){var statearr_71976 = state_71967;
(statearr_71976[(9)] = inst_71960);

return statearr_71976;
})();
var statearr_71977_71994 = state_71967__$1;
(statearr_71977_71994[(2)] = inst_71961);

(statearr_71977_71994[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71968 === (7))){
var inst_71963 = fluree.db.connection.msg_consumer.call(null,conn);
var state_71967__$1 = state_71967;
var statearr_71978_71995 = state_71967__$1;
(statearr_71978_71995[(2)] = inst_71963);

(statearr_71978_71995[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71968 === (8))){
var inst_71965 = (state_71967[(2)]);
var state_71967__$1 = state_71967;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71967__$1,inst_71965);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_71979 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71979[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_71979[(1)] = (1));

return statearr_71979;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_71967){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_71967);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71980){var ex__2730__auto__ = e71980;
var statearr_71981_71996 = state_71967;
(statearr_71981_71996[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_71967[(4)]))){
var statearr_71982_71997 = state_71967;
(statearr_71982_71997[(1)] = cljs.core.first.call(null,(state_71967[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71998 = state_71967;
state_71967 = G__71998;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_71967){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_71967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71983 = f__2750__auto__.call(null);
(statearr_71983[(6)] = c__2749__auto___71987);

return statearr_71983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq71941){
var G__71942 = cljs.core.first.call(null,seq71941);
var seq71941__$1 = cljs.core.next.call(null,seq71941);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71942,seq71941__$1);
}));

