// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__72009 = arguments.length;
switch (G__72009) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72054){
var state_val_72055 = (state_72054[(1)]);
if((state_val_72055 === (7))){
var inst_72024 = typeof user === 'string';
var state_72054__$1 = state_72054;
if(cljs.core.truth_(inst_72024)){
var statearr_72056_72085 = state_72054__$1;
(statearr_72056_72085[(1)] = (9));

} else {
var statearr_72057_72086 = state_72054__$1;
(statearr_72057_72086[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72055 === (1))){
var state_72054__$1 = state_72054;
var statearr_72058_72087 = state_72054__$1;
(statearr_72058_72087[(2)] = null);

(statearr_72058_72087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72055 === (4))){
var inst_72010 = (state_72054[(2)]);
var inst_72011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72012 = [inst_72010];
var inst_72013 = (new cljs.core.PersistentVector(null,1,(5),inst_72011,inst_72012,null));
var inst_72014 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72013);
var inst_72015 = reject.call(null,inst_72010);
var state_72054__$1 = (function (){var statearr_72059 = state_72054;
(statearr_72059[(7)] = inst_72014);

return statearr_72059;
})();
var statearr_72060_72088 = state_72054__$1;
(statearr_72060_72088[(2)] = inst_72015);

(statearr_72060_72088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72055 === (15))){
var inst_72043 = (state_72054[(2)]);
var inst_72044 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_72043);
var inst_72045 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72046 = cljs.core.constantly.call(null,inst_72044);
var inst_72047 = cljs.core.swap_BANG_.call(null,inst_72045,inst_72046);
var inst_72048 = fluree.db.connection.add_token.call(null,conn,inst_72044);
var inst_72049 = resolve.call(null,inst_72043);
var _ = (function (){var statearr_72061 = state_72054;
(statearr_72061[(4)] = cljs.core.rest.call(null,(state_72054[(4)])));

return statearr_72061;
})();
var state_72054__$1 = (function (){var statearr_72062 = state_72054;
(statearr_72062[(8)] = inst_72047);

(statearr_72062[(9)] = inst_72048);

return statearr_72062;
})();
var statearr_72063_72089 = state_72054__$1;
(statearr_72063_72089[(2)] = inst_72049);

(statearr_72063_72089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72055 === (13))){
var state_72054__$1 = state_72054;
var statearr_72064_72090 = state_72054__$1;
(statearr_72064_72090[(2)] = null);

(statearr_72064_72090[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72055 === (6))){
var state_72054__$1 = state_72054;
var statearr_72065_72091 = state_72054__$1;
(statearr_72065_72091[(2)] = user);

(statearr_72065_72091[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72055 === (3))){
var inst_72052 = (state_72054[(2)]);
var state_72054__$1 = state_72054;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72054__$1,inst_72052);
} else {
if((state_val_72055 === (12))){
var state_72054__$1 = state_72054;
var statearr_72066_72092 = state_72054__$1;
(statearr_72066_72092[(2)] = user);

(statearr_72066_72092[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72055 === (2))){
var _ = (function (){var statearr_72067 = state_72054;
(statearr_72067[(4)] = cljs.core.cons.call(null,(5),(state_72054[(4)])));

return statearr_72067;
})();
var inst_72021 = typeof user === 'number';
var state_72054__$1 = state_72054;
if(cljs.core.truth_(inst_72021)){
var statearr_72068_72093 = state_72054__$1;
(statearr_72068_72093[(1)] = (6));

} else {
var statearr_72069_72094 = state_72054__$1;
(statearr_72069_72094[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72055 === (11))){
var inst_72035 = (state_72054[(2)]);
var state_72054__$1 = state_72054;
var statearr_72071_72095 = state_72054__$1;
(statearr_72071_72095[(2)] = inst_72035);

(statearr_72071_72095[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72055 === (9))){
var inst_72026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72027 = ["_user/username",user];
var inst_72028 = (new cljs.core.PersistentVector(null,2,(5),inst_72026,inst_72027,null));
var state_72054__$1 = state_72054;
var statearr_72072_72096 = state_72054__$1;
(statearr_72072_72096[(2)] = inst_72028);

(statearr_72072_72096[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72055 === (5))){
var _ = (function (){var statearr_72073 = state_72054;
(statearr_72073[(4)] = cljs.core.rest.call(null,(state_72054[(4)])));

return statearr_72073;
})();
var state_72054__$1 = state_72054;
var ex72070 = (state_72054__$1[(2)]);
var statearr_72074_72097 = state_72054__$1;
(statearr_72074_72097[(5)] = ex72070);


var statearr_72075_72098 = state_72054__$1;
(statearr_72075_72098[(1)] = (4));

(statearr_72075_72098[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72055 === (14))){
var inst_72033 = (state_72054[(2)]);
var state_72054__$1 = state_72054;
var statearr_72076_72099 = state_72054__$1;
(statearr_72076_72099[(2)] = inst_72033);

(statearr_72076_72099[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72055 === (10))){
var state_72054__$1 = state_72054;
var statearr_72077_72100 = state_72054__$1;
(statearr_72077_72100[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72055 === (8))){
var inst_72037 = (state_72054[(2)]);
var inst_72038 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_72039 = [account,inst_72037,password,expireSeconds,syncTo];
var inst_72040 = cljs.core.PersistentHashMap.fromArrays(inst_72038,inst_72039);
var inst_72041 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_72040);
var state_72054__$1 = state_72054;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72054__$1,(15),inst_72041);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72079 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72079[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72079[(1)] = (1));

return statearr_72079;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72054){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_72054);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72080){var ex__2730__auto__ = e72080;
var statearr_72081_72101 = state_72054;
(statearr_72081_72101[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_72054[(4)]))){
var statearr_72082_72102 = state_72054;
(statearr_72082_72102[(1)] = cljs.core.first.call(null,(state_72054[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72103 = state_72054;
state_72054 = G__72103;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72054){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72054);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72083 = f__2750__auto__.call(null);
(statearr_72083[(6)] = c__2749__auto__);

return statearr_72083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__72105 = arguments.length;
switch (G__72105) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72114){
var state_val_72115 = (state_72114[(1)]);
if((state_val_72115 === (1))){
var inst_72106 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72108 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_72109 = (new cljs.core.PersistentVector(null,4,(5),inst_72107,inst_72108,null));
var inst_72110 = cljs.core.async.put_BANG_.call(null,inst_72106,inst_72109);
var inst_72111 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__72116 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__72117 = null;
var count__72118 = (0);
var i__72119 = (0);
while(true){
if((i__72119 < count__72118)){
var k = cljs.core._nth.call(null,chunk__72117,i__72119);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__72127 = seq__72116;
var G__72128 = chunk__72117;
var G__72129 = count__72118;
var G__72130 = (i__72119 + (1));
seq__72116 = G__72127;
chunk__72117 = G__72128;
count__72118 = G__72129;
i__72119 = G__72130;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__72116);
if(temp__5804__auto__){
var seq__72116__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__72116__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__72116__$1);
var G__72131 = cljs.core.chunk_rest.call(null,seq__72116__$1);
var G__72132 = c__4679__auto__;
var G__72133 = cljs.core.count.call(null,c__4679__auto__);
var G__72134 = (0);
seq__72116 = G__72131;
chunk__72117 = G__72132;
count__72118 = G__72133;
i__72119 = G__72134;
continue;
} else {
var k = cljs.core.first.call(null,seq__72116__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__72135 = cljs.core.next.call(null,seq__72116__$1);
var G__72136 = null;
var G__72137 = (0);
var G__72138 = (0);
seq__72116 = G__72135;
chunk__72117 = G__72136;
count__72118 = G__72137;
i__72119 = G__72138;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_72112 = cljs.core.async.take_BANG_.call(null,pc,inst_72111);
var state_72114__$1 = (function (){var statearr_72120 = state_72114;
(statearr_72120[(7)] = inst_72110);

return statearr_72120;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72114__$1,inst_72112);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72121 = [null,null,null,null,null,null,null,null];
(statearr_72121[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72121[(1)] = (1));

return statearr_72121;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72114){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_72114);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72122){var ex__2730__auto__ = e72122;
var statearr_72123_72139 = state_72114;
(statearr_72123_72139[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_72114[(4)]))){
var statearr_72124_72140 = state_72114;
(statearr_72124_72140[(1)] = cljs.core.first.call(null,(state_72114[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72141 = state_72114;
state_72114 = G__72141;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72114){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72125 = f__2750__auto__.call(null);
(statearr_72125[(6)] = c__2749__auto__);

return statearr_72125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__72143 = arguments.length;
switch (G__72143) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72180){
var state_val_72181 = (state_72180[(1)]);
if((state_val_72181 === (1))){
var state_72180__$1 = state_72180;
var statearr_72182_72203 = state_72180__$1;
(statearr_72182_72203[(2)] = null);

(statearr_72182_72203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72181 === (2))){
var _ = (function (){var statearr_72183 = state_72180;
(statearr_72183[(4)] = cljs.core.cons.call(null,(5),(state_72180[(4)])));

return statearr_72183;
})();
var inst_72155 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_72156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72157 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_72158 = (new cljs.core.PersistentVector(null,1,(5),inst_72156,inst_72157,null));
var inst_72159 = cljs.core.PersistentHashMap.EMPTY;
var inst_72160 = cljs.core.atom.call(null,inst_72159);
var inst_72161 = cljs.core.assoc_in.call(null,inst_72155,inst_72158,inst_72160);
var inst_72162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72163 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_72164 = (new cljs.core.PersistentVector(null,1,(5),inst_72162,inst_72163,null));
var inst_72165 = cljs.core.PersistentHashMap.EMPTY;
var inst_72166 = cljs.core.atom.call(null,inst_72165);
var inst_72167 = cljs.core.assoc_in.call(null,inst_72161,inst_72164,inst_72166);
var inst_72168 = cljs.core.async.promise_chan.call(null);
var inst_72169 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_72167);
var inst_72170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72171 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_72168,null];
var inst_72172 = (new cljs.core.PersistentVector(null,4,(5),inst_72170,inst_72171,null));
var inst_72173 = cljs.core.async.put_BANG_.call(null,inst_72169,inst_72172);
var inst_72174 = (function (){var conn = inst_72167;
var pc = inst_72168;
return (function (x){
if((x == null)){
} else {
var seq__72184_72204 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__72185_72205 = null;
var count__72186_72206 = (0);
var i__72187_72207 = (0);
while(true){
if((i__72187_72207 < count__72186_72206)){
var k_72208 = cljs.core._nth.call(null,chunk__72185_72205,i__72187_72207);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_72208], null),cljs.core.get.call(null,x,k_72208,null));


var G__72209 = seq__72184_72204;
var G__72210 = chunk__72185_72205;
var G__72211 = count__72186_72206;
var G__72212 = (i__72187_72207 + (1));
seq__72184_72204 = G__72209;
chunk__72185_72205 = G__72210;
count__72186_72206 = G__72211;
i__72187_72207 = G__72212;
continue;
} else {
var temp__5804__auto___72213 = cljs.core.seq.call(null,seq__72184_72204);
if(temp__5804__auto___72213){
var seq__72184_72214__$1 = temp__5804__auto___72213;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__72184_72214__$1)){
var c__4679__auto___72215 = cljs.core.chunk_first.call(null,seq__72184_72214__$1);
var G__72216 = cljs.core.chunk_rest.call(null,seq__72184_72214__$1);
var G__72217 = c__4679__auto___72215;
var G__72218 = cljs.core.count.call(null,c__4679__auto___72215);
var G__72219 = (0);
seq__72184_72204 = G__72216;
chunk__72185_72205 = G__72217;
count__72186_72206 = G__72218;
i__72187_72207 = G__72219;
continue;
} else {
var k_72220 = cljs.core.first.call(null,seq__72184_72214__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_72220], null),cljs.core.get.call(null,x,k_72220,null));


var G__72221 = cljs.core.next.call(null,seq__72184_72214__$1);
var G__72222 = null;
var G__72223 = (0);
var G__72224 = (0);
seq__72184_72204 = G__72221;
chunk__72185_72205 = G__72222;
count__72186_72206 = G__72223;
i__72187_72207 = G__72224;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_72175 = cljs.core.async.take_BANG_.call(null,inst_72168,inst_72174);
var ___$1 = (function (){var statearr_72188 = state_72180;
(statearr_72188[(4)] = cljs.core.rest.call(null,(state_72180[(4)])));

return statearr_72188;
})();
var state_72180__$1 = (function (){var statearr_72189 = state_72180;
(statearr_72189[(7)] = inst_72173);

return statearr_72189;
})();
var statearr_72190_72225 = state_72180__$1;
(statearr_72190_72225[(2)] = inst_72175);

(statearr_72190_72225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72181 === (3))){
var inst_72178 = (state_72180[(2)]);
var state_72180__$1 = state_72180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72180__$1,inst_72178);
} else {
if((state_val_72181 === (4))){
var inst_72144 = (state_72180[(2)]);
var inst_72145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72146 = [inst_72144];
var inst_72147 = (new cljs.core.PersistentVector(null,1,(5),inst_72145,inst_72146,null));
var inst_72148 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72147);
var inst_72149 = reject.call(null,inst_72144);
var state_72180__$1 = (function (){var statearr_72192 = state_72180;
(statearr_72192[(8)] = inst_72148);

return statearr_72192;
})();
var statearr_72193_72226 = state_72180__$1;
(statearr_72193_72226[(2)] = inst_72149);

(statearr_72193_72226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72181 === (5))){
var _ = (function (){var statearr_72194 = state_72180;
(statearr_72194[(4)] = cljs.core.rest.call(null,(state_72180[(4)])));

return statearr_72194;
})();
var state_72180__$1 = state_72180;
var ex72191 = (state_72180__$1[(2)]);
var statearr_72195_72227 = state_72180__$1;
(statearr_72195_72227[(5)] = ex72191);


var statearr_72196_72228 = state_72180__$1;
(statearr_72196_72228[(1)] = (4));

(statearr_72196_72228[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72197 = [null,null,null,null,null,null,null,null,null];
(statearr_72197[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72197[(1)] = (1));

return statearr_72197;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72180){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_72180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72198){var ex__2730__auto__ = e72198;
var statearr_72199_72229 = state_72180;
(statearr_72199_72229[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_72180[(4)]))){
var statearr_72200_72230 = state_72180;
(statearr_72200_72230[(1)] = cljs.core.first.call(null,(state_72180[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72231 = state_72180;
state_72180 = G__72231;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72180){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72201 = f__2750__auto__.call(null);
(statearr_72201[(6)] = c__2749__auto__);

return statearr_72201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__72233 = arguments.length;
switch (G__72233) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__72235 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__72235,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__72235,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__72238 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__72238,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__72238,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72291){
var state_val_72292 = (state_72291[(1)]);
if((state_val_72292 === (7))){
var inst_72252 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72253 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72254 = cljs.core.PersistentHashMap.fromArrays(inst_72252,inst_72253);
var inst_72255 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_72254);
var inst_72256 = (function(){throw inst_72255})();
var state_72291__$1 = state_72291;
var statearr_72293_72322 = state_72291__$1;
(statearr_72293_72322[(2)] = inst_72256);

(statearr_72293_72322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (1))){
var state_72291__$1 = state_72291;
var statearr_72294_72323 = state_72291__$1;
(statearr_72294_72323[(2)] = null);

(statearr_72294_72323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (4))){
var inst_72241 = (state_72291[(2)]);
var inst_72242 = cljs.core.clj__GT_js.call(null,inst_72241);
var inst_72243 = reject.call(null,inst_72242);
var state_72291__$1 = state_72291;
var statearr_72295_72324 = state_72291__$1;
(statearr_72295_72324[(2)] = inst_72243);

(statearr_72295_72324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (13))){
var inst_72270 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72271 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72272 = cljs.core.PersistentHashMap.fromArrays(inst_72270,inst_72271);
var inst_72273 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_72272);
var inst_72274 = (function(){throw inst_72273})();
var state_72291__$1 = state_72291;
var statearr_72296_72325 = state_72291__$1;
(statearr_72296_72325[(2)] = inst_72274);

(statearr_72296_72325[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (6))){
var state_72291__$1 = state_72291;
var statearr_72297_72326 = state_72291__$1;
(statearr_72297_72326[(2)] = null);

(statearr_72297_72326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (3))){
var inst_72289 = (state_72291[(2)]);
var state_72291__$1 = state_72291;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72291__$1,inst_72289);
} else {
if((state_val_72292 === (12))){
var state_72291__$1 = state_72291;
var statearr_72298_72327 = state_72291__$1;
(statearr_72298_72327[(2)] = null);

(statearr_72298_72327[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (2))){
var _ = (function (){var statearr_72299 = state_72291;
(statearr_72299[(4)] = cljs.core.cons.call(null,(5),(state_72291[(4)])));

return statearr_72299;
})();
var inst_72249 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_72291__$1 = state_72291;
if(cljs.core.truth_(inst_72249)){
var statearr_72300_72328 = state_72291__$1;
(statearr_72300_72328[(1)] = (6));

} else {
var statearr_72301_72329 = state_72291__$1;
(statearr_72301_72329[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (11))){
var inst_72267 = (state_72291[(2)]);
var state_72291__$1 = (function (){var statearr_72303 = state_72291;
(statearr_72303[(7)] = inst_72267);

return statearr_72303;
})();
if(cljs.core.truth_(password)){
var statearr_72304_72330 = state_72291__$1;
(statearr_72304_72330[(1)] = (12));

} else {
var statearr_72305_72331 = state_72291__$1;
(statearr_72305_72331[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (9))){
var state_72291__$1 = state_72291;
var statearr_72306_72332 = state_72291__$1;
(statearr_72306_72332[(2)] = null);

(statearr_72306_72332[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (5))){
var _ = (function (){var statearr_72307 = state_72291;
(statearr_72307[(4)] = cljs.core.rest.call(null,(state_72291[(4)])));

return statearr_72307;
})();
var state_72291__$1 = state_72291;
var ex72302 = (state_72291__$1[(2)]);
var statearr_72308_72333 = state_72291__$1;
(statearr_72308_72333[(5)] = ex72302);


var statearr_72309_72334 = state_72291__$1;
(statearr_72309_72334[(1)] = (4));

(statearr_72309_72334[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (14))){
var inst_72276 = (state_72291[(2)]);
var inst_72277 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_72278 = fluree.db.util.core.without_nils.call(null,inst_72277);
var inst_72279 = cljs.core.async.promise_chan.call(null);
var inst_72280 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72282 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_72278,inst_72279,null];
var inst_72283 = (new cljs.core.PersistentVector(null,4,(5),inst_72281,inst_72282,null));
var inst_72284 = cljs.core.async.put_BANG_.call(null,inst_72280,inst_72283);
var inst_72285 = (function (){var _ = inst_72276;
var data = inst_72278;
var pc = inst_72279;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_72286 = cljs.core.async.take_BANG_.call(null,inst_72279,inst_72285);
var _ = (function (){var statearr_72310 = state_72291;
(statearr_72310[(4)] = cljs.core.rest.call(null,(state_72291[(4)])));

return statearr_72310;
})();
var state_72291__$1 = (function (){var statearr_72311 = state_72291;
(statearr_72311[(8)] = inst_72284);

return statearr_72311;
})();
var statearr_72312_72335 = state_72291__$1;
(statearr_72312_72335[(2)] = inst_72286);

(statearr_72312_72335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (10))){
var inst_72261 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72262 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72263 = cljs.core.PersistentHashMap.fromArrays(inst_72261,inst_72262);
var inst_72264 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_72263);
var inst_72265 = (function(){throw inst_72264})();
var state_72291__$1 = state_72291;
var statearr_72313_72336 = state_72291__$1;
(statearr_72313_72336[(2)] = inst_72265);

(statearr_72313_72336[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (8))){
var inst_72258 = (state_72291[(2)]);
var state_72291__$1 = (function (){var statearr_72314 = state_72291;
(statearr_72314[(9)] = inst_72258);

return statearr_72314;
})();
if(cljs.core.truth_(ledger)){
var statearr_72315_72337 = state_72291__$1;
(statearr_72315_72337[(1)] = (9));

} else {
var statearr_72316_72338 = state_72291__$1;
(statearr_72316_72338[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0 = (function (){
var statearr_72317 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72317[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2727__auto__);

(statearr_72317[(1)] = (1));

return statearr_72317;
});
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1 = (function (state_72291){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_72291);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72318){var ex__2730__auto__ = e72318;
var statearr_72319_72339 = state_72291;
(statearr_72319_72339[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_72291[(4)]))){
var statearr_72320_72340 = state_72291;
(statearr_72320_72340[(1)] = cljs.core.first.call(null,(state_72291[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72341 = state_72291;
state_72291 = G__72341;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = function(state_72291){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1.call(this,state_72291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72321 = f__2750__auto__.call(null);
(statearr_72321[(6)] = c__2749__auto__);

return statearr_72321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__72343 = arguments.length;
switch (G__72343) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72410){
var state_val_72411 = (state_72410[(1)]);
if((state_val_72411 === (7))){
var inst_72355 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72356 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72357 = cljs.core.PersistentHashMap.fromArrays(inst_72355,inst_72356);
var inst_72358 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_72357);
var inst_72359 = (function(){throw inst_72358})();
var state_72410__$1 = state_72410;
var statearr_72412_72451 = state_72410__$1;
(statearr_72412_72451[(2)] = inst_72359);

(statearr_72412_72451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (20))){
var inst_72393 = (state_72410[(2)]);
var inst_72394 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_72395 = [ledger,password,user,auth,expire];
var inst_72396 = cljs.core.PersistentHashMap.fromArrays(inst_72394,inst_72395);
var inst_72397 = fluree.db.util.core.without_nils.call(null,inst_72396);
var inst_72398 = cljs.core.async.promise_chan.call(null);
var inst_72399 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72401 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_72397,inst_72398,null];
var inst_72402 = (new cljs.core.PersistentVector(null,4,(5),inst_72400,inst_72401,null));
var inst_72403 = cljs.core.async.put_BANG_.call(null,inst_72399,inst_72402);
var inst_72404 = (function (){var _ = inst_72393;
var data = inst_72397;
var pc = inst_72398;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_72405 = cljs.core.async.take_BANG_.call(null,inst_72398,inst_72404);
var _ = (function (){var statearr_72413 = state_72410;
(statearr_72413[(4)] = cljs.core.rest.call(null,(state_72410[(4)])));

return statearr_72413;
})();
var state_72410__$1 = (function (){var statearr_72414 = state_72410;
(statearr_72414[(7)] = inst_72403);

return statearr_72414;
})();
var statearr_72415_72452 = state_72410__$1;
(statearr_72415_72452[(2)] = inst_72405);

(statearr_72415_72452[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (1))){
var state_72410__$1 = state_72410;
var statearr_72416_72453 = state_72410__$1;
(statearr_72416_72453[(2)] = null);

(statearr_72416_72453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (4))){
var inst_72344 = (state_72410[(2)]);
var inst_72345 = cljs.core.clj__GT_js.call(null,inst_72344);
var inst_72346 = reject.call(null,inst_72345);
var state_72410__$1 = state_72410;
var statearr_72417_72454 = state_72410__$1;
(statearr_72417_72454[(2)] = inst_72346);

(statearr_72417_72454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (15))){
var inst_72380 = (state_72410[(8)]);
var state_72410__$1 = state_72410;
var statearr_72418_72455 = state_72410__$1;
(statearr_72418_72455[(2)] = inst_72380);

(statearr_72418_72455[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (13))){
var inst_72373 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72374 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72375 = cljs.core.PersistentHashMap.fromArrays(inst_72373,inst_72374);
var inst_72376 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_72375);
var inst_72377 = (function(){throw inst_72376})();
var state_72410__$1 = state_72410;
var statearr_72419_72456 = state_72410__$1;
(statearr_72419_72456[(2)] = inst_72377);

(statearr_72419_72456[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (6))){
var state_72410__$1 = state_72410;
var statearr_72420_72457 = state_72410__$1;
(statearr_72420_72457[(2)] = null);

(statearr_72420_72457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (17))){
var inst_72384 = (state_72410[(2)]);
var state_72410__$1 = state_72410;
if(cljs.core.truth_(inst_72384)){
var statearr_72421_72458 = state_72410__$1;
(statearr_72421_72458[(1)] = (18));

} else {
var statearr_72422_72459 = state_72410__$1;
(statearr_72422_72459[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (3))){
var inst_72408 = (state_72410[(2)]);
var state_72410__$1 = state_72410;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72410__$1,inst_72408);
} else {
if((state_val_72411 === (12))){
var state_72410__$1 = state_72410;
var statearr_72423_72460 = state_72410__$1;
(statearr_72423_72460[(2)] = null);

(statearr_72423_72460[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (2))){
var _ = (function (){var statearr_72424 = state_72410;
(statearr_72424[(4)] = cljs.core.cons.call(null,(5),(state_72410[(4)])));

return statearr_72424;
})();
var inst_72352 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_72410__$1 = state_72410;
if(cljs.core.truth_(inst_72352)){
var statearr_72425_72461 = state_72410__$1;
(statearr_72425_72461[(1)] = (6));

} else {
var statearr_72426_72462 = state_72410__$1;
(statearr_72426_72462[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (19))){
var inst_72387 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72388 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72389 = cljs.core.PersistentHashMap.fromArrays(inst_72387,inst_72388);
var inst_72390 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_72389);
var inst_72391 = (function(){throw inst_72390})();
var state_72410__$1 = state_72410;
var statearr_72427_72463 = state_72410__$1;
(statearr_72427_72463[(2)] = inst_72391);

(statearr_72427_72463[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (11))){
var inst_72370 = (state_72410[(2)]);
var state_72410__$1 = (function (){var statearr_72429 = state_72410;
(statearr_72429[(9)] = inst_72370);

return statearr_72429;
})();
if(cljs.core.truth_(password)){
var statearr_72430_72464 = state_72410__$1;
(statearr_72430_72464[(1)] = (12));

} else {
var statearr_72431_72465 = state_72410__$1;
(statearr_72431_72465[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (9))){
var state_72410__$1 = state_72410;
var statearr_72432_72466 = state_72410__$1;
(statearr_72432_72466[(2)] = null);

(statearr_72432_72466[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (5))){
var _ = (function (){var statearr_72433 = state_72410;
(statearr_72433[(4)] = cljs.core.rest.call(null,(state_72410[(4)])));

return statearr_72433;
})();
var state_72410__$1 = state_72410;
var ex72428 = (state_72410__$1[(2)]);
var statearr_72434_72467 = state_72410__$1;
(statearr_72434_72467[(5)] = ex72428);


var statearr_72435_72468 = state_72410__$1;
(statearr_72435_72468[(1)] = (4));

(statearr_72435_72468[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (14))){
var inst_72380 = (state_72410[(8)]);
var inst_72379 = (state_72410[(2)]);
var inst_72380__$1 = user;
var state_72410__$1 = (function (){var statearr_72436 = state_72410;
(statearr_72436[(10)] = inst_72379);

(statearr_72436[(8)] = inst_72380__$1);

return statearr_72436;
})();
if(cljs.core.truth_(inst_72380__$1)){
var statearr_72437_72469 = state_72410__$1;
(statearr_72437_72469[(1)] = (15));

} else {
var statearr_72438_72470 = state_72410__$1;
(statearr_72438_72470[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (16))){
var state_72410__$1 = state_72410;
var statearr_72439_72471 = state_72410__$1;
(statearr_72439_72471[(2)] = auth);

(statearr_72439_72471[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (10))){
var inst_72364 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72365 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72366 = cljs.core.PersistentHashMap.fromArrays(inst_72364,inst_72365);
var inst_72367 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_72366);
var inst_72368 = (function(){throw inst_72367})();
var state_72410__$1 = state_72410;
var statearr_72440_72472 = state_72410__$1;
(statearr_72440_72472[(2)] = inst_72368);

(statearr_72440_72472[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (18))){
var state_72410__$1 = state_72410;
var statearr_72441_72473 = state_72410__$1;
(statearr_72441_72473[(2)] = null);

(statearr_72441_72473[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72411 === (8))){
var inst_72361 = (state_72410[(2)]);
var state_72410__$1 = (function (){var statearr_72442 = state_72410;
(statearr_72442[(11)] = inst_72361);

return statearr_72442;
})();
if(cljs.core.truth_(ledger)){
var statearr_72443_72474 = state_72410__$1;
(statearr_72443_72474[(1)] = (9));

} else {
var statearr_72444_72475 = state_72410__$1;
(statearr_72444_72475[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72445 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72445[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72445[(1)] = (1));

return statearr_72445;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72410){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_72410);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72446){var ex__2730__auto__ = e72446;
var statearr_72447_72476 = state_72410;
(statearr_72447_72476[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_72410[(4)]))){
var statearr_72448_72477 = state_72410;
(statearr_72448_72477[(1)] = cljs.core.first.call(null,(state_72410[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72478 = state_72410;
state_72410 = G__72478;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72410){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72449 = f__2750__auto__.call(null);
(statearr_72449[(6)] = c__2749__auto__);

return statearr_72449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__72480 = arguments.length;
switch (G__72480) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72515){
var state_val_72516 = (state_72515[(1)]);
if((state_val_72516 === (1))){
var state_72515__$1 = state_72515;
var statearr_72517_72537 = state_72515__$1;
(statearr_72517_72537[(2)] = null);

(statearr_72517_72537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72516 === (2))){
var _ = (function (){var statearr_72518 = state_72515;
(statearr_72518[(4)] = cljs.core.cons.call(null,(5),(state_72515[(4)])));

return statearr_72518;
})();
var inst_72489 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_72515__$1 = state_72515;
if(cljs.core.truth_(inst_72489)){
var statearr_72519_72538 = state_72515__$1;
(statearr_72519_72538[(1)] = (6));

} else {
var statearr_72520_72539 = state_72515__$1;
(statearr_72520_72539[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72516 === (3))){
var inst_72513 = (state_72515[(2)]);
var state_72515__$1 = state_72515;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72515__$1,inst_72513);
} else {
if((state_val_72516 === (4))){
var inst_72481 = (state_72515[(2)]);
var inst_72482 = cljs.core.clj__GT_js.call(null,inst_72481);
var inst_72483 = reject.call(null,inst_72482);
var state_72515__$1 = state_72515;
var statearr_72522_72540 = state_72515__$1;
(statearr_72522_72540[(2)] = inst_72483);

(statearr_72522_72540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72516 === (5))){
var _ = (function (){var statearr_72523 = state_72515;
(statearr_72523[(4)] = cljs.core.rest.call(null,(state_72515[(4)])));

return statearr_72523;
})();
var state_72515__$1 = state_72515;
var ex72521 = (state_72515__$1[(2)]);
var statearr_72524_72541 = state_72515__$1;
(statearr_72524_72541[(5)] = ex72521);


var statearr_72525_72542 = state_72515__$1;
(statearr_72525_72542[(1)] = (4));

(statearr_72525_72542[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72516 === (6))){
var state_72515__$1 = state_72515;
var statearr_72526_72543 = state_72515__$1;
(statearr_72526_72543[(2)] = null);

(statearr_72526_72543[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72516 === (7))){
var inst_72492 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72493 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72494 = cljs.core.PersistentHashMap.fromArrays(inst_72492,inst_72493);
var inst_72495 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_72494);
var inst_72496 = (function(){throw inst_72495})();
var state_72515__$1 = state_72515;
var statearr_72527_72544 = state_72515__$1;
(statearr_72527_72544[(2)] = inst_72496);

(statearr_72527_72544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72516 === (8))){
var inst_72498 = (state_72515[(2)]);
var inst_72499 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_72500 = [jwt,expire];
var inst_72501 = cljs.core.PersistentHashMap.fromArrays(inst_72499,inst_72500);
var inst_72502 = fluree.db.util.core.without_nils.call(null,inst_72501);
var inst_72503 = cljs.core.async.promise_chan.call(null);
var inst_72504 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72506 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_72502,inst_72503,null];
var inst_72507 = (new cljs.core.PersistentVector(null,4,(5),inst_72505,inst_72506,null));
var inst_72508 = cljs.core.async.put_BANG_.call(null,inst_72504,inst_72507);
var inst_72509 = (function (){var _ = inst_72498;
var data = inst_72502;
var pc = inst_72503;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_72510 = cljs.core.async.take_BANG_.call(null,inst_72503,inst_72509);
var _ = (function (){var statearr_72528 = state_72515;
(statearr_72528[(4)] = cljs.core.rest.call(null,(state_72515[(4)])));

return statearr_72528;
})();
var state_72515__$1 = (function (){var statearr_72529 = state_72515;
(statearr_72529[(7)] = inst_72508);

return statearr_72529;
})();
var statearr_72530_72545 = state_72515__$1;
(statearr_72530_72545[(2)] = inst_72510);

(statearr_72530_72545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_72531 = [null,null,null,null,null,null,null,null];
(statearr_72531[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_72531[(1)] = (1));

return statearr_72531;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72515){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_72515);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72532){var ex__2730__auto__ = e72532;
var statearr_72533_72546 = state_72515;
(statearr_72533_72546[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_72515[(4)]))){
var statearr_72534_72547 = state_72515;
(statearr_72534_72547[(1)] = cljs.core.first.call(null,(state_72515[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72548 = state_72515;
state_72515 = G__72548;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72515){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72535 = f__2750__auto__.call(null);
(statearr_72535[(6)] = c__2749__auto__);

return statearr_72535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

