// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4913__auto___52899 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_52950){
var state_val_52951 = (state_52950[(1)]);
if((state_val_52951 === (7))){
var inst_52945 = (state_52950[(2)]);
var _ = (function (){var statearr_52952 = state_52950;
(statearr_52952[(4)] = cljs.core.rest.call(null,(state_52950[(4)])));

return statearr_52952;
})();
var state_52950__$1 = state_52950;
var statearr_52953_52980 = state_52950__$1;
(statearr_52953_52980[(2)] = inst_52945);

(statearr_52953_52980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52951 === (1))){
var state_52950__$1 = state_52950;
var statearr_52954_52981 = state_52950__$1;
(statearr_52954_52981[(2)] = null);

(statearr_52954_52981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52951 === (4))){
var inst_52900 = (state_52950[(2)]);
var state_52950__$1 = state_52950;
var statearr_52955_52982 = state_52950__$1;
(statearr_52955_52982[(2)] = inst_52900);

(statearr_52955_52982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52951 === (13))){
var inst_52941 = (state_52950[(2)]);
var state_52950__$1 = state_52950;
var statearr_52956_52983 = state_52950__$1;
(statearr_52956_52983[(2)] = inst_52941);

(statearr_52956_52983[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52951 === (6))){
var inst_52918 = (state_52950[(7)]);
var inst_52925 = (state_52950[(8)]);
var inst_52924 = cljs.core.seq.call(null,inst_52918);
var inst_52925__$1 = cljs.core.first.call(null,inst_52924);
var inst_52926 = cljs.core.next.call(null,inst_52924);
var inst_52927 = cljs.core.not.call(null,inst_52925__$1);
var state_52950__$1 = (function (){var statearr_52957 = state_52950;
(statearr_52957[(8)] = inst_52925__$1);

(statearr_52957[(9)] = inst_52926);

return statearr_52957;
})();
if(inst_52927){
var statearr_52958_52984 = state_52950__$1;
(statearr_52958_52984[(1)] = (8));

} else {
var statearr_52959_52985 = state_52950__$1;
(statearr_52959_52985[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52951 === (3))){
var inst_52948 = (state_52950[(2)]);
var state_52950__$1 = state_52950;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52950__$1,inst_52948);
} else {
if((state_val_52951 === (12))){
var inst_52919 = (state_52950[(10)]);
var inst_52925 = (state_52950[(8)]);
var inst_52926 = (state_52950[(9)]);
var inst_52938 = cljs.core.conj.call(null,inst_52919,inst_52925);
var inst_52918 = inst_52926;
var inst_52919__$1 = inst_52938;
var state_52950__$1 = (function (){var statearr_52960 = state_52950;
(statearr_52960[(7)] = inst_52918);

(statearr_52960[(10)] = inst_52919__$1);

return statearr_52960;
})();
var statearr_52961_52986 = state_52950__$1;
(statearr_52961_52986[(2)] = null);

(statearr_52961_52986[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52951 === (2))){
var _ = (function (){var statearr_52962 = state_52950;
(statearr_52962[(4)] = cljs.core.cons.call(null,(5),(state_52950[(4)])));

return statearr_52962;
})();
var inst_52913 = args;
var inst_52914 = cljs.core.seq.call(null,inst_52913);
var inst_52915 = cljs.core.first.call(null,inst_52914);
var inst_52916 = cljs.core.next.call(null,inst_52914);
var inst_52917 = cljs.core.PersistentVector.EMPTY;
var inst_52918 = inst_52913;
var inst_52919 = inst_52917;
var state_52950__$1 = (function (){var statearr_52963 = state_52950;
(statearr_52963[(11)] = inst_52916);

(statearr_52963[(7)] = inst_52918);

(statearr_52963[(10)] = inst_52919);

(statearr_52963[(12)] = inst_52915);

return statearr_52963;
})();
var statearr_52964_52987 = state_52950__$1;
(statearr_52964_52987[(2)] = null);

(statearr_52964_52987[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52951 === (11))){
var inst_52925 = (state_52950[(8)]);
var state_52950__$1 = state_52950;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52950__$1,(14),inst_52925);
} else {
if((state_val_52951 === (9))){
var inst_52925 = (state_52950[(8)]);
var inst_52930 = fluree.db.util.async.channel_QMARK_.call(null,inst_52925);
var state_52950__$1 = state_52950;
if(inst_52930){
var statearr_52966_52988 = state_52950__$1;
(statearr_52966_52988[(1)] = (11));

} else {
var statearr_52967_52989 = state_52950__$1;
(statearr_52967_52989[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52951 === (5))){
var _ = (function (){var statearr_52968 = state_52950;
(statearr_52968[(4)] = cljs.core.rest.call(null,(state_52950[(4)])));

return statearr_52968;
})();
var state_52950__$1 = state_52950;
var ex52965 = (state_52950__$1[(2)]);
var statearr_52969_52990 = state_52950__$1;
(statearr_52969_52990[(5)] = ex52965);


if((ex52965 instanceof Error)){
var statearr_52970_52991 = state_52950__$1;
(statearr_52970_52991[(1)] = (4));

(statearr_52970_52991[(5)] = null);

} else {
throw ex52965;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52951 === (14))){
var inst_52919 = (state_52950[(10)]);
var inst_52926 = (state_52950[(9)]);
var inst_52933 = (state_52950[(2)]);
var inst_52934 = fluree.db.util.async.throw_err.call(null,inst_52933);
var inst_52935 = cljs.core.conj.call(null,inst_52919,inst_52934);
var inst_52918 = inst_52926;
var inst_52919__$1 = inst_52935;
var state_52950__$1 = (function (){var statearr_52971 = state_52950;
(statearr_52971[(7)] = inst_52918);

(statearr_52971[(10)] = inst_52919__$1);

return statearr_52971;
})();
var statearr_52972_52992 = state_52950__$1;
(statearr_52972_52992[(2)] = null);

(statearr_52972_52992[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52951 === (10))){
var inst_52943 = (state_52950[(2)]);
var state_52950__$1 = state_52950;
var statearr_52973_52993 = state_52950__$1;
(statearr_52973_52993[(2)] = inst_52943);

(statearr_52973_52993[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52951 === (8))){
var inst_52919 = (state_52950[(10)]);
var state_52950__$1 = state_52950;
var statearr_52974_52994 = state_52950__$1;
(statearr_52974_52994[(2)] = inst_52919);

(statearr_52974_52994[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0 = (function (){
var statearr_52975 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52975[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__);

(statearr_52975[(1)] = (1));

return statearr_52975;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1 = (function (state_52950){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_52950);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e52976){var ex__2730__auto__ = e52976;
var statearr_52977_52995 = state_52950;
(statearr_52977_52995[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_52950[(4)]))){
var statearr_52978_52996 = state_52950;
(statearr_52978_52996[(1)] = cljs.core.first.call(null,(state_52950[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52997 = state_52950;
state_52950 = G__52997;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = function(state_52950){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1.call(this,state_52950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_52979 = f__2750__auto__.call(null);
(statearr_52979[(6)] = c__2749__auto__);

return statearr_52979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__52999 = entry;
var res = cljs.core.nth.call(null,vec__52999,(0),null);
var cost = cljs.core.nth.call(null,vec__52999,(1),null);
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__52998_SHARP_){
return cljs.core.update.call(null,cljs.core.update.call(null,cljs.core.update.call(null,p1__52998_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53047){
var state_val_53048 = (state_53047[(1)]);
if((state_val_53048 === (7))){
var state_53047__$1 = state_53047;
var statearr_53049_53078 = state_53047__$1;
(statearr_53049_53078[(2)] = coll);

(statearr_53049_53078[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53048 === (1))){
var state_53047__$1 = state_53047;
var statearr_53050_53079 = state_53047__$1;
(statearr_53050_53079[(2)] = null);

(statearr_53050_53079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53048 === (4))){
var inst_53002 = (state_53047[(2)]);
var state_53047__$1 = state_53047;
var statearr_53051_53080 = state_53047__$1;
(statearr_53051_53080[(2)] = inst_53002);

(statearr_53051_53080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53048 === (15))){
var inst_53021 = (state_53047[(7)]);
var inst_53029 = (state_53047[(2)]);
var inst_53030 = fluree.db.dbfunctions.internal.nth.call(null,inst_53021,inst_53029);
var inst_53031 = cljs.core.count.call(null,inst_53021);
var inst_53032 = ((9) + inst_53031);
var inst_53033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53034 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53036 = [inst_53021,inst_53029];
var inst_53037 = (new cljs.core.PersistentVector(null,2,(5),inst_53035,inst_53036,null));
var inst_53038 = ["nth",inst_53037,inst_53030];
var inst_53039 = cljs.core.PersistentHashMap.fromArrays(inst_53034,inst_53038);
var inst_53040 = [inst_53039,inst_53032];
var inst_53041 = (new cljs.core.PersistentVector(null,2,(5),inst_53033,inst_53040,null));
var inst_53042 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53041);
var _ = (function (){var statearr_53052 = state_53047;
(statearr_53052[(4)] = cljs.core.rest.call(null,(state_53047[(4)])));

return statearr_53052;
})();
var state_53047__$1 = (function (){var statearr_53053 = state_53047;
(statearr_53053[(8)] = inst_53042);

return statearr_53053;
})();
var statearr_53054_53081 = state_53047__$1;
(statearr_53054_53081[(2)] = inst_53030);

(statearr_53054_53081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53048 === (13))){
var state_53047__$1 = state_53047;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53047__$1,(16),key);
} else {
if((state_val_53048 === (6))){
var state_53047__$1 = state_53047;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53047__$1,(9),coll);
} else {
if((state_val_53048 === (3))){
var inst_53045 = (state_53047[(2)]);
var state_53047__$1 = state_53047;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53047__$1,inst_53045);
} else {
if((state_val_53048 === (12))){
var inst_53021 = (state_53047[(2)]);
var inst_53022 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_53047__$1 = (function (){var statearr_53055 = state_53047;
(statearr_53055[(7)] = inst_53021);

return statearr_53055;
})();
if(inst_53022){
var statearr_53056_53082 = state_53047__$1;
(statearr_53056_53082[(1)] = (13));

} else {
var statearr_53057_53083 = state_53047__$1;
(statearr_53057_53083[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53048 === (2))){
var _ = (function (){var statearr_53058 = state_53047;
(statearr_53058[(4)] = cljs.core.cons.call(null,(5),(state_53047[(4)])));

return statearr_53058;
})();
var inst_53008 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_53047__$1 = state_53047;
if(inst_53008){
var statearr_53059_53084 = state_53047__$1;
(statearr_53059_53084[(1)] = (6));

} else {
var statearr_53060_53085 = state_53047__$1;
(statearr_53060_53085[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53048 === (11))){
var inst_53015 = (state_53047[(9)]);
var state_53047__$1 = state_53047;
var statearr_53062_53086 = state_53047__$1;
(statearr_53062_53086[(2)] = inst_53015);

(statearr_53062_53086[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53048 === (9))){
var inst_53011 = (state_53047[(2)]);
var inst_53012 = fluree.db.util.async.throw_err.call(null,inst_53011);
var state_53047__$1 = state_53047;
var statearr_53063_53087 = state_53047__$1;
(statearr_53063_53087[(2)] = inst_53012);

(statearr_53063_53087[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53048 === (5))){
var _ = (function (){var statearr_53064 = state_53047;
(statearr_53064[(4)] = cljs.core.rest.call(null,(state_53047[(4)])));

return statearr_53064;
})();
var state_53047__$1 = state_53047;
var ex53061 = (state_53047__$1[(2)]);
var statearr_53065_53088 = state_53047__$1;
(statearr_53065_53088[(5)] = ex53061);


if((ex53061 instanceof Error)){
var statearr_53066_53089 = state_53047__$1;
(statearr_53066_53089[(1)] = (4));

(statearr_53066_53089[(5)] = null);

} else {
throw ex53061;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53048 === (14))){
var state_53047__$1 = state_53047;
var statearr_53067_53090 = state_53047__$1;
(statearr_53067_53090[(2)] = key);

(statearr_53067_53090[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53048 === (16))){
var inst_53025 = (state_53047[(2)]);
var inst_53026 = fluree.db.util.async.throw_err.call(null,inst_53025);
var state_53047__$1 = state_53047;
var statearr_53068_53091 = state_53047__$1;
(statearr_53068_53091[(2)] = inst_53026);

(statearr_53068_53091[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53048 === (10))){
var inst_53015 = (state_53047[(9)]);
var inst_53018 = cljs.core.vec.call(null,inst_53015);
var state_53047__$1 = state_53047;
var statearr_53069_53092 = state_53047__$1;
(statearr_53069_53092[(2)] = inst_53018);

(statearr_53069_53092[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53048 === (8))){
var inst_53015 = (state_53047[(9)]);
var inst_53015__$1 = (state_53047[(2)]);
var inst_53016 = cljs.core.set_QMARK_.call(null,inst_53015__$1);
var state_53047__$1 = (function (){var statearr_53070 = state_53047;
(statearr_53070[(9)] = inst_53015__$1);

return statearr_53070;
})();
if(inst_53016){
var statearr_53071_53093 = state_53047__$1;
(statearr_53071_53093[(1)] = (10));

} else {
var statearr_53072_53094 = state_53047__$1;
(statearr_53072_53094[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0 = (function (){
var statearr_53073 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53073[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__);

(statearr_53073[(1)] = (1));

return statearr_53073;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1 = (function (state_53047){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_53047);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53074){var ex__2730__auto__ = e53074;
var statearr_53075_53095 = state_53047;
(statearr_53075_53095[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_53047[(4)]))){
var statearr_53076_53096 = state_53047;
(statearr_53076_53096[(1)] = cljs.core.first.call(null,(state_53047[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53097 = state_53047;
state_53047 = G__53097;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = function(state_53047){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1.call(this,state_53047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53077 = f__2750__auto__.call(null);
(statearr_53077[(6)] = c__2749__auto__);

return statearr_53077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53158){
var state_val_53159 = (state_53158[(1)]);
if((state_val_53159 === (7))){
var state_53158__$1 = state_53158;
var statearr_53160_53194 = state_53158__$1;
(statearr_53160_53194[(2)] = test);

(statearr_53160_53194[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (20))){
var inst_53132 = (state_53158[(2)]);
var inst_53133 = fluree.db.util.async.throw_err.call(null,inst_53132);
var state_53158__$1 = state_53158;
var statearr_53161_53195 = state_53158__$1;
(statearr_53161_53195[(2)] = inst_53133);

(statearr_53161_53195[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (1))){
var state_53158__$1 = state_53158;
var statearr_53162_53196 = state_53158__$1;
(statearr_53162_53196[(2)] = null);

(statearr_53162_53196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (4))){
var inst_53098 = (state_53158[(2)]);
var state_53158__$1 = state_53158;
var statearr_53163_53197 = state_53158__$1;
(statearr_53163_53197[(2)] = inst_53098);

(statearr_53163_53197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (15))){
var inst_53116 = (state_53158[(7)]);
var inst_53124 = (state_53158[(2)]);
var inst_53125 = [inst_53124,f];
var inst_53126 = (new cljs.core.PersistentVector(null,2,(5),inst_53116,inst_53125,null));
var state_53158__$1 = state_53158;
var statearr_53164_53198 = state_53158__$1;
(statearr_53164_53198[(2)] = inst_53126);

(statearr_53164_53198[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (13))){
var state_53158__$1 = state_53158;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53158__$1,(16),t);
} else {
if((state_val_53159 === (6))){
var state_53158__$1 = state_53158;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53158__$1,(9),test);
} else {
if((state_val_53159 === (17))){
var state_53158__$1 = state_53158;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53158__$1,(20),f);
} else {
if((state_val_53159 === (3))){
var inst_53156 = (state_53158[(2)]);
var state_53158__$1 = state_53158;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53158__$1,inst_53156);
} else {
if((state_val_53159 === (12))){
var inst_53114 = (state_53158[(8)]);
var inst_53140 = (state_53158[(2)]);
var inst_53141 = cljs.core.nth.call(null,inst_53140,(0),null);
var inst_53142 = cljs.core.nth.call(null,inst_53140,(1),null);
var inst_53143 = fluree.db.dbfunctions.internal.if_else.call(null,inst_53114,inst_53141,inst_53142);
var inst_53144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53145 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53147 = [inst_53114,inst_53141,inst_53142];
var inst_53148 = (new cljs.core.PersistentVector(null,3,(5),inst_53146,inst_53147,null));
var inst_53149 = ["if-else",inst_53148,inst_53143];
var inst_53150 = cljs.core.PersistentHashMap.fromArrays(inst_53145,inst_53149);
var inst_53151 = [inst_53150,(10)];
var inst_53152 = (new cljs.core.PersistentVector(null,2,(5),inst_53144,inst_53151,null));
var inst_53153 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53152);
var _ = (function (){var statearr_53165 = state_53158;
(statearr_53165[(4)] = cljs.core.rest.call(null,(state_53158[(4)])));

return statearr_53165;
})();
var state_53158__$1 = (function (){var statearr_53166 = state_53158;
(statearr_53166[(9)] = inst_53153);

return statearr_53166;
})();
var statearr_53167_53199 = state_53158__$1;
(statearr_53167_53199[(2)] = inst_53143);

(statearr_53167_53199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (2))){
var _ = (function (){var statearr_53168 = state_53158;
(statearr_53168[(4)] = cljs.core.cons.call(null,(5),(state_53158[(4)])));

return statearr_53168;
})();
var inst_53107 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_53158__$1 = state_53158;
if(inst_53107){
var statearr_53169_53200 = state_53158__$1;
(statearr_53169_53200[(1)] = (6));

} else {
var statearr_53170_53201 = state_53158__$1;
(statearr_53170_53201[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (19))){
var inst_53128 = (state_53158[(10)]);
var inst_53136 = (state_53158[(2)]);
var inst_53137 = [f,inst_53136];
var inst_53138 = (new cljs.core.PersistentVector(null,2,(5),inst_53128,inst_53137,null));
var state_53158__$1 = state_53158;
var statearr_53171_53202 = state_53158__$1;
(statearr_53171_53202[(2)] = inst_53138);

(statearr_53171_53202[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (11))){
var inst_53128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53129 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_53158__$1 = (function (){var statearr_53173 = state_53158;
(statearr_53173[(10)] = inst_53128);

return statearr_53173;
})();
if(inst_53129){
var statearr_53174_53203 = state_53158__$1;
(statearr_53174_53203[(1)] = (17));

} else {
var statearr_53175_53204 = state_53158__$1;
(statearr_53175_53204[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (9))){
var inst_53110 = (state_53158[(2)]);
var inst_53111 = fluree.db.util.async.throw_err.call(null,inst_53110);
var state_53158__$1 = state_53158;
var statearr_53176_53205 = state_53158__$1;
(statearr_53176_53205[(2)] = inst_53111);

(statearr_53176_53205[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (5))){
var _ = (function (){var statearr_53177 = state_53158;
(statearr_53177[(4)] = cljs.core.rest.call(null,(state_53158[(4)])));

return statearr_53177;
})();
var state_53158__$1 = state_53158;
var ex53172 = (state_53158__$1[(2)]);
var statearr_53178_53206 = state_53158__$1;
(statearr_53178_53206[(5)] = ex53172);


if((ex53172 instanceof Error)){
var statearr_53179_53207 = state_53158__$1;
(statearr_53179_53207[(1)] = (4));

(statearr_53179_53207[(5)] = null);

} else {
throw ex53172;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (14))){
var state_53158__$1 = state_53158;
var statearr_53180_53208 = state_53158__$1;
(statearr_53180_53208[(2)] = t);

(statearr_53180_53208[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (16))){
var inst_53120 = (state_53158[(2)]);
var inst_53121 = fluree.db.util.async.throw_err.call(null,inst_53120);
var state_53158__$1 = state_53158;
var statearr_53181_53209 = state_53158__$1;
(statearr_53181_53209[(2)] = inst_53121);

(statearr_53181_53209[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (10))){
var inst_53116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53117 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_53158__$1 = (function (){var statearr_53182 = state_53158;
(statearr_53182[(7)] = inst_53116);

return statearr_53182;
})();
if(inst_53117){
var statearr_53183_53210 = state_53158__$1;
(statearr_53183_53210[(1)] = (13));

} else {
var statearr_53184_53211 = state_53158__$1;
(statearr_53184_53211[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (18))){
var state_53158__$1 = state_53158;
var statearr_53185_53212 = state_53158__$1;
(statearr_53185_53212[(2)] = f);

(statearr_53185_53212[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53159 === (8))){
var inst_53114 = (state_53158[(8)]);
var inst_53114__$1 = (state_53158[(2)]);
var state_53158__$1 = (function (){var statearr_53186 = state_53158;
(statearr_53186[(8)] = inst_53114__$1);

return statearr_53186;
})();
if(cljs.core.truth_(inst_53114__$1)){
var statearr_53187_53213 = state_53158__$1;
(statearr_53187_53213[(1)] = (10));

} else {
var statearr_53188_53214 = state_53158__$1;
(statearr_53188_53214[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0 = (function (){
var statearr_53189 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_53189[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__);

(statearr_53189[(1)] = (1));

return statearr_53189;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1 = (function (state_53158){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_53158);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53190){var ex__2730__auto__ = e53190;
var statearr_53191_53215 = state_53158;
(statearr_53191_53215[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_53158[(4)]))){
var statearr_53192_53216 = state_53158;
(statearr_53192_53216[(1)] = cljs.core.first.call(null,(state_53158[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53217 = state_53158;
state_53158 = G__53217;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = function(state_53158){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1.call(this,state_53158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53193 = f__2750__auto__.call(null);
(statearr_53193[(6)] = c__2749__auto__);

return statearr_53193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53247){
var state_val_53248 = (state_53247[(1)]);
if((state_val_53248 === (7))){
var state_53247__$1 = state_53247;
var statearr_53249_53268 = state_53247__$1;
(statearr_53249_53268[(2)] = arg);

(statearr_53249_53268[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53248 === (1))){
var state_53247__$1 = state_53247;
var statearr_53250_53269 = state_53247__$1;
(statearr_53250_53269[(2)] = null);

(statearr_53250_53269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53248 === (4))){
var inst_53218 = (state_53247[(2)]);
var state_53247__$1 = state_53247;
var statearr_53251_53270 = state_53247__$1;
(statearr_53251_53270[(2)] = inst_53218);

(statearr_53251_53270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53248 === (6))){
var state_53247__$1 = state_53247;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53247__$1,(9),arg);
} else {
if((state_val_53248 === (3))){
var inst_53245 = (state_53247[(2)]);
var state_53247__$1 = state_53247;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53247__$1,inst_53245);
} else {
if((state_val_53248 === (2))){
var _ = (function (){var statearr_53253 = state_53247;
(statearr_53253[(4)] = cljs.core.cons.call(null,(5),(state_53247[(4)])));

return statearr_53253;
})();
var inst_53224 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_53247__$1 = state_53247;
if(inst_53224){
var statearr_53254_53271 = state_53247__$1;
(statearr_53254_53271[(1)] = (6));

} else {
var statearr_53255_53272 = state_53247__$1;
(statearr_53255_53272[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53248 === (9))){
var inst_53227 = (state_53247[(2)]);
var inst_53228 = fluree.db.util.async.throw_err.call(null,inst_53227);
var state_53247__$1 = state_53247;
var statearr_53256_53273 = state_53247__$1;
(statearr_53256_53273[(2)] = inst_53228);

(statearr_53256_53273[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53248 === (5))){
var _ = (function (){var statearr_53257 = state_53247;
(statearr_53257[(4)] = cljs.core.rest.call(null,(state_53247[(4)])));

return statearr_53257;
})();
var state_53247__$1 = state_53247;
var ex53252 = (state_53247__$1[(2)]);
var statearr_53258_53274 = state_53247__$1;
(statearr_53258_53274[(5)] = ex53252);


if((ex53252 instanceof Error)){
var statearr_53259_53275 = state_53247__$1;
(statearr_53259_53275[(1)] = (4));

(statearr_53259_53275[(5)] = null);

} else {
throw ex53252;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53248 === (8))){
var inst_53231 = (state_53247[(2)]);
var inst_53232 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_53231);
var inst_53233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53234 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53236 = [inst_53231];
var inst_53237 = (new cljs.core.PersistentVector(null,1,(5),inst_53235,inst_53236,null));
var inst_53238 = ["nil?",inst_53237,inst_53232];
var inst_53239 = cljs.core.PersistentHashMap.fromArrays(inst_53234,inst_53238);
var inst_53240 = [inst_53239,(10)];
var inst_53241 = (new cljs.core.PersistentVector(null,2,(5),inst_53233,inst_53240,null));
var inst_53242 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53241);
var _ = (function (){var statearr_53260 = state_53247;
(statearr_53260[(4)] = cljs.core.rest.call(null,(state_53247[(4)])));

return statearr_53260;
})();
var state_53247__$1 = (function (){var statearr_53261 = state_53247;
(statearr_53261[(7)] = inst_53242);

return statearr_53261;
})();
var statearr_53262_53276 = state_53247__$1;
(statearr_53262_53276[(2)] = inst_53232);

(statearr_53262_53276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_53263 = [null,null,null,null,null,null,null,null];
(statearr_53263[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__);

(statearr_53263[(1)] = (1));

return statearr_53263;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1 = (function (state_53247){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_53247);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53264){var ex__2730__auto__ = e53264;
var statearr_53265_53277 = state_53247;
(statearr_53265_53277[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_53247[(4)]))){
var statearr_53266_53278 = state_53247;
(statearr_53266_53278[(1)] = cljs.core.first.call(null,(state_53247[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53279 = state_53247;
state_53247 = G__53279;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = function(state_53247){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1.call(this,state_53247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53267 = f__2750__auto__.call(null);
(statearr_53267[(6)] = c__2749__auto__);

return statearr_53267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53309){
var state_val_53310 = (state_53309[(1)]);
if((state_val_53310 === (7))){
var state_53309__$1 = state_53309;
var statearr_53311_53330 = state_53309__$1;
(statearr_53311_53330[(2)] = arg);

(statearr_53311_53330[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53310 === (1))){
var state_53309__$1 = state_53309;
var statearr_53312_53331 = state_53309__$1;
(statearr_53312_53331[(2)] = null);

(statearr_53312_53331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53310 === (4))){
var inst_53280 = (state_53309[(2)]);
var state_53309__$1 = state_53309;
var statearr_53313_53332 = state_53309__$1;
(statearr_53313_53332[(2)] = inst_53280);

(statearr_53313_53332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53310 === (6))){
var state_53309__$1 = state_53309;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53309__$1,(9),arg);
} else {
if((state_val_53310 === (3))){
var inst_53307 = (state_53309[(2)]);
var state_53309__$1 = state_53309;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53309__$1,inst_53307);
} else {
if((state_val_53310 === (2))){
var _ = (function (){var statearr_53315 = state_53309;
(statearr_53315[(4)] = cljs.core.cons.call(null,(5),(state_53309[(4)])));

return statearr_53315;
})();
var inst_53286 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_53309__$1 = state_53309;
if(inst_53286){
var statearr_53316_53333 = state_53309__$1;
(statearr_53316_53333[(1)] = (6));

} else {
var statearr_53317_53334 = state_53309__$1;
(statearr_53317_53334[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53310 === (9))){
var inst_53289 = (state_53309[(2)]);
var inst_53290 = fluree.db.util.async.throw_err.call(null,inst_53289);
var state_53309__$1 = state_53309;
var statearr_53318_53335 = state_53309__$1;
(statearr_53318_53335[(2)] = inst_53290);

(statearr_53318_53335[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53310 === (5))){
var _ = (function (){var statearr_53319 = state_53309;
(statearr_53319[(4)] = cljs.core.rest.call(null,(state_53309[(4)])));

return statearr_53319;
})();
var state_53309__$1 = state_53309;
var ex53314 = (state_53309__$1[(2)]);
var statearr_53320_53336 = state_53309__$1;
(statearr_53320_53336[(5)] = ex53314);


if((ex53314 instanceof Error)){
var statearr_53321_53337 = state_53309__$1;
(statearr_53321_53337[(1)] = (4));

(statearr_53321_53337[(5)] = null);

} else {
throw ex53314;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53310 === (8))){
var inst_53293 = (state_53309[(2)]);
var inst_53294 = fluree.db.dbfunctions.internal.not.call(null,inst_53293);
var inst_53295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53296 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53298 = [inst_53293];
var inst_53299 = (new cljs.core.PersistentVector(null,1,(5),inst_53297,inst_53298,null));
var inst_53300 = ["not",inst_53299,inst_53294];
var inst_53301 = cljs.core.PersistentHashMap.fromArrays(inst_53296,inst_53300);
var inst_53302 = [inst_53301,(10)];
var inst_53303 = (new cljs.core.PersistentVector(null,2,(5),inst_53295,inst_53302,null));
var inst_53304 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53303);
var _ = (function (){var statearr_53322 = state_53309;
(statearr_53322[(4)] = cljs.core.rest.call(null,(state_53309[(4)])));

return statearr_53322;
})();
var state_53309__$1 = (function (){var statearr_53323 = state_53309;
(statearr_53323[(7)] = inst_53304);

return statearr_53323;
})();
var statearr_53324_53338 = state_53309__$1;
(statearr_53324_53338[(2)] = inst_53294);

(statearr_53324_53338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0 = (function (){
var statearr_53325 = [null,null,null,null,null,null,null,null];
(statearr_53325[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__);

(statearr_53325[(1)] = (1));

return statearr_53325;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1 = (function (state_53309){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_53309);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53326){var ex__2730__auto__ = e53326;
var statearr_53327_53339 = state_53309;
(statearr_53327_53339[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_53309[(4)]))){
var statearr_53328_53340 = state_53309;
(statearr_53328_53340[(1)] = cljs.core.first.call(null,(state_53309[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53341 = state_53309;
state_53309 = G__53341;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = function(state_53309){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1.call(this,state_53309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53329 = f__2750__auto__.call(null);
(statearr_53329[(6)] = c__2749__auto__);

return statearr_53329;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53371){
var state_val_53372 = (state_53371[(1)]);
if((state_val_53372 === (7))){
var state_53371__$1 = state_53371;
var statearr_53373_53392 = state_53371__$1;
(statearr_53373_53392[(2)] = arg);

(statearr_53373_53392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53372 === (1))){
var state_53371__$1 = state_53371;
var statearr_53374_53393 = state_53371__$1;
(statearr_53374_53393[(2)] = null);

(statearr_53374_53393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53372 === (4))){
var inst_53342 = (state_53371[(2)]);
var state_53371__$1 = state_53371;
var statearr_53375_53394 = state_53371__$1;
(statearr_53375_53394[(2)] = inst_53342);

(statearr_53375_53394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53372 === (6))){
var state_53371__$1 = state_53371;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53371__$1,(9),arg);
} else {
if((state_val_53372 === (3))){
var inst_53369 = (state_53371[(2)]);
var state_53371__$1 = state_53371;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53371__$1,inst_53369);
} else {
if((state_val_53372 === (2))){
var _ = (function (){var statearr_53377 = state_53371;
(statearr_53377[(4)] = cljs.core.cons.call(null,(5),(state_53371[(4)])));

return statearr_53377;
})();
var inst_53348 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_53371__$1 = state_53371;
if(inst_53348){
var statearr_53378_53395 = state_53371__$1;
(statearr_53378_53395[(1)] = (6));

} else {
var statearr_53379_53396 = state_53371__$1;
(statearr_53379_53396[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53372 === (9))){
var inst_53351 = (state_53371[(2)]);
var inst_53352 = fluree.db.util.async.throw_err.call(null,inst_53351);
var state_53371__$1 = state_53371;
var statearr_53380_53397 = state_53371__$1;
(statearr_53380_53397[(2)] = inst_53352);

(statearr_53380_53397[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53372 === (5))){
var _ = (function (){var statearr_53381 = state_53371;
(statearr_53381[(4)] = cljs.core.rest.call(null,(state_53371[(4)])));

return statearr_53381;
})();
var state_53371__$1 = state_53371;
var ex53376 = (state_53371__$1[(2)]);
var statearr_53382_53398 = state_53371__$1;
(statearr_53382_53398[(5)] = ex53376);


if((ex53376 instanceof Error)){
var statearr_53383_53399 = state_53371__$1;
(statearr_53383_53399[(1)] = (4));

(statearr_53383_53399[(5)] = null);

} else {
throw ex53376;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53372 === (8))){
var inst_53355 = (state_53371[(2)]);
var inst_53356 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_53355);
var inst_53357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53358 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53360 = [inst_53355];
var inst_53361 = (new cljs.core.PersistentVector(null,1,(5),inst_53359,inst_53360,null));
var inst_53362 = ["empty?",inst_53361,inst_53356];
var inst_53363 = cljs.core.PersistentHashMap.fromArrays(inst_53358,inst_53362);
var inst_53364 = [inst_53363,(10)];
var inst_53365 = (new cljs.core.PersistentVector(null,2,(5),inst_53357,inst_53364,null));
var inst_53366 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53365);
var _ = (function (){var statearr_53384 = state_53371;
(statearr_53384[(4)] = cljs.core.rest.call(null,(state_53371[(4)])));

return statearr_53384;
})();
var state_53371__$1 = (function (){var statearr_53385 = state_53371;
(statearr_53385[(7)] = inst_53366);

return statearr_53385;
})();
var statearr_53386_53400 = state_53371__$1;
(statearr_53386_53400[(2)] = inst_53356);

(statearr_53386_53400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_53387 = [null,null,null,null,null,null,null,null];
(statearr_53387[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__);

(statearr_53387[(1)] = (1));

return statearr_53387;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1 = (function (state_53371){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_53371);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53388){var ex__2730__auto__ = e53388;
var statearr_53389_53401 = state_53371;
(statearr_53389_53401[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_53371[(4)]))){
var statearr_53390_53402 = state_53371;
(statearr_53390_53402[(1)] = cljs.core.first.call(null,(state_53371[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53403 = state_53371;
state_53371 = G__53403;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = function(state_53371){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1.call(this,state_53371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53391 = f__2750__auto__.call(null);
(statearr_53391[(6)] = c__2749__auto__);

return statearr_53391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53448 = arguments.length;
var i__4865__auto___53449 = (0);
while(true){
if((i__4865__auto___53449 < len__4864__auto___53448)){
args__4870__auto__.push((arguments[i__4865__auto___53449]));

var G__53450 = (i__4865__auto___53449 + (1));
i__4865__auto___53449 = G__53450;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53431){
var state_val_53432 = (state_53431[(1)]);
if((state_val_53432 === (1))){
var state_53431__$1 = state_53431;
var statearr_53433_53451 = state_53431__$1;
(statearr_53433_53451[(2)] = null);

(statearr_53433_53451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53432 === (2))){
var _ = (function (){var statearr_53434 = state_53431;
(statearr_53434[(4)] = cljs.core.cons.call(null,(5),(state_53431[(4)])));

return statearr_53434;
})();
var inst_53412 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53431__$1 = state_53431;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53431__$1,(6),inst_53412);
} else {
if((state_val_53432 === (3))){
var inst_53429 = (state_53431[(2)]);
var state_53431__$1 = state_53431;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53431__$1,inst_53429);
} else {
if((state_val_53432 === (4))){
var inst_53406 = (state_53431[(2)]);
var state_53431__$1 = state_53431;
var statearr_53436_53452 = state_53431__$1;
(statearr_53436_53452[(2)] = inst_53406);

(statearr_53436_53452[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53432 === (5))){
var _ = (function (){var statearr_53437 = state_53431;
(statearr_53437[(4)] = cljs.core.rest.call(null,(state_53431[(4)])));

return statearr_53437;
})();
var state_53431__$1 = state_53431;
var ex53435 = (state_53431__$1[(2)]);
var statearr_53438_53453 = state_53431__$1;
(statearr_53438_53453[(5)] = ex53435);


if((ex53435 instanceof Error)){
var statearr_53439_53454 = state_53431__$1;
(statearr_53439_53454[(1)] = (4));

(statearr_53439_53454[(5)] = null);

} else {
throw ex53435;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53432 === (6))){
var inst_53414 = (state_53431[(2)]);
var inst_53415 = fluree.db.util.async.throw_err.call(null,inst_53414);
var inst_53416 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_53415);
var inst_53417 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53418 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53420 = [inst_53415];
var inst_53421 = (new cljs.core.PersistentVector(null,1,(5),inst_53419,inst_53420,null));
var inst_53422 = ["str",inst_53421,inst_53416];
var inst_53423 = cljs.core.PersistentHashMap.fromArrays(inst_53418,inst_53422);
var inst_53424 = [inst_53423,(10)];
var inst_53425 = (new cljs.core.PersistentVector(null,2,(5),inst_53417,inst_53424,null));
var inst_53426 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53425);
var _ = (function (){var statearr_53440 = state_53431;
(statearr_53440[(4)] = cljs.core.rest.call(null,(state_53431[(4)])));

return statearr_53440;
})();
var state_53431__$1 = (function (){var statearr_53441 = state_53431;
(statearr_53441[(7)] = inst_53426);

return statearr_53441;
})();
var statearr_53442_53455 = state_53431__$1;
(statearr_53442_53455[(2)] = inst_53416);

(statearr_53442_53455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_53443 = [null,null,null,null,null,null,null,null];
(statearr_53443[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_53443[(1)] = (1));

return statearr_53443;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_53431){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_53431);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53444){var ex__2730__auto__ = e53444;
var statearr_53445_53456 = state_53431;
(statearr_53445_53456[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_53431[(4)]))){
var statearr_53446_53457 = state_53431;
(statearr_53446_53457[(1)] = cljs.core.first.call(null,(state_53431[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53458 = state_53431;
state_53431 = G__53458;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_53431){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_53431);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53447 = f__2750__auto__.call(null);
(statearr_53447[(6)] = c__2749__auto__);

return statearr_53447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq53404){
var G__53405 = cljs.core.first.call(null,seq53404);
var seq53404__$1 = cljs.core.next.call(null,seq53404);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53405,seq53404__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53484){
var state_val_53485 = (state_53484[(1)]);
if((state_val_53485 === (1))){
var state_53484__$1 = state_53484;
var statearr_53486_53501 = state_53484__$1;
(statearr_53486_53501[(2)] = null);

(statearr_53486_53501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53485 === (2))){
var _ = (function (){var statearr_53487 = state_53484;
(statearr_53487[(4)] = cljs.core.cons.call(null,(5),(state_53484[(4)])));

return statearr_53487;
})();
var inst_53465 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53484__$1 = state_53484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53484__$1,(6),inst_53465);
} else {
if((state_val_53485 === (3))){
var inst_53482 = (state_53484[(2)]);
var state_53484__$1 = state_53484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53484__$1,inst_53482);
} else {
if((state_val_53485 === (4))){
var inst_53459 = (state_53484[(2)]);
var state_53484__$1 = state_53484;
var statearr_53489_53502 = state_53484__$1;
(statearr_53489_53502[(2)] = inst_53459);

(statearr_53489_53502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53485 === (5))){
var _ = (function (){var statearr_53490 = state_53484;
(statearr_53490[(4)] = cljs.core.rest.call(null,(state_53484[(4)])));

return statearr_53490;
})();
var state_53484__$1 = state_53484;
var ex53488 = (state_53484__$1[(2)]);
var statearr_53491_53503 = state_53484__$1;
(statearr_53491_53503[(5)] = ex53488);


if((ex53488 instanceof Error)){
var statearr_53492_53504 = state_53484__$1;
(statearr_53492_53504[(1)] = (4));

(statearr_53492_53504[(5)] = null);

} else {
throw ex53488;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53485 === (6))){
var inst_53467 = (state_53484[(2)]);
var inst_53468 = fluree.db.util.async.throw_err.call(null,inst_53467);
var inst_53469 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_53468);
var inst_53470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53471 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53473 = [inst_53468];
var inst_53474 = (new cljs.core.PersistentVector(null,1,(5),inst_53472,inst_53473,null));
var inst_53475 = ["subs",inst_53474,inst_53469];
var inst_53476 = cljs.core.PersistentHashMap.fromArrays(inst_53471,inst_53475);
var inst_53477 = [inst_53476,(30)];
var inst_53478 = (new cljs.core.PersistentVector(null,2,(5),inst_53470,inst_53477,null));
var inst_53479 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53478);
var _ = (function (){var statearr_53493 = state_53484;
(statearr_53493[(4)] = cljs.core.rest.call(null,(state_53484[(4)])));

return statearr_53493;
})();
var state_53484__$1 = (function (){var statearr_53494 = state_53484;
(statearr_53494[(7)] = inst_53479);

return statearr_53494;
})();
var statearr_53495_53505 = state_53484__$1;
(statearr_53495_53505[(2)] = inst_53469);

(statearr_53495_53505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0 = (function (){
var statearr_53496 = [null,null,null,null,null,null,null,null];
(statearr_53496[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__);

(statearr_53496[(1)] = (1));

return statearr_53496;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1 = (function (state_53484){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_53484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53497){var ex__2730__auto__ = e53497;
var statearr_53498_53506 = state_53484;
(statearr_53498_53506[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_53484[(4)]))){
var statearr_53499_53507 = state_53484;
(statearr_53499_53507[(1)] = cljs.core.first.call(null,(state_53484[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53508 = state_53484;
state_53484 = G__53508;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = function(state_53484){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1.call(this,state_53484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53500 = f__2750__auto__.call(null);
(statearr_53500[(6)] = c__2749__auto__);

return statearr_53500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53538){
var state_val_53539 = (state_53538[(1)]);
if((state_val_53539 === (7))){
var state_53538__$1 = state_53538;
var statearr_53540_53559 = state_53538__$1;
(statearr_53540_53559[(2)] = str);

(statearr_53540_53559[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53539 === (1))){
var state_53538__$1 = state_53538;
var statearr_53541_53560 = state_53538__$1;
(statearr_53541_53560[(2)] = null);

(statearr_53541_53560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53539 === (4))){
var inst_53509 = (state_53538[(2)]);
var state_53538__$1 = state_53538;
var statearr_53542_53561 = state_53538__$1;
(statearr_53542_53561[(2)] = inst_53509);

(statearr_53542_53561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53539 === (6))){
var state_53538__$1 = state_53538;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53538__$1,(9),str);
} else {
if((state_val_53539 === (3))){
var inst_53536 = (state_53538[(2)]);
var state_53538__$1 = state_53538;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53538__$1,inst_53536);
} else {
if((state_val_53539 === (2))){
var _ = (function (){var statearr_53544 = state_53538;
(statearr_53544[(4)] = cljs.core.cons.call(null,(5),(state_53538[(4)])));

return statearr_53544;
})();
var inst_53515 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_53538__$1 = state_53538;
if(inst_53515){
var statearr_53545_53562 = state_53538__$1;
(statearr_53545_53562[(1)] = (6));

} else {
var statearr_53546_53563 = state_53538__$1;
(statearr_53546_53563[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53539 === (9))){
var inst_53518 = (state_53538[(2)]);
var inst_53519 = fluree.db.util.async.throw_err.call(null,inst_53518);
var state_53538__$1 = state_53538;
var statearr_53547_53564 = state_53538__$1;
(statearr_53547_53564[(2)] = inst_53519);

(statearr_53547_53564[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53539 === (5))){
var _ = (function (){var statearr_53548 = state_53538;
(statearr_53548[(4)] = cljs.core.rest.call(null,(state_53538[(4)])));

return statearr_53548;
})();
var state_53538__$1 = state_53538;
var ex53543 = (state_53538__$1[(2)]);
var statearr_53549_53565 = state_53538__$1;
(statearr_53549_53565[(5)] = ex53543);


if((ex53543 instanceof Error)){
var statearr_53550_53566 = state_53538__$1;
(statearr_53550_53566[(1)] = (4));

(statearr_53550_53566[(5)] = null);

} else {
throw ex53543;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53539 === (8))){
var inst_53522 = (state_53538[(2)]);
var inst_53523 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_53522);
var inst_53524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53525 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53527 = [inst_53522];
var inst_53528 = (new cljs.core.PersistentVector(null,1,(5),inst_53526,inst_53527,null));
var inst_53529 = ["lower-case",inst_53528,inst_53523];
var inst_53530 = cljs.core.PersistentHashMap.fromArrays(inst_53525,inst_53529);
var inst_53531 = [inst_53530,(10)];
var inst_53532 = (new cljs.core.PersistentVector(null,2,(5),inst_53524,inst_53531,null));
var inst_53533 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53532);
var _ = (function (){var statearr_53551 = state_53538;
(statearr_53551[(4)] = cljs.core.rest.call(null,(state_53538[(4)])));

return statearr_53551;
})();
var state_53538__$1 = (function (){var statearr_53552 = state_53538;
(statearr_53552[(7)] = inst_53533);

return statearr_53552;
})();
var statearr_53553_53567 = state_53538__$1;
(statearr_53553_53567[(2)] = inst_53523);

(statearr_53553_53567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0 = (function (){
var statearr_53554 = [null,null,null,null,null,null,null,null];
(statearr_53554[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__);

(statearr_53554[(1)] = (1));

return statearr_53554;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1 = (function (state_53538){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_53538);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53555){var ex__2730__auto__ = e53555;
var statearr_53556_53568 = state_53538;
(statearr_53556_53568[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_53538[(4)]))){
var statearr_53557_53569 = state_53538;
(statearr_53557_53569[(1)] = cljs.core.first.call(null,(state_53538[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53570 = state_53538;
state_53538 = G__53570;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = function(state_53538){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1.call(this,state_53538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53558 = f__2750__auto__.call(null);
(statearr_53558[(6)] = c__2749__auto__);

return statearr_53558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53600){
var state_val_53601 = (state_53600[(1)]);
if((state_val_53601 === (7))){
var state_53600__$1 = state_53600;
var statearr_53602_53621 = state_53600__$1;
(statearr_53602_53621[(2)] = str);

(statearr_53602_53621[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53601 === (1))){
var state_53600__$1 = state_53600;
var statearr_53603_53622 = state_53600__$1;
(statearr_53603_53622[(2)] = null);

(statearr_53603_53622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53601 === (4))){
var inst_53571 = (state_53600[(2)]);
var state_53600__$1 = state_53600;
var statearr_53604_53623 = state_53600__$1;
(statearr_53604_53623[(2)] = inst_53571);

(statearr_53604_53623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53601 === (6))){
var state_53600__$1 = state_53600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53600__$1,(9),str);
} else {
if((state_val_53601 === (3))){
var inst_53598 = (state_53600[(2)]);
var state_53600__$1 = state_53600;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53600__$1,inst_53598);
} else {
if((state_val_53601 === (2))){
var _ = (function (){var statearr_53606 = state_53600;
(statearr_53606[(4)] = cljs.core.cons.call(null,(5),(state_53600[(4)])));

return statearr_53606;
})();
var inst_53577 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_53600__$1 = state_53600;
if(inst_53577){
var statearr_53607_53624 = state_53600__$1;
(statearr_53607_53624[(1)] = (6));

} else {
var statearr_53608_53625 = state_53600__$1;
(statearr_53608_53625[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53601 === (9))){
var inst_53580 = (state_53600[(2)]);
var inst_53581 = fluree.db.util.async.throw_err.call(null,inst_53580);
var state_53600__$1 = state_53600;
var statearr_53609_53626 = state_53600__$1;
(statearr_53609_53626[(2)] = inst_53581);

(statearr_53609_53626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53601 === (5))){
var _ = (function (){var statearr_53610 = state_53600;
(statearr_53610[(4)] = cljs.core.rest.call(null,(state_53600[(4)])));

return statearr_53610;
})();
var state_53600__$1 = state_53600;
var ex53605 = (state_53600__$1[(2)]);
var statearr_53611_53627 = state_53600__$1;
(statearr_53611_53627[(5)] = ex53605);


if((ex53605 instanceof Error)){
var statearr_53612_53628 = state_53600__$1;
(statearr_53612_53628[(1)] = (4));

(statearr_53612_53628[(5)] = null);

} else {
throw ex53605;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53601 === (8))){
var inst_53584 = (state_53600[(2)]);
var inst_53585 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_53584);
var inst_53586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53587 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53589 = [inst_53584];
var inst_53590 = (new cljs.core.PersistentVector(null,1,(5),inst_53588,inst_53589,null));
var inst_53591 = ["upper-case",inst_53590,inst_53585];
var inst_53592 = cljs.core.PersistentHashMap.fromArrays(inst_53587,inst_53591);
var inst_53593 = [inst_53592,(10)];
var inst_53594 = (new cljs.core.PersistentVector(null,2,(5),inst_53586,inst_53593,null));
var inst_53595 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53594);
var _ = (function (){var statearr_53613 = state_53600;
(statearr_53613[(4)] = cljs.core.rest.call(null,(state_53600[(4)])));

return statearr_53613;
})();
var state_53600__$1 = (function (){var statearr_53614 = state_53600;
(statearr_53614[(7)] = inst_53595);

return statearr_53614;
})();
var statearr_53615_53629 = state_53600__$1;
(statearr_53615_53629[(2)] = inst_53585);

(statearr_53615_53629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0 = (function (){
var statearr_53616 = [null,null,null,null,null,null,null,null];
(statearr_53616[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__);

(statearr_53616[(1)] = (1));

return statearr_53616;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1 = (function (state_53600){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_53600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53617){var ex__2730__auto__ = e53617;
var statearr_53618_53630 = state_53600;
(statearr_53618_53630[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_53600[(4)]))){
var statearr_53619_53631 = state_53600;
(statearr_53619_53631[(1)] = cljs.core.first.call(null,(state_53600[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53632 = state_53600;
state_53600 = G__53632;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = function(state_53600){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1.call(this,state_53600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53620 = f__2750__auto__.call(null);
(statearr_53620[(6)] = c__2749__auto__);

return statearr_53620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4251__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4251__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__53634 = arguments.length;
switch (G__53634) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53662){
var state_val_53663 = (state_53662[(1)]);
if((state_val_53663 === (1))){
var state_53662__$1 = state_53662;
var statearr_53664_53680 = state_53662__$1;
(statearr_53664_53680[(2)] = null);

(statearr_53664_53680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53663 === (2))){
var _ = (function (){var statearr_53665 = state_53662;
(statearr_53665[(4)] = cljs.core.cons.call(null,(5),(state_53662[(4)])));

return statearr_53665;
})();
var inst_53644 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_53662__$1 = state_53662;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53662__$1,(6),inst_53644);
} else {
if((state_val_53663 === (3))){
var inst_53660 = (state_53662[(2)]);
var state_53662__$1 = state_53662;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53662__$1,inst_53660);
} else {
if((state_val_53663 === (4))){
var inst_53635 = (state_53662[(2)]);
var state_53662__$1 = state_53662;
var statearr_53667_53681 = state_53662__$1;
(statearr_53667_53681[(2)] = inst_53635);

(statearr_53667_53681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53663 === (5))){
var _ = (function (){var statearr_53668 = state_53662;
(statearr_53668[(4)] = cljs.core.rest.call(null,(state_53662[(4)])));

return statearr_53668;
})();
var state_53662__$1 = state_53662;
var ex53666 = (state_53662__$1[(2)]);
var statearr_53669_53682 = state_53662__$1;
(statearr_53669_53682[(5)] = ex53666);


if((ex53666 instanceof Error)){
var statearr_53670_53683 = state_53662__$1;
(statearr_53670_53683[(1)] = (4));

(statearr_53670_53683[(5)] = null);

} else {
throw ex53666;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53663 === (6))){
var inst_53646 = (state_53662[(2)]);
var inst_53647 = fluree.db.util.async.throw_err.call(null,inst_53646);
var inst_53648 = cljs.core.nth.call(null,inst_53647,(0),null);
var inst_53649 = cljs.core.nth.call(null,inst_53647,(1),null);
var inst_53650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53651 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53652 = ["?s","?ctx",inst_53648];
var inst_53653 = cljs.core.PersistentHashMap.fromArrays(inst_53651,inst_53652);
var inst_53654 = ((10) + inst_53649);
var inst_53655 = [inst_53653,inst_53654];
var inst_53656 = (new cljs.core.PersistentVector(null,2,(5),inst_53650,inst_53655,null));
var inst_53657 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53656);
var _ = (function (){var statearr_53671 = state_53662;
(statearr_53671[(4)] = cljs.core.rest.call(null,(state_53662[(4)])));

return statearr_53671;
})();
var state_53662__$1 = (function (){var statearr_53672 = state_53662;
(statearr_53672[(7)] = inst_53657);

return statearr_53672;
})();
var statearr_53673_53684 = state_53662__$1;
(statearr_53673_53684[(2)] = inst_53648);

(statearr_53673_53684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_53674 = [null,null,null,null,null,null,null,null];
(statearr_53674[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_53674[(1)] = (1));

return statearr_53674;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_53662){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_53662);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53675){var ex__2730__auto__ = e53675;
var statearr_53676_53685 = state_53662;
(statearr_53676_53685[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_53662[(4)]))){
var statearr_53677_53686 = state_53662;
(statearr_53677_53686[(1)] = cljs.core.first.call(null,(state_53662[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53687 = state_53662;
state_53662 = G__53687;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_53662){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_53662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53678 = f__2750__auto__.call(null);
(statearr_53678[(6)] = c__2749__auto__);

return statearr_53678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__53689 = arguments.length;
switch (G__53689) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53727){
var state_val_53728 = (state_53727[(1)]);
if((state_val_53728 === (7))){
var inst_53720 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_53727__$1 = state_53727;
var statearr_53729_53749 = state_53727__$1;
(statearr_53729_53749[(2)] = inst_53720);

(statearr_53729_53749[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53728 === (1))){
var state_53727__$1 = state_53727;
var statearr_53730_53750 = state_53727__$1;
(statearr_53730_53750[(2)] = null);

(statearr_53730_53750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53728 === (4))){
var inst_53690 = (state_53727[(2)]);
var state_53727__$1 = state_53727;
var statearr_53731_53751 = state_53727__$1;
(statearr_53731_53751[(2)] = inst_53690);

(statearr_53731_53751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53728 === (6))){
var inst_53701 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_53727__$1 = state_53727;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53727__$1,(10),inst_53701);
} else {
if((state_val_53728 === (3))){
var inst_53725 = (state_53727[(2)]);
var state_53727__$1 = state_53727;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53727__$1,inst_53725);
} else {
if((state_val_53728 === (2))){
var _ = (function (){var statearr_53733 = state_53727;
(statearr_53733[(4)] = cljs.core.cons.call(null,(5),(state_53727[(4)])));

return statearr_53733;
})();
var inst_53696 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_53727__$1 = state_53727;
if(cljs.core.truth_(inst_53696)){
var statearr_53734_53752 = state_53727__$1;
(statearr_53734_53752[(1)] = (6));

} else {
var statearr_53735_53753 = state_53727__$1;
(statearr_53735_53753[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53728 === (9))){
var inst_53707 = (state_53727[(2)]);
var inst_53708 = fluree.db.util.async.throw_err.call(null,inst_53707);
var inst_53709 = cljs.core.nth.call(null,inst_53708,(0),null);
var inst_53710 = cljs.core.nth.call(null,inst_53708,(1),null);
var inst_53711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53712 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53713 = ["?p","?ctx",inst_53709];
var inst_53714 = cljs.core.PersistentHashMap.fromArrays(inst_53712,inst_53713);
var inst_53715 = ((10) + inst_53710);
var inst_53716 = [inst_53714,inst_53715];
var inst_53717 = (new cljs.core.PersistentVector(null,2,(5),inst_53711,inst_53716,null));
var inst_53718 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53717);
var state_53727__$1 = (function (){var statearr_53736 = state_53727;
(statearr_53736[(7)] = inst_53718);

return statearr_53736;
})();
var statearr_53737_53754 = state_53727__$1;
(statearr_53737_53754[(2)] = inst_53709);

(statearr_53737_53754[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53728 === (5))){
var _ = (function (){var statearr_53738 = state_53727;
(statearr_53738[(4)] = cljs.core.rest.call(null,(state_53727[(4)])));

return statearr_53738;
})();
var state_53727__$1 = state_53727;
var ex53732 = (state_53727__$1[(2)]);
var statearr_53739_53755 = state_53727__$1;
(statearr_53739_53755[(5)] = ex53732);


if((ex53732 instanceof Error)){
var statearr_53740_53756 = state_53727__$1;
(statearr_53740_53756[(1)] = (4));

(statearr_53740_53756[(5)] = null);

} else {
throw ex53732;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53728 === (10))){
var inst_53703 = (state_53727[(2)]);
var inst_53704 = fluree.db.util.async.throw_err.call(null,inst_53703);
var inst_53705 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_53704);
var state_53727__$1 = state_53727;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53727__$1,(9),inst_53705);
} else {
if((state_val_53728 === (8))){
var inst_53722 = (state_53727[(2)]);
var _ = (function (){var statearr_53741 = state_53727;
(statearr_53741[(4)] = cljs.core.rest.call(null,(state_53727[(4)])));

return statearr_53741;
})();
var state_53727__$1 = state_53727;
var statearr_53742_53757 = state_53727__$1;
(statearr_53742_53757[(2)] = inst_53722);

(statearr_53742_53757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_53743 = [null,null,null,null,null,null,null,null];
(statearr_53743[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_53743[(1)] = (1));

return statearr_53743;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_53727){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_53727);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53744){var ex__2730__auto__ = e53744;
var statearr_53745_53758 = state_53727;
(statearr_53745_53758[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_53727[(4)]))){
var statearr_53746_53759 = state_53727;
(statearr_53746_53759[(1)] = cljs.core.first.call(null,(state_53727[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53760 = state_53727;
state_53727 = G__53760;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_53727){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_53727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53747 = f__2750__auto__.call(null);
(statearr_53747[(6)] = c__2749__auto__);

return statearr_53747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53809 = arguments.length;
var i__4865__auto___53810 = (0);
while(true){
if((i__4865__auto___53810 < len__4864__auto___53809)){
args__4870__auto__.push((arguments[i__4865__auto___53810]));

var G__53811 = (i__4865__auto___53810 + (1));
i__4865__auto___53810 = G__53811;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53792){
var state_val_53793 = (state_53792[(1)]);
if((state_val_53793 === (1))){
var state_53792__$1 = state_53792;
var statearr_53794_53812 = state_53792__$1;
(statearr_53794_53812[(2)] = null);

(statearr_53794_53812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53793 === (2))){
var _ = (function (){var statearr_53795 = state_53792;
(statearr_53795[(4)] = cljs.core.cons.call(null,(5),(state_53792[(4)])));

return statearr_53795;
})();
var inst_53769 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53792__$1 = state_53792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53792__$1,(6),inst_53769);
} else {
if((state_val_53793 === (3))){
var inst_53790 = (state_53792[(2)]);
var state_53792__$1 = state_53792;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53792__$1,inst_53790);
} else {
if((state_val_53793 === (4))){
var inst_53763 = (state_53792[(2)]);
var state_53792__$1 = state_53792;
var statearr_53797_53813 = state_53792__$1;
(statearr_53797_53813[(2)] = inst_53763);

(statearr_53797_53813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53793 === (5))){
var _ = (function (){var statearr_53798 = state_53792;
(statearr_53798[(4)] = cljs.core.rest.call(null,(state_53792[(4)])));

return statearr_53798;
})();
var state_53792__$1 = state_53792;
var ex53796 = (state_53792__$1[(2)]);
var statearr_53799_53814 = state_53792__$1;
(statearr_53799_53814[(5)] = ex53796);


if((ex53796 instanceof Error)){
var statearr_53800_53815 = state_53792__$1;
(statearr_53800_53815[(1)] = (4));

(statearr_53800_53815[(5)] = null);

} else {
throw ex53796;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53793 === (6))){
var inst_53771 = (state_53792[(2)]);
var inst_53772 = fluree.db.util.async.throw_err.call(null,inst_53771);
var inst_53773 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_53772);
var inst_53774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53775 = [inst_53772];
var inst_53776 = (new cljs.core.PersistentVector(null,1,(5),inst_53774,inst_53775,null));
var inst_53777 = cljs.core.count.call(null,inst_53776);
var inst_53778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53779 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53781 = [inst_53772];
var inst_53782 = (new cljs.core.PersistentVector(null,1,(5),inst_53780,inst_53781,null));
var inst_53783 = ["and",inst_53782,inst_53773];
var inst_53784 = cljs.core.PersistentHashMap.fromArrays(inst_53779,inst_53783);
var inst_53785 = [inst_53784,inst_53777];
var inst_53786 = (new cljs.core.PersistentVector(null,2,(5),inst_53778,inst_53785,null));
var inst_53787 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53786);
var _ = (function (){var statearr_53801 = state_53792;
(statearr_53801[(4)] = cljs.core.rest.call(null,(state_53792[(4)])));

return statearr_53801;
})();
var state_53792__$1 = (function (){var statearr_53802 = state_53792;
(statearr_53802[(7)] = inst_53787);

return statearr_53802;
})();
var statearr_53803_53816 = state_53792__$1;
(statearr_53803_53816[(2)] = inst_53773);

(statearr_53803_53816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_53804 = [null,null,null,null,null,null,null,null];
(statearr_53804[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_53804[(1)] = (1));

return statearr_53804;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_53792){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_53792);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53805){var ex__2730__auto__ = e53805;
var statearr_53806_53817 = state_53792;
(statearr_53806_53817[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_53792[(4)]))){
var statearr_53807_53818 = state_53792;
(statearr_53807_53818[(1)] = cljs.core.first.call(null,(state_53792[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53819 = state_53792;
state_53792 = G__53819;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_53792){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_53792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53808 = f__2750__auto__.call(null);
(statearr_53808[(6)] = c__2749__auto__);

return statearr_53808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq53761){
var G__53762 = cljs.core.first.call(null,seq53761);
var seq53761__$1 = cljs.core.next.call(null,seq53761);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53762,seq53761__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53868 = arguments.length;
var i__4865__auto___53869 = (0);
while(true){
if((i__4865__auto___53869 < len__4864__auto___53868)){
args__4870__auto__.push((arguments[i__4865__auto___53869]));

var G__53870 = (i__4865__auto___53869 + (1));
i__4865__auto___53869 = G__53870;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53851){
var state_val_53852 = (state_53851[(1)]);
if((state_val_53852 === (1))){
var state_53851__$1 = state_53851;
var statearr_53853_53871 = state_53851__$1;
(statearr_53853_53871[(2)] = null);

(statearr_53853_53871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53852 === (2))){
var _ = (function (){var statearr_53854 = state_53851;
(statearr_53854[(4)] = cljs.core.cons.call(null,(5),(state_53851[(4)])));

return statearr_53854;
})();
var inst_53828 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53851__$1 = state_53851;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53851__$1,(6),inst_53828);
} else {
if((state_val_53852 === (3))){
var inst_53849 = (state_53851[(2)]);
var state_53851__$1 = state_53851;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53851__$1,inst_53849);
} else {
if((state_val_53852 === (4))){
var inst_53822 = (state_53851[(2)]);
var state_53851__$1 = state_53851;
var statearr_53856_53872 = state_53851__$1;
(statearr_53856_53872[(2)] = inst_53822);

(statearr_53856_53872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53852 === (5))){
var _ = (function (){var statearr_53857 = state_53851;
(statearr_53857[(4)] = cljs.core.rest.call(null,(state_53851[(4)])));

return statearr_53857;
})();
var state_53851__$1 = state_53851;
var ex53855 = (state_53851__$1[(2)]);
var statearr_53858_53873 = state_53851__$1;
(statearr_53858_53873[(5)] = ex53855);


if((ex53855 instanceof Error)){
var statearr_53859_53874 = state_53851__$1;
(statearr_53859_53874[(1)] = (4));

(statearr_53859_53874[(5)] = null);

} else {
throw ex53855;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53852 === (6))){
var inst_53830 = (state_53851[(2)]);
var inst_53831 = fluree.db.util.async.throw_err.call(null,inst_53830);
var inst_53832 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_53831);
var inst_53833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53834 = [inst_53831];
var inst_53835 = (new cljs.core.PersistentVector(null,1,(5),inst_53833,inst_53834,null));
var inst_53836 = cljs.core.count.call(null,inst_53835);
var inst_53837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53838 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53840 = [inst_53831];
var inst_53841 = (new cljs.core.PersistentVector(null,1,(5),inst_53839,inst_53840,null));
var inst_53842 = ["or",inst_53841,inst_53832];
var inst_53843 = cljs.core.PersistentHashMap.fromArrays(inst_53838,inst_53842);
var inst_53844 = [inst_53843,inst_53836];
var inst_53845 = (new cljs.core.PersistentVector(null,2,(5),inst_53837,inst_53844,null));
var inst_53846 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53845);
var _ = (function (){var statearr_53860 = state_53851;
(statearr_53860[(4)] = cljs.core.rest.call(null,(state_53851[(4)])));

return statearr_53860;
})();
var state_53851__$1 = (function (){var statearr_53861 = state_53851;
(statearr_53861[(7)] = inst_53846);

return statearr_53861;
})();
var statearr_53862_53875 = state_53851__$1;
(statearr_53862_53875[(2)] = inst_53832);

(statearr_53862_53875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_53863 = [null,null,null,null,null,null,null,null];
(statearr_53863[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_53863[(1)] = (1));

return statearr_53863;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_53851){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_53851);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53864){var ex__2730__auto__ = e53864;
var statearr_53865_53876 = state_53851;
(statearr_53865_53876[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_53851[(4)]))){
var statearr_53866_53877 = state_53851;
(statearr_53866_53877[(1)] = cljs.core.first.call(null,(state_53851[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53878 = state_53851;
state_53851 = G__53878;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_53851){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_53851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53867 = f__2750__auto__.call(null);
(statearr_53867[(6)] = c__2749__auto__);

return statearr_53867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq53820){
var G__53821 = cljs.core.first.call(null,seq53820);
var seq53820__$1 = cljs.core.next.call(null,seq53820);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53821,seq53820__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53916){
var state_val_53917 = (state_53916[(1)]);
if((state_val_53917 === (7))){
var inst_53892 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_53916__$1 = state_53916;
if(inst_53892){
var statearr_53918_53941 = state_53916__$1;
(statearr_53918_53941[(1)] = (10));

} else {
var statearr_53919_53942 = state_53916__$1;
(statearr_53919_53942[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53917 === (1))){
var state_53916__$1 = state_53916;
var statearr_53920_53943 = state_53916__$1;
(statearr_53920_53943[(2)] = null);

(statearr_53920_53943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53917 === (4))){
var inst_53879 = (state_53916[(2)]);
var state_53916__$1 = state_53916;
var statearr_53921_53944 = state_53916__$1;
(statearr_53921_53944[(2)] = inst_53879);

(statearr_53921_53944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53917 === (13))){
var inst_53895 = (state_53916[(2)]);
var inst_53896 = fluree.db.util.async.throw_err.call(null,inst_53895);
var state_53916__$1 = state_53916;
var statearr_53922_53945 = state_53916__$1;
(statearr_53922_53945[(2)] = inst_53896);

(statearr_53922_53945[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53917 === (6))){
var inst_53887 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_53916__$1 = state_53916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53916__$1,(9),inst_53887);
} else {
if((state_val_53917 === (3))){
var inst_53914 = (state_53916[(2)]);
var state_53916__$1 = state_53916;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53916__$1,inst_53914);
} else {
if((state_val_53917 === (12))){
var inst_53899 = (state_53916[(2)]);
var state_53916__$1 = state_53916;
var statearr_53923_53946 = state_53916__$1;
(statearr_53923_53946[(2)] = inst_53899);

(statearr_53923_53946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53917 === (2))){
var _ = (function (){var statearr_53924 = state_53916;
(statearr_53924[(4)] = cljs.core.cons.call(null,(5),(state_53916[(4)])));

return statearr_53924;
})();
var inst_53885 = cljs.core.vector_QMARK_.call(null,coll);
var state_53916__$1 = state_53916;
if(inst_53885){
var statearr_53925_53947 = state_53916__$1;
(statearr_53925_53947[(1)] = (6));

} else {
var statearr_53926_53948 = state_53916__$1;
(statearr_53926_53948[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53917 === (11))){
var state_53916__$1 = state_53916;
var statearr_53928_53949 = state_53916__$1;
(statearr_53928_53949[(2)] = coll);

(statearr_53928_53949[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53917 === (9))){
var inst_53889 = (state_53916[(2)]);
var inst_53890 = fluree.db.util.async.throw_err.call(null,inst_53889);
var state_53916__$1 = state_53916;
var statearr_53929_53950 = state_53916__$1;
(statearr_53929_53950[(2)] = inst_53890);

(statearr_53929_53950[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53917 === (5))){
var _ = (function (){var statearr_53930 = state_53916;
(statearr_53930[(4)] = cljs.core.rest.call(null,(state_53916[(4)])));

return statearr_53930;
})();
var state_53916__$1 = state_53916;
var ex53927 = (state_53916__$1[(2)]);
var statearr_53931_53951 = state_53916__$1;
(statearr_53931_53951[(5)] = ex53927);


if((ex53927 instanceof Error)){
var statearr_53932_53952 = state_53916__$1;
(statearr_53932_53952[(1)] = (4));

(statearr_53932_53952[(5)] = null);

} else {
throw ex53927;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53917 === (10))){
var state_53916__$1 = state_53916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53916__$1,(13),coll);
} else {
if((state_val_53917 === (8))){
var inst_53901 = (state_53916[(2)]);
var inst_53902 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_53901);
var inst_53903 = cljs.core.count.call(null,inst_53902);
var inst_53904 = ((9) + inst_53903);
var inst_53905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53906 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53907 = ["count",inst_53901,inst_53903];
var inst_53908 = cljs.core.PersistentHashMap.fromArrays(inst_53906,inst_53907);
var inst_53909 = [inst_53908,inst_53904];
var inst_53910 = (new cljs.core.PersistentVector(null,2,(5),inst_53905,inst_53909,null));
var inst_53911 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53910);
var _ = (function (){var statearr_53933 = state_53916;
(statearr_53933[(4)] = cljs.core.rest.call(null,(state_53916[(4)])));

return statearr_53933;
})();
var state_53916__$1 = (function (){var statearr_53934 = state_53916;
(statearr_53934[(7)] = inst_53911);

return statearr_53934;
})();
var statearr_53935_53953 = state_53916__$1;
(statearr_53935_53953[(2)] = inst_53903);

(statearr_53935_53953[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0 = (function (){
var statearr_53936 = [null,null,null,null,null,null,null,null];
(statearr_53936[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__);

(statearr_53936[(1)] = (1));

return statearr_53936;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1 = (function (state_53916){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_53916);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53937){var ex__2730__auto__ = e53937;
var statearr_53938_53954 = state_53916;
(statearr_53938_53954[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_53916[(4)]))){
var statearr_53939_53955 = state_53916;
(statearr_53939_53955[(1)] = cljs.core.first.call(null,(state_53916[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53956 = state_53916;
state_53916 = G__53956;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = function(state_53916){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1.call(this,state_53916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53940 = f__2750__auto__.call(null);
(statearr_53940[(6)] = c__2749__auto__);

return statearr_53940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__53957,subject,pred){
var map__53958 = p__53957;
var map__53958__$1 = cljs.core.__destructure_map.call(null,map__53958);
var _QMARK_ctx = map__53958__$1;
var cache = cljs.core.get.call(null,map__53958__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.call(null,map__53958__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54049){
var state_val_54050 = (state_54049[(1)]);
if((state_val_54050 === (7))){
var state_54049__$1 = state_54049;
var statearr_54051_54107 = state_54049__$1;
(statearr_54051_54107[(2)] = subject);

(statearr_54051_54107[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (20))){
var state_54049__$1 = state_54049;
var statearr_54052_54108 = state_54049__$1;
(statearr_54052_54108[(2)] = cache);

(statearr_54052_54108[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (27))){
var inst_53980 = (state_54049[(7)]);
var inst_53992 = (state_54049[(8)]);
var inst_54006 = fluree.db.dbfunctions.internal.get_subj_pred.call(null,db,inst_53992,inst_53980);
var state_54049__$1 = state_54049;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54049__$1,(29),inst_54006);
} else {
if((state_val_54050 === (1))){
var state_54049__$1 = state_54049;
var statearr_54053_54109 = state_54049__$1;
(statearr_54053_54109[(2)] = null);

(statearr_54053_54109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (24))){
var inst_53992 = (state_54049[(8)]);
var inst_54019 = cljs.core.int_QMARK_.call(null,inst_53992);
var state_54049__$1 = state_54049;
if(inst_54019){
var statearr_54054_54110 = state_54049__$1;
(statearr_54054_54110[(1)] = (30));

} else {
var statearr_54055_54111 = state_54049__$1;
(statearr_54055_54111[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (4))){
var inst_53959 = (state_54049[(2)]);
var state_54049__$1 = state_54049;
var statearr_54056_54112 = state_54049__$1;
(statearr_54056_54112[(2)] = inst_53959);

(statearr_54056_54112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (15))){
var inst_53972 = (state_54049[(9)]);
var state_54049__$1 = state_54049;
var statearr_54057_54113 = state_54049__$1;
(statearr_54057_54113[(2)] = inst_53972);

(statearr_54057_54113[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (21))){
var inst_53993 = (state_54049[(10)]);
var state_54049__$1 = state_54049;
var statearr_54058_54114 = state_54049__$1;
(statearr_54058_54114[(2)] = inst_53993);

(statearr_54058_54114[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (31))){
var state_54049__$1 = state_54049;
var statearr_54059_54115 = state_54049__$1;
(statearr_54059_54115[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (32))){
var inst_54032 = (state_54049[(2)]);
var state_54049__$1 = state_54049;
var statearr_54061_54116 = state_54049__$1;
(statearr_54061_54116[(2)] = inst_54032);

(statearr_54061_54116[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (33))){
var inst_54023 = (state_54049[(2)]);
var inst_54024 = fluree.db.util.async.throw_err.call(null,inst_54023);
var state_54049__$1 = state_54049;
var statearr_54062_54117 = state_54049__$1;
(statearr_54062_54117[(2)] = inst_54024);

(statearr_54062_54117[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (13))){
var inst_53976 = (state_54049[(2)]);
var inst_53977 = fluree.db.util.async.throw_err.call(null,inst_53976);
var state_54049__$1 = state_54049;
var statearr_54063_54118 = state_54049__$1;
(statearr_54063_54118[(2)] = inst_53977);

(statearr_54063_54118[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (22))){
var inst_53997 = (state_54049[(2)]);
var state_54049__$1 = state_54049;
if(cljs.core.truth_(inst_53997)){
var statearr_54064_54119 = state_54049__$1;
(statearr_54064_54119[(1)] = (23));

} else {
var statearr_54065_54120 = state_54049__$1;
(statearr_54065_54120[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (36))){
var inst_54030 = (state_54049[(2)]);
var state_54049__$1 = state_54049;
var statearr_54066_54121 = state_54049__$1;
(statearr_54066_54121[(2)] = inst_54030);

(statearr_54066_54121[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (29))){
var inst_53980 = (state_54049[(7)]);
var inst_53992 = (state_54049[(8)]);
var inst_54008 = (state_54049[(2)]);
var inst_54009 = fluree.db.util.async.throw_err.call(null,inst_54008);
var inst_54010 = cljs.core._deref.call(null,cache);
var inst_54011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54012 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_53992,inst_53980];
var inst_54013 = (new cljs.core.PersistentVector(null,3,(5),inst_54011,inst_54012,null));
var inst_54014 = cljs.core.assoc_in.call(null,inst_54010,inst_54013,inst_54009);
var inst_54015 = cljs.core._vreset_BANG_.call(null,cache,inst_54014);
var state_54049__$1 = (function (){var statearr_54067 = state_54049;
(statearr_54067[(11)] = inst_54015);

return statearr_54067;
})();
var statearr_54068_54122 = state_54049__$1;
(statearr_54068_54122[(2)] = inst_54009);

(statearr_54068_54122[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (6))){
var state_54049__$1 = state_54049;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54049__$1,(9),subject);
} else {
if((state_val_54050 === (28))){
var inst_54017 = (state_54049[(2)]);
var state_54049__$1 = state_54049;
var statearr_54069_54123 = state_54049__$1;
(statearr_54069_54123[(2)] = inst_54017);

(statearr_54069_54123[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (25))){
var inst_53980 = (state_54049[(7)]);
var inst_53972 = (state_54049[(9)]);
var inst_54034 = (state_54049[(2)]);
var inst_54035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54036 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54038 = [inst_53972,inst_53980];
var inst_54039 = (new cljs.core.PersistentVector(null,2,(5),inst_54037,inst_54038,null));
var inst_54040 = ["get",inst_54039,inst_54034];
var inst_54041 = cljs.core.PersistentHashMap.fromArrays(inst_54036,inst_54040);
var inst_54042 = [inst_54041,(10)];
var inst_54043 = (new cljs.core.PersistentVector(null,2,(5),inst_54035,inst_54042,null));
var inst_54044 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54043);
var _ = (function (){var statearr_54070 = state_54049;
(statearr_54070[(4)] = cljs.core.rest.call(null,(state_54049[(4)])));

return statearr_54070;
})();
var state_54049__$1 = (function (){var statearr_54071 = state_54049;
(statearr_54071[(12)] = inst_54044);

return statearr_54071;
})();
var statearr_54072_54124 = state_54049__$1;
(statearr_54072_54124[(2)] = inst_54034);

(statearr_54072_54124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (34))){
var inst_53980 = (state_54049[(7)]);
var inst_53992 = (state_54049[(8)]);
var inst_54027 = fluree.db.dbfunctions.internal.get.call(null,inst_53992,inst_53980);
var state_54049__$1 = state_54049;
var statearr_54073_54125 = state_54049__$1;
(statearr_54073_54125[(2)] = inst_54027);

(statearr_54073_54125[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (17))){
var inst_53972 = (state_54049[(9)]);
var inst_53986 = cljs.core.first.call(null,inst_53972);
var state_54049__$1 = state_54049;
var statearr_54074_54126 = state_54049__$1;
(statearr_54074_54126[(2)] = inst_53986);

(statearr_54074_54126[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (3))){
var inst_54047 = (state_54049[(2)]);
var state_54049__$1 = state_54049;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54049__$1,inst_54047);
} else {
if((state_val_54050 === (12))){
var inst_53972 = (state_54049[(9)]);
var inst_53980 = (state_54049[(2)]);
var inst_53981 = cljs.core.vector_QMARK_.call(null,inst_53972);
var state_54049__$1 = (function (){var statearr_54075 = state_54049;
(statearr_54075[(7)] = inst_53980);

return statearr_54075;
})();
if(inst_53981){
var statearr_54076_54127 = state_54049__$1;
(statearr_54076_54127[(1)] = (14));

} else {
var statearr_54077_54128 = state_54049__$1;
(statearr_54077_54128[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (2))){
var _ = (function (){var statearr_54078 = state_54049;
(statearr_54078[(4)] = cljs.core.cons.call(null,(5),(state_54049[(4)])));

return statearr_54078;
})();
var inst_53965 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_54049__$1 = state_54049;
if(inst_53965){
var statearr_54079_54129 = state_54049__$1;
(statearr_54079_54129[(1)] = (6));

} else {
var statearr_54080_54130 = state_54049__$1;
(statearr_54080_54130[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (23))){
var inst_53980 = (state_54049[(7)]);
var inst_54003 = (state_54049[(13)]);
var inst_53992 = (state_54049[(8)]);
var inst_53999 = cljs.core.deref.call(null,cache);
var inst_54000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54001 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_53992,inst_53980];
var inst_54002 = (new cljs.core.PersistentVector(null,3,(5),inst_54000,inst_54001,null));
var inst_54003__$1 = cljs.core.get_in.call(null,inst_53999,inst_54002);
var state_54049__$1 = (function (){var statearr_54081 = state_54049;
(statearr_54081[(13)] = inst_54003__$1);

return statearr_54081;
})();
if(cljs.core.truth_(inst_54003__$1)){
var statearr_54082_54131 = state_54049__$1;
(statearr_54082_54131[(1)] = (26));

} else {
var statearr_54083_54132 = state_54049__$1;
(statearr_54083_54132[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (35))){
var state_54049__$1 = state_54049;
var statearr_54084_54133 = state_54049__$1;
(statearr_54084_54133[(2)] = null);

(statearr_54084_54133[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (19))){
var inst_53989 = (state_54049[(2)]);
var state_54049__$1 = state_54049;
var statearr_54085_54134 = state_54049__$1;
(statearr_54085_54134[(2)] = inst_53989);

(statearr_54085_54134[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (11))){
var state_54049__$1 = state_54049;
var statearr_54087_54135 = state_54049__$1;
(statearr_54087_54135[(2)] = pred);

(statearr_54087_54135[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (9))){
var inst_53968 = (state_54049[(2)]);
var inst_53969 = fluree.db.util.async.throw_err.call(null,inst_53968);
var state_54049__$1 = state_54049;
var statearr_54088_54136 = state_54049__$1;
(statearr_54088_54136[(2)] = inst_53969);

(statearr_54088_54136[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (5))){
var _ = (function (){var statearr_54089 = state_54049;
(statearr_54089[(4)] = cljs.core.rest.call(null,(state_54049[(4)])));

return statearr_54089;
})();
var state_54049__$1 = state_54049;
var ex54086 = (state_54049__$1[(2)]);
var statearr_54090_54137 = state_54049__$1;
(statearr_54090_54137[(5)] = ex54086);


if((ex54086 instanceof Error)){
var statearr_54091_54138 = state_54049__$1;
(statearr_54091_54138[(1)] = (4));

(statearr_54091_54138[(5)] = null);

} else {
throw ex54086;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (14))){
var inst_53972 = (state_54049[(9)]);
var inst_53983 = cljs.core.count.call(null,inst_53972);
var inst_53984 = cljs.core._EQ_.call(null,(1),inst_53983);
var state_54049__$1 = state_54049;
if(inst_53984){
var statearr_54092_54139 = state_54049__$1;
(statearr_54092_54139[(1)] = (17));

} else {
var statearr_54093_54140 = state_54049__$1;
(statearr_54093_54140[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (26))){
var inst_54003 = (state_54049[(13)]);
var state_54049__$1 = state_54049;
var statearr_54094_54141 = state_54049__$1;
(statearr_54094_54141[(2)] = inst_54003);

(statearr_54094_54141[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (16))){
var inst_53993 = (state_54049[(10)]);
var inst_53992 = (state_54049[(8)]);
var inst_53992__$1 = (state_54049[(2)]);
var inst_53993__$1 = cljs.core.int_QMARK_.call(null,inst_53992__$1);
var state_54049__$1 = (function (){var statearr_54095 = state_54049;
(statearr_54095[(10)] = inst_53993__$1);

(statearr_54095[(8)] = inst_53992__$1);

return statearr_54095;
})();
if(inst_53993__$1){
var statearr_54096_54142 = state_54049__$1;
(statearr_54096_54142[(1)] = (20));

} else {
var statearr_54097_54143 = state_54049__$1;
(statearr_54097_54143[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (30))){
var inst_53980 = (state_54049[(7)]);
var inst_53992 = (state_54049[(8)]);
var inst_54021 = fluree.db.dbfunctions.internal.get_subj_pred.call(null,db,inst_53992,inst_53980);
var state_54049__$1 = state_54049;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54049__$1,(33),inst_54021);
} else {
if((state_val_54050 === (10))){
var state_54049__$1 = state_54049;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54049__$1,(13),pred);
} else {
if((state_val_54050 === (18))){
var inst_53972 = (state_54049[(9)]);
var state_54049__$1 = state_54049;
var statearr_54098_54144 = state_54049__$1;
(statearr_54098_54144[(2)] = inst_53972);

(statearr_54098_54144[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54050 === (8))){
var inst_53972 = (state_54049[(2)]);
var inst_53973 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_54049__$1 = (function (){var statearr_54099 = state_54049;
(statearr_54099[(9)] = inst_53972);

return statearr_54099;
})();
if(inst_53973){
var statearr_54100_54145 = state_54049__$1;
(statearr_54100_54145[(1)] = (10));

} else {
var statearr_54101_54146 = state_54049__$1;
(statearr_54101_54146[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0 = (function (){
var statearr_54102 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54102[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__);

(statearr_54102[(1)] = (1));

return statearr_54102;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1 = (function (state_54049){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_54049);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54103){var ex__2730__auto__ = e54103;
var statearr_54104_54147 = state_54049;
(statearr_54104_54147[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_54049[(4)]))){
var statearr_54105_54148 = state_54049;
(statearr_54105_54148[(1)] = cljs.core.first.call(null,(state_54049[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54149 = state_54049;
state_54049 = G__54149;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = function(state_54049){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1.call(this,state_54049);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54106 = f__2750__auto__.call(null);
(statearr_54106[(6)] = c__2749__auto__);

return statearr_54106;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54188){
var state_val_54189 = (state_54188[(1)]);
if((state_val_54189 === (7))){
var inst_54156 = (state_54188[(7)]);
var state_54188__$1 = state_54188;
var statearr_54190_54214 = state_54188__$1;
(statearr_54190_54214[(2)] = inst_54156);

(statearr_54190_54214[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54189 === (1))){
var state_54188__$1 = state_54188;
var statearr_54191_54215 = state_54188__$1;
(statearr_54191_54215[(2)] = null);

(statearr_54191_54215[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54189 === (4))){
var inst_54150 = (state_54188[(2)]);
var state_54188__$1 = state_54188;
var statearr_54192_54216 = state_54188__$1;
(statearr_54192_54216[(2)] = inst_54150);

(statearr_54192_54216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54189 === (6))){
var inst_54158 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54188__$1 = state_54188;
var statearr_54193_54217 = state_54188__$1;
(statearr_54193_54217[(2)] = inst_54158);

(statearr_54193_54217[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54189 === (3))){
var inst_54186 = (state_54188[(2)]);
var state_54188__$1 = state_54188;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54188__$1,inst_54186);
} else {
if((state_val_54189 === (12))){
var inst_54168 = (state_54188[(2)]);
var inst_54169 = fluree.db.util.async.throw_err.call(null,inst_54168);
var inst_54170 = cljs.core.nth.call(null,inst_54169,(0),null);
var inst_54171 = cljs.core.nth.call(null,inst_54169,(1),null);
var inst_54172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54173 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54174 = ["?pO","?ctx",inst_54170];
var inst_54175 = cljs.core.PersistentHashMap.fromArrays(inst_54173,inst_54174);
var inst_54176 = ((10) + inst_54171);
var inst_54177 = [inst_54175,inst_54176];
var inst_54178 = (new cljs.core.PersistentVector(null,2,(5),inst_54172,inst_54177,null));
var inst_54179 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54178);
var state_54188__$1 = (function (){var statearr_54194 = state_54188;
(statearr_54194[(8)] = inst_54179);

return statearr_54194;
})();
var statearr_54195_54218 = state_54188__$1;
(statearr_54195_54218[(2)] = inst_54170);

(statearr_54195_54218[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54189 === (2))){
var inst_54156 = (state_54188[(7)]);
var _ = (function (){var statearr_54196 = state_54188;
(statearr_54196[(4)] = cljs.core.cons.call(null,(5),(state_54188[(4)])));

return statearr_54196;
})();
var inst_54156__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54188__$1 = (function (){var statearr_54197 = state_54188;
(statearr_54197[(7)] = inst_54156__$1);

return statearr_54197;
})();
if(cljs.core.truth_(inst_54156__$1)){
var statearr_54198_54219 = state_54188__$1;
(statearr_54198_54219[(1)] = (6));

} else {
var statearr_54199_54220 = state_54188__$1;
(statearr_54199_54220[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54189 === (11))){
var inst_54183 = (state_54188[(2)]);
var _ = (function (){var statearr_54201 = state_54188;
(statearr_54201[(4)] = cljs.core.rest.call(null,(state_54188[(4)])));

return statearr_54201;
})();
var state_54188__$1 = state_54188;
var statearr_54202_54221 = state_54188__$1;
(statearr_54202_54221[(2)] = inst_54183);

(statearr_54202_54221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54189 === (9))){
var inst_54166 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_54188__$1 = state_54188;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54188__$1,(12),inst_54166);
} else {
if((state_val_54189 === (5))){
var _ = (function (){var statearr_54203 = state_54188;
(statearr_54203[(4)] = cljs.core.rest.call(null,(state_54188[(4)])));

return statearr_54203;
})();
var state_54188__$1 = state_54188;
var ex54200 = (state_54188__$1[(2)]);
var statearr_54204_54222 = state_54188__$1;
(statearr_54204_54222[(5)] = ex54200);


if((ex54200 instanceof Error)){
var statearr_54205_54223 = state_54188__$1;
(statearr_54205_54223[(1)] = (4));

(statearr_54205_54223[(5)] = null);

} else {
throw ex54200;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54189 === (10))){
var inst_54181 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_54188__$1 = state_54188;
var statearr_54206_54224 = state_54188__$1;
(statearr_54206_54224[(2)] = inst_54181);

(statearr_54206_54224[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54189 === (8))){
var inst_54161 = (state_54188[(2)]);
var state_54188__$1 = state_54188;
if(cljs.core.truth_(inst_54161)){
var statearr_54207_54225 = state_54188__$1;
(statearr_54207_54225[(1)] = (9));

} else {
var statearr_54208_54226 = state_54188__$1;
(statearr_54208_54226[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_54209 = [null,null,null,null,null,null,null,null,null];
(statearr_54209[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_54209[(1)] = (1));

return statearr_54209;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_54188){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_54188);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54210){var ex__2730__auto__ = e54210;
var statearr_54211_54227 = state_54188;
(statearr_54211_54227[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_54188[(4)]))){
var statearr_54212_54228 = state_54188;
(statearr_54212_54228[(1)] = cljs.core.first.call(null,(state_54188[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54229 = state_54188;
state_54188 = G__54229;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = function(state_54188){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_54188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54213 = f__2750__auto__.call(null);
(statearr_54213[(6)] = c__2749__auto__);

return statearr_54213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54298){
var state_val_54299 = (state_54298[(1)]);
if((state_val_54299 === (7))){
var state_54298__$1 = state_54298;
var statearr_54300_54338 = state_54298__$1;
(statearr_54300_54338[(2)] = subject);

(statearr_54300_54338[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (20))){
var inst_54254 = (state_54298[(7)]);
var inst_54266 = (state_54298[(8)]);
var inst_54269 = fluree.db.dbfunctions.internal.follow_subject.call(null,_QMARK_ctx,inst_54266,inst_54254);
var state_54298__$1 = state_54298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54298__$1,(23),inst_54269);
} else {
if((state_val_54299 === (1))){
var state_54298__$1 = state_54298;
var statearr_54301_54339 = state_54298__$1;
(statearr_54301_54339[(2)] = null);

(statearr_54301_54339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (4))){
var inst_54230 = (state_54298[(2)]);
var state_54298__$1 = state_54298;
var statearr_54302_54340 = state_54298__$1;
(statearr_54302_54340[(2)] = inst_54230);

(statearr_54302_54340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (15))){
var inst_54246 = (state_54298[(9)]);
var state_54298__$1 = state_54298;
var statearr_54303_54341 = state_54298__$1;
(statearr_54303_54341[(2)] = inst_54246);

(statearr_54303_54341[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (21))){
var inst_54254 = (state_54298[(7)]);
var inst_54266 = (state_54298[(8)]);
var inst_54274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54275 = fluree.db.dbfunctions.internal.get_all.call(null,inst_54266,inst_54254);
var inst_54276 = cljs.core.count.call(null,inst_54254);
var inst_54277 = ((9) + inst_54276);
var inst_54278 = [inst_54275,inst_54277];
var inst_54279 = (new cljs.core.PersistentVector(null,2,(5),inst_54274,inst_54278,null));
var state_54298__$1 = state_54298;
var statearr_54304_54342 = state_54298__$1;
(statearr_54304_54342[(2)] = inst_54279);

(statearr_54304_54342[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (13))){
var inst_54250 = (state_54298[(2)]);
var inst_54251 = fluree.db.util.async.throw_err.call(null,inst_54250);
var state_54298__$1 = state_54298;
var statearr_54305_54343 = state_54298__$1;
(statearr_54305_54343[(2)] = inst_54251);

(statearr_54305_54343[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (22))){
var inst_54254 = (state_54298[(7)]);
var inst_54246 = (state_54298[(9)]);
var inst_54281 = (state_54298[(2)]);
var inst_54282 = cljs.core.nth.call(null,inst_54281,(0),null);
var inst_54283 = cljs.core.nth.call(null,inst_54281,(1),null);
var inst_54284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54285 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54287 = [inst_54246,inst_54254];
var inst_54288 = (new cljs.core.PersistentVector(null,2,(5),inst_54286,inst_54287,null));
var inst_54289 = ["get-all",inst_54288,inst_54282];
var inst_54290 = cljs.core.PersistentHashMap.fromArrays(inst_54285,inst_54289);
var inst_54291 = [inst_54290,inst_54283];
var inst_54292 = (new cljs.core.PersistentVector(null,2,(5),inst_54284,inst_54291,null));
var inst_54293 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54292);
var _ = (function (){var statearr_54306 = state_54298;
(statearr_54306[(4)] = cljs.core.rest.call(null,(state_54298[(4)])));

return statearr_54306;
})();
var state_54298__$1 = (function (){var statearr_54307 = state_54298;
(statearr_54307[(10)] = inst_54293);

return statearr_54307;
})();
var statearr_54308_54344 = state_54298__$1;
(statearr_54308_54344[(2)] = inst_54282);

(statearr_54308_54344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (6))){
var state_54298__$1 = state_54298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54298__$1,(9),subject);
} else {
if((state_val_54299 === (17))){
var inst_54246 = (state_54298[(9)]);
var inst_54260 = cljs.core.first.call(null,inst_54246);
var state_54298__$1 = state_54298;
var statearr_54309_54345 = state_54298__$1;
(statearr_54309_54345[(2)] = inst_54260);

(statearr_54309_54345[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (3))){
var inst_54296 = (state_54298[(2)]);
var state_54298__$1 = state_54298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54298__$1,inst_54296);
} else {
if((state_val_54299 === (12))){
var inst_54246 = (state_54298[(9)]);
var inst_54254 = (state_54298[(2)]);
var inst_54255 = cljs.core.vector_QMARK_.call(null,inst_54246);
var state_54298__$1 = (function (){var statearr_54310 = state_54298;
(statearr_54310[(7)] = inst_54254);

return statearr_54310;
})();
if(inst_54255){
var statearr_54311_54346 = state_54298__$1;
(statearr_54311_54346[(1)] = (14));

} else {
var statearr_54312_54347 = state_54298__$1;
(statearr_54312_54347[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (2))){
var _ = (function (){var statearr_54313 = state_54298;
(statearr_54313[(4)] = cljs.core.cons.call(null,(5),(state_54298[(4)])));

return statearr_54313;
})();
var inst_54239 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_54298__$1 = state_54298;
if(inst_54239){
var statearr_54314_54348 = state_54298__$1;
(statearr_54314_54348[(1)] = (6));

} else {
var statearr_54315_54349 = state_54298__$1;
(statearr_54315_54349[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (23))){
var inst_54271 = (state_54298[(2)]);
var inst_54272 = fluree.db.util.async.throw_err.call(null,inst_54271);
var state_54298__$1 = state_54298;
var statearr_54316_54350 = state_54298__$1;
(statearr_54316_54350[(2)] = inst_54272);

(statearr_54316_54350[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (19))){
var inst_54263 = (state_54298[(2)]);
var state_54298__$1 = state_54298;
var statearr_54317_54351 = state_54298__$1;
(statearr_54317_54351[(2)] = inst_54263);

(statearr_54317_54351[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (11))){
var state_54298__$1 = state_54298;
var statearr_54319_54352 = state_54298__$1;
(statearr_54319_54352[(2)] = path);

(statearr_54319_54352[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (9))){
var inst_54242 = (state_54298[(2)]);
var inst_54243 = fluree.db.util.async.throw_err.call(null,inst_54242);
var state_54298__$1 = state_54298;
var statearr_54320_54353 = state_54298__$1;
(statearr_54320_54353[(2)] = inst_54243);

(statearr_54320_54353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (5))){
var _ = (function (){var statearr_54321 = state_54298;
(statearr_54321[(4)] = cljs.core.rest.call(null,(state_54298[(4)])));

return statearr_54321;
})();
var state_54298__$1 = state_54298;
var ex54318 = (state_54298__$1[(2)]);
var statearr_54322_54354 = state_54298__$1;
(statearr_54322_54354[(5)] = ex54318);


if((ex54318 instanceof Error)){
var statearr_54323_54355 = state_54298__$1;
(statearr_54323_54355[(1)] = (4));

(statearr_54323_54355[(5)] = null);

} else {
throw ex54318;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (14))){
var inst_54246 = (state_54298[(9)]);
var inst_54257 = cljs.core.count.call(null,inst_54246);
var inst_54258 = cljs.core._EQ_.call(null,(1),inst_54257);
var state_54298__$1 = state_54298;
if(inst_54258){
var statearr_54324_54356 = state_54298__$1;
(statearr_54324_54356[(1)] = (17));

} else {
var statearr_54325_54357 = state_54298__$1;
(statearr_54325_54357[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (16))){
var inst_54266 = (state_54298[(8)]);
var inst_54266__$1 = (state_54298[(2)]);
var inst_54267 = cljs.core.int_QMARK_.call(null,inst_54266__$1);
var state_54298__$1 = (function (){var statearr_54326 = state_54298;
(statearr_54326[(8)] = inst_54266__$1);

return statearr_54326;
})();
if(inst_54267){
var statearr_54327_54358 = state_54298__$1;
(statearr_54327_54358[(1)] = (20));

} else {
var statearr_54328_54359 = state_54298__$1;
(statearr_54328_54359[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (10))){
var state_54298__$1 = state_54298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54298__$1,(13),path);
} else {
if((state_val_54299 === (18))){
var inst_54246 = (state_54298[(9)]);
var state_54298__$1 = state_54298;
var statearr_54329_54360 = state_54298__$1;
(statearr_54329_54360[(2)] = inst_54246);

(statearr_54329_54360[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (8))){
var inst_54246 = (state_54298[(2)]);
var inst_54247 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_54298__$1 = (function (){var statearr_54330 = state_54298;
(statearr_54330[(9)] = inst_54246);

return statearr_54330;
})();
if(inst_54247){
var statearr_54331_54361 = state_54298__$1;
(statearr_54331_54361[(1)] = (10));

} else {
var statearr_54332_54362 = state_54298__$1;
(statearr_54332_54362[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0 = (function (){
var statearr_54333 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54333[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__);

(statearr_54333[(1)] = (1));

return statearr_54333;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1 = (function (state_54298){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_54298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54334){var ex__2730__auto__ = e54334;
var statearr_54335_54363 = state_54298;
(statearr_54335_54363[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_54298[(4)]))){
var statearr_54336_54364 = state_54298;
(statearr_54336_54364[(1)] = cljs.core.first.call(null,(state_54298[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54365 = state_54298;
state_54298 = G__54365;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = function(state_54298){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1.call(this,state_54298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54337 = f__2750__auto__.call(null);
(statearr_54337[(6)] = c__2749__auto__);

return statearr_54337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54404){
var state_val_54405 = (state_54404[(1)]);
if((state_val_54405 === (7))){
var state_54404__$1 = state_54404;
var statearr_54406_54430 = state_54404__$1;
(statearr_54406_54430[(2)] = subject);

(statearr_54406_54430[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54405 === (1))){
var state_54404__$1 = state_54404;
var statearr_54407_54431 = state_54404__$1;
(statearr_54407_54431[(2)] = null);

(statearr_54407_54431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54405 === (4))){
var inst_54366 = (state_54404[(2)]);
var state_54404__$1 = state_54404;
var statearr_54408_54432 = state_54404__$1;
(statearr_54408_54432[(2)] = inst_54366);

(statearr_54408_54432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54405 === (13))){
var inst_54383 = (state_54404[(2)]);
var inst_54384 = fluree.db.util.async.throw_err.call(null,inst_54383);
var state_54404__$1 = state_54404;
var statearr_54409_54433 = state_54404__$1;
(statearr_54409_54433[(2)] = inst_54384);

(statearr_54409_54433[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54405 === (6))){
var state_54404__$1 = state_54404;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54404__$1,(9),subject);
} else {
if((state_val_54405 === (3))){
var inst_54402 = (state_54404[(2)]);
var state_54404__$1 = state_54404;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54404__$1,inst_54402);
} else {
if((state_val_54405 === (12))){
var inst_54379 = (state_54404[(7)]);
var inst_54387 = (state_54404[(2)]);
var inst_54388 = fluree.db.dbfunctions.internal.get_in.call(null,inst_54379,inst_54387);
var inst_54389 = cljs.core.count.call(null,inst_54387);
var inst_54390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54391 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54393 = [inst_54379,inst_54387];
var inst_54394 = (new cljs.core.PersistentVector(null,2,(5),inst_54392,inst_54393,null));
var inst_54395 = ["get-in",inst_54394,inst_54388];
var inst_54396 = cljs.core.PersistentHashMap.fromArrays(inst_54391,inst_54395);
var inst_54397 = [inst_54396,inst_54389];
var inst_54398 = (new cljs.core.PersistentVector(null,2,(5),inst_54390,inst_54397,null));
var inst_54399 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54398);
var _ = (function (){var statearr_54410 = state_54404;
(statearr_54410[(4)] = cljs.core.rest.call(null,(state_54404[(4)])));

return statearr_54410;
})();
var state_54404__$1 = (function (){var statearr_54411 = state_54404;
(statearr_54411[(8)] = inst_54399);

return statearr_54411;
})();
var statearr_54412_54434 = state_54404__$1;
(statearr_54412_54434[(2)] = inst_54388);

(statearr_54412_54434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54405 === (2))){
var _ = (function (){var statearr_54413 = state_54404;
(statearr_54413[(4)] = cljs.core.cons.call(null,(5),(state_54404[(4)])));

return statearr_54413;
})();
var inst_54372 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_54404__$1 = state_54404;
if(inst_54372){
var statearr_54414_54435 = state_54404__$1;
(statearr_54414_54435[(1)] = (6));

} else {
var statearr_54415_54436 = state_54404__$1;
(statearr_54415_54436[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54405 === (11))){
var state_54404__$1 = state_54404;
var statearr_54417_54437 = state_54404__$1;
(statearr_54417_54437[(2)] = path);

(statearr_54417_54437[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54405 === (9))){
var inst_54375 = (state_54404[(2)]);
var inst_54376 = fluree.db.util.async.throw_err.call(null,inst_54375);
var state_54404__$1 = state_54404;
var statearr_54418_54438 = state_54404__$1;
(statearr_54418_54438[(2)] = inst_54376);

(statearr_54418_54438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54405 === (5))){
var _ = (function (){var statearr_54419 = state_54404;
(statearr_54419[(4)] = cljs.core.rest.call(null,(state_54404[(4)])));

return statearr_54419;
})();
var state_54404__$1 = state_54404;
var ex54416 = (state_54404__$1[(2)]);
var statearr_54420_54439 = state_54404__$1;
(statearr_54420_54439[(5)] = ex54416);


if((ex54416 instanceof Error)){
var statearr_54421_54440 = state_54404__$1;
(statearr_54421_54440[(1)] = (4));

(statearr_54421_54440[(5)] = null);

} else {
throw ex54416;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54405 === (10))){
var state_54404__$1 = state_54404;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54404__$1,(13),path);
} else {
if((state_val_54405 === (8))){
var inst_54379 = (state_54404[(2)]);
var inst_54380 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_54404__$1 = (function (){var statearr_54422 = state_54404;
(statearr_54422[(7)] = inst_54379);

return statearr_54422;
})();
if(inst_54380){
var statearr_54423_54441 = state_54404__$1;
(statearr_54423_54441[(1)] = (10));

} else {
var statearr_54424_54442 = state_54404__$1;
(statearr_54424_54442[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0 = (function (){
var statearr_54425 = [null,null,null,null,null,null,null,null,null];
(statearr_54425[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__);

(statearr_54425[(1)] = (1));

return statearr_54425;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1 = (function (state_54404){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_54404);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54426){var ex__2730__auto__ = e54426;
var statearr_54427_54443 = state_54404;
(statearr_54427_54443[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_54404[(4)]))){
var statearr_54428_54444 = state_54404;
(statearr_54428_54444[(1)] = cljs.core.first.call(null,(state_54404[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54445 = state_54404;
state_54404 = G__54445;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = function(state_54404){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1.call(this,state_54404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54429 = f__2750__auto__.call(null);
(statearr_54429[(6)] = c__2749__auto__);

return statearr_54429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__54446,key_or_ks){
var map__54447 = p__54446;
var map__54447__$1 = cljs.core.__destructure_map.call(null,map__54447);
var _QMARK_ctx = map__54447__$1;
var db = cljs.core.get.call(null,map__54447__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_.call(null,key_or_ks)){
return cljs.core.get_in.call(null,new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.call(null,new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54492){
var state_val_54493 = (state_54492[(1)]);
if((state_val_54493 === (7))){
var state_54492__$1 = state_54492;
var statearr_54494_54523 = state_54492__$1;
(statearr_54494_54523[(2)] = coll);

(statearr_54494_54523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54493 === (1))){
var state_54492__$1 = state_54492;
var statearr_54495_54524 = state_54492__$1;
(statearr_54495_54524[(2)] = null);

(statearr_54495_54524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54493 === (4))){
var inst_54448 = (state_54492[(2)]);
var state_54492__$1 = state_54492;
var statearr_54496_54525 = state_54492__$1;
(statearr_54496_54525[(2)] = inst_54448);

(statearr_54496_54525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54493 === (15))){
var inst_54468 = (state_54492[(7)]);
var inst_54476 = (state_54492[(2)]);
var inst_54477 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_54468,inst_54476);
var inst_54478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54479 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54481 = [inst_54468,inst_54476];
var inst_54482 = (new cljs.core.PersistentVector(null,2,(5),inst_54480,inst_54481,null));
var inst_54483 = ["contains?",inst_54482,inst_54477];
var inst_54484 = cljs.core.PersistentHashMap.fromArrays(inst_54479,inst_54483);
var inst_54485 = [inst_54484,(10)];
var inst_54486 = (new cljs.core.PersistentVector(null,2,(5),inst_54478,inst_54485,null));
var inst_54487 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54486);
var _ = (function (){var statearr_54497 = state_54492;
(statearr_54497[(4)] = cljs.core.rest.call(null,(state_54492[(4)])));

return statearr_54497;
})();
var state_54492__$1 = (function (){var statearr_54498 = state_54492;
(statearr_54498[(8)] = inst_54487);

return statearr_54498;
})();
var statearr_54499_54526 = state_54492__$1;
(statearr_54499_54526[(2)] = inst_54477);

(statearr_54499_54526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54493 === (13))){
var state_54492__$1 = state_54492;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54492__$1,(16),key);
} else {
if((state_val_54493 === (6))){
var state_54492__$1 = state_54492;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54492__$1,(9),coll);
} else {
if((state_val_54493 === (3))){
var inst_54490 = (state_54492[(2)]);
var state_54492__$1 = state_54492;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54492__$1,inst_54490);
} else {
if((state_val_54493 === (12))){
var inst_54468 = (state_54492[(2)]);
var inst_54469 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_54492__$1 = (function (){var statearr_54500 = state_54492;
(statearr_54500[(7)] = inst_54468);

return statearr_54500;
})();
if(inst_54469){
var statearr_54501_54527 = state_54492__$1;
(statearr_54501_54527[(1)] = (13));

} else {
var statearr_54502_54528 = state_54492__$1;
(statearr_54502_54528[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54493 === (2))){
var _ = (function (){var statearr_54503 = state_54492;
(statearr_54503[(4)] = cljs.core.cons.call(null,(5),(state_54492[(4)])));

return statearr_54503;
})();
var inst_54454 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_54492__$1 = state_54492;
if(inst_54454){
var statearr_54504_54529 = state_54492__$1;
(statearr_54504_54529[(1)] = (6));

} else {
var statearr_54505_54530 = state_54492__$1;
(statearr_54505_54530[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54493 === (11))){
var inst_54461 = (state_54492[(9)]);
var inst_54465 = cljs.core.flatten.call(null,inst_54461);
var inst_54466 = cljs.core.set.call(null,inst_54465);
var state_54492__$1 = state_54492;
var statearr_54507_54531 = state_54492__$1;
(statearr_54507_54531[(2)] = inst_54466);

(statearr_54507_54531[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54493 === (9))){
var inst_54457 = (state_54492[(2)]);
var inst_54458 = fluree.db.util.async.throw_err.call(null,inst_54457);
var state_54492__$1 = state_54492;
var statearr_54508_54532 = state_54492__$1;
(statearr_54508_54532[(2)] = inst_54458);

(statearr_54508_54532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54493 === (5))){
var _ = (function (){var statearr_54509 = state_54492;
(statearr_54509[(4)] = cljs.core.rest.call(null,(state_54492[(4)])));

return statearr_54509;
})();
var state_54492__$1 = state_54492;
var ex54506 = (state_54492__$1[(2)]);
var statearr_54510_54533 = state_54492__$1;
(statearr_54510_54533[(5)] = ex54506);


if((ex54506 instanceof Error)){
var statearr_54511_54534 = state_54492__$1;
(statearr_54511_54534[(1)] = (4));

(statearr_54511_54534[(5)] = null);

} else {
throw ex54506;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54493 === (14))){
var state_54492__$1 = state_54492;
var statearr_54512_54535 = state_54492__$1;
(statearr_54512_54535[(2)] = key);

(statearr_54512_54535[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54493 === (16))){
var inst_54472 = (state_54492[(2)]);
var inst_54473 = fluree.db.util.async.throw_err.call(null,inst_54472);
var state_54492__$1 = state_54492;
var statearr_54513_54536 = state_54492__$1;
(statearr_54513_54536[(2)] = inst_54473);

(statearr_54513_54536[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54493 === (10))){
var inst_54461 = (state_54492[(9)]);
var state_54492__$1 = state_54492;
var statearr_54514_54537 = state_54492__$1;
(statearr_54514_54537[(2)] = inst_54461);

(statearr_54514_54537[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54493 === (8))){
var inst_54461 = (state_54492[(9)]);
var inst_54461__$1 = (state_54492[(2)]);
var inst_54462 = cljs.core.set_QMARK_.call(null,inst_54461__$1);
var state_54492__$1 = (function (){var statearr_54515 = state_54492;
(statearr_54515[(9)] = inst_54461__$1);

return statearr_54515;
})();
if(inst_54462){
var statearr_54516_54538 = state_54492__$1;
(statearr_54516_54538[(1)] = (10));

} else {
var statearr_54517_54539 = state_54492__$1;
(statearr_54517_54539[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_54518 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54518[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__);

(statearr_54518[(1)] = (1));

return statearr_54518;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1 = (function (state_54492){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_54492);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54519){var ex__2730__auto__ = e54519;
var statearr_54520_54540 = state_54492;
(statearr_54520_54540[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_54492[(4)]))){
var statearr_54521_54541 = state_54492;
(statearr_54521_54541[(1)] = cljs.core.first.call(null,(state_54492[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54542 = state_54492;
state_54492 = G__54542;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = function(state_54492){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1.call(this,state_54492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54522 = f__2750__auto__.call(null);
(statearr_54522[(6)] = c__2749__auto__);

return statearr_54522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54614 = arguments.length;
var i__4865__auto___54615 = (0);
while(true){
if((i__4865__auto___54615 < len__4864__auto___54614)){
args__4870__auto__.push((arguments[i__4865__auto___54615]));

var G__54616 = (i__4865__auto___54615 + (1));
i__4865__auto___54615 = G__54616;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54588){
var state_val_54589 = (state_54588[(1)]);
if((state_val_54589 === (7))){
var inst_54554 = (state_54588[(7)]);
var inst_54558 = cljs.core.first.call(null,inst_54554);
var inst_54559 = cljs.core.coll_QMARK_.call(null,inst_54558);
var state_54588__$1 = state_54588;
var statearr_54590_54617 = state_54588__$1;
(statearr_54590_54617[(2)] = inst_54559);

(statearr_54590_54617[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54589 === (1))){
var state_54588__$1 = state_54588;
var statearr_54591_54618 = state_54588__$1;
(statearr_54591_54618[(2)] = null);

(statearr_54591_54618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54589 === (4))){
var inst_54545 = (state_54588[(2)]);
var state_54588__$1 = state_54588;
var statearr_54592_54619 = state_54588__$1;
(statearr_54592_54619[(2)] = inst_54545);

(statearr_54592_54619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54589 === (6))){
var inst_54556 = (state_54588[(8)]);
var inst_54554 = (state_54588[(7)]);
var inst_54553 = (state_54588[(2)]);
var inst_54554__$1 = fluree.db.util.async.throw_err.call(null,inst_54553);
var inst_54555 = cljs.core.count.call(null,inst_54554__$1);
var inst_54556__$1 = cljs.core._EQ_.call(null,(1),inst_54555);
var state_54588__$1 = (function (){var statearr_54593 = state_54588;
(statearr_54593[(8)] = inst_54556__$1);

(statearr_54593[(7)] = inst_54554__$1);

return statearr_54593;
})();
if(inst_54556__$1){
var statearr_54594_54620 = state_54588__$1;
(statearr_54594_54620[(1)] = (7));

} else {
var statearr_54595_54621 = state_54588__$1;
(statearr_54595_54621[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54589 === (3))){
var inst_54586 = (state_54588[(2)]);
var state_54588__$1 = state_54588;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54588__$1,inst_54586);
} else {
if((state_val_54589 === (12))){
var inst_54567 = (state_54588[(2)]);
var inst_54568 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_54567);
var inst_54569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54570 = [inst_54567];
var inst_54571 = (new cljs.core.PersistentVector(null,1,(5),inst_54569,inst_54570,null));
var inst_54572 = cljs.core.count.call(null,inst_54571);
var inst_54573 = ((9) + inst_54572);
var inst_54574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54575 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54577 = [inst_54567];
var inst_54578 = (new cljs.core.PersistentVector(null,1,(5),inst_54576,inst_54577,null));
var inst_54579 = ["hash-set",inst_54578,inst_54568];
var inst_54580 = cljs.core.PersistentHashMap.fromArrays(inst_54575,inst_54579);
var inst_54581 = [inst_54580,inst_54573];
var inst_54582 = (new cljs.core.PersistentVector(null,2,(5),inst_54574,inst_54581,null));
var inst_54583 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54582);
var _ = (function (){var statearr_54596 = state_54588;
(statearr_54596[(4)] = cljs.core.rest.call(null,(state_54588[(4)])));

return statearr_54596;
})();
var state_54588__$1 = (function (){var statearr_54597 = state_54588;
(statearr_54597[(9)] = inst_54583);

return statearr_54597;
})();
var statearr_54598_54622 = state_54588__$1;
(statearr_54598_54622[(2)] = inst_54568);

(statearr_54598_54622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54589 === (2))){
var _ = (function (){var statearr_54599 = state_54588;
(statearr_54599[(4)] = cljs.core.cons.call(null,(5),(state_54588[(4)])));

return statearr_54599;
})();
var inst_54551 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54588__$1 = state_54588;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54588__$1,(6),inst_54551);
} else {
if((state_val_54589 === (11))){
var inst_54554 = (state_54588[(7)]);
var state_54588__$1 = state_54588;
var statearr_54601_54623 = state_54588__$1;
(statearr_54601_54623[(2)] = inst_54554);

(statearr_54601_54623[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54589 === (9))){
var inst_54562 = (state_54588[(2)]);
var state_54588__$1 = state_54588;
if(cljs.core.truth_(inst_54562)){
var statearr_54602_54624 = state_54588__$1;
(statearr_54602_54624[(1)] = (10));

} else {
var statearr_54603_54625 = state_54588__$1;
(statearr_54603_54625[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54589 === (5))){
var _ = (function (){var statearr_54604 = state_54588;
(statearr_54604[(4)] = cljs.core.rest.call(null,(state_54588[(4)])));

return statearr_54604;
})();
var state_54588__$1 = state_54588;
var ex54600 = (state_54588__$1[(2)]);
var statearr_54605_54626 = state_54588__$1;
(statearr_54605_54626[(5)] = ex54600);


if((ex54600 instanceof Error)){
var statearr_54606_54627 = state_54588__$1;
(statearr_54606_54627[(1)] = (4));

(statearr_54606_54627[(5)] = null);

} else {
throw ex54600;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54589 === (10))){
var inst_54554 = (state_54588[(7)]);
var inst_54564 = cljs.core.first.call(null,inst_54554);
var state_54588__$1 = state_54588;
var statearr_54607_54628 = state_54588__$1;
(statearr_54607_54628[(2)] = inst_54564);

(statearr_54607_54628[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54589 === (8))){
var inst_54556 = (state_54588[(8)]);
var state_54588__$1 = state_54588;
var statearr_54608_54629 = state_54588__$1;
(statearr_54608_54629[(2)] = inst_54556);

(statearr_54608_54629[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54609 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54609[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54609[(1)] = (1));

return statearr_54609;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54588){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_54588);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54610){var ex__2730__auto__ = e54610;
var statearr_54611_54630 = state_54588;
(statearr_54611_54630[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_54588[(4)]))){
var statearr_54612_54631 = state_54588;
(statearr_54612_54631[(1)] = cljs.core.first.call(null,(state_54588[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54632 = state_54588;
state_54588 = G__54632;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54588){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54613 = f__2750__auto__.call(null);
(statearr_54613[(6)] = c__2749__auto__);

return statearr_54613;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq54543){
var G__54544 = cljs.core.first.call(null,seq54543);
var seq54543__$1 = cljs.core.next.call(null,seq54543);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54544,seq54543__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54682 = arguments.length;
var i__4865__auto___54683 = (0);
while(true){
if((i__4865__auto___54683 < len__4864__auto___54682)){
args__4870__auto__.push((arguments[i__4865__auto___54683]));

var G__54684 = (i__4865__auto___54683 + (1));
i__4865__auto___54683 = G__54684;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54665){
var state_val_54666 = (state_54665[(1)]);
if((state_val_54666 === (1))){
var state_54665__$1 = state_54665;
var statearr_54667_54685 = state_54665__$1;
(statearr_54667_54685[(2)] = null);

(statearr_54667_54685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54666 === (2))){
var _ = (function (){var statearr_54668 = state_54665;
(statearr_54668[(4)] = cljs.core.cons.call(null,(5),(state_54665[(4)])));

return statearr_54668;
})();
var inst_54641 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54665__$1 = state_54665;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54665__$1,(6),inst_54641);
} else {
if((state_val_54666 === (3))){
var inst_54663 = (state_54665[(2)]);
var state_54665__$1 = state_54665;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54665__$1,inst_54663);
} else {
if((state_val_54666 === (4))){
var inst_54635 = (state_54665[(2)]);
var state_54665__$1 = state_54665;
var statearr_54670_54686 = state_54665__$1;
(statearr_54670_54686[(2)] = inst_54635);

(statearr_54670_54686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54666 === (5))){
var _ = (function (){var statearr_54671 = state_54665;
(statearr_54671[(4)] = cljs.core.rest.call(null,(state_54665[(4)])));

return statearr_54671;
})();
var state_54665__$1 = state_54665;
var ex54669 = (state_54665__$1[(2)]);
var statearr_54672_54687 = state_54665__$1;
(statearr_54672_54687[(5)] = ex54669);


if((ex54669 instanceof Error)){
var statearr_54673_54688 = state_54665__$1;
(statearr_54673_54688[(1)] = (4));

(statearr_54673_54688[(5)] = null);

} else {
throw ex54669;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54666 === (6))){
var inst_54643 = (state_54665[(2)]);
var inst_54644 = fluree.db.util.async.throw_err.call(null,inst_54643);
var inst_54645 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_54644);
var inst_54646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54647 = [inst_54644];
var inst_54648 = (new cljs.core.PersistentVector(null,1,(5),inst_54646,inst_54647,null));
var inst_54649 = cljs.core.count.call(null,inst_54648);
var inst_54650 = ((9) + inst_54649);
var inst_54651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54652 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54654 = [inst_54644];
var inst_54655 = (new cljs.core.PersistentVector(null,1,(5),inst_54653,inst_54654,null));
var inst_54656 = ["==",inst_54655,inst_54645];
var inst_54657 = cljs.core.PersistentHashMap.fromArrays(inst_54652,inst_54656);
var inst_54658 = [inst_54657,inst_54650];
var inst_54659 = (new cljs.core.PersistentVector(null,2,(5),inst_54651,inst_54658,null));
var inst_54660 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54659);
var _ = (function (){var statearr_54674 = state_54665;
(statearr_54674[(4)] = cljs.core.rest.call(null,(state_54665[(4)])));

return statearr_54674;
})();
var state_54665__$1 = (function (){var statearr_54675 = state_54665;
(statearr_54675[(7)] = inst_54660);

return statearr_54675;
})();
var statearr_54676_54689 = state_54665__$1;
(statearr_54676_54689[(2)] = inst_54645);

(statearr_54676_54689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54677 = [null,null,null,null,null,null,null,null];
(statearr_54677[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54677[(1)] = (1));

return statearr_54677;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54665){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_54665);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54678){var ex__2730__auto__ = e54678;
var statearr_54679_54690 = state_54665;
(statearr_54679_54690[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_54665[(4)]))){
var statearr_54680_54691 = state_54665;
(statearr_54680_54691[(1)] = cljs.core.first.call(null,(state_54665[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54692 = state_54665;
state_54665 = G__54692;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54665){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54681 = f__2750__auto__.call(null);
(statearr_54681[(6)] = c__2749__auto__);

return statearr_54681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq54633){
var G__54634 = cljs.core.first.call(null,seq54633);
var seq54633__$1 = cljs.core.next.call(null,seq54633);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54634,seq54633__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54742 = arguments.length;
var i__4865__auto___54743 = (0);
while(true){
if((i__4865__auto___54743 < len__4864__auto___54742)){
args__4870__auto__.push((arguments[i__4865__auto___54743]));

var G__54744 = (i__4865__auto___54743 + (1));
i__4865__auto___54743 = G__54744;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54725){
var state_val_54726 = (state_54725[(1)]);
if((state_val_54726 === (1))){
var state_54725__$1 = state_54725;
var statearr_54727_54745 = state_54725__$1;
(statearr_54727_54745[(2)] = null);

(statearr_54727_54745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54726 === (2))){
var _ = (function (){var statearr_54728 = state_54725;
(statearr_54728[(4)] = cljs.core.cons.call(null,(5),(state_54725[(4)])));

return statearr_54728;
})();
var inst_54701 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54725__$1 = state_54725;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54725__$1,(6),inst_54701);
} else {
if((state_val_54726 === (3))){
var inst_54723 = (state_54725[(2)]);
var state_54725__$1 = state_54725;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54725__$1,inst_54723);
} else {
if((state_val_54726 === (4))){
var inst_54695 = (state_54725[(2)]);
var state_54725__$1 = state_54725;
var statearr_54730_54746 = state_54725__$1;
(statearr_54730_54746[(2)] = inst_54695);

(statearr_54730_54746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54726 === (5))){
var _ = (function (){var statearr_54731 = state_54725;
(statearr_54731[(4)] = cljs.core.rest.call(null,(state_54725[(4)])));

return statearr_54731;
})();
var state_54725__$1 = state_54725;
var ex54729 = (state_54725__$1[(2)]);
var statearr_54732_54747 = state_54725__$1;
(statearr_54732_54747[(5)] = ex54729);


if((ex54729 instanceof Error)){
var statearr_54733_54748 = state_54725__$1;
(statearr_54733_54748[(1)] = (4));

(statearr_54733_54748[(5)] = null);

} else {
throw ex54729;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54726 === (6))){
var inst_54703 = (state_54725[(2)]);
var inst_54704 = fluree.db.util.async.throw_err.call(null,inst_54703);
var inst_54705 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_54704);
var inst_54706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54707 = [inst_54704];
var inst_54708 = (new cljs.core.PersistentVector(null,1,(5),inst_54706,inst_54707,null));
var inst_54709 = cljs.core.count.call(null,inst_54708);
var inst_54710 = ((9) + inst_54709);
var inst_54711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54712 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54714 = [inst_54704];
var inst_54715 = (new cljs.core.PersistentVector(null,1,(5),inst_54713,inst_54714,null));
var inst_54716 = [">",inst_54715,inst_54705];
var inst_54717 = cljs.core.PersistentHashMap.fromArrays(inst_54712,inst_54716);
var inst_54718 = [inst_54717,inst_54710];
var inst_54719 = (new cljs.core.PersistentVector(null,2,(5),inst_54711,inst_54718,null));
var inst_54720 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54719);
var _ = (function (){var statearr_54734 = state_54725;
(statearr_54734[(4)] = cljs.core.rest.call(null,(state_54725[(4)])));

return statearr_54734;
})();
var state_54725__$1 = (function (){var statearr_54735 = state_54725;
(statearr_54735[(7)] = inst_54720);

return statearr_54735;
})();
var statearr_54736_54749 = state_54725__$1;
(statearr_54736_54749[(2)] = inst_54705);

(statearr_54736_54749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54737 = [null,null,null,null,null,null,null,null];
(statearr_54737[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54737[(1)] = (1));

return statearr_54737;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54725){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_54725);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54738){var ex__2730__auto__ = e54738;
var statearr_54739_54750 = state_54725;
(statearr_54739_54750[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_54725[(4)]))){
var statearr_54740_54751 = state_54725;
(statearr_54740_54751[(1)] = cljs.core.first.call(null,(state_54725[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54752 = state_54725;
state_54725 = G__54752;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54725){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54741 = f__2750__auto__.call(null);
(statearr_54741[(6)] = c__2749__auto__);

return statearr_54741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq54693){
var G__54694 = cljs.core.first.call(null,seq54693);
var seq54693__$1 = cljs.core.next.call(null,seq54693);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54694,seq54693__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54802 = arguments.length;
var i__4865__auto___54803 = (0);
while(true){
if((i__4865__auto___54803 < len__4864__auto___54802)){
args__4870__auto__.push((arguments[i__4865__auto___54803]));

var G__54804 = (i__4865__auto___54803 + (1));
i__4865__auto___54803 = G__54804;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54785){
var state_val_54786 = (state_54785[(1)]);
if((state_val_54786 === (1))){
var state_54785__$1 = state_54785;
var statearr_54787_54805 = state_54785__$1;
(statearr_54787_54805[(2)] = null);

(statearr_54787_54805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54786 === (2))){
var _ = (function (){var statearr_54788 = state_54785;
(statearr_54788[(4)] = cljs.core.cons.call(null,(5),(state_54785[(4)])));

return statearr_54788;
})();
var inst_54761 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54785__$1 = state_54785;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54785__$1,(6),inst_54761);
} else {
if((state_val_54786 === (3))){
var inst_54783 = (state_54785[(2)]);
var state_54785__$1 = state_54785;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54785__$1,inst_54783);
} else {
if((state_val_54786 === (4))){
var inst_54755 = (state_54785[(2)]);
var state_54785__$1 = state_54785;
var statearr_54790_54806 = state_54785__$1;
(statearr_54790_54806[(2)] = inst_54755);

(statearr_54790_54806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54786 === (5))){
var _ = (function (){var statearr_54791 = state_54785;
(statearr_54791[(4)] = cljs.core.rest.call(null,(state_54785[(4)])));

return statearr_54791;
})();
var state_54785__$1 = state_54785;
var ex54789 = (state_54785__$1[(2)]);
var statearr_54792_54807 = state_54785__$1;
(statearr_54792_54807[(5)] = ex54789);


if((ex54789 instanceof Error)){
var statearr_54793_54808 = state_54785__$1;
(statearr_54793_54808[(1)] = (4));

(statearr_54793_54808[(5)] = null);

} else {
throw ex54789;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54786 === (6))){
var inst_54763 = (state_54785[(2)]);
var inst_54764 = fluree.db.util.async.throw_err.call(null,inst_54763);
var inst_54765 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_54764);
var inst_54766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54767 = [inst_54764];
var inst_54768 = (new cljs.core.PersistentVector(null,1,(5),inst_54766,inst_54767,null));
var inst_54769 = cljs.core.count.call(null,inst_54768);
var inst_54770 = ((9) + inst_54769);
var inst_54771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54772 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54774 = [inst_54764];
var inst_54775 = (new cljs.core.PersistentVector(null,1,(5),inst_54773,inst_54774,null));
var inst_54776 = ["<",inst_54775,inst_54765];
var inst_54777 = cljs.core.PersistentHashMap.fromArrays(inst_54772,inst_54776);
var inst_54778 = [inst_54777,inst_54770];
var inst_54779 = (new cljs.core.PersistentVector(null,2,(5),inst_54771,inst_54778,null));
var inst_54780 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54779);
var _ = (function (){var statearr_54794 = state_54785;
(statearr_54794[(4)] = cljs.core.rest.call(null,(state_54785[(4)])));

return statearr_54794;
})();
var state_54785__$1 = (function (){var statearr_54795 = state_54785;
(statearr_54795[(7)] = inst_54780);

return statearr_54795;
})();
var statearr_54796_54809 = state_54785__$1;
(statearr_54796_54809[(2)] = inst_54765);

(statearr_54796_54809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54797 = [null,null,null,null,null,null,null,null];
(statearr_54797[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54797[(1)] = (1));

return statearr_54797;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54785){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_54785);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54798){var ex__2730__auto__ = e54798;
var statearr_54799_54810 = state_54785;
(statearr_54799_54810[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_54785[(4)]))){
var statearr_54800_54811 = state_54785;
(statearr_54800_54811[(1)] = cljs.core.first.call(null,(state_54785[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54812 = state_54785;
state_54785 = G__54812;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54785){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54801 = f__2750__auto__.call(null);
(statearr_54801[(6)] = c__2749__auto__);

return statearr_54801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq54753){
var G__54754 = cljs.core.first.call(null,seq54753);
var seq54753__$1 = cljs.core.next.call(null,seq54753);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54754,seq54753__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54862 = arguments.length;
var i__4865__auto___54863 = (0);
while(true){
if((i__4865__auto___54863 < len__4864__auto___54862)){
args__4870__auto__.push((arguments[i__4865__auto___54863]));

var G__54864 = (i__4865__auto___54863 + (1));
i__4865__auto___54863 = G__54864;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54845){
var state_val_54846 = (state_54845[(1)]);
if((state_val_54846 === (1))){
var state_54845__$1 = state_54845;
var statearr_54847_54865 = state_54845__$1;
(statearr_54847_54865[(2)] = null);

(statearr_54847_54865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54846 === (2))){
var _ = (function (){var statearr_54848 = state_54845;
(statearr_54848[(4)] = cljs.core.cons.call(null,(5),(state_54845[(4)])));

return statearr_54848;
})();
var inst_54821 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54845__$1 = state_54845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54845__$1,(6),inst_54821);
} else {
if((state_val_54846 === (3))){
var inst_54843 = (state_54845[(2)]);
var state_54845__$1 = state_54845;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54845__$1,inst_54843);
} else {
if((state_val_54846 === (4))){
var inst_54815 = (state_54845[(2)]);
var state_54845__$1 = state_54845;
var statearr_54850_54866 = state_54845__$1;
(statearr_54850_54866[(2)] = inst_54815);

(statearr_54850_54866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54846 === (5))){
var _ = (function (){var statearr_54851 = state_54845;
(statearr_54851[(4)] = cljs.core.rest.call(null,(state_54845[(4)])));

return statearr_54851;
})();
var state_54845__$1 = state_54845;
var ex54849 = (state_54845__$1[(2)]);
var statearr_54852_54867 = state_54845__$1;
(statearr_54852_54867[(5)] = ex54849);


if((ex54849 instanceof Error)){
var statearr_54853_54868 = state_54845__$1;
(statearr_54853_54868[(1)] = (4));

(statearr_54853_54868[(5)] = null);

} else {
throw ex54849;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54846 === (6))){
var inst_54823 = (state_54845[(2)]);
var inst_54824 = fluree.db.util.async.throw_err.call(null,inst_54823);
var inst_54825 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_54824);
var inst_54826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54827 = [inst_54824];
var inst_54828 = (new cljs.core.PersistentVector(null,1,(5),inst_54826,inst_54827,null));
var inst_54829 = cljs.core.count.call(null,inst_54828);
var inst_54830 = ((9) + inst_54829);
var inst_54831 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54832 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54834 = [inst_54824];
var inst_54835 = (new cljs.core.PersistentVector(null,1,(5),inst_54833,inst_54834,null));
var inst_54836 = ["<=",inst_54835,inst_54825];
var inst_54837 = cljs.core.PersistentHashMap.fromArrays(inst_54832,inst_54836);
var inst_54838 = [inst_54837,inst_54830];
var inst_54839 = (new cljs.core.PersistentVector(null,2,(5),inst_54831,inst_54838,null));
var inst_54840 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54839);
var _ = (function (){var statearr_54854 = state_54845;
(statearr_54854[(4)] = cljs.core.rest.call(null,(state_54845[(4)])));

return statearr_54854;
})();
var state_54845__$1 = (function (){var statearr_54855 = state_54845;
(statearr_54855[(7)] = inst_54840);

return statearr_54855;
})();
var statearr_54856_54869 = state_54845__$1;
(statearr_54856_54869[(2)] = inst_54825);

(statearr_54856_54869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54857 = [null,null,null,null,null,null,null,null];
(statearr_54857[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54857[(1)] = (1));

return statearr_54857;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54845){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_54845);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54858){var ex__2730__auto__ = e54858;
var statearr_54859_54870 = state_54845;
(statearr_54859_54870[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_54845[(4)]))){
var statearr_54860_54871 = state_54845;
(statearr_54860_54871[(1)] = cljs.core.first.call(null,(state_54845[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54872 = state_54845;
state_54845 = G__54872;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54845){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54861 = f__2750__auto__.call(null);
(statearr_54861[(6)] = c__2749__auto__);

return statearr_54861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq54813){
var G__54814 = cljs.core.first.call(null,seq54813);
var seq54813__$1 = cljs.core.next.call(null,seq54813);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54814,seq54813__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54922 = arguments.length;
var i__4865__auto___54923 = (0);
while(true){
if((i__4865__auto___54923 < len__4864__auto___54922)){
args__4870__auto__.push((arguments[i__4865__auto___54923]));

var G__54924 = (i__4865__auto___54923 + (1));
i__4865__auto___54923 = G__54924;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54905){
var state_val_54906 = (state_54905[(1)]);
if((state_val_54906 === (1))){
var state_54905__$1 = state_54905;
var statearr_54907_54925 = state_54905__$1;
(statearr_54907_54925[(2)] = null);

(statearr_54907_54925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54906 === (2))){
var _ = (function (){var statearr_54908 = state_54905;
(statearr_54908[(4)] = cljs.core.cons.call(null,(5),(state_54905[(4)])));

return statearr_54908;
})();
var inst_54881 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54905__$1 = state_54905;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54905__$1,(6),inst_54881);
} else {
if((state_val_54906 === (3))){
var inst_54903 = (state_54905[(2)]);
var state_54905__$1 = state_54905;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54905__$1,inst_54903);
} else {
if((state_val_54906 === (4))){
var inst_54875 = (state_54905[(2)]);
var state_54905__$1 = state_54905;
var statearr_54910_54926 = state_54905__$1;
(statearr_54910_54926[(2)] = inst_54875);

(statearr_54910_54926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54906 === (5))){
var _ = (function (){var statearr_54911 = state_54905;
(statearr_54911[(4)] = cljs.core.rest.call(null,(state_54905[(4)])));

return statearr_54911;
})();
var state_54905__$1 = state_54905;
var ex54909 = (state_54905__$1[(2)]);
var statearr_54912_54927 = state_54905__$1;
(statearr_54912_54927[(5)] = ex54909);


if((ex54909 instanceof Error)){
var statearr_54913_54928 = state_54905__$1;
(statearr_54913_54928[(1)] = (4));

(statearr_54913_54928[(5)] = null);

} else {
throw ex54909;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54906 === (6))){
var inst_54883 = (state_54905[(2)]);
var inst_54884 = fluree.db.util.async.throw_err.call(null,inst_54883);
var inst_54885 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_54884);
var inst_54886 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54887 = [inst_54884];
var inst_54888 = (new cljs.core.PersistentVector(null,1,(5),inst_54886,inst_54887,null));
var inst_54889 = cljs.core.count.call(null,inst_54888);
var inst_54890 = ((9) + inst_54889);
var inst_54891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54892 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54893 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54894 = [inst_54884];
var inst_54895 = (new cljs.core.PersistentVector(null,1,(5),inst_54893,inst_54894,null));
var inst_54896 = [">=",inst_54895,inst_54885];
var inst_54897 = cljs.core.PersistentHashMap.fromArrays(inst_54892,inst_54896);
var inst_54898 = [inst_54897,inst_54890];
var inst_54899 = (new cljs.core.PersistentVector(null,2,(5),inst_54891,inst_54898,null));
var inst_54900 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54899);
var _ = (function (){var statearr_54914 = state_54905;
(statearr_54914[(4)] = cljs.core.rest.call(null,(state_54905[(4)])));

return statearr_54914;
})();
var state_54905__$1 = (function (){var statearr_54915 = state_54905;
(statearr_54915[(7)] = inst_54900);

return statearr_54915;
})();
var statearr_54916_54929 = state_54905__$1;
(statearr_54916_54929[(2)] = inst_54885);

(statearr_54916_54929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54917 = [null,null,null,null,null,null,null,null];
(statearr_54917[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54917[(1)] = (1));

return statearr_54917;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54905){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_54905);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54918){var ex__2730__auto__ = e54918;
var statearr_54919_54930 = state_54905;
(statearr_54919_54930[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_54905[(4)]))){
var statearr_54920_54931 = state_54905;
(statearr_54920_54931[(1)] = cljs.core.first.call(null,(state_54905[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54932 = state_54905;
state_54905 = G__54932;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54905){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54921 = f__2750__auto__.call(null);
(statearr_54921[(6)] = c__2749__auto__);

return statearr_54921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq54873){
var G__54874 = cljs.core.first.call(null,seq54873);
var seq54873__$1 = cljs.core.next.call(null,seq54873);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54874,seq54873__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54982 = arguments.length;
var i__4865__auto___54983 = (0);
while(true){
if((i__4865__auto___54983 < len__4864__auto___54982)){
args__4870__auto__.push((arguments[i__4865__auto___54983]));

var G__54984 = (i__4865__auto___54983 + (1));
i__4865__auto___54983 = G__54984;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54965){
var state_val_54966 = (state_54965[(1)]);
if((state_val_54966 === (1))){
var state_54965__$1 = state_54965;
var statearr_54967_54985 = state_54965__$1;
(statearr_54967_54985[(2)] = null);

(statearr_54967_54985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54966 === (2))){
var _ = (function (){var statearr_54968 = state_54965;
(statearr_54968[(4)] = cljs.core.cons.call(null,(5),(state_54965[(4)])));

return statearr_54968;
})();
var inst_54941 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54965__$1 = state_54965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54965__$1,(6),inst_54941);
} else {
if((state_val_54966 === (3))){
var inst_54963 = (state_54965[(2)]);
var state_54965__$1 = state_54965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54965__$1,inst_54963);
} else {
if((state_val_54966 === (4))){
var inst_54935 = (state_54965[(2)]);
var state_54965__$1 = state_54965;
var statearr_54970_54986 = state_54965__$1;
(statearr_54970_54986[(2)] = inst_54935);

(statearr_54970_54986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54966 === (5))){
var _ = (function (){var statearr_54971 = state_54965;
(statearr_54971[(4)] = cljs.core.rest.call(null,(state_54965[(4)])));

return statearr_54971;
})();
var state_54965__$1 = state_54965;
var ex54969 = (state_54965__$1[(2)]);
var statearr_54972_54987 = state_54965__$1;
(statearr_54972_54987[(5)] = ex54969);


if((ex54969 instanceof Error)){
var statearr_54973_54988 = state_54965__$1;
(statearr_54973_54988[(1)] = (4));

(statearr_54973_54988[(5)] = null);

} else {
throw ex54969;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54966 === (6))){
var inst_54943 = (state_54965[(2)]);
var inst_54944 = fluree.db.util.async.throw_err.call(null,inst_54943);
var inst_54945 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_54944);
var inst_54946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54947 = [inst_54944];
var inst_54948 = (new cljs.core.PersistentVector(null,1,(5),inst_54946,inst_54947,null));
var inst_54949 = cljs.core.count.call(null,inst_54948);
var inst_54950 = ((9) + inst_54949);
var inst_54951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54952 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54954 = [inst_54944];
var inst_54955 = (new cljs.core.PersistentVector(null,1,(5),inst_54953,inst_54954,null));
var inst_54956 = ["not=",inst_54955,inst_54945];
var inst_54957 = cljs.core.PersistentHashMap.fromArrays(inst_54952,inst_54956);
var inst_54958 = [inst_54957,inst_54950];
var inst_54959 = (new cljs.core.PersistentVector(null,2,(5),inst_54951,inst_54958,null));
var inst_54960 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54959);
var _ = (function (){var statearr_54974 = state_54965;
(statearr_54974[(4)] = cljs.core.rest.call(null,(state_54965[(4)])));

return statearr_54974;
})();
var state_54965__$1 = (function (){var statearr_54975 = state_54965;
(statearr_54975[(7)] = inst_54960);

return statearr_54975;
})();
var statearr_54976_54989 = state_54965__$1;
(statearr_54976_54989[(2)] = inst_54945);

(statearr_54976_54989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54977 = [null,null,null,null,null,null,null,null];
(statearr_54977[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54977[(1)] = (1));

return statearr_54977;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54965){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_54965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54978){var ex__2730__auto__ = e54978;
var statearr_54979_54990 = state_54965;
(statearr_54979_54990[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_54965[(4)]))){
var statearr_54980_54991 = state_54965;
(statearr_54980_54991[(1)] = cljs.core.first.call(null,(state_54965[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54992 = state_54965;
state_54965 = G__54992;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54965){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54981 = f__2750__auto__.call(null);
(statearr_54981[(6)] = c__2749__auto__);

return statearr_54981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq54933){
var G__54934 = cljs.core.first.call(null,seq54933);
var seq54933__$1 = cljs.core.next.call(null,seq54933);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54934,seq54933__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55042 = arguments.length;
var i__4865__auto___55043 = (0);
while(true){
if((i__4865__auto___55043 < len__4864__auto___55042)){
args__4870__auto__.push((arguments[i__4865__auto___55043]));

var G__55044 = (i__4865__auto___55043 + (1));
i__4865__auto___55043 = G__55044;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55025){
var state_val_55026 = (state_55025[(1)]);
if((state_val_55026 === (1))){
var state_55025__$1 = state_55025;
var statearr_55027_55045 = state_55025__$1;
(statearr_55027_55045[(2)] = null);

(statearr_55027_55045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55026 === (2))){
var _ = (function (){var statearr_55028 = state_55025;
(statearr_55028[(4)] = cljs.core.cons.call(null,(5),(state_55025[(4)])));

return statearr_55028;
})();
var inst_55001 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55025__$1 = state_55025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55025__$1,(6),inst_55001);
} else {
if((state_val_55026 === (3))){
var inst_55023 = (state_55025[(2)]);
var state_55025__$1 = state_55025;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55025__$1,inst_55023);
} else {
if((state_val_55026 === (4))){
var inst_54995 = (state_55025[(2)]);
var state_55025__$1 = state_55025;
var statearr_55030_55046 = state_55025__$1;
(statearr_55030_55046[(2)] = inst_54995);

(statearr_55030_55046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55026 === (5))){
var _ = (function (){var statearr_55031 = state_55025;
(statearr_55031[(4)] = cljs.core.rest.call(null,(state_55025[(4)])));

return statearr_55031;
})();
var state_55025__$1 = state_55025;
var ex55029 = (state_55025__$1[(2)]);
var statearr_55032_55047 = state_55025__$1;
(statearr_55032_55047[(5)] = ex55029);


if((ex55029 instanceof Error)){
var statearr_55033_55048 = state_55025__$1;
(statearr_55033_55048[(1)] = (4));

(statearr_55033_55048[(5)] = null);

} else {
throw ex55029;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55026 === (6))){
var inst_55003 = (state_55025[(2)]);
var inst_55004 = fluree.db.util.async.throw_err.call(null,inst_55003);
var inst_55005 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_55004);
var inst_55006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55007 = [inst_55004];
var inst_55008 = (new cljs.core.PersistentVector(null,1,(5),inst_55006,inst_55007,null));
var inst_55009 = cljs.core.count.call(null,inst_55008);
var inst_55010 = ((9) + inst_55009);
var inst_55011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55012 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55014 = [inst_55004];
var inst_55015 = (new cljs.core.PersistentVector(null,1,(5),inst_55013,inst_55014,null));
var inst_55016 = ["max",inst_55015,inst_55005];
var inst_55017 = cljs.core.PersistentHashMap.fromArrays(inst_55012,inst_55016);
var inst_55018 = [inst_55017,inst_55010];
var inst_55019 = (new cljs.core.PersistentVector(null,2,(5),inst_55011,inst_55018,null));
var inst_55020 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55019);
var _ = (function (){var statearr_55034 = state_55025;
(statearr_55034[(4)] = cljs.core.rest.call(null,(state_55025[(4)])));

return statearr_55034;
})();
var state_55025__$1 = (function (){var statearr_55035 = state_55025;
(statearr_55035[(7)] = inst_55020);

return statearr_55035;
})();
var statearr_55036_55049 = state_55025__$1;
(statearr_55036_55049[(2)] = inst_55005);

(statearr_55036_55049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55037 = [null,null,null,null,null,null,null,null];
(statearr_55037[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55037[(1)] = (1));

return statearr_55037;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55025){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_55025);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55038){var ex__2730__auto__ = e55038;
var statearr_55039_55050 = state_55025;
(statearr_55039_55050[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_55025[(4)]))){
var statearr_55040_55051 = state_55025;
(statearr_55040_55051[(1)] = cljs.core.first.call(null,(state_55025[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55052 = state_55025;
state_55025 = G__55052;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55025){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55041 = f__2750__auto__.call(null);
(statearr_55041[(6)] = c__2749__auto__);

return statearr_55041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq54993){
var G__54994 = cljs.core.first.call(null,seq54993);
var seq54993__$1 = cljs.core.next.call(null,seq54993);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54994,seq54993__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55102 = arguments.length;
var i__4865__auto___55103 = (0);
while(true){
if((i__4865__auto___55103 < len__4864__auto___55102)){
args__4870__auto__.push((arguments[i__4865__auto___55103]));

var G__55104 = (i__4865__auto___55103 + (1));
i__4865__auto___55103 = G__55104;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55085){
var state_val_55086 = (state_55085[(1)]);
if((state_val_55086 === (1))){
var state_55085__$1 = state_55085;
var statearr_55087_55105 = state_55085__$1;
(statearr_55087_55105[(2)] = null);

(statearr_55087_55105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (2))){
var _ = (function (){var statearr_55088 = state_55085;
(statearr_55088[(4)] = cljs.core.cons.call(null,(5),(state_55085[(4)])));

return statearr_55088;
})();
var inst_55061 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55085__$1 = state_55085;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55085__$1,(6),inst_55061);
} else {
if((state_val_55086 === (3))){
var inst_55083 = (state_55085[(2)]);
var state_55085__$1 = state_55085;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55085__$1,inst_55083);
} else {
if((state_val_55086 === (4))){
var inst_55055 = (state_55085[(2)]);
var state_55085__$1 = state_55085;
var statearr_55090_55106 = state_55085__$1;
(statearr_55090_55106[(2)] = inst_55055);

(statearr_55090_55106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (5))){
var _ = (function (){var statearr_55091 = state_55085;
(statearr_55091[(4)] = cljs.core.rest.call(null,(state_55085[(4)])));

return statearr_55091;
})();
var state_55085__$1 = state_55085;
var ex55089 = (state_55085__$1[(2)]);
var statearr_55092_55107 = state_55085__$1;
(statearr_55092_55107[(5)] = ex55089);


if((ex55089 instanceof Error)){
var statearr_55093_55108 = state_55085__$1;
(statearr_55093_55108[(1)] = (4));

(statearr_55093_55108[(5)] = null);

} else {
throw ex55089;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (6))){
var inst_55063 = (state_55085[(2)]);
var inst_55064 = fluree.db.util.async.throw_err.call(null,inst_55063);
var inst_55065 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_55064);
var inst_55066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55067 = [inst_55064];
var inst_55068 = (new cljs.core.PersistentVector(null,1,(5),inst_55066,inst_55067,null));
var inst_55069 = cljs.core.count.call(null,inst_55068);
var inst_55070 = ((9) + inst_55069);
var inst_55071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55072 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55074 = [inst_55064];
var inst_55075 = (new cljs.core.PersistentVector(null,1,(5),inst_55073,inst_55074,null));
var inst_55076 = ["min",inst_55075,inst_55065];
var inst_55077 = cljs.core.PersistentHashMap.fromArrays(inst_55072,inst_55076);
var inst_55078 = [inst_55077,inst_55070];
var inst_55079 = (new cljs.core.PersistentVector(null,2,(5),inst_55071,inst_55078,null));
var inst_55080 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55079);
var _ = (function (){var statearr_55094 = state_55085;
(statearr_55094[(4)] = cljs.core.rest.call(null,(state_55085[(4)])));

return statearr_55094;
})();
var state_55085__$1 = (function (){var statearr_55095 = state_55085;
(statearr_55095[(7)] = inst_55080);

return statearr_55095;
})();
var statearr_55096_55109 = state_55085__$1;
(statearr_55096_55109[(2)] = inst_55065);

(statearr_55096_55109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55097 = [null,null,null,null,null,null,null,null];
(statearr_55097[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55097[(1)] = (1));

return statearr_55097;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55085){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_55085);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55098){var ex__2730__auto__ = e55098;
var statearr_55099_55110 = state_55085;
(statearr_55099_55110[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_55085[(4)]))){
var statearr_55100_55111 = state_55085;
(statearr_55100_55111[(1)] = cljs.core.first.call(null,(state_55085[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55112 = state_55085;
state_55085 = G__55112;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55085){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55101 = f__2750__auto__.call(null);
(statearr_55101[(6)] = c__2749__auto__);

return statearr_55101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq55053){
var G__55054 = cljs.core.first.call(null,seq55053);
var seq55053__$1 = cljs.core.next.call(null,seq55053);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55054,seq55053__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__55114 = arguments.length;
switch (G__55114) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55159){
var state_val_55160 = (state_55159[(1)]);
if((state_val_55160 === (7))){
var state_55159__$1 = state_55159;
var statearr_55161_55298 = state_55159__$1;
(statearr_55161_55298[(2)] = query_map);

(statearr_55161_55298[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (1))){
var state_55159__$1 = state_55159;
var statearr_55162_55299 = state_55159__$1;
(statearr_55162_55299[(2)] = null);

(statearr_55162_55299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (4))){
var inst_55115 = (state_55159[(2)]);
var state_55159__$1 = state_55159;
var statearr_55163_55300 = state_55159__$1;
(statearr_55163_55300[(2)] = inst_55115);

(statearr_55163_55300[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (13))){
var inst_55137 = (state_55159[(7)]);
var inst_55141 = (state_55159[(2)]);
var inst_55142 = fluree.db.util.async.throw_err.call(null,inst_55141);
var inst_55143 = cljs.core.nth.call(null,inst_55142,(0),null);
var inst_55144 = cljs.core.nth.call(null,inst_55142,(1),null);
var inst_55145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55146 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55147 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55148 = [inst_55137];
var inst_55149 = (new cljs.core.PersistentVector(null,1,(5),inst_55147,inst_55148,null));
var inst_55150 = ["query",inst_55149,inst_55143];
var inst_55151 = cljs.core.PersistentHashMap.fromArrays(inst_55146,inst_55150);
var inst_55152 = [inst_55151,inst_55144];
var inst_55153 = (new cljs.core.PersistentVector(null,2,(5),inst_55145,inst_55152,null));
var inst_55154 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55153);
var _ = (function (){var statearr_55164 = state_55159;
(statearr_55164[(4)] = cljs.core.rest.call(null,(state_55159[(4)])));

return statearr_55164;
})();
var state_55159__$1 = (function (){var statearr_55165 = state_55159;
(statearr_55165[(8)] = inst_55154);

return statearr_55165;
})();
var statearr_55166_55301 = state_55159__$1;
(statearr_55166_55301[(2)] = inst_55143);

(statearr_55166_55301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (6))){
var state_55159__$1 = state_55159;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55159__$1,(9),query_map);
} else {
if((state_val_55160 === (3))){
var inst_55157 = (state_55159[(2)]);
var state_55159__$1 = state_55159;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55159__$1,inst_55157);
} else {
if((state_val_55160 === (12))){
var inst_55137 = (state_55159[(7)]);
var inst_55137__$1 = (state_55159[(2)]);
var inst_55138 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55139 = fluree.db.dbfunctions.internal.query.call(null,inst_55138,inst_55137__$1);
var state_55159__$1 = (function (){var statearr_55167 = state_55159;
(statearr_55167[(7)] = inst_55137__$1);

return statearr_55167;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55159__$1,(13),inst_55139);
} else {
if((state_val_55160 === (2))){
var _ = (function (){var statearr_55168 = state_55159;
(statearr_55168[(4)] = cljs.core.cons.call(null,(5),(state_55159[(4)])));

return statearr_55168;
})();
var inst_55124 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_55159__$1 = state_55159;
if(inst_55124){
var statearr_55169_55302 = state_55159__$1;
(statearr_55169_55302[(1)] = (6));

} else {
var statearr_55170_55303 = state_55159__$1;
(statearr_55170_55303[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (11))){
var inst_55131 = (state_55159[(9)]);
var state_55159__$1 = state_55159;
var statearr_55172_55304 = state_55159__$1;
(statearr_55172_55304[(2)] = inst_55131);

(statearr_55172_55304[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (9))){
var inst_55127 = (state_55159[(2)]);
var inst_55128 = fluree.db.util.async.throw_err.call(null,inst_55127);
var state_55159__$1 = state_55159;
var statearr_55173_55305 = state_55159__$1;
(statearr_55173_55305[(2)] = inst_55128);

(statearr_55173_55305[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (5))){
var _ = (function (){var statearr_55174 = state_55159;
(statearr_55174[(4)] = cljs.core.rest.call(null,(state_55159[(4)])));

return statearr_55174;
})();
var state_55159__$1 = state_55159;
var ex55171 = (state_55159__$1[(2)]);
var statearr_55175_55306 = state_55159__$1;
(statearr_55175_55306[(5)] = ex55171);


if((ex55171 instanceof Error)){
var statearr_55176_55307 = state_55159__$1;
(statearr_55176_55307[(1)] = (4));

(statearr_55176_55307[(5)] = null);

} else {
throw ex55171;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (10))){
var inst_55131 = (state_55159[(9)]);
var inst_55134 = fluree.db.util.json.parse.call(null,inst_55131);
var state_55159__$1 = state_55159;
var statearr_55177_55308 = state_55159__$1;
(statearr_55177_55308[(2)] = inst_55134);

(statearr_55177_55308[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55160 === (8))){
var inst_55131 = (state_55159[(9)]);
var inst_55131__$1 = (state_55159[(2)]);
var inst_55132 = typeof inst_55131__$1 === 'string';
var state_55159__$1 = (function (){var statearr_55178 = state_55159;
(statearr_55178[(9)] = inst_55131__$1);

return statearr_55178;
})();
if(cljs.core.truth_(inst_55132)){
var statearr_55179_55309 = state_55159__$1;
(statearr_55179_55309[(1)] = (10));

} else {
var statearr_55180_55310 = state_55159__$1;
(statearr_55180_55310[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55181 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55181[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55181[(1)] = (1));

return statearr_55181;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55159){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_55159);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55182){var ex__2730__auto__ = e55182;
var statearr_55183_55311 = state_55159;
(statearr_55183_55311[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_55159[(4)]))){
var statearr_55184_55312 = state_55159;
(statearr_55184_55312[(1)] = cljs.core.first.call(null,(state_55159[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55313 = state_55159;
state_55159 = G__55313;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55159){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55159);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55185 = f__2750__auto__.call(null);
(statearr_55185[(6)] = c__2749__auto__);

return statearr_55185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55256){
var state_val_55257 = (state_55256[(1)]);
if((state_val_55257 === (7))){
var state_55256__$1 = state_55256;
var statearr_55258_55314 = state_55256__$1;
(statearr_55258_55314[(2)] = select);

(statearr_55258_55314[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (20))){
var inst_55226 = (state_55256[(2)]);
var inst_55227 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_55256__$1 = (function (){var statearr_55259 = state_55256;
(statearr_55259[(7)] = inst_55226);

return statearr_55259;
})();
if(inst_55227){
var statearr_55260_55315 = state_55256__$1;
(statearr_55260_55315[(1)] = (22));

} else {
var statearr_55261_55316 = state_55256__$1;
(statearr_55261_55316[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (1))){
var state_55256__$1 = state_55256;
var statearr_55262_55317 = state_55256__$1;
(statearr_55262_55317[(2)] = null);

(statearr_55262_55317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (24))){
var inst_55202 = (state_55256[(8)]);
var inst_55210 = (state_55256[(9)]);
var inst_55226 = (state_55256[(7)]);
var inst_55218 = (state_55256[(10)]);
var inst_55234 = (state_55256[(2)]);
var inst_55235 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55236 = fluree.db.dbfunctions.internal.query.call(null,inst_55235,inst_55202,inst_55210,inst_55218,inst_55226,inst_55234);
var state_55256__$1 = state_55256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55256__$1,(26),inst_55236);
} else {
if((state_val_55257 === (4))){
var inst_55186 = (state_55256[(2)]);
var state_55256__$1 = state_55256;
var statearr_55263_55318 = state_55256__$1;
(statearr_55263_55318[(2)] = inst_55186);

(statearr_55263_55318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (15))){
var state_55256__$1 = state_55256;
var statearr_55264_55319 = state_55256__$1;
(statearr_55264_55319[(2)] = where);

(statearr_55264_55319[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (21))){
var inst_55222 = (state_55256[(2)]);
var inst_55223 = fluree.db.util.async.throw_err.call(null,inst_55222);
var state_55256__$1 = state_55256;
var statearr_55265_55320 = state_55256__$1;
(statearr_55265_55320[(2)] = inst_55223);

(statearr_55265_55320[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (13))){
var inst_55206 = (state_55256[(2)]);
var inst_55207 = fluree.db.util.async.throw_err.call(null,inst_55206);
var state_55256__$1 = state_55256;
var statearr_55266_55321 = state_55256__$1;
(statearr_55266_55321[(2)] = inst_55207);

(statearr_55266_55321[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (22))){
var state_55256__$1 = state_55256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55256__$1,(25),limit);
} else {
if((state_val_55257 === (6))){
var state_55256__$1 = state_55256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55256__$1,(9),select);
} else {
if((state_val_55257 === (25))){
var inst_55230 = (state_55256[(2)]);
var inst_55231 = fluree.db.util.async.throw_err.call(null,inst_55230);
var state_55256__$1 = state_55256;
var statearr_55267_55322 = state_55256__$1;
(statearr_55267_55322[(2)] = inst_55231);

(statearr_55267_55322[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (17))){
var inst_55214 = (state_55256[(2)]);
var inst_55215 = fluree.db.util.async.throw_err.call(null,inst_55214);
var state_55256__$1 = state_55256;
var statearr_55268_55323 = state_55256__$1;
(statearr_55268_55323[(2)] = inst_55215);

(statearr_55268_55323[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (3))){
var inst_55254 = (state_55256[(2)]);
var state_55256__$1 = state_55256;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55256__$1,inst_55254);
} else {
if((state_val_55257 === (12))){
var inst_55210 = (state_55256[(2)]);
var inst_55211 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_55256__$1 = (function (){var statearr_55269 = state_55256;
(statearr_55269[(9)] = inst_55210);

return statearr_55269;
})();
if(inst_55211){
var statearr_55270_55324 = state_55256__$1;
(statearr_55270_55324[(1)] = (14));

} else {
var statearr_55271_55325 = state_55256__$1;
(statearr_55271_55325[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (2))){
var _ = (function (){var statearr_55272 = state_55256;
(statearr_55272[(4)] = cljs.core.cons.call(null,(5),(state_55256[(4)])));

return statearr_55272;
})();
var inst_55195 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_55256__$1 = state_55256;
if(inst_55195){
var statearr_55273_55326 = state_55256__$1;
(statearr_55273_55326[(1)] = (6));

} else {
var statearr_55274_55327 = state_55256__$1;
(statearr_55274_55327[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (23))){
var state_55256__$1 = state_55256;
var statearr_55275_55328 = state_55256__$1;
(statearr_55275_55328[(2)] = limit);

(statearr_55275_55328[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (19))){
var state_55256__$1 = state_55256;
var statearr_55276_55329 = state_55256__$1;
(statearr_55276_55329[(2)] = block);

(statearr_55276_55329[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (11))){
var state_55256__$1 = state_55256;
var statearr_55278_55330 = state_55256__$1;
(statearr_55278_55330[(2)] = from);

(statearr_55278_55330[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (9))){
var inst_55198 = (state_55256[(2)]);
var inst_55199 = fluree.db.util.async.throw_err.call(null,inst_55198);
var state_55256__$1 = state_55256;
var statearr_55279_55331 = state_55256__$1;
(statearr_55279_55331[(2)] = inst_55199);

(statearr_55279_55331[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (5))){
var _ = (function (){var statearr_55280 = state_55256;
(statearr_55280[(4)] = cljs.core.rest.call(null,(state_55256[(4)])));

return statearr_55280;
})();
var state_55256__$1 = state_55256;
var ex55277 = (state_55256__$1[(2)]);
var statearr_55281_55332 = state_55256__$1;
(statearr_55281_55332[(5)] = ex55277);


if((ex55277 instanceof Error)){
var statearr_55282_55333 = state_55256__$1;
(statearr_55282_55333[(1)] = (4));

(statearr_55282_55333[(5)] = null);

} else {
throw ex55277;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (14))){
var state_55256__$1 = state_55256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55256__$1,(17),where);
} else {
if((state_val_55257 === (26))){
var inst_55202 = (state_55256[(8)]);
var inst_55210 = (state_55256[(9)]);
var inst_55226 = (state_55256[(7)]);
var inst_55218 = (state_55256[(10)]);
var inst_55238 = (state_55256[(2)]);
var inst_55239 = fluree.db.util.async.throw_err.call(null,inst_55238);
var inst_55240 = cljs.core.nth.call(null,inst_55239,(0),null);
var inst_55241 = cljs.core.nth.call(null,inst_55239,(1),null);
var inst_55242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55243 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55245 = [inst_55202,inst_55210,inst_55218,inst_55226];
var inst_55246 = (new cljs.core.PersistentVector(null,4,(5),inst_55244,inst_55245,null));
var inst_55247 = ["query",inst_55246,inst_55240];
var inst_55248 = cljs.core.PersistentHashMap.fromArrays(inst_55243,inst_55247);
var inst_55249 = [inst_55248,inst_55241];
var inst_55250 = (new cljs.core.PersistentVector(null,2,(5),inst_55242,inst_55249,null));
var inst_55251 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55250);
var _ = (function (){var statearr_55283 = state_55256;
(statearr_55283[(4)] = cljs.core.rest.call(null,(state_55256[(4)])));

return statearr_55283;
})();
var state_55256__$1 = (function (){var statearr_55284 = state_55256;
(statearr_55284[(11)] = inst_55251);

return statearr_55284;
})();
var statearr_55285_55334 = state_55256__$1;
(statearr_55285_55334[(2)] = inst_55240);

(statearr_55285_55334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (16))){
var inst_55218 = (state_55256[(2)]);
var inst_55219 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_55256__$1 = (function (){var statearr_55286 = state_55256;
(statearr_55286[(10)] = inst_55218);

return statearr_55286;
})();
if(inst_55219){
var statearr_55287_55335 = state_55256__$1;
(statearr_55287_55335[(1)] = (18));

} else {
var statearr_55288_55336 = state_55256__$1;
(statearr_55288_55336[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55257 === (10))){
var state_55256__$1 = state_55256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55256__$1,(13),from);
} else {
if((state_val_55257 === (18))){
var state_55256__$1 = state_55256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55256__$1,(21),block);
} else {
if((state_val_55257 === (8))){
var inst_55202 = (state_55256[(2)]);
var inst_55203 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_55256__$1 = (function (){var statearr_55289 = state_55256;
(statearr_55289[(8)] = inst_55202);

return statearr_55289;
})();
if(inst_55203){
var statearr_55290_55337 = state_55256__$1;
(statearr_55290_55337[(1)] = (10));

} else {
var statearr_55291_55338 = state_55256__$1;
(statearr_55291_55338[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55292 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55292[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55292[(1)] = (1));

return statearr_55292;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55256){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_55256);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55293){var ex__2730__auto__ = e55293;
var statearr_55294_55339 = state_55256;
(statearr_55294_55339[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_55256[(4)]))){
var statearr_55295_55340 = state_55256;
(statearr_55295_55340[(1)] = cljs.core.first.call(null,(state_55256[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55341 = state_55256;
state_55256 = G__55341;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55256){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55296 = f__2750__auto__.call(null);
(statearr_55296[(6)] = c__2749__auto__);

return statearr_55296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55397){
var state_val_55398 = (state_55397[(1)]);
if((state_val_55398 === (7))){
var state_55397__$1 = state_55397;
var statearr_55399_55430 = state_55397__$1;
(statearr_55399_55430[(2)] = startSubject);

(statearr_55399_55430[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55398 === (1))){
var state_55397__$1 = state_55397;
var statearr_55400_55431 = state_55397__$1;
(statearr_55400_55431[(2)] = null);

(statearr_55400_55431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55398 === (4))){
var inst_55342 = (state_55397[(2)]);
var state_55397__$1 = state_55397;
var statearr_55401_55432 = state_55397__$1;
(statearr_55401_55432[(2)] = inst_55342);

(statearr_55401_55432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55398 === (15))){
var inst_55374 = (state_55397[(2)]);
var inst_55375 = fluree.db.util.async.throw_err.call(null,inst_55374);
var inst_55376 = cljs.core.nth.call(null,inst_55375,(0),null);
var inst_55377 = cljs.core.nth.call(null,inst_55375,(1),null);
var inst_55378 = cljs.core.empty_QMARK_.call(null,inst_55376);
var state_55397__$1 = (function (){var statearr_55402 = state_55397;
(statearr_55402[(7)] = inst_55377);

return statearr_55402;
})();
if(inst_55378){
var statearr_55403_55433 = state_55397__$1;
(statearr_55403_55433[(1)] = (16));

} else {
var statearr_55404_55434 = state_55397__$1;
(statearr_55404_55434[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55398 === (13))){
var inst_55358 = (state_55397[(8)]);
var inst_55362 = (state_55397[(9)]);
var inst_55370 = (state_55397[(10)]);
var inst_55370__$1 = (state_55397[(2)]);
var inst_55371 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55372 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_55371,inst_55358,inst_55362,inst_55370__$1);
var state_55397__$1 = (function (){var statearr_55405 = state_55397;
(statearr_55405[(10)] = inst_55370__$1);

return statearr_55405;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55397__$1,(15),inst_55372);
} else {
if((state_val_55398 === (6))){
var state_55397__$1 = state_55397;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55397__$1,(9),startSubject);
} else {
if((state_val_55398 === (17))){
var state_55397__$1 = state_55397;
var statearr_55406_55435 = state_55397__$1;
(statearr_55406_55435[(2)] = true);

(statearr_55406_55435[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55398 === (3))){
var inst_55395 = (state_55397[(2)]);
var state_55397__$1 = state_55397;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55397__$1,inst_55395);
} else {
if((state_val_55398 === (12))){
var state_55397__$1 = state_55397;
var statearr_55407_55436 = state_55397__$1;
(statearr_55407_55436[(2)] = endSubject);

(statearr_55407_55436[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55398 === (2))){
var _ = (function (){var statearr_55408 = state_55397;
(statearr_55408[(4)] = cljs.core.cons.call(null,(5),(state_55397[(4)])));

return statearr_55408;
})();
var inst_55351 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_55397__$1 = state_55397;
if(inst_55351){
var statearr_55409_55437 = state_55397__$1;
(statearr_55409_55437[(1)] = (6));

} else {
var statearr_55410_55438 = state_55397__$1;
(statearr_55410_55438[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55398 === (11))){
var state_55397__$1 = state_55397;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55397__$1,(14),endSubject);
} else {
if((state_val_55398 === (9))){
var inst_55354 = (state_55397[(2)]);
var inst_55355 = fluree.db.util.async.throw_err.call(null,inst_55354);
var state_55397__$1 = state_55397;
var statearr_55412_55439 = state_55397__$1;
(statearr_55412_55439[(2)] = inst_55355);

(statearr_55412_55439[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55398 === (5))){
var _ = (function (){var statearr_55413 = state_55397;
(statearr_55413[(4)] = cljs.core.rest.call(null,(state_55397[(4)])));

return statearr_55413;
})();
var state_55397__$1 = state_55397;
var ex55411 = (state_55397__$1[(2)]);
var statearr_55414_55440 = state_55397__$1;
(statearr_55414_55440[(5)] = ex55411);


if((ex55411 instanceof Error)){
var statearr_55415_55441 = state_55397__$1;
(statearr_55415_55441[(1)] = (4));

(statearr_55415_55441[(5)] = null);

} else {
throw ex55411;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55398 === (14))){
var inst_55366 = (state_55397[(2)]);
var inst_55367 = fluree.db.util.async.throw_err.call(null,inst_55366);
var state_55397__$1 = state_55397;
var statearr_55416_55442 = state_55397__$1;
(statearr_55416_55442[(2)] = inst_55367);

(statearr_55416_55442[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55398 === (16))){
var state_55397__$1 = state_55397;
var statearr_55417_55443 = state_55397__$1;
(statearr_55417_55443[(2)] = false);

(statearr_55417_55443[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55398 === (10))){
var inst_55361 = (state_55397[(2)]);
var inst_55362 = fluree.db.util.async.throw_err.call(null,inst_55361);
var inst_55363 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_55397__$1 = (function (){var statearr_55418 = state_55397;
(statearr_55418[(9)] = inst_55362);

return statearr_55418;
})();
if(inst_55363){
var statearr_55419_55444 = state_55397__$1;
(statearr_55419_55444[(1)] = (11));

} else {
var statearr_55420_55445 = state_55397__$1;
(statearr_55420_55445[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55398 === (18))){
var inst_55377 = (state_55397[(7)]);
var inst_55358 = (state_55397[(8)]);
var inst_55362 = (state_55397[(9)]);
var inst_55370 = (state_55397[(10)]);
var inst_55382 = (state_55397[(2)]);
var inst_55383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55384 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55385 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55386 = [inst_55358,inst_55362,inst_55370];
var inst_55387 = (new cljs.core.PersistentVector(null,3,(5),inst_55385,inst_55386,null));
var inst_55388 = ["relationship?",inst_55387,inst_55382];
var inst_55389 = cljs.core.PersistentHashMap.fromArrays(inst_55384,inst_55388);
var inst_55390 = [inst_55389,inst_55377];
var inst_55391 = (new cljs.core.PersistentVector(null,2,(5),inst_55383,inst_55390,null));
var inst_55392 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55391);
var _ = (function (){var statearr_55421 = state_55397;
(statearr_55421[(4)] = cljs.core.rest.call(null,(state_55397[(4)])));

return statearr_55421;
})();
var state_55397__$1 = (function (){var statearr_55422 = state_55397;
(statearr_55422[(11)] = inst_55392);

return statearr_55422;
})();
var statearr_55423_55446 = state_55397__$1;
(statearr_55423_55446[(2)] = inst_55382);

(statearr_55423_55446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55398 === (8))){
var inst_55358 = (state_55397[(2)]);
var inst_55359 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_55397__$1 = (function (){var statearr_55424 = state_55397;
(statearr_55424[(8)] = inst_55358);

return statearr_55424;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55397__$1,(10),inst_55359);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_55425 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55425[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_55425[(1)] = (1));

return statearr_55425;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_55397){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_55397);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55426){var ex__2730__auto__ = e55426;
var statearr_55427_55447 = state_55397;
(statearr_55427_55447[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_55397[(4)]))){
var statearr_55428_55448 = state_55397;
(statearr_55428_55448[(1)] = cljs.core.first.call(null,(state_55397[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55449 = state_55397;
state_55397 = G__55449;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = function(state_55397){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_55397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55429 = f__2750__auto__.call(null);
(statearr_55429[(6)] = c__2749__auto__);

return statearr_55429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55486){
var state_val_55487 = (state_55486[(1)]);
if((state_val_55487 === (7))){
var state_55486__$1 = state_55486;
var statearr_55488_55508 = state_55486__$1;
(statearr_55488_55508[(2)] = pred_name);

(statearr_55488_55508[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55487 === (1))){
var state_55486__$1 = state_55486;
var statearr_55489_55509 = state_55486__$1;
(statearr_55489_55509[(2)] = null);

(statearr_55489_55509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55487 === (4))){
var inst_55450 = (state_55486[(2)]);
var state_55486__$1 = state_55486;
var statearr_55490_55510 = state_55486__$1;
(statearr_55490_55510[(2)] = inst_55450);

(statearr_55490_55510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55487 === (6))){
var state_55486__$1 = state_55486;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55486__$1,(9),pred_name);
} else {
if((state_val_55487 === (3))){
var inst_55484 = (state_55486[(2)]);
var state_55486__$1 = state_55486;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55486__$1,inst_55484);
} else {
if((state_val_55487 === (2))){
var _ = (function (){var statearr_55492 = state_55486;
(statearr_55492[(4)] = cljs.core.cons.call(null,(5),(state_55486[(4)])));

return statearr_55492;
})();
var inst_55459 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_55486__$1 = state_55486;
if(inst_55459){
var statearr_55493_55511 = state_55486__$1;
(statearr_55493_55511[(1)] = (6));

} else {
var statearr_55494_55512 = state_55486__$1;
(statearr_55494_55512[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55487 === (9))){
var inst_55462 = (state_55486[(2)]);
var inst_55463 = fluree.db.util.async.throw_err.call(null,inst_55462);
var state_55486__$1 = state_55486;
var statearr_55495_55513 = state_55486__$1;
(statearr_55495_55513[(2)] = inst_55463);

(statearr_55495_55513[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55487 === (5))){
var _ = (function (){var statearr_55496 = state_55486;
(statearr_55496[(4)] = cljs.core.rest.call(null,(state_55486[(4)])));

return statearr_55496;
})();
var state_55486__$1 = state_55486;
var ex55491 = (state_55486__$1[(2)]);
var statearr_55497_55514 = state_55486__$1;
(statearr_55497_55514[(5)] = ex55491);


if((ex55491 instanceof Error)){
var statearr_55498_55515 = state_55486__$1;
(statearr_55498_55515[(1)] = (4));

(statearr_55498_55515[(5)] = null);

} else {
throw ex55491;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55487 === (10))){
var inst_55466 = (state_55486[(7)]);
var inst_55470 = (state_55486[(2)]);
var inst_55471 = fluree.db.util.async.throw_err.call(null,inst_55470);
var inst_55472 = cljs.core.nth.call(null,inst_55471,(0),null);
var inst_55473 = cljs.core.nth.call(null,inst_55471,(1),null);
var inst_55474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55475 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55476 = ["max-pred-val",inst_55466,inst_55472];
var inst_55477 = cljs.core.PersistentHashMap.fromArrays(inst_55475,inst_55476);
var inst_55478 = (inst_55473 + (10));
var inst_55479 = [inst_55477,inst_55478];
var inst_55480 = (new cljs.core.PersistentVector(null,2,(5),inst_55474,inst_55479,null));
var inst_55481 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55480);
var _ = (function (){var statearr_55499 = state_55486;
(statearr_55499[(4)] = cljs.core.rest.call(null,(state_55486[(4)])));

return statearr_55499;
})();
var state_55486__$1 = (function (){var statearr_55500 = state_55486;
(statearr_55500[(8)] = inst_55481);

return statearr_55500;
})();
var statearr_55501_55516 = state_55486__$1;
(statearr_55501_55516[(2)] = inst_55472);

(statearr_55501_55516[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55487 === (8))){
var inst_55466 = (state_55486[(7)]);
var inst_55466__$1 = (state_55486[(2)]);
var inst_55467 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55468 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_55467,inst_55466__$1,null);
var state_55486__$1 = (function (){var statearr_55502 = state_55486;
(statearr_55502[(7)] = inst_55466__$1);

return statearr_55502;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55486__$1,(10),inst_55468);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_55503 = [null,null,null,null,null,null,null,null,null];
(statearr_55503[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__);

(statearr_55503[(1)] = (1));

return statearr_55503;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1 = (function (state_55486){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_55486);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55504){var ex__2730__auto__ = e55504;
var statearr_55505_55517 = state_55486;
(statearr_55505_55517[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_55486[(4)]))){
var statearr_55506_55518 = state_55486;
(statearr_55506_55518[(1)] = cljs.core.first.call(null,(state_55486[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55519 = state_55486;
state_55486 = G__55519;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = function(state_55486){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1.call(this,state_55486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55507 = f__2750__auto__.call(null);
(statearr_55507[(6)] = c__2749__auto__);

return statearr_55507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55546){
var state_val_55547 = (state_55546[(1)]);
if((state_val_55547 === (7))){
var state_55546__$1 = state_55546;
var statearr_55548_55567 = state_55546__$1;
(statearr_55548_55567[(2)] = n);

(statearr_55548_55567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55547 === (1))){
var state_55546__$1 = state_55546;
var statearr_55549_55568 = state_55546__$1;
(statearr_55549_55568[(2)] = null);

(statearr_55549_55568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55547 === (4))){
var inst_55520 = (state_55546[(2)]);
var state_55546__$1 = state_55546;
var statearr_55550_55569 = state_55546__$1;
(statearr_55550_55569[(2)] = inst_55520);

(statearr_55550_55569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55547 === (6))){
var state_55546__$1 = state_55546;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55546__$1,(9),n);
} else {
if((state_val_55547 === (3))){
var inst_55544 = (state_55546[(2)]);
var state_55546__$1 = state_55546;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55546__$1,inst_55544);
} else {
if((state_val_55547 === (2))){
var _ = (function (){var statearr_55552 = state_55546;
(statearr_55552[(4)] = cljs.core.cons.call(null,(5),(state_55546[(4)])));

return statearr_55552;
})();
var inst_55526 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55546__$1 = state_55546;
if(inst_55526){
var statearr_55553_55570 = state_55546__$1;
(statearr_55553_55570[(1)] = (6));

} else {
var statearr_55554_55571 = state_55546__$1;
(statearr_55554_55571[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55547 === (9))){
var inst_55529 = (state_55546[(2)]);
var inst_55530 = fluree.db.util.async.throw_err.call(null,inst_55529);
var state_55546__$1 = state_55546;
var statearr_55555_55572 = state_55546__$1;
(statearr_55555_55572[(2)] = inst_55530);

(statearr_55555_55572[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55547 === (5))){
var _ = (function (){var statearr_55556 = state_55546;
(statearr_55556[(4)] = cljs.core.rest.call(null,(state_55546[(4)])));

return statearr_55556;
})();
var state_55546__$1 = state_55546;
var ex55551 = (state_55546__$1[(2)]);
var statearr_55557_55573 = state_55546__$1;
(statearr_55557_55573[(5)] = ex55551);


if((ex55551 instanceof Error)){
var statearr_55558_55574 = state_55546__$1;
(statearr_55558_55574[(1)] = (4));

(statearr_55558_55574[(5)] = null);

} else {
throw ex55551;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55547 === (8))){
var inst_55533 = (state_55546[(2)]);
var inst_55534 = fluree.db.dbfunctions.internal.inc.call(null,inst_55533);
var inst_55535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55536 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55537 = ["inc",inst_55533,inst_55534];
var inst_55538 = cljs.core.PersistentHashMap.fromArrays(inst_55536,inst_55537);
var inst_55539 = [inst_55538,(10)];
var inst_55540 = (new cljs.core.PersistentVector(null,2,(5),inst_55535,inst_55539,null));
var inst_55541 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55540);
var _ = (function (){var statearr_55559 = state_55546;
(statearr_55559[(4)] = cljs.core.rest.call(null,(state_55546[(4)])));

return statearr_55559;
})();
var state_55546__$1 = (function (){var statearr_55560 = state_55546;
(statearr_55560[(7)] = inst_55541);

return statearr_55560;
})();
var statearr_55561_55575 = state_55546__$1;
(statearr_55561_55575[(2)] = inst_55534);

(statearr_55561_55575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0 = (function (){
var statearr_55562 = [null,null,null,null,null,null,null,null];
(statearr_55562[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__);

(statearr_55562[(1)] = (1));

return statearr_55562;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1 = (function (state_55546){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_55546);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55563){var ex__2730__auto__ = e55563;
var statearr_55564_55576 = state_55546;
(statearr_55564_55576[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_55546[(4)]))){
var statearr_55565_55577 = state_55546;
(statearr_55565_55577[(1)] = cljs.core.first.call(null,(state_55546[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55578 = state_55546;
state_55546 = G__55578;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = function(state_55546){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1.call(this,state_55546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55566 = f__2750__auto__.call(null);
(statearr_55566[(6)] = c__2749__auto__);

return statearr_55566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55605){
var state_val_55606 = (state_55605[(1)]);
if((state_val_55606 === (7))){
var state_55605__$1 = state_55605;
var statearr_55607_55626 = state_55605__$1;
(statearr_55607_55626[(2)] = n);

(statearr_55607_55626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55606 === (1))){
var state_55605__$1 = state_55605;
var statearr_55608_55627 = state_55605__$1;
(statearr_55608_55627[(2)] = null);

(statearr_55608_55627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55606 === (4))){
var inst_55579 = (state_55605[(2)]);
var state_55605__$1 = state_55605;
var statearr_55609_55628 = state_55605__$1;
(statearr_55609_55628[(2)] = inst_55579);

(statearr_55609_55628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55606 === (6))){
var state_55605__$1 = state_55605;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55605__$1,(9),n);
} else {
if((state_val_55606 === (3))){
var inst_55603 = (state_55605[(2)]);
var state_55605__$1 = state_55605;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55605__$1,inst_55603);
} else {
if((state_val_55606 === (2))){
var _ = (function (){var statearr_55611 = state_55605;
(statearr_55611[(4)] = cljs.core.cons.call(null,(5),(state_55605[(4)])));

return statearr_55611;
})();
var inst_55585 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55605__$1 = state_55605;
if(inst_55585){
var statearr_55612_55629 = state_55605__$1;
(statearr_55612_55629[(1)] = (6));

} else {
var statearr_55613_55630 = state_55605__$1;
(statearr_55613_55630[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55606 === (9))){
var inst_55588 = (state_55605[(2)]);
var inst_55589 = fluree.db.util.async.throw_err.call(null,inst_55588);
var state_55605__$1 = state_55605;
var statearr_55614_55631 = state_55605__$1;
(statearr_55614_55631[(2)] = inst_55589);

(statearr_55614_55631[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55606 === (5))){
var _ = (function (){var statearr_55615 = state_55605;
(statearr_55615[(4)] = cljs.core.rest.call(null,(state_55605[(4)])));

return statearr_55615;
})();
var state_55605__$1 = state_55605;
var ex55610 = (state_55605__$1[(2)]);
var statearr_55616_55632 = state_55605__$1;
(statearr_55616_55632[(5)] = ex55610);


if((ex55610 instanceof Error)){
var statearr_55617_55633 = state_55605__$1;
(statearr_55617_55633[(1)] = (4));

(statearr_55617_55633[(5)] = null);

} else {
throw ex55610;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55606 === (8))){
var inst_55592 = (state_55605[(2)]);
var inst_55593 = fluree.db.dbfunctions.internal.dec.call(null,inst_55592);
var inst_55594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55595 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55596 = ["dec",inst_55592,inst_55593];
var inst_55597 = cljs.core.PersistentHashMap.fromArrays(inst_55595,inst_55596);
var inst_55598 = [inst_55597,(10)];
var inst_55599 = (new cljs.core.PersistentVector(null,2,(5),inst_55594,inst_55598,null));
var inst_55600 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55599);
var _ = (function (){var statearr_55618 = state_55605;
(statearr_55618[(4)] = cljs.core.rest.call(null,(state_55605[(4)])));

return statearr_55618;
})();
var state_55605__$1 = (function (){var statearr_55619 = state_55605;
(statearr_55619[(7)] = inst_55600);

return statearr_55619;
})();
var statearr_55620_55634 = state_55605__$1;
(statearr_55620_55634[(2)] = inst_55593);

(statearr_55620_55634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0 = (function (){
var statearr_55621 = [null,null,null,null,null,null,null,null];
(statearr_55621[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__);

(statearr_55621[(1)] = (1));

return statearr_55621;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1 = (function (state_55605){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_55605);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55622){var ex__2730__auto__ = e55622;
var statearr_55623_55635 = state_55605;
(statearr_55623_55635[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_55605[(4)]))){
var statearr_55624_55636 = state_55605;
(statearr_55624_55636[(1)] = cljs.core.first.call(null,(state_55605[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55637 = state_55605;
state_55605 = G__55637;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = function(state_55605){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1.call(this,state_55605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55625 = f__2750__auto__.call(null);
(statearr_55625[(6)] = c__2749__auto__);

return statearr_55625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55687 = arguments.length;
var i__4865__auto___55688 = (0);
while(true){
if((i__4865__auto___55688 < len__4864__auto___55687)){
args__4870__auto__.push((arguments[i__4865__auto___55688]));

var G__55689 = (i__4865__auto___55688 + (1));
i__4865__auto___55688 = G__55689;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55670){
var state_val_55671 = (state_55670[(1)]);
if((state_val_55671 === (1))){
var state_55670__$1 = state_55670;
var statearr_55672_55690 = state_55670__$1;
(statearr_55672_55690[(2)] = null);

(statearr_55672_55690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55671 === (2))){
var _ = (function (){var statearr_55673 = state_55670;
(statearr_55673[(4)] = cljs.core.cons.call(null,(5),(state_55670[(4)])));

return statearr_55673;
})();
var inst_55646 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55670__$1 = state_55670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55670__$1,(6),inst_55646);
} else {
if((state_val_55671 === (3))){
var inst_55668 = (state_55670[(2)]);
var state_55670__$1 = state_55670;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55670__$1,inst_55668);
} else {
if((state_val_55671 === (4))){
var inst_55640 = (state_55670[(2)]);
var state_55670__$1 = state_55670;
var statearr_55675_55691 = state_55670__$1;
(statearr_55675_55691[(2)] = inst_55640);

(statearr_55675_55691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55671 === (5))){
var _ = (function (){var statearr_55676 = state_55670;
(statearr_55676[(4)] = cljs.core.rest.call(null,(state_55670[(4)])));

return statearr_55676;
})();
var state_55670__$1 = state_55670;
var ex55674 = (state_55670__$1[(2)]);
var statearr_55677_55692 = state_55670__$1;
(statearr_55677_55692[(5)] = ex55674);


if((ex55674 instanceof Error)){
var statearr_55678_55693 = state_55670__$1;
(statearr_55678_55693[(1)] = (4));

(statearr_55678_55693[(5)] = null);

} else {
throw ex55674;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55671 === (6))){
var inst_55648 = (state_55670[(2)]);
var inst_55649 = fluree.db.util.async.throw_err.call(null,inst_55648);
var inst_55650 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_55649);
var inst_55651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55652 = [inst_55649];
var inst_55653 = (new cljs.core.PersistentVector(null,1,(5),inst_55651,inst_55652,null));
var inst_55654 = cljs.core.count.call(null,inst_55653);
var inst_55655 = ((9) + inst_55654);
var inst_55656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55657 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55659 = [inst_55649];
var inst_55660 = (new cljs.core.PersistentVector(null,1,(5),inst_55658,inst_55659,null));
var inst_55661 = ["+",inst_55660,inst_55650];
var inst_55662 = cljs.core.PersistentHashMap.fromArrays(inst_55657,inst_55661);
var inst_55663 = [inst_55662,inst_55655];
var inst_55664 = (new cljs.core.PersistentVector(null,2,(5),inst_55656,inst_55663,null));
var inst_55665 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55664);
var _ = (function (){var statearr_55679 = state_55670;
(statearr_55679[(4)] = cljs.core.rest.call(null,(state_55670[(4)])));

return statearr_55679;
})();
var state_55670__$1 = (function (){var statearr_55680 = state_55670;
(statearr_55680[(7)] = inst_55665);

return statearr_55680;
})();
var statearr_55681_55694 = state_55670__$1;
(statearr_55681_55694[(2)] = inst_55650);

(statearr_55681_55694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55682 = [null,null,null,null,null,null,null,null];
(statearr_55682[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55682[(1)] = (1));

return statearr_55682;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55670){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_55670);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55683){var ex__2730__auto__ = e55683;
var statearr_55684_55695 = state_55670;
(statearr_55684_55695[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_55670[(4)]))){
var statearr_55685_55696 = state_55670;
(statearr_55685_55696[(1)] = cljs.core.first.call(null,(state_55670[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55697 = state_55670;
state_55670 = G__55697;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55670){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55686 = f__2750__auto__.call(null);
(statearr_55686[(6)] = c__2749__auto__);

return statearr_55686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq55638){
var G__55639 = cljs.core.first.call(null,seq55638);
var seq55638__$1 = cljs.core.next.call(null,seq55638);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55639,seq55638__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55747 = arguments.length;
var i__4865__auto___55748 = (0);
while(true){
if((i__4865__auto___55748 < len__4864__auto___55747)){
args__4870__auto__.push((arguments[i__4865__auto___55748]));

var G__55749 = (i__4865__auto___55748 + (1));
i__4865__auto___55748 = G__55749;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55730){
var state_val_55731 = (state_55730[(1)]);
if((state_val_55731 === (1))){
var state_55730__$1 = state_55730;
var statearr_55732_55750 = state_55730__$1;
(statearr_55732_55750[(2)] = null);

(statearr_55732_55750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55731 === (2))){
var _ = (function (){var statearr_55733 = state_55730;
(statearr_55733[(4)] = cljs.core.cons.call(null,(5),(state_55730[(4)])));

return statearr_55733;
})();
var inst_55706 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55730__$1 = state_55730;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55730__$1,(6),inst_55706);
} else {
if((state_val_55731 === (3))){
var inst_55728 = (state_55730[(2)]);
var state_55730__$1 = state_55730;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55730__$1,inst_55728);
} else {
if((state_val_55731 === (4))){
var inst_55700 = (state_55730[(2)]);
var state_55730__$1 = state_55730;
var statearr_55735_55751 = state_55730__$1;
(statearr_55735_55751[(2)] = inst_55700);

(statearr_55735_55751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55731 === (5))){
var _ = (function (){var statearr_55736 = state_55730;
(statearr_55736[(4)] = cljs.core.rest.call(null,(state_55730[(4)])));

return statearr_55736;
})();
var state_55730__$1 = state_55730;
var ex55734 = (state_55730__$1[(2)]);
var statearr_55737_55752 = state_55730__$1;
(statearr_55737_55752[(5)] = ex55734);


if((ex55734 instanceof Error)){
var statearr_55738_55753 = state_55730__$1;
(statearr_55738_55753[(1)] = (4));

(statearr_55738_55753[(5)] = null);

} else {
throw ex55734;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55731 === (6))){
var inst_55708 = (state_55730[(2)]);
var inst_55709 = fluree.db.util.async.throw_err.call(null,inst_55708);
var inst_55710 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_55709);
var inst_55711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55712 = [inst_55709];
var inst_55713 = (new cljs.core.PersistentVector(null,1,(5),inst_55711,inst_55712,null));
var inst_55714 = cljs.core.count.call(null,inst_55713);
var inst_55715 = ((9) + inst_55714);
var inst_55716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55717 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55719 = [inst_55709];
var inst_55720 = (new cljs.core.PersistentVector(null,1,(5),inst_55718,inst_55719,null));
var inst_55721 = ["-",inst_55720,inst_55710];
var inst_55722 = cljs.core.PersistentHashMap.fromArrays(inst_55717,inst_55721);
var inst_55723 = [inst_55722,inst_55715];
var inst_55724 = (new cljs.core.PersistentVector(null,2,(5),inst_55716,inst_55723,null));
var inst_55725 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55724);
var _ = (function (){var statearr_55739 = state_55730;
(statearr_55739[(4)] = cljs.core.rest.call(null,(state_55730[(4)])));

return statearr_55739;
})();
var state_55730__$1 = (function (){var statearr_55740 = state_55730;
(statearr_55740[(7)] = inst_55725);

return statearr_55740;
})();
var statearr_55741_55754 = state_55730__$1;
(statearr_55741_55754[(2)] = inst_55710);

(statearr_55741_55754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55742 = [null,null,null,null,null,null,null,null];
(statearr_55742[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55742[(1)] = (1));

return statearr_55742;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55730){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_55730);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55743){var ex__2730__auto__ = e55743;
var statearr_55744_55755 = state_55730;
(statearr_55744_55755[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_55730[(4)]))){
var statearr_55745_55756 = state_55730;
(statearr_55745_55756[(1)] = cljs.core.first.call(null,(state_55730[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55757 = state_55730;
state_55730 = G__55757;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55730){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55746 = f__2750__auto__.call(null);
(statearr_55746[(6)] = c__2749__auto__);

return statearr_55746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq55698){
var G__55699 = cljs.core.first.call(null,seq55698);
var seq55698__$1 = cljs.core.next.call(null,seq55698);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55699,seq55698__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55807 = arguments.length;
var i__4865__auto___55808 = (0);
while(true){
if((i__4865__auto___55808 < len__4864__auto___55807)){
args__4870__auto__.push((arguments[i__4865__auto___55808]));

var G__55809 = (i__4865__auto___55808 + (1));
i__4865__auto___55808 = G__55809;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55790){
var state_val_55791 = (state_55790[(1)]);
if((state_val_55791 === (1))){
var state_55790__$1 = state_55790;
var statearr_55792_55810 = state_55790__$1;
(statearr_55792_55810[(2)] = null);

(statearr_55792_55810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55791 === (2))){
var _ = (function (){var statearr_55793 = state_55790;
(statearr_55793[(4)] = cljs.core.cons.call(null,(5),(state_55790[(4)])));

return statearr_55793;
})();
var inst_55766 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55790__$1 = state_55790;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55790__$1,(6),inst_55766);
} else {
if((state_val_55791 === (3))){
var inst_55788 = (state_55790[(2)]);
var state_55790__$1 = state_55790;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55790__$1,inst_55788);
} else {
if((state_val_55791 === (4))){
var inst_55760 = (state_55790[(2)]);
var state_55790__$1 = state_55790;
var statearr_55795_55811 = state_55790__$1;
(statearr_55795_55811[(2)] = inst_55760);

(statearr_55795_55811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55791 === (5))){
var _ = (function (){var statearr_55796 = state_55790;
(statearr_55796[(4)] = cljs.core.rest.call(null,(state_55790[(4)])));

return statearr_55796;
})();
var state_55790__$1 = state_55790;
var ex55794 = (state_55790__$1[(2)]);
var statearr_55797_55812 = state_55790__$1;
(statearr_55797_55812[(5)] = ex55794);


if((ex55794 instanceof Error)){
var statearr_55798_55813 = state_55790__$1;
(statearr_55798_55813[(1)] = (4));

(statearr_55798_55813[(5)] = null);

} else {
throw ex55794;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55791 === (6))){
var inst_55768 = (state_55790[(2)]);
var inst_55769 = fluree.db.util.async.throw_err.call(null,inst_55768);
var inst_55770 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_55769);
var inst_55771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55772 = [inst_55769];
var inst_55773 = (new cljs.core.PersistentVector(null,1,(5),inst_55771,inst_55772,null));
var inst_55774 = cljs.core.count.call(null,inst_55773);
var inst_55775 = ((9) + inst_55774);
var inst_55776 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55777 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55779 = [inst_55769];
var inst_55780 = (new cljs.core.PersistentVector(null,1,(5),inst_55778,inst_55779,null));
var inst_55781 = ["*",inst_55780,inst_55770];
var inst_55782 = cljs.core.PersistentHashMap.fromArrays(inst_55777,inst_55781);
var inst_55783 = [inst_55782,inst_55775];
var inst_55784 = (new cljs.core.PersistentVector(null,2,(5),inst_55776,inst_55783,null));
var inst_55785 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55784);
var _ = (function (){var statearr_55799 = state_55790;
(statearr_55799[(4)] = cljs.core.rest.call(null,(state_55790[(4)])));

return statearr_55799;
})();
var state_55790__$1 = (function (){var statearr_55800 = state_55790;
(statearr_55800[(7)] = inst_55785);

return statearr_55800;
})();
var statearr_55801_55814 = state_55790__$1;
(statearr_55801_55814[(2)] = inst_55770);

(statearr_55801_55814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55802 = [null,null,null,null,null,null,null,null];
(statearr_55802[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55802[(1)] = (1));

return statearr_55802;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55790){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_55790);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55803){var ex__2730__auto__ = e55803;
var statearr_55804_55815 = state_55790;
(statearr_55804_55815[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_55790[(4)]))){
var statearr_55805_55816 = state_55790;
(statearr_55805_55816[(1)] = cljs.core.first.call(null,(state_55790[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55817 = state_55790;
state_55790 = G__55817;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55790){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55790);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55806 = f__2750__auto__.call(null);
(statearr_55806[(6)] = c__2749__auto__);

return statearr_55806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq55758){
var G__55759 = cljs.core.first.call(null,seq55758);
var seq55758__$1 = cljs.core.next.call(null,seq55758);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55759,seq55758__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55867 = arguments.length;
var i__4865__auto___55868 = (0);
while(true){
if((i__4865__auto___55868 < len__4864__auto___55867)){
args__4870__auto__.push((arguments[i__4865__auto___55868]));

var G__55869 = (i__4865__auto___55868 + (1));
i__4865__auto___55868 = G__55869;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55850){
var state_val_55851 = (state_55850[(1)]);
if((state_val_55851 === (1))){
var state_55850__$1 = state_55850;
var statearr_55852_55870 = state_55850__$1;
(statearr_55852_55870[(2)] = null);

(statearr_55852_55870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55851 === (2))){
var _ = (function (){var statearr_55853 = state_55850;
(statearr_55853[(4)] = cljs.core.cons.call(null,(5),(state_55850[(4)])));

return statearr_55853;
})();
var inst_55826 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55850__$1 = state_55850;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55850__$1,(6),inst_55826);
} else {
if((state_val_55851 === (3))){
var inst_55848 = (state_55850[(2)]);
var state_55850__$1 = state_55850;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55850__$1,inst_55848);
} else {
if((state_val_55851 === (4))){
var inst_55820 = (state_55850[(2)]);
var state_55850__$1 = state_55850;
var statearr_55855_55871 = state_55850__$1;
(statearr_55855_55871[(2)] = inst_55820);

(statearr_55855_55871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55851 === (5))){
var _ = (function (){var statearr_55856 = state_55850;
(statearr_55856[(4)] = cljs.core.rest.call(null,(state_55850[(4)])));

return statearr_55856;
})();
var state_55850__$1 = state_55850;
var ex55854 = (state_55850__$1[(2)]);
var statearr_55857_55872 = state_55850__$1;
(statearr_55857_55872[(5)] = ex55854);


if((ex55854 instanceof Error)){
var statearr_55858_55873 = state_55850__$1;
(statearr_55858_55873[(1)] = (4));

(statearr_55858_55873[(5)] = null);

} else {
throw ex55854;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55851 === (6))){
var inst_55828 = (state_55850[(2)]);
var inst_55829 = fluree.db.util.async.throw_err.call(null,inst_55828);
var inst_55830 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_55829);
var inst_55831 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55832 = [inst_55829];
var inst_55833 = (new cljs.core.PersistentVector(null,1,(5),inst_55831,inst_55832,null));
var inst_55834 = cljs.core.count.call(null,inst_55833);
var inst_55835 = ((9) + inst_55834);
var inst_55836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55837 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55839 = [inst_55829];
var inst_55840 = (new cljs.core.PersistentVector(null,1,(5),inst_55838,inst_55839,null));
var inst_55841 = ["/",inst_55840,inst_55830];
var inst_55842 = cljs.core.PersistentHashMap.fromArrays(inst_55837,inst_55841);
var inst_55843 = [inst_55842,inst_55835];
var inst_55844 = (new cljs.core.PersistentVector(null,2,(5),inst_55836,inst_55843,null));
var inst_55845 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55844);
var _ = (function (){var statearr_55859 = state_55850;
(statearr_55859[(4)] = cljs.core.rest.call(null,(state_55850[(4)])));

return statearr_55859;
})();
var state_55850__$1 = (function (){var statearr_55860 = state_55850;
(statearr_55860[(7)] = inst_55845);

return statearr_55860;
})();
var statearr_55861_55874 = state_55850__$1;
(statearr_55861_55874[(2)] = inst_55830);

(statearr_55861_55874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55862 = [null,null,null,null,null,null,null,null];
(statearr_55862[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55862[(1)] = (1));

return statearr_55862;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55850){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_55850);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55863){var ex__2730__auto__ = e55863;
var statearr_55864_55875 = state_55850;
(statearr_55864_55875[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_55850[(4)]))){
var statearr_55865_55876 = state_55850;
(statearr_55865_55876[(1)] = cljs.core.first.call(null,(state_55850[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55877 = state_55850;
state_55850 = G__55877;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55850){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55866 = f__2750__auto__.call(null);
(statearr_55866[(6)] = c__2749__auto__);

return statearr_55866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq55818){
var G__55819 = cljs.core.first.call(null,seq55818);
var seq55818__$1 = cljs.core.next.call(null,seq55818);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55819,seq55818__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55915){
var state_val_55916 = (state_55915[(1)]);
if((state_val_55916 === (7))){
var state_55915__$1 = state_55915;
var statearr_55917_55941 = state_55915__$1;
(statearr_55917_55941[(2)] = n);

(statearr_55917_55941[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55916 === (1))){
var state_55915__$1 = state_55915;
var statearr_55918_55942 = state_55915__$1;
(statearr_55918_55942[(2)] = null);

(statearr_55918_55942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55916 === (4))){
var inst_55878 = (state_55915[(2)]);
var state_55915__$1 = state_55915;
var statearr_55919_55943 = state_55915__$1;
(statearr_55919_55943[(2)] = inst_55878);

(statearr_55919_55943[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55916 === (13))){
var inst_55895 = (state_55915[(2)]);
var inst_55896 = fluree.db.util.async.throw_err.call(null,inst_55895);
var state_55915__$1 = state_55915;
var statearr_55920_55944 = state_55915__$1;
(statearr_55920_55944[(2)] = inst_55896);

(statearr_55920_55944[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55916 === (6))){
var state_55915__$1 = state_55915;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55915__$1,(9),n);
} else {
if((state_val_55916 === (3))){
var inst_55913 = (state_55915[(2)]);
var state_55915__$1 = state_55915;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55915__$1,inst_55913);
} else {
if((state_val_55916 === (12))){
var inst_55891 = (state_55915[(7)]);
var inst_55899 = (state_55915[(2)]);
var inst_55900 = fluree.db.dbfunctions.internal.quot.call(null,inst_55891,inst_55899);
var inst_55901 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55902 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55904 = [inst_55891,inst_55899];
var inst_55905 = (new cljs.core.PersistentVector(null,2,(5),inst_55903,inst_55904,null));
var inst_55906 = ["quot",inst_55905,inst_55900];
var inst_55907 = cljs.core.PersistentHashMap.fromArrays(inst_55902,inst_55906);
var inst_55908 = [inst_55907,(2)];
var inst_55909 = (new cljs.core.PersistentVector(null,2,(5),inst_55901,inst_55908,null));
var inst_55910 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55909);
var _ = (function (){var statearr_55921 = state_55915;
(statearr_55921[(4)] = cljs.core.rest.call(null,(state_55915[(4)])));

return statearr_55921;
})();
var state_55915__$1 = (function (){var statearr_55922 = state_55915;
(statearr_55922[(8)] = inst_55910);

return statearr_55922;
})();
var statearr_55923_55945 = state_55915__$1;
(statearr_55923_55945[(2)] = inst_55900);

(statearr_55923_55945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55916 === (2))){
var _ = (function (){var statearr_55924 = state_55915;
(statearr_55924[(4)] = cljs.core.cons.call(null,(5),(state_55915[(4)])));

return statearr_55924;
})();
var inst_55884 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55915__$1 = state_55915;
if(inst_55884){
var statearr_55925_55946 = state_55915__$1;
(statearr_55925_55946[(1)] = (6));

} else {
var statearr_55926_55947 = state_55915__$1;
(statearr_55926_55947[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55916 === (11))){
var state_55915__$1 = state_55915;
var statearr_55928_55948 = state_55915__$1;
(statearr_55928_55948[(2)] = d);

(statearr_55928_55948[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55916 === (9))){
var inst_55887 = (state_55915[(2)]);
var inst_55888 = fluree.db.util.async.throw_err.call(null,inst_55887);
var state_55915__$1 = state_55915;
var statearr_55929_55949 = state_55915__$1;
(statearr_55929_55949[(2)] = inst_55888);

(statearr_55929_55949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55916 === (5))){
var _ = (function (){var statearr_55930 = state_55915;
(statearr_55930[(4)] = cljs.core.rest.call(null,(state_55915[(4)])));

return statearr_55930;
})();
var state_55915__$1 = state_55915;
var ex55927 = (state_55915__$1[(2)]);
var statearr_55931_55950 = state_55915__$1;
(statearr_55931_55950[(5)] = ex55927);


if((ex55927 instanceof Error)){
var statearr_55932_55951 = state_55915__$1;
(statearr_55932_55951[(1)] = (4));

(statearr_55932_55951[(5)] = null);

} else {
throw ex55927;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55916 === (10))){
var state_55915__$1 = state_55915;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55915__$1,(13),d);
} else {
if((state_val_55916 === (8))){
var inst_55891 = (state_55915[(2)]);
var inst_55892 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_55915__$1 = (function (){var statearr_55933 = state_55915;
(statearr_55933[(7)] = inst_55891);

return statearr_55933;
})();
if(inst_55892){
var statearr_55934_55952 = state_55915__$1;
(statearr_55934_55952[(1)] = (10));

} else {
var statearr_55935_55953 = state_55915__$1;
(statearr_55935_55953[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0 = (function (){
var statearr_55936 = [null,null,null,null,null,null,null,null,null];
(statearr_55936[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__);

(statearr_55936[(1)] = (1));

return statearr_55936;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1 = (function (state_55915){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_55915);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55937){var ex__2730__auto__ = e55937;
var statearr_55938_55954 = state_55915;
(statearr_55938_55954[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_55915[(4)]))){
var statearr_55939_55955 = state_55915;
(statearr_55939_55955[(1)] = cljs.core.first.call(null,(state_55915[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55956 = state_55915;
state_55915 = G__55956;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = function(state_55915){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1.call(this,state_55915);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55940 = f__2750__auto__.call(null);
(statearr_55940[(6)] = c__2749__auto__);

return statearr_55940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55994){
var state_val_55995 = (state_55994[(1)]);
if((state_val_55995 === (7))){
var state_55994__$1 = state_55994;
var statearr_55996_56020 = state_55994__$1;
(statearr_55996_56020[(2)] = n);

(statearr_55996_56020[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55995 === (1))){
var state_55994__$1 = state_55994;
var statearr_55997_56021 = state_55994__$1;
(statearr_55997_56021[(2)] = null);

(statearr_55997_56021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55995 === (4))){
var inst_55957 = (state_55994[(2)]);
var state_55994__$1 = state_55994;
var statearr_55998_56022 = state_55994__$1;
(statearr_55998_56022[(2)] = inst_55957);

(statearr_55998_56022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55995 === (13))){
var inst_55974 = (state_55994[(2)]);
var inst_55975 = fluree.db.util.async.throw_err.call(null,inst_55974);
var state_55994__$1 = state_55994;
var statearr_55999_56023 = state_55994__$1;
(statearr_55999_56023[(2)] = inst_55975);

(statearr_55999_56023[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55995 === (6))){
var state_55994__$1 = state_55994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55994__$1,(9),n);
} else {
if((state_val_55995 === (3))){
var inst_55992 = (state_55994[(2)]);
var state_55994__$1 = state_55994;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55994__$1,inst_55992);
} else {
if((state_val_55995 === (12))){
var inst_55970 = (state_55994[(7)]);
var inst_55978 = (state_55994[(2)]);
var inst_55979 = fluree.db.dbfunctions.internal.mod.call(null,inst_55970,inst_55978);
var inst_55980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55981 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55983 = [inst_55970,inst_55978];
var inst_55984 = (new cljs.core.PersistentVector(null,2,(5),inst_55982,inst_55983,null));
var inst_55985 = ["mod",inst_55984,inst_55979];
var inst_55986 = cljs.core.PersistentHashMap.fromArrays(inst_55981,inst_55985);
var inst_55987 = [inst_55986,(2)];
var inst_55988 = (new cljs.core.PersistentVector(null,2,(5),inst_55980,inst_55987,null));
var inst_55989 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55988);
var _ = (function (){var statearr_56000 = state_55994;
(statearr_56000[(4)] = cljs.core.rest.call(null,(state_55994[(4)])));

return statearr_56000;
})();
var state_55994__$1 = (function (){var statearr_56001 = state_55994;
(statearr_56001[(8)] = inst_55989);

return statearr_56001;
})();
var statearr_56002_56024 = state_55994__$1;
(statearr_56002_56024[(2)] = inst_55979);

(statearr_56002_56024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55995 === (2))){
var _ = (function (){var statearr_56003 = state_55994;
(statearr_56003[(4)] = cljs.core.cons.call(null,(5),(state_55994[(4)])));

return statearr_56003;
})();
var inst_55963 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55994__$1 = state_55994;
if(inst_55963){
var statearr_56004_56025 = state_55994__$1;
(statearr_56004_56025[(1)] = (6));

} else {
var statearr_56005_56026 = state_55994__$1;
(statearr_56005_56026[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55995 === (11))){
var state_55994__$1 = state_55994;
var statearr_56007_56027 = state_55994__$1;
(statearr_56007_56027[(2)] = d);

(statearr_56007_56027[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55995 === (9))){
var inst_55966 = (state_55994[(2)]);
var inst_55967 = fluree.db.util.async.throw_err.call(null,inst_55966);
var state_55994__$1 = state_55994;
var statearr_56008_56028 = state_55994__$1;
(statearr_56008_56028[(2)] = inst_55967);

(statearr_56008_56028[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55995 === (5))){
var _ = (function (){var statearr_56009 = state_55994;
(statearr_56009[(4)] = cljs.core.rest.call(null,(state_55994[(4)])));

return statearr_56009;
})();
var state_55994__$1 = state_55994;
var ex56006 = (state_55994__$1[(2)]);
var statearr_56010_56029 = state_55994__$1;
(statearr_56010_56029[(5)] = ex56006);


if((ex56006 instanceof Error)){
var statearr_56011_56030 = state_55994__$1;
(statearr_56011_56030[(1)] = (4));

(statearr_56011_56030[(5)] = null);

} else {
throw ex56006;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55995 === (10))){
var state_55994__$1 = state_55994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55994__$1,(13),d);
} else {
if((state_val_55995 === (8))){
var inst_55970 = (state_55994[(2)]);
var inst_55971 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_55994__$1 = (function (){var statearr_56012 = state_55994;
(statearr_56012[(7)] = inst_55970);

return statearr_56012;
})();
if(inst_55971){
var statearr_56013_56031 = state_55994__$1;
(statearr_56013_56031[(1)] = (10));

} else {
var statearr_56014_56032 = state_55994__$1;
(statearr_56014_56032[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0 = (function (){
var statearr_56015 = [null,null,null,null,null,null,null,null,null];
(statearr_56015[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__);

(statearr_56015[(1)] = (1));

return statearr_56015;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1 = (function (state_55994){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_55994);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56016){var ex__2730__auto__ = e56016;
var statearr_56017_56033 = state_55994;
(statearr_56017_56033[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_55994[(4)]))){
var statearr_56018_56034 = state_55994;
(statearr_56018_56034[(1)] = cljs.core.first.call(null,(state_55994[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56035 = state_55994;
state_55994 = G__56035;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = function(state_55994){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1.call(this,state_55994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56019 = f__2750__auto__.call(null);
(statearr_56019[(6)] = c__2749__auto__);

return statearr_56019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56073){
var state_val_56074 = (state_56073[(1)]);
if((state_val_56074 === (7))){
var state_56073__$1 = state_56073;
var statearr_56075_56099 = state_56073__$1;
(statearr_56075_56099[(2)] = n);

(statearr_56075_56099[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (1))){
var state_56073__$1 = state_56073;
var statearr_56076_56100 = state_56073__$1;
(statearr_56076_56100[(2)] = null);

(statearr_56076_56100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (4))){
var inst_56036 = (state_56073[(2)]);
var state_56073__$1 = state_56073;
var statearr_56077_56101 = state_56073__$1;
(statearr_56077_56101[(2)] = inst_56036);

(statearr_56077_56101[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (13))){
var inst_56053 = (state_56073[(2)]);
var inst_56054 = fluree.db.util.async.throw_err.call(null,inst_56053);
var state_56073__$1 = state_56073;
var statearr_56078_56102 = state_56073__$1;
(statearr_56078_56102[(2)] = inst_56054);

(statearr_56078_56102[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (6))){
var state_56073__$1 = state_56073;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56073__$1,(9),n);
} else {
if((state_val_56074 === (3))){
var inst_56071 = (state_56073[(2)]);
var state_56073__$1 = state_56073;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56073__$1,inst_56071);
} else {
if((state_val_56074 === (12))){
var inst_56049 = (state_56073[(7)]);
var inst_56057 = (state_56073[(2)]);
var inst_56058 = fluree.db.dbfunctions.internal.rem.call(null,inst_56049,inst_56057);
var inst_56059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56060 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56062 = [inst_56049,inst_56057];
var inst_56063 = (new cljs.core.PersistentVector(null,2,(5),inst_56061,inst_56062,null));
var inst_56064 = ["rem",inst_56063,inst_56058];
var inst_56065 = cljs.core.PersistentHashMap.fromArrays(inst_56060,inst_56064);
var inst_56066 = [inst_56065,(2)];
var inst_56067 = (new cljs.core.PersistentVector(null,2,(5),inst_56059,inst_56066,null));
var inst_56068 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56067);
var _ = (function (){var statearr_56079 = state_56073;
(statearr_56079[(4)] = cljs.core.rest.call(null,(state_56073[(4)])));

return statearr_56079;
})();
var state_56073__$1 = (function (){var statearr_56080 = state_56073;
(statearr_56080[(8)] = inst_56068);

return statearr_56080;
})();
var statearr_56081_56103 = state_56073__$1;
(statearr_56081_56103[(2)] = inst_56058);

(statearr_56081_56103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (2))){
var _ = (function (){var statearr_56082 = state_56073;
(statearr_56082[(4)] = cljs.core.cons.call(null,(5),(state_56073[(4)])));

return statearr_56082;
})();
var inst_56042 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56073__$1 = state_56073;
if(inst_56042){
var statearr_56083_56104 = state_56073__$1;
(statearr_56083_56104[(1)] = (6));

} else {
var statearr_56084_56105 = state_56073__$1;
(statearr_56084_56105[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (11))){
var state_56073__$1 = state_56073;
var statearr_56086_56106 = state_56073__$1;
(statearr_56086_56106[(2)] = d);

(statearr_56086_56106[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (9))){
var inst_56045 = (state_56073[(2)]);
var inst_56046 = fluree.db.util.async.throw_err.call(null,inst_56045);
var state_56073__$1 = state_56073;
var statearr_56087_56107 = state_56073__$1;
(statearr_56087_56107[(2)] = inst_56046);

(statearr_56087_56107[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (5))){
var _ = (function (){var statearr_56088 = state_56073;
(statearr_56088[(4)] = cljs.core.rest.call(null,(state_56073[(4)])));

return statearr_56088;
})();
var state_56073__$1 = state_56073;
var ex56085 = (state_56073__$1[(2)]);
var statearr_56089_56108 = state_56073__$1;
(statearr_56089_56108[(5)] = ex56085);


if((ex56085 instanceof Error)){
var statearr_56090_56109 = state_56073__$1;
(statearr_56090_56109[(1)] = (4));

(statearr_56090_56109[(5)] = null);

} else {
throw ex56085;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (10))){
var state_56073__$1 = state_56073;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56073__$1,(13),d);
} else {
if((state_val_56074 === (8))){
var inst_56049 = (state_56073[(2)]);
var inst_56050 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_56073__$1 = (function (){var statearr_56091 = state_56073;
(statearr_56091[(7)] = inst_56049);

return statearr_56091;
})();
if(inst_56050){
var statearr_56092_56110 = state_56073__$1;
(statearr_56092_56110[(1)] = (10));

} else {
var statearr_56093_56111 = state_56073__$1;
(statearr_56093_56111[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0 = (function (){
var statearr_56094 = [null,null,null,null,null,null,null,null,null];
(statearr_56094[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__);

(statearr_56094[(1)] = (1));

return statearr_56094;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1 = (function (state_56073){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_56073);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56095){var ex__2730__auto__ = e56095;
var statearr_56096_56112 = state_56073;
(statearr_56096_56112[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_56073[(4)]))){
var statearr_56097_56113 = state_56073;
(statearr_56097_56113[(1)] = cljs.core.first.call(null,(state_56073[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56114 = state_56073;
state_56073 = G__56114;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = function(state_56073){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1.call(this,state_56073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56098 = f__2750__auto__.call(null);
(statearr_56098[(6)] = c__2749__auto__);

return statearr_56098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56141){
var state_val_56142 = (state_56141[(1)]);
if((state_val_56142 === (7))){
var state_56141__$1 = state_56141;
var statearr_56143_56162 = state_56141__$1;
(statearr_56143_56162[(2)] = x);

(statearr_56143_56162[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56142 === (1))){
var state_56141__$1 = state_56141;
var statearr_56144_56163 = state_56141__$1;
(statearr_56144_56163[(2)] = null);

(statearr_56144_56163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56142 === (4))){
var inst_56115 = (state_56141[(2)]);
var state_56141__$1 = state_56141;
var statearr_56145_56164 = state_56141__$1;
(statearr_56145_56164[(2)] = inst_56115);

(statearr_56145_56164[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56142 === (6))){
var state_56141__$1 = state_56141;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56141__$1,(9),x);
} else {
if((state_val_56142 === (3))){
var inst_56139 = (state_56141[(2)]);
var state_56141__$1 = state_56141;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56141__$1,inst_56139);
} else {
if((state_val_56142 === (2))){
var _ = (function (){var statearr_56147 = state_56141;
(statearr_56147[(4)] = cljs.core.cons.call(null,(5),(state_56141[(4)])));

return statearr_56147;
})();
var inst_56121 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_56141__$1 = state_56141;
if(inst_56121){
var statearr_56148_56165 = state_56141__$1;
(statearr_56148_56165[(1)] = (6));

} else {
var statearr_56149_56166 = state_56141__$1;
(statearr_56149_56166[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56142 === (9))){
var inst_56124 = (state_56141[(2)]);
var inst_56125 = fluree.db.util.async.throw_err.call(null,inst_56124);
var state_56141__$1 = state_56141;
var statearr_56150_56167 = state_56141__$1;
(statearr_56150_56167[(2)] = inst_56125);

(statearr_56150_56167[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56142 === (5))){
var _ = (function (){var statearr_56151 = state_56141;
(statearr_56151[(4)] = cljs.core.rest.call(null,(state_56141[(4)])));

return statearr_56151;
})();
var state_56141__$1 = state_56141;
var ex56146 = (state_56141__$1[(2)]);
var statearr_56152_56168 = state_56141__$1;
(statearr_56152_56168[(5)] = ex56146);


if((ex56146 instanceof Error)){
var statearr_56153_56169 = state_56141__$1;
(statearr_56153_56169[(1)] = (4));

(statearr_56153_56169[(5)] = null);

} else {
throw ex56146;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56142 === (8))){
var inst_56128 = (state_56141[(2)]);
var inst_56129 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_56128);
var inst_56130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56131 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56132 = ["boolean",inst_56128,inst_56129];
var inst_56133 = cljs.core.PersistentHashMap.fromArrays(inst_56131,inst_56132);
var inst_56134 = [inst_56133,(10)];
var inst_56135 = (new cljs.core.PersistentVector(null,2,(5),inst_56130,inst_56134,null));
var inst_56136 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56135);
var _ = (function (){var statearr_56154 = state_56141;
(statearr_56154[(4)] = cljs.core.rest.call(null,(state_56141[(4)])));

return statearr_56154;
})();
var state_56141__$1 = (function (){var statearr_56155 = state_56141;
(statearr_56155[(7)] = inst_56136);

return statearr_56155;
})();
var statearr_56156_56170 = state_56141__$1;
(statearr_56156_56170[(2)] = inst_56129);

(statearr_56156_56170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0 = (function (){
var statearr_56157 = [null,null,null,null,null,null,null,null];
(statearr_56157[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__);

(statearr_56157[(1)] = (1));

return statearr_56157;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1 = (function (state_56141){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_56141);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56158){var ex__2730__auto__ = e56158;
var statearr_56159_56171 = state_56141;
(statearr_56159_56171[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_56141[(4)]))){
var statearr_56160_56172 = state_56141;
(statearr_56160_56172[(1)] = cljs.core.first.call(null,(state_56141[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56173 = state_56141;
state_56141 = G__56173;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = function(state_56141){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1.call(this,state_56141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56161 = f__2750__auto__.call(null);
(statearr_56161[(6)] = c__2749__auto__);

return statearr_56161;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56211){
var state_val_56212 = (state_56211[(1)]);
if((state_val_56212 === (7))){
var state_56211__$1 = state_56211;
var statearr_56213_56237 = state_56211__$1;
(statearr_56213_56237[(2)] = pattern);

(statearr_56213_56237[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (1))){
var state_56211__$1 = state_56211;
var statearr_56214_56238 = state_56211__$1;
(statearr_56214_56238[(2)] = null);

(statearr_56214_56238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (4))){
var inst_56174 = (state_56211[(2)]);
var state_56211__$1 = state_56211;
var statearr_56215_56239 = state_56211__$1;
(statearr_56215_56239[(2)] = inst_56174);

(statearr_56215_56239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (13))){
var inst_56191 = (state_56211[(2)]);
var inst_56192 = fluree.db.util.async.throw_err.call(null,inst_56191);
var state_56211__$1 = state_56211;
var statearr_56216_56240 = state_56211__$1;
(statearr_56216_56240[(2)] = inst_56192);

(statearr_56216_56240[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (6))){
var state_56211__$1 = state_56211;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56211__$1,(9),pattern);
} else {
if((state_val_56212 === (3))){
var inst_56209 = (state_56211[(2)]);
var state_56211__$1 = state_56211;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56211__$1,inst_56209);
} else {
if((state_val_56212 === (12))){
var inst_56187 = (state_56211[(7)]);
var inst_56195 = (state_56211[(2)]);
var inst_56196 = fluree.db.dbfunctions.internal.re_find.call(null,inst_56187,inst_56195);
var inst_56197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56198 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56200 = [inst_56187,inst_56195];
var inst_56201 = (new cljs.core.PersistentVector(null,2,(5),inst_56199,inst_56200,null));
var inst_56202 = ["re-find",inst_56201,inst_56196];
var inst_56203 = cljs.core.PersistentHashMap.fromArrays(inst_56198,inst_56202);
var inst_56204 = [inst_56203,(10)];
var inst_56205 = (new cljs.core.PersistentVector(null,2,(5),inst_56197,inst_56204,null));
var inst_56206 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56205);
var _ = (function (){var statearr_56217 = state_56211;
(statearr_56217[(4)] = cljs.core.rest.call(null,(state_56211[(4)])));

return statearr_56217;
})();
var state_56211__$1 = (function (){var statearr_56218 = state_56211;
(statearr_56218[(8)] = inst_56206);

return statearr_56218;
})();
var statearr_56219_56241 = state_56211__$1;
(statearr_56219_56241[(2)] = inst_56196);

(statearr_56219_56241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (2))){
var _ = (function (){var statearr_56220 = state_56211;
(statearr_56220[(4)] = cljs.core.cons.call(null,(5),(state_56211[(4)])));

return statearr_56220;
})();
var inst_56180 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_56211__$1 = state_56211;
if(inst_56180){
var statearr_56221_56242 = state_56211__$1;
(statearr_56221_56242[(1)] = (6));

} else {
var statearr_56222_56243 = state_56211__$1;
(statearr_56222_56243[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (11))){
var state_56211__$1 = state_56211;
var statearr_56224_56244 = state_56211__$1;
(statearr_56224_56244[(2)] = string);

(statearr_56224_56244[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (9))){
var inst_56183 = (state_56211[(2)]);
var inst_56184 = fluree.db.util.async.throw_err.call(null,inst_56183);
var state_56211__$1 = state_56211;
var statearr_56225_56245 = state_56211__$1;
(statearr_56225_56245[(2)] = inst_56184);

(statearr_56225_56245[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (5))){
var _ = (function (){var statearr_56226 = state_56211;
(statearr_56226[(4)] = cljs.core.rest.call(null,(state_56211[(4)])));

return statearr_56226;
})();
var state_56211__$1 = state_56211;
var ex56223 = (state_56211__$1[(2)]);
var statearr_56227_56246 = state_56211__$1;
(statearr_56227_56246[(5)] = ex56223);


if((ex56223 instanceof Error)){
var statearr_56228_56247 = state_56211__$1;
(statearr_56228_56247[(1)] = (4));

(statearr_56228_56247[(5)] = null);

} else {
throw ex56223;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (10))){
var state_56211__$1 = state_56211;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56211__$1,(13),string);
} else {
if((state_val_56212 === (8))){
var inst_56187 = (state_56211[(2)]);
var inst_56188 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_56211__$1 = (function (){var statearr_56229 = state_56211;
(statearr_56229[(7)] = inst_56187);

return statearr_56229;
})();
if(inst_56188){
var statearr_56230_56248 = state_56211__$1;
(statearr_56230_56248[(1)] = (10));

} else {
var statearr_56231_56249 = state_56211__$1;
(statearr_56231_56249[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0 = (function (){
var statearr_56232 = [null,null,null,null,null,null,null,null,null];
(statearr_56232[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__);

(statearr_56232[(1)] = (1));

return statearr_56232;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1 = (function (state_56211){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_56211);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56233){var ex__2730__auto__ = e56233;
var statearr_56234_56250 = state_56211;
(statearr_56234_56250[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_56211[(4)]))){
var statearr_56235_56251 = state_56211;
(statearr_56235_56251[(1)] = cljs.core.first.call(null,(state_56211[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56252 = state_56211;
state_56211 = G__56252;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = function(state_56211){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1.call(this,state_56211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56236 = f__2750__auto__.call(null);
(statearr_56236[(6)] = c__2749__auto__);

return statearr_56236;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56279){
var state_val_56280 = (state_56279[(1)]);
if((state_val_56280 === (7))){
var state_56279__$1 = state_56279;
var statearr_56281_56300 = state_56279__$1;
(statearr_56281_56300[(2)] = email);

(statearr_56281_56300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (1))){
var state_56279__$1 = state_56279;
var statearr_56282_56301 = state_56279__$1;
(statearr_56282_56301[(2)] = null);

(statearr_56282_56301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (4))){
var inst_56253 = (state_56279[(2)]);
var state_56279__$1 = state_56279;
var statearr_56283_56302 = state_56279__$1;
(statearr_56283_56302[(2)] = inst_56253);

(statearr_56283_56302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (6))){
var state_56279__$1 = state_56279;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56279__$1,(9),email);
} else {
if((state_val_56280 === (3))){
var inst_56277 = (state_56279[(2)]);
var state_56279__$1 = state_56279;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56279__$1,inst_56277);
} else {
if((state_val_56280 === (2))){
var _ = (function (){var statearr_56285 = state_56279;
(statearr_56285[(4)] = cljs.core.cons.call(null,(5),(state_56279[(4)])));

return statearr_56285;
})();
var inst_56259 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_56279__$1 = state_56279;
if(inst_56259){
var statearr_56286_56303 = state_56279__$1;
(statearr_56286_56303[(1)] = (6));

} else {
var statearr_56287_56304 = state_56279__$1;
(statearr_56287_56304[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (9))){
var inst_56262 = (state_56279[(2)]);
var inst_56263 = fluree.db.util.async.throw_err.call(null,inst_56262);
var state_56279__$1 = state_56279;
var statearr_56288_56305 = state_56279__$1;
(statearr_56288_56305[(2)] = inst_56263);

(statearr_56288_56305[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (5))){
var _ = (function (){var statearr_56289 = state_56279;
(statearr_56289[(4)] = cljs.core.rest.call(null,(state_56279[(4)])));

return statearr_56289;
})();
var state_56279__$1 = state_56279;
var ex56284 = (state_56279__$1[(2)]);
var statearr_56290_56306 = state_56279__$1;
(statearr_56290_56306[(5)] = ex56284);


if((ex56284 instanceof Error)){
var statearr_56291_56307 = state_56279__$1;
(statearr_56291_56307[(1)] = (4));

(statearr_56291_56307[(5)] = null);

} else {
throw ex56284;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56280 === (8))){
var inst_56266 = (state_56279[(2)]);
var inst_56267 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_56266);
var inst_56268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56269 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56270 = ["re-find",inst_56266,inst_56267];
var inst_56271 = cljs.core.PersistentHashMap.fromArrays(inst_56269,inst_56270);
var inst_56272 = [inst_56271,(10)];
var inst_56273 = (new cljs.core.PersistentVector(null,2,(5),inst_56268,inst_56272,null));
var inst_56274 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56273);
var _ = (function (){var statearr_56292 = state_56279;
(statearr_56292[(4)] = cljs.core.rest.call(null,(state_56279[(4)])));

return statearr_56292;
})();
var state_56279__$1 = (function (){var statearr_56293 = state_56279;
(statearr_56293[(7)] = inst_56274);

return statearr_56293;
})();
var statearr_56294_56308 = state_56279__$1;
(statearr_56294_56308[(2)] = inst_56267);

(statearr_56294_56308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_56295 = [null,null,null,null,null,null,null,null];
(statearr_56295[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__);

(statearr_56295[(1)] = (1));

return statearr_56295;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1 = (function (state_56279){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_56279);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56296){var ex__2730__auto__ = e56296;
var statearr_56297_56309 = state_56279;
(statearr_56297_56309[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_56279[(4)]))){
var statearr_56298_56310 = state_56279;
(statearr_56298_56310[(1)] = cljs.core.first.call(null,(state_56279[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56311 = state_56279;
state_56279 = G__56311;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = function(state_56279){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1.call(this,state_56279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56299 = f__2750__auto__.call(null);
(statearr_56299[(6)] = c__2749__auto__);

return statearr_56299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56358){
var state_val_56359 = (state_56358[(1)]);
if((state_val_56359 === (7))){
var inst_56328 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56358__$1 = state_56358;
if(cljs.core.truth_(inst_56328)){
var statearr_56360_56387 = state_56358__$1;
(statearr_56360_56387[(1)] = (9));

} else {
var statearr_56361_56388 = state_56358__$1;
(statearr_56361_56388[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56359 === (1))){
var state_56358__$1 = state_56358;
var statearr_56362_56389 = state_56358__$1;
(statearr_56362_56389[(2)] = null);

(statearr_56362_56389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56359 === (4))){
var inst_56312 = (state_56358[(2)]);
var state_56358__$1 = state_56358;
var statearr_56363_56390 = state_56358__$1;
(statearr_56363_56390[(2)] = inst_56312);

(statearr_56363_56390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56359 === (15))){
var inst_56339 = (state_56358[(2)]);
var state_56358__$1 = state_56358;
var statearr_56364_56391 = state_56358__$1;
(statearr_56364_56391[(2)] = inst_56339);

(statearr_56364_56391[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56359 === (13))){
var inst_56336 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_56358__$1 = state_56358;
var statearr_56365_56392 = state_56358__$1;
(statearr_56365_56392[(2)] = inst_56336);

(statearr_56365_56392[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56359 === (6))){
var inst_56323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56324 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56325 = [inst_56324,(0)];
var inst_56326 = (new cljs.core.PersistentVector(null,2,(5),inst_56323,inst_56325,null));
var state_56358__$1 = state_56358;
var statearr_56366_56393 = state_56358__$1;
(statearr_56366_56393[(2)] = inst_56326);

(statearr_56366_56393[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56359 === (3))){
var inst_56356 = (state_56358[(2)]);
var state_56358__$1 = state_56358;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56358__$1,inst_56356);
} else {
if((state_val_56359 === (12))){
var inst_56332 = (state_56358[(2)]);
var inst_56333 = fluree.db.util.async.throw_err.call(null,inst_56332);
var state_56358__$1 = state_56358;
var statearr_56367_56394 = state_56358__$1;
(statearr_56367_56394[(2)] = inst_56333);

(statearr_56367_56394[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56359 === (2))){
var _ = (function (){var statearr_56368 = state_56358;
(statearr_56368[(4)] = cljs.core.cons.call(null,(5),(state_56358[(4)])));

return statearr_56368;
})();
var inst_56321 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56358__$1 = state_56358;
if(cljs.core.truth_(inst_56321)){
var statearr_56369_56395 = state_56358__$1;
(statearr_56369_56395[(1)] = (6));

} else {
var statearr_56370_56396 = state_56358__$1;
(statearr_56370_56396[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56359 === (11))){
var inst_56341 = (state_56358[(2)]);
var state_56358__$1 = state_56358;
var statearr_56372_56397 = state_56358__$1;
(statearr_56372_56397[(2)] = inst_56341);

(statearr_56372_56397[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56359 === (9))){
var inst_56330 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_56358__$1 = state_56358;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56358__$1,(12),inst_56330);
} else {
if((state_val_56359 === (5))){
var _ = (function (){var statearr_56373 = state_56358;
(statearr_56373[(4)] = cljs.core.rest.call(null,(state_56358[(4)])));

return statearr_56373;
})();
var state_56358__$1 = state_56358;
var ex56371 = (state_56358__$1[(2)]);
var statearr_56374_56398 = state_56358__$1;
(statearr_56374_56398[(5)] = ex56371);


if((ex56371 instanceof Error)){
var statearr_56375_56399 = state_56358__$1;
(statearr_56375_56399[(1)] = (4));

(statearr_56375_56399[(5)] = null);

} else {
throw ex56371;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56359 === (14))){
var state_56358__$1 = state_56358;
var statearr_56376_56400 = state_56358__$1;
(statearr_56376_56400[(2)] = null);

(statearr_56376_56400[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56359 === (10))){
var state_56358__$1 = state_56358;
var statearr_56377_56401 = state_56358__$1;
(statearr_56377_56401[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56359 === (8))){
var inst_56343 = (state_56358[(2)]);
var inst_56344 = cljs.core.nth.call(null,inst_56343,(0),null);
var inst_56345 = cljs.core.nth.call(null,inst_56343,(1),null);
var inst_56346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56347 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56348 = ["?user_id","?ctx",inst_56344];
var inst_56349 = cljs.core.PersistentHashMap.fromArrays(inst_56347,inst_56348);
var inst_56350 = ((10) + inst_56345);
var inst_56351 = [inst_56349,inst_56350];
var inst_56352 = (new cljs.core.PersistentVector(null,2,(5),inst_56346,inst_56351,null));
var inst_56353 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56352);
var _ = (function (){var statearr_56379 = state_56358;
(statearr_56379[(4)] = cljs.core.rest.call(null,(state_56358[(4)])));

return statearr_56379;
})();
var state_56358__$1 = (function (){var statearr_56380 = state_56358;
(statearr_56380[(7)] = inst_56353);

return statearr_56380;
})();
var statearr_56381_56402 = state_56358__$1;
(statearr_56381_56402[(2)] = inst_56344);

(statearr_56381_56402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0 = (function (){
var statearr_56382 = [null,null,null,null,null,null,null,null];
(statearr_56382[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__);

(statearr_56382[(1)] = (1));

return statearr_56382;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1 = (function (state_56358){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_56358);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56383){var ex__2730__auto__ = e56383;
var statearr_56384_56403 = state_56358;
(statearr_56384_56403[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_56358[(4)]))){
var statearr_56385_56404 = state_56358;
(statearr_56385_56404[(1)] = cljs.core.first.call(null,(state_56358[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56405 = state_56358;
state_56358 = G__56405;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = function(state_56358){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1.call(this,state_56358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56386 = f__2750__auto__.call(null);
(statearr_56386[(6)] = c__2749__auto__);

return statearr_56386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56433){
var state_val_56434 = (state_56433[(1)]);
if((state_val_56434 === (7))){
var inst_56426 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_56433__$1 = state_56433;
var statearr_56435_56454 = state_56433__$1;
(statearr_56435_56454[(2)] = inst_56426);

(statearr_56435_56454[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56434 === (1))){
var state_56433__$1 = state_56433;
var statearr_56436_56455 = state_56433__$1;
(statearr_56436_56455[(2)] = null);

(statearr_56436_56455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56434 === (4))){
var inst_56406 = (state_56433[(2)]);
var state_56433__$1 = state_56433;
var statearr_56437_56456 = state_56433__$1;
(statearr_56437_56456[(2)] = inst_56406);

(statearr_56437_56456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56434 === (6))){
var inst_56414 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_56433__$1 = state_56433;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56433__$1,(9),inst_56414);
} else {
if((state_val_56434 === (3))){
var inst_56431 = (state_56433[(2)]);
var state_56433__$1 = state_56433;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56433__$1,inst_56431);
} else {
if((state_val_56434 === (2))){
var _ = (function (){var statearr_56439 = state_56433;
(statearr_56439[(4)] = cljs.core.cons.call(null,(5),(state_56433[(4)])));

return statearr_56439;
})();
var inst_56412 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56433__$1 = state_56433;
if(cljs.core.truth_(inst_56412)){
var statearr_56440_56457 = state_56433__$1;
(statearr_56440_56457[(1)] = (6));

} else {
var statearr_56441_56458 = state_56433__$1;
(statearr_56441_56458[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56434 === (9))){
var inst_56416 = (state_56433[(2)]);
var inst_56417 = fluree.db.util.async.throw_err.call(null,inst_56416);
var inst_56418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56419 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56420 = ["?auth_id","?ctx",inst_56417];
var inst_56421 = cljs.core.PersistentHashMap.fromArrays(inst_56419,inst_56420);
var inst_56422 = [inst_56421,(10)];
var inst_56423 = (new cljs.core.PersistentVector(null,2,(5),inst_56418,inst_56422,null));
var inst_56424 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56423);
var state_56433__$1 = (function (){var statearr_56442 = state_56433;
(statearr_56442[(7)] = inst_56424);

return statearr_56442;
})();
var statearr_56443_56459 = state_56433__$1;
(statearr_56443_56459[(2)] = inst_56417);

(statearr_56443_56459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56434 === (5))){
var _ = (function (){var statearr_56444 = state_56433;
(statearr_56444[(4)] = cljs.core.rest.call(null,(state_56433[(4)])));

return statearr_56444;
})();
var state_56433__$1 = state_56433;
var ex56438 = (state_56433__$1[(2)]);
var statearr_56445_56460 = state_56433__$1;
(statearr_56445_56460[(5)] = ex56438);


if((ex56438 instanceof Error)){
var statearr_56446_56461 = state_56433__$1;
(statearr_56446_56461[(1)] = (4));

(statearr_56446_56461[(5)] = null);

} else {
throw ex56438;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56434 === (8))){
var inst_56428 = (state_56433[(2)]);
var _ = (function (){var statearr_56447 = state_56433;
(statearr_56447[(4)] = cljs.core.rest.call(null,(state_56433[(4)])));

return statearr_56447;
})();
var state_56433__$1 = state_56433;
var statearr_56448_56462 = state_56433__$1;
(statearr_56448_56462[(2)] = inst_56428);

(statearr_56448_56462[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_56449 = [null,null,null,null,null,null,null,null];
(statearr_56449[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_56449[(1)] = (1));

return statearr_56449;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_56433){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_56433);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56450){var ex__2730__auto__ = e56450;
var statearr_56451_56463 = state_56433;
(statearr_56451_56463[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_56433[(4)]))){
var statearr_56452_56464 = state_56433;
(statearr_56452_56464[(1)] = cljs.core.first.call(null,(state_56433[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56465 = state_56433;
state_56433 = G__56465;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_56433){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_56433);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56453 = f__2750__auto__.call(null);
(statearr_56453[(6)] = c__2749__auto__);

return statearr_56453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__56467 = arguments.length;
switch (G__56467) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56509){
var state_val_56510 = (state_56509[(1)]);
if((state_val_56510 === (7))){
var state_56509__$1 = state_56509;
var statearr_56511_56541 = state_56509__$1;
(statearr_56511_56541[(2)] = seed);

(statearr_56511_56541[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (1))){
var state_56509__$1 = state_56509;
var statearr_56512_56542 = state_56509__$1;
(statearr_56512_56542[(2)] = null);

(statearr_56512_56542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (4))){
var inst_56468 = (state_56509[(2)]);
var state_56509__$1 = state_56509;
var statearr_56513_56543 = state_56509__$1;
(statearr_56513_56543[(2)] = inst_56468);

(statearr_56513_56543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (15))){
var state_56509__$1 = state_56509;
var statearr_56514_56544 = state_56509__$1;
(statearr_56514_56544[(2)] = (10));

(statearr_56514_56544[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (13))){
var inst_56485 = (state_56509[(2)]);
var inst_56486 = fluree.db.util.async.throw_err.call(null,inst_56485);
var state_56509__$1 = state_56509;
var statearr_56515_56545 = state_56509__$1;
(statearr_56515_56545[(2)] = inst_56486);

(statearr_56515_56545[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (6))){
var state_56509__$1 = state_56509;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56509__$1,(9),seed);
} else {
if((state_val_56510 === (3))){
var inst_56507 = (state_56509[(2)]);
var state_56509__$1 = state_56509;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56509__$1,inst_56507);
} else {
if((state_val_56510 === (12))){
var inst_56489 = (state_56509[(7)]);
var inst_56489__$1 = (state_56509[(2)]);
var state_56509__$1 = (function (){var statearr_56516 = state_56509;
(statearr_56516[(7)] = inst_56489__$1);

return statearr_56516;
})();
if(cljs.core.truth_(inst_56489__$1)){
var statearr_56517_56546 = state_56509__$1;
(statearr_56517_56546[(1)] = (14));

} else {
var statearr_56518_56547 = state_56509__$1;
(statearr_56518_56547[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (2))){
var _ = (function (){var statearr_56519 = state_56509;
(statearr_56519[(4)] = cljs.core.cons.call(null,(5),(state_56509[(4)])));

return statearr_56519;
})();
var inst_56474 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_56509__$1 = state_56509;
if(inst_56474){
var statearr_56520_56548 = state_56509__$1;
(statearr_56520_56548[(1)] = (6));

} else {
var statearr_56521_56549 = state_56509__$1;
(statearr_56521_56549[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (11))){
var state_56509__$1 = state_56509;
var statearr_56523_56550 = state_56509__$1;
(statearr_56523_56550[(2)] = max);

(statearr_56523_56550[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (9))){
var inst_56477 = (state_56509[(2)]);
var inst_56478 = fluree.db.util.async.throw_err.call(null,inst_56477);
var state_56509__$1 = state_56509;
var statearr_56524_56551 = state_56509__$1;
(statearr_56524_56551[(2)] = inst_56478);

(statearr_56524_56551[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (5))){
var _ = (function (){var statearr_56525 = state_56509;
(statearr_56525[(4)] = cljs.core.rest.call(null,(state_56509[(4)])));

return statearr_56525;
})();
var state_56509__$1 = state_56509;
var ex56522 = (state_56509__$1[(2)]);
var statearr_56526_56552 = state_56509__$1;
(statearr_56526_56552[(5)] = ex56522);


if((ex56522 instanceof Error)){
var statearr_56527_56553 = state_56509__$1;
(statearr_56527_56553[(1)] = (4));

(statearr_56527_56553[(5)] = null);

} else {
throw ex56522;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (14))){
var inst_56489 = (state_56509[(7)]);
var state_56509__$1 = state_56509;
var statearr_56528_56554 = state_56509__$1;
(statearr_56528_56554[(2)] = inst_56489);

(statearr_56528_56554[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (16))){
var inst_56481 = (state_56509[(8)]);
var inst_56493 = (state_56509[(2)]);
var inst_56494 = fluree.db.dbfunctions.internal.rand.call(null,inst_56481,inst_56493);
var inst_56495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56496 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56497 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56498 = [max,seed];
var inst_56499 = (new cljs.core.PersistentVector(null,2,(5),inst_56497,inst_56498,null));
var inst_56500 = ["rand",inst_56499,inst_56494];
var inst_56501 = cljs.core.PersistentHashMap.fromArrays(inst_56496,inst_56500);
var inst_56502 = [inst_56501,(10)];
var inst_56503 = (new cljs.core.PersistentVector(null,2,(5),inst_56495,inst_56502,null));
var inst_56504 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56503);
var _ = (function (){var statearr_56529 = state_56509;
(statearr_56529[(4)] = cljs.core.rest.call(null,(state_56509[(4)])));

return statearr_56529;
})();
var state_56509__$1 = (function (){var statearr_56530 = state_56509;
(statearr_56530[(9)] = inst_56504);

return statearr_56530;
})();
var statearr_56531_56555 = state_56509__$1;
(statearr_56531_56555[(2)] = inst_56494);

(statearr_56531_56555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56510 === (10))){
var state_56509__$1 = state_56509;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56509__$1,(13),max);
} else {
if((state_val_56510 === (8))){
var inst_56481 = (state_56509[(2)]);
var inst_56482 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_56509__$1 = (function (){var statearr_56532 = state_56509;
(statearr_56532[(8)] = inst_56481);

return statearr_56532;
})();
if(inst_56482){
var statearr_56533_56556 = state_56509__$1;
(statearr_56533_56556[(1)] = (10));

} else {
var statearr_56534_56557 = state_56509__$1;
(statearr_56534_56557[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56535 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56535[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56535[(1)] = (1));

return statearr_56535;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56509){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_56509);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56536){var ex__2730__auto__ = e56536;
var statearr_56537_56558 = state_56509;
(statearr_56537_56558[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_56509[(4)]))){
var statearr_56538_56559 = state_56509;
(statearr_56538_56559[(1)] = cljs.core.first.call(null,(state_56509[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56560 = state_56509;
state_56509 = G__56560;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56509){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56539 = f__2750__auto__.call(null);
(statearr_56539[(6)] = c__2749__auto__);

return statearr_56539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56581){
var state_val_56582 = (state_56581[(1)]);
if((state_val_56582 === (1))){
var state_56581__$1 = state_56581;
var statearr_56583_56598 = state_56581__$1;
(statearr_56583_56598[(2)] = null);

(statearr_56583_56598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56582 === (2))){
var _ = (function (){var statearr_56584 = state_56581;
(statearr_56584[(4)] = cljs.core.cons.call(null,(5),(state_56581[(4)])));

return statearr_56584;
})();
var inst_56567 = cljs.core.random_uuid.call(null);
var inst_56568 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_56567);
var inst_56569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56570 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56571 = cljs.core.PersistentVector.EMPTY;
var inst_56572 = ["uuid",inst_56571,inst_56568];
var inst_56573 = cljs.core.PersistentHashMap.fromArrays(inst_56570,inst_56572);
var inst_56574 = [inst_56573,(10)];
var inst_56575 = (new cljs.core.PersistentVector(null,2,(5),inst_56569,inst_56574,null));
var inst_56576 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56575);
var ___$1 = (function (){var statearr_56585 = state_56581;
(statearr_56585[(4)] = cljs.core.rest.call(null,(state_56581[(4)])));

return statearr_56585;
})();
var state_56581__$1 = (function (){var statearr_56586 = state_56581;
(statearr_56586[(7)] = inst_56576);

return statearr_56586;
})();
var statearr_56587_56599 = state_56581__$1;
(statearr_56587_56599[(2)] = inst_56568);

(statearr_56587_56599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56582 === (3))){
var inst_56579 = (state_56581[(2)]);
var state_56581__$1 = state_56581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56581__$1,inst_56579);
} else {
if((state_val_56582 === (4))){
var inst_56561 = (state_56581[(2)]);
var state_56581__$1 = state_56581;
var statearr_56589_56600 = state_56581__$1;
(statearr_56589_56600[(2)] = inst_56561);

(statearr_56589_56600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56582 === (5))){
var _ = (function (){var statearr_56590 = state_56581;
(statearr_56590[(4)] = cljs.core.rest.call(null,(state_56581[(4)])));

return statearr_56590;
})();
var state_56581__$1 = state_56581;
var ex56588 = (state_56581__$1[(2)]);
var statearr_56591_56601 = state_56581__$1;
(statearr_56591_56601[(5)] = ex56588);


if((ex56588 instanceof Error)){
var statearr_56592_56602 = state_56581__$1;
(statearr_56592_56602[(1)] = (4));

(statearr_56592_56602[(5)] = null);

} else {
throw ex56588;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0 = (function (){
var statearr_56593 = [null,null,null,null,null,null,null,null];
(statearr_56593[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__);

(statearr_56593[(1)] = (1));

return statearr_56593;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1 = (function (state_56581){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_56581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56594){var ex__2730__auto__ = e56594;
var statearr_56595_56603 = state_56581;
(statearr_56595_56603[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_56581[(4)]))){
var statearr_56596_56604 = state_56581;
(statearr_56596_56604[(1)] = cljs.core.first.call(null,(state_56581[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56605 = state_56581;
state_56581 = G__56605;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = function(state_56581){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1.call(this,state_56581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56597 = f__2750__auto__.call(null);
(statearr_56597[(6)] = c__2749__auto__);

return statearr_56597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56635){
var state_val_56636 = (state_56635[(1)]);
if((state_val_56636 === (7))){
var state_56635__$1 = state_56635;
var statearr_56637_56656 = state_56635__$1;
(statearr_56637_56656[(2)] = num);

(statearr_56637_56656[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (1))){
var state_56635__$1 = state_56635;
var statearr_56638_56657 = state_56635__$1;
(statearr_56638_56657[(2)] = null);

(statearr_56638_56657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (4))){
var inst_56606 = (state_56635[(2)]);
var state_56635__$1 = state_56635;
var statearr_56639_56658 = state_56635__$1;
(statearr_56639_56658[(2)] = inst_56606);

(statearr_56639_56658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (6))){
var state_56635__$1 = state_56635;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56635__$1,(9),num);
} else {
if((state_val_56636 === (3))){
var inst_56633 = (state_56635[(2)]);
var state_56635__$1 = state_56635;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56635__$1,inst_56633);
} else {
if((state_val_56636 === (2))){
var _ = (function (){var statearr_56641 = state_56635;
(statearr_56641[(4)] = cljs.core.cons.call(null,(5),(state_56635[(4)])));

return statearr_56641;
})();
var inst_56612 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_56635__$1 = state_56635;
if(inst_56612){
var statearr_56642_56659 = state_56635__$1;
(statearr_56642_56659[(1)] = (6));

} else {
var statearr_56643_56660 = state_56635__$1;
(statearr_56643_56660[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (9))){
var inst_56615 = (state_56635[(2)]);
var inst_56616 = fluree.db.util.async.throw_err.call(null,inst_56615);
var state_56635__$1 = state_56635;
var statearr_56644_56661 = state_56635__$1;
(statearr_56644_56661[(2)] = inst_56616);

(statearr_56644_56661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (5))){
var _ = (function (){var statearr_56645 = state_56635;
(statearr_56645[(4)] = cljs.core.rest.call(null,(state_56635[(4)])));

return statearr_56645;
})();
var state_56635__$1 = state_56635;
var ex56640 = (state_56635__$1[(2)]);
var statearr_56646_56662 = state_56635__$1;
(statearr_56646_56662[(5)] = ex56640);


if((ex56640 instanceof Error)){
var statearr_56647_56663 = state_56635__$1;
(statearr_56647_56663[(1)] = (4));

(statearr_56647_56663[(5)] = null);

} else {
throw ex56640;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (8))){
var inst_56619 = (state_56635[(2)]);
var inst_56620 = fluree.db.dbfunctions.internal.ceil.call(null,inst_56619);
var inst_56621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56622 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56624 = [fluree.db.dbfunctions.fns.ceil];
var inst_56625 = (new cljs.core.PersistentVector(null,1,(5),inst_56623,inst_56624,null));
var inst_56626 = ["",inst_56625,inst_56620];
var inst_56627 = cljs.core.PersistentHashMap.fromArrays(inst_56622,inst_56626);
var inst_56628 = [inst_56627,(10)];
var inst_56629 = (new cljs.core.PersistentVector(null,2,(5),inst_56621,inst_56628,null));
var inst_56630 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56629);
var _ = (function (){var statearr_56648 = state_56635;
(statearr_56648[(4)] = cljs.core.rest.call(null,(state_56635[(4)])));

return statearr_56648;
})();
var state_56635__$1 = (function (){var statearr_56649 = state_56635;
(statearr_56649[(7)] = inst_56630);

return statearr_56649;
})();
var statearr_56650_56664 = state_56635__$1;
(statearr_56650_56664[(2)] = inst_56620);

(statearr_56650_56664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0 = (function (){
var statearr_56651 = [null,null,null,null,null,null,null,null];
(statearr_56651[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__);

(statearr_56651[(1)] = (1));

return statearr_56651;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1 = (function (state_56635){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_56635);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56652){var ex__2730__auto__ = e56652;
var statearr_56653_56665 = state_56635;
(statearr_56653_56665[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_56635[(4)]))){
var statearr_56654_56666 = state_56635;
(statearr_56654_56666[(1)] = cljs.core.first.call(null,(state_56635[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56667 = state_56635;
state_56635 = G__56667;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = function(state_56635){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1.call(this,state_56635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56655 = f__2750__auto__.call(null);
(statearr_56655[(6)] = c__2749__auto__);

return statearr_56655;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56697){
var state_val_56698 = (state_56697[(1)]);
if((state_val_56698 === (7))){
var state_56697__$1 = state_56697;
var statearr_56699_56718 = state_56697__$1;
(statearr_56699_56718[(2)] = num);

(statearr_56699_56718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56698 === (1))){
var state_56697__$1 = state_56697;
var statearr_56700_56719 = state_56697__$1;
(statearr_56700_56719[(2)] = null);

(statearr_56700_56719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56698 === (4))){
var inst_56668 = (state_56697[(2)]);
var state_56697__$1 = state_56697;
var statearr_56701_56720 = state_56697__$1;
(statearr_56701_56720[(2)] = inst_56668);

(statearr_56701_56720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56698 === (6))){
var state_56697__$1 = state_56697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56697__$1,(9),num);
} else {
if((state_val_56698 === (3))){
var inst_56695 = (state_56697[(2)]);
var state_56697__$1 = state_56697;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56697__$1,inst_56695);
} else {
if((state_val_56698 === (2))){
var _ = (function (){var statearr_56703 = state_56697;
(statearr_56703[(4)] = cljs.core.cons.call(null,(5),(state_56697[(4)])));

return statearr_56703;
})();
var inst_56674 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_56697__$1 = state_56697;
if(inst_56674){
var statearr_56704_56721 = state_56697__$1;
(statearr_56704_56721[(1)] = (6));

} else {
var statearr_56705_56722 = state_56697__$1;
(statearr_56705_56722[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56698 === (9))){
var inst_56677 = (state_56697[(2)]);
var inst_56678 = fluree.db.util.async.throw_err.call(null,inst_56677);
var state_56697__$1 = state_56697;
var statearr_56706_56723 = state_56697__$1;
(statearr_56706_56723[(2)] = inst_56678);

(statearr_56706_56723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56698 === (5))){
var _ = (function (){var statearr_56707 = state_56697;
(statearr_56707[(4)] = cljs.core.rest.call(null,(state_56697[(4)])));

return statearr_56707;
})();
var state_56697__$1 = state_56697;
var ex56702 = (state_56697__$1[(2)]);
var statearr_56708_56724 = state_56697__$1;
(statearr_56708_56724[(5)] = ex56702);


if((ex56702 instanceof Error)){
var statearr_56709_56725 = state_56697__$1;
(statearr_56709_56725[(1)] = (4));

(statearr_56709_56725[(5)] = null);

} else {
throw ex56702;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56698 === (8))){
var inst_56681 = (state_56697[(2)]);
var inst_56682 = fluree.db.dbfunctions.internal.floor.call(null,inst_56681);
var inst_56683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56684 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56686 = [fluree.db.dbfunctions.fns.floor];
var inst_56687 = (new cljs.core.PersistentVector(null,1,(5),inst_56685,inst_56686,null));
var inst_56688 = ["",inst_56687,inst_56682];
var inst_56689 = cljs.core.PersistentHashMap.fromArrays(inst_56684,inst_56688);
var inst_56690 = [inst_56689,(10)];
var inst_56691 = (new cljs.core.PersistentVector(null,2,(5),inst_56683,inst_56690,null));
var inst_56692 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56691);
var _ = (function (){var statearr_56710 = state_56697;
(statearr_56710[(4)] = cljs.core.rest.call(null,(state_56697[(4)])));

return statearr_56710;
})();
var state_56697__$1 = (function (){var statearr_56711 = state_56697;
(statearr_56711[(7)] = inst_56692);

return statearr_56711;
})();
var statearr_56712_56726 = state_56697__$1;
(statearr_56712_56726[(2)] = inst_56682);

(statearr_56712_56726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0 = (function (){
var statearr_56713 = [null,null,null,null,null,null,null,null];
(statearr_56713[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__);

(statearr_56713[(1)] = (1));

return statearr_56713;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1 = (function (state_56697){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_56697);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56714){var ex__2730__auto__ = e56714;
var statearr_56715_56727 = state_56697;
(statearr_56715_56727[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_56697[(4)]))){
var statearr_56716_56728 = state_56697;
(statearr_56716_56728[(1)] = cljs.core.first.call(null,(state_56697[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56729 = state_56697;
state_56697 = G__56729;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = function(state_56697){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1.call(this,state_56697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56717 = f__2750__auto__.call(null);
(statearr_56717[(6)] = c__2749__auto__);

return statearr_56717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56754){
var state_val_56755 = (state_56754[(1)]);
if((state_val_56755 === (1))){
var state_56754__$1 = state_56754;
var statearr_56756_56771 = state_56754__$1;
(statearr_56756_56771[(2)] = null);

(statearr_56756_56771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56755 === (2))){
var _ = (function (){var statearr_56757 = state_56754;
(statearr_56757[(4)] = cljs.core.cons.call(null,(5),(state_56754[(4)])));

return statearr_56757;
})();
var inst_56736 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_56754__$1 = state_56754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56754__$1,(6),inst_56736);
} else {
if((state_val_56755 === (3))){
var inst_56752 = (state_56754[(2)]);
var state_56754__$1 = state_56754;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56754__$1,inst_56752);
} else {
if((state_val_56755 === (4))){
var inst_56730 = (state_56754[(2)]);
var state_56754__$1 = state_56754;
var statearr_56759_56772 = state_56754__$1;
(statearr_56759_56772[(2)] = inst_56730);

(statearr_56759_56772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56755 === (5))){
var _ = (function (){var statearr_56760 = state_56754;
(statearr_56760[(4)] = cljs.core.rest.call(null,(state_56754[(4)])));

return statearr_56760;
})();
var state_56754__$1 = state_56754;
var ex56758 = (state_56754__$1[(2)]);
var statearr_56761_56773 = state_56754__$1;
(statearr_56761_56773[(5)] = ex56758);


if((ex56758 instanceof Error)){
var statearr_56762_56774 = state_56754__$1;
(statearr_56762_56774[(1)] = (4));

(statearr_56762_56774[(5)] = null);

} else {
throw ex56758;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56755 === (6))){
var inst_56738 = (state_56754[(2)]);
var inst_56739 = fluree.db.util.async.throw_err.call(null,inst_56738);
var inst_56740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56741 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56742 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56743 = [compare_val,new_val];
var inst_56744 = (new cljs.core.PersistentVector(null,2,(5),inst_56742,inst_56743,null));
var inst_56745 = ["",inst_56744,inst_56739];
var inst_56746 = cljs.core.PersistentHashMap.fromArrays(inst_56741,inst_56745);
var inst_56747 = [inst_56746,(10)];
var inst_56748 = (new cljs.core.PersistentVector(null,2,(5),inst_56740,inst_56747,null));
var inst_56749 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56748);
var _ = (function (){var statearr_56763 = state_56754;
(statearr_56763[(4)] = cljs.core.rest.call(null,(state_56754[(4)])));

return statearr_56763;
})();
var state_56754__$1 = (function (){var statearr_56764 = state_56754;
(statearr_56764[(7)] = inst_56749);

return statearr_56764;
})();
var statearr_56765_56775 = state_56754__$1;
(statearr_56765_56775[(2)] = inst_56739);

(statearr_56765_56775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_56766 = [null,null,null,null,null,null,null,null];
(statearr_56766[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__);

(statearr_56766[(1)] = (1));

return statearr_56766;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1 = (function (state_56754){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_56754);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56767){var ex__2730__auto__ = e56767;
var statearr_56768_56776 = state_56754;
(statearr_56768_56776[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_56754[(4)]))){
var statearr_56769_56777 = state_56754;
(statearr_56769_56777[(1)] = cljs.core.first.call(null,(state_56754[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56778 = state_56754;
state_56754 = G__56778;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = function(state_56754){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1.call(this,state_56754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56770 = f__2750__auto__.call(null);
(statearr_56770[(6)] = c__2749__auto__);

return statearr_56770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
