// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-ledger-id] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__24770 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__24770,(0),null);
var network = cljs.core.nth.call(null,vec__24770,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__24770,(2),null);
if(cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
/**
 * Predicates to exclude from the database
 */
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(130),(106)]);
fluree.db.graphdb.exclude_flake_QMARK_ = (function fluree$db$graphdb$exclude_flake_QMARK_(f){
return cljs.core.contains_QMARK_.call(null,fluree.db.graphdb.exclude_predicates,fluree.db.flake.p.call(null,f));
});
fluree.db.graphdb.include_flake_QMARK_ = cljs.core.complement.call(null,fluree.db.graphdb.exclude_flake_QMARK_);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__24773){
var map__24774 = p__24773;
var map__24774__$1 = cljs.core.__destructure_map.call(null,map__24774);
var opts = map__24774__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__24774__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24834){
var state_val_24835 = (state_24834[(1)]);
if((state_val_24835 === (7))){
var inst_24805 = cljs.core.not.call(null,reindex_QMARK_);
var state_24834__$1 = state_24834;
var statearr_24836_24860 = state_24834__$1;
(statearr_24836_24860[(2)] = inst_24805);

(statearr_24836_24860[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24835 === (1))){
var state_24834__$1 = state_24834;
var statearr_24837_24861 = state_24834__$1;
(statearr_24837_24861[(2)] = null);

(statearr_24837_24861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24835 === (4))){
var inst_24775 = (state_24834[(2)]);
var state_24834__$1 = state_24834;
var statearr_24838_24862 = state_24834__$1;
(statearr_24838_24862[(2)] = inst_24775);

(statearr_24838_24862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24835 === (6))){
var inst_24789 = (state_24834[(7)]);
var inst_24795 = (state_24834[(8)]);
var inst_24803 = (state_24834[(9)]);
var inst_24788 = (state_24834[(2)]);
var inst_24789__$1 = fluree.db.util.async.throw_err.call(null,inst_24788);
var inst_24790 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_24791 = cljs.core.__destructure_map.call(null,inst_24790);
var inst_24792 = cljs.core.get.call(null,inst_24791,new cljs.core.Keyword(null,"post","post",269697687));
var inst_24793 = cljs.core.get.call(null,inst_24791,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_24794 = fluree.db.flake.size_bytes.call(null,inst_24789__$1);
var inst_24795__$1 = (inst_24793 + inst_24794);
var inst_24796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24797 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_24798 = (new cljs.core.PersistentVector(null,2,(5),inst_24796,inst_24797,null));
var inst_24799 = cljs.core.get_in.call(null,db,inst_24798);
var inst_24800 = cljs.core.__destructure_map.call(null,inst_24799);
var inst_24801 = cljs.core.get.call(null,inst_24800,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_24802 = cljs.core.get.call(null,inst_24800,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_24803__$1 = (inst_24795__$1 > inst_24802);
var state_24834__$1 = (function (){var statearr_24839 = state_24834;
(statearr_24839[(7)] = inst_24789__$1);

(statearr_24839[(10)] = inst_24792);

(statearr_24839[(8)] = inst_24795__$1);

(statearr_24839[(9)] = inst_24803__$1);

(statearr_24839[(11)] = inst_24801);

return statearr_24839;
})();
if(cljs.core.truth_(inst_24803__$1)){
var statearr_24840_24863 = state_24834__$1;
(statearr_24840_24863[(1)] = (7));

} else {
var statearr_24841_24864 = state_24834__$1;
(statearr_24841_24864[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24835 === (3))){
var inst_24832 = (state_24834[(2)]);
var state_24834__$1 = state_24834;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24834__$1,inst_24832);
} else {
if((state_val_24835 === (12))){
var inst_24789 = (state_24834[(7)]);
var inst_24792 = (state_24834[(10)]);
var inst_24795 = (state_24834[(8)]);
var inst_24818 = (state_24834[(2)]);
var inst_24819 = cljs.core.into.call(null,inst_24792,inst_24789);
var inst_24820 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_24821 = cljs.core.swap_BANG_.call(null,inst_24820,cljs.core.empty);
var inst_24822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24823 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_24824 = (new cljs.core.PersistentVector(null,2,(5),inst_24822,inst_24823,null));
var inst_24825 = cljs.core.assoc_in.call(null,db,inst_24824,inst_24819);
var inst_24826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24827 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_24828 = (new cljs.core.PersistentVector(null,2,(5),inst_24826,inst_24827,null));
var inst_24829 = cljs.core.assoc_in.call(null,inst_24825,inst_24828,inst_24795);
var _ = (function (){var statearr_24842 = state_24834;
(statearr_24842[(4)] = cljs.core.rest.call(null,(state_24834[(4)])));

return statearr_24842;
})();
var state_24834__$1 = (function (){var statearr_24843 = state_24834;
(statearr_24843[(12)] = inst_24818);

(statearr_24843[(13)] = inst_24821);

return statearr_24843;
})();
var statearr_24844_24865 = state_24834__$1;
(statearr_24844_24865[(2)] = inst_24829);

(statearr_24844_24865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24835 === (2))){
var _ = (function (){var statearr_24845 = state_24834;
(statearr_24845[(4)] = cljs.core.cons.call(null,(5),(state_24834[(4)])));

return statearr_24845;
})();
var inst_24783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24784 = [pred_id];
var inst_24785 = (new cljs.core.PersistentVector(null,1,(5),inst_24783,inst_24784,null));
var inst_24786 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_24785);
var state_24834__$1 = state_24834;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24834__$1,(6),inst_24786);
} else {
if((state_val_24835 === (11))){
var state_24834__$1 = state_24834;
var statearr_24847_24866 = state_24834__$1;
(statearr_24847_24866[(2)] = null);

(statearr_24847_24866[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24835 === (9))){
var inst_24808 = (state_24834[(2)]);
var state_24834__$1 = state_24834;
if(cljs.core.truth_(inst_24808)){
var statearr_24848_24867 = state_24834__$1;
(statearr_24848_24867[(1)] = (10));

} else {
var statearr_24849_24868 = state_24834__$1;
(statearr_24849_24868[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24835 === (5))){
var _ = (function (){var statearr_24850 = state_24834;
(statearr_24850[(4)] = cljs.core.rest.call(null,(state_24834[(4)])));

return statearr_24850;
})();
var state_24834__$1 = state_24834;
var ex24846 = (state_24834__$1[(2)]);
var statearr_24851_24869 = state_24834__$1;
(statearr_24851_24869[(5)] = ex24846);


if((ex24846 instanceof Error)){
var statearr_24852_24870 = state_24834__$1;
(statearr_24852_24870[(1)] = (4));

(statearr_24852_24870[(5)] = null);

} else {
throw ex24846;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24835 === (10))){
var inst_24810 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_24811 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24812 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_24813 = cljs.core.PersistentHashMap.fromArrays(inst_24811,inst_24812);
var inst_24814 = cljs.core.ex_info.call(null,inst_24810,inst_24813);
var inst_24815 = (function(){throw inst_24814})();
var state_24834__$1 = state_24834;
var statearr_24853_24871 = state_24834__$1;
(statearr_24853_24871[(2)] = inst_24815);

(statearr_24853_24871[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24835 === (8))){
var inst_24803 = (state_24834[(9)]);
var state_24834__$1 = state_24834;
var statearr_24854_24872 = state_24834__$1;
(statearr_24854_24872[(2)] = inst_24803);

(statearr_24854_24872[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0 = (function (){
var statearr_24855 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24855[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__);

(statearr_24855[(1)] = (1));

return statearr_24855;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1 = (function (state_24834){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_24834);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24856){var ex__2730__auto__ = e24856;
var statearr_24857_24873 = state_24834;
(statearr_24857_24873[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_24834[(4)]))){
var statearr_24858_24874 = state_24834;
(statearr_24858_24874[(1)] = cljs.core.first.call(null,(state_24834[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24875 = state_24834;
state_24834 = G__24875;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__ = function(state_24834){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1.call(this,state_24834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24859 = f__2750__auto__.call(null);
(statearr_24859[(6)] = c__2749__auto__);

return statearr_24859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__24878 = arguments.length;
switch (G__24878) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25078){
var state_val_25079 = (state_25078[(1)]);
if((state_val_25079 === (7))){
var state_25078__$1 = state_25078;
var statearr_25080_25147 = state_25078__$1;
(statearr_25080_25147[(2)] = null);

(statearr_25080_25147[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (20))){
var inst_25000 = (state_25078[(7)]);
var inst_24999 = (state_25078[(8)]);
var inst_25001 = (state_25078[(9)]);
var inst_24915 = (state_25078[(10)]);
var inst_24914 = (state_25078[(11)]);
var inst_24965 = (state_25078[(12)]);
var inst_25003 = (state_25078[(13)]);
var inst_24998 = (state_25078[(14)]);
var inst_25002 = (state_25078[(15)]);
var inst_25013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25014 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25015 = (new cljs.core.PersistentVector(null,2,(5),inst_25013,inst_25014,null));
var inst_25016 = cljs.core.get_in.call(null,inst_24965,inst_25015);
var inst_25017 = (inst_25016 + inst_24914);
var inst_25018 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25019 = [inst_24998,inst_24999,inst_25000,inst_25001,inst_25002,inst_25017];
var inst_25020 = cljs.core.PersistentHashMap.fromArrays(inst_25018,inst_25019);
var inst_25021 = cljs.core.assoc.call(null,inst_24965,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_25003,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_25020);
var state_25078__$1 = (function (){var statearr_25081 = state_25078;
(statearr_25081[(16)] = inst_25021);

return statearr_25081;
})();
if(cljs.core.truth_(inst_24915)){
var statearr_25082_25148 = state_25078__$1;
(statearr_25082_25148[(1)] = (23));

} else {
var statearr_25083_25149 = state_25078__$1;
(statearr_25083_25149[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (27))){
var inst_25021 = (state_25078[(16)]);
var state_25078__$1 = state_25078;
var statearr_25084_25150 = state_25078__$1;
(statearr_25084_25150[(2)] = inst_25021);

(statearr_25084_25150[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (1))){
var state_25078__$1 = state_25078;
var statearr_25085_25151 = state_25078__$1;
(statearr_25085_25151[(2)] = null);

(statearr_25085_25151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (24))){
var inst_25021 = (state_25078[(16)]);
var inst_25025 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_25021);
var inst_25026 = (inst_25025 == null);
var state_25078__$1 = state_25078;
var statearr_25086_25152 = state_25078__$1;
(statearr_25086_25152[(2)] = inst_25026);

(statearr_25086_25152[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (39))){
var inst_25053 = (state_25078[(17)]);
var inst_25051 = (state_25078[(18)]);
var inst_25060 = (state_25078[(19)]);
var inst_25052 = (state_25078[(20)]);
var inst_25009 = (state_25078[(21)]);
var inst_25010 = (state_25078[(22)]);
var inst_25002 = (state_25078[(15)]);
var inst_25067 = (state_25078[(2)]);
var inst_25068 = cljs.core.conj.call(null,inst_25002,inst_25009);
var inst_24997 = inst_25010;
var inst_24998 = inst_25052;
var inst_24999 = inst_25053;
var inst_25000 = inst_25060;
var inst_25001 = inst_25067;
var inst_25002__$1 = inst_25068;
var inst_25003 = inst_25051;
var state_25078__$1 = (function (){var statearr_25087 = state_25078;
(statearr_25087[(23)] = inst_24997);

(statearr_25087[(7)] = inst_25000);

(statearr_25087[(8)] = inst_24999);

(statearr_25087[(9)] = inst_25001);

(statearr_25087[(13)] = inst_25003);

(statearr_25087[(14)] = inst_24998);

(statearr_25087[(15)] = inst_25002__$1);

return statearr_25087;
})();
var statearr_25088_25153 = state_25078__$1;
(statearr_25088_25153[(2)] = null);

(statearr_25088_25153[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (4))){
var inst_24879 = (state_25078[(2)]);
var state_25078__$1 = state_25078;
var statearr_25089_25154 = state_25078__$1;
(statearr_25089_25154[(2)] = inst_24879);

(statearr_25089_25154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (15))){
var inst_24937 = (state_25078[(24)]);
var state_25078__$1 = state_25078;
var statearr_25090_25155 = state_25078__$1;
(statearr_25090_25155[(2)] = inst_24937);

(statearr_25090_25155[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (21))){
var inst_24997 = (state_25078[(23)]);
var inst_25000 = (state_25078[(7)]);
var inst_24999 = (state_25078[(8)]);
var inst_24918 = (state_25078[(25)]);
var inst_24909 = (state_25078[(26)]);
var inst_24905 = (state_25078[(27)]);
var inst_24901 = (state_25078[(28)]);
var inst_25001 = (state_25078[(9)]);
var inst_24915 = (state_25078[(10)]);
var inst_24916 = (state_25078[(29)]);
var inst_24975 = (state_25078[(30)]);
var inst_24914 = (state_25078[(11)]);
var inst_24913 = (state_25078[(31)]);
var inst_24965 = (state_25078[(12)]);
var inst_25009 = (state_25078[(21)]);
var inst_25003 = (state_25078[(13)]);
var inst_24998 = (state_25078[(14)]);
var inst_25010 = (state_25078[(22)]);
var inst_24902 = (state_25078[(32)]);
var inst_24886 = (state_25078[(33)]);
var inst_24924 = (state_25078[(34)]);
var inst_25002 = (state_25078[(15)]);
var inst_24974 = (state_25078[(35)]);
var inst_25048 = fluree.db.flake.s.call(null,inst_25009);
var inst_25049 = fluree.db.flake.sid__GT_cid.call(null,inst_25048);
var inst_25050 = (function (){var flakes_bytes = inst_24914;
var t = inst_24886;
var spot = inst_24998;
var add_flakes = inst_24902;
var root_setting_change_QMARK_ = inst_24916;
var seq__25006 = inst_25010;
var G__24969 = inst_24997;
var ref_QMARK__map = inst_24913;
var r = inst_25010;
var psot = inst_24999;
var add_pred_to_idx_QMARK_ = inst_24924;
var _ = inst_24901;
var tspo = inst_25002;
var first__25007 = inst_25009;
var cid = inst_25049;
var ecount = inst_25003;
var pred_ecount = inst_24918;
var db_STAR_ = inst_24965;
var system_change_QMARK_ = inst_24915;
var add_preds = inst_24905;
var opst = inst_25001;
var vec__24970 = inst_24902;
var idx_QMARK__map = inst_24909;
var post = inst_25000;
var first__24972 = inst_24974;
var vec__25005 = inst_24997;
var seq__24971 = inst_24975;
var f = inst_25009;
return (function (p1__24876_SHARP_){
if(cljs.core.truth_(p1__24876_SHARP_)){
var x__4336__auto__ = p1__24876_SHARP_;
var y__4337__auto__ = fluree.db.flake.s.call(null,f);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
} else {
return fluree.db.flake.s.call(null,f);
}
});
})();
var inst_25051 = cljs.core.update.call(null,inst_25003,inst_25049,inst_25050);
var inst_25052 = cljs.core.conj.call(null,inst_24998,inst_25009);
var inst_25053 = cljs.core.conj.call(null,inst_24999,inst_25009);
var inst_25054 = fluree.db.flake.p.call(null,inst_25009);
var inst_25055 = cljs.core.get.call(null,inst_24909,inst_25054);
var state_25078__$1 = (function (){var statearr_25091 = state_25078;
(statearr_25091[(17)] = inst_25053);

(statearr_25091[(18)] = inst_25051);

(statearr_25091[(20)] = inst_25052);

return statearr_25091;
})();
if(cljs.core.truth_(inst_25055)){
var statearr_25092_25156 = state_25078__$1;
(statearr_25092_25156[(1)] = (34));

} else {
var statearr_25093_25157 = state_25078__$1;
(statearr_25093_25157[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (31))){
var inst_25037 = (state_25078[(36)]);
var state_25078__$1 = state_25078;
var statearr_25094_25158 = state_25078__$1;
(statearr_25094_25158[(2)] = inst_25037);

(statearr_25094_25158[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (32))){
var inst_25046 = (state_25078[(2)]);
var state_25078__$1 = state_25078;
var statearr_25095_25159 = state_25078__$1;
(statearr_25095_25159[(2)] = inst_25046);

(statearr_25095_25159[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (33))){
var inst_25037 = (state_25078[(36)]);
var inst_25041 = (state_25078[(2)]);
var inst_25042 = fluree.db.util.async.throw_err.call(null,inst_25041);
var inst_25043 = cljs.core.assoc.call(null,inst_25037,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_25042);
var state_25078__$1 = state_25078;
var statearr_25096_25160 = state_25078__$1;
(statearr_25096_25160[(2)] = inst_25043);

(statearr_25096_25160[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (13))){
var inst_24914 = (state_25078[(11)]);
var inst_24965 = (state_25078[(12)]);
var inst_24902 = (state_25078[(32)]);
var inst_24886 = (state_25078[(33)]);
var inst_24955 = (state_25078[(2)]);
var inst_24956 = cljs.core.assoc.call(null,inst_24955,new cljs.core.Keyword(null,"t","t",-1397832519),inst_24886);
var inst_24957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24958 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_24959 = (new cljs.core.PersistentVector(null,2,(5),inst_24957,inst_24958,null));
var inst_24960 = cljs.core.update_in.call(null,inst_24956,inst_24959,cljs.core._PLUS_,inst_24914);
var inst_24961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24962 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_24963 = (new cljs.core.PersistentVector(null,2,(5),inst_24961,inst_24962,null));
var inst_24964 = cljs.core.count.call(null,inst_24902);
var inst_24965__$1 = cljs.core.update_in.call(null,inst_24960,inst_24963,cljs.core._PLUS_,inst_24964);
var inst_24973 = cljs.core.seq.call(null,inst_24902);
var inst_24974 = cljs.core.first.call(null,inst_24973);
var inst_24975 = cljs.core.next.call(null,inst_24973);
var inst_24976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24977 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_24978 = (new cljs.core.PersistentVector(null,2,(5),inst_24976,inst_24977,null));
var inst_24979 = cljs.core.get_in.call(null,inst_24965__$1,inst_24978);
var inst_24980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24981 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_24982 = (new cljs.core.PersistentVector(null,2,(5),inst_24980,inst_24981,null));
var inst_24983 = cljs.core.get_in.call(null,inst_24965__$1,inst_24982);
var inst_24984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24985 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_24986 = (new cljs.core.PersistentVector(null,2,(5),inst_24984,inst_24985,null));
var inst_24987 = cljs.core.get_in.call(null,inst_24965__$1,inst_24986);
var inst_24988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24989 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_24990 = (new cljs.core.PersistentVector(null,2,(5),inst_24988,inst_24989,null));
var inst_24991 = cljs.core.get_in.call(null,inst_24965__$1,inst_24990);
var inst_24992 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24993 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"tspo","tspo",-440144953)];
var inst_24994 = (new cljs.core.PersistentVector(null,2,(5),inst_24992,inst_24993,null));
var inst_24995 = cljs.core.get_in.call(null,inst_24965__$1,inst_24994);
var inst_24996 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_24997 = inst_24902;
var inst_24998 = inst_24979;
var inst_24999 = inst_24983;
var inst_25000 = inst_24987;
var inst_25001 = inst_24991;
var inst_25002 = inst_24995;
var inst_25003 = inst_24996;
var state_25078__$1 = (function (){var statearr_25097 = state_25078;
(statearr_25097[(23)] = inst_24997);

(statearr_25097[(7)] = inst_25000);

(statearr_25097[(8)] = inst_24999);

(statearr_25097[(9)] = inst_25001);

(statearr_25097[(30)] = inst_24975);

(statearr_25097[(12)] = inst_24965__$1);

(statearr_25097[(13)] = inst_25003);

(statearr_25097[(14)] = inst_24998);

(statearr_25097[(15)] = inst_25002);

(statearr_25097[(35)] = inst_24974);

return statearr_25097;
})();
var statearr_25098_25161 = state_25078__$1;
(statearr_25098_25161[(2)] = null);

(statearr_25098_25161[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (22))){
var inst_25071 = (state_25078[(2)]);
var state_25078__$1 = state_25078;
var statearr_25099_25162 = state_25078__$1;
(statearr_25099_25162[(2)] = inst_25071);

(statearr_25099_25162[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (36))){
var inst_24913 = (state_25078[(31)]);
var inst_25009 = (state_25078[(21)]);
var inst_25060 = (state_25078[(2)]);
var inst_25061 = fluree.db.flake.p.call(null,inst_25009);
var inst_25062 = cljs.core.get.call(null,inst_24913,inst_25061);
var state_25078__$1 = (function (){var statearr_25100 = state_25078;
(statearr_25100[(19)] = inst_25060);

return statearr_25100;
})();
if(cljs.core.truth_(inst_25062)){
var statearr_25101_25163 = state_25078__$1;
(statearr_25101_25163[(1)] = (37));

} else {
var statearr_25102_25164 = state_25078__$1;
(statearr_25102_25164[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (29))){
var inst_25021 = (state_25078[(16)]);
var inst_25032 = (state_25078[(2)]);
var inst_25033 = fluree.db.util.async.throw_err.call(null,inst_25032);
var inst_25034 = cljs.core.assoc.call(null,inst_25021,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_25033);
var state_25078__$1 = state_25078;
var statearr_25103_25165 = state_25078__$1;
(statearr_25103_25165[(2)] = inst_25034);

(statearr_25103_25165[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (6))){
var inst_24886 = (state_25078[(33)]);
var inst_24891 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_24892 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_24893 = ["Invalid with called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24891)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24892)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24886),"."].join('');
var inst_24894 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24895 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_24896 = cljs.core.PersistentHashMap.fromArrays(inst_24894,inst_24895);
var inst_24897 = cljs.core.ex_info.call(null,inst_24893,inst_24896);
var inst_24898 = (function(){throw inst_24897})();
var state_25078__$1 = state_25078;
var statearr_25104_25166 = state_25078__$1;
(statearr_25104_25166[(2)] = inst_24898);

(statearr_25104_25166[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (28))){
var inst_24916 = (state_25078[(29)]);
var inst_25037 = (state_25078[(2)]);
var state_25078__$1 = (function (){var statearr_25105 = state_25078;
(statearr_25105[(36)] = inst_25037);

return statearr_25105;
})();
if(cljs.core.truth_(inst_24916)){
var statearr_25106_25167 = state_25078__$1;
(statearr_25106_25167[(1)] = (30));

} else {
var statearr_25107_25168 = state_25078__$1;
(statearr_25107_25168[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (25))){
var inst_25028 = (state_25078[(2)]);
var state_25078__$1 = state_25078;
if(cljs.core.truth_(inst_25028)){
var statearr_25108_25169 = state_25078__$1;
(statearr_25108_25169[(1)] = (26));

} else {
var statearr_25109_25170 = state_25078__$1;
(statearr_25109_25170[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (34))){
var inst_25000 = (state_25078[(7)]);
var inst_25009 = (state_25078[(21)]);
var inst_25057 = cljs.core.conj.call(null,inst_25000,inst_25009);
var state_25078__$1 = state_25078;
var statearr_25110_25171 = state_25078__$1;
(statearr_25110_25171[(2)] = inst_25057);

(statearr_25110_25171[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (17))){
var inst_24944 = (state_25078[(37)]);
var inst_24948 = (state_25078[(2)]);
var inst_24949 = fluree.db.util.async.throw_err.call(null,inst_24948);
var inst_24936 = inst_24944;
var inst_24937 = inst_24949;
var state_25078__$1 = (function (){var statearr_25111 = state_25078;
(statearr_25111[(38)] = inst_24936);

(statearr_25111[(24)] = inst_24937);

return statearr_25111;
})();
var statearr_25112_25172 = state_25078__$1;
(statearr_25112_25172[(2)] = null);

(statearr_25112_25172[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (3))){
var inst_25076 = (state_25078[(2)]);
var state_25078__$1 = state_25078;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25078__$1,inst_25076);
} else {
if((state_val_25079 === (12))){
var inst_24943 = (state_25078[(39)]);
var inst_24936 = (state_25078[(38)]);
var inst_24942 = cljs.core.seq.call(null,inst_24936);
var inst_24943__$1 = cljs.core.first.call(null,inst_24942);
var inst_24944 = cljs.core.next.call(null,inst_24942);
var state_25078__$1 = (function (){var statearr_25113 = state_25078;
(statearr_25113[(39)] = inst_24943__$1);

(statearr_25113[(37)] = inst_24944);

return statearr_25113;
})();
if(cljs.core.truth_(inst_24943__$1)){
var statearr_25114_25173 = state_25078__$1;
(statearr_25114_25173[(1)] = (14));

} else {
var statearr_25115_25174 = state_25078__$1;
(statearr_25115_25174[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (2))){
var inst_24886 = (state_25078[(33)]);
var _ = (function (){var statearr_25116 = state_25078;
(statearr_25116[(4)] = cljs.core.cons.call(null,(5),(state_25078[(4)])));

return statearr_25116;
})();
var inst_24885 = cljs.core.first.call(null,flakes);
var inst_24886__$1 = fluree.db.flake.t.call(null,inst_24885);
var inst_24887 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_24888 = (inst_24887 - (1));
var inst_24889 = cljs.core.not_EQ_.call(null,inst_24886__$1,inst_24888);
var state_25078__$1 = (function (){var statearr_25117 = state_25078;
(statearr_25117[(33)] = inst_24886__$1);

return statearr_25117;
})();
if(inst_24889){
var statearr_25118_25175 = state_25078__$1;
(statearr_25118_25175[(1)] = (6));

} else {
var statearr_25119_25176 = state_25078__$1;
(statearr_25119_25176[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (23))){
var inst_24915 = (state_25078[(10)]);
var state_25078__$1 = state_25078;
var statearr_25120_25177 = state_25078__$1;
(statearr_25120_25177[(2)] = inst_24915);

(statearr_25120_25177[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (35))){
var inst_25000 = (state_25078[(7)]);
var state_25078__$1 = state_25078;
var statearr_25121_25178 = state_25078__$1;
(statearr_25121_25178[(2)] = inst_25000);

(statearr_25121_25178[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (19))){
var inst_25073 = (state_25078[(2)]);
var _ = (function (){var statearr_25122 = state_25078;
(statearr_25122[(4)] = cljs.core.rest.call(null,(state_25078[(4)])));

return statearr_25122;
})();
var state_25078__$1 = state_25078;
var statearr_25123_25179 = state_25078__$1;
(statearr_25123_25179[(2)] = inst_25073);

(statearr_25123_25179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (11))){
var inst_24924 = (state_25078[(34)]);
var inst_24924__$1 = (state_25078[(2)]);
var inst_24932 = cljs.core.seq.call(null,inst_24924__$1);
var inst_24933 = cljs.core.first.call(null,inst_24932);
var inst_24934 = cljs.core.next.call(null,inst_24932);
var inst_24935 = db;
var inst_24936 = inst_24924__$1;
var inst_24937 = inst_24935;
var state_25078__$1 = (function (){var statearr_25125 = state_25078;
(statearr_25125[(38)] = inst_24936);

(statearr_25125[(40)] = inst_24934);

(statearr_25125[(41)] = inst_24933);

(statearr_25125[(34)] = inst_24924__$1);

(statearr_25125[(24)] = inst_24937);

return statearr_25125;
})();
var statearr_25126_25180 = state_25078__$1;
(statearr_25126_25180[(2)] = null);

(statearr_25126_25180[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (9))){
var inst_24918 = (state_25078[(25)]);
var inst_24902 = (state_25078[(32)]);
var inst_24920 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_24902,inst_24918);
var state_25078__$1 = state_25078;
var statearr_25127_25181 = state_25078__$1;
(statearr_25127_25181[(2)] = inst_24920);

(statearr_25127_25181[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (5))){
var _ = (function (){var statearr_25128 = state_25078;
(statearr_25128[(4)] = cljs.core.rest.call(null,(state_25078[(4)])));

return statearr_25128;
})();
var state_25078__$1 = state_25078;
var ex25124 = (state_25078__$1[(2)]);
var statearr_25129_25182 = state_25078__$1;
(statearr_25129_25182[(5)] = ex25124);


if((ex25124 instanceof Error)){
var statearr_25130_25183 = state_25078__$1;
(statearr_25130_25183[(1)] = (4));

(statearr_25130_25183[(5)] = null);

} else {
throw ex25124;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (14))){
var inst_24943 = (state_25078[(39)]);
var inst_24937 = (state_25078[(24)]);
var inst_24946 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_24937,inst_24943,opts);
var state_25078__$1 = state_25078;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25078__$1,(17),inst_24946);
} else {
if((state_val_25079 === (26))){
var inst_25021 = (state_25078[(16)]);
var inst_25030 = fluree.db.query.schema.schema_map.call(null,inst_25021);
var state_25078__$1 = state_25078;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25078__$1,(29),inst_25030);
} else {
if((state_val_25079 === (16))){
var inst_24953 = (state_25078[(2)]);
var state_25078__$1 = state_25078;
var statearr_25131_25184 = state_25078__$1;
(statearr_25131_25184[(2)] = inst_24953);

(statearr_25131_25184[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (38))){
var inst_25001 = (state_25078[(9)]);
var state_25078__$1 = state_25078;
var statearr_25132_25185 = state_25078__$1;
(statearr_25132_25185[(2)] = inst_25001);

(statearr_25132_25185[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (30))){
var inst_25021 = (state_25078[(16)]);
var inst_25039 = fluree.db.query.schema.setting_map.call(null,inst_25021);
var state_25078__$1 = state_25078;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25078__$1,(33),inst_25039);
} else {
if((state_val_25079 === (10))){
var inst_24922 = cljs.core.PersistentVector.EMPTY;
var state_25078__$1 = state_25078;
var statearr_25133_25186 = state_25078__$1;
(statearr_25133_25186[(2)] = inst_24922);

(statearr_25133_25186[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (18))){
var inst_24997 = (state_25078[(23)]);
var inst_25009 = (state_25078[(21)]);
var inst_25008 = cljs.core.seq.call(null,inst_24997);
var inst_25009__$1 = cljs.core.first.call(null,inst_25008);
var inst_25010 = cljs.core.next.call(null,inst_25008);
var inst_25011 = cljs.core.not.call(null,inst_25009__$1);
var state_25078__$1 = (function (){var statearr_25134 = state_25078;
(statearr_25134[(21)] = inst_25009__$1);

(statearr_25134[(22)] = inst_25010);

return statearr_25134;
})();
if(inst_25011){
var statearr_25135_25187 = state_25078__$1;
(statearr_25135_25187[(1)] = (20));

} else {
var statearr_25136_25188 = state_25078__$1;
(statearr_25136_25188[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (37))){
var inst_25001 = (state_25078[(9)]);
var inst_25009 = (state_25078[(21)]);
var inst_25064 = cljs.core.conj.call(null,inst_25001,inst_25009);
var state_25078__$1 = state_25078;
var statearr_25137_25189 = state_25078__$1;
(statearr_25137_25189[(2)] = inst_25064);

(statearr_25137_25189[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25079 === (8))){
var inst_24909 = (state_25078[(26)]);
var inst_24905 = (state_25078[(27)]);
var inst_24901 = (state_25078[(28)]);
var inst_24915 = (state_25078[(10)]);
var inst_24902 = (state_25078[(32)]);
var inst_24886 = (state_25078[(33)]);
var inst_24901__$1 = (state_25078[(2)]);
var inst_24902__$1 = cljs.core.filter.call(null,fluree.db.graphdb.include_flake_QMARK_,flakes);
var inst_24903 = cljs.core.PersistentHashSet.EMPTY;
var inst_24904 = cljs.core.map.call(null,fluree.db.flake.p,inst_24902__$1);
var inst_24905__$1 = cljs.core.into.call(null,inst_24903,inst_24904);
var inst_24906 = cljs.core.PersistentHashMap.EMPTY;
var inst_24907 = (function (){var t = inst_24886;
var _ = inst_24901__$1;
var add_flakes = inst_24902__$1;
var add_preds = inst_24905__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_24908 = cljs.core.map.call(null,inst_24907,inst_24905__$1);
var inst_24909__$1 = cljs.core.into.call(null,inst_24906,inst_24908);
var inst_24910 = cljs.core.PersistentHashMap.EMPTY;
var inst_24911 = (function (){var t = inst_24886;
var _ = inst_24901__$1;
var add_flakes = inst_24902__$1;
var add_preds = inst_24905__$1;
var idx_QMARK__map = inst_24909__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_24912 = cljs.core.map.call(null,inst_24911,inst_24905__$1);
var inst_24913 = cljs.core.into.call(null,inst_24910,inst_24912);
var inst_24914 = fluree.db.flake.size_bytes.call(null,inst_24902__$1);
var inst_24915__$1 = fluree.db.util.schema.system_change_QMARK_.call(null,inst_24902__$1);
var inst_24916 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_24902__$1);
var inst_24917 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_24918 = cljs.core.get.call(null,inst_24917,(0));
var state_25078__$1 = (function (){var statearr_25138 = state_25078;
(statearr_25138[(25)] = inst_24918);

(statearr_25138[(26)] = inst_24909__$1);

(statearr_25138[(27)] = inst_24905__$1);

(statearr_25138[(28)] = inst_24901__$1);

(statearr_25138[(10)] = inst_24915__$1);

(statearr_25138[(29)] = inst_24916);

(statearr_25138[(11)] = inst_24914);

(statearr_25138[(31)] = inst_24913);

(statearr_25138[(32)] = inst_24902__$1);

return statearr_25138;
})();
if(cljs.core.truth_(inst_24915__$1)){
var statearr_25139_25190 = state_25078__$1;
(statearr_25139_25190[(1)] = (9));

} else {
var statearr_25140_25191 = state_25078__$1;
(statearr_25140_25191[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_25141 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25141[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_25141[(1)] = (1));

return statearr_25141;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_25078){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_25078);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25142){var ex__2730__auto__ = e25142;
var statearr_25143_25192 = state_25078;
(statearr_25143_25192[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_25078[(4)]))){
var statearr_25144_25193 = state_25078;
(statearr_25144_25193[(1)] = cljs.core.first.call(null,(state_25078[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25194 = state_25078;
state_25078 = G__25194;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_25078){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_25078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25145 = f__2750__auto__.call(null);
(statearr_25145[(6)] = c__2749__auto__);

return statearr_25145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__25196 = arguments.length;
switch (G__25196) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2749__auto___25343 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25292){
var state_val_25293 = (state_25292[(1)]);
if((state_val_25293 === (7))){
var state_25292__$1 = state_25292;
var statearr_25294_25344 = state_25292__$1;
(statearr_25294_25344[(2)] = null);

(statearr_25294_25344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (20))){
var inst_25242 = (state_25292[(7)]);
var inst_25241 = (state_25292[(8)]);
var inst_25240 = (state_25292[(9)]);
var inst_25261 = (inst_25240 + (1));
var inst_25262 = cljs.core.assoc.call(null,inst_25242,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25261);
var inst_25263 = fluree.db.graphdb.with_t.call(null,inst_25262,inst_25241,opts);
var state_25292__$1 = state_25292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25292__$1,(23),inst_25263);
} else {
if((state_val_25293 === (1))){
var state_25292__$1 = state_25292;
var statearr_25295_25345 = state_25292__$1;
(statearr_25295_25345[(2)] = null);

(statearr_25295_25345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (24))){
var inst_25266 = (state_25292[(10)]);
var inst_25269 = cljs.core.assoc.call(null,inst_25266,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_25292__$1 = state_25292;
var statearr_25296_25346 = state_25292__$1;
(statearr_25296_25346[(2)] = inst_25269);

(statearr_25296_25346[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (4))){
var inst_25197 = (state_25292[(2)]);
var inst_25198 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_25197);
var state_25292__$1 = state_25292;
var statearr_25297_25347 = state_25292__$1;
(statearr_25297_25347[(2)] = inst_25198);

(statearr_25297_25347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (15))){
var inst_25248 = (state_25292[(11)]);
var state_25292__$1 = state_25292;
var statearr_25298_25348 = state_25292__$1;
(statearr_25298_25348[(2)] = inst_25248);

(statearr_25298_25348[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (21))){
var state_25292__$1 = state_25292;
var statearr_25299_25349 = state_25292__$1;
(statearr_25299_25349[(2)] = null);

(statearr_25299_25349[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (13))){
var inst_25284 = (state_25292[(2)]);
var inst_25285 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_25284);
var state_25292__$1 = state_25292;
var statearr_25300_25350 = state_25292__$1;
(statearr_25300_25350[(2)] = inst_25285);

(statearr_25300_25350[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (22))){
var inst_25280 = (state_25292[(2)]);
var state_25292__$1 = state_25292;
var statearr_25301_25351 = state_25292__$1;
(statearr_25301_25351[(2)] = inst_25280);

(statearr_25301_25351[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (6))){
var inst_25208 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25209 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_25210 = ["Invalid 'with' called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25208)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25209)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_25211 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25212 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25213 = cljs.core.PersistentHashMap.fromArrays(inst_25211,inst_25212);
var inst_25214 = cljs.core.ex_info.call(null,inst_25210,inst_25213);
var inst_25215 = (function(){throw inst_25214})();
var state_25292__$1 = state_25292;
var statearr_25304_25352 = state_25292__$1;
(statearr_25304_25352[(2)] = inst_25215);

(statearr_25304_25352[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (25))){
var inst_25248 = (state_25292[(11)]);
var inst_25249 = (state_25292[(12)]);
var inst_25266 = (state_25292[(10)]);
var inst_25271 = fluree.db.flake.t.call(null,inst_25248);
var inst_25272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25273 = [inst_25248];
var inst_25274 = (new cljs.core.PersistentVector(null,1,(5),inst_25272,inst_25273,null));
var inst_25239 = inst_25249;
var inst_25240 = inst_25271;
var inst_25241 = inst_25274;
var inst_25242 = inst_25266;
var state_25292__$1 = (function (){var statearr_25305 = state_25292;
(statearr_25305[(7)] = inst_25242);

(statearr_25305[(8)] = inst_25241);

(statearr_25305[(9)] = inst_25240);

(statearr_25305[(13)] = inst_25239);

return statearr_25305;
})();
var statearr_25306_25353 = state_25292__$1;
(statearr_25306_25353[(2)] = null);

(statearr_25306_25353[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (17))){
var inst_25242 = (state_25292[(7)]);
var inst_25241 = (state_25292[(8)]);
var inst_25248 = (state_25292[(11)]);
var inst_25240 = (state_25292[(9)]);
var inst_25249 = (state_25292[(12)]);
var inst_25257 = cljs.core.conj.call(null,inst_25241,inst_25248);
var tmp25302 = inst_25242;
var tmp25303 = inst_25240;
var inst_25239 = inst_25249;
var inst_25240__$1 = tmp25303;
var inst_25241__$1 = inst_25257;
var inst_25242__$1 = tmp25302;
var state_25292__$1 = (function (){var statearr_25307 = state_25292;
(statearr_25307[(7)] = inst_25242__$1);

(statearr_25307[(8)] = inst_25241__$1);

(statearr_25307[(9)] = inst_25240__$1);

(statearr_25307[(13)] = inst_25239);

return statearr_25307;
})();
var statearr_25308_25354 = state_25292__$1;
(statearr_25308_25354[(2)] = null);

(statearr_25308_25354[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (3))){
var inst_25290 = (state_25292[(2)]);
var state_25292__$1 = state_25292;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25292__$1,inst_25290);
} else {
if((state_val_25293 === (12))){
var inst_25248 = (state_25292[(11)]);
var inst_25239 = (state_25292[(13)]);
var inst_25247 = cljs.core.seq.call(null,inst_25239);
var inst_25248__$1 = cljs.core.first.call(null,inst_25247);
var inst_25249 = cljs.core.next.call(null,inst_25247);
var state_25292__$1 = (function (){var statearr_25309 = state_25292;
(statearr_25309[(11)] = inst_25248__$1);

(statearr_25309[(12)] = inst_25249);

return statearr_25309;
})();
if(cljs.core.truth_(inst_25248__$1)){
var statearr_25310_25355 = state_25292__$1;
(statearr_25310_25355[(1)] = (14));

} else {
var statearr_25311_25356 = state_25292__$1;
(statearr_25311_25356[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (2))){
var _ = (function (){var statearr_25312 = state_25292;
(statearr_25312[(4)] = cljs.core.cons.call(null,(5),(state_25292[(4)])));

return statearr_25312;
})();
var inst_25204 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_25205 = (inst_25204 + (1));
var inst_25206 = cljs.core.not_EQ_.call(null,block,inst_25205);
var state_25292__$1 = state_25292;
if(inst_25206){
var statearr_25313_25357 = state_25292__$1;
(statearr_25313_25357[(1)] = (6));

} else {
var statearr_25314_25358 = state_25292__$1;
(statearr_25314_25358[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (23))){
var inst_25248 = (state_25292[(11)]);
var inst_25265 = (state_25292[(2)]);
var inst_25266 = fluree.db.util.async.throw_err.call(null,inst_25265);
var inst_25267 = (inst_25248 == null);
var state_25292__$1 = (function (){var statearr_25315 = state_25292;
(statearr_25315[(10)] = inst_25266);

return statearr_25315;
})();
if(cljs.core.truth_(inst_25267)){
var statearr_25316_25359 = state_25292__$1;
(statearr_25316_25359[(1)] = (24));

} else {
var statearr_25317_25360 = state_25292__$1;
(statearr_25317_25360[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (19))){
var inst_25282 = (state_25292[(2)]);
var state_25292__$1 = state_25292;
var statearr_25318_25361 = state_25292__$1;
(statearr_25318_25361[(2)] = inst_25282);

(statearr_25318_25361[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (11))){
var inst_25287 = (state_25292[(2)]);
var _ = (function (){var statearr_25320 = state_25292;
(statearr_25320[(4)] = cljs.core.rest.call(null,(state_25292[(4)])));

return statearr_25320;
})();
var state_25292__$1 = state_25292;
var statearr_25321_25362 = state_25292__$1;
(statearr_25321_25362[(2)] = inst_25287);

(statearr_25321_25362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (9))){
var inst_25221 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_25222 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_25221);
var state_25292__$1 = state_25292;
var statearr_25322_25363 = state_25292__$1;
(statearr_25322_25363[(2)] = inst_25222);

(statearr_25322_25363[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (5))){
var _ = (function (){var statearr_25323 = state_25292;
(statearr_25323[(4)] = cljs.core.rest.call(null,(state_25292[(4)])));

return statearr_25323;
})();
var state_25292__$1 = state_25292;
var ex25319 = (state_25292__$1[(2)]);
var statearr_25324_25364 = state_25292__$1;
(statearr_25324_25364[(5)] = ex25319);


var statearr_25325_25365 = state_25292__$1;
(statearr_25325_25365[(1)] = (4));

(statearr_25325_25365[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (14))){
var inst_25248 = (state_25292[(11)]);
var inst_25240 = (state_25292[(9)]);
var inst_25251 = fluree.db.flake.t.call(null,inst_25248);
var inst_25252 = cljs.core._EQ_.call(null,inst_25240,inst_25251);
var state_25292__$1 = state_25292;
var statearr_25326_25366 = state_25292__$1;
(statearr_25326_25366[(2)] = inst_25252);

(statearr_25326_25366[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (26))){
var inst_25277 = (state_25292[(2)]);
var state_25292__$1 = state_25292;
var statearr_25327_25367 = state_25292__$1;
(statearr_25327_25367[(2)] = inst_25277);

(statearr_25327_25367[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (16))){
var inst_25255 = (state_25292[(2)]);
var state_25292__$1 = state_25292;
if(cljs.core.truth_(inst_25255)){
var statearr_25328_25368 = state_25292__$1;
(statearr_25328_25368[(1)] = (17));

} else {
var statearr_25329_25369 = state_25292__$1;
(statearr_25329_25369[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (10))){
var inst_25224 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_25232 = cljs.core.seq.call(null,inst_25224);
var inst_25233 = cljs.core.first.call(null,inst_25232);
var inst_25234 = cljs.core.next.call(null,inst_25232);
var inst_25235 = cljs.core.first.call(null,inst_25224);
var inst_25236 = fluree.db.flake.t.call(null,inst_25235);
var inst_25237 = cljs.core.PersistentVector.EMPTY;
var inst_25238 = db;
var inst_25239 = inst_25224;
var inst_25240 = inst_25236;
var inst_25241 = inst_25237;
var inst_25242 = inst_25238;
var state_25292__$1 = (function (){var statearr_25330 = state_25292;
(statearr_25330[(7)] = inst_25242);

(statearr_25330[(14)] = inst_25234);

(statearr_25330[(8)] = inst_25241);

(statearr_25330[(15)] = inst_25233);

(statearr_25330[(9)] = inst_25240);

(statearr_25330[(13)] = inst_25239);

return statearr_25330;
})();
var statearr_25331_25370 = state_25292__$1;
(statearr_25331_25370[(2)] = null);

(statearr_25331_25370[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (18))){
var state_25292__$1 = state_25292;
var statearr_25332_25371 = state_25292__$1;
(statearr_25332_25371[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25293 === (8))){
var inst_25218 = (state_25292[(2)]);
var inst_25219 = cljs.core.empty_QMARK_.call(null,flakes);
var state_25292__$1 = (function (){var statearr_25334 = state_25292;
(statearr_25334[(16)] = inst_25218);

return statearr_25334;
})();
if(inst_25219){
var statearr_25335_25372 = state_25292__$1;
(statearr_25335_25372[(1)] = (9));

} else {
var statearr_25336_25373 = state_25292__$1;
(statearr_25336_25373[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_25337 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25337[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_25337[(1)] = (1));

return statearr_25337;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_25292){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_25292);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25338){var ex__2730__auto__ = e25338;
var statearr_25339_25374 = state_25292;
(statearr_25339_25374[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_25292[(4)]))){
var statearr_25340_25375 = state_25292;
(statearr_25340_25375[(1)] = cljs.core.first.call(null,(state_25292[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25376 = state_25292;
state_25292 = G__25376;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_25292){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_25292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25341 = f__2750__auto__.call(null);
(statearr_25341[(6)] = c__2749__auto___25343);

return statearr_25341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25428){
var state_val_25429 = (state_25428[(1)]);
if((state_val_25429 === (7))){
var state_25428__$1 = state_25428;
var statearr_25430_25457 = state_25428__$1;
(statearr_25430_25457[(2)] = tt_id);

(statearr_25430_25457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25429 === (1))){
var state_25428__$1 = state_25428;
var statearr_25431_25458 = state_25428__$1;
(statearr_25431_25458[(2)] = null);

(statearr_25431_25458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25429 === (4))){
var inst_25377 = (state_25428[(2)]);
var state_25428__$1 = state_25428;
var statearr_25432_25459 = state_25428__$1;
(statearr_25432_25459[(2)] = inst_25377);

(statearr_25432_25459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25429 === (13))){
var inst_25421 = (state_25428[(2)]);
var state_25428__$1 = state_25428;
var statearr_25433_25460 = state_25428__$1;
(statearr_25433_25460[(2)] = inst_25421);

(statearr_25433_25460[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25429 === (6))){
var inst_25385 = cljs.core.random_uuid.call(null);
var state_25428__$1 = state_25428;
var statearr_25434_25461 = state_25428__$1;
(statearr_25434_25461[(2)] = inst_25385);

(statearr_25434_25461[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25429 === (3))){
var inst_25426 = (state_25428[(2)]);
var state_25428__$1 = state_25428;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25428__$1,inst_25426);
} else {
if((state_val_25429 === (12))){
var inst_25404 = (state_25428[(7)]);
var state_25428__$1 = state_25428;
var statearr_25435_25462 = state_25428__$1;
(statearr_25435_25462[(2)] = inst_25404);

(statearr_25435_25462[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25429 === (2))){
var _ = (function (){var statearr_25436 = state_25428;
(statearr_25436[(4)] = cljs.core.cons.call(null,(5),(state_25428[(4)])));

return statearr_25436;
})();
var inst_25383 = (tt_id == null);
var state_25428__$1 = state_25428;
if(cljs.core.truth_(inst_25383)){
var statearr_25437_25463 = state_25428__$1;
(statearr_25437_25463[(1)] = (6));

} else {
var statearr_25438_25464 = state_25428__$1;
(statearr_25438_25464[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25429 === (11))){
var inst_25411 = (state_25428[(8)]);
var inst_25404 = (state_25428[(7)]);
var inst_25414 = fluree.db.graphdb.with_t.call(null,inst_25404,inst_25411);
var state_25428__$1 = state_25428;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25428__$1,(14),inst_25414);
} else {
if((state_val_25429 === (9))){
var inst_25411 = (state_25428[(8)]);
var inst_25405 = (state_25428[(9)]);
var inst_25410 = cljs.core.seq.call(null,inst_25405);
var inst_25411__$1 = cljs.core.first.call(null,inst_25410);
var inst_25412 = cljs.core.next.call(null,inst_25410);
var state_25428__$1 = (function (){var statearr_25440 = state_25428;
(statearr_25440[(8)] = inst_25411__$1);

(statearr_25440[(10)] = inst_25412);

return statearr_25440;
})();
if(cljs.core.truth_(inst_25411__$1)){
var statearr_25441_25465 = state_25428__$1;
(statearr_25441_25465[(1)] = (11));

} else {
var statearr_25442_25466 = state_25428__$1;
(statearr_25442_25466[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25429 === (5))){
var _ = (function (){var statearr_25443 = state_25428;
(statearr_25443[(4)] = cljs.core.rest.call(null,(state_25428[(4)])));

return statearr_25443;
})();
var state_25428__$1 = state_25428;
var ex25439 = (state_25428__$1[(2)]);
var statearr_25444_25467 = state_25428__$1;
(statearr_25444_25467[(5)] = ex25439);


if((ex25439 instanceof Error)){
var statearr_25445_25468 = state_25428__$1;
(statearr_25445_25468[(1)] = (4));

(statearr_25445_25468[(5)] = null);

} else {
throw ex25439;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25429 === (14))){
var inst_25412 = (state_25428[(10)]);
var inst_25416 = (state_25428[(2)]);
var inst_25417 = fluree.db.util.async.throw_err.call(null,inst_25416);
var inst_25404 = inst_25417;
var inst_25405 = inst_25412;
var state_25428__$1 = (function (){var statearr_25446 = state_25428;
(statearr_25446[(9)] = inst_25405);

(statearr_25446[(7)] = inst_25404);

return statearr_25446;
})();
var statearr_25447_25469 = state_25428__$1;
(statearr_25447_25469[(2)] = null);

(statearr_25447_25469[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25429 === (10))){
var inst_25423 = (state_25428[(2)]);
var _ = (function (){var statearr_25448 = state_25428;
(statearr_25448[(4)] = cljs.core.rest.call(null,(state_25428[(4)])));

return statearr_25448;
})();
var state_25428__$1 = state_25428;
var statearr_25449_25470 = state_25428__$1;
(statearr_25449_25470[(2)] = inst_25423);

(statearr_25449_25470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25429 === (8))){
var inst_25388 = (state_25428[(2)]);
var inst_25389 = (function (){var tt_id__$1 = inst_25388;
return (function (db_STAR_,idx){
return cljs.core.update.call(null,db_STAR_,idx,cljs.core.assoc,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id__$1);
});
})();
var inst_25390 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_25388);
var inst_25391 = cljs.core.reduce.call(null,inst_25389,inst_25390,fluree.db.index.types);
var inst_25392 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),fluree.db.flake.cmp_tx,flakes);
var inst_25393 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25392);
var inst_25401 = cljs.core.seq.call(null,inst_25393);
var inst_25402 = cljs.core.first.call(null,inst_25401);
var inst_25403 = cljs.core.next.call(null,inst_25401);
var inst_25404 = inst_25391;
var inst_25405 = inst_25393;
var state_25428__$1 = (function (){var statearr_25450 = state_25428;
(statearr_25450[(9)] = inst_25405);

(statearr_25450[(11)] = inst_25402);

(statearr_25450[(7)] = inst_25404);

(statearr_25450[(12)] = inst_25403);

return statearr_25450;
})();
var statearr_25451_25471 = state_25428__$1;
(statearr_25451_25471[(2)] = null);

(statearr_25451_25471[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0 = (function (){
var statearr_25452 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25452[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__);

(statearr_25452[(1)] = (1));

return statearr_25452;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1 = (function (state_25428){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_25428);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25453){var ex__2730__auto__ = e25453;
var statearr_25454_25472 = state_25428;
(statearr_25454_25472[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_25428[(4)]))){
var statearr_25455_25473 = state_25428;
(statearr_25455_25473[(1)] = cljs.core.first.call(null,(state_25428[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25474 = state_25428;
state_25428 = G__25474;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__ = function(state_25428){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1.call(this,state_25428);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25456 = f__2750__auto__.call(null);
(statearr_25456[(6)] = c__2749__auto__);

return statearr_25456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2749__auto___25661 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25592){
var state_val_25593 = (state_25592[(1)]);
if((state_val_25593 === (7))){
var inst_25502 = (state_25592[(7)]);
var inst_25502__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_25592__$1 = (function (){var statearr_25594 = state_25592;
(statearr_25594[(7)] = inst_25502__$1);

return statearr_25594;
})();
if(inst_25502__$1){
var statearr_25595_25662 = state_25592__$1;
(statearr_25595_25662[(1)] = (13));

} else {
var statearr_25596_25663 = state_25592__$1;
(statearr_25596_25663[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (20))){
var state_25592__$1 = state_25592;
var statearr_25597_25664 = state_25592__$1;
(statearr_25597_25664[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (27))){
var inst_25538 = (state_25592[(8)]);
var inst_25542 = fluree.db.flake.s.call(null,inst_25538);
var state_25592__$1 = state_25592;
var statearr_25599_25665 = state_25592__$1;
(statearr_25599_25665[(2)] = inst_25542);

(statearr_25599_25665[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (1))){
var state_25592__$1 = state_25592;
var statearr_25600_25666 = state_25592__$1;
(statearr_25600_25666[(2)] = null);

(statearr_25600_25666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (24))){
var inst_25532 = (state_25592[(9)]);
var inst_25536 = cljs.core.first.call(null,inst_25532);
var state_25592__$1 = state_25592;
var statearr_25601_25667 = state_25592__$1;
(statearr_25601_25667[(2)] = inst_25536);

(statearr_25601_25667[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (39))){
var state_25592__$1 = state_25592;
var statearr_25602_25668 = state_25592__$1;
(statearr_25602_25668[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (4))){
var inst_25475 = (state_25592[(2)]);
var inst_25476 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_25477 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25478 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_25479 = cljs.core.PersistentHashMap.fromArrays(inst_25477,inst_25478);
var inst_25480 = cljs.core.ex_info.call(null,inst_25476,inst_25479,inst_25475);
var inst_25481 = cljs.core.async.put_BANG_.call(null,return_chan,inst_25480);
var state_25592__$1 = state_25592;
var statearr_25604_25669 = state_25592__$1;
(statearr_25604_25669[(2)] = inst_25481);

(statearr_25604_25669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (15))){
var inst_25509 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
if(cljs.core.truth_(inst_25509)){
var statearr_25605_25670 = state_25592__$1;
(statearr_25605_25670[(1)] = (16));

} else {
var statearr_25606_25671 = state_25592__$1;
(statearr_25606_25671[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (21))){
var inst_25558 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
var statearr_25607_25672 = state_25592__$1;
(statearr_25607_25672[(2)] = inst_25558);

(statearr_25607_25672[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (31))){
var inst_25556 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
var statearr_25608_25673 = state_25592__$1;
(statearr_25608_25673[(2)] = inst_25556);

(statearr_25608_25673[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (32))){
var inst_25562 = (state_25592[(10)]);
var inst_25564 = cljs.core.async.put_BANG_.call(null,return_chan,inst_25562);
var state_25592__$1 = state_25592;
var statearr_25609_25674 = state_25592__$1;
(statearr_25609_25674[(2)] = inst_25564);

(statearr_25609_25674[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (40))){
var inst_25585 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
var statearr_25610_25675 = state_25592__$1;
(statearr_25610_25675[(2)] = inst_25585);

(statearr_25610_25675[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (33))){
var inst_25562 = (state_25592[(10)]);
var inst_25566 = (state_25592[(11)]);
var inst_25566__$1 = (inst_25562 == null);
var state_25592__$1 = (function (){var statearr_25611 = state_25592;
(statearr_25611[(11)] = inst_25566__$1);

return statearr_25611;
})();
if(cljs.core.truth_(inst_25566__$1)){
var statearr_25612_25676 = state_25592__$1;
(statearr_25612_25676[(1)] = (35));

} else {
var statearr_25613_25677 = state_25592__$1;
(statearr_25613_25677[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (13))){
var inst_25504 = cljs.core.first.call(null,ident);
var inst_25505 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_25504);
var inst_25506 = (inst_25505 == null);
var state_25592__$1 = state_25592;
var statearr_25614_25678 = state_25592__$1;
(statearr_25614_25678[(2)] = inst_25506);

(statearr_25614_25678[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (22))){
var inst_25532 = (state_25592[(9)]);
var inst_25531 = (state_25592[(2)]);
var inst_25532__$1 = fluree.db.util.async.throw_err.call(null,inst_25531);
var inst_25533 = (inst_25532__$1 == null);
var state_25592__$1 = (function (){var statearr_25615 = state_25592;
(statearr_25615[(9)] = inst_25532__$1);

return statearr_25615;
})();
if(cljs.core.truth_(inst_25533)){
var statearr_25616_25679 = state_25592__$1;
(statearr_25616_25679[(1)] = (23));

} else {
var statearr_25617_25680 = state_25592__$1;
(statearr_25617_25680[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (36))){
var inst_25566 = (state_25592[(11)]);
var state_25592__$1 = state_25592;
var statearr_25618_25681 = state_25592__$1;
(statearr_25618_25681[(2)] = inst_25566);

(statearr_25618_25681[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (41))){
var inst_25580 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_25592__$1 = state_25592;
var statearr_25619_25682 = state_25592__$1;
(statearr_25619_25682[(2)] = inst_25580);

(statearr_25619_25682[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (43))){
var inst_25583 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
var statearr_25620_25683 = state_25592__$1;
(statearr_25620_25683[(2)] = inst_25583);

(statearr_25620_25683[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (29))){
var inst_25547 = cljs.core.pr_str.call(null,ident);
var inst_25548 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_25547].join('');
var inst_25549 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25550 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_25551 = cljs.core.PersistentHashMap.fromArrays(inst_25549,inst_25550);
var inst_25552 = cljs.core.ex_info.call(null,inst_25548,inst_25551);
var inst_25553 = (function(){throw inst_25552})();
var state_25592__$1 = state_25592;
var statearr_25621_25684 = state_25592__$1;
(statearr_25621_25684[(2)] = inst_25553);

(statearr_25621_25684[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (6))){
var inst_25489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25490 = [ident];
var inst_25491 = (new cljs.core.PersistentVector(null,1,(5),inst_25489,inst_25490,null));
var inst_25492 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_25491);
var state_25592__$1 = state_25592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25592__$1,(9),inst_25492);
} else {
if((state_val_25593 === (28))){
var inst_25544 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
var statearr_25622_25685 = state_25592__$1;
(statearr_25622_25685[(2)] = inst_25544);

(statearr_25622_25685[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (25))){
var inst_25538 = (state_25592[(8)]);
var inst_25538__$1 = (state_25592[(2)]);
var inst_25539 = (inst_25538__$1 == null);
var state_25592__$1 = (function (){var statearr_25623 = state_25592;
(statearr_25623[(8)] = inst_25538__$1);

return statearr_25623;
})();
if(cljs.core.truth_(inst_25539)){
var statearr_25624_25686 = state_25592__$1;
(statearr_25624_25686[(1)] = (26));

} else {
var statearr_25625_25687 = state_25592__$1;
(statearr_25625_25687[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (34))){
var inst_25587 = (state_25592[(2)]);
var _ = (function (){var statearr_25626 = state_25592;
(statearr_25626[(4)] = cljs.core.rest.call(null,(state_25592[(4)])));

return statearr_25626;
})();
var state_25592__$1 = state_25592;
var statearr_25627_25688 = state_25592__$1;
(statearr_25627_25688[(2)] = inst_25587);

(statearr_25627_25688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (17))){
var inst_25520 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_25592__$1 = state_25592;
if(inst_25520){
var statearr_25628_25689 = state_25592__$1;
(statearr_25628_25689[(1)] = (19));

} else {
var statearr_25629_25690 = state_25592__$1;
(statearr_25629_25690[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (3))){
var inst_25590 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25592__$1,inst_25590);
} else {
if((state_val_25593 === (12))){
var inst_25500 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
var statearr_25630_25691 = state_25592__$1;
(statearr_25630_25691[(2)] = inst_25500);

(statearr_25630_25691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (2))){
var _ = (function (){var statearr_25631 = state_25592;
(statearr_25631[(4)] = cljs.core.cons.call(null,(5),(state_25592[(4)])));

return statearr_25631;
})();
var inst_25487 = typeof ident === 'number';
var state_25592__$1 = state_25592;
if(cljs.core.truth_(inst_25487)){
var statearr_25632_25692 = state_25592__$1;
(statearr_25632_25692[(1)] = (6));

} else {
var statearr_25633_25693 = state_25592__$1;
(statearr_25633_25693[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (23))){
var state_25592__$1 = state_25592;
var statearr_25634_25694 = state_25592__$1;
(statearr_25634_25694[(2)] = null);

(statearr_25634_25694[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (35))){
var state_25592__$1 = state_25592;
var statearr_25635_25695 = state_25592__$1;
(statearr_25635_25695[(2)] = strict_QMARK_);

(statearr_25635_25695[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (19))){
var inst_25523 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25524 = cljs.core.first.call(null,ident);
var inst_25525 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_25524);
var inst_25526 = cljs.core.second.call(null,ident);
var inst_25527 = [inst_25525,inst_25526];
var inst_25528 = (new cljs.core.PersistentVector(null,2,(5),inst_25523,inst_25527,null));
var inst_25529 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_25528);
var state_25592__$1 = state_25592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25592__$1,(22),inst_25529);
} else {
if((state_val_25593 === (11))){
var state_25592__$1 = state_25592;
var statearr_25637_25696 = state_25592__$1;
(statearr_25637_25696[(2)] = null);

(statearr_25637_25696[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (9))){
var inst_25494 = (state_25592[(2)]);
var inst_25495 = fluree.db.util.async.throw_err.call(null,inst_25494);
var inst_25496 = cljs.core.not_empty.call(null,inst_25495);
var state_25592__$1 = state_25592;
if(cljs.core.truth_(inst_25496)){
var statearr_25638_25697 = state_25592__$1;
(statearr_25638_25697[(1)] = (10));

} else {
var statearr_25639_25698 = state_25592__$1;
(statearr_25639_25698[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (5))){
var _ = (function (){var statearr_25640 = state_25592;
(statearr_25640[(4)] = cljs.core.rest.call(null,(state_25592[(4)])));

return statearr_25640;
})();
var state_25592__$1 = state_25592;
var ex25636 = (state_25592__$1[(2)]);
var statearr_25641_25699 = state_25592__$1;
(statearr_25641_25699[(5)] = ex25636);


var statearr_25642_25700 = state_25592__$1;
(statearr_25642_25700[(1)] = (4));

(statearr_25642_25700[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (14))){
var inst_25502 = (state_25592[(7)]);
var state_25592__$1 = state_25592;
var statearr_25643_25701 = state_25592__$1;
(statearr_25643_25701[(2)] = inst_25502);

(statearr_25643_25701[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (26))){
var state_25592__$1 = state_25592;
var statearr_25644_25702 = state_25592__$1;
(statearr_25644_25702[(2)] = null);

(statearr_25644_25702[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (16))){
var inst_25511 = cljs.core.first.call(null,ident);
var inst_25512 = cljs.core.pr_str.call(null,inst_25511);
var inst_25513 = ["Subject ID lookup failed. The predicate ",inst_25512," does not exist."].join('');
var inst_25514 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25515 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_25516 = cljs.core.PersistentHashMap.fromArrays(inst_25514,inst_25515);
var inst_25517 = cljs.core.ex_info.call(null,inst_25513,inst_25516);
var inst_25518 = (function(){throw inst_25517})();
var state_25592__$1 = state_25592;
var statearr_25645_25703 = state_25592__$1;
(statearr_25645_25703[(2)] = inst_25518);

(statearr_25645_25703[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (38))){
var inst_25572 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_25573 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25574 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_25575 = cljs.core.PersistentHashMap.fromArrays(inst_25573,inst_25574);
var inst_25576 = cljs.core.ex_info.call(null,inst_25572,inst_25575);
var inst_25577 = cljs.core.async.put_BANG_.call(null,return_chan,inst_25576);
var state_25592__$1 = state_25592;
var statearr_25646_25704 = state_25592__$1;
(statearr_25646_25704[(2)] = inst_25577);

(statearr_25646_25704[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (30))){
var state_25592__$1 = state_25592;
var statearr_25647_25705 = state_25592__$1;
(statearr_25647_25705[(2)] = null);

(statearr_25647_25705[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (10))){
var state_25592__$1 = state_25592;
var statearr_25648_25706 = state_25592__$1;
(statearr_25648_25706[(2)] = ident);

(statearr_25648_25706[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (18))){
var inst_25560 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
var statearr_25649_25707 = state_25592__$1;
(statearr_25649_25707[(2)] = inst_25560);

(statearr_25649_25707[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (42))){
var state_25592__$1 = state_25592;
var statearr_25650_25708 = state_25592__$1;
(statearr_25650_25708[(2)] = null);

(statearr_25650_25708[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (37))){
var inst_25570 = (state_25592[(2)]);
var state_25592__$1 = state_25592;
if(cljs.core.truth_(inst_25570)){
var statearr_25651_25709 = state_25592__$1;
(statearr_25651_25709[(1)] = (38));

} else {
var statearr_25652_25710 = state_25592__$1;
(statearr_25652_25710[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25593 === (8))){
var inst_25562 = (state_25592[(10)]);
var inst_25562__$1 = (state_25592[(2)]);
var state_25592__$1 = (function (){var statearr_25653 = state_25592;
(statearr_25653[(10)] = inst_25562__$1);

return statearr_25653;
})();
if(cljs.core.truth_(inst_25562__$1)){
var statearr_25654_25711 = state_25592__$1;
(statearr_25654_25711[(1)] = (32));

} else {
var statearr_25655_25712 = state_25592__$1;
(statearr_25655_25712[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2727__auto____0 = (function (){
var statearr_25656 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25656[(0)] = fluree$db$graphdb$subid_$_state_machine__2727__auto__);

(statearr_25656[(1)] = (1));

return statearr_25656;
});
var fluree$db$graphdb$subid_$_state_machine__2727__auto____1 = (function (state_25592){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_25592);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25657){var ex__2730__auto__ = e25657;
var statearr_25658_25713 = state_25592;
(statearr_25658_25713[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_25592[(4)]))){
var statearr_25659_25714 = state_25592;
(statearr_25659_25714[(1)] = cljs.core.first.call(null,(state_25592[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25715 = state_25592;
state_25592 = G__25715;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2727__auto__ = function(state_25592){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2727__auto____1.call(this,state_25592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2727__auto____0;
fluree$db$graphdb$subid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2727__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25660 = f__2750__auto__.call(null);
(statearr_25660[(6)] = c__2749__auto___25661);

return statearr_25660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__25716){
var map__25717 = p__25716;
var map__25717__$1 = cljs.core.__destructure_map.call(null,map__25717);
var current_db_fn = cljs.core.get.call(null,map__25717__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.call(null,map__25717__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25733){
var state_val_25734 = (state_25733[(1)]);
if((state_val_25734 === (1))){
var state_25733__$1 = state_25733;
var statearr_25735_25749 = state_25733__$1;
(statearr_25735_25749[(2)] = null);

(statearr_25735_25749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (2))){
var _ = (function (){var statearr_25736 = state_25733;
(statearr_25736[(4)] = cljs.core.cons.call(null,(5),(state_25733[(4)])));

return statearr_25736;
})();
var inst_25724 = current_db_fn.call(null);
var state_25733__$1 = state_25733;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25733__$1,(6),inst_25724);
} else {
if((state_val_25734 === (3))){
var inst_25731 = (state_25733[(2)]);
var state_25733__$1 = state_25733;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25733__$1,inst_25731);
} else {
if((state_val_25734 === (4))){
var inst_25718 = (state_25733[(2)]);
var state_25733__$1 = state_25733;
var statearr_25738_25750 = state_25733__$1;
(statearr_25738_25750[(2)] = inst_25718);

(statearr_25738_25750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (5))){
var _ = (function (){var statearr_25739 = state_25733;
(statearr_25739[(4)] = cljs.core.rest.call(null,(state_25733[(4)])));

return statearr_25739;
})();
var state_25733__$1 = state_25733;
var ex25737 = (state_25733__$1[(2)]);
var statearr_25740_25751 = state_25733__$1;
(statearr_25740_25751[(5)] = ex25737);


if((ex25737 instanceof Error)){
var statearr_25741_25752 = state_25733__$1;
(statearr_25741_25752[(1)] = (4));

(statearr_25741_25752[(5)] = null);

} else {
throw ex25737;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25734 === (6))){
var inst_25726 = (state_25733[(2)]);
var inst_25727 = fluree.db.util.async.throw_err.call(null,inst_25726);
var inst_25728 = cljs.core.assoc.call(null,inst_25727,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_25742 = state_25733;
(statearr_25742[(4)] = cljs.core.rest.call(null,(state_25733[(4)])));

return statearr_25742;
})();
var state_25733__$1 = state_25733;
var statearr_25743_25753 = state_25733__$1;
(statearr_25743_25753[(2)] = inst_25728);

(statearr_25743_25753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0 = (function (){
var statearr_25744 = [null,null,null,null,null,null,null];
(statearr_25744[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__);

(statearr_25744[(1)] = (1));

return statearr_25744;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1 = (function (state_25733){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_25733);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25745){var ex__2730__auto__ = e25745;
var statearr_25746_25754 = state_25733;
(statearr_25746_25754[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_25733[(4)]))){
var statearr_25747_25755 = state_25733;
(statearr_25747_25755[(1)] = cljs.core.first.call(null,(state_25733[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25756 = state_25733;
state_25733 = G__25756;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__ = function(state_25733){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1.call(this,state_25733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25748 = f__2750__auto__.call(null);
(statearr_25748[(6)] = c__2749__auto__);

return statearr_25748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.call(null,this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__25757,property,collection){
var map__25758 = p__25757;
var map__25758__$1 = cljs.core.__destructure_map.call(null,map__25758);
var schema = cljs.core.get.call(null,map__25758__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__25759,property,predicate){
var map__25760 = p__25759;
var map__25760__$1 = cljs.core.__destructure_map.call(null,map__25760);
var this$ = map__25760__$1;
var schema = cljs.core.get.call(null,map__25760__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__25761 = cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop.call(null,this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__25761);
} else {
return G__25761;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__25763 = arguments.length;
switch (G__25763) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25795){
var state_val_25796 = (state_25795[(1)]);
if((state_val_25796 === (7))){
var state_25795__$1 = state_25795;
var statearr_25797_25891 = state_25795__$1;
(statearr_25797_25891[(2)] = null);

(statearr_25797_25891[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (1))){
var state_25795__$1 = state_25795;
var statearr_25798_25892 = state_25795__$1;
(statearr_25798_25892[(2)] = null);

(statearr_25798_25892[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (4))){
var inst_25764 = (state_25795[(2)]);
var state_25795__$1 = state_25795;
var statearr_25799_25893 = state_25795__$1;
(statearr_25799_25893[(2)] = inst_25764);

(statearr_25799_25893[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (6))){
var inst_25778 = (state_25795[(7)]);
var inst_25777 = (state_25795[(2)]);
var inst_25778__$1 = fluree.db.util.async.throw_err.call(null,inst_25777);
var inst_25779 = (inst_25778__$1 == null);
var state_25795__$1 = (function (){var statearr_25800 = state_25795;
(statearr_25800[(7)] = inst_25778__$1);

return statearr_25800;
})();
if(cljs.core.truth_(inst_25779)){
var statearr_25801_25894 = state_25795__$1;
(statearr_25801_25894[(1)] = (7));

} else {
var statearr_25802_25895 = state_25795__$1;
(statearr_25802_25895[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (3))){
var inst_25793 = (state_25795[(2)]);
var state_25795__$1 = state_25795;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25795__$1,inst_25793);
} else {
if((state_val_25796 === (12))){
var inst_25790 = (state_25795[(2)]);
var _ = (function (){var statearr_25803 = state_25795;
(statearr_25803[(4)] = cljs.core.rest.call(null,(state_25795[(4)])));

return statearr_25803;
})();
var state_25795__$1 = state_25795;
var statearr_25804_25896 = state_25795__$1;
(statearr_25804_25896[(2)] = inst_25790);

(statearr_25804_25896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (2))){
var _ = (function (){var statearr_25805 = state_25795;
(statearr_25805[(4)] = cljs.core.cons.call(null,(5),(state_25795[(4)])));

return statearr_25805;
})();
var inst_25771 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_25772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25773 = [tag_id,(30)];
var inst_25774 = (new cljs.core.PersistentVector(null,2,(5),inst_25772,inst_25773,null));
var inst_25775 = fluree.db.query.range.index_range.call(null,inst_25771,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_25774);
var state_25795__$1 = state_25795;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25795__$1,(6),inst_25775);
} else {
if((state_val_25796 === (11))){
var inst_25784 = (state_25795[(8)]);
var inst_25788 = fluree.db.flake.o.call(null,inst_25784);
var state_25795__$1 = state_25795;
var statearr_25807_25897 = state_25795__$1;
(statearr_25807_25897[(2)] = inst_25788);

(statearr_25807_25897[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (9))){
var inst_25784 = (state_25795[(8)]);
var inst_25784__$1 = (state_25795[(2)]);
var inst_25785 = (inst_25784__$1 == null);
var state_25795__$1 = (function (){var statearr_25808 = state_25795;
(statearr_25808[(8)] = inst_25784__$1);

return statearr_25808;
})();
if(cljs.core.truth_(inst_25785)){
var statearr_25809_25898 = state_25795__$1;
(statearr_25809_25898[(1)] = (10));

} else {
var statearr_25810_25899 = state_25795__$1;
(statearr_25810_25899[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (5))){
var _ = (function (){var statearr_25811 = state_25795;
(statearr_25811[(4)] = cljs.core.rest.call(null,(state_25795[(4)])));

return statearr_25811;
})();
var state_25795__$1 = state_25795;
var ex25806 = (state_25795__$1[(2)]);
var statearr_25812_25900 = state_25795__$1;
(statearr_25812_25900[(5)] = ex25806);


if((ex25806 instanceof Error)){
var statearr_25813_25901 = state_25795__$1;
(statearr_25813_25901[(1)] = (4));

(statearr_25813_25901[(5)] = null);

} else {
throw ex25806;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (10))){
var state_25795__$1 = state_25795;
var statearr_25814_25902 = state_25795__$1;
(statearr_25814_25902[(2)] = null);

(statearr_25814_25902[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (8))){
var inst_25778 = (state_25795[(7)]);
var inst_25782 = cljs.core.first.call(null,inst_25778);
var state_25795__$1 = state_25795;
var statearr_25815_25903 = state_25795__$1;
(statearr_25815_25903[(2)] = inst_25782);

(statearr_25815_25903[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_25816 = [null,null,null,null,null,null,null,null,null];
(statearr_25816[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_25816[(1)] = (1));

return statearr_25816;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_25795){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_25795);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25817){var ex__2730__auto__ = e25817;
var statearr_25818_25904 = state_25795;
(statearr_25818_25904[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_25795[(4)]))){
var statearr_25819_25905 = state_25795;
(statearr_25819_25905[(1)] = cljs.core.first.call(null,(state_25795[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25906 = state_25795;
state_25795 = G__25906;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_25795){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_25795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25820 = f__2750__auto__.call(null);
(statearr_25820[(6)] = c__2749__auto__);

return statearr_25820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25856){
var state_val_25857 = (state_25856[(1)]);
if((state_val_25857 === (7))){
var inst_25830 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_25856__$1 = state_25856;
var statearr_25858_25907 = state_25856__$1;
(statearr_25858_25907[(2)] = inst_25830);

(statearr_25858_25907[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (1))){
var state_25856__$1 = state_25856;
var statearr_25859_25908 = state_25856__$1;
(statearr_25859_25908[(2)] = null);

(statearr_25859_25908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (4))){
var inst_25821 = (state_25856[(2)]);
var state_25856__$1 = state_25856;
var statearr_25860_25909 = state_25856__$1;
(statearr_25860_25909[(2)] = inst_25821);

(statearr_25860_25909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (15))){
var inst_25851 = (state_25856[(2)]);
var _ = (function (){var statearr_25861 = state_25856;
(statearr_25861[(4)] = cljs.core.rest.call(null,(state_25856[(4)])));

return statearr_25861;
})();
var state_25856__$1 = state_25856;
var statearr_25862_25910 = state_25856__$1;
(statearr_25862_25910[(2)] = inst_25851);

(statearr_25862_25910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (13))){
var inst_25836 = (state_25856[(7)]);
var inst_25842 = clojure.string.includes_QMARK_.call(null,inst_25836,":");
var state_25856__$1 = state_25856;
if(inst_25842){
var statearr_25863_25911 = state_25856__$1;
(statearr_25863_25911[(1)] = (16));

} else {
var statearr_25864_25912 = state_25856__$1;
(statearr_25864_25912[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (6))){
var state_25856__$1 = state_25856;
var statearr_25865_25913 = state_25856__$1;
(statearr_25865_25913[(2)] = pred);

(statearr_25865_25913[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (17))){
var inst_25836 = (state_25856[(7)]);
var state_25856__$1 = state_25856;
var statearr_25866_25914 = state_25856__$1;
(statearr_25866_25914[(2)] = inst_25836);

(statearr_25866_25914[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (3))){
var inst_25854 = (state_25856[(2)]);
var state_25856__$1 = state_25856;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25856__$1,inst_25854);
} else {
if((state_val_25857 === (12))){
var inst_25840 = (state_25856[(2)]);
var state_25856__$1 = state_25856;
if(cljs.core.truth_(inst_25840)){
var statearr_25867_25915 = state_25856__$1;
(statearr_25867_25915[(1)] = (13));

} else {
var statearr_25868_25916 = state_25856__$1;
(statearr_25868_25916[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (2))){
var _ = (function (){var statearr_25869 = state_25856;
(statearr_25869[(4)] = cljs.core.cons.call(null,(5),(state_25856[(4)])));

return statearr_25869;
})();
var inst_25827 = typeof pred === 'string';
var state_25856__$1 = state_25856;
if(cljs.core.truth_(inst_25827)){
var statearr_25870_25917 = state_25856__$1;
(statearr_25870_25917[(1)] = (6));

} else {
var statearr_25871_25918 = state_25856__$1;
(statearr_25871_25918[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (11))){
var inst_25832 = (state_25856[(8)]);
var state_25856__$1 = state_25856;
var statearr_25873_25919 = state_25856__$1;
(statearr_25873_25919[(2)] = inst_25832);

(statearr_25873_25919[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (9))){
var inst_25832 = (state_25856[(8)]);
var inst_25835 = (state_25856[(2)]);
var inst_25836 = fluree.db.util.async.throw_err.call(null,inst_25835);
var state_25856__$1 = (function (){var statearr_25874 = state_25856;
(statearr_25874[(7)] = inst_25836);

return statearr_25874;
})();
if(cljs.core.truth_(inst_25832)){
var statearr_25875_25920 = state_25856__$1;
(statearr_25875_25920[(1)] = (10));

} else {
var statearr_25876_25921 = state_25856__$1;
(statearr_25876_25921[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (5))){
var _ = (function (){var statearr_25877 = state_25856;
(statearr_25877[(4)] = cljs.core.rest.call(null,(state_25856[(4)])));

return statearr_25877;
})();
var state_25856__$1 = state_25856;
var ex25872 = (state_25856__$1[(2)]);
var statearr_25878_25922 = state_25856__$1;
(statearr_25878_25922[(5)] = ex25872);


if((ex25872 instanceof Error)){
var statearr_25879_25923 = state_25856__$1;
(statearr_25879_25923[(1)] = (4));

(statearr_25879_25923[(5)] = null);

} else {
throw ex25872;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (14))){
var state_25856__$1 = state_25856;
var statearr_25880_25924 = state_25856__$1;
(statearr_25880_25924[(2)] = null);

(statearr_25880_25924[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (16))){
var inst_25836 = (state_25856[(7)]);
var inst_25844 = clojure.string.split.call(null,inst_25836,/:/);
var inst_25845 = cljs.core.second.call(null,inst_25844);
var state_25856__$1 = state_25856;
var statearr_25881_25925 = state_25856__$1;
(statearr_25881_25925[(2)] = inst_25845);

(statearr_25881_25925[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (10))){
var inst_25836 = (state_25856[(7)]);
var state_25856__$1 = state_25856;
var statearr_25882_25926 = state_25856__$1;
(statearr_25882_25926[(2)] = inst_25836);

(statearr_25882_25926[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (18))){
var inst_25848 = (state_25856[(2)]);
var state_25856__$1 = state_25856;
var statearr_25883_25927 = state_25856__$1;
(statearr_25883_25927[(2)] = inst_25848);

(statearr_25883_25927[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (8))){
var inst_25832 = (state_25856[(2)]);
var inst_25833 = fluree.db.dbproto._tag.call(null,this$,tag_id);
var state_25856__$1 = (function (){var statearr_25884 = state_25856;
(statearr_25884[(8)] = inst_25832);

return statearr_25884;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25856__$1,(9),inst_25833);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_25885 = [null,null,null,null,null,null,null,null,null];
(statearr_25885[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_25885[(1)] = (1));

return statearr_25885;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_25856){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_25856);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25886){var ex__2730__auto__ = e25886;
var statearr_25887_25928 = state_25856;
(statearr_25887_25928[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_25856[(4)]))){
var statearr_25888_25929 = state_25856;
(statearr_25888_25929[(1)] = cljs.core.first.call(null,(state_25856[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25930 = state_25856;
state_25856 = G__25930;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_25856){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_25856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25889 = f__2750__auto__.call(null);
(statearr_25889[(6)] = c__2749__auto__);

return statearr_25889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__25932 = arguments.length;
switch (G__25932) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25965){
var state_val_25966 = (state_25965[(1)]);
if((state_val_25966 === (7))){
var state_25965__$1 = state_25965;
var statearr_25967_26055 = state_25965__$1;
(statearr_25967_26055[(2)] = null);

(statearr_25967_26055[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25966 === (1))){
var state_25965__$1 = state_25965;
var statearr_25968_26056 = state_25965__$1;
(statearr_25968_26056[(2)] = null);

(statearr_25968_26056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25966 === (4))){
var inst_25933 = (state_25965[(2)]);
var state_25965__$1 = state_25965;
var statearr_25969_26057 = state_25965__$1;
(statearr_25969_26057[(2)] = inst_25933);

(statearr_25969_26057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25966 === (6))){
var inst_25948 = (state_25965[(7)]);
var inst_25947 = (state_25965[(2)]);
var inst_25948__$1 = fluree.db.util.async.throw_err.call(null,inst_25947);
var inst_25949 = (inst_25948__$1 == null);
var state_25965__$1 = (function (){var statearr_25970 = state_25965;
(statearr_25970[(7)] = inst_25948__$1);

return statearr_25970;
})();
if(cljs.core.truth_(inst_25949)){
var statearr_25971_26058 = state_25965__$1;
(statearr_25971_26058[(1)] = (7));

} else {
var statearr_25972_26059 = state_25965__$1;
(statearr_25972_26059[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25966 === (3))){
var inst_25963 = (state_25965[(2)]);
var state_25965__$1 = state_25965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25965__$1,inst_25963);
} else {
if((state_val_25966 === (12))){
var inst_25960 = (state_25965[(2)]);
var _ = (function (){var statearr_25973 = state_25965;
(statearr_25973[(4)] = cljs.core.rest.call(null,(state_25965[(4)])));

return statearr_25973;
})();
var state_25965__$1 = state_25965;
var statearr_25974_26060 = state_25965__$1;
(statearr_25974_26060[(2)] = inst_25960);

(statearr_25974_26060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25966 === (2))){
var _ = (function (){var statearr_25975 = state_25965;
(statearr_25975[(4)] = cljs.core.cons.call(null,(5),(state_25965[(4)])));

return statearr_25975;
})();
var inst_25939 = (30);
var inst_25941 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_25942 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25943 = [inst_25939,tag_name];
var inst_25944 = (new cljs.core.PersistentVector(null,2,(5),inst_25942,inst_25943,null));
var inst_25945 = fluree.db.query.range.index_range.call(null,inst_25941,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_25944);
var state_25965__$1 = state_25965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25965__$1,(6),inst_25945);
} else {
if((state_val_25966 === (11))){
var inst_25954 = (state_25965[(8)]);
var inst_25958 = fluree.db.flake.s.call(null,inst_25954);
var state_25965__$1 = state_25965;
var statearr_25977_26061 = state_25965__$1;
(statearr_25977_26061[(2)] = inst_25958);

(statearr_25977_26061[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25966 === (9))){
var inst_25954 = (state_25965[(8)]);
var inst_25954__$1 = (state_25965[(2)]);
var inst_25955 = (inst_25954__$1 == null);
var state_25965__$1 = (function (){var statearr_25978 = state_25965;
(statearr_25978[(8)] = inst_25954__$1);

return statearr_25978;
})();
if(cljs.core.truth_(inst_25955)){
var statearr_25979_26062 = state_25965__$1;
(statearr_25979_26062[(1)] = (10));

} else {
var statearr_25980_26063 = state_25965__$1;
(statearr_25980_26063[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25966 === (5))){
var _ = (function (){var statearr_25981 = state_25965;
(statearr_25981[(4)] = cljs.core.rest.call(null,(state_25965[(4)])));

return statearr_25981;
})();
var state_25965__$1 = state_25965;
var ex25976 = (state_25965__$1[(2)]);
var statearr_25982_26064 = state_25965__$1;
(statearr_25982_26064[(5)] = ex25976);


if((ex25976 instanceof Error)){
var statearr_25983_26065 = state_25965__$1;
(statearr_25983_26065[(1)] = (4));

(statearr_25983_26065[(5)] = null);

} else {
throw ex25976;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25966 === (10))){
var state_25965__$1 = state_25965;
var statearr_25984_26066 = state_25965__$1;
(statearr_25984_26066[(2)] = null);

(statearr_25984_26066[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25966 === (8))){
var inst_25948 = (state_25965[(7)]);
var inst_25952 = cljs.core.first.call(null,inst_25948);
var state_25965__$1 = state_25965;
var statearr_25985_26067 = state_25965__$1;
(statearr_25985_26067[(2)] = inst_25952);

(statearr_25985_26067[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_25986 = [null,null,null,null,null,null,null,null,null];
(statearr_25986[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_25986[(1)] = (1));

return statearr_25986;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_25965){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_25965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25987){var ex__2730__auto__ = e25987;
var statearr_25988_26068 = state_25965;
(statearr_25988_26068[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_25965[(4)]))){
var statearr_25989_26069 = state_25965;
(statearr_25989_26069[(1)] = cljs.core.first.call(null,(state_25965[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26070 = state_25965;
state_25965 = G__26070;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_25965){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_25965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25990 = f__2750__auto__.call(null);
(statearr_25990[(6)] = c__2749__auto__);

return statearr_25990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26025){
var state_val_26026 = (state_26025[(1)]);
if((state_val_26026 === (7))){
var inst_26004 = typeof pred === 'string';
var state_26025__$1 = state_26025;
if(cljs.core.truth_(inst_26004)){
var statearr_26027_26071 = state_26025__$1;
(statearr_26027_26071[(1)] = (10));

} else {
var statearr_26028_26072 = state_26025__$1;
(statearr_26028_26072[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26026 === (1))){
var state_26025__$1 = state_26025;
var statearr_26029_26073 = state_26025__$1;
(statearr_26029_26073[(2)] = null);

(statearr_26029_26073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26026 === (4))){
var inst_25991 = (state_26025[(2)]);
var state_26025__$1 = state_26025;
var statearr_26030_26074 = state_26025__$1;
(statearr_26030_26074[(2)] = inst_25991);

(statearr_26030_26074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26026 === (15))){
var inst_26018 = (state_26025[(2)]);
var state_26025__$1 = state_26025;
var statearr_26031_26075 = state_26025__$1;
(statearr_26031_26075[(2)] = inst_26018);

(statearr_26031_26075[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26026 === (13))){
var inst_26009 = (state_26025[(7)]);
var inst_26011 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26009),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_26012 = fluree.db.dbproto._tag_id.call(null,this$,inst_26011);
var state_26025__$1 = state_26025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26025__$1,(16),inst_26012);
} else {
if((state_val_26026 === (6))){
var inst_25999 = fluree.db.dbproto._tag_id.call(null,this$,tag_name);
var state_26025__$1 = state_26025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26025__$1,(9),inst_25999);
} else {
if((state_val_26026 === (3))){
var inst_26023 = (state_26025[(2)]);
var state_26025__$1 = state_26025;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26025__$1,inst_26023);
} else {
if((state_val_26026 === (12))){
var inst_26009 = (state_26025[(7)]);
var inst_26009__$1 = (state_26025[(2)]);
var state_26025__$1 = (function (){var statearr_26032 = state_26025;
(statearr_26032[(7)] = inst_26009__$1);

return statearr_26032;
})();
if(cljs.core.truth_(inst_26009__$1)){
var statearr_26033_26076 = state_26025__$1;
(statearr_26033_26076[(1)] = (13));

} else {
var statearr_26034_26077 = state_26025__$1;
(statearr_26034_26077[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26026 === (2))){
var _ = (function (){var statearr_26035 = state_26025;
(statearr_26035[(4)] = cljs.core.cons.call(null,(5),(state_26025[(4)])));

return statearr_26035;
})();
var inst_25997 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_26025__$1 = state_26025;
if(inst_25997){
var statearr_26036_26078 = state_26025__$1;
(statearr_26036_26078[(1)] = (6));

} else {
var statearr_26037_26079 = state_26025__$1;
(statearr_26037_26079[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26026 === (11))){
var inst_26007 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26025__$1 = state_26025;
var statearr_26039_26080 = state_26025__$1;
(statearr_26039_26080[(2)] = inst_26007);

(statearr_26039_26080[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26026 === (9))){
var inst_26001 = (state_26025[(2)]);
var inst_26002 = fluree.db.util.async.throw_err.call(null,inst_26001);
var state_26025__$1 = state_26025;
var statearr_26040_26081 = state_26025__$1;
(statearr_26040_26081[(2)] = inst_26002);

(statearr_26040_26081[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26026 === (5))){
var _ = (function (){var statearr_26041 = state_26025;
(statearr_26041[(4)] = cljs.core.rest.call(null,(state_26025[(4)])));

return statearr_26041;
})();
var state_26025__$1 = state_26025;
var ex26038 = (state_26025__$1[(2)]);
var statearr_26042_26082 = state_26025__$1;
(statearr_26042_26082[(5)] = ex26038);


if((ex26038 instanceof Error)){
var statearr_26043_26083 = state_26025__$1;
(statearr_26043_26083[(1)] = (4));

(statearr_26043_26083[(5)] = null);

} else {
throw ex26038;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26026 === (14))){
var state_26025__$1 = state_26025;
var statearr_26044_26084 = state_26025__$1;
(statearr_26044_26084[(2)] = null);

(statearr_26044_26084[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26026 === (16))){
var inst_26014 = (state_26025[(2)]);
var inst_26015 = fluree.db.util.async.throw_err.call(null,inst_26014);
var state_26025__$1 = state_26025;
var statearr_26045_26085 = state_26025__$1;
(statearr_26045_26085[(2)] = inst_26015);

(statearr_26045_26085[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26026 === (10))){
var state_26025__$1 = state_26025;
var statearr_26046_26086 = state_26025__$1;
(statearr_26046_26086[(2)] = pred);

(statearr_26046_26086[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26026 === (8))){
var inst_26020 = (state_26025[(2)]);
var _ = (function (){var statearr_26047 = state_26025;
(statearr_26047[(4)] = cljs.core.rest.call(null,(state_26025[(4)])));

return statearr_26047;
})();
var state_26025__$1 = state_26025;
var statearr_26048_26087 = state_26025__$1;
(statearr_26048_26087[(2)] = inst_26020);

(statearr_26048_26087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26049 = [null,null,null,null,null,null,null,null];
(statearr_26049[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26049[(1)] = (1));

return statearr_26049;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26025){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_26025);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26050){var ex__2730__auto__ = e26050;
var statearr_26051_26088 = state_26025;
(statearr_26051_26088[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_26025[(4)]))){
var statearr_26052_26089 = state_26025;
(statearr_26052_26089[(1)] = cljs.core.first.call(null,(state_26025[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26090 = state_26025;
state_26025 = G__26090;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26025){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26053 = f__2750__auto__.call(null);
(statearr_26053[(6)] = c__2749__auto__);

return statearr_26053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.tspo = tspo;
this.schema = schema;
this.settings = settings;
this.comparators = comparators;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k26092,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__26096 = k26092;
var G__26096__$1 = (((G__26096 instanceof cljs.core.Keyword))?G__26096.fqn:null);
switch (G__26096__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "tspo":
return self__.tspo;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "comparators":
return self__.comparators;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k26092,else__4505__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__26097){
var vec__26098 = p__26097;
var k__4526__auto__ = cljs.core.nth.call(null,vec__26098,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__26098,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26091){
var self__ = this;
var G__26091__$1 = this;
return (new cljs.core.RecordIter((0),G__26091__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (21 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26093,other26094){
var self__ = this;
var this26093__$1 = this;
return (((!((other26094 == null)))) && ((((this26093__$1.constructor === other26094.constructor)) && (((cljs.core._EQ_.call(null,this26093__$1.conn,other26094.conn)) && (((cljs.core._EQ_.call(null,this26093__$1.network,other26094.network)) && (((cljs.core._EQ_.call(null,this26093__$1.ledger_id,other26094.ledger_id)) && (((cljs.core._EQ_.call(null,this26093__$1.block,other26094.block)) && (((cljs.core._EQ_.call(null,this26093__$1.t,other26094.t)) && (((cljs.core._EQ_.call(null,this26093__$1.tt_id,other26094.tt_id)) && (((cljs.core._EQ_.call(null,this26093__$1.stats,other26094.stats)) && (((cljs.core._EQ_.call(null,this26093__$1.spot,other26094.spot)) && (((cljs.core._EQ_.call(null,this26093__$1.psot,other26094.psot)) && (((cljs.core._EQ_.call(null,this26093__$1.post,other26094.post)) && (((cljs.core._EQ_.call(null,this26093__$1.opst,other26094.opst)) && (((cljs.core._EQ_.call(null,this26093__$1.tspo,other26094.tspo)) && (((cljs.core._EQ_.call(null,this26093__$1.schema,other26094.schema)) && (((cljs.core._EQ_.call(null,this26093__$1.settings,other26094.settings)) && (((cljs.core._EQ_.call(null,this26093__$1.comparators,other26094.comparators)) && (((cljs.core._EQ_.call(null,this26093__$1.schema_cache,other26094.schema_cache)) && (((cljs.core._EQ_.call(null,this26093__$1.novelty,other26094.novelty)) && (((cljs.core._EQ_.call(null,this26093__$1.permissions,other26094.permissions)) && (((cljs.core._EQ_.call(null,this26093__$1.fork,other26094.fork)) && (((cljs.core._EQ_.call(null,this26093__$1.fork_block,other26094.fork_block)) && (((cljs.core._EQ_.call(null,this26093__$1.current_db_fn,other26094.current_db_fn)) && (cljs.core._EQ_.call(null,this26093__$1.__extmap,other26094.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k26092){
var self__ = this;
var this__4509__auto____$1 = this;
var G__26101 = k26092;
var G__26101__$1 = (((G__26101 instanceof cljs.core.Keyword))?G__26101.fqn:null);
switch (G__26101__$1) {
case "conn":
case "network":
case "ledger-id":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "tspo":
case "schema":
case "settings":
case "comparators":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k26092);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__26091){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__26102 = cljs.core.keyword_identical_QMARK_;
var expr__26103 = k__4511__auto__;
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__26103))){
return (new fluree.db.graphdb.GraphDb(G__26091,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__26091,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__26091,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,G__26091,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,G__26091,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,G__26091,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,G__26091,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,G__26091,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__26091,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__26091,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__26091,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__26091,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,G__26091,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,G__26091,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,G__26091,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,G__26091,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,G__26091,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,G__26091,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,G__26091,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__26091,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26102.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__26103))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__26091,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__26091),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__26091){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__26091,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop.call(null,this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop.call(null,this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"tspo","tspo",1200386574,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"comparators","comparators",314919572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__26095){
var extmap__4542__auto__ = (function (){var G__26105 = cljs.core.dissoc.call(null,G__26095,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__26095)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__26105);
} else {
return G__26105;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"tspo","tspo",-440144953).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"comparators","comparators",-1325611955).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__26095),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__26095),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),db__$1.ledger_id,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(comparators){
return cljs.core.reduce.call(null,(function (m,idx){
return cljs.core.assoc.call(null,m,idx,clojure.data.avl.sorted_set_by.call(null,cljs.core.get.call(null,comparators,idx)));
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),fluree.db.index.types);
});
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,ledger_id,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(ledger_id)){
} else {
throw (new Error(["Assert failed: ","No ledger-id provided when creating new db.","\n","ledger-id"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.index.default_comparators);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var map__26108 = fluree.db.index.default_comparators;
var map__26108__$1 = cljs.core.__destructure_map.call(null,map__26108);
var spot_cmp = cljs.core.get.call(null,map__26108__$1,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot_cmp = cljs.core.get.call(null,map__26108__$1,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post_cmp = cljs.core.get.call(null,map__26108__$1,new cljs.core.Keyword(null,"post","post",269697687));
var opst_cmp = cljs.core.get.call(null,map__26108__$1,new cljs.core.Keyword(null,"opst","opst",1213963058));
var tspo_cmp = cljs.core.get.call(null,map__26108__$1,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var spot = fluree.db.index.empty_branch.call(null,network,ledger_id,spot_cmp);
var psot = fluree.db.index.empty_branch.call(null,network,ledger_id,psot_cmp);
var post = fluree.db.index.empty_branch.call(null,network,ledger_id,post_cmp);
var opst = fluree.db.index.empty_branch.call(null,network,ledger_id,opst_cmp);
var tspo = fluree.db.index.empty_branch.call(null,network,ledger_id,tspo_cmp);
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,ledger_id,(0),(-1),null,stats,spot,psot,post,opst,tspo,schema,settings,fluree.db.index.default_comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
