// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
/**
 * Map of default index comparators for the five index types
 */
fluree.db.index.default_comparators = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"post","post",269697687),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"tspo","tspo",-440144953),fluree.db.flake.cmp_flakes_block], null);
/**
 * The five possible index orderings based on the subject, predicate, object,
 *   and transaction flake attributes
 */
fluree.db.index.types = cljs.core.set.call(null,cljs.core.keys.call(null,fluree.db.index.default_comparators));
/**
 * Returns `true` if `node` is a map for a leaf node
 */
fluree.db.index.leaf_QMARK_ = (function fluree$db$index$leaf_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === true;
});
/**
 * Returns `true` if `node` is a map for branch node
 */
fluree.db.index.branch_QMARK_ = (function fluree$db$index$branch_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === false;
});

/**
 * @interface
 */
fluree.db.index.Resolver = function(){};

var fluree$db$index$Resolver$resolve$dyn_13828 = (function (r,node){
var x__4550__auto__ = (((r == null))?null:r);
var m__4551__auto__ = (fluree.db.index.resolve[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,r,node);
} else {
var m__4549__auto__ = (fluree.db.index.resolve["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,r,node);
} else {
throw cljs.core.missing_protocol.call(null,"Resolver.resolve",r);
}
}
});
/**
 * Populate index branch and leaf node maps with either their child node
 *   attributes or the flakes the store, respectively.
 */
fluree.db.index.resolve = (function fluree$db$index$resolve(r,node){
if((((!((r == null)))) && ((!((r.fluree$db$index$Resolver$resolve$arity$2 == null)))))){
return r.fluree$db$index$Resolver$resolve$arity$2(r,node);
} else {
return fluree$db$index$Resolver$resolve$dyn_13828.call(null,r,node);
}
});

fluree.db.index.try_resolve = (function fluree$db$index$try_resolve(r,error_ch,node){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_13850){
var state_val_13851 = (state_13850[(1)]);
if((state_val_13851 === (1))){
var state_13850__$1 = state_13850;
var statearr_13852_13867 = state_13850__$1;
(statearr_13852_13867[(2)] = null);

(statearr_13852_13867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13851 === (2))){
var _ = (function (){var statearr_13853 = state_13850;
(statearr_13853[(4)] = cljs.core.cons.call(null,(6),(state_13850[(4)])));

return statearr_13853;
})();
var inst_13842 = fluree.db.index.resolve.call(null,r,node);
var state_13850__$1 = state_13850;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13850__$1,(7),inst_13842);
} else {
if((state_val_13851 === (3))){
var inst_13848 = (state_13850[(2)]);
var state_13850__$1 = state_13850;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13850__$1,inst_13848);
} else {
if((state_val_13851 === (4))){
var inst_13829 = (state_13850[(2)]);
var inst_13830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13831 = [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015)];
var inst_13832 = (new cljs.core.PersistentVector(null,3,(5),inst_13830,inst_13831,null));
var inst_13833 = cljs.core.select_keys.call(null,node,inst_13832);
var inst_13834 = fluree.db.util.log.error.call(null,inst_13829,"Error resolving index node:",inst_13833);
var state_13850__$1 = (function (){var statearr_13855 = state_13850;
(statearr_13855[(7)] = inst_13834);

return statearr_13855;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13850__$1,(5),error_ch,inst_13829);
} else {
if((state_val_13851 === (5))){
var inst_13836 = (state_13850[(2)]);
var state_13850__$1 = state_13850;
var statearr_13856_13868 = state_13850__$1;
(statearr_13856_13868[(2)] = inst_13836);

(statearr_13856_13868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13851 === (6))){
var _ = (function (){var statearr_13857 = state_13850;
(statearr_13857[(4)] = cljs.core.rest.call(null,(state_13850[(4)])));

return statearr_13857;
})();
var state_13850__$1 = state_13850;
var ex13854 = (state_13850__$1[(2)]);
var statearr_13858_13869 = state_13850__$1;
(statearr_13858_13869[(5)] = ex13854);


var statearr_13859_13870 = state_13850__$1;
(statearr_13859_13870[(1)] = (4));

(statearr_13859_13870[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13851 === (7))){
var inst_13844 = (state_13850[(2)]);
var inst_13845 = fluree.db.util.async.throw_err.call(null,inst_13844);
var _ = (function (){var statearr_13860 = state_13850;
(statearr_13860[(4)] = cljs.core.rest.call(null,(state_13850[(4)])));

return statearr_13860;
})();
var state_13850__$1 = state_13850;
var statearr_13861_13871 = state_13850__$1;
(statearr_13861_13871[(2)] = inst_13845);

(statearr_13861_13871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$try_resolve_$_state_machine__2727__auto__ = null;
var fluree$db$index$try_resolve_$_state_machine__2727__auto____0 = (function (){
var statearr_13862 = [null,null,null,null,null,null,null,null];
(statearr_13862[(0)] = fluree$db$index$try_resolve_$_state_machine__2727__auto__);

(statearr_13862[(1)] = (1));

return statearr_13862;
});
var fluree$db$index$try_resolve_$_state_machine__2727__auto____1 = (function (state_13850){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_13850);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e13863){var ex__2730__auto__ = e13863;
var statearr_13864_13872 = state_13850;
(statearr_13864_13872[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_13850[(4)]))){
var statearr_13865_13873 = state_13850;
(statearr_13865_13873[(1)] = cljs.core.first.call(null,(state_13850[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13874 = state_13850;
state_13850 = G__13874;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$try_resolve_$_state_machine__2727__auto__ = function(state_13850){
switch(arguments.length){
case 0:
return fluree$db$index$try_resolve_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$try_resolve_$_state_machine__2727__auto____1.call(this,state_13850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$try_resolve_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$try_resolve_$_state_machine__2727__auto____0;
fluree$db$index$try_resolve_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$try_resolve_$_state_machine__2727__auto____1;
return fluree$db$index$try_resolve_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_13866 = f__2750__auto__.call(null);
(statearr_13866[(6)] = c__2749__auto__);

return statearr_13866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns `true` if the data associated with the index node map `node` is fully
 *   resolved from storage
 */
fluree.db.index.resolved_QMARK_ = (function fluree$db$index$resolved_QMARK_(node){
if(fluree.db.index.leaf_QMARK_.call(null,node)){
return (!((new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
if(fluree.db.index.branch_QMARK_.call(null,node)){
return (!((new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
return null;
}
}
});
fluree.db.index.lookup = (function fluree$db$index$lookup(branch,flake){
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.index.branch_QMARK_.call(null,branch);
if(and__4251__auto__){
return fluree.db.index.resolved_QMARK_.call(null,branch);
} else {
return and__4251__auto__;
}
})())){
var map__13875 = branch;
var map__13875__$1 = cljs.core.__destructure_map.call(null,map__13875);
var children = cljs.core.get.call(null,map__13875__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.val.call(null,(function (){var or__4253__auto__ = clojure.data.avl.nearest.call(null,children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.first.call(null,children);
}
})());
} else {
return null;
}
});
fluree.db.index.lookup_leaf = (function fluree$db$index$lookup_leaf(r,branch,flake){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_13911){
var state_val_13912 = (state_13911[(1)]);
if((state_val_13912 === (7))){
var inst_13882 = (state_13911[(7)]);
var state_13911__$1 = state_13911;
var statearr_13913_13944 = state_13911__$1;
(statearr_13913_13944[(2)] = inst_13882);

(statearr_13913_13944[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13912 === (1))){
var state_13911__$1 = state_13911;
var statearr_13914_13945 = state_13911__$1;
(statearr_13914_13945[(2)] = null);

(statearr_13914_13945[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13912 === (4))){
var inst_13876 = (state_13911[(2)]);
var state_13911__$1 = state_13911;
var statearr_13915_13946 = state_13911__$1;
(statearr_13915_13946[(2)] = inst_13876);

(statearr_13915_13946[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13912 === (15))){
var inst_13890 = (state_13911[(8)]);
var inst_13895 = fluree.db.index.resolve.call(null,r,inst_13890);
var state_13911__$1 = state_13911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13911__$1,(17),inst_13895);
} else {
if((state_val_13912 === (13))){
var inst_13903 = (state_13911[(2)]);
var state_13911__$1 = state_13911;
var statearr_13916_13947 = state_13911__$1;
(statearr_13916_13947[(2)] = inst_13903);

(statearr_13916_13947[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13912 === (6))){
var inst_13884 = fluree.db.index.resolved_QMARK_.call(null,branch);
var state_13911__$1 = state_13911;
var statearr_13917_13948 = state_13911__$1;
(statearr_13917_13948[(2)] = inst_13884);

(statearr_13917_13948[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13912 === (17))){
var inst_13897 = (state_13911[(2)]);
var inst_13898 = fluree.db.util.async.throw_err.call(null,inst_13897);
var inst_13890 = inst_13898;
var state_13911__$1 = (function (){var statearr_13918 = state_13911;
(statearr_13918[(8)] = inst_13890);

return statearr_13918;
})();
var statearr_13919_13949 = state_13911__$1;
(statearr_13919_13949[(2)] = null);

(statearr_13919_13949[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13912 === (3))){
var inst_13909 = (state_13911[(2)]);
var state_13911__$1 = state_13911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13911__$1,inst_13909);
} else {
if((state_val_13912 === (12))){
var inst_13890 = (state_13911[(8)]);
var inst_13892 = fluree.db.index.leaf_QMARK_.call(null,inst_13890);
var state_13911__$1 = state_13911;
if(inst_13892){
var statearr_13920_13950 = state_13911__$1;
(statearr_13920_13950[(1)] = (14));

} else {
var statearr_13921_13951 = state_13911__$1;
(statearr_13921_13951[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13912 === (2))){
var inst_13882 = (state_13911[(7)]);
var _ = (function (){var statearr_13922 = state_13911;
(statearr_13922[(4)] = cljs.core.cons.call(null,(5),(state_13911[(4)])));

return statearr_13922;
})();
var inst_13882__$1 = fluree.db.index.branch_QMARK_.call(null,branch);
var state_13911__$1 = (function (){var statearr_13923 = state_13911;
(statearr_13923[(7)] = inst_13882__$1);

return statearr_13923;
})();
if(inst_13882__$1){
var statearr_13924_13952 = state_13911__$1;
(statearr_13924_13952[(1)] = (6));

} else {
var statearr_13925_13953 = state_13911__$1;
(statearr_13925_13953[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13912 === (11))){
var inst_13906 = (state_13911[(2)]);
var _ = (function (){var statearr_13927 = state_13911;
(statearr_13927[(4)] = cljs.core.rest.call(null,(state_13911[(4)])));

return statearr_13927;
})();
var state_13911__$1 = state_13911;
var statearr_13928_13954 = state_13911__$1;
(statearr_13928_13954[(2)] = inst_13906);

(statearr_13928_13954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13912 === (9))){
var inst_13889 = fluree.db.index.lookup.call(null,branch,flake);
var inst_13890 = inst_13889;
var state_13911__$1 = (function (){var statearr_13929 = state_13911;
(statearr_13929[(8)] = inst_13890);

return statearr_13929;
})();
var statearr_13930_13955 = state_13911__$1;
(statearr_13930_13955[(2)] = null);

(statearr_13930_13955[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13912 === (5))){
var _ = (function (){var statearr_13931 = state_13911;
(statearr_13931[(4)] = cljs.core.rest.call(null,(state_13911[(4)])));

return statearr_13931;
})();
var state_13911__$1 = state_13911;
var ex13926 = (state_13911__$1[(2)]);
var statearr_13932_13956 = state_13911__$1;
(statearr_13932_13956[(5)] = ex13926);


if((ex13926 instanceof Error)){
var statearr_13933_13957 = state_13911__$1;
(statearr_13933_13957[(1)] = (4));

(statearr_13933_13957[(5)] = null);

} else {
throw ex13926;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13912 === (14))){
var inst_13890 = (state_13911[(8)]);
var state_13911__$1 = state_13911;
var statearr_13934_13958 = state_13911__$1;
(statearr_13934_13958[(2)] = inst_13890);

(statearr_13934_13958[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13912 === (16))){
var inst_13901 = (state_13911[(2)]);
var state_13911__$1 = state_13911;
var statearr_13935_13959 = state_13911__$1;
(statearr_13935_13959[(2)] = inst_13901);

(statearr_13935_13959[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13912 === (10))){
var state_13911__$1 = state_13911;
var statearr_13936_13960 = state_13911__$1;
(statearr_13936_13960[(2)] = null);

(statearr_13936_13960[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13912 === (8))){
var inst_13887 = (state_13911[(2)]);
var state_13911__$1 = state_13911;
if(cljs.core.truth_(inst_13887)){
var statearr_13937_13961 = state_13911__$1;
(statearr_13937_13961[(1)] = (9));

} else {
var statearr_13938_13962 = state_13911__$1;
(statearr_13938_13962[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_13939 = [null,null,null,null,null,null,null,null,null];
(statearr_13939[(0)] = fluree$db$index$lookup_leaf_$_state_machine__2727__auto__);

(statearr_13939[(1)] = (1));

return statearr_13939;
});
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1 = (function (state_13911){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_13911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e13940){var ex__2730__auto__ = e13940;
var statearr_13941_13963 = state_13911;
(statearr_13941_13963[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_13911[(4)]))){
var statearr_13942_13964 = state_13911;
(statearr_13942_13964[(1)] = cljs.core.first.call(null,(state_13911[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13965 = state_13911;
state_13911 = G__13965;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__ = function(state_13911){
switch(arguments.length){
case 0:
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1.call(this,state_13911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0;
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1;
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_13943 = f__2750__auto__.call(null);
(statearr_13943[(6)] = c__2749__auto__);

return statearr_13943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.index.add_flakes = (function fluree$db$index$add_flakes(leaf,flakes){
var new_leaf = cljs.core.update.call(null,cljs.core.update.call(null,leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.conj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.call(null,cljs.core._PLUS_,size,cljs.core.map.call(null,fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__4253__auto__ = (function (){var G__13966 = new_leaf;
var G__13966__$1 = (((G__13966 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__13966));
if((G__13966__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__13966__$1);
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.call(null,new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
fluree.db.index.rem_flakes = (function fluree$db$index$rem_flakes(leaf,flakes){
var new_leaf = cljs.core.update.call(null,cljs.core.update.call(null,leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.disj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.call(null,cljs.core._,size,cljs.core.map.call(null,fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__4253__auto__ = (function (){var G__13967 = new_leaf;
var G__13967__$1 = (((G__13967 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__13967));
if((G__13967__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__13967__$1);
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.call(null,new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
/**
 * Returns a blank leaf node map for the provided `network`, `ledger-id`, and index
 *   comparator `cmp`.
 */
fluree.db.index.empty_leaf = (function fluree$db$index$empty_leaf(network,ledger_id,cmp){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[(0),ledger_id,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.new_leaf = (function fluree$db$index$new_leaf(network,ledger_id,cmp,flakes){
var empty_set = fluree.db.flake.sorted_set_by.call(null,cmp);
return fluree.db.index.add_flakes.call(null,cljs.core.assoc.call(null,fluree.db.index.empty_leaf.call(null,network,ledger_id,cmp),new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set),flakes);
});
/**
 * Checks if the `node` passed in the second argument is a descendant of the
 *   `branch` passed in the first argument
 */
fluree.db.index.descendant_QMARK_ = (function fluree$db$index$descendant_QMARK_(p__13968,p__13969){
var map__13970 = p__13968;
var map__13970__$1 = cljs.core.__destructure_map.call(null,map__13970);
var branch = map__13970__$1;
var cmp = cljs.core.get.call(null,map__13970__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var first_flake = cljs.core.get.call(null,map__13970__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.call(null,map__13970__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.call(null,map__13970__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var map__13971 = p__13969;
var map__13971__$1 = cljs.core.__destructure_map.call(null,map__13971);
var node = map__13971__$1;
var node_first = cljs.core.get.call(null,map__13971__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var node_rhs = cljs.core.get.call(null,map__13971__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
if((!(fluree.db.index.branch_QMARK_.call(null,branch)))){
return false;
} else {
var and__4251__auto__ = (function (){var or__4253__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (!((cmp.call(null,first_flake,node_first) > (0))));
}
})();
if(cljs.core.truth_(and__4251__auto__)){
return (((rhs == null)) || ((((!((node_rhs == null)))) && ((!((cmp.call(null,node_rhs,rhs) > (0))))))));
} else {
return and__4251__auto__;
}
}
});
fluree.db.index.child_entry = (function fluree$db$index$child_entry(p__13972){
var map__13973 = p__13972;
var map__13973__$1 = cljs.core.__destructure_map.call(null,map__13973);
var node = map__13973__$1;
var first = cljs.core.get.call(null,map__13973__$1,new cljs.core.Keyword(null,"first","first",-644103046));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [first,node], null);
});
/**
 * Returns avl sorted map whose keys are the first flakes of the index node
 *   sequence `child-nodes`, and whose values are the corresponding nodes from
 *   `child-nodes`.
 */
fluree.db.index.child_map = (function fluree$db$index$child_map(var_args){
var args__4870__auto__ = [];
var len__4864__auto___13976 = arguments.length;
var i__4865__auto___13977 = (0);
while(true){
if((i__4865__auto___13977 < len__4864__auto___13976)){
args__4870__auto__.push((arguments[i__4865__auto___13977]));

var G__13978 = (i__4865__auto___13977 + (1));
i__4865__auto___13977 = G__13978;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic = (function (cmp,child_nodes){
return cljs.core.apply.call(null,fluree.db.flake.sorted_map_by,cmp,cljs.core.mapcat.call(null,fluree.db.index.child_entry,child_nodes));
}));

(fluree.db.index.child_map.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.index.child_map.cljs$lang$applyTo = (function (seq13974){
var G__13975 = cljs.core.first.call(null,seq13974);
var seq13974__$1 = cljs.core.next.call(null,seq13974);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13975,seq13974__$1);
}));

/**
 * Returns a blank branch node which contains a single empty leaf node for the
 *   provided `network`, `ledger-id`, and index comparator `cmp`.
 */
fluree.db.index.empty_branch = (function fluree$db$index$empty_branch(network,ledger_id,cmp){
var child_node = fluree.db.index.empty_leaf.call(null,network,ledger_id,cmp);
var children = fluree.db.index.child_map.call(null,cmp,child_node);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[children,(0),ledger_id,false,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.reset_children = (function fluree$db$index$reset_children(p__13979,new_child_nodes){
var map__13980 = p__13979;
var map__13980__$1 = cljs.core.__destructure_map.call(null,map__13980);
var branch = map__13980__$1;
var comparator = cljs.core.get.call(null,map__13980__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var size = cljs.core.get.call(null,map__13980__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var new_kids = cljs.core.apply.call(null,fluree.db.index.child_map,comparator,new_child_nodes);
var new_first = (function (){var or__4253__auto__ = (function (){var G__13981 = new_kids;
var G__13981__$1 = (((G__13981 == null))?null:cljs.core.first.call(null,G__13981));
if((G__13981__$1 == null)){
return null;
} else {
return cljs.core.key.call(null,G__13981__$1);
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
var new_size = cljs.core.reduce.call(null,cljs.core._PLUS_,size,cljs.core.map.call(null,new cljs.core.Keyword(null,"size","size",1098693007),new_child_nodes));
return cljs.core.assoc.call(null,branch,new cljs.core.Keyword(null,"first","first",-644103046),new_first,new cljs.core.Keyword(null,"size","size",1098693007),new_size,new cljs.core.Keyword(null,"children","children",-940561982),new_kids);
});
fluree.db.index.new_branch = (function fluree$db$index$new_branch(network,ledger_id,cmp,child_nodes){
return fluree.db.index.reset_children.call(null,fluree.db.index.empty_branch.call(null,network,ledger_id,cmp),child_nodes);
});
/**
 * Returns `true` if `flake` has a transaction value after the provided `t`
 */
fluree.db.index.after_t_QMARK_ = (function fluree$db$index$after_t_QMARK_(t,flake){
return (fluree.db.flake.t.call(null,flake) < t);
});
/**
 * Returns a sequence containing only flakes from the flake set `flakes` with
 *   transaction values after the provided `t`.
 */
fluree.db.index.filter_after = (function fluree$db$index$filter_after(t,flakes){
return cljs.core.filter.call(null,cljs.core.partial.call(null,fluree.db.index.after_t_QMARK_,t),flakes);
});
/**
 * Returns an avl-subset of the avl-set `flakes` with transaction values on or
 *   before the provided `t`.
 */
fluree.db.index.flakes_through = (function fluree$db$index$flakes_through(t,flakes){
return fluree.db.flake.disj_all.call(null,flakes,fluree.db.index.filter_after.call(null,t,flakes));
});
fluree.db.index.novelty_subrange = (function fluree$db$index$novelty_subrange(p__13982,through_t,novelty){
var map__13983 = p__13982;
var map__13983__$1 = cljs.core.__destructure_map.call(null,map__13983);
var node = map__13983__$1;
var first_flake = cljs.core.get.call(null,map__13983__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.call(null,map__13983__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.call(null,map__13983__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var subrange = (cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4251__auto__ = (rhs == null);
if(and__4251__auto__){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?novelty:null))));
return fluree.db.index.flakes_through.call(null,through_t,subrange);
});
/**
 * Returns a sequence of flakes from the sorted set `flakes` that are out of date
 *   by the transaction `t` because `flakes` contains another flake with the same
 *   subject and predicate and a transaction value later than that flake but on or
 *   before `t`.
 */
fluree.db.index.stale_by = (function fluree$db$index$stale_by(t,flakes){
return cljs.core.mapcat.call(null,(function (flakes__$1){
var last_flake = cljs.core.last.call(null,flakes__$1);
if(cljs.core.truth_(fluree.db.flake.op.call(null,last_flake))){
return cljs.core.butlast.call(null,flakes__$1);
} else {
return flakes__$1;
}
}),cljs.core.partition_by.call(null,cljs.core.juxt.call(null,fluree.db.flake.s,fluree.db.flake.p,fluree.db.flake.o),cljs.core.filter.call(null,cljs.core.complement.call(null,cljs.core.partial.call(null,fluree.db.index.after_t_QMARK_,t)),flakes)));
});
/**
 * Returns a sorted set of flakes that are not out of date between the
 *   transactions `from-t` and `to-t`.
 */
fluree.db.index.t_range = (function fluree$db$index$t_range(p__13984,novelty,from_t,to_t){
var map__13985 = p__13984;
var map__13985__$1 = cljs.core.__destructure_map.call(null,map__13985);
var leaf = map__13985__$1;
var leaf_t = cljs.core.get.call(null,map__13985__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__13985__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var latest = (function (){var G__13986 = flakes;
if((leaf_t > to_t)){
return fluree.db.flake.conj_all.call(null,G__13986,fluree.db.index.novelty_subrange.call(null,leaf,to_t,novelty));
} else {
return G__13986;
}
})();
var stale_flakes = fluree.db.index.stale_by.call(null,from_t,latest);
var subsequent = fluree.db.index.filter_after.call(null,to_t,latest);
var out_of_range = cljs.core.concat.call(null,stale_flakes,subsequent);
return fluree.db.flake.disj_all.call(null,latest,out_of_range);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.CachedTRangeResolver = (function (node_resolver,novelty,from_t,to_t,async_cache,__meta,__extmap,__hash){
this.node_resolver = node_resolver;
this.novelty = novelty;
this.from_t = from_t;
this.to_t = to_t;
this.async_cache = async_cache;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (_,p__13992){
var self__ = this;
var map__13993 = p__13992;
var map__13993__$1 = cljs.core.__destructure_map.call(null,map__13993);
var node = map__13993__$1;
var id = cljs.core.get.call(null,map__13993__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tempid = cljs.core.get.call(null,map__13993__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var tt_id = cljs.core.get.call(null,map__13993__$1,new cljs.core.Keyword(null,"tt-id","tt-id",725587484));
var ___$1 = this;
if(fluree.db.index.branch_QMARK_.call(null,node)){
return fluree.db.index.resolve.call(null,self__.node_resolver,node);
} else {
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.index","t-range","fluree.db.index/t-range",437950593),id,tempid,tt_id,self__.from_t,self__.to_t], null),(function (___$2){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14011){
var state_val_14012 = (state_14011[(1)]);
if((state_val_14012 === (1))){
var state_14011__$1 = state_14011;
var statearr_14013_14037 = state_14011__$1;
(statearr_14013_14037[(2)] = null);

(statearr_14013_14037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14012 === (2))){
var ___$3 = (function (){var statearr_14014 = state_14011;
(statearr_14014[(4)] = cljs.core.cons.call(null,(5),(state_14011[(4)])));

return statearr_14014;
})();
var inst_14000 = fluree.db.index.resolve.call(null,self__.node_resolver,node);
var state_14011__$1 = state_14011;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14011__$1,(6),inst_14000);
} else {
if((state_val_14012 === (3))){
var inst_14009 = (state_14011[(2)]);
var state_14011__$1 = state_14011;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14011__$1,inst_14009);
} else {
if((state_val_14012 === (4))){
var inst_13994 = (state_14011[(2)]);
var state_14011__$1 = state_14011;
var statearr_14016_14038 = state_14011__$1;
(statearr_14016_14038[(2)] = inst_13994);

(statearr_14016_14038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14012 === (5))){
var ___$3 = (function (){var statearr_14017 = state_14011;
(statearr_14017[(4)] = cljs.core.rest.call(null,(state_14011[(4)])));

return statearr_14017;
})();
var state_14011__$1 = state_14011;
var ex14015 = (state_14011__$1[(2)]);
var statearr_14018_14039 = state_14011__$1;
(statearr_14018_14039[(5)] = ex14015);


if((ex14015 instanceof Error)){
var statearr_14019_14040 = state_14011__$1;
(statearr_14019_14040[(1)] = (4));

(statearr_14019_14040[(5)] = null);

} else {
throw ex14015;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14012 === (6))){
var inst_14002 = (state_14011[(2)]);
var inst_14003 = fluree.db.util.async.throw_err.call(null,inst_14002);
var inst_14004 = fluree.db.index.t_range.call(null,inst_14003,self__.novelty,self__.from_t,self__.to_t);
var inst_14005 = cljs.core.dissoc.call(null,inst_14003,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_14006 = cljs.core.assoc.call(null,inst_14005,new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_14004);
var ___$3 = (function (){var statearr_14020 = state_14011;
(statearr_14020[(4)] = cljs.core.rest.call(null,(state_14011[(4)])));

return statearr_14020;
})();
var state_14011__$1 = state_14011;
var statearr_14021_14041 = state_14011__$1;
(statearr_14021_14041[(2)] = inst_14006);

(statearr_14021_14041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2727__auto__ = null;
var fluree$db$index$state_machine__2727__auto____0 = (function (){
var statearr_14022 = [null,null,null,null,null,null,null];
(statearr_14022[(0)] = fluree$db$index$state_machine__2727__auto__);

(statearr_14022[(1)] = (1));

return statearr_14022;
});
var fluree$db$index$state_machine__2727__auto____1 = (function (state_14011){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_14011);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14023){var ex__2730__auto__ = e14023;
var statearr_14024_14042 = state_14011;
(statearr_14024_14042[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_14011[(4)]))){
var statearr_14025_14043 = state_14011;
(statearr_14025_14043[(1)] = cljs.core.first.call(null,(state_14011[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14044 = state_14011;
state_14011 = G__14044;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$state_machine__2727__auto__ = function(state_14011){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2727__auto____1.call(this,state_14011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2727__auto____0;
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2727__auto____1;
return fluree$db$index$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14026 = f__2750__auto__.call(null);
(statearr_14026[(6)] = c__2749__auto__);

return statearr_14026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k13988,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__14027 = k13988;
var G__14027__$1 = (((G__14027 instanceof cljs.core.Keyword))?G__14027.fqn:null);
switch (G__14027__$1) {
case "node-resolver":
return self__.node_resolver;

break;
case "novelty":
return self__.novelty;

break;
case "from-t":
return self__.from_t;

break;
case "to-t":
return self__.to_t;

break;
case "async-cache":
return self__.async_cache;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k13988,else__4505__auto__);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__14028){
var vec__14029 = p__14028;
var k__4526__auto__ = cljs.core.nth.call(null,vec__14029,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__14029,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.index.CachedTRangeResolver{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__13987){
var self__ = this;
var G__13987__$1 = this;
return (new cljs.core.RecordIter((0),G__13987__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (361103374 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this13989,other13990){
var self__ = this;
var this13989__$1 = this;
return (((!((other13990 == null)))) && ((((this13989__$1.constructor === other13990.constructor)) && (((cljs.core._EQ_.call(null,this13989__$1.node_resolver,other13990.node_resolver)) && (((cljs.core._EQ_.call(null,this13989__$1.novelty,other13990.novelty)) && (((cljs.core._EQ_.call(null,this13989__$1.from_t,other13990.from_t)) && (((cljs.core._EQ_.call(null,this13989__$1.to_t,other13990.to_t)) && (((cljs.core._EQ_.call(null,this13989__$1.async_cache,other13990.async_cache)) && (cljs.core._EQ_.call(null,this13989__$1.__extmap,other13990.__extmap)))))))))))))));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),null,new cljs.core.Keyword(null,"from-t","from-t",1730913525),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"to-t","to-t",569467359),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k13988){
var self__ = this;
var this__4509__auto____$1 = this;
var G__14032 = k13988;
var G__14032__$1 = (((G__14032 instanceof cljs.core.Keyword))?G__14032.fqn:null);
switch (G__14032__$1) {
case "node-resolver":
case "novelty":
case "from-t":
case "to-t":
case "async-cache":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k13988);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__13987){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__14033 = cljs.core.keyword_identical_QMARK_;
var expr__14034 = k__4511__auto__;
if(cljs.core.truth_(pred__14033.call(null,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),expr__14034))){
return (new fluree.db.index.CachedTRangeResolver(G__13987,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14033.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__14034))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,G__13987,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14033.call(null,new cljs.core.Keyword(null,"from-t","from-t",1730913525),expr__14034))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,G__13987,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14033.call(null,new cljs.core.Keyword(null,"to-t","to-t",569467359),expr__14034))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,G__13987,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14033.call(null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),expr__14034))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,G__13987,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__13987),null));
}
}
}
}
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__13987){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,G__13987,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.index.CachedTRangeResolver.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node-resolver","node-resolver",-1971835691,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"from-t","from-t",-923522244,null),new cljs.core.Symbol(null,"to-t","to-t",-2084968410,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null)], null);
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$type = true);

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.index/CachedTRangeResolver",null,(1),null));
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.index/CachedTRangeResolver");
}));

/**
 * Positional factory function for fluree.db.index/CachedTRangeResolver.
 */
fluree.db.index.__GT_CachedTRangeResolver = (function fluree$db$index$__GT_CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache){
return (new fluree.db.index.CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache,null,null,null));
});

/**
 * Factory function for fluree.db.index/CachedTRangeResolver, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_CachedTRangeResolver = (function fluree$db$index$map__GT_CachedTRangeResolver(G__13991){
var extmap__4542__auto__ = (function (){var G__14036 = cljs.core.dissoc.call(null,G__13991,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
if(cljs.core.record_QMARK_.call(null,G__13991)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__14036);
} else {
return G__14036;
}
})();
return (new fluree.db.index.CachedTRangeResolver(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078).cljs$core$IFn$_invoke$arity$1(G__13991),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__13991),new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(G__13991),new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(G__13991),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__13991),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

/**
 * Find the value of `leaf` at transaction `t` by adding new flakes from
 *   `idx-novelty` to `leaf` if `t` is newer than `leaf`, or removing flakes later
 *   than `t` from `leaf` if `t` is older than `leaf`.
 */
fluree.db.index.at_t = (function fluree$db$index$at_t(p__14047,t,idx_novelty){
var map__14048 = p__14047;
var map__14048__$1 = cljs.core.__destructure_map.call(null,map__14048);
var leaf = map__14048__$1;
var leaf_t = cljs.core.get.call(null,map__14048__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var rhs = cljs.core.get.call(null,map__14048__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.call(null,map__14048__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var flakes = cljs.core.get.call(null,map__14048__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
if(cljs.core._EQ_.call(null,leaf_t,t)){
return leaf;
} else {
var G__14049 = leaf;
var G__14049__$1 = (((leaf_t > t))?fluree.db.index.add_flakes.call(null,G__14049,fluree.db.index.novelty_subrange.call(null,leaf,t,idx_novelty)):G__14049);
var G__14049__$2 = (((leaf_t < t))?fluree.db.index.rem_flakes.call(null,G__14049__$1,fluree.db.index.filter_after.call(null,t,flakes)):G__14049__$1);
return cljs.core.assoc.call(null,G__14049__$2,new cljs.core.Keyword(null,"t","t",-1397832519),t);

}
});
fluree.db.index.mark_expanded = (function fluree$db$index$mark_expanded(node){
return cljs.core.assoc.call(null,node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179),true);
});
fluree.db.index.unmark_expanded = (function fluree$db$index$unmark_expanded(node){
return cljs.core.dissoc.call(null,node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179));
});
fluree.db.index.expanded_QMARK_ = (function fluree$db$index$expanded_QMARK_(node){
return new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179).cljs$core$IFn$_invoke$arity$1(node) === true;
});
fluree.db.index.resolve_when = (function fluree$db$index$resolve_when(r,resolve_QMARK_,error_ch,node){
if(cljs.core.truth_(resolve_QMARK_.call(null,node))){
return fluree.db.index.try_resolve.call(null,r,error_ch,node);
} else {
var G__14050 = cljs.core.async.chan.call(null);
cljs.core.async.put_BANG_.call(null,G__14050,node);

return G__14050;
}
});
fluree.db.index.resolve_children_when = (function fluree$db$index$resolve_children_when(r,resolve_QMARK_,error_ch,branch){
if(cljs.core.truth_(fluree.db.index.resolved_QMARK_.call(null,branch))){
return cljs.core.async.map.call(null,cljs.core.vector,cljs.core.map.call(null,(function (p__14051){
var vec__14052 = p__14051;
var _ = cljs.core.nth.call(null,vec__14052,(0),null);
var child = cljs.core.nth.call(null,vec__14052,(1),null);
return fluree.db.index.resolve_when.call(null,r,resolve_QMARK_,error_ch,child);
}),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(branch)));
} else {
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14057){
var state_val_14058 = (state_14057[(1)]);
if((state_val_14058 === (1))){
var inst_14055 = cljs.core.PersistentVector.EMPTY;
var state_14057__$1 = state_14057;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14057__$1,inst_14055);
} else {
return null;
}
});
return (function() {
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto__ = null;
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0 = (function (){
var statearr_14059 = [null,null,null,null,null,null,null];
(statearr_14059[(0)] = fluree$db$index$resolve_children_when_$_state_machine__2727__auto__);

(statearr_14059[(1)] = (1));

return statearr_14059;
});
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1 = (function (state_14057){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_14057);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14060){var ex__2730__auto__ = e14060;
var statearr_14061_14064 = state_14057;
(statearr_14061_14064[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_14057[(4)]))){
var statearr_14062_14065 = state_14057;
(statearr_14062_14065[(1)] = cljs.core.first.call(null,(state_14057[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14066 = state_14057;
state_14057 = G__14066;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__ = function(state_14057){
switch(arguments.length){
case 0:
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1.call(this,state_14057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0;
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1;
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14063 = f__2750__auto__.call(null);
(statearr_14063[(6)] = c__2749__auto__);

return statearr_14063;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}
});
/**
 * Returns a channel that will eventually contain the stream of index nodes
 *   descended from `root` in depth-first order. `resolve?` is a boolean function
 *   that will be applied to each node to determine whether or not the data
 *   associated with that node will be resolved from disk using the supplied
 *   `Resolver` `r`. `include?` is a boolean function that will be applied to each
 *   node to determine if it will be included in the final output node stream, `n`
 *   is an optional parameter specifying the number of nodes to load concurrently,
 *   and `xf` is an optional transducer that will transform the output stream if
 *   supplied.
 */
fluree.db.index.tree_chan = (function fluree$db$index$tree_chan(var_args){
var G__14068 = arguments.length;
switch (G__14068) {
case 5:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 7:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5 = (function (r,root,resolve_QMARK_,include_QMARK_,error_ch){
return fluree.db.index.tree_chan.call(null,r,root,resolve_QMARK_,include_QMARK_,(1),cljs.core.identity,error_ch);
}));

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7 = (function (r,root,resolve_QMARK_,include_QMARK_,n,xf,error_ch){
var out = cljs.core.async.chan.call(null,n,xf);
var c__2749__auto___14146 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14114){
var state_val_14115 = (state_14114[(1)]);
if((state_val_14115 === (7))){
var inst_14109 = (state_14114[(2)]);
var state_14114__$1 = state_14114;
var statearr_14116_14147 = state_14114__$1;
(statearr_14116_14147[(2)] = inst_14109);

(statearr_14116_14147[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (1))){
var inst_14069 = fluree.db.index.resolve_when.call(null,r,resolve_QMARK_,error_ch,root);
var state_14114__$1 = state_14114;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14114__$1,(2),inst_14069);
} else {
if((state_val_14115 === (4))){
var inst_14111 = (state_14114[(2)]);
var inst_14112 = cljs.core.async.close_BANG_.call(null,out);
var state_14114__$1 = (function (){var statearr_14117 = state_14114;
(statearr_14117[(7)] = inst_14111);

return statearr_14117;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14114__$1,inst_14112);
} else {
if((state_val_14115 === (15))){
var state_14114__$1 = state_14114;
var statearr_14118_14148 = state_14114__$1;
(statearr_14118_14148[(2)] = null);

(statearr_14118_14148[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (13))){
var inst_14106 = (state_14114[(2)]);
var state_14114__$1 = state_14114;
var statearr_14119_14149 = state_14114__$1;
(statearr_14119_14149[(2)] = inst_14106);

(statearr_14119_14149[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (6))){
var state_14114__$1 = state_14114;
var statearr_14120_14150 = state_14114__$1;
(statearr_14120_14150[(2)] = null);

(statearr_14120_14150[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (17))){
var inst_14091 = (state_14114[(2)]);
var state_14114__$1 = state_14114;
var statearr_14121_14151 = state_14114__$1;
(statearr_14121_14151[(2)] = inst_14091);

(statearr_14121_14151[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (3))){
var inst_14075 = (state_14114[(8)]);
var inst_14077 = (state_14114[(9)]);
var inst_14077__$1 = cljs.core.peek.call(null,inst_14075);
var state_14114__$1 = (function (){var statearr_14122 = state_14114;
(statearr_14122[(9)] = inst_14077__$1);

return statearr_14122;
})();
if(cljs.core.truth_(inst_14077__$1)){
var statearr_14123_14152 = state_14114__$1;
(statearr_14123_14152[(1)] = (5));

} else {
var statearr_14124_14153 = state_14114__$1;
(statearr_14124_14153[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (12))){
var inst_14077 = (state_14114[(9)]);
var inst_14097 = fluree.db.index.resolve_children_when.call(null,r,resolve_QMARK_,error_ch,inst_14077);
var state_14114__$1 = state_14114;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14114__$1,(18),inst_14097);
} else {
if((state_val_14115 === (2))){
var inst_14071 = (state_14114[(2)]);
var inst_14072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14073 = [inst_14071];
var inst_14074 = (new cljs.core.PersistentVector(null,1,(5),inst_14072,inst_14073,null));
var inst_14075 = inst_14074;
var state_14114__$1 = (function (){var statearr_14125 = state_14114;
(statearr_14125[(8)] = inst_14075);

return statearr_14125;
})();
var statearr_14126_14154 = state_14114__$1;
(statearr_14126_14154[(2)] = null);

(statearr_14126_14154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (11))){
var inst_14077 = (state_14114[(9)]);
var inst_14087 = include_QMARK_.call(null,inst_14077);
var state_14114__$1 = state_14114;
if(cljs.core.truth_(inst_14087)){
var statearr_14127_14155 = state_14114__$1;
(statearr_14127_14155[(1)] = (14));

} else {
var statearr_14128_14156 = state_14114__$1;
(statearr_14128_14156[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (9))){
var inst_14077 = (state_14114[(9)]);
var inst_14083 = fluree.db.index.expanded_QMARK_.call(null,inst_14077);
var state_14114__$1 = state_14114;
var statearr_14129_14157 = state_14114__$1;
(statearr_14129_14157[(2)] = inst_14083);

(statearr_14129_14157[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (5))){
var inst_14075 = (state_14114[(8)]);
var inst_14080 = (state_14114[(10)]);
var inst_14077 = (state_14114[(9)]);
var inst_14079 = cljs.core.pop.call(null,inst_14075);
var inst_14080__$1 = fluree.db.index.leaf_QMARK_.call(null,inst_14077);
var state_14114__$1 = (function (){var statearr_14130 = state_14114;
(statearr_14130[(10)] = inst_14080__$1);

(statearr_14130[(11)] = inst_14079);

return statearr_14130;
})();
if(inst_14080__$1){
var statearr_14131_14158 = state_14114__$1;
(statearr_14131_14158[(1)] = (8));

} else {
var statearr_14132_14159 = state_14114__$1;
(statearr_14132_14159[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (14))){
var inst_14077 = (state_14114[(9)]);
var inst_14089 = fluree.db.index.unmark_expanded.call(null,inst_14077);
var state_14114__$1 = state_14114;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14114__$1,(17),out,inst_14089);
} else {
if((state_val_14115 === (16))){
var inst_14079 = (state_14114[(11)]);
var inst_14094 = (state_14114[(2)]);
var inst_14075 = inst_14079;
var state_14114__$1 = (function (){var statearr_14133 = state_14114;
(statearr_14133[(8)] = inst_14075);

(statearr_14133[(12)] = inst_14094);

return statearr_14133;
})();
var statearr_14134_14160 = state_14114__$1;
(statearr_14134_14160[(2)] = null);

(statearr_14134_14160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (10))){
var inst_14085 = (state_14114[(2)]);
var state_14114__$1 = state_14114;
if(cljs.core.truth_(inst_14085)){
var statearr_14135_14161 = state_14114__$1;
(statearr_14135_14161[(1)] = (11));

} else {
var statearr_14136_14162 = state_14114__$1;
(statearr_14136_14162[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (18))){
var inst_14079 = (state_14114[(11)]);
var inst_14077 = (state_14114[(9)]);
var inst_14099 = (state_14114[(2)]);
var inst_14100 = fluree.db.index.mark_expanded.call(null,inst_14077);
var inst_14101 = cljs.core.conj.call(null,inst_14079,inst_14100);
var inst_14102 = cljs.core.rseq.call(null,inst_14099);
var inst_14103 = cljs.core.into.call(null,inst_14101,inst_14102);
var inst_14075 = inst_14103;
var state_14114__$1 = (function (){var statearr_14137 = state_14114;
(statearr_14137[(8)] = inst_14075);

return statearr_14137;
})();
var statearr_14138_14163 = state_14114__$1;
(statearr_14138_14163[(2)] = null);

(statearr_14138_14163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (8))){
var inst_14080 = (state_14114[(10)]);
var state_14114__$1 = state_14114;
var statearr_14139_14164 = state_14114__$1;
(statearr_14139_14164[(2)] = inst_14080);

(statearr_14139_14164[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2727__auto__ = null;
var fluree$db$index$state_machine__2727__auto____0 = (function (){
var statearr_14140 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14140[(0)] = fluree$db$index$state_machine__2727__auto__);

(statearr_14140[(1)] = (1));

return statearr_14140;
});
var fluree$db$index$state_machine__2727__auto____1 = (function (state_14114){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_14114);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14141){var ex__2730__auto__ = e14141;
var statearr_14142_14165 = state_14114;
(statearr_14142_14165[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_14114[(4)]))){
var statearr_14143_14166 = state_14114;
(statearr_14143_14166[(1)] = cljs.core.first.call(null,(state_14114[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14167 = state_14114;
state_14114 = G__14167;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$state_machine__2727__auto__ = function(state_14114){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2727__auto____1.call(this,state_14114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2727__auto____0;
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2727__auto____1;
return fluree$db$index$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14144 = f__2750__auto__.call(null);
(statearr_14144[(6)] = c__2749__auto___14146);

return statearr_14144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));


return out;
}));

(fluree.db.index.tree_chan.cljs$lang$maxFixedArity = 7);

