// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql_resp');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql_resp.vswap_BANG_ = (function fluree$db$query$fql_resp$vswap_BANG_(var_args){
var G__19765 = arguments.length;
switch (G__19765) {
case 2:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql_resp.has_ns_lookups_QMARK_ = (function fluree$db$query$fql_resp$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql_resp.full_select_spec = (function fluree$db$query$fql_resp$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__4253__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql_resp$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql_resp.add_fuel = (function fluree$db$query$fql_resp$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql_resp.resolve_reverse_refs = (function fluree$db$query$fql_resp$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19926){
var state_val_19927 = (state_19926[(1)]);
if((state_val_19927 === (7))){
var inst_19921 = (state_19926[(2)]);
var _ = (function (){var statearr_19928 = state_19926;
(statearr_19928[(4)] = cljs.core.rest.call(null,(state_19926[(4)])));

return statearr_19928;
})();
var state_19926__$1 = state_19926;
var statearr_19929_20011 = state_19926__$1;
(statearr_19929_20011[(2)] = inst_19921);

(statearr_19929_20011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (20))){
var inst_19848 = (state_19926[(7)]);
var state_19926__$1 = state_19926;
var statearr_19930_20012 = state_19926__$1;
(statearr_19930_20012[(2)] = inst_19848);

(statearr_19930_20012[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (27))){
var inst_19803 = (state_19926[(8)]);
var state_19926__$1 = state_19926;
if(cljs.core.truth_(inst_19803)){
var statearr_19931_20013 = state_19926__$1;
(statearr_19931_20013[(1)] = (29));

} else {
var statearr_19932_20014 = state_19926__$1;
(statearr_19932_20014[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (1))){
var state_19926__$1 = state_19926;
var statearr_19933_20015 = state_19926__$1;
(statearr_19933_20015[(2)] = null);

(statearr_19933_20015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (24))){
var inst_19804 = (state_19926[(9)]);
var state_19926__$1 = state_19926;
var statearr_19934_20016 = state_19926__$1;
(statearr_19934_20016[(2)] = inst_19804);

(statearr_19934_20016[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (39))){
var inst_19840 = (state_19926[(10)]);
var state_19926__$1 = state_19926;
var statearr_19935_20017 = state_19926__$1;
(statearr_19935_20017[(2)] = inst_19840);

(statearr_19935_20017[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (46))){
var inst_19805 = (state_19926[(11)]);
var state_19926__$1 = state_19926;
var statearr_19936_20018 = state_19926__$1;
(statearr_19936_20018[(2)] = inst_19805);

(statearr_19936_20018[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (4))){
var inst_19767 = (state_19926[(2)]);
var state_19926__$1 = state_19926;
var statearr_19937_20019 = state_19926__$1;
(statearr_19937_20019[(2)] = inst_19767);

(statearr_19937_20019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (15))){
var inst_19816 = (state_19926[(12)]);
var inst_19822 = cljs.core.count.call(null,inst_19816);
var inst_19823 = fluree.db.query.fql_resp.add_fuel.call(null,fuel,inst_19822,max_fuel);
var state_19926__$1 = state_19926;
var statearr_19938_20020 = state_19926__$1;
(statearr_19938_20020[(2)] = inst_19823);

(statearr_19938_20020[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (48))){
var inst_19785 = (state_19926[(13)]);
var inst_19792 = (state_19926[(14)]);
var inst_19907 = (state_19926[(15)]);
var inst_19915 = (state_19926[(2)]);
var inst_19916 = cljs.core.assoc.call(null,inst_19785,inst_19915,inst_19907);
var inst_19784 = inst_19792;
var inst_19785__$1 = inst_19916;
var state_19926__$1 = (function (){var statearr_19939 = state_19926;
(statearr_19939[(13)] = inst_19785__$1);

(statearr_19939[(16)] = inst_19784);

return statearr_19939;
})();
var statearr_19940_20021 = state_19926__$1;
(statearr_19940_20021[(2)] = null);

(statearr_19940_20021[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (50))){
var inst_19807 = (state_19926[(17)]);
var state_19926__$1 = state_19926;
var statearr_19941_20022 = state_19926__$1;
(statearr_19941_20022[(2)] = inst_19807);

(statearr_19941_20022[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (21))){
var inst_19804 = (state_19926[(9)]);
var state_19926__$1 = state_19926;
if(cljs.core.truth_(inst_19804)){
var statearr_19943_20023 = state_19926__$1;
(statearr_19943_20023[(1)] = (23));

} else {
var statearr_19944_20024 = state_19926__$1;
(statearr_19944_20024[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (31))){
var inst_19864 = (state_19926[(2)]);
var state_19926__$1 = state_19926;
if(cljs.core.truth_(inst_19864)){
var statearr_19945_20025 = state_19926__$1;
(statearr_19945_20025[(1)] = (32));

} else {
var statearr_19946_20026 = state_19926__$1;
(statearr_19946_20026[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (32))){
var inst_19840 = (state_19926[(10)]);
var inst_19847 = (state_19926[(18)]);
var inst_19839 = (state_19926[(19)]);
var inst_19866 = (inst_19839 + (1));
var tmp19942 = inst_19840;
var inst_19838 = inst_19847;
var inst_19839__$1 = inst_19866;
var inst_19840__$1 = tmp19942;
var state_19926__$1 = (function (){var statearr_19947 = state_19926;
(statearr_19947[(20)] = inst_19838);

(statearr_19947[(10)] = inst_19840__$1);

(statearr_19947[(19)] = inst_19839__$1);

return statearr_19947;
})();
var statearr_19948_20027 = state_19926__$1;
(statearr_19948_20027[(2)] = null);

(statearr_19948_20027[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (40))){
var state_19926__$1 = state_19926;
if(cljs.core.truth_(fuel)){
var statearr_19949_20028 = state_19926__$1;
(statearr_19949_20028[(1)] = (42));

} else {
var statearr_19950_20029 = state_19926__$1;
(statearr_19950_20029[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (33))){
var state_19926__$1 = state_19926;
var statearr_19951_20030 = state_19926__$1;
(statearr_19951_20030[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (13))){
var inst_19816 = (state_19926[(12)]);
var state_19926__$1 = state_19926;
var statearr_19953_20031 = state_19926__$1;
(statearr_19953_20031[(2)] = inst_19816);

(statearr_19953_20031[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (22))){
var inst_19857 = (state_19926[(2)]);
var state_19926__$1 = state_19926;
if(cljs.core.truth_(inst_19857)){
var statearr_19954_20032 = state_19926__$1;
(statearr_19954_20032[(1)] = (26));

} else {
var statearr_19955_20033 = state_19926__$1;
(statearr_19955_20033[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (36))){
var state_19926__$1 = state_19926;
var statearr_19956_20034 = state_19926__$1;
(statearr_19956_20034[(2)] = null);

(statearr_19956_20034[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (41))){
var inst_19847 = (state_19926[(18)]);
var inst_19839 = (state_19926[(19)]);
var inst_19896 = (state_19926[(2)]);
var inst_19897 = (inst_19839 + (1));
var inst_19838 = inst_19847;
var inst_19839__$1 = inst_19897;
var inst_19840 = inst_19896;
var state_19926__$1 = (function (){var statearr_19957 = state_19926;
(statearr_19957[(20)] = inst_19838);

(statearr_19957[(10)] = inst_19840);

(statearr_19957[(19)] = inst_19839__$1);

return statearr_19957;
})();
var statearr_19958_20035 = state_19926__$1;
(statearr_19958_20035[(2)] = null);

(statearr_19958_20035[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (43))){
var state_19926__$1 = state_19926;
var statearr_19959_20036 = state_19926__$1;
(statearr_19959_20036[(2)] = null);

(statearr_19959_20036[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (29))){
var inst_19803 = (state_19926[(8)]);
var inst_19839 = (state_19926[(19)]);
var inst_19861 = (inst_19839 < inst_19803);
var state_19926__$1 = state_19926;
var statearr_19960_20037 = state_19926__$1;
(statearr_19960_20037[(2)] = inst_19861);

(statearr_19960_20037[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (44))){
var inst_19880 = (state_19926[(21)]);
var inst_19876 = (state_19926[(22)]);
var inst_19889 = (state_19926[(2)]);
var inst_19890 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_19880,inst_19876);
var state_19926__$1 = (function (){var statearr_19961 = state_19926;
(statearr_19961[(23)] = inst_19889);

return statearr_19961;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19926__$1,(45),inst_19890);
} else {
if((state_val_19927 === (6))){
var inst_19791 = (state_19926[(24)]);
var inst_19784 = (state_19926[(16)]);
var inst_19790 = cljs.core.seq.call(null,inst_19784);
var inst_19791__$1 = cljs.core.first.call(null,inst_19790);
var inst_19792 = cljs.core.next.call(null,inst_19790);
var inst_19793 = cljs.core.not.call(null,inst_19791__$1);
var state_19926__$1 = (function (){var statearr_19962 = state_19926;
(statearr_19962[(24)] = inst_19791__$1);

(statearr_19962[(14)] = inst_19792);

return statearr_19962;
})();
if(inst_19793){
var statearr_19963_20038 = state_19926__$1;
(statearr_19963_20038[(1)] = (8));

} else {
var statearr_19964_20039 = state_19926__$1;
(statearr_19964_20039[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (28))){
var inst_19905 = (state_19926[(2)]);
var state_19926__$1 = state_19926;
var statearr_19965_20040 = state_19926__$1;
(statearr_19965_20040[(2)] = inst_19905);

(statearr_19965_20040[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (51))){
var inst_19913 = (state_19926[(2)]);
var state_19926__$1 = state_19926;
var statearr_19966_20041 = state_19926__$1;
(statearr_19966_20041[(2)] = inst_19913);

(statearr_19966_20041[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (25))){
var inst_19855 = (state_19926[(2)]);
var state_19926__$1 = state_19926;
var statearr_19967_20042 = state_19926__$1;
(statearr_19967_20042[(2)] = inst_19855);

(statearr_19967_20042[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (34))){
var inst_19903 = (state_19926[(2)]);
var state_19926__$1 = state_19926;
var statearr_19968_20043 = state_19926__$1;
(statearr_19968_20043[(2)] = inst_19903);

(statearr_19968_20043[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (17))){
var inst_19816 = (state_19926[(12)]);
var inst_19826 = (state_19926[(2)]);
var inst_19834 = cljs.core.seq.call(null,inst_19816);
var inst_19835 = cljs.core.first.call(null,inst_19834);
var inst_19836 = cljs.core.next.call(null,inst_19834);
var inst_19837 = cljs.core.PersistentVector.EMPTY;
var inst_19838 = inst_19816;
var inst_19839 = (0);
var inst_19840 = inst_19837;
var state_19926__$1 = (function (){var statearr_19969 = state_19926;
(statearr_19969[(25)] = inst_19826);

(statearr_19969[(26)] = inst_19835);

(statearr_19969[(20)] = inst_19838);

(statearr_19969[(10)] = inst_19840);

(statearr_19969[(27)] = inst_19836);

(statearr_19969[(19)] = inst_19839);

return statearr_19969;
})();
var statearr_19970_20044 = state_19926__$1;
(statearr_19970_20044[(2)] = null);

(statearr_19970_20044[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (3))){
var inst_19924 = (state_19926[(2)]);
var state_19926__$1 = state_19926;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19926__$1,inst_19924);
} else {
if((state_val_19927 === (12))){
var state_19926__$1 = state_19926;
var statearr_19971_20045 = state_19926__$1;
(statearr_19971_20045[(2)] = fuel);

(statearr_19971_20045[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (2))){
var _ = (function (){var statearr_19972 = state_19926;
(statearr_19972[(4)] = cljs.core.cons.call(null,(5),(state_19926[(4)])));

return statearr_19972;
})();
var inst_19780 = reverse_refs_specs;
var inst_19781 = cljs.core.seq.call(null,inst_19780);
var inst_19782 = cljs.core.first.call(null,inst_19781);
var inst_19783 = cljs.core.next.call(null,inst_19781);
var inst_19784 = inst_19780;
var inst_19785 = null;
var state_19926__$1 = (function (){var statearr_19973 = state_19926;
(statearr_19973[(28)] = inst_19783);

(statearr_19973[(13)] = inst_19785);

(statearr_19973[(29)] = inst_19782);

(statearr_19973[(16)] = inst_19784);

return statearr_19973;
})();
var statearr_19974_20046 = state_19926__$1;
(statearr_19974_20046[(2)] = null);

(statearr_19974_20046[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (23))){
var inst_19804 = (state_19926[(9)]);
var inst_19839 = (state_19926[(19)]);
var inst_19852 = (inst_19839 >= inst_19804);
var state_19926__$1 = state_19926;
var statearr_19975_20047 = state_19926__$1;
(statearr_19975_20047[(2)] = inst_19852);

(statearr_19975_20047[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (47))){
var inst_19806 = (state_19926[(30)]);
var state_19926__$1 = state_19926;
if(cljs.core.truth_(inst_19806)){
var statearr_19976_20048 = state_19926__$1;
(statearr_19976_20048[(1)] = (49));

} else {
var statearr_19977_20049 = state_19926__$1;
(statearr_19977_20049[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (35))){
var inst_19846 = (state_19926[(31)]);
var inst_19870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19871 = [inst_19846];
var inst_19872 = (new cljs.core.PersistentVector(null,1,(5),inst_19870,inst_19871,null));
var inst_19873 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_19872);
var state_19926__$1 = state_19926;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19926__$1,(38),inst_19873);
} else {
if((state_val_19927 === (19))){
var inst_19805 = (state_19926[(11)]);
var inst_19907 = (state_19926[(2)]);
var state_19926__$1 = (function (){var statearr_19978 = state_19926;
(statearr_19978[(15)] = inst_19907);

return statearr_19978;
})();
if(cljs.core.truth_(inst_19805)){
var statearr_19979_20050 = state_19926__$1;
(statearr_19979_20050[(1)] = (46));

} else {
var statearr_19980_20051 = state_19926__$1;
(statearr_19980_20051[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (11))){
var inst_19816 = (state_19926[(12)]);
var inst_19813 = (state_19926[(2)]);
var inst_19814 = fluree.db.util.async.throw_err.call(null,inst_19813);
var inst_19815 = cljs.core.map.call(null,fluree.db.flake.s,inst_19814);
var inst_19816__$1 = cljs.core.not_empty.call(null,inst_19815);
var state_19926__$1 = (function (){var statearr_19982 = state_19926;
(statearr_19982[(12)] = inst_19816__$1);

return statearr_19982;
})();
if(cljs.core.truth_(inst_19816__$1)){
var statearr_19983_20052 = state_19926__$1;
(statearr_19983_20052[(1)] = (12));

} else {
var statearr_19984_20053 = state_19926__$1;
(statearr_19984_20053[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (9))){
var inst_19791 = (state_19926[(24)]);
var inst_19801 = (state_19926[(32)]);
var inst_19800 = cljs.core.nth.call(null,inst_19791,(0),null);
var inst_19801__$1 = cljs.core.nth.call(null,inst_19791,(1),null);
var inst_19802 = cljs.core.__destructure_map.call(null,inst_19801__$1);
var inst_19803 = cljs.core.get.call(null,inst_19802,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_19804 = cljs.core.get.call(null,inst_19802,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_19805 = cljs.core.get.call(null,inst_19802,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_19806 = cljs.core.get.call(null,inst_19802,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_19807 = cljs.core.get.call(null,inst_19802,new cljs.core.Keyword(null,"p","p",151049309));
var inst_19808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19809 = [subject_id,inst_19800];
var inst_19810 = (new cljs.core.PersistentVector(null,2,(5),inst_19808,inst_19809,null));
var inst_19811 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_19810);
var state_19926__$1 = (function (){var statearr_19985 = state_19926;
(statearr_19985[(11)] = inst_19805);

(statearr_19985[(17)] = inst_19807);

(statearr_19985[(8)] = inst_19803);

(statearr_19985[(9)] = inst_19804);

(statearr_19985[(32)] = inst_19801__$1);

(statearr_19985[(30)] = inst_19806);

return statearr_19985;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19926__$1,(11),inst_19811);
} else {
if((state_val_19927 === (5))){
var _ = (function (){var statearr_19986 = state_19926;
(statearr_19986[(4)] = cljs.core.rest.call(null,(state_19926[(4)])));

return statearr_19986;
})();
var state_19926__$1 = state_19926;
var ex19981 = (state_19926__$1[(2)]);
var statearr_19987_20054 = state_19926__$1;
(statearr_19987_20054[(5)] = ex19981);


if((ex19981 instanceof Error)){
var statearr_19988_20055 = state_19926__$1;
(statearr_19988_20055[(1)] = (4));

(statearr_19988_20055[(5)] = null);

} else {
throw ex19981;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (14))){
var inst_19820 = (state_19926[(2)]);
var state_19926__$1 = state_19926;
if(cljs.core.truth_(inst_19820)){
var statearr_19989_20056 = state_19926__$1;
(statearr_19989_20056[(1)] = (15));

} else {
var statearr_19990_20057 = state_19926__$1;
(statearr_19990_20057[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (45))){
var inst_19840 = (state_19926[(10)]);
var inst_19892 = (state_19926[(2)]);
var inst_19893 = fluree.db.util.async.throw_err.call(null,inst_19892);
var inst_19894 = cljs.core.conj.call(null,inst_19840,inst_19893);
var state_19926__$1 = state_19926;
var statearr_19991_20058 = state_19926__$1;
(statearr_19991_20058[(2)] = inst_19894);

(statearr_19991_20058[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (26))){
var inst_19840 = (state_19926[(10)]);
var state_19926__$1 = state_19926;
var statearr_19992_20059 = state_19926__$1;
(statearr_19992_20059[(2)] = inst_19840);

(statearr_19992_20059[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (16))){
var state_19926__$1 = state_19926;
var statearr_19993_20060 = state_19926__$1;
(statearr_19993_20060[(2)] = null);

(statearr_19993_20060[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (38))){
var inst_19876 = (state_19926[(22)]);
var inst_19801 = (state_19926[(32)]);
var inst_19875 = (state_19926[(2)]);
var inst_19876__$1 = fluree.db.util.async.throw_err.call(null,inst_19875);
var inst_19877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19878 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_19879 = (new cljs.core.PersistentVector(null,4,(5),inst_19877,inst_19878,null));
var inst_19880 = cljs.core.select_keys.call(null,inst_19801,inst_19879);
var inst_19881 = cljs.core.empty_QMARK_.call(null,inst_19876__$1);
var state_19926__$1 = (function (){var statearr_19994 = state_19926;
(statearr_19994[(21)] = inst_19880);

(statearr_19994[(22)] = inst_19876__$1);

return statearr_19994;
})();
if(inst_19881){
var statearr_19995_20061 = state_19926__$1;
(statearr_19995_20061[(1)] = (39));

} else {
var statearr_19996_20062 = state_19926__$1;
(statearr_19996_20062[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (30))){
var inst_19803 = (state_19926[(8)]);
var state_19926__$1 = state_19926;
var statearr_19997_20063 = state_19926__$1;
(statearr_19997_20063[(2)] = inst_19803);

(statearr_19997_20063[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (10))){
var inst_19919 = (state_19926[(2)]);
var state_19926__$1 = state_19926;
var statearr_19998_20064 = state_19926__$1;
(statearr_19998_20064[(2)] = inst_19919);

(statearr_19998_20064[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (18))){
var inst_19848 = (state_19926[(7)]);
var inst_19846 = (state_19926[(31)]);
var inst_19838 = (state_19926[(20)]);
var inst_19845 = cljs.core.seq.call(null,inst_19838);
var inst_19846__$1 = cljs.core.first.call(null,inst_19845);
var inst_19847 = cljs.core.next.call(null,inst_19845);
var inst_19848__$1 = cljs.core.not.call(null,inst_19846__$1);
var state_19926__$1 = (function (){var statearr_19999 = state_19926;
(statearr_19999[(7)] = inst_19848__$1);

(statearr_19999[(31)] = inst_19846__$1);

(statearr_19999[(18)] = inst_19847);

return statearr_19999;
})();
if(inst_19848__$1){
var statearr_20000_20065 = state_19926__$1;
(statearr_20000_20065[(1)] = (20));

} else {
var statearr_20001_20066 = state_19926__$1;
(statearr_20001_20066[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (42))){
var inst_19876 = (state_19926[(22)]);
var inst_19885 = cljs.core.count.call(null,inst_19876);
var inst_19886 = fluree.db.query.fql_resp.add_fuel.call(null,fuel,inst_19885,max_fuel);
var state_19926__$1 = state_19926;
var statearr_20002_20067 = state_19926__$1;
(statearr_20002_20067[(2)] = inst_19886);

(statearr_20002_20067[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (37))){
var inst_19901 = (state_19926[(2)]);
var state_19926__$1 = state_19926;
var statearr_20003_20068 = state_19926__$1;
(statearr_20003_20068[(2)] = inst_19901);

(statearr_20003_20068[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (8))){
var inst_19785 = (state_19926[(13)]);
var state_19926__$1 = state_19926;
var statearr_20004_20069 = state_19926__$1;
(statearr_20004_20069[(2)] = inst_19785);

(statearr_20004_20069[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19927 === (49))){
var inst_19806 = (state_19926[(30)]);
var state_19926__$1 = state_19926;
var statearr_20005_20070 = state_19926__$1;
(statearr_20005_20070[(2)] = inst_19806);

(statearr_20005_20070[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0 = (function (){
var statearr_20006 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20006[(0)] = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__);

(statearr_20006[(1)] = (1));

return statearr_20006;
});
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1 = (function (state_19926){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_19926);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20007){var ex__2730__auto__ = e20007;
var statearr_20008_20071 = state_19926;
(statearr_20008_20071[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_19926[(4)]))){
var statearr_20009_20072 = state_19926;
(statearr_20009_20072[(1)] = cljs.core.first.call(null,(state_19926[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20073 = state_19926;
state_19926 = G__20073;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__ = function(state_19926){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1.call(this,state_19926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20010 = f__2750__auto__.call(null);
(statearr_20010[(6)] = c__2749__auto__);

return statearr_20010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.fql_resp.component_follow_QMARK_ = (function fluree$db$query$fql_resp$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql_resp.fuel_flake_transducer = (function fluree$db$query$fql_resp$fuel_flake_transducer(var_args){
var G__20075 = arguments.length;
switch (G__20075) {
case 2:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql_resp.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__20077 = null;
var G__20077__0 = (function (){
return xf.call(null);
});
var G__20077__1 = (function (result){
return xf.call(null,result);
});
var G__20077__2 = (function (result,flake){
fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__20077 = function(result,flake){
switch(arguments.length){
case 0:
return G__20077__0.call(this);
case 1:
return G__20077__1.call(this,result);
case 2:
return G__20077__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20077.cljs$core$IFn$_invoke$arity$0 = G__20077__0;
G__20077.cljs$core$IFn$_invoke$arity$1 = G__20077__1;
G__20077.cljs$core$IFn$_invoke$arity$2 = G__20077__2;
return G__20077;
})()
});
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql_resp.recur_select_spec = (function fluree$db$query$fql_resp$recur_select_spec(select_spec,flake){
var recur_subject = fluree.db.flake.o.call(null,flake);
var recur_pred = fluree.db.flake.p.call(null,flake);
var map__20078 = select_spec;
var map__20078__$1 = cljs.core.__destructure_map.call(null,map__20078);
var recur_seen = cljs.core.get.call(null,map__20078__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__20078__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.flake__GT_recur = (function fluree$db$query$fql_resp$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20192){
var state_val_20193 = (state_20192[(1)]);
if((state_val_20193 === (7))){
var inst_20104 = flakes;
var inst_20105 = cljs.core.seq.call(null,inst_20104);
var inst_20106 = cljs.core.first.call(null,inst_20105);
var inst_20107 = cljs.core.next.call(null,inst_20105);
var inst_20108 = cljs.core.PersistentVector.EMPTY;
var inst_20109 = inst_20104;
var inst_20110 = (0);
var inst_20111 = inst_20108;
var state_20192__$1 = (function (){var statearr_20194 = state_20192;
(statearr_20194[(7)] = inst_20111);

(statearr_20194[(8)] = inst_20110);

(statearr_20194[(9)] = inst_20107);

(statearr_20194[(10)] = inst_20106);

(statearr_20194[(11)] = inst_20109);

return statearr_20194;
})();
var statearr_20195_20261 = state_20192__$1;
(statearr_20195_20261[(2)] = null);

(statearr_20195_20261[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (20))){
var state_20192__$1 = state_20192;
var statearr_20196_20262 = state_20192__$1;
(statearr_20196_20262[(2)] = results);

(statearr_20196_20262[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (27))){
var state_20192__$1 = state_20192;
var statearr_20197_20263 = state_20192__$1;
(statearr_20197_20263[(2)] = null);

(statearr_20197_20263[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (1))){
var state_20192__$1 = state_20192;
var statearr_20198_20264 = state_20192__$1;
(statearr_20198_20264[(2)] = null);

(statearr_20198_20264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (24))){
var state_20192__$1 = state_20192;
var statearr_20199_20265 = state_20192__$1;
(statearr_20199_20265[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (39))){
var inst_20111 = (state_20192[(7)]);
var inst_20118 = (state_20192[(12)]);
var inst_20173 = (state_20192[(13)]);
var inst_20176 = (state_20192[(2)]);
var inst_20177 = fluree.db.util.async.throw_err.call(null,inst_20176);
var inst_20178 = cljs.core.conj.call(null,inst_20111,inst_20177);
var inst_20109 = inst_20118;
var inst_20110 = inst_20173;
var inst_20111__$1 = inst_20178;
var state_20192__$1 = (function (){var statearr_20201 = state_20192;
(statearr_20201[(7)] = inst_20111__$1);

(statearr_20201[(8)] = inst_20110);

(statearr_20201[(11)] = inst_20109);

return statearr_20201;
})();
var statearr_20202_20266 = state_20192__$1;
(statearr_20202_20266[(2)] = null);

(statearr_20202_20266[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (4))){
var inst_20079 = (state_20192[(2)]);
var state_20192__$1 = state_20192;
var statearr_20203_20267 = state_20192__$1;
(statearr_20203_20267[(2)] = inst_20079);

(statearr_20203_20267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (15))){
var inst_20092 = (state_20192[(14)]);
var state_20192__$1 = state_20192;
var statearr_20204_20268 = state_20192__$1;
(statearr_20204_20268[(2)] = inst_20092);

(statearr_20204_20268[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (21))){
var inst_20088 = (state_20192[(15)]);
var state_20192__$1 = state_20192;
if(cljs.core.truth_(inst_20088)){
var statearr_20205_20269 = state_20192__$1;
(statearr_20205_20269[(1)] = (23));

} else {
var statearr_20206_20270 = state_20192__$1;
(statearr_20206_20270[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (31))){
var inst_20156 = (state_20192[(16)]);
var state_20192__$1 = state_20192;
var statearr_20207_20271 = state_20192__$1;
(statearr_20207_20271[(2)] = inst_20156);

(statearr_20207_20271[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (32))){
var inst_20148 = (state_20192[(17)]);
var inst_20162 = (state_20192[(2)]);
var state_20192__$1 = (function (){var statearr_20208 = state_20192;
(statearr_20208[(18)] = inst_20162);

return statearr_20208;
})();
if(cljs.core.truth_(inst_20148)){
var statearr_20209_20272 = state_20192__$1;
(statearr_20209_20272[(1)] = (33));

} else {
var statearr_20210_20273 = state_20192__$1;
(statearr_20210_20273[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (33))){
var inst_20148 = (state_20192[(17)]);
var state_20192__$1 = state_20192;
var statearr_20211_20274 = state_20192__$1;
(statearr_20211_20274[(2)] = inst_20148);

(statearr_20211_20274[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (13))){
var inst_20128 = (state_20192[(2)]);
var state_20192__$1 = state_20192;
if(cljs.core.truth_(inst_20128)){
var statearr_20213_20275 = state_20192__$1;
(statearr_20213_20275[(1)] = (17));

} else {
var statearr_20214_20276 = state_20192__$1;
(statearr_20214_20276[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (22))){
var inst_20145 = (state_20192[(2)]);
var state_20192__$1 = state_20192;
var statearr_20215_20277 = state_20192__$1;
(statearr_20215_20277[(2)] = inst_20145);

(statearr_20215_20277[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (36))){
var inst_20111 = (state_20192[(7)]);
var inst_20110 = (state_20192[(8)]);
var inst_20118 = (state_20192[(12)]);
var inst_20170 = (inst_20110 + (1));
var tmp20212 = inst_20111;
var inst_20109 = inst_20118;
var inst_20110__$1 = inst_20170;
var inst_20111__$1 = tmp20212;
var state_20192__$1 = (function (){var statearr_20216 = state_20192;
(statearr_20216[(7)] = inst_20111__$1);

(statearr_20216[(8)] = inst_20110__$1);

(statearr_20216[(11)] = inst_20109);

return statearr_20216;
})();
var statearr_20217_20278 = state_20192__$1;
(statearr_20217_20278[(2)] = null);

(statearr_20217_20278[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (29))){
var inst_20155 = (state_20192[(2)]);
var inst_20156 = fluree.db.util.async.throw_err.call(null,inst_20155);
var state_20192__$1 = (function (){var statearr_20218 = state_20192;
(statearr_20218[(16)] = inst_20156);

return statearr_20218;
})();
if(cljs.core.truth_(fuel)){
var statearr_20219_20279 = state_20192__$1;
(statearr_20219_20279[(1)] = (30));

} else {
var statearr_20220_20280 = state_20192__$1;
(statearr_20220_20280[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (6))){
var state_20192__$1 = state_20192;
var statearr_20221_20281 = state_20192__$1;
(statearr_20221_20281[(2)] = results);

(statearr_20221_20281[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (28))){
var inst_20141 = (state_20192[(2)]);
var state_20192__$1 = state_20192;
var statearr_20222_20282 = state_20192__$1;
(statearr_20222_20282[(2)] = inst_20141);

(statearr_20222_20282[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (25))){
var inst_20143 = (state_20192[(2)]);
var state_20192__$1 = state_20192;
var statearr_20223_20283 = state_20192__$1;
(statearr_20223_20283[(2)] = inst_20143);

(statearr_20223_20283[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (34))){
var inst_20162 = (state_20192[(18)]);
var inst_20165 = cljs.core.empty_QMARK_.call(null,inst_20162);
var state_20192__$1 = state_20192;
var statearr_20224_20284 = state_20192__$1;
(statearr_20224_20284[(2)] = inst_20165);

(statearr_20224_20284[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (17))){
var inst_20111 = (state_20192[(7)]);
var inst_20130 = cljs.core.empty_QMARK_.call(null,inst_20111);
var state_20192__$1 = state_20192;
if(inst_20130){
var statearr_20225_20285 = state_20192__$1;
(statearr_20225_20285[(1)] = (20));

} else {
var statearr_20226_20286 = state_20192__$1;
(statearr_20226_20286[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (3))){
var inst_20190 = (state_20192[(2)]);
var state_20192__$1 = state_20192;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20192__$1,inst_20190);
} else {
if((state_val_20193 === (12))){
var inst_20092 = (state_20192[(14)]);
var state_20192__$1 = state_20192;
if(cljs.core.truth_(inst_20092)){
var statearr_20227_20287 = state_20192__$1;
(statearr_20227_20287[(1)] = (14));

} else {
var statearr_20228_20288 = state_20192__$1;
(statearr_20228_20288[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (2))){
var _ = (function (){var statearr_20229 = state_20192;
(statearr_20229[(4)] = cljs.core.cons.call(null,(5),(state_20192[(4)])));

return statearr_20229;
})();
var inst_20086 = select_spec;
var inst_20087 = cljs.core.__destructure_map.call(null,inst_20086);
var inst_20088 = cljs.core.get.call(null,inst_20087,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_20089 = cljs.core.get.call(null,inst_20087,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_20090 = cljs.core.get.call(null,inst_20087,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_20091 = cljs.core.get.call(null,inst_20087,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_20092 = cljs.core.get.call(null,inst_20087,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_20093 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_20094 = (inst_20091 > inst_20093);
var state_20192__$1 = (function (){var statearr_20230 = state_20192;
(statearr_20230[(14)] = inst_20092);

(statearr_20230[(19)] = inst_20089);

(statearr_20230[(20)] = inst_20090);

(statearr_20230[(15)] = inst_20088);

return statearr_20230;
})();
if(cljs.core.truth_(inst_20094)){
var statearr_20231_20289 = state_20192__$1;
(statearr_20231_20289[(1)] = (6));

} else {
var statearr_20232_20290 = state_20192__$1;
(statearr_20232_20290[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (23))){
var inst_20111 = (state_20192[(7)]);
var inst_20089 = (state_20192[(19)]);
var inst_20134 = cljs.core.assoc.call(null,results,inst_20089,inst_20111);
var state_20192__$1 = state_20192;
var statearr_20233_20291 = state_20192__$1;
(statearr_20233_20291[(2)] = inst_20134);

(statearr_20233_20291[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (35))){
var inst_20117 = (state_20192[(21)]);
var inst_20167 = (state_20192[(2)]);
var inst_20168 = fluree.db.query.fql_resp.recur_select_spec.call(null,select_spec,inst_20117);
var state_20192__$1 = (function (){var statearr_20234 = state_20192;
(statearr_20234[(22)] = inst_20168);

return statearr_20234;
})();
if(cljs.core.truth_(inst_20167)){
var statearr_20235_20292 = state_20192__$1;
(statearr_20235_20292[(1)] = (36));

} else {
var statearr_20236_20293 = state_20192__$1;
(statearr_20236_20293[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (19))){
var inst_20183 = (state_20192[(2)]);
var state_20192__$1 = state_20192;
var statearr_20237_20294 = state_20192__$1;
(statearr_20237_20294[(2)] = inst_20183);

(statearr_20237_20294[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (11))){
var inst_20119 = (state_20192[(23)]);
var state_20192__$1 = state_20192;
var statearr_20239_20295 = state_20192__$1;
(statearr_20239_20295[(2)] = inst_20119);

(statearr_20239_20295[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (9))){
var inst_20119 = (state_20192[(23)]);
var inst_20109 = (state_20192[(11)]);
var inst_20117 = (state_20192[(21)]);
var inst_20116 = cljs.core.seq.call(null,inst_20109);
var inst_20117__$1 = cljs.core.first.call(null,inst_20116);
var inst_20118 = cljs.core.next.call(null,inst_20116);
var inst_20119__$1 = cljs.core.not.call(null,inst_20117__$1);
var state_20192__$1 = (function (){var statearr_20240 = state_20192;
(statearr_20240[(12)] = inst_20118);

(statearr_20240[(23)] = inst_20119__$1);

(statearr_20240[(21)] = inst_20117__$1);

return statearr_20240;
})();
if(inst_20119__$1){
var statearr_20241_20296 = state_20192__$1;
(statearr_20241_20296[(1)] = (11));

} else {
var statearr_20242_20297 = state_20192__$1;
(statearr_20242_20297[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (5))){
var _ = (function (){var statearr_20243 = state_20192;
(statearr_20243[(4)] = cljs.core.rest.call(null,(state_20192[(4)])));

return statearr_20243;
})();
var state_20192__$1 = state_20192;
var ex20238 = (state_20192__$1[(2)]);
var statearr_20244_20298 = state_20192__$1;
(statearr_20244_20298[(5)] = ex20238);


if((ex20238 instanceof Error)){
var statearr_20245_20299 = state_20192__$1;
(statearr_20245_20299[(1)] = (4));

(statearr_20245_20299[(5)] = null);

} else {
throw ex20238;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (14))){
var inst_20092 = (state_20192[(14)]);
var inst_20110 = (state_20192[(8)]);
var inst_20123 = (inst_20110 < inst_20092);
var state_20192__$1 = state_20192;
var statearr_20246_20300 = state_20192__$1;
(statearr_20246_20300[(2)] = inst_20123);

(statearr_20246_20300[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (26))){
var inst_20111 = (state_20192[(7)]);
var inst_20089 = (state_20192[(19)]);
var inst_20137 = cljs.core.first.call(null,inst_20111);
var inst_20138 = cljs.core.assoc.call(null,results,inst_20089,inst_20137);
var state_20192__$1 = state_20192;
var statearr_20247_20301 = state_20192__$1;
(statearr_20247_20301[(2)] = inst_20138);

(statearr_20247_20301[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (16))){
var inst_20126 = (state_20192[(2)]);
var state_20192__$1 = state_20192;
var statearr_20248_20302 = state_20192__$1;
(statearr_20248_20302[(2)] = inst_20126);

(statearr_20248_20302[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (38))){
var inst_20181 = (state_20192[(2)]);
var state_20192__$1 = state_20192;
var statearr_20249_20303 = state_20192__$1;
(statearr_20249_20303[(2)] = inst_20181);

(statearr_20249_20303[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (30))){
var inst_20156 = (state_20192[(16)]);
var inst_20158 = fluree.db.query.fql_resp.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_20159 = cljs.core.sequence.call(null,inst_20158,inst_20156);
var state_20192__$1 = state_20192;
var statearr_20250_20304 = state_20192__$1;
(statearr_20250_20304[(2)] = inst_20159);

(statearr_20250_20304[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (10))){
var inst_20185 = (state_20192[(2)]);
var state_20192__$1 = state_20192;
var statearr_20251_20305 = state_20192__$1;
(statearr_20251_20305[(2)] = inst_20185);

(statearr_20251_20305[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20193 === (18))){
var inst_20090 = (state_20192[(20)]);
var inst_20117 = (state_20192[(21)]);
var inst_20147 = fluree.db.flake.o.call(null,inst_20117);
var inst_20148 = cljs.core.contains_QMARK_.call(null,inst_20090,inst_20147);
var inst_20150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20151 = [inst_20147];
var inst_20152 = (new cljs.core.PersistentVector(null,1,(5),inst_20150,inst_20151,null));
var inst_20153 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20152);
var state_20192__$1 = (function (){var statearr_20252 = state_20192;
(statearr_20252[(17)] = inst_20148);

return statearr_20252;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20192__$1,(29),inst_20153);
} else {
if((state_val_20193 === (37))){
var inst_20110 = (state_20192[(8)]);
var inst_20162 = (state_20192[(18)]);
var inst_20168 = (state_20192[(22)]);
var inst_20173 = (inst_20110 + (1));
var inst_20174 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_20168,inst_20162);
var state_20192__$1 = (function (){var statearr_20253 = state_20192;
(statearr_20253[(13)] = inst_20173);

return statearr_20253;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20192__$1,(39),inst_20174);
} else {
if((state_val_20193 === (8))){
var inst_20187 = (state_20192[(2)]);
var _ = (function (){var statearr_20254 = state_20192;
(statearr_20254[(4)] = cljs.core.rest.call(null,(state_20192[(4)])));

return statearr_20254;
})();
var state_20192__$1 = state_20192;
var statearr_20255_20306 = state_20192__$1;
(statearr_20255_20306[(2)] = inst_20187);

(statearr_20255_20306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0 = (function (){
var statearr_20256 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20256[(0)] = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__);

(statearr_20256[(1)] = (1));

return statearr_20256;
});
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1 = (function (state_20192){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_20192);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20257){var ex__2730__auto__ = e20257;
var statearr_20258_20307 = state_20192;
(statearr_20258_20307[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_20192[(4)]))){
var statearr_20259_20308 = state_20192;
(statearr_20259_20308[(1)] = cljs.core.first.call(null,(state_20192[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20309 = state_20192;
state_20192 = G__20309;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__ = function(state_20192){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1.call(this,state_20192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20260 = f__2750__auto__.call(null);
(statearr_20260[(6)] = c__2749__auto__);

return statearr_20260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql_resp.wildcard_pred_spec = (function fluree$db$query$fql_resp$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4253__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.add_pred = (function fluree$db$query$fql_resp$add_pred(var_args){
var G__20313 = arguments.length;
switch (G__20313) {
case 9:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20752){
var state_val_20753 = (state_20752[(1)]);
if((state_val_20753 === (121))){
var inst_20675 = (state_20752[(2)]);
var inst_20676 = fluree.db.util.async.throw_err.call(null,inst_20675);
var inst_20677 = cljs.core.seq.call(null,inst_20676);
var state_20752__$1 = state_20752;
if(inst_20677){
var statearr_20754_20968 = state_20752__$1;
(statearr_20754_20968[(1)] = (122));

} else {
var statearr_20755_20969 = state_20752__$1;
(statearr_20755_20969[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (65))){
var inst_20468 = (state_20752[(7)]);
var inst_20467 = (state_20752[(2)]);
var inst_20468__$1 = fluree.db.util.async.throw_err.call(null,inst_20467);
var inst_20469 = cljs.core.seq.call(null,inst_20468__$1);
var state_20752__$1 = (function (){var statearr_20756 = state_20752;
(statearr_20756[(7)] = inst_20468__$1);

return statearr_20756;
})();
if(inst_20469){
var statearr_20757_20970 = state_20752__$1;
(statearr_20757_20970[(1)] = (66));

} else {
var statearr_20758_20971 = state_20752__$1;
(statearr_20758_20971[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (70))){
var inst_20468 = (state_20752[(7)]);
var inst_20479 = cljs.core.count.call(null,inst_20468);
var inst_20480 = fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_20479);
var state_20752__$1 = state_20752;
var statearr_20759_20972 = state_20752__$1;
(statearr_20759_20972[(2)] = inst_20480);

(statearr_20759_20972[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (62))){
var inst_20458 = (state_20752[(8)]);
var inst_20461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20462 = fluree.db.flake.o.call(null,inst_20458);
var inst_20463 = [inst_20462];
var inst_20464 = (new cljs.core.PersistentVector(null,1,(5),inst_20461,inst_20463,null));
var inst_20465 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20464);
var state_20752__$1 = state_20752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20752__$1,(65),inst_20465);
} else {
if((state_val_20753 === (74))){
var inst_20452 = (state_20752[(9)]);
var state_20752__$1 = state_20752;
var statearr_20760_20973 = state_20752__$1;
(statearr_20760_20973[(2)] = inst_20452);

(statearr_20760_20973[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (110))){
var inst_20637 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_20638 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_20637);
var inst_20639 = inst_20638 === true;
var state_20752__$1 = state_20752;
if(cljs.core.truth_(inst_20639)){
var statearr_20761_20974 = state_20752__$1;
(statearr_20761_20974[(1)] = (113));

} else {
var statearr_20762_20975 = state_20752__$1;
(statearr_20762_20975[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (130))){
var inst_20747 = (state_20752[(2)]);
var _ = (function (){var statearr_20763 = state_20752;
(statearr_20763[(4)] = cljs.core.rest.call(null,(state_20752[(4)])));

return statearr_20763;
})();
var state_20752__$1 = state_20752;
var statearr_20764_20976 = state_20752__$1;
(statearr_20764_20976[(2)] = inst_20747);

(statearr_20764_20976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (128))){
var inst_20722 = (state_20752[(10)]);
var inst_20725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20726 = [acc,inst_20722];
var inst_20727 = (new cljs.core.PersistentVector(null,2,(5),inst_20725,inst_20726,null));
var state_20752__$1 = state_20752;
var statearr_20765_20977 = state_20752__$1;
(statearr_20765_20977[(2)] = inst_20727);

(statearr_20765_20977[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (7))){
var inst_20325 = (state_20752[(11)]);
var state_20752__$1 = state_20752;
var statearr_20766_20978 = state_20752__$1;
(statearr_20766_20978[(2)] = inst_20325);

(statearr_20766_20978[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (59))){
var inst_20716 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20767_20979 = state_20752__$1;
(statearr_20767_20979[(2)] = inst_20716);

(statearr_20767_20979[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (86))){
var inst_20546 = (state_20752[(12)]);
var inst_20546__$1 = (state_20752[(2)]);
var state_20752__$1 = (function (){var statearr_20768 = state_20752;
(statearr_20768[(12)] = inst_20546__$1);

return statearr_20768;
})();
if(cljs.core.truth_(inst_20546__$1)){
var statearr_20769_20980 = state_20752__$1;
(statearr_20769_20980[(1)] = (88));

} else {
var statearr_20770_20981 = state_20752__$1;
(statearr_20770_20981[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (20))){
var inst_20367 = (state_20752[(13)]);
var inst_20366 = (state_20752[(14)]);
var inst_20354 = (state_20752[(15)]);
var inst_20365 = (state_20752[(2)]);
var inst_20366__$1 = cljs.core.__destructure_map.call(null,inst_20354);
var inst_20367__$1 = cljs.core.get.call(null,inst_20366__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_20368 = cljs.core.get.call(null,inst_20366__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_20369 = cljs.core.get.call(null,inst_20366__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_20370 = cljs.core.get.call(null,inst_20366__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_20371 = cljs.core.get.call(null,inst_20366__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_20372 = cljs.core.get.call(null,inst_20366__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_20752__$1 = (function (){var statearr_20771 = state_20752;
(statearr_20771[(16)] = inst_20370);

(statearr_20771[(13)] = inst_20367__$1);

(statearr_20771[(17)] = inst_20369);

(statearr_20771[(14)] = inst_20366__$1);

(statearr_20771[(18)] = inst_20365);

(statearr_20771[(19)] = inst_20368);

(statearr_20771[(20)] = inst_20371);

(statearr_20771[(21)] = inst_20372);

return statearr_20771;
})();
if(cljs.core.truth_(inst_20367__$1)){
var statearr_20772_20982 = state_20752__$1;
(statearr_20772_20982[(1)] = (24));

} else {
var statearr_20773_20983 = state_20752__$1;
(statearr_20773_20983[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (72))){
var inst_20477 = (state_20752[(22)]);
var inst_20483 = (state_20752[(2)]);
var inst_20484 = cljs.core.seq.call(null,inst_20477);
var state_20752__$1 = (function (){var statearr_20774 = state_20752;
(statearr_20774[(23)] = inst_20483);

return statearr_20774;
})();
if(inst_20484){
var statearr_20775_20984 = state_20752__$1;
(statearr_20775_20984[(1)] = (73));

} else {
var statearr_20776_20985 = state_20752__$1;
(statearr_20776_20985[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (58))){
var inst_20354 = (state_20752[(15)]);
var inst_20499 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_20354);
var state_20752__$1 = state_20752;
if(cljs.core.truth_(inst_20499)){
var statearr_20777_20986 = state_20752__$1;
(statearr_20777_20986[(1)] = (76));

} else {
var statearr_20778_20987 = state_20752__$1;
(statearr_20778_20987[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (60))){
var inst_20451 = (state_20752[(24)]);
var inst_20458 = (state_20752[(8)]);
var inst_20457 = cljs.core.seq.call(null,inst_20451);
var inst_20458__$1 = cljs.core.first.call(null,inst_20457);
var inst_20459 = cljs.core.next.call(null,inst_20457);
var state_20752__$1 = (function (){var statearr_20779 = state_20752;
(statearr_20779[(25)] = inst_20459);

(statearr_20779[(8)] = inst_20458__$1);

return statearr_20779;
})();
if(cljs.core.truth_(inst_20458__$1)){
var statearr_20780_20988 = state_20752__$1;
(statearr_20780_20988[(1)] = (62));

} else {
var statearr_20781_20989 = state_20752__$1;
(statearr_20781_20989[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (27))){
var inst_20375 = (state_20752[(26)]);
var inst_20371 = (state_20752[(20)]);
var inst_20375__$1 = cljs.core.not_EQ_.call(null,(0),inst_20371);
var state_20752__$1 = (function (){var statearr_20782 = state_20752;
(statearr_20782[(26)] = inst_20375__$1);

return statearr_20782;
})();
if(inst_20375__$1){
var statearr_20783_20990 = state_20752__$1;
(statearr_20783_20990[(1)] = (30));

} else {
var statearr_20784_20991 = state_20752__$1;
(statearr_20784_20991[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (1))){
var state_20752__$1 = state_20752;
var statearr_20785_20992 = state_20752__$1;
(statearr_20785_20992[(2)] = null);

(statearr_20785_20992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (69))){
var inst_20473 = (state_20752[(2)]);
var inst_20474 = fluree.db.util.async.throw_err.call(null,inst_20473);
var state_20752__$1 = state_20752;
var statearr_20786_20993 = state_20752__$1;
(statearr_20786_20993[(2)] = inst_20474);

(statearr_20786_20993[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (101))){
var inst_20630 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20787_20994 = state_20752__$1;
(statearr_20787_20994[(2)] = inst_20630);

(statearr_20787_20994[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (24))){
var inst_20371 = (state_20752[(20)]);
var state_20752__$1 = state_20752;
if(cljs.core.truth_(inst_20371)){
var statearr_20788_20995 = state_20752__$1;
(statearr_20788_20995[(1)] = (27));

} else {
var statearr_20789_20996 = state_20752__$1;
(statearr_20789_20996[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (102))){
var inst_20602 = (state_20752[(27)]);
var inst_20601 = (state_20752[(2)]);
var inst_20602__$1 = fluree.db.util.async.throw_err.call(null,inst_20601);
var inst_20603 = cljs.core.empty_QMARK_.call(null,inst_20602__$1);
var state_20752__$1 = (function (){var statearr_20790 = state_20752;
(statearr_20790[(27)] = inst_20602__$1);

return statearr_20790;
})();
if(inst_20603){
var statearr_20791_20997 = state_20752__$1;
(statearr_20791_20997[(1)] = (103));

} else {
var statearr_20792_20998 = state_20752__$1;
(statearr_20792_20998[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (135))){
var state_20752__$1 = state_20752;
var statearr_20793_20999 = state_20752__$1;
(statearr_20793_20999[(2)] = null);

(statearr_20793_20999[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (55))){
var inst_20354 = (state_20752[(15)]);
var inst_20427 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_20354);
var state_20752__$1 = state_20752;
var statearr_20794_21000 = state_20752__$1;
(statearr_20794_21000[(2)] = inst_20427);

(statearr_20794_21000[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (85))){
var inst_20521 = (state_20752[(28)]);
var inst_20354 = (state_20752[(15)]);
var inst_20533 = fluree.db.flake.o.call(null,inst_20521);
var inst_20534 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_20354);
var inst_20535 = fluree.db.dbproto._tag.call(null,db,inst_20533,inst_20534);
var state_20752__$1 = state_20752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20752__$1,(87),inst_20535);
} else {
if((state_val_20753 === (39))){
var inst_20402 = (state_20752[(29)]);
var inst_20370 = (state_20752[(16)]);
var inst_20402__$1 = cljs.core.not.call(null,inst_20370);
var state_20752__$1 = (function (){var statearr_20795 = state_20752;
(statearr_20795[(29)] = inst_20402__$1);

return statearr_20795;
})();
if(inst_20402__$1){
var statearr_20796_21001 = state_20752__$1;
(statearr_20796_21001[(1)] = (42));

} else {
var statearr_20797_21002 = state_20752__$1;
(statearr_20797_21002[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (88))){
var inst_20546 = (state_20752[(12)]);
var inst_20515 = (state_20752[(30)]);
var inst_20548 = cljs.core.conj.call(null,inst_20515,inst_20546);
var state_20752__$1 = state_20752;
var statearr_20798_21003 = state_20752__$1;
(statearr_20798_21003[(2)] = inst_20548);

(statearr_20798_21003[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (46))){
var inst_20369 = (state_20752[(17)]);
var state_20752__$1 = state_20752;
var statearr_20799_21004 = state_20752__$1;
(statearr_20799_21004[(2)] = inst_20369);

(statearr_20799_21004[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (4))){
var inst_20314 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20800_21005 = state_20752__$1;
(statearr_20800_21005[(2)] = inst_20314);

(statearr_20800_21005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (77))){
var inst_20561 = (state_20752[(31)]);
var inst_20561__$1 = componentFollow_QMARK_;
var state_20752__$1 = (function (){var statearr_20801 = state_20752;
(statearr_20801[(31)] = inst_20561__$1);

return statearr_20801;
})();
if(cljs.core.truth_(inst_20561__$1)){
var statearr_20802_21006 = state_20752__$1;
(statearr_20802_21006[(1)] = (91));

} else {
var statearr_20803_21007 = state_20752__$1;
(statearr_20803_21007[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (106))){
var inst_20582 = (state_20752[(32)]);
var inst_20616 = (state_20752[(2)]);
var inst_20617 = fluree.db.util.async.throw_err.call(null,inst_20616);
var inst_20618 = cljs.core.conj.call(null,inst_20582,inst_20617);
var state_20752__$1 = state_20752;
var statearr_20804_21008 = state_20752__$1;
(statearr_20804_21008[(2)] = inst_20618);

(statearr_20804_21008[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (119))){
var inst_20660 = (state_20752[(33)]);
var inst_20690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20691 = [inst_20660,offset_map];
var inst_20692 = (new cljs.core.PersistentVector(null,2,(5),inst_20690,inst_20691,null));
var state_20752__$1 = state_20752;
var statearr_20805_21009 = state_20752__$1;
(statearr_20805_21009[(2)] = inst_20692);

(statearr_20805_21009[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (95))){
var inst_20368 = (state_20752[(19)]);
var state_20752__$1 = state_20752;
if(cljs.core.truth_(inst_20368)){
var statearr_20806_21010 = state_20752__$1;
(statearr_20806_21010[(1)] = (110));

} else {
var statearr_20807_21011 = state_20752__$1;
(statearr_20807_21011[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (54))){
var inst_20424 = (state_20752[(34)]);
var state_20752__$1 = state_20752;
var statearr_20808_21012 = state_20752__$1;
(statearr_20808_21012[(2)] = inst_20424);

(statearr_20808_21012[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (92))){
var inst_20561 = (state_20752[(31)]);
var state_20752__$1 = state_20752;
var statearr_20809_21013 = state_20752__$1;
(statearr_20809_21013[(2)] = inst_20561);

(statearr_20809_21013[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (104))){
var inst_20324 = (state_20752[(35)]);
var inst_20602 = (state_20752[(27)]);
var inst_20611 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_20612 = [true,inst_20324];
var inst_20613 = cljs.core.PersistentHashMap.fromArrays(inst_20611,inst_20612);
var inst_20614 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_20613,inst_20602);
var state_20752__$1 = state_20752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20752__$1,(106),inst_20614);
} else {
if((state_val_20753 === (15))){
var inst_20324 = (state_20752[(35)]);
var inst_20347 = (state_20752[(36)]);
var inst_20351 = cljs.core.assoc.call(null,inst_20347,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_20324);
var state_20752__$1 = state_20752;
var statearr_20810_21014 = state_20752__$1;
(statearr_20810_21014[(2)] = inst_20351);

(statearr_20810_21014[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (48))){
var inst_20418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20419 = [null,offset_map];
var inst_20420 = (new cljs.core.PersistentVector(null,2,(5),inst_20418,inst_20419,null));
var state_20752__$1 = state_20752;
var statearr_20811_21015 = state_20752__$1;
(statearr_20811_21015[(2)] = inst_20420);

(statearr_20811_21015[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (50))){
var inst_20718 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20812_21016 = state_20752__$1;
(statearr_20812_21016[(2)] = inst_20718);

(statearr_20812_21016[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (116))){
var inst_20659 = (state_20752[(37)]);
var inst_20666 = (state_20752[(38)]);
var inst_20665 = cljs.core.seq.call(null,inst_20659);
var inst_20666__$1 = cljs.core.first.call(null,inst_20665);
var inst_20667 = cljs.core.next.call(null,inst_20665);
var state_20752__$1 = (function (){var statearr_20813 = state_20752;
(statearr_20813[(38)] = inst_20666__$1);

(statearr_20813[(39)] = inst_20667);

return statearr_20813;
})();
if(cljs.core.truth_(inst_20666__$1)){
var statearr_20814_21017 = state_20752__$1;
(statearr_20814_21017[(1)] = (118));

} else {
var statearr_20815_21018 = state_20752__$1;
(statearr_20815_21018[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (75))){
var inst_20459 = (state_20752[(25)]);
var inst_20489 = (state_20752[(2)]);
var inst_20451 = inst_20459;
var inst_20452 = inst_20489;
var state_20752__$1 = (function (){var statearr_20816 = state_20752;
(statearr_20816[(24)] = inst_20451);

(statearr_20816[(9)] = inst_20452);

return statearr_20816;
})();
var statearr_20817_21019 = state_20752__$1;
(statearr_20817_21019[(2)] = null);

(statearr_20817_21019[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (99))){
var inst_20588 = (state_20752[(40)]);
var inst_20354 = (state_20752[(15)]);
var inst_20591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20592 = fluree.db.flake.o.call(null,inst_20588);
var inst_20593 = [inst_20592];
var inst_20594 = (new cljs.core.PersistentVector(null,1,(5),inst_20591,inst_20593,null));
var inst_20595 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_20596 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_20354);
var inst_20597 = [inst_20596];
var inst_20598 = cljs.core.PersistentHashMap.fromArrays(inst_20595,inst_20597);
var inst_20599 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20594,inst_20598);
var state_20752__$1 = state_20752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20752__$1,(102),inst_20599);
} else {
if((state_val_20753 === (21))){
var inst_20358 = (state_20752[(41)]);
var state_20752__$1 = state_20752;
var statearr_20818_21020 = state_20752__$1;
(statearr_20818_21020[(2)] = inst_20358);

(statearr_20818_21020[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (31))){
var inst_20375 = (state_20752[(26)]);
var state_20752__$1 = state_20752;
var statearr_20819_21021 = state_20752__$1;
(statearr_20819_21021[(2)] = inst_20375);

(statearr_20819_21021[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (113))){
var inst_20370 = (state_20752[(16)]);
var inst_20367 = (state_20752[(13)]);
var inst_20369 = (state_20752[(17)]);
var inst_20366 = (state_20752[(14)]);
var inst_20354 = (state_20752[(15)]);
var inst_20365 = (state_20752[(18)]);
var inst_20339 = (state_20752[(42)]);
var inst_20368 = (state_20752[(19)]);
var inst_20324 = (state_20752[(35)]);
var inst_20371 = (state_20752[(20)]);
var inst_20372 = (state_20752[(21)]);
var inst_20641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20642 = (function (){var p = inst_20372;
var pred_spec__$1 = inst_20339;
var orderBy = inst_20370;
var multi_QMARK_ = inst_20367;
var limit = inst_20369;
var offset = inst_20371;
var k = inst_20365;
var compact_QMARK_ = inst_20324;
var map__20320 = inst_20366;
var pred_spec_SINGLEQUOTE_ = inst_20354;
var ref_QMARK_ = inst_20368;
return (function (p1__20310_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[fluree.db.flake.o.call(null,p1__20310_SHARP_)]);
});
})();
var inst_20643 = cljs.core.mapv.call(null,inst_20642,flakes);
var inst_20644 = [inst_20643,offset_map];
var inst_20645 = (new cljs.core.PersistentVector(null,2,(5),inst_20641,inst_20644,null));
var state_20752__$1 = state_20752;
var statearr_20820_21022 = state_20752__$1;
(statearr_20820_21022[(2)] = inst_20645);

(statearr_20820_21022[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (32))){
var inst_20381 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20821_21023 = state_20752__$1;
(statearr_20821_21023[(2)] = inst_20381);

(statearr_20821_21023[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (136))){
var inst_20743 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20822_21024 = state_20752__$1;
(statearr_20822_21024[(2)] = inst_20743);

(statearr_20822_21024[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (40))){
var inst_20367 = (state_20752[(13)]);
var state_20752__$1 = state_20752;
var statearr_20823_21025 = state_20752__$1;
(statearr_20823_21025[(2)] = inst_20367);

(statearr_20823_21025[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (129))){
var inst_20367 = (state_20752[(13)]);
var state_20752__$1 = state_20752;
if(cljs.core.truth_(inst_20367)){
var statearr_20824_21026 = state_20752__$1;
(statearr_20824_21026[(1)] = (131));

} else {
var statearr_20825_21027 = state_20752__$1;
(statearr_20825_21027[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (91))){
var inst_20354 = (state_20752[(15)]);
var inst_20563 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_20354);
var state_20752__$1 = state_20752;
var statearr_20826_21028 = state_20752__$1;
(statearr_20826_21028[(2)] = inst_20563);

(statearr_20826_21028[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (117))){
var inst_20696 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20827_21029 = state_20752__$1;
(statearr_20827_21029[(2)] = inst_20696);

(statearr_20827_21029[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (108))){
var state_20752__$1 = state_20752;
var statearr_20828_21030 = state_20752__$1;
(statearr_20828_21030[(2)] = null);

(statearr_20828_21030[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (56))){
var inst_20429 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20829_21031 = state_20752__$1;
(statearr_20829_21031[(2)] = inst_20429);

(statearr_20829_21031[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (33))){
var inst_20372 = (state_20752[(21)]);
var inst_20389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20390 = cljs.core.get.call(null,offset_map,inst_20372);
var state_20752__$1 = (function (){var statearr_20830 = state_20752;
(statearr_20830[(43)] = inst_20389);

return statearr_20830;
})();
if(cljs.core.truth_(inst_20390)){
var statearr_20831_21032 = state_20752__$1;
(statearr_20831_21032[(1)] = (36));

} else {
var statearr_20832_21033 = state_20752__$1;
(statearr_20832_21033[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (13))){
var inst_20339 = (state_20752[(42)]);
var state_20752__$1 = state_20752;
var statearr_20833_21034 = state_20752__$1;
(statearr_20833_21034[(2)] = inst_20339);

(statearr_20833_21034[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (22))){
var inst_20354 = (state_20752[(15)]);
var inst_20361 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_20354);
var state_20752__$1 = state_20752;
var statearr_20834_21035 = state_20752__$1;
(statearr_20834_21035[(2)] = inst_20361);

(statearr_20834_21035[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (90))){
var inst_20522 = (state_20752[(44)]);
var inst_20551 = (state_20752[(2)]);
var inst_20514 = inst_20522;
var inst_20515 = inst_20551;
var state_20752__$1 = (function (){var statearr_20835 = state_20752;
(statearr_20835[(45)] = inst_20514);

(statearr_20835[(30)] = inst_20515);

return statearr_20835;
})();
var statearr_20836_21036 = state_20752__$1;
(statearr_20836_21036[(2)] = null);

(statearr_20836_21036[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (109))){
var inst_20589 = (state_20752[(46)]);
var inst_20620 = (state_20752[(47)]);
var inst_20626 = (state_20752[(2)]);
var inst_20581 = inst_20589;
var inst_20582 = inst_20620;
var state_20752__$1 = (function (){var statearr_20837 = state_20752;
(statearr_20837[(32)] = inst_20582);

(statearr_20837[(48)] = inst_20626);

(statearr_20837[(49)] = inst_20581);

return statearr_20837;
})();
var statearr_20838_21037 = state_20752__$1;
(statearr_20838_21037[(2)] = null);

(statearr_20838_21037[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (36))){
var inst_20372 = (state_20752[(21)]);
var inst_20392 = cljs.core.update.call(null,offset_map,inst_20372,cljs.core.dec);
var state_20752__$1 = state_20752;
var statearr_20839_21038 = state_20752__$1;
(statearr_20839_21038[(2)] = inst_20392);

(statearr_20839_21038[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (41))){
var inst_20416 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
if(cljs.core.truth_(inst_20416)){
var statearr_20840_21039 = state_20752__$1;
(statearr_20840_21039[(1)] = (48));

} else {
var statearr_20841_21040 = state_20752__$1;
(statearr_20841_21040[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (118))){
var inst_20666 = (state_20752[(38)]);
var inst_20669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20670 = fluree.db.flake.o.call(null,inst_20666);
var inst_20671 = [inst_20670];
var inst_20672 = (new cljs.core.PersistentVector(null,1,(5),inst_20669,inst_20671,null));
var inst_20673 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20672);
var state_20752__$1 = state_20752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20752__$1,(121),inst_20673);
} else {
if((state_val_20753 === (89))){
var inst_20515 = (state_20752[(30)]);
var state_20752__$1 = state_20752;
var statearr_20842_21041 = state_20752__$1;
(statearr_20842_21041[(2)] = inst_20515);

(statearr_20842_21041[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (100))){
var inst_20582 = (state_20752[(32)]);
var state_20752__$1 = state_20752;
var statearr_20843_21042 = state_20752__$1;
(statearr_20843_21042[(2)] = inst_20582);

(statearr_20843_21042[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (131))){
var inst_20365 = (state_20752[(18)]);
var inst_20721 = (state_20752[(50)]);
var inst_20722 = (state_20752[(10)]);
var inst_20730 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20731 = cljs.core.assoc.call(null,acc,inst_20365,inst_20721);
var inst_20732 = [inst_20731,inst_20722];
var inst_20733 = (new cljs.core.PersistentVector(null,2,(5),inst_20730,inst_20732,null));
var state_20752__$1 = state_20752;
var statearr_20844_21043 = state_20752__$1;
(statearr_20844_21043[(2)] = inst_20733);

(statearr_20844_21043[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (122))){
var inst_20660 = (state_20752[(33)]);
var inst_20666 = (state_20752[(38)]);
var inst_20667 = (state_20752[(39)]);
var inst_20679 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_20680 = fluree.db.flake.o.call(null,inst_20666);
var inst_20681 = [inst_20680];
var inst_20682 = cljs.core.PersistentHashMap.fromArrays(inst_20679,inst_20681);
var inst_20683 = cljs.core.conj.call(null,inst_20660,inst_20682);
var inst_20659 = inst_20667;
var inst_20660__$1 = inst_20683;
var state_20752__$1 = (function (){var statearr_20845 = state_20752;
(statearr_20845[(33)] = inst_20660__$1);

(statearr_20845[(37)] = inst_20659);

return statearr_20845;
})();
var statearr_20846_21044 = state_20752__$1;
(statearr_20846_21044[(2)] = null);

(statearr_20846_21044[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (43))){
var inst_20402 = (state_20752[(29)]);
var state_20752__$1 = state_20752;
var statearr_20847_21045 = state_20752__$1;
(statearr_20847_21045[(2)] = inst_20402);

(statearr_20847_21045[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (61))){
var inst_20438 = (state_20752[(51)]);
var inst_20495 = (state_20752[(2)]);
var inst_20496 = [inst_20495,offset_map];
var inst_20497 = (new cljs.core.PersistentVector(null,2,(5),inst_20438,inst_20496,null));
var state_20752__$1 = state_20752;
var statearr_20848_21046 = state_20752__$1;
(statearr_20848_21046[(2)] = inst_20497);

(statearr_20848_21046[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (29))){
var inst_20384 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20849_21047 = state_20752__$1;
(statearr_20849_21047[(2)] = inst_20384);

(statearr_20849_21047[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (44))){
var inst_20413 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20850_21048 = state_20752__$1;
(statearr_20850_21048[(2)] = inst_20413);

(statearr_20850_21048[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (93))){
var inst_20566 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
if(cljs.core.truth_(inst_20566)){
var statearr_20851_21049 = state_20752__$1;
(statearr_20851_21049[(1)] = (94));

} else {
var statearr_20852_21050 = state_20752__$1;
(statearr_20852_21050[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (6))){
var inst_20327 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_20328 = (inst_20327 == null);
var state_20752__$1 = state_20752;
var statearr_20853_21051 = state_20752__$1;
(statearr_20853_21051[(2)] = inst_20328);

(statearr_20853_21051[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (111))){
var state_20752__$1 = state_20752;
var statearr_20854_21052 = state_20752__$1;
(statearr_20854_21052[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (28))){
var inst_20371 = (state_20752[(20)]);
var state_20752__$1 = state_20752;
var statearr_20856_21053 = state_20752__$1;
(statearr_20856_21053[(2)] = inst_20371);

(statearr_20856_21053[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (134))){
var inst_20365 = (state_20752[(18)]);
var inst_20721 = (state_20752[(50)]);
var inst_20722 = (state_20752[(10)]);
var inst_20736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20737 = cljs.core.first.call(null,inst_20721);
var inst_20738 = cljs.core.assoc.call(null,acc,inst_20365,inst_20737);
var inst_20739 = [inst_20738,inst_20722];
var inst_20740 = (new cljs.core.PersistentVector(null,2,(5),inst_20736,inst_20739,null));
var state_20752__$1 = state_20752;
var statearr_20857_21054 = state_20752__$1;
(statearr_20857_21054[(2)] = inst_20740);

(statearr_20857_21054[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (64))){
var inst_20493 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20858_21055 = state_20752__$1;
(statearr_20858_21055[(2)] = inst_20493);

(statearr_20858_21055[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (103))){
var inst_20582 = (state_20752[(32)]);
var inst_20588 = (state_20752[(40)]);
var inst_20605 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_20606 = fluree.db.flake.o.call(null,inst_20588);
var inst_20607 = [inst_20606];
var inst_20608 = cljs.core.PersistentHashMap.fromArrays(inst_20605,inst_20607);
var inst_20609 = cljs.core.conj.call(null,inst_20582,inst_20608);
var state_20752__$1 = state_20752;
var statearr_20859_21056 = state_20752__$1;
(statearr_20859_21056[(2)] = inst_20609);

(statearr_20859_21056[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (51))){
var inst_20424 = (state_20752[(34)]);
var inst_20354 = (state_20752[(15)]);
var inst_20424__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_20354);
var state_20752__$1 = (function (){var statearr_20860 = state_20752;
(statearr_20860[(34)] = inst_20424__$1);

return statearr_20860;
})();
if(cljs.core.truth_(inst_20424__$1)){
var statearr_20861_21057 = state_20752__$1;
(statearr_20861_21057[(1)] = (54));

} else {
var statearr_20862_21058 = state_20752__$1;
(statearr_20862_21058[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (25))){
var inst_20367 = (state_20752[(13)]);
var state_20752__$1 = state_20752;
var statearr_20863_21059 = state_20752__$1;
(statearr_20863_21059[(2)] = inst_20367);

(statearr_20863_21059[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (34))){
var inst_20367 = (state_20752[(13)]);
var state_20752__$1 = state_20752;
if(cljs.core.truth_(inst_20367)){
var statearr_20864_21060 = state_20752__$1;
(statearr_20864_21060[(1)] = (39));

} else {
var statearr_20865_21061 = state_20752__$1;
(statearr_20865_21061[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (125))){
var inst_20370 = (state_20752[(16)]);
var inst_20367 = (state_20752[(13)]);
var inst_20369 = (state_20752[(17)]);
var inst_20366 = (state_20752[(14)]);
var inst_20354 = (state_20752[(15)]);
var inst_20365 = (state_20752[(18)]);
var inst_20339 = (state_20752[(42)]);
var inst_20368 = (state_20752[(19)]);
var inst_20324 = (state_20752[(35)]);
var inst_20371 = (state_20752[(20)]);
var inst_20372 = (state_20752[(21)]);
var inst_20701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20702 = (function (){var p = inst_20372;
var pred_spec__$1 = inst_20339;
var orderBy = inst_20370;
var multi_QMARK_ = inst_20367;
var limit = inst_20369;
var offset = inst_20371;
var k = inst_20365;
var compact_QMARK_ = inst_20324;
var map__20320 = inst_20366;
var pred_spec_SINGLEQUOTE_ = inst_20354;
var ref_QMARK_ = inst_20368;
return (function (p1__20311_SHARP_){
return fluree.db.flake.o.call(null,p1__20311_SHARP_);
});
})();
var inst_20703 = cljs.core.mapv.call(null,inst_20702,flakes);
var inst_20704 = [inst_20703,offset_map];
var inst_20705 = (new cljs.core.PersistentVector(null,2,(5),inst_20701,inst_20704,null));
var state_20752__$1 = state_20752;
var statearr_20866_21062 = state_20752__$1;
(statearr_20866_21062[(2)] = inst_20705);

(statearr_20866_21062[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (17))){
var inst_20354 = (state_20752[(15)]);
var inst_20355 = (state_20752[(52)]);
var inst_20354__$1 = (state_20752[(2)]);
var inst_20355__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_20354__$1);
var state_20752__$1 = (function (){var statearr_20867 = state_20752;
(statearr_20867[(15)] = inst_20354__$1);

(statearr_20867[(52)] = inst_20355__$1);

return statearr_20867;
})();
if(cljs.core.truth_(inst_20355__$1)){
var statearr_20868_21063 = state_20752__$1;
(statearr_20868_21063[(1)] = (18));

} else {
var statearr_20869_21064 = state_20752__$1;
(statearr_20869_21064[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (3))){
var inst_20750 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20752__$1,inst_20750);
} else {
if((state_val_20753 === (12))){
var inst_20339 = (state_20752[(42)]);
var inst_20344 = cljs.core.assoc.call(null,inst_20339,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_20752__$1 = state_20752;
var statearr_20870_21065 = state_20752__$1;
(statearr_20870_21065[(2)] = inst_20344);

(statearr_20870_21065[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (2))){
var inst_20325 = (state_20752[(11)]);
var _ = (function (){var statearr_20871 = state_20752;
(statearr_20871[(4)] = cljs.core.cons.call(null,(5),(state_20752[(4)])));

return statearr_20871;
})();
var inst_20324 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_20325__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_20752__$1 = (function (){var statearr_20872 = state_20752;
(statearr_20872[(35)] = inst_20324);

(statearr_20872[(11)] = inst_20325__$1);

return statearr_20872;
})();
if(cljs.core.truth_(inst_20325__$1)){
var statearr_20873_21066 = state_20752__$1;
(statearr_20873_21066[(1)] = (6));

} else {
var statearr_20874_21067 = state_20752__$1;
(statearr_20874_21067[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (66))){
var inst_20468 = (state_20752[(7)]);
var inst_20437 = (state_20752[(53)]);
var inst_20471 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_20437,inst_20468);
var state_20752__$1 = state_20752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20752__$1,(69),inst_20471);
} else {
if((state_val_20753 === (107))){
var inst_20602 = (state_20752[(27)]);
var inst_20622 = cljs.core.count.call(null,inst_20602);
var inst_20623 = fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_20622);
var state_20752__$1 = state_20752;
var statearr_20875_21068 = state_20752__$1;
(statearr_20875_21068[(2)] = inst_20623);

(statearr_20875_21068[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (23))){
var inst_20363 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20876_21069 = state_20752__$1;
(statearr_20876_21069[(2)] = inst_20363);

(statearr_20876_21069[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (47))){
var inst_20410 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20877_21070 = state_20752__$1;
(statearr_20877_21070[(2)] = inst_20410);

(statearr_20877_21070[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (35))){
var inst_20721 = (state_20752[(50)]);
var inst_20720 = (state_20752[(2)]);
var inst_20721__$1 = cljs.core.nth.call(null,inst_20720,(0),null);
var inst_20722 = cljs.core.nth.call(null,inst_20720,(1),null);
var inst_20723 = cljs.core.empty_QMARK_.call(null,inst_20721__$1);
var state_20752__$1 = (function (){var statearr_20878 = state_20752;
(statearr_20878[(50)] = inst_20721__$1);

(statearr_20878[(10)] = inst_20722);

return statearr_20878;
})();
if(inst_20723){
var statearr_20879_21071 = state_20752__$1;
(statearr_20879_21071[(1)] = (128));

} else {
var statearr_20880_21072 = state_20752__$1;
(statearr_20880_21072[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (127))){
var inst_20708 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20881_21073 = state_20752__$1;
(statearr_20881_21073[(2)] = inst_20708);

(statearr_20881_21073[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (82))){
var inst_20515 = (state_20752[(30)]);
var state_20752__$1 = state_20752;
var statearr_20882_21074 = state_20752__$1;
(statearr_20882_21074[(2)] = inst_20515);

(statearr_20882_21074[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (76))){
var inst_20501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20509 = flakes;
var inst_20510 = cljs.core.seq.call(null,inst_20509);
var inst_20511 = cljs.core.first.call(null,inst_20510);
var inst_20512 = cljs.core.next.call(null,inst_20510);
var inst_20513 = cljs.core.PersistentVector.EMPTY;
var inst_20514 = inst_20509;
var inst_20515 = inst_20513;
var state_20752__$1 = (function (){var statearr_20883 = state_20752;
(statearr_20883[(45)] = inst_20514);

(statearr_20883[(30)] = inst_20515);

(statearr_20883[(54)] = inst_20501);

(statearr_20883[(55)] = inst_20511);

(statearr_20883[(56)] = inst_20512);

return statearr_20883;
})();
var statearr_20884_21075 = state_20752__$1;
(statearr_20884_21075[(2)] = null);

(statearr_20884_21075[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (97))){
var inst_20588 = (state_20752[(40)]);
var inst_20581 = (state_20752[(49)]);
var inst_20587 = cljs.core.seq.call(null,inst_20581);
var inst_20588__$1 = cljs.core.first.call(null,inst_20587);
var inst_20589 = cljs.core.next.call(null,inst_20587);
var state_20752__$1 = (function (){var statearr_20885 = state_20752;
(statearr_20885[(46)] = inst_20589);

(statearr_20885[(40)] = inst_20588__$1);

return statearr_20885;
})();
if(cljs.core.truth_(inst_20588__$1)){
var statearr_20886_21076 = state_20752__$1;
(statearr_20886_21076[(1)] = (99));

} else {
var statearr_20887_21077 = state_20752__$1;
(statearr_20887_21077[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (19))){
var inst_20358 = (state_20752[(41)]);
var inst_20354 = (state_20752[(15)]);
var inst_20358__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_20354);
var state_20752__$1 = (function (){var statearr_20888 = state_20752;
(statearr_20888[(41)] = inst_20358__$1);

return statearr_20888;
})();
if(cljs.core.truth_(inst_20358__$1)){
var statearr_20889_21078 = state_20752__$1;
(statearr_20889_21078[(1)] = (21));

} else {
var statearr_20890_21079 = state_20752__$1;
(statearr_20890_21079[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (57))){
var inst_20354 = (state_20752[(15)]);
var inst_20434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20435 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_20436 = (new cljs.core.PersistentVector(null,3,(5),inst_20434,inst_20435,null));
var inst_20437 = cljs.core.select_keys.call(null,inst_20354,inst_20436);
var inst_20438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20446 = flakes;
var inst_20447 = cljs.core.seq.call(null,inst_20446);
var inst_20448 = cljs.core.first.call(null,inst_20447);
var inst_20449 = cljs.core.next.call(null,inst_20447);
var inst_20450 = cljs.core.PersistentVector.EMPTY;
var inst_20451 = inst_20446;
var inst_20452 = inst_20450;
var state_20752__$1 = (function (){var statearr_20891 = state_20752;
(statearr_20891[(51)] = inst_20438);

(statearr_20891[(24)] = inst_20451);

(statearr_20891[(57)] = inst_20449);

(statearr_20891[(58)] = inst_20448);

(statearr_20891[(53)] = inst_20437);

(statearr_20891[(9)] = inst_20452);

return statearr_20891;
})();
var statearr_20892_21080 = state_20752__$1;
(statearr_20892_21080[(2)] = null);

(statearr_20892_21080[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (68))){
var inst_20477 = (state_20752[(2)]);
var state_20752__$1 = (function (){var statearr_20893 = state_20752;
(statearr_20893[(22)] = inst_20477);

return statearr_20893;
})();
if(cljs.core.truth_(fuel)){
var statearr_20894_21081 = state_20752__$1;
(statearr_20894_21081[(1)] = (70));

} else {
var statearr_20895_21082 = state_20752__$1;
(statearr_20895_21082[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (11))){
var inst_20339 = (state_20752[(42)]);
var inst_20339__$1 = (state_20752[(2)]);
var inst_20341 = cljs.core.contains_QMARK_.call(null,inst_20339__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_20342 = (!(inst_20341));
var state_20752__$1 = (function (){var statearr_20896 = state_20752;
(statearr_20896[(42)] = inst_20339__$1);

return statearr_20896;
})();
if(inst_20342){
var statearr_20897_21083 = state_20752__$1;
(statearr_20897_21083[(1)] = (12));

} else {
var statearr_20898_21084 = state_20752__$1;
(statearr_20898_21084[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (115))){
var inst_20698 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20900_21085 = state_20752__$1;
(statearr_20900_21085[(2)] = inst_20698);

(statearr_20900_21085[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (9))){
var inst_20333 = cljs.core.first.call(null,flakes);
var inst_20334 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_20333);
var inst_20335 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_20336 = fluree.db.query.fql_resp.wildcard_pred_spec.call(null,db,cache,inst_20334,inst_20335);
var state_20752__$1 = state_20752;
var statearr_20901_21086 = state_20752__$1;
(statearr_20901_21086[(2)] = inst_20336);

(statearr_20901_21086[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (5))){
var _ = (function (){var statearr_20902 = state_20752;
(statearr_20902[(4)] = cljs.core.rest.call(null,(state_20752[(4)])));

return statearr_20902;
})();
var state_20752__$1 = state_20752;
var ex20899 = (state_20752__$1[(2)]);
var statearr_20903_21087 = state_20752__$1;
(statearr_20903_21087[(5)] = ex20899);


if((ex20899 instanceof Error)){
var statearr_20904_21088 = state_20752__$1;
(statearr_20904_21088[(1)] = (4));

(statearr_20904_21088[(5)] = null);

} else {
throw ex20899;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (112))){
var inst_20710 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20905_21089 = state_20752__$1;
(statearr_20905_21089[(2)] = inst_20710);

(statearr_20905_21089[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (83))){
var inst_20555 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20906_21090 = state_20752__$1;
(statearr_20906_21090[(2)] = inst_20555);

(statearr_20906_21090[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (14))){
var inst_20339 = (state_20752[(42)]);
var inst_20347 = (state_20752[(2)]);
var inst_20348 = cljs.core.contains_QMARK_.call(null,inst_20339,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_20349 = (!(inst_20348));
var state_20752__$1 = (function (){var statearr_20907 = state_20752;
(statearr_20907[(36)] = inst_20347);

return statearr_20907;
})();
if(inst_20349){
var statearr_20908_21091 = state_20752__$1;
(statearr_20908_21091[(1)] = (15));

} else {
var statearr_20909_21092 = state_20752__$1;
(statearr_20909_21092[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (45))){
var inst_20369 = (state_20752[(17)]);
var inst_20365 = (state_20752[(18)]);
var inst_20405 = cljs.core.get.call(null,acc,inst_20365);
var inst_20406 = cljs.core.count.call(null,inst_20405);
var inst_20407 = (inst_20406 >= inst_20369);
var state_20752__$1 = state_20752;
var statearr_20910_21093 = state_20752__$1;
(statearr_20910_21093[(2)] = inst_20407);

(statearr_20910_21093[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (53))){
var inst_20432 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
if(cljs.core.truth_(inst_20432)){
var statearr_20911_21094 = state_20752__$1;
(statearr_20911_21094[(1)] = (57));

} else {
var statearr_20912_21095 = state_20752__$1;
(statearr_20912_21095[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (78))){
var inst_20714 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20913_21096 = state_20752__$1;
(statearr_20913_21096[(2)] = inst_20714);

(statearr_20913_21096[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (132))){
var state_20752__$1 = state_20752;
var statearr_20915_21097 = state_20752__$1;
(statearr_20915_21097[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (26))){
var inst_20387 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
if(cljs.core.truth_(inst_20387)){
var statearr_20917_21098 = state_20752__$1;
(statearr_20917_21098[(1)] = (33));

} else {
var statearr_20918_21099 = state_20752__$1;
(statearr_20918_21099[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (123))){
var inst_20660 = (state_20752[(33)]);
var inst_20667 = (state_20752[(39)]);
var tmp20914 = inst_20660;
var inst_20659 = inst_20667;
var inst_20660__$1 = tmp20914;
var state_20752__$1 = (function (){var statearr_20919 = state_20752;
(statearr_20919[(33)] = inst_20660__$1);

(statearr_20919[(37)] = inst_20659);

return statearr_20919;
})();
var statearr_20920_21100 = state_20752__$1;
(statearr_20920_21100[(2)] = null);

(statearr_20920_21100[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (16))){
var inst_20347 = (state_20752[(36)]);
var state_20752__$1 = state_20752;
var statearr_20921_21101 = state_20752__$1;
(statearr_20921_21101[(2)] = inst_20347);

(statearr_20921_21101[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (133))){
var inst_20745 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20922_21102 = state_20752__$1;
(statearr_20922_21102[(2)] = inst_20745);

(statearr_20922_21102[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (81))){
var inst_20530 = (state_20752[(59)]);
var inst_20521 = (state_20752[(28)]);
var inst_20354 = (state_20752[(15)]);
var inst_20524 = cljs.core.deref.call(null,cache);
var inst_20525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20526 = fluree.db.flake.o.call(null,inst_20521);
var inst_20527 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_20354);
var inst_20528 = [inst_20526,inst_20527];
var inst_20529 = (new cljs.core.PersistentVector(null,2,(5),inst_20525,inst_20528,null));
var inst_20530__$1 = cljs.core.get.call(null,inst_20524,inst_20529);
var state_20752__$1 = (function (){var statearr_20923 = state_20752;
(statearr_20923[(59)] = inst_20530__$1);

return statearr_20923;
})();
if(cljs.core.truth_(inst_20530__$1)){
var statearr_20924_21103 = state_20752__$1;
(statearr_20924_21103[(1)] = (84));

} else {
var statearr_20925_21104 = state_20752__$1;
(statearr_20925_21104[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (120))){
var inst_20694 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20926_21105 = state_20752__$1;
(statearr_20926_21105[(2)] = inst_20694);

(statearr_20926_21105[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (79))){
var inst_20514 = (state_20752[(45)]);
var inst_20521 = (state_20752[(28)]);
var inst_20520 = cljs.core.seq.call(null,inst_20514);
var inst_20521__$1 = cljs.core.first.call(null,inst_20520);
var inst_20522 = cljs.core.next.call(null,inst_20520);
var state_20752__$1 = (function (){var statearr_20927 = state_20752;
(statearr_20927[(44)] = inst_20522);

(statearr_20927[(28)] = inst_20521__$1);

return statearr_20927;
})();
if(cljs.core.truth_(inst_20521__$1)){
var statearr_20928_21106 = state_20752__$1;
(statearr_20928_21106[(1)] = (81));

} else {
var statearr_20929_21107 = state_20752__$1;
(statearr_20929_21107[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (38))){
var inst_20389 = (state_20752[(43)]);
var inst_20397 = (state_20752[(2)]);
var inst_20398 = [null,inst_20397];
var inst_20399 = (new cljs.core.PersistentVector(null,2,(5),inst_20389,inst_20398,null));
var state_20752__$1 = state_20752;
var statearr_20930_21108 = state_20752__$1;
(statearr_20930_21108[(2)] = inst_20399);

(statearr_20930_21108[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (126))){
var state_20752__$1 = state_20752;
var statearr_20931_21109 = state_20752__$1;
(statearr_20931_21109[(2)] = null);

(statearr_20931_21109[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (98))){
var inst_20568 = (state_20752[(60)]);
var inst_20632 = (state_20752[(2)]);
var inst_20633 = [inst_20632,offset_map];
var inst_20634 = (new cljs.core.PersistentVector(null,2,(5),inst_20568,inst_20633,null));
var state_20752__$1 = state_20752;
var statearr_20932_21110 = state_20752__$1;
(statearr_20932_21110[(2)] = inst_20634);

(statearr_20932_21110[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (124))){
var inst_20688 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20933_21111 = state_20752__$1;
(statearr_20933_21111[(2)] = inst_20688);

(statearr_20933_21111[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (87))){
var inst_20521 = (state_20752[(28)]);
var inst_20354 = (state_20752[(15)]);
var inst_20537 = (state_20752[(2)]);
var inst_20538 = fluree.db.util.async.throw_err.call(null,inst_20537);
var inst_20539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20540 = fluree.db.flake.o.call(null,inst_20521);
var inst_20541 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_20354);
var inst_20542 = [inst_20540,inst_20541];
var inst_20543 = (new cljs.core.PersistentVector(null,2,(5),inst_20539,inst_20542,null));
var inst_20544 = fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc,inst_20543,inst_20538);
var state_20752__$1 = (function (){var statearr_20934 = state_20752;
(statearr_20934[(61)] = inst_20544);

return statearr_20934;
})();
var statearr_20935_21112 = state_20752__$1;
(statearr_20935_21112[(2)] = inst_20538);

(statearr_20935_21112[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (30))){
var inst_20372 = (state_20752[(21)]);
var inst_20377 = cljs.core.get.call(null,offset_map,inst_20372);
var inst_20378 = cljs.core.not_EQ_.call(null,(0),inst_20377);
var state_20752__$1 = state_20752;
var statearr_20936_21113 = state_20752__$1;
(statearr_20936_21113[(2)] = inst_20378);

(statearr_20936_21113[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (73))){
var inst_20452 = (state_20752[(9)]);
var inst_20477 = (state_20752[(22)]);
var inst_20486 = cljs.core.conj.call(null,inst_20452,inst_20477);
var state_20752__$1 = state_20752;
var statearr_20937_21114 = state_20752__$1;
(statearr_20937_21114[(2)] = inst_20486);

(statearr_20937_21114[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (96))){
var inst_20712 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
var statearr_20938_21115 = state_20752__$1;
(statearr_20938_21115[(2)] = inst_20712);

(statearr_20938_21115[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (10))){
var state_20752__$1 = state_20752;
var statearr_20939_21116 = state_20752__$1;
(statearr_20939_21116[(2)] = pred_spec);

(statearr_20939_21116[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (18))){
var inst_20355 = (state_20752[(52)]);
var state_20752__$1 = state_20752;
var statearr_20940_21117 = state_20752__$1;
(statearr_20940_21117[(2)] = inst_20355);

(statearr_20940_21117[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (105))){
var inst_20620 = (state_20752[(2)]);
var state_20752__$1 = (function (){var statearr_20941 = state_20752;
(statearr_20941[(47)] = inst_20620);

return statearr_20941;
})();
if(cljs.core.truth_(fuel)){
var statearr_20942_21118 = state_20752__$1;
(statearr_20942_21118[(1)] = (107));

} else {
var statearr_20943_21119 = state_20752__$1;
(statearr_20943_21119[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (52))){
var inst_20422 = (state_20752[(62)]);
var state_20752__$1 = state_20752;
var statearr_20944_21120 = state_20752__$1;
(statearr_20944_21120[(2)] = inst_20422);

(statearr_20944_21120[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (114))){
var inst_20654 = flakes;
var inst_20655 = cljs.core.seq.call(null,inst_20654);
var inst_20656 = cljs.core.first.call(null,inst_20655);
var inst_20657 = cljs.core.next.call(null,inst_20655);
var inst_20658 = cljs.core.PersistentVector.EMPTY;
var inst_20659 = inst_20654;
var inst_20660 = inst_20658;
var state_20752__$1 = (function (){var statearr_20945 = state_20752;
(statearr_20945[(33)] = inst_20660);

(statearr_20945[(63)] = inst_20656);

(statearr_20945[(37)] = inst_20659);

(statearr_20945[(64)] = inst_20657);

return statearr_20945;
})();
var statearr_20946_21121 = state_20752__$1;
(statearr_20946_21121[(2)] = null);

(statearr_20946_21121[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (67))){
var state_20752__$1 = state_20752;
var statearr_20947_21122 = state_20752__$1;
(statearr_20947_21122[(2)] = null);

(statearr_20947_21122[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (71))){
var state_20752__$1 = state_20752;
var statearr_20948_21123 = state_20752__$1;
(statearr_20948_21123[(2)] = null);

(statearr_20948_21123[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (42))){
var inst_20369 = (state_20752[(17)]);
var state_20752__$1 = state_20752;
if(cljs.core.truth_(inst_20369)){
var statearr_20949_21124 = state_20752__$1;
(statearr_20949_21124[(1)] = (45));

} else {
var statearr_20950_21125 = state_20752__$1;
(statearr_20950_21125[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (80))){
var inst_20501 = (state_20752[(54)]);
var inst_20557 = (state_20752[(2)]);
var inst_20558 = [inst_20557,offset_map];
var inst_20559 = (new cljs.core.PersistentVector(null,2,(5),inst_20501,inst_20558,null));
var state_20752__$1 = state_20752;
var statearr_20951_21126 = state_20752__$1;
(statearr_20951_21126[(2)] = inst_20559);

(statearr_20951_21126[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (37))){
var inst_20371 = (state_20752[(20)]);
var inst_20372 = (state_20752[(21)]);
var inst_20394 = (inst_20371 - (1));
var inst_20395 = cljs.core.assoc.call(null,offset_map,inst_20372,inst_20394);
var state_20752__$1 = state_20752;
var statearr_20952_21127 = state_20752__$1;
(statearr_20952_21127[(2)] = inst_20395);

(statearr_20952_21127[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (63))){
var inst_20452 = (state_20752[(9)]);
var state_20752__$1 = state_20752;
var statearr_20953_21128 = state_20752__$1;
(statearr_20953_21128[(2)] = inst_20452);

(statearr_20953_21128[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (94))){
var inst_20568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20576 = flakes;
var inst_20577 = cljs.core.seq.call(null,inst_20576);
var inst_20578 = cljs.core.first.call(null,inst_20577);
var inst_20579 = cljs.core.next.call(null,inst_20577);
var inst_20580 = cljs.core.PersistentVector.EMPTY;
var inst_20581 = inst_20576;
var inst_20582 = inst_20580;
var state_20752__$1 = (function (){var statearr_20954 = state_20752;
(statearr_20954[(32)] = inst_20582);

(statearr_20954[(65)] = inst_20578);

(statearr_20954[(60)] = inst_20568);

(statearr_20954[(66)] = inst_20579);

(statearr_20954[(49)] = inst_20581);

return statearr_20954;
})();
var statearr_20955_21129 = state_20752__$1;
(statearr_20955_21129[(2)] = null);

(statearr_20955_21129[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (8))){
var inst_20331 = (state_20752[(2)]);
var state_20752__$1 = state_20752;
if(cljs.core.truth_(inst_20331)){
var statearr_20956_21130 = state_20752__$1;
(statearr_20956_21130[(1)] = (9));

} else {
var statearr_20957_21131 = state_20752__$1;
(statearr_20957_21131[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (49))){
var inst_20422 = (state_20752[(62)]);
var inst_20422__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_20752__$1 = (function (){var statearr_20958 = state_20752;
(statearr_20958[(62)] = inst_20422__$1);

return statearr_20958;
})();
if(inst_20422__$1){
var statearr_20959_21132 = state_20752__$1;
(statearr_20959_21132[(1)] = (51));

} else {
var statearr_20960_21133 = state_20752__$1;
(statearr_20960_21133[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20753 === (84))){
var inst_20530 = (state_20752[(59)]);
var state_20752__$1 = state_20752;
var statearr_20961_21134 = state_20752__$1;
(statearr_20961_21134[(2)] = inst_20530);

(statearr_20961_21134[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$state_machine__2727__auto____0 = (function (){
var statearr_20962 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20962[(0)] = fluree$db$query$fql_resp$state_machine__2727__auto__);

(statearr_20962[(1)] = (1));

return statearr_20962;
});
var fluree$db$query$fql_resp$state_machine__2727__auto____1 = (function (state_20752){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_20752);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20963){var ex__2730__auto__ = e20963;
var statearr_20964_21135 = state_20752;
(statearr_20964_21135[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_20752[(4)]))){
var statearr_20965_21136 = state_20752;
(statearr_20965_21136[(1)] = cljs.core.first.call(null,(state_20752[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21137 = state_20752;
state_20752 = G__21137;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$state_machine__2727__auto__ = function(state_20752){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$state_machine__2727__auto____1.call(this,state_20752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$state_machine__2727__auto____0;
fluree$db$query$fql_resp$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$state_machine__2727__auto____1;
return fluree$db$query$fql_resp$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20966 = f__2750__auto__.call(null);
(statearr_20966[(6)] = c__2749__auto__);

return statearr_20966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql_resp.add_pred.cljs$lang$maxFixedArity = 10);

fluree.db.query.fql_resp.compare_fn = (function fluree$db$query$fql_resp$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql_resp.sort_offset_and_limit_res = (function fluree$db$query$fql_resp$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__21139 = res;
var G__21139__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__21138_SHARP_){
return cljs.core.get.call(null,p1__21138_SHARP_,sortPred);
}),fluree.db.query.fql_resp.compare_fn,G__21139):G__21139);
var G__21139__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__21139__$1):G__21139__$1);
var G__21139__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__21139__$2):G__21139__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__21139__$3);
} else {
return G__21139__$3;
}
} else {
return res;
}
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql_resp.flakes__GT_res = (function fluree$db$query$fql_resp$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21320){
var state_val_21321 = (state_21320[(1)]);
if((state_val_21321 === (7))){
var state_21320__$1 = state_21320;
var statearr_21322_21408 = state_21320__$1;
(statearr_21322_21408[(2)] = null);

(statearr_21322_21408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (20))){
var inst_21178 = cljs.core.PersistentHashMap.EMPTY;
var state_21320__$1 = state_21320;
var statearr_21323_21409 = state_21320__$1;
(statearr_21323_21409[(2)] = inst_21178);

(statearr_21323_21409[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (27))){
var inst_21196 = (state_21320[(7)]);
var inst_21166 = (state_21320[(8)]);
var inst_21160 = (state_21320[(9)]);
var inst_21180 = (state_21320[(10)]);
var inst_21299 = (state_21320[(2)]);
var inst_21300 = (function (){var top_level_subject = inst_21160;
var select_spec = inst_21166;
var base_acc = inst_21180;
var acc_PLUS_refs = inst_21196;
var result = inst_21299;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4253__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_21301 = cljs.core.PersistentVector.EMPTY;
var inst_21302 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_21166);
var inst_21303 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_21302);
var inst_21304 = cljs.core.vals.call(null,inst_21303);
var inst_21305 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_21166);
var inst_21306 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_21305);
var inst_21307 = cljs.core.vals.call(null,inst_21306);
var inst_21308 = cljs.core.concat.call(null,inst_21304,inst_21307);
var inst_21309 = cljs.core.reduce.call(null,inst_21300,inst_21301,inst_21308);
var inst_21311 = (function (){var top_level_subject = inst_21160;
var select_spec = inst_21166;
var base_acc = inst_21180;
var acc_PLUS_refs = inst_21196;
var result = inst_21299;
var sort_preds = inst_21309;
return (function (acc,p__21310){
var vec__21324 = p__21310;
var selectPred = cljs.core.nth.call(null,vec__21324,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__21324,(1),null);
var sortPred = cljs.core.nth.call(null,vec__21324,(2),null);
var limit = cljs.core.nth.call(null,vec__21324,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql_resp.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_21312 = cljs.core.reduce.call(null,inst_21311,inst_21299,inst_21309);
var state_21320__$1 = state_21320;
var statearr_21327_21410 = state_21320__$1;
(statearr_21327_21410[(2)] = inst_21312);

(statearr_21327_21410[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (1))){
var state_21320__$1 = state_21320;
var statearr_21328_21411 = state_21320__$1;
(statearr_21328_21411[(2)] = null);

(statearr_21328_21411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (24))){
var inst_21196 = (state_21320[(7)]);
var inst_21196__$1 = (state_21320[(2)]);
var inst_21197 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_21198 = cljs.core.PersistentHashMap.EMPTY;
var inst_21199 = inst_21197;
var inst_21200 = inst_21196__$1;
var inst_21201 = inst_21198;
var state_21320__$1 = (function (){var statearr_21329 = state_21320;
(statearr_21329[(7)] = inst_21196__$1);

(statearr_21329[(11)] = inst_21201);

(statearr_21329[(12)] = inst_21200);

(statearr_21329[(13)] = inst_21199);

return statearr_21329;
})();
var statearr_21330_21412 = state_21320__$1;
(statearr_21330_21412[(2)] = null);

(statearr_21330_21412[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (39))){
var inst_21166 = (state_21320[(8)]);
var inst_21216 = (state_21320[(14)]);
var inst_21209 = (state_21320[(15)]);
var inst_21200 = (state_21320[(12)]);
var inst_21245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21246 = fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,inst_21200,inst_21166,inst_21209,inst_21216,false);
var state_21320__$1 = (function (){var statearr_21331 = state_21320;
(statearr_21331[(16)] = inst_21245);

return statearr_21331;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21320__$1,(42),inst_21246);
} else {
if((state_val_21321 === (46))){
var inst_21201 = (state_21320[(11)]);
var inst_21209 = (state_21320[(15)]);
var inst_21199 = (state_21320[(13)]);
var inst_21263 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21264 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_21265 = cljs.core.first.call(null,inst_21209);
var inst_21266 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_21265);
var inst_21267 = [inst_21266];
var inst_21268 = cljs.core.PersistentHashMap.fromArrays(inst_21264,inst_21267);
var inst_21269 = cljs.core.rest.call(null,inst_21199);
var inst_21270 = [inst_21268,inst_21269,inst_21201];
var inst_21271 = (new cljs.core.PersistentVector(null,3,(5),inst_21263,inst_21270,null));
var state_21320__$1 = state_21320;
var statearr_21332_21413 = state_21320__$1;
(statearr_21332_21413[(2)] = inst_21271);

(statearr_21332_21413[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (4))){
var inst_21140 = (state_21320[(2)]);
var state_21320__$1 = state_21320;
var statearr_21333_21414 = state_21320__$1;
(statearr_21333_21414[(2)] = inst_21140);

(statearr_21333_21414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (15))){
var inst_21167 = (state_21320[(17)]);
var inst_21166 = (state_21320[(8)]);
var inst_21166__$1 = (state_21320[(2)]);
var inst_21167__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_21166__$1);
var state_21320__$1 = (function (){var statearr_21334 = state_21320;
(statearr_21334[(17)] = inst_21167__$1);

(statearr_21334[(8)] = inst_21166__$1);

return statearr_21334;
})();
if(cljs.core.truth_(inst_21167__$1)){
var statearr_21335_21415 = state_21320__$1;
(statearr_21335_21415[(1)] = (16));

} else {
var statearr_21336_21416 = state_21320__$1;
(statearr_21336_21416[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (48))){
var inst_21282 = (state_21320[(2)]);
var state_21320__$1 = state_21320;
var statearr_21337_21417 = state_21320__$1;
(statearr_21337_21417[(2)] = inst_21282);

(statearr_21337_21417[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (50))){
var state_21320__$1 = state_21320;
var statearr_21338_21418 = state_21320__$1;
(statearr_21338_21418[(2)] = null);

(statearr_21338_21418[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (21))){
var inst_21166 = (state_21320[(8)]);
var inst_21180 = (state_21320[(2)]);
var inst_21181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21182 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_21183 = (new cljs.core.PersistentVector(null,2,(5),inst_21181,inst_21182,null));
var inst_21184 = cljs.core.get_in.call(null,inst_21166,inst_21183);
var state_21320__$1 = (function (){var statearr_21339 = state_21320;
(statearr_21339[(10)] = inst_21180);

return statearr_21339;
})();
if(cljs.core.truth_(inst_21184)){
var statearr_21340_21419 = state_21320__$1;
(statearr_21340_21419[(1)] = (22));

} else {
var statearr_21341_21420 = state_21320__$1;
(statearr_21341_21420[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (31))){
var inst_21209 = (state_21320[(15)]);
var inst_21215 = (state_21320[(18)]);
var inst_21200 = (state_21320[(12)]);
var inst_21219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21220 = fluree.db.query.fql_resp.flake__GT_recur.call(null,db,inst_21209,inst_21215,inst_21200,fuel,max_fuel,cache);
var state_21320__$1 = (function (){var statearr_21342 = state_21320;
(statearr_21342[(19)] = inst_21219);

return statearr_21342;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21320__$1,(34),inst_21220);
} else {
if((state_val_21321 === (32))){
var inst_21215 = (state_21320[(18)]);
var state_21320__$1 = state_21320;
if(cljs.core.truth_(inst_21215)){
var statearr_21343_21421 = state_21320__$1;
(statearr_21343_21421[(1)] = (35));

} else {
var statearr_21344_21422 = state_21320__$1;
(statearr_21344_21422[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (40))){
var inst_21166 = (state_21320[(8)]);
var inst_21256 = (state_21320[(20)]);
var inst_21255 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_21166);
var inst_21256__$1 = cljs.core.empty_QMARK_.call(null,inst_21255);
var state_21320__$1 = (function (){var statearr_21345 = state_21320;
(statearr_21345[(20)] = inst_21256__$1);

return statearr_21345;
})();
if(inst_21256__$1){
var statearr_21346_21423 = state_21320__$1;
(statearr_21346_21423[(1)] = (43));

} else {
var statearr_21347_21424 = state_21320__$1;
(statearr_21347_21424[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (33))){
var inst_21209 = (state_21320[(15)]);
var inst_21288 = (state_21320[(2)]);
var inst_21289 = cljs.core.nth.call(null,inst_21288,(0),null);
var inst_21290 = cljs.core.nth.call(null,inst_21288,(1),null);
var inst_21291 = cljs.core.nth.call(null,inst_21288,(2),null);
var inst_21292 = cljs.core.first.call(null,inst_21209);
var inst_21293 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_21292);
var inst_21294 = cljs.core.assoc.call(null,inst_21289,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_21293);
var inst_21199 = inst_21290;
var inst_21200 = inst_21294;
var inst_21201 = inst_21291;
var state_21320__$1 = (function (){var statearr_21348 = state_21320;
(statearr_21348[(11)] = inst_21201);

(statearr_21348[(12)] = inst_21200);

(statearr_21348[(13)] = inst_21199);

return statearr_21348;
})();
var statearr_21349_21425 = state_21320__$1;
(statearr_21349_21425[(2)] = null);

(statearr_21349_21425[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (13))){
var inst_21160 = (state_21320[(9)]);
var inst_21163 = fluree.db.query.fql_resp.full_select_spec.call(null,db,cache,base_select_spec,inst_21160);
var state_21320__$1 = state_21320;
var statearr_21350_21426 = state_21320__$1;
(statearr_21350_21426[(2)] = inst_21163);

(statearr_21350_21426[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (22))){
var inst_21166 = (state_21320[(8)]);
var inst_21186 = cljs.core.first.call(null,flakes);
var inst_21187 = fluree.db.flake.s.call(null,inst_21186);
var inst_21188 = fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs.call(null,inst_21166);
var inst_21189 = fluree.db.query.fql_resp.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_21187,inst_21188);
var state_21320__$1 = state_21320;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21320__$1,(25),inst_21189);
} else {
if((state_val_21321 === (36))){
var inst_21166 = (state_21320[(8)]);
var inst_21243 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_21166);
var state_21320__$1 = state_21320;
if(cljs.core.truth_(inst_21243)){
var statearr_21351_21427 = state_21320__$1;
(statearr_21351_21427[(1)] = (39));

} else {
var statearr_21352_21428 = state_21320__$1;
(statearr_21352_21428[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (41))){
var inst_21284 = (state_21320[(2)]);
var state_21320__$1 = state_21320;
var statearr_21353_21429 = state_21320__$1;
(statearr_21353_21429[(2)] = inst_21284);

(statearr_21353_21429[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (43))){
var inst_21166 = (state_21320[(8)]);
var inst_21258 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_21166);
var state_21320__$1 = state_21320;
var statearr_21354_21430 = state_21320__$1;
(statearr_21354_21430[(2)] = inst_21258);

(statearr_21354_21430[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (29))){
var inst_21166 = (state_21320[(8)]);
var inst_21209 = (state_21320[(15)]);
var inst_21215 = (state_21320[(18)]);
var inst_21199 = (state_21320[(13)]);
var inst_21209__$1 = cljs.core.first.call(null,inst_21199);
var inst_21210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21211 = cljs.core.first.call(null,inst_21209__$1);
var inst_21212 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_21211);
var inst_21213 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_21212];
var inst_21214 = (new cljs.core.PersistentVector(null,3,(5),inst_21210,inst_21213,null));
var inst_21215__$1 = cljs.core.get_in.call(null,inst_21166,inst_21214);
var inst_21216 = fluree.db.query.fql_resp.component_follow_QMARK_.call(null,inst_21215__$1,inst_21166);
var inst_21217 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_21215__$1);
var state_21320__$1 = (function (){var statearr_21355 = state_21320;
(statearr_21355[(14)] = inst_21216);

(statearr_21355[(15)] = inst_21209__$1);

(statearr_21355[(18)] = inst_21215__$1);

return statearr_21355;
})();
if(cljs.core.truth_(inst_21217)){
var statearr_21356_21431 = state_21320__$1;
(statearr_21356_21431[(1)] = (31));

} else {
var statearr_21357_21432 = state_21320__$1;
(statearr_21357_21432[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (44))){
var inst_21256 = (state_21320[(20)]);
var state_21320__$1 = state_21320;
var statearr_21358_21433 = state_21320__$1;
(statearr_21358_21433[(2)] = inst_21256);

(statearr_21358_21433[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (6))){
var state_21320__$1 = state_21320;
var statearr_21359_21434 = state_21320__$1;
(statearr_21359_21434[(2)] = null);

(statearr_21359_21434[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (28))){
var inst_21200 = (state_21320[(12)]);
var state_21320__$1 = state_21320;
var statearr_21360_21435 = state_21320__$1;
(statearr_21360_21435[(2)] = inst_21200);

(statearr_21360_21435[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (51))){
var inst_21280 = (state_21320[(2)]);
var state_21320__$1 = state_21320;
var statearr_21361_21436 = state_21320__$1;
(statearr_21361_21436[(2)] = inst_21280);

(statearr_21361_21436[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (25))){
var inst_21180 = (state_21320[(10)]);
var inst_21191 = (state_21320[(2)]);
var inst_21192 = fluree.db.util.async.throw_err.call(null,inst_21191);
var inst_21193 = cljs.core.merge.call(null,inst_21180,inst_21192);
var state_21320__$1 = state_21320;
var statearr_21362_21437 = state_21320__$1;
(statearr_21362_21437[(2)] = inst_21193);

(statearr_21362_21437[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (34))){
var inst_21201 = (state_21320[(11)]);
var inst_21199 = (state_21320[(13)]);
var inst_21219 = (state_21320[(19)]);
var inst_21222 = (state_21320[(2)]);
var inst_21223 = fluree.db.util.async.throw_err.call(null,inst_21222);
var inst_21224 = cljs.core.rest.call(null,inst_21199);
var inst_21225 = [inst_21223,inst_21224,inst_21201];
var inst_21226 = (new cljs.core.PersistentVector(null,3,(5),inst_21219,inst_21225,null));
var state_21320__$1 = state_21320;
var statearr_21363_21438 = state_21320__$1;
(statearr_21363_21438[(2)] = inst_21226);

(statearr_21363_21438[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (17))){
var inst_21166 = (state_21320[(8)]);
var inst_21170 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_21166);
var state_21320__$1 = state_21320;
var statearr_21365_21439 = state_21320__$1;
(statearr_21365_21439[(2)] = inst_21170);

(statearr_21365_21439[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (3))){
var inst_21318 = (state_21320[(2)]);
var state_21320__$1 = state_21320;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21320__$1,inst_21318);
} else {
if((state_val_21321 === (12))){
var _ = (function (){var statearr_21366 = state_21320;
(statearr_21366[(4)] = cljs.core.rest.call(null,(state_21320[(4)])));

return statearr_21366;
})();
var state_21320__$1 = state_21320;
var ex21364 = (state_21320__$1[(2)]);
var statearr_21367_21440 = state_21320__$1;
(statearr_21367_21440[(5)] = ex21364);


var statearr_21368_21441 = state_21320__$1;
(statearr_21368_21441[(1)] = (11));

(statearr_21368_21441[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (2))){
var _ = (function (){var statearr_21369 = state_21320;
(statearr_21369[(4)] = cljs.core.cons.call(null,(5),(state_21320[(4)])));

return statearr_21369;
})();
var inst_21146 = cljs.core.not_empty.call(null,flakes);
var state_21320__$1 = state_21320;
if(cljs.core.truth_(inst_21146)){
var statearr_21370_21442 = state_21320__$1;
(statearr_21370_21442[(1)] = (6));

} else {
var statearr_21371_21443 = state_21320__$1;
(statearr_21371_21443[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (23))){
var inst_21180 = (state_21320[(10)]);
var state_21320__$1 = state_21320;
var statearr_21372_21444 = state_21320__$1;
(statearr_21372_21444[(2)] = inst_21180);

(statearr_21372_21444[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (47))){
var state_21320__$1 = state_21320;
var statearr_21373_21445 = state_21320__$1;
(statearr_21373_21445[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (35))){
var inst_21201 = (state_21320[(11)]);
var inst_21216 = (state_21320[(14)]);
var inst_21209 = (state_21320[(15)]);
var inst_21215 = (state_21320[(18)]);
var inst_21200 = (state_21320[(12)]);
var inst_21232 = fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,inst_21200,inst_21215,inst_21209,inst_21216,false,inst_21201);
var state_21320__$1 = state_21320;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21320__$1,(38),inst_21232);
} else {
if((state_val_21321 === (19))){
var inst_21160 = (state_21320[(9)]);
var inst_21174 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_21175 = [inst_21160];
var inst_21176 = cljs.core.PersistentHashMap.fromArrays(inst_21174,inst_21175);
var state_21320__$1 = state_21320;
var statearr_21375_21446 = state_21320__$1;
(statearr_21375_21446[(2)] = inst_21176);

(statearr_21375_21446[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (11))){
var inst_21148 = (state_21320[(2)]);
var inst_21149 = fluree.db.util.log.error.call(null,inst_21148);
var inst_21150 = (function(){throw inst_21148})();
var state_21320__$1 = (function (){var statearr_21377 = state_21320;
(statearr_21377[(21)] = inst_21149);

return statearr_21377;
})();
var statearr_21378_21447 = state_21320__$1;
(statearr_21378_21447[(2)] = inst_21150);

(statearr_21378_21447[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (9))){
var _ = (function (){var statearr_21379 = state_21320;
(statearr_21379[(4)] = cljs.core.cons.call(null,(12),(state_21320[(4)])));

return statearr_21379;
})();
var inst_21156 = cljs.core.first.call(null,flakes);
var inst_21157 = fluree.db.flake.s.call(null,inst_21156);
var ___$1 = (function (){var statearr_21380 = state_21320;
(statearr_21380[(4)] = cljs.core.rest.call(null,(state_21320[(4)])));

return statearr_21380;
})();
var state_21320__$1 = state_21320;
var statearr_21381_21448 = state_21320__$1;
(statearr_21381_21448[(2)] = inst_21157);

(statearr_21381_21448[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (5))){
var _ = (function (){var statearr_21382 = state_21320;
(statearr_21382[(4)] = cljs.core.rest.call(null,(state_21320[(4)])));

return statearr_21382;
})();
var state_21320__$1 = state_21320;
var ex21376 = (state_21320__$1[(2)]);
var statearr_21383_21449 = state_21320__$1;
(statearr_21383_21449[(5)] = ex21376);


if((ex21376 instanceof Error)){
var statearr_21384_21450 = state_21320__$1;
(statearr_21384_21450[(1)] = (4));

(statearr_21384_21450[(5)] = null);

} else {
throw ex21376;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (14))){
var state_21320__$1 = state_21320;
var statearr_21385_21451 = state_21320__$1;
(statearr_21385_21451[(2)] = base_select_spec);

(statearr_21385_21451[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (45))){
var inst_21261 = (state_21320[(2)]);
var state_21320__$1 = state_21320;
if(cljs.core.truth_(inst_21261)){
var statearr_21386_21452 = state_21320__$1;
(statearr_21386_21452[(1)] = (46));

} else {
var statearr_21387_21453 = state_21320__$1;
(statearr_21387_21453[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (26))){
var inst_21199 = (state_21320[(13)]);
var inst_21203 = cljs.core.empty_QMARK_.call(null,inst_21199);
var state_21320__$1 = state_21320;
if(inst_21203){
var statearr_21388_21454 = state_21320__$1;
(statearr_21388_21454[(1)] = (28));

} else {
var statearr_21389_21455 = state_21320__$1;
(statearr_21389_21455[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (16))){
var inst_21167 = (state_21320[(17)]);
var state_21320__$1 = state_21320;
var statearr_21390_21456 = state_21320__$1;
(statearr_21390_21456[(2)] = inst_21167);

(statearr_21390_21456[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (38))){
var inst_21199 = (state_21320[(13)]);
var inst_21234 = (state_21320[(2)]);
var inst_21235 = fluree.db.util.async.throw_err.call(null,inst_21234);
var inst_21236 = cljs.core.nth.call(null,inst_21235,(0),null);
var inst_21237 = cljs.core.nth.call(null,inst_21235,(1),null);
var inst_21238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21239 = cljs.core.rest.call(null,inst_21199);
var inst_21240 = [inst_21236,inst_21239,inst_21237];
var inst_21241 = (new cljs.core.PersistentVector(null,3,(5),inst_21238,inst_21240,null));
var state_21320__$1 = state_21320;
var statearr_21391_21457 = state_21320__$1;
(statearr_21391_21457[(2)] = inst_21241);

(statearr_21391_21457[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (30))){
var inst_21297 = (state_21320[(2)]);
var state_21320__$1 = state_21320;
var statearr_21392_21458 = state_21320__$1;
(statearr_21392_21458[(2)] = inst_21297);

(statearr_21392_21458[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (10))){
var inst_21160 = (state_21320[(2)]);
var inst_21161 = fluree.db.query.fql_resp.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_21320__$1 = (function (){var statearr_21393 = state_21320;
(statearr_21393[(9)] = inst_21160);

return statearr_21393;
})();
if(cljs.core.truth_(inst_21161)){
var statearr_21394_21459 = state_21320__$1;
(statearr_21394_21459[(1)] = (13));

} else {
var statearr_21395_21460 = state_21320__$1;
(statearr_21395_21460[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (18))){
var inst_21172 = (state_21320[(2)]);
var state_21320__$1 = state_21320;
if(cljs.core.truth_(inst_21172)){
var statearr_21396_21461 = state_21320__$1;
(statearr_21396_21461[(1)] = (19));

} else {
var statearr_21397_21462 = state_21320__$1;
(statearr_21397_21462[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (42))){
var inst_21201 = (state_21320[(11)]);
var inst_21245 = (state_21320[(16)]);
var inst_21199 = (state_21320[(13)]);
var inst_21248 = (state_21320[(2)]);
var inst_21249 = fluree.db.util.async.throw_err.call(null,inst_21248);
var inst_21250 = cljs.core.first.call(null,inst_21249);
var inst_21251 = cljs.core.rest.call(null,inst_21199);
var inst_21252 = [inst_21250,inst_21251,inst_21201];
var inst_21253 = (new cljs.core.PersistentVector(null,3,(5),inst_21245,inst_21252,null));
var state_21320__$1 = state_21320;
var statearr_21398_21463 = state_21320__$1;
(statearr_21398_21463[(2)] = inst_21253);

(statearr_21398_21463[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (37))){
var inst_21286 = (state_21320[(2)]);
var state_21320__$1 = state_21320;
var statearr_21399_21464 = state_21320__$1;
(statearr_21399_21464[(2)] = inst_21286);

(statearr_21399_21464[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (8))){
var inst_21315 = (state_21320[(2)]);
var _ = (function (){var statearr_21400 = state_21320;
(statearr_21400[(4)] = cljs.core.rest.call(null,(state_21320[(4)])));

return statearr_21400;
})();
var state_21320__$1 = state_21320;
var statearr_21401_21465 = state_21320__$1;
(statearr_21401_21465[(2)] = inst_21315);

(statearr_21401_21465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21321 === (49))){
var inst_21201 = (state_21320[(11)]);
var inst_21200 = (state_21320[(12)]);
var inst_21199 = (state_21320[(13)]);
var inst_21274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21275 = cljs.core.rest.call(null,inst_21199);
var inst_21276 = [inst_21200,inst_21275,inst_21201];
var inst_21277 = (new cljs.core.PersistentVector(null,3,(5),inst_21274,inst_21276,null));
var state_21320__$1 = state_21320;
var statearr_21402_21466 = state_21320__$1;
(statearr_21402_21466[(2)] = inst_21277);

(statearr_21402_21466[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0 = (function (){
var statearr_21403 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21403[(0)] = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__);

(statearr_21403[(1)] = (1));

return statearr_21403;
});
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1 = (function (state_21320){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_21320);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21404){var ex__2730__auto__ = e21404;
var statearr_21405_21467 = state_21320;
(statearr_21405_21467[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_21320[(4)]))){
var statearr_21406_21468 = state_21320;
(statearr_21406_21468[(1)] = cljs.core.first.call(null,(state_21320[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21469 = state_21320;
state_21320 = G__21469;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__ = function(state_21320){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1.call(this,state_21320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21407 = f__2750__auto__.call(null);
(statearr_21407[(6)] = c__2749__auto__);

return statearr_21407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
