// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.index');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4253__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * If a predicate is provided as a string value, coerce to pid
 */
fluree.db.query.range.coerce_predicate = (function fluree$db$query$range$coerce_predicate(db,pred){
if(typeof pred === 'string'){
var or__4253__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),pred);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",pred].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return pred;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14170 = match;
var p1 = cljs.core.nth.call(null,vec__14170,(0),null);
var p2 = cljs.core.nth.call(null,vec__14170,(1),null);
var p3 = cljs.core.nth.call(null,vec__14170,(2),null);
var p4 = cljs.core.nth.call(null,vec__14170,(3),null);
var op = cljs.core.nth.call(null,vec__14170,(4),null);
var m = cljs.core.nth.call(null,vec__14170,(5),null);
var G__14173 = idx;
var G__14173__$1 = (((G__14173 instanceof cljs.core.Keyword))?G__14173.fqn:null);
switch (G__14173__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.query.range.coerce_predicate.call(null,db,p2),p3,p4,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate.call(null,db,p1),p3,p4,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate.call(null,db,p1),p2,p4,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate.call(null,db,p2),p1,p4,op,m], null);

break;
case "tspo":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate.call(null,db,p3),p4,p1,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14173__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(9007199254740991)], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
fluree.db.query.range.txn_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.txn_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14175 = idx;
var G__14175__$1 = (((G__14175 instanceof cljs.core.Keyword))?G__14175.fqn:null);
switch (G__14175__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
case "tspo":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14175__$1)].join('')));

}
});
/**
 * Biggest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14177 = idx;
var G__14177__$1 = (((G__14177 instanceof cljs.core.Keyword))?G__14177.fqn:null);
switch (G__14177__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
case "tspo":
return fluree.db.query.range.txn_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14177__$1)].join('')));

}
});
fluree.db.query.range.resolve_subid = (function fluree$db$query$range$resolve_subid(db,id){
var out = cljs.core.async.chan.call(null);
if(cljs.core.not.call(null,id)){
cljs.core.async.close_BANG_.call(null,out);
} else {
if(fluree.db.util.core.pred_ident_QMARK_.call(null,id)){
cljs.core.async.pipe.call(null,fluree.db.dbproto._subid.call(null,db,id),out);
} else {
cljs.core.async.put_BANG_.call(null,out,id);
}
}

return out;
});
fluree.db.query.range.resolve_match_flake = (function fluree$db$query$range$resolve_match_flake(db,test,parts){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14217){
var state_val_14218 = (state_14217[(1)]);
if((state_val_14218 === (7))){
var inst_14194 = (state_14217[(7)]);
var inst_14201 = (state_14217[(2)]);
var inst_14202 = fluree.db.util.async.throw_err.call(null,inst_14201);
var state_14217__$1 = (function (){var statearr_14219 = state_14217;
(statearr_14219[(8)] = inst_14202);

return statearr_14219;
})();
if(cljs.core.truth_(inst_14194)){
var statearr_14220_14244 = state_14217__$1;
(statearr_14220_14244[(1)] = (8));

} else {
var statearr_14221_14245 = state_14217__$1;
(statearr_14221_14245[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14218 === (1))){
var state_14217__$1 = state_14217;
var statearr_14222_14246 = state_14217__$1;
(statearr_14222_14246[(2)] = null);

(statearr_14222_14246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14218 === (4))){
var inst_14179 = (state_14217[(2)]);
var state_14217__$1 = state_14217;
var statearr_14223_14247 = state_14217__$1;
(statearr_14223_14247[(2)] = inst_14179);

(statearr_14223_14247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14218 === (13))){
var inst_14209 = (state_14217[(2)]);
var state_14217__$1 = state_14217;
var statearr_14224_14248 = state_14217__$1;
(statearr_14224_14248[(2)] = inst_14209);

(statearr_14224_14248[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14218 === (6))){
var inst_14191 = (state_14217[(9)]);
var inst_14197 = (state_14217[(2)]);
var inst_14198 = fluree.db.util.async.throw_err.call(null,inst_14197);
var inst_14199 = fluree.db.query.range.resolve_subid.call(null,db,inst_14191);
var state_14217__$1 = (function (){var statearr_14225 = state_14217;
(statearr_14225[(10)] = inst_14198);

return statearr_14225;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14217__$1,(7),inst_14199);
} else {
if((state_val_14218 === (3))){
var inst_14215 = (state_14217[(2)]);
var state_14217__$1 = state_14217;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14217__$1,inst_14215);
} else {
if((state_val_14218 === (12))){
var state_14217__$1 = state_14217;
var statearr_14226_14249 = state_14217__$1;
(statearr_14226_14249[(2)] = (2147483647));

(statearr_14226_14249[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14218 === (2))){
var _ = (function (){var statearr_14227 = state_14217;
(statearr_14227[(4)] = cljs.core.cons.call(null,(5),(state_14217[(4)])));

return statearr_14227;
})();
var inst_14188 = parts;
var inst_14189 = cljs.core.nth.call(null,inst_14188,(0),null);
var inst_14190 = cljs.core.nth.call(null,inst_14188,(1),null);
var inst_14191 = cljs.core.nth.call(null,inst_14188,(2),null);
var inst_14192 = cljs.core.nth.call(null,inst_14188,(3),null);
var inst_14193 = cljs.core.nth.call(null,inst_14188,(4),null);
var inst_14194 = cljs.core.nth.call(null,inst_14188,(5),null);
var inst_14195 = fluree.db.query.range.resolve_subid.call(null,db,inst_14189);
var state_14217__$1 = (function (){var statearr_14228 = state_14217;
(statearr_14228[(11)] = inst_14190);

(statearr_14228[(12)] = inst_14193);

(statearr_14228[(9)] = inst_14191);

(statearr_14228[(7)] = inst_14194);

(statearr_14228[(13)] = inst_14192);

return statearr_14228;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14217__$1,(6),inst_14195);
} else {
if((state_val_14218 === (11))){
var state_14217__$1 = state_14217;
var statearr_14230_14250 = state_14217__$1;
(statearr_14230_14250[(2)] = (-2147483647));

(statearr_14230_14250[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14218 === (9))){
var inst_14205 = (cljs.core._GT__EQ_ === test);
var state_14217__$1 = state_14217;
if(cljs.core.truth_(inst_14205)){
var statearr_14231_14251 = state_14217__$1;
(statearr_14231_14251[(1)] = (11));

} else {
var statearr_14232_14252 = state_14217__$1;
(statearr_14232_14252[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14218 === (5))){
var _ = (function (){var statearr_14233 = state_14217;
(statearr_14233[(4)] = cljs.core.rest.call(null,(state_14217[(4)])));

return statearr_14233;
})();
var state_14217__$1 = state_14217;
var ex14229 = (state_14217__$1[(2)]);
var statearr_14234_14253 = state_14217__$1;
(statearr_14234_14253[(5)] = ex14229);


if((ex14229 instanceof Error)){
var statearr_14235_14254 = state_14217__$1;
(statearr_14235_14254[(1)] = (4));

(statearr_14235_14254[(5)] = null);

} else {
throw ex14229;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14218 === (10))){
var inst_14190 = (state_14217[(11)]);
var inst_14198 = (state_14217[(10)]);
var inst_14193 = (state_14217[(12)]);
var inst_14202 = (state_14217[(8)]);
var inst_14192 = (state_14217[(13)]);
var inst_14211 = (state_14217[(2)]);
var inst_14212 = fluree.db.flake.__GT_Flake.call(null,inst_14198,inst_14190,inst_14202,inst_14192,inst_14193,inst_14211);
var _ = (function (){var statearr_14236 = state_14217;
(statearr_14236[(4)] = cljs.core.rest.call(null,(state_14217[(4)])));

return statearr_14236;
})();
var state_14217__$1 = state_14217;
var statearr_14237_14255 = state_14217__$1;
(statearr_14237_14255[(2)] = inst_14212);

(statearr_14237_14255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14218 === (8))){
var inst_14194 = (state_14217[(7)]);
var state_14217__$1 = state_14217;
var statearr_14238_14256 = state_14217__$1;
(statearr_14238_14256[(2)] = inst_14194);

(statearr_14238_14256[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0 = (function (){
var statearr_14239 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14239[(0)] = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__);

(statearr_14239[(1)] = (1));

return statearr_14239;
});
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1 = (function (state_14217){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_14217);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14240){var ex__2730__auto__ = e14240;
var statearr_14241_14257 = state_14217;
(statearr_14241_14257[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_14217[(4)]))){
var statearr_14242_14258 = state_14217;
(statearr_14242_14258[(1)] = cljs.core.first.call(null,(state_14217[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14259 = state_14217;
state_14217 = G__14259;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__ = function(state_14217){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1.call(this,state_14217);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0;
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1;
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14243 = f__2750__auto__.call(null);
(statearr_14243[(6)] = c__2749__auto__);

return statearr_14243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.range.resolved_leaf_QMARK_ = (function fluree$db$query$range$resolved_leaf_QMARK_(node){
var and__4251__auto__ = fluree.db.index.leaf_QMARK_.call(null,node);
if(and__4251__auto__){
return fluree.db.index.resolved_QMARK_.call(null,node);
} else {
return and__4251__auto__;
}
});
/**
 * Returns true if the supplied `node` contains flakes between the `lower` and
 *   `upper` flakes, according to the `node`'s comparator.
 */
fluree.db.query.range.intersects_range_QMARK_ = (function fluree$db$query$range$intersects_range_QMARK_(node,range_set){
return cljs.core.not.call(null,(function (){var or__4253__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(and__4251__auto__)){
return fluree.db.flake.lower_than_all_QMARK_.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node),range_set);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(node))) && (fluree.db.flake.higher_than_all_QMARK_.call(null,new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(node),range_set)));
}
})());
});
/**
 * Returns a transducer to filter flakes according to the boolean function values
 *   of the `:subject-fn`, `:predicate-fn`, and `:object-fn` keys from the supplied
 *   options map. All three functions are optional, and each supplied function will
 *   be applied to its corresponding flake component, and only flakes where each
 *   function evaluates to a truthy value will be included.
 */
fluree.db.query.range.query_filter = (function fluree$db$query$range$query_filter(p__14260){
var map__14261 = p__14260;
var map__14261__$1 = cljs.core.__destructure_map.call(null,map__14261);
var subject_fn = cljs.core.get.call(null,map__14261__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var predicate_fn = cljs.core.get.call(null,map__14261__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var object_fn = cljs.core.get.call(null,map__14261__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var filter_xfs = (function (){var G__14262 = cljs.core.PersistentVector.EMPTY;
var G__14262__$1 = (cljs.core.truth_(subject_fn)?cljs.core.conj.call(null,G__14262,cljs.core.filter.call(null,(function (f){
return subject_fn.call(null,fluree.db.flake.s.call(null,f));
}))):G__14262);
var G__14262__$2 = (cljs.core.truth_(predicate_fn)?cljs.core.conj.call(null,G__14262__$1,cljs.core.filter.call(null,(function (f){
return predicate_fn.call(null,fluree.db.flake.p.call(null,f));
}))):G__14262__$1);
if(cljs.core.truth_(object_fn)){
return cljs.core.conj.call(null,G__14262__$2,cljs.core.filter.call(null,(function (f){
return object_fn.call(null,fluree.db.flake.o.call(null,f));
})));
} else {
return G__14262__$2;
}
})();
return cljs.core.apply.call(null,cljs.core.comp,filter_xfs);
});
/**
 * Returns a transducer to extract flakes from each leaf from a stream of index
 *   leaf nodes that satisfy the bounds specified in the supplied query options
 *   map. The result of the transformation will be a stream of collections of
 *   flakes from the leaf nodes in the input stream, with one flake collection for
 *   each input leaf.
 */
fluree.db.query.range.extract_query_flakes = (function fluree$db$query$range$extract_query_flakes(p__14263){
var map__14264 = p__14263;
var map__14264__$1 = cljs.core.__destructure_map.call(null,map__14264);
var opts = map__14264__$1;
var start_flake = cljs.core.get.call(null,map__14264__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var start_test = cljs.core.get.call(null,map__14264__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var end_flake = cljs.core.get.call(null,map__14264__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var end_test = cljs.core.get.call(null,map__14264__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
return cljs.core.comp.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.call(null,(function (flakes){
return fluree.db.flake.subrange.call(null,flakes,start_test,start_flake,end_test,end_flake);
})),cljs.core.map.call(null,(function (flakes){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,fluree.db.query.range.query_filter.call(null,opts),flakes);
})));
});
/**
 * Returns a channel that will contain a stream of chunked flake collections that
 *   contain the flakes between `start-flake` and `end-flake` and are within the
 *   transaction range starting at `from-t` and ending at `to-t`.
 */
fluree.db.query.range.resolve_flake_slices = (function fluree$db$query$range$resolve_flake_slices(p__14265,root,novelty,error_ch,p__14266){
var map__14267 = p__14265;
var map__14267__$1 = cljs.core.__destructure_map.call(null,map__14267);
var conn = map__14267__$1;
var async_cache = cljs.core.get.call(null,map__14267__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var map__14268 = p__14266;
var map__14268__$1 = cljs.core.__destructure_map.call(null,map__14268);
var opts = map__14268__$1;
var from_t = cljs.core.get.call(null,map__14268__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525));
var to_t = cljs.core.get.call(null,map__14268__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359));
var start_flake = cljs.core.get.call(null,map__14268__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.call(null,map__14268__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var resolver = fluree.db.index.__GT_CachedTRangeResolver.call(null,conn,novelty,from_t,to_t,async_cache);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(root);
var range_set = fluree.db.flake.sorted_set_by.call(null,cmp,start_flake,end_flake);
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_.call(null,node,range_set);
});
var query_xf = fluree.db.query.range.extract_query_flakes.call(null,opts);
return fluree.db.index.tree_chan.call(null,resolver,root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
});
fluree.db.query.range.unauthorized_QMARK_ = (function fluree$db$query$range$unauthorized_QMARK_(f){
return cljs.core._EQ_.call(null,f,new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));
});
fluree.db.query.range.authorize_flake = (function fluree$db$query$range$authorize_flake(db,error_ch,flake){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14299){
var state_val_14300 = (state_14299[(1)]);
if((state_val_14300 === (7))){
var inst_14282 = (state_14299[(7)]);
var state_14299__$1 = state_14299;
var statearr_14301_14325 = state_14299__$1;
(statearr_14301_14325[(2)] = inst_14282);

(statearr_14301_14325[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14300 === (1))){
var state_14299__$1 = state_14299;
var statearr_14302_14326 = state_14299__$1;
(statearr_14302_14326[(2)] = null);

(statearr_14302_14326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14300 === (4))){
var inst_14269 = (state_14299[(2)]);
var inst_14270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14271 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_14272 = (new cljs.core.PersistentVector(null,3,(5),inst_14270,inst_14271,null));
var inst_14273 = cljs.core.select_keys.call(null,db,inst_14272);
var inst_14274 = fluree.db.util.log.error.call(null,inst_14269,"Error authorizing flake in ledger",inst_14273);
var state_14299__$1 = (function (){var statearr_14304 = state_14299;
(statearr_14304[(8)] = inst_14274);

return statearr_14304;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14299__$1,(5),error_ch,inst_14269);
} else {
if((state_val_14300 === (13))){
var inst_14294 = (state_14299[(2)]);
var _ = (function (){var statearr_14305 = state_14299;
(statearr_14305[(4)] = cljs.core.rest.call(null,(state_14299[(4)])));

return statearr_14305;
})();
var state_14299__$1 = state_14299;
var statearr_14306_14327 = state_14299__$1;
(statearr_14306_14327[(2)] = inst_14294);

(statearr_14306_14327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14300 === (6))){
var _ = (function (){var statearr_14307 = state_14299;
(statearr_14307[(4)] = cljs.core.rest.call(null,(state_14299[(4)])));

return statearr_14307;
})();
var state_14299__$1 = state_14299;
var ex14303 = (state_14299__$1[(2)]);
var statearr_14308_14328 = state_14299__$1;
(statearr_14308_14328[(5)] = ex14303);


var statearr_14309_14329 = state_14299__$1;
(statearr_14309_14329[(1)] = (4));

(statearr_14309_14329[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14300 === (3))){
var inst_14297 = (state_14299[(2)]);
var state_14299__$1 = state_14299;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14299__$1,inst_14297);
} else {
if((state_val_14300 === (12))){
var state_14299__$1 = state_14299;
var statearr_14310_14330 = state_14299__$1;
(statearr_14310_14330[(2)] = new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));

(statearr_14310_14330[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14300 === (2))){
var inst_14282 = (state_14299[(7)]);
var _ = (function (){var statearr_14311 = state_14299;
(statearr_14311[(4)] = cljs.core.cons.call(null,(6),(state_14299[(4)])));

return statearr_14311;
})();
var inst_14282__$1 = fluree.db.util.schema.is_schema_flake_QMARK_.call(null,flake);
var state_14299__$1 = (function (){var statearr_14312 = state_14299;
(statearr_14312[(7)] = inst_14282__$1);

return statearr_14312;
})();
if(inst_14282__$1){
var statearr_14313_14331 = state_14299__$1;
(statearr_14313_14331[(1)] = (7));

} else {
var statearr_14314_14332 = state_14299__$1;
(statearr_14314_14332[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14300 === (11))){
var state_14299__$1 = state_14299;
var statearr_14315_14333 = state_14299__$1;
(statearr_14315_14333[(2)] = flake);

(statearr_14315_14333[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14300 === (9))){
var inst_14290 = (state_14299[(2)]);
var state_14299__$1 = state_14299;
if(cljs.core.truth_(inst_14290)){
var statearr_14316_14334 = state_14299__$1;
(statearr_14316_14334[(1)] = (11));

} else {
var statearr_14317_14335 = state_14299__$1;
(statearr_14317_14335[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14300 === (5))){
var inst_14276 = (state_14299[(2)]);
var state_14299__$1 = state_14299;
var statearr_14318_14336 = state_14299__$1;
(statearr_14318_14336[(2)] = inst_14276);

(statearr_14318_14336[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14300 === (10))){
var inst_14287 = (state_14299[(2)]);
var inst_14288 = fluree.db.util.async.throw_err.call(null,inst_14287);
var state_14299__$1 = state_14299;
var statearr_14319_14337 = state_14299__$1;
(statearr_14319_14337[(2)] = inst_14288);

(statearr_14319_14337[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14300 === (8))){
var inst_14285 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,flake);
var state_14299__$1 = state_14299;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14299__$1,(10),inst_14285);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0 = (function (){
var statearr_14320 = [null,null,null,null,null,null,null,null,null];
(statearr_14320[(0)] = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__);

(statearr_14320[(1)] = (1));

return statearr_14320;
});
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1 = (function (state_14299){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_14299);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14321){var ex__2730__auto__ = e14321;
var statearr_14322_14338 = state_14299;
(statearr_14322_14338[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_14299[(4)]))){
var statearr_14323_14339 = state_14299;
(statearr_14323_14339[(1)] = cljs.core.first.call(null,(state_14299[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14340 = state_14299;
state_14299 = G__14340;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__ = function(state_14299){
switch(arguments.length){
case 0:
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1.call(this,state_14299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0;
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1;
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14324 = f__2750__auto__.call(null);
(statearr_14324[(6)] = c__2749__auto__);

return statearr_14324;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Authorize each flake in the supplied `flakes` collection asynchronously,
 *   returning a collection containing only allowed flakes according to the
 *   permissions of the supplied `db`.
 */
fluree.db.query.range.authorize_flakes = (function fluree$db$query$range$authorize_flakes(db,error_ch,flakes){
return cljs.core.async.map.call(null,(function() { 
var G__14341__delegate = function (fs){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,fluree.db.query.range.unauthorized_QMARK_),fs);
};
var G__14341 = function (var_args){
var fs = null;
if (arguments.length > 0) {
var G__14342__i = 0, G__14342__a = new Array(arguments.length -  0);
while (G__14342__i < G__14342__a.length) {G__14342__a[G__14342__i] = arguments[G__14342__i + 0]; ++G__14342__i;}
  fs = new cljs.core.IndexedSeq(G__14342__a,0,null);
} 
return G__14341__delegate.call(this,fs);};
G__14341.cljs$lang$maxFixedArity = 0;
G__14341.cljs$lang$applyTo = (function (arglist__14343){
var fs = cljs.core.seq(arglist__14343);
return G__14341__delegate(fs);
});
G__14341.cljs$core$IFn$_invoke$arity$variadic = G__14341__delegate;
return G__14341;
})()
,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.range.authorize_flake,db,error_ch),flakes));
});
/**
 * Returns a channel that will eventually return a stream of flake slices
 *   containing only the schema flakes and the flakes validated by
 *   fluree.db.permissions-validate/allow-flake? function for the database `db`
 *   from the `flake-slices` channel
 */
fluree.db.query.range.filter_authorized = (function fluree$db$query$range$filter_authorized(p__14344,start,end,error_ch,flake_slices){
var map__14345 = p__14344;
var map__14345__$1 = cljs.core.__destructure_map.call(null,map__14345);
var db = map__14345__$1;
var permissions = cljs.core.get.call(null,map__14345__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
return flake_slices;
});
/**
 * Returns a transducer to filter a stream of flakes to only contain flakes from
 *   at most `limit` subjects, skipping the flakes from the first `offset`
 *   subjects.
 */
fluree.db.query.range.filter_subject_page = (function fluree$db$query$range$filter_subject_page(limit,offset){
var subject_page_xfs = (function (){var G__14346 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.partition_by.call(null,fluree.db.flake.s)], null);
var G__14346__$1 = (cljs.core.truth_(offset)?cljs.core.conj.call(null,G__14346,cljs.core.drop.call(null,offset)):G__14346);
var G__14346__$2 = (cljs.core.truth_(limit)?cljs.core.conj.call(null,G__14346__$1,cljs.core.take.call(null,limit)):G__14346__$1);
return cljs.core.conj.call(null,G__14346__$2,cljs.core.cat);

})();
return cljs.core.apply.call(null,cljs.core.comp,subject_page_xfs);
});
/**
 * Collects flakes from the stream of flake collections in the `flake-slices`
 *   channel into a sorted vector according to the `limit`, `offset`, and
 *   `flake-limit` parameters. The result will have flakes from at most `limit`
 *   subjects, not including flakes from the first `offset` subjects, and having at
 *   most `flake-limit` flakes in total.
 */
fluree.db.query.range.into_page = (function fluree$db$query$range$into_page(limit,offset,flake_limit,flake_slices){
var page_xfs = (function (){var G__14347 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cat], null);
var G__14347__$1 = (cljs.core.truth_((function (){var or__4253__auto__ = limit;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return offset;
}
})())?cljs.core.conj.call(null,G__14347,fluree.db.query.range.filter_subject_page.call(null,limit,offset)):G__14347);
if(cljs.core.truth_(flake_limit)){
return cljs.core.conj.call(null,G__14347__$1,cljs.core.take.call(null,flake_limit));
} else {
return G__14347__$1;
}
})();
var page_xf = cljs.core.apply.call(null,cljs.core.comp,page_xfs);
return cljs.core.async.transduce.call(null,page_xf,cljs.core.conj,cljs.core.PersistentVector.EMPTY,flake_slices);
});
/**
 * Return a channel that will eventually hold a sorted vector of the range of
 *   flakes from `db` that meet the criteria specified in the `opts` map.
 */
fluree.db.query.range.index_range_STAR_ = (function fluree$db$query$range$index_range_STAR_(p__14348,error_ch,p__14349){
var map__14350 = p__14348;
var map__14350__$1 = cljs.core.__destructure_map.call(null,map__14350);
var db = map__14350__$1;
var conn = cljs.core.get.call(null,map__14350__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__14351 = p__14349;
var map__14351__$1 = cljs.core.__destructure_map.call(null,map__14351);
var opts = map__14351__$1;
var idx = cljs.core.get.call(null,map__14351__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var start_flake = cljs.core.get.call(null,map__14351__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.call(null,map__14351__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var limit = cljs.core.get.call(null,map__14351__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__14351__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var flake_limit = cljs.core.get.call(null,map__14351__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961));
var idx_root = cljs.core.get.call(null,db,idx);
var idx_cmp = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var novelty = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx], null));
return fluree.db.query.range.into_page.call(null,limit,offset,flake_limit,fluree.db.query.range.filter_authorized.call(null,db,start_flake,end_flake,error_ch,fluree.db.query.range.resolve_flake_slices.call(null,conn,idx_root,novelty,error_ch,opts)));
});
/**
 * Finds the full index or time range interval including the maximum and minimum
 *   tests when only one test is provided
 */
fluree.db.query.range.expand_range_interval = (function fluree$db$query$range$expand_range_interval(idx,test,match){
var pred__14352 = cljs.core.identical_QMARK_;
var expr__14353 = test;
if(cljs.core.truth_(pred__14352.call(null,cljs.core._EQ_,expr__14353))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14352.call(null,cljs.core._LT_,expr__14353))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__14352.call(null,cljs.core._LT__EQ_,expr__14353))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14352.call(null,cljs.core._GT_,expr__14353))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__14352.call(null,cljs.core._GT__EQ_,expr__14353))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14353)].join('')));
}
}
}
}
}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we
 *   don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will return in
 *   reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number
 *          is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used
 *         when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__14356 = arguments.length;
switch (G__14356) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14357 = fluree.db.query.range.expand_range_interval.call(null,idx,test,match);
var start_test = cljs.core.nth.call(null,vec__14357,(0),null);
var start_match = cljs.core.nth.call(null,vec__14357,(1),null);
var end_test = cljs.core.nth.call(null,vec__14357,(2),null);
var end_match = cljs.core.nth.call(null,vec__14357,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (p__14360,idx,start_test,start_match,end_test,end_match,opts){
var map__14361 = p__14360;
var map__14361__$1 = cljs.core.__destructure_map.call(null,map__14361);
var db = map__14361__$1;
var t = cljs.core.get.call(null,map__14361__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__14362 = opts;
var map__14362__$1 = cljs.core.__destructure_map.call(null,map__14362);
var limit = cljs.core.get.call(null,map__14362__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var from_t = cljs.core.get.call(null,map__14362__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t);
var to_t = cljs.core.get.call(null,map__14362__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359),t);
var idx_compare = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var start_parts = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var end_parts = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14424){
var state_val_14425 = (state_14424[(1)]);
if((state_val_14425 === (7))){
var inst_14377 = (state_14424[(7)]);
var inst_14372 = (state_14424[(8)]);
var inst_14381 = (state_14424[(9)]);
var inst_14375 = (state_14424[(2)]);
var inst_14376 = fluree.db.util.async.throw_err.call(null,inst_14375);
var inst_14377__$1 = cljs.core.async.chan.call(null);
var inst_14378 = [new cljs.core.Keyword(null,"idx","idx",1053688473),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"start-test","start-test",-952983565),new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),new cljs.core.Keyword(null,"end-test","end-test",481973727),new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961)];
var inst_14379 = [idx,from_t,to_t,start_test,inst_14372,end_test,inst_14376,limit];
var inst_14380 = cljs.core.PersistentHashMap.fromArrays(inst_14378,inst_14379);
var inst_14381__$1 = fluree.db.query.range.index_range_STAR_.call(null,db,inst_14377__$1,inst_14380);
var inst_14389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14390 = [inst_14377__$1,inst_14381__$1];
var inst_14391 = (new cljs.core.PersistentVector(null,2,(5),inst_14389,inst_14390,null));
var state_14424__$1 = (function (){var statearr_14426 = state_14424;
(statearr_14426[(7)] = inst_14377__$1);

(statearr_14426[(9)] = inst_14381__$1);

return statearr_14426;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_14424__$1,(8),inst_14391);
} else {
if((state_val_14425 === (1))){
var state_14424__$1 = state_14424;
var statearr_14427_14456 = state_14424__$1;
(statearr_14427_14456[(2)] = null);

(statearr_14427_14456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (4))){
var inst_14363 = (state_14424[(2)]);
var state_14424__$1 = state_14424;
var statearr_14428_14457 = state_14424__$1;
(statearr_14428_14457[(2)] = inst_14363);

(statearr_14428_14457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (15))){
var inst_14394 = (state_14424[(10)]);
var state_14424__$1 = state_14424;
var statearr_14429_14458 = state_14424__$1;
(statearr_14429_14458[(2)] = inst_14394);

(statearr_14429_14458[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (13))){
var inst_14395 = (state_14424[(11)]);
var inst_14411 = cljs.core._EQ_.call(null,inst_14395,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_14424__$1 = state_14424;
if(inst_14411){
var statearr_14430_14459 = state_14424__$1;
(statearr_14430_14459[(1)] = (15));

} else {
var statearr_14431_14460 = state_14424__$1;
(statearr_14431_14460[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (6))){
var inst_14371 = (state_14424[(2)]);
var inst_14372 = fluree.db.util.async.throw_err.call(null,inst_14371);
var inst_14373 = fluree.db.query.range.resolve_match_flake.call(null,db,end_test,end_parts);
var state_14424__$1 = (function (){var statearr_14432 = state_14424;
(statearr_14432[(8)] = inst_14372);

return statearr_14432;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14424__$1,(7),inst_14373);
} else {
if((state_val_14425 === (17))){
var inst_14415 = (state_14424[(2)]);
var state_14424__$1 = state_14424;
var statearr_14433_14461 = state_14424__$1;
(statearr_14433_14461[(2)] = inst_14415);

(statearr_14433_14461[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (3))){
var inst_14422 = (state_14424[(2)]);
var state_14424__$1 = state_14424;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14424__$1,inst_14422);
} else {
if((state_val_14425 === (12))){
var inst_14393 = (state_14424[(12)]);
var inst_14409 = cljs.core.nth.call(null,inst_14393,(0),null);
var state_14424__$1 = state_14424;
var statearr_14434_14462 = state_14424__$1;
(statearr_14434_14462[(2)] = inst_14409);

(statearr_14434_14462[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (2))){
var _ = (function (){var statearr_14435 = state_14424;
(statearr_14435[(4)] = cljs.core.cons.call(null,(5),(state_14424[(4)])));

return statearr_14435;
})();
var inst_14369 = fluree.db.query.range.resolve_match_flake.call(null,db,start_test,start_parts);
var state_14424__$1 = state_14424;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14424__$1,(6),inst_14369);
} else {
if((state_val_14425 === (11))){
var inst_14419 = (state_14424[(2)]);
var _ = (function (){var statearr_14437 = state_14424;
(statearr_14437[(4)] = cljs.core.rest.call(null,(state_14424[(4)])));

return statearr_14437;
})();
var state_14424__$1 = state_14424;
var statearr_14438_14463 = state_14424__$1;
(statearr_14438_14463[(2)] = inst_14419);

(statearr_14438_14463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (9))){
var inst_14393 = (state_14424[(12)]);
var inst_14401 = cljs.core.nth.call(null,inst_14393,(0),null);
var inst_14402 = (function(){throw inst_14401})();
var state_14424__$1 = state_14424;
var statearr_14439_14464 = state_14424__$1;
(statearr_14439_14464[(2)] = inst_14402);

(statearr_14439_14464[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (5))){
var _ = (function (){var statearr_14440 = state_14424;
(statearr_14440[(4)] = cljs.core.rest.call(null,(state_14424[(4)])));

return statearr_14440;
})();
var state_14424__$1 = state_14424;
var ex14436 = (state_14424__$1[(2)]);
var statearr_14441_14465 = state_14424__$1;
(statearr_14441_14465[(5)] = ex14436);


if((ex14436 instanceof Error)){
var statearr_14442_14466 = state_14424__$1;
(statearr_14442_14466[(1)] = (4));

(statearr_14442_14466[(5)] = null);

} else {
throw ex14436;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (14))){
var inst_14417 = (state_14424[(2)]);
var state_14424__$1 = state_14424;
var statearr_14443_14467 = state_14424__$1;
(statearr_14443_14467[(2)] = inst_14417);

(statearr_14443_14467[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (16))){
var state_14424__$1 = state_14424;
var statearr_14444_14468 = state_14424__$1;
(statearr_14444_14468[(2)] = null);

(statearr_14444_14468[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (10))){
var inst_14395 = (state_14424[(11)]);
var inst_14381 = (state_14424[(9)]);
var inst_14404 = cljs.core._EQ_.call(null,inst_14395,inst_14381);
var state_14424__$1 = state_14424;
if(inst_14404){
var statearr_14445_14469 = state_14424__$1;
(statearr_14445_14469[(1)] = (12));

} else {
var statearr_14446_14470 = state_14424__$1;
(statearr_14446_14470[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (8))){
var inst_14377 = (state_14424[(7)]);
var inst_14393 = (state_14424[(12)]);
var inst_14395 = (state_14424[(11)]);
var inst_14393__$1 = (state_14424[(2)]);
var inst_14394 = cljs.core.nth.call(null,inst_14393__$1,(0),null);
var inst_14395__$1 = cljs.core.nth.call(null,inst_14393__$1,(1),null);
var inst_14396 = cljs.core._EQ_.call(null,inst_14395__$1,inst_14377);
var state_14424__$1 = (function (){var statearr_14447 = state_14424;
(statearr_14447[(10)] = inst_14394);

(statearr_14447[(12)] = inst_14393__$1);

(statearr_14447[(11)] = inst_14395__$1);

return statearr_14447;
})();
if(inst_14396){
var statearr_14448_14471 = state_14424__$1;
(statearr_14448_14471[(1)] = (9));

} else {
var statearr_14449_14472 = state_14424__$1;
(statearr_14449_14472[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_14450 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14450[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_14450[(1)] = (1));

return statearr_14450;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_14424){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_14424);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14451){var ex__2730__auto__ = e14451;
var statearr_14452_14473 = state_14424;
(statearr_14452_14473[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_14424[(4)]))){
var statearr_14453_14474 = state_14424;
(statearr_14453_14474[(1)] = cljs.core.first.call(null,(state_14424[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14475 = state_14424;
state_14424 = G__14475;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_14424){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_14424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14454 = f__2750__auto__.call(null);
(statearr_14454[(6)] = c__2749__auto__);

return statearr_14454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__14477 = arguments.length;
switch (G__14477) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14478 = fluree.db.query.range.expand_range_interval.call(null,idx,test,match);
var start_test = cljs.core.nth.call(null,vec__14478,(0),null);
var start_match = cljs.core.nth.call(null,vec__14478,(1),null);
var end_test = cljs.core.nth.call(null,vec__14478,(2),null);
var end_match = cljs.core.nth.call(null,vec__14478,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (p__14481,idx,start_test,start_match,end_test,end_match,p__14482){
var map__14483 = p__14481;
var map__14483__$1 = cljs.core.__destructure_map.call(null,map__14483);
var db = map__14483__$1;
var permissions = cljs.core.get.call(null,map__14483__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var t = cljs.core.get.call(null,map__14483__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__14484 = p__14482;
var map__14484__$1 = cljs.core.__destructure_map.call(null,map__14484);
var opts = map__14484__$1;
var object_fn = cljs.core.get.call(null,map__14484__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var idx_compare = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var vec__14485 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var s1 = cljs.core.nth.call(null,vec__14485,(0),null);
var p1 = cljs.core.nth.call(null,vec__14485,(1),null);
var o1 = cljs.core.nth.call(null,vec__14485,(2),null);
var t1 = cljs.core.nth.call(null,vec__14485,(3),null);
var op1 = cljs.core.nth.call(null,vec__14485,(4),null);
var m1 = cljs.core.nth.call(null,vec__14485,(5),null);
var vec__14488 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var s2 = cljs.core.nth.call(null,vec__14488,(0),null);
var p2 = cljs.core.nth.call(null,vec__14488,(1),null);
var o2 = cljs.core.nth.call(null,vec__14488,(2),null);
var t2 = cljs.core.nth.call(null,vec__14488,(3),null);
var op2 = cljs.core.nth.call(null,vec__14488,(4),null);
var m2 = cljs.core.nth.call(null,vec__14488,(5),null);
var vec__14491 = (function (){var temp__5806__auto__ = ((cljs.core.boolean_QMARK_.call(null,o1))?o1:((cljs.core.boolean_QMARK_.call(null,o2))?o2:null
));
if((temp__5806__auto__ == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o1,o2], null),object_fn], null);
} else {
var bool = temp__5806__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),(function (o){
return cljs.core._EQ_.call(null,o,bool);
})], null);
}
})();
var vec__14494 = cljs.core.nth.call(null,vec__14491,(0),null);
var o1__$1 = cljs.core.nth.call(null,vec__14494,(0),null);
var o2__$1 = cljs.core.nth.call(null,vec__14494,(1),null);
var object_fn__$1 = cljs.core.nth.call(null,vec__14491,(1),null);
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14562){
var state_val_14563 = (state_14562[(1)]);
if((state_val_14563 === (7))){
var inst_14519 = (state_14562[(7)]);
var inst_14509 = (state_14562[(8)]);
var inst_14517 = (state_14562[(9)]);
var inst_14515 = (state_14562[(2)]);
var inst_14516 = fluree.db.util.async.throw_err.call(null,inst_14515);
var inst_14517__$1 = cljs.core.async.chan.call(null);
var inst_14518 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"idx","idx",1053688473),idx,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t,new cljs.core.Keyword(null,"to-t","to-t",569467359),t,new cljs.core.Keyword(null,"start-test","start-test",-952983565),start_test,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),inst_14509,new cljs.core.Keyword(null,"end-test","end-test",481973727),end_test,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),inst_14516,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),object_fn__$1);
var inst_14519__$1 = fluree.db.query.range.index_range_STAR_.call(null,db,inst_14517__$1,inst_14518);
var inst_14527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14528 = [inst_14517__$1,inst_14519__$1];
var inst_14529 = (new cljs.core.PersistentVector(null,2,(5),inst_14527,inst_14528,null));
var state_14562__$1 = (function (){var statearr_14564 = state_14562;
(statearr_14564[(7)] = inst_14519__$1);

(statearr_14564[(9)] = inst_14517__$1);

return statearr_14564;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_14562__$1,(8),inst_14529);
} else {
if((state_val_14563 === (1))){
var state_14562__$1 = state_14562;
var statearr_14565_14594 = state_14562__$1;
(statearr_14565_14594[(2)] = null);

(statearr_14565_14594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14563 === (4))){
var inst_14497 = (state_14562[(2)]);
var state_14562__$1 = state_14562;
var statearr_14566_14595 = state_14562__$1;
(statearr_14566_14595[(2)] = inst_14497);

(statearr_14566_14595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14563 === (15))){
var inst_14532 = (state_14562[(10)]);
var state_14562__$1 = state_14562;
var statearr_14567_14596 = state_14562__$1;
(statearr_14567_14596[(2)] = inst_14532);

(statearr_14567_14596[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14563 === (13))){
var inst_14533 = (state_14562[(11)]);
var inst_14549 = cljs.core._EQ_.call(null,inst_14533,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_14562__$1 = state_14562;
if(inst_14549){
var statearr_14568_14597 = state_14562__$1;
(statearr_14568_14597[(1)] = (15));

} else {
var statearr_14569_14598 = state_14562__$1;
(statearr_14569_14598[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14563 === (6))){
var inst_14508 = (state_14562[(2)]);
var inst_14509 = fluree.db.util.async.throw_err.call(null,inst_14508);
var inst_14510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14511 = [s2,p2,o2__$1,t2,op2,m2];
var inst_14512 = (new cljs.core.PersistentVector(null,6,(5),inst_14510,inst_14511,null));
var inst_14513 = fluree.db.query.range.resolve_match_flake.call(null,db,end_test,inst_14512);
var state_14562__$1 = (function (){var statearr_14570 = state_14562;
(statearr_14570[(8)] = inst_14509);

return statearr_14570;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14562__$1,(7),inst_14513);
} else {
if((state_val_14563 === (17))){
var inst_14553 = (state_14562[(2)]);
var state_14562__$1 = state_14562;
var statearr_14571_14599 = state_14562__$1;
(statearr_14571_14599[(2)] = inst_14553);

(statearr_14571_14599[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14563 === (3))){
var inst_14560 = (state_14562[(2)]);
var state_14562__$1 = state_14562;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14562__$1,inst_14560);
} else {
if((state_val_14563 === (12))){
var inst_14531 = (state_14562[(12)]);
var inst_14547 = cljs.core.nth.call(null,inst_14531,(0),null);
var state_14562__$1 = state_14562;
var statearr_14572_14600 = state_14562__$1;
(statearr_14572_14600[(2)] = inst_14547);

(statearr_14572_14600[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14563 === (2))){
var _ = (function (){var statearr_14573 = state_14562;
(statearr_14573[(4)] = cljs.core.cons.call(null,(5),(state_14562[(4)])));

return statearr_14573;
})();
var inst_14503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14504 = [s1,p1,o1__$1,t1,op1,m1];
var inst_14505 = (new cljs.core.PersistentVector(null,6,(5),inst_14503,inst_14504,null));
var inst_14506 = fluree.db.query.range.resolve_match_flake.call(null,db,start_test,inst_14505);
var state_14562__$1 = state_14562;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14562__$1,(6),inst_14506);
} else {
if((state_val_14563 === (11))){
var inst_14557 = (state_14562[(2)]);
var _ = (function (){var statearr_14575 = state_14562;
(statearr_14575[(4)] = cljs.core.rest.call(null,(state_14562[(4)])));

return statearr_14575;
})();
var state_14562__$1 = state_14562;
var statearr_14576_14601 = state_14562__$1;
(statearr_14576_14601[(2)] = inst_14557);

(statearr_14576_14601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14563 === (9))){
var inst_14531 = (state_14562[(12)]);
var inst_14539 = cljs.core.nth.call(null,inst_14531,(0),null);
var inst_14540 = (function(){throw inst_14539})();
var state_14562__$1 = state_14562;
var statearr_14577_14602 = state_14562__$1;
(statearr_14577_14602[(2)] = inst_14540);

(statearr_14577_14602[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14563 === (5))){
var _ = (function (){var statearr_14578 = state_14562;
(statearr_14578[(4)] = cljs.core.rest.call(null,(state_14562[(4)])));

return statearr_14578;
})();
var state_14562__$1 = state_14562;
var ex14574 = (state_14562__$1[(2)]);
var statearr_14579_14603 = state_14562__$1;
(statearr_14579_14603[(5)] = ex14574);


if((ex14574 instanceof Error)){
var statearr_14580_14604 = state_14562__$1;
(statearr_14580_14604[(1)] = (4));

(statearr_14580_14604[(5)] = null);

} else {
throw ex14574;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14563 === (14))){
var inst_14555 = (state_14562[(2)]);
var state_14562__$1 = state_14562;
var statearr_14581_14605 = state_14562__$1;
(statearr_14581_14605[(2)] = inst_14555);

(statearr_14581_14605[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14563 === (16))){
var state_14562__$1 = state_14562;
var statearr_14582_14606 = state_14562__$1;
(statearr_14582_14606[(2)] = null);

(statearr_14582_14606[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14563 === (10))){
var inst_14533 = (state_14562[(11)]);
var inst_14519 = (state_14562[(7)]);
var inst_14542 = cljs.core._EQ_.call(null,inst_14533,inst_14519);
var state_14562__$1 = state_14562;
if(inst_14542){
var statearr_14583_14607 = state_14562__$1;
(statearr_14583_14607[(1)] = (12));

} else {
var statearr_14584_14608 = state_14562__$1;
(statearr_14584_14608[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14563 === (8))){
var inst_14533 = (state_14562[(11)]);
var inst_14531 = (state_14562[(12)]);
var inst_14517 = (state_14562[(9)]);
var inst_14531__$1 = (state_14562[(2)]);
var inst_14532 = cljs.core.nth.call(null,inst_14531__$1,(0),null);
var inst_14533__$1 = cljs.core.nth.call(null,inst_14531__$1,(1),null);
var inst_14534 = cljs.core._EQ_.call(null,inst_14533__$1,inst_14517);
var state_14562__$1 = (function (){var statearr_14585 = state_14562;
(statearr_14585[(10)] = inst_14532);

(statearr_14585[(11)] = inst_14533__$1);

(statearr_14585[(12)] = inst_14531__$1);

return statearr_14585;
})();
if(inst_14534){
var statearr_14586_14609 = state_14562__$1;
(statearr_14586_14609[(1)] = (9));

} else {
var statearr_14587_14610 = state_14562__$1;
(statearr_14587_14610[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_14588 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14588[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_14588[(1)] = (1));

return statearr_14588;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_14562){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_14562);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14589){var ex__2730__auto__ = e14589;
var statearr_14590_14611 = state_14562;
(statearr_14590_14611[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_14562[(4)]))){
var statearr_14591_14612 = state_14562;
(statearr_14591_14612[(1)] = cljs.core.first.call(null,(state_14562[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14613 = state_14562;
state_14562 = G__14613;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_14562){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_14562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14592 = f__2750__auto__.call(null);
(statearr_14592[(6)] = c__2749__auto__);

return statearr_14592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= fluree.db.flake.o.call(null,f))) && ((fluree.db.flake.o.call(null,f) <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14669){
var state_val_14670 = (state_14669[(1)]);
if((state_val_14670 === (7))){
var inst_14643 = (state_14669[(7)]);
var inst_14633 = (state_14669[(8)]);
var inst_14641 = fluree.db.flake.Flake__GT_parts.call(null,inst_14633);
var inst_14642 = cljs.core.nth.call(null,inst_14641,(0),null);
var inst_14643__$1 = cljs.core.nth.call(null,inst_14641,(1),null);
var inst_14644 = cljs.core.nth.call(null,inst_14641,(2),null);
var inst_14645 = cljs.core.nth.call(null,inst_14641,(3),null);
var inst_14646 = cljs.core.nth.call(null,inst_14641,(4),null);
var inst_14647 = cljs.core.nth.call(null,inst_14641,(5),null);
var inst_14648 = fluree.db.dbproto._tag.call(null,db,inst_14644,inst_14643__$1);
var state_14669__$1 = (function (){var statearr_14671 = state_14669;
(statearr_14671[(9)] = inst_14642);

(statearr_14671[(7)] = inst_14643__$1);

(statearr_14671[(10)] = inst_14646);

(statearr_14671[(11)] = inst_14647);

(statearr_14671[(12)] = inst_14645);

return statearr_14671;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14669__$1,(10),inst_14648);
} else {
if((state_val_14670 === (1))){
var inst_14621 = flakes;
var inst_14622 = cljs.core.seq.call(null,inst_14621);
var inst_14623 = cljs.core.first.call(null,inst_14622);
var inst_14624 = cljs.core.next.call(null,inst_14622);
var inst_14625 = cljs.core.PersistentVector.EMPTY;
var inst_14626 = inst_14621;
var inst_14627 = inst_14625;
var state_14669__$1 = (function (){var statearr_14672 = state_14669;
(statearr_14672[(13)] = inst_14624);

(statearr_14672[(14)] = inst_14627);

(statearr_14672[(15)] = inst_14626);

(statearr_14672[(16)] = inst_14623);

return statearr_14672;
})();
var statearr_14673_14691 = state_14669__$1;
(statearr_14673_14691[(2)] = null);

(statearr_14673_14691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14670 === (4))){
var inst_14633 = (state_14669[(8)]);
var inst_14636 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_14633);
var state_14669__$1 = state_14669;
if(inst_14636){
var statearr_14674_14692 = state_14669__$1;
(statearr_14674_14692[(1)] = (7));

} else {
var statearr_14675_14693 = state_14669__$1;
(statearr_14675_14693[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14670 === (6))){
var inst_14665 = (state_14669[(2)]);
var state_14669__$1 = state_14669;
var statearr_14676_14694 = state_14669__$1;
(statearr_14676_14694[(2)] = inst_14665);

(statearr_14676_14694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14670 === (3))){
var inst_14667 = (state_14669[(2)]);
var state_14669__$1 = state_14669;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14669__$1,inst_14667);
} else {
if((state_val_14670 === (2))){
var inst_14626 = (state_14669[(15)]);
var inst_14633 = (state_14669[(8)]);
var inst_14632 = cljs.core.seq.call(null,inst_14626);
var inst_14633__$1 = cljs.core.first.call(null,inst_14632);
var inst_14634 = cljs.core.next.call(null,inst_14632);
var state_14669__$1 = (function (){var statearr_14677 = state_14669;
(statearr_14677[(8)] = inst_14633__$1);

(statearr_14677[(17)] = inst_14634);

return statearr_14677;
})();
if(cljs.core.truth_(inst_14633__$1)){
var statearr_14678_14695 = state_14669__$1;
(statearr_14678_14695[(1)] = (4));

} else {
var statearr_14679_14696 = state_14669__$1;
(statearr_14679_14696[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14670 === (9))){
var inst_14662 = (state_14669[(2)]);
var state_14669__$1 = state_14669;
var statearr_14680_14697 = state_14669__$1;
(statearr_14680_14697[(2)] = inst_14662);

(statearr_14680_14697[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14670 === (5))){
var inst_14627 = (state_14669[(14)]);
var state_14669__$1 = state_14669;
var statearr_14681_14698 = state_14669__$1;
(statearr_14681_14698[(2)] = inst_14627);

(statearr_14681_14698[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14670 === (10))){
var inst_14627 = (state_14669[(14)]);
var inst_14642 = (state_14669[(9)]);
var inst_14643 = (state_14669[(7)]);
var inst_14646 = (state_14669[(10)]);
var inst_14647 = (state_14669[(11)]);
var inst_14634 = (state_14669[(17)]);
var inst_14645 = (state_14669[(12)]);
var inst_14650 = (state_14669[(2)]);
var inst_14651 = fluree.db.util.async.throw_err.call(null,inst_14650);
var inst_14652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14653 = [inst_14642,inst_14643,inst_14651,inst_14645,inst_14646,inst_14647];
var inst_14654 = (new cljs.core.PersistentVector(null,6,(5),inst_14652,inst_14653,null));
var inst_14655 = fluree.db.flake.parts__GT_Flake.call(null,inst_14654);
var inst_14656 = cljs.core.conj.call(null,inst_14627,inst_14655);
var inst_14626 = inst_14634;
var inst_14627__$1 = inst_14656;
var state_14669__$1 = (function (){var statearr_14682 = state_14669;
(statearr_14682[(14)] = inst_14627__$1);

(statearr_14682[(15)] = inst_14626);

return statearr_14682;
})();
var statearr_14683_14699 = state_14669__$1;
(statearr_14683_14699[(2)] = null);

(statearr_14683_14699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14670 === (8))){
var inst_14627 = (state_14669[(14)]);
var inst_14633 = (state_14669[(8)]);
var inst_14634 = (state_14669[(17)]);
var inst_14659 = cljs.core.conj.call(null,inst_14627,inst_14633);
var inst_14626 = inst_14634;
var inst_14627__$1 = inst_14659;
var state_14669__$1 = (function (){var statearr_14684 = state_14669;
(statearr_14684[(14)] = inst_14627__$1);

(statearr_14684[(15)] = inst_14626);

return statearr_14684;
})();
var statearr_14685_14700 = state_14669__$1;
(statearr_14685_14700[(2)] = null);

(statearr_14685_14700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0 = (function (){
var statearr_14686 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14686[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__);

(statearr_14686[(1)] = (1));

return statearr_14686;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1 = (function (state_14669){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_14669);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14687){var ex__2730__auto__ = e14687;
var statearr_14688_14701 = state_14669;
(statearr_14688_14701[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_14669[(4)]))){
var statearr_14689_14702 = state_14669;
(statearr_14689_14702[(1)] = cljs.core.first.call(null,(state_14669[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14703 = state_14669;
state_14669 = G__14703;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__ = function(state_14669){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1.call(this,state_14669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14690 = f__2750__auto__.call(null);
(statearr_14690[(6)] = c__2749__auto__);

return statearr_14690;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__14705 = arguments.length;
switch (G__14705) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14887){
var state_val_14888 = (state_14887[(1)]);
if((state_val_14888 === (65))){
var inst_14756 = (state_14887[(7)]);
var state_14887__$1 = state_14887;
if(cljs.core.truth_(inst_14756)){
var statearr_14889_14993 = state_14887__$1;
(statearr_14889_14993[(1)] = (68));

} else {
var statearr_14890_14994 = state_14887__$1;
(statearr_14890_14994[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (70))){
var inst_14866 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
var statearr_14891_14995 = state_14887__$1;
(statearr_14891_14995[(2)] = inst_14866);

(statearr_14891_14995[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (62))){
var inst_14832 = (state_14887[(2)]);
var inst_14833 = fluree.db.util.async.throw_err.call(null,inst_14832);
var inst_14834 = cljs.core.take.call(null,(1),inst_14833);
var state_14887__$1 = state_14887;
var statearr_14892_14996 = state_14887__$1;
(statearr_14892_14996[(2)] = inst_14834);

(statearr_14892_14996[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (74))){
var inst_14882 = (state_14887[(2)]);
var _ = (function (){var statearr_14893 = state_14887;
(statearr_14893[(4)] = cljs.core.rest.call(null,(state_14887[(4)])));

return statearr_14893;
})();
var state_14887__$1 = state_14887;
var statearr_14894_14997 = state_14887__$1;
(statearr_14894_14997[(2)] = inst_14882);

(statearr_14894_14997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (7))){
var state_14887__$1 = state_14887;
var statearr_14895_14998 = state_14887__$1;
(statearr_14895_14998[(2)] = false);

(statearr_14895_14998[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (59))){
var inst_14756 = (state_14887[(7)]);
var inst_14826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14827 = [inst_14756];
var inst_14828 = (new cljs.core.PersistentVector(null,1,(5),inst_14826,inst_14827,null));
var inst_14829 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_14830 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14828,inst_14829);
var state_14887__$1 = state_14887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14887__$1,(62),inst_14830);
} else {
if((state_val_14888 === (20))){
var state_14887__$1 = state_14887;
var statearr_14896_14999 = state_14887__$1;
(statearr_14896_14999[(2)] = null);

(statearr_14896_14999[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (72))){
var inst_14874 = (state_14887[(8)]);
var inst_14876 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_14874);
var state_14887__$1 = state_14887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14887__$1,(75),inst_14876);
} else {
if((state_val_14888 === (58))){
var inst_14824 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
if(cljs.core.truth_(inst_14824)){
var statearr_14897_15000 = state_14887__$1;
(statearr_14897_15000[(1)] = (59));

} else {
var statearr_14898_15001 = state_14887__$1;
(statearr_14898_15001[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (60))){
var inst_14717 = (state_14887[(9)]);
var inst_14719 = (state_14887[(10)]);
var inst_14818 = (state_14887[(11)]);
var inst_14716 = (state_14887[(12)]);
var inst_14836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14837 = [inst_14717,inst_14716,null,inst_14719];
var inst_14838 = (new cljs.core.PersistentVector(null,4,(5),inst_14836,inst_14837,null));
var inst_14839 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_14818);
var inst_14840 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14838,inst_14839);
var state_14887__$1 = state_14887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14887__$1,(63),inst_14840);
} else {
if((state_val_14888 === (27))){
var inst_14717 = (state_14887[(9)]);
var inst_14756 = (state_14887[(7)]);
var inst_14719 = (state_14887[(10)]);
var inst_14716 = (state_14887[(12)]);
var inst_14768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14769 = [inst_14716,inst_14717,inst_14756,inst_14719];
var inst_14770 = (new cljs.core.PersistentVector(null,4,(5),inst_14768,inst_14769,null));
var inst_14771 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14770,opts);
var state_14887__$1 = state_14887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14887__$1,(30),inst_14771);
} else {
if((state_val_14888 === (1))){
var state_14887__$1 = state_14887;
var statearr_14899_15002 = state_14887__$1;
(statearr_14899_15002[(2)] = null);

(statearr_14899_15002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (69))){
var state_14887__$1 = state_14887;
var statearr_14900_15003 = state_14887__$1;
(statearr_14900_15003[(2)] = null);

(statearr_14900_15003[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (24))){
var inst_14717 = (state_14887[(9)]);
var state_14887__$1 = state_14887;
if(cljs.core.truth_(inst_14717)){
var statearr_14901_15004 = state_14887__$1;
(statearr_14901_15004[(1)] = (31));

} else {
var statearr_14902_15005 = state_14887__$1;
(statearr_14902_15005[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (55))){
var inst_14819 = (state_14887[(13)]);
var inst_14717 = (state_14887[(9)]);
var inst_14818 = (state_14887[(2)]);
var inst_14819__$1 = cljs.core._EQ_.call(null,"_id",inst_14717);
var state_14887__$1 = (function (){var statearr_14903 = state_14887;
(statearr_14903[(13)] = inst_14819__$1);

(statearr_14903[(11)] = inst_14818);

return statearr_14903;
})();
if(inst_14819__$1){
var statearr_14904_15006 = state_14887__$1;
(statearr_14904_15006[(1)] = (56));

} else {
var statearr_14905_15007 = state_14887__$1;
(statearr_14905_15007[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (39))){
var inst_14786 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
var statearr_14906_15008 = state_14887__$1;
(statearr_14906_15008[(2)] = inst_14786);

(statearr_14906_15008[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (46))){
var inst_14810 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
if(cljs.core.truth_(inst_14810)){
var statearr_14907_15009 = state_14887__$1;
(statearr_14907_15009[(1)] = (50));

} else {
var statearr_14908_15010 = state_14887__$1;
(statearr_14908_15010[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (4))){
var inst_14706 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
var statearr_14909_15011 = state_14887__$1;
(statearr_14909_15011[(2)] = inst_14706);

(statearr_14909_15011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (54))){
var inst_14726 = (state_14887[(14)]);
var inst_14715 = (state_14887[(15)]);
var inst_14731 = (state_14887[(16)]);
var inst_14812 = (state_14887[(17)]);
var inst_14717 = (state_14887[(9)]);
var inst_14720 = (state_14887[(18)]);
var inst_14756 = (state_14887[(7)]);
var inst_14719 = (state_14887[(10)]);
var inst_14716 = (state_14887[(12)]);
var inst_14816 = (function (){var t = inst_14719;
var temp__5802__auto__ = inst_14812;
var p = inst_14717;
var idx_predicate_QMARK_ = inst_14720;
var o = inst_14756;
var vec__14712 = inst_14715;
var tag_predicate_QMARK_ = inst_14726;
var s = inst_14716;
var o_coerce_QMARK_ = inst_14731;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_14887__$1 = state_14887;
var statearr_14910_15012 = state_14887__$1;
(statearr_14910_15012[(2)] = inst_14816);

(statearr_14910_15012[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (15))){
var inst_14718 = (state_14887[(19)]);
var inst_14737 = fluree.db.dbproto._tag_id.call(null,db,inst_14718);
var state_14887__$1 = state_14887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14887__$1,(18),inst_14737);
} else {
if((state_val_14888 === (48))){
var inst_14803 = (state_14887[(20)]);
var state_14887__$1 = state_14887;
var statearr_14911_15013 = state_14887__$1;
(statearr_14911_15013[(2)] = inst_14803);

(statearr_14911_15013[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (50))){
var inst_14812 = (state_14887[(17)]);
var inst_14812__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_14887__$1 = (function (){var statearr_14912 = state_14887;
(statearr_14912[(17)] = inst_14812__$1);

return statearr_14912;
})();
if(cljs.core.truth_(inst_14812__$1)){
var statearr_14913_15014 = state_14887__$1;
(statearr_14913_15014[(1)] = (53));

} else {
var statearr_14914_15015 = state_14887__$1;
(statearr_14914_15015[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (75))){
var inst_14878 = (state_14887[(2)]);
var inst_14879 = fluree.db.util.async.throw_err.call(null,inst_14878);
var state_14887__$1 = state_14887;
var statearr_14915_15016 = state_14887__$1;
(statearr_14915_15016[(2)] = inst_14879);

(statearr_14915_15016[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (21))){
var inst_14752 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
var statearr_14916_15017 = state_14887__$1;
(statearr_14916_15017[(2)] = inst_14752);

(statearr_14916_15017[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (31))){
var inst_14779 = (state_14887[(21)]);
var inst_14756 = (state_14887[(7)]);
var inst_14779__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_14756);
var state_14887__$1 = (function (){var statearr_14917 = state_14887;
(statearr_14917[(21)] = inst_14779__$1);

return statearr_14917;
})();
if(inst_14779__$1){
var statearr_14918_15018 = state_14887__$1;
(statearr_14918_15018[(1)] = (34));

} else {
var statearr_14919_15019 = state_14887__$1;
(statearr_14919_15019[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (32))){
var inst_14717 = (state_14887[(9)]);
var state_14887__$1 = state_14887;
var statearr_14920_15020 = state_14887__$1;
(statearr_14920_15020[(2)] = inst_14717);

(statearr_14920_15020[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (40))){
var inst_14717 = (state_14887[(9)]);
var inst_14756 = (state_14887[(7)]);
var inst_14719 = (state_14887[(10)]);
var inst_14716 = (state_14887[(12)]);
var inst_14794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14795 = [inst_14717,inst_14756,inst_14716,inst_14719];
var inst_14796 = (new cljs.core.PersistentVector(null,4,(5),inst_14794,inst_14795,null));
var inst_14797 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_14796,opts);
var state_14887__$1 = state_14887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14887__$1,(43),inst_14797);
} else {
if((state_val_14888 === (56))){
var inst_14756 = (state_14887[(7)]);
var inst_14821 = cljs.core.int_QMARK_.call(null,inst_14756);
var state_14887__$1 = state_14887;
var statearr_14921_15021 = state_14887__$1;
(statearr_14921_15021[(2)] = inst_14821);

(statearr_14921_15021[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (33))){
var inst_14792 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
if(cljs.core.truth_(inst_14792)){
var statearr_14922_15022 = state_14887__$1;
(statearr_14922_15022[(1)] = (40));

} else {
var statearr_14923_15023 = state_14887__$1;
(statearr_14923_15023[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (13))){
var inst_14718 = (state_14887[(19)]);
var inst_14735 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_14718);
var state_14887__$1 = state_14887;
if(cljs.core.truth_(inst_14735)){
var statearr_14924_15024 = state_14887__$1;
(statearr_14924_15024[(1)] = (15));

} else {
var statearr_14925_15025 = state_14887__$1;
(statearr_14925_15025[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (22))){
var inst_14748 = (state_14887[(2)]);
var inst_14749 = fluree.db.util.async.throw_err.call(null,inst_14748);
var state_14887__$1 = state_14887;
var statearr_14926_15026 = state_14887__$1;
(statearr_14926_15026[(2)] = inst_14749);

(statearr_14926_15026[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (36))){
var inst_14789 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
var statearr_14927_15027 = state_14887__$1;
(statearr_14927_15027[(2)] = inst_14789);

(statearr_14927_15027[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (41))){
var inst_14717 = (state_14887[(9)]);
var state_14887__$1 = state_14887;
if(cljs.core.truth_(inst_14717)){
var statearr_14928_15028 = state_14887__$1;
(statearr_14928_15028[(1)] = (44));

} else {
var statearr_14929_15029 = state_14887__$1;
(statearr_14929_15029[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (43))){
var inst_14799 = (state_14887[(2)]);
var inst_14800 = fluree.db.util.async.throw_err.call(null,inst_14799);
var state_14887__$1 = state_14887;
var statearr_14930_15030 = state_14887__$1;
(statearr_14930_15030[(2)] = inst_14800);

(statearr_14930_15030[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (61))){
var inst_14845 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
var statearr_14931_15031 = state_14887__$1;
(statearr_14931_15031[(2)] = inst_14845);

(statearr_14931_15031[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (29))){
var inst_14765 = (state_14887[(2)]);
var inst_14766 = fluree.db.util.async.throw_err.call(null,inst_14765);
var state_14887__$1 = state_14887;
var statearr_14932_15032 = state_14887__$1;
(statearr_14932_15032[(2)] = inst_14766);

(statearr_14932_15032[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (44))){
var inst_14803 = (state_14887[(20)]);
var inst_14720 = (state_14887[(18)]);
var inst_14803__$1 = cljs.core.not.call(null,inst_14720);
var state_14887__$1 = (function (){var statearr_14933 = state_14887;
(statearr_14933[(20)] = inst_14803__$1);

return statearr_14933;
})();
if(inst_14803__$1){
var statearr_14934_15033 = state_14887__$1;
(statearr_14934_15033[(1)] = (47));

} else {
var statearr_14935_15034 = state_14887__$1;
(statearr_14935_15034[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (6))){
var inst_14717 = (state_14887[(9)]);
var inst_14722 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_14717);
var inst_14723 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_14722);
var state_14887__$1 = state_14887;
var statearr_14936_15035 = state_14887__$1;
(statearr_14936_15035[(2)] = inst_14723);

(statearr_14936_15035[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (28))){
var inst_14776 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
var statearr_14937_15036 = state_14887__$1;
(statearr_14937_15036[(2)] = inst_14776);

(statearr_14937_15036[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (64))){
var inst_14717 = (state_14887[(9)]);
var inst_14756 = (state_14887[(7)]);
var inst_14719 = (state_14887[(10)]);
var inst_14716 = (state_14887[(12)]);
var inst_14848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14849 = [inst_14717,inst_14716,inst_14756,inst_14719];
var inst_14850 = (new cljs.core.PersistentVector(null,4,(5),inst_14848,inst_14849,null));
var inst_14851 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14850,opts);
var state_14887__$1 = state_14887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14887__$1,(67),inst_14851);
} else {
if((state_val_14888 === (51))){
var inst_14717 = (state_14887[(9)]);
var state_14887__$1 = state_14887;
if(cljs.core.truth_(inst_14717)){
var statearr_14938_15037 = state_14887__$1;
(statearr_14938_15037[(1)] = (64));

} else {
var statearr_14939_15038 = state_14887__$1;
(statearr_14939_15038[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (25))){
var inst_14726 = (state_14887[(14)]);
var inst_14874 = (state_14887[(2)]);
var state_14887__$1 = (function (){var statearr_14940 = state_14887;
(statearr_14940[(8)] = inst_14874);

return statearr_14940;
})();
if(cljs.core.truth_(inst_14726)){
var statearr_14941_15039 = state_14887__$1;
(statearr_14941_15039[(1)] = (72));

} else {
var statearr_14942_15040 = state_14887__$1;
(statearr_14942_15040[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (34))){
var inst_14720 = (state_14887[(18)]);
var state_14887__$1 = state_14887;
if(cljs.core.truth_(inst_14720)){
var statearr_14943_15041 = state_14887__$1;
(statearr_14943_15041[(1)] = (37));

} else {
var statearr_14944_15042 = state_14887__$1;
(statearr_14944_15042[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (17))){
var inst_14754 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
var statearr_14945_15043 = state_14887__$1;
(statearr_14945_15043[(2)] = inst_14754);

(statearr_14945_15043[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (3))){
var inst_14885 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14887__$1,inst_14885);
} else {
if((state_val_14888 === (12))){
var inst_14718 = (state_14887[(19)]);
var state_14887__$1 = state_14887;
var statearr_14946_15044 = state_14887__$1;
(statearr_14946_15044[(2)] = inst_14718);

(statearr_14946_15044[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (2))){
var inst_14715 = (state_14887[(15)]);
var inst_14717 = (state_14887[(9)]);
var _ = (function (){var statearr_14947 = state_14887;
(statearr_14947[(4)] = cljs.core.cons.call(null,(5),(state_14887[(4)])));

return statearr_14947;
})();
var inst_14715__$1 = fparts;
var inst_14716 = cljs.core.nth.call(null,inst_14715__$1,(0),null);
var inst_14717__$1 = cljs.core.nth.call(null,inst_14715__$1,(1),null);
var inst_14718 = cljs.core.nth.call(null,inst_14715__$1,(2),null);
var inst_14719 = cljs.core.nth.call(null,inst_14715__$1,(3),null);
var inst_14720 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_14717__$1);
var state_14887__$1 = (function (){var statearr_14948 = state_14887;
(statearr_14948[(15)] = inst_14715__$1);

(statearr_14948[(9)] = inst_14717__$1);

(statearr_14948[(19)] = inst_14718);

(statearr_14948[(18)] = inst_14720);

(statearr_14948[(10)] = inst_14719);

(statearr_14948[(12)] = inst_14716);

return statearr_14948;
})();
if(cljs.core.truth_(inst_14717__$1)){
var statearr_14949_15045 = state_14887__$1;
(statearr_14949_15045[(1)] = (6));

} else {
var statearr_14950_15046 = state_14887__$1;
(statearr_14950_15046[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (66))){
var inst_14868 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
var statearr_14951_15047 = state_14887__$1;
(statearr_14951_15047[(2)] = inst_14868);

(statearr_14951_15047[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (23))){
var inst_14717 = (state_14887[(9)]);
var inst_14758 = cljs.core._EQ_.call(null,"_id",inst_14717);
var state_14887__$1 = state_14887;
if(inst_14758){
var statearr_14952_15048 = state_14887__$1;
(statearr_14952_15048[(1)] = (26));

} else {
var statearr_14953_15049 = state_14887__$1;
(statearr_14953_15049[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (47))){
var inst_14756 = (state_14887[(7)]);
var state_14887__$1 = state_14887;
var statearr_14954_15050 = state_14887__$1;
(statearr_14954_15050[(2)] = inst_14756);

(statearr_14954_15050[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (35))){
var inst_14779 = (state_14887[(21)]);
var state_14887__$1 = state_14887;
var statearr_14955_15051 = state_14887__$1;
(statearr_14955_15051[(2)] = inst_14779);

(statearr_14955_15051[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (19))){
var inst_14717 = (state_14887[(9)]);
var inst_14718 = (state_14887[(19)]);
var inst_14744 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_14717);
var inst_14745 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14744),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14718)].join('');
var inst_14746 = fluree.db.dbproto._tag_id.call(null,db,inst_14745);
var state_14887__$1 = state_14887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14887__$1,(22),inst_14746);
} else {
if((state_val_14888 === (57))){
var inst_14819 = (state_14887[(13)]);
var state_14887__$1 = state_14887;
var statearr_14956_15052 = state_14887__$1;
(statearr_14956_15052[(2)] = inst_14819);

(statearr_14956_15052[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (68))){
var inst_14717 = (state_14887[(9)]);
var inst_14756 = (state_14887[(7)]);
var inst_14719 = (state_14887[(10)]);
var inst_14716 = (state_14887[(12)]);
var inst_14857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14858 = [inst_14756,inst_14717,inst_14716,inst_14719];
var inst_14859 = (new cljs.core.PersistentVector(null,4,(5),inst_14857,inst_14858,null));
var inst_14860 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_14859,opts);
var state_14887__$1 = state_14887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14887__$1,(71),inst_14860);
} else {
if((state_val_14888 === (11))){
var inst_14731 = (state_14887[(16)]);
var inst_14731__$1 = (state_14887[(2)]);
var inst_14732 = cljs.core.not.call(null,inst_14731__$1);
var state_14887__$1 = (function (){var statearr_14958 = state_14887;
(statearr_14958[(16)] = inst_14731__$1);

return statearr_14958;
})();
if(inst_14732){
var statearr_14959_15053 = state_14887__$1;
(statearr_14959_15053[(1)] = (12));

} else {
var statearr_14960_15054 = state_14887__$1;
(statearr_14960_15054[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (9))){
var inst_14718 = (state_14887[(19)]);
var inst_14728 = typeof inst_14718 === 'string';
var state_14887__$1 = state_14887;
var statearr_14961_15055 = state_14887__$1;
(statearr_14961_15055[(2)] = inst_14728);

(statearr_14961_15055[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (5))){
var _ = (function (){var statearr_14962 = state_14887;
(statearr_14962[(4)] = cljs.core.rest.call(null,(state_14887[(4)])));

return statearr_14962;
})();
var state_14887__$1 = state_14887;
var ex14957 = (state_14887__$1[(2)]);
var statearr_14963_15056 = state_14887__$1;
(statearr_14963_15056[(5)] = ex14957);


if((ex14957 instanceof Error)){
var statearr_14964_15057 = state_14887__$1;
(statearr_14964_15057[(1)] = (4));

(statearr_14964_15057[(5)] = null);

} else {
throw ex14957;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (14))){
var inst_14716 = (state_14887[(12)]);
var inst_14756 = (state_14887[(2)]);
var state_14887__$1 = (function (){var statearr_14965 = state_14887;
(statearr_14965[(7)] = inst_14756);

return statearr_14965;
})();
if(cljs.core.truth_(inst_14716)){
var statearr_14966_15058 = state_14887__$1;
(statearr_14966_15058[(1)] = (23));

} else {
var statearr_14967_15059 = state_14887__$1;
(statearr_14967_15059[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (45))){
var inst_14717 = (state_14887[(9)]);
var state_14887__$1 = state_14887;
var statearr_14968_15060 = state_14887__$1;
(statearr_14968_15060[(2)] = inst_14717);

(statearr_14968_15060[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (53))){
var inst_14726 = (state_14887[(14)]);
var inst_14715 = (state_14887[(15)]);
var inst_14731 = (state_14887[(16)]);
var inst_14812 = (state_14887[(17)]);
var inst_14717 = (state_14887[(9)]);
var inst_14720 = (state_14887[(18)]);
var inst_14756 = (state_14887[(7)]);
var inst_14719 = (state_14887[(10)]);
var inst_14716 = (state_14887[(12)]);
var inst_14814 = (function (){var obj_fn = inst_14812;
var t = inst_14719;
var temp__5802__auto__ = inst_14812;
var p = inst_14717;
var idx_predicate_QMARK_ = inst_14720;
var o = inst_14756;
var vec__14712 = inst_14715;
var tag_predicate_QMARK_ = inst_14726;
var s = inst_14716;
var o_coerce_QMARK_ = inst_14731;
return (function (x){
var and__4251__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__4251__auto__;
}
});
})();
var state_14887__$1 = state_14887;
var statearr_14969_15061 = state_14887__$1;
(statearr_14969_15061[(2)] = inst_14814);

(statearr_14969_15061[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (26))){
var inst_14719 = (state_14887[(10)]);
var inst_14716 = (state_14887[(12)]);
var inst_14760 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14761 = [inst_14716,null,null,inst_14719];
var inst_14762 = (new cljs.core.PersistentVector(null,4,(5),inst_14760,inst_14761,null));
var inst_14763 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14762,opts);
var state_14887__$1 = state_14887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14887__$1,(29),inst_14763);
} else {
if((state_val_14888 === (16))){
var inst_14718 = (state_14887[(19)]);
var inst_14742 = typeof inst_14718 === 'string';
var state_14887__$1 = state_14887;
if(cljs.core.truth_(inst_14742)){
var statearr_14970_15062 = state_14887__$1;
(statearr_14970_15062[(1)] = (19));

} else {
var statearr_14971_15063 = state_14887__$1;
(statearr_14971_15063[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (38))){
var inst_14720 = (state_14887[(18)]);
var state_14887__$1 = state_14887;
var statearr_14972_15064 = state_14887__$1;
(statearr_14972_15064[(2)] = inst_14720);

(statearr_14972_15064[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (30))){
var inst_14773 = (state_14887[(2)]);
var inst_14774 = fluree.db.util.async.throw_err.call(null,inst_14773);
var state_14887__$1 = state_14887;
var statearr_14973_15065 = state_14887__$1;
(statearr_14973_15065[(2)] = inst_14774);

(statearr_14973_15065[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (73))){
var inst_14874 = (state_14887[(8)]);
var state_14887__$1 = state_14887;
var statearr_14974_15066 = state_14887__$1;
(statearr_14974_15066[(2)] = inst_14874);

(statearr_14974_15066[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (10))){
var inst_14726 = (state_14887[(14)]);
var state_14887__$1 = state_14887;
var statearr_14975_15067 = state_14887__$1;
(statearr_14975_15067[(2)] = inst_14726);

(statearr_14975_15067[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (18))){
var inst_14739 = (state_14887[(2)]);
var inst_14740 = fluree.db.util.async.throw_err.call(null,inst_14739);
var state_14887__$1 = state_14887;
var statearr_14976_15068 = state_14887__$1;
(statearr_14976_15068[(2)] = inst_14740);

(statearr_14976_15068[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (52))){
var inst_14870 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
var statearr_14977_15069 = state_14887__$1;
(statearr_14977_15069[(2)] = inst_14870);

(statearr_14977_15069[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (67))){
var inst_14853 = (state_14887[(2)]);
var inst_14854 = fluree.db.util.async.throw_err.call(null,inst_14853);
var state_14887__$1 = state_14887;
var statearr_14978_15070 = state_14887__$1;
(statearr_14978_15070[(2)] = inst_14854);

(statearr_14978_15070[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (71))){
var inst_14862 = (state_14887[(2)]);
var inst_14863 = fluree.db.util.async.throw_err.call(null,inst_14862);
var state_14887__$1 = state_14887;
var statearr_14979_15071 = state_14887__$1;
(statearr_14979_15071[(2)] = inst_14863);

(statearr_14979_15071[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (42))){
var inst_14872 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
var statearr_14980_15072 = state_14887__$1;
(statearr_14980_15072[(2)] = inst_14872);

(statearr_14980_15072[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (37))){
var inst_14756 = (state_14887[(7)]);
var inst_14782 = cljs.core.fn_QMARK_.call(null,inst_14756);
var inst_14783 = (!(inst_14782));
var state_14887__$1 = state_14887;
var statearr_14981_15073 = state_14887__$1;
(statearr_14981_15073[(2)] = inst_14783);

(statearr_14981_15073[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (63))){
var inst_14842 = (state_14887[(2)]);
var inst_14843 = fluree.db.util.async.throw_err.call(null,inst_14842);
var state_14887__$1 = state_14887;
var statearr_14982_15074 = state_14887__$1;
(statearr_14982_15074[(2)] = inst_14843);

(statearr_14982_15074[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (8))){
var inst_14726 = (state_14887[(14)]);
var inst_14726__$1 = (state_14887[(2)]);
var state_14887__$1 = (function (){var statearr_14983 = state_14887;
(statearr_14983[(14)] = inst_14726__$1);

return statearr_14983;
})();
if(cljs.core.truth_(inst_14726__$1)){
var statearr_14984_15075 = state_14887__$1;
(statearr_14984_15075[(1)] = (9));

} else {
var statearr_14985_15076 = state_14887__$1;
(statearr_14985_15076[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14888 === (49))){
var inst_14807 = (state_14887[(2)]);
var state_14887__$1 = state_14887;
var statearr_14986_15077 = state_14887__$1;
(statearr_14986_15077[(2)] = inst_14807);

(statearr_14986_15077[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_14987 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14987[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_14987[(1)] = (1));

return statearr_14987;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_14887){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_14887);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14988){var ex__2730__auto__ = e14988;
var statearr_14989_15078 = state_14887;
(statearr_14989_15078[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_14887[(4)]))){
var statearr_14990_15079 = state_14887;
(statearr_14990_15079[(1)] = cljs.core.first.call(null,(state_14887[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15080 = state_14887;
state_14887 = G__15080;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_14887){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_14887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14991 = f__2750__auto__.call(null);
(statearr_14991[(6)] = c__2749__auto__);

return statearr_14991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15082 = arguments.length;
switch (G__15082) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15117){
var state_val_15118 = (state_15117[(1)]);
if((state_val_15118 === (7))){
var inst_15104 = cljs.core.pr_str.call(null,name);
var inst_15105 = ["Invalid collection name: ",inst_15104].join('');
var inst_15106 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15107 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15108 = cljs.core.PersistentHashMap.fromArrays(inst_15106,inst_15107);
var inst_15109 = cljs.core.ex_info.call(null,inst_15105,inst_15108);
var inst_15110 = (function(){throw inst_15109})();
var state_15117__$1 = state_15117;
var statearr_15119_15139 = state_15117__$1;
(statearr_15119_15139[(2)] = inst_15110);

(statearr_15119_15139[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15118 === (1))){
var state_15117__$1 = state_15117;
var statearr_15120_15140 = state_15117__$1;
(statearr_15120_15140[(2)] = null);

(statearr_15120_15140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15118 === (4))){
var inst_15083 = (state_15117[(2)]);
var state_15117__$1 = state_15117;
var statearr_15121_15141 = state_15117__$1;
(statearr_15121_15141[(2)] = inst_15083);

(statearr_15121_15141[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15118 === (6))){
var inst_15089 = (state_15117[(7)]);
var inst_15091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15092 = fluree.db.flake.max_subject_id.call(null,inst_15089);
var inst_15093 = [inst_15092];
var inst_15094 = (new cljs.core.PersistentVector(null,1,(5),inst_15091,inst_15093,null));
var inst_15095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15096 = fluree.db.flake.min_subject_id.call(null,inst_15089);
var inst_15097 = [inst_15096];
var inst_15098 = (new cljs.core.PersistentVector(null,1,(5),inst_15095,inst_15097,null));
var inst_15099 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15094,cljs.core._LT__EQ_,inst_15098,opts);
var state_15117__$1 = state_15117;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15117__$1,(9),inst_15099);
} else {
if((state_val_15118 === (3))){
var inst_15115 = (state_15117[(2)]);
var state_15117__$1 = state_15117;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15117__$1,inst_15115);
} else {
if((state_val_15118 === (2))){
var inst_15089 = (state_15117[(7)]);
var _ = (function (){var statearr_15123 = state_15117;
(statearr_15123[(4)] = cljs.core.cons.call(null,(5),(state_15117[(4)])));

return statearr_15123;
})();
var inst_15089__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15117__$1 = (function (){var statearr_15124 = state_15117;
(statearr_15124[(7)] = inst_15089__$1);

return statearr_15124;
})();
if(cljs.core.truth_(inst_15089__$1)){
var statearr_15125_15142 = state_15117__$1;
(statearr_15125_15142[(1)] = (6));

} else {
var statearr_15126_15143 = state_15117__$1;
(statearr_15126_15143[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15118 === (9))){
var inst_15101 = (state_15117[(2)]);
var inst_15102 = fluree.db.util.async.throw_err.call(null,inst_15101);
var state_15117__$1 = state_15117;
var statearr_15127_15144 = state_15117__$1;
(statearr_15127_15144[(2)] = inst_15102);

(statearr_15127_15144[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15118 === (5))){
var _ = (function (){var statearr_15128 = state_15117;
(statearr_15128[(4)] = cljs.core.rest.call(null,(state_15117[(4)])));

return statearr_15128;
})();
var state_15117__$1 = state_15117;
var ex15122 = (state_15117__$1[(2)]);
var statearr_15129_15145 = state_15117__$1;
(statearr_15129_15145[(5)] = ex15122);


var statearr_15130_15146 = state_15117__$1;
(statearr_15130_15146[(1)] = (4));

(statearr_15130_15146[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15118 === (8))){
var inst_15112 = (state_15117[(2)]);
var _ = (function (){var statearr_15131 = state_15117;
(statearr_15131[(4)] = cljs.core.rest.call(null,(state_15117[(4)])));

return statearr_15131;
})();
var state_15117__$1 = state_15117;
var statearr_15132_15147 = state_15117__$1;
(statearr_15132_15147[(2)] = inst_15112);

(statearr_15132_15147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15133 = [null,null,null,null,null,null,null,null];
(statearr_15133[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15133[(1)] = (1));

return statearr_15133;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_15117){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_15117);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15134){var ex__2730__auto__ = e15134;
var statearr_15135_15148 = state_15117;
(statearr_15135_15148[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_15117[(4)]))){
var statearr_15136_15149 = state_15117;
(statearr_15136_15149[(1)] = cljs.core.first.call(null,(state_15117[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15150 = state_15117;
state_15117 = G__15150;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_15117){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_15117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15137 = f__2750__auto__.call(null);
(statearr_15137[(6)] = c__2749__auto__);

return statearr_15137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15154 = flakes;
var vec__15155 = G__15154;
var seq__15156 = cljs.core.seq.call(null,vec__15155);
var first__15157 = cljs.core.first.call(null,seq__15156);
var seq__15156__$1 = cljs.core.next.call(null,seq__15156);
var flake_SINGLEQUOTE_ = first__15157;
var r = seq__15156__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15154__$1 = G__15154;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15163 = G__15154__$1;
var seq__15164 = cljs.core.seq.call(null,vec__15163);
var first__15165 = cljs.core.first.call(null,seq__15164);
var seq__15164__$1 = cljs.core.next.call(null,seq__15164);
var flake_SINGLEQUOTE___$1 = first__15165;
var r__$1 = seq__15164__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = fluree.db.flake.o.call(null,flake_SINGLEQUOTE___$1);
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e15167){var e = e15167;
return null;
}})();
var map__15166 = cmd_map;
var map__15166__$1 = cljs.core.__destructure_map.call(null,map__15166);
var type = cljs.core.get.call(null,map__15166__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__15166__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__15166__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__15166__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__15166__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__15166__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15168 = r__$1;
var G__15169 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15154__$1 = G__15168;
result_STAR___$1 = G__15169;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15178 = blocks;
var vec__15179 = G__15178;
var seq__15180 = cljs.core.seq.call(null,vec__15179);
var first__15181 = cljs.core.first.call(null,seq__15180);
var seq__15180__$1 = cljs.core.next.call(null,seq__15180);
var block_SINGLEQUOTE_ = first__15181;
var r = seq__15180__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15178__$1 = G__15178;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15186 = G__15178__$1;
var seq__15187 = cljs.core.seq.call(null,vec__15186);
var first__15188 = cljs.core.first.call(null,seq__15187);
var seq__15187__$1 = cljs.core.next.call(null,seq__15187);
var block_SINGLEQUOTE___$1 = first__15188;
var r__$1 = seq__15187__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15189 = block_SINGLEQUOTE___$1;
var map__15189__$1 = cljs.core.__destructure_map.call(null,map__15189);
var block = cljs.core.get.call(null,map__15189__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__15189__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__15189__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__15178__$1,result_STAR___$1,map__15189,map__15189__$1,block,t,flakes,vec__15186,seq__15187,first__15188,seq__15187__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15178,vec__15179,seq__15180,first__15181,seq__15180__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15170_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15170_SHARP_),(2))){
return fluree.db.flake.o.call(null,p1__15170_SHARP_);
} else {
return null;
}
});})(G__15178__$1,result_STAR___$1,map__15189,map__15189__$1,block,t,flakes,vec__15186,seq__15187,first__15188,seq__15187__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15178,vec__15179,seq__15180,first__15181,seq__15180__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__15178__$1,result_STAR___$1,map__15189,map__15189__$1,block,t,flakes,prev_hash,vec__15186,seq__15187,first__15188,seq__15187__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15178,vec__15179,seq__15180,first__15181,seq__15180__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15171_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15171_SHARP_),(1))){
return fluree.db.flake.o.call(null,p1__15171_SHARP_);
} else {
return null;
}
});})(G__15178__$1,result_STAR___$1,map__15189,map__15189__$1,block,t,flakes,prev_hash,vec__15186,seq__15187,first__15188,seq__15187__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15178,vec__15179,seq__15180,first__15181,seq__15180__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__15178__$1,result_STAR___$1,map__15189,map__15189__$1,block,t,flakes,prev_hash,hash,vec__15186,seq__15187,first__15188,seq__15187__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15178,vec__15179,seq__15180,first__15181,seq__15180__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15172_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15172_SHARP_),(5))){
return fluree.db.flake.o.call(null,p1__15172_SHARP_);
} else {
return null;
}
});})(G__15178__$1,result_STAR___$1,map__15189,map__15189__$1,block,t,flakes,prev_hash,hash,vec__15186,seq__15187,first__15188,seq__15187__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15178,vec__15179,seq__15180,first__15181,seq__15180__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__15178__$1,result_STAR___$1,map__15189,map__15189__$1,block,t,flakes,prev_hash,hash,instant,vec__15186,seq__15187,first__15188,seq__15187__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15178,vec__15179,seq__15180,first__15181,seq__15180__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15173_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15173_SHARP_),(7))){
return fluree.db.flake.o.call(null,p1__15173_SHARP_);
} else {
return null;
}
});})(G__15178__$1,result_STAR___$1,map__15189,map__15189__$1,block,t,flakes,prev_hash,hash,instant,vec__15186,seq__15187,first__15188,seq__15187__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15178,vec__15179,seq__15180,first__15181,seq__15180__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__15178__$1,result_STAR___$1,map__15189,map__15189__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15186,seq__15187,first__15188,seq__15187__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15178,vec__15179,seq__15180,first__15181,seq__15180__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15174_SHARP_){
return cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15174_SHARP_),(106));
});})(G__15178__$1,result_STAR___$1,map__15189,map__15189__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15186,seq__15187,first__15188,seq__15187__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15178,vec__15179,seq__15180,first__15181,seq__15180__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__15190 = r__$1;
var G__15191 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15178__$1 = G__15190;
result_STAR___$1 = G__15191;
continue;
}
break;
}
});
